/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/format/DateFormat','sap/ui/model/FilterType','sap/ui/model/ListBinding','./CountMode','./Filter'],function(q,D,F,L,C,a){"use strict";var O=L.extend("sap.ui.model.odata.ODataListBinding",{constructor:function(m,p,c,s,f,P){L.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.bPendingChange=false;this.aKeys=[];this.bInitialized=false;this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;if(!this.oModel.getServiceMetadata()){var t=this,b=function(e){t._initSortersFilters();t.oModel.detachMetadataLoaded(b)};this.oModel.attachMetadataLoaded(this,b)}else{this._initSortersFilters()}var r=this.oModel._getObject(this.sPath,this.oContext);if(q.isArray(r)&&!s&&!f){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this.bDataAvailable=true}else{if(this.oModel.getServiceMetadata()){this.resetData()}}},metadata:{publicMethods:["getLength"]}});O.prototype.getContexts=function(s,l,t){this.bInitialized=true;this.iLastLength=l;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength}}if(!t){t=0}var b=true,c=this._getContexts(s,l),o={},S;S=this.calculateSection(s,l,t,c);b=c.length!=l&&!(this.bLengthFinal&&c.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&S.length>0&&(b||l<S.length)){this.loadData(S.startIndex,S.length);c.dataRequested=true}}if(this.bRefresh){if(this.bLengthFinal&&this.iLength==0){this.loadData(S.startIndex,S.length,true);c.dataRequested=true}this.bRefresh=false}else{for(var i=0;i<c.length;i++){o[c[i].getPath()]=c[i].getObject()}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){var d=this;var e=q.sap.arrayDiff(this.aLastContexts,c,function(f,n){return q.sap.equal(f&&d.oLastContextData&&d.oLastContextData[f.getPath()],n&&o&&o[n.getPath()])});c.diff=e}}this.iLastEndIndex=s+l;this.aLastContexts=c.slice(0);this.oLastContextData=q.extend(true,{},o)}return c};O.prototype._getContexts=function(s,l){var c=[],o,k;if(!s){s=0}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength}}for(var i=s;i<s+l;i++){k=this.aKeys[i];if(!k){break}o=this.oModel.getContext('/'+k);c.push(o)}return c};O.prototype.calculateSection=function(s,l,t,c){var b=false,S,d,p,P,r,o={},k;d=s;S=0;for(var i=s;i>=Math.max(s-t,0);i--){k=this.aKeys[i];if(!k){P=i+1;break}}for(var j=s+l;j<s+l+t;j++){k=this.aKeys[j];if(!k){p=j;break}}r=s-P;if(P&&s>t&&r<t){if(c.length!=l){d=s-t}else{d=P-t}S=t}if(d==s){d+=c.length}if(c.length!=l){S+=l-c.length}r=p-s-l;if(r==0){S+=t}if(p&&r<t&&r>0){if(d>s){d=p;S+=t}}if(this.bLengthFinal&&this.iLength<(S+d)){S=this.iLength-d}o.startIndex=d;o.length=S;return o};O.prototype.setContext=function(c){if(this.oContext!=c){this.oContext=c;if(this.isRelative()){this.oEntityType=this._getEntityType();if(this.bInitialized){var r=this.oModel._getObject(this.sPath,this.oContext);if(q.isArray(r)){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this._fireChange()}else{this.refresh()}}}}};O.prototype.loadData=function(s,l,p){var t=this,I=false;if(s||l){this.sRangeParams="$skip="+s+"&$top="+l;this.iStartIndex=s}else{s=this.iStartIndex}var P=[];if(this.sRangeParams){P.push(this.sRangeParams)}if(this.sSortParams){P.push(this.sSortParams)}if(this.sFilterParams){P.push(this.sFilterParams)}if(this.sCustomParams){P.push(this.sCustomParams)}if(!this.bLengthFinal&&(this.sCountMode==C.Inline||this.sCountMode==C.Both)){P.push("$inlinecount=allpages");I=true}function S(d){q.each(d.results,function(i,f){t.aKeys[s+i]=t.oModel._getKey(f)});if(I&&d.__count){t.iLength=parseInt(d.__count,10);t.bLengthFinal=true}if(t.iLength<s+d.results.length){t.iLength=s+d.results.length;t.bLengthFinal=false}if(d.results.length<l||l===undefined){t.iLength=s+d.results.length;t.bLengthFinal=true}if(s==0&&d.results.length==0){t.iLength=0;t.bLengthFinal=true}t.oRequestHandle=null;t.bPendingRequest=false;t.bNeedsUpdate=true}function c(){t.fireDataReceived()}function e(E){t.oRequestHandle=null;t.bPendingRequest=false;t.fireDataReceived()}function u(h){t.oRequestHandle=h}var b=this.sPath,o=this.oContext;if(this.isRelative()){b=this.oModel.resolve(b,o)}if(b){if(p){var U=this.oModel._createRequestUrl(b,P);this.fireDataRequested();this.oModel.fireRequestSent({url:U,method:"GET",async:true});setTimeout(function(){t.bNeedsUpdate=true;t.checkUpdate();t.oModel.fireRequestCompleted({url:U,method:"GET",async:true,success:true});t.fireDataReceived()},0)}else{this.bPendingRequest=true;this.fireDataRequested();this.oModel._loadData(b,P,S,e,false,u,c)}}};O.prototype.getLength=function(){return this.iLength};O.prototype._getLength=function(){var t=this;var p=[];if(this.sFilterParams){p.push(this.sFilterParams)}if(this.mParameters&&this.mParameters.custom){var c={custom:{}};q.each(this.mParameters.custom,function(s,v){c.custom[s]=v});p.push(this.oModel.createCustomParams(c))}function _(d){t.iLength=parseInt(d,10);t.bLengthFinal=true}function b(e){var E="Request for $count failed: "+e.message;if(e.response){E+=", "+e.response.statusCode+", "+e.response.statusText+", "+e.response.body}q.sap.log.warning(E)}var P=this.oModel.resolve(this.sPath,this.oContext);if(P){var u=this.oModel._createRequestUrl(P+"/$count",null,p);var r=this.oModel._createRequest(u,"GET",false);r.headers["Accept"]="text/plain";this.oModel._request(r,_,b,undefined,undefined,this.oModel.getServiceMetadata())}};O.prototype.refresh=function(f,c,e){var b=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){b=true}}if(c&&!b){q.each(this.aKeys,function(i,k){if(k in c){b=true;return false}})}if(!c&&!e){b=true}}if(f||b){this.abortPendingRequest();this.resetData();this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh})}};O.prototype._fireRefresh=function(A){this.bRefresh=true;this.fireEvent("refresh",A)};O.prototype.initialize=function(){if(this.bDataAvailable){this._fireChange({reason:sap.ui.model.ChangeReason.Change})}else{this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh})}};O.prototype.checkUpdate=function(f,c){var b=this.sChangeReason?this.sChangeReason:sap.ui.model.ChangeReason.Change,d=false,l,o,t=this;if(!f&&!this.bNeedsUpdate){if(c){q.each(this.aKeys,function(i,k){if(k in c){d=true;return false}})}else{d=true}if(d&&this.aLastContexts){d=false;var e=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!=e.length){d=true}else{q.each(this.aLastContexts,function(i,g){l=t.oLastContextData[g.getPath()];o=e[i].getObject();if(!q.sap.equal(l,o,3,true)){d=true;return false}})}}}if(f||d||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:b})}this.sChangeReason=undefined};O.prototype.resetData=function(){this.aKeys=[];this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;if(this.oModel.isCountSupported()&&(this.sCountMode==C.Request||this.sCountMode==C.Both)){this._getLength()}};O.prototype.abortPendingRequest=function(){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false}};O.prototype.sort=function(s){if(s instanceof sap.ui.model.Sorter){s=[s]}this.aSorters=s;this.createSortParams(s);this.abortPendingRequest();this.aKeys=[];if(this.bInitialized){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false}this.sChangeReason=sap.ui.model.ChangeReason.Sort;this._fireRefresh({reason:this.sChangeReason});this._fireSort({sorter:s})}return this};O.prototype.createSortParams=function(s){if(!s||s.length==0){return}this.sSortParams="$orderby=";for(var i=0;i<s.length;i++){var S=s[i];if(S instanceof sap.ui.model.Sorter){this.sSortParams+=S.sPath;this.sSortParams+=S.bDescending?"%20desc":"%20asc";this.sSortParams+=","}}this.sSortParams=this.sSortParams.slice(0,-1)};O.prototype.filter=function(f,s){if(!f){f=[]}if(f instanceof sap.ui.model.Filter){f=[f]}if(s==F.Application){this.aApplicationFilters=f}else{this.aFilters=f}f=this.aFilters.concat(this.aApplicationFilters);if(!f||!q.isArray(f)||f.length==0){this.aFilters=[];this.aApplicationFilters=[]}this.createFilterParams(f);this.abortPendingRequest();this.resetData();if(this.bInitialized){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false}this.sChangeReason=sap.ui.model.ChangeReason.Filter;this._fireRefresh({reason:this.sChangeReason});if(s==F.Application){this._fireFilter({filters:this.aApplicationFilters})}else{this._fireFilter({filters:this.aFilters})}}return this};O.prototype.createFilterParams=function(f){if(f&&f.length>0){var o={},b=0,c,s="$filter=",d=0,t=this;q.each(f,function(j,e){if(e.sPath){c=o[e.sPath];if(!c){c=o[e.sPath]=[];b++}}else{c=o["__multiFilter"];if(!c){c=o["__multiFilter"]=[];b++}}c.push(e)});q.each(o,function(p,c){if(c.length>1){s+='('}q.each(c,function(i,e){if(e instanceof a){if(e.aValues.length>1){s+='('}q.each(e.aValues,function(i,g){if(i>0){if(e.bAND){s+="%20and%20"}else{s+="%20or%20"}}s=t._createFilterSegment(e.sPath,g.operator,g.value1,g.value2,s)});if(e.aValues.length>1){s+=')'}}else if(e._bMultiFilter){s+=t._resolveMultiFilter(e)}else{s=t._createFilterSegment(e.sPath,e.sOperator,e.oValue1,e.oValue2,s)}if(i<c.length-1){s+="%20or%20"}});if(c.length>1){s+=')'}if(d<b-1){s+="%20and%20"}d++});this.sFilterParams=s}else{this.sFilterParams=null}};O.prototype._resolveMultiFilter=function(m){var t=this,f=m.aFilters,s="";if(f){s+="(";q.each(f,function(i,o){var l=false;if(o._bMultiFilter){s+=t._resolveMultiFilter(o)}else if(o.sPath){s+=t._createFilterSegment(o.sPath,o.sOperator,o.oValue1,o.oValue2,"")}if(i<(f.length-1)){if(m.bAnd){s+="%20and%20"}else{s+="%20or%20"}}});s+=")"}return s};O.prototype._createFilterSegment=function(p,o,v,V,f){var P;if(this.oEntityType){P=this.oModel.oMetadata._getPropertyMetadata(this.oEntityType,p);}if(P){v=this.oModel.formatValue(v,P.type);V=(V!=null)?this.oModel.formatValue(V,P.type):null}else{}if(v){v=q.sap.encodeURL(String(v))}if(V){V=q.sap.encodeURL(String(V))}switch(o){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":f+=p+"%20"+o.toLowerCase()+"%20"+v;break;case"BT":f+="("+p+"%20ge%20"+v+"%20and%20"+p+"%20le%20"+V+")";break;case"Contains":f+="substringof("+v+","+p+")";break;case"StartsWith":f+="startswith("+p+","+v+")";break;case"EndsWith":f+="endswith("+p+","+v+")";break;default:f+="true"}return f};O.prototype._initSortersFilters=function(){this.oEntityType=this._getEntityType();this.createSortParams(this.aSorters);this.createFilterParams(this.aFilters.concat(this.aApplicationFilters))};O.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var e=this.oModel.oMetadata._getEntityTypeByPath(r);return e}return undefined};return O},true);
