// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.unified.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.unified.ContentSwitcherRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.unified.ContentSwitcherRenderer");

/**
 * @class AnimatedContentSwitcher renderer. 
 * @static
 */
sap.ui.unified.ContentSwitcherRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.unified.ContentSwitcherRenderer.render = function(oRm, oControl){ 
	var sId            = oControl.getId();
	var sAnimation     = oControl.getAnimation();
	if(!sap.ui.getCore().getConfiguration().getAnimation()){
		sAnimation = sap.ui.unified.ContentSwitcherAnimation.None;
	}
	
	var iActiveContent = oControl.getActiveContent();

	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapUiUfdCSwitcher");
	oRm.addClass("sapUiUfdCSwitcherAnimation" + sAnimation);
	oRm.writeClasses();
	oRm.write(">");
	
	oRm.write("<section id=\"" + sId + "-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1" + (iActiveContent == 1 ? " sapUiUfdCSwitcherVisible" : "") +"\">");
	this.renderContent(oRm, oControl.getContent1());
	oRm.write("</section>");
	
	oRm.write("<section id=\"" + sId + "-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2" + (iActiveContent == 2 ? " sapUiUfdCSwitcherVisible" : "") +"\">");
	this.renderContent(oRm, oControl.getContent2());
	oRm.write("</section>");
	
	oRm.write("</div>");
};

sap.ui.unified.ContentSwitcherRenderer.renderContent = function(oRm, aContent) {
	for (var i = 0; i < aContent.length; ++i) {
		oRm.renderControl(aContent[i]);
	}
};
}; // end of sap/ui/unified/ContentSwitcherRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellOverlayRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.ShellOverlay
jQuery.sap.declare("sap.ui.unified.ShellOverlayRenderer");

/**
 * @class ShellOverlay renderer.
 * @static
 */
sap.ui.unified.ShellOverlayRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
 */
sap.ui.unified.ShellOverlayRenderer.render = function(rm, oControl){
	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapUiUfdShellOvrly");
	if(oControl._opening){
		rm.addClass("sapUiUfdShellOvrlyCntntHidden");
		rm.addClass("sapUiUfdShellOvrlyOpening");
	}
	
	if(oControl._getAnimActive()){
		rm.addClass("sapUiUfdShellOvrlyAnim");
	}
	rm.writeClasses();
	rm.write("><div>");
	
	rm.write("<header class='sapUiUfdShellOvrlyHead'>");
	rm.write("<hr class='sapUiUfdShellOvrlyBrand'/>");
	rm.write("<div class='sapUiUfdShellOvrlyHeadCntnt'>");
	rm.write("<div id='"+oControl.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");
	sap.ui.unified.ShellOverlayRenderer.renderSearch(rm, oControl);
	rm.write("</div>");
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),
		sCloseTxt = rb.getText("SHELL_OVERLAY_CLOSE");
	rm.write("<a tabindex='0' href='javascript:void(0);' id='"+oControl.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");
	rm.writeAttributeEscaped("title", sCloseTxt);
	rm.write(">");
	rm.writeEscaped(sCloseTxt);
	rm.write("</a></div></header>");
	rm.write("<div id='"+oControl.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");
	sap.ui.unified.ShellOverlayRenderer.renderContent(rm, oControl);
	rm.write("</div>");
	
	rm.write("</div></div>");
};

sap.ui.unified.ShellOverlayRenderer.renderSearch = function(rm, oControl) {
	var iWidth = oControl._getSearchWidth();
	var sStyle = "";
	if(iWidth > 0 && oControl._opening){
		sStyle = "style='width:"+iWidth+"px'";
	}
	
	rm.write("<div id='"+oControl.getId()+"-search' class='sapUiUfdShellOvrlySearch' "+sStyle+">");
	var oSearch = oControl.getSearch();
	if(oSearch){
		rm.renderControl(oSearch);
	}
	rm.write("</div>");
};

sap.ui.unified.ShellOverlayRenderer.renderContent = function(rm, oControl) {
	rm.write("<div>");
	var aContent = oControl.getContent();
	for(var i=0; i<aContent.length; i++){
		rm.renderControl(aContent[i]);
	}
	rm.write("</div>");
};
}; // end of sap/ui/unified/ShellOverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.Shell
jQuery.sap.declare("sap.ui.unified.ShellRenderer");

/**
 * @class Shell renderer.
 * @static
 */
sap.ui.unified.ShellRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
 */
sap.ui.unified.ShellRenderer.render = function(rm, oShell){
	var id = oShell.getId();

	rm.write("<div");
	rm.writeControlData(oShell);
	rm.addClass("sapUiUfdShell");
	if(oShell._animation){
		rm.addClass("sapUiUfdShellAnim");
	}
	rm.addClass("sapUiUfdShellHead"+ (oShell._showHeader ? "Visible" : "Hidden"));
	if(oShell.getShowCurtain()){
		rm.addClass("sapUiUfdShellCurtainVisible");
	}else{
		rm.addClass("sapUiUfdShellCurtainHidden");
		rm.addClass("sapUiUfdShellCurtainClosed");
	}
	
	rm.writeClasses();
	rm.write(">");
	
	rm.write("<hr id='", id, "-brand' class='sapUiUfdShellBrand'/>");
	
	rm.write("<header id='", id, "-hdr'  class='sapUiUfdShellHead'><div>");
	rm.write("<div id='", id, "-hdrcntnt' class='sapUiUfdShellCntnt'>");
	sap.ui.unified.ShellRenderer._renderHeaderContent(rm, oShell);
	rm.write("</div>", "</div>", "</header>");

	rm.write("<section id='", id, "-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");
	rm.write("<div id='", id, "-curtcntnt' class='sapUiUfdShellCntnt'>");
	rm.renderControl(oShell._curtCont);
	rm.write("</div>");
	rm.write("<span id='", id, "-curt-focusDummyOut' tabindex='0'></span>");
	rm.write("</section>");
	
	rm.write("<div id='", id, "-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas'>");
	rm.renderControl(oShell._cont);
	rm.write("</div>");
	
	rm.write("<span id='", id, "-main-focusDummyOut' tabindex='" + (oShell.getShowCurtain() ? 0 : -1) + "'></span>");
	
	rm.write("</div>");
};

sap.ui.unified.ShellRenderer._renderHeaderContent = function(rm, oShell){
	var id = oShell.getId();

	rm.write("<div id='", id, "-hdr-begin' class='sapUiUfdShellHeadBegin'>");
	sap.ui.unified.ShellRenderer.renderHeaderItems(rm, oShell, true);
	rm.write("</div>");
	
	rm.write("<div id='", id, "-hdr-center' class='sapUiUfdShellHeadCenter'>");
	sap.ui.unified.ShellRenderer.renderSearch(rm, oShell);
	rm.write("</div>");
	
	rm.write("<div id='", id, "-hdr-end' class='sapUiUfdShellHeadEnd'>");
	sap.ui.unified.ShellRenderer.renderHeaderItems(rm, oShell, false);
	rm.write("</div>");
};

sap.ui.unified.ShellRenderer.renderSearch = function(rm, oShell) {
	var oSearch = oShell.getSearch(),
		bShowSearch = oShell.getSearchVisible() && !!oSearch;
	rm.write("<div id='", oShell.getId(), "-hdr-search'");
	rm.writeAttribute("class", "sapUiUfdShellSearch" + (bShowSearch ? "" : " sapUiUfdShellHidden"));
	rm.write(">");
	if(oSearch){
		rm.renderControl(oSearch);
	}
	rm.write("</div>");
};

sap.ui.unified.ShellRenderer.renderHeaderItems = function(rm, oShell, begin) {
	rm.write("<div class='sapUiUfdShellHeadContainer'>");
	var aItems = begin ? oShell.getHeadItems() : oShell.getHeadEndItems();
	
	for(var i=0; i<aItems.length; i++){
		rm.write("<a tabindex='0' href='javascript:void(0);'");
		rm.writeElementData(aItems[i]);
		rm.addClass("sapUiUfdShellHeadItm");
		if(aItems[i].getStartsSection()){
			rm.addClass("sapUiUfdShellHeadItmDelim");
		}
		if(!aItems[i].getVisible()){
			rm.addClass("sapUiUfdShellHidden");
		}
		if(aItems[i].getSelected()){
			rm.addClass("sapUiUfdShellHeadItmSel");
		}
		if(aItems[i].getShowMarker()){
			rm.addClass("sapUiUfdShellHeadItmMark");
		}
		rm.writeClasses();
		var tooltip = aItems[i].getTooltip_AsString();
		if(tooltip){
			rm.writeAttributeEscaped("title", tooltip);
		}
		rm.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></a>");
	}
	
	rm.write("</div>");
	if(begin){
		sap.ui.unified.ShellRenderer._renderIcon(rm, oShell);
	}
};

sap.ui.unified.ShellRenderer._renderIcon = function(rm, oShell) {
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),
		sLogoTooltip = rb.getText("SHELL_LOGO_TOOLTIP"),
		sIco = oShell._getIcon();
	
	rm.write("<div class='sapUiUfdShellIco'>");
	rm.write("<img id='", oShell.getId(), "-icon'");
	rm.writeAttributeEscaped("title", sLogoTooltip);
	rm.writeAttributeEscaped("alt", sLogoTooltip);
	rm.write("src='");
	rm.writeEscaped(sIco);
	rm.write("' style='", sIco ? "" : "display:none;","'></img>");
	rm.write("</div>");
};

}; // end of sap/ui/unified/ShellRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.SplitContainerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.SplitContainer
jQuery.sap.declare("sap.ui.unified.SplitContainerRenderer");

/**
 * @class SplitContainer renderer.
 * @static
 */
sap.ui.unified.SplitContainerRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
 */
sap.ui.unified.SplitContainerRenderer.render = function(rm, oControl){
	var sId = oControl.getId();

	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapUiUfdSpltCont");
	if(sap.ui.getCore().getConfiguration().getAnimation()){
		rm.addClass("sapUiUfdSpltContAnim");
	}

	if(!oControl.getShowSecondaryContent()){
		rm.addClass("sapUiUfdSpltContPaneHidden");
	}
	rm.writeClasses();
	rm.write(">");
	
	var sCanvasId = sId + "-canvas";

	rm.write("<section id='", sCanvasId, "' class='sapUiUfdSpltContCanvas'>");
	this.renderContent(rm, sCanvasId, oControl.getContent(), oControl._bRootContent);
	rm.write("</section>");
	
	var sSidePaneId = sId + "-pane";

	var sWidth = oControl.getShowSecondaryContent() ? oControl.getSecondaryContentWidth() : "0";
	rm.write("<aside id='", sSidePaneId, "' style='width:", sWidth, "'");
	rm.addClass("sapUiUfdSpltContPane");
	if(!oControl.getShowSecondaryContent()){
		rm.addClass("sapUiUfdSplitContSecondClosed");
	}
	rm.writeClasses();
	rm.write(">");
	this.renderContent(rm, sSidePaneId, oControl.getSecondaryContent(), oControl._bRootContent);
	rm.write("</aside>");

	rm.write("</div>");
};

sap.ui.unified.SplitContainerRenderer.renderContent = function (rm, sId, aContent, bRootContent) {
	rm.write("<div id='", sId, "cntnt' class='sapUiUfdSpltContCntnt'");
	if(bRootContent){
		rm.writeAttribute("data-sap-ui-root-content", "true"); // see e.g. sap.m.App#onAfterRendering
	}
	rm.write(">");
	for(var i=0; i<aContent.length; i++){
		rm.renderControl(aContent[i]);
	}
	rm.write("</div>");
};

}; // end of sap/ui/unified/SplitContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

/**
 * Initialization Code and shared classes of library sap.ui.unified (1.20.6)
 */
jQuery.sap.declare("sap.ui.unified.library");
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained

/**
 * SAPUI5 unified library
 *
 * @namespace
 * @name sap.ui.unified
 * @public
 */


// library dependencies
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained


// delegate further initialization of this library to the Core
sap.ui.getCore().initLibrary({
  name : "sap.ui.unified",
  dependencies : ["sap.ui.core"],
  types: [
    "sap.ui.unified.ContentSwitcherAnimation"
  ],
  interfaces: [],
  controls: [
    "sap.ui.unified.ContentSwitcher",
    "sap.ui.unified.Shell",
    "sap.ui.unified.ShellOverlay",
    "sap.ui.unified.SplitContainer"
  ],
  elements: [
    "sap.ui.unified.ShellHeadItem"
  ],
  version: "1.20.6"});

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.unified.ContentSwitcherAnimation.
jQuery.sap.declare("sap.ui.unified.ContentSwitcherAnimation");


/**
 * @class Predefined animations for the ContentSwitcher
 *
 * @version 1.20.6
 * @static
 * @public
 * @since 1.16.0
 * @experimental Since version 1.16.0. 
 * API is not yet finished and might change completely
 */
sap.ui.unified.ContentSwitcherAnimation = {
  
    /**
     * No animation. Content is switched instantly. 
     * @public
     */
    None : "None",

    /**
     * Content is faded (opacity change). 
     * @public
     */
    Fade : "Fade",

    /**
     * The new content is "zoomed in" from the center and grows to fill the full content area. 
     * @public
     */
    ZoomIn : "ZoomIn",

    /**
     * The old content is "zoomed out", i.e. shrinks to a point at the center of the content area. 
     * @public
     */
    ZoomOut : "ZoomOut",

    /**
     * The new content rotates in. (Just like one of those old newspaper-animations.) 
     * @public
     */
    Rotate : "Rotate",

    /**
     * The new slides in from the left (to the right). 
     * @public
     */
    SlideRight : "SlideRight",

    /**
     * The new content slides in from the left while the old content slides out to the left at the same time. 
     * @public
     */
    SlideOver : "SlideOver"

  };

// -----------------------------------------------------------------------------
// Begin of Library Initialization coding, copied from shared.js
// -----------------------------------------------------------------------------

sap.ui.base.Object.extend("sap.ui.unified._ContentRenderer", {
	constructor : function(oControl, sContentContainerId, oContent, fAfterRenderCallback) {
		sap.ui.base.Object.apply(this);
		this._id = sContentContainerId;
		this._cntnt = oContent;
		this._ctrl = oControl;
		this._rm = sap.ui.getCore().createRenderManager();
		this._cb = fAfterRenderCallback || function(){};
	},
	
	destroy : function() {
		this._rm.destroy();
		delete this._rm;
		delete this._id;
		delete this._cntnt;
		delete this._cb;
		delete this._ctrl;
		if(this._rerenderTimer){
			jQuery.sap.clearDelayedCall(this._rerenderTimer);
			delete this._rerenderTimer;
		}
		sap.ui.base.Object.prototype.destroy.apply(this, arguments);
	},
	
	render : function() {
		if(!this._rm){
			return;
		}
		
		if(this._rerenderTimer){
			jQuery.sap.clearDelayedCall(this._rerenderTimer);
		}
		
		this._rerenderTimer = jQuery.sap.delayedCall(0, this, function(){
			var $content = jQuery.sap.byId(this._id);
			var doRender = $content.length > 0;
			
			if(doRender){
				if(typeof(this._cntnt) === "string"){
					var aContent = this._ctrl.getAggregation(this._cntnt, []);
					for(var i=0; i < aContent.length; i++){
						this._rm.renderControl(aContent[i]);
					}
				}else{
					this._cntnt(this._rm);
				}
				this._rm.flush($content[0]);
			}

			this._cb(doRender);
		});
	}
});


sap.ui.unified._iNumberOfOpenedShellOverlays = 0;
}; // end of sap/ui/unified/library.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ContentSwitcher') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.ContentSwitcher.
jQuery.sap.declare("sap.ui.unified.ContentSwitcher");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ContentSwitcher.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getAnimation animation} : string (default: 'None')</li>
 * <li>{@link #getActiveContent activeContent} : int (default: 1)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent1 content1} : sap.ui.core.Control[]</li>
 * <li>{@link #getContent2 content2} : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Switches between two control areas and animates it via CSS transitions
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.16.0
 * @experimental Since version 1.16.0. 
 * API is not yet finished and might change completely
 * @name sap.ui.unified.ContentSwitcher
 */
sap.ui.core.Control.extend("sap.ui.unified.ContentSwitcher", { metadata : {

	// ---- object ----
	deprecated : true,

	// ---- control specific ----
	library : "sap.ui.unified",
	properties : {
		"animation" : {type : "string", group : "Appearance", defaultValue : 'None'},
		"activeContent" : {type : "int", group : "Behavior", defaultValue : 1}
	},
	aggregations : {
    	"content1" : {type : "sap.ui.core.Control", multiple : true, singularName : "content1"}, 
    	"content2" : {type : "sap.ui.core.Control", multiple : true, singularName : "content2"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.ContentSwitcher with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.ContentSwitcher.extend
 * @function
 */


/**
 * Getter for property <code>animation</code>.
 * Set the used animation when changing content. This just sets a CSS-class named "sapUiUnifiedACSwitcherAnimation" + this value on the root element of the control. The animation has to be implemented in CSS. This also enables applications to implement their own animations via CSS by reacting to the parent class.
 * See the types sap.ui.unified.ContentSwitcherAnimation for default implementations.
 *
 * Default value is <code>None</code>
 *
 * @return {string} the value of property <code>animation</code>
 * @public
 * @name sap.ui.unified.ContentSwitcher#getAnimation
 * @function
 */

/**
 * Setter for property <code>animation</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {string} sAnimation  new value for property <code>animation</code>
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#setAnimation
 * @function
 */


/**
 * Getter for property <code>activeContent</code>.
 * The number of the currently active content (1 or 2).
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>activeContent</code>
 * @public
 * @name sap.ui.unified.ContentSwitcher#getActiveContent
 * @function
 */

/**
 * Setter for property <code>activeContent</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iActiveContent  new value for property <code>activeContent</code>
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#setActiveContent
 * @function
 */


/**
 * Getter for aggregation <code>content1</code>.<br/>
 * The controls that should be shown in the first content
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.ContentSwitcher#getContent1
 * @function
 */


/**
 * Inserts a content1 into the aggregation named <code>content1</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent1 the content1 to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content1 should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content1 is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content1 is inserted at 
 *             the last position        
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#insertContent1
 * @function
 */

/**
 * Adds some content1 <code>oContent1</code> 
 * to the aggregation named <code>content1</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent1 the content1 to add; if empty, nothing is inserted
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#addContent1
 * @function
 */

/**
 * Removes an content1 from the aggregation named <code>content1</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent1 the content1 to remove or its index or id
 * @return {sap.ui.core.Control} the removed content1 or null
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeContent1
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content1</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeAllContent1
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content1</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent1 the content1 whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.ContentSwitcher#indexOfContent1
 * @function
 */
	

/**
 * Destroys all the content1 in the aggregation 
 * named <code>content1</code>.
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#destroyContent1
 * @function
 */


/**
 * Getter for aggregation <code>content2</code>.<br/>
 * The controls that should be shown in the second content
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.ContentSwitcher#getContent2
 * @function
 */


/**
 * Inserts a content2 into the aggregation named <code>content2</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent2 the content2 to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content2 should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content2 is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content2 is inserted at 
 *             the last position        
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#insertContent2
 * @function
 */

/**
 * Adds some content2 <code>oContent2</code> 
 * to the aggregation named <code>content2</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent2 the content2 to add; if empty, nothing is inserted
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#addContent2
 * @function
 */

/**
 * Removes an content2 from the aggregation named <code>content2</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent2 the content2 to remove or its index or id
 * @return {sap.ui.core.Control} the removed content2 or null
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeContent2
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content2</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeAllContent2
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content2</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent2 the content2 whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.ContentSwitcher#indexOfContent2
 * @function
 */
	

/**
 * Destroys all the content2 in the aggregation 
 * named <code>content2</code>.
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#destroyContent2
 * @function
 */


// Start of sap\ui\unified\ContentSwitcher.js
(function(window, undefined) {

////////////////////////////////////////// Public Methods //////////////////////////////////////////

/**
 * This file defines behavior for the control,
 */
sap.ui.unified.ContentSwitcher.prototype.init = function(){
};

/**
 * Changes the currently active content to the other one. If content 1 is active, content 2 will
 * be activated and the other way around.
 * 
 * @public
 */
sap.ui.unified.ContentSwitcher.prototype.switchContent = function() {
	this.setActiveContent(this.getActiveContent() == 1 ? 2 : 1);
	return this;
};

////////////////////////////////////////// onEvent Methods /////////////////////////////////////////

sap.ui.unified.ContentSwitcher.prototype.onAfterRendering = function() {
	this._$Contents = [
		this.$("content1"),
		this.$("content2")
	];
};


////////////////////////////////////////// Private Methods /////////////////////////////////////////

/**
 * Make the content-area with the given number appear/visible. This just sets the CSS-class
 * sapUiUnifiedCSwitcherVisible
 */
sap.ui.unified.ContentSwitcher.prototype._showActiveContent = function(iNumber) {
	this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible", iNumber === 1);
	this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible", iNumber === 2);
};

///////////////////////////////////////// Hidden Functions /////////////////////////////////////////


//////////////////////////////////////// Overridden Methods ////////////////////////////////////////

    ///////////////////////////////// Property "activeContent" /////////////////////////////////

sap.ui.unified.ContentSwitcher.prototype.setActiveContent = function(iNumber) {
	iNumber = parseInt(iNumber);
	
	if (isNaN(iNumber) || iNumber < 1) {
		iNumber = 1;
		
		jQuery.sap.log.warning(
			"setActiveContent argument must be either 1 or 2. Active content set to 1."
		);
	} else if (iNumber > 2) {
		iNumber = 2;
		
		jQuery.sap.log.warning(
			"setActiveContent argument must be either 1 or 2. Active content set to 2."
		);
	}
	
	this.setProperty("activeContent", iNumber, /* supressInvalidate: */ true);
	
	this._showActiveContent(iNumber);
	
	return this;
};


    /////////////////////////////////// Property "animation" ///////////////////////////////////

sap.ui.unified.ContentSwitcher.prototype.setAnimation = function(sAnimation, bSuppressInvalidate){
	if (typeof(sAnimation) !== "string") {
		sAnimation = sap.ui.unified.ContentSwitcherAnimation.None;
		jQuery.sap.log.warning(
			"setAnimation argument must be a string. Animation was set to \"" + 
			sap.ui.unified.ContentSwitcherAnimation.None + "\"."
		);
	}
	
	// Remove all non-alphanumerical characters from the animation string
	sAnimation = sAnimation.replace(/[^a-zA-Z0-9]/g, "");
	
	var sCurrentAnimation = this.getProperty("animation");
	
	if (sAnimation === sCurrentAnimation) {
		// No change.
		return;
	}
	
	var $Dom = this.$();
	if ($Dom[0]) {
		// We are already rendered - so we have to change the class on the fly...
		$Dom.toggleClass("sapUiUfdCSwitcherAnimation" + sCurrentAnimation, false);
		$Dom.toggleClass("sapUiUfdCSwitcherAnimation" + sAnimation, true);
	}/* else {
		// The renderer will take care of it.
	}/**/

	this.setProperty("animation", sAnimation, bSuppressInvalidate);
	
	return this;
};


    //////////////////////////////////////// Event "xxx" ///////////////////////////////////////
    ///////////////////////////////////// Aggregation "xxx" ////////////////////////////////////
    ///////////////////////////////////// Association "xxx" ////////////////////////////////////

})(window);
}; // end of sap/ui/unified/ContentSwitcher.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellHeadItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.ShellHeadItem.
jQuery.sap.declare("sap.ui.unified.ShellHeadItem");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new ShellHeadItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getStartsSection startsSection} : boolean (default: false)</li>
 * <li>{@link #getSelected selected} : boolean (default: false)</li>
 * <li>{@link #getShowMarker showMarker} : boolean (default: false)</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.ShellHeadItem#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Header Action item of the Shell.
 * @extends sap.ui.core.Element
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.15.1
 * @name sap.ui.unified.ShellHeadItem
 */
sap.ui.core.Element.extend("sap.ui.unified.ShellHeadItem", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.ui.unified",
	properties : {
		"startsSection" : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
		"selected" : {type : "boolean", group : "Appearance", defaultValue : false},
		"showMarker" : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true}
	},
	events : {
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.ShellHeadItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.ShellHeadItem.extend
 * @function
 */

sap.ui.unified.ShellHeadItem.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>startsSection</code>.
 * If set to true, a divider is displayed before the item.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>startsSection</code>
 * @public
 * @deprecated Since version 1.18. 
 * Dividers are not supported anymore.
 * @name sap.ui.unified.ShellHeadItem#getStartsSection
 * @function
 */

/**
 * Setter for property <code>startsSection</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bStartsSection  new value for property <code>startsSection</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18. 
 * Dividers are not supported anymore.
 * @name sap.ui.unified.ShellHeadItem#setStartsSection
 * @function
 */


/**
 * Getter for property <code>selected</code>.
 * If set to true, the item gets a special design.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>selected</code>
 * @public
 * @name sap.ui.unified.ShellHeadItem#getSelected
 * @function
 */

/**
 * Setter for property <code>selected</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSelected  new value for property <code>selected</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#setSelected
 * @function
 */


/**
 * Getter for property <code>showMarker</code>.
 * If set to true, a theme dependent marker is shown on the item.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showMarker</code>
 * @public
 * @deprecated Since version 1.18. 
 * Markers should not be used anymore.
 * @name sap.ui.unified.ShellHeadItem#getShowMarker
 * @function
 */

/**
 * Setter for property <code>showMarker</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowMarker  new value for property <code>showMarker</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18. 
 * Markers should not be used anymore.
 * @name sap.ui.unified.ShellHeadItem#setShowMarker
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * The icon of the item, either defined in the sap.ui.core.IconPool or an URI to a custom image. An icon must be set.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.unified.ShellHeadItem#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#setIcon
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible items are not shown on the UI.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @since 1.18
 * @name sap.ui.unified.ShellHeadItem#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @since 1.18
 * @name sap.ui.unified.ShellHeadItem#setVisible
 * @function
 */


/**
 * Event is fired when the user presses the item. 
 *
 * @name sap.ui.unified.ShellHeadItem#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.unified.ShellHeadItem</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.ShellHeadItem</code>.<br/> itself. 
 *  
 * Event is fired when the user presses the item. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.ShellHeadItem</code>.<br/> itself.
 *
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.unified.ShellHeadItem</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.ShellHeadItem#firePress
 * @function
 */


// Start of sap\ui\unified\ShellHeadItem.js
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


sap.ui.unified.ShellHeadItem.prototype.onclick = function(oEvent){
	this.firePress();
};


sap.ui.unified.ShellHeadItem.prototype.setStartsSection = function(bStartsSection){
	bStartsSection = !!bStartsSection;
	this.setProperty("startsSection", bStartsSection, true);
	this.$().toggleClass("sapUiUfdShellHeadItmDelim", bStartsSection);
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setSelected = function(bSelected){
	bSelected = !!bSelected;
	this.setProperty("selected", bSelected, true);
	this.$().toggleClass("sapUiUfdShellHeadItmSel", bSelected);
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setVisible = function(bVisible){
	this.setProperty("visible", !!bVisible); // Suppress Rerendering handled by Shell
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setShowMarker = function(bMarker){
	bMarker = !!bMarker;
	this.setProperty("showMarker", bMarker, true);
	this.$().toggleClass("sapUiUfdShellHeadItmMark", bMarker);
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setIcon = function(sIcon){
	this.setProperty("icon", sIcon, true);
	if(this.getDomRef()){
		this._refreshIcon();
	}
	return this;
};


sap.ui.unified.ShellHeadItem.prototype._refreshIcon = function(){
	var $Ico = jQuery(this.$().children()[0]);
	var sIco = this.getIcon();
	$Ico.html("").css("style", "");
	if(sap.ui.core.IconPool.isIconURI(sIco)){
		var oIconInfo = sap.ui.core.IconPool.getIconInfo(sIco);
		if(oIconInfo){
			$Ico.text(oIconInfo.content).css("font-family", "'" + oIconInfo.fontFamily + "'");
		}
	}else{
		$Ico.html("<img src='" + jQuery.sap.encodeHTML(sIco) + "'></img>");
	}
};
}; // end of sap/ui/unified/ShellHeadItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.SplitContainer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.SplitContainer.
jQuery.sap.declare("sap.ui.unified.SplitContainer");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new SplitContainer.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getShowSecondaryContent showSecondaryContent} : boolean</li>
 * <li>{@link #getSecondaryContentWidth secondaryContentWidth} : sap.ui.core.CSSSize (default: '250px')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getSecondaryContent secondaryContent} : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Provides a main content and a secondary content area
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.15.0
 * @experimental Since version 1.15.0. 
 * API is not yet finished and might change completely
 * @name sap.ui.unified.SplitContainer
 */
sap.ui.core.Control.extend("sap.ui.unified.SplitContainer", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.ui.unified",
	properties : {
		"showSecondaryContent" : {type : "boolean", group : "Appearance", defaultValue : null},
		"secondaryContentWidth" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '250px'}
	},
	defaultAggregation : "content",
	aggregations : {
    	"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
    	"secondaryContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "secondaryContent"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.SplitContainer with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.SplitContainer.extend
 * @function
 */


/**
 * Getter for property <code>showSecondaryContent</code>.
 * Shows / Hides the secondary area.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showSecondaryContent</code>
 * @public
 * @name sap.ui.unified.SplitContainer#getShowSecondaryContent
 * @function
 */

/**
 * Setter for property <code>showSecondaryContent</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowSecondaryContent  new value for property <code>showSecondaryContent</code>
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#setShowSecondaryContent
 * @function
 */


/**
 * Getter for property <code>secondaryContentWidth</code>.
 * The width if the secondary content. The height is always 100%.
 *
 * Default value is <code>250px</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>secondaryContentWidth</code>
 * @public
 * @name sap.ui.unified.SplitContainer#getSecondaryContentWidth
 * @function
 */

/**
 * Setter for property <code>secondaryContentWidth</code>.
 *
 * Default value is <code>250px</code> 
 *
 * @param {sap.ui.core.CSSSize} sSecondaryContentWidth  new value for property <code>secondaryContentWidth</code>
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#setSecondaryContentWidth
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content to appear in the main area.
 * 
 * <strong>Note</strong>: this is the default aggregation for SplitContainer.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.SplitContainer#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.unified.SplitContainer#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.SplitContainer#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.SplitContainer#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>secondaryContent</code>.<br/>
 * The content to appear in the secondary area.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.SplitContainer#getSecondaryContent
 * @function
 */


/**
 * Inserts a secondaryContent into the aggregation named <code>secondaryContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oSecondaryContent the secondaryContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the secondaryContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the secondaryContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the secondaryContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#insertSecondaryContent
 * @function
 */

/**
 * Adds some secondaryContent <code>oSecondaryContent</code> 
 * to the aggregation named <code>secondaryContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oSecondaryContent the secondaryContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#addSecondaryContent
 * @function
 */

/**
 * Removes an secondaryContent from the aggregation named <code>secondaryContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vSecondaryContent the secondaryContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed secondaryContent or null
 * @public
 * @name sap.ui.unified.SplitContainer#removeSecondaryContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>secondaryContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.SplitContainer#removeAllSecondaryContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>secondaryContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oSecondaryContent the secondaryContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.SplitContainer#indexOfSecondaryContent
 * @function
 */
	

/**
 * Destroys all the secondaryContent in the aggregation 
 * named <code>secondaryContent</code>.
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#destroySecondaryContent
 * @function
 */


// Start of sap\ui\unified\SplitContainer.js
(function(window, undefined) {

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


////////////////////////////////////////// Public Methods //////////////////////////////////////////

sap.ui.unified.SplitContainer.prototype.init = function(){
	this.bRtl  = sap.ui.getCore().getConfiguration().getRTL();
	
	this._paneRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-panecntnt", "secondaryContent");
	this._canvasRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-canvascntnt", "content");
	
// Design decided that content does not need to be handled differently depending on device - remove 
// comments if needed again...
//	sap.ui.Device.media.attachHandler(
//		this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD
//	);

	// By default move the content when the secondaryContent is shown
	this._moveContent = true;
};

sap.ui.unified.SplitContainer.prototype.exit = function(){
	this._paneRenderer.destroy();
	delete this._paneRenderer;
	this._canvasRenderer.destroy();
	delete this._canvasRenderer;

	delete this._contentContainer;
	delete this._secondaryContentContainer;
};


////////////////////////////////////////// onEvent Methods /////////////////////////////////////////

sap.ui.unified.SplitContainer.prototype.onAfterRendering = function() {
	// Shortcuts to the main DOM containers
	this._contentContainer 			= this.$("canvas");
	this._secondaryContentContainer = this.$("pane");

// Design decided that content does not need to be handled differently depending on device - remove 
// comments if needed again...
//	this._lastDeviceName = "";
//	this._handleMediaChange(
//		sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD)
//	);
	
	this._applySecondaryContentSize();
};


////////////////////////////////////////// Private Methods /////////////////////////////////////////

// Design decided that content does not need to be handled differently depending on device - remove 
// comments if needed again...
///**
// * This method is called whenever the size of the document changes into a different range of values
// * that represent different devices (Desktop/Tablet/Phone).
// * 
// * @private
// */
//sap.ui.unified.SplitContainer.prototype._handleMediaChange = function(mParams) {
//	var sDeviceName = mParams.name;
//	
//	// By default, move the content to the right, there should be enough space
//	this._moveContent = true;
//
//	if (sDeviceName == "Phone") {
//		// On phones, do not move the main content as it does not have enough
//		// space as it is
//		this._moveContent = false;
//	}
//
//	// Only write changes if something actually changed
//	if (this._lastDeviceName !== sDeviceName) {
//		this._applySecondaryContentSize();
//	}
//	this._lastDeviceName = sDeviceName;
//};

/**
 * Applies the current status to the content areas (CSS left and width properties).
 * 
 * @private
 */
sap.ui.unified.SplitContainer.prototype._applySecondaryContentSize = function(){
	// Only set if rendered...
	if (this.getDomRef()) {
		var sDir = this.bRtl ? "right" : "left";
		
		var sSize = this.getSecondaryContentWidth();
		var bShow = this.getShowSecondaryContent();

		if (this._closeContentDelayId) {
			jQuery.sap.clearDelayedCall(this._closeContentDelayId);
		}
		
		this._secondaryContentContainer.css("width", sSize);
		this._secondaryContentContainer.css(sDir, bShow ? "0" : "-" + sSize);
		
		// Move main content if it should be completely visible. @see _handleMediaChange()
		if (this._moveContent) {
			this._contentContainer.css(sDir, bShow ? sSize : "0");
		} else {
			this._contentContainer.css(sDir, "0");
		}
		
		if (!bShow) {
			// The theming parameter is something along the lines of "500ms", the "ms"-part is
			// ignored by parseInt.
			// TODO: Cache the value.
			var iHideDelay = parseInt(
				sap.ui.core.theming.Parameters.get("sapUiUfdSplitContAnimationDuration"),
				10
			);
			// Maybe we could also allow "s"-values and then multiply everything below 20 with 1000...?

			this._closeContentDelayId = jQuery.sap.delayedCall(iHideDelay, this, function() {
				this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed", true);
			});
		} else {
			this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed", false);
		}
		
	}
};



/**
 * Optimization method that prevents the normal render from rerendering the whole control.
 * See _ContentRenderer in file shared.js for details.
 * 
 * @param {function} fMod Method that is called to perform the requested change
 * @param {sap.ui.core.Renderer} oDoIfRendered Renderer Instance
 * @returns {any} the return value from the first parameter
 * 
 * @private
 */
sap.ui.unified.SplitContainer.prototype._mod = function(fMod, oDoIfRendered){
	var bRendered = !!this.getDomRef();
	var res = fMod.apply(this, [bRendered]);
	if(bRendered && oDoIfRendered){
		oDoIfRendered.render();
	}
	return res;
};


//////////////////////////////////////// Overridden Methods ////////////////////////////////////////

    //////////////////////////// Property "showSecondaryContent" ///////////////////////////////

sap.ui.unified.SplitContainer.prototype.setShowSecondaryContent = function(bShow){
	var bRendered = this.getDomRef();
	this.setProperty("showSecondaryContent", !!bShow, bRendered);
	
	this._applySecondaryContentSize();
	return this;
};


	///////////////////////////// Property "secondaryContentWidth" /////////////////////////////

sap.ui.unified.SplitContainer.prototype.setSecondaryContentWidth = function(sSize) {
	this.setProperty("secondaryContentWidth", sSize, true);
	this._applySecondaryContentSize();
	return this;
};


	/////////////////////////////////// Aggregation "content" //////////////////////////////////

sap.ui.unified.SplitContainer.prototype.insertContent = function(oContent, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("content", oContent, iIndex, bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.addContent = function(oContent) {
	return this._mod(function(bRendered){
		return this.addAggregation("content", oContent, bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeContent = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("content", vIndex, bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeAllContent = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("content", bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.destroyContent = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("content", bRendered);
	}, this._canvasRenderer);
};


    ////////////////////////////// Aggregation "secondaryContent" //////////////////////////////

sap.ui.unified.SplitContainer.prototype.insertSecondaryContent = function(oContent, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("secondaryContent", oContent, iIndex, bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.addSecondaryContent = function(oContent) {
	return this._mod(function(bRendered){
		return this.addAggregation("secondaryContent", oContent, bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeSecondaryContent = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("secondaryContent", vIndex, bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeAllSecondaryContent = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("secondaryContent", bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.destroySecondaryContent = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("secondaryContent", bRendered);
	}, this._paneRenderer);
};


})(window);

}; // end of sap/ui/unified/SplitContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Shell') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.Shell.
jQuery.sap.declare("sap.ui.unified.Shell");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Shell.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getShowPane showPane} : boolean</li>
 * <li>{@link #getShowCurtain showCurtain} : boolean</li>
 * <li>{@link #getShowCurtainPane showCurtainPane} : boolean</li>
 * <li>{@link #getHeaderHiding headerHiding} : boolean</li>
 * <li>{@link #getSearchVisible searchVisible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getPaneContent paneContent} : sap.ui.core.Control[]</li>
 * <li>{@link #getCurtainContent curtainContent} : sap.ui.core.Control[]</li>
 * <li>{@link #getCurtainPaneContent curtainPaneContent} : sap.ui.core.Control[]</li>
 * <li>{@link #getHeadItems headItems} : sap.ui.unified.ShellHeadItem[]</li>
 * <li>{@link #getHeadEndItems headEndItems} : sap.ui.unified.ShellHeadItem[]</li>
 * <li>{@link #getSearch search} : sap.ui.core.Control</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The Shell
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.15.1
 * @name sap.ui.unified.Shell
 */
sap.ui.core.Control.extend("sap.ui.unified.Shell", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.ui.unified",
	properties : {
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"showPane" : {type : "boolean", group : "Appearance", defaultValue : null},
		"showCurtain" : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true},
		"showCurtainPane" : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true},
		"headerHiding" : {type : "boolean", group : "Appearance", defaultValue : null},
		"searchVisible" : {type : "boolean", group : "Appearance", defaultValue : true}
	},
	defaultAggregation : "content",
	aggregations : {
    	"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
    	"paneContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "paneContent"}, 
    	"curtainContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "curtainContent"}, 
    	"curtainPaneContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "curtainPaneContent"}, 
    	"headItems" : {type : "sap.ui.unified.ShellHeadItem", multiple : true, singularName : "headItem"}, 
    	"headEndItems" : {type : "sap.ui.unified.ShellHeadItem", multiple : true, singularName : "headEndItem"}, 
    	"search" : {type : "sap.ui.core.Control", multiple : false}, 
    	"canvasSplitContainer" : {type : "sap.ui.unified.SplitContainer", multiple : false, visibility : "hidden"}, 
    	"curtainSplitContainer" : {type : "sap.ui.unified.SplitContainer", multiple : false, visibility : "hidden"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.Shell with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.Shell.extend
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * The application icon.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.unified.Shell#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setIcon
 * @function
 */


/**
 * Getter for property <code>showPane</code>.
 * Shows / Hides the side pane.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showPane</code>
 * @public
 * @name sap.ui.unified.Shell#getShowPane
 * @function
 */

/**
 * Setter for property <code>showPane</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowPane  new value for property <code>showPane</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setShowPane
 * @function
 */


/**
 * Getter for property <code>showCurtain</code>.
 * Shows / Hides the curtain.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showCurtain</code>
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#getShowCurtain
 * @function
 */

/**
 * Setter for property <code>showCurtain</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowCurtain  new value for property <code>showCurtain</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#setShowCurtain
 * @function
 */


/**
 * Getter for property <code>showCurtainPane</code>.
 * Shows / Hides the side pane on the curtain.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showCurtainPane</code>
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#getShowCurtainPane
 * @function
 */

/**
 * Setter for property <code>showCurtainPane</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowCurtainPane  new value for property <code>showCurtainPane</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#setShowCurtainPane
 * @function
 */


/**
 * Getter for property <code>headerHiding</code>.
 * Whether the header can be hidden (manually or automatically). This feature is only available when touch events are supported.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>headerHiding</code>
 * @public
 * @name sap.ui.unified.Shell#getHeaderHiding
 * @function
 */

/**
 * Setter for property <code>headerHiding</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bHeaderHiding  new value for property <code>headerHiding</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setHeaderHiding
 * @function
 */


/**
 * Getter for property <code>searchVisible</code>.
 * If set to false, the search area (aggregation 'search') is hidden.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>searchVisible</code>
 * @public
 * @since 1.18
 * @name sap.ui.unified.Shell#getSearchVisible
 * @function
 */

/**
 * Setter for property <code>searchVisible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bSearchVisible  new value for property <code>searchVisible</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @since 1.18
 * @name sap.ui.unified.Shell#setSearchVisible
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content to appear in the main canvas.
 * 
 * <strong>Note</strong>: this is the default aggregation for Shell.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.unified.Shell#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>paneContent</code>.<br/>
 * The content to appear in the pane area.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getPaneContent
 * @function
 */


/**
 * Inserts a paneContent into the aggregation named <code>paneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oPaneContent the paneContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the paneContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the paneContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the paneContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertPaneContent
 * @function
 */

/**
 * Adds some paneContent <code>oPaneContent</code> 
 * to the aggregation named <code>paneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oPaneContent the paneContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addPaneContent
 * @function
 */

/**
 * Removes an paneContent from the aggregation named <code>paneContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vPaneContent the paneContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed paneContent or null
 * @public
 * @name sap.ui.unified.Shell#removePaneContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>paneContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllPaneContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>paneContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oPaneContent the paneContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfPaneContent
 * @function
 */
	

/**
 * Destroys all the paneContent in the aggregation 
 * named <code>paneContent</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyPaneContent
 * @function
 */


/**
 * Getter for aggregation <code>curtainContent</code>.<br/>
 * The content to appear in the curtain area.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getCurtainContent
 * @function
 */


/**
 * Inserts a curtainContent into the aggregation named <code>curtainContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oCurtainContent the curtainContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the curtainContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the curtainContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the curtainContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertCurtainContent
 * @function
 */

/**
 * Adds some curtainContent <code>oCurtainContent</code> 
 * to the aggregation named <code>curtainContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainContent the curtainContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addCurtainContent
 * @function
 */

/**
 * Removes an curtainContent from the aggregation named <code>curtainContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vCurtainContent the curtainContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed curtainContent or null
 * @public
 * @name sap.ui.unified.Shell#removeCurtainContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>curtainContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllCurtainContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>curtainContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainContent the curtainContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfCurtainContent
 * @function
 */
	

/**
 * Destroys all the curtainContent in the aggregation 
 * named <code>curtainContent</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyCurtainContent
 * @function
 */


/**
 * Getter for aggregation <code>curtainPaneContent</code>.<br/>
 * The content to appear in the pane area of the curtain.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getCurtainPaneContent
 * @function
 */


/**
 * Inserts a curtainPaneContent into the aggregation named <code>curtainPaneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oCurtainPaneContent the curtainPaneContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the curtainPaneContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the curtainPaneContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the curtainPaneContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertCurtainPaneContent
 * @function
 */

/**
 * Adds some curtainPaneContent <code>oCurtainPaneContent</code> 
 * to the aggregation named <code>curtainPaneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainPaneContent the curtainPaneContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addCurtainPaneContent
 * @function
 */

/**
 * Removes an curtainPaneContent from the aggregation named <code>curtainPaneContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vCurtainPaneContent the curtainPaneContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed curtainPaneContent or null
 * @public
 * @name sap.ui.unified.Shell#removeCurtainPaneContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>curtainPaneContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllCurtainPaneContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>curtainPaneContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainPaneContent the curtainPaneContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfCurtainPaneContent
 * @function
 */
	

/**
 * Destroys all the curtainPaneContent in the aggregation 
 * named <code>curtainPaneContent</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyCurtainPaneContent
 * @function
 */


/**
 * Getter for aggregation <code>headItems</code>.<br/>
 * The buttons shown in the begin (left in left-to-right case) of the Shell header. Currently max. 3 buttons are supported.
 * 
 * @return {sap.ui.unified.ShellHeadItem[]}
 * @public
 * @name sap.ui.unified.Shell#getHeadItems
 * @function
 */


/**
 * Inserts a headItem into the aggregation named <code>headItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *          oHeadItem the headItem to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the headItem should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the headItem is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the headItem is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertHeadItem
 * @function
 */

/**
 * Adds some headItem <code>oHeadItem</code> 
 * to the aggregation named <code>headItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadItem the headItem to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addHeadItem
 * @function
 */

/**
 * Removes an headItem from the aggregation named <code>headItems</code>.
 *
 * @param {int | string | sap.ui.unified.ShellHeadItem} vHeadItem the headItem to remove or its index or id
 * @return {sap.ui.unified.ShellHeadItem} the removed headItem or null
 * @public
 * @name sap.ui.unified.Shell#removeHeadItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>headItems</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.ShellHeadItem[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllHeadItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.ShellHeadItem</code> in the aggregation named <code>headItems</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadItem the headItem whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfHeadItem
 * @function
 */
	

/**
 * Destroys all the headItems in the aggregation 
 * named <code>headItems</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyHeadItems
 * @function
 */


/**
 * Getter for aggregation <code>headEndItems</code>.<br/>
 * The buttons shown in the end (right in left-to-right case) of the Shell header. Currently max. 3 buttons are supported.
 * 
 * @return {sap.ui.unified.ShellHeadItem[]}
 * @public
 * @name sap.ui.unified.Shell#getHeadEndItems
 * @function
 */


/**
 * Inserts a headEndItem into the aggregation named <code>headEndItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *          oHeadEndItem the headEndItem to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the headEndItem should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the headEndItem is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the headEndItem is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertHeadEndItem
 * @function
 */

/**
 * Adds some headEndItem <code>oHeadEndItem</code> 
 * to the aggregation named <code>headEndItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadEndItem the headEndItem to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addHeadEndItem
 * @function
 */

/**
 * Removes an headEndItem from the aggregation named <code>headEndItems</code>.
 *
 * @param {int | string | sap.ui.unified.ShellHeadItem} vHeadEndItem the headEndItem to remove or its index or id
 * @return {sap.ui.unified.ShellHeadItem} the removed headEndItem or null
 * @public
 * @name sap.ui.unified.Shell#removeHeadEndItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>headEndItems</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.ShellHeadItem[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllHeadEndItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.ShellHeadItem</code> in the aggregation named <code>headEndItems</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadEndItem the headEndItem whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfHeadEndItem
 * @function
 */
	

/**
 * Destroys all the headEndItems in the aggregation 
 * named <code>headEndItems</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyHeadEndItems
 * @function
 */


/**
 * Getter for aggregation <code>search</code>.<br/>
 * Experimental (This aggregation might change in future!): The search control which should be displayed in the shell header.
 * 
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.ui.unified.Shell#getSearch
 * @function
 */


/**
 * Setter for the aggregated <code>search</code>.
 * @param {sap.ui.core.Control} oSearch
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setSearch
 * @function
 */
	

/**
 * Destroys the search in the aggregation 
 * named <code>search</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroySearch
 * @function
 */


// Start of sap\ui\unified\Shell.js
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained

jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained

jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained


jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


sap.ui.unified.Shell._SIDEPANE_WIDTH_PHONE = 208;
sap.ui.unified.Shell._SIDEPANE_WIDTH_TABLET = 208;
sap.ui.unified.Shell._SIDEPANE_WIDTH_DESKTOP = 240;
sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE = true; /*Whether header hiding is technically possible (touch enabled)*/
sap.ui.unified.Shell._HEADER_AUTO_CLOSE = true;
sap.ui.unified.Shell._HEADER_TOUCH_TRESHOLD = 30;
	
sap.ui.unified.Shell.prototype.init = function(){
	var that = this;
	
	this._rtl = sap.ui.getCore().getConfiguration().getRTL();
	this._animation = sap.ui.getCore().getConfiguration().getAnimation();
	this._showHeader = true;
	this._iHeaderHidingDelay = 3000; /*Currently hidden but maybe a property later (see getter and setter below)*/
	
	this._cont = new sap.ui.unified.SplitContainer(this.getId()+"-container");
	this._cont._bRootContent = true; // see e.g. sap.m.App#onAfterRendering
	this.setAggregation("canvasSplitContainer", this._cont, true);
	
	this._curtCont = new sap.ui.unified.SplitContainer(this.getId()+"-curt-container");
	this._curtCont._bRootContent = true; // see e.g. sap.m.App#onAfterRendering
	this.setAggregation("curtainSplitContainer", this._curtCont, true);
	
	function _setSidePaneWidth(sRange){
		if(!sRange){
			sRange = sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD).name;
		}
		
		var w = sap.ui.unified.Shell["_SIDEPANE_WIDTH_"+sRange.toUpperCase()]+"px";
		that._cont.setSecondaryContentWidth(w);
		that._curtCont.setSecondaryContentWidth(w);
	};
	
	_setSidePaneWidth();

	this._handleMediaChange = function(mParams){
		if(!that.getDomRef()){
			return;
		}
		
		_setSidePaneWidth(mParams.name);
		
		that._refreshHeader();
	};
	
	sap.ui.Device.media.attachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
	
	function __refreshHeader(){
		that._refreshHeader();
	};
	
	this._headCenterRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-center", function(rm){
		sap.ui.unified.ShellRenderer.renderSearch(rm, that);
	}, __refreshHeader);
	
	this._headBeginRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-begin", function(rm){
		sap.ui.unified.ShellRenderer.renderHeaderItems(rm, that, true);
	}, __refreshHeader);
	
	this._headEndRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-end", function(rm){
		sap.ui.unified.ShellRenderer.renderHeaderItems(rm, that, false);
	}, __refreshHeader);
};


sap.ui.unified.Shell.prototype.exit = function(){
	sap.ui.Device.media.detachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
	delete this._handleMediaChange;
	
	this._headCenterRenderer.destroy();
	delete this._headCenterRenderer;
	this._headBeginRenderer.destroy();
	delete this._headBeginRenderer;
	this._headEndRenderer.destroy();
	delete this._headEndRenderer;
	
	delete this._cont; //Destroy of child controls done via aggregation handling
	delete this._curtCont;
};


sap.ui.unified.Shell.prototype.onAfterRendering = function(){
	var that = this;
	
	if(window.addEventListener && !sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE){
		function headerFocus(oBrowserEvent){
			var oEvent = jQuery.event.fix(oBrowserEvent);
			if(jQuery.sap.containsOrEquals(that.getDomRef("hdr"), oEvent.target)){
				that._timedHideHeader(oEvent.type === "focus");
			}
		};
		
		var oHdr = this.getDomRef("hdr");
		oHdr.addEventListener("focus", headerFocus, true);
		oHdr.addEventListener("blur", headerFocus, true);
	}
	
	this._refreshAfterRendering();
	
	this.$("hdr-center").toggleClass("sapUiUfdShellAnim", !this._noHeadCenterAnim);
};


sap.ui.unified.Shell.prototype.onThemeChanged = function(){
	if(this._refreshAfterRendering() && this._headBeginRenderer){
		this._headBeginRenderer.render(); //Refresh Company Logo
	}
};

sap.ui.unified.Shell.prototype.onfocusin = function(oEvent) {
	var sId = this.getId();
	
	if (oEvent.target.id === sId + "-curt-focusDummyOut") {
		// Jump back to shell when you reach the end of the curtain
		jQuery.sap.focus(this.$("hdrcntnt").firstFocusableDomRef());
	} else if (oEvent.target.id === sId + "-main-focusDummyOut") {
		// Jump to the curtain if it is open (can only reached by tabbing back when curtain is open)
		jQuery.sap.focus(this.$("curtcntnt").firstFocusableDomRef());
	}
};




(function(){

if(sap.ui.Device.support.touch){
	
	sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE = false;
		
	function _updateHeader(oShell){
		if(oShell._startY === undefined || oShell._currY === undefined){
			return;
		}
		
		var yMove = oShell._currY - oShell._startY;
		if(Math.abs(yMove) > sap.ui.unified.Shell._HEADER_TOUCH_TRESHOLD){
			oShell._doShowHeader(yMove > 0);
			oShell._startY = oShell._currY;
		}
	};
	
	sap.ui.unified.Shell.prototype.ontouchstart = function(oEvent){
		this._startY = oEvent.touches[0].pageY;
		if(this._startY > 2*48){ /*Only when touch starts "nearby" the header*/
			this._startY = undefined;
		}
		this._currY = this._startY;
	};
	
	sap.ui.unified.Shell.prototype.ontouchend = function(oEvent){
		_updateHeader(this);
		this._startY = undefined;
		this._currY = undefined;
	};
	
	sap.ui.unified.Shell.prototype.ontouchmove = function(oEvent){
		this._currY = oEvent.touches[0].pageY;
		_updateHeader(this);
	};
	
}

})();


// ***************** API / Overridden generated API *****************


sap.ui.unified.Shell.prototype.setHeaderHiding = function(bEnabled){
	bEnabled = !!bEnabled;
	return this._mod(function(bRendered){
		return this.setProperty("headerHiding", bEnabled, bRendered);
	}, function(){
		this._doShowHeader(!bEnabled ? true : this._showHeader);
	});
};


/*Not public, Maybe API later*/
sap.ui.unified.Shell.prototype.setHeaderHidingDelay = function(iDelay){
	this._iHeaderHidingDelay = iDelay;
	return this;
};


/*Not public, Maybe API later*/
sap.ui.unified.Shell.prototype.getHeaderHidingDelay = function(){
	return this._iHeaderHidingDelay;
};


sap.ui.unified.Shell.prototype.getShowPane = function(){
	return this._cont.getShowSecondaryContent();
};


sap.ui.unified.Shell.prototype.setShowPane = function(bShowPane){
	this._cont.setShowSecondaryContent(bShowPane);
	this.setProperty("showPane", !!bShowPane, true);
	return this;
};


sap.ui.unified.Shell.prototype.getShowPane = function(){
	return this._cont.getShowSecondaryContent();
};


sap.ui.unified.Shell.prototype.setShowCurtainPane = function(bShowPane){
	this._curtCont.setShowSecondaryContent(bShowPane);
	this.setProperty("showCurtainPane", !!bShowPane, true);
	return this;
};


sap.ui.unified.Shell.prototype.getShowCurtainPane = function(){
	return this._curtCont.getShowSecondaryContent();
};


sap.ui.unified.Shell.prototype.setShowCurtain = function(bShowCurtain){
	bShowCurtain = !!bShowCurtain;
	
	return this._mod(function(bRendered){
		return this.setProperty("showCurtain", bShowCurtain, bRendered);
	}, function(){
		this.$("main-focusDummyOut").attr("tabindex", bShowCurtain ? 0 : -1);
		this.$().toggleClass("sapUiUfdShellCurtainHidden", !bShowCurtain).toggleClass("sapUiUfdShellCurtainVisible", bShowCurtain);
		
		if(bShowCurtain){
			var zIndex = sap.ui.core.Popup.getNextZIndex();
			this.$("curt").css("z-index", zIndex+1);
			this.$("hdr").css("z-index", zIndex+3);
			this.$("brand").css("z-index", zIndex+7);
			this.$().toggleClass("sapUiUfdShellCurtainClosed", false);
		}
		
		this._timedCurtainClosed(bShowCurtain);
		
		this._doShowHeader(true);
	});
};


sap.ui.unified.Shell.prototype.setIcon = function(sIcon){
	return this._mod(function(bRendered){
		return this.setProperty("icon", sIcon, bRendered);
	}, this._headBeginRenderer);
};


sap.ui.unified.Shell.prototype.setSearchVisible = function(bSearchVisible){
	return this._mod(function(bRendered){
		return this.setProperty("searchVisible", !!bSearchVisible, bRendered);
	}, this._headCenterRenderer);
};


sap.ui.unified.Shell.prototype.setSearch = function(oSearch){
	return this._mod(function(bRendered){
		return this.setAggregation("search", oSearch, bRendered);
	}, this._headCenterRenderer);
};


sap.ui.unified.Shell.prototype.getContent = function() {
	return this._cont.getContent();
};
sap.ui.unified.Shell.prototype.insertContent = function(oContent, iIndex) {
	this._cont.insertContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addContent = function(oContent) {
	this._cont.addContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removeContent = function(vIndex) {
	return this._cont.removeContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllContent = function() {
	return this._cont.removeAllContent();
};
sap.ui.unified.Shell.prototype.destroyContent = function() {
	this._cont.destroyContent();
	return this;
};


sap.ui.unified.Shell.prototype.getPaneContent = function() {
	return this._cont.getSecondaryContent();
};
sap.ui.unified.Shell.prototype.insertPaneContent = function(oContent, iIndex) {
	this._cont.insertSecondaryContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addPaneContent = function(oContent) {
	this._cont.addSecondaryContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removePaneContent = function(vIndex) {
	return this._cont.removeSecondaryContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllPaneContent = function() {
	return this._cont.removeAllSecondaryContent();
};
sap.ui.unified.Shell.prototype.destroyPaneContent = function() {
	this._cont.destroySecondaryContent();
	return this;
};


sap.ui.unified.Shell.prototype.getCurtainContent = function() {
	return this._curtCont.getContent();
};
sap.ui.unified.Shell.prototype.insertCurtainContent = function(oContent, iIndex) {
	this._curtCont.insertContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addCurtainContent = function(oContent) {
	this._curtCont.addContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removeCurtainContent = function(vIndex) {
	return this._curtCont.removeContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllCurtainContent = function() {
	return this._curtCont.removeAllContent();
};
sap.ui.unified.Shell.prototype.destroyCurtainContent = function() {
	this._curtCont.destroyContent();
	return this;
};


sap.ui.unified.Shell.prototype.getCurtainPaneContent = function() {
	return this._curtCont.getSecondaryContent();
};
sap.ui.unified.Shell.prototype.insertCurtainPaneContent = function(oContent, iIndex) {
	this._curtCont.insertSecondaryContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addCurtainPaneContent = function(oContent) {
	this._curtCont.addSecondaryContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removeCurtainPaneContent = function(vIndex) {
	return this._curtCont.removeSecondaryContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllCurtainPaneContent = function() {
	return this._curtCont.removeAllSecondaryContent();
};
sap.ui.unified.Shell.prototype.destroyCurtainPaneContent = function() {
	this._curtCont.destroySecondaryContent();
	return this;
};


sap.ui.unified.Shell.prototype.insertHeadItem = function(oHeadItem, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("headItems", oHeadItem, iIndex, bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.addHeadItem = function(oHeadItem) {
	return this._mod(function(bRendered){
		return this.addAggregation("headItems", oHeadItem, bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.removeHeadItem = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("headItems", vIndex, bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.removeAllHeadItems = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("headItems", bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.destroyHeadItems = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("headItems", bRendered);
	}, this._headBeginRenderer);
};


sap.ui.unified.Shell.prototype.insertHeadEndItem = function(oHeadItem, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("headEndItems", oHeadItem, iIndex, bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.addHeadEndItem = function(oHeadItem) {
	return this._mod(function(bRendered){
		return this.addAggregation("headEndItems", oHeadItem, bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.removeHeadEndItem = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("headEndItems", vIndex, bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.removeAllHeadEndItems = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("headEndItems", bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.destroyHeadEndItems = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("headEndItems", bRendered);
	}, this._headEndRenderer);
};


// ***************** Private Helpers *****************


sap.ui.unified.Shell.prototype._doShowHeader = function(bShow){
	this._showHeader = this._isHeaderHidingActive() ? !!bShow : true;
	
	this.$().toggleClass("sapUiUfdShellHeadHidden", !this._showHeader).toggleClass("sapUiUfdShellHeadVisible", this._showHeader);
	
	if(this._showHeader){
		this._timedHideHeader();
	}
};

sap.ui.unified.Shell.prototype._timedHideHeader = function(bClearOnly){
	if(this._headerHidingTimer){
		jQuery.sap.clearDelayedCall(this._headerHidingTimer);
		this._headerHidingTimer = null;
	}
	
	if(bClearOnly || !sap.ui.unified.Shell._HEADER_AUTO_CLOSE || !this._isHeaderHidingActive() || this._iHeaderHidingDelay <= 0){
		return;
	}
	
	this._headerHidingTimer = jQuery.sap.delayedCall(this._iHeaderHidingDelay, this, function(){
		if(this._isHeaderHidingActive() && this._iHeaderHidingDelay > 0 && !jQuery.sap.containsOrEquals(this.getDomRef("hdr"), document.activeElement)){
			this._doShowHeader(false);
		}
	});
};

sap.ui.unified.Shell.prototype._timedCurtainClosed = function(bClearOnly){
	if(this._curtainClosedTimer){
		jQuery.sap.clearDelayedCall(this._curtainClosedTimer);
		this._curtainClosedTimer = null;
	}
	
	if(bClearOnly){
		return;
	}
	
	var duration = parseInt(sap.ui.core.theming.Parameters.get("sapUiUfdShellAnimDuration"), 10);
	if(!this._animation || (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10)){
		duration = 0;
	}
	
	this._curtainClosedTimer = jQuery.sap.delayedCall(duration, this, function(){
		this._curtainClosedTimer = null;
		this.$("curt").css("z-index", "");
		this.$("hdr").css("z-index", "");
		this.$("brand").css("z-index", "");
		this.$().toggleClass("sapUiUfdShellCurtainClosed", true);
	});
};


sap.ui.unified.Shell.prototype._mod = function(fMod, oDoIfRendered){
	var bRendered = !!this.getDomRef();
	var res = fMod.apply(this, [bRendered]);
	if(bRendered && oDoIfRendered){
		if(oDoIfRendered instanceof sap.ui.unified._ContentRenderer){
			oDoIfRendered.render();
		}else{
			oDoIfRendered.apply(this);
		}
	}
	return res;
};


sap.ui.unified.Shell.prototype._refreshHeader = function(){
	function updateItems(aItems){
		for(var i=0; i<aItems.length; i++){
			aItems[i]._refreshIcon();
		}
	}
	
	updateItems(this.getHeadItems());
	updateItems(this.getHeadEndItems());
	
	var isPhoneSize = jQuery("html").hasClass("sapUiMedia-Std-Phone"),
		searchVisible = !this.$("hdr-search").hasClass("sapUiUfdShellHidden"),
		$logo = this.$("icon");
	
	$logo.parent().toggleClass("sapUiUfdShellHidden", isPhoneSize && searchVisible);
	
	var	we = this.$("hdr-end").outerWidth(),
		wb = this.$("hdr-begin").outerWidth(),
		wmax = Math.max(we, wb),
		begin = (isPhoneSize && searchVisible ? wb : wmax)+"px",
		end = (isPhoneSize && searchVisible ? we : wmax)+"px";

	this.$("hdr-center").css({
		"left": this._rtl ? end : begin,
		"right": this._rtl ? begin : end
	});
};


sap.ui.unified.Shell.prototype._getIcon = function(){
	var ico = this.getIcon();
	if(!ico){
		//see sap.m.Shell
		jQuery.sap.require("sap.ui.core.theming.Parameters");
		ico = sap.ui.core.theming.Parameters.get("sapUiGlobalLogo"); // theme logo
		if(ico){
			var match = /url[\s]*\('?"?([^\'")]*)'?"?\)/.exec(ico);
			if(match){
				ico = match[1];
			}else if(ico === "''"){ // theme default
				ico = null;
			}
		}
	}
	
	return ico || sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif');
};


sap.ui.unified.Shell.prototype._refreshAfterRendering = function(){
	var oDom = this.getDomRef();
	
	if(!oDom){
		return false;
	}

	this._repaint(oDom);
	this._refreshHeader();
	
	this._timedHideHeader();
	
	return true;
};


sap.ui.unified.Shell.prototype._repaint = function(oDom){
	if(sap.ui.Device.browser.webkit){
		var display = oDom.style.display;
		oDom.style.display = "none";
		oDom.offsetHeight;
		oDom.style.display = display;
	}
};

sap.ui.unified.Shell.prototype._isHeaderHidingActive = function(){
	// Not active if no touch, the curtain is open or the hiding is deactivated via API
	if(sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE || this.getShowCurtain() || !this.getHeaderHiding() || sap.ui.unified._iNumberOfOpenedShellOverlays > 0){
		return false;
	}
	return true;
};


//***************** Avoid Rerendering *****************


sap.ui.unified.Shell.prototype.invalidate = function(oOrigin) {
	if(oOrigin instanceof sap.ui.unified.ShellHeadItem && this._headBeginRenderer && this._headEndRenderer){
		this._headBeginRenderer.render();
		this._headEndRenderer.render();
	}else{
		sap.ui.core.Control.prototype.invalidate.apply(this, arguments);
	}
};



}; // end of sap/ui/unified/Shell.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellOverlay') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.ShellOverlay.
jQuery.sap.declare("sap.ui.unified.ShellOverlay");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ShellOverlay.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getSearch search} : sap.ui.core.Control</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getShell shell} : string | sap.ui.unified.Shell</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.ShellOverlay#event:closed closed} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ShellOverlay to be opened in front of a sap.ui.unified.Shell
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.16.3
 * @name sap.ui.unified.ShellOverlay
 */
sap.ui.core.Control.extend("sap.ui.unified.ShellOverlay", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.ui.unified",
	defaultAggregation : "content",
	aggregations : {
    	"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
    	"search" : {type : "sap.ui.core.Control", multiple : false}
	},
	associations : {
		"shell" : {type : "sap.ui.unified.Shell", multiple : false}
	},
	events : {
		"closed" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.ShellOverlay with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.ShellOverlay.extend
 * @function
 */

sap.ui.unified.ShellOverlay.M_EVENTS = {'closed':'closed'};


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content to appear in the overlay.
 * 
 * <strong>Note</strong>: this is the default aggregation for ShellOverlay.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.ShellOverlay#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.unified.ShellOverlay#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.ShellOverlay#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.ShellOverlay#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>search</code>.<br/>
 * Experimental (This aggregation might change in future!): The search control which should be displayed in the overlay header.
 * 
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.ui.unified.ShellOverlay#getSearch
 * @function
 */


/**
 * Setter for the aggregated <code>search</code>.
 * @param {sap.ui.core.Control} oSearch
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#setSearch
 * @function
 */
	

/**
 * Destroys the search in the aggregation 
 * named <code>search</code>.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#destroySearch
 * @function
 */


/**
 * Reference to the sap.ui.unified.Shell control.
 *
 * @return {string} Id of the element which is the current target of the <code>shell</code> association, or null
 * @public
 * @name sap.ui.unified.ShellOverlay#getShell
 * @function
 */

/**
 * Reference to the sap.ui.unified.Shell control.
 *
 * @param {string | sap.ui.unified.Shell} vShell 
 *    Id of an element which becomes the new target of this <code>shell</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#setShell
 * @function
 */


	
/**
 * Fired when the overlay was closed. 
 *
 * @name sap.ui.unified.ShellOverlay#closed
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'closed' event of this <code>sap.ui.unified.ShellOverlay</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.ShellOverlay</code>.<br/> itself. 
 *  
 * Fired when the overlay was closed. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.ShellOverlay</code>.<br/> itself.
 *
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#attachClosed
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'closed' event of this <code>sap.ui.unified.ShellOverlay</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#detachClosed
 * @function
 */

/**
 * Fire event closed to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.ShellOverlay#fireClosed
 * @function
 */


// Start of sap\ui\unified\ShellOverlay.js
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained

jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained


jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained


/**** API ****/

/**
 * Opens the ShellOverlay.
 *
 * @public
 */
sap.ui.unified.ShellOverlay.prototype.open = function(){
	if(this._getPopup().isOpen()){
		return;
	}

	this._opening = true;
	this._forceShellHeaderVisible();
	this._getPopup().setModal(true, sap.ui.core.Popup.blStack.length == 0 && this._getAnimActive() ? "sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp" : "");
	this._getPopup().open(0, sap.ui.core.Popup.Dock.BeginTop, sap.ui.core.Popup.Dock.BeginTop, window, "0 0", "none");
	var oSearch = this.getSearch();
	if(oSearch){
		oSearch.focus();
	}
	this._opening = false;
	
	if(this._getAnimActive()){
		jQuery.sap.delayedCall(50, this, function(){
			jQuery.sap.byId("sap-ui-blocklayer-popup").toggleClass("sapUiUfdShellOvrlyBlyTp", false);
		});
	}
	
	jQuery.sap.delayedCall(this._getAnimDuration(true), this, function(){
		this.$().toggleClass("sapUiUfdShellOvrlyOpening", false);
	});
};

/**
 * Closes the ShellOverlay.
 *
 * @public
 */
sap.ui.unified.ShellOverlay.prototype.close = function(){
	if(!this._getPopup().isOpen()){
		return;
	}
	
	this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden", true).toggleClass("sapUiUfdShellOvrlyClosing", true);
	
	this._setSearchWidth();
	
	jQuery.sap.delayedCall(Math.max(this._getAnimDuration(false) - this._getBLAnimDuration(), 0), this, function(){
		var $Bl = jQuery.sap.byId("sap-ui-blocklayer-popup");
		if(sap.ui.core.Popup.blStack.length == 1 && this._getAnimActive() && $Bl.hasClass("sapUiUfdShellOvrlyBly")){
			$Bl.toggleClass("sapUiUfdShellOvrlyBlyTp", true);
		}
	});
	
	jQuery.sap.delayedCall(this._getAnimDuration(false), this, function(){
		this._getPopup().close(0);
		this.$().remove();
		this._forceShellHeaderVisible();
		this.fireClosed();
	});
};

sap.ui.unified.ShellOverlay.prototype.setShell = function(vShell){
	return this.setAssociation("shell", vShell, true);
};

sap.ui.unified.ShellOverlay.prototype.setSearch = function(oSearch){
	this.setAggregation("search", oSearch, true);
	if(!!this.getDomRef()){
		this._headRenderer.render();
	}
	return this;
};

sap.ui.unified.ShellOverlay.prototype.insertContent = function(oContent, iIndex) {
	var res = this.insertAggregation("content", oContent, iIndex, true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.addContent = function(oContent) {
	var res = this.addAggregation("content", oContent, true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.removeContent = function(vIndex) {
	var res = this.removeAggregation("content", vIndex, true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.removeAllContent = function() {
	var res = this.removeAllAggregation("content", true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.destroyContent = function() {
	var res = this.destroyAggregation("content", true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};


/**** Private ****/

sap.ui.unified.ShellOverlay.prototype.init = function(){
	this._animOpenDuration = -1;
	this._animCloseDuration = -1;
	this._animBlockLayerDuration = -1;
	this._animation = sap.ui.getCore().getConfiguration().getAnimation();
	this._opening = false;
	
	var that = this;
	
	this._headRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-center", function(rm){
		sap.ui.unified.ShellOverlayRenderer.renderSearch(rm, that);
	});
	this._contentRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-cntnt", function(rm){
		sap.ui.unified.ShellOverlayRenderer.renderContent(rm, that);
	});
};

sap.ui.unified.ShellOverlay.prototype.exit = function(){
	if(this._popup){
		this._popup.close(0);
		this._popup.destroy();
		this._popup = null;
	}
	
	this._getPopup = function(){return null;};
	this._headRenderer.destroy();
	delete this._headRenderer;
	this._contentRenderer.destroy();
	delete this._contentRenderer;
};

sap.ui.unified.ShellOverlay.prototype.onAfterRendering = function(){
	if(this._opening){
		this._setSearchWidth();
	}
	
	jQuery.sap.delayedCall(10, this, function(){
		this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden", false);
		this.$("search").css("width", "");
	});
};

sap.ui.unified.ShellOverlay.prototype.onclick = function(oEvent){
	if(jQuery(oEvent.target).attr("id") === this.getId()+"-close"){
		this.close();
	}
};

sap.ui.unified.ShellOverlay.prototype.onThemeChanged = function(){
	this._animOpenDuration = -1;
	this._animCloseDuration = -1;
	this._animBlockLayerDuration = -1;
};


/**** Private Helpers ****/

sap.ui.unified.ShellOverlay.prototype._getAnimDurationThemeParam = function(sParam, bClearIfNotActive){
	var val = parseInt(sap.ui.core.theming.Parameters.get(sParam), 10);
	if(!this._getAnimActive() && bClearIfNotActive){
		val = 0;
	}
	return val;
};

sap.ui.unified.ShellOverlay.prototype._getAnimDuration = function(bOpen){
	if((bOpen && this._animOpenDuration == -1) || (!bOpen && this._animCloseDuration == -1)){
		var sTxt = bOpen ? "Open" : "Close";
		this["_anim"+sTxt+"Duration"] = this._getAnimDurationThemeParam("sapUiUfdShellOvrly"+sTxt+"AnimOverAll", true);
	}
	return bOpen ? this._animOpenDuration : this._animCloseDuration;
};

sap.ui.unified.ShellOverlay.prototype._getBLAnimDuration = function(){
	if(this._animBlockLayerDuration == -1){
		this._animBlockLayerDuration = this._getAnimDurationThemeParam("sapUiUfdShellOvrlyBlockLayerAnimDuration", true);
	}
	return this._animBlockLayerDuration;
};

sap.ui.unified.ShellOverlay.prototype._getAnimActive = function(){
	if(!this._animation || (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10)){
		return false;
	}
	return true;
};

sap.ui.unified.ShellOverlay.prototype._getPopup = function(){
	if(!this._popup){
		this._popup = new sap.ui.core.Popup(this, true, false, false);
		this._popup._applyPosition = function(oPosition) {
			this._$().css("left", "0").css("top", "0");
			this._oLastPosition = oPosition;
			this._oLastOfRect = jQuery(window).rect();
		};
		this._popup.attachOpened(function(){
			sap.ui.unified._iNumberOfOpenedShellOverlays++;
		});
		this._popup.attachClosed(function(){
			sap.ui.unified._iNumberOfOpenedShellOverlays--;
		});
	}
	return this._popup;
};

sap.ui.unified.ShellOverlay.prototype._getShell = function(){
	var sId = this.getShell();
	if(!sId){
		return;
	}
	var oShell = sap.ui.getCore().byId(sId);
	if(!oShell || !(oShell instanceof sap.ui.unified.Shell)){
		return;
	}
	return oShell;
};

sap.ui.unified.ShellOverlay.prototype._forceShellHeaderVisible = function(){
	var oShell = this._getShell();
	if(oShell){
		oShell._doShowHeader(true);
	}
};

sap.ui.unified.ShellOverlay.prototype._getSearchWidth = function(){
	var sShellId = this.getShell();
	if(!sShellId){
		return -1;
	}
	var $ShellSearchArea = jQuery.sap.byId(sShellId+"-hdr-center").children();
	if($ShellSearchArea.length){
		return $ShellSearchArea.width();
	}
	return -1;
};

sap.ui.unified.ShellOverlay.prototype._setSearchWidth = function(){
	var iWidth = this._getSearchWidth();
	if(iWidth <= 0){
		return;
	}
	
	var sWidth = iWidth+"px";
	
	if(sap.ui.Device.browser.safari){
		//Safari doesn't support width transition based on different units -> so px must be replaced by %
		var iTotalWidth = this.$("hdr-center").width();
		if(iTotalWidth > iWidth){
			sWidth = Math.round((iWidth*100)/iTotalWidth) + "%";
		}else{
			sWidth = "100%";
		}
	}
	
	this.$("search").css("width", sWidth);
};



}; // end of sap/ui/unified/ShellOverlay.js
