/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.ux3.ExactBrowser");jQuery.sap.require("sap.ui.ux3.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.ux3.ExactBrowser",{metadata:{publicMethods:["reset"],library:"sap.ui.ux3",properties:{"title":{type:"string",group:"Misc",defaultValue:null},"headerTitle":{type:"string",group:"Misc",defaultValue:null},"visible":{type:"boolean",group:"",defaultValue:true},"topListOrder":{type:"sap.ui.ux3.ExactOrder",group:"",defaultValue:sap.ui.ux3.ExactOrder.Select},"enableListClose":{type:"boolean",group:"Misc",defaultValue:false},"listHeight":{type:"int",group:"Appearance",defaultValue:290},"showHeader":{type:"boolean",group:"Misc",defaultValue:false},"showTopList":{type:"boolean",group:"Misc",defaultValue:true},"enableReset":{type:"boolean",group:"Misc",defaultValue:true},"enableSave":{type:"boolean",group:"Misc",defaultValue:false},"topListWidth":{type:"int",group:"Misc",defaultValue:168}},defaultAggregation:"attributes",aggregations:{"attributes":{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute"},"optionsMenu":{type:"sap.ui.commons.Menu",multiple:false},"controls":{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"},"rootAttribute":{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{"followUpControl":{type:"sap.ui.core.Control",multiple:false}},events:{"attributeSelected":{},"save":{}}}});sap.ui.ux3.ExactBrowser.M_EVENTS={'attributeSelected':'attributeSelected','save':'save'};jQuery.sap.require("sap.ui.ux3.ExactAttribute");jQuery.sap.require("sap.ui.ux3.ExactList");jQuery.sap.require("sap.ui.commons.Menu");jQuery.sap.require("sap.ui.commons.Button");(function(){sap.ui.ux3.ExactBrowser.prototype.init=function(){var t=this;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._attributeRoot=new sap.ui.ux3.ExactAttribute();this.setAggregation("rootAttribute",this._attributeRoot);this._rootList=new sap.ui.ux3.ExactList(this.getId()+"-rootlist");this._rootList.setData(this._attributeRoot);this.addAggregation("controls",this._rootList);this._resetButton=new sap.ui.commons.Button(this.getId()+"-RstBtn",{text:this._rb.getText("EXACT_BRWSR_RESET"),lite:true});this._resetButton.addStyleClass("sapUiUx3ExactBrwsrReset");this.addAggregation("controls",this._resetButton);this._resetButton.attachPress(function(){t.reset()});this._saveButton=new sap.ui.commons.Button(this.getId()+"-SvBtn",{text:this._rb.getText("EXACT_BRWSR_SAVE"),lite:true});this._saveButton.addStyleClass("sapUiUx3ExactBrwsrSave");this.addAggregation("controls",this._saveButton);this._saveButton.attachPress(function(){t.fireSave()});this._rootList.attachAttributeSelected(function(e){t.fireAttributeSelected({attribute:e.getParameter("attribute"),allAttributes:e.getParameter("allAttributes")})});this._rootList.attachEvent("_headerPress",function(e){var m=t.getOptionsMenu();if(m){var d=e.getParameter("domRef");m.open(e.getParameter("keyboard"),d,sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.BeginBottom,d)}})};sap.ui.ux3.ExactBrowser.prototype.exit=function(){this._rootList.destroy();this._attributeRoot.destroy();this._rootList=null;this._attributeRoot=null;this._resetButton=null;this._saveButton=null;this._saveDialog=null;this._saveTextField=null;this._rb=null};sap.ui.ux3.ExactBrowser.prototype.onkeydown=function(e){if(e.keyCode!=jQuery.sap.KeyCodes.F6||!this.getFollowUpControl()){return}var f=sap.ui.getCore().byId(this.getFollowUpControl());if(f){e.preventDefault();f.focus()}};sap.ui.ux3.ExactBrowser.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};sap.ui.ux3.ExactBrowser.prototype.getTitle=function(){return this._rootList.getTopTitle()};sap.ui.ux3.ExactBrowser.prototype.setTitle=function(t){this._rootList.setTopTitle(t);return this};sap.ui.ux3.ExactBrowser.prototype.setTopListOrder=function(l){this.setProperty("topListOrder",l,true);this._attributeRoot.setListOrder(l);return this};sap.ui.ux3.ExactBrowser.prototype.getTopListWidth=function(){return this._attributeRoot.getWidth()};sap.ui.ux3.ExactBrowser.prototype.setTopListWidth=function(w){this._attributeRoot.setWidth(w);return this};sap.ui.ux3.ExactBrowser.prototype.getHeaderTitle=function(){var t=this.getProperty("headerTitle");return t?t:this._rb.getText("EXACT_BRWSR_TITLE")};sap.ui.ux3.ExactBrowser.prototype.getEnableListClose=function(){return this._rootList.getShowClose()};sap.ui.ux3.ExactBrowser.prototype.setEnableListClose=function(e){this._rootList.setShowClose(e);return this};sap.ui.ux3.ExactBrowser.prototype.getListHeight=function(){return this._rootList.getTopHeight()};sap.ui.ux3.ExactBrowser.prototype.setListHeight=function(l){this._rootList.setTopHeight(l);return this};sap.ui.ux3.ExactBrowser.prototype.getAttributes=function(){return this._attributeRoot.getAttributesInternal()};sap.ui.ux3.ExactBrowser.prototype.insertAttribute=function(a,i){this._attributeRoot.insertAttribute(a,i);return this};sap.ui.ux3.ExactBrowser.prototype.addAttribute=function(a){this._attributeRoot.addAttribute(a);return this};sap.ui.ux3.ExactBrowser.prototype.removeAttribute=function(e){return this._attributeRoot.removeAttribute(e)};sap.ui.ux3.ExactBrowser.prototype.removeAllAttributes=function(){return this._attributeRoot.removeAllAttributes()};sap.ui.ux3.ExactBrowser.prototype.indexOfAttribute=function(a){return this._attributeRoot.indexOfAttribute(a)};sap.ui.ux3.ExactBrowser.prototype.destroyAttributes=function(){this._attributeRoot.destroyAttributes();return this};sap.ui.ux3.ExactBrowser.prototype.reset=function(){this._rootList._closeAll()};sap.ui.ux3.ExactBrowser.prototype.hasOptionsMenu=function(){return!!this.getOptionsMenu()}}());
