/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.Page");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.m.Page",{metadata:{publicMethods:["scrollTo"],library:"sap.m",properties:{"title":{type:"string",group:"Data",defaultValue:null},"showNavButton":{type:"boolean",group:"Appearance",defaultValue:false},"showHeader":{type:"boolean",group:"Appearance",defaultValue:true},"navButtonText":{type:"string",group:"Misc",defaultValue:null,deprecated:true},"enableScrolling":{type:"boolean",group:"Behavior",defaultValue:true},"icon":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true},"backgroundDesign":{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:sap.m.PageBackgroundDesign.Standard},"navButtonType":{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Back,deprecated:true},"showFooter":{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{"content":{type:"sap.ui.core.Control",multiple:true,singularName:"content"},"customHeader":{type:"sap.m.Bar",multiple:false},"footer":{type:"sap.m.Bar",multiple:false},"subHeader":{type:"sap.m.Bar",multiple:false},"headerContent":{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},"_internalHeader":{type:"sap.m.Bar",multiple:false,visibility:"hidden"}},events:{"navButtonTap":{deprecated:true},"navButtonPress":{}}}});sap.m.Page.M_EVENTS={'navButtonTap':'navButtonTap','navButtonPress':'navButtonPress'};
sap.m.Page.prototype.init=function(){jQuery.sap.require("sap.ui.core.theming.Parameters");this._bIsPlatformDependent=sap.ui.core.theming.Parameters.get("sapMPlatformDependent")=="true";this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(this.getNavButtonText()==""&&this._bIsPlatformDependent){this.setNavButtonText(this._rb.getText("PAGE_NAVBUTTON_TEXT"))}};
sap.m.Page.prototype._hasScrolling=function(){return this.getEnableScrolling()};
sap.m.Page.prototype.onBeforeRendering=function(){if(this._oScroller&&!this._hasScrolling()){this._oScroller.destroy();this._oScroller=null}else if(this._hasScrolling()&&!this._oScroller){jQuery.sap.require("sap.ui.core.delegate.ScrollEnablement");this._oScroller=new sap.ui.core.delegate.ScrollEnablement(this,this.getId()+"-scroll",{horizontal:false,vertical:true,zynga:false,iscroll:this._bUseIScroll,preventDefault:false,nonTouchScrolling:"scrollbar",scrollbarClass:"sapMScrollbar"})}};
sap.m.Page.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null}if(this._navBtn){this._navBtn.destroy();this._navBtn=null}if(this._appIcon){this._appIcon.destroy();this._appIcon=null}};
sap.m.Page.prototype.setBackgroundDesign=function(b){var B=this.getBackgroundDesign();this.setProperty("backgroundDesign",b,true);this.$().removeClass("sapMPageBg"+B).addClass("sapMPageBg"+this.getBackgroundDesign());return this};
sap.m.Page.prototype.setTitle=function(t){var w=!this._headerTitle;this._headerTitle=this._headerTitle||new sap.m.Label(this.getId()+"-title",{text:t});this._headerTitle.setText(t);if(w){if(this._bIsPlatformDependent){if(sap.ui.Device.os.ios){this._updateHeaderContent(this._headerTitle,'middle',0)}else{this._titleIndex=this._titleIndex||0;this._updateHeaderContent(this._headerTitle,'left',this._titleIndex)}}else{this._updateHeaderContent(this._headerTitle,'middle',0)}}this.setProperty("title",t,true);return this};
sap.m.Page.prototype.setShowNavButton=function(s){var o=!!this.getShowNavButton();if(s===o){return this}this.setProperty("showNavButton",s,true);this._navBtn=this._navBtn||new sap.m.Button(this.getId()+"-navButton",{press:jQuery.proxy(function(){this.fireNavButtonPress();this.fireNavButtonTap()},this)});var n=this.getNavButtonType();if(sap.ui.Device.os.android&&n==sap.m.ButtonType.Back){this._navBtn.setType(sap.m.ButtonType.Up)}else{this._navBtn.setType(n);if(this._bIsPlatformDependent){this._navBtn.setText(this.getNavButtonText())}}if(s){if(sap.ui.Device.os.android&&this._bIsPlatformDependent){this._titleIndex=1;if(this.getIcon()){this._navBtn.setIcon(this.getIcon())}}if(this._appIcon){this._updateHeaderContent(this._appIcon,'left',-1)}this._updateHeaderContent(this._navBtn,'left',0)}else{this._updateHeaderContent(this._navBtn,'left',-1);if(this._bIsPlatformDependent&&!sap.ui.Device.os.ios&&this.getIcon()){this._appIcon=this._appIcon||new sap.m.Image(this.getId()+"-icon",{src:this.getIcon()});this._updateHeaderContent(this._appIcon,'left',0)}}return this};
sap.m.Page.prototype.setNavButtonType=function(n){this._navBtn=this._navBtn||new sap.m.Button(this.getId()+"-navButton",{press:jQuery.proxy(function(){this.fireNavButtonPress();this.fireNavButtonTap()},this)});if(!sap.ui.Device.os.ios&&n==sap.m.ButtonType.Back){this._navBtn.setType(sap.m.ButtonType.Up)}else{this._navBtn.setType(n)}this.setProperty("navButtonType",n,true);return this};
sap.m.Page.prototype.setNavButtonText=function(t){this._navBtn=this._navBtn||new sap.m.Button(this.getId()+"-navButton",{press:jQuery.proxy(function(){this.fireNavButtonPress();this.fireNavButtonTap()},this)});if(t==""&&this._bIsPlatformDependent){t=this._rb.getText("PAGE_NAVBUTTON_TEXT")}if(sap.ui.Device.os.ios&&this._bIsPlatformDependent){this._navBtn.setText(t)}this.setProperty("navButtonText",t,true);return this};
sap.m.Page.prototype.setIcon=function(i){var o=this.getIcon();if(o===i){return this}if(!sap.ui.Device.os.ios&&this._bIsPlatformDependent){if(i){if(this.getShowNavButton()){this._navBtn=this._navBtn||new sap.m.Button(this.getId()+"-navButton",{press:jQuery.proxy(function(){this.fireNavButtonPress();this.fireNavButtonTap()},this)});this._navBtn.setIcon(i);if(this._appIcon){this._updateHeaderContent(this._appIcon,'left',-1)}}else{this._appIcon=this._appIcon||new sap.m.Image(this.getId()+"-icon",{src:i}).addStyleClass("sapMPageAppIcon");this._appIcon.setSrc(i);if(this._navBtn){this._updateHeaderContent(this._navBtn,'left',-1)}this._updateHeaderContent(this._appIcon,'left',0)}this._titleIndex=1}else{if(this._appIcon){this._updateHeaderContent(this._appIcon,'left',-1);this._titleIndex=0;this._appIcon.destroy();this._appIcon=null}}}this.setProperty("icon",i,true);return this};
sap.m.Page.prototype._updateHeaderContent=function(c,C,i){var I=this._getInternalHeader();if(I){switch(C){case'left':if(i==-1){if(I.getContentLeft()){I.removeContentLeft(c)}}else{if(I.indexOfContentLeft(c)!=i){I.insertContentLeft(c,i);I.invalidate()}}break;case'middle':if(i==-1){if(I.getContentMiddle()){I.removeContentMiddle(c)}}else{if(I.indexOfContentMiddle(c)!=i){I.insertContentMiddle(c,i);I.invalidate()}}break;case'right':if(i==-1){if(I.getContentRight()){I.removeContentRight(c)}}else{if(I.indexOfContentRight(c)!=i){I.insertContentRight(c,i);I.invalidate()}}break;default:break}}};
sap.m.Page.prototype._getInternalHeader=function(){var i=this.getAggregation("_internalHeader");if(!i){this.setAggregation('_internalHeader',new sap.m.Bar(this.getId()+"-intHeader"));i=this.getAggregation("_internalHeader");i._context='header';if(sap.ui.Device.os.ios){if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,'left',0)}if(this.getTitle()&&this._headerTitle){this._updateHeaderContent(this._headerTitle,'middle',0)}}else{if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,'left',0);this._titleIndex=1}else{if(this._bIsPlatformDependent&&this.getIcon()&&this._appIcon){this._updateHeaderContent(this._appIcon,'left',0);this._titleIndex=1}}if(this.getTitle()&&this._headerTitle){if(this._bIsPlatformDependent){this._titleIndex=this._titleIndex||0;this._updateHeaderContent(this._headerTitle,'left',this._titleIndex)}else{this._updateHeaderContent(this._headerTitle,'middle',0)}}}}return i};
sap.m.Page.prototype._getAnyHeader=function(){var c=this.getCustomHeader();if(c){c._context='header';return c.addStyleClass("sapMPageHeader sapMHeader-CTX")}else{return this._getInternalHeader().addStyleClass("sapMPageHeader sapMHeader-CTX")}};
sap.m.Page.prototype.getScrollDelegate=function(){return this._oScroller};
sap.m.Page.prototype.scrollTo=function(y,t){if(this._oScroller){this._oScroller.scrollTo(0,y,t)}return this};
sap.m.Page.prototype.getHeaderContent=function(){return this._getInternalHeader().getContentRight()};
sap.m.Page.prototype.indexOfHeaderContent=function(c){return this._getInternalHeader().indexOfContentRight(c)};
sap.m.Page.prototype.insertHeaderContent=function(c,i){return this._getInternalHeader().insertContentRight(c,i)};
sap.m.Page.prototype.addHeaderContent=function(c){return this._getInternalHeader().addContentRight(c)};
sap.m.Page.prototype.removeHeaderContent=function(c){return this._getInternalHeader().removeContentRight(c)};
sap.m.Page.prototype.removeAllHeaderContent=function(){return this._getInternalHeader().removeAllContentRight()};
sap.m.Page.prototype.destroyHeaderContent=function(){return this._getInternalHeader().destroyContentRight()};
