/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.TextField");jQuery.sap.require("sap.ui.commons.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.commons.TextField",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],publicMethods:["focus","getLiveValue"],library:"sap.ui.commons",properties:{"value":{type:"string",group:"Data",defaultValue:'',bindable:"bindable"},"textDirection":{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},"enabled":{type:"boolean",group:"Behavior",defaultValue:true},"editable":{type:"boolean",group:"Behavior",defaultValue:true},"visible":{type:"boolean",group:"Behavior",defaultValue:true},"required":{type:"boolean",group:"Appearance",defaultValue:false},"width":{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},"maxLength":{type:"int",group:"Behavior",defaultValue:0},"valueState":{type:"sap.ui.core.ValueState",group:"Data",defaultValue:sap.ui.core.ValueState.None},"textAlign":{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin},"imeMode":{type:"sap.ui.core.ImeMode",group:"Behavior",defaultValue:sap.ui.core.ImeMode.Auto},"design":{type:"sap.ui.core.Design",group:"Appearance",defaultValue:sap.ui.core.Design.Standard},"helpId":{type:"string",group:"Behavior",defaultValue:''},"accessibleRole":{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:sap.ui.core.AccessibleRole.Textbox},"name":{type:"string",group:"Misc",defaultValue:null},"placeholder":{type:"string",group:"Appearance",defaultValue:null}},associations:{"ariaDescribedBy":{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},"ariaLabelledBy":{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{"change":{},"liveChange":{}}}});sap.ui.commons.TextField.M_EVENTS={'change':'change','liveChange':'liveChange'};jQuery.sap.require("sap.ui.core.ValueStateSupport");
sap.ui.commons.TextField.prototype.init=function(){};
sap.ui.commons.TextField.prototype.onfocusin=function(e){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onfocus){this.getRenderer().onfocus(this)}};
sap.ui.commons.TextField.prototype.onsapfocusleave=function(e){this._doOnEscape(e);this._checkChange(e);if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this)}var f=jQuery(this.getFocusDomRef());if(f.data("sap.InNavArea")===false){f.data("sap.InNavArea",true)}};
sap.ui.commons.TextField.prototype.onsapenter=function(e){this._checkChange(e)};
sap.ui.commons.TextField.prototype._checkChange=function(e){var i=this.getInputDomRef(),n=i&&i.value,o=this.getValue();if(this.getEditable()&&this.getEnabled()&&(o!=n)){this.setProperty("value",n,true);this.fireChange({newValue:n})}};
sap.ui.commons.TextField.prototype.onselectstart=function(e){if(!this.getEnabled()){e.preventDefault();e.stopPropagation()}};
sap.ui.commons.TextField.prototype._checkCursorPosForNav=function(e,f){var r=sap.ui.getCore().getConfiguration().getRTL();var b=f?r:!r;var $=jQuery(this.getInputDomRef());var p=$.cursorPos();var l=$.val().length;if(r){p=l-p}if((!b&&p!=l)||(b&&p!=0)){e.stopPropagation()}};
sap.ui.commons.TextField.prototype.onsapnext=function(e){if(e.keyCode!=jQuery.sap.KeyCodes.ARROW_DOWN){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=jQuery.sap.KeyCodes.END){e.preventDefault();return}this._checkCursorPosForNav(e,true)}};
sap.ui.commons.TextField.prototype.onsapprevious=function(e){if(e.keyCode!=jQuery.sap.KeyCodes.ARROW_UP){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=jQuery.sap.KeyCodes.HOME){e.preventDefault();return}this._checkCursorPosForNav(e,false)}};
sap.ui.commons.TextField.prototype.onsapnextmodifiers=sap.ui.commons.TextField.prototype.onsapnext;sap.ui.commons.TextField.prototype.onsappreviousmodifiers=sap.ui.commons.TextField.prototype.onsapprevious;sap.ui.commons.TextField.prototype.onsapend=sap.ui.commons.TextField.prototype.onsapnext;sap.ui.commons.TextField.prototype.onsaphome=sap.ui.commons.TextField.prototype.onsapprevious;
sap.ui.commons.TextField.prototype.onsapexpand=function(e){var i=jQuery(this.getFocusDomRef()).data("sap.InNavArea");if(i||i===false){e.stopPropagation();return}};
sap.ui.commons.TextField.prototype.onsapcollapse=sap.ui.commons.TextField.prototype.onsapexpand;
sap.ui.commons.TextField.prototype.onsapescape=function(e){var v=this.getProperty("value");this._bEsc=true;this._sValue=v;var i=this.getInputDomRef();if(i&&i.value!==v&&!this._propagateEsc){e.stopPropagation()}if(!!!sap.ui.Device.browser.firefox){this._doOnEscape(e)}};
sap.ui.commons.TextField.prototype.onkeypress=function(e){this._doOnEscape(e);var k=e.which;if(k>0&&k!==jQuery.sap.KeyCodes.ESCAPE){var f=jQuery(this.getFocusDomRef());if(f.data("sap.InNavArea")){f.data("sap.InNavArea",false)}}};
sap.ui.commons.TextField.prototype._doOnEscape=function(e){if(this._bEsc){var i=this.getInputDomRef();if(i){if(i.value!==this._sValue){jQuery(i).val(this._sValue)}var f=jQuery(this.getFocusDomRef());if(f.data("sap.InNavArea")===false){f.data("sap.InNavArea",true)}}this._bEsc=undefined;this._sValue=undefined}};
sap.ui.commons.TextField.prototype.onkeyup=function(e){if(e.keyCode==jQuery.sap.KeyCodes.F2){var f=jQuery(this.getFocusDomRef());if(f.data("sap.InNavArea")){f.data("sap.InNavArea",false)}else if(f.data("sap.InNavArea")===false){f.data("sap.InNavArea",true)}}else if(e.keyCode!=jQuery.sap.KeyCodes.TAB&&e.keyCode!=jQuery.sap.KeyCodes.ENTER){this._fireLiveChange(e)}};
sap.ui.commons.TextField.prototype.onpaste=function(e){var t=this;setTimeout(function(){t._fireLiveChange(e)},10)};
sap.ui.commons.TextField.prototype._fireLiveChange=function(e){if(this.getEnabled()&&this.getEditable()){var l=jQuery(this.getInputDomRef()).val();this.fireLiveChange({liveValue:l})}};
sap.ui.commons.TextField.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(o==v){return this}if(!this.getDomRef()){return this}if(this.getRenderer().setValueState){this.getRenderer().setValueState(this,o,v)}if(this.delayedCallId){jQuery.sap.clearDelayedCall(this.delayedCallId);this.delayedCallId=null}if(sap.ui.core.ValueState.Success==v){this.delayedCallId=jQuery.sap.delayedCall(3000,this,"removeValidVisualization")}return this};
sap.ui.commons.TextField.prototype.removeValidVisualization=function(){if(this.getRenderer().removeValidVisualization){this.getRenderer().removeValidVisualization(this)}};
sap.ui.commons.TextField.prototype.setEditable=function(e){var o=this.getEditable();this.setProperty('editable',e,true);e=this.getEditable();if(o!=e){if(this.getDomRef()&&this.getRenderer().setEditable){this.getRenderer().setEditable(this,e)}}return this};
sap.ui.commons.TextField.prototype.setEnabled=function(e){var o=this.getEnabled();this.setProperty('enabled',e,true);e=this.getEnabled();if(o!=e){if(this.getDomRef()&&this.getRenderer().setEnabled){this.getRenderer().setEnabled(this,e)}}return this};
sap.ui.commons.TextField.prototype.setRequired=function(r){var o=this.getRequired();this.setProperty('required',r,true);r=this.getRequired();if(o!=r){if(this.getDomRef()){if(this.getRenderer().setRequired){this.getRenderer().setRequired(this,r)}}this.fireEvent("requiredChanged",{required:r})}return this};
sap.ui.commons.TextField.prototype.setDesign=function(d){var o=this.getDesign();this.setProperty('design',d,true);d=this.getDesign();if(o!=d){if(this.getDomRef()){if(this.getRenderer().setDesign){this.getRenderer().setDesign(this,d)}}}return this};
sap.ui.commons.TextField.prototype.setValue=function(v){var n=v;if(n&&n.length>this.getMaxLength()&&this.getMaxLength()>0){n=n.substring(0,this.getMaxLength())}this.setProperty("value",n,true);n=this.getValue();var i=this.getInputDomRef();if(i&&i.value!==n){if(!sap.ui.Device.support.input.placeholder){if(n){this.$().removeClass('sapUiTfPlace');i.value=n}else{this.$().addClass('sapUiTfPlace');var p=this.getPlaceholder();if(this.getRenderer().convertPlaceholder){p=this.getRenderer().convertPlaceholder(this)}i.value=p}}else{i.value=n}}return this};
sap.ui.commons.TextField.prototype.setTooltip=function(t){this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(this.getInputDomRef()){var T=sap.ui.core.ValueStateSupport.enrichTooltip(this,this.getTooltip_AsString());jQuery(this.getInputDomRef()).attr("title",T||"")}return this};
sap.ui.commons.TextField.prototype.getInputDomRef=function(){if(!this._getRenderOuter()){return this.getDomRef()||null}else{return this.getDomRef("input")||null}};
sap.ui.commons.TextField.prototype.applyFocusInfo=function(f){if(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==8){var p=this.getValue().length;var t=this;setTimeout(function(){t.focus();jQuery(t.getFocusDomRef()).cursorPos(p)},0)}else{this.focus()}return this};
sap.ui.commons.TextField.prototype.getLiveValue=function(){var i=this.getInputDomRef();if(i){return jQuery(i).val()}else{return this.getValue()}};
sap.ui.commons.TextField.prototype.ondrop=function(e){this.onpaste(e)};
sap.ui.commons.TextField.prototype._getRenderOuter=function(){if(this.bRenderOuter==undefined){var r=this.getRenderer();if(r.renderOuterAttributes||r.renderOuterContentBefore||r.renderOuterContent){this.bRenderOuter=true}else{this.bRenderOuter=false}}return this.bRenderOuter};
sap.ui.commons.TextField.prototype.getIdForLabel=function(){if(!this._getRenderOuter()){return this.getId()}else{return this.getId()+'-input'}};
sap.ui.commons.TextField.prototype.getFocusDomRef=function(){return this.getInputDomRef()};
