/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObjectMetadata'],function(q,M){"use strict";var C=function(c,o){M.apply(this,arguments)};C.prototype=q.sap.newObject(M.prototype);C.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata}}return c};C.prototype.applySettings=function(c){var s=c.metadata;M.prototype.applySettings.call(this,c);var n=this.getName(),p=n.replace(/\.\w+?$/,"");if(s._src){q.sap.log.warning("The metadata of the component "+n+" is loaded from file "+s._src+". This is a design time feature and not for productive usage!");var u=q.sap.getModulePath(p,"/"+s._src);var r=q.sap.syncGetJSON(u);if(r.success){q.extend(s,r.data)}else{q.sap.log.error("Failed to load component metadata from \""+s._src+"\"! Reason: "+r.error)}}this._sComponentName=p;this._bInitialized=false;this._iInstanceCount=0;this._sVersion=s.version;this._mDependencies=s.dependencies;this._aIncludes=s.includes;this._mConfig=s.config;this._mCustomizing=s.customizing;this._mModels=s.models||{};this._mServices=s.services||{};var P=this.getParent();if(P instanceof C){this._mConfig=q.extend(true,{},P._mConfig,this._mConfig);this._mCustomizing=q.extend(true,{},P._mCustomizing,this._mCustomizing);this._mModels=q.extend(true,{},P._mModels,this._mModels);this._mServices=q.extend(true,{},P._mServices,this._mServices)}};C.prototype.init=function(){if(!this._bInitialized){var p=this.getParent();if(p instanceof C){p.init()}this._loadDependencies();this._loadIncludes();this._bInitialized=true}};C.prototype.exit=function(){if(this._bInitialized){var p=this.getParent();if(p instanceof C){p.exit()}this._bInitialized=false}};C.prototype.onInitComponent=function(){if(this._iInstanceCount===0&&!q.isEmptyObject(this._mCustomizing)){q.sap.require("sap.ui.core.CustomizingConfiguration");sap.ui.core.CustomizingConfiguration.activateForComponent(this._sComponentName)}this._iInstanceCount++};C.prototype.onExitComponent=function(){this._iInstanceCount--;if(this._iInstanceCount===0&&!q.isEmptyObject(this._mCustomizing)){if(sap.ui.core.CustomizingConfiguration){sap.ui.core.CustomizingConfiguration.deactivateForComponent(this._sComponentName)}}};C.prototype.getDependencies=function(){return this._mDependencies};C.prototype.getIncludes=function(){return(this._aIncludes&&this._aIncludes.length>0)?this._aIncludes:null};C.prototype.getUI5Version=function(){return this._mDependencies?this._mDependencies.ui5version:null};C.prototype.getComponents=function(){var c=null;if(this._mDependencies){if(this._mDependencies.components&&(this._mDependencies.components.length>0)){c=this._mDependencies.components}}return c};C.prototype.getLibs=function(){var l=null;if(this._mDependencies){if(this._mDependencies.libs&&(this._mDependencies.libs.length>0)){l=this._mDependencies.libs}}return l};C.prototype.getVersion=function(){return this._sVersion};C.prototype.getConfig=function(k){return this._mConfig?q.extend({},k?this._mConfig[k]:this._mConfig):undefined};C.prototype.getCustomizing=function(){return this._mCustomizing?q.extend({},this._mCustomizing):undefined};C.prototype.getModels=function(){return this._mModels};C.prototype.getServices=function(){return this._mServices};C.prototype._loadIncludes=function(){var I=this.getIncludes();if(I&&I.length>0){var t=this;var l=this.getLibraryName();q.each(I,function(i,f){if(f.match(/\.css$/i)){var c=sap.ui.resource(l,f);q.sap.log.info("Component \""+t.getName()+"\" is loading CSS: \""+c+"\"");q.sap.includeStyleSheet(c)}else{var m=f.match(/\.js$/i);if(m){var p=l.replace(/\./g,'/')+(f.slice(0,1)==='/'?'':'/')+f.slice(0,m.index);q.sap.log.info("Component \""+t.getName()+"\" is loading JS: \""+p+"\"");q.sap._requirePath(p)}}})}};C.prototype._loadDependencies=function(){var t=this,d=this.getDependencies();if(d){var l=d.libs;if(l){q.each(l,function(i,L){q.sap.log.info("Component \""+t.getName()+"\" is loading library: \""+L+"\"");sap.ui.getCore().loadLibrary(L)})}var c=d.components;if(c){q.each(c,function(i,n){q.sap.log.info("Component \""+t.getName()+"\" is loading component: \""+n+".Component\"");sap.ui.component.load({name:n})})}}};return C},true);
