/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for JSView
sap.ui.define(['jquery.sap.global', './ViewRenderer'],
	function(jQuery, ViewRenderer) {
	"use strict";


	/**
	 * @class TemplateView renderer.
	 * @static
	 * @name sap.ui.core.mvc.TemplateViewRenderer
	 */
	var TemplateViewRenderer = {
	};
	
	
	/**
	 * Renders the Template, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 * @name sap.ui.core.mvc.TemplateViewRenderer.render
	 * @function
	 */
	TemplateViewRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;
	
		// write the HTML into the render manager
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiView");
		rm.addClass("sapUiTmplView");
		ViewRenderer.addDisplayClass(rm, oControl);
		rm.addStyle("width", oControl.getWidth());
		rm.addStyle("height", oControl.getHeight());
		rm.writeStyles();
		rm.writeClasses();
		rm.write(">");
		
		rm.renderControl(oControl._oTemplate);
	
		rm.write("</div>");
	};

	return TemplateViewRenderer;

}, /* bExport= */ true);
