/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/Model','./CountMode','./ODataContextBinding','./ODataListBinding','./ODataMetadata','./ODataPropertyBinding','./ODataTreeBinding','sap/ui/thirdparty/URI','sap/ui/thirdparty/datajs'],function(q,M,C,O,a,b,c,d,U,e){"use strict";var f=M.extend("sap.ui.model.odata.ODataModel",{constructor:function(s,j,u,p,h,t,w,l){M.apply(this,arguments);var g,r,m,A=null,L,i,D;if(typeof j==="object"){u=j.user;p=j.password;h=j.headers;t=j.tokenHandling;l=j.loadMetadataAsync;w=j.withCredentials;m=j.maxDataServiceVersion;g=j.useBatch;r=j.refreshAfterChange;A=j.annotationURI;L=j.loadAnnotationsJoined;D=j.defaultCountMode;j=j.json}this.sDefaultBindingMode=sap.ui.model.BindingMode.OneWay;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.bCountSupported=true;this.bJSON=j;this.bCache=true;this.aPendingRequestHandles=[];this.oRequestQueue={};this.aBatchOperations=[];this.oHandler;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=g===true;this.bRefreshAfterChange=r!==false;this.sMaxDataServiceVersion=m;this.bLoadMetadataAsync=!!l;this.bLoadAnnotationsJoined=L===undefined?true:L;this.sAnnotationURI=A;this.sDefaultCountMode=D||C.Both;if(this.sAnnotationURI){q.sap.require("sap.ui.model.odata.ODataAnnotations")}this.oHeaders={};this.setHeaders(h);this.oData={};this.oMetadata=null;this.oAnnotations=null;if(s.indexOf("?")==-1){this.sServiceUrl=s}else{var k=s.split("?");this.sServiceUrl=k[0];this.sUrlParams=k[1]}if(sap.ui.getCore().getConfiguration().getStatistics()){if(this.sUrlParams){this.sUrlParams=this.sUrlParams+"&sap-statistics=true"}else{this.sUrlParams="sap-statistics=true"}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.oServiceData=f.mServiceData[this.sServiceUrl];if(!this.oServiceData){f.mServiceData[this.sServiceUrl]={};this.oServiceData=f.mServiceData[this.sServiceUrl]}if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken}this.sUser=u;this.sPassword=p;this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguage();if(this.sAnnotationURI&&!this.bLoadMetadataAsync){this.oMetadata=new b(this,false);this.oAnnotations=new sap.ui.model.odata.ODataAnnotations(this,this.sAnnotationURI,false)}else if(this.sAnnotationURI){this.oAnnotations=new sap.ui.model.odata.ODataAnnotations(this,this.sAnnotationURI,true);this.oMetadata=new b(this,true)}else{this.oMetadata=new b(this,this.bLoadMetadataAsync)}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata"}else{this.oHeaders["Accept"]="application/json"}this.oHandler=OData.jsonHandler}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";this.oHandler=OData.atomHandler}this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion}this.oHeaders["DataServiceVersion"]="2.0"},metadata:{publicMethods:["create","remove","update","submitChanges","getServiceMetadata","read","hasPendingChanges","refresh","resetChanges","isCountSupported","setCountSupported","setDefaultCountMode","getDefaultCountMode","forceNoCache","setProperty","refreshSecurityToken","setHeaders","getHeaders","formatValue, setUseBatch"]}});f.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed"};f.mServiceData={};f.prototype.fireRejectChange=function(A){this.fireEvent("rejectChange",A);return this};f.prototype.attachRejectChange=function(D,F,l){this.attachEvent("rejectChange",D,F,l);return this};f.prototype.detachRejectChange=function(F,l){this.detachEvent("rejectChange",F,l);return this};f.prototype._setMetadata=function(m){this.oMetadata=m;this.fireInternalMetadataLoaded()};f.prototype.attachInternalMetadataLoaded=function(D,F,l){this.attachEvent("internalMetadataLoaded",D,F,l);return this};f.prototype.fireInternalMetadataLoaded=function(A){this.fireEvent("internalMetadataLoaded",A);if(this.bLoadMetadataAsync&&this.sAnnotationURI&&this.bLoadAnnotationsJoined){var t=this;if(this.oAnnotations&&this.oAnnotations.bInitialized){this.fireMetadataLoaded(A)}else{this.attachAnnotationsLoaded(function(){this.fireMetadataLoaded(A)})}}else{this.fireMetadataLoaded(A)}return this};f.prototype.fireAnnotationsLoaded=function(A){this.fireEvent("annotationsLoaded",A);return this};f.prototype.attachAnnotationsLoaded=function(D,F,l){this.attachEvent("annotationsLoaded",D,F,l);return this};f.prototype.detachAnnotationsLoaded=function(F,l){this.detachEvent("annotationsLoaded",F,l);return this};f.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this};f.prototype.attachMetadataLoaded=function(D,F,l){this.attachEvent("metadataLoaded",D,F,l);return this};f.prototype.detachMetadataLoaded=function(F,l){this.detachEvent("metadataLoaded",F,l);return this};f.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this};f.prototype.attachMetadataFailed=function(D,F,l){this.attachEvent("metadataFailed",D,F,l);return this};f.prototype.detachMetadataFailed=function(F,l){this.detachEvent("metadataFailed",F,l);return this};f.prototype._createRequestUrl=function(p,o,u,B,g){var h=[],r,s,i="";if(p.indexOf('?')!=-1){s=p.substr(p.indexOf('?')+1);p=p.substr(0,p.indexOf('?'))}r=this._normalizePath(p,o);if(!B){i=this.sServiceUrl+r}else{i=r.substr(r.indexOf('/')+1)}if(q.type(u)==="string"){h.push(u)}else if(q.isArray(u)){h=u}else if(u){q.each(u,function(P,k){if(q.type(k)==="string"){k=q.sap.encodeURL(k)}h.push(q.sap.encodeURL(P)+"="+k)})}if(this.sUrlParams){h.push(this.sUrlParams)}if(s){h.push(s)}if(h.length>0){i+="?"+h.join("&")}if(g===undefined){g=true}if(g===false){var t=q.now();var j=i.replace(/([?&])_=[^&]*/,"$1_="+t);i=j+((j===i)?(/\?/.test(i)?"&":"?")+"_="+t:"")}return i};f.prototype._loadData=function(p,P,s,E,g,h,i){var r,R,o,t=this;function _(D,m){var n=D,v={};if(!n){q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+m.requestUri);t.fireRequestCompleted({url:o.requestUri,type:"GET",async:o.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false});return false}if(t.bUseBatch){var w=t._getBatchErrors(D);if(w.length>0){j(w[0]);return false}if(n.__batchResponses&&n.__batchResponses.length>0){n=n.__batchResponses[0].data}else{q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+m.requestUri)}}l=l.concat(n.results);if(n.__next){var x=new URI(n.__next);R=x.absoluteTo(m.requestUri).toString();R+=t.sUrlParams?'&'+t.sUrlParams:'';o.requestUri=R;k(o)}else{q.extend(n.results,l);if(n.results&&!q.isArray(n.results)){n=n.results}t._importData(n,v);if(t.sChangeKey&&v){var y=t.sChangeKey.substr(t.sChangeKey.lastIndexOf('/')+1);if(v[y]){t.sChangeKey=null}}if(s){s(n)}t.checkUpdate(false,v);if(i){i()}t.fireRequestCompleted({url:o.requestUri,type:"GET",async:o.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true})}}function j(m){if(t.bTokenHandling&&m.response){var T=t._getHeader("x-csrf-token",m.response.headers);if(!o.bTokenReset&&m.response.statusCode=='403'&&T.toLowerCase()=="required"){t.resetSecurityToken();o.bTokenReset=true;k();return}}var n=t._handleError(m);if(E){E(m)}t.fireRequestCompleted({url:o.requestUri,type:"GET",async:o.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false,errorobject:n});if(!r||!r.bAborted){t.fireRequestFailed(n)}}function k(){if(t.bUseBatch){t.updateSecurityToken();var m=URI.parse(o.requestUri).query;var n=t._createRequestUrl(p,null,m,t.bUseBatch);o=t._createRequest(n,"GET",true);var B=t._createBatchRequest([o],true);r=t._request(B,_,j,OData.batchHandler,undefined,t.getServiceMetadata())}else{r=t._request(o,_,j,t.oHandler,undefined,t.getServiceMetadata())}if(h){var w={abort:function(){r.bAborted=true;r.abort()}};h(w)}}var l=[];var u=this._createRequestUrl(p,null,P,null,g||this.bCache);o=this._createRequest(u,"GET",true);this.fireRequestSent({url:o.requestUri,type:"GET",async:o.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]}});k()};f.prototype._importData=function(D,k){var t=this,l,K,r,E;if(D.results){l=[];q.each(D.results,function(i,g){l.push(t._importData(g,k))});return l}else{K=this._getKey(D);E=this.oData[K];if(!E){E=D;this.oData[K]=E}q.each(D,function(n,p){if(p&&(p.__metadata&&p.__metadata.uri||p.results)&&!p.__deferred){r=t._importData(p,k);if(q.isArray(r)){E[n]={__list:r}}else{E[n]={__ref:r}}}else if(!p||!p.__deferred){E[n]=p}});k[K]=true;return K}};f.prototype._removeReferences=function(D){var t=this,l;if(D.results){l=[];q.each(D.results,function(i,g){l.push(t._removeReferences(g))});return l}else{q.each(D,function(p,o){if(o){if(o["__ref"]||o["__list"]){delete D[p]}}});return D}};f.prototype._restoreReferences=function(D){var t=this,o,l,r=[];if(D.results){l=[];q.each(D.results,function(i,g){l.push(t._restoreReferences(g))});return l}else{q.each(D,function(p,o){if(o&&o["__ref"]){var g=t._getObject("/"+o["__ref"]);if(g){delete o["__ref"];D[p]=g;t._restoreReferences(g)}}else if(o&&o["__list"]){q.each(o["__list"],function(j,E){var g=t._getObject("/"+o["__list"][j]);if(g){r.push(g);t._restoreReferences(g)}});delete o["__list"];o.results=r;r=[]}});return D}};f.prototype.removeData=function(){this.oData={}};f.prototype.refresh=function(F,m,E){var B=this.aBindings.slice(0);q.each(B,function(i,o){o.refresh(F,m,E)})};f.prototype.checkUpdate=function(F,m){var B=this.aBindings.slice(0);q.each(B,function(i,o){o.checkUpdate(F,m)})};f.prototype.bindProperty=function(p,o,P){var B=new c(this,p,o,P);return B};f.prototype.bindList=function(p,o,s,F,P){var B=new a(this,p,o,s,F,P);return B};f.prototype.bindTree=function(p,o,F,P){var B=new d(this,p,o,F,P);return B};f.prototype.createBindingContext=function(p,o,P,g,r){var r=!!r,F=this.resolve(p,o);if(typeof o=="function"){g=o;o=null}if(typeof P=="function"){g=P;P=null}var D=this._getObject(p,o),k,n,t=this;if(!r){r=this._isReloadNeeded(F,D,P)}if(!r){k=this._getKey(D);n=this.getContext('/'+k);g(n)}else{var i=!q.sap.startsWith(p,"/");if(F){var h=[],s=this.createCustomParams(P);if(s){h.push(s)}this._loadData(F,h,function(D){k=D?t._getKey(D):undefined;if(k&&o&&i){var j=o.getPath();j=j.substr(1);if(t.oData[j]){t.oData[j][p]={__ref:k}}}n=t.getContext('/'+k);g(n)},function(){g(null)})}else{g(null)}}};f.prototype._isReloadNeeded=function(F,D,p){var n,N=[],s,S=[];if(!D){return true}if(p&&p["expand"]){n=p["expand"].replace(/\s/g,"");N=n.split(',')}if(p&&p["select"]){s=p["select"].replace(/\s/g,"");S=s.split(',')}for(var i=0;i<N.length;i++){if(D[N[i]]===undefined||(D[N[i]]&&D[N[i]].__deferred)){return true}}for(var i=0;i<S.length;i++){if(D[S[i]]===undefined){return true}}if(S.length==0){var E=this.oMetadata._getEntityTypeByPath(F);if(!E){return false}else{for(var i=0;i<E.property.length;i++){if(D[E.property[i].name]===undefined){return true}}}}return false};f.prototype.destroyBindingContext=function(o){};f.prototype.createCustomParams=function(p){var g=[],m,s={expand:true,select:true};for(var n in p){if(n in s){g.push("$"+n+"="+q.sap.encodeURL(p[n]))}if(n=="custom"){m=p[n];for(var n in m){if(n.indexOf("$")==0){q.sap.log.warning("Trying to set OData parameter "+n+" as custom query option!")}else{g.push(n+"="+q.sap.encodeURL(m[n]))}}}}return g.join("&")};f.prototype.bindContext=function(p,o,P){var B=new O(this,p,o,P);return B};f.prototype.setCountSupported=function(g){this.bCountSupported=g};f.prototype.isCountSupported=function(){return this.bCountSupported};f.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s};f.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode};f.prototype._getKey=function(o){var k,u;if(o instanceof sap.ui.model.Context){k=o.getPath().substr(1)}else if(o&&o.__metadata&&o.__metadata.uri){u=o.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1)}return k};f.prototype.getProperty=function(p,o,i){var v=this._getObject(p,o);if(i==null||i==undefined){return v}if(!q.isPlainObject(v)){return v}v=q.extend(true,{},v);if(i==true){return this._restoreReferences(v)}else{return this._removeReferences(v)}};f.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null,k;if(o){k=o.getPath();k=k.substr(1);n=this.oData[k]}if(!p){return n}var P=p.split("/"),i=0;if(!P[0]){n=this.oData;i++}while(n&&P[i]){n=n[P[i]];if(n){if(n.__ref){n=this.oData[n.__ref]}else if(n.__list){n=n.__list}else if(n.__deferred){n=null}}i++}return n};f.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken()}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken}}};f.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"]};f.prototype.refreshSecurityToken=function(s,E,A){var t=this,u,T;A=A===true;u=this._createRequestUrl("/");var r=this._createRequest(u,"GET",A);r.headers["x-csrf-token"]="Fetch";function _(D,R){if(R){T=t._getHeader("x-csrf-token",R.headers);if(T){t.oServiceData.securityToken=T;t.oHeaders["x-csrf-token"]=T}else{t.resetSecurityToken();t.bTokenHandling=false}}if(s){s(D,R)}}function g(o){t.resetSecurityToken();t.bTokenHandling=false;t._handleError(o);if(E){E(o)}}return this._request(r,_,g,undefined,undefined,this.getServiceMetadata())};f.prototype._submitRequest=function(r,B,s,E,h){var t=this,R;function _(D,o){if(B&&h){var j=t._getBatchErrors(D);if(j.length>0){g(j[0]);return false}if(D.__batchResponses&&D.__batchResponses.length>0){R=D.__batchResponses[0].data;if(!R&&D.__batchResponses[0].__changeResponses){R=D.__batchResponses[0].__changeResponses[0].data}}D=R}t._handleETag(r,o,B);t._updateRequestQueue(r,B);if(t._isRefreshNeeded(r,o)){t.refresh(false,r.keys,r.entityTypes)}if(s){s(D,o)}}function g(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!r.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();r.bTokenReset=true;i();return}}t._handleError(o);if(E){E(o)}}function i(){if(t.bTokenHandling&&r.method!=="GET"){t.updateSecurityToken();if(t.bTokenHandling){r.headers["x-csrf-token"]=t.oServiceData.securityToken}}if(B){return t._request(r,_,g,OData.batchHandler,undefined,t.getServiceMetadata())}else{return t._request(r,_,g,t.oHandler,undefined,t.getServiceMetadata())}}return i()};f.prototype._createBatchRequest=function(B,A){var u,r,o={},p={},g=[],K={},E={};p.__batchRequests=B;u=this.sServiceUrl+"/$batch";if(this.sUrlParams){u+="?"+this.sUrlParams}q.extend(o,this.mCustomHeaders,this.oHeaders);delete o["Content-Type"];r={headers:o,requestUri:u,method:"POST",data:p,user:this.sUser,password:this.sPassword,async:A};if(A){r.withCredentials=this.bWithCredentials}q.each(B,function(i,h){if(h["__changeRequests"]){q.each(h["__changeRequests"],function(j,m){if(m.keys&&m.method!="POST"){q.each(m.keys,function(k,s){K[k]=s})}else if(m.entityTypes&&m.method=="POST"){q.each(m.entityTypes,function(l,s){E[l]=s})}})}});r.keys=K;r.entityTypes=E;return r};f.prototype._handleETag=function(r,R,B){var u,E,g,h,k,l;if(B){k=r.data.__batchRequests;l=R.data.__batchResponses;if(l&&k){for(var i=0;i<k.length;i++){g=k[i].__changeRequests;if(l[i]){h=l[i].__changeResponses;if(g&&h){for(var j=0;j<g.length;j++){if(g[j].method=="MERGE"||g[j].method=="PUT"){u=g[j].requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u}E=this._getObject(u);if(E&&E.__metadata&&h[j].headers&&h[j].headers.ETag){E.__metadata.etag=h[j].headers.ETag}}}}}else{q.sap.log.warning("could not update ETags for batch request: corresponding response for request missing")}}}else{q.sap.log.warning("could not update ETags for batch request: no batch responses/requests available")}}else{u=r.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u}E=this._getObject(u);if(E&&E.__metadata&&R.headers.ETag){E.__metadata.etag=R.headers.ETag}}};f.prototype._handleBatchErrors=function(r,D){var E=[];E=this._getBatchErrors(D);this._handleETag()};f.prototype._getBatchErrors=function(D){var E=[],s;q.each(D.__batchResponses,function(i,o){if(o.message){s="The following problem occurred: "+o.message;if(o.response){s+=o.response.statusCode+","+o.response.statusText+","+o.response.body}E.push(o);q.sap.log.fatal(s)}if(o.__changeResponses){q.each(o.__changeResponses,function(i,g){if(g.message){s="The following problem occurred: "+g.message;if(g.response){s+=g.response.statusCode+","+g.response.statusText+","+g.response.body}E.push(g);q.sap.log.fatal(s)}})}});return E};f.prototype._handleError=function(E){var p={},h,t;var s="The following problem occurred: "+E.message;p.message=E.message;if(E.response){if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()=="required"){this.resetSecurityToken()}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;p.statusCode=E.response.statusCode;p.statusText=E.response.statusText;p.responseText=E.response.body}q.sap.log.fatal(s);return p};f.prototype.getData=function(p,o,i){return this.getProperty(p,o,i)};f.prototype._getETag=function(p,P,E){var s,g,i;if(E){s=E}else{if(P&&P.__metadata){s=P.__metadata.etag}else if(p){g=p.replace(this.sServiceUrl+'/','');i=g.indexOf("?");if(i>-1){g=g.substr(0,i)}if(this.oData.hasOwnProperty(g)){s=this.getProperty('/'+g+'/__metadata/etag')}}}return s};f.prototype._createRequest=function(u,m,A,p,E){var o={},s;q.extend(o,this.mCustomHeaders,this.oHeaders);s=this._getETag(u,p,E);if(s&&m!="GET"){o["If-Match"]=s}if(this.bJSON&&m!="DELETE"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json"}if(m=="MERGE"&&!this.bUseBatch){o["x-http-method"]="MERGE";m="POST"}var r={headers:o,requestUri:u,method:m,user:this.sUser,password:this.sPassword,async:A};if(p){r.data=p}if(A){r.withCredentials=this.bWithCredentials}return r};f.prototype._isRefreshNeeded=function(r,R){var g=false,E,h=[],t=this;if(!this.bRefreshAfterChange){return g}if(r.data&&q.isArray(r.data.__batchRequests)){if(R){h=t._getBatchErrors(R.data);q.each(h,function(i,o){if(o.response&&o.response.statusCode=="412"){E=o.response.statusCode;return false}});if(!!E){return false}}q.each(r.data.__batchRequests,function(i,B){if(q.isArray(B.__changeRequests)){q.each(B.__changeRequests,function(i,o){g=g||t._isRefreshNeeded(o);return!g})}return!g})}else{if(r.method==="GET"){return false}else{if(R&&R.statusCode=="412"){g=false}else{g=true}}}return g};f.prototype.update=function(p,D,P){var s,E,m,r,u,o,g,R,B,h,S,k,i,A=false;if(P instanceof sap.ui.model.Context||arguments.length>3){o=P;s=arguments[3];E=arguments[4];m=arguments[5]}else{o=P.context||P.oContext;s=P.success||P.fnSuccess;E=P.error||P.fnError;g=P.eTag||P.sETag;m=typeof(P.merge)=="undefined"?P.bMerge===true:P.merge===true;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;i=P.urlParameters}u=this._createRequestUrl(p,o,i,this.bUseBatch);if(m){r=this._createRequest(u,"MERGE",A,D,g)}else{r=this._createRequest(u,"PUT",A,D,g)}p=this._normalizePath(p,o);S=this._getObject(p);r.keys={};if(S){k=this._getKey(S);r.keys[k]=true}if(this.bUseBatch){B=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(B,this.bUseBatch,s,E,true)}else{R=this._submitRequest(r,this.bUseBatch,s,E)}return R};f.prototype.create=function(p,D,P){var r,B,u,R,s,E,o,S,g,A=false,m;if(P&&typeof(P)=="object"&&!(P instanceof sap.ui.model.Context)){o=P.context;S=P.success;m=P.urlParameters;g=P.error;A=P.async===true}else{o=P;S=arguments[3];g=arguments[4]}u=this._createRequestUrl(p,o,m,this.bUseBatch);r=this._createRequest(u,"POST",A,D);p=this._normalizePath(p,o);E=this.oMetadata._getEntityTypeByPath(p);r.entityTypes={};if(E){r.entityTypes[E.entityType]=true}if(this.bUseBatch){B=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(B,this.bUseBatch,S,g,true)}else{R=this._submitRequest(r,this.bUseBatch,S,g)}return R};f.prototype.remove=function(p,P){var o,E,s,S,g,r,u,h,k,i,_,B,R,j,m,A=false,t=this;if((P&&P instanceof sap.ui.model.Context)||arguments[2]){o=P;S=arguments[2];g=arguments[3]}else if(P){o=P.context||P.oContext;S=P.success||P.fnSuccess;g=P.error||P.fnError;h=P.eTag||P.sETag;i=P.payload||P.oPayload;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;m=P.urlParameters}_=function(D,l){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!=-1){E=E.substr(0,E.indexOf('?'))}delete t.oData[E];delete t.mContexts["/"+E];if(S){S(D,l)}};u=this._createRequestUrl(p,o,m,this.bUseBatch);r=this._createRequest(u,"DELETE",A,i,h);p=this._normalizePath(p,o);s=this._getObject(p);r.keys={};if(s){k=this._getKey(s);r.keys[k]=true}if(this.bUseBatch){B=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(B,this.bUseBatch,_,g,true)}else{R=this._submitRequest(r,this.bUseBatch,_,g)}return R};f.prototype.callFunction=function(F,p){var r,B,u,R,o,P,g,s,E,A,m="GET",h={},t=this;if(p&&typeof(p)=="object"){m=p.method?p.method:m;P=p.urlParameters;g=p.context;s=p.success;E=p.error;A=p.async===true}else{m=p;P=arguments[2];g=arguments[3];s=arguments[4];E=arguments[5];A=arguments[6]===true}o=this.oMetadata._getFunctionImportMetadata(F,m);if(o){u=this._createRequestUrl(F,g,null,this.bUseBatch);var i=URI(u);if(o.parameter!=null){q.each(P,function(j,k){var l=q.grep(o.parameter,function(v){return v.name==j&&v.mode=="In"});if(l!=null&&l.length>0){var n=l[0];h[j]=t.formatValue(k,n.type)}else{q.sap.log.warning("Parameter "+j+" is not defined for function call "+F+"!")}})}if(m==="GET"){return t.read(F,g,h,true,s,E)}else{q.each(h,function(j,k){i.addQuery(j,k)});r=this._createRequest(i.toString(),m,A);if(this.bUseBatch){B=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(B,this.bUseBatch,s,E,true)}else{R=this._submitRequest(r,this.bUseBatch,s,E)}return R}}};f.prototype.read=function(p,P){var r,u,R,B,o,m,A,s,E,t=this;if(P&&typeof(P)=="object"&&!(P instanceof sap.ui.model.Context)){o=P.context;m=P.urlParameters;A=P.async!==false;s=P.success;E=P.error}else{o=P;m=arguments[2];A=arguments[3]!==false;s=arguments[4];E=arguments[5]}A=A!==false;u=this._createRequestUrl(p,o,m,this.bUseBatch);r=this._createRequest(u,"GET",A);if(this.bUseBatch){B=this._createBatchRequest([r],A);R=this._submitRequest(B,this.bUseBatch,s,E,true)}else{R=this._submitRequest(r,this.bUseBatch,s,E)}return R};f.prototype.createBatchOperation=function(p,m,D,P){var o={},E,s,k,g;q.extend(o,this.mCustomHeaders,this.oHeaders);if(q.sap.startsWith(p,"/")){p=p.substr(1)}if(P){E=P.sETag}if(m!="GET"){E=this._getETag(p,D,E);if(E){o["If-Match"]=E}}if(this.bJSON){if(m!="DELETE"&&m!="GET"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json"}}else{o["Content-Type"]="application/atom+xml"}var r={requestUri:p,method:m.toUpperCase(),headers:o};if(D){r.data=D}if(m!="GET"&&m!="POST"){if(p.indexOf("/")!=0){p='/'+p}s=this._getObject(p);if(s){k=this._getKey(s);r.keys={};r.keys[k]=true}}else if(m=="POST"){g=this.oMetadata._getEntityTypeByPath(p);if(g){r.entityTypes={};r.entityTypes[g.entityType]=true}}return r};f.prototype.addBatchReadOperations=function(r){if(!q.isArray(r)||r.length<=0){q.sap.log.warning("No array with batch operations provided!");return false}var t=this;q.each(r,function(i,R){if(R.method!="GET"){q.sap.log.warning("Batch operation should be a GET operation!");return false}t.aBatchOperations.push(R)})};f.prototype.addBatchChangeOperations=function(g){if(!q.isArray(g)||g.length<=0){return false}q.each(g,function(i,o){if(o.method!="POST"&&o.method!="PUT"&&o.method!="MERGE"&&o.method!="DELETE"){q.sap.log.warning("Batch operation should be a POST/PUT/MERGE/DELETE operation!");return false}});this.aBatchOperations.push({__changeRequests:g})};f.prototype.clearBatch=function(){this.aBatchOperations=[]};f.prototype.submitBatch=function(s,E,A){var r,u,R,t=this;function _(D,h){if(s){s(D,h,t._getBatchErrors(D))}}if(!(typeof(s)=="function")){var o=A;var g=E;A=s;s=g;E=o}A=A!==false;if(this.aBatchOperations.length<=0){q.sap.log.warning("No batch operations in batch. No request will be triggered!");return false}r=this._createBatchRequest(this.aBatchOperations,A);R=this._submitRequest(r,true,_,E,false);this.clearBatch();return R};f.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.getServiceMetadata){return this.oMetadata.getServiceMetadata()}};f.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData()}};f.prototype.submitChanges=function(s,E,p){var r,P,t=this,g,h,T,m,S,k;if(this.sChangeKey){g=this.sChangeKey.replace(this.sServiceUrl,'');S=this._getObject(g);P=S;if(q.isPlainObject(S)){P=q.extend(true,{},S);if(P.__metadata){T=P.__metadata.type;m=P.__metadata.etag;delete P.__metadata;if(T||m){P.__metadata={}}if(T){P.__metadata.type=T}if(!!m){P.__metadata.etag=m}}q.each(P,function(j,l){if(l&&l.__deferred){delete P[j]}});var o=this.oMetadata._getEntityTypeByPath(g);if(o){var n=this.oMetadata._getNavigationPropertyNames(o);q.each(n,function(I,N){delete P[N]})}P=this._removeReferences(P)}if(p&&p.sETag){h=p.sETag}r=this._createRequest(this.sChangeKey,"MERGE",true,P,h);r.keys={};if(S){k=this._getKey(S);r.keys[k]=true}this.oRequestQueue[this.sChangeKey]=r}if(this.bUseBatch){var i=[];q.each(this.oRequestQueue,function(k,j){j.requestUri=j.requestUri.replace(t.sServiceUrl+'/','');j.data._bCreate?delete j.data._bCreate:false;i.push(j)});r=this._createBatchRequest([{__changeRequests:i}],true);this._submitRequest(r,this.bUseBatch,s,E,true)}else{q.each(this.oRequestQueue,function(k,j){j.data._bCreate?delete j.data._bCreate:false;t._submitRequest(j,this.bUseBatch,s,E,true)})}return undefined};f.prototype._updateRequestQueue=function(r,B){var g,h,o,t=this;if(B){g=r.data.__batchRequests;if(g){for(var i=0;i<g.length;i++){h=g[i].__changeRequests;if(h){for(var j=0;j<h.length;j++){o=h[j];q.each(this.oRequestQueue,function(k,l){if(l===o&&k!==t.sChangeKey){delete t.oRequestQueue[k];delete t.oData[k];delete t.mContexts["/"+k]}else if(t.sChangeKey&&k===t.sChangeKey){delete t.oRequestQueue[k];t.sChangeKey=null}})}}}}}else{q.each(this.oRequestQueue,function(k,l){if(l===r&&k!==t.sChangeKey){delete t.oRequestQueue[k];delete t.oData[k];delete t.mContexts["/"+k]}else if(t.sChangeKey&&k===t.sChangeKey){delete t.oRequestQueue[k];t.sChangeKey=null}})}};f.prototype.resetChanges=function(s,E){var p;if(this.sChangeKey){p=this.sChangeKey.replace(this.sServiceUrl,'');this._loadData(p,null,s,E)}};f.prototype.setProperty=function(p,v,o){var P,E={},D={},s=this._createRequestUrl(p,o),g=p.substring(0,p.lastIndexOf("/")),k,h,m={},j=false;if(!this.resolve(p,o)){return false}s=s.replace(this.sServiceUrl+'/','');s=s.substring(0,s.indexOf("/"));s=this.sServiceUrl+'/'+s;P=p.substr(p.lastIndexOf("/")+1);D=this._getObject(g,o);if(!D){return false}h=g.split("/");for(var i=h.length-1;i>=0;i--){E=this._getObject(h.join("/"),o);if(E){k=this._getKey(E);if(k){break}}h.splice(i-1,1)}if(!k){k=this._getKey(o)}if(k){m[k]=true}if(D._bCreate){D[P]=v;j=true;this.checkUpdate(false,m)}else{if(!this.sChangeKey){this.sChangeKey=s}if(this.sChangeKey==s){D[P]=v;j=true;this.checkUpdate(false,m)}else{this.fireRejectChange({rejectedValue:v,oldValue:D[P]})}}return j};f.prototype._isHeaderPrivate=function(h){switch(h.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;break;case"x-csrf-token":return this.bTokenHandling;break;default:return false}};f.prototype.setHeaders=function(h){var m={},t=this;if(h){q.each(h,function(H,s){if(t._isHeaderPrivate(H)){q.sap.log.warning("Not allowed to modify private header: "+H)}else{m[H]=s}});this.mCustomHeaders=m}else{this.mCustomHeaders={}}};f.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders)};f.prototype._getHeader=function(F,h){var H;for(H in h){if(H.toLowerCase()===F.toLowerCase()){return h[H]}}return null};f.prototype.hasPendingChanges=function(){return this.sChangeKey!=null};f.prototype.updateBindings=function(F){this.checkUpdate(F)};f.prototype.forceNoCache=function(F){this.bCache=!F};f.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t};f.prototype.setUseBatch=function(u){this.bUseBatch=u};f.prototype.formatValue=function(v,t){if(!this.oDateTimeFormat){this.oDateTimeFormat=sap.ui.core.format.DateFormat.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''"});this.oDateTimeOffsetFormat=sap.ui.core.format.DateFormat.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''"});this.oTimeFormat=sap.ui.core.format.DateFormat.getTimeInstance({pattern:"'time'''HH:mm:ss''"})}var V;switch(t){case"Edm.String":V="'"+String(v).replace(/'/g,"''")+"'";break;case"Edm.Time":V="time'"+v+"'";break;case"Edm.DateTime":V=this.oDateTimeFormat.format(new Date(v),true);break;case"Edm.DateTimeOffset":V=this.oDateTimeOffsetFormat.format(new Date(v),true);break;case"Edm.Guid":V="guid'"+v+"'";break;case"Edm.Decimal":V=v+"M";break;case"Edm.Int64":V=v+"L";break;case"Edm.Single":V=v+"f";break;case"Edm.Binary":V="binary'"+v+"'";break;default:V=new String(v);break}return V};f.prototype.deleteCreatedEntry=function(o){if(o){var p=o.getPath();delete this.mContexts[p];if(q.sap.startsWith(p,"/")){p=p.substr(1)}delete this.oRequestQueue[p];delete this.oData[p]}};f.prototype.createEntry=function(p,P){var E={},k,u,r;if(!q.sap.startsWith(p,"/")){p="/"+p}var o=this.oMetadata._getEntityTypeByPath(p);if(!o){return undefined}if(typeof P==="object"&&!q.isArray(P)){E=P}else{for(var i=0;i<o.property.length;i++){var g=o.property[i];var t=g.type.split('.');var h=q.inArray(g.name,P)>-1;if(!P||h){E[g.name]=this._createPropertyValue(t);if(h){P.splice(P.indexOf(g.name),1)}}}if(P){}}E._bCreate=true;k=p.substring(1)+"('"+q.sap.uid()+"')";this.oData[k]=E;E.__metadata={type:""+o.entityType};u=this._createRequestUrl(p);r=this._createRequest(u,"POST",true,E);r.entityTypes={};r.entityTypes[o.entityType]=true;this.oRequestQueue[k]=r;return this.getContext("/"+k)};f.prototype._createPropertyValue=function(t){var n=t[0];var T=t[1];if(n.toUpperCase()!=='EDM'){var o={};var g=this.oMetadata._getObjectMetadata("complexType",T,n);for(var i=0;i<g.property.length;i++){var p=g.property[i];var t=p.type.split('.');o[p.name]=this._createPropertyValue(t)}return o}else{return this._getDefaultPropertyValue(T,n)}};f.prototype._getDefaultPropertyValue=function(t,n){return undefined};f.prototype._normalizePath=function(p,o){if(p.indexOf('?')!=-1){p=p.substr(0,p.indexOf('?'))}if(!o&&!q.sap.startsWith(p,"/")){p='/'+p;q.sap.log.warning("sPath should be absolute if no Context is set")}return this.resolve(p,o)};f.prototype.setRefreshAfterChange=function(r){this.bRefreshAfterChange=r};f.prototype.isList=function(p,o){var p=this.resolve(p,o);return p&&p.substr(p.lastIndexOf("/")).indexOf("(")===-1};f.prototype._request=function(r,s,E,h,H,m){if(this.bDestroyed){return{abort:function(){}}}var t=this;function w(g){return function(){var i=q.inArray(R,t.aPendingRequestHandles);if(i>-1){t.aPendingRequestHandles.splice(i,1)}if(!(R&&R.bSuppressErrorHandlerCall)){g.apply(this,arguments)}}}var R=OData.request(r,w(s||OData.defaultSuccess),w(E||OData.defaultError),h,H,m);if(r.async!==false){this.aPendingRequestHandles.push(R)}return R};f.prototype.destroy=function(){if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var r=this.aPendingRequestHandles[i];if(r&&r.abort){r.bSuppressErrorHandlerCall=true;r.abort()}}delete this.aPendingRequestHandles}if(this.oMetadata){this.oMetadata.destroy();delete this.oMetadata}if(this.oAnnotations){this.oAnnotations.destroy();delete this.oAnnotations}M.prototype.destroy.apply(this,arguments)};return f},true);
