/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.table.Column");jQuery.sap.require("sap.ui.table.library");jQuery.sap.require("sap.ui.core.Element");sap.ui.core.Element.extend("sap.ui.table.Column",{metadata:{publicMethods:["sort","toggleSort"],library:"sap.ui.table",properties:{"width":{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},"flexible":{type:"boolean",group:"Behavior",defaultValue:true},"resizable":{type:"boolean",group:"Behavior",defaultValue:true},"hAlign":{type:"sap.ui.commons.layout.HAlign",group:"Appearance",defaultValue:sap.ui.commons.layout.HAlign.Begin},"sorted":{type:"boolean",group:"Appearance",defaultValue:false},"sortOrder":{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:sap.ui.table.SortOrder.Ascending},"sortProperty":{type:"string",group:"Behavior",defaultValue:null},"filtered":{type:"boolean",group:"Appearance",defaultValue:false},"filterProperty":{type:"string",group:"Behavior",defaultValue:null},"filterValue":{type:"string",group:"Behavior",defaultValue:null},"filterOperator":{type:"string",group:"Behavior",defaultValue:null},"grouped":{type:"boolean",group:"Appearance",defaultValue:false},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"filterType":{type:"any",group:"Misc",defaultValue:null},"name":{type:"string",group:"Appearance",defaultValue:null},"showFilterMenuEntry":{type:"boolean",group:"Appearance",defaultValue:true},"showSortMenuEntry":{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"label",aggregations:{"label":{type:"sap.ui.core.Control",multiple:false},"multiLabels":{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},"template":{type:"sap.ui.core.Control",multiple:false},"menu":{type:"sap.ui.commons.Menu",multiple:false}}}});jQuery.sap.require("sap.ui.core.RenderManager");jQuery.sap.require("sap.ui.model.Type");jQuery.sap.require("sap.ui.model.Filter");jQuery.sap.require("sap.ui.model.Sorter");jQuery.sap.require("sap.ui.commons.Image");jQuery.sap.require("sap.ui.commons.Label");jQuery.sap.require("sap.ui.commons.TextField");jQuery.sap.require("sap.ui.model.type.String");sap.ui.table.Column._DEFAULT_FILTER_TYPE=new sap.ui.model.type.String();
sap.ui.table.Column.prototype.init=function(){this.oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._oSorter=null};
sap.ui.table.Column.prototype.exit=function(){var s=sap.ui.getCore().byId(this.getId()+"-sortIcon");if(s){s.destroy()}var f=sap.ui.getCore().byId(this.getId()+"-filterIcon");if(f){f.destroy()}};
sap.ui.table.Column.prototype.invalidate=function(o){if(o!==this.getTemplate()&&!(o instanceof sap.ui.table.ColumnMenu)){sap.ui.core.Element.prototype.invalidate.apply(this,arguments)}};
sap.ui.table.Column.prototype.setVisible=function(v){var t=this.getParent();var e=true;if(t){e=t.fireColumnVisibility({column:this,newVisible:v})}if(e){this.setProperty("visible",v)}return this};
sap.ui.table.Column.prototype.setLabel=function(l){var L=l;if(typeof(l)==="string"){L=new sap.ui.commons.Label({text:l})}this.setAggregation("label",L);return this};
sap.ui.table.Column.prototype.setTemplate=function(t){var T=t;if(typeof(t)==="string"){T=new sap.ui.commons.TextView().bindText(t)}this.setAggregation("template",T);this.invalidate();return this};
sap.ui.table.Column.prototype.getMenu=function(){var m=this.getAggregation("menu");if(!m){m=this._createMenu();this.setMenu(m)}return m};
sap.ui.table.Column.prototype.setMenu=function(m){this.setAggregation("menu",m,true);return this};
sap.ui.table.Column.prototype._createMenu=function(){jQuery.sap.require("sap.ui.table.ColumnMenu");return new sap.ui.table.ColumnMenu(this.getId()+"-menu")};
sap.ui.table.Column.prototype.setWidth=function(w){this.setProperty("width",w);this.fireEvent('_widthChanged',{newWidth:w});return this};
sap.ui.table.Column.prototype.setSorted=function(f){this.setProperty("sorted",f,true);this._renderSortIcon();return this};
sap.ui.table.Column.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._renderSortIcon();return this};
sap.ui.table.Column.prototype.setFiltered=function(f){this.setProperty("filtered",f,true);this._renderFilterIcon();return this};
sap.ui.table.Column.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);if(this.getMenu()){this.getMenu()._setFilterValue(v)}return this};
sap.ui.table.Column.prototype.onmousedown=function(e){var m=this.getAggregation("menu");this._bSkipOpen=m&&m.bOpen};
sap.ui.table.Column.prototype.onmouseout=function(e){if(this._bSkipOpen&&jQuery.sap.checkMouseEnterOrLeave(e,this.getDomRef())){this._bSkipOpen=false}};
sap.ui.table.Column.prototype._openMenu=function(){if(this._bSkipOpen){this._bSkipOpen=false;return}var m=this.getMenu();var e=sap.ui.core.Popup.Dock;m.open(false,this.getFocusDomRef(),e.BeginTop,e.BeginBottom,this.getDomRef(),"none none")};
sap.ui.table.Column.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===sap.ui.table.SortOrder.Ascending)};
sap.ui.table.Column.prototype.sort=function(d,a){var t=this.getParent();if(t){var n=d?sap.ui.table.SortOrder.Descending:sap.ui.table.SortOrder.Ascending;var e=t.fireSort({column:this,sortOrder:n,columnAdded:a});if(e){var s=[];var c=t.getColumns();if(a){for(var i=0,l=c.length;i<l;i++){if(c[i]==this){this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new sap.ui.model.Sorter(this.getSortProperty(),this.getSortOrder()===sap.ui.table.SortOrder.Descending);s.push(this._oSorter)}else{var S=c[i]._oSorter;if(S){s.push(S)}}}}else{for(var i=0,l=c.length;i<l;i++){if(c[i]!==this){c[i].setProperty("sorted",false,true);c[i].setProperty("sortOrder",sap.ui.table.SortOrder.Ascending,true);c[i]._renderSortIcon()}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new sap.ui.model.Sorter(this.getSortProperty(),this.getSortOrder()===sap.ui.table.SortOrder.Descending);s.push(this._oSorter)}if(t.isBound("rows")){t.getBinding("rows").sort(s)}this._renderSortIcon()}}return this};
sap.ui.table.Column.prototype._renderSortIcon=function(){var t=this.getParent();if(t&&t.getDomRef()){if(this.getSorted()){var c=sap.ui.getCore().getConfiguration().getTheme();var i=sap.ui.getCore().byId(this.getId()+"-sortIcon")||new sap.ui.commons.Image(this.getId()+"-sortIcon");i.addStyleClass("sapUiTableColIconsOrder");if(this.getSortOrder()===sap.ui.table.SortOrder.Ascending){i.setSrc(sap.ui.resource("sap.ui.table","themes/"+c+"/img/ico12_sort_asc.gif"))}else{i.setSrc(sap.ui.resource("sap.ui.table","themes/"+c+"/img/ico12_sort_desc.gif"))}var r=new sap.ui.core.RenderManager();var h=r.getHTML(i);this.$().find(".sapUiTableColIconsOrder").remove();jQuery(h).prependTo(this.getDomRef("icons"));this.$().attr("aria-sort",this.getSortOrder()===sap.ui.table.SortOrder.Ascending?"ascending":"descending");this.$().find(".sapUiTableColCell").addClass("sapUiTableColSorted")}else{this.$().find(".sapUiTableColIconsOrder").remove();this.$().removeAttr("aria-sort");this.$().find(".sapUiTableColCell").removeClass("sapUiTableColSorted")}}};
sap.ui.table.Column.prototype._getFilter=function(){var f=undefined,p=this.getFilterProperty(),v=this.getFilterValue(),o=this.getFilterOperator(),P,s,t=this.getFilterType()||sap.ui.table.Column._DEFAULT_FILTER_TYPE,i=t instanceof sap.ui.model.type.String,b;if(v){if(!o){b=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){o=sap.ui.model.FilterOperator.EQ;P=v.substr(1)}else if(v.indexOf("!=")==0){o=sap.ui.model.FilterOperator.NE;P=v.substr(2)}else if(v.indexOf("<=")==0){o=sap.ui.model.FilterOperator.LE;P=v.substr(2)}else if(v.indexOf("<")==0){o=sap.ui.model.FilterOperator.LT;P=v.substr(1)}else if(v.indexOf(">=")==0){o=sap.ui.model.FilterOperator.GE;P=v.substr(2)}else if(v.indexOf(">")==0){o=sap.ui.model.FilterOperator.GT;P=v.substr(1)}else if(b){if(b[1]&&b[2]){o=sap.ui.model.FilterOperator.BT;P=b[1];s=b[2]}else if(b[1]&&!b[2]){o=sap.ui.model.FilterOperator.GE;P=b[1]}else{o=sap.ui.model.FilterOperator.LE;P=b[2]}}else if(i&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){o=sap.ui.model.FilterOperator.Contains;P=v.substr(1,v.length-2)}else if(i&&v.indexOf("*")==0){o=sap.ui.model.FilterOperator.EndsWith;P=v.substr(1)}else if(i&&v.lastIndexOf("*")==v.length-1){o=sap.ui.model.FilterOperator.StartsWith;P=v.substr(0,v.length-1)}else{if(i){o=sap.ui.model.FilterOperator.Contains}else{o=sap.ui.model.FilterOperator.EQ}P=v.substr(0)}if(!s){f=new sap.ui.model.Filter(p,o,this._parseFilterValue(P))}else{f=new sap.ui.model.Filter(p,o,this._parseFilterValue(P),this._parseFilterValue(s))}}else{f=new sap.ui.model.Filter(p,o,this._parseFilterValue(v))}}return f};
sap.ui.table.Column.prototype.filter=function(v){var t=this.getParent();if(t.isBound("rows")){var E=t.fireFilter({column:this,value:v});if(E){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var f=[];var c=t.getColumns();for(var i=0,l=c.length;i<l;i++){var C=c[i],m=C.getMenu(),F;try{F=C._getFilter()}catch(e){m._setFilterState(sap.ui.core.ValueState.Error);continue}if(F){f.push(F);m._setFilterState(sap.ui.core.ValueState.None)}}t.getBinding("rows").filter(f,sap.ui.model.FilterType.Control);this._renderFilterIcon()}}return this};
sap.ui.table.Column.prototype._parseFilterValue=function(v){var f=this.getFilterType();if(f){if(jQuery.isFunction(f)){v=f(v)}else{v=f.parseValue(v,"string")}}return v};
sap.ui.table.Column.prototype._renderFilterIcon=function(){var t=this.getParent();if(t&&t.getDomRef()){var c=sap.ui.getCore().getConfiguration().getTheme();var i=sap.ui.getCore().byId(this.getId()+"-filterIcon")||new sap.ui.commons.Image(this.getId()+"-filterIcon");i.$().remove();i.addStyleClass("sapUiTableColIconsFilter");if(this.getFiltered()){i.setSrc(sap.ui.resource("sap.ui.table","themes/"+c+"/img/ico12_filter.gif"));var r=new sap.ui.core.RenderManager();var h=r.getHTML(i);jQuery(h).prependTo(this.getDomRef("icons"));this.$().find(".sapUiTableColCell").addClass("sapUiTableColFiltered")}else{this.$().find(".sapUiTableColCell").removeClass("sapUiTableColFiltered")}}};
sap.ui.table.Column.prototype._restoreIcons=function(){if(this.getSorted()){this._renderSortIcon()}if(this.getFiltered()){this._renderFilterIcon()}};
sap.ui.table.Column.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()};
