/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.ActionSheet");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.m.ActionSheet",{metadata:{publicMethods:["openBy","close","isOpen"],library:"sap.m",properties:{"placement":{type:"sap.m.PlacementType",group:"Appearance",defaultValue:sap.m.PlacementType.Bottom},"showCancelButton":{type:"boolean",group:"Appearance",defaultValue:true},"cancelButtonText":{type:"string",group:"Appearance",defaultValue:null},"title":{type:"string",group:"Appearance",defaultValue:null}},aggregations:{"buttons":{type:"sap.m.Button",multiple:true,singularName:"button"},"_cancelButton":{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{"cancelButtonTap":{deprecated:true},"beforeOpen":{},"afterOpen":{},"beforeClose":{},"afterClose":{},"cancelButtonPress":{}}}});sap.m.ActionSheet.M_EVENTS={'cancelButtonTap':'cancelButtonTap','beforeOpen':'beforeOpen','afterOpen':'afterOpen','beforeClose':'beforeClose','afterClose':'afterClose','cancelButtonPress':'cancelButtonPress'};jQuery.sap.require("sap.m.Dialog");jQuery.sap.require("sap.m.Popover");jQuery.sap.require("sap.ui.core.delegate.ItemNavigation");
sap.m.ActionSheet.prototype.init=function(){this._oItemNavigation=new sap.ui.core.delegate.ItemNavigation();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation)};
sap.m.ActionSheet.prototype.exit=function(){if(this._parent){this._parent.destroy();this._parent=null}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};
sap.m.ActionSheet.prototype._setItemNavigation=function(){var b=this.getButtons(),d=[],D=this.getDomRef();if(D){this._oItemNavigation.setRootDomRef(D);for(var i=0;i<b.length;i++){if(b[i].getEnabled()){d.push(b[i].getFocusDomRef())}}if(this._oCancelButton){d.push(this._oCancelButton.getFocusDomRef())}this._oItemNavigation.setItemDomRefs(d);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(d.length)}};
sap.m.ActionSheet.prototype.onAfterRendering=function(){this._setItemNavigation();this.$().on("keyup.ActionSheet",jQuery.proxy(this.onKeyUp,this))};
sap.m.ActionSheet.prototype.onBeforeRendering=function(){if(this.getDomRef()){this.$().off("keyup.ActionSheet")}};
sap.m.ActionSheet.prototype.onKeyUp=function(e){if(e.which==jQuery.sap.KeyCodes.ESCAPE){this.close();e.stopPropagation();e.preventDefault()}};
sap.m.ActionSheet.prototype.sapfocusleave=function(){this.close()};
sap.m.ActionSheet.prototype.openBy=function(c){var t=this;if(!this._parent){var o=this.getParent();if(o){this.setParent(null)}if(!sap.ui.Device.system.phone){this._parent=new sap.m.Popover({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen()},afterOpen:function(){t.focus();t.fireAfterOpen()},beforeClose:function(){t.fireBeforeClose()},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress()}t.fireAfterClose()}}).addStyleClass("sapMActionSheetPopover");if(sap.ui.Device.browser.internet_explorer){this._parent._fnSetArrowPosition=jQuery.proxy(function(){sap.m.Popover.prototype._setArrowPosition.apply(this);var $=this.$(),C=$.children(".sapMPopoverCont")[0].getBoundingClientRect().width;jQuery.each($.find(".sapMActionSheet > .sapMBtn"),function(i,b){var a=jQuery(b),B;a.css("width","");B=b.getBoundingClientRect().width;if(B<=C){a.css("width","100%")}})},this._parent)}}else{this._parent=new sap.m.Dialog({title:this.getTitle(),type:sap.m.DialogType.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen()},afterOpen:function(){t.focus();t.fireAfterOpen()},beforeClose:function(e){t.fireBeforeClose({origin:e.getParameter("origin")})},afterClose:function(e){t.fireAfterClose({origin:e.getParameter("origin")})}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle")}if(!sap.ui.Device.system.phone){this._parent.setBeginButton(this._getCancelButton())}if(sap.ui.Device.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){var $=this.$(),a=this.$("cont");$.css({"width":"100%","max-height":"100%","left":"0px","right":"","bottom":"",});a.css("max-height","")};function g(y){return"translate3d(0px, "+(y>0?y:0)+"px, 0px)"};this._parent._openAnimation=function($,r,O){var a=jQuery(window),w=a.height(),s=g(w);$.css({"top":"0px","-webkit-transform":s,"-moz-transform":s,"transform":s,"display":"block"});$.bind("webkitTransitionEnd transitionend",function(){jQuery(this).unbind("webkitTransitionEnd transitionend");$.removeClass("sapMDialogSliding");O()});setTimeout(function(){var T=w-$.outerHeight(),e=g(T);$.css({"-webkit-transform":e,"-moz-transform":e,"transform":e}).addClass("sapMDialogSliding").removeClass("sapMDialogHidden")},0)};this._parent._closeAnimation=function($,r,C){var a=jQuery(window),T=g(a.height());$.bind("webkitTransitionEnd transitionend",function(){jQuery(this).unbind("webkitTransitionEnd transitionend");$.removeClass("sapMDialogSliding");C()});$.css({"-webkit-transform":T,"-moz-transform":T,"transform":T}).addClass("sapMDialogSliding")};this._parent.oPopup.setAnimations(jQuery.proxy(this._parent._openAnimation,this._parent),jQuery.proxy(this._parent._closeAnimation,this._parent));this._parent._adjustScrollingPane=function(){var $=this.$(),h=$.height(),H=$.children("header.sapMIBar").outerHeight(true),a=this.$("cont");a.css("max-height",h-H);if(this._oScroller){this._oScroller.refresh()}};this._parent._fnOrientationChange=jQuery.proxy(function(){this._setDimensions();var $=jQuery(window),w=$.height(),a=this.$(),T=w-a.outerHeight(),s=g(T),b=this.$("cont");a.css({"-webkit-transform":s,"-moz-transform":s,"transform":s});this._adjustScrollingPane()},this._parent)}}if(o){o.addDependent(this._parent)}}if(!sap.ui.Device.system.phone){this._parent.openBy(c)}else{this._parent.open()}};
sap.m.ActionSheet.prototype.close=function(c){if(this._parent){this._parent.close()}};
sap.m.ActionSheet.prototype.isOpen=function(c){return!!this._parent&&this._parent.isOpen()};
sap.m.ActionSheet.prototype._createCancelButton=function(){if(!this._oCancelButton){var c=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new sap.m.Button(this.getId()+'-cancelBtn',{text:c,type:sap.m.ButtonType.Reject,press:function(){if(sap.ui.Device.system.phone&&t._parent){t._parent._oCloseTrigger=this}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress()}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(sap.ui.Device.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true)}}return this};
sap.m.ActionSheet.prototype._getCancelButton=function(){if(sap.ui.Device.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton}return null};
sap.m.ActionSheet.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t)}return this};
sap.m.ActionSheet.prototype._preProcessActionButton=function(b){var t=b.getType();if(t!==sap.m.ButtonType.Accept&&t!==sap.m.ButtonType.Reject){b.setType(sap.m.ButtonType.Transparent)}b.addStyleClass("sapMBtnInverted");return this};
sap.m.ActionSheet.prototype.setShowCancelButton=function(v){if(this._parent){if(sap.ui.Device.system.phone){this.setProperty("showCancelButton",v,false)}}else{this.setProperty("showCancelButton",v,true)}return this};
sap.m.ActionSheet.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._parent&&sap.ui.Device.system.phone){this._parent.setTitle(t)}if(this._parent){if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle")}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle")}}return this};
sap.m.ActionSheet.prototype.setPlacement=function(p){this.setProperty("placement",p,true);if(!sap.ui.Device.system.phone){if(this._parent){this._parent.setPlacement(p)}}return this};
sap.m.ActionSheet.prototype._buttonSelected=function(){if(sap.ui.Device.system.phone&&this._parent){this._parent._oCloseTrigger=this}this.close()};
sap.m.ActionSheet.prototype.addButton=function(b){this.addAggregation("buttons",b,false);this._preProcessActionButton(b);b.attachPress(this._buttonSelected,this);return this};
sap.m.ActionSheet.prototype.insertButton=function(b,i){this.insertAggregation("buttons",b,i,false);this._preProcessActionButton(b);b.attachPress(this._buttonSelected,this);return this};
sap.m.ActionSheet.prototype.removeButton=function(b){var r=this.removeAggregation("buttons",b,false);if(r){r.detachPress(this._buttonSelected,this)}return r};
sap.m.ActionSheet.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;jQuery.each(r,function(i,b){b.detachPress(t._buttonSelected,t)});return r};
sap.m.ActionSheet.prototype.clone=function(){var b=this.getButtons();for(var i=0;i<b.length;i++){var B=b[i];B.detachPress(this._buttonSelected,this)}var c=sap.ui.core.Control.prototype.clone.apply(this,arguments);for(var i=0;i<b.length;i++){var B=b[i];B.attachPress(this._buttonSelected,this)}return c};
