/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.TabStrip");jQuery.sap.require("sap.ui.commons.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.commons.TabStrip",{metadata:{publicMethods:["createTab","closeTab"],library:"sap.ui.commons",properties:{"height":{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},"width":{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},"selectedIndex":{type:"int",group:"Misc",defaultValue:0}},defaultAggregation:"tabs",aggregations:{"tabs":{type:"sap.ui.commons.Tab",multiple:true,singularName:"tab"}},events:{"select":{},"close":{}}}});sap.ui.commons.TabStrip.M_EVENTS={'select':'select','close':'close'};jQuery.sap.require("sap.ui.core.delegate.ItemNavigation");
sap.ui.commons.TabStrip.prototype.onAfterRendering=function(){var f=this.getFocusDomRef(),t=f.lastChild.childNodes,T=[],s=-1;for(var i=0;i<t.length;i++){T.push(t[i]);if(jQuery(t[i]).hasClass("sapUiTabSel")){s=i}}if(!this.oItemNavigation){this.oItemNavigation=new sap.ui.core.delegate.ItemNavigation();this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(T);this.oItemNavigation.setSelectedIndex(s);var t=this.getTabs();for(var i=0;i<t.length;i++){t[i].onAfterRendering()}};
sap.ui.commons.TabStrip.prototype.createTab=function(t,c){var T=this.getTabs(),o=new sap.ui.core.Title(this.getId()+"-"+T.length+"-title",{text:t}),a=new sap.ui.commons.Tab(this.getId()+"-"+T.length);a.setTitle(o);a.addContent(c);this.addTab(a);return a};
sap.ui.commons.TabStrip.prototype.selectTabByDomRef=function(d){var i=this.getItemIndex(d);if(i>-1){if((i!=this.getSelectedIndex())&&(this.getTabs()[i].getEnabled())){var o=this.getSelectedIndex();this.setProperty('selectedIndex',i,true);this.rerenderPanel(o);this.oItemNavigation.setSelectedIndex(this.oItemNavigation.getFocusedIndex());this.fireSelect({index:i})}}};
sap.ui.commons.TabStrip.prototype.onsapspace=function(e){var s=e.target;this.selectTabByDomRef(s)};
sap.ui.commons.TabStrip.prototype.onsapspacemodifiers=sap.ui.commons.TabStrip.prototype.onsapspace;sap.ui.commons.TabStrip.prototype.onsapenter=sap.ui.commons.TabStrip.prototype.onsapspace;sap.ui.commons.TabStrip.prototype.onsapentermodifiers=sap.ui.commons.TabStrip.prototype.onsapspace;
sap.ui.commons.TabStrip.prototype.onsapdelete=function(e){var s=e.target;var i=this.getItemIndex(s);if(i>-1&&this.getTabs()[i].getClosable()){this.fireClose({index:i})}};
sap.ui.commons.TabStrip.prototype.onclick=function(e){var s=e.target,d=this.getDomRef();if(s.className=="sapUiTabClose"){var i=this.getItemIndex(jQuery(s).parentByAttribute("id"));if(i>-1){this.fireClose({index:i})}return}this.selectTabByDomRef(s)};
sap.ui.commons.TabStrip.prototype.getFocusDomRef=function(){return this.getDomRef().firstChild};
sap.ui.commons.TabStrip.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}};
sap.ui.commons.TabStrip.prototype.getItemIndex=function(d){var i;if(!d.id||d.id.search("-close")!=-1){var I=jQuery(d).parentByAttribute("id");i=I.id}else{i=d.id}for(var a=0,t=this.getTabs();a<t.length;a++){if(i==t[a].getId()){return a}}return-1};
sap.ui.commons.TabStrip.prototype.removeTab=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e)}if(typeof(e)=="object"){i=this.indexOfTab(e)}var t=this.getTabs()[i];if(t.getVisible()){t.setProperty("visible",false,true);this.hideTab(i);t.setProperty("visible",true,true)}if(this.getSelectedIndex()>i){this.setProperty('selectedIndex',this.getSelectedIndex()-1,true)}return this.removeAggregation("tabs",i,true)};
sap.ui.commons.TabStrip.prototype.setSelectedIndex=function(s){var o=this.getSelectedIndex();if(s==o){return this}var t=this.getTabs();var T=t[s];if(!T&&!this.getDomRef()){this.setProperty('selectedIndex',s,false)}else if(T&&T.getEnabled()&&T.getVisible()){this.setProperty('selectedIndex',s,true);if(this.getDomRef()&&!this.invalidated){this.rerenderPanel(o);if(this.oItemNavigation){var v=0;var S=-1;for(var i=0;i<t.length;i++){T=t[i];if(T.getVisible()===false){continue}if(i==s){S=v;break}v++}this.oItemNavigation.setSelectedIndex(S)}}}else{this._warningInvalidSelectedIndex(s,T)}return this};
sap.ui.commons.TabStrip.prototype.closeTab=function(i){var t=this.getTabs()[i];if(!t||!t.getClosable()||!t.getVisible()){return}t.setProperty("visible",false,true);this.hideTab(i)};
sap.ui.commons.TabStrip.prototype.hideTab=function(I){var t=this.getTabs()[I];if(!this.getDomRef()){return}var f=this.oItemNavigation.getFocusedIndex();var v=parseInt(t.$().attr("aria-posinset"),10)-1;var F=sap.ui.getCore().getCurrentFocusedControlId();t.$().remove();if(this.iVisibleTabs==1){this.setProperty('selectedIndex',-1,true);t.$("panel").remove()}else if(I==this.getSelectedIndex()){var n=I+1;while(n<this.getTabs().length&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n++}if(n==this.getTabs().length){n=I-1;while(n>=0&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n--}}this.setProperty('selectedIndex',n,true);this.rerenderPanel(I)}else{this.toggleTabClasses(this.getSelectedIndex(),this.getSelectedIndex())}this.iVisibleTabs--;var v=0;var T=[];var s=-1;var b=false;for(var i=0;i<this.getTabs().length;i++){var t=this.getTabs()[i];if(F==t.getId()){b=true}if(t.getVisible()===false){continue}if(i==this.getSelectedIndex()){s=v}v++;t.$().attr("aria-posinset",v).attr("aria-setsize",this.iVisibleTabs);if(v==this.iVisibleTabs){t.$().addClass("sapUiTabLast")}T.push(t.getDomRef())}if(v<=f){f--}this.oItemNavigation.setItemDomRefs(T);this.oItemNavigation.setSelectedIndex(s);this.oItemNavigation.setFocusedIndex(f);if(b){this.oItemNavigation.focusItem(f)}};
sap.ui.commons.TabStrip.prototype.rerenderPanel=function(o){var n=this.getSelectedIndex();var $=this.getTabs()[o].$("panel");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderTabContents(r,this.getTabs()[n]);r.flush($[0]);r.destroy()}var N=this.getTabs()[n].getId();$.attr("id",N+"-panel").attr("aria-labelledby",N);this.getTabs()[n].onAfterRendering();this.toggleTabClasses(o,n)};
sap.ui.commons.TabStrip.prototype.toggleTabClasses=function(o,n){this.getTabs()[o].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",false);var b=o-1;while(b>=0&&!this.getTabs()[b].getVisible()){b--}if(b>=0){this.getTabs()[b].$().removeClass("sapUiTabBeforeSel")}var a=o+1;while(a<this.getTabs().length&&!this.getTabs()[a].getVisible()){a++}if(a<this.getTabs().length){this.getTabs()[a].$().removeClass("sapUiTabAfterSel")}this.getTabs()[n].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",true);b=n-1;while(b>=0&&!this.getTabs()[b].getVisible()){b--}if(b>=0){this.getTabs()[b].$().addClass("sapUiTabBeforeSel")}a=n+1;while(a<this.getTabs().length&&!this.getTabs()[a].getVisible()){a++}if(a<this.getTabs().length){this.getTabs()[a].$().addClass("sapUiTabAfterSel")}};
sap.ui.commons.TabStrip.prototype._originalInvalidate=sap.ui.commons.TabStrip.prototype.invalidate;
sap.ui.commons.TabStrip.prototype.invalidate=function(){this.invalidated=true;sap.ui.commons.TabStrip.prototype._originalInvalidate.apply(this,arguments)};
sap.ui.commons.TabStrip.prototype._warningInvalidSelectedIndex=function(s,t){var d="";if(!t){d="Tab not exists"}else if(!t.getEnabled()){d="Tab disabled"}else if(!t.getVisible()){d="Tab not visible"}jQuery.sap.log.warning("SelectedIndex "+s+" can not be set",d,"sap.ui.commons.TabStrip")};
