// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.commons.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.commons.AccordionRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Accordion
jQuery.sap.declare("sap.ui.commons.AccordionRenderer");

/**
 * @class
 * @static
 */
sap.ui.commons.AccordionRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oAccordion An object representation of the control that should be rendered
 */
sap.ui.commons.AccordionRenderer.render = function(oRenderManager, oAccordion){

	// convenience variable
	var rm = oRenderManager;


	// write the HTML into the render manager
	rm.write("<div");
	rm.writeControlData(oAccordion);

	if ( sap.ui.getCore().getConfiguration().getAccessibility()){
		rm.writeAttribute('role', 'tablist');
	}

	rm.addClass("sapUiAcd");
	rm.addStyle("width", oAccordion.getWidth());
	rm.writeClasses();
	rm.writeStyles();
	rm.write(">"); // SPAN element

	rm.write("<div id='" + oAccordion.getId()+ "-dropTarget" + "' style='width:"+ oAccordion.getWidth() +"' tabIndex='-1' class='sapUiAcd-droptarget'></div>");

	var aSections = oAccordion.getSections();
	var aDefaultSections = oAccordion.getOpenedSectionsId().split(",");

	for(var i=0;i<aSections.length;i++){

		// Open the section if the section is part of the default opened section
		if(oAccordion.bInitialRendering){

			if(jQuery.inArray(aSections[i].getId(),aDefaultSections)!= -1){
				aSections[i]._setCollapsed(false);
			}
			else{
				aSections[i]._setCollapsed(true);
			}

	   }

	   sap.ui.commons.AccordionRenderer.renderSection(rm, aSections[i]);

	}

	rm.write('<SPAN id="' + oAccordion.getId() + '-Descr" style="visibility: hidden; display: none;">');
	rm.write(oAccordion.rb.getText("ACCORDION_DSC"));
	rm.write('</SPAN>');

	rm.write("</div>");

	oAccordion.bInitialRendering = false;

};


sap.ui.commons.AccordionRenderer.renderSection = function(oRenderManager, oControl) {

	var rm = oRenderManager;
	var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();

	var heightSet = sap.ui.commons.AccordionSection._isSizeSet(oControl.getMaxHeight());
	var widthSet = sap.ui.commons.AccordionSection._isSizeSet(oControl.getParent().getWidth());

	// root element and classes
	rm.write("<div");
	rm.writeElementData(oControl);
	rm.addClass("sapUiAcdSection");

	if(oControl.getParent().isLastSection(oControl)){
		rm.addClass("sapUiAcdSectionLast");
	}

	rm.addStyle("width", oControl.getParent().getWidth());
	if (!oControl.getCollapsed()) {
		rm.addStyle("height", oControl.getMaxHeight());
	} else {
		rm.addClass("sapUiAcdSectionColl");
	}

	rm.addClass("sapUiAcdSectionArea");

	if (!heightSet) {
		rm.addClass("sapUiAcdSectionFlexHeight");
	}
	if (!oControl.getEnabled()) {
		rm.addClass("sapUiAcdSectionDis");
	}

	rm.writeClasses();
	rm.writeStyles();

	// header
	rm.write("><div class='sapUiAcdSectionHdr'");
	if (oControl.getEnabled()) {
		rm.write(" tabindex='0'");
	}
	rm.writeAttribute("id", oControl.getId() + "-hdr");
	if (accessibility) {
		rm.writeAttribute('role', 'tab');
		rm.writeAttribute("aria-labelledby", oControl.getId() + "-lbl");
		rm.writeAttribute("aria-describedby", oControl.getParent().getId() + "-Descr");
		if (oControl.getEnabled()) {
			if (oControl.getCollapsed()) {
				rm.writeAttribute("aria-expanded", "false");
			} else {
				rm.writeAttribute("aria-expanded", "true");
			}
		}
	}
	rm.write(">");

	rm.write("<div ");
	rm.writeAttribute("id", oControl.getId() + "-trgt");
	rm.write(">");

	rm.write("<span id='" + oControl.getId() + "-hdrL'>");

	if (oControl.getEnabled()){
		rm.write("<a id='" + oControl.getId() + "-minL' class='sapUiAcdSectionMinArrow' href='javascript:void(0)' title='Collapse/Expand'");
	}else{
		rm.write("<a id='" + oControl.getId() + "-minL' class='sapUiAcdSectionMinArrow sapUiAcdCursorText' href='javascript:void(0)' title='Collapse/Expand'");
	}

	rm.write(" tabindex='-1' ");

	if (accessibility) {

		rm.writeAttribute("aria-labelledby", oControl.getId() + "-lbl");

		//Is the section opened --> selected in this case
		if (oControl.getCollapsed()) {
			rm.writeAttribute("aria-selected", "false");
		} else {
			rm.writeAttribute("aria-selected", "true");
		}
		//Disabled --> Unavailable annoucement
		if (oControl.getEnabled()) {
			rm.writeAttribute("aria-disabled", "false");
			if (!!!sap.ui.Device.browser.internet_explorer) {
				rm.writeAttribute("aria-grabbed", "false");
			}
		}
		else{
			rm.writeAttribute("aria-disabled", "true");
			if (!!!sap.ui.Device.browser.internet_explorer) {
				rm.writeAttribute("aria-grabbed", "");
			}
		}

	}
	rm.write("></a>");

	// label
	rm.write("<span tabindex='-1' id='" + oControl.getId() + "-lbl' class='sapUiAcdSectionLabel'");

	if (oControl.getCollapsed()) {
		rm.writeAttribute("aria-selected", "false");
		rm.addStyle("font-weight", "normal");
		rm.writeStyles();
	} else {
		rm.writeAttribute("aria-selected", "true");
		rm.addStyle("font-weight", "bold");
		rm.writeStyles();
	}

	if (accessibility) {

		rm.writeAttribute("role", "heading");
		rm.writeAttribute("aria-labelledby", oControl.getId() + "-lbl");
		rm.writeAttribute("tabindex", "0");

		if (oControl.getEnabled()) {
			rm.writeAttribute("aria-disabled", "false");
		}
		else{
			rm.writeAttribute("aria-disabled", "true");
		}
	}

	rm.write(">");

	rm.writeEscaped(oControl.getTitle());
	rm.write("</span>");
	rm.write("</span>");

	rm.write("</div></div>");

	// everything below the header is only rendered initially if not collapsed - saves performance and Panel just re-renders later on expand
	if (!oControl.getCollapsed()) {

		// Content area
		rm.write("<div class='sapUiAcdSectionCont' tabindex='-1' id='" + oControl.getId() + "-cont'");
		if (heightSet && widthSet) {
			rm.write(" style='position:absolute;'");
		} else {
			rm.write(" style='position:relative;top:0px;'"); // for IE7, when Panel contains relatively positioned elements
		}

		if ( sap.ui.getCore().getConfiguration().getAccessibility()){
			rm.writeAttribute('role', 'tabpanel');
		}

		rm.write(">");

		// Content (child controls)
		var oControls = oControl.getContent(),
		iLength = oControls.length;
		for (var i=0;i<iLength;i++) {
			rm.renderControl(oControls[i]);
		}
		rm.write("</div>");

	}
	// End of Panel
	rm.write("</div>");
};
}; // end of sap/ui/commons/AccordionRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ApplicationHeaderRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ApplicationHeader
jQuery.sap.declare("sap.ui.commons.ApplicationHeaderRenderer");

/**
 * @class ApplicationHeader renderer.
 * @static
 */
sap.ui.commons.ApplicationHeaderRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oAppHeader an object representation of the control that should be rendered
 */
sap.ui.commons.ApplicationHeaderRenderer.render = function(oRenderManager, oAppHeader){

	if (!this.initializationDone){
		oAppHeader.initControls();
		oAppHeader.initializationDone = true;
	}

	var appHeaderId = oAppHeader.getId();

	//Write the HTML into the render manager
	oRenderManager.write("<header");
	oRenderManager.writeControlData(oAppHeader);
	oRenderManager.addClass("sapUiAppHdr");
	oRenderManager.writeClasses();
	oRenderManager.write(">");

	//Welcome and logoff areas
	oRenderManager.write("<div id=\"" + appHeaderId + "-appHeaderWelcomeLogoffAreas\" class=\"sapUiAppHdrWelcomeLogoffArea sapUiInverted-CTX\">");
	this.renderWelcomeAndLogoffAreas(oRenderManager, oAppHeader);
	oRenderManager.write("</div>"); //End welcome and logout areas

	//Logo area
	oRenderManager.write("<div id=\"" + appHeaderId + "-logoArea\" class=\"sapUiAppHdrLogo\">");
	this.renderLogoArea(oRenderManager,oAppHeader);
	oRenderManager.write("</div>");

	oRenderManager.write("</header>");

};

/**
 * Renders the HTML for the logo area (Logo src and text if any)
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oAppHeader an object representation of the control that should be rendered
 */
sap.ui.commons.ApplicationHeaderRenderer.renderLogoArea = function(oRenderManager, oAppHeader){

	//Add the logo, but first set the source to the right path
	var sSrc = oAppHeader.getLogoSrc();
	if(!sSrc){
		jQuery.sap.require("sap.ui.core.theming.Parameters");
		sSrc = sap.ui.core.theming.Parameters._getThemeImage(); // theme logo
	}
	if(!sSrc){
		sSrc = sap.ui.resource("sap.ui.commons", "themes/" + sap.ui.getCore().getConfiguration().getTheme() + "/img/applicationheader/SAPLogo.png");
	}
	
	oAppHeader.oLogo.setSrc(sSrc);
	oRenderManager.renderControl(oAppHeader.oLogo);

	//Insert the logo text if any provided by application
	if (oAppHeader.getLogoText() != ""){
		oAppHeader.oLogoText.setText(oAppHeader.getLogoText());
		oAppHeader.oLogoText.setTooltip(oAppHeader.getLogoText());
		oRenderManager.renderControl(oAppHeader.oLogoText);
	}

};

/**
 * Renders the HTML for the welcome and logoff areas
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oAppHeader an object representation of the control that should be rendered
 */
sap.ui.commons.ApplicationHeaderRenderer.renderWelcomeAndLogoffAreas = function(oRenderManager, oAppHeader){

	var appHeaderId = oAppHeader.getId();

	//Check if the Welcome text is requested
	if (oAppHeader.getDisplayWelcome()){

		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

		var padding = sap.ui.getCore().getConfiguration().getRTL() ? "padding-left" : "padding-right";

		//Add the user name if provided
		if (oAppHeader.getUserName() != ""){
			oRenderManager.write("<label class=\"sapUiLbl sapUiLblEmph\" style=\"text-align: left;\" dir=\"Inherit\" id=\"" + appHeaderId + "-welcomeLabel\">" +
								  rb.getText("APPHDR_WELCOME_USER") + ":</label>");
			oRenderManager.write("&nbsp;");
			oRenderManager.write("<label class=\"sapUiLbl\" style=\"text-align: left;", padding, ":15px;\" dir=\"Inherit\" id=\"", appHeaderId, "-userLabel\">");
			oRenderManager.writeEscaped(oAppHeader.getUserName());
			oRenderManager.write("</label>");
		}
		else{
			oRenderManager.write("<label class=\"sapUiLbl sapUiLblEmph\" style=\"text-align: left;" + padding + ":15px;\" dir=\"Inherit\" id=\"" + appHeaderId + "-welcomeLabel\">" +
								  rb.getText("APPHDR_WELCOME") + "</label>");
		}
	}

	//Logout area
	if (oAppHeader.getDisplayLogoff()){

		//Display the separator only when the welcome area is displayed as well
		if (oAppHeader.getDisplayWelcome()){
			oRenderManager.write("<span role=\"separator\" class=\"sapUiTbSeparator\"></span>");
		}
		oRenderManager.renderControl(oAppHeader.oLogoffBtn);
	}

};
}; // end of sap/ui/commons/ApplicationHeaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Button
jQuery.sap.declare("sap.ui.commons.ButtonRenderer");

/**
 * @class
 * @author SAP SE
 * @version 1.24.2
 * @static
 */
sap.ui.commons.ButtonRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oButton An object representation of the control that should be rendered.
 */
sap.ui.commons.ButtonRenderer.render = function(rm, oButton) {

	// return immediately if control is invisible
	if (!oButton.getVisible()) {
		return;
	}

	rm.addClass("sapUiBtn");

	// button is rendered as a "<button>" element
	rm.write("<button type=\"button\""); // otherwise this turns into a submit button in IE8
	rm.writeControlData(oButton);
	if(oButton.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oButton.getTooltip_AsString());
	}

	//styling
	if (oButton.getStyled()) {
		rm.addClass("sapUiBtnS");
	}

	if (oButton.getLite()) {
		rm.addClass("sapUiBtnLite");
	}else{
		rm.addClass("sapUiBtnNorm");
	}

	var sStyle = oButton.getStyle();

	if (sStyle != "" && sStyle != sap.ui.commons.ButtonStyle.Default) {
		rm.addClass("sapUiBtn"+jQuery.sap.escapeHTML(sStyle));
	}

	//ARIA
	rm.writeAccessibilityState(oButton, {
		role: 'button',
		disabled: !oButton.getEnabled()
	});

	if (!oButton.getEnabled()) {
		rm.write(" tabIndex=\"-1\"");
		rm.addClass("sapUiBtnDsbl");
	} else {
		rm.write(" tabIndex=\"0\"");
		rm.addClass("sapUiBtnStd");
	}

	var bImageOnly = false;
	if (!oButton.getText() && oButton.getIcon()) { // icon, but no text => reduce padding
		rm.addClass("sapUiBtnIconOnly");
		bImageOnly = true; // only the image is there, so it must have some meaning
	}

	if (oButton.getWidth() && oButton.getWidth() != '') {
		rm.addStyle("width", oButton.getWidth());
		rm.addClass("sapUiBtnFixedWidth");
	}
	if (oButton.getHeight() && oButton.getHeight() != '') {
		rm.addStyle("height", oButton.getHeight());
	}
	rm.writeStyles();

	if(this.renderButtonAttributes){
		this.renderButtonAttributes(rm, oButton);
	}

	// feature-dependent CSS class, written for browsers not understanding CSS gradients (=IE8, IE9)
	// required to avoid a large number of browser selectors which is needed to NOT serve filter:... to IE10
	if (!!sap.ui.Device.browser.internet_explorer && (!document.documentMode || document.documentMode < 10)) {
		rm.addClass("sapUiBtnNoGradient");
	}

	rm.writeClasses();

	rm.write(">");

	if(this.renderButtonContentBefore){
		this.renderButtonContentBefore(rm, oButton);
	}

	var bUseIconFont = false;
	if (sap.ui.core.IconPool.isIconURI(oButton.getIcon())) {
		bUseIconFont = true;
	}

	if (oButton.getIconFirst()) {
		if (bUseIconFont) {
			this.writeIconHtml(rm, oButton, bImageOnly);
		} else if(this._getIconForState(oButton, "base")) {
			this.writeImgHtml(rm, oButton, bImageOnly);
		}
	}

	// write the button label
	if (oButton.getText()) {
		if (!oButton.getIcon() && !this.renderButtonContentBefore && !this.renderButtonContentAfter) {
			rm.writeEscaped(oButton.getText());
		} else { // if there is an icon, an additional span is required
			rm.write("<span class=\"sapUiBtnTxt\">");
			rm.writeEscaped(oButton.getText());
			rm.write("</span>");
		}
	}

	if (!oButton.getIconFirst()) {
		if (bUseIconFont) {
			this.writeIconHtml(rm, oButton, bImageOnly);
		} else if(this._getIconForState(oButton, "base")) {
			this.writeImgHtml(rm, oButton, bImageOnly);
		}
	}

	if(this.renderButtonContentAfter){
		this.renderButtonContentAfter(rm, oButton);
	}

	// close button
	rm.write("</button>");
};

/**
 * Function called by button control on mouse down event.
 */
sap.ui.commons.ButtonRenderer.onactive = function(oButton) {
	oButton.$().addClass("sapUiBtnAct").removeClass("sapUiBtnStd");
	oButton.$("img").attr("src", this._getIconForState(oButton, "active"));
};

/**
 * Function called by button control on mouse up event.
 */
sap.ui.commons.ButtonRenderer.ondeactive = function(oButton) {
	oButton.$().addClass("sapUiBtnStd").removeClass("sapUiBtnAct");
	oButton.$("img").attr("src", this._getIconForState(oButton, "deactive"));
};

/**
 * Function called by button control on blur.
 */
sap.ui.commons.ButtonRenderer.onblur = function(oButton) {
	oButton.$().removeClass("sapUiBtnFoc");
	oButton.$("img").attr("src", this._getIconForState(oButton, "blur"));
	if (!!sap.ui.Device.browser.internet_explorer) {
		sap.ui.commons.ButtonRenderer.onmouseout(oButton);
	}
};

/**
 * Function called by button control on focus.
 */
sap.ui.commons.ButtonRenderer.onfocus = function(oButton) {
	oButton.$().addClass("sapUiBtnFoc");
	oButton.$("img").attr("src", this._getIconForState(oButton, "focus"));
};

/**
 * Function called when mouse leaves button
 */
sap.ui.commons.ButtonRenderer.onmouseout = function(oButton) {
	oButton.$().removeClass("sapUiBtnAct");
	oButton.$().addClass("sapUiBtnStd");
	oButton.$("img").attr("src", this._getIconForState(oButton, "mouseout"));
};

/**
 * Function called when mouse enters button
 * @private
 */
sap.ui.commons.ButtonRenderer.onmouseover = function(oButton) {
	oButton.$("img").attr("src", this._getIconForState(oButton, "mouseover"));
};

/**
 * Returns the icon URI for the given button state
 * @private
 */
sap.ui.commons.ButtonRenderer._getIconForState = function(oButton, sState) {
	if (!oButton.getEnabled()){
		sState = "disabled";
	}
	switch(sState){
		case "focus":
		case "blur":
		case "base":
			if(oButton.$().hasClass("sapUiBtnAct")){
				var sIcon = oButton.getIconSelected() || oButton.getIconHovered();
				return sIcon ? sIcon : oButton.getIcon();
			}else if(oButton.$().hasClass("sapUiBtnFoc")){
				return oButton.getIconHovered() || oButton.getIcon();
			}
			return oButton.getIcon();
		case "mouseout":
			if(oButton.$().hasClass("sapUiBtnFoc")){
				return oButton.getIconHovered() || oButton.getIcon();
			}
			return oButton.getIcon();
		case "active":
			var sIcon = oButton.getIconSelected() || oButton.getIconHovered();
			return sIcon ? sIcon : oButton.getIcon();
		case "mouseover":
		case "deactive":
			var sIcon = oButton.getIconHovered();
			return sIcon ? sIcon : oButton.getIcon();
	}
	return oButton.getIcon();
};

/**
 * HTML for icon as image
 */
sap.ui.commons.ButtonRenderer.writeImgHtml = function(oRenderManager, oButton, bImageOnly) {
	var rm = oRenderManager,
		iconUrl = this._getIconForState(oButton, "base");

	rm.write("<img");
	rm.writeAttribute("id", oButton.getId() + "-img");
	rm.writeAttributeEscaped("src", iconUrl);
	if(oButton.getTooltip_AsString() && !oButton.getText()) {
		rm.writeAttributeEscaped("alt", oButton.getTooltip_AsString());
	} else {
		rm.writeAttribute("alt", ""); // there must be an ALT attribute
	}

	if (!bImageOnly) {
		rm.writeAttribute("role", "presentation");
	}

	rm.addClass("sapUiBtnIco");
	if (oButton.getText()) { // only add a distance to the text if there is text
		if (oButton.getIconFirst()) {
			rm.addClass("sapUiBtnIcoL");
		} else {
			rm.addClass("sapUiBtnIcoR");
		}
	}
	rm.writeClasses();

	rm.write("/>");
};

/**
 * HTML for icon as icon font
 */
sap.ui.commons.ButtonRenderer.writeIconHtml = function(oRenderManager, oButton, bImageOnly) {

	var rm = oRenderManager;
	var oIconInfo = sap.ui.core.IconPool.getIconInfo(oButton.getIcon());
	var aClasses = [];
	var mAttributes = {};

	mAttributes["id"] = oButton.getId() + "-icon";

	aClasses.push("sapUiBtnIco");
	if (oButton.getText()) { // only add a distance to the text if there is text
		var bRTL = rm.getConfiguration().getRTL();
		if ((oButton.getIconFirst() && (!bRTL || oIconInfo.skipMirroring)) || (!oButton.getIconFirst() && !oIconInfo.skipMirroring && bRTL)) {
			aClasses.push("sapUiBtnIcoL");
		} else {
			aClasses.push("sapUiBtnIcoR");
		}
	}

	rm.writeIcon(oButton.getIcon(), aClasses, mAttributes);

};

sap.ui.commons.ButtonRenderer.changeIcon = function(oButton) {

	if (sap.ui.core.IconPool.isIconURI(oButton.getIcon())) {
		var oIconInfo = sap.ui.core.IconPool.getIconInfo(oButton.getIcon());
		var oIcon = oButton.$("icon");
		if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 9) {
			oIcon.text(oIconInfo.content);
		} else {
			oIcon.attr("data-sap-ui-icon-content", oIconInfo.content);
		}
		if(!oIconInfo.skipMirroring) {
			oIcon.addClass("sapUiIconMirrorInRTL");
		} else {
			oIcon.removeClass("sapUiIconMirrorInRTL");
		}
	} else if (oButton.$().hasClass("sapUiBtnAct")) {
		oButton.$("img").attr("src", this._getIconForState(oButton, "active"));
	} else if (oButton.$().hasClass("sapUiBtnFoc")) {
		oButton.$("img").attr("src", this._getIconForState(oButton, "focus"));
	} else if (oButton.$().hasClass("sapUiBtnStd")) {
		oButton.$("img").attr("src", this._getIconForState(oButton, "base"));
	}

};

}; // end of sap/ui/commons/ButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CalloutBaseRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.CalloutBaseRenderer");

/**
 * @class CalloutBase renderer.
 * @static
 */
sap.ui.commons.CalloutBaseRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the Callout that should be rendered
 */
sap.ui.commons.CalloutBaseRenderer.render = function(oRenderManager, oControl){

	var rm = oRenderManager;
	var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
	var sId = oControl.getId();

	//container
	rm.write("<div");
	rm.writeControlData(oControl);

	rm.addClass("sapUiCltBase");
	if (this.addRootClasses) {
		this.addRootClasses(rm, oControl);
	}
	rm.writeClasses();

	if (accessibility) {
		rm.writeAttribute("role", "dialog");
		//ARIA label
		var sAriaLabel = oControl.oRb.getText('CALLOUT_ARIA_NAME');
		if(sAriaLabel){
			rm.writeAttributeEscaped("aria-label", sAriaLabel);
		}
	}
	if (oControl.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
	}
	
	rm.addStyle("display", "none");
	rm.writeStyles();
	
	rm.write(">");

	//first focusable control to provide tab loop
	rm.write("<span id=\"" + sId + "-fhfe\" tabIndex=\"0\"></span>");

	// content container
	rm.write("<div");
	rm.writeAttribute("id",sId + "-cont");

	rm.addClass("sapUiCltBaseCont");
	if (this.addContentClasses) {
		this.addContentClasses(rm, oControl);
	}
	rm.writeClasses();

	rm.writeAttribute("tabindex","-1");
	rm.write(">");

	// successor controls provide content here in their specific renderContent methods
	if (this.renderContent) {
		this.renderContent(rm, oControl);
	}
	rm.write("</div>");

	// arrow tip
	rm.write("<div");
	rm.writeAttribute("id", sId+"-arrow");
	if (accessibility) {
		rm.writeAttribute("role", "presentation");
	}
	// specific arrow placement is specified in behavior by setting additional CSS classes
	rm.addClass("sapUiCltBaseArr");
	if (this.addArrowClasses) {
		this.addArrowClasses(rm, oControl);
	}
	rm.writeClasses();
	rm.write("></div>");

	//last focusable control to provide tab loop
	rm.write("<span id=\"" + sId + "-fhee\" tabIndex=\"0\"></span>");

	rm.write("</div>");// container

};

}; // end of sap/ui/commons/CalloutBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CalloutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.CalloutRenderer");

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class Callout renderer.
 * @static
 */
sap.ui.commons.CalloutRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.CalloutBaseRenderer);

/**
 * Renders the HTML for content.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oCallout an object representation of the Callout that should be rendered
 */
sap.ui.commons.CalloutRenderer.renderContent = function(oRenderManager, oCallout){

	var rm = oRenderManager;
	var content = oCallout.getContent();

	// content
	for (var i = 0; i < content.length; i++) {
		rm.renderControl(content[i]);
	}
};

/**
 * Add the root CSS class to the Callout to redefine/extend CalloutBase
 *
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager the RenderManager that can be used for writing to
 *            the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
sap.ui.commons.CalloutRenderer.addRootClasses = function(oRenderManager, oControl) {
	oRenderManager.addClass("sapUiClt");
};

/**
 * Add the content CSS class to the Callout to redefine/extend CalloutBase
 *
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager the RenderManager that can be used for writing to
 *            the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
sap.ui.commons.CalloutRenderer.addContentClasses = function(oRenderManager, oControl) {
	oRenderManager.addClass("sapUiCltCont");
};

/**
 * Add the arrow/tip CSS class to the Callout to redefine/extend CalloutBase
 *
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager the RenderManager that can be used for writing to
 *            the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
sap.ui.commons.CalloutRenderer.addArrowClasses = function(oRenderManager, oControl) {
	oRenderManager.addClass("sapUiCltArr");
};

}; // end of sap/ui/commons/CalloutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CarouselRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Carousel
jQuery.sap.declare("sap.ui.commons.CarouselRenderer");

/**
 * @class carousel renderer.
 * @static
 */
sap.ui.commons.CarouselRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.CarouselRenderer.render = function(oRenderManager, oControl) {

	var rm = oRenderManager;
	var bRTL = sap.ui.getCore().getConfiguration().getRTL();

	rm.write("<div");
	rm.addClass("sapUiCrsl");
	if (oControl.getWidth() != "") {
		rm.addStyle("width", oControl.getWidth());
	}
	if (oControl.getHeight() != "") {
		rm.addStyle("height", oControl.getHeight());
	}
	rm.writeStyles();
	rm.writeClasses();
	rm.writeControlData(oControl);
	rm.write(">");

	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	// Start Prev button
	rm.write("<div");
	rm.writeAttribute("id", oControl.getId() + "-prevbutton");
	rm.writeAttribute("title", rb.getText("CAROUSEL_SHOW_PREV"));
	rm.addClass("sapUiCrslPrevBtn");
	rm.writeClasses();
	if (oControl.getHandleSize() != 22) {
		if (oControl.getOrientation() == "vertical") {
			rm.addStyle("height",oControl.getHandleSize() + "px");
		} else {
			rm.addStyle("width",oControl.getHandleSize() + "px");
		}
		rm.writeStyles();
	}
	rm.write(">");
	if (oControl.getOrientation() == "vertical") {
		rm.write("&#9650");//Symbol for Base and HCB Theme (Must be hidden in other themes)
	} else {
		if (bRTL) {
			rm.write("&#9658");//Symbol for Base and HCB Theme (Must be hidden in other themes)
		}
		else{
			rm.write("&#9668");//Symbol for Base and HCB Theme (Must be hidden in other themes)
		}
	}
	rm.write("</div>");
	// End Prev button

	// Start Next button
	rm.write("<div");
	rm.writeAttribute("id", oControl.getId() + "-nextbutton");
	rm.writeAttribute("title", rb.getText("CAROUSEL_SHOW_NEXT"));
	rm.addClass("sapUiCrslNextBtn");
	rm.writeClasses();
	if (oControl.getHandleSize() != 22) {
		if (oControl.getOrientation() == "vertical") {
			rm.addStyle("height",oControl.getHandleSize() + "px");
		} else {
			rm.addStyle("width",oControl.getHandleSize() + "px");
		}
		rm.writeStyles();
	}
	rm.write(">");
	if (oControl.getOrientation() == "vertical") {
		rm.write("&#9660");//Symbol for Base and HCB Theme (Must be hidden in other themes)
	} else {
		if (bRTL) {
			rm.write("&#9668");//Symbol for Base and HCB Theme (Must be hidden in other themes)
		}
		else{
			rm.write("&#9658");//Symbol for Base and HCB Theme (Must be hidden in other themes)
		}
	}
	rm.write("</div>");
	// End Next button


	rm.write("<div");
	rm.writeAttribute("tabindex", "0");
	rm.addClass("sapUiCrslBefore");
	rm.writeClasses();
	rm.write("></div>");

	// Start content area
	rm.write("<div");
	rm.writeAttribute("id", oControl.getId() + "-contentarea");
	rm.addClass("sapUiCrslCnt");
	rm.writeClasses();
	rm.write(">");

	var aContent = oControl.getContent();

	rm.write("<ul");
	rm.writeAttribute("id", oControl.getId() + "-scrolllist");
	rm.writeAttribute("role", "listbox");
	rm.writeAttribute("aria-describedby", oControl.getId() + "-navigate");
	rm.addClass("sapUiCrslScl");
	rm.writeClasses();
	rm.write(">");

	for ( var i = 0; i < aContent.length; i++) {
		var oChild = aContent[i];
		rm.write("<li");
		rm.writeAttribute("id",oControl.getId() + "-item-" + oChild.getId());
		rm.writeAttribute("role", "option");
		rm.writeAttribute("tabindex", "-1");
		rm.writeAttribute("aria-describedby", oControl.getId() + "-toggleaction");
		rm.addClass("sapUiCrslItm");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oChild);
		rm.write("</li>");
	}

	rm.write("</ul>");

	rm.write("</div>");
	// End content area

	rm.write("<div");
	rm.writeAttribute("tabindex", "0");
	rm.addClass("sapUiCrslAfter");
	rm.writeClasses();
	rm.write("></div>");

	// aria description for toggling the action mode
	rm.write("<span");
	rm.writeAttribute("id", oControl.getId() + "-toggleaction");
	rm.addStyle("position", "absolute");
	rm.addStyle("top", "-20000px");
	rm.writeStyles();
	rm.write(">");
	rm.write(rb.getText("CAROUSEL_ACTION_MODE"));
	rm.write("</span>");

	// aria description for navigation
	rm.write("<span");
	rm.writeAttribute("id", oControl.getId() + "-navigate");
	rm.addStyle("position", "absolute");
	rm.addStyle("top", "-20000px");
	rm.writeStyles();
	rm.write(">");
	rm.write(rb.getText("CAROUSEL_NAV"));
	rm.write("</span>");

	rm.write("</div>");
};
}; // end of sap/ui/commons/CarouselRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CheckBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.CheckBox
jQuery.sap.declare("sap.ui.commons.CheckBoxRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class
 * @author SAP SE
 * @version 0.1
 * @static
 */
sap.ui.commons.CheckBoxRenderer = {
};

/**
 * Renders the HTML for the CheckBox, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that is used for writing to the render output buffer.
 * @param {sap.ui.commons.CheckBox} oCheckBox The CheckBox control that should be rendered.
 */
sap.ui.commons.CheckBoxRenderer.render = function(rm, oCheckBox) {

	// Return immediately if control is invisible
	if (!oCheckBox.getVisible()) {
		return;
	}

	rm.addClass("sapUiCb");

	// Open the containing <span> tag
	rm.write("<span");
	rm.writeControlData(oCheckBox);

	// ARIA
	rm.writeAccessibilityState(oCheckBox, {"role" : sap.ui.core.AccessibleRole.Checkbox.toLowerCase()});

	// Collect state information
	var enabled = oCheckBox.getEnabled() != null && oCheckBox.getEnabled();
	var editable = oCheckBox.getEditable() != null && oCheckBox.getEditable();
	var inErrorState = false;
	var inWarningState = false;
	if (oCheckBox.getValueState() != null) {
		inErrorState = sap.ui.core.ValueState.Error == oCheckBox.getValueState();
		inWarningState = sap.ui.core.ValueState.Warning == oCheckBox.getValueState();
	}


	// Add classes and properties depending on the state
	if (oCheckBox.getChecked()) {
		rm.addClass("sapUiCbChk");
	}

	var myTabIndex = 0;
	var bReadOnly = false;

	if (!editable) {
		bReadOnly = true;
		rm.addClass("sapUiCbRo");
		// According to CSN 2581852 2012 a readonly CB should be in the tabchain
		// This changed in 2013 back to not in the tabchain: see CSN 0002937527 2013
		// Let's see how often this will be changed back and forth in the future... Accessibility fun! :-D
		// End of 2013 is have to be again in the tabchain.
		// But not in the Form. But this is handled in the FormLayout control
		// Let's see what happens 2014... ;-)
		myTabIndex = 0;
	}
	if (!enabled) {
		bReadOnly = true;
		rm.addClass("sapUiCbDis");
		myTabIndex = -1;
	}
	if (inErrorState) {
		rm.addClass("sapUiCbErr");
		rm.writeAttribute("aria-invalid", "true");
	} else if (inWarningState) {
		rm.addClass("sapUiCbWarn");
	}
	if (enabled && editable && !inErrorState && !inWarningState) {
		rm.addClass("sapUiCbStd");
	}
	if (enabled && editable) {
		rm.addClass("sapUiCbInteractive");
	}
	rm.writeClasses();

	if (oCheckBox.getWidth() && oCheckBox.getWidth() != '') {
		rm.writeAttribute("style", "width:" + oCheckBox.getWidth() + ";");
	}

	rm.writeAttribute("tabIndex", myTabIndex);

	rm.write(">"); // close the containing <span> tag


	// Write the (potentially hidden) HTML checkbox element
	rm.write("<input type='CheckBox' tabindex='-1' id='");
	rm.write(oCheckBox.getId());
	rm.write("-CB'");

	if (oCheckBox.getName()) {
		rm.writeAttributeEscaped('name', oCheckBox.getName());
	}

	if (oCheckBox.getChecked()) {
		rm.write(" checked='checked'");
	}
	if (!enabled) {
		rm.write(" disabled='disabled'");
	}
	var tooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oCheckBox, oCheckBox.getTooltip_AsString());
	if (tooltip) {
		rm.writeAttributeEscaped("title", tooltip);
	}
	if(bReadOnly) {
		//'readonly' property is not supported by input type=checkbox
		//In order to make readonly checkbox unresponsive, we need to apply 'disabled' property - only affects HCB theme
		rm.write(" disabled='disabled'");
	}
	rm.write(" />"); // close checkbox-input-element


	// Write the checkbox label which also holds the background image
	rm.write("<label");
	if (tooltip) {
		rm.writeAttributeEscaped("title", tooltip);
	}
	rm.writeAttribute("for", oCheckBox.getId() + "-CB"); // label for checkbox, so clicks toggle the state
	if (!oCheckBox.getText()) {
		rm.write(" class='sapUiCbNoText'");
	}
	rm.write(">");
	if (oCheckBox.getText()) {
		this.renderText(rm, oCheckBox.getText(), oCheckBox.getTextDirection());
	}
	rm.write("</label>");

	// close the surrounding <span> element
	rm.write("</span>");
};



/**
 * Write the CheckBox label either flat or - in case the text direction is different from the environment - within a span tag with an explicit "dir".
 */
sap.ui.commons.CheckBoxRenderer.renderText = function(oRenderManager, sText, eTextDirection) {
	var rm = oRenderManager;
	if (!eTextDirection || eTextDirection == sap.ui.core.TextDirection.Inherit) {
		rm.writeEscaped(sText);
	} else {
		rm.write("<span style=\"direction:" + eTextDirection.toLowerCase() + ";\">");
		rm.writeEscaped(sText);
		rm.write("</span>");
	}
};

}; // end of sap/ui/commons/CheckBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ColorPickerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ColorPicker
jQuery.sap.declare("sap.ui.commons.ColorPickerRenderer");

/**
 * @class ColorPicker renderer.
 * @static
 */
sap.ui.commons.ColorPickerRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.ColorPickerRenderer.render = function(oRm, oControl){

	// write the HTML into the render manager
	oRm.write("<div");   // Outer DIV
	oRm.writeControlData(oControl);
	oRm.writeClasses();
	oRm.write(">"); // <DIV> element
	oRm.renderControl(oControl.oMatrix);
	oRm.write("</div>");  // outer DIV

};


}; // end of sap/ui/commons/ColorPickerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.DialogRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Dialog
jQuery.sap.declare("sap.ui.commons.DialogRenderer");

/**
 * @class  sap.ui.commons.DialogRenderer
 * @static
 */
sap.ui.commons.DialogRenderer = {};


/**
 * Renders the HTML for the Dialog, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
 */
sap.ui.commons.DialogRenderer.render = function(rm, oControl) {
	var heightSet = sap.ui.commons.Dialog._isSizeSet(oControl.getHeight());
	var widthSet = sap.ui.commons.Dialog._isSizeSet(oControl.getWidth());

	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	oControl.getScrollTop();  // Update the scroll position properties
	oControl.getScrollLeft();

	var aButtons = oControl.getButtons();
	var iButtonCount = aButtons.length;


	// Root element and classes/styles
	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapUiDlg");
	if (oControl.getModal()) {
		rm.addClass("sapUiDlgModal");
	}
	rm.addClass("sapUiDlgContentBorderDesign" + oControl.getContentBorderDesign());

	rm.addStyle("width", oControl.getWidth());
	rm.addStyle("height", oControl.getHeight());
	rm.addStyle("min-width", oControl.getMinWidth());
	rm.addStyle("min-height", oControl.getMinHeight());
	rm.addStyle("max-width", oControl.getMaxWidth());
	rm.addStyle("max-height", oControl.getMaxHeight());

	if (!heightSet) {
		rm.addClass("sapUiDlgFlexHeight");
	}
	if (!widthSet) {
		rm.addClass("sapUiDlgFlexWidth");
	}
	if (iButtonCount == 0) {
		rm.addClass("sapUiDlgNoButtons");
	}
	if (!oControl.getApplyContentPadding()) {
		rm.addClass("sapUiDlgNoPad");
	}
	rm.writeClasses();
	rm.writeStyles();

	rm.writeAttribute("aria-labelledby", oControl.getId() + "-lbl " + oControl.getId() + "-acc");
	rm.writeAttribute("role", oControl.getAccessibleRole().toLowerCase());
	rm.writeAttribute("tabindex", "-1");
	rm.write("><span style='display:none;' id='", oControl.getId(), "-acc'>", rb.getText("DIALOG_CLOSE_HELP"), "</span>");

	// Header
	rm.write("<span id='" + oControl.getId() + "-fhfe' tabIndex='0'></span><div id='" + oControl.getId() + "-hdr' class='sapUiDlgHdr'>");
	rm.write("<span class='sapUiDlgHdrLeft' id='" + oControl.getId() + "-hdrL'>");

	// Header label
	var title = oControl.getTitle();
	rm.write("<span id='" + oControl.getId() + "-lbl' class='sapUiDlgLabel'");

	rm.writeAttribute("role", "heading");
	rm.writeAttribute("aria-level", "1");
	if (title) {
		rm.writeAttributeEscaped("title", title);
	}
	rm.write(">");

	if (!title) {
		rm.write("&nbsp;");
	} else {
		rm.writeEscaped(title); 
	}
	rm.write("</span></span>");
	rm.write("<span id='", oControl.getId(), "-hdrR' class='sapUiDlgHdrBtns'>");
	// Example for an additional button:   rm.write("<a class='sapUiDlgOptBtn'></a>");

	if (oControl.getShowCloseButton()) {
		rm.write("<a id='", oControl.getId(), "-close' class='sapUiDlgCloseBtn' href='javascript:void(0)'");
		rm.write(" tabIndex='-1'"); // according to accessibility experts (O.K. and M.J.), the 'x' should not be tab-able
		rm.writeAttribute("role","button");
		rm.writeAttributeEscaped("aria-label", rb.getText("DIALOG_CLOSE_HELP"));
		rm.writeAttributeEscaped("title", rb.getText("DIALOG_CLOSE_TEXT"));
		rm.write(">X</a>");
	}
	rm.write("</span></div>");

	// 	Header separator
	rm.write('<div class="sapUiDlgHdrSep"></div>');

	// Content area
	rm.write("<div class='sapUiDlgCont' id='", oControl.getId(), "-cont' tabindex=\"-1\">");

	// Content
	var aChildren = oControl.getContent();
	for(var i = 0; i < aChildren.length; i++) {
		rm.renderControl(aChildren[i]);
	}
	rm.write("</div>");

	// Footer separator
	if (iButtonCount > 0) {
		rm.write('<div class="sapUiDlgFooterSep"></div>');
	}

	// Footer
	rm.write("<div id='");
	rm.write(oControl.getId());
	rm.write("-footer' class='sapUiDlgFooter'>");

	// Wave and Buttons
	rm.write("<div class='sapUiDlgBtns'>");
	for (var i = 0; i < iButtonCount; i++) {
		rm.renderControl(aButtons[i]);
	}
	rm.write("</div><div class='sapUiDlgWave'></div></div>");

	// Grip
	if (oControl.getResizable()) {
		rm.write("<span id='");
		rm.write(oControl.getId());
		rm.write("-grip' class='sapUiDlgGrip'>&#916;</span>");
	}

	// End of Dialog
	rm.write("<span id='" + oControl.getId() + "-fhee' tabIndex='0'></span></div>");

};

}; // end of sap/ui/commons/DialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FileUploaderRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.FileUploader
jQuery.sap.declare("sap.ui.commons.FileUploaderRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.unified.FileUploaderRenderer'); // unlisted dependency retained


sap.ui.commons.FileUploaderRenderer = sap.ui.core.Renderer.extend(sap.ui.unified.FileUploaderRenderer);
}; // end of sap/ui/commons/FileUploaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FormattedTextViewRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.FormattedTextViewRenderer");

/**
 * @class FormattedTextView renderer.
 * @static
 */
sap.ui.commons.FormattedTextViewRenderer = {};

/*
 * Renders the HTML for the FormattedTextView, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for
 * writing to the render output buffer @param {sap.ui.core.Control} oControl an
 * object representation of the control that should be rendered
 */
sap.ui.commons.FormattedTextViewRenderer.render = function(oRm, oControl) {
	if (!oControl.getVisible()) {
		return;
	}

	// pattern for placeholders:
	var rPlaceHolderPattern = /<embed\s+data-index="([0-9]+)"\s*\/?>/gim;
	var sHtml = oControl.getHtmlText();

	// clone, will be modified below
	var aInnerControls = oControl.getControls().slice();

	var iToBeRendered = aInnerControls.length;
	var lastIndex = 0;
	var aMatch = [];

	// write the HTML into the render manager
	oRm.write("<span");
	oRm.writeControlData(oControl);
	oRm.addClass("sapUiFTV");
	oRm.writeClasses();

	// render Tooltip
	if (oControl.getTooltip_AsString()) {
		oRm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
	}
	oRm.write(">"); // span element

	// check for placeholders in htmlText property
	while (aMatch = rPlaceHolderPattern.exec(sHtml)) {
		// write any static HTML between previous and current placeholder (if
		// any)
		oRm.write(sHtml.slice(lastIndex, aMatch.index));
		// replace placeholder with control in aggregation
		if (this._renderReplacement(oRm, aMatch[1], aInnerControls)) {
			iToBeRendered--;
		} else {
			jQuery.sap.log.warning("Could not find matching control to placeholder #" + aMatch[1]);
		}
		lastIndex = rPlaceHolderPattern.lastIndex;
	}
	// render the remainder of the HTML
	oRm.write(sHtml.slice(lastIndex, sHtml.length));

	if (iToBeRendered > 0) {
		jQuery.sap.log.warning('There are leftover controls in the aggregation that have not been used in the formatted text', oControl);
	}

	oRm.write("</span>");

};

/* Private method for placeholder replacement */
sap.ui.commons.FormattedTextViewRenderer._renderReplacement = function(rm, controlsIndex, aControls) {
	if (aControls[controlsIndex]) {
		rm.renderControl(aControls[controlsIndex]);
		// UI5 controls must not be rendered twice!
		aControls[controlsIndex] = null;
		return true;
	} else
		return false;
};
}; // end of sap/ui/commons/FormattedTextViewRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.HorizontalDividerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.HorizontalDivider
jQuery.sap.declare("sap.ui.commons.HorizontalDividerRenderer");

/**
 * @class HorizontalDivider renderer.
 * @static
 */
sap.ui.commons.HorizontalDividerRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered
 */
sap.ui.commons.HorizontalDividerRenderer.render = function(oRenderManager, oControl){
	var rm = oRenderManager;

	// return immediately if control is invisible
	if(!oControl.getVisible()){
		return;
	}

	rm.write("<hr");
	rm.writeControlData(oControl);
	rm.writeAttribute("role", "separator"); //ARIA
	if(oControl.getWidth()) {
		rm.writeAttribute("style", "width:"+oControl.getWidth()+";");
	}
	rm.addClass("sapUiCommonsHoriDiv");
	rm.addClass(oControl.getType() == "Page" ? "sapUiCommonsHoriDivTypePage" : "sapUiCommonsHoriDivTypeArea");
	switch(oControl.getHeight()){
		case "Ruleheight":
			rm.addClass("sapUiCommonsHoriDivHeightR");
			break;
		case "Small":
			rm.addClass("sapUiCommonsHoriDivHeightS");
			break;
		case "Large":
			rm.addClass("sapUiCommonsHoriDivHeightL");
			break;
		default:
			rm.addClass("sapUiCommonsHoriDivHeightM");
	}
	rm.writeClasses();
	rm.write("/>");
};

}; // end of sap/ui/commons/HorizontalDividerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ImageMapRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.ImageMapRenderer");

/**
 * @class ImageMap renderer.
 * @static
 */
sap.ui.commons.ImageMapRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.ImageMapRenderer.render = function(oImageRenderManager, oImageMap){
    // convenience variable
	var rm = oImageRenderManager;
	var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	rm.write('<SPAN id="' + oImageMap.getId() + '-Descr" style="visibility: hidden; display: none;">');
	rm.writeEscaped(rb.getText("IMAGEMAP_DSC"));
	rm.write('</SPAN>');

	rm.write("<map tabindex='-1'");
	rm.writeControlData(oImageMap);

	// Render name attribute
	rm.writeAttributeEscaped("name",  oImageMap.getName());

	if (oImageMap.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oImageMap.getTooltip_AsString());
	}

	rm.write(">");
	var aAreas = oImageMap.getAreas();
		for (var index = 0, length = aAreas.length; index < length; index++) {
			rm.write("<area ");

			rm.writeElementData(aAreas[index]);

			if (accessibility) {
				rm.writeAttribute("aria-describedby", oImageMap.getId() + "-Descr");
			}

			// Get the Attributes of the area
			var sShape = aAreas[index].getShape();
			var sCoords = aAreas[index].getCoords();
			var sHref = aAreas[index].getHref();
			var sAlt = aAreas[index].getAlt();
			var sTitle = aAreas[index].getTooltip_AsString();

			// Render Shape Attribute. It can an be only rect, circle, poly and default
			if ( (sShape === "rect") || (sShape === "circle") || (sShape === "poly")){
				rm.writeAttribute("shape", sShape);
			} else {
				rm.writeAttribute("shape", "default");
			}

			// Render Coordinates. To do: check syntax of the input array of the coordinates
			if (sCoords) {
				rm.writeAttributeEscaped("coords", sCoords);
			}

			// Render href
			if (sHref) {
				rm.writeAttributeEscaped("href", sHref);
			}

			// Render text on ALT
			if (sAlt) {
				rm.writeAttributeEscaped("alt", sAlt);
			}

			// Tooltip
			if (sTitle) {
				rm.writeAttributeEscaped("title", sTitle);
			}



			rm.writeAttribute("tabIndex", 0);
			rm.write(">");
		} // end of for

	rm.write("</map>");

};

}; // end of sap/ui/commons/ImageMapRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ImageRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Image
jQuery.sap.declare("sap.ui.commons.ImageRenderer");

/**
 * @class
 *
 * @author d046011
 * @version 0.1
 * @static
 */
sap.ui.commons.ImageRenderer = {
};

/**
 * Renders the HTML for the Image, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.commons.Image} oImage The control that should be rendered.
 */
sap.ui.commons.ImageRenderer.render = function(oRenderManager, oImage) {
	var rm = oRenderManager;

	// Return immediately if control is invisible
	if (!oImage.getVisible()) {
		return;
	}

	// Open the <img> tag
	rm.write("<img");
	rm.writeControlData(oImage);

	// Set the 1x1.gif when empty source is set. This is to prevent the broken image placeholder and unnecessary 
	// requests to the root url in older browsers (as the 1x1.gif is only loaded once and then cached).
	// Hiding the image won't help as hidden images are still loaded.
	// The HTML5 spec requires empty source tags to be ignored. Anyway, some modern browsers still show border around
	// empty images.
	rm.writeAttributeEscaped("src", oImage.getSrc() || sap.ui.resource('sap.ui.commons', 'img/1x1.gif'));

	rm.addClass("sapUiImg");
	if (oImage.hasListeners("press")) {
		rm.addClass("sapUiImgWithHandler");
	}
	if (!oImage.getSrc()) {
		rm.addClass("sapUiImgNoSource");	
	}
	rm.writeClasses();

	var tooltip = oImage.getTooltip_AsString();
	if (tooltip) {
		rm.writeAttributeEscaped("title", tooltip);
	}

	var sUseMap = oImage.getUseMap();
	if (sUseMap) {
		if (!(jQuery.sap.startsWith(sUseMap, "#"))) {
			sUseMap = "#" + sUseMap;
		}
		rm.writeAttributeEscaped("useMap", sUseMap);
	}

	// determine tab index and write alt attribute - both depending on "decorative" state (which is overridden by the "useMap" property
	var myTabIndex = 0;
	if ((oImage.getDecorative() && (!sUseMap))) {
		myTabIndex = -1;
		rm.writeAttribute("role", "presentation");
		rm.write(" alt=''"); // accessibility requirement: write always empty alt attribute for decorative images
	} else {
		if (oImage.getAlt()) {
			rm.writeAttributeEscaped("alt", oImage.getAlt() || tooltip); // accessibility requirement: use tooltip for alt if alt is not set
		} else if (tooltip) {
			rm.writeAttributeEscaped("alt", tooltip);
		}
	}
	rm.writeAttribute("tabIndex", myTabIndex);

	// Dimensions
	var myStyle = "";
	if (oImage.getWidth() && oImage.getWidth() != '') {
		myStyle += "width:" + oImage.getWidth() + ";";
	}
	if (oImage.getHeight() && oImage.getHeight() != '') {
		myStyle += "height:" + oImage.getHeight() + ";";
	}
	if (myStyle != "") {
		rm.writeAttribute("style", myStyle);
	}

	rm.write("/>"); // close the <img> element
};
}; // end of sap/ui/commons/ImageRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.InPlaceEditRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.InPlaceEditRenderer");

/**
 * @class InPlaceEdit renderer.
 * @static
 */
sap.ui.commons.InPlaceEditRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oInPlaceEdit an object representation of the control that should be rendered
 */
sap.ui.commons.InPlaceEditRenderer.render = function(rm, oInPlaceEdit){

	var oContent = oInPlaceEdit.getContent();
	var sWidth;

	if (oContent) {
		if (oContent.getWidth) {
			sWidth = oContent.getWidth();
		}
		if (oContent.getVisible && !oContent.getVisible()) {
			// invisible -> render nothing
			return;
		}
	}else{
		// no content -> render nothing
		return;
	}

	// write the HTML into the render manager
	rm.write("<DIV");
	rm.writeControlData(oInPlaceEdit);
	rm.addClass("sapUiIpe");

	if (!oInPlaceEdit.getEditable()) {
		rm.addClass("sapUiIpeRo");
	}else if (!oInPlaceEdit._bEditMode) {
		// display mode
		rm.writeAttribute("tabindex", "-1"); //to have focus event on clicking on this DIV (ComboBox expander in display mode)
		if (!oInPlaceEdit._sOldTextAvailable) {
			if (oContent.getMetadata().getName() == "sap.ui.commons.ComboBox" || oContent.getMetadata().getName() == "sap.ui.commons.DropdownBox") {
				rm.addClass("sapUiIpeCombo");
			}
		}
		if (oContent.getMetadata().getName() == "sap.ui.commons.Link") {
			rm.addClass("sapUiIpeLink");
		}
	}else{
		// edit mode
		rm.addClass("sapUiIpeEdit");
	}

	if (sWidth) {
		rm.addStyle("width", sWidth);
	}

	if (oInPlaceEdit.getUndoEnabled() && oInPlaceEdit._sOldTextAvailable && ( !oInPlaceEdit._bEditMode || ( oInPlaceEdit._bEditMode && oInPlaceEdit._oEditControl.getValue() != oInPlaceEdit._sOldText))) {
		// there is an old text available - visualize Undo
		rm.addClass("sapUiIpeUndo");
	}

	switch (oInPlaceEdit.getValueState()) {
	case sap.ui.core.ValueState.Error:
		rm.addClass('sapUiIpeErr');
	break;
	case sap.ui.core.ValueState.Success:
		rm.addClass('sapUiIpeSucc');
	break;
	case sap.ui.core.ValueState.Warning:
		rm.addClass('sapUiIpeWarn');
	break;
	default:
	break;
	}

	var tooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oInPlaceEdit, oInPlaceEdit.getTooltip_AsString());
	if(tooltip) {
		rm.writeAttributeEscaped('title', tooltip);
	}

	rm.writeClasses();
	rm.writeStyles();
	rm.write(">"); // DIV
	if (oInPlaceEdit._sOldTextAvailable || oContent.getMetadata().getName() == "sap.ui.commons.Link") {
		// there is an old text available - put content in a extra DIV to position
		// for Link do it always to have the edit button next to the link, but have the defined width for the outer DIV
		rm.write("<DIV");
		rm.addClass("sapUiIpeCont");
		if (oContent.getMetadata().getName() == "sap.ui.commons.ComboBox" || oContent.getMetadata().getName() == "sap.ui.commons.DropdownBox") {
			rm.addClass("sapUiIpeCombo");
		}
		rm.writeClasses();
		rm.write(">"); // DIV

	}
	if (oInPlaceEdit._bEditMode) {
		this.renderEditContent(rm, oInPlaceEdit);
	}else{
		this.renderDisplayContent(rm, oInPlaceEdit);
	}
	if (oInPlaceEdit._sOldTextAvailable || oContent.getMetadata().getName() == "sap.ui.commons.Link") {
		rm.write("</DIV>");
		if (oInPlaceEdit.getUndoEnabled() && oInPlaceEdit._sOldTextAvailable) {
			// there is an old text available and undo enabled - render undo button
			rm.renderControl(oInPlaceEdit._oUndoButton);
		}
	}
	rm.write("</DIV>");
};

sap.ui.commons.InPlaceEditRenderer.renderDisplayContent = function(rm, oInPlaceEdit){

	if (oInPlaceEdit._oDisplayControl) {
		rm.renderControl(oInPlaceEdit._oDisplayControl);
		if (oInPlaceEdit.getEditable() && oInPlaceEdit._oDisplayControl.getMetadata().getName() == "sap.ui.commons.Link") {
			rm.renderControl(oInPlaceEdit._oEditButton);
		}
	}

};

sap.ui.commons.InPlaceEditRenderer.renderEditContent = function(rm, oInPlaceEdit){

	if (oInPlaceEdit._oEditControl) {
		rm.renderControl(oInPlaceEdit._oEditControl);
	}

};
}; // end of sap/ui/commons/InPlaceEditRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.LabelRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Label
jQuery.sap.declare("sap.ui.commons.LabelRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class
 *
 * @author SAP - TD Core UI&AM UI Infra
 * @version 0.1
 * @static
 */
sap.ui.commons.LabelRenderer = {
//	sap.ui.core.Renderer.apply(this, arguments);
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
 * @param {sap.ui.core.Control} oLabel An object representation of the control that should be rendered.
 */
sap.ui.commons.LabelRenderer.render = function(oRenderManager, oLabel) {
	// Some convenience variables.
	var rm = oRenderManager;
	var r = sap.ui.commons.LabelRenderer;

	// Return immediately if control is invisible
	if (!oLabel.getVisible()) {
		return;
	}

	rm.write("<label");
	rm.writeControlData(oLabel);

	var sTooltip = oLabel.getTooltip_AsString();

	if (oLabel.getLabelForRendering()) {
		var oFor = sap.ui.getCore().byId(oLabel.getLabelForRendering());
		rm.write(" for=\"");
		// for some controls the label must point to an special HTML element, not the outer one.
		if ( oFor && oFor.getIdForLabel) {
			rm.write(oFor.getIdForLabel());
		} else{
			rm.write(oLabel.getLabelForRendering());
		}
		rm.write("\"");

		if ((!sTooltip || sTooltip == "") && oFor && oFor.getTooltip_AsString() && oFor.getTooltip_AsString() != "") {
			// If label has no own tooltip use tooltip of the labeled control
			sTooltip = oFor.getTooltip_AsString();
		}
	}

	// check whether a 'required' marker is needed
	if ( oLabel.isRequired() ) {
		rm.addClass('sapUiLblReq');
		if (oLabel.getRequiredAtBegin()) {
			rm.addClass('sapUiLblReqBeg');
		} else {
			rm.addClass('sapUiLblReqEnd');
		}
	}

	if(sTooltip) {
		rm.writeAttributeEscaped('title', sTooltip);
	}

	// Styles
	rm.addClass("sapUiLbl");
	if (oLabel.getDesign() == sap.ui.commons.LabelDesign.Bold) {
		rm.addClass("sapUiLblEmph");
	}

	// Text direction
	var sTextDir = oLabel.getTextDirection();
	if (sTextDir) {
		rm.addStyle("direction", sTextDir.toLowerCase());
	}

	// Style for text alignment
	var oTextAlign = oLabel.getTextAlign();
	if(oTextAlign) {
		rm.addStyle("text-align", r.getTextAlign(oTextAlign, sTextDir));
	}

	// Style for width
	var sWidth = oLabel.getWidth();
	if(sWidth) {
		rm.addStyle("width", sWidth);
	}

	if(!oLabel.getWrapping()){
		rm.addClass("sapUiLblNowrap");
	}

	rm.writeStyles();
	rm.writeClasses();

	// Close start tag
	rm.write(">");

	// Get image fragment if there is one, and write
	if (oLabel.getIcon()) {
		this.writeImgHtml(rm, oLabel);
	}

	// Write the label text
	if (oLabel.getText()) {
		rm.writeEscaped(oLabel.getText());
	}

	// Close tag
	rm.write("</label>");
};


sap.ui.commons.LabelRenderer.writeImgHtml = function(oRenderManager, oLabel) {
	var rm = oRenderManager;
	var sIconUrl = oLabel.getIcon();
	var oConfig = oRenderManager.getConfiguration();
	var aClasses = [];
	var mAttributes = {};

	aClasses.push("sapUiLblIco");
	if ((oLabel.getTextDirection()==sap.ui.core.TextDirection.RTL && !oConfig.getRTL()) || (oLabel.getTextDirection()==sap.ui.core.TextDirection.LTR && oConfig.getRTL())) {
		// if text direction is different to global text direction, icon margin must be switched.
		aClasses.push("sapUiLblIcoR");
	} else {
		aClasses.push("sapUiLblIcoL");
	}

	rm.writeIcon(sIconUrl, aClasses, mAttributes);

};

/**
 * Dummy inheritance of static methods/functions.
 * @see sap.ui.core.Renderer.getTextAlign
 * @private
 */
sap.ui.commons.LabelRenderer.getTextAlign = sap.ui.core.Renderer.getTextAlign;

}; // end of sap/ui/commons/LabelRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.LinkRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Link
jQuery.sap.declare("sap.ui.commons.LinkRenderer");

/**
 * @class
 *
 * @author SAP SE
 * @version 0.1
 * @static
 */
sap.ui.commons.LinkRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oLink An object representation of the control that should be rendered.
 */
sap.ui.commons.LinkRenderer.render = function(rm, oLink) {

	// Return immediately if control is invisible
	if (!oLink.getVisible()) {
		return;
	}

	// Link is rendered as a "<a>" element
	rm.write("<a");
	rm.writeControlData(oLink);

	rm.writeAccessibilityState(oLink);

	if (!oLink.getEnabled()) {
		rm.addClass("sapUiLnkDsbl");
		rm.writeAttribute("disabled", "true");
	} else {
		rm.addClass("sapUiLnk");
	}
	rm.writeClasses();

	if (oLink.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oLink.getTooltip_AsString());
	}

	if (oLink.getHref()) {
		rm.writeAttributeEscaped("href", oLink.getHref());
	}	else {
		rm.writeAttribute("href", "javascript:void(0);");
	}

	if (oLink.getTarget()) {
		rm.writeAttributeEscaped("target", oLink.getTarget());
	}

	if (!oLink.getEnabled()) {
		rm.writeAttribute("tabIndex", "-1");
	} else {
		rm.writeAttribute("tabIndex", "0");
	}

	if (oLink.getWidth()) {
		rm.addStyle("width", oLink.getWidth());
	}
	rm.writeStyles();

	// Close the opening tag
	rm.write(">");

	// Write the Link text
	if (oLink.getText()) {
		rm.writeEscaped(oLink.getText());
	}

	// Close the tag
	rm.write("</a>");

};

}; // end of sap/ui/commons/LinkRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ListBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ListBox
jQuery.sap.declare("sap.ui.commons.ListBoxRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('jquery.sap.strings'); // unlisted dependency retained


/**
 * @class ListBox Renderer
 *
 * @author d046011
 * @version 1.24.2
 * @static
 */
sap.ui.commons.ListBoxRenderer = {
};

/**
 * Renders the HTML for the ListBox, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
 * @param {sap.ui.commons.ListBox} oListBox The ListBox control that should be rendered.
 */
sap.ui.commons.ListBoxRenderer.render = function(rm, oListBox) {
	var r = sap.ui.commons.ListBoxRenderer;

	// TODO: this is a prototype experimenting with an alternative to onAfterRendering for size calculations and corrections
	// Do not copy this approach for now!
	// Main problem: renderers are supposed to create a string, not DOM elements, e.g. so they could also run on the server. At least that was the idea in former times.
	if (r.borderWidths === undefined) {
		if (!!sap.ui.Device.browser.internet_explorer) { // all known IE versions have this issue (min-width does not include borders)  TODO: update
			var oFakeLbx = document.createElement("div");
			var oStaticArea = sap.ui.getCore().getStaticAreaRef();
			oStaticArea.appendChild(oFakeLbx);
			oFakeLbx.className = "sapUiLbx";
			var $fakeLbx = jQuery(oFakeLbx);
			$fakeLbx.css("width", "50px");
			$fakeLbx.css("min-width", "100px");
			r.borderWidths = oFakeLbx.offsetWidth - 100;
			oStaticArea.removeChild(oFakeLbx);
		} else {
			// all other browsers are fine
			r.borderWidths = 0;
		}
	}


	// Return immediately if control is invisible
	if (!oListBox.getVisible()) {
		return;
	}

	rm.addClass("sapUiLbx");
	var bStd = true;
	if (!oListBox.getEditable()) {
		rm.addClass("sapUiLbxRo");
		bStd = false;
	}
	if (!oListBox.getEnabled()) {
		rm.addClass("sapUiLbxDis");
		bStd = false;
	}
	if (bStd) {
		rm.addClass("sapUiLbxStd"); // neither readonly nor disabled - this helps the CSS
	}

	// Open the containing <div> tag
	rm.write("<div");

	rm.writeControlData(oListBox);
	rm.writeAttribute("tabindex", "-1");

	var sWidth = oListBox.getWidth();
	if (sWidth) {
		rm.addStyle("width", sWidth);
		var bDisplaySecondaryValues = oListBox.getDisplaySecondaryValues();
		var bDisplayIcons = oListBox.getDisplayIcons();
		if (!bDisplaySecondaryValues && !bDisplayIcons) {
			// if fixed width, no secondary values and no icons use table-layout:fixed; to enable text-overflow:ellipsis;
			// not possible with secondary value / icons because of auto width function of table not available with fixed layout
			rm.addClass("sapUiLbxFixed");
		}
	}

	if (!sWidth || (sWidth == "auto") || (sWidth == "inherit")) {
		rm.addClass("sapUiLbxFlexWidth");
	}

	rm.writeClasses();

	// min/max-widths need fixes in IE
	var sMinWidth = oListBox.getMinWidth();
	var sMaxWidth = oListBox.getMaxWidth();
	if (!!sap.ui.Device.browser.internet_explorer) {
		sMinWidth = r.fixWidth(sMinWidth);
		sMaxWidth = r.fixWidth(sMaxWidth);
	}
	if (sMinWidth) {
		rm.addStyle("min-width", sMinWidth);
	}
	if (sMaxWidth) {
		rm.addStyle("max-width", sMaxWidth);
	}

	if (oListBox._bHeightInItems) {
		if (oListBox._sTotalHeight != null) {
			rm.addStyle("height", oListBox._sTotalHeight); // calculated height available
		} else {
			// height will be calculated and set in onAfterRendering
		}
	} else {
		var sHeight = oListBox.getHeight();
		if(sHeight){
			rm.addStyle("height", sHeight); // "normal" CSS height
		}
	}
	rm.writeStyles();

	var tooltip = oListBox.getTooltip_AsString();
	if (tooltip) {
		rm.writeAttributeEscaped("title", tooltip);
	}
	rm.write(">");

	this.renderItemList(oListBox, rm);

	rm.write("</div>");
};

/**
 * Renders all items
 */
sap.ui.commons.ListBoxRenderer.renderItemList = function (oListBox, rm) {

	// Write the start tag
	rm.write("<ul id='" + oListBox.getId() + "-list'");

	rm.writeAttribute("tabindex", this.getTabIndex(oListBox));

	// add ARIA stuff
	rm.writeAccessibilityState(oListBox, {
		role: "listbox",
		multiselectable: oListBox.getAllowMultiSelect()
	});
	rm.write(">");

	var items = oListBox.getItems(),
		iRealItemIndex = 0, // to not count separators
		iRealItemCount = 0;

	for (var i = 0; i < items.length; i++) { // TODO: required only for ARIA setsize
		if (!(items[i] instanceof sap.ui.core.SeparatorItem)) {
			iRealItemCount++;
		}
	}

	var bMarkLastChild = (!!sap.ui.Device.browser.internet_explorer && (sap.ui.Device.browser.version == 8)); // IE8 workaround for "last-child"
	var bDisplaySecondaryValues = oListBox.getDisplaySecondaryValues();

	// Write the rows with the items
	for (var i = 0; i < items.length; i++) {
		var item = items[i];

		if (item instanceof sap.ui.core.SeparatorItem) {
			// draw a separator
			rm.write("<div id='", item.getId(), "' class='sapUiLbxSep' role='separator'><hr/>");

			// colspan is not available, so add more separator cells
			if (oListBox.getDisplayIcons()) {
				rm.write("<hr/>");
			}
			if (bDisplaySecondaryValues) {
				rm.write("<hr/>");
			}
			rm.write("</div>");

		} else {
			// regular ListItem or just a plain Item
			rm.write("<li");
			rm.writeElementData(item);
			rm.writeAttribute("data-sap-ui-lbx-index", i);

			rm.addClass("sapUiLbxI");
			if (!item.getEnabled()) {
				rm.addClass("sapUiLbxIDis");
			}
			rm.writeAttribute("tabindex", "-1"); // make all LIs to focusable elements, tabindex will be changed by ItemNavigation
			if (oListBox.isIndexSelected(i)) {
				rm.addClass("sapUiLbxISel");
			}
			rm.writeClasses();

			// get the text values
			var sText = item.getText();
			var sSecondaryValue = item.getAdditionalText ? item.getAdditionalText() : ""; // allow usage of sap.ui.core.Item

			// tooltip
			if (item.getTooltip_AsString()) {
				rm.writeAttributeEscaped("title", item.getTooltip_AsString());
			} else {
				rm.writeAttributeEscaped("title", sText + ((bDisplaySecondaryValues && sSecondaryValue) ? "  --  " + sSecondaryValue : ""));
			}

			// ARIA
			rm.writeAccessibilityState(item, {
				role: "option",
				selected: (i===oListBox.getSelectedIndex()),
				setsize: iRealItemCount,
				posinset: iRealItemIndex+1
			});

			rm.write(">");


			// write icon column if required
			if (oListBox.getDisplayIcons()) {
				var sIcon;
				if (item.getIcon) { // allow usage of sap.ui.core.Item
					sIcon = item.getIcon();
				}
				rm.write("<span");
				if (sap.ui.core.IconPool.isIconURI(sIcon)) {
					rm.addClass("sapUiLbxIIco");
					rm.addClass("sapUiLbxIIcoFont");
					var oIconInfo = sap.ui.core.IconPool.getIconInfo(sIcon);
					rm.addStyle("font-family", "'" + oIconInfo.fontFamily + "'");
					if(oIconInfo && !oIconInfo.skipMirroring){
						rm.addClass("sapUiIconMirrorInRTL");
					}
					rm.writeClasses();
					rm.writeStyles();
					rm.write(">");
					rm.write(oIconInfo.content);
				}else{
					rm.write(" class='sapUiLbxIIco'><img src='");
					// if the item has an icon, use it; otherwise use something empty
					if (sIcon) {
						rm.writeEscaped(sIcon);
					} else {
						rm.write(sap.ui.resource('sap.ui.commons', 'img/1x1.gif'));
					}
					rm.write("'/>");
				}
				rm.write("</span>");
			}

			// write the main text
			rm.write("<span class='sapUiLbxITxt");
			if (bMarkLastChild && !bDisplaySecondaryValues) {
				rm.write(" sapUiLbxILastChild");
			}
			rm.write("'");
			rm.writeAttribute("id", item.getId() + "-txt");
			var oTextAlign = oListBox.getValueTextAlign();
			if(oTextAlign) {
				rm.write("style='text-align:" + sap.ui.commons.ListBoxRenderer.getTextAlign(oTextAlign, null) + "'"); // TODO: check whether the ListBox needs its own textDirection property
			}
			rm.write(">");
			if(sText === "" || sText === null) {
				rm.write("&nbsp;");
			} else {
				rm.writeEscaped(sText);
			}

			// Potentially display second column
			if (bDisplaySecondaryValues) {
				rm.write("</span><span class='sapUiLbxISec");
				if (bMarkLastChild) {
					rm.write(" sapUiLbxILastChild");
				}
				rm.write("'");
				var oTextAlign = oListBox.getSecondaryValueTextAlign();
				if(oTextAlign) {
					rm.write("style='text-align:" + sap.ui.commons.ListBoxRenderer.getTextAlign(oTextAlign, null) + "'"); // TODO: check whether the ListBox needs its own textDirection property
				}
				rm.write(">");
				rm.writeEscaped(sSecondaryValue);
			}

			rm.write("</span></li>");
			iRealItemIndex++;
		}
	}

	// Close the surrounding element
	rm.write("</ul>");
};


/**
 * If the given width is set in pixels, this method reduces the pixel width by the known total width of the borders.
 * Needed for IE which doesn't handle the combination of border-box and min/max-width correctly.
 * @private
 */
sap.ui.commons.ListBoxRenderer.fixWidth = function(sCssWidth) {
	if (sap.ui.commons.ListBoxRenderer.borderWidths > 0) {
		if (sCssWidth && jQuery.sap.endsWithIgnoreCase(sCssWidth, "px")) {
			var iWidth = parseInt(sCssWidth.substr(0, sCssWidth.length - 2), 10);
			var newWidth = iWidth - sap.ui.commons.ListBoxRenderer.borderWidths;
			if (newWidth >= 0) {
				return newWidth + "px";
			}
		}
	}
	return sCssWidth;
};

/**
 * The default TabIndex that should be set for the ListBox as well as for the selected element.
 * Can be overwritten in extending sub-classes.
 * @param {sap.ui.commons.ListBox} oListBox
 * @protected
 */
sap.ui.commons.ListBoxRenderer.getTabIndex = function(oListBox) {
	if (oListBox.getEnabled() && oListBox.getEditable()) {
		return 0;
	} else {
		return -1;
	}
};

/**
 * Adapts the item CSS classes after a selection change
 * @private
 */
sap.ui.commons.ListBoxRenderer.handleSelectionChanged = function(oListBox) { // TODO: handle tab stop
	if (oListBox.getDomRef()) {
		var items = oListBox.getItems();
		for (var i = 0, l = items.length; i < l; i++) { // TODO: could take very long for long lists
			if (oListBox.isIndexSelected(i)) {
				items[i].$().addClass("sapUiLbxISel").attr("aria-selected", "true");
			} else {
				items[i].$().removeClass("sapUiLbxISel").attr("aria-selected", "false");
			}
		}
	}
};

/**
 * Set the active descendant of the ListBox to get correct announcements
 * @private
 */
sap.ui.commons.ListBoxRenderer.handleARIAActivedescendant = function(oListBox, iIndex) {
	var $list = oListBox.$("list");
	if ($list.length > 0) {
		var $selectedChild = $list.children("li[data-sap-ui-lbx-index=" + iIndex + "]");
		$list.attr("aria-activedescendant", $selectedChild.attr("id"));
	}
};

/**
 * Dummy inheritance of static methods/functions.
 * @see sap.ui.core.Renderer.getTextAlign
 * @private
 */
sap.ui.commons.ListBoxRenderer.getTextAlign = sap.ui.core.Renderer.getTextAlign;

}; // end of sap/ui/commons/ListBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuBarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MenuBar
jQuery.sap.declare("sap.ui.commons.MenuBarRenderer");


/**
 * @class MenuBarRenderer.
 * @static
 */
sap.ui.commons.MenuBarRenderer = {
};

/**
 * Renders the HTML for the given menubar using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.commons.Toolbar} oToolbar An object representation of the control that should be rendered.
 */
sap.ui.commons.MenuBarRenderer.render = function(oRenderManager, oMenuBar) {
	var rm = oRenderManager;

	oMenuBar.doBeforeRendering();

	if(!oMenuBar.getVisible()) {
		return;
	}

	rm.write("<div");
	rm.writeControlData(oMenuBar);
	rm.addClass("sapUiMnuBar");
	if(oMenuBar.getDesign() == sap.ui.commons.MenuBarDesign.Header) {
		rm.addClass("sapUiMnuBarHeader");
	}
	var bIsDisabled = !oMenuBar.getEnabled();
	if(bIsDisabled) {
		rm.addClass("sapUiMnuBarDsbl");
	}
	rm.addStyle("width", oMenuBar.getWidth());
	rm.writeStyles();
	rm.writeClasses();
	rm.writeAttribute("tabindex", "0");
	var sTooltip = oMenuBar.getTooltip_AsString();
	sap.ui.commons.MenuBarRenderer.writeAria(rm, "menubar", sTooltip, bIsDisabled);
	rm.write("><ul");
	rm.writeAttribute("id", oMenuBar.getId()+"-area");
	rm.writeAttribute("class", "sapUiMnuBarArea");
	rm.write(">");

	var iVisibleItemIdx = 0;
	var aItems = oMenuBar.getItems();
	for(var i=0; i<aItems.length; i++){
		var oItem = aItems[i];
		if(oItem.getVisible()){
			iVisibleItemIdx++;
			rm.write("<li");
			rm.writeElementData(oItem);
			rm.addClass("sapUiMnuBarItm");
			var bDsbld = !oItem.getEnabled() || bIsDisabled;
			if(bDsbld) {
				rm.addClass("sapUiMnuBarItmDsbl");
			}
			rm.writeClasses();
			rm.writeAttribute("itemidx", ""+i);
			var sTooltip = oItem.getTooltip_AsString();
			sap.ui.commons.MenuBarRenderer.writeAria(rm, "menuitem", sTooltip, bDsbld, iVisibleItemIdx);
			rm.writeAttribute("tabindex", "-1");
			rm.write("><span>");
			rm.writeEscaped(oItem.getText());
			rm.write("</span></li>");
		}
	}

	rm.write("<li");
	rm.writeAttribute("id", oMenuBar.getId()+"-ovrflw");
	rm.writeAttribute("itemidx", "ovrflw");
	rm.writeAttribute("style", "display:none;");
	rm.writeAttribute("tabindex", "-1");
	rm.addClass("sapUiMnuBarItm");
	rm.addClass("sapUiMnuBarOvrFlw");
	if(bDsbld) {
		rm.addClass("sapUiMnuBarItmDsbl");
	}
	rm.writeClasses();
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	var sOverFlowText = undefined;
	if(rb) {
		sOverFlowText = rb.getText("MNUBAR_OVRFLW");
	}
	sap.ui.commons.MenuBarRenderer.writeAria(rm, "menuitem", sOverFlowText, false, 0);
	rm.write("><span></span></li></ul></div>");
};

sap.ui.commons.MenuBarRenderer.writeAria = function(rm, sRole, sText, bDisabled, iIdx){
	if(sText) {
		rm.writeAttributeEscaped("title", sText);
	}

	if(!sap.ui.getCore().getConfiguration().getAccessibility()) {
		return;
	}

	rm.writeAttribute("role", sRole);
	if(sRole == "menuitem"){
		rm.writeAttribute("aria-haspopup", true);
		rm.writeAttribute("aria-posinset", iIdx);
	}
	if(bDisabled) {
		rm.writeAttribute("aria-disabled", true);
	}
};
}; // end of sap/ui/commons/MenuBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MenuButton
jQuery.sap.declare("sap.ui.commons.MenuButtonRenderer");

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class MenuButton renderer.
 * For a common look&feel, the MenuButton extends the Button control,
 * just like the TextField ComboBox works.
 * @static
 */
sap.ui.commons.MenuButtonRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.ButtonRenderer);

/**
 * Hint: "renderButtonAttributes" is a reserved/hard-coded Button extending function!
 *       It is used to allow extensions to display content after the actual button content.
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager currently rendering this control
 * @param {sap.ui.commons.MenuButton}
 *            oControl the MenuButton that should be rendered
 * @private
 */
sap.ui.commons.MenuButtonRenderer.renderButtonAttributes = function(rm, oControl) {
	//Add specific ARIA information for MenuButton
	if (sap.ui.getCore().getConfiguration().getAccessibility()){
		rm.writeAttribute("aria-haspopup", "true");
	}
};

/**
 * Hint: "renderButtonContentAfter" is a reserved/hard-coded Button extending function!
 *       It is used to allow extensions to display content after the actual button content.
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager currently rendering this control
 * @param {sap.ui.commons.MenuButton}
 *            oControl the MenuButton that should be rendered
 * @private
 */
sap.ui.commons.MenuButtonRenderer.renderButtonContentAfter = function(rm, oControl) {
	rm.write("<span class=\"sapUiMenuButtonIco\"></span>");
};
}; // end of sap/ui/commons/MenuButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuItemBase') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)
 * 
 * (c) Copyright 2009-2014 SAP SE. All rights reserved
 */

jQuery.sap.declare("sap.ui.commons.MenuItemBase");

/**
 * @class Provides the standard properties for menu items.
 * @extends sap.ui.unified.MenuItemBase
 *
 * @author SAP SE 
 *
 * @public
 * @deprecated Since version 1.21.0. 
 * Please use the control sap.ui.unified.MenuItemBase of the library sap.ui.unified instead.
 * @name sap.ui.commons.MenuItemBase
 */

(function(){

try{
	sap.ui.getCore().loadLibrary("sap.ui.unified");
}catch(e){
	alert("The controls/elements 'sap.ui.commons.Menu*' needs library 'sap.ui.unified'.");
	throw(e);
}

jQuery.sap.require('sap.ui.unified.MenuItemBase'); // unlisted dependency retained


sap.ui.commons.MenuItemBase = sap.ui.unified.MenuItemBase;

})();
}; // end of sap/ui/commons/MenuItemBase.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Menu
jQuery.sap.declare("sap.ui.commons.MenuRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.unified.MenuRenderer'); // unlisted dependency retained


sap.ui.commons.MenuRenderer = sap.ui.core.Renderer.extend(sap.ui.unified.MenuRenderer);
}; // end of sap/ui/commons/MenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageBarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MessageBar
jQuery.sap.declare("sap.ui.commons.MessageBarRenderer");
//jQuery.sap.require("sap.ui.commons.MessageType");
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained


/**
 * @class MessageBar renderer.
 * @static
 */
sap.ui.commons.MessageBarRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.MessageBarRenderer.render = function(oRenderManager, oControl){
  // Convenience variables
	var rm  = oRenderManager;
	var id  = oControl.getId();

	// Opening the outer DIV container:
	// (Marking it as "draggable" stops the browser text selection on drag.)
	rm.write('<div draggable="true"');
  rm.writeControlData(oControl);
  rm.addClass("sapUiMsgBar");
  if (this.oDropPosition) {
	// A "re-dock" image will be added if the MessageBar has been dragged.
	rm.addClass("sapUiMsgBarMoved");
  }
  rm.writeClasses();
  rm.write(">");

		// Opening the counters&icons DIV container:
		// (An "id" is provided as the Toast will have to right-align against this element.)
		rm.write('<div id="' + id + '__sums" class="sapUiMsgBarSums">');

		  // Open-Hide message list arrow:
			// (An "id" is provided as the Toast will have to point-back towards this element.)
			// (This "Arrow" image is state-dependent and theme-dependent.)
			rm.write('<div id="' + id + '__arrowImg" class="sapUiMsgBarToggle"></div>');

		  // Error area: Image and Error count.
			// IDs are provided for DOM updates: display:none and count.
			rm.write('<div id="' + id + '__ErrorImg" class="sapUiMsgIcon sapUiMsgIconError sapUiMsgBarZeroCount"></div>');
			rm.write('<span id="' + id + '__ErrorCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');

		  // Warning area: Image and Warning count.
			rm.write('<div id="' + id + '__WarningImg" class="sapUiMsgIcon sapUiMsgIconWarning sapUiMsgBarZeroCount"></div>');
			rm.write('<span id="' + id + '__WarningCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');

		  // Success area: Image and Success count.
			rm.write('<div id="' + id + '__SuccessImg" class="sapUiMsgIcon sapUiMsgIconSuccess sapUiMsgBarZeroCount"></div>');
			rm.write('<span id="' + id + '__SuccessCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');

		// Closing the counters&icons DIV container:
	  rm.write("</div>");

	  // Re-dock icon: Appears after Drag&Drop.
		rm.write('<div class="sapUiMsgBarHome"></div>');

	// Closing the outer DIV container:
  rm.write("</div>");
};
}; // end of sap/ui/commons/MessageBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageListRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MessageList
jQuery.sap.declare("sap.ui.commons.MessageListRenderer");

/**
 * @class MessageList renderer.
 * @static
 */
sap.ui.commons.MessageListRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.MessageListRenderer.render = function(oRenderManager, oControl){
	// Convenience variable
	var rm = oRenderManager;

	// Opening the outer container:
  rm.write('<ul class="sapUiMsgList"');
  rm.writeControlData(oControl);
  rm.write(">");

	  // Rendering all supplied messages:
	  // Most recent messages were pushed in last, so looping in reversed order
	  // to display those first.
		for (var i=oControl.aMessages.length-1; i>=0; i--) {
		  rm.write('<li class="sapUiMsgListLi">');
		  rm.renderControl(oControl.aMessages[i]);
		  rm.write("</li>");
		} // end for

  // Closing container:
  rm.write("</ul>");
};
}; // end of sap/ui/commons/MessageListRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.commons.Message
jQuery.sap.declare("sap.ui.commons.MessageRenderer");

/**
 * @class Message renderer.
 * @static
 */
sap.ui.commons.MessageRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * A "Message" renders with:
 *  - An icon,
 *  - Possibly with a "Details" pointer to point to its longText
 *  - A shortText
 * It is up to its host (Toast, List, ... ) to hide or not the different parts.
 * For example, it is for the Toast to decide if icons are to be shown or not! Decision can be theme-dependent!
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.MessageRenderer.render = function(oRenderManager, oControl){
	// Convenience variables
	var rm = oRenderManager;

	// Opening the outer container:
	// tabindex="0": Message must be focusable for accessibility?!?
	rm.write('<div class="sapUiMsg" tabindex="0">');

	// Message icon:
	rm.write('<div class="sapUiMsgIcon sapUiMsgIcon' + oControl.getType() + '"></div>');

	// Possible "Details" pointer, with its trailing "-" separator:
	if ( typeof oControl.fnCallBack === "function" ) {
		rm.write('<span class="sapUiMsgLnk">');
		// Rendering a "short" Link pointing to the "long" Details:
		if (!oControl.oLink) {
			oControl.oLink = new sap.ui.commons.Link();
			var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
			oControl.oLink.setText(rb.getText("MSGLIST_DETAILS"));
			oControl.oLink.attachPress(function() {oControl.openDetails();});
		}
		rm.renderControl(oControl.oLink);
		rm.write(' - </span>');
	}

	// ShortText:
	rm.write('<span class="sapUiMsgTxt">');
	rm.writeEscaped(oControl.getText());
	rm.write('</span>');

	// Closing the outer container:
	rm.write('</div>');
};
}; // end of sap/ui/commons/MessageRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageToastRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MessageToast
jQuery.sap.declare("sap.ui.commons.MessageToastRenderer");

/**
 * @class MessageToast renderer.
 * @static
 */
sap.ui.commons.MessageToastRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.MessageToastRenderer.render = function(oRenderManager, oControl){
	// Convenience variable
	var rm = oRenderManager;

	// Opening the invisible outer-DIV container:
	// (Required to host the down-arrow.)
	// "classing" as per Type/Priority, for influencing the inner rendering:
	rm.write('<div class="' + oControl.getClasses() + '"');
	rm.writeControlData(oControl);
	rm.write('>');

		// Opening the inner-DIV message-container:
		rm.write('<div class="sapUiMsgToastMsg sapUiShd">');

			// Checking what message is to be toasted:
		  if (oControl.oMessage) {
			rm.renderControl(oControl.oMessage);
		  } else {
			// No message supplied. Rendering "Multiple new messages...":
				var sMultiMsgs = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("MSGTOAST_MULTI_MSGS");
				rm.write('<div class="sapUiMsg" tabindex="0"><span class="sapUiMsgTxt">' + sMultiMsgs + '</span></div>');
		  }

		// Closing the inner-DIV message-container:
		rm.write("</div>");

	  // Down-arrow:
		// (An "id" is provided as this arrow will have to point-back towards the right Bar icon.)
		// (This "Arrow" image is Type/Priority-dependent and theme-dependent.)
		rm.write('<div id="' + oControl.getId() + 'Arrow" class="sapUiMsgToastArrow"></div>');

	// Closing the invisible outer-DIV container:
	rm.write("</div>");
};
}; // end of sap/ui/commons/MessageToastRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.PaginatorRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.commons.Paginator
jQuery.sap.declare("sap.ui.commons.PaginatorRenderer");
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained


/**
 * @class Paginator renderer.
 * @static
 */
sap.ui.commons.PaginatorRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oPaginator an object representation of the control that should be rendered
 */
sap.ui.commons.PaginatorRenderer.render = function(oRm, oPaginator){

	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	oRm.write("<div");
	oRm.writeControlData(oPaginator);
	oRm.writeAccessibilityState(oPaginator, {
		role: "toolbar",
		labelledby: oPaginator.getId() + "-accDesc"
	});
	oRm.addClass("sapUiPag");
	oRm.writeClasses();
	oRm.write(">");

	oRm.write("<span class='sapUiPagAccDesc' id='" + oPaginator.getId() + "-accDesc'>");
	oRm.writeEscaped(rb.getText("PAGINATOR"));	
	oRm.write("</span>");

	this.renderPaginator(oRm, oPaginator);

	oRm.write("</div>");
};


/**
 * Builds the paginator
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oPaginator an object representation of the control that should be rendered
 */
sap.ui.commons.PaginatorRenderer.renderPaginator = function(oRm, oPaginator) {
	// First check if number of page is 1 or less, in this case, we do not render the paginator
	if (oPaginator.getNumberOfPages() <= 1) {
		return;
	}

	// Buffer paginator id for other ids concatenation
	var paginatorId = oPaginator.getId();
	var iCurrentPage = oPaginator.getCurrentPage();
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");


	/************************************************************************************
	 * Render the Page 1 (first page link) when necessary, back arrow, back link
	 ************************************************************************************/
	var linkClass = (iCurrentPage == 1) ? "sapUiLnkDsbl" : "sapUiLnk";
	var linkAcc = (iCurrentPage == 1) ? " aria-disabled='true'" : "";

	// First page link must only appear when at least 5 pages are available
	if (oPaginator.getNumberOfPages() > 5) {
		oRm.write("<a id='" + paginatorId + "--firstPageLink' href='javascript:void(0);' title='");
		oRm.writeEscaped(rb.getText("FIRST_PAGE"));
		oRm.write("' class='sapUiPagBtn sapUiPagFirst " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
		oRm.writeEscaped(rb.getText("PAGINATOR_OTHER_PAGE", [1]));
		oRm.write("</span></a>");
	}
	oRm.write("<a id='" + paginatorId + "--backLink' href='javascript:void(0);' title='");
	oRm.writeEscaped(rb.getText("PREVIOUS_PAGE"));
	oRm.write("' class='sapUiPagBtn sapUiPagBack " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
	oRm.writeEscaped(rb.getText("BACK"));
	oRm.write("</span></a>");



	/************************************************************************************
	 * Render the page numbers in a list
	 *************************************************************************************/
	oRm.write("<ul id='" + paginatorId + "-pages' role='presentation'>");
	oRm.write(sap.ui.commons.PaginatorRenderer.getPagesHtml(paginatorId, oPaginator._calculatePagesRange(), oPaginator.getCurrentPage(), true));
	oRm.write("</ul>");



	/************************************************************************************
	 * Render the forward link, forward arrow and last page link when necessary
	 *************************************************************************************/
	linkClass = (iCurrentPage == oPaginator.getNumberOfPages()) ? "sapUiLnkDsbl" : "sapUiLnk";
	linkAcc = (iCurrentPage == 1) ? " aria-disabled='true'" : "";

	oRm.write("<a id='" + paginatorId + "--forwardLink' href='javascript:void(0);' title='");
	oRm.writeEscaped(rb.getText("NEXT_PAGE"));
	oRm.write("' class='sapUiPagBtn sapUiPagForward " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
	oRm.writeEscaped(rb.getText("FORWARD"));
	oRm.write("</span></a>");
	if (oPaginator.getNumberOfPages() > 5) {
		oRm.write("<a id='" + paginatorId + "--lastPageLink' href='javascript:void(0);' title='");
		oRm.writeEscaped(rb.getText("LAST_PAGE"));
		oRm.write("' class='sapUiPagBtn sapUiPagLast " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
		oRm.writeEscaped(rb.getText("PAGINATOR_OTHER_PAGE", [oPaginator.getNumberOfPages()]));
		oRm.write("</span></a>");
	}
};


sap.ui.commons.PaginatorRenderer.getPagesHtml = function(sPaginatorId, oRange, iCurrent, bVisible) {
	var aHtml = [];
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	// each single page link is an <li> with an <a> inside
	for (var i = oRange.firstPage; i <= oRange.lastPage; i++) {
		aHtml.push("<li id='" + sPaginatorId + "-li--" + i + "' class='sapUiPagPage");
		aHtml.push((i == iCurrent) ? " sapUiPagCurrentPage'" : "'");
		if (!bVisible) { // for those items to be animated into view
			aHtml.push(" style='display:none'");
		}
		aHtml.push(">");
		aHtml.push("<a id='" + sPaginatorId + "-a--" + i + "' title='");
		if (i == iCurrent) {
			aHtml.push(jQuery.sap.encodeHTML(rb.getText("PAGINATOR_CURRENT_PAGE", [i])));
		} else {
			aHtml.push(jQuery.sap.encodeHTML(rb.getText("PAGINATOR_OTHER_PAGE", [i])));
		}
		aHtml.push("' href='javascript:void(0);'");
		if (i == iCurrent) {
			aHtml.push(" tabindex='0' class='sapUiLnkDsbl'");
		} else {
			 aHtml.push(" class='sapUiLnk'");
		}
		aHtml.push(">" + i + "</a>"); // TODO: clickable?! onPageClick
		aHtml.push("</li>");
	}

	return aHtml.join("");
};

/**
 * Updates the back/first/next/last page links
 * @param {sap.ui.core.Control} oPaginator an object representation of the control that should be updated
 * @private
 */
sap.ui.commons.PaginatorRenderer.updateBackAndForward = function(oPaginator) {
	var page = oPaginator.getCurrentPage();
	var id = oPaginator.getId();

	var isFirst = (page == 1);
	var isLast = (page == oPaginator.getNumberOfPages());

	var firstPage = jQuery.sap.byId(id + "--firstPageLink").toggleClass("sapUiLnk", !isFirst).toggleClass("sapUiLnkDsbl", isFirst);
	var backLink = jQuery.sap.byId(id + "--backLink").toggleClass("sapUiLnk", !isFirst).toggleClass("sapUiLnkDsbl", isFirst);
	var forwardLink = jQuery.sap.byId(id + "--forwardLink").toggleClass("sapUiLnk", !isLast).toggleClass("sapUiLnkDsbl", isLast);
	var lastPage = jQuery.sap.byId(id + "--lastPageLink").toggleClass("sapUiLnk", !isLast).toggleClass("sapUiLnkDsbl", isLast);
	
	if (isFirst) {
		firstPage.attr("aria-disabled", "true");
		backLink.attr("aria-disabled", "true");
		forwardLink.removeAttr("aria-disabled");
		lastPage.removeAttr("aria-disabled");
	} else if (isLast) {
		firstPage.removeAttr("aria-disabled");
		backLink.removeAttr("aria-disabled");
		forwardLink.attr("aria-disabled", "true");
		lastPage.attr("aria-disabled", "true");
	} else {
		firstPage.removeAttr("aria-disabled");
		backLink.removeAttr("aria-disabled");
		forwardLink.removeAttr("aria-disabled");
		lastPage.removeAttr("aria-disabled");
	}
};
}; // end of sap/ui/commons/PaginatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.PanelRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Panel
jQuery.sap.declare("sap.ui.commons.PanelRenderer");

/**
 * @class
 * @static
 */
sap.ui.commons.PanelRenderer = function() {
};


/**
 * Renders the HTML for the Panel, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered
 */
sap.ui.commons.PanelRenderer.render = function(rm, oControl) {
	var id = oControl.getId();

	// do not render anything for invisible Panels
	if (!oControl.getVisible()) {
		return;
	}

	var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();

	//var hasToolbar = false; // TODO: this can be used in the future; rendering should already be quite ok, but minor adjustments are expected

	var heightSet = sap.ui.commons.Panel._isSizeSet(oControl.getHeight());
	var widthSet = sap.ui.commons.Panel._isSizeSet(oControl.getWidth());

	oControl.getScrollTop();  // update the scroll position properties
	oControl.getScrollLeft();


	// root element and classes
	rm.write("<section");
	rm.writeControlData(oControl);
	rm.addClass("sapUiPanel");
	rm.addStyle("width", oControl.getWidth());

	if (!oControl.getCollapsed()) {
		rm.addStyle("height", oControl.getHeight());
	} else {
		rm.addClass("sapUiPanelColl");
		rm.addStyle("height", "auto");
	}
	if (heightSet) {
		rm.addClass("sapUiPanelHeightSet");
	}
	if (widthSet) {
		rm.addClass("sapUiPanelWidthSet");
	}
	if (oControl.getApplyContentPadding()) {
		rm.addClass("sapUiPanelWithPadding");
	}
	if (!oControl.getEnabled()) {
		rm.addClass("sapUiPanelDis");
	}
	if (oControl.getShowCollapseIcon()) {
		rm.addClass("sapUiPanelWithCollapseIcon");
	}
	rm.addClass("sapUiPanelBorderDesign" + oControl.getBorderDesign());
	rm.addClass("sapUiPanelAreaDesign" + oControl.getAreaDesign());
	rm.writeClasses();
	rm.writeStyles();

	if (accessibility) {
		rm.writeAttribute("aria-labelledby", id + "-title ");
		rm.writeAttribute("aria-describedby", id + "-acc");
		rm.writeAttribute("role", "region");
		if (oControl.getCollapsed()) {
			rm.writeAttribute("aria-expanded", "false");
		} else {
			rm.writeAttribute("aria-expanded", "true");
		}
		rm.writeAttribute("tabindex", "0");
	}

	// tooltip of Panel
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}


	// header
	rm.write("><header id='" + id + "-hdr'");
	rm.addClass("sapUiPanelHdr");

	// tooltip of Title, might be set in addition
	var oTitle = oControl.getTitle();
	var sTitleTooltip;
	var sLevel = sap.ui.core.TitleLevel.H5; // to be compatible of size
	var bEmphasized = true;
	if (oTitle) {
		sTitleTooltip = oTitle.getTooltip_AsString();
		if (sTitleTooltip) {
			rm.writeAttributeEscaped("title", sTitleTooltip);
		}

		if (oTitle.getLevel() != sap.ui.core.TitleLevel.Auto) {
			// if title level is set use emphasized of title, otherwise use default one to be compatible
			sLevel = oTitle.getLevel();
			bEmphasized = oTitle.getEmphasized();
		}
	}
	if (bEmphasized) {
		rm.addClass("sapUiPanelHdrEmph");
	}

	rm.writeClasses();
	rm.write(">");
	
	if(oControl.getShowCollapseIcon() && accessibility){
		rm.write("<span id=\""+id+"-acc\" style=\"display:none;\">");
		rm.writeEscaped(oControl._rb.getText("PANEL_HEAD_ACC"));
		rm.write("</span>");
	}

	var sCollapseTooltip = oControl._rb.getText(oControl.getCollapsed() ? "PANEL_EXPAND" : "PANEL_COLLAPSE");
	if (oControl.getShowCollapseIcon()) { /* TODO: remove this one and rearrange the other in CSS */
		rm.write("<a id='" + id + "-collArrow' class='sapUiPanelHdrItem sapUiPanelCollArrow' href='javascript:void(0)' tabindex='0' title='" + sCollapseTooltip + "'");
		if (accessibility) {
			//rm.writeAttribute("aria-labelledby", id + "-title");
			rm.writeAttribute("role", "button");
		}
		rm.write(">&nbsp;</a>");
	}


	// IMPORTANT: title h1 is always rendered to simplify calculations and because having no title should be a rare use-case
	// if (oTitle) {
	if (oTitle && oTitle.getIcon()) {
		// header icon, if available
		var sIcon = oTitle.getIcon();
		var aClasses = [];
		var mAttributes = {};

		mAttributes["id"] = id + "-ico";
		aClasses.push("sapUiPanelIco");
		aClasses.push("sapUiPanelHdrItem");
		aClasses.push("sapUiTv"+sLevel); // use same font-size like header level (if icon font is used (for image it dosn't matters)

		rm.writeIcon(sIcon, aClasses, mAttributes);
	}

	// header title text
	var text = jQuery.sap.escapeHTML(oControl.getText());
	if (!text) {
		text = "&nbsp;";
	}
	// just reuse TextView class because there font size & co. is already defined
	rm.write("<"+sLevel+" ");
	rm.addClass("sapUiTv"+sLevel);
//	rm.write("<h1 id='" + id + "-title' class='sapUiPanelHdrItem sapUiPanelTitle'");
	rm.write(" id='" + id + "-title' ");
	rm.addClass("sapUiPanelHdrItem");
	rm.addClass("sapUiPanelTitle");
	rm.writeClasses();
	if (accessibility) {
		rm.writeAttribute("role", "heading");
	}
	rm.write(">");
	rm.write(text); // already escaped!
//	rm.write("</h1>");
	rm.write("</"+sLevel+">");


  // toolbar + buttons
  var aButtons = oControl.getButtons();
  if (aButtons && (aButtons.length > 0)) {
	rm.write("<div id='" + id + "-tb' class='sapUiPanelHdrItem sapUiPanelTb sapUiTbDesignFlat'>");

	for (var i = 0; i < aButtons.length; i++) {
		rm.renderControl(aButtons[i]);
	}

		rm.write("</div>");
  }


  // any other right-aligned buttons go like this:
  // <a id="firstIcoRight" class="sapUiPanelHdrRightItem sapUiPanel*">O</a>
  // the positioning among these items needs to be solved then, either by fixed CSS classes if there are few items (like Right1 Right2)
  // or maybe they need to be put into a nowrap div

  // collapse icon
  if (oControl.getShowCollapseIcon()) {
		rm.write("<a id='" + id + "-collIco' class='sapUiPanelHdrRightItem sapUiPanelCollIco' href='javascript:void(0)' tabindex='0' title='" + sCollapseTooltip + "'");
		if (accessibility) {
			//rm.writeAttribute("aria-labelledby", id + "-title");
			rm.writeAttribute("role", "button");
		}
		rm.write(">&nbsp;</a>");
	}

  rm.write("</header>");



	// content area

	// everything below the header is only rendered initially if not collapsed - saves performance and Panel just re-renders later on expand
	if (!oControl.getCollapsed()) {
		rm.write("<div class='sapUiPanelCont' id='", id, "-cont'>");

		// Content (child controls)
		var oControls = oControl.getContent(),
				iLength = oControls.length;
		for (var i=0; i < iLength; i++) {
			rm.renderControl(oControls[i]);
		}

		rm.write("</div>");
	}

	rm.write("</section>");
};
}; // end of sap/ui/commons/PanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ProgressIndicatorRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ProgressIndicator
jQuery.sap.declare("sap.ui.commons.ProgressIndicatorRenderer");

/**
 * @class ProgressIndicator renderer.
 * @static
 */
sap.ui.commons.ProgressIndicatorRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.ProgressIndicatorRenderer.render = function(oRenderManager, oProgressIndicator){
	// .convenience variable
	var rm = oRenderManager;
	var widthControl = oProgressIndicator.getWidth();
	var widthBar = oProgressIndicator.getPercentValue();
	var widthBorder;
	var positionEnd;
	oProgressIndicator.bRtl  = sap.ui.getCore().getConfiguration().getRTL();

	// return immediately if control is invisible
	if (!oProgressIndicator.getVisible()) {
		return;
	}

	if (widthBar > 100) {
		widthBorder = (10000 / widthBar) + '%';
	}
	else {
		widthBorder = '100%';
	}

	// write the HTML into the render manager
	rm.write('<DIV');
	rm.writeControlData(oProgressIndicator);

	rm.writeAttribute('tabIndex', '0');

	//ARIA
	if ( sap.ui.getCore().getConfiguration().getAccessibility()){
//		rm.writeAttribute("role", sap.ui.core.AccessibleRole.Slider);
		rm.writeAttribute('role', 'progressbar');
		rm.writeAccessibilityState(oProgressIndicator, {valuemin: '0%'});
		rm.writeAccessibilityState(oProgressIndicator, {valuemax: '100%'});
		rm.writeAccessibilityState(oProgressIndicator, {valuenow: widthBar + '%'});
//		rm.writeAccessibilityState(oProgressIndicator, {label:oSlider.getTooltip()});

//		if (!oProgressIndicator.getEditable()) {
//			rm.writeAccessibilityState(oProgressIndicator, {disabled: true});
//		}else {
//			rm.writeAccessibilityState(oProgressIndicator, {disabled: false});
//		}
	}

	if (oProgressIndicator.getWidth() && oProgressIndicator.getWidth() != '') {
		rm.writeAttribute('style', 'height: 16px; width:' + widthControl + ';');
	}

	if (oProgressIndicator.getTooltip_AsString()) {
		rm.writeAttributeEscaped('title', oProgressIndicator.getDisplayValue() + '- '+ oProgressIndicator.getTooltip_AsString());
	}
	else {
		rm.writeAttributeEscaped('title', oProgressIndicator.getDisplayValue());
	}

	rm.addClass('sapUiProgInd');
	rm.writeClasses();

	rm.write('>');

	rm.write('<DIV');
	rm.writeAttribute('id', oProgressIndicator.getId() + '-box');

	if (oProgressIndicator.getWidth() && oProgressIndicator.getWidth() != '') {
		rm.writeAttribute('style', 'height: 16px; width:' + widthBorder + ';');
	}

	rm.addClass('sapUiProgIndBorder');
	rm.writeClasses();

	rm.write('>');

	rm.write('<DIV');
	rm.writeAttribute('id', oProgressIndicator.getId() + '-bar');
	rm.writeAttribute('onselectstart', "return false");
	rm.writeAttribute('style', 'height: 14px; width:' + oProgressIndicator.getPercentValue() + '%;');

	var sBarColor = oProgressIndicator.getBarColor();
	switch (sBarColor) {
		case "POSITIVE":
			rm.addClass('sapUiProgIndBarPos');
			break;
		case "NEGATIVE":
			rm.addClass('sapUiProgIndBarNeg');
			break;
		case "CRITICAL":
			rm.addClass('sapUiProgIndBarCrit');
			break;
		case "NEUTRAL":
			rm.addClass('sapUiProgIndBar');
			break;
		default:
			rm.addClass('sapUiProgIndBar');
			break;
	}

	rm.writeClasses();

	rm.write('>');

	rm.write('<DIV');
	rm.writeAttribute('id', oProgressIndicator.getId() + '-end');

	if (widthBar > 100) {
		switch (sBarColor) {
			case "POSITIVE":
				rm.addClass('sapUiProgIndPosEnd');
				break;
			case "NEGATIVE":
				rm.addClass('sapUiProgIndNegEnd');
				break;
			case "CRITICAL":
				rm.addClass('sapUiProgIndCritEnd');
				break;
			case "NEUTRAL":
				rm.addClass('sapUiProgIndEnd');
				break;
			default:
				rm.addClass('sapUiProgIndEnd');
				break;
		}
	}
	else {
		rm.addClass('sapUiProgIndEndHidden');
	}

	rm.writeClasses();
	if (oProgressIndicator.bRtl) {
		rm.writeAttribute('style', 'position: relative; right:' + widthBorder);
	} else {
		rm.writeAttribute('style', 'position: relative; left:' + widthBorder);
	}

	rm.write('>');
	rm.write('</DIV>');

	rm.write('<SPAN');

	rm.addClass('sapUiProgIndFont');
	rm.writeClasses();

	rm.write('>');

	if (oProgressIndicator.getShowValue()&& oProgressIndicator.getShowValue() == true) {
		if (oProgressIndicator.getDisplayValue() && oProgressIndicator.getDisplayValue() != '') {
			rm.writeEscaped(oProgressIndicator.getDisplayValue());
		}
	}

	rm.write('</SPAN>');
	rm.write('</DIV>');
	rm.write('</DIV>');
	rm.write('</DIV>');
};
}; // end of sap/ui/commons/ProgressIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButtonGroupRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RadioButtonGroup
jQuery.sap.declare("sap.ui.commons.RadioButtonGroupRenderer");

/**
 * @class RadioButtonGroup renderer.
 * @static
 */
sap.ui.commons.RadioButtonGroupRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.RadioButtonGroupRenderer.render = function(oRenderManager, oRBGroup){
	// convenience variable
	var rm = oRenderManager;

	// Return immediately if control is invisible or has no RadioButtons
	if (!oRBGroup.getVisible() || !oRBGroup.aRBs) {
		return;
	}

	var iColumns = oRBGroup.getColumns();
	var bEnabled = oRBGroup.getEnabled();

	if (bEnabled) {
		// check if at least one item is enabled
		var aItems = oRBGroup.getItems();
		bEnabled = false;
		for ( var i = 0; i < aItems.length; i++) {
			if (aItems[i].getEnabled()){
				bEnabled = true;
				break;
			}
		}
	}

	rm.write("<DIV");
	rm.writeControlData(oRBGroup);
	rm.addClass("sapUiRbG");
	if(iColumns > 1){
		if(iColumns == oRBGroup.aRBs.length){
			rm.addClass("sapUiRbG1Row");
		}else{
			rm.addClass("sapUiRbGTab");
			if (oRBGroup.getWidth() && oRBGroup.getWidth() != '') {
				rm.addClass("sapUiRbGTabFlex");
				// as in Firefox -moz-box-flex > 0 brings ellipsis even if no width is given
				// therefore flexible columns should be only used if a width is given.
			}
		}
	}

	if (oRBGroup.getWidth() && oRBGroup.getWidth() != '') {
		rm.addStyle("width", oRBGroup.getWidth());
	}

	if (oRBGroup.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oRBGroup.getTooltip_AsString());
	}

	if(bEnabled){
		rm.writeAttribute('tabindex', '0');
	}else{
		rm.writeAttribute('tabindex', '-1');
	}

	// ARIA
	rm.writeAccessibilityState(oRBGroup, {
		role: "radiogroup",
		invalid: oRBGroup.getValueState() == sap.ui.core.ValueState.Error,
		disabled: !oRBGroup.getEditable()
	});

	rm.writeClasses();
	rm.writeStyles();
	rm.write(">"); // DIV

	// columns
	for (var c = 0; c < iColumns; c++) {
		if(iColumns > 1 && iColumns != oRBGroup.aRBs.length){
			// if only 1 column -> no DIV necessary
			rm.write("<DIV");
			rm.addClass("sapUiRbGCol");
			rm.writeClasses();
			rm.write(">"); // DIV element
		}

		// render RadioButtons
		for (var i = c; i < oRBGroup.aRBs.length; i=i+iColumns) {
			rm.renderControl(oRBGroup.aRBs[i]);
		}

		if(iColumns > 1 && iColumns != oRBGroup.aRBs.length){
			rm.write("</DIV>");
		}
	}

	if(iColumns > 1 && iColumns != oRBGroup.aRBs.length){
		// dummy Column to avoid big spaces between RadioButtons in Safari
		rm.write('<DIV class="sapUiRbGDummy"> </DIV>');
	}

	rm.write("</DIV>");
};
}; // end of sap/ui/commons/RadioButtonGroupRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RadioButton
jQuery.sap.declare("sap.ui.commons.RadioButtonRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class RadioButton Renderer
 *
 * @author d046011
 * @version 0.1
 * @static
 */
sap.ui.commons.RadioButtonRenderer = {
};

/**
 * Renders the HTML for the RadioButton, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.commons.RadioButton} oRadioButton The RadioButton control that should be rendered.
 */
sap.ui.commons.RadioButtonRenderer.render = function(rm, oRadioButton) {

	// Return immediately if control is invisible
	if (!oRadioButton.getVisible()) {
		return;
	}

	var sId = oRadioButton.getId();
	var tooltip = oRadioButton.getTooltip_AsString();

	rm.addClass("sapUiRb");

	// Open the containing <span> tag
	rm.write("<span");
	rm.writeControlData(oRadioButton);

	// ARIA
	rm.writeAccessibilityState(oRadioButton, {
		role: "radio",
		checked: oRadioButton.getSelected() === true,
		invalid: oRadioButton.getValueState() == sap.ui.core.ValueState.Error,
		disabled: !oRadioButton.getEditable(),
		labelledby: sId+"-label",
		describedby: tooltip ? sId+"-Descr" : undefined
	});

	// Collect state information
	var enabled = oRadioButton.getEnabled() != null && oRadioButton.getEnabled();
	var editable = oRadioButton.getEditable() != null && oRadioButton.getEditable();
	var inErrorState = false;
	var inWarningState = false;
	if (oRadioButton.getValueState() != null) {
		inErrorState = sap.ui.core.ValueState.Error == oRadioButton.getValueState();
		inWarningState = sap.ui.core.ValueState.Warning == oRadioButton.getValueState();
	}

	// Add classes and properties depending on the state
	if (oRadioButton.getSelected()) {
		rm.addClass("sapUiRbSel");
	}

	var myTabIndex = 0;
	var bReadOnly = false;

	if (!enabled) {
		myTabIndex = -1;
		bReadOnly = true;
		rm.addClass("sapUiRbDis");
	}
	if (!editable) {
		//myTabIndex = -1; //According to CSN2581852 2012 a readonly RB should be in the tabchain
		bReadOnly = true;
		rm.addClass("sapUiRbRo");
	}
	if (inErrorState) {
		rm.addClass("sapUiRbErr");
	} else if (inWarningState) {
		rm.addClass("sapUiRbWarn");
	}
	if (enabled && editable && !inErrorState && !inWarningState) {
		rm.addClass("sapUiRbStd");
	}
	if (enabled && editable) {
		rm.addClass("sapUiRbInteractive");
	}
	rm.writeClasses();

	if (oRadioButton.getWidth() && oRadioButton.getWidth() != '') {
		rm.writeAttribute("style", "width:" + oRadioButton.getWidth() + ";");
	}

	rm.writeAttribute("tabIndex", myTabIndex);

	var tooltipToUse = sap.ui.core.ValueStateSupport.enrichTooltip(oRadioButton, tooltip ? tooltip : oRadioButton.getText());
	if (tooltipToUse) {
		rm.writeAttributeEscaped("title", tooltipToUse);
	}

	rm.write(">"); // Close the containing <span> tag


	// Write the real - potentially hidden - HTML RadioButton element
	rm.write("<input type='radio' tabindex='-1' id='");
	rm.write(sId);
	rm.write("-RB' name=\"");
	rm.writeEscaped(oRadioButton.getGroupName());
	rm.write("\" ");
	if (oRadioButton.getSelected()) {
		rm.write(" checked='checked'");
	}
	if (!enabled) {
		rm.write(" disabled='disabled'");
	}
	if(bReadOnly) {
		rm.write(" readonly='readonly'");
		rm.write(" disabled='disabled'");
	}
	if (oRadioButton.getKey()) {
		rm.writeAttributeEscaped("value", oRadioButton.getKey());
	}

	rm.write(" />"); // Close RadioButton-input-element


	// Write the RadioButton label which also holds the background image
	rm.write("<label id=\""+sId+"-label\"");
	rm.writeAttribute("for", sId + "-RB"); // Label for RadioButton, so a click toggles the state
	if (!oRadioButton.getText()) {
		rm.write(" class=\"sapUiRbNoText\"");
	}
	rm.write(">");
	if (oRadioButton.getText()) {
		this.renderText(rm, oRadioButton.getText(), oRadioButton.getTextDirection());
	}
	rm.write("</label>");

	if (tooltip) {
		// for ARIA the tooltip must be in a separate SPAN and assigned via aria-describedby.
		// otherwise JAWS do not read it.
		rm.write("<span id=\""+sId+"-Descr\" style=\"visibility: hidden; display: none;\">");
		rm.writeEscaped(tooltip);
		rm.write("</span>");
	}
	// Close the surrounding <span> element
	rm.write("</span>");
};

/**
 * Write RadioButton label - either flat, or, in case the text direction is different from the environment, within a <span> with an explicit "dir".
 */
sap.ui.commons.RadioButtonRenderer.renderText = function(oRenderManager, sText, eTextDirection) {
	var rm = oRenderManager;
	if (!eTextDirection || eTextDirection == sap.ui.core.TextDirection.Inherit){
		rm.writeEscaped(sText);
	} else {
		rm.write("<span style=\"direction:" + eTextDirection.toLowerCase() + ";\">");
		rm.writeEscaped(sText);
		rm.write("</span>");
	}
};

sap.ui.commons.RadioButtonRenderer.setSelected = function(oRadioButton, bSelected) {

	oRadioButton.$().toggleClass('sapUiRbSel', bSelected).attr('aria-checked', bSelected);
	var $Dom = oRadioButton.getDomRef("RB");
	if(bSelected){
		$Dom.checked = true;
		$Dom.setAttribute('checked', 'checked');
	}else{
		$Dom.checked = false;
		$Dom.removeAttribute('checked');
	}

};

}; // end of sap/ui/commons/RadioButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RatingIndicatorRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RatingIndicator
jQuery.sap.declare("sap.ui.commons.RatingIndicatorRenderer");

/**
 * @class RatingIndicatorRenderer.
 * @static
 */
sap.ui.commons.RatingIndicatorRenderer = function() {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oRating an object representation of the control that should be rendered
 */
sap.ui.commons.RatingIndicatorRenderer.render = function(oRenderManager, oRating) {
	var rm = oRenderManager;

	// return immediately if control is invisible
	if(!oRating.getVisible()){
		return;
	}

	var iNumberOfSymbols = oRating.getMaxValue();

	rm.write("<div");
	rm.writeControlData(oRating);
	rm.addClass("sapUiRating");
	if(oRating.getEditable()){
		rm.addClass("sapUiRatingEdit");
	}
	rm.writeClasses();
	rm.writeAttribute("tabindex", "0"/*oRating.getEditable() ? "0" : "-1"*/); //According to CSN 2581852 2012 the RI should always be in the tabchain
	if(oRating.getTooltip() && oRating.getTooltip_AsString()){
		rm.writeAttributeEscaped("title", oRating.getTooltip_AsString());
	}else if(!oRating.getEditable()){
		rm.writeAttribute("title", oRating._getDisplayValue());
	}

	//ARIA
	rm.writeAccessibilityState(oRating, {
		"role": "slider",
		"orientation": "horizontal",
		"valuemin": 1,
		"valuemax": iNumberOfSymbols,
		"disabled": !oRating.getEditable(),
		"live": "assertive"
	});

	rm.write(">");

	for(var i=0; i<iNumberOfSymbols; i++){
		sap.ui.commons.RatingIndicatorRenderer.renderItem(rm, oRating, i, oRating._getDisplayValue());
	}

	rm.write("</div>");
};

/**
 * Helper function to render a rating symbol.
 * @private
 */
sap.ui.commons.RatingIndicatorRenderer.renderItem = function(rm, oRating, i, fValue){
	var val = i+1;
	rm.write("<div");
	rm.writeAttribute("id", oRating.getId() + "-itm-" + val);
	rm.writeAttribute("itemvalue", val);
	rm.writeAttribute("class", "sapUiRatingItm");
	rm.writeAttribute("style", "line-height:0px;");
	if(!oRating.getTooltip() && oRating.getEditable()){
		//rm.writeAttribute("dir", "ltr"); //Do we need this to avoid tooltips like "of 5 3" instead of "3 of 5"
		rm.writeAttributeEscaped("title", oRating._getText("RATING_TOOLTIP" , [val, oRating.getMaxValue()]));
	}
	rm.write(">");

	rm.write("<img");
	rm.writeAttribute("class", "sapUiRatingItmImg");
	var sIcon = sap.ui.commons.RatingIndicatorRenderer.getThemeSymbol("selected", oRating);
	rm.writeAttributeEscaped("src", sIcon);
	rm.write("/>");

	rm.write("<div");
	rm.writeAttribute("class", "sapUiRatingItmOvrflw");

	var visualMode = oRating.getVisualMode();
	if(visualMode == "Full"){
		fValue = Math.round(fValue);
	}
	var style;
	if(fValue >= val){
		style = "width:0%;";
	}else if(fValue < i){
		style = "width:100%;";
	}else{
		var diff = fValue-i;
		if(visualMode == "Half"){
			var width = 50;
			if(diff < 0.25) {
				width = 100;
			}
			if(diff >= 0.75) {
				width = 0;
			}
			style = "width:" + width + "%;";
		}else{ //Continuous
			style = "width:" + (100-Math.round(diff*100)) + "%;";
		}
	}
	rm.writeAttribute("style", style);
	rm.write(">");

	rm.write("<img");
	rm.writeAttribute("class", "sapUiRatingItmOvrflwImg");
	sIcon = sap.ui.commons.RatingIndicatorRenderer.getThemeSymbol("unselected", oRating);
	rm.writeAttributeEscaped("src", sIcon);
	rm.write("/>");

	rm.write("</div>");
	rm.write("</div>");
};

/**
 * Helper function to render a rating symbol in hover state.
 *
 * @param {int} iCount the number of the rating image which should be hovered.
 * @param {sap.ui.core.Control} oRating an object representation of the control that should be rendered
 * @param {boolean} bAfter specifies whether the rating image is behind the hovered one.
 * @private
 */
sap.ui.commons.RatingIndicatorRenderer.hoverRatingSymbol = function(iCount, oRating, bAfter){
	var oSymbol = jQuery.sap.byId(oRating.getId() + "-itm-" + iCount);
	oSymbol.addClass("sapUiRatingItmHov");
	var oSymbolImage = oSymbol.children("img");
	var sIcon = sap.ui.commons.RatingIndicatorRenderer.getThemeSymbol(bAfter ? "unselected" : "hover", oRating);
	oSymbolImage.attr("src", sIcon);
};

/**
 * Helper function to render a rating symbol in normal (selected/deselected) state.
 *
 * @param {int} iCount the number of the rating image which should be unhovered.
 * @param {sap.ui.core.Control} oRating an object representation of the control that should be rendered
 * @private
 */
sap.ui.commons.RatingIndicatorRenderer.unhoverRatingSymbol = function(iCount, oRating){
	var oSymbol = jQuery.sap.byId(oRating.getId() + "-itm-" + iCount);
	oSymbol.removeClass("sapUiRatingItmHov");
	var oSymbolImage = oSymbol.children("img");
	var sIcon = sap.ui.commons.RatingIndicatorRenderer.getThemeSymbol("selected", oRating);
	oSymbolImage.attr("src", sIcon);
};

/**
 * Helper function to find the right symbol.
 *
 * @param {string} sType type of desired image (selected, unselected, hover)
 * @param {sap.ui.core.Control} oRating an object representation of the control that should be rendered
 * @private
 */
sap.ui.commons.RatingIndicatorRenderer.getThemeSymbol = function(sType, oRating){
	var sIcon, sParam;

	if(sType == "selected"){
		sIcon = oRating.getIconSelected();
		sParam = "sap.ui.commons.RatingIndicator:sapUiRatingSymbolSelected";
	}else if(sType == "unselected"){
		sIcon = oRating.getIconUnselected();
		sParam = "sap.ui.commons.RatingIndicator:sapUiRatingSymbolUnselected";
	}else{
		sIcon = oRating.getIconHovered();
		sParam = "sap.ui.commons.RatingIndicator:sapUiRatingSymbolHovered";
	}

	if(!sIcon){
		var sThemePath = 
			"themes/" + 
			sap.ui.getCore().getConfiguration().getTheme() + "/" + 
			sap.ui.core.theming.Parameters.get(sParam);

		// The documentation states that sap.ui.resource() should be used for theme-URLs
		sIcon = sap.ui.resource("sap.ui.commons", sThemePath);
	}

	return sIcon;
};
}; // end of sap/ui/commons/RatingIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ResponsiveContainerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ResponsiveContainer
jQuery.sap.declare("sap.ui.commons.ResponsiveContainerRenderer");

/**
 * @class RatingIndicatorRenderer.
 * @static
 */
sap.ui.commons.ResponsiveContainerRenderer = function() {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oRating an object representation of the control that should be rendered
 */
sap.ui.commons.ResponsiveContainerRenderer.render = function(oRenderManager, oContainer) {
	var oRM = oRenderManager,
		oContent = oContainer.getAggregation("content");
	oRM.write("<div ");
	oRM.writeControlData(oContainer);
	oRM.addStyle("width", oContainer.getWidth());
	oRM.addStyle("height", oContainer.getHeight());
	oRM.writeStyles();
	oRM.write(">");
	if (oContent) {
		oRM.renderControl(oContent);
	}
	// Render divs for each range into an invisible area to get the actual pixel width
	// for arbitrary CSS sizes (em, ex, rem, etc...)
	oRM.write("<div ");
	oRM.addStyle("width", "0px");
	oRM.addStyle("height", "0px");
	oRM.addStyle("overflow", "hidden");
	oRM.writeStyles();
	oRM.write(">");
	jQuery.each(oContainer.getRanges(), function(i, oRange) {
		oRM.write("<div ");
		oRM.writeElementData(oRange);
		oRM.addStyle("width", oRange.getWidth());
		oRM.addStyle("height", oRange.getHeight());
		oRM.writeStyles();
		oRM.write("></div>")
	});
	oRM.write("</div>")
	oRM.write("</div>");
};
}; // end of sap/ui/commons/ResponsiveContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RichTooltipRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RichTooltip
jQuery.sap.declare("sap.ui.commons.RichTooltipRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class RichToltip renderer.
 * @static
 */
sap.ui.commons.RichTooltipRenderer = {};

/**
 * Renders the HTML for the RichTooltip, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oRichTooltip An object representation of the control that should be rendered.
 */
sap.ui.commons.RichTooltipRenderer.render = function(rm, oRichTooltip){
	var sId = oRichTooltip.getId();

	// Header
	rm.write("<div ");
	rm.writeControlData(oRichTooltip);
	rm.addClass("sapUiRtt");
	rm.writeClasses();
	rm.write(" ><div><div>");
	rm.write("<div class='sapUiRttTopL'></div><div class='sapUiRttTopR'></div>");
	rm.write("<div class='sapUiRttCL'>");
	rm.write("<div class='sapUiRttCR'>");
	
	rm.write("<div class='sapUiRttContent'>");

	// Title
	var sTitle = oRichTooltip.getTitle();
	if (sTitle) {
		rm.write("<div id='" + sId +"-title' role='tooltip' class='sapUiRttTitle'>");
		rm.writeEscaped(sTitle);
		rm.write("</div>");
		// render a separator between title and rest of the RichTooltip
		rm.write("<div class='sapUiRttSep'></div>");
	}

	// if the parent element has a set ValueState render the corresponding text and image
	var sValueStateText = sap.ui.core.ValueStateSupport.getAdditionalText(oRichTooltip.getParent());
	
	// render the individual ValueState text (if available) otherwise use the default text
	var sIndividualText = oRichTooltip.getAggregation("individualStateText");
	
	// if there is any (from parent control or from RTT itself) value state text set
	if (sValueStateText || sIndividualText) {
		rm.write('<div class="sapUiRttValueStateContainer">');
		
		// only if the owner of the RTT has a value state - render state and image
		if (sValueStateText) {
			var sValueState = oRichTooltip.getParent().getValueState();
			var sValueStateImage = sValueState !== sap.ui.core.ValueState.None ? "ValueState_" + sValueState + ".png" : "";

			// if there is a proper value state -> render corresponding image
			if (sValueStateImage !== "") {
				sValueStateImage = jQuery.sap.getModulePath("sap.ui.commons", '/')
				+ "themes/"
				+ sap.ui.getCore().getConfiguration().getTheme()
				+ "/img/richtooltip/" + sValueStateImage;
			
				rm.write('<img id="'+ sId +'-valueStateImage" class="sapUiRttValueStateImage" src="');
				rm.writeEscaped(sValueStateImage);
				rm.write('"/>');
			}
		} 
	
	    if (sIndividualText) {
			rm.renderControl(sIndividualText);
		} else {
			rm.write('<div id="'+ sId +'-valueStateText" class="sapUiRttValueStateText">');
			rm.writeEscaped(sValueStateText);
			rm.write('</div>');
		}
		
		rm.write('</div>');
		
		// render a separator between ValueState stuff and text of the RichTooltip
		rm.write("<div class='sapUiRttSep'></div>");
	}	
	
	
	rm.write('<div class="sapUiRttContentContainer">');
	// render image that might be set
	var sImage = oRichTooltip.getImageSrc();
	if (sImage){
		var sAltText = oRichTooltip.getImageAltText();
		rm.write('<img id="' + sId + '-image" alt="' + sAltText + '" class="sapUiRttImage" src="');
		rm.writeEscaped(sImage);
		rm.write('"/>');
	}
	
	// render RichTooltip's text
	var oText = oRichTooltip.getAggregation("formattedText");
	if (oText){
		rm.renderControl(oText);
	}
	rm.write('</div>');

	// render footer
	rm.write("</div></div></div>");
	rm.write("<div class='sapUiRttBotL'></div>");
	rm.write("<div class='sapUiRttBotR'></div>");
	rm.write("</div></div></div>");
};
}; // end of sap/ui/commons/RichTooltipRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RoadMapRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RoadMap
jQuery.sap.declare("sap.ui.commons.RoadMapRenderer");

(function() {

/**
 * @class RoadMap renderer.
 * @static
 */
sap.ui.commons.RoadMapRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @private
 */
sap.ui.commons.RoadMapRenderer.render = function(oRenderManager, oRoadMap){
	var rm = oRenderManager;

	oRoadMap.doBeforeRendering(); //Inform the Roadmap that the rendering starts

	if(!oRoadMap.getVisible()) {
		return;
	}

	rm.write("<div");
	rm.writeControlData(oRoadMap);
	rm.addClass("sapUiRoadMap");
	rm.writeClasses();
	rm.writeAttribute("tabIndex", "0");

	var sTooltip = oRoadMap.getTooltip_AsString();
	if(sTooltip){
		rm.writeAttributeEscaped("title", sTooltip);
	}

	rm.writeAttribute("style", "width:"+(oRoadMap.getWidth() ? oRoadMap.getWidth() : "100%")+";");

	rm.write(">");

	renderDelimiter(rm, oRoadMap, true);

	rm.write("<ul");
	rm.writeAttribute("id", oRoadMap.getId() + "-steparea");
	rm.addClass("sapUiRoadMapStepArea");
	rm.writeClasses();

	//ARIA
	if(sap.ui.getCore().getConfiguration().getAccessibility()){
		rm.writeAttribute("role", "group");
		rm.writeAttributeEscaped("aria-label", getText("RDMP_DEFAULT_TOOLTIP", []));
		if(sTooltip){
			rm.writeAttributeEscaped("title", sTooltip);
		}
	}

	rm.write(">");

	var aSteps = oRoadMap.getSteps();
	for(var i=0; i<aSteps.length; i++){
		var oStep = aSteps[i];
		if(oStep.getSubSteps().length > 0){ //is expandable?
			renderExpandableStep(rm, oRoadMap, oStep);
		}else{
			renderStep(rm, oRoadMap, oStep);
		}
	}

	rm.write("</ul>");

	renderDelimiter(rm, oRoadMap, false);

	rm.write("</div>");
};


/**
 * Updates the CSS classes of the Roadmap to select a new step.
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {string} sId the ID of the step which should be selected.
 * @private
 */
sap.ui.commons.RoadMapRenderer.selectStepWithId = function(oRoadMap, sId){
	var sCurrentId = oRoadMap.getSelectedStep();
	if(sCurrentId) {
		jQuery.sap.byId(sCurrentId).removeClass("sapUiRoadMapSelected");
	}
	if(sId) {
		jQuery.sap.byId(sId).addClass("sapUiRoadMapSelected");
	}
	if(sap.ui.getCore().getConfiguration().getAccessibility()){
		if(sCurrentId) {
			jQuery.sap.byId(sCurrentId+"-box").removeAttr("aria-checked");
		}
		if(sId) {
			jQuery.sap.byId(sId+"-box").attr("aria-checked", true);
		}
	}
};


/**
 * Updates the CSS classes of the Roadmap when a step is selected. If the step is an
 * expandable step the exapnd state is toggled.
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @see <code>sap.ui.commons.RoadMapRenderer.selectStepWithId</code>
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {sap.ui.core.Element} oStep the step which was selected.
 * @param {boolean} bIsSubStep indicator whether the given step is a sub step or not.
 * @param {boolean} bSkipAnim indicator whether animation should be used or not.
 * @param {function} fEndCallBack callback function which is called in the end with a string parameter indicating the operation which was done ("expanded", "collapsed", "selected")
 * @param {boolean} bSkipSelect indicator whether selection state should be switched or not.
 * @private
 */
sap.ui.commons.RoadMapRenderer.selectStep = function(oRoadMap, oStep, bIsSubStep, bSkipAnim, fEndCallBack, bSkipSelect){
	if(!bSkipSelect){
		//Select the step
		sap.ui.commons.RoadMapRenderer.selectStepWithId(oRoadMap, oStep.getId());
	}
	if(!bIsSubStep && oStep.getSubSteps().length > 0){
		//Expandable step -> Toggle the expand state

		var aSteps = oStep.getSubSteps();
		var jDomRef = oStep.$();
		var bIsExpanded = jDomRef.hasClass("sapUiRoadMapExpanded"); //Get the current expand state

		var iCounter = 1; //Must be in the end 0 when all animations are done (see fDoOnAnimComplete)

		var fDoOnAnimComplete = function(){ //Function called when an animation is done
			iCounter--;
			if(iCounter > 0) {
				return;
			}

			//Only do something if the last animation finishs
			if(fEndCallBack) {
				fEndCallBack(!bIsExpanded ? "expanded" : "collapsed");
			}
			sap.ui.commons.RoadMapRenderer.updateStepArea(oRoadMap);
		};

		//Animation function to hide / show a step (depending on the current expand state)
		var fAnim = function(sId, bOpen, fComplete){
			var jRef = jQuery.sap.byId(sId);
			if(!jQuery.fx.off && !bSkipAnim){ //Animation only if turned on globally and if should not be skipped
				jRef.width(bOpen ? "0px" : oRoadMap.iStepWidth);
				var oLabel = jQuery.sap.byId(sId+"-label");
				oLabel.addClass("sapUiRoadMapHidden");
				if(bOpen) {
					jRef.toggleClass("sapUiRoadMapHidden");
				}
				jRef.animate({width: bOpen ? oRoadMap.iStepWidth : "0px"}, "fast", function(){
					if(!bOpen) {
						jRef.toggleClass("sapUiRoadMapHidden");
					}
					jRef.width("");
					oLabel.removeClass("sapUiRoadMapHidden");
					if(fComplete) {
						fComplete();
					}
				});
			}else{
				jRef.toggleClass("sapUiRoadMapHidden");
				if(fComplete) {
					fComplete();
				}
			}
		};

		//Change the expand state of the step immediately
		jDomRef.toggleClass("sapUiRoadMapExpanded");

		if(sap.ui.getCore().getConfiguration().getAccessibility()){
			var bExp = jDomRef.hasClass("sapUiRoadMapExpanded");
			oStep.$("box").attr("aria-expanded", bExp);
			oStep.$("expandend-box").attr("aria-expanded", bExp);
		}

		//Hide / Show the sub steps
		for(var i=0; i<aSteps.length; i++){
			if(aSteps[i].getVisible()){
				iCounter++;
				fAnim(aSteps[i].getId(), !bIsExpanded, fDoOnAnimComplete);
			}
		}
		//Hide / Show the end step
		fAnim(oStep.getId()+"-expandend", !bIsExpanded, fDoOnAnimComplete);
	}else{
		if(fEndCallBack) {
			fEndCallBack("selected");
		}
	}
};


/**
 * Recalculates the width of the step area and updates the delimiters.
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @private
 */
sap.ui.commons.RoadMapRenderer.updateStepArea = function(oRoadMap){
	if(oRoadMap.iStepWidth != -1){
		var jStepAreaRef = oRoadMap.$("steparea");
		var jStartDelimRef = oRoadMap.$("Start");
		var jEndDelimRef = oRoadMap.$("End");
		var jRoadMapRef = oRoadMap.$();

		var iScrollLeft = jStepAreaRef.scrollLeft();

		var iAvailableSpaceForSteps = jRoadMapRef.width() - jStartDelimRef.outerWidth(true) - jEndDelimRef.outerWidth(true);
		var iMaxVisibleSteps = oRoadMap.getNumberOfVisibleSteps();
		var iCurrentMaxVisibleSteps = getNumberOfPotentiallyVisibleSteps(oRoadMap);
		if(iMaxVisibleSteps < 1){
			iMaxVisibleSteps = iCurrentMaxVisibleSteps;
		}else{
			iMaxVisibleSteps = Math.min(iMaxVisibleSteps, iCurrentMaxVisibleSteps);
		}

		var iPossibleSteps = Math.floor(iAvailableSpaceForSteps / oRoadMap.iStepWidth);
		var iNumberOfVisibleSteps = Math.min(iMaxVisibleSteps, iPossibleSteps);
		jStepAreaRef.width(iNumberOfVisibleSteps * oRoadMap.iStepWidth).scrollLeft(iScrollLeft);

		updateDelimiters(oRoadMap);
	}
};


/**
 * Recalculates the width of the step area and updates the delimiters and sets the
 * focus either to the specified first visible step of the Roadmap (if not exists the first visible
 * step is focused).
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @see <code>sap.ui.commons.RoadMapRenderer.updateStepArea</code>
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {boolean} bSkipScrollState if false the function does the same as <code>sap.ui.commons.RoadMapRenderer.updateStepArea</code>
 * @private
 */
sap.ui.commons.RoadMapRenderer.updateScrollArea = function(oRoadMap, bSkipScrollState){
	sap.ui.commons.RoadMapRenderer.updateStepArea(oRoadMap);
	if(!bSkipScrollState){
		var jStepArea = oRoadMap.$("steparea");
		var oPos = getStepEndPosition(oRoadMap, false);
		if(oRoadMap.getFirstVisibleStep()){
			var jStep = jQuery.sap.byId(oRoadMap.getFirstVisibleStep());
			oPos = getPositionLeft(jStepArea, jStep);
		}
		updateScrollState(oRoadMap, oPos + getRTLFactor()*jStepArea.scrollLeft(), true);
	}
};


/**
 * Checks whether the step with the given Id is currently in the visible part of the scroll area.
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {string} sId the ID of the step which should be checked.
 * @private
 */
sap.ui.commons.RoadMapRenderer.isVisibleRef = function(oRoadMap, sId){
	var jStepArea = oRoadMap.$("steparea");
	var jStepAreaChildren = jStepArea.children(":visible");
	for(var i=0; i<jStepAreaChildren.length; i++){
		var jChild = jQuery(jStepAreaChildren.get(i));
		if(jChild.attr("id") == sId){
			var iPos = getPositionLeft(jStepArea, jChild);
			return iPos >= 0 && iPos < jStepArea.width();
		}
	}
	return false;
};


/**
 * Returns the Id of the first step in the visible part of the scroll area.
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @private
 */
sap.ui.commons.RoadMapRenderer.getFirstVisibleRef = function(oRoadMap){
	var jStepArea = oRoadMap.$("steparea");
	var jStepAreaChildren = jStepArea.children(":visible");
	for(var i=0; i<jStepAreaChildren.length; i++){
		var jChild = jQuery(jStepAreaChildren.get(i));
		if(getPositionLeft(jStepArea, jChild) == 0){
			return jChild;
		}
	}
	return null;
};


/**
 * Updates the label text of the given step
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Element} oStep the Step for which the label should be changed.
 * @param {string} sLabel the new label.
 * @private
 */
sap.ui.commons.RoadMapRenderer.setStepLabel = function(oStep, sLabel){
	var l = sLabel ? jQuery.sap.escapeHTML(sLabel) : "";
	oStep.$("label").html(l);
	oStep.$("expandend-label").html(l);
	
	if(!sap.ui.getCore().getConfiguration().getAccessibility()) {
		return;
	}
	
	oStep.$("box").attr("aria-label", getAriaLabel(oStep, sLabel));
	oStep.$("expandend-box").attr("aria-label", getAriaLabel(oStep, sLabel));
};


/**
 * Updates the enabled state of the given step
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {sap.ui.core.Element} oStep the Step for which the state should be changed.
 * @param {boolean} bEnabled the enabled state.
 * @private
 */
sap.ui.commons.RoadMapRenderer.setStepEnabled = function(oRoadMap, oStep, bEnabled){
	var jRef = oStep.$();
	var jRef2 = oStep.$("expandend");
	if(bEnabled){
		jRef.removeClass("sapUiRoadMapDisabled");
		jRef2.removeClass("sapUiRoadMapDisabled");
		if(sap.ui.getCore().getConfiguration().getAccessibility()){
			oStep.$("box").removeAttr("aria-disabled");
			oStep.$("expandend-box").removeAttr("aria-disabled");
		}
		return false;
	}else{
		var bSelected = oRoadMap.getSelectedStep() == oStep.getId();
		if(bSelected) {
			jRef.removeClass("sapUiRoadMapSelected");
		}
		jRef.addClass("sapUiRoadMapDisabled");
		jRef2.addClass("sapUiRoadMapDisabled");
		if(sap.ui.getCore().getConfiguration().getAccessibility()){
			var jRefBox = oStep.$("box");
			jRefBox.attr("aria-disabled", true);
			if(bSelected) {
				jRefBox.removeAttr("aria-checked");
			}
			oStep.$("expandend-box").attr("aria-disabled", true);
		}
		return bSelected;
	}
};


/**
 * Updates the visible state of the given step
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {sap.ui.core.Element} oStep the Step for which the state should be changed.
 * @param {boolean} bIsSubStep indicates whether the given step is a substep or not
 * @param {boolean} bVisible the visible state.
 * @private
 */
sap.ui.commons.RoadMapRenderer.setStepVisible = function(oRoadMap, oStep, bIsSubStep, bVisible){
	var jRef = oStep.$();
	var jRef2 = oStep.$("expandend");
	var bSelected = oRoadMap.getSelectedStep() == oStep.getId();

	var oParent = oStep.getParent();
	if(bIsSubStep){
		if(oParent.getEnabled() && oParent.getVisible() && oParent.getExpanded()){
			if(bVisible){
				jRef.removeClass("sapUiRoadMapHidden");
			}else{
				jRef.addClass("sapUiRoadMapHidden");
			}
		}
	}else{
		if(bVisible){
			jRef.removeClass("sapUiRoadMapHidden");
		}else{
			jRef.addClass("sapUiRoadMapHidden");
		}

		var aSteps = oStep.getSubSteps();
		if(aSteps.length > 0 && oStep.getExpanded()){
			if(bVisible){
				jRef2.removeClass("sapUiRoadMapHidden");
			}else{
				jRef2.addClass("sapUiRoadMapHidden");
			}

			for(var i=0; i<aSteps.length; i++){
				if(aSteps[i].getVisible()){
					var jRef3 = aSteps[i].$();
					if(oRoadMap.getSelectedStep() == aSteps[i].getId()){
						bSelected = true;
						jRef3.removeClass("sapUiRoadMapSelected");
						aSteps[i].$("box").removeAttr("aria-checked");
					}
					if(bVisible){
						jRef3.removeClass("sapUiRoadMapHidden");
					}else{
						jRef3.addClass("sapUiRoadMapHidden");
					}
				}
			}
		}
	}

	return bSelected;
};


/**
 * Updates the width of the Roadmap
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {string} sWidth the new width.
 * @private
 */
sap.ui.commons.RoadMapRenderer.setRoadMapWidth = function(oRoadMap, sWidth){
	var jRef = oRoadMap.$();
	jRef.attr("style", "width:"+(sWidth ? sWidth : "100%")+";");
};


/**
 * Scrolls according to the given direction.
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @see <code>sap.ui.commons.RoadMapRenderer.getFirstVisibleRef</code>
 *
 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
 * @param {string} sDir the scroll direction (allowed are "next", "prev", "first", "last")
 * @param {function} fEndCallBack callback function which is called in the end with a string parameter indicating the id of the new first visible step
 * @private
 */
sap.ui.commons.RoadMapRenderer.scrollToNextStep = function(oRoadMap, sDir, fEndCallBack){
	var oPos = sDir;
	if(sDir == "first" || sDir == "last") {
		oPos = getStepEndPosition(oRoadMap, sDir == "last");
	}
	updateScrollState(oRoadMap, oPos, false, fEndCallBack);
};


/**
 * Shortens the label of the given step and adds ellipses if necessary
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Element} oStep the Step for which the label should be adapted
 * @private
 */
sap.ui.commons.RoadMapRenderer.addEllipses = function(oStep){
	if(!oStep) {
		return;
	}

	var jStepLabel = oStep.$("label");
	var sOriginalText = oStep.getLabel();
	var sText = sOriginalText + "";

	var jClone = jQuery("<label class=\"sapUiRoadMapTitle\" style=\"display:none;position:absolute;overflow:visible;font-weight:bold;height:auto\">"+sText+"</label>");
	jClone.width(jStepLabel.width());
	jQuery(sap.ui.getCore().getStaticAreaRef()).append(jClone);

	var bIsShortened = false;
	while(sText.length > 0 && jClone.height() > jStepLabel.height()){
		//TODO: Do we need special RTL handling here?
		sText = sText.substr(0, sText.length - 1);
		jClone.html(jQuery.sap.escapeHTML(sText + "..."));
		bIsShortened = true;
	}

	if(bIsShortened){
		jStepLabel.html("<span>" + jQuery.sap.escapeHTML(sText) + "</span>");
		jStepLabel.attr("title", oStep.getLabel());
	}else{
		jStepLabel.attr("title", getStepTooltip(oStep));
	}

	jClone.remove();
};


/**
 * Updates the ARIA properties of the steps on the same level as the given step.
 * (Attention: This function should only be called by the Roadmap control itself).
 *
 * @param {sap.ui.core.Element} oStep the Step.
 * @private
 */
sap.ui.commons.RoadMapRenderer.updateStepAria = function(oStep){
	if(!sap.ui.getCore().getConfiguration().getAccessibility()) {
		return;
	}
	var bIsTopLevel = oStep.getParent() instanceof sap.ui.commons.RoadMap;
	var aSteps = oStep.getParent()[bIsTopLevel ? "getSteps" : "getSubSteps"]();
	for(var i=0; i<aSteps.length; i++){
		var sPosInSet = getAriaPosInSet(aSteps[i]);
		var sSetSize = getAriaSetSize(aSteps[i]);
		var jStepBox = aSteps[i].$("box");
		jStepBox.attr("aria-posinset", sPosInSet);
		jStepBox.attr("aria-setsize", sSetSize);
		if(bIsTopLevel && aSteps[i].getSubSteps().length > 0){
			jStepBox = aSteps[i].$("expandend-box");
			jStepBox.attr("aria-posinset", sPosInSet);
			jStepBox.attr("aria-setsize", sSetSize);
		}
	};
};


//********* Private *********


//Writes the delimiter HTML into the rendermanger
var renderDelimiter = function(rm, oRoadMap, bStart){
	var sType = bStart ? "Start" : "End";
	rm.write("<div");
	rm.writeAttribute("id", oRoadMap.getId() + "-" + sType);
	rm.writeAttribute("tabindex", "-1");
	var hasHiddenSteps = true; //Simply assume that there are hidden steps -> updated later (see function updateScrollState)
	rm.addClass(hasHiddenSteps ? "sapUiRoadMap" + sType + "Scroll" : "sapUiRoadMap" + sType + "Fixed");
	rm.addClass("sapUiRoadMapDelim");
	rm.addClass("sapUiRoadMapContent");
	rm.writeClasses();
	rm.write("></div>");
};


//Writes the step HTML into the rendermanger
var renderStep = function(rm, oRoadMap, oStep, aAdditionalClasses, fAddAdditionalBoxContent, sId){
	rm.write("<li");
	if(sId){ //Write the given Id if available, otherwise use writeControlData
		rm.writeAttribute("id", sId);
	}else{
		rm.writeElementData(oStep);
	}
	var sStepName = getStepName(oRoadMap, oStep);
	oStep.__stepName = sStepName;
	var sTooltip = getStepTooltip(oStep);

	rm.addClass("sapUiRoadMapContent");
	rm.addClass("sapUiRoadMapStep");
	if(!oStep.getVisible()) {
		rm.addClass("sapUiRoadMapHidden");
	}
	if(oStep.getEnabled()){
		if(oRoadMap.getSelectedStep() == oStep.getId()) {
			rm.addClass("sapUiRoadMapSelected");
		}
	}else{
		rm.addClass("sapUiRoadMapDisabled");
	}
	if(aAdditionalClasses){ //Write additional CSS classes if available
		for(var i=0; i<aAdditionalClasses.length; i++){
			rm.addClass(aAdditionalClasses[i]);
		}
	}
	rm.writeClasses();

	rm.write(">");

	renderAdditionalStyleElem(rm, sId ? sId : oStep.getId(), 1);

	rm.write("<div");
	rm.writeAttribute("id", (sId ? sId : oStep.getId()) + "-box");
	rm.writeAttribute("tabindex", "-1");
	rm.addClass("sapUiRoadMapStepBox");
	rm.writeClasses();
	rm.writeAttributeEscaped("title", sTooltip);

	writeStepAria(rm, oRoadMap, oStep, fAddAdditionalBoxContent ? true : false);

	rm.write("><span>");
	rm.write(sStepName);
	rm.write("</span>");

	//Call callback function to render additional content
	if(fAddAdditionalBoxContent) {
		fAddAdditionalBoxContent(rm, oRoadMap, oStep);
	}

	rm.write("</div>");

	rm.write("<label");
	rm.writeAttribute("id", (sId ? sId : oStep.getId()) + "-label");
	rm.addClass("sapUiRoadMapTitle");
	rm.writeAttributeEscaped("title", sTooltip);
	rm.writeClasses();
	rm.write(">");
	var sLabel = oStep.getLabel();
	if(sLabel) {
		rm.writeEscaped(sLabel);
	}
	rm.write("</label>");

	renderAdditionalStyleElem(rm, sId ? sId : oStep.getId(), 2);

	rm.write("</li>");
};


//Returns the tooltip of the given step
var getStepTooltip = function(oStep){
	var sTooltip = oStep.getTooltip_AsString();
	if(!sTooltip){
		if(sap.ui.getCore().getConfiguration().getAccessibility()){
			sTooltip = getText("RDMP_DEFAULT_STEP_TOOLTIP", [oStep.__stepName]);
		}else{
			sTooltip = "";
		}
	}
	return sTooltip;
};


//Writes the additonal style HTML into the rendermanger (see renderStep)
var renderAdditionalStyleElem = function(rm, sId, iIdx){
	rm.write("<div");
	rm.writeAttribute("id", sId + "-add" + iIdx);
	rm.addClass("sapUiRoadMapStepAdd" + iIdx);
	rm.writeClasses();
	rm.write("></div>");
};


//Writes the ARIA properties of a step
var writeStepAria = function(rm, oRoadMap, oStep, bIsExpandable){
	if(!sap.ui.getCore().getConfiguration().getAccessibility()) {
		return;
	}

	rm.writeAttribute("role", "treeitem");

	if(oStep.getEnabled()){
		rm.writeAttribute("aria-checked", oRoadMap.getSelectedStep() == oStep.getId());
	}else{
		rm.writeAttribute("aria-disabled", true);
	}
	rm.writeAttribute("aria-haspopup", bIsExpandable);
	rm.writeAttribute("aria-level", oStep.getParent() instanceof sap.ui.commons.RoadMap ? 1 : 2);
	
	rm.writeAttribute("aria-posinset", getAriaPosInSet(oStep));
	rm.writeAttribute("aria-setsize", getAriaSetSize(oStep));
	rm.writeAttributeEscaped("aria-label", getAriaLabel(oStep, oStep.getLabel()));

	if(!bIsExpandable) {
		return;
	}

	rm.writeAttribute("aria-expanded", oStep.getExpanded());
};


//Computes how the aria-label property should be set for the given step
var getAriaLabel = function(oStep, sLabel){
	var bIsExpandable = oStep.getParent() instanceof sap.ui.commons.RoadMap && oStep.getSubSteps().length > 0;
	
	var sResult = sLabel || "";
	if(oStep.getEnabled()){
		sResult = getText(bIsExpandable ? "RDMP_ARIA_EXPANDABLE_STEP" : "RDMP_ARIA_STANDARD_STEP", [sResult]);
	}
	
	return sResult; 
};


//Computes how the aria-posinset property should be set for the given step
var getAriaPosInSet = function(oStep){
	var bIsTopLevel = oStep.getParent() instanceof sap.ui.commons.RoadMap;
	var iIdx = oStep.getParent()[bIsTopLevel ? "indexOfStep" : "indexOfSubStep"](oStep);
	var iCountInvisible = 0;
	var aSteps = oStep.getParent()[bIsTopLevel ? "getSteps" : "getSubSteps"]();
	for(var i=0; i<iIdx; i++){
		if(!aSteps[i].getVisible()){
			iCountInvisible++;
		}
	}
	return iIdx + 1 - iCountInvisible;
};


//Computes how the aria-setsize property should be set for the given step
var getAriaSetSize = function(oStep){
	var bIsTopLevel = oStep.getParent() instanceof sap.ui.commons.RoadMap;
	var aSteps = oStep.getParent()[bIsTopLevel ? "getSteps" : "getSubSteps"]();
	var iCount = aSteps.length;
	for(var i=0; i<aSteps.length; i++){
		if(!aSteps[i].getVisible()){
			iCount--;
		}
	}
	return iCount;
};


//Writes the step HTML of the expandable step and its children into the rendermanger
var renderExpandableStep = function(rm, oRoadMap, oStep){
	var fCreateIcon = function(rm, oRoadMap, sId, sIcon, sAdditonalClass){
		rm.write("<div");
		rm.writeAttribute("id", sId + "-ico");
		rm.addClass("sapUiRoadMapStepIco");
		if(sAdditonalClass) {
			rm.addClass(sAdditonalClass);
		}
		rm.writeClasses();
		rm.write("></div>");
	};

	var bIsExpanded = oStep.getExpanded();

	//Render the start step with an additional icon
	renderStep(rm, oRoadMap, oStep, bIsExpanded ? ["sapUiRoadMapExpanded"] : null, function(rm, oRoadMap, oStep){
		fCreateIcon(rm, oRoadMap, oStep.getId(), bIsExpanded ? "roundtripstart.gif" : "roundtrip.gif");
	});

	//Render the sub steps
	var aSteps = oStep.getSubSteps();
	for(var i=0; i<aSteps.length; i++){
		var aClasses = ["sapUiRoadMapSubStep"];
		if(!bIsExpanded && aSteps[i].getVisible()) {
			aClasses.push("sapUiRoadMapHidden");
		}
		renderStep(rm, oRoadMap, aSteps[i], aClasses);
	}

	//Render the end step with an additional icon
	aClasses = ["sapUiRoadMapExpanded", "sapUiRoadMapStepEnd"];
	if(!bIsExpanded) {
		aClasses.push("sapUiRoadMapHidden");
	}
	renderStep(rm, oRoadMap, oStep, aClasses, function(rm, oRoadMap, oStep){
		fCreateIcon(rm, oRoadMap, oStep.getId()+"-expandend", "roundtripend.gif");
	}, oStep.getId()+"-expandend");
};


//Returns the name of the step according to its index in the aggregation (like "1", "a", "aa")
var getStepName = function(oRoadMap, oStep){
	var oParent = oStep.getParent();
	if(oParent === oRoadMap) {
		return oParent.indexOfStep(oStep) + 1;
	}

	var iIdx = oParent.indexOfSubStep(oStep);

	if(iIdx < 26) {
		return String.fromCharCode(97+iIdx);
	} // Single character

	//Double characters Substeps name are formed of 2 letters (e.g. "aa"). -> so overall 702 substeps possible
	var firstCharIdx = Math.floor(iIdx/26) - 1;
	var secondCharIdx = iIdx % 26;
	return String.fromCharCode(97+firstCharIdx, 97+secondCharIdx);
};


//Refreshs teh delimiters according to the current scroll state
var updateDelimiters = function(oRoadMap){
	var iRTLFactor = getRTLFactor();

	var jStepArea = oRoadMap.$("steparea");

	var iScrollLeft = getScrollLeft(jStepArea);

	var jStartDelim = oRoadMap.$("Start");
	jStartDelim.removeClass("sapUiRoadMapStartScroll").removeClass("sapUiRoadMapStartFixed");
	jStartDelim.addClass(iRTLFactor*iScrollLeft >= oRoadMap.iStepWidth ? "sapUiRoadMapStartScroll" : "sapUiRoadMapStartFixed");

	var jEndDelim = oRoadMap.$("End");
	jEndDelim.removeClass("sapUiRoadMapEndScroll").removeClass("sapUiRoadMapEndFixed");
	var bEndReached = jStepArea.get(0).scrollWidth - iRTLFactor*iScrollLeft - jStepArea.width() < oRoadMap.iStepWidth;
	jEndDelim.addClass(bEndReached ? "sapUiRoadMapEndFixed" : "sapUiRoadMapEndScroll");
};


//Returns the translatable text according to the given key and arguments
var getText = function(sKey, aArgs) {
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	if(rb) {
		return rb.getText(sKey, aArgs);
	}
	return sKey;
};


//Returns the number of steps which currently could be visible
//(Must be visible and for substeps the parent must be expanded)
var getNumberOfPotentiallyVisibleSteps = function(oRoadMap){
	var counter = 0;
	var aSteps = oRoadMap.getSteps();
	for(var i=0; i<aSteps.length; i++){
		if(aSteps[i].getVisible()){
			counter++;
			if(aSteps[i].getExpanded()){
				counter++; //End of Expanded Step
				var aSubSteps = aSteps[i].getSubSteps();
				for(var j=0; j<aSubSteps.length; j++){
					if(aSubSteps[j].getVisible()) {
						counter++;
					}
				}
			}
		}
	}
	return counter;
};


//Returns the position left attribute of the given step within the scroll area
var getPositionLeft = function(jStepArea, jStep){
	var iPos = jStep.position().left;
	if(sap.ui.getCore().getConfiguration().getRTL()){ //Recompute in RTL case
		iPos = jStepArea.width() - iPos - jStep.outerWidth();
	}
	return iPos;
};


//Returns a factor which is needed in some browsers in RTL mode to make the position and scroll calculations running:
//Scrolling in RTL is quite strange in the different browsers:
//  -Firefox: right side has scrollleft=0, scrolling is indicated with negative values
//  -IE:      right side has scrollleft=0, scrolling is indicated with positive values
//  -Safari:  left side has scrollleft=0, scrolling is indicated with positive values
var getRTLFactor = function(){
	return sap.ui.getCore().getConfiguration().getRTL() && !!!sap.ui.Device.browser.internet_explorer ? -1 : 1;
};


//Calculates the scroll left attribute (with fix for Safari in RTL mode) to make the position and scroll calculations running
//(see comment on getRTLFactor for RTL behavior)
var getScrollLeft = function(jStepArea){
	if(sap.ui.getCore().getConfiguration().getRTL() && !!sap.ui.Device.browser.webkit){
		return (-1)*(jStepArea.get(0).scrollWidth - jStepArea.scrollLeft() - jStepArea.width());
	}
	return jStepArea.scrollLeft();
};


//Calculates the position of the fisrt/last step (with fix for Safari in RTL mode) to make the position and scroll calculations running
//(see comment on getRTLFactor for RTL behavior)
var getStepEndPosition = function(oRoadMap, bLast){
	var iScrollWidth = oRoadMap.$("steparea").get(0).scrollWidth;
	if(sap.ui.getCore().getConfiguration().getRTL() && !!sap.ui.Device.browser.webkit){
		return bLast ? 0 : (-1)*iScrollWidth;
	}
	return bLast ? iScrollWidth : 0;
};


//Scrolls to the given position
var updateScrollState = function(oRoadMap, iNewPos, bSkipAnim, fEndCallBack){
	var jStepArea = oRoadMap.$("steparea");
	jStepArea.stop(false, true);

	if(iNewPos == "next"){
		iNewPos = jStepArea.scrollLeft() + oRoadMap.iStepWidth*getRTLFactor();
	}else if(iNewPos == "prev"){
		iNewPos = jStepArea.scrollLeft() - oRoadMap.iStepWidth*getRTLFactor();
	}else if(iNewPos == "keep"){
		iNewPos = jStepArea.scrollLeft();
	}else{
		iNewPos = iNewPos*getRTLFactor();
	}

	var fDoAfterScroll = function(){
		updateDelimiters(oRoadMap);

		if(fEndCallBack){
			var jFirstVisibleRef = sap.ui.commons.RoadMapRenderer.getFirstVisibleRef(oRoadMap);
			fEndCallBack(jFirstVisibleRef.attr("id"));
		}
	};

	if(!jQuery.fx.off && !bSkipAnim){
		jStepArea.animate({scrollLeft: iNewPos}, "fast", fDoAfterScroll);
	}else{
		jStepArea.scrollLeft(iNewPos);
		fDoAfterScroll();
	}
};


}());
}; // end of sap/ui/commons/RoadMapRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SearchFieldRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.SearchField
jQuery.sap.declare("sap.ui.commons.SearchFieldRenderer");

/**
 * @class SearchField renderer.
 * @static
 */
sap.ui.commons.SearchFieldRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.SearchFieldRenderer.render = function(oRenderManager, oControl){
    var rm = oRenderManager;

	if(!oControl.getVisible()){
		return;
	}

    rm.write("<div");
    rm.writeControlData(oControl);
    rm.addClass("sapUiSearchField");
    if(!oControl.getEditable() || !oControl.getEnabled()){
		rm.addClass("sapUiSearchFieldDsbl");
    }
    if(!oControl.hasListExpander()){
		rm.addClass("sapUiSearchFieldNoExp");
    }
    if(oControl.getEnableClear()){
		rm.addClass("sapUiSearchFieldClear");
    }
    if(oControl.getWidth()) {
		rm.addStyle("width", oControl.getWidth());
    }
    if(oControl.getValue()) {
    	rm.addClass("sapUiSearchFieldVal");
    }
    rm.writeClasses();
    rm.writeStyles();

	/*rm.writeAccessibilityState(null, {
		//role: "search",
		owns: oControl._ctrl.getId() + (oControl.getShowExternalButton() ? (" "+oControl._btn.getId()) : "")
	});*///CSN 1076183 2013: ARIA owns not required and leads to unexpected screen reader anouncements
    	
    rm.write(">");
    rm.renderControl(oControl._ctrl);
    if(oControl.getShowExternalButton()){
		rm.renderControl(oControl._btn);
    }
    rm.write("</div>");
};






}; // end of sap/ui/commons/SearchFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SegmentedButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.SegmentedButtonRenderer");

/**
 * @class SegmentedButton renderer.
 * @static
 */
sap.ui.commons.SegmentedButtonRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.SegmentedButtonRenderer.render = function(oRenderManager, oControl){
    // convenience variable
	var rm = oRenderManager,
		rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons"),
		// ResourceBundle always returns the key if the text is not found
		sText = rb.getText("SEGMENTEDBUTTON_ARIA_SELECT");
	if (!oControl.getVisible()) {
		return;
	}

	// write the HTML into the render manager  
    rm.write("<span");
    rm.writeControlData(oControl);
    rm.addClass("sapUiSegmentedButton");
    rm.writeClasses();
	rm.write(">"); // SPAN element
    rm.write('<span id="'+oControl.getId()+'-radiogroup"');
    // ARIA
	rm.writeAccessibilityState(oControl, {
		role: "radiogroup",
		disabled: !oControl.getEnabled()
	});
	rm.write(">"); // SPAN element
	this.renderButtons(rm,oControl);
    rm.write("</span>");
	rm.write('<span id="'+oControl.getId()+'-label" style="visibility: hidden; display: none;">');
	rm.writeEscaped(sText);
	rm.write('</span>');
    rm.write("</span>");
};

sap.ui.commons.SegmentedButtonRenderer.renderButtons = function(oRenderManager, oControl) {
	// convenience variable
	var rm = oRenderManager,
		aButtons = oControl.getButtons();
    jQuery.each(aButtons, function(i,oButton) {
    	rm.renderControl(oButton);
    });
};
}; // end of sap/ui/commons/SegmentedButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SliderRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Slider
jQuery.sap.declare("sap.ui.commons.SliderRenderer");

/**
 * @class Slider renderer.
 * @static
 */
sap.ui.commons.SliderRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered.
 */
sap.ui.commons.SliderRenderer.render = function(oRenderManager, oSlider){
	// Convenience variable
	var rm = oRenderManager;
	var oR  = sap.ui.commons.SliderRenderer;

	// Return immediately if control is invisible
	if (!oSlider.getVisible()) {
		return;
	}

	// Write the HTML into the render manager
	rm.write('<DIV');
	rm.writeControlData(oSlider);
	rm.addClass('sapUiSli');
	this.controlAdditionalCode(rm,oSlider);
	if(oSlider.getTooltip_AsString()) {
		rm.writeAttributeEscaped('title', oSlider.getTooltip_AsString());
	}

	if (!oSlider.getVertical() && oSlider.getWidth()) {
		rm.writeAttribute('style', 'width:' + oSlider.getWidth() + ';');
	} else {
		rm.writeAttribute('style', 'height:' + oSlider.getHeight() + ';');
	}

	if (!oSlider.getEnabled()) {
		rm.addClass('sapUiSliDsbl');
	}else{
		if (!oSlider.getEditable()) {
			rm.addClass('sapUiSliRo');
		}else {
			rm.addClass('sapUiSliStd');
		}
	}
	if (oSlider.getVertical()) {
		rm.addClass('sapUiSliVert');
	} else {
		rm.addClass('sapUiSliHori');
	}

	rm.writeClasses();

	// invisible span with tooltip as text for aria on grip
	if(oSlider.getTooltip_AsString()) {
		rm.write('><SPAN id="' + oSlider.getId() + '-Descr" style="visibility: hidden; display: none;">');
		rm.writeEscaped(oSlider.getTooltip_AsString());
		rm.write('</SPAN');
	}

	// Write slide bar
	rm.write('><DIV');
	rm.writeAttribute('id', oSlider.getId() + '-right');
	rm.write('class="sapUiSliR" > <DIV');

	rm.writeAttribute('id', oSlider.getId() + '-left');
	rm.write('class="sapUiSliL" > <DIV');

	rm.writeAttribute('id', oSlider.getId() + '-bar');
	rm.write('class="sapUiSliBar" >');

	var useTextLabels = false;
	if (oSlider.getLabels() && oSlider.getLabels().length > 0) {
		useTextLabels = true;
	}

	if(oSlider.getTotalUnits() > 0 || useTextLabels){

		var iTotalUnits = oSlider.getTotalUnits();
		if (useTextLabels) {
			iTotalUnits = oSlider.getLabels().length -1;
		}

		var fStepSize = (oSlider.getMax() - oSlider.getMin()) / iTotalUnits;

		// Add ticks
		for (var i = 0; i <= iTotalUnits; i++){
			rm.write('<DIV');
			rm.writeAttribute('id', oSlider.getId() + '-tick' + i);
			rm.write('class="sapUiSliTick" ');
			rm.write('></DIV>'); // tick

			if( oSlider.getStepLabels() ){
				// Texts
				rm.write('<DIV');
				rm.writeAttribute('id', oSlider.getId() + '-text' + i);
				switch (i){
				case ( 0 ):
					rm.write('class="sapUiSliText sapUiSliTextLeft" >');
					break;
				case (iTotalUnits):
					rm.write('class="sapUiSliText sapUiSliTextRight" >');
					break;
				default:
					rm.write('class="sapUiSliText" >');
					break;
				}
				if (useTextLabels) {
					rm.write(oSlider.getLabels()[i]);
				} else {
					rm.write(oSlider.getMin() + i * fStepSize);
				}
				rm.write('</DIV>'); // Text
			}
		}
	}

	// Highlight bar
	rm.write('<DIV');
	rm.writeAttribute('id', oSlider.getId() + '-hili');
	rm.write('class="sapUiSliHiLi"></DIV>');

	this.renderGrip(rm, oSlider);

	rm.write('</DIV></DIV></DIV></DIV>');
};

/**
 * Renders the Grip for the slider control, using the provided {@link sap.ui.fw.RenderManager}.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered.
 */
sap.ui.commons.SliderRenderer.renderGrip = function(rm, oSlider){

	rm.write('<DIV');

	// Icon for grip
	rm.writeAttribute('id', oSlider.getId() + '-grip');
	if (oSlider.getEnabled()) {
		rm.writeAttribute('tabIndex', '0');
	}else{
		rm.writeAttribute('tabIndex', '-1');
	}
	rm.writeAttribute('class', 'sapUiSliGrip');
	rm.writeAttribute('title', oSlider.getValue());

	// ARIA
	rm.writeAccessibilityState(oSlider, {
		role: 'slider',
		orientation: 'horizontal',
		valuemin: oSlider.getMin(),
		valuemax: oSlider.getMax(),
		live: 'assertive',
		disabled: !oSlider.getEditable() || !oSlider.getEnabled(),
		describedby: oSlider.getTooltip_AsString() ? (oSlider.getId()+'-Descr ' + oSlider.getAriaDescribedBy().join(" ")) : undefined
	});

	if (oSlider.getVertical()) {
		rm.write('>&#9668;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)
	} else {
		rm.write('>&#9650;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)
	}
};

/**
 * Adds extra code to the control (i.e. in subclasses), using the provided {@link sap.ui.fw.RenderManager}.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered.
 */
sap.ui.commons.SliderRenderer.controlAdditionalCode = function(rm, oSlider){
};
}; // end of sap/ui/commons/SliderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SplitterRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Splitter
jQuery.sap.declare("sap.ui.commons.SplitterRenderer");

/**
 * @class
 * @static
 */
sap.ui.commons.SplitterRenderer = {};

/**
 * Renders the HTML for the Splitter, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered
 */
sap.ui.commons.SplitterRenderer.render = function(oRenderManager, oControl) {

	// return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	var rm = oRenderManager;
	var orientation = oControl.getSplitterOrientation();
	var position = oControl.getSplitterPosition();
	var dimensionSecPane;
	var oControls;
	var iLength;
	var i;
	/*
	 * dimension (height or width) of the first pane is equal to the position of the splitter bar
	 * dimension of the second pane is the remaining available place after placing the first place
	 * 100 - position
	 * the splitter bar width/height is not taken into account since it has a fix width/height of 4px,
	 * it will be calculated after rendering
	 * it will be converted into percentage once we had the width/height of the splitter available area in px
	 */
	position = position.substring(0, position.length - 1);
	dimensionSecPane = 100 - position;

	/* Opening Splitter Wrapper DIV*/
	rm.write("<div ");
	rm.writeControlData(oControl);
	rm.addClass("sapUiSplitter");

	rm.addStyle("width",  oControl.getWidth());
	rm.addStyle("height",  oControl.getHeight());
	rm.writeStyles();
	rm.writeClasses();
	rm.write(">");

	/*rendering the first pane*/
	rm.write("<div id=\"" + oControl.getId() + "_firstPane\" ");
	if (oControl.getShowScrollBars()){
		rm.addStyle("overflow", "auto");
	} else{
		rm.addStyle("overflow", "hidden");
	}
	if (orientation == sap.ui.core.Orientation.Vertical) {
		rm.addClass("sapUiVSplitterFirstPane");
		rm.addStyle("width", position + "%");
	} else if (orientation == sap.ui.core.Orientation.Horizontal) {
		rm.addClass("sapUiHSplitterFirstPane");
		rm.addStyle("height", position + "%");
	}

	rm.writeClasses();
	rm.writeStyles();
	rm.write(">");

	/*First content (child controls)*/
	oControls = oControl.getFirstPaneContent();
	iLength = oControls.length;
	for (i = 0; i < iLength; i++) {
		rm.renderControl(oControls[i]);
	}
	rm.write("</div>");

	/*rendering the splitter bar*/
	rm.write("<div  id=\"" + oControl.getId() + "_SB\" tabIndex=\"0\" role=\"separator\" title=\"" + oControl.getText("SPLITTER_MOVE") + "\""); 
	if (orientation == sap.ui.core.Orientation.Vertical) {
		if (oControl.getSplitterBarVisible()){
			rm.addClass("sapUiVerticalSplitterBar");
		} else {
			rm.addClass("sapUiVerticalSplitterBarHidden");
		}
		rm.addStyle("width", 0 + "%");
	} else if (orientation == sap.ui.core.Orientation.Horizontal) {
		if (oControl.getSplitterBarVisible()){
			rm.addClass("sapUiHorizontalSplitterBar");
		} else {
			rm.addClass("sapUiHorizontalSplitterBarHidden");
		}
		rm.addStyle("height", 0 + "%");
	}
	rm.writeClasses();
	rm.writeStyles();
	rm.write(">");
	rm.write("</div>");

	/*rendering the second pane*/
	rm.write("<div id=\"" + oControl.getId() + "_secondPane\" ");
	if (oControl.getShowScrollBars()){
		rm.addStyle("overflow", "auto");
	} else{
		rm.addStyle("overflow", "hidden");
	}
	if (orientation == sap.ui.core.Orientation.Vertical) {
		rm.addClass("sapUiVSplitterSecondPane");
		rm.addStyle("width", dimensionSecPane + '%');
	} else if (orientation == sap.ui.core.Orientation.Horizontal) {
		rm.addClass("sapUiHSplitterSecondPane");
		rm.addStyle("height", dimensionSecPane + '%');
	}
	rm.writeClasses();
	rm.writeStyles();
	rm.write(">");

	/*Second content (child controls)*/
	oControls = oControl.getSecondPaneContent();
	iLength = oControls.length;
	for (i = 0; i < iLength; i++) {
		rm.renderControl(oControls[i]);
	}
	rm.write("</div>");

	/* Closing the Splitter Wrapper DIV*/
	rm.write("</div>");
};
}; // end of sap/ui/commons/SplitterRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TabStripRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TabStrip
jQuery.sap.declare("sap.ui.commons.TabStripRenderer");

/**
 * @class TabStrip renderer.
 * @static
 */
sap.ui.commons.TabStripRenderer = function() {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.TabStripRenderer.render = function(oRenderManager, oControl){
	// convenience variable
	var rm = oRenderManager;
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	//outer DIV
	rm.write("<div role='presentation'");
	rm.addClass("sapUiTabStrip");
	rm.addStyle("height",oControl.getHeight());
	rm.addStyle("width",oControl.getWidth());
	rm.writeClasses();
	rm.writeStyles();
	rm.writeControlData(oControl);
	//header area
	rm.write("><div class=\"sapUiTabBar\" tabIndex=\"0\"");
	if(oControl.getTooltip_AsString()) {
		rm.writeAttributeEscaped('title', oControl.getTooltip_AsString());
	}
	// menu and list header
	rm.write("><div class=\"sapUiTabMenu\"></div><ul class=\"sapUiTabBarCnt\" role=\"tablist\">");

	var aTabs = oControl.getTabs();
	// check if selected tab exists and is visible -> otherwise select first active one
	var bWrongIndex = false;
	var iSelectedIndex = oControl.getSelectedIndex();
	if (iSelectedIndex < 0) {
		// if not tab is selected use default value
		iSelectedIndex = 0;
		oControl.setProperty( 'selectedIndex', 0, true );
	}
	var oSelectedTab = aTabs[iSelectedIndex];
	if(!oSelectedTab || !oSelectedTab.getVisible() || !oSelectedTab.getEnabled()){
		oControl._warningInvalidSelectedIndex(iSelectedIndex, oSelectedTab);
		bWrongIndex = true;
	}

	// for ARIA determine number of visible tabs
	oControl.iVisibleTabs = 0;
	for (var i=0;i<aTabs.length;i++) {
		var oTab = aTabs[i];
		if(oTab.getVisible() === false) {
			continue;
		}
		oControl.iVisibleTabs++;
	}

	var iVisibleIndex = 0;
	// tabs
	for (var i = 0; i < aTabs.length; i++) {
		var oTab = aTabs[i];
		if(oTab.getVisible() === false) {
			continue;
		}

		if(bWrongIndex && oTab.getEnabled()){
			oControl.setProperty( 'selectedIndex', i, true );
			iSelectedIndex = i;
			bWrongIndex = false;
		}

		rm.write("<li");

		if (oTab.getEnabled() == false) {
			rm.addClass("sapUiTabDsbl");
		} else if (i==iSelectedIndex) {
			rm.addClass("sapUiTabSel");
		} else {
			rm.addClass("sapUiTab");
		}

		// enable the successor tab to overlap this tab if selected
		if (i==iSelectedIndex-1) {
			rm.addClass("sapUiTabBeforeSel");
		} else if (i==iSelectedIndex+1) {
			rm.addClass("sapUiTabAfterSel");
		}

		rm.writeControlData(oTab);
		rm.writeAttribute("tabidx", i);

		//ARIA
		iVisibleIndex++;

		rm.writeAttribute("tabindex", "-1");
		rm.writeAttribute("role", "tab");

		rm.writeAccessibilityState(oTab, {selected: i==iSelectedIndex,
										  controls: oTab.getId() + "-panel",
										  disabled: !oTab.getEnabled(),
										  posinset: iVisibleIndex,
										  setsize: oControl.iVisibleTabs});
		if (oTab.getClosable()) {
			// close button text must be read
			rm.writeAccessibilityState(oTab, {describedby: oTab.getId() + "-close"});
		}

		if (iVisibleIndex == oControl.iVisibleTabs) {
			rm.addClass("sapUiTabLast"); // needed for IE8
		}
		rm.writeClasses();

		var oTitle = oTab.getTitle();
		// tooltip: if title has a tooltip use it, if not use the tooltip of the tab
		if(oTitle && oTitle.getTooltip_AsString()) {
			rm.writeAttributeEscaped('title', oTitle.getTooltip_AsString());
		} else if(oTab.getTooltip_AsString()){
			rm.writeAttributeEscaped('title', oTab.getTooltip_AsString());
		}
		rm.write(">");

		// title with icon
		if (oTitle) {
			var sIcon = oTitle.getIcon();
			if (sIcon) {
				var aClasses = [];
				var mAttributes = {};

				aClasses.push("sapUiTabIco");
				rm.writeIcon(sIcon, aClasses, mAttributes);
			}
			rm.writeEscaped(oTitle.getText());
		} else {
			jQuery.sap.log.warning("No title configured for " + oTab + ". Either set a string as 'text' property or a sap.ui.core.Title as 'title' aggregation.");
		}
		if (oTab.getClosable()) {
			// close button
			rm.write("<button id='" + oTab.getId() + "-close' type=\"button\" tabindex= \"-1\" class=\"sapUiTabClose\" title=\""+rb.getText("TAB_CLOSE_TEXT")+"\"></button>");
		}
		rm.write("</li>");
	}
	rm.write("</ul></div>");

	if (bWrongIndex) {
		// still wrong index - no tab is selected -> render empty panel area
		oControl.setProperty( 'selectedIndex', -1, true );
		iSelectedIndex = -1;
		rm.write("<div id=\"" + oControl.getId() + "-panel" + "\" role=\"tabpanel\"");
		rm.addClass("sapUiTabPanel");
		if(oControl.getHeight()){
			rm.addClass("sapUiTabPanelHeight");
		}
		rm.writeClasses();
		rm.write("></div>");
	}else {
		for (var i=0;i<aTabs.length;i++) {
			var oTab = aTabs[i];
			//do not render unselected (or invisible) tab content
			if (i!=iSelectedIndex || oTab.getVisible() === false) {
				continue;
			}

			// Improved version... now announcing the title when clicked into the tabpanel... into the full tabpanel!
			// ARIA requires ID for the Panel...
			rm.write("<div id=\"" + oTab.getId() + "-panel" + "\" role=\"tabpanel\" aria-labelledby=\"" + oTab.getId() +"\"");
			rm.addClass("sapUiTabPanel");
			if(oControl.getHeight()){
				rm.addClass("sapUiTabPanelHeight");
			}
			rm.writeClasses();
			rm.write(">");

			sap.ui.commons.TabStripRenderer.renderTabContents(rm,oTab);
			rm.write("</div>");
		}
	}
	rm.write("</div>");

	// reset invalidate flag
	oControl.invalidated = false;

};

/*moved over from former (and replaced) Panel control
 * @private
 */
sap.ui.commons.TabStripRenderer.renderTabContents = function(rm, oControl) {

	// Content
	var oControls = oControl.getContent(),
	iLength = oControls.length;
	for (var i=0;i<iLength;i++) {
		rm.renderControl(oControls[i]);
	}

};
}; // end of sap/ui/commons/TabStripRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TextFieldRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TextField
jQuery.sap.declare("sap.ui.commons.TextFieldRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * TextField Renderer
 * @class
 * @static
 * @author SAP
 * @version 1.24.2
 * @since 0.9.0
 */
sap.ui.commons.TextFieldRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.commons.TextField}
 *            oTextField The TextField control that should be rendered.
 */
sap.ui.commons.TextFieldRenderer.render = function(oRenderManager, oTextField) {

	var rm = oRenderManager,
		r  = sap.ui.commons.TextFieldRenderer;

	// Return immediately if control is invisible
	if (!oTextField.getVisible()) {
		return;
	}

	var sWidth = oTextField.getWidth();
	var tooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oTextField, oTextField.getTooltip_AsString());
	var bRenderOuter = oTextField._getRenderOuter();

// In case of Combobox, F4-help, DatePicker: Render outer element.
// The details of the outer element are rendered in the hook implemented in the corresponding control.
	if (bRenderOuter) {
		rm.write("<div");
		rm.writeControlData(oTextField);
		rm.addClass("sapUiTfBack");
		this.renderStyles(rm, oTextField);

		if(tooltip) {
			rm.writeAttributeEscaped('title', tooltip);
		}

		var sSpanStyle;
		if(sWidth && sWidth != '') {
			sSpanStyle= 'width: '+ sWidth+';';
		}

		if(this.renderOuterAttributes){
			this.renderOuterAttributes(rm, oTextField);
		}

		if (sSpanStyle) {
			rm.writeAttribute('style', sSpanStyle);
		}
		rm.writeStyles();
		rm.writeClasses();
		rm.write(">");

		// Outer hook
		if (this.renderOuterContentBefore) {
			this.renderOuterContentBefore(rm, oTextField);
		}
	}

// Inner tag / pure TextField
	if (this.getInnerTagName){
		rm.write('<'+this.getInnerTagName());
	}else{
		rm.write("<input");
	}
	rm.addClass("sapUiTf");

	if (!bRenderOuter) {
		// Stand-alone TextField
		rm.writeControlData(oTextField);
		rm.addClass("sapUiTfBack");
		this.renderStyles(rm, oTextField);

		if(sWidth && sWidth != '') {
			rm.addStyle("width", sWidth);
		}
	}else{
		rm.writeAttribute('id', oTextField.getId() + '-input');
		rm.addClass("sapUiTfInner");
		rm.addStyle("width", '100%');
	}

	if(tooltip) {
		// render title always on INPUT tag (even it's in outer DIV too)
		// because screenreader ignores it on outer DIV 
		rm.writeAttributeEscaped('title', tooltip);
	}

	if (oTextField.getName()) {
		rm.writeAttributeEscaped('name', oTextField.getName());
	}

	if(!oTextField.getEditable()){
		rm.writeAttribute('readonly', 'readonly');
	}
	if(this.renderTextFieldEnabled){
		this.renderTextFieldEnabled(rm, oTextField);
	}else if(!oTextField.getEnabled()){
		rm.writeAttribute('disabled', 'disabled');
		rm.writeAttribute('tabindex', '-1');
	}else if(!oTextField.getEditable()){
		rm.writeAttribute('tabindex', '0');
	}else{
		rm.writeAttribute('tabindex', '0');
	}

	// Appearance
	var sTextDir = oTextField.getTextDirection();
	if (sTextDir) {
		rm.addStyle("direction", sTextDir.toLowerCase());
	}

	var oTextAlign = oTextField.getTextAlign();
	if(oTextAlign) {
		rm.addStyle("text-align", r.getTextAlign(oTextAlign, sTextDir));
	}

	switch (oTextField.getImeMode()) {
	case sap.ui.core.ImeMode.Inactive:
		rm.addStyle('ime-mode','inactive');
		break;
	case sap.ui.core.ImeMode.Active:
		rm.addStyle('ime-mode','active');
		break;
	case sap.ui.core.ImeMode.Disabled:
		rm.addStyle('ime-mode','disabled');
		break;
	}

	if(oTextField.getDesign() == sap.ui.core.Design.Monospace){
		rm.addClass('sapUiTfMono');
	}

	if (oTextField.getMaxLength()) {
		rm.writeAttribute("maxLength", oTextField.getMaxLength());
	}

	// Add additional attributes, styles and so on (TextArea)
	if (this.renderInnerAttributes) {
		this.renderInnerAttributes(rm, oTextField);
	}

	// ARIA
	if(this.renderARIAInfo){
		this.renderARIAInfo(rm, oTextField);
	}

	var sPlaceholder = oTextField.getPlaceholder();
	if (sPlaceholder) {
		if (this.convertPlaceholder) {
			sPlaceholder = this.convertPlaceholder(oTextField);
		}
		if (sap.ui.Device.support.input.placeholder) {
			rm.writeAttributeEscaped('placeholder', sPlaceholder);
		}
	}

	rm.writeStyles();
	rm.writeClasses();

	if (this.getInnerTagName){
		rm.write(">");
	}else{
		rm.write(" value=\"");
		if (!sap.ui.Device.support.input.placeholder && sPlaceholder && !oTextField.getValue()) {
			rm.writeEscaped(sPlaceholder);
		} else {
			rm.writeEscaped(oTextField.getValue());
		}
		rm.write("\"");
		rm.write("/>");
	}

	if (this.getInnerTagName){
		// Inner hook
		if (this.renderInnerContent) {
			this.renderInnerContent(rm, oTextField);
		}

		rm.write('</'+this.getInnerTagName()+'>');
	}

	if (bRenderOuter) {
		// Outer hook
		if (this.renderOuterContent) {
			this.renderOuterContent(rm, oTextField);
		}

		rm.write("</div>");
	}

};

sap.ui.commons.TextFieldRenderer.renderStyles = function(rm, oTextField) {

	rm.addClass('sapUiTfBrd');

	if(oTextField.getEnabled()){
		if(!oTextField.getEditable()){
			rm.addClass("sapUiTfRo");
		}else{
			rm.addClass("sapUiTfStd");
		}
	}else{
		rm.addClass("sapUiTfDsbl");
	}

	switch (oTextField.getValueState()){
	case (sap.ui.core.ValueState.Error) :
		rm.addClass('sapUiTfErr');
	break;
	case (sap.ui.core.ValueState.Success) :
		rm.addClass('sapUiTfSucc');
	break;
	case (sap.ui.core.ValueState.Warning) :
		rm.addClass('sapUiTfWarn');
	break;
	}

	if(oTextField.getRequired()){
		rm.addClass('sapUiTfReq');
	}

	if (oTextField.getPlaceholder() && !sap.ui.Device.support.input.placeholder) {
		rm.addClass('sapUiTfPlace');
	}

};

sap.ui.commons.TextFieldRenderer.onfocus = function(oTextField) {
	var oTfRef = oTextField.$();
	oTfRef.addClass("sapUiTfFoc");

	if (!sap.ui.Device.support.input.placeholder && !oTextField.getValue() && oTextField.getPlaceholder()) {
		if(oTextField._getRenderOuter()){
			var oTfRefInput = oTextField.$("input");
		}else{
			var oTfRefInput = oTfRef;
		}

		oTfRef.removeClass("sapUiTfPlace");
		oTfRefInput.val("");
	}
};

sap.ui.commons.TextFieldRenderer.onblur = function(oTextField) {
	var oTfRef = oTextField.$();
	oTfRef.removeClass("sapUiTfFoc");

	var sPlaceholder = oTextField.getPlaceholder();
	if (!sap.ui.Device.support.input.placeholder) {
		if(oTextField._getRenderOuter()){
			var oTfRefInput = oTextField.$("input");
		}else{
			var oTfRefInput = oTfRef;
		}

		if (!oTfRefInput.val() && sPlaceholder) {
			oTfRef.addClass("sapUiTfPlace");
			if (this.convertPlaceholder) {
				sPlaceholder = this.convertPlaceholder(oTextField);
			}
			oTfRefInput.val(sPlaceholder);
		}
	}
};

sap.ui.commons.TextFieldRenderer.setValueState = function(oTextField, oldValueState, newValueState) {
	var oTfRef = oTextField.$();
	var bRenderOuter = oTextField._getRenderOuter();

	if(bRenderOuter){
	// aria attribute must be on inner tag
		var oTfRefInput = oTextField.$("input");
	}else{
		var oTfRefInput = oTfRef;
	}

	// Remove old value state
	switch (oldValueState){
	case (sap.ui.core.ValueState.Error) :
		oTfRef.removeClass('sapUiTfErr');
		oTfRefInput.removeAttr('aria-invalid');
		break;
	case (sap.ui.core.ValueState.Success) :
		oTfRef.removeClass('sapUiTfSucc');
		break;
	case (sap.ui.core.ValueState.Warning) :
		oTfRef.removeClass('sapUiTfWarn');
		break;
	}

	// Set new value state
	switch (newValueState){
	case (sap.ui.core.ValueState.Error) :
		oTfRef.addClass('sapUiTfErr');
		oTfRefInput.attr('aria-invalid',true);
		break;
	case (sap.ui.core.ValueState.Success) :
		oTfRef.addClass('sapUiTfSucc');
		break;
	case (sap.ui.core.ValueState.Warning) :
		oTfRef.addClass('sapUiTfWarn');
		break;
	}

	var tooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oTextField, oTextField.getTooltip_AsString());
	if (tooltip) {
		oTfRef.attr('title', tooltip);
		if (bRenderOuter) {
			oTextField.$("input").attr('title', tooltip);
		}
	}else{
		oTfRef.removeAttr('title');
		if (bRenderOuter) {
			oTextField.$("input").removeAttr('title');
		}
	}

};

sap.ui.commons.TextFieldRenderer.setEditable = function(oTextField, bEditable) {

	if(!oTextField.getEnabled()){
		// if disabled -> nothing to do
		return;
	}

	var oTfRef = oTextField.$();

	if(oTextField._getRenderOuter()){
	// Readonly attribute must be on inner tag
		var oTfRefInput = oTextField.$("input");
	}else{
		var oTfRefInput = oTfRef;
	}


	if (bEditable) {
		oTfRef.removeClass('sapUiTfRo').addClass('sapUiTfStd');
		oTfRefInput.removeAttr('readonly');
	} else {
		oTfRef.removeClass('sapUiTfStd').addClass('sapUiTfRo');
		oTfRefInput.attr('readonly', 'readonly');
	}

	oTfRefInput.attr('aria-readonly', !bEditable);
};

sap.ui.commons.TextFieldRenderer.setEnabled = function(oTextField, bEnabled) {
	var oTfRef = oTextField.$();

	if(oTextField._getRenderOuter()){
	// Disabled attribute must be on inner tag
		var oTfRefInput = oTextField.$("input");
	}else{
		var oTfRefInput = oTfRef;
	}

	if (bEnabled) {
		if (oTextField.getEditable()) {
			oTfRef.removeClass('sapUiTfDsbl').addClass('sapUiTfStd').removeAttr('aria-disabled');
			oTfRefInput.removeAttr('disabled').removeAttr('aria-disabled').attr( 'tabindex', '0');
		} else {
			oTfRef.removeClass('sapUiTfDsbl').addClass('sapUiTfRo').removeAttr('aria-disabled');
			oTfRefInput.removeAttr('disabled').removeAttr('aria-disabled').attr( 'tabindex', '0').attr( 'readonly', 'readonly');
		}
	}else{
		if (oTextField.getEditable()) {
			oTfRef.removeClass('sapUiTfStd').addClass('sapUiTfDsbl').attr('aria-disabled', 'true');
			oTfRefInput.attr( 'disabled', 'disabled').attr('aria-disabled', 'true').attr( 'tabindex', '-1');
		} else {
			oTfRef.removeClass('sapUiTfRo').addClass('sapUiTfDsbl').attr('aria-disabled', 'true');
			oTfRefInput.removeAttr('readonly').attr( 'disabled', 'disabled').attr('aria-disabled', 'true').attr( 'tabindex', '-1');
		}
	}

};

sap.ui.commons.TextFieldRenderer.removeValidVisualization = function(oTextField) {
	var oTfRef = oTextField.$();
	if(oTfRef) {
		oTfRef.removeClass("sapUiTfSucc");
	}
	else {
		jQuery.sap.delayedCall(1000, sap.ui.commons.TextFieldRenderer, "removeValidVisualization", [oTextField]);
	}
};

sap.ui.commons.TextFieldRenderer.setDesign = function(oTextField, sDesign) {

	oTextField.$().toggleClass('sapUiTfMono', (sDesign == sap.ui.core.Design.Monospace));
};

sap.ui.commons.TextFieldRenderer.setRequired = function(oTextField, bRequired) {

	if(oTextField._getRenderOuter()){
	// aria attribute must be on inner tag
		var oTfRefInput = oTextField.$("input");
	}else{
		var oTfRefInput = oTextField.$();
	}

	oTextField.$().toggleClass('sapUiTfReq', bRequired);
	if (bRequired) {
		oTfRefInput.attr("aria-required", true);
	} else {
		oTfRefInput.removeAttr("aria-required");
	}

};

sap.ui.commons.TextFieldRenderer.renderARIAInfo = function(rm, oTextField) {

	var mProps= {
		role: oTextField.getAccessibleRole().toLowerCase(),
		multiline: false,
		autocomplete: 'none'};

	if (oTextField.getValueState() == sap.ui.core.ValueState.Error) {
		mProps["invalid"] = true;
	}

	rm.writeAccessibilityState(oTextField, mProps);

};

/**
 * Dummy inheritance of static methods/functions.
 * @see sap.ui.core.Renderer.getTextAlign
 * @private
 */
sap.ui.commons.TextFieldRenderer.getTextAlign = sap.ui.core.Renderer.getTextAlign;

}; // end of sap/ui/commons/TextFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TextViewRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TextView
jQuery.sap.declare("sap.ui.commons.TextViewRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class TextView renderer.
 * @author SAP SE
 * @static
 */
sap.ui.commons.TextViewRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oTextView An object representation of the control that should be rendered.
 */
sap.ui.commons.TextViewRenderer.render = function(oRenderManager, oTextView) {

	var rm = oRenderManager;
	var r = sap.ui.commons.TextViewRenderer;

	// return immediately if control is invisible
	if (!oTextView.getVisible()) {
		return;
	}

	// Get parameters
	var enabled = oTextView.getEnabled() === true,
		oDesign = oTextView.getDesign(),
		tabIndex = 0;

	// Enable/disable
	if(!enabled) {
		tabIndex = -1;
		rm.addClass("sapUiTvDsbl");
		oTextView.allowTextSelection(false);
	}
	// Show error/warning states if they are enabled
	else {
		// error/warning state
		switch (oTextView.getSemanticColor()){
		case (sap.ui.commons.TextViewColor.Negative) :
			rm.addClass('sapUiTvErr');
			break;
		case (sap.ui.commons.TextViewColor.Positive) :
			rm.addClass('sapUiTvSucc');
			break;
		case (sap.ui.commons.TextViewColor.Critical) :
			rm.addClass('sapUiTvWarn');
			break;
		}
	}

	// Styles
	var TextViewDesign = sap.ui.commons.TextViewDesign;
	if (oDesign != TextViewDesign.Standard) {
		if (oDesign === TextViewDesign.Bold) {
			rm.addClass("sapUiTvEmph");
		} else if (oDesign === TextViewDesign.H1) {
			rm.addClass("sapUiTvH1");
		} else if (oDesign === TextViewDesign.H2) {
			rm.addClass("sapUiTvH2");
		} else if (oDesign === TextViewDesign.H3) {
			rm.addClass("sapUiTvH3");
		} else if (oDesign === TextViewDesign.H4) {
			rm.addClass("sapUiTvH4");
		} else if (oDesign === TextViewDesign.H5) {
			rm.addClass("sapUiTvH5");
		} else if (oDesign === TextViewDesign.H6) {
			rm.addClass("sapUiTvH6");
		} else if (oDesign === TextViewDesign.Italic) {
			rm.addClass("sapUiTvItalic");
		} else if (oDesign === TextViewDesign.Small) {
			rm.addClass("sapUiTvSmall");
		} else if (oDesign === TextViewDesign.Monospace) {
			rm.addClass("sapUiTvMono");
		} else if (oDesign === TextViewDesign.Underline) {
			rm.addClass("sapUiTvULine");
		}
	}

	if(!oTextView.getWrapping()){
		rm.addClass("sapUiTvWrap");
	}

	if (oTextView.getWidth() && oTextView.getWidth() != '') {
		rm.addStyle("width", oTextView.getWidth());
	}

	rm.write("<span");
	rm.writeControlData(oTextView);

	rm.addClass("sapUiTv");

	if (oTextView.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oTextView.getTooltip_AsString());
	}else if (oTextView.getText()) {
		rm.writeAttributeEscaped("title", oTextView.getText());
	}

	// Appearance
	var sTextDir = oTextView.getTextDirection();
	if (sTextDir) {
		rm.addStyle("direction", sTextDir.toLowerCase());
	}

	var oTextAlign = oTextView.getTextAlign();
	if(oTextAlign) {
		// use class because it's easier to overwrite
		var sAlign = r.getTextAlign(oTextAlign, sTextDir);
		sAlign = sAlign.charAt(0).toUpperCase() + sAlign.substring(1);
		rm.addClass("sapUiTvAlign"+sAlign);
	}

	// Make control focusable via tab
	// according to Stefan Schnabel there shall not be a tabstop   rm.writeAttribute('tabindex', tabIndex);
	rm.writeAttribute('tabindex', '-1'); //to make it focusable in ItemNavigation
	// Set Accessible Role
	rm.writeAccessibilityState(oTextView, {
		role: oTextView.getAccessibleRole().toLowerCase(),
		invalid: oTextView.getSemanticColor() == sap.ui.commons.TextViewColor.Negative,
		disabled: !oTextView.getEnabled()
	});

	rm.writeClasses();
	rm.writeStyles();
	rm.write(">");
	rm.writeEscaped(oTextView.getText(), true);
	rm.write("</span>");

};

/**
 * Dummy inheritance of static methods/functions.
 * @see sap.ui.core.Renderer.getTextAlign
 * @private
 */
sap.ui.commons.TextViewRenderer.getTextAlign = sap.ui.core.Renderer.getTextAlign;
}; // end of sap/ui/commons/TextViewRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ToggleButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Togglebutton
jQuery.sap.declare("sap.ui.commons.ToggleButtonRenderer");

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class ToggleButton renderer.
 * @author D040134
 * @static
 */

sap.ui.commons.ToggleButtonRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.ButtonRenderer);

/**
 * Hint: "renderButtonAttributes" is a reserved/hard-coded Button extending function!
 *       It is used to allow extensions to display content after the actual button content.
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager currently rendering this control
 * @param {sap.ui.commons.ToggleButton}
 *            oToggleButton the ToggleButton that should be rendered
 * @private
 */
sap.ui.commons.ToggleButtonRenderer.renderButtonAttributes = function(rm, oToggleButton) {
	rm.addClass("sapUiToggleBtn");
	if (oToggleButton.getPressed()){
		rm.addClass("sapUiToggleBtnPressed");
		rm.writeAttribute('aria-pressed', true);
	} else {
		rm.writeAttribute('aria-pressed', false);
	}
};


/**
 * Function called by ToggleButton control to enable Pressed state.
 */
sap.ui.commons.ToggleButtonRenderer.onactivePressed = function(oToggleButton) {
	oToggleButton.$().addClass("sapUiToggleBtnPressed").attr('aria-pressed', true);
};

/**
 * Function called by button control to disable Pressed state.
 */
sap.ui.commons.ToggleButtonRenderer.ondeactivePressed = function(oToggleButton) {
	oToggleButton.$().removeClass("sapUiToggleBtnPressed").attr('aria-pressed', false);
};

/**
 * Function called by button control to update image based on state.
 */
sap.ui.commons.ToggleButtonRenderer.updateImage = function(oToggleButton) {
	oToggleButton.$("img").attr('src',this._getIconForState(oToggleButton, "base"));
};

/**
 * Returns the icon URI for the given button state
 * @private
 */
sap.ui.commons.ToggleButtonRenderer._getIconForState = function(oButton, sState) {
	switch(sState){
		case "mouseout":
		case "focus":
		case "blur":
		case "base":
			return oButton.getPressed() && oButton.getIconSelected() ? oButton.getIconSelected() : oButton.getIcon();
		case "active":
			var sIcon = oButton.getIconSelected();
			return sIcon ? sIcon : oButton.getIcon();
		case "mouseover":
		case "deactive":
			var sIcon = oButton.getIconHovered();
			return sIcon ? sIcon : (oButton.getPressed() && oButton.getIconSelected() ? oButton.getIconSelected() : oButton.getIcon());
	}
	return oButton.getIcon();
};

}; // end of sap/ui/commons/ToggleButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ToolbarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Toolbar
jQuery.sap.declare("sap.ui.commons.ToolbarRenderer");

/**
 * @class
 *
 * @static
 */
sap.ui.commons.ToolbarRenderer = {
};

/**
 * Renders the HTML for the given toolbar using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.commons.Toolbar} oToolbar An object representation of the control that should be rendered.
 */
sap.ui.commons.ToolbarRenderer.render = function(oRenderManager, oToolbar) {
	var rm = oRenderManager;
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	jQuery.sap.assert(oToolbar instanceof sap.ui.commons.Toolbar, "ToolbarRenderer.render: oToolbar must be a toolbar");

	if (!oToolbar.getVisible()) {
		return;
	}

	rm.write("<div role='toolbar' tabindex='0'"); // Tab index required for ItemNavigation, the Toolbar is actually not tabable
	rm.writeControlData(oToolbar);
	if (oToolbar.getWidth()) {
		rm.addStyle("width", oToolbar.getWidth());
	}

	var sTooltip = oToolbar.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}

	rm.addClass("sapUiTb");
	rm.addClass("sapUiTbDesign" + oToolbar.getDesign());
	if (oToolbar.getStandalone()) {
		rm.addClass("sapUiTbStandalone");
	}

	rm.writeStyles();
	rm.writeClasses();
	rm.write(">");

	var aRightItems = oToolbar.getRightItems();
	var iRightItemsLength =  aRightItems.length;
	var bHasRightItems = iRightItemsLength > 0;

    if (bHasRightItems){
    	rm.write("<div class='sapUiTbCont sapUiTbContLeft'><div class='sapUiTbInner' >");
    } else {
    	rm.write("<div class='sapUiTbCont'><div class='sapUiTbInner'>");
    }


	// Render each item, also the hidden ones, as they might become visible when the toolbar is resized
	var aItems = oToolbar.getItems();
	var iLength = aItems.length;
	for (var i = 0; i < iLength; i++) {
		var oToolbarItem = aItems[i];
		if (oToolbarItem) {
			jQuery.sap.assert(oToolbarItem.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"), "ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");

			// Render ToolbarSeparator elements internally, dispatch rendering of real controls
			if (oToolbarItem instanceof sap.ui.commons.ToolbarSeparator) {
				sap.ui.commons.ToolbarRenderer.renderSeparator(rm, oToolbarItem);
			} else {
				rm.renderControl(oToolbarItem);
			}
		}
	}

	// Render the overflow menu button and the cover hiding it, if appropriate
	rm.write("<div id='");
	rm.write(oToolbar.getId());
	rm.write("-mn' class='sapUiTbOB' role='button' aria-haspopup='true' title='" + rb.getText("TOOLBAR_OVERFLOW") + "' tabindex='-1'></div></div></div>");

	// Render right side items if right items exist
	if (bHasRightItems){
		rm.write("<div class='sapUiTbInnerRight' >");
		for (var i = 0; i < iRightItemsLength; i++) {
			var oToolbarItem = aRightItems[i];
			if (oToolbarItem) {
				jQuery.sap.assert(oToolbarItem.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"), "ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");
				// Render ToolbarSeparator elements internally, dispatch rendering of real controls
				if (oToolbarItem instanceof sap.ui.commons.ToolbarSeparator) {
					sap.ui.commons.ToolbarRenderer.renderSeparator(rm, oToolbarItem);
				} else {
					rm.renderControl(oToolbarItem);
				}
			}
		}
		rm.write("</div>");
	}
	// Close div for the toolbar
	rm.write("</div>");

};


/**
 * Renders the given ToolbarSeparator
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager
 * @param {sap.ui.commons.ToolbarItem} oToolbarItem The ToolbarSeparator
 * @private
 */
sap.ui.commons.ToolbarRenderer.renderSeparator = function(oRm, oToolbarItem) {
	if (oToolbarItem.getDisplayVisualSeparator()) {
		oRm.write("<span ");
		oRm.writeElementData(oToolbarItem);
		if (oToolbarItem.getDesign() === sap.ui.commons.ToolbarSeparatorDesign.FullHeight) {
			oRm.write(" class='sapUiTbSeparator sapUiTbSepFullHeight' role='separator'></span>");
		} else {
			oRm.write(" class='sapUiTbSeparator' role='separator'></span>");
		}
	} else {
		oRm.write("<span ");
		oRm.writeElementData(oToolbarItem);
		oRm.write(" class='sapUiTbSpacer' role='separator'></span>");
	}
};


/**
 * Fills the overflow popup with the currently invisible toolbar items.
 *
 * @param {sap.ui.commons.Toolbar} oToolbar
 * @private
 */
sap.ui.commons.ToolbarRenderer.fillOverflowPopup = function(oToolbar) {
	var oPopupHolder = oToolbar.getDomRef("pu");
	if (!oPopupHolder) {
		oPopupHolder = sap.ui.commons.ToolbarRenderer.initOverflowPopup(oToolbar).firstChild;
	}

	// Move all invisible items from the second row of the toolbar to the popup
	var iVisibleItems = oToolbar.getVisibleItemInfo().count;
	var oToolbarCont = oToolbar.getDomRef().firstChild.firstChild;
	var iPos = 0;
	var oChild = oToolbarCont.firstChild;
	var sOverflowButtonId = oToolbar.getId() + "-mn";
	while (oChild) {
		var nextChild = oChild.nextSibling;
		if (iPos >= iVisibleItems) {
			if (oChild.id == sOverflowButtonId) { // do not move overflow button and cover
				break;
			}

			oPopupHolder.appendChild(oChild);
		}
		oChild = nextChild;
		iPos++;
	}
};


/**
 * Creates the overflow popup inside the static area, but does not fill its contents (=no items).
 *
 * @param {sap.ui.commons.Toolbar} oToolbar
 * @private
 */
sap.ui.commons.ToolbarRenderer.initOverflowPopup = function(oToolbar) {
	var oStaticArea = sap.ui.getCore().getStaticAreaRef();
	var oPopupHolder = document.createElement("div");
	oPopupHolder.className = "sapUiTbDD sapUiTbDesignFlat";
	oPopupHolder.innerHTML = "<div id='" + oToolbar.getId() + "-pu' data-sap-ui=" + oToolbar.getId() + " tabindex='0' role='menu'></div>";
	oStaticArea.appendChild(oPopupHolder);
	return oPopupHolder;
};


/**
 * Removes the toolbar items from the overflow popup and puts them back into the toolbar.
 *
 * @param {sap.ui.commons.Toolbar} oToolbar
 * @private
 */
sap.ui.commons.ToolbarRenderer.emptyOverflowPopup = function(oToolbar) {
	var oPopupHolder = oToolbar.getDomRef("pu");
	var oDomRef = oToolbar.getDomRef();
	
	if (oPopupHolder && oDomRef) {
		var oOverflowButton = oToolbar.getDomRef("mn");
		var oToolbarCont = oDomRef.firstChild.firstChild;
		while (oPopupHolder.hasChildNodes()) {
			oToolbarCont.insertBefore(oPopupHolder.firstChild, oOverflowButton);
		}
	}
};


/**
 * Returns the area in which the overflow popup should be rendered.
 *
 * @param {sap.ui.commons.Toolbar} oToolbar The Toolbar whose popup area is requested
 *
 * @private
 */
sap.ui.commons.ToolbarRenderer.getPopupArea = function(oToolbar) {
	return oToolbar.getDomRef("pu");
};

/**
 * @param {sap.ui.commons.Toolbar} oToolbar The Toolbar where the overflow button should be set active
 * @private
 */
sap.ui.commons.ToolbarRenderer.setActive = function(oToolbar) {
	oToolbar.$("mn").addClass("sapUiTbOBAct");
};

/**
 * @param {sap.ui.commons.Toolbar} oToolbar The Toolbar where the overflow button should be set not active
 * @private
 */
sap.ui.commons.ToolbarRenderer.unsetActive = function(oToolbar) {
	oToolbar.$("mn").removeClass("sapUiTbOBAct");
};
}; // end of sap/ui/commons/ToolbarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TreeRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TreeRenderer
jQuery.sap.declare("sap.ui.commons.TreeRenderer");

/**
 * @class Tree renderer.
 * @static
 */
sap.ui.commons.TreeRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oTree an object representation of the control that should be rendered
 */
sap.ui.commons.TreeRenderer.render = function(oRenderManager, oTree){
	// convenience variable
	var rm = oRenderManager;

	//First node get is focusable.
	sap.ui.commons.TreeRenderer.bFirstNodeRendered = false;

	rm.write("<div");
	rm.writeControlData(oTree);
	rm.addClass("sapUiTree");

	if(oTree.getHeight() != "" && oTree.getHeight() != "auto"){
		rm.addClass("sapUiTreeFixedHeight");
	}
	if(!oTree.getShowHeader()){
		rm.addClass("sapUiTreeTransparent");
	}
	rm.writeClasses();

	rm.addStyle("width", oTree.getWidth() || "auto");
	rm.addStyle("height", oTree.getHeight());
	rm.addStyle("min-width", oTree.getMinWidth());

	rm.writeStyles();

	//ARIA
	rm.writeAttribute('role', 'tree');
	rm.write(">");

	if(oTree.getShowHeader()){

		rm.write("<div id=\""+ oTree.getId() +"-Header\" class=\"sapUiTreeHeader\""); //Header
		rm.writeAttribute('role', 'heading');
		rm.write(">");

		//Title
		rm.write("<div class='sapUiTreeTitle'");

		if(oTree.getTooltip_AsString()){
			rm.writeAttributeEscaped( "title", oTree.getTooltip_AsString());//Tree tooltip
		}
		rm.write(">");
		rm.writeEscaped(oTree.getTitle());
		rm.write("</div>");


		if(oTree.getShowHeaderIcons()){
			rm.write("<div id='"+oTree.getId()+"-TBCont' class='sapUiTreeTbCont'"); //ToolbarContainer
			rm.writeAttribute('role', 'toolbar');
			rm.write(">");
			rm.renderControl(oTree.oCollapseAllButton);
			rm.renderControl(oTree.oExpandAllButton );

			rm.write("</div>");
		}


		rm.write("</div>");//End of Header
	}

	rm.write("<div id=\""+ oTree.getId() +"-TreeCont\""); //tree container


	rm.addClass("sapUiTreeCont");
	var showScroll = oTree.getShowHorizontalScrollbar();
	if(showScroll){
		rm.addClass("sapUiTreeContScroll");
	}else{
		rm.addClass("sapUiTreeContNoScroll");
	}
	rm.writeClasses();

	rm.write(">");

	// write the HTML into the render manager
	rm.write("<ul class=\"sapUiTreeList\">");

	var aNodes = oTree.getNodes();
	 for(var i=0;i<aNodes.length;i++){
	   sap.ui.commons.TreeRenderer.renderNode(rm, aNodes[i], 1, aNodes.length, i + 1);
	}

	rm.write("</ul>");
	rm.write("</div>");//Tree Container
	rm.write("</div>");//Tree
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oNode an object representation of the control that should be rendered
 * @param {int} iLevel the hierarchical level value of the node
 */
sap.ui.commons.TreeRenderer.renderNode = function(oRenderManager, oNode, iLevel, iSize, iPos){
	// convenience variable
	var rm = oRenderManager;
	var bExpanded;

	// write the HTML into the render manager
	rm.write("<li");
	rm.writeElementData(oNode);
	rm.addClass("sapUiTreeNode");

	if(oNode.getExpanded() && (oNode.getHasExpander() || oNode.hasChildren() )){
		rm.addClass("sapUiTreeNodeExpanded");
		bExpanded = true;
	}
	else if(!oNode.getExpanded() && (oNode.getHasExpander() || oNode.hasChildren() )){

		rm.addClass("sapUiTreeNodeCollapsed");
		bExpanded = false;
	}

	if(oNode.getSelectable() && oNode.getIsSelected()){
		rm.addClass("sapUiTreeNodeSelected");
		rm.writeAttribute('aria-selected', 'true');
	}

	if(! bExpanded && oNode.hasSelectedHiddenChild()){
		rm.addClass("sapUiTreeNodeSelectedParent");
		rm.writeAttribute('aria-selected', 'true');
	}

	rm.writeClasses(oNode);

	//ARIA
	var mProps = {role: 'treeitem', level: iLevel, setsize: iSize, posinset: iPos};

	if(bExpanded){
		mProps["expanded"] = true;
	}
	else{
		// don't write aria expanded attribute if a node has no children
		// if a node has an expander we assume that it also has children
		if (oNode.getHasExpander()) {
			mProps["expanded"] = false;
		}
	}

	rm.writeAccessibilityState(oNode, mProps);

	//Tooltip
	rm.writeAttributeEscaped( "title", oNode.getTooltip_AsString());

	if(!sap.ui.commons.TreeRenderer.bFirstNodeRendered){
		rm.write("tabindex='0'");
		sap.ui.commons.TreeRenderer.bFirstNodeRendered = true;
	}
	rm.write(">");


	rm.write("<span");  //Node Content

	rm.addClass("sapUiTreeNodeContent");
	if(!oNode.getSelectable()){
		rm.addClass("sapUiTreeNodeNotSelectable");
	}
	rm.writeClasses();

	rm.write(">");  //Node Content

	if(oNode.getIcon()){
		rm.writeIcon(oNode.getIcon(), "sapUiTreeIcon");
	}

	rm.writeEscaped( oNode.getText());


	rm.write("</span>"); //Node Content

	rm.write("</li>");

	if(oNode.getNodes()){
		var aSubNodes = oNode.getNodes();
		rm.write("<ul");

		rm.writeAttribute("id", oNode.getId() + "-children");

		rm.addClass("sapUiTreeChildrenNodes");
		if(!bExpanded){
			rm.addClass("sapUiTreeHiddenChildrenNodes");
		}
		else{
			rm.writeAttribute("style", "display: block;");//For animation sake
		}
		rm.writeClasses();

		rm.write(">");
		iLevel ++;
		for(var i=0;i<aSubNodes.length;i++){
			sap.ui.commons.TreeRenderer.renderNode(rm, aSubNodes[i], iLevel, aSubNodes.length, i + 1);
		}
		rm.write("</ul>");
	}
};

}; // end of sap/ui/commons/TreeRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TriStateCheckBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TriStateCheckBox
jQuery.sap.declare("sap.ui.commons.TriStateCheckBoxRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class
 * @author SAP SE
 * @version 0.1
 * @static
 */
sap.ui.commons.TriStateCheckBoxRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.TriStateCheckBoxRenderer.render = function(oRm, oControl) {

	// Return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	var myTabIndex = 0;
	var bReadOnly = false;

	// Collect state information
  var enabled = !!oControl.getEnabled();
	var editable = !!oControl.getEditable();
	var inErrorState = false;
	var inWarningState = false;
	var selectedState = oControl.getSelectionState();
	var ariaState = selectedState.toLowerCase();
	if (ariaState == "checked"){
		ariaState = true;
	}
	else if(ariaState == "unchecked"){
		ariaState = false;
	}
	var tooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oControl, oControl.getTooltip_AsString());
	var ariaLabelId = "sapUiAriaLabel" + oControl.getIdForLabel();
	if (oControl.getValueState() != null){
		inErrorState = sap.ui.core.ValueState.Error == oControl.getValueState();
		inWarningState = sap.ui.core.ValueState.Warning == oControl.getValueState();
	}

	// write the HTML into the render manager
	//outer span containing aria information, tabindex, text and tooltip etc.
	oRm.write("<span");
	oRm.writeControlData(oControl);

	oRm.addClass("sapUiTriCb");

	if (!!oControl.getWidth()){
		oRm.writeAttribute("style", "width:" + oControl.getWidth() + ";");
	}
	oRm.writeAccessibilityState(oControl, {
		"role" : sap.ui.core.AccessibleRole.Checkbox.toLowerCase(),
		"checked" : ariaState
		});
	oRm.writeClasses();
	if (!enabled){
		myTabIndex = -1;
	}
	oRm.writeAttribute("tabIndex", myTabIndex);
	oRm.write(">");

	// inner span carrying metadata and style according to the current state
	oRm.write("<span");

	oRm.writeAccessibilityState(oControl, {"labelledby": ariaLabelId});

	if (tooltip){
		oRm.writeAttributeEscaped("title", tooltip);
	}

	if (!enabled){
		bReadOnly = true;
		myTabIndex = -1;
		oRm.write(" disabled='disabled'");
	}

	if (!editable){
		bReadOnly = true;
	}

	if (bReadOnly){
		oRm.write(" readOnly='readOnly'");
	}

	oRm.addClass("sapUiTriCbInner");

	if (!enabled){
		oRm.addClass("sapUiTriCbDis");
	}

	if (!editable){
		oRm.addClass("sapUiTriCbRo");
	}

	if (inErrorState){
		oRm.addClass("sapUiTriCbErr");
	}
	else if (inWarningState){
		oRm.addClass("sapUiTriCbWarn");
	}

	// Add classes and properties depending on the state
	if (selectedState === "Checked") {
		oRm.addClass("sapUiTriCbCheck");
	}
	else if (selectedState === "Mixed") {
		oRm.addClass("sapUiTriCbMix");
	}

	oRm.writeClasses();
	oRm.write(">"); // span element
	oRm.write("</span>");

// render text into the outer span
	if (oControl.getText()) {
		this.renderText(ariaLabelId, oRm, oControl.getText(), oControl.getTextDirection());
	}
	oRm.write("</span>");

};

/**
 * Write the descriptive span for the CheckBox along with an explicit "dir" in case the text direction is different from the environment.
 * Add sLabelId as id for aria-labelledby support
 *
 */
 sap.ui.commons.TriStateCheckBoxRenderer.renderText = function(sLabelId, oRenderManager, sText, eTextDirection) {
	var oRm = oRenderManager;
	oRm.write("<span id=" + sLabelId + " class=\"sapUiTriCbLbl\"");
	if (!eTextDirection || eTextDirection == sap.ui.core.TextDirection.Inherit) {
		oRm.write(">");
		oRm.writeEscaped(sText);
	} else {
		oRm.write(" style=\"direction:" + eTextDirection.toLowerCase() + ";\">");
		oRm.writeEscaped(sText);
	}
	oRm.write("</span>");
};
}; // end of sap/ui/commons/TriStateCheckBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ValueHelpFieldRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ValueHelpField
jQuery.sap.declare("sap.ui.commons.ValueHelpFieldRenderer");


/**
 * @class ValueHelpField renderer.
 * For a common look&feel, the ValueHelpField extends the TextField control,
 * just like the ComboBox does.
 * @static
 */
sap.ui.commons.ValueHelpFieldRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.TextFieldRenderer);

/**
 * Hint: "renderOuterAttributes" is a reserved/hard-coded TextField extending function!
 *       It is used to allow extensions to display help icons.
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager currently rendering this control
 * @param {sap.ui.commons.ValueHelpField}
 *            oControl the ValueHelpField whose "value help" should be rendered
 * @private
 */
sap.ui.commons.ValueHelpFieldRenderer.renderOuterAttributes = function(rm, oControl) {
	// To share the overall ComboBox styling:
	// Note: Would be best if a more generic className had been used for this, like
	//       "sapUiTfIconContainer", as ComboBox and DatePicker and ValueHelpField are likely
	//       to always share a common container look. (Only icon should differ.)
	//       Then, in the unlikely case where one of them would want to differ from the
	//       others, then this one would only need to add its own className on top of
	//       the generic one, e.g. "sapUiTfDateContainer" for the DatePicker.
	// Referencing "sapUiTfCombo" for now.
	rm.addClass("sapUiTfCombo");
//as only input field gets focus, render aria info there
	rm.writeAttribute("aria-owns", oControl.getId() + '-input '+oControl.getId() + '-icon');
};

/**
 * Renders additional HTML for the ComboBox to the TextField (sets the icon)
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for
 *                                                 writing to the Render-Output-Buffer.
 * @param {sap.ui.fw.Control} oControl An object representation of the control that should
 *                                     be rendered.
 */
sap.ui.commons.ValueHelpFieldRenderer.renderOuterContent = function(rm, oControl){

	var sIconUrl = oControl.getIconURL();
	var aClasses = [];
	var mAttributes = {};
	mAttributes["id"] = oControl.getId() + "-icon";
	mAttributes["role"] = "button";

	// As mentioned above, a more generic "sapUiTfIcon" className could have been used...
	// One would just have had to add its own icon className!
	// Using "sapUiTfValueHelpIcon" for now, as it proved easier to define instead of overwriting
	// the ComboBox image sources and backgrounds.
	aClasses.push("sapUiTfValueHelpIcon");

	if (sIconUrl && sap.ui.core.IconPool.isIconURI(sIconUrl)) {
		oControl.bIsIconURI = true;
	} else {
		oControl.bIsIconURI = false;
		if (oControl.getEnabled() && oControl.getEditable()) {
			aClasses.push("sapUiTfValueHelpRegularIcon");
		}

		sIconUrl = this.renderIcon(rm, oControl, aClasses);
	}

	rm.writeIcon(sIconUrl, aClasses, mAttributes);

};

/**
 * as onBeforeRendering only runs while re-rendering this module is called in renderer
 */
sap.ui.commons.ValueHelpFieldRenderer.renderIcon = function(rm, oControl, aClasses){

	var sIcon = "";

	if (!oControl.getEnabled()) {
		if (oControl.getIconDisabledURL()) {
			oControl.sIconDsblUrl = oControl.getIconDisabledURL();
		} else if (oControl.getIconURL()) {
			oControl.sIconDsblUrl = oControl.getIconURL();
			aClasses.push('sapUiTfValueHelpDsblIcon');
		}
		sIcon = oControl.sIconDsblUrl;
	} else {
		if (oControl.getIconURL()) {
			oControl.sIconRegularUrl = oControl.getIconURL();
		}
		sIcon = oControl.sIconRegularUrl;
	}
	return sIcon;

};

///**
// * Renders ARIA information for the outer DIV
// *
// * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for
// *                                                 writing to the Render-Output-Buffer
// * @param {sap.ui.fw.Control} oControl an object representation of the control that should
// *                                     be rendered
// */
//sap.ui.commons.ValueHelpFieldRenderer.renderARIAInfo = function(rm, oControl) {
//	if ( sap.ui.getCore().getConfiguration().getAccessibility()){
//	// Widgets are discrete user interface objects with which the user can interact.
//	// Widget roles map to standard features in accessibility APIs.
//	// When a user navigates an element assigned any of the non-abstract subclass roles of widget,
//	// assistive technologies that typically intercept standard keyboard events SHOULD switch to
//	// an application browsing mode, and pass keyboard events through to the web application.
//	// The intent is to hint to certain assistive technologies to switch from normal browsing mode
//	// into a mode more appropriate for interacting with a web application; some user agents have
//	// a browse navigation mode where keys, such as up and down arrows, are used to browse the
//	// document, and this native behavior prevents the use of these keys by a web application.
//		rm.writeAttribute('role', 'widget');
//		rm.writeAttribute('aria-haspopup', 'true');
//		// IMPORTANT: According to jQuery forums, DatePicker Accessibility is to be delivered in a
//		//            future release. No release mentionned.
//		// So there is not much point about doing more about this at the moment.
//	}
//};
}; // end of sap/ui/commons/ValueHelpFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.FormLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.form.FormLayoutRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.form.FormLayoutRenderer'); // unlisted dependency retained


sap.ui.commons.form.FormLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.FormLayoutRenderer);
 
}; // end of sap/ui/commons/form/FormLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.FormRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.form.FormRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.form.FormRenderer'); // unlisted dependency retained


sap.ui.commons.form.FormRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.FormRenderer);
}; // end of sap/ui/commons/form/FormRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.GridLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.form.GridLayoutRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.form.GridLayoutRenderer'); // unlisted dependency retained


sap.ui.commons.form.GridLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.GridLayoutRenderer);
}; // end of sap/ui/commons/form/GridLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.ResponsiveLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.form.ResponsiveLayoutRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.form.ResponsiveLayoutRenderer'); // unlisted dependency retained


sap.ui.commons.form.ResponsiveLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.ResponsiveLayoutRenderer);
}; // end of sap/ui/commons/form/ResponsiveLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.SimpleFormRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.form.SimpleFormRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.form.SimpleFormRenderer'); // unlisted dependency retained


sap.ui.commons.form.SimpleFormRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.SimpleFormRenderer);
}; // end of sap/ui/commons/form/SimpleFormRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.AbsoluteLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.AbsoluteLayout
jQuery.sap.declare("sap.ui.commons.layout.AbsoluteLayoutRenderer");

/**
 * @class AbsoluteLayout renderer.
 * @static
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer = {
};


(function() {

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.render = function(oRenderManager, oControl){
	var rm = oRenderManager;

	oControl.doBeforeRendering();

	if(!oControl.getVisible()) {
		return;
	}

	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapUiLayoutAbs");
	rm.addClass("sapUiLayoutAbsOvrflwY" + oControl.getVerticalScrolling());
	rm.addClass("sapUiLayoutAbsOvrflwX" + oControl.getHorizontalScrolling());
	rm.writeClasses();
	var sStyle = "width:" + oControl.getWidth() + ";height:" + oControl.getHeight() + ";";
	rm.writeAttribute("style", sStyle);
	var sTooltip = oControl.getTooltip_AsString();
	if(sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	rm.write(">");

	var aPositions = oControl.getPositions();
	if(aPositions && aPositions.length > 0){
		for(var index=0; index<aPositions.length; index++){
			var oPosition = aPositions[index];
			var oChildControl = oPosition.getControl();
			if(oChildControl) {
				rm.write("<div");
				rm.writeElementData(oPosition);
				rm.writeAttribute("class", "sapUiLayoutAbsPos");
				rm.writeAttribute("style", getComputedStyles(oPosition));
				sTooltip = oPosition.getTooltip_AsString();
				if(sTooltip) {
					rm.writeAttributeEscaped("title", sTooltip);
				}
				rm.write(">");
				rm.renderControl(oChildControl);
				rm.write("</div>");
			}
		}
	}

	rm.write("</div>");
};


/**
 * Updates the size of the layout.
 *
 * @private
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.updateLayoutSize = function(oLayout) {
	jQuery(oLayout.getDomRef()).css("width", oLayout.getWidth()).css("height", oLayout.getHeight());
};


/**
 * Updates the scrolling mode of the layout.
 *
 * @private
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.updateLayoutScolling = function(oLayout) {
	var jLayout = jQuery(oLayout.getDomRef());
	for(var sScrollingType in sap.ui.core.Scrolling) {
		jLayout.removeClass("sapUiLayoutAbsOvrflwY"+sScrollingType).removeClass("sapUiLayoutAbsOvrflwX"+sScrollingType);
	}
	jLayout.addClass("sapUiLayoutAbsOvrflwY"+oLayout.getVerticalScrolling()).addClass("sapUiLayoutAbsOvrflwX"+oLayout.getHorizontalScrolling());
};


/**
 * Updates the styles of the given position in the Dom.
 *
 * @private
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.updatePositionStyles = function(oPosition) {
	jQuery(oPosition.getDomRef()).attr("style", getComputedStyles(oPosition));
};


/**
 * Removes the given position from the Dom.
 *
 * @private
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.removePosition = function(oPosition) {
	jQuery(oPosition.getDomRef()).remove();
};


/**
 * Removes all positions of the given layout from the Dom.
 *
 * @private
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.removeAllPositions = function(oLayout) {
	jQuery(oLayout.getDomRef()).html("");
};


/**
 * Updates the styles and the content of the given position in the Dom.
 *
 * @private
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.updatePositionedControl = function(oPosition) {
	sap.ui.commons.layout.AbsoluteLayoutRenderer.updatePositionStyles(oPosition);
	var rm = sap.ui.getCore().createRenderManager();
	rm.renderControl(oPosition.getControl());
	rm.flush(oPosition.getDomRef());
	rm.destroy();
};


/**
 * Inserts the given position into the Dom incl. the content and updating the styles.
 *
 * @private
 */
sap.ui.commons.layout.AbsoluteLayoutRenderer.insertPosition = function(oLayout, oPosition) {
	var index = oLayout.indexOfPosition(oPosition);
	var oPositions = oLayout.getPositions();
	var oPredecessorPosition = null;
	while(index > 0) {
		index--;
		if(oPositions[index].getDomRef()){
			oPredecessorPosition = oPositions[index];
			break;
		}
	}

	var sHTML = "<div id=\""+oPosition.getId()+"\" data-sap-ui=\""+oPosition.getId()+"\" class=\"sapUiLayoutAbsPos\"></div>";
	if(!oPredecessorPosition){
		jQuery(oLayout.getDomRef()).prepend(sHTML);
	}else{
		jQuery(oPredecessorPosition.getDomRef()).after(sHTML);
	}

	sap.ui.commons.layout.AbsoluteLayoutRenderer.updatePositionedControl(oPosition);
};


/**
 * Computes and returns the CSS styles for the given position.
 *
 * @private
 */
var getComputedStyles = function(oPosition) {
	var oPos = oPosition.getComputedPosition();

	var addStyle = function(oPosition, aBuffer, sPos, sVal){
		if(sVal) {
			aBuffer.push(sPos+":"+sVal+";");
		}
	};

	var aBuffer = [];
	addStyle(oPosition, aBuffer, "top", oPos.top);
	addStyle(oPosition, aBuffer, "bottom", oPos.bottom);
	addStyle(oPosition, aBuffer, "left", oPos.left);
	addStyle(oPosition, aBuffer, "right", oPos.right);
	addStyle(oPosition, aBuffer, "width", oPos.width);
	addStyle(oPosition, aBuffer, "height", oPos.height);

	return aBuffer.join("");
};

}());
}; // end of sap/ui/commons/layout/AbsoluteLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.BorderLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.BorderLayout
jQuery.sap.declare("sap.ui.commons.layout.BorderLayoutRenderer");

jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained


/**
 * @class BorderLayout renderer.
 * @static
 */
sap.ui.commons.layout.BorderLayoutRenderer = {};

(function() {
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing
	 *            to the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should
	 *            be rendered
	 */
	sap.ui.commons.layout.BorderLayoutRenderer.render = function(oRm, oControl) {
		var mAreas = {
			top : oControl.getTop(),
			begin : oControl.getBegin(),
			center : oControl.getCenter(),
			end : oControl.getEnd(),
			bottom : oControl.getBottom()
		};
		var mAreaSizes = {
			top : sizeOf(mAreas.top),
			begin : sizeOf(mAreas.begin),
			center : sizeOf(mAreas.center),
			end : sizeOf(mAreas.end),
			bottom : sizeOf(mAreas.bottom)
		};
		var bRTL = sap.ui.getCore().getConfiguration().getRTL();

		// open the outer HTML tag
		oRm.write("<div");
		// let control data be written so that connection to SAPUI5 eventing
		// gets established
		oRm.writeControlData(oControl);
		oRm.addClass("sapUiBorderLayout");
		oRm.addStyle("width", oControl.getWidth());
		oRm.addStyle("height", oControl.getHeight());
		oRm.writeClasses();
		oRm.writeStyles();
		// don't forget to close the HTML tag
		oRm.write(">");

		/* render areas */
		if (mAreas.top/* && oTop.getVisible() */) {
			renderArea(oRm, "top", mAreas.top, mAreaSizes, bRTL);
		}
		if (mAreas.begin/* && oBegin.getVisible() */) {
			renderArea(oRm, "begin", mAreas.begin, mAreaSizes, bRTL);
		}
		if (mAreas.center && mAreas.center.getVisible()) {
			renderArea(oRm, "center", mAreas.center, mAreaSizes, bRTL);
		}
		if (mAreas.end/* && oEnd.getVisible() */) {
			renderArea(oRm, "end", mAreas.end, mAreaSizes, bRTL);
		}
		if (mAreas.bottom/* && oBottom.getVisible() */) {
			renderArea(oRm, "bottom", mAreas.bottom, mAreaSizes, bRTL);
		}

		// close surrounding div
		oRm.write("</div>");
	};

	sap.ui.commons.layout.BorderLayoutRenderer.animate = function(oArea, bVisible) {
		var oBorderLayout = oArea.getParent();
		// var sBorderLayoutId = oBorderLayout.getId();
		var bRTL = sap.ui.getCore().getConfiguration().getRTL();
		var end = bVisible ? oArea.getSize() : "0";

		switch (oArea.getAreaId()) {
		case "top":
			$area(oArea, "top").animate({
				height : end
			});
			$area(oArea, "begin").animate({
				top : end
			});
			$area(oArea, "center").animate({
				top : end
			});
			$area(oArea, "end").animate({
				top : end
			});
			break;

		case "begin":
			$area(oArea, "begin").animate({
				width : end
			});
			$area(oArea, "center").animate(bRTL ? {
				right : end
			} : {
				left : end
			});
			break;

		case "end":
			$area(oArea, "center").animate(bRTL ? {
				left : end
			} : {
				right : end
			});
			$area(oArea, "end").animate({
				width : end
			});
			break;

		case "bottom":
			$area(oArea, "begin").animate({
				bottom : end
			});
			$area(oArea, "center").animate({
				bottom : end
			});
			$area(oArea, "end").animate({
				bottom : end
			});
			$area(oArea, "bottom").animate({
				height : end
			});
			break;

		default:
			break;
		}

	};

	function sizeOf(oArea) {
		var oSize = oArea && oArea.getVisible() && oArea.getSize();
		return oSize || "0";
	}

	function renderArea(oRm, sAreaId, oArea, mAreaSizes, bRTL) {
		var aAreaControls = oArea.getContent();
		var length = aAreaControls.length;

		oRm.write("<div");
		oRm.writeAttribute("id", oArea.getId());
		// collect styles and classes depending on area type
		switch (sAreaId) {
		case "top":
			oRm.addClass("sapUiBorderLayoutTop");
			oRm.addStyle("height", mAreaSizes.top);
			break;
		case "begin":
			oRm.addClass("sapUiBorderLayoutBegin");
			oRm.addStyle("width", mAreaSizes.begin);
			oRm.addStyle("top", mAreaSizes.top);
			oRm.addStyle("bottom", mAreaSizes.bottom);
			break;
		case "center":
			oRm.addClass("sapUiBorderLayoutCenter");
			oRm.addStyle("top", mAreaSizes.top);
			oRm.addStyle("right", bRTL ? mAreaSizes.begin : mAreaSizes.end);
			oRm.addStyle("bottom", mAreaSizes.bottom);
			oRm.addStyle("left", bRTL ? mAreaSizes.end : mAreaSizes.begin);
			break;
		case "end":
			oRm.addClass("sapUiBorderLayoutEnd");
			oRm.addStyle("width", mAreaSizes.end);
			oRm.addStyle("top", mAreaSizes.top);
			oRm.addStyle("bottom", mAreaSizes.bottom);
			break;
		case "bottom":
			oRm.addClass("sapUiBorderLayoutBottom");
			oRm.addStyle("height", mAreaSizes.bottom);
			break;
		default:
			jQuery.sap.assert("default branch must not be reached");
			break;
		}

		// add overflow definition to the style-attribute value
		oRm.addStyle("overflow-x", jQuery.sap.encodeHTML(oArea.getOverflowX() || ""));
		oRm.addStyle("overflow-y", jQuery.sap.encodeHTML(oArea.getOverflowY() || ""));

		// write alignment
		var sAlign = oArea.getContentAlign();
		if (bRTL) {
			if (sAlign === "right") {
				sAlign = "left";
			} else if (sAlign === "left") {
				sAlign = "right";
			}
		}
		oRm.addStyle("text-align", jQuery.sap.encodeHTML(sAlign || ""));

		oRm.writeClasses(oArea);
		oRm.writeStyles();

		oRm.write(">");

		// render the controls
		for ( var i = 0; i < length; i++) {
			oRm.renderControl(aAreaControls[i]);
		}

		oRm.write("</div>");
	}

	function $area(oArea, sAreaId) {
		var oOtherArea = oArea.getParent().getArea(sAreaId);
		return oOtherArea ? oOtherArea.$() : jQuery();
	}
}());
}; // end of sap/ui/commons/layout/BorderLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.HorizontalLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.layout.HorizontalLayoutRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.HorizontalLayoutRenderer'); // unlisted dependency retained


sap.ui.commons.layout.HorizontalLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.HorizontalLayoutRenderer);
}; // end of sap/ui/commons/layout/HorizontalLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.MatrixLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.MatrixLayout
jQuery.sap.declare("sap.ui.commons.layout.MatrixLayoutRenderer");

/**
 * @class MatrixLayout renderer.
 *
 * @author d029921
 * @static
 */
sap.ui.commons.layout.MatrixLayoutRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the Render-Output-Buffer.
 * @param {sap.ui.core.Control} oMatrixLayout an object representation of the control that should be rendered
 */
sap.ui.commons.layout.MatrixLayoutRenderer.render = function(oRenderManager, oMatrixLayout) {

	// some convenience variables.
	var rm = oRenderManager;
	var r = sap.ui.commons.layout.MatrixLayoutRenderer;

	// return immediately if control is invisible
	if ( !oMatrixLayout.getVisible() ) {
		return;
	}

	var bRTL = sap.ui.getCore().getConfiguration().getRTL();

	//ARIA
	rm.write("<TABLE role=\"presentation\"");
	rm.writeControlData(oMatrixLayout);
	rm.write(" cellpadding=\"0\" cellspacing=\"0\"");
	rm.addStyle("border-collapse", "collapse");

	var sMatrixWidth = oMatrixLayout.getWidth();
	if(sMatrixWidth){
		rm.addStyle("width", sMatrixWidth);
	}

	var sMatrixHeight = oMatrixLayout.getHeight();
	if(sMatrixHeight && sMatrixHeight != 'auto'){
		rm.addStyle("height", sMatrixHeight);
		// get value and unit of Layout height (to determine row heights if given in %)
		var oMatrixHeight = r.getValueUnit( sMatrixHeight );
	}

	if(oMatrixLayout.getLayoutFixed()){
		// table layout is fixed
		rm.addStyle("table-layout", "fixed");
		if(!sMatrixWidth){
			rm.addStyle("width", "100%");
		}
	}

	rm.addClass("sapUiMlt");
	rm.writeStyles();
	rm.writeClasses();

	if(oMatrixLayout.getTooltip_AsString()) {
		rm.writeAttributeEscaped('title', oMatrixLayout.getTooltip_AsString());
	}

	// close table-start-tag
	rm.write('>');

	var aRows = oMatrixLayout.getRows();
	var iCols = oMatrixLayout.getColumns();
	if(iCols < 1){
		// determine number of columns
		for (var i = 0; i < aRows.length; i++) {
			var oMatrixLayoutRow = aRows[i];
			var aCells = oMatrixLayoutRow.getCells();
			if( iCols < aCells.length){
				iCols = aCells.length;
			}
		}
	}

	// create columns
	if(iCols > 0){
		var aWidths = oMatrixLayout.getWidths();
		rm.write("<colgroup>");
		for (var j = 0; j < iCols; j++) {
			rm.write("<col");
			if(aWidths && aWidths[j] && aWidths[j] != "auto"){
				rm.addStyle('width', aWidths[j]); // use style because col width in HTML supports only be px or %
				rm.writeStyles();
			}
			rm.write("/>");
		}
		rm.write("</colgroup>");
	}

	// in IE9 there is a problem with column width if too much colspans are used and not
	// at least one cell per columns has colspan 1
	// to keep the check simple just check if in every row colspans are used
	var bDummyRow = true;
	var bColspanInRow = false;

	rm.write('<TBODY style="width: 100%; height: 100%">');

	// for each row
	for (var i = 0; i < aRows.length; i++) {
		var oMatrixLayoutRow = aRows[i];

		// get value and unit of Row height (to determine row heights if given in %)
		var sRowHeight = oMatrixLayoutRow.getHeight();
		if (sRowHeight == "auto") {
			//ignore auto because without rowHeight it's auto sized
			sRowHeight = "";
		}
		if (sRowHeight && oMatrixHeight) {
			var oRowHeight = r.getValueUnit( sRowHeight );
			if( oRowHeight.Unit == '%' && oMatrixHeight.Unit != '%'){
				// Matrix has fix height and Row % -> calculate Row height to fix value
				sRowHeight = ( oMatrixHeight.Value * oRowHeight.Value / 100 ) + oMatrixHeight.Unit;
			}
		}

		rm.write("<tr");
		rm.writeElementData(oMatrixLayoutRow);
		rm.writeClasses(oMatrixLayoutRow);
		if(oMatrixLayoutRow.getTooltip_AsString()) {
			rm.writeAttributeEscaped('title', oMatrixLayoutRow.getTooltip_AsString());
		}

		if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version >= 9 && sRowHeight) {
			// for IE9 and IE10 in some cases the height is needed on TR, so it's added here.
			// Other browsers don't need it here
			// TD must have the same height even it looks wrong
			// (e.g. TR must have 30% and TD must have 30% to show a 30% height row)
			rm.addStyle("height", sRowHeight);
			rm.writeStyles();
		}
		rm.write(">");

		// for each cell
		var aCells = oMatrixLayoutRow.getCells();

		var iColumns = iCols;
		if(iCols < 1){
			// render only defined cells
			iColumns = aCells.length;
		}

		bColspanInRow = false;
		var iColSpans = 0;
		if(!oMatrixLayoutRow.RowSpanCells){
			oMatrixLayoutRow.RowSpanCells = 0;
		}else {
			bColspanInRow = true; // not really but ok for this case
		}

		for (var j = 0; j < iColumns; j++) {
			if(j >= (iColumns - iColSpans - oMatrixLayoutRow.RowSpanCells)){
			// no more cells because of Colspan
				break;
			}

			var oMatrixLayoutCell = aCells[j];

			rm.write("<td");

			if (sRowHeight && ( !oMatrixLayoutCell || oMatrixLayoutCell.getRowSpan() == 1 )) {
				// set height only if cell has no rowspan or is not specified
				rm.addStyle("height", sRowHeight);
			}

			if(oMatrixLayoutCell){
				// if empty cell only render empty TD
				rm.writeElementData(oMatrixLayoutCell);
				if(oMatrixLayoutCell.getTooltip_AsString()) {
					rm.writeAttributeEscaped('title', oMatrixLayoutCell.getTooltip_AsString());
				}

				if(oMatrixLayout.getLayoutFixed() && oMatrixLayoutCell.getContent().length > 0){
					// table layout is fixed
					rm.addStyle("overflow", "hidden");
					// as in Firefox 10 ellipsis makes problems it is removed.
					// controls inside of matrix cells should bring their own ellipsis function
					// However, ellipsis on cells can only work if included control has 100% size of cell,
					// otherwise (if control is bigger) its only cut.
					//rm.addStyle("text-overflow", "ellipsis");
				}

				var sHAlign = r.getHAlign(oMatrixLayoutCell.getHAlign(), bRTL);
				if (sHAlign) {
					rm.writeAttribute("align", sHAlign);
				}
				var sVAlign = r.getVAlign(oMatrixLayoutCell.getVAlign());
				if (sVAlign && sVAlign != "middle") { //middle is default, not needed
					rm.writeAttribute("valign", sVAlign);
				}
				if (oMatrixLayoutCell.getColSpan() > 1) {
					rm.writeAttribute("colspan", oMatrixLayoutCell.getColSpan());
					iColSpans = iColSpans + oMatrixLayoutCell.getColSpan() - 1;
					bColspanInRow = true;
				}
				if (oMatrixLayoutCell.getRowSpan() > 1) {
					rm.writeAttribute("rowspan", oMatrixLayoutCell.getRowSpan());

					// summarize height of all used rows
					var fValue = 0;
					var sUnit = "";
					for (var x = 0; x < oMatrixLayoutCell.getRowSpan(); x++) {
						var oRow = aRows[i+x];

						if(!oRow){
							sUnit = false;
							break;
						}

						if(!oRow.RowSpanCells){
							oRow.RowSpanCells = 0;
						}

						if(x > 0){
							// add number of cells with rowspan to following rows to not render additional cells
							oRow.RowSpanCells = oRow.RowSpanCells + oMatrixLayoutCell.getColSpan();
						}
						var sHeight = oRow.getHeight();
						if(!sHeight || sHeight == "auto"){
							//no height defined for one row -> no summarize possible
							sUnit = false;
							//break;
						}else{
							var oHeight = r.getValueUnit( sHeight );
							if( oHeight.Unit == '%' && oMatrixHeight.Unit != '%'){
								// Matrix has fix height and Row % -> calculate Row height to fix value
								oHeight.Value = ( oMatrixHeight.Value * oRowHeight.Value / 100 );
								oHeight.Unit  = oMatrixHeight.Unit;
							}
							if(sUnit == ""){
								sUnit = oHeight.Unit;
							}else{
								if(sUnit != oHeight.Unit){
									//different unit -> no summarize possible
									sUnit = false;
									//break;
								}
							}
							fValue = fValue + oHeight.Value;
						}
					}
					if(sUnit != false){
						var sSpanHeight = fValue + sUnit;
						rm.addStyle("height", sSpanHeight);
					}
				}

				// set CSS class for appropriate background
				rm.addClass(r.getBackgroundClass(oMatrixLayoutCell.getBackgroundDesign()));

				// set CSS class for appropriate separator
				rm.addClass(r.getSeparationClass(oMatrixLayoutCell.getSeparation()));

				if(!oMatrixLayout.getLayoutFixed() || !sRowHeight){
					// set CSS class for appropriate padding
					rm.addClass(r.getPaddingClass(oMatrixLayoutCell.getPadding()));

					rm.addClass("sapUiMltCell");
				} else{
					rm.addStyle("white-space", "nowrap");
				}


				rm.writeClasses(oMatrixLayoutCell);
			}
			rm.writeStyles();

			// close td-start-tag
			rm.write(">");

			if(oMatrixLayoutCell){
				// if empty cell only render empty TD

				if(oMatrixLayout.getLayoutFixed() && sRowHeight){
					// table layout is fixed
					// in case of defined height some DIVs are needed.
					// 1. one DIV to define height
					// 2. DIV to set vertical alignment
					// 3. DIV inside 2. DIV to set paddings for control inside.
					rm.write('<div');

					if( oMatrixLayoutCell.getRowSpan() != 1 && sSpanHeight && sSpanHeight.search('%') == -1){
						rm.addStyle("height", sSpanHeight);
					}else if(sRowHeight.search('%') != -1 || (oMatrixLayoutCell.getRowSpan() != 1 && !sSpanHeight)){
						rm.addStyle("height", '100%');
					}else{
						rm.addStyle("height", sRowHeight);
					}

					rm.addStyle("display", "inline-block");
					if (sVAlign) {
						rm.addStyle("vertical-align", sVAlign);
					}
					rm.writeStyles();
					rm.writeClasses(false);
					rm.write("></div>");
					rm.write('<div');
					rm.addStyle("display", "inline-block");
					if (sVAlign) {
						rm.addStyle("vertical-align", sVAlign);
					}
					if( oMatrixLayoutCell.getRowSpan() != 1 && sSpanHeight && sSpanHeight.search('%') == -1){
						rm.addStyle("max-height", sSpanHeight);
					}else if(sRowHeight.search('%') != -1 || (oMatrixLayoutCell.getRowSpan() != 1 && !sSpanHeight)){
						rm.addStyle("max-height", '100%');
					}else{
						rm.addStyle("max-height", sRowHeight);
					}
					/* determine height of content (if its a property there)
					   and set it to DIV (if possible) */
					var sContentHeight;
					var sDivHeight = "0";
					var sDivUnit = "";
					var sInnerDivHeight = "0";
					var aContentControls = oMatrixLayoutCell.getContent();
					for (var index = 0, length = aContentControls.length; index < length; index++) {
						if(aContentControls[index].getHeight && aContentControls[index].getHeight() !=""){
							// check unit
							var oControlHeight = r.getValueUnit( aContentControls[index].getHeight() );
							if (oControlHeight) {
								if(sDivUnit == ""){
									sDivUnit = oControlHeight.Unit;
								}
								if(sDivUnit != oControlHeight.Unit){
									// different units in content controls not allowed -> use 100%
									sDivUnit = "%";
									sDivHeight = "100";
									break;
								}
								if(oControlHeight.Unit == "%"){
									// give %-height to outer DIV but the reverse %-height to the inner DIV
									// -> height of the content is right
									if(parseFloat(sDivHeight) < parseFloat(oControlHeight.Value)){
										sDivHeight = oControlHeight.Value;
										if(sDivHeight != "100"){
											sInnerDivHeight = 10000 / parseFloat(sDivHeight);
										}
									}
								}// for fix units no calculation needed -DIVs get the size automatically
							}
						}
					}
					if(sDivHeight != "0"){
						rm.addStyle("height", sDivHeight+sDivUnit);
					}
					rm.addStyle("white-space", "normal");
					rm.addStyle("width", "100%");
					rm.writeStyles();
					rm.writeClasses(false);

					rm.write("><div");
					rm.addStyle("overflow", "hidden");
					rm.addStyle("text-overflow", "inherit");
					if(sDivHeight != "0"){
						if(sInnerDivHeight != "0"){
							rm.addStyle("height", sInnerDivHeight + "%");
						}else{
							rm.addStyle("height", "100%");
						}
					}
					rm.addClass("sapUiMltCell");

					// set CSS class for appropriate padding
					rm.addClass(r.getPaddingClass(oMatrixLayoutCell.getPadding()));

					rm.writeStyles();
					rm.writeClasses(false);
					rm.write(">"); // DIV
				}
				var aContentControls = oMatrixLayoutCell.getContent();
				for (var index = 0, length = aContentControls.length; index < length; index++) {
					oRenderManager.renderControl(aContentControls[index]);
				}
				if(oMatrixLayout.getLayoutFixed() && sRowHeight){
					// table layout is fixed
					rm.write("</div></div>");
				}
			}

			// close cell
			rm.write("</td>");
		}

		// close row
		rm.write("</tr>");

		// initialize RowSpanCounter after Row is rendered
		oMatrixLayoutRow.RowSpanCells = undefined;

		if (!bColspanInRow) {
			bDummyRow = false;
		}
	} // end of rows-rendering

	if (bDummyRow && sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version >= 9) {
		// render dummy row to help IE9 to calculate column sizes
		rm.write("<tr style='height:0;'>");
		for ( var i = 0; i < iCols; i++) {
			rm.write("<td></td>");
		}
		rm.write("</tr>");
	}

	// close tbody, close table
	rm.write("</TBODY></TABLE>");

};

/**
 * Returns the value for the HTML "align" attribute according to the given
 * horizontal alignment and RTL mode, or NULL if the HTML default is fine.
 *
 * @param {sap.ui.commons.layout.HAlign} oHAlign
 * @param {boolean} bRTL
 * @type string
 */
sap.ui.commons.layout.MatrixLayoutRenderer.getHAlign = function(oHAlign, bRTL) {
  switch (oHAlign) {
	case sap.ui.commons.layout.HAlign.Begin:
	  return null; // this is the HTML default

	case sap.ui.commons.layout.HAlign.Center:
	  return "center";

	case sap.ui.commons.layout.HAlign.End:
	  return bRTL ? "left" : "right";

	case sap.ui.commons.layout.HAlign.Left:
	  return bRTL ? "left" : null;

	case sap.ui.commons.layout.HAlign.Right:
	  return bRTL ? null : "right";
  }

  jQuery.sap.assert(false, "MatrixLayoutRenderer.getHAlign: oHAlign must be a known value");
  return null;
};

/**
 * Returns the value for the HTML "valign" attribute according to the given
 * vertical alignment, or NULL if the HTML default is fine.
 *
 * @param {sap.ui.commons.layout.VAlign} oVAlign
 * @type string
 */
sap.ui.commons.layout.MatrixLayoutRenderer.getVAlign = function(oVAlign) {
  switch (oVAlign) {
	case sap.ui.commons.layout.VAlign.Bottom:
	  return "bottom";

	case sap.ui.commons.layout.VAlign.Middle:
		return "middle";
	case sap.ui.commons.layout.VAlign.Top:
	  return "top";
  }

  jQuery.sap.assert(false, "MatrixLayoutRenderer.getVAlign: oVAlign must be a known value");
  return null;
};

/**
 * Returns the class name according to the given background design or NULL of
 * none is needed.
 *
 * @param {sap.ui.commons.layout.BackgroundDesign} oBackgroundDesign
 * @type string
 */
sap.ui.commons.layout.MatrixLayoutRenderer.getBackgroundClass = function(oBackgroundDesign) {
  switch (oBackgroundDesign) {
	case sap.ui.commons.layout.BackgroundDesign.Border:
	  return "sapUiMltBgBorder";

	case sap.ui.commons.layout.BackgroundDesign.Fill1:
	  return "sapUiMltBgFill1";

	case sap.ui.commons.layout.BackgroundDesign.Fill2:
	  return "sapUiMltBgFill2";

	case sap.ui.commons.layout.BackgroundDesign.Fill3:
	  return "sapUiMltBgFill3";

	case sap.ui.commons.layout.BackgroundDesign.Header:
	  return "sapUiMltBgHeader";

	case sap.ui.commons.layout.BackgroundDesign.Plain:
	  return "sapUiMltBgPlain";

	case sap.ui.commons.layout.BackgroundDesign.Transparent:
	  return null;
  }

  jQuery.sap.assert(false, "MatrixLayoutRenderer.getBackgroundClass: oBackgroundDesign must be a known value");
  return null;
};

/**
 * Returns the class name according to the given padding or NULL of
 * none is needed.
 *
 * @param {sap.ui.commons.layout.Padding} oPadding
 * @type string
 */
sap.ui.commons.layout.MatrixLayoutRenderer.getPaddingClass = function(oPadding) {
  switch (oPadding) {
	case sap.ui.commons.layout.Padding.None:
	  return "sapUiMltPadNone";

	case sap.ui.commons.layout.Padding.Begin:
	  return "sapUiMltPadLeft"; //TODO OK with RTL?

	case sap.ui.commons.layout.Padding.End:
	  return "sapUiMltPadRight"; //TODO OK with RTL?

	case sap.ui.commons.layout.Padding.Both:
	  return "sapUiMltPadBoth";

	case sap.ui.commons.layout.Padding.Neither:
	  return "sapUiMltPadNeither";
  }

  jQuery.sap.assert(false, "MatrixLayoutRenderer.getPaddingClass: oPadding must be a known value");
  return null;
};

/**
 * Returns the class name according to the given separation or NULL of
 * none is needed.
 *
 * @param {sap.ui.commons.layout.Separation} oSeparation
 * @type string
 */
sap.ui.commons.layout.MatrixLayoutRenderer.getSeparationClass = function(oSeparation) {
  switch (oSeparation) {
	case sap.ui.commons.layout.Separation.None:
	  return null;

	case sap.ui.commons.layout.Separation.Small:
	  return "sapUiMltSepS";

	case sap.ui.commons.layout.Separation.SmallWithLine:
	  return "sapUiMltSepSWL";

	case sap.ui.commons.layout.Separation.Medium:
	  return "sapUiMltSepM";

	case sap.ui.commons.layout.Separation.MediumWithLine:
	  return "sapUiMltSepMWL";

	case sap.ui.commons.layout.Separation.Large:
	  return "sapUiMltSepL";

	case sap.ui.commons.layout.Separation.LargeWithLine:
	  return "sapUiMltSepLWL";
  }

  jQuery.sap.assert(false, "MatrixLayoutRenderer.getSeparationClass: oSeparation must be a known value");
  return null;
};

/**
 * get Value and Unit for size
 */
sap.ui.commons.layout.MatrixLayoutRenderer.getValueUnit = function(sSize) {

	var fValue = 0;
	var sUnit = "";

	var iPos = sSize.search('px');
	if(iPos > -1){
		sUnit = "px";
		fValue = parseInt(sSize.slice(0,iPos), 10);
		return({ Value: fValue, Unit: sUnit })
	}

	iPos = sSize.search('pt');
	if(iPos > -1){
		sUnit = "pt";
		fValue = parseFloat(sSize.slice(0,iPos));
		return({ Value: fValue, Unit: sUnit })
	}

	iPos = sSize.search('in');
	if(iPos > -1){
		sUnit = "in";
		fValue = parseFloat(sSize.slice(0,iPos));
		return({ Value: fValue, Unit: sUnit })
	}

	iPos = sSize.search('mm');
	if(iPos > -1){
		sUnit = "mm";
		fValue = parseFloat(sSize.slice(0,iPos));
		return({ Value: fValue, Unit: sUnit })
	}

	iPos = sSize.search('cm');
	if(iPos > -1){
		sUnit = "cm";
		fValue = parseFloat(sSize.slice(0,iPos));
		return({ Value: fValue, Unit: sUnit })
	}

	iPos = sSize.search('em');
	if(iPos > -1){
		sUnit = "em";
		fValue = parseFloat(sSize.slice(0,iPos));
		return({ Value: fValue, Unit: sUnit })
	}

	iPos = sSize.search('ex');
	if(iPos > -1){
		sUnit = "ex";
		fValue = parseFloat(sSize.slice(0,iPos));
		return({ Value: fValue, Unit: sUnit })
	}

	iPos = sSize.search('%');
	if(iPos > -1){
		sUnit = "%";
		fValue = parseFloat(sSize.slice(0,iPos));
		return({ Value: fValue, Unit: sUnit })
	}

};

}; // end of sap/ui/commons/layout/MatrixLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.ResponsiveFlowLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.layout.ResponsiveFlowLayoutRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.ResponsiveFlowLayoutRenderer'); // unlisted dependency retained


sap.ui.commons.layout.ResponsiveFlowLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.ResponsiveFlowLayoutRenderer);
}; // end of sap/ui/commons/layout/ResponsiveFlowLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.VerticalLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.VerticalLayout
jQuery.sap.declare("sap.ui.commons.layout.VerticalLayoutRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.VerticalLayoutRenderer'); // unlisted dependency retained


sap.ui.commons.layout.VerticalLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.VerticalLayoutRenderer);

}; // end of sap/ui/commons/layout/VerticalLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

/**
 * Initialization Code and shared classes of library sap.ui.commons (1.24.2)
 */
jQuery.sap.declare("sap.ui.commons.library");
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained

/**
 * Common basic controls, mainly intended for desktop scenarios
 *
 * @namespace
 * @name sap.ui.commons
 * @public
 */


// library dependencies
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained

jQuery.sap.require('sap.ui.layout.library'); // unlisted dependency retained


// delegate further initialization of this library to the Core
sap.ui.getCore().initLibrary({
  name : "sap.ui.commons",
  dependencies : ["sap.ui.core","sap.ui.layout"],
  types: [
    "sap.ui.commons.ButtonStyle",
    "sap.ui.commons.HorizontalDividerHeight",
    "sap.ui.commons.HorizontalDividerType",
    "sap.ui.commons.LabelDesign",
    "sap.ui.commons.MenuBarDesign",
    "sap.ui.commons.MessageType",
    "sap.ui.commons.PaginatorEvent",
    "sap.ui.commons.RatingIndicatorVisualMode",
    "sap.ui.commons.RowRepeaterDesign",
    "sap.ui.commons.SplitterSize",
    "sap.ui.commons.TextViewColor",
    "sap.ui.commons.TextViewDesign",
    "sap.ui.core.TitleLevel",
    "sap.ui.commons.ToolbarDesign",
    "sap.ui.commons.ToolbarSeparatorDesign",
    "sap.ui.commons.TreeSelectionMode",
    "sap.ui.commons.TriStateCheckBoxState",
    "sap.ui.commons.enums.AreaDesign",
    "sap.ui.commons.enums.BorderDesign",
    "sap.ui.commons.enums.Orientation",
    "sap.ui.layout.form.GridElementCells",
    "sap.ui.layout.form.SimpleFormLayout",
    "sap.ui.commons.layout.BackgroundDesign",
    "sap.ui.commons.layout.BorderLayoutAreaTypes",
    "sap.ui.commons.layout.HAlign",
    "sap.ui.commons.layout.Padding",
    "sap.ui.commons.layout.Separation",
    "sap.ui.commons.layout.VAlign"
  ],
  interfaces: [
    "sap.ui.commons.FormattedTextViewControl",
    "sap.ui.commons.ToolbarItem"
  ],
  controls: [
    "sap.ui.commons.Accordion",
    "sap.ui.commons.ApplicationHeader",
    "sap.ui.commons.AutoComplete",
    "sap.ui.commons.Button",
    "sap.ui.commons.Callout",
    "sap.ui.commons.CalloutBase",
    "sap.ui.commons.Carousel",
    "sap.ui.commons.CheckBox",
    "sap.ui.commons.ColorPicker",
    "sap.ui.commons.ComboBox",
    "sap.ui.commons.DatePicker",
    "sap.ui.commons.Dialog",
    "sap.ui.commons.DropdownBox",
    "sap.ui.commons.FileUploader",
    "sap.ui.commons.FormattedTextView",
    "sap.ui.commons.HorizontalDivider",
    "sap.ui.commons.Image",
    "sap.ui.commons.ImageMap",
    "sap.ui.commons.InPlaceEdit",
    "sap.ui.commons.Label",
    "sap.ui.commons.Link",
    "sap.ui.commons.ListBox",
    "sap.ui.commons.Menu",
    "sap.ui.commons.MenuBar",
    "sap.ui.commons.MenuButton",
    "sap.ui.commons.Message",
    "sap.ui.commons.MessageBar",
    "sap.ui.commons.MessageList",
    "sap.ui.commons.MessageToast",
    "sap.ui.commons.Paginator",
    "sap.ui.commons.Panel",
    "sap.ui.commons.PasswordField",
    "sap.ui.commons.ProgressIndicator",
    "sap.ui.commons.RadioButton",
    "sap.ui.commons.RadioButtonGroup",
    "sap.ui.commons.RangeSlider",
    "sap.ui.commons.RatingIndicator",
    "sap.ui.commons.ResponsiveContainer",
    "sap.ui.commons.ResponsiveContainerRange",
    "sap.ui.commons.RichTooltip",
    "sap.ui.commons.RoadMap",
    "sap.ui.commons.RowRepeater",
    "sap.ui.commons.SearchField",
    "sap.ui.commons.SegmentedButton",
    "sap.ui.commons.Slider",
    "sap.ui.commons.Splitter",
    "sap.ui.commons.Tab",
    "sap.ui.commons.TabStrip",
    "sap.ui.commons.TextArea",
    "sap.ui.commons.TextField",
    "sap.ui.commons.TextView",
    "sap.ui.commons.ToggleButton",
    "sap.ui.commons.Toolbar",
    "sap.ui.commons.Tree",
    "sap.ui.commons.TriStateCheckBox",
    "sap.ui.commons.ValueHelpField",
    "sap.ui.commons.form.Form",
    "sap.ui.commons.form.FormLayout",
    "sap.ui.commons.form.GridLayout",
    "sap.ui.commons.form.ResponsiveLayout",
    "sap.ui.commons.form.SimpleForm",
    "sap.ui.commons.layout.AbsoluteLayout",
    "sap.ui.commons.layout.BorderLayout",
    "sap.ui.commons.layout.HorizontalLayout",
    "sap.ui.commons.layout.MatrixLayout",
    "sap.ui.commons.layout.ResponsiveFlowLayout",
    "sap.ui.commons.layout.VerticalLayout"
  ],
  elements: [
    "sap.ui.commons.AccordionSection",
    "sap.ui.commons.Area",
    "sap.ui.commons.FileUploaderParameter",
    "sap.ui.commons.MenuItem",
    "sap.ui.commons.MenuItemBase",
    "sap.ui.commons.MenuTextFieldItem",
    "sap.ui.commons.RoadMapStep",
    "sap.ui.commons.RowRepeaterFilter",
    "sap.ui.commons.RowRepeaterSorter",
    "sap.ui.commons.SearchProvider",
    "sap.ui.commons.Title",
    "sap.ui.commons.ToolbarSeparator",
    "sap.ui.commons.TreeNode",
    "sap.ui.commons.form.FormContainer",
    "sap.ui.commons.form.FormElement",
    "sap.ui.commons.form.GridContainerData",
    "sap.ui.commons.form.GridElementData",
    "sap.ui.commons.layout.BorderLayoutArea",
    "sap.ui.commons.layout.MatrixLayoutCell",
    "sap.ui.commons.layout.MatrixLayoutRow",
    "sap.ui.commons.layout.PositionContainer",
    "sap.ui.commons.layout.ResponsiveFlowLayoutData"
  ],
  version: "1.24.2"});

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.ButtonStyle.
jQuery.sap.declare("sap.ui.commons.ButtonStyle");


/**
 * @class different styles for a button.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.ButtonStyle = {

	/**
	 * Button is emphasized.
	 * @public
	 */
	Emph : "Emph",

	/**
	 * Accept button (normally green).
	 * @public
	 */
	Accept : "Accept",

	/**
	 * Reject button (normally red).
	 * @public
	 */
	Reject : "Reject",

	/**
	 * default style (no special styling).
	 * @public
	 */
	Default : "Default"

};
/**
 * 
 *   		Marker interface for common controls which are suitable for use within a FormattedTextView.
 *   
 *
 * @author SAP
 * @name sap.ui.commons.FormattedTextViewControl
 * @interface
 * @public
 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
 */

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.HorizontalDividerHeight.
jQuery.sap.declare("sap.ui.commons.HorizontalDividerHeight");


/**
 * @class Enumeration of possible HorizontalDivider height settings.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.HorizontalDividerHeight = {

	/**
	 * Divider gets no top and bottom margin.
	 * @public
	 */
	Ruleheight : "Ruleheight",

	/**
	 * Divider gets a small top and bottom margin.
	 * @public
	 */
	Small : "Small",

	/**
	 * Divider gets a medium top and bottom margin.
	 * @public
	 */
	Medium : "Medium",

	/**
	 * Divider gets a large top and bottom margin.
	 * @public
	 */
	Large : "Large"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.HorizontalDividerType.
jQuery.sap.declare("sap.ui.commons.HorizontalDividerType");


/**
 * @class Enumeration of possible HorizontalDivider types.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.HorizontalDividerType = {

	/**
	 * Type Area
	 * @public
	 */
	Area : "Area",

	/**
	 * Type Page
	 * @public
	 */
	Page : "Page"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.LabelDesign.
jQuery.sap.declare("sap.ui.commons.LabelDesign");


/**
 * @class Available label display modes.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.LabelDesign = {

	/**
	 * Displays the label in bold.
	 * @public
	 */
	Bold : "Bold",

	/**
	 * Displays the label in normal mode.
	 * @public
	 */
	Standard : "Standard"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.MenuBarDesign.
jQuery.sap.declare("sap.ui.commons.MenuBarDesign");


/**
 * @class Determines the visual design of a MenuBar. The feature might be not supported by all themes.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.MenuBarDesign = {

	/**
	 * The MenuBar appears in standard design.
	 * @public
	 */
	Standard : "Standard",

	/**
	 * The MenuBar appears in header design.
	 * @public
	 */
	Header : "Header"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.MessageType.
jQuery.sap.declare("sap.ui.commons.MessageType");


/**
 * @class [Enter description for MessageType]
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.MessageType = {

	/**
	 * Error message
	 * @public
	 */
	Error : "Error",

	/**
	 * Warning message
	 * @public
	 */
	Warning : "Warning",

	/**
	 * Successful message
	 * @public
	 */
	Success : "Success"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.PaginatorEvent.
jQuery.sap.declare("sap.ui.commons.PaginatorEvent");


/**
 * @class Disctinct paginator event types
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.PaginatorEvent = {

	/**
	 * First page event
	 * @public
	 */
	First : "First",

	/**
	 * Previous page event
	 * @public
	 */
	Previous : "Previous",

	/**
	 * Go to page event
	 * @public
	 */
	Goto : "Goto",

	/**
	 * Next page event
	 * @public
	 */
	Next : "Next",

	/**
	 * Last page event
	 * @public
	 */
	Last : "Last"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.RatingIndicatorVisualMode.
jQuery.sap.declare("sap.ui.commons.RatingIndicatorVisualMode");


/**
 * @class Possible values for the visualization of float values in the RatingIndicator Control.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.RatingIndicatorVisualMode = {

	/**
	 * Values are rounded to the nearest integer value (e.g. 1.7 -> 2).
	 * @public
	 */
	Full : "Full",

	/**
	 * Values are rounded to the nearest half value (e.g. 1.7 -> 1.5).
	 * @public
	 */
	Half : "Half",

	/**
	 * Values are not rounded.
	 * @public
	 */
	Continuous : "Continuous"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.RowRepeaterDesign.
jQuery.sap.declare("sap.ui.commons.RowRepeaterDesign");


/**
 * @class Determines the visual design of a RowRepeater.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.RowRepeaterDesign = {

	/**
	 * The RowRepeater header and footer elements, as well as the row container background, appear solid.
	 * @public
	 */
	Standard : "Standard",

	/**
	 * The RowRepeater header and footer elements, as well as the row container background, appear transparent.
	 * @public
	 */
	Transparent : "Transparent",

	/**
	 * The RowRepeater will be displayed without header, toolbar or footer. Background will be transparent.
	 * @public
	 */
	BareShell : "BareShell"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

// Provides data type sap.ui.commons.SplitterSize
jQuery.sap.declare('sap.ui.commons.SplitterSize');
jQuery.sap.require('sap.ui.base.DataType'); // unlisted dependency retained


/**
 * @class A string type that represents subset of CSS size values. For the Splitter only px and % are allowed.
 *
 * @author SAP SE
 * @final
 * @static
 * @public
 * @ui5-metamodel This simple type also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.SplitterSize = sap.ui.base.DataType.createType('sap.ui.commons.SplitterSize', {
    isValid : function(vValue) {
      return /^((0*|([0-9]+|[0-9]*\.[0-9]+)([pP][xX]|%)))$/.test(vValue);
    }

  },
  sap.ui.base.DataType.getType('string')
);

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.TextViewColor.
jQuery.sap.declare("sap.ui.commons.TextViewColor");


/**
 * @class Semantic Colors of a text.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.TextViewColor = {

	/**
	 * Default color
	 * @public
	 */
	Default : "Default",

	/**
	 * Positive color
	 * @public
	 */
	Positive : "Positive",

	/**
	 * Negative color
	 * @public
	 */
	Negative : "Negative",

	/**
	 * Critical color
	 * @public
	 */
	Critical : "Critical"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.TextViewDesign.
jQuery.sap.declare("sap.ui.commons.TextViewDesign");


/**
 * @class Designs for TextView.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.TextViewDesign = {

	/**
	 * Displays the text in standard letters.
	 * @public
	 */
	Standard : "Standard",

	/**
	 * Displays the text in bold letters
	 * @public
	 */
	Bold : "Bold",

	/**
	 * Displays the text in header 1 letters.
	 * @public
	 */
	H1 : "H1",

	/**
	 * Displays the text in header 2 letters.
	 * @public
	 */
	H2 : "H2",

	/**
	 * Displays the text in header 3 letters.
	 * @public
	 */
	H3 : "H3",

	/**
	 * Displays the text in header 4 letters.
	 * @public
	 */
	H4 : "H4",

	/**
	 * Displays the text in header 5 letters.
	 * @public
	 */
	H5 : "H5",

	/**
	 * Displays the text in header 6 letters.
	 * @public
	 */
	H6 : "H6",

	/**
	 * Displays the text in italic letters
	 * @public
	 */
	Italic : "Italic",

	/**
	 * Displays the text in smaller letters.
	 * @public
	 */
	Small : "Small",

	/**
	 * Displays the text in monospace letters.
	 * @public
	 */
	Monospace : "Monospace",

	/**
	 * underlined Text
	 * @public
	 */
	Underline : "Underline"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.ToolbarDesign.
jQuery.sap.declare("sap.ui.commons.ToolbarDesign");


/**
 * @class Determines the visual design of a Toolbar.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.ToolbarDesign = {

	/**
	 * The toolbar elements such as buttons for example have their normal visual design, and the toolbar appears solid.
	 * The feature might be not supported by all themes.
	 * @public
	 */
	Standard : "Standard",

	/**
	 * The controls included in the toolbar have a normal visual design where the toolbar appears transparent.
	 * The feature might be not supported by all themes.
	 * 
	 * @public
	 */
	Transparent : "Transparent",

	/**
	 * The included controls have a very light appearance. The feature might be not supported by all themes.
	 * @public
	 */
	Flat : "Flat"

};
/**
 * 
 *   Marker interface for common controls which are suitable for use within a toolbar.
 *   The most prominent example of a toolbar item is a button which is mostly used with
 *   an icon instead of a text caption.
 *   Toolbar items must have a fixed height compatible with the toolbar being
 *   a single horizontal row. They can refer to the toolbar's marker class
 *   "sapUiTb" to adjust their own theming when used inside a toolbar.
 *   
 *
 * @author d029921
 * @name sap.ui.commons.ToolbarItem
 * @interface
 * @public
 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
 */

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.ToolbarSeparatorDesign.
jQuery.sap.declare("sap.ui.commons.ToolbarSeparatorDesign");


/**
 * @class Design of the Toolbar Separator.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.ToolbarSeparatorDesign = {

	/**
	 * Standard Separator between controls
	 * @public
	 */
	Standard : "Standard",

	/**
	 * 100% height Separator before and after specific controls
	 * @public
	 */
	FullHeight : "FullHeight"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.TreeSelectionMode.
jQuery.sap.declare("sap.ui.commons.TreeSelectionMode");


/**
 * @class Selection mode of the tree
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.TreeSelectionMode = {

	/**
	 * Select multiple rows at a time.
	 * @public
	 */
	Multi : "Multi",

	/**
	 * Select one row at a time.
	 * @public
	 */
	Single : "Single",

	/**
	 * No rows can be selected.
	 * @public
	 */
	None : "None"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.TriStateCheckBoxState.
jQuery.sap.declare("sap.ui.commons.TriStateCheckBoxState");


/**
 * @class States for TriStateCheckBox
 *
 * @version 1.24.2
 * @static
 * @public
 * @since 1.7.2
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.TriStateCheckBoxState = {

	/**
	 * unchecked, default value for tri-state checkbox
	 * @public
	 */
	Unchecked : "Unchecked",

	/**
	 * mixed state for tri-state checkbox
	 * @public
	 */
	Mixed : "Mixed",

	/**
	 * checked value for tri-state checkbox
	 * @public
	 */
	Checked : "Checked"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.enums.AreaDesign.
jQuery.sap.declare("sap.ui.commons.enums.AreaDesign");


/**
 * @class Value set for the background design of areas
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.enums.AreaDesign = {

	/**
	 * Shows the area in a plain look
	 * @public
	 */
	Plain : "Plain",

	/**
	 * Shows the label in a filled look
	 * @public
	 */
	Fill : "Fill",

	/**
	 * Shows the background as transparent
	 * @public
	 */
	Transparent : "Transparent"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.enums.BorderDesign.
jQuery.sap.declare("sap.ui.commons.enums.BorderDesign");


/**
 * @class Value set for the border design of areas
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.enums.BorderDesign = {

	/**
	 * Draws the border as a box around the area
	 * @public
	 */
	Box : "Box",

	/**
	 * Suppresses the border
	 * @public
	 */
	None : "None"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.enums.Orientation.
jQuery.sap.declare("sap.ui.commons.enums.Orientation");


/**
 * @class Orientation of a UI element
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.enums.Orientation = {

	/**
	 * Horizontal orientation
	 * @public
	 */
	horizontal : "horizontal",

	/**
	 * Vertical orientation
	 * @public
	 */
	vertical : "vertical"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.layout.BackgroundDesign.
jQuery.sap.declare("sap.ui.commons.layout.BackgroundDesign");


/**
 * @class
 * Background design (i.e. color), e.g. of a layout cell.
 * 
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.layout.BackgroundDesign = {

	/**
	 * 
	 * A background design suitable for borders.
	 * 
	 * @public
	 */
	Border : "Border",

	/**
	 * 
	 * An opaque background design that looks dark filled.
	 * 
	 * @public
	 */
	Fill1 : "Fill1",

	/**
	 * 
	 * An opaque background design that looks medium filled.
	 * 
	 * @public
	 */
	Fill2 : "Fill2",

	/**
	 * 
	 * An opaque background design that looks light filled.
	 * 
	 * @public
	 */
	Fill3 : "Fill3",

	/**
	 * 
	 * A background design suitable for headers.
	 * 
	 * @public
	 */
	Header : "Header",

	/**
	 * 
	 * A plain but opaque background design.
	 * 
	 * @public
	 */
	Plain : "Plain",

	/**
	 * 
	 * A transparent background.
	 * 
	 * @public
	 */
	Transparent : "Transparent"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.layout.BorderLayoutAreaTypes.
jQuery.sap.declare("sap.ui.commons.layout.BorderLayoutAreaTypes");


/**
 * @class The type (=position) of a BorderLayoutArea
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.layout.BorderLayoutAreaTypes = {

	/**
	 * Value to identify the top area.
	 * @public
	 */
	top : "top",

	/**
	 * Value to identify the begin area.
	 * @public
	 */
	begin : "begin",

	/**
	 * Value to identify the center area.
	 * @public
	 */
	center : "center",

	/**
	 * Value to identify the end area.
	 * @public
	 */
	end : "end",

	/**
	 * Value to identify the bottom area.
	 * @public
	 */
	bottom : "bottom"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.layout.HAlign.
jQuery.sap.declare("sap.ui.commons.layout.HAlign");


/**
 * @class
 * Horizontal alignment, e.g. of a layout cell's content within the cell's borders.
 * Note that some values depend on the current locale's writing direction while
 * others do not.
 * 
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.layout.HAlign = {

	/**
	 * 
	 * Aligned towards the beginning of a line, in the current locale's writing direction.
	 * 
	 * @public
	 */
	Begin : "Begin",

	/**
	 * 
	 * Horizontally centered.
	 * 
	 * @public
	 */
	Center : "Center",

	/**
	 * 
	 * Aligned towards the end of a line, in the current locale's writing direction.
	 * 
	 * @public
	 */
	End : "End",

	/**
	 * 
	 * Left aligned, regardless of the current locale's writing direction.
	 * 
	 * @public
	 */
	Left : "Left",

	/**
	 * 
	 * Right aligned, regardless of the current locale's writing direction.
	 * 
	 * @public
	 */
	Right : "Right"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.layout.Padding.
jQuery.sap.declare("sap.ui.commons.layout.Padding");


/**
 * @class
 * Padding, e.g. of a layout cell's content within the cell's borders.
 * Note that all options except "None" include a padding of 2px at the top and
 * bottom, and differ only in the presence of a 4px padding towards the beginning
 * or end of a line, in the current locale's writing direction.
 * 
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.layout.Padding = {

	/**
	 * 
	 * No padding at all.
	 * 
	 * @public
	 */
	None : "None",

	/**
	 * 
	 * Top and bottom padding of 2px.
	 * Padding of 4px towards the beginning of a line, in the current locale's
	 * writing direction, but none towards its end.
	 * 
	 * @public
	 */
	Begin : "Begin",

	/**
	 * 
	 * Top and bottom padding of 2px.
	 * Padding of 4px towards the end of a line, in the current locale's
	 * writing direction, but none towards its beginning.
	 * 
	 * @public
	 */
	End : "End",

	/**
	 * 
	 * Top and bottom padding of 2px.
	 * Padding of 4px towards both the beginning and end of a line.
	 * 
	 * @public
	 */
	Both : "Both",

	/**
	 * 
	 * Top and bottom padding of 2px.
	 * No padding towards neither the beginning nor end of a line.
	 * 
	 * @public
	 */
	Neither : "Neither"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.layout.Separation.
jQuery.sap.declare("sap.ui.commons.layout.Separation");


/**
 * @class
 * Separation, e.g. of a layout cell from its neighbor, via a vertical gutter of
 * defined width, with or without a vertical line in its middle.
 * 
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.layout.Separation = {

	/**
	 * 
	 * No gutter at all (0px), and without a vertical line, of course.
	 * 
	 * @public
	 */
	None : "None",

	/**
	 * 
	 * A small (17px) vertical gutter without a vertical line.
	 * 
	 * @public
	 */
	Small : "Small",

	/**
	 * 
	 * A small (17px) vertical gutter with a vertical line in its middle.
	 * 
	 * @public
	 */
	SmallWithLine : "SmallWithLine",

	/**
	 * 
	 * A medium (31px) vertical gutter without a vertical line.
	 * 
	 * @public
	 */
	Medium : "Medium",

	/**
	 * 
	 * A medium (31px) vertical gutter with a vertical line in its middle.
	 * 
	 * @public
	 */
	MediumWithLine : "MediumWithLine",

	/**
	 * 
	 * A large (63px) vertical gutter without a vertical line.
	 * 
	 * @public
	 */
	Large : "Large",

	/**
	 * 
	 * A large (63px) vertical gutter with a vertical line in its middle.
	 * 
	 * @public
	 */
	LargeWithLine : "LargeWithLine"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.commons.layout.VAlign.
jQuery.sap.declare("sap.ui.commons.layout.VAlign");


/**
 * @class
 * Vertical alignment, e.g. of a layout cell's content within the cell's borders.
 * 
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.layout.VAlign = {

	/**
	 * 
	 * Aligned at the bottom.
	 * 
	 * @public
	 */
	Bottom : "Bottom",

	/**
	 * 
	 * Vertically centered.
	 * 
	 * @public
	 */
	Middle : "Middle",

	/**
	 * 
	 * Aligned at the top.
	 * 
	 * @public
	 */
	Top : "Top"

};

// -----------------------------------------------------------------------------
// Begin of Library Initialization coding, copied from shared.js
// -----------------------------------------------------------------------------

// lazy imports for MessageBox
sap.ui.lazyRequire("sap.ui.commons.MessageBox", "alert confirm show");

sap.ui.lazyRequire("sap.ui.commons.MenuItemBase", "new extend getMetadata");

sap.ui.commons.Orientation = {
	// Map the Orientation enum to new enums in core
	"Vertical"   : sap.ui.core.Orientation.Vertical,
	"Horizontal" : sap.ui.core.Orientation.Horizontal,
	// Map the Orientation enum to new enums with uppercase
	"vertical"   : sap.ui.core.Orientation.Vertical,
	"horizontal" : sap.ui.core.Orientation.Horizontal
};

//map the old commons type to new ones after move
sap.ui.commons.form.GridElementCells = sap.ui.layout.form.GridElementCells;
sap.ui.commons.form.SimpleFormLayout = sap.ui.layout.form.SimpleFormLayout;
sap.ui.commons.TitleLevel = sap.ui.core.TitleLevel;

// implement Form helper factory with common controls
if (!sap.ui.layout.form.FormHelper || !sap.ui.layout.form.FormHelper.bFinal) {
	sap.ui.layout.form.FormHelper = {
		createLabel: function(sText){
			return new sap.ui.commons.Label({text: sText});
		},
		createButton: function(sId, fPressFunction, oThis){
			var oButton = new sap.ui.commons.Button(sId,{
				lite: true
				});
			oButton.attachEvent('press', fPressFunction, oThis); // attach event this way to have the right this-reference in handler
			return oButton;
		},
		setButtonContent: function(oButton, sText, sTooltip, sIcon, sIconHovered){
			oButton.setText(sText);
			oButton.setTooltip(sTooltip);
			oButton.setIcon(sIcon);
			oButton.setIconHovered(sIconHovered);
		},
		addFormClass: function(){ return null; },
		bArrowKeySupport: true, /* enables the keyboard support for arrow keys */
		bFinal: false /* to allow mobile to overwrite  */
	};
}

//implement FileUploader helper factory with commons controls
jQuery.sap.setObject("sap.ui.unified.FileUploaderHelper", {
	createTextField: function(sId){
		var oTextField = new sap.ui.commons.TextField(sId);
		return oTextField;
	},
	setTextFieldContent: function(oTextField, sWidth){
		oTextField.setWidth(sWidth);
	},
	createButton: function(){
		var oButton = new sap.ui.commons.Button();
		return oButton;
	},
	bFinal: false /* to allow mobile to overwrite  */
});

//implement table helper factory with m controls
//possible is set before layout lib is loaded.
jQuery.sap.setObject("sap.ui.table.TableHelper", {
	createLabel: function(mConfig){
		return new sap.ui.commons.Label(mConfig);
	},
	createTextView: function(mConfig){
		return new sap.ui.commons.TextView(mConfig);
	},
	createTextField: function(mConfig){
		return new sap.ui.commons.TextField(mConfig);
	},
	createImage: function(mConfig){
		return new sap.ui.commons.Image(mConfig);
	},
	bFinal: false /* to allow mobile to overwrite  */
});

}; // end of sap/ui/commons/library.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Accordion') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Accordion.
jQuery.sap.declare("sap.ui.commons.Accordion");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Accordion.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '200px')</li>
 * <li>{@link #getOpenedSectionsId openedSectionsId} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getSections sections} <strong>(default aggregation)</strong> : sap.ui.commons.AccordionSection[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.Accordion#event:sectionOpen sectionOpen} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.commons.Accordion#event:sectionClose sectionClose} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.commons.Accordion#event:sectionsReorder sectionsReorder} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Contains N sections which act as containers for any library controls
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Accordion
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Accordion", { metadata : {

	publicMethods : [
		// methods
		"openSection", "closeSection"
	],
	library : "sap.ui.commons",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : '200px'},
		"openedSectionsId" : {type : "string", group : "Misc", defaultValue : null}
	},
	defaultAggregation : "sections",
	aggregations : {
		"sections" : {type : "sap.ui.commons.AccordionSection", multiple : true, singularName : "section"}
	},
	events : {
		"sectionOpen" : {}, 
		"sectionClose" : {}, 
		"sectionsReorder" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Accordion with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Accordion.extend
 * @function
 */

sap.ui.commons.Accordion.M_EVENTS = {'sectionOpen':'sectionOpen','sectionClose':'sectionClose','sectionsReorder':'sectionsReorder'};


/**
 * Getter for property <code>width</code>.
 * When the width specified is smaller than a section content, a horizontal scroll bar is provided.
 *
 * Default value is <code>200px</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.Accordion#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>200px</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#setWidth
 * @function
 */


/**
 * Getter for property <code>openedSectionsId</code>.
 * Section IDs that shall be opened by default at application start.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>openedSectionsId</code>
 * @public
 * @name sap.ui.commons.Accordion#getOpenedSectionsId
 * @function
 */

/**
 * Setter for property <code>openedSectionsId</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sOpenedSectionsId  new value for property <code>openedSectionsId</code>
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#setOpenedSectionsId
 * @function
 */


/**
 * Getter for aggregation <code>sections</code>.<br/>
 * Empty container used to display any library controls.
 * 
 * <strong>Note</strong>: this is the default aggregation for Accordion.
 * @return {sap.ui.commons.AccordionSection[]}
 * @public
 * @name sap.ui.commons.Accordion#getSections
 * @function
 */


/**
 * Inserts a section into the aggregation named <code>sections</code>.
 *
 * @param {sap.ui.commons.AccordionSection}
 *          oSection the section to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the section should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the section is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the section is inserted at 
 *             the last position        
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#insertSection
 * @function
 */

/**
 * Adds some section <code>oSection</code> 
 * to the aggregation named <code>sections</code>.
 *
 * @param {sap.ui.commons.AccordionSection}
 *            oSection the section to add; if empty, nothing is inserted
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#addSection
 * @function
 */

/**
 * Removes an section from the aggregation named <code>sections</code>.
 *
 * @param {int | string | sap.ui.commons.AccordionSection} vSection the section to remove or its index or id
 * @return {sap.ui.commons.AccordionSection} the removed section or null
 * @public
 * @name sap.ui.commons.Accordion#removeSection
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>sections</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.commons.AccordionSection[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Accordion#removeAllSections
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.commons.AccordionSection</code> in the aggregation named <code>sections</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.commons.AccordionSection}
 *            oSection the section whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.Accordion#indexOfSection
 * @function
 */
	

/**
 * Destroys all the sections in the aggregation 
 * named <code>sections</code>.
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#destroySections
 * @function
 */


/**
 * Event is triggered when the user opens a section.
 *
 * @name sap.ui.commons.Accordion#sectionOpen
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.openSectionId ID of the opened section
 * @param {string[]} oControlEvent.getParameters.closeSectionIds IDs of the sections that shall be closed. Can be initial in the case of no previously opened section.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'sectionOpen' event of this <code>sap.ui.commons.Accordion</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Accordion</code>.<br/> itself. 
 *  
 * Event is triggered when the user opens a section.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Accordion</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#attachSectionOpen
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'sectionOpen' event of this <code>sap.ui.commons.Accordion</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#detachSectionOpen
 * @function
 */

/**
 * Fire event sectionOpen to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'openSectionId' of type <code>string</code> ID of the opened section</li>
 * <li>'closeSectionIds' of type <code>string[]</code> IDs of the sections that shall be closed. Can be initial in the case of no previously opened section.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.Accordion#fireSectionOpen
 * @function
 */


/**
 * Event is triggered when the user closes a section.
 *
 * @name sap.ui.commons.Accordion#sectionClose
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.closeSectionId ID of the closed section
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'sectionClose' event of this <code>sap.ui.commons.Accordion</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Accordion</code>.<br/> itself. 
 *  
 * Event is triggered when the user closes a section.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Accordion</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#attachSectionClose
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'sectionClose' event of this <code>sap.ui.commons.Accordion</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#detachSectionClose
 * @function
 */

/**
 * Fire event sectionClose to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'closeSectionId' of type <code>string</code> ID of the closed section</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.Accordion#fireSectionClose
 * @function
 */


/**
 * Triggered when the user changes the position of a section.
 *
 * @name sap.ui.commons.Accordion#sectionsReorder
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.movedSectionId ID of the moved section.
 * @param {int} oControlEvent.getParameters.newIndex New index of the moved section.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'sectionsReorder' event of this <code>sap.ui.commons.Accordion</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Accordion</code>.<br/> itself. 
 *  
 * Triggered when the user changes the position of a section.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Accordion</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#attachSectionsReorder
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'sectionsReorder' event of this <code>sap.ui.commons.Accordion</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Accordion#detachSectionsReorder
 * @function
 */

/**
 * Fire event sectionsReorder to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'movedSectionId' of type <code>string</code> ID of the moved section.</li>
 * <li>'newIndex' of type <code>int</code> New index of the moved section.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.Accordion} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.Accordion#fireSectionsReorder
 * @function
 */


/**
 * Opens a section.
 *
 * @name sap.ui.commons.Accordion#openSection
 * @function
 * @param {string} sSectionId
 *         Id of the section that shall be opened
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Closes a section, and opens the default one
 *
 * @name sap.ui.commons.Accordion#closeSection
 * @function
 * @param {string} sSectionId
 *         Id of the section that shall be closed
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\Accordion.js
/***************************************************
* ACCORDION CONTROL - JAVASCRIPT FUNCTIONS
*
* An accordion is a control that applications can use
* to define N sections in which they can display N
* elements of X types. One section can be opened at
* once and one section is always opened. If the application
* does not provide a default section to be opened,
* the first enabled section is opened by default.
****************************************************/
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained

jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-core'); // unlisted dependency retained

jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-widget'); // unlisted dependency retained

jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-mouse'); // unlisted dependency retained

jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-sortable'); // unlisted dependency retained


//*"*************************************************
//* CONSTANTS DECLARATION - CLASS ATTRIBUTES
//***************************************************
sap.ui.commons.Accordion.CARD_1   = 1;
sap.ui.commons.Accordion.CARD_0_1 = 2;
sap.ui.commons.Accordion.CARD_0_N = 3;
sap.ui.commons.Accordion.CARD_1_N = 4;
sap.ui.commons.Accordion.KEY_TIMEOUT = 500;

sap.ui.commons.Accordion.aAccordionsToReplace = [];
sap.ui.commons.Accordion.aAccordions = [];

//***************************************************
//* INITIALIZATION
//***************************************************
/**
* Initialization of the Accordion control
* @private
*/
sap.ui.commons.Accordion.prototype.init = function(){

   this.bInitialRendering = true;

   // By default, only one section is opened
   this.activationMode = sap.ui.commons.Accordion.CARD_1;

   // Get messagebundle.properties for sap.ui.commons
   this.rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

   // Array used to store all section titles
   this.aSectionTitles = [];

   sap.ui.commons.Accordion.aAccordions.push(this);

};

/***********************************************************************************
* KEYBOARD NAVIGATION
* Note that we rely on 2 mechanisms to support all keyboard shortcuts needed.
* First, for control activation (open/close sections), we rely on UI5 pseudo-events
* which are called before the browser event. These events all start with onsap_xyz.
* For other navigation purposes such as next/previous element, we use itemNavigation.
* Note that to enter the section's content, one needs to use the TAB key which
* will take the browser's default behavior.
***********************************************************************************/

/**
 * SPACE key behavior
 * Opens the section or activates the UI element on SPACE key
 * @param {jQuery.Event} oEvent Browser event
 * @private
 */
sap.ui.commons.Accordion.prototype.onsapspace = function(oEvent){

	this.onclick(oEvent);

};

/**
 * PAGE DOWN key behavior
 * Beware that these shortcuts are used by FF3.6 to navigate between opened tabs in the browsers.
 * So this is declared as a limitation, but behaves as expected in Safari 5
 * Opens the next section and focuses the first element of this opened section
 * @param {jQuery.Event} oEvent Browser event
 * @private
 */
sap.ui.commons.Accordion.prototype.onsappagedownmodifiers = function(oEvent){

	// Get all the sections
	var target = jQuery(oEvent.target);
	var aParents = target.parentsUntil('.sapUiAcd');

	// Get the next section
	var oDOMSection = aParents[aParents.length - 1];
	var oNextSection = jQuery(oDOMSection).next();

	// Skip all disabled sections
	while(!this.getCorrespondingSection(oNextSection[0]).getEnabled()){
		oNextSection = oNextSection.next();
	}
	oNextSection = oNextSection[0];


	// Open the next enabled section
	this.openSection(oNextSection.id);

	// Drill down the DOM to get the next section and focus on its first active element
	var oSection = this.getCorrespondingSection(oNextSection);
	oSection.focusFirstControl();

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

};

/**
 * PAGE UP key behavior
 * Beware that these shortcuts are used by FF3.6 to navigate between opened TABS in the browsers.
 * So this is declared as a limitation, but behaves as expected in Safari 5
 * Opens the previous section and focuses the first element of this opened section
 * @param [jQuery.Event} oEvent Browser event
 * @private
 */
sap.ui.commons.Accordion.prototype.onsappageupmodifiers = function(oEvent){

	// Get all the sections
	var target = jQuery(oEvent.target);
	var aParents = target.parentsUntil('.sapUiAcd');

	// Get the previous section
	var oSection = aParents[aParents.length - 1];
	var oNextSection = jQuery(oSection).prev();

	// Skip all disabled sections
	while(!this.getCorrespondingSection(oNextSection[0]).getEnabled()){
		oNextSection = oNextSection.prev();
	}
	oNextSection = oNextSection[0];

	// Open the previously enabled section
	this.openSection(oNextSection.id);

	// Drill down the DOM to get the previous section and focus its first active element
	var oSection = this.getCorrespondingSection(oNextSection);
	if(oSection){
		oSection.focusFirstControl();
	}

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

};

sap.ui.commons.Accordion.prototype.onsapupmodifiers = function(oEvent){

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

	// Get the section to move
	var aParents	= jQuery(oEvent.target).parentsUntil('.sapUiAcd');
	var oDomSection = aParents[aParents.length - 1];

	// Is the section if the first one. if so, no up possible!
	if(this.__idxOfSec(oDomSection.id)==0){
		return;
	}

	var oDomTargetSection = jQuery(oDomSection).prev().first()[0];
	var bInsertFirst = false;
	if(this.__idxOfSec(oDomTargetSection.id)==0){
		bInsertFirst = true;
	}

	this.dropSection(oDomSection,oDomTargetSection,bInsertFirst);

	// Ensure the focus is on the right section
	var aSections = this.getSections();
	aSections[this.__idxOfSec(oDomSection.id)].focus();

};

sap.ui.commons.Accordion.prototype.onsapdownmodifiers = function(oEvent){

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

	//Get the section to move
	var aParents	= jQuery(oEvent.target).parentsUntil('.sapUiAcd');
	var oDomSection = aParents[aParents.length - 1];

	//Is the section if the first one. if so, no up possible!
	if(this.__idxOfSec(oDomSection.id)==this.getSections().length-1){
		return;
	}

	var oDomTargetSection = jQuery(oDomSection).next().first()[0];
	this.dropSection(oDomSection,oDomTargetSection,false);

	//Ensure the focus is on the right section
	var aSections = this.getSections();
	aSections[this.__idxOfSec(oDomSection.id)].focus();

};

/**
 * Called when the user presses the UP arrow key
 * @param oEvent The event triggered by the user
 * @private
 */
sap.ui.commons.Accordion.prototype.onsapprevious = function(oEvent){

	if (oEvent.srcControl.getMetadata().getName() != "sap.ui.commons.AccordionSection" ) {
		return;
	}

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

	//Get the current section
	var oCurrentSection = this.getCurrentSection(oEvent.target);

	//Extra check to see of we are on the first section, if yes, set the focus on this one
	if (oCurrentSection.id == this.getSections()[0].getId()){
		var oNextFocusableElement = jQuery(oCurrentSection).find("div.sapUiAcdSectionHdr");
		if (oNextFocusableElement){
			oNextFocusableElement.focus();
		}
	}

	//Simply set the focus on the next section if any
	if (oCurrentSection){

		//Get the previous section that is enabled, disregard disabled sections
		var oPreviousSection = jQuery(oCurrentSection).prev();
		while (oPreviousSection && jQuery(oPreviousSection).hasClass("sapUiAcdSectionDis")){
			oPreviousSection = jQuery(oPreviousSection).prev();
		}
		if (oPreviousSection){
			var oNextFocusableElement = jQuery(oPreviousSection).find("div.sapUiAcdSectionHdr");
			if (oNextFocusableElement){
				oNextFocusableElement.focus();
			}
		}
	}

};

/**
 * Called when the user presses the down arrow key
 * @param {jQuery.Event} oEvent The event triggered by the user
 * @private
 */
sap.ui.commons.Accordion.prototype.onsapnext = function(oEvent){

	if (oEvent.srcControl.getMetadata().getName() != "sap.ui.commons.AccordionSection" ) {
		return;
	}

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

	//Get the current section
	var oCurrentSection = this.getCurrentSection(oEvent.target);

	//Simply set the focus on the next section if any
	if (oCurrentSection){

		//Get the next section that is enabled, disregard disabled sections
		var oNextSection = jQuery(oCurrentSection).next();
		while (oNextSection && jQuery(oNextSection).hasClass("sapUiAcdSectionDis")){
			oNextSection = jQuery(oNextSection).next();
		}
		if (oNextSection){
			var oNextFocusableElement = jQuery(oNextSection).find("div.sapUiAcdSectionHdr");
			if (oNextFocusableElement){
				oNextFocusableElement.focus();
			}
		}
	}

};

/**
 * Called when the user presses the home key
 * @param oEvent The event triggered by the user
 * @private
 */
sap.ui.commons.Accordion.prototype.onsaphome = function(oEvent){

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

	//Get the current first section id
	var oFocusableSection = this.getSections()[0].getDomRef();

	//If the section is disabled, get the next section that is enabled, disregard disabled sections
	if (jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")){
		oFocusableSection = jQuery(oFocusableSection).next();
		while (oFocusableSection && jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")){
			oFocusableSection = jQuery(oFocusableSection).next();
		}
	}

	//We found one focusable section
	if (oFocusableSection){
		var oNextFocusableElement = jQuery(oFocusableSection).find("div.sapUiAcdSectionHdr");
		if (oNextFocusableElement){
			oNextFocusableElement.focus();
		}
	}

};

/**
 * Called when the user presses the end key
 * @param oEvent The event triggered by the user
 * @private
 */
sap.ui.commons.Accordion.prototype.onsapend = function(oEvent){

	// Stop the event
	oEvent.preventDefault();
	oEvent.stopPropagation();

	//Get the last section
	var iNbSections = this.getSections().length;
	var oFocusableSection = this.getSections()[iNbSections-1].getDomRef();

	//If the section is disabled, get the previous section that is enabled, disregard disabled sections
	if (jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")){
		oFocusableSection = jQuery(oFocusableSection).prev();
		while (oFocusableSection && jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")){
			oFocusableSection = jQuery(oFocusableSection).prev();
		}
	}

	//We found one focusable section
	if (oFocusableSection){
		var oNextFocusableElement = jQuery(oFocusableSection).find("div.sapUiAcdSectionHdr");
		if (oNextFocusableElement){
			oNextFocusableElement.focus();
		}
	}

};

/**
 * Utility to get the current section
 * @param {Element} oDomElement The current DOM element from which an event is triggered
 * @private
 */
sap.ui.commons.Accordion.prototype.getCurrentSection = function(oDomElement){

	//Use jQuery to get the parent section
	var oCurrentSection = oDomElement;
	while (!jQuery(oCurrentSection).hasClass("sapUiAcdSection")){
		oCurrentSection = jQuery(oCurrentSection).parent();
	}
	return oCurrentSection[0];

};

/***********************************************************************************
 * DRAG AND DROP
 * Drag and drop is used to move a single section at once up/down in the accordion
 * This can be achieved via a mouse click (down/up) and also via some keyboard
 * shortcuts (Ctrl-up and Ctrl-down)
 ***********************************************************************************/
/**
 * Drops a section to a new index
 * @param {Element} oDomSection	Section to drop to a new index
 * @param {Element} oDomTargetSection Section after which to drop the section
 * @param {boolean} bDropFirst If true, drop at first place
 * @private
 */
sap.ui.commons.Accordion.prototype.dropSection = function(oDomSection, oDomTargetSection, bDropFirst){

	//Get accordion DOM object
	var oDomAccordion = jQuery(oDomSection).parent()[0];

	//We substract 1 as the first child is the drop target and the should not be considered
	var aChildren = jQuery(oDomAccordion).children(".sapUiAcdSection").toArray();
	var iIndexToInsert = jQuery.inArray(oDomTargetSection, aChildren);

	if(bDropFirst){
		iIndexToInsert -= 1;
	}

	//Update accordion with the change
	this.moveSection(oDomSection.id,iIndexToInsert);

};

/**
 * Moves one section to a given new index by adjusting all internal information
 * @param {string} sSectionId The current section ID being moved
 * @param {int} iTargetIndex Where the section is dropped
 * @private
 */
sap.ui.commons.Accordion.prototype.moveSection = function(sSectionId, iTargetIndex){

	//Get previous index
	var iOldIndex = this.__idxOfSec(sSectionId);


	if(iTargetIndex==iOldIndex){
		 //Nothing to do
		 return;
	}


	/****Remove section from arrays*********************************/

	//Remove title for the list
	var sSectionTitle = this.aSectionTitles[iOldIndex];
	this.aSectionTitles.splice(iOldIndex,1);

	//Remove section aggregation
	var aSections = this.getSections();
	var oSection = aSections[iOldIndex];
	this.removeSection(iOldIndex, true);


	/****Add section to new index*********************************/
	if(iTargetIndex != -1){
		this.aSectionTitles.splice(iTargetIndex,0,sSectionTitle);
	}
	else{
		this.aSectionTitles.splice(0,0,sSectionTitle);
	}

	//Update aggregation
	this.insertSection(oSection,iTargetIndex, true);

	//Trigger event for application to react
	this.fireSectionsReorder({movedSectionId:sSectionId, newIndex:iTargetIndex});

};

sap.ui.commons.Accordion.prototype._onSortChange = function(oEvent, oUi){

	oEvent.preventDefault();
	oEvent.stopPropagation();

	var oDomSection = oUi.item[0];
	var SectionId = oUi.item[0].getAttribute("Id");

	//Get accordion DOM object
	var oDomAccordion = jQuery(oDomSection).parent()[0];

	var aChildren = jQuery(oDomAccordion).children(".sapUiAcdSection").toArray();
	var iIndexToInsert = jQuery.inArray(oDomSection, aChildren);

	this.moveSection(SectionId,iIndexToInsert);
};

/***********************************************************************************
 * FUNCTIONALITIES
 * Available functionalities in the Accordion are the following:
 * - Open a section
 * - Close a section
 ***********************************************************************************/

/**
 * Activation of the section - Opens or closes a section.
 * If the focus is on a collapsed section, it will close the currently opened section, and open this one.
 * If the focus is on an expanded section, it will collapse the section and open the default section.
 * This function is called onClick by the mouse, or via ENTER/SPACE keys
 * @param {jQuery.Event} oEvent Browser event
 * @private
 */
sap.ui.commons.Accordion.prototype.onclick = function(oEvent){

	//Click on the accordion itself are not considered
	if(oEvent.srcControl.getId() ==  this.getId()){
		return;
	}

	//Move up in the DOM to get the section (click occurs on the arrow which is an inner html element)
	var target = jQuery(oEvent.target);

	//Disable the possibility to click on the content to open/close a section
	if(target.hasClass("sapUiAcdSectionCont")){
		return;
	}

	if ( !(jQuery(oEvent.target).control(0) instanceof sap.ui.commons.AccordionSection) ) {
		return;
	}

	var oDomSection = oEvent.srcControl.getDomRef();

	//If the section is disabled, we cannot open/close it.
	var oSection = this.getCorrespondingSection(oDomSection);
	if(oSection && !oSection.getEnabled()){
		return;
	}

	//If the section is closed, open it
	if(oEvent.srcControl && oEvent.srcControl.getCollapsed() == true){
		this.openSection(oDomSection.id);
	}
	//If it is opened, close it
	else{
		if (oEvent.srcControl){
			this.closeSection(oDomSection.id);
		}
	}

	//Stop the event here
	oEvent.preventDefault();
	oEvent.stopPropagation();

	//Ensure the focus is on the right section
	var aSections = this.getSections();
	aSections[this.__idxOfSec(oDomSection.id)].focus();

};

/**
 * Opens a given section
 * @param {string} sSectionId, The given section ID
 * @private
 */
sap.ui.commons.Accordion.prototype.openSection = function(sSectionId){

	//Map the section ID to its internal index
	var iIndex = this.__idxOfSec(sSectionId);

	//Get all accordion's sections
	var aSections = this.getSections();

	//Close all sections currently opened
	if (this.activationMode == sap.ui.commons.Accordion.CARD_0_1 || this.activationMode == sap.ui.commons.Accordion.CARD_1){
	  var aClosedSections = this.closeOpenedSections();
	}

	//Open the section with the index retrieved from the importing section ID
	aSections[iIndex]._setCollapsed(false);

	//Trigger event for application to react
	this.fireSectionOpen({openSectionId:sSectionId, closeSectionIds:aClosedSections});

};

/**
 * Closes a given section
 * @param {string} sSectionId, The given section ID
 * @private
 */
sap.ui.commons.Accordion.prototype.closeSection = function(sSectionId){

	//Get the corresponding mapping index
	var iIndex = this.__idxOfSec(sSectionId);

	//Get all accordion's sections
	var aSections = this.getSections();
	var oCurrentSection = aSections[iIndex];

	//Get all default sections that should be opened
	var aDefaultSections = this.getOpenedSectionsId().split(",");

	//If we are in a context that one opened section is required and that the section we are about to
	//close is the default one, we avoid closing and reopening it.
	/**
	if ((	this.activationMode == sap.ui.commons.Accordion.CARD_1_N || this.activationMode == sap.ui.commons.Accordion.CARD_1) &&
			this.getNumberOfOpenedSections() == 1 && jQuery.inArray(oCurrentSection.getId(),aDefaultSections) != -1) {
			return;
	}
	*/

	//Close the given section
	aSections[iIndex]._setCollapsed(true);
	//If there is no section opened and at least one is required to be, we open the default one to respect activationMode
	//if ((this.activationMode == sap.ui.commons.Accordion.CARD_1_N || this.activationMode == sap.ui.commons.Accordion.CARD_1) && this.getNumberOfOpenedSections() == 0){
	//this.openDefaultSections();
	//}

	//Trigger event for application to react
	this.fireSectionClose({closeSectionId:sSectionId});

};

/**
 * Closes all opened sections
 * @private
 */
sap.ui.commons.Accordion.prototype.closeOpenedSections = function(){

	var aClosedSections = [];
	var aSections = this.getSections();

	//Simply loop and close the sections already opened
	for(var i=0;i<aSections.length;i++){
		if ( aSections[i].getCollapsed() == false ){
			aSections[i]._setCollapsed(true);
			aClosedSections.push(aSections[i].getId());
		}
	}

	//Return all sections that were closed
	return aClosedSections;

};

/**
 * Opens the default section; consider activationMode
 * @private
 */
sap.ui.commons.Accordion.prototype.openDefaultSections = function(){

	//Get all accordion's sections
	var aSections = this.getSections();

	//Loop trough all defaulted opened section and open them
	var aDefaultSections = this.getOpenedSectionsId().split(",");
	for(var i=0 ; i<aDefaultSections.length ; i++){
	  //From the default section ID to open, we retrieve the index
	  var oActiveSection = aSections[this.__idxOfSec(aDefaultSections[i])];
	  oActiveSection._setCollapsed(false);
	}

};

/**
 * Returns the number of currently opened sections
 * @return The number of currently opened sections
 * @private
 */
sap.ui.commons.Accordion.prototype.getNumberOfOpenedSections = function(){

	//Initialize the return parameter
	var openedSections  = 0;

	//Get all accordion's sections
	var aSections		= this.getSections();

	//Loop and sum up all opened sections
	for(var i=0;i<aSections.length;i++){
		if ( aSections[i].getCollapsed() == false ){
			openedSections++;
		}
	}
	return openedSections;
};


//*************************************************************************************
// * UTILITIES FUNCTIONS
// * List of all Javascript utilities functions needed to achieve the required behavior
// ************************************************************************************

sap.ui.commons.Accordion.prototype.addSection = function(oSection) {

	this.addAggregation("sections", oSection);

	//Add a default opened section id
	if ( (this.getOpenedSectionsId() == null || this.getOpenedSectionsId() == "" ) && oSection.getEnabled()){
		this.setOpenedSectionsId(oSection.getId());
	}

	this.aSectionTitles.push(oSection.getTitle());

};

/**
 * Returns the index of the given section or Id of a section.
 * @private
 */
sap.ui.commons.Accordion.prototype.__idxOfSec = function(oSection){
	if(typeof(oSection) == "string"){
		oSection = sap.ui.getCore().byId(oSection);
	}
	return this.indexOfSection(oSection);
};

/**
 * Redefinition of the method to add additional handling
 *
 * @param {string} sOpenedSectionsId  New value for property openedSectionsId
 * @return {sap.ui.commons.Accordion} 'this' to allow method chaining
 * @public
 */
sap.ui.commons.Accordion.prototype.setOpenedSectionsId = function(sOpenedSectionsId) {

	var aSections = this.getSections();

	var aDefaultSections = sOpenedSectionsId.split(",");


	if(aDefaultSections.length==1){
		//it can be that the method is called from method AddSection. We don't want to intefere with those
		// call.
		if(this.__idxOfSec(sOpenedSectionsId) < 0){
			this.setProperty("openedSectionsId", sOpenedSectionsId);
			return this;
		}

		if(aSections[this.__idxOfSec(sOpenedSectionsId)].getEnabled()){
			//If the provided section is enabled
			this.setProperty("openedSectionsId", sOpenedSectionsId);
		}
		else{

			//If the provided section is disabled, the open section will be the first enable section starting for the top
			for(var i=0;i<aSections.length;i++){
				if(aSections[i].getEnabled()){
					this.setProperty("openedSectionsId", aSections[i].getId());
					return this;
				}
			}
		}


	}
	else if(aDefaultSections.length==0){
		//If the empty string is provided, we keep the automatically selected section(as selected in method AddSection).
		return this;

	}
	//Several sections were provided, but some can be disabled. Check each of them
	else{
		var sCheckIndices;

		for(var i=0;i<aDefaultSections.length;i++){
			if(aSections[this.__idxOfSec(aDefaultSections[i])].getEnabled()){

				if(sCheckIndices){
					sCheckIndices += "," + aDefaultSections[i];

					//only one section should be opened at once, so return after the first is set
					return;
				}
				else{
					sCheckIndices = aDefaultSections[i];
				}

			}
		}

		if(sCheckIndices){
			//If at least one section remains
			this.setProperty("openedSectionsId", sCheckIndices);
		}


	}

	return this;

};


/**
 * Returns AccordionSection Object corresponding to a given Section DOM Object
 * @param oDomSection The section in a DOM representation object
 * @return The current section control
 * @private
 */
sap.ui.commons.Accordion.prototype.getCorrespondingSection = function (oDomSection) {

	//Look for section index within accordion
	if(jQuery(oDomSection).hasClass("sapUiAcdSection") ){
		var aAccordion	= jQuery(oDomSection).parent();
		var oAccordion  = aAccordion[0];
		var aSections	= jQuery(oAccordion).children();
		var iIndex		= aSections.index( oDomSection );
		var aoSections	= this.getSections();
		//Remove 1 as we have the target div as first child
		return aoSections[iIndex-1];
	}

};

/**
 * Returns true if the current section being processed is the last one of the Accordion
 * @param oSection The current section being processed
 * @return true If the current section being processed is the last one of the Accordion
 * @private
 */
sap.ui.commons.Accordion.prototype.isLastSection = function(oSection) {

	//Get all accordion's sections
	var aSections = this.getSections();

	//Simply check in our internal array containing all titles
	/*if(aSections.indexOf(oSection) == aSections.length-1 ){*/
	if(jQuery.inArray(oSection,aSections) == aSections.length-1 ){
		return true;
	}
	else{
		return false;
	}

};

/**
 * Once the Accordion is rendered, build the list of active controls that will be included
 * in the item navigation object. This support arrow keys navigation.
 * @private
 */
sap.ui.commons.Accordion.prototype.onAfterRendering = function() {

	// Collect the dom references of the items
	var accordion = this.getDomRef();
	var leftBorder = "0px";
	var rightBorder = "0px";
	//neccessary to make sure IE8 does not deliver medium if no border width is set
	if (jQuery(accordion).css("borderLeftStyle") !== "none") {
		leftBorder = jQuery(accordion).css("border-left-width");
	}
	if (jQuery(accordion).css("borderRightStyle") !== "none") {
		rightBorder = jQuery(accordion).css("border-right-width");
	}
	var borderTotal = parseFloat(leftBorder.substring(0, leftBorder.indexOf("px"))) + parseFloat(rightBorder.substring(0, rightBorder.indexOf("px")));
	accordion.style.height = accordion.offsetHeight - borderTotal - 7 + "px";

	this.$().sortable({
		handle: "> div.sapUiAcdSectionHdr > div",
		stop: jQuery.proxy(this._onSortChange, this)
	});
};

}; // end of sap/ui/commons/Accordion.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.AccordionSection') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.AccordionSection.
jQuery.sap.declare("sap.ui.commons.AccordionSection");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new AccordionSection.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getMaxHeight maxHeight} : sap.ui.core.CSSSize</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getCollapsed collapsed} : boolean (default: false)</li>
 * <li>{@link #getTitle title} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.AccordionSection#event:scroll scroll} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Represents a panel which is a container for other controls. The container does not have any layout function.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.AccordionSection
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.commons.AccordionSection", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"maxHeight" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"collapsed" : {type : "boolean", group : "Behavior", defaultValue : false},
		"title" : {type : "string", group : "Misc", defaultValue : null}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	},
	events : {
		"scroll" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.AccordionSection with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.AccordionSection.extend
 * @function
 */

sap.ui.commons.AccordionSection.M_EVENTS = {'scroll':'scroll'};


/**
 * Getter for property <code>maxHeight</code>.
 * When the section content exceeds maxHeight, a vertical scroll bar appears.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>maxHeight</code>
 * @public
 * @name sap.ui.commons.AccordionSection#getMaxHeight
 * @function
 */

/**
 * Setter for property <code>maxHeight</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sMaxHeight  new value for property <code>maxHeight</code>
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#setMaxHeight
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Requirement is that the used theme supports the control.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.AccordionSection#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#setEnabled
 * @function
 */


/**
 * Getter for property <code>collapsed</code>.
 * It is recommended to make some settings for the width when the section is set to 'collapsed'.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>collapsed</code>
 * @public
 * @name sap.ui.commons.AccordionSection#getCollapsed
 * @function
 */

/**
 * Setter for property <code>collapsed</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bCollapsed  new value for property <code>collapsed</code>
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#setCollapsed
 * @function
 */


/**
 * Getter for property <code>title</code>.
 * Text for the section header
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>title</code>
 * @public
 * @name sap.ui.commons.AccordionSection#getTitle
 * @function
 */

/**
 * Setter for property <code>title</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTitle  new value for property <code>title</code>
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#setTitle
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Aggregates the controls that are contained in the panel. Control layouting is browser-dependent. For a stable content layout, use a layout control as direct single child.
 * When the panel dimensions are set, the child control may have width and height of 100%;
 * when the panel dimensions are not set, the child defines the panel size.
 * 
 * <strong>Note</strong>: this is the default aggregation for AccordionSection.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.commons.AccordionSection#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.commons.AccordionSection#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.AccordionSection#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.AccordionSection#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#destroyContent
 * @function
 */


/**
 * Event is fired when the user scrolls the panel.
 *
 * @name sap.ui.commons.AccordionSection#scroll
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.left Horizontal scroll position.
 * @param {int} oControlEvent.getParameters.top Vertical scroll position.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'scroll' event of this <code>sap.ui.commons.AccordionSection</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.AccordionSection</code>.<br/> itself. 
 *  
 * Event is fired when the user scrolls the panel.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.AccordionSection</code>.<br/> itself.
 *
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#attachScroll
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'scroll' event of this <code>sap.ui.commons.AccordionSection</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.AccordionSection#detachScroll
 * @function
 */

/**
 * Fire event scroll to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'left' of type <code>int</code> Horizontal scroll position.</li>
 * <li>'top' of type <code>int</code> Vertical scroll position.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.AccordionSection} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.AccordionSection#fireScroll
 * @function
 */


// Start of sap\ui\commons\AccordionSection.js
/**
 * AccordionSection Behavior Implementation
 *
 * Open:
 * - HeaderDesign not implemented yet
 */

/**
 * Do some initialization
 * @private
 */
sap.ui.commons.AccordionSection.prototype.init = function(){
   this.bIgnoreScrollEvent = true; // do not fire a scroll event initially
   this.oScrollDomRef = null;      // points to the content area
};

/**
 * Set focus on the first control
 * @private
 */
sap.ui.commons.AccordionSection.prototype.focusFirstControl = function () {
	var aControls = this.getContent();
	if (aControls[0]) {
		aControls[0].focus();
	}
};

/**
 * Set focus the arrow
 * @private
 */
sap.ui.commons.AccordionSection.prototype.focus = function () {

	var header = this.getDomRef("hdr");
	header.focus();
};

/**
 * Called after the theme has been switched, required for adjustments
 * @private
 */
sap.ui.commons.AccordionSection.prototype.onThemeChanged = function () {
	var hdrLeft = this.getDomRef("hdrL");

	if (hdrLeft) {
		hdrLeft.style.width = "auto";
		var obj = this;
		setTimeout(function() {obj.onAfterRendering();}, 0); // TODO: there is a problem in IE8, depending on what the surrounding container is...
	}

}

/**
 * Adapts size settings of the rendered HTML
 * @private
 */;
sap.ui.commons.AccordionSection.prototype.onAfterRendering = function () {

	this.oScrollDomRef = this.getDomRef("cont");
	var cont	  = this.oScrollDomRef;
	var root	  = this.getDomRef();
	var accordion = this.getParent().getDomRef();
	// if only height is set, the content area's height needs to be adapted  (should be a rare use-case)
	if (!sap.ui.commons.AccordionSection._isSizeSet(this.getParent().getWidth()) && sap.ui.commons.AccordionSection._isSizeSet(this.getMaxHeight())) {
		if (cont) {
			var contTop = cont.offsetTop;
			var targetHeight = (root.offsetHeight - contTop);
			cont.style.height = targetHeight + "px";

			var actualContHeight = cont.offsetHeight;
			if (actualContHeight > targetHeight) {
				cont.style.height = targetHeight - (actualContHeight - targetHeight) + "px";
			}
		}

	}

	var leftBorder	= jQuery(accordion).css("border-left-width");
	var rightBorder = jQuery(accordion).css("border-right-width");


	var borderTotal = parseFloat(leftBorder.substring(0, leftBorder.indexOf("px") )) + parseFloat(rightBorder.substring(0, rightBorder.indexOf("px") ));
	var oDomLabel = this.getDomRef("lbl");
	root.style.width = accordion.offsetWidth - borderTotal + "px";
	oDomLabel.style.width = accordion.offsetWidth - 30 + "px";

	//Bind the scroll event (does not bubble)
	var fnScrollProxy = this.__scrollproxy__;
	if (!fnScrollProxy) {
		fnScrollProxy = this.__scrollproxy__ = jQuery.proxy(this.onscroll, this);
	}
	this.$("cont").bind("scroll", fnScrollProxy);

};

sap.ui.commons.AccordionSection.prototype.onBeforeRendering = function() {
	var fnScrollProxy = this.__scrollproxy__;
	if (fnScrollProxy) {
		this.$("cont").unbind("scroll", fnScrollProxy);
	}
};

/**
 * Property setter for the "enabled" state
 *
 * @param {boolean} bEnabled Whether the AccordionSection should be enabled, or not
 * @return {sap.ui.commons.AccordionSection} 'this' to allow method chaining
 * @public
 */
sap.ui.commons.AccordionSection.prototype.setEnabled = function(bEnabled) {
	this.setProperty("enabled", bEnabled, true); // no re-rendering!
	var root = this.getDomRef();
	if (root) {
		// if already rendered, adapt rendered control without complete re-rendering
		if (bEnabled) {
			jQuery(root).removeClass("sapUiAcdSectionDis");
		} else {
			jQuery(root).addClass("sapUiAcdSectionDis");
		}
	}
	return this;
};


/**
 * Property setter for the "collapsed" state
 *
 * @param bCollapsed Whether the AccordionSection should be collapsed, or not
 * @private
 */
sap.ui.commons.AccordionSection.prototype._setCollapsed = function(bCollapsed) {
	this.setProperty("collapsed", bCollapsed, true); // no re-rendering!
	this._setCollapsedState(bCollapsed); // adapt rendered control without complete re-rendering
};

/**
 * Property setter for the "collapsed" state
 *
 * @param {boolean} bCollapsed Whether the AccordionSection should be collapsed, or not
 * @return {sap.ui.commons.AccordionSection} 'this' to allow method chaining
 * @public
 */
sap.ui.commons.AccordionSection.prototype.setCollapsed = function(bCollapsed) {
	if(this.getParent()){

		if(!bCollapsed){
			this.getParent().openSection(this.getId());
		}
		else{
			this.getParent().closeSection(this.getId());
		}
	}
	else{
		this._setCollapsed(bCollapsed);
	}
	return this;
};


/**
 * Internal method for applying a "collapsed" state to the rendered HTML
 *
 * @param bCollapsed Whether the AccordionSection should be collapsed, or not
 * @private
 */
sap.ui.commons.AccordionSection.prototype._setCollapsedState = function(bCollapsed) {

	if (this.getDomRef()) {
		// after AccordionSection has been rendered
		if (bCollapsed) {
			var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();

			// collapsing
			if (!this.getParent().getWidth()) {
				this.getDomRef().style.width = this.getDomRef().offsetWidth + "px"; // maintain the current width
			}
			jQuery(this.getDomRef()).addClass("sapUiAcdSectionColl");
			var tb = this.getDomRef("tb");
			if (tb) {
				tb.style.display = "none";
			}

			var cont = this.getDomRef("cont");
			cont.style.display = "none";
			if (accessibility) {
				cont.setAttribute("aria-expanded", "false");
				cont.setAttribute("aria-hidden", "true");
			}

			this.rerender();

		} else {
			// expanding
			if (!this.getDomRef("cont")) {
				// content has not been rendered yet, so render it now
				this.rerender(); // TODO: potentially restore focus to collapse icon/button
			} else {
				// content exists already, just make it visible again
				jQuery(this.getDomRef()).removeClass("sapUiAcdSectionColl");
				var tb = this.getDomRef("tb");
				if (tb) {
					tb.style.display = "block";
				}

				var cont = this.getDomRef("cont");
				cont.style.display = "block";
				if (accessibility) {
					cont.setAttribute("aria-expanded", "true");
				}

				if (this.getMaxHeight()) {
					this.getDomRef().style.height = this.getMaxHeight(); // restore the set height
				}
			}
		}
	}
}


/**
 * Static method that finds out whether the given CSS size is actually set.
 * Returns "true" for absolute and relative sizes, returns "false" if "null", "inherit" or "auto" is given.
 *
 * @static
 * @param sCssSize A CSS size string which must be a valid CSS size, or null
 * @private
 */;
sap.ui.commons.AccordionSection._isSizeSet = function(sCssSize) {
	return (sCssSize && !(sCssSize =="auto") && !(sCssSize == "inherit"));
}


/*   Event Handling   */

/**
 * Handles any "triggering" actions like click and space
 *
 * @param {jQuery.Event} oEvent
 * @private
 */;
sap.ui.commons.AccordionSection.prototype._handleTrigger = function(oEvent) {
	// minimize button toggled
	if((oEvent.target.id === this.getId() + "-minL") ||
			(oEvent.target.id === this.getId() + "-minR")) {
		var bCollapsed = !this.getProperty("collapsed");
		this._setCollapsed(bCollapsed);
		oEvent.preventDefault();
		oEvent.stopPropagation();
	}
};

/**
 * Handles the scroll event of the browser
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.AccordionSection.prototype.onscroll = function (oEvent) {
	/**
	if (this.bIgnoreScrollEvent) { // bIgnoreScrollEvent is set to "true" if the scrollbar is moved via API calls
		this.bIgnoreScrollEvent = false;
		return;
	}
	var oDomRef = this.getDomRef();
	if (oDomRef) {
		this.fireScroll(oDomRef.scrollTop, oDomRef.scrollLeft);
	}
	 */
};
}; // end of sap/ui/commons/AccordionSection.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ApplicationHeader') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.ApplicationHeader.
jQuery.sap.declare("sap.ui.commons.ApplicationHeader");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ApplicationHeader.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getLogoSrc logoSrc} : sap.ui.core.URI</li>
 * <li>{@link #getLogoText logoText} : string</li>
 * <li>{@link #getDisplayLogoff displayLogoff} : boolean (default: true)</li>
 * <li>{@link #getUserName userName} : string</li>
 * <li>{@link #getDisplayWelcome displayWelcome} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.ApplicationHeader#event:logoff logoff} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The application header control stands on the top of any application page. It consists basically of 4 areas. Logo area/Function area provided by application/Search area/Logout area
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.ApplicationHeader
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.ApplicationHeader", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"logoSrc" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
		"logoText" : {type : "string", group : "Misc", defaultValue : null},
		"displayLogoff" : {type : "boolean", group : "Misc", defaultValue : true},
		"userName" : {type : "string", group : "Misc", defaultValue : null},
		"displayWelcome" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	events : {
		"logoff" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.ApplicationHeader with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.ApplicationHeader.extend
 * @function
 */

sap.ui.commons.ApplicationHeader.M_EVENTS = {'logoff':'logoff'};


/**
 * Getter for property <code>logoSrc</code>.
 * Path (src) to the logo icon to be displayed in the application header.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>logoSrc</code>
 * @public
 * @name sap.ui.commons.ApplicationHeader#getLogoSrc
 * @function
 */

/**
 * Setter for property <code>logoSrc</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sLogoSrc  new value for property <code>logoSrc</code>
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ApplicationHeader#setLogoSrc
 * @function
 */


/**
 * Getter for property <code>logoText</code>.
 * The text that will be displayed beside the logo in the application header. This property is optional.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>logoText</code>
 * @public
 * @name sap.ui.commons.ApplicationHeader#getLogoText
 * @function
 */

/**
 * Setter for property <code>logoText</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sLogoText  new value for property <code>logoText</code>
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ApplicationHeader#setLogoText
 * @function
 */


/**
 * Getter for property <code>displayLogoff</code>.
 * If set to true, the logoff area will be displayed at the right hand side of the application header.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>displayLogoff</code>
 * @public
 * @name sap.ui.commons.ApplicationHeader#getDisplayLogoff
 * @function
 */

/**
 * Setter for property <code>displayLogoff</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bDisplayLogoff  new value for property <code>displayLogoff</code>
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ApplicationHeader#setDisplayLogoff
 * @function
 */


/**
 * Getter for property <code>userName</code>.
 * User name that will be displayed beside the welcome text
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>userName</code>
 * @public
 * @name sap.ui.commons.ApplicationHeader#getUserName
 * @function
 */

/**
 * Setter for property <code>userName</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sUserName  new value for property <code>userName</code>
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ApplicationHeader#setUserName
 * @function
 */


/**
 * Getter for property <code>displayWelcome</code>.
 * By default, set to true and dislpays the welcome text
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>displayWelcome</code>
 * @public
 * @name sap.ui.commons.ApplicationHeader#getDisplayWelcome
 * @function
 */

/**
 * Setter for property <code>displayWelcome</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bDisplayWelcome  new value for property <code>displayWelcome</code>
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ApplicationHeader#setDisplayWelcome
 * @function
 */


/**
 * Fires an event to log off the user from the application.
 * No parameters.
 *
 * @name sap.ui.commons.ApplicationHeader#logoff
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'logoff' event of this <code>sap.ui.commons.ApplicationHeader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.ApplicationHeader</code>.<br/> itself. 
 *  
 * Fires an event to log off the user from the application.
 * No parameters.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.ApplicationHeader</code>.<br/> itself.
 *
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ApplicationHeader#attachLogoff
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'logoff' event of this <code>sap.ui.commons.ApplicationHeader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ApplicationHeader#detachLogoff
 * @function
 */

/**
 * Fire event logoff to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.ApplicationHeader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.ApplicationHeader#fireLogoff
 * @function
 */


// Start of sap\ui\commons\ApplicationHeader.js
///**
// * This file defines behavior for the control,
// */
sap.ui.commons.ApplicationHeader.prototype.init = function(){
	this.initializationDone = false;
};

sap.ui.commons.ApplicationHeader.prototype.exit = function() {
	this.oLogo && this.oLogo.destroy();
	this.oLogoText && this.oLogoText.destroy();
	this.oLogoffBtn && this.oLogoffBtn.destroy();
};

/**
 * Create the composite parts out of the current settings.
 * Called by the renderer just before rendering
 * @private
 */
sap.ui.commons.ApplicationHeader.prototype.initControls = function() {

	//Application header to build sub-controls ids
	var appHeaderId = this.getId();

	//Get the texts from the resources bundle
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	//Create the logo image control and the title (textView) control
	this.oLogo && this.oLogo.destroy();
	this.oLogo = new sap.ui.commons.Image(appHeaderId + "-logoImg");
	this.oLogo.setTooltip(rb.getText("APPHDR_LOGO_TOOLTIP"));
	this.oLogo.setParent(this);
	this.oLogoText && this.oLogoText.destroy();
	this.oLogoText = new sap.ui.commons.TextView(appHeaderId + "-logoText");
	this.oLogoText.setAccessibleRole(sap.ui.core.AccessibleRole.Heading);
	this.oLogoText.setParent(this);

	//Log off button
	this.oLogoffBtn && this.oLogoffBtn.destroy();
	this.oLogoffBtn = new sap.ui.commons.Button(appHeaderId + "-logoffBtn");
	var sLogOffText = rb.getText("APPHDR_LOGOFF");
	this.oLogoffBtn.setText(sLogOffText);
	this.oLogoffBtn.setTooltip(sLogOffText);
	this.oLogoffBtn.attachPress(this.logoff,this);
	this.oLogoffBtn.setParent(this);
	this.oLogoffBtn.setLite(true);
}


/**
*  This event is fired when the user clicks on the Log Off button
*  @param oEvent The event triggered
*  @private
*/;
sap.ui.commons.ApplicationHeader.prototype.logoff = function(oEvent){
	this.fireLogoff();
};


// ---- Overwritten property setters to make sure the full area is rerendered correctly ----

sap.ui.commons.ApplicationHeader.prototype.setLogoSrc = function(sLogoSrc) {
	this.initializationDone = false;
	this.setProperty("logoSrc", sLogoSrc);
	return this;
};

sap.ui.commons.ApplicationHeader.prototype.setLogoText = function(sLogoText) {
	this.initializationDone = false;
	this.setProperty("logoText", sLogoText);
	return this;
};

sap.ui.commons.ApplicationHeader.prototype.setUserName = function(sUserName){
	this.initializationDone = false;
	this.setProperty("userName", sUserName);
	return this;
};

sap.ui.commons.ApplicationHeader.prototype.setDisplayWelcome = function(bDisplayWelcome) {
	this.initializationDone = false;
	this.setProperty("displayWelcome", bDisplayWelcome);
	return this;
};

sap.ui.commons.ApplicationHeader.prototype.setDisplayLogoff = function(bDisplayLogoff) {
	this.initializationDone = false;
	this.setProperty("displayLogoff", bDisplayLogoff);
	return this;
};
}; // end of sap/ui/commons/ApplicationHeader.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Area') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Area.
jQuery.sap.declare("sap.ui.commons.Area");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new Area.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getShape shape} : string</li>
 * <li>{@link #getCoords coords} : string</li>
 * <li>{@link #getHref href} : sap.ui.core.URI</li>
 * <li>{@link #getAlt alt} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Used for defining areas in an image map. At runtime, the user can trigger an action, or start a URL, from the single image areas.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Area
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.commons.Area", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"shape" : {type : "string", group : "Misc", defaultValue : null},
		"coords" : {type : "string", group : "Misc", defaultValue : null},
		"href" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
		"alt" : {type : "string", group : "Misc", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Area with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Area.extend
 * @function
 */


/**
 * Getter for property <code>shape</code>.
 * The value is a string and can be 'rect' for rectangle, 'poly' for poligon, 'circle', or default.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>shape</code>
 * @public
 * @name sap.ui.commons.Area#getShape
 * @function
 */

/**
 * Setter for property <code>shape</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sShape  new value for property <code>shape</code>
 * @return {sap.ui.commons.Area} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Area#setShape
 * @function
 */


/**
 * Getter for property <code>coords</code>.
 * Coordinates of the area
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>coords</code>
 * @public
 * @name sap.ui.commons.Area#getCoords
 * @function
 */

/**
 * Setter for property <code>coords</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sCoords  new value for property <code>coords</code>
 * @return {sap.ui.commons.Area} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Area#setCoords
 * @function
 */


/**
 * Getter for property <code>href</code>.
 * Hyper link that is executed when the area is clicked
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>href</code>
 * @public
 * @name sap.ui.commons.Area#getHref
 * @function
 */

/**
 * Setter for property <code>href</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sHref  new value for property <code>href</code>
 * @return {sap.ui.commons.Area} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Area#setHref
 * @function
 */


/**
 * Getter for property <code>alt</code>.
 * Alternative text that is displayed in the case the image is not available
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>alt</code>
 * @public
 * @name sap.ui.commons.Area#getAlt
 * @function
 */

/**
 * Setter for property <code>alt</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAlt  new value for property <code>alt</code>
 * @return {sap.ui.commons.Area} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Area#setAlt
 * @function
 */


// Start of sap\ui\commons\Area.js
///**
// * This file defines behavior for the control,
// */
//sap.ui.dev.Area.prototype.init = function(){
//   // do something for initialization...
//};

/**
 * Function is called when Link is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Area.prototype.onclick = function(oEvent) {

	// The Element or Control that initiated the event. For example the id of the area if image map is defined for the current image.
	var oEventSource = jQuery(oEvent.target).control(0);

    // Fire event on Image Map
	this.getParent().firePress({areaId: oEventSource.getId()});
};
}; // end of sap/ui/commons/Area.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Button') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Button.
jQuery.sap.declare("sap.ui.commons.Button");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Button.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string (default: '')</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHelpId helpId} : string (default: '')</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI (default: '')</li>
 * <li>{@link #getIconHovered iconHovered} : sap.ui.core.URI (default: '')</li>
 * <li>{@link #getIconSelected iconSelected} : sap.ui.core.URI (default: '')</li>
 * <li>{@link #getIconFirst iconFirst} : boolean (default: true)</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize</li>
 * <li>{@link #getStyled styled} : boolean (default: true)</li>
 * <li>{@link #getLite lite} : boolean (default: false)</li>
 * <li>{@link #getStyle style} : sap.ui.commons.ButtonStyle (default: sap.ui.commons.ButtonStyle.Default)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getAriaDescribedBy ariaDescribedBy} : string | sap.ui.core.Control</li>
 * <li>{@link #getAriaLabelledBy ariaLabelledBy} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.Button#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Enables users to trigger actions such as save or print. For the button UI, you can define some text or an icon, or both.
 * @extends sap.ui.core.Control
 * @implements sap.ui.commons.ToolbarItem
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Button
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Button", { metadata : {

	interfaces : [
		"sap.ui.commons.ToolbarItem"
	],
	publicMethods : [
		// methods
		"focus"
	],
	library : "sap.ui.commons",
	properties : {
		"text" : {type : "string", group : "Appearance", defaultValue : ''},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "", defaultValue : true},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"helpId" : {type : "string", group : "Behavior", defaultValue : ''},
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},
		"iconHovered" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},
		"iconSelected" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},
		"iconFirst" : {type : "boolean", group : "Appearance", defaultValue : true},
		"height" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"styled" : {type : "boolean", group : "Appearance", defaultValue : true},
		"lite" : {type : "boolean", group : "Appearance", defaultValue : false},
		"style" : {type : "sap.ui.commons.ButtonStyle", group : "Appearance", defaultValue : sap.ui.commons.ButtonStyle.Default}
	},
	associations : {
		"ariaDescribedBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
		"ariaLabelledBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
	},
	events : {
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Button with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Button.extend
 * @function
 */

sap.ui.commons.Button.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>text</code>.
 * 
 * Button text displayed at runtime.
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.commons.Button#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setText
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * 
 * Boolean property to enable the control (default is true). Buttons that are disabled have other colors than enabled ones, depending on custom settings.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.Button#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * 
 * Invisible buttons are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.Button#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setVisible
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * 
 * Control width as common CSS-size (px or % as unit, for example)
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.Button#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setWidth
 * @function
 */


/**
 * Getter for property <code>helpId</code>.
 * 
 * Unique identifier used for help service
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>helpId</code>
 * @public
 * @name sap.ui.commons.Button#getHelpId
 * @function
 */

/**
 * Setter for property <code>helpId</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sHelpId  new value for property <code>helpId</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setHelpId
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * Icon to be displayed as graphical element within the button.
 * This can be an URI to an image or an icon font URI.
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.commons.Button#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setIcon
 * @function
 */


/**
 * Getter for property <code>iconHovered</code>.
 * Icon to be displayed as graphical element within the button when it is hovered (only if also a base icon was specified). If not specified the base icon is used.
 * If a icon font icon is used, this property is ignored.
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>iconHovered</code>
 * @public
 * @name sap.ui.commons.Button#getIconHovered
 * @function
 */

/**
 * Setter for property <code>iconHovered</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.URI} sIconHovered  new value for property <code>iconHovered</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setIconHovered
 * @function
 */


/**
 * Getter for property <code>iconSelected</code>.
 * Icon to be displayed as graphical element within the button when it is selected (only if also a base icon was specified). If not specified the base or hovered icon is used.
 * If a icon font icon is used, this property is ignored.
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>iconSelected</code>
 * @public
 * @name sap.ui.commons.Button#getIconSelected
 * @function
 */

/**
 * Setter for property <code>iconSelected</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.URI} sIconSelected  new value for property <code>iconSelected</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setIconSelected
 * @function
 */


/**
 * Getter for property <code>iconFirst</code>.
 * 
 * If set to true (default), the display sequence is 1. icon 2. control text .
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>iconFirst</code>
 * @public
 * @name sap.ui.commons.Button#getIconFirst
 * @function
 */

/**
 * Setter for property <code>iconFirst</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bIconFirst  new value for property <code>iconFirst</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setIconFirst
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * Specifies the button height. If this property is set, the height which is specified by the underlying theme is not used any longer.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.ui.commons.Button#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setHeight
 * @function
 */


/**
 * Getter for property <code>styled</code>.
 * Indicates if the button is styled. If not it is rendered as native HTML-button. In this case a custom styling can be added usig addStyleClass.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>styled</code>
 * @public
 * @name sap.ui.commons.Button#getStyled
 * @function
 */

/**
 * Setter for property <code>styled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bStyled  new value for property <code>styled</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setStyled
 * @function
 */


/**
 * Getter for property <code>lite</code>.
 * The button is rendered as lite button.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>lite</code>
 * @public
 * @name sap.ui.commons.Button#getLite
 * @function
 */

/**
 * Setter for property <code>lite</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bLite  new value for property <code>lite</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setLite
 * @function
 */


/**
 * Getter for property <code>style</code>.
 * Style of the button.
 * (e.g. emphasized)
 *
 * Default value is <code>sap.ui.commons.ButtonStyle.Default</code>
 *
 * @return {sap.ui.commons.ButtonStyle} the value of property <code>style</code>
 * @public
 * @name sap.ui.commons.Button#getStyle
 * @function
 */

/**
 * Setter for property <code>style</code>.
 *
 * Default value is <code>sap.ui.commons.ButtonStyle.Default</code> 
 *
 * @param {sap.ui.commons.ButtonStyle} oStyle  new value for property <code>style</code>
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#setStyle
 * @function
 */


/**
 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.Button#getAriaDescribedBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaDescribedBy
 *    Id of a ariaDescribedBy which becomes an additional target of this <code>ariaDescribedBy</code> association.
 *    Alternatively, a ariaDescribedBy instance may be given. 
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#addAriaDescribedBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaDescribedBy the ariaDescribedBy to remove or its index or id
 * @return {string} the id of the removed ariaDescribedBy or null
 * @public
 * @name sap.ui.commons.Button#removeAriaDescribedBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Button#removeAllAriaDescribedBy
 * @function
 */

	
/**
 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.Button#getAriaLabelledBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaLabelledBy
 *    Id of a ariaLabelledBy which becomes an additional target of this <code>ariaLabelledBy</code> association.
 *    Alternatively, a ariaLabelledBy instance may be given. 
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#addAriaLabelledBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaLabelledBy the ariaLabelledBy to remove or its index or id
 * @return {string} the id of the removed ariaLabelledBy or null
 * @public
 * @name sap.ui.commons.Button#removeAriaLabelledBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Button#removeAllAriaLabelledBy
 * @function
 */

	
/**
 * 
 * Event is fired when the user presses the control.
 *
 * @name sap.ui.commons.Button#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.commons.Button</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Button</code>.<br/> itself. 
 *  
 * 
 * Event is fired when the user presses the control.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Button</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.commons.Button</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Button#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.Button} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.Button#firePress
 * @function
 */


/**
 * Puts the focus to the button.
 *
 * @name sap.ui.commons.Button#focus
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\Button.js
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


sap.ui.core.EnabledPropagator.call(sap.ui.commons.Button.prototype);

/**
 * Function is called when button is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onclick = function(oEvent) {
	if (this.getEnabled()){
		this.firePress({/* no parameters */});
	}

	oEvent.preventDefault();
	oEvent.stopPropagation();
};

/**
 * Handles the sapenter event does not bubble
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onsapenter = function(oEvent) {
	oEvent.stopPropagation();
};

/**
 * Function is called when mouse key is clicked down. The button style classes
 * are replaced then.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onmousedown = function(oEvent) {
	this.handleMouseDown(oEvent, true);
};

/**
 * Function to handle the mouse down event.
 *
 * @param {jQuery.Event} oEvent The causing event.
 * @param {boolean} [bFocus=false] Whether to set the focus on the selected element in a delayed call.
 * @private
 */
sap.ui.commons.Button.prototype.handleMouseDown = function(oEvent, bFocus) {
	if (this.getEnabled() && this.getRenderer().onactive) {
		this.getRenderer().onactive(this);
	}
	// webkit && firefox on mac does not focus a Button on click, it even unfocuses it onmousedown!
	if (bFocus && (!!sap.ui.Device.browser.webkit || (!!sap.ui.Device.browser.firefox && navigator.platform.indexOf("Mac") === 0))) { 
		if(sap.ui.Device.browser.mobile && !!sap.ui.Device.browser.webkit){
			//In mobile Webkit Browsers (IPad) the focus must be set immediately to ensure that a focusout happens whereever the
			//focus currently is. The deleayedCall below is still needed due to the reason described above. (CSN 2536817 2012)
			this.focus();
		}
		jQuery.sap.delayedCall(0, this, function(){
			this.focus();
		}); 
	}
};

/**
 * When mouse key is up again, reset the background images to normal.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onmouseup = function(oEvent) {
	if (this.getEnabled() && this.getRenderer().ondeactive) {
		this.getRenderer().ondeactive(this);
	}
};

/**
 * When mouse is going out of the control, reset the background images to normal.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onmouseout = function(oEvent) {
	if (this.getEnabled() && this.getRenderer().onmouseout) {
		this.getRenderer().onmouseout(this);
	}
};

/**
 * When mouse is going over the control a hover effect is done.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onmouseover = function(oEvent) {
	if (this.getEnabled() && this.getRenderer().onmouseover) {
		this.getRenderer().onmouseover(this);
	}
};

/**
 * When the button looses the focus, this method is called.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onfocusout = function(oEvent) {
	if (this.getEnabled() && this.getRenderer().onblur) {
		this.getRenderer().onblur(this);
	}
};

/**
 * When the button gets the focus, this method is called.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Button.prototype.onfocusin = function(oEvent) {
	if (this.getEnabled() && this.getRenderer().onfocus) {
		this.getRenderer().onfocus(this);
	}
};

/*
 * If Icon has just changed don't rerender.
 */
sap.ui.commons.Button.prototype.setIcon = function(sIcon) {

	this._setIcon(sIcon, "icon");

	return this;

};

sap.ui.commons.Button.prototype.setIconHovered = function(sIcon) {

	this._setIcon(sIcon, "iconHovered");

	return this;

};

sap.ui.commons.Button.prototype.setIconSelected = function(sIcon) {

	this._setIcon(sIcon, "iconSelected");

	return this;

};

/*
 * helper function to set different icons
 */
sap.ui.commons.Button.prototype._setIcon = function(sIcon, sProperty) {

	var sIconOld = this.getProperty(sProperty);

	if (sIconOld == sIcon) {
		// icon not changed -> nothing to do
		return;
	}

	var bUseIconFontOld = false;
	if (sap.ui.core.IconPool.isIconURI(sIconOld)) {
		bUseIconFontOld = true;
	}

	var bUseIconFontNew = false;
	if (sap.ui.core.IconPool.isIconURI(sIcon)) {
		bUseIconFontNew = true;
	}

	var bSupressRerender = true;
	if ((!sIconOld && sIcon) || (sIconOld && !sIcon) || (bUseIconFontOld != bUseIconFontNew)) {
		// Icon new added or removed -> need to rerender
		bSupressRerender = false;
	}

	this.setProperty(sProperty, sIcon, bSupressRerender);

	if (bSupressRerender == true && this.getDomRef() && this.getRenderer().changeIcon) {
		this.getRenderer().changeIcon(this);
	}

};

}; // end of sap/ui/commons/Button.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CalloutBase') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.CalloutBase.
jQuery.sap.declare("sap.ui.commons.CalloutBase");

jQuery.sap.require('sap.ui.core.TooltipBase'); // unlisted dependency retained



/**
 * Constructor for a new CalloutBase.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.CalloutBase#event:open open} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.commons.CalloutBase#event:close close} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.commons.CalloutBase#event:beforeOpen beforeOpen} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.commons.CalloutBase#event:opened opened} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.TooltipBase#constructor sap.ui.core.TooltipBase}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * CalloutBase is a building block for Callout. Do not use it directly. Use the Callout control instead
 * @extends sap.ui.core.TooltipBase
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.CalloutBase
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.TooltipBase.extend("sap.ui.commons.CalloutBase", { metadata : {

	publicMethods : [
		// methods
		"adjustPosition", "close", "setPosition"
	],
	library : "sap.ui.commons",
	events : {
		"open" : {}, 
		"close" : {}, 
		"beforeOpen" : {allowPreventDefault : true}, 
		"opened" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.CalloutBase with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.CalloutBase.extend
 * @function
 */

sap.ui.commons.CalloutBase.M_EVENTS = {'open':'open','close':'close','beforeOpen':'beforeOpen','opened':'opened'};


/**
 * The event is fired when the popup is opened.
 *
 * @name sap.ui.commons.CalloutBase#open
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.core.Control} oControlEvent.getParameters.parent Parent control that has this Callout as a tooltip
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'open' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself. 
 *  
 * The event is fired when the popup is opened.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself.
 *
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CalloutBase#attachOpen
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'open' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CalloutBase#detachOpen
 * @function
 */

/**
 * Fire event open to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'parent' of type <code>sap.ui.core.Control</code> Parent control that has this Callout as a tooltip</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.CalloutBase#fireOpen
 * @function
 */


/**
 * Event is fired when the Callout window is closed.
 *
 * @name sap.ui.commons.CalloutBase#close
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'close' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself. 
 *  
 * Event is fired when the Callout window is closed.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself.
 *
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CalloutBase#attachClose
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'close' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CalloutBase#detachClose
 * @function
 */

/**
 * Fire event close to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.CalloutBase#fireClose
 * @function
 */


/**
 * Event is fired before a Callout is displayed. Call the preventDefault method of the event object to postpone opening. Application may use this event to start asynchronous Ajax call to load the Callout content
 *
 * @name sap.ui.commons.CalloutBase#beforeOpen
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.core.Control} oControlEvent.getParameters.parent Parent control that has this Callout as a tooltip
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'beforeOpen' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself. 
 *  
 * Event is fired before a Callout is displayed. Call the preventDefault method of the event object to postpone opening. Application may use this event to start asynchronous Ajax call to load the Callout content
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself.
 *
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CalloutBase#attachBeforeOpen
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'beforeOpen' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CalloutBase#detachBeforeOpen
 * @function
 */

/**
 * Fire event beforeOpen to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'parent' of type <code>sap.ui.core.Control</code> Parent control that has this Callout as a tooltip</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.commons.CalloutBase#fireBeforeOpen
 * @function
 */


/**
 * Is fired when the Callout has been opened
 *
 * @name sap.ui.commons.CalloutBase#opened
 * @event
 * @since 1.11.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'opened' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself. 
 *  
 * Is fired when the Callout has been opened
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.CalloutBase</code>.<br/> itself.
 *
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.0
 * @name sap.ui.commons.CalloutBase#attachOpened
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'opened' event of this <code>sap.ui.commons.CalloutBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.0
 * @name sap.ui.commons.CalloutBase#detachOpened
 * @function
 */

/**
 * Fire event opened to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @protected
 * @since 1.11.0
 * @name sap.ui.commons.CalloutBase#fireOpened
 * @function
 */


/**
 * Adjust position of the already opened Callout window.
 * Call this method each time when the size of the opened
 * Callout window may be changed due to new or changed
 * contents.
 *
 * @name sap.ui.commons.CalloutBase#adjustPosition
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Closes Callout
 *
 * @name sap.ui.commons.CalloutBase#close
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Helper function to set position of the Callout window relative to the parent control. It automatically calculates and sets the correct offset, so it is recommended to use this function instead of setMyPosition and setAtPosition
 *
 * @name sap.ui.commons.CalloutBase#setPosition
 * @function
 * @param {sap.ui.core.Dock} sMyPosition
 *         Docking position of the Callout
 * @param {sap.ui.core.Dock} sAtPosition
 *         Docking position of the Callout
 * @type sap.ui.commons.CalloutBase
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\CalloutBase.js
///**
// * This file defines behavior for the Callout control
// */

/**
 * Initializes a new callout base.
 * Overrides default popup placement and offset of the TooltipBase control
 *
 * @private
 */
sap.ui.commons.CalloutBase.prototype.init = function() {
	this.oPopup = new sap.ui.core.Popup();
	this.oPopup.setShadow(true);
	
	// resource bundle
	this.oRb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	// override the default position and offset of TooltipBase:
	this.setPosition(sap.ui.core.Popup.Dock.BeginBottom, sap.ui.core.Popup.Dock.BeginTop);

	// listen to global events outside of the callout to close it when needed
	this.fAnyEventHandlerProxy = jQuery.proxy(this.onAnyEvent, this);

	// make this.oPopup call this.setTip each time after its position is changed
	var that = this;
	this.oPopup._applyPosition = function(oPosition){
		sap.ui.core.Popup.prototype._applyPosition.call(this, oPosition);
		that.setTip();
	};
	
	// enable the Callout to fix its position when scolling occurs
	this.oPopup.setFollowOf(true);
};

/**
 * Destroys this instance of the callout, called by Element#destroy()
 * @private
 */
sap.ui.commons.CalloutBase.prototype.exit = function() {
	this.oPopup.close();
	this.oPopup.detachEvent("opened", this.handleOpened, this);
	this.oPopup.detachEvent("closed", this.handleClosed, this);
	this.oPopup.destroy();
	delete this.oPopup;
	delete this.oRb;
	jQuery.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);
};

/**
 * Return the popup to use. Each callout has own popup.
 * (Allow multiple call-outs taking into account pin-up functionality in the next version).
 * Overrides {@link sap.ui.core.TooltipBase} that has a single common popup for all instances.
 * @type sap.ui.core.Popup
 * @return The popup to use
 * @private
 */
sap.ui.commons.CalloutBase.prototype._getPopup = function(){
	return this.oPopup;
};

/**
 * Check if the given DOM reference is child of this control
 * @param {oDOMNode}
 * DOM node reference
 * @private
 */
sap.ui.commons.CalloutBase.prototype.hasChild = function(oDOMNode) {
	return oDOMNode && !!(jQuery(oDOMNode).closest(this.getDomRef()).length);
};

/**
 * Check if the given DOM reference is part of a SAPUI5 popup
 * @param {oDOMNode}
 * DOM node reference
 * @private
 */
sap.ui.commons.CalloutBase.prototype.isPopupElement = function(oDOMNode) {
	if(!oDOMNode){ return false; }
	if(this.hasChild(oDOMNode)){ return true; }

	var oStatic = sap.ui.getCore().getStaticAreaRef();
	// if oDOMNode belongs to a static area child, get z-index of this child:
	var thatZ = parseInt(jQuery(oDOMNode).closest(jQuery(oStatic).children()).css("z-index"), 10);
	// z-index of this:
	var thisZ = parseInt(this.$().css("z-index"), 10);

	// true if the element has the z-index inside of static area that is higher as the z-index of my control
	return thatZ && thisZ && thatZ >= thisZ;
};

/**
 * Set tip arrow below or above the callout window depending on the popup placement
 * @private
 */
sap.ui.commons.CalloutBase.prototype.setTip = function() {

	if (!this.oPopup || !this.oPopup.isOpen()) {
		return;
	}

	var $parent = this._currentControl.$(),
		$this = this.$(),
		$arrow = this.$("arrow"),
		$offset = $this.offset(),
		$pOffset = $parent.offset(),
		bShow = true,
		dock = {},
		tRect = {
			l:$offset.left,
			r:$offset.left+$this.outerWidth(),
			w:$this.outerWidth(),
			t:$offset.top,
			b:$offset.top+$this.outerHeight(),
			h:$this.outerHeight()
		},
		pRect = {
			l:$pOffset.left,
			r:$pOffset.left+$parent.outerWidth(),
			w:$parent.outerWidth(),
			t:$pOffset.top,
			b:$pOffset.top+$parent.outerHeight(),
			h:$parent.outerHeight()
		},
		borderWidth = ($this.outerWidth() - $this.innerWidth()) / 2,
		arrowWidth = $arrow.outerWidth() * 1.4,
		aw = $arrow.outerWidth() / 5, // (width*sqrt(2)-width)/2
		tipOffset = aw - borderWidth - 8, // offset of the tip to the border should be 8px
		myPosition = this.getMyPosition();

	// right-left pointer
	if ( tRect.r < pRect.l - tipOffset ){ dock.x = "right"; }
	else if ( tRect.l - tipOffset > pRect.r ){ dock.x = "left"; }

	// top-bottom pointer
	if ( tRect.t > pRect.b - tipOffset ){ dock.y = "top"; }
	else if ( tRect.b < pRect.t + tipOffset ){ dock.y = "bottom"; }

	if(dock.x){ // pointer on the left or right side

		var vPos = 0;
		// Set the vertical position of the pointer, relative to callout:
		//   dock top: top, dock bottom: bottom, dock center: center
		if(myPosition.indexOf("top") > -1){
			vPos = 20;
		} else if (myPosition.indexOf("bottom") > -1){
			vPos = tRect.h - 20 - arrowWidth;
		} else { // center
			vPos = (tRect.h -arrowWidth) / 2;
		}

		// adjust if it points outside of the parent or the parent is too small
		// - put it into the middle of intersection
		var tipY = tRect.t + vPos + arrowWidth / 2 + borderWidth;
		if( (tipY < pRect.t) || (tipY > pRect.b) || (pRect.t > tRect.t && pRect.b < tRect.b)){
			vPos = (Math.max(tRect.t, pRect.t) + Math.min(tRect.b, pRect.b))/2 - tRect.t -  arrowWidth / 2;
		}

		if(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8 && dock.x == "left"){
			tipOffset = tipOffset - 8;
		}
		$arrow.css(dock.x, tipOffset + "px");
		$arrow.css("top", vPos);

		// do not show pointer if it cannot be placed inside
		if( vPos < 0 || vPos > tRect.h - arrowWidth){
			bShow = false;
		}
	}

	if(dock.y){ // pointer on the top or bottom border
		// switch right to left in case of RTL for the relevant docking (begin & end):
		var bRtl = sap.ui.getCore().getConfiguration().getRTL();
		if(bRtl){ myPosition.replace("begin", "right").replace("end", "left"); }
		var hPos = 0;

		// Set horizontal position of the pointer, relative to callout:
		//   dock left: left, dock right: right, dock center: center
		if((myPosition.indexOf("begin") > -1) || (myPosition.indexOf("left") > -1)){
			hPos = 20;
		} else if ((myPosition.indexOf("right") > -1) || (myPosition.indexOf("end") > -1)){
			hPos = tRect.w - 20 - arrowWidth;
		} else { // center
			hPos = (tRect.w -arrowWidth) / 2;
		}

		// adjust if it points outside of the parent - put it into the middle of intersection
		var tipX = tRect.l + hPos + arrowWidth / 2 + borderWidth;
		if( (tipX < pRect.l) || (tipX > pRect.r)){
			hPos = (Math.max(tRect.l, pRect.l) + Math.min(tRect.r, pRect.r))/2 - tRect.l - arrowWidth / 2;
		}

		if(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8 && dock.y == "top"){
			tipOffset = tipOffset - 8;
		}
		$arrow.css(dock.y, tipOffset + "px");
		$arrow.css("left", hPos + "px");

		// do not show pointer if it cannot be placed inside
		if( hPos < 0 || hPos > tRect.w - arrowWidth){
			bShow = false;
		}
	}

	if(dock.x && dock.y || !dock.x && !dock.y){ bShow = false; }

	// hide if the pointer cannot be shown
	$arrow.toggle(bShow);
};

sap.ui.commons.CalloutBase.prototype.adjustPosition = function() {

	function _adjust(){
		// adjust popup position
		if (this.oPopup) {
			var oParentDomRef = this._currentControl.getDomRef();
			this.oPopup.setPosition(this.getMyPosition(), this.getAtPosition(), oParentDomRef, this.getOffset(), this.getCollision());
		}
	}

	setTimeout( jQuery.proxy( _adjust, this ), 0 );
};

/**
 * @see sap.ui.core.Element.prototype.focus As the callout itself is just a
 *      frame, focus the first focusable content
 * @private
 */
sap.ui.commons.CalloutBase.prototype.focus = function() {
	if(this.oPopup && this.oPopup.isOpen()){
		// Focus the first focusable child. If the callout is empty, focus the content container div.
		// Empty callout should be focused too because the contents may appear at a later time point
		// and we need input focus to react to the ESC key.
		var $Content = this.$("cont");
		jQuery.sap.focus($Content.firstFocusableDomRef() || $Content.get(0));
	}
};

/**
 * Open the callout window.
 *
 * @param {sap.ui.core.Control}
 *       parent control that contains the callout
 * @private
 */
sap.ui.commons.CalloutBase.prototype.openPopup = function(oSC) {

	if(!this.oPopup || this.oPopup.isOpen()){ 
		return;
	}

	if (sap.ui.core.TooltipBase.sOpenTimeout) {
		jQuery.sap.clearDelayedCall(sap.ui.core.TooltipBase.sOpenTimeout);
		sap.ui.core.TooltipBase.sOpenTimeout = undefined;
	}

	// TODO this._parentControl member not defined! Can't we use oSC instead?
	// fire the "beforeOpen" event and delay display of the Callout if the application requests this
	if(!this.fireEvent("beforeOpen", {parent:this._currentControl}, true, false)){
		if(!this.sCloseNowTimeout){
			// postpone opening for 200ms
			sap.ui.core.TooltipBase.sOpenTimeout = jQuery.sap.delayedCall(200, this, "openPopup", [this._currentControl]);
		}
		return;
	};

	// save parent focus info to be restored after close
	this.oParentFocusInfo = oSC.getFocusInfo();

	this.oPopup.attachEvent("opened", this.handleOpened, this);

	// use TooltipBase to open the pop-up
	sap.ui.core.TooltipBase.prototype.openPopup.call(this, oSC);

	this.adjustPosition();

	this.fireOpen({ parent : this._currentControl });
};

/**
 * Close the Callout popup.
 *
 * @public
 */
sap.ui.commons.CalloutBase.prototype.close = function() {
	if(this.oPopup && this.oPopup.isOpen() && !this.sCloseNowTimeout){
		if (sap.ui.core.TooltipBase.sOpenTimeout) {
			jQuery.sap.clearDelayedCall(sap.ui.core.TooltipBase.sOpenTimeout);
			sap.ui.core.TooltipBase.sOpenTimeout = undefined;
		}
		this.closePopup();
	}
};

/**
 * Close CalloutBase. Fire the close event.
 *
 * @private
 */
sap.ui.commons.CalloutBase.prototype.closePopup = function() {
	var bWasOpen = this.oPopup !== undefined && this.oPopup.isOpen();

	if(this.fAnyEventHandlerProxy){
		jQuery.sap.unbindAnyEvent(this.onAnyEvent);
	}

	// This also attaches the handleClosed function to the closed-event
	sap.ui.core.TooltipBase.prototype.closePopup.call(this);

	// Set focus to the parent control.
	// Accessibility requirement: a focused Callout should set focus to its parent after close,
	// and not to a control where it could be found originally (In the scenario when a Callout
	// is opened on hover and a control inside it was clicked on with the mouse. This would
	// implicitly mean that a user has moved focus to the parent control intentionally)
	if (bWasOpen && this._currentControl && this.bFocused) {
		this._currentControl.applyFocusInfo(this.oParentFocusInfo);
		this.bFocused = false;
	}

	// inform the application
	this.fireClose();
};

/**
 * Attaches the Callout to the Popup's closed-event and forwards it accordingly to the attached listeners
 * @private
 */
sap.ui.commons.CalloutBase.prototype.handleClosed = function(){
	if (this.oPopup){
		this.oPopup.detachEvent("closed", this.handleClosed, this);
		this.fireClosed();
	}
};

/**
 * Handle the key down event for ESCAPE and Ctrl-I.
 *
 * @param {jQuery.Event}
 *            oEvent - the event that occurred on the Parent of the Callout.
 * @private
 */
sap.ui.commons.CalloutBase.prototype.onkeydown = function(oEvent) {

	var bCtrlI = oEvent.ctrlKey && oEvent.which == jQuery.sap.KeyCodes.I;
	var bEsc = oEvent.which == jQuery.sap.KeyCodes.ESCAPE;

	if(!bCtrlI && !bEsc){
		if(jQuery(oEvent.target).control(0) === this._currentControl){
			// Close callout by any key press on the parent control except for Ctrl-I
			this.close();
		}
		return;
	}

	// do not try to open the same callout twice
	if (bCtrlI) {
		if (this.oPopup && this.oPopup.isOpen()){
			return; // this is already opened
		}
		this.bDoFocus = true; // accessibility: request focus
	}

	// let the TooltipBase remove/set standard tooltips and open/close the popup
	sap.ui.core.TooltipBase.prototype.onkeydown.call(this, oEvent);
};

/**
 * If the callout has been opened with a keyboard command, the mouse
 * pointer is most probably outside: the callout does not receive any
 * mouseover and mouseout events. Arrange a global mousemove listener
 * temporarily.
 * Use case: accessibility testing; advanced users that prefer to work with
 * keyboard instead of mouse.
 *
 * @private
 */
sap.ui.commons.CalloutBase.prototype.handleOpened = function() {
	this.oPopup.detachEvent("opened", this.handleOpened, this);

	// The following is needed only of the callout was opened with the keyboard:
	// - request focus (accessibility requirement)
	if (this.bDoFocus) {
		this.focus();
		this.bDoFocus = false;
		this.bFocused = true; // Remember to set focus to parent on close
	}
	
	this.$().css("display:", "");
	this.fireOpened();
	
	// - listen to mouse over events outside
	//   do always because the Callout can lose focus to child popup controls
	jQuery.sap.bindAnyEvent(this.fAnyEventHandlerProxy);
};

/**
 * Event handler for the focusin event.
 * Organize a local tab chain inside of a callout.
 * If it occurs on the focus handler elements at the beginning of the callout,
 * the focus is set to the end, and vice versa.
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.CalloutBase.prototype.onfocusin = function(oEvent){

	// Some element has been focused inside of the popup.
	// Focus will be set to the parent after popup close.
	this.bFocused = true;

	var oSourceDomRef = oEvent.target;

	// The same logic as in the Dialog.control:
	if (oSourceDomRef.id === this.getId() + "-fhfe") {
		// the FocusHandlingFirstElement was focused and thus the focus should move to the last element.
		jQuery.sap.focus(this.$("cont").lastFocusableDomRef());
	} else if (oSourceDomRef.id === this.getId() + "-fhee") {
		// the FocusHandlingEndElement was focused and thus the focus should move to the first element.
		jQuery.sap.focus(this.$("cont").firstFocusableDomRef());
	}
};

/**
 * When a control that has a Callout looses the focus to the Callout contents,
 * do not close it. Override the onfocusout event handler of TooltipBalse.
 * @param {jQuery.EventObject} the event indication that the focus is lost
 * @private
 */
sap.ui.commons.CalloutBase.prototype.onfocusout = function(oEvent) {
	return;
};

/**
* Handle the mouseover event: do not close if a child control has a simple tooltip
* @param {jQuery.EventObject} oEvent The event that occurred in the callout
* @private
 */
sap.ui.commons.CalloutBase.prototype.onmouseover = function(oEvent) {
	// do not close my pop-up if it was opened already
	if (this.oPopup && (this.oPopup.isOpen() && this.oPopup.getContent() == this)) {
		if (this.sCloseNowTimeout){
			jQuery.sap.clearDelayedCall(this.sCloseNowTimeout);
			this.sCloseNowTimeout = null; }
		return;
	} else {
		sap.ui.core.TooltipBase.prototype.onmouseover.call(this, oEvent);
	}
};

/**
 * Handle the mouseout event of a Callout. Override the default TooltipBase behavior when 
 * the mouse pointer is over some other popup on the screen
 * @param {jQuery.EventObject} oEvent mouseout Event.
 * @private
 */
sap.ui.commons.CalloutBase.prototype.onmouseout = function(oEvent) {
	// Do not close callout when the mouse goes to a popup (like menu)
	if(this.oPopup && (this.oPopup.isOpen() && this.isPopupElement(oEvent.relatedTarget))) {
		return;
	}
	sap.ui.core.TooltipBase.prototype.onmouseout.call(this, oEvent);
};

/**
 * Always close Callout when the user clicks on the parent control.
 * @param {jQuery.EventObject} the event
 * @private
 */
sap.ui.commons.CalloutBase.prototype.onmousedown = function(oEvent) {
	if(jQuery(oEvent.target).control(0) === this._currentControl){
		this.close();
	}
};

/**
 * Handles the outer event of the popup.
 * @param {sap.ui.core.Event} oControlEvent The event
 * @private
 */
sap.ui.commons.CalloutBase.prototype.onAnyEvent = function(oEvent){

	if((this.oPopup && !this.oPopup.isOpen()) || oEvent.type != "mouseover" || this.hasChild(oEvent.target)) {
		return;
	}

	// do not close if the hovered element is a top level popup or it is the parent of the callout
	var bDoNotClose = this.isPopupElement(oEvent.target) || jQuery(oEvent.target).control(0) === this._currentControl;
	if(!bDoNotClose && !this.sCloseNowTimeout && !sap.ui.core.TooltipBase.sOpenTimeout){
		// schedule close if mouse moved outside of the Popup
		this.sCloseNowTimeout = jQuery.sap.delayedCall(400, this, "closePopup");
	}
	if (bDoNotClose && this.sCloseNowTimeout) {
		// do not close when inside
		jQuery.sap.clearDelayedCall(this.sCloseNowTimeout);
		this.sCloseNowTimeout = null;
	}
};

/**
 * Set position of the Callout window relative to the parent control.
 * This function automatically calculates and sets the correct offset,
 * use it instead of <code>setMyPosition/setAtPosition</code>.
 * @param {sap.ui.core.Popup.Dock} myPosition docking position of the Callout
 * @param {sap.ui.core.Popup.Dock} atPosition docking position of the parent control
 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.CalloutBase.prototype.setPosition = function(myPosition, atPosition){

	var myPos = myPosition || sap.ui.core.Popup.Dock.BeginBottom;
	var atPos = atPosition || sap.ui.core.Popup.Dock.BeginTop;

	var myX = 0, myY = 0, atX = 0, atY = 0, gap = 5;

	if((myPos.indexOf("begin") > -1) || (myPos.indexOf("left") > -1)){
		myX = -1;
	} else if ((myPos.indexOf("right") > -1) || (myPos.indexOf("end") > -1)){
		myX = 1;
	}

	if((atPos.indexOf("begin") > -1) || (atPos.indexOf("left") > -1)){
		atX = -1;
	} else if ((atPos.indexOf("right") > -1) || (atPos.indexOf("end") > -1)){
		atX = 1;
	}

	if(myPos.indexOf("top") > -1){
		myY = -1;
	} else if (myPos.indexOf("bottom") > -1){
		myY = 1;
	}

	if(atPos.indexOf("top") > -1){
		atY = -1;
	} else if (atPos.indexOf("bottom") > -1){
		atY = 1;
	}

	var offset = ((myX - atX) * myX * atX * gap) + " " + ((myY - atY) * myY * atY * gap);

	this.setMyPosition(myPos);
	this.setAtPosition(atPos);
	this.setOffset(offset);

	return this;
};


}; // end of sap/ui/commons/CalloutBase.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Carousel') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Carousel.
jQuery.sap.declare("sap.ui.commons.Carousel");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Carousel.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getOrientation orientation} : sap.ui.commons.enums.Orientation (default: sap.ui.commons.enums.Orientation.horizontal)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize</li>
 * <li>{@link #getDefaultItemHeight defaultItemHeight} : int (default: 150)</li>
 * <li>{@link #getDefaultItemWidth defaultItemWidth} : int (default: 150)</li>
 * <li>{@link #getAnimationDuration animationDuration} : int (default: 500)</li>
 * <li>{@link #getVisibleItems visibleItems} : int</li>
 * <li>{@link #getHandleSize handleSize} : int (default: 22)</li>
 * <li>{@link #getFirstVisibleIndex firstVisibleIndex} : int (default: 0)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Carousel holds multiple controls and displays them vertical or horizontal next to each other. You can define how many content items should be displayed at once or let the carousel determine that for you. Navigation is done through buttons or keys.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.8.0
 * @name sap.ui.commons.Carousel
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Carousel", { metadata : {

	publicMethods : [
		// methods
		"showNext", "showPrevious", "showElementWithId"
	],
	library : "sap.ui.commons",
	properties : {
		"orientation" : {type : "sap.ui.commons.enums.Orientation", group : "Misc", defaultValue : sap.ui.commons.enums.Orientation.horizontal},
		"width" : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},
		"height" : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},
		"defaultItemHeight" : {type : "int", group : "Misc", defaultValue : 150},
		"defaultItemWidth" : {type : "int", group : "Misc", defaultValue : 150},
		"animationDuration" : {type : "int", group : "Misc", defaultValue : 500},
		"visibleItems" : {type : "int", group : "Misc", defaultValue : null},
		"handleSize" : {type : "int", group : "Misc", defaultValue : 22},
		"firstVisibleIndex" : {type : "int", group : "Appearance", defaultValue : 0}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content", bindable : "bindable"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Carousel with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Carousel.extend
 * @function
 */


/**
 * Getter for property <code>orientation</code>.
 * Can be either "horizontal" or "vertical"
 *
 * Default value is <code>horizontal</code>
 *
 * @return {sap.ui.commons.enums.Orientation} the value of property <code>orientation</code>
 * @public
 * @name sap.ui.commons.Carousel#getOrientation
 * @function
 */

/**
 * Setter for property <code>orientation</code>.
 *
 * Default value is <code>horizontal</code> 
 *
 * @param {sap.ui.commons.enums.Orientation} oOrientation  new value for property <code>orientation</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setOrientation
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Width of carousel
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.Carousel#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setWidth
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * Height of carousel
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.ui.commons.Carousel#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setHeight
 * @function
 */


/**
 * Getter for property <code>defaultItemHeight</code>.
 * Default height of item in carousel if no height can be determined
 *
 * Default value is <code>150</code>
 *
 * @return {int} the value of property <code>defaultItemHeight</code>
 * @public
 * @name sap.ui.commons.Carousel#getDefaultItemHeight
 * @function
 */

/**
 * Setter for property <code>defaultItemHeight</code>.
 *
 * Default value is <code>150</code> 
 *
 * @param {int} iDefaultItemHeight  new value for property <code>defaultItemHeight</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setDefaultItemHeight
 * @function
 */


/**
 * Getter for property <code>defaultItemWidth</code>.
 * Default width of item in carousel if no height can be determined
 *
 * Default value is <code>150</code>
 *
 * @return {int} the value of property <code>defaultItemWidth</code>
 * @public
 * @name sap.ui.commons.Carousel#getDefaultItemWidth
 * @function
 */

/**
 * Setter for property <code>defaultItemWidth</code>.
 *
 * Default value is <code>150</code> 
 *
 * @param {int} iDefaultItemWidth  new value for property <code>defaultItemWidth</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setDefaultItemWidth
 * @function
 */


/**
 * Getter for property <code>animationDuration</code>.
 * Duration for animation when navigating through children
 *
 * Default value is <code>500</code>
 *
 * @return {int} the value of property <code>animationDuration</code>
 * @public
 * @name sap.ui.commons.Carousel#getAnimationDuration
 * @function
 */

/**
 * Setter for property <code>animationDuration</code>.
 *
 * Default value is <code>500</code> 
 *
 * @param {int} iAnimationDuration  new value for property <code>animationDuration</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setAnimationDuration
 * @function
 */


/**
 * Getter for property <code>visibleItems</code>.
 * If defined, the carousel displays the number of items defined. Items will be resized to fit the area.
 *
 * Default value is <code></code>
 *
 * @return {int} the value of property <code>visibleItems</code>
 * @public
 * @name sap.ui.commons.Carousel#getVisibleItems
 * @function
 */

/**
 * Setter for property <code>visibleItems</code>.
 *
 * Default value is <code></code> 
 *
 * @param {int} iVisibleItems  new value for property <code>visibleItems</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setVisibleItems
 * @function
 */


/**
 * Getter for property <code>handleSize</code>.
 * Size of the handle in pixels. (Height for vertical carousel, width for horizontal carousel)
 *
 * Default value is <code>22</code>
 *
 * @return {int} the value of property <code>handleSize</code>
 * @public
 * @name sap.ui.commons.Carousel#getHandleSize
 * @function
 */

/**
 * Setter for property <code>handleSize</code>.
 *
 * Default value is <code>22</code> 
 *
 * @param {int} iHandleSize  new value for property <code>handleSize</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#setHandleSize
 * @function
 */


/**
 * Getter for property <code>firstVisibleIndex</code>.
 * The index of the element in the content aggreation which is displayed first on rendering
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>firstVisibleIndex</code>
 * @public
 * @since 1.11.0
 * @name sap.ui.commons.Carousel#getFirstVisibleIndex
 * @function
 */

/**
 * Setter for property <code>firstVisibleIndex</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iFirstVisibleIndex  new value for property <code>firstVisibleIndex</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.0
 * @name sap.ui.commons.Carousel#setFirstVisibleIndex
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Controls which are displayed inside the carousel
 * 
 * <strong>Note</strong>: this is the default aggregation for Carousel.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.commons.Carousel#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.commons.Carousel#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Carousel#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.Carousel#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#destroyContent
 * @function
 */


/**
 * Binder for aggregation <code>content</code>.
 *
 * @param {string} sPath path to a list in the model 
 * @param {sap.ui.core.Element} oTemplate the control template for this aggregation
 * @param {sap.ui.model.Sorter} oSorter the initial sort order (optional)
 * @param {array} aFilters the predefined filters for this aggregation (optional)
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#bindContent
 * @function
 */

/**
 * Unbinder for aggregation <code>content</code>.
 *
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Carousel#unbindContent
 * @function
 */


/**
 * Shows next item in carousel. This can be only used after the component is rendered.
 *
 * @name sap.ui.commons.Carousel#showNext
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Shows previous item in carousel. This can be only used after the component is rendered.
 *
 * @name sap.ui.commons.Carousel#showPrevious
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Shows the element with id specified. This can be only used after the component is rendered.
 *
 * @name sap.ui.commons.Carousel#showElementWithId
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\Carousel.js
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained


/**
 * Initialize the carousel control
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.init = function() {
	this._visibleItems = 0;
};

/**
 * Clean up control when it is destroyed
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.exit = function() {
	// Cleanup resize event registration on exit
	if (this.sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);
		this.sResizeListenerId = null;
	}
	this._destroyItemNavigation();
};

/**
 * If one of the navigation buttons is clicked we trigger the navigation
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onclick = function(oEvent) {
	var sCarouselId = this.getId();

	switch (oEvent.target) {
	case jQuery.sap.byId(sCarouselId + '-prevbutton')[0]:
		this.showPrevious();
		break;
	case jQuery.sap.byId(sCarouselId + '-nextbutton')[0]:
		this.showNext();
		break;
	default:
		return;
	}
};

/**
 * Used for before-rendering initialization.
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onBeforeRendering = function() {
	// Cleanup resize event registration before re-rendering
	if (this.sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);
		this.sResizeListenerId = null;
	}
};

/**
 * Used for after-rendering initialization.
 *
 * @private
 */
sap.ui.commons.Carousel.prototype.onAfterRendering = function() {
	// Define which attribute needs to be animated
	if (this.getOrientation() == "vertical") {
		this._sAnimationAttribute = 'margin-top';
	} else {
		if (sap.ui.getCore().getConfiguration().getRTL()) {
			this._sAnimationAttribute = 'margin-right';
		} else {
			this._sAnimationAttribute = 'margin-left';
		}
	}

	this.showElementWithId(this._getItemIdByIndex(this.getFirstVisibleIndex()));

	this.calculateAndSetSize();
	this.oDomRef = this.getDomRef();
	this.sResizeListenerId = sap.ui.core.ResizeHandler.register(this.oDomRef, jQuery.proxy(this.onresize, this));
	
	this._initItemNavigation();
};

/**
 * Initialize item navigation
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype._initItemNavigation = function() {
	var $this = this.$();
	var $scrollList = this.$("scrolllist");

	if (!this._oItemNavigation) {
		this._oItemNavigation = new sap.ui.core.delegate.ItemNavigation();
		this._oItemNavigation.setCycling(true);
		this.addDelegate(this._oItemNavigation);
		//Setting focus on next to an invisible element changes the scollPosition and messes up correct display
		//So after setting the focus, we need to reset the left scrollpos
		this._oItemNavigation.attachEvent(sap.ui.core.delegate.ItemNavigation.Events.AfterFocus, function(oEvent) {
			var $ContentArea = this.$("contentarea"),
				$ScrollList = this.$("scrolllist");

			// ItemNavigation should only handle keyboard, do not set the focus on a carousel item if clicked on control inside
			var oOrgEvent = oEvent.getParameter("event");
			if (oOrgEvent && oOrgEvent.type == "mousedown") {
				var bItem = false;
				for ( var i = 0; i < $ScrollList.children().length; i++) {
					var oItem = $ScrollList.children()[i];
					if (oOrgEvent.target.id == oItem.id) {
						bItem = true;
						break;
					}
				}
				if (!bItem) {
					// something inside carousel item clicked -> focus this one
					oOrgEvent.target.focus();
				}
			}

			if (sap.ui.getCore().getConfiguration().getRTL()) {
				$ContentArea.scrollLeft($ScrollList.width()  - $ContentArea.width());
			} else {
				$ContentArea.scrollLeft(0);
			}
		}, this);
	}

	this._oItemNavigation.setRootDomRef($scrollList[0]);
	this._oItemNavigation.setItemDomRefs($scrollList.children());
}

/**
 * Destroy item navigation
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype._destroyItemNavigation = function() {
	if (this._oItemNavigation) {
		this._oItemNavigation.destroy();
		this._oItemNavigation = undefined;
	}
}

/**
 * Called after the theme has been switched. Some adjustments required.
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onThemeChanged = function (oEvent) {
	this.calculateAndSetSize();
};

/**
 * Focus in handling
 * handles the focus when you tab into the control
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onfocusin = function(oEvent) {
	var $target = jQuery(oEvent.target);
	// KEYBOARD HANDLING (_bIgnoreFocusIn is set in onsaptabXXX)
	if (!this._bIgnoreFocusIn && ($target.hasClass("sapUiCrslBefore") || $target.hasClass("sapUiCrslAfter"))) {
		// when entering the before or after helper DOM elements we put the
		// focus on the current focus element of the item navigation and we
		// leave the action mode!
		this._leaveActionMode();
		// set the focus on the last focused dom ref of the item navigation or
		// in case if not set yet (tab previous into item nav) then we set the
		// focus to the root domref
		jQuery(this._oItemNavigation.getFocusedDomRef() || this._oItemNavigation.getRootDomRef()).focus();
	}
};

/**
 * If we are in action mode we only allow tabbing within the selected element
 * else we focus on the next element in the tab chain (not in the carousel item)
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onsaptabnext = function(oEvent) {
	var $this = this.$();
	if (this._bActionMode) {
		if ($this.find(".sapUiCrslScl").lastFocusableDomRef() === oEvent.target) {
			$this.find(".sapUiCrslScl").firstFocusableDomRef().focus();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	} else {
		if (this._oItemNavigation.getFocusedDomRef() === oEvent.target) {
			this._bIgnoreFocusIn = true;
			$this.find(".sapUiCrslAfter").focus();
			this._bIgnoreFocusIn = false;
		}
	}
};

/**
 * If we are in action mode we only allow tabbing within the selected element
 * else we focus on the previous element in the tab chain (not in the carousel item)
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onsaptabprevious = function(oEvent) {
	var $this = this.$();
	if (this._bActionMode) {
		if ($this.find(".sapUiCrslScl").firstFocusableDomRef() === oEvent.target) {
			$this.find(".sapUiCrslScl").lastFocusableDomRef().focus();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	} else {
		if (this._oItemNavigation.getFocusedDomRef() === oEvent.target &&
				jQuery.sap.containsOrEquals($this.find(".sapUiCrslScl").get(0), oEvent.target)) {
			this._bIgnoreFocusIn = true;
			$this.find(".sapUiCrslBefore").focus();
			this._bIgnoreFocusIn = false;
		}
	}
};

/**
 * handle the ESCAPE key to leave the action mode
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onsapescape = function(oEvent) {
	this._leaveActionMode(oEvent);
};

/**
 * Trigger the navigation to the next item and stop current animations (if available)
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onsapnext = function(oEvent) {
	var $target = jQuery(oEvent.target);
	var $ScrollList = this.$("scrolllist");
	$ScrollList.stop(true, true);
	if ($target.hasClass('sapUiCrslItm') && $target.nextAll(':visible').length < 2) {
		this.showNext();
		oEvent.preventDefault();
	}
};

/**
 * Trigger the navigation to the previous item and stop current animations (if available)
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onsapprevious = function(oEvent) {
	var $target = jQuery(oEvent.target);
	var $ScrollList = this.$("scrolllist");
	$ScrollList.stop(true, true);
	if ($target.hasClass('sapUiCrslItm') && $target.prevAll(':visible').length < 2) {
		this.showPrevious();
		oEvent.preventDefault();
	}
};

/**
 * If in action mode and F2 is pressed we leave the action mode
 * If not in action mode and F2 or enter is pressed we enter the action mode
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onkeydown = function(oEvent) {
	var $this = this.$();
	if (!this._bActionMode &&
		oEvent.keyCode == jQuery.sap.KeyCodes.F2 ||
		oEvent.keyCode == jQuery.sap.KeyCodes.ENTER) {
		if ($this.find(".sapUiCrslScl li:focus").length > 0) {
			this._enterActionMode($this.find(".sapUiCrslScl li:focus :sapFocusable").get(0));
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	} else if (this._bActionMode &&
		oEvent.keyCode == jQuery.sap.KeyCodes.F2) {
		this._leaveActionMode(oEvent);
	} 
};

/**
 * Handle clicking into elements
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype.onmouseup = function(oEvent) {
	if (this.$().find(".sapUiCrslScl li :focus").length > 0) {
		// when clicking into a focusable control we enter the action mode!
		this._enterActionMode(this.$().find(".sapUiCrslScl li :focus").get(0));
	} else {
		// when clicking anywhere else in the table we leave the action mode!
		this._leaveActionMode(oEvent);
	}
};

if (sap.ui.Device.support.touch) {
	
	sap.ui.commons.Carousel.prototype.onswipeleft = function(oEvent) {
		this.showNext();
	};
	
	sap.ui.commons.Carousel.prototype.onswiperight = function(oEvent) {
		this.showPrevious();
	};

}


/**
 * Enter action mode
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype._enterActionMode = function(oDomRef) {
	// only enter the action mode when not already in action mode
	if (oDomRef && !this._bActionMode) {

		// in the action mode we need no item navigation
		this._bActionMode = true;
		this.removeDelegate(this._oItemNavigation);

		// remove the tab index from the item navigation
		jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "-1");
		
		//set aria active descendent
		this.$("scrolllist").attr("aria-activedescendant", jQuery(this._oItemNavigation.getFocusedDomRef()).attr("id"));

		// set the focus to the active control
		jQuery(oDomRef).focus();
	}
};

/**
 * Leave action mode
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype._leaveActionMode = function(oEvent) {
	if (this._bActionMode) {

		// in the navigation mode we use the item navigation
		this._bActionMode = false;
		this.addDelegate(this._oItemNavigation);

		// reset the tabindex of the focused domref of the item navigation
		jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "0");

		//remove aria active descendent
		this.$("scrolllist").removeAttr("aria-activedescendant");

		// when we have an event which is responsible to leave the action mode
		// we search for the closest
		if (oEvent) {
			if (jQuery(oEvent.target).closest("li[tabindex=-1]").length > 0) {
				// triggered when clicking into an item, then we focus the item
				var iIndex = jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(oEvent.target).closest("li[tabindex=-1]").get(0));
				this._oItemNavigation.focusItem(iIndex, null);
			} else {
				// somewhere else means whe check if the click happend inside
				// the container, then we focus the last focused element
				if (jQuery.sap.containsOrEquals(this.$().find(".sapUiCrslScl").get(0), oEvent.target)) {
					this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
				}
			}
		} else {
			// when no event is given we just focus the last focused index
			this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
		}
	}
};

/**
 * Function is called when window is resized
 *
 * @param {jQuery.Event}
 *            oEvent
 * @private
 */
sap.ui.commons.Carousel.prototype.onresize = function(oEvent) {
	if (!this.getDomRef()) {
		// carousel is not rendered, maybe deleted from DOM -> deregister resize
		// handler and do nothing
		// Cleanup resize event registration on exit
		if (this.sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
		return;
	}

	this.calculateAndSetSize();
};

/**
 * Slide to previous element
 *
 * @public
 */
sap.ui.commons.Carousel.prototype.showPrevious = function() {
	var mAnimationArguments = {};
	mAnimationArguments[this._sAnimationAttribute] = 0;
	var $ScrollList = this.$("scrolllist");
	var $ContentArea = this.$("contentarea");
	if ($ScrollList.children('li').length < 2) {
		return;
	}
	$ScrollList.stop(true, true);
	$ScrollList.css(this._sAnimationAttribute, -this._iMaxWidth);
	var $lastItem = $ScrollList.children('li:last');
	var $firstItem = $ScrollList.children('li:first');
	this._showAllItems();
	$lastItem.insertBefore($firstItem);
	$ScrollList.append($lastItem.sapExtendedClone(true));
	var me = this;
	$ScrollList.animate(mAnimationArguments, this.getAnimationDuration(), function() {
			$ScrollList.children('li:last').remove();
			me.setProperty("firstVisibleIndex", me._getContentIndex($ScrollList.children('li:first').attr('id')), true);
			me._hideInvisibleItems();
		});
};

/**
 * Slide to next element
 *
 * @public
 */
sap.ui.commons.Carousel.prototype.showNext = function() {
	var mAnimationArguments = {};
	mAnimationArguments[this._sAnimationAttribute] = -this._iMaxWidth;
	var $ScrollList = this.$("scrolllist");
	var $ContentArea = this.$("contentarea");
	if ($ScrollList.children('li').length < 2) {
		return;
	}
	$ScrollList.stop(true, true);
	this._showAllItems();
	var sAnimationAttribute = this._sAnimationAttribute;
	var me = this;
	var $firstItem = $ScrollList.children('li:first');
	$firstItem.appendTo($ScrollList);
	$firstItem.sapExtendedClone(true).insertBefore($ScrollList.children('li:first'));
	$ScrollList.animate(mAnimationArguments, this.getAnimationDuration(), function() {
			$ScrollList.children('li:first').remove();
			jQuery(this).css(sAnimationAttribute, '0px');
			me.setProperty("firstVisibleIndex", me._getContentIndex($ScrollList.children('li:first').attr('id')), true);
			me._hideInvisibleItems();
		});
};

/**
 * Slide to specific element
 *
 * @public
 * @param {string} sElementId
 */
sap.ui.commons.Carousel.prototype.showElementWithId = function(sElementId) {
	this._showAllItems();
	var $ScrollList = this.$("scrolllist");
	sElementId = this.getId() + "-item-" + sElementId;
	var index = $ScrollList.children('li').index(jQuery.sap.byId(sElementId));
	$ScrollList.children('li:lt(' + index + ')').appendTo($ScrollList);
	this._hideInvisibleItems();
};

sap.ui.commons.Carousel.prototype.calculateAndSetSize = function() {
	var aContent = this.getContent();
	var sCarouselId = this.getId();

	this._showAllItems();

	if (aContent.length > 0) {
		var maxWidth = 0;
		var maxHeight = 0;

		for ( var i = 0; i < aContent.length; i++) {
			var childWidth, childHeight;
			try {
				childWidth = aContent[i].getWidth();
				if (childWidth.substr(-1) == "%") {
					childWidth = this.getDefaultItemWidth();
				}
			} catch (e) {
				childWidth = this.getDefaultItemWidth();
			}
			try {
				childHeight = aContent[i].getHeight();
				if (childHeight.substr(-1) == "%") {
					childHeight = this.getDefaultItemHeight();
				}
			} catch (e) {
				childHeight = this.getDefaultItemHeight();
			}
			maxWidth = Math.max(maxWidth, parseInt(childWidth, 10));
			maxHeight = Math.max(maxHeight, parseInt(childHeight, 10));
		}

		if (maxWidth == 0 || isNaN(maxWidth)) {
			maxWidth = this.getDefaultItemWidth();
		}
		if (maxHeight == 0 || isNaN(maxHeight)) {
			maxHeight = this.getDefaultItemHeight();
		}

		var contentBarSize;
		var visibleItems = this.getVisibleItems();
		var $Me = jQuery.sap.byId(sCarouselId);
		var $NextButton = jQuery.sap.byId(sCarouselId + '-nextbutton');
		var $PrevButton = jQuery.sap.byId(sCarouselId + '-prevbutton');
		var $ContentArea = jQuery.sap.byId(sCarouselId + '-contentarea');

		if (this.getWidth() && this.getOrientation() == "vertical") {
			maxWidth = $Me.width();
		}
		if (this.getHeight() && this.getOrientation() == "horizontal") {
			maxHeight = $Me.height();
		}

		this.$().addClass('sapUiCrsl' + jQuery.sap.charToUpperCase(this.getOrientation(), 0));

		if (this.getOrientation() == "horizontal") {
			contentBarSize = $Me.width() - this.getHandleSize() * 2 - 1;
			$ContentArea.css('left', this.getHandleSize() + "px").css('right', this.getHandleSize() + "px");

			if (visibleItems == 0) {
				visibleItems = Math.floor(contentBarSize / maxWidth);
			}

			maxWidth = contentBarSize / visibleItems;
			this._iMaxWidth = maxWidth;

			var cLineHeight = maxHeight + "px";
			$ContentArea.find('.sapUiCrslItm').css("width", maxWidth + "px").css("height", maxHeight + "px");
			$PrevButton.css("height", maxHeight).css("line-height", cLineHeight);
			$NextButton.css("height", maxHeight).css("line-height", cLineHeight);
			$ContentArea.height(maxHeight);
			$Me.height(maxHeight);
		} else {
			contentBarSize = $Me.height() - this.getHandleSize() * 2 - 1;
			$ContentArea.css('top', this.getHandleSize() + "px").css('bottom', this.getHandleSize() + "px");

			if (visibleItems == 0) {
				visibleItems = Math.floor(contentBarSize / maxHeight);
			}

			maxHeight = contentBarSize / visibleItems;
			this._iMaxWidth = maxHeight;

			$ContentArea.find('.sapUiCrslItm').css("width", maxWidth + "px").css("height", maxHeight + "px");
			$PrevButton.width(maxWidth).after($ContentArea);
			$NextButton.width(maxWidth);
			$ContentArea.width(maxWidth);
			$Me.width(maxWidth);
		}
		this._visibleItems = visibleItems;
		this._hideInvisibleItems();
	}
};

sap.ui.commons.Carousel.prototype.getFocusDomRef = function() {
	return this.oContentArea;
};

/**
 * Make all carousel items visible
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype._showAllItems = function() {
	var $ContentArea = this.$("contentarea");
	$ContentArea.find('.sapUiCrslItm').show();
};

/**
 * Hide all carousel items
 * 
 * @private
 */
sap.ui.commons.Carousel.prototype._hideInvisibleItems = function() {
	var $ContentArea = this.$("contentarea");
	$ContentArea.find('.sapUiCrslItm:gt(' + (this._visibleItems - 1)  + ')').hide();
};

sap.ui.commons.Carousel.prototype._getContentIndex = function(sId) {
	var aIdParts = sId.split("-item-");
	return jQuery.inArray(sap.ui.getCore().byId(aIdParts[1]), this.getContent());
};

sap.ui.commons.Carousel.prototype._getItemIdByIndex = function(iIndex) {
	var oContent = this.getContent()[iIndex];
	if (!oContent) {
		return null;
	}
	return oContent.getId();
};

/**
 * Setter for property <code>firstVisibleIndex</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iFirstVisibleIndex  new value for property <code>firstVisibleIndex</code>
 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.0
 * @name sap.ui.commons.Carousel#setFirstVisibleIndex
 * @function
 */
sap.ui.commons.Carousel.prototype.setFirstVisibleIndex = function(iFirstVisibleIndex) {
	if (iFirstVisibleIndex > this.getContent().length - 1) {
		jQuery.sap.log.warning("The index is invalid. There are less items available in the carousel.");
		return this;
	}
	this.setProperty("firstVisibleIndex", iFirstVisibleIndex, true);
	this.showElementWithId(this._getItemIdByIndex(iFirstVisibleIndex));
	if (this._oItemNavigation) {
		this._oItemNavigation.focusItem(iFirstVisibleIndex);
	}
	return this;
};


//Fix because jQuery clone doesn't support cloning textarea values
//jQuery Ticket #3016 (http://bugs.jquery.com/ticket/3016)

//Textarea and select clone() bug workaround | Spencer Tipping
//Licensed under the terms of the MIT source code license

//Motivation.
//jQuery's clone() method works in most cases, but it fails to copy the value of textareas and select elements. This patch replaces jQuery's clone() method with a wrapper that fills in the
//values after the fact.

//An interesting error case submitted by Piotr Przybył: If two <select> options had the same value, the clone() method would select the wrong one in the cloned box. The fix, suggested by Piotr
//and implemented here, is to use the selectedIndex property on the <select> box itself rather than relying on jQuery's value-based val().

(function (original) {
	jQuery.fn.sapExtendedClone = function () {
		var result           = original.apply(this, arguments);
		var my_textareas     = this.find('textarea').add(this.filter('textarea'));
		var result_textareas = result.find('textarea').add(result.filter('textarea'));
		var my_selects       = this.find('select').add(this.filter('select'));
		var result_selects   = result.find('select').add(result.filter('select'));

		for (var i = 0, l = my_textareas.length; i < l; ++i) {
			jQuery(result_textareas[i]).val(jQuery(my_textareas[i]).val());
		}
		for (var i = 0, l = my_selects.length;   i < l; ++i) {
			result_selects[i].selectedIndex = my_selects[i].selectedIndex;
		}

		return result;
	};
}) (jQuery.fn.clone);

}; // end of sap/ui/commons/Carousel.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CheckBox') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.CheckBox.
jQuery.sap.declare("sap.ui.commons.CheckBox");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new CheckBox.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getChecked checked} : boolean (default: false)</li>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getEditable editable} : boolean (default: true)</li>
 * <li>{@link #getValueState valueState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getTextDirection textDirection} : sap.ui.core.TextDirection (default: sap.ui.core.TextDirection.Inherit)</li>
 * <li>{@link #getName name} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getAriaDescribedBy ariaDescribedBy} : string | sap.ui.core.Control</li>
 * <li>{@link #getAriaLabelledBy ariaLabelledBy} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.CheckBox#event:change change} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * 
 * Provides a box which can be flagged, the box has a label. A check box can either stand alone, or in a group with other check boxes. As an option, the boxes can initially be set to status 'Not Editable'.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.CheckBox
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.CheckBox", { metadata : {

	publicMethods : [
		// methods
		"toggle"
	],
	library : "sap.ui.commons",
	properties : {
		"checked" : {type : "boolean", group : "Data", defaultValue : false, bindable : "bindable"},
		"text" : {type : "string", group : "Appearance", defaultValue : null},
		"visible" : {type : "boolean", group : "Misc", defaultValue : true},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"editable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"valueState" : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"textDirection" : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
		"name" : {type : "string", group : "Misc", defaultValue : null}
	},
	associations : {
		"ariaDescribedBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
		"ariaLabelledBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
	},
	events : {
		"change" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.CheckBox with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.CheckBox.extend
 * @function
 */

sap.ui.commons.CheckBox.M_EVENTS = {'change':'change'};


/**
 * Getter for property <code>checked</code>.
 * Contains the state of the control whether it is flagged with a check mark, or not
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>checked</code>
 * @public
 * @name sap.ui.commons.CheckBox#getChecked
 * @function
 */

/**
 * Setter for property <code>checked</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bChecked  new value for property <code>checked</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setChecked
 * @function
 */


/**
 * Binder for property <code>checked</code>.
 *
 * @param {string} sPath path to a property in the model 
 * @param {function} [fnFormatter=null] the formatter function
 * @param {sap.ui.model.BindingMode} [sMode=Default] the binding mode to be used for this property binding (e.g. one way) 
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#bindChecked
 * @function
 */

/**
 * Unbinder for property <code>checked</code>.
 *
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#unbindChecked
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * Defines the text displayed next to the check box
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.commons.CheckBox#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setText
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.CheckBox#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setVisible
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Using this property, the control could be disabled, if required.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.CheckBox#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setEnabled
 * @function
 */


/**
 * Getter for property <code>editable</code>.
 * Specifies whether the user shall be allowed to flag the check box
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @name sap.ui.commons.CheckBox#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setEditable
 * @function
 */


/**
 * Getter for property <code>valueState</code>.
 * Accepts the core enumeration ValueState.type that supports 'None', 'Error', 'Warning' and 'Success'.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>valueState</code>
 * @public
 * @name sap.ui.commons.CheckBox#getValueState
 * @function
 */

/**
 * Setter for property <code>valueState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oValueState  new value for property <code>valueState</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setValueState
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * The width can be set to an absolute value. If no value is set, the control width results from the text length.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.CheckBox#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setWidth
 * @function
 */


/**
 * Getter for property <code>textDirection</code>.
 * The value can be set to LTR or RTL. Otherwise, the control inherits the text direction from its parent control.
 *
 * Default value is <code>Inherit</code>
 *
 * @return {sap.ui.core.TextDirection} the value of property <code>textDirection</code>
 * @public
 * @name sap.ui.commons.CheckBox#getTextDirection
 * @function
 */

/**
 * Setter for property <code>textDirection</code>.
 *
 * Default value is <code>Inherit</code> 
 *
 * @param {sap.ui.core.TextDirection} oTextDirection  new value for property <code>textDirection</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setTextDirection
 * @function
 */


/**
 * Getter for property <code>name</code>.
 * The 'name' property to be used in the HTML code, for example for HTML forms that send data to the server via submit.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>name</code>
 * @public
 * @name sap.ui.commons.CheckBox#getName
 * @function
 */

/**
 * Setter for property <code>name</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sName  new value for property <code>name</code>
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#setName
 * @function
 */


/**
 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.CheckBox#getAriaDescribedBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaDescribedBy
 *    Id of a ariaDescribedBy which becomes an additional target of this <code>ariaDescribedBy</code> association.
 *    Alternatively, a ariaDescribedBy instance may be given. 
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#addAriaDescribedBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaDescribedBy the ariaDescribedBy to remove or its index or id
 * @return {string} the id of the removed ariaDescribedBy or null
 * @public
 * @name sap.ui.commons.CheckBox#removeAriaDescribedBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.CheckBox#removeAllAriaDescribedBy
 * @function
 */

	
/**
 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.CheckBox#getAriaLabelledBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaLabelledBy
 *    Id of a ariaLabelledBy which becomes an additional target of this <code>ariaLabelledBy</code> association.
 *    Alternatively, a ariaLabelledBy instance may be given. 
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#addAriaLabelledBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaLabelledBy the ariaLabelledBy to remove or its index or id
 * @return {string} the id of the removed ariaLabelledBy or null
 * @public
 * @name sap.ui.commons.CheckBox#removeAriaLabelledBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.CheckBox#removeAllAriaLabelledBy
 * @function
 */

	
/**
 * 
 * Event is triggered when the control status is changed by the user by flagging or unflagging the checkbox.
 *
 * @name sap.ui.commons.CheckBox#change
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {boolean} oControlEvent.getParameters.checked
 *         Checks whether the box is flagged or not flagged.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'change' event of this <code>sap.ui.commons.CheckBox</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.CheckBox</code>.<br/> itself. 
 *  
 * 
 * Event is triggered when the control status is changed by the user by flagging or unflagging the checkbox.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.CheckBox</code>.<br/> itself.
 *
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#attachChange
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'change' event of this <code>sap.ui.commons.CheckBox</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.CheckBox#detachChange
 * @function
 */

/**
 * Fire event change to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'checked' of type <code>boolean</code> 
					Checks whether the box is flagged or not flagged.
					</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.CheckBox} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.CheckBox#fireChange
 * @function
 */


/**
 * 
 * Inverts the current value of the control.
 *
 * @name sap.ui.commons.CheckBox#toggle
 * @function
 * @type sap.ui.commons.CheckBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\CheckBox.js
/**
 * Event handler called when the check box is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.CheckBox.prototype.onclick = function(oEvent) {
	//According to CSN2581852 2012 a readonly CB should be in the tabchain
	// This changed in 2013 back to not in the tabchain: see CSN 0002937527 2013
	// Let's see how often this will be changed back and forth in the future... Accessibility fun! :-D
	// End of 2013 is have to be again in the tabchain.
	// But not in the Form. But this is handled in the FromLayout control
	// Let's see what happens 2014... ;-)
	if(!!sap.ui.Device.browser.internet_explorer && !this.getEnabled()){
		// in IE tabindex = -1 hides focus, so in readOnly/disabled case tabindex must be temporarily set to 0
		// as long as CheckBox is focused
		this.$().attr("tabindex", 0).addClass("sapUiCbFoc"); // the CSS class itself is not used, but IE only draws the standard focus outline when it is added
	}

	this.userToggle(oEvent);
};

/**
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.CheckBox.prototype.onfocusout = function(oEvent) {
	//According to CSN2581852 2012 a readonly CB should be in the tabchain
	// This changed in 2013 back to not in the tabchain: see CSN 0002937527 2013
	// Let's see how often this will be changed back and forth in the future... Accessibility fun! :-D
	// End of 2013 is have to be again in the tabchain.
	// But not in the Form. But this is handled in the FromLayout control
	// Let's see what happens 2014... ;-)
	if(!!sap.ui.Device.browser.internet_explorer && !this.getEnabled()){
		// in IE tabindex = -1 hides focus, so in readOnly/disabled case tabindex must be temporarily set to 0
		// as long as CheckBox is focused - now unset this again
		this.$().attr("tabindex", -1).removeClass("sapUiCbFoc");
	}
};

/**
 * Event handler called when the space key is pressed.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.CheckBox.prototype.onsapspace = function(oEvent) {
	this.userToggle(oEvent);
};

/**
 * This method is used internally whenever the user toggles the check box value.
 * Purpose: Event cancellation and change event firing.
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.CheckBox.prototype.userToggle = function(oEvent) {
	oEvent.preventDefault();
	if (this.getEnabled() && this.getEditable()) {
		this.toggle();
		this.fireChange({checked: this.getChecked()});
	} else {
		// CheckBox has been activated by the user, but value cannot be changed
		// do nothing, but restore the focus to the complete control, as the user might have clicked the <input> element which also can get the focus
		this.getDomRef().focus();
	}
};

// implement public method toggle()
sap.ui.commons.CheckBox.prototype.toggle = function() {
	this.setChecked(!this.getChecked());
	return this;
};

}; // end of sap/ui/commons/CheckBox.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ColorPicker') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.ColorPicker.
jQuery.sap.declare("sap.ui.commons.ColorPicker");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ColorPicker.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getColorString colorString} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.ColorPicker#event:change change} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.commons.ColorPicker#event:liveChange liveChange} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * This control gives the user the opportunity to choose a color. The color can be defined using HEX-, RGB- or HSV-values or a CSS colorname.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.ColorPicker
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.ColorPicker", { metadata : {

	publicMethods : [
		// methods
		"getRGB"
	],
	library : "sap.ui.commons",
	properties : {
		"colorString" : {type : "string", group : "Misc", defaultValue : null}
	},
	events : {
		"change" : {}, 
		"liveChange" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.ColorPicker with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.ColorPicker.extend
 * @function
 */

sap.ui.commons.ColorPicker.M_EVENTS = {'change':'change','liveChange':'liveChange'};


/**
 * Getter for property <code>colorString</code>.
 * This is the import-parameter of the ColorPicker.
 * As input-parameter, it can be a Hexadecimal string (#FFFFFF), a RGB-string rgb(255,255,255), a HSV-string hsv(360,100,100) or a CSS-colorname 'red'.
 * As output-parameter it is a RGB-string containing the current color.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>colorString</code>
 * @public
 * @name sap.ui.commons.ColorPicker#getColorString
 * @function
 */

/**
 * Setter for property <code>colorString</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sColorString  new value for property <code>colorString</code>
 * @return {sap.ui.commons.ColorPicker} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ColorPicker#setColorString
 * @function
 */


/**
 * Value was changed. This event is fired if the value has changed by an user action.
 *
 * @name sap.ui.commons.ColorPicker#change
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.r Parameter containing the RED value (0-255)
 * @param {int} oControlEvent.getParameters.g Parameter containing the GREEN value (0-255)
 * @param {int} oControlEvent.getParameters.b Parameter containing the BLUE value (0-255)
 * @param {int} oControlEvent.getParameters.h Parameter containing the HUE value (0-360)
 * @param {int} oControlEvent.getParameters.s Parameter containing the SATURATION value (0-100)
 * @param {int} oControlEvent.getParameters.v Parameter containing the VALUE value (0-100)
 * @param {string} oControlEvent.getParameters.hex Parameter containing the Hexadecimal string (#FFFFFF)
 * @param {string} oControlEvent.getParameters.alpha Parameter containing the alpha value (transparency)
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'change' event of this <code>sap.ui.commons.ColorPicker</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.ColorPicker</code>.<br/> itself. 
 *  
 * Value was changed. This event is fired if the value has changed by an user action.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.ColorPicker</code>.<br/> itself.
 *
 * @return {sap.ui.commons.ColorPicker} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ColorPicker#attachChange
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'change' event of this <code>sap.ui.commons.ColorPicker</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.ColorPicker} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ColorPicker#detachChange
 * @function
 */

/**
 * Fire event change to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'r' of type <code>int</code> Parameter containing the RED value (0-255)</li>
 * <li>'g' of type <code>int</code> Parameter containing the GREEN value (0-255)</li>
 * <li>'b' of type <code>int</code> Parameter containing the BLUE value (0-255)</li>
 * <li>'h' of type <code>int</code> Parameter containing the HUE value (0-360)</li>
 * <li>'s' of type <code>int</code> Parameter containing the SATURATION value (0-100)</li>
 * <li>'v' of type <code>int</code> Parameter containing the VALUE value (0-100)</li>
 * <li>'hex' of type <code>string</code> Parameter containing the Hexadecimal string (#FFFFFF)</li>
 * <li>'alpha' of type <code>string</code> Parameter containing the alpha value (transparency)</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.ColorPicker} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.ColorPicker#fireChange
 * @function
 */


/**
 * Value was changed. This event is fired during the mouse move. The normal change event ist only fired by mouseup.
 *
 * @name sap.ui.commons.ColorPicker#liveChange
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.r Parameter containing the RED value (0-255)
 * @param {int} oControlEvent.getParameters.g Parameter containing the GREEN value (0-255)
 * @param {int} oControlEvent.getParameters.b Parameter containing the BLUE value (0-255)
 * @param {int} oControlEvent.getParameters.h Parameter containing the HUE value (0-360)
 * @param {int} oControlEvent.getParameters.s Parameter containing the SATURATION value (0-100)
 * @param {int} oControlEvent.getParameters.v Parameter containing the VALUE value (0-100)
 * @param {string} oControlEvent.getParameters.hex Parameter containing the Hexadecimal string (#FFFFFF)
 * @param {string} oControlEvent.getParameters.alpha Parameter containing the alpha value (transparency)
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'liveChange' event of this <code>sap.ui.commons.ColorPicker</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.ColorPicker</code>.<br/> itself. 
 *  
 * Value was changed. This event is fired during the mouse move. The normal change event ist only fired by mouseup.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.ColorPicker</code>.<br/> itself.
 *
 * @return {sap.ui.commons.ColorPicker} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ColorPicker#attachLiveChange
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'liveChange' event of this <code>sap.ui.commons.ColorPicker</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.ColorPicker} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ColorPicker#detachLiveChange
 * @function
 */

/**
 * Fire event liveChange to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'r' of type <code>int</code> Parameter containing the RED value (0-255)</li>
 * <li>'g' of type <code>int</code> Parameter containing the GREEN value (0-255)</li>
 * <li>'b' of type <code>int</code> Parameter containing the BLUE value (0-255)</li>
 * <li>'h' of type <code>int</code> Parameter containing the HUE value (0-360)</li>
 * <li>'s' of type <code>int</code> Parameter containing the SATURATION value (0-100)</li>
 * <li>'v' of type <code>int</code> Parameter containing the VALUE value (0-100)</li>
 * <li>'hex' of type <code>string</code> Parameter containing the Hexadecimal string (#FFFFFF)</li>
 * <li>'alpha' of type <code>string</code> Parameter containing the alpha value (transparency)</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.ColorPicker} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.ColorPicker#fireLiveChange
 * @function
 */


/**
 * This method delivers the current RGB-values
 *
 * @name sap.ui.commons.ColorPicker#getRGB
 * @function
 * @type object
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\ColorPicker.js
/**
 * This file defines behavior for the control sap.ui.commons.ColorPicker
 */


/**
 * Initialization hook... creating composite parts
 */
sap.ui.commons.ColorPicker.prototype.init = function(){

	//	declare global variable for the ColorObject
	this.Color = {
			r   :  255,
			g   :  255,
			b   :  255,
			h   :  0,
			s   :  0,
			v   :  100,
			a	:  1,
			a_old: 1,
			hex :  "#FFFFFF",
			old :  "#FFFFFF"
	};

	//	create global variables
	this.HexString = "FFFFFF";
	this.rgbString = "";
	this.$cpBox = null;
	this.$cpCur = null;
	this.RGB = {
			r : 0,
			g : 0,
			b : 0
	};

	//	check if we are in RTL mode
	this.bRtl  = sap.ui.getCore().getConfiguration().getRTL();

	//	create Matrix layout (outer control)
	this.oMatrix = new sap.ui.commons.layout.MatrixLayout({
		layoutFixed : true,
		columns : 3,
		width : "270px",
		widths : [ "117px", "84px", "69px"]
	});
	this.oMatrix.setParent(this);
	this.oMatrix.addStyleClass("sapUiColorPicker-ColorPickerMatrix");

	//	HTML-Control containing the ColorPickerBox
	var cpBoxID = this.getId() + '-cpBox';
	var cpCurID = this.getId() + '-cpCur';
	this.oHtmlBox = new sap.ui.core.HTML({
		content : "<DIV id=" + cpBoxID + " class=sapUiColorPicker-ColorPickerBox><DIV id=" + cpCurID + " class=sapUiColorPicker-ColorPickerCircle></DIV></DIV>"
	});

	//	HTML-Control containing the Old Color Box
	var ocBoxID = this.getId() + '-ocBox';
	this.oHtmlOldCol = new sap.ui.core.HTML({
		content : "<DIV id=" + ocBoxID + " class=sapUiColorPicker-ColorPickerOldColor></DIV>"
	});

	//	HTML-Control containing the New Color Box
	var ncBoxID = this.getId() + '-ncBox';
	this.oHtmlNewCol = new sap.ui.core.HTML({
		content : "<DIV id=" + ncBoxID + " class=sapUiColorPicker-ColorPickerNewColor></DIV>"
	});

	//	label and input field for Hexadecimal value
	var inpID = this.getId() + '-hxF';
	var hexValue = this.Color.hex.substr(1);
	this.oHexField = new sap.ui.commons.TextField({id: inpID, value : hexValue});
	this.oHexField.addStyleClass("sapUiColorPicker-ColorPickerHexField");
	this.oHexLabel = new sap.ui.commons.Label();
	this.oHexLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
	this.oHexLabel.setText("#:");
	this.oHexLabel.setLabelFor(this.oHexField);

	//	label and input field for Red Value
	inpID = this.getId() + '-rF';
	this.oRedField = new sap.ui.commons.TextField({id: inpID, value: this.Color.r, width:"3em"});
	this.oRedField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsLeft");
	this.oRedLabel = new sap.ui.commons.Label();
	this.oRedLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
	this.oRedLabel.setText("R:");
	this.oRedLabel.setLabelFor(this.oRedField);

	//	label and input field for Green Value
	inpID = this.getId() + '-gF';
	this.oGreenField = new sap.ui.commons.TextField({id: inpID, value : this.Color.g, width:"3em"});
	this.oGreenField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsLeft");
	this.oGreenLabel = new sap.ui.commons.Label();
	this.oGreenLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
	this.oGreenLabel.setText("G:");
	this.oGreenLabel.setLabelFor(this.oGreenField);

	//	label and input field for Blue Value
	inpID = this.getId() + '-bF';
	this.oBlueField = new sap.ui.commons.TextField({id: inpID, value : this.Color.b, width:"3em"});
	this.oBlueField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsLeft");
	this.oBlueLabel = new sap.ui.commons.Label();
	this.oBlueLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
	this.oBlueLabel.setText("B:");
	this.oBlueLabel.setLabelFor(this.oBlueField);

	//	label and input field for Hue Value
	inpID = this.getId() + '-hF';
	this.oHueField = new sap.ui.commons.TextField({id: inpID, value : this.Color.h, width:"3em"});
	this.oHueField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsRight");
	this.oHueLabel = new sap.ui.commons.Label();
	this.oHueLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
	this.oHueLabel.setText("H:");
	this.oHueLabel.setLabelFor(this.oHueField);

	//	label and input field for Saturation Value
	inpID = this.getId() + '-sF';
	this.oSatField = new sap.ui.commons.TextField({id: inpID, value : this.Color.s, width:"3em"});
	this.oSatField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsRight");
	this.oSatLabel = new sap.ui.commons.Label();
	this.oSatLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
	this.oSatLabel.setText("S:");
	this.oSatLabel.setLabelFor(this.oSatField);

	//	label and input field for Value
	inpID = this.getId() + '-vF';
	this.oValField = new sap.ui.commons.TextField({id: inpID, value : this.Color.v, width:"3em"});
	this.oValField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsRight");
	this.oValLabel = new sap.ui.commons.Label();
	this.oValLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
	this.oValLabel.setText("V:");
	this.oValLabel.setLabelFor(this.oValField);

	//	slider
	inpID = this.getId() + '-hSLD';
	this.oSlider = new sap.ui.commons.Slider({id: inpID});
	this.oSlider.setMax(360);
	this.oSlider.setValue(parseInt(this.oHueField.getValue()),10);
	this.oSlider.addStyleClass("sapUiColorPicker-ColorPickerSlider");

	// alpha slider
	inpID = this.getId() + '-aSLD';
	this.oAlphaSlider = new sap.ui.commons.Slider({id: inpID});
	this.oAlphaSlider.setMax(1);
	this.oAlphaSlider.setValue(1);
	this.oAlphaSlider.setSmallStepWidth(.01);
	this.oAlphaSlider.addStyleClass("sapUiColorPicker-ColorPickerAlphaSlider");

	//	1.Horizontal Layout
	this.oHLayout1 = new sap.ui.layout.HorizontalLayout({
		content: [this.oRedLabel, this.oRedField]
	});

	//	2.Horizontal Layout
	this.oHLayout2 = new sap.ui.layout.HorizontalLayout({
		content: [this.oGreenLabel, this.oGreenField]
	});

	//	3.Horizontal Layout
	this.oHLayout3 = new sap.ui.layout.HorizontalLayout({
		content: [this.oBlueLabel, this.oBlueField]
	});

	//	4.Horizontal Layout
	this.oHLayout4 = new sap.ui.layout.HorizontalLayout({
		content: [this.oHexLabel, this.oHexField]
	});

	//	5.Horizontal Layout
	this.oHLayout5 = new sap.ui.layout.HorizontalLayout({
		content: [this.oHueLabel, this.oHueField]
	});

	//	6.Horizontal Layout
	this.oHLayout6 = new sap.ui.layout.HorizontalLayout({
		content: [this.oSatLabel, this.oSatField]
	});

	//	7.Horizontal Layout
	this.oHLayout7 = new sap.ui.layout.HorizontalLayout({
		content: [this.oValLabel, this.oValField]
	});

	//	8.Horizontal Layout
	this.oHLayout8 = new sap.ui.layout.HorizontalLayout({
		content: [this.oHtmlOldCol, this.oHtmlNewCol]
	});
	
	//	Vertical Layout1 containing first four horizontal layouts
	this.oVLayout1 = new sap.ui.layout.VerticalLayout({
		content:[ this.oHLayout1, this.oHLayout2, this.oHLayout3, this.oHLayout4]
	});

	//	Vertical Layout2 containing 2.nd four horizontal layouts
	this.oVLayout2 = new sap.ui.layout.VerticalLayout({
		content:[ this.oHLayout5, this.oHLayout6, this.oHLayout7, this.oHLayout8]
	});
	this.oVLayout2.addStyleClass("sapUiColorPicker-ColorPickerLastColumn");

	//	add first Row to the Matrix Layout
	this.oMatrix.createRow(this.oHtmlBox, this.oVLayout1, this.oVLayout2);

	//	create second Row containing slider
	this.oRow2 = new sap.ui.commons.layout.MatrixLayoutRow();
	this.oCell = new sap.ui.commons.layout.MatrixLayoutCell({ colSpan : 3 });
	this.oCell.addContent(this.oSlider);
	this.oRow2.addCell(this.oCell);

	//	add second Row to the Matrix Layout
	this.oMatrix.addRow(this.oRow2);

	// add another row for the alpha slider
	this.oRow3 = new sap.ui.commons.layout.MatrixLayoutRow();
	this.oCell = new sap.ui.commons.layout.MatrixLayoutCell({ colSpan : 3 });
	this.oCell.addContent(this.oAlphaSlider);
	this.oRow3.addCell(this.oCell);

	//	add third Row to the Matrix Layout
	this.oMatrix.addRow(this.oRow3);

	//	attach Eventhandler
	this.oHexField.attachChange(jQuery.proxy(this._handleHexValueChange,this));
	this.oRedField.attachChange(jQuery.proxy(this._handleRedValueChange,this));
	this.oGreenField.attachChange(jQuery.proxy(this._handleGreenValueChange,this));
	this.oBlueField.attachChange(jQuery.proxy(this._handleBlueValueChange,this));
	this.oHueField.attachChange(jQuery.proxy(this._handleHueValueChange,this));
	this.oSatField.attachChange(jQuery.proxy(this._handleSatValueChange,this));
	this.oValField.attachChange(jQuery.proxy(this._handleValValueChange,this));
	this.oSlider.attachLiveChange(jQuery.proxy(this._handleSliderLiveChange,this));
	this.oSlider.attachChange(jQuery.proxy(this._handleSliderChange,this));
	this.oAlphaSlider.attachLiveChange(jQuery.proxy(this._handleAlphaSliderLiveChange,this));
	this.oAlphaSlider.attachChange(jQuery.proxy(this._handleAlphaSliderChange,this));
}



/**
 * Clean-up hook... destroying composite parts.
 */
sap.ui.commons.ColorPicker.prototype.exit = function(){

	//	unbind Mouse-Event-Handler
	if (this.$cpBox) {
		this.$cpBox.unbind("mousedown", this.handleMouseDown);
	}

	jQuery(document)
	.unbind("mousemove", this.handleMousePos)
	.unbind("mouseup", this.handleMouseUp);

	//	destroy Objects
	this.oMatrix.destroy();
}



/**
 * Evaluate parameter values
 */
sap.ui.commons.ColorPicker.prototype.setColorString = function(iColorString) {

	//	parse string; get the color object
	this._parseColorString(iColorString);

	//	update UI
	this.oHexField.setValue(this.Color.hex.substr(1));
	this.oRedField.setValue(this.Color.r);
	this.oGreenField.setValue(this.Color.g);
	this.oBlueField.setValue(this.Color.b);
	this.oHueField.setValue(this.Color.h);
	this.oSatField.setValue(this.Color.s);
	this.oValField.setValue(this.Color.v);
	this.oSlider.setValue(this.Color.h);
	this.oAlphaSlider.setValue(this.Color.a);

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler of the mouse down event
 */
sap.ui.commons.ColorPicker.prototype.handleMouseDown = function(e) {

	//	exit if the HEXfield is errorneous
	if (this.oHexField.getValueState() == sap.ui.core.ValueState.Error) return;

	//	call mouse position handler
	this.handleMousePos(e);
	jQuery(document)
	.bind("mousemove", jQuery.proxy(this.handleMousePos, this))
	.bind("mouseup", jQuery.proxy(this.handleMouseUp, this));
}



/**
 * Event handler of the mouse up event
 */
sap.ui.commons.ColorPicker.prototype.handleMouseUp = function(e) {

	//	exit if the HEXfield is errorneous
	if (this.oHexField.getValueState() == sap.ui.core.ValueState.Error) return;

	//	call mouse position handler
	this.handleMousePos(e);
	jQuery(document)
	.unbind("mousemove", this.handleMousePos)
	.unbind("mouseup", this.handleMouseUp);

	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for the mouse position
 */
sap.ui.commons.ColorPicker.prototype.handleMousePos = function(e) {

	//	get offset of the colorpicker box
	var cpBoxOffset = this.$cpBox.offset();

	//	get width & height if the colorpicker box
	var cpBoxWidth  = this.$cpBox.width();
	var cpBoxHeight = this.$cpBox.height();

	//	calculate the hue and saturation values from the mouse position
	var x = e.pageX - cpBoxOffset.left;
	var y = e.pageY - cpBoxOffset.top;
	x = Math.min(Math.max(x, 0), cpBoxWidth);
	//	handle RTL - mode
	if(this.bRtl){
		var rX = cpBoxWidth - x;
		x = rX;
	};
	y = Math.min(Math.max(y, 0), cpBoxHeight);
	var valValue = parseInt(x/cpBoxWidth * 100,10);
	var satValue = parseInt((1 - y/cpBoxHeight) * 100,10);

	//	set the new values
	this.oSatField.setValue(satValue);
	this.oValField.setValue(valValue);

	//	process changes
	this._processHSVchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for Slider LIVE changes
 */
sap.ui.commons.ColorPicker.prototype._handleSliderLiveChange = function() {

	//	get the new value
	var sliderValue = parseInt(this.oSlider.getValue(),10);

	//	set the new hue value in the hue inut field
	this.oHueField.setValue(sliderValue);

	//	process changes
	this._processHSVchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for Slider changes
 */
sap.ui.commons.ColorPicker.prototype._handleSliderChange = function() {

	//	get the new value
	var sliderValue = parseInt(this.oSlider.getValue(),10);

	//	set the new hue value in the hue inut field
	this.oHueField.setValue(sliderValue);

	//	process changes
	this._processHSVchanges();

	//	fire Change event
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
* Event handler for Alpha-Slider LIVE changes
*/
sap.ui.commons.ColorPicker.prototype._handleAlphaSliderLiveChange = function() {

	// get the new value
	this.Color.a = this.oAlphaSlider.getValue();
	
	//	process changes
	this._processHSVchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for Alpha-Slider changes
 */
sap.ui.commons.ColorPicker.prototype._handleAlphaSliderChange = function() {

	//	get the new value
	this.Color.a = this.oAlphaSlider.getValue();
	
	//	process changes
	this._processHSVchanges();

	//	fire Change event
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for changes of hue input field
 */
sap.ui.commons.ColorPicker.prototype._handleHueValueChange = function(){

	//	get the new value
	var hueValue = parseInt(this.oHueField.getValue(),10);

	//	check for correct value (0 - 360)
	if (hueValue < 0 || isNaN(hueValue)) hueValue = 0;
	if (hueValue > 360) hueValue = 359.9;

	//	set the new value (maybe the value has been changed in the above lines)
	this.oHueField.setValue(hueValue);

	//	update slider value
	this.oSlider.setValue(hueValue);

	//	process Changes
	this._processHSVchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for changes of saturation input field
 */
sap.ui.commons.ColorPicker.prototype._handleSatValueChange =  function(){

	//	get the new value
	var satValue = parseInt(this.oSatField.getValue(),10);

	//	check for correct value (0-100)
	if (satValue < 0 || isNaN(satValue)) satValue = 0;
	if (satValue > 100) satValue = 100;

	//	set the new value (maybe the value has been changed in the above lines)
	this.oSatField.setValue(satValue);

	//	process Changes
	this._processHSVchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for changes of value input field
 */
sap.ui.commons.ColorPicker.prototype._handleValValueChange = function(){

	//	get the new value
	var valValue = parseInt(this.oValField.getValue(),10);

	//	check for correct value (0-100)
	if (valValue < 0 || isNaN(valValue)) valValue = 0;
	if (valValue > 100) valValue = 100;

	//	set the new value (maybe the value has been changed in the above lines)
	this.oValField.setValue(valValue);

	//	process Changes
	this._processHSVchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for changes of RED input field
 */
sap.ui.commons.ColorPicker.prototype._handleRedValueChange = function(){

	//	get the new value
	var redValue = parseInt(this.oRedField.getValue(),10);

	//	check for correct value (0-255)
	if (redValue < 0 || isNaN(redValue)) redValue = 0;
	if (redValue > 255) redValue = 255;

	//	set the new value (maybe the value has been changed in the above lines)
	this.oRedField.setValue(redValue);

	//	process changes
	this._processRGBchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for changes of GREEN input field
 */
sap.ui.commons.ColorPicker.prototype._handleGreenValueChange = function(){

	//	get the new value
	var greenValue = parseInt(this.oGreenField.getValue(),10);

	//	check for correct value
	if (greenValue < 0 || isNaN(greenValue)) greenValue = 0;
	if (greenValue > 255) greenValue = 255;

	//	set the new value (maybe the value has been changed in the above lines)
	this.oGreenField.setValue(greenValue);

	//	process changes
	this._processRGBchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Event handler for changes of BLUE input field
 */
sap.ui.commons.ColorPicker.prototype._handleBlueValueChange = function(){

	//	get the new value
	var blueValue = parseInt(this.oBlueField.getValue(),10);

	//	check for correct value
	if (blueValue < 0 || isNaN(blueValue)) blueValue = 0;
	if (blueValue > 255) blueValue = 255;

	//	set the new value (maybe the value has been changed in the above lines)
	this.oBlueField.setValue(blueValue);

	//	process changes
	this._processRGBchanges();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Process changes of Hue, Value and Saturation
 */
sap.ui.commons.ColorPicker.prototype._processHSVchanges = function(){

	//	get HSV-values
	var hueValue   = parseInt(this.oHueField.getValue(),10);
	var satValue   = parseInt(this.oSatField.getValue(),10);
	var valValue   = parseInt(this.oValField.getValue(),10);

	//	calculate and set new RGB-values
	this._calculateRGB(hueValue, satValue, valValue);
	this.Color.r = this.RGB.r;
	this.Color.g = this.RGB.g;
	this.Color.b = this.RGB.b;
	this.oRedField.setValue(this.Color.r);
	this.oGreenField.setValue(this.Color.g);
	this.oBlueField.setValue(this.Color.b);

	//	calculate and set HEX-values from the RGB-values
	this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);
	this.oHexField.setValue(this.HexString);
	this.Color.hex =  "#" + this.oHexField.getValue();

	//	set HSV-values
	this.Color.h = hueValue;
	this.Color.s = satValue;
	this.Color.v = valValue;
	this.oHueField.setValue(this.Color.h);
	this.oSatField.setValue(this.Color.s);
	this.oValField.setValue(this.Color.v);

	//	update gradient box background
	this._updateGradientBoxBackground(this.Color.h);

	//	update cursor position
	this._updateCursorPosition();

	//	update selected color background
	this._updateSelColorBackground();
}



/**
 * Process changes of Red, Green and Blue values
 */
sap.ui.commons.ColorPicker.prototype._processRGBchanges = function(){

	//	calculate and set HEX-value from the RGB-values
	var redValue   = Math.round(parseInt(this.oRedField.getValue(),10));
	var greenValue = Math.round(parseInt(this.oGreenField.getValue(),10));
	var blueValue  = Math.round(parseInt(this.oBlueField.getValue(),10));
	this._calculateHEX(redValue, greenValue, blueValue);
	this.oHexField.setValue(this.HexString);

	//	calculate and set HSV-values from the RGB-values
	this._calculateHSV(redValue, greenValue, blueValue);
	this.oHueField.setValue(this.Color.h);
	this.oSatField.setValue(this.Color.s);
	this.oValField.setValue(this.Color.v);

	//	update slider value
	this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));

	//	store the values in variable
	this.Color.r   = redValue;
	this.Color.g   = greenValue;
	this.Color.b   = blueValue;
	this.Color.hex =  "#" + this.oHexField.getValue();

	//	update gradient box background
	this._updateGradientBoxBackground(this.Color.h);

	//	update cursor position
	this._updateCursorPosition();

	//	update selected color background
	this._updateSelColorBackground();
}



/**
 * Event handler for changes of HEX input field
 */
sap.ui.commons.ColorPicker.prototype._handleHexValueChange = function(){

	//	get the new value and convert to uppercase
	var hexValue = this.oHexField.getValue().toUpperCase();

	//	check for correct value
	if (hexValue.substr(0, 1) == '#') hexValue = hexValue.substr(1);
	var re=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;
	if (re.test(hexValue) == false){
		this.oHexField.setValueState(sap.ui.core.ValueState.Error);
		this.oSlider.setEnabled(false);
		this.oAlphaSlider.setEnabled(false);
		this.oHueField.setEnabled(false);
		this.oRedField.setEnabled(false);
		this.oGreenField.setEnabled(false);
		this.oBlueField.setEnabled(false);
		this.oSatField.setEnabled(false);
		this.oValField.setEnabled(false);
		return false;
	} else if(this.oHexField.getValueState()  == sap.ui.core.ValueState.Error){
		this.oHexField.setValueState(sap.ui.core.ValueState.None);
		this.oSlider.setEnabled(true);
		this.oAlphaSlider.setEnabled(true);
		this.oHueField.setEnabled(true);
		this.oRedField.setEnabled(true);
		this.oGreenField.setEnabled(true);
		this.oBlueField.setEnabled(true);
		this.oSatField.setEnabled(true);
		this.oValField.setEnabled(true);
	};

	//	convert from short to long hex (if needed)
	if (hexValue.length == 3){
		var tempValue = hexValue.charAt(0)+hexValue.charAt(0)+hexValue.charAt(1)+hexValue.charAt(1)+hexValue.charAt(2)+hexValue.charAt(2);
		hexValue = tempValue;
	};

	//	process Changes
	this._processHexChanges(hexValue);

	//	update UI
	this.oHexField.setValue(hexValue);
	this.oRedField.setValue(this.Color.r);
	this.oGreenField.setValue(this.Color.g);
	this.oBlueField.setValue(this.Color.b);
	this.oHueField.setValue(this.Color.h);
	this.oSatField.setValue(this.Color.s);
	this.oValField.setValue(this.Color.v);
	this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));
	this.oAlphaSlider.setValue(1);

	//	update gradient box background
	this._updateGradientBoxBackground(this.Color.h);

	//	update cursor position
	this._updateCursorPosition();

	//	update selected color background
	this._updateSelColorBackground();

	//	fire events & update property
	this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
	this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
}



/**
 * Hex-Values have changed ==> process changes
 */
sap.ui.commons.ColorPicker.prototype._processHexChanges = function (ihexValue){

	//	convert RGB-values
	this._convertRGB(ihexValue);

	//	calculate and set HSV-values from the RGB-values
	this._calculateHSV(this.Color.r, this.Color.g, this.Color.b);

	//	all values except hex set; set the hex value
	this.Color.hex = "#" + ihexValue.toUpperCase();
}



/**
 * Update Cursor position in the ColorPicker Box
 */
sap.ui.commons.ColorPicker.prototype._updateCursorPosition = function(){

	//	get the width & height
	var cpCurWidth  = this.$cpCur.width();
	var cpCurHeight = this.$cpCur.height();
	var cpBoxWidth  = this.$cpBox.width();
	var cpBoxHeight = this.$cpBox.height();

	//	get the saturation and value
	var satValue = this.oSatField.getValue();
	var valValue = this.oValField.getValue();

	//	calculate the x and y values
	var x = parseInt(valValue * cpBoxWidth /100,10);
	//	calculate x if we are in RTL mode
	if(this.bRtl){
		var rX = cpBoxWidth - x;
		x = rX;
	};
	var y = parseInt((1-satValue/100)*cpBoxHeight,10);
	x = Math.min(Math.max(x, 0), cpBoxWidth-cpCurWidth/2) -cpCurWidth/2;
	y = Math.min(Math.max(y, 0), cpBoxHeight-cpCurHeight/2) -cpCurHeight/2;

	//	set the new cursor position
	this.$cpCur.css("left", x).css("top", y);
}



/**
 * Calculate RGB-Values from Hue/Saturation/Value
 */
sap.ui.commons.ColorPicker.prototype._calculateRGB = function( hue, sat, val){

	//hue value is cyclic, so 360 = 0
	if (hue == 360) {
		hue = 0;
	}
	hue /= 60;
	sat /= 100;
	val /= 100;
	
	
	//Formula taken from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
	var c = val * sat;
	var x = c * (1 - Math.abs(hue % 2 - 1));
	var m = val - c;
	
	// calculate values
	var redValue = 0, greenValue = 0, blueValue = 0;
	var i = Math.floor(hue);
	
	switch (i) {
		case 0:
			redValue   = c;
			greenValue = x;
			break;
		case 1:
			redValue   = x;
			greenValue = c;
			break;
		case 2:
			greenValue = c;
			blueValue  = x;
			break;
		case 3:
			greenValue = x;
			blueValue  = c;
			break;
		case 4:
			redValue   = x;
			blueValue  = c;
			break;
		case 5:
			redValue   = c;
			blueValue  = x;
			break;
	}
	
	this.RGB.r = Math.floor((redValue + m) * 255);
	this.RGB.g = Math.floor((greenValue + m) * 255);
	this.RGB.b = Math.floor((blueValue + m) * 255);
}



/**
 * Get RGB-String from the current RGB-Values
 */
sap.ui.commons.ColorPicker.prototype._getRGBString = function( ){
	if(this.Color.a < 1){
		return "rgba(" + this.Color.r + "," + this.Color.g + "," + this.Color.b + ", " + this.Color.a + ")";
	} else {
		return "rgb(" + this.Color.r + "," + this.Color.g + "," + this.Color.b + ")";
	}
}



/**
 * Calculate HEX-Values when RGB-values change
 */
sap.ui.commons.ColorPicker.prototype._calculateHEX = function(red,green,blue){

	//	convert values
	var redStr     = red.toString(16);
	var greenStr   = green.toString(16);
	var blueStr    = blue.toString(16);
	if (redStr.length == 1)   redStr   = '0' + redStr;
	if (greenStr.length == 1) greenStr = '0' + greenStr;
	if (blueStr.length == 1)  blueStr  = '0' + blueStr;

	//	return the HexValue
	this.HexString = (redStr + greenStr + blueStr).toUpperCase();
}



/**
 * Calculate HSV-Values from RGB-values
 */
sap.ui.commons.ColorPicker.prototype._calculateHSV = function (red, green, blue){

	//	calculate values
	var max			= Math.max(Math.max(red, green), blue);
	var min			= Math.min(Math.min(red, green), blue);
	var delta		= (max - min);
	var valValue	= Math.round(max*100/255);
	var satValue = (max==0.0)?0:(100*delta/max);
	var hueValue = 0;
	if (satValue==0) hueValue=0;
	else if (red==max)   hueValue=60.0*(green-blue)/delta;
	else if (green==max) hueValue=120.0+60.0*(blue-red)/delta;
	else if (blue==max)  hueValue=240.0+60.0*(red-green)/delta;
	if (hueValue<0.0) hueValue+=359.9;
	hueValue=Math.round(hueValue);
	satValue=Math.round(satValue);

	//	store the new values
	this.Color.h = hueValue;
	this.Color.s = satValue;
	this.Color.v = valValue;
}



/**
 * Convert HEX-Value to RGB-Values
 */
sap.ui.commons.ColorPicker.prototype._convertRGB = function(hex){

	//	calculate the new values
	var red   = parseInt(hex.substr(0, 2), 16);
	var green = parseInt(hex.substr(2, 2), 16);
	var blue  = parseInt(hex.substr(4, 2), 16);

	//	return the new values
	this.Color.r = red;
	this.Color.g = green;
	this.Color.b = blue;
}



/**
 * Update GradientBox Background
 */
sap.ui.commons.ColorPicker.prototype._updateGradientBoxBackground = function(hue){

	//	calculate RGB-values
	this._calculateRGB(hue, 100, 100);

	//	calculate Hex-value
	this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);
	var hexCol    =  "#" + this.HexString;

	//	set backgroundColor
	this.$cpBox.css('background-color','rgb(' + this.RGB.r + ', '  + this.RGB.g + ', ' + this.RGB.b + ')');
}



/**
 * Update background of "new color box"
 */
sap.ui.commons.ColorPicker.prototype._updateSelColorBackground = function(){

	//	set the new color
	this.$("ncBox").css('background-color',this._getRGBString());

}



/**
 * Parse Input Parameter; evaluate color
 */
sap.ui.commons.ColorPicker.prototype._parseColorString = function(iColorString){

	//	delete #, trim and convert to lower case
	if (iColorString.substr(0, 1) == '#') iColorString = iColorString.substr(1);
	iColorString = iColorString.replace(/ /g,'');
	iColorString = iColorString.toLowerCase();

	//	parse Names
	var searchKey = "";
	var hexValue = "";
	var colorNames = {
			aliceblue: 				'f0f8ff',
			antiquewhite: 			'faebd7',
			aqua: 					'00ffff',
			aquamarine: 			'7fffd4',
			azure: 					'f0ffff',
			beige: 					'f5f5dc',
			bisque: 				'ffe4c4',
			black: 					'000000',
			blanchedalmond:			'ffebcd',
			blue: 					'0000ff',
			blueviolet:				'8a2be2',
			brown:					'a52a2a',
			burlywood: 				'deb887',
			cadetblue: 				'5f9ea0',
			chartreuse: 			'7fff00',
			chocolate: 				'd2691e',
			coral: 					'ff7f50',
			cornflowerblue: 		'6495ed',
			cornsilk: 				'fff8dc',
			crimson: 				'dc143c',
			cyan: 					'00ffff',
			darkblue: 				'00008b',
			darkcyan: 				'008b8b',
			darkgoldenrod: 			'b8860b',
			darkgray: 				'a9a9a9',
			darkgreen: 				'006400',
			darkkhaki: 				'bdb76b',
			darkmagenta: 			'8b008b',
			darkolivegreen: 		'556b2f',
			darkorange: 			'ff8c00',
			darkorchid: 			'9932cc',
			darkred: 				'8b0000',
			darksalmon: 			'e9967a',
			darkseagreen: 			'8fbc8f',
			darkslateblue: 			'483d8b',
			darkslategray: 			'2f4f4f',
			darkturquoise: 			'00ced1',
			darkviolet: 			'9400d3',
			deeppink: 				'ff1493',
			deepskyblue: 			'00bfff',
			dimgray: 				'696969',
			dodgerblue: 			'1e90ff',
			feldspar: 				'd19275',
			firebrick: 				'b22222',
			floralwhite: 			'fffaf0',
			forestgreen: 			'228b22',
			fuchsia: 				'ff00ff',
			gainsboro: 				'dcdcdc',
			ghostwhite: 			'f8f8ff',
			gold: 					'ffd700',
			goldenrod: 				'daa520',
			gray: 					'808080',
			green: 					'008000',
			greenyellow: 			'adff2f',
			honeydew: 				'f0fff0',
			hotpink: 				'ff69b4',
			indianred : 			'cd5c5c',
			indigo : 				'4b0082',
			ivory: 					'fffff0',
			khaki: 					'f0e68c',
			lavender: 				'e6e6fa',
			lavenderblush: 			'fff0f5',
			lawngreen: 				'7cfc00',
			lemonchiffon: 			'fffacd',
			lightblue: 				'add8e6',
			lightcoral: 			'f08080',
			lightcyan: 				'e0ffff',
			lightgoldenrodyellow:	'fafad2',
			lightgrey: 				'd3d3d3',
			lightgreen: 			'90ee90',
			lightpink: 				'ffb6c1',
			lightsalmon: 			'ffa07a',
			lightseagreen: 			'20b2aa',
			lightskyblue: 			'87cefa',
			lightslateblue: 		'8470ff',
			lightslategray: 		'778899',
			lightsteelblue: 		'b0c4de',
			lightyellow: 			'ffffe0',
			lime: 					'00ff00',
			limegreen: 				'32cd32',
			linen: 					'faf0e6',
			magenta: 				'ff00ff',
			maroon: 				'800000',
			mediumaquamarine: 		'66cdaa',
			mediumblue: 			'0000cd',
			mediumorchid: 			'ba55d3',
			mediumpurple: 			'9370d8',
			mediumseagreen: 		'3cb371',
			mediumslateblue: 		'7b68ee',
			mediumspringgreen: 		'00fa9a',
			mediumturquoise: 		'48d1cc',
			mediumvioletred:		'c71585',
			midnightblue: 			'191970',
			mintcream: 				'f5fffa',
			mistyrose: 				'ffe4e1',
			moccasin: 				'ffe4b5',
			navajowhite: 			'ffdead',
			navy: 					'000080',
			oldlace: 				'fdf5e6',
			olive: 					'808000',
			olivedrab: 				'6b8e23',
			orange: 				'ffa500',
			orangered: 				'ff4500',
			orchid: 				'da70d6',
			palegoldenrod: 			'eee8aa',
			palegreen: 				'98fb98',
			paleturquoise: 			'afeeee',
			palevioletred: 			'd87093',
			papayawhip: 			'ffefd5',
			peachpuff: 				'ffdab9',
			peru: 					'cd853f',
			pink: 					'ffc0cb',
			plum: 					'dda0dd',
			powderblue: 			'b0e0e6',
			purple: 				'800080',
			red: 					'ff0000',
			rosybrown: 				'bc8f8f',
			royalblue: 				'4169e1',
			saddlebrown: 			'8b4513',
			salmon: 				'fa8072',
			sandybrown: 			'f4a460',
			seagreen: 				'2e8b57',
			seashell: 				'fff5ee',
			sienna: 				'a0522d',
			silver: 				'c0c0c0',
			skyblue: 				'87ceeb',
			slateblue: 				'6a5acd',
			slategray: 				'708090',
			snow: 					'fffafa',
			springgreen: 			'00ff7f',
			steelblue: 				'4682b4',
			tan: 					'd2b48c',
			teal: 					'008080',
			thistle: 				'd8bfd8',
			tomato: 				'ff6347',
			turquoise: 				'40e0d0',
			violet: 				'ee82ee',
			violetred: 				'd02090',
			wheat: 					'f5deb3',
			white: 					'ffffff',
			whitesmoke: 			'f5f5f5',
			yellow: 				'ffff00',
			yellowgreen: 			'9acd32'
	};

	for (searchKey in colorNames) {
		if (iColorString == searchKey) {
			hexValue = colorNames[searchKey].toUpperCase();
		}
	};

	if (hexValue !=""){
		//Found a name; get RGB and HSV values
		this._processHexChanges(hexValue);
		this.Color.old = this.Color.hex;
	};


	//	parse HEX
	//	allowed input: #aabbcc, aabbcc, #abc, abc
	//	'#' has already been deleted, search only for values
	//  check for correct value using regular expression
	var re=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;
	if (re.test(iColorString) == true){
		//it's a hex value; check if its aabbcc or abc
		if (iColorString.length == 3){
			var hexValue = iColorString.charAt(0)+iColorString.charAt(0)+iColorString.charAt(1)+iColorString.charAt(1)+iColorString.charAt(2)+iColorString.charAt(2);
		}
		else {
			hexValue = iColorString;
		};
		//get RGB and HSV values
		this._processHexChanges(hexValue);
		this.Color.old = this.Color.hex;
	};


	//	parse RGBA
	//	allowed input: rgba(255,255,255,0.3); rgba255,255,255,0.3
	//	check if the string begins with "rgba"
	if (iColorString.substr(0, 4) == 'rgba'){
		// remove rgba, "(", ")" and blanks
		iColorString = iColorString.substr(4);
		iColorString = iColorString.replace("(",'');
		iColorString = iColorString.replace(")",'');
		iColorString = iColorString.split(' ').join('');
		var re=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){1}(([0]\.[0-9]*)|(\.[0-9]{2})|[1]){1}$/;
		if (re.test(iColorString) == true){
			//it's a rgba string, get the values and convert to Hex
			var RGBColor = iColorString.split(",");
			var sAlpha = iColorString.substr(iColorString.lastIndexOf(",")+1, (iColorString.length-iColorString.lastIndexOf(",")));
			this._calculateHEX(parseInt(RGBColor[0],10), parseInt(RGBColor[1],10), parseInt(RGBColor[2],10));
			//get HSV values
			this._processHexChanges(this.HexString);
			this.Color.old = this.Color.hex;
			this.Color.a = this.Color.a_old = parseFloat(sAlpha);
		};
	};

	
	//	parse RGB
	//	allowed input: rgb(255,255,255); rgb255,255,255
	//	check if the string begins with "rgb"
	if (iColorString.substr(0, 3) == 'rgb'){
		// remove rgb, "(", ")" and blanks
		iColorString = iColorString.substr(3);
		iColorString = iColorString.replace("(",'');
		iColorString = iColorString.replace(")",'');
		iColorString = iColorString.split(' ').join('');
		var re=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5]))){1}$/;
		if (re.test(iColorString) == true){
			//it's a rgb string, get the values and convert to Hex
			var RGBColor = iColorString.split(",");
			this._calculateHEX(parseInt(RGBColor[0],10), parseInt(RGBColor[1],10), parseInt(RGBColor[2],10));
			//get HSV values
			this._processHexChanges(this.HexString);
			this.Color.old = this.Color.hex;
		};
	};


	//	parse HSV
	//	allowed input: hsv(360,100,100); hsv360,100,100; [hsv(360,0.5,0.5); hsv360,0.5,0.5 later]
	//	check if the string begins with "rgb"
	if (iColorString.substr(0, 3) == 'hsv'){
		// remove hsv, "(", ")" and blanks
		iColorString = iColorString.substr(3);
		iColorString = iColorString.replace("(",'');
		iColorString = iColorString.replace(")",'');
		iColorString = iColorString.split(' ').join('');
		var re=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(((\d{1,2})|(100)),){1}((\d{1,2})|(100)){1}$/;
		if (re.test(iColorString) == true){
			//it's a hsv string, get the values
			var HSVColor = iColorString.split(",");
			//get RGB values
			this._calculateRGB(parseInt(HSVColor[0],10), parseInt(HSVColor[1],10), parseInt(HSVColor[2],10));
			//get Hex values
			this._calculateHEX(this.RGB.r, this.RGB.g, this.RGB.b);
			//store the values
			this.Color.r   = this.RGB.r;
			this.Color.g   = this.RGB.g;
			this.Color.b   = this.RGB.b;
			this.Color.h   = parseInt(HSVColor[0],10);
			this.Color.s   = parseInt(HSVColor[1],10);
			this.Color.v   = parseInt(HSVColor[2],10);
			this.Color.hex = "#" + this.HexString;
			this.Color.old = this.Color.hex;
		};
	}
	else return false;
}



/**
 * Event after rendering the page
 */
sap.ui.commons.ColorPicker.prototype.onAfterRendering = function (){

	// get the jQuery-Object for cpBox and cpCur
	this.$cpBox = this.$("cpBox");
	this.$cpCur = this.$("cpCur");

	//	add Mousehandler for ColorPickerBox
	this.$cpBox.bind("mousedown", jQuery.proxy(this.handleMouseDown, this));

	//	set the background color of the Color Boxes
	this.$("ncBox").css('background-color',this._getRGBString());
	this.$("ocBox").css('background-color',this._getRGBString());

	//	update the background color of the 'new color box'
	this._updateGradientBoxBackground(this.Color.h);

	//	update cursor position
	this._updateCursorPosition();
}



/**
 * Event before rendering the page
 */
sap.ui.commons.ColorPicker.prototype.onBeforeRendering = function (){

	//	unbind Mousehandler for ColorPickerBox
	this.$("cpBox").unbind("mousedown", this.handleMouseDown);

}



/**
 * Deliver current RGB-values
 */
sap.ui.commons.ColorPicker.prototype.getRGB = function (){

	return {r:this.Color.r, g:this.Color.g, b:this.Color.b};

}

}; // end of sap/ui/commons/ColorPicker.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ComboBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ComboBox
jQuery.sap.declare("sap.ui.commons.ComboBoxRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class Renderer for the sap.ui.commons.ComboBox
 * @static
 */
sap.ui.commons.ComboBoxRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.TextFieldRenderer);

/**
 * Renders the outer &lt;div&gt; for the ComboBox to the TextField
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.commons.ComboBoxRenderer.renderOuterAttributes = function(rm, oCmb) {
	rm.addClass("sapUiTfCombo");
	this.renderComboARIAInfo(rm, oCmb);
};

/**
 * Renders additional HTML for the ComboBox to the TextField before the INPUT element (sets the icon)
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oCmb an object representation of the control that should be rendered
 */
sap.ui.commons.ComboBoxRenderer.renderOuterContentBefore = function(rm, oCmb){

	this.renderExpander(rm, oCmb);
	this.renderSelectBox(rm, oCmb, '-1');

};

sap.ui.commons.ComboBoxRenderer.renderExpander = function(rm, oCmb){

	rm.write("<div");
	rm.writeAttributeEscaped('id', oCmb.getId() + '-icon');
	rm.writeAttribute('unselectable', 'on');
	if ( sap.ui.getCore().getConfiguration().getAccessibility()){
		rm.writeAttribute("role", "presentation");
	}
	rm.addClass("sapUiTfComboIcon");
	rm.writeClasses();
	rm.write(">&#9660;</div>");//Symbol for HCB Theme (Must be hidden in other themes)

};

sap.ui.commons.ComboBoxRenderer.renderSelectBox = function(rm, oCmb, sTabindex){

	if (oCmb.mobile) {
		// for mobile devices render SELECT box
		// it lays over the button but should be transparent. So a click on the button opens the select box
		rm.write("<select");
		rm.writeAttributeEscaped('id', oCmb.getId() + '-select');
		rm.writeAttribute('tabindex', sTabindex);
		if (!oCmb.getEnabled() || !oCmb.getEditable()) {
			rm.writeAttribute('disabled', 'disabled');
		}
		rm.write(">");
		for ( var i = 0; i < oCmb.getItems().length; i++) {
			var oItem = oCmb.getItems()[i];
			rm.write("<option");
			// combine comboBox ID with Item ID because items can be in more than one ComboBox vi the same List
			rm.writeAttributeEscaped('id', oCmb.getId()+"-"+oItem.getId());
			if (!oItem.getEnabled()) {
				rm.writeAttribute("disabled", "disabled");
			}
			rm.write(">"+oItem.getText()+"</option>");
		}
		rm.write("</select>");
	}

};

/**
 * Renders the inner &lt;div&gt; for the ComboBox to the TextField
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oCmb an object representation of the control that should be rendered
 */
sap.ui.commons.ComboBoxRenderer.renderInnerAttributes = function(rm, oCmb) {

	if (oCmb.mobile) {
		rm.writeAttribute('autocapitalize', 'off');
		rm.writeAttribute('autocorrect', 'off');
	}

};

/*
 * Renders ARIA information for the combobox (outer &lt;div&gt;)
 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
 * @private
 */
sap.ui.commons.ComboBoxRenderer.renderComboARIAInfo = function(rm, oCmb) {

	// to not force creation if internal ListBox do not use _getListBox()
	var sListBox = oCmb.getListBox();
	if (!sListBox && oCmb._oListBox) {
		sListBox = oCmb._oListBox.getId();
	}

	var mProps = {
		role: "combobox",
		owns: oCmb.getId() + "-input " + sListBox
		};

	if (!oCmb.getEnabled()) {
		mProps["disabled"] = true;
	}

	rm.writeAccessibilityState(null,  //null because otherwise automatic generated attributes will be rendered twice
		mProps);

};

/*
 * Renders ARIA information for the given input field (called from 'parent'-renderer, i.e. sap.ui.commons.TextFieldRenderer)
 * As the input tag has the focus all controls aria attributes should be here
 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
 * @private
 */
sap.ui.commons.ComboBoxRenderer.renderARIAInfo = function(rm, oCmb) {

	var iPosInSet = -1;
	if(oCmb.getSelectedItemId()){
		for ( var i = 0; i < oCmb.getItems().length; i++) {
			var oItem = oCmb.getItems()[i];
			if (oItem.getId() == oCmb.getSelectedItemId()) {
				iPosInSet =  i+1;
				break;
			}
		}
	}

	var mProps = {
			autocomplete: "inline",
			live: "polite",
			setsize: oCmb.getItems().length,
			posinset: (iPosInSet >= 0) ? iPosInSet : undefined
		};

	if (oCmb.getValueState() == sap.ui.core.ValueState.Error) {
		mProps["invalid"] = true;
	}

	rm.writeAccessibilityState(oCmb, mProps);

};

sap.ui.commons.ComboBoxRenderer.setEditable = function(oCmb, bEditable) {

	if (oCmb.mobile) {
		var $Select = oCmb.$("select");
		if (bEditable && oCmb.getEnabled()) {
			$Select.removeAttr("disabled");
		} else {
			$Select.attr("disabled", "disabled");
		}
	}

	sap.ui.commons.TextFieldRenderer.setEditable.apply(this, arguments);

};

sap.ui.commons.ComboBoxRenderer.setEnabled = function(oCmb, bEnabled) {

	if (oCmb.mobile) {
		var $Select = oCmb.$("select");
		if (bEnabled && oCmb.getEditable()) {
			$Select.removeAttr("disabled");
		} else {
			$Select.attr("disabled", "disabled");
		}
	}

	sap.ui.commons.TextFieldRenderer.setEnabled.apply(this, arguments);

};
}; // end of sap/ui/commons/ComboBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Dialog') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Dialog.
jQuery.sap.declare("sap.ui.commons.Dialog");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Dialog.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize</li>
 * <li>{@link #getScrollLeft scrollLeft} : int (default: 0)</li>
 * <li>{@link #getScrollTop scrollTop} : int (default: 0)</li>
 * <li>{@link #getTitle title} : string (default: '')</li>
 * <li>{@link #getApplyContentPadding applyContentPadding} : boolean (default: true)</li>
 * <li>{@link #getShowCloseButton showCloseButton} : boolean (default: true)</li>
 * <li>{@link #getResizable resizable} : boolean (default: true)</li>
 * <li>{@link #getMinWidth minWidth} : sap.ui.core.CSSSize</li>
 * <li>{@link #getMinHeight minHeight} : sap.ui.core.CSSSize</li>
 * <li>{@link #getMaxWidth maxWidth} : sap.ui.core.CSSSize</li>
 * <li>{@link #getMaxHeight maxHeight} : sap.ui.core.CSSSize</li>
 * <li>{@link #getContentBorderDesign contentBorderDesign} : sap.ui.commons.enums.BorderDesign (default: sap.ui.commons.enums.BorderDesign.None)</li>
 * <li>{@link #getModal modal} : boolean (default: false)</li>
 * <li>{@link #getAccessibleRole accessibleRole} : sap.ui.core.AccessibleRole (default: sap.ui.core.AccessibleRole.Dialog)</li>
 * <li>{@link #getKeepInWindow keepInWindow} : boolean (default: false)</li>
 * <li>{@link #getAutoClose autoClose} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getButtons buttons} : sap.ui.core.Control[]</li>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getDefaultButton defaultButton} : string | sap.ui.commons.Button</li>
 * <li>{@link #getInitialFocus initialFocus} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.Dialog#event:closed closed} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * An interactive window appearing on request displaying information to the user. The API supports features such as popups with fixed sizes, popups with unlimited width, scrolling bars for large windows, and control nesting (for example, a drop-down list can be included in the window).
 * @extends sap.ui.core.Control
 * @implements sap.ui.core.PopupInterface
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Dialog
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Dialog", { metadata : {

	interfaces : [
		"sap.ui.core.PopupInterface"
	],
	publicMethods : [
		// methods
		"open", "close", "isOpen", "getOpenState"
	],
	library : "sap.ui.commons",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"height" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"scrollLeft" : {type : "int", group : "Behavior", defaultValue : 0},
		"scrollTop" : {type : "int", group : "Behavior", defaultValue : 0},
		"title" : {type : "string", group : "Misc", defaultValue : ''},
		"applyContentPadding" : {type : "boolean", group : "Appearance", defaultValue : true},
		"showCloseButton" : {type : "boolean", group : "Behavior", defaultValue : true},
		"resizable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"minWidth" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"minHeight" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"maxWidth" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"maxHeight" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"contentBorderDesign" : {type : "sap.ui.commons.enums.BorderDesign", group : "Appearance", defaultValue : sap.ui.commons.enums.BorderDesign.None},
		"modal" : {type : "boolean", group : "Misc", defaultValue : false},
		"accessibleRole" : {type : "sap.ui.core.AccessibleRole", group : "Accessibility", defaultValue : sap.ui.core.AccessibleRole.Dialog},
		"keepInWindow" : {type : "boolean", group : "Behavior", defaultValue : false},
		"autoClose" : {type : "boolean", group : "Misc", defaultValue : false}
	},
	defaultAggregation : "content",
	aggregations : {
		"buttons" : {type : "sap.ui.core.Control", multiple : true, singularName : "button"}, 
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	},
	associations : {
		"defaultButton" : {type : "sap.ui.commons.Button", multiple : false}, 
		"initialFocus" : {type : "sap.ui.core.Control", multiple : false}
	},
	events : {
		"closed" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Dialog with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Dialog.extend
 * @function
 */

sap.ui.commons.Dialog.M_EVENTS = {'closed':'closed'};


/**
 * Getter for property <code>width</code>.
 * 
 * Outer width of dialog window. When not set and not constrained by one of the width parameters (minWidth/maxWidth), the window size is automatically adapted to the content.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.Dialog#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setWidth
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * 
 * Outer height of dialog window. When not set and not constrained by one of the height parameters (minHeight/maxHeight), the window size is automatically adapted to the content.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.ui.commons.Dialog#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setHeight
 * @function
 */


/**
 * Getter for property <code>scrollLeft</code>.
 * 
 * Scroll position from left to right. "0" means leftmost position.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>scrollLeft</code>
 * @public
 * @name sap.ui.commons.Dialog#getScrollLeft
 * @function
 */

/**
 * Setter for property <code>scrollLeft</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iScrollLeft  new value for property <code>scrollLeft</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setScrollLeft
 * @function
 */


/**
 * Getter for property <code>scrollTop</code>.
 * 
 * Scroll position from top to buttom. "0" means topmost position.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>scrollTop</code>
 * @public
 * @name sap.ui.commons.Dialog#getScrollTop
 * @function
 */

/**
 * Setter for property <code>scrollTop</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iScrollTop  new value for property <code>scrollTop</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setScrollTop
 * @function
 */


/**
 * Getter for property <code>title</code>.
 * 
 * Dialog title displayed in the header.
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>title</code>
 * @public
 * @name sap.ui.commons.Dialog#getTitle
 * @function
 */

/**
 * Setter for property <code>title</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sTitle  new value for property <code>title</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setTitle
 * @function
 */


/**
 * Getter for property <code>applyContentPadding</code>.
 * 
 * Padding is theme-dependent. When set to "false", the content extends to the dialog borders.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>applyContentPadding</code>
 * @public
 * @name sap.ui.commons.Dialog#getApplyContentPadding
 * @function
 */

/**
 * Setter for property <code>applyContentPadding</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bApplyContentPadding  new value for property <code>applyContentPadding</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setApplyContentPadding
 * @function
 */


/**
 * Getter for property <code>showCloseButton</code>.
 * 
 * Displays a close button in the title bar.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showCloseButton</code>
 * @public
 * @name sap.ui.commons.Dialog#getShowCloseButton
 * @function
 */

/**
 * Setter for property <code>showCloseButton</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowCloseButton  new value for property <code>showCloseButton</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setShowCloseButton
 * @function
 */


/**
 * Getter for property <code>resizable</code>.
 * 
 * Specifies whether the dialog window can be resized by the user. The dialog frame contains the visual symbol.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>resizable</code>
 * @public
 * @name sap.ui.commons.Dialog#getResizable
 * @function
 */

/**
 * Setter for property <code>resizable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bResizable  new value for property <code>resizable</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setResizable
 * @function
 */


/**
 * Getter for property <code>minWidth</code>.
 * 
 * Minimum outer width of the dialog window. When set, neither the user nor some layout settings can make the window smaller.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>minWidth</code>
 * @public
 * @name sap.ui.commons.Dialog#getMinWidth
 * @function
 */

/**
 * Setter for property <code>minWidth</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sMinWidth  new value for property <code>minWidth</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setMinWidth
 * @function
 */


/**
 * Getter for property <code>minHeight</code>.
 * 
 * Minimum outer height of the dialog window. When set, neither the user nor some layout settings can make the window smaller.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>minHeight</code>
 * @public
 * @name sap.ui.commons.Dialog#getMinHeight
 * @function
 */

/**
 * Setter for property <code>minHeight</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sMinHeight  new value for property <code>minHeight</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setMinHeight
 * @function
 */


/**
 * Getter for property <code>maxWidth</code>.
 * 
 * Maximum outer width of the dialog window. If set, neither the user nor some layout settings can make the window larger.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>maxWidth</code>
 * @public
 * @name sap.ui.commons.Dialog#getMaxWidth
 * @function
 */

/**
 * Setter for property <code>maxWidth</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sMaxWidth  new value for property <code>maxWidth</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setMaxWidth
 * @function
 */


/**
 * Getter for property <code>maxHeight</code>.
 * 
 * Maximum outer height of the dialog window. If set, neither the user nor some layout settings can make the window larger.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>maxHeight</code>
 * @public
 * @name sap.ui.commons.Dialog#getMaxHeight
 * @function
 */

/**
 * Setter for property <code>maxHeight</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sMaxHeight  new value for property <code>maxHeight</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setMaxHeight
 * @function
 */


/**
 * Getter for property <code>contentBorderDesign</code>.
 * 
 * Border design is theme-dependent.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.commons.enums.BorderDesign} the value of property <code>contentBorderDesign</code>
 * @public
 * @name sap.ui.commons.Dialog#getContentBorderDesign
 * @function
 */

/**
 * Setter for property <code>contentBorderDesign</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.commons.enums.BorderDesign} oContentBorderDesign  new value for property <code>contentBorderDesign</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setContentBorderDesign
 * @function
 */


/**
 * Getter for property <code>modal</code>.
 * Specify whether the dialog should be modal, or not. In case of <code>true</code> the focus is kept inside the dialog.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>modal</code>
 * @public
 * @name sap.ui.commons.Dialog#getModal
 * @function
 */

/**
 * Setter for property <code>modal</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bModal  new value for property <code>modal</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setModal
 * @function
 */


/**
 * Getter for property <code>accessibleRole</code>.
 * The ARIA role for the control. E.g. for alert-style Dialogs this can be set to "AlertDialog".
 *
 * Default value is <code>Dialog</code>
 *
 * @return {sap.ui.core.AccessibleRole} the value of property <code>accessibleRole</code>
 * @public
 * @name sap.ui.commons.Dialog#getAccessibleRole
 * @function
 */

/**
 * Setter for property <code>accessibleRole</code>.
 *
 * Default value is <code>Dialog</code> 
 *
 * @param {sap.ui.core.AccessibleRole} oAccessibleRole  new value for property <code>accessibleRole</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setAccessibleRole
 * @function
 */


/**
 * Getter for property <code>keepInWindow</code>.
 * Whether Dialog movement should be restricted to the visible area of the window. This only affects drag&drop movements by the user. This doesn't affect modal dialogs -> modal dialogs always stay in the window.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>keepInWindow</code>
 * @public
 * @since 1.9.0
 * @name sap.ui.commons.Dialog#getKeepInWindow
 * @function
 */

/**
 * Setter for property <code>keepInWindow</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bKeepInWindow  new value for property <code>keepInWindow</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.9.0
 * @name sap.ui.commons.Dialog#setKeepInWindow
 * @function
 */


/**
 * Getter for property <code>autoClose</code>.
 * If this property is set to true the Dialog will close if the Dialog loses its focus
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>autoClose</code>
 * @public
 * @since 1.10
 * @name sap.ui.commons.Dialog#getAutoClose
 * @function
 */

/**
 * Setter for property <code>autoClose</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bAutoClose  new value for property <code>autoClose</code>
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.10
 * @name sap.ui.commons.Dialog#setAutoClose
 * @function
 */


/**
 * Getter for aggregation <code>buttons</code>.<br/>
 * Aggregating the buttons to display at the bottom of the dialog, for example OK and Cancel. Association defaultButton can be used for one of the defined buttons.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.commons.Dialog#getButtons
 * @function
 */


/**
 * Inserts a button into the aggregation named <code>buttons</code>.
 *
 * @param {sap.ui.core.Control}
 *          oButton the button to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the button should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the button is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the button is inserted at 
 *             the last position        
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#insertButton
 * @function
 */

/**
 * Adds some button <code>oButton</code> 
 * to the aggregation named <code>buttons</code>.
 *
 * @param {sap.ui.core.Control}
 *            oButton the button to add; if empty, nothing is inserted
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#addButton
 * @function
 */

/**
 * Removes an button from the aggregation named <code>buttons</code>.
 *
 * @param {int | string | sap.ui.core.Control} vButton the button to remove or its index or id
 * @return {sap.ui.core.Control} the removed button or null
 * @public
 * @name sap.ui.commons.Dialog#removeButton
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>buttons</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Dialog#removeAllButtons
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>buttons</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oButton the button whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.Dialog#indexOfButton
 * @function
 */
	

/**
 * Destroys all the buttons in the aggregation 
 * named <code>buttons</code>.
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#destroyButtons
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Aggregating the content of the dialog (one or more controls).
 * 
 * Caveat: when content is added with width given as a percentage, the Dialog itself should have a width set.
 * 
 * <strong>Note</strong>: this is the default aggregation for Dialog.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.commons.Dialog#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.commons.Dialog#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Dialog#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.Dialog#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#destroyContent
 * @function
 */


/**
 * 
 * Defines one of the buttons that have been provided via button aggregation to be the default button. This default button is initially selected, if no control is set via the initialFocus association explicitly. The default button is activated when Enter is pressed in the context of the dialog and when the currently selected element does not handle the Enter event itself.
 *
 * @return {string} Id of the element which is the current target of the <code>defaultButton</code> association, or null
 * @public
 * @name sap.ui.commons.Dialog#getDefaultButton
 * @function
 */

/**
 * 
 * Defines one of the buttons that have been provided via button aggregation to be the default button. This default button is initially selected, if no control is set via the initialFocus association explicitly. The default button is activated when Enter is pressed in the context of the dialog and when the currently selected element does not handle the Enter event itself.
 *
 * @param {string | sap.ui.commons.Button} vDefaultButton 
 *    Id of an element which becomes the new target of this <code>defaultButton</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setDefaultButton
 * @function
 */


	
/**
 * 
 * Defines the control that shall get the focus when the dialog is opened.
 *
 * @return {string} Id of the element which is the current target of the <code>initialFocus</code> association, or null
 * @public
 * @name sap.ui.commons.Dialog#getInitialFocus
 * @function
 */

/**
 * 
 * Defines the control that shall get the focus when the dialog is opened.
 *
 * @param {string | sap.ui.core.Control} vInitialFocus 
 *    Id of an element which becomes the new target of this <code>initialFocus</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#setInitialFocus
 * @function
 */


	
/**
 * 
 * Event is fired when the user closes the dialog window. Event parameters provide information about last position and last size.
 *
 * @name sap.ui.commons.Dialog#closed
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.width the width of the dialog when closed
 * @param {int} oControlEvent.getParameters.height the height of the dialog when closed
 * @param {int} oControlEvent.getParameters.top the top position of the dialog when closed
 * @param {int} oControlEvent.getParameters.left the left position of the dialog when closed
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'closed' event of this <code>sap.ui.commons.Dialog</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Dialog</code>.<br/> itself. 
 *  
 * 
 * Event is fired when the user closes the dialog window. Event parameters provide information about last position and last size.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Dialog</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#attachClosed
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'closed' event of this <code>sap.ui.commons.Dialog</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Dialog#detachClosed
 * @function
 */

/**
 * Fire event closed to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'width' of type <code>int</code> the width of the dialog when closed</li>
 * <li>'height' of type <code>int</code> the height of the dialog when closed</li>
 * <li>'top' of type <code>int</code> the top position of the dialog when closed</li>
 * <li>'left' of type <code>int</code> the left position of the dialog when closed</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.Dialog} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.Dialog#fireClosed
 * @function
 */


/**
 * Opens the dialog control instance.
 *
 * @name sap.ui.commons.Dialog#open
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Closes the dialog control instance.
 *
 * @name sap.ui.commons.Dialog#close
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns whether the Dialog is open (this includes opening and closing animations). For more detailed information about the current state check Dialog.getOpenState().
 *
 * @name sap.ui.commons.Dialog#isOpen
 * @function
 * @type boolean
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns whether the Dialog is currently open, closed, or transitioning between these states.
 *
 * @name sap.ui.commons.Dialog#getOpenState
 * @function
 * @type sap.ui.core.OpenState
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\Dialog.js
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained


/**
 * Initialization hook for the dialog.
 * It creates the instance of the Popup helper service and does some basic configuration for it.
 *
 * @private
 */
sap.ui.commons.Dialog.prototype.init = function() {
   // do something for initialization...
   this.oPopup = new sap.ui.core.Popup(this, true, true);
   var eDock = sap.ui.core.Popup.Dock;
   this.oPopup.setPosition(eDock.CenterCenter, eDock.CenterCenter, window);

   this._minWidth = 64; // the technical minWidth, not the one set via API; will be calculated after rendering
   this._minHeight = 48; // the technical minHeight, not the one set via API; will be calculated after rendering
   // TODO: re-calculate after theme switch?!!

   this.allowTextSelection(false);
};

sap.ui.commons.Dialog.prototype.setInitialFocus = function(sId) {
	if (sId != null && typeof(sId) != "string") {
		sId = sId.getId();
	}
	this.oPopup.setInitialFocusId(sId);
	this.setAssociation("initialFocus", sId, true);
};

/**
 * Required adaptations after rendering.
 * @private
 */
sap.ui.commons.Dialog.prototype.onAfterRendering = function() {
	var $content = this.$("cont");

	// if content has 100% width, but Dialog has no width, set content width to auto
	if (!sap.ui.commons.Dialog._isSizeSet(this.getWidth()) && !sap.ui.commons.Dialog._isSizeSet(this.getMaxWidth())) {
		$content.children().each(function(index, element) {
			if (jQuery.trim(this.style.width) == "100%") {
				this.style.width = "auto";
			}
		});
	}

	// IE9+10 fix where subpixel font rendering may lead to rounding errors in RTL mode when the content has a width of "xyz.5px"
	if (!!sap.ui.Device.browser.internet_explorer && (sap.ui.Device.browser.version == 9 || sap.ui.Device.browser.version == 10) && ($content.length > 0)) {
		var elm = $content[0];
		if (sap.ui.getCore().getConfiguration().getRTL() && !sap.ui.commons.Dialog._isSizeSet(this.getWidth())) {
			if (elm.ownerDocument && elm.ownerDocument.defaultView && elm.ownerDocument.defaultView.getComputedStyle) {
				var width = elm.ownerDocument.defaultView.getComputedStyle(elm).getPropertyValue("width");
				if (width) {
					var fWidth = parseFloat(width, 10);
					if (fWidth % 1 == 0.5) {
						$content[0].style.width = (fWidth + 0.01) + "px"; // if aaaalll these conditions are fulfilled, the Dialog must be a LITTLE bit wider to avoid rounding errors
					}
				}
			}
		}
	}
	
	// if height is not set, but min-height is set, the Dialog is in a mixed mode between fixed height and flexible height 
	// (denoted by sapUiDlgFlexHeight), where sometimes the content pushes the height (when it is tall enough) and sometimes
	// the Dialog needs to take care to push the button row to the bottom (when there is less content than what would fit into a Dialog
	// with min-height size).
	// Therefore we need to check which one of both cases is currently active.
	if (!sap.ui.commons.Dialog._isSizeSet(this.getHeight()) && sap.ui.commons.Dialog._isSizeSet(this.getMinHeight())) {
		// height is not set, so the content height should push the height - denoted by the CSS class "sapUiDlgFlexHeight" which applies a simple layout
		// where header, content, and footer are stacked on top of each other
		
		// however, when there is a minHeight set which is larger than the natural height, the footer would be not at the bottom, so let's check whether the Dialog
		// is now smaller than the min-height:
		var footer = this.getDomRef("footer");
		var footerBottom = footer.offsetTop + footer.offsetHeight;
		var dialogBottom = this.getDomRef().offsetHeight;
		if (footerBottom < dialogBottom) {
			this.$().removeClass("sapUiDlgFlexHeight");
		} else { 
			// normal case: Dialog content pushes its height to or beyond its minimum height - this works fine with "sapUiDlgFlexHeight"
		}
	}

	// Calculate min size
	var _minSize = this.getMinSize();
	this._minWidth = _minSize.width;
	this._minHeight = _minSize.height;
};

/**
 * Handle the click event happening on the dialog instance.
 *
 * TODO also raise some event when click on 'x'
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.onclick = function(oEvent) {
	switch(oEvent.target.id) {
	case this.getId() + "-close":
		this.close();
		oEvent.preventDefault(); // avoid onbeforeunload event which happens at least in IE9 because of the javascript:void(0); link target
		break;
	};
	return false;
};

/**
 * Opens this instance of dialog
 * @public
 */
sap.ui.commons.Dialog.prototype.open = function() {

	if ( !this.oPopup ) {
		// TODO discuss behavior of destroyed controls in general
		jQuery.sap.log.fatal("This dialog instance has been destroyed already");
		return;
	}
	if ( this._bOpen ) {
		return;
	}

	// Save current focused element to restore the focus after closing the dialog
	this._oPreviousFocus = sap.ui.core.Popup.getCurrentFocusInfo();

	this.oPopup.attachEvent("opened", this.handleOpened, this);
	this.oPopup.attachEvent("closed", this.handleClosed, this);
	this.oPopup.setModal(this.getModal());
	this.oPopup.setAutoClose(this.getAutoClose());
	this.oPopup.open(400);
	this._bOpen = true;
};


/**
 * @private
 */
sap.ui.commons.Dialog.prototype._handleOpened = function() {
	var sInitFocus = this.getInitialFocus(),
	oFocusCtrl;
	if(sInitFocus && (oFocusCtrl = sap.ui.getCore().getControl(sInitFocus))){ // an additional previous check was  oFocusCtrl.getParent() === this  which prevented nested children from being focused
		oFocusCtrl.focus();
		this._bInitialFocusSet = true;
	} else {
		sInitFocus = this.getDefaultButton();
		if(sInitFocus && (oFocusCtrl = sap.ui.getCore().getControl(sInitFocus)) && oFocusCtrl.getParent() === this){
			oFocusCtrl.focus();
			this._bInitialFocusSet = true;
		} else if (this.getButtons().length > 0) {
			this.getButtons()[0].focus();// TODO is this wanted?
			this._bInitialFocusSet = true;
		} else if(this.getContent().length > 0){
			// let's at least focus something in the Dialog
			this.getContent()[0].focus();
			this._bInitialFocusSet = true;
		}
	}
};

sap.ui.commons.Dialog.prototype.handleOpened = function() {
	this.oPopup.detachEvent("opened", this.handleOpened, this);

	if (sap.ui.Device.browser.internet_explorer &&  sap.ui.Device.browser.version === 11) {
		// a delayed call is needed for IE11. Since it fires the opened event before all stuff
		// is visible. All stuff is added to the DOM though and all operations can be done
		// but a focus seems to work (there is no error) but the focus can't be set to something
		// that isn't really visible
		jQuery.sap.clearDelayedCall(this._delayedCallId);
		this._delayedCallId = jQuery.sap.delayedCall(0, this, this._handleOpened); 
	} else {
		this._handleOpened();
	}
};

/**
 * Closes this Dialog
 * @public
 */
sap.ui.commons.Dialog.prototype.close = function() {

	if ( !this._bOpen ) {
		return;
	}

	var oRect = this.$().rect();

	this._bOpen = false;
	this._bInitialFocusSet = false;
	this.oPopup.close(400);

	// do this delayed or it possibly won't work because of popup closing animations
	jQuery.sap.delayedCall(400, this, "restorePreviousFocus");

	jQuery.each(oRect, function(key, val){
		oRect[key] = parseInt(val, 10);
	});
	
	this._oRect = oRect;
};

sap.ui.commons.Dialog.prototype.handleClosed = function() {
	this.oPopup.detachEvent("closed", this.handleClosed, this);

	this.fireClosed(this._oRect);
	this.close();
};

/**
 * restore the focus when the dialog was closed to the control which opened the dialog.
 * This is independent of the dialogs modal state. The popup also restores focus when using modal popups/dialogs.
 * @private
 */
sap.ui.commons.Dialog.prototype.restorePreviousFocus = function() {
	sap.ui.core.Popup.applyFocusInfo(this._oPreviousFocus);
};


sap.ui.commons.Dialog.prototype.setTitle = function (sText) {
	this.setProperty("title", sText, true); // last parameter avoids invalidation
	this.$("lbl").text(sText);
	return this;
};

/**
 * Destroys this instance of dialog, called by Element#destroy()
 * @private
 */
sap.ui.commons.Dialog.prototype.exit = function() {
	// only fire the closed event if the dialog was open
	var bWasOpen = this.isOpen();
	this.close();

	// just to ensure that any attached event is being detached
	this.oPopup.detachEvent("opened", this.handleOpened, this);
	this.oPopup.detachEvent("closed", this.handleClosed, this);
	
	this.oPopup.destroy();
	if (bWasOpen) {
		this.fireClosed(this._oRect);
	}
	this.oPopup = null;
};

/**
 * Checks whether the given sCssSize is an explicit value, or not (e.g. auto, inherit).
 *
 * @param {string} sCssSize The CSS string to check for being explicit value.
 * @return {boolean} whether The given sCssSize is an explicit value, or not (e.g. auto, inherit).
 * @private
 */
sap.ui.commons.Dialog._isSizeSet = function(sCssSize) {
	return (sCssSize && !(sCssSize == "auto") && !(sCssSize == "inherit"));
};

/**
 * Handles the sapescape event, triggers closing of the window.
 * TODO also raise some event like with the click on 'x'
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.onsapescape = function(oEvent) {
	this.close();

	oEvent.preventDefault();
	oEvent.stopPropagation();
};

/**
 * Handles the sapenter event, triggers the default button of the dialog.
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.onsapenter = function(oEvent) {
	// See open-method
	var oFocusCtrl,
		sInitFocus = this.getDefaultButton();

	// trigger the default button if it exists and is inside the Dialog
	if(sInitFocus && (oFocusCtrl = sap.ui.getCore().byId(sInitFocus)) && jQuery.contains(this.getDomRef(), oFocusCtrl.getDomRef())) {
		// Okay, we have the control
		if (oFocusCtrl instanceof sap.ui.commons.Button) {
			oFocusCtrl.onclick(oEvent);
		} // FIXME is this really the way it should be?
	}

	oEvent.preventDefault();
	oEvent.stopPropagation();
};

/**
 * Event handler for the focusin event.
 * If it occurs on the focus handler elements at the beginning of the dialog, the focus is set to the end, and vice versa.
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.onfocusin = function(oEvent){
	this.sLastRelevantNavigation = null;
	
	if (!this._bInitialFocusSet) {
		// since IE9 calls first "onfocusin" it has to be checked if the initial focus was set already
		return;
	}

	var sFirstFocusable = this.getId() + "-fhfe";
	var sLastFocusable = this.getId() + "-fhee";
	
	var oSourceDomRef = oEvent.target;
	var oFocusDomRef = undefined;
	var $FocusablesCont = jQuery(":sapFocusable", this.$("cont"));
	var $FocusablesFoot = jQuery(":sapFocusable", this.$("footer"));

	/*
	 * It's not needed to check if buttons are set since jQuery(":focusable", jQuery.sap.byId(this.getId() + "-fhfe")) 
	 * or jQuery(":sapFocusable", jQuery.sap.byId(this.getId() + "-fhfe")) returns an empty array. Therefore these
	 * elements won't be found via 'lastFocusableDomRef()'
	 */
	if (oSourceDomRef.id === sFirstFocusable) {
		// the FocusHandlingFirstElement was focused and thus the focus should move to the last element.
		if ($FocusablesFoot.length > 0) {
			oFocusDomRef = $FocusablesFoot[$FocusablesFoot.length-1];
		} else {
			oFocusDomRef = $FocusablesCont[$FocusablesCont.length-1];
		}
	} else if (oSourceDomRef.id === sLastFocusable) {
		// the FocusHandlingEndElement was focused and thus the focus should move to the first element.
		if ($FocusablesCont.length > 0) {
			oFocusDomRef = $FocusablesCont[0];
		} else {
			oFocusDomRef = $FocusablesFoot[0];
		}
	}
	
	if (oFocusDomRef) {
		/*
		 * This check especially for IE9 is needed because when IE9 is used together with JAWS the element that will be 
		 * focused isn't read when the focus happens too fast. Therefore a delay is added to JAWS can read the newly
		 * focused element. 
		 */
		var iDelay = sap.ui.Device.browser.msie &&  sap.ui.Device.browser.version === 9 ? 100 : 0;

		jQuery.sap.delayedCall(iDelay, this, function(){
			// if the element is a control the focus should be called via the control
			// especially if the control has an individual focus DOM-ref
			if (sap.ui.getCore().byId(oFocusDomRef.id) instanceof sap.ui.core.Control) {
				oFocusDomRef.focus(); 
			} else {
				jQuery.sap.focus(oFocusDomRef); 
			}
		});
	}
};

/**
 * Restores the focus in case it got lost beforehand e.g. by leaving the dialog or the whole window.
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.restoreFocus = function() {
	if (this.oRestoreFocusInfo && this.oPopup.bOpen) { // do not restore the focus if Dialog is no longer open  TODO: where is the focus going, then? The Toolbar testpage at least works fine.
		var oCtrl = sap.ui.getCore().getControl(this.oRestoreFocusInfo.sFocusId);
		if (oCtrl) {
			oCtrl.applyFocusInfo(this.oRestoreFocusInfo.oFocusInfo);
		}
	}
};

/**
 * Handles or cancels the selectstart event when occuring in parts of the dialog.
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.onselectstart = function(oEvent) {
	if (!jQuery.sap.containsOrEquals(this.getDomRef("cont"), oEvent.target)) {
		oEvent.preventDefault();
		oEvent.stopPropagation();
	}
};

/**
 * Get minimal reasonable size of the dialog given its inner elements. Call is recommended after rendering.
 *
 * @return {Object} An object with inner structure {width:{int}, height:{int}}
 * @private
 */
sap.ui.commons.Dialog.prototype.getMinSize = function () {

	var oDialog = jQuery.sap.domById(this.sId), oTitle = jQuery.sap.domById(this.sId + "-hdr"), oFooter = jQuery.sap.domById(this.sId + "-footer"),
		heightTitle=0, widthFooter=0, heightFooter=0;

	var oFooterBtns = jQuery(oFooter).children("DIV").get(0);
	widthFooter = oFooterBtns.offsetWidth;

	var addValue = 0;
	// add border and padding of footer...not margin
	addValue += jQuery(oFooter).outerWidth(false) - jQuery(oFooter).width();
	// add border and padding of footer...not margin
	addValue += jQuery(oDialog).outerWidth(false) - jQuery(oDialog).width();

	// if there is a too small specific border value add +20 for certainty to avoid wrapping
	if (addValue <= 20) {
	 addValue = 20;
	}

	widthFooter += addValue;

	if (isNaN(widthFooter) || widthFooter < 100) {
		widthFooter = 100;
	}

	heightTitle = oTitle.offsetHeight;
	heightFooter = oFooter.offsetHeight;
	return {
		width: widthFooter,
		height: heightTitle + heightFooter + 36 /* min. height content */
	};
};


// Implementation of API method isOpen
sap.ui.commons.Dialog.prototype.isOpen = function(){
	return this.oPopup.isOpen();
};

// Implementation of API method isOpen
sap.ui.commons.Dialog.prototype.getOpenState = function(){
	return this.oPopup.getOpenState();
};

/**
 * Whether the dialog is currently enabled or not.
 * 
 * Applications can't control the enabled state via a property. A dialog is implicitly 
 * enabled depending on its <code>openState</code>. Descendant controls that honor the 
 * enabled state of their ancestors will appear disabled after the dialog is closed.
 * 
 * @experimental Whether a dialog is regarded as "enabled" during the state transitions 
 * (OPENING, CLOSING) is not fully decided. Currently, it is enabled during the OPENING phase 
 * and disabled during the CLOSING phase. The only potential change would be to treat the 
 * OPENING phase as disabled as well. Applications should be prepared to receive events from
 * "enabled" controls after they called open() on the dialog until close() is called on it.
 * If the mentioned potential change should happen, the dialog will become enabled only 
 * after the transition to OPEN. Events from "enabled" children then can still only arrive 
 * between open() and close(), so applications that obey the previous rule should continue 
 * to work. Only end users or code  that explicitly triggers pseudo user events will notice 
 * a difference. <br>
 * A second aspect that might change is the visual behavior of the content: during the CLOSING 
 * phase it 'looks' enabled but in fact it is already disabled. This avoids unnecessary redraws 
 * for content that becomes hidden soon. Should this show to be confusing for end users, it might 
 * be changed.
 * 
 * @return {boolean} whether the dialog is currently enabled or not.
 * @public
 */
sap.ui.commons.Dialog.prototype.getEnabled = function() {
  var eState = this.getOpenState();
  // TODO the check for state OPENING is a compromise. Without that, the content of the dialog will render 
  // in disabled state but will be enabled. As an alternative, the dialog could render again after OPEN is reached
  // and after switching to CLOSING (to properly reflect the changed enabled state in the descendants) 
  return eState === sap.ui.core.OpenState.OPENING || eState === sap.ui.core.OpenState.OPEN;
};

// **************************************************
// 'Legacy' Resize and Move handling including jQuery-UI parts for that would bring in 70k (uncompressed)
// **************************************************

/**
* Handles the dragstart event.
* In case of resize currently ongoing, this cancels the dragstart.
* @param {sap.ui.core.BroserEvent} oEvent The forwarded browser event
* @private
*/
sap.ui.commons.Dialog.prototype.ondragstart = function(oEvent){
	if(this.sDragMode == "resize" || this.sDragMode == "move") {
		oEvent.preventDefault();
		oEvent.stopPropagation();
	}
};

/**
 * Initializes drag and move capabilities.

 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.onmousedown = function (oEvent) {

	var oSource = oEvent.target,
		sId = this.getId();

	this._bRtlMode = sap.ui.getCore().getConfiguration().getRTL(); // remember the RTL mode for the starting resize operation

	if(jQuery.sap.containsOrEquals(this.getDomRef("hdr"), oSource)) {
		if (oSource.id != (sId + "-close")) {
			this.sDragMode = "move";
			this._RootWidth = this.getDomRef().offsetWidth;
			this._RootHeight = this.getDomRef().offsetHeight;
		}
	} else if(oSource.id == sId + "-grip") {
		this.sDragMode = "resize";

		// Now the dialog is fixed-width and fixed-height; write them to the element and adapt its classes to switch positioning
		var oDomRef = this.getDomRef();
		var sWidth = oDomRef.offsetWidth + "px";
		oDomRef.style.width = sWidth;
		var sHeight = oDomRef.offsetHeight + "px";
		oDomRef.style.height = sHeight;
		jQuery(oDomRef).removeClass("sapUiDlgFlexHeight sapUiDlgFlexWidth");
		// ...also remember the dimensions for the future (e.g. for after rerendering) - but do not cause rerendering now
		this.setProperty("width", sWidth, true);
		this.setProperty("height", sHeight, true);
	}

	if (this.sDragMode == null) {
		return;
	}

	// save current focused control for restoring later in restore focus
	var oActElement = document.activeElement;
	if (oActElement && oActElement.id){
		var oCtrl = jQuery.sap.byId(oActElement.id).control(0);
		if(oCtrl) {
			this.oRestoreFocusInfo = {sFocusId: oCtrl.getId(), oFocusInfo: oCtrl.getFocusInfo()};
		}
	}

	// Calculate event X,Y coordinates
	this.startDragX = oEvent.screenX;
	this.startDragY = oEvent.screenY;

	this.originalRectangle = this.$().rect();

	jQuery(window.document).bind("selectstart", jQuery.proxy(this.ondragstart, this));
	jQuery(window.document).bind("mousemove", jQuery.proxy(this.handleMove, this));
	jQuery(window.document).bind("mouseup", jQuery.proxy(this.handleMouseUp, this));

	var outerDoc = sap.ui.commons.Dialog._findSameDomainParentWinDoc();
	if (outerDoc) {
		jQuery(outerDoc).bind("selectstart", jQuery.proxy(this.ondragstart, this));
		jQuery(outerDoc).bind("mousemove", jQuery.proxy(this.handleMove, this));
		jQuery(outerDoc).bind("mouseup", jQuery.proxy(this.handleMouseUp, this));
	}

};


/**
 * Returns the document of the parent window which is highest up in the hierarchy of parent windows, but still belongs
 * to the same domain (so its document is accessible)
 *
 * @private
 */
sap.ui.commons.Dialog._findSameDomainParentWinDoc = function() {
	var outerDoc = null;
	try {
		var win = window;
		while (win.parent && (win.parent != win)) {
			if (win.parent.document) {
				outerDoc = win.parent.document;
				win = win.parent;
			}
		}
	} catch(e) {
		// parent is in a different domain, so we cannot listen to mouse events there
		// outerWindow is now either null or the highest possible parent window (!= the document's window) in the same domain
	}
	return outerDoc;
};


/**
 * Handles the move event taking the current dragMode into account.
 * @param {DOMEvent} event The event raised by the browser.
 * @private
 */
sap.ui.commons.Dialog.prototype.handleMove = function (event) {

	if (!this.sDragMode) {
		return;
	}

	event = event || window.event;

	if (this.sDragMode == "resize") {

		var deltaX = event.screenX - this.startDragX;
		var deltaY = event.screenY - this.startDragY;

		var w = (this._bRtlMode ? this.originalRectangle.width - deltaX : this.originalRectangle.width + deltaX);
		var h = this.originalRectangle.height + deltaY;

		w = Math.max(w, this._minWidth);
		h = Math.max(h, this._minHeight);

		// The dimension constraints set via API could be in any CSS unit, so just set the size and do checks
		// (min/max override what was set here)
		var oDomRef = this.getDomRef();
		oDomRef.style.width = w + "px";
		oDomRef.style.height = h + "px";

		// Now use the actual size of the dialog, which might have been constrained by min-*/max-* for resizing the popup and the shadow
		w = this.getDomRef().offsetWidth;
		h = this.getDomRef().offsetHeight;

		// In IE8, style.width/height will still have the old values - possibly outside this Dialog's size constraints.
		// The Dialog box itself will stay correctly constrained, but its child elements will be positioned as if the style.width/height
		// values were the actual size, so for this browser - and to be cleaner - explicitly set these sizes. This is an IE8 bug.
		oDomRef.style.width = w + "px";
		oDomRef.style.height = h + "px";

		// Also remember the dimensions for the future (e.g. for after rerendering) - but do not cause rerendering now
		this.setProperty("width", w+"px", true);
		this.setProperty("height", h+"px", true);

	} else if (this.sDragMode == "move") {

		var iLeft = this.originalRectangle.left + event.screenX - this.startDragX;
		var iTop = this.originalRectangle.top + event.screenY - this.startDragY;

		iTop = Math.max(iTop, 0); // should not move the Dialog beyond the top border - otherwise it cannot be moved back
		if (this._bRtlMode || this._keepInWindow()) {
			iLeft = Math.min(iLeft, document.documentElement.clientWidth - this._RootWidth); // in RTL mode, do not move beyond the right window border
		}
		if (!this._bRtlMode || this._keepInWindow()) {
			iLeft = Math.max(iLeft, 0); // in LTR mode do not move the Dialog beyond the left border
		}
		if (this._keepInWindow()) {
			iTop = Math.min(iTop, document.documentElement.clientHeight - this._RootHeight);
		}

		this.oPopup.setPosition(sap.ui.core.Popup.Dock.LeftTop, {left:iLeft, top:iTop});
	}

	event.cancelBubble = true;
	return false;
};

/**
 * This function checks if the "keepInWindow" property is set or if the Dialog is modal.
 * Modal Dialogs mustn't not leave the window also.
 * 
 * @returns {boolean} if the Dialog must leave the window area
 * @private
 */
sap.ui.commons.Dialog.prototype._keepInWindow = function () {
	return this.getKeepInWindow() || this.getModal();
};


/**
 * Handle mouseup event.
 * This does the cleanup after drag and move handling.
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.ui.commons.Dialog.prototype.handleMouseUp = function (oEvent) {

	if (this.sDragMode == null) {
		return;
	}

	jQuery(window.document).unbind("selectstart", this.ondragstart);
	jQuery(window.document).unbind("mousemove", this.handleMove);
	jQuery(window.document).unbind("mouseup", this.handleMouseUp);

	var outerDoc = sap.ui.commons.Dialog._findSameDomainParentWinDoc();
	if (outerDoc) {
		jQuery(outerDoc).unbind("selectstart", this.ondragstart);
		jQuery(outerDoc).unbind("mousemove", this.handleMove);
		jQuery(outerDoc).unbind("mouseup", this.handleMouseUp);
	}

	if(!!sap.ui.Device.browser.webkit){
		//Force Webkit Browsers to do a repaint
		sap.ui.core.RenderManager.forceRepaint(this.getId());
	}

	// Set back focus to previously focused element
	this.restoreFocus();
	this.sDragMode = null;

};

sap.ui.commons.Dialog.setAutoClose = function(bAutoclose){
	this.oPopup.setAutoClose(bAutoclose);
};
sap.ui.commons.Dialog.getAutoClose = function(){
	this.oPopup.getAutoClose();
};

}; // end of sap/ui/commons/Dialog.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.DropdownBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.DropdownBox
jQuery.sap.declare("sap.ui.commons.DropdownBoxRenderer");


/**
 * @class DropdownBox renderer.
 * @static
 */
sap.ui.commons.DropdownBoxRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.ComboBoxRenderer);

/**
 * Renders additional HTML for the DropdownBox to the TextField before the INPUT element (sets the icon)
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oDdb an object representation of the control that should be rendered
 */
sap.ui.commons.DropdownBoxRenderer.renderOuterContentBefore = function(rm, oDdb){

	this.renderExpander(rm, oDdb);

};

/**
 * Renders additional HTML for the DropdownBox to the TextField after the INPUT element (sets the select box)
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oDdb an object representation of the control that should be rendered
 */
sap.ui.commons.DropdownBoxRenderer.renderOuterContent = function(rm, oDdb){

	this.renderSelectBox(rm, oDdb, '0');

};

/**
 * Used to set the tabindex of the dropdownbox to -1
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oDdb an object representation of the control that should be rendered
 */
sap.ui.commons.DropdownBoxRenderer.renderTextFieldEnabled = function(rm, oDdb) {

	if (oDdb.mobile) {
		rm.writeAttribute('tabindex', '-1');
	}else if(!oDdb.getEnabled()){
		rm.writeAttribute('disabled', 'disabled');
		rm.writeAttribute('tabindex', '-1');
	}else if(!oDdb.getEditable()){
		rm.writeAttribute('tabindex', '0');
	}else{
		rm.writeAttribute('tabindex', '0');
	}

};

/*
 * Renders ARIA information for the dropdownbox (outer &lt;div&gt;)
 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
 * @private
 */
sap.ui.commons.DropdownBoxRenderer.renderARIAInfo = function(rm, oDdb) {

	var iPosInSet = -1;
	if(oDdb.getSelectedItemId()){
		for ( var i = 0; i < oDdb.getItems().length; i++) {
			var oItem = oDdb.getItems()[i];
			if (oItem.getId() == oDdb.getSelectedItemId()) {
				iPosInSet =  i+1;
				break;
			}
		}
	}

	var mProps = {
			autocomplete: "list",
			live: "polite",
			setsize: oDdb.getItems().length,
			posinset: (iPosInSet >= 0) ? iPosInSet : undefined
		};

	if (oDdb.getValueState() == sap.ui.core.ValueState.Error) {
		mProps["invalid"] = true;
	}

	rm.writeAccessibilityState(oDdb, mProps);

};
}; // end of sap/ui/commons/DropdownBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FileUploader') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.FileUploader.
jQuery.sap.declare("sap.ui.commons.FileUploader");

jQuery.sap.require('sap.ui.unified.FileUploader'); // unlisted dependency retained



/**
 * Constructor for a new FileUploader.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.FileUploader#constructor sap.ui.unified.FileUploader}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The framework generates an input field and a button with text "Browse ...". The API supports features such as on change uploads (the upload starts immediately after a file has been selected), file uploads with explicit calls, adjustable control sizes, text display after uploads, or tooltips containing complete file paths.
 * @extends sap.ui.unified.FileUploader
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.21.0. 
 * Please use the control sap.ui.unified.FileUploader of the library sap.ui.unified instead.
 * @name sap.ui.commons.FileUploader
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.FileUploader.extend("sap.ui.commons.FileUploader", { metadata : {

	deprecated : true,
	library : "sap.ui.commons"
}});


/**
 * Creates a new subclass of class sap.ui.commons.FileUploader with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.FileUploader.extend
 * @function
 */


// Start of sap\ui\commons\FileUploader.js
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)
 * 
 * (c) Copyright 2009-2014 SAP SE. All rights reserved
 */

jQuery.sap.declare("sap.ui.commons.FileUploader");

(function(){

	try{
		sap.ui.getCore().loadLibrary("sap.ui.unified");
	}catch(e){
		alert("The control 'sap.ui.commons.FileUploader' needs library 'sap.ui.unified'.");
		throw(e);
	}

})();
}; // end of sap/ui/commons/FileUploader.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FileUploaderParameter') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.FileUploaderParameter.
jQuery.sap.declare("sap.ui.commons.FileUploaderParameter");

jQuery.sap.require('sap.ui.unified.FileUploaderParameter'); // unlisted dependency retained



/**
 * Constructor for a new FileUploaderParameter.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.FileUploaderParameter#constructor sap.ui.unified.FileUploaderParameter}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Represents a parameter for the FileUploader which is rendered as a hidden inputfield.
 * @extends sap.ui.unified.FileUploaderParameter
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.21.0. 
 * Please use the element sap.ui.unified.FileUploaderParameter of the library sap.ui.unified instead.
 * @name sap.ui.commons.FileUploaderParameter
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.FileUploaderParameter.extend("sap.ui.commons.FileUploaderParameter", { metadata : {

	deprecated : true,
	library : "sap.ui.commons"
}});


/**
 * Creates a new subclass of class sap.ui.commons.FileUploaderParameter with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.FileUploaderParameter.extend
 * @function
 */


// Start of sap\ui\commons\FileUploaderParameter.js
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)
 * 
 * (c) Copyright 2009-2014 SAP SE. All rights reserved
 */

jQuery.sap.declare("sap.ui.commons.FileUploaderParameter");

(function(){

	try{
		sap.ui.getCore().loadLibrary("sap.ui.unified");
	}catch(e){
		alert("The element 'sap.ui.commons.FileUploaderParameter' needs library 'sap.ui.unified'.");
		throw(e);
	}

})();
}; // end of sap/ui/commons/FileUploaderParameter.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FormattedTextView') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.FormattedTextView.
jQuery.sap.declare("sap.ui.commons.FormattedTextView");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new FormattedTextView.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getAccessibleRole accessibleRole} : sap.ui.core.AccessibleRole (default: sap.ui.core.AccessibleRole.Document)</li>
 * <li>{@link #getHtmlText htmlText} : string (default: "")</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getControls controls} : sap.ui.commons.FormattedTextViewControl[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Allows to use a limited set of HTML tags for display
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.9.0
 * @name sap.ui.commons.FormattedTextView
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.FormattedTextView", { metadata : {

	publicMethods : [
		// methods
		"setContent"
	],
	library : "sap.ui.commons",
	properties : {
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"accessibleRole" : {type : "sap.ui.core.AccessibleRole", group : "Accessibility", defaultValue : sap.ui.core.AccessibleRole.Document},
		"htmlText" : {type : "string", group : "Misc", defaultValue : ""}
	},
	aggregations : {
		"controls" : {type : "sap.ui.commons.FormattedTextViewControl", multiple : true, singularName : "control"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.FormattedTextView with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.FormattedTextView.extend
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Flag to suppress rendering of the FormattedTextView control
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.FormattedTextView#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.FormattedTextView} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.FormattedTextView#setVisible
 * @function
 */


/**
 * Getter for property <code>accessibleRole</code>.
 * The ARIA role for the control.
 *
 * Default value is <code>Document</code>
 *
 * @return {sap.ui.core.AccessibleRole} the value of property <code>accessibleRole</code>
 * @public
 * @name sap.ui.commons.FormattedTextView#getAccessibleRole
 * @function
 */

/**
 * Setter for property <code>accessibleRole</code>.
 *
 * Default value is <code>Document</code> 
 *
 * @param {sap.ui.core.AccessibleRole} oAccessibleRole  new value for property <code>accessibleRole</code>
 * @return {sap.ui.commons.FormattedTextView} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.FormattedTextView#setAccessibleRole
 * @function
 */


/**
 * Getter for property <code>htmlText</code>.
 * Text with placeholders
 *
 * Default value is <code>""</code>
 *
 * @return {string} the value of property <code>htmlText</code>
 * @public
 * @name sap.ui.commons.FormattedTextView#getHtmlText
 * @function
 */

/**
 * Setter for property <code>htmlText</code>.
 *
 * Default value is <code>""</code> 
 *
 * @param {string} sHtmlText  new value for property <code>htmlText</code>
 * @return {sap.ui.commons.FormattedTextView} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.FormattedTextView#setHtmlText
 * @function
 */


/**
 * Getter for aggregation <code>controls</code>.<br/>
 * Array of controls that should be replaced within htmlText
 * 
 * @return {sap.ui.commons.FormattedTextViewControl[]}
 * @public
 * @name sap.ui.commons.FormattedTextView#getControls
 * @function
 */


/**
 * Inserts a control into the aggregation named <code>controls</code>.
 *
 * @param {sap.ui.commons.FormattedTextViewControl}
 *          oControl the control to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the control should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the control is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the control is inserted at 
 *             the last position        
 * @return {sap.ui.commons.FormattedTextView} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.FormattedTextView#insertControl
 * @function
 */

/**
 * Adds some control <code>oControl</code> 
 * to the aggregation named <code>controls</code>.
 *
 * @param {sap.ui.commons.FormattedTextViewControl}
 *            oControl the control to add; if empty, nothing is inserted
 * @return {sap.ui.commons.FormattedTextView} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.FormattedTextView#addControl
 * @function
 */

/**
 * Removes an control from the aggregation named <code>controls</code>.
 *
 * @param {int | string | sap.ui.commons.FormattedTextViewControl} vControl the control to remove or its index or id
 * @return {sap.ui.commons.FormattedTextViewControl} the removed control or null
 * @public
 * @name sap.ui.commons.FormattedTextView#removeControl
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>controls</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.commons.FormattedTextViewControl[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.FormattedTextView#removeAllControls
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.commons.FormattedTextViewControl</code> in the aggregation named <code>controls</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.commons.FormattedTextViewControl}
 *            oControl the control whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.FormattedTextView#indexOfControl
 * @function
 */
	

/**
 * Destroys all the controls in the aggregation 
 * named <code>controls</code>.
 * @return {sap.ui.commons.FormattedTextView} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.FormattedTextView#destroyControls
 * @function
 */


/**
 * Sets text with placeholders and given array of controls
 *
 * @name sap.ui.commons.FormattedTextView#setContent
 * @function
 * @param {string} sHtmlText
 *         Contains the corresponding HTML-text
 * @param {sap.ui.commons.FormattedTextViewControl} oControls
 *         Array of controls that should be used within given HTML-text
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\FormattedTextView.js
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained


(function() {
	sap.ui.commons.FormattedTextView.prototype.init = function() {
		this._aAllowedInterfaces = [];
		this._aAllowedInterfaces[0] = "sap.ui.commons.FormattedTextViewControl";

		/*
		 * these are the rules for the FormattedTextView
		 */
		this._ftv = {};

		// rules for the allowed attributes
		this._ftv.ATTRIBS = {
			'span::class' : 1,
			'div::class' : 1,
			'div::id' : 1,
			'span::id' : 1,
			'embed::data-index' : 1
		};

		// rules for the allowed tags
		this._ftv.ELEMENTS = {
			// Text Module Tags
			'abbr' : 1,
			'acronym' : 1,
			'address' : 1,
			'blockquote' : 1,
			'br' : 1,
			'cite' : 1,
			'code' : 1,
			'dfn' : 1,
			'div' : 1,
			'em' : 1,
			'h1' : 1,
			'h2' : 1,
			'h3' : 1,
			'h4' : 1,
			'h5' : 1,
			'h6' : 1,
			'kbd' : 1,
			'p' : 1,
			'pre' : 1,
			'q' : 1,
			'samp' : 1,
			'strong' : 1,
			'span' : 1,
			'var' : 1,

			// List Module Tags
			'dl' : 1,
			'dt' : 1,
			'dd' : 1,
			'ol' : 1,
			'ul' : 1,
			'li' : 1,

			// Special Tags
			// this is the placeholder for the controls
			'embed' : 1

		// TODO maybe add these tags (if someone really need this)
		// 'a' : 1, currently used via Link-Control
		// 'img' : 1, currently used via Image-Control
		};
	};
	sap.ui.commons.FormattedTextView.prototype.exit = function() {
		delete this._aAllowedInterfaces;

		delete this._ftv;
	};

	sap.ui.commons.FormattedTextView.prototype.hasControls = function() {
		var aControls = this.getAggregation("controls");
		if (aControls && aControls.length > 0) {
			return true;
		}
		return false;
	};

	/**
	 * Sanitizes attributes on an HTML tag.
	 *
	 * @private
	 * @param {string}
	 *            tagName An HTML tag name in lowercase.
	 * @param {Array.
	 *            <?string>} attribs An array of alternating names and values.
	 * @return {Array.<?string>} The sanitized attributes as a list of
	 *         alternating names and values, where a null value means to omit
	 *         the attribute.
	 */
	var fnSanitizeAttribs = function(tagName, attribs) {
		for ( var i = 0; i < attribs.length; i += 2) {
			// attribs[i] is the name of the tag's attribute.
			// attribs[i+1] is its corresponding value.
			// (i.e. <span class="foo"> -> attribs[i] = "class" | attribs[i+1] =
			// "foo")

			var sAttribKey = tagName + "::" + attribs[i];

			if (this._ftv.ATTRIBS[sAttribKey]) {
				// keep the value of this class
				if (tagName === "embed") {
					var intPattern = /^[0-9]*$/;
					if (!attribs[i + 1].match(intPattern)) {
						// attribs[i + 1] = null;
						return null;
					}
				}
			} else {
				var sWarning = '<' + tagName + '> with attribute [' + attribs[i] + '="' + attribs[i + 1] + '"] is not allowed and cut';
				jQuery.sap.log.warning(sWarning, this);

				// to remove this attribute by the sanitizer the value has to be
				// set to null
				attribs[i + 1] = null;
			}

		}
		return attribs;
	};

	/**
	 * Sanitizes HTML tags and attributes according to a given policy.
	 *
	 * @private
	 * @param {string}
	 *            inputHtml The HTML to sanitize.
	 * @param {function(string,string[])} tagPolicy A function that decides which
	 *            tags to accept and sanitizes their attributes (see
	 *            makeHtmlSanitizer above for details).
	 * @return {string} The sanitized HTML.
	 */
	var fnPolicy = function(tagName, attribs) {
		if (this._ftv.ELEMENTS[tagName]) {
			var proxiedSanatizedAttribs = jQuery.proxy(fnSanitizeAttribs, this);
			return proxiedSanatizedAttribs(tagName, attribs);
		} else {
			var sWarning = '<' + tagName + '> is not allowed and cut (and its content)';
			jQuery.sap.log.warning(sWarning, this);
		}
	};

	sap.ui.commons.FormattedTextView.prototype.setHtmlText = function(sText) {
		var sSanitizedText = "";

		// use a proxy for policy to access the control's private variables
		var fnProxiedPolicy = jQuery.proxy(fnPolicy, this);

		// using the sanitizer that is already set to the encoder
		sSanitizedText = jQuery.sap._sanitizeHTML(sText, {
			tagPolicy : fnProxiedPolicy
		});

		this.setProperty("htmlText", sSanitizedText);
	};

	var fnSetControls = function(aControls, oThis) {
		if (oThis.hasControls()) {
			oThis.removeAllAggregation("controls");
		}

		var bIsArray = jQuery.isArray(aControls);
		if (bIsArray && aControls.length > 0) {
			// iterate through the given array but suppress invalidate
			for ( var i = 0; i < aControls.length; i++) {
				oThis.addAggregation("controls", aControls[i], true);
			}
			oThis.invalidate();
		}
	};

	sap.ui.commons.FormattedTextView.prototype.setContent = function(sHtmlText, aControls) {
		// set the text using existing checks and method
		this.setHtmlText(sHtmlText);

		// validate and set content of controls corresponding to given HTML-text
		// with place holders
		fnSetControls(aControls, this);
	};
}());
}; // end of sap/ui/commons/FormattedTextView.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.HorizontalDivider') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.HorizontalDivider.
jQuery.sap.declare("sap.ui.commons.HorizontalDivider");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new HorizontalDivider.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getType type} : sap.ui.commons.HorizontalDividerType (default: sap.ui.commons.HorizontalDividerType.Area)</li>
 * <li>{@link #getHeight height} : sap.ui.commons.HorizontalDividerHeight (default: sap.ui.commons.HorizontalDividerHeight.Medium)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Divides the screen in visual areas.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.HorizontalDivider
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.HorizontalDivider", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"width" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '100%'},
		"type" : {type : "sap.ui.commons.HorizontalDividerType", group : "Appearance", defaultValue : sap.ui.commons.HorizontalDividerType.Area},
		"height" : {type : "sap.ui.commons.HorizontalDividerHeight", group : "Appearance", defaultValue : sap.ui.commons.HorizontalDividerHeight.Medium}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.HorizontalDivider with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.HorizontalDivider.extend
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible dividers are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.HorizontalDivider#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.HorizontalDivider} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.HorizontalDivider#setVisible
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Defines the width of the divider.
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.HorizontalDivider#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.HorizontalDivider} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.HorizontalDivider#setWidth
 * @function
 */


/**
 * Getter for property <code>type</code>.
 * Defines the type of the divider.
 *
 * Default value is <code>Area</code>
 *
 * @return {sap.ui.commons.HorizontalDividerType} the value of property <code>type</code>
 * @public
 * @name sap.ui.commons.HorizontalDivider#getType
 * @function
 */

/**
 * Setter for property <code>type</code>.
 *
 * Default value is <code>Area</code> 
 *
 * @param {sap.ui.commons.HorizontalDividerType} oType  new value for property <code>type</code>
 * @return {sap.ui.commons.HorizontalDivider} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.HorizontalDivider#setType
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * Defines the height of the divider.
 *
 * Default value is <code>Medium</code>
 *
 * @return {sap.ui.commons.HorizontalDividerHeight} the value of property <code>height</code>
 * @public
 * @name sap.ui.commons.HorizontalDivider#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is <code>Medium</code> 
 *
 * @param {sap.ui.commons.HorizontalDividerHeight} oHeight  new value for property <code>height</code>
 * @return {sap.ui.commons.HorizontalDivider} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.HorizontalDivider#setHeight
 * @function
 */


// Start of sap\ui\commons\HorizontalDivider.js
// No Behaviour
}; // end of sap/ui/commons/HorizontalDivider.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Image') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Image.
jQuery.sap.declare("sap.ui.commons.Image");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Image.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getSrc src} : sap.ui.core.URI</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize</li>
 * <li>{@link #getDecorative decorative} : boolean (default: true)</li>
 * <li>{@link #getAlt alt} : string</li>
 * <li>{@link #getUseMap useMap} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.Image#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A wrapper around the IMG tag. The image can be loaded from a remote or local server.
 * There are various size setting options available, and the images can be combined with actions.
 * @extends sap.ui.core.Control
 * @implements sap.ui.commons.ToolbarItem,sap.ui.commons.FormattedTextViewControl
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Image
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Image", { metadata : {

	interfaces : [
		"sap.ui.commons.ToolbarItem",
		"sap.ui.commons.FormattedTextViewControl"
	],
	library : "sap.ui.commons",
	properties : {
		"src" : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"width" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
		"height" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
		"decorative" : {type : "boolean", group : "Accessibility", defaultValue : true},
		"alt" : {type : "string", group : "Accessibility", defaultValue : null},
		"useMap" : {type : "string", group : "Misc", defaultValue : null}
	},
	events : {
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Image with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Image.extend
 * @function
 */

sap.ui.commons.Image.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>src</code>.
 * Relative or absolute path to URL where the image file is stored.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>src</code>
 * @public
 * @name sap.ui.commons.Image#getSrc
 * @function
 */

/**
 * Setter for property <code>src</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sSrc  new value for property <code>src</code>
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#setSrc
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible images are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.Image#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#setVisible
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the overall size is maintained then, considering the aspect ratio.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.Image#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#setWidth
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the overall size is maintained then, considering the aspect ratio.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.ui.commons.Image#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#setHeight
 * @function
 */


/**
 * Getter for property <code>decorative</code>.
 * A decorative image is included for design reasons. Accessibility tools will ignore decorative images.
 * Note: If the Image has an image map (useMap is set), this property will be overridden (the image will not be rendered as decorative).
 * A decorative image has no ALT attribute, so the Alt property is ignored if the image is decorative.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>decorative</code>
 * @public
 * @name sap.ui.commons.Image#getDecorative
 * @function
 */

/**
 * Setter for property <code>decorative</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bDecorative  new value for property <code>decorative</code>
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#setDecorative
 * @function
 */


/**
 * Getter for property <code>alt</code>.
 * The alternative text that is displayed in case the Image is not available, or cannot be displayed.
 * If the image is set to decorative this property is ignored.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>alt</code>
 * @public
 * @name sap.ui.commons.Image#getAlt
 * @function
 */

/**
 * Setter for property <code>alt</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAlt  new value for property <code>alt</code>
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#setAlt
 * @function
 */


/**
 * Getter for property <code>useMap</code>.
 * The name of the image map that defines the clickable areas
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>useMap</code>
 * @public
 * @name sap.ui.commons.Image#getUseMap
 * @function
 */

/**
 * Setter for property <code>useMap</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sUseMap  new value for property <code>useMap</code>
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#setUseMap
 * @function
 */


/**
 * Event is fired when the user clicks on the control.
 *
 * @name sap.ui.commons.Image#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.commons.Image</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Image</code>.<br/> itself. 
 *  
 * Event is fired when the user clicks on the control.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Image</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.commons.Image</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Image#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.Image} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.Image#firePress
 * @function
 */


// Start of sap\ui\commons\Image.js
/**
 * Function is called when image is clicked.
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Image.prototype.onclick = function(oEvent) {
	this.firePress({/* no parameters */});
};

/**
 * Function is called when "enter" keydown happens on image.
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Image.prototype.onsapenter = sap.ui.commons.Image.prototype.onclick;

}; // end of sap/ui/commons/Image.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ImageMap') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.ImageMap.
jQuery.sap.declare("sap.ui.commons.ImageMap");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ImageMap.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getName name} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getAreas areas} : sap.ui.commons.Area[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.ImageMap#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Combination of image areas where at runtime these areas are starting points for hyperlinks or actions
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.ImageMap
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.ImageMap", { metadata : {

	publicMethods : [
		// methods
		"createArea"
	],
	library : "sap.ui.commons",
	properties : {
		"name" : {type : "string", group : "Misc", defaultValue : null}
	},
	aggregations : {
		"areas" : {type : "sap.ui.commons.Area", multiple : true, singularName : "area"}
	},
	events : {
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.ImageMap with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.ImageMap.extend
 * @function
 */

sap.ui.commons.ImageMap.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>name</code>.
 * Name for the image that serves as reference
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>name</code>
 * @public
 * @name sap.ui.commons.ImageMap#getName
 * @function
 */

/**
 * Setter for property <code>name</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sName  new value for property <code>name</code>
 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ImageMap#setName
 * @function
 */


/**
 * Getter for aggregation <code>areas</code>.<br/>
 * Area representing the reference to the target location
 * 
 * @return {sap.ui.commons.Area[]}
 * @public
 * @name sap.ui.commons.ImageMap#getAreas
 * @function
 */


/**
 * Inserts a area into the aggregation named <code>areas</code>.
 *
 * @param {sap.ui.commons.Area}
 *          oArea the area to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the area should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the area is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the area is inserted at 
 *             the last position        
 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ImageMap#insertArea
 * @function
 */

/**
 * Adds some area <code>oArea</code> 
 * to the aggregation named <code>areas</code>.
 *
 * @param {sap.ui.commons.Area}
 *            oArea the area to add; if empty, nothing is inserted
 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ImageMap#addArea
 * @function
 */

/**
 * Removes an area from the aggregation named <code>areas</code>.
 *
 * @param {int | string | sap.ui.commons.Area} vArea the area to remove or its index or id
 * @return {sap.ui.commons.Area} the removed area or null
 * @public
 * @name sap.ui.commons.ImageMap#removeArea
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>areas</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.commons.Area[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.ImageMap#removeAllAreas
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.commons.Area</code> in the aggregation named <code>areas</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.commons.Area}
 *            oArea the area whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.ImageMap#indexOfArea
 * @function
 */
	

/**
 * Destroys all the areas in the aggregation 
 * named <code>areas</code>.
 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ImageMap#destroyAreas
 * @function
 */


/**
 * Event for the areas that can be clicked in an ImageMap
 *
 * @name sap.ui.commons.ImageMap#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.areaId Id of clicked Area.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.commons.ImageMap</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.ImageMap</code>.<br/> itself. 
 *  
 * Event for the areas that can be clicked in an ImageMap
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.ImageMap</code>.<br/> itself.
 *
 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ImageMap#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.commons.ImageMap</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ImageMap#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'areaId' of type <code>string</code> Id of clicked Area.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.ImageMap#firePress
 * @function
 */


/**
 * Adds an area to the ImageMap
 *
 * @name sap.ui.commons.ImageMap#createArea
 * @function
 * @param {string[]} aArea
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\ImageMap.js
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained


/**
 * Adds areas to the Image Map. Each argument must be either a JSon object or a
 * list of objects or the area element or elements.
 *
 * @param {sap.ui.commons.Area|string} Area to add
 * @return {sap.ui.commons.Area} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.ImageMap.prototype.createArea = function() {
	var oArea = new sap.ui.commons.Area();

	for ( var i = 0; i < arguments.length; i++) {
		var oContent = arguments[i];
		var oArea;
		if (oContent instanceof sap.ui.commons.Area) {
			oArea = oContent;
		} else {
			oArea = new sap.ui.commons.Area(oContent);
		}
		this.addArea(oArea);
	}
	return this;
};

/**
 * Used for after-rendering initialization.
 *
 * @private
 */
sap.ui.commons.ImageMap.prototype.onAfterRendering = function() {

	this.oDomRef = this.getDomRef();

	// Initialize the ItemNavigation if does not exist yet
	if (!this.oItemNavigation) {
		this.oItemNavigation = new sap.ui.core.delegate.ItemNavigation();
	}

	if (!!sap.ui.Device.browser.internet_explorer) {

		var that = this;
		var aImageControls = [];
		this.oItemNavigation.setTabIndex0();

		// Find the Image control and add delegate to it
		var $Images = jQuery("img[useMap=#" + this.getName() + "]");
		$Images.each(function(i, image) {
			var id = image.getAttribute("id");
			var imageControl = sap.ui.getCore().byId(id);
			imageControl.addDelegate(that.oItemNavigation);
			that.oItemNavigation.setRootDomRef(image);
			aImageControls.push(imageControl);
		});

		this.aImageControls = aImageControls;
	} else {

		this.addDelegate(this.oItemNavigation);
		this.oItemNavigation.setRootDomRef(this.oDomRef);
	}

	// Set navigations items = Areas inside of Image map
	var aItemDomRefs = [];
	var aAllAreas = this.getAreas();
	for ( var i = 0; i < aAllAreas.length; i++) {
		var oDomRef = aAllAreas[i].getFocusDomRef();
		if (oDomRef) { // separators return null here
			aItemDomRefs.push(oDomRef);
		}
	}

	this.oItemNavigation.setItemDomRefs(aItemDomRefs);
	this.oItemNavigation.setCycling(true);
	this.oItemNavigation.setSelectedIndex(-1);
	this.oItemNavigation.setFocusedIndex(-1);

};

/**
 * Does all the cleanup when the Image Map is to be destroyed. Called from the
 * element's destroy() method.
 *
 * @private
 */
sap.ui.commons.ImageMap.prototype.exit = function() {
	// Remove the item navigation delegate
	if (this.oItemNavigation) {
		if (!!sap.ui.Device.browser.internet_explorer) {
			for ( var i = 0; i < this.aImageControls.length; i++) {
				this.aImageControls[i].removeDelegate(this.oItemNavigation);
			}
		} else {
			this.removeDelegate(this.oItemNavigation);
		}
		this.oItemNavigation.destroy();
		delete this.oItemNavigation;
	}

	// No super.exit() to call
};
}; // end of sap/ui/commons/ImageMap.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Label') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Label.
jQuery.sap.declare("sap.ui.commons.Label");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Label.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getDesign design} : sap.ui.commons.LabelDesign (default: sap.ui.commons.LabelDesign.Standard)</li>
 * <li>{@link #getTextDirection textDirection} : sap.ui.core.TextDirection (default: sap.ui.core.TextDirection.Inherit)</li>
 * <li>{@link #getWrapping wrapping} : boolean (default: false)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '')</li>
 * <li>{@link #getText text} : string (default: '')</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getTextAlign textAlign} : sap.ui.core.TextAlign (default: sap.ui.core.TextAlign.Begin)</li>
 * <li>{@link #getRequired required} : boolean (default: false)</li>
 * <li>{@link #getRequiredAtBegin requiredAtBegin} : boolean</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getLabelFor labelFor} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * 
 * Is used for labeling other controls. The API provides formatting options, for example for bold display or alignment. A label can have an icon.
 * @extends sap.ui.core.Control
 * @implements sap.ui.commons.ToolbarItem,sap.ui.core.Label
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Label
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Label", { metadata : {

	interfaces : [
		"sap.ui.commons.ToolbarItem",
		"sap.ui.core.Label"
	],
	library : "sap.ui.commons",
	properties : {
		"design" : {type : "sap.ui.commons.LabelDesign", group : "Appearance", defaultValue : sap.ui.commons.LabelDesign.Standard},
		"textDirection" : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
		"wrapping" : {type : "boolean", group : "Appearance", defaultValue : false},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
		"text" : {type : "string", group : "Misc", defaultValue : ''},
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"textAlign" : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
		"required" : {type : "boolean", group : "Appearance", defaultValue : false},
		"requiredAtBegin" : {type : "boolean", group : "Misc", defaultValue : null}
	},
	associations : {
		"labelFor" : {type : "sap.ui.core.Control", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Label with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Label.extend
 * @function
 */


/**
 * Getter for property <code>design</code>.
 * 
 * Labels can have bold format.
 *
 * Default value is <code>sap.ui.commons.LabelDesign.Standard</code>
 *
 * @return {sap.ui.commons.LabelDesign} the value of property <code>design</code>
 * @public
 * @name sap.ui.commons.Label#getDesign
 * @function
 */

/**
 * Setter for property <code>design</code>.
 *
 * Default value is <code>sap.ui.commons.LabelDesign.Standard</code> 
 *
 * @param {sap.ui.commons.LabelDesign} oDesign  new value for property <code>design</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setDesign
 * @function
 */


/**
 * Getter for property <code>textDirection</code>.
 * 
 * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction from its parent container.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code>
 *
 * @return {sap.ui.core.TextDirection} the value of property <code>textDirection</code>
 * @public
 * @name sap.ui.commons.Label#getTextDirection
 * @function
 */

/**
 * Setter for property <code>textDirection</code>.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code> 
 *
 * @param {sap.ui.core.TextDirection} oTextDirection  new value for property <code>textDirection</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setTextDirection
 * @function
 */


/**
 * Getter for property <code>wrapping</code>.
 * Specifies whether a line wrapping shall be displayed when the text value is longer than the width
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>wrapping</code>
 * @public
 * @name sap.ui.commons.Label#getWrapping
 * @function
 */

/**
 * Setter for property <code>wrapping</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bWrapping  new value for property <code>wrapping</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setWrapping
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * 
 * Control width as common CSS-size (px or % as unit, for example).
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.Label#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setWidth
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * 
 * Text to be displayed.
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.commons.Label#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setText
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * 
 * Invisible labels are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @since 1.14.0
 * @name sap.ui.commons.Label#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @since 1.14.0
 * @name sap.ui.commons.Label#setVisible
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * Icon to be displayed in the control.
 * This can be an URI to an image or an icon font URI.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.commons.Label#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setIcon
 * @function
 */


/**
 * Getter for property <code>textAlign</code>.
 * 
 * Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
 *
 * Default value is <code>sap.ui.core.TextAlign.Begin</code>
 *
 * @return {sap.ui.core.TextAlign} the value of property <code>textAlign</code>
 * @public
 * @name sap.ui.commons.Label#getTextAlign
 * @function
 */

/**
 * Setter for property <code>textAlign</code>.
 *
 * Default value is <code>sap.ui.core.TextAlign.Begin</code> 
 *
 * @param {sap.ui.core.TextAlign} oTextAlign  new value for property <code>textAlign</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setTextAlign
 * @function
 */


/**
 * Getter for property <code>required</code>.
 * Allows to enforce the required indicator even when the associated control doesn't have a getRequired method (a required property) or when the flag is not set.
 * If the associated control has a required property, the values of both required flags are combined with the OR operator, so a Label can't override a required=true value.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>required</code>
 * @public
 * @since 1.11.0
 * @name sap.ui.commons.Label#getRequired
 * @function
 */

/**
 * Setter for property <code>required</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bRequired  new value for property <code>required</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.0
 * @name sap.ui.commons.Label#setRequired
 * @function
 */


/**
 * Getter for property <code>requiredAtBegin</code>.
 * If set the required indicator is at the begin of the label, if not set at the end.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>requiredAtBegin</code>
 * @public
 * @since 1.14.0
 * @name sap.ui.commons.Label#getRequiredAtBegin
 * @function
 */

/**
 * Setter for property <code>requiredAtBegin</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bRequiredAtBegin  new value for property <code>requiredAtBegin</code>
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @since 1.14.0
 * @name sap.ui.commons.Label#setRequiredAtBegin
 * @function
 */


/**
 * Association to the labeled control.
 * By default the label set the for attribute to the ID of the labeled control. This can be changed implementing function getIdForLabel on the labelled control.
 *
 * @return {string} Id of the element which is the current target of the <code>labelFor</code> association, or null
 * @public
 * @name sap.ui.commons.Label#getLabelFor
 * @function
 */

/**
 * Association to the labeled control.
 * By default the label set the for attribute to the ID of the labeled control. This can be changed implementing function getIdForLabel on the labelled control.
 *
 * @param {string | sap.ui.core.Control} vLabelFor 
 *    Id of an element which becomes the new target of this <code>labelFor</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.ui.commons.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Label#setLabelFor
 * @function
 */


	
// Start of sap\ui\commons\Label.js
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained


sap.ui.commons.Label.prototype.onAfterRendering = function () {

	var sFor = this.getLabelForRendering();

	if (sFor) {
		var oFor = sap.ui.getCore().byId(sFor);

		if (oFor) {
			if (this.getTooltip_AsString() == "" || !(this.getTooltip() instanceof sap.ui.core.TooltipBase)) {
				// no own tooltip use RichTooltip of labeled control if available
				if (oFor.getTooltip() instanceof sap.ui.core.TooltipBase) {
					this.oForTooltip = oFor.getTooltip();
					this.addDelegate(this.oForTooltip);
				}
			}

			// attach to change of required flag of labeled control
			oFor.attachEvent("requiredChanged",this._handleRequiredChanged, this);
			this._oFor = oFor;
		}
	}

};

sap.ui.commons.Label.prototype.onBeforeRendering = function () {

	if (this.oForTooltip) {
		this.removeDelegate(this.oForTooltip);
		this.oForTooltip = null;
	}

	if (this._oPopup) {
		this._oPopup.destroy();
		delete this._oPopup;
	}

	if (this._oFor) {
		this._oFor.detachEvent("requiredChanged",this._handleRequiredChanged, this);
		this._oFor = undefined;
	}

};

sap.ui.commons.Label.prototype.exit = function(){

	if (this.oForTooltip) {
		this.removeDelegate(this.oForTooltip);
		this.oForTooltip = null;
	}

	if (this._oPopup) {
		this._oPopup.destroy();
		delete this._oPopup;
	}

	if (this._oFor) {
		this._oFor.detachEvent("requiredChanged",this._handleRequiredChanged, this);
		this._oFor = undefined;
	}

};

/**
 * Checks whether either the label itself or the associated control is marked as required.
 */
sap.ui.commons.Label.prototype.isRequired = function(){

	// the value of the local required flag is ORed with the result of a "getRequired" 
	// method of the associated "labelFor" control. If the associated control doesn't 
	// have a getRequired method, this is treated like a return value of "false".
	var oFor = sap.ui.getCore().byId(this.getLabelForRendering());
	return this.getRequired() || (oFor && oFor.getRequired && oFor.getRequired() === true);

};

/*
 * if required flag of labeled control changes after Label is rendered,
 * Label must be rendered again
 */
sap.ui.commons.Label.prototype._handleRequiredChanged = function(){

	this.invalidate();

};

/*
 * As own function to make possible to overwrite it (e.G. from Form).
 */
sap.ui.commons.Label.prototype.getLabelForRendering = function(){

	return this.getLabelFor();

};


/**
 * @deprecated
 */
sap.ui.commons.Label.prototype.setReqiuredAtBegin = function(bReqiuredAtBegin){
	return this.setRequiredAtBegin(bReqiuredAtBegin);
};

/**
 * @deprecated
 */
sap.ui.commons.Label.prototype.getReqiuredAtBegin = function(){
	return this.getRequiredAtBegin();
};
/*
sap.ui.commons.Label.prototype.onmouseover = function(oEvent) {
	var oRef = this.getDomRef();
	if (Math.abs(oRef.clientWidth - oRef.scrollWidth) < 2){
		return;
	}

	if (!this._oPopup) {
		 this._oPopup = new sap.ui.core.Popup();
		 this._oPopup.setDurations(0, 0); // no animations
		 this._oPopup.setContent(this._createInfo());
		 this._oPopup.attachOpened(this._handleOpened, this);
	}

	var eDock = sap.ui.core.Popup.Dock;
	this._oPopup.open(0, eDock.BeginTop, eDock.BeginTop, this, "0 1", "fit", true);
};

sap.ui.commons.Label.prototype._createInfo = function(){
	var $Me   = jQuery(this.getDomRef());
	var sText = $Me.html();
	var sHtml = "<span id='" + this.getId()+'-info' + "' class='sapUiLblInfo " + $Me.attr("class") + "'>" + sText + "</span>";

	var oDomRef = jQuery(sHtml).appendTo(sap.ui.getCore().getStaticAreaRef());
	var that = this;
	jQuery(oDomRef).mouseout([this.getId()], function(oEvent){
		that._oPopup.close();
	});
	return oDomRef;
};

sap.ui.commons.Label.prototype._handleOpened = function(){
	var that = this;
	jQuery.sap.byId(this.getId()+'-info').mouseout([this.getId()], function(oEvent){
		that._oPopup.close();
	});
};*/
}; // end of sap/ui/commons/Label.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Link') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Link.
jQuery.sap.declare("sap.ui.commons.Link");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Link.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string (default: '')</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getHelpId helpId} : string (default: '')</li>
 * <li>{@link #getHref href} : sap.ui.core.URI</li>
 * <li>{@link #getTarget target} : string</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getAriaDescribedBy ariaDescribedBy} : string | sap.ui.core.Control</li>
 * <li>{@link #getAriaLabelledBy ariaLabelledBy} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.Link#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * 
 * Provides an absolute or relative reference to an internal or external URL. The classical target parameters are supported.
 * Another usage scenario is triggering an action, for example to open a popup window. In both cases, the link is a hypertext link.
 * @extends sap.ui.core.Control
 * @implements sap.ui.commons.ToolbarItem,sap.ui.commons.FormattedTextViewControl
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Link
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Link", { metadata : {

	interfaces : [
		"sap.ui.commons.ToolbarItem",
		"sap.ui.commons.FormattedTextViewControl"
	],
	publicMethods : [
		// methods
		"focus"
	],
	library : "sap.ui.commons",
	properties : {
		"text" : {type : "string", group : "Appearance", defaultValue : ''},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "", defaultValue : true},
		"helpId" : {type : "string", group : "Behavior", defaultValue : ''},
		"href" : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
		"target" : {type : "string", group : "Data", defaultValue : null},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null}
	},
	associations : {
		"ariaDescribedBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
		"ariaLabelledBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
	},
	events : {
		"press" : {allowPreventDefault : true}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Link with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Link.extend
 * @function
 */

sap.ui.commons.Link.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>text</code>.
 * 
 * Link text to be displayed.
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.commons.Link#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#setText
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Whether the link can be triggered by the user.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.Link#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * 
 * Invisible links are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.Link#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#setVisible
 * @function
 */


/**
 * Getter for property <code>helpId</code>.
 * 
 * Unique identifier used for help service.
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>helpId</code>
 * @public
 * @name sap.ui.commons.Link#getHelpId
 * @function
 */

/**
 * Setter for property <code>helpId</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sHelpId  new value for property <code>helpId</code>
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#setHelpId
 * @function
 */


/**
 * Getter for property <code>href</code>.
 * The link target URI. Supports standard hyperlink behavior. If an action should be triggered, this should not be set, but instead an event handler for the "press" event should be registered.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>href</code>
 * @public
 * @name sap.ui.commons.Link#getHref
 * @function
 */

/**
 * Setter for property <code>href</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sHref  new value for property <code>href</code>
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#setHref
 * @function
 */


/**
 * Getter for property <code>target</code>.
 * 
 * Options are _self, _top, _blank, _parent, _search. Alternatively, a frame name can be entered.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>target</code>
 * @public
 * @name sap.ui.commons.Link#getTarget
 * @function
 */

/**
 * Setter for property <code>target</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTarget  new value for property <code>target</code>
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#setTarget
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Width of text link. When it is set (CSS-size such as % or px), this is the exact size. When left blank, the text defines the size.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @since 1.8.0
 * @name sap.ui.commons.Link#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @since 1.8.0
 * @name sap.ui.commons.Link#setWidth
 * @function
 */


/**
 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.Link#getAriaDescribedBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaDescribedBy
 *    Id of a ariaDescribedBy which becomes an additional target of this <code>ariaDescribedBy</code> association.
 *    Alternatively, a ariaDescribedBy instance may be given. 
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#addAriaDescribedBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaDescribedBy the ariaDescribedBy to remove or its index or id
 * @return {string} the id of the removed ariaDescribedBy or null
 * @public
 * @name sap.ui.commons.Link#removeAriaDescribedBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Link#removeAllAriaDescribedBy
 * @function
 */

	
/**
 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.Link#getAriaLabelledBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaLabelledBy
 *    Id of a ariaLabelledBy which becomes an additional target of this <code>ariaLabelledBy</code> association.
 *    Alternatively, a ariaLabelledBy instance may be given. 
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#addAriaLabelledBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaLabelledBy the ariaLabelledBy to remove or its index or id
 * @return {string} the id of the removed ariaLabelledBy or null
 * @public
 * @name sap.ui.commons.Link#removeAriaLabelledBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Link#removeAllAriaLabelledBy
 * @function
 */

	
/**
 * 
 * Event is fired when the user clicks the control.
 *
 * @name sap.ui.commons.Link#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.commons.Link</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Link</code>.<br/> itself. 
 *  
 * 
 * Event is fired when the user clicks the control.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Link</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.commons.Link</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Link#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.commons.Link#firePress
 * @function
 */


/**
 * Puts the focus to the link.
 *
 * @name sap.ui.commons.Link#focus
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\Link.js
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained


sap.ui.core.EnabledPropagator.call(sap.ui.commons.Link.prototype);

/**
 * Also trigger link activation when space is pressed on the focused control
 */
sap.ui.commons.Link.prototype.onsapspace = function(oEvent) {
	sap.ui.commons.Link.prototype.onclick.apply(this, arguments);
};

/**
 * Function is called when Link is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Link.prototype.onclick = function(oEvent) {
	if (this.getEnabled()) {
		// the default behavior will be supressed, when oEvent.preventDefault() is 
		// called or when the link doesn't contain a valid href (javascript:void(0)).
		// The last thing will trigger the onbeforeunload event in IE when not 
		// preventing the default behavior
		if (!this.firePress() || !this.getHref()) {
			oEvent.preventDefault();
		}
	} else {
		oEvent.preventDefault();
	}
};

/**
 * The Link handles the enter by itself
 * @since 1.16.2
 */
sap.ui.commons.Link.prototype.onsapenter = function(oEvent) {
	oEvent.stopPropagation();
};
}; // end of sap/ui/commons/Link.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ListBox') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.ListBox.
jQuery.sap.declare("sap.ui.commons.ListBox");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ListBox.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getEditable editable} : boolean (default: true)</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getAllowMultiSelect allowMultiSelect} : boolean (default: false)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize</li>
 * <li>{@link #getScrollTop scrollTop} : int (default: -1)</li>
 * <li>{@link #getDisplayIcons displayIcons} : boolean (default: false)</li>
 * <li>{@link #getDisplaySecondaryValues displaySecondaryValues} : boolean (default: false)</li>
 * <li>{@link #getValueTextAlign valueTextAlign} : sap.ui.core.TextAlign (default: sap.ui.core.TextAlign.Begin)</li>
 * <li>{@link #getSecondaryValueTextAlign secondaryValueTextAlign} : sap.ui.core.TextAlign (default: sap.ui.core.TextAlign.Begin)</li>
 * <li>{@link #getMinWidth minWidth} : sap.ui.core.CSSSize</li>
 * <li>{@link #getMaxWidth maxWidth} : sap.ui.core.CSSSize</li>
 * <li>{@link #getVisibleItems visibleItems} : int</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getItems items} <strong>(default aggregation)</strong> : sap.ui.core.Item[]</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getAriaDescribedBy ariaDescribedBy} : string | sap.ui.core.Control</li>
 * <li>{@link #getAriaLabelledBy ariaLabelledBy} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.ListBox#event:select select} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Provides a list of items from which users can choose an item. For the design of the list box, features such as defining the list box height,
 * fixing the number of visible items, choosing one item to be the item that is marked by default when the list box is shown, or a scroll bar for large list boxes
 * are available.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.ListBox
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.ListBox", { metadata : {

	publicMethods : [
		// methods
		"getSelectedIndex", "setSelectedIndex", "addSelectedIndex", "removeSelectedIndex", "getSelectedIndices", "setSelectedIndices", "addSelectedIndices", "isIndexSelected", "getSelectedItem", "getSelectedItems", "clearSelection", "scrollToIndex", "setItems", "setSelectedKeys", "getSelectedKeys"
	],
	library : "sap.ui.commons",
	properties : {
		"editable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"allowMultiSelect" : {type : "boolean", group : "Behavior", defaultValue : false},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"height" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"scrollTop" : {type : "int", group : "Behavior", defaultValue : -1},
		"displayIcons" : {type : "boolean", group : "Behavior", defaultValue : false},
		"displaySecondaryValues" : {type : "boolean", group : "Misc", defaultValue : false},
		"valueTextAlign" : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
		"secondaryValueTextAlign" : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
		"minWidth" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"maxWidth" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"visibleItems" : {type : "int", group : "Dimension", defaultValue : null}
	},
	defaultAggregation : "items",
	aggregations : {
		"items" : {type : "sap.ui.core.Item", multiple : true, singularName : "item"}
	},
	associations : {
		"ariaDescribedBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
		"ariaLabelledBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
	},
	events : {
		"select" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.ListBox with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.ListBox.extend
 * @function
 */

sap.ui.commons.ListBox.M_EVENTS = {'select':'select'};


/**
 * Getter for property <code>editable</code>.
 * Value "true" makes the list box interactive.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @name sap.ui.commons.ListBox#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setEditable
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Disabled controls have another color display depending on custom settings.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.ListBox#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setEnabled
 * @function
 */


/**
 * Getter for property <code>allowMultiSelect</code>.
 * Specifies whether multiple selection is allowed.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>allowMultiSelect</code>
 * @public
 * @name sap.ui.commons.ListBox#getAllowMultiSelect
 * @function
 */

/**
 * Setter for property <code>allowMultiSelect</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bAllowMultiSelect  new value for property <code>allowMultiSelect</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setAllowMultiSelect
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.ListBox#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setVisible
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Control width as common CSS-size (px or % as unit, for example).
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.ListBox#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setWidth
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * Control height as common CSS-size (px or % as unit, for example).
 * The setting overrides any definitions made for the setVisibleItems() method.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.ui.commons.ListBox#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setHeight
 * @function
 */


/**
 * Getter for property <code>scrollTop</code>.
 * Scroll bar position from the top. Setting the scrollTop property and calling scrollToIndex are two operations influencing the same "physical" property, so the last call "wins".
 *
 * Default value is <code>-1</code>
 *
 * @return {int} the value of property <code>scrollTop</code>
 * @public
 * @name sap.ui.commons.ListBox#getScrollTop
 * @function
 */

/**
 * Setter for property <code>scrollTop</code>.
 *
 * Default value is <code>-1</code> 
 *
 * @param {int} iScrollTop  new value for property <code>scrollTop</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setScrollTop
 * @function
 */


/**
 * Getter for property <code>displayIcons</code>.
 * Defines whether the icons of the list items shall also be displayed. Enabling icons requires some space to be reserved for them. Displaying icons can also
 * influence the width and height of a single item, which affects the overall height of the ListBox when defined in number of items.
 * Note that the number of icons that can be displayed in the ListBox depends on the size of the icons themselves and of the total ListBox height.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>displayIcons</code>
 * @public
 * @name sap.ui.commons.ListBox#getDisplayIcons
 * @function
 */

/**
 * Setter for property <code>displayIcons</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bDisplayIcons  new value for property <code>displayIcons</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setDisplayIcons
 * @function
 */


/**
 * Getter for property <code>displaySecondaryValues</code>.
 * Specifies whether the text values from the additionalText property (see sap.ui.core.ListItems) shall be displayed.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>displaySecondaryValues</code>
 * @public
 * @name sap.ui.commons.ListBox#getDisplaySecondaryValues
 * @function
 */

/**
 * Setter for property <code>displaySecondaryValues</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bDisplaySecondaryValues  new value for property <code>displaySecondaryValues</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setDisplaySecondaryValues
 * @function
 */


/**
 * Getter for property <code>valueTextAlign</code>.
 * The text alignment in the primary ListBox column.
 *
 * Default value is <code>Begin</code>
 *
 * @return {sap.ui.core.TextAlign} the value of property <code>valueTextAlign</code>
 * @public
 * @name sap.ui.commons.ListBox#getValueTextAlign
 * @function
 */

/**
 * Setter for property <code>valueTextAlign</code>.
 *
 * Default value is <code>Begin</code> 
 *
 * @param {sap.ui.core.TextAlign} oValueTextAlign  new value for property <code>valueTextAlign</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setValueTextAlign
 * @function
 */


/**
 * Getter for property <code>secondaryValueTextAlign</code>.
 * The text alignment in the secondary ListBox text column (if available).
 *
 * Default value is <code>Begin</code>
 *
 * @return {sap.ui.core.TextAlign} the value of property <code>secondaryValueTextAlign</code>
 * @public
 * @name sap.ui.commons.ListBox#getSecondaryValueTextAlign
 * @function
 */

/**
 * Setter for property <code>secondaryValueTextAlign</code>.
 *
 * Default value is <code>Begin</code> 
 *
 * @param {sap.ui.core.TextAlign} oSecondaryValueTextAlign  new value for property <code>secondaryValueTextAlign</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setSecondaryValueTextAlign
 * @function
 */


/**
 * Getter for property <code>minWidth</code>.
 * The minimum width of the ListBox. If not set, there is no minimum width.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>minWidth</code>
 * @public
 * @name sap.ui.commons.ListBox#getMinWidth
 * @function
 */

/**
 * Setter for property <code>minWidth</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sMinWidth  new value for property <code>minWidth</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setMinWidth
 * @function
 */


/**
 * Getter for property <code>maxWidth</code>.
 * The maximum width of the ListBox. If not set, there is no maximum width.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>maxWidth</code>
 * @public
 * @name sap.ui.commons.ListBox#getMaxWidth
 * @function
 */

/**
 * Setter for property <code>maxWidth</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sMaxWidth  new value for property <code>maxWidth</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setMaxWidth
 * @function
 */


/**
 * Getter for property <code>visibleItems</code>.
 * The ListBox height in number of items that are initially displayed without scrolling. This setting overwrites height
 * settings in terms of CSS size that have been made. When the items have different heights, the height of the first item is used for all
 * other item height calculations. Note that if there are one or more separators between the visible ListBox items, the displayed items
 * might not relate 1:1 to the initially specified number of items. When the value is retrieved, it equals the previously set value if it was set;
 * otherwise, it will be the number of items completely fitting into the ListBox without scrolling in the case the control was already rendered.
 * Note that if the control was not rendered, the behavior will be undefined, it may return -1 or any other number.
 *
 * Default value is <code></code>
 *
 * @return {int} the value of property <code>visibleItems</code>
 * @public
 * @name sap.ui.commons.ListBox#getVisibleItems
 * @function
 */

/**
 * Setter for property <code>visibleItems</code>.
 *
 * Default value is <code></code> 
 *
 * @param {int} iVisibleItems  new value for property <code>visibleItems</code>
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#setVisibleItems
 * @function
 */


/**
 * Getter for aggregation <code>items</code>.<br/>
 * Aggregation of items to be displayed. Must be either of type sap.ui.core.ListItem or sap.ui.core.SeparatorItem.
 * 
 * <strong>Note</strong>: this is the default aggregation for ListBox.
 * @return {sap.ui.core.Item[]}
 * @public
 * @name sap.ui.commons.ListBox#getItems
 * @function
 */


/**
 * Inserts a item into the aggregation named <code>items</code>.
 *
 * @param {sap.ui.core.Item}
 *          oItem the item to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the item should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the item is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the item is inserted at 
 *             the last position        
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#insertItem
 * @function
 */

/**
 * Adds some item <code>oItem</code> 
 * to the aggregation named <code>items</code>.
 *
 * @param {sap.ui.core.Item}
 *            oItem the item to add; if empty, nothing is inserted
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#addItem
 * @function
 */

/**
 * Removes an item from the aggregation named <code>items</code>.
 *
 * @param {int | string | sap.ui.core.Item} vItem the item to remove or its index or id
 * @return {sap.ui.core.Item} the removed item or null
 * @public
 * @name sap.ui.commons.ListBox#removeItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>items</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Item[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.ListBox#removeAllItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Item</code> in the aggregation named <code>items</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Item}
 *            oItem the item whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.ListBox#indexOfItem
 * @function
 */
	

/**
 * Destroys all the items in the aggregation 
 * named <code>items</code>.
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#destroyItems
 * @function
 */


/**
 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.ListBox#getAriaDescribedBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaDescribedBy
 *    Id of a ariaDescribedBy which becomes an additional target of this <code>ariaDescribedBy</code> association.
 *    Alternatively, a ariaDescribedBy instance may be given. 
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#addAriaDescribedBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaDescribedBy the ariaDescribedBy to remove or its index or id
 * @return {string} the id of the removed ariaDescribedBy or null
 * @public
 * @name sap.ui.commons.ListBox#removeAriaDescribedBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.ListBox#removeAllAriaDescribedBy
 * @function
 */

	
/**
 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.ListBox#getAriaLabelledBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaLabelledBy
 *    Id of a ariaLabelledBy which becomes an additional target of this <code>ariaLabelledBy</code> association.
 *    Alternatively, a ariaLabelledBy instance may be given. 
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#addAriaLabelledBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaLabelledBy the ariaLabelledBy to remove or its index or id
 * @return {string} the id of the removed ariaLabelledBy or null
 * @public
 * @name sap.ui.commons.ListBox#removeAriaLabelledBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.ListBox#removeAllAriaLabelledBy
 * @function
 */

	
/**
 * Event is fired when selection is changed by user interaction.
 *
 * @name sap.ui.commons.ListBox#select
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.id ID of the ListBox which triggered the event.
 * @param {int} oControlEvent.getParameters.selectedIndex The currently selected index of the ListBox. In the case of multiple selection, this is exactly one of the selected indices - the one whose selection has triggered the selection change; to get all currently selected indices, use selectedIndices.
 * @param {sap.ui.core.Item} oControlEvent.getParameters.selectedItem The currently selected item of the ListBox. In the case of multiple selection, this is exactly one of the selected items - the one whose selection has triggered the selection change.
 * @param {int[]} oControlEvent.getParameters.selectedIndices Array containing the indices which are selected.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'select' event of this <code>sap.ui.commons.ListBox</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.ListBox</code>.<br/> itself. 
 *  
 * Event is fired when selection is changed by user interaction.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.ListBox</code>.<br/> itself.
 *
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#attachSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'select' event of this <code>sap.ui.commons.ListBox</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ListBox#detachSelect
 * @function
 */

/**
 * Fire event select to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'id' of type <code>string</code> ID of the ListBox which triggered the event.</li>
 * <li>'selectedIndex' of type <code>int</code> The currently selected index of the ListBox. In the case of multiple selection, this is exactly one of the selected indices - the one whose selection has triggered the selection change; to get all currently selected indices, use selectedIndices.</li>
 * <li>'selectedItem' of type <code>sap.ui.core.Item</code> The currently selected item of the ListBox. In the case of multiple selection, this is exactly one of the selected items - the one whose selection has triggered the selection change.</li>
 * <li>'selectedIndices' of type <code>int[]</code> Array containing the indices which are selected.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.ListBox#fireSelect
 * @function
 */


/**
 * Zero-based index of selected item. Index value for no selection is -1. When multiple selection is enabled and multiple items are selected, the method returns the first selected item.
 *
 * @name sap.ui.commons.ListBox#getSelectedIndex
 * @function
 * @type int
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Sets the zero-based index of the currently selected item. This method removes any previous selections. When the given index is invalid, the call is ignored.
 *
 * @name sap.ui.commons.ListBox#setSelectedIndex
 * @function
 * @param {int} iIndex
 *         Index to be selected
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Adds the given index to current selection. When multiple selection is disabled, this replaces the current selection. When the given index is invalid, the call is ignored.
 *
 * @name sap.ui.commons.ListBox#addSelectedIndex
 * @function
 * @param {int} iIndex
 *         Index to add to selection.
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Removes the given index from this selection. When the index is invalid or not selected, the call is ignored.
 *
 * @name sap.ui.commons.ListBox#removeSelectedIndex
 * @function
 * @param {int} iIndex
 *         Index that shall be removed from selection.
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
 *
 * @name sap.ui.commons.ListBox#getSelectedIndices
 * @function
 * @type int[]
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
 * When multiple selection is disabled and multiple items are given, the selection is set to the index of the first valid index in the given array.
 * Any invalid indices are ignored.
 * The previous selection is in any case replaced.
 *
 * @name sap.ui.commons.ListBox#setSelectedIndices
 * @function
 * @param {int[]} aIndices
 *         Indices of the items to be selected.
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Adds the given indices to selection. Any invalid indices are ignored.
 *
 * @name sap.ui.commons.ListBox#addSelectedIndices
 * @function
 * @param {int[]} aIndices
 *         Indices of the items that shall additionally be selected.
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns whether the given index is selected.
 *
 * @name sap.ui.commons.ListBox#isIndexSelected
 * @function
 * @param {int} iIndex
 *         Index which is checked for selection state.
 * @type boolean
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns selected item. When no item is selected, "null" is returned. When multi-selection is enabled and multiple items are selected, only the first selected item is returned.
 *
 * @name sap.ui.commons.ListBox#getSelectedItem
 * @function
 * @type sap.ui.core.Item
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns an array containing the selected items. In the case of no selection, an empty array is returned.
 *
 * @name sap.ui.commons.ListBox#getSelectedItems
 * @function
 * @type sap.ui.core.Item[]
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Removes complete selection.
 *
 * @name sap.ui.commons.ListBox#clearSelection
 * @function
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * If the ListBox has a scroll bar because the number of items is larger than the number of visible items, this method scrolls to the item with the given index. If there are enough items, this item will then appear at the topmost visible position in the ListBox. If bLazy is true, it only scrolls as far as required to make the item visible.
 * Setting the scrollTop property and calling scrollToIndex are two operations influencing the same "physical" property, so the last call "wins".
 *
 * @name sap.ui.commons.ListBox#scrollToIndex
 * @function
 * @param {int} iIndex
 *         The index to which the ListBox should scroll.
 * @param {boolean} bLazy
 *         If set to true, the ListBox only scrolls if the item is not completely visible, and it scrolls for exactly the space to make it fully visible. If set to false, the item is scrolled to the top position (if possible).
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Allows setting the list items as array for this instance of ListBox.
 *
 * @name sap.ui.commons.ListBox#setItems
 * @function
 * @param {sap.ui.core.ListItem[]} aItems
 *         The items to set for this ListBox.
 * @param {boolean} bDestroyItems
 *         Optional boolean parameter to indicate that the formerly set items should be destroyed, instead of just removed.
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Keys of the items to be selected, wrapped in an array. An empty array means no selection. When multiple selection is disabled,
 * and multiple keys are given, the selection is set to the item with the first valid key in the given array. Any invalid keys are ignored.
 * The previous selection is replaced in any case.
 *
 * @name sap.ui.commons.ListBox#setSelectedKeys
 * @function
 * @param {string[]} aKeys
 *         The keys of the items to be selected
 * @type sap.ui.commons.ListBox
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns the keys of the selected items in an array. If a selected item does not have a key, the respective array entry will be undefined.
 *
 * @name sap.ui.commons.ListBox#getSelectedKeys
 * @function
 * @type string[]
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\ListBox.js
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained

jQuery.sap.require('jquery.sap.strings'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


/**
 * Initializes the ListBox control
 * @private
 */
sap.ui.commons.ListBox.prototype.init = function () {
	this.allowTextSelection(false);
	if (!this._bHeightInItems) { // otherwise setVisibleItems was already called by the JSON constructor
		this._bHeightInItems = false; // decides whether the height is set as CSS size (height is in height property then) or in multiples of an item height (height is in this._iVisibleItems then)
		this._iVisibleItems = -1;     // initially -1, this subsequently must be the number of items that are visible without scrolling; the value is either set directly if the height is given in items, or calculated in onAfterRendering
	}
	this._sTotalHeight = null;    // if height is set in items, this contains the
	if (sap.ui.commons.ListBox._fItemHeight === undefined) {
		sap.ui.commons.ListBox._fItemHeight = -1;
	}
	if (sap.ui.commons.ListBox._iBordersAndStuff === undefined) {
		sap.ui.commons.ListBox._iBordersAndStuff = -1;
	}

	this._aSelectionMap = [];
	this._iLastDirectlySelectedIndex = -1;

	//FIXME Mapping from activeItems index to the id of it for item navigation purposes
	this._aActiveItems = null;
	
	if(sap.ui.Device.support.touch){
		jQuery.sap.require("sap.ui.core.delegate.ScrollEnablement");
		this._oScroller = new sap.ui.core.delegate.ScrollEnablement(this, this.getId()+"-list", {
			   vertical: true,
			   zynga: true,
			   preventDefault: true
		});
	}
	
};


/**
 * Re-initializes the ListBox, so all sizes are fine after a theme switch
 * @private
 */
sap.ui.commons.ListBox.prototype.onThemeChanged = function () {
	sap.ui.commons.ListBox._fItemHeight = -1;
	sap.ui.commons.ListBox._iBordersAndStuff = -1;
	this._sTotalHeight = null;
	if (!this._bHeightInItems) {
		this._iVisibleItems = -1; // re-calculation only required for ItemNavigation - shouldn't change when explicitly set
	}
	this._skipStoreScrollTop = true; // Skip remembering the scrolltop in next onBeforeRendering due to theme change
	if (this.getDomRef()) {
		this.invalidate();
	}
};


/**
 * Called before rendering. Required for storing the scroll position.
 * @private
 */
sap.ui.commons.ListBox.prototype.onBeforeRendering = function () {
	if(this._skipStoreScrollTop){
		delete this._skipStoreScrollTop;
		return;
	}
	
	this.getScrollTop(); // store current ScrollTop
	// TODO: store focus??
};


/**
 * Called after rendering. Required for calculating and setting the correct heights.
 * @private
 */
sap.ui.commons.ListBox.prototype.onAfterRendering = function () {
	var oDomRef = this.getDomRef();

	// calculate item height
	if (sap.ui.commons.ListBox._fItemHeight <= 0) { // TODO: merge with width measurement which is currently in renderer
		
		// create dummy ListBox with dummy item
		var oStaticArea = sap.ui.getCore().getStaticAreaRef();
		var div = document.createElement("div");
		div.id = "sap-ui-commons-ListBox-sizeDummy";
		oStaticArea.appendChild(div);
		div.innerHTML = '<div class="sapUiLbx sapUiLbxFlexWidth sapUiLbxStd"><ul><li class="sapUiLbxI"><span class="sapUiLbxITxt">&nbsp;</span></li></ul></div>';
		var oItemDomRef = div.firstChild.firstChild.firstChild;
		sap.ui.commons.ListBox._fItemHeight = oItemDomRef.offsetHeight;

		// subpixel rendering strategy in IE >= 9 can lead to the total being larger than the sum of heights
		if (!!sap.ui.Device.browser.internet_explorer && (document.documentMode == 9 || document.documentMode == 10)) { // TODO: browser version check... not good...
			var cs = document.defaultView.getComputedStyle(oItemDomRef.firstChild, "");
			var h = parseFloat(cs.getPropertyValue("height").split("px")[0]);
			if (!(typeof h === "number") || !(h > 0)) { // sometimes cs.getPropertyValue("height") seems to return "auto"
				h = jQuery(oItemDomRef.firstChild).height();
			}
			var pt = parseFloat(cs.getPropertyValue("padding-top").split("px")[0]);
			var pb = parseFloat(cs.getPropertyValue("padding-bottom").split("px")[0]);
			var bt = parseFloat(cs.getPropertyValue("border-top-width").split("px")[0]);
			var bb = parseFloat(cs.getPropertyValue("border-bottom-width").split("px")[0]);
			sap.ui.commons.ListBox._fItemHeight = h + pt + pb + bt + bb;
		}

		// remove the dummy
		oStaticArea.removeChild(div);
	}

	// calculate height of ListBox borders and padding
	if (sap.ui.commons.ListBox._iBordersAndStuff == -1) {
		var $DomRef = jQuery(this.getDomRef());
		var outerHeight = $DomRef.outerHeight();
		var innerHeight = $DomRef.height();
		sap.ui.commons.ListBox._iBordersAndStuff = outerHeight - innerHeight;
	}

	// Height is set in number of visible items
	if (this._bHeightInItems) {
		if(this._sTotalHeight == null) {
			//...but the height needs to be calculated first
			this._calcTotalHeight(); // TODO: verify this._sTotalHeight is > 0

			// now set height
			oDomRef.style.height = this._sTotalHeight;
		} else {
			// height was already set in the renderer!
		}
	}

	// find out how many items are visible because the ItemNavigation needs to know
	if (this._iVisibleItems = -1) {
		this._updatePageSize();
	}

	// Collect items for ItemNavigation   TODO: make it cleaner
	var oFocusRef = this.getFocusDomRef(),
			aRows = oFocusRef.childNodes,
			aDomRefs = [],
			aItems = this.getItems();
	this._aActiveItems = [];
	var aActiveItems = this._aActiveItems;
	for (var i=0; i < aRows.length; i++) {
		if (!(aItems[i] instanceof sap.ui.core.SeparatorItem)) {
			aActiveItems[aDomRefs.length] = i;
			aDomRefs.push(aRows[i]);
		}
	}

	// init ItemNavigation
	if (!this.oItemNavigation) {
		var bNotInTabChain = (!this.getEnabled() || !this.getEditable());
		this.oItemNavigation = new sap.ui.core.delegate.ItemNavigation(null, null, bNotInTabChain);
		this.oItemNavigation.attachEvent(sap.ui.core.delegate.ItemNavigation.Events.AfterFocus, this._handleAfterFocus, this);
		this.addDelegate(this.oItemNavigation);
	}
	this.oItemNavigation.setRootDomRef(oFocusRef);
	this.oItemNavigation.setItemDomRefs(aDomRefs);
	this.oItemNavigation.setCycling(false);
	this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(this.getSelectedIndex()));
	this.oItemNavigation.setPageSize(this._iVisibleItems); // Page down by number of visible items

	// Apply scrollTop


	// if scrolling to a certain item index is currently requested (but was not done because the control was not rendered before), do it now
	if (this.oScrollToIndexRequest) {
		this.scrollToIndex(this.oScrollToIndexRequest.iIndex, this.oScrollToIndexRequest.bLazy); // keep the oScrollToIndexRequest for the timeouted call
	} else {
		var scrollTop = this.getProperty("scrollTop");
		if (scrollTop > -1) {
			oDomRef.scrollTop = scrollTop;
		}
	}

	// sometimes this did not work, so repeat it after a timeout (consciously done twice, yes)
	var that = this;
	window.setTimeout(function() { // needs to be delayed because in Firefox sometimes the scrolling seems to come too early
		// if scrolling to a certain item index is currently requested (but was not done because the control was not rendered before), do it now
		if (that.oScrollToIndexRequest) {
			that.scrollToIndex(that.oScrollToIndexRequest.iIndex, that.oScrollToIndexRequest.bLazy);
			that.oScrollToIndexRequest = null;
		} else {
			var scrollTop = that.getProperty("scrollTop");
			if (scrollTop > -1) {
				oDomRef.scrollTop = scrollTop;
			}
		}
	}, 0);
};


/**
 * For the given iIndex, this method calculates the index of the respective item within the ItemNavigation set.
 * (if there are separators, the ItemNavigation does not know them)
 * Prerequisite: the iIndex points to an element which is NOT a Separator or disabled (= it must be known to the ItemNavigation)
 * @private
 */
sap.ui.commons.ListBox.prototype._getNavigationIndexForRealIndex = function(iIndex) {
	var aItems = this.getItems();
	var iNavIndex = iIndex;
	for (var i = 0; i < iIndex; i++) {
		if (aItems[i] instanceof sap.ui.core.SeparatorItem) {
			iNavIndex--;
		}
	}
	return iNavIndex;
};


/**
 * Calculates the number of visible items. Must happen after rendering and whenever the height is changed without rerendering.
 * @private
 */
sap.ui.commons.ListBox.prototype._updatePageSize = function() {
	var oDomRef = this.getDomRef();
	if (oDomRef) {
		if (sap.ui.commons.ListBox._fItemHeight > 0) {
			this._iVisibleItems = Math.floor(oDomRef.clientHeight / sap.ui.commons.ListBox._fItemHeight);
		} else {
			// TODO: shouldn't happen
		}
	}
	// else: nothing to do, item navigation will be initialized after rendering
};

/*
 * Scrolls the item with the given index into view, preferably at the topmost position.
 */
sap.ui.commons.ListBox.prototype.scrollToIndex = function(iIndex, bLazy) {
	var oDomRef = this.getDomRef();
	if (oDomRef) { // only if already rendered
		var oItem = this.$("list").children("li[data-sap-ui-lbx-index=" + iIndex + "]");
		oItem = oItem.get(0);
		if (oItem) {
			var iScrollTop = oItem.offsetTop;
			if (!bLazy) {
				// scroll there without any conditions
				this.setScrollTop(iScrollTop);
			} else {
				// "lazy" means we should only scroll if required and as far as required
				var iCurrentScrollTop = oDomRef.scrollTop;
				var iViewPortHeight = jQuery(oDomRef).height();
				if (iCurrentScrollTop >= iScrollTop) {
					// if we have to scroll up, the behavior is fine already
					this.setScrollTop(iScrollTop);
				} else if ((iScrollTop + sap.ui.commons.ListBox._fItemHeight) > (iCurrentScrollTop + iViewPortHeight)) { // bottom Edge of item > bottom edge of viewport
					// the item is - at least partly - below the current viewport of the ListBox, so scroll down. But only as far as required
					this.setScrollTop(Math.ceil(iScrollTop + sap.ui.commons.ListBox._fItemHeight - iViewPortHeight)); // round because of _fItemHeight
				} else {
					// if the item is already fully visible, do nothing
				}
			}
		}
		// store the actual position
		this.getScrollTop();
	} else {
		// control not yet rendered, thus item height is unknown, so remember request for after rendering
		this.oScrollToIndexRequest = {iIndex:iIndex,bLazy:bLazy};
	}
	return this;
};

sap.ui.commons.ListBox.prototype.getVisibleItems = function() {
	return this._iVisibleItems;
};

/**
 * Makes the ListBox render with a height that allows it to display exactly the given number of items.
 *
 * @param {int} iItemCount the number of items that should fit into the ListBox without scrolling
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.ListBox.prototype.setVisibleItems = function(iItemCount) {
 /*
	*For the calculation, the size of the first item is used; if no item is present, an invisible dummy item
	* is rendered and instantly removed again.
	* Therefore, this method will not work for items with different heights and if actual items have a different
	* size than generic empty dummy items.
	*/
	// TODO: prevent values less than 1, or make them go back to CSS heights
	this.setProperty("visibleItems", iItemCount, true);

	this._iVisibleItems = iItemCount;
	if (iItemCount < 0) {
		this._bHeightInItems = false;
	} else {
		this._bHeightInItems = true;
	}

	// the actual height to set must be calculated now or later
	this._sTotalHeight = null;

	// if already rendered, calculate and set the height
	var oDomRef = this.getDomRef();
	if (oDomRef) {
		if (this._bHeightInItems) {
			var oFirstItem = oDomRef.firstChild ? oDomRef.firstChild.firstChild : null;
			if (oFirstItem || ((sap.ui.commons.ListBox._fItemHeight > 0) && (sap.ui.commons.ListBox._iBordersAndStuff > 0))) {
				oDomRef.style.height = this._calcTotalHeight();
			} else {
				// already rendered, but no dummy item!
				this.invalidate();
			}
		} else {
			oDomRef.style.height = this.getHeight();
			this._updatePageSize();
			if (this.oItemNavigation) {
				this.oItemNavigation.setPageSize(this._iVisibleItems); // Page down by number of visible items
			}
		}
	}

	if (this._sTotalHeight == null) { // this is the "else" clause covering all cases where the height was not set above
		// called before rendering, so the calculation and setting of the actual CSS height to set must be done later
	}

	return this;
};


/**
 * Calculates the outer height of the ListBox from the known item height and number of items that should fit.
 * The result (a CSS size string) is returned as well as assigned to this._sTotalHeight.
 * Precondition: the control is rendered, this._iVisibleItems, sap.ui.commons.ListBox._iBordersAndStuff and
 * sap.ui.commons.ListBox._fItemHeight are initialized.
 *
 * @returns {string} the required outer height as CSS size
 * @private
 */
sap.ui.commons.ListBox.prototype._calcTotalHeight = function() {
	// TODO: check preconditions
	var desiredHeight = this._iVisibleItems * sap.ui.commons.ListBox._fItemHeight;
	this._sTotalHeight = (desiredHeight + sap.ui.commons.ListBox._iBordersAndStuff) + "px";
	return this._sTotalHeight;
};


/**
 * Sets the height of this ListBox in CSS units

 * @param {string} sHeight
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.ListBox.prototype.setHeight = function(sHeight) {
	this._bHeightInItems = false;
	this._iVisibleItems = -1;

	var oDomRef = this.getDomRef();
	if (oDomRef) {
		oDomRef.style.height = sHeight;
		this._updatePageSize();
		if (this.oItemNavigation) {
			this.oItemNavigation.setPageSize(this._iVisibleItems); // Page down by number of visible items
		}
	}

	this.setProperty("height", sHeight, true); // no re-rendering
	return this;
};

/**
 * Setter for property width.
 *
 * @param {string} sWidth
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.ListBox.prototype.setWidth = function(sWidth) {
	var oDomRef = this.getDomRef();
	if (oDomRef) {
		oDomRef.style.width = sWidth;
	}
	this.setProperty("width", sWidth, true); // no re-rendering
	return this;
};

/**
 * Positions the ListBox contents that are scrolled-down by the given number of pixels
 *
 * @param {int} iScrollTop Vertical scroll position in pixels
 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.ListBox.prototype.setScrollTop = function (iScrollTop) {
	var scrollDomRef = this.getDomRef();
	this.oScrollToIndexRequest = null; // delete any pending scroll request
	if (scrollDomRef) {
		scrollDomRef.scrollTop = iScrollTop;
	}
	this.setProperty("scrollTop", iScrollTop, true); // no rerendering
	return this;
};

/**
 * Returns how many pixels the ListBox contents are currently scrolled down
 *
 * @return {int} Vertical scroll position
 * @public
 */
sap.ui.commons.ListBox.prototype.getScrollTop = function () {
	var scrollDomRef = this.getDomRef();
	if (scrollDomRef) {
		var scrollTop = scrollDomRef.scrollTop;
		this.setProperty("scrollTop", scrollTop, true);
		return scrollTop;
	} else {
		return this.getProperty("scrollTop");
	}
};



/* --- user interaction handling methods --- */

sap.ui.commons.ListBox.prototype.onfocusin = function (oEvent) {
	if(!!sap.ui.Device.browser.internet_explorer && ((sap.ui.Device.browser.version == 7) || (sap.ui.Device.browser.version == 8)) /* =IE8! */ && (oEvent.target != this.getDomRef()) && (oEvent.target.className != "sapUiLbxI")) {
		var parent = oEvent.target.parentNode;

		if (jQuery(parent).hasClass("sapUiLbxI")) {
			parent.focus();
		}
	}
};

sap.ui.commons.ListBox.prototype.onmousedown = function(oEvent) {
	if (!!sap.ui.Device.browser.webkit && oEvent.target && oEvent.target.id === this.getId()) { // ListBox scrollbar has been clicked; webkit completely removes the focus, which breaks autoclose popups
		var idToFocus = document.activeElement ? document.activeElement.id : this.getId();
		var that = this;
		window.setTimeout(function(){
			var scrollPos = that.getDomRef().scrollTop; // yes, this scrollPosition is the right one to use. The one before setTimeout works for the scrollbar grip, but not for the arrows
			jQuery.sap.focus(jQuery.sap.domById(idToFocus)); // re-set the focus
			that.getDomRef().scrollTop = scrollPos; // re-apply the scroll position (otherwise the focus() call would scroll the focused element into view)
		},0);
	}
};

sap.ui.commons.ListBox.prototype.onclick = function (oEvent) {
	this._handleUserActivation(oEvent);
};

sap.ui.commons.ListBox.prototype.onsapspace = function (oEvent) {
	this._handleUserActivation(oEvent);
};

/*
 * Ensure the sapspace event with modifiers is also handled as well as the respective "enter" events
 */

sap.ui.commons.ListBox.prototype.onsapspacemodifiers = sap.ui.commons.ListBox.prototype.onsapspace;
sap.ui.commons.ListBox.prototype.onsapenter = sap.ui.commons.ListBox.prototype.onsapspace;
sap.ui.commons.ListBox.prototype.onsapentermodifiers = sap.ui.commons.ListBox.prototype.onsapspace;

/**
 * Internal method invoked when the user activates an item. Differentiates and dispatches according to modifier key
 * and current selection.
 *
 * @private
 */
sap.ui.commons.ListBox.prototype._handleUserActivation = function (oEvent) {
	if (!this.getEnabled() || !this.getEditable()) {
		return;
	}

	var oSource = oEvent.target;
	if (oSource.id === "" || jQuery.sap.endsWith(oSource.id, "-txt")) {
		oSource = oSource.parentNode;
		if (oSource.id === "") { // could be the image inside the first cell
			oSource = oSource.parentNode;
		}
	}
	var attr = jQuery(oSource).attr("data-sap-ui-lbx-index");
	if (typeof attr == "string" && attr.length > 0) {
		var iIndex = parseInt(attr, 10); // Get the selected index from the HTML

		var aItems = this.getItems();
		var oItem = aItems[iIndex]; // oItem could be a separator, though!

		// It could be the case that the list of items changed during the click event handling. Ensure the item is still the one in
		if (aItems.length <= iIndex) {  // TODO: very questionable! Why set the index to the last position? And why allow removing items during the processing?  Remove!
			iIndex = aItems.length - 1;
		}

		if (iIndex >= 0 && iIndex < aItems.length) { // TODO: this should be known by now
			if (oItem.getEnabled() && !(oItem instanceof sap.ui.core.SeparatorItem)) {
				// Take care of selection and select event
				if (oEvent.ctrlKey || oEvent.metaKey) { // = CTRL
						this._handleUserActivationCtrl(iIndex, oItem);
				} else {
					if (oEvent.shiftKey) {
						this.setSelectedIndices(this._getUserSelectionRange(iIndex));
						this.fireSelect({
							id:this.getId(),
							selectedIndex:iIndex,
							selectedIndices:this.getSelectedIndices(), /* NEW (do not use hungarian prefixes!) */
							selectedItem:oItem,
							sId:this.getId(),
							aSelectedIndices:this.getSelectedIndices() /* OLD */
						});
						this._iLastDirectlySelectedIndex = iIndex;
					} else {
						this._handleUserActivationPlain(iIndex, oItem);
					}
				}
			}
		}
		oEvent.preventDefault();
		oEvent.stopPropagation();
	}
};

/**
 * Called when the user triggers an item without holding a modifier key.
 * Changes the selection in the expected way.
 *
 * @private
 */
sap.ui.commons.ListBox.prototype._handleUserActivationPlain = function (iIndex, oItem) {
	this._iLastDirectlySelectedIndex = iIndex;
	this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(iIndex));
	if (this.getSelectedIndex() != iIndex || this.getSelectedIndices().length > 1) {
		this.setSelectedIndex(iIndex); // Replace selection

		this.fireSelect({
			id:this.getId(),
			selectedIndex:iIndex,
			selectedIndices:this.getSelectedIndices(), /* NEW (do not use hungarian prefixes!) */
			selectedItem:oItem,
			sId:this.getId(),
			aSelectedIndices:this.getSelectedIndices() /* OLD */
		});
	}
};

/**
 * Called when the user triggers an item while pressing the Ctrl key.
 * Changes the selection in the expected way for the "Ctrl" case.
 *
 * @private
 */
sap.ui.commons.ListBox.prototype._handleUserActivationCtrl = function (iIndex, oItem) {
	this._iLastDirectlySelectedIndex = iIndex;
	this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(iIndex));
	if (this.isIndexSelected(iIndex)) {
		this.removeSelectedIndex(iIndex); // Remove from multi-selection
	} else {
		this.addSelectedIndex(iIndex); // Add to multi-selection
	}

	this.fireSelect({
		id:this.getId(),
		selectedIndex:iIndex,
		selectedIndices:this.getSelectedIndices(), /* NEW (do not use hungarian prefixes!) */
		selectedItem:oItem,
		sId:this.getId(),
		aSelectedIndices:this.getSelectedIndices() /* OLD */
	});
};

/**
 * Calculates the list of indices ranging from the previously selected item to the
 * given index. Used internally for calculating the new selection range when the user holds the "shift" key
 * while clicking in the ListBox.
 *
 * @private
 */
sap.ui.commons.ListBox.prototype._getUserSelectionRange = function (iIndex) {
	if (this._iLastDirectlySelectedIndex == -1) {
		// TODO: Use focus and continue execution
		return [];
	}

	var aItems = this.getItems();
	var aRange = [];
	if (this._iLastDirectlySelectedIndex <= iIndex) {
		for (var i = this._iLastDirectlySelectedIndex; i <= iIndex; i++) {
			if ((i > -1) && (aItems[i].getEnabled() && !(aItems[i] instanceof sap.ui.core.SeparatorItem))) {
				aRange.push(i);
			}
		}
	} else {
		for (var i = iIndex; i <= this._iLastDirectlySelectedIndex; i++) {
			if ((i > -1) && (aItems[i].getEnabled() && !(aItems[i] instanceof sap.ui.core.SeparatorItem))) {
				aRange.push(i);
			}
		}
	}
	return aRange;
};



/* --- Overwritten setters and getters affecting the selection --- */

sap.ui.commons.ListBox.prototype.getSelectedIndex = function() {
	for (var i = 0; i < this._aSelectionMap.length; i++) {
		if (this._aSelectionMap[i]) {
			return i;
		}
	}
	return -1;
};

sap.ui.commons.ListBox.prototype.setSelectedIndex = function(iSelectedIndex) {
	if ((iSelectedIndex < -1) || (iSelectedIndex > this._aSelectionMap.length-1)) {
		return;
	} // Invalid index

	// do not select a disabled or separator item
	var aItems = this.getItems();
	if ((iSelectedIndex > -1) && (!aItems[iSelectedIndex].getEnabled() || (aItems[iSelectedIndex] instanceof sap.ui.core.SeparatorItem))) {
		return;
	}

	for (var i = 0; i < this._aSelectionMap.length; i++) {
		this._aSelectionMap[i] = false;
	}
	this._aSelectionMap[iSelectedIndex] = true;
	// And inform the itemNavigation about this, too
	if(this.oItemNavigation) {
		this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(iSelectedIndex));
	}
	this.getRenderer().handleSelectionChanged(this);

	return this;
};

sap.ui.commons.ListBox.prototype.addSelectedIndex = function(iSelectedIndex) {
	if (!this.getAllowMultiSelect()) { // If multi-selection is not allowed, this call equals setSelectedIndex
		this.setSelectedIndex(iSelectedIndex);
	}

	// Multi-selectable case
	if ((iSelectedIndex < -1) || (iSelectedIndex > this._aSelectionMap.length-1)) {
		return;
	} // Invalid index

	// do not select a disabled or separator item
	var aItems = this.getItems();
	if ((iSelectedIndex > -1) && (!aItems[iSelectedIndex].getEnabled() || (aItems[iSelectedIndex] instanceof sap.ui.core.SeparatorItem))) {
		return;
	}

	if (this._aSelectionMap[iSelectedIndex]) {
		return;
	} // Selection does not change

	// Was not selected before
	this._aSelectionMap[iSelectedIndex] = true;
	this.getRenderer().handleSelectionChanged(this);

	return this;
};

sap.ui.commons.ListBox.prototype.removeSelectedIndex = function(iIndex) {
	if ((iIndex < 0) || (iIndex > this._aSelectionMap.length-1)) {
		return;
	} // Invalid index

	if (!this._aSelectionMap[iIndex]) {
		return;
	} // Selection does not change

	// Was selected before
	this._aSelectionMap[iIndex] = false;
	this.getRenderer().handleSelectionChanged(this);

	return this;
};

sap.ui.commons.ListBox.prototype.clearSelection = function() {
	for (var i = 0; i < this._aSelectionMap.length; i++) {
		if (this._aSelectionMap[i]) {
			this._aSelectionMap[i] = false;
		}
	}
	// More or less re-initialized
	this._iLastDirectlySelectedIndex = -1;
	// Reset the index also in ItemNavigation
	if(this.oItemNavigation) {
		this.oItemNavigation.setSelectedIndex(-1);
	}
	this.getRenderer().handleSelectionChanged(this);

	return this;
};



sap.ui.commons.ListBox.prototype.getSelectedIndices = function() {
	var aResult = [];
	for (var i = 0; i < this._aSelectionMap.length; i++) {
		if (this._aSelectionMap[i]) {
			aResult.push(i);
		}
	}
	return aResult;
};

sap.ui.commons.ListBox.prototype.setSelectedIndices = function(aSelectedIndices) {
	var indicesToSet = [];
	var aItems = this.getItems();
	for (var i = 0; i < aSelectedIndices.length; i++) {
		if ((aSelectedIndices[i] > -1) && (aSelectedIndices[i] < this._aSelectionMap.length)) {
			if (aItems[aSelectedIndices[i]].getEnabled() && !(aItems[aSelectedIndices[i]] instanceof sap.ui.core.SeparatorItem)) {
				indicesToSet.push(aSelectedIndices[i]);
			}
		}
	}

	if (indicesToSet.length > 0) { // TODO: Disable event listening to items??
		// With multi-selection disabled, use the first valid index only
		if (!this.getAllowMultiSelect()) {
			indicesToSet = [indicesToSet[0]];
		}
	}

	for (var i = 0; i < this._aSelectionMap.length; i++) {
		this._aSelectionMap[i] = false;
	}

	// O(n+m)
	for (var i = 0; i < indicesToSet.length; i++) {
		this._aSelectionMap[indicesToSet[i]] = true;
	}
	this.getRenderer().handleSelectionChanged(this);

	return this;
};

sap.ui.commons.ListBox.prototype.addSelectedIndices = function(aSelectedIndices) {
	var indicesToSet = [];
	var aItems = this.getItems();
	for (var i = 0; i < aSelectedIndices.length; i++) {
		if ((aSelectedIndices[i] > -1) && (aSelectedIndices[i] < this._aSelectionMap.length)) {
			// do not select a disabled or separator item
			if (aItems[aSelectedIndices[i]].getEnabled() && !(aItems[aSelectedIndices[i]] instanceof sap.ui.core.SeparatorItem)) {
				indicesToSet.push(aSelectedIndices[i]);
			}
		}
	}

	if (indicesToSet.length > 0) { // TODO: Disable event listening to items??
		// With multi-selection disabled, use the first valid index only
		if (!this.getAllowMultiSelect()) {
			indicesToSet = [indicesToSet[0]];
		}

		// O(n+m)
		for (var i = 0; i < indicesToSet.length; i++) {
			this._aSelectionMap[indicesToSet[i]] = true;
		}
		this.getRenderer().handleSelectionChanged(this);
	}
	return this;
};


sap.ui.commons.ListBox.prototype.isIndexSelected = function(iIndex) {
	if ((iIndex < -1) || (iIndex > this._aSelectionMap.length-1)) {
		return false; // Invalid index -> not selected
	}

	return this._aSelectionMap[iIndex];
};


sap.ui.commons.ListBox.prototype.setSelectedKeys = function(aSelectedKeys) {
	var aItems = this.getItems();

	var key;
	var mKeyMap = {};
	for (var i = 0; i < aSelectedKeys.length; i++) { // put the keys into a map to hopefully search faster below
		mKeyMap[aSelectedKeys[i]] = true;
	}

	var aIndices = [];
	for (var j = 0; j < aItems.length; j++) {
		if (mKeyMap[aItems[j].getKey()]) {
			aIndices.push(j);
		}
	}

	return this.setSelectedIndices(aIndices);
};

sap.ui.commons.ListBox.prototype.getSelectedKeys = function() {
	var aItems = this.getItems();
	var aResult = [];
	for (var i = 0; i < this._aSelectionMap.length; i++) {
		if (this._aSelectionMap[i]) {
			aResult.push(aItems[i].getKey());
		}
	}
	return aResult;
};


sap.ui.commons.ListBox.prototype.getSelectedItem = function() {
	var iIndex = this.getSelectedIndex();
	if ((iIndex < 0) || (iIndex >= this._aSelectionMap.length)) {
		return null;
	}
	return this.getItems()[iIndex];
};

sap.ui.commons.ListBox.prototype.getSelectedItems = function() {
	var aItems = this.getItems();
	var aResult = [];
	for (var i = 0; i < this._aSelectionMap.length; i++) {
		if (this._aSelectionMap[i]) {
			aResult.push(aItems[i]);
		}
	}
	return aResult;
};

sap.ui.commons.ListBox.prototype.setAllowMultiSelect = function(bAllowMultiSelect) {
	this.setProperty("allowMultiSelect", bAllowMultiSelect);
	var oneWasSelected = false;
	var twoWereSelected = false;
	if (!bAllowMultiSelect && this._aSelectionMap) {
		for (var i = 0; i < this._aSelectionMap.length; i++) {
			if (this._aSelectionMap[i]) {
				if (!oneWasSelected) {
					oneWasSelected = true;
				} else {
					this._aSelectionMap[i] = false;
					twoWereSelected = true;
				}
			}
		}
	}
	if (twoWereSelected) {
		this.getRenderer().handleSelectionChanged(this);
	}
	return this;
};


/**
 * Handles the event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
 *
 * @param {sap.ui.base.Event} oControlEvent The event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
 * @private
 */
sap.ui.commons.ListBox.prototype._handleAfterFocus = function(oControlEvent) {
	var iIndex = oControlEvent.getParameter("index");
	iIndex = ((iIndex !== undefined && iIndex >= 0) ? this._aActiveItems[iIndex] : 0);

	this.getRenderer().handleARIAActivedescendant(this, iIndex);
};

/* --- "items" aggregation methods, overwritten to update _aSelectionMap and allow filteredItems --- */

/*
 * Implementation of API method setItems.
 * Semantically belonging to "items" aggregation but not part of generated method set.
 * @param bNoItemsChanged not in official API, only needed in DropdownBox TypeAhead
 */
sap.ui.commons.ListBox.prototype.setItems = function(aItems, bDestroyItems, bNoItemsChanged) {
	this.bNoItemsChangeEvent = true;
	if(bDestroyItems) {
		this.destroyItems();
	} else {
		this.removeAllItems();
	}
	for(var i = 0, l = aItems.length; i < l; i++){
		this.addItem(aItems[i]);
	}
	this.bNoItemsChangeEvent = undefined;
	if (!bNoItemsChanged) {
		this.fireEvent("itemsChanged", {event: "setItems", items: aItems}); //private event used in DropdownBox
	}
	return this;
};

sap.ui.commons.ListBox.prototype.addItem = function(oItem) {
	this.bNoItemInvalidateEvent = true;
	this.addAggregation("items", oItem);
	this.bNoItemInvalidateEvent = false;
	if ( !this._aSelectionMap ) {
		this._aSelectionMap = [];
	}
	this._aSelectionMap.push(false);

	if (!this.bNoItemsChangeEvent) {
		this.fireEvent("itemsChanged", {event: "addItem", item: oItem}); //private event used in DropdownBox
	}

	oItem.attachEvent("_change", this._handleItemChanged, this);

	return this;
};

sap.ui.commons.ListBox.prototype.insertItem = function(oItem, iIndex) {
	if ((iIndex < 0) || (iIndex > this._aSelectionMap.length)) {
		return;
	} // Ignore invalid index TODO:: check behavior for iIndex=length
	// TODO: Negative indices might be used to count from end of array

	this.bNoItemInvalidateEvent = true;
	this.insertAggregation("items", oItem, iIndex);
	this.bNoItemInvalidateEvent = false;
	this._aSelectionMap.splice(iIndex, 0, false);

	this.invalidate();

	if (!this.bNoItemsChangeEvent) {
		this.fireEvent("itemsChanged", {event: "insertItems", item: oItem, index: iIndex}); //private event used in DropdownBox
	}

	oItem.attachEvent("_change", this._handleItemChanged, this);

	return this;
};

sap.ui.commons.ListBox.prototype.removeItem = function(vElement) {
	var iIndex = vElement;
	if (typeof(vElement) == "string") { // ID of the element is given
		vElement = sap.ui.getCore().byId(vElement);
	}
	if (typeof(vElement) == "object") { // the element itself is given or has just been retrieved
		iIndex = this.indexOfItem(vElement);
	}

	if ((iIndex < 0) || (iIndex > this._aSelectionMap.length-1)) {
		if (!this.bNoItemsChangeEvent) {
			this.fireEvent("itemsChanged", {event: "removeItem", item: vElement}); //private event used in DropdownBox
		}
		return;
	} // Ignore invalid index

	this.bNoItemInvalidateEvent = true;
	var oRemoved = this.removeAggregation("items", iIndex);
	this.bNoItemInvalidateEvent = false;
	this._aSelectionMap.splice(iIndex, 1);

	this.invalidate();

	if (!this.bNoItemsChangeEvent) {
		this.fireEvent("itemsChanged", {event: "removeItem", item: oRemoved}); //private event used in DropdownBox
	}

	oRemoved.detachEvent("_change", this._handleItemChanged, this);

	return oRemoved;
};

sap.ui.commons.ListBox.prototype.removeAllItems = function() {
	this.bNoItemInvalidateEvent = true;
	var oRemoved = this.removeAllAggregation("items");
	this.bNoItemInvalidateEvent = false;

	this._aSelectionMap = [];

	this.invalidate();

	if (!this.bNoItemsChangeEvent) {
		this.fireEvent("itemsChanged", {event: "removeAllItems"}); //private event used in DropdownBox
	}

	for ( var i = 0; i < oRemoved.length; i++) {
		oRemoved[i].detachEvent("_change", this._handleItemChanged, this);
	}

	return oRemoved;
};

sap.ui.commons.ListBox.prototype.destroyItems = function() {

	var aItems = this.getItems();
	for ( var i = 0; i < aItems.length; i++) {
		aItems[i].detachEvent("_change", this._handleItemChanged, this);
	}

	this.bNoItemInvalidateEvent = true;
	var destroyed = this.destroyAggregation("items");
	this.bNoItemInvalidateEvent = false;

	this._aSelectionMap = [];

	this.invalidate();

	if (!this.bNoItemsChangeEvent) {
		this.fireEvent("itemsChanged", {event: "destroyItems"}); //private event used in DropdownBox
	}

	return destroyed;
};

sap.ui.commons.ListBox.prototype.updateItems = function(){

	this.bNoItemsChangeEvent = true;

	this.updateAggregation("items");

	this.bNoItemsChangeEvent = undefined;

	this.fireEvent("itemsChanged", {event: "updateItems"}); //private event used in DropdownBox

};

/**
 * Does all the cleanup when the ListBox is to be destroyed.
 * Called from the element's destroy() method.
 * @private
 */
sap.ui.commons.ListBox.prototype.exit = function (){
	if (this.oItemNavigation) {
		this.removeDelegate(this.oItemNavigation);
		this.oItemNavigation.destroy();
		delete this.oItemNavigation;
	}
	
	if(this._oScroller){
		this._oScroller.destroy();
		this._oScroller = null;
	}

	// No super.exit() to call
};

/*
 * Overrides getFocusDomRef of base element class.
 * @public
 */
sap.ui.commons.ListBox.prototype.getFocusDomRef = function() {
	return this.getDomRef("list");
};

/*
 * Overwrites default implementation
 * the label must point to the UL element
 * @public
 */
sap.ui.commons.ListBox.prototype.getIdForLabel = function () {
	return this.getId()+'-list';
};

/*
 * inform ComboBox if an item has changed
*/
sap.ui.commons.ListBox.prototype._handleItemChanged = function(oEvent) {

	if (!this.bNoItemInvalidateEvent) {
		this.fireEvent("itemInvalidated", {item: oEvent.oSource}); //private event used in ComboBox
	}

};

}; // end of sap/ui/commons/ListBox.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Menu') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Menu.
jQuery.sap.declare("sap.ui.commons.Menu");

jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained



/**
 * Constructor for a new Menu.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.Menu#constructor sap.ui.unified.Menu}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A container for menu items. When the space in the browser is not large enough to display all defined items, a scroll bar is provided.
 * @extends sap.ui.unified.Menu
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.21.0. 
 * Please use the control sap.ui.unified.Menu of the library sap.ui.unified instead.
 * @name sap.ui.commons.Menu
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.Menu.extend("sap.ui.commons.Menu", { metadata : {

	deprecated : true,
	library : "sap.ui.commons"
}});


/**
 * Creates a new subclass of class sap.ui.commons.Menu with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Menu.extend
 * @function
 */


// Start of sap\ui\commons\Menu.js
 /*Ensure MenuItemBase is loaded (incl. loading of unified library)*/
}; // end of sap/ui/commons/Menu.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuButton') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.MenuButton.
jQuery.sap.declare("sap.ui.commons.MenuButton");




/**
 * Constructor for a new MenuButton.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getDockButton dockButton} : string</li>
 * <li>{@link #getDockMenu dockMenu} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getMenu menu} <strong>(default aggregation)</strong> : sap.ui.unified.Menu</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.MenuButton#event:itemSelected itemSelected} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.commons.Button#constructor sap.ui.commons.Button}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Common button control that opens a menu when clicked by the user. The control provides an API for configuring the docking position
 * of the menu.
 * @extends sap.ui.commons.Button
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.MenuButton
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.commons.Button.extend("sap.ui.commons.MenuButton", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"dockButton" : {type : "string", group : "Misc", defaultValue : null},
		"dockMenu" : {type : "string", group : "Misc", defaultValue : null}
	},
	defaultAggregation : "menu",
	aggregations : {
		"menu" : {type : "sap.ui.unified.Menu", multiple : false}
	},
	events : {
		"itemSelected" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.MenuButton with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.MenuButton.extend
 * @function
 */

sap.ui.commons.MenuButton.M_EVENTS = {'itemSelected':'itemSelected'};


/**
 * Getter for property <code>dockButton</code>.
 * The position / edge (see sap.ui.core.Popup.Dock) of the button where the menu is docked. Default is 'begin bottom'.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>dockButton</code>
 * @public
 * @name sap.ui.commons.MenuButton#getDockButton
 * @function
 */

/**
 * Setter for property <code>dockButton</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sDockButton  new value for property <code>dockButton</code>
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MenuButton#setDockButton
 * @function
 */


/**
 * Getter for property <code>dockMenu</code>.
 * The position / edge (see sap.ui.core.Popup.Dock) of the menu which is docked to the button. Default is 'begin top'.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>dockMenu</code>
 * @public
 * @name sap.ui.commons.MenuButton#getDockMenu
 * @function
 */

/**
 * Setter for property <code>dockMenu</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sDockMenu  new value for property <code>dockMenu</code>
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MenuButton#setDockMenu
 * @function
 */


/**
 * Getter for aggregation <code>menu</code>.<br/>
 * Menu that shall be opened when the button is clicked
 * 
 * <strong>Note</strong>: this is the default aggregation for MenuButton.
 * @return {sap.ui.unified.Menu}
 * @public
 * @name sap.ui.commons.MenuButton#getMenu
 * @function
 */


/**
 * Setter for the aggregated <code>menu</code>.
 * @param {sap.ui.unified.Menu} oMenu
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MenuButton#setMenu
 * @function
 */
	

/**
 * Destroys the menu in the aggregation 
 * named <code>menu</code>.
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MenuButton#destroyMenu
 * @function
 */


/**
 * Event that is fired when a menu item is selected by the user
 *
 * @name sap.ui.commons.MenuButton#itemSelected
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.itemId The ID of the selected item
 * @param {sap.ui.commons.MenuItemBase} oControlEvent.getParameters.item The selected item
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'itemSelected' event of this <code>sap.ui.commons.MenuButton</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.MenuButton</code>.<br/> itself. 
 *  
 * Event that is fired when a menu item is selected by the user
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.MenuButton</code>.<br/> itself.
 *
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MenuButton#attachItemSelected
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'itemSelected' event of this <code>sap.ui.commons.MenuButton</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MenuButton#detachItemSelected
 * @function
 */

/**
 * Fire event itemSelected to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'itemId' of type <code>string</code> The ID of the selected item</li>
 * <li>'item' of type <code>sap.ui.commons.MenuItemBase</code> The selected item</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.MenuButton#fireItemSelected
 * @function
 */


// Start of sap\ui\commons\MenuButton.js
 /*Ensure MenuItemBase is loaded (incl. loading of unified library)*/


(function() {
	
sap.ui.commons.MenuButton.prototype.init = function() {
	this.addStyleClass("sapUiMenuButton");
	this.bWithKeyboard = false;
};

/**
 * Function is called when button is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.MenuButton.prototype.onclick = function(oEvent) {
	if(this.getEnabled() && !this._bSkipOpen){
		var oTooltip = this.getTooltip();
		if(oTooltip && oTooltip instanceof sap.ui.core.TooltipBase){
			oTooltip._closeOrPreventOpen(); //CSN 1762131 2013
		}
		var sDockButton = this.getDockButton() ? this.getDockButton() : sap.ui.core.Popup.Dock.BeginBottom;
		var sDockMenu = this.getDockMenu() ? this.getDockMenu() : sap.ui.core.Popup.Dock.BeginTop;
		this.getMenu().open(this.bWithKeyboard, this, sDockMenu, sDockButton, this);
	}
	this.bWithKeyboard = false;
	this._bSkipOpen = false;
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

/**
 * Function is called when mouse key is clicked down.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.MenuButton.prototype.onmousedown = function(oEvent) {
	this.handleMouseDown(oEvent, false);
	this._bSkipOpen = this.getMenu() && this.getMenu().bOpen;
};


/**
 * Function is called when mouse leaves the control.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.MenuButton.prototype.onmouseout = function(oEvent) {
	if(sap.ui.commons.Button.prototype.onmouseout){
		sap.ui.commons.Button.prototype.onmouseout.apply(this, arguments);
	}
	if(this._bSkipOpen && jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())){
		this._bSkipOpen = false;
	}
};


/**
 * Function is called when enter key is pressed.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.MenuButton.prototype.onsapenter = function(oEvent){
	//It is sufficient to set this flag here only. A click event to open the menu will follow.
	this.bWithKeyboard = true;
};

/**
 * Function is called when space key is pressed.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.MenuButton.prototype.onsapspace = function(oEvent){
	//It is sufficient to set this flag here only. A click event to open the menu will follow.
	this.bWithKeyboard = true;
};

/**
 * Function is called when down key is pressed with a modifier key.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
//Requested by UX, see CSN 0120061532 0001379793 2011
sap.ui.commons.MenuButton.prototype.onsapdownmodifiers = function(oEvent){
	if(oEvent.altKey){
		this.bWithKeyboard = true;
		this.onclick(oEvent);
	}
};

sap.ui.commons.MenuButton.prototype.clone = function(sIdSuffix, aLocalIds) {
	//Deregister event listener before cloning
	updateMenuEventRegistration(this);
	var oClone = sap.ui.commons.Button.prototype.clone.apply(this, arguments);
	updateMenuEventRegistration(this, this.getMenu());
	return oClone;
};

/**
 * Setter for the aggregated <code>menu</code>.
 * @param {sap.ui.commons.Menu} oMenu
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.MenuButton.prototype.setMenu = function(oMenu) {
	updateMenuEventRegistration(this, oMenu);
	this.setAggregation("menu", oMenu);
	return this;
};

/**
 * Destroys the menu in the aggregation
 * named <code>menu</code>.
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.MenuButton.prototype.destroyMenu = function() {
	updateMenuEventRegistration(this, null);
	this.destroyAggregation("menu");
	return this;
};

//********** Private **********

// Detaches the select event handler from the current menu and attaches it to the new menu
var updateMenuEventRegistration = function(oThis, oNewMenu){
	var oMenu = oThis.getMenu();
	if(oMenu) {
		oMenu.detachItemSelect(oThis._fItemSelectHandler);
	}
	oThis._fItemSelectHandler = jQuery.proxy(onItemSelected, oThis);
	if(oNewMenu) {
		oNewMenu.attachItemSelect(oThis._fItemSelectHandler);
	}
};

//Function is called when an item in the menu was selected.
var onItemSelected = function(oEvent){
	var oItem = oEvent.getParameter("item");
	this.fireItemSelected({itemId: oItem.getId(), item: oItem});
	this.firePress({itemId: oItem.getId(), item: oItem});
};

}());

// to overwrite JS doc for inherited press event

/**
 * Fired when an item from the menu was selected.
 *
 * @see sap.ui.commons.MenuButton#itemSelected
 *
 * @name sap.ui.commons.MenuButton#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 *
 * @param {string} oControlEvent.getParameters.itemId The id of the selected item
 * @param {sap.ui.commons.MenuItemBase} oControlEvent.getParameters.item The selected item
 * @public
 */

/**
 * Attach event-handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.commons.MenuButton</code>.<br/>
 *
 * Event is fired when an item from the menu was selected.
 *
 * @see sap.ui.commons.MenuButton#attachItemSelected
 *
 * @param {object}
 *            [oData] The object, that should be passed along with the event-object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs. This function will be called on the
 *            oListener-instance (if present) or in a 'static way'.
 * @param {object}
 *            [oListener] Object on which to call the given function. If empty, the global context (window) is used.
 *
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 */

/**
 * Detach event-handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.commons.MenuButton</code>.<br/>
 *
 * The passed function and listener object must match the ones previously used for event registration.
 *
 * @see sap.ui.commons.MenuButton#detachItemSelected
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Object on which the given function had to be called.
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @public
 */

/**
 * Fire event press to attached listeners.
 *
 * @see sap.ui.commons.MenuButton#fireItemSelected
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
 * @protected
 */
}; // end of sap/ui/commons/MenuButton.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.MenuItem.
jQuery.sap.declare("sap.ui.commons.MenuItem");

jQuery.sap.require('sap.ui.unified.MenuItem'); // unlisted dependency retained



/**
 * Constructor for a new MenuItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.MenuItem#constructor sap.ui.unified.MenuItem}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Smallest unit in the menu hierarchy. An item can be a direct part of a menu bar, of a menu, or of a sub menu.
 * @extends sap.ui.unified.MenuItem
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.21.0. 
 * Please use the control sap.ui.unified.MenuItem of the library sap.ui.unified instead.
 * @name sap.ui.commons.MenuItem
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.MenuItem.extend("sap.ui.commons.MenuItem", { metadata : {

	deprecated : true,
	library : "sap.ui.commons"
}});


/**
 * Creates a new subclass of class sap.ui.commons.MenuItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.MenuItem.extend
 * @function
 */


// Start of sap\ui\commons\MenuItem.js
 /*Ensure MenuItemBase is loaded (incl. loading of unified library)*/
}; // end of sap/ui/commons/MenuItem.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuTextFieldItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.MenuTextFieldItem.
jQuery.sap.declare("sap.ui.commons.MenuTextFieldItem");

jQuery.sap.require('sap.ui.unified.MenuTextFieldItem'); // unlisted dependency retained



/**
 * Constructor for a new MenuTextFieldItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.MenuTextFieldItem#constructor sap.ui.unified.MenuTextFieldItem}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Menu item which contains an text field. This menu item is e.g. helpful for filters.
 * The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
 * @extends sap.ui.unified.MenuTextFieldItem
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.21.0. 
 * Please use the control sap.ui.unified.MenuTextFieldItem of the library sap.ui.unified instead.
 * @name sap.ui.commons.MenuTextFieldItem
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.MenuTextFieldItem.extend("sap.ui.commons.MenuTextFieldItem", { metadata : {

	deprecated : true,
	library : "sap.ui.commons"
}});


/**
 * Creates a new subclass of class sap.ui.commons.MenuTextFieldItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.MenuTextFieldItem.extend
 * @function
 */


// Start of sap\ui\commons\MenuTextFieldItem.js
 /*Ensure MenuItemBase is loaded (incl. loading of unified library)*/
}; // end of sap/ui/commons/MenuTextFieldItem.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Message') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Message.
jQuery.sap.declare("sap.ui.commons.Message");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Message.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getType type} : sap.ui.commons.MessageType</li>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getAssociatedElementId associatedElementId} : string</li>
 * <li>{@link #getDesign design} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Creates the "Message"s to be supplied to the "MessageBar" Control.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.4.0. 
 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
 * @name sap.ui.commons.Message
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Message", { metadata : {

	deprecated : true,
	publicMethods : [
		// methods
		"bindDetails"
	],
	library : "sap.ui.commons",
	properties : {
		"type" : {type : "sap.ui.commons.MessageType", group : "Behavior", defaultValue : null},
		"text" : {type : "string", group : "Data", defaultValue : null},
		"associatedElementId" : {type : "string", group : "Data", defaultValue : null},
		"design" : {type : "string", group : "Misc", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Message with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Message.extend
 * @function
 */


/**
 * Getter for property <code>type</code>.
 * "Success", or "Warning", or "Error" messages. (Mandatory)
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.commons.MessageType} the value of property <code>type</code>
 * @public
 * @name sap.ui.commons.Message#getType
 * @function
 */

/**
 * Setter for property <code>type</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.commons.MessageType} oType  new value for property <code>type</code>
 * @return {sap.ui.commons.Message} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Message#setType
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * Message short text. (Mandatory)
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.commons.Message#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.commons.Message} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Message#setText
 * @function
 */


/**
 * Getter for property <code>associatedElementId</code>.
 * Associated UI element ID. (Optional)
 * For navigation to error field.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>associatedElementId</code>
 * @public
 * @name sap.ui.commons.Message#getAssociatedElementId
 * @function
 */

/**
 * Setter for property <code>associatedElementId</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAssociatedElementId  new value for property <code>associatedElementId</code>
 * @return {sap.ui.commons.Message} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Message#setAssociatedElementId
 * @function
 */


/**
 * Getter for property <code>design</code>.
 * Internal attribute, used to force the display of the "short" or the "long" text only.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>design</code>
 * @public
 * @name sap.ui.commons.Message#getDesign
 * @function
 */

/**
 * Setter for property <code>design</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sDesign  new value for property <code>design</code>
 * @return {sap.ui.commons.Message} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Message#setDesign
 * @function
 */


/**
 * Registers a callback function to be invoked if long text Details are to be made available. This callback function will be supplied the corresponding Message "id", and should return the HTML string to be displayed within the Message Details Dialog.
 * E.g.: myMessage.bindDetails(getDetails);
 * where
 * function getDetails(sId) {... return htmlString;}
 *
 * @name sap.ui.commons.Message#bindDetails
 * @function
 * @type string
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\Message.js


sap.ui.commons.Message.prototype.init = function(){
	// Defining some private data...
	this.isRTL = sap.ui.getCore().getConfiguration().getRTL();

	// The "Details" related Controls.
  this.fnCallBack    = null; // Supplied only if a longText is to be provided on demand.
	this.oLink         = null; // Created only if a longText exists. This is the link opening the Details Dialog.
	this.oContainer    = null; // Created only if a longText exists. This is the "Dialog" hosting the Details.
	this.oDetails      = null; // Created only if a longText exists. This is the Controller rendering the Details.
	this.oBtnOK        = null; // Created only if a longText exists. This is the OK button found within the Dialog.
};

/**
 * Destroys this Control instance, called by Element#destroy()
 * @private
 */
sap.ui.commons.Message.prototype.exit = function() {
	if (this.oLink) {
		this.oLink.destroy();
		this.oLink = null;
	}
	if (this.oDetails) {
		this.oDetails.destroy();
		this.oDetails = null;
	}
	if (this.oContainer) {
		this.oContainer.destroy();
		this.oContainer = null;
	}
	if (this.oBtnOK) {
		this.oBtnOK.destroy();
		this.oBtnOK = null;
	}
};

// #############################################################################
// Internal Utilities
// #############################################################################
/**
 * This utility is for closing the Message Details from its OK button.
 * @private
 */
sap.ui.commons.Message.closeDetails = function(oControlEvent) {
  oControlEvent.getSource().getParent().close();
};
/**
 * This utility closes THIS Message's Details.
 * @private
 */
sap.ui.commons.Message.prototype.closeDetails = function() {
  // If Details have been opened, can attempt to close them:
  if (this.oContainer) {
	this.oContainer.close();
  }
};

/**
 * This utility renders the Message Details.
 * Current Specifications are those of JPaaS:
 *    Supported by:               "Dialog"              "MessageBox"
 *  - Title:                       Yes                   Yes
 *  - Non-blocking:                Yes, configurable.    No, modal only
 *  - Accepts HTML string:         Yes, via oContent.    No, sMessage only
 *  - Bottom-Right resize handle:  Yes                   No
 *  - No icon:                     Yes                   Possible
 * @private
 */
sap.ui.commons.Message.prototype.openDetails = function() {
  if (!this.oContainer) {
	var rb          = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	var OK          = rb.getText("MSGBAR_DETAILS_DIALOG_CLOSE");
	var title       = rb.getText("MSGBAR_DETAILS_DIALOG_TITLE");
	// Reading the HTML details as is, styles included:
	var	htmlDetails = this.fnCallBack(this.getId());
	this.oDetails   = new sap.ui.commons.Message({type: this.getType(), text: htmlDetails});
	this.oBtnOK     = new sap.ui.commons.Button({text: OK, press:sap.ui.commons.Message.closeDetails});
	this.oContainer = new sap.ui.commons.Dialog();
	this.oContainer.addContent(this.oDetails);
	this.oContainer.setTitle(title);
		this.oContainer.addButton(this.oBtnOK);
  //this.oContainer.setDefaultButton(this.oBtnOK); // Already the default since the only button...
  }
	// Other visible Dialogs around?
  var sContainerId = this.oContainer.getId();
  var iOthersMaxZIndex = 0;
  var oOtherOpenDialogs = jQuery('.sapUiDlg');
  for (var i=oOtherOpenDialogs.length-1; i>=0; i--) {
	if (jQuery(oOtherOpenDialogs[i]).css('visibility') != "visible") {
	  oOtherOpenDialogs.splice(i, 1);
	} else if (oOtherOpenDialogs[i].id == sContainerId) {
	  oOtherOpenDialogs.splice(i, 1);
	} else {
	  iOthersMaxZIndex = Math.max(iOthersMaxZIndex,jQuery(oOtherOpenDialogs[i]).css('zIndex'));
	}
  }

  // Taking note for later:
  var bWasOpen = this.oContainer.isOpen();
  // No matter what, we have to open the new Details, so:
  this.oContainer.open();

  // jQuery version of our OPEN Dialog Container:
	var jContainer = this.oContainer.$();

  // Starting a new Stack in the default Dialog's location:
  var jContainerRect = jContainer.rect(); // For Height and Width...
	if (oOtherOpenDialogs.length == 0) {
		// "offsets.right" & "offsets.left" should be identical as plain Dialogs are centered,
		// but in case there is a bug (like in Safari RTL):
		if (this.isRTL) {
		  // Will be using "left" invariably for RTL or LTR:
			jContainerRect.left = Number(jContainer.css('right').replace("px", ""));
		}
		this.setLastOffsets(jContainerRect);
		// Nothing else to do:
		return;
	}

  // Dialog limitation. Work-around:
  if (bWasOpen) {
		if (iOthersMaxZIndex > jContainer.css('zIndex')) {
			// zIndex not raised via previous re-open()...
			// Have to raise it ourselves.
		jContainer.css('zIndex',iOthersMaxZIndex+1);
		}
		// Nothing else to do:
	return;
  }

  //*************** Stacking process starts ***************
  // 1st rendering the new Dialog on top of the old one...
  var oNextOffsets = this.getNextOffsets();
	jContainer.css('top',  (oNextOffsets.top -sap.ui.commons.Message.TOP_INCR ) + "px");
  if (this.isRTL) {
		jContainer.css('right', (oNextOffsets.left-sap.ui.commons.Message.LEFT_INCR) + "px");
  } else {
	jContainer.css('left',  (oNextOffsets.left-sap.ui.commons.Message.LEFT_INCR) + "px");
  }

  // Figuring what should the next coordinates be:
  var jContainerRect = jContainer.rect(); // For Height and Width...
  var scrollTop   = jQuery(window).scrollTop();
  var scrollLeft  = jQuery(window).scrollLeft(); // Negative in RTL
  var scrollRight = -scrollLeft;
  // Checking if the new coordinates fit within the window:
  if ((jQuery(window).height()+scrollTop) < (oNextOffsets.top+jContainerRect.height)) {
	// ReStacking from the top:
	oNextOffsets.top = scrollTop;
	this.setLastOffsets(oNextOffsets);
  }
  if (this.isRTL) {
	  if ((jQuery(window).width()+scrollRight) < (oNextOffsets.left+jContainerRect.width)) {
		// ReStacking from the right:
		oNextOffsets.left = scrollRight;
		this.setLastOffsets(oNextOffsets);
	  }
		// Animating the Dialog to its new offset position:
		jContainer.animate({top:oNextOffsets.top+"px", right:oNextOffsets.left+"px"}, 200);
  } else {
	  if ((jQuery(window).width()+scrollLeft) < (oNextOffsets.left+jContainerRect.width)) {
		// ReStacking from the left:
		oNextOffsets.left = scrollLeft;
		this.setLastOffsets(oNextOffsets);
	  }
		// Animating the Dialog to its new offset position:
		jContainer.animate({top:oNextOffsets.top+"px", left:oNextOffsets.left+"px"}, 200);
  }

//MESSAGEBOX BACKUP: Issues: Only Modal, Doesn't accept HTML string, No Resize-Area.
//	var rb    = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
//  var ICON  = this.getType().toUpperCase();		// ERROR, WARNING, ...
//  var title = rb.getText("MSGTYPE_" + ICON);
//  var text  = this.getLongText();
//  sap.ui.commons.MessageBox.show(text, ICON, title);
};

sap.ui.commons.Message.TOP_INCR  = 20;
sap.ui.commons.Message.LEFT_INCR = 10;


// Begin of Dialog-Offsets-Stacking facilities
(function() {
	var oLastOffsets = null;
	/**
	 * @static
	 */
	sap.ui.commons.Message.setLastOffsets = function(oOffsets){
		oLastOffsets = oOffsets;
	};
	sap.ui.commons.Message.prototype.setLastOffsets = function(oOffsets){
		sap.ui.commons.Message.setLastOffsets(oOffsets);
	};
	sap.ui.commons.Message.getNextOffsets = function(){
	  oLastOffsets.top   += sap.ui.commons.Message.TOP_INCR;
	  oLastOffsets.left  += sap.ui.commons.Message.LEFT_INCR;
		return oLastOffsets;
	};
	sap.ui.commons.Message.prototype.getNextOffsets = function(){
		return sap.ui.commons.Message.getNextOffsets();
	};
}());
// End of Dialog-Offsets-Stacking facilities


// #############################################################################
// Public APIs
// #############################################################################
/**
 * This interface registers a CallBack function, to be called for rendering
 * the longText Details of a Message.
 * This function will be supplied the ID of the Message.
 * This function is expected to return the (simple) HTML string giving the
 * details belonging to this message ID.
 * @param {Function} fnCallBack
 * @public
 */
sap.ui.commons.Message.prototype.bindDetails = function(fnCallBack) {
  this.fnCallBack = fnCallBack;
};
}; // end of sap/ui/commons/Message.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageBar') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.MessageBar.
jQuery.sap.declare("sap.ui.commons.MessageBar");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new MessageBar.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getAnchorID anchorID} : string (default: '')</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getMaxToasted maxToasted} : int (default: 3)</li>
 * <li>{@link #getMaxListed maxListed} : int (default: 7)</li>
 * <li>{@link #getAnchorSnapPoint anchorSnapPoint} : string (default: "begin top")</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Creates an instance of a "MessageBar" Control, for displaying "Message"s.
 * There is no imposed limit on the number of "MessageBar"s that can be created, but using only 1 makes sense, specially if accessing it (via Ctl-m) becomes a necessity.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.4.0. 
 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
 * @name sap.ui.commons.MessageBar
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.MessageBar", { metadata : {

	deprecated : true,
	publicMethods : [
		// methods
		"addMessages", "deleteMessages", "deleteAllMessages"
	],
	library : "sap.ui.commons",
	properties : {
		"anchorID" : {type : "string", group : "Appearance", defaultValue : ''},
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"maxToasted" : {type : "int", group : "Misc", defaultValue : 3},
		"maxListed" : {type : "int", group : "Misc", defaultValue : 7},
		"anchorSnapPoint" : {type : "string", group : "Misc", defaultValue : "begin top"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.MessageBar with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.MessageBar.extend
 * @function
 */


/**
 * Getter for property <code>anchorID</code>.
 * Element ID upon which the 'message bar' is to be initially positioned.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>anchorID</code>
 * @public
 * @name sap.ui.commons.MessageBar#getAnchorID
 * @function
 */

/**
 * Setter for property <code>anchorID</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAnchorID  new value for property <code>anchorID</code>
 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageBar#setAnchorID
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.MessageBar#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageBar#setVisible
 * @function
 */


/**
 * Getter for property <code>maxToasted</code>.
 * Maximum number of simultaneous messages being toasting-up in a row. Value '0' means this dynamic part of the feature is switched off.
 *
 * Default value is <code>3</code>
 *
 * @return {int} the value of property <code>maxToasted</code>
 * @public
 * @name sap.ui.commons.MessageBar#getMaxToasted
 * @function
 */

/**
 * Setter for property <code>maxToasted</code>.
 *
 * Default value is <code>3</code> 
 *
 * @param {int} iMaxToasted  new value for property <code>maxToasted</code>
 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageBar#setMaxToasted
 * @function
 */


/**
 * Getter for property <code>maxListed</code>.
 * Maximum number of messages being display in the List before a scrollbar appears. Value '0' means no limit.
 *
 * Default value is <code>7</code>
 *
 * @return {int} the value of property <code>maxListed</code>
 * @public
 * @name sap.ui.commons.MessageBar#getMaxListed
 * @function
 */

/**
 * Setter for property <code>maxListed</code>.
 *
 * Default value is <code>7</code> 
 *
 * @param {int} iMaxListed  new value for property <code>maxListed</code>
 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageBar#setMaxListed
 * @function
 */


/**
 * Getter for property <code>anchorSnapPoint</code>.
 * Type: sap.ui.core.Popup.Dock
 * SnapPoint of MessageBar over anchorId.
 * Note: Use "begin" or "end" for RTL support.
 * Note: "center" is not indicated, as positioning is only set once, either via the css "left" or the "right" attribute. Therefore a MessageBar will only be extended in one direction, as Messages come in.
 *
 * Default value is <code>"begin top"</code>
 *
 * @return {string} the value of property <code>anchorSnapPoint</code>
 * @public
 * @name sap.ui.commons.MessageBar#getAnchorSnapPoint
 * @function
 */

/**
 * Setter for property <code>anchorSnapPoint</code>.
 *
 * Default value is <code>"begin top"</code> 
 *
 * @param {string} sAnchorSnapPoint  new value for property <code>anchorSnapPoint</code>
 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageBar#setAnchorSnapPoint
 * @function
 */


/**
 * To add message(s).
 *
 * @name sap.ui.commons.MessageBar#addMessages
 * @function
 * @param {sap.ui.commons.Message[]} aAMessages
 *         Array of messages.
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * To deleted messages.
 *
 * @name sap.ui.commons.MessageBar#deleteMessages
 * @function
 * @param {string[]} aIds
 *         Messages IDs to be deleted.
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * To deleted all messages.
 *
 * @name sap.ui.commons.MessageBar#deleteAllMessages
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\MessageBar.js
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained


sap.ui.commons.MessageBar.prototype.init = function(){
	// Defining some private data...

	// Message queues, in priority order:
	this.aErrors    = []; // Error queue.
	this.aWarnings  = []; // Warning queue.
	this.aSuccesses = []; // Success queue.
	// Toasting queue:
	this.aToasts    = [];
	this.maxToastsReached = false; // Disables Toast queue.

	// Popup(oContent, bModal, bShadow, bAutoClose) container initialization:
	// - oModal: "true/false" : For blocking the background window.
	this.oPopup   = new sap.ui.core.Popup(this, false, true, false);

	// The different related Controls.
	this.oList    = null; // Created only if opened by user.
	// MessageBar does not come without Toasts:
	var id        = this.getId();
	this.oToast   = new sap.ui.commons.MessageToast(id+"__Toast", {anchorId:id+"__sums"});
	var that      = this; // For closure
	this.oToast.attachNext(function(){that.checkForToast();});

	// Drag&Drop data. Only evaluated if needed:
	this.snapPoint = null;
	this.oHomePosition = null;
	this.oDropPosition = null;
	this.bToggleListBackAfterDrag = null;
};

/**
 * Destroys this Control instance, called by Element#destroy()
 * @private
 */
sap.ui.commons.MessageBar.prototype.exit = function() {
	// If this happens during a Drag, forcing a Drop
	// in order to remove any bound handlers:
	this.onmouseup();

	// Closing and destroying everything:
	this.close();

	this.oPopup.destroy();
	this.oPopup = null;

	this.oToast.destroy();
	this.oToast = null;

	if (this.oList) {
		this.oList.destroy();
		this.oList = null;
	}
};

// **************************************************
// * Drag&Drop // Copied from Dialog and ColumnDnDManager...
// **************************************************
/**
* Overwrites the native D&D, not to see the native ghost.
* @param {sap.ui.core.BrowserEvent} oEvent The forwarded browser event
* @private
*/
sap.ui.commons.MessageBar.prototype.ondragstart = function(oEvent){
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

/**
 * Initializes drag and drop capabilities.
 *
 * @param {jQuery.Event} oEvent The event object
 * @private
 */
sap.ui.commons.MessageBar.prototype.onmousedown = function (oEvent) {
//jQuery.sap.log.debug("MESSAGEBAR: ONMOUSEDOWN");
	var oSource  = oEvent.target;
	var jSource = jQuery(oSource);

	// If cursor does not say move, then do not bother.
	if (jSource.css('cursor') != "move") {
		return;
	}

	this.sDragMode = "move";


  // MessageBar start position:
	this.oMsgBarDragStartPosition       = this.$().rect();
	this.oMsgBarDragStartPosition.right = Number(this.$().css('right').replace("px", ""));

	// Recording our home position, in order to return to it on demand:
	if (!this.oHomePosition) {
		this.oHomePosition = this.oMsgBarDragStartPosition;
	}

	// To evaluate the extend of the drag:
	this.mouseDragStartPositionX = oEvent.screenX;
	this.mouseDragStartPositionY = oEvent.screenY;

	// Activating our move handler:
	var jDocument = jQuery(window.document);
	jDocument.bind("mousemove", jQuery.proxy(this.handleMove, this));
	if(window.parent) {
		jQuery(window.parent.document).bind("mousemove", jQuery.proxy(this.handleMove, this), true);
	}

	// Fix for IE blue text selection while dragging:
	jDocument.bind("selectstart",jQuery.proxy(this.ondragstart,this), true);
};

/**
 * Handles the move event.
 * @param {DOMEvent} event The event raised by the browser.
 * @private
 */
sap.ui.commons.MessageBar.prototype.handleMove = function (event) {
//jQuery.sap.log.debug("MESSAGEBAR: HANDLEMOVE");
	if (!this.sDragMode) {
		return;
	}

  // First closing the MessageList, if visible.
  // That will allow the user to better see where he moves the MessageBar.
  // We will reopen it after the Drop.
  // This will also allow the List Popup to properly position itself (UP/DOWN).
  if (this.bToggleListBackAfterDrag==null && this.oList) {
	this.bToggleListBackAfterDrag = this.oList.getVisible();
	if (this.bToggleListBackAfterDrag) {
		this.toggleList();
	}
  }

  // Moving our Control by the extent of the mouse-drag:
	event = event || window.event;
	var iTop   = this.oMsgBarDragStartPosition.top   + event.screenY - this.mouseDragStartPositionY;
	var iLeft  = this.oMsgBarDragStartPosition.left  + event.screenX - this.mouseDragStartPositionX;
	var iRight = this.oMsgBarDragStartPosition.right - event.screenX + this.mouseDragStartPositionX;

  this.oPopup._$().css('top', iTop);
	// Is the Bar to be positioned and dragged from its right-hand side???
	if (this.snapPoint.indexOf("right") != -1) {
		this.oPopup._$().css('right', iRight);
	} else {
		this.oPopup._$().css('left', iLeft);
	}

	// Saving the drop position for the next MessageList "open" event:
	this.oDropPosition = {top: iTop, left: iLeft, right: iRight};

	event.cancelBubble = true;
	return false;
};

/**
 * Handle onmouseup event.
 * This does the cleanup after drag and move handling.
 * @param {jQuery.Event} oEvent The event object
 * @private
 */
sap.ui.commons.MessageBar.prototype.onmouseup = function (oEvent) {
//jQuery.sap.log.debug("MESSAGEBAR: ONMOUSEUP");
	if (!this.sDragMode) {
		return;
	}

	// If we have indeed moved, then rendering our "back-home" icon:
  if (this.oDropPosition) {
	  this.addStyleClass("sapUiMsgBarMoved");
  }

  // Reopening the List if was open before the move:
  if (this.bToggleListBackAfterDrag) {
	this.toggleList();
  }
  this.bToggleListBackAfterDrag = null; // Re-initialized for the next D&D.

	// Removing our move handler:
	var jDocument = jQuery(window.document);
	jDocument.unbind("mousemove", jQuery.proxy(this.handleMove, this));
	if(window.parent) {
		jQuery(window.parent.document).unbind("mousemove", jQuery.proxy(this.handleMove, this));
	}
	jDocument.unbind("selectstart",jQuery.proxy(this.ondragstart,this));

	this.sDragMode = null;

	// Resume the toasting:
	this.checkForToast();
};

// **************************************************
// * Clicking
// **************************************************
/**
 * Handle onclick events.
 * The 2 click-able areas are:
 *  1) The front Open/Close list button.
 *  2) The back GoHome button.
 * @param {jQuery.Event} oEvent The event object
 * @private
 */
sap.ui.commons.MessageBar.prototype.onclick = function (oEvent) {
	var oSource = oEvent.target;
	var jSource = jQuery(oSource);

	// If cursor does not say click, then do not bother.
	if (jSource.css('cursor') != "pointer") {
		return;
	}

  // Now, checking were the click came from:
  if (jSource.hasClass("sapUiMsgBarToggle")) {
		this.toggleList();
  } else if (jSource.hasClass("sapUiMsgBarHome")) {
		this.backHome();
  } else {
	jQuery.sap.log.debug("Warning: MessageBar unsupported click on " + jSource.attr('className'));
  }
}

// #############################################################################
// Internal Utilities
// #############################################################################
/**
 * This utility checks what action the Toaster should execute next.
 * @private
 */;
sap.ui.commons.MessageBar.prototype.checkForToast = function() {
  // No more toast if Multiple Toasts has already been displayed:
  if (this.maxToastsReached) {
	return;
  }

  // Making sure there is some queued messages:
  if (this.aToasts==null || this.aToasts.length == 0) {
	return;
  }

  // Making sure the feature is active:
  var maxToasted = this.getMaxToasted();
  if (maxToasted == 0) {
	return;
  }

  // Do not toast during Drag&Drop. Do not distract the user!
  if (this.sDragMode) {
	return;
  }

  var nextToast = null;
  var anchorId = "";
  if (this.aToasts.length > this.getMaxToasted()) {
	// Having a null "nextToast" would indicate a "Multiple new messages..."
	// With "Multiple new messages...", no need to toast messages anymore,
	// so emptying the toasting queue:
	  this.aToasts = [];
	  this.maxToastsReached = true;
	// Do not wait for the previous toast to be done.
	// The Toast has to point towards our left open/close Arrow:
	anchorId = this.getId() + "__arrowImg";
  } else {
	// Do not put a new toast in if there is already one in:
	  if (!this.oToast.isIdle()) {
		return;
	  }
	// Retrieving the oldest queued message:
	nextToast = this.aToasts.splice(0, 1)[0];
	// The Toast has to point towards the icon of the same priority, e.g. "id_ErrorImg":
	anchorId = this.getId() + "__" + nextToast.getType() + "Img";
  }

  // Triggering a Toast:
  this.oToast.toast(nextToast, anchorId);
};

/**
 * This utility adds Toasts to the Toast Array, if not already
 * included within this Array.
 * Order is chronological, not by priority.
 * @private
 */
sap.ui.commons.MessageBar.prototype.addToasts = function(aMessages) {
  // Looping through the supplied messages:
	for (var i=0, len=aMessages.length; i<len; i++) {
	  var newMessage = aMessages[i];
	  var alreadyQueued = false;
	  // Making sure message is not already queued for Toast:
	  for (var j=this.aToasts.length; j>=0; j--) {
		if (newMessage == this.aToasts[j]) {
		  alreadyQueued = true;
		  break;
		}
	  }
	  // Adding the message to the Toast queue:
	  if (!alreadyQueued) {
		this.aToasts.push(newMessage);
	  }
  } // end supplied messages for-loop
};

/**
 * This utility removes a Toast from the Array of messages still
 * to be toasted.
 * @private
 */
sap.ui.commons.MessageBar.prototype.deleteToast = function(sId) {
  if (!this.aToasts) {
	return;
  }

  // Checking if within the Toast queue:
	for (var j=0, len=this.aToasts.length; j<len; j++) {
		if (this.aToasts[j].getId() == sId) {
			this.aToasts.splice(j, 1);
			return;
		}
	}
};

/**
 * This utility removes one message, given its ID, from the possible
 * message queues (Error, Warning, Success...).
 * Messages always have an ID, since created via the "Message" Control.
 * @private
 */
sap.ui.commons.MessageBar.prototype.deleteOneMessage = function(sId) {
  if (!sId) {
	return;
  }

  // Checking if within the Error queue:
	for (var j=0, len=this.aErrors.length; j<len; j++) {
		if (this.aErrors[j].getId() == sId) {
		  this.aErrors[j].closeDetails();
			this.aErrors.splice(j, 1);
			return;
		}
	}

  // Checking if within the Warning queue:
	for (var j=0, len=this.aWarnings.length; j<len; j++) {
		if (this.aWarnings[j].getId() == sId) {
		  this.aWarnings[j].closeDetails();
			this.aWarnings.splice(j, 1);
			return;
		}
	}

  // Checking if within the Success queue:
	for (var j=0, len=this.aSuccesses.length; j<len; j++) {
		if (this.aSuccesses[j].getId() == sId) {
		  this.aSuccesses[j].closeDetails();
			this.aSuccesses.splice(j, 1);
			return;
		}
	}
};

/**
 * This utility converts "Begin"/"End" into "Right"/"Left" coordinates,
 * for RTL support.
 * @private
 */
sap.ui.commons.MessageBar.prototype.getSnapPoint = function() {
  if (!this.snapPoint) {
	  this.snapPoint = this.getAnchorSnapPoint();
	  if (sap.ui.getCore().getConfiguration().getRTL()) {
		this.snapPoint = this.snapPoint.replace("begin", "right").replace("end", "left");
	  } else {
		this.snapPoint = this.snapPoint.replace("begin", "left").replace("end", "right");
	  }
  }
  return this.snapPoint;
};

/**
 * This utility opens the MessageBar Popup.
 * @private
 */
sap.ui.commons.MessageBar.prototype.open = function() {
	// Defining or fetching the Popup attributes:
  var animationDuration = 0;
  var snapPoint = this.getSnapPoint();

	// Opening the MessageBar:
  var anchor = null;
  var anchorId = this.getAnchorID();
  if (anchorId) {
	anchor = jQuery.sap.domById(anchorId);
  }
  if (!anchor) {
	anchor = document.body;
  }
  // Invoking the MsgBar Popup open function(iDuration, my, at, of, offset):
	this.oPopup.open(animationDuration, snapPoint, snapPoint, anchor, "0 0");

  // Repositioning as per the Drop position:
  if (this.oDropPosition) {
	  this.oPopup._$().css('top', this.oDropPosition.top);
		// Is the Bar to be positioned and dragged from its right-hand side???
		if (snapPoint.indexOf("right") != -1) {
			this.oPopup._$().css('right', this.oDropPosition.right);
		} else {
			this.oPopup._$().css('left', this.oDropPosition.left);
		}
  }

  // If closed with a list present, then we should still display it:
  if (this.hasStyleClass("sapUiMsgBarOpen")) {
	this.oList.setVisible(true);
  }
};

/**
 * This utility closes the MessageBar Popup.
 * @private
 */
sap.ui.commons.MessageBar.prototype.close = function() {
  // First closing the MessageList, if visible:
  if (this.oList && this.oList.getVisible()) {
	this.oList.setVisible(false);
  }

  // Invoking the MsgBar Popup close = function(iDuration):
  var animationDuration = 0;
	this.oPopup.close(animationDuration);

  // Re-initializing flag along with the turning-off of the MessageBar:
  this.maxToastsReached = false;
};

/**
 * This utility updates the messageBar counters, and visibility.
 * @private
 */
sap.ui.commons.MessageBar.prototype.updateCountersAndVisibility = function() {
  // If invisible, get out of here!
	if (!this.getProperty("visible")) {
		return;
	}

  // Convenience variable
	var id = this.getId();

  // Updating the Error Count and Visibility:
  var oCount = jQuery.sap.domById(id + "__ErrorCount");
  if (!oCount) {
	// The MessageBar has to be available on the DOM in order to update it!
	// This code is required as the MessageBar is first created.
	  this.open();
	oCount = jQuery.sap.domById(id + "__ErrorCount");
  }
  var count   = this.aErrors.length;
  var oldText = oCount.innerHTML;
  var newText = "(" + count + ")";
  var jIcon   = null;
  var jCount  = null;
  if (newText != oldText) {
	// Have to directly update the DOM element:
	oCount.innerHTML = newText;

	if (newText == "(0)") {
	  // Allowing empty queues not to be displayed:
	  jIcon  = jQuery.sap.byId(id + "__ErrorImg");
	  jCount = jQuery.sap.byId(id + "__ErrorCount");
	  jIcon.addClass("sapUiMsgBarZeroCount");
	  jCount.addClass("sapUiMsgBarZeroCount");
	} else if (oldText == "(0)") {
	  // Displaying the non-empty queue:
	  jIcon  = jQuery.sap.byId(id + "__ErrorImg");
	  jCount = jQuery.sap.byId(id + "__ErrorCount");
	  jIcon.removeClass("sapUiMsgBarZeroCount");
	  jCount.removeClass("sapUiMsgBarZeroCount");
	}
  }


  // Updating the Warning Count and Visibility:
  oCount  = jQuery.sap.domById(id + "__WarningCount");
  count   = this.aWarnings.length;
  oldText = oCount.innerHTML;
  newText = "(" + count + ")";
  jIcon   = null;
  jCount  = null;
  if (newText != oldText) {
	// Have to directly update the DOM element:
	oCount.innerHTML = newText;

	if (newText == "(0)") {
	  // Allowing empty queues not to be displayed:
	  jIcon  = jQuery.sap.byId(id + "__WarningImg");
	  jCount = jQuery.sap.byId(id + "__WarningCount");
	  jIcon.addClass("sapUiMsgBarZeroCount");
	  jCount.addClass("sapUiMsgBarZeroCount");
	} else if (oldText == "(0)") {
	  // Displaying the non-empty queue:
	  jIcon  = jQuery.sap.byId(id + "__WarningImg");
	  jCount = jQuery.sap.byId(id + "__WarningCount");
	  jIcon.removeClass("sapUiMsgBarZeroCount");
	  jCount.removeClass("sapUiMsgBarZeroCount");
	}
  }


  // Updating the Success Count and Visibility:
  oCount  = jQuery.sap.domById(id + "__SuccessCount");
  count   = this.aSuccesses.length;
  oldText = oCount.innerHTML;
  newText = "(" + count + ")";
  jIcon   = null;
  jCount  = null;
  if (newText != oldText) {
	// Have to directly update the DOM element:
	oCount.innerHTML = newText;

	if (newText == "(0)") {
	  // Allowing empty queues not to be displayed:
	  jIcon  = jQuery.sap.byId(id + "__SuccessImg");
	  jCount = jQuery.sap.byId(id + "__SuccessCount");
	  jIcon.addClass("sapUiMsgBarZeroCount");
	  jCount.addClass("sapUiMsgBarZeroCount");
	} else if (oldText == "(0)") {
	  // Displaying the non-empty queue:
	  jIcon  = jQuery.sap.byId(id + "__SuccessImg");
	  jCount = jQuery.sap.byId(id + "__SuccessCount");
	  jIcon.removeClass("sapUiMsgBarZeroCount");
	  jCount.removeClass("sapUiMsgBarZeroCount");
	}
  }


	// If the MessageBar is now empty, then it should become invisible:
	if (this.aErrors.length==0 &&
		this.aWarnings.length==0 &&
		this.aSuccesses.length==0) {
	  // Hiding the MessageBar:
	  this.close();
	  return;
	} else {
	  // Showing the MessageBar:
	  this.open();
	}

	// If the MessageList is already open, updating it:
	if (this.oList && this.oList.getVisible()) {
		this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));
	}

  // Checking for the next Toaster action:
	this.checkForToast();
};

/**
 * This utility toggles the MessageList Popup.
 * This function is invoked by clicking the front MessageBar Arrow.
 * @private
 */
sap.ui.commons.MessageBar.prototype.toggleList = function() {
  // Creating the List, if not already done:
  if (!this.oList) {
	var listId = this.getId() + "__List";
	  this.oList = new sap.ui.commons.MessageList(listId, {anchorId:this.getId(), maxListed:this.getMaxListed()});
  }

  // Retrieving the List current Open/Close information:
  var visible  = this.oList.getVisible();

  // Toggling the List, and adapting our styling:
  if (!visible) {
	this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));
	this.addStyleClass("sapUiMsgBarOpen");
  } else {
	this.removeStyleClass("sapUiMsgBarOpen");
  }
  this.oList.setVisible(!visible);
};

/**
 * This utility restores the initial position of the MessageBar.
 * @private
 */
sap.ui.commons.MessageBar.prototype.backHome = function() {
  // Instead of repositioning the List, we may as well just re-opening it once back home!
  // Just like when it is the user that is D&D the Bar!
  // This will also allow the List Popup to properly position itself (UP/DOWN).
//this.oPopup.setPosition(sap.ui.core.Popup.Dock.LeftTop, {left:this.oHomePosition.left + "px", top: this.oHomePosition.top + "px"});
  var jPopup = this.oPopup._$();
  if (this.oList && this.oList.getVisible()) {
	this.toggleList();
	var that = this;
		// Is the Bar to be positioned and dragged from its right-hand side???
		if (this.snapPoint.indexOf("right") != -1) {
			jPopup.animate({right:this.oHomePosition.right + "px", top:this.oHomePosition.top + "px"}, 200, function() {that.toggleList();});
		} else {
			jPopup.animate({left:this.oHomePosition.left + "px", top:this.oHomePosition.top + "px"}, 200, function() {that.toggleList();});
		}
  } else {
		// Is the Bar to be positioned and dragged from its right-hand side???
		if (this.snapPoint.indexOf("right") != -1) {
			jPopup.animate({right:this.oHomePosition.right + "px", top:this.oHomePosition.top + "px"}, 200);
		} else {
			jPopup.animate({left:this.oHomePosition.left + "px", top:this.oHomePosition.top + "px"}, 200);
		}
  }

  // MessageBar is back home:
  this.oDropPosition = null;
  // Hiding our "back-home" icon:
  this.removeStyleClass("sapUiMsgBarMoved");
};

// #############################################################################
// Public APIs
// #############################################################################
/**
 * This public API adds/updates a supplied list of messages.
 * The messageBar is to appear should at least one message exists.
 * @param {sap.ui.commons.Message[]} aMessages
 * @public
 */
sap.ui.commons.MessageBar.prototype.addMessages = function(aMessages) {
  if (!aMessages) {
	return;
  }

  // Looping through the supplied messages:
	for (var i=0, len=aMessages.length; i<len; i++) {
	// First have to removing each message from the message queues,
	// in case this is an update that we are doing!
	// This approach allows for messages to change priority,
	// and for "updated" messages to get re-ordered, i.e.
	// the most recent ones are displayed first (on a given priority
	// level).
	this.deleteOneMessage(aMessages[i].getId());

	// Now, inserting each message into its proper queue:
	  switch (aMessages[i].getType()){
		case sap.ui.commons.MessageType.Error:
		  // Adding the "new" Error message:
		this.aErrors.push(aMessages[i]);
		  break;

		case sap.ui.commons.MessageType.Warning:
		  // Adding the "new" Warning message:
		this.aWarnings.push(aMessages[i]);
		  break;

		case sap.ui.commons.MessageType.Success:
		  // Adding the "new" Success message:
		this.aSuccesses.push(aMessages[i]);
		  break;

		default:
		  jQuery.sap.log.debug("ERROR: MessageBar supplied messageType=" + aMessages[i].getType());
	  } // end switch
	} // end for

	// Adding the new messages to the toasting queue:
  this.addToasts(aMessages);

	// Updating the messageBar:
	this.updateCountersAndVisibility();

	return this;
};

/**
 * This public API deletes a supplied list of messages.
 * The messageBar is to disappear should no message remains.
 * @param {string[]} aIds
 * @public
 */
sap.ui.commons.MessageBar.prototype.deleteMessages = function(aIds) {
  if (!aIds) {
	return;
  }

  // Removing each message from their message queues, and toast queue:
	for (var i=0, len=aIds.length; i<len; i++) {
	this.deleteOneMessage(aIds[i]);
	this.deleteToast(aIds[i]);
	} // end for

	// Updating the messageBar:
	this.updateCountersAndVisibility();

	return this;
};

/**
 * This public API deletes all recorded messages.
 * The messageBar is to disappear.
 * @public
 */
sap.ui.commons.MessageBar.prototype.deleteAllMessages = function() {
  // Closing the corresponding Details if any:
	for (var j=this.aErrors.length-1; j>=0; j--) {
		this.aErrors[j].closeDetails();
	}
	for (var j=this.aWarnings.length-1; j>=0; j--) {
		this.aWarnings[j].closeDetails();
	}
	for (var j=this.aSuccesses.length-1; j>=0; j--) {
		this.aSuccesses[j].closeDetails();
	}

	// Empty all error queues:
  this.aErrors    = [];
  this.aWarnings  = [];
  this.aSuccesses = [];
  // Empty the Toasting queue:
  this.aToasts    = [];

	// Updating the messageBar:
	this.updateCountersAndVisibility();

	return this;
};



// #############################################################################
// Overwriting auto-generated methods of MessageBar.API.js
// #############################################################################

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code>
 *
 * The default implementation of function "setVisible()" is enhanced 
 * in order to toggle the "visibility:hidden;" attribute over the control.
 * 
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.MessageBar.prototype.setVisible = function(bVisible) {
	this.setProperty("visible", bVisible);

  if (bVisible) {
		// Updating and rendering the MessageBar:
		this.updateCountersAndVisibility();
  }
  else {
	// Just closing the MessageBar:
	  this.close();
  }

	return this;
};
}; // end of sap/ui/commons/MessageBar.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageList') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.MessageList.
jQuery.sap.declare("sap.ui.commons.MessageList");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new MessageList.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: false)</li>
 * <li>{@link #getAnchorId anchorId} : string</li>
 * <li>{@link #getMaxListed maxListed} : string (default: '7')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Instantiated by the "MessageBar" Control if the user ever requests to generate the corresponding "MessageList".
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.4.0. 
 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
 * @name sap.ui.commons.MessageList
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.MessageList", { metadata : {

	deprecated : true,
	publicMethods : [
		// methods
		"setMessages"
	],
	library : "sap.ui.commons",
	properties : {
		"visible" : {type : "boolean", group : "Behavior", defaultValue : false},
		"anchorId" : {type : "string", group : "Appearance", defaultValue : null},
		"maxListed" : {type : "string", group : "Misc", defaultValue : '7'}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.MessageList with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.MessageList.extend
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * To open or close the Control.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.MessageList#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.MessageList} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageList#setVisible
 * @function
 */


/**
 * Getter for property <code>anchorId</code>.
 * Id of the anchor under which the MessageList is to render.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>anchorId</code>
 * @public
 * @name sap.ui.commons.MessageList#getAnchorId
 * @function
 */

/**
 * Setter for property <code>anchorId</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAnchorId  new value for property <code>anchorId</code>
 * @return {sap.ui.commons.MessageList} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageList#setAnchorId
 * @function
 */


/**
 * Getter for property <code>maxListed</code>.
 * Maximum number of messages being display in the List before a scrollbar appears. Value '0' means no limit.
 *
 * Default value is <code>7</code>
 *
 * @return {string} the value of property <code>maxListed</code>
 * @public
 * @name sap.ui.commons.MessageList#getMaxListed
 * @function
 */

/**
 * Setter for property <code>maxListed</code>.
 *
 * Default value is <code>7</code> 
 *
 * @param {string} sMaxListed  new value for property <code>maxListed</code>
 * @return {sap.ui.commons.MessageList} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageList#setMaxListed
 * @function
 */


/**
 * Sets the message list to be displayed.
 *
 * @name sap.ui.commons.MessageList#setMessages
 * @function
 * @param {sap.ui.commons.Message[]} aMessages
 *         Message list.
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\MessageList.js
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained

///**
// * This file defines behavior for the control,
// */
sap.ui.commons.MessageList.prototype.init = function(){
	// Defining some private data:
	this.aMessages = [];
	this.iItemHeight = 0;

	// Popup(oContent, bModal, bShadow, bAutoClose) container initialization:
	// - bModal: "true/false" : For blocking the background window.
	this.oPopup   = new sap.ui.core.Popup(this, false, true, false);
};

/**
 * Destroys this Control instance, called by Element#destroy()
 * @private
 */
sap.ui.commons.MessageList.prototype.exit = function() {
  this.close();

	this.oPopup.destroy();
	this.oPopup = null;
};

/**
 * Re-initializes the measurements, so all sizes are recalculated after a theme switch.
 * @private
 */
sap.ui.commons.MessageList.prototype.onThemeChanged = function () {
	this.iItemHeight = 0;
};

/**
 * This utility checks to see if a scrollbar has to be rendered.
 */
sap.ui.commons.MessageList.prototype.onAfterRendering = function () {
	var oList = this.getDomRef();
	var jList = jQuery(oList);

  // A scrollbar is only required over 7 items:
  var maxVisibleItems = this.getMaxListed();
  var len = this.aMessages.length;
  if (len <= maxVisibleItems) {
	// By default, css height was set to "20px" to make sure List would fit, for Popup to open.
	jList.height("auto");
	return;
  }

	// Calculating 1 item height:
	if (this.iItemHeight == 0) {
		var oItem = oList.firstChild;
		var jItem = jQuery(oItem);
		this.iItemHeight = jItem.height();
	}

  oList.style.overflowY = "scroll";
  oList.style.overflowX = "hidden";
	var desiredHeight = (maxVisibleItems * this.iItemHeight) + "px";
	jList.height(desiredHeight);
};

// #############################################################################
// Internal Utilities
// #############################################################################
/**
 * This utility opens the MessageList Popup.
 */
sap.ui.commons.MessageList.prototype.open = function() {
  var rtl = sap.ui.getCore().getConfiguration().getRTL();

	// Defining or fetching the Popup attributes:
  var animationDuration = 200;
  var msgListSnapPoint = rtl ? sap.ui.core.Popup.Dock.RightTop    : sap.ui.core.Popup.Dock.LeftTop;
  var anchorSnapPoint  = rtl ? sap.ui.core.Popup.Dock.RightBottom : sap.ui.core.Popup.Dock.LeftBottom;
  var relativeAnchorPosition = "0 0";
  var anchor = null;
  var anchorId = this.getAnchorId();
  if (anchorId) {
	anchor = jQuery.sap.domById(anchorId);
  }
  if (!anchor) {
	anchor = document.body;
  }
  // Invoking the MsgBar Popup open function(iDuration, my, at, of, offset):
  this.oPopup.open(animationDuration, msgListSnapPoint, anchorSnapPoint, anchor, relativeAnchorPosition);
};

/**
 * This utility closes the MessageList Popup.
 */
sap.ui.commons.MessageList.prototype.close = function() {
  // Invoking the MsgBar Popup close = function(iDuration):
  var animationDuration = 200;
  this.oPopup.close(animationDuration);
};

/**
 * This public API receives the list of Messages to be displayed,
 * and re-render this Control if visible.
 */
sap.ui.commons.MessageList.prototype.setMessages = function(aMessages) {
  // Storing the Messages:
  this.aMessages = aMessages;

  // Re-rendering this MessageList if visible:
  if (this.getVisible()) {
	sap.ui.getCore().getRenderManager().render(this, sap.ui.getCore().getStaticAreaRef(), true);
  }

  return this;
};


// #############################################################################
// Overwriting auto-generated methods of MessageList.API.js
// #############################################################################

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code>
 *
 * The default implementation of function "setVisible()" is overwritten 
 * in order to invoke the open() and close() of the MessageList Popup.
 * 
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.MessageList.prototype.setVisible = function(bVisible) {
	this.setProperty("visible", bVisible);

  // Opening or closing the MessageBar, as requested:
  if (bVisible) {
	// Re-rendering, in case content is new.
	sap.ui.getCore().getRenderManager().render(this, sap.ui.getCore().getStaticAreaRef(), true);
		this.open();
  } else {
	  this.close();
  }

	return this;
};
}; // end of sap/ui/commons/MessageList.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageToast') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.MessageToast.
jQuery.sap.declare("sap.ui.commons.MessageToast");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new MessageToast.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getAnchorId anchorId} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.MessageToast#event:next next} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Responsible for displaying the new incoming messages, one at the time, on top of the MessageBar.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.4.0. 
 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
 * @name sap.ui.commons.MessageToast
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.MessageToast", { metadata : {

	deprecated : true,
	publicMethods : [
		// methods
		"toast", "isIdle"
	],
	library : "sap.ui.commons",
	properties : {
		"anchorId" : {type : "string", group : "Misc", defaultValue : null}
	},
	events : {
		"next" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.MessageToast with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.MessageToast.extend
 * @function
 */

sap.ui.commons.MessageToast.M_EVENTS = {'next':'next'};


/**
 * Getter for property <code>anchorId</code>.
 * Id of the anchor on top of which the MessageToast is to render.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>anchorId</code>
 * @public
 * @name sap.ui.commons.MessageToast#getAnchorId
 * @function
 */

/**
 * Setter for property <code>anchorId</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAnchorId  new value for property <code>anchorId</code>
 * @return {sap.ui.commons.MessageToast} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageToast#setAnchorId
 * @function
 */


/**
 * Fired once the "toast()" method is over, so that the MessageBar can toast() another message if needed.
 *
 * @name sap.ui.commons.MessageToast#next
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'next' event of this <code>sap.ui.commons.MessageToast</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.MessageToast</code>.<br/> itself. 
 *  
 * Fired once the "toast()" method is over, so that the MessageBar can toast() another message if needed.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.MessageToast</code>.<br/> itself.
 *
 * @return {sap.ui.commons.MessageToast} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageToast#attachNext
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'next' event of this <code>sap.ui.commons.MessageToast</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.MessageToast} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.MessageToast#detachNext
 * @function
 */

/**
 * Fire event next to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.MessageToast} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.MessageToast#fireNext
 * @function
 */


/**
 * Triggers the toasting of a message, on top of the MessageBar.
 * If no message is supplied, displayes the "Multiple new messages..." message.
 *
 * @name sap.ui.commons.MessageToast#toast
 * @function
 * @param {sap.ui.commons.Message} oMessage
 *         The Message to be toasted.
 * @param {string} sAnchorId
 *         DOM ID of the anchor against which the Toast Arrow should align for a given Toast.
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns TRUE if no message is being toasted.
 *
 * @name sap.ui.commons.MessageToast#isIdle
 * @function
 * @type boolean
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\MessageToast.js
jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-core'); // unlisted dependency retained


sap.ui.commons.MessageToast.prototype.init = function(){
	// Local variables...
	this.oMessage    = null;
	this.sAnchorId   = "";
	this.bIdle       = true;
	this.sLeftOffset = "";

	// Popup(oContent, bModal, bShadow, bAutoClose) container initialization:
	// - oModal: "true/false" : For blocking the background window.
	// - bShadow: "false" as the MessageBar Popup is displayed without shadow in all themes.
	//            Shadow is added but not at the Popup level because in contains a down-arrow.
	//            Therefore the shadow is added to an inner container, excluding this down-arrow.
	this.oPopup   = new sap.ui.core.Popup(this, false, false, false);
	// Asking the Popup to fire our "next" event once a "toast()" is over.
	this.oPopup.attachClosed(this.next, this);
};

/**
 * Destroys this Control instance, called by Element#destroy()
 * @private
 */
sap.ui.commons.MessageToast.prototype.exit = function() {
  if (!this.bIdle) {
	this.close();
  }

	this.oPopup.destroy();
	this.oPopup = null;
};

/**
 * This utility makes sure that the Toast is pointing down towards
 * the right MessageBar Icon.
 * @private
 */
sap.ui.commons.MessageToast.prototype.onAfterRendering = function(){
  // The MessageToast and the MessageBar are right-aligned.
  // The MessageToast has a minWidth matching that of the MessageBar.
  // (That allows us to position the down-arrow without moving the MessageToast.)
  // The MessageToast Arrow aligns towards the proper MessageBar Icon.

  var rtl = sap.ui.getCore().getConfiguration().getRTL();

  // 1) Calculating the distance between the Icon and the right side of its MessageBar container:
  var jIcon = jQuery.sap.byId(this.sAnchorId); // Anchor against which our Arrow has to align
//if (!jIcon) return;
  var iconPosition  = jIcon.position();
  var jBar = jQuery.sap.byId(this.getAnchorId()); // Anchor against which our Toast has to align
//if (!jBar) return;
  var barWidth = jBar.outerWidth();
  if (iconPosition) {
	  var targetRightOffset = rtl ? iconPosition.left + jIcon.outerWidth()
								  : barWidth - iconPosition.left;


	  // 2) Calculating the default distance between the Arrow and the right side of our Toast:
		var jToast = this.$();  // = jQuery.sap.byId(this.getId());
	  var toastWidth = jToast.width();
	  var defaultArrowRightOffset = Math.max(toastWidth,barWidth);

	  // 3) Taking care of too-small a Toast:
	  var delta = barWidth - toastWidth;
		if (delta > 0) {
		// Making the Toast as wide as the Bar:
		jToast.css('minWidth', barWidth);
		}

	  // 4) Now, we need to move our Arrow right, by what is missing:
	  var moveRightOffset = rtl ? (defaultArrowRightOffset - targetRightOffset + 2) + "px"
								: (defaultArrowRightOffset - targetRightOffset - 2) + "px";
		if (defaultArrowRightOffset >= targetRightOffset) {
		var jArrow = jQuery.sap.byId(this.getId() + "Arrow");
		if (sap.ui.getCore().getConfiguration().getRTL()) {
			jArrow.css('marginRight', moveRightOffset); // Positive padding
		} else {
			jArrow.css('marginLeft', moveRightOffset); // Positive padding
		}
		// Our right-alignment can stay:
		this.sLeftOffset = "0";
		}
	}
};

// #############################################################################
// Internal Utilities
// #############################################################################
/**
 * Our popup-close callback function.
 * Registers the fact that a toast just completed, and fires our "next" event.
 * @private
 */
sap.ui.commons.MessageToast.prototype.next = function(){
	// Toast done (allows for smooth toasting):
  this.bIdle = true;
  this.fireNext()
}

/**
 * This utility opens the MessageToast Popup.
 * @private
 */;
sap.ui.commons.MessageToast.prototype.open = function(iDuration) {
	// For Multiple Messages, 1st we need to close the existing toast:
  if (!this.bIdle) {
	this.oPopup.close(0);
  }

	// Toast start (allows for no interruption):
  this.bIdle = false;

  var rtl = sap.ui.getCore().getConfiguration().getRTL();

	// Defining or fetching the Popup attributes:
  var popupSnapPoint  = rtl ? sap.ui.core.Popup.Dock.LeftBottom : sap.ui.core.Popup.Dock.RightBottom;
  var anchorSnapPoint = rtl ? sap.ui.core.Popup.Dock.LeftTop    : sap.ui.core.Popup.Dock.RightTop;
  var relativeAnchorPosition = this.sLeftOffset + " 5";
  var anchor = null;
  var anchorId = this.getAnchorId();
  if (anchorId) {
	anchor = jQuery.sap.domById(anchorId);
  }
  if (!anchor) {
	anchor = document.body;
  }
  // Invoking the MsgBar Popup open function(iDuration, my, at, of, offset):
  this.oPopup.open(iDuration, popupSnapPoint, anchorSnapPoint, anchor, relativeAnchorPosition);
};

/**
 * This utility closes the MessageToast Popup.
 * @private
 */
sap.ui.commons.MessageToast.prototype.close = function(iDuration) {
  // Invoking the Popup close = function(iDuration):
  this.oPopup.close(iDuration);
};

/**
 * This utility returns the class of the MessageToast container,
 * which changes according to the displayed message TYPE/PRIORITY
 * to allow for "semantic" rendering.  :-)
 * @private
 */
sap.ui.commons.MessageToast.prototype.getClasses = function() {
  // By default assuming the "Multiple new messages..." css:
  var css = "sapUiMsgToast";
  // Allow for specializing as per the message Type:
  if (this.oMessage && this.oMessage.getType()) {
	css += " sapUiMsgT" + this.oMessage.getType();
  }
  return css;
};

// #############################################################################
// Public APIs
// #############################################################################
/**
 * This public API receives the list of Messages to be displayed,
 * and re-render this Control if visible.
 * @param {object} oMessage
 * @param {string} sAnchorId
 * @public
 */
sap.ui.commons.MessageToast.prototype.toast = function(oMessage, sAnchorId) {
  // Storing the supplied data:
	this.oMessage = oMessage;
	this.sAnchorId = sAnchorId;
  // Render according to new message, and animate:
	sap.ui.getCore().getRenderManager().render(this, sap.ui.getCore().getStaticAreaRef(), true);
  this.open(750);
  this.close(2250); // <-- CAN BE COMMENTED OUT WHILE STYLING THE TOAST...

	return this;
};

/**
 * Returns the idle state of the control.
 * @public
 */
sap.ui.commons.MessageToast.prototype.isIdle = function() {
  return this.bIdle;
};
}; // end of sap/ui/commons/MessageToast.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Paginator') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Paginator.
jQuery.sap.declare("sap.ui.commons.Paginator");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Paginator.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getCurrentPage currentPage} : int (default: 1)</li>
 * <li>{@link #getNumberOfPages numberOfPages} : int</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.Paginator#event:page page} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Provides navigation between pages within a list of numbered pages.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Paginator
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Paginator", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"currentPage" : {type : "int", group : "Misc", defaultValue : 1},
		"numberOfPages" : {type : "int", group : "Misc", defaultValue : null}
	},
	events : {
		"page" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Paginator with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Paginator.extend
 * @function
 */

sap.ui.commons.Paginator.M_EVENTS = {'page':'page'};


/**
 * Getter for property <code>currentPage</code>.
 * Represents the current page (first page has index 1, not 0, to match the visual number)
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>currentPage</code>
 * @public
 * @name sap.ui.commons.Paginator#getCurrentPage
 * @function
 */

/**
 * Setter for property <code>currentPage</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iCurrentPage  new value for property <code>currentPage</code>
 * @return {sap.ui.commons.Paginator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Paginator#setCurrentPage
 * @function
 */


/**
 * Getter for property <code>numberOfPages</code>.
 * Represents the overall number of pages that are embedded into the parent control
 *
 * Default value is <code></code>
 *
 * @return {int} the value of property <code>numberOfPages</code>
 * @public
 * @name sap.ui.commons.Paginator#getNumberOfPages
 * @function
 */

/**
 * Setter for property <code>numberOfPages</code>.
 *
 * Default value is <code></code> 
 *
 * @param {int} iNumberOfPages  new value for property <code>numberOfPages</code>
 * @return {sap.ui.commons.Paginator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Paginator#setNumberOfPages
 * @function
 */


/**
 * Event is fired when the user navigates to another page by selecting it directly, or by jumping forward/backward.
 *
 * @name sap.ui.commons.Paginator#page
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.srcPage The page which is the current one before the page event is fired (and another page is displayed)
 * @param {int} oControlEvent.getParameters.targetPage The page that shall be displayed next after the page event is fired.
 * 
 *         The page number is 1-based: the first page has index 1, not 0, to match the number visible in the UI.
 * @param {sap.ui.commons.PaginatorEvent} oControlEvent.getParameters.type Provides the values 'First', 'Last', 'Next', 'Previous', 'Goto'. The event parameter informs the application
 *         how the user navigated to the new page: Whether the 'Next' button was used, or another button, or whether the page was directly
 *         selected
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'page' event of this <code>sap.ui.commons.Paginator</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.Paginator</code>.<br/> itself. 
 *  
 * Event is fired when the user navigates to another page by selecting it directly, or by jumping forward/backward.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.Paginator</code>.<br/> itself.
 *
 * @return {sap.ui.commons.Paginator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Paginator#attachPage
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'page' event of this <code>sap.ui.commons.Paginator</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.Paginator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Paginator#detachPage
 * @function
 */

/**
 * Fire event page to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'srcPage' of type <code>int</code> The page which is the current one before the page event is fired (and another page is displayed)</li>
 * <li>'targetPage' of type <code>int</code> The page that shall be displayed next after the page event is fired.

The page number is 1-based: the first page has index 1, not 0, to match the number visible in the UI.</li>
 * <li>'type' of type <code>sap.ui.commons.PaginatorEvent</code> Provides the values 'First', 'Last', 'Next', 'Previous', 'Goto'. The event parameter informs the application 
					how the user navigated to the new page: Whether the 'Next' button was used, or another button, or whether the page was directly 
					selected</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.Paginator} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.Paginator#firePage
 * @function
 */


// Start of sap\ui\commons\Paginator.js
/*
 * All animations of the Paginator control can be centrally switched
 * off by setting the <code>bShowAnimation</code> flag to <code>false</code>.
 * @private
 */

// Constants declaration
sap.ui.commons.Paginator.MAX_NUMBER_PAGES = 5;

/**
 * Init function
 * @private
 */
sap.ui.commons.Paginator.prototype.init = function(){
	//Animations are set to true by default, then on control initialization, check the number of pages
	this.bShowAnimation = true;
};


/**
 * When the user clicks on a page link, we navigae to that page, either with animation or with rerendering
 * @param {jQuery.Event} oEvent The current event
 * @private
 */
sap.ui.commons.Paginator.prototype.onclick = function(oEvent){
	if (oEvent && oEvent.target) {

		// Supress triggering beforeunload in IE
		oEvent.preventDefault();

		// go up one node if unnamed element is the source
		var target = oEvent.target;
		if (!target.id) {
			target = target.parentNode;
		}

		if (target.id && target.id != this.getId() + "-pages") {

			// Retrieve from where the event originated
			var aArray = target.id.split("--");

			// only do something if relevant item has been clicked
			if (aArray.length > 1) {
				var lastPart = aArray[aArray.length - 1];

				// What type of event will be sent
				var sEventType = null;

				// Buffer the current page as the sourcePage
				var iSrcPage = this.getCurrentPage();
				var iTargetPage = iSrcPage; // will be changed below

				// we have a number - a page has been clicked
				if (lastPart.match(/^\d+$/)) {
					sEventType = sap.ui.commons.PaginatorEvent.Goto;
					iTargetPage = parseInt(lastPart, 10);

				} else if (lastPart == "firstPageLink") {
					sEventType = sap.ui.commons.PaginatorEvent.First;
					iTargetPage = 1;

				} else if (lastPart == "backLink") {
					sEventType = sap.ui.commons.PaginatorEvent.Previous;
					iTargetPage = Math.max(iSrcPage-1, 1);

				} else if (lastPart == "forwardLink") {
					sEventType = sap.ui.commons.PaginatorEvent.Next;
					iTargetPage = Math.min(iSrcPage+1, this.getNumberOfPages());

				} else if (lastPart == "lastPageLink") {
					sEventType = sap.ui.commons.PaginatorEvent.Last;
					iTargetPage = this.getNumberOfPages();

				} else {
					// TODO: should not happen
				}

				if (iTargetPage != iSrcPage) {
					if (this.bShowAnimation){
						this.setCurrentPage(iTargetPage, true); // update current page without re-rendering...
						this.triggerPaginatorAnimation(); // ...and animate
					} else {
						this.setCurrentPage(iTargetPage); // includes re-rendering
					}

					// fire the "page" event
					this.firePage({srcPage:iSrcPage,targetPage:iTargetPage,type:sEventType});
				}
			}
		}
	}
};

sap.ui.commons.Paginator.prototype.setCurrentPage = function(iTargetPage, bSuppressRerendering) {
	this.setProperty("currentPage", iTargetPage, bSuppressRerendering);
	if (this.getDomRef()) {
		sap.ui.commons.PaginatorRenderer.updateBackAndForward(this);
	}
};

/**
 * When animation is set to true, this function will use jQuery to animate the paginator
 * as if the page numbers were sliding left/right.
 * @private
 */
sap.ui.commons.Paginator.prototype.triggerPaginatorAnimation = function() {
	var aIndicesToHide = [];
	var aIndicesToShow = [];
	var paginatorId = this.getId();
	var aChildren = jQuery.sap.byId(paginatorId + "-pages").children();

	// Get the ranges we need to display before and after the animation
	var oNewRange = this._calculatePagesRange();
	var oOldRange;
	if (this._oOldRange) {
		oOldRange = this._oOldRange;
	} else {
		oOldRange = {};
		var aParts = aChildren[0].id.split("--");
		oOldRange.firstPage = parseInt(aParts[aParts.length-1], 10);
		aParts = aChildren[aChildren.length-1].id.split("--");
		oOldRange.lastPage = parseInt(aParts[aParts.length-1], 10);
	}

	// the pages to be shown only after the animation are those to be rendered invisible, initially
	for (var i = oNewRange.firstPage; i <= oNewRange.lastPage; i++) {
		if (i < oOldRange.firstPage || i > oOldRange.lastPage) {
			aIndicesToShow.push(i);
		}
	}
	var oInvisibleRange = {
			firstPage:aIndicesToShow[0],
			lastPage:aIndicesToShow[aIndicesToShow.length-1]
	};

	// the pages to be shown initially, but NOT after the animation, are those to fade out
	for (var i = oOldRange.firstPage; i <= oOldRange.lastPage; i++) {
		if (i < oNewRange.firstPage || i > oNewRange.lastPage) {
			aIndicesToHide.push(i);
		}
	}

	// build the html for both the initially visible and still invisible pages
	var oldHtml = sap.ui.commons.PaginatorRenderer.getPagesHtml(this.getId(), oOldRange, this.getCurrentPage(), true);
	var newHtml = sap.ui.commons.PaginatorRenderer.getPagesHtml(this.getId(), oInvisibleRange, this.getCurrentPage(), false);
	if (oOldRange.firstPage < oInvisibleRange.firstPage) {
		newHtml = oldHtml + newHtml;
	} else {
		newHtml = newHtml + oldHtml;
	}
	
	
	// remember focus
	var focElem = document.activeElement;
	var focId = focElem ? focElem.id : undefined; // remember ID of focused element - it should still be focused after rendering
	
	this.getDomRef("pages").innerHTML = newHtml;
	
	// restore focus
	if (focId) {
		// Set focus on the previously focused element.
		// jQuery does not like document.activeElement, so we have to fetch it
		// from the DOM again.
		focElem = jQuery.sap.domById(focId);
	} else {
		// Set focus to active page link if no other element was active before
		focElem = jQuery.sap.domById("testPaginator-a--" + this.getCurrentPage());
	}

	jQuery.sap.focus(focElem);
	
	
	// Use jQuery hide/show to animate the paging
	var prefix = this.getId() + "-li--";

	this._oOldRange = oNewRange;
	for (var i=0 ; i<aIndicesToHide.length; i++) {
		var id = prefix + aIndicesToHide[i];
		jQuery.sap.byId(id).hide(400, function(){ // remove the DOM elements after the animation
			var id = this.id;
			var elem = jQuery.sap.domById(id);
			if (elem) {
				elem.parentNode.removeChild(elem);
			}
		});
	}

	for (var i=0 ; i<aIndicesToShow.length; i++) {
		jQuery.sap.byId(prefix + aIndicesToShow[i]).show(400);
	}
};


/**
 * Calculates what is the first page and last page to display (The current range).
 * Ensure that when we go over 5 pages, the current page will always be rendered centered
 * In this case, middle -2 and middle + 2 to get to full 5 pages range
 * @return {object} oPageRange object containing first page and last page to display
 * @private
 */
sap.ui.commons.Paginator.prototype._calculatePagesRange = function(){

	//Setting default values
	var iFirstPage = 1;
	var iLastPage = this.getNumberOfPages();
	var iCurrentPage = this.getCurrentPage();
	var iNbPages = this.getNumberOfPages();

	//From page 1 to page 5, we display 1 to 10 or less
	if ( iCurrentPage < 4 ){

		iFirstPage = 1;

		//Check if last page does not go over 5 --> iLastPage is already set with nbPages above
		if(iLastPage > sap.ui.commons.Paginator.MAX_NUMBER_PAGES){
			iLastPage = sap.ui.commons.Paginator.MAX_NUMBER_PAGES;
		}

	}
	//Now, the current page is more than 3, so we need to shift the range
	else{

		//Reached the last page
		if (iCurrentPage == iLastPage){
			//How many pages exist, if less than 5, simply substract the nb of pages from the last one (range is in this case 1 to max 5)
			if (iNbPages < 5){
				iFirstPage = 1;
			}
			//More than 5 pages, substract 4 pages to have the 5 pages range
			else{
				iFirstPage = iLastPage - 4;
			}
		}

		//Last page - current page is below 3, substract 4 to always see the right range for the last 2 pages
		else if ( iLastPage-iCurrentPage < 3 ){
			iFirstPage = iLastPage - 4;
		}

		//All other case, create the range from the current page +-2
		else{
			iFirstPage = iCurrentPage - 2;
			iLastPage = iCurrentPage + 2;
		}
	}

	return { firstPage : iFirstPage, lastPage : iLastPage };
};


/**
 * @param {jQuery.Event} oEvent the browser event
 * @private
 */
sap.ui.commons.Paginator.prototype.onkeydown = function(oEvent){

	//Get the event type and dispatch to the keyboard navigation manager
	var aEvents = oEvent.getPseudoTypes();

	//Tab
	if (jQuery.inArray("saptabnext", aEvents) != -1) {
		this.triggerTabbingNavigation(oEvent,false);
	}
	//Shift/tab
	else if (jQuery.inArray("saptabprevious", aEvents) != -1) {
		this.triggerTabbingNavigation(oEvent,true);
	}
	//Moves focus to the right (Right arrow key)
	else if (jQuery.inArray("sapincrease", aEvents) != -1 ){
		this.triggerInternalNavigation(oEvent,"next");
	}
	//Moves focus to the left (Left arrow key)
	else if (jQuery.inArray("sapdecrease", aEvents) != -1 ){
		this.triggerInternalNavigation(oEvent,"previous");
	}

};


/**
 * This function will navigate left and right in the paginator, skipping non tabbable elements
 * @param {jQuery.Event} oEvent the browser event
 * @param {string} sDirection Navigation left or right
 * @private
 */
sap.ui.commons.Paginator.prototype.triggerInternalNavigation = function(oEvent,sDirection){

	var aFocusableElements = jQuery(this.getDomRef()).find(":sapFocusable");
	var iCurrentIndex = jQuery(aFocusableElements).index(oEvent.target);

	//Right key pressed
	if (sDirection == "next"){
		var iNextIndex = iCurrentIndex + 1;
		if (jQuery(oEvent.target).hasClass("sapUiPagCurrentPage")){
			iNextIndex = iNextIndex + 1;
		}
		var oNextElement = aFocusableElements[iNextIndex];
		if (oNextElement){
			jQuery(oNextElement).focus();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	}
	//Left key pressed
	else if(sDirection == "previous" && aFocusableElements[iCurrentIndex-1]){
		var iNextIndex = iCurrentIndex - 1;
		var oNextElement = aFocusableElements[iNextIndex];
		if (oNextElement && jQuery(oNextElement).hasClass("sapUiPagCurrentPage")){
			oNextElement = aFocusableElements[iNextIndex - 1];
		}
		if (oNextElement){
			jQuery(oNextElement).focus();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	}

};

/**
 * This function will handle the TAB key in the paginator (simple group)
 * @param {jQuery.Event} oEvent the browser event
 * @param {boolean} shiftKeyPressed Tabbing or shift-Tabbing
 * @private
 */
sap.ui.commons.Paginator.prototype.triggerTabbingNavigation = function(oEvent,shiftKeyPressed){

	//Get all focusable elements
	var aFocusableElements = jQuery(this.getDomRef()).find(":sapFocusable");

	//Tabbing --> Focus the last active element then let the browser focus the next active element
	if (!shiftKeyPressed){
		jQuery(aFocusableElements[aFocusableElements.length-1]).focus();
	}
	//Shift/Tab keys pressed --> Focus the 2nd active element then let the browser focus the first active element
	else{

		//Which element triggered the event
		var iCurrentIndex = jQuery(aFocusableElements).index(oEvent.target);

		//If the focus is already on the first active element, let the browser move the focus
		if (iCurrentIndex != 0){
			jQuery(aFocusableElements[0]).focus();
		}
	}
};

sap.ui.commons.Paginator.prototype.getFocusInfo = function() {
	var sId = this.$().find(":focus").attr("id");
	if (sId) {
		return {customId: sId};
	} else {
		return sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
	}
};

sap.ui.commons.Paginator.prototype.applyFocusInfo = function(mFocusInfo) {
	if (mFocusInfo && mFocusInfo.customId) {
		this.$().find("#" + mFocusInfo.customId).focus();
	} else {
		sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
	}
	return this;
};



}; // end of sap/ui/commons/Paginator.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Panel') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.Panel.
jQuery.sap.declare("sap.ui.commons.Panel");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Panel.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getScrollLeft scrollLeft} : int (default: 0)</li>
 * <li>{@link #getScrollTop scrollTop} : int (default: 0)</li>
 * <li>{@link #getApplyContentPadding applyContentPadding} : boolean (default: true)</li>
 * <li>{@link #getCollapsed collapsed} : boolean (default: false)</li>
 * <li>{@link #getAreaDesign areaDesign} : sap.ui.commons.enums.AreaDesign (default: sap.ui.commons.enums.AreaDesign.Fill)</li>
 * <li>{@link #getBorderDesign borderDesign} : sap.ui.commons.enums.BorderDesign (default: sap.ui.commons.enums.BorderDesign.Box)</li>
 * <li>{@link #getShowCollapseIcon showCollapseIcon} : boolean (default: true)</li>
 * <li>{@link #getText text} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getTitle title} : sap.ui.core.Title</li>
 * <li>{@link #getButtons buttons} : sap.ui.commons.Button[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Represents a container with scroll functionality, the control can be used for text and controls. The Panel does not layout the embedded controls.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.Panel
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.Panel", { metadata : {

	publicMethods : [
		// methods
		"setDimensions"
	],
	library : "sap.ui.commons",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
		"height" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"scrollLeft" : {type : "int", group : "Behavior", defaultValue : 0},
		"scrollTop" : {type : "int", group : "Behavior", defaultValue : 0},
		"applyContentPadding" : {type : "boolean", group : "Appearance", defaultValue : true},
		"collapsed" : {type : "boolean", group : "Behavior", defaultValue : false},
		"areaDesign" : {type : "sap.ui.commons.enums.AreaDesign", group : "Appearance", defaultValue : sap.ui.commons.enums.AreaDesign.Fill},
		"borderDesign" : {type : "sap.ui.commons.enums.BorderDesign", group : "Appearance", defaultValue : sap.ui.commons.enums.BorderDesign.Box},
		"showCollapseIcon" : {type : "boolean", group : "Behavior", defaultValue : true},
		"text" : {type : "string", group : "Misc", defaultValue : null}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
		"title" : {type : "sap.ui.core.Title", multiple : false}, 
		"buttons" : {type : "sap.ui.commons.Button", multiple : true, singularName : "button"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.Panel with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.Panel.extend
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Panel width in CSS size
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.Panel#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setWidth
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * Per default, the height for the Panel is automatically adjusted to the content. Dimension allows to explicitly specify the height.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.ui.commons.Panel#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setHeight
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Represents the state of the of the Panel (enabled or disabled)
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.Panel#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible Panels are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.Panel#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setVisible
 * @function
 */


/**
 * Getter for property <code>scrollLeft</code>.
 * Specifies the scroll position from left to right. Value "0" means leftmost position.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>scrollLeft</code>
 * @public
 * @name sap.ui.commons.Panel#getScrollLeft
 * @function
 */

/**
 * Setter for property <code>scrollLeft</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iScrollLeft  new value for property <code>scrollLeft</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setScrollLeft
 * @function
 */


/**
 * Getter for property <code>scrollTop</code>.
 * Specifies the scroll position from top to bottom. Value "0" means topmost position.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>scrollTop</code>
 * @public
 * @name sap.ui.commons.Panel#getScrollTop
 * @function
 */

/**
 * Setter for property <code>scrollTop</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iScrollTop  new value for property <code>scrollTop</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setScrollTop
 * @function
 */


/**
 * Getter for property <code>applyContentPadding</code>.
 * Padding is theme-dependent.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>applyContentPadding</code>
 * @public
 * @name sap.ui.commons.Panel#getApplyContentPadding
 * @function
 */

/**
 * Setter for property <code>applyContentPadding</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bApplyContentPadding  new value for property <code>applyContentPadding</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setApplyContentPadding
 * @function
 */


/**
 * Getter for property <code>collapsed</code>.
 * A collapsed Panel consumes less space than a not collapsed one. When it is initially collapsed, the contents are not rendered.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>collapsed</code>
 * @public
 * @name sap.ui.commons.Panel#getCollapsed
 * @function
 */

/**
 * Setter for property <code>collapsed</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bCollapsed  new value for property <code>collapsed</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setCollapsed
 * @function
 */


/**
 * Getter for property <code>areaDesign</code>.
 * Defines the background color. Note that color settings are theme-dependent.
 *
 * Default value is <code>Fill</code>
 *
 * @return {sap.ui.commons.enums.AreaDesign} the value of property <code>areaDesign</code>
 * @public
 * @name sap.ui.commons.Panel#getAreaDesign
 * @function
 */

/**
 * Setter for property <code>areaDesign</code>.
 *
 * Default value is <code>Fill</code> 
 *
 * @param {sap.ui.commons.enums.AreaDesign} oAreaDesign  new value for property <code>areaDesign</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setAreaDesign
 * @function
 */


/**
 * Getter for property <code>borderDesign</code>.
 * The Panel can have a box as border. Note that displaying borders is theme-dependent.
 *
 * Default value is <code>Box</code>
 *
 * @return {sap.ui.commons.enums.BorderDesign} the value of property <code>borderDesign</code>
 * @public
 * @name sap.ui.commons.Panel#getBorderDesign
 * @function
 */

/**
 * Setter for property <code>borderDesign</code>.
 *
 * Default value is <code>Box</code> 
 *
 * @param {sap.ui.commons.enums.BorderDesign} oBorderDesign  new value for property <code>borderDesign</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setBorderDesign
 * @function
 */


/**
 * Getter for property <code>showCollapseIcon</code>.
 * Specifies whether the Panel shall have an icon for collapsing/expanding, or not.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showCollapseIcon</code>
 * @public
 * @name sap.ui.commons.Panel#getShowCollapseIcon
 * @function
 */

/**
 * Setter for property <code>showCollapseIcon</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowCollapseIcon  new value for property <code>showCollapseIcon</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setShowCollapseIcon
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * Can be used to create a simple title text for Panels that do not require an icon in the header.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.commons.Panel#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setText
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Aggregates the controls that are contained in the Panel. It is recommended to use a layout control as single direct child.
 * When the Panel dimensions are set, the child control may have width and height of 100%. When the dimensions are not set, the child defines
 * the Panel size.
 * 
 * <strong>Note</strong>: this is the default aggregation for Panel.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.commons.Panel#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.commons.Panel#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Panel#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.Panel#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>title</code>.<br/>
 * Aggregates the title element of the Panel. For text titles only, you alternatively could use setText() which also creates a title in the background.
 * 
 * @return {sap.ui.core.Title}
 * @public
 * @name sap.ui.commons.Panel#getTitle
 * @function
 */


/**
 * Setter for the aggregated <code>title</code>.
 * @param {sap.ui.core.Title} oTitle
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#setTitle
 * @function
 */
	

/**
 * Destroys the title in the aggregation 
 * named <code>title</code>.
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#destroyTitle
 * @function
 */


/**
 * Getter for aggregation <code>buttons</code>.<br/>
 * The buttons that shall be displayed in the Panel header
 * 
 * @return {sap.ui.commons.Button[]}
 * @public
 * @name sap.ui.commons.Panel#getButtons
 * @function
 */


/**
 * Inserts a button into the aggregation named <code>buttons</code>.
 *
 * @param {sap.ui.commons.Button}
 *          oButton the button to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the button should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the button is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the button is inserted at 
 *             the last position        
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#insertButton
 * @function
 */

/**
 * Adds some button <code>oButton</code> 
 * to the aggregation named <code>buttons</code>.
 *
 * @param {sap.ui.commons.Button}
 *            oButton the button to add; if empty, nothing is inserted
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#addButton
 * @function
 */

/**
 * Removes an button from the aggregation named <code>buttons</code>.
 *
 * @param {int | string | sap.ui.commons.Button} vButton the button to remove or its index or id
 * @return {sap.ui.commons.Button} the removed button or null
 * @public
 * @name sap.ui.commons.Panel#removeButton
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>buttons</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.commons.Button[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.Panel#removeAllButtons
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.commons.Button</code> in the aggregation named <code>buttons</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.commons.Button}
 *            oButton the button whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.Panel#indexOfButton
 * @function
 */
	

/**
 * Destroys all the buttons in the aggregation 
 * named <code>buttons</code>.
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.Panel#destroyButtons
 * @function
 */


/**
 * Property for width and height settings for the Panel
 *
 * @name sap.ui.commons.Panel#setDimensions
 * @function
 * @param {sap.ui.core.CSSSize} sWidth
 * 
 *         Panel width as CSS size
 * @param {sap.ui.core.CSSSize} sHeight
 * 
 *         Panel height as CSS size
 * @type sap.ui.commons.Panel
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\Panel.js
/**
 * Initialization
 * @private
 */
sap.ui.commons.Panel.prototype.init = function() {
	this._oScrollDomRef = null;       // points to the content area
	this._iMaxTbBtnWidth = -1;        // the maximum width of all toolbar buttons (when there are any, else -1)
	this._iTbMarginsAndBorders = 0;
	this._iMinTitleWidth = 30;        // the minimum width of the title span
	this._iOptTitleWidth = 30;
	this._iTitleMargin = 0;
	this._bFocusCollapseIcon = false; // indicates whether the collapse icon should be focused after the next rendering
	this._resizeDelayTimer = null;    // the timer for delayed reaction to resize events in browsers not supporting FlexBox layout
	this._rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
};

sap.ui.commons.Panel.prototype.exit = function() {
	this._rb = undefined;
};

/**
 * Called after the theme has been switched: adjust sizes
 * @private
 */
sap.ui.commons.Panel.prototype.onThemeChanged = function () {
	if (this.getDomRef() && this._oTitleDomRef) { // only if already rendered and if a real Panel (no subclass like Tab)

		// reset size settings done for previous theme, so elements take their optimum space
		this.getDomRef().style.minWidth = "auto";
		if (this._oToolbarDomRef) {
			this._oToolbarDomRef.style.width = "auto";
		}
		this._oTitleDomRef.style.width = "auto";

		// adapt sizes
		this._initializeSizes(); // TODO: delay this for Safari?
		if (!jQuery.support.flexBoxLayout ||
				(sap.ui.commons.Panel._isSizeSet(this.getHeight()) && (this._hasIcon() || (this.getButtons().length > 0)))) {
			this._handleResizeNow();
		}
	}
};


/**
 * Event unbinding
 * @private
 */
sap.ui.commons.Panel.prototype.onBeforeRendering = function() {
	// Deregister resize event before re-rendering
	if(this.sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);
		this.sResizeListenerId = null;
	}
};


/**
 * Adapts size settings of the rendered HTML
 * @private
 */
sap.ui.commons.Panel.prototype.onAfterRendering = function () {
	var id = this.getId();
	this._oScrollDomRef = jQuery.sap.domById(id + "-cont");
	if (!this._oScrollDomRef) {
		return;
	} // BugFix for TwoGo where the DomRefs were not there after rendering
	this._oHeaderDomRef = jQuery.sap.domById(id + "-hdr");
	this._oTitleDomRef = jQuery.sap.domById(id + "-title");
	this._oToolbarDomRef = jQuery.sap.domById(id + "-tb");

	// restore focus if required
	if (this._bFocusCollapseIcon) {
		this._bFocusCollapseIcon = false;
		var $collArrow = jQuery.sap.byId(id + "-collArrow");
		if($collArrow.is(":visible") && ($collArrow.css("visibility") == "visible" || $collArrow.css("visibility") == "inherit")) {
			$collArrow.focus();
		} else {
			var $collIco = jQuery.sap.byId(id + "-collIco");
			if ($collIco.is(":visible") && ($collIco.css("visibility") == "visible" || $collIco.css("visibility") == "inherit")) {
				$collIco.focus();
			}
		}
	}

	this._initializeSizes(); // TODO: delay this for Safari?

	// in browsers not supporting the FlexBoxLayout we need to listen to resizing
	if (!jQuery.support.flexBoxLayout ||
			(sap.ui.commons.Panel._isSizeSet(this.getHeight()) && (this._hasIcon() || (this.getButtons().length > 0)))) {
		this._handleResizeNow();
		this.sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(), jQuery.proxy(this._handleResizeSoon, this));
	}
};


/**
 *
 * @protected
 */
sap.ui.commons.Panel.prototype.getFocusInfo = function () {
	var collId = null;
	var id = this.getId();

	// if collapse icon needs to be focused, find out which one - if any - is currently visible
	if (this._bFocusCollapseIcon) {
		var $collArrow = jQuery.sap.byId(id + "-collArrow");
		if($collArrow.is(":visible") && ($collArrow.css("visibility") == "visible" || $collArrow.css("visibility") == "inherit")) {
			collId = $collArrow[0].id;
		} else {
			var $collIco = jQuery.sap.byId(id + "-collIco");
			if ($collIco.is(":visible") && ($collIco.css("visibility") == "visible" || $collIco.css("visibility") == "inherit")) {
				collId = $collIco[0].id;
			}
		}

	}

	// if a collapse icon is visible and to be focused, return its ID, otherwise just the control ID
	return {id:(collId ? collId : id)};
};


/**
 *
 * @private
 */
sap.ui.commons.Panel.prototype.applyFocusInfo = function (oFocusInfo) {
	var $DomRef;
	if (oFocusInfo && oFocusInfo.id && ($DomRef = jQuery.sap.byId(oFocusInfo.id)) && ($DomRef.length > 0)) {
		$DomRef.focus();
	} else {
		this.focus();
	}
	return this;
};


/**
 * Measures and calculates/sets sizes as soon as the CSS has been applied after rendering or a theme switch
 * @private
 */
sap.ui.commons.Panel.prototype._initializeSizes = function() {
	var bRtl = sap.ui.getCore().getConfiguration().getRTL();

	// maximum width of a toolbar item -> min toolbar width
	var aButtons = this.getButtons();
	if (aButtons && aButtons.length > 0) {
		var maxWidth = 0;
		jQuery(this._oToolbarDomRef).children().each(function(){
			var width = this.offsetWidth;
			if (width > maxWidth) {
				maxWidth = width;
			}
		});
		this._iMaxTbBtnWidth = maxWidth;

		if (this._oToolbarDomRef) {
			this._oToolbarDomRef.style.minWidth = maxWidth + "px";

			// calculate the toolbar borders and margins
			var $tb = jQuery(this._oToolbarDomRef);
			this._iTbMarginsAndBorders = $tb.outerWidth(true) - $tb.width();
		}
	}

	// calculate available space between left- and right-aligned items with static width
	var beginBorderOfTitle = this._oTitleDomRef.offsetLeft; // displacement of the beginning of the title from the Panel border
	var totalWidth = this.getDomRef().offsetWidth;
	if (bRtl) {
		beginBorderOfTitle = totalWidth - (beginBorderOfTitle + this._oTitleDomRef.offsetWidth); // RTL case
	}
	var $title = jQuery(this._oTitleDomRef);
	this._iOptTitleWidth = $title.width() + 1 /*+1 to avoid subpixel issues*/;
	this._iTitleMargin = $title.outerWidth(true) - $title.outerWidth();
	var beginBorderOfRightItems = 10000;
	jQuery(this._oHeaderDomRef).children(".sapUiPanelHdrRightItem").each(function(){
		var begin = this.offsetLeft;
		if (bRtl) {
			begin = totalWidth - (begin + this.offsetWidth); // RTL case
		}
		if ((begin < beginBorderOfRightItems) && (begin > 0)) {
			beginBorderOfRightItems = begin;
		}
	});


	// set minimum Panel width as sum of minimum sizes
	var minWidth = beginBorderOfTitle;
	minWidth += this._iMinTitleWidth; // 30px is ok even if there is no title
	minWidth += this._iMaxTbBtnWidth + 1; // -1 if there is no toolbar... 1px more or less is no problem here
	minWidth += (beginBorderOfRightItems == 10000) ? 10 : (totalWidth - beginBorderOfRightItems); // use 10 as hardcoded right border
	this.getDomRef().style.minWidth = minWidth + 10 + "px";


	// restore scroll positions
	if (this._oScrollDomRef) {
		var scrollTop = this.getProperty("scrollTop");
		if (scrollTop > 0) {
			this._oScrollDomRef.scrollTop = scrollTop;
		}
		var scrollLeft = this.getProperty("scrollLeft");
		if (scrollLeft > 0) {
			this._oScrollDomRef.scrollLeft = scrollLeft;
		}

	}

};


/**
 * Adapts the absolute position of the content when height is set.
 * @private
 */
sap.ui.commons.Panel.prototype._fixContentHeight = function() {
	//if height is set and an icon or at least one toolbar button is present (which *could* inflate the header height), the cont top must be set to the header height
	if (sap.ui.commons.Panel._isSizeSet(this.getHeight()) && (this._hasIcon() || (this.getButtons().length > 0))) { // TODO: what if the icon is not yet loaded?
		this._iContTop = this._oHeaderDomRef.offsetHeight;
		if (this._oScrollDomRef) {
			this._oScrollDomRef.style.top = this._iContTop + "px";
		}
	}
};


/**
 * Called in browsers not supporting the FlexBox layout whenever the Panel size is changing. This method registers a delayed reaction to the size changes.
 * When there are further size changes during this delay, the delay starts from zero. So the Panel is not adapted during the resize, but only after resizing has
 * completed. This should fix most of the related performance issues.
 * @private
 */
sap.ui.commons.Panel.prototype._handleResizeSoon = function() {
	if (this._resizeDelayTimer) {
		jQuery.sap.clearDelayedCall(this._resizeDelayTimer);
	}

	this._resizeDelayTimer = jQuery.sap.delayedCall(200, this, function() {
		this._handleResizeNow();
		this._resizeDelayTimer = null;
	});
};


/**
 * Called in browsers not supporting the FlexBox layout whenever the Panel size has changed and the header layout finally needs to be adapted.
 * Basically this method imitates that layout's behavior.
 * @private
 */
sap.ui.commons.Panel.prototype._handleResizeNow = function() {
	// in IE8 (maybe also IE9) the sizes of the flexible items (title and toolbar) need to be adjusted
	// whenever the Panel width changes
	if (!jQuery.support.flexBoxLayout && this.getDomRef()) {
		var bRtl = sap.ui.getCore().getConfiguration().getRTL();

		/* Algorithm:
		 * 1. calculate space available for the two elements
		 * 2. if no toolbar is present, apply this width to the title, else:
		 * 3.   reduce toolbar width until maxBtnSize is reached, then reduce title width until minimum (do not make either any smaller; the Panel has a min-width anyway)
		 * 4.   apply these widths
		 */

		// begin of Panel to begin of Title
		var beginBorderOfTitle = this._oTitleDomRef.offsetLeft; // displacement of the beginning of the title from the Panel border
		var totalWidth = this.getDomRef().offsetWidth;
		if (bRtl) {
			beginBorderOfTitle = totalWidth - (beginBorderOfTitle + this._oTitleDomRef.offsetWidth); // RTL case
		}

		// begin of Panel to begin if "RightItems"
		var beginBorderOfRightItems = 10000;
		jQuery(this._oHeaderDomRef).children(".sapUiPanelHdrRightItem").each(function(){
			var begin = this.offsetLeft;
			if (bRtl) {
				begin = totalWidth - (begin + this.offsetWidth); // RTL case
			}
			if ((begin < beginBorderOfRightItems) && (begin > 0)) {
				beginBorderOfRightItems = begin;
			}
		});

		var availableSpace = (beginBorderOfRightItems == 10000) ?
					this.$().width() - beginBorderOfTitle - 20
				: beginBorderOfRightItems - beginBorderOfTitle - 10;

		var aButtons = this.getButtons();
		if (aButtons && aButtons.length > 0) { // there are title and toolbar; calculate and set both sizes
			// differentiate between two cases: 1. there is enough space for title plus minimum toolbar width
			//                                  2. both need to be reduced in size
			if ((availableSpace - this._iOptTitleWidth - this._iTitleMargin) > (this._iMaxTbBtnWidth - this._iTbMarginsAndBorders)) {
				// if available width minus optimum title width is still more than the minimum toolbar width,
				// give all remaining width to the toolbar
				this._oToolbarDomRef.style.width = (availableSpace - this._iOptTitleWidth - this._iTitleMargin - this._iTbMarginsAndBorders) + "px";
				this._oTitleDomRef.style.width = this._iOptTitleWidth + "px";
			} else {
				// both are affected => set toolbar to minimum and reduce title width, but not smaller than minimum
				this._oToolbarDomRef.style.width = this._iMaxTbBtnWidth + "px";
				this._oTitleDomRef.style.width = Math.max((availableSpace - this._iMaxTbBtnWidth - this._iTbMarginsAndBorders), this._iMinTitleWidth) + "px";
			}

		} else {
			// no toolbar
			this._oTitleDomRef.style.width = Math.max(availableSpace, this._iMinTitleWidth) + "px";
		}
	}

	// in case the resizing caused button wrapping, adapt content height -- FOR ALL BROWSERS!
	this._fixContentHeight();
};


/**
 * Helper method to find out whether the Panel has an icon.
 * @private
 */
sap.ui.commons.Panel.prototype._hasIcon = function() {
	return (this.getTitle() && this.getTitle().getIcon());
};



/**
 * Property setter for the "enabled" state
 *
 * @param {boolean} bEnabled whether the Panel should be enabled or not
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setEnabled = function(bEnabled) {
	this.setProperty("enabled", bEnabled, true); // no re-rendering!
	// if already rendered, adapt rendered control without complete re-rendering
	jQuery(this.getDomRef()).toggleClass("sapUiPanelDis", !bEnabled);
	return this;
};


/**
 * Property setter for the padding
 *
 * @param {boolean} bPadding whether the Panel should have padding
 * @returns {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setApplyContentPadding = function(bPadding) {
	this.setProperty("applyContentPadding", bPadding, true); // no re-rendering!
	jQuery(this.getDomRef()).toggleClass("sapUiPanelWithPadding", bPadding);
	return this;
};


/**
 * Property setter for the "collapsed" state
 *
 * @param {boolean} bCollapsed whether the Panel should be collapsed or not
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setCollapsed = function(bCollapsed) {
	this.setProperty("collapsed", bCollapsed, true); // no re-rendering!
	this._setCollapsedState(bCollapsed); // adapt rendered control without complete re-rendering
	return this;
};


/**
 * Internal method for applying a (non-)"collapsed" state to the rendered HTML
 *
 * @param bCollapsed whether the Panel should be collapsed or not
 * @private
 */
sap.ui.commons.Panel.prototype._setCollapsedState = function(bCollapsed) {
	var oDomRef = this.getDomRef();
	if (oDomRef) {
		// after Panel has been rendered
		var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
		if (bCollapsed) {
			// collapsing
			if (!this.getWidth()) {
				oDomRef.style.width = this.getDomRef().offsetWidth + "px"; // maintain the current width
			}
			jQuery(oDomRef).addClass("sapUiPanelColl");
			if (accessibility) {
				oDomRef.setAttribute("aria-expanded", "false");
			}
			if (this.getHeight()) {
				// if there is a height set, the Panel would still consume the respective space, so remove the height setting
				oDomRef.style.height = "auto";
			}
			// update tooltips
			var sExpandTooltip = this._rb.getText("PANEL_EXPAND");
			this.$("collArrow").attr("title", sExpandTooltip);
			this.$("collIco").attr("title", sExpandTooltip);

		} else {
			// expanding
			if (!this.getDomRef("cont")) {
				// content has not been rendered yet, so render it now
				this._bFocusCollapseIcon = true; // restore focus to collapse icon/button after rendering
				this.rerender();
			} else {
				// content exists already, just make it visible again
				jQuery(oDomRef).removeClass("sapUiPanelColl");
				if (accessibility) {
					oDomRef.setAttribute("aria-expanded", "true");
				}
				if (!this.getWidth()) {
					oDomRef.style.width = "auto"; // restore the automatic width behavior
				}
				if (this.getHeight()) {
					oDomRef.style.height = this.getHeight(); // restore the set height
				}
				// update tooltips
				var sCollapseTooltip = this._rb.getText("PANEL_COLLAPSE");
				this.$("collArrow").attr("title", sCollapseTooltip);
				this.$("collIco").attr("title", sCollapseTooltip);
			}
		}
	}
};


/**
 * Static method that finds out whether the given CSS size is actually set.
 * Returns "true" for absolute and relative sizes, returns "false" if "null", "inherit" or "auto" is given.
 *
 * @static
 * @param sCssSize a css size string (must be a valid CSS size, or null)
 * @private
 */
sap.ui.commons.Panel._isSizeSet = function(sCssSize) {
	return (sCssSize && !(sCssSize =="auto") && !(sCssSize == "inherit"));
};

// API method
sap.ui.commons.Panel.prototype.setTitle = function(oTitle) {
	var oOldTitle = this.getTitle();
	this.setAggregation("title", oTitle);
	// check whether the title has been created on the fly. Then we are owner of it and should destroy it
	// the ID check should be sufficient as long as the naming conventions are obeyed
	if ( oOldTitle && oOldTitle !== oTitle && oOldTitle.getId() === this.getId() + "-tit" ) {
		oOldTitle.destroy();
	}
	return this;
};

// API method
sap.ui.commons.Panel.prototype.setText = function(sText) {
	if (!this.getTitle()) {
		this.setTitle(new sap.ui.core.Title(this.getId() + "-tit",{text:sText}));
	} else {
		this.getTitle().setText(sText);
	}
	return this;
};

// API method
sap.ui.commons.Panel.prototype.getText = function () {
	if (!this.getTitle()) {
		return "";
	} else {
		return this.getTitle().getText();
	}
};


/**
 * Returns the scroll position of the panel in pixels from the left. Returns 0 if not rendered yet.
 * Also internally updates the control property.
 *
 * @return the scroll position
 * @public
 */
sap.ui.commons.Panel.prototype.getScrollLeft = function () {
	var scrollLeft = 0;
	if (this._oScrollDomRef) {
		if (sap.ui.getCore().getConfiguration().getRTL()) {
			scrollLeft = jQuery(this._oScrollDomRef).scrollLeftRTL();
		} else {
			scrollLeft = jQuery(this._oScrollDomRef).scrollLeft();
		}
		jQuery.sap.assert(typeof scrollLeft == "number", "scrollLeft read from DOM should be a number");
		this.setProperty("scrollLeft", scrollLeft, true);
	}

	return scrollLeft;
};


/**
 * Sets the scroll position of the panel in pixels from the left.
 *
 * @param {int} iPosition the position to scroll to
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setScrollLeft = function (iPosition) {
	this.setProperty("scrollLeft", iPosition, true);
	if (this._oScrollDomRef) {
		if (sap.ui.getCore().getConfiguration().getRTL()) {
			jQuery(this._oScrollDomRef).scrollLeftRTL(iPosition);
		} else {
			jQuery(this._oScrollDomRef).scrollLeft(iPosition);
		}
	}
	return this;
};


/**
 * Returns the scroll position of the panel in pixels from the top. Returns 0 if not rendered yet.
 * Also internally updates the control property.
 *
 * @return the scroll position
 * @public
 */
sap.ui.commons.Panel.prototype.getScrollTop = function () {
	var scrollTop = 0;
	if (this._oScrollDomRef) {
		scrollTop = this._oScrollDomRef.scrollTop;
		this.setProperty("scrollTop", scrollTop, true);
	}

	return scrollTop;
};


/**
 * Sets the scrolls position of the panel in pixels from the top.
 *
 * @param {int} iPosition the position to scroll to
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setScrollTop = function (iPosition) {
	this.setProperty("scrollTop", iPosition, true);
	if (this._oScrollDomRef) {
		this._oScrollDomRef.scrollTop = iPosition;
	}
	return this;
};


/**
 * Sets the dimensions of the panel.
 *
 * @param {string} sWidth the width of the panel as CSS size
 * @param {string} sHeight the height of the panel as CSS size
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setDimensions = function (sWidth, sHeight) {
	jQuery.sap.assert(typeof sWidth == "string" && typeof sHeight == "string", "sWidth and sHeight must be strings");
	this.setWidth(sWidth); // does not rerender
	this.setHeight(sHeight);
	return this;
};


/**
 * Sets the width of the panel.
 *
 * @param {string} sWidth the width of the panel as CSS size
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setWidth = function (sWidth) {
	this.setProperty("width", sWidth, true); // don't rerender
	var oDomRef = this.getDomRef();
	if (oDomRef) {
		oDomRef.style.width = sWidth;
	}
	return this;
};


/**
 * Sets the height of the panel.
 *
 * @param {string} sHeight the height of the panel as CSS size
 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.Panel.prototype.setHeight = function (sHeight) {
	this.setProperty("height", sHeight, true); // don't rerender
	var oDomRef = this.getDomRef();
	if (oDomRef) {
		oDomRef.style.height = sHeight;
	}
	return this;
};



/*   Event Handling   */

/**
 * Handles mouse clicks
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Panel.prototype.onclick = function(oEvent) {
	this._handleTrigger(oEvent);
};

/**
 * Handles "space" presses
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Panel.prototype.onsapspace = function(oEvent) {
	this._handleTrigger(oEvent);
};

/**
 * Handles any "triggering" actions like click and space
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.Panel.prototype._handleTrigger = function(oEvent) {
	var id = this.getId();
	// minimize button toggled
	if((oEvent.target.id === id + "-collArrow") ||
			(oEvent.target.id === id + "-collIco") ||
			// toggle triggered via space key
			(oEvent.target.id === id && oEvent.type === "sapspace" && this.getShowCollapseIcon())) {
		this.setCollapsed(!this.getProperty("collapsed"));
		oEvent.preventDefault();
		oEvent.stopPropagation();
		this.fireEvent("collapsedToggled"); //private event used in ResponsiveLayout
	}
};

}; // end of sap/ui/commons/Panel.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.PasswordFieldRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.commons.PasswordFieldRenderer");


/**
 * @class PasswordFieldRenderer.
 * @static
 */
sap.ui.commons.PasswordFieldRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.TextFieldRenderer);


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.fw.Control} oPasswordField an object representation of the control that should be rendered
 */
sap.ui.commons.PasswordFieldRenderer.renderInnerAttributes = function(rm, oPasswordField) {

	if (sap.ui.Device.support.input.placeholder || oPasswordField.getValue() || !oPasswordField.getPlaceholder()) {
		// if browser not supports placeholder on input tag, set the password type only if placeholder is not displayed
		rm.writeAttribute('type', 'password');
	}

};


sap.ui.commons.PasswordFieldRenderer.renderTextFieldEnabled = function(rm, oPasswordField) {
	if (!oPasswordField.getEnabled() && !oPasswordField.getEditable()) {
		// "disabled" may not be rendered because the Jaws screenreader then reads the password
		// use "readonly" instead
		// but write it only if it has not yet been written by the TextFieldRenderer
		rm.writeAttribute('readonly', 'readonly');
		rm.writeAttribute('tabindex', '-1'); // apart from that, act as if disabled, e.g. no tab-stop
	} else {
		rm.writeAttribute('tabindex', '0'); // editable and readonly have a tab-stop
	}
};


// this method uses "readonly" instead of "disabled" because with "disabled" the Jaws screenreader reads the password
sap.ui.commons.PasswordFieldRenderer.setEnabled = function(oPasswordField, bEnabled) {
	var oTfRef = oPasswordField.getDomRef();

	if (bEnabled) {
		if (oPasswordField.getEditable()) {
			jQuery(oTfRef).removeClass('sapUiTfDsbl').addClass('sapUiTfStd');
			jQuery(oTfRef).removeAttr('readonly').attr('tabindex', '0');
		} else {
			jQuery(oTfRef).removeClass('sapUiTfDsbl').addClass('sapUiTfRo');
			jQuery(oTfRef).attr('tabindex', '0');
		}
	} else {
		if (oPasswordField.getEditable()) {
			jQuery(oTfRef).removeClass('sapUiTfStd').addClass('sapUiTfDsbl');
			jQuery(oTfRef).attr('readonly', 'readonly').attr('tabindex', '-1');
		} else {
			jQuery(oTfRef).removeClass('sapUiTfRo').addClass('sapUiTfDsbl');
			jQuery(oTfRef).attr( 'tabindex', '-1');
		}
	}
};


}; // end of sap/ui/commons/PasswordFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ProgressIndicator') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.ProgressIndicator.
jQuery.sap.declare("sap.ui.commons.ProgressIndicator");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ProgressIndicator.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getBarColor barColor} : sap.ui.core.BarColor (default: sap.ui.core.BarColor.NEUTRAL)</li>
 * <li>{@link #getDisplayValue displayValue} : string (default: '0%')</li>
 * <li>{@link #getPercentValue percentValue} : int (default: 0)</li>
 * <li>{@link #getShowValue showValue} : boolean (default: true)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '100%')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Shows the progress of a process in a graphical way. The indicator can be displayed with or without numerical values.
 * The filling can be displayed in color only, or additionally with the percentage rate. The indicator status can be interactive.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.ProgressIndicator
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.ProgressIndicator", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"barColor" : {type : "sap.ui.core.BarColor", group : "Appearance", defaultValue : sap.ui.core.BarColor.NEUTRAL},
		"displayValue" : {type : "string", group : "Appearance", defaultValue : '0%'},
		"percentValue" : {type : "int", group : "Data", defaultValue : 0},
		"showValue" : {type : "boolean", group : "Appearance", defaultValue : true},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.ProgressIndicator with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.ProgressIndicator.extend
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.ProgressIndicator#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ProgressIndicator#setVisible
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Switches enabled state of the control. Disabled fields have different colors, and can not be focused.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.ProgressIndicator#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ProgressIndicator#setEnabled
 * @function
 */


/**
 * Getter for property <code>barColor</code>.
 * The color of the bar. Enumeration sap.ui.core.BarColor provides CRITICAL (yellow), NEGATIVE (red), POSITIVE (green), NEUTRAL (blue) (default value).
 *
 * Default value is <code>NEUTRAL</code>
 *
 * @return {sap.ui.core.BarColor} the value of property <code>barColor</code>
 * @public
 * @name sap.ui.commons.ProgressIndicator#getBarColor
 * @function
 */

/**
 * Setter for property <code>barColor</code>.
 *
 * Default value is <code>NEUTRAL</code> 
 *
 * @param {sap.ui.core.BarColor} oBarColor  new value for property <code>barColor</code>
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ProgressIndicator#setBarColor
 * @function
 */


/**
 * Getter for property <code>displayValue</code>.
 * The text value to be displayed in the bar.
 *
 * Default value is <code>0%</code>
 *
 * @return {string} the value of property <code>displayValue</code>
 * @public
 * @name sap.ui.commons.ProgressIndicator#getDisplayValue
 * @function
 */

/**
 * Setter for property <code>displayValue</code>.
 *
 * Default value is <code>0%</code> 
 *
 * @param {string} sDisplayValue  new value for property <code>displayValue</code>
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ProgressIndicator#setDisplayValue
 * @function
 */


/**
 * Getter for property <code>percentValue</code>.
 * The numerical value for the displayed length of the progress bar.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>percentValue</code>
 * @public
 * @name sap.ui.commons.ProgressIndicator#getPercentValue
 * @function
 */

/**
 * Setter for property <code>percentValue</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iPercentValue  new value for property <code>percentValue</code>
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ProgressIndicator#setPercentValue
 * @function
 */


/**
 * Getter for property <code>showValue</code>.
 * Specifies whether the current value shall be rendered inside the bar.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showValue</code>
 * @public
 * @name sap.ui.commons.ProgressIndicator#getShowValue
 * @function
 */

/**
 * Setter for property <code>showValue</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowValue  new value for property <code>showValue</code>
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ProgressIndicator#setShowValue
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * The width of the control.
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.ProgressIndicator#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.ProgressIndicator#setWidth
 * @function
 */


// Start of sap\ui\commons\ProgressIndicator.js
/**
 * Function is called when ProgressIndicator is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.ProgressIndicator.prototype.onclick = function(oEvent) {

	// Set focus to whole ProgressIndicator control
	this.focus();

};

sap.ui.commons.ProgressIndicator.prototype.setEndBar = function () {

	var widthBar = this.getPercentValue();
	var widthBorder;
	var sBarColor = this.getBarColor();
	var time;

	this.oBar  = this.getDomRef("bar");
	this.oEnd  = this.getDomRef("end");
	this.oBox  = this.getDomRef("box");

	jQuery(this.oEnd).removeClass('sapUiProgIndEndHidden');

	switch (sBarColor) {
		case "POSITIVE":
			jQuery(this.oEnd).addClass('sapUiProgIndPosEnd');
			break;
		case "NEGATIVE":
			jQuery(this.oEnd).addClass('sapUiProgIndNegEnd');
			break;
		case "CRITICAL":
			jQuery(this.oEnd).addClass('sapUiProgIndCritEnd');
			break;
		case "NEUTRAL":
			jQuery(this.oEnd).addClass('sapUiProgIndEnd');
			break;
		default:
			jQuery(this.oEnd).addClass('sapUiProgIndEnd');
			break;
	}

	if (widthBar > 100) {
		widthBorder = (10000 / widthBar) + '%';
	}
	else {
		widthBorder = '100%';
	}

	if (widthBar > 100) {
		time = (widthBar - 100) * 20;
	}
	else {
		time = (100 - widthBar) * 20;
	}

	jQuery(this.oBox).animate({width: widthBorder}, 0, 'linear');

	if(this.bRtl){
		jQuery(this.oEnd).animate({right: widthBorder}, time, 'linear');
	}
	else {
		jQuery(this.oEnd).animate({left: widthBorder}, time, 'linear');
	}

	jQuery(this.oBar).animate({width: widthBar + '%'}, time, 'linear');
	if(!this.oThis){
		this.oThis = this.$();
	}
	this.oThis.attr('aria-valuenow', widthBar + '%');

};

sap.ui.commons.ProgressIndicator.prototype.setEndBarGoesBack = function (iPercentValue) {

	var widthBar = this.getPercentValue();
	var widthBorder;
	var sBarColor = this.getBarColor();
	var time;

	this.oBar  = this.getDomRef("bar");
	this.oEnd  = this.getDomRef("end");
	this.oBox  = this.getDomRef("box");

	if (iPercentValue > 100) {
		widthBorder = (10000 / iPercentValue) + '%';
	}
	else {
		widthBorder = '100%';
	}

	switch (sBarColor) {
		case "POSITIVE":
			jQuery(this.oEnd).removeClass('sapUiProgIndPosEnd');
			break;
		case "NEGATIVE":
			jQuery(this.oEnd).removeClass('sapUiProgIndNegEnd');
			break;
		case "CRITICAL":
			jQuery(this.oEnd).removeClass('sapUiProgIndCritEnd');
			break;
		case "NEUTRAL":
			jQuery(this.oEnd).removeClass('sapUiProgIndEnd');
			break;
		default:
			jQuery(this.oEnd).removeClass('sapUiProgIndEnd');
			break;
	}

	jQuery(this.oEnd).addClass('sapUiProgIndEndHidden');

	if (widthBar > 100) {
		time = (widthBar - 100) * 20;
	}
	else {
		time = (100 - widthBar) * 20;
	}

	jQuery(this.oBox).animate({width: widthBorder}, 0, 'linear');

	if(this.bRtl){
		jQuery(this.oEnd).animate({right: widthBorder}, time, 'linear');
	}
	else {
		jQuery(this.oEnd).animate({left: widthBorder}, time, 'linear');
	}

	jQuery(this.oBar).animate({width: widthBar + '%'}, time, 'linear');
	if(!this.oThis){
		this.oThis = this.$();
	}
	this.oThis.attr('aria-valuenow', widthBar + '%');

};

/**
 * Property setter for the PercentValue
 * A new rendering is not necessary, only the bar has to be moved.
 *
 * @param {int} iPercentValue
 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
 * @public
 */
sap.ui.commons.ProgressIndicator.prototype.setPercentValue = function(iPercentValue) {

	var widthBar = this.getPercentValue();
	var widthBorder;
	var sBarColor = this.getBarColor();

	this.oBar  = this.getDomRef("bar");
	this.oEnd  = this.getDomRef("end");
	this.oBox  = this.getDomRef("box");

	var that = this;
	var time;

	if (iPercentValue < 0) {
		iPercentValue = 0;
	}

	if (iPercentValue > 100) {
		widthBorder = (10000 / iPercentValue) + '%';
	}
	else {
		widthBorder = '100%';
	}

	if(!this.oBar){
		// Not already rendered -> return and render
		time = iPercentValue * 20;
		this.setProperty('percentValue', iPercentValue, true); // No re-rendering!
		jQuery(this.oBar).animate({width: iPercentValue + '%'}, time, 'linear');
		return this;
	}

	if (iPercentValue > 100 && widthBar <= 100) {
		time = (100 - widthBar) * 20;
		this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
		jQuery(this.oBar).animate({width: '100%'}, time, 'linear', function() {
		that.setEndBar();
		});
	}
	else if (iPercentValue <= 100 && widthBar > 100) {
		time = (widthBar - 100) * 20;
		this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
		jQuery(this.oBar).animate({width: '100%'}, time, 'linear', function() {
		that.setEndBarGoesBack();
		});
	}
	else if (iPercentValue > 100 && widthBar > 100) {
		if (iPercentValue > widthBar) {
			time = (iPercentValue - widthBar) * 20;
		}
		else {
			time = (widthBar - iPercentValue) * 20;
		}
		widthBorder = (10000 / iPercentValue) + '%';
		this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
		jQuery(this.oBox).animate({width: widthBorder}, 0, 'linear');

		if(this.bRtl){
			jQuery(this.oEnd).animate({right: widthBorder}, time, 'linear');
		}
		else {
			jQuery(this.oEnd).animate({left: widthBorder}, time, 'linear');
		}

		jQuery(this.oBar).animate({width: iPercentValue + '%'}, time, 'linear', function() {
		});
		if(!this.oThis){
			this.oThis = this.$();
		}
		this.oThis.attr('aria-valuenow', iPercentValue + '%');
	}
	else {
		if (iPercentValue > widthBar) {
			time = (iPercentValue - widthBar) * 20;
		}
		else {
			time = (widthBar - iPercentValue) * 20;
		}
		this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
		jQuery(this.oBar).animate({width: iPercentValue + '%'}, time, 'linear');
		if(!this.oThis){
			this.oThis = this.$();
		}
		this.oThis.attr('aria-valuenow', iPercentValue + '%');
	}

	return this;
};

}; // end of sap/ui/commons/ProgressIndicator.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButton') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.RadioButton.
jQuery.sap.declare("sap.ui.commons.RadioButton");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new RadioButton.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getEditable editable} : boolean (default: true)</li>
 * <li>{@link #getSelected selected} : boolean (default: false)</li>
 * <li>{@link #getValueState valueState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getTextDirection textDirection} : sap.ui.core.TextDirection (default: sap.ui.core.TextDirection.Inherit)</li>
 * <li>{@link #getGroupName groupName} : string (default: 'sapUiRbDefaultGroup')</li>
 * <li>{@link #getKey key} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getAriaDescribedBy ariaDescribedBy} : string | sap.ui.core.Control</li>
 * <li>{@link #getAriaLabelledBy ariaLabelledBy} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.RadioButton#event:select select} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Consists of a round element and a descriptive text. Generally, you would create at least two radio button controls;
 * by this, you provide a limited choice for the user. Radio buttons can trigger events.
 * Available value states are "Error", "None", "Success", "Warning".
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.RadioButton
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.RadioButton", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"text" : {type : "string", group : "Data", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"editable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"selected" : {type : "boolean", group : "Data", defaultValue : false},
		"valueState" : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"textDirection" : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
		"groupName" : {type : "string", group : "Behavior", defaultValue : 'sapUiRbDefaultGroup'},
		"key" : {type : "string", group : "Data", defaultValue : null}
	},
	associations : {
		"ariaDescribedBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
		"ariaLabelledBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
	},
	events : {
		"select" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.RadioButton with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.RadioButton.extend
 * @function
 */

sap.ui.commons.RadioButton.M_EVENTS = {'select':'select'};


/**
 * Getter for property <code>text</code>.
 * Defines the text displayed next to the radio button.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.commons.RadioButton#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setText
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible radio buttons are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.RadioButton#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setVisible
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * 
 * Disabled controls are displayed in another color, depending on the customer settings.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.commons.RadioButton#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setEnabled
 * @function
 */


/**
 * Getter for property <code>editable</code>.
 * Specifies whether the user can choose a radio button
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @name sap.ui.commons.RadioButton#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setEditable
 * @function
 */


/**
 * Getter for property <code>selected</code>.
 * Specifies the select state of the radio button
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>selected</code>
 * @public
 * @name sap.ui.commons.RadioButton#getSelected
 * @function
 */

/**
 * Setter for property <code>selected</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSelected  new value for property <code>selected</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setSelected
 * @function
 */


/**
 * Getter for property <code>valueState</code>.
 * 
 * Enumeration sap.ui.core.ValueState provides state values Error, Success, Warning, None
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>valueState</code>
 * @public
 * @name sap.ui.commons.RadioButton#getValueState
 * @function
 */

/**
 * Setter for property <code>valueState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oValueState  new value for property <code>valueState</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setValueState
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * The control width depends on the text length. Alternatively, CSS-sizes in % or px can be set.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.RadioButton#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setWidth
 * @function
 */


/**
 * Getter for property <code>textDirection</code>.
 * 
 * Available options are LTR and RTL. Alternatively, the control can inherit the text direction from its parent container.
 *
 * Default value is <code>Inherit</code>
 *
 * @return {sap.ui.core.TextDirection} the value of property <code>textDirection</code>
 * @public
 * @name sap.ui.commons.RadioButton#getTextDirection
 * @function
 */

/**
 * Setter for property <code>textDirection</code>.
 *
 * Default value is <code>Inherit</code> 
 *
 * @param {sap.ui.core.TextDirection} oTextDirection  new value for property <code>textDirection</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setTextDirection
 * @function
 */


/**
 * Getter for property <code>groupName</code>.
 * Name of the radio button group the current radio button belongs to. You can define a new name for the group.
 * If no new name is specified, this radio button belongs to the sapUiRbDefaultGroup per default. Default behavior of a radio button
 * in a group is that when one of the radio buttons in a group is selected, all others are unselected.
 *
 * Default value is <code>'sapUiRbDefaultGroup'</code>
 *
 * @return {string} the value of property <code>groupName</code>
 * @public
 * @name sap.ui.commons.RadioButton#getGroupName
 * @function
 */

/**
 * Setter for property <code>groupName</code>.
 *
 * Default value is <code>'sapUiRbDefaultGroup'</code> 
 *
 * @param {string} sGroupName  new value for property <code>groupName</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setGroupName
 * @function
 */


/**
 * Getter for property <code>key</code>.
 * Can be used for subsequent actions
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>key</code>
 * @public
 * @name sap.ui.commons.RadioButton#getKey
 * @function
 */

/**
 * Setter for property <code>key</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sKey  new value for property <code>key</code>
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#setKey
 * @function
 */


/**
 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.RadioButton#getAriaDescribedBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaDescribedBy
 *    Id of a ariaDescribedBy which becomes an additional target of this <code>ariaDescribedBy</code> association.
 *    Alternatively, a ariaDescribedBy instance may be given. 
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#addAriaDescribedBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaDescribedBy the ariaDescribedBy to remove or its index or id
 * @return {string} the id of the removed ariaDescribedBy or null
 * @public
 * @name sap.ui.commons.RadioButton#removeAriaDescribedBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.RadioButton#removeAllAriaDescribedBy
 * @function
 */

	
/**
 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.RadioButton#getAriaLabelledBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaLabelledBy
 *    Id of a ariaLabelledBy which becomes an additional target of this <code>ariaLabelledBy</code> association.
 *    Alternatively, a ariaLabelledBy instance may be given. 
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#addAriaLabelledBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaLabelledBy the ariaLabelledBy to remove or its index or id
 * @return {string} the id of the removed ariaLabelledBy or null
 * @public
 * @name sap.ui.commons.RadioButton#removeAriaLabelledBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.RadioButton#removeAllAriaLabelledBy
 * @function
 */

	
/**
 * Event is triggered when the user makes a change on the radio button.
 *
 * @name sap.ui.commons.RadioButton#select
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'select' event of this <code>sap.ui.commons.RadioButton</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.RadioButton</code>.<br/> itself. 
 *  
 * Event is triggered when the user makes a change on the radio button.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.RadioButton</code>.<br/> itself.
 *
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#attachSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'select' event of this <code>sap.ui.commons.RadioButton</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButton#detachSelect
 * @function
 */

/**
 * Fire event select to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.RadioButton} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.RadioButton#fireSelect
 * @function
 */


// Start of sap\ui\commons\RadioButton.js
/**
 * Event handler called when the radio button is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.RadioButton.prototype.onclick = function(oEvent) {

	if(this.getEnabled() && oEvent.target.id == (this.getId()+"-RB")){
		this.focus();
	}

	if(!!sap.ui.Device.browser.internet_explorer && (/*!this.getEditable() ||*/ !this.getEnabled())){ //According to CSN2581852 2012 a readonly CB should be in the tabchain 
		// in IE tabindex = -1 hides focus, so in readOnly case tabindex must be set to 0
		// as long as RadioButton is clicked on
		this.$().attr("tabindex", 0).toggleClass("sapUiRbFoc");
	}

	this.userSelect(oEvent);
};

/**
 * Event handler called when the space key is pressed.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.RadioButton.prototype.onsapspace = function(oEvent) {

	if(this.getEnabled() && oEvent.target.id == (this.getId()+"-RB")){
		this.focus();
	}
	this.userSelect(oEvent);
};

/**
 * Event handler called focus is set on Radio button
 * Problem in HCB: Focus is set in IE8 to bullet, not to whole control
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.RadioButton.prototype.onsaptabnext = function(oEvent) {

	if(!!sap.ui.Device.browser.internet_explorer){
		this.bTabPressed = true;
		var that = this;
		window.setTimeout(function(){that.bTabPressed = false;}, 100);
	}
};

/**
 * Event handler called when the radio button is focused
 * Problem in HCB: Focus is sometimes set in IE8 to bullet, not to whole control
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.RadioButton.prototype.onfocusin = function(oEvent) {

	if(this.getEnabled() && oEvent.target.id == (this.getId()+"-RB")){
		if(this.bTabPressed){
			// this only occurs in IE in HCB mode
			var aFocusableElements = jQuery(":sapFocusable"),
				bFound = false;
			for(var i = 0; i < aFocusableElements.length; i++){
				if(bFound && aFocusableElements[i].parentNode != oEvent.target && aFocusableElements[i].tabIndex != "-1"){
					aFocusableElements[i].focus();
					oEvent.preventDefault();
					break;
				}
				if(oEvent.target == aFocusableElements[i]){
					bFound = true;
				}
			}
		}else{
			this.focus();
		}
	}
};

/**
 * Event handler called when the radio button is left
 * Problem in IE: Tabindex must be set back to -1
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.RadioButton.prototype.onfocusout = function(oEvent) {

	if(!!sap.ui.Device.browser.internet_explorer && (/*!this.getEditable() ||*/ !this.getEnabled())){ //According to CSN2581852 2012 a readonly CB should be in the tabchain 
		// in IE tabindex = -1 hides focus, so in readOnly case tabindex must be set to 0
		// as long as RadioButton is clicked on
		this.$().attr("tabindex", -1).toggleClass("sapUiRbFoc");
	}

};
/**
 * This method is used internally only, whenever the user somehow selects the RadioButton.
 * It is responsible for event cancellation and for firing the select event.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.commons.RadioButton.prototype.userSelect = function(oEvent) {
//	oEvent.preventDefault();
	// the control should not stop browser event propagation
	// Example: table control needs to catch and handle the event as well
	//oEvent.stopPropagation();

	if (this.getEnabled() && this.getEditable()) {
		var selected = this.getSelected();
		if (!selected) {
			this.setSelected(true);
			this.fireSelect({/* no parameters */});
		}
	}else{
		// readOnly or disabled -> don't allow browser to switch RadioButton on
		oEvent.preventDefault();
	}
};

// #############################################################################
// Overwritten methods that are also generated in RadioButton.API.js
// #############################################################################

/*
 * Overwrite the definition from RadioButton.API.js
 */
sap.ui.commons.RadioButton.prototype.setSelected = function(bSelected) {

	var bSelectedOld = this.getSelected();

	this.setProperty("selected", bSelected, true); // No re-rendering
	bSelected = this.getSelected();

	if (bSelected) { // If this radio button is selected, explicitly deselect the other radio buttons of the same group
		if (this.getGroupName() && (this.getGroupName() != "")) { // Do it only if groupName is set
			// TODO: Add control references to some static list when they are constructed, in order to avoid searching every time
			var others = document.getElementsByName(this.getGroupName());
			for (var i = 0; i < others.length; i++) {
				var other = others[i];
				// Recommendation is that the HTML radio button has an ID ending with "-RB"
				if (other.id && (other.id.length > 3) && (other.id.substr(other.id.length-3) == "-RB")) {
					// The SAPUI5 control is known by an ID without the "-RB" suffix
					var oControl = sap.ui.getCore().getElementById(other.id.substr(0, other.id.length-3));
					if (oControl instanceof sap.ui.commons.RadioButton && (oControl != this)) {
						oControl.setSelected(false);
					}
				}
			}
		}
	}
	if ((bSelectedOld != bSelected) && this.getDomRef() && this.getRenderer().setSelected){
		this.getRenderer().setSelected(this, bSelected);
	}

	return this;
};

sap.ui.commons.RadioButton.prototype.getTooltipDomRefs = function() {
	return this.$().children();
};
}; // end of sap/ui/commons/RadioButton.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButtonGroup') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.RadioButtonGroup.
jQuery.sap.declare("sap.ui.commons.RadioButtonGroup");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new RadioButtonGroup.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getColumns columns} : int (default: 1)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEditable editable} : boolean (default: true)</li>
 * <li>{@link #getValueState valueState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li>
 * <li>{@link #getSelectedIndex selectedIndex} : int (default: 0)</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getItems items} <strong>(default aggregation)</strong> : sap.ui.core.Item[]</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getAriaDescribedBy ariaDescribedBy} : string | sap.ui.core.Control</li>
 * <li>{@link #getAriaLabelledBy ariaLabelledBy} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.RadioButtonGroup#event:select select} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * a group of RadioButtons to hande as one UI element.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.RadioButtonGroup
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.RadioButtonGroup", { metadata : {

	publicMethods : [
		// methods
		"getSelectedItem", "setSelectedItem"
	],
	library : "sap.ui.commons",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"columns" : {type : "int", group : "Appearance", defaultValue : 1},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"editable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"valueState" : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},
		"selectedIndex" : {type : "int", group : "Data", defaultValue : 0},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true}
	},
	defaultAggregation : "items",
	aggregations : {
		"items" : {type : "sap.ui.core.Item", multiple : true, singularName : "item", bindable : "bindable"}
	},
	associations : {
		"ariaDescribedBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
		"ariaLabelledBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
	},
	events : {
		"select" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.RadioButtonGroup with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.RadioButtonGroup.extend
 * @function
 */

sap.ui.commons.RadioButtonGroup.M_EVENTS = {'select':'select'};


/**
 * Getter for property <code>width</code>.
 * Width of the RadioButtonGroup.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#setWidth
 * @function
 */


/**
 * Getter for property <code>columns</code>.
 * Number of RadioButtons displayed in one Line.
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>columns</code>
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getColumns
 * @function
 */

/**
 * Setter for property <code>columns</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iColumns  new value for property <code>columns</code>
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#setColumns
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Visibility of Group
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#setVisible
 * @function
 */


/**
 * Getter for property <code>editable</code>.
 * Specifies whether the user can choose a radio button.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#setEditable
 * @function
 */


/**
 * Getter for property <code>valueState</code>.
 * The value state to be displayed.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>valueState</code>
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getValueState
 * @function
 */

/**
 * Setter for property <code>valueState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oValueState  new value for property <code>valueState</code>
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#setValueState
 * @function
 */


/**
 * Getter for property <code>selectedIndex</code>.
 * Index of the selected/checked RadioButton.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>selectedIndex</code>
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getSelectedIndex
 * @function
 */

/**
 * Setter for property <code>selectedIndex</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iSelectedIndex  new value for property <code>selectedIndex</code>
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#setSelectedIndex
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * If set the RadioButtonGroup is enabled, if not it is disabled. If it is disabled all RadioButtons will be shown as disabled. The enabled property of the item will not be uses in this case. If the RadioButtonGroup is enabled the enabled property of the item will define if a RadioButton is enabled or not.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @since 1.10.3
 * @name sap.ui.commons.RadioButtonGroup#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @since 1.10.3
 * @name sap.ui.commons.RadioButtonGroup#setEnabled
 * @function
 */


/**
 * Getter for aggregation <code>items</code>.<br/>
 * RadioButtons of this RadioButtonGroup
 * 
 * <strong>Note</strong>: this is the default aggregation for RadioButtonGroup.
 * @return {sap.ui.core.Item[]}
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getItems
 * @function
 */


/**
 * Inserts a item into the aggregation named <code>items</code>.
 *
 * @param {sap.ui.core.Item}
 *          oItem the item to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the item should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the item is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the item is inserted at 
 *             the last position        
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#insertItem
 * @function
 */

/**
 * Adds some item <code>oItem</code> 
 * to the aggregation named <code>items</code>.
 *
 * @param {sap.ui.core.Item}
 *            oItem the item to add; if empty, nothing is inserted
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#addItem
 * @function
 */

/**
 * Removes an item from the aggregation named <code>items</code>.
 *
 * @param {int | string | sap.ui.core.Item} vItem the item to remove or its index or id
 * @return {sap.ui.core.Item} the removed item or null
 * @public
 * @name sap.ui.commons.RadioButtonGroup#removeItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>items</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Item[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.RadioButtonGroup#removeAllItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Item</code> in the aggregation named <code>items</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Item}
 *            oItem the item whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.commons.RadioButtonGroup#indexOfItem
 * @function
 */
	

/**
 * Destroys all the items in the aggregation 
 * named <code>items</code>.
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#destroyItems
 * @function
 */


/**
 * Binder for aggregation <code>items</code>.
 *
 * @param {string} sPath path to a list in the model 
 * @param {sap.ui.core.Element} oTemplate the control template for this aggregation
 * @param {sap.ui.model.Sorter} oSorter the initial sort order (optional)
 * @param {array} aFilters the predefined filters for this aggregation (optional)
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#bindItems
 * @function
 */

/**
 * Unbinder for aggregation <code>items</code>.
 *
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#unbindItems
 * @function
 */


/**
 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getAriaDescribedBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaDescribedBy
 *    Id of a ariaDescribedBy which becomes an additional target of this <code>ariaDescribedBy</code> association.
 *    Alternatively, a ariaDescribedBy instance may be given. 
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#addAriaDescribedBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaDescribedBy the ariaDescribedBy to remove or its index or id
 * @return {string} the id of the removed ariaDescribedBy or null
 * @public
 * @name sap.ui.commons.RadioButtonGroup#removeAriaDescribedBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.RadioButtonGroup#removeAllAriaDescribedBy
 * @function
 */

	
/**
 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
 * 
 * @return {string[]}
 * @public
 * @name sap.ui.commons.RadioButtonGroup#getAriaLabelledBy
 * @function
 */

	
/**
 *
 * @param {string | sap.ui.core.Control} vAriaLabelledBy
 *    Id of a ariaLabelledBy which becomes an additional target of this <code>ariaLabelledBy</code> association.
 *    Alternatively, a ariaLabelledBy instance may be given. 
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#addAriaLabelledBy
 * @function
 */

/**
 * @param {int | string | sap.ui.core.Control} vAriaLabelledBy the ariaLabelledBy to remove or its index or id
 * @return {string} the id of the removed ariaLabelledBy or null
 * @public
 * @name sap.ui.commons.RadioButtonGroup#removeAriaLabelledBy
 * @function
 */

/**
 * @return {string[]} an array with the ids of the removed elements (might be empty)
 * @public
 * @name sap.ui.commons.RadioButtonGroup#removeAllAriaLabelledBy
 * @function
 */

	
/**
 * Event is fired when selection is changed by user interaction.
 *
 * @name sap.ui.commons.RadioButtonGroup#select
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.selectedIndex Index of the selected RadioButton.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'select' event of this <code>sap.ui.commons.RadioButtonGroup</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.commons.RadioButtonGroup</code>.<br/> itself. 
 *  
 * Event is fired when selection is changed by user interaction.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.commons.RadioButtonGroup</code>.<br/> itself.
 *
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#attachSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'select' event of this <code>sap.ui.commons.RadioButtonGroup</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.commons.RadioButtonGroup#detachSelect
 * @function
 */

/**
 * Fire event select to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'selectedIndex' of type <code>int</code> Index of the selected RadioButton.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.commons.RadioButtonGroup} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.commons.RadioButtonGroup#fireSelect
 * @function
 */


/**
 * Returns selected item. When no item is selected, "null" is returned.
 *
 * @name sap.ui.commons.RadioButtonGroup#getSelectedItem
 * @function
 * @type sap.ui.core.Item
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Sets the item as seleced and removs the selection from the old one.
 *
 * @name sap.ui.commons.RadioButtonGroup#setSelectedItem
 * @function
 * @param {sap.ui.core.Item} oItem
 *         Selected item.
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\commons\RadioButtonGroup.js
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained


sap.ui.commons.RadioButtonGroup.prototype.exit = function() {
	this.destroyItems(); // or Element.exit should call the typed destroyXYZ methods?
	// sap.ui.core.Control.prototype.exit.apply(this); // does not exist!

	if (this.oItemNavigation) {
		this.removeDelegate(this.oItemNavigation);
		this.oItemNavigation.destroy();
		delete this.oItemNavigation;
	}

};

sap.ui.commons.RadioButtonGroup.prototype.onBeforeRendering = function() {
	if(this.getSelectedIndex() > this.getItems().length){
		// SelectedIndex is > than number of items -> select the first one
		jQuery.sap.log.warning("Invalid index, set to 0");
		this.setSelectedIndex(0);
	};
};

sap.ui.commons.RadioButtonGroup.prototype.onAfterRendering = function() {

	this.initItemNavigation();

	// update ARIA information of RadioButtons
	for(var i = 0; i < this.aRBs.length; i++){
		this.aRBs[i].$().attr("aria-posinset", i+1).attr("aria-setsize", this.aRBs.length);
	}
};

/*
 * initialize ItemNavigation. Transfer RadioButtons to ItemNavigation.
 * TabIndexes are set by ItemNavigation
 * @private
 */
sap.ui.commons.RadioButtonGroup.prototype.initItemNavigation = function(){

	// Collect items for ItemNavigation
	var aDomRefs = [];
	this._aActiveItems = [];
	var aActiveItems = this._aActiveItems;
	var bEnabled = false;
	for (var i=0; i < this.aRBs.length; i++) {
		aActiveItems[aDomRefs.length] = i;
		aDomRefs.push(this.aRBs[i].getDomRef());
		if (!bEnabled && this.aRBs[i].getEnabled()) {
			// at least one RadioButton is enabled
			bEnabled = true;
		}
	}

	if (bEnabled) {
		// at least one RadioButton enabled -> use property of RadioButtonGroup
		// so if all RadioButtons are disabled the RadioButtonGroup is disabled too.
		bEnabled = this.getEnabled();
	}

	if (!bEnabled) {
		// RadioButtonGroup is disabled -> no ItemNavigation
		if (this.oItemNavigation) {
			this.removeDelegate(this.oItemNavigation);
			this.oItemNavigation.destroy();
			delete this.oItemNavigation;
		}
		return;
	}

	// init ItemNavigation
	if (!this.oItemNavigation) {
		this.oItemNavigation = new sap.ui.core.delegate.ItemNavigation();
		this.oItemNavigation.attachEvent(sap.ui.core.delegate.ItemNavigation.Events.AfterFocus, this._handleAfterFocus, this);
		this.addDelegate(this.oItemNavigation);
	}
	this.oItemNavigation.setRootDomRef(this.getDomRef());
	this.oItemNavigation.setItemDomRefs(aDomRefs);
	this.oItemNavigation.setCycling(true);
	this.oItemNavigation.setColumns(this.getColumns());
	this.oItemNavigation.setSelectedIndex(this.getSelectedIndex());
	this.oItemNavigation.setFocusedIndex(this.getSelectedIndex());
};

/*
 * Set selected RadioButton via Index
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.setSelectedIndex = function(iSelectedIndex) {

	var iIndexOld = this.getSelectedIndex();

	if (iSelectedIndex < 0) {
		// invalid negative index -> don't change index.
		jQuery.sap.log.warning("Invalid index, will not be changed");
		return this;
	}

	this.setProperty("selectedIndex", iSelectedIndex, true); // no re-rendering

	// deselect old RadioButton
	if( !isNaN(iIndexOld) && this.aRBs && this.aRBs[iIndexOld]){
		this.aRBs[iIndexOld].setSelected(false);
	}

	// select new one
	if(this.aRBs && this.aRBs[iSelectedIndex]){
		this.aRBs[iSelectedIndex].setSelected(true);
	}

	if(this.oItemNavigation){
		this.oItemNavigation.setSelectedIndex(iSelectedIndex);
		this.oItemNavigation.setFocusedIndex(iSelectedIndex);
	}

	return this;

};

/*
 * Set selected RadioButton via Item
 * @param {sap.ui.core.Item} oSelectedItem the item to be selected.
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.setSelectedItem = function(iSelectedItem) {

	for (var i = 0; i < this.getItems().length; i++){
		if(iSelectedItem.getId() == this.getItems()[i].getId()){
			this.setSelectedIndex(i);
			break;
		}
	}
};

/*
 * Get item of selected RadioButton
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.getSelectedItem = function() {

	return this.getItems()[this.getSelectedIndex()];

};

/*
 * Adds a new Item
 * If an item is added a new RadioButton must be added
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.addItem = function(oItem) {

	this.myChange = true;
	this.addAggregation("items", oItem);
	this.myChange = undefined;

	if(this.getSelectedIndex() === undefined){
		// if not defined -> select first one
		this.setSelectedIndex(0);
	}
	if(!this.aRBs){
		this.aRBs = [];
	}

	var iIndex = this.aRBs.length;

	this.aRBs[iIndex] = this.createRadioButton(oItem, iIndex);

	return this;
};

/*
 * Inserts a new Item
 * If an item is inserted a new RadioButton must be inserted
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.insertItem = function(oItem, iIndex) {

	this.myChange = true;
	this.insertAggregation("items", oItem, iIndex);
	this.myChange = undefined;

	if(!this.aRBs){
		this.aRBs = [];
	}

	var iLength = this.aRBs.length;

	if(this.getSelectedIndex() === undefined || iLength == 0){
		// if not defined -> select first one
		this.setSelectedIndex(0);
	}else if(this.getSelectedIndex() >= iIndex){
		// If inserted before selected one, move selection index (only change parameter, not RadioButton)
		this.setProperty("selectedIndex", this.getSelectedIndex() + 1, true); // no re-rendering
	}

	if( iIndex >= iLength){
		this.aRBs[iIndex] = this.createRadioButton(oItem, iIndex);
	}else{
		// Insert RadioButton: loop backwards over Array and shift everything
		for (var i = (iLength); i > iIndex; i--) {
			this.aRBs[i] = this.aRBs[i-1];
			if((i-1) == iIndex){
				this.aRBs[i-1] = this.createRadioButton(oItem, iIndex);
			}
		}
	}

	return this;

};

/*
 * create RadioButton for an item
 * @private
 */
sap.ui.commons.RadioButtonGroup.prototype.createRadioButton = function(oItem, iIndex){

	if(this.iIDCount == undefined){
		this.iIDCount = 0;
	}else{
		this.iIDCount++;
	}

	var oRadioButton = new sap.ui.commons.RadioButton(this.getId() + "-" + this.iIDCount);
	oRadioButton.setText(oItem.getText());
	oRadioButton.setTooltip(oItem.getTooltip());
	if (this.getEnabled()) {
		oRadioButton.setEnabled(oItem.getEnabled());
	} else {
		oRadioButton.setEnabled(false);
	}
	oRadioButton.setKey(oItem.getKey());
	oRadioButton.setTextDirection(oItem.getTextDirection());
	oRadioButton.setEditable(this.getEditable());
	oRadioButton.setGroupName(this.getId());
	oRadioButton.setValueState(this.getValueState());
	oRadioButton.setParent(this);

	if( iIndex == this.getSelectedIndex() ){
		oRadioButton.setSelected(true);
	}

	oRadioButton.attachEvent('select', this.handleRBSelect, this);

	return(oRadioButton);
};

/*
 * Removes an Item
 * If an item is removed the corresponding RadioButton must be deleted
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.removeItem = function(vElement) {
	var iIndex = vElement;
	if (typeof(vElement) == "string") { // ID of the element is given
		vElement = sap.ui.getCore().byId(vElement);
	}
	if (typeof(vElement) == "object") { // the element itself is given or has just been retrieved
		iIndex = this.indexOfItem(vElement);
	}

	this.myChange = true;
	var oItem = this.removeAggregation("items", iIndex);
	this.myChange = undefined;

	if(!this.aRBs){
		this.aRBs = [];
	}

	if(!this.aRBs[iIndex]){
		// RadioButton not exists
		return null;
	}

	this.aRBs[iIndex].destroy();
	this.aRBs.splice(iIndex, 1);

	if(this.aRBs.length == 0){
		this.setSelectedIndex(undefined);
	}else if(this.getSelectedIndex() == iIndex){
		// selected one is removed -> select first one
		this.setSelectedIndex(0);
	}else{
		if(this.getSelectedIndex() > iIndex){
			// If removed before selected one, move selection index (only change parameter, not RadioButton)
			this.setProperty("selectedIndex", this.getSelectedIndex() - 1, true); // no re-rendering
		}
	}

	return oItem;
};

/*
 * Removes all items
 * If all items are removed all RadioButtons must be deleted
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.removeAllItems = function() {

	this.myChange = true;
	var aItems = this.removeAllAggregation("items");
	this.myChange = undefined;

	this.setSelectedIndex(undefined);

	if(this.aRBs){
		while(this.aRBs.length > 0){
			this.aRBs[0].destroy();
			this.aRBs.splice(0, 1);
		};
		return aItems;
	}else{
		return null;
	}

};

/*
 * destroys all items
 * If all items are destroyed all RadioButtons must be deleted
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.destroyItems = function() {

	this.myChange = true;
	this.destroyAggregation("items");
	this.myChange = undefined;

	this.setSelectedIndex(undefined);

	if(this.aRBs){
		while(this.aRBs.length > 0){
			this.aRBs[0].destroy();
			this.aRBs.splice(0, 1);
		};
	}

	return this;

};

/*
 * if invalid -> synchronize radio buttons
 * @protected
 */
sap.ui.commons.RadioButtonGroup.prototype.invalidate = function(oOrigin){

	if(oOrigin instanceof sap.ui.core.Item && this.aRBs && !this.myChange){
		// change was not done by RadioButtonGroup itself
		var aItems = this.getItems();
		for (var i = 0; i < aItems.length; i++) {
			if( aItems[i] == oOrigin){
				if(this.aRBs[i]){
					this.aRBs[i].setText(aItems[i].getText());
					this.aRBs[i].setTooltip(aItems[i].getTooltip());
					if (this.getEnabled()) {
						this.aRBs[i].setEnabled(aItems[i].getEnabled());
					} else {
						this.aRBs[i].setEnabled(false);
					}
					this.aRBs[i].setKey(aItems[i].getKey());
					this.aRBs[i].setTextDirection(aItems[i].getTextDirection());
				}
				break;
			}
		}
		if(this.getDomRef()){
			this.initItemNavigation();
		}
	}
	var oParent = this.getParent();
	if(oParent) {
		oParent.invalidate(this);
	}

};

/*
 * On SELECT event of single Radio Buttons fire Select Event for group
 * @private
 */
sap.ui.commons.RadioButtonGroup.prototype.handleRBSelect = function(oControlEvent){
	// find RadioButton in Array to get Index
	for (var i = 0; i < this.aRBs.length; i++) {
		if(this.aRBs[i].getId() == oControlEvent.getParameter("id")){
			this.setSelectedIndex(i);
			this.oItemNavigation.setSelectedIndex(i);
			this.oItemNavigation.setFocusedIndex(i);
			this.fireSelect({selectedIndex: i});
			break;
		}
	}

};

/*
 * Set all RadioButtons to Editable/ReadOnly
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.setEditable = function(bEditable){

	this.setProperty("editable", bEditable, false); // re-rendering to update ItemNavigation

	if(this.aRBs){
		for (var i = 0; i < this.aRBs.length; i++) {
			this.aRBs[i].setEditable(bEditable);
		}
	}
};

/*
 * Set all RadioButtons to Enabled/Disabled
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.setEnabled = function(bEnabled){

	this.setProperty("enabled", bEnabled, false); // re-rendering to update ItemNavigation

	if(this.aRBs){
		var aItems = this.getItems();

		for (var i = 0; i < this.aRBs.length; i++) {
			if (bEnabled) {
				this.aRBs[i].setEnabled(aItems[i].getEnabled());
			}else {
				this.aRBs[i].setEnabled(bEnabled);
			}
		}
	}

};

/*
 * Set ValueState for all RadioButtons
 * @public
 */
sap.ui.commons.RadioButtonGroup.prototype.setValueState = function(sValueState){

	this.setProperty("valueState", sValueState, false); // re-rendering to update ItemNavigation

	if(this.aRBs){
		for (var i = 0; i < this.aRBs.length; i++) {
			this.aRBs[i].setValueState(sValueState);
		}
	}
};

/*
 * Handles the event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
 * Ensures that focused element is selected
 *
 * @param {sap.ui.base.Event} oControlEvent The event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
 * @private
 */
sap.ui.commons.RadioButtonGroup.prototype._handleAfterFocus = function(oControlEvent){

	var iIndex = oControlEvent.getParameter("index");
	var oEvent = oControlEvent.getParameter("event");

	if(iIndex != this.getSelectedIndex() && !(oEvent.ctrlKey || oEvent.metaKey) && this.aRBs[iIndex].getEditable() && this.aRBs[iIndex].getEnabled()){
		// if CTRL key is used do not switch selection
		this.setSelectedIndex(iIndex);
		this.oItemNavigation.setSelectedIndex(iIndex);
		this.fireSelect({selectedIndex:iIndex});
	}
};
}; // end of sap/ui/commons/RadioButtonGroup.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RangeSliderRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RangeSlider
jQuery.sap.declare("sap.ui.commons.RangeSliderRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class RangeSlider renderer.
 * @static
 */
sap.ui.commons.RangeSliderRenderer = sap.ui.core.Renderer.extend(sap.ui.commons.SliderRenderer);

/**
 * Renders the Grip for the slider control, using the provided {@link sap.ui.fw.RenderManager}.
 * Each slider is handeled as individual single sliders for aria.
 * Min and max values are adjusted when sliders are moved.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered.
 */
sap.ui.commons.RangeSliderRenderer.renderGrip = function(oRenderManager, oSlider){
	var rm = oRenderManager;

	//Left Grip
	rm.write('<DIV');

	// Icon for grip
	rm.writeAttribute('id', oSlider.getId() + '-grip');
	if (oSlider.getEnabled()) {
		rm.writeAttribute('tabIndex', '0');
	}else{
		rm.writeAttribute('tabIndex', '-1');
	}
	rm.writeAttribute('class', 'sapUiSliGrip');
	rm.writeAttribute('title', oSlider.getValue());

	// ARIA
	rm.writeAccessibilityState(oSlider, {
		role: 'slider',
		controls: oSlider.getId() + '-grip2',
		orientation: 'horizontal',
		valuemin: oSlider.getMin(),
		valuemax: oSlider.getValue2(),
		live: 'assertive',
		disabled: !oSlider.getEditable() || !oSlider.getEnabled(),
		describedby: oSlider.getTooltip_AsString() ? (oSlider.getId()+'-Descr ' + oSlider.getAriaDescribedBy().join(" ")) : undefined
	});

	rm.write('>&#9650;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)

	//Right Grip
	rm.write('<DIV');

	// Icon for grip
	rm.writeAttribute('id', oSlider.getId() + '-grip2');
	if (oSlider.getEnabled()) {
		rm.writeAttribute('tabIndex', '0');
	}else{
		rm.writeAttribute('tabIndex', '-1');
	}
	rm.writeAttribute('class', 'sapUiSliGrip');
	rm.writeAttribute('title', oSlider.getValue2());

	// ARIA
	rm.writeAccessibilityState(oSlider, {
		role: 'slider',
		controls: oSlider.getId() + '-grip',
		orientation: 'horizontal',
		valuemin: oSlider.getValue(),
		valuemax: oSlider.getMax(),
		live: 'assertive',
		disabled: !oSlider.getEditable() || !oSlider.getEnabled(),
		describedby: oSlider.getTooltip_AsString() ? (oSlider.getId()+'-Descr ' + oSlider.getAriaDescribedBy().join(" ")) : undefined
	});

	rm.write('>&#9650;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)

};

/**
 * Adds extra code to the control (i.e. in subclasses), using the provided {@link sap.ui.fw.RenderManager}.
 *
 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered.
 */
sap.ui.commons.RangeSliderRenderer.controlAdditionalCode = function(rm, oSlider){
	rm.addClass('sapUiRSli');
};
}; // end of sap/ui/commons/RangeSliderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RatingIndicator') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.commons.RatingIndicator.
jQuery.sap.declare("sap.ui.commons.RatingIndicator");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new RatingIndicator.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEditable editable} : boolean (default: true)</li>
 * <li>{@link #getMaxValue maxValue} : int (default: 5)</li>
 * <li>{@link #getValue value} : float (default: 0)</li>
 * <li>{@link #getAverageValue averageValue} : float (default: 0)</li>
 * <li>{@link #getIconSelected iconSelected} : sap.ui.core.URI</li>
 * <li>{@link #getIconUnselected iconUnselected} : sap.ui.core.URI</li>
 * <li>{@link #getIconHovered iconHovered} : sap.ui.core.URI</li>
 * <li>{@link #getVisualMode visualMode} : sap.ui.commons.RatingIndicatorVisualMode (default: sap.ui.commons.RatingIndicatorVisualMode.Half)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getAriaDescribedBy ariaDescribedBy} : string | sap.ui.core.Control</li>
 * <li>{@link #getAriaLabelledBy ariaLabelledBy} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.commons.RatingIndicator#event:change change} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Is used to let the user do some rating on a certain topic. The amount of rating symbols can be specified, as well as the URIs to the
 * image icons which shall be used as rating symbols. When the user performs a rating, an event is fired.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.commons.RatingIndicator
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.commons.RatingIndicator", { metadata : {

	library : "sap.ui.commons",
	properties : {
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"editable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"maxValue" : {type : "int", group : "Behavior", defaultValue : 5},
		"value" : {type : "float", group : "Behavior", defaultValue : 0, bindable : "bindable"},
		"averageValue" : {type : "float", group : "Behavior", defaultValue : 0},
		"iconSelected" : {type : "sap.ui.core.URI", group : "Behavior", defaultValue : null},
		"iconUnselected" : {type : "sap.ui.core.URI", group : "Behavior", defaultValue : null},
		"iconHovered" : {type : "sap.ui.core.URI", group : "Behavior", defaultValue : null},
		"visualMode" : {type : "sap.ui.commons.RatingIndicatorVisualMode", group : "Behavior", defaultValue : sap.ui.commons.RatingIndicatorVisualMode.Half}
	},
	associations : {
		"ariaDescribedBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
		"ariaLabelledBy" : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
	},
	events : {
		"change" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.commons.RatingIndicator with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.commons.RatingIndicator.extend
 * @function
 */

sap.ui.commons.Rat