/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/Global','sap/ui/base/DataType','sap/ui/base/EventProvider','./Component','./Configuration','./Control','./Element','./ElementMetadata','./FocusHandler','./RenderManager','./ResizeHandler','./ThemeCheck','./UIArea','./tmpl/Template','jquery.sap.act','jquery.sap.dom','jquery.sap.events','jquery.sap.mobile','jquery.sap.properties','jquery.sap.resources','jquery.sap.script'],function(q,D,G,a,E,C,c,d,e,g,F,R,h,T,U,j){"use strict";var k=E.extend("sap.ui.core.Core",{constructor:function(){if(sap.ui.getCore&&sap.ui.getCore()){return sap.ui.getCore()}var t=this,l=q.sap.log,M="sap.ui.core.Core";E.apply(this);this.bBooted=false;this.bInitialized=false;this.bDomReady=false;this.aPlugins=[];this.mLibraries={};this.mResourceBundles={};this.mUIAreas={};this.oModels={};this.oEventBus=null;this.mElements={};this.mObjects={"component":{},"template":{}};this.oRootComponent=null;this.aInitListeners=[];this.bInitLegacyLib=false;l.info("Creating Core",null,M);this.oConfiguration=new c(this);if(this.oConfiguration["xx-bindingSyntax"]==="complex"){sap.ui.base.ManagedObject.bindingParser=sap.ui.base.BindingParser.complexParser}if(this.oConfiguration["xx-designMode"]==true){sap.ui.base.BindingParser._keepBindingStrings=true}g.prototype.register=function(K){t.registerElementClass(K)};e.prototype.register=function(){t.registerElement(this)};e.prototype.deregister=function(){t.deregisterElement(this)};C.prototype.register=function(){t.registerObject(this)};C.prototype.deregister=function(){t.deregisterObject(this)};j.prototype.register=function(){t.registerObject(this)};j.prototype.deregister=function(){t.deregisterObject(this)};var m=this.oConfiguration.modules;if(this.oConfiguration.getDebug()){m.unshift("sap-ui-debug")}var i=q.inArray("sap.ui.core.library",m);if(i!=0){if(i>0){m.splice(i,1)}m.unshift("sap.ui.core.library")}l.info("Declared modules: "+m,M);var o=window["sap-ui-config"];if(this.oConfiguration.themeRoot){o=o||{};o.themeroots=o.themeroots||{};o.themeroots[this.oConfiguration.getTheme()]=this.oConfiguration.themeRoot}if(o){if(o.themeroots){for(var f in o.themeroots){var n=o.themeroots[f];if(typeof n==="string"){this.setThemeRoot(f,n)}else{for(var p in n){if(p.length>0){this.setThemeRoot(f,[p],n[p])}else{this.setThemeRoot(f,n[p])}}}}}}this.sTheme=this.oConfiguration.getTheme();q(document.documentElement).addClass("sapUiTheme-"+this.sTheme);l.info("Declared theme "+this.sTheme,null,M);if(this.oConfiguration.getRTL()){q(document.documentElement).attr("dir","rtl");l.info("RTL mode activated",null,M)}var $=q("html");var b=D.browser;var s=b.name;if(s===b.BROWSER.CHROME){q.browser.safari=false;q.browser.chrome=true}else if(s===b.BROWSER.SAFARI){q.browser.safari=true;q.browser.chrome=false;if(b.mobile){s="m"+s}}if(s){q.browser.fVersion=b.version;q.browser.mobile=b.mobile;s=s+Math.floor(b.version);$.attr("data-sap-ui-browser",s);l.debug("Browser-Id: "+s,null,M)}$.attr("data-sap-ui-os",D.os.name+D.os.versionStr);var u=null;switch(D.os.name){case D.os.OS.IOS:u="sap-ios";break;case D.os.OS.ANDROID:u="sap-android";break;case D.os.OS.BLACKBERRY:u="sap-bb";break;case D.os.OS.WINDOWS_PHONE:u="sap-winphone";break}if(u){$.addClass(u)}if(this.oConfiguration.getWeinreId()){l.info("Starting WEINRE Remote Web Inspector");var w="<script src=\"";w+=this.oConfiguration.getWeinreServer();w+="/target/target-script-min.js#";w+=q.sap.encodeURL(this.oConfiguration.getWeinreId());w+="\"></script>";document.write(w)}sap.ui.getCore=q.sap.getter(this.getInterface());R.initHTML5Support();this.oRenderManager=new R();var S=q.sap.syncPoint("UI5 Document Ready",function(O,K){t.handleLoad()});var v=S.startTask("document.ready");var x=S.startTask("preload and boot");q(function(){l.trace("document is ready");S.finishTask(v)});var y=q.sap.syncPoint("UI5 Core Preloads and Bootstrap Script",function(O,K){l.trace("Core loaded: open="+O+", failures="+K);t._boot();S.finishTask(x)});var z=this.oConfiguration["xx-bootTask"];if(z){var A=y.startTask("custom boot task");z(function(K){y.finishTask(A,typeof K==="undefined"||K===true)})}var B=new q.sap.Version(this.oConfiguration.getCompatibilityVersion("flexBoxPolyfill"));if(B.compareTo("1.16")>=0){q.support.useFlexBoxPolyfill=false}else if(!q.support.flexBoxLayout&&!q.support.newFlexBoxLayout&&!q.support.ie10FlexBoxLayout){q.support.useFlexBoxPolyfill=true}else{q.support.useFlexBoxPolyfill=false}var H=y.startTask("bootstrap script");this.boot=function(){if(this.bBooted){return}this.bBooted=true;y.finishTask(H)};var P=this.oConfiguration.preload;if(window["sap-ui-debug"]){P=""}if(P==="auto"){P=(window["sap-ui-optimized"]&&!this.oConfiguration['xx-loadAllMode'])?"sync":""}this.oConfiguration.preload=P;if(P==="sync"||P==="async"){var I=P!=="sync";q.each(m,function(i,K){if(K.match(/\.library$/)){q.sap.preloadModules(K+"-preload",I,y)}})}var J=this.oConfiguration.getAppCacheBuster();if(J&&J.length>0){q.sap.require("sap.ui.core.AppCacheBuster");sap.ui.core.AppCacheBuster.boot(y)}},metadata:{publicMethods:["boot","isInitialized","isThemeApplied","attachInitEvent","attachInit","getRenderManager","createRenderManager","getConfiguration","setRoot","createUIArea","getUIArea","getUIDirty","getElementById","getCurrentFocusedControlId","getControl","getComponent","getTemplate","lock","unlock","isLocked","attachEvent","detachEvent","applyChanges","getEventBus","applyTheme","setThemeRoot","attachThemeChanged","detachThemeChanged","getStaticAreaRef","registerPlugin","unregisterPlugin","getLibraryResourceBundle","byId","getLoadedLibraries","loadLibrary","initLibrary","includeLibraryTheme","setModel","getModel","hasModel","isMobile","attachControlEvent","detachControlEvent","attachIntervalTimer","detachIntervalTimer","attachParseError","detachParseError","fireParseError","attachValidationError","detachValidationError","fireValidationError","attachFormatError","detachFormatError","fireFormatError","attachValidationSuccess","detachValidationSuccess","fireValidationSuccess","attachLocalizationChanged","detachLocalizationChanged","attachLibraryChanged","detachLibraryChanged","isStaticAreaRef","createComponent","getRootComponent","getApplication"]}});k.M_EVENTS={ControlEvent:"ControlEvent",UIUpdated:"UIUpdated",ThemeChanged:"ThemeChanged",LocalizationChanged:"localizationChanged",LibraryChanged:"libraryChanged",ValidationError:"validationError",ParseError:"parseError",FormatError:"formatError",ValidationSuccess:"validationSuccess"};k.prototype._boot=function(){this.lock();var b=this.oConfiguration['xx-preloadLibCss'];if(b.length>0){var A=b[0].slice(0,1)==="!";if(A){b[0]=b[0].slice(1)}if(b[0]==="*"){b.splice(0,1);var p=0;q.each(this.oConfiguration.modules,function(i,f){var m=f.match(/^(.*)\.library$/);if(m){b.splice(p,0,m[1])}})}if(!A){this.includeLibraryTheme("sap-ui-merged",undefined,"?l="+b.join(","))}}var t=this;q.each(this.oConfiguration.modules,function(i,f){var m=f.match(/^(.*)\.library$/);if(m){t.loadLibrary(m[1])}else{q.sap.require(f)}});this.unlock()};k.prototype.applyTheme=function(t,s){t=this.oConfiguration._normalizeTheme(t,s);if(s){this.setThemeRoot(t,s)}if(t&&this.sTheme!=t){var b=this.sTheme;this._updateThemeUrls(t);this.sTheme=t;this.oConfiguration._setTheme(t);q(document.documentElement).removeClass("sapUiTheme-"+b).addClass("sapUiTheme-"+t);if(this.oThemeCheck){this.oThemeCheck.fireThemeChangedEvent(false,true)}}};k.prototype._updateThemeUrls=function(t){var b=this,s=this.oConfiguration.getRTL()?"-RTL":"";q("link[id^=sap-ui-theme-]").each(function(){var l=this.id.slice(13),L=this.href.slice(this.href.lastIndexOf("/")+1),S="library",H,p,$=q(this);if((p=l.indexOf("-["))>0){S+=l.slice(p+2,-1);l=l.slice(0,p)}if(L===(S+".css")||L===(S+"-RTL.css")){L=S+s+".css"}if($.attr("sap-ui-css-count")){$.remove()}H=b._getThemePath(l,t)+L;if(H!=this.href){this.href=H;$.removeAttr("sap-ui-ready")}})};k.prototype._getThemePath=function(l,t){if(this._mThemeRoots){var p=this._mThemeRoots[t+" "+l]||this._mThemeRoots[t];if(p){p=p+l.replace(/\./g,"/")+"/themes/"+t+"/";q.sap.registerModulePath(l+".themes."+t,p);return p}}return q.sap.getModulePath(l+".themes."+t,"/")};k.prototype.setThemeRoot=function(t,l,s){if(!this._mThemeRoots){this._mThemeRoots={}}if(s===undefined){s=l;l=undefined}s=s+(s.slice(-1)=="/"?"":"/");if(l){for(var i=0;i<l.length;i++){var b=l[i];this._mThemeRoots[t+" "+b]=s}}else{this._mThemeRoots[t]=s}return this};k.prototype.init=function(){if(this.bInitialized){return}var b=q.sap.log,M="sap.ui.core.Core.init()";this.boot();b.info("Initializing",null,M);this.oFocusHandler=new F(document.body,this);this.oResizeHandler=new h(this);this.oThemeCheck=new T(this);b.info("Initialized",null,M);this.bInitialized=true;b.info("Starting Plugins",null,M);this.startPlugins();b.info("Plugins started",null,M);var o=this.oConfiguration;if(o.areas){for(var i=0,l=o.areas.length;i<l;i++){this.createUIArea(o.areas[i])}o.areas=undefined}if(o.onInit){if(typeof o.onInit==="function"){o.onInit()}else{q.sap.globalEval(o.onInit)}o.onInit=undefined}this.oThemeCheck.fireThemeChangedEvent(true);var s=o.getRootComponent();if(s){b.info("Loading Root Component: "+s,null,M);var m=sap.ui.component({name:s});this.oRootComponent=m;var n=o["xx-rootComponentNode"];if(n&&m instanceof sap.ui.core.UIComponent){var p=q.sap.domById(n);if(p){b.info("Creating ComponentContainer for Root Component: "+s,null,M);var t=new sap.ui.core.ComponentContainer({component:m,propagateModel:true});t.placeAt(p)}}}else{var A=o.getApplication();if(A){b.warning("The configuration 'application' is deprecated. Please use the configuration 'component' instead! Please migrate from sap.ui.app.Application to sap.ui.core.Component.");b.info("Loading Application: "+A,null,M);q.sap.require(A);var u=q.sap.getObject(A);var v=new u();}}var w=this.aInitListeners;this.aInitListeners=undefined;if(w&&w.length>0){b.info("Fire Loaded Event",null,M);q.each(w,function(i,f){f()})}this.renderPendingUIUpdates()};k.prototype.handleLoad=function(){this.bDomReady=true;var w=this.isLocked();if(!w){this.lock()}this.init();if(!w){this.unlock()}};k.prototype.isInitialized=function(){return this.bInitialized};k.prototype.isThemeApplied=function(){return T.themeLoaded};k.prototype.attachInitEvent=function(f){if(this.aInitListeners){this.aInitListeners.push(f)}};k.prototype.attachInit=function(f){if(this.aInitListeners){this.aInitListeners.push(f)}else{f()}};k.prototype.lock=function(){this.bLocked=true};k.prototype.unlock=function(){this.bLocked=false};k.prototype.isLocked=function(){return this.bLocked};k.prototype.getConfiguration=function(){return this.oConfiguration};k.prototype.getRenderManager=function(){return this.createRenderManager()};k.prototype.createRenderManager=function(){return(new R()).getInterface()};k.prototype.getCurrentFocusedControlId=function(){if(!this.isInitialized()){throw new Error("Core must be initialized")}return this.oFocusHandler.getCurrentFocusedControlId()};k.prototype.loadLibrary=function(l,u){if(!this.mLibraries[l]){var m=l+".library",A;if(u){q.sap.registerModulePath(l,u)}if(this.oConfiguration['xx-loadAllMode']&&!q.sap.isDeclared(m)){A=m+"-all";q.sap.log.debug("load all-in-one file "+A);q.sap.require(A)}else if(this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async'){q.sap.preloadModules(m+"-preload",false)}q.sap.require(m);if(!this.mLibraries[l]){q.sap.log.warning("library "+l+" didn't initialize itself");this.initLibrary(l)}if(this.oThemeCheck&&this.isInitialized()){this.oThemeCheck.fireThemeChangedEvent(true)}}return this.mLibraries[l]};k.prototype.createComponent=function(v,u,i,s){if(typeof v==="string"){v={name:v,url:u};if(typeof i==="object"){v.settings=i}else{v.id=i;v.settings=s}}return sap.ui.component(v)};k.prototype.getRootComponent=function(){return this.oRootComponent};k.prototype.initLibrary=function(l){var L=typeof l==="string",o=L?{name:l}:l,s=o.name,b=q.sap.log,M="sap.ui.core.Core.initLibrary()";if(L){b.warning("[Deprecated] library "+s+" uses old fashioned initLibrary() call (rebuild with newest generator)")}if(!s||this.mLibraries[s]){return}b.debug("Analyzing Library "+s,null,M);this.mLibraries[s]=o=q.extend({dependencies:[],types:[],interfaces:[],controls:[],elements:[]},o);function f(){var p=q.sap.properties({url:sap.ui.resource(s,"library.properties")});o.version=p.getProperty(s+"[version]");var t=p.getProperty(s+"[dependencies]");b.debug("Required Libraries: "+t,null,M);o.dependencies=(t&&t.split(/[,;| ]/))||[];var K=p.getKeys(),u=/(.+)\.(type|interface|control|element)$/,v;for(var i=0;i<K.length;i++){var w=p.getProperty(K[i]);if(v=w.match(u)){o[v[2]+"s"].push(K[i])}}}if(L){f()}for(var i=0;i<o.dependencies.length;i++){var m=o.dependencies[i];b.debug("resolve Dependencies to "+m,null,M);if(!this.mLibraries[m]){b.warning("Dependency from "+s+" to "+m+" has not been resolved by library itself",null,M);this.loadLibrary(m)}}a.registerInterfaceTypes(o.interfaces);var n=o.controls.concat(o.elements);for(var i=0;i<n.length;i++){sap.ui.lazyRequire(n[i],"new extend getMetadata")}if(!o.noLibraryCSS&&q.inArray(s,this.oConfiguration['xx-preloadLibCss'])<0){this.includeLibraryTheme(s)}o.sName=o.name;o.aControls=o.controls;if(!q.sap.isDeclared(s+".library")){b.warning("Library Module "+s+".library"+" not loaded automatically",null,M);q.sap.require(s+".library")}this.fireLibraryChanged({name:s,stereotype:"library",operation:"add",metadata:o})};k.prototype.includeLibraryTheme=function(l,v,Q){if((l!="sap.ui.legacy")&&(l!="sap.ui.classic")){if(!v){v=""}var s=(this.oConfiguration.getRTL()?"-RTL":"");var L,b=l+(v.length>0?"-["+v+"]":v);if(l&&l.indexOf(":")==-1){L="library"+v+s}else{L=l.substring(l.indexOf(":")+1)+v;l=l.substring(0,l.indexOf(":"))}var f=this._getThemePath(l,this.sTheme)+L+".css"+(Q?Q:"");q.sap.log.info("Including "+f+" -  sap.ui.core.Core.includeLibraryTheme()");q.sap.includeStyleSheet(f,"sap-ui-theme-"+b);if(sap.ui.core.theming&&sap.ui.core.theming.Parameters){sap.ui.core.theming.Parameters._addLibraryTheme(b)}}};k.prototype.getLoadedLibraries=function(){return q.extend({},this.mLibraries)};k.prototype.getLibraryResourceBundle=function(l,L){l=l||"sap.ui.core";L=L||this.getConfiguration().getLanguage();var K=l+"/"+L;if(!this.mResourceBundles[K]){var u=sap.ui.resource(l,'messagebundle.properties');this.mResourceBundles[K]=q.sap.resources({url:u,locale:L})}return this.mResourceBundles[K]};k.prototype.setRoot=function(o,b){if(b){b.placeAt(o,"only")}};k.prototype.createUIArea=function(o){var t=this;if(!o){throw new Error("oDomRef must not be null")}if(typeof(o)==="string"){var i=o;o=q.sap.domById(o);if(!o){throw new Error("DOM element with ID '"+i+"' not found in page, but application tries to insert content.")}}if(!o.id||o.id.length==0){o.id=q.sap.uid()}var I=o.id;if(!this.mUIAreas[I]){this.mUIAreas[I]=new U(this,o);q.each(this.oModels,function(n,m){t.mUIAreas[I].oPropagatedProperties.oModels[n]=m});this.mUIAreas[I].propagateProperties(true)}else{this.mUIAreas[I].setRootNode(o)}return this.mUIAreas[I]};k.prototype.getUIArea=function(o){var i="";if(typeof(o)=="string"){i=o}else{i=o.id}if(i){return this.mUIAreas[i]}return null};var r=U._oRenderLog;k.prototype.addInvalidatedUIArea=function(u){if(!this._sRerenderTimer){r.debug("Registering timer for delayed re-rendering");this._sRerenderTimer=q.sap.delayedCall(0,this,"renderPendingUIUpdates")}};k.MAX_RENDERING_ITERATIONS=20;k.prototype.renderPendingUIUpdates=function(){r.debug("Render pending UI updates: start");q.sap.measure.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");var u=false,l=k.MAX_RENDERING_ITERATIONS>0,L=0;this._bRendering=true;do{if(l){L++;if(L>k.MAX_RENDERING_ITERATIONS){this._bRendering=false;throw new Error("Rendering has been re-started too many times ("+L+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.")}if(L>1){r.debug("Render pending UI updates: iteration "+L)}}if(this._sRerenderTimer){q.sap.clearDelayedCall(this._sRerenderTimer);this._sRerenderTimer=undefined}var m=this.mUIAreas;for(var i in m){u=m[i].rerender()||u}}while(l&&this._sRerenderTimer);this._bRendering=false;if(u){this.fireUIUpdated()}r.debug("Render pending UI updates: finished");q.sap.measure.end("renderPendingUIUpdates")};k.prototype.getUIDirty=function(){return!!(this._sRerenderTimer||this._bRendering)};k.prototype.attachUIUpdated=function(f,l){this.attachEvent(k.M_EVENTS.UIUpdated,f,l)};k.prototype.detachUIUpdated=function(f,l){this.detachEvent(k.M_EVENTS.UIUpdated,f,l)};k.prototype.fireUIUpdated=function(p){this.fireEvent(k.M_EVENTS.UIUpdated,p)};k.prototype.attachThemeChanged=function(f,l){this.attachEvent(k.M_EVENTS.ThemeChanged,f,l)};k.prototype.detachThemeChanged=function(f,l){this.detachEvent(k.M_EVENTS.ThemeChanged,f,l)};k.prototype.fireThemeChanged=function(p){q.sap.scrollbarSize(true);if(sap.ui.core.theming&&sap.ui.core.theming.Parameters){sap.ui.core.theming.Parameters.reset(true)}var s=k.M_EVENTS.ThemeChanged;var o=q.Event(s);o.theme=p?p.theme:null;q.each(this.mElements,function(i,b){b._handleEvent(o)});q.sap.act.refresh();this.fireEvent(s,p)};k.prototype.attachLocalizationChanged=function(f,l){this.attachEvent(k.M_EVENTS.LocalizationChanged,f,l)};k.prototype.detachLocalizationChanged=function(f,l){this.detachEvent(k.M_EVENTS.LocalizationChanged,f,l)};k.prototype.fireLocalizationChanged=function(m){var t=this,s=k.M_EVENTS.LocalizationChanged,b=q.Event(s,{changes:m}),A=sap.ui.base.ManagedObject._handleLocalizationChange,f=[];q.each(m,function(i,v){f.push(i)});q.sap.log.info("localization settings changed: "+f.join(","),null,"sap.ui.core.Core");q.each(this.oModels,function(N,M){if(M&&M._handleLocalizationChange){M._handleLocalizationChange()}});function n(p){q.each(this.mUIAreas,function(){A.call(this,p)});q.each(this.mObjects["component"],function(){A.call(this,p)});q.each(this.mElements,function(){A.call(this,p)})}n.call(this,1);n.call(this,2);if(m.rtl!=undefined){q(document.documentElement).attr("dir",m.rtl?"rtl":"ltr");this._updateThemeUrls(this.sTheme);q.each(this.mUIAreas,function(){this.invalidate()});q.sap.log.info("RTL mode "+m.rtl?"activated":"deactivated")}q.each(this.mElements,function(i,o){this._handleEvent(b)});this.fireEvent(s,{changes:m})};k.prototype.attachLibraryChanged=function(f,l){this.attachEvent(k.M_EVENTS.LibraryChanged,f,l)};k.prototype.detachLibraryChanged=function(f,l){this.detachEvent(k.M_EVENTS.LibraryChanged,f,l)};k.prototype.fireLibraryChanged=function(p){this.fireEvent(k.M_EVENTS.LibraryChanged,p)};k.prototype.applyChanges=function(){this.renderPendingUIUpdates()};k.prototype.registerElementClass=function(m){var n=m.getName(),l=m.getLibraryName()||"",L=this.mLibraries[l],b=d.prototype.isPrototypeOf(m.getClass().prototype),f=false;if(!L){L=this.mLibraries[l]={dependencies:[],types:[],interfaces:[],controls:[],elements:[]}}if(b){if(q.inArray(n,L.controls)<0){L.controls.push(n);f=true}}else{if(q.inArray(n,L.elements)<0){L.elements.push(n);f=true}}if(f){q.sap.log.debug("Class "+m.getName()+" registered for library "+m.getLibraryName());this.fireLibraryChanged({name:m.getName(),stereotype:m.getStereotype(),operation:"add",metadata:m})}};k.prototype.registerElement=function(o){var b=this.byId(o.getId());if(b&&b!==o){if(this.oConfiguration.getNoDuplicateIds()){q.sap.log.error("adding element with duplicate id '"+o.getId()+"'");throw new Error("Error: adding element with duplicate id '"+o.getId()+"'")}else{q.sap.log.warning("adding element with duplicate id '"+o.getId()+"'")}}this.mElements[o.getId()]=o};k.prototype.deregisterElement=function(o){delete this.mElements[o.getId()]};k.prototype.registerObject=function(o){var i=o.getId(),t=o.getMetadata().getStereotype(),b=this.getObject(t,i);if(b&&b!==o){q.sap.log.error("adding object \""+t+"\" with duplicate id '"+i+"'");throw new Error("Error: adding object \""+t+"\" with duplicate id '"+i+"'")}this.mObjects[t][i]=o};k.prototype.deregisterObject=function(o){var i=o.getId(),t=o.getMetadata().getStereotype();delete this.mObjects[t][i]};k.prototype.byId=function(i){return i==null?undefined:this.mElements[i]};k.prototype.getControl=k.prototype.byId;k.prototype.getElementById=k.prototype.byId;k.prototype.getObject=function(t,i){return i==null?undefined:this.mObjects[t]&&this.mObjects[t][i]};k.prototype.getComponent=function(i){return this.getObject("component",i)};k.prototype.getTemplate=function(i){return this.getObject("template",i)};k.prototype.getStaticAreaRef=function(){var s="sap-ui-static";var S=q.sap.domById(s);if(!S){if(!this.bDomReady){throw new Error("DOM is not ready yet. Static UIArea cannot be created.")}var l=this.getConfiguration().getRTL()?"right":"left";S=q("<DIV/>",{id:s}).css({"height":"0","width":"0","overflow":"hidden","float":l}).prependTo(document.body)[0];this.createUIArea(S).bInitial=false}return S};k.prototype.isStaticAreaRef=function(o){return o&&(o.id==="sap-ui-static")};k._I_INTERVAL=200;h.prototype.I_INTERVAL=k._I_INTERVAL;k.prototype.attachIntervalTimer=function(f,l){if(!this.oTimedTrigger){q.sap.require("sap.ui.core.IntervalTrigger");this.oTimedTrigger=new sap.ui.core.IntervalTrigger(k._I_INTERVAL)}this.oTimedTrigger.addListener(f,l)};k.prototype.detachIntervalTimer=function(f,l){if(this.oTimedTrigger){this.oTimedTrigger.removeListener(f,l)}};k.prototype.attachControlEvent=function(f,l){this.attachEvent(k.M_EVENTS.ControlEvent,f,l)};k.prototype.detachControlEvent=function(f,l){this.detachEvent(k.M_EVENTS.ControlEvent,f,l)};k.prototype.fireControlEvent=function(p){this.fireEvent(k.M_EVENTS.ControlEvent,p)};k.prototype._handleControlEvent=function(o,u){var b=q.Event(o.type);q.extend(b,o);b.originalEvent=undefined;this.fireControlEvent({"browserEvent":b,"uiArea":u})};k.prototype.getApplication=function(){return sap.ui.getApplication&&sap.ui.getApplication()};k.prototype.registerPlugin=function(p){if(!p){return}for(var i=0,l=this.aPlugins.length;i<l;i++){if(this.aPlugins[i]===p){return}}this.aPlugins.push(p);if(this.bInitialized&&p&&p.startPlugin){p.startPlugin(this)}};k.prototype.unregisterPlugin=function(p){if(!p){return}var P=-1;for(var i=this.aPlugins.length;i--;i>=0){if(this.aPlugins[i]===p){P=i;break}}if(P==-1){return}if(this.bInitialized&&p&&p.stopPlugin){p.stopPlugin(this)}this.aPlugins.splice(P,1)};k.prototype.startPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.startPlugin){p.startPlugin(this,true)}}};k.prototype.stopPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.stopPlugin){p.stopPlugin(this)}}};k.prototype.setModel=function(m,n){if(!m&&this.oModels[n]){delete this.oModels[n];q.each(this.mUIAreas,function(i,u){delete u.oPropagatedProperties.oModels[n];u.propagateProperties(n)})}else if(m&&m!==this.oModels[n]){this.oModels[n]=m;q.each(this.mUIAreas,function(i,u){u.oPropagatedProperties.oModels[n]=m;u.propagateProperties(n)})}else{}return this};k.prototype.getModel=function(n){return this.oModels[n]};k.prototype.hasModel=function(){return!q.isEmptyObject(this.oModels)};k.prototype.getEventBus=function(){if(!this.oEventBus){q.sap.require("sap.ui.core.EventBus");this.oEventBus=new sap.ui.core.EventBus()}return this.oEventBus};k.prototype.attachValidationError=function(f,l){this.attachEvent(k.M_EVENTS.ValidationError,f,l);return this};k.prototype.detachValidationError=function(f,l){this.detachEvent(k.M_EVENTS.ValidationError,f,l);return this};k.prototype.attachParseError=function(f,l){this.attachEvent(k.M_EVENTS.ParseError,f,l);return this};k.prototype.detachParseError=function(f,l){this.detachEvent(k.M_EVENTS.ParseError,f,l);return this};k.prototype.attachFormatError=function(f,l){this.attachEvent(k.M_EVENTS.FormatError,f,l);return this};k.prototype.detachFormatError=function(f,l){this.detachEvent(k.M_EVENTS.FormatError,f,l);return this};k.prototype.attachValidationSuccess=function(f,l){this.attachEvent(k.M_EVENTS.ValidationSuccess,f,l);return this};k.prototype.detachValidationSuccess=function(f,l){this.detachEvent(k.M_EVENTS.ValidationSuccess,f,l);return this};k.prototype.fireParseError=function(A){this.fireEvent(k.M_EVENTS.ParseError,A);return this};k.prototype.fireValidationError=function(A){this.fireEvent(k.M_EVENTS.ValidationError,A);return this};k.prototype.fireFormatError=function(A){this.fireEvent(k.M_EVENTS.FormatError,A);return this};k.prototype.fireValidationSuccess=function(A){this.fireEvent(k.M_EVENTS.ValidationSuccess,A);return this};k.prototype.isMobile=function(){return D.browser.mobile};if(!window.sap.ui.getCore){(function(){new k()}())}sap.ui.setRoot=function(o,b){sap.ui.getCore().setRoot(o,b)};return k},true);
