// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.table.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.table.ColumnMenuRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.table.ColumnMenuRenderer
jQuery.sap.declare("sap.ui.table.ColumnMenuRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.require('sap.ui.unified.MenuRenderer'); // unlisted dependency retained


/**
 * @class Renderer for the sap.ui.table.ColumnMenuRendere
 * @static
 */
sap.ui.table.ColumnMenuRenderer = sap.ui.core.Renderer.extend(sap.ui.unified.MenuRenderer);
}; // end of sap/ui/table/ColumnMenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TablePersoController') ) {
/*
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides TablePersoController
jQuery.sap.declare("sap.ui.table.TablePersoController");
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained


/**
 * Constructor for a new TablePersoController.
 *
 * Accepts an object literal <code>mSettings</code> that defines initial
 * property values, aggregated and associated objects as well as event handlers.
 *
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event),
 * then the framework assumes property, aggregation, association, event in that order.
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:"
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getAutoSave autoSave} : boolean (default: true)</li>
 * <li>{@link #getPersoService persoService} : any</li></ul>
 * <li>{@link #getCustomDataKey customDataKey} : string (default: "persoKey")</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * </ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getTable table} : string | sap.ui.table.Table</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * </ul>
 * </li>
 * </ul>

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The TablePersoController can be used to connect a table with a persistence service.
 * @extends sap.ui.base.ManagedObject
 *
 * @author SAP SE
 * @version 1.24.2
 * @since 1.21.1
 *
 * @constructor
 * @public
 * @name sap.ui.table.TablePersoController
 */
sap.ui.base.ManagedObject.extend("sap.ui.table.TablePersoController", /** @lends sap.ui.table.TablePersoController */ {

	constructor: function(sId, mSettings) {
		sap.ui.base.ManagedObject.apply(this, arguments);
	},

	metadata: {
		properties: {
			"autoSave": {
				type: "boolean",
				defaultValue: true
			},
			"persoService": {
				type: "any"
			},
			"customDataKey": {
				type: "string",
				defaultValue: "persoKey"
			}
		},
		associations: {
			"table": {
				type: "sap.ui.table.Table",
				multiple: false
			}
		},
		library: "sap.ui.table"
	}

});

/**
 * Creates a new subclass of class sap.ui.table.TablePersoController with name <code>sClassName</code>
 * and enriches it with the information contained in <code>oClassInfo</code>.
 *
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.base.ManagedObject.extend ManagedObject.extend}.
 *
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.TablePersoController.extend
 * @function
 */

/**
 * @function
 * @name sap.ui.table.TablePersoController.prototype.init
 * @private
 */
sap.ui.table.TablePersoController.prototype.init = function() {

	// Table Personalization schema
	this._schemaProperty = "_persoSchemaVersion";
	this._schemaVersion = "1.0";

	this._oInitialPersoData = null;
	
	this._aTableEvents = ["columnResize", "columnMove", "columnVisibility", "sort", "filter", "group"];
	this._aColumnProperties = ["visible", "width", "sorted", "sortOrder", "grouped", "summed"];
	
	this._bSaveFilters = false;
	if (this._bSaveFilters) {
		this._aTableEvents.push("filter");
		this._aColumnProperties.push("filtered");
		this._aColumnProperties.push("filterValue");
	}
	
};

/**
 * @function
 * @name sap.ui.table.TablePersoController.prototype.exit
 * @private
 */
sap.ui.table.TablePersoController.prototype.exit = function() {

	var oTable = this._getTable();

	if (oTable) {
		this._manageTableEventHandlers(oTable, false);
	}

	delete this._schemaProperty;
	delete this._schemaVersion;

	delete this._oInitialPersoData;
	
	delete this._oDialog;

};

/**
 * Getter for property <code>persoService</code>.<br/>
 * Personalization Service object. Needs to have the following methods:
 * <ul>
 * <li>getPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
 * <li>setPersData(oBundle) : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
 * <li>delPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
 * </ul>
 * @return {any}
 * @public
 * @name sap.ui.table.TablePersoController#getPersoService
 * @function
 */

/**
 * Setter for property <code>persoService</code>.<br/>
 * Personalization Service object. Needs to have the following methods:
 * <ul>
 * <li>getPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
 * <li>setPersData(oBundle) : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
 * <li>delPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
 * </ul>
 *
 * @param {any} oPersoService
 * @return {sap.ui.table.TablePersoController} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TablePersoController#setPersoService
 * @function
 */
sap.ui.table.TablePersoController.prototype.setPersoService = function(oService) {
	oService = this.validateProperty("persoService", oService);
	if (oService &&
		(!jQuery.isFunction(oService.getPersData) ||
		!jQuery.isFunction(oService.setPersData) ||
		!jQuery.isFunction(oService.delPersData))) {
		throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods " +
				"\"getPersData\", \"setPersData\" and \"delPersData\".");
	}

	var oOldService = this.getPersoService();
	this.setProperty("persoService", oService, true);
	var oNewService = this.getPersoService();

	// refresh data using new service if there was a new service set and a table was set
	if (oNewService && oNewService !== oOldService && this._getTable() && (this.getAutoSave() || !oOldService )) {
		this.refresh();
	}

	return this;
};

/**
 * Getter for property <code>autoSave</code>.<br/>
 * Auto save state
 * <p>Default value is <code>true</code></p>
 *
 * @return {boolean}
 * @public
 * @name sap.ui.table.TablePersoController#getAutoSave
 * @function
 */

/**
 * Setter for property <code>autoSave</code>.
 *
 * @param {boolean} bAutoSave
 * @return {sap.ui.table.TablePersoController} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TablePersoController#setAutoSave
 * @function
 */
sap.ui.table.TablePersoController.prototype.setAutoSave = function(bAutoSave) {
	var oOldValue = this.getAutoSave();
	this.setProperty("autoSave", bAutoSave, true);
	var oNewValue = this.getAutoSave();

	// save data if autoSave is turned from false to true
	if (oNewValue && !oOldValue) {
		this.savePersonalizations();
	}

	return this;
};

/**
 * Getter for association <code>table</code>.<br/>
 *
 * @return {string} Id of the element which is the current target of the <code>table</code> association, or null
 * @public
 * @name sap.ui.table.TablePersoController#getTable
 * @function
 */

/**
 * Setter for association <code>table</code>.<br/>
 *
 * @param {string | sap.ui.table.Table} vTable
 *    Id of an element which becomes the new target of this <code>table</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.ui.table.TablePersoController} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TablePersoController#setTable
 * @function
 */
sap.ui.table.TablePersoController.prototype.setTable = function(vTable) {
	var oOldTable = this._getTable();
	if (oOldTable) {
		oOldTable._oPersoController = undefined; // remove the relationship to the controller
	}
	this.setAssociation("table", vTable, true);
	var oNewTable = this._getTable();
	if (oNewTable) {
		oNewTable._oPersoController = this; // set the relationship to controller (debugging & performance opts)
	}

	// detach handlers from old table
	if (oOldTable) {
		this._manageTableEventHandlers(oOldTable, false);
	}

	if (oNewTable && oNewTable !== oOldTable) {

		// save initial table configuration (incl. text for perso dialog)
		this._oInitialPersoData = this._getCurrentTablePersoData(true);

		// attach handlers to new table
		this._manageTableEventHandlers(oNewTable, true);

		// only refresh if there is a service set and autoSave is on or no table was set before
		if (this.getPersoService() && (this.getAutoSave() || !oOldTable )) {
			this.refresh();
		}
	} else if (!oNewTable) {
		// remove initial data if table is set to null
		this._oInitialPersoData = null;
	}

	return this;
};

/**
 * Getter for property <code>customDataKey</code>.<br/>
 * By defining a custom data key the <code>TablePersoController</code>
 * will try to get the key for saving the perso data from the custom
 * data of the Table and Column instead of creating it by concatenate 
 * the ID of the Table and the Column. Basically this will be more stable 
 * than using the auto IDs.
 *
 * <p>Default value is <code>"persoKey"</code></p>
 * 
 * @return {string}
 * @public
 * @name sap.ui.table.TablePersoController#getCustomDataKey
 * @function
 */

/**
 * Setter for property <code>customDataKey</code>.
 *
 * @param {string} sCustomDataKey
 * @return {sap.ui.table.TablePersoController} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TablePersoController#setAutoSave
 * @function
 */
sap.ui.table.TablePersoController.prototype.setCustomDataKey = function(sCustomDataKey) {
	var sOldValue = this.getCustomDataKey();
	this.setProperty("customDataKey", sCustomDataKey, true);
	var sNewValue = this.getCustomDataKey();

	// save data if the autosave is on and the perso key has been changed
	if (sOldValue !== sNewValue && this.getAutoSave()) {
		this.savePersonalizations();
	}
	
	return this;
};

sap.ui.table.TablePersoController.prototype._manageTableEventHandlers = function(oTable, bAttach) {
	// attach or detach the Table Event Handlers (necessary for autosave)
	for (var i = 0, l = this._aTableEvents.length; i < l; i++) {
		var fn = oTable[(bAttach ? "attachEvent" : "detachEvent")];
		fn.apply(oTable, [this._aTableEvents[i], this._tableEventHandler, this]);
	}
};

/**
 * Refresh the personalizations (reloads data from service).
 *
 * @return {jQuery.Promise} <code>jQuery Promise</code> which is resolved once the refresh is finished
 * @public
 * @function
 */
sap.ui.table.TablePersoController.prototype.refresh = function() {
	var that = this;

	var oService = this.getPersoService();
	if (oService) {
		return oService.getPersData().done(function(oServiceData) {
			var oData = (oServiceData && jQuery.isArray(oServiceData.aColumns))
					? oServiceData
					: that._oInitialPersoData; // use initial column definitions
			that._adjustTable(oData);
		}).fail(function() {
			jQuery.sap.log.error("Problem reading persisted personalization data.");
		});
	} else {
		jQuery.sap.log.error("The Personalization Service is not available!");
		// return a dummy promise and reject it immediately
		var oDeferred = jQuery.Deferred();
		oDeferred.reject();
		return oDeferred.promise();
	}
};

/**
 * Saves the current personalization state.
 *
 * @return {jQuery.Promise} <code>jQuery Promise</code> which is resolved once the save is finished
 * @public
 * @function
 */
sap.ui.table.TablePersoController.prototype.savePersonalizations = function() {
	var oService = this.getPersoService();
	if (oService) {

		var oData = this._getCurrentTablePersoData();
		oData[this._schemaProperty] = this._schemaVersion;

		return oService.setPersData(oData).fail(function() {
			jQuery.sap.log.error("Problem persisting personalization data.");
		});
		
	} else {
		jQuery.sap.log.error("The Personalization Service is not available!");
		// return a dummy promise and reject it immediately
		var oDeferred = jQuery.Deferred();
		oDeferred.reject();
		return oDeferred.promise();
	}
};

sap.ui.table.TablePersoController.prototype._adjustTable = function(oData) {
	var oTable = this._getTable();
	if (!oTable || !oData || !jQuery.isArray(oData.aColumns)) {
		return;
	}

	// create a persoKey to column map
	var mColumns = {}, aCols = oTable.getColumns();
	for (var i = 0, l = aCols.length; i < l; i++) {
		mColumns[this._getColumnPersoKey(aCols[i])] = aCols[i];
	}
	
	var aColumns = oData.aColumns;

	for (var i = 0, l = aColumns.length; i < l; i++) {
		var oColumnInfo = aColumns[i]; // P13N info object
		var oColumn = mColumns[oColumnInfo.id];

		// only if the column is available in the table 
		// e.g. if the Table has been removed or renamed => ignore!
		if (oColumn) {
			
			// apply the order
			if (oTable.indexOfColumn(oColumn) !== oColumnInfo.order) {
				oTable.removeColumn(oColumn);
				oTable.insertColumn(oColumn, oColumnInfo.order);
			}

			var oMetadata = oColumn.getMetadata();
			for (var j = 0, lj = this._aColumnProperties.length; j < lj; j++) {
				var sProperty = this._aColumnProperties[j];
				if (oColumnInfo[sProperty] !== undefined) {
					try {
						if (oMetadata.hasProperty(sProperty) && oColumn.getProperty(sProperty) != oColumnInfo[sProperty]) {
							oColumn.setProperty(sProperty, oColumnInfo[sProperty]);
						}
					} catch (ex) {
						jQuery.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \"" + oColumn[sProperty] + "\" for the property + \"" + sProperty + "\".");
					}
				}
			}
			
		}

	}
	
	if (typeof oTable._onPersoApplied === "function") {
		oTable._onPersoApplied();
	}
	
};

sap.ui.table.TablePersoController.prototype._tableEventHandler = function(oEvent) {
	if (this.getAutoSave() && !this._iTriggerSaveTimeout) {
		var that = this;
		this._iTriggerSaveTimeout = setTimeout(function() {
			that.savePersonalizations();
			that._iTriggerSaveTimeout = null;
		}, 0);
	}
};

sap.ui.table.TablePersoController.prototype._getCurrentTablePersoData = function(bForDialog) {
	var oTable = this._getTable(),
		aColumns = oTable.getColumns();

	var oData = {
		aColumns: []
	};

	for (var i = 0, l = aColumns.length; i < l; i++) {
		var oColumn = aColumns[i];
		var sPersoKey = this._getColumnPersoKey(oColumn);
		var oColumnInfo = {
			id: sPersoKey,
			order: i
		};
		var oMetadata = oColumn.getMetadata();
		for (var j = 0, lj = this._aColumnProperties.length; j < lj; j++) {
			var sProperty = this._aColumnProperties[j];
			if (oMetadata.hasProperty(sProperty)) {
				oColumnInfo[sProperty] = oColumn.getProperty(sProperty);
			}
		}
		if (bForDialog) {
			oColumnInfo.text = oColumn.getLabel() && oColumn.getLabel().getText() || sPersoKey;
		}
		oData.aColumns.push(oColumnInfo);
	}

	return oData;
};

sap.ui.table.TablePersoController.prototype._getTable = function() {
	return sap.ui.getCore().byId(this.getTable());
};

sap.ui.table.TablePersoController.prototype._getColumnPersoKey = function(oColumn) {
	return this._getPersoKey(this._getTable()) + "-" + this._getPersoKey(oColumn);
};

sap.ui.table.TablePersoController.prototype._getPersoKey = function(oControl) {
	var sPersoKey = oControl.data(this.getCustomDataKey());
	if (!sPersoKey) {
		sPersoKey = oControl.getId();
		if (sPersoKey.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix()) === 0) {
			jQuery.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \"" + oControl.getId() + "\")");
		}
	}
	return sPersoKey;
};

/**
 * Opens the personalization dialog for the Table to modify the visibility and
 * the order of the columns.
 * 
 * <i>Using this functionality will require to load the sap.m library because the
 * personalization dialog is only available in this library for now.</i>
 * 
 * @param {object} mSettings
 * @public
 * @name sap.ui.table.TablePersoController#openDialog
 * @function
 * @experimental since 1.21.2 - API might change / feature requires the sap.m library!
 */
sap.ui.table.TablePersoController.prototype.openDialog = function(mSettings) {

	// include the mobile library to re-use the sap.m.TablePersoDialog
	sap.ui.getCore().loadLibrary("sap.m");
	jQuery.sap.require("sap.m.TablePersoDialog");
		
	// create and open the dialog
	if (!this._oDialog) {
		var that = this;
		this._oDialog = new sap.m.TablePersoDialog({
			persoService: this.getPersoService(),
			showSelectAll: true,
			showResetAll: true,
			grouping: false,
			contentWidth: mSettings && mSettings.contentWidth,
			contentHeight: mSettings && mSettings.contentHeight || "20rem",
			initialColumnState: this._oInitialPersoData.aColumns,
			columnInfoCallback: function(oTable, mPersoMap, oPersoService) {
				return that._getCurrentTablePersoData(true).aColumns;
			},
			confirm : function() {
				that._adjustTable(this.retrievePersonalizations());
				if (that.getAutoSave()) {
					that.savePersonalizations();
				}
			}
		});
		this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding"); // otherwise height calculation doesn't work properly!
		jQuery.sap.syncStyleClass("sapUiSizeCompact", this._getTable(), this._oDialog._oDialog);
	}
	
	this._oDialog.open();
	
};

}; // end of sap/ui/table/TablePersoController.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.Table
jQuery.sap.declare("sap.ui.table.TableRenderer");

/**
 * @class Table renderer.
 * @static
 */
sap.ui.table.TableRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oTable an object representation of the control that should be rendered
 */
sap.ui.table.TableRenderer.render = function(rm, oTable) {

	// return immediately if control is invisible
	if (!oTable.getVisible()) {
		return;
	}
	
	// create the rows of the table 
	// (here we could think about a swith to allow the programmatic usage of the table)
	oTable._createRows();

	// basic table div
	rm.write("<div");
	if (oTable._bAccMode) {
		var aAriaOwnsIds = [];
		if (oTable.getToolbar()) {
			aAriaOwnsIds.push(oTable.getToolbar().getId());
		}
		aAriaOwnsIds.push(oTable.getId() + "-table");
		rm.writeAttribute("aria-owns", aAriaOwnsIds.join(" "));
		rm.writeAttribute("aria-readonly", "true");
		if (oTable.getTitle()) {
			rm.writeAttribute("aria-labelledby", oTable.getTitle().getId());
		}
		if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
			rm.writeAttribute("aria-multiselectable", "true");
		}
	}
	rm.writeControlData(oTable);
	rm.addClass("sapUiTable");
	rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode());
	if (oTable.getColumnHeaderVisible()) {
		rm.addClass("sapUiTableCHdr"); // show column headers
	}
	if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
		rm.addClass("sapUiTableRSel"); // show row selector
	}
	rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode()); // row selection mode
	//rm.addClass("sapUiTableHScr"); // show horizontal scrollbar
	if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
		rm.addClass("sapUiTableVScr"); // show vertical scrollbar
	}
	if (oTable.getEditable()) {
		rm.addClass("sapUiTableEdt"); // editable (background color)
	}
	rm.addClass("sapUiTableShNoDa");
	if (oTable.getShowNoData() && oTable._getRowCount() === 0) {
		rm.addClass("sapUiTableEmpty"); // no data!
	}
	if (oTable.getEnableGrouping()) {
		rm.addClass("sapUiTableGrouping");
	}
	rm.writeClasses();
	if (oTable.getWidth()) {
		rm.addStyle("width", oTable.getWidth());
	}
	rm.writeStyles();
	rm.write(">");

	if (oTable.getTitle()) {
		this.renderHeader(rm, oTable, oTable.getTitle());
	}

	if (oTable.getToolbar()) {
		this.renderToolbar(rm, oTable, oTable.getToolbar());
	}

	if (oTable.getExtension() && oTable.getExtension().length > 0) {
		this.renderExtensions(rm, oTable, oTable.getExtension());
	}

	rm.write("<div");
	rm.addClass("sapUiTableCnt");
	rm.writeClasses();
	if (oTable._bAccMode) {
		rm.writeAttribute("aria-describedby", oTable.getId() + "-ariacount");
	}
	rm.write(">");

	this.renderColHdr(rm, oTable);

	this.renderTable(rm, oTable);

	if (oTable._bAccMode) {
		// aria description for the row count
		rm.write("<span");
		rm.writeAttribute("id", oTable.getId() + "-ariadesc");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(oTable._oResBundle.getText("TBL_TABLE"));
		rm.write("</span>");
		// aria description for the row count
		rm.write("<span");
		rm.writeAttribute("id", oTable.getId() + "-ariacount");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write("</span>");
		// aria description for toggling the edit mode
		rm.write("<span");
		rm.writeAttribute("id", oTable.getId() + "-toggleedit");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(oTable._oResBundle.getText("TBL_TOGGLE_EDIT_KEY"));
		rm.write("</span>");
		// aria description for row selection behavior with no line selected
		rm.write("<span");
		rm.writeAttribute("id", oTable.getId() + "-selectrow");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
		rm.write("</span>");
		// aria description for row selection behavior with line selected
		rm.write("<span");
		rm.writeAttribute("id", oTable.getId() + "-selectrowmulti");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));
		rm.write("</span>");
		// aria description for row deselection behavior with no line selected
		rm.write("<span");
		rm.writeAttribute("id", oTable.getId() + "-deselectrow");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_KEY"));
		rm.write("</span>");
		// aria description for row deselection behavior with line selected
		rm.write("<span");
		rm.writeAttribute("id", oTable.getId() + "-deselectrowmulti");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY"));
		rm.write("</span>");
	}

	rm.write("</div>");

	if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
		rm.write("<div");
		rm.addClass("sapUiTablePaginator");
		rm.writeClasses();
		rm.write(">");
		if (!oTable._oPaginator) {
			jQuery.sap.require("sap.ui.commons.Paginator");
			oTable._oPaginator = new sap.ui.commons.Paginator(oTable.getId() + "-paginator");
			oTable._oPaginator.attachPage(jQuery.proxy(oTable.onvscroll, oTable));
		}
		rm.renderControl(oTable._oPaginator);
		rm.write("</div>");
	}

	if (oTable.getFooter()) {
		this.renderFooter(rm, oTable, oTable.getFooter());
	}

	if (oTable.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Interactive) {
		this.renderVariableHeight(rm ,oTable);
	}

	rm.write("</div>");

};

// =============================================================================
// BASIC AREAS OF THE TABLE
// =============================================================================

sap.ui.table.TableRenderer.renderHeader = function(rm, oTable, oTitle) {
	rm.write("<div");
	rm.addClass("sapUiTableHdr");
	rm.writeClasses();
	if (oTable._bAccMode) {
		rm.writeAttribute("role", "heading");
	}
	rm.write(">");

	rm.renderControl(oTitle);

	rm.write("</div>");
};

sap.ui.table.TableRenderer.renderToolbar = function(rm, oTable, oToolbar) {
	rm.write("<div");
	rm.addClass("sapUiTableTbr");
	if (typeof oToolbar.getStandalone !== "function") {
		// for the mobile toolbar we add another class
		rm.addClass("sapUiTableMTbr");
	}
	rm.writeClasses();
	rm.write(">");

	// toolbar has to be embedded (not standalone)!
	if (typeof oToolbar.getStandalone === "function" && oToolbar.getStandalone()) {
		oToolbar.setStandalone(false);
	}

	rm.renderControl(oToolbar);

	rm.write("</div>");
};

sap.ui.table.TableRenderer.renderExtensions = function(rm, oTable, aExtensions) {
	for (var i = 0, l = aExtensions.length; i < l; i++) {
		this.renderExtension(rm, oTable, aExtensions[i]);
	}
};

sap.ui.table.TableRenderer.renderExtension = function(rm, oTable, oExtension) {
	rm.write("<div");
	rm.addClass("sapUiTableExt");
	rm.writeClasses();
	rm.write(">");
	
	rm.renderControl(oExtension);
	
	rm.write("</div>");
};

sap.ui.table.TableRenderer.renderTable = function(rm, oTable) {
	rm.write("<div");
	rm.addClass("sapUiTableCCnt");
	rm.writeClasses();
	rm.write(">");

	rm.write("<div");
	rm.addClass("sapUiTableCtrlBefore");
	rm.writeClasses();
	rm.writeAttribute("tabindex", "0");
	rm.write("></div>");
	
	this.renderRowHdr(rm, oTable);
	this.renderTableCtrl(rm, oTable);
	this.renderVSb(rm, oTable);

	rm.write("</div>");
	
	this.renderHSb(rm, oTable);
	
};

sap.ui.table.TableRenderer.renderFooter = function(rm, oTable, oFooter) {
	rm.write("<div");
	rm.addClass("sapUiTableFtr");
	rm.writeClasses();
	rm.write(">");

	rm.renderControl(oFooter);

	rm.write("</div>");
};

sap.ui.table.TableRenderer.renderVariableHeight = function(rm, oTable) {
	rm.write('<div id="' + oTable.getId() + '-sb" tabIndex="-1"');
	rm.addClass("sapUiTableSplitterBar");
	rm.addStyle("height", "5px");
	rm.writeClasses();
	rm.writeStyles();
	rm.write(">");
	rm.write("</div>");
};

// =============================================================================
// COLUMN HEADER OF THE TABLE
// =============================================================================

sap.ui.table.TableRenderer.renderColHdr = function(rm, oTable) {

	rm.write("<div");
	rm.addClass("sapUiTableColHdrCnt");
	rm.writeClasses();
	if (oTable.getColumnHeaderHeight() > 0) {
		rm.addStyle("height", (oTable.getColumnHeaderHeight() * oTable._getHeaderRowCount()) + "px");
	}
	if (oTable._bAccMode &&
		 (oTable.getSelectionMode() === sap.ui.table.SelectionMode.None ||
				 oTable.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
		rm.writeAttribute("role", "row");
	}
	rm.writeStyles();
	rm.write(">");

	this.renderColRowHdr(rm, oTable);

	var aCols = oTable.getColumns();

	if (oTable.getFixedColumnCount() > 0) {
		rm.write("<div");
		rm.addClass("sapUiTableColHdrFixed");
		rm.writeClasses();
		rm.write(">");

		for (var h = 0; h < oTable._getHeaderRowCount(); h++) {
			
			rm.write("<div");
			rm.addClass("sapUiTableColHdr");
			rm.writeClasses();
			rm.addStyle("min-width", oTable._getColumnsWidth(0, oTable.getFixedColumnCount()) + "px");
			rm.writeStyles();
			rm.write(">");

			var iSpan = 1;
			for (var i = 0, l = oTable.getFixedColumnCount(); i < l; i++) {
				if (aCols[i] && aCols[i].shouldRender()) {
					if (iSpan <= 1) {
						this.renderCol(rm, oTable, aCols[i], i, h);
						var aHeaderSpan = aCols[i].getHeaderSpan();
						if (jQuery.isArray(aHeaderSpan)) {
							iSpan = aCols[i].getHeaderSpan()[h] + 1;
						} else {
							iSpan = aCols[i].getHeaderSpan() + 1;
						}
					} else {
						//Render column header but this is invisible because of the span
						this.renderCol(rm, oTable, aCols[i], i, h, true);
					}
					if (h == 0) {
						this.renderColRsz(rm, oTable, aCols[i], i);
					}
					iSpan--;
				}
			}
	
			rm.write("<p style=\"clear: both;\"></p>");
			rm.write("</div>");

		}

		rm.write("</div>");
	}

	rm.write("<div");
	rm.addClass("sapUiTableColHdrScr");
	rm.writeClasses();
	if (oTable.getFixedColumnCount() > 0) {
		if (oTable._bRtlMode) {
			rm.addStyle("margin-right", "0");
		} else {
			rm.addStyle("margin-left", "0");
		}
		rm.writeStyles();
	}
	rm.write(">");
	
	for (var h = 0; h < oTable._getHeaderRowCount(); h++) {

		rm.write("<div");
		rm.addClass("sapUiTableColHdr");
		rm.writeClasses();
		rm.addStyle("min-width", oTable._getColumnsWidth(oTable.getFixedColumnCount(), aCols.length) + "px");
		rm.writeStyles();
		rm.write(">");

		var iSpan = 1;
		for (var i = oTable.getFixedColumnCount(), l = aCols.length; i < l; i++) {
			if (aCols[i].shouldRender()) {
				if (iSpan <= 1) {
					this.renderCol(rm, oTable, aCols[i], i, h);
					var aHeaderSpan = aCols[i].getHeaderSpan();
					if (jQuery.isArray(aHeaderSpan)) {
						iSpan = aCols[i].getHeaderSpan()[h] + 1;
					} else {
						iSpan = aCols[i].getHeaderSpan() + 1;
					}
				} else {
					//Render column header but this is invisible because of the span
					this.renderCol(rm, oTable, aCols[i], i, h, true);
				}
				if (h == 0) {
					this.renderColRsz(rm, oTable, aCols[i], i);
				}
				iSpan--;
			}
		}

		rm.write("<p style=\"clear: both;\"></p>");
		rm.write("</div>");

	}

	rm.write("</div>");

	rm.write("</div>");

};

sap.ui.table.TableRenderer.renderColRowHdr = function(rm, oTable) {
	rm.write("<div");
	rm.writeAttribute("id", oTable.getId() + "-selall");
	var oSelMode = oTable.getSelectionMode();
	if ((oSelMode == "Multi" || oSelMode == "MultiToggle") && oTable.getEnableSelectAll()) {
		rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_SELECT_ALL"));
		rm.addClass("sapUiTableSelAll");
		rm.addClass("sapUiTableSelAllEnabled");
	}
	rm.addClass("sapUiTableColRowHdr");
	rm.writeClasses();
	if (oTable._bAccMode) {
		rm.writeAttribute("tabindex", "-1");
		rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_SELECT_ALL_KEY"));
	}
	rm.write(">");
	if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.Single) {
		rm.write("<div");
		rm.addClass("sapUiTableColRowHdrIco");
		rm.writeClasses();
		if (oTable.getColumnHeaderHeight() > 0) {
			rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
		}
		rm.write(">");
		rm.write("</div>");
	}
	rm.write("</div>");
};

sap.ui.table.TableRenderer.renderCol = function(rm, oTable, oColumn, iIndex, iHeader, bInvisible) {
	var oLabel;
	if (oColumn.getMultiLabels().length > 0) {
		oLabel = oColumn.getMultiLabels()[iHeader];
	} else if (iHeader == 0) {
		oLabel = oColumn.getLabel();
	}
	
	rm.write("<div");
	if (iHeader === 0) {
		rm.writeElementData(oColumn);
	} else {
		// TODO: we need a writeElementData with suffix - it is another HTML element
		//       which belongs to the same column but it is not in one structure!
		rm.writeAttribute('id', oColumn.getId() + "_" + iHeader);
	}
	rm.writeAttribute('data-sap-ui-colid', oColumn.getId());
	rm.writeAttribute("data-sap-ui-colindex", iIndex);
	if (oTable._bAccMode) {
		if (!!sap.ui.Device.browser.internet_explorer) {
			rm.writeAttribute("role", "columnheader");
		}
		// TODO: determine if the column has a column menu
		rm.writeAttribute("aria-haspopup", "true");
		rm.writeAttribute("tabindex", "-1");
	}
	rm.addClass("sapUiTableCol");
	rm.writeClasses();
	rm.addStyle("width", oColumn.getWidth());
	if (oTable.getColumnHeaderHeight() > 0) {
		rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
	}
	if (bInvisible) {
		rm.addStyle("display", "none");
	}
	rm.writeStyles();
	var sTooltip = oColumn.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	rm.write("><div");
	rm.addClass("sapUiTableColCell");
	rm.writeClasses();
	var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
	if (sHAlign) {
		rm.addStyle("text-align", sHAlign);
	}
	rm.writeStyles();
	rm.write(">");

	// TODO: rework column sort / filter status integration
	rm.write("<div id=\"" + oColumn.getId() + "-icons\" class=\"sapUiTableColIcons\"></div>");
	
	if (oLabel) {
		rm.renderControl(oLabel);
	}

	rm.write("</div></div>");
};

sap.ui.table.TableRenderer.renderColRsz = function(rm, oTable, oColumn, iIndex) {
	if (oColumn.getResizable()) {
		rm.write("<div");
		rm.writeAttribute("id", oColumn.getId() + "-rsz");
		rm.writeAttribute("data-sap-ui-colindex", iIndex);
		rm.writeAttribute("tabindex", "-1");
		rm.addClass("sapUiTableColRsz");
		rm.writeClasses();
		rm.addStyle("left", oTable._bRtlMode ? "99000px" : "-99000px");
		rm.writeStyles();
		rm.write("></div>");
	}
};


// =============================================================================
// CONTENT AREA OF THE TABLE
// =============================================================================

sap.ui.table.TableRenderer.renderRowHdr = function(rm, oTable) {
	rm.write("<div");
	rm.addClass("sapUiTableRowHdrScr");
	rm.writeClasses();
	rm.write(">");

	// start with the first current top visible row
	for (var row = 0, count = oTable.getRows().length; row < count; row++) {
		this.renderRowHdrRow(rm, oTable, oTable.getRows()[row], row);
	}

	rm.write("</div>");
};

sap.ui.table.TableRenderer.renderRowHdrRow = function(rm, oTable, oRow, iRowIndex) {
	rm.write("<div");
	rm.writeAttribute("id", oTable.getId() + "-rowsel" + iRowIndex);
	rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
	rm.addClass("sapUiTableRowHdr");
	if (oRow._bHidden) {
		rm.addClass("sapUiTableRowHidden");
	}
	rm.writeClasses();
	if (oTable.getRowHeight() > 0) {
		rm.addStyle("height", oTable.getRowHeight() + "px");
	}
	if (oTable._bAccMode) {
		// defined via ARIA spec but not yet supported
		var aCellIds = [];
		jQuery.each(oRow.getCells(), function(iIndex, oCell) {
			aCellIds.push(oRow.getId() + "-col" + iIndex);
		});
		if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
			rm.writeAttribute("aria-selected", "false");
		}
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
			rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_ROW_SELECT"));
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi && oTable._oSelection.getSelectedIndices().length > 1) {
				rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));
			} else {
				rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
			}
		}
		rm.writeAttribute("tabindex", "-1");
	}
	rm.writeStyles();
	rm.write("></div>");
};

sap.ui.table.TableRenderer.renderTableCtrl = function(rm, oTable) {

	if (oTable.getFixedColumnCount() > 0) {
		rm.write("<div");
		rm.addClass("sapUiTableCtrlScrFixed");
		rm.writeClasses();
		rm.write(">");

		this.renderTableControl(rm, oTable, true);

		rm.write("</div>");
	}

	rm.write("<div");
	rm.addClass("sapUiTableCtrlScr");
	rm.writeClasses();
	if (oTable.getFixedColumnCount() > 0) {
		if (oTable._bRtlMode) {
			rm.addStyle("margin-right", "0");
		} else {
			rm.addStyle("margin-left", "0");
		}
		rm.writeStyles();
	}
	rm.write(">");

	rm.write("<div");
	rm.addClass("sapUiTableCtrlCnt");
	rm.writeClasses();
	rm.write(">");

	this.renderTableControl(rm, oTable, false);

	rm.write("</div>");

	rm.write("<div");
	rm.addClass("sapUiTableCtrlAfter");
	rm.writeClasses();
	rm.writeAttribute("tabindex", "0");
	rm.write("></div>");
	rm.write("</div>");

	rm.write("<div");
	rm.addClass("sapUiTableCtrlEmpty");
	rm.writeClasses();
	rm.writeAttribute("tabindex", "0");
	rm.write(">");
	if (oTable.getNoData() && oTable.getNoData() instanceof sap.ui.core.Control) {
		rm.renderControl(oTable.getNoData());
	} else {
		rm.write("<span");
		rm.addClass("sapUiTableCtrlEmptyMsg");
		rm.writeClasses();
		rm.write(">");
		if (typeof oTable.getNoData() === "string" || oTable.getNoData() instanceof String) {
			rm.writeEscaped(oTable.getNoData());
		} else if (oTable.getNoDataText()) {
			rm.writeEscaped(oTable.getNoDataText());
		} else {
			rm.writeEscaped(oTable._oResBundle.getText("TBL_NO_DATA"));
		}
		rm.write("</span>");
	}
	rm.write("</div>");
};


sap.ui.table.TableRenderer.renderTableControl = function(rm, oTable, bFixedTable) {
	var iStartColumn, iEndColumn;
	if (bFixedTable) {
		iStartColumn = 0;
		iEndColumn = oTable.getFixedColumnCount();
	} else {
		iStartColumn = oTable.getFixedColumnCount();
		iEndColumn = oTable.getColumns().length;
	}
	var iFixedRows = oTable.getFixedRowCount();
	var iFixedBottomRows = oTable.getFixedBottomRowCount();
	var aRows = oTable.getRows();

	if (iFixedRows > 0) {
		this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, true, false, 0, iFixedRows);
	}
	this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, false, iFixedRows, aRows.length - iFixedBottomRows);
	if (iFixedBottomRows > 0) {
		this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, true, aRows.length - iFixedBottomRows, aRows.length);
	}
};

sap.ui.table.TableRenderer.renderTableControlCnt = function(rm, oTable, bFixedTable, iStartColumn, iEndColumn, bFixedRow, bFixedBottomRow, iStartRow, iEndRow) {
	rm.write("<table");
	var sId = oTable.getId() + "-table";
	if (bFixedTable) {
		sId += "-fixed";
		rm.addClass("sapUiTableCtrlFixed");
	} else {
		rm.addClass("sapUiTableCtrlScroll");
	}
	if (bFixedRow) {
		sId += "-fixrow";
		rm.addClass("sapUiTableCtrlRowFixed");
	} else if (bFixedBottomRow) {
		sId += "-fixrow-bottom";
		rm.addClass("sapUiTableCtrlRowFixedBottom");
	} else {
		rm.addClass("sapUiTableCtrlRowScroll");
	}
	rm.writeAttribute("id", sId);
	if (oTable._bAccMode) {
		rm.writeAttribute("role", "grid");
	}
	rm.addClass("sapUiTableCtrl");
	rm.writeClasses();
	rm.addStyle("min-width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
	//Firefox and chrome and safari need a defined width for the fixed table
	if (bFixedTable && (!!sap.ui.Device.browser.firefox || !!sap.ui.Device.browser.chrome || !!sap.ui.Device.browser.safari)) {
		rm.addStyle("width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
	}
	rm.writeStyles();
	rm.write(">");

	rm.write("<thead>");

	rm.write("<tr");
	rm.addClass("sapUiTableCtrlCol");
	if (iStartRow == 0) {
		rm.addClass("sapUiTableCtrlFirstCol");
	}
	rm.writeClasses();
	rm.write(">");

	var aCols = oTable.getColumns();
	if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
		rm.write("<th");
		rm.addStyle("width", "0px");
		rm.writeStyles();
		if (oTable._bAccMode && iStartRow == 0) {
			rm.writeAttribute("role", "columnheader");
			rm.writeAttribute("scope", "col");
			rm.writeAttribute("id", oTable.getId() + "_colsel");
		}
		rm.write("></th>");
	} else {
		if (aCols.length === 0) {
			// no cols => render th => avoids rendering issue in firefox
			rm.write("<th></th>");
		}
	}

	for (var col = iStartColumn, count = iEndColumn; col < count; col++) {
		var oColumn = aCols[col];
		if (oColumn && oColumn.shouldRender()) {
			rm.write("<th");
			rm.addStyle("width", oColumn.getWidth());
			rm.writeStyles();
			if (iStartRow == 0) {
				if (oTable._bAccMode) {
					rm.writeAttribute("aria-owns", oColumn.getId());
					rm.writeAttribute("aria-labelledby", oColumn.getId());
					rm.writeAttribute("role", "columnheader");
					rm.writeAttribute("scope", "col");
					rm.writeAttribute("id", oTable.getId() + "_col" + col);
				}
			}
			rm.writeAttribute("data-sap-ui-headcolindex", col);
			rm.write(">");
			if (iStartRow == 0) {
				if (oColumn.getMultiLabels().length > 0) {
					rm.renderControl(oColumn.getMultiLabels()[0]);
				} else {
					rm.renderControl(oColumn.getLabel());
				}
			}
			rm.write("</th>");
		}
	}
	
	// dummy column to fill the table width
	if (!bFixedTable && oTable._hasOnlyFixColumnWidths() && aCols.length > 0) {
		rm.write("<th></th>");
	}

	rm.write("</tr>");
	rm.write("</thead>");

	rm.write("<tbody>");

	// render the table rows
	var aRows = oTable.getRows();
	for (var row = iStartRow, count = iEndRow; row < count; row++) {
		this.renderTableRow(rm, oTable, aRows[row], row, bFixedTable, iStartColumn, iEndColumn, false);
	}

	rm.write("</tbody>");
	rm.write("</table>");
};

sap.ui.table.TableRenderer.renderTableRow = function(rm, oTable, oRow, iRowIndex, bFixedTable, iStartColumn, iEndColumn, bFixedRow) {

	rm.write("<tr");
	rm.addClass("sapUiTableTr");
	if (bFixedTable) {
		rm.writeAttribute("id", oRow.getId() + "-fixed");
	} else {
		rm.writeElementData(oRow);
	}
	if (oRow._bHidden) {
		rm.addClass("sapUiTableRowHidden");
	}
	if (iRowIndex % 2 === 0) {
		rm.addClass("sapUiTableRowEven");
	} else {
		rm.addClass("sapUiTableRowOdd");
	}
	rm.writeClasses();
	rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
	if (oTable.getRowHeight() > 0) {
		rm.addStyle("height", oTable.getRowHeight() + "px");
	}
	rm.writeStyles();
	if (oTable._bAccMode) {
		rm.writeAttribute("role", "row");
		if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
			rm.writeAttribute("aria-selected", "false");
		}
//		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
//			rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_ROW_SELECT"));
//			rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
//		}
	}
	rm.write(">");
	var aCells = oRow.getCells();
	if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
		rm.write("<td");
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "gridcell");
			rm.writeAttribute("headers", oTable.getId() + "_colsel");
			rm.writeAttribute("aria-owns", oTable.getId() + "-rowsel" + iRowIndex);
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
				rm.writeAttribute("aria-selected", "false");
			}
		}
		rm.write(">");
		if (oTable._bAccMode) {
			rm.write("<div");
			rm.addClass("sapUiTableAriaRowSel");
			rm.writeClasses();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
			rm.write("</div>");
		}
		rm.write("</td>");
	} else {
		if (aCells.length === 0) {
			rm.write("<td");
			if (oTable._bAccMode) {
				rm.writeAttribute("role", "gridcell");
				rm.writeAttribute("headers", oTable.getId() + "_colsel");
				rm.writeAttribute("aria-owns", oTable.getId() + "-rowsel" + iRowIndex);
				if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
					rm.writeAttribute("aria-selected", "false");
				}
			}
			rm.write(">");
			if (oTable._bAccMode) {
				rm.write("<div");
				rm.addClass("sapUiTableAriaRowSel");
				rm.writeClasses();
				rm.write(">");
				rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
				rm.write("</div>");
			}
			rm.write("</td>");
		}
	}
	for (var cell = 0, count = aCells.length; cell < count; cell++) {
		this.renderTableCell(rm, oTable, oRow, aCells[cell], cell, bFixedTable, iStartColumn, iEndColumn);
	}
	if (!bFixedTable && oTable._hasOnlyFixColumnWidths() && aCells.length > 0) {
		rm.write("<td></td>");
	}
	rm.write("</tr>");

};

sap.ui.table.TableRenderer.renderTableCell = function(rm, oTable, oRow, oCell, iCellIndex, bFixedTable, iStartColumn, iEndColumn) {
	var iColIndex = oCell.data("sap-ui-colindex");
	var oColumn = oTable.getColumns()[iColIndex];
	if (oColumn.shouldRender() && iStartColumn <= iColIndex && iEndColumn > iColIndex) {
		rm.write("<td");
		var sId = oRow.getId() + "-col" + iCellIndex;
		rm.writeAttribute("id", sId);
		if (oTable._bAccMode) {
			// correct would be aria-labelledby but doesn't work for JAWS
			rm.writeAttribute("headers", oTable.getId() + "_col" + iColIndex);
			rm.writeAttribute("role", "gridcell");
			var sLabelledBy = oTable.getId() + "-ariadesc " + oColumn.getId();
			var iMultiLabels = oColumn.getMultiLabels().length;
			if (iMultiLabels > 1) {
				for (var i = 1; i < iMultiLabels; i++) {
					sLabelledBy +=  " " + oColumn.getId() + "_" + i;
				}
			}
			sLabelledBy +=  " " + oCell.getId();
			rm.writeAttribute("aria-labelledby", sLabelledBy);
			rm.writeAttribute("aria-describedby", oTable.getId() + "-toggleedit");
			rm.writeAttribute("aria-activedescendant", oCell.getId());
			rm.writeAttribute("tabindex", "-1");
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
				rm.writeAttribute("aria-selected", "false");
			}
		}
		var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
		if (sHAlign) {
			rm.addStyle("text-align", sHAlign);
		}
		rm.writeStyles();
		var aVisibleColumns = oTable._getVisibleColumns();
		if (aVisibleColumns.length > 0 && aVisibleColumns[0] === oColumn) {
			rm.addClass("sapUiTableTdFirst");
		}
		// grouping support to show/hide values of grouped columns
		if (oColumn.getGrouped()) {
			rm.addClass("sapUiTableTdGroup");
		}
		rm.writeClasses();
		rm.write("><div");
		rm.addClass("sapUiTableCell");
		rm.writeClasses();
		/*
		if (oTable.getRowHeight() > 0) {
			rm.addStyle("height", oTable.getRowHeight() + "px");
		}
		rm.writeStyles();
		*/
		rm.write(">");
		this.renderTableCellControl(rm, oTable, oCell, iCellIndex);
		rm.write("</div></td>");
	}
};

sap.ui.table.TableRenderer.renderTableCellControl = function(rm, oTable, oCell, iCellIndex) {
	rm.renderControl(oCell);
};

sap.ui.table.TableRenderer.renderVSb = function(rm, oTable) {
	rm.write("<div");
	rm.addClass("sapUiTableVSb");
	rm.writeClasses();
	rm.write(">");
	rm.renderControl(oTable._oVSb);
	rm.write("</div>");
};

sap.ui.table.TableRenderer.renderHSb = function(rm, oTable) {
	rm.write("<div");
	rm.addClass("sapUiTableHSb");
	rm.writeClasses();
	rm.write(">");
	rm.renderControl(oTable._oHSb);
	rm.write("</div>");
};


// =============================================================================
// HELPER FUNCTIONALITY
// =============================================================================

/**
 * Returns the value for the HTML "align" attribute according to the given
 * horizontal alignment and RTL mode, or NULL if the HTML default is fine.
 *
 * @param {sap.ui.core.HorizontalAlign} oHAlign
 * @param {boolean} bRTL
 * @type string
 */
sap.ui.table.TableRenderer.getHAlign = function(oHAlign, bRTL) {
  switch (oHAlign) {
	case sap.ui.core.HorizontalAlign.Center:
	  return "center";
	case sap.ui.core.HorizontalAlign.End:
	case sap.ui.core.HorizontalAlign.Right:
	  return bRTL ? "left" : "right";
  }
  // case sap.ui.core.HorizontalAlign.Left:
  // case sap.ui.core.HorizontalAlign.Begin:
  return bRTL ? "right" : "left";
};

}; // end of sap/ui/table/TableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeTableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.TreeTable
jQuery.sap.declare("sap.ui.table.TreeTableRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class TreeTable renderer.
 * @static
 */
sap.ui.table.TreeTableRenderer = sap.ui.core.Renderer.extend(sap.ui.table.TableRenderer);


sap.ui.table.TreeTableRenderer.renderTableCellControl = function(rm, oTable, oCell, iCellIndex) {
	if (oTable.isTreeBinding("rows") && iCellIndex === 0 && !oTable.getUseGroupMode()) {
		rm.write("<span");
		rm.addClass("sapUiTableTreeIcon");
		rm.addClass("sapUiTableTreeIconLeaf");
		rm.writeClasses();
		rm.writeAttribute("tabindex", -1);
		rm.write(">&nbsp;</span>");
	}
	rm.renderControl(oCell);
};

}; // end of sap/ui/table/TreeTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

/**
 * Initialization Code and shared classes of library sap.ui.table (1.24.2)
 */
jQuery.sap.declare("sap.ui.table.library");
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained

/**
 * Table-like controls, mainly for desktop scenarios.
 *
 * @namespace
 * @name sap.ui.table
 * @public
 */


// library dependencies
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained

jQuery.sap.require('sap.ui.unified.library'); // unlisted dependency retained


// delegate further initialization of this library to the Core
sap.ui.getCore().initLibrary({
  name : "sap.ui.table",
  dependencies : ["sap.ui.core","sap.ui.unified"],
  types: [
    "sap.ui.table.NavigationMode",
    "sap.ui.table.SelectionBehavior",
    "sap.ui.table.SelectionMode",
    "sap.ui.table.SortOrder",
    "sap.ui.table.VisibleRowCountMode"
  ],
  interfaces: [],
  controls: [
    "sap.ui.table.AnalyticalColumnMenu",
    "sap.ui.table.AnalyticalTable",
    "sap.ui.table.ColumnMenu",
    "sap.ui.table.DataTable",
    "sap.ui.table.Table",
    "sap.ui.table.TreeTable"
  ],
  elements: [
    "sap.ui.table.AnalyticalColumn",
    "sap.ui.table.Column",
    "sap.ui.table.Row"
  ],
  version: "1.24.2"});

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.table.NavigationMode.
jQuery.sap.declare("sap.ui.table.NavigationMode");


/**
 * @class Navigation mode of the table
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.NavigationMode = {

	/**
	 * Uses the scrollbar control.
	 * @public
	 */
	Scrollbar : "Scrollbar",

	/**
	 * Uses the paginator control.
	 * @public
	 */
	Paginator : "Paginator"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.table.SelectionBehavior.
jQuery.sap.declare("sap.ui.table.SelectionBehavior");


/**
 * @class Selection behavior of the table
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.SelectionBehavior = {

	/**
	 * Rows can be selected on the complete row.
	 * @public
	 */
	Row : "Row",

	/**
	 * Rows can only be selected on the row selector.
	 * @public
	 */
	RowSelector : "RowSelector",

	/**
	 * Rows can only be selected on the row (and the selector is hidden).
	 * @public
	 */
	RowOnly : "RowOnly"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.table.SelectionMode.
jQuery.sap.declare("sap.ui.table.SelectionMode");


/**
 * @class Selection mode of the table
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.SelectionMode = {

	/**
	 * Select multiple rows at a time (toggle behavior).
	 * @public
	 */
	MultiToggle : "MultiToggle",

	/**
	 * Select multiple rows at a time.
	 * @public
	 */
	Multi : "Multi",

	/**
	 * Select one row at a time.
	 * @public
	 */
	Single : "Single",

	/**
	 * No rows can be selected.
	 * @public
	 */
	None : "None"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.table.SortOrder.
jQuery.sap.declare("sap.ui.table.SortOrder");


/**
 * @class Sort order of a column
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.SortOrder = {

	/**
	 * Sort Order: ascending.
	 * @public
	 */
	Ascending : "Ascending",

	/**
	 * Sort Order: descending.
	 * @public
	 */
	Descending : "Descending"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.table.VisibleRowCountMode.
jQuery.sap.declare("sap.ui.table.VisibleRowCountMode");


/**
 * @class VisibleRowCountMode of the table
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.VisibleRowCountMode = {

	/**
	 * The table always has as many rows as defined in the visibleRowCount property.
	 * @public
	 */
	Fixed : "Fixed",

	/**
	 * After rendering the table has as many rows as defined in visibleRowCount property. The user is able to change the visible rows by moving a grip with the mouse. The visibleRowCount property is changed accordingly.
	 * @public
	 */
	Interactive : "Interactive",

	/**
	 * The table automatically fills the height of the surrounding container. The visibleRowCount property is automatically changed accordingly. All rows need the same height, otherwise the auto mode doesn't always work as expected.
	 * @public
	 */
	Auto : "Auto"

};

// -----------------------------------------------------------------------------
// Begin of Library Initialization coding, copied from shared.js
// -----------------------------------------------------------------------------

// map the new Column to the old ColumnHeader
sap.ui.table.ColumnHeader = sap.ui.table.Column;

// map the SelectionMode All to Multi
sap.ui.table.SelectionMode.All = sap.ui.table.SelectionMode.Multi;

//factory for table to create labels an textviews to be overwritten by commons and mobile library
if (!sap.ui.table.TableHelper) {
	sap.ui.table.TableHelper = {
		createLabel: function(mConfig){ throw new Error("no Label control available!"); }, /* must return a Label control */
		createTextView: function(mConfig){ throw new Error("no TextView control available!"); }, /* must return a textview control */
		createTextField: function(mConfig){ throw new Error("no TextField control available!"); }, /* must return a textfield control */
		createImage: function(mConfig){ throw new Error("no Image control available!"); }, /* must return a textview control */
		bFinal: false /* if true, the helper must not be overwritten by an other library */
	};
}
}; // end of sap/ui/table/library.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenuRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.table.AnalyticalColumnMenuRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class AnalyticalTable renderer.
 * @static
 */
sap.ui.table.AnalyticalColumnMenuRenderer = sap.ui.core.Renderer.extend(sap.ui.table.ColumnMenuRenderer);
}; // end of sap/ui/table/AnalyticalColumnMenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalTableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.table.AnalyticalTableRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class AnalyticalTable renderer. 
 * @static
 */
sap.ui.table.AnalyticalTableRenderer = sap.ui.core.Renderer.extend(sap.ui.table.TableRenderer);
}; // end of sap/ui/table/AnalyticalTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Column') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.Column.
jQuery.sap.declare("sap.ui.table.Column");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new Column.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getFlexible flexible} : boolean (default: true)</li>
 * <li>{@link #getResizable resizable} : boolean (default: true)</li>
 * <li>{@link #getHAlign hAlign} : sap.ui.core.HorizontalAlign (default: sap.ui.core.HorizontalAlign.Begin)</li>
 * <li>{@link #getSorted sorted} : boolean (default: false)</li>
 * <li>{@link #getSortOrder sortOrder} : sap.ui.table.SortOrder (default: sap.ui.table.SortOrder.Ascending)</li>
 * <li>{@link #getSortProperty sortProperty} : string</li>
 * <li>{@link #getFiltered filtered} : boolean (default: false)</li>
 * <li>{@link #getFilterProperty filterProperty} : string</li>
 * <li>{@link #getFilterValue filterValue} : string</li>
 * <li>{@link #getFilterOperator filterOperator} : string</li>
 * <li>{@link #getGrouped grouped} : boolean (default: false)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getFilterType filterType} : any</li>
 * <li>{@link #getName name} : string</li>
 * <li>{@link #getShowFilterMenuEntry showFilterMenuEntry} : boolean (default: true)</li>
 * <li>{@link #getShowSortMenuEntry showSortMenuEntry} : boolean (default: true)</li>
 * <li>{@link #getHeaderSpan headerSpan} : any (default: 1)</li>
 * <li>{@link #getAutoResizable autoResizable} : boolean (default: false)</li>
 * <li>{@link #getDefaultFilterOperator defaultFilterOperator} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getLabel label} <strong>(default aggregation)</strong> : sap.ui.core.Control</li>
 * <li>{@link #getMultiLabels multiLabels} : sap.ui.core.Control[]</li>
 * <li>{@link #getTemplate template} : sap.ui.core.Control</li>
 * <li>{@link #getMenu menu} : sap.ui.unified.Menu</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The column allows to define column specific properties that will be applied when rendering the table.
 * @extends sap.ui.core.Element
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.table.Column
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.table.Column", { metadata : {

	publicMethods : [
		// methods
		"sort", "toggleSort"
	],
	library : "sap.ui.table",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"flexible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"resizable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"hAlign" : {type : "sap.ui.core.HorizontalAlign", group : "Appearance", defaultValue : sap.ui.core.HorizontalAlign.Begin},
		"sorted" : {type : "boolean", group : "Appearance", defaultValue : false},
		"sortOrder" : {type : "sap.ui.table.SortOrder", group : "Appearance", defaultValue : sap.ui.table.SortOrder.Ascending},
		"sortProperty" : {type : "string", group : "Behavior", defaultValue : null},
		"filtered" : {type : "boolean", group : "Appearance", defaultValue : false},
		"filterProperty" : {type : "string", group : "Behavior", defaultValue : null},
		"filterValue" : {type : "string", group : "Behavior", defaultValue : null},
		"filterOperator" : {type : "string", group : "Behavior", defaultValue : null},
		"grouped" : {type : "boolean", group : "Appearance", defaultValue : false},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"filterType" : {type : "any", group : "Misc", defaultValue : null},
		"name" : {type : "string", group : "Appearance", defaultValue : null},
		"showFilterMenuEntry" : {type : "boolean", group : "Appearance", defaultValue : true},
		"showSortMenuEntry" : {type : "boolean", group : "Appearance", defaultValue : true},
		"headerSpan" : {type : "any", group : "Behavior", defaultValue : 1},
		"autoResizable" : {type : "boolean", group : "Behavior", defaultValue : false},
		"defaultFilterOperator" : {type : "string", group : "Behavior", defaultValue : null}
	},
	defaultAggregation : "label",
	aggregations : {
		"label" : {type : "sap.ui.core.Control", multiple : false}, 
		"multiLabels" : {type : "sap.ui.core.Control", multiple : true, singularName : "multiLabel"}, 
		"template" : {type : "sap.ui.core.Control", multiple : false}, 
		"menu" : {type : "sap.ui.unified.Menu", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.table.Column with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.Column.extend
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Width of the column.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.table.Column#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setWidth
 * @function
 */


/**
 * Getter for property <code>flexible</code>.
 * Is the width of the column flexible (grows on resize)?
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>flexible</code>
 * @public
 * @name sap.ui.table.Column#getFlexible
 * @function
 */

/**
 * Setter for property <code>flexible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bFlexible  new value for property <code>flexible</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setFlexible
 * @function
 */


/**
 * Getter for property <code>resizable</code>.
 * Is the column resizable or not?
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>resizable</code>
 * @public
 * @name sap.ui.table.Column#getResizable
 * @function
 */

/**
 * Setter for property <code>resizable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bResizable  new value for property <code>resizable</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setResizable
 * @function
 */


/**
 * Getter for property <code>hAlign</code>.
 * Horizontal alignment of the column content. Controls with a text align do not inherit the horizontal alignment. You have to set the text align directly on the template.
 *
 * Default value is <code>Begin</code>
 *
 * @return {sap.ui.core.HorizontalAlign} the value of property <code>hAlign</code>
 * @public
 * @name sap.ui.table.Column#getHAlign
 * @function
 */

/**
 * Setter for property <code>hAlign</code>.
 *
 * Default value is <code>Begin</code> 
 *
 * @param {sap.ui.core.HorizontalAlign} oHAlign  new value for property <code>hAlign</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setHAlign
 * @function
 */


/**
 * Getter for property <code>sorted</code>.
 * flag, if the column is sorted or not (displays the sorting indicator, does not trigger the sort method!)
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>sorted</code>
 * @public
 * @name sap.ui.table.Column#getSorted
 * @function
 */

/**
 * Setter for property <code>sorted</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSorted  new value for property <code>sorted</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setSorted
 * @function
 */


/**
 * Getter for property <code>sortOrder</code>.
 * @see sap.ui.table.SortOrder (default value: "Ascending")
 *
 * Default value is <code>Ascending</code>
 *
 * @return {sap.ui.table.SortOrder} the value of property <code>sortOrder</code>
 * @public
 * @name sap.ui.table.Column#getSortOrder
 * @function
 */

/**
 * Setter for property <code>sortOrder</code>.
 *
 * Default value is <code>Ascending</code> 
 *
 * @param {sap.ui.table.SortOrder} oSortOrder  new value for property <code>sortOrder</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setSortOrder
 * @function
 */


/**
 * Getter for property <code>sortProperty</code>.
 * Specifies the binding property on which the column will sort.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>sortProperty</code>
 * @public
 * @name sap.ui.table.Column#getSortProperty
 * @function
 */

/**
 * Setter for property <code>sortProperty</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sSortProperty  new value for property <code>sortProperty</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setSortProperty
 * @function
 */


/**
 * Getter for property <code>filtered</code>.
 * flag, if the column is filtered or not (displays the filter indicator, does not trigger the filter method!)
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>filtered</code>
 * @public
 * @name sap.ui.table.Column#getFiltered
 * @function
 */

/**
 * Setter for property <code>filtered</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bFiltered  new value for property <code>filtered</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setFiltered
 * @function
 */


/**
 * Getter for property <code>filterProperty</code>.
 * Specifies the binding property on which the column will filter.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>filterProperty</code>
 * @public
 * @name sap.ui.table.Column#getFilterProperty
 * @function
 */

/**
 * Setter for property <code>filterProperty</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sFilterProperty  new value for property <code>filterProperty</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setFilterProperty
 * @function
 */


/**
 * Getter for property <code>filterValue</code>.
 * Specifies the value of the filter as string (will be converted into the propert data type).
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>filterValue</code>
 * @public
 * @name sap.ui.table.Column#getFilterValue
 * @function
 */

/**
 * Setter for property <code>filterValue</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sFilterValue  new value for property <code>filterValue</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setFilterValue
 * @function
 */


/**
 * Getter for property <code>filterOperator</code>.
 * @see sap.ui.model.FilterOperator (default value: "Contains")
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>filterOperator</code>
 * @public
 * @name sap.ui.table.Column#getFilterOperator
 * @function
 */

/**
 * Setter for property <code>filterOperator</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sFilterOperator  new value for property <code>filterOperator</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setFilterOperator
 * @function
 */


/**
 * Getter for property <code>grouped</code>.
 * flag, if the column is grouped or not (hides the column!)
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>grouped</code>
 * @public
 * @name sap.ui.table.Column#getGrouped
 * @function
 */

/**
 * Setter for property <code>grouped</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bGrouped  new value for property <code>grouped</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setGrouped
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.table.Column#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setVisible
 * @function
 */


/**
 * Getter for property <code>filterType</code>.
 * Type of Filter. This is used to transform the search term to the specified type, to make sure that the right columns are displayed. This should be the same as defined in binding for this column. As alternative you can pass a function which does the conversion. The function receives the entered filter value as parameter and returns the proper value for the filter expression. Another option is to pass the classname of the type, e.g.: sap.ui.model.type.Date or an expression similar to the binding syntax, e.g.: "\{type: 'sap.ui.model.type.Date', formatOptions: \{UTC: true\}, constraints: {} \}". Here the escaping is mandatory to avoid handling by the binding parser. By default the filter type is sap.ui.model.type.String.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {any} the value of property <code>filterType</code>
 * @public
 * @since 1.9.2
 * @name sap.ui.table.Column#getFilterType
 * @function
 */

/**
 * Setter for property <code>filterType</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {any} oFilterType  new value for property <code>filterType</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.9.2
 * @name sap.ui.table.Column#setFilterType
 * @function
 */


/**
 * Getter for property <code>name</code>.
 * The name of the column which is used in the column visibility menu item as text. If not set as fallback the column menu tries to get the text from the nested Label.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>name</code>
 * @public
 * @since 1.11.1
 * @name sap.ui.table.Column#getName
 * @function
 */

/**
 * Setter for property <code>name</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sName  new value for property <code>name</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.1
 * @name sap.ui.table.Column#setName
 * @function
 */


/**
 * Getter for property <code>showFilterMenuEntry</code>.
 * Define if the filter menu entry is displayed
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showFilterMenuEntry</code>
 * @public
 * @since 1.13.0
 * @name sap.ui.table.Column#getShowFilterMenuEntry
 * @function
 */

/**
 * Setter for property <code>showFilterMenuEntry</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowFilterMenuEntry  new value for property <code>showFilterMenuEntry</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.13.0
 * @name sap.ui.table.Column#setShowFilterMenuEntry
 * @function
 */


/**
 * Getter for property <code>showSortMenuEntry</code>.
 * Define if the sort menu entries are displayed
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showSortMenuEntry</code>
 * @public
 * @since 1.13.0
 * @name sap.ui.table.Column#getShowSortMenuEntry
 * @function
 */

/**
 * Setter for property <code>showSortMenuEntry</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowSortMenuEntry  new value for property <code>showSortMenuEntry</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.13.0
 * @name sap.ui.table.Column#setShowSortMenuEntry
 * @function
 */


/**
 * Getter for property <code>headerSpan</code>.
 * If this property is set a span is applied for the header. When moving columns all columns which are part of the header will be moved. This can be either an integer or an array of integers (if you use the multi header feature of the table). If you only specify an integer this span is applied for all header rows, with multiple integers you can specify a seperate span for each header row.
 *
 * Default value is <code>1</code>
 *
 * @return {any} the value of property <code>headerSpan</code>
 * @public
 * @name sap.ui.table.Column#getHeaderSpan
 * @function
 */

/**
 * Setter for property <code>headerSpan</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {any} oHeaderSpan  new value for property <code>headerSpan</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setHeaderSpan
 * @function
 */


/**
 * Getter for property <code>autoResizable</code>.
 * Enables auto-resizing of the column on doubleclicking the resizer. Currently only implemented to work with the following controls: sap.m.Text, sap.m.Label, sap.m.Link , sap.m.Input, sap.ui.commons.TextView, sap.ui.commons.Label, sap.ui.commons.Link and sap.ui.commons.TextField, sap.ui.commons.Checkbox, sap.m.Checkbox
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>autoResizable</code>
 * @public
 * @since 1.21.1
 * @name sap.ui.table.Column#getAutoResizable
 * @function
 */

/**
 * Setter for property <code>autoResizable</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bAutoResizable  new value for property <code>autoResizable</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.1
 * @name sap.ui.table.Column#setAutoResizable
 * @function
 */


/**
 * Getter for property <code>defaultFilterOperator</code>.
 * If this property is set the default filter operator of the column is overwritten.
 * By default "Contains" is used for string and "EQ" for other types. A valid sap.ui.model.FilterOperator needs to be passed.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>defaultFilterOperator</code>
 * @public
 * @name sap.ui.table.Column#getDefaultFilterOperator
 * @function
 */

/**
 * Setter for property <code>defaultFilterOperator</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sDefaultFilterOperator  new value for property <code>defaultFilterOperator</code>
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setDefaultFilterOperator
 * @function
 */


/**
 * Getter for aggregation <code>label</code>.<br/>
 * Label (header renderer) of the column which is displayed in the column header. Define a control for each header row in the table. This aggregation is for the standard behaviour, if you only want to display one single row header.
 * 
 * <strong>Note</strong>: this is the default aggregation for Column.
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.ui.table.Column#getLabel
 * @function
 */


/**
 * Setter for the aggregated <code>label</code>.
 * @param {sap.ui.core.Control} oLabel
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setLabel
 * @function
 */
	

/**
 * Destroys the label in the aggregation 
 * named <code>label</code>.
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#destroyLabel
 * @function
 */


/**
 * Getter for aggregation <code>multiLabels</code>.<br/>
 * Labels (header renderer) of the column which are displayed in the column header. Define a control for each header row in the table. Use this aggregation, if you want to use multiple headers per column.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @since 1.13.1
 * @name sap.ui.table.Column#getMultiLabels
 * @function
 */


/**
 * Inserts a multiLabel into the aggregation named <code>multiLabels</code>.
 *
 * @param {sap.ui.core.Control}
 *          oMultiLabel the multiLabel to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the multiLabel should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the multiLabel is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the multiLabel is inserted at 
 *             the last position        
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.13.1
 * @name sap.ui.table.Column#insertMultiLabel
 * @function
 */

/**
 * Adds some multiLabel <code>oMultiLabel</code> 
 * to the aggregation named <code>multiLabels</code>.
 *
 * @param {sap.ui.core.Control}
 *            oMultiLabel the multiLabel to add; if empty, nothing is inserted
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.13.1
 * @name sap.ui.table.Column#addMultiLabel
 * @function
 */

/**
 * Removes an multiLabel from the aggregation named <code>multiLabels</code>.
 *
 * @param {int | string | sap.ui.core.Control} vMultiLabel the multiLabel to remove or its index or id
 * @return {sap.ui.core.Control} the removed multiLabel or null
 * @public
 * @since 1.13.1
 * @name sap.ui.table.Column#removeMultiLabel
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>multiLabels</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @since 1.13.1
 * @name sap.ui.table.Column#removeAllMultiLabels
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>multiLabels</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oMultiLabel the multiLabel whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @since 1.13.1
 * @name sap.ui.table.Column#indexOfMultiLabel
 * @function
 */
	

/**
 * Destroys all the multiLabels in the aggregation 
 * named <code>multiLabels</code>.
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.13.1
 * @name sap.ui.table.Column#destroyMultiLabels
 * @function
 */


/**
 * Getter for aggregation <code>template</code>.<br/>
 * Template (cell renderer) of this column. A template is decoupled from the column which means after changing the templates' properties or aggregations an explicit invalidation of the column or table is required. The default is: sap.ui.commons.TextView.
 * 
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.ui.table.Column#getTemplate
 * @function
 */


/**
 * Setter for the aggregated <code>template</code>.
 * @param {sap.ui.core.Control} oTemplate
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setTemplate
 * @function
 */
	

/**
 * Destroys the template in the aggregation 
 * named <code>template</code>.
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#destroyTemplate
 * @function
 */


/**
 * Getter for aggregation <code>menu</code>.<br/>
 * The menu used by the column. By default the {@link sap.ui.table.ColumnMenu} is used.
 * 
 * @return {sap.ui.unified.Menu}
 * @public
 * @name sap.ui.table.Column#getMenu
 * @function
 */


/**
 * Setter for the aggregated <code>menu</code>.
 * @param {sap.ui.unified.Menu} oMenu
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#setMenu
 * @function
 */
	

/**
 * Destroys the menu in the aggregation 
 * named <code>menu</code>.
 * @return {sap.ui.table.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Column#destroyMenu
 * @function
 */


/**
 * sorts the current column ascending or descending
 *
 * @name sap.ui.table.Column#sort
 * @function
 * @param {boolean} bDescending
 *         sort order of the column (if undefined the default will be ascending)
 * @type sap.ui.table.Column
 * @public
 * @deprecated Since version 1.5.1. 
 * Please use the function "sap.ui.Table.prototype.sort".
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * toggles the sort order of the column
 *
 * @name sap.ui.table.Column#toggleSort
 * @function
 * @type sap.ui.table.Column
 * @public
 * @deprecated Since version 1.5.1. 
 * Please use the function "sap.ui.Table.prototype.sort".
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\table\Column.js
jQuery.sap.require('sap.ui.core.RenderManager'); // unlisted dependency retained

jQuery.sap.require('sap.ui.model.Type'); // unlisted dependency retained

jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained

jQuery.sap.require('sap.ui.model.Sorter'); // unlisted dependency retained

jQuery.sap.require('sap.ui.model.type.String'); // unlisted dependency retained


/** default filter type for the columns */
sap.ui.table.Column._DEFAULT_FILTER_TYPE = new sap.ui.model.type.String();

/**
 * called when the column is initialized
 */
sap.ui.table.Column.prototype.init = function() {

	this.oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
	this._oSorter = null;

};

/**
 * called when the column is destroyed
 */
sap.ui.table.Column.prototype.exit = function() {

	// destroy the sort image
	var oSortImage = sap.ui.getCore().byId(this.getId() + "-sortIcon");
	if (oSortImage) {
		oSortImage.destroy();
	}
	
	// destroy the filter image
	var oFilterImage = sap.ui.getCore().byId(this.getId() + "-filterIcon");
	if (oFilterImage) {
		oFilterImage.destroy();
	}
	
};

/**
 * called when the columns parent is set
 */
sap.ui.table.Column.prototype.setParent = function(oParent, sAggregationName, bSuppressRerendering) {
	sap.ui.core.Element.prototype.setParent.apply(this, arguments);
	var oMenu = this.getAggregation("menu");
	if (oMenu && typeof oMenu._updateReferences === "function") {
		//if menu is set update menus internal references
		oMenu._updateReferences(this);
	}
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.invalidate = function(oOrigin) {
	// prevent changes in the template (especially the databinding ones)
	//  - what about exchanging the template? => implemented in setTemplate
	//  - what about modifiying properties? => developer must call invalidate!
	// The problem is that we just need to prevent databinding changes. The
	// problem here is that the databinding bindings are created ones the template
	// is created and has its own model. If now changes are done in the model
	// this directly affects the template which invalidates the column invalidating
	// the complete Table.  
	/*
	 * PART1: When you create the Tooltip (deferred) then it establishes the
	 * connection to its data (also for the template of the column!) and this
	 * finally invalidates the Table which triggers the re-rendering. One
	 * option is to complete decouple the template from the Table by
	 * supressing the invalidate. But this finally also decouples the Table
	 * from any changes on the template after the template has been applied
	 * to the Column. But when re-rendering it would update the column cells.
	 * To notify the Table on proper changes one has to call the method
	 * invalidate on the Table.
	*/
	/* 
	 * PART2: we also suppress the re-rendering in case of the column menu is
	 * rerendered. This is a popup and we use the instance check because of the
	 * menu behind the getMenu function is lazy created when first accessed.
	 */
  if (oOrigin !== this.getTemplate() && !(oOrigin instanceof sap.ui.table.ColumnMenu)) {
  	// changes on the template require to call invalidate on the column or table
    sap.ui.core.Element.prototype.invalidate.apply(this, arguments);
  }
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setLabel = function(vLabel) {
	var oLabel = vLabel;
	if (typeof (vLabel) === "string") {
		oLabel = sap.ui.table.TableHelper.createLabel({text: vLabel});
	}
	this.setAggregation("label", oLabel);
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setTemplate = function(vTemplate) {
	var oTemplate = vTemplate;
	if (typeof (vTemplate) === "string") {
		oTemplate = sap.ui.table.TableHelper.createTextView().bindProperty("text", vTemplate);
	}
	this.setAggregation("template", oTemplate);
	// manually invalidate the Column (because of the invalidate decoupling to 
	// prevent invalidations from the databinding part)
	this.invalidate();
	return this;
};


/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.getMenu = function() {
	var oMenu = this.getAggregation("menu");
	if (!oMenu) {
		oMenu = this._createMenu();
		this.setMenu(oMenu);
	}
	return oMenu;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setMenu = function(oMenu) {
	this.setAggregation("menu", oMenu, true);
	return this;
};

/*
 * Factory method. Creates the column menu.
 * 
 * @return {sap.ui.table.ColumnMenu} The created column menu.
 */
sap.ui.table.Column.prototype._createMenu = function() {
	jQuery.sap.require("sap.ui.table.ColumnMenu");
	return new sap.ui.table.ColumnMenu(this.getId() + "-menu");
};


/*
 * @see JSDoc generated by SAPUI5 control API generator
sap.ui.table.Column.prototype.setEditorTemplate = function(vTemplate) {
	var oTemplate = vTemplate;
	if (typeof (vTemplate) === "string") {
		oTemplate = sap.ui.table.TableHelper.createTextField().bindProperty("value", vTemplate);
	}
	this.setAggregation("editorTemplate", oTemplate);
	return this;
};
*/

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setWidth = function(sWidth) {
	this.setProperty("width", sWidth);
	this.fireEvent('_widthChanged', { newWidth: sWidth });
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setSorted = function(bFlag) {
	this.setProperty("sorted", bFlag, true);
	this._renderSortIcon();
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setSortOrder = function(tSortOrder) {
	this.setProperty("sortOrder", tSortOrder, true);
	this._renderSortIcon();
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setFiltered = function(bFlag) {
	this.setProperty("filtered", bFlag, true);
	this._renderFilterIcon();
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setFilterValue = function(sValue) {
	this.setProperty("filterValue", sValue, true);
	if (this.getMenu()) {
		this.getMenu()._setFilterValue(sValue);
	}
	return this;
};


/**
 * Function is called when mouse key is clicked down.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.table.Column.prototype.onmousedown = function(oEvent) {
	var oMenu = this.getAggregation("menu");
	this._bSkipOpen = oMenu && oMenu.bOpen;
};


/**
 * Function is called when mouse leaves the control.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.ui.table.Column.prototype.onmouseout = function(oEvent) {
	if(this._bSkipOpen && jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())){
		this._bSkipOpen = false;
	}
};


sap.ui.table.Column.prototype._openMenu = function() {
	if(this._bSkipOpen){
		this._bSkipOpen = false;
		return;
	}
	var oMenu = this.getMenu();
	var eDock = sap.ui.core.Popup.Dock;
	oMenu.open(false, this.getFocusDomRef(), eDock.BeginTop, eDock.BeginBottom, this.getDomRef(), "none none");
};

sap.ui.table.Column.prototype.toggleSort = function() {
	// by default we sort ascending / only if already is sorted ascending then we toggle
	this.sort(this.getSorted() && this.getSortOrder() === sap.ui.table.SortOrder.Ascending);
};

sap.ui.table.Column.prototype.sort = function(bDescending, bAdd) {

	var oTable = this.getParent();
	if (oTable) {

		// get the sort order type
		var oNewSortOrder = bDescending ? sap.ui.table.SortOrder.Descending : sap.ui.table.SortOrder.Ascending;
	
		// notify the event listeners
		var bExecuteDefault = oTable.fireSort({
			column: this,
			sortOrder: oNewSortOrder,
			columnAdded: bAdd
		});

		if (bExecuteDefault) {
		
			// reset the sorting status of all columns
			var aSorters = [];
			var aCols = oTable.getColumns();
			if (bAdd) {
				for (var i = 0, l = aCols.length; i < l; i++) {
					if (aCols[i] == this) {
						// set the sort property of the current column
						this.setProperty("sorted", true, true);
						this.setProperty("sortOrder", oNewSortOrder, true);
						this._oSorter = new sap.ui.model.Sorter(this.getSortProperty(), this.getSortOrder() === sap.ui.table.SortOrder.Descending);
						aSorters.push(this._oSorter);
					} else {
						var oSorter = aCols[i]._oSorter;
						if (oSorter) {
							aSorters.push(oSorter);
						}
					}
				}
			} else {
				for (var i = 0, l = aCols.length; i < l; i++) {
					if (aCols[i] !== this) {
						aCols[i].setProperty("sorted", false, true);
						aCols[i].setProperty("sortOrder", sap.ui.table.SortOrder.Ascending, true);
						aCols[i]._renderSortIcon();
						delete aCols[i]._oSorter;
					}
				}
				// set the sort property of the current column
				this.setProperty("sorted", true, true);
				this.setProperty("sortOrder", oNewSortOrder, true);
				this._oSorter = new sap.ui.model.Sorter(this.getSortProperty(), this.getSortOrder() === sap.ui.table.SortOrder.Descending);
				aSorters.push(this._oSorter);
			}
			
			// set the sorted flag and sort the model
			if (oTable.isBound("rows")) {
				
				// sort the binding 
				oTable.getBinding("rows").sort(aSorters);
				
				if (this._afterSort) {
					this._afterSort();
				}
			}
			
			// update the sort icon
			this._renderSortIcon();
			
		}
		
	}
	
	return this;
	
};

sap.ui.table.Column.prototype._renderSortIcon = function() {

	var oTable = this.getParent();
	if (oTable && oTable.getDomRef()) {
		if (this.getSorted()) {
		
			// create the image for the sort order visualization
			var sCurrentTheme = sap.ui.getCore().getConfiguration().getTheme();
			var oImage = sap.ui.getCore().byId(this.getId() + "-sortIcon") || sap.ui.table.TableHelper.createImage(this.getId() + "-sortIcon");
			oImage.addStyleClass("sapUiTableColIconsOrder");
			if (this.getSortOrder() === sap.ui.table.SortOrder.Ascending) {
				oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_sort_asc.gif"));
			} else {
				oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_sort_desc.gif"));
			}
			
			// apply the image and aria property to the column
			var oRenderManager = new sap.ui.core.RenderManager();
			var htmlImage = oRenderManager.getHTML(oImage);
			this.$().find(".sapUiTableColIconsOrder").remove();
			jQuery(htmlImage).prependTo(this.getDomRef("icons"));
			this.$().attr("aria-sort", this.getSortOrder() === sap.ui.table.SortOrder.Ascending ? "ascending" : "descending");
			
			this.$().find(".sapUiTableColCell").addClass("sapUiTableColSorted");
			
		} else {
		
			// remove the sort indicators
			this.$().find(".sapUiTableColIconsOrder").remove();
			this.$().removeAttr("aria-sort");

			this.$().find(".sapUiTableColCell").removeClass("sapUiTableColSorted");
			
		}
	}

};

sap.ui.table.Column.prototype._getFilter = function() {

	var oFilter = undefined,
	    sPath = this.getFilterProperty(),
	    sValue = this.getFilterValue(),
	    sOperator = this.getFilterOperator(),
	    sParsedValue,
	    sSecondaryParsedValue,
	    oType = this.getFilterType() || sap.ui.table.Column._DEFAULT_FILTER_TYPE,
	    bIsString = oType instanceof sap.ui.model.type.String,
	    aBetween;

	if (sValue) {
	
		// determine the operator 
		if (!sOperator) {
		
			aBetween = sValue.match(/(.*)\s*\.\.\s*(.*)/);
		
			// determine the filter operator depending on the
			if (sValue.indexOf("=") == 0) {
				sOperator = sap.ui.model.FilterOperator.EQ;
				sParsedValue = sValue.substr(1);
			} else if (sValue.indexOf("!=") == 0) {
				sOperator = sap.ui.model.FilterOperator.NE;
				sParsedValue = sValue.substr(2);
			} else if (sValue.indexOf("<=") == 0) {
				sOperator = sap.ui.model.FilterOperator.LE;
				sParsedValue = sValue.substr(2);
			} else if (sValue.indexOf("<") == 0) {
				sOperator = sap.ui.model.FilterOperator.LT;
				sParsedValue = sValue.substr(1);
			} else if (sValue.indexOf(">=") == 0) {
				sOperator = sap.ui.model.FilterOperator.GE;
				sParsedValue = sValue.substr(2);
			} else if (sValue.indexOf(">") == 0) {
				sOperator = sap.ui.model.FilterOperator.GT;
				sParsedValue = sValue.substr(1);
			} else if (aBetween) {
				if (aBetween[1] && aBetween[2]) {
					sOperator = sap.ui.model.FilterOperator.BT;
					sParsedValue = aBetween[1];
					sSecondaryParsedValue = aBetween[2];
				} else if (aBetween[1] && !aBetween[2]) {
					sOperator = sap.ui.model.FilterOperator.GE;
					sParsedValue = aBetween[1];
				} else {
					sOperator = sap.ui.model.FilterOperator.LE;
					sParsedValue = aBetween[2];
				}
			} else if (bIsString && sValue.indexOf("*") == 0 && sValue.lastIndexOf("*") == sValue.length - 1) {
				sOperator = sap.ui.model.FilterOperator.Contains;
				sParsedValue = sValue.substr(1, sValue.length - 2);
			} else if (bIsString && sValue.indexOf("*") == 0) {
				sOperator = sap.ui.model.FilterOperator.EndsWith;
				sParsedValue = sValue.substr(1);
			} else if (bIsString && sValue.lastIndexOf("*") == sValue.length - 1) {
				sOperator = sap.ui.model.FilterOperator.StartsWith;
				sParsedValue = sValue.substr(0, sValue.length - 1);
			} else {
				if (this.getDefaultFilterOperator()) {
					sOperator = this.getDefaultFilterOperator();
				} else {
					if (bIsString) {
						// Due to compatibility reason we need to use Contains for Strings instead of EQ as default!!
						sOperator = sap.ui.model.FilterOperator.Contains;
					} else {
						sOperator = sap.ui.model.FilterOperator.EQ;
					}
				}
				sParsedValue = sValue.substr(0);
			}
			if (!sSecondaryParsedValue) {
				oFilter = new sap.ui.model.Filter(sPath, sOperator, this._parseFilterValue(sParsedValue));
			} else {
				oFilter = new sap.ui.model.Filter(sPath, sOperator, this._parseFilterValue(sParsedValue), this._parseFilterValue(sSecondaryParsedValue));
			}
		} else {
			oFilter = new sap.ui.model.Filter(sPath, sOperator, this._parseFilterValue(sValue));
		}

	}

	return oFilter;

};

sap.ui.table.Column.prototype.filter = function(sValue) {

	var oTable = this.getParent();
	if (oTable && oTable.isBound("rows")) {
	
		// notify the event listeners
		var bExecuteDefault = oTable.fireFilter({
			column: this,
			value: sValue
		});
		
		if (bExecuteDefault) {
		
			this.setProperty("filtered", !!sValue, true);
			this.setProperty("filterValue", sValue, true);
		
			var aFilters = [];
			var aCols = oTable.getColumns();
			for (var i = 0, l = aCols.length; i < l; i++) {
				var oCol = aCols[i],
					oMenu = oCol.getMenu(),
					oFilter;
				
				try {
					oFilter = oCol._getFilter();
				} catch (e) {
					if (oMenu._setFilterState) {
						oMenu._setFilterState(sap.ui.core.ValueState.Error);
					}
					continue;
				}
				if (oFilter) {
					aFilters.push(oFilter);
					if (oMenu._setFilterState) {
						oMenu._setFilterState(sap.ui.core.ValueState.None);
					}
				}
			}
			oTable.getBinding("rows").filter(aFilters, sap.ui.model.FilterType.Control);
			
			this._renderFilterIcon();
			
		}
		
	}

	return this;
	
};

sap.ui.table.Column.prototype._parseFilterValue = function(sValue) {
	var oFilterType = this.getFilterType();

	if (oFilterType) {
		if (jQuery.isFunction(oFilterType)) {
			sValue = oFilterType(sValue);
		} else {
			sValue = oFilterType.parseValue(sValue, "string");
		}
	}

	return sValue;
};

sap.ui.table.Column.prototype._renderFilterIcon = function() {
	var oTable = this.getParent();
	if (oTable && oTable.getDomRef()) {
		var sCurrentTheme = sap.ui.getCore().getConfiguration().getTheme();
		var oImage = sap.ui.getCore().byId(this.getId() + "-filterIcon") || sap.ui.table.TableHelper.createImage(this.getId() + "-filterIcon");
		oImage.$().remove();
		oImage.addStyleClass("sapUiTableColIconsFilter");
		if (this.getFiltered()) {
			oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_filter.gif"));
			var oRenderManager = new sap.ui.core.RenderManager();
			var htmlImage = oRenderManager.getHTML(oImage);
			jQuery(htmlImage).prependTo(this.getDomRef("icons"));
			this.$().find(".sapUiTableColCell").addClass("sapUiTableColFiltered");
		} else {
			this.$().find(".sapUiTableColCell").removeClass("sapUiTableColFiltered");
		}
	}
};

sap.ui.table.Column.prototype._restoreIcons = function() {

	if (this.getSorted()) {
		this._renderSortIcon();
	}

	if (this.getFiltered()) {
		this._renderFilterIcon();
	}

};

/**
 * Returns whether the column should be rendered or not. 
 * @return {boolean} true, if the column should be rendered
 * @protected 
 */
sap.ui.table.Column.prototype.shouldRender = function() {
	return this.getVisible() && !this.getGrouped();
};

/*
 * support the declarative usage of the filter type 
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Column.prototype.setFilterType = function(vType) {
	var oType = vType;
	if (typeof (vType) === "string") {
		try {
			// similar to BindingParser allow to specify formatOptions and constraints for types
			var mConfig = jQuery.sap.parseJS(vType);
			if (typeof (mConfig.type) === "string") {
				var fnType = jQuery.sap.getObject(mConfig.type);
				oType = fnType && new fnType(mConfig.formatOptions, mConfig.constraints);
			}
		} catch (ex) {
			var fnType = jQuery.sap.getObject(vType);
			oType = fnType && new fnType();
		}
		// check for a valid type
		if (!(oType instanceof sap.ui.model.Type)) {
			jQuery.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");
			oType = undefined;
		}
	}
	this.setProperty("filterType", oType, true);
	return this;
};


}; // end of sap/ui/table/Column.js
if ( !jQuery.sap.isDeclared('sap.ui.table.ColumnMenu') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.ColumnMenu.
jQuery.sap.declare("sap.ui.table.ColumnMenu");

jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained



/**
 * Constructor for a new ColumnMenu.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.Menu#constructor sap.ui.unified.Menu}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The column menu provides all common actions that can be performed on a column.
 * @extends sap.ui.unified.Menu
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.table.ColumnMenu
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.Menu.extend("sap.ui.table.ColumnMenu", { metadata : {

	library : "sap.ui.table"
}});


/**
 * Creates a new subclass of class sap.ui.table.ColumnMenu with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.ColumnMenu.extend
 * @function
 */


// Start of sap\ui\table\ColumnMenu.js
jQuery.sap.require('sap.ui.core.RenderManager'); // unlisted dependency retained

jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained

jQuery.sap.require('sap.ui.unified.MenuItem'); // unlisted dependency retained


/**
 * This file defines behavior for the control,
 */


/**
 * Initialization of the ColumnMenu control
 * @private
 */
sap.ui.table.ColumnMenu.prototype.init = function() {
	if(sap.ui.unified.Menu.prototype.init){
		sap.ui.unified.Menu.prototype.init.apply(this, arguments);
	}
	this.addStyleClass("sapUiTableColumnMenu");
	this.oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
	this._bInvalidated = true;
	this._iPopupClosedTimeoutId = null;
	this._oColumn = null;
	this._oTable = null;
	this._attachPopupClosed();
};


/**
 * Termination of the ColumnMenu control
 * @private
 */
sap.ui.table.ColumnMenu.prototype.exit = function() {
	if(sap.ui.unified.Menu.prototype.exit){
		sap.ui.unified.Menu.prototype.exit.apply(this, arguments);
	}
	window.clearTimeout(this._iPopupClosedTimeoutId);
	this._detachEvents();
	this._oColumn = this._oTable = null;
};


/**
 * Event handler. Called when the theme is changed.
 * @private
 */
sap.ui.table.ColumnMenu.prototype.onThemeChanged = function() {
	if (this.getDomRef()) {
		this._invalidate();
	}
};


/**
 * Overwrite of {@link sap.ui.unified.Menu#setParent} method.
 * @see sap.ui.unified.Menu#setParent
 * @private
 */
sap.ui.table.ColumnMenu.prototype.setParent = function(oParent) {
	this._detachEvents();
	this._invalidate();
	this._updateReferences(oParent);
	this._attachEvents();
	return sap.ui.unified.Menu.prototype.setParent.apply(this, arguments);
};

sap.ui.table.ColumnMenu.prototype._updateReferences = function(oParent) {
	this._oColumn = oParent;
	if (oParent) {
		jQuery.sap.assert(oParent instanceof sap.ui.table.Column, "ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column");

		this._oTable = this._oColumn.getParent();
		if (this._oTable) {
			jQuery.sap.assert(this._oTable instanceof sap.ui.table.Table, "ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table");	
		}
	}
};


/**
 * Attaches the required event handlers.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._attachEvents = function() {
	if (this._oTable) {
		this._oTable.attachColumnVisibility(this._invalidate, this);
		this._oTable.attachColumnMove(this._invalidate, this);
	}
};


/**
 * Detaches the required event handlers.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._detachEvents = function() {
	if (this._oTable) {
		this._oTable.detachColumnVisibility(this._invalidate, this);
		this._oTable.detachColumnMove(this._invalidate, this);
	}
};

/**
 * Invalidates the column menu control items. Forces recreation of the menu items when the menu is opened.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._invalidate = function() {
	this._bInvalidated = true;
};


/**
 * Special handling for IE < 9 when the popup is closed.
 * The associated column of the menu is focused when the menu is closed.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._attachPopupClosed = function() {
	// put the focus back into the column header after the 
	// popup is being closed.
	var that = this;

	if (!sap.ui.Device.support.touch) {
		this.getPopup().attachClosed(function(oEvent) {
			that._iPopupClosedTimeoutId = window.setTimeout(function() {
				if (that._oColumn) {
					that._oColumn.focus();
				}
			}, 0);
		});	
	}
};


/**
 * Overwrite of {@link sap.ui.unified.Menu#open} method.
 * @see sap.ui.unified.Menu#open
 * @private
 */
sap.ui.table.ColumnMenu.prototype.open = function() {
	if (this._bInvalidated) {
		this._bInvalidated = false;
		this.destroyItems();
		this._addMenuItems();
	}

	if (this.getItems().length > 0) {
		sap.ui.unified.Menu.prototype.open.apply(this, arguments);
	}
};


/**
 * Adds the menu items to the menu.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._addMenuItems = function() {
	if (this._oColumn) {
		this._addSortMenuItem(false);
		this._addSortMenuItem(true);
		this._addFilterMenuItem();
		this._addGroupMenuItem();
		this._addFreezeMenuItem();
		this._addColumnVisibilityMenuItem();
	}
};


/**
 * Adds the sort menu item to the menu.
 * @param {boolean} bDesc the sort direction. <code>true</code> for descending.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._addSortMenuItem = function(bDesc) {
	var oColumn = this._oColumn;

	var sDir = bDesc ? "desc" : "asc";
	var sIcon = bDesc ? "sort-descending" : "sort-ascending";
	if (oColumn.getSortProperty() && oColumn.getShowSortMenuEntry()) {
		this.addItem(this._createMenuItem(
			sDir,
			"TBL_SORT_" + sDir.toUpperCase(),
			sIcon,
			function(oEvent) {
				oColumn.sort(bDesc, oEvent.getParameter("ctrlKey") === true);
			}
		));
	}
};


/**
 * Adds the filter menu item to the menu.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._addFilterMenuItem = function() {
	var oColumn = this._oColumn;
	var oTable = oColumn.getParent();
	var bEnableCustomFilter = false;

	if(oTable) {
		bEnableCustomFilter = oTable.getEnableCustomFilter();
	}

	if (oColumn.getFilterProperty() && oColumn.getShowFilterMenuEntry()) {

		if(bEnableCustomFilter) {
			this.addItem(this._createMenuItem(
				"filter",
				"TBL_FILTER_ITEM",
				"filter",
				function(oEvent) {
					oTable.fireCustomFilter({
						column: oColumn
					});
				}
			));
		}
		else {
			this.addItem(this._createMenuTextFieldItem(
				"filter",
				"TBL_FILTER",
				"filter",
				oColumn.getFilterValue(),
				function(oEvent) {
					oColumn.filter(this.getValue());
				}
			));
		}
	}
};


/**
 * Adds the group menu item to the menu.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._addGroupMenuItem = function() {
	var oColumn = this._oColumn;
	var oTable = this._oTable;
	if (oTable && oTable.getEnableGrouping() && oColumn.getSortProperty()) {
		this.addItem(this._createMenuItem(
			"group",
			"TBL_GROUP",
			null,
			jQuery.proxy(function(oEvent) {
				oTable.setGroupBy(oColumn);
			},this)
		));
	}
};


/**
 * Adds the freeze menu item to the menu.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._addFreezeMenuItem = function() {
	var oColumn = this._oColumn;
	var oTable = this._oTable;
	if (oTable && oTable.getEnableColumnFreeze()) {
		var iColumnIndex = jQuery.inArray(oColumn, oTable.getColumns());
		var bIsFixedColumn = iColumnIndex + 1 == oTable.getFixedColumnCount();
		this.addItem(this._createMenuItem(
			"freeze",
			bIsFixedColumn ? "TBL_UNFREEZE" : "TBL_FREEZE",
			null,
			function(oEvent) {
				
				// forward the event
				var bExecuteDefault = oTable.fireColumnFreeze({
					column: oColumn
				});

				// execute the column freezing
				if (bExecuteDefault) {
					if (bIsFixedColumn) {
						oTable.setFixedColumnCount(0);
					} else {
						oTable.setFixedColumnCount(iColumnIndex + 1);
					}
				}
			}
		));
	}
};


/**
 * Adds the column visibility menu item to the menu.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._addColumnVisibilityMenuItem = function() {
	var oTable = this._oTable;

	if (oTable && oTable.getShowColumnVisibilityMenu()) {
		var oColumnVisibiltyMenuItem = this._createMenuItem("column-visibilty", "TBL_COLUMNS");
		this.addItem(oColumnVisibiltyMenuItem);

		var oColumnVisibiltyMenu = new sap.ui.unified.Menu(oColumnVisibiltyMenuItem.getId() + "-menu");
		oColumnVisibiltyMenu.addStyleClass("sapUiTableColumnVisibilityMenu");
		oColumnVisibiltyMenuItem.setSubmenu(oColumnVisibiltyMenu);

		var aColumns = oTable.getColumns();
		
		if (oTable.getColumnVisibilityMenuSorter && typeof oTable.getColumnVisibilityMenuSorter === "function") {
			var oSorter = oTable.getColumnVisibilityMenuSorter();
			if (typeof oSorter === "function") {
				aColumns = aColumns.sort(oSorter);
			}
		}
		
		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oMenuItem = this._createColumnVisibilityMenuItem(oColumnVisibiltyMenu.getId() + "-item-" + i, aColumns[i]);
			oColumnVisibiltyMenu.addItem(oMenuItem);
		}
	}
};


/**
 * Factory method for the column visibility menu item.
 * @param {string} sId the id of the menu item.
 * @param {sap.ui.table.Column} oColumn the associated column to the menu item.
 * @return {sap.ui.unified.MenuItem} the created menu item.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._createColumnVisibilityMenuItem = function(sId, oColumn) {
	var sText = oColumn.getName() || (oColumn.getLabel() && oColumn.getLabel().getText ? oColumn.getLabel().getText() : null); 
	return new sap.ui.unified.MenuItem(sId, {
		text: sText,
		icon: oColumn.getVisible() ? "sap-icon://accept" : null,
		select: jQuery.proxy(function(oEvent) {
			var oMenuItem = oEvent.getSource();
			var bVisible = !oColumn.getVisible();
			if (bVisible || this._oTable._getVisibleColumnCount() > 1) {
				var oTable = oColumn.getParent();
				var bExecuteDefault = true;
				if (oTable && oTable instanceof sap.ui.table.Table) {
					bExecuteDefault = oTable.fireColumnVisibility({
						column: oColumn,
						newVisible: bVisible
					});
				}
				if (bExecuteDefault) {
					oColumn.setVisible(bVisible);
				}
				oMenuItem.setIcon(bVisible ? "sap-icon://accept" : null);
			}
		}, this)
	});
};


/**
 * Factory method for a menu item.
 * @param {string} sId the id of the menu item.
 * @param {string} sTextI18nKey the i18n key that should be used for the menu item text.
 * @param {string} sIcon the icon name
 * @param {function} fHandler the handler function to call when the item gets selected.
 * @return {sap.ui.unified.MenuItem} the created menu item.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._createMenuItem = function(sId, sTextI18nKey, sIcon, fHandler) {
	return new sap.ui.unified.MenuItem(this.getId() + "-" + sId, {
		text: this.oResBundle.getText(sTextI18nKey),
		icon: sIcon ? "sap-icon://" + sIcon : null,
		select: fHandler || function() {}
	});
};


/**
 * Factory method for a menu text field item.
 * @param {string} sId the id of the menu item.
 * @param {string} sTextI18nKey the i18n key that should be used for the menu item text.
 * @param {string} sIcon the icon name
 * @param {string} sValue the default value of the text field
 * @param {function} fHandler the handler function to call when the item gets selected.
 * @return {sap.ui.unified.MenuTextFieldItem} the created menu text field item.
 * @private
 */
sap.ui.table.ColumnMenu.prototype._createMenuTextFieldItem = function(sId, sTextI18nKey, sIcon, sValue, fHandler) {
	jQuery.sap.require("sap.ui.unified.MenuTextFieldItem");
	fHandler = fHandler || function() {};
	return new sap.ui.unified.MenuTextFieldItem(this.getId() + "-" + sId, {
		label: this.oResBundle.getText(sTextI18nKey),
		icon: sIcon ? "sap-icon://" + sIcon : null,
		value: sValue,
		select: fHandler || function() {}
	});
};


/**
 * sets a new filter value into the filter field
 * @private
 */
sap.ui.table.ColumnMenu.prototype._setFilterValue = function(sValue) {
	var oFilterField = sap.ui.getCore().byId(this.getId() + "-filter");
	if (oFilterField) {
		oFilterField.setValue(sValue);
	}
	return this;
};

/**
 * Sets the value state of the filter field
 * @private
 */
sap.ui.table.ColumnMenu.prototype._setFilterState = function(sFilterState) {
	var oFilterField = sap.ui.getCore().byId(this.getId() + "-filter");
	if (oFilterField) {
		oFilterField.setValueState(sFilterState);
	}
	return this;
};

}; // end of sap/ui/table/ColumnMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.table.DataTableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.DataTable
jQuery.sap.declare("sap.ui.table.DataTableRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class DataTableRenderer
 * @static
 */
sap.ui.table.DataTableRenderer = sap.ui.core.Renderer.extend(sap.ui.table.TreeTableRenderer);

}; // end of sap/ui/table/DataTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Row') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.Row.
jQuery.sap.declare("sap.ui.table.Row");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new Row.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getCells cells} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The row.
 * @extends sap.ui.core.Element
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.table.Row
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.table.Row", { metadata : {

	publicMethods : [
		// methods
		"getIndex"
	],
	library : "sap.ui.table",
	defaultAggregation : "cells",
	aggregations : {
		"cells" : {type : "sap.ui.core.Control", multiple : true, singularName : "cell"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.table.Row with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.Row.extend
 * @function
 */


/**
 * Getter for aggregation <code>cells</code>.<br/>
 * The controls for the cells.
 * 
 * <strong>Note</strong>: this is the default aggregation for Row.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.table.Row#getCells
 * @function
 */


/**
 * Inserts a cell into the aggregation named <code>cells</code>.
 *
 * @param {sap.ui.core.Control}
 *          oCell the cell to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the cell should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the cell is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the cell is inserted at 
 *             the last position        
 * @return {sap.ui.table.Row} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Row#insertCell
 * @function
 */

/**
 * Adds some cell <code>oCell</code> 
 * to the aggregation named <code>cells</code>.
 *
 * @param {sap.ui.core.Control}
 *            oCell the cell to add; if empty, nothing is inserted
 * @return {sap.ui.table.Row} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Row#addCell
 * @function
 */

/**
 * Removes an cell from the aggregation named <code>cells</code>.
 *
 * @param {int | string | sap.ui.core.Control} vCell the cell to remove or its index or id
 * @return {sap.ui.core.Control} the removed cell or null
 * @public
 * @name sap.ui.table.Row#removeCell
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>cells</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.table.Row#removeAllCells
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>cells</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oCell the cell whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.table.Row#indexOfCell
 * @function
 */
	

/**
 * Destroys all the cells in the aggregation 
 * named <code>cells</code>.
 * @return {sap.ui.table.Row} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Row#destroyCells
 * @function
 */


/**
 * Returns the index of the row in the table or -1 if not added to a table.
 *
 * @name sap.ui.table.Row#getIndex
 * @function
 * @type int
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\table\Row.js
sap.ui.table.Row.prototype.getIndex = function() {
	var oTable = this.getParent();
	if (oTable) {
		var iFirstRow = oTable.getFirstVisibleRow();
		var iRowIndex = oTable.indexOfRow(this);
		return iFirstRow + iRowIndex;
	}
	return -1;
};
}; // end of sap/ui/table/Row.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Table') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.Table.
jQuery.sap.declare("sap.ui.table.Table");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Table.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: 'auto')</li>
 * <li>{@link #getRowHeight rowHeight} : int</li>
 * <li>{@link #getColumnHeaderHeight columnHeaderHeight} : int</li>
 * <li>{@link #getColumnHeaderVisible columnHeaderVisible} : boolean (default: true)</li>
 * <li>{@link #getVisibleRowCount visibleRowCount} : int (default: 10)</li>
 * <li>{@link #getFirstVisibleRow firstVisibleRow} : int (default: 0)</li>
 * <li>{@link #getSelectionMode selectionMode} : sap.ui.table.SelectionMode (default: sap.ui.table.SelectionMode.Multi)</li>
 * <li>{@link #getSelectionBehavior selectionBehavior} : sap.ui.table.SelectionBehavior (default: sap.ui.table.SelectionBehavior.RowSelector)</li>
 * <li>{@link #getSelectedIndex selectedIndex} : int (default: -1)</li>
 * <li>{@link #getAllowColumnReordering allowColumnReordering} : boolean (default: true)</li>
 * <li>{@link #getEditable editable} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getNavigationMode navigationMode} : sap.ui.table.NavigationMode (default: sap.ui.table.NavigationMode.Scrollbar)</li>
 * <li>{@link #getThreshold threshold} : int (default: 100)</li>
 * <li>{@link #getEnableColumnReordering enableColumnReordering} : boolean (default: true)</li>
 * <li>{@link #getEnableGrouping enableGrouping} : boolean (default: false)</li>
 * <li>{@link #getShowColumnVisibilityMenu showColumnVisibilityMenu} : boolean (default: false)</li>
 * <li>{@link #getShowNoData showNoData} : boolean (default: true)</li>
 * <li>{@link #getVisibleRowCountMode visibleRowCountMode} : sap.ui.table.VisibleRowCountMode (default: sap.ui.table.VisibleRowCountMode.Fixed)</li>
 * <li>{@link #getFixedColumnCount fixedColumnCount} : int (default: 0)</li>
 * <li>{@link #getFixedRowCount fixedRowCount} : int (default: 0)</li>
 * <li>{@link #getMinAutoRowCount minAutoRowCount} : int (default: 5)</li>
 * <li>{@link #getFixedBottomRowCount fixedBottomRowCount} : int (default: 0)</li>
 * <li>{@link #getEnableColumnFreeze enableColumnFreeze} : boolean (default: false)</li>
 * <li>{@link #getEnableCellFilter enableCellFilter} : boolean (default: false)</li>
 * <li>{@link #getNoDataText noDataText} : string</li>
 * <li>{@link #getShowOverlay showOverlay} : boolean (default: false)</li>
 * <li>{@link #getEnableSelectAll enableSelectAll} : boolean (default: true)</li>
 * <li>{@link #getEnableCustomFilter enableCustomFilter} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getTitle title} : sap.ui.core.Control|string</li>
 * <li>{@link #getFooter footer} : sap.ui.core.Control|string</li>
 * <li>{@link #getToolbar toolbar} : sap.ui.core.Toolbar</li>
 * <li>{@link #getExtension extension} : sap.ui.core.Control[]</li>
 * <li>{@link #getColumns columns} <strong>(default aggregation)</strong> : sap.ui.table.Column[]</li>
 * <li>{@link #getRows rows} : sap.ui.table.Row[]</li>
 * <li>{@link #getNoData noData} : sap.ui.core.Control|string</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getGroupBy groupBy} : string | sap.ui.table.Column</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.table.Table#event:rowSelectionChange rowSelectionChange} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:columnSelect columnSelect} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:columnResize columnResize} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:columnMove columnMove} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:sort sort} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:filter filter} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:group group} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:columnVisibility columnVisibility} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:cellClick cellClick} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:cellContextmenu cellContextmenu} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:columnFreeze columnFreeze} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.table.Table#event:customFilter customFilter} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The Table control provides a set of sophisticated and comfort functions for table design. For example, you can make settings for the number of visible rows. The first visible row can be explicitly set. For the selection of rows, a Multi, a Single, and a None mode are available.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.table.Table
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.table.Table", { metadata : {

	publicMethods : [
		// methods
		"getSelectedIndices", "addSelectionInterval", "setSelectionInterval", "removeSelectionInterval", "isIndexSelected", "clearSelection", "selectAll", "getContextByIndex", "sort", "filter"
	],
	library : "sap.ui.table",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : 'auto'},
		"rowHeight" : {type : "int", group : "Appearance", defaultValue : null},
		"columnHeaderHeight" : {type : "int", group : "Appearance", defaultValue : null},
		"columnHeaderVisible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"visibleRowCount" : {type : "int", group : "Appearance", defaultValue : 10},
		"firstVisibleRow" : {type : "int", group : "Appearance", defaultValue : 0},
		"selectionMode" : {type : "sap.ui.table.SelectionMode", group : "Behavior", defaultValue : sap.ui.table.SelectionMode.Multi},
		"selectionBehavior" : {type : "sap.ui.table.SelectionBehavior", group : "Behavior", defaultValue : sap.ui.table.SelectionBehavior.RowSelector},
		"selectedIndex" : {type : "int", group : "Appearance", defaultValue : -1},
		"allowColumnReordering" : {type : "boolean", group : "Behavior", defaultValue : true, deprecated: true},
		"editable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"navigationMode" : {type : "sap.ui.table.NavigationMode", group : "Behavior", defaultValue : sap.ui.table.NavigationMode.Scrollbar},
		"threshold" : {type : "int", group : "Appearance", defaultValue : 100},
		"enableColumnReordering" : {type : "boolean", group : "Behavior", defaultValue : true},
		"enableGrouping" : {type : "boolean", group : "Behavior", defaultValue : false},
		"showColumnVisibilityMenu" : {type : "boolean", group : "Appearance", defaultValue : false},
		"showNoData" : {type : "boolean", group : "Appearance", defaultValue : true},
		"visibleRowCountMode" : {type : "sap.ui.table.VisibleRowCountMode", group : "Appearance", defaultValue : sap.ui.table.VisibleRowCountMode.Fixed},
		"fixedColumnCount" : {type : "int", group : "Appearance", defaultValue : 0},
		"fixedRowCount" : {type : "int", group : "Appearance", defaultValue : 0},
		"minAutoRowCount" : {type : "int", group : "Appearance", defaultValue : 5},
		"fixedBottomRowCount" : {type : "int", group : "Appearance", defaultValue : 0},
		"enableColumnFreeze" : {type : "boolean", group : "Behavior", defaultValue : false},
		"enableCellFilter" : {type : "boolean", group : "Behavior", defaultValue : false},
		"noDataText" : {type : "string", group : "Appearance", defaultValue : null, deprecated: true},
		"showOverlay" : {type : "boolean", group : "Appearance", defaultValue : false},
		"enableSelectAll" : {type : "boolean", group : "Behavior", defaultValue : true},
		"enableCustomFilter" : {type : "boolean", group : "Behavior", defaultValue : false}
	},
	defaultAggregation : "columns",
	aggregations : {
		"title" : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false}, 
		"footer" : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false}, 
		"toolbar" : {type : "sap.ui.core.Toolbar", multiple : false}, 
		"extension" : {type : "sap.ui.core.Control", multiple : true, singularName : "extension"}, 
		"columns" : {type : "sap.ui.table.Column", multiple : true, singularName : "column", bindable : "bindable"}, 
		"rows" : {type : "sap.ui.table.Row", multiple : true, singularName : "row", bindable : "bindable"}, 
		"noData" : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false}
	},
	associations : {
		"groupBy" : {type : "sap.ui.table.Column", multiple : false}
	},
	events : {
		"rowSelectionChange" : {}, 
		"columnSelect" : {allowPreventDefault : true}, 
		"columnResize" : {allowPreventDefault : true}, 
		"columnMove" : {allowPreventDefault : true}, 
		"sort" : {allowPreventDefault : true}, 
		"filter" : {allowPreventDefault : true}, 
		"group" : {allowPreventDefault : true}, 
		"columnVisibility" : {allowPreventDefault : true}, 
		"cellClick" : {allowPreventDefault : true}, 
		"cellContextmenu" : {allowPreventDefault : true}, 
		"columnFreeze" : {allowPreventDefault : true}, 
		"customFilter" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.table.Table with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.Table.extend
 * @function
 */

sap.ui.table.Table.M_EVENTS = {'rowSelectionChange':'rowSelectionChange','columnSelect':'columnSelect','columnResize':'columnResize','columnMove':'columnMove','sort':'sort','filter':'filter','group':'group','columnVisibility':'columnVisibility','cellClick':'cellClick','cellContextmenu':'cellContextmenu','columnFreeze':'columnFreeze','customFilter':'customFilter'};


/**
 * Getter for property <code>width</code>.
 * Width of the Table.
 *
 * Default value is <code>auto</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.table.Table#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>auto</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setWidth
 * @function
 */


/**
 * Getter for property <code>rowHeight</code>.
 * Height of a row of the Table in pixel.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>rowHeight</code>
 * @public
 * @name sap.ui.table.Table#getRowHeight
 * @function
 */

/**
 * Setter for property <code>rowHeight</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iRowHeight  new value for property <code>rowHeight</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setRowHeight
 * @function
 */


/**
 * Getter for property <code>columnHeaderHeight</code>.
 * Height of the column header of the Table in pixel.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>columnHeaderHeight</code>
 * @public
 * @name sap.ui.table.Table#getColumnHeaderHeight
 * @function
 */

/**
 * Setter for property <code>columnHeaderHeight</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iColumnHeaderHeight  new value for property <code>columnHeaderHeight</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setColumnHeaderHeight
 * @function
 */


/**
 * Getter for property <code>columnHeaderVisible</code>.
 * Flag whether the column header is visible or not.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>columnHeaderVisible</code>
 * @public
 * @name sap.ui.table.Table#getColumnHeaderVisible
 * @function
 */

/**
 * Setter for property <code>columnHeaderVisible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bColumnHeaderVisible  new value for property <code>columnHeaderVisible</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setColumnHeaderVisible
 * @function
 */


/**
 * Getter for property <code>visibleRowCount</code>.
 * Count of visible rows (will overwrite the height property).
 *
 * Default value is <code>10</code>
 *
 * @return {int} the value of property <code>visibleRowCount</code>
 * @public
 * @name sap.ui.table.Table#getVisibleRowCount
 * @function
 */

/**
 * Setter for property <code>visibleRowCount</code>.
 *
 * Default value is <code>10</code> 
 *
 * @param {int} iVisibleRowCount  new value for property <code>visibleRowCount</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setVisibleRowCount
 * @function
 */


/**
 * Getter for property <code>firstVisibleRow</code>.
 * First visible row.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>firstVisibleRow</code>
 * @public
 * @name sap.ui.table.Table#getFirstVisibleRow
 * @function
 */

/**
 * Setter for property <code>firstVisibleRow</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iFirstVisibleRow  new value for property <code>firstVisibleRow</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setFirstVisibleRow
 * @function
 */


/**
 * Getter for property <code>selectionMode</code>.
 * Selection mode of the Table.
 *
 * Default value is <code>Multi</code>
 *
 * @return {sap.ui.table.SelectionMode} the value of property <code>selectionMode</code>
 * @public
 * @name sap.ui.table.Table#getSelectionMode
 * @function
 */

/**
 * Setter for property <code>selectionMode</code>.
 *
 * Default value is <code>Multi</code> 
 *
 * @param {sap.ui.table.SelectionMode} oSelectionMode  new value for property <code>selectionMode</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setSelectionMode
 * @function
 */


/**
 * Getter for property <code>selectionBehavior</code>.
 * Selection behavior of the Table.
 *
 * Default value is <code>RowSelector</code>
 *
 * @return {sap.ui.table.SelectionBehavior} the value of property <code>selectionBehavior</code>
 * @public
 * @name sap.ui.table.Table#getSelectionBehavior
 * @function
 */

/**
 * Setter for property <code>selectionBehavior</code>.
 *
 * Default value is <code>RowSelector</code> 
 *
 * @param {sap.ui.table.SelectionBehavior} oSelectionBehavior  new value for property <code>selectionBehavior</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setSelectionBehavior
 * @function
 */


/**
 * Getter for property <code>selectedIndex</code>.
 * Zero-based index of selected item. Index value for no selection is -1. When multi-selection is enabled and multiple items are selected, the method returns the lead selected item. Sets the zero-based index of the currently selected item. This method removes any previous selections. When the given index is invalid, the call is ignored.
 *
 * Default value is <code>-1</code>
 *
 * @return {int} the value of property <code>selectedIndex</code>
 * @public
 * @name sap.ui.table.Table#getSelectedIndex
 * @function
 */

/**
 * Setter for property <code>selectedIndex</code>.
 *
 * Default value is <code>-1</code> 
 *
 * @param {int} iSelectedIndex  new value for property <code>selectedIndex</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setSelectedIndex
 * @function
 */


/**
 * Getter for property <code>allowColumnReordering</code>.
 * Flag to enable or disable column reordering
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>allowColumnReordering</code>
 * @public
 * @deprecated Since version 1.5.2. 
 * Use the property enableColumnReordering instead.
 * @name sap.ui.table.Table#getAllowColumnReordering
 * @function
 */

/**
 * Setter for property <code>allowColumnReordering</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bAllowColumnReordering  new value for property <code>allowColumnReordering</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.5.2. 
 * Use the property enableColumnReordering instead.
 * @name sap.ui.table.Table#setAllowColumnReordering
 * @function
 */


/**
 * Getter for property <code>editable</code>.
 * Flag whether the controls of the Table are editable or not (currently this only controls the background color!)
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @name sap.ui.table.Table#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setEditable
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.table.Table#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setVisible
 * @function
 */


/**
 * Getter for property <code>navigationMode</code>.
 * Flag whether to use the scroll mode or paging mode. If the Paginator mode is used it will require the sap.ui.commons library!
 *
 * Default value is <code>Scrollbar</code>
 *
 * @return {sap.ui.table.NavigationMode} the value of property <code>navigationMode</code>
 * @public
 * @name sap.ui.table.Table#getNavigationMode
 * @function
 */

/**
 * Setter for property <code>navigationMode</code>.
 *
 * Default value is <code>Scrollbar</code> 
 *
 * @param {sap.ui.table.NavigationMode} oNavigationMode  new value for property <code>navigationMode</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setNavigationMode
 * @function
 */


/**
 * Getter for property <code>threshold</code>.
 * Threshold to fetch the next chunk of data. The minimal threshold can be the visible row count of the Table. If the value is 0 then the thresholding is disabled.
 *
 * Default value is <code>100</code>
 *
 * @return {int} the value of property <code>threshold</code>
 * @public
 * @name sap.ui.table.Table#getThreshold
 * @function
 */

/**
 * Setter for property <code>threshold</code>.
 *
 * Default value is <code>100</code> 
 *
 * @param {int} iThreshold  new value for property <code>threshold</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setThreshold
 * @function
 */


/**
 * Getter for property <code>enableColumnReordering</code>.
 * Flag to enable or disable column reordering
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enableColumnReordering</code>
 * @public
 * @name sap.ui.table.Table#getEnableColumnReordering
 * @function
 */

/**
 * Setter for property <code>enableColumnReordering</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnableColumnReordering  new value for property <code>enableColumnReordering</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setEnableColumnReordering
 * @function
 */


/**
 * Getter for property <code>enableGrouping</code>.
 * Flag to enable or disable column grouping. (experimental!)
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>enableGrouping</code>
 * @public
 * @name sap.ui.table.Table#getEnableGrouping
 * @function
 */

/**
 * Setter for property <code>enableGrouping</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bEnableGrouping  new value for property <code>enableGrouping</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setEnableGrouping
 * @function
 */


/**
 * Getter for property <code>showColumnVisibilityMenu</code>.
 * Flag to show or hide the column visibility menu.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showColumnVisibilityMenu</code>
 * @public
 * @name sap.ui.table.Table#getShowColumnVisibilityMenu
 * @function
 */

/**
 * Setter for property <code>showColumnVisibilityMenu</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowColumnVisibilityMenu  new value for property <code>showColumnVisibilityMenu</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setShowColumnVisibilityMenu
 * @function
 */


/**
 * Getter for property <code>showNoData</code>.
 * Flag whether to show the no data overlay or not once the table is empty.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showNoData</code>
 * @public
 * @name sap.ui.table.Table#getShowNoData
 * @function
 */

/**
 * Setter for property <code>showNoData</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowNoData  new value for property <code>showNoData</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setShowNoData
 * @function
 */


/**
 * Getter for property <code>visibleRowCountMode</code>.
 * This defines how the table handles the visible rows in the table. The default behavior is, that a fixed row count is defined. If you change it to auto the visibleRowCount property is changed by the table automatically. It will then adjust its maximum row count to the space it is allowed to cover (limited by the surrounding container) and its minimum row count to the value of the property minAutoRowCount (default value : 5) In manual mode the user can change the visibleRowCount interactively.
 *
 * Default value is <code>Fixed</code>
 *
 * @return {sap.ui.table.VisibleRowCountMode} the value of property <code>visibleRowCountMode</code>
 * @public
 * @since 1.9.2
 * @name sap.ui.table.Table#getVisibleRowCountMode
 * @function
 */

/**
 * Setter for property <code>visibleRowCountMode</code>.
 *
 * Default value is <code>Fixed</code> 
 *
 * @param {sap.ui.table.VisibleRowCountMode} oVisibleRowCountMode  new value for property <code>visibleRowCountMode</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.9.2
 * @name sap.ui.table.Table#setVisibleRowCountMode
 * @function
 */


/**
 * Getter for property <code>fixedColumnCount</code>.
 * Number of columns that are fix on the left. When you use a horizontal scroll bar, only the columns which are not fixed, will scroll. Fixed columns need a defined width for the feature to work.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>fixedColumnCount</code>
 * @public
 * @name sap.ui.table.Table#getFixedColumnCount
 * @function
 */

/**
 * Setter for property <code>fixedColumnCount</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iFixedColumnCount  new value for property <code>fixedColumnCount</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setFixedColumnCount
 * @function
 */


/**
 * Getter for property <code>fixedRowCount</code>.
 * Number of rows that are fix on the top. When you use a vertical scroll bar, only the rows which are not fixed, will scroll.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>fixedRowCount</code>
 * @public
 * @name sap.ui.table.Table#getFixedRowCount
 * @function
 */

/**
 * Setter for property <code>fixedRowCount</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iFixedRowCount  new value for property <code>fixedRowCount</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setFixedRowCount
 * @function
 */


/**
 * Getter for property <code>minAutoRowCount</code>.
 * This property is used to set the minimum count of visible rows when the property visibleRowCountMode is set to Auto. For any other visibleRowCountMode, it is ignored.
 *
 * Default value is <code>5</code>
 *
 * @return {int} the value of property <code>minAutoRowCount</code>
 * @public
 * @name sap.ui.table.Table#getMinAutoRowCount
 * @function
 */

/**
 * Setter for property <code>minAutoRowCount</code>.
 *
 * Default value is <code>5</code> 
 *
 * @param {int} iMinAutoRowCount  new value for property <code>minAutoRowCount</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setMinAutoRowCount
 * @function
 */


/**
 * Getter for property <code>fixedBottomRowCount</code>.
 * Number of rows that are fix on the bottom. When you use a vertical scroll bar, only the rows which are not fixed, will scroll. (experimental!)
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>fixedBottomRowCount</code>
 * @public
 * @since 1.18.7
 * @name sap.ui.table.Table#getFixedBottomRowCount
 * @function
 */

/**
 * Setter for property <code>fixedBottomRowCount</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iFixedBottomRowCount  new value for property <code>fixedBottomRowCount</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.18.7
 * @name sap.ui.table.Table#setFixedBottomRowCount
 * @function
 */


/**
 * Getter for property <code>enableColumnFreeze</code>.
 * Flag whether to show or hide the column menu item to freeze or unfreeze a column.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>enableColumnFreeze</code>
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#getEnableColumnFreeze
 * @function
 */

/**
 * Setter for property <code>enableColumnFreeze</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bEnableColumnFreeze  new value for property <code>enableColumnFreeze</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#setEnableColumnFreeze
 * @function
 */


/**
 * Getter for property <code>enableCellFilter</code>.
 * Flag whether to enable or disable the context menu on cells to trigger a filtering with the cell value.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>enableCellFilter</code>
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#getEnableCellFilter
 * @function
 */

/**
 * Setter for property <code>enableCellFilter</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bEnableCellFilter  new value for property <code>enableCellFilter</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#setEnableCellFilter
 * @function
 */


/**
 * Getter for property <code>noDataText</code>.
 * This text is shown, in case there is no data available to be displayed in the Table and no custom noData control is set.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>noDataText</code>
 * @public
 * @since 1.21.0
 * @deprecated Since version 1.22.1. 
 * The aggregation noData also supports string values now. Use noData instead.
 * @name sap.ui.table.Table#getNoDataText
 * @function
 */

/**
 * Setter for property <code>noDataText</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sNoDataText  new value for property <code>noDataText</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @deprecated Since version 1.22.1. 
 * The aggregation noData also supports string values now. Use noData instead.
 * @name sap.ui.table.Table#setNoDataText
 * @function
 */


/**
 * Getter for property <code>showOverlay</code>.
 * Setting this property to true will show an overlay on top of the Table content and users cannot click anymore on the Table content.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showOverlay</code>
 * @public
 * @since 1.21.2
 * @name sap.ui.table.Table#getShowOverlay
 * @function
 */

/**
 * Setter for property <code>showOverlay</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowOverlay  new value for property <code>showOverlay</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.2
 * @name sap.ui.table.Table#setShowOverlay
 * @function
 */


/**
 * Getter for property <code>enableSelectAll</code>.
 * Specifies if a select all button should be displayed in the top left corner.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enableSelectAll</code>
 * @public
 * @since 1.23.0
 * @name sap.ui.table.Table#getEnableSelectAll
 * @function
 */

/**
 * Setter for property <code>enableSelectAll</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnableSelectAll  new value for property <code>enableSelectAll</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.23.0
 * @name sap.ui.table.Table#setEnableSelectAll
 * @function
 */


/**
 * Getter for property <code>enableCustomFilter</code>.
 * Set this parameter to true to implement your own filter behaviour. Instead of the filter input box a button will be rendered for which' press event (customFilter) you can register an event handler.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>enableCustomFilter</code>
 * @public
 * @since 1.23.0
 * @name sap.ui.table.Table#getEnableCustomFilter
 * @function
 */

/**
 * Setter for property <code>enableCustomFilter</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bEnableCustomFilter  new value for property <code>enableCustomFilter</code>
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.23.0
 * @name sap.ui.table.Table#setEnableCustomFilter
 * @function
 */


/**
 * Getter for aggregation <code>title</code>.<br/>
 * Control or text of title section of the Table (if not set it will be hidden)
 * 
 * @return {sap.ui.core.Control|string}
 * @public
 * @name sap.ui.table.Table#getTitle
 * @function
 */


/**
 * Setter for the aggregated <code>title</code>.
 * @param {sap.ui.core.Control|string} oTitle
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setTitle
 * @function
 */
	

/**
 * Destroys the title in the aggregation 
 * named <code>title</code>.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#destroyTitle
 * @function
 */


/**
 * Getter for aggregation <code>footer</code>.<br/>
 * Control or text of footer section of the Table (if not set it will be hidden)
 * 
 * @return {sap.ui.core.Control|string}
 * @public
 * @name sap.ui.table.Table#getFooter
 * @function
 */


/**
 * Setter for the aggregated <code>footer</code>.
 * @param {sap.ui.core.Control|string} oFooter
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setFooter
 * @function
 */
	

/**
 * Destroys the footer in the aggregation 
 * named <code>footer</code>.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#destroyFooter
 * @function
 */


/**
 * Getter for aggregation <code>toolbar</code>.<br/>
 * Toolbar of the Table (if not set it will be hidden)
 * 
 * @return {sap.ui.core.Toolbar}
 * @public
 * @name sap.ui.table.Table#getToolbar
 * @function
 */


/**
 * Setter for the aggregated <code>toolbar</code>.
 * @param {sap.ui.core.Toolbar} oToolbar
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setToolbar
 * @function
 */
	

/**
 * Destroys the toolbar in the aggregation 
 * named <code>toolbar</code>.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#destroyToolbar
 * @function
 */


/**
 * Getter for aggregation <code>extension</code>.<br/>
 * Extension section of the Table (if not set it will be hidden)
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.table.Table#getExtension
 * @function
 */


/**
 * Inserts a extension into the aggregation named <code>extension</code>.
 *
 * @param {sap.ui.core.Control}
 *          oExtension the extension to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the extension should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the extension is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the extension is inserted at 
 *             the last position        
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#insertExtension
 * @function
 */

/**
 * Adds some extension <code>oExtension</code> 
 * to the aggregation named <code>extension</code>.
 *
 * @param {sap.ui.core.Control}
 *            oExtension the extension to add; if empty, nothing is inserted
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#addExtension
 * @function
 */

/**
 * Removes an extension from the aggregation named <code>extension</code>.
 *
 * @param {int | string | sap.ui.core.Control} vExtension the extension to remove or its index or id
 * @return {sap.ui.core.Control} the removed extension or null
 * @public
 * @name sap.ui.table.Table#removeExtension
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>extension</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.table.Table#removeAllExtension
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>extension</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oExtension the extension whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.table.Table#indexOfExtension
 * @function
 */
	

/**
 * Destroys all the extension in the aggregation 
 * named <code>extension</code>.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#destroyExtension
 * @function
 */


/**
 * Getter for aggregation <code>columns</code>.<br/>
 * Columns of the Table
 * 
 * <strong>Note</strong>: this is the default aggregation for Table.
 * @return {sap.ui.table.Column[]}
 * @public
 * @name sap.ui.table.Table#getColumns
 * @function
 */


/**
 * Inserts a column into the aggregation named <code>columns</code>.
 *
 * @param {sap.ui.table.Column}
 *          oColumn the column to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the column should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the column is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the column is inserted at 
 *             the last position        
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#insertColumn
 * @function
 */

/**
 * Adds some column <code>oColumn</code> 
 * to the aggregation named <code>columns</code>.
 *
 * @param {sap.ui.table.Column}
 *            oColumn the column to add; if empty, nothing is inserted
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#addColumn
 * @function
 */

/**
 * Removes an column from the aggregation named <code>columns</code>.
 *
 * @param {int | string | sap.ui.table.Column} vColumn the column to remove or its index or id
 * @return {sap.ui.table.Column} the removed column or null
 * @public
 * @name sap.ui.table.Table#removeColumn
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>columns</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.table.Column[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.table.Table#removeAllColumns
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.table.Column</code> in the aggregation named <code>columns</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.table.Column}
 *            oColumn the column whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.table.Table#indexOfColumn
 * @function
 */
	

/**
 * Destroys all the columns in the aggregation 
 * named <code>columns</code>.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#destroyColumns
 * @function
 */


/**
 * Binder for aggregation <code>columns</code>.
 *
 * @param {string} sPath path to a list in the model 
 * @param {sap.ui.core.Element} oTemplate the control template for this aggregation
 * @param {sap.ui.model.Sorter} oSorter the initial sort order (optional)
 * @param {array} aFilters the predefined filters for this aggregation (optional)
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#bindColumns
 * @function
 */

/**
 * Unbinder for aggregation <code>columns</code>.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#unbindColumns
 * @function
 */


/**
 * Getter for aggregation <code>rows</code>.<br/>
 * Rows of the Table
 * 
 * @return {sap.ui.table.Row[]}
 * @public
 * @name sap.ui.table.Table#getRows
 * @function
 */


/**
 * Inserts a row into the aggregation named <code>rows</code>.
 *
 * @param {sap.ui.table.Row}
 *          oRow the row to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the row should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the row is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the row is inserted at 
 *             the last position        
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#insertRow
 * @function
 */

/**
 * Adds some row <code>oRow</code> 
 * to the aggregation named <code>rows</code>.
 *
 * @param {sap.ui.table.Row}
 *            oRow the row to add; if empty, nothing is inserted
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#addRow
 * @function
 */

/**
 * Removes an row from the aggregation named <code>rows</code>.
 *
 * @param {int | string | sap.ui.table.Row} vRow the row to remove or its index or id
 * @return {sap.ui.table.Row} the removed row or null
 * @public
 * @name sap.ui.table.Table#removeRow
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>rows</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.table.Row[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.table.Table#removeAllRows
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.table.Row</code> in the aggregation named <code>rows</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.table.Row}
 *            oRow the row whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.table.Table#indexOfRow
 * @function
 */
	

/**
 * Destroys all the rows in the aggregation 
 * named <code>rows</code>.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#destroyRows
 * @function
 */


/**
 * Binder for aggregation <code>rows</code>.
 *
 * @param {string} sPath path to a list in the model 
 * @param {sap.ui.core.Element} oTemplate the control template for this aggregation
 * @param {sap.ui.model.Sorter} oSorter the initial sort order (optional)
 * @param {array} aFilters the predefined filters for this aggregation (optional)
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#bindRows
 * @function
 */

/**
 * Unbinder for aggregation <code>rows</code>.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#unbindRows
 * @function
 */


/**
 * Getter for aggregation <code>noData</code>.<br/>
 * The value for the noData aggregation can be either a string value or a control instance. The control is shown, in case there is no data for the Table available. In case of a string value this will simply replace the no data text.
 * 
 * @return {sap.ui.core.Control|string}
 * @public
 * @name sap.ui.table.Table#getNoData
 * @function
 */


/**
 * Setter for the aggregated <code>noData</code>.
 * @param {sap.ui.core.Control|string} oNoData
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setNoData
 * @function
 */
	

/**
 * Destroys the noData in the aggregation 
 * named <code>noData</code>.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#destroyNoData
 * @function
 */


/**
 * Group By Column (experimental!)
 *
 * @return {string} Id of the element which is the current target of the <code>groupBy</code> association, or null
 * @public
 * @name sap.ui.table.Table#getGroupBy
 * @function
 */

/**
 * Group By Column (experimental!)
 *
 * @param {string | sap.ui.table.Column} vGroupBy 
 *    Id of an element which becomes the new target of this <code>groupBy</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#setGroupBy
 * @function
 */


	
/**
 * fired when the row selection of the table has been changed (the event parameters can be used to determine selection changes - to find out the selected rows you should better use the table selection API)
 *
 * @name sap.ui.table.Table#rowSelectionChange
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.rowIndex row index which has been clicked so that the selection has been changed (either selected or deselected)
 * @param {object} oControlEvent.getParameters.rowContext binding context of the row which has been clicked so that selection has been changed
 * @param {int[]} oControlEvent.getParameters.rowIndices array of row indices which selection has been changed (either selected or deselected)
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'rowSelectionChange' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when the row selection of the table has been changed (the event parameters can be used to determine selection changes - to find out the selected rows you should better use the table selection API)
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachRowSelectionChange
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'rowSelectionChange' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachRowSelectionChange
 * @function
 */

/**
 * Fire event rowSelectionChange to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'rowIndex' of type <code>int</code> row index which has been clicked so that the selection has been changed (either selected or deselected)</li>
 * <li>'rowContext' of type <code>object</code> binding context of the row which has been clicked so that selection has been changed</li>
 * <li>'rowIndices' of type <code>int[]</code> array of row indices which selection has been changed (either selected or deselected)</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.table.Table#fireRowSelectionChange
 * @function
 */


/**
 * fired when a column of the table has been selected
 *
 * @name sap.ui.table.Table#columnSelect
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column reference to the selected column
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'columnSelect' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when a column of the table has been selected
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachColumnSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'columnSelect' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachColumnSelect
 * @function
 */

/**
 * Fire event columnSelect to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> reference to the selected column</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.table.Table#fireColumnSelect
 * @function
 */


/**
 * fired when a table column is resized.
 *
 * @name sap.ui.table.Table#columnResize
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column resized column.
 * @param {int} oControlEvent.getParameters.width new width of the table in pixel.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'columnResize' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when a table column is resized.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachColumnResize
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'columnResize' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachColumnResize
 * @function
 */

/**
 * Fire event columnResize to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> resized column.</li>
 * <li>'width' of type <code>int</code> new width of the table in pixel.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.table.Table#fireColumnResize
 * @function
 */


/**
 * fired when a table column is moved.
 *
 * @name sap.ui.table.Table#columnMove
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column moved column.
 * @param {int} oControlEvent.getParameters.newPos new position of the column.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'columnMove' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when a table column is moved.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachColumnMove
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'columnMove' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachColumnMove
 * @function
 */

/**
 * Fire event columnMove to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> moved column.</li>
 * <li>'newPos' of type <code>int</code> new position of the column.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.table.Table#fireColumnMove
 * @function
 */


/**
 * fired when the table is sorted.
 *
 * @name sap.ui.table.Table#sort
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column sorted column.
 * @param {sap.ui.table.SortOrder} oControlEvent.getParameters.sortOrder Sort Order
 * @param {boolean} oControlEvent.getParameters.columnAdded If column was added to sorter this is true. If new sort is started this is set to false
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'sort' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when the table is sorted.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachSort
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'sort' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachSort
 * @function
 */

/**
 * Fire event sort to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> sorted column.</li>
 * <li>'sortOrder' of type <code>sap.ui.table.SortOrder</code> Sort Order</li>
 * <li>'columnAdded' of type <code>boolean</code> If column was added to sorter this is true. If new sort is started this is set to false</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.table.Table#fireSort
 * @function
 */


/**
 * fired when the table is filtered.
 *
 * @name sap.ui.table.Table#filter
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column filtered column.
 * @param {string} oControlEvent.getParameters.value filter value.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'filter' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when the table is filtered.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachFilter
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'filter' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachFilter
 * @function
 */

/**
 * Fire event filter to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> filtered column.</li>
 * <li>'value' of type <code>string</code> filter value.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.table.Table#fireFilter
 * @function
 */


/**
 * fired when the table is grouped (experimental!).
 *
 * @name sap.ui.table.Table#group
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column grouped column.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'group' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when the table is grouped (experimental!).
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachGroup
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'group' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachGroup
 * @function
 */

/**
 * Fire event group to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> grouped column.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.table.Table#fireGroup
 * @function
 */


/**
 * fired when the visibility of a table column is changed.
 *
 * @name sap.ui.table.Table#columnVisibility
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column affected column.
 * @param {boolean} oControlEvent.getParameters.visible new value of the visible property.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'columnVisibility' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when the visibility of a table column is changed.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#attachColumnVisibility
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'columnVisibility' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.Table#detachColumnVisibility
 * @function
 */

/**
 * Fire event columnVisibility to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> affected column.</li>
 * <li>'visible' of type <code>boolean</code> new value of the visible property.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.ui.table.Table#fireColumnVisibility
 * @function
 */


/**
 * fired when the user clicks a cell of the table (experimental!).
 *
 * @name sap.ui.table.Table#cellClick
 * @event
 * @since 1.21.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.core.Control} oControlEvent.getParameters.cellControl The control of the cell.
 * @param {int} oControlEvent.getParameters.rowIndex Row index of the selected cell.
 * @param {int} oControlEvent.getParameters.columnIndex Column index of the selected cell.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'cellClick' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when the user clicks a cell of the table (experimental!).
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#attachCellClick
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'cellClick' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#detachCellClick
 * @function
 */

/**
 * Fire event cellClick to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'cellControl' of type <code>sap.ui.core.Control</code> The control of the cell.</li>
 * <li>'rowIndex' of type <code>int</code> Row index of the selected cell.</li>
 * <li>'columnIndex' of type <code>int</code> Column index of the selected cell.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @since 1.21.0
 * @name sap.ui.table.Table#fireCellClick
 * @function
 */


/**
 * fired when the user clicks a cell of the table (experimental!).
 *
 * @name sap.ui.table.Table#cellContextmenu
 * @event
 * @since 1.21.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.core.Control} oControlEvent.getParameters.cellControl The control of the cell.
 * @param {int} oControlEvent.getParameters.rowIndex Row index of the selected cell.
 * @param {int} oControlEvent.getParameters.columnIndex Column index of the selected cell.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'cellContextmenu' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when the user clicks a cell of the table (experimental!).
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#attachCellContextmenu
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'cellContextmenu' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#detachCellContextmenu
 * @function
 */

/**
 * Fire event cellContextmenu to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'cellControl' of type <code>sap.ui.core.Control</code> The control of the cell.</li>
 * <li>'rowIndex' of type <code>int</code> Row index of the selected cell.</li>
 * <li>'columnIndex' of type <code>int</code> Column index of the selected cell.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @since 1.21.0
 * @name sap.ui.table.Table#fireCellContextmenu
 * @function
 */


/**
 * fired when a column of the table should be freezed
 *
 * @name sap.ui.table.Table#columnFreeze
 * @event
 * @since 1.21.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.table.Column} oControlEvent.getParameters.column reference to the column to freeze
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'columnFreeze' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * fired when a column of the table should be freezed
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#attachColumnFreeze
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'columnFreeze' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.21.0
 * @name sap.ui.table.Table#detachColumnFreeze
 * @function
 */

/**
 * Fire event columnFreeze to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'column' of type <code>sap.ui.table.Column</code> reference to the column to freeze</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @since 1.21.0
 * @name sap.ui.table.Table#fireColumnFreeze
 * @function
 */


/**
 * This event is triggered when the custom filter item of the column menu is pressed. The column on which the event was triggered is passed as parameter.
 *
 * @name sap.ui.table.Table#customFilter
 * @event
 * @since 1.23.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'customFilter' event of this <code>sap.ui.table.Table</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.Table</code>.<br/> itself. 
 *  
 * This event is triggered when the custom filter item of the column menu is pressed. The column on which the event was triggered is passed as parameter.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.Table</code>.<br/> itself.
 *
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.23.0
 * @name sap.ui.table.Table#attachCustomFilter
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'customFilter' event of this <code>sap.ui.table.Table</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @public
 * @since 1.23.0
 * @name sap.ui.table.Table#detachCustomFilter
 * @function
 */

/**
 * Fire event customFilter to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.table.Table} <code>this</code> to allow method chaining
 * @protected
 * @since 1.23.0
 * @name sap.ui.table.Table#fireCustomFilter
 * @function
 */


/**
 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
 *
 * @name sap.ui.table.Table#getSelectedIndices
 * @function
 * @type int[]
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Adds the given selection interval to the selection. In case of single selection the "indexTo" value will be used for as selected index.
 *
 * @name sap.ui.table.Table#addSelectionInterval
 * @function
 * @param {int} iIndexFrom
 *         Index from which .
 * @param {int} iIndexTo
 *         Indices of the items that shall additionally be selected.
 * @type sap.ui.table.Table
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Sets the given selection interval as selection. In case of single selection the "indexTo" value will be used for as selected index.
 *
 * @name sap.ui.table.Table#setSelectionInterval
 * @function
 * @param {int} iIndexFrom
 *         Index from which .
 * @param {int} iIndexTo
 *         Indices of the items that shall additionally be selected.
 * @type sap.ui.table.Table
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Removes the given selection interval from the selection. In case of single selection this call removeSelectedIndex with the "indexTo" value.
 *
 * @name sap.ui.table.Table#removeSelectionInterval
 * @function
 * @param {int} iIndexFrom
 *         Index from which .
 * @param {int} iIndexTo
 *         Indices of the items that shall additionally be selected.
 * @type sap.ui.table.Table
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns whether the given index is selected.
 *
 * @name sap.ui.table.Table#isIndexSelected
 * @function
 * @param {int} iIndex
 *         Index which is checked for selection state.
 * @type boolean
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Removes complete selection.
 *
 * @name sap.ui.table.Table#clearSelection
 * @function
 * @type sap.ui.table.Table
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Add all rows to the selection.
 *
 * @name sap.ui.table.Table#selectAll
 * @function
 * @type sap.ui.table.Table
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Returns the context of a row by its index.
 *
 * @name sap.ui.table.Table#getContextByIndex
 * @function
 * @param {int} iIndex
 *         Index of the row to return the context from.
 * @type object
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * sorts the given column ascending or descending
 *
 * @name sap.ui.table.Table#sort
 * @function
 * @param {sap.ui.table.Column} oColumn
 *         column to be sorted
 * @param {sap.ui.table.SortOrder} oSortOrder
 *         sort order of the column (if undefined the default will be ascending)
 * @type sap.ui.table.Table
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * filter the given column by the given value
 *
 * @name sap.ui.table.Table#filter
 * @function
 * @param {sap.ui.table.Column} oColumn
 *         column to be filtered
 * @param {string} sValue
 *         filter value as string (will be converted)
 * @type sap.ui.table.Table
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\table\Table.js
jQuery.sap.require('sap.ui.model.SelectionModel'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.ScrollBar'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.IntervalTrigger'); // unlisted dependency retained



// =============================================================================
// BASIC CONTROL API
// =============================================================================

sap.ui.table.Table.ResizeTrigger = new sap.ui.core.IntervalTrigger(300);

/**
 * Initialization of the Table control
 * @private
 */
sap.ui.table.Table.prototype.init = function() {

	// create an information object which contains always required infos
	this._oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
	this._bAccMode = sap.ui.getCore().getConfiguration().getAccessibility();
	this._bRtlMode = sap.ui.getCore().getConfiguration().getRTL();

	// basic selection model (by default the table uses multi selection)
	this._oSelection = new sap.ui.model.SelectionModel(sap.ui.model.SelectionModel.MULTI_SELECTION);
	this._oSelection.attachSelectionChanged(this._onSelectionChanged, this);

	// minimum width of a table column in pixel:
	// should at least be larger than the paddings for cols and cells!
	this._iColMinWidth = 20;
	
	this._oCalcColumnWidths = [];

	// columns to cells map
	this._aIdxCols2Cells = [];

	// visible columns
	this._aVisibleColumns = [];

	// we add a delegate to enable to focus the scrollbar when clicking on them
	// to avoid that the table control grabs the focus and scrolls to the focus
	// element (hide the outline)
	var fnFocusIndex = {
		onAfterRendering: function(oEvent) {
			oEvent.srcControl.$("sb").attr("tabindex", "-1").css("outline", "none");
		}	
	};
	
	// vertical scrollbar
	this._oVSb = new sap.ui.core.ScrollBar(this.getId() + "-vsb", {size: "100%"});
	this._oVSb.attachScroll(this.onvscroll, this);
	this._oVSb.addDelegate(fnFocusIndex);

	// horizontal scrollbar (configure by default for the pixel mode)
	this._oHSb = new sap.ui.core.ScrollBar(this.getId() + "-hsb", {size: "100%", contentSize: "0px", vertical: false});
	this._oHSb.attachScroll(this.onhscroll, this);
	this._oHSb.addDelegate(fnFocusIndex);

	// action mode flag (for keyboard navigation)
	this._bActionMode = false;
	
	// column index of the last fixed column (to prevent column reordering!)
	this._iLastFixedColIndex = -1;
	
	// flag whether the editable property should be inherited or not
	this._bInheritEditableToControls = false;

	// text selection for column headers?
	this._bAllowColumnHeaderTextSelection = false;

	// flag, whether to call _updateTableCell on cell control or not?
	this._bCallUpdateTableCell = false;

	// timer delay in ms
	this._iTimerDelay = 250;

	this._doubleclickDelay = 300;
	this._clicksRegistered = 0;

	// determine whether jQuery version is less than 1.8 (height and width behaves different!!)
	this._bjQueryLess18 = jQuery.sap.Version(jQuery.fn.jquery).compareTo("1.8") < 0;

};


/**
 * Termination of the Table control
 * @private
 */
sap.ui.table.Table.prototype.exit = function() {
	// destroy the child controls
	this._oVSb.destroy();
	this._oHSb.destroy();
	if (this._oPaginator) {
		this._oPaginator.destroy();
	}
	// destroy helpers
	this._destroyItemNavigation();
	// cleanup
	this._cleanUpTimers();
	this._detachEvents();
};


/**
 * theme changed
 * @private
 */
sap.ui.table.Table.prototype.onThemeChanged = function() {
	if (this.getDomRef()) {
		this.invalidate();
	}
};


/**
 * Rerendering handling
 * @private
 */
sap.ui.table.Table.prototype.onBeforeRendering = function() {
	this._cleanUpTimers();
	this._detachEvents();
};


/**
 * Rerendering handling
 * @private
 */
sap.ui.table.Table.prototype.onAfterRendering = function() {

	this._bOnAfterRendering = true;

	var $this = this.$();

	this._renderOverlay();
	this._updateVSb(true);
	this._updateTableContent();
	this._handleResize();
	this._attachEvents();

	// restore the column icons
	var aCols = this.getColumns();
	for (var i = 0, l = aCols.length; i < l; i++) {
		if (aCols[i].getVisible()) {
			aCols[i]._restoreIcons();
		}
	}
	
	// enable/disable text selection for column headers
	if (!this._bAllowColumnHeaderTextSelection) {
		this._disableTextSelection($this.find(".sapUiTableColHdrCnt"));
	} 

	this._bOnAfterRendering = false;

	this._initItemNavigation();

};

sap.ui.table.Table.prototype._renderOverlay = function() {
	var $this = this.$(), 
	    $overlay = $this.find(".sapUiTableOverlay"),
	    bShowOverlay = this.getShowOverlay();
	if (bShowOverlay && $overlay.length === 0) {
		$overlay = jQuery("<div>").addClass("sapUiOverlay sapUiTableOverlay").css("z-index", "1"); 
		$this.append($overlay);
	} else if (!bShowOverlay) {
		$overlay.remove();
	}
};

sap.ui.table.Table.prototype.setShowOverlay = function(bShow) {
	this.setProperty("showOverlay", bShow, true);
	this._renderOverlay();
	return this;
};

/**
 * update the table content (scrollbar, no data overlay, selection, row header, ...)
 * @private
 */
sap.ui.table.Table.prototype._updateTableContent = function() {

	// show or hide the no data container
	this._updateNoData();
	
	// update the selection visualization
	this._updateSelection();
	
	// update the rows (TODO: generalize this for 1.6)
	if (this._modifyRow) {
		var that = this;
		jQuery.each(this.getRows(), function(iIndex, oRow) {
			that._modifyRow(iIndex + that.getFirstVisibleRow(), oRow.$());
			that._modifyRow(iIndex + that.getFirstVisibleRow(), oRow.$("fixed"));
		});
	}
	
	var oBinding = this.getBinding("rows");
	var iFixedTopRows = this.getFixedRowCount();
	var iFixedBottomRows = this.getFixedBottomRowCount();
	var iVisibleRowCount = this.getVisibleRowCount();
	var that = this;
	
	if (oBinding) {
		jQuery.each(this.getRows(), function(iIndex, oRow) {
	
			var $row = oRow.$();
			var $fixedRow = oRow.$("fixed");
			var $rowHdr = that.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
			
			if (iFixedTopRows > 0) {
				var bIsTopRow = iIndex < iFixedTopRows;
				if (bIsTopRow) {
					if (!$row.hasClass("sapUiTableFixedTopRow")) {
						$row.addClass('sapUiTableFixedTopRow');
						$fixedRow.addClass('sapUiTableFixedTopRow');
						$rowHdr.addClass('sapUiTableFixedTopRow');
					}
				} else if ($row.hasClass("sapUiTableFixedTopRow")) {
					$row.removeClass('sapUiTableFixedTopRow');
					$fixedRow.removeClass('sapUiTableFixedTopRow');
					$rowHdr.removeClass('sapUiTableFixedTopRow');
				}
			}
		
			if (iFixedBottomRows > 0) {
				var bIsBottomRow,
					bIsPreBottomRow;
				if (oBinding.getLength() >= iVisibleRowCount) {
					bIsBottomRow = iIndex > iVisibleRowCount - iFixedBottomRows - 1;
					bIsPreBottomRow = iIndex > iVisibleRowCount - iFixedBottomRows - 2;
				} else {
					bIsBottomRow = (that.getFirstVisibleRow() + iIndex) > (oBinding.getLength() - 1 - iFixedBottomRows) && (that.getFirstVisibleRow() + iIndex) < oBinding.getLength();
					bIsPreBottomRow = (that.getFirstVisibleRow() + iIndex) > (oBinding.getLength() - 2 - iFixedBottomRows) && (that.getFirstVisibleRow() + iIndex) < oBinding.getLength();
				}
				if (bIsBottomRow) {
					if (!$row.hasClass("sapUiTableFixedBottomRow")) {
						$row.addClass('sapUiTableFixedBottomRow');
						$fixedRow.addClass('sapUiTableFixedBottomRow');
						$rowHdr.addClass('sapUiTableFixedBottomRow');
					}
				} else if ($row.hasClass("sapUiTableFixedBottomRow")) {
					$row.removeClass('sapUiTableFixedBottomRow');
					$fixedRow.removeClass('sapUiTableFixedBottomRow');
					$rowHdr.removeClass('sapUiTableFixedBottomRow');
				}
				if (bIsPreBottomRow) {
					if (!$row.hasClass("sapUiTableFixedPreBottomRow")) {
						$row.addClass('sapUiTableFixedPreBottomRow');
						$fixedRow.addClass('sapUiTableFixedPreBottomRow');
						$rowHdr.addClass('sapUiTableFixedPreBottomRow');
					}
				} else if ($row.hasClass("sapUiTableFixedPreBottomRow")) {
					$row.removeClass('sapUiTableFixedPreBottomRow');
					$fixedRow.removeClass('sapUiTableFixedPreBottomRow');
					$rowHdr.removeClass('sapUiTableFixedPreBottomRow');
				}
			}
		});
	}
	
	// update the row header (sync row heights)
	this._updateRowHeader();
	
	// hook for update table cell after rendering is complete 
	if (this._bOnAfterRendering && (this._bCallUpdateTableCell || typeof this._updateTableCell === "function")) {
		var that = this;
		var oBindingInfo = this.mBindingInfos["rows"];
		jQuery.each(this.getRows(), function(iIndex, oRow) {
			jQuery.each(oRow.getCells(), function(iIndex, oCell) {
				if (oCell._updateTableCell) {
					oCell._updateTableCell(oCell /* cell control */, 
					                       oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */, 
					                       oCell.$().closest("td") /* jQuery object for td */);
				}
				if (that._updateTableCell) {
					that._updateTableCell(oCell /* cell control */, 
					                       oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */, 
					                       oCell.$().closest("td") /* jQuery object for td */);
				}
			});
		});
	}
	
};


// =============================================================================
// ITEMNAVIGATION
// =============================================================================


/**
 * initialize ItemNavigation. Transfer relevant controls to ItemNavigation.
 * TabIndexes are set by ItemNavigation
 * @private
*/
sap.ui.table.Table.prototype._initItemNavigation = function() {

	var $this = this.$();
	var iColumnCount = this._getVisibleColumnCount();
	var iTotalColumnCount = iColumnCount;

	// initialization of item navigation for the Column Headers
	if (!this._oColHdrItemNav) {
		this._oColHdrItemNav = new sap.ui.core.delegate.ItemNavigation();
		this._oColHdrItemNav.setCycling(false);
		this.addDelegate(this._oColHdrItemNav);
	}

	// create the list of item dom refs
	var aItemDomRefs = [];
	if (this.getFixedColumnCount() == 0) {
		aItemDomRefs = $this.find(".sapUiTableCtrl td[tabindex]").get();
	} else {
		var $topLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');
		var $topRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');
		var $middleLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');
		var $middleRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');
		var $bottomLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');
		var $bottomRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');
		for (var i = 0; i < this.getVisibleRowCount(); i++) {
			aItemDomRefs = aItemDomRefs.concat($topLeft.find('tr[data-sap-ui-rowindex="' + i +'"]').find('td[tabindex]').get());
			aItemDomRefs = aItemDomRefs.concat($topRight.find('tr[data-sap-ui-rowindex="' + i +'"]').find('td[tabindex]').get());
			aItemDomRefs = aItemDomRefs.concat($middleLeft.find('tr[data-sap-ui-rowindex="' + i +'"]').find('td[tabindex]').get());
			aItemDomRefs = aItemDomRefs.concat($middleRight.find('tr[data-sap-ui-rowindex="' + i +'"]').find('td[tabindex]').get());
			aItemDomRefs = aItemDomRefs.concat($bottomLeft.find('tr[data-sap-ui-rowindex="' + i +'"]').find('td[tabindex]').get());
			aItemDomRefs = aItemDomRefs.concat($bottomRight.find('tr[data-sap-ui-rowindex="' + i +'"]').find('td[tabindex]').get());
		}
	}
	
	// to later determine the position of the first TD in the aItemDomRefs we keep the
	// count of TDs => aCount - TDs = first TD (add the row headers to the TD count / except the first one!)
	var iTDCount = aItemDomRefs.length;
	
	// add the row header items (if visible)
	if (this.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
		var aRowHdrDomRefs = $this.find(".sapUiTableRowHdr").get();
		for (var i = aRowHdrDomRefs.length - 1; i >= 0; i--) {
			aItemDomRefs.splice(i * iColumnCount, 0, aRowHdrDomRefs[i]);
			// we ignore the row headers
			iTDCount++;
		}
		// except the first row header
		iTDCount--; 
		// add the row header to the column count
		iTotalColumnCount++;
	}
	
	// add the column items
	if (this.getColumnHeaderVisible()) {
		aItemDomRefs = $this.find(".sapUiTableCol").get().concat(aItemDomRefs);
	}
	
	// add the select all item
	if (this.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly &&
			this.getColumnHeaderVisible()) {
		var aRowHdr = $this.find(".sapUiTableColRowHdr").get();
		for (var i = this._getHeaderRowCount() - 1; i >= 0; i--) {
			aItemDomRefs.splice(i * iColumnCount, 0, aRowHdr[0]);
		}
	}
	
	// initialization of item navigation for the Table control
	if (!this._oItemNavigation) {
		this._oItemNavigation = new sap.ui.core.delegate.ItemNavigation();
		this._oItemNavigation.setTableMode(true);
		this._oItemNavigation.attachEvent(sap.ui.core.delegate.ItemNavigation.Events.BeforeFocus, function(oEvent) {
			this.$("ariadesc").text("");
		}, this);
		this.addDelegate(this._oItemNavigation);
	}

	// configure the item navigation
	this._oItemNavigation.setColumns(iTotalColumnCount);
	this._oItemNavigation.setRootDomRef($this.find(".sapUiTableCnt").get(0));
	this._oItemNavigation.setItemDomRefs(aItemDomRefs);
	this._oItemNavigation.setFocusedIndex(aItemDomRefs.length - iTDCount);

};

/**
 * destroys ItemNavigation
 * @private
*/
sap.ui.table.Table.prototype._destroyItemNavigation = function() {

	// destroy of item navigation for the Table control
	if (this._oItemNavigation) {
		this._oItemNavigation.destroy();
		this._oItemNavigation = undefined;
	}

};


/*
 * @see JSDoc generated by SAPUI5 control
 */
sap.ui.table.Table.prototype.getFocusInfo = function() {
	var sId = this.$().find(":focus").attr("id");
	if (sId) {
		return {customId: sId};
	} else {
		return sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
	}
};

/*
 * @see JSDoc generated by SAPUI5 control
 */
sap.ui.table.Table.prototype.applyFocusInfo = function(mFocusInfo) {
	if (mFocusInfo && mFocusInfo.customId) {
		this.$().find("#" + mFocusInfo.customId).focus();
	} else {
		sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
	}
	return this;
};


// =============================================================================
// PUBLIC TABLE API
// =============================================================================


/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setTitle = function(vTitle) {
	var oTitle = vTitle;
	if (typeof (vTitle) === "string" || vTitle instanceof String) {
		oTitle = sap.ui.table.TableHelper.createTextView({
			text: vTitle,
			wrapping: false,
			width: "100%"
		});
		oTitle.addStyleClass("sapUiTableHdrTitle");
	}
	this.setAggregation("title", oTitle);
	return this;
};


/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setFooter = function(vFooter) {
	var oFooter = vFooter;
	if (typeof (vFooter) === "string" || vFooter instanceof String) {
		oFooter = sap.ui.table.TableHelper.createTextView({
			text: vFooter,
			wrapping: false,
			width: "100%"
		});
	}
	this.setAggregation("footer", oFooter);
	return this;
};


/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setSelectionMode = function(oSelectionMode) {
	this._oSelection.clearSelection();
	if (oSelectionMode === sap.ui.table.SelectionMode.Single) {
		this._oSelection.setSelectionMode(sap.ui.model.SelectionModel.SINGLE_SELECTION);
	} else {
		this._oSelection.setSelectionMode(sap.ui.model.SelectionModel.MULTI_SELECTION);
	}
	this.setProperty("selectionMode", oSelectionMode);
	return this;
};


/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setFirstVisibleRow = function(iRowIndex, bOnScroll) {
	// TODO: think about this optimization - for now it doesn't work since
	//       this API is used to update the rows afterwards
	//if (iRowIndex !== this.getFirstVisibleRow()) {
		// update the property
		this.setProperty("firstVisibleRow", iRowIndex, true);
		// update the bindings:
		//  - prevent the rerendering
		//  - use the databinding fwk to update the content of the rows
		if (this.getBinding("rows") && !this._bRefreshing) {
			this.updateRows();
		}
	//}
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.getAllowColumnReordering = function() {
	jQuery.sap.log.warning("getAllowColumnReordering is deprecated - please use getEnableColumnReordering!");
	return sap.ui.table.Table.prototype.getEnableColumnReordering.apply(this, arguments);
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setAllowColumnReordering = function() {
	jQuery.sap.log.warning("setAllowColumnReordering is deprecated - please use setEnableColumnReordering!");
	return sap.ui.table.Table.prototype.setEnableColumnReordering.apply(this, arguments);
};


// enable calling 'bindAggregation("rows")' without a factory
sap.ui.table.Table.getMetadata().getAllAggregations()["rows"]._doesNotRequireFactory = true;

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.bindRows = function(oBindingInfo, vTemplate, oSorter, aFilters) {
	// ensure old Table API compatibility (sPath, [oSorter], [aFilters])
	if (typeof oBindingInfo === "string" &&
		  (vTemplate instanceof sap.ui.model.Sorter || jQuery.isArray(oSorter) && oSorter[0] instanceof sap.ui.model.Filter) ) {
		aFilters = oSorter;
		oSorter = vTemplate;
		vTemplate = undefined;
	}

	return this.bindAggregation("rows", oBindingInfo, vTemplate, oSorter, aFilters);
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype._bindAggregation = function(sName, sPath, oTemplate, oSorter, aFilters) {
	sap.ui.core.Element.prototype._bindAggregation.apply(this, arguments);
	var oBinding = this.getBinding("rows");
	if (sName === "rows" && oBinding) {
		oBinding.attachChange(this._onBindingChange, this);
	}
	return this;
};

/**
 * handler for change events of the binding
 * @param {sap.ui.base.Event} oEvent change event
 * @private
 */
sap.ui.table.Table.prototype._onBindingChange = function(oEvent) {
	var sReason = typeof(oEvent) === "object" ? oEvent.getParameter("reason") : oEvent;
	if (sReason === "sort" || sReason === "filter") {
		this.clearSelection();
		this.setFirstVisibleRow(0);
	}
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.unbindAggregation = function(sName, bSuppressReset) {
	var oBinding = this.getBinding("rows");
	if (sName === "rows" && oBinding) {
		oBinding.detachChange(this._onBindingChange);
		//Reset needs to be resetted, else destroyRows is called, which is not allowed to be called
		bSuppressReset = true;
	}
	this.updateRows(); // TODO: shouldn't this be more a central feature?!
	return sap.ui.core.Element.prototype.unbindAggregation.apply(this, [sName, bSuppressReset]);
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setVisibleRowCountMode = function(oVisibleRowCountMode) {
	this.setProperty("visibleRowCountMode", oVisibleRowCountMode);
	this._handleRowCountMode();
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setVisibleRowCount = function(iVisibleRowCount) {
	if (iVisibleRowCount != null && !isFinite(iVisibleRowCount)) {
		return;
	}
	iVisibleRowCount = this.validateProperty("visibleRowCount", iVisibleRowCount);
	if (this.getBinding("rows") && this.getBinding("rows").getLength() <= iVisibleRowCount) {
		this.setProperty("firstVisibleRow", 0);
	}
	this.setProperty("visibleRowCount", iVisibleRowCount);
	return this;
};

/**
 * refresh rows
 * @private
 */
sap.ui.table.Table.prototype.refreshRows = function(sReason) {
	//needs to be called here to reset the firstVisible row so that the correct data is fetched
	this._bRefreshing = true;
	this._onBindingChange(sReason);
	this._updateBindingContexts(true);
	this._bRefreshing = false;
};

/**
 * updates the rows - called internally by the updateAggregation function when
 * anything in the model has been changed.
 * @private
 */
sap.ui.table.Table.prototype.updateRows = function(sReason) {

	// by default the start index is the first visible row
	var iStartIndex = this.getFirstVisibleRow();

	// calculate the boundaries (at least 0 - max the row count - visible row count)
	iStartIndex = Math.max(iStartIndex, 0);
	if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar && this._getRowCount() > 0) {
		iStartIndex = Math.min(iStartIndex, Math.max(this._getRowCount() - this.getVisibleRowCount(), 0));
	}
	this.setProperty("firstVisibleRow", iStartIndex, true);
	
	// when not scrolling we update also the scroll position of the scrollbar
	if (this._oVSb.getScrollPosition() !== iStartIndex) {
		this._oVSb.setScrollPosition(iStartIndex);
	} 
	
	// update the paginator
	if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
		// if iStartIndex is equal or greater than the number of total rows go back to page 1
		var iNewPage = 1;
		if (iStartIndex < this.getBinding("rows").getLength()) {
			iNewPage = Math.ceil((iStartIndex + 1) / this.getVisibleRowCount());
		}
		if (iNewPage !== this._oPaginator.getCurrentPage()) {
			this.setProperty("firstVisibleRow", (iNewPage - 1) * this.getVisibleRowCount(), true);
			this._oPaginator.setCurrentPage(iNewPage);
			if (this._oPaginator.getDomRef()) {
				this._oPaginator.rerender();
			}
		}
	}

	// update the bindings only once the table is rendered
	if (this.getDomRef()) {

		// update the bindings by using a delayed mechanism to avoid to many update
		// requests: by using the mechanism below it will trigger an update each 50ms
		this._sBindingTimer = this._sBindingTimer || jQuery.sap.delayedCall(50, this, function() {
			// update only if control not marked as destroyed (could happen because updateRows is called during destroying the table) 
			if(!this.bIsDestroyed) {
				this._determineVisibleCols();
				this._updateBindingContexts();
				this._updateVSb(); // this was moved here, before it was done before updatebindingContext
				this._updateTableContent();
				this._sBindingTimer = undefined;
				//Helper event for testing
				this.fireEvent("_rowsUpdated");
			}
		});
	}
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.insertRow = function() {
	jQuery.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!");
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.addRow = function() {
	jQuery.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!");
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.removeRow = function() {
	jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!");
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.removeAllRows = function() {
	jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!");
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.destroyRows = function() {
	jQuery.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!");
};

/**
 * triggers automatic resizing of a column to the widest content.(experimental!)
 * @experimental Experimental! Presently implemented to only work with pure text-based controls, 
 * the sap.ui.commons.Checkbox and sap.m.Image as well as sap.ui.commons.Image.
 * It will also work for most simple input fields (TextField, CheckBox, but not ComboBox) 
 * 
 * @param {int} iColId column id
 * @function
 * @public
 */
sap.ui.table.Table.prototype.autoResizeColumn = function(iColId) {
	var oCol = this.getColumns()[iColId];
	this._iColumnResizeStart = null;
	oCol._iNewWidth = this._calculateAutomaticColumnWidth(iColId);
	this._oCalcColumnWidths[iColId] = oCol._iNewWidth;
	this._onColumnResized(null, iColId);
};


// =============================================================================
// EVENT HANDLING & CLEANUP
// =============================================================================

/**
 * attaches the required native event handlers
 * @private
 */
sap.ui.table.Table.prototype._attachEvents = function() {

	var $this = this.$();

	// listen to the scroll events of the containers (for keyboard navigation)
	$this.find(".sapUiTableColHdrScr").scroll(jQuery.proxy(this._oncolscroll, this));
	$this.find(".sapUiTableCtrlScr").scroll(jQuery.proxy(this._oncntscroll, this));
	$this.find(".sapUiTableCtrlScrFixed").scroll(jQuery.proxy(this._oncntscroll, this));

	// sync row header > content (hover effect)
	$this.find(".sapUiTableRowHdr").hover(function() {
		jQuery(this).addClass("sapUiTableRowHvr");
		var iIndex = $this.find(".sapUiTableRowHdr").index(this);
		$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
	}, function() {
		jQuery(this).removeClass("sapUiTableRowHvr");
		$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
		$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
	});

	// sync content fixed > row header (hover effect)
	$this.find(".sapUiTableCtrlFixed > tbody > tr").hover(function() {
		jQuery(this).addClass("sapUiTableRowHvr");
		var iIndex = $this.find(".sapUiTableCtrlFixed > tbody > tr").index(this);
		$this.find(".sapUiTableRowHdr").filter(":eq(" + (iIndex) + ")").addClass("sapUiTableRowHvr");
		$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
	}, function() {
		jQuery(this).removeClass("sapUiTableRowHvr");
		$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
		$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
	});

	// sync content scroll > row header (hover effect)
	$this.find(".sapUiTableCtrlScroll > tbody > tr").hover(function() {
		jQuery(this).addClass("sapUiTableRowHvr");
		var iIndex = $this.find(".sapUiTableCtrlScroll > tbody > tr").index(this);
		$this.find(".sapUiTableRowHdr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
	}, function() {
		jQuery(this).removeClass("sapUiTableRowHvr");
		$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
		$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
	});

	// listen to the resize handlers
	$this.find(".sapUiTableColRsz").mousedown(jQuery.proxy(this._onColumnResizeStart, this));

	this._enableColumnAutoResizing();
	sap.ui.table.Table.ResizeTrigger.addListener(this._checkTableSize, this);

	// the vertical scrollbar listens to the mousewheel on the content section
	this._oHSb.bind($this.find(".sapUiTableCtrlScr").get(0));
	this._oVSb.bind($this.find(".sapUiTableCtrlScr").get(0));
	this._oHSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
	this._oVSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
	this._oVSb.bind($this.find(".sapUiTableRowHdrScr").get(0));

};


/**
 * detaches the required native event handlers
 * @private
 */
sap.ui.table.Table.prototype._detachEvents = function() {

	var $this = this.$();

	$this.find(".sapUiTableRowHdrScr").unbind();
	$this.find(".sapUiTableColHdrScr").unbind();

	$this.find(".sapUiTableCtrl > tbody > tr").unbind();
	$this.find(".sapUiTableRowHdr").unbind();

	sap.ui.table.Table.ResizeTrigger.removeListener(this._checkTableSize, this);

	$this.find(".sapUiTableColRsz").unbind();

	this._oHSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
	this._oVSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
	this._oHSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
	this._oVSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
	this._oVSb.unbind($this.find(".sapUiTableRowHdrScr").get(0));

};


/**
 * cleanup the timers when not required anymore
 * @private
 */
sap.ui.table.Table.prototype._cleanUpTimers = function() {

	if (this._sBindingTimer) {
		jQuery.sap.clearDelayedCall(this._sBindingTimer);
		this._sBindingTimer = undefined;
	}

	if (this._sScrollBarTimer) {
		jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
		this._sScrollBarTimer = undefined;
	}

	if (this._sDelayedMenuTimer) {
		jQuery.sap.clearDelayedCall(this._sDelayedMenuTimer);
		this._sDelayedMenuTimer = undefined;
	}

	if (this._sDelayedActionTimer) {
		jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);
		this._sDelayedActionTimer = undefined;
	}

	if (this._sColHdrPosTimer) {
		jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
		this._sColHdrPosTimer = undefined;
	}

	if (this._visibleRowCountTimer) {
		jQuery.sap.clearDelayedCall(this._visibleRowCountTimer);
		this._visibleRowCountTimer = undefined;
	}

	sap.ui.table.Table.ResizeTrigger.removeListener(this._checkTableSize, this);
};


// =============================================================================
// PRIVATE TABLE STUFF
// =============================================================================


/**
 * creates the rows for the rows aggregation
 * @private
 */
sap.ui.table.Table.prototype._createRows = function(iStartIndex) {

	var iFirstVisibleRow = this.getFirstVisibleRow();
	var iVisibleRowCount = this.getVisibleRowCount();

	// by default the start index is the first visible row
	iStartIndex = iStartIndex === undefined ? iFirstVisibleRow : iStartIndex;

	// create the new template
	var oTemplate = new sap.ui.table.Row(this.getId() + "-rows");
	var aCols = this.getColumns();
	var iCellIndex = 0;
	for (var i = 0, l = aCols.length; i < l; i++) {
		if (aCols[i].getVisible()) {
			var oColTemplate = aCols[i].getTemplate();
			if (oColTemplate) {
				var oClone = oColTemplate.clone("col" + i);
				// inherit the editable property if required to the child controls
				if (this._bInheritEditableToControls && !this.getEditable() && oClone.setEditable) {
					oClone.setEditable(false);
				}
				oClone.data("sap-ui-colindex", i);
				oTemplate.addCell(oClone);
				this._aIdxCols2Cells[i] = iCellIndex++;
			}
		}
	}

	// initially called without iStartIndex and iLength
	this.destroyAggregation("rows", true);
	var aContexts = undefined;
	var oBinding = this.getBinding("rows");
	var oBindingInfo = this.mBindingInfos["rows"];
	if (oBinding && iVisibleRowCount > 0) {
		// if thresholding is 0 then it is disabled and we forward 0 to the binding
		var iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()): 0;
		var iFixedBottomRowCount = this.getFixedBottomRowCount();
		aContexts = oBinding.getContexts(iStartIndex, iVisibleRowCount - iFixedBottomRowCount, iThreshold);
		if (iFixedBottomRowCount > 0 && (iVisibleRowCount - iFixedBottomRowCount) < oBinding.getLength()) {
			aContexts = aContexts.concat(oBinding.getContexts(oBinding.getLength() - iFixedBottomRowCount, iFixedBottomRowCount, 1));
		}
	}
	for (var i = 0; i < iVisibleRowCount; i++) {
		var oClone = oTemplate.clone("row" + i); // TODO: Isn't the following required! + "-" + this.getId());
		if (aContexts && aContexts[i]) {
			oClone.setBindingContext(aContexts[i], oBindingInfo.model);
			oClone._bHidden = false;
		} else {
			oClone._bHidden = true;
		}
		this.addAggregation("rows", oClone, true);
	}

	// destroy the template
	oTemplate.destroy();

};


/**
 * updates the horizontal scrollbar
 * @private
 */
sap.ui.table.Table.prototype._updateHSb = function() {

	// get the width of the container
	var $this = this.$();

	// apply the new content size
	var iColsWidth = $this.find(".sapUiTableCtrlScroll").width();
	if (!!sap.ui.Device.browser.safari) {
		iColsWidth = Math.max(iColsWidth, this._getColumnsWidth(this.getFixedColumnCount()));
	}
	// add the horizontal scrollbar
	if (iColsWidth > $this.find(".sapUiTableCtrlScr").width()) {
		// show the scrollbar
		if (!$this.hasClass("sapUiTableHScr")) {
			$this.addClass("sapUiTableHScr");
			if (!!sap.ui.Device.browser.safari) {
				// min-width on table elements does not work for safari
				if (this._bjQueryLess18) {
					$this.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr").width(iColsWidth);
				} else {
					$this.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr").outerWidth(iColsWidth);
				}
			}
		}
		var iScrollPadding = $this.find(".sapUiTableCtrlFixed").width();
		if ($this.find(".sapUiTableRowHdrScr:visible").length > 0) {
			iScrollPadding += $this.find(".sapUiTableRowHdrScr").width();
		}
		if (this._bRtlMode) {
			$this.find(".sapUiTableHSb").css('padding-right', iScrollPadding + 'px');
		} else {
			$this.find(".sapUiTableHSb").css('padding-left', iScrollPadding + 'px');
		}
		this._oHSb.setContentSize(iColsWidth + "px");
		if (this._oHSb.getDomRef()) {
			this._oHSb.rerender();
		}
	} else {
		// hide the scrollbar
		if ($this.hasClass("sapUiTableHScr")) {
			$this.removeClass("sapUiTableHScr");
			if (!!sap.ui.Device.browser.safari) {
				// min-width on table elements does not work for safari
				$this.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width", "");
			}
		}
	}

	this._syncHeaderAndContent();
	
};


/**
 * updates the vertical scrollbar
 * @private
 */
sap.ui.table.Table.prototype._updateVSb = function(bOnAfterRendering) {
	var $this = this.$();
	var bDoResize = false;
	var bForceUpdateVSb = false;
	var oBinding = this.getBinding("rows");
	if (oBinding) {
	
		// move the vertical scrollbar to the scrolling table only
		var iFixedRows = this.getFixedRowCount();
		if (iFixedRows > 0) {
			var iOffsetTop = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetTop;
			this.$().find('.sapUiTableVSb').css('top', (iOffsetTop - 1) + 'px');
			bForceUpdateVSb = true;
		}
		var iFixedBottomRows = this.getFixedBottomRowCount();
		if (iFixedBottomRows > 0) {
			var iOffsetHeight = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetHeight;
			this.$().find('.sapUiTableVSb').css('height', iOffsetHeight + 'px');
			bForceUpdateVSb = true;
		}
		
		var iSteps = Math.max(0, (oBinding.getLength() || 0) - this.getVisibleRowCount());
		// check for paging mode or scrollbar mode
		if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			// update the paginator (set the first visible row property)
			var iNumberOfPages = Math.ceil((oBinding.getLength() || 0) / this.getVisibleRowCount());
			this._oPaginator.setNumberOfPages(iNumberOfPages);
			var iPage = Math.min(iNumberOfPages, Math.ceil((this.getFirstVisibleRow() + 1) / this.getVisibleRowCount()));
			this.setProperty("firstVisibleRow", (Math.max(iPage,1) - 1) * this.getVisibleRowCount(), true);
			this._oPaginator.setCurrentPage(iPage);
			if (this._oPaginator.getDomRef()) {
				this._oPaginator.rerender();
			}
			if ($this.hasClass("sapUiTableVScr")) {
				$this.removeClass("sapUiTableVScr");
			}
		} else {
			// in case of scrollbar mode show or hide the scrollbar dependening on the
			// calculated steps:
			if (iSteps > 0) {
				if (!$this.hasClass("sapUiTableVScr")) {
					$this.addClass("sapUiTableVScr");
					bDoResize = true;
				}
			} else {
				if ($this.hasClass("sapUiTableVScr")) {
					$this.removeClass("sapUiTableVScr");
					bDoResize = true;
				}
			}
		}
		
		// update the scrollbar only if it is required
		jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
		if (bForceUpdateVSb || iSteps !== this._oVSb.getSteps() || this.getFirstVisibleRow() !== this._oVSb.getScrollPosition()) {
			
			// TODO: in case of bForceUpdateVSb the scrolling doesn't work anymore
			//       height changes of the scrollbar should not require a re-rendering!
			this._sScrollBarTimer = jQuery.sap.delayedCall(bOnAfterRendering ? 0 : 250, this, function() {
				
				this._oVSb.setSteps(iSteps);
				if (this._oVSb.getDomRef()) {
					this._oVSb.rerender();
				}
				this._oVSb.setScrollPosition(this.getFirstVisibleRow());
				
			});

		}
		
	} else {
		// check for paging mode or scrollbar mode
		if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			// update the paginator (set the first visible row property)
			this._oPaginator.setNumberOfPages(0);
			this._oPaginator.setCurrentPage(0);
			if (this._oPaginator.getDomRef()) {
				this._oPaginator.rerender();
			}
		} else {
			if ($this.hasClass("sapUiTableVScr")) {
				$this.removeClass("sapUiTableVScr");
				bDoResize = true;
			}
		}
	}
	if (bDoResize && !this._bOnAfterRendering) {
		this._handleResize();
	}
};


/**
 * updates the binding contexts of the currently visible controls
 * @private
 */
sap.ui.table.Table.prototype._updateBindingContexts = function(bSuppressUpdate) {

	var aRows = this.getRows(),
	    oBinding = this.getBinding("rows"),
	    oBindinginfo = this.mBindingInfos["rows"],
	    aFixedContexts = undefined,
	    aContexts = undefined,
	    aFixedBottomContexts = undefined,
	    iFixedRows = this.getFixedRowCount(),
	    iFixedBottomRows = this.getFixedBottomRowCount(),
	    iVisibleRowCount = this.getVisibleRowCount();

	// fetch the contexts from the binding
	if (oBinding) {
		var iThreshold; 
		if (iFixedRows > 0 || iFixedBottomRows > 0) {
			// thresholding is deactivated when value is 0
			var iTotalFixedRows = iFixedRows + iFixedBottomRows;
			iThreshold = this.getThreshold() ? Math.max((this.getVisibleRowCount() - iTotalFixedRows), this.getThreshold()) : 0;
			aContexts = oBinding.getContexts(this.getFirstVisibleRow() + iFixedRows, aRows.length - iTotalFixedRows, iThreshold);
			// static rows: we fetch the contexts without threshold to avoid loading
			// of unnecessary data. Make sure to fetch after the normal rows to avoid
			// outgoing double requests for the contexts. 
			if (iFixedRows > 0) {
				aFixedContexts = oBinding.getContexts(0, iFixedRows);
				aContexts = aFixedContexts.concat(aContexts);
			}
			if (iFixedBottomRows > 0 && (iVisibleRowCount - iFixedBottomRows) < oBinding.getLength()) {
				aFixedBottomContexts = oBinding.getContexts(oBinding.getLength() - iFixedBottomRows, iFixedBottomRows);
				aContexts = aContexts.concat(aFixedBottomContexts);
			}
		} else if (aRows.length > 0) {
			// thresholding is deactivated when value is 0
			iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()) : 0;
			aContexts = oBinding.getContexts(this.getFirstVisibleRow(), aRows.length, iThreshold);
		}
	}

	// update the binding contexts only for the visible columns
	//for (var iIndex = 0, iLength = this.getRows().length; iIndex < iLength; iIndex++) {
	if (!bSuppressUpdate) {
		for (var iIndex = aRows.length - 1; iIndex >= 0; iIndex--) {
			var oContext = aContexts ? aContexts[iIndex] : undefined;
			var oRow = aRows[iIndex];
			if (oRow) {
				this._updateRowBindingContext(oRow, oContext, oBindinginfo && oBindinginfo.model);
			}
		}
	}

};

/**
 * updates the binding context a row
 * @param {sap.ui.table.Row} row to update
 * @param {sap.ui.model.Context} binding context of the row
 * @private
 */
sap.ui.table.Table.prototype._updateRowBindingContext = function(oRow, oContext, sModelName) {
	var aCells = oRow.getCells();
	var $row = oRow.$();
	var $fixedRow = oRow.$("fixed");
	var $rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
	// check for a context object (in case of grouping there could be custom context objects)
	if (oContext && oContext instanceof sap.ui.model.Context) {
		for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
			var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
			if (aCells[col]) {
				this._updateCellBindingContext(aCells[col], oContext, sModelName);
			}
		}
		if ($row.hasClass("sapUiTableRowHidden")) {
			$row.removeClass("sapUiTableRowHidden");
			$fixedRow.removeClass("sapUiTableRowHidden");
			$rowHdr.removeClass("sapUiTableRowHidden");
		}
		oRow._bHidden = false;
	} else {
		if (!$row.hasClass("sapUiTableRowHidden")) {
			$row.addClass("sapUiTableRowHidden");
			$fixedRow.addClass("sapUiTableRowHidden");
			$rowHdr.addClass("sapUiTableRowHidden");
		}
		if ($row.hasClass("sapUiTableFixedBottomRow")) {
			$row.removeClass('sapUiTableFixedBottomRow');
			$fixedRow.removeClass('sapUiTableFixedBottomRow');
			$rowHdr.removeClass('sapUiTableFixedBottomRow');
		}
		if ($row.hasClass("sapUiTableFixedPreBottomRow")) {
			$row.removeClass('sapUiTableFixedPreBottomRow');
			$fixedRow.removeClass('sapUiTableFixedPreBottomRow');
			$rowHdr.removeClass('sapUiTableFixedPreBottomRow');
		}
		if ($row.hasClass("sapUiTableFixedTopRow")) {
			$row.removeClass('sapUiTableFixedTopRow');
			$fixedRow.removeClass('sapUiTableFixedTopRow');
			$rowHdr.removeClass('sapUiTableFixedTopRow');
		}
		oRow._bHidden = true;
		for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
			var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
			if (aCells[col]) {
				this._updateCellBindingContext(aCells[col], oContext, sModelName);
			}
		}
	}
};

/**
 * updates the binding context a cell
 * @param {sap.ui.core.Control} control of the cell
 * @param {sap.ui.model.Context} binding context of the cell
 * @private
 */
sap.ui.table.Table.prototype._updateCellBindingContext = function(oCell, oContext, sModelName) {
		oCell.setBindingContext(oContext, sModelName);
		if (this._bCallUpdateTableCell && oCell._updateTableCell) {
			oCell._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */);
		}
		if (typeof this._updateTableCell === "function") {
			this._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */);
		}
};

/**
 * check if data is available in the table
 * @private
 */
sap.ui.table.Table.prototype._hasData = function() {
	var oBinding = this.getBinding("rows");
	if (!oBinding || (oBinding.getLength() || 0) === 0) {
		return false;
	}
	return true;
};

/**
 * show or hide the no data container
 * @private
 */
sap.ui.table.Table.prototype._updateNoData = function() {
	// no data?
	if (this.getShowNoData()) {
		var oBinding = this.getBinding("rows");
		if (!this._hasData()) {
			if (!this.$().hasClass("sapUiTableEmpty")) {
				this.$().addClass("sapUiTableEmpty");
			}
			// update the ARIA text for the row count
			this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [0]));
		} else {
			if (this.$().hasClass("sapUiTableEmpty")) {
				this.$().removeClass("sapUiTableEmpty");
			}
			// update the ARIA text for the row count
			this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [(oBinding.getLength() || 0)]));
		}
	}
};


/**
 * determines the currently visible columns (used for simply updating only the
 * controls of the visible columns instead of the complete row!)
 * @private
 */
sap.ui.table.Table.prototype._determineVisibleCols = function() {

	// determine the visible colums
	var $this = this.$(),
	    that = this;

	if ($this.hasClass("sapUiTableHScr")) {

		var bRtl = this._bRtlMode;

		// calculate the view port
		var iScrollLeft = this._oHSb.getNativeScrollPosition();
		if(bRtl && sap.ui.Device.browser.firefox && iScrollLeft < 0) {
			// Firefox deals with negative scrollPosition in RTL mode
			iScrollLeft = iScrollLeft * -1;
		}
		var iScrollRight = iScrollLeft + this._getScrollWidth();

		// has the view port changed?
		if (this._iOldScrollLeft !== iScrollLeft || this._iOldScrollRight !== iScrollRight || this._bForceVisibleColCalc) {

			// calculate the first and last visible column
			var iLeft = bRtl ? $this.find(".sapUiTableCtrlScroll").width() : 0;

			if((sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox) && bRtl) {
				// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
				// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
				iLeft = 0;
			}

			this._aVisibleColumns = [];
			for (var i = 0, l = this.getFixedColumnCount(); i < l; i++) {
				this._aVisibleColumns.push(i);
			};
			var $ths = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll .sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex]");
			$ths.each(function(iIndex, oElement) {
				var iWidth = jQuery(oElement).width();
				if (bRtl && sap.ui.Device.browser.chrome) {
					iLeft -= iWidth;
				}
				if (iLeft + iWidth >= iScrollLeft && iLeft <= iScrollRight) {
					that._aVisibleColumns.push(parseInt(jQuery(oElement).data('sap-ui-headcolindex'),10));
				}
				if (!bRtl || (sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox)) {
					iLeft += iWidth;
				}
			});

			// keep the view port information (performance!!)
			this._iOldScrollLeft = iScrollLeft;
			this._iOldScrollRight = iScrollRight;
			this._bForceVisibleColCalc = false;
		}
	} else {
		this._aVisibleColumns = [];
		var aCols = this.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].shouldRender()) {
				this._aVisibleColumns.push(i);
			}
		}
	}

};

/**
 * enables automatic resizing on doubleclick on a column if the corresponding column attribute is set 
 * @experimental Experimental, only works with limited control set
 * @function
 * @private
 */
sap.ui.table.Table.prototype._enableColumnAutoResizing = function (){
	var that = this;
	jQuery.each(this.getColumns(), function (iIndex, oCol){
		if (!!oCol.getAutoResizable()){
			var $resizer = jQuery.find(".sapUiTableColRsz[data-sap-ui-colindex=" + iIndex + "]");
			if ($resizer){
				that._bindSimulatedDoubleclick($resizer, null /* fnSingleClick*/, that._onAutomaticColumnResize /* fnDoubleClick */);
			}
		}
	});
};

sap.ui.table.Table.prototype.addColumn = function (oColumn) {
	var that = this;
	this.addAggregation('columns', oColumn);
	oColumn.attachEvent('_widthChanged', function(oEvent) {
		that._bForceVisibleColCalc = true;
	});

	return this;
};

sap.ui.table.Table.prototype.insertColumn = function (oColumn, iIndex) {
	var that = this;
	this.insertAggregation('columns', oColumn, iIndex);
	oColumn.attachEvent('_widthChanged', function() {
		that._bForceVisibleColCalc = true;
	});

	return this;
};

/**
 * returns the count of rows when bound or 0
 * @private
 */
sap.ui.table.Table.prototype._getRowCount = function() {
	var oBinding = this.getBinding("rows");
	return oBinding ? (oBinding.getLength() || 0) : 0;
};


/**
 * returns the current top scroll position of the scrollbar (row number)
 * @private
 */
sap.ui.table.Table.prototype._getScrollTop = function() {
	if (this.$().hasClass("sapUiTableVScr")) {
		return this._oVSb.getScrollPosition() || 0;
	} else {
		if (this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			return (((this._oPaginator.getCurrentPage() || 1) - 1) * this.getVisibleRowCount());
		} else {
			return 0;
		}
	}
};

/**
 * returns the width of the table scroll container
 * @private
 */
sap.ui.table.Table.prototype._getScrollWidth = function() {
	return this.$().find(".sapUiTableCtrlScr").width();
};

/**
 * returns the height of the table scroll container
 * @private
 */
sap.ui.table.Table.prototype._getScrollHeight = function() {
	return this.$().find(".sapUiTableCtrlScr").height();
};

/**
 * returns the count of visible columns
 * @private
 */
sap.ui.table.Table.prototype._getVisibleColumns = function() {
	var aColumns = [];
	var aCols = this.getColumns();
	for (var i = 0, l = aCols.length; i < l; i++) {
		if (aCols[i].shouldRender()) {
			aColumns.push(aCols[i]);
		}
	}
	return aColumns;
};

/**
 * returns the count of visible columns
 * @private
 */
sap.ui.table.Table.prototype._getVisibleColumnCount = function() {
	return this._getVisibleColumns().length;
};

/**
 * returns the row count of headers
 * @private
 */
sap.ui.table.Table.prototype._getHeaderRowCount = function() {
	if (!this._useMultiHeader()) {
		return 1;
	}
	var iHeaderRows = 0;
	jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
		iHeaderRows = Math.max(iHeaderRows,  oColumn.getMultiLabels().length);
	});
	return iHeaderRows;
};

/**
 * returns if multi header beahviour is used or not
 * @private
 */
sap.ui.table.Table.prototype._useMultiHeader = function() {
	var useMultiLabels = false;
	jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
		if (oColumn.getMultiLabels().length > 0) {
			useMultiLabels = true;
			return false;
		}
	});
	return useMultiLabels;
};


/**
 * returns the min width of all columns
 * @private
 */
sap.ui.table.Table.prototype._getColumnsWidth = function(iStartColumn, iEndColumn) {

	// first calculate the min width of the table for all columns
	var aCols = this.getColumns();
	var iColsWidth = 0;

	if (iStartColumn !== 0 && !iStartColumn) {
		iStartColumn = 0;
	}
	if (iEndColumn !== 0 && !iEndColumn) {
		iEndColumn = aCols.length;
	}
	
	for (var i = iStartColumn, l = iEndColumn; i < l; i++) {
		if (aCols[i] && aCols[i].shouldRender()) {
			var sWidth = aCols[i].getWidth();
			var iWidth = parseInt(sWidth, 10);
			if (jQuery.sap.endsWith(sWidth, "px")) {
				iColsWidth += iWidth;
			} else {
				// for unknown width we use the min width
				iColsWidth += /* aCols[i].getMinWidth() || */ this._iColMinWidth;
			}
		}
	}
	
	return iColsWidth;

};

/**
 * calculates the width of the columns by using the browsers calculation
 * mechanism and setting a fix width to the columns
 * @private
 */
sap.ui.table.Table.prototype._handleResize = function() {

	// when using the native resize handler then this function could be called
	// before the table has been rendered - therefore we interrupt this method
	if (!this.getDomRef()) {
		return;
	}
	
	// update the horizontal scrollbar
	this._updateHSb();

	// update the column header (sync column widths)
	this._updateColumnHeader();
	
	this._updateRowHeader();

	this._handleRowCountMode();
};

sap.ui.table.Table.prototype._checkTableSize = function() {
	if (!this.getDomRef()) return;
	
	var oParentDomRef = this.getDomRef().parentNode,
		iHeight = oParentDomRef.offsetHeight,
		iWidth = oParentDomRef.offsetWidth;
		
	if (oParentDomRef != this._lastParent || iHeight != this._lastParentHeight || iWidth != this._lastParentWidth) {
		this._handleResize();
		this._lastParent = oParentDomRef;
		this._lastParentHeight = iHeight;
		this._lastParentWidth = iWidth;
		
		// update the bindings
		if (this.getBinding("rows")) {
			this.updateRows();
		}
	}
};

sap.ui.table.Table.prototype._handleRowCountMode = function() {
	//if visibleRowCountMode is auto change the visibleRowCount according to the parents container height
	if (this.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Auto) {
		var iCanvasHeight = this.$().parent().height();
		var iRows = this._calculateRowsToDisplay(iCanvasHeight);
		if (isNaN(iRows)) {
			return;
		}
		//Currently this needs to be executed in a timeout because invalidate is lost wenn method is called during onAfterRendering
		//This can be reverted when keeping the invalidate calls, that occur during onAfterRendering are kept
		var that = this;
		this._visibleRowCountTimer = setTimeout(function() {
			that.setVisibleRowCount(iRows);
		}, 0);
	}
};

/**
 * updates the row headers
 * @private
 */
sap.ui.table.Table.prototype._updateRowHeader = function() {

	// we skip this expensive height and width calculation when not required!
	if (this.getFixedRowCount() >= 0 || this.getFixedColumnCount() >= 0 || this.getRowHeight() <= 0) {
		
		var $this = this.$();

		var $fixedRows = $this.find(".sapUiTableCtrlFixed > tbody > tr");
		var $scrollRows = $this.find(".sapUiTableCtrlScroll > tbody > tr");
		var $rowHeaders = $this.find(".sapUiTableRowHdr");

		if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
			$fixedRows.css('height','');
			$scrollRows.css('height','');
		}

		for (var i = 0, l = $scrollRows.length; i < l; i++) {
			var iHeight = Math.max($fixedRows[i] ? ($fixedRows[i].getBoundingClientRect().bottom - $fixedRows[i].getBoundingClientRect().top) : 0, $scrollRows[i] ? ($scrollRows[i].getBoundingClientRect().bottom - $scrollRows[i].getBoundingClientRect().top) : 0);
			if (this._bjQueryLess18) {
				jQuery($rowHeaders[i]).height(iHeight);
				if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
					jQuery($fixedRows[i]).height(iHeight);
					jQuery($scrollRows[i]).height(iHeight);
				}
			} else {
				jQuery($rowHeaders[i]).outerHeight(iHeight);
				if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
					jQuery($fixedRows[i]).outerHeight(iHeight);
					jQuery($scrollRows[i]).outerHeight(iHeight);
				}
			}
		}

	}

};

/**
 * updates the column headers (width and position of the resize handles)
 * @private
 */
sap.ui.table.Table.prototype._updateColumnHeader = function(bUpdateResizeHandlers) {
	if (this._sColHdrPosTimer) {
		jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
	}
	var bRtl = this._bRtlMode;
	var iLeftAway = this._bRtlMode ? "99000px" : "-99000px";
	
	var fnSyncColumnHeaders = function() {
		
		// resize the dependent columns 
		// (put the percentage width into relation th fixed widths)
		// TODO: reconsider this behavior: see snippix #98183 (initial display) and #98183 (resizing)
		this._resizeDependentColumns();
	
		// sync the width of the columns
		var that = this, $this = this.$();
		var $cols = $this.find(".sapUiTableColHdr .sapUiTableCol");
		var $colRszs = $this.find(".sapUiTableColHdr .sapUiTableColRsz");
		var aCols = this._getVisibleColumns();
		//If no header items exist an emty th is rendered but aCols.length is 0
		//Because of that we don't have to do anything of aCols.length = 0
		if (aCols.length == 0) return;
		var iTableWidth = $this.width();
		var $ths = $this.find(".sapUiTableCtrlFirstCol > th");
		var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
		var iInvisibleColWidth = 0;
		if (bHasRowHeader) {
			var oHiddenElement = $ths.get(0);
			iInvisibleColWidth = oHiddenElement.getBoundingClientRect().right - oHiddenElement.getBoundingClientRect().left;
			$ths = $ths.not(":nth-child(1)");
		}
		$ths.each(function(iIndex, oElement) {
			if (aCols[iIndex]) {
				jQuery(oElement).css('width', aCols[iIndex].getWidth());
			}
		});
		$ths.each(function(iIndex, oElement) {
			// apply the width of the column
			var iWidth = (oElement.getBoundingClientRect().right - oElement.getBoundingClientRect().left), //get real width (with decimal values),
				vHeaderSpan = aCols[iIndex] ? aCols[iIndex].getHeaderSpan() : 1,
				aHeaderWidths = [],
				aSpans;
				
			if (vHeaderSpan) {
				if (jQuery.isArray(vHeaderSpan)) {
					jQuery.each(vHeaderSpan, function(iSpanIndex, iSpan) {
						vHeaderSpan[iSpanIndex] = Math.max((iSpan + iIndex > aCols.length) ? Math.min(iSpan, aCols.length - iIndex) : iSpan, 1);
					});
					aSpans = vHeaderSpan;
				} else {
					vHeaderSpan = Math.max((vHeaderSpan + iIndex > aCols.length) ? Math.min(vHeaderSpan, aCols.length - iIndex) : vHeaderSpan, 1);
					aSpans = [vHeaderSpan];
				}
			} else {
				aSpans = [1];
			}

			//for the first column also calculate the width of the hidden column
			if (iIndex == 0) {
				iWidth += iInvisibleColWidth;
			}

			for(var i=0; i<aSpans.length; i++) {
				aHeaderWidths[i] = iWidth;
				for (var j=1; j<aSpans[i]; j++) {
					var oHeader = $ths[iIndex+j];
					if (oHeader) {
						aHeaderWidths[i] += oHeader.getBoundingClientRect().right - oHeader.getBoundingClientRect().left;
					}
				}
			}

			var $col = $cols.filter('[data-sap-ui-colindex=' + jQuery(oElement).data('sap-ui-headcolindex') + ']');
			if ($col.length > 0) {
				if (!bUpdateResizeHandlers) {
					// to avoid flickering we store the last real width of the column
					// and update the width of the column only when it has been changed
					var oCol = sap.ui.getCore().byId($col.first().data("sap-ui-colid"));
					for (var i=0; i<$col.length; i++) {
						if (that._bjQueryLess18) {
							jQuery($col[i]).width(aHeaderWidths[i] || aHeaderWidths[0]);
						} else {
							jQuery($col[i]).outerWidth(aHeaderWidths[i] || aHeaderWidths[0]);
						}
					}
					oCol._iRealWidth = iWidth;
				}
				// the left position is calculated from the sapUiTableCnt element (therefore we need the offset!)
				var iLeft = $col.first().position().left;
				var iStartColIndex = jQuery(oElement).data('sap-ui-headcolindex');
				for (var i = 0; i < aSpans[0]; i++) {
					iLeft += (bRtl ? -2 : ($ths[iIndex+i].getBoundingClientRect().right - $ths[iIndex+i].getBoundingClientRect().left) - 3);
					// PERF-OPT: only positon the visible resize handlers
					var $colrsz = $colRszs.filter('[data-sap-ui-colindex=' + iStartColIndex + ']');
					if (iLeft >= 0 && iLeft <= iTableWidth) {
						$colrsz.css({
							"left": iLeft
						});
					} else if ($colrsz.css("left") !== iLeftAway) {
						$colrsz.css({
							"left": iLeftAway
						});
					}
					iStartColIndex++;
				}
			}
		});
		
		// we change the height of the cols, col header and the row header to auto to
		// find out whether to use the height of a cell or the min height of the col header 
		var bHasColHdrHeight = this.getColumnHeaderHeight() > 0;
		if (!bHasColHdrHeight && !bUpdateResizeHandlers) {
			var $jqColHdr = $this.find(".sapUiTableColHdr");
			var $jqColHdrCnt = $this.find(".sapUiTableColHdrCnt");
			var $jqColRowHdr = $this.find(".sapUiTableColRowHdr");
			var $jqo = $jqColRowHdr.add($jqColHdrCnt);
			$jqo.height("auto");
			$cols.height("auto");
			//Total height of the table header
			var iHeight = Math.max($jqColHdr.height(), $jqColHdrCnt.height());
			//Height of one row within the header
			var iRegularHeight = iHeight / this._getHeaderRowCount();
			if (this._bjQueryLess18) {
				$cols.height(iRegularHeight);
				$jqo.height(iHeight);
			} else {
				$cols.outerHeight(iRegularHeight);
				$jqo.outerHeight(iHeight);
			}
		}
	};
	
	// instantly execute the synchronization or delay it
	if (this._bOnAfterRendering) {
		fnSyncColumnHeaders.apply(this, arguments);
	} else {
		this._sColHdrPosTimer = jQuery.sap.delayedCall(150, this, fnSyncColumnHeaders);
	}
	
};

/**
 * disables text selection on the document (disabled fro Dnd)
 * @private
 */
sap.ui.table.Table.prototype._disableTextSelection = function (oElement) {
	// prevent text selection
	jQuery(oElement || document.body).
		attr("unselectable", "on").
		css({
			"-moz-user-select": "none",
			"-webkit-user-select": "none",
			"user-select": "none"
        }).
		bind("selectstart", function(oEvent) {
			oEvent.preventDefault();
			return false;
		});
};

/**
 * enables text selection on the document (disabled fro Dnd)
 * @private
 */
sap.ui.table.Table.prototype._enableTextSelection = function (oElement) {
	jQuery(oElement || document.body).
		attr("unselectable", "off").
		css({
			"-moz-user-select": "",
			"-webkit-user-select": "",
			"user-select": ""
        }).
		unbind("selectstart");
};

/**
 * clears the text selection on the document (disabled fro Dnd)
 * @private
 */
sap.ui.table.Table.prototype._clearTextSelection = function () {
	if (window.getSelection) {
	  if (window.getSelection().empty) {  // Chrome
	    window.getSelection().empty();
	  } else if (window.getSelection().removeAllRanges) {  // Firefox
	    window.getSelection().removeAllRanges();
	  }
	} else if (document.selection && document.selection.empty) {  // IE?
		try {
		    document.selection.empty();
		} catch (ex) {
		    // ignore error to as a workaround for bug in IE8
		}
	}
};

// =============================================================================
// CONTROL EVENT HANDLING
// =============================================================================

/**
 * will be called by the vertical scrollbar. updates the visualized data by
 * applying the first visible (scrollpos) row from the vertical scrollbar
 * @private
 */
sap.ui.table.Table.prototype.onvscroll = function(oEvent) {
	// do not scroll in action mode!
	this._leaveActionMode();
	// set the first visible row
	this.setFirstVisibleRow(this._getScrollTop(), true);
};

/**
 * sync the column header and content 
 * @private
 */
sap.ui.table.Table.prototype._syncHeaderAndContent = function() {
	if (!this._bSyncScrollLeft) {
		this._bSyncScrollLeft = true;
		// synchronize the scroll areas
		var $this = this.$();
		var iScrollLeft = this._oHSb.getNativeScrollPosition();
		$this.find(".sapUiTableCtrlScr").scrollLeft(iScrollLeft);
		if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
			var oScrollDomRef = $this.find(".sapUiTableColHdrScr").get(0);
			iScrollLeft = oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - this._oHSb.getScrollPosition();
		}
		$this.find(".sapUiTableColHdrScr").scrollLeft(iScrollLeft);
		this._bSyncScrollLeft = false;
	}

};

/**
 * will be called when the horizontal scrollbar is used. since the table does
 * not render/update the data of all columns (only the visible ones) in case
 * of scrolling horizontally we need to update the content of the columns which
 * became visible.
 * @private
 */
sap.ui.table.Table.prototype.onhscroll = function(oEvent) {

	if (!this._bOnAfterRendering) {

		// sync the column header and the content area
		this._syncHeaderAndContent();

		// update the column headers (resize handles)
		this._updateColumnHeader(true);

		// update the bindings
		if (this.getBinding("rows")) {
			this.updateRows();
		}

	}

};

/**
 * when navigating within the column header we need to synchronize the content
 * area with the position (scrollLeft) of the column header.
 * @private
 */
sap.ui.table.Table.prototype._oncolscroll = function(oEvent) {
	if (!this._bSyncScrollLeft) {
		var $cnt = this.$().find(".sapUiTableColHdrScr");
		if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
			var oScrollDomRef = this.$().find(".sapUiTableColHdrScr").get(0);
			this._oHSb.setScrollPosition(oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - $cnt.scrollLeft());
		} else {
			this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
		}
	}
};

/**
 * when navigating within the content area we need to synchronize the column
 * header with the position (scrollLeft) of the content area.
 * @private
 */
sap.ui.table.Table.prototype._oncntscroll = function(oEvent) {
	if (!this._bSyncScrollLeft) {
		var $cnt = this.$().find(".sapUiTableCtrlScr");
		this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
	}
};


/**
 * listens to the mousedown events for starting column drag & drop. therefore
 * we wait 200ms to make sure it is no click on the column to open the menu.
 * @private
 */
sap.ui.table.Table.prototype.onmousedown = function(oEvent) {

	// only move on left click!
	var bLeftButton = oEvent.button === (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 8 ? 1 : 0);
	if (bLeftButton) {

		var $target = jQuery(oEvent.target);
	
		var $splitter = this.$("sb");
		if (oEvent.target == $splitter[0]) {
	
			// Fix for IE text selection while dragging
			jQuery(document.body).bind("selectstart",jQuery.proxy(this._splitterSelectStart,this));
	
			var offset = $splitter.offset();
			var height = $splitter.height();
			var width = $splitter.width();
	
			jQuery(document.body).append(
					"<div id=\"" + this.getId() + "-ghost\" class=\"sapUiHSBGhost\" style =\" height:" + height + "px; width:"
					+ width + "px; left:" + offset.left + "px; top:" + offset.top + "px\" ></div>");
	
			// append overlay over splitter to enable correct functionality of moving the splitter
			$splitter.append(
					"<div id=\"" + this.getId() + "-overlay\" style =\"left: 0px;" +
							" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");
	
			jQuery(document).bind("mouseup", jQuery.proxy(this._onGhostMouseRelease, this));
			jQuery(document).bind("mousemove", jQuery.proxy(this._onGhostMouseMove, this));
			return;
		}
	
		var $col = $target.closest(".sapUiTableCol");
		if ($col.length === 1) {
	
			this._bShowMenu = true;
			this._sDelayedMenuTimer = jQuery.sap.delayedCall(200, this, function() {
				this._bShowMenu = false;
			});
					
			if (this.getEnableColumnReordering()) {
		
				var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
				if (iIndex > this._iLastFixedColIndex) {
				
					var oColumn = this.getColumns()[iIndex];
					
					this._sDelayedActionTimer = jQuery.sap.delayedCall(200, this, function() {
						this._onColumnMoveStart(oColumn);
					});
					
				}
	
			}
		}
	
		// in case of FireFox and CTRL+CLICK it selects the target TD 
		//   => prevent the default behavior only in this case (to still allow text selection)
		var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);
		if (!!sap.ui.Device.browser.firefox && bCtrl) {
			oEvent.preventDefault();
		}
		
	}
	
};

/**
 * controls the action mode when clicking into the table control
 * @private
 */
sap.ui.table.Table.prototype.onmouseup = function(oEvent) {
	if (this.$().find(".sapUiTableCtrl td :focus").length > 0) {
		// when clicking into a focusable control we enter the action mode!
		this._enterActionMode(this.$().find(".sapUiTableCtrl td :focus"));
	} else {
		// when clicking anywhere else in the table we leave the action mode!
		this._leaveActionMode(oEvent);
	}
};

/**
 * handles the selection when clicking on the table
 * @private
 */
sap.ui.table.Table.prototype.onclick = function(oEvent) {
	// clean up the timer
	jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);
	// forward the event
	if (!this._findAndfireCellEvent(this.fireCellClick, oEvent)) {
		this._onSelect(oEvent);
	} else {
		oEvent.preventDefault();
	}
};

/**
 * handles the cell contextmenu eventing of the table
 * @private
 */
sap.ui.table.Table.prototype.oncontextmenu = function(oEvent) {
	if (this._findAndfireCellEvent(this.fireCellContextmenu, oEvent, this._oncellcontextmenu)) {
		oEvent.preventDefault();
	}
};

/**
 * handles the default cell contextmenu
 * @private
 */
sap.ui.table.Table.prototype._oncellcontextmenu = function(mParams) {

	if (this.getEnableCellFilter()) {

		// create the contextmenu instance the first time it is needed
		if (!this._oContextMenu) {

			jQuery.sap.require("sap.ui.unified.Menu");
			jQuery.sap.require("sap.ui.unified.MenuItem");

			this._oContextMenu = new sap.ui.unified.Menu(this.getId() + "-contextmenu");
			this.addDependent(this._oContextMenu);
		}

		// does the column support filtering?
		var oColumn = this._getVisibleColumns()[mParams.columnIndex];
		var sProperty = oColumn.getFilterProperty();
		if (sProperty && oColumn.getShowFilterMenuEntry()) {

			// destroy all items of the menu and recreate
			this._oContextMenu.destroyItems();
			this._oContextMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_FILTER"),
				select: [function() {
					var oContext = this.getContextByIndex(mParams.rowIndex);
					var sValue = oContext.getProperty(sProperty);
					this.filter(oColumn, sValue);
				}, this]
			}));

			// open the popup below the cell
			var eDock = sap.ui.core.Popup.Dock;
			this._oContextMenu.open(false, mParams.cellDomRef, eDock.BeginTop, eDock.BeginBottom, mParams.cellDomRef, "none none");
			return true;
		}
	}
};

/**
 * helper method to bind different functions to a click if both a single and a double click can occur on an element 
 * @experimental Experimental
 * @function
 * @private
 */
sap.ui.table.Table.prototype._bindSimulatedDoubleclick = function(element, fnClick, fnDoubleclick){
	var eventBound = "click";
	var that = this;
	if (!!sap.ui.Device.support.touch){
		//event needs to be touchend due to timing issues on the ipad
		eventBound = "touchend";
	}
	jQuery(element).on(eventBound, function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
		that._clicksRegistered = that._clicksRegistered + 1;
		if(that._clicksRegistered < 2){
			that._singleClickTimer = jQuery.sap.delayedCall(that._doubleclickDelay, that, function(){
				that._clicksRegistered = 0;
				if(fnClick){
					fnClick.call(that, oEvent);
				}
			}, [oEvent]);
		} else {
			jQuery.sap.clearDelayedCall(that._singleClickTimer);
			that._clicksRegistered = 0;
			fnDoubleclick.call(that, oEvent);
		}
	});
};

/**
 * finds the cell on which the click or contextmenu event is executed and 
 * notifies the listener which control has been clicked or the contextmenu
 * should be openend.
 * @param {function} fnFire function to fire the event
 * @param {DOMEvent} oEvent event object
 * @return {boolean} cancelled or not
 * @private
 */
sap.ui.table.Table.prototype._findAndfireCellEvent = function(fnFire, oEvent, fnContextMenu) {
	var $target = jQuery(oEvent.target);
	// find out which cell has been clicked
	var $cell = $target.closest("td[role='gridcell']");
	var sId = $cell.attr("id");
	var aMatches = /.*-row(\d*)-col(\d*)/i.exec(sId);
	var bCancel = false;
	if (aMatches) {
		var iRow = aMatches[1];
		var iCol = aMatches[2];
		var oRow = this.getRows()[iRow];
		var oCell = oRow && oRow.getCells()[iCol];
		var iRealRowIndex = oRow && oRow.getIndex();
		var mParams = {
			rowIndex: iRealRowIndex,
			columnIndex: iCol,
			cellControl: oCell
		};
		bCancel = !fnFire.call(this, mParams);
		if (!bCancel && typeof fnContextMenu === "function") {
			mParams.cellDomRef = $cell[0];
			bCancel = fnContextMenu.call(this, mParams);
		}
	}
	return bCancel;
};

/**
 * handles the focus in to reposition the focus or prevent default handling for
 * column resizing
 * @private
 */
sap.ui.table.Table.prototype.onfocusin = function(oEvent) {
	var $target = jQuery(oEvent.target);
	// KEYBOARD HANDLING (_bIgnoreFocusIn is set in onsaptabXXX)
	if (!this._bIgnoreFocusIn && ($target.hasClass("sapUiTableCtrlBefore") || $target.hasClass("sapUiTableCtrlAfter"))) {
		// reset the aria description of the table that the table is announced the
		// first time the table grabs the focus
		this.$("ariadesc").text(this._oResBundle.getText("TBL_TABLE"));
		// when entering the before or after helper DOM elements we put the
		// focus on the current focus element of the item navigation and we
		// leave the action mode!
		this._leaveActionMode();
		// set the focus on the last focused dom ref of the item navigation or
		// in case if not set yet (tab previous into item nav) then we set the
		// focus to the root domref
		jQuery(this._oItemNavigation.getFocusedDomRef() || this._oItemNavigation.getRootDomRef()).focus();
	} else if (jQuery.sap.endsWith(oEvent.target.id, "-rsz")) {
		// prevent that the ItemNavigation grabs the focus!
		// only for the column resizing
		oEvent.preventDefault();
		oEvent.stopPropagation();
	}
};


// =============================================================================
// SELECTION HANDLING
// =============================================================================

/**
 * handles the row selection and the column header menu
 * @private
 */
sap.ui.table.Table.prototype._onSelect = function(oEvent) {

	// trigger column menu
	var $target = jQuery(oEvent.target);

	// determine modifier keys
	var bShift = oEvent.shiftKey;
	var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);

	// column header?
	var $col = $target.closest(".sapUiTableCol");
	if (this._bShowMenu && $col.length === 1) {
		var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
		var oColumn = this.getColumns()[iIndex];
		this._onColumnSelect(oColumn);
		return;
	}

	// row header?
	var $row = $target.closest(".sapUiTableRowHdr");
	if ($row.length === 1) {
		var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
		this._onRowSelect(this.getFirstVisibleRow() + iIndex, bShift, bCtrl);
		return;
	}

	// table control? (only if the selection behavior is set to row)
	if (/*!this._bActionMode && */ (
	    this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.Row ||
	    this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
		var $row = $target.closest(".sapUiTableCtrl > tbody > tr");
		if ($row.length === 1) {
			var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
			this._onRowSelect(this.getFirstVisibleRow() + iIndex, bShift, bCtrl);
			return;
		}
	}

	// select all?
	if (jQuery.sap.containsOrEquals(this.getDomRef("selall"), oEvent.target)) {
		if (!jQuery(this.getDomRef("selall")).hasClass("sapUiTableSelAll")) {
			this.clearSelection();
		} else {
			this.selectAll();
		}
		if (!!sap.ui.Device.browser.internet_explorer) {
			this.$("selall").focus();
		}
		return;
	}

};


// =============================================================================
// ROW EVENT HANDLING
// =============================================================================

/**
 * handles the row selection (depending on the mode)
 * @private
 */
sap.ui.table.Table.prototype._onRowSelect = function(iRowIndex, bShift, bCtrl) {

	// in case of IE and SHIFT we clear the text selection
	if (!!sap.ui.Device.browser.internet_explorer && bShift) {
		this._clearTextSelection();
	}

	// is the table bound?
	var oBinding = this.getBinding("rows");
	if (!oBinding) {
		return;
	}

	//var iRowIndex = Math.min(Math.max(0, iRowIndex), this.getBinding("rows").getLength() - 1);
	if (iRowIndex < 0 || iRowIndex >= (oBinding.getLength() || 0)) {
		return;
	}

	this._iSourceRowIndex = iRowIndex;

	var oSelMode = this.getSelectionMode();
	if (oSelMode !== sap.ui.table.SelectionMode.None) {
		if (oSelMode === sap.ui.table.SelectionMode.Single) {
			if (!this.isIndexSelected(iRowIndex)) {
				this.setSelectedIndex(iRowIndex);
			} else {
				this.clearSelection();
			}
		} else {
			// in case of multi toggle behavior a click on the row selection
			// header adds or removes the selected row and the previous seleciton
			// will not be removed
			if (oSelMode === sap.ui.table.SelectionMode.MultiToggle) {
				bCtrl = true;
			}
			if (bShift) {
				// If no row is selected getSelectedIndex returns -1 - then we simply 
				// select the clicked row:
				var iSelectedIndex = this.getSelectedIndex(); 
				if (iSelectedIndex >= 0) {
					this.addSelectionInterval(iSelectedIndex, iRowIndex);
				} else {
					this.setSelectedIndex(iRowIndex);
				}
			} else {
				if (!this.isIndexSelected(iRowIndex)) {
					if (bCtrl) {
						this.addSelectionInterval(iRowIndex, iRowIndex);
					} else {
						this.setSelectedIndex(iRowIndex);
					}
				} else {
					if (bCtrl) {
						this.removeSelectionInterval(iRowIndex, iRowIndex);
					} else {
						if (this.getSelectedIndices().length === 1) {
							this.clearSelection();
						} else {
							this.setSelectedIndex(iRowIndex);
						}
					}
				}
			}
		}
	}

	this._iSourceRowIndex = undefined;

};


// =============================================================================
// COLUMN EVENT HANDLING
// =============================================================================

/**
 * column select event => opens the column menu
 * @private
 */
sap.ui.table.Table.prototype._onColumnSelect = function(oColumn) {

	// forward the event
	var bExecuteDefault = this.fireColumnSelect({
		column: oColumn
	});

	// if the default behavior should be prevented we suppress to open
	// the column menu!
	if (bExecuteDefault) {
		oColumn._openMenu();
	}

};

/**
 * start column moveing
 * @private
 */
sap.ui.table.Table.prototype._onColumnMoveStart = function(oColumn) {

	this._disableTextSelection();

	var $col = oColumn.$();
	var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
	
	if (iColIndex < this.getFixedColumnCount()) {
		return;
	}

	this._$colGhost = $col.clone().removeAttr("id");

	$col.css({
		"opacity": ".25"
	});

	this._$colGhost.addClass("sapUiTableColGhost").css({
		"left": -10000,
		"top": -10000,
		//Position is set to relative for columns later, if the moving is started a second time the position: relative overwrites
		//the absolut position set by the sapUiTableColGhost class, so we overrite the style attribute for position here to make
		//sure that the position is absolute
		"position": "absolute",
		"z-index": this.$().zIndex() + 10
	});

	// TODO: only for the visible columns!?
	this.$().find(".sapUiTableCol").each(function(iIndex, oElement) {

		var $col = jQuery(this);
		$col.css({position: "relative"});

		$col.data("pos", {
			left: $col.position().left,
			center: $col.position().left + $col.outerWidth() / 2,
			right:  $col.position().left + $col.outerWidth()
		});

	});

	this._$colGhost.appendTo(document.body);

	jQuery(document.body).
		mousemove(jQuery.proxy(this._onColumnMove, this)).
		mouseup(jQuery.proxy(this._onColumnMoved, this));
	

};

/**
 * move the column position the ghost
 * @private
 */
sap.ui.table.Table.prototype._onColumnMove = function(oEvent) {

	var $this = this.$();
	var bRtl = this._bRtlMode;
	var iRelX = oEvent.pageX - $this.offset().left;
	var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
	var $DnDCol = this.getColumns()[iDnDColIndex].$();

	// find out the new col position
	var iOldColPos = this._iNewColPos;
	this._iNewColPos = iDnDColIndex;
	var that = this;
	$this.find(".sapUiTableCol").each(function(iIndex, oCol) {

		var $col = jQuery(oCol);
		var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
		var vHeaderSpans = sap.ui.getCore().byId($col.attr("data-sap-ui-colid")).getHeaderSpan();
		var iSpan = vHeaderSpans ? jQuery.isArray(vHeaderSpans) ? vHeaderSpans[0] : vHeaderSpans : 1;

		if ($col.get(0) !== $DnDCol.get(0)) {

			var oPos = $col.data("pos");

			var bBefore = iRelX >= oPos.left && iRelX <= oPos.center;
			var bAfter = iRelX >= oPos.center && iRelX <= oPos.right;

			if (!bRtl) {
				that._iNewColPos = bBefore ? iColIndex : bAfter ? iColIndex + iSpan : that._iNewColPos;
			} else {
				that._iNewColPos = bAfter ? iColIndex : bBefore ? iColIndex + iSpan : that._iNewColPos;
			}

			if ((bBefore || bAfter) && iColIndex > iDnDColIndex) {
				that._iNewColPos--;
			}

		}

	});

	// prevent the reordering of the fixed columns
	if (this._iNewColPos <= this._iLastFixedColIndex) {
		this._iNewColPos = iOldColPos;
	}
	if (this._iNewColPos < this.getFixedColumnCount()) {
		this._iNewColPos = iOldColPos;
	}

	// animate the column move
	this._animateColumnMove(iDnDColIndex, iOldColPos, this._iNewColPos);

	// update the ghost position
	this._$colGhost.css({
		"left": oEvent.pageX + 5,
		"top": oEvent.pageY + 5
	});

};

/**
 * animates the column movement
 */
sap.ui.table.Table.prototype._animateColumnMove = function(iColIndex, iOldPos, iNewPos) {

	var bRtl = this._bRtlMode;
	var $DnDCol = this.getColumns()[iColIndex].$();

	// position has been changed => reorder
	if (iOldPos !== iNewPos) {

		for (var i = Math.min(iOldPos, iNewPos), l = Math.max(iOldPos, iNewPos); i <= l; i++) {
			var oCol = this.getColumns()[i];
			if (i !== iColIndex && oCol.getVisible()) {
				oCol.$().stop(true, true).animate({left: "0px"});
			}
		}

		var iOffsetLeft = 0;
		if (iNewPos < iColIndex) {
			for (var i = iNewPos; i < iColIndex; i++) {
				var oCol = this.getColumns()[i];
				if (oCol.getVisible()) {
					var $col = oCol.$();
					iOffsetLeft -= $col.outerWidth();
					$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? -1 : 1) + "px"});
				}
			}
		} else {
			for (var i = iColIndex + 1, l = iNewPos + 1; i < l; i++) {
				var oCol = this.getColumns()[i];
				if (oCol.getVisible()) {
					var $col = oCol.$();
					iOffsetLeft += $col.outerWidth();
					$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? 1 : -1) + "px"});
				}
			}
		}
		$DnDCol.stop(true, true).animate({left: iOffsetLeft * (bRtl ? -1 : 1) + "px"});

	}
	
};

/**
 * columns is moved => update!
 * @private
 */
sap.ui.table.Table.prototype._onColumnMoved = function(oEvent) {

	var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
	var oDnDCol = this.getColumns()[iDnDColIndex];

	jQuery(document.body).
		unbind("mousemove", this._onColumnMove).
		unbind("mouseup", this._onColumnMoved);

	this._$colGhost.remove();
	this._$colGhost = undefined;

	this._enableTextSelection();

	// forward the event
	var bExecuteDefault = this.fireColumnMove({
		column: oDnDCol,
		newPos: this._iNewColPos
	});
	
	var bMoveRight = iDnDColIndex < this._iNewColPos;

	if (bExecuteDefault && this._iNewColPos !== undefined && this._iNewColPos !== iDnDColIndex) {
		this.removeColumn(oDnDCol);
		this.insertColumn(oDnDCol, this._iNewColPos);
		var vHeaderSpan = oDnDCol.getHeaderSpan(),
			iSpan = vHeaderSpan ? jQuery.isArray(vHeaderSpan) ? vHeaderSpan[0] : vHeaderSpan : 1;

		if (iSpan > 1) {
			if (!bMoveRight) {
				this._iNewColPos++;
			}
			for (var i = 1; i < iSpan; i++) {
				var oDependentCol = this.getColumns()[bMoveRight ? iDnDColIndex : iDnDColIndex+i];
				this.removeColumn(oDependentCol);
				this.insertColumn(oDependentCol, this._iNewColPos);
				this.fireColumnMove({
					column: oDependentCol,
					newPos: this._iNewColPos
				});
				if (!bMoveRight) {
					this._iNewColPos++;
				}
			}
		}
		this._oColHdrItemNav.setFocusedIndex(this._iNewColPos);
	} else {
		this._animateColumnMove(iDnDColIndex, this._iNewColPos, iDnDColIndex);
		oDnDCol.$().css({
			"backgroundColor": "",
			"backgroundImage": "",
			"opacity": ""
		});
	}
	delete this._iNewColPos;

};

/**
 * starts the automatic column resize after doubleclick 
 * @experimental Experimental, only works with a limited control set
 * @private
 */
sap.ui.table.Table.prototype._onAutomaticColumnResize = function(oEvent) {
	var iColIndex, oCol, headerSpan, maxHeaderSpan, iColsToResize = 1, bResizeMultiple = false;
	jQuery.sap.log.debug("doubleclick fired");
	this._disableTextSelection();
	this._$colResize = jQuery(oEvent.target);
	this._$colResize.addClass("sapUiTableColRszActive");
	//get the id of the column which needs to be resized. it might be different from the resizers column id if a headerspan is used.
	var iParentColIndex = parseInt(this._$colResize.prevAll(".sapUiTableCol").first().attr("data-sap-ui-colindex"), 10);
	iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
	if (iParentColIndex != iColIndex) {
		bResizeMultiple = true;
	}
	//try to find out if we are only resizing one column or all columns under a header span
	if (bResizeMultiple) {
		oCol = this.getColumns()[iParentColIndex];
		headerSpan = oCol.getHeaderSpan();
		if(headerSpan instanceof Array){
			maxHeaderSpan = Math.max.apply(Math, headerSpan);
		} else if (!!headerSpan) {
			maxHeaderSpan = headerSpan;
		}
		if (iColIndex + headerSpan - 1 != iParentColIndex){
			iColsToResize = maxHeaderSpan;
			iColIndex = iParentColIndex + maxHeaderSpan;
		}
	}
	if(iColsToResize > 1){
	//	for(var i = 0; i < iColsToResize; i--{
		while (iColIndex > iParentColIndex) {
			iColIndex--;
			this.autoResizeColumn(iColIndex);
		}
	} else {
		this.autoResizeColumn(iColIndex);
	}
	oEvent.preventDefault();
	oEvent.stopPropagation();
};


/**
 * start the column resize
 * @private
 */
sap.ui.table.Table.prototype._onColumnResizeStart = function(oEvent) {
	
	// only resize on left click!
	var bLeftButton = oEvent.button === (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 8 ? 1 : 0);
	if (bLeftButton) {
	
		this._iColumnResizeStart = oEvent.pageX;
	
		this._disableTextSelection();
		this._$colResize = jQuery(oEvent.target);
	
		jQuery(document.body).
			mousemove(jQuery.proxy(this._onColumnResize, this)).
			mouseup(jQuery.proxy(this._onColumnResized, this));

	}
	
};

/**
 * resize the column
 * @private
 */
sap.ui.table.Table.prototype._onColumnResize = function(oEvent) {

	if (this._iColumnResizeStart && oEvent.pageX < this._iColumnResizeStart + 3 && oEvent.pageX > this._iColumnResizeStart - 3) {
		return;
	}

	this._$colResize.addClass("sapUiTableColRszActive");
	this._iColumnResizeStart = null;

	var $this = this.$();

	var bRtl = this._bRtlMode;
	var iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
	var oColumn = this.getColumns()[iColIndex];
	var $col = $this.find(".sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex='" + iColIndex + "']");

	// get the left position of the column to calculate the new width
	// relative to the parent container (sapUiTableCnt)!
	var iColLeft = $col.position().left;

	var iWidth;
	if (!bRtl) {
		// find the total left offset from the document (required for pageX info)
		var iOffsetLeft = $this.find(".sapUiTableCtrlFirstCol > th:first").offset().left;

		// relative left position within the table scroll container
		var iRelLeft = oEvent.pageX - iOffsetLeft;

		// calculate the new width
		iWidth = iRelLeft - iColLeft;
	} else {
		var $ScrollArea = $this.find('.sapUiTableCtrlScr');
		var iScrollAreaScrollLeft = $ScrollArea.scrollLeft();

		if(sap.ui.Device.browser.internet_explorer) {
			// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
			// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
			iScrollAreaScrollLeft = $ScrollArea[0].scrollWidth - iScrollAreaScrollLeft - $ScrollArea[0].clientWidth;
		}else if(sap.ui.Device.browser.firefox) {
			// FF has negative reverse scroll position (Chrome = 0, IE = 100, FF = -100)
			iScrollAreaScrollLeft = iScrollAreaScrollLeft + $ScrollArea[0].scrollWidth - $ScrollArea[0].clientWidth;
		}

		//get the difference between where mouse was released and left side of the table
		var iDiff = iColLeft - iScrollAreaScrollLeft - oEvent.pageX + $ScrollArea.offset().left;
		iWidth = $col.outerWidth() + iDiff;
	}

	iWidth = Math.max(iWidth, /* oColumn.getMinWidth() || */ this._iColMinWidth);
	//iWidth = Math.min(iWidth, oColumn.getMaxWidth() || iWidth);

	// calculate and set the position of the resize handle
	var iRszOffsetLeft = $this.find(".sapUiTableCnt").offset().left;
	var iRszLeft = oEvent.pageX - iRszOffsetLeft;
	iRszLeft -= this._$colResize.width() / 2;
	this._$colResize.css("left", iRszLeft);

	// store the width of the column to apply later
	oColumn._iNewWidth = iWidth;
};

/**
 * column is resized => update!
 * @private
 */
sap.ui.table.Table.prototype._onColumnResized = function(oEvent, iIndex) {
	var iColIndex;
	// ignore when no resize column is set
	if (!this._$colResize && (iIndex === null || iIndex === undefined)) {
		return;
	}
	// get the new width of the column
	if (iIndex === null || iIndex === undefined) {
		iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
	} else {
		iColIndex = iIndex;
	}
	var oColumn = this.getColumns()[iColIndex];
	// if the resize has started and we have a new width for the column
	// we apply it to the column object
	var bResized = false;
	if (!this._iColumnResizeStart && oColumn._iNewWidth) {
		var sWidth;
		var iAvailableSpace = this.$().find(".sapUiTableCtrl").width();
		if (!this._checkPercentageColumnWidth()) {
			sWidth = oColumn._iNewWidth + "px";
		} else {
			var iColumnWidth = Math.round(100 / iAvailableSpace * oColumn._iNewWidth);
			sWidth = iColumnWidth + "%";
		}
	
		this._updateColumnWidth(oColumn, sWidth);
		this._resizeDependentColumns(oColumn, sWidth);
	
		delete oColumn._iNewWidth;
		
		bResized = true;
	}

	// unbind the event handlers
	jQuery(document.body).
		unbind("mousemove", this._onColumnResize).
		unbind("mouseup", this._onColumnResized);

	// focus the column
	oColumn.focus();

	// hide the text selection
	if (this._$colResize) {
		this._$colResize.removeClass("sapUiTableColRszActive");
		this._$colResize = undefined;
	}
	this._enableTextSelection();
	
	// rerender / ignore if nothing changed!
	if (bResized) {
		this.invalidate();
	}

};

sap.ui.table.Table.prototype._resizeDependentColumns = function(oColumn, sWidth) {

	//Adjust columns only if the columns have percentage values
	if (this._checkPercentageColumnWidth()) {
		var aVisibleColumns = this._getVisibleColumns();
		//var oLastVisibleColumn = aVisibleColumns[aVisibleColumns.length - 1]; // NOT USED!
		//var bAllFollowingColumnsFlexible = true; // NOT USED!

		var iColumnIndex = undefined;
		jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
			if (oColumn === oCurrentColumn) {
				iColumnIndex = iIndex;
			//} else if (iColumnIndex !== undefined && !oCurrentColumn.getFlexible()) { // NOT REQUIRED?
				//bAllFollowingColumnsFlexible = false;
			}
		});

		var iOthersWidth = 0;
		var iLastIndex = aVisibleColumns.length - 1;
		var iTotalPercentage;
		if (iColumnIndex === undefined) {
			iTotalPercentage = 0;
		} else {
			iTotalPercentage = parseInt(sWidth,10);
		}
		var iPercentages = 0;
		var aOtherColumns = [];
		var that = this;

		jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
			var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
			if ((((iColumnIndex === iLastIndex && iIndex < iColumnIndex) || ((iColumnIndex !== iLastIndex) && iIndex > iColumnIndex)) && oCurrentColumn.getFlexible()) || iColumnIndex === undefined) {
				iOthersWidth += oCurrentColumn.$().outerWidth();
				iPercentages += iColumnPercentage;
				aOtherColumns.push(oCurrentColumn);
			} else if (iIndex !== iColumnIndex) {
				iTotalPercentage += iColumnPercentage;
			}
		});

		var iCalcPercentage = iTotalPercentage;
		jQuery.each(aOtherColumns, function(iIndex, oCurrentColumn){
			var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
			var iNewWidth = Math.round((100 - iCalcPercentage) / iPercentages * iColumnPercentage);
			if (iIndex === aOtherColumns.length - 1) {
				iNewWidth = 100 - iTotalPercentage;
			} else {
				iTotalPercentage += iNewWidth;
			}
			that._updateColumnWidth(oCurrentColumn, iNewWidth + "%");
		});
	} else if (!this._hasOnlyFixColumnWidths()) {
		
		var aVisibleColumns = this._getVisibleColumns(),
			iAvailableSpace = this.$().find(".sapUiTableCtrl").width(),
			iColumnIndex,
			iRightColumns = 0,
			iLeftWidth = 0,
			iRightWidth = 0,
			iNonFixedColumns = 0;

		jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
			//Check columns if they are fixed = they have a pixel width
			if (!jQuery.sap.endsWith(oCurrentColumn.getWidth(), "px")) {
				iNonFixedColumns++;
				return false;
			}
			//if iColumnIndex is defined we already found our column and all other columns are right of that one
			if (iColumnIndex != undefined) {
				iRightWidth += parseInt(oCurrentColumn.getWidth(),10);
				iRightColumns++;
			} else if (oColumn !== oCurrentColumn) {
				iLeftWidth += parseInt(oCurrentColumn.getWidth(),10);
			}
			if (oColumn === oCurrentColumn) {
				iColumnIndex = iIndex;
				//Use new width of column
				iLeftWidth += parseInt(sWidth,10);
			}
		});
		//If there are non fixed columns we don't do this
		if (iNonFixedColumns > 0 || (iLeftWidth + iRightWidth > iAvailableSpace)) {
			return;
		}
		//Available space is all space right of the modified columns
		iAvailableSpace -= iLeftWidth;
		for (var i=iColumnIndex+1;i<aVisibleColumns.length; i++) {
			//Calculate new column width based on previous percentage width
			var oColumn = aVisibleColumns[i],
				iColWidth = parseInt(oColumn.getWidth(),10),
				iPercent = iColWidth / iRightWidth * 100,
				iNewWidth = iAvailableSpace / 100 * iPercent;
			this._updateColumnWidth(oColumn, Math.round(iNewWidth)+'px');
		}
	}
};

sap.ui.table.Table.prototype._getColumnPercentageWidth = function(oColumn) {
	var sColumnWidth = oColumn.getWidth();
	var iColumnPercentage = parseInt(oColumn.getWidth(),10);
	var iTotalWidth = this.$().find(".sapUiTableCtrl").width();
	if (jQuery.sap.endsWith(sColumnWidth, "px")) {
		iColumnPercentage = Math.round(100 / iTotalWidth * iColumnPercentage);
	} else if (!jQuery.sap.endsWith(sColumnWidth, "%")) {
		iColumnPercentage = Math.round(100 / iTotalWidth * oColumn.$().width());
	}
	return iColumnPercentage;
};

sap.ui.table.Table.prototype._updateColumnWidth = function(oColumn, sWidth) {
	// forward the event
	var bExecuteDefault = this.fireColumnResize({
		column: oColumn,
		width: sWidth
	});

	// set the width of the column (when not cancelled)
	if (bExecuteDefault) {
		oColumn.setProperty("width", sWidth, true);
		this.$().find('th[aria-owns="' + oColumn.getId() + '"]').css('width', sWidth);
	}
};

/**
 * Check if at least one column has a percentage value
 */
sap.ui.table.Table.prototype._checkPercentageColumnWidth = function() {
	var aColumns = this.getColumns();
	var bHasPercentageColumns = false;
	jQuery.each(aColumns, function(iIndex, oColumn) {
		if (jQuery.sap.endsWith(oColumn.getWidth(), "%")) {
			bHasPercentageColumns = true;
			return false;
		}
	});
	return bHasPercentageColumns;
};

/**
 * Check if table has only non flexible columns with fixed widths and only then
 * the table adds a dummy column to fill the rest of the width instead of resizing
 * the columns to fit the complete table width
 */
sap.ui.table.Table.prototype._hasOnlyFixColumnWidths = function() {
	var bOnlyFixColumnWidths = true;
	jQuery.each(this.getColumns(), function(iIndex, oColumn) {
		var sWidth = oColumn.getWidth();
		if (oColumn.getFlexible() || !sWidth || sWidth.substr(-2) !== "px") {
			bOnlyFixColumnWidths = false;
			return false;
		}
	});
	return bOnlyFixColumnWidths;
};


// =============================================================================
// SORTING & FILTERING
// =============================================================================

sap.ui.table.Table.prototype.sort = function(oColumn, oSortOrder, bAdd) {
	if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
		oColumn.sort(oSortOrder === sap.ui.table.SortOrder.Descending, bAdd);
	}
};

sap.ui.table.Table.prototype.filter = function(oColumn, sValue) {
	if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
		oColumn.filter(sValue);
	}
};


// =============================================================================
// SELECTION HANDLING
// =============================================================================

/**
 * updates the visual selection in the HTML markup
 */
sap.ui.table.Table.prototype._updateSelection = function() {
	if (this.getSelectionMode() === sap.ui.table.SelectionMode.None) {
		return;
	}
	var $this = this.$();
	var iFirstRow = this.getFirstVisibleRow();
	var that = this;
	var oResBundle = this._oResBundle;
	var bMultiSelection = this._oSelection.getSelectedIndices().length > 1;
	// Only show "click to select"-tooltip on cell if it actually can be selected that way
	var bSelectOnCell = this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowSelector;
	var sRowSelect           = oResBundle.getText("TBL_ROW_SELECT");
	var sRowSelectKey        = oResBundle.getText("TBL_ROW_SELECT_KEY");
	var sRowDeSelect         = oResBundle.getText("TBL_ROW_DESELECT");
	var sRowDeSelectKey      = oResBundle.getText("TBL_ROW_DESELECT_KEY");
	var sRowSelectMulti      = oResBundle.getText("TBL_ROW_SELECT_MULTI");
	var sRowSelectMultiKey   = oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY");
	var sRowDeSelectMulti    = oResBundle.getText("TBL_ROW_DESELECT_MULTI");
	var sRowDeSelectMultiKey = oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY");
	
	
	$this.find(".sapUiTableRowHdr").each(function(iIndex, oElement) {
		var $jqTR1 = jQuery($this.find(".sapUiTableCtrlFixed > tbody > tr").get(iIndex));
		var $jqTR2 = jQuery($this.find(".sapUiTableCtrlScroll > tbody > tr").get(iIndex));
		var $jqTR = $jqTR1.add($jqTR2);
		var $jqDIV = jQuery(this);
		var $jqRow = $jqDIV.add($jqTR);
		if (that.isIndexSelected(iFirstRow + iIndex)) {
			if (!jQuery(this).hasClass("sapUiTableRowSel")) {
				jQuery(this).addClass("sapUiTableRowSel");
				$jqTR.addClass("sapUiTableRowSel");
				$jqRow.attr("aria-selected", "true");
				$jqTR.children("td").attr("aria-selected", "true");
			}
			if (bMultiSelection) {
				$jqTR.find(".sapUiTableAriaRowSel").text(sRowDeSelectMultiKey);
				if (bSelectOnCell) {
					$jqRow.attr("title", sRowDeSelectMulti).
						attr("aria-label", sRowDeSelectMultiKey);
					$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-deselectrowmulti");
				}
			} else {
				$jqTR.find(".sapUiTableAriaRowSel").text(sRowDeSelectKey);
				if (bSelectOnCell) {
					$jqRow.attr("title", sRowDeSelect).
						attr("aria-label", sRowDeSelectKey);
					$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-deselectrow");
				}
			}
		} else {
			if (jQuery(this).hasClass("sapUiTableRowSel")) {
				jQuery(this).removeClass("sapUiTableRowSel");
				$jqTR.removeClass("sapUiTableRowSel");
				if (that.getSelectionMode()  === sap.ui.table.SelectionMode.Multi ||
				    that.getSelectionMode()  === sap.ui.table.SelectionMode.MultiToggle) {
					$jqRow.attr("aria-selected", "false");
					$jqTR.children("td").attr("aria-selected", "false");
				} else {
					$jqRow.removeAttr("aria-selected");
					$jqTR.children("td").removeAttr("aria-selected");
				}
			}
			if ((that.getSelectionMode() === sap.ui.table.SelectionMode.Multi ||
			    that.getSelectionMode()  === sap.ui.table.SelectionMode.MultiToggle) && that._oSelection.getSelectedIndices().length > 0) {
				$jqTR.find(".sapUiTableAriaRowSel").text(sRowSelectMulti);
				if (bSelectOnCell) {
					$jqRow.attr("title", sRowSelectMulti).
						attr("aria-label", sRowSelectMultiKey);
					$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-selectrowmulti");
				}
			} else {
				$jqTR.find(".sapUiTableAriaRowSel").text(sRowSelectKey);
				if (bSelectOnCell) {
					$jqRow.attr("title", sRowSelect).
						attr("aria-label", sRowSelectKey);
					$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-selectrow");
				}
			}
		}
	});
	// update internal property to reflect the correct index
	this.setProperty("selectedIndex", this.getSelectedIndex(), true); 
};


/**
 * notifies the selection listeners about the changed rows
 */
sap.ui.table.Table.prototype._onSelectionChanged = function(oEvent) {
	var aRowIndices = oEvent.getParameter("rowIndices");
	var iRowIndex = this._iSourceRowIndex !== undefined ? this._iSourceRowIndex : this.getSelectedIndex();
	this._updateSelection();
	var oSelMode = this.getSelectionMode();
	if (oSelMode == "Multi" || oSelMode == "MultiToggle") {
		this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");
	}
	this.fireRowSelectionChange({
		rowIndex: iRowIndex,
		rowContext: this.getContextByIndex(iRowIndex),
		rowIndices: aRowIndices
	});
};


/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.getContextByIndex = function(iIndex) {
	// TODO: ODataListBinding needs to make sure to prevent loading multiple times
	// index must not be smaller than 0! otherwise the ODataModel fails
	var oBinding = this.getBinding("rows");
	return iIndex >= 0 && oBinding ? oBinding.getContexts(iIndex, 1)[0] : null;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.getSelectedIndex = function() {
	return this._oSelection.getLeadSelectedIndex();
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setSelectedIndex = function(iIndex) {
	if (iIndex === -1) {
		//If Index eq -1 no item is selected, therefore clear selection is called
		//SelectionModel doesn't know that -1 means no selection
		this._oSelection.clearSelection();
	} else {
		this._oSelection.setSelectionInterval(iIndex, iIndex);
	}
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.clearSelection = function() {
	this._oSelection.clearSelection();
	var oSelMode = this.getSelectionMode();
	if (oSelMode == "Multi" || oSelMode == "MultiToggle") {
		this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");
	}
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.selectAll = function() {
	var oSelMode = this.getSelectionMode();
	if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle")) {
		return this;
	}
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		this._oSelection.setSelectionInterval(0, (oBinding.getLength() || 0) - 1);
		this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
	}
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.getSelectedIndices = function() {
	return this._oSelection.getSelectedIndices();
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.addSelectionInterval = function(iIndexFrom, iIndexTo) {
	this._oSelection.addSelectionInterval(iIndexFrom, iIndexTo);
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.setSelectionInterval = function(iIndexFrom, iIndexTo) {
	this._oSelection.setSelectionInterval(iIndexFrom, iIndexTo);
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.removeSelectionInterval = function(iIndexFrom, iIndexTo) {
	this._oSelection.removeSelectionInterval(iIndexFrom, iIndexTo);
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.Table.prototype.isIndexSelected = function(iIndex) {
	return this._oSelection.isSelectedIndex(iIndex);
};


// =============================================================================
// KEYBOARD HANDLING HELPERS
// =============================================================================

/**
 * scrolls down a single row
 * @private
 */
sap.ui.table.Table.prototype._scrollNext = function() {
	// we are at the end => scroll one down if possible
	if (this.getFirstVisibleRow() < this._getRowCount() - this.getVisibleRowCount()) {
		this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + 1, this._getRowCount() - this.getVisibleRowCount()));
	}
};

/**
 * scrolls up a single row
 * @private
 */
sap.ui.table.Table.prototype._scrollPrevious = function() {
	// we are at the beginning => scroll one up if possible
	if (this.getFirstVisibleRow() > 0) {
		this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - 1, 0));
	}
};

/**
 * scrolls down a up page
 * @private
 */
sap.ui.table.Table.prototype._scrollPageUp = function() {
	this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - this.getVisibleRowCount(), 0));
};

/**
 * scrolls down a complete page
 * @private
 */
sap.ui.table.Table.prototype._scrollPageDown = function() {
	this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + this.getVisibleRowCount(), this._getRowCount() - this.getVisibleRowCount()));
};

/**
 * checks if the current target domref is in the first row of the table
 * @private
 */
sap.ui.table.Table.prototype._isTopRow = function(oEvent) {
	var $target = jQuery(oEvent.target);
	var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
	var iFixedRows = this.getFixedRowCount();
	if (iFixedRows > 0 && iRowIndex >= iFixedRows) {
		return iRowIndex === iFixedRows;
	}
	return iRowIndex === 0;
};

/**
 * checks if the current target domref is in the last row of the table
 * @private
 */
sap.ui.table.Table.prototype._isBottomRow = function(oEvent) {
	var $target = jQuery(oEvent.target);
	var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
	var iFixedRows = this.getFixedBottomRowCount();
	if (iFixedRows > 0 && iRowIndex <= this.getVisibleRowCount() - 1 - iFixedRows) {
		return iRowIndex === this.getVisibleRowCount() - 1 - iFixedRows;
	}
	return iRowIndex === this.getVisibleRowCount() - 1;
};

/**
 * enters the action mode. in the action mode the user can navigate through the
 * interactive controls of the table by using the TAB & SHIFT-TAB. this table is
 * aligned with the official WAI-ARIA 1.0.
 * @private
 */
sap.ui.table.Table.prototype._enterActionMode = function($Focusable) {
	// only enter the action mode when not already in action mode and:
	if ($Focusable.length > 0 && !this._bActionMode) {

		//If cell has no tabbable element, we don't do anything
		if($Focusable.filter(":sapTabbable").length == 0) {
			return;
		}

		// in the action mode we need no item navigation
		this._bActionMode = true;
		this.removeDelegate(this._oItemNavigation);

		// remove the tab index from the item navigation
		jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "-1");

		// set the focus to the active control
		$Focusable.filter(":sapTabbable").eq(0).focus();
	}
};

/**
 * leaves the action mode and enters the navigation mode. in the navigation mode
 * the user can navigate through the cells of the table by using the arrow keys,
 * page up & down keys, home and end keys. this table is aligned with the
 * official WAI-ARIA 1.0.
 * @private
 */
sap.ui.table.Table.prototype._leaveActionMode = function(oEvent) {

 // TODO: update ItemNavigation position otherwise the position is strange!
 //        EDIT AN SCROLL!

	if (this._bActionMode) {

		// in the navigation mode we use the item navigation
		this._bActionMode = false;
		this.addDelegate(this._oItemNavigation);

		// reset the tabindex of the focused domref of the item navigation
		jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "0");

		// when we have an event which is responsible to leave the action mode
		// we search for the closest
		if (oEvent) {
			if (jQuery(oEvent.target).closest("td[tabindex='-1']").length > 0) {
				// triggered when clicking into a cell, then we focus the cell
				var iIndex = jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(oEvent.target).closest("td[tabindex='-1']").get(0));
				this._oItemNavigation.focusItem(iIndex, null);
			} else {
				// somewhere else means whe check if the click happend inside
				// the container, then we focus the last focused element
				// (DON'T KNOW IF THIS IS OK - but we don't know where the focus was!)
				if (jQuery.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0), oEvent.target)) {
					this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
				}
			}
		} else {
			// when no event is given we just focus the last focused index
			this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
		}
		
	}

};


// =============================================================================
// KEYBOARD HANDLING EVENTS
// =============================================================================

// FYI: two more relevant things are handled in the onclick and onfocusin event

/**
 * handle the row selection via SPACE or ENTER key
 * @private
 */
sap.ui.table.Table.prototype.onsapselectmodifiers = 
sap.ui.table.Table.prototype.onsapselect = function(oEvent) {
	if (oEvent.srcControl !== this && jQuery.inArray(oEvent.srcControl,this.getRows()) === -1 && jQuery.inArray(oEvent.srcControl,this.getColumns()) === -1) {
		return;
	}
	this._bShowMenu = true;
	this._onSelect(oEvent);
	this._bShowMenu = false;
	oEvent.preventDefault();
};

/**
 * handle the row selection via SPACE or ENTER key
 * @private
 */
sap.ui.table.Table.prototype.onkeydown = function(oEvent) {
	var $this = this.$();
	if (!this._bActionMode &&
		oEvent.keyCode == jQuery.sap.KeyCodes.F2 ||
		oEvent.keyCode == jQuery.sap.KeyCodes.ENTER) {
		if ($this.find(".sapUiTableCtrl td:focus").length > 0) {
			this._enterActionMode($this.find(".sapUiTableCtrl td:focus").find(":sapFocusable"));
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	} else if (this._bActionMode &&
		oEvent.keyCode == jQuery.sap.KeyCodes.F2) {
		this._leaveActionMode(oEvent);
	} else if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode) {
		//Set tabindex to second table if fixed columns are used
		if (this.getFixedColumnCount() > 0) {
			var $cell = jQuery(oEvent.target);
			if ($cell.is("td[role=gridcell]") == false) {
				$cell = $cell.parents("td[role=gridcell]");
			}
			var $row = $cell.parent("tr[data-sap-ui-rowindex]");
			var $table = $row.closest(".sapUiTableCtrl");
			var iRowIndex = parseInt($row.attr("data-sap-ui-rowindex"),10);
			var $cells = $row.find("td[role=gridcell]");
			var iColIndex = $cells.index($cell);
			var iTableCols = $cells.length;
			if (iColIndex === (iTableCols - 1)) {
				var $otherTable;
				if ($table.hasClass("sapUiTableCtrlFixed")) {
					$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll");
				} else {
					$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlFixed");
					iRowIndex++;
					if (iRowIndex == this.getVisibleRowCount()) {
						iRowIndex = 0;
					}
				}
				var $otherRow = $otherTable.find("tr[data-sap-ui-rowindex='" + iRowIndex + "']");
				var $nextFocus = $otherRow.find("td :sapFocusable[tabindex='0']").first();
				if ($nextFocus.length > 0) {
					$nextFocus.focus();
					oEvent.preventDefault();
				}
			}
		}
	}
};

/**
 * handle the ESCAPE key to leave the action mode
 * @private
 */
sap.ui.table.Table.prototype.onsapescape = function(oEvent) {
	this._leaveActionMode(oEvent);
};

/**
 * handle the SHIFT-TAB key
 * <ul>
 *   <li>Navigation Mode: jump to the next focusable control before the table</li>
 *   <li>Action Mode: focus previous focusable control (wrap at the beginning)</li>
 * </ul>
 * @private
 */
sap.ui.table.Table.prototype.onsaptabprevious = function(oEvent) {
	var $this = this.$();
	if (this._bActionMode) {
		if ($this.find(".sapUiTableCtrlFixed").firstFocusableDomRef() === oEvent.target) {
			$this.find(".sapUiTableCtrlScroll").lastFocusableDomRef().focus();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	} else {
		// in case of having the focus in the row or column header we do not need to
		// place the focus to the div before the table control because there we do
		// not need to skip the table controls anymore.
		if (this._oItemNavigation.getFocusedDomRef() === oEvent.target &&
				jQuery.sap.containsOrEquals($this.find(".sapUiTableCCnt").get(0), oEvent.target)) {
			this._bIgnoreFocusIn = true;
			$this.find(".sapUiTableCtrlBefore").focus();
			this._bIgnoreFocusIn = false;
		}
	}
};

/**
 * handle the TAB key:
 * <ul>
 *   <li>Navigation Mode: jump to the next focusable control after the table</li>
 *   <li>Action Mode: focus next focusable control (wrap at the end)</li>
 * </ul>
 * @private
 */
sap.ui.table.Table.prototype.onsaptabnext = function(oEvent) {
	var $this = this.$();
	if (this._bActionMode) {
		if ($this.find(".sapUiTableCCnt").lastFocusableDomRef() === oEvent.target) {
			$this.find(".sapUiTableCCnt").firstFocusableDomRef().focus();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	} else {
		if (this._oItemNavigation.getFocusedDomRef() === oEvent.target) {
			this._bIgnoreFocusIn = true;
			$this.find(".sapUiTableCtrlAfter").focus();
			this._bIgnoreFocusIn = false;
		}
	}
};

/**
 * dynamic scrolling when reaching the bottom row with the ARROW DOWN key
 * @private
 */
sap.ui.table.Table.prototype.onsapdown = function(oEvent) {
	if (!this._bActionMode && this._isBottomRow(oEvent)) {
		if (this.getFirstVisibleRow() != this._getRowCount() - this.getVisibleRowCount() - this.getFixedBottomRowCount()) {
			oEvent.stopImmediatePropagation(true);
			if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
				this._scrollNext();
			} else {
				this._scrollPageDown();
			}
		}
	}
	oEvent.preventDefault();
};

/**
 * dynamic scrolling when reaching the top row with the ARROW UP key
 * @private
 */
sap.ui.table.Table.prototype.onsapup = function(oEvent) {
	if (!this._bActionMode && this._isTopRow(oEvent)) {
		if (this.getFirstVisibleRow() != 0) {
			oEvent.stopImmediatePropagation(true);
		}
		if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
			this._scrollPrevious();
		} else {
			this._scrollPageUp();
		}
	}
	oEvent.preventDefault();
};

/**
 * dynamic scrolling when reaching the bottom row with the PAGE DOWN key
 * @private
 */
sap.ui.table.Table.prototype.onsappagedown = function(oEvent) {
	if (!this._bActionMode && this._isBottomRow(oEvent)) {
		this._scrollPageDown();
	}
	oEvent.preventDefault();
};

/**
 * dynamic scrolling when reaching the top row with the PAGE UP key
 * @private
 */
sap.ui.table.Table.prototype.onsappageup = function(oEvent) {
	if (!this._bActionMode) {
		var oIN = this._oItemNavigation;
		var iIndex = this.getColumnHeaderVisible() ? oIN.iColumns : 0;
		// we need to make sure to move to the first row before switching into the column header
		if (oIN.iFocusedIndex >= iIndex && this.getFirstVisibleRow() != 0) {
			var iCol = oIN.iFocusedIndex % oIN.iColumns;
			oIN.focusItem(iIndex + iCol, oEvent);
			oEvent.stopImmediatePropagation(true);
		}
		if (this._isTopRow(oEvent)) {
			this._scrollPageUp();
		}
	}
	oEvent.preventDefault();
};

/**
 * dynamic scrolling when using CTRL + HOME key
 * @private
 */
sap.ui.table.Table.prototype.onsaphomemodifiers = function(oEvent) {
	if (oEvent.metaKey || oEvent.ctrlKey) {
		this.setFirstVisibleRow(0);
	}
};

/**
 * dynamic scrolling when using CTRL + END key
 * @private
 */
sap.ui.table.Table.prototype.onsapendmodifiers = function(oEvent) {
	if (oEvent.metaKey || oEvent.ctrlKey) {
		this.setFirstVisibleRow(this._getRowCount() - this.getVisibleRowCount());
	}
};


// =============================================================================
// GROUPING
// =============================================================================

/* 
 * overridden to hide the group by column when set
 */
sap.ui.table.Table.prototype.setGroupBy = function(vValue) {

	// determine the group by column
	var oGroupBy = vValue;
	if (typeof oGroupBy === "string") {
		oGroupBy = sap.ui.getCore().byId(oGroupBy);
	}

	// only for columns we do the full handling here - otherwise the method
	// setAssociation will fail below with a specific fwk error message
	var bReset = false;
	if (oGroupBy && oGroupBy instanceof sap.ui.table.Column) {
	
		// check for column being part of the columns aggregation
		if (jQuery.inArray(oGroupBy, this.getColumns()) === -1) {
			throw new Error("Column has to be part of the columns aggregation!");
		} 
	
		// fire the event (to allow to cancel the event)
		var bExecuteDefault = this.fireGroup({column: oGroupBy});
	
		// first we reset the grouping indicator of the old column (will show the column)
		var oOldGroupBy = sap.ui.getCore().byId(this.getGroupBy());
		if (oOldGroupBy) {
			oOldGroupBy.setGrouped(false);
			bReset = true; 
		}
	
		// then we set the grouping indicator of the new column (will hide the column)
		// ==> only if the default behavior is not prevented 
		if (bExecuteDefault && oGroupBy instanceof sap.ui.table.Column) {
			oGroupBy.setGrouped(true);
		}
		
	}
	
	// reset the binding when no value is given or the binding needs to be reseted
	// TODO: think about a better handling to recreate the group binding
	if (!oGroupBy || bReset) {
		var oBindingInfo = this.getBindingInfo("rows");
		delete oBindingInfo.binding;
		this._bindAggregation("rows", oBindingInfo);
	}

	// set the new group by column (TODO: undefined doesn't work!)
	return this.setAssociation("groupBy", oGroupBy);
};

/*
 * override the getBinding to inject the grouping information into the JSON model.
 *
 * !!EXPERIMENTAL FEATURE!!
 * 
 * TODO: 
 *   - Grouping is not really possible for models based on OData: 
 *     - it works when loading data from the beginning because in this case the
 *       model has the relevant information (distinct values) to determine the
 *       count of rows and add them properly in the scrollbar as well as adding
 *       the group information to the contexts array which is used by the 
 *       _modifyRow to display the group headers
 *     - it doesn't work when not knowing how many groups are available before
 *       and on which position the group header has to be added - e.g. when 
 *       displaying a snapshot in the middle of the model.
 *   - For OData it might be a server-side feature?
 */
sap.ui.table.Table.prototype.getBinding = function(sName) {

	// default binding is the "rows" binding
	sName = sName || "rows";
	var oBinding = sap.ui.core.Element.prototype.getBinding.call(this, sName);

	// we do all the extended stuff only when grouping is enabled
	if (this.getEnableGrouping()) {

		// require the binding types (think about loading them only if required)
		jQuery.sap.require("sap.ui.model.ClientListBinding");
	
		// check for grouping being supported or not (only for client ListBindings!!) 
		var oGroupBy = sap.ui.getCore().byId(this.getGroupBy());
		var bIsSupported = oGroupBy && oGroupBy.getGrouped() &&
		                   sName === "rows" && oBinding && 
		                   oBinding instanceof sap.ui.model.ClientListBinding;
	
		// only enhance the binding if it has not been done yet and supported!
		if (bIsSupported && !oBinding._modified) {
			
			// once the binding is modified we always return the modified binding
			// and don't wanna modifiy the binding once again
			oBinding._modified = true;
			 
			// hook into the row modification and add the grouping specifics
			this._modifyRow = function(iRowIndex, $row) {
	
				// we add the style override to display the row header
				this.$().find(".sapUiTableRowHdrScr").css("display", "block");

				// modify the rows
				var $rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
				if (oBinding.isGroupHeader(iRowIndex)) {
					$row.addClass("sapUiTableGroupHeader sapUiTableRowHidden");
					var sClass = oBinding.isExpanded(iRowIndex) ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
					$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\">" + oBinding.getTitle(iRowIndex) + "</div>");
					$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
				} else {
					$row.removeClass("sapUiTableGroupHeader");
					$rowHdr.html("");
					$rowHdr.removeClass("sapUiTableGroupHeader");
				}
				
			};
			
			this.onclick = function(oEvent) {
				if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
					var $parent = jQuery(oEvent.target).parents("[data-sap-ui-rowindex]");
					if ($parent.length > 0) {
						var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
						var oBinding = this.getBinding("rows");
						if (oBinding.isExpanded(iRowIndex)) {
							oBinding.collapse(iRowIndex);
							jQuery(oEvent.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");
						} else {
							oBinding.expand(iRowIndex);
							jQuery(oEvent.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");
						}
					}
				} else {
					if (sap.ui.table.Table.prototype.onclick) {
						sap.ui.table.Table.prototype.onclick.apply(this, arguments);
					}
				}
			};

			// we use sorting finally to sort the values and afterwards group them
			var sPropertyName = oGroupBy.getSortProperty();
			oBinding.sort(new sap.ui.model.Sorter(sPropertyName));

			// fetch the contexts from the original binding
			var iLength = oBinding.getLength(),
				aContexts = oBinding.getContexts(0, iLength);

			// add the context information for the group headers which are later on
			// used for displaying the grouping information of each group
			var sKey = undefined;
			var iCounter = 0;
			for (var i = iLength - 1; i >= 0; i--) {
				var sNewKey = aContexts[i].getProperty(sPropertyName); 
				if (!sKey) {
					sKey = sNewKey;
				}
				if (sKey !== sNewKey) {
					aContexts.splice(i + 1, 0, {
						oContext: aContexts[i + 1],
						name: sKey,
						count: iCounter,
						groupHeader: true,
						expanded: true
					});
					sKey = sNewKey;
					iCounter = 0;
				}
				iCounter++;
			}
			aContexts.splice(0, 0, {
				oContext: aContexts[0],
				name: sKey,
				count: iCounter,
				groupHeader: true,
				expanded: true
			});
		
			// extend the binding and hook into the relevant functions to provide
			// access to the grouping information for the _modifyRow function
			jQuery.extend(oBinding, {
				getLength: function() {
					return aContexts.length;
				},
				getContexts: function(iStartIndex, iLength) {
					return aContexts.slice(iStartIndex, iStartIndex + iLength);
				},
				isGroupHeader: function(iIndex) {
					var oContext = aContexts[iIndex];
					return oContext && !(oContext instanceof sap.ui.model.Context);
				},
				getTitle: function(iIndex) {
					var oContext = aContexts[iIndex];
					return oContext && !(oContext instanceof sap.ui.model.Context) && (oContext["name"] + " - " + oContext["count"]);
				},
				isExpanded: function(iIndex) {
					return this.isGroupHeader(iIndex) && aContexts[iIndex].expanded;
				},
				expand: function(iIndex) {
					if (this.isGroupHeader(iIndex) && !aContexts[iIndex].expanded) {
						for (var i = 0; i < aContexts[iIndex].childs.length; i++) {
							aContexts.splice(iIndex + 1 + i, 0, aContexts[iIndex].childs[i]);
						}
						delete aContexts[iIndex].childs;
						aContexts[iIndex].expanded = true;
						this._fireChange();
					}
				},
				collapse: function(iIndex) {
					if (this.isGroupHeader(iIndex) && aContexts[iIndex].expanded) {
						aContexts[iIndex].childs = aContexts.splice(iIndex + 1, aContexts[iIndex].count);
						aContexts[iIndex].expanded = false;
						this._fireChange();
					}
				}
				
			});
			
		}
		
	}

	return oBinding;

};

sap.ui.table.Table.prototype.resetGrouping = function() {

	// reset the group binding only when enhanced
	var oBinding = this.getBinding("rows");
	if (oBinding && oBinding._modified) {

		// we remove the style override to display the row header
		this.$().find(".sapUiTableRowHdrScr").css("display", "");

		// if the grouping is not supported we remove the hacks we did
		// and simply return the binding finally
		this.onclick = sap.ui.table.Table.prototype.onclick;
		this._modifyRow = undefined;
		
		// reset the binding
		var oBindingInfo = this.getBindingInfo("rows");
		this.unbindRows();
		this.bindRows(oBindingInfo);

	}

};

sap.ui.table.Table.prototype.setEnableGrouping = function(bEnableGrouping) {
	// set the property
	this.setProperty("enableGrouping", bEnableGrouping);
	// reset the grouping
	if (!bEnableGrouping) {
		this.resetGrouping();
	}
	// update the column headers
	this._invalidateColumnMenus();
	return this;
}; 

sap.ui.table.Table.prototype.setEnableCustomFilter = function(bEnableCustomFilter) {
	this.setProperty("enableCustomFilter", bEnableCustomFilter);
	// update the column headers
	this._invalidateColumnMenus();
	return this;
};

sap.ui.table.Table.prototype.setEnableColumnFreeze = function(bEnableColumnFreeze) {
	this.setProperty("enableColumnFreeze", bEnableColumnFreeze);
	this._invalidateColumnMenus();
	return this;
}; 

sap.ui.table.Table.prototype.setShowColumnVisibilityMenu = function(bShowColumnVisibilityMenu) {
	this.setProperty("showColumnVisibilityMenu", bShowColumnVisibilityMenu);
	this._invalidateColumnMenus();
	return this;
}; 

sap.ui.table.Table.prototype.setFixedColumnCount = function(iFixedColumnCount) {
	var aCols = this._getVisibleColumns();
	var vHeaderSpan = aCols[iFixedColumnCount-1] && aCols[iFixedColumnCount-1].getHeaderSpan();
	if (vHeaderSpan) {
		var iHeaderSpan;
		if (jQuery.isArray(vHeaderSpan)) {
			iHeaderSpan = parseInt(vHeaderSpan[0], 10);
		} else {
			iHeaderSpan = parseInt(vHeaderSpan, 10);
		}
		iFixedColumnCount += iHeaderSpan - 1;
	}
	//Set current width as fixed width for cols
	var $ths = this.$().find(".sapUiTableCtrlFirstCol > th");
	for (var i = 0; i < iFixedColumnCount; i++) {
		var oColumn = aCols[i];
		if (oColumn) {
			var iColumnIndex = jQuery.inArray(oColumn, this.getColumns());
			if (!oColumn.getWidth()) {
				oColumn.setWidth($ths.filter("[data-sap-ui-headcolindex='" + iColumnIndex + "']").width() + "px");
			}
		}
	}
	this.setProperty("fixedColumnCount", iFixedColumnCount);
	this._invalidateColumnMenus();
	return this;
};

sap.ui.table.Table.prototype._invalidateColumnMenus = function() {
	var aCols = this.getColumns();
	for (var i = 0, l = aCols.length; i < l; i++) {
		if (aCols[i].getMenu()) {
			aCols[i].getMenu()._bInvalidated = true;
		}
	}
};

/**
 * The selectstart event triggered in IE to select the text.
 * @private
 * @param {event} oEvent The splitterselectstart event
 * @return {boolean} false
 */
sap.ui.table.Table.prototype._splitterSelectStart = function(oEvent){
	oEvent.preventDefault();
	oEvent.stopPropagation();
	return false;
};

/**
 * drops the splitter bar
 */
sap.ui.table.Table.prototype._onGhostMouseRelease = function(oEvent) {

	var splitterBarGhost = this.getDomRef("ghost");

	var iNewHeight = oEvent.pageY - this.$().offset().top;

    this.setVisibleRowCount(this._calculateRowsToDisplay(iNewHeight));

	jQuery(splitterBarGhost).remove();
	this.$("overlay").remove();

	jQuery(document.body).unbind("selectstart", this._splitterSelectStart);
	jQuery(document).unbind("mouseup", this._onGhostMouseRelease);
	jQuery(document).unbind("mousemove", this._onGhostMouseMove);

};

sap.ui.table.Table.prototype._onGhostMouseMove = function(oEvent) {
	var splitterBarGhost = this.getDomRef("ghost");

	var min = this.$().offset().top;
	if (oEvent.pageY > min) {
		jQuery(splitterBarGhost).css("top", oEvent.pageY + "px");
	}
};

sap.ui.table.Table.prototype._calculateRowsToDisplay = function(iHeight) {
	var $this = this.$();
	var iControlHeight = this.$().outerHeight();
	var iHeaderHeight = $this.find('.sapUiTableColHdrCnt').outerHeight();
	var iContentHeight = $this.find('.sapUiTableCCnt').outerHeight();
	var iMinRowCount = this.getMinAutoRowCount()||5; 

	var iRowHeight = $this.find(".sapUiTableCtrl tr[data-sap-ui-rowindex='0']").outerHeight();
	//No rows displayed when visible row count == 0, now row height can be determined, therefore we set standard row height
	if (iRowHeight == null) {
		var sRowHeightParamName = "sap.ui.table.Table:sapUiTableRowHeight";
		if ($this.parents().hasClass('sapUiSizeCompact')) {
			sRowHeightParamName = "sap.ui.table.Table:sapUiTableCompactRowHeight";
		}
		iRowHeight = parseInt(sap.ui.core.theming.Parameters.get(sRowHeightParamName), 10);
	}
	var iAvailableSpace = iHeight - (iControlHeight - iHeaderHeight - iContentHeight) - iHeaderHeight;

	return Math.max(iMinRowCount, Math.floor(iAvailableSpace/iRowHeight));
};

sap.ui.table.Table.prototype.setShowNoData = function(bShowNoData) {
	this.setProperty('showNoData', bShowNoData, true);
	bShowNoData = this.getProperty('showNoData');
	if (!bShowNoData) {
		this.$().removeClass("sapUiTableEmpty");
	} else {
		this._updateNoData();
	}
	return this;
};

sap.ui.table.Table.prototype.setNoDataText = function(sText) {
	this.setProperty("noDataText", sText, true);
	this.$().find('.sapUiTableCtrlEmptyMsg').text(sText);
};

/**
 * Creates a new {@link sap.ui.core.util.Export} object and fills row/column information from the table if not provided. For the cell content, the column's "sortProperty" will be used (experimental!)
 *
 * <p><b>Please note: The return value was changed from jQuery Promises to standard ES6 Promises.
 * jQuery specific Promise methods ('done', 'fail', 'always', 'pipe' and 'state') are still available but should not be used. 
 * Please use only the standard methods 'then' and 'catch'!</b></p>
 *
 * @param {object} [mSettings] settings for the new Export, see {@link sap.ui.core.util.Export} <code>constructor</code>
 * @return {Promise} Promise object
 *
 * @experimental Experimental because the property for the column/cell definitions (sortProperty) could change in future.
 * @public
 * @name sap.ui.table.Table#exportData
 * @function
 */
sap.ui.table.Table.prototype.exportData = function(mSettings) {
	jQuery.sap.require("sap.ui.core.util.Export");

	mSettings = mSettings || {};

	if (!mSettings.rows) {
		var oBinding = this.getBinding("rows"),
			oBindingInfo = this.getBindingInfo("rows");

		var aFilters = oBinding.aFilters.concat(oBinding.aApplicationFilters);

		mSettings.rows = {
			path: oBindingInfo.path,
			model: oBindingInfo.model,
			sorter: oBinding.aSorters,
			filters: aFilters,
			parameters: oBindingInfo.parameters
		};
	}
	
	// by default we choose the export type CSV
	if (!mSettings.exportType) {
		jQuery.sap.require("sap.ui.core.util.ExportTypeCSV");
		mSettings.exportType = new sap.ui.core.util.ExportTypeCSV();
	}

	var sModelName = mSettings.rows.model;
	if (!sModelName) {
		// if a model separator is found in the path, extract model name from there
		var sPath = mSettings.rows.path;
		var iSeparatorPos = sPath.indexOf(">");
		if (iSeparatorPos > 0) {
			sModelName = sPath.substr(0, iSeparatorPos);
		}
	}

	if (!mSettings.columns) {
		mSettings.columns = [];

		var aColumns = this.getColumns();
		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oColumn = aColumns[i];
			if (oColumn.getSortProperty()) {
				mSettings.columns.push({
					name: oColumn.getLabel().getText(),
					template: {
						content: {
							path: oColumn.getSortProperty(),
							model: sModelName
						}
					}
				});
			}
		}
	}

	var oExport = new sap.ui.core.util.Export(mSettings);
	this.addDependent(oExport);

	return oExport;
};

/**
 * internal function to calculate the widest content width of the column 
 * also takes the column header and potential icons into account
 * @param {int} iColIndex index of the column which should be resized
 * @return {int} minWidth minimum width the column needs to have
 * @private
 * @experimental Experimental, only works with a limited control set
 * @function
 */

sap.ui.table.Table.prototype._calculateAutomaticColumnWidth = function(iColIndex) {
	
	var aTextBasedControls = [
		"sap.m.Text",
		"sap.m.Label",
		"sap.m.Link",
		"sap.ui.commons.TextView",
		"sap.ui.commons.Label",
		"sap.ui.commons.Link"
	]; 

	var $this = this.$();
	var iHeaderWidth = 0;

	var $cols = $this.find('td[headers=\"' + this.getId() + '_col' + iColIndex + '\"]').children("div");
	var oColumns = this.getColumns();
	var oCol = oColumns[iColIndex];
	var aHeaderSpan = oCol.getHeaderSpan(); 
	var oColLabel = oCol.getLabel();
	var that = this;
	
	var oColTemplate = oCol.getTemplate();
	var bIsTextBased = jQuery.inArray(oColTemplate.getMetadata().getName(), aTextBasedControls) != -1 ||
	                   sap.ui.commons && sap.ui.commons.TextField && oColTemplate instanceof sap.ui.commons.TextField ||
	                   sap.m && sap.m.Input && oColTemplate instanceof sap.m.Input;
	
	var hiddenSizeDetector = document.createElement("div");
	document.body.appendChild(hiddenSizeDetector);
	jQuery(hiddenSizeDetector).addClass("sapUiTableHiddenSizeDetector");

	var oColLabels = oCol.getMultiLabels();
	if(oColLabels.length == 0 && !!oColLabel){
		oColLabels = [oColLabel];
	}

	if (oColLabels.length > 0) {
		jQuery.each(oColLabels, function(iIdx, oLabel){
			var iWidth, iPaddings, iHeaderSpan;
			if(!!oLabel.getText()){
				jQuery(hiddenSizeDetector).text(oLabel.getText());
				iHeaderWidth = hiddenSizeDetector.scrollWidth;
			} else {
				iHeaderWidth = oLabel.$().scrollWidth;
			}
			iHeaderWidth = iHeaderWidth + $this.find("#"+oCol.getId() + "-icons").first().width();
			
			$this.find(".sapUiTableColIcons#" + oCol.getId() + "_" + iIdx + "-icons").first().width();
			if (aHeaderSpan instanceof Array && aHeaderSpan[iIdx] > 1){
				iHeaderSpan = aHeaderSpan[iIdx];
			} else if (aHeaderSpan > 1){
				iHeaderSpan = aHeaderSpan;
			}
			if(!!iHeaderSpan){
				// we have a header span, so we need to distribute the width of this header label over more than one column
				//get the width of the other columns and subtract from the minwidth required from label side
				var i = iHeaderSpan-1;
				while (i > iColIndex) {
					iHeaderWidth = iHeaderWidth - (that._oCalcColumnWidths[iColIndex+i] || 0);
					i -= 1;
				}
			}
		});
	}

	var minAddWidth = Math.max.apply(null, $cols.map(
		function(){
			var _$this = jQuery(this);
			return parseInt(_$this.css('padding-left')) + parseInt(_$this.css('padding-right'))
					+ parseInt(_$this.css('margin-left')) + parseInt(_$this.css('margin-right'));
		}).get());

	//get the max width of the currently displayed cells in this column
	var minWidth = Math.max.apply(null, $cols.children().map(
		function() {
			var width = 0,
			sWidth = 0;
			var _$this = jQuery(this);
			var sColText = _$this.text() || _$this.val();

			if (bIsTextBased){
				jQuery(hiddenSizeDetector).text(sColText);
				sWidth = hiddenSizeDetector.scrollWidth;
			} else {
				sWidth = this.scrollWidth;
			}
			if(iHeaderWidth > sWidth){
				sWidth = iHeaderWidth;
			}
			width = sWidth + parseInt(_$this.css('margin-left'))
									+ parseInt(_$this.css('margin-right'))
									+ minAddWidth
									+ 1; // ellipsis is still displayed if there is an equality of the div's width and the table column
			return width;
		}).get());

	jQuery(hiddenSizeDetector).remove();
	return (minWidth > this._iColMinWidth) ? minWidth : this._iColMinWidth;
};

sap.ui.table.Table.prototype._onPersoApplied = function() {

	// apply the sorter and filter again (right now only the first sorter is applied)
	var aColumns = this.getColumns();
	var aSorters = [];//, aFilters = [];
	for (var i = 0, l = aColumns.length; i < l; i++) {
		var oColumn = aColumns[i];
		if (oColumn.getSorted()) {
			aSorters.push(new sap.ui.model.Sorter(oColumn.getSortProperty(), oColumn.getSortOrder() === sap.ui.table.SortOrder.Descending));
		/*
		} else if (oColumn.getFiltered()) {
			aFilters.push(oColumn._getFilter());
		*/
		}
	}
	
	if (aSorters.length > 0 && this.getBinding("rows")) {
		this.getBinding("rows").sort(aSorters);
	}
	/*
	if (aFilters.length > 0 && this.getBinding("rows")) {
		this.getBinding("rows").filter(aFilters);
	}
	*/
	
	this.refreshRows();
	
};

}; // end of sap/ui/table/Table.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeTable') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.TreeTable.
jQuery.sap.declare("sap.ui.table.TreeTable");




/**
 * Constructor for a new TreeTable.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getExpandFirstLevel expandFirstLevel} : boolean (default: false)</li>
 * <li>{@link #getUseGroupMode useGroupMode} : boolean (default: false)</li>
 * <li>{@link #getGroupHeaderProperty groupHeaderProperty} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.table.TreeTable#event:toggleOpenState toggleOpenState} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.table.Table#constructor sap.ui.table.Table}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The TreeTable Control.
 * @extends sap.ui.table.Table
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.table.TreeTable
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.Table.extend("sap.ui.table.TreeTable", { metadata : {

	publicMethods : [
		// methods
		"expand", "collapse", "isExpanded"
	],
	library : "sap.ui.table",
	properties : {
		"expandFirstLevel" : {type : "boolean", group : "", defaultValue : false},
		"useGroupMode" : {type : "boolean", group : "Appearance", defaultValue : false},
		"groupHeaderProperty" : {type : "string", group : "Data", defaultValue : null}
	},
	events : {
		"toggleOpenState" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.table.TreeTable with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.TreeTable.extend
 * @function
 */

sap.ui.table.TreeTable.M_EVENTS = {'toggleOpenState':'toggleOpenState'};


/**
 * Getter for property <code>expandFirstLevel</code>.
 * Flag to enable or disable expanding of first level.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>expandFirstLevel</code>
 * @public
 * @name sap.ui.table.TreeTable#getExpandFirstLevel
 * @function
 */

/**
 * Setter for property <code>expandFirstLevel</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bExpandFirstLevel  new value for property <code>expandFirstLevel</code>
 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TreeTable#setExpandFirstLevel
 * @function
 */


/**
 * Getter for property <code>useGroupMode</code>.
 * If group mode is enable nodes with subitems are rendered as if they were group headers. This can be used to do the grouping for an OData service on the backend and visualize this in a table. This mode only makes sense if the tree has a depth of exacly 1 (group headers and entries)
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>useGroupMode</code>
 * @public
 * @name sap.ui.table.TreeTable#getUseGroupMode
 * @function
 */

/**
 * Setter for property <code>useGroupMode</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bUseGroupMode  new value for property <code>useGroupMode</code>
 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TreeTable#setUseGroupMode
 * @function
 */


/**
 * Getter for property <code>groupHeaderProperty</code>.
 * The property name of the rows data which will be displayed as a group header if the group mode is enabled
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>groupHeaderProperty</code>
 * @public
 * @name sap.ui.table.TreeTable#getGroupHeaderProperty
 * @function
 */

/**
 * Setter for property <code>groupHeaderProperty</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sGroupHeaderProperty  new value for property <code>groupHeaderProperty</code>
 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TreeTable#setGroupHeaderProperty
 * @function
 */


/**
 * fired when a node has been expanded or collapsed (only available in hierachical mode)
 *
 * @name sap.ui.table.TreeTable#toggleOpenState
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.rowIndex index of the expanded/collapsed row
 * @param {object} oControlEvent.getParameters.rowContext binding context of the selected row
 * @param {boolean} oControlEvent.getParameters.expanded flag whether the node has been expanded or collapsed
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'toggleOpenState' event of this <code>sap.ui.table.TreeTable</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.TreeTable</code>.<br/> itself. 
 *  
 * fired when a node has been expanded or collapsed (only available in hierachical mode)
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.TreeTable</code>.<br/> itself.
 *
 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TreeTable#attachToggleOpenState
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'toggleOpenState' event of this <code>sap.ui.table.TreeTable</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TreeTable#detachToggleOpenState
 * @function
 */

/**
 * Fire event toggleOpenState to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'rowIndex' of type <code>int</code> index of the expanded/collapsed row</li>
 * <li>'rowContext' of type <code>object</code> binding context of the selected row</li>
 * <li>'expanded' of type <code>boolean</code> flag whether the node has been expanded or collapsed</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.table.TreeTable#fireToggleOpenState
 * @function
 */


/**
 * expands the row for the given row index
 *
 * @name sap.ui.table.TreeTable#expand
 * @function
 * @param {int} iRowIndex
 *         index of the row to expand
 * @type sap.ui.table.TreeTable
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * collapses the row for the given row index
 *
 * @name sap.ui.table.TreeTable#collapse
 * @function
 * @param {int} iRowIndex
 *         index of the row to collapse
 * @type sap.ui.table.TreeTable
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * returns whether the row is expanded or collapsed
 *
 * @name sap.ui.table.TreeTable#isExpanded
 * @function
 * @param {int} iRowIndex
 *         index of the row to check
 * @type boolean
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\table\TreeTable.js
/**
 * Initialization of the TreeTable control
 * @private
 */
sap.ui.table.TreeTable.prototype.init = function() {
	sap.ui.table.Table.prototype.init.apply(this, arguments);
	this._iLastFixedColIndex = 0;
	
	// adopting properties and load icon fonts for bluecrystal
	if (sap.ui.getCore().getConfiguration().getTheme() === "sap_bluecrystal") {
	
		// add the icon fonts
		jQuery.sap.require("sap.ui.core.IconPool");
		sap.ui.core.IconPool.insertFontFaceStyle();
		
		// defaulting the rowHeight -> is set via CSS 
		
	}
	
};


/**
 * Setter for property <code>fixedRowCount</code>.
 *
 * <b>This property is not supportd for the TreeTable and will be ignored!</b>
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iFixedRowCount  new value for property <code>fixedRowCount</code>
 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.TreeTable#setFixedRowCount
 * @function
 */
sap.ui.table.TreeTable.prototype.setFixedRowCount = function(iRowCount) {
	// this property makes no sense for the TreeTable
	jQuery.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");
	return this;
};


/**
 * Rerendering handling
 * @private
 */
sap.ui.table.TreeTable.prototype.onAfterRendering = function() {
	sap.ui.table.Table.prototype.onAfterRendering.apply(this, arguments);
	this.$().find("[role=grid]").attr("role", "treegrid");
};

sap.ui.table.TreeTable.prototype.isTreeBinding = function(sName) {
	sName = sName || "rows";
	if (sName === "rows") {
		return true;
	}
	return sap.ui.core.Element.prototype.isTreeBinding.apply(this, sName);
};

sap.ui.table.TreeTable.prototype.getBinding = function(sName) {
	sName = sName || "rows";
	var oBinding = sap.ui.core.Element.prototype.getBinding.call(this, sName);
	// the check for the tree binding is only relevant becuase of the DataTable migration
	//  --> once the DataTable is deleted after the deprecation period this check can be deleted 
	if (oBinding && this.isTreeBinding(sName) && sName === "rows" && !oBinding.getLength) {
		// SIMULATE A LIST BINDING FOR THE TREE BINDING!
		//jQuery.sap.log.info("Enhancing Binding Object - Tree to List Binding");
		var that = this;
		jQuery.extend(oBinding, {
			_init: function(bExpandFirstLevel) {
				// load the root contexts and create the context info map
				this.mContextInfo = {};
				this._initContexts();
				// expand the first level if required
				if (bExpandFirstLevel) {
					var that = this;
					if (this.aContexts) {
						jQuery.each(this.aContexts.slice(), function(iIndex, oContext) {
							that._loadChildContexts(oContext);
							that._getContextInfo(oContext).bExpanded = true;
						});
					}
				}
			},
			_initContexts: function() {
				// load the root contexts and create the context info map entry (if missing)
				this.aContexts = this.getRootContexts();
				for (var i = 0, l = this.aContexts.length; i < l; i++) {
					var oldContextInfo = this._getContextInfo(this.aContexts[i]);
					this._setContextInfo({
						oContext: this.aContexts[i],
						iLevel: 0,
						bExpanded: oldContextInfo ? oldContextInfo.bExpanded : false
					});
				}
			},
			_fnFireFilter: oBinding._fireFilter,
			_fireFilter: function() {
				this._fnFireFilter.apply(this, arguments);
				this._initContexts();
				this._restoreContexts(this.aContexts);
			},
			_fnFireChange: oBinding._fireChange,
			_fireChange: function() {
				this._fnFireChange.apply(this, arguments);
				this._initContexts();
				this._restoreContexts(this.aContexts);
			},
			_restoreContexts: function(aContexts) {
				var that = this;
				var aNewChildContexts = [];
				jQuery.each(aContexts.slice(), function(iIndex, oContext) {
					var oContextInfo = that._getContextInfo(oContext);
					if (oContextInfo && oContextInfo.bExpanded) {
						aNewChildContexts.push.apply(aNewChildContexts, that._loadChildContexts(oContext));
					}
				});
				if (aNewChildContexts.length > 0) {
					this._restoreContexts(aNewChildContexts);
				}
			},
			_loadChildContexts: function(oContext) {
				var oContextInfo = this._getContextInfo(oContext);
				var iIndex = jQuery.inArray(oContext, this.aContexts);
				var aNodeContexts = this.getNodeContexts(oContext);
				for (var i = 0, l = aNodeContexts.length; i < l; i++) {
					this.aContexts.splice(iIndex + i + 1, 0, aNodeContexts[i]);
					var oldContextInfo = this._getContextInfo(aNodeContexts[i]);
					this._setContextInfo({
						oParentContext: oContext,
						oContext: aNodeContexts[i],
						iLevel: oContextInfo.iLevel + 1,
						bExpanded: oldContextInfo ? oldContextInfo.bExpanded : false
					});
				}
				return aNodeContexts;
			},
			_getContextInfo: function(oContext) {
				return oContext ? this.mContextInfo[oContext.getPath()] : undefined;
			},
			_setContextInfo: function(mData) {
				if (mData && mData.oContext) {
					this.mContextInfo[mData.oContext.getPath()] = mData;
				}
			},
			getLength: function() {
				return this.aContexts ? this.aContexts.length : 0;
			},
			getContexts: function(iStartIndex, iLength) {
				return this.aContexts.slice(iStartIndex, iStartIndex + iLength);
			},
			getLevel: function(oContext) {
				var oContextInfo = this._getContextInfo(oContext);
				return oContextInfo ? oContextInfo.iLevel : -1;
			},
			isExpanded: function(oContext) {
				var oContextInfo = this._getContextInfo(oContext);
				return oContextInfo ? oContextInfo.bExpanded : false;
			},
			expandContext: function(oContext) {
				var oContextInfo = this._getContextInfo(oContext);
				if (oContextInfo && !oContextInfo.bExpanded) {
					this.storeSelection();
					this._loadChildContexts(oContext);
					oContextInfo.bExpanded = true;
					this._fireChange();
					this.restoreSelection();
				}
			},
			collapseContext: function(oContext) {
				var oContextInfo = this._getContextInfo(oContext);
				if (oContextInfo && oContextInfo.bExpanded) {
					this.storeSelection();
					for (var i = this.aContexts.length - 1; i > 0; i--) {
						if (this._getContextInfo(this.aContexts[i]).oParentContext === oContext) {
							this.aContexts.splice(i, 1);
						}
					}
					oContextInfo.bExpanded = false;
					this._fireChange();
					this.restoreSelection();
				}
			},
			toggleContext: function(oContext) {
				var oContextInfo = this._getContextInfo(oContext);
				if (oContextInfo) {
					if (oContextInfo.bExpanded) {
						this.collapseContext(oContext);
					} else {
						this.expandContext(oContext);
					}
				}
			},
			storeSelection: function() {
				var aSelectedIndices = that.getSelectedIndices();
				var aSelectedContexts = [];
				jQuery.each(aSelectedIndices, function(iIndex, iValue) {
					aSelectedContexts.push(that.getContextByIndex(iValue));
				});
				this._aSelectedContexts = aSelectedContexts;
			},
			restoreSelection: function() {
				that.clearSelection();
				var _aSelectedContexts = this._aSelectedContexts;
				jQuery.each(this.aContexts, function(iIndex, oContext) {
					if (jQuery.inArray(oContext, _aSelectedContexts) >= 0) {
						that.addSelectionInterval(iIndex, iIndex);
					}
				});
				this._aSelectedContexts = undefined;
			},
			attachSort: function() {},
			detachSort: function() {}
		});
		// initialize the binding
		oBinding._init(this.getExpandFirstLevel());
	}
	return oBinding;
};

sap.ui.table.TreeTable.prototype._updateTableContent = function() {
	sap.ui.table.Table.prototype._updateTableContent.apply(this, arguments);

	if (!this.getUseGroupMode()) {
		return;
	}
	
	//If group mode is enabled nodes which have children are visualized as if they were group header
	var oBinding = this.getBinding("rows"),
		iFirstRow = this.getFirstVisibleRow(),
		iCount = this.getVisibleRowCount();

	for (var iRow = 0; iRow < iCount; iRow++) {
		var oContext = this.getContextByIndex(iFirstRow + iRow),
			$row = this.getRows()[iRow].$(),
			$rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");

		if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
			// modify the rows
			$row.addClass("sapUiTableGroupHeader sapUiTableRowHidden");
			var sClass = oBinding.isExpanded(oContext) ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
			$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\">" + this.getModel().getProperty(this.getGroupHeaderProperty(), oContext) + "</div>");
			$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
		} else {
			$row.removeClass("sapUiTableGroupHeader");
			if (oContext) {
				$row.removeClass("sapUiTableRowHidden");
			}
			$rowHdr.html("");
			$rowHdr.removeClass("sapUiTableGroupHeader");
		}
	}
};

sap.ui.table.TreeTable.prototype._updateTableCell = function(oCell, oContext, oTD) {

	var oBinding = this.getBinding("rows");
	
	if (oBinding) {
		var iLevel = oBinding.getLevel ? oBinding.getLevel(oContext) : 0;
		var $row;
		// in case of fixed columns we need to lookup the fixed table 
		// otherwise the expand/collapse/margin will not be set!
		if (this.getFixedColumnCount() > 0) {
			$row = oCell.getParent().$("fixed");
		} else {
			$row = oCell.getParent().$();
		}
		var $TreeIcon = $row.find(".sapUiTableTreeIcon");
		var sTreeIconClass = "sapUiTableTreeIconLeaf";
		if (!this.getUseGroupMode()) {
			$TreeIcon.css("marginLeft", iLevel * 17);
		}
		if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
			sTreeIconClass = oBinding.isExpanded(oContext) ? "sapUiTableTreeIconNodeOpen" : "sapUiTableTreeIconNodeClosed";
			$row.attr('aria-expanded', oBinding.isExpanded(oContext));
			var sNodeText = oBinding.isExpanded(oContext) ? this._oResBundle.getText("TBL_COLLAPSE") : this._oResBundle.getText("TBL_EXPAND");
			$TreeIcon.attr('title', sNodeText);
		} else {
			$row.attr('aria-expanded', false);
			$TreeIcon.attr('title', this._oResBundle.getText("TBL_LEAF"));
		}
		$TreeIcon.removeClass("sapUiTableTreeIconLeaf sapUiTableTreeIconNodeOpen sapUiTableTreeIconNodeClosed").addClass(sTreeIconClass);
		$row.attr("data-sap-ui-level", iLevel);
		$row.attr('aria-level', iLevel + 1);
	}
	
};

sap.ui.table.TreeTable.prototype.onclick = function(oEvent) {
	if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
		this._onGroupSelect(oEvent);
	} else if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
		this._onNodeSelect(oEvent);
	} else {
		if (sap.ui.table.Table.prototype.onclick) {
			sap.ui.table.Table.prototype.onclick.apply(this, arguments);
		}
	}
};

sap.ui.table.TreeTable.prototype.onsapselect = function(oEvent) {
	if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
		this._onNodeSelect(oEvent);
	} else {
		if (sap.ui.table.Table.prototype.onsapselect) {
			sap.ui.table.Table.prototype.onsapselect.apply(this, arguments);
		}
	}
};

sap.ui.table.TreeTable.prototype.onkeydown = function(oEvent) {
	sap.ui.table.Table.prototype.onkeydown.apply(this, arguments);
	var $Target = jQuery(oEvent.target),
		$TargetTD = $Target.closest('td');
	if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode && $TargetTD.find('.sapUiTableTreeIcon').length > 0) {
		//If node icon has focus set tab to control else set tab to node icon
		if ($Target.hasClass('sapUiTableTreeIcon')) {
			if (!$Target.hasClass("sapUiTableTreeIconLeaf")) {
				$TargetTD.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();
			}
		} else {
			$TargetTD.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();
		}
		oEvent.preventDefault();
	}
};

sap.ui.table.TreeTable.prototype._onNodeSelect = function(oEvent) {

	var $parent = jQuery(oEvent.target).parents("tr");
	if ($parent.length > 0) {
		var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
		var oContext = this.getContextByIndex(iRowIndex);
		this.fireToggleOpenState({
			rowIndex: iRowIndex,
			rowContext: oContext,
			expanded: !this.getBinding().isExpanded(oContext)
		});
		this.getBinding("rows").toggleContext(oContext);
	}

	oEvent.preventDefault();
	oEvent.stopPropagation();

};

sap.ui.table.TreeTable.prototype._onGroupSelect = function(oEvent) {

	var $parent = jQuery(oEvent.target).parents("[data-sap-ui-rowindex]");
	if ($parent.length > 0) {
		var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
		var oContext = this.getContextByIndex(iRowIndex);
		if (this.getBinding().isExpanded(oContext)) {
			jQuery(oEvent.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");
		} else {
			jQuery(oEvent.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");
		}
		this.fireToggleOpenState({
			rowIndex: iRowIndex,
			rowContext: oContext,
			expanded: !this.getBinding().isExpanded(oContext)
		});
		this.getBinding("rows").toggleContext(oContext);
	}

	oEvent.preventDefault();
	oEvent.stopPropagation();

};

sap.ui.table.TreeTable.prototype.expand = function(iRowIndex) {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var oContext = this.getContextByIndex(iRowIndex);
		oBinding.expandContext(oContext);
	}
};

sap.ui.table.TreeTable.prototype.collapse = function(iRowIndex) {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var oContext = this.getContextByIndex(iRowIndex);
		oBinding.collapseContext(oContext);
	}
};

sap.ui.table.TreeTable.prototype.isExpanded = function(iRowIndex) {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var oContext = this.getContextByIndex(iRowIndex);
		return oBinding.isExpanded(oContext);
	}
	return false;
};

sap.ui.table.TreeTable.prototype._enterActionMode = function($Tabbable) {
	var $domRef = $Tabbable.eq(0);
	
	sap.ui.table.Table.prototype._enterActionMode.apply(this, arguments);
	if ($Tabbable.length > 0 && $domRef.hasClass("sapUiTableTreeIcon") && !$domRef.hasClass("sapUiTableTreeIconLeaf")) {
		//Set tabindex to 0 to have make node icon accessible
		$domRef.attr("tabindex", 0).focus();
		//set action mode to true so that _leaveActionMode is called to remove the tabindex again
		this._bActionMode = true;
	}
};

sap.ui.table.TreeTable.prototype._leaveActionMode = function(oEvent) {
	sap.ui.table.Table.prototype._leaveActionMode.apply(this, arguments);
	this.$().find(".sapUiTableTreeIcon").attr("tabindex", -1);
};


}; // end of sap/ui/table/TreeTable.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumn') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.AnalyticalColumn.
jQuery.sap.declare("sap.ui.table.AnalyticalColumn");




/**
 * Constructor for a new AnalyticalColumn.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getLeadingProperty leadingProperty} : string</li>
 * <li>{@link #getSummed summed} : boolean (default: false)</li>
 * <li>{@link #getInResult inResult} : boolean (default: false)</li>
 * <li>{@link #getShowIfGrouped showIfGrouped} : boolean (default: false)</li>
 * <li>{@link #getGroupHeaderFormatter groupHeaderFormatter} : any</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.table.Column#constructor sap.ui.table.Column}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * This column addes additional properties to the tabl ecolumn which are needed for the analytical binding and table
 * @extends sap.ui.table.Column
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @experimental Since version 1.21. 
 * The AnalyticalColumn will be productized soon. Some attributes will be added to Column.
 * @name sap.ui.table.AnalyticalColumn
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.Column.extend("sap.ui.table.AnalyticalColumn", { metadata : {

	library : "sap.ui.table",
	properties : {
		"leadingProperty" : {type : "string", group : "Misc", defaultValue : null},
		"summed" : {type : "boolean", group : "Misc", defaultValue : false},
		"inResult" : {type : "boolean", group : "Misc", defaultValue : false},
		"showIfGrouped" : {type : "boolean", group : "Appearance", defaultValue : false},
		"groupHeaderFormatter" : {type : "any", group : "Behavior", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.ui.table.AnalyticalColumn with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.AnalyticalColumn.extend
 * @function
 */


/**
 * Getter for property <code>leadingProperty</code>.
 * Defines the primary model property which is used inside the Column. In case of the analytical extension this means the property which is grouped by for dimensions or the property which is summed for measures.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>leadingProperty</code>
 * @public
 * @name sap.ui.table.AnalyticalColumn#getLeadingProperty
 * @function
 */

/**
 * Setter for property <code>leadingProperty</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sLeadingProperty  new value for property <code>leadingProperty</code>
 * @return {sap.ui.table.AnalyticalColumn} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalColumn#setLeadingProperty
 * @function
 */


/**
 * Getter for property <code>summed</code>.
 * If defined a sum for this column is calculated
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>summed</code>
 * @public
 * @name sap.ui.table.AnalyticalColumn#getSummed
 * @function
 */

/**
 * Setter for property <code>summed</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSummed  new value for property <code>summed</code>
 * @return {sap.ui.table.AnalyticalColumn} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalColumn#setSummed
 * @function
 */


/**
 * Getter for property <code>inResult</code>.
 * Specifies that the dimension referred to by the column shall be included in the granularity of the data result. It allows a finer distinction between a visible/grouped/(included)inResult column.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>inResult</code>
 * @public
 * @name sap.ui.table.AnalyticalColumn#getInResult
 * @function
 */

/**
 * Setter for property <code>inResult</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bInResult  new value for property <code>inResult</code>
 * @return {sap.ui.table.AnalyticalColumn} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalColumn#setInResult
 * @function
 */


/**
 * Getter for property <code>showIfGrouped</code>.
 * Specifies whether the column is displayed within the table even if it is grouped or not. A grouped column has the same value for every rows within the group.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showIfGrouped</code>
 * @public
 * @name sap.ui.table.AnalyticalColumn#getShowIfGrouped
 * @function
 */

/**
 * Setter for property <code>showIfGrouped</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowIfGrouped  new value for property <code>showIfGrouped</code>
 * @return {sap.ui.table.AnalyticalColumn} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalColumn#setShowIfGrouped
 * @function
 */


/**
 * Getter for property <code>groupHeaderFormatter</code>.
 * If the column is grouped, this formatter is used to format the value in the group header
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {any} the value of property <code>groupHeaderFormatter</code>
 * @public
 * @name sap.ui.table.AnalyticalColumn#getGroupHeaderFormatter
 * @function
 */

/**
 * Setter for property <code>groupHeaderFormatter</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {any} oGroupHeaderFormatter  new value for property <code>groupHeaderFormatter</code>
 * @return {sap.ui.table.AnalyticalColumn} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalColumn#setGroupHeaderFormatter
 * @function
 */


// Start of sap\ui\table\AnalyticalColumn.js
sap.ui.table.AnalyticalColumn.prototype.init = function() {
	sap.ui.table.Column.prototype.init.apply(this, arguments);
	this._bSkipUpdateAI = false;
};

/**
 * map of filtertypes for re-use in getFilterType
 * @private
 */
sap.ui.table.AnalyticalColumn._DEFAULT_FILTERTYPES = {
	"Time": new sap.ui.model.type.Time({UTC: true}),
	"DateTime": new sap.ui.model.type.DateTime({UTC: true}),
	"Float": new sap.ui.model.type.Float(),
	"Integer": new sap.ui.model.type.Integer(),
	"Boolean": new sap.ui.model.type.Boolean()
};

/*
 * Factory method. Creates the column menu.
 * 
 * @return {sap.ui.table.AnalyticalColumnMenu} The created column menu.
 */
sap.ui.table.AnalyticalColumn.prototype._createMenu = function() {
	jQuery.sap.require("sap.ui.table.AnalyticalColumnMenu");
	return new sap.ui.table.AnalyticalColumnMenu(this.getId() + "-menu");
};

sap.ui.table.AnalyticalColumn.prototype.setGrouped = function(bGrouped) {
	var oParent = this.getParent();
	var that = this;
	if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
		if (bGrouped) {
			oParent._addGroupedColumn(this.getId());
		} else {
			oParent._aGroupedColumns = jQuery.grep(oParent._aGroupedColumns, function(value) {
				return value != that.getId();
			});
		}
	}
	var bReturn = this.setProperty("grouped", bGrouped);
	this._updateTableColumnDetails();
	this._updateTableAnalyticalInfo(true);
	return bReturn;
};

sap.ui.table.AnalyticalColumn.prototype.setSummed = function(bSummed) {
	var bReturn = this.setProperty("summed", bSummed, true);
	this._updateTableAnalyticalInfo();
	return bReturn;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.AnalyticalColumn.prototype.setVisible = function(bVisible) {
	sap.ui.table.Column.prototype.setVisible.apply(this, arguments);
	this._updateTableColumnDetails();
	this._updateTableAnalyticalInfo();
	return this;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.AnalyticalColumn.prototype.getLabel = function() {
	var oLabel = this.getAggregation("label");
	if (!oLabel) {
		if (!this._oBindingLabel) {
			var oParent = this.getParent();
			if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
				var oBinding = oParent.getBinding("rows");
				if (oBinding) {
					this._oBindingLabel = sap.ui.table.TableHelper.createLabel({text: oBinding.getPropertyLabel(this.getLeadingProperty())});
				}
			}
		}
		oLabel = this._oBindingLabel;
	}
	return oLabel;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.AnalyticalColumn.prototype.getFilterProperty = function() {
	var sProperty = this.getProperty("filterProperty");
	if (!sProperty) {
		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			var oBinding = oParent.getBinding("rows");
			var sLeadingProperty = this.getLeadingProperty();
			if (oBinding && jQuery.inArray(sLeadingProperty, oBinding.getFilterablePropertyNames()) > -1) {
				sProperty = sLeadingProperty;
			}
		}
	}
	return sProperty;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.AnalyticalColumn.prototype.getSortProperty = function() {
	var sProperty = this.getProperty("sortProperty");
	if (!sProperty) {
		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			var oBinding = oParent.getBinding("rows");
			var sLeadingProperty = this.getLeadingProperty();
			if (oBinding && jQuery.inArray(sLeadingProperty, oBinding.getSortablePropertyNames()) > -1) {
				sProperty = sLeadingProperty;
			}
		}
	}
	return sProperty;
};

/*
 * @see JSDoc generated by SAPUI5 control API generator
 */
sap.ui.table.AnalyticalColumn.prototype.getFilterType = function() {
	var vFilterType = this.getProperty("filterType");
	if (!vFilterType) {
		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			var oBinding = oParent.getBinding("rows");
			var sLeadingProperty = this.getLeadingProperty(),
			    oProperty = oBinding && oBinding.getProperty(sLeadingProperty);
			if (oProperty) {
				var sType = undefined;
				switch (oProperty.type) {
					case "Edm.Time":
						vFilterType = sap.ui.table.AnalyticalColumn._DEFAULT_FILTERTYPES["Time"];
						break;
					case "Edm.DateTime":
					case "Edm.DateTimeOffset":
						vFilterType = sap.ui.table.AnalyticalColumn._DEFAULT_FILTERTYPES["DateTime"]
						break;
					case "Edm.Single":
					case "Edm.Double":
					case "Edm.Decimal":
						vFilterType = sap.ui.table.AnalyticalColumn._DEFAULT_FILTERTYPES["Float"]
						break;
					case "Edm.SByte":
					case "Edm.Int16":
					case "Edm.Int32":
					case "Edm.Int64":
						vFilterType = sap.ui.table.AnalyticalColumn._DEFAULT_FILTERTYPES["Integer"]
						break;
					case "Edm.Boolean":
						vFilterType = sap.ui.table.AnalyticalColumn._DEFAULT_FILTERTYPES["Boolean"]
						break;
				}
			}
		}
	}
	return vFilterType;
};

sap.ui.table.AnalyticalColumn.prototype._afterSort = function() {
	this._updateTableAnalyticalInfo();
};

sap.ui.table.AnalyticalColumn.prototype._updateTableAnalyticalInfo = function(bSupressRefresh) {
	if (this._bSkipUpdateAI) {
		return;
	}

	var oParent = this.getParent();
	if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
		oParent.updateAnalyticalInfo(bSupressRefresh);
	}
};

sap.ui.table.AnalyticalColumn.prototype._updateTableColumnDetails = function() {
	if (this._bSkipUpdateAI) {
		return;
	}

	var oParent = this.getParent();
	if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
		oParent._updateTableColumnDetails();
	}
};

sap.ui.table.AnalyticalColumn.prototype.shouldRender = function() {
	if (!this.getVisible()) {
		return false;
	}
	return (!this.getGrouped() || this._bLastGroupAndGrouped || this.getShowIfGrouped()) && (!this._bDependendGrouped || this._bLastGroupAndGrouped);
};

sap.ui.table.AnalyticalColumn.prototype.getTooltip_AsString = function() {
	var oParent = this.getParent();
	if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
		var oBinding = oParent.getBinding("rows");
		if (oBinding && this.getLeadingProperty()) {
			return oBinding.getPropertyQuickInfo(this.getLeadingProperty());
		}
	}
	return sap.ui.core.Element.prototype.getTooltip_AsString.apply(this);
};

}; // end of sap/ui/table/AnalyticalColumn.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenu') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.AnalyticalColumnMenu.
jQuery.sap.declare("sap.ui.table.AnalyticalColumnMenu");




/**
 * Constructor for a new AnalyticalColumnMenu.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.table.ColumnMenu#constructor sap.ui.table.ColumnMenu}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A column menu which is used by the analytical column
 * @extends sap.ui.table.ColumnMenu
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @experimental Since version 1.21. 
 * The AnalyticalColumnMenu will be productized soon.
 * @name sap.ui.table.AnalyticalColumnMenu
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.ColumnMenu.extend("sap.ui.table.AnalyticalColumnMenu", { metadata : {

	library : "sap.ui.table"
}});


/**
 * Creates a new subclass of class sap.ui.table.AnalyticalColumnMenu with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.AnalyticalColumnMenu.extend
 * @function
 */


// Start of sap\ui\table\AnalyticalColumnMenu.js
sap.ui.table.AnalyticalColumnMenu.prototype.init = function() {
	sap.ui.table.ColumnMenu.prototype.init.apply(this);
};

/**
 * Adds the menu items to the menu.
 * @private
 */
sap.ui.table.AnalyticalColumnMenu.prototype._addMenuItems = function() {
	sap.ui.table.ColumnMenu.prototype._addMenuItems.apply(this);
	if (this._oColumn) {
		this._addSumMenuItem();
	}
};

/**
 * Adds the group menu item to the menu.
 * @private
 */
sap.ui.table.AnalyticalColumnMenu.prototype._addGroupMenuItem = function() {
	var oColumn = this._oColumn,
		oTable = this._oTable,
		oBinding = oTable.getBinding("rows"),
		oResultSet = oBinding && oBinding.getAnalyticalQueryResult();

	if (oTable && oResultSet && oResultSet.findDimensionByPropertyName(oColumn.getLeadingProperty()) 
			&& jQuery.inArray(oColumn.getLeadingProperty(), oBinding.getSortablePropertyNames()) > -1
			&& jQuery.inArray(oColumn.getLeadingProperty(), oBinding.getFilterablePropertyNames()) > -1) {
		this._oGroupIcon = this._createMenuItem(
			"group",
			"TBL_GROUP",
			oColumn.getGrouped() ? "accept" : null,
			jQuery.proxy(function(oEvent) {
				var oMenuItem = oEvent.getSource(),
					bGrouped = oColumn.getGrouped();

				oColumn.setGrouped(!bGrouped);
				oMenuItem.setIcon(!bGrouped ? "sap-icon://accept" : null);
			}, this)
		);
		this.addItem(this._oGroupIcon);
	}
};

/**
 * Adds the group menu item to the menu.
 * @private
 */
sap.ui.table.AnalyticalColumnMenu.prototype._addSumMenuItem = function() {
	var oColumn = this._oColumn,
		oTable = this._oTable,
		oBinding = oTable.getBinding("rows"),
		oResultSet = oBinding && oBinding.getAnalyticalQueryResult();
	
	if (oTable && oResultSet && oResultSet.findMeasureByPropertyName(oColumn.getLeadingProperty())) {
		this._oSumItem = this._createMenuItem(
			"total",
			"TBL_TOTAL",
			oColumn.getSummed() ? "accept" : null,
			jQuery.proxy(function(oEvent) {
				var oMenuItem = oEvent.getSource(),
					bSummed = oColumn.getSummed();

				oColumn.setSummed(!bSummed);
				oMenuItem.setIcon(!bSummed ? "sap-icon://accept" : null);
			}, this)
		);
		this.addItem(this._oSumItem);
	}
};


sap.ui.table.AnalyticalColumnMenu.prototype.open = function() {
	sap.ui.table.ColumnMenu.prototype.open.apply(this, arguments);
	
	var oColumn = this._oColumn;
	this._oSumItem && this._oSumItem.setIcon(oColumn.getSummed() ? "sap-icon://accept" : null);
	this._oGroupIcon && this._oGroupIcon.setIcon(oColumn.getGrouped() ? "sap-icon://accept" : null);
	this._oGroupIcon && this._oGroupIcon.setVisible(!oColumn._isLastGroupableLeft);
};
}; // end of sap/ui/table/AnalyticalColumnMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalTable') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.AnalyticalTable.
jQuery.sap.declare("sap.ui.table.AnalyticalTable");




/**
 * Constructor for a new AnalyticalTable.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getSumOnTop sumOnTop} : boolean (default: false)</li>
 * <li>{@link #getNumberOfExpandedLevels numberOfExpandedLevels} : int (default: 0)</li>
 * <li>{@link #getColumnVisibilityMenuSorter columnVisibilityMenuSorter} : any</li>
 * <li>{@link #getDirty dirty} : boolean</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.table.Table#constructor sap.ui.table.Table}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Table which handles analytical OData backends
 * @extends sap.ui.table.Table
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @experimental Since version 1.21. 
 * The AnalyticalTable will be productized soon.
 * @name sap.ui.table.AnalyticalTable
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.Table.extend("sap.ui.table.AnalyticalTable", { metadata : {

	publicMethods : [
		// methods
		"getTotalSize"
	],
	library : "sap.ui.table",
	properties : {
		"sumOnTop" : {type : "boolean", group : "Appearance", defaultValue : false},
		"numberOfExpandedLevels" : {type : "int", group : "Misc", defaultValue : 0},
		"columnVisibilityMenuSorter" : {type : "any", group : "Appearance", defaultValue : null},
		"dirty" : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true}
	}
}});


/**
 * Creates a new subclass of class sap.ui.table.AnalyticalTable with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.AnalyticalTable.extend
 * @function
 */


/**
 * Getter for property <code>sumOnTop</code>.
 * Specifies if the total values should be displayed in the group headers or on bottom of the row. Does not affact the total sum.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>sumOnTop</code>
 * @public
 * @name sap.ui.table.AnalyticalTable#getSumOnTop
 * @function
 */

/**
 * Setter for property <code>sumOnTop</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSumOnTop  new value for property <code>sumOnTop</code>
 * @return {sap.ui.table.AnalyticalTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalTable#setSumOnTop
 * @function
 */


/**
 * Getter for property <code>numberOfExpandedLevels</code>.
 * Number of levels, which should be opened initially (on first load of data).
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>numberOfExpandedLevels</code>
 * @public
 * @name sap.ui.table.AnalyticalTable#getNumberOfExpandedLevels
 * @function
 */

/**
 * Setter for property <code>numberOfExpandedLevels</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iNumberOfExpandedLevels  new value for property <code>numberOfExpandedLevels</code>
 * @return {sap.ui.table.AnalyticalTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalTable#setNumberOfExpandedLevels
 * @function
 */


/**
 * Getter for property <code>columnVisibilityMenuSorter</code>.
 * Functions which is used to sort the column visibility menu entries e.g.: function(ColumnA, ColumnB) { return 0 = equals, <0 lower, >0 greater }; Other values than functions will be ignored.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {any} the value of property <code>columnVisibilityMenuSorter</code>
 * @public
 * @name sap.ui.table.AnalyticalTable#getColumnVisibilityMenuSorter
 * @function
 */

/**
 * Setter for property <code>columnVisibilityMenuSorter</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {any} oColumnVisibilityMenuSorter  new value for property <code>columnVisibilityMenuSorter</code>
 * @return {sap.ui.table.AnalyticalTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.AnalyticalTable#setColumnVisibilityMenuSorter
 * @function
 */


/**
 * Getter for property <code>dirty</code>.
 * If dirty the content of the Table will be overlayed.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>dirty</code>
 * @public
 * @deprecated Since version 1.21.2. 
 * Please use setShowOverlay instead.
 * @name sap.ui.table.AnalyticalTable#getDirty
 * @function
 */

/**
 * Setter for property <code>dirty</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bDirty  new value for property <code>dirty</code>
 * @return {sap.ui.table.AnalyticalTable} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.21.2. 
 * Please use setShowOverlay instead.
 * @name sap.ui.table.AnalyticalTable#setDirty
 * @function
 */


/**
 * Returns the total size of the data entries.
 *
 * @name sap.ui.table.AnalyticalTable#getTotalSize
 * @function
 * @type int
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\table\AnalyticalTable.js
// =====================================================================
// WE START WITH A COPY OF THE TREETABLE AND REFACTOR THE CODING!
// =====================================================================

jQuery.sap.require('sap.ui.model.analytics.TreeBindingAdapter'); // unlisted dependency retained



/**
 * Initialization of the AnalyticalTable control
 * @private
 */
sap.ui.table.AnalyticalTable.prototype.init = function() {
	sap.ui.table.Table.prototype.init.apply(this, arguments);
	
	this.addStyleClass("sapUiAnalyticalTable");
	
	this.attachBrowserEvent("contextmenu", this._onContextMenu);
	
	// defaulting properties
	this.setSelectionMode(sap.ui.table.SelectionMode.MultiToggle);
	this.setShowColumnVisibilityMenu(true);
	this.setEnableColumnFreeze(true);
	this.setEnableCellFilter(true);
	this._aGroupedColumns = [];
	
	// adopting properties and load icon fonts for bluecrystal
	if (sap.ui.getCore().getConfiguration().getTheme() === "sap_bluecrystal") {
	
		// add the icon fonts
		jQuery.sap.require("sap.ui.core.IconPool");
		sap.ui.core.IconPool.insertFontFaceStyle();
		
		// defaulting the rowHeight -> is set via CSS 
		
	}
	

	this._bBindingAttachedListener = false;
	
};

sap.ui.table.AnalyticalTable.prototype.setFixedRowCount = function() {
	jQuery.sap.log.error("The property fixedRowCount is not supported by the AnalyticalTable and must not be set!");
	return this;
};

sap.ui.table.AnalyticalTable.prototype.setFixedBottomRowCount = function() {
	jQuery.sap.log.error("The property fixedBottomRowCount is managed by the AnalyticalTable and must not be set!");
	return this;
};

/**
 * Rerendering handling
 * @private
 */
sap.ui.table.AnalyticalTable.prototype.onAfterRendering = function() {
	sap.ui.table.Table.prototype.onAfterRendering.apply(this, arguments);
	this.$().find("[role=grid]").attr("role", "treegrid");
};

sap.ui.table.AnalyticalTable.prototype.setDirty = function(bDirty) {
	jQuery.sap.log.error("The property \"dirty\" is deprecated. Please use \"showOverlay\".");
	this.setProperty("dirty", bDirty, true);
	this.setShowOverlay(this.getDirty());
	return this;
};

sap.ui.table.AnalyticalTable.prototype.getModel = function(oModel, sName) {
	var oModel = sap.ui.table.Table.prototype.getModel.apply(this, arguments);
	if (oModel && sap.ui.model.odata && oModel instanceof sap.ui.model.odata.ODataModel) {
		jQuery.sap.require("sap.ui.model.analytics.ODataModelAdapter");
		sap.ui.model.analytics.ODataModelAdapter.apply(oModel);
	}
	return oModel;
};

sap.ui.table.AnalyticalTable.prototype._bindAggregation = function(sName, sPath, oTemplate, oSorter, aFilters) {
	if (sName === "rows") {
		// make sure to reset the first visible row (currently needed for the analytical binding)
		// TODO: think about a boundary check to reset the firstvisiblerow if out of bounds
		this.setProperty("firstVisibleRow", 0, true);
	}
	return sap.ui.table.Table.prototype._bindAggregation.apply(this, arguments);
};

/**
 * handler for change events of the binding
 * @param {sap.ui.base.Event} oEvent change event
 * @private
 */
sap.ui.table.AnalyticalTable.prototype._onBindingChange = function(oEvent) {
	sap.ui.table.Table.prototype._onBindingChange.apply(this, arguments);
	// the column menus have to be invalidated when the amount
	// of data changes in the Table; this happens on normal changes
	// of the Table as well as when filtering  
	var sReason = typeof(oEvent) === "object" ? oEvent.getParameter("reason") : oEvent;
	if (sReason !== "sort") {
		this._invalidateColumnMenus(); 
	}
};

sap.ui.table.AnalyticalTable.prototype.bindRows = function(oBindingInfo) {
	var sPath,
		oTemplate,
		aSorters,
		aFilters;
	
	// Old API compatibility (sName, sPath, oTemplate, oSorter, aFilters)
	if (typeof oBindingInfo == "string") {
		sPath = arguments[0];
		oTemplate = arguments[1];
		aSorters = arguments[2];
		aFilters = arguments[3];
		oBindingInfo = {path: sPath, sorter: aSorters, filters: aFilters};
		// allow either to pass the template or the factory function as 3rd parameter
		if (oTemplate instanceof sap.ui.base.ManagedObject) {
			oBindingInfo.template = oTemplate;
		} else if (typeof oTemplate === "function") {
			oBindingInfo.factory = oTemplate;
		}
	}
	
	// extract the sorters from the columns (TODO: reconsider this!)
	var aColumns = this.getColumns();
	for (var i = 0, l = aColumns.length; i < l; i++) {
		if (aColumns[i].getSorted()) {
			oBindingInfo.sorter = oBindingInfo.sorter || [];
			oBindingInfo.sorter.push(new sap.ui.model.Sorter(aColumns[i].getSortProperty() || aColumns[i].getLeadingProperty(), aColumns[i].getSortOrder() === sap.ui.table.SortOrder.Descending));
		}
	}
	
	oBindingInfo.parameters = oBindingInfo.parameters || {};
	oBindingInfo.parameters.analyticalInfo = this._getColumnInformation();
	oBindingInfo.parameters.sumOnTop = this.getSumOnTop();
	oBindingInfo.parameters.numberOfExpandedLevels = this.getNumberOfExpandedLevels();
	
	var vReturn = this.bindAggregation("rows", oBindingInfo);
	this._bSupressRefresh = true;
	this._updateColumns();
	this._bSupressRefresh = false;
	
	this._bBindingAttachedListener = false;
	
	return vReturn;
};

sap.ui.table.AnalyticalTable.prototype.updateRows = function(sReason) {
	this._attachBindingListener();
	sap.ui.table.Table.prototype.updateRows.apply(this, arguments);
};

sap.ui.table.AnalyticalTable.prototype.refreshRows = function(sReason) {
	this._attachBindingListener();
	sap.ui.table.Table.prototype.refreshRows.apply(this, arguments);
};

sap.ui.table.AnalyticalTable.prototype._attachBindingListener = function() {
	if (!this._bBindingAttachedListener) {
		this._bBindingAttachedListener = true;
		
		var oBinding = this.getBinding("rows");
		var that = this;
		if (oBinding) {
			oBinding.attachContextChange(function(oEvent) {
				if (!that._oSelection) {
					return;
				}
				var oParameters = oEvent.getParameters(),
					sType = oParameters.type,
					iIndex = oParameters.index,
					iLength = oParameters.length;
				
				if (sType === "remove") {
					that._oSelection.sliceSelectionInterval(iIndex, Math.max(iIndex, iIndex + iLength - 1));
				} else {
					that._oSelection.moveSelectionInterval(iIndex, iLength);
				}
			});
		}
	}
};

sap.ui.table.AnalyticalTable.prototype._getColumnInformation = function() {
	var aColumns = [],
		aTableColumns = this.getColumns();
	
	for (var i = 0; i < this._aGroupedColumns.length; i++) {
		var oColumn = sap.ui.getCore().byId(this._aGroupedColumns[i]);
		
		if (!oColumn) continue;
		
		aColumns.push({
			name: oColumn.getLeadingProperty(),
			visible: oColumn.getVisible(),
			grouped: oColumn.getGrouped(),
			total: oColumn.getSummed(),
			sorted: oColumn.getSorted(),
			sortOrder: oColumn.getSortOrder(),
			inResult: oColumn.getInResult(),
			formatter: oColumn.getGroupHeaderFormatter()
		});
	}
	
	for (var i = 0; i < aTableColumns.length; i++) {
		var oColumn = aTableColumns[i];
		
		if (jQuery.inArray(oColumn.getId(), this._aGroupedColumns) > -1) {
			continue;
		}
		if (!oColumn instanceof sap.ui.table.AnalyticalColumn) {
			jQuery.sap.log.error("You have to use AnalyticalColumns for the Analytical table");
		}
		
		aColumns.push({
			name: oColumn.getLeadingProperty(),
			visible: oColumn.getVisible(),
			grouped: oColumn.getGrouped(),
			total: oColumn.getSummed(),
			sorted: oColumn.getSorted(),
			sortOrder: oColumn.getSortOrder(),
			inResult: oColumn.getInResult(),
			formatter: oColumn.getGroupHeaderFormatter()
		});
	}
	
	return aColumns;
};

sap.ui.table.AnalyticalTable.prototype._updateTableContent = function() {
	sap.ui.table.Table.prototype._updateTableContent.apply(this, arguments);
	
	var oBinding = this.getBinding("rows"),
		iFirstRow = this.getFirstVisibleRow(),
		iFixedBottomRowCount = this.getFixedBottomRowCount(),
		iCount = this.getVisibleRowCount(),
		aCols = this.getColumns();
	
	if (!oBinding) {
		return;
	}
	
	var iFirstMeasureColumnIndex = this._getFirstMeasureColumnIndex(),
		sMaxGroupHeaderWidth;
	if (iFirstMeasureColumnIndex > -1) {
		var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
		var $ths = this.$().find(".sapUiTableCtrlFirstCol > th");
		if (bHasRowHeader) {
			$ths = $ths.not(":nth-child(1)");
		}
		var iOffset = $ths.get(0).getBoundingClientRect().left;
		var $FirstMeasureColumn = $ths.get(this._getFirstMeasureColumnIndex());
		if ($FirstMeasureColumn) {
			var iMaxGroupHeaderWidth = 32 + $FirstMeasureColumn.getBoundingClientRect().left - iOffset;
			sMaxGroupHeaderWidth = iMaxGroupHeaderWidth + "px";
		} else {
			sMaxGroupHeaderWidth = "none";
		}
	} else {
		sMaxGroupHeaderWidth = "none";
	}

	var aRows = this.getRows();
	for (var iRow = 0, l = Math.min(iCount, aRows.length); iRow < l; iRow++) {
		var bIsFixedRow = iRow > (iCount - iFixedBottomRowCount - 1) && oBinding.getLength() > iCount,
			iRowIndex = bIsFixedRow ? (oBinding.getLength() - 1 - (iCount - 1 - iRow)) : iFirstRow + iRow,
			oContextInfo = this.getContextInfoByIndex(iRowIndex),
			oRow = aRows[iRow],
			$row = oRow.$(),
			$fixedRow = oRow.$("fixed"),
			$rowHdr = this.$().find("div[data-sap-ui-rowindex=" + $row.attr("data-sap-ui-rowindex") + "]"),
			iLevel = oContextInfo ? oContextInfo.level : 0;
			
		if (!oContextInfo || !oContextInfo.context) {
			$row.removeAttr("data-sap-ui-level");
			$row.removeAttr('aria-level');
			$row.removeAttr('aria-expanded');
			$row.removeClass("sapUiTableGroupHeader");
			$row.removeClass("sapUiAnalyticalTableSum");
			$row.removeClass("sapUiAnalyticalTableDummy");
			$fixedRow.removeAttr("data-sap-ui-level");
			$fixedRow.removeAttr('aria-level');
			$fixedRow.removeAttr('aria-expanded');
			$fixedRow.removeClass("sapUiTableGroupHeader");
			$rowHdr.removeClass("sapUiTableGroupHeader");
			$rowHdr.html("");
			$rowHdr.removeAttr("data-sap-ui-level");
			$rowHdr.removeClass("sapUiAnalyticalTableSum");
			$rowHdr.removeClass("sapUiAnalyticalTableDummy");
			if (oContextInfo && !oContextInfo.context) {
				$row.addClass("sapUiAnalyticalTableDummy");
				$rowHdr.addClass("sapUiAnalyticalTableDummy");
				$rowHdr.html('<div class="sapUiAnalyticalTableLoading">Loading...</div>');
			}
			continue;
		}
	
		if (oBinding.indexHasChildren && oBinding.indexHasChildren(iRowIndex)) {
			// modify the rows
			$row.addClass("sapUiTableGroupHeader");
			$fixedRow.addClass("sapUiTableGroupHeader");
			var sClass = oContextInfo.expanded ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
			$row.attr('aria-expanded', oContextInfo.expanded);
			$fixedRow.attr('aria-expanded', oContextInfo.expanded);
			var sGroupHeaderText = oBinding.getGroupName(oContextInfo.context, oContextInfo.level);
			$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\" title=\"" + sGroupHeaderText + "\" style=\"max-width:"  + sMaxGroupHeaderWidth + "\">" + sGroupHeaderText + "</div>");
			if (oContextInfo.expanded && !this.getSumOnTop()) {
				$row.addClass("sapUiTableRowHidden");
			}
			$row.removeClass("sapUiAnalyticalTableSum");
			$rowHdr.removeClass("sapUiAnalyticalTableSum");
			$row.removeClass("sapUiAnalyticalTableDummy");
			$rowHdr.removeClass("sapUiAnalyticalTableDummy");
			$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
		} else {
			$row.attr('aria-expanded', false);
			$row.removeClass("sapUiTableGroupHeader");
			$row.removeClass("sapUiTableRowHidden");
			$row.removeClass("sapUiAnalyticalTableSum");
			$row.removeClass("sapUiAnalyticalTableDummy");
			
			$fixedRow.attr('aria-expanded', false);
			$fixedRow.removeClass("sapUiTableGroupHeader");

			$rowHdr.html("");
			$rowHdr.removeClass("sapUiTableGroupHeader");
			$rowHdr.removeClass("sapUiAnalyticalTableDummy");
			$rowHdr.removeClass("sapUiAnalyticalTableSum");
			
			if (oContextInfo.sum && oContextInfo.context && oContextInfo.context.getObject()) {
				$row.addClass("sapUiAnalyticalTableSum");
				$rowHdr.addClass("sapUiAnalyticalTableSum");
			}
		}
		$row.attr("data-sap-ui-level", iLevel);
		$fixedRow.attr("data-sap-ui-level", iLevel);
		$rowHdr.attr("data-sap-ui-level", iLevel);
		$row.attr('aria-level', iLevel + 1);
		$fixedRow.attr('aria-level', iLevel + 1);
		
		// show or hide the totals if not enabled - needs to be done by Table
		// control since the model could be reused and thus the values cannot
		// be cleared in the model - and the binding has no control over the 
		// value mapping - this happens directly via the context!
		var aCells = oRow.getCells();
		for (var i = 0, lc = aCells.length; i < lc; i++) {
			var iCol = aCells[i].data("sap-ui-colindex");
			var oCol = aCols[iCol];
			var $td = jQuery(aCells[i].$().closest("td"));
			if (oBinding.isMeasure(oCol.getLeadingProperty())) {
				if (!oContextInfo.sum || oCol.getSummed()) {
					$td.removeClass("sapUiTableCellHidden");
				} else {
					$td.addClass("sapUiTableCellHidden");
				}
			}
		}
		
	}
};

sap.ui.table.AnalyticalTable.prototype.onclick = function(oEvent) {
	if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
		this._onNodeSelect(oEvent);
	} else if (jQuery(oEvent.target).hasClass("sapUiAnalyticalTableSum")) {
		//Summs connot be selected
		oEvent.preventDefault();
		return;
	} else {
		if (sap.ui.table.Table.prototype.onclick) {
			sap.ui.table.Table.prototype.onclick.apply(this, arguments);
		}
	}
};

sap.ui.table.AnalyticalTable.prototype.onsapselect = function(oEvent) {
	if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
		this._onNodeSelect(oEvent);
	} else if (jQuery(oEvent.target).hasClass("sapUiAnalyticalTableSum")) {
		//Summs connot be selected
		oEvent.preventDefault();
		return;
	} else {
		var $Target = jQuery(oEvent.target),
			$TargetDIV = $Target.closest('div.sapUiTableRowHdr');
		if ($TargetDIV.hasClass('sapUiTableGroupHeader') && $TargetDIV.hasClass('sapUiTableRowHdr')) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($TargetDIV.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			oBinding.toggleIndex(iRowIndex);
			this.updateRows();
			return;
		}
		if (sap.ui.table.Table.prototype.onsapselect) {
			sap.ui.table.Table.prototype.onsapselect.apply(this, arguments);
		}
	}
};

sap.ui.table.AnalyticalTable.prototype._onNodeSelect = function(oEvent) {

	var $parent = jQuery(oEvent.target).parent();
	if ($parent.length > 0) {
		var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
		var oBinding = this.getBinding("rows");
		oBinding.toggleIndex(iRowIndex);
		this.updateRows();
	}

	oEvent.preventDefault();
	oEvent.stopPropagation();

};

sap.ui.table.AnalyticalTable.prototype._onContextMenu = function(oEvent) {
	if (jQuery(oEvent.target).closest('tr').hasClass('sapUiTableGroupHeader') ||
			jQuery(oEvent.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length > 0) {
		this._iGroupedLevel = jQuery(oEvent.target).closest('[data-sap-ui-level]').data('sap-ui-level');
		var oMenu = this._getGroupHeaderMenu();
		var eDock = sap.ui.core.Popup.Dock;
		oMenu.open(false, oEvent.target, eDock.LeftTop, eDock.LeftTop, document, (oEvent.pageX-2) +" "+ (oEvent.pageY-2));
	
		oEvent.preventDefault();
		oEvent.stopPropagation();
		return;
	}

	return true;
};

sap.ui.table.AnalyticalTable.prototype._getGroupHeaderMenu = function() {

	var that = this;
	function getGroupColumnInfo() {
		var iIndex = that._iGroupedLevel - 1;
		if(that._aGroupedColumns[iIndex]) {
			var oColumn = that.getColumns().filter(function(oColumn){
				if(that._aGroupedColumns[iIndex] === oColumn.getId()) {
					return true;
				}
			})[0];

			return {
				column: oColumn,
				index: jQuery.inArray(oColumn, that.getColumns()) + 1
			};
		}else {
			return undefined;
		}
	}

	if (!this._oGroupHeaderMenu) {
		this._oGroupHeaderMenu = new sap.ui.unified.Menu();
		this._oGroupHeaderMenuVisibilityItem = new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_SHOW_COLUMN"),
			select: function() {
				var oGroupColumnInfo = getGroupColumnInfo();

				if (oGroupColumnInfo) {
					var oColumn = oGroupColumnInfo.column;
					oColumn.setShowIfGrouped(!oColumn.getShowIfGrouped());
				}
			}
		});
		this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);
		this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_UNGROUP"),
			select: function() {
				var aColumns = that.getColumns(),
					iFoundGroups = 0,
					iLastGroupedIndex = -1,
					iUngroudpedIndex = -1,
					oColumn;
				for (var i=0; i<aColumns.length; i++) {
					oColumn = aColumns[i];
					if (oColumn.getGrouped()) {
						iFoundGroups++;
						if (iFoundGroups == that._iGroupedLevel) {
							oColumn._bSkipUpdateAI = true;
							oColumn.setGrouped(false);
							oColumn._bSkipUpdateAI = false;
							iUngroudpedIndex = i;
						} else {
							iLastGroupedIndex = i;
						}
					}
				}
				if (iLastGroupedIndex > -1 && iUngroudpedIndex > -1 && iUngroudpedIndex < iLastGroupedIndex) {
					var oUngroupedColumn = aColumns[iUngroudpedIndex];
					var iHeaderSpan = oUngroupedColumn.getHeaderSpan();
					if (jQuery.isArray(iHeaderSpan)) {
						iHeaderSpan = iHeaderSpan[0];
					}
					var aRemovedColumns = [];
					for (var i=iUngroudpedIndex; i<iUngroudpedIndex+iHeaderSpan; i++) {
						aRemovedColumns.push(aColumns[i]);
					}
					jQuery.each(aRemovedColumns, function(iIndex, oColumn) {
						that.removeColumn(oColumn);
						that.insertColumn(oColumn, iLastGroupedIndex);
					});
				}
				that._updateTableColumnDetails();
				that.updateAnalyticalInfo();
			}
		}));
		this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_UNGROUP_ALL"),
			select: function() {
				var aColumns = that.getColumns();
				for (var i=0; i<aColumns.length; i++) {
					aColumns[i]._bSkipUpdateAI = true;
					aColumns[i].setGrouped(false);
					aColumns[i]._bSkipUpdateAI = false;
				}
				that._bSupressRefresh = true;
				that._updateTableColumnDetails();
				that.updateAnalyticalInfo();
				that._bSupressRefresh = false;
			}
		}));
		this._oGroupHeaderMoveUpItem = new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_MOVE_UP"),
			select: function() {
				var oGroupColumnInfo = getGroupColumnInfo();

				if (oGroupColumnInfo) {
					var oColumn = oGroupColumnInfo.column;
					var iIndex = jQuery.inArray(oColumn.getId(), that._aGroupedColumns);
					if (iIndex > 0) {
						that._aGroupedColumns[iIndex] = that._aGroupedColumns.splice(iIndex - 1, 1, that._aGroupedColumns[iIndex])[0];
						that.updateAnalyticalInfo();
					}
				}
			},
			icon: "sap-icon://arrow-top"
		});
		this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);
		this._oGroupHeaderMoveDownItem = new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_MOVE_DOWN"),
			select: function() {
				var oGroupColumnInfo = getGroupColumnInfo();

				if (oGroupColumnInfo) {
					var oColumn = oGroupColumnInfo.column;
					var iIndex = jQuery.inArray(oColumn.getId(), that._aGroupedColumns);
					if (iIndex < that._aGroupedColumns.length) {
						that._aGroupedColumns[iIndex] = that._aGroupedColumns.splice(iIndex + 1, 1, that._aGroupedColumns[iIndex])[0];
						that.updateAnalyticalInfo();
					}
				}
			},
			icon: "sap-icon://arrow-bottom"
		});
		this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);
		this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_SORT_ASC"),
			select: function() {
				var oGroupColumnInfo = getGroupColumnInfo();

				if (oGroupColumnInfo) {
					var oColumn = oGroupColumnInfo.column;

					oColumn.sort(false); //update Analytical Info triggered by aftersort in column
				}
			},
			icon: "sap-icon://up"
		}));
		this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_SORT_DESC"),
			select: function() {
				var oGroupColumnInfo = getGroupColumnInfo();

				if (oGroupColumnInfo) {
					var oColumn = oGroupColumnInfo.column;

					oColumn.sort(true); //update Analytical Info triggered by aftersort in column
				}
			},
			icon: "sap-icon://down"
		}));
		this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),
			select: function() {
				that.getBinding("rows").collapseAll(that._iGroupedLevel);
				that._oSelection.clearSelection();
				that.updateRows();
			}
		}));
		this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
			text: this._oResBundle.getText("TBL_COLLAPSE_ALL"),
			select: function() {
				that.getBinding("rows").collapseAll();
				that._oSelection.clearSelection();
				that.updateRows();
			}
		}));
	}
	
	var oGroupColumnInfo = getGroupColumnInfo();
	if (oGroupColumnInfo) {
		var oColumn = oGroupColumnInfo.column;
		if (oColumn.getShowIfGrouped()) {
			this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));
		} else {
			this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));
		}
		this._oGroupHeaderMoveUpItem.setEnabled(oGroupColumnInfo.index > 0);
		this._oGroupHeaderMoveDownItem.setEnabled(oGroupColumnInfo.index < this._aGroupedColumns.length - 2);
	} else {
		this._oGroupHeaderMoveUpItem.setEnabled(true);
		this._oGroupHeaderMoveDownItem.setEnabled(true);
	}

	return this._oGroupHeaderMenu;

};

sap.ui.table.AnalyticalTable.prototype.expand = function(iRowIndex) {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var oContext = this.getContextByIndex(iRowIndex);
		oBinding.expand(oContext);
		this.updateRows();
	}
};

sap.ui.table.AnalyticalTable.prototype.collapse = function(iRowIndex) {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var oContext = this.getContextByIndex(iRowIndex);
		oBinding.collapse(oContext);
		this.updateRows();
	}
};

sap.ui.table.AnalyticalTable.prototype.isExpanded = function(iRowIndex) {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var oContext = this.getContextByIndex(iRowIndex);
		return oBinding.isExpanded(oContext);
	}
	return false;
};

sap.ui.table.AnalyticalTable.prototype.selectAll = function() {
	sap.ui.table.Table.prototype.selectAll.apply(this);
	var oSelMode = this.getSelectionMode();
	if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle")) {
		return this;
	}
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var iLength = (oBinding.getLength() || 0);
		for (var i=0; i<iLength; i++) {
			var oContextInfo = this.getContextInfoByIndex(i);
			if (oContextInfo.sum || oBinding.indexHasChildren(i)) {
				this._oSelection.removeSelectionInterval(i,i);
			}
		}
		this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
	}
	return this;
};

sap.ui.table.AnalyticalTable.prototype.getContextInfoByIndex = function(iIndex) {
	var oBinding = this.getBinding("rows");
	return iIndex >= 0 && oBinding ? oBinding.getContextInfo(iIndex) : null;
};

sap.ui.table.AnalyticalTable.prototype._onColumnMoved = function(oEvent) {
	sap.ui.table.Table.prototype._onColumnMoved.apply(this, arguments);
	this.updateAnalyticalInfo();
};

sap.ui.table.AnalyticalTable.prototype.addColumn = function(vColumn, bSuppressInvalidate) {
	var oColumn = this._getColumn(vColumn);
	if (oColumn.getGrouped()) {
		this._addGroupedColumn(oColumn.getId());
	}
	return sap.ui.table.Table.prototype.addColumn.call(this, oColumn, bSuppressInvalidate);
};

sap.ui.table.AnalyticalTable.prototype.insertColumn = function(vColumn, iIndex, bSuppressInvalidate) {
	var oColumn = this._getColumn(vColumn);
	if (oColumn.getGrouped()) {
		this._addGroupedColumn(oColumn.getId());
	}
	return sap.ui.table.Table.prototype.insertColumn.call(this, oColumn, iIndex, bSuppressInvalidate);
};

sap.ui.table.AnalyticalTable.prototype.removeColumn = function(vColumn, bSuppressInvalidate) {
	var oColumn = sap.ui.table.Table.prototype.removeColumn.apply(this, arguments);
	if (oColumn) {
		this._aGroupedColumns = jQuery.grep(this._aGroupedColumns, function(value) {
			return value != oColumn.getId();
		});
	}
	return oColumn;
};

sap.ui.table.AnalyticalTable.prototype.removeAllColumns = function(bSuppressInvalidate) {
	this._aGroupedColumns = [];
	return sap.ui.table.Table.prototype.removeColumn.apply(this, arguments);
};

sap.ui.table.AnalyticalTable.prototype._getColumn = function(vColumn) {
	if (typeof vColumn === "string") {
		var oColumn =  new sap.ui.table.AnalyticalColumn({
			leadingProperty: vColumn,
			template: vColumn,
			managed: true
		});
		return oColumn;
	} else if (vColumn instanceof sap.ui.table.AnalyticalColumn) {
		return vColumn;
	} else {
		throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");
	}
};

sap.ui.table.AnalyticalTable.prototype._updateColumns = function() {
	this._updateTableColumnDetails();
	this.updateAnalyticalInfo();
};

sap.ui.table.AnalyticalTable.prototype.updateAnalyticalInfo = function(bSupressRefresh) {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		var aColumnInfo = this._getColumnInformation();
		oBinding.updateAnalyticalInfo(aColumnInfo);
		this._updateTotalRow(aColumnInfo, bSupressRefresh);
		if (bSupressRefresh || this._bSupressRefresh) {
			return;
		}
		this.refreshRows();
	}
};

sap.ui.table.AnalyticalTable.prototype._updateTotalRow = function(aColumnInfo, bSuppressInvalidate) {

	var bHasTotal = false;
	for (var i = 0, l = aColumnInfo ? aColumnInfo.length : 0; i < l; i++) {
		if (aColumnInfo[i].visible && aColumnInfo[i].total) {
			bHasTotal = true;
			break;
		}
	}
	
	var oBinding = this.getBinding("rows");
	if (oBinding && (!oBinding.bProvideGrandTotals || !oBinding._hasTotaledMeasures())) {
		bHasTotal = false;
	}
	
	var iFixedBottomRowCount = this.getFixedBottomRowCount();
	if (bHasTotal) {
		if (iFixedBottomRowCount !== 1) {
			this.setProperty("fixedBottomRowCount", 1, bSuppressInvalidate);
		}
	} else {
		if (iFixedBottomRowCount !== 0) {
			this.setProperty("fixedBottomRowCount", 0, bSuppressInvalidate);
		}
	}
	
};

sap.ui.table.AnalyticalTable.prototype._updateTableColumnDetails = function() {
	var oBinding = this.getBinding("rows"),
		oResult = oBinding && oBinding.getAnalyticalQueryResult();

	if (oResult) {
		var aColumns = this.getColumns(),
			aGroupedDimensions = [],
			aUngroupedDimensions = [],
			aDimensions = [],
			oDimensionIndex = {},
			oColumn,
			oDimension;

		// calculate an index of all dimensions and their columns. Grouping is done per dimension.
		for(var i = 0; i < aColumns.length; i++) {
			oColumn = aColumns[i];
			oColumn._isLastGroupableLeft = false;
			oColumn._bLastGroupAndGrouped = false;
			oColumn._bDependendGrouped = false;
			
			// ignore invisible columns
			if (!oColumn.getVisible()) {
				continue;
			}

			var sLeadingProperty = oColumn.getLeadingProperty();
			oDimension = oResult.findDimensionByPropertyName(sLeadingProperty);

			if(oDimension) {
				var sDimensionName = oDimension.getName();
				if(!oDimensionIndex[sDimensionName]) {
					oDimensionIndex[sDimensionName] = {dimension: oDimension, columns: [oColumn]};
				}
				else {
					oDimensionIndex[sDimensionName].columns.push(oColumn);
				}

				// if one column of a dimension is grouped, the dimension is considered as grouped.
				// all columns which are not explicitly grouped will be flagged as dependendGrouped in the next step
				if(oColumn.getGrouped() && jQuery.inArray(sDimensionName, aGroupedDimensions) == -1) {
					aGroupedDimensions.push(sDimensionName);
				}

				if(jQuery.inArray(sDimensionName, aDimensions) == -1) {
					aDimensions.push(sDimensionName);
				}
			}
		}

		aUngroupedDimensions = jQuery.grep(aDimensions, function (s) {
			return (jQuery.inArray(s, aGroupedDimensions) == -1);
		});

		// for all grouped dimensions
		if(aGroupedDimensions.length > 0) {
			// calculate and flag the dependendly grouped columns of the dimension
			jQuery.each(aGroupedDimensions, function(i, s) {
				jQuery.each(oDimensionIndex[s].columns, function(j, o) {
					if(!o.getGrouped()) {
						o._bDependendGrouped = true;
					}
				});
			});

			// if there is only one dimension left, their columns must remain visible even though they are grouped. 
			// this behavior is controlled by the flag _bLastGroupAndGrouped
			if(aGroupedDimensions.length == aDimensions.length) {
				oDimension = oResult.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length - 1]).getLeadingProperty());
				var aGroupedDimensionColumns = oDimensionIndex[oDimension.getName()].columns;
				jQuery.each(aGroupedDimensionColumns, function(i, o) {
					o._bLastGroupAndGrouped = true;
				});
			} 
		}

		if(aUngroupedDimensions.length == 1) {
			jQuery.each(oDimensionIndex[aUngroupedDimensions[0]].columns, function(j, o) {
				o._isLastGroupableLeft = true;
			});
		}
	}
};

sap.ui.table.AnalyticalTable.prototype._getFirstMeasureColumnIndex = function() {
	var oBinding = this.getBinding("rows"),
		oResultSet = oBinding && oBinding.getAnalyticalQueryResult(),
		aColumns = this._getVisibleColumns();
	
	if (!oResultSet) {
		return -1;
	}
	
	for(var i=0; i < aColumns.length; i++) {
		var oColumn = aColumns[i],
			sLeadingProperty = oColumn.getLeadingProperty();

		if (oResultSet.findMeasureByName(sLeadingProperty) || oResultSet.findMeasureByPropertyName(sLeadingProperty)) {
			return i;
		}
	}
};

sap.ui.table.AnalyticalTable.prototype.getTotalSize = function() {
	var oBinding = this.getBinding("rows");
	if (oBinding) {
		return oBinding.getTotalSize();
	}
	return 0;
};

sap.ui.table.AnalyticalTable.prototype._hasData = function() {
	var oBinding = this.getBinding("rows"),
		iLength = oBinding && (oBinding.getLength() || 0),
		bHasTotal = oBinding && oBinding.hasGrandTotalDisplayed();
	
	if (!oBinding || (bHasTotal && iLength < 2) || (!bHasTotal && iLength === 0)) {
		return false;
	}
	return true;
};

sap.ui.table.AnalyticalTable.prototype._onPersoApplied = function() {
	sap.ui.table.Table.prototype._onPersoApplied.apply(this, arguments);
	this._aGroupedColumns = [];
	var aColumns = this.getColumns();
	for (var i = 0, l = aColumns.length; i < l; i++) {
		if (aColumns[i].getGrouped()) {
			this._addGroupedColumn(aColumns[i].getId());
		}
	}
	this._updateTableColumnDetails();
	this.updateAnalyticalInfo();
};

sap.ui.table.AnalyticalTable.prototype._addGroupedColumn = function(sColumn) {
	if(jQuery.inArray(sColumn, this._aGroupedColumns) < 0) {
		this._aGroupedColumns.push(sColumn);
	}
};

}; // end of sap/ui/table/AnalyticalTable.js
if ( !jQuery.sap.isDeclared('sap.ui.table.DataTable') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.table.DataTable.
jQuery.sap.declare("sap.ui.table.DataTable");




/**
 * Constructor for a new DataTable.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getExpandedVisibleRowCount expandedVisibleRowCount} : int</li>
 * <li>{@link #getExpanded expanded} : boolean (default: false)</li>
 * <li>{@link #getHierarchical hierarchical} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.table.DataTable#event:rowSelect rowSelect} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.table.TreeTable#constructor sap.ui.table.TreeTable}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The DataTable control provides a set of sophisticated and comfort functions for table design. For example, you can make settings for the number of visible rows and a number for the displayed rows in the case the user expands the table. The first visible row can be explicitly set. For the selection of columns and rows, a Multi, a Single, a None, and an All mode are available. Setting the Editable property to true lets the user make changes on the table cell entries.
 * @extends sap.ui.table.TreeTable
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @deprecated Since version 1.5.1. 
 * The DataTable has been replaced via the Table/TreeTable control.
 * @name sap.ui.table.DataTable
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.table.TreeTable.extend("sap.ui.table.DataTable", { metadata : {

	deprecated : true,
	library : "sap.ui.table",
	properties : {
		"expandedVisibleRowCount" : {type : "int", group : "", defaultValue : null},
		"expanded" : {type : "boolean", group : "", defaultValue : false},
		"hierarchical" : {type : "boolean", group : "", defaultValue : false}
	},
	events : {
		"rowSelect" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.table.DataTable with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.table.DataTable.extend
 * @function
 */

sap.ui.table.DataTable.M_EVENTS = {'rowSelect':'rowSelect'};


/**
 * Getter for property <code>expandedVisibleRowCount</code>.
 * Count of visible rows when expanded
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>expandedVisibleRowCount</code>
 * @public
 * @name sap.ui.table.DataTable#getExpandedVisibleRowCount
 * @function
 */

/**
 * Setter for property <code>expandedVisibleRowCount</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iExpandedVisibleRowCount  new value for property <code>expandedVisibleRowCount</code>
 * @return {sap.ui.table.DataTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.DataTable#setExpandedVisibleRowCount
 * @function
 */


/**
 * Getter for property <code>expanded</code>.
 * Flag whether the Table is expanded or not
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>expanded</code>
 * @public
 * @name sap.ui.table.DataTable#getExpanded
 * @function
 */

/**
 * Setter for property <code>expanded</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bExpanded  new value for property <code>expanded</code>
 * @return {sap.ui.table.DataTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.DataTable#setExpanded
 * @function
 */


/**
 * Getter for property <code>hierarchical</code>.
 * Flag, whether the table displays its content hierarchical or not (**experimental**!!)
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>hierarchical</code>
 * @public
 * @name sap.ui.table.DataTable#getHierarchical
 * @function
 */

/**
 * Setter for property <code>hierarchical</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bHierarchical  new value for property <code>hierarchical</code>
 * @return {sap.ui.table.DataTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.DataTable#setHierarchical
 * @function
 */


/**
 * fired when the row selection of the table has been changed
 *
 * @name sap.ui.table.DataTable#rowSelect
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {int} oControlEvent.getParameters.rowIndex row index which row has been selected or deselected
 * @param {object} oControlEvent.getParameters.rowContext binding context of the row index which row has been selected or deselected
 * @param {int[]} oControlEvent.getParameters.rowIndices array of row indices which selection has been changed (either selected or deselected)
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'rowSelect' event of this <code>sap.ui.table.DataTable</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.table.DataTable</code>.<br/> itself. 
 *  
 * fired when the row selection of the table has been changed
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.table.DataTable</code>.<br/> itself.
 *
 * @return {sap.ui.table.DataTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.DataTable#attachRowSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'rowSelect' event of this <code>sap.ui.table.DataTable</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.table.DataTable} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.table.DataTable#detachRowSelect
 * @function
 */

/**
 * Fire event rowSelect to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'rowIndex' of type <code>int</code> row index which row has been selected or deselected</li>
 * <li>'rowContext' of type <code>object</code> binding context of the row index which row has been selected or deselected</li>
 * <li>'rowIndices' of type <code>int[]</code> array of row indices which selection has been changed (either selected or deselected)</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.table.DataTable} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.table.DataTable#fireRowSelect
 * @function
 */


// Start of sap\ui\table\DataTable.js
/**
 * Initialization of the DataTable control
 * @private
 */
sap.ui.table.DataTable.prototype.init = function() {
	
	sap.ui.table.TreeTable.prototype.init.apply(this, arguments);
	
	this._bInheritEditableToControls = true;
	
	// default values for DataTable
	this.setEditable(false); 
	this.setSelectionBehavior(sap.ui.table.SelectionBehavior.Row);
	
	this.attachRowSelectionChange(function(oEvent) {
		this.fireRowSelect(oEvent.mParameters);
	});
	
	this._iLastFixedColIndex = -1;

};

sap.ui.table.DataTable.prototype.isTreeBinding = function(sName) {
	sName = sName || "rows";
	if (sName === "rows") {
		return this.getHierarchical();
	}
	return sap.ui.core.Element.prototype.isTreeBinding.apply(this, arguments);
};

sap.ui.table.DataTable.prototype.setHierarchical = function(bHierarchical) {
	this.setProperty("hierarchical", bHierarchical);
	this._iLastFixedColIndex = bHierarchical ? 0 : -1;
};

sap.ui.table.DataTable.prototype.setVisibleRowCount = function(iRowCount) {
	this._iVisibleRowCount = iRowCount;
	if (!this.getExpanded()) {
		sap.ui.table.Table.prototype.setVisibleRowCount.apply(this, arguments);
	}
};

sap.ui.table.DataTable.prototype.setExpandedVisibleRowCount = function(iRowCount) {
	this.setProperty("expandedVisibleRowCount", iRowCount, true);
	if (this.getExpanded()) {
		sap.ui.table.Table.prototype.setVisibleRowCount.apply(this, arguments);
	}
};

sap.ui.table.DataTable.prototype.setExpanded = function(bExpanded) {
	this.setProperty("expanded", bExpanded, true);
	if (this.getExpandedVisibleRowCount() > 0) {
		var iRowCount = bExpanded ? this.getExpandedVisibleRowCount() : this._iVisibleRowCount;
		sap.ui.table.Table.prototype.setVisibleRowCount.call(this, iRowCount);
	}
};

}; // end of sap/ui/table/DataTable.js
