// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.unified.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarLegendRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.unified.CalendarLegendRenderer");

/**
 * @class Legend renderer.
 * @static
 */
sap.ui.unified.CalendarLegendRenderer = {};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *            oRm the RenderManager that can be used for writing to the render
 *            output buffer
 * @param {sap.ui.core.Legend}
 *            oLeg an object representation of the legend that should be
 *            rendered
 */
sap.ui.unified.CalendarLegendRenderer.render = function(oRm, oLeg) {

	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
	var aClasses = [ "Today", "Selected", "NormalDay", "NonWorkingDay" ];
	var aStandardItems = [ "TODAY", "SELECTED", "NORMAL_DAY", "NON_WORKING_DAY" ];
	var aCustomItems = oLeg.getItems();

	oRm.write("<div");
	oRm.writeControlData(oLeg);
	oRm.addClass("sapUiUnifiedLegend");
	oRm.writeClasses();
	var sColumnWidth = oLeg.getColumnWidth();
	oRm.writeAttribute("style", "column-width:"+sColumnWidth+";-moz-column-width:"+sColumnWidth+";-webkit-column-width:"+sColumnWidth+";");
	oRm.writeStyles();
	oRm.write(">");

	// rendering standard days and colors
	for (var i = 0; i < aStandardItems.length; i++) {
		this.renderLegendItem(oRm, "sapUiUnifiedLegend" + aClasses[i], rb.getText("LEGEND_" + aStandardItems[i]));

	}
	// rendering special day and colors
	if (aCustomItems && aCustomItems.length > 0)
		for (var i = 0; i < aCustomItems.length; i++) {
			var type = i+1;
			this.renderLegendItem(oRm, "sapUiCalLegDayType" + ((type < 10) ? "0" + type : type), aCustomItems[i].getText());
		}
	oRm.write("</div>");

};

/**
 * Renders one item of the legend {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *            oRm the RenderManager that can be used for writing to the render
 *            output buffer
 * @param sClass
 *            name of the css class used for this item
 * @param sText
 *            description of the item
 */
sap.ui.unified.CalendarLegendRenderer.renderLegendItem = function(oRm, sClass, sText) {

	// new LegendItem
	oRm.write("<div");
	oRm.addClass("sapUiUnifiedLegendItem");
	oRm.writeClasses();
	oRm.writeStyles();
	oRm.write(">");
	// draw the square background
	oRm.write("<div");
	oRm.addClass("sapUiUnifiedLegendSquare");
	oRm.writeClasses();
	oRm.writeStyles();
	oRm.write(">");
	// draw the square color
	oRm.write("<div");
	oRm.addClass("sapUiUnifiedLegendSquareColor")
	oRm.addClass(sClass);
	oRm.writeClasses();
	oRm.writeStyles();
	oRm.write("></div></div>"); // close color, background
	// write description
	oRm.write("<div");
	oRm.addClass("sapUiUnifiedLegendDescription");
	oRm.writeClasses();
	oRm.writeStyles();
	oRm.write(">");
	oRm.writeEscaped(sText);
	oRm.write("</div></div>"); // close description, LegendItem

}

}; // end of sap/ui/unified/CalendarLegendRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.unified.CalendarRenderer");

/**
 * @class DatePicker renderer.
 * @static
 */
sap.ui.unified.CalendarRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.unified.Calendar} oCal an object representation of the control that should be rendered
 */
sap.ui.unified.CalendarRenderer.render = function(oRm, oCal){

	oCal._iMode = 0; // it's rendered always as DayPicker

	var oDate = oCal._getFocusedDate();
	var sId = oCal.getId();
	var sTooltip = oCal.getTooltip_AsString();

	oRm.write("<div");
	oRm.writeControlData(oCal);
	oRm.addClass("sapUiCal");
	oRm.writeClasses();

	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
	oRm.writeAccessibilityState(oCal, {
		role: "dialog",
		label: rb.getText("DATEPICKER_DIALOG")
	});

	if (sTooltip) {
		oRm.writeAttributeEscaped('title', sTooltip);
	}

	oRm.write(">"); // div element

	this.renderHeader(oRm, oCal, oDate);

	this.renderDayPicker(oRm, oCal, oDate);

	oRm.write("<button id=\""+sId+"-cancel\" class=\"sapUiCancel\" tabindex=\"-1\">");
	oRm.write(rb.getText("CALENDAR_CANCEL"));
	oRm.write("</button>");

	// dummy element to catch tabbing in from next element
	oRm.write("<div id=\""+sId+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");

	oRm.write("</div>");
};

sap.ui.unified.CalendarRenderer.renderHeader = function(oRm, oCal, oDate){

	var oLocaleData = oCal._getLocaleData();
	var sId = oCal.getId();
	var iMonth = oDate.getUTCMonth();
	var iYear = oDate.getUTCFullYear();
	var aMonthNames = [];
	if (oCal._bLongMonth || !oCal._bNamesLengthChecked) {
		aMonthNames = oLocaleData.getMonthsStandAlone("wide");
	} else {
		aMonthNames = oLocaleData.getMonthsStandAlone("abbreviated");
	}

	oRm.write("<div");
	oRm.addClass("sapUiCalHead");
	oRm.writeClasses();
	oRm.write(">"); // div element
	oRm.write("<button id=\""+sId+"-prev\" class=\"sapUiCalPrev\" tabindex=\"-1\">");
	oRm.writeIcon("sap-icon://slim-arrow-left");
	oRm.write("</button>");

	oRm.write("<button");
	oRm.writeAttributeEscaped('id', sId + '-month');
	oRm.addClass("sapUiCalMonthPick");
	oRm.writeAttribute('tabindex', "-1");
	oRm.writeClasses();
	oRm.write(">"); // button element
	oRm.write(aMonthNames[iMonth]);
	oRm.write("</button>");

	oRm.write("<button");
	oRm.writeAttributeEscaped('id', sId + '-year');
	oRm.addClass("sapUiCalYearPick");
	oRm.writeAttribute('tabindex', "-1");
	oRm.writeClasses();
	oRm.write(">"); // button element
	oRm.write(iYear);
	oRm.write("</button>");

	oRm.write("<button id=\""+sId+"-next\" class=\"sapUiCalNext\" tabindex=\"-1\">");
	oRm.writeIcon("sap-icon://slim-arrow-right");
	oRm.write("</button>");
	oRm.write("</div>");

};

sap.ui.unified.CalendarRenderer.renderDayPicker = function(oRm, oCal, oDate){

	var oLocaleData = oCal._getLocaleData();
	var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();
	var sId = oCal.getId();

	// week numbers
	var aWeekDays = [];
	if (oCal._bLongWeekDays || !oCal._bNamesLengthChecked) {
		aWeekDays = oLocaleData.getDaysStandAlone("abbreviated");
	}else{
		aWeekDays = oLocaleData.getDaysStandAlone("narrow");
	}
	for ( var i = 0; i < 7; i++) {
		oRm.write("<div");
		oRm.addClass("sapUiCalWH");
		if (i == 0) {
			oRm.addClass("sapUiCalFirstWDay");
		}
		oRm.writeClasses();
		oRm.write(">"); // div element
		oRm.write(aWeekDays[(i+iFirstDayOfWeek)%7]);
		oRm.write("</div>");
	}

	// days
	oRm.write("<div id=\""+sId+"-days\" class=\"sapUiCalDays\">"); // extra DIV around the days to allow rerendering only it's content
	this.renderDays(oRm, oCal, oDate);
	oRm.write("</div>");

};

sap.ui.unified.CalendarRenderer.renderDays = function(oRm, oCal, oDate){

	if (!oDate) {
		oDate = oCal._getFocusedDate();
	}

	var sLocale = oCal.getLocale();
	var oLocaleData = oCal._getLocaleData();
	var iMonth = oDate.getUTCMonth();
	var iYear = oDate.getUTCFullYear();
	var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();
	var iWeekendStart = oLocaleData.getWeekendStart();
	var iWeekendEnd = oLocaleData.getWeekendEnd();
	var oToday = new Date();
	var sId = oCal.getId();

	// determine weekday of first day in month
	var oFirstDay = new Date(oDate.getTime());
	oFirstDay.setUTCDate(1);
	var iWeekDay = oFirstDay.getUTCDay();
	var iDaysOldMonth = iWeekDay - iFirstDayOfWeek;
	if (iDaysOldMonth < 0) {
		iDaysOldMonth = 7 + iDaysOldMonth;
	}

	if (iDaysOldMonth > 0) {
		// determine first day for display
		oFirstDay.setUTCDate(1 - iDaysOldMonth);
	}

	var oDay = new Date(oFirstDay.getTime());
	var sYyyymmdd = "";
	var iNextMonth = (iMonth + 1) % 12;
	var iSelected = 0;
	var oType;

	do {

		sYyyymmdd = oCal._oFormatYyyymmdd.format(oDay, true);
		iWeekDay = oDay.getUTCDay();
		iSelected = oCal._checkDateSelected(oDay);
		oType = oCal._getDateType(oDay);
		oRm.write("<div");
		oRm.writeAttribute("id", sId+"-"+sYyyymmdd);
		oRm.addClass("sapUiCalDay");
		oRm.addClass("sapUiCalWDay"+iWeekDay);
		if (iWeekDay == iFirstDayOfWeek) {
			oRm.addClass("sapUiCalFirstWDay");
		}
		if (iMonth != oDay.getUTCMonth()) {
			oRm.addClass("sapUiCalDayOtherMonth");
		}
		if (oDay.getUTCMonth() == oToday.getMonth() && oDay.getUTCFullYear() == oToday.getFullYear() && oDay.getUTCDate() == oToday.getDate()) {
			oRm.addClass("sapUiCalDayToday");
		}

		if (iSelected > 0) {
			oRm.addClass("sapUiCalDaySel"); // day selected
		}
		if (iSelected == 2) {
			oRm.addClass("sapUiCalDaySelStart"); // interval start
		} else if (iSelected == 3) {
			oRm.addClass("sapUiCalDaySelEnd"); // interval end
		} else if (iSelected == 4) {
			oRm.addClass("sapUiCalDaySelBetween"); // interval between
		} else if (iSelected == 5) {
			oRm.addClass("sapUiCalDaySelStart"); // interval start
			oRm.addClass("sapUiCalDaySelEnd"); // interval end
		}

		if (oType) {
			oRm.addClass("sapUiCalDay"+oType.type);
			if (oType.tooltip) {
				oRm.writeAttributeEscaped('title', oType.tooltip);
			}
		}

		if ((iWeekDay >= iWeekendStart && iWeekDay <= iWeekendEnd) ||
		    ( iWeekendEnd < iWeekendStart && ( iWeekDay >= iWeekendStart || iWeekDay <= iWeekendEnd))){
			oRm.addClass("sapUiCalDayWeekEnd");
		}
		oRm.writeAttribute("tabindex", "-1");
		oRm.writeAttribute("data-sap-day", sYyyymmdd);
		oRm.writeClasses();
		oRm.write(">"); // div element

		oRm.write("<span class=\"sapUiCalDayNum\">");
		oRm.write(oDay.getUTCDate());
		oRm.write("</span>");

		if (iWeekDay == iFirstDayOfWeek) {
			// add week number - inside first day of the week to allow better position and make it easier for ItemNavigation
			oRm.write("<span class=\"sapUiCalWeekNum\">");
			oRm.write(this.calculateWeekNumber(oDay, iYear, sLocale, oLocaleData));
			oRm.write("</span>");
		}

		oRm.write("</div>");

		oDay.setUTCDate(oDay.getUTCDate()+1);

	} while (oDay.getUTCMonth() != iNextMonth || oDay.getUTCDay() != iFirstDayOfWeek);

};

sap.ui.unified.CalendarRenderer.calculateWeekNumber = function(oDate, iYear, sLocale, oLocaleData){

	var iWeekNum = 0;
	var iWeekDay = 0;
	var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();

	switch (sLocale) {
	case "en-US":
		/*
		 * in US the week starts with Sunday
		 * The first week of the year starts with January 1st. But Dec. 31 is still in the last year
		 * So the week beginning in December and ending in January has 2 week numbers
		 */
		var oJanFirst = new Date(oDate.getTime());
		oJanFirst.setUTCFullYear(iYear, 0, 1);
		iWeekDay = oJanFirst.getUTCDay();

		//get the date for the same weekday like jan 1.
		var oCheckDate = new Date(oDate.getTime());
		oCheckDate.setUTCDate(oCheckDate.getUTCDate() - oCheckDate.getUTCDay() + iWeekDay);

		iWeekNum = Math.round((oCheckDate.getTime() - oJanFirst.getTime()) / 86400000 / 7) + 1;

		break;

	default:
		// normally the first week of the year is the one where the first Thursday of the year is
		// find Thursday of this week
		// if the checked day is before the 1. day of the week use a day of the previous week to check
		var oThursday = new Date(oDate.getTime());
		oThursday.setUTCDate(oThursday.getUTCDate() - iFirstDayOfWeek);
		iWeekDay = oThursday.getUTCDay();
		oThursday.setUTCDate(oThursday.getUTCDate() - iWeekDay + 4);

		var oFirstDayOfYear = new Date(oThursday.getTime());
		oFirstDayOfYear.setUTCMonth(0, 1);
		iWeekDay = oFirstDayOfYear.getUTCDay();
		var iAddDays = 0;
		if (iWeekDay > 4) {
			iAddDays = 7; // first day of year is after Thursday, so first Thursday is in the next week
		}
		var oFirstThursday = new Date(oFirstDayOfYear.getTime());
		oFirstThursday.setUTCDate(1 - iWeekDay + 4 + iAddDays);

		iWeekNum = Math.round((oThursday.getTime() - oFirstThursday.getTime()) / 86400000 / 7) + 1;

		break;
	}

	return iWeekNum;

};

sap.ui.unified.CalendarRenderer.renderMonthPicker = function(oRm, oCal, oDate){

	var oLocaleData = oCal._getLocaleData();
	var sId = oCal.getId();
	var aMonthNames = [];
	if (oCal._bLongMonth || !oCal._bNamesLengthChecked) {
		aMonthNames = oLocaleData.getMonthsStandAlone("wide");
	} else {
		aMonthNames = oLocaleData.getMonthsStandAlone("abbreviated");
	}
	var iMonth = oDate.getUTCMonth();

	oRm.write("<div id=\""+sId+"-months\" class=\"sapUiCalMonths\">");

	for ( var i = 0; i < 12; i++) {
		oRm.write("<div");
		oRm.writeAttribute("id", sId+"-m"+i);
		oRm.addClass("sapUiCalMonth");
		if (i == iMonth) {
			oRm.addClass("sapUiCalMonthSel");
		}
		oRm.writeAttribute("tabindex", "-1");
		oRm.writeClasses();
		oRm.write(">"); // div element
		oRm.write(aMonthNames[i]);
		oRm.write("</div>");
	}

	oRm.write("</div>");

};

sap.ui.unified.CalendarRenderer.renderYearPicker = function(oRm, oCal, oDate){

	var sId = oCal.getId();
	var iCurrentYear = oDate.getUTCFullYear();
	var iYear = 0;

	oRm.write("<div id=\""+sId+"-years\" class=\"sapUiCalYears\">");

	for ( var i = 0; i < 20; i++) {
		iYear = iCurrentYear - 10 + i;
		oRm.write("<div");
		oRm.writeAttribute("id", sId+"-y"+iYear);
		oRm.addClass("sapUiCalYear");
		if (i == 10) {
			oRm.addClass("sapUiCalYearSel");
		}
		oRm.writeAttribute("tabindex", "-1");
		oRm.writeClasses();
		oRm.write(">"); // div element
		oRm.write(iYear);
		oRm.write("</div>");
	}

	oRm.write("</div>");

};

}; // end of sap/ui/unified/CalendarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ContentSwitcherRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.unified.ContentSwitcherRenderer");

/**
 * @class AnimatedContentSwitcher renderer. 
 * @static
 */
sap.ui.unified.ContentSwitcherRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.unified.ContentSwitcherRenderer.render = function(oRm, oControl){ 
	var sId            = oControl.getId();
	var sAnimation     = oControl.getAnimation();
	if(!sap.ui.getCore().getConfiguration().getAnimation()){
		sAnimation = sap.ui.unified.ContentSwitcherAnimation.None;
	}
	
	var iActiveContent = oControl.getActiveContent();

	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapUiUfdCSwitcher");
	oRm.addClass("sapUiUfdCSwitcherAnimation" + sAnimation);
	oRm.writeClasses();
	oRm.write(">");
	
	oRm.write("<section id=\"" + sId + "-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1" + (iActiveContent == 1 ? " sapUiUfdCSwitcherVisible" : "") +"\">");
	this.renderContent(oRm, oControl.getContent1());
	oRm.write("</section>");
	
	oRm.write("<section id=\"" + sId + "-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2" + (iActiveContent == 2 ? " sapUiUfdCSwitcherVisible" : "") +"\">");
	this.renderContent(oRm, oControl.getContent2());
	oRm.write("</section>");
	
	oRm.write("</div>");
};

sap.ui.unified.ContentSwitcherRenderer.renderContent = function(oRm, aContent) {
	for (var i = 0; i < aContent.length; ++i) {
		oRm.renderControl(aContent[i]);
	}
};
}; // end of sap/ui/unified/ContentSwitcherRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CurrencyRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.Menu
jQuery.sap.declare("sap.ui.unified.CurrencyRenderer");


/**
 * @class Currency renderer.
 *
 * @version 1.24.2
 * @static
 */
sap.ui.unified.CurrencyRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
 * @param {sap.ui.core.Control}
 *            oMenu An object representation of the control that should be rendered
 */
sap.ui.unified.CurrencyRenderer.render = function(oRm,oCurrency) {
	var bHasValue = oCurrency._hasValue();
	oRm.write("<div")
	oRm.writeControlData(oCurrency);
	oRm.addClass("sapUiUfdCurrency");
	if (!oCurrency._hasValue()) {
		oRm.addClass("sapUiUfdCurrencyNoVal");
	}
	oRm.writeClasses();
	oRm.write(">");
	oRm.write("<div");
	oRm.addClass("sapUiUfdCurrencyAlign");
	oRm.writeClasses();
	oRm.write(">");
	oRm.write("<span");
	oRm.addClass("sapUiUfdCurrencyValue");
	oRm.writeClasses();
	oRm.write(">");
	oRm.writeEscaped(oCurrency.getFormattedValue());
	oRm.write("</span>");
	oRm.write("<span");
	oRm.addClass("sapUiUfdCurrencyCurrency");
	oRm.writeClasses();
	oRm.write(">");
	if (oCurrency.getUseSymbol()) {
		oRm.writeEscaped(oCurrency.getCurrencySymbol());
	} else {
		oRm.writeEscaped(oCurrency.getCurrency());
	}
	oRm.write("</span>");
	oRm.write("</div>");
	oRm.write("</div>");
};
}; // end of sap/ui/unified/CurrencyRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.FileUploaderRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.FileUploader
jQuery.sap.declare("sap.ui.unified.FileUploaderRenderer");

/**
 * @class
 * @static
 */
sap.ui.unified.FileUploaderRenderer = function() {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
 */
sap.ui.unified.FileUploaderRenderer.render = function(oRenderManager, oFileUploader) {

	var rm = oRenderManager;
	var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();

	// return immediately if control is invisible
	if (!oFileUploader.getVisible()) {
		return;
	}

	rm.write('<div');
	rm.writeControlData(oFileUploader);
	rm.addClass("sapUiFup");
	rm.writeClasses();
	rm.write('>');

	// form
	rm.write('<form style="display:inline-block" encType="multipart/form-data" method="post"');
	rm.writeAttribute('id', oFileUploader.getId() + '-fu_form');
	rm.writeAttributeEscaped('action', oFileUploader.getUploadUrl());
	rm.writeAttribute('target', oFileUploader.getId() + '-frame');
	rm.write('>');

	// the SAPUI5 TextField and Button
	rm.write('<div class="sapUiFupInp"');
	if (accessibility) {
		rm.writeAttribute("role", "textbox");
		rm.writeAttribute("aria-readonly", "true");
	}
	rm.write('>');

	if (!oFileUploader.getButtonOnly()) {
		rm.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div>');
	} else {
		rm.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div style="display:none">');
	}
	rm.renderControl(oFileUploader.oFilePath);
	rm.write('</div><div>');  //-> per style margin
	rm.renderControl(oFileUploader.oBrowse);
	rm.write('</div></div></div>');

	// hidden pure input type file (surrounded by a div which is responsible for giving the input the correct size)
	var sName = oFileUploader.getName() || oFileUploader.getId();
	rm.write('<div class="sapUiFupInputMask">');
	rm.write('<input type="hidden" name="_charset_">');
	rm.write('<input type="hidden" id="' + oFileUploader.getId() + '-fu_data"');
	rm.writeAttributeEscaped('name', sName + '-data');
	rm.writeAttributeEscaped('value', oFileUploader.getAdditionalData() || "");
	rm.write('>');
	jQuery.each(oFileUploader.getParameters(), function(iIndex, oParam) {
		rm.write('<input type="hidden" ');
		rm.writeAttributeEscaped('name', oParam.getName() || "");
		rm.writeAttributeEscaped('value', oParam.getValue() || "");
		rm.write('>');
	});
	rm.write('</div>');


	rm.write('</div>');
	rm.write('</form>');
	rm.write('</div>');
};
}; // end of sap/ui/unified/FileUploaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.Menu
jQuery.sap.declare("sap.ui.unified.MenuRenderer");


/**
 * @class Menu renderer.
 * @author SAP - TD Core UI&AM UI Infra
 *
 * @version 1.24.2
 * @static
 */
sap.ui.unified.MenuRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
 * @param {sap.ui.core.Control}
 *            oMenu An object representation of the control that should be rendered
 */
sap.ui.unified.MenuRenderer.render = function(rm, oMenu) {
	var colCount = 8;
	
	if(oMenu.oHoveredItem && oMenu.indexOfItem(oMenu.oHoveredItem) < 0){
		//Hover item not valid anymore
		oMenu.oHoveredItem = null;
	}
	
	rm.write("<div tabindex=\"-1\" hideFocus=\"true\"");

	if(oMenu.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oMenu.getTooltip_AsString());
	}

	// ARIA
	var bAccessible = sap.ui.getCore().getConfiguration().getAccessibility();
	if(bAccessible){
		rm.writeAttribute("aria-orientation", "vertical");
		rm.writeAttribute("role", "menu");

		var _getText = function(sKey, aArgs) {
			var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
			if(rb) {
				return rb.getText(sKey, aArgs);
			}
			return sKey;
		};

		rm.writeAttributeEscaped("aria-label", oMenu.getAriaDescription() ? oMenu.getAriaDescription() : _getText("MNU_ARIA_NAME"));
		rm.writeAttribute("aria-level", oMenu.getMenuLevel());
		if(oMenu.oHoveredItem) {
			rm.writeAttribute("aria-activedescendant", oMenu.oHoveredItem.getId());
		}
	}

	rm.addClass("sapUiMnu");
	if(oMenu.getRootMenu().bUseTopStyle){
		rm.addClass("sapUiMnuTop");
	}
	rm.writeClasses();
	rm.writeControlData(oMenu);
	rm.write(">");
	sap.ui.unified.MenuRenderer.renderItems(rm, oMenu);
	rm.write("</div>");
};

sap.ui.unified.MenuRenderer.renderItems = function(rm, oMenu) {
	var aItems = oMenu.getItems();
	var bAccessible = sap.ui.getCore().getConfiguration().getAccessibility();
	
	rm.write("<ul class=\"sapUiMnuLst");

	var bHasIcons = false;
	var bHasSubMenus = false;
	for(var idx=0; idx<aItems.length; idx++){
		if(aItems[idx].getIcon && aItems[idx].getIcon()){
			bHasIcons = true;
		}
		if(aItems[idx].getSubmenu()){
			bHasSubMenus = true;
		}
	}

	if(!bHasIcons) {
		rm.write(" sapUiMnuNoIco");
	}
	if(!bHasSubMenus) {
		rm.write(" sapUiMnuNoSbMnu");
	}

	rm.write("\">");

	var iNumberOfVisibleItems = 0;
	for (var i=0;i<aItems.length;i++) {
		if(aItems[i].getVisible() && aItems[i].render){
			iNumberOfVisibleItems++;
		}
	}

	var index = 0;
	// Menu items
	for (var i=0;i<aItems.length;i++) {
		var oItem = aItems[i];
		if(oItem.getVisible() && oItem.render){
			index++;

			if(oItem.getStartsSection()){
				rm.write("<li ");
				if(bAccessible) {
					rm.write("role=\"separator\" ");
				}
				rm.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");
			}

			oItem.render(rm, oItem, oMenu, {bAccessible: bAccessible, iItemNo: index, iTotalItems: iNumberOfVisibleItems});
		}
	}

	rm.write("</ul>");	
};
}; // end of sap/ui/unified/MenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellOverlayRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.ShellOverlay
jQuery.sap.declare("sap.ui.unified.ShellOverlayRenderer");

/**
 * @class ShellOverlay renderer.
 * @static
 */
sap.ui.unified.ShellOverlayRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
 */
sap.ui.unified.ShellOverlayRenderer.render = function(rm, oControl){
	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapUiUfdShellOvrly");
	if(oControl._opening){
		rm.addClass("sapUiUfdShellOvrlyCntntHidden");
		rm.addClass("sapUiUfdShellOvrlyOpening");
	}
	
	if(oControl._getAnimActive()){
		rm.addClass("sapUiUfdShellOvrlyAnim");
	}
	rm.writeClasses();
	rm.write("><div>");
	
	rm.write("<header class='sapUiUfdShellOvrlyHead'>");
	rm.write("<hr class='sapUiUfdShellOvrlyBrand'/>");
	rm.write("<div class='sapUiUfdShellOvrlyHeadCntnt'>");
	rm.write("<div id='"+oControl.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");
	sap.ui.unified.ShellOverlayRenderer.renderSearch(rm, oControl);
	rm.write("</div>");
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),
		sCloseTxt = rb.getText("SHELL_OVERLAY_CLOSE");
	rm.write("<a tabindex='0' href='javascript:void(0);' id='"+oControl.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");
	rm.writeAttributeEscaped("title", sCloseTxt);
	rm.write(">");
	rm.writeEscaped(sCloseTxt);
	rm.write("</a></div></header>");
	rm.write("<div id='"+oControl.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");
	sap.ui.unified.ShellOverlayRenderer.renderContent(rm, oControl);
	rm.write("</div>");
	
	rm.write("</div></div>");
};

sap.ui.unified.ShellOverlayRenderer.renderSearch = function(rm, oControl) {
	var iWidth = oControl._getSearchWidth();
	var sStyle = "";
	if(iWidth > 0 && oControl._opening){
		sStyle = "style='width:"+iWidth+"px'";
	}
	
	rm.write("<div id='"+oControl.getId()+"-search' class='sapUiUfdShellOvrlySearch' "+sStyle+"><div>");
	var oSearch = oControl.getSearch();
	if(oSearch){
		rm.renderControl(oSearch);
	}
	rm.write("</div></div>");
};

sap.ui.unified.ShellOverlayRenderer.renderContent = function(rm, oControl) {
	rm.write("<div>");
	var aContent = oControl.getContent();
	for(var i=0; i<aContent.length; i++){
		rm.renderControl(aContent[i]);
	}
	rm.write("</div>");
};
}; // end of sap/ui/unified/ShellOverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.Shell
jQuery.sap.declare("sap.ui.unified.ShellRenderer");

/**
 * @class Shell renderer.
 * @static
 */
sap.ui.unified.ShellRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
 */
sap.ui.unified.ShellRenderer.render = function(rm, oShell){
	var id = oShell.getId();

	rm.write("<div");
	rm.writeControlData(oShell);
	rm.addClass("sapUiUfdShell");
	if(oShell._animation){
		rm.addClass("sapUiUfdShellAnim");
	}
	if(oShell.getSearch()){
		rm.addClass("sapUiUfdShellWithSearch");
	}
	if(!oShell.getHeaderVisible()){
		rm.addClass("sapUiUfdShellNoHead");
	}
	rm.addClass("sapUiUfdShellHead"+ (oShell._showHeader ? "Visible" : "Hidden"));
	if(oShell.getShowCurtain()){
		rm.addClass("sapUiUfdShellCurtainVisible");
	}else{
		rm.addClass("sapUiUfdShellCurtainHidden");
		rm.addClass("sapUiUfdShellCurtainClosed");
	}
	
	rm.writeClasses();
	rm.write(">");
	
	rm.write("<hr id='", id, "-brand' class='sapUiUfdShellBrand'/>");
	
	rm.write("<header id='", id, "-hdr'  class='sapUiUfdShellHead'><div>");
	rm.write("<div id='", id, "-hdrcntnt' class='sapUiUfdShellCntnt'>");
	sap.ui.unified.ShellRenderer._renderHeaderContent(rm, oShell);
	rm.write("</div>", "</div>", "</header>");

	rm.write("<section id='", id, "-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");
	rm.write("<div id='", id, "-curtcntnt' class='sapUiUfdShellCntnt'>");
	rm.renderControl(oShell._curtCont);
	rm.write("</div>");
	rm.write("<span id='", id, "-curt-focusDummyOut' tabindex='0'></span>");
	rm.write("</section>");
	
	rm.write("<div id='", id, "-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiUfdShellBackground'>");
	rm.write("<div id='", id, "-strgbg' class='sapUiUfdShellBG"+(oShell._useStrongBG ? " sapMGlobalBackgroundColorStrong" : "")+"'></div>");
	rm.write("<div class='sapMGlobalBackgroundImage sapUiUfdShellBG'></div>");
	rm.renderControl(oShell._cont);
	rm.write("</div>");
	
	rm.write("<span id='", id, "-main-focusDummyOut' tabindex='" + (oShell.getShowCurtain() ? 0 : -1) + "'></span>");
	
	rm.write("</div>");
};

sap.ui.unified.ShellRenderer._renderHeaderContent = function(rm, oShell){
	var id = oShell.getId();

	rm.write("<div id='", id, "-hdr-begin' class='sapUiUfdShellHeadBegin'>");
	sap.ui.unified.ShellRenderer.renderHeaderItems(rm, oShell, true);
	rm.write("</div>");
	
	rm.write("<div id='", id, "-hdr-center' class='sapUiUfdShellHeadCenter'>");
	sap.ui.unified.ShellRenderer.renderSearch(rm, oShell);
	rm.write("</div>");
	
	rm.write("<div id='", id, "-hdr-end' class='sapUiUfdShellHeadEnd'>");
	sap.ui.unified.ShellRenderer.renderHeaderItems(rm, oShell, false);
	rm.write("</div>");
};

sap.ui.unified.ShellRenderer.renderSearch = function(rm, oShell) {
	var oSearch = oShell.getSearch();
	rm.write("<div id='", oShell.getId(), "-hdr-search'");
	rm.writeAttribute("class", "sapUiUfdShellSearch" + (oShell.getSearchVisible() ? "" : " sapUiUfdShellHidden"));
	rm.write("><div>");
	if(oSearch){
		rm.renderControl(oSearch);
	}
	rm.write("</div></div>");
};

sap.ui.unified.ShellRenderer.renderHeaderItems = function(rm, oShell, begin) {
	rm.write("<div class='sapUiUfdShellHeadContainer'>");
	var aItems = begin ? oShell.getHeadItems() : oShell.getHeadEndItems();
	
	for(var i=0; i<aItems.length; i++){
		rm.write("<a tabindex='0' href='javascript:void(0);'");
		rm.writeElementData(aItems[i]);
		rm.addClass("sapUiUfdShellHeadItm");
		if(aItems[i].getStartsSection()){
			rm.addClass("sapUiUfdShellHeadItmDelim");
		}
		if(aItems[i].getShowSeparator()){
			rm.addClass("sapUiUfdShellHeadItmSep");
		}
		if(!aItems[i].getVisible()){
			rm.addClass("sapUiUfdShellHidden");
		}
		if(aItems[i].getSelected()){
			rm.addClass("sapUiUfdShellHeadItmSel");
		}
		if(aItems[i].getShowMarker()){
			rm.addClass("sapUiUfdShellHeadItmMark");
		}
		rm.writeClasses();
		var tooltip = aItems[i].getTooltip_AsString();
		if(tooltip){
			rm.writeAttributeEscaped("title", tooltip);
		}
		rm.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></a>");
	}
	
	var oUser = oShell.getUser();
	if(!begin && oUser){
		rm.write("<a tabindex='0' href='javascript:void(0);'");
		rm.writeElementData(oUser);
		rm.addClass("sapUiUfdShellHeadUsrItm");
		rm.writeClasses();
		var tooltip = oUser.getTooltip_AsString();
		if(tooltip){
			rm.writeAttributeEscaped("title", tooltip);
		}
		rm.write("><span id='", oUser.getId(), "-img' class='sapUiUfdShellHeadUsrItmImg'></span>");
		rm.write("<span id='"+oUser.getId()+"-name' class='sapUiUfdShellHeadUsrItmName'");
		var sUserName = oUser.getUsername() || "";
		rm.writeAttributeEscaped("title", sUserName);
		rm.write(">");
		rm.writeEscaped(sUserName);
		rm.write("</span><span class='sapUiUfdShellHeadUsrItmExp'></span></a>");
	}
	
	rm.write("</div>");
	if(begin){
		sap.ui.unified.ShellRenderer._renderIcon(rm, oShell);
	}
};

sap.ui.unified.ShellRenderer._renderIcon = function(rm, oShell) {
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),
		sLogoTooltip = rb.getText("SHELL_LOGO_TOOLTIP"),
		sIco = oShell._getIcon();
	
	rm.write("<div class='sapUiUfdShellIco'>");
	rm.write("<img id='", oShell.getId(), "-icon'");
	rm.writeAttributeEscaped("title", sLogoTooltip);
	rm.writeAttributeEscaped("alt", sLogoTooltip);
	rm.write("src='");
	rm.writeEscaped(sIco);
	rm.write("' style='", sIco ? "" : "display:none;","'></img>");
	rm.write("</div>");
};

}; // end of sap/ui/unified/ShellRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.SplitContainerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.SplitContainer
jQuery.sap.declare("sap.ui.unified.SplitContainerRenderer");

/**
 * @class SplitContainer renderer.
 * @static
 */
sap.ui.unified.SplitContainerRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
 */
sap.ui.unified.SplitContainerRenderer.render = function(rm, oControl){
	var sId = oControl.getId();

	var bVertical = oControl.getOrientation() == sap.ui.core.Orientation.Vertical;
	
	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapUiUfdSpltCont");
	rm.addClass("sapUiUfdSpltCont" + (bVertical ? "V" : "H"));
	if(sap.ui.getCore().getConfiguration().getAnimation()){
		rm.addClass("sapUiUfdSpltContAnim");
	}

	if(!oControl.getShowSecondaryContent()){
		rm.addClass("sapUiUfdSpltContPaneHidden");
	}
	rm.writeClasses();
	rm.write(">");
	
	var sCanvasId = sId + "-canvas";

	rm.write("<section id='", sCanvasId, "' class='sapUiUfdSpltContCanvas'>");
	this.renderContent(rm, sCanvasId, oControl.getContent(), oControl._bRootContent);
	rm.write("</section>");
	
	var sSidePaneId = sId + "-pane";

	var sWidth = oControl.getShowSecondaryContent() ? oControl.getSecondaryContentSize() : "0";
	rm.write("<aside id='", sSidePaneId, "' style='width:", sWidth, "'");
	rm.addClass("sapUiUfdSpltContPane");
	if(!oControl.getShowSecondaryContent()){
		rm.addClass("sapUiUfdSplitContSecondClosed");
	}
	rm.writeClasses();
	rm.write(">");
	this.renderContent(rm, sSidePaneId, oControl.getSecondaryContent(), oControl._bRootContent);
	rm.write("</aside>");

	rm.write("</div>");
};

sap.ui.unified.SplitContainerRenderer.renderContent = function (rm, sId, aContent, bRootContent) {
	rm.write("<div id='", sId, "cntnt' class='sapUiUfdSpltContCntnt'");
	if(bRootContent){
		rm.writeAttribute("data-sap-ui-root-content", "true"); // see e.g. sap.m.App#onAfterRendering
	}
	rm.write(">");
	for(var i=0; i<aContent.length; i++){
		rm.renderControl(aContent[i]);
	}
	rm.write("</div>");
};

}; // end of sap/ui/unified/SplitContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

/**
 * Initialization Code and shared classes of library sap.ui.unified (1.24.2)
 */
jQuery.sap.declare("sap.ui.unified.library");
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained

/**
 * Unified controls intended for both, mobile and desktop scenarios
 *
 * @namespace
 * @name sap.ui.unified
 * @public
 */


// library dependencies
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained


// delegate further initialization of this library to the Core
sap.ui.getCore().initLibrary({
  name : "sap.ui.unified",
  dependencies : ["sap.ui.core"],
  types: [
    "sap.ui.unified.CalendarDayType",
    "sap.ui.unified.ContentSwitcherAnimation"
  ],
  interfaces: [],
  controls: [
    "sap.ui.unified.Calendar",
    "sap.ui.unified.CalendarLegend",
    "sap.ui.unified.ContentSwitcher",
    "sap.ui.unified.Currency",
    "sap.ui.unified.FileUploader",
    "sap.ui.unified.Menu",
    "sap.ui.unified.Shell",
    "sap.ui.unified.ShellOverlay",
    "sap.ui.unified.SplitContainer"
  ],
  elements: [
    "sap.ui.unified.CalendarLegendItem",
    "sap.ui.unified.DateRange",
    "sap.ui.unified.DateTypeRange",
    "sap.ui.unified.FileUploaderParameter",
    "sap.ui.unified.MenuItem",
    "sap.ui.unified.MenuItemBase",
    "sap.ui.unified.MenuTextFieldItem",
    "sap.ui.unified.ShellHeadItem",
    "sap.ui.unified.ShellHeadUserItem"
  ],
  version: "1.24.2"});

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.unified.CalendarDayType.
jQuery.sap.declare("sap.ui.unified.CalendarDayType");


/**
 * @class Type of a calendar day used for visualization.
 *
 * @version 1.24.2
 * @static
 * @public
 * @since 1.24.0
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.CalendarDayType = {

	/**
	 * Type 01: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type01 : "Type01",

	/**
	 * Type 02: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type02 : "Type02",

	/**
	 * Type 03: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type03 : "Type03",

	/**
	 * Type 04: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type04 : "Type04",

	/**
	 * Type 05: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type05 : "Type05",

	/**
	 * Type 06: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type06 : "Type06",

	/**
	 * Type 07: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type07 : "Type07",

	/**
	 * Type 08: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type08 : "Type08",

	/**
	 * Type 09: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type09 : "Type09",

	/**
	 * Type 10: The semantic meaning must be defined by the application. It can be shown in a legend.
	 * @public
	 */
	Type10 : "Type10"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.unified.ContentSwitcherAnimation.
jQuery.sap.declare("sap.ui.unified.ContentSwitcherAnimation");


/**
 * @class Predefined animations for the ContentSwitcher
 *
 * @version 1.24.2
 * @static
 * @public
 * @since 1.16.0
 * @experimental Since version 1.16.0. 
 * API is not yet finished and might change completely
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.ContentSwitcherAnimation = {

	/**
	 * No animation. Content is switched instantly.
	 * @public
	 */
	None : "None",

	/**
	 * Content is faded (opacity change).
	 * @public
	 */
	Fade : "Fade",

	/**
	 * The new content is "zoomed in" from the center and grows to fill the full content area.
	 * @public
	 */
	ZoomIn : "ZoomIn",

	/**
	 * The old content is "zoomed out", i.e. shrinks to a point at the center of the content area.
	 * @public
	 */
	ZoomOut : "ZoomOut",

	/**
	 * The new content rotates in. (Just like one of those old newspaper-animations.)
	 * @public
	 */
	Rotate : "Rotate",

	/**
	 * The new slides in from the left (to the right).
	 * @public
	 */
	SlideRight : "SlideRight",

	/**
	 * The new content slides in from the left while the old content slides out to the left at the same time.
	 * @public
	 */
	SlideOver : "SlideOver"

};

// -----------------------------------------------------------------------------
// Begin of Library Initialization coding, copied from shared.js
// -----------------------------------------------------------------------------

sap.ui.base.Object.extend("sap.ui.unified._ContentRenderer", {
	constructor : function(oControl, sContentContainerId, oContent, fAfterRenderCallback) {
		sap.ui.base.Object.apply(this);
		this._id = sContentContainerId;
		this._cntnt = oContent;
		this._ctrl = oControl;
		this._rm = sap.ui.getCore().createRenderManager();
		this._cb = fAfterRenderCallback || function(){};
	},
	
	destroy : function() {
		this._rm.destroy();
		delete this._rm;
		delete this._id;
		delete this._cntnt;
		delete this._cb;
		delete this._ctrl;
		if(this._rerenderTimer){
			jQuery.sap.clearDelayedCall(this._rerenderTimer);
			delete this._rerenderTimer;
		}
		sap.ui.base.Object.prototype.destroy.apply(this, arguments);
	},
	
	render : function() {
		if(!this._rm){
			return;
		}
		
		if(this._rerenderTimer){
			jQuery.sap.clearDelayedCall(this._rerenderTimer);
		}
		
		this._rerenderTimer = jQuery.sap.delayedCall(0, this, function(){
			var $content = jQuery.sap.byId(this._id);
			var doRender = $content.length > 0;
			
			if(doRender){
				if(typeof(this._cntnt) === "string"){
					var aContent = this._ctrl.getAggregation(this._cntnt, []);
					for(var i=0; i < aContent.length; i++){
						this._rm.renderControl(aContent[i]);
					}
				}else{
					this._cntnt(this._rm);
				}
				this._rm.flush($content[0]);
			}

			this._cb(doRender);
		});
	}
});


sap.ui.unified._iNumberOfOpenedShellOverlays = 0;

//factory for the FileUploader to create TextField an Button to be overwritten by commons and mobile library
if (!sap.ui.unified.FileUploaderHelper) {
	sap.ui.unified.FileUploaderHelper = {
		createTextField: function(sId){ throw new Error("no TextField control available!"); }, /* must return a TextField control */
		setTextFieldContent: function(oTextField, sWidth){ throw new Error("no TextField control available!"); },
		createButton: function(){ throw new Error("no Button control available!"); }, /* must return a Button control */
		bFinal: false /* if true, the helper must not be overwritten by an other library */
	};
}
}; // end of sap/ui/unified/library.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Calendar') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.Calendar.
jQuery.sap.declare("sap.ui.unified.Calendar");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Calendar.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getIntervalSelection intervalSelection} : boolean (default: false)</li>
 * <li>{@link #getSingleSelection singleSelection} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getSelectedDates selectedDates} : sap.ui.unified.DateRange[]</li>
 * <li>{@link #getSpecialDates specialDates} : sap.ui.unified.DateTypeRange[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.Calendar#event:select select} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.Calendar#event:cancel cancel} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Basic Calendar.
 * This calendar ist used for DatePickers
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.Calendar
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.Calendar", { metadata : {

	publicMethods : [
		// methods
		"focusDate"
	],
	library : "sap.ui.unified",
	properties : {
		"intervalSelection" : {type : "boolean", group : "Misc", defaultValue : false},
		"singleSelection" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	aggregations : {
		"selectedDates" : {type : "sap.ui.unified.DateRange", multiple : true, singularName : "selectedDate"}, 
		"specialDates" : {type : "sap.ui.unified.DateTypeRange", multiple : true, singularName : "specialDate"}
	},
	events : {
		"select" : {}, 
		"cancel" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.Calendar with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.Calendar.extend
 * @function
 */

sap.ui.unified.Calendar.M_EVENTS = {'select':'select','cancel':'cancel'};


/**
 * Getter for property <code>intervalSelection</code>.
 * If set, interval selection is allowed
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>intervalSelection</code>
 * @public
 * @name sap.ui.unified.Calendar#getIntervalSelection
 * @function
 */

/**
 * Setter for property <code>intervalSelection</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bIntervalSelection  new value for property <code>intervalSelection</code>
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#setIntervalSelection
 * @function
 */


/**
 * Getter for property <code>singleSelection</code>.
 * If set, only a single date or interval, if intervalSelection is enabled, can be selected
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>singleSelection</code>
 * @public
 * @name sap.ui.unified.Calendar#getSingleSelection
 * @function
 */

/**
 * Setter for property <code>singleSelection</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bSingleSelection  new value for property <code>singleSelection</code>
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#setSingleSelection
 * @function
 */


/**
 * Getter for aggregation <code>selectedDates</code>.<br/>
 * Date Ranges for selected dates of the DatePicker
 * 
 * @return {sap.ui.unified.DateRange[]}
 * @public
 * @name sap.ui.unified.Calendar#getSelectedDates
 * @function
 */


/**
 * Inserts a selectedDate into the aggregation named <code>selectedDates</code>.
 *
 * @param {sap.ui.unified.DateRange}
 *          oSelectedDate the selectedDate to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the selectedDate should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the selectedDate is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the selectedDate is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#insertSelectedDate
 * @function
 */

/**
 * Adds some selectedDate <code>oSelectedDate</code> 
 * to the aggregation named <code>selectedDates</code>.
 *
 * @param {sap.ui.unified.DateRange}
 *            oSelectedDate the selectedDate to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#addSelectedDate
 * @function
 */

/**
 * Removes an selectedDate from the aggregation named <code>selectedDates</code>.
 *
 * @param {int | string | sap.ui.unified.DateRange} vSelectedDate the selectedDate to remove or its index or id
 * @return {sap.ui.unified.DateRange} the removed selectedDate or null
 * @public
 * @name sap.ui.unified.Calendar#removeSelectedDate
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>selectedDates</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.DateRange[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Calendar#removeAllSelectedDates
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.DateRange</code> in the aggregation named <code>selectedDates</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.DateRange}
 *            oSelectedDate the selectedDate whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Calendar#indexOfSelectedDate
 * @function
 */
	

/**
 * Destroys all the selectedDates in the aggregation 
 * named <code>selectedDates</code>.
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#destroySelectedDates
 * @function
 */


/**
 * Getter for aggregation <code>specialDates</code>.<br/>
 * Date Range with type to visualize special days in the Calendar.
 * If one day is assigned to more than one Type, only the first one will be used.
 * 
 * @return {sap.ui.unified.DateTypeRange[]}
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.Calendar#getSpecialDates
 * @function
 */


/**
 * Inserts a specialDate into the aggregation named <code>specialDates</code>.
 *
 * @param {sap.ui.unified.DateTypeRange}
 *          oSpecialDate the specialDate to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the specialDate should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the specialDate is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the specialDate is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.Calendar#insertSpecialDate
 * @function
 */

/**
 * Adds some specialDate <code>oSpecialDate</code> 
 * to the aggregation named <code>specialDates</code>.
 *
 * @param {sap.ui.unified.DateTypeRange}
 *            oSpecialDate the specialDate to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.Calendar#addSpecialDate
 * @function
 */

/**
 * Removes an specialDate from the aggregation named <code>specialDates</code>.
 *
 * @param {int | string | sap.ui.unified.DateTypeRange} vSpecialDate the specialDate to remove or its index or id
 * @return {sap.ui.unified.DateTypeRange} the removed specialDate or null
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.Calendar#removeSpecialDate
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>specialDates</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.DateTypeRange[]} an array of the removed elements (might be empty)
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.Calendar#removeAllSpecialDates
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.DateTypeRange</code> in the aggregation named <code>specialDates</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.DateTypeRange}
 *            oSpecialDate the specialDate whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.Calendar#indexOfSpecialDate
 * @function
 */
	

/**
 * Destroys all the specialDates in the aggregation 
 * named <code>specialDates</code>.
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.Calendar#destroySpecialDates
 * @function
 */


/**
 * Date selection changed
 *
 * @name sap.ui.unified.Calendar#select
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'select' event of this <code>sap.ui.unified.Calendar</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.Calendar</code>.<br/> itself. 
 *  
 * Date selection changed
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.Calendar</code>.<br/> itself.
 *
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#attachSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'select' event of this <code>sap.ui.unified.Calendar</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#detachSelect
 * @function
 */

/**
 * Fire event select to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.Calendar#fireSelect
 * @function
 */


/**
 * Date selection was cancelled
 *
 * @name sap.ui.unified.Calendar#cancel
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'cancel' event of this <code>sap.ui.unified.Calendar</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.Calendar</code>.<br/> itself. 
 *  
 * Date selection was cancelled
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.Calendar</code>.<br/> itself.
 *
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#attachCancel
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'cancel' event of this <code>sap.ui.unified.Calendar</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Calendar#detachCancel
 * @function
 */

/**
 * Fire event cancel to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.Calendar#fireCancel
 * @function
 */


/**
 * Sets the focused date of the calendar.
 *
 * @name sap.ui.unified.Calendar#focusDate
 * @function
 * @param {object} oDate
 *         JavaScript date object for focused date.
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\unified\Calendar.js
jQuery.sap.require('sap.ui.core.LocaleData'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained

jQuery.sap.require('sap.ui.model.type.Date'); // unlisted dependency retained


/*
 * There are different modes (stored in this._iMode)
 * The standard is 0, that means a calendar showing a calendar with the days of one month.
 * If 1 a month picker is shown.
 * if 2 a year picker is shown.
 */

(function() {

	sap.ui.unified.Calendar.prototype.init = function(){

		this._mouseMoveProxy = jQuery.proxy(this._handleMouseMove, this);

		this._iMode = 0; // days are shown

		this._oFormatYyyymmdd = sap.ui.core.format.DateFormat.getInstance({pattern: "yyyyMMdd"});

	};

	sap.ui.unified.Calendar.prototype.exit = function(){

		if (this._sRenderMonth) {
			jQuery.sap.clearDelayedCall(this._sRenderMonth);
		}

	};

//	sap.ui.unified.Calendar.prototype.onBeforeRendering = function(){
//	};

	sap.ui.unified.Calendar.prototype.onAfterRendering = function(){

		var that = this;

		_initItemNavigation(that);

		// check if day names and month names are too big -> use smaller ones
		_checkNamesLength(that);

	};

	// overwrite invalidate to recognize changes on selectedDates
	sap.ui.unified.Calendar.prototype.invalidate = function(oOrigin) {

		if(!oOrigin || !(oOrigin instanceof sap.ui.unified.DateRange)){
			sap.ui.core.Control.prototype.invalidate.apply(this, arguments);
		} else if (this.getDomRef() && this._iMode == 0 && !this._sRenderMonth) {
			// DateRange changed -> only rerender days
			// do this only once if more DateRanges / Special days are changed
			var that = this;
			this._sRenderMonth = jQuery.sap.delayedCall(0, this, _renderMonth, [that]);
		}

	};

	/**
	 * sets the locale for the DatePicker
	 * only for internal use
	 * @param {string} sLocale  new value for <code>locale</code>
	 * @returns {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
	 * @private
	 */
	sap.ui.unified.Calendar.prototype.setLocale = function(sLocale){

			if (this._sLocale != sLocale) {
				this._sLocale = sLocale;
				this._oLocaleData = undefined;
				this.invalidate();
			}

			return this;

	};

	/**
	 * gets the used locale for the DatePicker
	 * only for internal use
	 * @return {string} sLocale
	 * @private
	 */
	sap.ui.unified.Calendar.prototype.getLocale = function(){

			if (!this._sLocale) {
				this._sLocale = sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();
			}

			return this._sLocale;

	};

	sap.ui.unified.Calendar.prototype._getFocusedDate = function(){

		if (!this._oFocusedDate) {
			var that = this;
			_determineFocusedDate(that);
		}

		return this._oFocusedDate;

	};

	sap.ui.unified.Calendar.prototype._setFocusedDate = function(oDate){

		this._oFocusedDate = new Date(oDate);

	};

	sap.ui.unified.Calendar.prototype.focusDate = function(oDate){

		if (oDate && !this._oFocusedDate || this._oFocusedDate.getTime() != oDate.getTime()) {
			this._setFocusedDate(_createUTCDate(oDate));

			if (this.getDomRef() && this._iMode == 0) {
				var that = this;
				_renderMonth(that);
			}
		}

	};

	/**
	 * sets the Popup mode
	 * e.G. Tab-chain should not leave calendar
	 * only for internal use
	 * @param {boolean} bPoupupMode <code>PopupMode</code>
	 * @private
	 */
	sap.ui.unified.Calendar.prototype.setPopupMode = function(bPoupupMode){

		this._bPoupupMode = bPoupupMode;

	};

	/*
	 * gets localeData for used locale
	 * if no locale is given use rendered one
	 */
	sap.ui.unified.Calendar.prototype._getLocaleData = function(){

		if (!this._oLocaleData) {
			var sLocale = this.getLocale();
			var oLocale = new sap.ui.core.Locale(sLocale);
			this._oLocaleData = sap.ui.core.LocaleData.getInstance(oLocale);
		}

		return this._oLocaleData;

	};

	sap.ui.unified.Calendar.prototype.onclick = function(oEvent){

		if (oEvent.isMarked("delayedMouseEvent") ) {
			return;
		}

		var that = this;
		var oFocusedDate = this._getFocusedDate();

		if (jQuery.sap.containsOrEquals(this.getDomRef("next"), oEvent.target)) {
			switch (this._iMode) {
			case 0: // day picker
				oFocusedDate.setUTCMonth(oFocusedDate.getUTCMonth()+1, 1);
				_renderMonth(that);
				break;

			case 1: // month picker
				oFocusedDate.setUTCFullYear(oFocusedDate.getUTCFullYear()+1);
				this.$("year").text(oFocusedDate.getUTCFullYear());
				break;

			case 2: // year picker
				_updateYears(that, true, this._oItemNavigation.getFocusedIndex());
				break;
			// no default
			}
		} else if (jQuery.sap.containsOrEquals(this.getDomRef("prev"), oEvent.target)) {
			switch (this._iMode) {
			case 0: // day picker
				oFocusedDate.setUTCDate(1);
				oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()-1);
				_renderMonth(that);
				break;

			case 1: // month picker
				oFocusedDate.setUTCFullYear(oFocusedDate.getUTCFullYear()-1);
				this.$("year").text(oFocusedDate.getUTCFullYear());
				break;

			case 2: // year picker
				_updateYears(that, false, this._oItemNavigation.getFocusedIndex());
				break;
			// no default
			}
		} else if (oEvent.target.id == this.getId()+"-month") {
			if (this._iMode != 1) {
				_showMonthPicker(that);
			}else {
				_hideMonthPicker(that);
			}
			// add ItemNavigation again (might be removed by Tab)
			this.addDelegate(this._oItemNavigation);
		} else if (oEvent.target.id == this.getId()+"-year") {
			if (this._iMode != 2) {
				_showYearPicker(that);
			}else {
				_hideYearPicker(that);
			}
			// add ItemNavigation again (might be removed by Tab)
			this.addDelegate(this._oItemNavigation);
		} else if (oEvent.target.id == this.getId()+"-cancel") {
			this.onsapescape(oEvent);
		}

	};

	sap.ui.unified.Calendar.prototype._handleMouseMove = function(oEvent){

		if (!this.$().is(":visible")) {
			// calendar was closed -> remove mousemove handler
			jQuery(window.document).unbind('mousemove', this._mouseMoveProxy);
			this._bMouseMove = undefined;
		}

		var $Target = jQuery(oEvent.target);

		if ($Target.hasClass("sapUiCalDayNum")) {
			$Target = $Target.parent();
		}

		if ($Target.hasClass("sapUiCalDay")) {
			var oFocusedDate = this._getFocusedDate();
			var oOldFocusedDate = oFocusedDate;
			oFocusedDate = this._oFormatYyyymmdd.parse($Target.attr("data-sap-day"), true);
			this._setFocusedDate(oFocusedDate);

			if (oFocusedDate.getTime() != oOldFocusedDate.getTime()) {
				var that = this;
				if ($Target.hasClass("sapUiCalDayOtherMonth")) {
					// in other month -> change month
					_renderMonth(that);
				}else {
					_selectDay(that, oFocusedDate, false, true);
					this._bMoveChange = true;
				}

			}
		}

	};

	sap.ui.unified.Calendar.prototype.onmouseup = function(oEvent){

		if (this._bMouseMove) {
			jQuery(window.document).unbind('mousemove', this._mouseMoveProxy);
			this._bMouseMove = undefined;

			// focus now selected day
			var oFocusedDate = this._getFocusedDate();
			var aDomRefs = this.$("days").children(".sapUiCalDay");

			for ( var i = 0; i < aDomRefs.length; i++) {
				var $DomRef = jQuery(aDomRefs[i]);
				if (!$DomRef.hasClass("sapUiCalDayOtherMonth")) {
					if ($DomRef.attr("data-sap-day") == this._oFormatYyyymmdd.format(oFocusedDate, true)) {
						$DomRef.focus();
						break;
					}
				}
			}

			if (this._bMoveChange) {
				// selection was changed -> make it final
				var that = this;
				_selectDay(that, oFocusedDate);
				this._bMoveChange = false;
				_fireSelect(that);
			}
		}

	};
/*
	sap.ui.unified.Calendar.prototype.onswipeleft = function(oEvent) {

		var that = this;
		var oFocusedDate = this._getFocusedDate();

		oFocusedDate.setUTCMonth(oFocusedDate.getUTCMonth()+1, 1);
		_renderMonth(that);

	};

	sap.ui.unified.Calendar.prototype.onswiperight = function(oEvent) {

		var that = this;
		var oFocusedDate = this._getFocusedDate();

		oFocusedDate.setUTCDate(1);
		oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()-1);
		_renderMonth(that);

	};
*/
	sap.ui.unified.Calendar.prototype.onsapselect = function(oEvent){

		// focused item must be selected
		var that = this;
		var iIndex = 0;

		switch (this._iMode) {
		case 0: // day picker
			if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target)) {
				_selectDay(that, that._getFocusedDate());
				_fireSelect(that);

				//to prevent bubbling into input field if in DatePicker
				oEvent.stopPropagation();
				oEvent.preventDefault();
			}
			break;

		case 1: // month picker
			if (jQuery.sap.containsOrEquals(this.getDomRef("months"), oEvent.target)) {
				iIndex = this._oItemNavigation.getFocusedIndex();
				_selectMonth(that, iIndex);
			}
			break;

		case 2: // year picker
			if (jQuery.sap.containsOrEquals(this.getDomRef("years"), oEvent.target)) {
				iIndex = this._oItemNavigation.getFocusedIndex();
				_selectYear(that, iIndex);
			}
			break;
		// no default
		}

	};

	sap.ui.unified.Calendar.prototype.onsapselectmodifiers = function(oEvent){

//		// focused item must be selected
//		var that = this;
//		_selectDay(that, new Date(this._getFocusedDate().getTime()), oEvent.shiftKey);
//		_fireSelect(that)
//
//		//to prevent bubbling into input field if in DatePicker
//		oEvent.stopPropagation();
//		oEvent.preventDefault();
		this.onsapselect(oEvent);

	};

	sap.ui.unified.Calendar.prototype.onsapescape = function(oEvent){

		var that = this;

		switch (this._iMode) {
		case 0: // day picker
			this.fireCancel();
			break;

		case 1: // month picker
			_hideMonthPicker(that);
			break;

		case 2: // year picker
			_hideYearPicker(that);
			break;
		// no default
		}

	};

	sap.ui.unified.Calendar.prototype.onsapshow = function(oEvent){

		if (this._bPoupupMode) {
			var that = this;
			switch (this._iMode) {
			case 1: // month picker
				_hideMonthPicker(that);
				break;

			case 2: // year picker
				_hideYearPicker(that);
				break;
			// no default
			}
			this.fireCancel();

			oEvent.preventDefault(); // otherwise IE opens the address bar history

		}

	};

	sap.ui.unified.Calendar.prototype.onsaphide = sap.ui.unified.Calendar.prototype.onsapshow;

	sap.ui.unified.Calendar.prototype.onsappageupmodifiers = function(oEvent){

		// not handled by ItemNavigation
		if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target)) {
			// go one year back
			var oFocusedDate = this._getFocusedDate();
			var that = this;
			var iYear = oFocusedDate.getUTCFullYear();

			if (oEvent.metaKey || oEvent.ctrlKey) {
				oFocusedDate.setUTCFullYear(iYear - 10);
			} else {
				oFocusedDate.setUTCFullYear(iYear-1);
			}
			_renderMonth(that);
		}

		// cancel the event otherwise the browser select some text
		oEvent.preventDefault();

	};

	sap.ui.unified.Calendar.prototype.onsappagedownmodifiers = function(oEvent){

		// not handled by ItemNavigation
		if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target)) {
			// go one year forward
			var oFocusedDate = this._getFocusedDate();
			var that = this;
			var iYear = oFocusedDate.getUTCFullYear();

			if (oEvent.metaKey || oEvent.ctrlKey) {
				oFocusedDate.setUTCFullYear(iYear + 10);
			} else {
				oFocusedDate.setUTCFullYear(iYear+1);
			}
			_renderMonth(that);
		}

		// cancel the event otherwise the browser select some text
		oEvent.preventDefault();

	};

	sap.ui.unified.Calendar.prototype.onsappageup = function(oEvent){

		if(oEvent.target.id == this.getId()+"-month" || oEvent.target.id == this.getId()+"-year"){
			//prevent browser scrolling
			oEvent.preventDefault();
		}

	};

	sap.ui.unified.Calendar.prototype.onsappagedown = sap.ui.unified.Calendar.prototype.onsappageup;

	sap.ui.unified.Calendar.prototype.onsaptabnext = function(oEvent){

		// if tab was pressed on a day it should jump to the month and then to the year button

		if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target) ||
		    jQuery.sap.containsOrEquals(this.getDomRef("months"), oEvent.target) ||
		    jQuery.sap.containsOrEquals(this.getDomRef("years"), oEvent.target)) {
			// tab from a day
			jQuery.sap.focus(this.getDomRef("month"));

			if (!this._bPoupupMode) {
				// remove Tabindex from day - to break cycle
				jQuery(this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");
			}

			// remove ItemNavigation to prevent arrow navigation on buttons
			this.removeDelegate(this._oItemNavigation);

			oEvent.preventDefault();
		}else if(oEvent.target.id == this.getId()+"-month"){
			jQuery.sap.focus(this.getDomRef("year"));

			// remove ItemNavigation to prevent arrow navigation on buttons
			this.removeDelegate(this._oItemNavigation);

			oEvent.preventDefault();
		}else if(oEvent.target.id == this.getId()+"-year"){
			// add ItemNavigation again
			this.addDelegate(this._oItemNavigation);
		}

	};

	sap.ui.unified.Calendar.prototype.onsaptabprevious = function(oEvent){

		if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target) ||
		    jQuery.sap.containsOrEquals(this.getDomRef("months"), oEvent.target) ||
		    jQuery.sap.containsOrEquals(this.getDomRef("years"), oEvent.target)) {
			// tab from a day
			if (this._bPoupupMode) {
				jQuery.sap.focus(this.getDomRef("year"));

				// remove ItemNavigation to prevent arrow navigation on buttons
				this.removeDelegate(this._oItemNavigation);

				oEvent.preventDefault();
			}
		}else if(oEvent.target.id == this.getId()+"-month"){
			// add ItemNavigation again
			this.addDelegate(this._oItemNavigation);
			this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());

			oEvent.preventDefault();
		}else if(oEvent.target.id == this.getId()+"-year"){
			jQuery.sap.focus(this.getDomRef("month"));

			oEvent.preventDefault();
		}

	};

	sap.ui.unified.Calendar.prototype.onsapnext = function(oEvent){

		if(oEvent.target.id == this.getId()+"-month" || oEvent.target.id == this.getId()+"-year"){
			//prevent browser scrolling
			oEvent.preventDefault();
		}

	};

	sap.ui.unified.Calendar.prototype.onsapprevious = sap.ui.unified.Calendar.prototype.onsapnext;

	sap.ui.unified.Calendar.prototype.onfocusin = function(oEvent){

		if(oEvent.target.id == this.getId()+"-end"){
			// focus via tab+shift (otherwise not possible to go to this element)
			jQuery.sap.focus(this.getDomRef("year"));

			// remove Tabindex from day - to break cycle
			jQuery(this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");

			// remove ItemNavigation to prevent arrow navigation on buttons
			this.removeDelegate(this._oItemNavigation);
		}

		// remove tabindex of dummy element if focus is inside calendar
		jQuery.sap.byId(this.getId()+"-end").attr("tabindex", "-1");

	};

	sap.ui.unified.Calendar.prototype.onsapfocusleave = function(oEvent){

		if (!oEvent.relatedControlId || !jQuery.sap.containsOrEquals(this.getDomRef(), sap.ui.getCore().byId(oEvent.relatedControlId).getFocusDomRef())) {
			// put dummy element back to tab-chain
			jQuery.sap.byId(this.getId()+"-end").attr("tabindex", "0");
			// add ItemNavigation again
			this.addDelegate(this._oItemNavigation);
		}

	};

	/*
	 * Checks if a date is selected and what kind of selected
	 * @return {int} iSelected 0: not selected; 1: single day selected, 2: interval start, 3: interval end, 4: interval between
	 * @private
	 */
	sap.ui.unified.Calendar.prototype._checkDateSelected = function(oDate){

		jQuery.sap.assert(oDate instanceof Date, "Date must be a JavaScript date object");

		var iSelected = 0;
		var aSelectedDates = this.getSelectedDates();
		var oTimeStamp = oDate.getTime();

		for ( var i = 0; i < aSelectedDates.length; i++) {
			// initalize the time part of the start and end time
			var oRange = aSelectedDates[i];
			var oTmpDate = _createUTCDate(oRange.getStartDate());
			var oStartDate;
			var oStartTimeStamp = 0;
			if (oTmpDate) {
				oStartDate = oTmpDate;
				oStartTimeStamp = oStartDate.getTime();
			}
			var oEndDate;
			var oEndTimeStamp = 0;
			if (this.getIntervalSelection()) {
				oTmpDate = _createUTCDate(oRange.getEndDate());
				if (oTmpDate) {
					oEndDate = oTmpDate;
					oEndTimeStamp = oEndDate.getTime();
				}
			}

			if (oTimeStamp == oStartTimeStamp && !oEndDate ) {
				iSelected = 1; // single day selected
				break;
			}else if (oTimeStamp == oStartTimeStamp && oEndDate ) {
				iSelected = 2; // interval start
				if (oEndDate && oTimeStamp == oEndTimeStamp) {
					// one day interval
					iSelected = 5;
				}
				break;
			}else if (oEndDate && oTimeStamp == oEndTimeStamp) {
				iSelected = 3; // interval end
				break;
			}else if (oEndDate && oTimeStamp > oStartTimeStamp && oTimeStamp < oEndTimeStamp) {
				iSelected = 4; // interval between
				break;
			}

			if (this.getSingleSelection()) {
				// if single selection only check the first range
				break;
			}
		}

		return iSelected;

	};

	/*
	 * gets the type of a single date checking the specialDates aggregation
	 * the first hit is used
	 * @return {object} date type and tooltip defined in CalendarDayType
	 * @private
	 */
	sap.ui.unified.Calendar.prototype._getDateType = function(oDate){

		jQuery.sap.assert(oDate instanceof Date, "Date must be a JavaScript date object");

		var oType;
		var aSpecialDates = this.getSpecialDates();
		var oTimeStamp = oDate.getTime();

		for ( var i = 0; i < aSpecialDates.length; i++) {
			// initialize the time part of the start and end time
			var oRange = aSpecialDates[i];
			var oTmpDate = _createUTCDate(oRange.getStartDate());
			var oStartDate;
			var oStartTimeStamp = 0;
			if (oTmpDate) {
				oStartDate = oTmpDate;
				oStartTimeStamp = oStartDate.getTime();
			}
			var oEndDate;
			var oEndTimeStamp = 0;
			oTmpDate = _createUTCDate(oRange.getEndDate());
			if (oTmpDate) {
				oEndDate = oTmpDate;
				oEndTimeStamp = oEndDate.getTime();
			}

			if ((oTimeStamp == oStartTimeStamp && !oEndDate) || (oTimeStamp >= oStartTimeStamp && oTimeStamp <= oEndTimeStamp)) {
				oType = {type: oRange.getType(), tooltip: oRange.getTooltip_AsString()};
				break;
			}
		}

		return oType;

	};

	function _handleAfterFocus(oControlEvent){

		var iIndex = oControlEvent.getParameter("index");
		var oEvent = oControlEvent.getParameter("event");

		if (!oEvent) {
			return; // happens if focus is set via ItemNavigation.focusItem directly
		}

		var that = this;
		var oFocusedDate = this._getFocusedDate();

		if (this._iMode == 0) {
			// day picker

			var aDomRefs = this.$("days").children(".sapUiCalDay");
			var i = 0;

			// find out what day was focused
			var $DomRef = jQuery(aDomRefs[iIndex]);
			var $DomRefDay;
			if ($DomRef.hasClass("sapUiCalDayOtherMonth")) {
				if (oEvent.type == "saphomemodifiers" && (oEvent.metaKey || oEvent.ctrlKey)) {
					// on ctrl+home key focus first day of month
					oFocusedDate.setUTCDate(1);
					for ( i = 0; i < aDomRefs.length; i++) {
						$DomRefDay = jQuery(aDomRefs[i]);
						if (this._oFormatYyyymmdd.parse($DomRefDay.attr("data-sap-day"), true).getUTCDate() == 1) {
							this._oItemNavigation.focusItem(i);
							break;
						}
					}
				} else if(oEvent.type == "sapendmodifiers" && (oEvent.metaKey || oEvent.ctrlKey)) {
					// on ctrl+end key focus last day of month
					for ( i = aDomRefs.length - 1; i > 0 ; i--) {
						$DomRefDay = jQuery(aDomRefs[i]);
						if (!$DomRefDay.hasClass("sapUiCalDayOtherMonth")) {
							oFocusedDate = this._oFormatYyyymmdd.parse($DomRefDay.attr("data-sap-day"), true);
							this._setFocusedDate(oFocusedDate);
							this._oItemNavigation.focusItem(i);
							break;
						}
					}
				} else {
					// switch to the requested month and focus the chosen day
					oFocusedDate = this._oFormatYyyymmdd.parse($DomRef.attr("data-sap-day"), true);
					this._setFocusedDate(oFocusedDate);
					_renderMonth(that);
				}
			}else {
				// day in current month focused
				if (!jQuery(oEvent.target).hasClass("sapUiCalWeekNum")) {
					// not if clicked on week number
					oFocusedDate = this._oFormatYyyymmdd.parse($DomRef.attr("data-sap-day"), true);
					this._setFocusedDate(oFocusedDate);
				}
			}
		}

		if (oEvent.type == "mousedown") {
			// as no click event is fired in some cases, e.g. if month is changed (because of changing DOM) select the day on mousedown
			_handleMousedown(that, oEvent, oFocusedDate, iIndex);
		}

	}

	function _handleFocusAgain(oControlEvent){

		var iIndex = oControlEvent.getParameter("index");
		var oEvent = oControlEvent.getParameter("event");

		if (!oEvent) {
			return; // happens if focus is set via ItemNavigation.focusItem directly
		}

		if (oEvent.type == "mousedown") {
			// as no click event is fired in some cases, e.g. if month is changed (because of changing DOM) select the day on mousedown
			var that = this;
			var oFocusedDate = this._getFocusedDate();
			_handleMousedown(that, oEvent, oFocusedDate, iIndex);
		}

	}

	function _handleMousedown(oThis, oEvent, oFocusedDate, iIndex){

			switch (oThis._iMode) {
			case 0: // day picker
				_selectDay(oThis, oFocusedDate, oEvent.shiftKey);
				_fireSelect(oThis);
				if (oThis.getIntervalSelection() && oThis.$().is(":visible")) {
					// if calendar was closed in select event, do not add mousemove handler
					jQuery(window.document).bind('mousemove', oThis._mouseMoveProxy);
					oThis._bMouseMove = true;
				}
				break;

			case 1: // month picker
				_selectMonth(oThis, iIndex);
				break;

			case 2: // year picker
				_selectYear(oThis, iIndex);
				break;
			// no default
			}
			oEvent.preventDefault(); // to prevent focus set outside of DatePicker
			oEvent.setMark("cancelAutoClose");

	}

	function _handleBorderReached(oControlEvent){

		var oEvent = oControlEvent.getParameter("event");
		var iMonth = 0;
		var oFocusedDate = this._getFocusedDate();

		if (oEvent.type) {
			var that = this;

			switch (this._iMode) {
			case 0: // day picker
				switch (oEvent.type) {
				case "sapnext":
				case "sapnextmodifiers":
					// last day in month reached
					if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) {
						//goto same day next week
						oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()+7);
					} else {
						//go to next day
						oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()+1);
					}
					break;

				case "sapprevious":
				case "sappreviousmodifiers":
					// first day in month reached
					if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) {
						//goto same day previous week
						oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()-7);
					} else {
						//go to previous day
						oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()-1);
					}
					break;

				case "sappagedown":
					// go to same day next month
					iMonth = oFocusedDate.getUTCMonth()+1;
					oFocusedDate.setUTCMonth(iMonth);
					// but if the day doesn't exist in this month, go to last day of the month
					if (iMonth%12 != oFocusedDate.getUTCMonth()) {
						while (iMonth != oFocusedDate.getUTCMonth()) {
							oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()-1);
						}
					}
					break;

				case "sappageup":
					// go to same day previous month
					iMonth = oFocusedDate.getUTCMonth()-1;
					oFocusedDate.setUTCMonth(iMonth);
					if (iMonth < 0) {
						iMonth = 11;
					}
					// but if the day doesn't exist in this month, go to last day of the month
					if (iMonth != oFocusedDate.getUTCMonth()) {
						while (iMonth != oFocusedDate.getUTCMonth()) {
							oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()-1);
						}
					}
					break;

				default:
					break;
				}

				_renderMonth(that);
				break;

			case 1: // month picker
				break;

			case 2: // year picker
				switch (oEvent.type) {
				case "sapnext":
				case "sapnextmodifiers":
					if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) {
						//same column in first row of next group
						_updateYears(that, true, this._oItemNavigation.getFocusedIndex() - 16);
					} else {
						// first year in next group
						_updateYears(that, true, 0);
					}
					break;

				case "sapprevious":
				case "sappreviousmodifiers":
					if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) {
						//same column in last row of previous group
						_updateYears(that, false, 16 + this._oItemNavigation.getFocusedIndex());
					} else {
						// last year in previous group
						_updateYears(that, false, 19);
					}
					break;

				case "sappagedown":
					// same index in next group
					_updateYears(that, true, this._oItemNavigation.getFocusedIndex());
					break;

				case "sappageup":
					// same index in previous group
					_updateYears(that, false, this._oItemNavigation.getFocusedIndex());
					break;

				default:
					break;
				}
				break;
			// no default
			}
		}

	}

	function _initItemNavigation(oThis){

		var oDate = oThis._getFocusedDate();
		var sYyyymmdd = oThis._oFormatYyyymmdd.format(oDate, true);
		var aDomRefs = [];
		var oRootDomRef;
		var iIndex = 0;
		var iColumns = 0;
		var bNoColumnChange = false;
		var bCycling = true;

		switch (oThis._iMode) {
		case 0: // day picker
			oRootDomRef = oThis.$("days").get(0);
			aDomRefs = oThis.$("days").children(".sapUiCalDay");

			for ( var i = 0; i < aDomRefs.length; i++) {
				var $DomRef = jQuery(aDomRefs[i]);
				if ($DomRef.attr("data-sap-day") === sYyyymmdd) {
					iIndex = i;
				}
			}

			iColumns = 7;
			bNoColumnChange = true;
			bCycling = false;

			break;

		case 1: // month picker
			oRootDomRef = oThis.$("months").get(0);
			aDomRefs = oThis.$("months").children(".sapUiCalMonth");
			iIndex = oDate.getUTCMonth();

			iColumns = 3;

			break;

		case 2: // year picker
			oRootDomRef = oThis.$("years").get(0);
			aDomRefs = oThis.$("years").children(".sapUiCalYear");
			iIndex = 10;

			iColumns = 4;
			bNoColumnChange = true;
			bCycling = false;

			break;
		// no default
		}


		if (!oThis._oItemNavigation) {
			oThis._oItemNavigation = new sap.ui.core.delegate.ItemNavigation();
			oThis._oItemNavigation.attachEvent(sap.ui.core.delegate.ItemNavigation.Events.AfterFocus, _handleAfterFocus, oThis);
			oThis._oItemNavigation.attachEvent(sap.ui.core.delegate.ItemNavigation.Events.FocusAgain, _handleFocusAgain, oThis);
			oThis._oItemNavigation.attachEvent(sap.ui.core.delegate.ItemNavigation.Events.BorderReached, _handleBorderReached, oThis);
			oThis.addDelegate(oThis._oItemNavigation);
			oThis._oItemNavigation.setHomeEndColumnMode(true, true);
			oThis._oItemNavigation.setDisabledModifiers({
				sapnext : ["alt"],
				sapprevious : ["alt"],
				saphome : ["alt"],
				sapend : ["alt"]
			});
		}
		oThis._oItemNavigation.setRootDomRef(oRootDomRef);
		oThis._oItemNavigation.setItemDomRefs(aDomRefs);
		oThis._oItemNavigation.setCycling(bCycling);
		oThis._oItemNavigation.setColumns(iColumns, bNoColumnChange);
		oThis._oItemNavigation.setFocusedIndex(iIndex);
		oThis._oItemNavigation.setPageSize(aDomRefs.length); // to make sure that pageup/down goes out of month

	}

	function _renderMonth(oThis){

		this._sRenderMonth = undefined; // initialize delayed call

		var oDate = oThis._getFocusedDate();
		var $Container = oThis.$("days");

		if ($Container.length > 0) {
			var oRm = sap.ui.getCore().createRenderManager();
			oThis.getRenderer().renderDays(oRm, oThis, oDate);
			oRm.flush($Container[0]);
			oRm.destroy();
		}

		// fire internal event for DatePicker for with number of rendered days. If Calendar becomes larger maybe popup must change position
		oThis.fireEvent("_renderMonth", {days: $Container.children(".sapUiCalDay").length})

		// change month and year
		var aMonthNames = [];
		if (oThis._bLongMonth || !oThis._bNamesLengthChecked) {
			aMonthNames = oThis._getLocaleData().getMonthsStandAlone("wide");
		} else {
			aMonthNames = oThis._getLocaleData().getMonthsStandAlone("abbreviated");
		}
		oThis.$("month").text(aMonthNames[oDate.getUTCMonth()]);
		oThis.$("year").text(oDate.getUTCFullYear());

		_initItemNavigation(oThis);
		oThis._oItemNavigation.focusItem(oThis._oItemNavigation.getFocusedIndex());

	}



	/**
	 * Creates a Date in local timezone from UTC timezone
	 * @param {Date} oDate in UTC timezone
	 * @return {Date} in local timezone
	 * @private
	 */
	function _createLocalDate(oDate) {
		if (oDate) {
			return new Date(oDate.getTime() + oDate.getTimezoneOffset() * 60000);
		}
	}

	/**
	 * Creates a Date in UTC timezone from local timezone
	 * @param {Date} oDate in local timezone
	 * @return {Date} in UTC timezone
	 * @private
	 */
	function _createUTCDate(oDate) {
		if (oDate) {
			return new Date(Date.UTC(oDate.getFullYear(),oDate.getMonth(),oDate.getDate()));
		}

	}

	function _selectDay(oThis, oDate, bIntervalEnd, bMove){

		var aSelectedDates = oThis.getSelectedDates();
		var oDateRange;
		var aDomRefs = oThis.$("days").children(".sapUiCalDay");
		var $DomRef;
		var sYyyymmdd;
		var i = 0;
		if (oThis.getSingleSelection()) {
			var oStartDate;

			if (aSelectedDates.length > 0) {
				oDateRange = aSelectedDates[0];
				oStartDate = _createUTCDate(oDateRange.getStartDate());
			} else{
				oDateRange = new sap.ui.unified.DateRange();
				oThis.addAggregation("selectedDates", oDateRange, true); // no re-rendering
			}

			if (oThis.getIntervalSelection()/* && bIntervalEnd*/ && (!oDateRange.getEndDate() || bMove) && oStartDate) {
				// single interval selection
				var oEndDate;
				if (oDate.getTime() < oStartDate.getTime()) {
					oEndDate= oStartDate;
					oStartDate = oDate;
					if (!bMove) {
						// in move mode do not set date. this bring broblems if on backward move the start date would be cahnged
						oDateRange.setProperty("startDate", _createLocalDate(oStartDate), true); // no-rerendering
						oDateRange.setProperty("endDate", _createLocalDate(oEndDate), true); // no-rerendering
					}
				}else if (oDate.getTime() >= oStartDate.getTime()) {
					// single day ranges are allowed
					oEndDate = oDate;
					if (!bMove) {
						oDateRange.setProperty("endDate", _createLocalDate(oEndDate), true); // no-rerendering
					}
				}

				var oDay;
				for ( i = 0; i < aDomRefs.length; i++) {
					$DomRef = jQuery(aDomRefs[i]);
					oDay = oThis._oFormatYyyymmdd.parse($DomRef.attr("data-sap-day"), true);

					if (oDay.getTime() == oStartDate.getTime()) {
						$DomRef.addClass("sapUiCalDaySelStart");
						$DomRef.addClass("sapUiCalDaySel");
							if (oEndDate && oDay.getTime() == oEndDate.getTime()) {
								// start day and end day are the same
								$DomRef.addClass("sapUiCalDaySelEnd");
							}
					}else if (oEndDate && oDay.getTime() > oStartDate.getTime() && oDay.getTime() < oEndDate.getTime()) {
						$DomRef.addClass("sapUiCalDaySel");
						$DomRef.addClass("sapUiCalDaySelBetween");
					}else if (oEndDate && oDay.getTime() == oEndDate.getTime()) {
						$DomRef.addClass("sapUiCalDaySelEnd");
						$DomRef.addClass("sapUiCalDaySel");
					}else{
						if ($DomRef.hasClass("sapUiCalDaySel")){
							$DomRef.removeClass("sapUiCalDaySel");
						}
						if ($DomRef.hasClass("sapUiCalDaySelStart")){
								$DomRef.removeClass("sapUiCalDaySelStart");
						}else if ($DomRef.hasClass("sapUiCalDaySelBetween")){
								$DomRef.removeClass("sapUiCalDaySelBetween");
						}else if ($DomRef.hasClass("sapUiCalDaySelEnd")){
								$DomRef.removeClass("sapUiCalDaySelEnd");
						}
					}
				}
			} else {
				// single day selection or start a new interval
				sYyyymmdd = oThis._oFormatYyyymmdd.format(oDate, true);
				for ( i = 0; i < aDomRefs.length; i++) {
					$DomRef = jQuery(aDomRefs[i]);
					if (!$DomRef.hasClass("sapUiCalDayOtherMonth") && $DomRef.attr("data-sap-day") == sYyyymmdd) {
						$DomRef.addClass("sapUiCalDaySel");
					}else if ($DomRef.hasClass("sapUiCalDaySel")/*oOldDate && parseInt($DomRef.attr("data-sap-day")) == oOldDate.getUTCDate()*/){
							$DomRef.removeClass("sapUiCalDaySel");
					}
					if ($DomRef.hasClass("sapUiCalDaySelStart")){
							$DomRef.removeClass("sapUiCalDaySelStart");
					}else if ($DomRef.hasClass("sapUiCalDaySelBetween")){
							$DomRef.removeClass("sapUiCalDaySelBetween");
					}else if ($DomRef.hasClass("sapUiCalDaySelEnd")){
							$DomRef.removeClass("sapUiCalDaySelEnd");
					}
				}
				oDateRange.setProperty("startDate", _createLocalDate(oDate), true); // no-rerendering
				oDateRange.setProperty("endDate", undefined, true); // no-rerendering
			}
		} else {
			// multiple selection
			if (oThis.getIntervalSelection()) {
				throw new Error("Calender don't support multiple interval selection");

			} else {
				var iSelected = oThis._checkDateSelected(oDate);
				if (iSelected > 0) {
					// already selected - deselect
					for ( i = 0; i < aSelectedDates.length; i++) {
						if (aSelectedDates[i].getStartDate() && oDate.getTime() == _createUTCDate(aSelectedDates[i].getStartDate()).getTime()) {
							oThis.removeAggregation("selectedDates", i, true); // no re-rendering
							break;
						}
					}
				}else{
					// not selected -> select
					oDateRange = new sap.ui.unified.DateRange({startDate: _createLocalDate(oDate)});
					oThis.addAggregation("selectedDates", oDateRange, true); // no re-rendering
				}
				sYyyymmdd = oThis._oFormatYyyymmdd.format(oDate, true);
				for ( i = 0; i < aDomRefs.length; i++) {
					$DomRef = jQuery(aDomRefs[i]);
					if (!$DomRef.hasClass("sapUiCalDayOtherMonth") && $DomRef.attr("data-sap-day") == sYyyymmdd) {
						if (iSelected > 0) {
							$DomRef.removeClass("sapUiCalDaySel");
						}else {
							$DomRef.addClass("sapUiCalDaySel");
						}
					}
				}
			}
		}

	}

	function _determineFocusedDate(oThis){

		var aSelectedDates = oThis.getSelectedDates();
		if (aSelectedDates && aSelectedDates[0] && aSelectedDates[0].getStartDate()) {
			// selected dates are provided -> use first one to focus
			oThis._oFocusedDate = _createUTCDate(aSelectedDates[0].getStartDate());
		} else {
			// use current date
			var newDate = new Date();
			oThis._oFocusedDate = _createUTCDate(newDate);
		}

	}

	function _showMonthPicker(oThis){

		if (oThis._iMode == 2) {
			_hideYearPicker(oThis);
		}

		var oDate = oThis._getFocusedDate();
		var oRm = sap.ui.getCore().createRenderManager();
		var $Container = oThis.$();

		oThis.getRenderer().renderMonthPicker(oRm, oThis, oDate);
		oRm.flush($Container[0], false, true); // insert it
		oRm.destroy();

		// disable prev and next button
//		oThis.$("prev").attr("disabled", "disabled").addClass("sapUiCalDsbl");
//		oThis.$("next").attr("disabled", "disabled").addClass("sapUiCalDsbl");

		oThis._iMode = 1;

		// remove tabindex from focused day
		jQuery(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");

		_initItemNavigation(oThis);
		jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

	}

	function _hideMonthPicker(oThis){

		oThis.$("months").remove();
		oThis._iMode = 0;
		_initItemNavigation(oThis);
		jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

		// enable prev and next button
//		oThis.$("prev").removeAttr("disabled").removeClass("sapUiCalDsbl");
//		oThis.$("next").removeAttr("disabled").removeClass("sapUiCalDsbl");

	}

	function _selectMonth(oThis, iMonth){

		var oFocusedDate = oThis._getFocusedDate();
		oFocusedDate.setUTCMonth(iMonth);

		if (iMonth != oFocusedDate.getUTCMonth() ) {
			// day did not exist in this month (e.g. 31) -> go to last day of month
			oFocusedDate.setUTCDate(0);
		}

		_renderMonth(oThis);

		_hideMonthPicker(oThis);

	}

	function _showYearPicker(oThis){

		if (oThis._iMode == 1) {
			_hideMonthPicker(oThis);
		}

		var oDate = oThis._getFocusedDate();
		var oRm = sap.ui.getCore().createRenderManager();
		var $Container = oThis.$();

		oThis.getRenderer().renderYearPicker(oRm, oThis, oDate);
		oRm.flush($Container[0], false, true); // insert it
		oRm.destroy();

		// check special case if only 4 weeks are displayed (e.g. February 2021) -> top padding must be removed
		var aDomRefs = oThis.$("days").children(".sapUiCalDay");
		if (aDomRefs.length == 28) {
			oThis.$("years").addClass("sapUiCalYearNoTop");
		}

		oThis._iMode = 2;

		// remove tabindex from focused day
		jQuery(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");

		_initItemNavigation(oThis);
		jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

	}

	function _hideYearPicker(oThis){

		oThis.$("years").remove();
		oThis._iMode = 0;
		_initItemNavigation(oThis);
		jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

	}

	function _selectYear(oThis, iIndex){

		var oFocusedDate = oThis._getFocusedDate();
		var aDomRefs = oThis.$("years").children(".sapUiCalYear");
		var sYear = jQuery(aDomRefs[iIndex]).text();
		oFocusedDate.setUTCFullYear(sYear);

		_renderMonth(oThis);

		_hideYearPicker(oThis);

	}

	function _updateYears(oThis, bForward, iSelectedIndex){

		var aDomRefs = oThis.$("years").children(".sapUiCalYear");
		var iFirstYear = parseInt(jQuery(aDomRefs[0]).text());
		var oFocusedDate = oThis._getFocusedDate();
		var sCurrentYear = oFocusedDate.getUTCFullYear().toString();

		if (bForward) {
			iFirstYear = iFirstYear + 20;
		} else {
			iFirstYear = iFirstYear - 20;
		}

		var iYear = iFirstYear;
		for ( var i = 0; i < aDomRefs.length; i++) {
			var $DomRef = jQuery(aDomRefs[i]);
			$DomRef.attr("id", oThis.getId() + "-y" + iYear);
			$DomRef.text(iYear);
			if ($DomRef.hasClass("sapUiCalYearSel") && $DomRef.text() != sCurrentYear) {
				$DomRef.removeClass("sapUiCalYearSel");
			} else if (!$DomRef.hasClass("sapUiCalYearSel") && $DomRef.text() == sCurrentYear){
				$DomRef.addClass("sapUiCalYearSel");
			}
			iYear++;
		}

		oThis._oItemNavigation.focusItem(iSelectedIndex);

	}

	function _checkNamesLength(oThis){

		if (!oThis._bNamesLengthChecked) {
			// only once - cannot change by rerendering - only by theme change
			var i = 0;
			var oWeekDay;
			var oLocaleData;

			// check day names
			var aWeekHeaders = oThis.$().children(".sapUiCalWH");
			var bTooLong = false;

			for ( i = 0; i < aWeekHeaders.length; i++) {
				oWeekDay = aWeekHeaders[i];
				if (oWeekDay.clientWidth < oWeekDay.scrollWidth) {
					bTooLong = true;
					break;
				}
			}

			if (bTooLong) {
				oThis._bLongWeekDays = false;
				oLocaleData = oThis._getLocaleData();
				var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();
				var aDayNames = oLocaleData.getDaysStandAlone("narrow");
				for ( i = 0; i < aDayNames.length; i++) {
					oWeekDay = aWeekHeaders[i];
					jQuery(oWeekDay).text(aDayNames[(i + iFirstDayOfWeek) % 7]);
				}
			} else{
				oThis._bLongWeekDays = true;
			}

			// check month names
			_showMonthPicker(oThis);

			var aMonths = oThis.$("months").children();
			bTooLong = false;
			for ( i = 0; i < aMonths.length; i++) {
				var oMonth = aMonths[i];
				if (oMonth.clientWidth < oMonth.scrollWidth) {
					bTooLong = true;
					break;
				}
			}
			if (bTooLong) {
				oThis._bLongMonth = false;
				if (!oLocaleData) {
					oLocaleData = oThis._getLocaleData();
				}
				// change month name on button but not chnage month picker, becuase it is hided again
				var aMonthNames = oLocaleData.getMonthsStandAlone("abbreviated");
				var oDate = oThis._getFocusedDate();
				oThis.$("month").text(aMonthNames[oDate.getUTCMonth()]);
			} else{
				oThis._bLongMonth = true;
			}

			_hideMonthPicker(oThis);

			oThis._bNamesLengthChecked = true;
		}

	}

	function _fireSelect(oThis){

		if (oThis._bMouseMove) {
			// detach mouse move handler because calendar might be losed in select event handler
			jQuery(window.document).unbind('mousemove', oThis._mouseMoveProxy);
			oThis._bMouseMove = undefined;
		}

		oThis.fireSelect();

	}

}());

}; // end of sap/ui/unified/Calendar.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarLegend') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.CalendarLegend.
jQuery.sap.declare("sap.ui.unified.CalendarLegend");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new CalendarLegend.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getColumnWidth columnWidth} : sap.ui.core.CSSSize (default: '120px')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getItems items} : sap.ui.unified.CalendarLegendItem[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A legend for the Calendar Control. Displays special dates colors with their corresponding description. The aggregation specialDates can be set herefor.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.CalendarLegend
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.CalendarLegend", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"columnWidth" : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : '120px'}
	},
	aggregations : {
		"items" : {type : "sap.ui.unified.CalendarLegendItem", multiple : true, singularName : "item"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.CalendarLegend with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.CalendarLegend.extend
 * @function
 */


/**
 * Getter for property <code>columnWidth</code>.
 * Width of the columns created in which the items are arranged.
 *
 * Default value is <code>120px</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>columnWidth</code>
 * @public
 * @name sap.ui.unified.CalendarLegend#getColumnWidth
 * @function
 */

/**
 * Setter for property <code>columnWidth</code>.
 *
 * Default value is <code>120px</code> 
 *
 * @param {sap.ui.core.CSSSize} sColumnWidth  new value for property <code>columnWidth</code>
 * @return {sap.ui.unified.CalendarLegend} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.CalendarLegend#setColumnWidth
 * @function
 */


/**
 * Getter for aggregation <code>items</code>.<br/>
 * Items to be displayed.
 * 
 * @return {sap.ui.unified.CalendarLegendItem[]}
 * @public
 * @name sap.ui.unified.CalendarLegend#getItems
 * @function
 */


/**
 * Inserts a item into the aggregation named <code>items</code>.
 *
 * @param {sap.ui.unified.CalendarLegendItem}
 *          oItem the item to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the item should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the item is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the item is inserted at 
 *             the last position        
 * @return {sap.ui.unified.CalendarLegend} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.CalendarLegend#insertItem
 * @function
 */

/**
 * Adds some item <code>oItem</code> 
 * to the aggregation named <code>items</code>.
 *
 * @param {sap.ui.unified.CalendarLegendItem}
 *            oItem the item to add; if empty, nothing is inserted
 * @return {sap.ui.unified.CalendarLegend} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.CalendarLegend#addItem
 * @function
 */

/**
 * Removes an item from the aggregation named <code>items</code>.
 *
 * @param {int | string | sap.ui.unified.CalendarLegendItem} vItem the item to remove or its index or id
 * @return {sap.ui.unified.CalendarLegendItem} the removed item or null
 * @public
 * @name sap.ui.unified.CalendarLegend#removeItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>items</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.CalendarLegendItem[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.CalendarLegend#removeAllItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.CalendarLegendItem</code> in the aggregation named <code>items</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.CalendarLegendItem}
 *            oItem the item whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.CalendarLegend#indexOfItem
 * @function
 */
	

/**
 * Destroys all the items in the aggregation 
 * named <code>items</code>.
 * @return {sap.ui.unified.CalendarLegend} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.CalendarLegend#destroyItems
 * @function
 */


// Start of sap\ui\unified\CalendarLegend.js
///**
// * This file defines behavior for the control,
// */
//sap.ui.unified.CalendarLegend.prototype.init = function(){
//   // do something for initialization...
//};


//IE9 workaround for responsive layout of legend items
sap.ui.unified.CalendarLegend.prototype.onAfterRendering = function()	{
	if(sap.ui.Device.browser.msie) {
		if(sap.ui.Device.browser.version<10) {
			jQuery( ".sapUiUnifiedLegendItem" ).css( "width", this.getColumnWidth()+4+"px" ).css("display", "inline-block");
		}
	}
}

}; // end of sap/ui/unified/CalendarLegend.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarLegendItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.CalendarLegendItem.
jQuery.sap.declare("sap.ui.unified.CalendarLegendItem");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new CalendarLegendItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Item to be displayed in a CalendarLegend.
 * @extends sap.ui.core.Element
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.CalendarLegendItem
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.unified.CalendarLegendItem", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"text" : {type : "string", group : "Misc", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.CalendarLegendItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.CalendarLegendItem.extend
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * Text to be displayed for the item.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.unified.CalendarLegendItem#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.unified.CalendarLegendItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.CalendarLegendItem#setText
 * @function
 */


// Start of sap\ui\unified\CalendarLegendItem.js
///**
// * This file defines behavior for the control,
// */
//sap.ui.unified.CalendarLegendItem.prototype.init = function(){
//   // do something for initialization...
//};

}; // end of sap/ui/unified/CalendarLegendItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ContentSwitcher') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.ContentSwitcher.
jQuery.sap.declare("sap.ui.unified.ContentSwitcher");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ContentSwitcher.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getAnimation animation} : string (default: 'None')</li>
 * <li>{@link #getActiveContent activeContent} : int (default: 1)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent1 content1} : sap.ui.core.Control[]</li>
 * <li>{@link #getContent2 content2} : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Switches between two control areas and animates it via CSS transitions
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @experimental Since version 1.16.0. 
 * API is not yet finished and might change completely
 * @name sap.ui.unified.ContentSwitcher
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.ContentSwitcher", { metadata : {

	deprecated : true,
	library : "sap.ui.unified",
	properties : {
		"animation" : {type : "string", group : "Appearance", defaultValue : 'None'},
		"activeContent" : {type : "int", group : "Behavior", defaultValue : 1}
	},
	aggregations : {
		"content1" : {type : "sap.ui.core.Control", multiple : true, singularName : "content1"}, 
		"content2" : {type : "sap.ui.core.Control", multiple : true, singularName : "content2"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.ContentSwitcher with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.ContentSwitcher.extend
 * @function
 */


/**
 * Getter for property <code>animation</code>.
 * Set the used animation when changing content. This just sets a CSS-class named "sapUiUnifiedACSwitcherAnimation" + this value on the root element of the control. The animation has to be implemented in CSS. This also enables applications to implement their own animations via CSS by reacting to the parent class.
 * See the types sap.ui.unified.ContentSwitcherAnimation for default implementations.
 *
 * Default value is <code>None</code>
 *
 * @return {string} the value of property <code>animation</code>
 * @public
 * @name sap.ui.unified.ContentSwitcher#getAnimation
 * @function
 */

/**
 * Setter for property <code>animation</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {string} sAnimation  new value for property <code>animation</code>
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#setAnimation
 * @function
 */


/**
 * Getter for property <code>activeContent</code>.
 * The number of the currently active content (1 or 2).
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>activeContent</code>
 * @public
 * @name sap.ui.unified.ContentSwitcher#getActiveContent
 * @function
 */

/**
 * Setter for property <code>activeContent</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iActiveContent  new value for property <code>activeContent</code>
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#setActiveContent
 * @function
 */


/**
 * Getter for aggregation <code>content1</code>.<br/>
 * The controls that should be shown in the first content
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.ContentSwitcher#getContent1
 * @function
 */


/**
 * Inserts a content1 into the aggregation named <code>content1</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent1 the content1 to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content1 should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content1 is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content1 is inserted at 
 *             the last position        
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#insertContent1
 * @function
 */

/**
 * Adds some content1 <code>oContent1</code> 
 * to the aggregation named <code>content1</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent1 the content1 to add; if empty, nothing is inserted
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#addContent1
 * @function
 */

/**
 * Removes an content1 from the aggregation named <code>content1</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent1 the content1 to remove or its index or id
 * @return {sap.ui.core.Control} the removed content1 or null
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeContent1
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content1</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeAllContent1
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content1</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent1 the content1 whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.ContentSwitcher#indexOfContent1
 * @function
 */
	

/**
 * Destroys all the content1 in the aggregation 
 * named <code>content1</code>.
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#destroyContent1
 * @function
 */


/**
 * Getter for aggregation <code>content2</code>.<br/>
 * The controls that should be shown in the second content
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.ContentSwitcher#getContent2
 * @function
 */


/**
 * Inserts a content2 into the aggregation named <code>content2</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent2 the content2 to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content2 should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content2 is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content2 is inserted at 
 *             the last position        
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#insertContent2
 * @function
 */

/**
 * Adds some content2 <code>oContent2</code> 
 * to the aggregation named <code>content2</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent2 the content2 to add; if empty, nothing is inserted
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#addContent2
 * @function
 */

/**
 * Removes an content2 from the aggregation named <code>content2</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent2 the content2 to remove or its index or id
 * @return {sap.ui.core.Control} the removed content2 or null
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeContent2
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content2</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.ContentSwitcher#removeAllContent2
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content2</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent2 the content2 whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.ContentSwitcher#indexOfContent2
 * @function
 */
	

/**
 * Destroys all the content2 in the aggregation 
 * named <code>content2</code>.
 * @return {sap.ui.unified.ContentSwitcher} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ContentSwitcher#destroyContent2
 * @function
 */


// Start of sap\ui\unified\ContentSwitcher.js
(function(window, undefined) {

////////////////////////////////////////// Public Methods //////////////////////////////////////////

/**
 * This file defines behavior for the control,
 */
sap.ui.unified.ContentSwitcher.prototype.init = function(){
};

/**
 * Changes the currently active content to the other one. If content 1 is active, content 2 will
 * be activated and the other way around.
 * 
 * @public
 */
sap.ui.unified.ContentSwitcher.prototype.switchContent = function() {
	this.setActiveContent(this.getActiveContent() == 1 ? 2 : 1);
	return this;
};

////////////////////////////////////////// onEvent Methods /////////////////////////////////////////

sap.ui.unified.ContentSwitcher.prototype.onAfterRendering = function() {
	this._$Contents = [
		this.$("content1"),
		this.$("content2")
	];
};


////////////////////////////////////////// Private Methods /////////////////////////////////////////

/**
 * Make the content-area with the given number appear/visible. This just sets the CSS-class
 * sapUiUnifiedCSwitcherVisible
 */
sap.ui.unified.ContentSwitcher.prototype._showActiveContent = function(iNumber) {
	this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible", iNumber === 1);
	this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible", iNumber === 2);
};

///////////////////////////////////////// Hidden Functions /////////////////////////////////////////


//////////////////////////////////////// Overridden Methods ////////////////////////////////////////

    ///////////////////////////////// Property "activeContent" /////////////////////////////////

sap.ui.unified.ContentSwitcher.prototype.setActiveContent = function(iNumber) {
	iNumber = parseInt(iNumber);
	
	if (isNaN(iNumber) || iNumber < 1) {
		iNumber = 1;
		
		jQuery.sap.log.warning(
			"setActiveContent argument must be either 1 or 2. Active content set to 1."
		);
	} else if (iNumber > 2) {
		iNumber = 2;
		
		jQuery.sap.log.warning(
			"setActiveContent argument must be either 1 or 2. Active content set to 2."
		);
	}
	
	this.setProperty("activeContent", iNumber, /* supressInvalidate: */ true);
	
	this._showActiveContent(iNumber);
	
	return this;
};


    /////////////////////////////////// Property "animation" ///////////////////////////////////

sap.ui.unified.ContentSwitcher.prototype.setAnimation = function(sAnimation, bSuppressInvalidate){
	if (typeof(sAnimation) !== "string") {
		sAnimation = sap.ui.unified.ContentSwitcherAnimation.None;
		jQuery.sap.log.warning(
			"setAnimation argument must be a string. Animation was set to \"" + 
			sap.ui.unified.ContentSwitcherAnimation.None + "\"."
		);
	}
	
	// Remove all non-alphanumerical characters from the animation string
	sAnimation = sAnimation.replace(/[^a-zA-Z0-9]/g, "");
	
	var sCurrentAnimation = this.getProperty("animation");
	
	if (sAnimation === sCurrentAnimation) {
		// No change.
		return;
	}
	
	var $Dom = this.$();
	if ($Dom[0]) {
		// We are already rendered - so we have to change the class on the fly...
		$Dom.toggleClass("sapUiUfdCSwitcherAnimation" + sCurrentAnimation, false);
		$Dom.toggleClass("sapUiUfdCSwitcherAnimation" + sAnimation, true);
	}/* else {
		// The renderer will take care of it.
	}/**/

	this.setProperty("animation", sAnimation, bSuppressInvalidate);
	
	return this;
};


    //////////////////////////////////////// Event "xxx" ///////////////////////////////////////
    ///////////////////////////////////// Aggregation "xxx" ////////////////////////////////////
    ///////////////////////////////////// Association "xxx" ////////////////////////////////////

})(window);
}; // end of sap/ui/unified/ContentSwitcher.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Currency') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.Currency.
jQuery.sap.declare("sap.ui.unified.Currency");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Currency.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getValue value} : float (default: 0)</li>
 * <li>{@link #getCurrency currency} : string</li>
 * <li>{@link #getMaxPrecision maxPrecision} : int (default: 3)</li>
 * <li>{@link #getUseSymbol useSymbol} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A text view which displays currency values and aligns them at the separator
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.21.1
 * @name sap.ui.unified.Currency
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.Currency", { metadata : {

	publicMethods : [
		// methods
		"getFormattedValue", "getCurrencySymbol"
	],
	library : "sap.ui.unified",
	properties : {
		"value" : {type : "float", group : "Appearance", defaultValue : 0},
		"currency" : {type : "string", group : "Appearance", defaultValue : null},
		"maxPrecision" : {type : "int", group : "Appearance", defaultValue : 3},
		"useSymbol" : {type : "boolean", group : "Appearance", defaultValue : true}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.Currency with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.Currency.extend
 * @function
 */


/**
 * Getter for property <code>value</code>.
 * The currency value
 *
 * Default value is <code>0</code>
 *
 * @return {float} the value of property <code>value</code>
 * @public
 * @name sap.ui.unified.Currency#getValue
 * @function
 */

/**
 * Setter for property <code>value</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {float} fValue  new value for property <code>value</code>
 * @return {sap.ui.unified.Currency} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Currency#setValue
 * @function
 */


/**
 * Getter for property <code>currency</code>.
 * The ISO 4217 currency code
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>currency</code>
 * @public
 * @name sap.ui.unified.Currency#getCurrency
 * @function
 */

/**
 * Setter for property <code>currency</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sCurrency  new value for property <code>currency</code>
 * @return {sap.ui.unified.Currency} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Currency#setCurrency
 * @function
 */


/**
 * Getter for property <code>maxPrecision</code>.
 * Defines the space that is available for the precision of the various currencies.
 *
 * Default value is <code>3</code>
 *
 * @return {int} the value of property <code>maxPrecision</code>
 * @public
 * @name sap.ui.unified.Currency#getMaxPrecision
 * @function
 */

/**
 * Setter for property <code>maxPrecision</code>.
 *
 * Default value is <code>3</code> 
 *
 * @param {int} iMaxPrecision  new value for property <code>maxPrecision</code>
 * @return {sap.ui.unified.Currency} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Currency#setMaxPrecision
 * @function
 */


/**
 * Getter for property <code>useSymbol</code>.
 * Show the currency symbol instead of the ISO currency code
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>useSymbol</code>
 * @public
 * @name sap.ui.unified.Currency#getUseSymbol
 * @function
 */

/**
 * Setter for property <code>useSymbol</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bUseSymbol  new value for property <code>useSymbol</code>
 * @return {sap.ui.unified.Currency} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Currency#setUseSymbol
 * @function
 */


/**
 * The formatted value
 *
 * @name sap.ui.unified.Currency#getFormattedValue
 * @function
 * @type string
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Get symbol of the currency, if available
 *
 * @name sap.ui.unified.Currency#getCurrencySymbol
 * @function
 * @type string
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\unified\Currency.js
jQuery.sap.require('sap.ui.core.format.NumberFormat'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.LocaleData'); // unlisted dependency retained


//Whitespace characters to align values
sap.ui.unified.Currency.FIGURE_SPACE = '\u2007';
sap.ui.unified.Currency.PUNCTUATION_SPACE = '\u2008';

sap.ui.unified.Currency.prototype.init = function() {
	this._oFormat = sap.ui.core.format.NumberFormat.getCurrencyInstance({
		showMeasure: false
	});
};

sap.ui.unified.Currency.prototype.getFormattedValue = function() {
	if (this.getCurrency() === "*") {
		return "";
	}

	var iPadding = this.getMaxPrecision()- this._oFormat.oLocaleData.getCurrencyDigits(this.getCurrency());
	var sValue = this._oFormat.format(this.getValue(), this.getCurrency());
	
	if (iPadding == this.getMaxPrecision() && this.getMaxPrecision() > 0) {
		sValue += sap.ui.unified.Currency.PUNCTUATION_SPACE;
	}

	// create spaces
	if (iPadding > 0) {
		sValue = jQuery.sap.padRight(sValue, sap.ui.unified.Currency.FIGURE_SPACE, sValue.length + iPadding);
	} else if (iPadding < 0) {
		sValue = sValue.substr(0, sValue.length + iPadding);
	}
	
	return sValue;
};

sap.ui.unified.Currency.prototype.getCurrencySymbol = function() {
	return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());
};

sap.ui.unified.Currency.prototype.setValue = function(sValue) {
	// force the invalidation if the value should be displayed
	// to re-render the control finally
	var bHasValue = this._hasValue(),
	    bHasNoValueClass = this.$().hasClass("sapUiUfdCurrencyNoVal");
	if (bHasValue === bHasNoValueClass) {
		this.invalidate();
	}
	this.setProperty("value", sValue);
	return this;
};

/**
 * Checks if the binding has a proper value or the value is undefined. In case of 
 * undefined value the Currency control will not display any value! This workaround
 * is necessary because of the default value 0 suppresses to set a undefined or null value
 * instead and this cannot be changed due to compatibility.
 * @private
 */
sap.ui.unified.Currency.prototype._hasValue = function() {
	var oValueBinding = this.getBinding("value"),
	    bHasBinding = oValueBinding !== undefined,
	    bHasValue = bHasBinding ? oValueBinding.getValue() !== undefined : true /* no databinding => always true */;
	return bHasValue;
};

}; // end of sap/ui/unified/Currency.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.DateRange') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.DateRange.
jQuery.sap.declare("sap.ui.unified.DateRange");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new DateRange.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getStartDate startDate} : object</li>
 * <li>{@link #getEndDate endDate} : object</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Date range for use in DatePicker
 * @extends sap.ui.core.Element
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.DateRange
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.unified.DateRange", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"startDate" : {type : "object", group : "Misc", defaultValue : null},
		"endDate" : {type : "object", group : "Misc", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.DateRange with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.DateRange.extend
 * @function
 */


/**
 * Getter for property <code>startDate</code>.
 * Start date for a date range. This must be a JavaScript date object.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {object} the value of property <code>startDate</code>
 * @public
 * @name sap.ui.unified.DateRange#getStartDate
 * @function
 */

/**
 * Setter for property <code>startDate</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {object} oStartDate  new value for property <code>startDate</code>
 * @return {sap.ui.unified.DateRange} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.DateRange#setStartDate
 * @function
 */


/**
 * Getter for property <code>endDate</code>.
 * Start date for a date range. If empty only a single date is presented by this DateRange element. This must be a JavaScript date object.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {object} the value of property <code>endDate</code>
 * @public
 * @name sap.ui.unified.DateRange#getEndDate
 * @function
 */

/**
 * Setter for property <code>endDate</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {object} oEndDate  new value for property <code>endDate</code>
 * @return {sap.ui.unified.DateRange} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.DateRange#setEndDate
 * @function
 */


// Start of sap\ui\unified\DateRange.js
///**
// * This file defines behavior for the control,
// */

sap.ui.unified.DateRange.prototype.setStartDate = function(oDate){

	jQuery.sap.assert(!oDate || oDate instanceof Date, "Date must be a JavaScript date object");

	this.setProperty("startDate", oDate);

};

sap.ui.unified.DateRange.prototype.setEndDate = function(oDate){

	jQuery.sap.assert(!oDate || oDate instanceof Date, "Date must be a JavaScript date object");

	this.setProperty("endDate", oDate);

};
}; // end of sap/ui/unified/DateRange.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.DateTypeRange') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.DateTypeRange.
jQuery.sap.declare("sap.ui.unified.DateTypeRange");




/**
 * Constructor for a new DateTypeRange.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getType type} : sap.ui.unified.CalendarDayType</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.DateRange#constructor sap.ui.unified.DateRange}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Date range with calendar day type information. Used to visualize special days in the Calendar.
 * @extends sap.ui.unified.DateRange
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.DateTypeRange
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.DateRange.extend("sap.ui.unified.DateTypeRange", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"type" : {type : "sap.ui.unified.CalendarDayType", group : "Appearance", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.DateTypeRange with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.DateTypeRange.extend
 * @function
 */


/**
 * Getter for property <code>type</code>.
 * Type of the dayte range.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.unified.CalendarDayType} the value of property <code>type</code>
 * @public
 * @name sap.ui.unified.DateTypeRange#getType
 * @function
 */

/**
 * Setter for property <code>type</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.unified.CalendarDayType} oType  new value for property <code>type</code>
 * @return {sap.ui.unified.DateTypeRange} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.DateTypeRange#setType
 * @function
 */


// Start of sap\ui\unified\DateTypeRange.js
///**
// * This file defines behavior for the control,
// */
//sap.ui.unified.DateTypeRange.prototype.init = function(){
//   // do something for initialization...
//};

}; // end of sap/ui/unified/DateTypeRange.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.FileUploader') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.FileUploader.
jQuery.sap.declare("sap.ui.unified.FileUploader");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new FileUploader.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getValue value} : string (default: '')</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getUploadUrl uploadUrl} : sap.ui.core.URI (default: '')</li>
 * <li>{@link #getName name} : string</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '')</li>
 * <li>{@link #getUploadOnChange uploadOnChange} : boolean (default: false)</li>
 * <li>{@link #getAdditionalData additionalData} : string</li>
 * <li>{@link #getSameFilenameAllowed sameFilenameAllowed} : boolean (default: false)</li>
 * <li>{@link #getButtonText buttonText} : string</li>
 * <li>{@link #getFileType fileType} : string[]</li>
 * <li>{@link #getMultiple multiple} : boolean (default: false)</li>
 * <li>{@link #getMaximumFileSize maximumFileSize} : float</li>
 * <li>{@link #getMimeType mimeType} : string[]</li>
 * <li>{@link #getSendXHR sendXHR} : boolean (default: false)</li>
 * <li>{@link #getPlaceholder placeholder} : string</li>
 * <li>{@link #getStyle style} : string</li>
 * <li>{@link #getButtonOnly buttonOnly} : boolean (default: false)</li>
 * <li>{@link #getUseMultipart useMultipart} : boolean (default: true)</li>
 * <li>{@link #getMaximumFilenameLength maximumFilenameLength} : int</li>
 * <li>{@link #getValueState valueState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getParameters parameters} : sap.ui.unified.FileUploaderParameter[]</li>
 * <li>{@link #getHeaderParameters headerParameters} : sap.ui.unified.FileUploaderParameter[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.FileUploader#event:change change} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.FileUploader#event:uploadComplete uploadComplete} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.FileUploader#event:typeMissmatch typeMissmatch} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.FileUploader#event:fileSizeExceed fileSizeExceed} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.FileUploader#event:fileAllowed fileAllowed} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.FileUploader#event:uploadProgress uploadProgress} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.FileUploader#event:uploadAborted uploadAborted} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.ui.unified.FileUploader#event:filenameLengthExceed filenameLengthExceed} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The framework generates an input field and a button with text "Browse ...". The API supports features such as on change uploads (the upload starts immediately after a file has been selected), file uploads with explicit calls, adjustable control sizes, text display after uploads, or tooltips containing complete file paths.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.FileUploader
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.FileUploader", { metadata : {

	publicMethods : [
		// methods
		"upload", "abort", "clear"
	],
	library : "sap.ui.unified",
	properties : {
		"value" : {type : "string", group : "Data", defaultValue : ''},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"uploadUrl" : {type : "sap.ui.core.URI", group : "Data", defaultValue : ''},
		"name" : {type : "string", group : "Data", defaultValue : null},
		"width" : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : ''},
		"uploadOnChange" : {type : "boolean", group : "Behavior", defaultValue : false},
		"additionalData" : {type : "string", group : "Data", defaultValue : null},
		"sameFilenameAllowed" : {type : "boolean", group : "Behavior", defaultValue : false},
		"buttonText" : {type : "string", group : "Misc", defaultValue : null},
		"fileType" : {type : "string[]", group : "Data", defaultValue : null},
		"multiple" : {type : "boolean", group : "Behavior", defaultValue : false},
		"maximumFileSize" : {type : "float", group : "Data", defaultValue : null},
		"mimeType" : {type : "string[]", group : "Data", defaultValue : null},
		"sendXHR" : {type : "boolean", group : "Behavior", defaultValue : false},
		"placeholder" : {type : "string", group : "Appearance", defaultValue : null},
		"style" : {type : "string", group : "Appearance", defaultValue : null},
		"buttonOnly" : {type : "boolean", group : "Appearance", defaultValue : false},
		"useMultipart" : {type : "boolean", group : "Behavior", defaultValue : true},
		"maximumFilenameLength" : {type : "int", group : "Data", defaultValue : null},
		"valueState" : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None}
	},
	aggregations : {
		"parameters" : {type : "sap.ui.unified.FileUploaderParameter", multiple : true, singularName : "parameter"}, 
		"headerParameters" : {type : "sap.ui.unified.FileUploaderParameter", multiple : true, singularName : "headerParameter"}
	},
	events : {
		"change" : {}, 
		"uploadComplete" : {}, 
		"typeMissmatch" : {}, 
		"fileSizeExceed" : {}, 
		"fileAllowed" : {}, 
		"uploadProgress" : {}, 
		"uploadAborted" : {}, 
		"filenameLengthExceed" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.FileUploader with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.FileUploader.extend
 * @function
 */

sap.ui.unified.FileUploader.M_EVENTS = {'change':'change','uploadComplete':'uploadComplete','typeMissmatch':'typeMissmatch','fileSizeExceed':'fileSizeExceed','fileAllowed':'fileAllowed','uploadProgress':'uploadProgress','uploadAborted':'uploadAborted','filenameLengthExceed':'filenameLengthExceed'};


/**
 * Getter for property <code>value</code>.
 * Value of the path for file upload.
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>value</code>
 * @public
 * @name sap.ui.unified.FileUploader#getValue
 * @function
 */

/**
 * Setter for property <code>value</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sValue  new value for property <code>value</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setValue
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Disabled controls have different colors, depending on customer settings.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.unified.FileUploader#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.unified.FileUploader#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setVisible
 * @function
 */


/**
 * Getter for property <code>uploadUrl</code>.
 * Used when URL address is on a remote server.
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>uploadUrl</code>
 * @public
 * @name sap.ui.unified.FileUploader#getUploadUrl
 * @function
 */

/**
 * Setter for property <code>uploadUrl</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.URI} sUploadUrl  new value for property <code>uploadUrl</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setUploadUrl
 * @function
 */


/**
 * Getter for property <code>name</code>.
 * Unique control name for identification on the server side after sending data to the server.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>name</code>
 * @public
 * @name sap.ui.unified.FileUploader#getName
 * @function
 */

/**
 * Setter for property <code>name</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sName  new value for property <code>name</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setName
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Specifies the displayed control width.
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.unified.FileUploader#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setWidth
 * @function
 */


/**
 * Getter for property <code>uploadOnChange</code>.
 * If set to "true", the upload immediately starts after file selection. With the default setting, the upload needs to be explicitly triggered.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>uploadOnChange</code>
 * @public
 * @name sap.ui.unified.FileUploader#getUploadOnChange
 * @function
 */

/**
 * Setter for property <code>uploadOnChange</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bUploadOnChange  new value for property <code>uploadOnChange</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setUploadOnChange
 * @function
 */


/**
 * Getter for property <code>additionalData</code>.
 * Additional data that is sent to the back end service. Data will be transmitted as value of a hidden input where the name is derived from the name property with suffix -data.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>additionalData</code>
 * @public
 * @name sap.ui.unified.FileUploader#getAdditionalData
 * @function
 */

/**
 * Setter for property <code>additionalData</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAdditionalData  new value for property <code>additionalData</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setAdditionalData
 * @function
 */


/**
 * Getter for property <code>sameFilenameAllowed</code>.
 * If the FileUploader is configured to upload the file directly after the file is selected it is not allowed to upload a file with the same name again. If a user should be allowed to upload a file with the same name again this parameter has to be "true". A typical use case would be if the files have different paths.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>sameFilenameAllowed</code>
 * @public
 * @name sap.ui.unified.FileUploader#getSameFilenameAllowed
 * @function
 */

/**
 * Setter for property <code>sameFilenameAllowed</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSameFilenameAllowed  new value for property <code>sameFilenameAllowed</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setSameFilenameAllowed
 * @function
 */


/**
 * Getter for property <code>buttonText</code>.
 * The Button text can be overwritten using this property.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>buttonText</code>
 * @public
 * @name sap.ui.unified.FileUploader#getButtonText
 * @function
 */

/**
 * Setter for property <code>buttonText</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sButtonText  new value for property <code>buttonText</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setButtonText
 * @function
 */


/**
 * Getter for property <code>fileType</code>.
 * The chosen files will be checked against an array of file types. If at least one file does not fit the file type restriction the upload is prevented.
 * Example: ["jpg", "png", "bmp"].
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string[]} the value of property <code>fileType</code>
 * @public
 * @name sap.ui.unified.FileUploader#getFileType
 * @function
 */

/**
 * Setter for property <code>fileType</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string[]} aFileType  new value for property <code>fileType</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setFileType
 * @function
 */


/**
 * Getter for property <code>multiple</code>.
 * Allows multiple files to be chosen and uploaded from the same folder. This property is not supported by Internet Explorer 8 and 9.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>multiple</code>
 * @public
 * @name sap.ui.unified.FileUploader#getMultiple
 * @function
 */

/**
 * Setter for property <code>multiple</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bMultiple  new value for property <code>multiple</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setMultiple
 * @function
 */


/**
 * Getter for property <code>maximumFileSize</code>.
 * A file size limit in megabytes which prevents the upload if at least one file exceeds it. This property is not supported by Internet Explorer 8 and 9.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {float} the value of property <code>maximumFileSize</code>
 * @public
 * @name sap.ui.unified.FileUploader#getMaximumFileSize
 * @function
 */

/**
 * Setter for property <code>maximumFileSize</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {float} fMaximumFileSize  new value for property <code>maximumFileSize</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setMaximumFileSize
 * @function
 */


/**
 * Getter for property <code>mimeType</code>.
 * The chosen files will be checked against an array of mime types. If at least one file does not fit the mime type restriction the upload is prevented. This property is not supported by Internet Explorer 8 and 9.
 * Example: mimeType ["image/png", "image/jpeg"].
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string[]} the value of property <code>mimeType</code>
 * @public
 * @name sap.ui.unified.FileUploader#getMimeType
 * @function
 */

/**
 * Setter for property <code>mimeType</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string[]} aMimeType  new value for property <code>mimeType</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setMimeType
 * @function
 */


/**
 * Getter for property <code>sendXHR</code>.
 * If set to "true", the request will be sent as XHR request instead of a form submit. This property is not supported by Internet Explorer 8 and 9.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>sendXHR</code>
 * @public
 * @name sap.ui.unified.FileUploader#getSendXHR
 * @function
 */

/**
 * Setter for property <code>sendXHR</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSendXHR  new value for property <code>sendXHR</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setSendXHR
 * @function
 */


/**
 * Getter for property <code>placeholder</code>.
 * Placeholder for the text field.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>placeholder</code>
 * @public
 * @name sap.ui.unified.FileUploader#getPlaceholder
 * @function
 */

/**
 * Setter for property <code>placeholder</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sPlaceholder  new value for property <code>placeholder</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setPlaceholder
 * @function
 */


/**
 * Getter for property <code>style</code>.
 * Style of the button. "Transparent, "Accept", "Reject", or "Emphasized" is allowed.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>style</code>
 * @public
 * @name sap.ui.unified.FileUploader#getStyle
 * @function
 */

/**
 * Setter for property <code>style</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sStyle  new value for property <code>style</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setStyle
 * @function
 */


/**
 * Getter for property <code>buttonOnly</code>.
 * If set to "true", the FileUploader will be rendered as Button only, without showing the InputField.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>buttonOnly</code>
 * @public
 * @name sap.ui.unified.FileUploader#getButtonOnly
 * @function
 */

/**
 * Setter for property <code>buttonOnly</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bButtonOnly  new value for property <code>buttonOnly</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setButtonOnly
 * @function
 */


/**
 * Getter for property <code>useMultipart</code>.
 * If set to "false", the request will be sent as file only request instead of a multipart/form-data request. Only one file could be uploaded using this type of request. Required for sending such a request is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>useMultipart</code>
 * @public
 * @name sap.ui.unified.FileUploader#getUseMultipart
 * @function
 */

/**
 * Setter for property <code>useMultipart</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bUseMultipart  new value for property <code>useMultipart</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#setUseMultipart
 * @function
 */


/**
 * Getter for property <code>maximumFilenameLength</code>.
 * The maximum length of a filename which the FileUploader will accept. If the maximum filename length is exceeded, the corresponding Event 'filenameLengthExceed' is fired.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>maximumFilenameLength</code>
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#getMaximumFilenameLength
 * @function
 */

/**
 * Setter for property <code>maximumFilenameLength</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iMaximumFilenameLength  new value for property <code>maximumFilenameLength</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#setMaximumFilenameLength
 * @function
 */


/**
 * Getter for property <code>valueState</code>.
 * Visualizes warnings or errors related to the text field. Possible values: Warning, Error, Success, None.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>valueState</code>
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#getValueState
 * @function
 */

/**
 * Setter for property <code>valueState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oValueState  new value for property <code>valueState</code>
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#setValueState
 * @function
 */


/**
 * Getter for aggregation <code>parameters</code>.<br/>
 * The parameters for the FileUploader which are rendered as a hidden inputfield.
 * 
 * @return {sap.ui.unified.FileUploaderParameter[]}
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploader#getParameters
 * @function
 */


/**
 * Inserts a parameter into the aggregation named <code>parameters</code>.
 *
 * @param {sap.ui.unified.FileUploaderParameter}
 *          oParameter the parameter to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the parameter should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the parameter is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the parameter is inserted at 
 *             the last position        
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploader#insertParameter
 * @function
 */

/**
 * Adds some parameter <code>oParameter</code> 
 * to the aggregation named <code>parameters</code>.
 *
 * @param {sap.ui.unified.FileUploaderParameter}
 *            oParameter the parameter to add; if empty, nothing is inserted
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploader#addParameter
 * @function
 */

/**
 * Removes an parameter from the aggregation named <code>parameters</code>.
 *
 * @param {int | string | sap.ui.unified.FileUploaderParameter} vParameter the parameter to remove or its index or id
 * @return {sap.ui.unified.FileUploaderParameter} the removed parameter or null
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploader#removeParameter
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>parameters</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.FileUploaderParameter[]} an array of the removed elements (might be empty)
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploader#removeAllParameters
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.FileUploaderParameter</code> in the aggregation named <code>parameters</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.FileUploaderParameter}
 *            oParameter the parameter whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploader#indexOfParameter
 * @function
 */
	

/**
 * Destroys all the parameters in the aggregation 
 * named <code>parameters</code>.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploader#destroyParameters
 * @function
 */


/**
 * Getter for aggregation <code>headerParameters</code>.<br/>
 * The header parameters for the FileUploader which are only submitted with XHR requests. Header parameters are not supported by Internet Explorer 8 and 9.
 * 
 * @return {sap.ui.unified.FileUploaderParameter[]}
 * @public
 * @name sap.ui.unified.FileUploader#getHeaderParameters
 * @function
 */


/**
 * Inserts a headerParameter into the aggregation named <code>headerParameters</code>.
 *
 * @param {sap.ui.unified.FileUploaderParameter}
 *          oHeaderParameter the headerParameter to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the headerParameter should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the headerParameter is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the headerParameter is inserted at 
 *             the last position        
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#insertHeaderParameter
 * @function
 */

/**
 * Adds some headerParameter <code>oHeaderParameter</code> 
 * to the aggregation named <code>headerParameters</code>.
 *
 * @param {sap.ui.unified.FileUploaderParameter}
 *            oHeaderParameter the headerParameter to add; if empty, nothing is inserted
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#addHeaderParameter
 * @function
 */

/**
 * Removes an headerParameter from the aggregation named <code>headerParameters</code>.
 *
 * @param {int | string | sap.ui.unified.FileUploaderParameter} vHeaderParameter the headerParameter to remove or its index or id
 * @return {sap.ui.unified.FileUploaderParameter} the removed headerParameter or null
 * @public
 * @name sap.ui.unified.FileUploader#removeHeaderParameter
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>headerParameters</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.FileUploaderParameter[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.FileUploader#removeAllHeaderParameters
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.FileUploaderParameter</code> in the aggregation named <code>headerParameters</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.FileUploaderParameter}
 *            oHeaderParameter the headerParameter whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.FileUploader#indexOfHeaderParameter
 * @function
 */
	

/**
 * Destroys all the headerParameters in the aggregation 
 * named <code>headerParameters</code>.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#destroyHeaderParameters
 * @function
 */


/**
 * Event is fired when the value of the file path has been changed.
 *
 * @name sap.ui.unified.FileUploader#change
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.newValue New file path value.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'change' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired when the value of the file path has been changed.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#attachChange
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'change' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#detachChange
 * @function
 */

/**
 * Fire event change to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'newValue' of type <code>string</code> New file path value.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.FileUploader#fireChange
 * @function
 */


/**
 * Event is fired as soon as the upload request is completed (either successful or unsuccessful). To see if the upload request was successful, check the 'state' parameter for a value 2xx.
 * The uploads actual progress can be retrieved via the 'uploadProgress' Event.
 * However this covers only the client side of the Upload process and does not give any success status from the server.
 *
 * @name sap.ui.unified.FileUploader#uploadComplete
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.response Response message which comes from the server. On the server side this response has to be put within the &quot;body&quot; tags of the response document of the iFrame. It can consist of a return code and an optional message. This does not work in cross-domain scenarios.
 * @param {string} oControlEvent.getParameters.readyStateXHR ReadyState of the XHR request. Required for receiving a readyState is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.
 * @param {string} oControlEvent.getParameters.status Status of the XHR request. Required for receiving a status is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.
 * @param {string} oControlEvent.getParameters.responseRaw Http-Response which comes from the server. Required for receiving "responseRaw" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.
 * @param {object} oControlEvent.getParameters.headers Http-Response-Headers which come from the server. provided as a JSON-map, i.e. each header-field is reflected by a property in the header-object, with the property value reflecting the header-field's content. Required for receiving "header" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'uploadComplete' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired as soon as the upload request is completed (either successful or unsuccessful). To see if the upload request was successful, check the 'state' parameter for a value 2xx.
 * The uploads actual progress can be retrieved via the 'uploadProgress' Event.
 * However this covers only the client side of the Upload process and does not give any success status from the server.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#attachUploadComplete
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'uploadComplete' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#detachUploadComplete
 * @function
 */

/**
 * Fire event uploadComplete to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'response' of type <code>string</code> Response message which comes from the server. On the server side this response has to be put within the &quot;body&quot; tags of the response document of the iFrame. It can consist of a return code and an optional message. This does not work in cross-domain scenarios.</li>
 * <li>'readyStateXHR' of type <code>string</code> ReadyState of the XHR request. Required for receiving a readyState is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.</li>
 * <li>'status' of type <code>string</code> Status of the XHR request. Required for receiving a status is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.</li>
 * <li>'responseRaw' of type <code>string</code> Http-Response which comes from the server. Required for receiving "responseRaw" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.</li>
 * <li>'headers' of type <code>object</code> Http-Response-Headers which come from the server. provided as a JSON-map, i.e. each header-field is reflected by a property in the header-object, with the property value reflecting the header-field's content. Required for receiving "header" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.FileUploader#fireUploadComplete
 * @function
 */


/**
 * Event is fired when the type of a file does not match the mimeType or fileType property.
 *
 * @name sap.ui.unified.FileUploader#typeMissmatch
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.fileName The name of a file to be uploaded.
 * @param {string} oControlEvent.getParameters.fileType The file ending of a file to be uploaded.
 * @param {string} oControlEvent.getParameters.mimeType The MIME type of a file to be uploaded.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'typeMissmatch' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired when the type of a file does not match the mimeType or fileType property.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#attachTypeMissmatch
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'typeMissmatch' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#detachTypeMissmatch
 * @function
 */

/**
 * Fire event typeMissmatch to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'fileName' of type <code>string</code> The name of a file to be uploaded.</li>
 * <li>'fileType' of type <code>string</code> The file ending of a file to be uploaded.</li>
 * <li>'mimeType' of type <code>string</code> The MIME type of a file to be uploaded.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.FileUploader#fireTypeMissmatch
 * @function
 */


/**
 * Event is fired when the size of a file is above the maximumFileSize property. This event is not supported by Internet Explorer 8 and 9 (same restriction as for the property maximumFileSize).
 *
 * @name sap.ui.unified.FileUploader#fileSizeExceed
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.fileName The name of a file to be uploaded.
 * @param {string} oControlEvent.getParameters.fileSize The size in MB of a file to be uploaded.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'fileSizeExceed' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired when the size of a file is above the maximumFileSize property. This event is not supported by Internet Explorer 8 and 9 (same restriction as for the property maximumFileSize).
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#attachFileSizeExceed
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'fileSizeExceed' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#detachFileSizeExceed
 * @function
 */

/**
 * Fire event fileSizeExceed to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'fileName' of type <code>string</code> The name of a file to be uploaded.</li>
 * <li>'fileSize' of type <code>string</code> The size in MB of a file to be uploaded.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.FileUploader#fireFileSizeExceed
 * @function
 */


/**
 * Event is fired when the file is allowed for upload on client side.
 *
 * @name sap.ui.unified.FileUploader#fileAllowed
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'fileAllowed' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired when the file is allowed for upload on client side.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#attachFileAllowed
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'fileAllowed' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.FileUploader#detachFileAllowed
 * @function
 */

/**
 * Fire event fileAllowed to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.FileUploader#fireFileAllowed
 * @function
 */


/**
 * Event is fired after the upload has started and before the upload is completed and contains progress information related to the running upload. Depending on file size, band width and used browser the event is fired once or multiple times.
 * This is event is only supported with property sendXHR set to true, i.e. the event is not supported in Internet Explorer 8 or 9.
 *
 * @name sap.ui.unified.FileUploader#uploadProgress
 * @event
 * @since 1.24.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {boolean} oControlEvent.getParameters.lengthComputable Indicates whether or not the relative upload progress can be calculated out of loaded and total.
 * @param {float} oControlEvent.getParameters.loaded The number of bytes of the file which have been uploaded by to the time the event was fired.
 * @param {float} oControlEvent.getParameters.total The total size of the file to be uploaded in byte.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'uploadProgress' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired after the upload has started and before the upload is completed and contains progress information related to the running upload. Depending on file size, band width and used browser the event is fired once or multiple times.
 * This is event is only supported with property sendXHR set to true, i.e. the event is not supported in Internet Explorer 8 or 9.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#attachUploadProgress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'uploadProgress' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#detachUploadProgress
 * @function
 */

/**
 * Fire event uploadProgress to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'lengthComputable' of type <code>boolean</code> Indicates whether or not the relative upload progress can be calculated out of loaded and total.</li>
 * <li>'loaded' of type <code>float</code> The number of bytes of the file which have been uploaded by to the time the event was fired.</li>
 * <li>'total' of type <code>float</code> The total size of the file to be uploaded in byte.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#fireUploadProgress
 * @function
 */


/**
 * Event is fired after the current upload has been aborted.
 * This is event is only supported with property sendXHR set to true, i.e. the event is not supported in Internet Explorer 8 or 9.
 *
 * @name sap.ui.unified.FileUploader#uploadAborted
 * @event
 * @since 1.24.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'uploadAborted' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired after the current upload has been aborted.
 * This is event is only supported with property sendXHR set to true, i.e. the event is not supported in Internet Explorer 8 or 9.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#attachUploadAborted
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'uploadAborted' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#detachUploadAborted
 * @function
 */

/**
 * Fire event uploadAborted to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#fireUploadAborted
 * @function
 */


/**
 * Event is fired, if the filename of a chosen file is longer than the value specified with the maximumFilenameLength property.
 *
 * @name sap.ui.unified.FileUploader#filenameLengthExceed
 * @event
 * @since 1.24.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.fileName The filename, which is longer than specified by the value of the property maximumFilenameLength.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'filenameLengthExceed' event of this <code>sap.ui.unified.FileUploader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.FileUploader</code>.<br/> itself. 
 *  
 * Event is fired, if the filename of a chosen file is longer than the value specified with the maximumFilenameLength property.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.FileUploader</code>.<br/> itself.
 *
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#attachFilenameLengthExceed
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'filenameLengthExceed' event of this <code>sap.ui.unified.FileUploader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @public
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#detachFilenameLengthExceed
 * @function
 */

/**
 * Fire event filenameLengthExceed to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'fileName' of type <code>string</code> The filename, which is longer than specified by the value of the property maximumFilenameLength.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.FileUploader} <code>this</code> to allow method chaining
 * @protected
 * @since 1.24.0
 * @name sap.ui.unified.FileUploader#fireFilenameLengthExceed
 * @function
 */


/**
 * Starts the upload (as defined by uploadUrl)
 *
 * @name sap.ui.unified.FileUploader#upload
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Aborts the currently running upload.
 *
 * @name sap.ui.unified.FileUploader#abort
 * @function
 * @type void
 * @public
 * @since 1.24.0
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Clears the content of the FileUploader. The attached additional data however is retained.
 *
 * @name sap.ui.unified.FileUploader#clear
 * @function
 * @type void
 * @public
 * @since 1.25.0
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\unified\FileUploader.js
/**
 * Initializes the control.
 * It is called from the constructor.
 * @private
 */
sap.ui.unified.FileUploader.prototype.init = function(){

	// Instantiate browser-specific UI-Elements (IE8 only): 
	// works fine with applySettings() after init() - most things are done in onAfterRendering
	// IE8 should render a native file uploader and the SAPUI5 controls should be exactly behind
	if (!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8) {
		this.oFilePath = new sap.ui.commons.TextField(this.getId() + "-fu_input",
													{width: "225px"});
		
		this.oBrowse = new sap.ui.commons.Button({enabled : this.getEnabled(),
			text: "Browse..",
			width: "0px",
			height: "0px"});
	} else {
		//all other browsers will load the respective UI-Elements from the FileUploaderHelper
		this.oFilePath = sap.ui.unified.FileUploaderHelper.createTextField(this.getId() + "-fu_input");
		this.oBrowse = sap.ui.unified.FileUploaderHelper.createButton();
	}
	this.oFilePath.setParent(this);
	this.oBrowse.setParent(this);

	this.oFileUpload = null;

	//retrieving the default browse button text from the resource bundle
	this.oBrowse.setText(this.getBrowseText());

//	var that = this;
//	var oDelegate = {
//		onfocusin : function(){
//			var jFO = jQuery.sap.byId(that.getId() + "-fu");
//			if(jFO.length > 0){
//				jFO[0].focus();
//			}
//		}
//	};
//	this.oFilePath.addDelegate(oDelegate);
//	this.oBrowse.addDelegate(oDelegate);

};

sap.ui.unified.FileUploader.prototype.setButtonText = function(sText) {
	this.oBrowse.setText(sText || this.getBrowseText());
	this.setProperty("buttonText", sText, false);
	return this;
};

sap.ui.unified.FileUploader.prototype.getIdForLabel = function () {
	return this.oBrowse.getId();
};

sap.ui.unified.FileUploader.prototype.setFileType = function(vTypes) {
	// Compatibility issue: converting the given types to an array in case it is a string
	var aTypes = this._convertTypesToArray(vTypes);
	this.setProperty("fileType", aTypes, false);
	return this;
};

sap.ui.unified.FileUploader.prototype.setMimeType = function(vTypes) {
	// Compatibility issue: converting the given types to an array in case it is a string
	var aTypes = this._convertTypesToArray(vTypes);
	this.setProperty("mimeType", aTypes, false);
	return this;
};

/**
 * Helper to ensure, that the types (file or mime) are inside an array.
 * The FUP also accepts comma-separated strings for its fileType and mimeType property. 
 * @private
 */
sap.ui.unified.FileUploader.prototype._convertTypesToArray = function (vTypes) {
	if (typeof vTypes === "string") {
		if(vTypes === ""){
			return [];
		} else {
			return vTypes.split(",");
		}
	}
	return vTypes;
};

/**
 * Terminates the control when it has been destroyed.
 * @private
 */
sap.ui.unified.FileUploader.prototype.exit = function(){

	// destroy the nested controls
	this.oFilePath.destroy();
	this.oBrowse.destroy();

	// remove the IFRAME
	if (this.oIFrameRef) {
		jQuery(this.oIFrameRef).unbind();
		sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);
		this.oIFrameRef = null;
	}

};

/**
 * Clean up event listeners before rendering
 * @private
 */
sap.ui.unified.FileUploader.prototype.onBeforeRendering = function() {

	// store the file uploader outside in the static area
	var oStaticArea = sap.ui.getCore().getStaticAreaRef();
	jQuery(this.oFileUpload).appendTo(oStaticArea);

	// unbind the custom event handlers in case of IE8
	jQuery(this.oFileUpload).unbind();

};

/**
 * Prepare the upload processing, establish the change handler for the
 * pure html input object.
 * @private
 */
sap.ui.unified.FileUploader.prototype.onAfterRendering = function() {

	// prepare the file upload control and the upload iframe
	this.prepareFileUploadAndIFrame();

	// event listener registration for change event in IE8 because the change
	// event is not bubbling for IE8 => so we do this for all browsers!
	jQuery(this.oFileUpload).change(jQuery.proxy(this.handlechange, this));

	// IE8 should render a native file uploader and don't need the witdh calculation
	if ((!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 8)) {
		this.oBrowse.getDomRef().style.padding = "0px";
		this.oBrowse.getDomRef().style.visibility = "hidden";
		this.oFilePath.getDomRef().style.height = "20px";
		this.oFilePath.getDomRef().style.visibility = "hidden";
		jQuery(this.oFilePath.getDomRef()).removeClass('sapUiTfBrd');
	} else {
		this.oFilePath.$().attr("tabindex", "-1");
		// in case of IE9 we prevent the browse button from being focused because the
		// native file uploader requires the focus for catching the keyboard events
		if ((!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 9)) {
			this.oBrowse.$().attr("tabindex", "-1");
		}
		jQuery.sap.delayedCall(0, this, this._recalculateWidth);
	}
	
};

sap.ui.unified.FileUploader.prototype._recalculateWidth = function() {
	// calculation of the width of the overlay for the original file upload
	// !!!sap.ui.Device.browser.internet_explorer check: only for non IE browsers since there we need
	// the button in front of the fileuploader
	if (this.getWidth()) {
		if(this.getButtonOnly()) {
			this.oBrowse.getDomRef().style.width = this.getWidth();
		} else {
			// Recalculate the textfield width...
			this._resizeDomElements();
		}
	}
};

/**
 * Returns the DOM element that should be focused when focus is set onto the control.
 */
sap.ui.unified.FileUploader.prototype.getFocusDomRef = function() {
	return this.$("fu").get(0);
};

sap.ui.unified.FileUploader.prototype._resizeDomElements = function() {
	var sId = this.getId();
	this._oBrowseDomRef = this.oBrowse.getDomRef();
	var $b = jQuery(this._oBrowseDomRef);
	var _buttonWidth = $b.parent().outerWidth(true);
	this._oFilePathDomRef = this.oFilePath.getDomRef();
	var oDomRef = this._oFilePathDomRef;
	var sWidth = this.getWidth();

	if (sWidth.substr(-1) == "%") {
		// Special case - if the width is not in px, we only change the top element

		// Resize all elements from the input field up to the control element itself.
		while (oDomRef.id != sId) {
			oDomRef.style.width = "100%";
			oDomRef = oDomRef.parentNode;
		}

		oDomRef.style.width = sWidth;
	} else {
		oDomRef.style.width = sWidth;

		// Now make sure the field including the button has the correct size
		var $fp = jQuery(this._oFilePathDomRef);
		var _newWidth = $fp.outerWidth() - _buttonWidth;
		if (_newWidth < 0) {
			this.oFilePath.getDomRef().style.width = "0px";
			if (!!!sap.ui.Device.browser.internet_explorer) {
				this.oFileUpload.style.width = $b.outerWidth(true);
			}
		} else {
			this.oFilePath.getDomRef().style.width = _newWidth + "px";
		}
	}
};

sap.ui.unified.FileUploader.prototype.onresize = function() {
	this._recalculateWidth();
};

sap.ui.unified.FileUploader.prototype.onThemeChanged = function() {
	this._recalculateWidth();
};

sap.ui.unified.FileUploader.prototype.setEnabled = function(bEnabled){
	this.setProperty("enabled", bEnabled, true);
	this.oFilePath.setEnabled(bEnabled);
	this.oBrowse.setEnabled(bEnabled);
	if (bEnabled) {
		this.$("fu").removeAttr('disabled');
	} else {
		this.$("fu").attr('disabled', 'disabled');
	}
	return this;
};

sap.ui.unified.FileUploader.prototype.setValueState = function(sValueState) {
	this.setProperty("valueState", sValueState);
	//as of 1.23.1 oFilePath can be a sap.ui.commons.TextField or a sap.m.Input, which both have a valueState
	if (this.oFilePath.setValueState) {
		this.oFilePath.setValueState(sValueState);
	}
	return this;
};

sap.ui.unified.FileUploader.prototype.setUploadUrl = function(sValue, bFireEvent) {
	this.setProperty("uploadUrl", sValue, true);
	var $uploadForm = this.$("fu_form");
	$uploadForm.attr("action", this.getUploadUrl());
	return this;
};

sap.ui.unified.FileUploader.prototype.setPlaceholder = function(sPlaceholder) {
	this.setProperty("placeholder", sPlaceholder, true);
	this.oFilePath.setPlaceholder(sPlaceholder);
	return this;
};

sap.ui.unified.FileUploader.prototype.setStyle = function(sStyle) {
	this.setProperty("style", sStyle, true);
	if (sStyle == "Transparent") {
		if (this.oBrowse.setLite) {
			this.oBrowse.setLite(true);
		} else {
			this.oBrowse.setType("Transparent");
		}
	} else {
		if (this.oBrowse.setType) {
			this.oBrowse.setType(sStyle);
		} else {
			if (sStyle == "Emphasized") {
				sStyle = "Emph";
			}
			this.oBrowse.setStyle(sStyle);
		}
	}
	return this;
};

sap.ui.unified.FileUploader.prototype.setValue = function(sValue, bFireEvent, bSupressFocus) {
	var oldValue = this.getValue();
	if((oldValue != sValue) || this.getSameFilenameAllowed()) {
		// only upload when a valid value is set
		var bUpload = this.getUploadOnChange() && sValue;
		// when we do not upload we re-render (cause some browsers don't like
		// to change the value of file uploader INPUT elements)
		this.setProperty("value", sValue, bUpload);
		if (this.oFilePath) {
			this.oFilePath.setValue(sValue);
			//refocus the filepath input field, except in IE8 or if bSupressFocus is set
			if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8) && this.oFilePath.getFocusDomRef() && !bSupressFocus) {
				this.oFilePath.getFocusDomRef().focus();
			}
		}
		var oForm = this.getDomRef("fu_form"),
			sapMInnerInput = this.getDomRef("fu_input-inner");
		//reseting the input fields if setValue("") is called, also for undefined and null
		if (this.oFileUpload && /* is visible: */ oForm && !sValue) {
			// some browsers do not allow to clear the value of the fileuploader control
			// therefore we utilize the form and reset the values inside this form and
			// apply the additionalData again afterwards
			oForm.reset();
			this.getDomRef("fu_input").value = "";
			//if the sap.m library is used, we also need to clear the inner input-field of sap.m.Input
			if (sapMInnerInput){
				sapMInnerInput.value = "";
			}
			//keep the additional data on the form
			this.$("fu_data").val(this.getAdditionalData());
		}
		// only fire event when triggered by user interaction
		if (bFireEvent) {
			this.fireChange({id:this.getId(), newValue:sValue});
		}
		if (bUpload) {
			this.upload();
		}
	}
	return this;
};

sap.ui.unified.FileUploader.prototype.clear = function () {
	//clear the value, don't fire change event, and supress the refocusing of the file input field
	return this.setValue("", false, true);
};

sap.ui.unified.FileUploader.prototype.onmouseover = function () {
	jQuery(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover');
};

sap.ui.unified.FileUploader.prototype.onmouseout = function () {
	jQuery(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover');
};

sap.ui.unified.FileUploader.prototype.onfocusin = function () {
	jQuery(this.oBrowse.getDomRef()).addClass('sapUiBtnStdFocus').attr("tabindex", "-1");
	jQuery(this.oFilePath.getDomRef()).removeClass('sapUiTfFoc');
	this.focus();
};

sap.ui.unified.FileUploader.prototype.onfocusout = function () {
	jQuery(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdFocus').attr("tabindex", "0");
};

sap.ui.unified.FileUploader.prototype.setAdditionalData = function(sAdditionalData) {
	// set the additional data in the hidden input
	this.setProperty("additionalData", sAdditionalData, true);
	var oAdditionalData = this.getDomRef("fu_data");
	if (oAdditionalData) {
		var sAdditionalData = this.getAdditionalData() || "";
		oAdditionalData.value = sAdditionalData;
	}
	return this;
};

sap.ui.unified.FileUploader.prototype.upload = function() {

	var uploadForm = this.getDomRef("fu_form"),
		that = this;
	
	try {
		if (uploadForm) {
			this._bUploading = true;
			if (this.getSendXHR() && window.File) {
				var oFiles = jQuery.sap.domById(this.getId() + "-fu").files;
				if (oFiles.length > 0) {
					//keep a reference on the current upload xhr
					var xhr = this._uploadXHR = new window.XMLHttpRequest();
					xhr.upload.addEventListener("progress", function(oProgressEvent) {
						var oProgressData = {
							lengthComputable: !!oProgressEvent.lengthComputable,
							loaded: oProgressEvent.loaded,
							total: oProgressEvent.total
						};
						that.fireUploadProgress(oProgressData);
					});
					//relay the abort event, if the xhr was aborted manually
					xhr.upload.addEventListener("abort", function(oAbortEvent){
						that.fireUploadAborted();
					});
					
					xhr.open("POST", this.getUploadUrl(), true);
					if (this.getHeaderParameters()) {
						var oHeaderParams = this.getHeaderParameters();
						for (var i = 0; i < oHeaderParams.length; i++) {
							var sHeader = oHeaderParams[i].getName();
							var sValue = oHeaderParams[i].getValue();
							xhr.setRequestHeader(sHeader, sValue);
						}
					}
					if (this.getUseMultipart()) {
						var formData = new window.FormData();
						var name = jQuery.sap.domById(this.getId() + "-fu").name;
						for (var i = 0; i < oFiles.length; i++) {
							formData.append(name, oFiles[i]);
						}
						formData.append("_charset_", "UTF-8");
						var data = jQuery.sap.domById(this.getId() + "-fu_data").name;
						if (this.getAdditionalData()) {
							var sData = this.getAdditionalData();
							formData.append(data, sData);
						} else {
							formData.append(data, "");
						}
						if (this.getParameters()) {
							var oParams = this.getParameters();
							for (var i = 0; i < oParams.length; i++) {
								var sName = oParams[i].getName();
								var sValue = oParams[i].getValue();
								formData.append(sName, sValue);
							}
						}
						xhr.send(formData);
					} else {
						xhr.send(oFiles[0]);
					}

					xhr.onreadystatechange = function() {
						var sResponse;
						var sResponseRaw;
						var mHeaders = {};
						var sPlainHeader;
						var aHeaderLines;
						var iHeaderIdx;
						var sReadyState = xhr.readyState;
						var sStatus = xhr.status;
						if (xhr.readyState == 4) {
							//this check is needed, because (according to the xhr spec) the readyState is set to OPEN (4)
							//as soon as the xhr is aborted. Only after the progress events are fired, the state is set to UNSENT (0)
							if (xhr.responseXML) {
								sResponse = xhr.responseXML.documentElement.textContent;
							}
							sResponseRaw = xhr.response;
							
							//Parse the http-header into a map
							sPlainHeader = xhr.getAllResponseHeaders();
							if (sPlainHeader) {
								aHeaderLines = sPlainHeader.split("\u000d\u000a")
								for (var i = 0; i < aHeaderLines.length; i++) {
									if (aHeaderLines[i]) {
										iHeaderIdx = aHeaderLines[i].indexOf("\u003a\u0020");
										mHeaders[aHeaderLines[i].substring(0, iHeaderIdx)] = aHeaderLines[i].substring(iHeaderIdx + 2);
									}
								}
							}
							that.fireUploadComplete({
								"headers": mHeaders,
								"response": sResponse,
								"responseRaw": sResponseRaw,
								"readyStateXHR": sReadyState,
								"status": sStatus
							});
						}
						that._bUploading = false;
					}
					this._bUploading = false;
				}
			} else {
				uploadForm.submit();
			}
			jQuery.sap.log.info("File uploading to " + this.getUploadUrl());
			if (this.getSameFilenameAllowed() && this.getUploadOnChange()) {
				this.setValue("", true);
			}
		}
	} catch(oException) {
		jQuery.sap.log.error("File upload failed:\n" + oException.message);
	}
};

/**
 * Aborts the currently running Upload.
 * @public
 */
sap.ui.unified.FileUploader.prototype.abort = function() {
	if (this._uploadXHR && this._uploadXHR.abort) {
		//fires a progress event 'abort' on the _uploadXHR
		this._uploadXHR.abort();
	}
};

sap.ui.unified.FileUploader.prototype.onkeypress = function(oEvent) {
	this.onkeydown(oEvent);
};

sap.ui.unified.FileUploader.prototype.onclick = function(oEvent) {
	if (this.getSameFilenameAllowed()) {
		this.setValue("", true);
	}
};

//
//Event Handling
//
sap.ui.unified.FileUploader.prototype.onkeydown = function(oEvent) {
	if (!this.getEnabled()) {
		return;
	}
	if (this.getSameFilenameAllowed()) {
		this.setValue("", true);
	}
	var iKeyCode = oEvent.keyCode,
		eKC = jQuery.sap.KeyCodes;
	if (iKeyCode == eKC.DELETE || iKeyCode == eKC.BACKSPACE) {
		if (this.oFileUpload) {
			this.setValue("", true);
		}
	} else if (iKeyCode == eKC.SPACE || iKeyCode == eKC.ENTER) {
		// this does not work for IE9 and downwards! TODO: check with IE10/11
		// consider to always put the focus on the hidden file uploader
		// and let the fileuploader manager the keyboard interaction
		if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 9) && this.oFileUpload) {
			this.oFileUpload.click();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	} else if (iKeyCode != eKC.TAB &&
				iKeyCode != eKC.SHIFT &&
				iKeyCode != eKC.F6) {
		oEvent.preventDefault();
		oEvent.stopPropagation();
	}
};

/**
 * Helper function to check if the given filename is longer than the specified 'maximumFilenameLength'.
 * @param {string} [sFilename] the filename which should be tested
 * @param {boolean} [bFireEvent] if necessary, this flag triggers that a filenameLengthExceed event is fired 
 * @returns {boolean} whether the filename is too long or not
 * @private
 */
sap.ui.unified.FileUploader.prototype._isFilenameTooLong = function (sFilename) {
	var iMaxFilenameLength = this.getMaximumFilenameLength();
	if (iMaxFilenameLength !== 0 && sFilename.length > iMaxFilenameLength) {
		jQuery.sap.log.info("The filename of " + sFilename + " (" + sFilename.length + " characters)  is longer than the maximum of " + iMaxFilenameLength + " characters.");
		return true;
	}
	
	return false;
}

sap.ui.unified.FileUploader.prototype.handlechange = function(oEvent) {
	if (this.oFileUpload && this.getEnabled()) {

		var fMaxSize = this.getMaximumFileSize();

		var aFileTypes = this.getFileType();
		var aMimeTypes = this.getMimeType();

		var sFileString = '';

		if (window.File) {
			var oFiles = oEvent.target.files;

			for (var i = 0; i < oFiles.length; i++) {
				var iCount = i + 1;
				var sName = oFiles[i].name;
				var sNameLength = sName.length;
				var sType = oFiles[i].type;
				if (!sType) {
					sType = "unknown";
				}
				var fSize = ((oFiles[i].size/1024)/1024);
				if (fMaxSize && (fSize > fMaxSize)) {
					jQuery.sap.log.info("File: " + sName + " is of size " + fSize + " MB which exceeds the file size limit of " + fMaxSize + " MB.");
					this.fireFileSizeExceed({
						fileName:sName,
						fileSize:fSize
					});
					return;
				}
				//check if the filename is too long and fire the corresponding event if necessary
				if (this._isFilenameTooLong(sName)) {
					this.fireFilenameLengthExceed({
						fileName: sName
					});
					return;
				}
				//check allowed mime-types for potential mismatches
				if (aMimeTypes && aMimeTypes.length > 0) {
					var bWrongMime = true;
					for (var j = 0; j < aMimeTypes.length; j++) {
						if (sType.match(aMimeTypes[j])) {
							bWrongMime = false;
						}
					}
					if (bWrongMime) {
						jQuery.sap.log.info("File: " + sName + " is of type " + sType + ". Allowed types are: "  + aMimeTypes + ".");
						this.fireTypeMissmatch({
							fileName:sName,
							mimeType:sType
						});
						return;
					}
				}
				//check allowed file-types for potential mismatches
				if (aFileTypes && aFileTypes.length > 0) {
					var bWrongType = true;
					var iIdx = sName.lastIndexOf(".");
					var sFileEnding = sName.substring(iIdx + 1);
					for (var k = 0; k < aFileTypes.length; k++) {
						if (sFileEnding == aFileTypes[k]) {
							bWrongType = false;
						}
					}
					if (bWrongType) {
						jQuery.sap.log.info("File: " + sName + " is of type " + sFileEnding + ". Allowed types are: "  + aFileTypes + ".");
						this.fireTypeMissmatch({
							fileName:sName,
							fileType:sFileEnding
						});
						return;
					}
				}
				sFileString = sFileString + '"' + oFiles[i].name + '" ';
			}
			if (sFileString) {
				this.fireFileAllowed();
			}
		} else if (aFileTypes && aFileTypes.length > 0) {
			// This else case is executed if the File-API is not supported by the browser (especially IE8/9).
			// Check if allowed file types match the chosen file from the oFileUpload IFrame Workaround.
			var bWrongType = true;
			var sName = this.oFileUpload.value || "";
			var iIdx = sName.lastIndexOf(".");
			var sFileEnding = sName.substring(iIdx + 1);
			for (var k = 0; k < aFileTypes.length; k++) {
				if (sFileEnding == aFileTypes[k]) {
					bWrongType = false;
				}
			}
			if (bWrongType) {
				jQuery.sap.log.info("File: " + sName + " is of type " + sFileEnding + ". Allowed types are: "  + aFileTypes + ".");
				this.fireTypeMissmatch({
					fileName:sName,
					fileType:sFileEnding
				});
				return;
			}
			//check if the filename is too long and fire the corresponding event if necessary
			if (this._isFilenameTooLong(sName)) {
				this.fireFilenameLengthExceed({
					fileName: sName
				});
				return;
			}
			if (sName) {
				this.fireFileAllowed();
			}
		}

		// due to new security mechanism modern browsers simply
		// append a fakepath in front of the filename instead of
		// returning the filename only - we strip this path now
		var sValue = this.oFileUpload.value || "";
		var iIndex = sValue.lastIndexOf("\\");
		if (iIndex >= 0) {
			sValue = sValue.substring(iIndex + 1);
		}
		if (this.getMultiple() && !sap.ui.Device.browser.internet_explorer) {
			sValue = sFileString;
		}

		//sValue has to be filled to avoid clearing the FilePath by pressing cancel
		if (sValue || sap.ui.Device.browser.chrome) { // in Chrome the file path has to be cleared as the upload will be avoided
			this.setValue(sValue, true);
		}
	}
};

//
//	Private
//

/**
 * Helper to retrieve the I18N texts for a button
 * @private
 */
sap.ui.unified.FileUploader.prototype.getBrowseText = function() {
	var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
	var sText = undefined;
	if (rb) {
		sText = rb.getText("FILEUPLOAD_BROWSE");
	}
	return sText ? sText : "Browse...";
};

/**
 * Getter for shortened value.
 * @private
 * @deprecated the value now is the short value (filename only)!
 */
sap.ui.unified.FileUploader.prototype.getShortenValue = function() {
	return this.getValue();
};

/**
 * Prepares the hidden IFrame for uploading the file (in static area).
 * @private
 */
sap.ui.unified.FileUploader.prototype.prepareFileUploadAndIFrame = function() {

	if (!this.oFileUpload) {

		// create the file uploader markup
		var aFileUpload = [];
		aFileUpload.push('<input ');
		aFileUpload.push('type="file" ');
		if (this.getName()) {
			if (this.getMultiple() && !sap.ui.Device.browser.internet_explorer) {
				aFileUpload.push('name="' + this.getName() + '[]" ');
			} else {
				aFileUpload.push('name="' + this.getName() + '" ');
			}
		} else {
			if (this.getMultiple() && !sap.ui.Device.browser.internet_explorer) {
				aFileUpload.push('name="' + this.getId() + '[]" ');
			} else {
				aFileUpload.push('name="' + this.getId() + '" ');
			}
		}
		aFileUpload.push('id="' + this.getId() + '-fu" ');
		if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8)) {
			// for IE9 the file uploader itself gets the focus to make sure that the
			// keyboard interaction works and there is no security issue - unfortunately
			// this has the negative side effect that 2 tabs are required.
			if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 9)) {
				aFileUpload.push('tabindex="-1" ');
			}
			aFileUpload.push('size="1" ');
		}
		if (this.getTooltip_AsString() ) {
			aFileUpload.push('title="' + jQuery.sap.escapeHTML(this.getTooltip_AsString()) + '" ');
		} else if (this.getTooltip() ) {
			// object tooltip, do nothing - tooltip will be displayed
		} else if (this.getValue() != "") {
			// only if there is no tooltip, then set value as fallback
			aFileUpload.push('title="' + jQuery.sap.escapeHTML(this.getValue()) + '" ');
		}
		if (!this.getEnabled()) {
			aFileUpload.push('disabled="disabled" ');
		}
		if (this.getMultiple() && !sap.ui.Device.browser.internet_explorer) {
			aFileUpload.push('multiple ');
		}
		aFileUpload.push('>');

		// add it into the control markup
		this.oFileUpload = jQuery(aFileUpload.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0);

	} else {

		// move the file uploader from the static area to the control markup
		jQuery(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"));

	}

	if (!this.oIFrameRef) {

		// create the upload iframe
		var uploadForm = this.getDomRef("fu_form");
		var oIFrameRef = document.createElement("iframe");
		oIFrameRef.style.display = "none";
		oIFrameRef.src = "javascript:''";
		oIFrameRef.id = this.sId + "-frame";
		sap.ui.getCore().getStaticAreaRef().appendChild(oIFrameRef);
		oIFrameRef.contentWindow.name = this.sId + "-frame";

		// sink the load event of the upload iframe
		var that = this;
		this._bUploading = false; // flag for uploading (because of IE8 to make sure that complete is only triggered after upload)
		jQuery(oIFrameRef).load(function(oEvent) {
			if (that._bUploading) {
				jQuery.sap.log.info("File uploaded to " + that.getUploadUrl());
				var sResponse;
				try {
					sResponse = that.oIFrameRef.contentDocument.body.innerHTML;
				} catch (ex) {
					// in case of cross-domain submit we get a permission denied exception
					// when we try to access the body of the IFrame document
				}
				that.fireUploadComplete({"response": sResponse});
				that._bUploading = false;
			}
		});

		// keep the reference
		this.oIFrameRef = oIFrameRef;

	}
};

}; // end of sap/ui/unified/FileUploader.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.FileUploaderParameter') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.FileUploaderParameter.
jQuery.sap.declare("sap.ui.unified.FileUploaderParameter");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new FileUploaderParameter.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getName name} : string</li>
 * <li>{@link #getValue value} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Represents a parameter for the FileUploader which is rendered as a hidden inputfield.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.FileUploaderParameter
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.unified.FileUploaderParameter", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"name" : {type : "string", group : "Data", defaultValue : null},
		"value" : {type : "string", group : "Data", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.FileUploaderParameter with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.FileUploaderParameter.extend
 * @function
 */


/**
 * Getter for property <code>name</code>.
 * The name of the hidden inputfield.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>name</code>
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploaderParameter#getName
 * @function
 */

/**
 * Setter for property <code>name</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sName  new value for property <code>name</code>
 * @return {sap.ui.unified.FileUploaderParameter} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploaderParameter#setName
 * @function
 */


/**
 * Getter for property <code>value</code>.
 * The value of the hidden inputfield.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>value</code>
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploaderParameter#getValue
 * @function
 */

/**
 * Setter for property <code>value</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sValue  new value for property <code>value</code>
 * @return {sap.ui.unified.FileUploaderParameter} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.2
 * @name sap.ui.unified.FileUploaderParameter#setValue
 * @function
 */


// Start of sap\ui\unified\FileUploaderParameter.js

}; // end of sap/ui/unified/FileUploaderParameter.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuItemBase') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.MenuItemBase.
jQuery.sap.declare("sap.ui.unified.MenuItemBase");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new MenuItemBase.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getStartsSection startsSection} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getSubmenu submenu} <strong>(default aggregation)</strong> : sap.ui.unified.Menu</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.MenuItemBase#event:select select} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Provides the standard properties for menu items.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.MenuItemBase
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.unified.MenuItemBase", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"startsSection" : {type : "boolean", group : "Behavior", defaultValue : false}
	},
	defaultAggregation : "submenu",
	aggregations : {
		"submenu" : {type : "sap.ui.unified.Menu", multiple : false}
	},
	events : {
		"select" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.MenuItemBase with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.MenuItemBase.extend
 * @function
 */

sap.ui.unified.MenuItemBase.M_EVENTS = {'select':'select'};


/**
 * Getter for property <code>enabled</code>.
 * 
 * Disabled items have different colors, depending on customer settings.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.unified.MenuItemBase#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItemBase#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * 
 * Invisible controls are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.unified.MenuItemBase#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItemBase#setVisible
 * @function
 */


/**
 * Getter for property <code>startsSection</code>.
 * 
 * If set to true, a divider is displayed before the item
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>startsSection</code>
 * @public
 * @name sap.ui.unified.MenuItemBase#getStartsSection
 * @function
 */

/**
 * Setter for property <code>startsSection</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bStartsSection  new value for property <code>startsSection</code>
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItemBase#setStartsSection
 * @function
 */


/**
 * Getter for aggregation <code>submenu</code>.<br/>
 * Aggregation of a menu item's sub menu.
 * 
 * <strong>Note</strong>: this is the default aggregation for MenuItemBase.
 * @return {sap.ui.unified.Menu}
 * @public
 * @name sap.ui.unified.MenuItemBase#getSubmenu
 * @function
 */


/**
 * Setter for the aggregated <code>submenu</code>.
 * @param {sap.ui.unified.Menu} oSubmenu
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItemBase#setSubmenu
 * @function
 */
	

/**
 * Destroys the submenu in the aggregation 
 * named <code>submenu</code>.
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItemBase#destroySubmenu
 * @function
 */


/**
 * Event is fired when an item is selected. The event is also available for items having a sub menu.
 * A mouse click or space bar click on a sub menu item fires the event.
 *
 * @name sap.ui.unified.MenuItemBase#select
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.unified.MenuItemBase} oControlEvent.getParameters.item Represents the current item
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'select' event of this <code>sap.ui.unified.MenuItemBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.MenuItemBase</code>.<br/> itself. 
 *  
 * Event is fired when an item is selected. The event is also available for items having a sub menu.
 * A mouse click or space bar click on a sub menu item fires the event.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.MenuItemBase</code>.<br/> itself.
 *
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItemBase#attachSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'select' event of this <code>sap.ui.unified.MenuItemBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItemBase#detachSelect
 * @function
 */

/**
 * Fire event select to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'item' of type <code>sap.ui.unified.MenuItemBase</code> Represents the current item</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.MenuItemBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.MenuItemBase#fireSelect
 * @function
 */


// Start of sap\ui\unified\MenuItemBase.js
sap.ui.unified.MenuItemBase.prototype.init = function(){
   // do something for initialization...
};

/**
 * @param {object} oRenderManager
 * @param {object} oItem
 * @param {object} oMenu
 * @protected
 */
sap.ui.unified.MenuItemBase.prototype.render = function(oRenderManager, oItem, oMenu){
	// Subclasses have to override this: Called when the item is rendered
	var rm = oRenderManager;
	rm.write("<li");
	rm.writeElementData(oItem);
	rm.write("><div style=\"white-space:nowrap;display:inline-block;padding:1px;color:black;\" id=\""+this.getId()+"-txt\">");
	rm.write(oItem.getId());
	if(this.getSubmenu()){
		rm.write("&nbsp;&nbsp;->");
	}
	rm.write("</div></li>");
};

/** 
 * @param {boolean} bHovered
 * @param {object} oMenu
 * @protected
 */
sap.ui.unified.MenuItemBase.prototype.hover = function(bHovered, oMenu){
	// Subclasses have to override this: Called when the item is hovered
	this.$("txt").attr("style", bHovered ? "white-space:nowrap;display:inline-block;padding:1px;color:red;" : "white-space:nowrap;display:inline-block;padding:1px;color:black;");
};

/** 
 * @param {boolean} bOpened
 * @protected
 */
sap.ui.unified.MenuItemBase.prototype.onSubmenuToggle = function(bOpened){
	// Subclasses may override this: Called when the items submenu is opend or closed
	this.$().toggleClass("sapUiMnuItmSubMnuOpen", bOpened);
};

/**
 * @protected
 */
sap.ui.unified.MenuItemBase.prototype.onAfterRendering = function(){
	// Subclasses may override this: Called after the item is rendered
};



sap.ui.unified.MenuItemBase.prototype.onmouseover = function(oEvent){
	var oParent = this.getParent();
	if(oParent && oParent instanceof sap.ui.unified.Menu && this.getTooltip() instanceof sap.ui.core.TooltipBase){
		//TooltipBase stops the event propagation
		oParent.onmouseover(oEvent);
	}
};
}; // end of sap/ui/unified/MenuItemBase.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuTextFieldItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.MenuTextFieldItem.
jQuery.sap.declare("sap.ui.unified.MenuTextFieldItem");




/**
 * Constructor for a new MenuTextFieldItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getLabel label} : string</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getValue value} : string</li>
 * <li>{@link #getValueState valueState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.MenuItemBase#constructor sap.ui.unified.MenuItemBase}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Menu item which contains an text field. This menu item is e.g. helpful for filters.
 * The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
 * @extends sap.ui.unified.MenuItemBase
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.MenuTextFieldItem
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.MenuItemBase.extend("sap.ui.unified.MenuTextFieldItem", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"label" : {type : "string", group : "Appearance", defaultValue : null},
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"value" : {type : "string", group : "Misc", defaultValue : null},
		"valueState" : {type : "sap.ui.core.ValueState", group : "Appearance", defaultValue : sap.ui.core.ValueState.None}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.MenuTextFieldItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.MenuTextFieldItem.extend
 * @function
 */


/**
 * Getter for property <code>label</code>.
 * The label of the contained text field.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>label</code>
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#getLabel
 * @function
 */

/**
 * Setter for property <code>label</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sLabel  new value for property <code>label</code>
 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#setLabel
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * Icon to be displayed.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#setIcon
 * @function
 */


/**
 * Getter for property <code>value</code>.
 * Value of the contained text field.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>value</code>
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#getValue
 * @function
 */

/**
 * Setter for property <code>value</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sValue  new value for property <code>value</code>
 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#setValue
 * @function
 */


/**
 * Getter for property <code>valueState</code>.
 * Visualizes warnings or errors.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>valueState</code>
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#getValueState
 * @function
 */

/**
 * Setter for property <code>valueState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oValueState  new value for property <code>valueState</code>
 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#setValueState
 * @function
 */


// Start of sap\ui\unified\MenuTextFieldItem.js

jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


(function() {

/**
 * Called by the Menu renderer when the item should be rendered.
 * @private
 */
sap.ui.unified.MenuTextFieldItem.prototype.render = function(oRenderManager, oItem, oMenu, oInfo){
	var rm = oRenderManager,
		bIsEnabled = oMenu.checkEnabled(oItem),
		itemId = oItem.getId();
	
	rm.write("<li "); 
	rm.writeAttribute("class", "sapUiMnuItm sapUiMnuTfItm" + (oMenu.checkEnabled(oItem) ? "" : " sapUiMnuItmDsbl"));
	rm.writeElementData(oItem);
	
	// ARIA
	if(oInfo.bAccessible){
		rm.writeAttribute("role", "menuitem");
		rm.writeAttribute("aria-labelledby", oMenu.getId()+" "+itemId+"-txt "+itemId+"-scuttxt");
		rm.writeAttribute("aria-disabled", !bIsEnabled);
		rm.writeAttribute("aria-posinset", oInfo.iItemNo);
		rm.writeAttribute("aria-setsize", oInfo.iTotalItems);
	}
	
	// Left border
	rm.write("><div class=\"sapUiMnuItmL\"></div>");
	
	// icon/check column 
	rm.write("<div class=\"sapUiMnuItmIco\">");
	if (oItem.getIcon()) {
		rm.writeIcon(oItem.getIcon());
	}
	rm.write("</div>");
	
	// Text filed column 
	rm.write("<div id=\""+itemId+"-txt\" class=\"sapUiMnuItmTxt\">");
	rm.write("<label id=\""+itemId+"-lbl\" for=\""+itemId+"-tf\" class=\"sapUiMnuTfItemLbl\">");
	rm.writeEscaped(oItem.getLabel() || "");
	rm.write("</label>");
	rm.write("<div id=\""+itemId+"-str\" class=\"sapUiMnuTfItmStretch\"></div>"); // Helper to strech the width if needed
	rm.write("<div class=\"sapUiMnuTfItemWrppr\">");
	rm.write("<input id=\""+itemId+"-tf\" tabindex=\"-1\" role=\"textbox\" aria-multiline=\"false\" aria-autocomplete=\"none\"");
	rm.writeAttributeEscaped("value", oItem.getValue() || "");
	rm.writeAttribute("class", bIsEnabled ? "sapUiMnuTfItemTf sapUiMnuTfItemTfEnbl" : "sapUiMnuTfItemTf sapUiMnuTfItemTfDsbl");	
	if(!bIsEnabled){
		rm.writeAttribute("disabled", "disabled");		
	}
	rm.write("></input></div></div>");
	
	// Right border
	rm.write("<div class=\"sapUiMnuItmR\"></div>");

	rm.write("</li>");
};


/**
 * Called by the Menu renderer when the item is hovered.
 * @private
 */
sap.ui.unified.MenuTextFieldItem.prototype.hover = function(bHovered, oMenu){
	this.$().toggleClass("sapUiMnuItmHov", bHovered);
	
	if(bHovered && oMenu.checkEnabled(this)){
		var that = this;
		function focusTF() { that.$("tf").focus(); };
		
		if(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8){
			setTimeout(focusTF, 0);
		}else{
			focusTF();
		}
	}
};


/**
 * Called by the Menu renderer after the item is rendered.
 * @private
 */
sap.ui.unified.MenuTextFieldItem.prototype.onAfterRendering = function(){
	this._adaptSizes();
	this.setValueState(this.getValueState());	
};


//************ Event Handling *************


sap.ui.unified.MenuTextFieldItem.prototype.onsapup = function(oEvent){
	this.getParent().focus();
	this.getParent().onsapprevious(oEvent);
};


sap.ui.unified.MenuTextFieldItem.prototype.onsapdown = function(oEvent){
	this.getParent().focus();
	this.getParent().onsapnext(oEvent);
};


sap.ui.unified.MenuTextFieldItem.prototype.onsaphome = function(oEvent){
	if(this._checkCursorPosForNav(false)){
		this.getParent().focus();
		this.getParent().onsaphome(oEvent);
	}
};


sap.ui.unified.MenuTextFieldItem.prototype.onsapend = function(oEvent){
	if(this._checkCursorPosForNav(true)){
		this.getParent().focus();
		this.getParent().onsapend(oEvent);
	}
};


sap.ui.unified.MenuTextFieldItem.prototype.onsapescape = function(oEvent){
	this.getParent().onsapescape(oEvent);
};


sap.ui.unified.MenuTextFieldItem.prototype.onkeydown = function(oEvent){
	oEvent.stopPropagation(); //Avoid bubbling key events to the Menu -> Events are only selectively forwarded
};


sap.ui.unified.MenuTextFieldItem.prototype.onclick = function(oEvent){
	if(!sap.ui.Device.system.desktop && this.getParent().checkEnabled(this)){
		this.focus();
	}
	oEvent.stopPropagation();
};


sap.ui.unified.MenuTextFieldItem.prototype.onsapenter = function(oEvent){
	var sValue = this.$("tf").val();
	this.setValue(sValue);
	this.getParent().selectItem(this);
	oEvent.preventDefault();
	oEvent.stopPropagation();
};


// ************ Overridden API functions *************

/**
 * Getter for aggregation <code>submenu</code>.<br/>
 * Aggregation of a menu item's sub menu.
 * 
 * @return {sap.ui.unified.Menu}
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#getSubmenu
 * @deprecated The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
 * @function
 */
 
/**
 * Destroys the submenu in the aggregation 
 * named <code>submenu</code>.
 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#destroySubmenu
 * @deprecated The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
 * @function
 */

/**
 * Setter for the aggregated <code>submenu</code>.
 * @param {sap.ui.unified.Menu} oSubmenu
 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuTextFieldItem#setSubmenu
 * @deprecated The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
 * @function
 */
sap.ui.unified.MenuTextFieldItem.prototype.setSubmenu = function(oMenu){
	jQuery.sap.log.warning("The aggregation 'submenu' is not supported for this type of menu item.", "", "sap.ui.unified.MenuTextFieldItem");
	return this;
};


sap.ui.unified.MenuTextFieldItem.prototype.setLabel = function(sLabel){
	this.setProperty("label", sLabel, true);
	this.$("lbl").text(sLabel);
	this._adaptSizes();
	return this;
};


sap.ui.unified.MenuTextFieldItem.prototype.setValue = function(sValue){
	this.setProperty("value", sValue, true);
	this.$("tf").val(sValue);
	//this._adaptSizes();
	return this;
};


sap.ui.unified.MenuTextFieldItem.prototype.setValueState = function(sValueState){
	this.setProperty("valueState", sValueState, true);
	var $tf = this.$("tf");
	$tf.toggleClass("sapUiMnuTfItemTfErr", sValueState == sap.ui.core.ValueState.Error);
	$tf.toggleClass("sapUiMnuTfItemTfWarn", sValueState == sap.ui.core.ValueState.Warning);
	var sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(this, this.getTooltip_AsString());
	this.$().attr("title", sTooltip ? sTooltip : "");
	return this;
};


//************ Private Helpers *************


sap.ui.unified.MenuTextFieldItem.prototype.getFocusDomRef = function () {
	var $FocusRef = this.$("tf");
	return $FocusRef.length ? $FocusRef.get(0) : null;
};


sap.ui.unified.MenuTextFieldItem.prototype._adaptSizes = function(){
	var $tf = this.$("tf");
	var $lbl = this.$("lbl");
	var offsetLeft = $lbl.length ? $lbl.get(0).offsetLeft : 0;
	
	if(sap.ui.getCore().getConfiguration().getRTL()){
		$tf.parent().css({"width": "auto", "right": (this.$().outerWidth(true) - offsetLeft + ($lbl.outerWidth(true) - $lbl.outerWidth()))+"px"});
	}else{
		$tf.parent().css({"width": "auto", "left": (offsetLeft + $lbl.outerWidth(true))+"px"});
	}
};


sap.ui.unified.MenuTextFieldItem.prototype._checkCursorPosForNav = function(bForward) {
	var bRtl = sap.ui.getCore().getConfiguration().getRTL();
	var bBack = bForward ? bRtl : !bRtl;
	var $input = this.$("tf");
	var iPos = $input.cursorPos();
	var iLen = $input.val().length;
	if(bRtl){
		iPos = iLen-iPos;
	}
	if((!bBack && iPos != iLen) || (bBack && iPos != 0)){
		return false;
	}
	return true;
};


}());

}; // end of sap/ui/unified/MenuTextFieldItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellHeadItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.ShellHeadItem.
jQuery.sap.declare("sap.ui.unified.ShellHeadItem");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new ShellHeadItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getStartsSection startsSection} : boolean (default: false)</li>
 * <li>{@link #getShowSeparator showSeparator} : boolean (default: true)</li>
 * <li>{@link #getSelected selected} : boolean (default: false)</li>
 * <li>{@link #getShowMarker showMarker} : boolean (default: false)</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.ShellHeadItem#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Header Action item of the Shell.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.15.1
 * @name sap.ui.unified.ShellHeadItem
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.unified.ShellHeadItem", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"startsSection" : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
		"showSeparator" : {type : "boolean", group : "Appearance", defaultValue : true},
		"selected" : {type : "boolean", group : "Appearance", defaultValue : false},
		"showMarker" : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true}
	},
	events : {
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.ShellHeadItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.ShellHeadItem.extend
 * @function
 */

sap.ui.unified.ShellHeadItem.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>startsSection</code>.
 * If set to true, a divider is displayed before the item.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>startsSection</code>
 * @public
 * @deprecated Since version 1.18. 
 * Dividers are not supported anymore.
 * @name sap.ui.unified.ShellHeadItem#getStartsSection
 * @function
 */

/**
 * Setter for property <code>startsSection</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bStartsSection  new value for property <code>startsSection</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18. 
 * Dividers are not supported anymore.
 * @name sap.ui.unified.ShellHeadItem#setStartsSection
 * @function
 */


/**
 * Getter for property <code>showSeparator</code>.
 * If set to true, a separator is displayed after the item.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showSeparator</code>
 * @public
 * @since 1.22.5
 * @name sap.ui.unified.ShellHeadItem#getShowSeparator
 * @function
 */

/**
 * Setter for property <code>showSeparator</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowSeparator  new value for property <code>showSeparator</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @since 1.22.5
 * @name sap.ui.unified.ShellHeadItem#setShowSeparator
 * @function
 */


/**
 * Getter for property <code>selected</code>.
 * If set to true, the item gets a special design.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>selected</code>
 * @public
 * @name sap.ui.unified.ShellHeadItem#getSelected
 * @function
 */

/**
 * Setter for property <code>selected</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSelected  new value for property <code>selected</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#setSelected
 * @function
 */


/**
 * Getter for property <code>showMarker</code>.
 * If set to true, a theme dependent marker is shown on the item.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showMarker</code>
 * @public
 * @deprecated Since version 1.18. 
 * Markers should not be used anymore.
 * @name sap.ui.unified.ShellHeadItem#getShowMarker
 * @function
 */

/**
 * Setter for property <code>showMarker</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowMarker  new value for property <code>showMarker</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18. 
 * Markers should not be used anymore.
 * @name sap.ui.unified.ShellHeadItem#setShowMarker
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * The icon of the item, either defined in the sap.ui.core.IconPool or an URI to a custom image. An icon must be set.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.unified.ShellHeadItem#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#setIcon
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible items are not shown on the UI.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @since 1.18
 * @name sap.ui.unified.ShellHeadItem#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @since 1.18
 * @name sap.ui.unified.ShellHeadItem#setVisible
 * @function
 */


/**
 * Event is fired when the user presses the item.
 *
 * @name sap.ui.unified.ShellHeadItem#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.unified.ShellHeadItem</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.ShellHeadItem</code>.<br/> itself. 
 *  
 * Event is fired when the user presses the item.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.ShellHeadItem</code>.<br/> itself.
 *
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.unified.ShellHeadItem</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadItem#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.ShellHeadItem} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.ShellHeadItem#firePress
 * @function
 */


// Start of sap\ui\unified\ShellHeadItem.js
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


sap.ui.unified.ShellHeadItem.prototype.onclick = function(oEvent){
	this.firePress();
};

sap.ui.unified.ShellHeadItem.prototype.onsapspace = sap.ui.unified.ShellHeadItem.prototype.onclick;


sap.ui.unified.ShellHeadItem.prototype.setStartsSection = function(bStartsSection){
	bStartsSection = !!bStartsSection;
	this.setProperty("startsSection", bStartsSection, true);
	this.$().toggleClass("sapUiUfdShellHeadItmDelim", bStartsSection);
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setShowSeparator = function(bShowSeparator){
	bShowSeparator = !!bShowSeparator;
	this.setProperty("showSeparator", bShowSeparator, true);
	this.$().toggleClass("sapUiUfdShellHeadItmSep", bShowSeparator);
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setSelected = function(bSelected){
	bSelected = !!bSelected;
	this.setProperty("selected", bSelected, true);
	this.$().toggleClass("sapUiUfdShellHeadItmSel", bSelected);
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setVisible = function(bVisible){
	this.setProperty("visible", !!bVisible); // Suppress Rerendering handled by Shell
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setShowMarker = function(bMarker){
	bMarker = !!bMarker;
	this.setProperty("showMarker", bMarker, true);
	this.$().toggleClass("sapUiUfdShellHeadItmMark", bMarker);
	return this;
};


sap.ui.unified.ShellHeadItem.prototype.setIcon = function(sIcon){
	this.setProperty("icon", sIcon, true);
	if(this.getDomRef()){
		this._refreshIcon();
	}
	return this;
};


sap.ui.unified.ShellHeadItem.prototype._refreshIcon = function(){
	var $Ico = jQuery(this.$().children()[0]);
	var sIco = this.getIcon();
	if(sap.ui.core.IconPool.isIconURI(sIco)){
		var oIconInfo = sap.ui.core.IconPool.getIconInfo(sIco);
		$Ico.html("").css("style", "");
		if(oIconInfo){
			$Ico.text(oIconInfo.content).css("font-family", "'" + oIconInfo.fontFamily + "'");
		}
	}else{
		var $Image = this.$("img-inner");
		if($Image.length == 0 || $Image.attr("src") != sIco){
			$Ico.css("style", "").html("<img id='" + this.getId() + "-img-inner' src='" + jQuery.sap.encodeHTML(sIco) + "'></img>");
		}
	}
};

}; // end of sap/ui/unified/ShellHeadItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellHeadUserItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.ShellHeadUserItem.
jQuery.sap.declare("sap.ui.unified.ShellHeadUserItem");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new ShellHeadUserItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getUsername username} : string (default: '')</li>
 * <li>{@link #getImage image} : sap.ui.core.URI</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.ShellHeadUserItem#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * User Header Action Item of the Shell.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.ShellHeadUserItem
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.unified.ShellHeadUserItem", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"username" : {type : "string", group : "Appearance", defaultValue : ''},
		"image" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null}
	},
	events : {
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.ShellHeadUserItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.ShellHeadUserItem.extend
 * @function
 */

sap.ui.unified.ShellHeadUserItem.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>username</code>.
 * The name of the user.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>username</code>
 * @public
 * @name sap.ui.unified.ShellHeadUserItem#getUsername
 * @function
 */

/**
 * Setter for property <code>username</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sUsername  new value for property <code>username</code>
 * @return {sap.ui.unified.ShellHeadUserItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadUserItem#setUsername
 * @function
 */


/**
 * Getter for property <code>image</code>.
 * An image of the user, normally an URI to a image but also an icon from the sap.ui.core.IconPool is possible.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>image</code>
 * @public
 * @name sap.ui.unified.ShellHeadUserItem#getImage
 * @function
 */

/**
 * Setter for property <code>image</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sImage  new value for property <code>image</code>
 * @return {sap.ui.unified.ShellHeadUserItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadUserItem#setImage
 * @function
 */


/**
 * Event is fired when the user presses the button.
 *
 * @name sap.ui.unified.ShellHeadUserItem#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.unified.ShellHeadUserItem</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.ShellHeadUserItem</code>.<br/> itself. 
 *  
 * Event is fired when the user presses the button.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.ShellHeadUserItem</code>.<br/> itself.
 *
 * @return {sap.ui.unified.ShellHeadUserItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadUserItem#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.unified.ShellHeadUserItem</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.ShellHeadUserItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellHeadUserItem#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.ShellHeadUserItem} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.ShellHeadUserItem#firePress
 * @function
 */


// Start of sap\ui\unified\ShellHeadUserItem.js
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained

sap.ui.core.IconPool.getIconInfo("", ""); //Ensure Icon Font is loaded

sap.ui.unified.ShellHeadUserItem.prototype.onclick = function(oEvent){
	this.firePress();
};

sap.ui.unified.ShellHeadUserItem.prototype.onsapspace = sap.ui.unified.ShellHeadUserItem.prototype.onclick;

sap.ui.unified.ShellHeadUserItem.prototype.setImage = function(sImage){
	this.setProperty("image", sImage, true);
	if(this.getDomRef()){
		this._refreshImage();
	}
	return this;
};

sap.ui.unified.ShellHeadUserItem.prototype._refreshImage = function(){
	var $Ico = this.$("img");
	var sImage = this.getImage();
	if(!sImage){
		$Ico.html("").css("style", "").css("display", "none");
	}else if(sap.ui.core.IconPool.isIconURI(sImage)){
		var oIconInfo = sap.ui.core.IconPool.getIconInfo(sImage);
		$Ico.html("").css("style", "");
		if(oIconInfo){
			$Ico.text(oIconInfo.content).css("font-family", "'" + oIconInfo.fontFamily + "'");
		}
	}else{
		var $Image = this.$("img-inner");
		if($Image.length == 0 || $Image.attr("src") != sImage){
			$Ico.css("style", "").html("<img id='" + this.getId() + "-img-inner' src='" + jQuery.sap.encodeHTML(sImage) + "'></img>");
		}
	}
};

sap.ui.unified.ShellHeadUserItem.prototype._checkAndAdaptWidth = function(bShellSearchVisible){
	if(!this.getDomRef()){
		return false;
	}
	
	var $Ref = this.$(),
		$NameRef = this.$("name");
	var iBeforeWidth = $Ref.width();
	$Ref.toggleClass("sapUiUfdShellHeadUsrItmLimit", false);
	//User name cannot be larger than 240px
	//(if a search field is shown in the shell this max size decreases depending on the screen width)
	var iMax = 240;
	if(bShellSearchVisible){
		iMax = Math.min(iMax, 0.5*document.documentElement.clientWidth - 225);
	}
	if(iMax < $NameRef.width()){
		$Ref.toggleClass("sapUiUfdShellHeadUsrItmLimit", true);
	}
	return iBeforeWidth != $Ref.width();
};

}; // end of sap/ui/unified/ShellHeadUserItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.SplitContainer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.SplitContainer.
jQuery.sap.declare("sap.ui.unified.SplitContainer");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new SplitContainer.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getShowSecondaryContent showSecondaryContent} : boolean</li>
 * <li>{@link #getSecondaryContentSize secondaryContentSize} : sap.ui.core.CSSSize (default: '250px')</li>
 * <li>{@link #getSecondaryContentWidth secondaryContentWidth} : sap.ui.core.CSSSize (default: '250px')</li>
 * <li>{@link #getOrientation orientation} : sap.ui.core.Orientation (default: sap.ui.core.Orientation.Horizontal)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getSecondaryContent secondaryContent} : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Provides a main content and a secondary content area
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.15.0
 * @experimental Since version 1.15.0. 
 * API is not yet finished and might change completely
 * @name sap.ui.unified.SplitContainer
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.SplitContainer", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"showSecondaryContent" : {type : "boolean", group : "Appearance", defaultValue : null},
		"secondaryContentSize" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '250px'},
		"secondaryContentWidth" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '250px', deprecated: true},
		"orientation" : {type : "sap.ui.core.Orientation", group : "Appearance", defaultValue : sap.ui.core.Orientation.Horizontal}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
		"secondaryContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "secondaryContent"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.SplitContainer with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.SplitContainer.extend
 * @function
 */


/**
 * Getter for property <code>showSecondaryContent</code>.
 * Shows / Hides the secondary area.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showSecondaryContent</code>
 * @public
 * @name sap.ui.unified.SplitContainer#getShowSecondaryContent
 * @function
 */

/**
 * Setter for property <code>showSecondaryContent</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowSecondaryContent  new value for property <code>showSecondaryContent</code>
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#setShowSecondaryContent
 * @function
 */


/**
 * Getter for property <code>secondaryContentSize</code>.
 * The width if the secondary content. The height is always 100%.
 *
 * Default value is <code>250px</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>secondaryContentSize</code>
 * @public
 * @name sap.ui.unified.SplitContainer#getSecondaryContentSize
 * @function
 */

/**
 * Setter for property <code>secondaryContentSize</code>.
 *
 * Default value is <code>250px</code> 
 *
 * @param {sap.ui.core.CSSSize} sSecondaryContentSize  new value for property <code>secondaryContentSize</code>
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#setSecondaryContentSize
 * @function
 */


/**
 * Getter for property <code>secondaryContentWidth</code>.
 * Do not use. Use secondaryContentSize instead.
 *
 * Default value is <code>250px</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>secondaryContentWidth</code>
 * @public
 * @deprecated Since version 1.22. 
 * 
 * Only available for backwards compatibility.
 * @name sap.ui.unified.SplitContainer#getSecondaryContentWidth
 * @function
 */

/**
 * Setter for property <code>secondaryContentWidth</code>.
 *
 * Default value is <code>250px</code> 
 *
 * @param {sap.ui.core.CSSSize} sSecondaryContentWidth  new value for property <code>secondaryContentWidth</code>
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.22. 
 * 
 * Only available for backwards compatibility.
 * @name sap.ui.unified.SplitContainer#setSecondaryContentWidth
 * @function
 */


/**
 * Getter for property <code>orientation</code>.
 * Whether to show the secondary content on the left ("Horizontal", default) or on the top ("Vertical").
 *
 * Default value is <code>Horizontal</code>
 *
 * @return {sap.ui.core.Orientation} the value of property <code>orientation</code>
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.SplitContainer#getOrientation
 * @function
 */

/**
 * Setter for property <code>orientation</code>.
 *
 * Default value is <code>Horizontal</code> 
 *
 * @param {sap.ui.core.Orientation} oOrientation  new value for property <code>orientation</code>
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.SplitContainer#setOrientation
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content to appear in the main area.
 * 
 * <strong>Note</strong>: this is the default aggregation for SplitContainer.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.SplitContainer#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.unified.SplitContainer#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.SplitContainer#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.SplitContainer#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>secondaryContent</code>.<br/>
 * The content to appear in the secondary area.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.SplitContainer#getSecondaryContent
 * @function
 */


/**
 * Inserts a secondaryContent into the aggregation named <code>secondaryContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oSecondaryContent the secondaryContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the secondaryContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the secondaryContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the secondaryContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#insertSecondaryContent
 * @function
 */

/**
 * Adds some secondaryContent <code>oSecondaryContent</code> 
 * to the aggregation named <code>secondaryContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oSecondaryContent the secondaryContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#addSecondaryContent
 * @function
 */

/**
 * Removes an secondaryContent from the aggregation named <code>secondaryContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vSecondaryContent the secondaryContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed secondaryContent or null
 * @public
 * @name sap.ui.unified.SplitContainer#removeSecondaryContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>secondaryContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.SplitContainer#removeAllSecondaryContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>secondaryContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oSecondaryContent the secondaryContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.SplitContainer#indexOfSecondaryContent
 * @function
 */
	

/**
 * Destroys all the secondaryContent in the aggregation 
 * named <code>secondaryContent</code>.
 * @return {sap.ui.unified.SplitContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.SplitContainer#destroySecondaryContent
 * @function
 */


// Start of sap\ui\unified\SplitContainer.js
(function(window, undefined) {

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


////////////////////////////////////////// Public Methods //////////////////////////////////////////

sap.ui.unified.SplitContainer.prototype.init = function(){
	this.bRtl  = sap.ui.getCore().getConfiguration().getRTL();
	
	this._paneRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-panecntnt", "secondaryContent");
	this._canvasRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-canvascntnt", "content");
	
// Design decided that content does not need to be handled differently depending on device - remove 
// comments if needed again...
//	sap.ui.Device.media.attachHandler(
//		this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD
//	);

	// By default move the content when the secondaryContent is shown
	this._moveContent = true;
};

sap.ui.unified.SplitContainer.prototype.exit = function(){
	this._paneRenderer.destroy();
	delete this._paneRenderer;
	this._canvasRenderer.destroy();
	delete this._canvasRenderer;

	delete this._contentContainer;
	delete this._secondaryContentContainer;
};


////////////////////////////////////////// onEvent Methods /////////////////////////////////////////

sap.ui.unified.SplitContainer.prototype.onAfterRendering = function() {
	// Shortcuts to the main DOM containers
	this._contentContainer 			= this.$("canvas");
	this._secondaryContentContainer = this.$("pane");

// Design decided that content does not need to be handled differently depending on device - remove 
// comments if needed again...
//	this._lastDeviceName = "";
//	this._handleMediaChange(
//		sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD)
//	);
	
	this._applySecondaryContentSize();
};


////////////////////////////////////////// Private Methods /////////////////////////////////////////

// Design decided that content does not need to be handled differently depending on device - remove 
// comments if needed again...
///**
// * This method is called whenever the size of the document changes into a different range of values
// * that represent different devices (Desktop/Tablet/Phone).
// * 
// * @private
// */
//sap.ui.unified.SplitContainer.prototype._handleMediaChange = function(mParams) {
//	var sDeviceName = mParams.name;
//	
//	// By default, move the content to the right, there should be enough space
//	this._moveContent = true;
//
//	if (sDeviceName == "Phone") {
//		// On phones, do not move the main content as it does not have enough
//		// space as it is
//		this._moveContent = false;
//	}
//
//	// Only write changes if something actually changed
//	if (this._lastDeviceName !== sDeviceName) {
//		this._applySecondaryContentSize();
//	}
//	this._lastDeviceName = sDeviceName;
//};

/**
 * Applies the current status to the content areas (CSS left and width properties).
 * 
 * @private
 */
sap.ui.unified.SplitContainer.prototype._applySecondaryContentSize = function(){
	// Only set if rendered...
	if (this.getDomRef()) {
		var bVertical = this.getOrientation() == sap.ui.core.Orientation.Vertical;
		var sSize, sOtherSize;
		var sDir, sOtherDir;
		var sSizeValue = this.getSecondaryContentSize();
		var bShow = this.getShowSecondaryContent();

		if (bVertical) {
			// Vertical mode
			sSize = "height";
			sOtherSize =  "width";
			sDir = "top";
			sOtherDir = this.bRtl ? "right" : "left";
		} else {
			// Horizontal mode
			sSize = "width";
			sOtherSize =  "height";
			sDir = this.bRtl ? "right" : "left";
			sOtherDir = "top";
		}
		
		if (this._closeContentDelayId) {
			jQuery.sap.clearDelayedCall(this._closeContentDelayId);
		}
		
		this._secondaryContentContainer.css(sSize, sSizeValue);
		this._secondaryContentContainer.css(sOtherSize, "");
		this._secondaryContentContainer.css(sDir, bShow ? "0" : "-" + sSizeValue);
		this._secondaryContentContainer.css(sOtherDir, "");
		
		// Move main content if it should be completely visible. @see _handleMediaChange()
		if (this._moveContent) {
			this._contentContainer.css(sDir, bShow ? sSizeValue : "0");
		} else {
			this._contentContainer.css(sDir, "0");
		}
		
		if (!bShow) {
			// The theming parameter is something along the lines of "500ms", the "ms"-part is
			// ignored by parseInt.
			// TODO: Cache the value.
			var iHideDelay = parseInt(
				sap.ui.core.theming.Parameters.get("sapUiUfdSplitContAnimationDuration"),
				10
			);
			// Maybe we could also allow "s"-values and then multiply everything below 20 with 1000...?

			this._closeContentDelayId = jQuery.sap.delayedCall(iHideDelay, this, function() {
				this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed", true);
			});
		} else {
			this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed", false);
		}
		
	}
};



/**
 * Optimization method that prevents the normal render from rerendering the whole control.
 * See _ContentRenderer in file shared.js for details.
 * 
 * @param {function} fMod Method that is called to perform the requested change
 * @param {sap.ui.core.Renderer} oDoIfRendered Renderer Instance
 * @returns {any} the return value from the first parameter
 * 
 * @private
 */
sap.ui.unified.SplitContainer.prototype._mod = function(fMod, oDoIfRendered){
	var bRendered = !!this.getDomRef();
	var res = fMod.apply(this, [bRendered]);
	if(bRendered && oDoIfRendered){
		oDoIfRendered.render();
	}
	return res;
};


//////////////////////////////////////// Overridden Methods ////////////////////////////////////////

    //////////////////////////// Property "showSecondaryContent" ///////////////////////////////

sap.ui.unified.SplitContainer.prototype.setShowSecondaryContent = function(bShow){
	var bRendered = this.getDomRef();
	this.setProperty("showSecondaryContent", !!bShow, bRendered);
	
	this._applySecondaryContentSize();
	return this;
};


	///////////////////////////// Property "secondaryContentSize" /////////////////////////////

sap.ui.unified.SplitContainer.prototype.setSecondaryContentSize = function(sSize) {
	this.setProperty("secondaryContentSize", sSize, true);
	this._applySecondaryContentSize();
	return this;
};

/**
 * Backwards compatibility with old property name
 */
sap.ui.unified.SplitContainer.prototype.getSecondaryContentWidth = function() {
	jQuery.sap.log.warning(
		"SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use " +
		"\"SecondaryContentSize\" instead."
	);
	return this.getSecondaryContentSize.apply(this, arguments);
};
	
sap.ui.unified.SplitContainer.prototype.setSecondaryContentWidth = function() {
	jQuery.sap.log.warning(
		"SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use " +
		"\"SecondaryContentSize\" instead."
	);
	return this.setSecondaryContentSize.apply(this, arguments);
};



	/////////////////////////////////// Aggregation "content" //////////////////////////////////

sap.ui.unified.SplitContainer.prototype.insertContent = function(oContent, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("content", oContent, iIndex, bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.addContent = function(oContent) {
	return this._mod(function(bRendered){
		return this.addAggregation("content", oContent, bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeContent = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("content", vIndex, bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeAllContent = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("content", bRendered);
	}, this._canvasRenderer);
};
sap.ui.unified.SplitContainer.prototype.destroyContent = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("content", bRendered);
	}, this._canvasRenderer);
};


    ////////////////////////////// Aggregation "secondaryContent" //////////////////////////////

sap.ui.unified.SplitContainer.prototype.insertSecondaryContent = function(oContent, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("secondaryContent", oContent, iIndex, bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.addSecondaryContent = function(oContent) {
	return this._mod(function(bRendered){
		return this.addAggregation("secondaryContent", oContent, bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeSecondaryContent = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("secondaryContent", vIndex, bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.removeAllSecondaryContent = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("secondaryContent", bRendered);
	}, this._paneRenderer);
};
sap.ui.unified.SplitContainer.prototype.destroySecondaryContent = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("secondaryContent", bRendered);
	}, this._paneRenderer);
};


})(window);

}; // end of sap/ui/unified/SplitContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Menu') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.Menu.
jQuery.sap.declare("sap.ui.unified.Menu");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Menu.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getAriaDescription ariaDescription} : string</li>
 * <li>{@link #getMaxVisibleItems maxVisibleItems} : int (default: 0)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getItems items} <strong>(default aggregation)</strong> : sap.ui.unified.MenuItemBase[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.Menu#event:itemSelect itemSelect} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A container for menu items. When the space in the browser is not large enough to display all defined items, a scroll bar is provided.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.Menu
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.Menu", { metadata : {

	publicMethods : [
		// methods
		"open", "close"
	],
	library : "sap.ui.unified",
	properties : {
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"ariaDescription" : {type : "string", group : "Accessibility", defaultValue : null},
		"maxVisibleItems" : {type : "int", group : "Behavior", defaultValue : 0}
	},
	defaultAggregation : "items",
	aggregations : {
		"items" : {type : "sap.ui.unified.MenuItemBase", multiple : true, singularName : "item"}
	},
	events : {
		"itemSelect" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.Menu with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.Menu.extend
 * @function
 */

sap.ui.unified.Menu.M_EVENTS = {'itemSelect':'itemSelect'};


/**
 * Getter for property <code>enabled</code>.
 * 
 * Disabled menus have other colors than enabled ones, depending on customer settings.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.unified.Menu#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#setEnabled
 * @function
 */


/**
 * Getter for property <code>ariaDescription</code>.
 * 
 * The label/description provided for screen readers
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>ariaDescription</code>
 * @public
 * @name sap.ui.unified.Menu#getAriaDescription
 * @function
 */

/**
 * Setter for property <code>ariaDescription</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAriaDescription  new value for property <code>ariaDescription</code>
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#setAriaDescription
 * @function
 */


/**
 * Getter for property <code>maxVisibleItems</code>.
 * 
 * Max. number of items to be displayed before an overflow mechanimn appears. Values smaller than 1 mean infinite number of visible items.
 * The menu can not become larger than the screen height.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>maxVisibleItems</code>
 * @public
 * @name sap.ui.unified.Menu#getMaxVisibleItems
 * @function
 */

/**
 * Setter for property <code>maxVisibleItems</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iMaxVisibleItems  new value for property <code>maxVisibleItems</code>
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#setMaxVisibleItems
 * @function
 */


/**
 * Getter for aggregation <code>items</code>.<br/>
 * Aggregation of menu items
 * 
 * <strong>Note</strong>: this is the default aggregation for Menu.
 * @return {sap.ui.unified.MenuItemBase[]}
 * @public
 * @name sap.ui.unified.Menu#getItems
 * @function
 */


/**
 * Inserts a item into the aggregation named <code>items</code>.
 *
 * @param {sap.ui.unified.MenuItemBase}
 *          oItem the item to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the item should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the item is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the item is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#insertItem
 * @function
 */

/**
 * Adds some item <code>oItem</code> 
 * to the aggregation named <code>items</code>.
 *
 * @param {sap.ui.unified.MenuItemBase}
 *            oItem the item to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#addItem
 * @function
 */

/**
 * Removes an item from the aggregation named <code>items</code>.
 *
 * @param {int | string | sap.ui.unified.MenuItemBase} vItem the item to remove or its index or id
 * @return {sap.ui.unified.MenuItemBase} the removed item or null
 * @public
 * @name sap.ui.unified.Menu#removeItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>items</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.MenuItemBase[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Menu#removeAllItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.MenuItemBase</code> in the aggregation named <code>items</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.MenuItemBase}
 *            oItem the item whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Menu#indexOfItem
 * @function
 */
	

/**
 * Destroys all the items in the aggregation 
 * named <code>items</code>.
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#destroyItems
 * @function
 */


/**
 * 
 * Provides the application an alternative option to listen to select events. This event is only fired on the root menu of a menu hierarchy.
 * Note that there is also a select event available for MenuItem; if the current event is used, the select event of a MenuItem becomes redundant.
 *
 * @name sap.ui.unified.Menu#itemSelect
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {sap.ui.unified.MenuItemBase} oControlEvent.getParameters.item The selected item
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'itemSelect' event of this <code>sap.ui.unified.Menu</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.Menu</code>.<br/> itself. 
 *  
 * 
 * Provides the application an alternative option to listen to select events. This event is only fired on the root menu of a menu hierarchy.
 * Note that there is also a select event available for MenuItem; if the current event is used, the select event of a MenuItem becomes redundant.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.Menu</code>.<br/> itself.
 *
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#attachItemSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'itemSelect' event of this <code>sap.ui.unified.Menu</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Menu#detachItemSelect
 * @function
 */

/**
 * Fire event itemSelect to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'item' of type <code>sap.ui.unified.MenuItemBase</code> The selected item</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.Menu} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.Menu#fireItemSelect
 * @function
 */


/**
 * Opens the menu
 *
 * @name sap.ui.unified.Menu#open
 * @function
 * @param {boolean} bWithKeyboard
 * 
 *         An indicator whether the first item shall be highlighted, or not. It is highlighted in the case that the menu is opened via keyboard.
 * @param {object} oOpenerRef
 * 
 *         DOMNode or sap.ui.core.Element that opens the menu; the DOMNode or sap.ui.core.Element will be focused again after the menu is closed. This parameter is optional.
 * @param {sap.ui.core.Dock} sMy
 * 
 *         The popup content's reference position for docking.
 *         See also sap.ui.core.Popup.Dock and sap.ui.core.Popup.open.
 * @param {sap.ui.core.Dock} sAt
 * 
 *         The 'of' element's reference point for docking to.
 *         See also sap.ui.core.Popup.Dock and sap.ui.core.Popup.open.
 * @param {object} oOf
 * 
 *         The DOM element or sap.ui.core.Element to dock to.
 *         See also sap.ui.core.Popup.open.
 * @param {string} sOffset
 * 
 *         The offset relative to the docking point, specified as a string with space-separated pixel values (e.g. "0 10" to move the popup 10 pixels to the right).
 *         See also sap.ui.core.Popup.open.
 * @param {sap.ui.core.Collision} sCollision
 * 
 *         The collision defines how the position of an element should be adjusted in case it overflows the window in some direction.
 *         See also sap.ui.core.Popup.open.
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


/**
 * Closes the menu
 *
 * @name sap.ui.unified.Menu#close
 * @function
 * @type void
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\unified\Menu.js
(function(window, undefined) {


jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained

jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained


sap.ui.unified.Menu.prototype.init = function(){
	var that = this;
	this.bOpen = false;
	this.oOpenedSubMenu = null;
	this.oHoveredItem = null;
	this.oPopup = null; // Will be created lazily
	this.fAnyEventHandlerProxy = jQuery.proxy(function(oEvent){
		var oRoot = this.getRootMenu();
		if(oRoot != this || !this.bOpen || !this.getDomRef() || (oEvent.type != "mousedown" && oEvent.type != "touchstart")) {
			return;
		}
		oRoot.handleOuterEvent(this.getId(), oEvent); //TBD: standard popup autoclose
	}, this);
	this.fOrientationChangeHandler = function(){
		that.close();
	};
	this.bUseTopStyle = false;
};

/**
 * Does all the cleanup when the Menu is to be destroyed.
 * Called from Element's destroy() method.
 * @private
 */
sap.ui.unified.Menu.prototype.exit = function(){
	if(this.oPopup){
		this.oPopup.detachOpened(this._menuOpened, this);
		this.oPopup.detachClosed(this._menuClosed, this);
		this.oPopup.destroy();
		delete this.oPopup;
	}
	
	jQuery.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);
	if(this._bOrientationChangeBound){
		jQuery(window).unbind("orientationchange", this.fOrientationChangeHandler);
		this._bOrientationChangeBound = false;
	}
	
	// Cleanup
	this._resetDelayedRerenderItems();
};

/**
 * Called when the control or its children are changed.
 * @private
 */
sap.ui.unified.Menu.prototype.invalidate = function(oOrigin){
	if(oOrigin instanceof sap.ui.unified.MenuItemBase && this.getDomRef()){
		this._delayedRerenderItems();
	}else{
		sap.ui.core.Control.prototype.invalidate.apply(this, arguments);
	}
};

/**
 * Called before rendering starts by the renderer
 * @private
 */
sap.ui.unified.Menu.prototype.onBeforeRendering = function() {
	this._resetDelayedRerenderItems();
};

/**
 * Called when the rendering is complete
 * @private
 */
sap.ui.unified.Menu.prototype.onAfterRendering = function() {
	var aItems = this.getItems();
	var item = -1;
	
	for(var i=0; i<aItems.length; i++){
		if(aItems[i].onAfterRendering && aItems[i].getDomRef()){
			item = i;
			aItems[i].onAfterRendering();
		}
	}
	
	if(this.oHoveredItem) {
		this.oHoveredItem.hover(true, this);
	}
	
	var iMaxVisibleItems = this.getMaxVisibleItems();
	var iMaxHeight = document.documentElement.clientHeight-10;
	if(iMaxVisibleItems > 0 && item >= 0){
		iMaxHeight = Math.min(iMaxHeight, aItems[item].$().outerHeight(true) * iMaxVisibleItems);
	}
	
	if(this.$().outerHeight(true) > iMaxHeight){
		this.$().css("max-height", iMaxHeight+"px").toggleClass("sapUiMnuScroll", true);
	}
};


//****** API Methods ******

sap.ui.unified.Menu.prototype.addItem = function(oItem){
	this.addAggregation("items", oItem, !!this.getDomRef());
	this._delayedRerenderItems();
	return this;
};

sap.ui.unified.Menu.prototype.insertItem = function(oItem, idx){
	this.insertAggregation("items", oItem, idx, !!this.getDomRef());
	this._delayedRerenderItems();
	return this;
};

sap.ui.unified.Menu.prototype.removeItem = function(oItem){
	this.removeAggregation("items", oItem, !!this.getDomRef());
	this._delayedRerenderItems();
	return this;
};

sap.ui.unified.Menu.prototype.removeAllItems = function(){
	var oRes = this.removeAllAggregation("items", !!this.getDomRef());
	this._delayedRerenderItems();
	return oRes;
};

sap.ui.unified.Menu.prototype.destroyItems = function(){
	this.destroyAggregation("items", !!this.getDomRef());
	this._delayedRerenderItems();
	return this;
};

sap.ui.unified.Menu.prototype._delayedRerenderItems = function(){
	if(!this.getDomRef()){
		return;
	}
	this._resetDelayedRerenderItems();
	
	this._itemRerenderTimer = jQuery.sap.delayedCall(0, this, function(){
		var oDomRef = this.getDomRef();
		if(oDomRef){
			var oRm = sap.ui.getCore().createRenderManager();
			sap.ui.unified.MenuRenderer.renderItems(oRm, this);
			oRm.flush(oDomRef);
			oRm.destroy();
			this.onAfterRendering();
			this.getPopup()._applyPosition(this.getPopup()._oLastPosition);
		}
	});
};

sap.ui.unified.Menu.prototype._resetDelayedRerenderItems = function(){
	if(this._itemRerenderTimer){
		jQuery.sap.clearDelayedCall(this._itemRerenderTimer);
		delete this._itemRerenderTimer;
	}
};


sap.ui.unified.Menu.prototype.open = function(bWithKeyboard, oOpenerRef, my, at, of, offset, collision){
	if(this.bOpen) {
		return;
	}
	
	setItemToggleState(this, true);

	this.bOpen = true;
	this.oOpenerRef = oOpenerRef;

	// Open the sap.ui.core.Popup
	this.getPopup().open(0, my, at, of, offset || "0 0", collision || "_sapUiCommonsMenuFlip _sapUiCommonsMenuFlip", true);

	// Set the tab index of the menu and focus
	var oDomRef = this.getDomRef();
	jQuery(oDomRef).attr("tabIndex", 0).focus();
	
	// Mark the first item when using the keyboard
	if (bWithKeyboard) {
		this.setHoveredItem(this.getNextVisibleItem(-1));
	}

	jQuery.sap.bindAnyEvent(this.fAnyEventHandlerProxy);
	if(sap.ui.Device.support.orientation && this.getRootMenu() === this){
		jQuery(window).bind("orientationchange", this.fOrientationChangeHandler);
		this._bOrientationChangeBound = true;
	}
};

/**
 * This function is called when the Menu was opened.
 *
 * @since 1.17.0
 * @private
 */ 
sap.ui.unified.Menu.prototype._menuOpened = function() {
	fnIe8RepaintBug(this);
};

sap.ui.unified.Menu.prototype.close = function() {
	if(!this.bOpen || sap.ui.unified.Menu._dbg /*Avoid closing for debugging purposes*/) {
		return;
	}
	
	setItemToggleState(this, false);
	
	// Remove fixed flag if it existed
	delete this._bFixed;

	jQuery.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);
	if(this._bOrientationChangeBound){
		jQuery(window).unbind("orientationchange", this.fOrientationChangeHandler);
		this._bOrientationChangeBound = false;
	}

	this.bOpen = false;
	// Close all sub menus if there are any
	if(this.oOpenedSubMenu) {
		this.oOpenedSubMenu.close();
	}

	// Reset the hover state
	this.setHoveredItem();

	// Reset the tab index of the menu and focus the opener (if there is any)
	jQuery(this.getDomRef()).attr("tabIndex", -1);

	// Close the sap.ui.core.Popup
	this.getPopup().close(0);

	//Remove the Menus DOM after it is closed
	this._resetDelayedRerenderItems();
	this.$().remove();
	this.bOutput = false;

	if(this.isSubMenu()){
		this.getParent().getParent().oOpenedSubMenu = null;
	}
};

/**
 * This function is called when the Menu was closed.
 *
 * @since 1.17.0
 * @private
 */ 
sap.ui.unified.Menu.prototype._menuClosed = function() {
	//TBD: standard popup autoclose: this.close(); //Ensure proper cleanup
	if (this.oOpenerRef) {
		if (!this.ignoreOpenerDOMRef) {
			try {
				this.oOpenerRef.focus();
			} catch(e) {
				jQuery.sap.log.warning("Menu.close cannot restore the focus on opener " + this.oOpenerRef + ", " + e);
			}
		}
		this.oOpenerRef = undefined;
	}
};

//****** Event Handlers ******

sap.ui.unified.Menu.prototype.onclick = function(oEvent){
	this.selectItem(this.getItemByDomRef(oEvent.target), false, !!(oEvent.metaKey || oEvent.ctrlKey));
	oEvent.preventDefault();
	oEvent.stopPropagation();
};


sap.ui.unified.Menu.prototype.onsapnext = function(oEvent){
	//right or down (RTL: left or down)
	if(oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_DOWN){
		//Go to sub menu if available
		if(this.oHoveredItem && this.oHoveredItem.getSubmenu() && this.checkEnabled(this.oHoveredItem)){
			this.openSubmenu(this.oHoveredItem, true);
			return;
		}
	}

	//Go to the next visible item
	var iIdx = this.oHoveredItem ? this.indexOfAggregation("items", this.oHoveredItem) : -1;
	this.setHoveredItem(this.getNextVisibleItem(iIdx));
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

sap.ui.unified.Menu.prototype.onsapprevious = function(oEvent){
	//left or up (RTL: right or up)
	if(oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_UP){
		//Go to parent menu if this is a sub menu
		if(this.isSubMenu()){
			this.close();
			oEvent.preventDefault();
			oEvent.stopPropagation();
			return;
		}
	}

	//Go to the previous visible item
	var iIdx = this.oHoveredItem ? this.indexOfAggregation("items", this.oHoveredItem) : -1;
	this.setHoveredItem(this.getPreviousVisibleItem(iIdx));
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

sap.ui.unified.Menu.prototype.onsaphome = function(oEvent){
	//Go to the first visible item
	var aItems = this.getItems();
	var oItem = null;
	for(var i=0; i<aItems.length; i++){
		if(aItems[i].getVisible()){
			oItem = aItems[i];
			break;
		}
	}

	this.setHoveredItem(oItem);
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

sap.ui.unified.Menu.prototype.onsapend = function(oEvent){
	//Go to the last visible item
	var aItems = this.getItems();
	var oItem = null;
	for(var i=aItems.length-1; i>=0; i--){
		if(aItems[i].getVisible()){
			oItem = aItems[i];
			break;
		}
	}

	this.setHoveredItem(oItem);
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

sap.ui.unified.Menu.prototype.onsapselect = function(oEvent){
	this._sapSelectOnKeyDown = true;
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

sap.ui.unified.Menu.prototype.onkeyup = function(oEvent){
	//like sapselect but on keyup:
	//Using keydown has the following side effect:
	//If the selection leads to a close of the menu and the focus is restored to the caller (e.g. a button)
	//the keyup is fired on the caller (in case of a button a click event is fired there in FF -> Bad!)
	//The attribute _sapSelectOnKeyDown is used to avoid the problem the other way round (Space is pressed
	//on Button which opens the menu and the space keyup immediately selects the first item)
	if(!this._sapSelectOnKeyDown){
		return;
	}else{
		this._sapSelectOnKeyDown = false;
	}
	if(!jQuery.sap.PseudoEvents.sapselect.fnCheck(oEvent)) {
		return;
	}
	this.selectItem(this.oHoveredItem, true, false);
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

sap.ui.unified.Menu.prototype.onsapbackspace = function(oEvent){
	if(jQuery(oEvent.target).prop("tagName") != "INPUT"){
		oEvent.preventDefault(); //CSN 4537657 2012: Stop browser history navigation
	}
};
sap.ui.unified.Menu.prototype.onsapbackspacemodifiers = sap.ui.unified.Menu.prototype.onsapbackspace;

sap.ui.unified.Menu.prototype.onsapescape = function(oEvent){
	this.close();
	oEvent.preventDefault();
	oEvent.stopPropagation();
};

sap.ui.unified.Menu.prototype.onsaptabnext = sap.ui.unified.Menu.prototype.onsapescape;
sap.ui.unified.Menu.prototype.onsaptabprevious = sap.ui.unified.Menu.prototype.onsapescape;

sap.ui.unified.Menu.prototype.onmouseover = function(oEvent){
	if(!sap.ui.Device.system.desktop){
		return;
	}
	var oItem = this.getItemByDomRef(oEvent.target);
	if(!this.bOpen || !oItem || oItem == this.oHoveredItem) {
		return;
	}

	if(this.oOpenedSubMenu && jQuery.sap.containsOrEquals(this.oOpenedSubMenu.getDomRef(), oEvent.target)) {
		return;
	}

	this.setHoveredItem(oItem);

	if (this.oOpenedSubMenu && !this.oOpenedSubMenu._bFixed) {
		this.oOpenedSubMenu.close();
		this.oOpenedSubMenu = null;
	}

	if(jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())){
		this.getDomRef().focus();
	}

	if(this.checkEnabled(oItem)) {
		this.openSubmenu(oItem, false, true);
	}
};

sap.ui.unified.Menu.prototype.onmouseout = function(oEvent){
	if(!sap.ui.Device.system.desktop){
		return;
	}
	fnIe8RepaintBug(this);
	
	if(jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())){
		if(!this.oOpenedSubMenu || !this.oOpenedSubMenu.getParent() === this.oHoveredItem) {
			this.setHoveredItem(null);
		}
	}
};

/**
 * Handles the onsapfocusleave event
 * @param {jQuery.Event} oEvent The browser event
 * @private
 */
sap.ui.unified.Menu.prototype.onsapfocusleave = function(oEvent){
	// Only the deepest opened sub menu should handle the event or ignore the event from an item
	if(this.oOpenedSubMenu || !this.bOpen) {
		return;
	}
	this.getRootMenu().handleOuterEvent(this.getId(), oEvent); //TBD: standard popup autoclose
};

//****** Helper Methods ******

sap.ui.unified.Menu.prototype.handleOuterEvent = function(oMenuId, oEvent){
	//See sap.ui.core.Popup implementation: Target is to use autoclose mechanismn of the popup
	//but currently there autoclose only works for 2 hierarchy levels and not for n as needed by the menu
	//-> This function and all its callers are obsolete when switching later to standard popup autoclose
	//   (all needed further code locations for that change are marked with "TBD: standard popup autoclose")
	var isInMenuHierarchy = false,
		touchEnabled = this.getPopup().touchEnabled;
	
	if (oEvent.type == "mousedown" || oEvent.type == "touchstart"){
		// Suppress the delayed mouse event from mobile browser
		if(touchEnabled && (oEvent.isMarked("delayedMouseEvent") || oEvent.isMarked("cancelAutoClose"))){
			return;
		}
		var currentMenu = this;
		while(currentMenu && !isInMenuHierarchy){
			if(jQuery.sap.containsOrEquals(currentMenu.getDomRef(), oEvent.target)){
				isInMenuHierarchy = true;
			}
			currentMenu = currentMenu.oOpenedSubMenu;
		}
	}else if (oEvent.type == "sapfocusleave"){
		if(touchEnabled){
			return;
		}
		if(oEvent.relatedControlId){
			var currentMenu = this;
			while(currentMenu && !isInMenuHierarchy){
				if((currentMenu.oOpenedSubMenu && currentMenu.oOpenedSubMenu.getId() == oEvent.relatedControlId)
						|| jQuery.sap.containsOrEquals(currentMenu.getDomRef(), jQuery.sap.byId(oEvent.relatedControlId).get(0))){
					isInMenuHierarchy = true;
				}
				currentMenu = currentMenu.oOpenedSubMenu;
			}
		}
	}

	if(!isInMenuHierarchy) {
		this.ignoreOpenerDOMRef = true;
		this.close();
		this.ignoreOpenerDOMRef = false;
	}
};

sap.ui.unified.Menu.prototype.getItemByDomRef = function(oDomRef){
	var oItems = this.getItems(),
		iLength = oItems.length;
	for(var i=0;i<iLength;i++){
		var oItem = oItems[i],
			oItemRef = oItem.getDomRef();
		if(jQuery.sap.containsOrEquals(oItemRef, oDomRef)) {
			return oItem;
		}
	}
	return null;
};

sap.ui.unified.Menu.prototype.selectItem = function(oItem, bWithKeyboard, bCtrlKey){
	if(!oItem || !(oItem instanceof sap.ui.unified.MenuItemBase && this.checkEnabled(oItem))) {
		return;
	}

	var oSubMenu = oItem.getSubmenu();

	if(!oSubMenu){
		// This is a normal item -> Close all menus and fire event.
		this.getRootMenu().close();
	}else{
		if(!sap.ui.Device.system.desktop && this.oOpenedSubMenu === oSubMenu){
			this.oOpenedSubMenu.close();
			this.oOpenedSubMenu = null;
		}else{
			// Item with sub menu was triggered -> Open sub menu and fire event.
			this.openSubmenu(oItem, bWithKeyboard);
		}
	}

	oItem.fireSelect({item: oItem, ctrlKey: bCtrlKey});
	this.getRootMenu().fireItemSelect({item: oItem});
};

sap.ui.unified.Menu.prototype.isSubMenu = function(){
	return this.getParent() && this.getParent().getParent && this.getParent().getParent() instanceof sap.ui.unified.Menu;
};

sap.ui.unified.Menu.prototype.getRootMenu = function(){
	var oMenu = this;
	while(oMenu.isSubMenu()){
		oMenu = oMenu.getParent().getParent();
	}
	return oMenu;
};

sap.ui.unified.Menu.prototype.getMenuLevel = function(){
	var iLevel = 1;
	var oMenu = this;
	while(oMenu.isSubMenu()){
		oMenu = oMenu.getParent().getParent();
		iLevel++;
	}
	return iLevel;
};

sap.ui.unified.Menu.prototype.getPopup = function (){
	if(!this.oPopup){
		this.oPopup = new sap.ui.core.Popup(this, false, true, false); // content, modal, shadow, autoclose (TBD: standard popup autoclose)
		this.oPopup.setDurations(0, 0);
		this.oPopup.attachOpened(this._menuOpened, this);
		this.oPopup.attachClosed(this._menuClosed, this);
	}
	return this.oPopup;
};

sap.ui.unified.Menu.prototype.setHoveredItem = function(oItem){
	if(this.oHoveredItem) {
		this.oHoveredItem.hover(false, this);
	}

	if(!oItem){
		this.oHoveredItem = null;
		jQuery(this.getDomRef()).removeAttr("aria-activedescendant");
		return;
	}

	this.oHoveredItem = oItem;
	oItem.hover(true, this);
	if(sap.ui.getCore().getConfiguration().getAccessibility()) {
		jQuery(this.getDomRef()).attr("aria-activedescendant", oItem.getId());
	}
};

sap.ui.unified.Menu.prototype.openSubmenu = function(oItem, bWithKeyboard, bWithHover){
	var oSubMenu = oItem.getSubmenu();
	if(!oSubMenu) {
		return;
	}

	if(this.oOpenedSubMenu && this.oOpenedSubMenu !== oSubMenu){
		// Another sub menu is open and has not been fixed. Close it at first.
		this.oOpenedSubMenu.close();
		this.oOpenedSubMenu = null;
	}
	
	if (this.oOpenedSubMenu) {
		// Already open. Keep open, bring to front and fix/unfix menu...

		// Fix/Unfix Menu if clicked. Do not change status if just hovering over
		this.oOpenedSubMenu._bFixed = 
			   (bWithHover && this.oOpenedSubMenu._bFixed) 
			|| (!bWithHover && !this.oOpenedSubMenu._bFixed);
		
		this.oOpenedSubMenu._bringToFront();
	} else {
		// Open the sub menu
		this.oOpenedSubMenu = oSubMenu;
		var eDock = sap.ui.core.Popup.Dock;
		oSubMenu.open(bWithKeyboard, this, eDock.BeginTop, eDock.EndTop, oItem, "0 0");
	}
};

/**
 * Brings this menu to the front of the menu stack.
 * This simulates a mouse-event and raises the z-index which is internally tracked by the Popup.
 * 
 * @private
 */
sap.ui.unified.Menu.prototype._bringToFront = function() {
	// This is a hack. We "simulate" a mouse-down-event on the submenu so that it brings itself
	// to the front.
	jQuery.sap.byId(this.getPopup().getId()).mousedown();
};

sap.ui.unified.Menu.prototype.checkEnabled = function(oItem){
	fnIe8RepaintBug(this);
	return oItem && oItem.getEnabled() && this.getEnabled();
};

sap.ui.unified.Menu.prototype.getNextVisibleItem = function(iIdx){
	var oItem = null;
	var aItems = this.getItems();

	// At first, start with the next index
	for(var i=iIdx+1; i<aItems.length; i++){
		if(aItems[i].getVisible()){
			oItem = aItems[i];
			break;
		}
	}

	// If nothing found, start from the beginning
	if(!oItem){
		for(var i=0; i<=iIdx; i++){
			if(aItems[i].getVisible()){
				oItem = aItems[i];
				break;
			}
		}
	}

	return oItem;
};

sap.ui.unified.Menu.prototype.getPreviousVisibleItem = function(iIdx){
	var oItem = null;
	var aItems = this.getItems();

	// At first, start with the previous index
	for(var i=iIdx-1; i>=0; i--){
		if(aItems[i].getVisible()){
			oItem = aItems[i];
			break;
		}
	}

	// If nothing found, start from the end
	if(!oItem){
		for(var i=aItems.length-1; i>=iIdx; i--){
			if(aItems[i].getVisible()){
				oItem = aItems[i];
				break;
			}
		}
	}

	return oItem;
};

sap.ui.unified.Menu.prototype.setRootMenuTopStyle = function(bUseTopStyle){
	this.getRootMenu().bUseTopStyle = bUseTopStyle;
	sap.ui.unified.Menu.rerenderMenu(this.getRootMenu());
};


sap.ui.unified.Menu.rerenderMenu = function(oMenu){
	var aItems = oMenu.getItems();
	for(var i=0; i<aItems.length; i++){
		var oSubMenu = aItems[i].getSubmenu();
		if(oSubMenu) {
			sap.ui.unified.Menu.rerenderMenu(oSubMenu);
		}
	}

	oMenu.invalidate();
	oMenu.rerender();
};


///////////////////////////////////////// Hidden Functions /////////////////////////////////////////

function setItemToggleState(oMenu, bOpen){
	var oParent = oMenu.getParent();
	if(oParent && oParent instanceof sap.ui.unified.MenuItemBase){
		oParent.onSubmenuToggle(bOpen);
	}
};


//IE 8 repainting bug when hovering over MenuItems with IconFont
var fnIe8RepaintBug = function() {};
if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 9) {
	fnIe8RepaintBug = function(oMenu, iDelay) {
		if (iDelay === undefined) {
			iDelay = 50;
		}
		
		
		/* In case of perdormance issues, the commented code around the delayedCall might help:
		jQuery.sap.clearDelayedCall(oMenu.data("delayedRepaintId"));
		var iDelayedId =  */ 
		jQuery.sap.delayedCall(iDelay, oMenu, function() {
			var $Elem = this.$(); // this is the Menu instance from the oMenu argument
			if ($Elem.length > 0) {
				var oDomRef = $Elem[0].firstChild;
				sap.ui.core.RenderManager.forceRepaint(oDomRef);
			}
		});
		/* oMenu.data("delayedRepaintId", iDelayedId); */
	};
}


//**********************************************

/*!
 * The following code is taken from 
 * jQuery UI 1.10.3 - 2013-11-18
 * jquery.ui.position.js
 *
 * http://jqueryui.com
 * Copyright 2013 jQuery Foundation and other contributors; Licensed MIT
 */

//TODO: Get rid of this coding when jQuery UI 1.8 is no longer supported and the framework was switched to jQuery UI 1.9 ff. 

function _migrateDataTojQueryUI110(data){
	var withinElement = jQuery(window);
	data.within = {
		element: withinElement,
		isWindow: true,
		offset: withinElement.offset() || { left: 0, top: 0 },
		scrollLeft: withinElement.scrollLeft(),
		scrollTop: withinElement.scrollTop(),
		width: withinElement.width(),
		height: withinElement.height()
	};
	data.collisionPosition = {
		marginLeft: 0,
		marginTop: 0
	};
	return data;
};

var _pos_jQueryUI110 = {
	fit: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,
				outerWidth = within.width,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = withinOffset - collisionPosLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,
				newOverRight;

			// element is wider than within
			if ( data.collisionWidth > outerWidth ) {
				// element is initially over the left side of within
				if ( overLeft > 0 && overRight <= 0 ) {
					newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;
					position.left += overLeft - newOverRight;
				// element is initially over right side of within
				} else if ( overRight > 0 && overLeft <= 0 ) {
					position.left = withinOffset;
				// element is initially over both left and right sides of within
				} else {
					if ( overLeft > overRight ) {
						position.left = withinOffset + outerWidth - data.collisionWidth;
					} else {
						position.left = withinOffset;
					}
				}
			// too far left -> align with left edge
			} else if ( overLeft > 0 ) {
				position.left += overLeft;
			// too far right -> align with right edge
			} else if ( overRight > 0 ) {
				position.left -= overRight;
			// adjust based on position and margin
			} else {
				position.left = Math.max( position.left - collisionPosLeft, position.left );
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollTop : within.offset.top,
				outerHeight = data.within.height,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = withinOffset - collisionPosTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,
				newOverBottom;

			// element is taller than within
			if ( data.collisionHeight > outerHeight ) {
				// element is initially over the top of within
				if ( overTop > 0 && overBottom <= 0 ) {
					newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;
					position.top += overTop - newOverBottom;
				// element is initially over bottom of within
				} else if ( overBottom > 0 && overTop <= 0 ) {
					position.top = withinOffset;
				// element is initially over both top and bottom of within
				} else {
					if ( overTop > overBottom ) {
						position.top = withinOffset + outerHeight - data.collisionHeight;
					} else {
						position.top = withinOffset;
					}
				}
			// too far up -> align with top
			} else if ( overTop > 0 ) {
				position.top += overTop;
			// too far down -> align with bottom edge
			} else if ( overBottom > 0 ) {
				position.top -= overBottom;
			// adjust based on position and margin
			} else {
				position.top = Math.max( position.top - collisionPosTop, position.top );
			}
		}
	},
	flip: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.left + within.scrollLeft,
				outerWidth = within.width,
				offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = collisionPosLeft - offsetLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,
				myOffset = data.my[ 0 ] === "left" ?
					-data.elemWidth :
					data.my[ 0 ] === "right" ?
						data.elemWidth :
						0,
				atOffset = data.at[ 0 ] === "left" ?
					data.targetWidth :
					data.at[ 0 ] === "right" ?
						-data.targetWidth :
						0,
				offset = -2 * data.offset[ 0 ],
				newOverRight,
				newOverLeft;

			if ( overLeft < 0 ) {
				newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;
				if ( newOverRight < 0 || newOverRight < Math.abs( overLeft ) ) {
					position.left += myOffset + atOffset + offset;
				}
			}
			else if ( overRight > 0 ) {
				newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;
				if ( newOverLeft > 0 || Math.abs( newOverLeft ) < overRight ) {
					position.left += myOffset + atOffset + offset;
				}
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.top + within.scrollTop,
				outerHeight = within.height,
				offsetTop = within.isWindow ? within.scrollTop : within.offset.top,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = collisionPosTop - offsetTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,
				top = data.my[ 1 ] === "top",
				myOffset = top ?
					-data.elemHeight :
					data.my[ 1 ] === "bottom" ?
						data.elemHeight :
						0,
				atOffset = data.at[ 1 ] === "top" ?
					data.targetHeight :
					data.at[ 1 ] === "bottom" ?
						-data.targetHeight :
						0,
				offset = -2 * data.offset[ 1 ],
				newOverTop,
				newOverBottom;
			if ( overTop < 0 ) {
				newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;
				if ( ( position.top + myOffset + atOffset + offset) > overTop && ( newOverBottom < 0 || newOverBottom < Math.abs( overTop ) ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
			else if ( overBottom > 0 ) {
				newOverTop = position.top -  data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;
				if ( ( position.top + myOffset + atOffset + offset) > overBottom && ( newOverTop > 0 || Math.abs( newOverTop ) < overBottom ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
		}
	},
	flipfit: {
		left: function() {
			_pos_jQueryUI110.flip.left.apply( this, arguments );
			_pos_jQueryUI110.fit.left.apply( this, arguments );
		},
		top: function() {
			_pos_jQueryUI110.flip.top.apply( this, arguments );
			_pos_jQueryUI110.fit.top.apply( this, arguments );
		}
	}
};

jQuery.ui.position._sapUiCommonsMenuFlip = {
	left: function(position, data){
		
		if(jQuery.ui.position.flipfit){ //jQuery UI 1.9 ff.
			jQuery.ui.position.flipfit.left.apply(this, arguments);
			return;
		}
		
		//jQuery UI 1.8
		data = _migrateDataTojQueryUI110(data);
		_pos_jQueryUI110.flipfit.left.apply(this, arguments);
	},
	top: function(position, data){
		
		if(jQuery.ui.position.flipfit){ //jQuery UI 1.9 ff.
			jQuery.ui.position.flipfit.top.apply(this, arguments);
			return;
		}
		
		//jQuery UI 1.8
		data = _migrateDataTojQueryUI110(data);
		_pos_jQueryUI110.flipfit.top.apply(this, arguments);
	}
};

//******************** jQuery UI 1.10.3 End **************************


})(window);

}; // end of sap/ui/unified/Menu.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.MenuItem.
jQuery.sap.declare("sap.ui.unified.MenuItem");




/**
 * Constructor for a new MenuItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string (default: '')</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI (default: '')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.unified.MenuItemBase#constructor sap.ui.unified.MenuItemBase}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Smallest unit in the menu hierarchy. An item can be a direct part of a menu bar, of a menu, or of a sub menu.
 * @extends sap.ui.unified.MenuItemBase
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @name sap.ui.unified.MenuItem
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.unified.MenuItemBase.extend("sap.ui.unified.MenuItem", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"text" : {type : "string", group : "Appearance", defaultValue : ''},
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.MenuItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.MenuItem.extend
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * 
 * Item text
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.ui.unified.MenuItem#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.ui.unified.MenuItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItem#setText
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * 
 * Icon to be displayed
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.unified.MenuItem#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.unified.MenuItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.MenuItem#setIcon
 * @function
 */


// Start of sap\ui\unified\MenuItem.js
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained

sap.ui.core.IconPool.getIconInfo("", ""); //Ensure Icon Font is loaded

sap.ui.unified.MenuItem.prototype.render = function(oRenderManager, oItem, oMenu, oInfo){
	var rm = oRenderManager;
	var oSubMenu = oItem.getSubmenu();
	rm.write("<li ");
	rm.writeAttribute("class", "sapUiMnuItm" + (oMenu.checkEnabled(oItem) ? "" : " sapUiMnuItmDsbl"));
	if(oItem.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oItem.getTooltip_AsString());
	}
	rm.writeElementData(oItem);

	// ARIA
	if(oInfo.bAccessible){
		rm.writeAttribute("role", "menuitem");
		rm.writeAttribute("aria-labelledby", oMenu.getId()+" "+this.getId()+"-txt "+this.getId()+"-scuttxt");
		rm.writeAttribute("aria-disabled", !oMenu.checkEnabled(oItem));
		rm.writeAttribute("aria-posinset", oInfo.iItemNo);
		rm.writeAttribute("aria-setsize", oInfo.iTotalItems);
		if (oSubMenu) {
			rm.writeAttribute("aria-haspopup", true);
			rm.writeAttribute("aria-owns", oSubMenu.getId());
		}
	}

	// Left border
	rm.write("><div class=\"sapUiMnuItmL\"></div>");

	// icon/check column
	rm.write("<div class=\"sapUiMnuItmIco\">");
	if (oItem.getIcon()) {
		rm.writeIcon(oItem.getIcon());
	}
	rm.write("</div>");

	// Text column
	rm.write("<div id=\""+this.getId()+"-txt\" class=\"sapUiMnuItmTxt\">");
	rm.writeEscaped(oItem.getText());
	rm.write("</div>");

	// Shortcut column
	rm.write("<div id=\""+this.getId()+"-scuttxt\" class=\"sapUiMnuItmSCut\"></div>");

	// Submenu column
	rm.write("<div class=\"sapUiMnuItmSbMnu\">");
	if(oSubMenu) {
		rm.write("<div class=\"sapUiIconMirrorInRTL\"></div>");
	}
	rm.write("</div>");

	// Right border
	rm.write("<div class=\"sapUiMnuItmR\"></div>");

	rm.write("</li>");
};

/**
 * @protected
 */
sap.ui.unified.MenuItem.prototype.hover = function(bHovered, oMenu){
	this.$().toggleClass("sapUiMnuItmHov", bHovered);
};
}; // end of sap/ui/unified/MenuItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Shell') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.Shell.
jQuery.sap.declare("sap.ui.unified.Shell");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Shell.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getShowPane showPane} : boolean</li>
 * <li>{@link #getShowCurtain showCurtain} : boolean</li>
 * <li>{@link #getShowCurtainPane showCurtainPane} : boolean</li>
 * <li>{@link #getHeaderHiding headerHiding} : boolean</li>
 * <li>{@link #getHeaderVisible headerVisible} : boolean (default: true)</li>
 * <li>{@link #getSearchVisible searchVisible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getPaneContent paneContent} : sap.ui.core.Control[]</li>
 * <li>{@link #getCurtainContent curtainContent} : sap.ui.core.Control[]</li>
 * <li>{@link #getCurtainPaneContent curtainPaneContent} : sap.ui.core.Control[]</li>
 * <li>{@link #getHeadItems headItems} : sap.ui.unified.ShellHeadItem[]</li>
 * <li>{@link #getHeadEndItems headEndItems} : sap.ui.unified.ShellHeadItem[]</li>
 * <li>{@link #getSearch search} : sap.ui.core.Control</li>
 * <li>{@link #getUser user} : sap.ui.unified.ShellHeadUserItem</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The shell control is meant as root control (full-screen) of an application.
 * It was build as root control of the Fiori Launchpad application and provides the basic capabilities
 * for this purpose. Do not use this control within applications which run inside the Fiori Lauchpad and
 * do not use it for other scenarios than the root control usecase.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.15.1
 * @name sap.ui.unified.Shell
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.Shell", { metadata : {

	library : "sap.ui.unified",
	properties : {
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"showPane" : {type : "boolean", group : "Appearance", defaultValue : null},
		"showCurtain" : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true},
		"showCurtainPane" : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true},
		"headerHiding" : {type : "boolean", group : "Appearance", defaultValue : null},
		"headerVisible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"searchVisible" : {type : "boolean", group : "Appearance", defaultValue : true}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
		"paneContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "paneContent"}, 
		"curtainContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "curtainContent"}, 
		"curtainPaneContent" : {type : "sap.ui.core.Control", multiple : true, singularName : "curtainPaneContent"}, 
		"headItems" : {type : "sap.ui.unified.ShellHeadItem", multiple : true, singularName : "headItem"}, 
		"headEndItems" : {type : "sap.ui.unified.ShellHeadItem", multiple : true, singularName : "headEndItem"}, 
		"search" : {type : "sap.ui.core.Control", multiple : false}, 
		"canvasSplitContainer" : {type : "sap.ui.unified.SplitContainer", multiple : false, visibility : "hidden"}, 
		"curtainSplitContainer" : {type : "sap.ui.unified.SplitContainer", multiple : false, visibility : "hidden"}, 
		"user" : {type : "sap.ui.unified.ShellHeadUserItem", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.Shell with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.Shell.extend
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * The application icon.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.ui.unified.Shell#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setIcon
 * @function
 */


/**
 * Getter for property <code>showPane</code>.
 * Shows / Hides the side pane.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showPane</code>
 * @public
 * @name sap.ui.unified.Shell#getShowPane
 * @function
 */

/**
 * Setter for property <code>showPane</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowPane  new value for property <code>showPane</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setShowPane
 * @function
 */


/**
 * Getter for property <code>showCurtain</code>.
 * Shows / Hides the curtain.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showCurtain</code>
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#getShowCurtain
 * @function
 */

/**
 * Setter for property <code>showCurtain</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowCurtain  new value for property <code>showCurtain</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#setShowCurtain
 * @function
 */


/**
 * Getter for property <code>showCurtainPane</code>.
 * Shows / Hides the side pane on the curtain.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showCurtainPane</code>
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#getShowCurtainPane
 * @function
 */

/**
 * Setter for property <code>showCurtainPane</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowCurtainPane  new value for property <code>showCurtainPane</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.3. 
 * Curtain is deprecated and replaced by ShellOverlay mechanism.
 * @name sap.ui.unified.Shell#setShowCurtainPane
 * @function
 */


/**
 * Getter for property <code>headerHiding</code>.
 * Whether the header can be hidden (manually or automatically). This feature is only available when touch events are supported.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>headerHiding</code>
 * @public
 * @name sap.ui.unified.Shell#getHeaderHiding
 * @function
 */

/**
 * Setter for property <code>headerHiding</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bHeaderHiding  new value for property <code>headerHiding</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setHeaderHiding
 * @function
 */


/**
 * Getter for property <code>headerVisible</code>.
 * If set to false, no header (and no items, search, ...) is shown.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>headerVisible</code>
 * @public
 * @since 1.23
 * @name sap.ui.unified.Shell#getHeaderVisible
 * @function
 */

/**
 * Setter for property <code>headerVisible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bHeaderVisible  new value for property <code>headerVisible</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @since 1.23
 * @name sap.ui.unified.Shell#setHeaderVisible
 * @function
 */


/**
 * Getter for property <code>searchVisible</code>.
 * If set to false, the search area (aggregation 'search') is hidden.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>searchVisible</code>
 * @public
 * @since 1.18
 * @name sap.ui.unified.Shell#getSearchVisible
 * @function
 */

/**
 * Setter for property <code>searchVisible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bSearchVisible  new value for property <code>searchVisible</code>
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @since 1.18
 * @name sap.ui.unified.Shell#setSearchVisible
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content to appear in the main canvas.
 * 
 * <strong>Note</strong>: this is the default aggregation for Shell.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.unified.Shell#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>paneContent</code>.<br/>
 * The content to appear in the pane area.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getPaneContent
 * @function
 */


/**
 * Inserts a paneContent into the aggregation named <code>paneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oPaneContent the paneContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the paneContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the paneContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the paneContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertPaneContent
 * @function
 */

/**
 * Adds some paneContent <code>oPaneContent</code> 
 * to the aggregation named <code>paneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oPaneContent the paneContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addPaneContent
 * @function
 */

/**
 * Removes an paneContent from the aggregation named <code>paneContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vPaneContent the paneContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed paneContent or null
 * @public
 * @name sap.ui.unified.Shell#removePaneContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>paneContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllPaneContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>paneContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oPaneContent the paneContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfPaneContent
 * @function
 */
	

/**
 * Destroys all the paneContent in the aggregation 
 * named <code>paneContent</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyPaneContent
 * @function
 */


/**
 * Getter for aggregation <code>curtainContent</code>.<br/>
 * The content to appear in the curtain area.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getCurtainContent
 * @function
 */


/**
 * Inserts a curtainContent into the aggregation named <code>curtainContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oCurtainContent the curtainContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the curtainContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the curtainContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the curtainContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertCurtainContent
 * @function
 */

/**
 * Adds some curtainContent <code>oCurtainContent</code> 
 * to the aggregation named <code>curtainContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainContent the curtainContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addCurtainContent
 * @function
 */

/**
 * Removes an curtainContent from the aggregation named <code>curtainContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vCurtainContent the curtainContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed curtainContent or null
 * @public
 * @name sap.ui.unified.Shell#removeCurtainContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>curtainContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllCurtainContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>curtainContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainContent the curtainContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfCurtainContent
 * @function
 */
	

/**
 * Destroys all the curtainContent in the aggregation 
 * named <code>curtainContent</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyCurtainContent
 * @function
 */


/**
 * Getter for aggregation <code>curtainPaneContent</code>.<br/>
 * The content to appear in the pane area of the curtain.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.Shell#getCurtainPaneContent
 * @function
 */


/**
 * Inserts a curtainPaneContent into the aggregation named <code>curtainPaneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *          oCurtainPaneContent the curtainPaneContent to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the curtainPaneContent should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the curtainPaneContent is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the curtainPaneContent is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertCurtainPaneContent
 * @function
 */

/**
 * Adds some curtainPaneContent <code>oCurtainPaneContent</code> 
 * to the aggregation named <code>curtainPaneContent</code>.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainPaneContent the curtainPaneContent to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addCurtainPaneContent
 * @function
 */

/**
 * Removes an curtainPaneContent from the aggregation named <code>curtainPaneContent</code>.
 *
 * @param {int | string | sap.ui.core.Control} vCurtainPaneContent the curtainPaneContent to remove or its index or id
 * @return {sap.ui.core.Control} the removed curtainPaneContent or null
 * @public
 * @name sap.ui.unified.Shell#removeCurtainPaneContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>curtainPaneContent</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllCurtainPaneContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>curtainPaneContent</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oCurtainPaneContent the curtainPaneContent whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfCurtainPaneContent
 * @function
 */
	

/**
 * Destroys all the curtainPaneContent in the aggregation 
 * named <code>curtainPaneContent</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyCurtainPaneContent
 * @function
 */


/**
 * Getter for aggregation <code>headItems</code>.<br/>
 * The buttons shown in the begin (left in left-to-right case) of the Shell header. Currently max. 3 visible buttons are supported.
 * 
 * @return {sap.ui.unified.ShellHeadItem[]}
 * @public
 * @name sap.ui.unified.Shell#getHeadItems
 * @function
 */


/**
 * Inserts a headItem into the aggregation named <code>headItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *          oHeadItem the headItem to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the headItem should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the headItem is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the headItem is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertHeadItem
 * @function
 */

/**
 * Adds some headItem <code>oHeadItem</code> 
 * to the aggregation named <code>headItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadItem the headItem to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addHeadItem
 * @function
 */

/**
 * Removes an headItem from the aggregation named <code>headItems</code>.
 *
 * @param {int | string | sap.ui.unified.ShellHeadItem} vHeadItem the headItem to remove or its index or id
 * @return {sap.ui.unified.ShellHeadItem} the removed headItem or null
 * @public
 * @name sap.ui.unified.Shell#removeHeadItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>headItems</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.ShellHeadItem[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllHeadItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.ShellHeadItem</code> in the aggregation named <code>headItems</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadItem the headItem whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfHeadItem
 * @function
 */
	

/**
 * Destroys all the headItems in the aggregation 
 * named <code>headItems</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyHeadItems
 * @function
 */


/**
 * Getter for aggregation <code>headEndItems</code>.<br/>
 * The buttons shown in the end (right in left-to-right case) of the Shell header. Currently max. 3 visible buttons are supported (when user is set only 1).
 * 
 * @return {sap.ui.unified.ShellHeadItem[]}
 * @public
 * @name sap.ui.unified.Shell#getHeadEndItems
 * @function
 */


/**
 * Inserts a headEndItem into the aggregation named <code>headEndItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *          oHeadEndItem the headEndItem to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the headEndItem should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the headEndItem is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the headEndItem is inserted at 
 *             the last position        
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#insertHeadEndItem
 * @function
 */

/**
 * Adds some headEndItem <code>oHeadEndItem</code> 
 * to the aggregation named <code>headEndItems</code>.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadEndItem the headEndItem to add; if empty, nothing is inserted
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#addHeadEndItem
 * @function
 */

/**
 * Removes an headEndItem from the aggregation named <code>headEndItems</code>.
 *
 * @param {int | string | sap.ui.unified.ShellHeadItem} vHeadEndItem the headEndItem to remove or its index or id
 * @return {sap.ui.unified.ShellHeadItem} the removed headEndItem or null
 * @public
 * @name sap.ui.unified.Shell#removeHeadEndItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>headEndItems</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.unified.ShellHeadItem[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.Shell#removeAllHeadEndItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.unified.ShellHeadItem</code> in the aggregation named <code>headEndItems</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.unified.ShellHeadItem}
 *            oHeadEndItem the headEndItem whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.Shell#indexOfHeadEndItem
 * @function
 */
	

/**
 * Destroys all the headEndItems in the aggregation 
 * named <code>headEndItems</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroyHeadEndItems
 * @function
 */


/**
 * Getter for aggregation <code>search</code>.<br/>
 * Experimental (This aggregation might change in future!): The search control which should be displayed in the shell header.
 * 
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.ui.unified.Shell#getSearch
 * @function
 */


/**
 * Setter for the aggregated <code>search</code>.
 * @param {sap.ui.core.Control} oSearch
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#setSearch
 * @function
 */
	

/**
 * Destroys the search in the aggregation 
 * named <code>search</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.Shell#destroySearch
 * @function
 */


/**
 * Getter for aggregation <code>user</code>.<br/>
 * The user item which is rendered in the shell header beside the items.
 * 
 * @return {sap.ui.unified.ShellHeadUserItem}
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.Shell#getUser
 * @function
 */


/**
 * Setter for the aggregated <code>user</code>.
 * @param {sap.ui.unified.ShellHeadUserItem} oUser
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.Shell#setUser
 * @function
 */
	

/**
 * Destroys the user in the aggregation 
 * named <code>user</code>.
 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
 * @public
 * @since 1.22.0
 * @name sap.ui.unified.Shell#destroyUser
 * @function
 */


// Start of sap\ui\unified\Shell.js
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained

jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained

jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained


jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


sap.ui.unified.Shell._SIDEPANE_WIDTH_PHONE = 208;
sap.ui.unified.Shell._SIDEPANE_WIDTH_TABLET = 208;
sap.ui.unified.Shell._SIDEPANE_WIDTH_DESKTOP = 240;
sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE = true; /*Whether header hiding is technically possible (touch enabled)*/
sap.ui.unified.Shell._HEADER_AUTO_CLOSE = true;
sap.ui.unified.Shell._HEADER_TOUCH_TRESHOLD = 30;
if(sap.ui.Device.browser.chrome){
	//see https://groups.google.com/a/chromium.org/forum/#!topic/input-dev/Ru9xjSsvLHw --> chrome://flags/#touch-scrolling-mode
	sap.ui.unified.Shell._HEADER_TOUCH_TRESHOLD = sap.ui.Device.browser.version < 36 ? 10 : 15;
}
	
sap.ui.unified.Shell.prototype.init = function(){
	var that = this;
	
	this._rtl = sap.ui.getCore().getConfiguration().getRTL();
	this._animation = sap.ui.getCore().getConfiguration().getAnimation();
	this._showHeader = true;
	this._iHeaderHidingDelay = 3000; /*Currently hidden but maybe a property later (see getter and setter below)*/
	this._useStrongBG = false;
	
	this._cont = new sap.ui.unified.SplitContainer(this.getId()+"-container");
	this._cont._bRootContent = true; // see e.g. sap.m.App#onAfterRendering
	this.setAggregation("canvasSplitContainer", this._cont, true);
	
	this._curtCont = new sap.ui.unified.SplitContainer(this.getId()+"-curt-container");
	this._curtCont._bRootContent = true; // see e.g. sap.m.App#onAfterRendering
	this.setAggregation("curtainSplitContainer", this._curtCont, true);
	
	function _setSidePaneWidth(sRange){
		if(!sRange){
			sRange = sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD).name;
		}
		
		var w = sap.ui.unified.Shell["_SIDEPANE_WIDTH_"+sRange.toUpperCase()]+"px";
		that._cont.setSecondaryContentSize(w);
		that._curtCont.setSecondaryContentSize(w);
	};
	
	_setSidePaneWidth();

	this._handleMediaChange = function(mParams){
		if(!that.getDomRef()){
			return;
		}
		
		_setSidePaneWidth(mParams.name);
		
		that._refreshHeader();
	};
	
	sap.ui.Device.media.attachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
	
	this._handleResizeChange = function(mParams){
		if(!that.getDomRef() || !that.getUser()){
			return;
		}
		
		var oUser = this.getUser();
		var bChanged = oUser._checkAndAdaptWidth(!this.$("hdr-search").hasClass("sapUiUfdShellHidden") && !!this.getSearch());
		if(bChanged){
			that._refreshHeader();
		}
	};
	
	sap.ui.Device.resize.attachHandler(this._handleResizeChange, this);
	
	function __refreshHeader(){
		that._refreshHeader();
	};
	
	this._headCenterRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-center", function(rm){
		sap.ui.unified.ShellRenderer.renderSearch(rm, that);
	}, __refreshHeader);
	
	this._headBeginRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-begin", function(rm){
		sap.ui.unified.ShellRenderer.renderHeaderItems(rm, that, true);
	}, __refreshHeader);
	
	this._headEndRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-end", function(rm){
		sap.ui.unified.ShellRenderer.renderHeaderItems(rm, that, false);
	}, __refreshHeader);
};


sap.ui.unified.Shell.prototype.exit = function(){
	sap.ui.Device.media.detachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
	delete this._handleMediaChange;
	
	sap.ui.Device.resize.detachHandler(this._handleResizeChange, this);
	delete this._handleResizeChange;
	
	this._headCenterRenderer.destroy();
	delete this._headCenterRenderer;
	this._headBeginRenderer.destroy();
	delete this._headBeginRenderer;
	this._headEndRenderer.destroy();
	delete this._headEndRenderer;
	
	delete this._cont; //Destroy of child controls done via aggregation handling
	delete this._curtCont;
};


sap.ui.unified.Shell.prototype.onAfterRendering = function(){
	var that = this;
	
	if(window.addEventListener && !sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE){
		function headerFocus(oBrowserEvent){
			var oEvent = jQuery.event.fix(oBrowserEvent);
			if(jQuery.sap.containsOrEquals(that.getDomRef("hdr"), oEvent.target)){
				that._timedHideHeader(oEvent.type === "focus");
			}
		};
		
		var oHdr = this.getDomRef("hdr");
		oHdr.addEventListener("focus", headerFocus, true);
		oHdr.addEventListener("blur", headerFocus, true);
	}
	
	this._refreshAfterRendering();
	
	this.$("hdr-center").toggleClass("sapUiUfdShellAnim", !this._noHeadCenterAnim);
};


sap.ui.unified.Shell.prototype.onThemeChanged = function(){
	if(this._refreshAfterRendering() && this._headBeginRenderer){
		this._headBeginRenderer.render(); //Refresh Company Logo
	}
};

sap.ui.unified.Shell.prototype.onfocusin = function(oEvent) {
	var sId = this.getId();
	
	if (oEvent.target.id === sId + "-curt-focusDummyOut") {
		// Jump back to shell when you reach the end of the curtain
		jQuery.sap.focus(this.$("hdrcntnt").firstFocusableDomRef());
	} else if (oEvent.target.id === sId + "-main-focusDummyOut") {
		// Jump to the curtain if it is open (can only reached by tabbing back when curtain is open)
		jQuery.sap.focus(this.$("curtcntnt").firstFocusableDomRef());
	}
};




(function(){

if(sap.ui.Device.support.touch){
	
	sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE = false;
		
	function _updateHeader(oShell){
		if(oShell._startY === undefined || oShell._currY === undefined){
			return;
		}
		
		var yMove = oShell._currY - oShell._startY;
		if(Math.abs(yMove) > sap.ui.unified.Shell._HEADER_TOUCH_TRESHOLD){
			oShell._doShowHeader(yMove > 0);
			oShell._startY = oShell._currY;
		}
	};
	
	sap.ui.unified.Shell.prototype.ontouchstart = function(oEvent){
		this._startY = oEvent.touches[0].pageY;
		if(this._startY > 2*48){ /*Only when touch starts "nearby" the header*/
			this._startY = undefined;
		}
		this._currY = this._startY;
	};
	
	sap.ui.unified.Shell.prototype.ontouchend = function(oEvent){
		_updateHeader(this);
		this._startY = undefined;
		this._currY = undefined;
	};
	
	sap.ui.unified.Shell.prototype.ontouchcancel = sap.ui.unified.Shell.prototype.ontouchend;
	
	sap.ui.unified.Shell.prototype.ontouchmove = function(oEvent){
		this._currY = oEvent.touches[0].pageY;
		_updateHeader(this);
	};
	
}

})();


// ***************** API / Overridden generated API *****************


sap.ui.unified.Shell.prototype.setHeaderHiding = function(bEnabled){
	bEnabled = !!bEnabled;
	return this._mod(function(bRendered){
		return this.setProperty("headerHiding", bEnabled, bRendered);
	}, function(){
		this._doShowHeader(!bEnabled ? true : this._showHeader);
	});
};


/*Not public, Maybe API later*/
sap.ui.unified.Shell.prototype.setHeaderHidingDelay = function(iDelay){
	this._iHeaderHidingDelay = iDelay;
	return this;
};


/*Not public, Maybe API later*/
sap.ui.unified.Shell.prototype.getHeaderHidingDelay = function(){
	return this._iHeaderHidingDelay;
};


sap.ui.unified.Shell.prototype.getShowPane = function(){
	return this._cont.getShowSecondaryContent();
};


sap.ui.unified.Shell.prototype.setShowPane = function(bShowPane){
	this._cont.setShowSecondaryContent(bShowPane);
	this.setProperty("showPane", !!bShowPane, true);
	return this;
};


sap.ui.unified.Shell.prototype.getShowPane = function(){
	return this._cont.getShowSecondaryContent();
};


sap.ui.unified.Shell.prototype.setShowCurtainPane = function(bShowPane){
	this._curtCont.setShowSecondaryContent(bShowPane);
	this.setProperty("showCurtainPane", !!bShowPane, true);
	return this;
};


sap.ui.unified.Shell.prototype.getShowCurtainPane = function(){
	return this._curtCont.getShowSecondaryContent();
};


sap.ui.unified.Shell.prototype.setShowCurtain = function(bShowCurtain){
	bShowCurtain = !!bShowCurtain;
	
	return this._mod(function(bRendered){
		return this.setProperty("showCurtain", bShowCurtain, bRendered);
	}, function(){
		this.$("main-focusDummyOut").attr("tabindex", bShowCurtain ? 0 : -1);
		this.$().toggleClass("sapUiUfdShellCurtainHidden", !bShowCurtain).toggleClass("sapUiUfdShellCurtainVisible", bShowCurtain);
		
		if(bShowCurtain){
			var zIndex = sap.ui.core.Popup.getNextZIndex();
			this.$("curt").css("z-index", zIndex+1);
			this.$("hdr").css("z-index", zIndex+3);
			this.$("brand").css("z-index", zIndex+7);
			this.$().toggleClass("sapUiUfdShellCurtainClosed", false);
		}
		
		this._timedCurtainClosed(bShowCurtain);
		
		this._doShowHeader(true);
	});
};


sap.ui.unified.Shell.prototype.setIcon = function(sIcon){
	return this._mod(function(bRendered){
		return this.setProperty("icon", sIcon, bRendered);
	}, this._headBeginRenderer);
};


sap.ui.unified.Shell.prototype.setSearchVisible = function(bSearchVisible){
	var bSearchCurrentlyVisible = this.getSearchVisible(),
		bSearchVisible = !!bSearchVisible,
		$search = this.$("hdr-search");
	
	if(bSearchCurrentlyVisible == bSearchVisible){
		return;
	}
	
	$search.toggleClass("sapUiUfdShellHidden", !bSearchVisible);
	
	return this.setProperty("searchVisible", bSearchVisible, true);
};


sap.ui.unified.Shell.prototype.setHeaderVisible = function(bHeaderVisible){
	bHeaderVisible = !!bHeaderVisible;
	this.setProperty("headerVisible", bHeaderVisible, true);
	this.$().toggleClass("sapUiUfdShellNoHead", !bHeaderVisible);
	if(bHeaderVisible){
		this._refreshHeader();
	}
	return this;
};


sap.ui.unified.Shell.prototype.setSearch = function(oSearch){
	return this._mod(function(bRendered){
		this.setAggregation("search", oSearch, bRendered);
		this.$().toggleClass("sapUiUfdShellWithSearch", !!oSearch);
		return this;
	}, this._headCenterRenderer);
};


sap.ui.unified.Shell.prototype.setUser = function(oUser){
	return this._mod(function(bRendered){
		return this.setAggregation("user", oUser, bRendered);
	}, this._headEndRenderer);
};


sap.ui.unified.Shell.prototype.getContent = function() {
	return this._cont.getContent();
};
sap.ui.unified.Shell.prototype.insertContent = function(oContent, iIndex) {
	this._cont.insertContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addContent = function(oContent) {
	this._cont.addContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removeContent = function(vIndex) {
	return this._cont.removeContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllContent = function() {
	return this._cont.removeAllContent();
};
sap.ui.unified.Shell.prototype.destroyContent = function() {
	this._cont.destroyContent();
	return this;
};
sap.ui.unified.Shell.prototype.indexOfContent = function(oContent) {
	return this._cont.indexOfContent(oContent);
};


sap.ui.unified.Shell.prototype.getPaneContent = function() {
	return this._cont.getSecondaryContent();
};
sap.ui.unified.Shell.prototype.insertPaneContent = function(oContent, iIndex) {
	this._cont.insertSecondaryContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addPaneContent = function(oContent) {
	this._cont.addSecondaryContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removePaneContent = function(vIndex) {
	return this._cont.removeSecondaryContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllPaneContent = function() {
	return this._cont.removeAllSecondaryContent();
};
sap.ui.unified.Shell.prototype.destroyPaneContent = function() {
	this._cont.destroySecondaryContent();
	return this;
};
sap.ui.unified.Shell.prototype.indexOfPaneContent = function(oContent) {
	return this._cont.indexOfSecondaryContent(oContent);
};

sap.ui.unified.Shell.prototype.getCurtainContent = function() {
	return this._curtCont.getContent();
};
sap.ui.unified.Shell.prototype.insertCurtainContent = function(oContent, iIndex) {
	this._curtCont.insertContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addCurtainContent = function(oContent) {
	this._curtCont.addContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removeCurtainContent = function(vIndex) {
	return this._curtCont.removeContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllCurtainContent = function() {
	return this._curtCont.removeAllContent();
};
sap.ui.unified.Shell.prototype.destroyCurtainContent = function() {
	this._curtCont.destroyContent();
	return this;
};
sap.ui.unified.Shell.prototype.indexOfCurtainContent = function(oContent) {
	return this._curtCont.indexOfCurtainContent(oContent);
};

sap.ui.unified.Shell.prototype.getCurtainPaneContent = function() {
	return this._curtCont.getSecondaryContent();
};
sap.ui.unified.Shell.prototype.insertCurtainPaneContent = function(oContent, iIndex) {
	this._curtCont.insertSecondaryContent(oContent, iIndex);
	return this;
};
sap.ui.unified.Shell.prototype.addCurtainPaneContent = function(oContent) {
	this._curtCont.addSecondaryContent(oContent);
	return this;
};
sap.ui.unified.Shell.prototype.removeCurtainPaneContent = function(vIndex) {
	return this._curtCont.removeSecondaryContent(vIndex);
};
sap.ui.unified.Shell.prototype.removeAllCurtainPaneContent = function() {
	return this._curtCont.removeAllSecondaryContent();
};
sap.ui.unified.Shell.prototype.destroyCurtainPaneContent = function() {
	this._curtCont.destroySecondaryContent();
	return this;
};
sap.ui.unified.Shell.prototype.indexOfCurtainPaneContent = function(oContent) { 
	return this._curtCont.indexOfSecondaryContent(oContent);
};

sap.ui.unified.Shell.prototype.insertHeadItem = function(oHeadItem, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("headItems", oHeadItem, iIndex, bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.addHeadItem = function(oHeadItem) {
	return this._mod(function(bRendered){
		return this.addAggregation("headItems", oHeadItem, bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.removeHeadItem = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("headItems", vIndex, bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.removeAllHeadItems = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("headItems", bRendered);
	}, this._headBeginRenderer);
};
sap.ui.unified.Shell.prototype.destroyHeadItems = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("headItems", bRendered);
	}, this._headBeginRenderer);
};

sap.ui.unified.Shell.prototype.insertHeadEndItem = function(oHeadItem, iIndex) {
	return this._mod(function(bRendered){
		return this.insertAggregation("headEndItems", oHeadItem, iIndex, bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.addHeadEndItem = function(oHeadItem) {
	return this._mod(function(bRendered){
		return this.addAggregation("headEndItems", oHeadItem, bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.removeHeadEndItem = function(vIndex) {
	return this._mod(function(bRendered){
		return this.removeAggregation("headEndItems", vIndex, bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.removeAllHeadEndItems = function() {
	return this._mod(function(bRendered){
		return this.removeAllAggregation("headEndItems", bRendered);
	}, this._headEndRenderer);
};
sap.ui.unified.Shell.prototype.destroyHeadEndItems = function() {
	return this._mod(function(bRendered){
		return this.destroyAggregation("headEndItems", bRendered);
	}, this._headEndRenderer);
};


/*Restricted API for Launchpad to set a Strong BG style*/
sap.ui.unified.Shell.prototype._setStrongBackground = function(bUseStongBG){	
	this._useStrongBG = !!bUseStongBG;
	this.$("strgbg").toggleClass("sapMGlobalBackgroundColorStrong", this._useStrongBG);
};

// ***************** Private Helpers *****************


sap.ui.unified.Shell.prototype._doShowHeader = function(bShow){
	var bWasVisible = this._showHeader;
	this._showHeader = this._isHeaderHidingActive() ? !!bShow : true;
	
	this.$().toggleClass("sapUiUfdShellHeadHidden", !this._showHeader).toggleClass("sapUiUfdShellHeadVisible", this._showHeader);
	
	if(this._showHeader){
		this._timedHideHeader();
	}
	
	if (bWasVisible != this._showHeader && this._isHeaderHidingActive()){
		jQuery.sap.delayedCall(500, this, function(){
			try {
				var oResizeEvent = document.createEvent("UIEvents");
				oResizeEvent.initUIEvent("resize", true, false, window, 0);
				window.dispatchEvent(oResizeEvent);
			} catch(e) {
				jQuery.sap.log.error(e);
			}
		});
	}
};

sap.ui.unified.Shell.prototype._timedHideHeader = function(bClearOnly){
	if(this._headerHidingTimer){
		jQuery.sap.clearDelayedCall(this._headerHidingTimer);
		this._headerHidingTimer = null;
	}
	
	if(bClearOnly || !sap.ui.unified.Shell._HEADER_AUTO_CLOSE || !this._isHeaderHidingActive() || this._iHeaderHidingDelay <= 0){
		return;
	}
	
	this._headerHidingTimer = jQuery.sap.delayedCall(this._iHeaderHidingDelay, this, function(){
		if(this._isHeaderHidingActive() && this._iHeaderHidingDelay > 0 && !jQuery.sap.containsOrEquals(this.getDomRef("hdr"), document.activeElement)){
			this._doShowHeader(false);
		}
	});
};

sap.ui.unified.Shell.prototype._timedCurtainClosed = function(bClearOnly){
	if(this._curtainClosedTimer){
		jQuery.sap.clearDelayedCall(this._curtainClosedTimer);
		this._curtainClosedTimer = null;
	}
	
	if(bClearOnly){
		return;
	}
	
	var duration = parseInt(sap.ui.core.theming.Parameters.get("sapUiUfdShellAnimDuration"), 10);
	if(!this._animation || (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10)){
		duration = 0;
	}
	
	this._curtainClosedTimer = jQuery.sap.delayedCall(duration, this, function(){
		this._curtainClosedTimer = null;
		this.$("curt").css("z-index", "");
		this.$("hdr").css("z-index", "");
		this.$("brand").css("z-index", "");
		this.$().toggleClass("sapUiUfdShellCurtainClosed", true);
	});
};


sap.ui.unified.Shell.prototype._mod = function(fMod, oDoIfRendered){
	var bRendered = !!this.getDomRef();
	var res = fMod.apply(this, [bRendered]);
	if(bRendered && oDoIfRendered){
		if(oDoIfRendered instanceof sap.ui.unified._ContentRenderer){
			oDoIfRendered.render();
		}else{
			oDoIfRendered.apply(this);
		}
	}
	return res;
};


sap.ui.unified.Shell.prototype._refreshHeader = function(){
	function updateItems(aItems){
		for(var i=0; i<aItems.length; i++){
			aItems[i]._refreshIcon();
		}
	}
	
	updateItems(this.getHeadItems());
	updateItems(this.getHeadEndItems());
	
	var oUser = this.getUser(),
		isPhoneSize = jQuery("html").hasClass("sapUiMedia-Std-Phone"),
		searchVisible = !this.$("hdr-search").hasClass("sapUiUfdShellHidden"),
		$logo = this.$("icon");
	
	if(oUser){
		oUser._refreshImage();
		oUser._checkAndAdaptWidth(searchVisible && !!this.getSearch());
	}
	
	$logo.parent().toggleClass("sapUiUfdShellHidden", isPhoneSize && searchVisible && !!this.getSearch());
	
	var	we = this.$("hdr-end").outerWidth(),
		wb = this.$("hdr-begin").outerWidth(),
		wmax = Math.max(we, wb),
		begin = (isPhoneSize && searchVisible ? wb : wmax)+"px",
		end = (isPhoneSize && searchVisible ? we : wmax)+"px";

	this.$("hdr-center").css({
		"left": this._rtl ? end : begin,
		"right": this._rtl ? begin : end
	});
};


sap.ui.unified.Shell.prototype._getIcon = function(){
	var ico = this.getIcon();
	if(!ico){
		jQuery.sap.require("sap.ui.core.theming.Parameters");
		ico = sap.ui.core.theming.Parameters._getThemeImage(null, true); // theme logo
	}
	return ico;
};


sap.ui.unified.Shell.prototype._refreshAfterRendering = function(){
	var oDom = this.getDomRef();
	
	if(!oDom){
		return false;
	}

	this._repaint(oDom);
	this._refreshHeader();
	
	this._timedHideHeader();
	
	return true;
};


sap.ui.unified.Shell.prototype._repaint = function(oDom){
	if(sap.ui.Device.browser.webkit){
		var display = oDom.style.display;
		oDom.style.display = "none";
		oDom.offsetHeight;
		oDom.style.display = display;
		
		this._refreshCSSWorkaround();
	}
};

sap.ui.unified.Shell.prototype._isHeaderHidingActive = function(){
	// Not active if no touch, the curtain is open or the hiding is deactivated via API
	if(sap.ui.unified.Shell._HEADER_ALWAYS_VISIBLE || this.getShowCurtain() || !this.getHeaderHiding() || sap.ui.unified._iNumberOfOpenedShellOverlays > 0 || !this.getHeaderVisible()){
		return false;
	}
	return true;
};

sap.ui.unified.Shell.prototype._refreshCSSWorkaround = function() {
	if(!sap.ui.Device.browser.webkit || !sap.ui.Device.support.touch){
		return;
	}
	
	if(this._cssWorkaroundTimer){
		jQuery.sap.clearDelayedCall(this._cssWorkaroundTimer);
		this._cssWorkaroundTimer = null;
	}
	this.$("css").remove();

	this._cssWorkaroundTimer = jQuery.sap.delayedCall(10, this, function(){
		this._cssWorkaroundTimer = null;
		jQuery.sap.log.debug("sap.ui.unified.Shell: CSS Workaround applied.");
		jQuery("head").append("<link type='text/css' rel='stylesheet' id='"+this.getId()+"-css' href='data:text/css;base64,LnNhcFVpVWZkU2hlbGxDaHJvbWVSZXBhaW50e291dGxpbmUtY29sb3I6aW5pdGlhbDt9'/>");
		this._cssWorkaroundTimer = jQuery.sap.delayedCall(100, this, function(){
			this.$("css").remove();
		});
	});
};



//***************** Avoid Rerendering *****************


sap.ui.unified.Shell.prototype.invalidate = function(oOrigin) {
	if(oOrigin instanceof sap.ui.unified.ShellHeadItem && this._headBeginRenderer && this._headEndRenderer){
		this._headBeginRenderer.render();
		this._headEndRenderer.render();
	}else if(oOrigin instanceof sap.ui.unified.ShellHeadUserItem && this._headEndRenderer){
		this._headEndRenderer.render();
	}else{
		sap.ui.core.Control.prototype.invalidate.apply(this, arguments);
	}
};



}; // end of sap/ui/unified/Shell.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellOverlay') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.unified.ShellOverlay.
jQuery.sap.declare("sap.ui.unified.ShellOverlay");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ShellOverlay.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getSearch search} : sap.ui.core.Control</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getShell shell} : string | sap.ui.unified.Shell</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.unified.ShellOverlay#event:closed closed} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ShellOverlay to be opened in front of a sap.ui.unified.Shell
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.3
 * @name sap.ui.unified.ShellOverlay
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.unified.ShellOverlay", { metadata : {

	library : "sap.ui.unified",
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
		"search" : {type : "sap.ui.core.Control", multiple : false}
	},
	associations : {
		"shell" : {type : "sap.ui.unified.Shell", multiple : false}
	},
	events : {
		"closed" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.unified.ShellOverlay with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.unified.ShellOverlay.extend
 * @function
 */

sap.ui.unified.ShellOverlay.M_EVENTS = {'closed':'closed'};


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content to appear in the overlay.
 * 
 * <strong>Note</strong>: this is the default aggregation for ShellOverlay.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.unified.ShellOverlay#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.unified.ShellOverlay#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.unified.ShellOverlay#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.unified.ShellOverlay#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>search</code>.<br/>
 * Experimental (This aggregation might change in future!): The search control which should be displayed in the overlay header.
 * 
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.ui.unified.ShellOverlay#getSearch
 * @function
 */


/**
 * Setter for the aggregated <code>search</code>.
 * @param {sap.ui.core.Control} oSearch
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#setSearch
 * @function
 */
	

/**
 * Destroys the search in the aggregation 
 * named <code>search</code>.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#destroySearch
 * @function
 */


/**
 * Reference to the sap.ui.unified.Shell control.
 *
 * @return {string} Id of the element which is the current target of the <code>shell</code> association, or null
 * @public
 * @name sap.ui.unified.ShellOverlay#getShell
 * @function
 */

/**
 * Reference to the sap.ui.unified.Shell control.
 *
 * @param {string | sap.ui.unified.Shell} vShell 
 *    Id of an element which becomes the new target of this <code>shell</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#setShell
 * @function
 */


	
/**
 * Fired when the overlay was closed.
 *
 * @name sap.ui.unified.ShellOverlay#closed
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'closed' event of this <code>sap.ui.unified.ShellOverlay</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.unified.ShellOverlay</code>.<br/> itself. 
 *  
 * Fired when the overlay was closed.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.unified.ShellOverlay</code>.<br/> itself.
 *
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#attachClosed
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'closed' event of this <code>sap.ui.unified.ShellOverlay</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.unified.ShellOverlay#detachClosed
 * @function
 */

/**
 * Fire event closed to attached listeners.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.unified.ShellOverlay} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.unified.ShellOverlay#fireClosed
 * @function
 */


// Start of sap\ui\unified\ShellOverlay.js
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained

jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained


jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained


/**** API ****/

/**
 * Opens the ShellOverlay.
 *
 * @public
 */
sap.ui.unified.ShellOverlay.prototype.open = function(){
	if(this._getPopup().isOpen()){
		return;
	}

	this._opening = true;
	this._forceShellHeaderVisible();
	this._getPopup().setModal(true, sap.ui.core.Popup.blStack.length == 0 && this._getAnimActive() ? "sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp" : "");
	this._getPopup().open(0, sap.ui.core.Popup.Dock.BeginTop, sap.ui.core.Popup.Dock.BeginTop, window, "0 0", "none");
	var oSearch = this.getSearch();
	if(oSearch){
		oSearch.focus();
	}
	this._opening = false;
	
	if(this._getAnimActive()){
		jQuery.sap.delayedCall(50, this, function(){
			jQuery.sap.byId("sap-ui-blocklayer-popup").toggleClass("sapUiUfdShellOvrlyBlyTp", false);
		});
	}
	
	jQuery.sap.delayedCall(this._getAnimDuration(true), this, function(){
		this.$().toggleClass("sapUiUfdShellOvrlyOpening", false);
	});
};

/**
 * Closes the ShellOverlay.
 *
 * @public
 */
sap.ui.unified.ShellOverlay.prototype.close = function(){
	if(!this._getPopup().isOpen()){
		return;
	}
	
	this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden", true).toggleClass("sapUiUfdShellOvrlyClosing", true);
	
	this._setSearchWidth();
	
	jQuery.sap.delayedCall(Math.max(this._getAnimDuration(false) - this._getBLAnimDuration(), 0), this, function(){
		var $Bl = jQuery.sap.byId("sap-ui-blocklayer-popup");
		if(sap.ui.core.Popup.blStack.length == 1 && this._getAnimActive() && $Bl.hasClass("sapUiUfdShellOvrlyBly")){
			$Bl.toggleClass("sapUiUfdShellOvrlyBlyTp", true);
		}
	});
	
	jQuery.sap.delayedCall(this._getAnimDuration(false), this, function(){
		this._getPopup().close(0);
		this.$().remove();
		this._forceShellHeaderVisible();
		this.fireClosed();
	});
};

sap.ui.unified.ShellOverlay.prototype.setShell = function(vShell){
	return this.setAssociation("shell", vShell, true);
};

sap.ui.unified.ShellOverlay.prototype.setSearch = function(oSearch){
	this.setAggregation("search", oSearch, true);
	if(!!this.getDomRef()){
		this._headRenderer.render();
	}
	return this;
};

sap.ui.unified.ShellOverlay.prototype.insertContent = function(oContent, iIndex) {
	var res = this.insertAggregation("content", oContent, iIndex, true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.addContent = function(oContent) {
	var res = this.addAggregation("content", oContent, true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.removeContent = function(vIndex) {
	var res = this.removeAggregation("content", vIndex, true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.removeAllContent = function() {
	var res = this.removeAllAggregation("content", true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};
sap.ui.unified.ShellOverlay.prototype.destroyContent = function() {
	var res = this.destroyAggregation("content", true);
	if(!!this.getDomRef()){
		this._contentRenderer.render();
	}
	return res;
};


/**** Private ****/

sap.ui.unified.ShellOverlay.prototype.init = function(){
	this._animOpenDuration = -1;
	this._animCloseDuration = -1;
	this._animBlockLayerDuration = -1;
	this._animation = sap.ui.getCore().getConfiguration().getAnimation();
	this._opening = false;
	
	var that = this;
	
	this._headRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-hdr-center", function(rm){
		sap.ui.unified.ShellOverlayRenderer.renderSearch(rm, that);
	});
	this._contentRenderer = new sap.ui.unified._ContentRenderer(this, this.getId()+"-cntnt", function(rm){
		sap.ui.unified.ShellOverlayRenderer.renderContent(rm, that);
	});
};

sap.ui.unified.ShellOverlay.prototype.exit = function(){
	if(this._popup){
		this._popup.close(0);
		this._popup.destroy();
		this._popup = null;
	}
	
	this._getPopup = function(){return null;};
	this._headRenderer.destroy();
	delete this._headRenderer;
	this._contentRenderer.destroy();
	delete this._contentRenderer;
};

sap.ui.unified.ShellOverlay.prototype.onAfterRendering = function(){
	if(this._opening){
		this._setSearchWidth();
	}
	
	jQuery.sap.delayedCall(10, this, function(){
		this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden", false);
		this.$("search").css("width", "");
	});
};

sap.ui.unified.ShellOverlay.prototype.onclick = function(oEvent){
	if(jQuery(oEvent.target).attr("id") === this.getId()+"-close"){
		this.close();
	}
};

sap.ui.unified.ShellOverlay.prototype.onThemeChanged = function(){
	this._animOpenDuration = -1;
	this._animCloseDuration = -1;
	this._animBlockLayerDuration = -1;
};


/**** Private Helpers ****/

sap.ui.unified.ShellOverlay.prototype._getAnimDurationThemeParam = function(sParam, bClearIfNotActive){
	var val = parseInt(sap.ui.core.theming.Parameters.get(sParam), 10);
	if(!this._getAnimActive() && bClearIfNotActive){
		val = 0;
	}
	return val;
};

sap.ui.unified.ShellOverlay.prototype._getAnimDuration = function(bOpen){
	if((bOpen && this._animOpenDuration == -1) || (!bOpen && this._animCloseDuration == -1)){
		var sTxt = bOpen ? "Open" : "Close";
		this["_anim"+sTxt+"Duration"] = this._getAnimDurationThemeParam("sapUiUfdShellOvrly"+sTxt+"AnimOverAll", true);
	}
	return bOpen ? this._animOpenDuration : this._animCloseDuration;
};

sap.ui.unified.ShellOverlay.prototype._getBLAnimDuration = function(){
	if(this._animBlockLayerDuration == -1){
		this._animBlockLayerDuration = this._getAnimDurationThemeParam("sapUiUfdShellOvrlyBlockLayerAnimDuration", true);
	}
	return this._animBlockLayerDuration;
};

sap.ui.unified.ShellOverlay.prototype._getAnimActive = function(){
	if(!this._animation || (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10)){
		return false;
	}
	return true;
};

sap.ui.unified.ShellOverlay.prototype._getPopup = function(){
	if(!this._popup){
		this._popup = new sap.ui.core.Popup(this, true, false, false);
		this._popup._applyPosition = function(oPosition) {
			this._$().css("left", "0").css("top", "0");
			this._oLastPosition = oPosition;
			this._oLastOfRect = jQuery(window).rect();
		};
		this._popup.attachOpened(function(){
			sap.ui.unified._iNumberOfOpenedShellOverlays++;
		});
		this._popup.attachClosed(function(){
			sap.ui.unified._iNumberOfOpenedShellOverlays--;
		});
	}
	return this._popup;
};

sap.ui.unified.ShellOverlay.prototype._getShell = function(){
	var sId = this.getShell();
	if(!sId){
		return;
	}
	var oShell = sap.ui.getCore().byId(sId);
	if(!oShell || !(oShell instanceof sap.ui.unified.Shell)){
		return;
	}
	return oShell;
};

sap.ui.unified.ShellOverlay.prototype._forceShellHeaderVisible = function(){
	var oShell = this._getShell();
	if(oShell){
		oShell._doShowHeader(true);
	}
};

sap.ui.unified.ShellOverlay.prototype._getSearchWidth = function(){
	var sShellId = this.getShell();
	if(!sShellId){
		return -1;
	}
	var $ShellSearchArea = jQuery.sap.byId(sShellId+"-hdr-center").children();
	if($ShellSearchArea.length){
		return $ShellSearchArea.width();
	}
	return -1;
};

sap.ui.unified.ShellOverlay.prototype._setSearchWidth = function(){
	var iWidth = this._getSearchWidth();
	if(iWidth <= 0){
		return;
	}
	
	var sWidth = iWidth+"px";
	
	if(sap.ui.Device.browser.safari){
		//Safari doesn't support width transition based on different units -> so px must be replaced by %
		var iTotalWidth = this.$("hdr-center").width();
		if(iTotalWidth > iWidth){
			sWidth = Math.round((iWidth*100)/iTotalWidth) + "%";
		}else{
			sWidth = "100%";
		}
	}
	
	this.$("search").css("width", sWidth);
};



}; // end of sap/ui/unified/ShellOverlay.js
