/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.ux3.NotificationBar");jQuery.sap.require("sap.ui.ux3.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.ux3.NotificationBar",{metadata:{publicMethods:["hasItems"],library:"sap.ui.ux3",properties:{"visibleStatus":{type:"sap.ui.ux3.NotificationBarStatus",group:"Misc",defaultValue:sap.ui.ux3.NotificationBarStatus.Default},"resizeEnabled":{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{"messageNotifier":{type:"sap.ui.core.Element",multiple:false},"notifiers":{type:"sap.ui.core.Element",multiple:true,singularName:"notifier"}},events:{"display":{},"resize":{}}}});sap.ui.ux3.NotificationBar.M_EVENTS={'display':'display','resize':'resize'};jQuery.sap.require("sap.ui.core.delegate.ItemNavigation");jQuery.sap.require("sap.ui.core.theming.Parameters");sap.ui.core.Control.extend("sap.ui.ux3.NotificationBar.NotifierView",{renderMessages:function(r){r.write("<div");r.writeAttribute("id",this.getId()+"-content");r.addClass("sapUiNotifierContent");r.writeClasses();r.write(">");var m=this.getMessages();var i=m.length-1;var f=true;for(;i>=0;i--){if(!f||(i==0&&m.length>1)){r.write("<div");r.addClass("sapUiNotificationBarCltSep");r.writeClasses();r.write(">");r.write("</div>")}else{f=false}var M=m[i];if(M._message&&M._message.getReadOnly()){M.addStyleClass("sapUiNotifierMessageReadOnly")}r.renderControl(M)}r.write("</div>")},metadata:{properties:{"title":"string","visibleItems":"int","renderMode":{type:"string",defaultValue:"callout"}},aggregations:{"messages":"sap.ui.ux3.NotificationBar.MessageView"}},init:function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3")},exit:function(){if(this._renderedControl){delete this._renderedControl}delete this._oResBundle},getTitle:function(){var t=this.getProperty("title");var c=this.getMessages().length;if(c>0){var k="NOTIBAR_NOTIFIER_VIEW_TITLE";t=this._oResBundle.getText(k,[t,c])}return t},renderer:function(r,c){r.write("<div");r.addClass("sapUiNotifierContainer");r.writeControlData(c);r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-title");r.addClass("sapUiNotifierTitle");r.writeClasses();r.write(">");r.writeEscaped(c.getTitle());r.write("</div>");if(c.getMessages().length>0){c.renderMessages(r)}r.write("</div>")},onAfterRendering:function(){var $=this.$("content");var a=$.children();var t=0,c=0;var v=this.getVisibleItems();for(var i=1;i<a.length;i++){var b=jQuery(a[i]);if(b.hasClass("sapUiNotifierMessage")){c++}var h=b.outerHeight(true);t+=h;if(c==v){t+=2;$.css("max-height",t)}}}});sap.ui.core.Control.extend("sap.ui.ux3.NotificationBar.MessageView",{metadata:{properties:{"text":"string","timestamp":"string","icon":"sap.ui.core.URI"}},renderer:function(r,c){var i=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapUiNotifierMessage");r.writeClasses();r.writeAttribute("tabindex","0");r.write(">");if(c.getIcon()){r.write("<div");r.writeAttribute("id",i+"-icon");r.addClass("sapUiNotifierMessageIcon");r.writeClasses();r.write(">");r.write("<img");r.writeAttribute("src",c.getIcon());r.write("/>");r.write("</div>")}r.write("<div");r.writeAttribute("id",i+"-text");r.addClass("sapUiNotifierMessageText");r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");r.write("<div");r.writeAttribute("id",i+"-timestamp");r.addClass("sapUiNotifierMessageTimestamp");r.writeClasses();r.write(">");r.writeEscaped(c.getTimestamp());r.write("</div>");r.write("</div>")},onclick:function(e){if(!this._message.getReadOnly()){var n=this._message.getParent();n.fireMessageSelected({message:this._message,notifier:n})}},onsapselect:function(e){this.onclick(e)},exit:function(e){if(this._message){delete this._message}}});(function(){var c=function(t){var i=t.hasItems();var j=t.getVisibleStatus();if(i&&j==="None"){return true}else if(!i&&j!=="None"){return true}else if(!i&&j!=="Min"){return true}else{return false}};var C=function(E){var j=E.getParameter("callout");switch(E.getParameter("type")){case"added":case"removed":var n=E.getParameter("notifier");if(this.getMessageNotifier()&&this.getMessageNotifier().getId()===n.getId()){var p=n.getMessages().concat(new Array());if(p.length>0){p.sort(sap.ui.core.Message.compareByType);var I=p.length-1;this._sSeverestMessageLevel=p[I].getLevel()}}if(c(this)){var q=this.hasItems();this.fireDisplay({show:q})}else{this.invalidate();if(E.getParameter("type")==="removed"){if(j.getContent().length>0){var N=j.getContent()[0];var M=E.getParameter("message");var t=N.getMessages();var u;for(var i=0;i<t.length;i++){u=t[i];if(M.getId()===u._message.getId()){u.destroy();j.rerender();j.adjustPosition();break}}}}}break;case"openCallout":j.destroyContent();var n=E.getParameter("notifier");n.destroyAggregation("views",true);var v=n.getId();var x=this.getMessageNotifier();if(x&&v===x.getId()){v+="-messageNotifierView"}else{v+="-messageView"}var y=new sap.ui.ux3.NotificationBar.NotifierView(v,{title:n.getTitle(),visibleItems:this._visibleItems});if(n._bEnableMessageSelect){y.addStyleClass("sapUiNotifierSelectable")}var z=n.getMessages();for(var i=0;i<z.length;i++){var V=f(z[i],n,this);y.addMessage(V)}n.addAggregation("views",y,true);j.addContent(y);break}};sap.ui.ux3.NotificationBar.HOVER_ITEM_HEIGHT=16;sap.ui.ux3.NotificationBar.prototype.init=function(){this._oItemNavigation=new sap.ui.core.delegate.ItemNavigation();this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._iCalloutWidth=parseInt(250);this._iCalloutHeight=parseInt(200);this._visibleItems=5;this._eventListener=jQuery.proxy(C,this);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._togglerPosition="50%";this._gapMessageArea="5";this._sSeverestMessageLevel=sap.ui.core.MessageType.None;jQuery(window).bind("resize",jQuery.proxy(o,this));this._proxyEnableMessageSelect=jQuery.proxy(e,this)};sap.ui.ux3.NotificationBar.prototype.exit=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;delete this._iCalloutWidth;delete this._iCalloutHeight;delete this._visibleItems;delete this._eventListener;if(this.getMessageNotifier()){var M=this.getMessageNotifier();M._oMessageArea.destroy();delete M._oMessageArea}delete this._resizeFrom;delete this._resizeTo;delete this._oResBundle;delete this._formerVisibleStatus;delete this._togglerPosition;delete this._gapMessageArea;delete this._isHovered;delete this._togglerClicked;delete this._sSeverestMessageLevel;jQuery(window).unbind("resize",o);delete this._proxyEnableMessageSelect};var f=function(M,n,N){var i=new sap.ui.ux3.NotificationBar.MessageView(n.getId()+"-messageView-"+M.getId(),{text:M.getText(),timestamp:M.getTimestamp()});i._message=M;if(n.sParentAggregationName=="messageNotifier"){if(N.getVisibleStatus()==sap.ui.ux3.NotificationBarStatus.Max){i.setIcon(M.getIcon()||M.getDefaultIcon("32x32"))}else{i.setIcon(M.getIcon()||M.getDefaultIcon())}}else{i.setIcon(M.getIcon())}return i};var r=function(t,n){n.attachEvent("_childControlCalling",t._eventListener,t)};var d=function(t,n){n.detachEvent("_childControlCalling",t._eventListener,t)};sap.ui.ux3.NotificationBar.prototype.addNotifier=function(n){if(n){var i=(this.getVisibleStatus()==sap.ui.ux3.NotificationBarStatus.None)?true:false;this.addAggregation("notifiers",n,i);r(this,n)}return this};sap.ui.ux3.NotificationBar.prototype.insertNotifier=function(n,i){if(n){this.insertAggregation("notifiers",n,i);r(this,n)}return this};sap.ui.ux3.NotificationBar.prototype.removeNotifier=function(n){var i=this.removeAggregation("notifiers",n);d(this,i);return i};sap.ui.ux3.NotificationBar.prototype.removeAllNotifiers=function(){var j=this.removeAllAggregation("notifiers");for(var i=0;i<j.length;i++){var n=j[i];d(this,n)}return j};sap.ui.ux3.NotificationBar.prototype.destroyNotifiers=function(){var j=this.getNotifiers();for(var i=0;i<j.length;i++){var n=j[i];d(this,n)}this.destroyAggregation("notifiers");return this};var e=function(E){var M=this.getMessageNotifier();if(M&&M.getId()===E.getParameter("notifier").getId()){M.invalidate()}};sap.ui.ux3.NotificationBar.prototype.setMessageNotifier=function(M){var i=this.getMessageNotifier();if(i){i._oMessageArea.destroy();delete i._oMessageArea;i.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);d(this,i)}this.setAggregation("messageNotifier",M);if(M){M._oMessageArea=new sap.ui.ux3.NotificationBar.MessageView(this.getId()+"-inplaceMessage");M._oMessageArea.setParent(M);M.attachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);r(this,M)}return this};sap.ui.ux3.NotificationBar.prototype.destroyMessageNotifier=function(M){var i=this.getMessageNotifier();if(i){i._oMessageArea.destroy();delete i._oMessageArea;i.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);d(this,i)}this.destroyAggregation("messageNotifier");return this};var s=function(t,i){var T=t.$();switch(i){case sap.ui.ux3.NotificationBarStatus.Min:T.addClass("sapUiNotificationBarMinimized");break;case sap.ui.ux3.NotificationBarStatus.Max:var j=t.getHeightOfStatus(t.getVisibleStatus());T.addClass("sapUiNotificationBarMaximized");T.css("height",j);var $=t.$("containers");$.css("max-height",j);break;case sap.ui.ux3.NotificationBarStatus.None:if(!t._resizeTo){T.css("display","none")}break;case sap.ui.ux3.NotificationBarStatus.Default:default:T.removeClass("sapUiNotificationBarMaximized");T.removeClass("sapUiNotificationBarMinimized");break}};var R=function(t){if(w(t)){var F=t.getHeightOfStatus(t._resizeFrom);var T=t.$();T.css("height",F);var j=t.getHeightOfStatus(t._resizeTo);T.stop(true,true).animate({height:j},"fast",function(){var n=t.getVisibleStatus();if(n==="None"){T.css("display","none");if(t.hasItems()){if(t.getMessageNotifier()){var M=t.getMessageNotifier();M.$().css("display","none")}if(t.getNotifiers().length>0){var N=t.getNotifiers();for(var i=0;i<N.length;i++){N[i].$().css("display","none")}}}}s(t,n);k(t,n)})}else{var n=t.getVisibleStatus();s(t,n)}delete t._resizeFrom;delete t._resizeTo};var S=function(t){if(t.getMessageNotifier()&&t.getMessageNotifier().hasItems()){var $=undefined;var I=t.getId()+"-notifiers";var j=jQuery.sap.byId(I);if(j.length>0){var T=parseInt(j.width());var n=j.children();for(var i=0;i<n.length;i++){var p=jQuery(n[i]);if(p.hasClass("sapUiNotifier")){T-=p.width()}else if(p.hasClass("sapUiNotifierSeparator")){T-=p.width()}else if(p.hasClass("sapUiInPlaceMessage")){$=p}}if($){T-=t._gapMessageArea+2;$.css("width",T+"px")}}}};var m=function(E){var i=jQuery(window).height();var n=E.data.notibar;var $=n.$("hoverItem");var j=E.clientY;var p=parseInt(j,10);var B=i-$.outerHeight();if(n._isHovered){if(p<B){var q=jQuery.proxy(H,n);$.on("mouseleave",q);window.setTimeout(function(){var t=jQuery.Event("mouseleave",{notibar:n});$.trigger(t);$.off("mouseleave",q)},100);delete n._isHovered}}else{if(p>=B){var q=jQuery.proxy(H,n);$.on("mouseenter",q);window.setTimeout(function(){var t=jQuery.Event("mouseenter",{notibar:n});$.trigger(t);$.off("mouseenter",q)},100);n._isHovered=true}}};var a=function(n){var $=jQuery(document);if(n.getVisibleStatus()==="Min"){$.on("mousemove",{notibar:n},m)}else{$.off("mousemove",m)}};sap.ui.ux3.NotificationBar.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());var I=[];var n=this.getVisibleStatus()===sap.ui.ux3.NotificationBarStatus.Max;if(n){var M=this.getMessageNotifier();if(M!=null){var p=M.getMessages();var q=M.getId()+"-messageNotifierView-messageView-";for(var i=p.length-1;i>=0;i--){var D=jQuery.sap.domById(q+p[i].getId());if(D){I.push(D)}}}var N=this.getNotifiers();for(var i=0;i<N.length;i++){var p=N[i].getMessages();var q=N[i].getId()+"-notifierView-messageView-";for(var j=p.length-1;j>=0;j--){var D=jQuery.sap.domById(q+p[j].getId());if(D){I.push(D)}}}}else{var N=this.getNotifiers();for(var i=0;i<N.length;i++){var D=N[i].getDomRef();if(D){I.push(D)}}var M=this.getMessageNotifier();if(M!=null){var D=M.getDomRef();if(D){I.push(D)}D=this.getDomRef("inplaceMessage");if(D&&jQuery(D).hasClass("sapUiInPlaceMessageSelectable")){I.push(D)}}}this._oItemNavigation.setItemDomRefs(I);R(this);S(this);b(this,this.getMessageNotifier());g(this);if(!!sap.ui.Device.browser.internet_explorer){a(this)}if(sap.ui.Device.browser.mobile){var $=this.$("toggler");if(this.getVisibleStatus()!==sap.ui.ux3.NotificationBarStatus.None){$.css("display","block")}else{$.css("display","none")}}};var b=function(t,M){if(M&&M.hasItems()){var $=M.$("counter");$.removeClass("sapUiMessageInformation");$.removeClass("sapUiMessageSuccess");$.removeClass("sapUiMessageWarning");$.removeClass("sapUiMessageError");var L=t._sSeverestMessageLevel;$.addClass("sapUiMessage"+L);var i=M.getMessages().length;var K="NOTIBAR_MESSAGE_NOTIFIER_DESC_LEVEL_"+L.toUpperCase()+(i===1?"_SING":"_PL");h(t,M,K,i)}};var g=function(t){var n=t.getNotifiers();for(var i=0;i<n.length;i++){var j=n[i].getMessages().length;var K="NOTIBAR_NOTIFIER_COUNT_TEXT_"+(j===1?"SING":"PL");h(t,n[i],K,j)}};var h=function(t,n,K,i){var $=n.$("description");var M=t._oResBundle.getText(K,[i]);$.html(M)};var H=function(E){var $=this.$("toggler");var D=($.css("display")==="block")?true:false;if(D){if(E.type==="mouseleave"){$.css("display","none")}}else{if(E.type==="mouseenter"){$.css("display","block")}}};var o=function(E){S(this)};var w=function(t){if(t._resizeFrom&&t._resizeTo){if(t._resizeFrom!=t._resizeTo){return true}}return false};sap.ui.ux3.NotificationBar.prototype.hasItems=function(){var n=this.getNotifiers();if(n.length>0){for(var i=0;i<n.length;i++){var N=n[i];if(N.hasItems()){return true}}}if(this.getMessageNotifier()){if(this.getMessageNotifier().hasItems()){return true}}return false};var k=function(n,t){var i="none";var N=n.$();switch(t){case sap.ui.ux3.NotificationBarStatus.Max:case sap.ui.ux3.NotificationBarStatus.None:break;case sap.ui.ux3.NotificationBarStatus.Min:N.stop().animate({height:n.getHeightOfStatus(t)},{duration:"fast",queue:true});N.addClass("sapUiNotificationBarMinimized");n.$("notifiers").css("display","none");i="block";break;default:case sap.ui.ux3.NotificationBarStatus.Default:N.stop().animate({height:n.getHeightOfStatus(t)},{duration:"fast",queue:true});N.removeClass("sapUiNotificationBarMaximized");N.removeClass("sapUiNotificationBarMinimized");break}var $=n.$("hoverItem");$.css("display",i)};sap.ui.ux3.NotificationBar.prototype.onfocusin=function(E){if(this._togglerClicked){delete this._togglerClicked;E.stopImmediatePropagation(true)}};sap.ui.ux3.NotificationBar.prototype.onclick=function(E){this._togglerClicked=true;this.$().blur();var $=jQuery(document.activeElement);l(this);var i=E.target.id;var j=i.split("-");if(j){var v=this.getVisibleStatus();var I=j.length-1;switch(j[I]){case"ArrowUp":if(v==="Min"){this.setVisibleStatus("Default")}else{this.setVisibleStatus("Max")}break;case"ArrowDown":if(v==="Max"){this.setVisibleStatus("Default")}else{this.setVisibleStatus("Min")}E.preventDefault();break;case"BarUp":if(this._formerVisibleStatus){this.setVisibleStatus(this._formerVisibleStatus)}else{this.setVisibleStatus("Default")}break;case"BarDown":this._formerVisibleStatus=v;this.setVisibleStatus("Min");$.blur();break;default:if($.hasClass("sapUiNotifier")){$.focus()}else{if(this.hasItems()){var n=this.getNotifiers();if(n.length>0){var p=jQuery(n[0]);p.focus()}else{var q=this.getMessageNotifier();if(q){jQuery(q).focus()}}}}break}}};sap.ui.ux3.NotificationBar.prototype.onThemeChanged=function(E){if(this.getDomRef()){this.invalidate()}};var l=function(t){var n=t.getNotifiers();for(var i=0;i<n.length;i++){var N=n[i];N._oCallout.close()}if(t.getMessageNotifier()){t.getMessageNotifier()._oCallout.close()}};sap.ui.ux3.NotificationBar.prototype.getHeightOfStatus=function(i){var p="";if(i==sap.ui.ux3.NotificationBarStatus.Min){p="sapUiNotificationBarHeightMinimized"}else if(i==sap.ui.ux3.NotificationBarStatus.Default){p="sapUiNotificationBarHeight"}else if(i==sap.ui.ux3.NotificationBarStatus.Max){p="sapUiNotificationBarHeightMaximized";p=sap.ui.core.theming.Parameters.get(p);var I=p.indexOf("%");if(I!=-1){var P=p.substring(0,I);var j=jQuery(window).height();j=parseInt(j/100*P);var _=parseInt(this.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default));if(j<_){j=_+1}}else{var M="No valid percantage value given for maximized size. 400px is used";jQuery.sap.log.warning(M);j=400}return j+"px"}else{return"0px"}p=sap.ui.core.theming.Parameters.get(p);return p};sap.ui.ux3.NotificationBar.prototype.setVisibleStatus=function(t){this._resizeFrom=this.getVisibleStatus();this._resizeTo=t;if(this._resizeFrom!==this._resizeTo){if(t===sap.ui.ux3.NotificationBarStatus.None){l(this);if(this.getDomRef()){k(this,t)}else{this.$().css({"height":"0px","display":"none"})}}this.setProperty("visibleStatus",t);this.fireResize({status:t})}}}());
