/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.Button");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.m.Button",{metadata:{library:"sap.m",properties:{"text":{type:"string",group:"Misc",defaultValue:null},"type":{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Default},"width":{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},"enabled":{type:"boolean",group:"Behavior",defaultValue:true},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"icon":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"iconFirst":{type:"boolean",group:"Appearance",defaultValue:true},"activeIcon":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"iconDensityAware":{type:"boolean",group:"Misc",defaultValue:true}},events:{"tap":{deprecated:true},"press":{}}}});sap.m.Button.M_EVENTS={'tap':'tap','press':'press'};jQuery.sap.require("sap.ui.core.EnabledPropagator");sap.ui.core.EnabledPropagator.call(sap.m.Button.prototype);jQuery.sap.require("sap.ui.core.theming.Parameters");jQuery.sap.require("sap.ui.core.IconPool");
sap.m.Button.prototype.exit=function(e){if(this._image){this._image.destroy()}if(this._iconBtn){this._iconBtn.destroy()}};
sap.m.Button.prototype.ontouchstart=function(e){e.setMarked();if(e.targetTouches.length===1){this._activeButton();this._target=e.target}};
sap.m.Button.prototype.ontouchend=function(e){this._inactiveButton()};
sap.m.Button.prototype.ontouchcancel=function(e){this._inactiveButton()};
sap.m.Button.prototype.ontap=function(e){e.setMarked();if(this.getEnabled()){if(!this._target){this._target=e.target}if((!!this._target)&&(this._target===e.target)){this.fireTap({});this.firePress({})}}delete this._target};
sap.m.Button.prototype.onkeydown=function(e){if(e.which===jQuery.sap.KeyCodes.SPACE||e.which===jQuery.sap.KeyCodes.ENTER){e.setMarked();this._activeButton();this._target=e.target}};
sap.m.Button.prototype.onkeyup=function(e){if(!this._target){return}this._target=null;if(e.which===jQuery.sap.KeyCodes.SPACE||e.which===jQuery.sap.KeyCodes.ENTER){e.setMarked();this._inactiveButton();this.firePress({})}};
sap.m.Button.prototype.onfocusout=function(e){this._inactiveButton()};
sap.m.Button.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive")}if(this.getEnabled()){if(this.getIcon()&&this.getActiveIcon()&&this._image instanceof sap.m.Image){this._image.setSrc(this.getActiveIcon())}}};
sap.m.Button.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive")}if(this.getEnabled()){if(this.getIcon()&&this.getActiveIcon()&&this._image instanceof sap.m.Image){this._image.setSrc(this.getIcon())}}};
sap.m.Button.prototype._isHoverable=function(){return this.getEnabled()&&sap.ui.Device.system.desktop};
sap.m.Button.prototype._getImage=function(i,s,a,I){if(this._image&&(this._image.getSrc()!==s)){this._image.destroy();this._image=undefined}var o=this._image;if(!!o){o.setSrc(s);if(o instanceof sap.m.Image){o.setActiveSrc(a);o.setDensityAware(I)}}else{o=sap.ui.core.IconPool.createControlByURI({id:i,src:s,activeSrc:a,densityAware:I},sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true)}o.addStyleClass("sapMBtnIcon");if(this.getText()){if(o.hasStyleClass("sapMBtnIconLeft")){o.removeStyleClass("sapMBtnIconLeft")}if(o.hasStyleClass("sapMBtnIconRight")){o.removeStyleClass("sapMBtnIconRight")}if(o.hasStyleClass("sapMBtnBackIconLeft")){o.removeStyleClass("sapMBtnBackIconLeft")}if(this.getIconFirst()){if(this.getType()===sap.m.ButtonType.Back||this.getType()===sap.m.ButtonType.Up){o.addStyleClass("sapMBtnBackIconLeft")}else{o.addStyleClass("sapMBtnIconLeft")}}else{o.addStyleClass("sapMBtnIconRight")}}return this._image=o};
sap.m.Button.prototype._getInternalIconBtn=function(i,s){var I=this._iconBtn;if(!!I){I.setSrc(s)}else{I=sap.ui.core.IconPool.createControlByURI(s,sap.m.Image)}I.addStyleClass("sapMBtnIcon");if(this.getText()){I.addStyleClass("sapMBtnIconLeft")}return this._iconBtn=I};
sap.m.Button.prototype._isUnstyled=function(){var u=false;if(this.getType()===sap.m.ButtonType.Unstyled){u=true}return u};
sap.m.Button.prototype.setText=function(t){var v=this.getText();if(t===null||t===undefined){t=""}if(v!==t){var d=this.getDomRef("content");var s=!!d;this.setProperty("text",t,s);if(s){t=this.getText();d.innerHTML=jQuery.sap.escapeHTML(t);if(this.getIcon()){d=this.getDomRef("inner");this._removeTextPadding();if(t.length>0){this._addTextPadding(this.getIconFirst())}if(this.$().hasClass("sapMBtnBack")){this.$().removeClass("sapMBtnBack")}if((this.getType()===sap.m.ButtonType.Back||this.getType()===sap.m.ButtonType.Up)&&this.getIcon()&&!this.getText()){this.$().addClass("sapMBtnBack")}}}}return this};
sap.m.Button.prototype.setIcon=function(i){var v=this.getIcon();if(i===null||i===undefined){i=""}if(v!==i){var d=this.getDomRef("img");var s=!!d;if(sap.ui.core.IconPool.isIconURI(i)===sap.ui.core.IconPool.isIconURI(v)){s=true}else{s=false}if(i.length===0){s=false}this.setProperty("icon",i,s);if(s&&this._image){this._image.setSrc(i)}}return this};
sap.m.Button.prototype.setIconFirst=function(i){var v=this.getIconFirst();if(v!==i){var d=this.getDomRef("img");var s=!!d;this.setProperty("iconFirst",i,s);if(s){if(this.getText()){if(this.$("img").hasClass("sapMBtnIconLeft")){this.$("img").removeClass("sapMBtnIconLeft")}if(this.$("img").hasClass("sapMBtnIconRight")){this.$("img").removeClass("sapMBtnIconRight")}if(this.$("img").hasClass("sapMBtnBackIconLeft")){this.$("img").removeClass("sapMBtnBackIconLeft")}if(this.$("content").hasClass("sapMBtnContentLeft")){this.$("content").removeClass("sapMBtnContentLeft")}if(this.$("content").hasClass("sapMBtnContentRight")){this.$("content").removeClass("sapMBtnContentRight")}if(this.$("content").hasClass("sapMBtnBackContentRight")){this.$("content").removeClass("sapMBtnBackContentRight")}if(i){if(this.getType()===sap.m.ButtonType.Back||this.getType()===sap.m.ButtonType.Up){this.$("img").addClass("sapMBtnBackIconLeft");this.$("content").addClass("sapMBtnBackContentRight")}else{this.$("img").addClass("sapMBtnIconLeft");this.$("content").addClass("sapMBtnContentRight")}}else{if(this.getType()===sap.m.ButtonType.Back||this.getType()===sap.m.ButtonType.Up){this.$("content").addClass("sapMBtnContentRight")}else{this.$("content").addClass("sapMBtnContentLeft")}this.$("img").addClass("sapMBtnIconRight")}}this._removeTextPadding();if(this.getText().length>0){this._addTextPadding(i)}}}return this};
sap.m.Button.prototype._removeTextPadding=function(){if(this.$("inner").hasClass("sapMBtnPaddingLeft")){this.$("inner").removeClass("sapMBtnPaddingLeft")}else if(this.$("inner").hasClass("sapMBtnPaddingRight")){this.$("inner").removeClass("sapMBtnPaddingRight")}if(!this.getText()){if(this.$("content").hasClass("sapMBtnContentLeft")){this.$("content").removeClass("sapMBtnContentLeft")}if(this.$("content").hasClass("sapMBtnContentRight")){this.$("content").removeClass("sapMBtnContentRight")}if(this.$("content").hasClass("sapMBtnBackContentRight")){this.$("content").removeClass("sapMBtnBackContentRight")}}};
sap.m.Button.prototype._addTextPadding=function(i){var t=this.getType();if(i){this.$("inner").addClass("sapMBtnPaddingRight")}else{if(t!=sap.m.ButtonType.Back&&t!=sap.m.ButtonType.Up){this.$("inner").addClass("sapMBtnPaddingLeft")}}if(this.getText()){if(this.getIcon()){if(this.getIconFirst()){if(this.getType()===sap.m.ButtonType.Back||this.getType()===sap.m.ButtonType.Up){this.$("content").addClass("sapMBtnBackContentRight")}else{this.$("content").addClass("sapMBtnContentRight")}}else{if(this.getType()===sap.m.ButtonType.Back||this.getType()===sap.m.ButtonType.Up){this.$("content").addClass("sapMBtnContentRight")}this.$("content").addClass("sapMBtnContentLeft")}}else{if(this.getType()===sap.m.ButtonType.Back||this.getType()===sap.m.ButtonType.Up){this.$("content").addClass("sapMBtnContentRight")}}}};
sap.m.Button.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner")};
