/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.ComboBox");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.m.ComboBoxBase");sap.m.ComboBoxBase.extend("sap.m.ComboBox",{metadata:{library:"sap.m",properties:{"selectedKey":{type:"string",group:"Data",defaultValue:null},"selectedItemId":{type:"string",group:"Misc",defaultValue:null}},associations:{"selectedItem":{type:"sap.ui.core.Item",multiple:false}},events:{"selectionChange":{}}}});sap.m.ComboBox.M_EVENTS={'selectionChange':'selectionChange'};jQuery.sap.require("sap.m.ComboBoxRenderer");
sap.m.ComboBox.prototype._getSelectedListItem=function(){var i=this.getSelectedItem();return(i&&i.data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"ListItem"))||null};
sap.m.ComboBox.prototype.updateItems=function(r){this._bDataAvailable=false;this.updateAggregation("items");this._bDataAvailable=true};
sap.m.ComboBox.prototype.refreshItems=function(){this.refreshAggregation("items")};
sap.m.ComboBox.prototype._createPopover=function(){var p=new sap.m.Popover({showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0,initialFocus:this,bounce:false});this._decoratePopover(p);return p};
sap.m.ComboBox.prototype._decoratePopover=function(p){var s=this;p._removeArrow=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"]};p._setPosition=function(){this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"]};p._setArrowPosition=function(){};p.open=function(){return this.openBy(s.getFocusDomRef())}};
sap.m.ComboBox.prototype.onAfterRenderingPopover=function(){var p=this.getPicker();p._removeArrow();p._setPosition()};
sap.m.ComboBox.prototype._createDialog=function(){var C=sap.m.ComboBoxBaseRenderer.CSS_CLASS;var d=new sap.m.Dialog({stretchOnPhone:true,customHeader:new sap.m.Bar({contentLeft:new sap.m.InputBase({value:this.getSelectedItem().getText(),width:"100%",editable:false}).addStyleClass(C+"Input")}).addStyleClass(C+"Bar")});d.getAggregation("customHeader").attachBrowserEvent("tap",function(){d.close()},this);return d};
sap.m.ComboBox.prototype.onBeforeOpenDialog=function(){var h=this.getPicker().getCustomHeader();h.getContentLeft()[0].setValue(this.getSelectedItem().getText())};
sap.m.ComboBox.prototype.onBeforeRendering=function(){sap.m.ComboBoxBase.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();this._clearList();this._fillList(this.getItems())};
sap.m.ComboBox.prototype.oninput=function(e){sap.m.ComboBoxBase.prototype.oninput.apply(this,arguments);var C=sap.m.ComboBoxBaseRenderer.CSS_CLASS,s=this.getSelectedItem(),I=this.getItems(),o=e.target,v=o.value,f=true,a,m,l,i=0;if(I.length){this.open()}if(!this.isAllowedSubstringValue(v)){v=v.substr(0,v.length-1);this.updateDomValue(v)}if(v===""){this.setSelection(null,{suppressInvalidate:true});if(s!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()})}}for(;i<I.length;i++){a=I[i];m=jQuery.sap.startsWithIgnoreCase(a.getText(),v);l=a.data(C+"ListItem");if(v===""){m=true}l.setVisible(m);if(f&&m&&v!==""){f=false;if(this._bDoTypeAhead){this.updateDomValue(a.getText())}this.setSelection(a,{suppressInvalidate:true});if(s!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()})}if(this._bDoTypeAhead){this.selectText(v.length,9999999)}this.scrollToItem(this.getList().getSelectedItem())}}};
sap.m.ComboBox.prototype.onSelectionChange=function(c){var l=c.getParameter("listItem"),n=this._findMappedItem(l),v;if((l.getType()==="Inactive")||!this.getEnabled()||!this.getEditable()){return}if(n){this.updateDomValue(n.getText());this.setSelection(n,{suppressInvalidate:true,listItemUpdated:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});v=this.getValue();jQuery.sap.delayedCall(0,this,"selectText",[v.length,v.length])}};
sap.m.ComboBox.prototype.onItemPress=function(){this.close()};
sap.m.ComboBox.prototype.onkeydown=function(e){sap.m.ComboBoxBase.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();var k=jQuery.sap.KeyCodes;this._bDoTypeAhead=(e.which!==k.BACKSPACE)&&(e.which!==k.DELETE)};
sap.m.ComboBox.prototype.oncut=function(e){sap.m.ComboBoxBase.prototype.oncut.apply(this,arguments);this._bDoTypeAhead=false};
sap.m.ComboBox.prototype.onsapenter=function(e){sap.m.ComboBoxBase.prototype.onsapenter.apply(this,arguments);e.setMarked();if(!this.getEnabled()||!this.getEditable()){return}var v=this.getFocusDomRef().value;this.setValue(v);this.selectText(v.length,v.length);if(this.isOpen()){this.close()}};
sap.m.ComboBox.prototype.onsapdown=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();var n,s=this.getSelectableItems();n=s[s.indexOf(this.getSelectedItem())+1];if(n){this.updateDomValue(n.getText());this.setSelection(n,{suppressInvalidate:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});this.selectText(0,this.getFocusDomRef().value.length)}this.scrollToItem(this.getList().getSelectedItem())};
sap.m.ComboBox.prototype.onsapup=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();var p,s=this.getSelectableItems();p=s[s.indexOf(this.getSelectedItem())-1];if(p){this.updateDomValue(p.getText());this.setSelection(p,{suppressInvalidate:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});this.selectText(0,this.getFocusDomRef().value.length)}this.scrollToItem(this.getList().getSelectedItem())};
sap.m.ComboBox.prototype.onsaphome=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();var f=this.getSelectableItems()[0];if(f&&(f!==this.getSelectedItem())){this.updateDomValue(f.getText());this.setSelection(f,{suppressInvalidate:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});this.selectText(0,this.getFocusDomRef().value.length)}this.scrollToItem(this.getList().getSelectedItem())};
sap.m.ComboBox.prototype.onsapend=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();var l=this.findLastEnabledItem(this.getSelectableItems());if(l&&(l!==this.getSelectedItem())){this.updateDomValue(l.getText());this.setSelection(l,{suppressInvalidate:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});this.selectText(0,this.getFocusDomRef().value.length)}this.scrollToItem(this.getList().getSelectedItem())};
sap.m.ComboBox.prototype.onsappagedown=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();var s=this.getSelectableItems(),i=s.indexOf(this.getSelectedItem())+20,I;i=(i>s.length-1)?s.length-1:Math.max(0,i);I=s[i];if(I&&(I!==this.getSelectedItem())){this.updateDomValue(I.getText());this.setSelection(I,{suppressInvalidate:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});this.selectText(0,this.getFocusDomRef().value.length)}this.scrollToItem(this.getList().getSelectedItem())};
sap.m.ComboBox.prototype.onsappageup=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();var s=this.getSelectableItems(),i=s.indexOf(this.getSelectedItem())-20,I;i=(i>s.length-1)?s.length-1:Math.max(0,i);I=s[i];if(I&&(I!==this.getSelectedItem())){this.updateDomValue(I.getText());this.setSelection(I,{suppressInvalidate:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});this.selectText(0,this.getFocusDomRef().value.length)}this.scrollToItem(this.getList().getSelectedItem())};
sap.m.ComboBox.prototype.onfocusin=function(e){if(e.target===this.getOpenArea()){this.focus()}else{jQuery.sap.delayedCall(0,this,function(){if(document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length)}})}};
sap.m.ComboBox.prototype.onsapfocusleave=function(e){var p=this.getAggregation("picker");if(!e.relatedControlId||!p){return}var c=sap.ui.getCore().byId(e.relatedControlId),f=c&&c.getFocusDomRef();if(jQuery.sap.containsOrEquals(p.getFocusDomRef(),f)){if(sap.ui.Device.system.desktop){this.focus()}}};
sap.m.ComboBox.prototype.setSelection=function(i,o){var l;o=o||{};this.setAssociation("selectedItem",i||null,o.suppressInvalidate);this.setProperty("selectedItemId",i?i.getId():"",o.suppressInvalidate);this.setProperty("selectedKey",i?i.getKey():"",o.suppressInvalidate);if(!o.listItemUpdated){l=this._getSelectedListItem();if(l){this.getList().setSelectedItem(l,true)}else if(this.getList()){if(this.getDefaultSelectedItem()){this.getList().setSelectedItem(this.getDefaultSelectedItem().data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"ListItem"),true)}else if(this.getList().getSelectedItem()){this.getList().setSelectedItem(this.getList().getSelectedItem(),false)}}}};
sap.m.ComboBox.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey())};
sap.m.ComboBox.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText())}}else if(!this.isBound("items")||this._bDataAvailable){i=this.getDefaultSelectedItem();this.setSelection(i,{suppressInvalidate:true})}};
sap.m.ComboBox.prototype.createPicker=function(p){var P=this.getAggregation("picker");if(P){return P}P=this["_create"+p]();this.setAggregation("picker",P,true);P.setHorizontalScrolling(false).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Picker").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return P};
sap.m.ComboBox.prototype.createList=function(){this._oList=new sap.m.List({width:"100%",mode:sap.m.ListMode.SingleSelectMaster,rememberSelections:false}).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"List").attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this)};
sap.m.ComboBox.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this)};
sap.m.ComboBox.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this)};
sap.m.ComboBox.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()];this.addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Pressed");this.addContent();p&&p.call(this)};
sap.m.ComboBox.prototype.onBeforeOpenPopover=function(){var d=this.getDomRef(),c=window.getComputedStyle(d);if(c){this.getPicker().setContentWidth((parseFloat(c.width)/parseFloat(sap.m.BaseFontSize))+"rem")}};
sap.m.ComboBox.prototype.onAfterOpen=function(){};
sap.m.ComboBox.prototype.onBeforeClose=function(){};
sap.m.ComboBox.prototype.onAfterClose=function(){this.removeStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Pressed");this.clearFilter()};
sap.m.ComboBox.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"))};
sap.m.ComboBox.prototype.getDefaultSelectedItem=function(){return this.getForceSelection()?this.findFirstEnabledItem():null};
sap.m.ComboBox.prototype.isAllowedSubstringValue=function(v){if(!this.getForceSelection()){return true}return this.getItems().some(function(i){return jQuery.sap.startsWithIgnoreCase(i.getText(),v)})};
sap.m.ComboBox.prototype.clearSelection=function(){this.setSelection(null)};
sap.m.ComboBox.prototype.selectText=function(s,S){sap.m.ComboBoxBase.prototype.selectText.apply(this,arguments);this.textSelectionStart=s;this.textSelectionEnd=S;return this};
sap.m.ComboBox.prototype.setValue=function(v,s){if(!s&&this.getForceSelection()&&!this.getItemByText(v)){return this}sap.m.ComboBoxBase.prototype.setValue.call(this,v);return this};
sap.m.ComboBox.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i)}if(!(i instanceof sap.ui.core.Item)&&i!==null){jQuery.sap.log.warning('Warning: setSelectedItem() "vItem" has to be an instance of sap.ui.core.Item, a valid sap.ui.core.Item id, or null on',this);return this}if(!i){i=this.getDefaultSelectedItem()}this.setSelection(i,{suppressInvalidate:true});this.setValue(i?i.getText():((i=this.getDefaultSelectedItem())?i.getText():""),true);return this};
sap.m.ComboBox.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);var I=sap.ui.getCore().byId(i);if(!(I instanceof sap.ui.core.Item)&&i!==""){jQuery.sap.log.warning('Warning: setSelectedItemId() "sItem" has to be a string id of an sap.ui.core.Item instance, an empty string or undefined on',this);return this}if(!I){I=this.getDefaultSelectedItem()}this.setSelection(I,{suppressInvalidate:true});this.setValue(I?I.getText():((I=this.getDefaultSelectedItem())?I.getText():""),true);return this};
sap.m.ComboBox.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var i=this.getItemByKey(k);if(i||(k==="")){if(!i&&k===""){i=this.getDefaultSelectedItem()}this.setSelection(i,{suppressInvalidate:true});this.setValue(i?i.getText():((i=this.getDefaultSelectedItem())?i.getText():""),true);return this}this._sValue=this.getValue();return this.setProperty("selectedKey",k)};
sap.m.ComboBox.prototype.getSelectedItem=function(){var s=this.getAssociation("selectedItem");return(s===null)?null:sap.ui.getCore().byId(s)||null};
sap.m.ComboBox.prototype.removeItem=function(i){i=sap.m.ComboBoxBase.prototype.removeItem.call(this,i);var v=this.getValue(),I;if(this.getItems().length===0){this.clearSelection();if(this.getForceSelection()){this.setValue("",true)}}else if(this.isItemSelected(i)){I=this.getDefaultSelectedItem();this.setSelection(I);if(this.getForceSelection()){v=I?I.getText():""}this.setValue(v)}return i};
sap.m.ComboBox.prototype.removeAllItems=function(){var i=sap.m.ComboBoxBase.prototype.removeAllItems.call(this);if(this.getForceSelection()){this.setValue("",true)}return i};
sap.m.ComboBox.prototype.getForceSelection=function(){return false};
sap.m.ComboBox.prototype.setForceSelection=function(){};
