/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.MultiComboBox");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.m.ComboBoxBase");sap.m.ComboBoxBase.extend("sap.m.MultiComboBox",{metadata:{publicMethods:["addSelectedKeys","removeSelectedKeys"],library:"sap.m",properties:{"selectedKeys":{type:"string[]",group:"Data",defaultValue:null}},associations:{"selectedItems":{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{"selectionChange":{},"selectionFinish":{}}}});sap.m.MultiComboBox.M_EVENTS={'selectionChange':'selectionChange','selectionFinish':'selectionFinish'};jQuery.sap.require("sap.ui.core.EnabledPropagator");jQuery.sap.require("sap.m.MultiComboBoxRenderer");jQuery.sap.require("sap.m.Bar");jQuery.sap.require("sap.m.List");jQuery.sap.require("sap.m.Popover");jQuery.sap.require("sap.m.Dialog");jQuery.sap.require("sap.ui.core.IconPool");jQuery.sap.require("jquery.sap.xml");sap.ui.core.IconPool.insertFontFaceStyle();sap.ui.core.EnabledPropagator.apply(sap.m.MultiComboBox.prototype,[true]);
sap.m.MultiComboBox.prototype.onsapend=function(e){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments)};
sap.m.MultiComboBox.prototype.onsaphome=function(e){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments)};
sap.m.MultiComboBox.prototype.onsapdown=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();var i=this.getSelectableItems();var I=i[0];if(I&&this.isOpen()){this.getListItem(I).focus();return}if(this._oTokenizer.getSelectedTokens().length){return}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length)}this._setContainerSizes()};
sap.m.MultiComboBox.prototype.onsapup=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length)}this._setContainerSizes()};
sap.m.MultiComboBox.prototype.onsapenter=function(e){sap.m.ComboBoxBase.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();var v;if(this.isOpen()){v=this.getSelectableItems()}else{v=this._getItemsStartingText(this.getValue())}if(v.length>1){this._showWrongValueVisualEffect()}if(v.length===1){var i=v[0];var p={item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};if(this.getValue()===""||jQuery.sap.startsWithIgnoreCase(i.getText(),this.getValue())){if(this.getListItem(i).isSelected()){this.setValue('')}else{this.setSelection(p)}}}this.close()};
sap.m.MultiComboBox.prototype.onsapfocusleave=function(e){var p=this.getAggregation("picker");var c=sap.ui.getCore().byId(e.relatedControlId);var f=c&&c.getFocusDomRef();if(p&&f){if(jQuery.sap.equal(p.getFocusDomRef(),f)){this.focus()}}this._setContainerSizes()};
sap.m.MultiComboBox.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef("border")};
sap.m.MultiComboBox.prototype.onfocusin=function(e){this.addStyleClass(sap.m.MultiComboBoxRenderer.CSS_CLASS+"Focused");if(e.target===this.getOpenArea()){this.focus()}};
sap.m.MultiComboBox.prototype.onsapescape=function(e){sap.m.ComboBoxBase.prototype.onsapescape.apply(this,arguments);this._setContainerSizes()};
sap.m.MultiComboBox.prototype._handleItemTap=function(e){if(e.target.childElementCount===0||e.target.childElementCount===2){if(this.isOpen()&&!this._isListInSuggestMode()){this.close()}}};
sap.m.MultiComboBox.prototype._handleItemPress=function(e){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){this.clearFilter();var i=this._getLastSelectedItem();if(i){this.getListItem(i).focus()}return}};
sap.m.MultiComboBox.prototype._handleSelectionLiveChange=function(e){var l=e.getParameter("listItem");var i=e.getParameter("selected");var n=this._getItemByListItem(l);if(l.getType()==="Inactive"){return}if(!n){return}var p={item:n,id:n.getId(),key:n.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(i){this.fireChangeEvent(n.getText());this.setSelection(p)}else{this.fireChangeEvent(n.getText());this.removeSelection(p);this.setValue('')}if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){l.focus()}};
sap.m.MultiComboBox.prototype.onkeydown=function(e){sap.m.ComboBoxBase.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return}if(this.getValue().length===0&&(e.ctrlKey||e.metaKey)&&(e.which===jQuery.sap.KeyCodes.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);e.preventDefault()}};
sap.m.MultiComboBox.prototype.oninput=function(e){sap.m.ComboBoxBase.prototype.oninput.apply(this,arguments);var v=e.target.value;if(!this.getEnabled()||!this.getEditable()){return}var i=this._getItemsStartingText(v);var V=!!i.length;if(!V&&v!==""){this.updateDomValue(this._sOldValue||"");if(this._iOldCursorPos){jQuery(this.getFocusDomRef()).cursorPos(this._iOldCursorPos)}this._showWrongValueVisualEffect();return}this.getSelectableItems().forEach(function(I){var m=jQuery.sap.startsWithIgnoreCase(I.getText(),v);if(v===""){m=true}var l=this.getListItem(I);if(l){l.setVisible(m)}},this);this._setContainerSizes();if(this.getValue()===""||!V){this.close()}else{this.open()}};
sap.m.MultiComboBox.prototype.onkeyup=function(e){if(!this.getEnabled()||!this.getEditable()){return}this._sOldValue=this.getValue();this._iOldCursorPos=jQuery(this.getFocusDomRef()).cursorPos()};
sap.m.MultiComboBox.prototype._showWrongValueVisualEffect=function(){var v=this.getValueState();if(v===sap.ui.core.ValueState.Error||v===sap.ui.core.ValueState.Success||v===sap.ui.core.ValueState.Warning){this.$().removeClass("sapMInputBase"+v);jQuery.sap.delayedCall(300,this.$(),"addClass",["sapMInputBase"+v])}else{this.$().addClass("sapMInputBaseError");jQuery.sap.delayedCall(300,this.$(),"removeClass",["sapMInputBaseError"])}};
sap.m.MultiComboBox.prototype.createPicker=function(p){var P=this.getAggregation("picker");if(P){return P}P=this["_create"+p]();this.setAggregation("picker",P,true);P.setHorizontalScrolling(false).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Picker").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return P};
sap.m.MultiComboBox.prototype.onBeforeRendering=function(){sap.m.ComboBoxBase.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();this._synchronizeSelectedItemAndKey(i);this._clearList();this._clearTokenizer();this._fillList(i)};
sap.m.MultiComboBox.prototype.onBeforeRenderingPicker=function(){var o=this["_onBeforeRendering"+this.getPickerType()];if(o){o.call(this)}};
sap.m.MultiComboBox.prototype.onAfterRenderingPicker=function(){var o=this["_onAfterRendering"+this.getPickerType()];if(o){o.call(this)}};
sap.m.MultiComboBox.prototype.onBeforeOpen=function(){var p=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Pressed");this._resetCurrentItem();this.addContent();if(p){p.call(this)}};
sap.m.MultiComboBox.prototype.onAfterOpen=function(){};
sap.m.MultiComboBox.prototype.onBeforeClose=function(){};
sap.m.MultiComboBox.prototype.onAfterClose=function(){this.removeStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Pressed");this.clearFilter();this.fireSelectionFinish({selectedItems:this.getSelectedItems()})};
sap.m.MultiComboBox.prototype._onBeforeOpenDialog=function(){};
sap.m.MultiComboBox.prototype._onBeforeOpenPopover=function(){var d=this.getDomRef();var c=window.getComputedStyle(d);if(c){this.getPicker().setContentWidth((parseFloat(c.width)/parseFloat(sap.m.BaseFontSize))+"rem")}};
sap.m.MultiComboBox.prototype._createDialog=function(){var d=new sap.m.Dialog({stretchOnPhone:true,customHeader:new sap.m.Bar({contentLeft:new sap.m.InputBase({width:"100%",editable:false}).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Input")}).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Bar")});d.getAggregation("customHeader").attachBrowserEvent("tap",function(){d.close()},this);return d};
sap.m.MultiComboBox.prototype._onAfterRenderingPopover=function(){var p=this.getPicker();p._removeArrow();p._setPosition()};
sap.m.MultiComboBox.prototype._decoratePopover=function(p){var t=this;p._removeArrow=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"]};p._setPosition=function(){this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"]};p._setArrowPosition=function(){};p.open=function(){var d=jQuery(t.getDomRef());var b=d.find(sap.m.MultiComboBoxRenderer.DOT_CSS_CLASS+"Border");return this.openBy(b[0])}};
sap.m.MultiComboBox.prototype._createPopover=function(){var p=new sap.m.Popover({showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0,initialFocus:this,bounce:false});this._decoratePopover(p);return p};
sap.m.MultiComboBox.prototype.createList=function(){this._oList=new sap.m.List({width:"100%",mode:sap.m.ListMode.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"List").addStyleClass(sap.m.MultiComboBoxRenderer.CSS_CLASS+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this)};
sap.m.MultiComboBox.prototype.setSelection=function(o){if(o.item&&this.isItemSelected(o.item)){return}if(!o.item){return}this.addAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),true)}var t=new sap.m.Token({key:o.key,text:o.item.getText(),tooltip:o.item.getText()});o.item.data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Token",t);this._oTokenizer.addToken(t);this.addStyleClass("sapMMultiComboBoxHasToken");this.setValue('');if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:true})}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()})}}};
sap.m.MultiComboBox.prototype.removeSelection=function(o){if(o.item&&!this.isItemSelected(o.item)){return}if(!o.item){return}this.removeAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),false)}if(!o.tokenUpdated){var t=this._getTokenByItem(o.item);o.item.data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Token",null);this._oTokenizer.removeToken(t)}if(!this._hasTokens()){this.removeStyleClass("sapMMultiComboBoxHasToken")}if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:false})}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()})}}};
sap.m.MultiComboBox.prototype._synchronizeSelectedItemAndKey=function(I){if(!I.length){jQuery.sap.log.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return}var s=this.getSelectedKeys();var k=this.getKeys(this.getSelectedItems());if(s.length){for(var i=0,K=null,o=null,a=null,l=s.length;i<l;i++){K=s[i];if(k.indexOf(K)>-1){if(this._aCustomerKeys.length&&(a=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(a,1)}continue}o=this.getItemByKey(""+K);if(o){if(this._aCustomerKeys.length&&(a=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(a,1)}this.setSelection({item:o,id:o.getId(),key:o.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false})}}return}};
sap.m.MultiComboBox.prototype._setContainerSizes=function(){var d=this.getDomRef();if(!d){return}var m=jQuery(d);var s=jQuery(m.children(sap.m.MultiComboBoxRenderer.DOT_CSS_CLASS+"ShadowDiv")[0]);s.text(this.getValue());var i=jQuery(m.find(sap.m.MultiComboBoxRenderer.DOT_CSS_CLASS+"InputContainer")[0]);var t=this._oTokenizer.getScrollWidth();var I=s.outerWidth();var a=this.$().find(".sapMMultiComboBoxBorder").width();if(a!==0){var b=jQuery(this.getOpenArea()).outerWidth(true);var T=t+I+b;var c;if(T<a){c=I+a-T}else{c=I;t=a-c-b}var w=(c/parseFloat(sap.m.BaseFontSize))+"rem";jQuery(i.find(".sapMInputBaseInner")[0]).css("width",w);this._oTokenizer.setPixelWidth(t)}};
sap.m.MultiComboBox.prototype._getTokenByItem=function(i){return i?i.data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Token"):null};
sap.m.MultiComboBox.prototype._getSelectedItemsOf=function(I){for(var i=0,l=I.length,s=[];i<l;i++){if(this.getListItem(I[i]).isSelected()){s.push(I[i])}}return s};
sap.m.MultiComboBox.prototype._getPlaceholder=function(c){if(this._hasTokens()){return""}return this.getPlaceholder()};
sap.m.MultiComboBox.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var T=t.length?t[t.length-1]:null;if(!T){return null}return this._getItemByToken(T)};
sap.m.MultiComboBox.prototype._getOrderedSelectedItems=function(){var I=[];for(var i=0,t=this._oTokenizer.getTokens(),l=t.length;i<l;i++){I[i]=this._getItemByToken(t[i])}return I};
sap.m.MultiComboBox.prototype._getFocusedListItem=function(){var f=jQuery(':focus');var F=sap.ui.getCore().byId(f.attr('id'));if(this.getList()&&F&&jQuery.sap.containsOrEquals(this.getList().getFocusDomRef(),F.getFocusDomRef())){return F}return null};
sap.m.MultiComboBox.prototype._getFocusedItem=function(){var l=this._getFocusedListItem();return this._getItemByListItem(l)};
sap.m.MultiComboBox.prototype._isRangeSelectionSet=function(l){var L=l.getDomRef();return L.indexOf(sap.m.MultiComboBoxRenderer.CSS_CLASS+"ItemRangeSelection")>-1?true:false};
sap.m.MultiComboBox.prototype._hasTokens=function(){if(this._oTokenizer.getTokens().length){return true}return false};
sap.m.MultiComboBox.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem()}return this._oCurrentItem};
sap.m.MultiComboBox.prototype._setCurrentItem=function(i){this._oCurrentItem=i};
sap.m.MultiComboBox.prototype._resetCurrentItem=function(){this._oCurrentItem=null};
sap.m.MultiComboBox.prototype._decorateListItem=function(l){l.addDelegate({onkeyup:function(e){var i=null;if(e.which==jQuery.sap.KeyCodes.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.clearFilter();this.open();i=this._getLastSelectedItem();if(i){this.getListItem(i).focus()}return}},onkeydown:function(e){var i=null,I=null;if(e.shiftKey&&e.which==jQuery.sap.KeyCodes.ARROW_DOWN){I=this._getCurrentItem();i=this._getNextVisibleItemOf(I)}if(e.shiftKey&&e.which==jQuery.sap.KeyCodes.ARROW_UP){I=this._getCurrentItem();i=this._getPreviousVisibleItemOf(I)}if(i&&i!==I){if(this.getListItem(I).isSelected()){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i)}else{this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i)}return}this._resetCurrentItem();if(e.ctrlKey&&e.which==jQuery.sap.KeyCodes.SPACE){e.setMarked();e.preventDefault();return}if((e.ctrlKey||e.metaKey)&&e.which==jQuery.sap.KeyCodes.A){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var s=this._getSelectedItemsOf(v);if(s.length!==v.length){v.forEach(function(i){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false})},this)}else{v.forEach(function(i){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false})},this)}}}},true,this);l.addEventDelegate({onsapbackspace:function(e){e.preventDefault()},onsapshow:function(e){e.setMarked();if(e.keyCode===jQuery.sap.KeyCodes.F4){e.preventDefault()}if(this.isOpen()){this.close();return}if(this.hasContent()){this.open()}},onsaphide:function(e){this.onsapshow(e)},onsapenter:function(e){e.setMarked();this.close()},onsaphome:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[0];this.getListItem(i).focus()},onsapend:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[v.length-1];this.getListItem(i).focus()},onsapup:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[0];var I=jQuery(document.activeElement).control()[0];if(I===this.getListItem(i)){this.focus();e.stopPropagation(true)}},onfocusin:function(e){this.addStyleClass(sap.m.MultiComboBoxRenderer.CSS_CLASS+"Focused")},onfocusout:function(e){this.removeStyleClass(sap.m.MultiComboBoxRenderer.CSS_CLASS+"Focused")},onsapfocusleave:function(e){var p=this.getAggregation("picker");var c=sap.ui.getCore().byId(e.relatedControlId);if(p&&c&&jQuery.sap.equal(p.getFocusDomRef(),c.getFocusDomRef())){if(e.srcControl){e.srcControl.focus()}}}},this);if(sap.ui.Device.support.touch){l.addEventDelegate({ontouchstart:function(e){e.setMark("cancelAutoClose")}})}};
sap.m.MultiComboBox.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);this.getRenderer().placeholderToBeShown=function(r,c){return(!c._oTokenizer.getTokens().length)&&(c.getPlaceholder()?true:false)};return t};
sap.m.MultiComboBox.prototype._handleTokenChange=function(e){var t=e.getParameter("type");var T=e.getParameter("token");var i=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return}if(t===sap.m.Tokenizer.TokenChangeType.Removed){i=(T&&this._getItemByToken(T));if(i&&this.isItemSelected(i)){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});this.focus();this.fireChangeEvent('')}}if(this.isActive()){var d=jQuery(this.getFocusDomRef());if(this._getPlaceholder()===""){d[0].placeholder=""}else{d[0].placeholder=this.getPlaceholder()}}};
sap.m.MultiComboBox.prototype._onAfterRenderingTokenizer=function(){this._setContainerSizes()};
sap.m.MultiComboBox.prototype.onAfterRendering=function(){sap.m.ComboBoxBase.prototype.onAfterRendering.apply(this,arguments);var p=this.getPicker();var d=jQuery(this.getDomRef());var b=d.find(sap.m.MultiComboBoxRenderer.DOT_CSS_CLASS+"Border");p._oOpenBy=b[0]};
sap.m.MultiComboBox.prototype.onfocusout=function(e){this.removeStyleClass(sap.m.MultiComboBoxRenderer.CSS_CLASS+"Focused");sap.m.ComboBoxBase.prototype.onfocusout.apply(this,arguments)};
sap.m.MultiComboBox.prototype.onsapbackspace=function(e){if(!this.getEnabled()||!this.getEditable()){e.preventDefault();return}if(this.getCursorPosition()>0||this.getValue().length>0){return}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);e.preventDefault()};
sap.m.MultiComboBox.prototype.onsapdelete=function(e){if(!this.getEnabled()||!this.getEditable()){return}if(this.getValue()&&!this._isCompleteTextSelected()){return}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments)};
sap.m.MultiComboBox.prototype.onsapnext=function(e){if(e.isMarked()){return}var f=jQuery(document.activeElement).control()[0];if(!f){return}if(f===this._oTokenizer||this._oTokenizer.$().find(f.$()).length>0&&this.getEditable()){this.focus()}};
sap.m.MultiComboBox.prototype.onsapprevious=function(e){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(e.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments)}}};
sap.m.MultiComboBox.prototype._getItemsStartingText=function(t){var i=[];this.getSelectableItems().forEach(function(I){if(jQuery.sap.startsWithIgnoreCase(I.getText(),t)){i.push(I)}},this);return i};
sap.m.MultiComboBox.prototype.getCursorPosition=function(){return this._$input.cursorPos()};
sap.m.MultiComboBox.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false}return true};
sap.m.MultiComboBox.prototype._getNextVisibleItemOf=function(i){var I=this.getSelectableItems();var a=I.indexOf(i)+1;if(a<=0||a>I.length-1){return null}return I[a]};
sap.m.MultiComboBox.prototype._getPreviousVisibleItemOf=function(i){var I=this.getSelectableItems();var a=I.indexOf(i)-1;if(a<0){return null}return I[a]};
sap.m.MultiComboBox.prototype._getNextTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextVisibleItemOf(this._oTraversalItem)}if(i.length&&i[0].getText()===this.getValue()){return this._getNextVisibleItemOf(i[0])}return i.length?i[0]:this.getSelectableItems()[0]};
sap.m.MultiComboBox.prototype._getPreviousTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousVisibleItemOf(this._oTraversalItem)}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousVisibleItemOf(i[i.length-1])}return i.length?i[i.length-1]:this._getPreviousVisibleItemOf(null)};
sap.m.MultiComboBox.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this}if(!jQuery.isArray(i)){jQuery.sap.log.warning('Warning: setSelectedItems() "aItems" has to be an array of sap.ui.core.Item instances or an array of valid sap.ui.core.Item Ids',this);return this}i.forEach(function(I){if(!(I instanceof sap.ui.core.Item)&&(typeof I!=="string")){jQuery.sap.log.warning('Warning: setSelectedItems() "aItems" has to be an array of sap.ui.core.Item instances or an array of valid sap.ui.core.Item Ids',this);return}if(typeof I==="string"){I=sap.ui.getCore().byId(I)}this.setSelection({item:I?I:null,id:I?I.getId():"",key:I?I.getKey():"",suppressInvalidate:true})},this);return this};
sap.m.MultiComboBox.prototype.addSelectedItem=function(i){if(!i){return this}if(typeof i==="string"){i=sap.ui.getCore().byId(i)}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this};
sap.m.MultiComboBox.prototype.removeSelectedItem=function(i){if(!i){return null}if(typeof i==="string"){i=sap.ui.getCore().byId(i)}if(!this.isItemSelected(i)){return null}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i};
sap.m.MultiComboBox.prototype.removeAllSelectedItems=function(){var i=[];var I=this.getAssociation("selectedItems",[]);I.forEach(function(o){var a=this.removeSelectedItem(o);if(a){i.push(a.getId())}},this);return i};
sap.m.MultiComboBox.prototype.removeSelectedKeys=function(k){var i=[],I;if(!k||!k.length||!jQuery.isArray(k)){return i}var o;k.forEach(function(K){o=this.getItemByKey(K);if(o){this.removeSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",fireChangeEvent:false,suppressInvalidate:true});i.push(o)}if(this._aCustomerKeys.length&&(I=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(I,1)}},this);return i};
sap.m.MultiComboBox.prototype.setSelectedKeys=function(k){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(k);return this};
sap.m.MultiComboBox.prototype.addSelectedKeys=function(k){if(!k||!k.length||!jQuery.isArray(k)){return this}if(!jQuery.isArray(k)||typeof k[0]!=="string"){jQuery.sap.log.warning('Warning: addSelectedKeys() "aKeys" has to be an array of string',this);return this}k.forEach(function(K){var i=this.getItemByKey(K);if(i){this.addSelectedItem(i)}else if(K){this._aCustomerKeys.push(K)}},this);return this};
sap.m.MultiComboBox.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],k=[];i.forEach(function(I){k.push(I.getKey())},this);if(this._aCustomerKeys.length){k=k.concat(this._aCustomerKeys)}return k};
sap.m.MultiComboBox.prototype.getSelectedItems=function(){var i=[],I=this.getAssociation("selectedItems")||[];I.forEach(function(s){var o=sap.ui.getCore().byId(s);if(o){i.push(o)}},this);return i};
sap.m.MultiComboBox.prototype.getWidth=function(){return this.getProperty("width")||"100%"};
sap.m.MultiComboBox.prototype.setEditable=function(e){sap.m.ComboBoxBase.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(e);return this};
sap.m.MultiComboBox.prototype.setWidth=function(w){if(w==="auto"){w="100%"}sap.m.ComboBoxBase.prototype.setWidth.apply(this,arguments)};
sap.m.MultiComboBox.prototype.clearFilter=function(){this.getItems().forEach(function(i){this.getListItem(i).setVisible(i.getEnabled()&&this.getSelectable(i))},this)};
sap.m.MultiComboBox.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(l){return!l.getVisible()&&this._getItemByListItem(l).getEnabled()},this)};
sap.m.MultiComboBox.prototype._mapItemToListItem=function(i){if(!i){return null}var l=sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Item";var L=(this.isItemSelected(i))?l+"Selected":"";var o=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,visible:i.getEnabled()}).addStyleClass(l+" "+L);o.setTooltip(i.getTooltip());i.data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"ListItem",o);if(L){var t=new sap.m.Token({key:i.getKey(),text:i.getText(),tooltip:i.getText()});i.data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Token",t);this._oTokenizer.addToken(t)}this.setSelectable(i,i.getEnabled());this._decorateListItem(o);return o};
sap.m.MultiComboBox.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return}i._bSelectable=s;var l=this.getListItem(i);if(l){l.setVisible(s)}var t=this._getTokenByItem(i);if(t){t.setVisible(s)}};
sap.m.MultiComboBox.prototype.getSelectable=function(i){return i._bSelectable};
sap.m.MultiComboBox.prototype._fillList=function(I){if(!I){return null}for(var i=0,l,a=I.length;i<a;i++){l=this._mapItemToListItem(I[i]);this.getList().addAggregation("items",l,true);if(this.isItemSelected(I[i])){this.getList().setSelectedItem(l,true)}}};
sap.m.MultiComboBox.prototype.init=function(){sap.m.ComboBoxBase.prototype.init.apply(this,arguments);this.createList();this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Popover");this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[]};
sap.m.MultiComboBox.prototype.clearSelection=function(){this.removeAllSelectedItems()};
sap.m.MultiComboBox.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i))}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i};
sap.m.MultiComboBox.prototype.isItemSelected=function(i){return(this.getSelectedItems().indexOf(i)>-1?true:false)};
sap.m.MultiComboBox.prototype._clearList=function(){if(this.getList()){this.getList().destroyAggregation("items",true)}};
sap.m.MultiComboBox.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true)};
sap.m.MultiComboBox.prototype.getList=function(){return this._oList};
sap.m.MultiComboBox.prototype.exit=function(){sap.m.ComboBoxBase.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null}};
sap.m.MultiComboBox.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems()}this._oTokenizer.destroyTokens();return this};
sap.m.MultiComboBox.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems()}return i};
sap.m.MultiComboBox.prototype._getItemByListItem=function(l){return this._getItemBy(l,"ListItem")};
sap.m.MultiComboBox.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token")};
sap.m.MultiComboBox.prototype._getItemBy=function(d,D){D=sap.m.ComboBoxBaseRenderer.CSS_CLASS+D;for(var i=0,I=this.getItems(),a=I.length;i<a;i++){if(I[i].data(D)===d){return I[i]}}return null};
sap.m.MultiComboBox.prototype.getListItem=function(i){return i?i.data(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"ListItem"):null};
