/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.RatingIndicator");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.m.RatingIndicator",{metadata:{library:"sap.m",properties:{"visible":{type:"boolean",group:"Behavior",defaultValue:true},"enabled":{type:"boolean",group:"Behavior",defaultValue:true},"maxValue":{type:"int",group:"Behavior",defaultValue:5},"value":{type:"float",group:"Behavior",defaultValue:0,bindable:"bindable"},"iconSize":{type:"sap.ui.core.CSSSize",group:"Behavior",defaultValue:null},"iconSelected":{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},"iconUnselected":{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},"iconHovered":{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},"visualMode":{type:"sap.m.RatingIndicatorVisualMode",group:"Behavior",defaultValue:sap.m.RatingIndicatorVisualMode.Half}},aggregations:{"_iconsSelected":{type:"sap.ui.core.Control",multiple:true,singularName:"_iconsSelected",visibility:"hidden"},"_iconsUnselected":{type:"sap.ui.core.Control",multiple:true,singularName:"_iconsUnselected",visibility:"hidden"},"_iconsHovered":{type:"sap.ui.core.Control",multiple:true,singularName:"_iconsHovered",visibility:"hidden"}},events:{"change":{},"liveChange":{}}}});sap.m.RatingIndicator.M_EVENTS={'change':'change','liveChange':'liveChange'};jQuery.sap.require("sap.ui.core.IconPool");jQuery.sap.require("sap.ui.core.theming.Parameters");
sap.m.RatingIndicator.prototype.init=function(){this.allowTextSelection(false);this._iIconCounter=0;this._fHoverValue=0;if(sap.m.RatingIndicator._pxCalculations===undefined){sap.m.RatingIndicator._pxCalculations=[]}};
sap.m.RatingIndicator.prototype.setValue=function(v){if(v<0){return this}if(isNaN(v)){jQuery.sap.log.warning('Ignored new rating value "'+v+'" because it is NAN')}else if(this.$().length&&(v>this.getMaxValue())){jQuery.sap.log.warning('Ignored new rating value "'+v+'" because it is out  of range (0-'+this.getMaxValue()+')')}else{v=this._roundValueToVisualMode(v);this.setProperty("value",v,true);this._fHoverValue=v;if(this.$().length){this._updateUI(v)}}return this};
sap.m.RatingIndicator.prototype.setIconSize=function(i){if(this.$().length){this._iPxIconSize=this._toPx(i)||16}this.setProperty("iconSize",i,false);return this};
sap.m.RatingIndicator.prototype.setIconSelected=function(u){var I=this.getAggregation("_iconsSelected"),i=0;if(I){for(;i<I.length;i++){I[i].setSrc(u)}}this.setProperty("iconSelected",u,true);return this};
sap.m.RatingIndicator.prototype.setIconUnselected=function(u){var I=this.getAggregation("_iconsUnselected"),i=0;if(I){for(;i<I.length;i++){I[i].setSrc(u)}}this.setProperty("iconUnselected",u,true);return this};
sap.m.RatingIndicator.prototype.setIconHovered=function(u){var I=this.getAggregation("_iconsHovered"),i=0;if(I){for(;i<I.length;i++){I[i].setSrc(u)}}this.setProperty("iconHovered",u,true);return this};
sap.m.RatingIndicator.prototype.onBeforeRendering=function(){var v=this.getValue(),m=this.getMaxValue();if(v>m){this.setValue(m);jQuery.sap.log.warning("Set value to maxValue because value is > maxValue ("+v+" > "+m+").")}else if(v<0){this.setValue(0);jQuery.sap.log.warning("Set value to 0 because value is < 0 ("+v+" < 0).")}this._iPxIconSize=this._toPx(this.getIconSize())||16;this._iPxPaddingSize=this._toPx(sap.ui.core.theming.Parameters.get("sapUiRIIconPadding"))||4};
sap.m.RatingIndicator.prototype.exit=function(){delete this._iIconCounter;delete this._fStartValue;delete this._iPxIconSize;delete this._iPxPaddingSize;delete this._fHoverValue};
sap.m.RatingIndicator.prototype._toPx=function(c){c=c||0;var s=sap.m.RatingIndicator._pxCalculations[c],a;if(s===undefined){if(c){a=jQuery('<div style="display: none; width: '+c+'; margin: 0; padding:0; height: auto; line-height: 1; font-size: 1; border:0; overflow: hidden">&nbsp;</div>').appendTo(sap.ui.getCore().getStaticAreaRef());s=a.width()}else{a=jQuery('<div class="sapMRIIcon">&nbsp;</div>').appendTo(sap.ui.getCore().getStaticAreaRef());s=a.height()}a.remove()}sap.m.RatingIndicator._pxCalculations[c]=Math.round(s);return sap.m.RatingIndicator._pxCalculations[c]};
sap.m.RatingIndicator.prototype._updateUI=function(v,h){var s=this.$("sel"),u=this.$("unsel-wrapper"),H=this.$("hov"),i=this._iPxIconSize,I=this._iPxPaddingSize,a="px",S=this.getMaxValue(),b=v*i+(Math.round(v)-1)*I,w=S*(i+I)-I;this._fHoverValue=v;if(b<0){b=0}u.width((w-b)+a);if(h){H.width(b+a);s.hide();H.show()}else{s.width(b+a);H.hide();s.show()}jQuery.sap.log.debug("Updated rating UI with value "+v+" and hover mode "+h)};
sap.m.RatingIndicator.prototype._getIcon=function(s){var i=null,u=null;switch(s){case 1:u=this.getIconUnselected()||sap.ui.core.IconPool.getIconURI("favorite");break;case 2:u=this.getIconHovered()||sap.ui.core.IconPool.getIconURI("favorite");break;case 0:u=this.getIconSelected()||sap.ui.core.IconPool.getIconURI("favorite");break}if(u){i=sap.ui.core.IconPool.createControlByURI({id:this.getId()+"__icon"+this._iIconCounter++,src:u},sap.m.Image);switch(s){case 1:this.addAggregation("_iconsUnselected",i,true);break;case 2:this.addAggregation("_iconsHovered",i,true);break;case 0:this.addAggregation("_iconsSelected",i,true);break}}return i};
sap.m.RatingIndicator.prototype._calculateSelectedValue=function(e){var s=-1.0,p=0.0,c=this.$(),C=(c.innerWidth()-c.width())/2,E,r=sap.ui.getCore().getConfiguration().getRTL();if(e.targetTouches){E=e.targetTouches[0]}else{E=e}if(!E||!E.pageX){E=e;if((!E||!E.pageX)&&e.changedTouches){E=e.changedTouches[0]}}if(!E.pageX){return parseFloat(s)}if(E.pageX<c.offset().left){s=0}else if((E.pageX-c.offset().left)>c.innerWidth()-C){s=this.getMaxValue()}else{p=(E.pageX-c.offset().left-C)/c.width();s=p*this.getMaxValue()}if(r){s=this.getMaxValue()-s}return this._roundValueToVisualMode(s,true)};
sap.m.RatingIndicator.prototype._roundValueToVisualMode=function(v,i){if(i){if(v<0.25){v=0}else if(v<this.getMaxValue()-0.25){v+=0.25}v=Math.round(v)}else{if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Full){v=Math.round(v)}else if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Half){v=Math.round(v*2)/2}}return parseFloat(v)};
sap.m.RatingIndicator.prototype.ontouchstart=function(e){if(this.getEnabled()){e.setMarked();if(!this._touchEndProxy){this._touchEndProxy=jQuery.proxy(this._ontouchend,this)}if(!this._touchMoveProxy){this._touchMoveProxy=jQuery.proxy(this._ontouchmove,this)}jQuery(document).on("touchend touchcancel mouseup",this._touchEndProxy);jQuery(document).on("touchmove mousemove",this._touchMoveProxy);this._fStartValue=this.getValue();var v=this._calculateSelectedValue(e);if(v>=0&&v<=this.getMaxValue()){this._updateUI(v,true);if(this._fStartValue!==v){this.fireLiveChange({value:v})}}}};
sap.m.RatingIndicator.prototype._ontouchmove=function(e){if(e.isMarked("delayedMouseEvent")){return}e.preventDefault();if(this.getEnabled()){var v=this._calculateSelectedValue(e);if(v>=0&&v<=this.getMaxValue()){this._updateUI(v,true);if(this._fStartValue!==v){this.fireLiveChange({value:v})}}}};
sap.m.RatingIndicator.prototype._ontouchend=function(e){if(e.isMarked("delayedMouseEvent")){return}if(this.getEnabled()){var v=this._calculateSelectedValue(e);this.setProperty("value",v,true);this._updateUI(v,false);if(this._fStartValue!==v){this.fireLiveChange({value:v});this.fireChange({value:v})}jQuery(document).off("touchend touchcancel mouseup",this._touchEndProxy);jQuery(document).off("touchmove mousemove",this._touchMoveProxy);delete this._fStartValue}};
sap.m.RatingIndicator.prototype.ontouchcancel=sap.m.RatingIndicator.prototype.ontouchend;
sap.m.RatingIndicator.prototype.onsapincrease=function(e){var v=this.getValue(),o=this.getValue(),m=this.getMaxValue();if(!this.getEnabled()){return false}if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Full){v+=1}else if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Half){v+=0.5}if(v>m){v=m}this.setValue(v);if(v!==o){this.fireLiveChange({value:v});this.fireChange({value:v})}if(e){e.preventDefault();e.stopPropagation()}};
sap.m.RatingIndicator.prototype.onsapdecrease=function(e){var v=this.getValue(),o=this.getValue();if(!this.getEnabled()){return false}if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Full){v-=1}else if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Half){v-=0.5}if(v<0){v=0}this.setValue(v);if(v!==o){this.fireLiveChange({value:v});this.fireChange({value:v})}if(e){e.preventDefault();e.stopPropagation()}};
sap.m.RatingIndicator.prototype.onsaphome=function(e){var v=0,o=this.getValue();if(!this.getEnabled()){return false}this.setValue(v);if(v!==o){this.fireLiveChange({value:v});this.fireChange({value:v})}if(e){e.preventDefault();e.stopPropagation()}};
sap.m.RatingIndicator.prototype.onsapend=function(e){var v=this.getMaxValue(),o=this.getValue();if(!this.getEnabled()){return false}this.setValue(v);if(v!==o){this.fireLiveChange({value:v});this.fireChange({value:v})}if(e){e.preventDefault();e.stopPropagation()}};
sap.m.RatingIndicator.prototype.onsapselect=function(e){var v=this.getValue(),m=this.getMaxValue(),o=this.getValue();if(!this.getEnabled()){return false}if(v===m){v=0}else if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Full){v+=1}else if(this.getVisualMode()===sap.m.RatingIndicatorVisualMode.Half){v+=0.5}if(v>m){v=m}this.setValue(v);if(v!==o){this.fireLiveChange({value:v});this.fireChange({value:v})}if(e){e.preventDefault();e.stopPropagation()}};
