/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.TextFieldRenderer");jQuery.sap.require("sap.ui.core.Renderer");jQuery.sap.require("sap.ui.core.ValueStateSupport");sap.ui.commons.TextFieldRenderer={};
sap.ui.commons.TextFieldRenderer.render=function(R,t){var a=R,r=sap.ui.commons.TextFieldRenderer;if(!t.getVisible()){return}var w=t.getWidth();var b=sap.ui.core.ValueStateSupport.enrichTooltip(t,t.getTooltip_AsString());var c=t._getRenderOuter();if(c){a.write("<div");a.writeControlData(t);a.addClass("sapUiTfBack");this.renderStyles(a,t);if(b){a.writeAttributeEscaped('title',b)}var s;if(w&&w!=''){s='width: '+w+';'}if(this.renderOuterAttributes){this.renderOuterAttributes(a,t)}if(s){a.writeAttribute('style',s)}a.writeStyles();a.writeClasses();a.write(">");if(this.renderOuterContentBefore){this.renderOuterContentBefore(a,t)}}if(this.getInnerTagName){a.write('<'+this.getInnerTagName())}else{a.write("<input")}a.addClass("sapUiTf");if(!c){a.writeControlData(t);a.addClass("sapUiTfBack");this.renderStyles(a,t);if(w&&w!=''){a.addStyle("width",w)}}else{a.writeAttribute('id',t.getId()+'-input');a.addClass("sapUiTfInner");a.addStyle("width",'100%')}if(b){a.writeAttributeEscaped('title',b)}if(t.getName()){a.writeAttributeEscaped('name',t.getName())}if(!t.getEditable()){a.writeAttribute('readonly','readonly')}if(this.renderTextFieldEnabled){this.renderTextFieldEnabled(a,t)}else if(!t.getEnabled()){a.writeAttribute('disabled','disabled');a.writeAttribute('tabindex','-1')}else if(!t.getEditable()){a.writeAttribute('tabindex','0')}else{a.writeAttribute('tabindex','0')}var T=t.getTextDirection();if(T){a.addStyle("direction",T.toLowerCase())}var o=t.getTextAlign();if(o){a.addStyle("text-align",r.getTextAlign(o,T))}switch(t.getImeMode()){case sap.ui.core.ImeMode.Inactive:a.addStyle('ime-mode','inactive');break;case sap.ui.core.ImeMode.Active:a.addStyle('ime-mode','active');break;case sap.ui.core.ImeMode.Disabled:a.addStyle('ime-mode','disabled');break}if(t.getDesign()==sap.ui.core.Design.Monospace){a.addClass('sapUiTfMono')}if(t.getMaxLength()){a.writeAttribute("maxLength",t.getMaxLength())}if(this.renderInnerAttributes){this.renderInnerAttributes(a,t)}if(this.renderARIAInfo){this.renderARIAInfo(a,t)}var p=t.getPlaceholder();if(p){if(this.convertPlaceholder){p=this.convertPlaceholder(t)}if(sap.ui.Device.support.input.placeholder){a.writeAttributeEscaped('placeholder',p)}}a.writeStyles();a.writeClasses();if(this.getInnerTagName){a.write(">")}else{a.write(" value=\"");if(!sap.ui.Device.support.input.placeholder&&p&&!t.getValue()){a.writeEscaped(p)}else{a.writeEscaped(t.getValue())}a.write("\"");a.write("/>")}if(this.getInnerTagName){if(this.renderInnerContent){this.renderInnerContent(a,t)}a.write('</'+this.getInnerTagName()+'>')}if(c){if(this.renderOuterContent){this.renderOuterContent(a,t)}a.write("</div>")}};
sap.ui.commons.TextFieldRenderer.renderStyles=function(r,t){r.addClass('sapUiTfBrd');if(t.getEnabled()){if(!t.getEditable()){r.addClass("sapUiTfRo")}else{r.addClass("sapUiTfStd")}}else{r.addClass("sapUiTfDsbl")}switch(t.getValueState()){case(sap.ui.core.ValueState.Error):r.addClass('sapUiTfErr');break;case(sap.ui.core.ValueState.Success):r.addClass('sapUiTfSucc');break;case(sap.ui.core.ValueState.Warning):r.addClass('sapUiTfWarn');break}if(t.getRequired()){r.addClass('sapUiTfReq')}if(t.getPlaceholder()&&!sap.ui.Device.support.input.placeholder){r.addClass('sapUiTfPlace')}};
sap.ui.commons.TextFieldRenderer.onfocus=function(t){var T=t.$();T.addClass("sapUiTfFoc");if(!sap.ui.Device.support.input.placeholder&&!t.getValue()&&t.getPlaceholder()){if(t._getRenderOuter()){var o=t.$("input")}else{var o=T}T.removeClass("sapUiTfPlace");o.val("")}};
sap.ui.commons.TextFieldRenderer.onblur=function(t){var T=t.$();T.removeClass("sapUiTfFoc");var p=t.getPlaceholder();if(!sap.ui.Device.support.input.placeholder){if(t._getRenderOuter()){var o=t.$("input")}else{var o=T}if(!o.val()&&p){T.addClass("sapUiTfPlace");if(this.convertPlaceholder){p=this.convertPlaceholder(t)}o.val(p)}}};
sap.ui.commons.TextFieldRenderer.setValueState=function(t,o,n){var T=t.$();var r=t._getRenderOuter();if(r){var a=t.$("input")}else{var a=T}switch(o){case(sap.ui.core.ValueState.Error):T.removeClass('sapUiTfErr');a.removeAttr('aria-invalid');break;case(sap.ui.core.ValueState.Success):T.removeClass('sapUiTfSucc');break;case(sap.ui.core.ValueState.Warning):T.removeClass('sapUiTfWarn');break}switch(n){case(sap.ui.core.ValueState.Error):T.addClass('sapUiTfErr');a.attr('aria-invalid',true);break;case(sap.ui.core.ValueState.Success):T.addClass('sapUiTfSucc');break;case(sap.ui.core.ValueState.Warning):T.addClass('sapUiTfWarn');break}var b=sap.ui.core.ValueStateSupport.enrichTooltip(t,t.getTooltip_AsString());if(b){T.attr('title',b);if(r){t.$("input").attr('title',b)}}else{T.removeAttr('title');if(r){t.$("input").removeAttr('title')}}};
sap.ui.commons.TextFieldRenderer.setEditable=function(t,e){if(!t.getEnabled()){return}var T=t.$();if(t._getRenderOuter()){var o=t.$("input")}else{var o=T}if(e){T.removeClass('sapUiTfRo').addClass('sapUiTfStd');o.removeAttr('readonly')}else{T.removeClass('sapUiTfStd').addClass('sapUiTfRo');o.attr('readonly','readonly')}o.attr('aria-readonly',!e)};
sap.ui.commons.TextFieldRenderer.setEnabled=function(t,e){var T=t.$();if(t._getRenderOuter()){var o=t.$("input")}else{var o=T}if(e){if(t.getEditable()){T.removeClass('sapUiTfDsbl').addClass('sapUiTfStd').removeAttr('aria-disabled');o.removeAttr('disabled').removeAttr('aria-disabled').attr('tabindex','0')}else{T.removeClass('sapUiTfDsbl').addClass('sapUiTfRo').removeAttr('aria-disabled');o.removeAttr('disabled').removeAttr('aria-disabled').attr('tabindex','0').attr('readonly','readonly')}}else{if(t.getEditable()){T.removeClass('sapUiTfStd').addClass('sapUiTfDsbl').attr('aria-disabled','true');o.attr('disabled','disabled').attr('aria-disabled','true').attr('tabindex','-1')}else{T.removeClass('sapUiTfRo').addClass('sapUiTfDsbl').attr('aria-disabled','true');o.removeAttr('readonly').attr('disabled','disabled').attr('aria-disabled','true').attr('tabindex','-1')}}};
sap.ui.commons.TextFieldRenderer.removeValidVisualization=function(t){var T=t.$();if(T){T.removeClass("sapUiTfSucc")}else{jQuery.sap.delayedCall(1000,sap.ui.commons.TextFieldRenderer,"removeValidVisualization",[t])}};
sap.ui.commons.TextFieldRenderer.setDesign=function(t,d){t.$().toggleClass('sapUiTfMono',(d==sap.ui.core.Design.Monospace))};
sap.ui.commons.TextFieldRenderer.setRequired=function(t,r){if(t._getRenderOuter()){var T=t.$("input")}else{var T=t.$()}t.$().toggleClass('sapUiTfReq',r);if(r){T.attr("aria-required",true)}else{T.removeAttr("aria-required")}};
sap.ui.commons.TextFieldRenderer.renderARIAInfo=function(r,t){var p={role:t.getAccessibleRole().toLowerCase(),multiline:false,autocomplete:'none'};if(t.getValueState()==sap.ui.core.ValueState.Error){p["invalid"]=true}r.writeAccessibilityState(t,p)};
sap.ui.commons.TextFieldRenderer.getTextAlign=sap.ui.core.Renderer.getTextAlign;
