/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.Tree");jQuery.sap.require("sap.ui.commons.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.commons.Tree",{metadata:{publicMethods:["expandAll","collapseAll"],library:"sap.ui.commons",properties:{"title":{type:"string",group:"Misc",defaultValue:null},"width":{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},"height":{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},"showHeader":{type:"boolean",group:"Misc",defaultValue:true},"showHeaderIcons":{type:"boolean",group:"Misc",defaultValue:true},"showHorizontalScrollbar":{type:"boolean",group:"Misc",defaultValue:false},"minWidth":{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},"selectionMode":{type:"sap.ui.commons.TreeSelectionMode",group:"Behavior",defaultValue:sap.ui.commons.TreeSelectionMode.Single}},defaultAggregation:"nodes",aggregations:{"nodes":{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node",bindable:"bindable"}},events:{"select":{allowPreventDefault:true},"selectionChange":{}}}});sap.ui.commons.Tree.M_EVENTS={'select':'select','selectionChange':'selectionChange'};sap.ui.commons.Tree.prototype.resizeListenerId;
sap.ui.commons.Tree.prototype.init=function(){this.bAllCollapsed=false;this.allowTextSelection(false);this.iOldScrollTop=null;this.oSelectedNodeMap={};this.oSelectedContextMap={};this.aLeadSelection=null;this.bDelFlag=null;this.aExpandedTree=[];var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oCollapseAllButton=new sap.ui.commons.Button(this.getId()+"-CollapseAll",{icon:this.getIconPrefix()+"CollapseAll.png",tooltip:r.getText("TREE_COLLAPSE_ALL"),lite:true});this.oExpandAllButton=new sap.ui.commons.Button(this.getId()+"-ExpandAll",{icon:this.getIconPrefix()+"ExpandAll.png",tooltip:r.getText("TREE_EXPAND_ALL"),lite:true});this.oCollapseAllButton.attachPress(this.onCollapseAll,this);this.oExpandAllButton.attachPress(this.onExpandAll,this);this.oCollapseAllButton.addStyleClass("sapUiTreeCol");this.oExpandAllButton.addStyleClass("sapUiTreeExp")};
sap.ui.commons.Tree.prototype.exit=function(){if(this.oCollapseAllButton){this.oCollapseAllButton.destroy();this.oCollapseAllButton=null}if(this.oExpandAllButton){this.oExpandAllButton.destroy();this.oExpandAllButton=null}};
sap.ui.commons.Tree.SelectionType={Select:"Select",Toggle:"Toggle",Range:"Range"};
sap.ui.commons.Tree.prototype.onThemeChanged=function(){this.oCollapseAllButton.setIcon(this.getIconPrefix()+"CollapseAll.png");this.oExpandAllButton.setIcon(this.getIconPrefix()+"ExpandAll.png")};
sap.ui.commons.Tree.prototype.onExpandAll=function(){this.expandAll()};
sap.ui.commons.Tree.prototype.onCollapseAll=function(){this.collapseAll()};
sap.ui.commons.Tree.prototype.expandAll=function(){var n=this.getNodes();for(var i=0;i<n.length;i++){n[i].expand(true)}};
sap.ui.commons.Tree.prototype.collapseAll=function(){var n=this.getNodes();for(var i=0;i<n.length;i++){n[i].collapse(true)}};
sap.ui.commons.Tree.prototype.onsapdown=function(e){this.moveFocus(false);e.preventDefault()};
sap.ui.commons.Tree.prototype.onsapup=function(e){this.moveFocus(true);e.preventDefault()};
sap.ui.commons.Tree.prototype.onsaphome=function(e){this.placeFocus(this.getFirstSibling(e.target));e.preventDefault()};
sap.ui.commons.Tree.prototype.onsaphomemodifiers=function(e){this.placeFocus(this.getFirst());e.preventDefault()};
sap.ui.commons.Tree.prototype.onsapend=function(e){this.placeFocus(this.getLastSibling(e.target));e.preventDefault()};
sap.ui.commons.Tree.prototype.onsapendmodifiers=function(e){this.placeFocus(this.getLast());e.preventDefault()};
sap.ui.commons.Tree.prototype.onsapcollapseall=function(e){if(this.bAllCollapsed){this.expandAll()}else{this.collapseAll()}this.bAllCollapsed=!this.bAllCollapsed};
sap.ui.commons.Tree.prototype.getIconPrefix=function(){var i="themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/";if(!sap.ui.getCore().getConfiguration().getRTL()){i+="img/tree/"}else{i+="img-RTL/tree/"}return sap.ui.resource("sap.ui.commons",i)};
sap.ui.commons.Tree.prototype.getFirstSibling=function(d){var D=jQuery(d).siblings(".sapUiTreeNode:visible").first();if(D.length){return D[0]}return null};
sap.ui.commons.Tree.prototype.getLastSibling=function(d){var D=jQuery(d).siblings(".sapUiTreeNode:visible").last();if(D.length){return D[0]}return null};
sap.ui.commons.Tree.prototype.getFirst=function(){var d=this.$().find(".sapUiTreeNode:visible").first();if(d.length){return d[0]}return null};
sap.ui.commons.Tree.prototype.getLast=function(){var d=this.$().find(".sapUiTreeNode:visible").last();if(d.length){return d[0]}return null};
sap.ui.commons.Tree.prototype.moveFocus=function(m){var a=jQuery(".sapUiTreeNode:focus");if(a.length){var c=sap.ui.getCore().getControl(a[0].id);var d=this.$().find(".sapUiTreeNode:visible");var b=d.index(a[0]);var n=b;if(m){n--}else{n++}if(n>=0&&n<d.length){var D=d.eq(n);var N=sap.ui.getCore().getControl(D[0].id);c.blur();N.focus()}}};
sap.ui.commons.Tree.prototype.adjustFocus=function(){var f=this.$().find('.sapUiTreeNode[tabIndex="0"]');if(!f.is(':visible')){var d=this.$().find(".sapUiTreeNode");var a=d.index(f[0]);var D=d.filter(":lt("+a+")");var b=D.filter(":visible");var n=b[b.length-1];if(n){n.setAttribute("tabindex","0");if(jQuery(".sapUiTreeNode:focus").is(":not(:visible)")){n.focus()}}}};
sap.ui.commons.Tree.prototype.placeFocus=function(d){if(!d){return}var D=this.$().find(".sapUiTreeNode[tabIndex='0']");if(D.length){D[0].setAttribute("tabindex","-1")}d.setAttribute("tabindex","0");var t=sap.ui.getCore().getControl(d.id);t.focus()};
sap.ui.commons.Tree.prototype.adjustSelectionOnExpanding=function(e){var t=this.$(),E=jQuery(e),d,D;if(E.hasClass("sapUiTreeNodeSelectedParent")){E.removeClass("sapUiTreeNodeSelectedParent")}var $=t.find(".sapUiTreeNodeSelected:visible");if($.length){t.find(".sapUiTreeNodeSelectedParent").removeClass("sapUiTreeNodeSelectedParent")}else{d=t.find(".sapUiTreeNodeSelected");D=d.parent(".sapUiTreeChildrenNodes").prev(".sapUiTreeNode");while(D.length&&!D.is(":visible")){D=D.parent(".sapUiTreeChildrenNodes").prev(".sapUiTreeNode")}D.addClass("sapUiTreeNodeSelectedParent")}};
sap.ui.commons.Tree.prototype.adjustSelectionOnCollapsing=function(d){var t=this;if(this.getSelectionMode()!=sap.ui.commons.TreeSelectionMode.Multi){var D=jQuery(d),c="#"+D.attr("id")+"-children",$=D.siblings(c).find(".sapUiTreeNodeSelected"),a=D.siblings(c).find(".sapUiTreeNodeSelectedParent");if($.length||a.length){D.addClass("sapUiTreeNodeSelectedParent");if(a.length){a.removeClass("sapUiTreeNodeSelectedParent")}}}else{var D=jQuery(d),c="#"+D.attr("id")+"-children",$=D.siblings(c).find(".sapUiTreeNodeSelected");var s=$.control();if(s){if(jQuery.isEmptyObject(s)==false){jQuery.each(s,function(i,n){t._delMultiSelection(n)})}}}};
sap.ui.commons.Tree.prototype.isTreeBinding=function(n){return(n=="nodes")};
sap.ui.commons.Tree.prototype.updateNodes=function(){var c=this.oSelectedContext,n;this.updateAggregation("nodes");if(c){n=this.getNodeByContext(c);this.setSelection(n,true)}};
sap.ui.commons.Tree.prototype.getNodeByContext=function(c){return this.findNode(this,function(n){return n.getBindingContext()==c})};
sap.ui.commons.Tree.prototype.findNode=function(n,m){var f,t=this;if(m(n)){return n}jQuery.each(n.getNodes(),function(i,n){f=t.findNode(n,m);if(f)return false});return f};
sap.ui.commons.Tree.prototype.setSelectionMode=function(m){m=this.validateProperty("selectionMode",m);if(this.getSelectionMode()!=m){this.setProperty("selectionMode",m);this._delSelection()}};
sap.ui.commons.Tree.prototype.getSelection=function(){for(var i in this.oSelectedNodeMap){return this.oSelectedNodeMap[i]}return null};
sap.ui.commons.Tree.prototype.setSelection=function(n,s,t,d){var D=true;if(!s){D=this.fireSelect({node:n,nodeContext:n&&n.getBindingContext()})}if(D){switch(this.getSelectionMode()){case sap.ui.commons.TreeSelectionMode.Single:this._setSelectedNode(n,s);break;case sap.ui.commons.TreeSelectionMode.Multi:if(t==sap.ui.commons.Tree.SelectionType.Range){this._setSelectedNodeMapRange(n,s)}else if(t==sap.ui.commons.Tree.SelectionType.Toggle){this._setSelectedNodeMapToggle(n,s)}else{this._setSelectedNode(n,s)}break;case sap.ui.commons.TreeSelectionMode.None:break}}};
sap.ui.commons.Tree.prototype.onAfterRendering=function(){if(this.iOldScrollTop){this.$("TreeCont").scrollTop(this.iOldScrollTop)}};
sap.ui.commons.Tree.prototype.invalidate=function(){sap.ui.core.Control.prototype.invalidate.apply(this,arguments);this.oSelectedNodeMap={};this.oSelectedContextMap={};this.updateSelection(this,true)};
sap.ui.commons.Tree.prototype.updateSelection=function(n,e){var t=this;jQuery.each(n.getNodes(),function(i,n){if(n.getIsSelected()){switch(t.getSelectionMode()){case sap.ui.commons.TreeSelectionMode.None:jQuery.sap.log.warning("Added selected nodes in a tree with disabled selection");n.setIsSelected(false);break;case sap.ui.commons.TreeSelectionMode.Single:if(jQuery.isEmptyObject(t.oSelectedNodeMap)==false){jQuery.sap.log.warning("Added multiple selected nodes in single select tree");n.setIsSelected(false)}else{t.oSelectedNodeMap[n.getId()]=n}break;case sap.ui.commons.TreeSelectionMode.Multi:if(!e){jQuery.sap.log.warning("Added selected node inside collapsed node in multi select tree");n.setIsSelected(false)}else{t.oSelectedNodeMap[n.getId()]=n}break}}t.updateSelection(n,e&&n.getExpanded())})};
sap.ui.commons.Tree.prototype.onBeforeRendering=function(){this.iOldScrollTop=this.$("TreeCont").scrollTop()};
sap.ui.commons.Tree.prototype._setSelectedNode=function(n,s){var t=this;jQuery.each(this.oSelectedNodeMap,function(i,n){t._delMultiSelection(n,s)});if(n){n._select(s,true)}this.oSelectedNodeMap[n.getId()]=n;this.oSelectedContextMap[n.getId()]=n&&n.getBindingContext();this.oLeadSelection=n;if(!s){this.fireSelectionChange({nodes:[n],nodeContexts:[n&&n.getBindingContext()]})}};
sap.ui.commons.Tree.prototype._setSelectedNodeMapToggle=function(n,s){this._setNodeSelection(n,!n.getIsSelected(),s)};
sap.ui.commons.Tree.prototype._setSelectedNodeMapRange=function(n,s){var N=[],c=[];var t=this;if(this.bDelFlag==true){jQuery.each(this.oSelectedNodeMap,function(I,n){t._delMultiSelection(n,s)})};if(this.oSelectedNodeMap[n.getId()]==n){return}else{this.aExpandedTree.length=0;var N=n.getTree().getNodes();var i,a,b;if(N.length>0){this._getSelectableNodes(N);var S=this.aExpandedTree.indexOf(this.oLeadSelection);var e=this.aExpandedTree.indexOf(n);if(S<e){a=S,b=e}else{a=e,b=S};for(i=a;i<=b;i++){var o=this.aExpandedTree[i];this._setMultiSelection(o,s)}}};if(!s){jQuery.map(this.oSelectedNodeMap,function(I,n){N.push(n)});jQuery.map(this.oSelectedContextMap,function(I,n){c.push(n)});this.fireSelectionChange({nodes:N,nodeContexts:c})}};
sap.ui.commons.Tree.prototype._getSelectableNodes=function(n){if(n.length>0){var i;for(i=0;i<n.length;i++){var N=n[i];if(N.getSelectable()){this.aExpandedTree.push(N)};if(N.getExpanded()){var s=N.getNodes();this._getSelectableNodes(s)}}}};
sap.ui.commons.Tree.prototype._setNodeSelection=function(n,i,s){var N=[],a=[];this.bDelFlag=true;if(i){this._setMultiSelection(n,s);this.oLeadSelection=n}else{this._delMultiSelection(n,s);this.oLeadSelection=n}if(!s){jQuery.map(this.oSelectedNodeMap,function(I,n){N.push(n)});jQuery.map(this.oSelectedContextMap,function(I,n){a.push(n)});this.fireSelectionChange({nodes:N,nodeContexts:a})}};
sap.ui.commons.Tree.prototype._setMultiSelection=function(s,S){if(!s){return}s._select(S);this.oSelectedNodeMap[s.getId()]=s;this.oSelectedContextMap[s.getId()]=s.getBindingContext()};
sap.ui.commons.Tree.prototype._delMultiSelection=function(s,S){if(!s){return}s._deselect();delete this.oSelectedNodeMap[s.getId()];delete this.oSelectedContextMap[s.getId()]};
sap.ui.commons.Tree.prototype._delSelection=function(){var t=this;if(this.oSelectedNode){this.oSelectedNode._deselect()}if(jQuery.isEmptyObject(this.oSelectedNodeMap)==false){jQuery.each(this.oSelectedNodeMap,function(i,n){t._delMultiSelection(n)})}};
