// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.layout.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.layout.GridRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.layout.GridRenderer");

/**
 * @class
 * @author SAP SE
 * @version
 * 1.24.2
 * @static
 */
sap.ui.layout.GridRenderer = {};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            oRm the RenderManager that can be used for writing to the render
 *            output buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
sap.ui.layout.GridRenderer.render = function(oRm, oControl) {
	var INDENTPATTERN = /^([L](?:[0-9]|1[0-1]))? ?([M](?:[0-9]|1[0-1]))? ?([S](?:[0-9]|1[0-1]))?$/i;
	var SPANPATTERN = /^([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;
	
	// write the HTML into the render manager
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapUiRespGrid");
	
	var  sMedia = sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD).name;
	oRm.addClass("sapUiRespGridMedia-Std-" + sMedia);
	
	var fHSpacing = oControl.getHSpacing();
	// Check for allowed values, if not matching, set to to default 1 rem.
	if (fHSpacing == 0.5) {
		fHSpacing = "05";
	} else if ((fHSpacing !== 0) && (fHSpacing !== 1) && (fHSpacing !== 2)) {
		fHSpacing = 1;
	}
	
	oRm.addClass("sapUiRespGridHSpace" + fHSpacing);

	var fVSpacing = oControl.getVSpacing();
	// Check for allowed values, if not matching, set to to default 1 rem.
	if (fVSpacing == 0.5) {
		fVSpacing = "05";
	} else if ((fVSpacing !== 0) && (fVSpacing !== 1) && (fVSpacing !== 2)) {
		fVSpacing = 1;
	} 
	
	oRm.addClass("sapUiRespGridVSpace" + fVSpacing);

	var sPosition = oControl.getPosition();
	if (sPosition) {
		sPosition = sPosition.toUpperCase();
		if (sPosition === sap.ui.layout.GridPosition.Center.toUpperCase()) {
			oRm.addClass("sapUiRespGridPosCenter");
		} else if (sPosition === sap.ui.layout.GridPosition.Right.toUpperCase()) {
			oRm.addClass("sapUiRespGridPosRight");
		}
	}

	oRm.writeClasses();
	var sWidth = oControl.getWidth();
	if (sWidth !== "100%" && sWidth !== "auto" && sWidth !== "inherit") {
		if (fHSpacing == 0) {
			sWidth = "width: " + sWidth;
		} else {
			sWidth = "width: -webkit-calc(" + sWidth + " - " + fHSpacing  + "rem); width: calc(" + sWidth + " - " + fHSpacing  + "rem); ";
		}
		oRm.writeAttribute("style", sWidth);
	}
	oRm.write(">");

	var aItems = oControl.getContent();

	var defaultSpan = oControl.getDefaultSpan();
	var defaultIndent = oControl.getDefaultIndent();
	var aDIndent = INDENTPATTERN.exec(defaultIndent);

	// Default Span if nothing is specified at all, not on Grid , not on the
	// cell.
	var aDefColSpan = [ "", "L3", "M6", "S12" ];

	// Default Span values defined on the whole Grid, that is used if there is
	// no individual span defined for the cell.
	var aDSpan = SPANPATTERN.exec(defaultSpan);

	for ( var i = 0; i < aItems.length; i++) { // loop over all child controls
		oRm.write("<div");
		var oLay = oControl._getLayoutDataForControl(aItems[i]);

		if (oLay) {

			// Line break
			if (oLay.getLinebreak() === true) {
				oRm.addClass("sapUiRespGridBreak");
			} else {
				if (oLay.getLinebreakL() === true) {
					oRm.addClass("sapUiRespGridBreakL");
				}
				if (oLay.getLinebreakM() === true) {
					oRm.addClass("sapUiRespGridBreakM");
				}
				if (oLay.getLinebreakS() === true) {
					oRm.addClass("sapUiRespGridBreakS");
				}
			}

			// Span
			var aSpan;
			var sSpan = oLay.getSpan();
			if (!sSpan || !sSpan.lenght == 0) {
				aSpan = aDSpan;
			} else {
				aSpan = SPANPATTERN.exec(sSpan);
			}

			if (aSpan) {
				for ( var j = 1; j < aSpan.length; j++) {
					var span = aSpan[j];
					if (!span) {
						span = aDSpan[j];
						if (!span) {
							span = aDefColSpan[j];
						}
					}

					// Catch the Individual Spans
					var iSpanLarge = oLay.getSpanL();
					var iSpanMedium = oLay.getSpanM();
					var iSpanSmall = oLay.getSpanS();

					span = span.toUpperCase();
					if ((span.substr(0, 1) === "L") && (iSpanLarge > 0)	&& (iSpanLarge < 13)) {
						oRm.addClass("sapUiRespGridSpanL" + iSpanLarge);
					} else if ((span.substr(0, 1) === "M") && (iSpanMedium > 0)	&& (iSpanMedium < 13)) {
						oRm.addClass("sapUiRespGridSpanM" + iSpanMedium);
					} else if ((span.substr(0, 1) === "S") && (iSpanSmall > 0) && (iSpanSmall < 13)) {
						oRm.addClass("sapUiRespGridSpanS" + iSpanSmall);
					} else {
						oRm.addClass("sapUiRespGridSpan" + span);
					}
				}
			}

			// Indent
			var aIndent;

			var sIndent = oLay.getIndent();
			if (!sIndent || sIndent.length == 0) {
				aIndent = aDIndent;
			} else {
				aIndent = INDENTPATTERN.exec(sIndent);
			}

			if (!aIndent) {
				aIndent = aDIndent;
				if (!aIndent) {
					aIndent = undefined; // no indent
				}
			}

			if (aIndent) {
				for ( var j = 1; j < aIndent.length; j++) {
					var indent = aIndent[j];
					if (!indent) {
						if (aDIndent && aDIndent[j]) {
							indent = aDIndent[j];
						}
					}
					if (indent) {
						indent = indent.toUpperCase();

						// Catch the Individual Indents
						var iIndentLarge = oLay.getIndentL();
						var iIndentMedium = oLay.getIndentM();
						var iIndentSmall = oLay.getIndentS();

						if ((indent.substr(0, 1) === "L") && (iIndentLarge > 0)
								&& (iIndentLarge < 12)) {
							oRm.addClass("sapUiRespGridIndentL" + iIndentLarge);
						} else if ((indent.substr(0, 1) === "M")
								&& (iIndentMedium > 0) && (iIndentMedium < 12)) {
							oRm.addClass("sapUiRespGridIndentM"	+ iIndentMedium);
						} else if ((indent.substr(0, 1) === "S")
								&& (iIndentSmall > 0) && (iIndentSmall < 12)) {
							oRm.addClass("sapUiRespGridIndentS" + iIndentSmall);
						} else {
							if (!(/^(L0)? ?(M0)? ?(S0)?$/.exec(indent))) {
								oRm.addClass("sapUiRespGridIndent" + indent);
							}
						}
					}
				}
			}
			
			
			
			
			// Visibility
			var l = oLay.getVisibleL(),
			m = oLay.getVisibleM(),
			s = oLay.getVisibleS();

			if (!l && m && s) {
				oRm.addClass("sapUiRespGridHiddenL");
			} else if (!l && !m && s) {
				oRm.addClass("sapUiRespGridVisibleS");
			} else if (l && !m && !s) {
				oRm.addClass("sapUiRespGridVisibleL");
			} else if (!l && m && !s) {
				oRm.addClass("sapUiRespGridVisibleM");
			} else if (l && !m && s) {
				oRm.addClass("sapUiRespGridHiddenM");
			} else if (l && m && !s) {
				oRm.addClass("sapUiRespGridHiddenS");
			}

			// Move - moveBwd shifts a grid element to the left in LTR mode and
			// opposite in RTL mode

			var sMoveB = oLay.getMoveBackwards();

			if (sMoveB && sMoveB.length > 0) {
				var aMoveB = INDENTPATTERN.exec(sMoveB);
				if (aMoveB) {
					for ( var j = 1; j < aMoveB.length; j++) {
						var moveB = aMoveB[j];
						if (moveB) {
							oRm.addClass("sapUiRespGridBwd"	+ moveB.toUpperCase());
						}
					}
				}
			}
			// ... while moveFwd shifts it to the right in LTR mode and opposite
			// in RTL
			var sMoveF = oLay.getMoveForward();

			if (sMoveF && sMoveF.length > 0) {
				var aMoveF = INDENTPATTERN.exec(sMoveF);
				if (aMoveF) {
					for ( var j = 1; j < aMoveF.length; j++) {
						var moveF = aMoveF[j];
						if (moveF) {
							oRm.addClass("sapUiRespGridFwd"	+ moveF.toUpperCase());
						}
					}
				}
			}
			
			// Internal additional classes
			if (oLay._sStylesInternal) {
				oRm.addClass(oLay._sStylesInternal);
			}
		}

		// No layoutData - just apply defaults
		if (!oLay) {
			var span = "";
			if (aDSpan) {
				for ( var j = 1; j < aDSpan.length; j++) {
					span = aDSpan[j];
					if (!span) {
						span = aDefColSpan[j];
					}
					oRm.addClass("sapUiRespGridSpan" + span.toUpperCase());
				}
			} else {
				for ( var j = 1; j < aDefColSpan.length; j++) {
					span = aDefColSpan[j];
					oRm.addClass("sapUiRespGridSpan" + span.toUpperCase());
				}
			}
			
			var indent = "";
			if (aDIndent) {
				for ( var j = 1; j < aDIndent.length; j++) {
					indent = aDIndent[j];
					if (indent && (indent.substr(1,1) !== "0")) {
						oRm.addClass("sapUiRespGridIndent" + indent.toUpperCase());
					}
				}
			}
		}

		oRm.writeClasses();
		oRm.write(">");

		oRm.renderControl(aItems[i]); // render the child control (could even
										// be a big control tree, but you don't
										// need to care)

		oRm.write("</div>"); // end of the box around the respective child
	}

	oRm.write("</div>"); // end of the complete grid  control
};

}; // end of sap/ui/layout/GridRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.HorizontalLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.layout.HorizontalLayoutRenderer");

/**
 * @class HorizontalLayout renderer.
 * @static
 */
sap.ui.layout.HorizontalLayoutRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.layout.HorizontalLayoutRenderer.render = function(oRenderManager, oControl){
	// return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	// convenience variable
	var rm = oRenderManager;
	var bNoWrap = !oControl.getAllowWrapping();

	// write the HTML into the render manager
	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapUiHLayout");
	if (bNoWrap) {
		rm.addClass("sapUiHLayoutNoWrap");
	}
	rm.writeClasses();
	rm.write(">"); // div element

	var aChildren = oControl.getContent();
	for (var i = 0; i < aChildren.length; i++) {
		if (bNoWrap) {
			rm.write("<div class='sapUiHLayoutChildWrapper'>");
		}
		rm.renderControl(aChildren[i]);
		if (bNoWrap) {
			rm.write("</div>");
		}
	}

	rm.write("</div>");
};

}; // end of sap/ui/layout/HorizontalLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.ResponsiveFlowLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.layout.ResponsiveFlowLayoutRenderer");

/**
 * @class ResponsiveFlowLayout renderer.
 * @static
 */
sap.ui.layout.ResponsiveFlowLayoutRenderer = {};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            oRm the RenderManager that can be used for writing to the render
 *            output buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
(function() {
	sap.ui.layout.ResponsiveFlowLayoutRenderer.render = function(oRm, oControl) {
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapUiRFL");
		oRm.writeClasses();
		oRm.write(">"); // div element

		// rendering of content happens in oControl.fnRenderContent

		oRm.write("</div>");
	};
}());

}; // end of sap/ui/layout/ResponsiveFlowLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.SplitterRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.layout.SplitterRenderer");

/**
 * @class Splitter renderer. 
 * @static
 */
sap.ui.layout.SplitterRenderer = {
};


/**
 * Renders the main HTML element for the Splitter control and everything else is rendered in a
 * hidden area inside the splitter. The content of that hidden area is shown after rendering to
 * avoid flickering.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.layout.SplitterRenderer.render = function(oRm, oControl){
	var bHorizontal       = oControl.getOrientation() === sap.ui.core.Orientation.Horizontal;
	var sOrientationClass = bHorizontal ? "sapUiLoSplitterH" : "sapUiLoSplitterV";
	var bAnimate          = sap.ui.getCore().getConfiguration().getAnimation();
	
	
	// Make sure we have the main element available before rendering the children so we can use 
	// the element width to calculate before rendering the children.
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapUiLoSplitter");
	oRm.addClass(sOrientationClass);
	if (bAnimate && !oControl._liveResize) {
		// Do not animate via CSS when liveResize is enabled
		oRm.addClass("sapUiLoSplitterAnimated");
	}
	oRm.writeClasses();
	oRm.addStyle("width", oControl.getWidth());
	oRm.addStyle("height", oControl.getHeight());
	oRm.writeStyles();
	oRm.write(">"); // main div
	
	this.renderInitialContent(oRm, oControl);
	
	oRm.write("</div>"); // main control
};

sap.ui.layout.SplitterRenderer.renderInitialContent = function(oRm, oControl) {
	var sId         = oControl.getId();
	var bHorizontal = oControl.getOrientation() === sap.ui.core.Orientation.Horizontal;
	var sSizeType   = bHorizontal ? "width" : "height";
	var sGripIcon = "sap-icon://" + (bHorizontal ? "horizontal" : "vertical") + "-grip";

	var aContents = oControl.getContentAreas();
	var iLen = aContents.length;
	var aCalculatedSizes = oControl.getCalculatedSizes();
	for (var i = 0; i < iLen; ++i) {
		var oLayoutData;
		var sSize = "0";
		if (aCalculatedSizes[i]) {
			// Use precalculated sizes if available
			sSize = aCalculatedSizes[i] + "px";
		} else if (oLayoutData = aContents[i].getLayoutData()) {
			sSize = oLayoutData.getSize();
		}
		
		// Render content control
		oRm.write(
			"<section " +
			"id=\"" + sId + "-content-" + i +"\" " +
			"style=\""+ sSizeType +": " + sSize + ";\" " +
			"class=\"sapUiLoSplitterContent\">"
		);
		oRm.renderControl(aContents[i]);
		oRm.write("</section>");
		
		if (i < iLen - 1) {
			// Render splitter if this is not the last control
			oRm.write(
				"<div id=\"" + sId + "-splitbar-" + i +"\" " +
					"role=\"separator\" " + 
					"title=\"" + oControl._getText("SPLITTER_MOVE") + "\"" +
					"class=\"sapUiLoSplitterBar\" " + 
					"tabindex=\"0\">"
			);
			// Icon ID must start with sId + "-splitbar-" + i so that the target is recognized for resizing
			oRm.writeIcon(sGripIcon, "sapUiLoSplitterBarIcon", { "id" : sId + "-splitbar-" + i + "-icon" });
			oRm.write("</div>");
		}
	}
	
	oRm.write(
		"<div id=\""+ sId +"-overlay\" class=\"sapUiLoSplitterOverlay\" style=\"display: none;\">" +
		"<div id=\""+ sId +"-overlayBar\" class=\"sapUiLoSplitterOverlayBar\">"
	);
	// Icon ID must start with sId + "-splitbar" so that the target is recognized for resizing
	oRm.writeIcon(sGripIcon, "sapUiLoSplitterBarIcon", { "id" : sId + "-splitbar-Overlay-icon" });
	oRm.write(
		"</div>" +
		"</div>"
	);
	
};


}; // end of sap/ui/layout/SplitterRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.VerticalLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.layout.VerticalLayout
jQuery.sap.declare("sap.ui.layout.VerticalLayoutRenderer");

/**
 * @class layout/VerticalLayout renderer.
 * @static
 */
sap.ui.layout.VerticalLayoutRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.layout.VerticalLayoutRenderer.render = function(oRenderManager, oVerticalLayout){
	// convenience variable
	var rm = oRenderManager;

	// return immediately if control is invisible
	if (!oVerticalLayout.getVisible()) {
		return;
	}

	// write the HTML into the render manager
	rm.write("<DIV");
	rm.writeControlData(oVerticalLayout);
	rm.addClass("sapUiVlt");
	rm.addClass("sapuiVlt"); // for compatibility keep the old, wrong class name

	if(oVerticalLayout.getWidth() && oVerticalLayout.getWidth() != ''){
		rm.addStyle("width", oVerticalLayout.getWidth());
	}
	rm.writeStyles();
	rm.writeClasses();
	rm.write(">"); // DIV element

	// render content
	var aContent = oVerticalLayout.getContent();

	for ( var i = 0; i < aContent.length; i++) {
		rm.write("<DIV class=\"sapUiVltCell sapuiVltCell\">"); // for compatibility keep the old, wrong class name
		rm.renderControl(aContent[i]);
		rm.write("</DIV>");
	}

	rm.write("</DIV>");
};

}; // end of sap/ui/layout/VerticalLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.FormLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.layout.form.FormLayoutRenderer");

/**
 * @class FormLayout renderer.
 * @static
 */
sap.ui.layout.form.FormLayoutRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oLayout an object representation of the control that should be rendered
 */
sap.ui.layout.form.FormLayoutRenderer.render = function(oRenderManager, oLayout){
	// convenience variable
	var rm = oRenderManager;

	var oForm = oLayout.getParent();
	if (oForm && oForm instanceof sap.ui.layout.form.Form) {
		this.renderForm(rm, oLayout, oForm);
	}

};

/**
 * Renders the HTML for the given form content, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oLayout an object representation of the Layout control that should be rendered
 * @param {sap.ui.layout.form.Form} oForm, a form control to render its content
 */
sap.ui.layout.form.FormLayoutRenderer.renderForm = function(rm, oLayout, oForm){

	rm.write("<div");
	rm.writeControlData(oLayout);
	rm.addClass(this.getMainClass());
	rm.writeClasses();
	rm.write(">");

	// Form header
	var sSize = sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:sapUiFormTitleSize');
	this.renderTitle(rm, oForm.getTitle(), undefined, false, sSize, oForm.getId());

	this.renderContainers(rm, oLayout, oForm);

	rm.write("</div>");
};

sap.ui.layout.form.FormLayoutRenderer.getMainClass = function(){
	return "sapUiFormLayout";
};

sap.ui.layout.form.FormLayoutRenderer.renderContainers = function(rm, oLayout, oForm){

	var aContainers = oForm.getFormContainers();
	for (var i = 0, il = aContainers.length; i < il; i++) {
		var oContainer = aContainers[i];
		if (oContainer.getVisible()) {
			this.renderContainer(rm, oLayout, oContainer);
		}
	}

};

sap.ui.layout.form.FormLayoutRenderer.renderContainer = function(rm, oLayout, oContainer){

	var bExpandable = oContainer.getExpandable();

	rm.write("<section");
	rm.writeElementData(oContainer);
	rm.addClass("sapUiFormContainer");

	if(oContainer.getTooltip_AsString()) {
		rm.writeAttributeEscaped('title', oContainer.getTooltip_AsString());
	}
	rm.writeClasses();
	rm.write(">");
	this.renderTitle(rm, oContainer.getTitle(), oContainer._oExpandButton, bExpandable, sap.ui.core.TitleLevel.H4, oContainer.getId());

	if (bExpandable) {
		rm.write("<div id='"+oContainer.getId()+"-content'");
		if (!oContainer.getExpanded()) {
			rm.addStyle("display", "none");
			rm.writeStyles();
		}
		rm.write(">");
	}

	var aElements = oContainer.getFormElements();
	for (var j = 0, jl = aElements.length; j < jl; j++) {

		var oElement = aElements[j];

		if (oElement.getVisible()) {
			this.renderElement(rm, oLayout, oElement);
		}

	}
	if (bExpandable) {
		rm.write("</div>");
	}
	rm.write("</section>");

};

sap.ui.layout.form.FormLayoutRenderer.renderElement = function(rm, oLayout, oElement){

	rm.write("<div");
	rm.writeElementData(oElement);
	rm.addClass("sapUiFormElement");
	rm.writeClasses();
	rm.write(">");

	var oLabel = oElement.getLabelControl();
	if (oLabel) {
		rm.renderControl(oLabel);
	}

	var aFields = oElement.getFields();
	if (aFields && aFields.length > 0) {
		for (var k = 0, kl = aFields.length; k < kl; k++) {
			var oField = aFields[k];
			rm.renderControl(oField);
		}
	}
	rm.write("</div>");

};

/*
 * Renders the title for a Form or a FormContainer
 * If this function is overwritten in a Layout please use the right IDs to be sure aria-describedby works fine
 */
sap.ui.layout.form.FormLayoutRenderer.renderTitle = function(rm, oTitle, oExpandButton, bExpander, sLevelDefault, sContentId){

	if (oTitle){
		//determine title level -> if not set use H4 as default
		var sLevel = sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:sapUiFormSubTitleSize');
		if (sLevelDefault) {
			sLevel = sLevelDefault;
		}
		if (typeof oTitle !== "string" && oTitle.getLevel() != sap.ui.core.TitleLevel.Auto) {
			sLevel = oTitle.getLevel();
		}

		// just reuse TextView class because there font size & co. is already defined
		rm.write("<"+sLevel+" ");
		rm.addClass("sapUiFormTitle");
		rm.addClass("sapUiFormTitle"+sLevel);

		if(typeof oTitle !== "string"){
			rm.writeElementData(oTitle);
			if (oTitle.getTooltip_AsString()) {
				rm.writeAttributeEscaped('title', oTitle.getTooltip_AsString());
			}
			if (oTitle.getEmphasized()) {
				rm.addClass("sapUiFormTitleEmph");
			}
		}else {
			rm.writeAttribute("id", sContentId+"--title");
		}
		rm.writeClasses();
		rm.write(">");

		if (bExpander && oExpandButton) {
			rm.renderControl(oExpandButton);
		}
		if (typeof oTitle === "string") {
			// Title is just a string
			rm.writeEscaped(oTitle, true);
		}else{
			// title control
			var sIcon = oTitle.getIcon();

			if (sIcon) {
				var aClasses = [];
				var mAttributes = {};

				mAttributes["id"] = oTitle.getId() + "-ico";
				rm.writeIcon(sIcon, aClasses, mAttributes);
			}
			rm.writeEscaped(oTitle.getText(), true);
		}

		rm.write("</"+sLevel+">");
	}

};
}; // end of sap/ui/layout/form/FormLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.FormRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.layout.form.FormRenderer");

/**
 * @class Form renderer.
 * @static
 */
sap.ui.layout.form.FormRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oForm an object representation of the control that should be rendered
 */
sap.ui.layout.form.FormRenderer.render = function(oRenderManager, oForm){

	if (!oForm.getVisible()) {
		// nothing to render
		return;
	}

	// convenience variable
	var rm = oRenderManager;
	var oLayout = oForm.getLayout();

	// write only a DIV for the form and let the layout render the rest
	rm.write("<div");
	rm.writeControlData(oForm);
	rm.addClass("sapUiForm");

	var sClass = sap.ui.layout.form.FormHelper.addFormClass();
	if (sClass) {
		rm.addClass(sClass);
	}

	if (oForm.getEditable()) {
		rm.addClass("sapUiFormEdit");
		rm.addClass("sapUiFormEdit-CTX");
	}

	if (oForm.getWidth()) {
		rm.addStyle("width", oForm.getWidth());
	}
	if(oForm.getTooltip_AsString()) {
		rm.writeAttributeEscaped('title', oForm.getTooltip_AsString());
	}
	rm.writeClasses();
	rm.writeStyles();

	var mAriaProps = {role: "form"};
	var oTitle = oForm.getTitle();
	if (oTitle) {
		var sId = "";
		if (typeof oTitle == "string") {
			sId = oForm.getId()+"--title";
		} else {
			sId = oTitle.getId();
		}
		mAriaProps["describedby"] = sId;
	}

	rm.writeAccessibilityState(oForm, mAriaProps);

	rm.write(">");

	if (oLayout) {
		// render the layout with the content of this form control
		rm.renderControl(oLayout);
	}else{
		jQuery.sap.log.warning("Form \""+ oForm.getId() +"\" - Layout missing!", "Renderer", "Form");
	}

	rm.write("</div>");
};
}; // end of sap/ui/layout/form/FormRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.GridLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.declare("sap.ui.layout.form.GridLayoutRenderer");


/**
 * @class form/GridLayout renderer.
 * @static
 */
sap.ui.layout.form.GridLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.FormLayoutRenderer);

/**
 * Renders the HTML for the given form content, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oLayout an object representation of the Layout control that should be rendered
 * @param {sap.ui.layout.form.Form} oForm, a form control to render its content
 */
sap.ui.layout.form.GridLayoutRenderer.renderForm = function(rm, oLayout, oForm){

	var bSingleColumn = oLayout.getSingleColumn();
	var iColumns = 16;
	var bSeparatorColumn = false;
	var iColumnsHalf = 0;
	var aContainers = oForm.getFormContainers();
	var iContainerLength = aContainers.length;

	if (bSingleColumn) {
		iColumns = iColumns/2;
		iColumnsHalf = iColumns;
	}else{
		iColumnsHalf = iColumns/2;
		//check if the separator column is needed -> if there are half containers
		for ( var i = 0; i < iContainerLength; i++) {
			var oContainerData = this.getContainerData(oLayout, aContainers[i]);
			if (oContainerData && oContainerData.getHalfGrid()) {
				bSeparatorColumn = true;
				break;
			}
		}
	}

	rm.write("<table role=\"presentation\"");
	rm.writeControlData(oLayout);
	rm.write(" cellpadding=\"0\" cellspacing=\"0\"");
	rm.addStyle("border-collapse", "collapse");
	rm.addStyle("table-layout", "fixed");
	rm.addStyle("width", "100%");
	rm.addClass("sapUiGrid");

	rm.writeStyles();
	rm.writeClasses();
	rm.write(">");
	rm.write("<colgroup>");
	rm.write("<col span="+iColumnsHalf+">");
	if (bSeparatorColumn) {
		rm.write("<col class = \"sapUiGridSpace\"span=1>");
	}
	if (!bSingleColumn) {
		rm.write("<col span="+iColumnsHalf+">");
	}
	rm.write("</colgroup><tbody>");

	// form header as table header
	if (oForm.getTitle()) {
		var iTitleCells = iColumns;
		if (bSeparatorColumn) {
			iTitleCells++;
		}
		rm.write("<tr><th colspan="+iTitleCells+">");
		var sSize = sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:sapUiFormTitleSize');
		this.renderTitle(rm, oForm.getTitle(), undefined, false, sSize, oForm.getId());
		rm.write("</th></tr>")
	}

	var i = 0;
	while (i < iContainerLength) {
		var oContainer = aContainers[i];
		oContainer._checkProperties();
		if (oContainer.getVisible()) {
			var oContainerData = this.getContainerData(oLayout, oContainer);
			if (oContainerData && oContainerData.getHalfGrid() && !bSingleColumn) {
				var oContainer2 = aContainers[i+1];
				var oContainerData2 = undefined;
				if (oContainer2 && oContainer2.getVisible()) {
					oContainerData2 = this.getContainerData(oLayout, oContainer2);
				}
				if (oContainerData2 && oContainerData2.getHalfGrid()) {
					oContainer2._checkProperties();
					this.renderContainerHalfSize(rm, oLayout, oContainer, oContainer2, iColumns);
					i++;
				}else{
					// second container is full size or does not exist -> render only 1 container as half size
					this.renderContainerHalfSize(rm, oLayout, oContainer, undefined, iColumns);
				}
			} else {
				this.renderContainerFullSize(rm, oLayout, oContainer, iColumns, bSeparatorColumn);
			}
		}

		i++;
	}

	if (!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version >= 9) {
		// As IE9 is buggy wth colspan and layout fixed if not all columns are defined least once
		rm.write("<tr style=\"visibility:hidden;\">")
		for ( var i = 0; i < iColumns; i++) {
			rm.write("<td style=\"visibility:hidden; padding:0; height: 0;\"></td>")
		}
		if (bSeparatorColumn) {
			rm.write("<td style=\"visibility:hidden; padding:0; height: 0;\"></td>")
		}
		rm.write("</tr>")
	}

	rm.write("</tbody></table>");

};

sap.ui.layout.form.GridLayoutRenderer.renderContainerFullSize = function(rm, oLayout, oContainer, iColumns, bSeparatorColumn){

	var bExpandable = oContainer.getExpandable();

	// as container has no own DOM Element no element data is rendered.
	// This should not be a problem as it is an element, not a control.

	// render Container tooltip at header cell
	var sTooltip = oContainer.getTooltip_AsString();

	// container header
	if (oContainer.getTitle()) {
		var iTitleCells = iColumns;
		if (bSeparatorColumn) {
			iTitleCells++;
		}
		rm.write("<tr><td colspan="+iTitleCells+" class=\"sapUiGridHeader\"");
		if (sTooltip) {
			rm.writeAttributeEscaped('title', sTooltip);
		}
		rm.write(">");
		this.renderTitle(rm, oContainer.getTitle(), oContainer._oExpandButton, bExpandable, false, oContainer.getId());
		rm.write("</td></tr>")
	}

	if (!bExpandable || oContainer.getExpanded()) {
		// container is not expandable or is expanded -> render elements
		var aElements = oContainer.getFormElements();
		var aReservedCells = [];
		for (var j = 0, jl = aElements.length; j < jl; j++) {

			var oElement = aElements[j];
			if (oElement.getVisible()) {
				var bEmptyRow = aReservedCells[0] && (aReservedCells[0][0] == iColumns);

				rm.write("<tr");
				if (aReservedCells[0] != "full" && !bEmptyRow) {
					rm.writeElementData(oElement);
					rm.addClass("sapUiFormElement");
				}
				rm.writeClasses();
				rm.write(">");
				if (!bEmptyRow) {
					aReservedCells = this.renderElement(rm, oLayout, oElement, false, iColumns, bSeparatorColumn, aReservedCells);
				}else{
					// the complete line is reserved -> render only an empty row
					aReservedCells.splice(0,1);
				}
				rm.write("</tr>")
				if (aReservedCells[0] == "full" || bEmptyRow) {
					// this is a full size element -> just render it again in the next line
					j = j-1;
				}
			}
		}
		if (aReservedCells.length > 0) {
			// still rowspans left -> render dummy rows to fill up
			for ( var i = 0; i < aReservedCells.length; i++) {
			rm.write("<tr></tr>");
			}
		}
	}

};

// no bSeparartor needed because between 2 containers there must be a separator
sap.ui.layout.form.GridLayoutRenderer.renderContainerHalfSize = function(rm, oLayout, oContainer1, oContainer2, iColumns){

	var iContainerColumns = iColumns/2;

	var bExpandable1 = oContainer1.getExpandable();

	var sTooltip1 = oContainer1.getTooltip_AsString();
	var sTooltip2;

	var oTitle1 = oContainer1.getTitle();
	var oTitle2;

	var aElements1 = [];
	if (!bExpandable1 || oContainer1.getExpanded()) {
		aElements1 = oContainer1.getFormElements();
	}
	var iLength1 = aElements1.length;
	var aElements2 = [];
	var iLength2 = 0;

	var bExpandable2 = false;
	if (oContainer2) {
		bExpandable2 = oContainer2.getExpandable();
		sTooltip2 = oContainer2.getTooltip_AsString();
		oTitle2 = oContainer2.getTitle();
		if (!bExpandable2 || oContainer2.getExpanded()) {
			aElements2 = oContainer2.getFormElements();
		}
		iLength2 = aElements2.length;
	}

	if (oTitle1 || oTitle2) {
		// render title row (if one container has a title, the other has none leave the cells empty)
		rm.write("<tr><td colspan="+iContainerColumns+" class=\"sapUiGridHeader\"");
		if (sTooltip1) {
			rm.writeAttributeEscaped('title', sTooltip1);
		}
		rm.write(">");
		if (oTitle1) {
			this.renderTitle(rm, oTitle1, oContainer1._oExpandButton, bExpandable1, false, oContainer1.getId());
		}
		rm.write("</td><td></td><td colspan="+iContainerColumns+" class=\"sapUiGridHeader\"")
		if (sTooltip2) {
			rm.writeAttributeEscaped('title', sTooltip2);
		}
		rm.write(">");
		if (oTitle2) {
			this.renderTitle(rm, oTitle2, oContainer2._oExpandButton, bExpandable2, false, oContainer2.getId());
		}
		rm.write("</td></tr>")
	}

	if ((!bExpandable1 || oContainer1.getExpanded()) || (!bExpandable2 || oContainer2.getExpanded())) {
		var aReservedCells1 = [],
			aReservedCells2 = [];
		var i1 = 0, i2 = 0;

		while (i1 < iLength1 || i2 < iLength2) {
			var oElement1 = aElements1[i1];
			var oElement2 = aElements2[i2];
			var bEmptyRow1 = aReservedCells1[0] && (aReservedCells1[0][0] == iContainerColumns);
			var bEmptyRow2 = aReservedCells2[0] && (aReservedCells2[0][0] == iContainerColumns);

			if ((oElement1 && oElement1.getVisible()) || (oElement2 && oElement2.getVisible()) || bEmptyRow1 || bEmptyRow2) {
				rm.write("<tr>");
				if (!bEmptyRow1) {
					if (oElement1 && oElement1.getVisible() && (!bExpandable1 || oContainer1.getExpanded())) {
						aReservedCells1 = this.renderElement(rm, oLayout, oElement1, true, iContainerColumns, false, aReservedCells1);
					}else{
						rm.write("<td colspan="+iContainerColumns+"></td>")
					}
					if (aReservedCells1[0] != "full") {
						i1++;
					}
				}else {
					if (aReservedCells1[0][2] > 0) {
						// render empty label cell
						rm.write("<td colspan="+aReservedCells1[0][2]+"></td>")
					}
					aReservedCells1.splice(0,1);
				}
				rm.write("<td></td>"); // separator column
				if (!bEmptyRow2) {
					if (oElement2 && oElement2.getVisible() && (!bExpandable2 || oContainer2.getExpanded())) {
						aReservedCells2 = this.renderElement(rm, oLayout, oElement2, true, iContainerColumns, false, aReservedCells2);
					}else{
						rm.write("<td colspan="+iContainerColumns+"></td>")
					}
					if (aReservedCells2[0] != "full") {
						i2++;
					}
				}else {
					if (aReservedCells2[0][2] > 0) {
						// render empty label cell
						rm.write("<td colspan="+aReservedCells2[0][2]+"></td>")
					}
					aReservedCells2.splice(0,1);
				}
				rm.write("</tr>")
			}else{
				i1++;
				i2++;
			}
		}
		if (aReservedCells1.length > 0 || aReservedCells2.length > 0) {
			// still rowspans left -> render dummy rows to fill up
			for ( var i = 0; i < aReservedCells1.length || i < aReservedCells2.length; i++) {
			rm.write("<tr></tr>");
			}
		}
	}
};

/*
 * aReservedCells : Array of already used cells of vCells (Rowspan) of previous elements, "full" if a full-size field
 */
sap.ui.layout.form.GridLayoutRenderer.renderElement = function(rm, oLayout, oElement, bHalf, iCells, bSeparatorColumn, aReservedCells){

	var oLabel = oElement.getLabelControl(); // do not use getLabel() because it returns just text if only text is maintained
	var iLabelFromRowspan = 0;
	var aFields = oElement.getFields();
	var iCellsUsed = 0;
	var iAutoCellsUsed = 0;
	var bMiddleSet = false;

	if (aFields.length == 1 && this.getElementData(oLayout, aFields[0]) && this.getElementData(oLayout, aFields[0]).getHCells() == "full") {
		// field must be full size - render label in a separate row
		if (aReservedCells.length > 0 && aReservedCells[0] != "full") {
			// already rowspans left -> ignore full line and raise error
			jQuery.sap.log.error("Element \""+ oElement.getId() +"\" - Too much fields for one row!", "Renderer", "GridLayout");
			return aReservedCells;
		}
		if (bSeparatorColumn) {
			iCells = iCells + 1;
		}
		if (oLabel && aReservedCells[0] != "full") {
			rm.write("<td colspan="+iCells+" class=\"sapUiGridLabelFull\">");
			rm.renderControl(oLabel);
			rm.write("</td>");
			return ["full"];
		}else{
			aReservedCells.splice(0,1);
			var iRowspan = this.getElementData(oLayout, aFields[0]).getVCells();
			rm.write("<td colspan="+iCells);
			if (iRowspan > 1 && bHalf) {
				// Rowspan on full size cells -> reserve cells for next line (makes only sense in half size containers);
				rm.write(" rowspan="+iRowspan);
				for ( var x = 0; x < iRowspan-1; x++) {
					aReservedCells.push([iCells, undefined, false]);
				}
			}
			rm.write(" >");
			rm.renderControl(aFields[0]);
			rm.write("</td>");
			return aReservedCells;
		}
	}

	if (aReservedCells.length > 0 && aReservedCells[0][0] > 0) {
		// already cells reserved by previous lines via vCells
		// add label cells to free cells because they are reduced by rendering the label
		iCells = iCells - aReservedCells[0][0] + aReservedCells[0][2];
		bMiddleSet = aReservedCells[0][1];
		iLabelFromRowspan = aReservedCells[0][2];
		aReservedCells.splice(0,1);
	}

	var iLabelCells = iLabelFromRowspan;
	if (oLabel || iLabelFromRowspan > 0) {
		iLabelCells = 3;
		if (oLabel && iLabelFromRowspan == 0) {
			// if there is a rowspan in rows above, the label can not have a different size
			var oElementData = this.getElementData(oLayout, oLabel);

			if (oElementData) {
				var sColspan = oElementData.getHCells();
				if (sColspan != "auto" && sColspan != "full") {
					iLabelCells = parseInt(sColspan);
				}
			}
		}

		rm.write("<td colspan="+iLabelCells+" class=\"sapUiGridLabel\">");
		if (oLabel) {
			rm.renderControl(oLabel);
		}
		iCells = iCells - iLabelCells;
		rm.write("</td>");
	}

	if (aFields && aFields.length > 0) {
		// calculate free cells for auto size
		var iAutoCells = iCells;
		var iAutoFields = aFields.length;
		for (var i = 0, il = aFields.length; i < il; i++) {
			var oField = aFields[i];
			var oElementData = this.getElementData(oLayout, oField);
			if (oElementData && oElementData.getHCells() != "auto") {
				iAutoCells = iAutoCells - parseInt(oElementData.getHCells());
				iAutoFields = iAutoFields - 1;
			}
		}

		for (var i = 0, iAutoI = 0, il = aFields.length; i < il; i++) {
			var oField = aFields[i];
			var oElementData = this.getElementData(oLayout, oField);
			var sColspan = "auto";
			var iColspan = 1;
			var iRowspan = 1;
			if (oElementData) {
				sColspan = oElementData.getHCells();
				iRowspan = oElementData.getVCells();
			}
			// calculate real colspan
			if (sColspan == "auto") {
				if (iAutoCells > 0) {
					iColspan = Math.floor(iAutoCells / iAutoFields);
					if (iColspan < 1) {
						iColspan = 1;
					}
					iAutoI++;
					iAutoCellsUsed = iAutoCellsUsed + iColspan;
					if ((iAutoI == iAutoFields) && (iAutoCells > iAutoCellsUsed)) {
						iColspan = iColspan + (iAutoCells-iAutoCellsUsed);
					}
				} else {
					// no space for auto cells -> render it with 1 cell
					iColspan = 1;
				}
			}else{
				iColspan = parseInt(sColspan);
			}
			iCellsUsed = iCellsUsed + iColspan;
			if (iCellsUsed > iCells) {
				// too much cells
				jQuery.sap.log.error("Element \""+ oElement.getId() +"\" - Too much fields for one row!", "Renderer", "GridLayout");
				iCellsUsed = iCellsUsed - iColspan; // to add empty dummy cell
				break;
			}

			if (iRowspan > 1) {
				// Rowspan is used -> reserve cells for next line
				for ( var x = 0; x < iRowspan-1; x++) {
					if (oLabel) {
						iLabelFromRowspan = iLabelCells;
					}
					if (aReservedCells.length > x) {
						aReservedCells[x][0] = aReservedCells[x][0] + iColspan;
						aReservedCells[x][2] = iLabelFromRowspan;
					}else{
						aReservedCells.push([iLabelCells + iColspan, undefined, iLabelFromRowspan]);
					}
				}
			}

			if (bSeparatorColumn && iCellsUsed >= Math.floor(iCells/2) && !bMiddleSet) {
				// for the middle cell add the separator column
				iColspan = iColspan + 1;
				bMiddleSet = true;
				if (iRowspan > 1) {
					// Rowspan is used -> reserve cells for next line
					for ( var x = 0; x < iRowspan-1; x++) {
						aReservedCells[x][1] = true;
					}
				}
			}

			rm.write("<td");
			if (iColspan > 1) {
				rm.write(" colspan="+iColspan);
			}
			if (iRowspan > 1) {
				rm.write(" rowspan="+iRowspan);
			}
			rm.write(" >");
			rm.renderControl(oField);
			rm.write("</td>")
		}
	}
	if (iCellsUsed < iCells) {
		// add an empty cell if not all cells are filled
		var iEmpty = iCells - iCellsUsed;
		if (!bHalf && bSeparatorColumn && !bMiddleSet) {
			iEmpty++;
		}
		rm.write("<td colspan="+iEmpty+" ></td>");
	}

	return aReservedCells;

};

sap.ui.layout.form.GridLayoutRenderer.getContainerData = function(oLayout, oContainer){

	return oLayout.getLayoutDataForElement(oContainer, "sap.ui.layout.form.GridContainerData")

};

sap.ui.layout.form.GridLayoutRenderer.getElementData = function(oLayout, oControl){

	return oLayout.getLayoutDataForElement(oControl, "sap.ui.layout.form.GridElementData")

};
}; // end of sap/ui/layout/form/GridLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveGridLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.ui.layout.form.ResponsiveGridLayoutRenderer");

/**
 * @class form/ResponsiveGridLayout renderer.
 * @static
 */
sap.ui.layout.form.ResponsiveGridLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.FormLayoutRenderer);

sap.ui.layout.form.ResponsiveGridLayoutRenderer.getMainClass = function(){
	return "sapUiFormResGrid";
};

sap.ui.layout.form.ResponsiveGridLayoutRenderer.renderContainers = function(rm, oLayout, oForm){

	var aContainers = oForm.getFormContainers();
	var aVisibleContainers = [];
	var iLength = 0;
	for ( var i = 0; i < aContainers.length; i++) {
		var oContainer = aContainers[i];
		if (oContainer.getVisible()) {
			iLength++;
			aVisibleContainers.push(oContainer);
		}
	}

	if (iLength > 0) {
		// special case: only one container -> do not render an outer Grid
		if (iLength > 1) {
			//render Grid
			rm.renderControl(oLayout._mainGrid);
		}else if(oLayout.mContainers[aVisibleContainers[0].getId()][0]){
			// render panel
			rm.renderControl(oLayout.mContainers[aVisibleContainers[0].getId()][0]);
		}else{
			// render Grid of container
			rm.renderControl(oLayout.mContainers[aVisibleContainers[0].getId()][1]);
		}
	}

};
}; // end of sap/ui/layout/form/ResponsiveGridLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.ui.layout.form.ResponsiveLayoutRenderer");

/**
 * @class ResponsiveLayout renderer.
 * @static
 */
sap.ui.layout.form.ResponsiveLayoutRenderer = sap.ui.core.Renderer.extend(sap.ui.layout.form.FormLayoutRenderer);


sap.ui.layout.form.ResponsiveLayoutRenderer.getMainClass = function(){
	return "sapUiFormResLayout";
};

sap.ui.layout.form.ResponsiveLayoutRenderer.renderContainers = function(rm, oLayout, oForm){

	var aContainers = oForm.getFormContainers();
	var iLength = 0;
	for ( var i = 0; i < aContainers.length; i++) {
		var oContainer = aContainers[i];
		if (oContainer.getVisible()) {
			iLength++;
		}
	}

	if (iLength > 0) {
		// special case: only one container -> do not render an outer ResponsiveFlowLayout
		if (iLength > 1) {
			//render ResponsiveFlowLayout
			rm.renderControl(oLayout._mainRFLayout);
		}else if(oLayout.mContainers[aContainers[0].getId()][0]){
			// render panel
			rm.renderControl(oLayout.mContainers[aContainers[0].getId()][0]);
		}else{
			// render ResponsiveFlowLayout of container
			rm.renderControl(oLayout.mContainers[aContainers[0].getId()][1]);
		}
	}

};

}; // end of sap/ui/layout/form/ResponsiveLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.SimpleFormRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.ui.layout.form.SimpleFormRenderer");

/**
 * @class SimpleForm renderer.
 * @static
 */
sap.ui.layout.form.SimpleFormRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.ui.layout.form.SimpleFormRenderer.render = function(oRm, oControl){

	oControl._bChangedByMe = true;
	// write the HTML into the render manager
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapUiSimpleForm");
	oRm.writeClasses();
	oRm.write(">"); // div element
	var oForm = oControl.getAggregation("form");
	oRm.renderControl(oForm);
	oRm.write("</div>");
	oControl._bChangedByMe = false;

};

}; // end of sap/ui/layout/form/SimpleFormRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

/**
 * Initialization Code and shared classes of library sap.ui.layout (1.24.2)
 */
jQuery.sap.declare("sap.ui.layout.library");
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained

/**
 * SAPUI5 library with layout controls.
 *
 * @namespace
 * @name sap.ui.layout
 * @public
 */


// library dependencies
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained


// delegate further initialization of this library to the Core
sap.ui.getCore().initLibrary({
  name : "sap.ui.layout",
  dependencies : ["sap.ui.core"],
  types: [
    "sap.ui.layout.GridIndent",
    "sap.ui.layout.GridPosition",
    "sap.ui.layout.GridSpan",
    "sap.ui.layout.form.GridElementCells",
    "sap.ui.layout.form.SimpleFormLayout"
  ],
  interfaces: [],
  controls: [
    "sap.ui.layout.Grid",
    "sap.ui.layout.HorizontalLayout",
    "sap.ui.layout.ResponsiveFlowLayout",
    "sap.ui.layout.Splitter",
    "sap.ui.layout.VerticalLayout",
    "sap.ui.layout.form.Form",
    "sap.ui.layout.form.FormLayout",
    "sap.ui.layout.form.GridLayout",
    "sap.ui.layout.form.ResponsiveGridLayout",
    "sap.ui.layout.form.ResponsiveLayout",
    "sap.ui.layout.form.SimpleForm"
  ],
  elements: [
    "sap.ui.layout.GridData",
    "sap.ui.layout.ResponsiveFlowLayoutData",
    "sap.ui.layout.SplitterLayoutData",
    "sap.ui.layout.form.FormContainer",
    "sap.ui.layout.form.FormElement",
    "sap.ui.layout.form.GridContainerData",
    "sap.ui.layout.form.GridElementData"
  ],
  version: "1.24.2"});

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

// Provides data type sap.ui.layout.GridIndent
jQuery.sap.declare('sap.ui.layout.GridIndent');
jQuery.sap.require('sap.ui.base.DataType'); // unlisted dependency retained


/**
 * @class A string type that represents Grid's indent values for large, medium and small screens. Allowed values are separated by space Letters L, M or S followed by number of columns from 1 to 11 that the container has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided in the order large  medium  small.
 *
 * @author SAP SE
 * @final
 * @static
 * @public
 * @ui5-metamodel This simple type also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.GridIndent = sap.ui.base.DataType.createType('sap.ui.layout.GridIndent', {
    isValid : function(vValue) {
      return /^(([Ll](?:[0-9]|1[0-1]))? ?([Mm](?:[0-9]|1[0-1]))? ?([Ss](?:[0-9]|1[0-1]))?)$/.test(vValue);
    }

  },
  sap.ui.base.DataType.getType('string')
);

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.layout.GridPosition.
jQuery.sap.declare("sap.ui.layout.GridPosition");


/**
 * @class Position of the Grid. Can be "Left", "Center" or "Right". "Left" is default.
 *
 * @version 1.24.2
 * @static
 * @public
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.GridPosition = {

	/**
	 * Grid is aligned left.
	 * @public
	 */
	Left : "Left",

	/**
	 * Grid is aligned to the right.
	 * @public
	 */
	Right : "Right",

	/**
	 * Grid is centered on the screen.
	 * @public
	 */
	Center : "Center"

};
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

// Provides data type sap.ui.layout.GridSpan
jQuery.sap.declare('sap.ui.layout.GridSpan');
jQuery.sap.require('sap.ui.base.DataType'); // unlisted dependency retained


/**
 * @class A string type that represents Grid's span values for large, medium and small screens. Allowed values are separated by space Letters L, M or S followed by number of columns from 1 to 12 that the container has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided in the order large  medium  small.
 *
 * @author SAP SE
 * @final
 * @static
 * @public
 * @ui5-metamodel This simple type also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.GridSpan = sap.ui.base.DataType.createType('sap.ui.layout.GridSpan', {
    isValid : function(vValue) {
      return /^(([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(vValue);
    }

  },
  sap.ui.base.DataType.getType('string')
);

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

// Provides data type sap.ui.layout.form.GridElementCells
jQuery.sap.declare('sap.ui.layout.form.GridElementCells');
jQuery.sap.require('sap.ui.base.DataType'); // unlisted dependency retained


/**
 * @class A string that defines the number of used cells in a GridLayout. This can be a number from 1 to 16, "auto" or "full".
 *
 * @static
 * @public
 * @ui5-metamodel This simple type also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.form.GridElementCells = sap.ui.base.DataType.createType('sap.ui.layout.form.GridElementCells', {
    isValid : function(vValue) {
      return /^(auto|full|([1-9]|1[0-6]))$/.test(vValue);
    }

  },
  sap.ui.base.DataType.getType('string')
);

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.ui.layout.form.SimpleFormLayout.
jQuery.sap.declare("sap.ui.layout.form.SimpleFormLayout");


/**
 * @class Available FormLayouts used for the SimpleForm.
 *
 * @version 1.24.2
 * @static
 * @public
 * @since 1.16.0
 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.form.SimpleFormLayout = {

	/**
	 * Uses the ResponsiveLayout for the SimpleForm
	 * @public
	 */
	ResponsiveLayout : "ResponsiveLayout",

	/**
	 * Uses the GridLayout for the SimpleForm
	 * @public
	 */
	GridLayout : "GridLayout",

	/**
	 * Uses the ResponsiveGridLayout for the SimpleForm
	 * @public
	 * @since 1.16.0
	 */
	ResponsiveGridLayout : "ResponsiveGridLayout"

};

// -----------------------------------------------------------------------------
// Begin of Library Initialization coding, copied from shared.js
// -----------------------------------------------------------------------------

// factory for Form to create labels an buttons to be overwritten by commons and mobile library
if (!sap.ui.layout.form.FormHelper) {
	sap.ui.layout.form.FormHelper = {
		createLabel: function(sText){ throw new Error("no Label control available!"); }, /* must return a Label control */
		createButton: function(sId, fPressFunction, oThis){ throw new Error("no Button control available!"); }, /* must return a button control */
		setButtonContent: function(oButton, sText, sTooltip, sIcon, sIconHovered){ throw new Error("no Button control available!"); },
		addFormClass: function(){ return null; },
		bArrowKeySupport: true, /* enables the keyboard support for arrow keys */
		bFinal: false /* if true, the helper must not be overwritten by an other library */
	};
}
}; // end of sap/ui/layout/library.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.Grid') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.Grid.
jQuery.sap.declare("sap.ui.layout.Grid");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Grid.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getVSpacing vSpacing} : float (default: 1)</li>
 * <li>{@link #getHSpacing hSpacing} : float (default: 1)</li>
 * <li>{@link #getPosition position} : sap.ui.layout.GridPosition (default: "Left")</li>
 * <li>{@link #getDefaultSpan defaultSpan} : sap.ui.layout.GridSpan (default: "L3 M6 S12")</li>
 * <li>{@link #getDefaultIndent defaultIndent} : sap.ui.layout.GridIndent (default: "L0 M0 S0")</li>
 * <li>{@link #getContainerQuery containerQuery} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The Grid control is a layout which positions its child controls in a 12 column flow layout. Its children can be specified to take on a variable amount of columns depending on available screen size. With this control it is possible to achieve flexible layouts and line-breaks for large-, medium- and small-sized screens, such as desktop, tablet, and mobile. The Grid control's width can be percentage- or pixel-based and the spacing between its columns can be set to various pre-defined values.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.15.0
 * @name sap.ui.layout.Grid
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.Grid", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
		"vSpacing" : {type : "float", group : "Dimension", defaultValue : 1},
		"hSpacing" : {type : "float", group : "Dimension", defaultValue : 1},
		"position" : {type : "sap.ui.layout.GridPosition", group : "Dimension", defaultValue : "Left"},
		"defaultSpan" : {type : "sap.ui.layout.GridSpan", group : "Behavior", defaultValue : "L3 M6 S12"},
		"defaultIndent" : {type : "sap.ui.layout.GridIndent", group : "Behavior", defaultValue : "L0 M0 S0"},
		"containerQuery" : {type : "boolean", group : "Behavior", defaultValue : false}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.Grid with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.Grid.extend
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Optional. Width of the Grid. If not specified, then 100%.
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.layout.Grid#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#setWidth
 * @function
 */


/**
 * Getter for property <code>vSpacing</code>.
 * Optional. Vertical spacing between the rows in the Grid. In rem, allowed values are 0, 0.5, 1 and 2.
 *
 * Default value is <code>1</code>
 *
 * @return {float} the value of property <code>vSpacing</code>
 * @public
 * @name sap.ui.layout.Grid#getVSpacing
 * @function
 */

/**
 * Setter for property <code>vSpacing</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {float} fVSpacing  new value for property <code>vSpacing</code>
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#setVSpacing
 * @function
 */


/**
 * Getter for property <code>hSpacing</code>.
 * Optional. Horizontal spacing between the content in the Grid. In rem, allowed values are 0, 0.5 , 1 or 2.
 *
 * Default value is <code>1</code>
 *
 * @return {float} the value of property <code>hSpacing</code>
 * @public
 * @name sap.ui.layout.Grid#getHSpacing
 * @function
 */

/**
 * Setter for property <code>hSpacing</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {float} fHSpacing  new value for property <code>hSpacing</code>
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#setHSpacing
 * @function
 */


/**
 * Getter for property <code>position</code>.
 * Optional. Position of the Grid in the window or surrounding container. Possible values are "Center", "Left" and "Right".
 *
 * Default value is <code>"Left"</code>
 *
 * @return {sap.ui.layout.GridPosition} the value of property <code>position</code>
 * @public
 * @name sap.ui.layout.Grid#getPosition
 * @function
 */

/**
 * Setter for property <code>position</code>.
 *
 * Default value is <code>"Left"</code> 
 *
 * @param {sap.ui.layout.GridPosition} oPosition  new value for property <code>position</code>
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#setPosition
 * @function
 */


/**
 * Getter for property <code>defaultSpan</code>.
 * Optional. A string type that represents Grid's default span values for large, medium and small screens for the whole Grid. Allowed values are separated by space Letters L, M or S followed by number of columns from 1 to 12 that the container has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided in the order large medium small.
 *
 * Default value is <code>"L3 M6 S12"</code>
 *
 * @return {sap.ui.layout.GridSpan} the value of property <code>defaultSpan</code>
 * @public
 * @name sap.ui.layout.Grid#getDefaultSpan
 * @function
 */

/**
 * Setter for property <code>defaultSpan</code>.
 *
 * Default value is <code>"L3 M6 S12"</code> 
 *
 * @param {sap.ui.layout.GridSpan} sDefaultSpan  new value for property <code>defaultSpan</code>
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#setDefaultSpan
 * @function
 */


/**
 * Getter for property <code>defaultIndent</code>.
 * Optional. Defines default for the whole Grid numbers of empty columns before the current span begins. It can be defined for large, medium and small screens. Allowed values are separated by space Letters L, M or S followed by number of columns from 0 to 11 that the container has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided in the order large medium small.
 *
 * Default value is <code>"L0 M0 S0"</code>
 *
 * @return {sap.ui.layout.GridIndent} the value of property <code>defaultIndent</code>
 * @public
 * @name sap.ui.layout.Grid#getDefaultIndent
 * @function
 */

/**
 * Setter for property <code>defaultIndent</code>.
 *
 * Default value is <code>"L0 M0 S0"</code> 
 *
 * @param {sap.ui.layout.GridIndent} sDefaultIndent  new value for property <code>defaultIndent</code>
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#setDefaultIndent
 * @function
 */


/**
 * Getter for property <code>containerQuery</code>.
 * If true then not the media Query ( device screen size), but the size of the container surrounding the grid defines the current range (large, medium or small).
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>containerQuery</code>
 * @public
 * @name sap.ui.layout.Grid#getContainerQuery
 * @function
 */

/**
 * Setter for property <code>containerQuery</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bContainerQuery  new value for property <code>containerQuery</code>
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#setContainerQuery
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Controls that are placed into Grid layout.
 * 
 * <strong>Note</strong>: this is the default aggregation for Grid.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.layout.Grid#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.layout.Grid#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.Grid#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.Grid#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.layout.Grid} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Grid#destroyContent
 * @function
 */


// Start of sap\ui\layout\Grid.js
/**
 * This file defines behavior for the control
 */
(function() {
	
	sap.ui.layout.Grid.prototype.init = function() {
		this._iBreakPointTablet = sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[0]; 
		this._iBreakPointDesktop = sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[1];
	};
	
	/**
	 * Used for after-rendering initialization.
	 *
	 * @private
	 */
	sap.ui.layout.Grid.prototype.onAfterRendering = function() {
		if (this.getContainerQuery()) {
			this._sContainerResizeListener = sap.ui.core.ResizeHandler.register(this, jQuery.proxy(this._onParentResize, this));
			this._onParentResize();
		} else {
			sap.ui.Device.media.attachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
		}
	};
	
	sap.ui.layout.Grid.prototype.onBeforeRendering = function() {
		// Cleanup resize event registration before re-rendering
		this._cleanup();
	};
	
	sap.ui.layout.Grid.prototype.exit = function() {
		// Cleanup resize event registration on exit
		this._cleanup();
	};
	
	/**
	 * Clean up the control.
	 * 
	 * @private
	 */
	sap.ui.layout.Grid.prototype._cleanup = function() {	
		// Cleanup resize event registration
		if (this._sContainerResizeListener) {
			sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);
			this._sContainerResizeListener = null;
		}
		
		// Device Media Change handler
		sap.ui.Device.media.detachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
	};
	
	sap.ui.layout.Grid.prototype._handleMediaChange  = function(oParams) {
		this._toggleClass(oParams.name);
	};
	
	sap.ui.layout.Grid.prototype._setBreakPointTablet = function( breakPoint) {
		this._iBreakPointTablet = breakPoint;
	};
	
	sap.ui.layout.Grid.prototype._setBreakPointDesktop = function( breakPoint) {
		this._iBreakPointDesktop = breakPoint;
	};
	
	sap.ui.layout.Grid.prototype._onParentResize = function() {	
		var oDomRef = this.getDomRef();
		// Prove if Dom reference exist, and if not - clean up the references.
		if (!oDomRef) {
			this._cleanup();
			return;
		}

		if (!jQuery(oDomRef).is(":visible")) {
			return;
		}

		var iCntWidth = oDomRef.clientWidth;
		if (iCntWidth <= this._iBreakPointTablet) {
			this._toggleClass("Phone");	
		} else if ((iCntWidth > this._iBreakPointTablet) && (iCntWidth <= this._iBreakPointDesktop)) {
			this._toggleClass("Tablet");
		} else {
			this._toggleClass("Desktop");
		}
	};
	
	
	sap.ui.layout.Grid.prototype._toggleClass = function(sMedia) {
		var $DomRef = this.$();
		if (!$DomRef) return;
		
		if ($DomRef.hasClass("sapUiRespGridMedia-Std-" + sMedia)) {
			return;
		}
		
		$DomRef.toggleClass("sapUiRespGridMedia-Std-" + sMedia, true);     
		if (sMedia === "Phone") {
			$DomRef.toggleClass("sapUiRespGridMedia-Std-Desktop", false).toggleClass("sapUiRespGridMedia-Std-Tablet", false);
		} else if (sMedia === "Tablet") {
			$DomRef.toggleClass("sapUiRespGridMedia-Std-Desktop", false).toggleClass("sapUiRespGridMedia-Std-Phone", false);
		} else {
			$DomRef.toggleClass("sapUiRespGridMedia-Std-Phone", false).toggleClass("sapUiRespGridMedia-Std-Tablet", false);
		}
		
		this.fireEvent("mediaChanged", {media: sMedia});
	};
	
	
	/*
     * Get span information for the Control
     * @param {sap.ui.core.Control} Control instance
     * @return {Object} Grid layout data
     * @private
     */
	sap.ui.layout.Grid.prototype._getLayoutDataForControl = function(oControl) {
		var oLayoutData = oControl.getLayoutData();

		if (!oLayoutData) {
			return undefined;
		} else if (oLayoutData instanceof sap.ui.layout.GridData) {
			return oLayoutData;
		} else if (oLayoutData.getMetadata().getName() == "sap.ui.core.VariantLayoutData") {
			// multiple LayoutData available - search here
			var aLayoutData = oLayoutData.getMultipleLayoutData();
			for ( var i = 0; i < aLayoutData.length; i++) {
				var oLayoutData2 = aLayoutData[i];
				if (oLayoutData2 instanceof sap.ui.layout.GridData) {
					return oLayoutData2;
				}
			}
		}
	};
	
	/*
	 * If LayoutData is changed on one inner control, the whole grid needs to re-render
	 * because it may influence other rows and columns
	 */
	sap.ui.layout.Grid.prototype.onLayoutDataChange = function(oEvent){
		if (this.getDomRef()) {
			// only if already rendered
			this.invalidate();
		}
	};
}());

}; // end of sap/ui/layout/Grid.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.GridData') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.GridData.
jQuery.sap.declare("sap.ui.layout.GridData");

jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained



/**
 * Constructor for a new GridData.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getSpan span} : sap.ui.layout.GridSpan</li>
 * <li>{@link #getSpanL spanL} : int</li>
 * <li>{@link #getSpanM spanM} : int</li>
 * <li>{@link #getSpanS spanS} : int</li>
 * <li>{@link #getIndent indent} : sap.ui.layout.GridIndent</li>
 * <li>{@link #getIndentL indentL} : int</li>
 * <li>{@link #getIndentM indentM} : int</li>
 * <li>{@link #getIndentS indentS} : int</li>
 * <li>{@link #getVisibleL visibleL} : boolean (default: true)</li>
 * <li>{@link #getVisibleM visibleM} : boolean (default: true)</li>
 * <li>{@link #getVisibleS visibleS} : boolean (default: true)</li>
 * <li>{@link #getMoveBackwards moveBackwards} : sap.ui.layout.GridIndent</li>
 * <li>{@link #getMoveForward moveForward} : sap.ui.layout.GridIndent</li>
 * <li>{@link #getLinebreak linebreak} : boolean (default: false)</li>
 * <li>{@link #getLinebreakL linebreakL} : boolean (default: false)</li>
 * <li>{@link #getLinebreakM linebreakM} : boolean (default: false)</li>
 * <li>{@link #getLinebreakS linebreakS} : boolean (default: false)</li>
 * <li>{@link #getSpanLarge spanLarge} : int</li>
 * <li>{@link #getSpanMedium spanMedium} : int</li>
 * <li>{@link #getSpanSmall spanSmall} : int</li>
 * <li>{@link #getIndentLarge indentLarge} : int</li>
 * <li>{@link #getIndentMedium indentMedium} : int</li>
 * <li>{@link #getIndentSmall indentSmall} : int</li>
 * <li>{@link #getVisibleOnLarge visibleOnLarge} : boolean (default: true)</li>
 * <li>{@link #getVisibleOnMedium visibleOnMedium} : boolean (default: true)</li>
 * <li>{@link #getVisibleOnSmall visibleOnSmall} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.LayoutData#constructor sap.ui.core.LayoutData}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Grid layout data
 * @extends sap.ui.core.LayoutData
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.15.0
 * @name sap.ui.layout.GridData
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.LayoutData.extend("sap.ui.layout.GridData", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"span" : {type : "sap.ui.layout.GridSpan", group : "Behavior", defaultValue : null},
		"spanL" : {type : "int", group : "Behavior", defaultValue : null},
		"spanM" : {type : "int", group : "Behavior", defaultValue : null},
		"spanS" : {type : "int", group : "Behavior", defaultValue : null},
		"indent" : {type : "sap.ui.layout.GridIndent", group : "Behavior", defaultValue : null},
		"indentL" : {type : "int", group : "Behavior", defaultValue : null},
		"indentM" : {type : "int", group : "Behavior", defaultValue : null},
		"indentS" : {type : "int", group : "Behavior", defaultValue : null},
		"visibleL" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visibleM" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visibleS" : {type : "boolean", group : "Behavior", defaultValue : true},
		"moveBackwards" : {type : "sap.ui.layout.GridIndent", group : "Misc", defaultValue : null},
		"moveForward" : {type : "sap.ui.layout.GridIndent", group : "Misc", defaultValue : null},
		"linebreak" : {type : "boolean", group : "Misc", defaultValue : false},
		"linebreakL" : {type : "boolean", group : "Misc", defaultValue : false},
		"linebreakM" : {type : "boolean", group : "Misc", defaultValue : false},
		"linebreakS" : {type : "boolean", group : "Misc", defaultValue : false},
		"spanLarge" : {type : "int", group : "Behavior", defaultValue : null, deprecated: true},
		"spanMedium" : {type : "int", group : "Behavior", defaultValue : null, deprecated: true},
		"spanSmall" : {type : "int", group : "Behavior", defaultValue : null, deprecated: true},
		"indentLarge" : {type : "int", group : "Behavior", defaultValue : null, deprecated: true},
		"indentMedium" : {type : "int", group : "Behavior", defaultValue : null, deprecated: true},
		"indentSmall" : {type : "int", group : "Behavior", defaultValue : null, deprecated: true},
		"visibleOnLarge" : {type : "boolean", group : "Behavior", defaultValue : true, deprecated: true},
		"visibleOnMedium" : {type : "boolean", group : "Behavior", defaultValue : true, deprecated: true},
		"visibleOnSmall" : {type : "boolean", group : "Behavior", defaultValue : true, deprecated: true}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.GridData with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.GridData.extend
 * @function
 */


/**
 * Getter for property <code>span</code>.
 * A string type that represents Grid's span values for large, medium and small screens. Allowed values are separated by space Letters L, M or S followed by number of columns from 1 to 12 that the container has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided in the order large medium small.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.layout.GridSpan} the value of property <code>span</code>
 * @public
 * @name sap.ui.layout.GridData#getSpan
 * @function
 */

/**
 * Setter for property <code>span</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.layout.GridSpan} sSpan  new value for property <code>span</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setSpan
 * @function
 */


/**
 * Getter for property <code>spanL</code>.
 * Optional. Defines a span value for large screens. This value overwrites the value for large screens defined in the parameter "span".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>spanL</code>
 * @public
 * @name sap.ui.layout.GridData#getSpanL
 * @function
 */

/**
 * Setter for property <code>spanL</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iSpanL  new value for property <code>spanL</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setSpanL
 * @function
 */


/**
 * Getter for property <code>spanM</code>.
 * Optional. Defines a span value for medium size screens. This value overwrites the value for medium screens defined in the parameter "span".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>spanM</code>
 * @public
 * @name sap.ui.layout.GridData#getSpanM
 * @function
 */

/**
 * Setter for property <code>spanM</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iSpanM  new value for property <code>spanM</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setSpanM
 * @function
 */


/**
 * Getter for property <code>spanS</code>.
 * Optional. Defines a span value for small screens. This value overwrites the value for small screens defined in the parameter "span".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>spanS</code>
 * @public
 * @name sap.ui.layout.GridData#getSpanS
 * @function
 */

/**
 * Setter for property <code>spanS</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iSpanS  new value for property <code>spanS</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setSpanS
 * @function
 */


/**
 * Getter for property <code>indent</code>.
 * A string type that represents Grid's span values for large, medium and small screens. Allowed values are separated by space Letters L, M or S followed by number of columns from 1 to 12 that the container has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided in the order large medium small.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.layout.GridIndent} the value of property <code>indent</code>
 * @public
 * @name sap.ui.layout.GridData#getIndent
 * @function
 */

/**
 * Setter for property <code>indent</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.layout.GridIndent} sIndent  new value for property <code>indent</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setIndent
 * @function
 */


/**
 * Getter for property <code>indentL</code>.
 * Optional. Defines a span value for large screens. This value overwrites the value for large screens defined in the parameter "indent".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>indentL</code>
 * @public
 * @name sap.ui.layout.GridData#getIndentL
 * @function
 */

/**
 * Setter for property <code>indentL</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iIndentL  new value for property <code>indentL</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setIndentL
 * @function
 */


/**
 * Getter for property <code>indentM</code>.
 * Optional. Defines a span value for medium size screens. This value overwrites the value for medium screens defined in the parameter "indent".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>indentM</code>
 * @public
 * @name sap.ui.layout.GridData#getIndentM
 * @function
 */

/**
 * Setter for property <code>indentM</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iIndentM  new value for property <code>indentM</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setIndentM
 * @function
 */


/**
 * Getter for property <code>indentS</code>.
 * Optional. Defines a span value for small screens. This value overwrites the value for small screens defined in the parameter "indent".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>indentS</code>
 * @public
 * @name sap.ui.layout.GridData#getIndentS
 * @function
 */

/**
 * Setter for property <code>indentS</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iIndentS  new value for property <code>indentS</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setIndentS
 * @function
 */


/**
 * Getter for property <code>visibleL</code>.
 * Defines if this Control is visible on Large screens.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visibleL</code>
 * @public
 * @name sap.ui.layout.GridData#getVisibleL
 * @function
 */

/**
 * Setter for property <code>visibleL</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisibleL  new value for property <code>visibleL</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setVisibleL
 * @function
 */


/**
 * Getter for property <code>visibleM</code>.
 * Defines if this Control is visible on Medium size screens.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visibleM</code>
 * @public
 * @name sap.ui.layout.GridData#getVisibleM
 * @function
 */

/**
 * Setter for property <code>visibleM</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisibleM  new value for property <code>visibleM</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setVisibleM
 * @function
 */


/**
 * Getter for property <code>visibleS</code>.
 * Defines if this Control is visible on small screens.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visibleS</code>
 * @public
 * @name sap.ui.layout.GridData#getVisibleS
 * @function
 */

/**
 * Setter for property <code>visibleS</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisibleS  new value for property <code>visibleS</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setVisibleS
 * @function
 */


/**
 * Getter for property <code>moveBackwards</code>.
 * Optional. Moves a cell backwards so many columns as specified.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.layout.GridIndent} the value of property <code>moveBackwards</code>
 * @public
 * @name sap.ui.layout.GridData#getMoveBackwards
 * @function
 */

/**
 * Setter for property <code>moveBackwards</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.layout.GridIndent} sMoveBackwards  new value for property <code>moveBackwards</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setMoveBackwards
 * @function
 */


/**
 * Getter for property <code>moveForward</code>.
 * Optional. Moves a cell forwards so many columns as specified.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.layout.GridIndent} the value of property <code>moveForward</code>
 * @public
 * @name sap.ui.layout.GridData#getMoveForward
 * @function
 */

/**
 * Setter for property <code>moveForward</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.layout.GridIndent} sMoveForward  new value for property <code>moveForward</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setMoveForward
 * @function
 */


/**
 * Getter for property <code>linebreak</code>.
 * Optional. If this property is set to true, the control on all-size screens causes a line break within the Grid and becomes the first within the next line.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>linebreak</code>
 * @public
 * @name sap.ui.layout.GridData#getLinebreak
 * @function
 */

/**
 * Setter for property <code>linebreak</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bLinebreak  new value for property <code>linebreak</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setLinebreak
 * @function
 */


/**
 * Getter for property <code>linebreakL</code>.
 * Optional. If this property is set to true, the control on large screens causes a line break within the Grid and becomes the first within the next line.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>linebreakL</code>
 * @public
 * @name sap.ui.layout.GridData#getLinebreakL
 * @function
 */

/**
 * Setter for property <code>linebreakL</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bLinebreakL  new value for property <code>linebreakL</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setLinebreakL
 * @function
 */


/**
 * Getter for property <code>linebreakM</code>.
 * Optional. If this property is set to true, the control on medium sized screens causes a line break within the Grid and becomes the first within the next line.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>linebreakM</code>
 * @public
 * @name sap.ui.layout.GridData#getLinebreakM
 * @function
 */

/**
 * Setter for property <code>linebreakM</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bLinebreakM  new value for property <code>linebreakM</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setLinebreakM
 * @function
 */


/**
 * Getter for property <code>linebreakS</code>.
 * Optional. If this property is set to true, the control on small screens causes a line break within the Grid and becomes the first within the next line.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>linebreakS</code>
 * @public
 * @name sap.ui.layout.GridData#getLinebreakS
 * @function
 */

/**
 * Setter for property <code>linebreakS</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bLinebreakS  new value for property <code>linebreakS</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.GridData#setLinebreakS
 * @function
 */


/**
 * Getter for property <code>spanLarge</code>.
 * Deprecated. Defines a span value for large screens. This value overwrites the value for large screens defined in the parameter "span".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>spanLarge</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use spanL instead.
 * @name sap.ui.layout.GridData#getSpanLarge
 * @function
 */

/**
 * Setter for property <code>spanLarge</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iSpanLarge  new value for property <code>spanLarge</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use spanL instead.
 * @name sap.ui.layout.GridData#setSpanLarge
 * @function
 */


/**
 * Getter for property <code>spanMedium</code>.
 * Deprecated. Defines a span value for medium size screens. This value overwrites the value for medium screens defined in the parameter "span".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>spanMedium</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use spanM instead.
 * @name sap.ui.layout.GridData#getSpanMedium
 * @function
 */

/**
 * Setter for property <code>spanMedium</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iSpanMedium  new value for property <code>spanMedium</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use spanM instead.
 * @name sap.ui.layout.GridData#setSpanMedium
 * @function
 */


/**
 * Getter for property <code>spanSmall</code>.
 * Deprecated. Defines a span value for small screens. This value overwrites the value for small screens defined in the parameter "span".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>spanSmall</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use spanS instead.
 * @name sap.ui.layout.GridData#getSpanSmall
 * @function
 */

/**
 * Setter for property <code>spanSmall</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iSpanSmall  new value for property <code>spanSmall</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use spanS instead.
 * @name sap.ui.layout.GridData#setSpanSmall
 * @function
 */


/**
 * Getter for property <code>indentLarge</code>.
 * Deprecated. Defines a span value for large screens. This value overwrites the value for large screens defined in the parameter "indent".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>indentLarge</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use indentL instead.
 * @name sap.ui.layout.GridData#getIndentLarge
 * @function
 */

/**
 * Setter for property <code>indentLarge</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iIndentLarge  new value for property <code>indentLarge</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use indentL instead.
 * @name sap.ui.layout.GridData#setIndentLarge
 * @function
 */


/**
 * Getter for property <code>indentMedium</code>.
 * Deprecated. Defines a span value for medium size screens. This value overwrites the value for medium screens defined in the parameter "indent".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>indentMedium</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use indentM instead.
 * @name sap.ui.layout.GridData#getIndentMedium
 * @function
 */

/**
 * Setter for property <code>indentMedium</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iIndentMedium  new value for property <code>indentMedium</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use indentM instead.
 * @name sap.ui.layout.GridData#setIndentMedium
 * @function
 */


/**
 * Getter for property <code>indentSmall</code>.
 * Deprecated. Defines a span value for small screens. This value overwrites the value for small screens defined in the parameter "indent".
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>indentSmall</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use indentS instead.
 * @name sap.ui.layout.GridData#getIndentSmall
 * @function
 */

/**
 * Setter for property <code>indentSmall</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iIndentSmall  new value for property <code>indentSmall</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use indentS instead.
 * @name sap.ui.layout.GridData#setIndentSmall
 * @function
 */


/**
 * Getter for property <code>visibleOnLarge</code>.
 * Deprecated. Defines if this Control is visible on Large screens.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visibleOnLarge</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use visibleL instead.
 * @name sap.ui.layout.GridData#getVisibleOnLarge
 * @function
 */

/**
 * Setter for property <code>visibleOnLarge</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisibleOnLarge  new value for property <code>visibleOnLarge</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use visibleL instead.
 * @name sap.ui.layout.GridData#setVisibleOnLarge
 * @function
 */


/**
 * Getter for property <code>visibleOnMedium</code>.
 * Deprecated. Defines if this Control is visible on Medium size screens.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visibleOnMedium</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use visibleM instead.
 * @name sap.ui.layout.GridData#getVisibleOnMedium
 * @function
 */

/**
 * Setter for property <code>visibleOnMedium</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisibleOnMedium  new value for property <code>visibleOnMedium</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use visibleM instead.
 * @name sap.ui.layout.GridData#setVisibleOnMedium
 * @function
 */


/**
 * Getter for property <code>visibleOnSmall</code>.
 * Deprecated. Defines if this Control is visible on small screens.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visibleOnSmall</code>
 * @public
 * @deprecated Since version 1.17.1. 
 * Use visibleS instead.
 * @name sap.ui.layout.GridData#getVisibleOnSmall
 * @function
 */

/**
 * Setter for property <code>visibleOnSmall</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisibleOnSmall  new value for property <code>visibleOnSmall</code>
 * @return {sap.ui.layout.GridData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.17.1. 
 * Use visibleS instead.
 * @name sap.ui.layout.GridData#setVisibleOnSmall
 * @function
 */


// Start of sap\ui\layout\GridData.js
/**
 * This file defines behavior for the control
 */
(function() {

	sap.ui.layout.GridData.prototype._setStylesInternal = function(sStyles) {
		if (sStyles && sStyles.length > 0) {
			this._sStylesInternal = sStyles;
		} else {
			this._sStylesInternal = undefined;
		}
	};
	
	/*
	 * Get span information for the large screens
	 * @return {int} the value of the span 
	 * @private
	 */
	sap.ui.layout.GridData.prototype._getEffectiveSpanLarge = function() {

		var iSpan = this.getSpanL();
		if (iSpan && (iSpan > 0) && (iSpan < 13)) {
			return iSpan;
		}
		
		var SPANPATTERN = /L([1-9]|1[0-2])(?:\s|$)/i;

		var aSpan = SPANPATTERN.exec(this.getSpan());

		if (aSpan) {
			var span = aSpan[0];
			if (span) {
				span = span.toUpperCase();
				if (span.substr(0,1) === "L") {
					return parseInt(span.substr(1));
				}
			}
		}
		return undefined;
	};
	
	/*
	 * Get span information for the medium screens 
	 * @return {int} the value of the span 
	 * @private
	 */
	sap.ui.layout.GridData.prototype._getEffectiveSpanMedium = function() {
		var iSpan = this.getSpanM();
		if (iSpan && (iSpan > 0) && (iSpan < 13)) {
			return iSpan;
		}
				
		var SPANPATTERN = /M([1-9]|1[0-2])(?:\s|$)/i;

		var aSpan = SPANPATTERN.exec(this.getSpan());

		if (aSpan) {
			var span = aSpan[0];
			if (span) {
				span = span.toUpperCase();
				if (span.substr(0,1) === "M") {
					return parseInt(span.substr(1));
				}
			}
		}
		return undefined;
	};
	
	/*
	 * Get span information for the small screens
	 * @return {int} the value of the span 
	 * @private
	 */
	sap.ui.layout.GridData.prototype._getEffectiveSpanSmall = function() {
		var iSpan = this.getSpanS();
		if (iSpan && (iSpan > 0) && (iSpan < 13)) {
			return iSpan;
		}
		
		
		var SPANPATTERN = /S([1-9]|1[0-2])(?:\s|$)/i;

		var aSpan = SPANPATTERN.exec(this.getSpan());

		if (aSpan) {
			var span = aSpan[0];
			if (span) {
				span = span.toUpperCase();
				if (span.substr(0,1) === "S") {
					return parseInt(span.substr(1));
				}
			}
		}
		return undefined;
	};
	
	
	// Deprecated properties handling
	//Setter
	sap.ui.layout.GridData.prototype.setSpanLarge = function(iSpan) {
		this.setSpanL(iSpan);
		jQuery.sap.log.warning("Deprecated property spanLarge is used, please use spanL instead.");
	};
	
	sap.ui.layout.GridData.prototype.setSpanMedium = function(iSpan) {
		this.setSpanM(iSpan);
		jQuery.sap.log.warning("Deprecated property spanMedium is used, please use spanM instead.");
	};
	
	sap.ui.layout.GridData.prototype.setSpanSmall = function(iSpan) {
		this.setSpanS(iSpan);
		jQuery.sap.log.warning("Deprecated property spanSmall is used, please use spanS instead.");
	};
	
	sap.ui.layout.GridData.prototype.setIndentLarge = function(iIndent) {
		this.setIndentL(iIndent);
		jQuery.sap.log.warning("Deprecated property indentLarge is used, please use indentL instead.");
	};
	
	sap.ui.layout.GridData.prototype.setIndentMedium = function(iIndent) {
		this.setIndentM(iIndent);
		jQuery.sap.log.warning("Deprecated property indentMedium is used, please use indentM instead.");
	};
	
	sap.ui.layout.GridData.prototype.setIndentSmall = function(iIndent) {
		this.setIndentS(iIndent);
		jQuery.sap.log.warning("Deprecated property indentSmall is used, please use indentS instead.");
	};
	
	sap.ui.layout.GridData.prototype.setVisibleOnLarge = function(bVisible) {
		this.setVisibleL(bVisible);
		jQuery.sap.log.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");
	};
	
	sap.ui.layout.GridData.prototype.setVisibleOnMedium = function(bVisible) {
		this.setVisibleM(bVisible);
		jQuery.sap.log.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");
	};
	
	sap.ui.layout.GridData.prototype.setVisibleOnSmall = function(bVisible) {
		this.setVisibleS(bVisible);
		jQuery.sap.log.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");
	};
	
	
	// Getter 
	sap.ui.layout.GridData.prototype.getSpanLarge = function() {
		jQuery.sap.log.warning("Deprecated property spanLarge is used, please use spanL instead.");
		return this.getSpanL();
	};
	
	sap.ui.layout.GridData.prototype.getSpanMedium = function() {
		jQuery.sap.log.warning("Deprecated property spanMedium is used, please use spanM instead.");
		return this.getSpanM();
	};
	
	sap.ui.layout.GridData.prototype.getSpanSmall = function() {
		jQuery.sap.log.warning("Deprecated property spanSmall is used, please use spanS instead.");
		return this.getSpanS();
	};
	
	sap.ui.layout.GridData.prototype.getIndentLarge = function() {
		jQuery.sap.log.warning("Deprecated property indentLarge is used, please use indentL instead.");
		return this.getIndentL();
	};
	
	sap.ui.layout.GridData.prototype.getIndentMedium = function() {
		jQuery.sap.log.warning("Deprecated property indentMedium is used, please use indentM instead.");
		return this.getIndentM();
	};
	
	sap.ui.layout.GridData.prototype.getIndentSmall = function() {
		jQuery.sap.log.warning("Deprecated property indentSmall is used, please use indentS instead.");
		return this.getIndentS();
	};
	
	sap.ui.layout.GridData.prototype.getVisibleOnLarge = function() {
		jQuery.sap.log.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");
		return this.getVisibleL();
	};
	
	sap.ui.layout.GridData.prototype.getVisibleOnMedium = function() {
		jQuery.sap.log.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");
		return this.getVisibleM();
	};
	
	sap.ui.layout.GridData.prototype.getVisibleOnSmall = function() {
		jQuery.sap.log.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");
		return this.getVisibleS();
	};
	
}());

}; // end of sap/ui/layout/GridData.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.HorizontalLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.HorizontalLayout.
jQuery.sap.declare("sap.ui.layout.HorizontalLayout");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new HorizontalLayout.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getAllowWrapping allowWrapping} : boolean (default: false)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A layout that provides support for horizontal alignment of controls
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.HorizontalLayout
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.HorizontalLayout", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"allowWrapping" : {type : "boolean", group : "Misc", defaultValue : false},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.HorizontalLayout with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.HorizontalLayout.extend
 * @function
 */


/**
 * Getter for property <code>allowWrapping</code>.
 * Specifies whether the content inside the Layout shall be line-wrapped in the case that there is less horizontal space available than required.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>allowWrapping</code>
 * @public
 * @name sap.ui.layout.HorizontalLayout#getAllowWrapping
 * @function
 */

/**
 * Setter for property <code>allowWrapping</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bAllowWrapping  new value for property <code>allowWrapping</code>
 * @return {sap.ui.layout.HorizontalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.HorizontalLayout#setAllowWrapping
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Whether this HorizontalLayout is visible.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.layout.HorizontalLayout#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.layout.HorizontalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.HorizontalLayout#setVisible
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The controls inside this layout
 * 
 * <strong>Note</strong>: this is the default aggregation for HorizontalLayout.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.layout.HorizontalLayout#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.layout.HorizontalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.HorizontalLayout#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.layout.HorizontalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.HorizontalLayout#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.layout.HorizontalLayout#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.HorizontalLayout#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.HorizontalLayout#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.layout.HorizontalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.HorizontalLayout#destroyContent
 * @function
 */


// Start of sap\ui\layout\HorizontalLayout.js

}; // end of sap/ui/layout/HorizontalLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.ResponsiveFlowLayoutData') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.ResponsiveFlowLayoutData.
jQuery.sap.declare("sap.ui.layout.ResponsiveFlowLayoutData");

jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained



/**
 * Constructor for a new ResponsiveFlowLayoutData.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getMinWidth minWidth} : int (default: 100)</li>
 * <li>{@link #getWeight weight} : int (default: 1)</li>
 * <li>{@link #getLinebreak linebreak} : boolean (default: false)</li>
 * <li>{@link #getMargin margin} : boolean (default: true)</li>
 * <li>{@link #getLinebreakable linebreakable} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.LayoutData#constructor sap.ui.core.LayoutData}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * This is a LayoutData Element that can be added to a control if this control is used within a ResponsiveFlowLayout
 * @extends sap.ui.core.LayoutData
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.ResponsiveFlowLayoutData
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.LayoutData.extend("sap.ui.layout.ResponsiveFlowLayoutData", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"minWidth" : {type : "int", group : "Misc", defaultValue : 100},
		"weight" : {type : "int", group : "Misc", defaultValue : 1},
		"linebreak" : {type : "boolean", group : "Misc", defaultValue : false},
		"margin" : {type : "boolean", group : "Misc", defaultValue : true},
		"linebreakable" : {type : "boolean", group : "Misc", defaultValue : true}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.ResponsiveFlowLayoutData with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.ResponsiveFlowLayoutData.extend
 * @function
 */


/**
 * Getter for property <code>minWidth</code>.
 * This is the minimal size in pixels of an ResponsiveFlowLayout element. The element will be shrinked till this value.
 *
 * Default value is <code>100</code>
 *
 * @return {int} the value of property <code>minWidth</code>
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#getMinWidth
 * @function
 */

/**
 * Setter for property <code>minWidth</code>.
 *
 * Default value is <code>100</code> 
 *
 * @param {int} iMinWidth  new value for property <code>minWidth</code>
 * @return {sap.ui.layout.ResponsiveFlowLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#setMinWidth
 * @function
 */


/**
 * Getter for property <code>weight</code>.
 * This is the weight of the element that influences the resulting width. If there are several elements within a row of the ResponsiveFlowLayout each element could have another weight. The bigger the weight of a single element the wider it will be pumped up --> a bigger weight result a bigger width.
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>weight</code>
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#getWeight
 * @function
 */

/**
 * Setter for property <code>weight</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iWeight  new value for property <code>weight</code>
 * @return {sap.ui.layout.ResponsiveFlowLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#setWeight
 * @function
 */


/**
 * Getter for property <code>linebreak</code>.
 * If this property is set the control where this LayoutData is added to will always cause a linebreak within the ResponsiveFlowLayout
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>linebreak</code>
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#getLinebreak
 * @function
 */

/**
 * Setter for property <code>linebreak</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bLinebreak  new value for property <code>linebreak</code>
 * @return {sap.ui.layout.ResponsiveFlowLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#setLinebreak
 * @function
 */


/**
 * Getter for property <code>margin</code>.
 * This property prevents any margin of the element if set to false
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>margin</code>
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#getMargin
 * @function
 */

/**
 * Setter for property <code>margin</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bMargin  new value for property <code>margin</code>
 * @return {sap.ui.layout.ResponsiveFlowLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#setMargin
 * @function
 */


/**
 * Getter for property <code>linebreakable</code>.
 * If this value shows if an element can be wrapped into a new line. If this value is set to false, the min-width will be set to 0 and the wrapping is up to the previous element.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>linebreakable</code>
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#getLinebreakable
 * @function
 */

/**
 * Setter for property <code>linebreakable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bLinebreakable  new value for property <code>linebreakable</code>
 * @return {sap.ui.layout.ResponsiveFlowLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayoutData#setLinebreakable
 * @function
 */


// Start of sap\ui\layout\ResponsiveFlowLayoutData.js
/*!
 * @copyright@
 */
sap.ui.layout.ResponsiveFlowLayoutData.MIN_WIDTH = 100;
sap.ui.layout.ResponsiveFlowLayoutData.WEIGHT = 1;
sap.ui.layout.ResponsiveFlowLayoutData.LINEBREAK = false;
sap.ui.layout.ResponsiveFlowLayoutData.MARGIN = true;
sap.ui.layout.ResponsiveFlowLayoutData.LINEBREAKABLE = true;

sap.ui.layout.ResponsiveFlowLayoutData.prototype.setWeight = function(iWeight) {
	if (iWeight >= 1) {
		this.setProperty("weight", iWeight);
	} else {
		jQuery.sap.log.warning("Values smaller than 1 are not valid. Default value '1' is used instead", this);
		this.setProperty("weight", sap.ui.layout.ResponsiveFlowLayoutData.WEIGHT);
	}

	return this;
};

sap.ui.layout.ResponsiveFlowLayoutData.prototype.setLinebreak = function(bLinebreak) {
	// if the element should not be linebreakable and a forced linebreak should
	// be set
	if (this.getLinebreakable() == false && bLinebreak) {
		jQuery.sap.log.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense! Please set either 'linebreak' or 'linebreakable'", this);
	} else {
		this.setProperty("linebreak", bLinebreak);
	}
};

sap.ui.layout.ResponsiveFlowLayoutData.prototype.setLinebreakable = function(bLinebreakable) {
	// if the element has a forced linebreak and the element should be set to
	// not linebreakable
	if (this.getLinebreak() === true && bLinebreakable === false) {
		jQuery.sap.log.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense! Please set either 'linebreak' or 'linebreakable'", this);
	} else {
		this.setProperty("linebreakable", bLinebreakable);
		// this.setMinWidth(0);
	}
};
}; // end of sap/ui/layout/ResponsiveFlowLayoutData.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.Splitter') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.Splitter.
jQuery.sap.declare("sap.ui.layout.Splitter");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Splitter.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getOrientation orientation} : sap.ui.core.Orientation (default: sap.ui.core.Orientation.Horizontal)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize (default: '100%')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContentAreas contentAreas} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.ui.layout.Splitter#event:resize resize} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * 
 * A layout that contains several content areas. The content that is added to the splitter should contain LayoutData of the type SplitterLayoutData that defines its size and size contraints.
 * 
 * By adding or changing SplitterLayoutData to the controls that make up the content areas, the size can be changed programatically. Additionally the contents can be made non-resizable individually and a minimal size (in px) can be set.
 * 
 * The orientation of the splitter can be set to horizontal (default) or vertical. All content areas of the splitter will be arranged in that way. In order to split vertically and horizontally at the same time, Splitters need to be nested.
 * 
 * The splitter bars can be focused to enable resizing of the content areas via keyboard. The contents size can be manipulated when the splitter bar is focused and Shift-Left/Down/Right/Up are pressed. When Shift-Home/End are pressed, the contents are set their minimum or maximum size (keep in mind though, that resizing an auto-size content-area next to another auto-size one might lead to the effect that the former does not take its maximum size but only the maximum size before recalculating auto sizes).
 * 
 * The splitter bars used for resizing the contents by the user can be set to different widths (or heights in vertical mode) and the splitter will automatically resize the other contents accordingly. In case the splitter bar is resized after the splitter has rendered, a manual resize has to be triggered by invoking triggerResize() on the Splitter.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.22.0
 * @experimental Since version 1.22.0. 
 * API is not yet finished and might change completely
 * @name sap.ui.layout.Splitter
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.Splitter", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"orientation" : {type : "sap.ui.core.Orientation", group : "Behavior", defaultValue : sap.ui.core.Orientation.Horizontal},
		"width" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '100%'},
		"height" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '100%'}
	},
	defaultAggregation : "contentAreas",
	aggregations : {
		"contentAreas" : {type : "sap.ui.core.Control", multiple : true, singularName : "contentArea"}
	},
	events : {
		"resize" : {}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.Splitter with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.Splitter.extend
 * @function
 */

sap.ui.layout.Splitter.M_EVENTS = {'resize':'resize'};


/**
 * Getter for property <code>orientation</code>.
 * Whether to split the contents horizontally (default) or vertically.
 *
 * Default value is <code>Horizontal</code>
 *
 * @return {sap.ui.core.Orientation} the value of property <code>orientation</code>
 * @public
 * @name sap.ui.layout.Splitter#getOrientation
 * @function
 */

/**
 * Setter for property <code>orientation</code>.
 *
 * Default value is <code>Horizontal</code> 
 *
 * @param {sap.ui.core.Orientation} oOrientation  new value for property <code>orientation</code>
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#setOrientation
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * The width of the control
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.layout.Splitter#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#setWidth
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * The height of the control
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.ui.layout.Splitter#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#setHeight
 * @function
 */


/**
 * Getter for aggregation <code>contentAreas</code>.<br/>
 * The content areas to be split. The control will show n-1 splitter bars between n controls in this aggregation.
 * 
 * <strong>Note</strong>: this is the default aggregation for Splitter.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.layout.Splitter#getContentAreas
 * @function
 */


/**
 * Inserts a contentArea into the aggregation named <code>contentAreas</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContentArea the contentArea to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the contentArea should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the contentArea is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the contentArea is inserted at 
 *             the last position        
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#insertContentArea
 * @function
 */

/**
 * Adds some contentArea <code>oContentArea</code> 
 * to the aggregation named <code>contentAreas</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContentArea the contentArea to add; if empty, nothing is inserted
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#addContentArea
 * @function
 */

/**
 * Removes an contentArea from the aggregation named <code>contentAreas</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContentArea the contentArea to remove or its index or id
 * @return {sap.ui.core.Control} the removed contentArea or null
 * @public
 * @name sap.ui.layout.Splitter#removeContentArea
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>contentAreas</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.Splitter#removeAllContentAreas
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>contentAreas</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContentArea the contentArea whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.Splitter#indexOfContentArea
 * @function
 */
	

/**
 * Destroys all the contentAreas in the aggregation 
 * named <code>contentAreas</code>.
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#destroyContentAreas
 * @function
 */


/**
 * Event is fired when contents are resized.
 *
 * @name sap.ui.layout.Splitter#resize
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters
 * @param {string} oControlEvent.getParameters.id The ID of the splitter control. The splitter control can also be accessed by calling getSource() on the event.
 * @param {int[]} oControlEvent.getParameters.oldSizes An array of values representing the old (pixel-)sizes of the splitter contents
 * @param {int[]} oControlEvent.getParameters.newSizes An array of values representing the new (pixel-)sizes of the splitter contents
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'resize' event of this <code>sap.ui.layout.Splitter</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.ui.layout.Splitter</code>.<br/> itself. 
 *  
 * Event is fired when contents are resized.
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.ui.layout.Splitter</code>.<br/> itself.
 *
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#attachResize
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'resize' event of this <code>sap.ui.layout.Splitter</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.Splitter#detachResize
 * @function
 */

/**
 * Fire event resize to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'id' of type <code>string</code> The ID of the splitter control. The splitter control can also be accessed by calling getSource() on the event.</li>
 * <li>'oldSizes' of type <code>int[]</code> An array of values representing the old (pixel-)sizes of the splitter contents</li>
 * <li>'newSizes' of type <code>int[]</code> An array of values representing the new (pixel-)sizes of the splitter contents</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.ui.layout.Splitter} <code>this</code> to allow method chaining
 * @protected
 * @name sap.ui.layout.Splitter#fireResize
 * @function
 */


// Start of sap\ui\layout\Splitter.js
(function(window, undefined) {
"use strict";

// "Hidden" resource bundle instance
var oResourceBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");

//////////////////////////////////////// "Static" Properties ///////////////////////////////////////


////////////////////////////////////////// Public Methods //////////////////////////////////////////

sap.ui.layout.Splitter.prototype.init = function() {
	this._needsInvalidation = false;
	this._liveResize        = true;
	this._keyboardEnabled   = true;
	this._bHorizontal       = true;
	/** @type {Number[]} */
	this._calculatedSizes   = [];
	this._move              = {};
	
	this._resizeTimeout     = null;
	
	// Context bound method for easy (de-)registering at the ResizeHandler
	this._resizeCallback    = this._delayedResize.bind(this);
	this._resizeHandlerId   = null;
	this.enableAutoResize();
	
	// Bound versions for event handler registration
	this._boundBarMoveEnd   = this._onBarMoveEnd.bind(this);
	this._boundBarMove      = this._onBarMove.bind(this);
	
	// Switch resizing parameters based on orientation - this must be done to initialize the values
	this._switchOrientation();
	
	// Create bound listener functions for keyboard event handling
	this._keyListeners = {
		increase     : this._onKeyboardResize.bind(this, "inc"),
		decrease     : this._onKeyboardResize.bind(this, "dec"),
		increaseMore : this._onKeyboardResize.bind(this, "incMore"),
		decreaseMore : this._onKeyboardResize.bind(this, "decMore"),
		max          : this._onKeyboardResize.bind(this, "max"),
		min          : this._onKeyboardResize.bind(this, "min")
	};
	this._enableKeyboardListeners();
	
};

sap.ui.layout.Splitter.prototype.exit = function() {
	this.disableAutoResize();
	delete this._resizeCallback;

	delete this._boundBarMoveEnd;
	delete this._boundBarMove;
	
	delete this._$SplitterOverlay;
	delete this._$SplitterOverlayBar;
};

/**
 * This method  triggers a resize on the Splitter - meaning it forces the Splitter to recalculate
 * all sizes.
 * This method should only be used in rare cases, for example when the CSS that defines the sizes
 * of the splitter bars changes without triggering a rerendering of the splitter.
 * 
 * @param {boolean} [forceDirectly=false] Do not delay the resize, trigger it right now.
 * @public
 */
sap.ui.layout.Splitter.prototype.triggerResize = function(forceDirectly) {
	if (forceDirectly) {
		this._resize();
	} else {
		this._delayedResize();
	}
};

//////////////////////////////////////// "Protected" Methods ///////////////////////////////////////

/**
 * Returns the current actual content sizes as pixel value - these values can change with every 
 * resize.
 * 
 * @returns {Number[]} Array of px values that correspond to the content area sizes
 * @protected
 * @deprecated This method is declared as protected in order to assess the need for this feature. It is declared as deprecated because the API might change in case the need for this is high enough to make it part of the official Splitter interface
 */
sap.ui.layout.Splitter.prototype.getCalculatedSizes = function() {
	return this._calculatedSizes;
};

/**
 * Enables the resize handler for this control, this leads to an automatic resize of
 * the contents whenever the control changes its size. The resize handler is enabled
 * in every control instance by default.
 * For performance reasons this behavior can be disabled by calling disableAutoResize()
 * 
 * @protected
 * @deprecated This method is declared as protected in order to assess the need for this feature. It is declared as deprecated because the API might change in case the need for this is high enough to make it part of the official Splitter interface
 */
sap.ui.layout.Splitter.prototype.enableAutoResize = function() {
	var that = this;
	sap.ui.getCore().attachInit(function() {
		that._resizeHandlerId = sap.ui.core.ResizeHandler.register(that, that._resizeCallback);
	});
	
	this._delayedResize();
};

/**
 * Disables the resize handler for this control, this leads to an automatic resize of
 * the contents whenever the control changes its size. The resize handler is enabled
 * in every control instance by default.
 * For performance reasons this behavior can be disabled by calling disableAutoResize()
 * 
 * @protected
 * @deprecated This method is declared as protected in order to assess the need for this feature. It is declared as deprecated because the API might change in case the need for this is high enough to make it part of the official Splitter interface
 */
sap.ui.layout.Splitter.prototype.disableAutoResize = function() {
	sap.ui.core.ResizeHandler.deregister(this._resizeHandlerId);
};

/**
 * Enables recalculation and resize of the splitter contents while dragging the splitter bar.
 * This means that the contents are resized several times per second when moving the splitter bar.
 * 
 * @protected
 * @deprecated This method is declared as protected in order to assess the need for this feature. It is declared as deprecated because the API might change in case the need for this is high enough to make it part of the official Splitter interface
 */
sap.ui.layout.Splitter.prototype.enableLiveResize = function() {
	this._liveResize = true;
	this.$().toggleClass("sapUiLoSplitterAnimated", false);
};

/**
 * Disables recalculation and resize of the splitter contents while dragging the splitter bar.
 * This means that the contents are resized only once after moving the splitter bar.
 * 
 * @protected
 * @deprecated This method is declared as protected in order to assess the need for this feature. It is declared as deprecated because the API might change in case the need for this is high enough to make it part of the official Splitter interface
 */
sap.ui.layout.Splitter.prototype.disableLiveResize = function() {
	this._liveResize = false;
	this.$().toggleClass("sapUiLoSplitterAnimated", true);
};

/**
 * Enables the resizing of the Splitter contents via keyboard. This makes the Splitter bars
 * focussable elements.
 * 
 * @protected
 */
sap.ui.layout.Splitter.prototype.enableKeyboardSupport = function() {
	// TODO: Decide whether to move this functionality to a property.
	var $Bars = this.$().find(".sapUiLoSplitterBar");
	$Bars.attr("tabindex", "0");
	this._enableKeyboardListeners();
};

/**
 * Disables the resizing of the Splitter contents via keyboard. This changes the Splitter bars
 * to non-focussable elements.
 * 
 * @protected
 */
sap.ui.layout.Splitter.prototype.disableKeyboardSupport = function() {
	// TODO: Decide whether to move this functionality to a property.
	var $Bars = this.$().find(".sapUiLoSplitterBar");
	$Bars.attr("tabindex", "-1");
	this._disableKeyboardListeners();
};




////////////////////////////////////////// onEvent Methods /////////////////////////////////////////

sap.ui.layout.Splitter.prototype.onBeforeRendering = function() {
	this._switchOrientation();
};

/**
 * After Rendering, this method is called, it can be used to manipulate the DOM which has already 
 * been written. Its main function is to move the previously rendered DOM from the hidden area to 
 * the main splitter area and apply correct sizing.
 */
sap.ui.layout.Splitter.prototype.onAfterRendering = function() {
	// Create overlay DOM element for resizing
	this._$SplitterOverlay = this.$("overlay");
	this._$SplitterOverlayBar = this.$("overlayBar");
	this._$SplitterOverlay.detach();
	
	// Calculate and apply correct sizes to the Splitter contents 
	this._resize();
};

/**
 * When one or several of the child controls change their layoutData, the Splitter must 
 * recalculate the sizes of its content areas.
 * 
 * @private
 */
sap.ui.layout.Splitter.prototype.onLayoutDataChange = function() {
	this._delayedResize();
};

/**
 * Starts the resize of splitter contents (when the bar is moved by touch)
 * 
 * @param {jQuery.Event} [oJEv] The jQuery event 
 * @private
 */
sap.ui.layout.Splitter.prototype.ontouchstart = function(oJEv) {
	if (this._ignoreTouch) {
		return;
	}
	
	var sId = this.getId();
	if (!oJEv.target.id || oJEv.target.id.indexOf(sId + "-splitbar") != 0) {
		// The clicked element was not one of my splitter bars
		return;
	}
	
	if (!oJEv.changedTouches || !oJEv.changedTouches[0]) {
		// No touch in event 
		return;
	}
	
	this._ignoreMouse = true;
	this._onBarMoveStart(oJEv.changedTouches[0], true);
};

/**
 * Starts the resize of splitter contents (when the bar is moved by mouse)
 * 
 * @param {jQuery.Event} [oJEv] The jQuery event 
 * @private
 */
sap.ui.layout.Splitter.prototype.onmousedown = function(oJEv) {
	if (this._ignoreMouse) {
		return;
	}
	
	var sId = this.getId();
	if (!oJEv.target.id || oJEv.target.id.indexOf(sId + "-splitbar") != 0) {
		// The clicked element was not one of my splitter bars
		return;
	}
	
	this._ignoreTouch = true;
	this._onBarMoveStart(oJEv);
};


/**
 * Starts a resize (for touch and click)
 * 
 * @param {jQuery.Event} [oJEv] The jQuery event 
 * @param {bool} [bTouch] Whether the first parameter is a touch event 
 * @private
 */
sap.ui.layout.Splitter.prototype._onBarMoveStart = function(oJEv, bTouch) {
	var sId = this.getId();
	
	var iPos = oJEv[this._moveCord];
	var iBar = parseInt(oJEv.target.id.substr((sId + "-splitbar-").length), 10);
	var $Bar = jQuery(oJEv.target);
	var mCalcSizes = this.getCalculatedSizes();
	var iBarSize = this._bHorizontal ?  $Bar.innerWidth() : $Bar.innerHeight();
	
	var aContentAreas = this.getContentAreas();
	var oLd1   = aContentAreas[iBar].getLayoutData();
	var oLd2   = aContentAreas[iBar + 1].getLayoutData();
	
	if (!oLd1.getResizable() || !oLd2.getResizable()) {
		// One of the contentAreas is not resizable, do not resize
		// Also: disallow text-marking behavior when not moving bar
		_preventTextSelection(bTouch);
		return;
	}
	
	// Calculate relative starting position of the bar for virtual bar placement
	var iRelStart = 0 - iBarSize;
	for (var i = 0; i <= iBar; ++i) {
		iRelStart += mCalcSizes[i] + iBarSize;
	}
	
	this._move = {
		// Start coordinate
		start : iPos,
		// Relative starting position of the bar
		relStart : iRelStart,
		// The number of the bar that is moved
		barNum : iBar,
		// The splitter bar that is moved
		bar : jQuery(oJEv.target),
		// The content sizes for fast resize bound calculation
		c1Size : mCalcSizes[iBar],
		c1MinSize : oLd1 ? parseInt(oLd1.getMinSize(), 10) : 0,
		c2Size : mCalcSizes[iBar + 1],
		c2MinSize : oLd2 ? parseInt(oLd2.getMinSize(), 10) : 0
	};
	
	// Event handlers use bound handler methods - see init()
	if (bTouch) {
		// this._ignoreMouse = true; // Ignore mouse-events until touch is done 
		document.addEventListener("touchend",  this._boundBarMoveEnd);
		document.addEventListener("touchmove", this._boundBarMove);
	} else {
		document.addEventListener("mouseup",   this._boundBarMoveEnd);
		document.addEventListener("mousemove", this._boundBarMove);
	}
	
	this._$SplitterOverlay.css("display", "block"); // Needed because it is set to none in renderer
	this._$SplitterOverlay.appendTo(this.getDomRef());
	this._$SplitterOverlayBar.css(this._sizeDirNot, "");
	this._move["bar"].css("visibility", "hidden");
	this._onBarMove(oJEv);
};

sap.ui.layout.Splitter.prototype._onBarMove = function(oJEv) {
	if (oJEv.preventDefault) { oJEv.preventDefault(); } // Do not select text
	
	var oEvent = oJEv;
	if (oJEv.changedTouches && oJEv.changedTouches[0]) {
		// Touch me baby!
		oEvent = oJEv.changedTouches[0];
	}
	
	var iPos = oEvent[this._moveCord];
	var iDelta = (iPos - this._move.start);
	
	var c1NewSize = this._move.c1Size + iDelta;
	var c2NewSize = this._move.c2Size - iDelta;
	
	
	var bInBounds = (
		    c1NewSize >= 0
		 && c2NewSize >= 0
		 && c1NewSize >= this._move.c1MinSize
		 && c2NewSize >= this._move.c2MinSize
	);
	
	// Move virtual splitter bar
	if (bInBounds) {
		this._$SplitterOverlayBar.css(this._sizeDir, this._move.relStart + iDelta);
		
		if (this._liveResize) {
			this._resizeContents(
				/* left content number:    */ this._move["barNum"],
				/* number of pixels:       */ 0 - (this._move["start"] - oEvent[this._moveCord]),
				/* also change layoutData: */ false
			);
		}
	}
	
};


/**
 * Ends the resize of splitter contents (when the bar is moved)
 * 
 * @param {jQuery.Event} [oJEv] The jQuery event 
 * @private
 */
sap.ui.layout.Splitter.prototype._onBarMoveEnd = function(oJEv) {
	this._ignoreMouse = false;
	this._ignoreTouch = false;
	
	var oEvent = oJEv;
	if (oJEv.changedTouches && oJEv.changedTouches[0]) {
		// Touch me baby!
		oEvent = oJEv.changedTouches[0];
	}
	
	var iPos = oEvent[this._moveCord];
	
	this._resizeContents(
		/* left content number:    */ this._move["barNum"],
		/* number of pixels:       */ 0 - (this._move["start"] - iPos),
		/* also change layoutData: */ true
	);
	
	// Remove resizing overlay
	this._move["bar"].css("visibility", "");
	this._$SplitterOverlay.css("display", ""); // Remove?
	this._$SplitterOverlay.detach();

	// Uses bound handler methods - see init()
	document.removeEventListener("mouseup",   this._boundBarMoveEnd);
	document.removeEventListener("mousemove", this._boundBarMove);
	document.removeEventListener("touchend",  this._boundBarMoveEnd);
	document.removeEventListener("touchmove", this._boundBarMove);
	
	jQuery.sap.focus(this._move.bar);
};

/**
 * Resizes the contents after a bar has been moved
 * 
 * @param {Number} [iLeftContent] Number of the first (left) content that is resized
 * @param {Number} [iPixels] Number of pixels to increase the first and decrease the second content
 * @param {bool} [bFinal] Whether this is the final position (sets the size in the layoutData of the 
 * content areas)
 */
sap.ui.layout.Splitter.prototype._resizeContents = function(iLeftContent, iPixels, bFinal) {
	if (isNaN(iPixels)) {
		jQuery.sap.log.warning("Splitter: Received invalid resizing values - resize aborted.");
		return;
	}
	
	var aContentAreas = this.getContentAreas();
	var oLd1   = aContentAreas[iLeftContent].getLayoutData();
	var oLd2   = aContentAreas[iLeftContent + 1].getLayoutData();
	
	var sSize1 = oLd1.getSize();
	var sSize2 = oLd2.getSize();
	
	var $Cnt1 = this.$("content-" + iLeftContent);
	var $Cnt2 = this.$("content-" + (iLeftContent + 1));
	
	var iNewSize1 = this._move.c1Size + iPixels;
	var iNewSize2 = this._move.c2Size - iPixels;
	var iMinSize1 = parseInt(oLd1.getMinSize(), 10);
	var iMinSize2 = parseInt(oLd2.getMinSize(), 10);
	
	// Adhere to size constraints
	var iDiff;
	if (iNewSize1 < iMinSize1) {
		iDiff = iMinSize1 - iNewSize1;
		iPixels += iDiff;
		iNewSize1 = iMinSize1;
		iNewSize2 -= iDiff;
	} else if (iNewSize2 < iMinSize2) {
		iDiff = iMinSize2 - iNewSize2;
		iPixels -= iDiff;
		iNewSize2 = iMinSize2;
		iNewSize1 -= iDiff;
	}
	
	if (bFinal) {
		// Resize finished, set layout data in content areas
		if (sSize1 === "auto" && sSize2 !== "auto") {
			// First pane has auto size - only change size of second pane
			oLd2.setSize(iNewSize2 + "px");
		} else if (sSize1 !== "auto" && sSize2 === "auto") {
			// Second pane has auto size - only change size of first pane
			oLd1.setSize(iNewSize1 + "px");
		} else {
			// TODO: What do we do if both are "auto"?
			oLd1.setSize(iNewSize1 + "px");
			oLd2.setSize(iNewSize2 + "px");
		}
	} else {
		// Live-Resize, resize contents in Dom
		$Cnt1.css(this._sizeType, iNewSize1 + "px");
		$Cnt2.css(this._sizeType, iNewSize2 + "px");
	}
	
	// TODO: When resizing everything gets absolute sizes - %-values should resize to % etc.
};


////////////////////////////////////////// Private Methods /////////////////////////////////////////

/**
 * Resizes as soon as the current stack is done. Can be used in cases where several resize-relevant
 * actions are done in a loop to make sure only one resize calculation is done at the end.
 *
 * @param {Number} [iDelay=0] Number of milliseconds to wait before doing the resize
 * @private
 */
sap.ui.layout.Splitter.prototype._delayedResize = function(iDelay) {
	if (iDelay === undefined) {
		iDelay = 0;
	}
	
	// If we are not rendered, we do not need to resize since resizing is done after rendering
	if (this.getDomRef()) {
		jQuery.sap.clearDelayedCall(this._resizeTimeout);
		this._resizeTimeout = jQuery.sap.delayedCall(iDelay, this, this._resize, []);
	}
};

/**
 * Recalculates the content sizes and manipulates the DOM accordingly.
 *
 * @private
 */
sap.ui.layout.Splitter.prototype._resize = function() {
	var i = 0, $Bar;
	
	// Save calculated sizes to be able to tell whether a resize occurred
	var oldCalculatedSizes = this.getCalculatedSizes();
	this._recalculateSizes();
	var newCalculatedSizes = this.getCalculatedSizes();

	var bSizesValid = false;
	for (i = 0; i < newCalculatedSizes.length; ++i) {
		if (newCalculatedSizes[i] !== 0) {
			bSizesValid = true;
			break;
		}
	}
	if (!bSizesValid) {
		// TODO: What if all sizes are set to 0 on purpose...?
		this._delayedResize(100);
		return;
	}
	
	var aContentAreas = this.getContentAreas();
	var bLastContentResizable = true;
	for (i = 0; i < aContentAreas.length; ++i) {
		var $Content = this.$("content-" + i);
		var oContent = aContentAreas[i];
		
		$Content.css(this._sizeType, newCalculatedSizes[i] + "px");
		$Content.css(this._sizeTypeNot, ""); // Remove other sizes.
		// TODO: Remove all wrong sizes when switching orientation instead of here?

		// Check whether bar should be movable
		var oLd = oContent.getLayoutData();
		var bContentResizable = oLd && oLd.getResizable();
		if (i > 0) {
			var bResizable = bContentResizable && bLastContentResizable;
			$Bar = this.$("splitbar-" + (i - 1));
			$Bar.toggleClass("sapUiLoSplitterNoResize", !bResizable);
			$Bar.attr("tabindex", bResizable && this._keyboardEnabled ? "0" : "-1");
			$Bar.attr("title", bResizable ? this._getText("SPLITTER_MOVE") : "");
		}
		bLastContentResizable = bContentResizable;
	}
	
	// In case the Splitter has a relative height or width set (like "100%"), and the surrounding 
	// container does not have a size set, the content of the Splitter defines the height/width,
	// in which case the size of the splitter bars is incorrect.
	var $this = this.$();
	// First remove the size from the splitter bar so it does not lead to growing the content
	for (i = 0; i < aContentAreas.length - 1; ++i) {
		$Bar = this.$("splitbar-" + i);
		$Bar.css(this._sizeTypeNot, "");
	}
	// Now measure the content and adapt the size of the Splitter bar
	for (i = 0; i < aContentAreas.length - 1; ++i) {
		$Bar = this.$("splitbar-" + i);
		var iSize = this._bHorizontal ? $this.height() : $this.width();
		$Bar.css(this._sizeTypeNot, iSize + "px");
	}
	
	// In case something was resized, change sizes and fire resize event
	if (_sizeArraysDiffer(oldCalculatedSizes, newCalculatedSizes)) {
		this.fireResize({
			oldSizes : oldCalculatedSizes,
			newSizes : newCalculatedSizes
		});
	}
};

/**
 * Calculates how much space is actually available inside the splitter to distribute the content
 * areas in.
 * 
 * @param {string[]} [aSizes] The list of size values from the LayoutData of the content areas
 * @returns {Number} The available space in px
 * @private
 */
sap.ui.layout.Splitter.prototype._calculateAvailableContentSize = function(aSizes) {
	var i = 0;
	
	var $Splitter = this.$();
	var iFullSize      = this._bHorizontal ? $Splitter.innerWidth() : $Splitter.innerHeight();
	// Due to rounding errors when zoom is activated, we need 1px of error margin for every element
	// that is automatically sized...
	var iAutosizedAreas = 0;
	var bHasAutoSizedContent = false;
	for (i = 0; i < aSizes.length; ++i) {
		var sSize = aSizes[i];
		if (sSize.indexOf("%") > -1) {
			iAutosizedAreas++;
		}
		if (aSizes[i] == "auto") {
			bHasAutoSizedContent = true;
		}
	}
	iAutosizedAreas += bHasAutoSizedContent ? 1 : 0;
	
	iFullSize -= iAutosizedAreas;
	
	// Due to zoom rounding erros, we cannot assume that all SplitBars have the same sizes, even 
	// though they have the same CSS size set.
	var iSplitters     = aSizes.length - 1;
	var iSplitBarsWidth = 0;
	for (i = 0; i < iSplitters; ++i) {
		iSplitBarsWidth += this._bHorizontal 
			? this.$("splitbar-" + i).innerWidth() 
			: this.$("splitbar-" + i).innerHeight();
	}
	
	return iFullSize - iSplitBarsWidth;
};

/**
 * Recalculates the content sizes in three steps:
 *  1. Searches for all absolute values ("px") and deducts them from the available space.
 *  2. Searches for all percent values and interprets them as % of the available space after step 1
 *  3. Divides the rest of the space uniformly between all contents with "auto" size values
 * 
 * @private
 */
sap.ui.layout.Splitter.prototype._recalculateSizes = function() {
	// TODO: (?) Use maxSize value from layoutData
	var i, sSize, oLayoutData, iColSize, idx;
	
	// Read all content sizes from the layout data
	var aSizes = [];
	var aContentAreas = this.getContentAreas();
	for (i = 0; i < aContentAreas.length; ++i) {
		oLayoutData = aContentAreas[i].getLayoutData();
		sSize = oLayoutData ? oLayoutData.getSize() : "auto";
		aSizes.push(sSize);
	}
	
	this._calculatedSizes = [];
	
	var iAvailableSize      = this._calculateAvailableContentSize(aSizes);
	
	var aAutosizeIdx = [];
	var aAutoMinsizeIdx = [];
	var aPercentsizeIdx = [];
	
	// Remove fixed sizes from available size
	for (i = 0; i < aSizes.length; ++i) {
		sSize = aSizes[i];
		var iSize;
		
		if (sSize.indexOf("px") > -1) {
			// Pixel based Value - deduct it from available size
			iSize = parseInt(sSize);
			iAvailableSize -= iSize;
			this._calculatedSizes[i] = iSize;
		} else if (sSize.indexOf("%") > -1) {
			aPercentsizeIdx.push(i);
		} else if (aSizes[i] == "auto") {
			oLayoutData = aContentAreas[i].getLayoutData();
			if (oLayoutData && parseInt(oLayoutData.getMinSize(), 10) != 0) {
				aAutoMinsizeIdx.push(i);
			} else {
				aAutosizeIdx.push(i);
			}
		} else {
			jQuery.sap.log.error("Illegal size value: " + aSizes[i]);
		}
	}
	
	var bWarnSize = false; // Warn about sizes being too big for the available space
	
	// If more than the available size if assigned to fixed width content, the rest will get no
	// space at all
	if (iAvailableSize < 0) { bWarnSize = true; iAvailableSize = 0; }
	
	// Now calculate % of the available space
	var iRest = iAvailableSize;
	var iPercentSizes = aPercentsizeIdx.length;
	for (i = 0; i < iPercentSizes; ++i) {
		idx = aPercentsizeIdx[i];
		// Percent based Value - deduct it from available size
		iColSize = parseFloat(aSizes[idx]) / 100 * iAvailableSize;
		iAvailableSize -= Math.ceil(iColSize);
		this._calculatedSizes[idx] = Math.floor(iColSize);
		iRest -= Math.ceil(iColSize);
	}
	iAvailableSize = iRest;
	
	if (iAvailableSize < 0) { bWarnSize = true; iAvailableSize = 0; }
	
	// Calculate auto sizes
	iColSize = Math.floor(iAvailableSize / (aAutoMinsizeIdx.length + aAutosizeIdx.length), 0);

	// First calculate auto-sizes with a minSize constraint
	var iAutoMinSizes = aAutoMinsizeIdx.length;
	for (i = 0; i < iAutoMinSizes; ++i) {
		idx = aAutoMinsizeIdx[i];
		var iMinSize = parseInt(aContentAreas[idx].getLayoutData().getMinSize(), 10);
		if (iMinSize > iColSize) {
			this._calculatedSizes[idx] = iMinSize;
			iAvailableSize -= iMinSize;
		} else {
			this._calculatedSizes[idx] = iColSize;
			iAvailableSize -= iColSize;
		}
	}
	
	if (iAvailableSize < 0) { bWarnSize = true; iAvailableSize = 0; }

	// Now calculate "auto"-sizes
	iRest = iAvailableSize;
	var iAutoSizes = aAutosizeIdx.length;
	iColSize = Math.floor(iAvailableSize / iAutoSizes, 0);
	for (i = 0; i < iAutoSizes; ++i) {
		idx = aAutosizeIdx[i];
		this._calculatedSizes[idx] = iColSize;
		iRest -= iColSize;
		if (i == iAutoSizes - 1 && iRest != 0) {
			// In case of rounding errors, change the last auto-size column
			this._calculatedSizes[idx] += iRest;
		}
	}
	
	if (bWarnSize) {
		// TODO: Decide if the warning should be kept - might spam the console but on the other
		//       hand it might make analyzing of splitter bugs easier, since we can just ask 
		//       developers if there was a [Splitter] output on the console if the splitter looks
		//       weird in their application.
		jQuery.sap.log.info(
			"[Splitter] The set sizes and minimal sizes of the splitter contents are bigger " +
			"than the available space in the UI."
		);
	}
};

/**
 * Stores the respective values that differ when resizing the splitter in horizontal vs. vertical
 * mode
 * 
 * @private
 */
sap.ui.layout.Splitter.prototype._switchOrientation = function() {
	this._bHorizontal = this.getOrientation() === sap.ui.core.Orientation.Horizontal;
	if (this._bHorizontal) {
		this._moveCord    = "pageX";
		this._sizeType    = "width";
		this._sizeTypeNot = "height";
		this._sizeDir     = "left";
		this._sizeDirNot  = "top";
	} else {
		this._moveCord    = "pageY";
		this._sizeType    = "height";
		this._sizeTypeNot = "width";
		this._sizeDir     = "top";
		this._sizeDirNot  = "left";
	}

	var $This = this.$();
	$This.toggleClass("sapUiLoSplitterH", this._bHorizontal);
	$This.toggleClass("sapUiLoSplitterV", !this._bHorizontal);
};

/**
 * Handles events that are generated from the keyboard that should trigger a resize (on the 
 * Splitter bars).
 * 
 * @param {string} [sType] The type of resize step ("inc", "dec", "incMore", "decMore", "max", "min")
 * @param {jQuery.Event} [oEvent] The original keyboard event
 */
sap.ui.layout.Splitter.prototype._onKeyboardResize = function(sType, oEvent) {
	var sBarId = this.getId() + "-splitbar-";
	if (!oEvent || !oEvent.target || !oEvent.target.id || oEvent.target.id.indexOf(sBarId) !== 0) {
		return;
	}

	var iStepSize = 20;
	var iBigStep  = 999999;

	var iBar = parseInt(oEvent.target.id.substr(sBarId.length));
	var mCalcSizes = this.getCalculatedSizes();
	// TODO: These two lines are incomprehensible magic - find better solution
	this._move.c1Size = mCalcSizes[iBar];
	this._move.c2Size = mCalcSizes[iBar + 1];
	
	var iStep = 0;
	switch (sType) {
		case "inc":
			iStep = iStepSize;
			break;
			
		case "incMore":
			iStep = iStepSize * 10;
			break;
			
		case "dec":
			iStep = 0 - iStepSize;
			break;
			
		case "decMore":
			iStep = 0 - iStepSize * 10;
			break;
			
		case "max":
			iStep = iBigStep;
			break;
			
		case "min":
			iStep = 0 - iBigStep;
			break;
			
		default:
			jQuery.sap.log.warn("[Splitter] Invalid keyboard resize type");
			break;
	}

	this._resizeContents(iBar, iStep, true);
};

/**
 * Connects the keyboard event listeners so resizing via keyboard will be possible
 */
sap.ui.layout.Splitter.prototype._enableKeyboardListeners = function() {
	this.onsapincrease          = this._keyListeners.increase;
	this.onsapincreasemodifiers = this._keyListeners.increase;
	this.onsapdecrease          = this._keyListeners.decrease;
	this.onsapdecreasemodifiers = this._keyListeners.decrease;
	this.onsappageup            = this._keyListeners.decreaseMore;
	this.onsappagedown          = this._keyListeners.increaseMore;
	this.onsapend               = this._keyListeners.max;
	this.onsapendmodifiers      = this._keyListeners.max;
	this.onsaphome              = this._keyListeners.min;
	this.onsaphomemodifiers     = this._keyListeners.min;
	
	
	this._keyboardEnabled = true;
	
	// TODO: implement sapskipforward and sapskipback for navigating between content areas
};

/**
 * Disconnects the keyboard event listeners so resizing via keyboard will not be possible anymore
 */
sap.ui.layout.Splitter.prototype._disableKeyboardListeners = function() {
	delete this.onsapincreasemodifiers;
	delete this.onsapdecreasemodifiers;
	delete this.onsapendmodifiers;
	delete this.onsaphomemodifiers;
	
	this._keyboardEnabled = false;
};

/**
 * Gets the text for the given key from the current resourcebundle 
 * 
 * @param {string} [sKey] Text key to look for in the resource bundle
 * @param {array} [aArgs] Additional arguments for the getText method of the ResourceBundle
 * @returns {string} The translated string
 * @private
 */
sap.ui.layout.Splitter.prototype._getText = function(sKey, aArgs) {
	return (oResourceBundle ? oResourceBundle.getText(sKey, aArgs) : sKey);
};


///////////////////////////////////////// Hidden Functions /////////////////////////////////////////

/**
 * Compares two (simple, one-dimensional) arrays. If all values are the same, false is returned - 
 * If values differ or at least one of the values is no array, true is returned.
 * 
 * @param {Number[]} [aSizes1] The array of numbers to compare against
 * @param {Number[]} [aSizes2] The array of numbers that is compared to the first one
 * @returns {bool} True if the size-arrays differ, false otherwise
 * @private
 */
function _sizeArraysDiffer(aSizes1, aSizes2) {
	if (aSizes1 === aSizes2) {
		// The same thing. No difference.
		return false;
	}
	
	if (!aSizes1 || !aSizes2 || aSizes1.length === undefined || aSizes2.length === undefined) {
		// At lease one of the two is not an array
		return true;
	}
	
	if (aSizes1.length != aSizes2.length) {
		return true;
	}
	
	for (var i = 0; i < aSizes1.length; ++i) {
		if (aSizes1[i] !== aSizes2[i]) {
			return true;
		}
	}
	
	return false;
}

/**
 * Prevents the selection of text while the mouse is moving when pressed
 * 
 * @param {bool} [bTouch] If set to true, touch events instead of mouse events are captured
 */
function _preventTextSelection(bTouch) {
	var fnPreventSelection = function(oEvent) {
		oEvent.preventDefault();
	};
	var fnAllowSelection = null;
	fnAllowSelection = function() {
		document.removeEventListener("touchend",  fnAllowSelection);
		document.removeEventListener("touchmove", fnPreventSelection);
		document.removeEventListener("mouseup",   fnAllowSelection);
		document.removeEventListener("mousemove", fnPreventSelection);
	};
	
	if (bTouch) {
		this._ignoreMouse = true; // Ignore mouse-events until touch is done 
		document.addEventListener("touchend",  fnAllowSelection);
		document.addEventListener("touchmove", fnPreventSelection);
	} else {
		document.addEventListener("mouseup",   fnAllowSelection);
		document.addEventListener("mousemove", fnPreventSelection);
	}
}

/**
 * Makes sure the LayoutData for the given control is set and compatible. In case nothing is set,
 * a default sap.ui.layout.SplitterLayoutData is set on the Element
 * 
 * @param {sap.ui.core.Element} [oContent] The Element for which the existance of LayoutData should be ensured
 * @private
 */
function _ensureLayoutData(oContent) {
	var oLd = oContent.getLayoutData();
	// Make sure LayoutData is set on the content
	// TODO: There should be a better way to verify that it's the correct type of LayoutData
	//       But this approach has the advantage that "compatible" LayoutData can be used.
	if (oLd && (!oLd.getResizable || !oLd.getSize || !oLd.getMinSize)) {
		jQuery.sap.log.warning(
			"Content \"" + oContent.getId() + "\" for the Splitter contained wrong LayoutData. " +
			"The LayoutData has been replaced with default values."
		);
		oLd = null;
	}
	if (!oLd) {
		oContent.setLayoutData(new sap.ui.layout.SplitterLayoutData());
	}
}


//////////////////////////////////////// Overridden Methods ////////////////////////////////////////


sap.ui.layout.Splitter.prototype.invalidate = function(oOrigin) {
	var bForce =
		// In case the content invalidates and bubbles up (for example an invisible button being
		// shown), we need to rerender
		// TODO: Render only the contentArea where the invalidate originated from
		(oOrigin && this.indexOfContentArea(oOrigin) != -1)
	
		// CustomData that needs to be updated in the DOM has been set on the splitter
		// TODO: Programatically write CustomData on this control to the DOM
	 || (oOrigin && oOrigin instanceof sap.ui.core.CustomData && oOrigin.getWriteToDom())
	
		// We do not know where the invalidate originated from. We will pretty much have to rerender
	 || (oOrigin === undefined);
	
	// Only really invalidate/rerender if needed
	if (bForce || this._needsInvalidation) {
		this._needsInvalidation = false;
		sap.ui.core.Control.prototype.invalidate.apply(this, arguments);
	}
};

    //////////////////////////////////// Property "orientation" ///////////////////////////////////

sap.ui.layout.Splitter.prototype.setOrientation = function(sOrientation) {
	var vReturn = this.setProperty("orientation", sOrientation, true);
	
	this._switchOrientation();
	this._delayedResize();
	
	return vReturn;
};


    ///////////////////////////////////// Property "width" ///////////////////////////////

sap.ui.layout.Splitter.prototype.setWidth = function(sWidth) {
	// Do not invalidate for size change
	this.setProperty("width", sWidth, true);
	// Set validated width on control
	this.$().css("width", this.getProperty("width"));
	return this;
};

    ///////////////////////////////////// Property "height" ///////////////////////////////

sap.ui.layout.Splitter.prototype.setHeight = function(sHeight) {
	// Do not invalidate for size change
	this.setProperty("height", sHeight, true);
	// Set validated height on control
	this.$().css("height", this.getProperty("height"));
	return this;
};

    //////////////////////////////////////// Event "xxx" ///////////////////////////////////////

    ///////////////////////////////////// Aggregation "contents" ///////////////////////////////

sap.ui.layout.Splitter.prototype.addContentArea = function(oContent) {
	this._needsInvalidation = true;
	_ensureLayoutData(oContent);
	return this.addAggregation("contentAreas", oContent);
};

sap.ui.layout.Splitter.prototype.removeContentArea = function(oContent) {
	this._needsInvalidation = true;
	return this.removeAggregation("contentAreas", oContent);
};

sap.ui.layout.Splitter.prototype.removeAllContentArea = function() {
	this._needsInvalidation = true;
	return this.destroyAllAggregation("contentAreas");
};

sap.ui.layout.Splitter.prototype.destroyContentArea = function() {
	this._needsInvalidation = true;
	return this.destroyAggregation("contentAreas");
};

sap.ui.layout.Splitter.prototype.insertContentArea = function(oContent, iIndex) {
	this._needsInvalidation = true;
	_ensureLayoutData(oContent);
	return this.insertAggregation("contentAreas", oContent, iIndex);
};

    ///////////////////////////////////// Association "xxx" ////////////////////////////////////


})(window);

}; // end of sap/ui/layout/Splitter.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.SplitterLayoutData') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.SplitterLayoutData.
jQuery.sap.declare("sap.ui.layout.SplitterLayoutData");

jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained



/**
 * Constructor for a new SplitterLayoutData.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getResizable resizable} : boolean (default: true)</li>
 * <li>{@link #getSize size} : sap.ui.core.CSSSize (default: 'auto')</li>
 * <li>{@link #getMinSize minSize} : int (default: 0)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.LayoutData#constructor sap.ui.core.LayoutData}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Holds layout data for the splitter contents.
 * Allowed size values are numeric values ending in "px" and "%" and the
 * special case "auto".
 * (The CSS value "auto" is used internally to recalculate the size of the content
 * dynamically and is not directly set as style property.)
 * @extends sap.ui.core.LayoutData
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.22.0
 * @experimental Since version 1.22.0. 
 * API is not yet finished and might change completely
 * @name sap.ui.layout.SplitterLayoutData
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.LayoutData.extend("sap.ui.layout.SplitterLayoutData", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"resizable" : {type : "boolean", group : "Behavior", defaultValue : true},
		"size" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : 'auto'},
		"minSize" : {type : "int", group : "Dimension", defaultValue : 0}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.SplitterLayoutData with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.SplitterLayoutData.extend
 * @function
 */


/**
 * Getter for property <code>resizable</code>.
 * Determines whether the control in the splitter can be resized or not.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>resizable</code>
 * @public
 * @name sap.ui.layout.SplitterLayoutData#getResizable
 * @function
 */

/**
 * Setter for property <code>resizable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bResizable  new value for property <code>resizable</code>
 * @return {sap.ui.layout.SplitterLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.SplitterLayoutData#setResizable
 * @function
 */


/**
 * Getter for property <code>size</code>.
 * Sets the size of the splitter content.
 *
 * Default value is <code>auto</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>size</code>
 * @public
 * @name sap.ui.layout.SplitterLayoutData#getSize
 * @function
 */

/**
 * Setter for property <code>size</code>.
 *
 * Default value is <code>auto</code> 
 *
 * @param {sap.ui.core.CSSSize} sSize  new value for property <code>size</code>
 * @return {sap.ui.layout.SplitterLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.SplitterLayoutData#setSize
 * @function
 */


/**
 * Getter for property <code>minSize</code>.
 * Sets the minimum size of the splitter content in px.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>minSize</code>
 * @public
 * @name sap.ui.layout.SplitterLayoutData#getMinSize
 * @function
 */

/**
 * Setter for property <code>minSize</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iMinSize  new value for property <code>minSize</code>
 * @return {sap.ui.layout.SplitterLayoutData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.SplitterLayoutData#setMinSize
 * @function
 */


// Start of sap\ui\layout\SplitterLayoutData.js
/*** NOTHING ***/
}; // end of sap/ui/layout/SplitterLayoutData.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.VerticalLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.VerticalLayout.
jQuery.sap.declare("sap.ui.layout.VerticalLayout");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new VerticalLayout.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * In this layout the elements are ordered one below the other
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.VerticalLayout
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.VerticalLayout", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.VerticalLayout with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.VerticalLayout.extend
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * CSS width of the vertical layout.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.layout.VerticalLayout#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.layout.VerticalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.VerticalLayout#setWidth
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * 
 * If not enabled all controls inside are not enabled automatically.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.ui.layout.VerticalLayout#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.ui.layout.VerticalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.VerticalLayout#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Whether this VerticalLayout is visible.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.layout.VerticalLayout#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.layout.VerticalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.VerticalLayout#setVisible
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Child Controls within the layout.
 * 
 * <strong>Note</strong>: this is the default aggregation for VerticalLayout.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.layout.VerticalLayout#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.layout.VerticalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.VerticalLayout#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.layout.VerticalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.VerticalLayout#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.layout.VerticalLayout#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.VerticalLayout#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.VerticalLayout#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.layout.VerticalLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.VerticalLayout#destroyContent
 * @function
 */


// Start of sap\ui\layout\VerticalLayout.js
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained


sap.ui.core.EnabledPropagator.call(sap.ui.layout.VerticalLayout.prototype);
}; // end of sap/ui/layout/VerticalLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.Form') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.Form.
jQuery.sap.declare("sap.ui.layout.form.Form");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new form/Form.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEditable editable} : boolean</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getFormContainers formContainers} <strong>(default aggregation)</strong> : sap.ui.layout.form.FormContainer[]</li>
 * <li>{@link #getTitle title} : sap.ui.core.Title|string</li>
 * <li>{@link #getLayout layout} : sap.ui.layout.form.FormLayout</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Form control.
 * Holder for form control to be rendered in a specific form layout.
 * A Form supports VariantLayoutData for it's content to allow a simple switching of Layouts.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.Form
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.form.Form", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"visible" : {type : "boolean", group : "Misc", defaultValue : true},
		"editable" : {type : "boolean", group : "Misc", defaultValue : null}
	},
	defaultAggregation : "formContainers",
	aggregations : {
		"formContainers" : {type : "sap.ui.layout.form.FormContainer", multiple : true, singularName : "formContainer"}, 
		"title" : {type : "sap.ui.core.Title", altTypes : ["string"], multiple : false}, 
		"layout" : {type : "sap.ui.layout.form.FormLayout", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.Form with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.Form.extend
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Width of the form.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.ui.layout.form.Form#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#setWidth
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible Forms are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.layout.form.Form#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#setVisible
 * @function
 */


/**
 * Getter for property <code>editable</code>.
 * Applies a device and theme specific line-height to the form elements if the form has editable content.
 * In this case all (not only the editable) rows of the form will get the line height.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @since 1.20.0
 * @name sap.ui.layout.form.Form#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @since 1.20.0
 * @name sap.ui.layout.form.Form#setEditable
 * @function
 */


/**
 * Getter for aggregation <code>formContainers</code>.<br/>
 * FormContainers with the content of the form.
 * 
 * <strong>Note</strong>: this is the default aggregation for form/Form.
 * @return {sap.ui.layout.form.FormContainer[]}
 * @public
 * @name sap.ui.layout.form.Form#getFormContainers
 * @function
 */


/**
 * Inserts a formContainer into the aggregation named <code>formContainers</code>.
 *
 * @param {sap.ui.layout.form.FormContainer}
 *          oFormContainer the formContainer to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the formContainer should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the formContainer is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the formContainer is inserted at 
 *             the last position        
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#insertFormContainer
 * @function
 */

/**
 * Adds some formContainer <code>oFormContainer</code> 
 * to the aggregation named <code>formContainers</code>.
 *
 * @param {sap.ui.layout.form.FormContainer}
 *            oFormContainer the formContainer to add; if empty, nothing is inserted
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#addFormContainer
 * @function
 */

/**
 * Removes an formContainer from the aggregation named <code>formContainers</code>.
 *
 * @param {int | string | sap.ui.layout.form.FormContainer} vFormContainer the formContainer to remove or its index or id
 * @return {sap.ui.layout.form.FormContainer} the removed formContainer or null
 * @public
 * @name sap.ui.layout.form.Form#removeFormContainer
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>formContainers</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.layout.form.FormContainer[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.form.Form#removeAllFormContainers
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.layout.form.FormContainer</code> in the aggregation named <code>formContainers</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.layout.form.FormContainer}
 *            oFormContainer the formContainer whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.form.Form#indexOfFormContainer
 * @function
 */
	

/**
 * Destroys all the formContainers in the aggregation 
 * named <code>formContainers</code>.
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#destroyFormContainers
 * @function
 */


/**
 * Getter for aggregation <code>title</code>.<br/>
 * Title element of the Form. Can either be a Label object, or a simple string.
 * 
 * @return {sap.ui.core.Title|string}
 * @public
 * @name sap.ui.layout.form.Form#getTitle
 * @function
 */


/**
 * Setter for the aggregated <code>title</code>.
 * @param {sap.ui.core.Title|string} oTitle
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#setTitle
 * @function
 */
	

/**
 * Destroys the title in the aggregation 
 * named <code>title</code>.
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#destroyTitle
 * @function
 */


/**
 * Getter for aggregation <code>layout</code>.<br/>
 * Layout of the form.
 * 
 * @return {sap.ui.layout.form.FormLayout}
 * @public
 * @name sap.ui.layout.form.Form#getLayout
 * @function
 */


/**
 * Setter for the aggregated <code>layout</code>.
 * @param {sap.ui.layout.form.FormLayout} oLayout
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#setLayout
 * @function
 */
	

/**
 * Destroys the layout in the aggregation 
 * named <code>layout</code>.
 * @return {sap.ui.layout.form.Form} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.Form#destroyLayout
 * @function
 */


// Start of sap\ui\layout\form\Form.js
/**
 * This file defines behavior for the control,
 */

(function() {

//	sap.ui.commons.Form.prototype.init = function(){
//	// do something for initialization...
//	};

	sap.ui.layout.form.Form.prototype.toggleContainerExpanded = function(oContainer){

		var oLayout = this.getLayout();
		if (oLayout) {
			oLayout.toggleContainerExpanded(oContainer);
		}

	};

	/*
	 * If onAfterRendering of a field is processed the layout might need to change it.
	 */
	sap.ui.layout.form.Form.prototype.contentOnAfterRendering = function(oFormElement, oControl){

		// call function of the layout
		var oLayout = this.getLayout();
		if (oLayout && oLayout.contentOnAfterRendering) {
			oLayout.contentOnAfterRendering( oFormElement, oControl);
		}

	};

	/*
	 * If LayoutData changed on control this may need changes on the layout. So bubble to the Layout
	 */
	sap.ui.layout.form.Form.prototype.onLayoutDataChange = function(oEvent){

		// call function of the layout
		var oLayout = this.getLayout();
		if (oLayout && oLayout.onLayoutDataChange) {
			oLayout.onLayoutDataChange(oEvent);
		}

	};

	sap.ui.layout.form.Form.prototype.setEditable = function(bEditable) {

		var bOldEditable = this.getEditable();
		this.setProperty("editable", bEditable, true);

		if (bEditable != bOldEditable && this.getDomRef()) {
			if (bEditable) {
				this.$().addClass("sapUiFormEdit").addClass("sapUiFormEdit-CTX");
			}else{
				this.$().removeClass("sapUiFormEdit").removeClass("sapUiFormEdit-CTX");
			}
		}

		return this;

	};

	/*
	 * Overwrite of INVALIDATE
	 * do not invalidate Form during rendering. Because there the Layout may update the content
	 * otherwise the Form will render twice
	*/
	sap.ui.layout.form.Form.prototype.invalidate = function(oOrigin) {

	if (!this._bNoInvalidate) {
		sap.ui.core.Control.prototype.invalidate.apply(this, arguments);
	}

};

}());

}; // end of sap/ui/layout/form/Form.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.FormContainer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.FormContainer.
jQuery.sap.declare("sap.ui.layout.form.FormContainer");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new form/FormContainer.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getExpanded expanded} : boolean (default: true)</li>
 * <li>{@link #getExpandable expandable} : boolean (default: false)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getFormElements formElements} <strong>(default aggregation)</strong> : sap.ui.layout.form.FormElement[]</li>
 * <li>{@link #getTitle title} : sap.ui.core.Title|string</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Used to group form elements.
 * Can contain other form elements or containers.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.FormContainer
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.layout.form.FormContainer", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"expanded" : {type : "boolean", group : "Misc", defaultValue : true},
		"expandable" : {type : "boolean", group : "Misc", defaultValue : false},
		"visible" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	defaultAggregation : "formElements",
	aggregations : {
		"formElements" : {type : "sap.ui.layout.form.FormElement", multiple : true, singularName : "formElement"}, 
		"title" : {type : "sap.ui.core.Title", altTypes : ["string"], multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.FormContainer with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.FormContainer.extend
 * @function
 */


/**
 * Getter for property <code>expanded</code>.
 * Group is expanded.
 * This property works only if the Container is expandable.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>expanded</code>
 * @public
 * @name sap.ui.layout.form.FormContainer#getExpanded
 * @function
 */

/**
 * Setter for property <code>expanded</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bExpanded  new value for property <code>expanded</code>
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#setExpanded
 * @function
 */


/**
 * Getter for property <code>expandable</code>.
 * Defines if the Container is expandable.
 * The expander icon will only be shown if a title is set for the Container.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>expandable</code>
 * @public
 * @name sap.ui.layout.form.FormContainer#getExpandable
 * @function
 */

/**
 * Setter for property <code>expandable</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bExpandable  new value for property <code>expandable</code>
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#setExpandable
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible FormContainers are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.layout.form.FormContainer#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#setVisible
 * @function
 */


/**
 * Getter for aggregation <code>formElements</code>.<br/>
 * Elements of the FormContainer.
 * 
 * <strong>Note</strong>: this is the default aggregation for form/FormContainer.
 * @return {sap.ui.layout.form.FormElement[]}
 * @public
 * @name sap.ui.layout.form.FormContainer#getFormElements
 * @function
 */


/**
 * Inserts a formElement into the aggregation named <code>formElements</code>.
 *
 * @param {sap.ui.layout.form.FormElement}
 *          oFormElement the formElement to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the formElement should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the formElement is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the formElement is inserted at 
 *             the last position        
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#insertFormElement
 * @function
 */

/**
 * Adds some formElement <code>oFormElement</code> 
 * to the aggregation named <code>formElements</code>.
 *
 * @param {sap.ui.layout.form.FormElement}
 *            oFormElement the formElement to add; if empty, nothing is inserted
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#addFormElement
 * @function
 */

/**
 * Removes an formElement from the aggregation named <code>formElements</code>.
 *
 * @param {int | string | sap.ui.layout.form.FormElement} vFormElement the formElement to remove or its index or id
 * @return {sap.ui.layout.form.FormElement} the removed formElement or null
 * @public
 * @name sap.ui.layout.form.FormContainer#removeFormElement
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>formElements</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.layout.form.FormElement[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.form.FormContainer#removeAllFormElements
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.layout.form.FormElement</code> in the aggregation named <code>formElements</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.layout.form.FormElement}
 *            oFormElement the formElement whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.form.FormContainer#indexOfFormElement
 * @function
 */
	

/**
 * Destroys all the formElements in the aggregation 
 * named <code>formElements</code>.
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#destroyFormElements
 * @function
 */


/**
 * Getter for aggregation <code>title</code>.<br/>
 * Title element of the Container. Can either be a Label object, or a simple string.
 * 
 * @return {sap.ui.core.Title|string}
 * @public
 * @name sap.ui.layout.form.FormContainer#getTitle
 * @function
 */


/**
 * Setter for the aggregated <code>title</code>.
 * @param {sap.ui.core.Title|string} oTitle
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#setTitle
 * @function
 */
	

/**
 * Destroys the title in the aggregation 
 * named <code>title</code>.
 * @return {sap.ui.layout.form.FormContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormContainer#destroyTitle
 * @function
 */


// Start of sap\ui\layout\form\FormContainer.js
/**
 * This file defines behavior for the control,
 */

jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


//sap.ui.core.EnabledPropagator.call(sap.ui.layout.form.FormContainer.prototype);

(function() {

	sap.ui.layout.form.FormContainer.prototype.init = function(){

		this._rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");

	};

	sap.ui.layout.form.FormContainer.prototype.exit = function(){

		if (this._oExpandButton) {
			this._oExpandButton.destroy();
			delete this._oExpandButton;
		}
		this._rb = undefined;

	};

	sap.ui.layout.form.FormContainer.prototype.setExpandable = function(bExpandable){

		this.setProperty("expandable", bExpandable);

		if (bExpandable) {
			var that = this;
			if (!this._oExpandButton) {
				this._oExpandButton = sap.ui.layout.form.FormHelper.createButton(this.getId()+"--Exp", _handleExpButtonPress, that);
				this._oExpandButton.setParent(this);
			}
			_setExpanderIcon(that);
		}

		return this;

	};

	sap.ui.layout.form.FormContainer.prototype.setExpanded = function(bExpanded){

		this.setProperty("expanded", bExpanded, true); // no automatic rerendering

		var that = this;
		_setExpanderIcon(that);

		var oForm = this.getParent();
		if (oForm && oForm.toggleContainerExpanded) {
			oForm.toggleContainerExpanded(that);
		}

		return this;

	};

	/*
	 * If onAfterRendering of a field is processed the Form (layout) might need to change it.
	 */
	sap.ui.layout.form.FormContainer.prototype.contentOnAfterRendering = function(oFormElement, oControl){

		// call function of parent (if assigned)
		var oParent = this.getParent();
		if (oParent && oParent.contentOnAfterRendering) {
			oParent.contentOnAfterRendering( oFormElement, oControl);
		}

	};

	/*
	 * If LayoutData changed on control this may need changes on the layout. So bubble to the form
	 */
	sap.ui.layout.form.FormContainer.prototype.onLayoutDataChange = function(oEvent){

		// call function of parent (if assigned)
		var oParent = this.getParent();
		if (oParent && oParent.onLayoutDataChange) {
			oParent.onLayoutDataChange(oEvent);
		}

	};

	/*
	 * Checks if properties are fine
	 * Expander only visible if title is set -> otherwise give warning
	 * @return 0 = no problem, 1 = warning, 2 = error
	 * @private
	 */
	sap.ui.layout.form.FormContainer.prototype._checkProperties = function(){

		var iReturn = 0;

		if (this.getExpandable() && !this.getTitle()) {
			jQuery.sap.log.warning("Expander only displayed if title is set", this.getId(), "FormContainer");
			iReturn = 1;
		}

		return iReturn;

	};

	function _setExpanderIcon(oContainer){

		if (!oContainer._oExpandButton) {
			return;
		}

		var sIcon, sIconHovered, sText, sTooltip;

		if (oContainer.getExpanded()) {
			sIcon = sap.ui.core.theming.Parameters.get('sapUiFormContainerColImageURL');
			sIconHovered = sap.ui.core.theming.Parameters.get('sapUiFormContainerColImageDownURL');
			sText = "-";
			sTooltip = oContainer._rb.getText("FORM_COLLAPSE");
		} else {
			sIcon = sap.ui.core.theming.Parameters.get('sapUiFormContainerExpImageURL');
			sIconHovered = sap.ui.core.theming.Parameters.get('sapUiFormContainerExpImageDownURL');
			sText = "+";
			sTooltip = oContainer._rb.getText("FORM_EXPAND");
		}

		if (sIcon) {
			sIcon = jQuery.sap.getModulePath("sap.ui.layout", '/') + "themes/" + sap.ui.getCore().getConfiguration().getTheme() + sIcon;
			sText = "";
		}
		if (sIconHovered) {
			sIconHovered = jQuery.sap.getModulePath("sap.ui.layout", '/') + "themes/" + sap.ui.getCore().getConfiguration().getTheme() + sIconHovered;
		}
		sap.ui.layout.form.FormHelper.setButtonContent(oContainer._oExpandButton, sText, sTooltip, sIcon, sIconHovered);

	};

	function _handleExpButtonPress(oEvent){

		this.setExpanded(!this.getExpanded());

	};

}());
}; // end of sap/ui/layout/form/FormContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.FormElement') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.FormElement.
jQuery.sap.declare("sap.ui.layout.form.FormElement");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new form/FormElement.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getLabel label} : sap.ui.core.Label|string</li>
 * <li>{@link #getFields fields} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A form element is a combination of one label and different controls associated to this label.
 * @extends sap.ui.core.Element
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.FormElement
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Element.extend("sap.ui.layout.form.FormElement", { metadata : {

	publicMethods : [
		// methods
		"getLabelControl"
	],
	library : "sap.ui.layout",
	properties : {
		"visible" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	defaultAggregation : "fields",
	aggregations : {
		"label" : {type : "sap.ui.core.Label", altTypes : ["string"], multiple : false}, 
		"fields" : {type : "sap.ui.core.Control", multiple : true, singularName : "field"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.FormElement with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.FormElement.extend
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible FormElements are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.ui.layout.form.FormElement#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.ui.layout.form.FormElement} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormElement#setVisible
 * @function
 */


/**
 * Getter for aggregation <code>label</code>.<br/>
 * Label of the fields. Can either be a Label object, or a simple string.
 * 
 * @return {sap.ui.core.Label|string}
 * @public
 * @name sap.ui.layout.form.FormElement#getLabel
 * @function
 */


/**
 * Setter for the aggregated <code>label</code>.
 * @param {sap.ui.core.Label|string} oLabel
 * @return {sap.ui.layout.form.FormElement} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormElement#setLabel
 * @function
 */
	

/**
 * Destroys the label in the aggregation 
 * named <code>label</code>.
 * @return {sap.ui.layout.form.FormElement} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormElement#destroyLabel
 * @function
 */


/**
 * Getter for aggregation <code>fields</code>.<br/>
 * Formular controls.
 * 
 * <strong>Note</strong>: this is the default aggregation for form/FormElement.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.layout.form.FormElement#getFields
 * @function
 */


/**
 * Inserts a field into the aggregation named <code>fields</code>.
 *
 * @param {sap.ui.core.Control}
 *          oField the field to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the field should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the field is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the field is inserted at 
 *             the last position        
 * @return {sap.ui.layout.form.FormElement} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormElement#insertField
 * @function
 */

/**
 * Adds some field <code>oField</code> 
 * to the aggregation named <code>fields</code>.
 *
 * @param {sap.ui.core.Control}
 *            oField the field to add; if empty, nothing is inserted
 * @return {sap.ui.layout.form.FormElement} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormElement#addField
 * @function
 */

/**
 * Removes an field from the aggregation named <code>fields</code>.
 *
 * @param {int | string | sap.ui.core.Control} vField the field to remove or its index or id
 * @return {sap.ui.core.Control} the removed field or null
 * @public
 * @name sap.ui.layout.form.FormElement#removeField
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>fields</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.form.FormElement#removeAllFields
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>fields</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oField the field whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.form.FormElement#indexOfField
 * @function
 */
	

/**
 * Destroys all the fields in the aggregation 
 * named <code>fields</code>.
 * @return {sap.ui.layout.form.FormElement} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.FormElement#destroyFields
 * @function
 */


/**
 * Returns the Label Control, even if the Label is entered as Text.
 *
 * @name sap.ui.layout.form.FormElement#getLabelControl
 * @function
 * @type sap.ui.core.Label
 * @public
 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
 */


// Start of sap\ui\layout\form\FormElement.js
/**
 * This file defines behavior for the control,
 */

jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained


// TODO deactivated until Element/Control has been clarified: sap.ui.core.EnabledPropagator.call(sap.ui.layout.form.FormElement.prototype);

(function() {

	sap.ui.layout.form.FormElement.prototype.init = function(){

		this._oFieldDelegate = {oElement: this, onAfterRendering: _fieldOnAfterRendering};

	};

	sap.ui.layout.form.FormElement.prototype.exit = function(){

		if (this._oLabel) {
			this._oLabel.destroy();
			delete this._oLabel;
		}

		this._oFieldDelegate = undefined;

	};

/*
 * sets the label for the FormElement. If it's only a string an internal label is created.
 * overwrite the isRequired and the getLabelForRendering functions with Form specific ones.
 */
	sap.ui.layout.form.FormElement.prototype.setLabel = function(vAny) {

		if (!this._oLabel) {
			var oOldLabel = this.getLabel();
			if (oOldLabel) {
				if (oOldLabel.isRequired) {
					oOldLabel.isRequired = oOldLabel._sapui_isRequired;
					oOldLabel._sapui_isRequired = undefined;
				}
				if (oOldLabel.getLabelForRendering) {
					oOldLabel.getLabelForRendering = oOldLabel._sapui_getLabelForRendering;
					oOldLabel._sapui_getLabelForRendering = undefined;
				}
			}
		}

		this.setAggregation("label", vAny);
		var oLabel = vAny;
		if (typeof oLabel === "string") {
			if (!this._oLabel) {
				this._oLabel = sap.ui.layout.form.FormHelper.createLabel(oLabel);
				this._oLabel.setParent(this);
				if (oLabel.isRequired) {
					this._oLabel.isRequired = _labelIsRequired;
				}
				this._oLabel.getLabelForRendering = _getLabelForRendering;
			}else{
				this._oLabel.setText(oLabel);
			}
		} else {
			if (this._oLabel) {
				this._oLabel.destroy();
				delete this._oLabel;
			}
			if (!oLabel) return this; //set label is called with null if label is removed by ManagedObject.removeChild
			if (oLabel.isRequired) {
				oLabel._sapui_isRequired = oLabel.isRequired;
				oLabel.isRequired = _labelIsRequired;
			}
			if (oLabel.getLabelForRendering) {
				oLabel._sapui_getLabelForRendering = oLabel.getLabelForRendering;
				oLabel.getLabelForRendering = _getLabelForRendering;
			}
		}

		return this;

	};

	sap.ui.layout.form.FormElement.prototype.getLabelControl = function() {

		if (this._oLabel) {
			return this._oLabel;
		} else {
			return this.getLabel();
		}

	};

	sap.ui.layout.form.FormElement.prototype.addField = function(oField) {

		this.addAggregation("fields", oField);
		oField.addDelegate(this._oFieldDelegate);

		return this;

	};

	sap.ui.layout.form.FormElement.prototype.insertField = function(oField, iIndex) {

		this.insertAggregation("fields", oField, iIndex);
		oField.addDelegate(this._oFieldDelegate);

		return this;

	};

	sap.ui.layout.form.FormElement.prototype.removeField = function(oField) {

		var oRemovedField = this.removeAggregation("fields", oField);
		oRemovedField.removeDelegate(this._oFieldDelegate);

		return oRemovedField;

	};

	sap.ui.layout.form.FormElement.prototype.removeAllFields = function() {

		var aRemovedFields = this.removeAllAggregation("fields");

		for ( var i = 0; i < aRemovedFields.length; i++) {
			var oRemovedField = aRemovedFields[i];
			oRemovedField.removeDelegate(this._oFieldDelegate);
		}

		return aRemovedFields;

	};

	sap.ui.layout.form.FormElement.prototype.destroyFields = function() {

		var aFields = this.getFields();

		for ( var i = 0; i < aFields.length; i++) {
			var oField = aFields[i];
			oField.removeDelegate(this._oFieldDelegate);
		}

		this.destroyAggregation("fields");

		return this;

	};

	sap.ui.layout.form.FormElement.prototype.updateFields = function() {

		var aFields = this.getFields();

		for ( var i = 0; i < aFields.length; i++) {
			var oField = aFields[i];
			oField.removeDelegate(this._oFieldDelegate);
		}

		this.updateAggregation("fields");

		aFields = this.getFields();

		for ( var i = 0; i < aFields.length; i++) {
			var oField = aFields[i];
			oField.addDelegate(this._oFieldDelegate);
		}

		return this;

	};

	/*
	 * Enhance Aria properties of fields to set aria-labelledby to FormElements label if not set otherwise
	 * Set aria-describedby to the title of the container, but only for the first field in the container
	 * This function is called during rendering.
	 */
	sap.ui.layout.form.FormElement.prototype.enhanceAccessibilityState = function(oElement, mAriaProps) {

		var oLabel = this.getLabelControl();
		if (oLabel && oLabel != oElement) {
			if (!mAriaProps["labelledby"]) {
				mAriaProps["labelledby"] = oLabel.getId();
			}

			var oContainer = this.getParent();
			var aElements = oContainer.getFormElements();
			if (this == aElements[0]) {
				// it's the first Element
				var aControls = this.getFields();
				if (oElement == aControls[0]) {
					//it's the first field
					var oTitle = oContainer.getTitle();
					if (oTitle) {
						var sId = "";
						if (typeof oTitle == "string") {
							sId = oContainer.getId()+"--title";
						} else {
							sId = oTitle.getId();
						}
						var sDescribedBy = mAriaProps["describedby"];
						if (sDescribedBy) {
							sDescribedBy = sDescribedBy + " " + sId;
						} else {
							sDescribedBy = sId;
						}
						mAriaProps["describedby"] = sDescribedBy;
					}
				}
			}
		}

		return mAriaProps;

	};

	/*
	 * If LayoutData changed on control this may need changes on the layout. So bubble to the form
	 */
	sap.ui.layout.form.FormElement.prototype.onLayoutDataChange = function(oEvent){

		// call function of parent (if assigned)
		var oParent = this.getParent();
		if (oParent && oParent.onLayoutDataChange) {
			oParent.onLayoutDataChange(oEvent);
		}

	};

	// *** Private helper functions ***

	/*
	 * overwrite Labels isRequired function to check if one of the fields in the element is required,
	 * not only the one directly assigned.
	 */
	var _labelIsRequired = function(){

		var oFormElement = this.getParent();
		var aFields = oFormElement.getFields();

		for ( var i = 0; i < aFields.length; i++) {
			var oField = aFields[i];
			if (oField.getRequired && oField.getRequired() === true) {
				return true;
			}
		}

		return false;

	};

	/*
	 * overwrite Labels getLabelForRendering function to point always to the first field.
	 * But only if the application does not set a labelFor explicitly.
	 */
	var _getLabelForRendering = function(){

		if (this.getLabelFor()) {
			return this.getLabelFor();
		}else {
			var oFormElement = this.getParent();
			var aFields = oFormElement.getFields();
			if (aFields[0]) {
				return aFields[0].getId();
			}
		}

	};

	/*
	 * If onAfterRendering of a field is processed the Form (layout) might need to change it.
	 */
	var _fieldOnAfterRendering = function(oEvent){

		// call function of parent (if assigned)
		var oParent = this.oElement.getParent();
		if (oParent && oParent.contentOnAfterRendering) {
			oParent.contentOnAfterRendering( this.oElement, oEvent.srcControl);
		}

	};

}());
}; // end of sap/ui/layout/form/FormElement.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.FormLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.FormLayout.
jQuery.sap.declare("sap.ui.layout.form.FormLayout");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new form/FormLayout.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Base layout for Forms.
 * Other Layouts must inherit from this one.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.FormLayout
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.form.FormLayout", { metadata : {

	library : "sap.ui.layout"
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.FormLayout with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.FormLayout.extend
 * @function
 */


// Start of sap\ui\layout\form\FormLayout.js
/**
 * This file defines behavior for the control,
 */



(function() {

	sap.ui.layout.form.FormLayout.prototype.contentOnAfterRendering = function(oFormElement, oControl){

		jQuery(oControl.getFocusDomRef()).data("sap.InNavArea", true);

	};

	sap.ui.layout.form.FormLayout.prototype.toggleContainerExpanded = function(oContainer){

		var bExpanded = oContainer.getExpanded();
		if(this.getDomRef()){
			if (bExpanded) {
				//show content
				oContainer.$("content").css("display", "");
			} else {
				//hide content
				oContainer.$("content").css("display", "none");
			}
		}

	};

	/*
	 * gets the layout data of a element (container, control...) for the needed layout data type
	 */
	sap.ui.layout.form.FormLayout.prototype.getLayoutDataForElement = function(oElement, sType){

		var oLayoutData = oElement.getLayoutData();

		var oClass = jQuery.sap.getObject(sType);

		if (!oLayoutData) {
			return undefined;
		}else if (oLayoutData instanceof oClass) {
			return oLayoutData;
		}else if (oLayoutData.getMetadata().getName() == "sap.ui.core.VariantLayoutData") {
			// multiple LayoutData available - search here
			var aLayoutData = oLayoutData.getMultipleLayoutData();
			for ( var i = 0; i < aLayoutData.length; i++) {
				var oLayoutData2 = aLayoutData[i];
				if (oLayoutData2 instanceof oClass) {
					return oLayoutData2;
				}
			}
		}

	};

	/* Keyboard handling
	 * In the FormLayout just a basic keyboard handling is implemented.
	 * This must be enhanced in the other Layouts if needed.
	 *
	 * The main idea is to navigate via arrow keys from control to control
	 * using Tab only the editable/active controls are reached. So the tab-chain is short
	 * Via F6 the navigation goes to the next container
	 * There is an "edit mode" to allow arrow key navigation inside of controls.
	 * For mobile application the Arrow-key navigation should be disabled
	 */

	sap.ui.layout.form.FormLayout.prototype.onsapright = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var that = this;

			if (!bRtl) {
				this.navigateForward(oEvent, that);
			} else {
				this.navigateBack(oEvent, that);
			}
		}

	};

	sap.ui.layout.form.FormLayout.prototype.onsapleft = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var that = this;

			if (!bRtl) {
				this.navigateBack(oEvent, that);
			} else {
				this.navigateForward(oEvent, that);
			}
		}

	};

	sap.ui.layout.form.FormLayout.prototype.onsapdown = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var oControl = oEvent.srcControl;
			var iCurrentIndex = 0;
			var oNewDomRef;
			var oRoot = this.findElement(oControl);
			var oElement = oRoot.element;
			oControl = oRoot.rootControl;
			if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
				oNewDomRef = this.findFieldBelow(oControl, oElement);
			} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
				// current control is not inside an Element - maybe a title or expander?
				oNewDomRef = this.findFirstFieldOfNextElement(oElement, 0);
			}

			if (oNewDomRef) {
				jQuery.sap.focus(oNewDomRef);
				oEvent.preventDefault(); // to avoid moving cursor in next field
			}
		}

	};

	sap.ui.layout.form.FormLayout.prototype.onsapup = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var oControl = oEvent.srcControl;
			var iCurrentIndex = 0;
			var oNewDomRef;
			var oRoot = this.findElement(oControl);
			var oElement = oRoot.element;
			oControl = oRoot.rootControl;
			if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
				oNewDomRef = this.findFieldAbove(oControl, oElement);
			} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
				// current control is not inside an Element - maybe a title or expander?
				var oForm = oElement.getParent();
				iCurrentIndex = oForm.indexOfFormContainer(oElement);
				oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex-1);
			}

			if (oNewDomRef) {
				jQuery.sap.focus(oNewDomRef);
				oEvent.preventDefault(); // to avoid moving cursor in next field
			}
		}

	};

	sap.ui.layout.form.FormLayout.prototype.onsaphome = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var oControl = oEvent.srcControl;
			var iCurrentIndex = 0;
			var oNewDomRef;
			var oRoot = this.findElement(oControl);
			var oElement = oRoot.element;
			var oContainer = oElement.getParent();
			var oForm = oContainer.getParent();

			iCurrentIndex = oForm.indexOfFormContainer(oContainer);
			// actually it's within the same container
			oNewDomRef = this.findFirstFieldOfFirstElementInNextContainer(oForm, iCurrentIndex);

			if (oNewDomRef) {
				jQuery.sap.focus(oNewDomRef);
				oEvent.preventDefault(); // to avoid moving cursor in next field
			}
		}

	};

	sap.ui.layout.form.FormLayout.prototype.onsaptop = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var oControl = oEvent.srcControl;
			var oRoot = this.findElement(oControl);
			var oElement = oRoot.element;
			var oNewDomRef;
			var oContainer;

			if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
				oContainer = oElement.getParent();
			} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
				// current control is not inside an Element - maybe a title or expander?
				oContainer = oElement;
			}
			var oForm = oContainer.getParent();

			oNewDomRef = this.findFirstFieldOfForm(oForm);

			if (oNewDomRef) {
				jQuery.sap.focus(oNewDomRef);
				oEvent.preventDefault(); // to avoid moving cursor in next field
			}
}

	};

	sap.ui.layout.form.FormLayout.prototype.onsapend = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var oControl = oEvent.srcControl;
			var iCurrentIndex = 0;
			var oNewDomRef;
			var oRoot = this.findElement(oControl);
			var oElement = oRoot.element;
			var oContainer = oElement.getParent();
			var oForm = oContainer.getParent();

			iCurrentIndex = oForm.indexOfFormContainer(oContainer);
			oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex);

			if (oNewDomRef) {
				jQuery.sap.focus(oNewDomRef);
				oEvent.preventDefault(); // to avoid moving cursor in next field
			}
}

	};

	sap.ui.layout.form.FormLayout.prototype.onsapbottom = function(oEvent){

		if (sap.ui.layout.form.FormHelper.bArrowKeySupport) {
			var oControl = oEvent.srcControl;
			var oRoot = this.findElement(oControl);
			var oElement = oRoot.element;
			var oNewDomRef;
			var oContainer;

			if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
				oContainer = oElement.getParent();
			} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
				// current control is not inside an Element - maybe a title or expander?
				oContainer = oElement;
			}
			var oForm = oContainer.getParent();

			var aContainers = oForm.getFormContainers();
			var iLength = aContainers.length;

			oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iLength - 1);

			if (oNewDomRef) {
				jQuery.sap.focus(oNewDomRef);
				oEvent.preventDefault(); // to avoid moving cursor in next field
			}
		}

	};

	sap.ui.layout.form.FormLayout.prototype.onsapexpand = function(oEvent){

		var oControl = oEvent.srcControl;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		var oContainer = oElement.getParent();

		if (oContainer.getExpandable()) {
			oContainer.setExpanded(true);
		}
	};

	sap.ui.layout.form.FormLayout.prototype.onsapcollapse = function(oEvent){

		var oControl = oEvent.srcControl;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		var oContainer = oElement.getParent();

		if (oContainer.getExpandable()) {
			oContainer.setExpanded(false);
		}
	};

	sap.ui.layout.form.FormLayout.prototype.onsapskipforward = function(oEvent){

		var oControl = oEvent.srcControl;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		oControl = oRoot.rootControl;
		var oNewDomRef;
		var oContainer;

		if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
			oContainer = oElement.getParent();
		} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
			// current control is not inside an Element - maybe a title or expander?
			oContainer = oElement;
		}
		var oForm = oContainer.getParent();
		var iCurrentIndex = oForm.indexOfFormContainer(oContainer);

		// goto next container
		oNewDomRef = this.findFirstFieldOfFirstElementInNextContainer(oForm, iCurrentIndex+1);
		if (!oNewDomRef) {
			oNewDomRef = this.findFirstFieldOfForm(oForm);
		}

		if (oNewDomRef) {
			jQuery.sap.focus(oNewDomRef);
			oEvent.preventDefault(); // to avoid moving cursor in next field
		}

	};

	sap.ui.layout.form.FormLayout.prototype.onsapskipback = function(oEvent){

		var oControl = oEvent.srcControl;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		oControl = oRoot.rootControl;
		var oNewDomRef;
		var oContainer;

		if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
			oContainer = oElement.getParent();
		} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
			// current control is not inside an Element - maybe a title or expander?
			oContainer = oElement;
		}
		var oForm = oContainer.getParent();
		var aContainers = oForm.getFormContainers();
		var iCurrentIndex = oForm.indexOfFormContainer(oContainer);

		// goto previous container
		while (!oNewDomRef && iCurrentIndex >= 0) {
			var oPrevContainer = aContainers[iCurrentIndex-1];
			if (!oPrevContainer.getExpandable() || oPrevContainer.getExpanded()) {
				oNewDomRef = this.findFirstFieldOfFirstElementInPrevContainer(oForm, iCurrentIndex-1);
			}
			iCurrentIndex = iCurrentIndex-1;
		}
		if (!oNewDomRef) {
			oNewDomRef = this.findLastFieldOfForm(oForm);
		}

		if (oNewDomRef) {
			jQuery.sap.focus(oNewDomRef);
			oEvent.preventDefault(); // to avoid moving cursor in next field
		}

	};

	sap.ui.layout.form.FormLayout.prototype.findElement = function(oControl){
		// since the source control can be part of a child control or layout we have to look in the control tree
		// to find the FormElement where the control is assigned

		var oElement = oControl.getParent();
		var oRootControl = oControl;

		while (oElement && !(oElement instanceof sap.ui.layout.form.FormElement) &&
				!(oElement && oElement instanceof sap.ui.layout.form.FormContainer) &&
				!(oElement && oElement instanceof sap.ui.layout.form.Form)) {
			oRootControl = oElement;
			oElement = oElement.getParent();
		}

		return ({rootControl: oRootControl, element: oElement});

	};

	sap.ui.layout.form.FormLayout.prototype.navigateForward = function(oEvent){

		var oControl = oEvent.srcControl;
		var iCurrentIndex = 0;
		var oNewDomRef;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		oControl = oRoot.rootControl;

		if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
			if (oControl == oElement.getLabelControl()) {
				iCurrentIndex = -1;
			} else {
				iCurrentIndex = oElement.indexOfField(oControl);
			}
			oNewDomRef = this.findNextFieldOfElement(oElement, iCurrentIndex+1);

			if (!oNewDomRef) {
				// use 1st field of next Element
				var oContainer = oElement.getParent();
				iCurrentIndex = oContainer.indexOfFormElement(oElement);
				oNewDomRef = this.findFirstFieldOfNextElement(oContainer, iCurrentIndex+1);

				if (!oNewDomRef) {
					// no next element -> look in next container
					var oForm = oContainer.getParent();
					iCurrentIndex = oForm.indexOfFormContainer(oContainer);
					oNewDomRef = this.findFirstFieldOfFirstElementInNextContainer(oForm, iCurrentIndex+1);
				}
			}
		} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
			// current control is not inside an Element - maybe a title or expander?
			oNewDomRef = this.findFirstFieldOfNextElement(oElement, 0);
		}

		if (oNewDomRef) {
			jQuery.sap.focus(oNewDomRef);
			oEvent.preventDefault(); // to avoid moving cursor in next field
		}

	};

	sap.ui.layout.form.FormLayout.prototype.tabForward = function(oEvent){

		var oControl = oEvent.srcControl;
		var iCurrentIndex = 0;
		var oNewDomRef;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		oControl = oRoot.rootControl;

		if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
			if (oControl == oElement.getLabelControl()) {
				iCurrentIndex = -1;
			} else {
				iCurrentIndex = oElement.indexOfField(oControl);
			}
			oNewDomRef = this.findNextFieldOfElement(oElement, iCurrentIndex+1, true);

			if (!oNewDomRef) {
				// use 1st field of next Element
				var oContainer = oElement.getParent();
				iCurrentIndex = oContainer.indexOfFormElement(oElement);
				oNewDomRef = this.findFirstFieldOfNextElement(oContainer, iCurrentIndex+1, true);

				if (!oNewDomRef) {
					// no next element -> look in next container
					var oForm = oContainer.getParent();
					iCurrentIndex = oForm.indexOfFormContainer(oContainer);
					oNewDomRef = this.findFirstFieldOfFirstElementInNextContainer(oForm, iCurrentIndex+1, true);
				}
			}
		} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
			// current control is not inside an Element - maybe a title or expander?
			oNewDomRef = this.findFirstFieldOfNextElement(oElement, 0, true);
			if (!oNewDomRef) {
				// no next element -> look in next container
				var oForm = oElement.getParent();
				iCurrentIndex = oForm.indexOfFormContainer(oElement);
				oNewDomRef = this.findFirstFieldOfFirstElementInNextContainer(oForm, iCurrentIndex+1, true);
			}
		}

		if (oNewDomRef) {
			jQuery.sap.focus(oNewDomRef);
			oEvent.preventDefault(); // to avoid moving cursor in next field
		}

	};

	sap.ui.layout.form.FormLayout.prototype.findNextFieldOfElement = function(oElement, iStartIndex, bTabOver){

		var aFields = oElement.getFields();
		var iLength = aFields.length;
		var oNewDomRef;

		for ( var i = iStartIndex; i < iLength; i++) {
			// find the next enabled control thats rendered
			var oField = aFields[i];
			var oDomRef = this._getDomRef(oField);
			if (bTabOver == true){
				if ((!oField.getEditable || oField.getEditable()) && (!oField.getEnabled || oField.getEnabled()) && oDomRef) {
					oNewDomRef = oDomRef;
					break;
				}
			} else {
				if ((!oField.getEnabled || oField.getEnabled()) && oDomRef) {
					oNewDomRef = oDomRef;
					break;
				}
			}
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findFirstFieldOfNextElement = function(oContainer, iStartIndex, bTabOver){

		var aElements = oContainer.getFormElements();
		var iLength = aElements.length;
		var oNewDomRef;
		var i = iStartIndex;

		while (!oNewDomRef && i < iLength) {
			var oElement = aElements[i];
			if (bTabOver == true){
				oNewDomRef = this.findNextFieldOfElement(oElement, 0, true);
			} else {
				oNewDomRef = this.findNextFieldOfElement(oElement, 0);
			}
			i++;
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findFirstFieldOfForm = function(oForm){
		var aContainers = oForm.getFormContainers();
		var oNewDomRef;
		var oContainer = aContainers[0];
		if (!oContainer.getExpandable() || oContainer.getExpanded()) {
			oNewDomRef = this.findFirstFieldOfNextElement(oContainer, 0);
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findLastFieldOfForm = function(oForm){
		var aContainers = oForm.getFormContainers();
		var iLength = aContainers.length;
		var oNewDomRef;
		var oContainer = aContainers[iLength -1];
		if (!oContainer.getExpandable() || oContainer.getExpanded()) {
			oNewDomRef = this.findFirstFieldOfNextElement(oContainer, 0);
		}

		return oNewDomRef;

	};

		sap.ui.layout.form.FormLayout.prototype.findFirstFieldOfLastContainerOfForm = function(oForm){
		var aContainers = oForm.getFormContainers();
		var iLength = aContainers.length;
		var oNewDomRef;
		var oContainer = aContainers[iLength -1];
		if (!oContainer.getExpandable() || oContainer.getExpanded()) {
			oNewDomRef = this.findFirstFieldOfNextElement(oContainer, 0);
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findFirstFieldOfFirstElementInNextContainer = function(oForm, iStartIndex, bTabOver){

		var aContainers = oForm.getFormContainers();
		var iLength = aContainers.length;
		var oNewDomRef;
		var i = iStartIndex;

		while (!oNewDomRef && i < iLength) {
			var oContainer = aContainers[i];
			if (oContainer.getExpandable() && bTabOver) {
				oNewDomRef = oContainer._oExpandButton.getFocusDomRef();
				if (oNewDomRef) {
					break;
				}
			}
			if (!oContainer.getExpandable() || oContainer.getExpanded()) {
				if (bTabOver == true){
					oNewDomRef = this.findFirstFieldOfNextElement(oContainer, 0, true);
				} else {
					oNewDomRef = this.findFirstFieldOfNextElement(oContainer, 0);
				}
			}
			i++;
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findFirstFieldOfFirstElementInPrevContainer = function(oForm, iStartIndex){

		var aContainers = oForm.getFormContainers();
		var iLength = aContainers.length;
		var oNewDomRef;
		var i = iStartIndex;

		while (!oNewDomRef && i < iLength && i >= 0) {
			var oContainer = aContainers[i];
			if (!oContainer.getExpandable() || oContainer.getExpanded()) {
				oNewDomRef = this.findFirstFieldOfNextElement(oContainer, 0);
			}
			i++;
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.navigateBack = function(oEvent){

		var oControl = oEvent.srcControl;
		var iCurrentIndex = 0;
		var oNewDomRef;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		oControl = oRoot.rootControl;
		if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
			if (oControl == oElement.getLabelControl()) {
				iCurrentIndex = 0;
			} else {
				iCurrentIndex = oElement.indexOfField(oControl);
			}
			oNewDomRef = this.findPrevFieldOfElement(oElement, iCurrentIndex-1);

			if (!oNewDomRef) {
				// use 1st field of next Element
				var oContainer = oElement.getParent();
				iCurrentIndex = oContainer.indexOfFormElement(oElement);
				oNewDomRef = this.findLastFieldOfPrevElement(oContainer, iCurrentIndex-1);

				if (!oNewDomRef) {
					// no next element -> look in next container
					var oForm = oContainer.getParent();
					iCurrentIndex = oForm.indexOfFormContainer(oContainer);
					oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex-1);
				}
			}
		} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
			// current control is not inside an Element - maybe a title or expander?
			var oForm = oElement.getParent();
			iCurrentIndex = oForm.indexOfFormContainer(oElement);
			oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex-1);
		}

		if (oNewDomRef) {
			jQuery.sap.focus(oNewDomRef);
			oEvent.preventDefault(); // to avoid moving cursor in next field
		}

	};

	sap.ui.layout.form.FormLayout.prototype.tabBack = function(oEvent){

		var oControl = oEvent.srcControl;
		var iCurrentIndex = 0;
		var oNewDomRef;
		var oRoot = this.findElement(oControl);
		var oElement = oRoot.element;
		oControl = oRoot.rootControl;
		if (oElement && oElement instanceof sap.ui.layout.form.FormElement) {
			if (oControl == oElement.getLabelControl()) {
				iCurrentIndex = 0;
			} else {
				iCurrentIndex = oElement.indexOfField(oControl);
			}
			oNewDomRef = this.findPrevFieldOfElement(oElement, iCurrentIndex-1, true);

			if (!oNewDomRef) {
				// use 1st field of next Element
				var oContainer = oElement.getParent();
				iCurrentIndex = oContainer.indexOfFormElement(oElement);
				oNewDomRef = this.findLastFieldOfPrevElement(oContainer, iCurrentIndex-1, true);

				if (!oNewDomRef) {
					// no next element -> look in next container
					var oForm = oContainer.getParent();
					iCurrentIndex = oForm.indexOfFormContainer(oContainer);
					if (oContainer.getExpandable()) {
						oNewDomRef = oContainer._oExpandButton.getFocusDomRef();
					}
					if (!oNewDomRef) {
						oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex-1, true);
					}
				}
			}
		} else if (oElement && oElement instanceof sap.ui.layout.form.FormContainer) {
			// current control is not inside an Element - maybe a title or expander?
			var oForm = oElement.getParent();
			iCurrentIndex = oForm.indexOfFormContainer(oElement);
			oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex-1, true);
		}

		if (oNewDomRef) {
			jQuery.sap.focus(oNewDomRef);
			oEvent.preventDefault(); // to avoid moving cursor in next field
		}

	};
	

	sap.ui.layout.form.FormLayout.prototype.findPrevFieldOfElement = function(oElement, iStartIndex, bTabOver){

		var aFields = oElement.getFields();
		var oNewDomRef;

		for ( var i = iStartIndex; i >= 0; i--) {
			// find the next enabled control thats rendered
			var oField = aFields[i];
			var oDomRef = this._getDomRef(oField);
			if (bTabOver == true){
				if ((!oField.getEditable || oField.getEditable()) && (!oField.getEnabled || oField.getEnabled()) && oDomRef) {
					oNewDomRef = oDomRef;
					break;
				}
			} else {
				if ((!oField.getEnabled || oField.getEnabled()) && oDomRef) {
					oNewDomRef = oDomRef;
					break;
				}
			}
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findLastFieldOfPrevElement = function(oContainer, iStartIndex, bTabOver){

		var aElements = oContainer.getFormElements();
		var oNewDomRef;
		var i = iStartIndex;

		while (!oNewDomRef && i >= 0) {
			var oElement = aElements[i];
			var iLength = oElement.getFields().length;

			if (bTabOver == true){
				oNewDomRef = this.findPrevFieldOfElement(oElement, iLength-1, true);
			} else {
				oNewDomRef = this.findPrevFieldOfElement(oElement, iLength-1);
			}
			i--;
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findLastFieldOfLastElementInPrevContainer = function(oForm, iStartIndex, bTabOver){

		var aContainers = oForm.getFormContainers();
		var oNewDomRef;
		var i = iStartIndex;

		while (!oNewDomRef && i >= 0) {
			var oContainer = aContainers[i];
			if (oContainer.getExpandable() && !oContainer.getExpanded() && bTabOver) {
				oNewDomRef = oContainer._oExpandButton.getFocusDomRef();
				if (oNewDomRef) {
					break;
				}
			}
			if (!oContainer.getExpandable() || oContainer.getExpanded()) {
				var iLength = oContainer.getFormElements().length;
				if (bTabOver == true){
					oNewDomRef = this.findLastFieldOfPrevElement(oContainer, iLength-1, true);
				} else {
					oNewDomRef = this.findLastFieldOfPrevElement(oContainer, iLength-1, 0);
				}
			}
			i--;
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype.findFieldBelow = function(oControl, oElement){

		var oContainer = oElement.getParent();
		var iCurrentIndex = oContainer.indexOfFormElement(oElement);
		var oNewDomRef = this.findFirstFieldOfNextElement(oContainer, iCurrentIndex+1);

		if (!oNewDomRef) {
			// no next element -> look in next container
			var oForm = oContainer.getParent();
			iCurrentIndex = oForm.indexOfFormContainer(oContainer);
			oNewDomRef = this.findFirstFieldOfFirstElementInNextContainer(oForm, iCurrentIndex+1);
		}

		return oNewDomRef;

	};


	sap.ui.layout.form.FormLayout.prototype.findFieldAbove = function(oControl, oElement){

		var oContainer = oElement.getParent();
		var iCurrentIndex = oContainer.indexOfFormElement(oElement);

		var aElements = oContainer.getFormElements();
		var oNewDomRef;
		var i = iCurrentIndex-1;

		while (!oNewDomRef && i >= 0) {
			var oElement = aElements[i];
			oNewDomRef = this.findPrevFieldOfElement(oElement, 0);
			i--;
		}

		if (!oNewDomRef) {
			// no next element -> look in previous container
			var oForm = oContainer.getParent();
			iCurrentIndex = oForm.indexOfFormContainer(oContainer);
			oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex-1);
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.FormLayout.prototype._getDomRef = function( oControl ){

		// get focusDOMRef of the control, but only if it's focusable
		var oDomRef = oControl.getFocusDomRef();
		if (!jQuery(oDomRef).is(":sapFocusable")) {
			oDomRef = undefined;
		}

		return oDomRef;

	};


}());

}; // end of sap/ui/layout/form/FormLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.GridContainerData') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.GridContainerData.
jQuery.sap.declare("sap.ui.layout.form.GridContainerData");

jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained



/**
 * Constructor for a new form/GridContainerData.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getHalfGrid halfGrid} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.LayoutData#constructor sap.ui.core.LayoutData}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Grid layout specific properties for FormContainers.
 * The width and height properties of the elements are ignored since the witdh and heights are defined by the grid cells.
 * @extends sap.ui.core.LayoutData
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.GridContainerData
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.LayoutData.extend("sap.ui.layout.form.GridContainerData", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"halfGrid" : {type : "boolean", group : "Misc", defaultValue : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.GridContainerData with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.GridContainerData.extend
 * @function
 */


/**
 * Getter for property <code>halfGrid</code>.
 * If set the container takes half the width of the form (8cells), if not it's the full width (16 cells).
 * If the GridLayout is set to be singleColumn the full width of the Grid is only 8 cells. So containers are rendered only one per row.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>halfGrid</code>
 * @public
 * @name sap.ui.layout.form.GridContainerData#getHalfGrid
 * @function
 */

/**
 * Setter for property <code>halfGrid</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bHalfGrid  new value for property <code>halfGrid</code>
 * @return {sap.ui.layout.form.GridContainerData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.GridContainerData#setHalfGrid
 * @function
 */


// Start of sap\ui\layout\form\GridContainerData.js
///**
// * This file defines behavior for the control, 
// */
//sap.ui.commons.form.GridLayoutdata.prototype.init = function(){
//   // do something for initialization...
//};

}; // end of sap/ui/layout/form/GridContainerData.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.GridElementData') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.GridElementData.
jQuery.sap.declare("sap.ui.layout.form.GridElementData");

jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained



/**
 * Constructor for a new form/GridElementData.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getHCells hCells} : sap.ui.layout.form.GridElementCells (default: 'auto')</li>
 * <li>{@link #getVCells vCells} : int (default: 1)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.LayoutData#constructor sap.ui.core.LayoutData}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The grid specific layout data for FormElement fields.
 * The width property of the elements is ignored since the width is defined by grid cells.
 * @extends sap.ui.core.LayoutData
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.GridElementData
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.LayoutData.extend("sap.ui.layout.form.GridElementData", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"hCells" : {type : "sap.ui.layout.form.GridElementCells", group : "Appearance", defaultValue : 'auto'},
		"vCells" : {type : "int", group : "Appearance", defaultValue : 1}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.GridElementData with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.GridElementData.extend
 * @function
 */


/**
 * Getter for property <code>hCells</code>.
 * Number of cells in horizontal direction.
 * If "auto" the size is determined by the number of fields and the available cells. For Labels the auto size is 3 cells.
 * If "full" only one field is allowed within the element. It gets the full width of the row and the label is displayed above. For Labels Full size has no effect.
 *
 * Default value is <code>auto</code>
 *
 * @return {sap.ui.layout.form.GridElementCells} the value of property <code>hCells</code>
 * @public
 * @name sap.ui.layout.form.GridElementData#getHCells
 * @function
 */

/**
 * Setter for property <code>hCells</code>.
 *
 * Default value is <code>auto</code> 
 *
 * @param {sap.ui.layout.form.GridElementCells} sHCells  new value for property <code>hCells</code>
 * @return {sap.ui.layout.form.GridElementData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.GridElementData#setHCells
 * @function
 */


/**
 * Getter for property <code>vCells</code>.
 * Number of cells in vertical direction.
 * This property has no effect for labels.
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>vCells</code>
 * @public
 * @name sap.ui.layout.form.GridElementData#getVCells
 * @function
 */

/**
 * Setter for property <code>vCells</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iVCells  new value for property <code>vCells</code>
 * @return {sap.ui.layout.form.GridElementData} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.GridElementData#setVCells
 * @function
 */


// Start of sap\ui\layout\form\GridElementData.js
///**
// * This file defines behavior for the control, 
// */
//sap.ui.commons.form.GridElementData.prototype.init = function(){
//   // do something for initialization...
//};

}; // end of sap/ui/layout/form/GridElementData.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.GridLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.GridLayout.
jQuery.sap.declare("sap.ui.layout.form.GridLayout");




/**
 * Constructor for a new form/GridLayout.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getSingleColumn singleColumn} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.layout.form.FormLayout#constructor sap.ui.layout.form.FormLayout}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * This Layout implements a guideline 2.0 grid. This can be a 16 column grid or an 8 column grid.
 * 
 * To adjust the content inside the GridLayout GridContainerData and GridElementData could be used.
 * @extends sap.ui.layout.form.FormLayout
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.GridLayout
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.form.FormLayout.extend("sap.ui.layout.form.GridLayout", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"singleColumn" : {type : "boolean", group : "Misc", defaultValue : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.GridLayout with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.GridLayout.extend
 * @function
 */


/**
 * Getter for property <code>singleColumn</code>.
 * If set the Grid allows only one container column. That means one container is below the other. The whole grid has 8 cells per row.
 * 
 * If not set containers can use the full width of the grid or two container can be placed beside each other. In this case the whole grid has 16 cell per row.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>singleColumn</code>
 * @public
 * @name sap.ui.layout.form.GridLayout#getSingleColumn
 * @function
 */

/**
 * Setter for property <code>singleColumn</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSingleColumn  new value for property <code>singleColumn</code>
 * @return {sap.ui.layout.form.GridLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.GridLayout#setSingleColumn
 * @function
 */


// Start of sap\ui\layout\form\GridLayout.js
/**
 * This file defines behavior for the control
 */




(function() {

	sap.ui.layout.form.GridLayout.prototype.toggleContainerExpanded = function(oContainer){

		// rerendering of the form is needed
		this.invalidate();

	};

	sap.ui.layout.form.GridLayout.prototype.onAfterRendering = function(){

		// set tabindex of expander buttons to -1 to prevent tabbing from outside the Form
		// directly to the expander
		var oForm = this.getParent();
		if (oForm) {
			var aContainers = oForm.getFormContainers();
			for ( var i = 0; i < aContainers.length; i++) {
				var oContainer = aContainers[i];
				if (oContainer.getExpandable()) {
					oContainer._oExpandButton.$().attr("tabindex", "-1");
				}
			}
		}

	};

	/*
	 * If onAfterRendering of a field is processed the width must be set to 100%
	 */
	sap.ui.layout.form.GridLayout.prototype.contentOnAfterRendering = function(oFormElement, oControl){

		sap.ui.layout.form.FormLayout.prototype.contentOnAfterRendering.apply(this, arguments);

		if (oControl.getMetadata().getName() != "sap.ui.commons.Image" ) {
			oControl.$().css("width", "100%");
		}

	};

	/*
	 * If LayoutData changed on one control this needs to rerender the whole table
	 * because it may influence other rows and columns
	 */
	sap.ui.layout.form.GridLayout.prototype.onLayoutDataChange = function(oEvent){

		if (this.getDomRef()) {
			// only if already rendered
			this.rerender();
		}

	};

	sap.ui.layout.form.GridLayout.prototype.onsaptabnext= function(oEvent){

		var bRtl = sap.ui.getCore().getConfiguration().getRTL();

		if (!bRtl) {
			this.tabForward(oEvent);
		} else {
			this.tabBack(oEvent);
		}

	};

	sap.ui.layout.form.GridLayout.prototype.onsaptabprevious = function(oEvent){

		var bRtl = sap.ui.getCore().getConfiguration().getRTL();

		if (!bRtl) {
			this.tabBack(oEvent);
		} else {
			this.tabForward(oEvent);
		}

	};

	sap.ui.layout.form.GridLayout.prototype.findFieldOfElement = function(oElement, iStartIndex, iLeft){

		if (!iLeft) {
			return sap.ui.layout.form.FormLayout.prototype.findPrevFieldOfElement.apply(this, arguments);
		}

		if (!oElement.getVisible()) {
			return;
		}

		var aFields = oElement.getFields();
		var oNewDomRef;

		var iIndex = aFields.length;
		iStartIndex = iIndex - 1;


		for ( var i = iStartIndex; i >= 0; i--) {
			// find the next enabled control thats rendered
			var oField = aFields[i];
			var iLeftnew = oField.$().offset().left;
			if (iLeft < iLeftnew && i != 0) {
				continue;
			}
			var oDomRef = this._getDomRef(oField);
			if ((!oField.getEnabled || oField.getEnabled()) && oDomRef) {
				oNewDomRef = oDomRef;
				break;
			}
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.GridLayout.prototype.findFieldBelow = function(oControl, oElement){

		var oContainer = oElement.getParent();
		var iCurrentIndex = oContainer.indexOfFormElement(oElement);
		var oNewDomRef;

		if(oContainer.getVisible()) {
			var aElements = oContainer.getFormElements();
			var iMax = aElements.length;
			var i = iCurrentIndex+1;
			var iLeft = oControl.$().offset().left;

			while (!oNewDomRef && i < iMax) {
				var oElement = aElements[i];
				oNewDomRef = this.findFieldOfElement(oElement, 0, iLeft);
				i++;
			}
		}

		if (!oNewDomRef) {
			// no next element -> look in next container
			var oForm = oContainer.getParent();
			iCurrentIndex = oForm.indexOfFormContainer(oContainer);
			oNewDomRef = this.findFirstFieldOfFirstElementInNextContainer(oForm, iCurrentIndex+1);
		}

		return oNewDomRef;

	};

	sap.ui.layout.form.GridLayout.prototype.findFieldAbove = function(oControl, oElement){

		var oContainer = oElement.getParent();
		var iCurrentIndex = oContainer.indexOfFormElement(oElement);
		var oNewDomRef;

		if(oContainer.getVisible()) {
			var aElements = oContainer.getFormElements();
			var i = iCurrentIndex-1;
			var iLeft = oControl.$().offset().left;

			while (!oNewDomRef && i >= 0) {
				var oElement = aElements[i];
				oNewDomRef = this.findFieldOfElement(oElement, 0, iLeft);
				i--;
			}
		}

		if (!oNewDomRef) {
			// no next element -> look in previous container
			var oForm = oContainer.getParent();
			iCurrentIndex = oForm.indexOfFormContainer(oContainer);
			oNewDomRef = this.findLastFieldOfLastElementInPrevContainer(oForm, iCurrentIndex-1);
		}

		return oNewDomRef;

	};

}());
}; // end of sap/ui/layout/form/GridLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveGridLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.ResponsiveGridLayout.
jQuery.sap.declare("sap.ui.layout.form.ResponsiveGridLayout");




/**
 * Constructor for a new form/ResponsiveGridLayout.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getLabelSpanL labelSpanL} : int (default: 4)</li>
 * <li>{@link #getLabelSpanM labelSpanM} : int (default: 2)</li>
 * <li>{@link #getLabelSpanS labelSpanS} : int (default: 12)</li>
 * <li>{@link #getEmptySpanL emptySpanL} : int (default: 0)</li>
 * <li>{@link #getEmptySpanM emptySpanM} : int (default: 0)</li>
 * <li>{@link #getEmptySpanS emptySpanS} : int (default: 0)</li>
 * <li>{@link #getColumnsL columnsL} : int (default: 2)</li>
 * <li>{@link #getColumnsM columnsM} : int (default: 1)</li>
 * <li>{@link #getBreakpointL breakpointL} : int (default: 1024)</li>
 * <li>{@link #getBreakpointM breakpointM} : int (default: 600)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.layout.form.FormLayout#constructor sap.ui.layout.form.FormLayout}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Renders a form using a Grid. Internally the Grid is used.
 * On the FormContainers, Labels and Fields GridData can be used to change the default rendering. On FormElements GridDada are not supported.
 * If own GridData are used this may be much more complex than the default. So in some cases the calculation for the other content may nor bring the expected result. In this case GridData should be used at all content to disable the default behaviour.
 * @extends sap.ui.layout.form.FormLayout
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.ResponsiveGridLayout
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.form.FormLayout.extend("sap.ui.layout.form.ResponsiveGridLayout", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"labelSpanL" : {type : "int", group : "Misc", defaultValue : 4},
		"labelSpanM" : {type : "int", group : "Misc", defaultValue : 2},
		"labelSpanS" : {type : "int", group : "Misc", defaultValue : 12},
		"emptySpanL" : {type : "int", group : "Misc", defaultValue : 0},
		"emptySpanM" : {type : "int", group : "Misc", defaultValue : 0},
		"emptySpanS" : {type : "int", group : "Misc", defaultValue : 0},
		"columnsL" : {type : "int", group : "Misc", defaultValue : 2},
		"columnsM" : {type : "int", group : "Misc", defaultValue : 1},
		"breakpointL" : {type : "int", group : "Misc", defaultValue : 1024},
		"breakpointM" : {type : "int", group : "Misc", defaultValue : 600}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.ResponsiveGridLayout with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.ResponsiveGridLayout.extend
 * @function
 */


/**
 * Getter for property <code>labelSpanL</code>.
 * Default span for labels in large size.
 * This span is only used if more than 1 container is in one line, if only 1 container is in the line the labelSpanM value is used.
 *
 * Default value is <code>4</code>
 *
 * @return {int} the value of property <code>labelSpanL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getLabelSpanL
 * @function
 */

/**
 * Setter for property <code>labelSpanL</code>.
 *
 * Default value is <code>4</code> 
 *
 * @param {int} iLabelSpanL  new value for property <code>labelSpanL</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setLabelSpanL
 * @function
 */


/**
 * Getter for property <code>labelSpanM</code>.
 * Default span for labels in medium size.
 * This property is used for full size containers. if more than one Container is in one line, labelSpanL is used.
 *
 * Default value is <code>2</code>
 *
 * @return {int} the value of property <code>labelSpanM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getLabelSpanM
 * @function
 */

/**
 * Setter for property <code>labelSpanM</code>.
 *
 * Default value is <code>2</code> 
 *
 * @param {int} iLabelSpanM  new value for property <code>labelSpanM</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setLabelSpanM
 * @function
 */


/**
 * Getter for property <code>labelSpanS</code>.
 * Default span for labels in small size.
 *
 * Default value is <code>12</code>
 *
 * @return {int} the value of property <code>labelSpanS</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getLabelSpanS
 * @function
 */

/**
 * Setter for property <code>labelSpanS</code>.
 *
 * Default value is <code>12</code> 
 *
 * @param {int} iLabelSpanS  new value for property <code>labelSpanS</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setLabelSpanS
 * @function
 */


/**
 * Getter for property <code>emptySpanL</code>.
 * Number of grid cells that are empty at the end of each line on large size.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>emptySpanL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getEmptySpanL
 * @function
 */

/**
 * Setter for property <code>emptySpanL</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iEmptySpanL  new value for property <code>emptySpanL</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setEmptySpanL
 * @function
 */


/**
 * Getter for property <code>emptySpanM</code>.
 * Number of grid cells that are empty at the end of each line on medium size.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>emptySpanM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getEmptySpanM
 * @function
 */

/**
 * Setter for property <code>emptySpanM</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iEmptySpanM  new value for property <code>emptySpanM</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setEmptySpanM
 * @function
 */


/**
 * Getter for property <code>emptySpanS</code>.
 * Number of grid cells that are empty at the end of each line on small size.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>emptySpanS</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getEmptySpanS
 * @function
 */

/**
 * Setter for property <code>emptySpanS</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iEmptySpanS  new value for property <code>emptySpanS</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setEmptySpanS
 * @function
 */


/**
 * Getter for property <code>columnsL</code>.
 * Form columns for large size.
 * The number of columns for large size must not be smaller that the number of columns for medium size
 *
 * Default value is <code>2</code>
 *
 * @return {int} the value of property <code>columnsL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getColumnsL
 * @function
 */

/**
 * Setter for property <code>columnsL</code>.
 *
 * Default value is <code>2</code> 
 *
 * @param {int} iColumnsL  new value for property <code>columnsL</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setColumnsL
 * @function
 */


/**
 * Getter for property <code>columnsM</code>.
 * Form columns for medium size.
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>columnsM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getColumnsM
 * @function
 */

/**
 * Setter for property <code>columnsM</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iColumnsM  new value for property <code>columnsM</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setColumnsM
 * @function
 */


/**
 * Getter for property <code>breakpointL</code>.
 * Breakpoint between Medium size and Large size.
 *
 * Default value is <code>1024</code>
 *
 * @return {int} the value of property <code>breakpointL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getBreakpointL
 * @function
 */

/**
 * Setter for property <code>breakpointL</code>.
 *
 * Default value is <code>1024</code> 
 *
 * @param {int} iBreakpointL  new value for property <code>breakpointL</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setBreakpointL
 * @function
 */


/**
 * Getter for property <code>breakpointM</code>.
 * Breakpoint between Small size and Medium size.
 *
 * Default value is <code>600</code>
 *
 * @return {int} the value of property <code>breakpointM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#getBreakpointM
 * @function
 */

/**
 * Setter for property <code>breakpointM</code>.
 *
 * Default value is <code>600</code> 
 *
 * @param {int} iBreakpointM  new value for property <code>breakpointM</code>
 * @return {sap.ui.layout.form.ResponsiveGridLayout} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.ResponsiveGridLayout#setBreakpointM
 * @function
 */


// Start of sap\ui\layout\form\ResponsiveGridLayout.js
///**
// * This file defines behavior for the control, 
// */




/*
 * The ResponsiveGridLayout uses Grid controls to render the Form
 * If more than one FormContainer is used there is an outer Grid (mainGrid) that holds the FormContainers
 * Each FormContainer holds it's own Grid where the FormElements content is placed.
 * If a FormContainer has a Title or is expandable it is rendered as a ResponsiveGridLayoutPanel.
 * The panels and GridLayouts are stored in this.mContainers. This has the following structure:
 * - For each FormContainer there is an entry inside the object. (this.mContainers[FormContainerId])
 * - For each FormContainer there is an array with 2 entries:
 *   - [0]: The Panel that renders the Container (undefined if no panel is used)
 *   - [1]: The Grid that holds the Containers content
 *          - the getLayoutData function of this Grid is overwritten to get the LayoutData of the FormContainer
 *            (If no panel is used)
 *
 * It must be made sure to hold this object up to date. So it is filled onBeforeRendering. Entries no longer used are deleted
 *
*/

sap.ui.core.Control.extend("sap.ui.layout.form.ResponsiveGridLayoutPanel", {

	metadata : {
		aggregations: {
			"content"   : {type: "sap.ui.layout.Grid", multiple: false}
		},
		associations: {
			"container" : {type: "sap.ui.layout.form.FormContainer", multiple: false},
			"layout"    : {type: "sap.ui.layout.form.ResponsiveLayout", multiple: false}
		}
	},

	getLayoutData :  function(){

		// only ResponsiveFlowLayoutData are interesting
		var oContainer = sap.ui.getCore().byId(this.getContainer());
		var oLayout    = sap.ui.getCore().byId(this.getLayout());
		var oLD;
		if (oLayout && oContainer) {
			oLD = oLayout.getLayoutDataForElement(oContainer, "sap.ui.layout.GridData");
		}
		if (oLD) {
			return oLD;
		}else {
			return this.getAggregation("layoutData");
		}

	},

	getCustomData :  function(){

		var oContainer = sap.ui.getCore().byId(this.getContainer());
		if (oContainer) {
			return oContainer.getCustomData();
		}

	},

	refreshExpanded :  function(){

		var oContainer = sap.ui.getCore().byId(this.getContainer());
		if (oContainer) {
			if (oContainer.getExpanded()) {
				this.$().removeClass("sapUiRGLContainerColl");
			}else {
				this.$().addClass("sapUiRGLContainerColl");
			}
		}
	},

	renderer : function(oRm, oPanel) {

		var oContainer = sap.ui.getCore().byId(oPanel.getContainer());
		var oLayout    = sap.ui.getCore().byId(oPanel.getLayout());
		var oContent   = oPanel.getContent();

		var bExpandable = oContainer.getExpandable();
		var sTooltip = oContainer.getTooltip_AsString();

		oRm.write("<div");
		oRm.writeControlData(oPanel);
		oRm.addClass("sapUiRGLContainer");
		if (bExpandable && !oContainer.getExpanded()) {
			oRm.addClass("sapUiRGLContainerColl");
		}

		if (sTooltip) {
			oRm.writeAttributeEscaped('title', sTooltip);
		}
		oRm.writeClasses();
		oRm.write(">");

		// container header
		if (oContainer.getTitle()) {
			oLayout.getRenderer().renderTitle(oRm, oContainer.getTitle(), oContainer._oExpandButton, bExpandable, false, oContainer.getId());
		}

		if (oContent) {
			oRm.write("<div");
			oRm.addClass("sapUiRGLContainerCont");
			oRm.writeClasses();
			oRm.write(">");
			// container is not expandable or is expanded -> render elements
			oRm.renderControl(oContent);
			oRm.write("</div>");
		}

		oRm.write("</div>");
	}

});

(function() {

	sap.ui.layout.form.ResponsiveGridLayout.prototype.init = function(){

		this.mContainers = {}; //association of container to panel and Grid
		this.oDummyLayoutData = new sap.ui.layout.GridData(this.getId()+"--Dummy");
		this.SPANPATTERN = /^([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;

	};

	sap.ui.layout.form.ResponsiveGridLayout.prototype.exit = function(){

		var that = this;

		// clear panels
		for ( var sContainerId in this.mContainers) {
			_cleanContainer(that, sContainerId);
		}

		// clear main Grid
		if (this._mainGrid) {
			this._mainGrid.destroy();
			delete this._mainGrid;
		}

		this.oDummyLayoutData.destroy();
		this.oDummyLayoutData = undefined;

	};

	sap.ui.layout.form.ResponsiveGridLayout.prototype.onBeforeRendering = function( oEvent ){

		var oForm = this.getParent();
		if (!oForm || !(oForm instanceof sap.ui.layout.form.Form)) {
			// layout not assigned to form - nothing to do
			return;
		}

		oForm._bNoInvalidate = true; // don't invalidate Form if only the Grids, Panels and LayoutData are created or changed)
		var that = this;
		_createPanels(that, oForm);
		_createMainGrid(that, oForm);
		oForm._bNoInvalidate = false;

	};

	sap.ui.layout.form.ResponsiveGridLayout.prototype.onAfterRendering = function( oEvent ){

		// special case: Form has desktop size but Containers have Tablet size: label sizes must be 4 instead of 2
		if (this._mainGrid) {
			var sMedia;
			if (this._mainGrid.$().hasClass("sapUiRespGridMedia-Std-Desktop")) {
				sMedia = "Desktop";
			}else if (this._mainGrid.$().hasClass("sapUiRespGridMedia-Std-Tablet")) {
				sMedia = "Tablet";
			}else if (this._mainGrid.$().hasClass("sapUiRespGridMedia-Std-Phone")) {
				sMedia = "Phone";
			}
		}

		// if main grid is used, deregister resize listeners of container grids. Because resize is triggered from main grid
		// container grids can't resize if main grid is not resized.
		if (this._mainGrid && this._mainGrid.__bIsUsed ) {
			for ( var sContainerId in this.mContainers) {
				if (this.mContainers[sContainerId][1]._sContainerResizeListener) {
					sap.ui.core.ResizeHandler.deregister(this.mContainers[sContainerId][1]._sContainerResizeListener);
					this.mContainers[sContainerId][1]._sContainerResizeListener = null;
				}
			}
		}

	};

	/*
	 * If onAfterRendering of a field is processed the width must be set to 100% (if no other width set)
	 */
	sap.ui.layout.form.ResponsiveGridLayout.prototype.contentOnAfterRendering = function(oFormElement, oControl){

		sap.ui.layout.form.FormLayout.prototype.contentOnAfterRendering.apply(this, arguments);

		if (oControl.getWidth && ( !oControl.getWidth() || oControl.getWidth() == "auto" ) && oControl.getMetadata().getName() != "sap.ui.commons.Image") {
			oControl.$().css("width", "100%");
		}

	};

	sap.ui.layout.form.ResponsiveGridLayout.prototype.toggleContainerExpanded = function(oContainer){

		//adapt the corresponding panel
		var bExpanded = oContainer.getExpanded();
		var sContainerId = oContainer.getId();
		if (this.mContainers[sContainerId] && this.mContainers[sContainerId][0]) {
			var oPanel = this.mContainers[sContainerId][0];
			oPanel.refreshExpanded();
		}

	};

	sap.ui.layout.form.ResponsiveGridLayout.prototype.onLayoutDataChange = function(oEvent){

		var oSource = oEvent.srcControl;

		// if layoutData changed for a Container, Element, or Field call the
		// onLayoutDataChange function of the parent ResponsiveFlowLayout

		if (oSource instanceof sap.ui.layout.form.FormContainer) {
			if (this._mainGrid) {
				this._mainRFGrid.onLayoutDataChange(oEvent);
			}
		}else if (oSource instanceof sap.ui.layout.form.FormElement) {
			// LayoutData on FormElement not supported in ResponsiveGridLayout
		}else{
			var oParent = oSource.getParent();
			if (oParent instanceof sap.ui.layout.form.FormElement) {
				var oContainer = oParent.getParent();
				var sContainerId = oContainer.getId();
				var sElementId = oParent.getId();
				if (this.mContainers[sContainerId] && this.mContainers[sContainerId][1]) {
					this.mContainers[sContainerId][1].onLayoutDataChange(oEvent);
				}
			}
		}

	};

	sap.ui.layout.form.ResponsiveGridLayout.prototype.onsapup = function(oEvent){
		this.onsapleft(oEvent);
	};

	sap.ui.layout.form.ResponsiveGridLayout.prototype.onsapdown = function(oEvent){
		this.onsapright(oEvent);
	};

	function _createPanels( oLayout, oForm ) {

		var aContainers = oForm.getFormContainers();
		var iLength = aContainers.length;
		var iVisibleContainers = 0;
		var iVisibleContainer = 0;
		var aVisibleContainers = [];
		var oPanel;
		var oGrid;
		var oContainer;
		var sContainerId;
		var i = 0;
		for ( i = 0; i < iLength; i++) {
			oContainer = aContainers[i];
			oContainer._checkProperties();
			if (oContainer.getVisible()) {
				iVisibleContainers++;
				aVisibleContainers.push(oContainer);
			}
		}
		for ( i = 0; i < iVisibleContainers; i++) {
			oContainer = aVisibleContainers[i];
			if (oContainer.getVisible()) {
				iVisibleContainer++;
				sContainerId = oContainer.getId();
				oPanel = undefined;
				oGrid = undefined;
				var oContainerNext = aVisibleContainers[i + 1];
				if (oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][1]) {
					// Grid already created
					oGrid = oLayout.mContainers[sContainerId][1];
				}else{
					oGrid = _createGrid(oLayout, oContainer);
				}

				var oTitle = oContainer.getTitle();
				if (oTitle || oContainer.getExpandable()) {
					// only if container has a title a panel is used
					if (oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][0]) {
						// Panel already created
						oPanel = oLayout.mContainers[sContainerId][0];
					}else{
						oPanel = _createPanel(oLayout, oContainer, oGrid);
						_changeGetLayoutDataOfGrid(oGrid, true);
					}
					_setLayoutDataForLinebreak(oPanel, oContainer, iVisibleContainer, oContainerNext, iVisibleContainers);
				}else{
					if (oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][0]) {
						// panel not longer needed
						_deletePanel(oLayout.mContainers[sContainerId][0]);
					}
					_changeGetLayoutDataOfGrid(oGrid, false);
					_setLayoutDataForLinebreak(oGrid, oContainer, iVisibleContainer, oContainerNext, iVisibleContainers);
				}

				oLayout.mContainers[sContainerId] = [oPanel, oGrid];
			}
		}

		var iObjectLength = _objectLength(oLayout.mContainers);
		if (iVisibleContainers < iObjectLength) {
			// delete old containers panels
			for ( sContainerId in oLayout.mContainers) {
				var bFound = false;
				for ( i = 0; i < iLength; i++) {
					oContainer = aContainers[i];
					if (sContainerId == oContainer.getId() && oContainer.getVisible()) {
						bFound = true;
						break;
					}
				}
				if (!bFound) {
					_cleanContainer(oLayout, sContainerId);
				}
			}
		}

	}

	function _createPanel( oLayout, oContainer, oGrid ) {

		var sContainerId = oContainer.getId();
		var oPanel = new sap.ui.layout.form.ResponsiveGridLayoutPanel(sContainerId+"---Panel", {
			container: oContainer,
			layout   : oLayout,
			content : oGrid
		});

		return oPanel;

	}

	/*
	 * clear variables before delete it
	 */
	function _deletePanel( oPanel ) {

		oPanel.setContent("");
		oPanel.setLayout("");
		oPanel.setContainer("");
		oPanel.destroy();
		delete oPanel;

	}

	function _createGrid( oLayout, oContainer ) {

		var sId = oContainer.getId()+"--Grid";

		var oGrid = new sap.ui.layout.Grid(sId, {vSpacing: 0, hSpacing: 0, containerQuery: true});
		oGrid.__myParentLayout = oLayout;
		oGrid.__myParentContainerId = oContainer.getId();
		oGrid.addStyleClass("sapUiFormResGridCont");

		oGrid.getContent = function(){
			var oContainer = sap.ui.getCore().byId(this.__myParentContainerId);
			if (oContainer) {
				var aContent = new Array;
				var aElements = oContainer.getFormElements();
				var aFields;
				var oLabel;
				for ( var i = 0; i < aElements.length; i++) {
					var oElement = aElements[i];
					if (oElement.getVisible()) {
						oLabel = oElement.getLabelControl();
						if (oLabel) {
							aContent.push(oLabel);
						}
						aFields = oElement.getFields();
						for ( var j = 0; j < aFields.length; j++) {
							aContent.push(aFields[j]);
						}
					}
				}
				return aContent;
			}else{
				return false;
			}
		}

		oGrid._getLayoutDataForControl = function(oControl) {
			var oLayout = this.__myParentLayout;
			var oLD = oLayout.getLayoutDataForElement(oControl, "sap.ui.layout.GridData");

			var oElement = oControl.getParent();
			var oLabel = oElement.getLabelControl();
			if (oLD) {
				if (oLabel == oControl) {
					oLD._setStylesInternal("sapUiFormResGridLbl");
				}
				return oLD;
			}else {
				// calculate Layout Data for control
				var oContainer = sap.ui.getCore().byId(this.__myParentContainerId);
				var oContainerLD = oLayout.getLayoutDataForElement(oContainer, "sap.ui.layout.GridData");
				var oForm = oContainer.getParent();
				// for overall grid, label has default Span of 2, but in L 2 Containers are in one line, so 2 Grids are in one line
				var iLabelLSpan = oLayout.getLabelSpanL();
				var iLabelMSpan = oLayout.getLabelSpanM();
				var iLabelSSpan = oLayout.getLabelSpanS();

				if (oForm.getFormContainers().length >= 1 && oLayout.getColumnsM() > 1) {
					// More than one Container in line
					iLabelMSpan = oLayout.getLabelSpanL();
				}
				if (oContainerLD) {
					if (oContainerLD._getEffectiveSpanLarge() == 12) {
						// If Container has the Full width in large Screen, use 2 as Label Span to be in line
						iLabelLSpan = oLayout.getLabelSpanM();
						iLabelMSpan = oLayout.getLabelSpanM();
					}
				}
				if (oForm.getFormContainers().length == 1 || oLayout.getColumnsL() == 1) {
					// only one container -> it's full size
					iLabelLSpan = oLayout.getLabelSpanM();
					iLabelMSpan = oLayout.getLabelSpanM();
				}
				if (oLabel == oControl) {
					oLayout.oDummyLayoutData.setSpan("L"+ iLabelLSpan +" M"+ iLabelMSpan +" S"+ iLabelSSpan);
					oLayout.oDummyLayoutData.setLinebreak(true);
					oLayout.oDummyLayoutData._setStylesInternal("sapUiFormResGridLbl");
					return oLayout.oDummyLayoutData;
				} else {
					var iLSpan = 12 - oLayout.getEmptySpanL();
					var iMSpan = 12 - oLayout.getEmptySpanM();
					var iSSpan = 12 - oLayout.getEmptySpanS();
					var iEffectiveSpan;
					if (oLabel) {
						var oLabelLD = oLayout.getLayoutDataForElement(oLabel, "sap.ui.layout.GridData");
						if (oLabelLD) {
							iEffectiveSpan = oLabelLD._getEffectiveSpanLarge();
							if (iEffectiveSpan) {
								iLabelLSpan = iEffectiveSpan;
							}
							iEffectiveSpan = oLabelLD._getEffectiveSpanMedium();
							if (iEffectiveSpan) {
								iLabelMSpan = iEffectiveSpan;
							}
							iEffectiveSpan = oLabelLD._getEffectiveSpanSmall();
							if (iEffectiveSpan) {
								iLabelSSpan = iEffectiveSpan;
							}
						}
						if (iLabelLSpan < 12) {
							iLSpan = iLSpan - iLabelLSpan;
						}
						if (iLabelMSpan < 12) {
							iMSpan = iMSpan - iLabelMSpan;
						}
						if (iLabelSSpan < 12) {
							iSSpan = iSSpan - iLabelSSpan;
						}
					}

					var aFields = oElement.getFields();
					var iLength = aFields.length;
					var iDefaultFields = 1; // because current field has no LayoutData
					var bFirstField = false;
					for ( var i = 0; i < iLength; i++) {
						var oField = aFields[i];
						if (oField != oControl) {
							// check if other fields have layoutData
							var oFieldLD = oLayout.getLayoutDataForElement(oField, "sap.ui.layout.GridData");
							// is Spans are too large - ignore in calculation....
							if (oFieldLD) {
								iEffectiveSpan = oFieldLD._getEffectiveSpanLarge();
								if (iEffectiveSpan && iEffectiveSpan < iLSpan) {
									iLSpan = iLSpan - iEffectiveSpan;
								}
								iEffectiveSpan = oFieldLD._getEffectiveSpanMedium();
								if (iEffectiveSpan && iEffectiveSpan < iMSpan) {
									iMSpan = iMSpan - iEffectiveSpan;
								}
								iEffectiveSpan = oFieldLD._getEffectiveSpanSmall();
								if (iEffectiveSpan && iEffectiveSpan < iSSpan) {
									iSSpan = iSSpan - iEffectiveSpan;
								}
							}else {
								iDefaultFields++;
							}
						}else{
							if (iDefaultFields == 1) {
								bFirstField = true;
							}
						}
					}
					var iMyLSpan, iMyMSpan, iMySSpan = 12;
					if (bFirstField) {
						var iRest = iLSpan - Math.floor(iLSpan / iDefaultFields) * iDefaultFields;
						iMyLSpan = Math.floor(iLSpan / iDefaultFields) + iRest;
						iRest = iMSpan - Math.floor(iMSpan / iDefaultFields) * iDefaultFields;
						iMyMSpan = Math.floor(iMSpan / iDefaultFields) + iRest;
						if (iLabelSSpan < 12) {
							// label is defined to not be full size -> make fields left of it
							iRest = iSSpan - Math.floor(iSSpan / iDefaultFields) * iDefaultFields;
							iMySSpan = Math.floor(iSSpan / iDefaultFields) + iRest;
						}
					} else {
						iMyLSpan = Math.floor(iLSpan / iDefaultFields);
						iMyMSpan = Math.floor(iMSpan / iDefaultFields);
						if (iLabelSSpan < 12) {
							// label is defined to not be full size -> make fields left of it
							iMySSpan = Math.floor(iSSpan / iDefaultFields);
						}
					}

					oLayout.oDummyLayoutData.setSpan("L"+iMyLSpan+" M"+iMyMSpan+" S"+iMySSpan);
					oLayout.oDummyLayoutData.setLinebreak(bFirstField && !oLabel);
					oLayout.oDummyLayoutData._setStylesInternal(undefined);
					return oLayout.oDummyLayoutData;
				}

				return oLD;
			}
		}

		// change resize handler so that the container Grids always get the same Media size like the main grid
		oGrid._onParentResizeOrig = oGrid._onParentResize;
		oGrid._onParentResize = function() {

			// Prove if Dom reference exist, and if not - clean up the references.
			if (!this.getDomRef()) {
				this._cleanup();
				return;
			}

			if (!jQuery(this.getDomRef()).is(":visible")) {
				return;
			}

			var oLayout = this.__myParentLayout;
			if (!oLayout._mainGrid || !oLayout._mainGrid.__bIsUsed ) {
				// no main grid used -> only 1 container
				var aContainers = oLayout.getParent().getFormContainers();
				if (!oLayout.mContainers[aContainers[0].getId()] || aContainers[0].getId() != this.__myParentContainerId) {
					// Form seems to be invalidated (container changed) but rerendering still not done
					// -> ignore resize, it will be rerendered soon
					return;
				}
				if(oLayout.mContainers[this.__myParentContainerId][0]){
					// panel used -> get size from panel
					var oDomRef = oLayout.mContainers[this.__myParentContainerId][0].getDomRef();

					var iCntWidth = oDomRef.clientWidth;
					if (iCntWidth <= oLayout.getBreakpointM()) {
						this._toggleClass("Phone");
					} else if ((iCntWidth > oLayout.getBreakpointM()) && (iCntWidth <= oLayout.getBreakpointL())) {
						this._toggleClass("Tablet");
					} else {
						this._toggleClass("Desktop");
					}
				}else {
					this._setBreakPointTablet(oLayout.getBreakpointM());
					this._setBreakPointDesktop(oLayout.getBreakpointL());
					this._onParentResizeOrig();
				}
			} else {
				var $DomRefMain = oLayout._mainGrid.$();

				if ($DomRefMain.hasClass("sapUiRespGridMedia-Std-Phone")) {
					this._toggleClass("Phone");
				} else if ($DomRefMain.hasClass("sapUiRespGridMedia-Std-Tablet")) {
					this._toggleClass("Tablet");
				} else {
					this._toggleClass("Desktop");
				}
			}
		}

		return oGrid;

	}

	/*
	 * clear variables before delete it
	 */
	function _deleteGrid( oGrid ) {

		if (oGrid.__myParentContainerId) {
			oGrid.__myParentContainerId = undefined;
		}
		oGrid.__myParentLayout = undefined;

		oGrid.destroy();
		delete oGrid;

	}

	function _changeGetLayoutDataOfGrid( oGrid, bOriginal ) {
		// only GridData are from interest

		if (bOriginal) {
			if (oGrid.__originalGetLayoutData) {
				oGrid.getLayoutData = oGrid.__originalGetLayoutData;
				delete oGrid.__originalGetLayoutData;
			}
		}else if(!oGrid.__originalGetLayoutData){
			oGrid.__originalGetLayoutData = oGrid.getLayoutData;
			oGrid.getLayoutData = function(){
				var oLayout = this.__myParentLayout;
				var oContainer = sap.ui.getCore().byId(this.__myParentContainerId);

				var oLD;
				if (oContainer) {
					oLD = oLayout.getLayoutDataForElement(oContainer, "sap.ui.layout.GridData");
				}

				if (oLD) {
					return oLD;
				}else {
					return this.getAggregation("layoutData");
				}
			};
		}

	}

	// every second container gets a Linebreak for large screens
	// oControl could be a Panel or a Grid( if no panel used)
	function _setLayoutDataForLinebreak( oControl, oContainer, iVisibleContainer, oContainerNext, iVisibleContainers ) {

		var oLayout;
		if (oControl instanceof sap.ui.layout.form.ResponsiveGridLayoutPanel) {
			oLayout = sap.ui.getCore().byId(oControl.getLayout());
		} else {
			oLayout = oControl.__myParentLayout;
		}

		var iColumnsL = oLayout.getColumnsL();
		var iColumnsM = oLayout.getColumnsM();
		var oLD = oLayout.getLayoutDataForElement(oContainer, "sap.ui.layout.GridData");
		if (!oLD) {
			// only needed if container has no own LayoutData
			var bLinebreakL = (iVisibleContainer % iColumnsL) == 1;
			var bLastL = (iVisibleContainer % iColumnsL) == 0;
			var bLastRowL = iVisibleContainer > (iVisibleContainers - iColumnsL + (iVisibleContainers % iColumnsL));
			var bLinebreakM = (iVisibleContainer % iColumnsM) == 1;
			var bLastM = (iVisibleContainer % iColumnsM) == 0;
			var bLastRowM = iVisibleContainer > (iVisibleContainers - iColumnsM + (iVisibleContainers % iColumnsM));

			if (oContainerNext) {
				var oLDNext = oLayout.getLayoutDataForElement(oContainerNext, "sap.ui.layout.GridData");
				if (oLDNext && ( oLDNext.getLinebreak() || oLDNext.getLinebreakL() )) {
					bLastL = true;
					bLastRowL = false;
				}
				if (oLDNext && ( oLDNext.getLinebreak() || oLDNext.getLinebreakM() )) {
					bLastM = true;
					bLastRowM = false;
				}
			}

			var sStyle = "";
			if (bLastL) {
				sStyle = "sapUiFormResGridLastContL";
			}
			if (bLastM) {
				if (sStyle) {
					sStyle = sStyle + " ";
				}
				sStyle = sStyle + "sapUiFormResGridLastContM";
			}
			if (bLastRowL) {
				if (sStyle) {
					sStyle = sStyle + " ";
				}
				sStyle = sStyle + "sapUiFormResGridLastRowL";
			}
			if (bLastRowM) {
				if (sStyle) {
					sStyle = sStyle + " ";
				}
				sStyle = sStyle + "sapUiFormResGridLastRowM";
			}

			oLD = oControl.getLayoutData();
			if (!oLD) {
				oLD = new sap.ui.layout.GridData(oControl.getId()+"--LD", { linebreakL: bLinebreakL, linebreakM: bLinebreakM });
				oControl.setLayoutData( oLD );
			} else {
				oLD.setLinebreakL(bLinebreakL);
				oLD.setLinebreakM(bLinebreakM);
			}
			oLD._setStylesInternal(sStyle);
		}

	}

	function _cleanContainer( oLayout, sContainerId ) {

		var aContainerContent = oLayout.mContainers[sContainerId];

		//delete Grid
		var oGrid = aContainerContent[1];
		if (oGrid) {
			_deleteGrid(oGrid);
		}

		//delete panel
		var oPanel = aContainerContent[0];
		if (oPanel) {
			_deletePanel(oPanel);
		}

		delete oLayout.mContainers[sContainerId];

	}

	function _createMainGrid( oLayout, oForm ) {

		var aContainers = oForm.getFormContainers();
		var oContainer;
		var iLength = 0;
		var iContentLenght = 0;
		var i = 0;

		// count only visible containers
		for ( i = 0; i < aContainers.length; i++) {
			oContainer = aContainers[i];
			if (oContainer.getVisible()) {
				iLength++;
			}
		}

		// special case: only one container -> do not render an outer ResponsiveFlowLayout
		if (iLength > 1) {
			var iSpanL = Math.floor(12 / oLayout.getColumnsL());
			var iSpanM = Math.floor(12 / oLayout.getColumnsM());
			if (!oLayout._mainGrid) {
				oLayout._mainGrid = new sap.ui.layout.Grid(oForm.getId()+"--Grid",{
					defaultSpan: "L"+iSpanL+" M"+iSpanM+" S12",
					hSpacing: 0,
					vSpacing: 0,
					containerQuery: true
					}).setParent(oLayout);
				oLayout._mainGrid.addStyleClass("sapUiFormResGridMain");
				// change resize handler so that the main grid triggers the resize of it's children
				oLayout._mainGrid._onParentResizeOrig = oLayout._mainGrid._onParentResize;
				oLayout._mainGrid._onParentResize = function() {
					this._onParentResizeOrig();

					for ( var sContainerId in oLayout.mContainers) {
						oLayout.mContainers[sContainerId][1]._onParentResize();
					}

				};
			}else{
				oLayout._mainGrid.setDefaultSpan("L"+iSpanL+" M"+iSpanM+" S12");
				// update containers
				var aLayoutContent = oLayout._mainGrid.getContent();
				iContentLenght = aLayoutContent.length;
				var bExchangeContent = false;
				// check if content has changed
				for ( i = 0; i < iContentLenght; i++) {
					var oContentElement = aLayoutContent[i];
					oContainer = undefined;
					if (oContentElement.getContainer) {
						// it's a panel
						oContainer = sap.ui.getCore().byId(oContentElement.getContainer());
					} else {
						// it's a Grid
						oContainer = sap.ui.getCore().byId(oContentElement.__myParentContainerId);
					}
					if (oContainer && oContainer.getVisible()) {
						var aContainerContent = oLayout.mContainers[oContainer.getId()];
						if (aContainerContent[0] && aContainerContent[0] != oContentElement) {
							// container uses panel but panel not the same element in content
							bExchangeContent = true;
							break;
						}
						if (!aContainerContent[0] && aContainerContent[1] && aContainerContent[1] != oContentElement) {
							// container uses no panel but Grid not the same element in content
							bExchangeContent = true;
							break;
						}
					}else{
						// no container exits for content -> just remove this content
						oLayout._mainGrid.removeContent(oContentElement);
					}
				}
				if (bExchangeContent) {
					// remove all content and add it new.
					oLayout._mainGrid.removeAllContent();
					iContentLenght = 0;
				}
			}
			oLayout._mainGrid._setBreakPointTablet(oLayout.getBreakpointM());
			oLayout._mainGrid._setBreakPointDesktop(oLayout.getBreakpointL());
			oLayout._mainGrid.__bIsUsed = true;

			if (iContentLenght < iLength) {
				// new containers added
				for ( i = 0; i < aContainers.length; i++) {
					oContainer = aContainers[i];
					if (oContainer.getVisible()) {
						var sContainerId = oContainer.getId();
						if (oLayout.mContainers[sContainerId]) {
							if (oLayout.mContainers[sContainerId][0]) {
								// panel used
								oLayout._mainGrid.addContent(oLayout.mContainers[sContainerId][0]);
							} else if (oLayout.mContainers[sContainerId][1]){
								// no panel - used Grid directly
								oLayout._mainGrid.addContent(oLayout.mContainers[sContainerId][1]);
							}
						}
					}
				}
			}
		}else if( oLayout._mainGrid ) {
			oLayout._mainGrid.__bIsUsed = false;
		}

	}

	function _objectLength(oObject){

		var iLength = 0;

		if (!Object.keys) {
			jQuery.each(oObject, function(){iLength++});
		} else {
			iLength = Object.keys(oObject).length;
		}

		return iLength;

	}

}());

}; // end of sap/ui/layout/form/ResponsiveGridLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.SimpleForm') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.SimpleForm.
jQuery.sap.declare("sap.ui.layout.form.SimpleForm");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new form/SimpleForm.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getMaxContainerCols maxContainerCols} : int (default: 2)</li>
 * <li>{@link #getMinWidth minWidth} : int (default: -1)</li>
 * <li>{@link #getEditable editable} : boolean</li>
 * <li>{@link #getLabelMinWidth labelMinWidth} : int (default: 192)</li>
 * <li>{@link #getLayout layout} : sap.ui.layout.form.SimpleFormLayout (default: sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout)</li>
 * <li>{@link #getLabelSpanL labelSpanL} : int (default: 4)</li>
 * <li>{@link #getLabelSpanM labelSpanM} : int (default: 2)</li>
 * <li>{@link #getLabelSpanS labelSpanS} : int (default: 12)</li>
 * <li>{@link #getEmptySpanL emptySpanL} : int (default: 0)</li>
 * <li>{@link #getEmptySpanM emptySpanM} : int (default: 0)</li>
 * <li>{@link #getEmptySpanS emptySpanS} : int (default: 0)</li>
 * <li>{@link #getColumnsL columnsL} : int (default: 2)</li>
 * <li>{@link #getColumnsM columnsM} : int (default: 1)</li>
 * <li>{@link #getBreakpointL breakpointL} : int (default: 1024)</li>
 * <li>{@link #getBreakpointM breakpointM} : int (default: 600)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Element[]</li>
 * <li>{@link #getTitle title} : sap.ui.core.Title|string</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Use the SimpleForm to create a form based on title, label and fields that are stacked in the content aggregation. Add Title to start a new FormContainer(Group). Add Label to start a new row in the container. Add Input/Display controls as needed. Use LayoutData to influence the layout for special cases in the Input/Display controls.
 * @extends sap.ui.core.Control
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.SimpleForm
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.form.SimpleForm", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"maxContainerCols" : {type : "int", group : "Appearance", defaultValue : 2},
		"minWidth" : {type : "int", group : "Appearance", defaultValue : -1},
		"editable" : {type : "boolean", group : "Misc", defaultValue : null},
		"labelMinWidth" : {type : "int", group : "Misc", defaultValue : 192},
		"layout" : {type : "sap.ui.layout.form.SimpleFormLayout", group : "Misc", defaultValue : sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout},
		"labelSpanL" : {type : "int", group : "Misc", defaultValue : 4},
		"labelSpanM" : {type : "int", group : "Misc", defaultValue : 2},
		"labelSpanS" : {type : "int", group : "Misc", defaultValue : 12},
		"emptySpanL" : {type : "int", group : "Misc", defaultValue : 0},
		"emptySpanM" : {type : "int", group : "Misc", defaultValue : 0},
		"emptySpanS" : {type : "int", group : "Misc", defaultValue : 0},
		"columnsL" : {type : "int", group : "Misc", defaultValue : 2},
		"columnsM" : {type : "int", group : "Misc", defaultValue : 1},
		"breakpointL" : {type : "int", group : "Misc", defaultValue : 1024},
		"breakpointM" : {type : "int", group : "Misc", defaultValue : 600}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Element", multiple : true, singularName : "content"}, 
		"form" : {type : "sap.ui.layout.form.Form", multiple : false, visibility : "hidden"}, 
		"title" : {type : "sap.ui.core.Title", altTypes : ["string"], multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.SimpleForm with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.SimpleForm.extend
 * @function
 */


/**
 * Getter for property <code>maxContainerCols</code>.
 * The maximum amount of inner FormContainers per row that is used before a new row is started.
 * (If a ResponsiveGridLayout is used as layout this property is not used. Please use the properties ColumnsL and ColumnsM in this case.)
 *
 * Default value is <code>2</code>
 *
 * @return {int} the value of property <code>maxContainerCols</code>
 * @public
 * @name sap.ui.layout.form.SimpleForm#getMaxContainerCols
 * @function
 */

/**
 * Setter for property <code>maxContainerCols</code>.
 *
 * Default value is <code>2</code> 
 *
 * @param {int} iMaxContainerCols  new value for property <code>maxContainerCols</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#setMaxContainerCols
 * @function
 */


/**
 * Getter for property <code>minWidth</code>.
 * The overall minimal width in pixels that is used for the SimpleForm. If the available width is below the given minWidth the SimpleForm will create a new row for the next FormContainer.
 * -1 value is default meaning that inner FormContainers will be stacked until maxCols is reached, irrespective if a maxWidth is reached or the available parents width is reached.
 * (only used if ResponsiveLayout is used as Layout)
 *
 * Default value is <code>-1</code>
 *
 * @return {int} the value of property <code>minWidth</code>
 * @public
 * @name sap.ui.layout.form.SimpleForm#getMinWidth
 * @function
 */

/**
 * Setter for property <code>minWidth</code>.
 *
 * Default value is <code>-1</code> 
 *
 * @param {int} iMinWidth  new value for property <code>minWidth</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#setMinWidth
 * @function
 */


/**
 * Getter for property <code>editable</code>.
 * Applies a device and theme specific line-height to the form elements if the form has editable content.
 * In this case all (not only the editable) rows of the form will get the line height.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @name sap.ui.layout.form.SimpleForm#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#setEditable
 * @function
 */


/**
 * Getter for property <code>labelMinWidth</code>.
 * Specifies the min-width in pixels of the label in all form containers. (only used if ResponsiveLaout is used as Layout)
 *
 * Default value is <code>192</code>
 *
 * @return {int} the value of property <code>labelMinWidth</code>
 * @public
 * @name sap.ui.layout.form.SimpleForm#getLabelMinWidth
 * @function
 */

/**
 * Setter for property <code>labelMinWidth</code>.
 *
 * Default value is <code>192</code> 
 *
 * @param {int} iLabelMinWidth  new value for property <code>labelMinWidth</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#setLabelMinWidth
 * @function
 */


/**
 * Getter for property <code>layout</code>.
 * The FormLayout that is used to render the SimpleForm
 *
 * Default value is <code>ResponsiveLayout</code>
 *
 * @return {sap.ui.layout.form.SimpleFormLayout} the value of property <code>layout</code>
 * @public
 * @name sap.ui.layout.form.SimpleForm#getLayout
 * @function
 */

/**
 * Setter for property <code>layout</code>.
 *
 * Default value is <code>ResponsiveLayout</code> 
 *
 * @param {sap.ui.layout.form.SimpleFormLayout} oLayout  new value for property <code>layout</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#setLayout
 * @function
 */


/**
 * Getter for property <code>labelSpanL</code>.
 * Default span for labels in large size.
 * This span is only used if more than 1 container is in one line, if only 1 container is in the line the labelSpanM value is used.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>4</code>
 *
 * @return {int} the value of property <code>labelSpanL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getLabelSpanL
 * @function
 */

/**
 * Setter for property <code>labelSpanL</code>.
 *
 * Default value is <code>4</code> 
 *
 * @param {int} iLabelSpanL  new value for property <code>labelSpanL</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setLabelSpanL
 * @function
 */


/**
 * Getter for property <code>labelSpanM</code>.
 * Default span for labels in medium size.
 * This property is used for full size containers. If more than one Container is in one line, labelSpanL is used.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>2</code>
 *
 * @return {int} the value of property <code>labelSpanM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getLabelSpanM
 * @function
 */

/**
 * Setter for property <code>labelSpanM</code>.
 *
 * Default value is <code>2</code> 
 *
 * @param {int} iLabelSpanM  new value for property <code>labelSpanM</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setLabelSpanM
 * @function
 */


/**
 * Getter for property <code>labelSpanS</code>.
 * Default span for labels in small size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>12</code>
 *
 * @return {int} the value of property <code>labelSpanS</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getLabelSpanS
 * @function
 */

/**
 * Setter for property <code>labelSpanS</code>.
 *
 * Default value is <code>12</code> 
 *
 * @param {int} iLabelSpanS  new value for property <code>labelSpanS</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setLabelSpanS
 * @function
 */


/**
 * Getter for property <code>emptySpanL</code>.
 * Number of grid cells that are empty at the end of each line on large size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>emptySpanL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getEmptySpanL
 * @function
 */

/**
 * Setter for property <code>emptySpanL</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iEmptySpanL  new value for property <code>emptySpanL</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setEmptySpanL
 * @function
 */


/**
 * Getter for property <code>emptySpanM</code>.
 * Number of grid cells that are empty at the end of each line on medium size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>emptySpanM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getEmptySpanM
 * @function
 */

/**
 * Setter for property <code>emptySpanM</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iEmptySpanM  new value for property <code>emptySpanM</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setEmptySpanM
 * @function
 */


/**
 * Getter for property <code>emptySpanS</code>.
 * Number of grid cells that are empty at the end of each line on small size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>emptySpanS</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getEmptySpanS
 * @function
 */

/**
 * Setter for property <code>emptySpanS</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iEmptySpanS  new value for property <code>emptySpanS</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setEmptySpanS
 * @function
 */


/**
 * Getter for property <code>columnsL</code>.
 * Form columns for large size.
 * The number of columns for large size must not be smaller that the number of columns for medium size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>2</code>
 *
 * @return {int} the value of property <code>columnsL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getColumnsL
 * @function
 */

/**
 * Setter for property <code>columnsL</code>.
 *
 * Default value is <code>2</code> 
 *
 * @param {int} iColumnsL  new value for property <code>columnsL</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setColumnsL
 * @function
 */


/**
 * Getter for property <code>columnsM</code>.
 * Form columns for medium size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>1</code>
 *
 * @return {int} the value of property <code>columnsM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getColumnsM
 * @function
 */

/**
 * Setter for property <code>columnsM</code>.
 *
 * Default value is <code>1</code> 
 *
 * @param {int} iColumnsM  new value for property <code>columnsM</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setColumnsM
 * @function
 */


/**
 * Getter for property <code>breakpointL</code>.
 * Breakpoint between Medium size and Large size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>1024</code>
 *
 * @return {int} the value of property <code>breakpointL</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getBreakpointL
 * @function
 */

/**
 * Setter for property <code>breakpointL</code>.
 *
 * Default value is <code>1024</code> 
 *
 * @param {int} iBreakpointL  new value for property <code>breakpointL</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setBreakpointL
 * @function
 */


/**
 * Getter for property <code>breakpointM</code>.
 * Breakpoint between Small size and Medium size.
 * (This property is only used if a ResponsiveGridLayout is used as Layout.)
 *
 * Default value is <code>600</code>
 *
 * @return {int} the value of property <code>breakpointM</code>
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getBreakpointM
 * @function
 */

/**
 * Setter for property <code>breakpointM</code>.
 *
 * Default value is <code>600</code> 
 *
 * @param {int} iBreakpointM  new value for property <code>breakpointM</code>
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setBreakpointM
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The form content.
 * Add a Title control to start a new group (Container).
 * Add a Label control to start a new row (Element).
 * Add controls as Input fields, text fields or other as needed.
 * Use LayoutData to influence the layout for special cases in the single controls.
 * For example, if a ResponsiveLayout is used as layout the form content is weighted using weight 3 for the labels and weight 5 for the fields part. Per default the label column is 192 pixels wide.
 * If your Input controls should influence their width you can add sap.ui.layout.ResponsiveFlowLayoutData to them via setLayoutData method.
 * Ensure that the sum of the weights in the ResponsiveFlowLayoutData does not use more than 5 as this is the total width of Input control part of each form row.
 * Example for a row where the Input takes 4 and the Text takes 1 weight:
 * new sap.ui.commons.Label({text:"Label"});
 * new sap.ui.commons.TextField({value:"Weight 4",
 * layoutData:new sap.ui.layout.ResponsiveFlowLayoutData({weight:4})}),
 * new sap.ui.commons.TextView({text:"Weight 1",
 * layoutData: new sap.ui.layout.ResponsiveFlowLayoutData({weight:1})}),
 * 
 * <strong>Note</strong>: this is the default aggregation for form/SimpleForm.
 * @return {sap.ui.core.Element[]}
 * @public
 * @name sap.ui.layout.form.SimpleForm#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Element}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Element}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Element} vContent the content to remove or its index or id
 * @return {sap.ui.core.Element} the removed content or null
 * @public
 * @name sap.ui.layout.form.SimpleForm#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Element[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.form.SimpleForm#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Element</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Element}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.form.SimpleForm#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.form.SimpleForm#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>title</code>.<br/>
 * Title element of the SimpleForm. Can either be a Label object, or a simple string.
 * 
 * @return {sap.ui.core.Title|string}
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#getTitle
 * @function
 */


/**
 * Setter for the aggregated <code>title</code>.
 * @param {sap.ui.core.Title|string} oTitle
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#setTitle
 * @function
 */
	

/**
 * Destroys the title in the aggregation 
 * named <code>title</code>.
 * @return {sap.ui.layout.form.SimpleForm} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.3
 * @name sap.ui.layout.form.SimpleForm#destroyTitle
 * @function
 */


// Start of sap\ui\layout\form\SimpleForm.js
///**
//* This file defines behavior for the control,
//*/



 // because initial not known what Layout used - but all FormLayout usein this one.
 // because ResponsiveLayout is the default and it's not known if or when setLayout is called

(function() {

	sap.ui.layout.form.SimpleForm.prototype.init = function() {

		this._iMaxWeight = 8;
		this._iLabelWeight = 3;
		this._iCurrentWidth = 0;
		var oForm = new sap.ui.layout.form.Form(this.getId()+"--Form");
		// use title of SimpleForm in Form
		oForm.getTitle = function(){
			return this.getParent().getTitle();
		};
		oForm._origInvalidate = oForm.invalidate;
		oForm.invalidate = function(oOrigin) {
			this._origInvalidate(arguments);
			if (this._bIsBeingDestroyed) return;
			var oSimpleForm = this.getParent();
			if (oSimpleForm) {
				oSimpleForm._formInvalidated(oOrigin);
			}
		};
		this.setAggregation("form",oForm);
		this._aElements = null;
		this._aLayouts = [];
		var that = this;
		this._changedFormContainers = [];
		this._changedFormElements = [];

	};

	sap.ui.layout.form.SimpleForm.prototype.exit = function() {

		var oForm = this.getAggregation("form");
		oForm.invalidate = oForm._origInvalidate;

		if (this._sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}
		for (var i=0;i<this._aLayouts.length;i++) {
			var oLayout = sap.ui.getCore().byId(this._aLayouts[i]);
			if (oLayout && oLayout.destroy) {
				oLayout.destroy();
			}
		}
		this._aLayouts = [];
		this._aElements = null;
		this._changedFormContainers = [];
		this._changedFormElements = [];

	};

	/*
	 * Update FormContaners, FormElements and LayoutData before controls are rendered
	 */
	sap.ui.layout.form.SimpleForm.prototype.onBeforeRendering = function() {

		this._bChangedByMe = true;
		//unregister resize
		if (this._sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}
		var that = this;

		var oForm = this.getAggregation("form");
		if(!oForm.getLayout()){
			_setFormLayout(that);
		}

		_updateFormContainers(that);
		this._bChangedByMe = false;

	};



	sap.ui.layout.form.SimpleForm.prototype.onAfterRendering = function() {

		if (this.getLayout() == sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout) {
			this._bChangedByMe = true;
			this.$().css("visibility", "hidden"); //avoid that a wrong layouting is visible
			this._applyLinebreaks();

			//attach the resize handler
			this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(),  jQuery.proxy(this._resize, this));
			this._bChangedByMe = false;
		}

	};

	sap.ui.layout.form.SimpleForm.prototype.setEditable = function(bEditable) {

		this._bChangedByMe = true;
		this.setProperty("editable", bEditable, true);

		var oForm = this.getAggregation("form");
		oForm.setEditable(bEditable);

		this._bChangedByMe = false;
		return this;

	};

	/*
	 * overwrite generated functions to use internal array to look for aggregation
	 */
	sap.ui.layout.form.SimpleForm.prototype.indexOfContent = function(oObject) {

		var aChildren = this._aElements;
		if (aChildren) {
			for (var i = 0; i < aChildren.length; i++) {
				if (aChildren[i] == oObject) {
					return i;
				}
			}
		}
		return -1;

	};

	sap.ui.layout.form.SimpleForm.prototype.addContent = function(oElement) {

		this._bChangedByMe = true;
		oElement = this.validateAggregation("content", oElement, /* multiple */ true);

		if (!this._aElements) {
			this._aElements = [];
		}

		// try to find corresponding FormElement and FormContainer to update them
		var iLength = this._aElements.length;
		var oLastElement;
		var oForm = this.getAggregation("form");
		var oFormContainer;
		var oFormElement;
		var oParent;
		var oLayoutData;

		if (oElement instanceof sap.ui.core.Title) {
			//start a new container with a title
			oFormContainer = _createFormContainer(this, oElement);
			oForm.addFormContainer(oFormContainer);
			this._changedFormContainers.push(oFormContainer);
		} else if (oElement.getMetadata().isInstanceOf("sap.ui.core.Label")) { // if the control implements the label interface
			// new label -> create new FormElement
			// determine Container from last Content element
			if (iLength > 0) {
				oLastElement = this._aElements[iLength - 1];
				oParent = oLastElement.getParent();
				if (oParent instanceof sap.ui.layout.form.FormElement) {
					oFormContainer = oParent.getParent();
				} else if (oParent instanceof sap.ui.layout.form.FormContainer){
					oFormContainer = oParent;
				}
			}
			if (!oFormContainer) {
				oFormContainer = _createFormContainer(this);
				oForm.addFormContainer(oFormContainer);
				this._changedFormContainers.push(oFormContainer);
			}

			oFormElement = _addFormElement(this, oFormContainer, oElement);
		} else {
			// new Field -> add to last FormElement
			if (iLength > 0) {
				oLastElement = this._aElements[iLength - 1];
				oParent = oLastElement.getParent();
				if (oParent instanceof sap.ui.layout.form.FormElement) {
					oFormContainer = oParent.getParent();
					oFormElement = oParent;
					oLayoutData = _getFieldLayoutData(this, oElement);
					if (oLayoutData instanceof sap.ui.layout.ResponsiveFlowLayoutData && !_isMyLayoutData(this, oLayoutData)) {
						if (oLayoutData.getLinebreak()) {
							oFormElement = _addFormElement(this, oFormContainer);
						}
					}
				} else if (oParent instanceof sap.ui.layout.form.FormContainer){
					oFormContainer = oParent;
					oFormElement = _addFormElement(this, oFormContainer);
				}
			}else {
				// no FormContainer and FormElement exists
				oFormContainer = _createFormContainer(this);
				oForm.addFormContainer(oFormContainer);
				this._changedFormContainers.push(oFormContainer);
				oFormElement = _addFormElement(this, oFormContainer);
			}

			_createFieldLayoutData(this, oElement, 5, false, true);

			oFormElement.addField(oElement);
			_markFormElementForUpdate(this._changedFormElements, oFormElement);
		}

		this._aElements.push(oElement);
		oElement.attachEvent("_change", _handleContentChange, this);
		this.invalidate();
		this._bChangedByMe = false;
		return this;

	};

	sap.ui.layout.form.SimpleForm.prototype.insertContent = function(oElement, iIndex) {

		oElement = this.validateAggregation("content", oElement, /* multiple */ true);

		if (!this._aElements) {
			this._aElements = [];
		}

		var iLength = this._aElements.length;
		var iNewIndex = iIndex < 0 ? 0 : (iIndex > iLength ? iLength : iIndex);
		if (iNewIndex !== iIndex) {
			jQuery.sap.log.warning("SimpleForm.insertContent: index '" + iIndex + "' out of range [0," + iLength + "], forced to " + iNewIndex);
		}

		if (iNewIndex == iLength) {
			// just added to the end -> use add function
			this.addContent(oElement);
			return this;
		}

		this._bChangedByMe = true;
		var oOldElement = this._aElements[iNewIndex];
		var oForm = this.getAggregation("form");
		var oFormContainer;
		var oFormElement;
		var oOldFormContainer;
		var oOldFormElement;
		var iContainerIndex;
		var iElementIndex = 0;
		var iFieldIndex;
		var aFields;
		var aFormElements;
		var aFormContainers;

		if (oElement instanceof sap.ui.core.Title) {
			//start a new container with a title
			if (iIndex == 0 && !(oOldElement instanceof sap.ui.core.Title)) {
				// special case - index==0 and first container has no title -> just add title to Container
				oFormContainer = oOldElement.getParent().getParent();
				oFormContainer.setTitle(oElement);
			} else {
				oFormContainer = _createFormContainer(this, oElement);
				if (oOldElement instanceof sap.ui.core.Title) {
					// insert before old container
					oOldFormContainer = oOldElement.getParent();
					iContainerIndex = oForm.indexOfFormContainer(oOldFormContainer);
				}else {
					// insert after old container
					oOldFormElement = oOldElement.getParent();
					oOldFormContainer = oOldFormElement.getParent();
					iContainerIndex = oForm.indexOfFormContainer(oOldFormContainer) + 1;
					iElementIndex = oOldFormContainer.indexOfFormElement(oOldFormElement);

					// check if old FormElement must be splited
					if (!oOldElement.getMetadata().isInstanceOf("sap.ui.core.Label")) {
						iFieldIndex = oOldFormElement.indexOfField(oOldElement);
						if (iFieldIndex > 0 || oOldFormElement.getLabel()) {
							// split FormElement
							oFormElement = _addFormElement(this, oFormContainer);
							this._changedFormElements.push(oFormElement);
							_markFormElementForUpdate(this._changedFormElements, oOldFormElement);
							// move all Fields after index into new FormElement
							aFields = oOldFormElement.getFields();
							for ( var i = iFieldIndex; i < aFields.length; i++) {
								var oField = aFields[i];
								oFormElement.addField(oField);
							}
							iElementIndex++;
						}
					}
					// move all FormElements after the new content into the new container
					aFormElements = oOldFormContainer.getFormElements();
					for ( var i = iElementIndex; i < aFormElements.length; i++) {
						oFormContainer.addFormElement(aFormElements[i]);
					}
				}
				oForm.insertFormContainer(oFormContainer, iContainerIndex);
			}
			this._changedFormContainers.push(oFormContainer);
		} else if (oElement.getMetadata().isInstanceOf("sap.ui.core.Label")) {
			if (oOldElement instanceof sap.ui.core.Title) {
				// add new FormElement to previous container
				oOldFormContainer = oOldElement.getParent();
				iContainerIndex = oForm.indexOfFormContainer(oOldFormContainer);
				aFormContainers = oForm.getFormContainers();
				oFormContainer = aFormContainers[iContainerIndex-1];
				oFormElement = _addFormElement(this, oFormContainer, oElement);
			} else if (oOldElement.getMetadata().isInstanceOf("sap.ui.core.Label")) {
				// insert new form element before this one
				oOldFormContainer = oOldElement.getParent().getParent();
				iElementIndex = oOldFormContainer.indexOfFormElement(oOldElement.getParent());
				oFormElement = _insertFormElement(this, oOldFormContainer, oElement, iElementIndex);
			} else {
				// split FormElement
				oOldFormElement = oOldElement.getParent();
				oOldFormContainer = oOldFormElement.getParent();
				iElementIndex = oOldFormContainer.indexOfFormElement(oOldFormElement) + 1;
				iFieldIndex = oOldFormElement.indexOfField(oOldElement);

				if (iFieldIndex == 0 && !oOldFormElement.getLabel()) {
					// special case: Form Element has no label and inserted before first Field
					oFormElement = oOldFormElement;
					oFormElement.setLabel(oElement);
					_createFieldLayoutData(this, oElement, this._iLabelWeight, false, true, this.getLabelMinWidth());
				} else {
					oFormElement = _insertFormElement(this, oOldFormContainer, oElement, iElementIndex);
					_markFormElementForUpdate(this._changedFormElements, oOldFormElement);

					// move all Fields after index into new FormElement
					aFields = oOldFormElement.getFields();
					for ( var i = iFieldIndex; i < aFields.length; i++) {
						var oField = aFields[i];
						oFormElement.addField(oField);
					}
				}
			}
			this._changedFormElements.push(oFormElement);
		}else{ // new field
			if (oOldElement instanceof sap.ui.core.Title) {
				// add new Field to last FormElement of previous FormContainer
				oOldFormContainer = oOldElement.getParent();
				iContainerIndex = oForm.indexOfFormContainer(oOldFormContainer);

				if (iContainerIndex == 0) {
					// it's the first container - insert new container before
					oFormContainer = _createFormContainer(this);
					oForm.insertFormContainer(oFormContainer, iContainerIndex);
					this._changedFormContainers.push(oFormContainer);
				}else{
					aFormContainers = oForm.getFormContainers();
					oFormContainer = aFormContainers[iContainerIndex-1];
				}

				aFormElements = oFormContainer.getFormElements();
				if (aFormElements.length == 0) {
					// container has no FormElements -> create one
					oFormElement = _addFormElement(this, oFormContainer);
				}else{
					oFormElement = aFormElements[aFormElements.length-1];
				}

				oFormElement.addField(oElement);
			} else if (oOldElement.getMetadata().isInstanceOf("sap.ui.core.Label")) {
				// add new field to previous FormElement
				oOldFormElement = oOldElement.getParent();
				oFormContainer = oOldFormElement.getParent();
				iElementIndex = oFormContainer.indexOfFormElement(oOldFormElement);

				if (iElementIndex == 0) {
					// it's already the first FormElement -> insert a new one before
					oFormElement = _insertFormElement(this, oFormContainer, null, 0);
				} else {
					aFormElements = oFormContainer.getFormElements();
					oFormElement = aFormElements[iElementIndex-1];
				}
				oFormElement.addField(oElement);
			} else {
				// insert new field into same FormElement before old field
				oFormElement = oOldElement.getParent();
				iFieldIndex = oFormElement.indexOfField(oOldElement);
				oFormElement.insertField(oElement, iFieldIndex);
			}
			_markFormElementForUpdate(this._changedFormElements, oFormElement);

			_createFieldLayoutData(this, oElement, 5, false, true);
		}

		this._aElements.splice(iNewIndex, 0, oElement);
		oElement.attachEvent("_change", _handleContentChange, this);
		this.invalidate();
		this._bChangedByMe = false;
		return this;

	};

	sap.ui.layout.form.SimpleForm.prototype.removeContent = function(vElement) {

		var oElement = null;
		var iIndex = -1;

		if (this._aElements) {

			if (typeof(vElement) == "string") { // ID of the element is given
				vElement = sap.ui.getCore().byId(vElement);
			}

			if (typeof(vElement) == "object") { // the element itself is given or has just been retrieved
				for (var i = 0; i < this._aElements.length; i++) {
					if (this._aElements[i] == vElement) {
						vElement = i;
						break;
					}
				}
			}

			if (typeof(vElement) == "number") { // "vElement" is the index now
				if (vElement < 0 || vElement >= this._aElements.length) {
					jQuery.sap.log.warning("Element.removeAggregation called with invalid index: Items, " + vElement);
				} else {
					iIndex = vElement;
					oElement = this._aElements[iIndex];
				}
			}
		}
		if (oElement) {
			this._bChangedByMe = true;
			var oForm = this.getAggregation("form");
			var oFormContainer;
			var oFormElement;
			var aFormElements;
			var aFields;

			if (oElement instanceof sap.ui.core.Title) {
				oFormContainer = oElement.getParent();
				oFormContainer.setTitle(null);
				if (iIndex > 0) {
					// if it's the first container -> just remove title
					// remove container and add content to previous container
					aFormElements = oFormContainer.getFormElements();
					var iContainerIndex = oForm.indexOfFormContainer(oFormContainer);
					var oPrevFormContainer = oForm.getFormContainers()[iContainerIndex-1];
					if (aFormElements && !aFormElements[0].getLabel()) {
						// first Form Element has no label -> add its fields to last Form Element of previous container
						var aPrevFormElements = oPrevFormContainer.getFormElements();
						var oLastFormElement = aPrevFormElements[aPrevFormElements.length - 1];
						aFields = aFormElements[0].getFields();
						for ( var i = 0; i < aFields.length; i++) {
							oLastFormElement.addField(aFields[i]);
						}
						_markFormElementForUpdate(this._changedFormElements, oLastFormElement);
						oFormContainer.removeFormElement(aFormElements[0]);
						aFormElements[0].destroy();
						aFormElements.splice(0,1);
					}
					for ( var i = 0; i < aFormElements.length; i++) {
						oPrevFormContainer.addFormElement(aFormElements[i]);
					}
					_markFormElementForUpdate(this._changedFormContainers, oPrevFormContainer);
					oForm.removeFormContainer(oFormContainer);
					oFormContainer.destroy();
				}
			} else if (oElement.getMetadata().isInstanceOf("sap.ui.core.Label")) {
				oFormElement = oElement.getParent();
				oFormContainer = oFormElement.getParent();
				oFormElement.setLabel(null);
				var iElementIndex = oFormContainer.indexOfFormElement(oFormElement);
				if (iElementIndex == 0) {
					// its the first Element of the container -> just remove label
					if (!oFormElement.getFields()) {
						// FormElement has no fields -> just delete
						oFormContainer.removeFormElement(oFormElement);
						oFormElement.destroy();
					}else {
						_markFormElementForUpdate(this._changedFormElements, oFormElement);
					}
				} else {
					// add fields to previous FormElement
					aFormElements = oFormContainer.getFormElements();
					var oPrevFormElement = aFormElements[iElementIndex-1];
					aFields = oFormElement.getFields();
					for ( var i = 0; i < aFields.length; i++) {
						oPrevFormElement.addField(aFields[i]);
					}
					_markFormElementForUpdate(this._changedFormElements, oPrevFormElement);
					oFormContainer.removeFormElement(oFormElement);
					oFormElement.destroy();
				}
			}else{ // remove field
				oFormElement = oElement.getParent();
				oFormElement.removeField(oElement);
				if (!oFormElement.getFields() && !oFormElement.getLabel()) {
					// FormElement has no more fields and no label -> just delete
					oFormContainer = oFormElement.getParent();
					oFormContainer.removeFormElement(oFormElement);
					oFormElement.destroy();
				} else {
					_markFormElementForUpdate(this._changedFormElements, oFormElement);
				}
			}

			this._aElements.splice(iIndex, 1);
			oElement.setParent(null);
			oElement.detachEvent("_change", _handleContentChange, this);
			_removeLayoutData(this, oElement);

			this.invalidate();
			this._bChangedByMe = false;
			return oElement;
		}
		return null;

	};

	sap.ui.layout.form.SimpleForm.prototype.removeAllContent = function() {

		if (this._aElements) {
			this._bChangedByMe = true;
			var oForm = this.getAggregation("form");
			var aFormContainers = oForm.getFormContainers();
			for ( var i = 0; i < aFormContainers.length; i++) {
				var oFormContainer = aFormContainers[i];
				oFormContainer.setTitle(null);
				var aFormElements = oFormContainer.getFormElements();
				for ( var j = 0; j < aFormElements.length; j++) {
					var oFormElement = aFormElements[j];
					oFormElement.setLabel(null);
					oFormElement.removeAllFields();
				}
				oFormContainer.destroyFormElements();
			}
			oForm.destroyFormContainers();

			for (var i = 0; i < this._aElements.length; i++) {
				var oElement = this._aElements[i];
				_removeLayoutData(this, oElement);
				oElement.detachEvent("_change", _handleContentChange, this);
			}
			var aElements = this._aElements;
			this._aElements = null;
			this.invalidate();
			this._bChangedByMe = false;
			return aElements;
		} else {
			return [];
		}

	};

	sap.ui.layout.form.SimpleForm.prototype.destroyContent = function() {

		var aElements = this.removeAllContent();

		if (aElements) {
			this._bChangedByMe = true;
			for (var i = 0; i < aElements.length; i++) {
				aElements[i].destroy();
			}
			this.invalidate();
			this._bChangedByMe = false;
		}
		return this;

	};

	sap.ui.layout.form.SimpleForm.prototype.getContent = function() {

		if (!this._aElements) {
			this._aElements = this.getAggregation("content", []);
		}
		return this._aElements;

	};

/*
 * set the FormLayout to the Form. If already a FormLayout is set, just set a new one.
 */
	sap.ui.layout.form.SimpleForm.prototype.setLayout = function(sLayout) {

		this._bChangedByMe = true;
		var sOldLayout = this.getLayout();
		this.setProperty("layout", sLayout);

		if (sLayout != sOldLayout) {
			var that = this;
			_setFormLayout(that);

			// update LayoutData for Containers, Elements and Fields
			var oForm = this.getAggregation("form");
			var aContainers = oForm.getFormContainers();
			var aElements;
			var aFields;
			var oLayoutData;

			for ( var i = 0; i < aContainers.length; i++) {
				var oContainer = aContainers[i];
				this._changedFormContainers.push(oContainer);
				oLayoutData = oContainer.getLayoutData();
				if (oLayoutData) {
					oLayoutData.destroy();
				}
				_createContainerLayoutData(this, oContainer);
				aElements = oContainer.getFormElements();
				for ( var j = 0; j < aElements.length; j++) {
					var oElement = aElements[j];
					_markFormElementForUpdate(this._changedFormElements, oElement);
					oLayoutData = oElement.getLayoutData();
					if (oLayoutData) {
						oLayoutData.destroy();
					}
					_createElementLayoutData(this, oElement);
					var oLabel = oElement.getLabel();
					if (oLabel) {
						_removeLayoutData(this, oLabel);
						_createFieldLayoutData(this, oLabel, this._iLabelWeight, false, true, this.getLabelMinWidth());
					}
					aFields = oElement.getFields();
					for ( var k = 0; k < aFields.length; k++) {
						var oField = aFields[k];
						_removeLayoutData(this, oField);
						_createFieldLayoutData(this, oField, 5, false, true);
					}
				}
			}
		}

		this._bChangedByMe = false;
		return this;

	};

	/*
	 * overwrite the clone function because content will not be cloned in default one
	 */
	sap.ui.layout.form.SimpleForm.prototype.clone = function(sIdSuffix) {

		this._bChangedByMe = true;
		var oClone = sap.ui.core.Control.prototype.clone.apply(this, arguments);
		var aContent = this.getContent();

		for ( var i = 0; i < aContent.length; i++) {
			var oElement = aContent[i];
			var oLayoutData = oElement.getLayoutData();
			var oElementClone = oElement.clone(sIdSuffix);
			if (oLayoutData) {
				// mark private LayoutData
				if (oLayoutData.getMetadata().getName() == "sap.ui.core.VariantLayoutData") {
					var aLayoutData = oLayoutData.getMultipleLayoutData();
					for ( var j = 0; j < aLayoutData.length; j++) {
						if (_isMyLayoutData(this, aLayoutData[j])) {
							oClone._aLayouts.push(oElementClone.getLayoutData().getMultipleLayoutData()[j].getId());
						}
					}
				} else if (_isMyLayoutData(this, oLayoutData)) {
					oClone._aLayouts.push(oElementClone.getLayoutData().getId());
				}
			}
			oClone.addContent(oElementClone);
		}

		this._bChangedByMe = false;
		return oClone;

	};

	var _setFormLayout = function(oThis) {

			var oForm = oThis.getAggregation("form");
			var oLayout = oForm.getLayout();
			if (oLayout) {
				oLayout.destroy();
			}

			switch (oThis.getLayout()) {
			case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:
				jQuery.sap.require("sap.ui.layout.form.ResponsiveLayout");
				oForm.setLayout(new sap.ui.layout.form.ResponsiveLayout(oThis.getId()+"--Layout"));
				break;
			case sap.ui.layout.form.SimpleFormLayout.GridLayout:
				jQuery.sap.require("sap.ui.layout.form.GridLayout");
				jQuery.sap.require("sap.ui.layout.form.GridContainerData");
				jQuery.sap.require("sap.ui.layout.form.GridElementData");
				oForm.setLayout(new sap.ui.layout.form.GridLayout(oThis.getId()+"--Layout"));
				break;
			case sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout:
				jQuery.sap.require("sap.ui.layout.form.ResponsiveGridLayout");
				jQuery.sap.require("sap.ui.layout.GridData");
				oForm.setLayout(new sap.ui.layout.form.ResponsiveGridLayout(oThis.getId()+"--Layout"));
				break;

			default:
				break;
			}

	};

	/*
	 * Updates the FormContainers of the simple form.
	 */
	var _updateFormContainers = function(oThis) {

		oThis._changedFormContainers = [];

		var sLayout = oThis.getLayout();


		switch (sLayout) {
		case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:
			// set the default values for linebreakes to avoid flickering for default case
			oThis._applyLinebreaks();
			break;
		case sap.ui.layout.form.SimpleFormLayout.GridLayout:
			_applyContainerSize(oThis);
			break;
		case sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout:
			var oLayout = oThis.getAggregation("form").getLayout();
			oLayout.setLabelSpanL(oThis.getLabelSpanL());
			oLayout.setLabelSpanM(oThis.getLabelSpanM());
			oLayout.setLabelSpanS(oThis.getLabelSpanS());
			oLayout.setEmptySpanL(oThis.getEmptySpanL());
			oLayout.setEmptySpanM(oThis.getEmptySpanM());
			oLayout.setEmptySpanS(oThis.getEmptySpanS());
			oLayout.setColumnsL(oThis.getColumnsL());
			oLayout.setColumnsM(oThis.getColumnsM());
			oLayout.setBreakpointL(oThis.getBreakpointL());
			oLayout.setBreakpointM(oThis.getBreakpointM());
			break;
		default:
			break;
		}

		for ( var i = 0; i < oThis._changedFormElements.length; i++) {
			var oFormElement = oThis._changedFormElements[i];

			switch (sLayout) {
			case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:
				_applyFieldWeight(oThis, oFormElement);
				break;
			case sap.ui.layout.form.SimpleFormLayout.GridLayout:
				break;
			default:
				break;
			}

			_updateVisibility(oThis, oFormElement);
		}
		oThis._changedFormElements = [];

	};

	/*
	 * Checks whether the given LayoutData is created and added by this Simple Form
	 * @param { sap.ui.layout.ResponsiveFlowLayoutData} optional (interface) The layout data
	 * @returns {boolean} Whether the given layout was created by this Simple Form
	 * @private
	 */
	var _isMyLayoutData = function(oThis, oLayoutData) {

		var sId = oLayoutData.getId(),
		sLayouts = " " + oThis._aLayouts.join(" ") + " ";
		return sLayouts.indexOf(" " + sId + " ") >-1;

	};

	/*
	 * Creates new sap.ui.layout.ResponsiveFlowLayoutData with the given parameters
	 * @param {int} iWeight the weight for the layout data
	 * @param {boolean} bLinebreak Whether the layout data has a linebreak
	 * @param {boolean} bLinebreakable Whether the layout data is linebreakable
	 * @returns {sap.ui.layout.ResponsiveFlowLayoutData} The newly created ResponsiveFlowLayoutData
	 * @private
	 */
	var _createRFLayoutData = function(oThis, iWeight, bLinebreak, bLinebreakable, iMinWidth) {

		var oLayout = new sap.ui.layout.ResponsiveFlowLayoutData({weight:iWeight,linebreak:bLinebreak===true,linebreakable: bLinebreakable===true});
		if (iMinWidth) {
			oLayout.setMinWidth(iMinWidth);
		}
		oThis._aLayouts.push(oLayout.getId());
		return oLayout;

	};

	/*
	 * Mabe there are VariantLayoutData used -> so get the right one for the used Layout
	 */
	var _getFieldLayoutData = function(oThis, oField){

		var oLayoutData;

		switch (oThis.getLayout()) {
		case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:
			oLayoutData = sap.ui.layout.form.FormLayout.prototype.getLayoutDataForElement(oField, "sap.ui.layout.ResponsiveFlowLayoutData");
			break;
		case sap.ui.layout.form.SimpleFormLayout.GridLayout:
			oLayoutData = sap.ui.layout.form.FormLayout.prototype.getLayoutDataForElement(oField, "sap.ui.layout.form.GridElementData");
			break;
		case sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout:
			oLayoutData = sap.ui.layout.form.FormLayout.prototype.getLayoutDataForElement(oField, "sap.ui.layout.GridData");
			break;

		default:
			break;
		}

		return oLayoutData;

	};

	var _createFieldLayoutData = function(oThis, oField, iWeight, bLinebreak, bLinebreakable, iMinWidth) {

		var oLayoutData;

		switch (oThis.getLayout()) {
		case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:
			oLayoutData = _getFieldLayoutData(oThis, oField);
			if (!oLayoutData || !_isMyLayoutData(oThis, oLayoutData)) {
				oLayoutData = oField.getLayoutData();
				if (oLayoutData && oLayoutData.getMetadata().getName() == "sap.ui.core.VariantLayoutData") {
					oLayoutData.addMultipleLayoutData(_createRFLayoutData(oThis, iWeight, bLinebreak, bLinebreakable, iMinWidth));
				} else if(!oLayoutData){
					oField.setLayoutData(_createRFLayoutData(oThis, iWeight, bLinebreak, bLinebreakable, iMinWidth));
				} else {
					jQuery.sap.log.warning("ResponsiveFlowLayoutData can not be set on Field "+ oField.getId(), "_createFieldLayoutData", "SimpleForm");
				}
			}
			break;
		case sap.ui.layout.form.SimpleFormLayout.GridLayout:
			// no default LayoutData needed"
			break;

		default:
			break;
		}

	};

	var _createElementLayoutData = function(oThis, oElement) {

		switch (oThis.getLayout()) {
		case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:
			oElement.setLayoutData(new sap.ui.layout.ResponsiveFlowLayoutData({linebreak:true, margin:false}));
			break;
		case sap.ui.layout.form.SimpleFormLayout.GridLayout:
			// no default LayoutData needed"
			break;

		default:
			break;
		}

	};

	var _createContainerLayoutData = function(oThis, oContainer) {

		switch (oThis.getLayout()) {
		case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:
			oContainer.setLayoutData(new sap.ui.layout.ResponsiveFlowLayoutData({minWidth:280}));
			break;
		case sap.ui.layout.form.SimpleFormLayout.GridLayout:
			if (oThis.getMaxContainerCols() > 1) {
				oContainer.setLayoutData(new sap.ui.layout.form.GridContainerData({halfGrid: true}));
			} else{
				oContainer.setLayoutData(new sap.ui.layout.form.GridContainerData({halfGrid: false}));
			}
			break;

		default:
			break;
		}

	};

	var _removeLayoutData = function(oThis, oElement) {

		var oLayout = _getFieldLayoutData(oThis, oElement);
		if (oLayout) {
			var sLayoutId = oLayout.getId();

			for ( var i = 0; i < oThis._aLayouts.length; i++) {
				var sId = oThis._aLayouts[i];
				if (sLayoutId == sId) {
					oLayout.destroy(); // is removed from parent during destroy
					oThis._aLayouts.splice(i, 1);
					break;
				}
			}
		}

	};

	/*
	 * Adds a new form element to the given FormContainer and adds the given label to it.
	 * @param {sap.ui.layout.form.FormContainer} The form container
	 * @param {sap.ui.core.Label} optional (interface) The label of the element
	 * @returns {sap.ui.layout.form.FormElement} The newly created FormElement
	 * @private
	 */
	var _addFormElement = function(oThis, oFormContainer, oLabel) {

		var oElement = _createFormElement(oThis, oLabel);
		oFormContainer.addFormElement(oElement);
		return oElement;

	};

	var _insertFormElement = function(oThis, oFormContainer, oLabel, iIndex) {

		var oElement = _createFormElement(oThis, oLabel);
		oFormContainer.insertFormElement(oElement, iIndex);
		return oElement;

	};

	var _createFormElement = function(oThis, oLabel) {

		var oElement = new sap.ui.layout.form.FormElement();
		_createElementLayoutData(oThis, oElement);
		if (oLabel) {
			oLabel.addStyleClass("sapUiFormLabel-CTX");
			oElement.setLabel(oLabel);
			if (!_getFieldLayoutData(oThis, oLabel)) {
				_createFieldLayoutData(oThis, oLabel, oThis._iLabelWeight, false, true, oThis.getLabelMinWidth());
			}
		}
		oElement.setVisible(false);
		return oElement;

	};

	/*
	 * creates a new form container and adds the given title to it.
	 * @param {sap.ui.core.Title} optional The title of the container
	 * @returns {sap.ui.layout.form.FormContainer} The newly created FormContainer
	 * @private
	 */
	var _createFormContainer = function(oThis, oTitle) {

		var oContainer = new sap.ui.layout.form.FormContainer();
		_createContainerLayoutData(oThis, oContainer);
		if (oTitle) {
			oContainer.setTitle(oTitle);
		}
		return oContainer;

	};

	/*
	 * Applies the weight property for the fields in the responsive layout.
	 * @param {sap.ui.layout.form.FormElement} oElement The FormElement where the weight is applied.
	 * @private
	 */
	var _applyFieldWeight = function(oThis, oElement){

		var iMaxWeight = oThis._iMaxWeight;
		var aFields = oElement.getFields();
		var oField;
		var iLength = aFields.length;
		var oLabel = oElement.getLabel();
		var oLayoutData;

		if (oLabel && _getFieldLayoutData(oThis, oLabel)) {
			iMaxWeight = iMaxWeight - _getFieldLayoutData(oThis, oLabel).getWeight();
		}

		// determine weights set from application
		for (var i=0; i < aFields.length; i++) {
			oField = aFields[i];
			oLayoutData = _getFieldLayoutData(oThis, oField);
			if (oLayoutData instanceof sap.ui.layout.ResponsiveFlowLayoutData && !_isMyLayoutData(oThis, oLayoutData)) {
				iMaxWeight = iMaxWeight - oLayoutData.getWeight();
				iLength--;
			}
		}

		var iWeight = Math.floor(iMaxWeight/iLength);
		var iRest = iMaxWeight % iLength;

		for (var i=0; i < aFields.length; i++) {
			oField = aFields[i];
			oLayoutData = _getFieldLayoutData(oThis, oField);
			var iCurrentWeight = iWeight;

			if (!oLayoutData) {
				_createFieldLayoutData(oThis, oField, iCurrentWeight, false, i==0);
			} else if (_isMyLayoutData(oThis, oLayoutData) && oLayoutData instanceof sap.ui.layout.ResponsiveFlowLayoutData) {
				// devide rest to first fields (not only to last one) (fist because to ignore manual set weigths)
				if (iRest > 0) {
					iCurrentWeight++;
					iRest--;
				}
				oLayoutData.setWeight(iCurrentWeight);
			}
		}

	};

	var _updateVisibility = function(oThis, oElement){

		var aFields = oElement.getFields();
		var iLength = aFields.length;
		var bVisible = false;

		for (var i=0; i < aFields.length; i++) {
			var oField = aFields[i];
			if (!oField.getVisible || oField.getVisible()) {
				// at least one Field is visible
				bVisible = true;
				break;
			}
		}

		if (oElement.getVisible() != bVisible) {
			// set visibility of FormElement
			oElement.setVisible(bVisible);
		}

	};

	/*
	 * Applies the linebreaks of form containers according the minWidth and maxContainerCol settings of the SimpleForm
	 * @private
	 */
	sap.ui.layout.form.SimpleForm.prototype._applyLinebreaks = function(){

		var oForm = this.getAggregation("form"),
		aContainers = oForm.getFormContainers();
		// set line break on every container if Form is smaller than getMinWidth pixel
		// and reset it if it's larger
		var oDomRef = this.getDomRef();
		var o$ = this.$();
		for (var i=1; i<aContainers.length; i++){
			var oContainer = aContainers[i],
			oLayoutData = oContainer.getLayoutData();
			if (!oDomRef || o$.outerWidth(true) > this.getMinWidth()){
				// if not already rendered use default values according to column number
				if (i % this.getMaxContainerCols() == 0) {
					oLayoutData.setLinebreak(true);
				}else{
					oLayoutData.setLinebreak(false);
				}
			} else {
				oLayoutData.setLinebreak(true);
			}
		}
		if (oDomRef && o$.css("visibility") == "hidden"){
			var that = this;
			setTimeout(function() {
				if (that.getDomRef()) {
					that.$().css("visibility", "inherit");
				}
			},10);
		}

	};

	/*
	 * Applies size of the containers in GridLayout: if only one container is in the last line -> make it full size
	 * @private
	 */
	var _applyContainerSize = function(oThis){

		var oForm = oThis.getAggregation("form");
		var aContainers = oForm.getFormContainers();
		var iLength = aContainers.length;
		if (iLength % 2 > 0) {
			aContainers[iLength-1].getLayoutData().setHalfGrid(false);
		}
	};

	/*
	 * Handles the resize event
	 * @private
	 */
	sap.ui.layout.form.SimpleForm.prototype._resize = function(){

		this._bChangedByMe = true;
		if (this._iCurrentWidth == this.$().outerWidth()) return;
		this._iCurrentWidth = this.$().outerWidth();
		this._applyLinebreaks();
		this._bChangedByMe = false;

	};

	var _markFormElementForUpdate = function(aFormElements, oFormElement){

		var bFound = false;
		for ( var i = 0; i < aFormElements.length; i++) {
			var oChangedFormElement = aFormElements[i];
			if (oChangedFormElement == oFormElement) {
				bFound = true;
				break;
			}
		}
		if (!bFound) {
			aFormElements.push(oFormElement);
		}

	};

	var _handleContentChange = function(oEvent) {
		if (oEvent.getParameter("name") == "visible") {
			var oFormElement= oEvent.oSource.getParent();
			_updateVisibility(this, oFormElement);
		}
	};

	var _getFormContent = function(oForm) {

		var aElements = [];
		var aFormContainers = oForm.getFormContainers();

		for ( var i = 0; i < aFormContainers.length; i++) {
			var oFormContainer = aFormContainers[i];
			var oTitle = oFormContainer.getTitle();
			if (oTitle) {
				aElements.push(oTitle);
			}

			var aFormElements = oFormContainer.getFormElements();
			for ( var j = 0; j < aFormElements.length; j++) {
				var oFormElement = aFormElements[j];
				var oLabel = oFormElement.getLabel();
				if (oLabel) {
					aElements.push(oLabel);
				}
				var aFields = oFormElement.getFields();
				for (var k = 0; k < aFields.length; k++) {
					var oField = aFields[k];
					aElements.push(oField);
				}
			}
		}

		return aElements;

	};

	sap.ui.layout.form.SimpleForm.prototype._formInvalidated = function(oOrigin){

		if (!this._bChangedByMe) {
			// check if content is still the same like in array
			// maybe ca Control was destroyed or removed without using the SimpleForm API
			// as invalidate is fired for every single object only one object can be changed
			var aContent = _getFormContent(this.getAggregation("form"));
			var j = 0;
			var bCreateNew = false;

			if (aContent.length < this._aElements.length) {
				// at least one element must be removed -> create completely new,
				// because for deleted controls it's hard to find out the old parent.
				bCreateNew = true;
			} else {
				for (var i = 0; i < aContent.length; i++) {
					var oElement1 = aContent[i];
					var oElement2 = this._aElements[j];
					if (oElement1 === oElement2) {
						j++;
					}else {
						// check if Element1 is new
						var oElementNext = aContent[i+1];
						if (oElementNext === oElement2) {
							this.insertContent(oElement1, i);
							break;
						}

						// check if Element2 is removed
						var oElementNext = this._aElements[j+1];
						if (oElementNext === oElement1) {
							// difficult to find out old Formelement or FormContainer -> create content completely new.
							bCreateNew = true;
							break;
						}

						break;
					}
				}
			}

			if (bCreateNew) {
				this.removeAllContent();
				for (var i = 0; i < aContent.length; i++) {
					var oElement = aContent[i];
					this.addContent(oElement);
				}
			}
		}

	};

}());
}; // end of sap/ui/layout/form/SimpleForm.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.ResponsiveFlowLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.ResponsiveFlowLayout.
jQuery.sap.declare("sap.ui.layout.ResponsiveFlowLayout");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ResponsiveFlowLayout.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getResponsive responsive} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * This is a layout where several controls can be added. These controls are blown up to fit a whole line. If the window resizes the controls are moved between the lines and resized again.
 * @extends sap.ui.core.Control
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.ResponsiveFlowLayout
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.core.Control.extend("sap.ui.layout.ResponsiveFlowLayout", { metadata : {

	library : "sap.ui.layout",
	properties : {
		"responsive" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	defaultAggregation : "content",
	aggregations : {
		"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	}
}});


/**
 * Creates a new subclass of class sap.ui.layout.ResponsiveFlowLayout with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.ResponsiveFlowLayout.extend
 * @function
 */


/**
 * Getter for property <code>responsive</code>.
 * If this property is 'false' all added controls keep their widths. Otherwise all added controls will be extended to the possible width of a row.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>responsive</code>
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#getResponsive
 * @function
 */

/**
 * Setter for property <code>responsive</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bResponsive  new value for property <code>responsive</code>
 * @return {sap.ui.layout.ResponsiveFlowLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#setResponsive
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Added content that should be positioned. Every content item should have a ResponsiveFlowLayoutData attached otherwise the default values are used.
 * 
 * <strong>Note</strong>: this is the default aggregation for ResponsiveFlowLayout.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.ui.layout.ResponsiveFlowLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.ui.layout.ResponsiveFlowLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.ui.layout.ResponsiveFlowLayout} <code>this</code> to allow method chaining
 * @public
 * @name sap.ui.layout.ResponsiveFlowLayout#destroyContent
 * @function
 */


// Start of sap\ui\layout\ResponsiveFlowLayout.js

jQuery.sap.require('sap.ui.core.IntervalTrigger'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


(function() {
	sap.ui.layout.ResponsiveFlowLayout.prototype.init = function() {
		this._rows = [];

		this._bIsRegistered = false;
		this._proxyComputeWidths = jQuery.proxy(computeWidths, this);

		this.oRm = new sap.ui.core.RenderManager();
		this.oRm.writeStylesAndClasses = function() {
			this.writeStyles();
			this.writeClasses();
		};
		this.oRm.writeHeader = function(sId, oStyles, aClasses) {
			this.write('<div id="' + sId + '"');

			if (oStyles) {
				for ( var key in oStyles) {
					if (key === "width" && oStyles[key] === "100%") {
						this.addClass("sapUiRFLFullLength");
					}
					this.addStyle(key, oStyles[key]);
				}
			}
			for (var i = 0; i < aClasses.length; i++) {
				this.addClass(aClasses[i]);
			}

			this.writeStylesAndClasses();
			this.write(">");
		};

		this._iRowCounter = 0;
	};
	sap.ui.layout.ResponsiveFlowLayout.prototype.exit = function() {
		delete this._rows;

		if (this._IntervalCall) {
			jQuery.sap.clearDelayedCall(this._IntervalCall);
			this._IntervalCall = undefined;
		}

		if (this._resizeHandlerComputeWidthsID) {
			sap.ui.core.ResizeHandler.deregister(this._resizeHandlerComputeWidthsID);
		}
		delete this._resizeHandlerComputeWidthsID;
		delete this._proxyComputeWidths;

		this.oRm.destroy();
		delete this.oRm;

		delete this._$DomRef;
		delete this._oDomRef;

		delete this._iRowCounter;
	};

	var updateRows = function(oThis) {
		var aControls = oThis.getContent();
		var aRows = [];
		var iRow = -1;
		var oItem = {}, oLast = {};
		var sId = "";
		var oLD;
		var minWidth = 0, weight = 0, length = 0;
		var bBreak = false, bMargin = false, bLinebreakable = false;

		for (var i = 0; i < aControls.length; i++) {
			// use default values -> are overwritten if LayoutData exists
			minWidth = sap.ui.layout.ResponsiveFlowLayoutData.MIN_WIDTH;
			weight = sap.ui.layout.ResponsiveFlowLayoutData.WEIGHT;
			bBreak = sap.ui.layout.ResponsiveFlowLayoutData.LINEBREAK;
			bMargin = sap.ui.layout.ResponsiveFlowLayoutData.MARGIN;
			bLinebreakable = sap.ui.layout.ResponsiveFlowLayoutData.LINEBREAKABLE;

			// set the values of the layout data if available
			oLD = _getLayoutDataForControl(aControls[i]);
			if (oLD instanceof sap.ui.layout.ResponsiveFlowLayoutData) {
				bBreak = oLD.getLinebreak();
				minWidth = oLD.getMinWidth();
				weight = oLD.getWeight();
				bMargin = oLD.getMargin();
				bLinebreakable = oLD.getLinebreakable();
			}

			if (iRow < 0 || bBreak) {
				/*
				 * if first run OR current control should cause a linebreak the
				 * control will be placed in a new row
				 */
				iRow++;
				aRows.push({
					height : -1,
					cont : []
				});
			}

			length = aRows[iRow].cont.length;
			sId = aControls[i].getId() + "-cont" + iRow + "_" + length;
			oItem = {
				minWidth : minWidth,
				weight : weight,
				linebreakable : bLinebreakable,
				// since the margin of the element is used outside of it it
				// becomes padding
				padding : bMargin,
				control : aControls[i],
				id : sId,
				breakWith : []
			};

			// check if item has been pushed needed if no element was found that
			// is allowed to be wrapped into a new line
			var bPushed = false;
			if (!!!bLinebreakable) {
				// if an element mustn't break -> find any previous element that
				// is allowed to do wrapping
				for (var br = length; br > 0; br--) {
					oLast = aRows[iRow].cont[br - 1];
					if (oLast.linebreakable) {
						oLast.breakWith.push(oItem);
						bPushed = true;
						break;
					}
				}
			}

			if (!bPushed) {
				aRows[iRow].cont.push(oItem);
			}

		}

		oThis._rows = aRows;
	};

	var getCurrentWrapping = function(oRow, $Row, oThis) {
		var r = [];
		var lastOffsetLeft = 10000000;
		var currentRow = -1;

		var fnCurrentWrapping = function(j) {
			var $cont = jQuery.sap.byId(oRow.cont[j].id);
			if ($cont.length > 0) {
				var offset = $cont[0].offsetLeft;
				if (lastOffsetLeft >= offset) {
					r.push({
						cont : []
					});
					currentRow++;
				}
				lastOffsetLeft = offset;
				r[currentRow].cont.push(oRow.cont[j]);
			}
		}

		// Find out the "rows" within a row
		if (sap.ui.getCore().getConfiguration().getRTL()) {
			// for RTL-mode the elements have to be checked the other way round
			for (var i = oRow.cont.length - 1; i >= 0; i--) {
				fnCurrentWrapping(i);
			}
		} else {
			for (var i = 0; i < oRow.cont.length; i++) {
				fnCurrentWrapping(i);
			}
		}

		return r;
	};

	/**
	 * @param {object}
	 *            [oRow] is the corresponding row of possible controls
	 * @param {int}
	 *            [iWidth] is the width of the row in pixels
	 */
	var getTargetWrapping = function(oRow, iWidth) {
		/*
		 * initiating all required variables to increase speed and memory
		 * efficiency
		 */
		var r = [];
		var currentRow = -1;
		var currentWidth = 0;
		var totalWeight = 0;
		var indexLinebreak = 0;
		var w1 = 0, w2 = 0;
		var j = 0, k = 0;

		// Find out the "rows" within a row
		for (j = 0; j < oRow.cont.length; j++) {
			currentWidth = 0;
			totalWeight = 0;
			for (k = indexLinebreak; k <= j; k++) {
				totalWeight = totalWeight + oRow.cont[k].weight;
			}
			for (k = indexLinebreak; k <= j; k++) {
				w1 = iWidth / totalWeight * oRow.cont[k].weight;
				w1 = Math.floor(w1);

				w2 = oRow.cont[k].minWidth;

				currentWidth += Math.max(w1, w2);
			}

			if (currentRow == -1 || currentWidth > iWidth) {
				r.push({
					cont : []
				});
				if (currentRow !== -1) {
					/*
					 * if this is NOT the first run -> all coming iterations
					 * needn't to start from '0' since the calculation of a new
					 * row has begun
					 */
					indexLinebreak = j;
				}
				currentRow++;
			}
			r[currentRow].cont.push(oRow.cont[j]);
		}
		return r;
	};

	var checkWrappingDiff = function(wrap1, wrap2) {
		if (wrap1.length != wrap2.length) {
			return true;
		}

		for (var i = 0; i < wrap1.length; i++) {
			if (wrap1[i].cont.length != wrap2[i].cont.length) {
				return true;
			}
		}

		return false;
	};

	/**
	 * Creates the corresponding content of the targeted wrapping and pushes it
	 * to the RenderManager instance.
	 * 
	 * @param {object}
	 *            [oTargetWrapping] is the wrapping how it should be (may differ
	 *            from current wrapping)
	 * @param {int}
	 *            [iWidth] the available inner width of the row
	 * @private
	 */
	sap.ui.layout.ResponsiveFlowLayout.prototype.renderContent = function(oTargetWrapping, iWidth) {
		var r = oTargetWrapping;
		var iRowProcWidth = 0;
		var aWidths = [];
		var i = 0, ii = 0, j = 0, jj = 0;
		var totalWeight = 0;
		var iProcWidth = 0;
		var oCont;
		var tWeight = 0, tMinWidth = 0;
		var aBreakWidths = [];
		var aClasses = [];

		var sId = this.getId();
		var sHeaderId = "";

		for (i = 0; i < r.length; i++) {
			/*
			 * reset all corresponding values for each row
			 */
			iProcWidth = 0;
			aWidths.length = 0;
			iRowProcWidth = 100; // subtract the used values from a whole row
			aClasses.length = 0;

			aClasses.push("sapUiRFLRow");
			if (r[i].cont.length <= 1) {
				aClasses.push("sapUiRFLCompleteRow");
			}
			var sRowId = sId + "-row" + this._iRowCounter;
			var oStyles = {};
			this.oRm.writeHeader(sRowId, oStyles, aClasses);

			totalWeight = 0;
			for (ii = 0; ii < r[i].cont.length; ii++) {
				totalWeight += r[i].cont[ii].weight;
			}

			for (j = 0; j < r[i].cont.length; j++) {
				oCont = r[i].cont[j];
				tWeight = 0;
				tMinWidth = 0;

				if (oCont.breakWith.length > 0) {
					tWeight = oCont.weight;
					tMinWidth = oCont.minWidth;
					for (var br = 0; br < oCont.breakWith.length; br++) {
						tWeight += oCont.breakWith[br].weight;
						tMinWidth += oCont.breakWith[br].minWidth;
					}
				}

				/*
				 * Render Container
				 */
				sHeaderId = r[i].cont[j].id;
				aClasses.length = 0;
				// clear all other values from the object
				oStyles = {
					// the unit "px" is added below to be able to calculate with
					// the value of min-width
					"min-width" : oCont.breakWith.length > 0 ? tMinWidth : oCont.minWidth
				}

				iProcWidth = 100 / totalWeight * oCont.weight;
				var iProcMinWidth = oStyles["min-width"] / iWidth * 100;
				// round the values BEFORE they are used for the percental value
				// because if the un-rounded values don't need the percental
				// value
				// of the min-width the percentage value of the calculated width
				// might be lower
				// after it is floored.
				var iPMinWidth = Math.ceil(iProcMinWidth);
				var iPWidth = Math.floor(iProcWidth);
				if (iPWidth !== 100 && iPMinWidth > iPWidth) {
					// if the percentage of the element's width will lead
					// into a too small element use the corresponding
					// percentage value of the min-width
					iProcWidth = iPMinWidth;
				} else {
					iProcWidth = iPWidth;
				}

				// check how many percentage points are still left. If there
				// are less available than calculated just use the rest of
				// the row
				iProcWidth = iRowProcWidth < iProcWidth ? iRowProcWidth : iProcWidth;

				iRowProcWidth -= iProcWidth;
				aWidths.push(iProcWidth);

				// if possible percentage amount is not 0% and this is the
				// last item
				if (iRowProcWidth > 0 && j === (r[i].cont.length - 1)) {
					iProcWidth += iRowProcWidth;
				}

				aClasses.push("sapUiRFLContainer");
				oStyles["width"] = iProcWidth + "%";
				oStyles["min-width"] = oStyles["min-width"] + "px";
				this.oRm.writeHeader(sHeaderId, oStyles, aClasses);

				/*
				 * content rendering (render control)
				 */
				aClasses.length = 0;
				aClasses.push("sapUiRFLContainerContent");
				if (oCont.breakWith.length > 0) {
					aClasses.push("sapUiRFLMultiContainerContent");
				}
				if (oCont.padding) {
					aClasses.push("sapUiRFLPaddingClass");
				}

				oStyles = {};
				this.oRm.writeHeader("", oStyles, aClasses);

				/*
				 * Render all following elements into same container if there
				 * are any that should wrap together with container. Else simply
				 * render the control.
				 */
				if (oCont.breakWith.length > 0) {
					/*
					 * Render first element of wrap-together-group
					 */
					sHeaderId = r[i].cont[j].id + "-multi0";
					aClasses.length = 0;
					oStyles = {
						"min-width" : tMinWidth + "px"
					}
					// set width of first element
					var percW = 100 / tWeight * oCont.weight;
					percW = Math.floor(percW);
					aBreakWidths.push(percW);

					aClasses.push("sapUiRFLMultiContent");
					oStyles["width"] = percW + "%";

					if (r[i].cont[j].padding) {
						aClasses.push("sapUiRFLPaddingClass");
					}
					this.oRm.writeHeader(sHeaderId, oStyles, aClasses);

					// total percentage for all elements
					var tPercentage = percW;

					this.oRm.renderControl(oCont.control);
					this.oRm.write("</div>");

					/*
					 * Render all following elements that should wrap with the
					 * trailing one
					 */
					for (jj = 0; jj < oCont.breakWith.length; jj++) {
						sHeaderId = oCont.breakWith[jj].id + '-multi' + (jj + 1);
						aClasses.length = 0;
						oStyles = {
							"min-width" : oCont.breakWith[jj].minWidth + "px"
						}

						percW = 100 / tWeight * oCont.breakWith[jj].weight;
						percW = Math.floor(percW);

						aBreakWidths.push(percW);
						tPercentage += percW;

						// if percentage is not 100% and this is the last
						// item
						if (tPercentage < 100 && jj === (oCont.breakWith.length - 1)) {
							percW += 100 - tPercentage;
						}

						aClasses.push("sapUiRFLMultiContent");
						oStyles["width"] = percW + "%";

						if (oCont.breakWith[jj].padding) {
							aClasses.push("sapUiRFLPaddingClass");
						}
						this.oRm.writeHeader(sHeaderId, oStyles, aClasses);

						this.oRm.renderControl(oCont.breakWith[jj].control);
						this.oRm.write("</div>");
					}
				} else {
					this.oRm.renderControl(oCont.control);
				}
				this.oRm.write("</div>"); // content

				this.oRm.write("</div>"); // container
			}
			this.oRm.write("</div>"); // row

			this._iRowCounter++;
		}
	};

	var computeWidths = function(bInitial) {
		this._iRowCounter = 0;

		this._oDomRef = this.getDomRef();
		if (this._oDomRef) {
			var sId = this.getId();
			var iInnerWidth = this._oDomRef.offsetWidth;
			var bRender = false;

			if (this._rows) {
				for (var i = 0; i < this._rows.length; i++) {
					var $Row = this._$DomRef.find("#" + sId + "-row" + i);

					var oTargetWrapping = getTargetWrapping(this._rows[i], iInnerWidth);
					var oCurrentWrapping = getCurrentWrapping(this._rows[i], $Row, this);

					// render if wrapping differs
					bRender = checkWrappingDiff(oCurrentWrapping, oTargetWrapping);

					// if the width/height changed so the sizes need to be
					// recalculated
					var oRowRect = $Row.rect();
					var oPrevRect = this._rows[i].oRect;

					if (oRowRect && oPrevRect) {
						bRender = bRender || (oRowRect.width !== oPrevRect.width) && (oRowRect.height !== oPrevRect.height);
					}

					// if this sould be the initial rendering -> do it
					bRender = bRender || (typeof (bInitial) === "boolean" && bInitial);

					if (this._bLayoutDataChanged || bRender) {
						this._oDomRef.innerHTML = "";
						// reset this to be clean for next check interval
						this._bLayoutDataChanged = false;

						this.renderContent(oTargetWrapping, iInnerWidth);
					}
				}

				if (this._oDomRef.innerHTML === "") {
					this.oRm.flush(this._oDomRef);

					for (var i = 0; i < this._rows.length; i++) {
						var oTmpRect = jQuery.sap.byId(sId + "-row" + i).rect();
						this._rows[i].oRect = oTmpRect;
					}
				}

				if (this._rows.length === 0) {
					if (this._resizeHandlerComputeWidthsID) {
						sap.ui.core.ResizeHandler.deregister(this._resizeHandlerComputeWidthsID);
						delete this._resizeHandlerComputeWidthsID;
					}
				}
			}
		}
	};

	/**
	 * Before all controls are rendered it is needed to update the internal
	 * structure of the rows
	 */
	sap.ui.layout.ResponsiveFlowLayout.prototype.onBeforeRendering = function() {
		// update the internal structure of the rows
		updateRows(this);

		if (this._resizeHandlerFullLengthID) {
			sap.ui.core.ResizeHandler.deregister(this._resizeHandlerFullLengthID);
			delete this._resizeHandlerFullLengthID;
		}
	};

	/**
	 * If the layout should be responsive it is necessary to fix the content's
	 * items' widths corresponding to the layout's width
	 */
	sap.ui.layout.ResponsiveFlowLayout.prototype.onAfterRendering = function(oEvent) {
		this._oDomRef = this.getDomRef();
		this._$DomRef = jQuery(this._oDomRef);

		// Initial Width Adaptation
		this._proxyComputeWidths(true);

		if (this.getResponsive()) {
			if (!this._resizeHandlerComputeWidthsID) {
				this._resizeHandlerComputeWidthsID = sap.ui.core.ResizeHandler.register(this, this._proxyComputeWidths);
			}
		} else {
			if (this._resizeHandlerComputeWidthsID) {
				sap.ui.core.ResizeHandler.deregister(this._resizeHandlerComputeWidthsID);
				delete this._resizeHandlerComputeWidthsID;
			}
		}
	};

	sap.ui.layout.ResponsiveFlowLayout.prototype.onThemeChanged = function(oEvent) {
		if (oEvent.type === "LayoutDataChange") {
			this._bLayoutDataChanged = true;
		}
		if (!this._resizeHandlerComputeWidthsID) {
			this._resizeHandlerComputeWidthsID = sap.ui.core.ResizeHandler.register(this, this._proxyComputeWidths);
		}

		updateRows(this);
		this._proxyComputeWidths();
	};

	/**
	 * If any LayoutData was changed the samte stuff like 'onThemeChanged' has
	 * to be done
	 */
	sap.ui.layout.ResponsiveFlowLayout.prototype.onLayoutDataChange = sap.ui.layout.ResponsiveFlowLayout.prototype.onThemeChanged;

	var _getLayoutDataForControl = function(oControl) {
		var oLayoutData = oControl.getLayoutData();

		if (!oLayoutData) {
			return undefined;
		} else if (oLayoutData instanceof sap.ui.layout.ResponsiveFlowLayoutData) {
			return oLayoutData;
		} else if (oLayoutData.getMetadata().getName() == "sap.ui.core.VariantLayoutData") {
			// multiple LayoutData available - search here
			var aLayoutData = oLayoutData.getMultipleLayoutData();
			for (var i = 0; i < aLayoutData.length; i++) {
				var oLayoutData2 = aLayoutData[i];
				if (oLayoutData2 instanceof sap.ui.layout.ResponsiveFlowLayoutData) {
					return oLayoutData2;
				}
			}
		}
	};

	/**
	 * These function needs to be overridden to prevent any rendering while some
	 * content is still being added.
	 * 
	 * @param {Object}
	 *            [oContent] the content that should be added to the layout
	 * @public
	 */
	sap.ui.layout.ResponsiveFlowLayout.prototype.addContent = function(oContent) {
		if (oContent && this._IntervalCall) {
			jQuery.sap.clearDelayedCall(this._IntervalCall);
			this._IntervalCall = undefined;
		}
		this.addAggregation("content", oContent);
	};

	/**
	 * These function needs to be overridden to prevent any rendering while some
	 * content is still being added.
	 * 
	 * @param {Object}
	 *            [oContent] the content that should be inserted to the layout
	 * @param {int}
	 *            [iIndex] the index where the content should be inserted into
	 * @public
	 */
	sap.ui.layout.ResponsiveFlowLayout.prototype.insertContent = function(oContent, iIndex) {
		if (oContent && this._IntervalCall) {
			jQuery.sap.clearDelayedCall(this._IntervalCall);
			this._IntervalCall = undefined;
		}
		this.insertAggregation("content", oContent, iIndex);
	};

	/**
	 * These function needs to be overridden to prevent any rendering while some
	 * content is still being added.
	 * 
	 * @param {Object}
	 *            [oContent] the content that should be removed from the layout
	 * @public
	 */
	sap.ui.layout.ResponsiveFlowLayout.prototype.removeContent = function(oContent) {
		if (oContent && this._IntervalCall) {
			jQuery.sap.clearDelayedCall(this._IntervalCall);
			this._IntervalCall = undefined;
		}
		this.removeAggregation("content", oContent);
	};
}());
}; // end of sap/ui/layout/ResponsiveFlowLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.ui.layout.form.ResponsiveLayout.
jQuery.sap.declare("sap.ui.layout.form.ResponsiveLayout");




/**
 * Constructor for a new form/ResponsiveLayout.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.layout.form.FormLayout#constructor sap.ui.layout.form.FormLayout}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Renders a form with responsive layout. Internally the ResponsiveFlowLayout is used.
 * @extends sap.ui.layout.form.FormLayout
 *
 * @author SAP SE
 * @version 1.24.2
 *
 * @constructor
 * @public
 * @since 1.16.0
 * @name sap.ui.layout.form.ResponsiveLayout
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
sap.ui.layout.form.FormLayout.extend("sap.ui.layout.form.ResponsiveLayout", { metadata : {

	library : "sap.ui.layout"
}});


/**
 * Creates a new subclass of class sap.ui.layout.form.ResponsiveLayout with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.ui.layout.form.ResponsiveLayout.extend
 * @function
 */


// Start of sap\ui\layout\form\ResponsiveLayout.js
/**
 * This file defines behavior for the control,
 */




/*
 * The ResponsiveLayout for forms inside is using ResponsiveFlowLayouts to render the form.
 * There is no own rendering for FormContainers or FormElements.
 * The whole Layout has a Responsive FlowLayout inside to make the FormContainers responsive.
 * Only if there is only one FormContainer inside the Form there is no ResponsiveFlowLayout
 * for the whole layout.
 * A FormContainer is rendered as a Panel if it has a title or an expander. Inside the panel there
 * is a ResponsiveFlowLayout for the single FormElements. If the FormContainer has no title or
 * expander, just the ResponsiveFlowLayout is rendered.
 * A FormElement is rendered as ResponsiveFlowLayout to make the label and the fields responsive.
 * If the Element has a label and more than 1 Field a ResponsiveFlowLayout including the fields is rendered.
 * The Panels and ResponsiveFlowLayouts are stored in object this.mContainers. This has the following
 * structure:
 * - For each FormContainer there is an entry inside the object. (this.mContainers[FormContainerId])
 * - For each FormContainer there is an array with 3 entries:
 *   - [0]: The Panel that renders the Container (undefined if no panel is used)
 *          - It's not the standard Panel, is an special panel defined for the ResponsiveLayout
 *   - [1]: The ResponsiveFlowLayout that holds the Containers content
 *          - the getLayoutData function of this ResponsiveFlowLayouts is overwritten to get the LayoutData of the FormContainer
 *            (If no panel is used)
 *   - [2]: An object that holds the ResponsiveFlowLayouts for the FormElements:
 *          - For each FormElement there is an entry inside the object. (this.mContainers[FormElementId])
 *          - Each object includes an array with 2 entries:
 *            - [0]: The ResponsiveFlowLayout for the FormElement
 *            - [1]: If more than 1 Field and a label, here the ResponsiveFlowLayout for the fields is stored
 *          - the getContent function of this ResponsiveFlowLayouts is overwritten to get the content of the FormElement
 *          - the getLayoutData function of this ResponsiveFlowLayouts is overwritten to get the LayoutData of the FormElement
 *
 * It must be made sure to hold this object up to date. So it is filled onBeforeRendering. Entries no longer used are deleted
 *
 * In this._mainRFLayout the ResponsiveFlowLayout of the whole layout is stored. (If more than one Container.)
 */

/*
 * as the panel can not be used in mobile environment a own internal control is needed to render the containers
 * use FormContainer as association to have access to it's content directly. So no mapping of properties and aggregations needed
 */
sap.ui.core.Control.extend("sap.ui.layout.form.ResponsiveLayoutPanel", {

	metadata : {
		aggregations: {
			"content"   : {type: "sap.ui.layout.ResponsiveFlowLayout", multiple: false}
		},
		associations: {
			"container" : {type: "sap.ui.layout.form.FormContainer", multiple: false},
			"layout"    : {type: "sap.ui.layout.form.ResponsiveLayout", multiple: false}
		}
	},

	getLayoutData :  function(){

		// only ResponsiveFlowLayoutData are interesting
		var oContainer = sap.ui.getCore().byId(this.getContainer());
		var oLayout    = sap.ui.getCore().byId(this.getLayout());
		var oLD;
		if (oLayout && oContainer) {
			oLD = oLayout.getLayoutDataForElement(oContainer, "sap.ui.layout.ResponsiveFlowLayoutData");
		}
		return oLD;

	},

	getCustomData :  function(){

		var oContainer = sap.ui.getCore().byId(this.getContainer());
		if (oContainer) {
			return oContainer.getCustomData();
		}

	},

	refreshExpanded :  function(){

		var oContainer = sap.ui.getCore().byId(this.getContainer());
		if (oContainer) {
			if (oContainer.getExpanded()) {
				this.$().removeClass("sapUiRLContainerColl");
			}else {
				this.$().addClass("sapUiRLContainerColl");
			}
		}
	},

	renderer : function(oRm, oPanel) {

		var oContainer = sap.ui.getCore().byId(oPanel.getContainer());
		var oLayout    = sap.ui.getCore().byId(oPanel.getLayout());
		var oContent   = oPanel.getContent();

		if (!oContainer || !oLayout) {
			// Container might be removed, but ResponsiveFlowLayout still calls a rerendering with old content
			return;
		}

		var bExpandable = oContainer.getExpandable();
		var sTooltip = oContainer.getTooltip_AsString();

		oRm.write("<div");
		oRm.writeControlData(oPanel);
		oRm.addClass("sapUiRLContainer");
		if (bExpandable && !oContainer.getExpanded()) {
			oRm.addClass("sapUiRLContainerColl");
		}

		if (sTooltip) {
			oRm.writeAttributeEscaped('title', sTooltip);
		}
		oRm.writeClasses();
		oRm.write(">");

		// container header
		if (oContainer.getTitle()) {
			oLayout.getRenderer().renderTitle(oRm, oContainer.getTitle(), oContainer._oExpandButton, bExpandable, false, oContainer.getId());
		}

		if (oContent) {
			oRm.write("<div");
			oRm.addClass("sapUiRLContainerCont");
			oRm.writeClasses();
			oRm.write(">");
			// container is not expandable or is expanded -> render elements
			oRm.renderControl(oContent);
			oRm.write("</div>");
		}

		oRm.write("</div>");
	}

});

(function() {

	sap.ui.layout.form.ResponsiveLayout.prototype.init = function(){

		this.mContainers = {}; //association of container to panel and ResponsiveFlowLayout
		this._defaultLayoutData = new sap.ui.layout.ResponsiveFlowLayoutData({margin: false});

	};

	sap.ui.layout.form.ResponsiveLayout.prototype.exit = function(){

		var that = this;

		// clear panels
		for ( var sContainerId in this.mContainers) {
			_cleanContainer(that, sContainerId);
		}

		// clear ResponsiveFlowLayouts
		if (this._mainRFLayout) {
			this._mainRFLayout.destroy();
			delete this._mainRFLayout;
		}

		this._defaultLayoutData.destroy();
		delete this._defaultLayoutData;

	};

	sap.ui.layout.form.ResponsiveLayout.prototype.onBeforeRendering = function( oEvent ){

		var oForm = this.getParent();
		if (!oForm || !(oForm instanceof sap.ui.layout.form.Form)) {
			// layout not assigned to form - nothing to do
			return;
		}

		oForm._bNoInvalidate = true; // don't invalidate Form if only the Grids, Panels and LayoutData are created or changed)
		var that = this;
		_createPanels(that, oForm);
		_createMainResponsiveFlowLayout(that, oForm);
		oForm._bNoInvalidate = false;

	};

	/*
	 * If onAfterRendering of a field is processed the width must be set to 100% (if no other width set)
	 */
	sap.ui.layout.form.ResponsiveLayout.prototype.contentOnAfterRendering = function(oFormElement, oControl){

		sap.ui.layout.form.FormLayout.prototype.contentOnAfterRendering.apply(this, arguments);

		if (oControl.getWidth && ( !oControl.getWidth() || oControl.getWidth() == "auto" ) && oControl.getMetadata().getName() != "sap.ui.commons.Image") {
			oControl.$().css("width", "100%");
		}

	};

	sap.ui.layout.form.ResponsiveLayout.prototype.toggleContainerExpanded = function(oContainer){

		//adapt the corresponding panel
		var bExpanded = oContainer.getExpanded();
		var sContainerId = oContainer.getId();
		if (this.mContainers[sContainerId] && this.mContainers[sContainerId][0]) {
			var oPanel = this.mContainers[sContainerId][0];
			oPanel.refreshExpanded();
		}

	};

	sap.ui.layout.form.ResponsiveLayout.prototype.onLayoutDataChange = function(oEvent){

		var oSource = oEvent.srcControl;
		var oContainer;
		var sContainerId;
		var sElementId;

		// if layoutData changed for a Container, Element, or Field call the
		// onLayoutDataChange function of the parent ResponsiveFlowLayout

		if (oSource instanceof sap.ui.layout.form.FormContainer) {
			if (this._mainRFLayout) {
				this._mainRFLayout.onLayoutDataChange(oEvent);
			}
		} else if (oSource instanceof sap.ui.layout.form.FormElement) {
			sContainerId = oSource.getParent().getId();
			if (this.mContainers[sContainerId] && this.mContainers[sContainerId][1]) {
				this.mContainers[sContainerId][1].onLayoutDataChange(oEvent);
			}
		}else{
			var oParent = oSource.getParent();
			if (oParent instanceof sap.ui.layout.form.FormElement) {
				oContainer = oParent.getParent();
				sContainerId = oContainer.getId();
				sElementId = oParent.getId();
				if (this.mContainers[sContainerId] && this.mContainers[sContainerId][2] &&
					this.mContainers[sContainerId][2][sElementId]) {
					this.mContainers[sContainerId][2][sElementId][0].onLayoutDataChange(oEvent);
				}
			}
		}

	};

	sap.ui.layout.form.ResponsiveLayout.prototype.onsapup = function(oEvent){
		this.onsapleft(oEvent);
	};

	sap.ui.layout.form.ResponsiveLayout.prototype.onsapdown = function(oEvent){
		this.onsapright(oEvent);
	};

	function _createPanels( oLayout, oForm ) {

		var aContainers = oForm.getFormContainers();
		var oContainer;
		var sContainerId;
		var iLength = aContainers.length;
		var iVisibleContainers = 0;
		var oPanel;
		var oRFLayout;
		var i = 0;
		for ( i = 0; i < iLength; i++) {
			oContainer = aContainers[i];
			oContainer._checkProperties();
			if (oContainer.getVisible()) {
				iVisibleContainers++;
				sContainerId = oContainer.getId();
				oPanel = undefined;
				oRFLayout = undefined;
				if (oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][1]) {
					// ResponsiveFlowLayout already created
					oRFLayout = oLayout.mContainers[sContainerId][1];
				}else{
					oRFLayout = _createResponsiveFlowLayout(oLayout, oContainer, undefined);
				}

				var oTitle = oContainer.getTitle();
				if (oTitle || oContainer.getExpandable()) {
					// only if container has a title a panel is used
					if (oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][0]) {
						// Panel already created
						oPanel = oLayout.mContainers[sContainerId][0];
					}else{
						oPanel = _createPanel(oLayout, oContainer, oRFLayout);
						_changeGetLayoutDataOfResponsiveFlowLayout(oRFLayout, true);
					}
				}else{
					// panel not longer needed
					if (oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][0]) {
						_deletePanel(oLayout.mContainers[sContainerId][0]);
						_changeGetLayoutDataOfResponsiveFlowLayout(oRFLayout, false);
					}
				}

				var mContent = _createContent(oLayout, oContainer, oRFLayout);

				oLayout.mContainers[sContainerId] = [oPanel, oRFLayout, mContent];
			}
		}

		var iObjectLength = _objectLength(oLayout.mContainers);
		if (iVisibleContainers < iObjectLength) {
			// delete old containers panels
			for ( sContainerId in oLayout.mContainers) {
				var bFound = false;
				for ( i = 0; i < iLength; i++) {
					oContainer = aContainers[i];
					if (sContainerId == oContainer.getId() && oContainer.getVisible()) {
						bFound = true;
						break;
					}
				}
				if (!bFound) {
					_cleanContainer(oLayout, sContainerId);
				}
			}
		}

	}

	function _createPanel( oLayout, oContainer, oRFLayout ) {

		var sContainerId = oContainer.getId();
		var oPanel = new sap.ui.layout.form.ResponsiveLayoutPanel(sContainerId+"--Panel", {
			container: oContainer,
			layout   : oLayout,
			content : oRFLayout
		});

		return oPanel;

	}

	/*
	 * clear variables before delete it
	 */
	function _deletePanel( oPanel ) {

		oPanel.setContent("");
		oPanel.setLayout("");
		oPanel.setContainer("");
		oPanel.destroy();
		delete oPanel;

	}

	function _createContent( oLayout, oContainer, oContainerLayout ) {

		var sContainerId = oContainer.getId();
		var aElements = oContainer.getFormElements();
		var iLength = aElements.length;
		var iVisibleElements = 0;
		var mRFLayouts = {};
		if (oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][2]) {
			mRFLayouts = oLayout.mContainers[sContainerId][2];
		}

		var oRFLayout;
		var oFieldsRFLayout;
		var iLastIndex = -1;
		var oElement;
		var sElementId;
		var i = 0;
		for (i = 0; i < iLength; i++) {
			oElement = aElements[i];
			if (oElement.getVisible()) {
				sElementId = oElement.getId();
				_checkElementMoved(oLayout, oContainer, oElement, mRFLayouts, oContainerLayout, i);
				if (mRFLayouts[sElementId]) {
					// ResponsiveFlowLayout already created
					oRFLayout = mRFLayouts[sElementId][0];
					iLastIndex = oContainerLayout.indexOfContent(oRFLayout);
				}else{
					oRFLayout = _createResponsiveFlowLayout(oLayout, oContainer, oElement);
					oRFLayout.addStyleClass("sapUiRLElement");
					if (oElement.getLabel()) {
						oRFLayout.addStyleClass("sapUiRLElementWithLabel");
					}
					mRFLayouts[sElementId] = [oRFLayout, undefined];
					iLastIndex++;
					oContainerLayout.insertContent(oRFLayout, iLastIndex);
				}

				// if more fields after a label put the fields in an additional ResponsiveFlowLayout
				var aFields = oElement.getFields();
				if (oElement.getLabel() && aFields.length > 1) {
					if (mRFLayouts[sElementId][1]) {
						oFieldsRFLayout = mRFLayouts[sElementId][1];
					} else {
						oFieldsRFLayout = _createResponsiveFlowLayout(oLayout, oContainer, oElement, true);
						oFieldsRFLayout.addStyleClass("sapUiRLElementFields");
						mRFLayouts[sElementId][1] = oFieldsRFLayout;
					}
					_updateLayoutDataOfContentResponsiveFlowLayout(oLayout, oFieldsRFLayout, aFields);
				} else {
					if (mRFLayouts[sElementId][1]) {
						// ResponsiveFlowLayout for fields not longer needed
						oFieldsRFLayout = mRFLayouts[sElementId][1];
						_deleteResponsiveFlowLayout(oFieldsRFLayout);
						mRFLayouts[sElementId][1] = undefined;
					}
				}
				iVisibleElements++;
			}
		}

		var iObjectLength = _objectLength(mRFLayouts);
		if (iVisibleElements < iObjectLength) {
			// delete old elements RFLayouts
			for ( sElementId in mRFLayouts) {
				var bFound = false;
				for ( i = 0; i < iLength; i++) {
					oElement = aElements[i];
					if (sElementId == oElement.getId() && oElement.getVisible()) {
						bFound = true;
						break;
					}
				}
				if (!bFound) {
					if (mRFLayouts[sElementId][1]) {
						// ResponsiveFlowLayout for fields not longer needed
						oFieldsRFLayout = mRFLayouts[sElementId][1];
						_deleteResponsiveFlowLayout(oFieldsRFLayout);
					}
					oRFLayout = mRFLayouts[sElementId][0];
					oContainerLayout.removeContent(oRFLayout);
					_deleteResponsiveFlowLayout(oRFLayout);
					delete mRFLayouts[sElementId];
				}
			}
		}

		return mRFLayouts;

	}

	function _createResponsiveFlowLayout( oLayout, oContainer, oElement, bElementContent ) {

		var sId;
		if (oElement && !bElementContent) {
			sId = oElement.getId()+"--RFLayout";
		} else if (oElement && bElementContent) {
			sId = oElement.getId()+"--content--RFLayout";
		} else if (oContainer) {
			sId = oContainer.getId() + "--RFLayout";
		} else {
			return false;
		}

		var oRFLayout = new sap.ui.layout.ResponsiveFlowLayout(sId);
		oRFLayout.__myParentLayout = oLayout;
		oRFLayout.__myParentContainerId = oContainer.getId();

		if (oElement) {
			oRFLayout.__myParentElementId = oElement.getId();
			// assign Elements content -> overwrite getContent function of responsiveFlowLayout
			// to not change parent assignment of controls
			if (!bElementContent) {
				oRFLayout.getContent = function(){
					var oElement = sap.ui.getCore().byId(this.__myParentElementId);
					if (oElement) {
						var aContent = new Array();
						var oLabel = oElement.getLabelControl();
						var aFields = oElement.getFields();
						if (!oLabel || aFields.length <= 1) {
							aContent = aFields;
							if (oLabel) {
								aContent.unshift(oLabel);
							}
						}else{
							// more than one field -> put in the content RFLayout
							var oLayout = this.__myParentLayout;
							var sContainerId = this.__myParentContainerId;
							var sElementId = oElement.getId();
							if (oLabel) {
								aContent.push(oLabel);
							}
							if(oLayout.mContainers[sContainerId] && oLayout.mContainers[sContainerId][2] &&
									oLayout.mContainers[sContainerId][2][sElementId] &&
									oLayout.mContainers[sContainerId][2][sElementId][1]){
								aContent.push(oLayout.mContainers[sContainerId][2][sElementId][1]);
							}
						}

						return aContent;
					}else{
						return false;
					}
				}
			}else{
				oRFLayout.getContent = function(){
					var oElement = sap.ui.getCore().byId(this.__myParentElementId);
					if (oElement) {
						return oElement.getFields();
					}else{
						return false;
					}
				}
			}
		}

		if ((oElement && !bElementContent) || (!oElement && !oContainer.getTitle() && !oContainer.getExpandable())) {
			// use LayoutData of container only if no panel is used
			_changeGetLayoutDataOfResponsiveFlowLayout(oRFLayout, false);
		}else{
			// create LayoutData to disable margins
			oRFLayout.setLayoutData(new sap.ui.layout.ResponsiveFlowLayoutData({margin: false}));
		}

		return oRFLayout;

	}

	function _changeGetLayoutDataOfResponsiveFlowLayout( oRFLayout, bOriginal ) {
		// only ResponsiveFlowLayoutData are from interest
		// if none maintained use default one to disable margins

		if (bOriginal) {
			if (oRFLayout.__originalGetLayoutData) {
				oRFLayout.getLayoutData = oRFLayout.__originalGetLayoutData;
				delete oRFLayout.__originalGetLayoutData;
			}
		}else if(!oRFLayout.__originalGetLayoutData){
			oRFLayout.__originalGetLayoutData = oRFLayout.getLayoutData;
			oRFLayout.getLayoutData = function(){
				var oLayout = this.__myParentLayout;
				var oContainer = sap.ui.getCore().byId(this.__myParentContainerId);
				var oElement = sap.ui.getCore().byId(this.__myParentElementId);

				var oLD;
				if (oElement) {
					oLD = oLayout.getLayoutDataForElement(oElement, "sap.ui.layout.ResponsiveFlowLayoutData");
				}else if (oContainer) {
					oLD = oLayout.getLayoutDataForElement(oContainer, "sap.ui.layout.ResponsiveFlowLayoutData");
				}

				if (oLD) {
					return oLD;
				}else {
					return oLayout._defaultLayoutData;
				}
			};
		}

	}

	/*
	 * If a ResponsiveFlowLayout for the fields of an FormElement is used it must get the weight
	 * of all fields to have the right weight relative to the label.
	 */
	function _updateLayoutDataOfContentResponsiveFlowLayout( oLayout, oRFLayout, aFields ) {

		var oLD;
		var iWeight = 0;
		for ( var i = 0; i < aFields.length; i++) {
			var oField = aFields[i];
			oLD = oLayout.getLayoutDataForElement(oField, "sap.ui.layout.ResponsiveFlowLayoutData");
			if (oLD) {
				iWeight = iWeight + oLD.getWeight();
			} else {
				iWeight++;
			}
		}

		oLD = oRFLayout.getLayoutData();
		if (oLD) {
			oLD.setWeight(iWeight);
		} else {
			oRFLayout.setLayoutData(
					new sap.ui.layout.ResponsiveFlowLayoutData({weight: iWeight})
			);
		}

	}

	/*
	 * clear variables before delete it
	 */
	function _deleteResponsiveFlowLayout( oRFLayout ) {

		if (oRFLayout.__myParentContainerId) {
			oRFLayout.__myParentContainerId = undefined;
		}
		if (oRFLayout.__myParentElementId) {
			oRFLayout.__myParentElementId = undefined;
		}
		oRFLayout.__myParentLayout = undefined;

		oRFLayout.destroy();
		delete oRFLayout;

	}

	function _cleanContainer( oLayout, sContainerId ) {

		var aContainerContent = oLayout.mContainers[sContainerId];
		var oRFLayout;

		//delete Elements Content
		var oElementRFLayouts = aContainerContent[2];
		if (oElementRFLayouts) {
			for ( var sElementId in oElementRFLayouts) {
				if (oElementRFLayouts[sElementId][1]) {
					// ResponsiveFlowLayout for fields not longer needed
					_deleteResponsiveFlowLayout(oElementRFLayouts[sElementId][1]);
				}
				oRFLayout = oElementRFLayouts[sElementId][0];
				_deleteResponsiveFlowLayout(oRFLayout);
				delete oElementRFLayouts[sElementId];
			}
		}

		//delete ResponsiveFlowLayout
		oRFLayout = aContainerContent[1]
		if (oRFLayout) {
			oRFLayout.removeAllContent();
			_deleteResponsiveFlowLayout(oRFLayout);
		}

		//delete panel
		var oPanel = aContainerContent[0];
		if (oPanel) {
			_deletePanel(oPanel);
		}

		delete oLayout.mContainers[sContainerId];

	}

	function _checkElementMoved(oLayout, oContainer, oElement, mRFLayouts, oContainerLayout, iIndex){

		// if a Element is just moved from one Container to an other this is not recognized
		// so the ResponsiveFlowLayouts must be updated and the control object must be adjusted
		var sElementId = oElement.getId();
		var sId = sElementId+"--RFLayout";
		var oRFLayout = sap.ui.getCore().byId(sId);

		if (!mRFLayouts[sElementId] && oRFLayout) {
			// Element not maintained in control object of container but already has a RFLayout
			// find old container id
			var sOldContainerId = oRFLayout.__myParentContainerId;

			// move to new containers control object
			mRFLayouts[sElementId] = oLayout.mContainers[sOldContainerId][2][sElementId];
			oContainerLayout.insertContent(oRFLayout, iIndex);
			oRFLayout.__myParentContainerId = oContainer.getId();
			if (mRFLayouts[sElementId][1]) {
				mRFLayouts[sElementId][1].__myParentContainerId = oContainer.getId();
			}

			// delete from old container in control object
			delete oLayout.mContainers[sOldContainerId][2][sElementId];
		}

	}

	function _createMainResponsiveFlowLayout( oLayout, oForm ) {

		var aContainers = oForm.getFormContainers();
		var oContainer;
		var iLength = 0;
		var iContentLenght = 0;
		var i = 0;

		// count only visible containers
		for ( i = 0; i < aContainers.length; i++) {
			oContainer = aContainers[i];
			if (oContainer.getVisible()) {
				iLength++;
			}
		}

		// special case: only one container -> do not render an outer ResponsiveFlowLayout
		if (iLength > 1) {
			if (!oLayout._mainRFLayout) {
				oLayout._mainRFLayout = new sap.ui.layout.ResponsiveFlowLayout(oForm.getId()+"--RFLayout").setParent(oLayout);
			}else{
				// update containers
				var aLayoutContent = oLayout._mainRFLayout.getContent();
				iContentLenght = aLayoutContent.length;
				var bExchangeContent = false;
				// check if content has changed
				for ( i = 0; i < iContentLenght; i++) {
					var oContentElement = aLayoutContent[i];
					oContainer = undefined;
					if (oContentElement.getContainer) {
						// it's a panel
						oContainer = sap.ui.getCore().byId(oContentElement.getContainer());
					} else {
						// it's a RFLayout
						oContainer = sap.ui.getCore().byId(oContentElement.__myParentContainerId);
					}
					if (oContainer && oContainer.getVisible()) {
						var aContainerContent = oLayout.mContainers[oContainer.getId()];
						if (aContainerContent[0] && aContainerContent[0] != oContentElement) {
							// container uses panel but panel not the same element in content
							bExchangeContent = true;
							break;
						}
						if (!aContainerContent[0] && aContainerContent[1] && aContainerContent[1] != oContentElement) {
							// container uses no panel but RFLayout not the same element in content
							bExchangeContent = true;
							break;
						}
					}else{
						// no container exits for content -> just remove this content
						oLayout._mainRFLayout.removeContent(oContentElement);
					}
				}
				if (bExchangeContent) {
					// remove all content and add it new.
					oLayout._mainRFLayout.removeAllContent();
					iContentLenght = 0;
				}
			}
			if (iContentLenght < iLength) {
				// new containers added
				for ( i = 0; i < aContainers.length; i++) {
					oContainer = aContainers[i];
					if (oContainer.getVisible()) {
						var sContainerId = oContainer.getId();
						if (oLayout.mContainers[sContainerId]) {
							if (oLayout.mContainers[sContainerId][0]) {
								// panel used
								oLayout._mainRFLayout.addContent(oLayout.mContainers[sContainerId][0]);
							} else if (oLayout.mContainers[sContainerId][1]){
								// no panel - used ResponsiveFlowLayot directly
								oLayout._mainRFLayout.addContent(oLayout.mContainers[sContainerId][1]);
							}
						}
					}
				}
			}
		}

	}

	function _objectLength(oObject){

		var iLength = 0;

		if (!Object.keys) {
			jQuery.each(oObject, function(){iLength++});
		} else {
			iLength = Object.keys(oObject).length;
		}

		return iLength;

	}

}());

}; // end of sap/ui/layout/form/ResponsiveLayout.js
