/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Sorter','sap/ui/model/FilterOperator','./odata4analytics'],function(q,T,C,S,F,o){"use strict";var A=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,c,s,f,P){T.call(this,m,p,c,f,P);this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(f);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bUseAcceleratedAutoExpand=true;this.aRequestQueue=[];this.iTotalSize=-1;this.mKey={};this.mFinalLength={};this.mLength={};this.bNeedsUpdate=false;this.mOwnKey={};this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.updateAnalyticalInfo(P==undefined?[]:P.analyticalInfo)}});A.prototype.getRootContexts=function(p){var a=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(A._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return null}if(a<=1){r=this._getContextsForParentContext(null);if(a==1){this._considerRequestGrouping([R,this._getRequestId(A._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0})}}else{r=this._getContextsForParentContext(null);var b=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);b.push(R);this._considerRequestGrouping(b);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels})}if(r.length>1)q.sap.log.fatal("assertion failed: grand total represented by a single entry");return r};A.prototype.getNodeContexts=function(c,p){var s,l,t,L,n;if(typeof p=="object"){s=p.startIndex;l=p.length;t=p.threshold;L=p.level;n=p.numberOfExpandedLevels}else{s=arguments[1];l=arguments[2];t=arguments[3];L=arguments[4];n=arguments[5]}var a=this._getContextsForParentContext(c,s,l,t,L,n);return a};A.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};A.prototype.hasAvailableNodeContexts=function(c,l){var g=this._getGroupIdFromContext(c,l);if(this.mKey[g]!=undefined)if(this.mFinalLength[g]==true)return A.prototype.ContextsAvailabilityStatus.ALL;else return A.prototype.ContextsAvailabilityStatus.SOME;else return A.prototype.ContextsAvailabilityStatus.NONE};A.prototype.getGroupSize=function(c,l){if(c===undefined)return 0;var g=this._getGroupIdFromContext(c,l);return this.mFinalLength[g]?this.mLength[g]:-1};A.prototype.getTotalSize=function(){if(!this.bProvideTotalSize)q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");return this.iTotalSize};A.prototype.hasChildren=function(c,p){if(c===undefined)return false;if(c==null)return true;var i=p.level;if(i==0)return true;if(this.aAggregationLevel.length<i)return false;return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1};A.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){h=true;break}return h};A.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet};A.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet};A.prototype.hasGrandTotalDisplayed=function(){return this.bProvideGrandTotals};A.prototype.getProperty=function(p){return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p)};A.prototype.getFilterablePropertyNames=function(){return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames()};A.prototype.getSortablePropertyNames=function(){return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames()};A.prototype.getPropertyLabel=function(p){return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p)};A.prototype.getPropertyHeading=function(p){return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p)};A.prototype.getPropertyQuickInfo=function(p){return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p)};A.prototype.isMeasure=function(p){return q.inArray(p,this.aMeasureName)!==-1};A.prototype.filter=function(f,s){f=this._convertDeprecatedFilterObjects(f);if(s==sap.ui.model.FilterType.Application)this.aApplicationFilter=f;else this.aControlFilter=f;this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Filter});return this};A.prototype.sort=function(s){if(s instanceof S){s=[s]}this.aSorter=s?s:[];this._abortAllPendingRequests();this._fireRefresh({reason:C.Sort});return this};A.prototype.getGroupName=function(c,l){if(c===undefined)return"";var g=this.aAggregationLevel[l-1],d=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),v=this.mAnalyticalInfoByProperty[g].formatter,p=c.getProperty(g),t,f,G;if(d&&this.oDimensionDetailsSet[g].textPropertyName){t=d.getTextProperty()}var s,a,b,a;if(t){s=d.getTextProperty().name;b=this.mAnalyticalInfoByProperty[s].formatter;a=c.getProperty(s)}if(!t){f=v?v(p):p;G=((d.getLabelText())?d.getLabelText()+': ':'')+f}else{f=v?v(p,a):p;G=((d.getLabelText())?d.getLabelText()+': ':'')+f;var e=b?b(a,p):a;if(e){G+=' - '+e}}return G};A.prototype.updateAnalyticalInfo=function(c){var p=this.oDimensionDetailsSet;this.mAnalyticalInfoByProperty=new Object();this.aMaxAggregationLevel=new Array();this.aAggregationLevel=new Array();this.aMeasureName=new Array();this.iAnalyticalInfoVersionNumber=(this.iAnalyticalInfoVersionNumber===undefined?1:(this.iAnalyticalInfoVersionNumber>999?1:this.iAnalyticalInfoVersionNumber+1));this.oMeasureDetailsSet=new Object();this.oDimensionDetailsSet=new Object();for(var i=0;i<c.length;i++){var d=this.oAnalyticalQueryResult.findDimensionByPropertyName(c[i].name);if(d&&(c[i].inResult==true||c[i].visible==true)){c[i].dimensionPropertyName=d.getName();var D=this.oDimensionDetailsSet[d.getName()];if(!D){D=new Object();D.name=d.getName();D.aAttributeName=new Array();D.grouped=false;this.oDimensionDetailsSet[d.getName()]=D;this.aMaxAggregationLevel.push(D.name);if(c[i].grouped==true)this.aAggregationLevel.push(D.name)}if(c[i].grouped==true){if(this.getSortablePropertyNames().indexOf(d.getName())==-1){q.sap.log.fatal("property "+d.getName()+" must be sortable in order to be used as grouped dimension")}D.grouped=true}if(d.getName()==c[i].name){D.keyPropertyName=c[i].name}var t=d.getTextProperty();if(t&&t.name==c[i].name){D.textPropertyName=c[i].name}if(d.findAttributeByName(c[i].name)){D.aAttributeName.push(c[i].name)}D.analyticalInfo=c[i]}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(c[i].name);if(m&&(c[i].inResult==true||c[i].visible==true)){c[i].measurePropertyName=m.getName();var M=this.oMeasureDetailsSet[m.getName()];if(!M){M=new Object();M.name=m.getName();this.oMeasureDetailsSet[m.getName()]=M;this.aMeasureName.push(M.name)}if(m.getRawValueProperty().name==c[i].name){M.rawValuePropertyName=c[i].name}var f=m.getFormattedValueProperty();if(f&&f.name==c[i].name){M.formattedValuePropertyName=c[i].name}M.analyticalInfo=c[i]}this.mAnalyticalInfoByProperty[c[i].name]=c[i]}var M;for(var a in this.oMeasureDetailsSet){var u=this.oAnalyticalQueryResult.findMeasureByName(a).getUnitProperty();if(u)this.oMeasureDetailsSet[a].unitPropertyName=u.name}var b=function(e){var n=[];for(var g in e)n.push(g.name);return n.sort().join(";")};if(b(p)!=b(this.oDimensionDetailsSet))this.iTotalSize=-1;this.aAnalyticalInfo=c;this.mFinalLength={};this.mLength={};this.mKey={};this.mOwnKey={};this.mContexts={};this.bNeedsUpdate=false};A.prototype.getAnalyticalInfoForColumn=function(c){return this.mAnalyticalInfoByProperty[c]};A.prototype.loadGroups=function(g){var G=new Array();for(var s in g){G.push(s);delete this.mKey[s];delete this.mLength[s];delete this.mFinalLength[s];var a=g[s];for(var i=0;i<a.length;i++){var b=a[i];this._getContextsForParentGroupId(s,b.startIndex,b.length,b.threshold)}var r=new Array();for(var i=-1,s;s=G[++i];){r.push(this._getRequestId(A._requestType.groupMembersQuery,{groupId:s}))}this._considerRequestGrouping(r)}};A.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult};A._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4};A.prototype._getContextsForParentContext=function(p,s,l,t,L,n){if(p===undefined)return[];if(p&&p.getPath()=="/artificialRootContent"){p=this.getModel().getContext("/")}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,t,n)};A.prototype._getContextsForParentGroupId=function(p,s,l,t,n){if(p===undefined)return[];if(!s)s=0;if(!l)l=this.oModel.iSizeLimit;if(this.mFinalLength[p]&&this.mLength[p]<l)l=this.mLength[p];if(!t)t=0;if(!n)n=0;if(p==null){if(n>0){q.sap.log.fatal("invalid request to determine nodes of root context");return null}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1}}var c,L,g,a,G,m;var b=n>0&&p!=null;if(b){var M=this._getGroupIdLevel(p);var d=M+n;G=this._calculateRequiredGroupExpansion(p,d,s,l+t);var D=G.groupId_Missing==null;D=D||G.groupId_Missing.length<p.length||G.groupId_Missing.substring(0,p.length)!=p;if(D){q.sap.log.debug("auto expand: data available for group ID "+p);c=this._getLoadedContextsForGroup(p,s,l)}else{m=l+t}L=!D}else{c=this._getLoadedContextsForGroup(p,s,l);g=this._calculateRequiredGroupSection(p,s,l,t,c);var P=g.length>0&&l<g.length;L=(c.length!=l&&!(this.mFinalLength[p]&&c.length>=this.mLength[p]-s))||P}if(!L)this._cleanupGroupingForCompletedRequest(this._getRequestId(A._requestType.groupMembersQuery,{groupId:p}));if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(A._requestType.totalSizeQuery));var e=true;var f;if(this.bUseBatchRequests){if(b){f=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,r;r=f[++i];){if(this._isRequestPending(r)){e=false;break}}if(e){this.aRequestQueue.push([A._requestType.groupMembersAutoExpansionQuery,p,G,m,n])}}else{e=!this._isRequestPending(this._getRequestId(A._requestType.groupMembersQuery,{groupId:p}));if(e){this.aRequestQueue.push([A._requestType.groupMembersQuery,p,g.startIndex,g.length]);f=[this._getRequestId(A._requestType.groupMembersQuery,{groupId:p})]}}if(e&&N){f.push(this._getRequestId(A._requestType.totalSizeQuery));this._considerRequestGrouping(f);this.aRequestQueue.push([A._requestType.totalSizeQuery])}if(e){if(p==null){this._abortAllPendingRequests()}q.sap.delayedCall(0,this,A.prototype._processRequestQueue)}}else{var h;if(b){f=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,r;r=f[++i];){if(this._isRequestPending(r)){e=false;break}}if(e){h=this._prepareGroupMembersAutoExpansionQueryRequest(A._requestType.groupMembersAutoExpansionQuery,p,G,m,n)}}else{e=!this._isRequestPending(this._getRequestId(A._requestType.groupMembersQuery,{groupId:p}));if(e){h=this._prepareGroupMembersQueryRequest(A._requestType.groupMembersQuery,p,g.startIndex,g.length);f=[h.sRequestId]}}if(e){if(p==null){this._abortAllPendingRequests()}this._executeQueryRequest(h);if(N&&!h.bIsFlatListRequest){f.push(this._getRequestId(A._requestType.totalSizeQuery));this._considerRequestGrouping(f);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(A._requestType.totalSizeQuery))}}}}}return c};A.prototype._processRequestQueue=function(){if(this.aRequestQueue.length==0)return;var r=[];var f=false;for(var i=-1,R;R=this.aRequestQueue[++i];){if(R[0]==A._requestType.groupMembersQuery){var a=A.prototype._prepareGroupMembersQueryRequest.apply(this,R);f=f||a.bIsFlatListRequest;r.push(a)}}for(var i=-1,R;R=this.aRequestQueue[++i];){var a=null;switch(R[0]){case A._requestType.groupMembersQuery:continue;case A._requestType.totalSizeQuery:if(!f){a=A.prototype._prepareTotalSizeQueryRequest.apply(this,R);r.push(a)}break;case A._requestType.groupMembersAutoExpansionQuery:a=A.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,R);for(var j=-1,l;l=a.aGroupMembersAutoExpansionRequestDetails[++j];){r.push(l)}break;default:q.sap.log.fatal("unhandled request type "+this.aRequestQueue[i][0]);continue}}if(r.length>1)this._executeBatchRequest(r);else this._executeQueryRequest(r[0]);this.aRequestQueue=[]};A.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[];var c=this.iAnalyticalInfoVersionNumber;var a=new o.QueryResultRequest(this.oAnalyticalQueryResult);a.setResourcePath(this._getResourcePath());a.getSortExpression().clear();var b=0,d=-1;if(g){G=this._getGroupIdComponents(g);b=d=G.length;var u=0;for(var i=0,e=0;i<b;e++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[e]].grouped==false)++u;else++i}b=d=b+u;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[d]].grouped==false)if(++d==this.aMaxAggregationLevel.length)break}}var I=d>=this.aMaxAggregationLevel.length-1;var f=this.aMaxAggregationLevel.slice(0,d+1);a.setAggregationLevel(f);for(var i=0;i<f.length;i++){var D=this.oDimensionDetailsSet[f[i]];var h=(D.keyPropertyName!=undefined);var j=(D.textPropertyName!=undefined);a.includeDimensionKeyTextAttributes(D.name,true,j,D.aAttributeName);if(D.grouped){a.getSortExpression().addSorter(f[i],o.SortOrder.Ascending)}}var k=a.getFilterExpression();k.clear();if(this.aApplicationFilter)k.addUI5FilterConditions(this.aApplicationFilter);if(this.aControlFilter)k.addUI5FilterConditions(this.aControlFilter);if(b>=1){for(var i=0,l=G.length;i<l;i++){k.addCondition(this.aAggregationLevel[i],F.EQ,G[i])}}var m;var n;var p;var M;var t=new Array();if(g!=null||this.bProvideGrandTotals){a.setMeasures(this.aMeasureName);for(var v in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[v];if(!I&&this.mAnalyticalInfoByProperty[v].total==false){m=false;n=false;p=false}else{m=(M.rawValuePropertyName!=undefined);n=(M.formattedValuePropertyName!=undefined);p=(M.unitPropertyName!=undefined);if(p){if(t.indexOf(M.unitPropertyName)==-1){t.push(M.unitPropertyName)}}}a.includeMeasureRawFormattedValueUnit(M.name,m,n,p)}for(var i in f){var w;if((w=t.indexOf(f[i]))!=-1)t.splice(w,1)}}var x=a.getSortExpression();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i])x.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?o.SortOrder.Descending:o.SortOrder.Ascending)}if(L==0)q.sap.log.fatal("unhandled case: load 0 entities of sub group");a.setResultPageBoundaries(s+1,s+L);a.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(A._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:a,sGroupId:g,aSelectedUnitPropertyName:t,aAggregationLevel:f,bIsFlatListRequest:I&&b==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L}};A.prototype._prepareTotalSizeQueryRequest=function(r){var c=this.iAnalyticalInfoVersionNumber;var a=new o.QueryResultRequest(this.oAnalyticalQueryResult);a.setResourcePath(this._getResourcePath());a.setAggregationLevel(this.aMaxAggregationLevel);a.setMeasures([]);var f=a.getFilterExpression();f.clear();if(this.aApplicationFilter)f.addUI5FilterConditions(this.aApplicationFilter);if(this.aControlFilter)f.addUI5FilterConditions(this.aControlFilter);a.setResultPageBoundaries(1,1);a.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(A._requestType.totalSizeQuery),oAnalyticalQueryRequest:a}};A.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,l,n){var p=function(G,c){if(G.groupId_Missing==null){q.sap.log.fatal("missing group Id not present");return f}var d=t._getGroupIdComponents(G.groupId_Missing);var e=d.length;if(e>c){q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return f}var z=[];for(var i=0;i<e;i++){var B=t.aAggregationLevel[i];var V=d[i];var y=t._getFilterOperatorMatchingPropertySortOrder(B);z[i]=new sap.ui.model.Filter(B,y,V)}var D=null;if(G.startIndex_Missing>0){var E=t.mKey[G.groupId_Missing][G.startIndex_Missing-1];var H=t.oModel.getObject("/"+E);var I=t.aAggregationLevel[e];var J=H[I];D=new sap.ui.model.Filter(I,t._getFilterOperatorMatchingPropertySortOrder(I,false),J)}var f=[];for(var L=0;L<c;L++){var K=[];var N=Math.min(e,L+1);for(var O=0;O<N;O++){var Q=[];var U=Math.min(e,O+1);var W=G.startIndex_Missing>0;for(var X=0;X<U;X++){var Y=new sap.ui.model.Filter("x",sap.ui.model.FilterOperator.EQ,"x");Y=q.extend(true,Y,z[X]);if(U>1&&X<U-1)Y.sOperator=sap.ui.model.FilterOperator.EQ;if(X==e-1&&L>e-1&&!W){if(Y.sOperator==sap.ui.model.FilterOperator.GT)Y.sOperator=sap.ui.model.FilterOperator.GE;else Y.sOperator=sap.ui.model.FilterOperator.LE}Q.push(Y)}if(Q.length>0){K.push(new sap.ui.model.Filter(Q,true));if(L>e-1&&O==e-1&&W){var Z=[];for(var i=0;i<Q.length;i++){var $=new sap.ui.model.Filter("x",sap.ui.model.FilterOperator.EQ,"x");$=q.extend(true,$,Q[i]);Z.push($)}Z[e-1].sOperator=sap.ui.model.FilterOperator.EQ;Z.push(D);K.push(new sap.ui.model.Filter(Z,true));break}}}if(K.length>0)f[L]=new sap.ui.model.Filter(K,false);else f[L]=null}return f};var a=function(r,g,L,z,s,l,B,U){var D=[];var E=t.iAnalyticalInfoVersionNumber;var H=new o.QueryResultRequest(t.oAnalyticalQueryResult);H.setResourcePath(t._getResourcePath());H.getSortExpression().clear();var I=0,J=-1;I=J=L-1;var K=0;for(var i=0,N=0;i<I;N++){if(t.oDimensionDetailsSet[t.aMaxAggregationLevel[N]].grouped==false){++K}else{++i}}I=J=I+K;if(t.aMaxAggregationLevel.length>0){while(t.oDimensionDetailsSet[t.aMaxAggregationLevel[J]].grouped==false){if(++J==t.aMaxAggregationLevel.length){break}}}var O=J>=t.aMaxAggregationLevel.length-1;var Q=t.aMaxAggregationLevel.slice(0,J+1);H.setAggregationLevel(Q);for(var i=0;i<Q.length;i++){var V=t.oDimensionDetailsSet[Q[i]];var W=(V.keyPropertyName!=undefined);var X=(V.textPropertyName!=undefined);H.includeDimensionKeyTextAttributes(V.name,true,X,V.aAttributeName);if(V.grouped){H.getSortExpression().addSorter(Q[i],o.SortOrder.Ascending)}}var Y=H.getFilterExpression();Y.clear();if(t.aApplicationFilter)Y.addUI5FilterConditions(t.aApplicationFilter);if(t.aControlFilter)Y.addUI5FilterConditions(t.aControlFilter);Y.addUI5FilterConditions(z);var Z;var $;var _;var a1;var b1=new Array();H.setMeasures(t.aMeasureName);for(var c1 in t.oMeasureDetailsSet){a1=t.oMeasureDetailsSet[c1];if(!O&&t.mAnalyticalInfoByProperty[c1].total==false){Z=false;$=false;_=false}else{Z=(a1.rawValuePropertyName!=undefined);$=(a1.formattedValuePropertyName!=undefined);_=(a1.unitPropertyName!=undefined);if(_){if(b1.indexOf(a1.unitPropertyName)==-1){b1.push(a1.unitPropertyName)}}}H.includeMeasureRawFormattedValueUnit(a1.name,Z,$,_)}for(var i in Q){var d1;if((d1=b1.indexOf(Q[i]))!=-1)b1.splice(d1,1)}var e1=H.getSortExpression();for(var i=0;i<t.aSorter.length;i++){if(t.aSorter[i])e1.addSorter(t.aSorter[i].sPath,t.aSorter[i].bDescending?o.SortOrder.Descending:o.SortOrder.Ascending)}if(l==0)q.sap.log.fatal("unhandled case: load 0 entities of sub group");var f1=s;if(!U)f1=0;H.setResultPageBoundaries(f1+1,f1+l);return{iRequestType:r,sRequestId:t._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:L}),oAnalyticalQueryRequest:H,iLevel:L,aSelectedUnitPropertyName:b1,aAggregationLevel:Q,bIsFlatListRequest:O,bIsLeafGroupsRequest:O,iStartIndex:s,iLength:l,bAvoidLengthUpdate:B}};var t=this;var b=[];var R=[];if(G&&this.bUseAcceleratedAutoExpand){var c=this._getGroupIdLevel(g)+n+1;var d=t._getGroupIdComponents(G.groupId_Missing);var e=d.length;var f=p(G,c);for(var L=1;L<=c;L++){var s;if(L>=e+2)s=0;else if(L==e+1)s=G.startIndex_Missing;else if(e>0){var h;if(L==e)h=G.groupId_Missing;else h=this._getGroupIdAncestors(G.groupId_Missing,-(e-L))[0];var j=this._getGroupIdAncestors(G.groupId_Missing,-(e-L+1))[0];if(!j)q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+L);var s=this.mKey[j].indexOf(this.mOwnKey[h]);if(s==-1)q.sap.log.fatal("failed to determine position of value "+h+" in group "+j);s++}var k=l>L?Math.ceil((l-L)/(c-L+1)):l;var m=f[L-1]?[f[L-1]]:[];var u=a(A._requestType.levelMembersQuery,g,L,m,s,k,false,false);b.push(u);R.push(this._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:L}))}}else{var M=this._getGroupIdLevel(g)+1;var c=M+n;var m=[];var v=this._getGroupIdComponents(g);for(var i=0;i<v.length;i++)m.push(new sap.ui.model.Filter(this.aAggregationLevel[i],sap.ui.model.FilterOperator.EQ,v[i]));var w=false;if(G){var P=this.aAggregationLevel[v.length];var x=this._getGroupIdComponents(G.groupId_Missing)[v.length];if(x){var y=this._getFilterOperatorMatchingPropertySortOrder(P,true);m.push(new sap.ui.model.Filter(P,y,x));w=true}}for(var L=M;L<=c;L++){var k=l>L?Math.ceil((l-L)/(c-L+1)):l;var u=a(A._requestType.levelMembersQuery,g,L,m,0,k,L==M?w:false,true);b.push(u);R.push(this._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:L}))}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:b,sGroupId:g,iLength:l}};A.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var a=m+n;var r=[];for(var l=m;l<=a;l++){r.push(this._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:l}))}return r};A.prototype._getQueryODataRequestOptions=function(a){var s=a.getURIQueryOptionValue("$select");var f=a.getURIQueryOptionValue("$filter");var O=a.getURIQueryOptionValue("$orderby");var b=a.getURIQueryOptionValue("$skip");var t=a.getURIQueryOptionValue("$top");var i=a.getURIQueryOptionValue("$inlinecount");if(this.mParameters["filter"])f+="and ("+this.mParameters["filter"]+")";var p=[];if(s)p.push("$select="+s);if(f)p.push("$filter="+f);if(O)p.push("$orderby="+O);if(b)p.push("$skip="+b);if(t)p.push("$top="+t);if(i)p.push("$inlinecount="+i);return p};A.prototype._executeBatchRequest=function(r){var c=this.iAnalyticalInfoVersionNumber;var t=this;var b=[],e=[];for(var i=-1,R;R=r[++i];){var a=R.oAnalyticalQueryRequest,g=R.sGroupId;if(a.getURIQueryOptionValue("$select")==null){this.fireDataRequested();var E=this.getModel().getContext("/artificialRootContent");g=null;this.mLength[g]=1;this.mFinalLength[g]=true;this.mKey[g]=["artificialRootContent"];this.bNeedsUpdate=true;var t=this;if(r.length==1){setTimeout(function(){t.fireDataReceived()})}this.bArtificalRootContext=true;continue}var p=a.getURIToQueryResultEntries();if(p.indexOf("/")==0)p=p.substring(1);if(!this._isRequestPending(R.sRequestId)){this._registerNewRequest(R.sRequestId);b.push(this.oModel.createBatchOperation(p.replace(/\ /g,"%20"),"GET"));e.push(R)}}q.sap.log.debug("AnalyticalBinding: executing batch request with "+e.length+" operations");var d=this._getIdForNewRequestHandle();if(b.length>0){this.oModel.addBatchReadOperations(b);this.fireDataRequested();var f=this.oModel.submitBatch(s,h,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});this._registerNewRequestHandle(d,f)}function s(D,j){t._deregisterHandleOfCompletedRequest(d);if(e.length!=D.__batchResponses.length)q.sap.log.fatal("assertion failed: received "+D.__batchResponses.length+" responses for "+e.length+" read operations in the batch request");if(c!=t.iAnalyticalInfoVersionNumber){for(var i=-1,k;k=e[++i].sRequestId;){t._deregisterCompletedRequest(k);t._cleanupGroupingForCompletedRequest(k)}return}for(var i=0;i<D.__batchResponses.length;i++){if(D.__batchResponses[i].data!=undefined){switch(e[i].iRequestType){case A._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(e[i],D.__batchResponses[i].data);break;case A._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(e[i],D.__batchResponses[i].data);break;case A._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(e[i],D.__batchResponses[i].data);break;default:q.sap.log.fatal("invalid request type "+e[i].iRequestType);continue}}t._deregisterCompletedRequest(e[i].sRequestId);t._cleanupGroupingForCompletedRequest(e[i].sRequestId)}var O=true;var B=t.oModel._getBatchErrors(D);if(B.length>0)O=false;t.oModel.fireRequestCompleted({url:j.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:t.oModel._handleError(B[0])});if(O){t.oModel.checkUpdate()}t.fireDataReceived()}function h(j){t._deregisterHandleOfCompletedRequest(d);for(var i=-1,k;k=e[++i];){t._deregisterCompletedRequest(k.sRequestId);t._cleanupGroupingForCompletedRequest(k.sRequestId)}if(c!=t.iAnalyticalInfoVersionNumber){return}t.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:t.oModel._handleError(j)});t.oModel.fireRequestFailed(t.oModel._handleError(j));t.fireDataReceived()}};A.prototype._executeQueryRequest=function(r){if(r.iRequestType==A._requestType.groupMembersAutoExpansionQuery){for(var i=-1,a;a=r.aGroupMembersAutoExpansionRequestDetails[++i];){this._executeQueryRequest(a)}return}var c=this.iAnalyticalInfoVersionNumber;var a=r.oAnalyticalQueryRequest,g=r.sGroupId;var p=a.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(a);var t=this;if(a.getURIQueryOptionValue("$select")==null){this.fireDataRequested();var e=this.getModel().getContext("/artificialRootContent");g=null;this.mLength[g]=1;this.mFinalLength[g]=true;this.mKey[g]=["artificialRootContent"];this.bNeedsUpdate=true;var t=this;setTimeout(function(){if(t._cleanupGroupingForCompletedRequest(r.sRequestId))t.fireDataReceived()});this.bArtificalRootContext=true;return}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var i=0;i<P.length;i++)P[i]=P[i].replace(/\ /g,"%20");q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();this.oModel._loadData(p,P,s,E,false,u,f);function s(d){t._deregisterHandleOfCompletedRequest(R);if(c!=t.iAnalyticalInfoVersionNumber){t._deregisterCompletedRequest(r.sRequestId);return}switch(r.iRequestType){case A._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(r,d);break;case A._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(r,d);break;case A._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(r,d);break;default:q.sap.log.fatal("invalid request type "+r.iRequestType);break}t._deregisterCompletedRequest(r.sRequestId)}function f(){if(c!=t.iAnalyticalInfoVersionNumber){return}if(t._cleanupGroupingForCompletedRequest(r.sRequestId))t.fireDataReceived()}function E(d){t._deregisterHandleOfCompletedRequest(R);t._deregisterCompletedRequest(r.sRequestId);t._cleanupGroupingForCompletedRequest(r.sRequestId);if(c!=t.iAnalyticalInfoVersionNumber){return}t.fireDataReceived()}function u(b){t._registerNewRequestHandle(R,b)}};A.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests()};A.prototype._processGroupMembersQueryResponse=function(r,d){var g=r.sGroupId,s=r.aSelectedUnitPropertyName,a=r.aAggregationLevel,b=r.iStartIndex,l=r.iLength,G=g==null?0:this._getGroupIdLevel(g)+1;if(!this.mKey[g])this.mKey[g]=[];var K=this.mKey[g];var c=b;var u=(s.length>0);var p=null,D=null;var f=-1;var e=0;var h=null;for(var i=0;i<d.results.length;i++){var E=d.results[i];if(u){D="";for(var j=0;j<a.length;j++){D+=E[a[j]]+"|"}if(p==D){if(f==-1)f=i-1;var m=-1,P=d.results[i-1];for(var k=0;k<s.length;k++){if(P[s[k]]!=E[s[k]]){m=k;break}}if(m==-1)q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(i-1)+" and "+i)}if((p!=D||i==d.results.length-1)&&f!=-1){var M=q.extend(true,{},d.results[f]);var n=this.oModel._getObject("/"+this.oModel._getKey(d.results[f]));for(var k=0;k<s.length;k++)M[s[k]]="*";for(var t in this.oMeasureDetailsSet){var v=this.oMeasureDetailsSet[t];if(!r.bIsFlatListRequest&&!this.mAnalyticalInfoByProperty[t].total){if(v.rawValuePropertyName!=undefined)M[v.rawValuePropertyName]=undefined;if(v.formattedValuePropertyName!=undefined)M[v.formattedValuePropertyName]=undefined}else{if(v.rawValuePropertyName!=undefined)M[v.rawValuePropertyName]=null;if(v.formattedValuePropertyName!=undefined)M[v.formattedValuePropertyName]="*"}}var w="";if(h==null)h=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();for(var k=0;k<h.length;k++){var x=M[h[k]];w+=(x===undefined?"":x)+","}M.__metadata.uri=w+"-multiple-units-not-dereferencable";delete M.__metadata["self"];delete M.__metadata["self_link_extensions"];M["^~volatile"]=true;this.oModel._importData(M,{});var y=this.oModel._getKey(M);this.oModel.getContext('/'+y)["_volatile"]=true;K[c-1]=y;if(i==d.results.length-1&&p==D)e+=i-f;else e+=i-f-1;f=-1;if(p!=D)K[c++]=this.oModel._getKey(E)}else if(p!=D)K[c++]=this.oModel._getKey(E);p=D}else K[c++]=this.oModel._getKey(E);if(!r.bIsLeafGroupsRequest){var z=this._getGroupIdFromContext(this.oModel.getContext('/'+K[c-1]),G);this.mOwnKey[z]=K[c-1]}}if(!r.bAvoidLengthUpdate){if(d.__count){this.mLength[g]=parseInt(d.__count,10)-e;this.mFinalLength[g]=true;if(r.bIsFlatListRequest)this.iTotalSize=d.__count}if(this.mLength[g]<b+d.results.length){this.mLength[g]=b+(d.results.length-e);this.mFinalLength[g]=false}if((d.results.length-e)<l||l===undefined){this.mLength[g]=b+(d.results.length-e);this.mFinalLength[g]=true}if(d.results.length==0){this.mLength[g]=0;this.mFinalLength[g]=true}}this.bNeedsUpdate=true};A.prototype._processTotalSizeQueryResponse=function(r,d){var a=r.oAnalyticalQueryRequest;if(d.__count==undefined){q.sap.log.fatal("missing entity count in query result");return}this.iTotalSize=d.__count};A.prototype._processLevelMembersQueryResponse=function(r,d){var p=function(c,I){var g={iRequestType:A._requestType.groupMembersQuery,sRequestId:t._getRequestId(A._requestType.groupMembersQuery,{groupId:P}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:P,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:c?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(c&&r.iStartIndex>0&&(t.mKey[g.sGroupId]===undefined||t.mKey[g.sGroupId][r.iStartIndex-1]===undefined)){var s=t._getParentGroupId(g.sGroupId);var h=t.mKey[s].indexOf(t.mOwnKey[g.sGroupId]);if(h==-1)q.sap.log.fatal("assertion failed: failed to determine position of "+g.sGroupId+" in group "+s);if(h>0&&t.mKey[s][h-1]!==undefined){var j=t.mKey[s][h-1];var k=t._getGroupIdFromContext(t.oModel.getContext('/'+j),t._getGroupIdLevel(g.sGroupId));t.mFinalLength[k]=true;g.iStartIndex=0}}if(I){g.iLength=0;t.mLength[g.sGroupId]=0}var l=q.extend(true,{},d);l.results=b;t._processGroupMembersQueryResponse(g,l)};var a=r.oAnalyticalQueryRequest,t=this;if(d.results.length==0)return;var P=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(d.results[0])),r.iLevel-1);var b=[];var c=true;for(var i=0;i<d.results.length;i++){var e=d.results[i];var f=this.oModel.getContext("/"+this.oModel._getKey(d.results[i]));var s=this._getGroupIdFromContext(f,r.iLevel-1);if(P==s){b.push(e);if(i<d.results.length-1)continue}p(c,d.results.length==r.iLength&&i==d.results.length-1);c=false;if(P!=s)b=[e];P=s}if(b.length==1)p(c,d.results.length==r.iLength)};A.prototype._getLoadedContextsForGroup=function(g,s,l){var c=[],a,k=this.mKey[g],K;if(!k)return c;if(!s)s=0;if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]&&this.mLength[g]<l)l=this.mLength[g]}for(var i=s;i<s+l;i++){K=k[i];if(!K){break}a=this.oModel.getContext('/'+K);c.push(a)}return c};A.prototype._calculateRequiredGroupSection=function(g,s,l,t,c){var L=false,a,b,p,P,r,d={},k=this.mKey[g],K;b=s;a=0;if(!k){P=s;p=s+l}else{for(var i=s-1;i>=Math.max(s-t,0);i--){K=k[i];if(!K){P=i+1;break}}for(var j=s+l;j<s+l+t;j++){K=k[j];if(!K){p=j;break}}}r=s-P;if(P&&s>t&&r<t){if(c.length!=l)b=s-t;else b=P-t;a=t}if(b==s)b+=c.length;if(c.length!=l)a+=l-c.length;r=p-s-l;if(r==0)a+=t;if(p&&r<t&&r>0){if(b>=s){b=p;a+=t}}if(this.mFinalLength[g]&&this.mLength[g]<(a+b))a=this.mLength[g]-b;d.startIndex=b;d.length=a;return d};A.prototype._calculateRequiredGroupExpansion=function(g,a,s,l){var n={groupId_Missing:null,length_Missing:0};var c=function(g,a,s,l){var L=t._getGroupIdLevel(g);if(L==a){var j=t._getLoadedContextsForGroup(g,s,l);var k=s+j.length-1;if(j.length>=l)return n;else{if(t.mFinalLength[g]){if(j.length>=t.mLength[g])return{groupId_Missing:null,length_Missing:l-j.length};else return{groupId_Missing:g,startIndex_Missing:k+1,length_Missing:l-j.length}}else return{groupId_Missing:g,startIndex_Missing:k+1,length_Missing:l-j.length}}}var j=t._getLoadedContextsForGroup(g,s,l);var b=l,k=s+j.length-1;for(var i=-1,m;m=j[++i];){b--;var G=c(t._getGroupIdFromContext(m,L+1),a,0,b);if(G.groupId_Missing==null){if(G.length_Missing==0)return G;else b=G.length_Missing}else{return G}if(b==0)break}if(t.mFinalLength[g]||b==0)return{groupId_Missing:null,length_Missing:b};else return{groupId_Missing:g,startIndex_Missing:k+1,length_Missing:b}};var t=this;var L=this._getGroupIdLevel(g);if(L==a+1){g=this._getParentGroupId(g);--L}if(g==null||L>a)return n;var b=l,d=s;while(g!=null){var G=c(g,a,d,b);if(G.groupId_Missing!=null)return G;else if(G.length_Missing==0)return G;else{var f=false;while(!f){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break}var e=this.mOwnKey[g];if(!e){q.sap.log.fatal("assertion failed: entitykey for group w/ ID "+g+" not available");return n}var h=this.mKey[p].indexOf(e);if(h==-1){q.sap.log.fatal("assertion failed: group w/ ID "+g+" not found in members of parent w/ ID "+p);return n}if(h==this.mKey[p].length-1){if(this.mFinalLength[p]){g=p;--L;continue}else{return{groupId_Missing:p,startIndex_Missing:h+1,length_Missing:b}}}else{e=this.mKey[p][h+1];g=this._getGroupIdFromContext(this.oModel.getContext('/'+e),L);f=true}}d=0;b=G.length_Missing}}return{groupId_Missing:null,length_Missing:b}};A.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath};A.prototype._getEntitySet=function(){var e=this.sEntitySetName;var b=this.getContext();if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results"}}return e};A.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?o.SortOrder.Descending:o.SortOrder.Ascending}}return null};A.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,w){var f=sap.ui.model.FilterOperator.GT;switch(this._getEffectiveSortOrder(p)){case o.SortOrder.Ascending:if(w)f=sap.ui.model.FilterOperator.GE;else f=sap.ui.model.FilterOperator.GT;break;case o.SortOrder.Descending:if(w)f=sap.ui.model.FilterOperator.LE;else f=sap.ui.model.FilterOperator.LT;break}return f};A.prototype._convertDeprecatedFilterObjects=function(f){if(!f)return f;for(var i=0,l=f.length;i<l;i++){if(sap.ui.model.odata&&typeof sap.ui.model.odata.Filter==="function"&&f[i]instanceof sap.ui.model.odata.Filter)f[i]=f[i].convert()}return f};A.prototype._getGroupIdFromContext=function(c,l){if(!c){return null}var g="/";var d=null;if(l>this.aAggregationLevel.length)q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");for(var i=0;i<l;i++){d=c.getProperty(this.aAggregationLevel[i]);if(d!=null){g+=encodeURIComponent(d)+"/"}else{g+="@/"}}return g};A.prototype._getGroupIdLevel=function(g){if(g==null){q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1}return g.split("/").length-2};A.prototype._getGroupIdComponents=function(g){if(g==null)return null;var G=g.split("/");var d=new Array();for(var i=1;i<G.length-1;i++){if(G[i]=="@")d[i-1]=null;else d[i-1]=decodeURIComponent(G[i])}return d};A.prototype._getGroupIdAncestors=function(g,n){if(!n)return[];if(g==null){q.sap.log.fatal("group ID null does not have ancestors");return[]}if(g=="/")if(Math.abs(n)==1)return[null];else{q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[]}var G=g.split("/");var a=new Array(),s="";var f=0,t=G.length-3;if(n>0)if(n-1>t)q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);else t=n-1;else if(-(n+1)>t)q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);else{f=t+1+n;for(var i=0;i<f;i++){s+=G[i]+"/"}}for(var i=f;i<=t;i++){s+=G[i]+"/";a.push(s)}return a};A.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0]};A.prototype._removeDuplicatesFromStringArray=function(a){var t={};for(var i=0;i<a.length;i++)t[a[i]]=true;var u=[];for(var s in t)u.push(s);return u};A.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined)this.oPendingRequestHandle=[];for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined)return i}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1};A.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined)q.sap.log.fatal("request handle ID already in use");this.oPendingRequestHandle[r]=R};A.prototype._deregisterHandleOfCompletedRequest=function(r){if(this.oPendingRequestHandle[r]===undefined)q.sap.log.fatal("no handle found for this request ID");this.oPendingRequestHandle[r]=undefined};A.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){this.oPendingRequestHandle[i]!==undefined&&this.oPendingRequestHandle[i].abort()}this.oPendingRequestHandle=[]};A.prototype._getRequestId=function(r,p){switch(r){case A._requestType.groupMembersQuery:if(p.groupId===undefined)q.sap.log.fatal("missing group ID");var g=p.groupId;return A._requestType.groupMembersQuery+(g==null?"":g);case A._requestType.levelMembersQuery:if(p.level===undefined)q.sap.log.fatal("missing level");if(p.groupId===undefined)q.sap.log.fatal("missing groupId");return""+A._requestType.levelMembersQuery+p.level+(this.bUseAcceleratedAutoExpand==true?"":p.groupId);case A._requestType.totalSizeQuery:return A._requestType.totalSizeQuery;default:q.sap.log.fatal("invalid request type "+r);return-1}};A.prototype._registerNewRequest=function(r){if(r==undefined||r==""){q.sap.log.fatal("missing request ID");return}if(!this.oPendingRequests[r])this.oPendingRequests[r]=1;else++this.oPendingRequests[r]};A.prototype._considerRequestGrouping=function(r){for(var i=-1,R;R=r[++i];){if(this.oGroupedRequests[R]===undefined)this.oGroupedRequests[R]={};var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++)g[r[j]]=true}};A.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0};A.prototype._deregisterCompletedRequest=function(r){if(!this.oPendingRequests[r])q.sap.log.fatal("assertion failed: there is no pending request ID "+r);if(this.oPendingRequests[r]==1)delete this.oPendingRequests[r];else--this.oPendingRequests[r]};A.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r))return false;var g=true;if(this.oGroupedRequests[r]!=undefined){for(var O in this.oGroupedRequests[r]){if(this.oPendingRequests[O]){g=false;break}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r)this._cleanupGroupingForCompletedRequest(O)}}return g};A.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={}};A.prototype.resetData=function(c){if(c){var p=c.getPath();delete this.mKey[p];delete this.mOwnKey[p];delete this.mLength[p];delete this.mFinalLength[p]}else{this.mKey={};this.mOwnKey={};this.mLength={};this.mFinalLength={}}};A.prototype.refresh=function(f,c,e){var b=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e))b=true}if(c&&!b){q.each(this.mKey,function(i,n){q.each(n,function(i,k){if(k in c){b=true;return false}});if(b)return false})}if(!c&&!e){b=true}}if(f||b){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh})}};A.prototype.checkUpdate=function(f,c){var b=false;if(!f){if(this.bNeedsUpdate||!c){b=true}else{q.each(this.mKey,function(i,n){q.each(n,function(i,k){if(k in c){b=true;return false}});if(b)return false})}}if(f||b){this.bNeedsUpdate=false;this._fireChange()}};A.prototype.getDownloadUrl=function(f){var a=new o.QueryResultRequest(this.oAnalyticalQueryResult);a.setResourcePath(this._getResourcePath());var s=[];var b=[];for(var d in this.oDimensionDetailsSet)s.push(d);a.setAggregationLevel(s);for(var d in this.oDimensionDetailsSet){var D=this.oDimensionDetailsSet[d];var I=(D.keyPropertyName!=undefined);var c=(D.textPropertyName!=undefined);a.includeDimensionKeyTextAttributes(D.name,true,c,D.aAttributeName)}for(var m in this.oMeasureDetailsSet)b.push(m);a.setMeasures(b);for(var m in this.oMeasureDetailsSet){var M=this.oMeasureDetailsSet[m];var e=(M.rawValuePropertyName!=undefined);var g=(M.formattedValuePropertyName!=undefined);var h=(M.unitPropertyName!=undefined);a.includeMeasureRawFormattedValueUnit(M.name,e,g,h)}var j=a.getSortExpression();j.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){j.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?o.SortOrder.Descending:o.SortOrder.Ascending)}}var k=a.getFilterExpression();k.clear();if(this.aApplicationFilter){k.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){k.addUI5FilterConditions(this.aControlFilter)}var p=a.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(a);for(var i=0,l=P.length;i<l;i++){if(/^\$select/i.test(P[i])){P.splice(i,1);break}}var v=[];for(var i=0,l=this.aAnalyticalInfo.length;i<l;i++){var n=this.aAnalyticalInfo[i];if(n.visible){v.push(n.name)}}if(v.length>0){P.push("$select="+v.join(","))}if(f){P.splice(0,0,"$format="+encodeURIComponent(f))}if(p){return this.oModel._createRequestUrl(p,null,P)}};return A},true);
