/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/EventProvider'],function(q,E){"use strict";var O=sap.ui.base.EventProvider.extend("sap.ui.model.odata.ODataAnnotations",{constructor:function(a,m,p){"use strict";E.apply(this,arguments);this.oMetadata=m;this.oAnnotations=null;this.bLoaded=false;this.bAsync=p&&p.async;this.xPath=null;this.aAnnotationURI=a;this.error=null;this.bValidXML=true;this.oRequestHandles=[];this.oLoadEvent=null;this.oFailedEvent=null;this.xmlCompatVersion=false;if(a){this.loadXML();if(!this.bAsync){if(this.error){q.sap.log.error("OData annotations could not be loaded: "+this.error.message)}}}},metadata:{publicMethods:["parse","getAnnotationsData","attachFailed","detachAnnoationsFailed","attachLoaded","detachLoaded"]}});O.prototype.getAnnotationsData=function(){return this.oAnnotations};O.prototype.isLoaded=function(){return this.bLoaded};O.prototype.fireLoaded=function(a){this.fireEvent("loaded",a);return this};O.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this};O.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this};O.prototype.fireFailed=function(a){this.fireEvent("failed",a);return this};O.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this};O.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this};O.prototype._parseAliases=function(x,a,A){var r=this.xPath.selectNodes(x,"//edmx:Reference",x);for(var i=0;i<r.length;i+=1){var b=this.xPath.nextNode(r,i);var c=this.xPath.selectNodes(x,"./edmx:Include",b);if(c&&c.length>0){var d=this.xPath.nextNode(c,0);if(d.getAttribute("Alias")){A[d.getAttribute("Alias")]=d.getAttribute("Namespace")}else{A[d.getAttribute("Namespace")]=d.getAttribute("Namespace")}}var e=this.xPath.selectNodes(x,"./edmx:IncludeAnnotations",b);if(e.length>0){for(var j=0;j<e.length;j+=1){var f=this.xPath.nextNode(e,j);if(f.getAttribute("TargetNamespace")){var s=f.getAttribute("TargetNamespace");if(!a[s]){a[s]={}}a[s][f.getAttribute("TermNamespace")]=b.getAttribute("Uri")}else{a[f.getAttribute("TermNamespace")]=b.getAttribute("Uri")}}}}};O.prototype.parse=function(x){var m={},s,S={},a,A={},t=this,b,T,c,d,M,e,f,g,h,j,p,k,l,n,o,r,u,v,w,y,z,B,C;var D={};this.xPath=this.getXPath();this.oServiceMetadata=this.oMetadata.getServiceMetadata();x=this.xPath.setNameSpace(x);s=this.xPath.selectNodes(x,"//d:Schema",x);for(var i=0;i<s.length;i+=1){a=this.xPath.nextNode(s,i);S.Alias=a.getAttribute("Alias");S.Namespace=a.getAttribute("Namespace")}this._parseAliases(x,A,D);if(A){m.annotationReferences=A}m.aliasDefinitions=D;b=this.xPath.selectNodes(x,"//d:Term",x);if(b.length>0){T={};for(var F=0;F<b.length;F+=1){c=this.xPath.nextNode(b,F);d=this.replaceWithAlias(c.getAttribute("Type"),D);T["@"+S.Alias+"."+c.getAttribute("Name")]=d}m.termDefinitions=T}M=this.getAllPropertiesMetadata(this.oServiceMetadata);if(M.extensions){m.propertyExtensions=M.extensions}e=this.xPath.selectNodes(x,"//d:Annotations ",x);for(var F=0;F<e.length;F+=1){f=this.xPath.nextNode(e,F);if(f.hasChildNodes()===false){continue}g=f.getAttribute("Target");h=g.split(".")[0];if(h&&D[h]){g=g.replace(new RegExp(h,""),D[h])}j=g;p=null;if(g.indexOf("/")>0){j=g.split("/")[0];p=g.replace(j+"/","")}if(!m[j]){m[j]={}}if(p){if(!m.propertyAnnotations){m.propertyAnnotations={}}if(!m.propertyAnnotations[j]){m.propertyAnnotations[j]={}}m.propertyAnnotations[j][p]={};k=this.xPath.selectNodes(x,"./d:Annotation",f);for(var G=0;G<k.length;G+=1){l=this.xPath.nextNode(k,G);if(l.hasChildNodes()===false){n=this.replaceWithAlias(l.getAttribute("Term"),D);m.propertyAnnotations[j][p][n]=this.getPropertyValueAttributes(l,D)}}}else{o=j.replace(D[h],h);k=this.xPath.selectNodes(x,"./d:Annotation",f);for(var H=0;H<k.length;H+=1){l=this.xPath.nextNode(k,H);r=l.getAttribute("Qualifier");u=this.replaceWithAlias(l.getAttribute("Term"),D);if(r){u+="#"+r}v=this.getPropertyValue(x,l,o,D);v=this.setEdmTypes(v,M.types,j,S);m[j][u]=v}w=this.xPath.selectNodes(x,"//d:Annotations[contains(@Target, '"+o+"')]//d:PropertyValue[contains(@Path, '/')]//@Path",x);for(i=0;i<w.length;i+=1){y=this.xPath.nextNode(w,i);z=y.value;if(m.propertyAnnotations){if(m.propertyAnnotations[j]){if(m.propertyAnnotations[j][z]){continue}}}B=z.split('/');if(this.isNavProperty(j,B[0],this.oServiceMetadata)){if(!m.expand){m.expand={}}if(!m.expand[j]){m.expand[j]={}}m.expand[j][B[0]]=B[0]}}C=this.xPath.selectNodes(x,"//d:Annotations[contains(@Target, '"+o+"')]//d:Path[contains(., '/')]",x);for(i=0;i<C.length;i+=1){y=this.xPath.nextNode(C,i);z=this.xPath.getNodeText(y);if(m.propertyAnnotations[j]){if(m.propertyAnnotations[j][z]){continue}}if(!m.expand){m.expand={}}if(!m.expand[j]){m.expand[j]={}}B=z.split('/');if(this.isNavProperty(j,B[0],this.oServiceMetadata)){if(!m.expand){m.expand={}}if(!m.expand[j]){m.expand[j]={}}m.expand[j][B[0]]=B[0]}}}}return m};O.prototype.getXPath=function(){var x={};if(this.xmlCompatVersion){x={setNameSpace:function(o){o.setProperty("SelectionNamespaces",'xmlns:edmx="http://docs.oasis-open.org/odata/ns/edmx" xmlns:d="http://docs.oasis-open.org/odata/ns/edm"');o.setProperty("SelectionLanguage","XPath");return o},selectNodes:function(o,x,i){return i.selectNodes(x)},nextNode:function(n){return n.nextNode()},getNodeText:function(n){return n.text}}}else{x={setNameSpace:function(o){return o},nsResolver:function(p){var n={"edmx":"http://docs.oasis-open.org/odata/ns/edmx","d":"http://docs.oasis-open.org/odata/ns/edm"};return n[p]||null},selectNodes:function(o,p,i){var a=o.evaluate(p,i,this.nsResolver,7,null);a.length=a.snapshotLength;return a},nextNode:function(n,i){return n.snapshotItem(i)},getNodeText:function(n){return n.textContent}}}return x};O.prototype.setXML=function(x,X,o){var d={success:function(){},error:function(){}};o=q.extend({},d,o);var t=this;var a=null;if(sap.ui.Device.browser.internet_explorer){a=new ActiveXObject("Microsoft.XMLDOM");a.loadXML(X);this.xmlCompatVersion=true}else if(x){a=x}else{a=new DOMParser().parseFromString(X,'application/xml')}if(a.getElementsByTagName("parsererror").length>0){o.error({xmlDoc:a});return false}else{if(q.isEmptyObject(this.oMetadata.getServiceMetadata())){this.oMetadata.attachLoaded(function(){var A=t.parse(a);if(A){o.success({annotations:A,xmlDoc:a})}else{o.error({xmlDoc:a})}})}else{var A=this.parse(a);if(A){o.success({annotations:A,xmlDoc:a})}else{o.error({xmlDoc:a})}}return true}};O.prototype.loadXML=function(){var t=this;if(!q.isArray(this.aAnnotationURI)){this.aAnnotationURI=[this.aAnnotationURI]}var l=this.aAnnotationURI.length;this.mLoaded={length:l};for(var i=0;i<l;++i){this.mLoaded[i]=false;var a={url:this.aAnnotationURI[i],async:this.bAsync};var h=(function(r){return function _handleFail(j,s){if(t.oRequestHandles[r]&&t.oRequestHandles[r].bSuppressErrorHandlerCall){return}t.oRequestHandles[r]=null;t.error={message:s,statusCode:j.statusCode,statusText:j.statusText,url:t.aAnnotationURI[r],responseText:j.responseText};if(!this.bAsync){t.oFailedEvent=q.sap.delayedCall(0,t,t.fireFailed,[t.error])}else{t.fireFailed(t.error)}}})(i);var H=(function(r){return function(d,T,j){t.oRequestHandles[r]=null;t.setXML(j.responseXML,j.responseText,{success:function(D){t.mLoaded[r]=D.annotations;t.checkAllLoaded()},error:function(D){t.mLoaded[r]=false;h(j,"Malformed XML document");t.checkAllLoaded()}})}})(i);this.oRequestHandles[i]=q.ajax(a).done(H).fail(h)}};O.prototype.checkAllLoaded=function(){var l=this.mLoaded.length;for(var i=0;i<l;++i){if(!this.mLoaded[i]){return}}this.oAnnotations={};for(var i=0;i<l;++i){q.extend(true,this.oAnnotations,this.mLoaded[i])}this.bLoaded=true;if(this.bAsync){this.fireLoaded({annotations:this.oAnnotations})}else{this.oLoadEvent=q.sap.delayedCall(0,this,this.fireLoaded,[{annotations:this.oAnnotations}])}};O.prototype.getAllPropertiesMetadata=function(m){var M={},P={},o={},b=false,n,e,c,a={},d={},f={},g=false,h,C,s,t,r,R;for(var i=m.dataServices.schema.length-1;i>=0;i-=1){M=m.dataServices.schema[i];if(M.entityType){n=M.namespace;e=M.entityType;c=M.complexType;for(var j in e){a=e[j];f={};if(a.hasStream&&a.hasStream==="true"){continue}for(var k in a.property){h=a.property[k];if(h.type.substring(0,n.length)===n){for(var l in c){if(c[l].name===h.type.substring(n.length+1)){for(k in c[l].property){C=c[l].property[k];d[c[l].name+"/"+C.name]=C.type}}}}else{s=h.name;t=h.type;for(var p in h.extensions){r=h.extensions[p];if((r.name==="display-format")&&(r.value==="Date")){t="Edm.Date"}else{g=true;if(!f[s]){f[s]={}}if(r.namespace&&!f[s][r.namespace]){f[s][r.namespace]={}}f[s][r.namespace][r.name]=r.value}}d[s]=t}}if(!P[n+"."+a.name]){P[n+"."+a.name]={}}P[n+"."+a.name]=d;if(g){if(!o[n+"."+a.name]){b=true}o[n+"."+a.name]={};o[n+"."+a.name]=f}}}}if(b){R={types:P,extensions:o}}else{R={types:P}}return R};O.prototype.setEdmTypes=function(p,P,t,s){var o,e='';for(var a in p){if(p[a]){o=p[a];if(o.Value&&o.Value.Path){e=this.getEdmType(o.Value.Path,P,t,s);if(e){p[a].EdmType=e}continue}if(o.Path){e=this.getEdmType(o.Path,P,t,s);if(e){p[a].EdmType=e}continue}if(o.Facets){p[a].Facets=this.setEdmTypes(o.Facets,P,t,s);continue}if(o.Data){p[a].Data=this.setEdmTypes(o.Data,P,t,s);continue}if(a==="Data"){p.Data=this.setEdmTypes(o,P,t,s);continue}if(o.Value&&o.Value.Apply){p[a].Value.Apply.Parameters=this.setEdmTypes(o.Value.Apply.Parameters,P,t,s);continue}if(o.Value&&o.Type&&(o.Type==="Path")){e=this.getEdmType(o.Value,P,t,s);if(e){p[a].EdmType=e}}}}return p};O.prototype.getEdmType=function(p,P,t,s){if((p.charAt(0)==="@")&&(p.indexOf(s.Alias)===1)){p=p.slice(s.Alias.length+2)}if(p.indexOf("/")>=0){if(P[p.slice(0,p.indexOf("/"))]){t=p.slice(0,p.indexOf("/"));p=p.slice(p.indexOf("/")+1)}}for(var a in P[t]){if(p===a){return P[t][a]}}};O.prototype.getPropertyValueAttributes=function(d,a){var b="",c="",i,p={};for(i=0;i<d.attributes.length;i+=1){if((d.attributes[i].name!=="Property")&&(d.attributes[i].name!=="Term")){b=d.attributes[i].name;c=d.attributes[i].value}}if(b.length>0){p[b]=this.replaceWithAlias(c,a)}return p};O.prototype.getSimpleNodeValue=function(x,d){var v={},s,a,p,b,c,e;if(d.hasChildNodes()){s=this.xPath.selectNodes(x,"./d:String",d);if(s.length>0){a=this.xPath.nextNode(s,0);v["String"]=this.xPath.getNodeText(a)}else{p=this.xPath.selectNodes(x,"./d:Path",d);if(p.length>0){b=this.xPath.nextNode(p,0);v["Path"]=this.xPath.getNodeText(b)}else{c=this.xPath.selectNodes(x,"./d:Apply",d);if(c.length>0){e=this.xPath.nextNode(c,0);v["Apply"]=this.getApplyFunctions(x,e,this.xPath)}}}}return v};O.prototype.getPropertyValue=function(x,d,t,a){var p={},r,b,n,c,e,u,f,g,P={},h,i,j,k,l;var m=this.getXPath();if(d.hasChildNodes()){r=this.xPath.selectNodes(x,"./d:Record | ./d:Collection/d:Record | ./d:Collection/d:If/d:Record",d);if(r.length){b=0;for(n=0;n<r.length;n+=1){c=this.xPath.nextNode(r,n);e=this.getPropertyValues(x,c,t,a);if(c.getAttribute("Type")){e["RecordType"]=this.replaceWithAlias(c.getAttribute("Type"),a)}if(b===0){if(c.nextElementSibling||(c.parentNode.nodeName==="Collection")||(c.parentNode.nodeName==="If")){p=[];p.push(e)}else{p=e}}else{p.push(e)}b+=1}}else{u=this.xPath.selectNodes(x,"./d:UrlRef",d);if(u.length>0){for(n=0;n<u.length;n+=1){f=this.xPath.nextNode(u,n);p["UrlRef"]=this.getSimpleNodeValue(x,f)}}else{u=this.xPath.selectNodes(x,"./d:Url",d);if(u.length>0){for(n=0;n<u.length;n+=1){f=this.xPath.nextNode(u,n);p["Url"]=this.getSimpleNodeValue(x,f)}}else{l=this.xPath.selectNodes(x,"./d:Collection/d:AnnotationPath | ./d:Collection/d:PropertyPath",d);if(l.length>0){p=[];for(n=0;n<l.length;n+=1){g=this.xPath.nextNode(l,n);P={};P[g.nodeName]=m.getNodeText(g);p.push(P)}}else{p=this.getPropertyValueAttributes(d,a);h=this.xPath.selectNodes(x,"./d:Annotation",d);i={};for(j=0;j<h.length;j+=1){i=this.xPath.nextNode(h,j);if(i.hasChildNodes()===false){k=this.replaceWithAlias(i.getAttribute("Term"),a);p[k]=this.getPropertyValueAttributes(i,a)}}}}}}}else{p=this.getPropertyValueAttributes(d,a)}return p};O.prototype.getPropertyValues=function(x,d,t,a){var p={},b={},c,n,e,f,g,h,i,j,k,l;c=this.xPath.selectNodes(x,"./d:Annotation",d);for(n=0;n<c.length;n+=1){b=this.xPath.nextNode(c,n);if(b.hasChildNodes()===false){e=this.replaceWithAlias(b.getAttribute("Term"),a);p[e]=this.getPropertyValueAttributes(b,a)}}f=this.xPath.selectNodes(x,"./d:PropertyValue",d);if(f.length>0){for(g=0;g<f.length;g+=1){h=this.xPath.nextNode(f,g);i=h.getAttribute("Property");p[i]=this.getPropertyValue(x,h,t,a);j=this.xPath.selectNodes(x,"./d:Apply",h);k=null;for(l=0;l<j.length;l+=1){k=this.xPath.nextNode(j,l);if(k){p[i]={};p[i]['Apply']=this.getApplyFunctions(x,k)}}}}else{p=this.getPropertyValue(x,d,t,a)}return p};O.prototype.getApplyFunctions=function(x,a){var b={},p,c=null,d=[],i;p=this.xPath.selectNodes(x,"./d:*",a);for(i=0;i<p.length;i+=1){c=this.xPath.nextNode(p,i);switch(c.nodeName){case"Apply":d.push({"Type":"Apply","Value":this.getApplyFunctions(x,c)});break;case"LabeledElement":d.push({"Name":c.getAttribute("Name"),"Value":this.getSimpleNodeValue(x,c)});break;default:d.push({"Type":c.nodeName,"Value":this.xPath.getNodeText(c)});break}}b['Name']=a.getAttribute('Function');b['Parameters']=d;return b};O.prototype.isNavProperty=function(e,p,m){var M,i,n,a,j,k;for(i=m.dataServices.schema.length-1;i>=0;i-=1){M=m.dataServices.schema[i];if(M.entityType){n=M.namespace+".";a=M.entityType;for(k=a.length-1;k>=0;k-=1){if(n+a[k].name===e&&a[k].navigationProperty){for(j=0;j<a[k].navigationProperty.length;j+=1){if(a[k].navigationProperty[j].name===p){return true}}}}}}return false};O.prototype.replaceWithAlias=function(v,a){for(var A in a){if(v.indexOf(A+".")>=0){v=v.replace(A+".",a[A]+".");return v}}return v};O.prototype.destroy=function(){for(var i=0;i<this.oRequestHandles.length;++i){if(this.oRequestHandles[i]){this.oRequestHandles[i].bSuppressErrorHandlerCall=true;this.oRequestHandles[i].abort();this.oRequestHandles[i]=null}}sap.ui.base.Object.prototype.destroy.apply(this,arguments);if(!!this.oLoadEvent){q.sap.clearDelayedCall(this.oLoadEvent)}if(!!this.oFailedEvent){q.sap.clearDelayedCall(this.oFailedEvent)}};return O},true);
