/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.unified.FileUploader");jQuery.sap.require("sap.ui.unified.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.unified.FileUploader",{metadata:{publicMethods:["upload","abort","clear"],library:"sap.ui.unified",properties:{"value":{type:"string",group:"Data",defaultValue:''},"enabled":{type:"boolean",group:"Behavior",defaultValue:true},"visible":{type:"boolean",group:"Behavior",defaultValue:true},"uploadUrl":{type:"sap.ui.core.URI",group:"Data",defaultValue:''},"name":{type:"string",group:"Data",defaultValue:null},"width":{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:''},"uploadOnChange":{type:"boolean",group:"Behavior",defaultValue:false},"additionalData":{type:"string",group:"Data",defaultValue:null},"sameFilenameAllowed":{type:"boolean",group:"Behavior",defaultValue:false},"buttonText":{type:"string",group:"Misc",defaultValue:null},"fileType":{type:"string[]",group:"Data",defaultValue:null},"multiple":{type:"boolean",group:"Behavior",defaultValue:false},"maximumFileSize":{type:"float",group:"Data",defaultValue:null},"mimeType":{type:"string[]",group:"Data",defaultValue:null},"sendXHR":{type:"boolean",group:"Behavior",defaultValue:false},"placeholder":{type:"string",group:"Appearance",defaultValue:null},"style":{type:"string",group:"Appearance",defaultValue:null},"buttonOnly":{type:"boolean",group:"Appearance",defaultValue:false},"useMultipart":{type:"boolean",group:"Behavior",defaultValue:true},"maximumFilenameLength":{type:"int",group:"Data",defaultValue:null},"valueState":{type:"sap.ui.core.ValueState",group:"Data",defaultValue:sap.ui.core.ValueState.None}},aggregations:{"parameters":{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"parameter"},"headerParameters":{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"headerParameter"}},events:{"change":{},"uploadComplete":{},"typeMissmatch":{},"fileSizeExceed":{},"fileAllowed":{},"uploadProgress":{},"uploadAborted":{},"filenameLengthExceed":{}}}});sap.ui.unified.FileUploader.M_EVENTS={'change':'change','uploadComplete':'uploadComplete','typeMissmatch':'typeMissmatch','fileSizeExceed':'fileSizeExceed','fileAllowed':'fileAllowed','uploadProgress':'uploadProgress','uploadAborted':'uploadAborted','filenameLengthExceed':'filenameLengthExceed'};
sap.ui.unified.FileUploader.prototype.init=function(){if(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==8){this.oFilePath=new sap.ui.commons.TextField(this.getId()+"-fu_input",{width:"225px"});this.oBrowse=new sap.ui.commons.Button({enabled:this.getEnabled(),text:"Browse..",width:"0px",height:"0px"})}else{this.oFilePath=sap.ui.unified.FileUploaderHelper.createTextField(this.getId()+"-fu_input");this.oBrowse=sap.ui.unified.FileUploaderHelper.createButton()}this.oFilePath.setParent(this);this.oBrowse.setParent(this);this.oFileUpload=null;this.oBrowse.setText(this.getBrowseText())};
sap.ui.unified.FileUploader.prototype.setButtonText=function(t){this.oBrowse.setText(t||this.getBrowseText());this.setProperty("buttonText",t,false);return this};
sap.ui.unified.FileUploader.prototype.getIdForLabel=function(){return this.oBrowse.getId()};
sap.ui.unified.FileUploader.prototype.setFileType=function(t){var T=this._convertTypesToArray(t);this.setProperty("fileType",T,false);return this};
sap.ui.unified.FileUploader.prototype.setMimeType=function(t){var T=this._convertTypesToArray(t);this.setProperty("mimeType",T,false);return this};
sap.ui.unified.FileUploader.prototype._convertTypesToArray=function(t){if(typeof t==="string"){if(t===""){return[]}else{return t.split(",")}}return t};
sap.ui.unified.FileUploader.prototype.exit=function(){this.oFilePath.destroy();this.oBrowse.destroy();if(this.oIFrameRef){jQuery(this.oIFrameRef).unbind();sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);this.oIFrameRef=null}};
sap.ui.unified.FileUploader.prototype.onBeforeRendering=function(){var s=sap.ui.getCore().getStaticAreaRef();jQuery(this.oFileUpload).appendTo(s);jQuery(this.oFileUpload).unbind()};
sap.ui.unified.FileUploader.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame();jQuery(this.oFileUpload).change(jQuery.proxy(this.handlechange,this));if((!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=8)){this.oBrowse.getDomRef().style.padding="0px";this.oBrowse.getDomRef().style.visibility="hidden";this.oFilePath.getDomRef().style.height="20px";this.oFilePath.getDomRef().style.visibility="hidden";jQuery(this.oFilePath.getDomRef()).removeClass('sapUiTfBrd')}else{this.oFilePath.$().attr("tabindex","-1");if((!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==9)){this.oBrowse.$().attr("tabindex","-1")}jQuery.sap.delayedCall(0,this,this._recalculateWidth)}};
sap.ui.unified.FileUploader.prototype._recalculateWidth=function(){if(this.getWidth()){if(this.getButtonOnly()){this.oBrowse.getDomRef().style.width=this.getWidth()}else{this._resizeDomElements()}}};
sap.ui.unified.FileUploader.prototype.getFocusDomRef=function(){return this.$("fu").get(0)};
sap.ui.unified.FileUploader.prototype._resizeDomElements=function(){var i=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var $=jQuery(this._oBrowseDomRef);var _=$.parent().outerWidth(true);this._oFilePathDomRef=this.oFilePath.getDomRef();var d=this._oFilePathDomRef;var w=this.getWidth();if(w.substr(-1)=="%"){while(d.id!=i){d.style.width="100%";d=d.parentNode}d.style.width=w}else{d.style.width=w;var a=jQuery(this._oFilePathDomRef);var b=a.outerWidth()-_;if(b<0){this.oFilePath.getDomRef().style.width="0px";if(!!!sap.ui.Device.browser.internet_explorer){this.oFileUpload.style.width=$.outerWidth(true)}}else{this.oFilePath.getDomRef().style.width=b+"px"}}};
sap.ui.unified.FileUploader.prototype.onresize=function(){this._recalculateWidth()};
sap.ui.unified.FileUploader.prototype.onThemeChanged=function(){this._recalculateWidth()};
sap.ui.unified.FileUploader.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);this.oFilePath.setEnabled(e);this.oBrowse.setEnabled(e);if(e){this.$("fu").removeAttr('disabled')}else{this.$("fu").attr('disabled','disabled')}return this};
sap.ui.unified.FileUploader.prototype.setValueState=function(v){this.setProperty("valueState",v);if(this.oFilePath.setValueState){this.oFilePath.setValueState(v)}return this};
sap.ui.unified.FileUploader.prototype.setUploadUrl=function(v,f){this.setProperty("uploadUrl",v,true);var $=this.$("fu_form");$.attr("action",this.getUploadUrl());return this};
sap.ui.unified.FileUploader.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);this.oFilePath.setPlaceholder(p);return this};
sap.ui.unified.FileUploader.prototype.setStyle=function(s){this.setProperty("style",s,true);if(s=="Transparent"){if(this.oBrowse.setLite){this.oBrowse.setLite(true)}else{this.oBrowse.setType("Transparent")}}else{if(this.oBrowse.setType){this.oBrowse.setType(s)}else{if(s=="Emphasized"){s="Emph"}this.oBrowse.setStyle(s)}}return this};
sap.ui.unified.FileUploader.prototype.setValue=function(v,f,s){var o=this.getValue();if((o!=v)||this.getSameFilenameAllowed()){var u=this.getUploadOnChange()&&v;this.setProperty("value",v,u);if(this.oFilePath){this.oFilePath.setValue(v);if(!(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==8)&&this.oFilePath.getFocusDomRef()&&!s){this.oFilePath.getFocusDomRef().focus()}}var F=this.getDomRef("fu_form"),a=this.getDomRef("fu_input-inner");if(this.oFileUpload&&F&&!v){F.reset();this.getDomRef("fu_input").value="";if(a){a.value=""}this.$("fu_data").val(this.getAdditionalData())}if(f){this.fireChange({id:this.getId(),newValue:v})}if(u){this.upload()}}return this};
sap.ui.unified.FileUploader.prototype.clear=function(){return this.setValue("",false,true)};
sap.ui.unified.FileUploader.prototype.onmouseover=function(){jQuery(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover')};
sap.ui.unified.FileUploader.prototype.onmouseout=function(){jQuery(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover')};
sap.ui.unified.FileUploader.prototype.onfocusin=function(){jQuery(this.oBrowse.getDomRef()).addClass('sapUiBtnStdFocus').attr("tabindex","-1");jQuery(this.oFilePath.getDomRef()).removeClass('sapUiTfFoc');this.focus()};
sap.ui.unified.FileUploader.prototype.onfocusout=function(){jQuery(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdFocus').attr("tabindex","0")};
sap.ui.unified.FileUploader.prototype.setAdditionalData=function(a){this.setProperty("additionalData",a,true);var A=this.getDomRef("fu_data");if(A){var a=this.getAdditionalData()||"";A.value=a}return this};
sap.ui.unified.FileUploader.prototype.upload=function(){var u=this.getDomRef("fu_form"),t=this;try{if(u){this._bUploading=true;if(this.getSendXHR()&&window.File){var f=jQuery.sap.domById(this.getId()+"-fu").files;if(f.length>0){var x=this._uploadXHR=new window.XMLHttpRequest();x.upload.addEventListener("progress",function(P){var o={lengthComputable:!!P.lengthComputable,loaded:P.loaded,total:P.total};t.fireUploadProgress(o)});x.upload.addEventListener("abort",function(A){t.fireUploadAborted()});x.open("POST",this.getUploadUrl(),true);if(this.getHeaderParameters()){var h=this.getHeaderParameters();for(var i=0;i<h.length;i++){var H=h[i].getName();var v=h[i].getValue();x.setRequestHeader(H,v)}}if(this.getUseMultipart()){var a=new window.FormData();var n=jQuery.sap.domById(this.getId()+"-fu").name;for(var i=0;i<f.length;i++){a.append(n,f[i])}a.append("_charset_","UTF-8");var d=jQuery.sap.domById(this.getId()+"-fu_data").name;if(this.getAdditionalData()){var D=this.getAdditionalData();a.append(d,D)}else{a.append(d,"")}if(this.getParameters()){var p=this.getParameters();for(var i=0;i<p.length;i++){var N=p[i].getName();var v=p[i].getValue();a.append(N,v)}}x.send(a)}else{x.send(f[0])}x.onreadystatechange=function(){var r;var R;var m={};var P;var b;var c;var s=x.readyState;var S=x.status;if(x.readyState==4){if(x.responseXML){r=x.responseXML.documentElement.textContent}R=x.response;P=x.getAllResponseHeaders();if(P){b=P.split("\u000d\u000a");for(var i=0;i<b.length;i++){if(b[i]){c=b[i].indexOf("\u003a\u0020");m[b[i].substring(0,c)]=b[i].substring(c+2)}}}t.fireUploadComplete({"headers":m,"response":r,"responseRaw":R,"readyStateXHR":s,"status":S})}t._bUploading=false};this._bUploading=false}}else{u.submit()}jQuery.sap.log.info("File uploading to "+this.getUploadUrl());if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true)}}}catch(e){jQuery.sap.log.error("File upload failed:\n"+e.message)}};
sap.ui.unified.FileUploader.prototype.abort=function(){if(this._uploadXHR&&this._uploadXHR.abort){this._uploadXHR.abort()}};
sap.ui.unified.FileUploader.prototype.onkeypress=function(e){this.onkeydown(e)};
sap.ui.unified.FileUploader.prototype.onclick=function(e){if(this.getSameFilenameAllowed()){this.setValue("",true)}};
sap.ui.unified.FileUploader.prototype.onkeydown=function(e){if(!this.getEnabled()){return}if(this.getSameFilenameAllowed()){this.setValue("",true)}var k=e.keyCode,a=jQuery.sap.KeyCodes;if(k==a.DELETE||k==a.BACKSPACE){if(this.oFileUpload){this.setValue("",true)}}else if(k==a.SPACE||k==a.ENTER){if(!(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=9)&&this.oFileUpload){this.oFileUpload.click();e.preventDefault();e.stopPropagation()}}else if(k!=a.TAB&&k!=a.SHIFT&&k!=a.F6){e.preventDefault();e.stopPropagation()}};
sap.ui.unified.FileUploader.prototype._isFilenameTooLong=function(f){var m=this.getMaximumFilenameLength();if(m!==0&&f.length>m){jQuery.sap.log.info("The filename of "+f+" ("+f.length+" characters)  is longer than the maximum of "+m+" characters.");return true}return false};
sap.ui.unified.FileUploader.prototype.handlechange=function(e){if(this.oFileUpload&&this.getEnabled()){var m=this.getMaximumFileSize();var f=this.getFileType();var M=this.getMimeType();var F='';if(window.File){var o=e.target.files;for(var i=0;i<o.length;i++){var c=i+1;var n=o[i].name;var N=n.length;var t=o[i].type;if(!t){t="unknown"}var s=((o[i].size/1024)/1024);if(m&&(s>m)){jQuery.sap.log.info("File: "+n+" is of size "+s+" MB which exceeds the file size limit of "+m+" MB.");this.fireFileSizeExceed({fileName:n,fileSize:s});return}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});return}if(M&&M.length>0){var w=true;for(var j=0;j<M.length;j++){if(t.match(M[j])){w=false}}if(w){jQuery.sap.log.info("File: "+n+" is of type "+t+". Allowed types are: "+M+".");this.fireTypeMissmatch({fileName:n,mimeType:t});return}}if(f&&f.length>0){var W=true;var I=n.lastIndexOf(".");var a=n.substring(I+1);for(var k=0;k<f.length;k++){if(a==f[k]){W=false}}if(W){jQuery.sap.log.info("File: "+n+" is of type "+a+". Allowed types are: "+f+".");this.fireTypeMissmatch({fileName:n,fileType:a});return}}F=F+'"'+o[i].name+'" '}if(F){this.fireFileAllowed()}}else if(f&&f.length>0){var W=true;var n=this.oFileUpload.value||"";var I=n.lastIndexOf(".");var a=n.substring(I+1);for(var k=0;k<f.length;k++){if(a==f[k]){W=false}}if(W){jQuery.sap.log.info("File: "+n+" is of type "+a+". Allowed types are: "+f+".");this.fireTypeMissmatch({fileName:n,fileType:a});return}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});return}if(n){this.fireFileAllowed()}}var v=this.oFileUpload.value||"";var b=v.lastIndexOf("\\");if(b>=0){v=v.substring(b+1)}if(this.getMultiple()&&!sap.ui.Device.browser.internet_explorer){v=F}if(v||sap.ui.Device.browser.chrome){this.setValue(v,true)}}};
sap.ui.unified.FileUploader.prototype.getBrowseText=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var t=undefined;if(r){t=r.getText("FILEUPLOAD_BROWSE")}return t?t:"Browse..."};
sap.ui.unified.FileUploader.prototype.getShortenValue=function(){return this.getValue()};
sap.ui.unified.FileUploader.prototype.prepareFileUploadAndIFrame=function(){if(!this.oFileUpload){var f=[];f.push('<input ');f.push('type="file" ');if(this.getName()){if(this.getMultiple()&&!sap.ui.Device.browser.internet_explorer){f.push('name="'+this.getName()+'[]" ')}else{f.push('name="'+this.getName()+'" ')}}else{if(this.getMultiple()&&!sap.ui.Device.browser.internet_explorer){f.push('name="'+this.getId()+'[]" ')}else{f.push('name="'+this.getId()+'" ')}}f.push('id="'+this.getId()+'-fu" ');if(!(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==8)){if(!(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==9)){f.push('tabindex="-1" ')}f.push('size="1" ')}if(this.getTooltip_AsString()){f.push('title="'+jQuery.sap.escapeHTML(this.getTooltip_AsString())+'" ')}else if(this.getTooltip()){}else if(this.getValue()!=""){f.push('title="'+jQuery.sap.escapeHTML(this.getValue())+'" ')}if(!this.getEnabled()){f.push('disabled="disabled" ')}if(this.getMultiple()&&!sap.ui.Device.browser.internet_explorer){f.push('multiple ')}f.push('>');this.oFileUpload=jQuery(f.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0)}else{jQuery(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"))}if(!this.oIFrameRef){var u=this.getDomRef("fu_form");var i=document.createElement("iframe");i.style.display="none";i.src="javascript:''";i.id=this.sId+"-frame";sap.ui.getCore().getStaticAreaRef().appendChild(i);i.contentWindow.name=this.sId+"-frame";var t=this;this._bUploading=false;jQuery(i).load(function(e){if(t._bUploading){jQuery.sap.log.info("File uploaded to "+t.getUploadUrl());var r;try{r=t.oIFrameRef.contentDocument.body.innerHTML}catch(a){}t.fireUploadComplete({"response":r});t._bUploading=false}});this.oIFrameRef=i}};
