/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP SE or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.ux3.DataSetSimpleView");jQuery.sap.require("sap.ui.ux3.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.ux3.DataSetSimpleView",{metadata:{interfaces:["sap.ui.ux3.DataSetView"],library:"sap.ui.ux3",properties:{"floating":{type:"boolean",group:"Misc",defaultValue:true},"name":{type:"string",group:"Misc",defaultValue:"Name of this View"},"icon":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"iconHovered":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"iconSelected":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"responsive":{type:"boolean",group:"Misc",defaultValue:false},"itemMinWidth":{type:"int",group:"Misc",defaultValue:0},"initialItemCount":{type:"int",group:"Appearance",defaultValue:0},"reloadItemCount":{type:"int",group:"Appearance",defaultValue:0},"scrollArea":{type:"any",group:"Appearance",defaultValue:null},"height":{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{"template":{type:"sap.ui.core.Control",multiple:false}}}});jQuery.sap.require("jquery.sap.script");jQuery.sap.require("sap.ui.core.ResizeHandler");
sap.ui.ux3.DataSetSimpleView.prototype.init=function(){this._oDataSet=this.getParent();this.items=[];this._bRendered=false;if(this.getInitialItemCount()>0&&this.getReloadItemCount()<=0){this.setReloadItemCount(this.getInitialItemCount())}this._bUsePagination=false};
sap.ui.ux3.DataSetSimpleView.prototype.exit=function(){if(this.sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};
sap.ui.ux3.DataSetSimpleView.prototype.handleSelection=function(e){var d=this.getParent();var o=e.getParameters().oldLeadSelectedIndex,n=e.getParameters().newLeadSelectedIndex,i=d.getItems(),s=d.getSelectedIndices();if(s.length>1){this._clearTextSelection()}jQuery.each(i,function(a,b){if(d.isSelectedIndex(a)){b.$().addClass("sapUiUx3DSSVSelected")}else{b.$().removeClass("sapUiUx3DSSVSelected")}})};
sap.ui.ux3.DataSetSimpleView.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty()}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges()}}else if(document.selection&&document.selection.empty){try{document.selection.empty()}catch(e){}}};
sap.ui.ux3.DataSetSimpleView.prototype.isItemSelected=function(i){var I=jQuery.inArray(i,this.items);if(I==-1){return false}return this.getParent().isSelectedIndex(I)};
sap.ui.ux3.DataSetSimpleView.prototype.initView=function(I){this.getParent().attachSelectionChanged(this.handleSelection,this);this.items=this.items.concat(I);for(var i=0;i<I.length;i++){var t=this.getTemplate().clone();I[i].setAggregation('_template',t,true)}};
sap.ui.ux3.DataSetSimpleView.prototype.updateView=function(d){var r=sap.ui.getCore().createRenderManager(),l=this.items.length;for(var i=0;i<d.length;i++){var I=d[i].item;var a=d[i].index;if(d[i].type==="insert"){var t=this.getTemplate().clone();I.setAggregation('_template',t,true);if(i==d.length-1&&l==0){var D={onAfterRendering:function(){this.calculateItemCounts();this.getParent().updateItems(sap.ui.model.ChangeReason.Change);t.removeDelegate(D)}};t.addDelegate(D,false,this)}this.getRenderer().renderItem(r,this,I);r.flush(this.$()[0],false,a);this.items.splice(a,0,I)}else{this.items.splice(a,1);I.$().remove();I.destroy()}}if(d.length>0&&this.getFloating()&&this.getResponsive()){this._computeWidths(true)}r.destroy()};
sap.ui.ux3.DataSetSimpleView.prototype.exitView=function(I){this.getParent().detachSelectionChanged(this.handleSelection,this);for(var i=0;i<I.length;i++){I[i].destroyAggregation("_template",true)}this.items=[]};
sap.ui.ux3.DataSetSimpleView.prototype.initScrollArea=function(){var $=this.getScrollArea(),t=this;var s=function(e){t.getParent().updateItems(sap.ui.model.ChangeReason.Change)};if(typeof $==='string'){$=jQuery.sap.byId($)}if(!$){$=this.$()}else if($.is('html')){$=jQuery(document)}if(!this._bUsePagination){$.off('scroll',s)}else{$.on('scroll',s)}};
sap.ui.ux3.DataSetSimpleView.prototype.checkScrollItems=function(){if(!this._bRendered){return}var b=this.getParent().mBindingInfos["items"],$=this.getScrollArea(),B=b.binding,p=this.getParent(),a=0,f,s,c,S;if(p.getItems().length===B.getLength()){return a}if(typeof $==='string'){$=jQuery.sap.byId($)}if(!$){$=this.$()}if(!$||$.length==0){return a}s=$[0];c=s.clientHeight;S=s.scrollHeight;if($.is('html')){$=jQuery(document)}if(c==S){f=c+this._iScrollTrigger}else{f=c+this._iScrollTrigger+$.scrollTop()}if(f>0){var n=Math.floor(f/this._iRowHeight)*this._iItemsPerRow;var C=p.getItems().length;n=Math.ceil(n/this._iItemsPerRow)*this._iItemsPerRow;a=n-C}return a};
sap.ui.ux3.DataSetSimpleView.prototype.getItemCount=function(){if(this._bUsePagination){var l=this.getParent().getItems().length,a=this.checkScrollItems();if(l==0){l+=this.getInitialItemCount()}else{l+=a}return l}else{return null}};
sap.ui.ux3.DataSetSimpleView.prototype.setInitialItemCount=function(v){this.setProperty("initialItemCount",v);this._bUsePagination=(v!=0)};
sap.ui.ux3.DataSetSimpleView.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};
sap.ui.ux3.DataSetSimpleView.prototype.onAfterRendering=function(){this._bRendered=true;this.initScrollArea();if((this.getFloating()&&this.getResponsive())||this._bUsePagination){this._height=-1;this._itemsPerRow=-1;this.onresize();this.sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),jQuery.proxy(this.onresize,this))}};
sap.ui.ux3.DataSetSimpleView.prototype.onThemeChanged=function(){if(this._bRendered){this.calculateItemCounts();this.getParent().updateItems(sap.ui.model.ChangeReason.Change)}};
sap.ui.ux3.DataSetSimpleView.prototype.onresize=function(){if(!this.getDomRef()){if(this.sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);this.sResizeListenerId=null}return}if(this.getFloating()&&this.getResponsive()){this._computeWidths()}if(this._bUsePagination&&this.items.length>0){this.calculateItemCounts();this.getParent().updateItems(sap.ui.model.ChangeReason.Change)}};
sap.ui.ux3.DataSetSimpleView.prototype.setTemplate=function(t){this.setAggregation("template",t,true);if(this.getParent()){this.getParent().updateItems()}};
sap.ui.ux3.DataSetSimpleView.prototype.calculateItemCounts=function(){if(this.getDomRef()){var $=this.$(),a=$.children().first();this._iItemsPerRow=Math.floor($.outerWidth(true)/a.outerWidth(true));this._iNewRows=Math.ceil(this.getReloadItemCount()/this._iItemsPerRow);this._iNewItems=this._iItemsPerRow*this._iNewRows;this._iRowHeight=a.outerHeight(true);this._iScrollTrigger=this._iNewRows*this._iRowHeight}};
sap.ui.ux3.DataSetSimpleView.prototype._computeWidths=function(i){var t=this.$();var I=Math.floor(t.width()/this.getItemMinWidth());var a=Math.floor(100/I);if(t.width()*a/100<this.getItemMinWidth()){I--;a=Math.floor(100/I)}if(i||this._height!=t.height()||this._itemsPerRow!=I){var c=-1;var b=this.getParent().getItems();var d,w;for(var j=0;j<b.length;j++){if(c==-1||c+1>I){c=0;d=100-(I*a)}var w=a;if(d>0){w++;d--}b[j].$().css("width",w+"%");c++}this._height=t.height();this._itemsPerRow=I}};
sap.ui.ux3.DataSetSimpleView.prototype.setScrollArea=function(s,S){if(typeof s!=='string'&&!(s instanceof jQuery)){jQuery.sap.log.error('You can only pass a string (ID of scroll area DOM) or an jQuery object as scrollarea')}this.setProperty('scrollArea',s,S)};
