/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters'],function(q,l,C,P){"use strict";var L=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:sap.m.ListType.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}}}});L.prototype._bNoFlex=!q.support.hasFlexBoxSupport;L.prototype._sImagePath=q.sap.getModulePath("sap.m","/")+"themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/img/list/"+(q.os.ios?"ios":"android")+"/";L.prototype.init=function(){this._active=false;this._mode="None"};L.prototype.getBindingContextPath=function(m){if(this._listId&&!m){m=(sap.ui.getCore().byId(this._listId).getBindingInfo("items")||{}).model}var c=this.getBindingContext(m);if(c){return c.getPath()}};L.prototype._getRadioButton=function(r,g){if(this.hasOwnProperty("_checkBox")){this._checkBox.destroy();delete this._checkBox}return this._radioButton||(this._radioButton=new sap.m.RadioButton(r,{groupName:g,activeHandling:false,selected:this.getSelected()}).setParent(this,null,true).attachSelect(this._select)).setTabIndex(-1)};L.prototype._getCheckBox=function(b){if(this.hasOwnProperty("_radioButton")){this._radioButton.destroy();delete this._radioButton}return this._checkBox||(this._checkBox=new sap.m.CheckBox(b,{activeHandling:false,selected:this.getSelected()}).setParent(this,null,true).attachSelect(this._select)).setTabIndex(-1)};L.prototype.exit=function(){if(this._radioButton){this._radioButton.destroy();delete this._radioButton}if(this._checkBox){this._checkBox.destroy();delete this._checkBox}if(this._navImage){this._navImage.destroy();delete this._navImage}if(this._delIcon){this._delIcon.destroy();delete this._delIcon}if(this._navIcon){this._navIcon.destroy();delete this._navIcon}if(this._detailIcon){this._detailIcon.destroy();delete this._detailIcon}this._oLastFocused=null};L.prototype.isSelectable=function(){return true};L.prototype.isSelected=function(){if(this.isSelectable()){return this.getProperty("selected")}return false};L.prototype.getSelected=function(){return this.isSelected()};L.prototype.setVisible=function(v){v=this.validateProperty("visible",v);if(this.getVisible()===v){return this}this.setProperty("visible",v);if(this._listId){var o=sap.ui.getCore().byId(this._listId);o.onItemVisibleChange(this,v)}return this};L.prototype.setSelected=function(s,d){s=this.validateProperty("selected",s);if(!this.isSelectable()||s===this.getSelected()){return this}if(!d&&this._listId){var o=sap.ui.getCore().byId(this._listId);o.onItemSetSelected(this,s)}if(this._checkBox){this._checkBox.setSelected(s)}else if(this._radioButton){this._radioButton.setSelected(s)}if(this.getDomRef()){this.$().toggleClass("sapMLIBSelected",s)}return this.setProperty("selected",s,true)};L.prototype.setActive=function(a){if(a!=this._active){this._active=a;this._activeHandling();if(this.getType()=="Navigation"){this._activeHandlingNav()}if(a){this._activeHandlingInheritor()}else{this._inactiveHandlingInheritor()}}return this};L.prototype.setUnread=function(u){this.setProperty("unread",u);this.$().toggleClass("sapMLIBUnread",u);return this};L.prototype._getNavImage=function(i,I,s,a){if(!q.os.ios&&this.getType()=="Navigation"){return null}if(this.hasOwnProperty("_navImage")){return this._navImage}if(a){a=this._sImagePath+a}this._navImage=new sap.m.Image(i,{src:this._sImagePath+s,activeSrc:a,densityAware:false}).addStyleClass(I,true).setParent(this,null,true);return this._navImage};L.prototype._getDelImage=function(i,I,s){return this._delImage||(this._delImage=new sap.m.Image(i,{src:this._sImagePath+s,densityAware:false}).addStyleClass(I,true).setParent(this,null,true).attachPress(this._delete))};L.prototype.ontap=function(e){var t=this.getType();if(this._mode==="SingleSelectMaster"||(this._includeItemInSelection&&(this._mode==="SingleSelect"||this._mode==="SingleSelectLeft"||this._mode==="MultiSelect"))){switch(this._mode){case"SingleSelect":case"SingleSelectLeft":case"SingleSelectMaster":if(!this.getSelected()&&e.srcControl&&e.srcControl.getId()!==this._radioButton.getId()){this.setSelected(true);this._listId&&sap.ui.getCore().byId(this._listId)._selectTapped(this)}break;case"MultiSelect":if(e.srcControl&&e.srcControl.getId()!==this._checkBox.getId()){this.setSelected(!this.getSelected());this._listId&&sap.ui.getCore().byId(this._listId)._selectTapped(this)}break}}else{switch(t){case"Active":case"Navigation":if(this._isActivationHandled(e)&&!this._eventHandledByControl){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false)})}if(!this._eventHandledByControl){q.sap.delayedCall(50,this,function(){this.fireTap({});this.firePress({})})}break;case"Detail":if(e.srcControl&&e.srcControl.getId()===(this.getId()+"-imgDet")){this.fireDetailTap({});this.fireDetailPress({})}break;case"DetailAndActive":if(e.srcControl&&e.srcControl.getId()===(this.getId()+"-imgDet")){this.fireDetailTap({});this.fireDetailPress({})}else{if(this._isActivationHandled(e)&&!this._eventHandledByControl){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false)})}if(!this._eventHandledByControl){q.sap.delayedCall(50,this,function(){this.fireTap({});this.firePress({})})}}break}}if(this._listId&&t!="Inactive"&&!this._eventHandledByControl){sap.ui.getCore().byId(this._listId)._onItemPressed(this,e)}};L.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();this._touchedY=e.targetTouches[0].clientY;this._touchedX=e.targetTouches[0].clientX;this._timeoutIdStart=q.sap.delayedCall(100,this,function(){if(!(this._includeItemInSelection&&(this._mode=="SingleSelect"||this._mode=="SingleSelectLeft"||this._mode=="MultiSelect"))&&((e.touches&&e.touches.length===1)||!e.touches)){var t=this.getType();switch(t){case"Active":case"Navigation":case"DetailAndActive":if(this._isActivationHandled(e)&&!this._eventHandledByControl){e.setMarked();this.setActive(true)}break}}})};L.prototype.ontouchmove=function(e){var t=((Math.abs(this._touchedY-e.targetTouches[0].clientY)>10)||Math.abs(this._touchedX-e.targetTouches[0].clientX)>10);if((this._active||this._timeoutIdStart)&&t){clearTimeout(this._timeoutIdStart);this.setActive(false);this._timeoutIdStart=null;this._timeoutIdEnd=null}};L.prototype.ontouchend=function(e){if(e.targetTouches.length===0){switch(this.getType()){case"Active":case"Navigation":case"DetailAndActive":this._timeoutIdEnd=q.sap.delayedCall(100,this,function(){this._event=e;this.setActive(false)});break}}};L.prototype.ontouchcancel=L.prototype.ontouchend;L.prototype._activeHandlingNav=function(){if(sap.ui.Device.os.ios){this.$("imgNav").toggleClass("sapMLIBImgNavActive",this._active)}};L.prototype._activeHandlingInheritor=function(){};L.prototype._inactiveHandlingInheritor=function(){};L.prototype._activeHandling=function(){this.$().toggleClass("sapMLIBActive",this._active);this.$("counter").toggleClass("sapMLIBActiveCounter",this._active);if(this.getUnread()){this.$("unread").toggleClass("sapMLIBActiveUnread",this._active)}var i=sap.ui.getCore().byId(this.getId()+"-imgDet");if(i){i.$().toggleClass("sapMLIBIconDetActive",this._active)}var I=sap.ui.getCore().byId(this.getId()+"-imgDel");if(I){I.$().toggleClass("sapMLIBIconDelActive",this._active)}};L.prototype._isActivationHandled=function(e){this._event=e;var c=e.srcControl;if(c&&c.getId()!=this.getId()+"-imgDel"&&c.getId()!=this.getId()+"-imgDet"&&(!c.getActiveHandling||c.getActiveHandling&&c.getActiveHandling()!==false)){return true}return false};L.prototype.onsapspace=function(e){if(e.srcControl!==this){return}e.preventDefault();if(!this._listId||e.isMarked()||!this.isSelectable()||this._mode=="Delete"||this._mode=="None"){return}if(this._mode=="MultiSelect"){this.setSelected(!this.getSelected());sap.ui.getCore().byId(this._listId)._selectTapped(this)}else if(!this.getSelected()){this.setSelected(true);sap.ui.getCore().byId(this._listId)._selectTapped(this)}e.setMarked()};L.prototype.onsapenter=function(e){if(!this._listId||e.isMarked()||e.srcControl!==this){return}if(this.getType()!="Inactive"){sap.ui.getCore().byId(this._listId)._onItemPressed(this,e)}if((this._includeItemInSelection&&this._mode!="None"&&this._mode!="Delete")||this._mode=="SingleSelectMaster"){this.onsapspace(e);return}switch(this.getType()){case"Active":case"Navigation":case"DetailAndActive":e.setMarked();this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false)});q.sap.delayedCall(0,this,function(){this.fireTap({});this.firePress({})});break}};L.prototype.onsapdelete=function(e){if(!this._listId||e.isMarked()||e.srcControl!==this||this._mode!="Delete"){return}this._delete.call(this._delIcon||this._delImage);e.preventDefault();e.setMarked()};L.prototype._switchFocus=function(e){var p=this.getParent();var t=this.getTabbables();if(e.srcControl!==this){p._iLastFocusPosOfItem=t.index(e.target);this.focus()}else if(t.length){var f=p._iLastFocusPosOfItem||0;f=t[f]?f:-1;t.eq(f).focus()}};L.prototype.onkeydown=function(e){var k=q.sap.KeyCodes;if(e.isMarked()){return}if(e.which==k.F7){this._switchFocus(e);e.preventDefault();e.setMarked();return}if(e.srcControl!==this){return}if(e.which==k.F2&&this.getType().indexOf("Detail")==0){this.fireDetailTap({});this.fireDetailPress({});e.preventDefault();e.setMarked();return}};L.prototype.getTabbables=function(){return this.$().find(":sapTabbable")};L.prototype.onsaptabnext=function(e){if(!this._listId||e.isMarked()){return}var o=this.getTabbables().get(-1)||this.getDomRef();if(e.target===o){sap.ui.getCore().byId(this._listId).forwardTab(true);e.setMarked()}};L.prototype.onsaptabprevious=function(e){if(!this._listId||e.isMarked()){return}if(e.target===this.getDomRef()){sap.ui.getCore().byId(this._listId).forwardTab(false);e.setMarked()}};L.prototype.onfocusin=function(e){if(!this._listId||e.isMarked()||e.srcControl===this||!q(e.target).is(":sapFocusable")){return}sap.ui.getCore().byId(this._listId).setItemFocusable(this);e.setMarked()};return L},true);
