/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";var O=C.extend("sap.m.ObjectHeader",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:null},introActive:{type:"boolean",group:"Misc",defaultValue:null},titleActive:{type:"boolean",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconActive:{type:"boolean",group:"Misc",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},numberState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},condensed:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Transparent},responsive:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},firstStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},secondStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},statuses:{type:"sap.ui.core.Control",multiple:true,singularName:"status"},_objectNumber:{type:"sap.m.ObjectNumber",multiple:false,visibility:"hidden"},headerContainer:{type:"sap.m.ObjectHeaderContainer",multiple:false}},events:{titlePress:{parameters:{domRef:{type:"object"}}},introPress:{parameters:{domRef:{type:"object"}}},iconPress:{parameters:{domRef:{type:"object"}}},titleSelectorPress:{parameters:{domRef:{type:"object"}}}}}});O.prototype.init=function(){var t=this;this._oPlaceholderIcon=I.createControlByURI({id:this.getId()+"-placeholder",src:I.getIconURI("fridge")});this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible");this._oFlagIcon=I.createControlByURI({id:this.getId()+"-flag",src:I.getIconURI("flag"),visible:false});this._oFavIcon=I.createControlByURI({id:this.getId()+"-favorite",src:I.getIconURI("favorite"),visible:false});this._oTitleArrowIcon=I.createControlByURI({id:this.getId()+"-titleArrow",src:I.getIconURI("arrow-down"),decorative:false,visible:false,size:(this.getCondensed()?"1.125rem":"1.375rem"),press:function(e){t.fireTitleSelectorPress({domRef:this.getDomRef()})}});this._fNumberWidth=undefined;this._titleText=new sap.m.Text(this.getId()+"-titleText");this._titleText.setMaxLines(3)};O.prototype.setCondensed=function(c){this.setProperty("condensed",c);if(this.getCondensed()){this._oTitleArrowIcon.setSize("1.125rem")}else{this._oTitleArrowIcon.setSize("1.375rem")}return this};O.prototype.setNumber=function(n){this.setProperty("number",n);this._getObjectNumber().setNumber(n);return this};O.prototype.setNumberUnit=function(u){this.setProperty("numberUnit",u);this._getObjectNumber().setNumberUnit(u);return this};O.prototype.setNumberState=function(s){this.setProperty("numberState",s,true);this._getObjectNumber().setState(s);return this};O.prototype._getObjectNumber=function(){var c=this.getAggregation("_objectNumber");if(!c){c=new sap.m.ObjectNumber(this.getId()+"-number",{emphasized:false});this.setAggregation("_objectNumber",c,true)}return c};O.prototype.ontap=function(e){var s=e.target.id;if(this.getIntroActive()&&s===this.getId()+"-intro"){this.fireIntroPress({domRef:q.sap.domById(s)})}else if(this.getTitleActive()&&e.srcControl===this._titleText){this.fireTitlePress({domRef:this._titleText.getFocusDomRef()})}else if(this.getIconActive()&&(s===this.getId()+"-img"||s===this.getId()+"-icon")){this.fireIconPress({domRef:q.sap.domById(s)})}};O.prototype._handleSpaceOrEnter=function(e){var s=e.target.id;if(this.getTitleActive()&&s===this.getId()+"-title"){if(e.type==="sapspace"){e.preventDefault()}this.fireTitlePress({domRef:this._titleText.getFocusDomRef()})}else if(this.getIntroActive()&&s===this.getId()+"-intro"){if(e.type==="sapspace"){e.preventDefault()}this.fireIntroPress({domRef:q.sap.domById(s)})}else if(this.getIconActive()&&q(e.target).hasClass('sapMOHIcon')){if(e.type==="sapspace"){e.preventDefault()}var i=q.sap.domById(this.getId()+"-icon");if(!i){i=q.sap.domById(this.getId()+"-img")}this.fireIconPress({domRef:i})}};O.prototype.onsapspace=O.prototype._handleSpaceOrEnter;O.prototype.onsapenter=O.prototype._handleSpaceOrEnter;O.prototype.exit=function(){if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=undefined}if(this._oPlaceholderIcon){this._oPlaceholderIcon.destroy();this._oPlaceholderIcon=undefined}if(this._oFavIcon){this._oFavIcon.destroy();this._oFavIcon=undefined}if(this._oFlagIcon){this._oFlagIcon.destroy();this._oFlagIcon=undefined}if(this._oTitleArrowIcon){this._oTitleArrowIcon.destroy();this._oTitleArrowIcon=undefined}if(this._titleText){this._titleText.destroy();this._titleText=undefined}};O.prototype._getImageControl=function(){var i=this.getId()+"-img";var s=sap.ui.Device.system.phone?"2.5rem":"3rem";var h=s;var w=s;if(this.getResponsive()){s="2.5rem";h="3rem";w="3rem"}var p={src:this.getIcon(),height:h,width:w,size:s,densityAware:this.getIconDensityAware()};this._oImageControl=sap.m.ImageHelper.getImageControl(i,this._oImageControl,this,p);return this._oImageControl};O.prototype.onBeforeRendering=function(){if(this.getHeaderContainer()instanceof C&&this.getHeaderContainer().$()){this.getHeaderContainer().$().remove()}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};O.prototype.onAfterRendering=function(){if(this.getShowTitleSelector()){this._oTitleArrowIcon.$().css("cursor","pointer")}if(this.$("number").length>0){this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._resizeElements,this));setTimeout(q.proxy(this._resizeElements,this))}};O.prototype._resizeElements=function(){if(!this.getDomRef()){return}var i=this.getId();if(!this.getResponsive()){var $=q.sap.byId(i+"-numberdiv");var h=$.hasClass("sapMOHNumberWrap");if(this._fNumberWidth===undefined){this._fNumberWidth=$.outerWidth()}var o=$.parent().width()*35/100<this._fNumberWidth;if(o!=h){$.toggleClass("sapMOHNumberWrap");q.sap.byId(i+"-titlediv").toggleClass("sapMOHNumberWrap");q(O._escapeId(i)+" .sapMOHBottomRow").css("margin-top",o&&sap.ui.Device.system.phone?".25rem":"");this._titleText.setMaxLines(o?2:3).rerender()}}};O._escapeId=function(i){return i?"#"+i.replace(/(:|\.)/g,'\\$1'):""};O.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this.getShowMarkers())};O.prototype._hasIcon=function(){return!!this.getIcon().trim()};O.prototype._hasAttributes=function(){var a=this.getAttributes();if(a&&a.length>0){for(var i=0;i<a.length;i++){if(!a[i]._isEmpty()){return true}}}return false};O.prototype._hasStatus=function(){var h=((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()));if(!h&&this.getStatuses()&&this.getStatuses().length>0){var s=this.getStatuses();for(var i=0;i<s.length;i++){if(s[i]instanceof sap.m.ObjectStatus&&!s[i]._isEmpty()){h=true;break}else if(s[i]instanceof sap.m.ProgressIndicator){h=true;break}}}return h};return O},true);
