/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";var b=a.extend("sap.m.P13nFilterPanel",{metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{}}}});b.prototype.setConditions=function(c){var I=[];var e=[];if(c.length){for(var i=0;i<c.length;i++){var o=c[i];if(!o.exclude){I.push(o)}else{e.push(o)}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(e);if(e.length>0){this._oExcludePanel.setExpanded(true)}};b.prototype._addCondition=function(c){if(!c.exclude){this._oIncludeFilterPanel.addCondition(c)}else{this._oExcludeFilterPanel.addCondition(c)}if(this._oExcludeFilterPanel.getConditions().length>0){this._oExcludePanel.setExpanded(true)}};b.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var e=this._oExcludeFilterPanel.getConditions();return i.concat(e)};b.prototype.setContainerQuery=function(c){this.setProperty("containerQuery",c);this._oIncludeFilterPanel.setContainerQuery(c);this._oExcludeFilterPanel.setContainerQuery(c)};b.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m)};b.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions()};b.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions()};b.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors()};b.prototype.onBeforeNavigationFrom=function(){return this.validateConditions()};b.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions()};b.prototype.setIncludeOperations=function(o){this._aIncludeOperations=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations)}};b.prototype.getIncludeOperations=function(){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations()}};b.prototype.setExcludeOperations=function(o){this._aExcludeOperations=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations)}};b.prototype.getExcludeOperations=function(){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations()}};b.prototype.setKeyFields=function(k){this._aKeyFields=k;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setKeyFields(this._aKeyFields)}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields(this._aKeyFields)}};b.prototype.getKeyFields=function(){return this._aKeyFields};b.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m)}this._updatePanel()};b.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m)}this._updatePanel()};b.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes(),10);var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes(),10);if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin")}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false)}};b.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMFilterPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!this._aIncludeOperations){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.StartsWith,sap.m.P13nConditionOperation.EndsWith,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE])}if(!this._aExcludeOperations){this.setExcludeOperations([sap.m.P13nConditionOperation.EQ])}this._oIncludePanel=new sap.m.Panel({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),autoAddNewRow:true,alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel.setOperations(this._aIncludeOperations);this._oIncludeFilterPanel.setOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"date");this._oIncludeFilterPanel.setOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"numeric");this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new sap.m.Panel({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),autoAddNewRow:true,alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel.setOperations(this._aExcludeOperations);this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel()};b.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy()}return null};this._aKeyFields=d(this._aKeyFields);this._aIncludeOperations=d(this._aIncludeOperations);this._aExcludeOperations=d(this._aExcludeOperations);this._oRb=d(this._oRb)};b.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);var k={key:i.getColumnKey(),text:i.getText(),tooltip:i.getTooltip(),maxLength:i.getMaxLength(),type:i.getType(),precision:i.getPrecision(),scale:i.getScale(),isDefault:i.getIsDefault()};this._aKeyFields.push(k);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.addKeyField(k)}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.addKeyField(k)}};b.prototype.destroyItems=function(){this.destroyAggregation("items");if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.removeAllKeyFields()}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.removeAllKeyFields()}return this};b.prototype.addFilterItem=function(f){this.addAggregation("filterItems",f);if(!this._bIgnoreBindCalls){var c={exclude:f.getExclude(),key:f.getKey(),keyField:f.getColumnKey(),operation:f.getOperation(),value1:f.getValue1(),value2:f.getValue2()};this._addCondition(c)}};b.prototype.insertFilterItem=function(f){this.insertAggregation("filterItems",f);return this};b.prototype.removeFilterItem=function(f){f=this.removeAggregation("filterItems",f);return f};b.prototype.removeAllFilterItems=function(){var f=this.removeAllAggregation("filterItems");if(!this._bIgnoreBindCalls){this.setConditions([])}return f};b.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this.setConditions([])}return this};b.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var f=null;if(n){f={key:k,exclude:n.exclude,columnKey:n.keyField,operation:n.operation,value1:n.value1,value2:n.value2}}if(o==="update"){var F=t.getFilterItems()[i];if(F){F.setExclude(n.exclude);F.setColumnKey(n.keyField);F.setOperation(n.operation);F.setValue1(n.value1);F.setValue2(n.value2)}t.fireUpdateFilterItem({key:k,index:i,filterItemData:f})}if(o==="add"){t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:i,filterItemData:f});t._bIgnoreBindCalls=false}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:i});t._bIgnoreBindCalls=false}}};return b},true);
