/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./SwitchRenderer','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/theming/Parameters'],function(q,S,l,C,E,I,P){"use strict";var a=C.extend("sap.m.Switch",{metadata:{library:"sap.m",properties:{state:{type:"boolean",group:"Misc",defaultValue:false},customTextOn:{type:"string",group:"Misc",defaultValue:""},customTextOff:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Data",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.m.SwitchType",group:"Appearance",defaultValue:sap.m.SwitchType.Default}},events:{change:{parameters:{state:{type:"boolean"}}}}}});I.insertFontFaceStyle();E.apply(a.prototype,[true]);a.prototype._slide=function(i){if(i>a._OFFPOSITION){i=a._OFFPOSITION}else if(i<a._ONPOSITION){i=a._ONPOSITION}else{i=i}if(this._iCurrentPosition===i){return}this._iCurrentPosition=i;this._$SwitchInner[0].style[sap.ui.getCore().getConfiguration().getRTL()?"right":"left"]=i+"px";this._setTempState(Math.abs(i)<a._SWAPPOINT)};a.prototype._setTempState=function(b){if(this._bTempState===b){return}this._bTempState=b;this._$Handle[0].setAttribute("data-sap-ui-swt",b?this._sOn:this._sOff)};a.prototype._setDomState=function(s){var b=S.CSS_CLASS,c=s?this._sOn:this._sOff;if(!this._$Switch){return this}this._$Handle[0].setAttribute("data-sap-ui-swt",c);if(this.getName()){this._$Checkbox[0].setAttribute("checked",s);this._$Checkbox[0].setAttribute("value",c)}s?this._$Switch.removeClass(b+"Off").addClass(b+"On"):this._$Switch.removeClass(b+"On").addClass(b+"Off");this._$Switch.addClass(b+"Trans");this._$SwitchInner[0].style.cssText=""};a._getCssParameter=function(s){var g=P.get;return g(s)||g(s+"-"+sap.ui.Device.os.name.toLowerCase())};var p="sapMSwitch-TRANSITIONTIME",t=a._getCssParameter(p);a._TRANSITIONTIME=Number(t)||0;a._ONPOSITION=Number(a._getCssParameter("sapMSwitch-ONPOSITION"));a._OFFPOSITION=Number(a._getCssParameter("sapMSwitch-OFFPOSITION"));a._SWAPPOINT=Math.abs((a._ONPOSITION-a._OFFPOSITION)/2);a._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");a.prototype.onBeforeRendering=function(){var b=a;this._sOn=this.getCustomTextOn()||b._oRb.getText("SWITCH_ON");this._sOff=this.getCustomTextOff()||b._oRb.getText("SWITCH_OFF")};a.prototype.onAfterRendering=function(){var s,b="."+S.CSS_CLASS;s=this.$();this._$Switch=s.find(b);this._$SwitchInner=this._$Switch.children(b+"Inner");this._$Handle=this._$SwitchInner.children(b+"Handle");this._$Checkbox=s.children("input")};a.prototype.ontouchstart=function(e){var T=e.targetTouches[0],b=S.CSS_CLASS;e.setMarked();if(sap.m.touch.countContained(e.touches,this.getId())>1||!this.getEnabled()||e.button){return}this._iActiveTouchId=T.identifier;q.sap.delayedCall(0,this,"focus");this._$Switch.addClass(b+"Pressed").removeClass(b+"Trans");this._bTempState=this.getState();this._iStartPressPosX=T.pageX;this._iPosition=this._$SwitchInner.position().left;this._bDragging=false};a.prototype.ontouchmove=function(e){e.setMarked();e.preventDefault();var T,i,f=sap.m.touch;if(!this.getEnabled()||e.button){return}T=f.find(e.changedTouches,this._iActiveTouchId);if(!T||T.pageX===this._iStartPressPosX){return}this._bDragging=true;i=((this._iStartPressPosX-T.pageX)*-1)+this._iPosition;if(sap.ui.getCore().getConfiguration().getRTL()){i=-i}this._slide(i)};a.prototype.ontouchend=function(e){e.setMarked();var T,f=sap.m.touch,b=q.sap.assert;if(!this.getEnabled()||e.button){return}b(this._iActiveTouchId!==undefined,"expect to already be touching");T=f.find(e.changedTouches,this._iActiveTouchId);if(T){b(!f.find(e.touches,this._iActiveTouchId),"touchend still active");this._$Switch.removeClass(S.CSS_CLASS+"Pressed");this._setDomState(this._bDragging?this._bTempState:!this.getState());q.sap.delayedCall(a._TRANSITIONTIME,this,function(){var s=this.getState();this.setState(this._bDragging?this._bTempState:!s);if(s!==this.getState()){this.fireChange({state:this.getState()})}})}};a.prototype.ontouchcancel=a.prototype.ontouchend;a.prototype.onsapselect=function(e){var s;if(this.getEnabled()){e.setMarked();e.preventDefault();this.setState(!this.getState());s=this.getState();q.sap.delayedCall(a._TRANSITIONTIME,this,function(){this.fireChange({state:s})})}};a.prototype.setState=function(s){this.setProperty("state",s,true);this._setDomState(this.getState());return this};return a},true);
