/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./MessageBox','./MessageToast','./library','sap/ui/core/Control','sap/ui/unified/library'],function(q,M,a,l,C,b){"use strict";var U=C.extend("sap.m.UploadCollection",{metadata:{library:"sap.m",properties:{fileType:{type:"string[]",group:"Data",defaultValue:null},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},maximumFileSize:{type:"int",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Behavior",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:sap.m.ListSeparators.None},uploadEnabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"string",group:"Data",defaultValue:"../../../upload"}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.UploadCollectionItem",multiple:true,singularName:"item"},headerParameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"headerParameter"},parameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"parameter"}},events:{change:{parameters:{documentId:{type:"string"}}},fileDeleted:{parameters:{documentId:{type:"string"}}},filenameLengthExceed:{parameters:{documentId:{type:"string"}}},fileRenamed:{parameters:{documentId:{type:"string"},fileName:{type:"string"}}},fileSizeExceed:{parameters:{documentId:{type:"string"},fileSize:{type:"string"}}},typeMissmatch:{parameters:{documentId:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"}}},uploadComplete:{parameters:{readyStateXHR:{type:"string"},response:{type:"string"},status:{type:"string"}}},uploadTerminated:{}}}});U._uploadingStatus="uploading";U._displayStatus="display";U._toBeDeletedStatus="toBeDeleted";U.prototype._requestIdName="requestId";U.prototype._requestIdValue=0;U.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");sap.m.UploadCollection.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oList=new sap.m.List(this.getId()+"-list",{});this._oList.addStyleClass("sapMUCList")};U.prototype.setFileType=function(f){this.setProperty("fileType",f);if(this._getFileUploader().getFileType()!==f){this._getFileUploader().setFileType(f)}return this};U.prototype.setMaximumFilenameLength=function(m){this.setProperty("maximumFilenameLength",m);if(this._getFileUploader().getMaximumFilenameLength()!==m){this._getFileUploader().setMaximumFilenameLength(m)}return this};U.prototype.setMaximumFileSize=function(m){this.setProperty("maximumFileSize",m);if(this._getFileUploader().getMaximumFileSize()!==m){this._getFileUploader().setMaximumFileSize(m)}return this};U.prototype.setMimeType=function(m){this.setProperty("mimeType",m);if(this._getFileUploader().getMimeType()!==m){this._getFileUploader().setMimeType(m)}return this};U.prototype.setMultiple=function(m){return this};U.prototype.setNoDataText=function(n){this.setProperty("noDataText",n);if(this._oList.getNoDataText()!==n){this._oList.setNoDataText(n)}return this};U.prototype.setShowSeparators=function(s){this.setProperty("showSeparators",s);if(this._oList.getShowSeparators()!==s){this._oList.setShowSeparators(s)}return this};U.prototype.setUploadEnabled=function(u){this.setProperty("uploadEnabled",u);if(this._getFileUploader().getEnabled()!==u){this._getFileUploader().setEnabled(u)}return this};U.prototype.setUploadUrl=function(u){this.setProperty("uploadUrl",u);if(this._getFileUploader().getUploadUrl()!==u){this._getFileUploader().setUploadUrl(u)}return this};U.prototype.onBeforeRendering=function(){var n=n||{};var N=N||this.getNoDataText();var i,j,I;if(this.aItems&&this.aItems.length>0){var c=this.aItems.length;var u=[];for(i=0;i<c;i++){if(this.aItems[i]._status===U._uploadingStatus){u.push(this.aItems[i])}if(this.aItems[i]._status===U._toBeDeletedStatus){I=true}}i=0;if(u.length>0){var d=this.getItems().length;for(i=0;i<d;i++){if(u.length===0){break}j=0;for(j=0;j<u.length;j++){if(this.getItems()[i].getProperty("fileName")===u[j].getProperty("fileName")&&this.getItems()[i]._requestIdName===u[j]._requestIdName){u.splice(j,1);break}}}}if(this.getItems()&&this.getItems().length>0){this.aItems.length=0;this.aItems=this.getItems();for(i=0;i<u.length;i++){this.aItems.unshift(u[i])}}else{if(I==true){for(i=c;i--;){if(this.aItems[i]._status===U._toBeDeletedStatus){this.aItems.splice(i,1)}}}}}else{this.aItems=this.getItems()}n=this._getNumberOfAttachmentsLabel(this.aItems.length);if(!this.oHeaderToolbar){this.oHeaderToolbar=new sap.m.Toolbar(this.getId()+"-toolbar",{content:[n,new sap.m.ToolbarSpacer(),this._getFileUploader()]})}else{var t=this.oHeaderToolbar.getContent();t[0]=n;this.oHeaderToolbar.content=t}this.oHeaderToolbar.addStyleClass("sapMUCListHeader");if((sap.ui.Device.browser.msie&&sap.ui.Device.browser.version<=9)&&this.aItems.length>0&&this.aItems[0]._status===U._uploadingStatus){this._oFileUploader.setEnabled(false)}else{if(this.sErrorState!=="Error"){if(this.getUploadEnabled()!=this._oFileUploader.getEnabled()){this._oFileUploader.setEnabled(this.getUploadEnabled())}}else{this._oFileUploader.setEnabled(false)}}this._clearList();this._fillList(this.aItems);this._oList.setHeaderToolbar(this.oHeaderToolbar)};U.prototype.onAfterRendering=function(){var t=this;for(var i=0;i<this._oList.aDelegates.length;i++){if(this._oList.aDelegates[i]._sId&&this._oList.aDelegates[i]._sId==="UploadCollection"){this._oList.aDelegates.splice(i,1)}}if(this.aItems||(this.aItems===this.getItems())){if(this.editModeItem){var $=q.sap.byId(this.editModeItem+"-ta_editFileName-inner");if($){var I=this.editModeItem;if(!(sap.ui.Device.os.ios&&(sap.ui.Device.browser.chrome||sap.ui.Device.browser.safari))){$.focus(function(){$.selectText(0,$.val().length)})}$.focus();this._oList.addDelegate({onclick:function(e){sap.m.UploadCollection.prototype._handleClick(e,t,I)}});this._oList.aDelegates[this._oList.aDelegates.length-1]._sId="UploadCollection"}}else{if(this.sFocusId){sap.m.UploadCollection.prototype._setFocus2LineItem(this.sFocusId);this.sFocusId=null}else if(this.sDeletedItemId){sap.m.UploadCollection.prototype._setFocusAfterDeletion(this.sDeletedItemId,t);this.sDeletedItemId=null}}}};U.prototype.exit=function(){if(this._oList){this._oList.destroy();this._oList=null}};U.prototype._mapItemToListItem=function(i){if(!i){return null}var I=i.getId(),p=i._percentUploaded,s=i._status,f=i.getFileName(),t=this,e=true;var B,o,c,E,d,F,u,P,T,g,h,j,k,m,n,H,L;if(s===U._uploadingStatus){B=new sap.m.BusyIndicator(I+"-ia_indicator",{visible:true}).setSize("2.5rem").addStyleClass("sapMUCloadingIcon")}if(s==="Edit"){o=new sap.m.Button({id:I+"-okButton",text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),type:sap.m.ButtonType.Transparent}).addStyleClass("sapMUCOkBtn");c=new sap.m.Button({id:I+"-cancelButton",text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),type:sap.m.ButtonType.Transparent}).addStyleClass("sapMUCCancelBtn")}if(s===U._displayStatus){e=i.getEnableEdit();if(this.sErrorState==="Error"){e=false}E=new sap.m.Button({id:I+"-editButton",icon:"sap-icon://edit",type:sap.m.ButtonType.Transparent,enabled:e,visible:i.getVisibleEdit(),press:function(z){sap.m.UploadCollection.prototype._handleEdit(z,t)}}).addStyleClass("sapMUCEditBtn")}if(s===U._displayStatus){var r="deleteButton";var d=this._createDeleteButton(I,r,i,this.sErrorState);d.attachPress(function(z){sap.m.UploadCollection.prototype._handleDelete(z,t)})}if(s===U._uploadingStatus&&!(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version<=9)){var r="terminateButton";var d=this._createDeleteButton(I,r,i,this.sErrorState);d.attachPress(function(z){sap.m.UploadCollection.prototype._handleTerminate(z,t)})}k=new sap.ui.layout.HorizontalLayout(I+"-ba_innerHL",{content:[o,c,E,d],allowWrapping:false}).addStyleClass("sapMUCBtnHL");if(s===U._displayStatus||s===U._uploadingStatus){e=true;if(this.sErrorState==="Error"){e=false}F=new sap.m.Link(I+"-ta_filenameHL",{text:f,enabled:e,target:"_blank",href:i.getUrl()}).addStyleClass("sapMUCFileName")}if(s===U._displayStatus){u=new sap.m.Label(I+"-ta_date",{text:i.getUploadedDate()+" "+i.getContributor()})}if(s===U._uploadingStatus&&!(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version<=9)){P=new sap.m.Label(I+"-ta_progress",{text:this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[p])}).addStyleClass("sapMUCProgress")}if(s===U._displayStatus||s===U._uploadingStatus){T=new sap.ui.layout.HorizontalLayout(I+"-ta_descriptionHL",{content:[u,P]}).addStyleClass("sapMUCDescriptionHL")}if(s==="Edit"){var v=U.prototype._splitFilename(f);var w=t.getMaximumFilenameLength();var V="None";var S=false;var x=v.name;if(i.errorState==="Error"){S=true;V="Error";x=i.changedFileName}g=new sap.m.Input(I+"-ta_editFileName",{type:sap.m.InputType.Text,valueState:V,valueStateText:this._oRb.getText("UPLOADCOLLECTION_EXISTS"),showValueStateMessage:S,value:x,description:v.extension}).addStyleClass("sapMUCEditBox");if((w-v.extension.length)>0){g.setProperty("maxLength",w-v.extension.length,true)}g.setLayoutData(new sap.m.FlexItemData({growFactor:1}));m=new sap.m.HBox(I+"-ta_extensionHL",{items:[g]}).addStyleClass("sapMUCEditHL")}n=new sap.ui.layout.VerticalLayout(I+"-ta_textVL",{content:[F,m,T]}).addStyleClass("sapMUCText");if(s===U._displayStatus||s==="Edit"){var D=false;if(this.sErrorState==="Error"||i.getProperty("url")==false){D=true}j=i.getThumbnailUrl();if(j){h=new sap.m.Image(I+"-ia_imageHL",{src:sap.m.UploadCollection.prototype._getThumbnail(j,f),decorative:D}).addStyleClass("sapMUCItemImage")}else{h=new sap.ui.core.Icon(I+"-ia_iconHL",{src:sap.m.UploadCollection.prototype._getThumbnail(undefined,f),decorative:D}).setSize('2.5rem').addStyleClass("sapMUCItemIcon")}if(D==false){h.attachPress(function(z){sap.m.UploadCollection.prototype._triggerLink(z,t)})}}H=new sap.ui.layout.HorizontalLayout(I+"-ta_HL",{content:[B,h,n,k],allowWrapping:false}).addStyleClass("sapMUCItemHL");if(s==="Edit"){H.addStyleClass("sapMUCEditMode")}else{H.removeStyleClass("sapMUCEditMode")}L=new sap.m.CustomListItem({content:[H]});for(var y in i.mProperties){if(i.mProperties.hasOwnProperty(y)){L.mProperties[y]=i.mProperties[y]}}L._status=s;L.addStyleClass("sapMUCItem");return L};U.prototype._createDeleteButton=function(i,B,I,e){var E=I.getEnableDelete();if(this.sErrorState==="Error"){E=false}var d=new sap.m.Button({id:i+"-"+B,icon:"sap-icon://sys-cancel",type:sap.m.ButtonType.Transparent,enabled:E,visible:I.getVisibleDelete()}).addStyleClass("sapMUCDeleteBtn");return d};U.prototype._fillList=function(i){var t=this;var m=i.length-1;q.each(i,function(I,o){if(!o._status){o._status=U._displayStatus}if(!o._percentUploaded&&o._status===U._uploadingStatus){o._percentUploaded=0}var L=t._mapItemToListItem(o);if(I===0&&m===0){L.addStyleClass("sapMUCListSingleItem")}else if(I===0){L.addStyleClass("sapMUCListFirstItem")}else if(I===m){L.addStyleClass("sapMUCListLastItem")}else{L.addStyleClass("sapMUCListItem")}t._oList.addAggregation("items",L,true)})};U.prototype._clearList=function(){if(this._oList){this._oList.destroyAggregation("items",true)}};U.prototype._getNumberOfAttachmentsLabel=function(i){var n=i||0;if(!this.oNumberOfAttachmentsLabel){this.oNumberOfAttachmentsLabel=new sap.m.Label(this.getId()+"-numberOfAttachmentsLabel",{design:sap.m.LabelDesign.Standard,text:this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[n])})}else{this.oNumberOfAttachmentsLabel.setText(this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[n]))}return this.oNumberOfAttachmentsLabel};U.prototype._handleDelete=function(e,c){var p=e.getParameters();var I=c.getAggregation("items");var s=p.id.split("-deleteButton")[0];var d=null;var f="";var F;var m;c.sDeletedItemId=s;for(var i=0;i<I.length;i++){if(I[i].sId===s){d=i;break}}if(q.sap.byId(c.sId).hasClass("sapUiSizeCompact")){f="sapUiSizeCompact"}if(!!I[d]){F=I[d].getFileName();if(!F){m=this._oRb.getText("UPLOADCOLLECTION_DELETE_WITHOUT_FILENAME_TEXT")}else{m=this._oRb.getText("UPLOADCOLLECTION_DELETE_TEXT",F)}sap.m.MessageBox.show(m,{title:this._oRb.getText("UPLOADCOLLECTION_DELETE_TITLE"),actions:[sap.m.MessageBox.Action.OK,sap.m.MessageBox.Action.CANCEL],onClose:function(A){if(A===sap.m.MessageBox.Action.OK){c.fireFileDeleted({documentId:I[d].getDocumentId()});I[d]._status=U._toBeDeletedStatus}},dialogId:"messageBoxDeleteFile",styleClass:f})}};U.prototype._handleTerminate=function(e,c){var s="",u,f,L,d,i,j;if(q.sap.byId(c.sId).hasClass("sapUiSizeCompact")){s="sapUiSizeCompact"}u=this._splitString2Array(c._getFileUploader().getProperty("value"),c);f=new sap.m.List({});u.forEach(function(I){L=new sap.m.StandardListItem({title:I,icon:c._getIconFromFilename(I)});f.addAggregation("items",L,true)});d=new sap.m.Dialog({title:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TITLE"),content:[new sap.m.Text({text:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TEXT")}),f],buttons:[new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),press:function(){u=c._splitString2Array(c._getFileUploader().getProperty("value"),c);for(i=0;i<u.length;i++){for(j=0;j<c.aItems.length;j++){if(u[i]===c.aItems[j].getProperty("fileName")&&c.aItems[j]._status===U._displayStatus){c.fireFileDeleted({documentId:c.aItems[j].getDocumentId()});c.aItems[j]._status=U._toBeDeletedStatus;break}}}c._getFileUploader().abort();d.close()}}),new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),press:function(){d.close()}})],styleClass:s});d.open()};U.prototype._handleEdit=function(e,c){if(e.sId){var p=e.getParameters();var i=p.id;var I=i.split("-");var L=I.length;var s=I[L-2];c.aItems[s]._status="Edit";c.editModeItem=e.oSource.sId.split("-editButton")[0];c.invalidate()}};U.prototype._handleClick=function(e,c,s){if(e.target.id.lastIndexOf("editButton")>0){sap.m.UploadCollection.prototype._handleOk(e,c,s,false)}else if(e.target.id.lastIndexOf("cancelButton")>0){sap.m.UploadCollection.prototype._handleCancel(e,c,s)}else if(e.target.id.lastIndexOf("ia_imageHL")<0&&e.target.id.lastIndexOf("ia_iconHL")<0&&e.target.id.lastIndexOf("deleteButton")<0&&e.target.id.lastIndexOf("ta_editFileName")<0){if(e.target.id.lastIndexOf("ta_HL")>0){c.sFocusId=e.target.id}sap.m.UploadCollection.prototype._handleOk(e,c,s,true)}};U.prototype._handleOk=function(e,c,s,t){var T=true;var E=document.getElementById(s+"-ta_editFileName-inner");var n=E.value.replace(/^\s+/,"");if(!c.sFocusId){c.sFocusId=c.editModeItem+"-ta_HL"}if(n.length>0){var S=s.split("-").pop();c.aItems[S]._status=U._displayStatus;var o=c.aItems[S].getProperty("fileName");var f=U.prototype._splitFilename(o);if(f.name!=n){if(!c.getSameFilenameAllowed()){var i=sap.ui.getCore().byId(s+"-ta_editFileName");if(sap.m.UploadCollection.prototype._checkDoubleFileName(n+f.extension,c.aItems)){var d=c.aItems[S].errorState;var g=c.aItems[S].changedFileName;i.setProperty("valueState","Error",true);c.aItems[S]._status="Edit";c.aItems[S].errorState="Error";c.aItems[S].changedFileName=n;c.sErrorState="Error";T=false;if(d!="Error"||g!=n){c.invalidate()}}else{i.setValueState="";c.aItems[S].errorState=null;c.aItems[S].changedFileName=null;c.sErrorState=null;c.editModeItem=null;if(t){c.invalidate()}}}if(T){c.fireFileRenamed({documentId:c.aItems[S].getProperty("documentId"),fileName:n+f.extension})}}else{c.editModeItem=null;if(t){c.invalidate()}}}};U.prototype._handleCancel=function(e,c,s){var S=s.split("-").pop();c.aItems[S]._status=U._displayStatus;c.aItems[S].errorState=null;c.aItems[S].changedFileName=sap.ui.getCore().byId(s+"-ta_editFileName").getProperty("value");c.sFocusId=c.editModeItem+"-ta_HL";c.sErrorState=null;c.editModeItem=null;c.invalidate()};U.prototype._onChange=function(e){if(e){var t=this;var h,r,c,i,f;if(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version<=9){var n=e.getParameter("newValue");if(!n){return}f=n.split(/\" "/)[0];if(f.length===0){return}}else{c=e.getParameter("files").length;if(c===0){return}this._oFileUploader.removeAllHeaderParameters();this.removeAllHeaderParameters()}this._oFileUploader.removeAllParameters();this.removeAllParameters();this.fireChange(e);var p=this.getAggregation("parameters");if(p){q.each(p,function(d,g){var P=new sap.ui.unified.FileUploaderParameter({name:g.getProperty("name"),value:g.getProperty("value")});t._oFileUploader.addParameter(P)})}if(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version<=9){var I=new sap.m.UploadCollectionItem();I.setProperty("contributor",null);I.setDocumentId(null);I.setEnableDelete(true);I.setFileName(f);I.setMimeType(null);I._status=U._uploadingStatus;I._percentUploaded=0;I.setThumbnailUrl(null);I.setUploadedDate(null);I.setUrl(null);this.aItems.unshift(I);this.insertItem(I)}else{this._requestIdValue=this._requestIdValue+1;r=this._requestIdValue.toString();var H=this.getAggregation("headerParameters");for(i=0;i<c;i++){var I=new sap.m.UploadCollectionItem();I.setProperty("contributor",null);I.setDocumentId(null);I.setEnableDelete(true);I.setFileName(e.getParameter("files")[i].name);I.setMimeType(null);I._status=U._uploadingStatus;I._percentUploaded=0;I.setThumbnailUrl(null);I.setUploadedDate(null);I.setUrl(null);I._requestIdName=r;I.fileSize=e.getParameter("files")[i].size;this.aItems.unshift(I);this.insertItem(I)}if(H){q.each(H,function(d,g){var h=new sap.ui.unified.FileUploaderParameter({name:g.getProperty("name"),value:g.getProperty("value")});t._oFileUploader.addHeaderParameter(h)})}h=new sap.ui.unified.FileUploaderParameter({name:this._requestIdName,value:r});t._oFileUploader.addHeaderParameter(h)}}};U.prototype._onFileAllowed=function(e){};U.prototype._onFilenameLengthExceed=function(e){this.fireFilenameLengthExceed(e)};U.prototype._onFileSizeExceed=function(e){this.fireFileSizeExceed(e)};U.prototype._onTypeMissmatch=function(e){this.fireTypeMissmatch(e)};U.prototype._onUploadTerminated=function(e){if(e){var i;var r=this._getRequestId(e);var f=e.getParameter("fileName");var c=this.aItems.length;for(i=0;i<c;i++){if(this.aItems[i]===f&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===U._uploadingStatus){this.aItems.splice(i,1);this.removeItem(i);break}}this.fireUploadTerminated()}};U.prototype._onUploadComplete=function(e){if(e){var i,r,u,c;r=this._getRequestId(e);u=e.getParameter("fileName");if(!u){var d=(e.getSource().getProperty("value")).split(/\" "/);u=d[0]}c=this.aItems.length;for(i=0;i<c;i++){if(!r){if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._status===U._uploadingStatus){this.aItems[i]._status=U._displayStatus;break}}else if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===U._uploadingStatus){this.aItems[i]._status=U._displayStatus;break}}this.fireUploadComplete(e)}};U.prototype._onUploadProgress=function(e){if(e){var i,u,p,n,P,r,c;u=e.getParameter("fileName");r=this._getRequestId(e);n=Math.round(e.getParameter("loaded")/e.getParameter("total")*100);p=n.toString();p=this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[p]);c=this.aItems.length;for(i=0;i<c;i++){if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName==r&&this.aItems[i]._status===U._uploadingStatus){P=q.sap.byId(this.aItems[i].getId()+"-ta_progress");P.text(p);this.aItems[i]._percentUploaded=n;break}}}};U.prototype._getRequestId=function(e){var h,H,v;h=e.getParameter("requestHeaders");if(!h){return null}for(var j=0;j<h.length;j++){H=h[j].name;if(H==this._requestIdName){v=h[j].value}}return v};U.prototype._getFileUploader=function(){var t=this;if(!this._oFileUploader){var s=(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version<=9)?false:true;this._oFileUploader=new sap.ui.unified.FileUploader(this.getId()+"-uploader",{buttonOnly:true,buttonText:" ",enabled:this.getUploadEnabled(),fileType:this.getFileType(),icon:"sap-icon://add",iconFirst:false,maximumFilenameLength:this.getMaximumFilenameLength(),maximumFileSize:this.getMaximumFileSize(),mimeType:this.getMimeType(),multiple:false,name:"uploadCollection",uploadOnChange:true,uploadUrl:this.getUploadUrl(),useMultipart:false,sendXHR:s,change:function(e){t._onChange(e)},fileAllowed:function(e){t._onFileAllowed(e)},filenameLengthExceed:function(e){t._onFilenameLengthExceed(e)},fileSizeExceed:function(e){t._onFileSizeExceed(e)},typeMissmatch:function(e){t._onTypeMissmatch(e)},uploadAborted:function(e){t._onUploadTerminated(e)},uploadComplete:function(e){t._onUploadComplete(e)},uploadProgress:function(e){t._onUploadProgress(e)}})}return this._oFileUploader};U.prototype._getIconFromFilename=function(f){var F=this._splitFilename(f).extension;switch(F){case'.bmp':case'.jpg':case'.png':return'sap-icon://attachment-photo';case'.csv':case'.xls':case'.xlsx':return'sap-icon://excel-attachment';case'.doc':case'.docx':case'.odt':return'sap-icon://doc-attachment';case'.pdf':return'sap-icon://pdf-attachment';case'.ppt':case'.pptx':return'sap-icon://ppt-attachment';case'.txt':return'sap-icon://document-text';default:return'sap-icon://document'}};U.prototype._getThumbnail=function(t,f){if(t){return t}else{return this._getIconFromFilename(f)}};U.prototype._triggerLink=function(e,c){var L=null;var i;var I=e.getParameter("id");if(c.editModeItem){i=c.editModeItem.split("-").pop();sap.m.URLHelper.redirect(c.aItems[i].getProperty("url"),true);return}else{L=I.split(I.split("-").pop())[0]+"ta_filenameHL";sap.m.URLHelper.redirect(sap.ui.getCore().byId(L).getHref(),true)}};U.prototype.onkeydown=function(e){switch(e.keyCode){case q.sap.KeyCodes.F2:sap.m.UploadCollection.prototype._handleF2(e,this);break;case q.sap.KeyCodes.ESCAPE:sap.m.UploadCollection.prototype._handleESC(e,this);break;case q.sap.KeyCodes.DELETE:sap.m.UploadCollection.prototype._handleDEL(e,this);break;case q.sap.KeyCodes.ENTER:sap.m.UploadCollection.prototype._handleENTER(e,this);break;default:return}e.setMarked()};U.prototype._setFocusAfterDeletion=function(D,c){if(!D){return}var L=c.aItems.length;var s=null;if(L==0){var f=q.sap.byId(c._oFileUploader.sId);var F=f.find(":button");q.sap.focus(F)}else{var i=D.split("-").pop();if((L-1)>=i){s=D+"-ta_HL"}else{s=c.aItems.pop().sId+"-ta_HL"}sap.m.UploadCollection.prototype._setFocus2LineItem(s)}};U.prototype._setFocus2LineItem=function(f){if(!f){return}var $=q.sap.byId(f);var c=$.parentsUntil("ul");var d=c.filter("li");d.attr("tabIndex",-1);q.sap.focus(d)};U.prototype._handleENTER=function(e,c){var t;var L;if(c.editModeItem){t=e.target.id.split(c.editModeItem).pop()}else{t=e.target.id.split("-").pop()}switch(t){case"-ta_editFileName-inner":case"-okButton":sap.m.UploadCollection.prototype._handleOk(e,c,c.editModeItem,true);break;case"-cancelButton":e.preventDefault();sap.m.UploadCollection.prototype._handleCancel(e,c,c.editModeItem);break;case"-ia_iconHL":case"-ia_imageHL":var i=c.editModeItem.split("-").pop();sap.m.URLHelper.redirect(c.aItems[i].getProperty("url"),true);break;case"ia_iconHL":case"ia_imageHL":L=e.target.id.split(t)[0]+"ta_filenameHL";sap.m.URLHelper.redirect(sap.ui.getCore().byId(L).getHref(),true);break;default:if(t.substring(0,6)=="__item"){var s=q.sap.byId(t).find("[id$='ta_HL']")[0].id;L=s.split("ta_HL")[0]+"ta_filenameHL";sap.m.URLHelper.redirect(sap.ui.getCore().byId(L).getHref(),true);break}return}};U.prototype._handleDEL=function(e,c){if(!c.editModeItem){var o=q.sap.byId(e.target.id);var d=o.find("[id$='-deleteButton']");var D=sap.ui.getCore().byId(d[0].id);D.firePress()}};U.prototype._handleESC=function(e,c){if(c.editModeItem){c.sFocusId=c.editModeItem+"-ta_HL";c.aItems[c.editModeItem.split("-").pop()]._status=U._displayStatus;sap.m.UploadCollection.prototype._handleCancel(e,c,c.editModeItem)}};U.prototype._handleF2=function(e,c){var o=sap.ui.getCore().byId(e.target.id);var d=q.sap.byId(e.target.id);if(o!=undefined){if(o._status==U._displayStatus){d=q.sap.byId(e.target.id);var f=d.find("[id$='-editButton']");var E=sap.ui.getCore().byId(f[0].id);if(E.getEnabled()){if(c.editModeItem){sap.m.UploadCollection.prototype._handleClick(e,c,c.editModeItem)}E.firePress()}}else{sap.m.UploadCollection.prototype._handleClick(e,c,c.editModeItem)}}else{if(e.target.id.search(c.editModeItem)==0){sap.m.UploadCollection.prototype._handleOk(e,c,c.editModeItem,true)}}};U.prototype._splitString2Array=function(s,c){if(c.getMultiple()==true&&!(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version<=9)){s=s.substring(1,s.length-2)}return s.split(/\" "/)};U.prototype._checkDoubleFileName=function(f,I){if(I.length==0||!f){return false}var L=I.length;f=f.replace(/^\s+/,"");for(var i=0;i<L;i++){if(f==I[i].getProperty("fileName")){return true}}return false};U.prototype._splitFilename=function(f){var r={};var n=f.split(".");r.extension="."+n.pop();r.name=n.join(".");return r};return U},true);
