/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Control','./IconPool','./library'],function(q,C,I,l){"use strict";var a=C.extend("sap.ui.core.Icon",{metadata:{library:"sap.ui.core",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},hoverColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},activeColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true}},events:{press:{}}}});a.prototype.onAfterRendering=function(){var i=this.$();if(this.hasListeners("press")){i.css("cursor","pointer")}if(i.css("cursor")==="auto"){i.css("cursor","default")}};a.prototype.onmousedown=function(e){this._bPressFired=false;if(this.hasListeners("press")||this.hasListeners("tap")){e.setMarked()}var A=this.getActiveColor(),s=this.getActiveBackgroundColor(),i;if(A||s){if(!e.targetTouches||(e.targetTouches&&e.targetTouches.length===1)){i=this.$();i.addClass("sapUiIconActive");if(A){i.css("color",A)}if(s){i.css("background-color",s)}}}};a.prototype.ontouchstart=a.prototype.onmousedown;a.prototype.onmouseup=function(e){if(!e.targetTouches||(e.targetTouches&&e.targetTouches.length===0)){this.$().removeClass("sapUiIconActive");this._restoreColors()}};a.prototype.ontouchend=a.prototype.onmouseup;a.prototype.ontouchcancel=a.prototype.onmouseup;a.prototype.onmouseover=function(){var h=this.getHoverColor(),H=this.getHoverBackgroundColor(),i=this.$();if(h){i.css("color",h)}if(H){i.css("background-color",H)}};a.prototype.onmouseout=function(){this._restoreColors()};a.prototype.onclick=function(){if(this._bPressFired){return}this.firePress({});this._bPressFired=true};a.prototype.ontap=a.prototype.onclick;a.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.preventDefault();var i=this.$(),A=this.getActiveColor(),s=this.getActiveBackgroundColor();i.addClass("sapUiIconActive");if(A){i.css("color",A)}if(s){i.css("background-color",s)}}};a.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors();this.firePress({})}};a.prototype._restoreColors=function(){this.$().css({"color":this.getColor()||"","background-color":this.getBackgroundColor()||""})};a.prototype.setSrc=function(s){var i=I.getIconInfo(s),t=sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<9,$=this.$();if(i){$.css("font-family",i.fontFamily);if(t){$.text(i.content)}else{$.attr("data-sap-ui-icon-content",i.content)}$.toggleClass("sapUiIconMirrorInRTL",!i.suppressMirroring)}this.setProperty("src",s,!!i);return this};a.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this};a.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css({"height":h,"line-height":h});return this};a.prototype.setSize=function(s){this.setProperty("size",s,true);this.$().css("font-size",s);return this};a.prototype.setColor=function(c){this.setProperty("color",c,true);this.$().css("color",c);return this};a.prototype.setActiveColor=function(c){return this.setProperty("activeColor",c,true)};a.prototype.setHoverColor=function(c){return this.setProperty("hoverColor",c,true)};a.prototype.setBackgroundColor=function(c){this.setProperty("backgroundColor",c,true);this.$().css("background-color",c);return this};a.prototype.setActiveBackgroundColor=function(c){return this.setProperty("activeBackgroundColor",c,true)};a.prototype.setHoverBackgroundColor=function(c){return this.setProperty("hoverBackgroundColor",c,true)};a.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.splice(0,0,"press");this.$().css("cursor","pointer");return C.prototype.attachEvent.apply(this,m)};a.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.splice(0,0,"press");C.prototype.detachEvent.apply(this,m);if(!this.hasListeners("press")){this.$().css("cursor","default")}return this};return a},true);
