/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/LocaleData'],function(q,L){"use strict";var N=sap.ui.base.Object.extend("sap.ui.core.format.NumberFormat",{constructor:function(f){throw new Error()}});N.INTEGER=0;N.FLOAT=1;N.CURRENCY=2;N.PERCENT=3;var r={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var R={};R[r.FLOOR]=Math.floor;R[r.CEILING]=Math.ceil;R[r.TOWARDS_ZERO]=function(n){return n>0?Math.floor(n):Math.ceil(n)};R[r.AWAY_FROM_ZERO]=function(n){return n>0?Math.ceil(n):Math.floor(n)};R[r.HALF_TOWARDS_ZERO]=function(n){return n>0?Math.ceil(n-0.5):Math.floor(n+0.5)};R[r.HALF_AWAY_FROM_ZERO]=function(n){return n>0?Math.floor(n+0.5):Math.ceil(n-0.5)};R[r.HALF_FLOOR]=function(n){return Math.ceil(n-0.5)};R[r.HALF_CEILING]=Math.round;N.RoundingMode=r;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:N.INTEGER,showMeasure:false,style:"standard",roundingMode:N.RoundingMode.TOWARDS_ZERO};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:N.FLOAT,showMeasure:false,style:"standard",roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:N.PERCENT,showMeasure:false,style:"standard",roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:2,maxFractionDigits:2,groupingEnabled:true,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:N.CURRENCY,showMeasure:true,style:"standard",roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO};N.getInstance=function(f,l){return this.getFloatInstance(f,l)};N.getFloatInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,N.FLOAT);F.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,o,f);if(f&&f.pattern){F.oFormatOptions=q.extend(false,F.oFormatOptions,this.parseNumberPattern(f.pattern))}return F};N.getIntegerInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,N.INTEGER);F.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,o,f);if(f&&f.pattern){F.oFormatOptions=q.extend(false,F.oFormatOptions,this.parseNumberPattern(f.pattern))}return F};N.getCurrencyInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,N.CURRENCY);F.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,o,f);if(f&&f.pattern){F.oFormatOptions=q.extend(false,F.oFormatOptions,this.parseNumberPattern(f.pattern))}return F};N.getPercentInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,N.PERCENT);F.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,o,f);if(f&&f.pattern){F.oFormatOptions=q.extend(false,F.oFormatOptions,this.parseNumberPattern(f.pattern))}return F};N.createInstance=function(f,l){var F=q.sap.newObject(this.prototype);if(f instanceof sap.ui.core.Locale){l=f;f=undefined}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()}F.oLocale=l;F.oLocaleData=L.getInstance(l);return F};N.getLocaleFormatOptions=function(l,t){var o={},n;if(t==N.CURRENCY){n=l.getCurrencyPattern();o=this.parseNumberPattern(n)}o.plusSign=l.getNumberSymbol("plusSign");o.minusSign=l.getNumberSymbol("minusSign");o.decimalSeparator=l.getNumberSymbol("decimal");o.groupingSeparator=l.getNumberSymbol("group");o.percentSign=l.getNumberSymbol("percentSign");o.pattern=n;return o};N.parseNumberPattern=function(f){var m=0;var M=0;var c=0;var G=false;var S=0;for(var i=0;i<f.length;i++){var C=f[i];if(C===","){G=true;continue}else if(C==="."){S=1;continue}else if(S==0&&C==="0"){m++}else if(S==1){if(C==="0"){M++;c++}else if(C==="#"){c++}}}return{minIntegerDigits:m,minFractionDigits:M,maxFractionDigits:c,groupingEnabled:G}};N.prototype.format=function(v,m){var i="",f="",G="",c="",n="",p="",P=0,l=0,d=v<0,D=-1,o=this.oFormatOptions,e;var S=g(v,this.oFormatOptions.style,this.oLocaleData);if(S){v=v/S.magnitude;if(S.decimals!==undefined){o.maxFractionDigits=o.maxFractionDigits||S.decimals;o.minFractionDigits=o.minFractionDigits||S.decimals}}if(o.type==N.PERCENT){v=s(+v,2)}if(o.type==N.CURRENCY){var h=this.oLocaleData.getCurrencyDigits(m);o.maxFractionDigits=h;o.minFractionDigits=h}if(typeof v=="number"){v=b(v,o)}n=this.convertToDecimal(v);if(n=="NaN"){return n}if(d){n=n.substr(1)}D=n.indexOf(".");if(D>-1){i=n.substr(0,D);f=n.substr(D+1)}else{i=n}if(i.length<o.minIntegerDigits){i=q.sap.padLeft(i,"0",o.minIntegerDigits)}else if(i.length>o.maxIntegerDigits){i=q.sap.padLeft("","?",o.maxIntegerDigits)}if(f.length<o.minFractionDigits){f=q.sap.padRight(f,"0",o.minFractionDigits)}else if(f.length>o.maxFractionDigits){f=f.substr(0,o.maxFractionDigits)}l=i.length;if(o.groupingEnabled&&l>3){P=l%3||3;G=i.substr(0,P);while(P<i.length){G+=o.groupingSeparator;G+=i.substr(P,3);P+=3}i=G}if(d){c=o.minusSign}c+=i;if(f){c+=o.decimalSeparator+f}if(S&&S.formatString){c=S.formatString.replace(S.valueSubString,c);c=c.replace(/'.'/g,".")}if(m&&o.showMeasure){if(o.type==N.CURRENCY){p=o.pattern;e=p.split(";");if(e.length===2){p=d?e[1]:e[0];if(d){c=c.substring(1)}}p=p.replace(/\u00a4/,this.oLocaleData.getCurrencySymbol(m));if(d){p=p.replace(/-/,o.minusSign)}p=p.replace(/[0#.,]+/,c);c=p}}if(o.type==N.PERCENT){p=this.oLocaleData.getPercentPattern();c=p.replace(/[0#.,]+/,c);c=c.replace(/%/,this.oFormatOptions.percentSign)}if(sap.ui.getCore().getConfiguration().getOriginInfo()){c=new String(c);c.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()}}return c};N.prototype.parse=function(v){var o=this.oFormatOptions,c="^\\s*([+-]?(?:[0-9\\"+o.groupingSeparator+"]+|[0-9\\"+o.groupingSeparator+"]*\\"+o.decimalSeparator+"[0-9]+)([eE][+-][0-9]+)?)\\s*$",d="^\\s*([+-]?[0-9\\"+o.groupingSeparator+"]+)\\s*$",G=new RegExp("\\"+o.groupingSeparator,"g"),D=new RegExp("\\"+o.decimalSeparator,"g"),p=this.oLocaleData.getPercentPattern(),P=this.oLocaleData.getNumberSymbol("percentSign"),e,f,h=0;if(p.charAt(0)==="%"){c=c.slice(0,1)+"%?"+c.slice(1)}else if(p.charAt(p.length-1)==="%"){c=c.slice(0,c.length-1)+"%?"+c.slice(c.length-1)}v=v.replace(/\s/g,"");var S=a(v,this.oFormatOptions.style,this.oLocaleData);v=S.number;if(o.isInteger){e=new RegExp(d)}else{e=new RegExp(c)}if(!e.test(v)){return NaN}v=v.replace(G,"");if(o.isInteger){h=parseInt(v,10)}else{v=v.replace(D,".");if(v.indexOf(P)!==-1){f=true;v=v.replace(P,"")}h=parseFloat(v);if(f){h=s(h,-2)}}if(S.factor>1){h=h*S.factor}return h};N.prototype.convertToDecimal=function(v){var V=""+v,n,B,d,f,e,p;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V}var c=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);n=c[1]=="-";B=c[2].replace(/\./g,"");d=c[3]?c[3].length:0;f=c[4]?c[4].length:0;e=parseInt(c[5],10);if(e>0){if(e<f){p=d+e;V=B.substr(0,p)+"."+B.substr(p)}else{V=B;e-=f;for(var i=0;i<e;i++){V+="0"}}}else{if(-e<d){p=d+e;V=B.substr(0,p)+"."+B.substr(p)}else{V=B;e+=d;for(var i=0;i>e;i--){V="0"+V}V="0."+V}}if(n){V="-"+V}return V};function g(v,S,l){var o;if(S!="short"&&S!="long"){return o}var k=1;while(Math.abs(v)>=k*10&&k<1e14){k=k*10}var f=v/k;var p="other";if(f==0){p="zero"}else if(f==1){p="one"}else if(f==2){p="two"}else if(f>2&&f<=5){p="few"}else if(f>5&&f<=10){p="many"}var c=l.getDecimalFormat(S,k.toString(),p);if(!c){return o}o={};if(!c||c=="0"){o.magnitude=1}else{o.formatString=c;var m=c.match(/0+\.*0*/);if(m){o.valueSubString=m[0];var d=o.valueSubString.indexOf(".");if(d==-1){o.decimals=0;o.magnitude=k*Math.pow(10,1-o.valueSubString.length)}else{o.decimals=o.valueSubString.length-d-1;o.magnitude=k*Math.pow(10,1-d)}}else{o.magnitude=1}}return o}function a(v,S,l){var n;var f=1;if(S!="short"&&S!="long"){return{number:v,factor:f}}var k=10;var p;var c;while(k<1e14){for(var i=0;i<6;i++){switch(i){case 0:p="zero";break;case 1:p="one";break;case 2:p="two";break;case 3:p="few";break;case 4:p="many";break;default:p="other"}c=l.getDecimalFormat(S,k.toString(),p);if(c){c=c.replace(/[\s\u00a0]/g,"");var m=c.match(/0+\.*0*/);if(m){var V=m[0];var u=c.replace(V,"");var I=v.indexOf(u);if(I>=0){n=v.replace(u,"");f=k;break}}}}if(n){break}k=k*10}if(!n){n=v}return{number:n,factor:f}}function b(v,o){if(typeof v!=="number"){return NaN}var c=o.roundingMode||N.RoundingMode.HALF_AWAY_FROM_ZERO;if(typeof c==="function"){v=c(v,o.maxFractionDigits)}else{if(!o.maxFractionDigits){return R[c](v)}v=s(R[c](s(v,o.maxFractionDigits)),-o.maxFractionDigits)}return v}function s(v,S){if(typeof v!=="number"||typeof S!=="number"){return NaN}var e=v.toString().split("e");S=e[1]?(+e[1]+S):S;return+(e[0]+"e"+S)}return N},true);
