/*!
 * @copyright@
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Sorter','sap/ui/model/FilterOperator','./odata4analytics'],function(Q,T,C,S,F,a){"use strict";var A=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,c,s,f,P){T.call(this,m,p,c,f,P);this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(f);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=true;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.mEntityKey={};this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.")}this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==sap.ui.model.odata.CountMode.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options")}else if(P&&(P.countMode==sap.ui.model.odata.CountMode.Request||P.countMode==sap.ui.model.odata.CountMode.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options")}else if(this.oModel.sDefaultCountMode==sap.ui.model.odata.CountMode.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options")}this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this.updateAnalyticalInfo(P==undefined?[]:P.analyticalInfo)}});A.prototype.getRootContexts=function(p){var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(A._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r}r=this._getContextsForParentContext(null);if(r.length==1){return r}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(A._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0})}}else{var b=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);b.push(R);this._considerRequestGrouping(b);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels})}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry")}return r};A.prototype.getNodeContexts=function(c,p){var s,l,t,L,n;if(typeof p=="object"){s=p.startIndex;l=p.length;t=p.threshold;L=p.level;n=p.numberOfExpandedLevels}else{s=arguments[1];l=arguments[2];t=arguments[3];L=arguments[4];n=arguments[5]}var b=this._getContextsForParentContext(c,s,l,t,L,n);return b};A.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};A.prototype.hasAvailableNodeContexts=function(c,l){var g=this._getGroupIdFromContext(c,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return A.prototype.ContextsAvailabilityStatus.ALL}else{return A.prototype.ContextsAvailabilityStatus.SOME}}else{return A.prototype.ContextsAvailabilityStatus.NONE}};A.prototype.getGroupSize=function(c,l){if(c===undefined){return 0}var g=this._getGroupIdFromContext(c,l);return this.mFinalLength[g]?this.mLength[g]:-1};A.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked")}return this.iTotalSize};A.prototype.hasChildren=function(c,p){if(c===undefined){return false}if(c==null){return true}var i=p.level;if(i==0){return true}if(this.aAggregationLevel.length<i){return false}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1};A.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break}}return h};A.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet};A.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet};A.prototype.hasGrandTotalDisplayed=function(){return this.bProvideGrandTotals};A.prototype.getProperty=function(p){return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p)};A.prototype.getFilterablePropertyNames=function(){return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames()};A.prototype.getSortablePropertyNames=function(){return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames()};A.prototype.getPropertyLabel=function(p){return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p)};A.prototype.getPropertyHeading=function(p){return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p)};A.prototype.getPropertyQuickInfo=function(p){return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p)};A.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1};A.prototype.filter=function(f,s){f=this._convertDeprecatedFilterObjects(f);if(s==sap.ui.model.FilterType.Application){this.aApplicationFilter=f}else{this.aControlFilter=f}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Filter});return this};A.prototype.sort=function(s){if(s instanceof S){s=[s]}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Sort});return this};A.prototype.getGroupName=function(c,l){if(c===undefined){return""}var g=this.aAggregationLevel[l-1],d=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),v=this.mAnalyticalInfoByProperty[g].formatter,p=c.getProperty(g),t,f,G;if(d&&this.oDimensionDetailsSet[g].textPropertyName){t=d.getTextProperty()}var s,b,e;if(t){s=d.getTextProperty().name;e=this.mAnalyticalInfoByProperty[s].formatter;b=c.getProperty(s)}if(!t){f=v?v(p):p;G=((d.getLabelText())?d.getLabelText()+': ':'')+f}else{f=v?v(p,b):p;G=((d.getLabelText())?d.getLabelText()+': ':'')+f;var h=e?e(b,p):b;if(h){G+=' - '+h}}return G};A.prototype.updateAnalyticalInfo=function(c){var p=this.oDimensionDetailsSet;this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};for(var i=0;i<c.length;i++){var d=this.oAnalyticalQueryResult.findDimensionByPropertyName(c[i].name);if(d&&(c[i].inResult==true||c[i].visible==true)){c[i].dimensionPropertyName=d.getName();var D=this.oDimensionDetailsSet[d.getName()];if(!D){D={};D.name=d.getName();D.aAttributeName=[];D.grouped=false;this.oDimensionDetailsSet[d.getName()]=D;this.aMaxAggregationLevel.push(D.name);if(c[i].grouped==true){this.aAggregationLevel.push(D.name)}}if(c[i].grouped==true){if(Q.inArray(d.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+d.getName()+" must be sortable in order to be used as grouped dimension")}D.grouped=true}if(d.getName()==c[i].name){D.keyPropertyName=c[i].name}var t=d.getTextProperty();if(t&&t.name==c[i].name){D.textPropertyName=c[i].name}if(d.findAttributeByName(c[i].name)){D.aAttributeName.push(c[i].name)}D.analyticalInfo=c[i]}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(c[i].name);if(m&&(c[i].inResult==true||c[i].visible==true)){c[i].measurePropertyName=m.getName();var M=this.oMeasureDetailsSet[m.getName()];if(!M){M={};M.name=m.getName();this.oMeasureDetailsSet[m.getName()]=M;this.aMeasureName.push(M.name)}if(m.getRawValueProperty().name==c[i].name){M.rawValuePropertyName=c[i].name}var f=m.getFormattedValueProperty();if(f&&f.name==c[i].name){M.formattedValuePropertyName=c[i].name}M.analyticalInfo=c[i]}this.mAnalyticalInfoByProperty[c[i].name]=c[i]}for(var b in this.oMeasureDetailsSet){var u=this.oAnalyticalQueryResult.findMeasureByName(b).getUnitProperty();if(u){this.oMeasureDetailsSet[b].unitPropertyName=u.name}}var e=function(o){var n=[];for(var g in o)n.push(g.name);return n.sort().join(";")};if(e(p)!=e(this.oDimensionDetailsSet)){this.iTotalSize=-1}this.aAnalyticalInfo=c;this.resetData();this.bNeedsUpdate=false};A.prototype.getAnalyticalInfoForColumn=function(c){return this.mAnalyticalInfoByProperty[c]};A.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var b=g[s];for(var i=0;i<b.length;i++){var o=b[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold)}var r=[];for(var j=-1,c;(c=G[++j])!==undefined;){r.push(this._getRequestId(A._requestType.groupMembersQuery,{groupId:c}))}this._considerRequestGrouping(r)}};A.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult};A._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};A._artificialRootContextGroupId="artificialRootContext";A.prototype._getContextsForParentContext=function(p,s,l,t,L,n){if(p===undefined){return[]}if(p&&p.getPath()=="/"+A._artificialRootContextGroupId){p=this.getModel().getContext("/")}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,t,n)};A.prototype._getContextsForParentGroupId=function(p,s,l,t,n){if(p===undefined){return[]}if(!s){s=0}if(!l){l=this.oModel.iSizeLimit}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed")}}if(!t){t=0}if(!n){n=0}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1}}var c=[],L,g,G,m;var b=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[b]){this.aMultiUnitLoadFactor[b]=1}var d=n>0&&p!=null;if(d){var M=this._getGroupIdLevel(p);var e=M+n;G=this._calculateRequiredGroupExpansion(p,e,s,l+t);var D=G.groupId_Missing==null;D=D||G.groupId_Missing.length<p.length||G.groupId_Missing.substring(0,p.length)!=p;if(D){c=this._getLoadedContextsForGroup(p,s,l)}else{m=l+t}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[b])}else{c=this._getLoadedContextsForGroup(p,s,l);g=this._calculateRequiredGroupSection(p,s,l,t,c);var P=g.length>0&&l<g.length;L=(c.length!=l&&!(this.mFinalLength[p]&&c.length>=this.mLength[p]-s))||P;g.length=Math.ceil(g.length*this.aMultiUnitLoadFactor[b])}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(A._requestType.groupMembersQuery,{groupId:p}))}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(A._requestType.totalSizeQuery));E=true;var f;if(this.bUseBatchRequests){if(d){f=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,r;(r=f[++i])!==undefined;){if(this._isRequestPending(r)){E=false;break}}if(E){this.aBatchRequestQueue.push([A._requestType.groupMembersAutoExpansionQuery,p,G,m,n])}}else{E=!this._isRequestPending(this._getRequestId(A._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([A._requestType.groupMembersQuery,p,g.startIndex,g.length]);f=[this._getRequestId(A._requestType.groupMembersQuery,{groupId:p})]}}if(E&&N){f.push(this._getRequestId(A._requestType.totalSizeQuery));this._considerRequestGrouping(f);this.aBatchRequestQueue.push([A._requestType.totalSizeQuery])}if(E){if(p==null){this._abortAllPendingRequests()}Q.sap.delayedCall(0,this,A.prototype._processRequestQueue)}}else{var o;if(d){f=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,h;(h=f[++j])!==undefined;){if(this._isRequestPending(h)){E=false;break}}if(E){o=this._prepareGroupMembersAutoExpansionQueryRequest(A._requestType.groupMembersAutoExpansionQuery,p,G,m,n)}}else{E=!this._isRequestPending(this._getRequestId(A._requestType.groupMembersQuery,{groupId:p}));if(E){o=this._prepareGroupMembersQueryRequest(A._requestType.groupMembersQuery,p,g.startIndex,g.length);f=[o.sRequestId]}}if(E){if(p==null){this._abortAllPendingRequests()}this._executeQueryRequest(o);if(N&&!o.bIsFlatListRequest){f.push(this._getRequestId(A._requestType.totalSizeQuery));this._considerRequestGrouping(f);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(A._requestType.totalSizeQuery))}}}}}return c};A.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[]}if(r.length==0){return}var R=[];var f=false;var i,o,b;for(i=-1;(b=r[++i])!==undefined;){if(b[0]==A._requestType.groupMembersQuery){o=A.prototype._prepareGroupMembersQueryRequest.apply(this,b);f=f||o.bIsFlatListRequest;R.push(o)}}for(i=-1;(b=r[++i])!==undefined;){o=null;switch(b[0]){case A._requestType.groupMembersQuery:continue;case A._requestType.totalSizeQuery:if(!f){o=A.prototype._prepareTotalSizeQueryRequest.apply(this,b);R.push(o)}break;case A._requestType.groupMembersAutoExpansionQuery:o=A.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,b);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l)}break;case A._requestType.reloadMeasuresQuery:{var c=b[1];for(var k=-1,d;(d=c[++k])!==undefined;){R.push(d)}break}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue}}if(R.length>1){this._executeBatchRequest(R)}else{this._executeQueryRequest(R[0])}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[]}};A.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[];var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var c=0,b=-1;if(g){G=this._getGroupIdComponents(g);c=b=G.length;var u=0;for(var j=0,d=0;j<c;d++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[d]].grouped==false){++u}else{++j}}c=b=c+u;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[b]].grouped==false){if(++b==this.aMaxAggregationLevel.length){break}}}}var I=b>=this.aMaxAggregationLevel.length-1;var e=this.aMaxAggregationLevel.slice(0,b+1);o.setAggregationLevel(e);for(var i=0;i<e.length;i++){var D=this.oDimensionDetailsSet[e[i]];var f=(D.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(D.name,true,f,D.aAttributeName);if(D.grouped){o.getSortExpression().addSorter(e[i],a.SortOrder.Ascending)}}var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter)}if(c>=1){for(var k=0,l=G.length;k<l;k++){h.removeConditions(this.aAggregationLevel[k]);h.addCondition(this.aAggregationLevel[k],F.EQ,G[k])}}var p;var q;var t;var M;var v=[];if(g!=null||this.bProvideGrandTotals){o.setMeasures(this.aMeasureName);for(var w in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[w];if(!I&&this.mAnalyticalInfoByProperty[w].total==false){p=false;q=false;t=false}else{p=(M.rawValuePropertyName!=undefined);q=(M.formattedValuePropertyName!=undefined);t=(M.unitPropertyName!=undefined);if(t){if(Q.inArray(M.unitPropertyName,v)==-1){v.push(M.unitPropertyName)}}}o.includeMeasureRawFormattedValueUnit(M.name,p,q,t)}for(var n in e){var x;if((x=Q.inArray(e[n],v))!=-1){v.splice(x,1)}}}var y=o.getSortExpression();for(var m=0;m<this.aSorter.length;m++){if(this.aSorter[m]){y.addSorter(this.aSorter[m].sPath,this.aSorter[m].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending)}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group")}var K=this._getKeyIndexMapping(g,s);o.setResultPageBoundaries(K.iServiceKeyIndex+1,K.iServiceKeyIndex+L);o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(A._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:v,aAggregationLevel:e,bIsFlatListRequest:I&&c==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:K}};A.prototype._prepareTotalSizeQueryRequest=function(r){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.setAggregationLevel(this.aMaxAggregationLevel);o.setMeasures([]);var f=o.getFilterExpression();f.clear();if(this.aApplicationFilter){f.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){f.addUI5FilterConditions(this.aControlFilter)}o.setResultPageBoundaries(1,1);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(A._requestType.totalSizeQuery),oAnalyticalQueryRequest:o}};A.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var t=this;var p=function(G,d){var h=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return h}var e=t._getGroupIdComponents(G.groupId_Missing);var f=e.length;if(f>d){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return h}var k=[];for(var i=0;i<f;i++){var l=t.aAggregationLevel[i];var V=e[i];var E=t._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new sap.ui.model.Filter(l,E,V)}var K=null;if(G.startIndex_Missing>0){var N=t._getKey(G.groupId_Missing,G.startIndex_Missing-1);var O=t.oModel.getObject("/"+N);var U=t.aAggregationLevel[f];var W=O[U];K=new sap.ui.model.Filter(U,t._getFilterOperatorMatchingPropertySortOrder(U,false),W)}for(var m=0;m<d;m++){var X=[];var Y=Math.min(f,m+1);for(var Z=0;Z<Y;Z++){var $=[];var _=Math.min(f,Z+1);var a1=G.startIndex_Missing>0;for(var b1=0;b1<_;b1++){var c1=new sap.ui.model.Filter("x",sap.ui.model.FilterOperator.EQ,"x");c1=Q.extend(true,c1,k[b1]);if(_>1&&b1<_-1){c1.sOperator=sap.ui.model.FilterOperator.EQ}if(b1==f-1&&m>f-1&&!a1){if(c1.sOperator==sap.ui.model.FilterOperator.GT){c1.sOperator=sap.ui.model.FilterOperator.GE}else{c1.sOperator=sap.ui.model.FilterOperator.LE}}$.push(c1)}if($.length>0){X.push(new sap.ui.model.Filter($,true));if(m>f-1&&Z==f-1&&a1){var d1=[];for(var j=0;j<$.length;j++){var e1=new sap.ui.model.Filter("x",sap.ui.model.FilterOperator.EQ,"x");e1=Q.extend(true,e1,$[j]);d1.push(e1)}d1[f-1].sOperator=sap.ui.model.FilterOperator.EQ;d1.push(K);X.push(new sap.ui.model.Filter(d1,true));break}}}if(X.length>0){h[m]=new sap.ui.model.Filter(X,false)}else{h[m]=null}}return h};var b=function(r,g,m,K,o,L,N,U){var O=new a.QueryResultRequest(t.oAnalyticalQueryResult);O.setResourcePath(t._getResourcePath());O.getSortExpression().clear();var V=0,W=-1;V=W=m-1;var X=0;for(var i=0,Y=0;i<V;Y++){if(t.oDimensionDetailsSet[t.aMaxAggregationLevel[Y]].grouped==false){++X}else{++i}}V=W=V+X;if(t.aMaxAggregationLevel.length>0){while(t.oDimensionDetailsSet[t.aMaxAggregationLevel[W]].grouped==false){if(++W==t.aMaxAggregationLevel.length){break}}}var Z=W>=t.aMaxAggregationLevel.length-1;var $=t.aMaxAggregationLevel.slice(0,W+1);O.setAggregationLevel($);for(var l=0;l<$.length;l++){var _=t.oDimensionDetailsSet[$[l]];var a1=(_.textPropertyName!=undefined);O.includeDimensionKeyTextAttributes(_.name,true,a1,_.aAttributeName);if(_.grouped){O.getSortExpression().addSorter($[l],a.SortOrder.Ascending)}}var b1=O.getFilterExpression();b1.clear();if(t.aApplicationFilter){b1.addUI5FilterConditions(t.aApplicationFilter)}if(t.aControlFilter){b1.addUI5FilterConditions(t.aControlFilter)}b1.addUI5FilterConditions(K);var c1;var d1;var e1;var f1;var g1=[];O.setMeasures(t.aMeasureName);for(var h1 in t.oMeasureDetailsSet){f1=t.oMeasureDetailsSet[h1];if(!Z&&t.mAnalyticalInfoByProperty[h1].total==false){c1=false;d1=false;e1=false}else{c1=(f1.rawValuePropertyName!=undefined);d1=(f1.formattedValuePropertyName!=undefined);e1=(f1.unitPropertyName!=undefined);if(e1){if(Q.inArray(f1.unitPropertyName,g1)==-1){g1.push(f1.unitPropertyName)}}}O.includeMeasureRawFormattedValueUnit(f1.name,c1,d1,e1)}for(var j in $){var i1;if((i1=Q.inArray($[j],g1))!=-1){g1.splice(i1,1)}}var j1=O.getSortExpression();for(var k=0;k<t.aSorter.length;k++){if(t.aSorter[k]){j1.addSorter(t.aSorter[k].sPath,t.aSorter[k].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending)}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group")}var k1=o;if(!U){k1=0}O.setResultPageBoundaries(k1+1,k1+L);return{iRequestType:r,sRequestId:t._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:m}),oAnalyticalQueryRequest:O,iLevel:m,aSelectedUnitPropertyName:g1,aAggregationLevel:$,bIsFlatListRequest:Z,bIsLeafGroupsRequest:Z,iStartIndex:o,iLength:L,bAvoidLengthUpdate:N}};var c=[];var R=[];if(G&&this.bUseAcceleratedAutoExpand){var d=this._getGroupIdLevel(g)+n+1;var e=t._getGroupIdComponents(G.groupId_Missing);var f=e.length;var h=p(G,d);var s;for(var m=1;m<=d;m++){var o;if(m>=f+2){o=0;s=undefined}else if(m==f+1){o=G.startIndex_Missing;s=G.groupId_Missing}else if(f>0){if(m==f){s=G.groupId_Missing}else{s=this._getGroupIdAncestors(G.groupId_Missing,-(f-m))[0]}var q=this._getGroupIdAncestors(G.groupId_Missing,-(f-m+1))[0];if(!q){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+m)}o=this._findKeyIndex(q,this.mEntityKey[s]);if(o==-1){Q.sap.log.fatal("failed to determine position of value "+s+" in group "+q)}s=q;o++}var u=L>m?Math.ceil((L-m)/(d-m+1)):L;var v=h[m-1]?[h[m-1]]:[];var w=b(A._requestType.levelMembersQuery,g,m,v,o,u,false,false);w.sGroupId_Missing_AtLevel=s;c.push(w);R.push(this._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:m}))}}else{var M=this._getGroupIdLevel(g)+1;var x=M+n;var y=[];var z=this._getGroupIdComponents(g);for(var i=0;i<z.length;i++){y.push(new sap.ui.model.Filter(this.aAggregationLevel[i],sap.ui.model.FilterOperator.EQ,z[i]))}var B=false;if(G){var P=this.aAggregationLevel[z.length];var D=this._getGroupIdComponents(G.groupId_Missing)[z.length];if(D){var E=this._getFilterOperatorMatchingPropertySortOrder(P,true);y.push(new sap.ui.model.Filter(P,E,D));B=true}}for(var H=M;H<=x;H++){var I=L>H?Math.ceil((L-H)/(x-H+1)):L;var J=b(A._requestType.levelMembersQuery,g,H,y,0,I,H==M?B:false,true);c.push(J);R.push(this._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:H}))}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:c,sGroupId:g,iLength:L}};A.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var b=g.aAggregationLevel;o.setAggregationLevel(b);var I=g.bIsLeafGroupsRequest;var f=o.getFilterExpression();f.clear();if(this.aApplicationFilter){f.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){f.addUI5FilterConditions(this.aControlFilter)}var c=[];for(var i=0;i<b.length;i++){var d=new sap.ui.model.Filter(b[i],sap.ui.model.FilterOperator.EQ,m.oEntry[b[i]]);c.push(d)}f.addUI5FilterConditions(c);var e;var h;var k;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var l in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[l];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue}if(!I&&this.mAnalyticalInfoByProperty[l].total==false){e=false;h=false;k=false}else{e=(M.rawValuePropertyName!=undefined);h=(M.formattedValuePropertyName!=undefined);k=(M.unitPropertyName!=undefined);if(k){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName)}}}o.includeMeasureRawFormattedValueUnit(M.name,e,h,k)}for(var j in b){var n;if((n=Q.inArray(b[j],s))!=-1){s.splice(n,1)}}return{iRequestType:r,sRequestId:this._getRequestId(A._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:b,oMultiUnitRepresentative:m}};A.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(A._requestType.levelMembersQuery,{groupId:g,level:l}))}return r};A.prototype._getQueryODataRequestOptions=function(o){try{o.getFilterExpression().checkValidity()}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined}var s=o.getURIQueryOptionValue("$select");var f=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var b=o.getURIQueryOptionValue("$skip");var t=o.getURIQueryOptionValue("$top");var i=o.getURIQueryOptionValue("$inlinecount");if(this.mParameters&&this.mParameters["filter"]){f+="and ("+this.mParameters["filter"]+")"}var p=[];if(s){p.push("$select="+s)}if(f){p.push("$filter="+f)}if(O){p.push("$orderby="+O)}if(b){p.push("$skip="+b)}if(t){p.push("$top="+t)}if(i){p.push("$inlinecount="+i)}return p};A.prototype._executeBatchRequest=function(r){var c=this.iAnalyticalInfoVersionNumber;var t=this;var b=[],e=[];function d(){t.fireDataReceived()}for(var i=-1,R;(R=r[++i])!==undefined;){var o=R.oAnalyticalQueryRequest,g=R.sGroupId;if(o.getURIQueryOptionValue("$select")==null){this.fireDataRequested();g=null;this.mServiceLength[g]=this.mLength[g]=1;this.mServiceFinalLength[g]=true;this._setServiceKey(this._getKeyIndexMapping(g,0),A._artificialRootContextGroupId);this.bNeedsUpdate=true;if(r.length==1){setTimeout(d)}this.bArtificalRootContext=true;continue}var p=o.getURIToQueryResultEntries();if(p.indexOf("/")==0){p=p.substring(1)}if(!this._isRequestPending(R.sRequestId)){this._registerNewRequest(R.sRequestId);b.push(this.oModel.createBatchOperation(p.replace(/\ /g,"%20"),"GET"));e.push(R)}}var f=this._getIdForNewRequestHandle();if(b.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+e.length+" operations");this.oModel.addBatchReadOperations(b);this.fireDataRequested();var h=this.oModel.submitBatch(s,E,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});this._registerNewRequestHandle(f,h)}function s(D,l){t._deregisterHandleOfCompletedRequest(f);if(e.length!=D.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+D.__batchResponses.length+" responses for "+e.length+" read operations in the batch request")}if(c!=t.iAnalyticalInfoVersionNumber){for(var j=-1,m;(m=e[++j].sRequestId)!==undefined;){t._deregisterCompletedRequest(m);t._cleanupGroupingForCompletedRequest(m)}return}for(var k=0;k<D.__batchResponses.length;k++){if(D.__batchResponses[k].data!=undefined){switch(e[k].iRequestType){case A._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(e[k],D.__batchResponses[k].data);break;case A._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(e[k],D.__batchResponses[k].data);break;case A._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(e[k],D.__batchResponses[k].data);break;case A._requestType.reloadMeasuresQuery:t._processReloadMeasurePropertiesQueryResponse(e[k],D.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+e[k].iRequestType);continue}}t._deregisterCompletedRequest(e[k].sRequestId);t._cleanupGroupingForCompletedRequest(e[k].sRequestId)}var O=true;var B=t.oModel._getBatchErrors(D);if(B.length>0){O=false}t.oModel.fireRequestCompleted({url:l.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:t.oModel._handleError(B[0])});if(O){t.oModel.checkUpdate()}t.fireDataReceived()}function E(k){t._deregisterHandleOfCompletedRequest(f);for(var j=-1,l;(l=e[++j])!==undefined;){t._deregisterCompletedRequest(l.sRequestId);t._cleanupGroupingForCompletedRequest(l.sRequestId)}if(c!=t.iAnalyticalInfoVersionNumber){return}t.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:t.oModel._handleError(k)});t.oModel.fireRequestFailed(t.oModel._handleError(k));t.fireDataReceived()}};A.prototype._executeQueryRequest=function(r){if(r.iRequestType==A._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o)}return}var c=this.iAnalyticalInfoVersionNumber;var b=r.oAnalyticalQueryRequest,g=r.sGroupId;var p=b.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(b);if(!P){return}var t=this;if(b.getURIQueryOptionValue("$select")==null){this.fireDataRequested();g=null;this.mServiceLength[g]=this.mLength[g]=1;this.mServiceFinalLength[g]=true;this._setServiceKey(this._getKeyIndexMapping(g,0),A._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(t._cleanupGroupingForCompletedRequest(r.sRequestId)){t.fireDataReceived()}});this.bArtificalRootContext=true;return}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20")}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();this.oModel._loadData(p,P,s,e,false,u,f);function s(d){t._deregisterHandleOfCompletedRequest(R);if(c!=t.iAnalyticalInfoVersionNumber){t._deregisterCompletedRequest(r.sRequestId);return}switch(r.iRequestType){case A._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(r,d);break;case A._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(r,d);break;case A._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(r,d);break;case A._requestType.reloadMeasuresQuery:t._processReloadMeasurePropertiesQueryResponse(r,d);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break}t._deregisterCompletedRequest(r.sRequestId)}function f(){if(c!=t.iAnalyticalInfoVersionNumber){return}if(t._cleanupGroupingForCompletedRequest(r.sRequestId)){t.fireDataReceived()}}function e(d){t._deregisterHandleOfCompletedRequest(R);t._deregisterCompletedRequest(r.sRequestId);t._cleanupGroupingForCompletedRequest(r.sRequestId);if(c!=t.iAnalyticalInfoVersionNumber){return}t.fireDataReceived()}function u(d){t._registerNewRequestHandle(R,d)}};A.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests()};A.prototype._processGroupMembersQueryResponse=function(R,d){var G=R.sGroupId,s=R.aSelectedUnitPropertyName,b=R.aAggregationLevel,c=R.oKeyIndexMapping.iIndex,e=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,f=G==null?0:this._getGroupIdLevel(G)+1;var u=(s.length>0);var P,D;var n;var t=0;var v;var w,x=[];var O=d.results.length;var y=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(y&&y.length>0){for(var i=0,z=y.length;i<z;i++){d.results[i-z]=this.oModel.getObject("/"+y[i])}var E=d.results[-y.length];P="";for(var j=0;j<b.length;j++){P+=E[b[j]]+"|"}}v=y&&y.length==1;for(var h=0;h<O;h++){var B=d.results[h];if(u){D="";for(var g=0;g<b.length;g++){D+=B[b[g]]+"|"}if(P==D){if(n===undefined){if(h==0){n=-y.length;K.iServiceKeyIndex-=y.length-1}else{n=h-1}}var H=-1,I=d.results[h-1];for(var k=0;k<s.length;k++){if(I[s[k]]!=B[s[k]]){H=k;break}}if(H==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h)}}if((P!=D||h==O-1)&&n!==undefined){var M=[];for(var l=n;l<h;l++){M.push(d.results[l])}if(P==D){M.push(d.results[h])}var J=[];for(var m=0;m<s.length;m++){var U=s[m];for(var o=1;o<M.length;o++){if(M[o-1][U]!=M[o][U]){J.push(U);break}}}var N=this._createMultiUnitRepresentativeEntry(G,d.results[n],s,J,R.bIsFlatListRequest);if(N.aReloadMeasurePropertyName.length>0){w=this._prepareReloadMeasurePropertiesQueryRequest(A._requestType.reloadMeasuresQuery,R,N);x.push(w)}var V=this._setAdjacentMultiUnitKeys(K,N,M);var W;if(N.bIsNewEntry){W=M.length-1}else{W=V}if(v){v=false}if(W<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative")}t+=W;n=undefined;if(P!=D){v=this._setServiceKey(K,this.oModel._getKey(B))}}else if(P!=D){v=this._setServiceKey(K,this.oModel._getKey(B))}P=D}else{this._setServiceKey(K,this.oModel._getKey(B))}if(!R.bIsLeafGroupsRequest){var X=this._getKey(G,K.iIndex-1),Y=this._getGroupIdFromContext(this.oModel.getContext('/'+X),f);this.mEntityKey[Y]=X}}var Z=[];if(this.bReloadSingleUnitMeasures&&x.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([A._requestType.reloadMeasuresQuery,x]);Q.sap.delayedCall(0,this,A.prototype._processRequestQueue)}else{for(var q=0;q<x.length;q++){var $=x[q];this._executeQueryRequest($)}}for(var p=0;p<x.length;p++){var _=x[p];Z.push(_.sRequestId)}this._considerRequestGrouping(Z)}if(y&&y.length>0){for(var r=0,a1=y.length;r<a1;r++){delete d.results[r-a1]}}if(u){t+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,b,s,R.bIsFlatListRequest)}if(!R.bAvoidLengthUpdate){var b1=false;if(d.__count){this.mServiceLength[G]=parseInt(d.__count,10);this.mLength[G]=this.mServiceLength[G]-t;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=d.__count}b1=true}if(this.mServiceLength[G]<e+O){this.mServiceLength[G]=e+O;this.mLength[G]=c+O-t;this.mFinalLength[G]=false}if(O<L||L===undefined){this.mServiceLength[G]=e+O;this.mLength[G]=c+K.iIndex-c;this.mFinalLength[G]=true;b1=true}if(O==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;b1=true}if(!b1&&this.mLength[G]!==undefined&&t>0){this.mLength[G]-=t}}this.bNeedsUpdate=true;if(t>0){this.aMultiUnitLoadFactor[b.length]=d.results.length/(d.results.length-t);if(this.aMultiUnitLoadFactor[b.length]<1.5){this.aMultiUnitLoadFactor[b.length]=2}}};A.prototype._processTotalSizeQueryResponse=function(r,d){if(d.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return}this.iTotalSize=d.__count};A.prototype._processLevelMembersQueryResponse=function(r,d){var t=this;var p,P;var b=function(c,I){var g={iRequestType:A._requestType.groupMembersQuery,sRequestId:t._getRequestId(A._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:c?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(c&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=g.sGroupId||t._getKeys(g.sGroupId)===undefined)){var s=t._getParentGroupId(g.sGroupId);var f=t._findKeyIndex(s,t.mEntityKey[g.sGroupId]);if(f==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+g.sGroupId+" in group "+s)}if(f>0&&t._getKey(s,f-1)!==undefined){var h=t._getKey(s,f-1);var j=t._getGroupIdFromContext(t.oModel.getContext('/'+h),t._getGroupIdLevel(g.sGroupId));t.mFinalLength[j]=true;g.iStartIndex=0}}if(I){g.iLength=P.length}g.oKeyIndexMapping=t._getKeyIndexMapping(g.sGroupId,g.iStartIndex);var k=Q.extend(true,{},d);k.results=P;t._processGroupMembersQueryResponse(g,k)};if(d.results.length==0){return}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(d.results[0])),r.iLevel-1);P=[];var c=true;for(var i=0;i<d.results.length;i++){var e=d.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(d.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(e);if(i<d.results.length-1){continue}}b(c,d.results.length==r.iLength&&i==d.results.length-1);c=false;if(p!=s){P=[e]}p=s}if(d.results.length>1&&P.length==1){b(c,d.results.length==r.iLength)}};A.prototype._processReloadMeasurePropertiesQueryResponse=function(r,d){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(d.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return}var R=d.results[0];var o=this.oModel.getKey(R);var b=this.oModel.getObject("/"+M);if(!b){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return}var c=m.aReloadMeasurePropertyName;for(var i=0;i<c.length;i++){b[c[i]]=R[c[i]]}this.oModel.deleteCreatedEntry(this.oModel.getContext("/"+o))};A.prototype._getLoadedContextsForGroup=function(g,s,l){var c=[],o,k=this._getKeys(g),K;if(!k){return c}if(!s){s=0}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]&&this.mLength[g]<l){l=this.mLength[g]}}for(var i=s;i<s+l;i++){K=k(i);if(!K){break}o=this.oModel.getContext('/'+K);c.push(o)}return c};A.prototype._calculateRequiredGroupSection=function(g,s,l,t,c){var b,d,p,P,r,o={},k=this._getKeys(g),K;d=s;b=0;if(!k){P=s;p=s+l}else{for(var i=s-1;i>=Math.max(s-t,0);i--){K=k(i);if(!K){P=i+1;break}}for(var j=s+l;j<s+l+t;j++){K=k(j);if(!K){p=j;break}}}r=s-P;if(P&&s>t&&r<t){if(c.length!=l){d=s-t}else{d=P-t}b=t}if(d==s){d+=c.length}if(c.length!=l){b+=l-c.length}r=p-s-l;if(r==0){b+=t}if(p&&r<t&&r>0){if(d>=s){d=p;b+=t}}if(this.mFinalLength[g]&&this.mLength[g]<(b+d)){b=this.mLength[g]-d}o.startIndex=d;o.length=b;return o};A.prototype._calculateRequiredGroupExpansion=function(g,b,s,l){var n={groupId_Missing:null,length_Missing:0};var t=this;var c=function(g,b,s,l){var L=t._getGroupIdLevel(g);if(L==b){var k=t._getLoadedContextsForGroup(g,s,l);var m=s+k.length-1;if(k.length>=l){return n}else if(t.mFinalLength[g]){if(k.length>=t.mLength[g]){return{groupId_Missing:null,length_Missing:l-k.length}}else{return{groupId_Missing:g,startIndex_Missing:m+1,length_Missing:l-k.length}}}else{return{groupId_Missing:g,startIndex_Missing:m+1,length_Missing:l-k.length}}}var o=t._getLoadedContextsForGroup(g,s,l);var d=l,q=s+o.length-1;for(var i=-1,r;(r=o[++i])!==undefined;){d--;var G=c(t._getGroupIdFromContext(r,L+1),b,0,d);if(G.groupId_Missing==null){if(G.length_Missing==0){return G}else{d=G.length_Missing}}else{return G}if(d==0){break}}if(t.mFinalLength[g]||d==0){return{groupId_Missing:null,length_Missing:d}}else{return{groupId_Missing:g,startIndex_Missing:q+1,length_Missing:d}}};var L=this._getGroupIdLevel(g);if(L==b+1){g=this._getParentGroupId(g);--L}if(g==null||L>b){return n}var d=l,e=s;while(g!=null){var G=c(g,b,e,d);if(G.groupId_Missing!=null){return G}else if(G.length_Missing==0){return G}else{var f=false;while(!f){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break}var h=this.mEntityKey[g];if(!h){Q.sap.log.fatal("assertion failed: entitykey for group w/ ID "+g+" not available");return n}var j=this._findKeyIndex(p,h);if(j==-1){Q.sap.log.fatal("assertion failed: group w/ ID "+g+" not found in members of parent w/ ID "+p);return n}if(j==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue}else{return{groupId_Missing:p,startIndex_Missing:j+1,length_Missing:d}}}else{h=this._getKey(p,j+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+h),L);f=true}}e=0;d=G.length_Missing}}return{groupId_Missing:null,length_Missing:d}};A.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath};A.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results"}}return e};A.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending}}return null};A.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,w){var f;switch(this._getEffectiveSortOrder(p)){case a.SortOrder.Ascending:if(w){f=sap.ui.model.FilterOperator.GE}else{f=sap.ui.model.FilterOperator.GT}break;case a.SortOrder.Descending:if(w){f=sap.ui.model.FilterOperator.LE}else{f=sap.ui.model.FilterOperator.LT}break;default:f=sap.ui.model.FilterOperator.GT}return f};A.prototype._convertDeprecatedFilterObjects=function(f){if(!f){return f}for(var i=0,l=f.length;i<l;i++){if(sap.ui.model.odata&&typeof sap.ui.model.odata.Filter==="function"&&f[i]instanceof sap.ui.model.odata.Filter){f[i]=f[i].convert()}}return f};A.prototype._getGroupIdFromContext=function(c,l){if(!c){return null}var g="/";var d=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels")}for(var i=0;i<l;i++){d=c.getProperty(this.aAggregationLevel[i]);if(d!=null){g+=encodeURIComponent(d)+"/"}else{g+="@/"}}return g};A.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1}return g.split("/").length-2};A.prototype._getGroupIdComponents=function(g){if(g==null){return null}var G=g.split("/");var d=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){d[i-1]=null}else{d[i-1]=decodeURIComponent(G[i])}}return d};A.prototype._getGroupIdAncestors=function(g,n){if(!n){return[]}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[]}if(g=="/"){if(Math.abs(n)==1){return[null]}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[]}}var G=g.split("/");var b=[],s="";var f=0,t=G.length-3;if(n>0){if(n-1>t){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g)}else{t=n-1}}else if(-(n+1)>t){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g)}else{f=t+1+n;for(var i=0;i<f;i++){s+=G[i]+"/"}}for(var j=f;j<=t;j++){s+=G[j]+"/";b.push(s)}return b};A.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0]};A.prototype._removeDuplicatesFromStringArray=function(b){var t={};for(var i=0;i<b.length;i++){t[b[i]]=true}var u=[];for(var s in t){u.push(s)}return u};A.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[]}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1};A.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use")}this.oPendingRequestHandle[r]=R};A.prototype._deregisterHandleOfCompletedRequest=function(r){if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID")}this.oPendingRequestHandle[r]=undefined};A.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort()}}}this.oPendingRequestHandle=[]};A.prototype._getRequestId=function(r,p){switch(r){case A._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID")}return A._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case A._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level")}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId")}return""+A._requestType.levelMembersQuery+p.level+(this.bUseAcceleratedAutoExpand==true?"":p.groupId);case A._requestType.totalSizeQuery:return A._requestType.totalSizeQuery;case A._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key")}return A._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1}};A.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1}else{++this.oPendingRequests[r]}};A.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={}}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true}}};A.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0};A.prototype._deregisterCompletedRequest=function(r){if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r)}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r]}else{--this.oPendingRequests[r]}};A.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O)}}}return g};A.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var b=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break}}}var L;if(l==0){L=0}else{if(k[l]>=0){L=k[l]}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(b[L+1]!==undefined){++L}}else{L=Math.abs(k[l+1])-1}if(b[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L)}}var d=s-l;i=L+d}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K};A.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i)};A.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined}if(s>=0){return this.mServiceKey[g][s]}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null}return k};A.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined}var t=this;return function(i){return t._getKey(g,i)}};A.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined}var s=this.mServiceKey[g],b=k[I];if(b===undefined){return undefined}if(b>=0){return[s[b]]}var G=[];if(k[I+1]===undefined){b=k[I]=="ZERO"?0:-k[I];while(s[b]!==undefined){G.push(s[b++])}}else{b=k[I]=="ZERO"?0:-k[I];for(var i=b,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i])}}return G};A.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined}return this.mKeyIndex[g].length};A.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(this.mMultiUnitKey[i]==k){return i}}else if(s[K[i]]==k){return i}}return-1};A.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[]}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[]}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n};A.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[]}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[]}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[]}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i])}return n};A.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,b,s,I){var K=this.mKeyIndex[k.sGroupId],c=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],d=0,n=k.iServiceKeyIndex,e=k.iIndex;var M,o;if(K===undefined){return d}var N=false;var p=c[n-1],f=c[n];if(f===undefined){return d}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return d}var P=this.oModel.getObject("/"+p);var g=this.oModel.getObject("/"+f);var h="",j="";for(var i=0;i<b.length;i++){h+=P[b[i]]+"|";j+=g[b[i]]+"|"}N=h==j;var l=e;if(l>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return d}while(K[l]===undefined||Math.abs(K[l])<n){++l}if(N){if(Math.abs(K[l])==n&&K[l]<0){if(l>e){if(K[e-1]<0){m[l]=undefined;K.splice(e,l-e+1);m.splice(e,l-e+1)}else{K[e-1]=-K[e-1];m[e-1]=m[l];m[l]=undefined;K.splice(e,l-e+1);m.splice(e,l-e+1);d=1}}}else if(Math.abs(K[l])>n){var q=l-1;if(K[q]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[q]=-K[q];m[q]=o;if(q>e){K.splice(e,q-e);m.splice(e,q-e)}if(M.bIsNewEntry){d=1}else{d=0}}else if(K[e-1]<0){if(l>e){m[q]=undefined;K.splice(e,q-e+1);m.splice(e,q-e+1)}}else{K[e-1]=-K[e-1];m[e-1]=m[q];m[q]=undefined;K.splice(e,q-e+1);m.splice(e,q-e+1)}}else if(K[l]==n){if(l>e){if(K[e-1]<0){K.splice(e,l-e+1);m.splice(e,l-e+1);d=1}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before")}K[e-1]=-K[e-1];m[e-1]=o;K.splice(e,l-e+1);m.splice(e,l-e+1);d=1}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return d}}else if(K[l]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required")}else if(l-e>0){K.splice(e,l-e);m.splice(e,l-e)}return d};A.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,d,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*"}}if(d){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,d)==-1){R.push(o.rawValuePropertyName)}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],d)!=-1){m[s[k]]="*"}}var b="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var D=m[this.aAllDimensionSortedByName[l]];b+=(D===undefined?"":D)+","}b+="-multiple-units-not-dereferencable";var c;if(this.mMultiUnitKey[g]&&(c=Q.inArray(b,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+b),bIsNewEntry:false,iIndex:c,aReloadMeasurePropertyName:R}}m.__metadata.uri=b;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{});var e=this.oModel._getKey(m);this.oModel.getContext('/'+e)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R}};A.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={}};A.prototype.resetData=function(c){var g=c?c.getPath():undefined;this._resetData(g)};A.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g]}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={}}};A.prototype.refresh=function(f,c,e){var b=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){b=true}}if(c&&!b){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in c){b=true;return false}});if(b){return false}})}if(!c&&!e){b=true}}if(f||b){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh})}};A.prototype.checkUpdate=function(f,c){var b=false;if(!f){if(this.bNeedsUpdate||!c){b=true}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in c){b=true;return false}});if(b){return false}})}}if(f||b){this.bNeedsUpdate=false;this._fireChange()}};A.prototype.getDownloadUrl=function(f){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var s=[];var b=[];for(var d in this.oDimensionDetailsSet)s.push(d);o.setAggregationLevel(s);for(var D in this.oDimensionDetailsSet){var c=this.oDimensionDetailsSet[D];var I=(c.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(c.name,true,I,c.aAttributeName)}for(var M in this.oMeasureDetailsSet)b.push(M);o.setMeasures(b);for(var e in this.oMeasureDetailsSet){var g=this.oMeasureDetailsSet[e];var h=(g.rawValuePropertyName!=undefined);var n=(g.formattedValuePropertyName!=undefined);var p=(g.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(g.name,h,n,p)}var q=o.getSortExpression();q.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){q.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending)}}var r=o.getFilterExpression();r.clear();if(this.aApplicationFilter){r.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){r.addUI5FilterConditions(this.aControlFilter)}var P=o.getURIToQueryResultEntitySet();var t=this._getQueryODataRequestOptions(o);if(!t){return undefined}var E=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var u=this.aAnalyticalInfo[k];if((u.visible||u.inResult)&&u.name!==""){E.push(u.name);if(this.oMeasureDetailsSet[u.name]!=undefined&&this.oMeasureDetailsSet[u.name].unitPropertyName!=undefined){E.push(this.oMeasureDetailsSet[u.name].unitPropertyName)}}}for(var j=0,l=t.length;j<l;j++){if(/^\$select/i.test(t[j])){t[j]="$select="+E.join(",");break}}if(f){t.splice(0,0,"$format="+encodeURIComponent(f))}if(P){return this.oModel._createRequestUrl(P,null,t)}};return A},true);
