/*!
 * @copyright@
 */
sap.ui.define(['jquery.sap.global'],function(q){"use strict";var o=o||{};o.constants={};o.constants["SAP_NAMESPACE"]="http://www.sap.com/Protocols/SAPData";o.constants["VERSION"]="0.7";o.helper={tokenizeNametoLabelText:function(n){var l="";l=n.replace(/^P_(.*)/,"$1");l=l.replace(/([^A-Z0-9_]+)([A-Z0-9_])/g,"$1 $2");l=l.replace(/([A-Z0-9_]{2,})([A-Z0-9_])([^A-Z0-9_]+)/g,"$1 $2$3");l=l.replace(/(.*) _E$/,"$1");l=l.replace(/(.*) _(.*)/g,"$1 $2");return l}};o.Model=function(m,p){this._init(m,p)};o.Model.ReferenceByURI=function(u){return{sServiceURI:u}};o.Model.ReferenceByModel=function(m){return{oModel:m}};o.Model.ReferenceWithWorkaround=function(m,w){return{oModelReference:m,aWorkaroundID:w}};o.Model.prototype={_init:function(M,P){if(typeof P=="string"){throw"Deprecated second argument: Adjust your invocation by passing an object with a property sAnnotationJSONDoc as a second argument instead"}this._mParameter=P;this._oActivatedWorkarounds={};if(M&&M.aWorkaroundID){for(var i=-1,I;(I=M.aWorkaroundID[++i])!==undefined;){this._oActivatedWorkarounds[I]=true}M=M.oModelReference}if(!M||(!M.sServiceURI&&!M.oModel)){throw"Usage with oModelReference being an instance of Model.ReferenceByURI or Model.ReferenceByModel"}if(M.oModel){this._oModel=M.oModel}else{this._oModel=new sap.ui.model.odata.ODataModel(M.sServiceURI)}if(this._oModel.getServiceMetadata().dataServices==undefined){throw"Model could not be loaded"}if(P&&P.sAnnotationJSONDoc){this.mergeV2Annotations(P.sAnnotationJSONDoc)}this._oQueryResultSet={};this._oParameterizationSet={};this._oEntityTypeSet={};this._oEntitySetSet={};this._oEntityTypeNameToEntitySetMap={};var S=this._oModel.getServiceMetadata().dataServices.schema[0];for(var j=-1,c;(c=S.entityContainer[++j])!==undefined;){if(c.isDefaultEntityContainer=="true"){this._oDefaultEntityContainer=c;break}}var e=S.entityType;var Q=[],a=[],u=[];for(var k=-1,T;(T=e[++k])!==undefined;){var b=false;if(T.extensions!=undefined){for(var l=-1,E;(E=T.extensions[++l])!==undefined;){if(E.namespace==o.constants.SAP_NAMESPACE&&E.name=="semantics"){b=true;switch(E.value){case"aggregate":Q.push(T);break;case"parameters":a.push(T);break;default:u.push(T)}}if(b){continue}}if(!b){u.push(T)}}else{u.push(T)}}for(var m=-1,d;(d=u[++m])!==undefined;){var f=new o.EntityType(this._oModel.getServiceMetadata(),S,d);this._oEntityTypeSet[f.getQName()]=f;var g=this._getEntitySetsOfType(S,f.getQName());if(g.length==0){throw"Invalid consumption model: No entity set for entity type "+f.getQName()+" found"}if(g.length>1){throw"Unsupported consumption model: More than one entity set for entity type "+f.getQName()+" found"}var h=new o.EntitySet(this._oModel.getServiceMetadata(),S,g[0][0],g[0][1],f);this._oEntitySetSet[h.getQName()]=h;this._oEntityTypeNameToEntitySetMap[f.getQName()]=h}var v={};for(var n=-1,w;(w=a[++n])!==undefined;){var x=new o.EntityType(this._oModel.getServiceMetadata(),S,w);this._oEntityTypeSet[x.getQName()]=x;var y=this._getEntitySetsOfType(S,x.getQName());if(y.length==0){throw"Invalid consumption model: No entity set for parameter entity type "+x.getQName()+" found"}if(y.length>1){throw"Unsupported consumption model: More than one entity set for parameter entity type "+x.getQName()+" found"}var z=new o.EntitySet(this._oModel.getServiceMetadata(),S,y[0][0],y[0][1],x);this._oEntitySetSet[z.getQName()]=z;this._oEntityTypeNameToEntitySetMap[x.getQName()]=z;var A=new o.Parameterization(x,z);this._oParameterizationSet[A.getName()]=A;v[x.getQName()]=A;var B=x.getQName();if(S.association!=undefined){for(var p=-1,C;(C=S.association[++p])!==undefined;){if(C.referentialConstraint==undefined){continue}var D=null;if(C.end[0].type==B&&C.end[0].multiplicity=="*"&&C.end[1].multiplicity=="1"){D=C.end[1].type}else if(C.end[1].type==B&&C.end[1].multiplicity=="*"&&C.end[0].multiplicity=="1"){D=C.end[0].type}if(!D){continue}if(C.referentialConstraint.dependent.propertyRef.length!=1){continue}var F=A.findParameterByName(C.referentialConstraint.dependent.propertyRef[0].name);if(F==null){continue}var V=this._oEntityTypeSet[D];var G=this._oEntityTypeNameToEntitySetMap[D];F.setValueSetEntity(V,G)}}}for(var r=-1,H;(H=Q[++r])!==undefined;){var J=new o.EntityType(this._oModel.getServiceMetadata(),S,H);this._oEntityTypeSet[J.getQName()]=J;var K=J.getQName();var L=null;var N=null;if(S.association!=undefined){for(var s=-1,O;(O=S.association[++s])!==undefined;){var R=null;if(O.end[0].type==K){R=O.end[1].type}else if(O.end[1].type==K){R=O.end[0].type}else{continue}var U=null;U=v[R];if(U!=null){if(L!=null){throw"LIMITATION: Unable to handle multiple parameter entity types of query entity "+J.name}else{L=U;N=O}}}}var W=this._getEntitySetsOfType(S,J.getQName());if(W.length!=1){throw"Invalid consumption model: There must be exactly one entity set for an entity type annotated with aggregating semantics"}var X=new o.EntitySet(this._oModel.getServiceMetadata(),S,W[0][0],W[0][1],J);this._oEntitySetSet[X.getQName()]=X;this._oEntityTypeNameToEntitySetMap[J.getQName()]=X;var Y=new o.QueryResult(this,J,X,L);this._oQueryResultSet[Y.getName()]=Y;if(L){L.setTargetQueryResult(Y,N)}if(S.association!=undefined){for(var t=-1,Z;(Z=S.association[++t])!==undefined;){if(Z.referentialConstraint==undefined){continue}var $=null;if(Z.end[0].type==K&&Z.end[0].multiplicity=="*"&&Z.end[1].multiplicity=="1"){$=Z.end[1].type}else if(Z.end[1].type==K&&Z.end[1].multiplicity=="*"&&Z.end[0].multiplicity=="1"){$=Z.end[0].type}if(!$){continue}if(Z.referentialConstraint.dependent.propertyRef.length!=1){continue}var _=Y.findDimensionByName(Z.referentialConstraint.dependent.propertyRef[0].name);if(_==null){continue}var a1=this._oEntityTypeNameToEntitySetMap[$];_.setMembersEntitySet(a1)}}}},oUI5ODataModelAnnotatableObject:{objectName:"schema",keyPropName:"namespace",extensions:true,aSubObject:[{objectName:"entityType",keyPropName:"name",extensions:true,aSubObject:[{objectName:"property",keyPropName:"name",aSubObject:[],extensions:true}]},{objectName:"entityContainer",keyPropName:"name",extensions:false,aSubObject:[{objectName:"entitySet",keyPropName:"name",extensions:true,aSubObject:[]}]}]},mergeV2Annotations:function(a){var A=null;try{A=JSON.parse(a)}catch(e){return}var m;try{m=this._oModel.getServiceMetadata().dataServices}catch(e){return}for(var p in A){if(!(this.oUI5ODataModelAnnotatableObject.objectName==p)){continue}if(!(A[p]instanceof Array)){continue}this.mergeV2AnnotationLevel(m[this.oUI5ODataModelAnnotatableObject.objectName],A[this.oUI5ODataModelAnnotatableObject.objectName],this.oUI5ODataModelAnnotatableObject);break}return},mergeV2AnnotationLevel:function(M,a,u){for(var i=-1,A;(A=a[++i])!==undefined;){for(var j=-1,b;(b=M[++j])!==undefined;){if(!(A[u.keyPropName]==b[u.keyPropName])){continue}if(A["extensions"]!=undefined){if(b["extensions"]==undefined){b["extensions"]=[]}for(var l=-1,c;(c=A["extensions"][++l])!==undefined;){var f=false;for(var m=-1,d;(d=b["extensions"][++m])!==undefined;){if(c.name==d.name&&c.namespace==d.namespace){d.value=c.value;f=true;break}}if(!f){b["extensions"].push(c)}}}for(var k=-1,U;(U=u.aSubObject[++k])!==undefined;){for(var p in A){if(!(U.objectName==p)){continue}if(!(A[U.objectName]instanceof Array)){continue}if((b[U.objectName]==undefined)||(!(b[U.objectName]instanceof Array))){continue}this.mergeV2AnnotationLevel(b[U.objectName],A[U.objectName],U);break}}}}return},findQueryResultByName:function(n){var Q=this._oQueryResultSet[n];if(!Q&&this._oDefaultEntityContainer){var s=this._oDefaultEntityContainer.name+"."+n;Q=this._oQueryResultSet[s]}return Q},getAllQueryResultNames:function(){if(this._aQueryResultNames){return this._aQueryResultNames}this._aQueryResultNames=new Array(0);for(var n in this._oQueryResultSet){this._aQueryResultNames.push(this._oQueryResultSet[n].getName())}return this._aQueryResultNames},getAllQueryResults:function(){return this._oQueryResultSet},getODataModel:function(){return this._oModel},_getEntitySetsOfType:function(s,Q){var e=[];for(var i=-1,E;(E=s.entityContainer[++i])!==undefined;){for(var j=-1,a;(a=E.entitySet[++j])!==undefined;){if(a.entityType==Q){e.push([E,a])}}}return e},_mParameter:null,_oModel:null,_oDefaultEntityContainer:null,_aQueryResultNames:null,_oQueryResultSet:null,_oParameterizationSet:null,_oEntityTypeSet:null,_oEntitySetSet:null,_oEntityTypeNameToEntitySetMap:null,_oActivatedWorkarounds:null};o.QueryResult=function(m,e,E,p){this._init(m,e,E,p)};o.QueryResult.prototype={_init:function(m,e,E,p,a){this._oModel=m;this._oEntityType=e;this._oEntitySet=E;this._oParameterization=p;this._oDimensionSet={};this._oMeasureSet={};var P=e.getTypeDescription().property;var A={};for(var i=-1,b;(b=P[++i])!==undefined;){if(b.extensions==undefined){continue}for(var j=-1,c;(c=b.extensions[++j])!==undefined;){if(!c.namespace==o.constants.SAP_NAMESPACE){continue}switch(c.name){case"aggregation-role":switch(c.value){case"dimension":{var d=new o.Dimension(this,b);this._oDimensionSet[d.getName()]=d;break}case"measure":{var M=new o.Measure(this,b);this._oMeasureSet[M.getName()]=M;break}case"totaled-properties-list":this._oTotaledPropertyListProperty=b;break;default:}break;case"attribute-for":{var D=new o.DimensionAttribute(this,b);A[D.getKeyProperty()]=D;break}default:}}}for(var s in A){var f=A[s];f.getDimension().addAttribute(f)}if(m._oActivatedWorkarounds.IdentifyTextPropertiesByName){var g=[];for(var h in this._oDimensionSet){var k=this._oDimensionSet[h];if(!k.getTextProperty()){var T=null;T=e.findPropertyByName(h+"Name");if(!T){T=e.findPropertyByName(h+"Text")}if(!T){T=e.findPropertyByName(h+"Desc")}if(!T){T=e.findPropertyByName(h+"Description")}if(T){k.setTextProperty(T);g.push(T.name)}}}for(var t=-1,l;(l=g[++t])!==undefined;){delete this._oDimensionSet[l]}}},getName:function(){return this.getEntitySet().getQName()},getParameterization:function(){return this._oParameterization},getAllDimensionNames:function(){if(this._aDimensionNames){return this._aDimensionNames}this._aDimensionNames=[];for(var n in this._oDimensionSet)this._aDimensionNames.push(this._oDimensionSet[n].getName());return this._aDimensionNames},getAllDimensions:function(){return this._oDimensionSet},getAllMeasureNames:function(){if(this._aMeasureNames){return this._aMeasureNames}this._aMeasureNames=[];for(var n in this._oMeasureSet)this._aMeasureNames.push(this._oMeasureSet[n].getName());return this._aMeasureNames},getAllMeasures:function(){return this._oMeasureSet},findDimensionByName:function(n){return this._oDimensionSet[n]},findDimensionByPropertyName:function(n){if(this._oDimensionSet[n]){return this._oDimensionSet[n]}for(var d in this._oDimensionSet){var D=this._oDimensionSet[d];var t=D.getTextProperty();if(t&&t.name==n){return D}if(D.findAttributeByName(n)){return D}}return null},getTotaledPropertiesListProperty:function(){return this._oTotaledPropertyListProperty},findMeasureByName:function(n){return this._oMeasureSet[n]},findMeasureByPropertyName:function(n){if(this._oMeasureSet[n]){return this._oMeasureSet[n]}for(var m in this._oMeasureSet){var M=this._oMeasureSet[m];var f=M.getFormattedValueProperty();if(f&&f.name==n){return M}}return null},getModel:function(){return this._oModel},getEntityType:function(){return this._oEntityType},getEntitySet:function(){return this._oEntitySet},_oModel:null,_oEntityType:null,_oEntitySet:null,_oParameterization:null,_aDimensionNames:null,_oDimensionSet:null,_aMeasureNames:null,_oMeasureSet:null,_oTotaledPropertyListProperty:null};o.Parameterization=function(e,E){this._init(e,E)};o.Parameterization.prototype={_init:function(e,E){this._oEntityType=e;this._oEntitySet=E;this._oParameterSet={};var p=e.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){if(P.extensions==undefined){continue}for(var j=-1,a;(a=P.extensions[++j])!==undefined;){if(!a.namespace==o.constants.SAP_NAMESPACE){continue}switch(a.name){case"parameter":{var b=new o.Parameter(this,P);this._oParameterSet[b.getName()]=b;break}default:}}}},setTargetQueryResult:function(Q,a){this._oQueryResult=Q;var s=this._oEntityType.getSchema().namespace+"."+a.name;var n=this._oEntityType.getTypeDescription().navigationProperty;if(!n){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type"}for(var i=-1,N;(N=n[++i])!==undefined;){if(N.relationship==s){this._oNavPropToQueryResult=N.name}}if(!this._oNavPropToQueryResult){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type"}},getTargetQueryResult:function(){if(!this._oQueryResult){throw"No target query result set"}return this._oQueryResult},getName:function(){return this.getEntitySet().getQName()},getAllParameterNames:function(){if(this._aParameterNames){return this._aParameterNames}this._aParameterNames=[];for(var n in this._oParameterSet)this._aParameterNames.push(this._oParameterSet[n].getName());return this._aParameterNames},getAllParameters:function(){return this._oParameterSet},findParameterByName:function(n){return this._oParameterSet[n]},getNavigationPropertyToQueryResult:function(){return this._oNavPropToQueryResult},getEntityType:function(){return this._oEntityType},getEntitySet:function(){return this._oEntitySet},_oEntityType:null,_oEntitySet:null,_oQueryResult:null,_oNavPropToQueryResult:null,_aParameterNames:null,_oParameterSet:null};o.Parameter=function(p,P){this._init(p,P)};o.Parameter.prototype={_init:function(p,P){this._oParameterization=p;this._oProperty=P;var e=p.getEntityType();if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue}switch(E.name){case"parameter":switch(E.value){case"mandatory":this._bRequired=true;break;case"optional":this._bRequired=false;break;default:throw"Invalid annotation value for parameter property"}break;case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=e.findPropertyByName(E.value);break;case"upper-boundary":this._bIntervalBoundaryParameter=true;this._oUpperIntervalBoundaryParameterProperty=e.findPropertyByName(E.value);break;case"lower-boundary":this._bIntervalBoundaryParameter=true;this._oLowerIntervalBoundaryParameterProperty=e.findPropertyByName(E.value);break;default:}}}if(!this._sLabelText){this._sLabelText=""}},setValueSetEntity:function(e,E){this._oValueSetEntityType=e;this._oValueSetEntitySet=E},getTextProperty:function(){return this._oTextProperty},getLabelText:function(){if(!this._sLabelText&&this._oParameterization._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return this._sLabelText},isOptional:function(){return(!this._bRequired)},isIntervalBoundary:function(){return this._bIntervalBoundaryParameter},isLowerIntervalBoundary:function(){return(this._oUpperIntervalBoundaryParameterProperty?true:false)},getPeerIntervalBoundaryParameter:function(){var p=null;if(this._oLowerIntervalBoundaryParameterProperty){p=this._oLowerIntervalBoundaryParameterProperty.name}else{p=this._oUpperIntervalBoundaryParameterProperty.name}if(!p){throw"Parameter is not an interval boundary"}return this._oParameterization.findParameterByName(p)},isValueSetAvailable:function(){return(this._oValueSetEntityType?true:false)},getName:function(){return this._oProperty.name},getProperty:function(){return this._oProperty},getContainingParameterization:function(){return this._oParameterization},getURIToValueEntitySet:function(s){var u=null;u=(s?s:"")+"/"+this._oValueSetEntitySet.getQName();return u},_oParameterization:null,_oProperty:null,_sLabelText:null,_oTextProperty:null,_bRequired:false,_bIntervalBoundaryParameter:false,_oLowerIntervalBoundaryParameterProperty:null,_oUpperIntervalBoundaryParameterProperty:null,_oValueSetEntityType:null,_oValueSetEntitySet:null};o.Dimension=function(Q,p){this._init(Q,p)};o.Dimension.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;this._oAttributeSet={}},setMembersEntitySet:function(e){this._oMembersEntitySet=e},getName:function(){return this._oProperty.name},getKeyProperty:function(){return this._oProperty},getTextProperty:function(){if(!this._oTextProperty){this._oTextProperty=this._oQueryResult.getEntityType().getTextPropertyOfProperty(this.getName())}return this._oTextProperty},setTextProperty:function(t){this._oTextProperty=t},getLabelText:function(){if(!this._sLabelText){this._sLabelText=this._oQueryResult.getEntityType().getLabelOfProperty(this.getName())}if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return(this._sLabelText==null?"":this._sLabelText)},getSuperOrdinateDimension:function(){if(!this._sSuperOrdinateDimension){var s=this._oQueryResult.getEntityType().getSuperOrdinatePropertyOfProperty(this.getName()).name;this._sSuperOrdinateDimension=this._oQueryResult.findDimensionByName(s)}return this._sSuperOrdinateDimension},getHierarchy:function(){if(!this._oHierarchy){this._oHierarchy=this._oQueryResult.getEntityType().getHierarchy(this._oProperty.name)}return this._oHierarchy},getAllAttributeNames:function(){if(this._aAttributeNames){return this._aAttributeNames}this._aAttributeNames=[];for(var n in this._oAttributeSet)this._aAttributeNames.push(this._oAttributeSet[n].getName());return this._aAttributeNames},getAllAttributes:function(){return this._oAttributeSet},findAttributeByName:function(n){return this._oAttributeSet[n]},addAttribute:function(d){this._oAttributeSet[d.getName()]=d},getContainingQueryResult:function(){return this._oQueryResult},hasMasterData:function(){return this._oMembersEntitySet!=null?true:false},getMasterDataEntitySet:function(){return this._oMembersEntitySet},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sSuperOrdinateDimension:null,_aAttributeNames:null,_oAttributeSet:null,_oMembersEntitySet:null,_oHierarchy:null};o.DimensionAttribute=function(Q,p){this._init(Q,p)};o.DimensionAttribute.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,e;(e=p.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue}switch(e.name){case"attribute-for":this._sDimensionName=e.value;break;case"label":this._sLabelText=e.value;break;case"text":this._oTextProperty=Q.getEntityType().findPropertyByName(e.value);break;default:}}}},getName:function(){return this._oProperty.name},getKeyProperty:function(){return this._oProperty},getTextProperty:function(){return this._oTextProperty},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return this._sLabelText},getDimension:function(){return this._oQueryResult.findDimensionByName(this._sDimensionName)},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sDimensionName:null};o.Measure=function(Q,p){this._init(Q,p)};o.Measure.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,e;(e=p.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue}switch(e.name){case"label":this._sLabelText=e.value;break;case"text":this._oTextProperty=Q.getEntityType().findPropertyByName(e.value);break;case"unit":this._oUnitProperty=Q.getEntityType().findPropertyByName(e.value);break;default:}}}if(!this._sLabelText){this._sLabelText=""}},getName:function(){return this._oProperty.name},getRawValueProperty:function(){return this._oProperty},getFormattedValueProperty:function(){return this._oTextProperty},getUnitProperty:function(){return this._oUnitProperty},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return this._sLabelText},isUpdatable:function(){if(this._bIsUpdatable!=null){return this._bIsUpdatable}var u=this._oQueryResult.getEntitySet().getUpdatablePropertyNameSet();return(u[this.getName()]!=undefined)},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_oUnitProperty:null,_bIsUpdatable:null};o.EntitySet=function(m,s,c,e,E){this._init(m,s,c,e,E)};o.EntitySet.prototype={_init:function(m,s,c,e,E){this._oEntityType=E;this._oEntitySet=e;this._oContainer=c;this._oSchema=s;this._oModel=m;if(s.entityContainer.length>1){this._sQName=c.name+"."+e.name}else{this._sQName=e.name}},getQName:function(){return this._sQName},getSetDescription:function(){return this._oEntitySet},getEntityType:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},getUpdatablePropertyNameSet:function(){if(this._oUpdatablePropertyNames){return this._oUpdatablePropertyNames}this._oUpdatablePropertyNames={};var s=true;if(this._oEntitySet.extensions!=undefined){for(var j=-1,e;(e=this._oEntitySet.extensions[++j])!==undefined;){if(e.namespace==o.constants.SAP_NAMESPACE&&e.name=="updatable"){if(e.value=="false"){s=false;break}}}}if(!s){return this._oUpdatablePropertyNames}var p=this._oEntityType.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){var b=true;if(P.extensions==undefined){continue}for(var k=-1,E;(E=P.extensions[++k])!==undefined;){if(E.namespace!=o.constants.SAP_NAMESPACE){continue}if(E.name=="updatable"){if(E.value=="false"){b=false;break}}}if(b){this._oUpdatablePropertyNames[P.name]=true}}return this._oUpdatablePropertyNames},_oEntityType:null,_oEntitySet:null,_oContainer:null,_oSchema:null,_oModel:null,_sQName:null,_oUpdatablePropertyNames:null};o.EntityType=function(m,s,e){this._init(m,s,e)};o.EntityType.propertyFilterRestriction={SINGLE_VALUE:"single-value",MULTI_VALUE:"multi-value",INTERVAL:"interval"};o.EntityType.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aKeyProperties=[];this._oPropertySet={};this._aFilterablePropertyNames=[];this._aSortablePropertyNames=[];this._aRequiredFilterPropertyNames=[];this._oPropertyFilterRestrictionSet={};this._oPropertyHeadingsSet={};this._oPropertyQuickInfosSet={};this._sQName=s.namespace+"."+e.name;var r={};var R=null;for(var i=-1,p;(p=e.key.propertyRef[++i])!==undefined;){this._aKeyProperties.push(p.name)}for(var k=-1,P;(P=e.property[++k])!==undefined;){this._oPropertySet[P.name]=P;this._aFilterablePropertyNames.push(P.name);this._aSortablePropertyNames.push(P.name);if(P.extensions==undefined){continue}for(var j=-1,E;(E=P.extensions[++j])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue}switch(E.name){case"filterable":if(E.value=="false"){this._aFilterablePropertyNames.pop(P.name)}break;case"sortable":if(E.value=="false"){this._aSortablePropertyNames.pop(P.name)}break;case"required-in-filter":if(E.value=="true"){this._aRequiredFilterPropertyNames.push(P.name)}break;case"filter-restriction":if(E.value==o.EntityType.propertyFilterRestriction.SINGLE_VALUE||E.value==o.EntityType.propertyFilterRestriction.MULTI_VALUE||E.value==o.EntityType.propertyFilterRestriction.INTERVAL){this._oPropertyFilterRestrictionSet[P.name]=E.value}break;case"hierarchy-node-for":if(!(R=r[P.name])){R=r[P.name]={}}R.dimensionName=E.value;break;case"hierarchy-parent-node-for":case"hierarchy-parent-nod":if(!(R=r[E.value])){R=r[E.value]={}}R.parentNodeIDProperty=P;break;case"hierarchy-level-for":if(!(R=r[E.value])){R=r[E.value]={}}R.levelProperty=P;break;case"hierarchy-drill-state-for":case"hierarchy-drill-stat":if(!(R=r[E.value])){R=r[E.value]={}}R.drillStateProperty=P;break;default:}}}this._oRecursiveHierarchySet={};for(var h in r){var H=r[h];var a=this._oPropertySet[h];var d=this._oPropertySet[H.dimensionName];if(d==null){d=a}this._oRecursiveHierarchySet[d.name]=new o.RecursiveHierarchy(e,a,H.parentNodeIDProperty,H.levelProperty,d)}},getProperties:function(){return this._oPropertySet},findPropertyByName:function(p){return this._oPropertySet[p]},getKeyProperties:function(){return this._aKeyProperties},getLabelOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue}if(e.name=="label"){return e.value}}}return null},getHeadingOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p}var s=null;if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue}if(e.name=="heading"){return e.value}if(e.name=="label"){s=e.value}}}return s},getQuickInfoOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p}var s=null;if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue}if(e.name=="quickinfo"){return e.value}if(e.name=="label"){s=e.value}}}return s},getTextPropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(e.name=="text"){return this.findPropertyByName(e.value)}}}return null},getSuperOrdinatePropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(e.name=="super-ordinate"){return this.findPropertyByName(e.value)}}}return null},getFilterablePropertyNames:function(){return this._aFilterablePropertyNames},getSortablePropertyNames:function(){return this._aSortablePropertyNames},getRequiredFilterPropertyNames:function(){return this._aRequiredFilterPropertyNames},getPropertiesWithFilterRestrictions:function(){return this._oPropertyFilterRestrictionSet},getAllHierarchyPropertyNames:function(){if(this._aHierarchyPropertyNames){return this._aHierarchyPropertyNames}this._aHierarchyPropertyNames=[];for(var n in this._oRecursiveHierarchySet)this._aHierarchyPropertyNames.push(this._oRecursiveHierarchySet[n].getNodeValueProperty().name);return this._aHierarchyPropertyNames},getHierarchy:function(n){if(this._oRecursiveHierarchySet[n]==undefined){return null}return this._oRecursiveHierarchySet[n]},getQName:function(){return this._sQName},getTypeDescription:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},_oEntityType:null,_oSchema:null,_oModel:null,_sQName:null,_aKeyProperties:null,_oPropertySet:null,_aFilterablePropertyNames:null,_aRequiredFilterPropertyNames:null,_oPropertyFilterRestrictionSet:null,_aHierarchyPropertyNames:null,_oRecursiveHierarchySet:null};o.RecursiveHierarchy=function(e,n,p,N,a){this._init(e,n,p,N,a)};o.RecursiveHierarchy.prototype={_init:function(e,n,p,N,a){this._oEntityType=e;this._oNodeIDProperty=n;this._oParentNodeIDProperty=p;this._oNodeLevelProperty=N;this._oNodeValueProperty=a},isRecursiveHierarchy:function(){return true},isLeveledHierarchy:function(){return false},getNodeIDProperty:function(){return this._oNodeIDProperty},getParentNodeIDProperty:function(){return this._oParentNodeIDProperty},getNodeLevelProperty:function(){return this._oNodeLevelProperty},getNodeValueProperty:function(){return this._oNodeValueProperty},_oNodeIDProperty:null,_oParentNodeIDProperty:null,_oNodeLevelProperty:null,_oNodeValueProperty:null};o.FilterExpression=function(m,s,e){this._init(m,s,e)};o.FilterExpression.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aConditionUI5Filter=[];this._aUI5FilterArray=[]},_renderPropertyFilterValue:function(f,p){return q.sap.encodeURL(this._oModel.getODataModel().formatValue(f,p))},clear:function(){this._aConditionUI5Filter=[];this._aUI5FilterArray=[]},_addCondition:function(p,O,v,V){for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(u.sPath==p&&u.sOperator==O&&u.oValue1==v&&u.oValue2==V){return}}this._aConditionUI5Filter.push(new sap.ui.model.Filter(p,O,v,V))},_addUI5FilterArray:function(u){this._aUI5FilterArray.push(u)},addCondition:function(p,O,v,V){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p}var f=this._oEntityType.getFilterablePropertyNames();if(q.inArray(p,f)===-1){throw"Cannot add filter condition for not filterable property name "+p}this._addCondition(p,O,v,V);return this},removeConditions:function(p){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot remove filter conditions for unknown property name "+p}for(var i=0;i<this._aConditionUI5Filter.length;i++){var u=this._aConditionUI5Filter[i];if(u.sPath==p){this._aConditionUI5Filter.splice(i--,1)}}return this},addSetCondition:function(p,v){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p}var f=this._oEntityType.getFilterablePropertyNames();if(q.inArray(p,f)===-1){throw"Cannot add filter condition for not filterable property name "+p}for(var i=-1,V;(V=v[++i])!==undefined;){this._addCondition(p,sap.ui.model.FilterOperator.EQ,V)}return this},addUI5FilterConditions:function(u){if(!q.isArray(u)){throw"Argument is not an array"}if(u.length==0){return this}var h=false;for(var i=0;i<u.length;i++){if(u[i].aFilters!=undefined){h=true;break}}if(h){this._addUI5FilterArray(u)}else{for(var j=0;j<u.length;j++){this.addCondition(u[j].sPath,u[j].sOperator,u[j].oValue1,u[j].oValue2)}}return this},getExpressionAsUI5FilterArray:function(){var f=this._aConditionUI5Filter.concat([]);for(var i=-1,F;(F=this._aUI5FilterArray[++i])!==undefined;){for(var j=-1,a;(a=F[++j])!==undefined;){f.push(a)}}return f},getPropertiesReferencedByUI5FilterArray:function(u,r){for(var i=-1,U;(U=u[++i])!==undefined;){if(U.aFilters!=undefined){this.getPropertiesReferencedByUI5FilterArray(U.aFilters,r)}else{if(r[U.sPath]==undefined){r[U.sPath]=[]}r[U.sPath].push(U)}}},getReferencedProperties:function(){var r={};for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(r[u.sPath]==undefined){r[u.sPath]=[]}r[u.sPath].push(u)}for(var j=-1,U;(U=this._aUI5FilterArray[++j])!==undefined;){this.getPropertiesReferencedByUI5FilterArray(U,r)}return r},renderUI5Filter:function(u){var p=this._oEntityType.findPropertyByName(u.sPath);if(p==null){throw"Cannot add filter condition for unknown property name "+u.sPath}var f=null;switch(u.sOperator){case sap.ui.model.FilterOperator.BT:f="("+u.sPath+" "+sap.ui.model.FilterOperator.GE.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type)+" and "+u.sPath+" "+sap.ui.model.FilterOperator.LE.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case sap.ui.model.FilterOperator.Contains:f="substringof("+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+","+u.sPath+")";break;case sap.ui.model.FilterOperator.StartsWith:case sap.ui.model.FilterOperator.EndsWith:f=u.sOperator.toLowerCase()+"("+u.sPath+","+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+")";break;default:f=u.sPath+" "+u.sOperator.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type)}return f},renderUI5MultiFilter:function(u){var U=[];var O="";var l=u.bAnd==true?" and ":" or ";for(var i=-1,a;(a=u.aFilters[++i])!==undefined;){if(a.aFilters!=undefined){U.push(a);continue}O+=(O==""?"":l)+"("+this.renderUI5Filter(a)+")"}if(U.length>0){for(var j=-1,m;(m=U[++j])!==undefined;){O+=(O==""?"":l)+"("+this.renderUI5MultiFilter(m)+")"}}return O},renderUI5FilterArray:function(u){if(u.length==0){return""}var O="";u.sort(function(a,b){if(a.sPath==b.sPath){return 0}if(a.sPath>b.sPath){return 1}else{return-1}});var p=u[0].sPath;var s="";var n=[],U=[];for(var i=-1,c;(c=u[++i])!==undefined;){if(c.aFilters!=undefined){U.push(c);continue}if(p!=c.sPath){if(s!=""){O+=(O==""?"":" and ")+"("+s+")"}s="";if(n.length>0){for(var j=-1,N;(N=n[++j])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(N)}O+=(O==""?"":" and ")+"("+s+")";s=""}p=c.sPath;n=[]}if(c.sOperator==sap.ui.model.FilterOperator.NE){n.push(c);continue}s+=(s==""?"":" or ")+this.renderUI5Filter(c)}if(s!=""){O+=(O==""?"":" and ")+"("+s+")"}if(n.length>0){s="";for(var k=-1,d;(d=n[++k])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(d)}O+=(O==""?"":" and ")+"("+s+")"}if(U.length>0){for(var l=-1,m;(m=U[++l])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5MultiFilter(m)+")"}}return O},getURIFilterOptionValue:function(){var O=this.renderUI5FilterArray(this._aConditionUI5Filter);for(var i=-1,u;(u=this._aUI5FilterArray[++i])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5FilterArray(u)+")"}return O},checkValidity:function(){var r=this._oEntityType.getRequiredFilterPropertyNames();var p=this.getReferencedProperties();for(var i=-1,P;(P=r[++i])!==undefined;){if(p[P]==undefined){throw"filter expression does not contain required property "+P}}var a=this._oEntityType.getPropertiesWithFilterRestrictions();for(var s in a){var f=a[s];if(f==o.EntityType.propertyFilterRestriction.SINGLE_VALUE){if(p[s]!=undefined){if(p[s].length>1||p[s][0].sOperator!=sap.ui.model.FilterOperator.EQ){throw"filter expression may use "+s+" only with a single EQ condition"}}}}return true},getEntityType:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},_oEntityType:null,_oSchema:null,_oModel:null,_aFilterCondition:null};o.SortOrder={Ascending:"asc",Descending:"desc"};o.SortExpression=function(m,s,e){this._init(m,s,e)};o.SortExpression.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aSortCondition=[]},_containsSorter:function(p){var r=null;for(var i=-1,c;(c=this._aSortCondition[++i])!==undefined;){if(c.property.name===p){r={sorter:c,index:i};break}}return r},_removeFromArray:function(a,f,t){var r=a.slice((t||f)+1||a.length);a.length=f<0?a.length+f:f;return a.push.apply(a,r)},clear:function(){this._aSortCondition=[]},addSorter:function(p,s){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add sort condition for unknown property name "+p}var e=this._containsSorter(p);if(e!=null){e.sorter.order=s;return this}var S=this._oEntityType.getSortablePropertyNames();if(q.inArray(p,S)===-1){throw"Cannot add sort condition for not sortable property name "+p}this._aSortCondition.push({property:P,order:s});return this},removeSorter:function(p){if(!p){return}var s=this._containsSorter(p);if(s){this._removeFromArray(this._aSortCondition,s.index)}},getExpressionsAsUI5SorterArray:function(){var s=[];for(var i=-1,c;(c=this._aSortCondition[++i])!==undefined;){s.push(new sap.ui.model.Sorter(c.property.name,c.order==o.SortOrder.Descending))}return s},getExpressionAsUI5Sorter:function(){var s=this.getExpressionsAsUI5SorterArray();if(s.length==0){return null}else{return s[0]}},getURIOrderByOptionValue:function(s){if(this._aSortCondition.length==0){return""}var O="";for(var i=-1,c;(c=this._aSortCondition[++i])!==undefined;){if(!s[c.property.name]){continue}O+=(O==""?"":",")+c.property.name+" "+c.order}return O},getEntityType:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},_oEntityType:null,_oSchema:null,_oModel:null,_aSortCondition:null};o.ParameterizationRequest=function(p){this._init(p)};o.ParameterizationRequest.prototype={_init:function(p){if(!p){throw"No parameterization given"}this._oParameterization=p;this._oParameterValueAssignment=[]},_renderParameterKeyValue:function(k,p){return q.sap.encodeURL(this._oParameterization.getTargetQueryResult().getModel().getODataModel().formatValue(k,p))},getParameterization:function(){return this._oParameterization},setParameterValue:function(p,v,t){var P=this._oParameterization.findParameterByName(p);if(!P){throw"Invalid parameter name "+p}if(t!=null){if(!P.isIntervalBoundary()){throw"Range value cannot be applied to parameter "+p+" accepting only single values"}if(!P.isLowerIntervalBoundary()){throw"Range value given, but parameter "+p+" does not hold the lower boundary"}}if(!P.isIntervalBoundary()){if(v==null){delete this._oParameterValueAssignment[p]}else{this._oParameterValueAssignment[p]=v}}else{if(v==null&&t!=null){throw"Parameter "+p+": An upper boundary cannot be given without the lower boundary"}if(v==null){delete this._oParameterValueAssignment[p];t=null}else{this._oParameterValueAssignment[p]=v}var u=P.getPeerIntervalBoundaryParameter();if(t==null){t=v}if(v==null){delete this._oParameterValueAssignment[u.getName()]}else{this._oParameterValueAssignment[u.getName()]=t}}return},getURIToParameterizationEntitySet:function(s){return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName()},getURIToParameterizationEntry:function(s){var d=this._oParameterization.getAllParameters();for(var D in d){if(this._oParameterValueAssignment[D]==undefined){throw"Parameter "+D+" has no value assigned"}}var k="",f=true;for(var p in this._oParameterValueAssignment){k+=(f?"":",")+p+"="+this._renderParameterKeyValue(this._oParameterValueAssignment[p],d[p].getProperty().type);f=false}return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName()+"("+k+")"},_oParameterization:null,_oParameterValueAssignment:null};o.QueryResultRequest=function(Q,p){this._init(Q)};o.QueryResultRequest.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oParameterizationRequest=p;this._oAggregationLevel={};this._oMeasures={};this._bIncludeEntityKey=false;this._oFilterExpression=null;this._oSortExpression=null;this._oSelectedPropertyNames=null},setParameterizationRequest:function(p){this._oParameterizationRequest=p},setResourcePath:function(r){this._sResourcePath=r;if(this._sResourcePath.indexOf("/")!=0){throw"Missing leading / (slash) for resource path"}if(this._oQueryResult.getParameterization()){var l=r.lastIndexOf("/");if(l==-1){throw"Missing navigation from parameter entity set to query result in resource path"}var n=r.substring(l+1);if(n!=this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()){throw"Invalid navigation property from parameter entity set to query result in resource path"}}},getParameterizationRequest:function(){return this._oParameterizationRequest},getQueryResult:function(){return this._oQueryResult},setAggregationLevel:function(d){this._oAggregationLevel={};if(!d){d=this._oQueryResult.getAllDimensionNames()}this.addToAggregationLevel(d);this._oSelectedPropertyNames=null},addToAggregationLevel:function(d){if(!d){return}this._oSelectedPropertyNames=null;for(var i=-1,D;(D=d[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(D)){throw D+" is not a valid dimension name"}this._oAggregationLevel[D]={key:true,text:false,attributes:null}}},removeFromAggregationLevel:function(d){if(!d){return}this._oSelectedPropertyNames=null;for(var i=-1,D;(D=d[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(D)){throw D+" is not a valid dimension name"}if(this._oAggregationLevel[D]!=undefined){delete this._oAggregationLevel[D];this.getSortExpression().removeSorter(D)}}},getAggregationLevel:function(){var d=[];for(var D in this._oAggregationLevel){d.push(D)}return d},getAggregationLevelDetails:function(d){if(this._oAggregationLevel[d]==undefined){throw"Aggregation level does not include dimension "+d}return this._oAggregationLevel[d]},setMeasures:function(m){if(!m){m=this._oQueryResult.getAllMeasureNames()}this._oSelectedPropertyNames=null;this._oMeasures={};for(var i=-1,M;(M=m[++i])!==undefined;){if(!this._oQueryResult.findMeasureByName(M)){throw M+" is not a valid measure name"}this._oMeasures[M]={value:true,text:false,unit:false}}},getMeasureNames:function(){var m=[];for(var M in this._oMeasures){m.push(M)}return m},includeDimensionKeyTextAttributes:function(d,I,b,a){this._oSelectedPropertyNames=null;var D=[];if(d){if(this._oAggregationLevel[d]==undefined){throw d+" is not included in the aggregation level"}D.push(d)}else{for(var n in this._oAggregationLevel){D.push(n)}a=null}for(var i=-1,s;(s=D[++i])!==undefined;){if(I!=null){this._oAggregationLevel[s].key=I}if(b!=null){this._oAggregationLevel[s].text=b}if(a!=null){this._oAggregationLevel[s].attributes=a}}},includeMeasureRawFormattedValueUnit:function(m,I,b,a){this._oSelectedPropertyNames=null;var M=[];if(m){if(this._oMeasures[m]==undefined){throw m+" is not part of the query result"}M.push(m)}else{for(var n in this._oMeasures){M.push(n)}}for(var i=-1,s;(s=M[++i])!==undefined;){if(I!=null){this._oMeasures[s].value=I}if(b!=null){this._oMeasures[s].text=b}if(a!=null){this._oMeasures[s].unit=a}}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oQueryResult.getEntityType();this._oFilterExpression=new o.FilterExpression(this._oQueryResult.getModel(),e.getSchema(),e)}return this._oFilterExpression},setFilterExpression:function(f){this._oFilterExpression=f},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oQueryResult.getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e)}return this._oSortExpression},setSortExpression:function(s){this._oSortExpression=s},setRequestOptions:function(i,I){if(i!=null){this._bIncludeEntityKey=i}if(I!=null){this._bIncludeCount=I}},setResultPageBoundaries:function(s,e){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric"}if(e!==null&&typeof e!=="number"){throw"End value must be null or numeric"}if(s==null){s=1}if(s<1||s>(e==null?s:e)){throw"Invalid values for requested page boundaries"}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(e!=null)?(e-s+1):null},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1}else{e=this._iSkipRequestOption+this._iTopRequestOption}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:e}},getURIToQueryResultEntitySet:function(s){var u=null;if(this._sResourcePath!=null){u=(s?s:"")+this._sResourcePath}else if(this._oQueryResult.getParameterization()){if(!this._oParameterizationRequest){throw"Missing parameterization request"}else{u=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()}}else{u=(s?s:"")+"/"+this._oQueryResult.getEntitySet().getQName()}return u},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var S="";this._oSelectedPropertyNames={};var d=null;for(var D in this._oAggregationLevel){var a=this._oQueryResult.findDimensionByName(D);var b=this._oAggregationLevel[D];if(b.key==true){d=a.getKeyProperty().name;if(this._oSelectedPropertyNames[d]==undefined){S+=(S==""?"":",")+d;this._oSelectedPropertyNames[d]=true}}if(b.text==true&&a.getTextProperty()){d=a.getTextProperty().name;if(this._oSelectedPropertyNames[d]==undefined){S+=(S==""?"":",")+d;this._oSelectedPropertyNames[d]=true}}if(b.attributes){for(var i=-1,A;(A=b.attributes[++i])!==undefined;){d=a.findAttributeByName(A).getName();if(this._oSelectedPropertyNames[d]==undefined){S+=(S==""?"":",")+d;this._oSelectedPropertyNames[d]=true}}}}var m;for(var M in this._oMeasures){var c=this._oQueryResult.findMeasureByName(M);var e=this._oMeasures[M];if(e.value==true){m=c.getRawValueProperty().name;if(this._oSelectedPropertyNames[m]==undefined){S+=(S==""?"":",")+m;this._oSelectedPropertyNames[m]=true}}if(e.text==true&&c.getFormattedValueProperty()){m=c.getFormattedValueProperty().name;if(this._oSelectedPropertyNames[m]==undefined){S+=(S==""?"":",")+m;this._oSelectedPropertyNames[m]=true}}if(e.unit==true&&c.getUnitProperty()){m=c.getUnitProperty().name;if(this._oSelectedPropertyNames[m]==undefined){S+=(S==""?"":",")+m;this._oSelectedPropertyNames[m]=true}}}if(this._bIncludeEntityKey){var k=this._oQueryResult.getEntityType().getTypeDescription().key.propertyRef;for(var j=-1,K;(K=k[++j])!==undefined;){S+=(S==""?"":",")+K.name}}s=(S?S:null);break}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue()}s=(f?f:null);break}case"$orderby":{var g=null;if(this._oSortExpression){g=this._oSortExpression.getURIOrderByOptionValue(this._oSelectedPropertyNames)}s=(g?g:null);break}case"$top":{if(this._iTopRequestOption!==null){s=this._iTopRequestOption}break}case"$skip":{s=this._iSkipRequestOption;break}case"$inlinecount":{s=(this._bIncludeCount==true?"allpages":null);break}default:break}return s},getURIToQueryResultEntries:function(s,r){if(!r){r=this.getURIToQueryResultEntitySet(s)}this.getFilterExpression().checkValidity();var S=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var a=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var b=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var Q=false;if(S){u+="?$select="+S;Q=true}if(this._oFilterExpression&&f){if(!Q){u+="?";Q=true}else{u+="&"}u+="$filter="+f}if(this._oSortExpression&&a){if(!Q){u+="?";Q=true}else{u+="&"}u+="$orderby="+a}if(this._iTopRequestOption&&t){if(!Q){u+="?";Q=true}else{u+="&"}u+="$top="+t}if(this._iSkipRequestOption&&b){if(!Q){u+="?";Q=true}else{u+="&"}u+="$skip="+b}if(this._bIncludeCount&&i){if(!Q){u+="?";Q=true}else{u+="&"}u+="$inlinecount="+i}return u},_oQueryResult:null,_oParameterizationRequest:null,_sResourcePath:null,_oAggregationLevel:null,_oMeasures:null,_bIncludeEntityKey:null,_bIncludeCount:null,_oFilterExpression:null,_oSortExpression:null,_iSkipRequestOption:0,_iTopRequestOption:null};o.ParameterValueSetRequest=function(p){this._init(p)};o.ParameterValueSetRequest.prototype={_init:function(p){this._oParameter=p;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null},includeParameterText:function(i){if(i!=null){this._oValueSetResult.text=i}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();var m=this._oParameter.getContainingParameterization().getTargetQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,e.getSchema(),e)}return this._oFilterExpression},setFilterExpression:function(f){this._oFilterExpression=f},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e)}return this._oSortExpression},setSortExpression:function(s){this._oSortExpression=s},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var S="";S+=(S==""?"":",")+this._oParameter.getProperty().name;if(this._oValueSetResult.text==true&&this._oParameter.getTextProperty()){S+=(S==""?"":",")+this._oParameter.getTextProperty().name}s=(S?S:null);break}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue()}s=(f?f:null);break}case"$orderby":{var a=null;if(this._oSortExpression){a=this._oSortExpression.getURIOrderByOptionValue()}s=(a?a:null);break}default:break}return s},getURIToParameterValueSetEntries:function(s){var r=null;r=(s?s:"")+"/"+this._oParameter.getContainingParameterization().getEntitySet().getQName();this.getFilterExpression().checkValidity();var S=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var a=this.getURIQueryOptionValue("$orderby");var u=r;var Q=false;if(S){u+="?$select="+S;Q=true}if(this._oFilterExpression&&f){if(!Q){u+="?";Q=true}else{u+="&"}u+="$filter="+f}if(this._oSortExpression&&a){if(!Q){u+="?";Q=true}else{u+="&"}u+="$orderby="+a}return u},_oParameter:null,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null};o.DimensionMemberSetRequest=function(d,p,u){this._init(d,p,u)};o.DimensionMemberSetRequest.prototype={_init:function(d,p,u){this._oDimension=d;this._oParameterizationRequest=p;this._bUseMasterData=u;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;if(this._oParameterizationRequest!=null&&this._bUseMasterData==true){throw"LIMITATION: parameterized master data entity sets are not yet implemented"}if(this._bUseMasterData){this._oEntitySet=this._oDimension.getMasterDataEntitySet()}else{this._oEntitySet=this._oDimension.getContainingQueryResult().getEntitySet();if(this._oDimension.getContainingQueryResult().getParameterization()&&!this._oParameterizationRequest){throw"Missing parameterization request"}}},setParameterizationRequest:function(p){this._oParameterizationRequest=p},includeDimensionTextAttributes:function(i,I){this._oValueSetResult.text={text:false,attributes:false};if(i==true){this._oValueSetResult.text=true}if(I==true){this._oValueSetResult.attributes=true}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oEntitySet.getEntityType();var m=this._oDimension.getContainingQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,e.getSchema(),e)}return this._oFilterExpression},setFilterExpression:function(f){this._oFilterExpression=f},getSortExpression:function(){if(this._oSortExpression==null){this._oSortExpression=new o.SortExpression(this._oEntityType.getModel(),this._oEntityType.getSchema(),this._oEntityType)}return this._oSortExpression},setSortExpression:function(s){this._oSortExpression=s},setRequestOptions:function(i){if(i!=null){this._bIncludeCount=i}},setResultPageBoundaries:function(s,e){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric"}if(e!==null&&typeof e!=="number"){throw"End value must be null or numeric"}if(s==null){s=1}if(s<1||s>(e==null?s:e)){throw"Invalid values for requested page boundaries"}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(e!=null)?(e-s+1):null},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1}else{e=this._iSkipRequestOption+this._iTopRequestOption}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:e}},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var S="";var e=this._oEntitySet.getEntityType();var K=e.getKeyProperties();var a=[];if(this._bUseMasterData){for(var i=-1,b;(b=K[++i])!==undefined;){S+=(S==""?"":",")+b;var c=e.getTextPropertyOfProperty(b);if(c){if(this._oValueSetResult.text==true){S+=","+c.name}a.push(c.name)}}}else{S+=(S==""?"":",")+this._oDimension.getKeyProperty().name;if(this._oValueSetResult.text==true&&this._oDimension.getTextProperty()){S+=(S==""?"":",")+this._oDimension.getTextProperty().name}}if(this._oValueSetResult.attributes){if(this._bUseMasterData){var A=e.getProperties();for(var p in A){var I=false;for(var j=-1,d;(d=K[++j])!==undefined;){if(p==d){I=true;break}}if(I){continue}for(var k=-1,f;(f=a[++k])!==undefined;){if(p==f){I=true;break}}if(!I){S+=","+p}}}else{var g=this._oDimension.getAllAttributeNames();for(var l=-1,h;(h=g[++l])!==undefined;){S+=(S==""?"":",")+this._oDimension.findAttributeByName(h).getName()}}}s=(S?S:null);break}case"$filter":{var F=null;if(this._oFilterExpression){F=this._oFilterExpression.getURIFilterOptionValue()}s=(F?F:null);break}case"$orderby":{var m=null;if(this._oSortExpression){m=this._oSortExpression.getURIOrderByOptionValue()}s=(m?m:null);break}case"$top":{if(this._iTopRequestOption!==null){s=this._iTopRequestOption}break}case"$skip":{s=this._iSkipRequestOption;break}case"$inlinecount":{s=(this._bIncludeCount==true?"allpages":null);break}default:break}return s},getURIToDimensionMemberEntitySet:function(s){var r=null;if(!this._bUseMasterData&&this._oParameterizationRequest){r=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oDimension.getContainingQueryResult().getParameterization().getNavigationPropertyToQueryResult()}else{r=(s?s:"")+"/"+this._oEntitySet.getQName()}return r},getURIToDimensionMemberEntries:function(s){var r=this.getURIToDimensionMemberEntitySet(s);this.getFilterExpression().checkValidity();var S=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var a=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var b=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var Q=false;if(S){u+="?$select="+S;Q=true}if(this._oFilterExpression&&f){if(!Q){u+="?";Q=true}else{u+="&"}u+="$filter="+f}if(this._oSortExpression&&a){if(!Q){u+="?";Q=true}else{u+="&"}u+="$orderby="+a}if(this._iTopRequestOption&&t){if(!Q){u+="?";Q=true}else{u+="&"}u+="$top="+t}if(this._iSkipRequestOption&&b){if(!Q){u+="?";Q=true}else{u+="&"}u+="$skip="+b}if(this._bIncludeCount&&i){if(!Q){u+="?";Q=true}else{u+="&"}u+="$inlinecount="+i}return u},_oDimension:null,_oParameterizationRequest:null,_oEntitySet:null,_bUseMasterData:false,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null,_bIncludeCount:null,_iSkipRequestOption:0,_iTopRequestOption:null};return o},true);
