/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/Model','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','sap/ui/model/odata/v2/ODataTreeBinding','sap/ui/thirdparty/URI','sap/ui/thirdparty/datajs'],function(q,M,O,C,a,b,c,d,e,U,f){"use strict";var g=M.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(s,p){M.apply(this,arguments);var u,P,h,t,w,m,i,r,A,l,D,j,k,S,n,o,J,v=this;if(typeof(s)==="object"){p=s;s=p.serviceUrl}if(p){u=p.user;P=p.password;h=p.headers;t=p.tokenHandling;w=p.withCredentials;m=p.maxDataServiceVersion;i=p.useBatch;r=p.refreshAfterChange;A=p.annotationURI;l=p.loadAnnotationsJoined;j=p.defaultBindingMode;D=p.defaultCountMode;k=p.metadataNamespaces;S=p.serviceUrlParams;n=p.metadataUrlParams;J=p.json}this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.sDefaultBindingMode=j||sap.ui.model.BindingMode.OneWay;this.bJSON=J!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredBatchGroups={};this.mChangeBatchGroups={'*':{batchGroupId:undefined,single:true}};this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=i!==false;this.bRefreshAfterChange=r!==false;this.sMaxDataServiceVersion=m;this.bLoadMetadataAsync=true;this.bLoadAnnotationsJoined=l!==false;this.sAnnotationURI=A;this.sDefaultCountMode=D||C.Request;this.oMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshBatchGroupId=undefined;this.sDefaultChangeBatchGroup="changes";this.setDeferredBatchGroups([this.sDefaultChangeBatchGroup]);this.setChangeBatchGroups({"*":{batchGroupId:this.sDefaultChangeBatchGroup}});if(this.sAnnotationURI){q.sap.require("sap.ui.model.odata.ODataAnnotations")}this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.sServiceUrl=s;var x=s.split("?");if(x[1]){this.sServiceUrl=x[0];this.aUrlParams.push(x[1])}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=u;this.sPassword=P;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true")}this.oServiceData=g.mServiceData[this.sServiceUrl];if(!this.oServiceData){g.mServiceData[this.sServiceUrl]={};this.oServiceData=g.mServiceData[this.sServiceUrl]}if(!this.oServiceData.oMetadata){o=O._createUrlParamsArray(n);this.oMetadata=new sap.ui.model.odata.ODataMetadata(this._createRequestUrl("/$metadata",undefined,o),{async:this.bLoadMetadataAsync,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:k,withCredentials:this.bWithCredentials});this.oServiceData.oMetadata=this.oMetadata}else{this.oMetadata=this.oServiceData.oMetadata}if(S){this.aUrlParams=this.aUrlParams.concat(O._createUrlParamsArray(S))}if(!this.oMetadata.isLoaded()){this.oMetadata.attachLoaded(function(E){v._initializeMetadata()},this);this.oMetadata.attachFailed(function(E){v.fireMetadataFailed(E.getParameters())})}if(this.oMetadata.isFailed()){this.refreshMetadata()}if(this.sAnnotationURI){this.oAnnotations=new sap.ui.model.odata.ODataAnnotations(this.sAnnotationURI,this.oMetadata,{async:this.bLoadMetadataAsync});this.oAnnotations.attachFailed(function(E){v.fireAnnotationsFailed(E.getParameters())});this.oAnnotations.attachLoaded(function(E){v.fireAnnotationsLoaded(E.getParameters())})}if(this.oMetadata.isLoaded()){this._initializeMetadata(true)}this.oHeaders={};this.setHeaders(h);if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata"}else{this.oHeaders["Accept"]="application/json"}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml"}if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguage();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","hasPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});g.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};g.prototype.attachBatchRequestFailed=function(D,F,l){this.attachEvent("batchRequestFailed",D,F,l);return this};g.prototype.detachBatchRequestFailed=function(F,l){this.detachEvent("batchRequestFailed",F,l);return this};g.prototype.fireBatchRequestFailed=function(A){this.fireEvent("batchRequestFailed",A);return this};g.prototype.attachBatchRequestSent=function(D,F,l){this.attachEvent("batchRequestSent",D,F,l);return this};g.prototype.detachBatchRequestSent=function(F,l){this.detachEvent("batchRequestSent",F,l);return this};g.prototype.fireBatchRequestSent=function(A){this.fireEvent("batchRequestSent",A);return this};g.prototype.attachBatchRequestCompleted=function(D,F,l){this.attachEvent("batchRequestCompleted",D,F,l);return this};g.prototype.detachBatchRequestCompleted=function(F,l){this.detachEvent("batchRequestCompleted",F,l);return this};g.prototype.fireBatchRequestCompleted=function(A){this.fireEvent("batchRequestCompleted",A);return this};g.mServiceData={};g.prototype.fireRejectChange=function(A){this.fireEvent("rejectChange",A);return this};g.prototype.attachRejectChange=function(D,F,l){this.attachEvent("rejectChange",D,F,l);return this};g.prototype.detachRejectChange=function(F,l){this.detachEvent("rejectChange",F,l);return this};g.prototype._initializeMetadata=function(D){var t=this;this.bUseBatch=this.bUseBatch||this.oMetadata.getUseBatch();var h=function(i,j){if(j){t.metadataLoadEvent=q.sap.delayedCall(0,t,h,[t.bLoadMetadataAsync])}else{if(i){t.initialize()}t.fireMetadataLoaded({metadata:t.oMetadata});q.sap.log.debug(t+" - metadataloaded fired")}};if(this.bLoadMetadataAsync&&this.sAnnotationURI&&this.bLoadAnnotationsJoined){if(this.oAnnotations&&this.oAnnotations.bInitialized){h(true)}else{this.oAnnotations.attachLoaded(function(){h(true)},this)}}else{h(this.bLoadMetadataAsync,D)}};g.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){this.oMetadata.refresh()}};g.prototype.fireAnnotationsLoaded=function(A){this.fireEvent("annotationsLoaded",A);return this};g.prototype.attachAnnotationsLoaded=function(D,F,l){this.attachEvent("annotationsLoaded",D,F,l);return this};g.prototype.detachAnnotationsLoaded=function(F,l){this.detachEvent("annotationsLoaded",F,l);return this};g.prototype.fireAnnotationsFailed=function(A){this.fireEvent("annotationsFailed",A);q.sap.log.debug(this+" - annotationsfailed fired");return this};g.prototype.attachAnnotationsFailed=function(D,F,l){this.attachEvent("annotationsFailed",D,F,l);return this};g.prototype.detachAnnotationsFailed=function(F,l){this.detachEvent("annotationsFailed",F,l);return this};g.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this};g.prototype.attachMetadataLoaded=function(D,F,l){this.attachEvent("metadataLoaded",D,F,l);return this};g.prototype.detachMetadataLoaded=function(F,l){this.detachEvent("metadataLoaded",F,l);return this};g.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this};g.prototype.attachMetadataFailed=function(D,F,l){this.attachEvent("metadataFailed",D,F,l);return this};g.prototype.detachMetadataFailed=function(F,l){this.detachEvent("metadataFailed",F,l);return this};g.prototype._createEventInfo=function(r,R,B){var E={};E.url=r.requestUri;E.method=r.method;E.async=r.async;E.headers=r.headers;if(B){E.requests=[];for(var i=0;i<B.length;i++){var o={};if(q.isArray(B[i])){var h=B[i];for(var j=0;j<h.length;j++){var r=h[j].request;var I=B[i][j].response;o.url=r.requestUri;o.method=r.method;o.headers=r.headers;if(I){o.response={};o.success=true;if(I.message){o.response.message=I.message;I=I.response;o.response.responseText=I.body;o.success=false}o.response.headers=I.headers;o.response.statusCode=I.statusCode;o.response.statusText=I.statusText}E.requests.push(o)}}else{var r=B[i].request;var I=B[i].response;o.url=r.requestUri;o.method=r.method;o.headers=r.headers;if(I){o.response={};o.success=true;if(I.message){o.response.message=I.message;I=I.response;o.response.responseText=I.body;o.success=false}o.response.headers=I.headers;o.response.statusCode=I.statusCode;o.response.statusText=I.statusText}E.requests.push(o)}}}if(R){E.response={};E.success=true;if(R.message){E.response.message=R.message;E.success=false}if(R.response){R=R.response}if(R&&R.statusCode){E.response.headers=R.headers;E.response.statusCode=R.statusCode;E.response.statusText=R.statusText;E.response.responseText=R.body!==undefined?R.body:R.responseText}}E.ID=r.requestID;return E};g.prototype._createRequestID=function(){var r;r=q.sap.uid();return r};g.prototype._createRequestUrl=function(p,o,u,B){var n,A=[],s="";n=this._normalizePath(p,o);if(!B){s=this.sServiceUrl+n}else{s=n.substr(n.indexOf('/')+1)}if(this.aUrlParams){A=A.concat(this.aUrlParams)}if(u){A=A.concat(u)}if(A&&A.length>0){s+="?"+A.join("&")}return s};g.prototype._importData=function(D,m){var t=this,l,k,r,E;if(D.results){l=[];q.each(D.results,function(i,h){var k=t._importData(h,m);if(k){l.push(k)}});return l}else{k=this._getKey(D);if(!k){return k}E=this.oData[k];if(!E){E=D;this.oData[k]=E}q.each(D,function(n,p){if(p&&(p.__metadata&&p.__metadata.uri||p.results)&&!p.__deferred){r=t._importData(p,m);if(q.isArray(r)){E[n]={__list:r}}else{E[n]={__ref:r}}}else if(!p||!p.__deferred){E[n]=p}});m[k]=true;return k}};g.prototype._removeReferences=function(D){var t=this,l;if(D.results){l=[];q.each(D.results,function(i,h){l.push(t._removeReferences(h))});return l}else{q.each(D,function(p,o){if(o){if(o["__ref"]||o["__list"]){delete D[p]}}});return D}};g.prototype._restoreReferences=function(D){var t=this,l,r=[];if(D.results){l=[];q.each(D.results,function(i,h){l.push(t._restoreReferences(h))});return l}else{q.each(D,function(p,o){if(o&&o["__ref"]){var h=t._getObject("/"+o["__ref"]);if(h){delete o["__ref"];D[p]=h;t._restoreReferences(h)}}else if(o&&o["__list"]){q.each(o["__list"],function(j,E){var h=t._getObject("/"+o["__list"][j]);if(h){r.push(h);t._restoreReferences(h)}});delete o["__list"];o.results=r;r=[]}});return D}};g.prototype.removeData=function(){this.oData={}};g.prototype.initialize=function(){var B=this.aBindings.slice(0);q.each(B,function(i,o){o.initialize()})};g.prototype.refresh=function(F,r,B){if(r){this.removeData()}this._refresh(F,B)};g.prototype._refresh=function(F,B,m,E){var h=this.aBindings.slice(0);this.sRefreshBatchGroupId=B;q.each(h,function(i,o){o.refresh(F,m,E)});this.sRefreshBatchGroupId=undefined};g.prototype.checkUpdate=function(F,m){var B=this.aBindings.slice(0);q.each(B,function(I,o){o.checkUpdate(F,m)});for(var i=0;i<this.aCallAfterUpdate.length;i++){this.aCallAfterUpdate[i]()}this.aCallAfterUpdate=[]};g.prototype.bindProperty=function(p,o,P){var B=new d(this,p,o,P);return B};g.prototype.bindList=function(p,o,s,F,P){var B=new b(this,p,o,s,F,P);return B};g.prototype.bindTree=function(p,o,F,P){var B=new e(this,p,o,F,P);return B};g.prototype.createBindingContext=function(p,o,P,h,r){var F=this.resolve(p,o);r=!!r;if(typeof o=="function"){h=o;o=null}if(typeof P=="function"){h=P;P=null}var D=this._getObject(p,o),k,n,t=this;if(!r){r=this._isReloadNeeded(F,D,P)}if(!r){k=this._getKey(D);n=this.getContext('/'+k);h(n)}else{var i=!q.sap.startsWith(p,"/");if(F){var j=[],s=this.createCustomParams(P);if(s){j.push(s)}var l=function(D){k=D?t._getKey(D):undefined;if(k&&o&&i){var u=o.getPath();u=u.substr(1);if(t.oData[u]){t.oData[u][p]={__ref:k}}}n=t.getContext('/'+k);h(n)};var m=function(E){if(E.statusCode=='404'&&o&&i){var u=o.getPath();u=u.substr(1);if(t.oData[u]){t.oData[u][p]={__ref:null}}}h(null)};this.read(F,{urlParameters:j,success:l,error:m})}else{h(null)}}};g.prototype._isReloadNeeded=function(F,D,p){var n,N=[],s,S=[],i;if(!D){return true}if(p&&p["expand"]){n=p["expand"].replace(/\s/g,"");N=n.split(',')}if(N){for(i=0;i<N.length;i++){var h=N[i].indexOf("/");if(h!==-1){var j=N[i].slice(0,h);var k=N[i].slice(h+1);N[i]=[j,k]}}}for(i=0;i<N.length;i++){var l=N[i];if(q.isArray(l)){var o=D[l[0]];var m=l[1];if(!o||(o&&o.__deferred)){return true}else{if(o){var P,r,R;if(o.__list&&o.__list.length>0){for(var t=0;t<o.__list.length;t++){P="/"+o.__list[t];r=this.getObject(P);R=this._isReloadNeeded(P,r,{expand:m});if(R){return true}}}else if(o.__ref){P="/"+o.__ref;r=this.getObject(P);R=this._isReloadNeeded(P,r,{expand:m});if(R){return true}}}}}else{if(D[l]===undefined||(D[l]&&D[l].__deferred)){return true}}}if(p&&p["select"]){s=p["select"].replace(/\s/g,"");S=s.split(',')}for(i=0;i<S.length;i++){if(D[S[i]]===undefined){return true}}if(S.length===0){var E=this.oMetadata._getEntityTypeByPath(F);if(!E){return false}else{for(i=0;i<E.property.length;i++){if(D[E.property[i].name]===undefined){return true}}}}return false};g.prototype.createCustomParams=function(p){var h=[],m,s={expand:true,select:true};for(var n in p){if(n in s){h.push("$"+n+"="+q.sap.encodeURL(p[n]))}if(n==="custom"){m=p[n];for(n in m){if(n.indexOf("$")===0){q.sap.log.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!")}else{h.push(n+"="+q.sap.encodeURL(m[n]))}}}}return h.join("&")};g.prototype.bindContext=function(p,o,P){var B=new a(this,p,o,P);return B};g.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s};g.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode};g.prototype._getKey=function(o){var k,u;if(o instanceof sap.ui.model.Context){k=o.getPath().substr(1)}else if(o&&o.__metadata&&o.__metadata.uri){u=o.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1)}return k};g.prototype.getKey=function(o){return this._getKey(o)};g.prototype.createKey=function(s,k){var E=this.oMetadata._getEntityTypeByPath(s),K=s,t=this,n,p;K+="(";if(E.key.propertyRef.length===1){n=E.key.propertyRef[0].name;p=this.oMetadata._getPropertyMetadata(E,n);K+=O.formatValue(k[n],p.type)}else{q.each(E.key.propertyRef,function(i,P){if(i>0){K+=","}n=P.name;p=t.oMetadata._getPropertyMetadata(E,n);K+=n;K+="=";K+=O.formatValue(k[n],p.type)})}K+=")";return K};g.prototype.getProperty=function(p,o,i){var v=this._getObject(p,o);if(!i){return v}if(!q.isPlainObject(v)){return v}v=q.extend(true,{},v);if(i===true){return this._restoreReferences(v)}else{return this._removeReferences(v)}};g.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null,r,k;if(this.oMetadata&&p&&p.indexOf('#')>-1){r=this.resolve(p,o);if(r){n=this.oMetadata._getAnnotation(r)}}else{if(o){k=o.getPath();k=k.substr(1);n=this.mChangedEntities[k]?this.mChangedEntities[k]:this.oData[k]}if(!p){return n}var P=p.split("/"),i=0;if(!P[0]){i++;if(this.mChangedEntities[P[i]]){n=this.mChangedEntities}else{n=this.oData}}while(n&&P[i]){n=n[P[i]];if(n){if(n.__ref){n=this.oData[n.__ref]}else if(n.__list){n=n.__list}else if(n.__deferred){n=undefined}}i++}}return n};g.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken()}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken}}};g.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"]};g.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken}return t};g.prototype.refreshSecurityToken=function(s,E){var t=this,u,T;u=this._createRequestUrl("/");var r=this._createRequest(u,"GET",null,null,null,false);r.headers["x-csrf-token"]="Fetch";function _(D,R){if(R){T=t._getHeader("x-csrf-token",R.headers);if(T){t.oServiceData.securityToken=T;t.oHeaders["x-csrf-token"]=T}else{t.resetSecurityToken();t.bTokenHandling=false}}if(s){s(D,R)}}function h(o){t.resetSecurityToken();t.bTokenHandling=false;t._handleError(o);if(E){E(o)}}return this._request(r,_,h,undefined,undefined,this.getServiceMetadata())};g.prototype._submitRequest=function(r,s,E){var t=this,h;function _(D,R){if(s){s(D,R)}}function i(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!r.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){t.resetSecurityToken();r.bTokenReset=true;j();return}}t._handleError(o);if(E){E(o)}}function j(){if(t.bTokenHandling&&r.method!=="GET"){t.updateSecurityToken();if(t.bTokenHandling){r.headers["x-csrf-token"]=t.oServiceData.securityToken}}h=t._getODataHandler(r.requestUri);return t._request(r,_,i,h,undefined,t.getServiceMetadata())}return j()};g.prototype._submitSingleRequest=function(r,s,E){var t=this,R,m={},G={},h={},o;var i=function(D,k){var S=function(D,k){if(s){s(D,k)}if(r.requestUri.indexOf("$count")===-1){t.checkUpdate(false,G);if(t._isRefreshNeeded(r,k)){t._refresh(false,undefined,m,h)}}t._updateChangedEntities(m)};t._processSuccess(r,k,S,G,m,h)};var j=function(k){if(E){E(t._handleError(k))}o=t._createEventInfo(r,k);t.fireRequestCompleted(o);if(!R||!R.bAborted){t.fireRequestFailed(o)}};R=this._submitRequest(r,i,j);o=this._createEventInfo(r);this.fireRequestSent(o);return R};g.prototype._submitBatchRequest=function(B,r,s,E){var t=this;var h=function(D,o){var m,n,p,u=D.__batchResponses,v,w={},G={},x={};if(u){var i,j;for(i=0;i<u.length;i++){m=u[i];if(q.isArray(r[i])){if(m.message){for(j=0;j<r[i].length;j++){n=r[i][j];if(!n.request._aborted){t._processError(n.request,m,n.fnError)}n.response=m}}else{p=m.__changeResponses;for(j=0;j<p.length;j++){var y=p[j];n=r[i][j];if(!n.request._aborted){if(y.message){t._processError(n.request,y,n.fnError)}else{t._processSuccess(n.request,y,n.fnSuccess,G,w,x)}}n.response=y}}}else{n=r[i];if(!n.request._aborted){if(m.message){t._processError(n.request,m,n.fnError)}else{t._processSuccess(n.request,m,n.fnSuccess,G,w,x)}}n.response=m}}t.checkUpdate(false,G)}if(s){s(D)}v=t._createEventInfo(B,o,r);t.fireBatchRequestCompleted(v)};var k=function(o){if(E){E(o)}l("Completed",B,o,r);if(!R||!R.bAborted){l("Failed",B,o,r)}};var l=function(T,B,o,r){var j;q.each(r,function(i,m){if(q.isArray(m)){q.each(m,function(i,m){j=t._createEventInfo(m.request,o);t["fireRequest"+T](j)})}else{j=t._createEventInfo(m.request,o);t["fireRequest"+T](j)}});j=t._createEventInfo(B,o,r);t["fireBatchRequest"+T](j)};var R=this._submitRequest(B,h,k);l("Sent",B,null,r);return R};g.prototype._createBatchRequest=function(B){var u,r,o={},p={};p.__batchRequests=B;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&")}q.extend(o,this.mCustomHeaders,this.oHeaders);delete o["Content-Type"];r={headers:o,requestUri:u,method:"POST",data:p,user:this.sUser,password:this.sPassword,async:true};r.withCredentials=this.bWithCredentials;return r};g.prototype._pushToRequestQueue=function(r,B,s,R,S,E){var o,h=r[B];if(!h){h={};h.requests=[];r[B]=h}if(R.method!=="GET"){if(!h.changes){h.changes={}}if(R.key&&h.map&&R.key in h.map){if(R.method==="POST"){h.map[R.key].method="POST"}if(h.map[R.key]._aborted){delete h.map[R.key]._aborted}h.map[R.key].data=R.data}else{o=h.changes[s];if(!o){o=[];h.changes[s]=o}R._changeSetId=s;o.push({request:R,fnSuccess:S,fnError:E,changeSetId:s});if(R.key){if(!h.map){h.map={}}h.map[R.key]=R}}}else{h.requests.push({request:R,fnSuccess:S,fnError:E})}};g.prototype._collectChangedEntities=function(G,m,E){var t=this;if(G.changes){q.each(G.changes,function(s,h){for(var i=0;i<h.length;i++){var r=h[i].request;if(r.method==="POST"){var o=t.oMetadata._getEntityTypeByPath("/"+r.requestUri);if(o){E[o.entityType]=true}}else{m[r.requestUri]=true}}})}};g.prototype._processRequestQueue=function(r,B,s,E){var t=this,R=[];if(this.oRequestTimer&&r!==this.mDeferredRequests){q.sap.clearDelayedCall(this.oRequestTimer);this.oRequestTimer=undefined}if(this.bUseBatch){if(t.bRefreshAfterChange){q.each(r,function(G,o){if(G===B||!B){var m={},h={};t._collectChangedEntities(o,m,h);t._refresh(false,G,m,h)}})}q.each(r,function(G,o){if(G===B||!B){var h=[],j=[],k;if(o.changes){q.each(o.changes,function(n,p){k={__changeRequests:[]};for(var i=0;i<p.length;i++){if(!p[i].request._aborted){if(p[i].request.data&&p[i].request.data.__metadata){delete p[i].request.data.__metadata.created}k.__changeRequests.push(p[i].request)}}if(k.__changeRequests&&k.__changeRequests.length>0){h.push(k);j.push(o.changes[n])}})}if(o.requests){var l=o.requests;for(var i=0;i<l.length;i++){if(!l[i].request._aborted){h.push(l[i].request);j.push(l[i])}}}if(h.length>0){var m=t._createBatchRequest(h,true);R.push(t._submitBatchRequest(m,j,s,E))}delete r[G]}})}else{q.each(r,function(G,o){if(G===B||!B){if(o.changes){q.each(o.changes,function(j,k){for(var i=0;i<k.length;i++){if(!k[i].request._aborted){R.push(t._submitSingleRequest(k[i].request,k[i].fnSuccess,k[i].fnError))}}})}if(o.requests){var h=o.requests;for(var i=0;i<h.length;i++){if(!h[i].request._aborted){R.push(t._submitSingleRequest(h[i].request,h[i].fnSuccess,h[i].fnError))}}}delete r[G]}})}return R.length==1?R[0]:R};g.prototype._processSuccess=function(r,R,s,G,m,E){var o=R.data,h,u,p,P,i,t=this;h=!(R.statusCode===204||R.statusCode==='204');if(h&&!o&&R){q.sap.log.fatal(this+" - No data was retrieved by service: '"+R.requestUri+ +"'");t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false}if(o&&o.results&&!q.isArray(o.results)){o=o.results}if(o&&(q.isArray(o)||typeof o=='object')){o=q.extend(true,{},o);t._importData(o,G)}u=r.requestUri;p=u.replace(this.sServiceUrl,"");if(!q.sap.startsWith(p,'/')){p='/'+p}p=this._normalizePath(p);if(!h){P=p.split("/");if(P[1]){m[P[1]]=true;var j={};j[P[1]]=true;this._updateChangedEntities(j)}if(r.method==="DELETE"){delete t.oData[P[1]];delete t.mContexts["/"+P[1]]}}if(h&&r.method==="POST"){i=this.oMetadata._getEntityTypeByPath(p);if(i){E[i.entityType]=true}if(r.context){var k=this._getKey(o);delete this.mChangedEntities[r.context.sPath.substr(1)];delete this.oData[r.context.sPath.substr(1)];r.context.sPath='/'+k}}this._updateETag(r,R);if(s){s(R.data,R)}var l=this._createEventInfo(r,R);this.fireRequestCompleted(l);return true};g.prototype._processError=function(r,R,E){var o=this._handleError(R);if(E){E(o)}var h=this._createEventInfo(r,o);this.fireRequestCompleted(h);this.fireRequestFailed(h)};g.prototype._processChange=function(k,D,m){var p,E,s,h,u,r,t;E=this.oMetadata._getEntityTypeByPath(k);m=m!==false;if(D.__metadata&&D.__metadata.created){h="POST";k=D.__metadata.created.key}else if(m){h="MERGE"}else{h="PUT"}p=q.extend(true,{},D);if(p.__metadata){t=p.__metadata.type;s=p.__metadata.etag;delete p.__metadata;if(t||s){p.__metadata={}}if(t){p.__metadata.type=t}if(s){p.__metadata.etag=s}}q.each(p,function(P,o){if(o&&o.__deferred){delete p[P]}});if(E){var n=this.oMetadata._getNavigationPropertyNames(E);q.each(n,function(i,N){delete p[N]})}p=this._removeReferences(p);u=this._createRequestUrl('/'+k);r=this._createRequest(u,h,undefined,p,s);if(this.bUseBatch){r.requestUri=r.requestUri.replace(this.sServiceUrl+'/','')}return r};g.prototype._resolveGroup=function(k){var o,E,B,s;E=this.oMetadata._getEntityTypeByPath(k);if(this.mChangeBatchGroups[E.name]){o=this.mChangeBatchGroups[E.name];B=o.batchGroupId;s=o.single?q.sap.uid():o.changeSetId}else if(this.mChangeBatchGroups['*']){o=this.mChangeBatchGroups['*'];B=o.batchGroupId;s=o.single?q.sap.uid():o.changeSetId}return{batchGroupId:B,changeSetId:s}};g.prototype._updateETag=function(r,R){var u,E,s;u=r.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u}E=this._getObject(u);s=this._getHeader("etag",R.headers);if(E&&E.__metadata&&s){E.__metadata.etag=s}};g.prototype._handleError=function(E){var p={},t;var s="The following problem occurred: "+E.message;p.message=E.message;if(E.response){if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()==="required"){this.resetSecurityToken()}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;p.statusCode=E.response.statusCode;p.statusText=E.response.statusText;p.headers=E.response.headers;p.responseText=E.response.body}q.sap.log.fatal(s);return p};g.prototype.getData=function(p,o,i){return this.getProperty(p,o,i)};g.prototype._getODataHandler=function(u){if(u.indexOf("$batch")>-1){return OData.batchHandler}else if(u.indexOf("$count")>-1){return undefined}else if(this.bJSON){return OData.jsonHandler}else{return OData.atomHandler}};g.prototype._getETag=function(p,D){var E,s,i;if(D&&D.__metadata){E=D.__metadata.etag}else if(p){s=p.replace(this.sServiceUrl+'/','');i=s.indexOf("?");if(i>-1){s=s.substr(0,i)}if(this.oData.hasOwnProperty(s)){E=this.getProperty('/'+s+'/__metadata/etag')}}return E};g.prototype._createRequest=function(u,m,h,D,E,A){var H=this._getHeaders(h);E=E||this._getETag(u,D);A=A!==false;if(E&&m!=="GET"){H["If-Match"]=E}if(this.bJSON&&m!=="DELETE"&&this.sMaxDataServiceVersion==="2.0"){H["Content-Type"]="application/json"}if(u.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5"}if(m==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";m="POST"}var r={headers:H,requestUri:u,method:m,user:this.sUser,password:this.sPassword,async:A};if(D){r.data=D}if(this.bWithCredentials){r.withCredentials=this.bWithCredentials}r.requestID=this._createRequestID();return r};g.prototype._isRefreshNeeded=function(r,R){var h=false;if(this.bRefreshAfterChange){h=true}return h};g.prototype.update=function(p,D,P){var s,E,m,r,u,o,h,R,S,k,i,B,j,l,H,n,t;if(P){B=P.batchGroupId;j=P.changeSetId;o=P.context;s=P.success;E=P.error;h=P.eTag;H=P.headers;m=P.merge!==false;l=P.urlParameters}i=O._createUrlParamsArray(l);u=this._createRequestUrl(p,o,i,this.bUseBatch);n=m?"MERGE":"PUT";r=this._createRequest(u,n,H,D,h);p=this._normalizePath(p,o);S=this._getObject(p);r.keys={};if(S){k=this._getKey(S);r.keys[k]=true}t=this.mRequests;if(B in this.mDeferredBatchGroups){t=this.mDeferredRequests}this._pushToRequestQueue(t,B,j,r,s,E);if(this.bUseBatch){R={abort:function(){r._aborted=true}};if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests])}}else{R=this._processRequestQueue(this.mRequests)}return R};g.prototype.create=function(p,D,P){var r,u,R,E,o,s,h,m,i,H,j,k,B,l,n;if(P){o=P.context;m=P.urlParameters;s=P.success;h=P.error;B=P.batchGroupId;n=P.changeSetId;k=P.eTag;H=P.headers}j=O._createUrlParamsArray(m);l="POST";u=this._createRequestUrl(p,o,j,this.bUseBatch);r=this._createRequest(u,l,H,D,k);p=this._normalizePath(p,o);E=this.oMetadata._getEntityTypeByPath(p);r.entityTypes={};if(E){r.entityTypes[E.entityType]=true}i=this.mRequests;if(B in this.mDeferredBatchGroups){i=this.mDeferredRequests}this._pushToRequestQueue(i,B,n,r,s,h);if(this.bUseBatch){R={abort:function(){r._aborted=true}};if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests])}}else{R=this._processRequestQueue(this.mRequests)}return R};g.prototype.remove=function(p,P){var o,E,s,h,r,u,B,i,j,k,R,m,H,l,n,t,v=this;if(P){B=P.batchGroupId;i=P.changeSetId;o=P.context;s=P.success;h=P.error;j=P.eTag;H=P.headers;m=P.urlParameters}l=O._createUrlParamsArray(m);k=function(D,w){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!==-1){E=E.substr(0,E.indexOf('?'))}delete v.oData[E];delete v.mContexts["/"+E];if(s){s(D,w)}};n="DELETE";u=this._createRequestUrl(p,o,l,this.bUseBatch);r=this._createRequest(u,n,H,undefined,j);t=this.mRequests;if(B in this.mDeferredBatchGroups){t=this.mDeferredRequests}this._pushToRequestQueue(t,B,i,r,k,h);if(this.bUseBatch){R={abort:function(){r._aborted=true}};if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests])}}else{R=this._processRequestQueue(this.mRequests)}return R};g.prototype.callFunction=function(F,p){var r,u,R,o,m,h,s,E,i="GET",j=[],B,k,H;if(p){B=p.batchGroupId;k=p.changeSetId;i=p.method?p.method:i;h=p.urlParameters;s=p.success;E=p.error;H=p.headers}if(!q.sap.startsWith(F,"/")){q.sap.log.fatal(this+" callFunction: path '"+F+"' must be absolute!");return}o=this.oMetadata._getFunctionImportMetadata(F,i);if(o){if(o.parameter!=null){q.each(h,function(P,l){var n=q.grep(o.parameter,function(v){return v.name===P&&v.mode==="In"});if(n!=null&&n.length>0){var t=n[0];j.push(P+"="+O.formatValue(l,t.type))}else{q.sap.log.warning(this+" - Parameter '"+P+"' is not defined for function call '"+F+"'!")}})}u=this._createRequestUrl(F,null,j,this.bUseBatch);r=this._createRequest(u,i,H,undefined);m=this.mRequests;if(B in this.mDeferredBatchGroups){m=this.mDeferredRequests}this._pushToRequestQueue(m,B,k,r,s,E);if(this.bUseBatch){R={abort:function(){r._aborted=true}};if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests])}}else{R=this._processRequestQueue(this.mRequests)}}return R};g.prototype.read=function(p,P){var r,u,R,o,m,s,E,F,S,h,i,j,n,k,H,l,B,t;if(P){o=P.context;m=P.urlParameters;s=P.success;E=P.error;F=P.filters;S=P.sorters;B=P.batchGroupId;H=P.headers}if(this.sRefreshBatchGroupId){B=this.sRefreshBatchGroupId}k=O._createUrlParamsArray(m);i=O.createSortParams(S);if(i){k.push(i)}if(p.indexOf("$count")===-1){if(F&&!this.oMetadata){q.sap.log.fatal(this+" - Tried to use filters in read method before metadata is available.")}else{n=this._normalizePath(p,o);j=this.oMetadata&&this.oMetadata._getEntityTypeByPath(n);h=O.createFilterParams(F,this.oMetadata,j);if(h){k.push(h)}}}l="GET";u=this._createRequestUrl(p,o,k,this.bUseBatch);r=this._createRequest(u,l,H);t=this.mRequests;if(B in this.mDeferredBatchGroups){t=this.mDeferredRequests}this._pushToRequestQueue(t,B,null,r,s,E);if(this.bUseBatch){R={abort:function(){r._aborted=true}};if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests])}}else{R=this._processRequestQueue(this.mRequests)}return R};g.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata()}};g.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData()}};g.prototype.submitChanges=function(p){var m=true,r,B,G,s,E,t=this;if(p){B=p.batchGroupId;s=p.success;E=p.error;B=p.batchGroupId;m=p.merge!==false}q.each(this.mChangedEntities,function(k,D){G=t._resolveGroup(k);if(G.batchGroupId===B||!B){r=t._processChange(k,D,m);r.key=k;if(G.batchGroupId in t.mDeferredBatchGroups){t._pushToRequestQueue(t.mDeferredRequests,G.batchGroupId,G.changeSetId,r)}}});return this._processRequestQueue(this.mDeferredRequests,B,s,E)};g.prototype._updateChangedEntities=function(m){var t=this;q.each(m,function(k,h){if(k in t.mChangedEntities){var o=t._getObject('/'+k);delete t.mChangedEntities[k];var E=t._getObject('/'+k);q.extend(true,E,o)}})};g.prototype.resetChanges=function(k){var t=this;if(k){q.each(k,function(i,K){if(K in t.mChangedEntities){t.mChangeHandles[K].abort();delete t.mChangeHandles[K];delete t.mChangedEntities[K]}else{q.sap.log.warning(t+" - resetChanges: "+K+" is not changed nor a valid change key!")}})}else{q.each(this.mChangedEntities,function(K,o){t.mChangeHandles[K].abort();delete t.mChangeHandles[K];delete t.mChangedEntities[K]})}this.checkUpdate()};g.prototype.setProperty=function(p,v,o){var P,r,R,E={},D={},s=this.resolve(p,o),h,k,G,j,m={};if(!s){q.sap.log.warning(this+" - TwoWay binding: path '"+p+"' not resolvable!");return false}h=s.split("/");P=h[h.length-1];D=this._getObject(s.substr(0,s.lastIndexOf("/")));if(!D){return false}for(var i=h.length-1;i>=0;i--){E=this._getObject(h.join("/"));if(E){k=this._getKey(E);if(k){break}}h.splice(i,1)}if(!this.mChangedEntities[k]){E=q.extend(true,{},E)}this.mChangedEntities[k]=E;E[P]=v;G=this._resolveGroup(k);r=this.mRequests;if(G.batchGroupId in this.mDeferredBatchGroups){r=this.mDeferredRequests;R=this._processChange(k,{__metadata:E.__metadata});R.key=k}else{R=this._processChange(k,E)}if(!this.mChangeHandles[k]){j={abort:function(){R._aborted=true}};this.mChangeHandles[k]=j}this._pushToRequestQueue(r,G.batchGroupId,G.changeSetId,R);if(this.bUseBatch){if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests])}}else{this._processRequestQueue(this.mRequests)}m[k]=true;this.checkUpdate(false,m);return true};g.prototype._isHeaderPrivate=function(h){switch(h.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;default:return false}return false};g.prototype.setHeaders=function(h){var m={},t=this;this.mCustomHeaders={};if(h){q.each(h,function(H,s){if(t._isHeaderPrivate(H)){q.sap.log.warning(this+" - modifying private header: '"+H+"' not allowed!")}else{m[H]=s}});this.mCustomHeaders=m}};g.prototype._getHeaders=function(h){var m={},t=this;if(h){q.each(h,function(H,s){if(t._isHeaderPrivate(H)){q.sap.log.warning(this+" - modifying private header: '"+H+"' not allowed!")}else{m[H]=s}})}return q.extend({},this.mCustomHeaders,m,this.oHeaders)};g.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders)};g.prototype._getHeader=function(h,H){var s;for(s in H){if(s.toLowerCase()===h.toLowerCase()){return H[s]}}return null};g.prototype.hasPendingChanges=function(){return!q.isEmptyObject(this.mChangedEntities)};g.prototype.getPendingChanges=function(){return q.extend(true,{},this.mChangedEntities)};g.prototype.updateBindings=function(F){this.checkUpdate(F)};g.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t};g.prototype.setUseBatch=function(u){this.bUseBatch=u};g.prototype.formatValue=function(v,t){return O.formatValue(v,t)};g.prototype.deleteCreatedEntry=function(o){if(o){var p=o.getPath();delete this.mContexts[p];if(q.sap.startsWith(p,"/")){p=p.substr(1)}this.mChangeHandles[p].abort();delete this.mChangeHandles[p];delete this.mChangedEntities[p];delete this.oData[p]}};g.prototype.createEntry=function(p,P){var s,E,r,u,o,h,k,j,B,l,R,m,H,n,v,t,w={},x="POST";if(P){v=P.properties;B=P.batchGroupId;l=P.changeSetId;o=P.context;s=P.success;E=P.error;h=P.eTag;H=P.headers;m=P.urlParameters}B=B?B:this.sDefaultChangeBatchGroup;j=O._createUrlParamsArray(m);if(!q.sap.startsWith(p,"/")){p="/"+p}var y=this.oMetadata._getEntityTypeByPath(p);if(!y){return undefined}if(typeof v==="object"&&!q.isArray(v)){w=v}else{for(var i=0;i<y.property.length;i++){var z=y.property[i];var T=z.type.split('.');var A=q.inArray(z.name,v)>-1;if(!v||A){w[z.name]=this._createPropertyValue(T);if(A){v.splice(v.indexOf(z.name),1)}}}if(v){}}k=p.substring(1)+"('"+q.sap.uid()+"')";this.oData[k]=w;w.__metadata={type:""+y.entityType,uri:this.sServiceUrl+'/'+k,created:{key:p.substring(1)}};u=this._createRequestUrl(p,o,j,this.bUseBatch);r=this._createRequest(u,x,H,w,undefined,h);o=this.getContext("/"+k);r.context=o;r.key=k;if(!this.mChangedEntities[k]){t=q.extend(true,{},w)}this.mChangedEntities[k]=t;n=this.mRequests;if(B in this.mDeferredBatchGroups){n=this.mDeferredRequests}this._pushToRequestQueue(n,B,l,r,s,E,P);R={abort:function(){r._aborted=true}};this.mChangeHandles[k]=R;if(this.bUseBatch){if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests])}}else{this._processRequestQueue(this.mRequests)}return o};g.prototype._createPropertyValue=function(t){var n=t[0];var T=t[1];if(n.toUpperCase()!=='EDM'){var o={};var h=this.oMetadata._getObjectMetadata("complexType",T,n);for(var i=0;i<h.property.length;i++){var p=h.property[i];t=p.type.split('.');o[p.name]=this._createPropertyValue(t)}return o}else{return this._getDefaultPropertyValue(T,n)}};g.prototype._getDefaultPropertyValue=function(t,n){return undefined};g.prototype._normalizePath=function(p,o){if(p&&p.indexOf('?')!==-1){p=p.substr(0,p.indexOf('?'))}if(!o&&!q.sap.startsWith(p,"/")){q.sap.log.fatal(this+" path "+p+" must be absolute if no Context is set")}return this.resolve(p,o)};g.prototype.setRefreshAfterChange=function(r){this.bRefreshAfterChange=r};g.prototype.isList=function(p,o){p=this.resolve(p,o);return p&&p.substr(p.lastIndexOf("/")).indexOf("(")===-1};g.prototype._request=function(r,s,E,h,H,m){var R;if(this.bDestroyed){return{abort:function(){}}}var t=this;function w(i){return function(){var I=q.inArray(R,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1)}if(!(R&&R.bSuppressErrorHandlerCall)){i.apply(this,arguments)}}}R=OData.request(r,w(s||OData.defaultSuccess),w(E||OData.defaultError),h,H,m);if(r.async!==false){this.aPendingRequestHandles.push(R)}return R};g.prototype.destroy=function(){if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var r=this.aPendingRequestHandles[i];if(r&&r.abort){r.bSuppressErrorHandlerCall=true;r.abort()}}delete this.aPendingRequestHandles}if(this.oMetadataLoadEvent){q.sap.clearDelayedCall(this.oMetadataLoadEvent)}if(this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent)}if(this.oMetadata){this.oMetadata.destroy();delete this.oMetadata}if(this.oAnnotations){this.oAnnotations.destroy();delete this.oAnnotations}M.prototype.destroy.apply(this,arguments)};g.prototype.setDeferredBatchGroups=function(G){var t=this;this.mDeferredBatchGroups={};q.each(G,function(i,B){t.mDeferredBatchGroups[B]=B})};g.prototype.getDeferredBatchGroups=function(){var G=[],i=0;q.each(this.mDeferredBatchGroups,function(k,B){G[i]=B;i++});return G};g.prototype.setChangeBatchGroups=function(G){this.mChangeBatchGroups=G};g.prototype.getChangeBatchGroups=function(){return this.mChangeBatchGroups};g.prototype.callAfterUpdate=function(F){this.aCallAfterUpdate.push(F)};return g},true);
