/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Column','./library'],function(q,C,l){"use strict";var A=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});A.prototype.init=function(){C.prototype.init.apply(this,arguments);this._bSkipUpdateAI=false};A._DEFAULT_FILTERTYPES={"Time":new sap.ui.model.type.Time({UTC:true}),"DateTime":new sap.ui.model.type.DateTime({UTC:true}),"Float":new sap.ui.model.type.Float(),"Integer":new sap.ui.model.type.Integer(),"Boolean":new sap.ui.model.type.Boolean()};A.prototype._createMenu=function(){q.sap.require("sap.ui.table.AnalyticalColumnMenu");return new sap.ui.table.AnalyticalColumnMenu(this.getId()+"-menu")};A.prototype.setGrouped=function(g){var p=this.getParent();var t=this;if(p&&p instanceof sap.ui.table.AnalyticalTable){if(g){p._addGroupedColumn(this.getId())}else{p._aGroupedColumns=q.grep(p._aGroupedColumns,function(v){return v!=t.getId()})}}var r=this.setProperty("grouped",g);this._updateTableColumnDetails();this._updateTableAnalyticalInfo(true);return r};A.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r};A.prototype.setVisible=function(v){C.prototype.setVisible.apply(this,arguments);this._updateTableColumnDetails();this._updateTableAnalyticalInfo();return this};A.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){var b=p.getBinding("rows");if(b){this._oBindingLabel=sap.ui.table.TableHelper.createLabel({text:b.getPropertyLabel(this.getLeadingProperty())})}}}L=this._oBindingLabel}return L};A.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(P&&P instanceof sap.ui.table.AnalyticalTable){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getFilterablePropertyNames())>-1){p=L}}}return p};A.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(P&&P instanceof sap.ui.table.AnalyticalTable){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getSortablePropertyNames())>-1){p=L}}}return p};A.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){var b=p.getBinding("rows");var L=this.getLeadingProperty(),P=b&&b.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=A._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=A._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=A._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=A._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=A._DEFAULT_FILTERTYPES["Boolean"];break}}}}return f};A.prototype._afterSort=function(){this._updateTableAnalyticalInfo()};A.prototype._updateTableAnalyticalInfo=function(s){if(this._bSkipUpdateAI){return}var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){p.updateAnalyticalInfo(s)}};A.prototype._updateTableColumnDetails=function(){if(this._bSkipUpdateAI){return}var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){p._updateTableColumnDetails()}};A.prototype.shouldRender=function(){if(!this.getVisible()){return false}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped)};A.prototype.getTooltip_AsString=function(){var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){var b=p.getBinding("rows");if(b&&this.getLeadingProperty()){return b.getPropertyQuickInfo(this.getLeadingProperty())}}return sap.ui.core.Element.prototype.getTooltip_AsString.apply(this)};return A},true);
