// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.unified.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarLegendRenderer') ) {
/*
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.unified.CalendarLegendRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/CalendarLegendRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Legend renderer.
	 * @namespace
	 */
	var CalendarLegendRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Legend} oLeg an object representation of the legend that should be rendered
	 */
	CalendarLegendRenderer.render = function(oRm, oLeg) {
	
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
		var aClasses = [
			"Today", "Selected", "NormalDay", "NonWorkingDay"
		];
		var aStandardItems = [
			"TODAY", "SELECTED", "NORMAL_DAY", "NON_WORKING_DAY"
		];
		var aCustomItems = oLeg.getItems();
	
		oRm.write("<div");
		oRm.writeControlData(oLeg);
		oRm.addClass("sapUiUnifiedLegend");
		oRm.writeClasses();
		var sColumnWidth = oLeg.getColumnWidth();
		oRm.writeAttribute("style", "column-width:" + sColumnWidth + ";-moz-column-width:" + sColumnWidth + ";-webkit-column-width:" + sColumnWidth + ";");
		oRm.writeStyles();
		oRm.write(">");
	
		// rendering standard days and colors
		for (var i = 0; i < aStandardItems.length; i++) {
			this.renderLegendItem(oRm, "sapUiUnifiedLegend" + aClasses[i], rb.getText("LEGEND_" + aStandardItems[i]));
	
		}
		// rendering special day and colors
		if (aCustomItems && aCustomItems.length > 0) {
			for (var j = 0; j < aCustomItems.length; j++) {
				var type = j + 1;
				this.renderLegendItem(oRm, "sapUiCalLegDayType" + ((type < 10) ? "0" + type : type), aCustomItems[j].getText());
			}
		}
		oRm.write("</div>");
	};
	
	/**
	 * Renders one item of the legend {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {string} sClass name of the CSS class used for this item
	 * @param {string} sText description of the item
	 */
	CalendarLegendRenderer.renderLegendItem = function(oRm, sClass, sText) {
	
		// new LegendItem
		oRm.write("<div");
		oRm.addClass("sapUiUnifiedLegendItem");
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");
		// draw the square background
		oRm.write("<div");
		oRm.addClass("sapUiUnifiedLegendSquare");
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");
		// draw the square color
		oRm.write("<div");
		oRm.addClass("sapUiUnifiedLegendSquareColor");
		oRm.addClass(sClass);
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write("></div></div>"); // close color, background
		// write description
		oRm.write("<div");
		oRm.addClass("sapUiUnifiedLegendDescription");
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");
		oRm.writeEscaped(sText);
		oRm.write("</div></div>"); // close description, LegendItem
	};
	

	return CalendarLegendRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/CalendarLegendRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.unified.CalendarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/CalendarRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * DatePicker renderer.
	 * @namespace
	 */
	var CalendarRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.unified.Calendar} oCal an object representation of the control that should be rendered
	 */
	CalendarRenderer.render = function(oRm, oCal){

		oCal._iMode = 0; // it's rendered always as DayPicker

		var oDate = oCal._getFocusedDate();
		var sId = oCal.getId();
		var sTooltip = oCal.getTooltip_AsString();

		oRm.write("<div");
		oRm.writeControlData(oCal);
		oRm.addClass("sapUiCal");
		oRm.writeClasses();
		// This makes the calendar focusable and therefore
		// the white empty areas can be clicked without closing the calendar
		// by accident.
		oRm.writeAttribute("tabindex", "-1");

		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
		oRm.writeAccessibilityState(oCal, {
			role: "dialog",
			label: rb.getText("DATEPICKER_DIALOG")
		});

		if (sTooltip) {
			oRm.writeAttributeEscaped('title', sTooltip);
		}

		oRm.write(">"); // div element

		this.renderHeader(oRm, oCal, oDate);

		this.renderDayPicker(oRm, oCal, oDate);

		oRm.write("<button id=\"" + sId + "-cancel\" class=\"sapUiCancel\" tabindex=\"-1\">");
		oRm.write(rb.getText("CALENDAR_CANCEL"));
		oRm.write("</button>");

		// dummy element to catch tabbing in from next element
		oRm.write("<div id=\"" + sId + "-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");

		oRm.write("</div>");
	};

	CalendarRenderer.renderHeader = function(oRm, oCal, oDate){

		var oLocaleData = oCal._getLocaleData();
		var sId = oCal.getId();
		var iMonth = oDate.getUTCMonth();
		var iYear = oDate.getUTCFullYear();
		var aMonthNames = [];
		if (oCal._bLongMonth || !oCal._bNamesLengthChecked) {
			aMonthNames = oLocaleData.getMonthsStandAlone("wide");
		} else {
			aMonthNames = oLocaleData.getMonthsStandAlone("abbreviated");
		}

		oRm.write("<div");
		oRm.addClass("sapUiCalHead");
		oRm.writeClasses();
		oRm.write(">"); // div element
		oRm.write("<button id=\"" + sId + "-prev\" class=\"sapUiCalPrev\" tabindex=\"-1\">");
		oRm.writeIcon("sap-icon://slim-arrow-left");
		oRm.write("</button>");

		oRm.write("<button");
		oRm.writeAttributeEscaped('id', sId + '-month');
		oRm.addClass("sapUiCalMonthPick");
		oRm.writeAttribute('tabindex', "-1");
		oRm.writeClasses();
		oRm.write(">"); // button element
		oRm.write(aMonthNames[iMonth]);
		oRm.write("</button>");

		oRm.write("<button");
		oRm.writeAttributeEscaped('id', sId + '-year');
		oRm.addClass("sapUiCalYearPick");
		oRm.writeAttribute('tabindex', "-1");
		oRm.writeClasses();
		oRm.write(">"); // button element
		oRm.write(iYear);
		oRm.write("</button>");

		oRm.write("<button id=\"" + sId + "-next\" class=\"sapUiCalNext\" tabindex=\"-1\">");
		oRm.writeIcon("sap-icon://slim-arrow-right");
		oRm.write("</button>");
		oRm.write("</div>");

	};

	CalendarRenderer.renderDayPicker = function(oRm, oCal, oDate){

		var oLocaleData = oCal._getLocaleData();
		var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();
		var sId = oCal.getId();

		// week numbers
		var aWeekDays = [];
		if (oCal._bLongWeekDays || !oCal._bNamesLengthChecked) {
			aWeekDays = oLocaleData.getDaysStandAlone("abbreviated");
		} else {
			aWeekDays = oLocaleData.getDaysStandAlone("narrow");
		}
		for ( var i = 0; i < 7; i++) {
			oRm.write("<div");
			oRm.addClass("sapUiCalWH");
			if (i == 0) {
				oRm.addClass("sapUiCalFirstWDay");
			}
			oRm.writeClasses();
			oRm.write(">"); // div element
			oRm.write(aWeekDays[(i + iFirstDayOfWeek) % 7]);
			oRm.write("</div>");
		}

		// days
		oRm.write("<div id=\"" + sId + "-days\" class=\"sapUiCalDays\">"); // extra DIV around the days to allow rerendering only it's content
		this.renderDays(oRm, oCal, oDate);
		oRm.write("</div>");

	};

	CalendarRenderer.renderDays = function(oRm, oCal, oDate){

		if (!oDate) {
			oDate = oCal._getFocusedDate();
		}

		var sLocale = oCal.getLocale();
		var oLocaleData = oCal._getLocaleData();
		var iMonth = oDate.getUTCMonth();
		var iYear = oDate.getUTCFullYear();
		var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();
		var iWeekendStart = oLocaleData.getWeekendStart();
		var iWeekendEnd = oLocaleData.getWeekendEnd();
		var oToday = new Date();
		var sId = oCal.getId();

		// determine weekday of first day in month
		var oFirstDay = new Date(oDate.getTime());
		oFirstDay.setUTCDate(1);
		var iWeekDay = oFirstDay.getUTCDay();
		var iDaysOldMonth = iWeekDay - iFirstDayOfWeek;
		if (iDaysOldMonth < 0) {
			iDaysOldMonth = 7 + iDaysOldMonth;
		}

		if (iDaysOldMonth > 0) {
			// determine first day for display
			oFirstDay.setUTCDate(1 - iDaysOldMonth);
		}

		var oDay = new Date(oFirstDay.getTime());
		var sYyyymmdd = "";
		var iNextMonth = (iMonth + 1) % 12;
		var iSelected = 0;
		var oType;

		do {

			sYyyymmdd = oCal._oFormatYyyymmdd.format(oDay, true);
			iWeekDay = oDay.getUTCDay();
			iSelected = oCal._checkDateSelected(oDay);
			oType = oCal._getDateType(oDay);
			oRm.write("<div");
			oRm.writeAttribute("id", sId + "-" + sYyyymmdd);
			oRm.addClass("sapUiCalDay");
			oRm.addClass("sapUiCalWDay" + iWeekDay);
			if (iWeekDay == iFirstDayOfWeek) {
				oRm.addClass("sapUiCalFirstWDay");
			}
			if (iMonth != oDay.getUTCMonth()) {
				oRm.addClass("sapUiCalDayOtherMonth");
			}
			if (oDay.getUTCMonth() == oToday.getMonth() && oDay.getUTCFullYear() == oToday.getFullYear() && oDay.getUTCDate() == oToday.getDate()) {
				oRm.addClass("sapUiCalDayToday");
			}

			if (iSelected > 0) {
				oRm.addClass("sapUiCalDaySel"); // day selected
			}
			if (iSelected == 2) {
				oRm.addClass("sapUiCalDaySelStart"); // interval start
			} else if (iSelected == 3) {
				oRm.addClass("sapUiCalDaySelEnd"); // interval end
			} else if (iSelected == 4) {
				oRm.addClass("sapUiCalDaySelBetween"); // interval between
			} else if (iSelected == 5) {
				oRm.addClass("sapUiCalDaySelStart"); // interval start
				oRm.addClass("sapUiCalDaySelEnd"); // interval end
			}

			if (oType) {
				oRm.addClass("sapUiCalDay" + oType.type);
				if (oType.tooltip) {
					oRm.writeAttributeEscaped('title', oType.tooltip);
				}
			}

			if ((iWeekDay >= iWeekendStart && iWeekDay <= iWeekendEnd) ||
					( iWeekendEnd < iWeekendStart && ( iWeekDay >= iWeekendStart || iWeekDay <= iWeekendEnd))) {
				oRm.addClass("sapUiCalDayWeekEnd");
			}
			oRm.writeAttribute("tabindex", "-1");
			oRm.writeAttribute("data-sap-day", sYyyymmdd);
			oRm.writeClasses();
			oRm.write(">"); // div element

			oRm.write("<span class=\"sapUiCalDayNum\">");
			oRm.write(oDay.getUTCDate());
			oRm.write("</span>");

			if (iWeekDay == iFirstDayOfWeek) {
				// add week number - inside first day of the week to allow better position and make it easier for ItemNavigation
				oRm.write("<span class=\"sapUiCalWeekNum\">");
				oRm.write(this.calculateWeekNumber(oDay, iYear, sLocale, oLocaleData));
				oRm.write("</span>");
			}

			oRm.write("</div>");

			oDay.setUTCDate(oDay.getUTCDate() + 1);

		} while (oDay.getUTCMonth() != iNextMonth || oDay.getUTCDay() != iFirstDayOfWeek);

	};

	CalendarRenderer.calculateWeekNumber = function(oDate, iYear, sLocale, oLocaleData){

		var iWeekNum = 0;
		var iWeekDay = 0;
		var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();

		switch (sLocale) {
		case "en-US":
			/*
			 * in US the week starts with Sunday
			 * The first week of the year starts with January 1st. But Dec. 31 is still in the last year
			 * So the week beginning in December and ending in January has 2 week numbers
			 */
			var oJanFirst = new Date(oDate.getTime());
			oJanFirst.setUTCFullYear(iYear, 0, 1);
			iWeekDay = oJanFirst.getUTCDay();

			//get the date for the same weekday like jan 1.
			var oCheckDate = new Date(oDate.getTime());
			oCheckDate.setUTCDate(oCheckDate.getUTCDate() - oCheckDate.getUTCDay() + iWeekDay);

			iWeekNum = Math.round((oCheckDate.getTime() - oJanFirst.getTime()) / 86400000 / 7) + 1;

			break;

		default:
			// normally the first week of the year is the one where the first Thursday of the year is
			// find Thursday of this week
			// if the checked day is before the 1. day of the week use a day of the previous week to check
			var oThursday = new Date(oDate.getTime());
		oThursday.setUTCDate(oThursday.getUTCDate() - iFirstDayOfWeek);
		iWeekDay = oThursday.getUTCDay();
		oThursday.setUTCDate(oThursday.getUTCDate() - iWeekDay + 4);

		var oFirstDayOfYear = new Date(oThursday.getTime());
		oFirstDayOfYear.setUTCMonth(0, 1);
		iWeekDay = oFirstDayOfYear.getUTCDay();
		var iAddDays = 0;
		if (iWeekDay > 4) {
			iAddDays = 7; // first day of year is after Thursday, so first Thursday is in the next week
		}
		var oFirstThursday = new Date(oFirstDayOfYear.getTime());
		oFirstThursday.setUTCDate(1 - iWeekDay + 4 + iAddDays);

		iWeekNum = Math.round((oThursday.getTime() - oFirstThursday.getTime()) / 86400000 / 7) + 1;

		break;
		}

		return iWeekNum;

	};

	CalendarRenderer.renderMonthPicker = function(oRm, oCal, oDate){

		var oLocaleData = oCal._getLocaleData();
		var sId = oCal.getId();
		var aMonthNames = [];
		if (oCal._bLongMonth || !oCal._bNamesLengthChecked) {
			aMonthNames = oLocaleData.getMonthsStandAlone("wide");
		} else {
			aMonthNames = oLocaleData.getMonthsStandAlone("abbreviated");
		}
		var iMonth = oDate.getUTCMonth();

		oRm.write("<div id=\"" + sId + "-months\" class=\"sapUiCalMonths\">");

		for ( var i = 0; i < 12; i++) {
			oRm.write("<div");
			oRm.writeAttribute("id", sId + "-m" + i);
			oRm.addClass("sapUiCalMonth");
			if (i == iMonth) {
				oRm.addClass("sapUiCalMonthSel");
			}
			oRm.writeAttribute("tabindex", "-1");
			oRm.writeClasses();
			oRm.write(">"); // div element
			oRm.write(aMonthNames[i]);
			oRm.write("</div>");
		}

		oRm.write("</div>");

	};

	CalendarRenderer.renderYearPicker = function(oRm, oCal, oDate){

		var sId = oCal.getId();
		var iCurrentYear = oDate.getUTCFullYear();
		var iYear = 0;

		oRm.write("<div id=\"" + sId + "-years\" class=\"sapUiCalYears\">");

		for ( var i = 0; i < 20; i++) {
			iYear = iCurrentYear - 10 + i;
			oRm.write("<div");
			oRm.writeAttribute("id", sId + "-y" + iYear);
			oRm.addClass("sapUiCalYear");
			if (i == 10) {
				oRm.addClass("sapUiCalYearSel");
			}
			oRm.writeAttribute("tabindex", "-1");
			oRm.writeClasses();
			oRm.write(">"); // div element
			oRm.write(iYear);
			oRm.write("</div>");
		}

		oRm.write("</div>");

	};

	return CalendarRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/CalendarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ContentSwitcherRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.unified.ContentSwitcherRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ContentSwitcherRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * AnimatedContentSwitcher renderer. 
	 * @namespace
	 */
	var ContentSwitcherRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ContentSwitcherRenderer.render = function(oRm, oControl){
		var sId            = oControl.getId();
		var sAnimation     = oControl.getAnimation();
		if (!sap.ui.getCore().getConfiguration().getAnimation()) {
			sAnimation = sap.ui.unified.ContentSwitcherAnimation.None;
		}
		
		var iActiveContent = oControl.getActiveContent();
	
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapUiUfdCSwitcher");
		oRm.addClass("sapUiUfdCSwitcherAnimation" + sAnimation);
		oRm.writeClasses();
		oRm.write(">");
		
		oRm.write("<section id=\"" + sId + "-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1" + (iActiveContent == 1 ? " sapUiUfdCSwitcherVisible" : "") + "\">");
		this.renderContent(oRm, oControl.getContent1());
		oRm.write("</section>");
		
		oRm.write("<section id=\"" + sId + "-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2" + (iActiveContent == 2 ? " sapUiUfdCSwitcherVisible" : "") + "\">");
		this.renderContent(oRm, oControl.getContent2());
		oRm.write("</section>");
		
		oRm.write("</div>");
	};
	
	ContentSwitcherRenderer.renderContent = function(oRm, aContent) {
		for (var i = 0; i < aContent.length; ++i) {
			oRm.renderControl(aContent[i]);
		}
	};

	return ContentSwitcherRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ContentSwitcherRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CurrencyRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.Menu
jQuery.sap.declare('sap.ui.unified.CurrencyRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/CurrencyRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	
	/**
	 * Currency renderer.
	 *
	 * @version 1.26.7
	 * @namespace
	 */
	var CurrencyRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
	 * @param {sap.ui.core.Control}
	 *            oMenu An object representation of the control that should be rendered
	 */
	CurrencyRenderer.render = function(oRm,oCurrency) {
		oRm.write("<div");
		oRm.writeControlData(oCurrency);
		oRm.addClass("sapUiUfdCurrency");
		if (!oCurrency._hasValue()) {
			oRm.addClass("sapUiUfdCurrencyNoVal");
		}
		oRm.writeClasses();
		oRm.write(">");
		oRm.write("<div");
		oRm.addClass("sapUiUfdCurrencyAlign");
		oRm.writeClasses();
		oRm.write(">");
		oRm.write("<span");
		oRm.addClass("sapUiUfdCurrencyValue");
		oRm.writeClasses();
		oRm.write(">");
		oRm.writeEscaped(oCurrency.getFormattedValue());
		oRm.write("</span>");
		oRm.write("<span");
		oRm.addClass("sapUiUfdCurrencyCurrency");
		oRm.writeClasses();
		oRm.write(">");
		if (oCurrency.getUseSymbol()) {
			oRm.writeEscaped(oCurrency.getCurrencySymbol());
		} else {
			oRm.writeEscaped(oCurrency.getCurrency());
		}
		oRm.write("</span>");
		oRm.write("</div>");
		oRm.write("</div>");
	};

	return CurrencyRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/CurrencyRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.FileUploaderRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.FileUploader
jQuery.sap.declare('sap.ui.unified.FileUploaderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/FileUploaderRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @namespace
	 */
	var FileUploaderRenderer = function() {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	FileUploaderRenderer.render = function(oRenderManager, oFileUploader) {
	
		var rm = oRenderManager;
		var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();

		rm.write('<div');
		rm.writeControlData(oFileUploader);
		rm.addClass("sapUiFup");
		rm.writeClasses();
		rm.write('>');
	
		// form
		rm.write('<form style="display:inline-block" encType="multipart/form-data" method="post"');
		rm.writeAttribute('id', oFileUploader.getId() + '-fu_form');
		rm.writeAttributeEscaped('action', oFileUploader.getUploadUrl());
		rm.writeAttribute('target', oFileUploader.getId() + '-frame');
		rm.write('>');
	
		// the SAPUI5 TextField and Button
		rm.write('<div class="sapUiFupInp"');
		if (accessibility) {
			rm.writeAttribute("role", "textbox");
			rm.writeAttribute("aria-readonly", "true");
		}
		rm.write('>');
	
		if (!oFileUploader.getButtonOnly()) {
			rm.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div>');
		} else {
			rm.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div style="display:none">');
		}
		rm.renderControl(oFileUploader.oFilePath);
		rm.write('</div><div>');  //-> per style margin
		rm.renderControl(oFileUploader.oBrowse);
		rm.write('</div></div></div>');
	
		// hidden pure input type file (surrounded by a div which is responsible for giving the input the correct size)
		var sName = oFileUploader.getName() || oFileUploader.getId();
		rm.write('<div class="sapUiFupInputMask">');
		rm.write('<input type="hidden" name="_charset_">');
		rm.write('<input type="hidden" id="' + oFileUploader.getId() + '-fu_data"');
		rm.writeAttributeEscaped('name', sName + '-data');
		rm.writeAttributeEscaped('value', oFileUploader.getAdditionalData() || "");
		rm.write('>');
		jQuery.each(oFileUploader.getParameters(), function(iIndex, oParam) {
			rm.write('<input type="hidden" ');
			rm.writeAttributeEscaped('name', oParam.getName() || "");
			rm.writeAttributeEscaped('value', oParam.getValue() || "");
			rm.write('>');
		});
		rm.write('</div>');
	
	
		rm.write('</div>');
		rm.write('</form>');
		rm.write('</div>');
	};

	return FileUploaderRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/FileUploaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.Menu
jQuery.sap.declare('sap.ui.unified.MenuRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/MenuRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	
	/**
	 * Menu renderer.
	 * @author SAP - TD Core UI&AM UI Infra
	 *
	 * @version 1.26.7
	 * @namespace
	 */
	var MenuRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
	 * @param {sap.ui.core.Control}
	 *            oMenu An object representation of the control that should be rendered
	 */
	MenuRenderer.render = function(rm, oMenu) {
		if (oMenu.oHoveredItem && oMenu.indexOfItem(oMenu.oHoveredItem) < 0) {
			//Hover item not valid anymore
			oMenu.oHoveredItem = null;
		}
		
		rm.write("<div tabindex=\"-1\" hideFocus=\"true\"");
	
		if (oMenu.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oMenu.getTooltip_AsString());
		}
	
		// ARIA
		var bAccessible = sap.ui.getCore().getConfiguration().getAccessibility();
		if (bAccessible) {
			rm.writeAttribute("role", "menu");
			rm.writeAttribute("aria-level", oMenu.getMenuLevel());
			if (oMenu.oHoveredItem) {
				rm.writeAttribute("aria-activedescendant", oMenu.oHoveredItem.getId());
			}
		}
	
		rm.addClass("sapUiMnu");
		if (oMenu.getRootMenu().bUseTopStyle) {
			rm.addClass("sapUiMnuTop");
		}
		rm.writeClasses();
		rm.writeControlData(oMenu);
		rm.write(">");
		MenuRenderer.renderItems(rm, oMenu);
		if (bAccessible) {
			var _getText = function(sKey, aArgs) {
				var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
				if (rb) {
					return rb.getText(sKey, aArgs);
				}
				return sKey;
			};
			
			rm.write("<span id='", oMenu.getId(), "-label' class='sapUiInvisibleText' aria-hidden='true'>");
			rm.writeEscaped(oMenu.getAriaDescription() ? oMenu.getAriaDescription() : _getText("MNU_ARIA_NAME"));
			rm.write("</span>");
		}
		rm.write("</div>");
	};
	
	MenuRenderer.renderItems = function(rm, oMenu) {
		var aItems = oMenu.getItems();
		var bAccessible = sap.ui.getCore().getConfiguration().getAccessibility();
		
		rm.write("<ul class=\"sapUiMnuLst");
	
		var bHasIcons = false;
		var bHasSubMenus = false;
		for (var idx = 0; idx < aItems.length; idx++) {
			if (aItems[idx].getIcon && aItems[idx].getIcon()) {
				bHasIcons = true;
			}
			if (aItems[idx].getSubmenu()) {
				bHasSubMenus = true;
			}
		}
	
		if (!bHasIcons) {
			rm.write(" sapUiMnuNoIco");
		}
		if (!bHasSubMenus) {
			rm.write(" sapUiMnuNoSbMnu");
		}
	
		rm.write("\">");
	
		var iNumberOfVisibleItems = 0;
		for (var i = 0;i < aItems.length;i++) {
			if (aItems[i].getVisible() && aItems[i].render) {
				iNumberOfVisibleItems++;
			}
		}
	
		var index = 0;
		// Menu items
		for (var i = 0;i < aItems.length;i++) {
			var oItem = aItems[i];
			if (oItem.getVisible() && oItem.render) {
				index++;
	
				if (oItem.getStartsSection()) {
					rm.write("<li ");
					if (bAccessible) {
						rm.write("role=\"separator\" ");
					}
					rm.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");
				}
	
				oItem.render(rm, oItem, oMenu, {bAccessible: bAccessible, iItemNo: index, iTotalItems: iNumberOfVisibleItems});
			}
		}
	
		rm.write("</ul>");
	};

	return MenuRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/MenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellLayoutRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.ShellLayout
jQuery.sap.declare('sap.ui.unified.ShellLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellLayoutRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Shell Layout renderer.
	 * @namespace
	 */
	var ShellLayoutRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
	 */
	ShellLayoutRenderer.render = function(rm, oShell){
		var id = oShell.getId();
	
		rm.write("<div");
		rm.writeControlData(oShell);
		rm.addClass("sapUiUfdShell");
		if (oShell._animation) {
			rm.addClass("sapUiUfdShellAnim");
		}
		if (!oShell.getHeaderVisible()) {
			rm.addClass("sapUiUfdShellNoHead");
		}
		rm.addClass("sapUiUfdShellHead" + (oShell._showHeader ? "Visible" : "Hidden"));
		if (oShell.getShowCurtain()) {
			rm.addClass("sapUiUfdShellCurtainVisible");
		} else {
			rm.addClass("sapUiUfdShellCurtainHidden");
			rm.addClass("sapUiUfdShellCurtainClosed");
		}
		
		rm.writeClasses();
		rm.write(">");
		
		rm.write("<hr id='", id, "-brand' class='sapUiUfdShellBrand'/>");
		
		rm.write("<header id='", id, "-hdr'  class='sapUiUfdShellHead'><div>");
		rm.write("<div id='", id, "-hdrcntnt' class='sapUiUfdShellCntnt'>");
		if (oShell.getHeader()) {
			rm.renderControl(oShell.getHeader());
		}
		rm.write("</div>", "</div>", "</header>");
	
		rm.write("<section id='", id, "-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");
		rm.write("<div id='", id, "-curtcntnt' class='sapUiUfdShellCntnt'>");
		rm.renderControl(oShell._curtCont);
		rm.write("</div>");
		rm.write("<span id='", id, "-curt-focusDummyOut' tabindex='0'></span>");
		rm.write("</section>");
		
		rm.write("<div id='", id, "-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiUfdShellBackground'>");
		rm.write("<div id='", id, "-strgbg' class='sapUiUfdShellBG" + (oShell._useStrongBG ? " sapMGlobalBackgroundColorStrong" : "") + "'></div>");
		rm.write("<div class='sapMGlobalBackgroundImage sapUiUfdShellBG'></div>");
		rm.renderControl(oShell._cont);
		rm.write("</div>");
		
		rm.write("<span id='", id, "-main-focusDummyOut' tabindex='" + (oShell.getShowCurtain() ? 0 : -1) + "'></span>");
		
		rm.write("</div>");
	};

	return ShellLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellOverlayRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.ShellOverlay
jQuery.sap.declare('sap.ui.unified.ShellOverlayRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellOverlayRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ShellOverlay renderer.
	 * @namespace
	 */
	var ShellOverlayRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
	 */
	ShellOverlayRenderer.render = function(rm, oControl){
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUfdShellOvrly");
		if (oControl._opening) {
			rm.addClass("sapUiUfdShellOvrlyCntntHidden");
			rm.addClass("sapUiUfdShellOvrlyOpening");
		}
		
		if (oControl._getAnimActive()) {
			rm.addClass("sapUiUfdShellOvrlyAnim");
		}
		rm.writeClasses();
		rm.write("><span id='", oControl.getId(), "-focfirst' tabIndex='0'></span><div id='", oControl.getId(), "-inner'>");
		
		rm.write("<header class='sapUiUfdShellOvrlyHead'>");
		rm.write("<hr class='sapUiUfdShellOvrlyBrand'/>");
		rm.write("<div class='sapUiUfdShellOvrlyHeadCntnt'>");
		rm.write("<div id='" + oControl.getId() + "-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");
		ShellOverlayRenderer.renderSearch(rm, oControl);
		rm.write("</div>");
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),
			sCloseTxt = rb.getText("SHELL_OVERLAY_CLOSE");
		rm.write("<a tabindex='0' href='javascript:void(0);' id='" + oControl.getId() + "-close' class='sapUiUfdShellOvrlyHeadClose'");
		rm.writeAttributeEscaped("title", sCloseTxt);
		rm.write(">");
		rm.writeEscaped(sCloseTxt);
		rm.write("</a></div></header>");
		rm.write("<div id='" + oControl.getId() + "-cntnt' class='sapUiUfdShellOvrlyCntnt'>");
		ShellOverlayRenderer.renderContent(rm, oControl);
		rm.write("</div>");
		
		rm.write("</div><span id='", oControl.getId(), "-foclast' tabIndex='0'></span></div>");
	};
	
	ShellOverlayRenderer.renderSearch = function(rm, oControl) {
		var iWidth = oControl._getSearchWidth();
		var sStyle = "";
		if (iWidth > 0 && oControl._opening) {
			sStyle = "style='width:" + iWidth + "px'";
		}
		
		rm.write("<div id='" + oControl.getId() + "-search' class='sapUiUfdShellOvrlySearch' " + sStyle + "><div>");
		var oSearch = oControl.getSearch();
		if (oSearch) {
			rm.renderControl(oSearch);
		}
		rm.write("</div></div>");
	};
	
	ShellOverlayRenderer.renderContent = function(rm, oControl) {
		rm.write("<div tabindex='-1'>");
		var aContent = oControl.getContent();
		for (var i = 0; i < aContent.length; i++) {
			rm.renderControl(aContent[i]);
		}
		rm.write("</div>");
	};

	return ShellOverlayRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellOverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.Shell
jQuery.sap.declare('sap.ui.unified.ShellRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './ShellLayoutRenderer'],
	function(jQuery, Renderer, ShellLayoutRenderer) {
	"use strict";


	/**
	 * Renderer for the sap.ui.unified.Shell
	 * @namespace
	 */
	var ShellRenderer = Renderer.extend(ShellLayoutRenderer);
	

	return ShellRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.SplitContainerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.unified.SplitContainer
jQuery.sap.declare('sap.ui.unified.SplitContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/SplitContainerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * SplitContainer renderer.
	 * @namespace
	 */
	var SplitContainerRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
	 */
	SplitContainerRenderer.render = function(rm, oControl){
		var sId = oControl.getId();
	
		var bVertical = oControl.getOrientation() == sap.ui.core.Orientation.Vertical;
		
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUfdSpltCont");
		rm.addClass("sapUiUfdSpltCont" + (bVertical ? "V" : "H"));
		if (sap.ui.getCore().getConfiguration().getAnimation()) {
			rm.addClass("sapUiUfdSpltContAnim");
		}
	
		if (!oControl.getShowSecondaryContent()) {
			rm.addClass("sapUiUfdSpltContPaneHidden");
		}
		rm.writeClasses();
		rm.write(">");
		
		var sCanvasId = sId + "-canvas";
	
		rm.write("<section id='", sCanvasId, "' class='sapUiUfdSpltContCanvas'>");
		this.renderContent(rm, sCanvasId, oControl.getContent(), oControl._bRootContent);
		rm.write("</section>");
		
		var sSidePaneId = sId + "-pane";
	
		var sWidth = oControl.getShowSecondaryContent() ? oControl.getSecondaryContentSize() : "0";
		rm.write("<aside id='", sSidePaneId, "' style='width:", sWidth, "'");
		rm.addClass("sapUiUfdSpltContPane");
		if (!oControl.getShowSecondaryContent()) {
			rm.addClass("sapUiUfdSplitContSecondClosed");
		}
		rm.writeClasses();
		rm.write(">");
		this.renderContent(rm, sSidePaneId, oControl.getSecondaryContent(), oControl._bRootContent);
		rm.write("</aside>");
	
		rm.write("</div>");
	};
	
	SplitContainerRenderer.renderContent = function (rm, sId, aContent, bRootContent) {
		rm.write("<div id='", sId, "cntnt' class='sapUiUfdSpltContCntnt'");
		if (bRootContent) {
			rm.writeAttribute("data-sap-ui-root-content", "true"); // see e.g. sap.m.App#onAfterRendering
		}
		rm.write(">");
		for (var i = 0; i < aContent.length; i++) {
			rm.renderControl(aContent[i]);
		}
		rm.write("</div>");
	};
	

	return SplitContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/SplitContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.unified.
 */
jQuery.sap.declare('sap.ui.unified.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/library",['jquery.sap.global', 
	'sap/ui/core/library'], // library dependency
	function(jQuery) {

	"use strict";

	/**
	 * Unified controls intended for both, mobile and desktop scenarios
	 *
	 * @namespace
	 * @name sap.ui.unified
	 * @author SAP SE
	 * @version 1.26.7
	 * @public
	 */
	
	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.unified",
		version: "1.26.7",
		dependencies : ["sap.ui.core"],
		types: [
			"sap.ui.unified.CalendarDayType",
			"sap.ui.unified.ContentSwitcherAnimation"
		],
		interfaces: [],
		controls: [
			"sap.ui.unified.Calendar",
			"sap.ui.unified.CalendarLegend",
			"sap.ui.unified.ContentSwitcher",
			"sap.ui.unified.Currency",
			"sap.ui.unified.FileUploader",
			"sap.ui.unified.Menu",
			"sap.ui.unified.Shell",
			"sap.ui.unified.ShellLayout",
			"sap.ui.unified.ShellOverlay",
			"sap.ui.unified.SplitContainer"
		],
		elements: [
			"sap.ui.unified.CalendarLegendItem",
			"sap.ui.unified.DateRange",
			"sap.ui.unified.DateTypeRange",
			"sap.ui.unified.FileUploaderParameter",
			"sap.ui.unified.MenuItem",
			"sap.ui.unified.MenuItemBase",
			"sap.ui.unified.MenuTextFieldItem",
			"sap.ui.unified.ShellHeadItem",
			"sap.ui.unified.ShellHeadUserItem"
		]
	});
	
	
	/**
	 * Type of a calendar day used for visualization.
	 *
	 * @enum {string}
	 * @public
	 * @since 1.24.0
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.unified.CalendarDayType = {
	
		/**
		 * Type 01: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type01 : "Type01",
	
		/**
		 * Type 02: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type02 : "Type02",
	
		/**
		 * Type 03: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type03 : "Type03",
	
		/**
		 * Type 04: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type04 : "Type04",
	
		/**
		 * Type 05: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type05 : "Type05",
	
		/**
		 * Type 06: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type06 : "Type06",
	
		/**
		 * Type 07: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type07 : "Type07",
	
		/**
		 * Type 08: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type08 : "Type08",
	
		/**
		 * Type 09: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type09 : "Type09",
	
		/**
		 * Type 10: The semantic meaning must be defined by the application. It can be shown in a legend.
		 * @public
		 */
		Type10 : "Type10"
	
	};
	
	
	/**
	 * Predefined animations for the ContentSwitcher
	 *
	 * @enum {string}
	 * @public
	 * @since 1.16.0
	 * @experimental Since version 1.16.0. 
	 * API is not yet finished and might change completely
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.unified.ContentSwitcherAnimation = {
	
		/**
		 * No animation. Content is switched instantly.
		 * @public
		 */
		None : "None",
	
		/**
		 * Content is faded (opacity change).
		 * @public
		 */
		Fade : "Fade",
	
		/**
		 * The new content is "zoomed in" from the center and grows to fill the full content area.
		 * @public
		 */
		ZoomIn : "ZoomIn",
	
		/**
		 * The old content is "zoomed out", i.e. shrinks to a point at the center of the content area.
		 * @public
		 */
		ZoomOut : "ZoomOut",
	
		/**
		 * The new content rotates in. (Just like one of those old newspaper-animations.)
		 * @public
		 */
		Rotate : "Rotate",
	
		/**
		 * The new slides in from the left (to the right).
		 * @public
		 */
		SlideRight : "SlideRight",
	
		/**
		 * The new content slides in from the left while the old content slides out to the left at the same time.
		 * @public
		 */
		SlideOver : "SlideOver"
	
	};
	
	sap.ui.base.Object.extend("sap.ui.unified._ContentRenderer", {
		constructor : function(oControl, sContentContainerId, oContent, fAfterRenderCallback) {
			sap.ui.base.Object.apply(this);
			this._id = sContentContainerId;
			this._cntnt = oContent;
			this._ctrl = oControl;
			this._rm = sap.ui.getCore().createRenderManager();
			this._cb = fAfterRenderCallback || function(){};
		},
		
		destroy : function() {
			this._rm.destroy();
			delete this._rm;
			delete this._id;
			delete this._cntnt;
			delete this._cb;
			delete this._ctrl;
			if (this._rerenderTimer) {
				jQuery.sap.clearDelayedCall(this._rerenderTimer);
				delete this._rerenderTimer;
			}
			sap.ui.base.Object.prototype.destroy.apply(this, arguments);
		},
		
		render : function() {
			if (!this._rm) {
				return;
			}
			
			if (this._rerenderTimer) {
				jQuery.sap.clearDelayedCall(this._rerenderTimer);
			}
			
			this._rerenderTimer = jQuery.sap.delayedCall(0, this, function(){
				var $content = jQuery.sap.byId(this._id);
				var doRender = $content.length > 0;
				
				if (doRender) {
					if (typeof (this._cntnt) === "string") {
						var aContent = this._ctrl.getAggregation(this._cntnt, []);
						for (var i = 0; i < aContent.length; i++) {
							this._rm.renderControl(aContent[i]);
						}
					} else {
						this._cntnt(this._rm);
					}
					this._rm.flush($content[0]);
				}
	
				this._cb(doRender);
			});
		}
	});
	
	
	sap.ui.unified._iNumberOfOpenedShellOverlays = 0;
	
	//factory for the FileUploader to create TextField an Button to be overwritten by commons and mobile library
	if (!sap.ui.unified.FileUploaderHelper) {
		sap.ui.unified.FileUploaderHelper = {
			createTextField: function(sId){ throw new Error("no TextField control available!"); }, /* must return a TextField control */
			setTextFieldContent: function(oTextField, sWidth){ throw new Error("no TextField control available!"); },
			createButton: function(){ throw new Error("no Button control available!"); }, /* must return a Button control */
			bFinal: false /* if true, the helper must not be overwritten by an other library */
		};
	}

	return sap.ui.unified;

}, /* bExport= */ false);

}; // end of sap/ui/unified/library.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Calendar') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.Calendar.
jQuery.sap.declare('sap.ui.unified.Calendar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.LocaleData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.type.Date'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/Calendar",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/LocaleData', 'sap/ui/core/delegate/ItemNavigation', 'sap/ui/model/type/Date', './library'],
	function(jQuery, Control, LocaleData, ItemNavigation, Date1, library) {
	"use strict";

	/**
	 * Constructor for a new Calendar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Basic Calendar.
	 * This calendar ist used for DatePickers
	 * @extends sap.ui.core.Control
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.22.0
	 * @alias sap.ui.unified.Calendar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Calendar = Control.extend("sap.ui.unified.Calendar", /** @lends sap.ui.unified.Calendar.prototype */ { metadata : {

		library : "sap.ui.unified",
		properties : {

			/**
			 * If set, interval selection is allowed
			 */
			intervalSelection : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * If set, only a single date or interval, if intervalSelection is enabled, can be selected
			 */
			singleSelection : {type : "boolean", group : "Misc", defaultValue : true}
		},
		aggregations : {

			/**
			 * Date Ranges for selected dates of the DatePicker
			 */
			selectedDates : {type : "sap.ui.unified.DateRange", multiple : true, singularName : "selectedDate"}, 

			/**
			 * Date Range with type to visualize special days in the Calendar.
			 * If one day is assigned to more than one Type, only the first one will be used.
			 * @since 1.24.0
			 */
			specialDates : {type : "sap.ui.unified.DateTypeRange", multiple : true, singularName : "specialDate"}
		},
		events : {

			/**
			 * Date selection changed
			 */
			select : {}, 

			/**
			 * Date selection was cancelled
			 */
			cancel : {}
		}
	}});

	/*
	 * There are different modes (stored in this._iMode)
	 * The standard is 0, that means a calendar showing a calendar with the days of one month.
	 * If 1 a month picker is shown.
	 * if 2 a year picker is shown.
	 */

	(function() {

		Calendar.prototype.init = function(){

			this._mouseMoveProxy = jQuery.proxy(this._handleMouseMove, this);

			this._iMode = 0; // days are shown

			this._oFormatYyyymmdd = sap.ui.core.format.DateFormat.getInstance({pattern: "yyyyMMdd"});

			this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling

			this._oMinDate = new Date(Date.UTC(1, 0, 1));
			this._oMinDate.setUTCFullYear(1); // otherwise year 1 will be converted to year 1901
			this._oMaxDate = new Date(Date.UTC(9999, 11, 31));

		};

		Calendar.prototype.exit = function(){

			if (this._sRenderMonth) {
				jQuery.sap.clearDelayedCall(this._sRenderMonth);
			}

		};

		//	sap.ui.unified.Calendar.prototype.onBeforeRendering = function(){
		//	};

		Calendar.prototype.onAfterRendering = function(){

			var that = this;

			_initItemNavigation(that);

			// check if day names and month names are too big -> use smaller ones
			_checkNamesLength(that);

			_togglePrevNext(that, this._getFocusedDate(), true);

		};

		// overwrite invalidate to recognize changes on selectedDates
		Calendar.prototype.invalidate = function(oOrigin) {

			if (!oOrigin || !(oOrigin instanceof sap.ui.unified.DateRange)) {
				Control.prototype.invalidate.apply(this, arguments);
			} else if (this.getDomRef() && this._iMode == 0 && !this._sRenderMonth) {
				// DateRange changed -> only rerender days
				// do this only once if more DateRanges / Special days are changed
				var that = this;
				this._sRenderMonth = jQuery.sap.delayedCall(0, this, _renderMonth, [that]);
			}

		};

		/**
		 * sets the locale for the DatePicker
		 * only for internal use
		 * @param {string} sLocale  new value for <code>locale</code>
		 * @returns {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
		 * @private
		 */
		Calendar.prototype.setLocale = function(sLocale){

			if (this._sLocale != sLocale) {
				this._sLocale = sLocale;
				this._oLocaleData = undefined;
				this.invalidate();
			}

			return this;

		};

		/**
		 * gets the used locale for the DatePicker
		 * only for internal use
		 * @return {string} sLocale
		 * @private
		 */
		Calendar.prototype.getLocale = function(){

			if (!this._sLocale) {
				this._sLocale = sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();
			}

			return this._sLocale;

		};

		Calendar.prototype._getFocusedDate = function(){

			if (!this._oFocusedDate) {
				var that = this;
				_determineFocusedDate(that);
			}

			return this._oFocusedDate;

		};

		Calendar.prototype._setFocusedDate = function(oDate){

			this._oFocusedDate = new Date(oDate);

		};

		/**
		 * Sets the focused date of the calendar.
		 *
		 * @param {object} oDate
		 *         JavaScript date object for focused date.
		 * @returns {sap.ui.unified.Calendar} <code>this</code> to allow method chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		Calendar.prototype.focusDate = function(oDate){

			if (oDate && (!this._oFocusedDate || this._oFocusedDate.getTime() != oDate.getTime())) {
				if (!(oDate instanceof Date)) {
					throw new Error("Date must be a JavaScript date object; " + this);
				}

				var iYear = oDate.getFullYear();
				if (iYear < 1 || iYear > 9999) {
					throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); " + this);
				}

				this._setFocusedDate(_createUTCDate(oDate));

				if (this.getDomRef() && this._iMode == 0) {
					var that = this;
					_renderMonth(that);
				}
			}

			return this;

		};

		/**
		 * sets the Popup mode
		 * e.G. Tab-chain should not leave calendar
		 * only for internal use
		 * @param {boolean} bPoupupMode <code>PopupMode</code>
		 * @private
		 */
		Calendar.prototype.setPopupMode = function(bPoupupMode){

			this._bPoupupMode = bPoupupMode;

		};

		/*
		 * gets localeData for used locale
		 * if no locale is given use rendered one
		 */
		Calendar.prototype._getLocaleData = function(){

			if (!this._oLocaleData) {
				var sLocale = this.getLocale();
				var oLocale = new sap.ui.core.Locale(sLocale);
				this._oLocaleData = LocaleData.getInstance(oLocale);
			}

			return this._oLocaleData;

		};

		Calendar.prototype.onclick = function(oEvent){

			if (oEvent.isMarked("delayedMouseEvent") ) {
				return;
			}

			var that = this;
			var oFocusedDate = this._getFocusedDate();

			if (jQuery.sap.containsOrEquals(this.getDomRef("next"), oEvent.target) && !this.$("next").attr("disabled")) {
					switch (this._iMode) {
					case 0: // day picker
						oFocusedDate.setUTCMonth(oFocusedDate.getUTCMonth() + 1, 1);
						_renderMonth(that);
						break;

					case 1: // month picker
						oFocusedDate.setUTCFullYear(oFocusedDate.getUTCFullYear() + 1);
						this.$("year").text(oFocusedDate.getUTCFullYear());
						_togglePrevNext(that, oFocusedDate);
						break;

					case 2: // year picker
						_updateYears(that, true, this._oItemNavigation.getFocusedIndex());
						break;
						// no default
					}
			} else if (jQuery.sap.containsOrEquals(this.getDomRef("prev"), oEvent.target) && !this.$("prev").attr("disabled")) {
				switch (this._iMode) {
				case 0: // day picker
					oFocusedDate.setUTCDate(1);
					oFocusedDate.setUTCDate(oFocusedDate.getUTCDate() - 1);
					_renderMonth(that);
					break;

				case 1: // month picker
					oFocusedDate.setUTCFullYear(oFocusedDate.getUTCFullYear() - 1);
					this.$("year").text(oFocusedDate.getUTCFullYear());
					_togglePrevNext(that, oFocusedDate);
					break;

				case 2: // year picker
					_updateYears(that, false, this._oItemNavigation.getFocusedIndex());
					break;
					// no default
				}
			} else if (oEvent.target.id == this.getId() + "-month") {
				if (this._iMode != 1) {
					_showMonthPicker(that);
				} else {
					_hideMonthPicker(that);
				}
				// add ItemNavigation again (might be removed by Tab)
				this.addDelegate(this._oItemNavigation);
			} else if (oEvent.target.id == this.getId() + "-year") {
				if (this._iMode != 2) {
					_showYearPicker(that);
				} else {
					_hideYearPicker(that);
				}
				// add ItemNavigation again (might be removed by Tab)
				this.addDelegate(this._oItemNavigation);
			} else if (oEvent.target.id == this.getId() + "-cancel") {
				this.onsapescape(oEvent);
			}

		};

		Calendar.prototype._handleMouseMove = function(oEvent){

			if (!this.$().is(":visible")) {
				// calendar was closed -> remove mousemove handler
				jQuery(window.document).unbind('mousemove', this._mouseMoveProxy);
				this._bMouseMove = undefined;
			}

			var $Target = jQuery(oEvent.target);

			if ($Target.hasClass("sapUiCalDayNum")) {
				$Target = $Target.parent();
			}

			if ($Target.hasClass("sapUiCalDay")) {
				var oFocusedDate = this._getFocusedDate();
				var oOldFocusedDate = oFocusedDate;
				oFocusedDate = this._oFormatYyyymmdd.parse($Target.attr("data-sap-day"), true);
				this._setFocusedDate(oFocusedDate);

				if (oFocusedDate.getTime() != oOldFocusedDate.getTime()) {
					var that = this;
					if ($Target.hasClass("sapUiCalDayOtherMonth")) {
						// in other month -> change month
						_renderMonth(that);
					} else {
						_selectDay(that, oFocusedDate, false, true);
						this._bMoveChange = true;
					}

				}
			}

		};

		Calendar.prototype.onmouseup = function(oEvent){

			if (this._bMouseMove) {
				jQuery(window.document).unbind('mousemove', this._mouseMoveProxy);
				this._bMouseMove = undefined;

				// focus now selected day
				var oFocusedDate = this._getFocusedDate();
				var aDomRefs = this.$("days").children(".sapUiCalDay");

				for ( var i = 0; i < aDomRefs.length; i++) {
					var $DomRef = jQuery(aDomRefs[i]);
					if (!$DomRef.hasClass("sapUiCalDayOtherMonth")) {
						if ($DomRef.attr("data-sap-day") == this._oFormatYyyymmdd.format(oFocusedDate, true)) {
							$DomRef.focus();
							break;
						}
					}
				}

				if (this._bMoveChange) {
					// selection was changed -> make it final
					var that = this;
					_selectDay(that, oFocusedDate);
					this._bMoveChange = false;
					_fireSelect(that);
				}
			}

		};
		/*
		sap.ui.unified.Calendar.prototype.onswipeleft = function(oEvent) {

			var that = this;
			var oFocusedDate = this._getFocusedDate();

			oFocusedDate.setUTCMonth(oFocusedDate.getUTCMonth()+1, 1);
			_renderMonth(that);

		};

		sap.ui.unified.Calendar.prototype.onswiperight = function(oEvent) {

			var that = this;
			var oFocusedDate = this._getFocusedDate();

			oFocusedDate.setUTCDate(1);
			oFocusedDate.setUTCDate(oFocusedDate.getUTCDate()-1);
			_renderMonth(that);

		};
		*/
		Calendar.prototype.onsapselect = function(oEvent){

			// focused item must be selected
			var that = this;
			var iIndex = 0;

			switch (this._iMode) {
			case 0: // day picker
				if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target)) {
					_selectDay(that, that._getFocusedDate());
					_fireSelect(that);

					//to prevent bubbling into input field if in DatePicker
					oEvent.stopPropagation();
					oEvent.preventDefault();
				}
				break;

			case 1: // month picker
				if (jQuery.sap.containsOrEquals(this.getDomRef("months"), oEvent.target)) {
					iIndex = this._oItemNavigation.getFocusedIndex();
					_selectMonth(that, iIndex);
				}
				break;

			case 2: // year picker
				if (jQuery.sap.containsOrEquals(this.getDomRef("years"), oEvent.target)) {
					iIndex = this._oItemNavigation.getFocusedIndex();
					_selectYear(that, iIndex);
				}
				break;
				// no default
			}

		};

		Calendar.prototype.onsapselectmodifiers = function(oEvent){

			this.onsapselect(oEvent);

		};

		Calendar.prototype.onsapescape = function(oEvent){

			var that = this;

			switch (this._iMode) {
			case 0: // day picker
				this.fireCancel();
				break;

			case 1: // month picker
				_hideMonthPicker(that);
				break;

			case 2: // year picker
				_hideYearPicker(that);
				break;
				// no default
			}

		};

		Calendar.prototype.onsapshow = function(oEvent){

			if (this._bPoupupMode) {
				var that = this;
				switch (this._iMode) {
				case 1: // month picker
					_hideMonthPicker(that);
					break;

				case 2: // year picker
					_hideYearPicker(that);
					break;
					// no default
				}
				this.fireCancel();

				oEvent.preventDefault(); // otherwise IE opens the address bar history

			}

		};

		Calendar.prototype.onsaphide = Calendar.prototype.onsapshow;

		Calendar.prototype.onsappageupmodifiers = function(oEvent){

			// not handled by ItemNavigation
			if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target)) {
				// go one year back
				var oFocusedDate = this._getFocusedDate();
				var that = this;
				var iYear = oFocusedDate.getUTCFullYear();

				if (oEvent.metaKey || oEvent.ctrlKey) {
					oFocusedDate.setUTCFullYear(iYear - 10);
				} else {
					oFocusedDate.setUTCFullYear(iYear - 1);
				}

				if (oFocusedDate.getTime() < this._oMinDate.getTime()){
					this._setFocusedDate(this._oMinDate);
				}
				_renderMonth(that);
			}

			// cancel the event otherwise the browser select some text
			oEvent.preventDefault();

		};

		Calendar.prototype.onsappagedownmodifiers = function(oEvent){

			// not handled by ItemNavigation
			if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target)) {
				// go one year forward
				var oFocusedDate = this._getFocusedDate();
				var that = this;
				var iYear = oFocusedDate.getUTCFullYear();

				if (oEvent.metaKey || oEvent.ctrlKey) {
					oFocusedDate.setUTCFullYear(iYear + 10);
				} else {
					oFocusedDate.setUTCFullYear(iYear + 1);
				}

				if (oFocusedDate.getTime() > this._oMaxDate.getTime()){
					this._setFocusedDate(this._oMaxDate);
				}
				_renderMonth(that);
			}

			// cancel the event otherwise the browser select some text
			oEvent.preventDefault();

		};

		Calendar.prototype.onsappageup = function(oEvent){

			if (oEvent.target.id == this.getId() + "-month" || oEvent.target.id == this.getId() + "-year") {
				//prevent browser scrolling
				oEvent.preventDefault();
			}

		};

		Calendar.prototype.onsappagedown = Calendar.prototype.onsappageup;

		Calendar.prototype.onsaptabnext = function(oEvent){

			// if tab was pressed on a day it should jump to the month and then to the year button

			if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target) ||
					jQuery.sap.containsOrEquals(this.getDomRef("months"), oEvent.target) ||
					jQuery.sap.containsOrEquals(this.getDomRef("years"), oEvent.target)) {
				// tab from a day
				jQuery.sap.focus(this.getDomRef("month"));

				if (!this._bPoupupMode) {
					// remove Tabindex from day - to break cycle
					jQuery(this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");
				}

				// remove ItemNavigation to prevent arrow navigation on buttons
				this.removeDelegate(this._oItemNavigation);

				oEvent.preventDefault();
			} else if (oEvent.target.id == this.getId() + "-month") {
				jQuery.sap.focus(this.getDomRef("year"));

				// remove ItemNavigation to prevent arrow navigation on buttons
				this.removeDelegate(this._oItemNavigation);

				oEvent.preventDefault();
			} else if (oEvent.target.id == this.getId() + "-year") {
				// add ItemNavigation again
				this.addDelegate(this._oItemNavigation);
			}

		};

		Calendar.prototype.onsaptabprevious = function(oEvent){

			if (jQuery.sap.containsOrEquals(this.getDomRef("days"), oEvent.target) ||
					jQuery.sap.containsOrEquals(this.getDomRef("months"), oEvent.target) ||
					jQuery.sap.containsOrEquals(this.getDomRef("years"), oEvent.target)) {
				// tab from a day
				if (this._bPoupupMode) {
					jQuery.sap.focus(this.getDomRef("year"));

					// remove ItemNavigation to prevent arrow navigation on buttons
					this.removeDelegate(this._oItemNavigation);

					oEvent.preventDefault();
				}
			} else if (oEvent.target.id == this.getId() + "-month") {
				// add ItemNavigation again
				this.addDelegate(this._oItemNavigation);
				this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());

				oEvent.preventDefault();
			} else if (oEvent.target.id == this.getId() + "-year") {
				jQuery.sap.focus(this.getDomRef("month"));

				oEvent.preventDefault();
			}

		};

		Calendar.prototype.onsapnext = function(oEvent){

			if (oEvent.target.id == this.getId() + "-month" || oEvent.target.id == this.getId() + "-year") {
				//prevent browser scrolling
				oEvent.preventDefault();
			}

		};

		Calendar.prototype.onsapprevious = Calendar.prototype.onsapnext;

		Calendar.prototype.onfocusin = function(oEvent){

			if (oEvent.target.id == this.getId() + "-end") {
				// focus via tab+shift (otherwise not possible to go to this element)
				jQuery.sap.focus(this.getDomRef("year"));

				// remove Tabindex from day - to break cycle
				jQuery(this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");

				// remove ItemNavigation to prevent arrow navigation on buttons
				this.removeDelegate(this._oItemNavigation);
			}

			// remove tabindex of dummy element if focus is inside calendar
			jQuery.sap.byId(this.getId() + "-end").attr("tabindex", "-1");

		};

		Calendar.prototype.onsapfocusleave = function(oEvent){

			if (!oEvent.relatedControlId || !jQuery.sap.containsOrEquals(this.getDomRef(), sap.ui.getCore().byId(oEvent.relatedControlId).getFocusDomRef())) {
				// put dummy element back to tab-chain
				jQuery.sap.byId(this.getId() + "-end").attr("tabindex", "0");
				// add ItemNavigation again
				this.addDelegate(this._oItemNavigation);
			}

		};

		/*
		 * Checks if a date is selected and what kind of selected
		 * @return {int} iSelected 0: not selected; 1: single day selected, 2: interval start, 3: interval end, 4: interval between
		 * @private
		 */
		Calendar.prototype._checkDateSelected = function(oDate){

			if (!(oDate instanceof Date)) {
				throw new Error("Date must be a JavaScript date object; " + this);
			}

			var iSelected = 0;
			var aSelectedDates = this.getSelectedDates();
			var oTimeStamp = oDate.getTime();

			for ( var i = 0; i < aSelectedDates.length; i++) {
				// initalize the time part of the start and end time
				var oRange = aSelectedDates[i];
				var oTmpDate = _createUTCDate(oRange.getStartDate());
				var oStartDate;
				var oStartTimeStamp = 0;
				if (oTmpDate) {
					oStartDate = oTmpDate;
					oStartTimeStamp = oStartDate.getTime();
				}
				var oEndDate;
				var oEndTimeStamp = 0;
				if (this.getIntervalSelection()) {
					oTmpDate = _createUTCDate(oRange.getEndDate());
					if (oTmpDate) {
						oEndDate = oTmpDate;
						oEndTimeStamp = oEndDate.getTime();
					}
				}

				if (oTimeStamp == oStartTimeStamp && !oEndDate ) {
					iSelected = 1; // single day selected
					break;
				} else if (oTimeStamp == oStartTimeStamp && oEndDate ) {
					iSelected = 2; // interval start
					if (oEndDate && oTimeStamp == oEndTimeStamp) {
						// one day interval
						iSelected = 5;
					}
					break;
				} else if (oEndDate && oTimeStamp == oEndTimeStamp) {
					iSelected = 3; // interval end
					break;
				} else if (oEndDate && oTimeStamp > oStartTimeStamp && oTimeStamp < oEndTimeStamp) {
					iSelected = 4; // interval between
					break;
				}

				if (this.getSingleSelection()) {
					// if single selection only check the first range
					break;
				}
			}

			return iSelected;

		};

		/*
		 * gets the type of a single date checking the specialDates aggregation
		 * the first hit is used
		 * @return {object} date type and tooltip defined in CalendarDayType
		 * @private
		 */
		Calendar.prototype._getDateType = function(oDate){

			if (!(oDate instanceof Date)) {
				throw new Error("Date must be a JavaScript date object; " + this);
			}

			var oType;
			var aSpecialDates = this.getSpecialDates();
			var oTimeStamp = oDate.getTime();

			for ( var i = 0; i < aSpecialDates.length; i++) {
				// initialize the time part of the start and end time
				var oRange = aSpecialDates[i];
				var oTmpDate = _createUTCDate(oRange.getStartDate());
				var oStartDate;
				var oStartTimeStamp = 0;
				if (oTmpDate) {
					oStartDate = oTmpDate;
					oStartTimeStamp = oStartDate.getTime();
				}
				var oEndDate;
				var oEndTimeStamp = 0;
				oTmpDate = _createUTCDate(oRange.getEndDate());
				if (oTmpDate) {
					oEndDate = oTmpDate;
					oEndTimeStamp = oEndDate.getTime();
				}

				if ((oTimeStamp == oStartTimeStamp && !oEndDate) || (oTimeStamp >= oStartTimeStamp && oTimeStamp <= oEndTimeStamp)) {
					oType = {type: oRange.getType(), tooltip: oRange.getTooltip_AsString()};
					break;
				}
			}

			return oType;

		};

		function _handleAfterFocus(oControlEvent){

			var iIndex = oControlEvent.getParameter("index");
			var oEvent = oControlEvent.getParameter("event");

			if (!oEvent) {
				return; // happens if focus is set via ItemNavigation.focusItem directly
			}

			var that = this;
			var oFocusedDate = this._getFocusedDate();

			if (this._iMode == 0) {
				// day picker

				var aDomRefs = this.$("days").children(".sapUiCalDay");
				var i = 0;

				// find out what day was focused
				var $DomRef = jQuery(aDomRefs[iIndex]);
				var $DomRefDay;
				if ($DomRef.hasClass("sapUiCalDayOtherMonth")) {
					if (oEvent.type == "saphomemodifiers" && (oEvent.metaKey || oEvent.ctrlKey)) {
						// on ctrl+home key focus first day of month
						oFocusedDate.setUTCDate(1);
						_focusDate(that, oFocusedDate);
					} else if (oEvent.type == "sapendmodifiers" && (oEvent.metaKey || oEvent.ctrlKey)) {
						// on ctrl+end key focus last day of month
						for ( i = aDomRefs.length - 1; i > 0 ; i--) {
							$DomRefDay = jQuery(aDomRefs[i]);
							if (!$DomRefDay.hasClass("sapUiCalDayOtherMonth")) {
								oFocusedDate = this._oFormatYyyymmdd.parse($DomRefDay.attr("data-sap-day"), true);
								this._setFocusedDate(oFocusedDate);
								break;
							}
						}
						if (oFocusedDate.getTime() >= this._oMinDate.getTime() && oFocusedDate.getTime() <= this._oMaxDate.getTime()) {
								this._oItemNavigation.focusItem(i);
						}else {
							_focusDate(that, oFocusedDate);
						}
					} else {
						// switch to the requested month and focus the chosen day
						oFocusedDate = this._oFormatYyyymmdd.parse($DomRef.attr("data-sap-day"), true);
						if (!oFocusedDate) {
							oFocusedDate = this._getFocusedDate(); // e.g. year > 9999
						}

						if (oFocusedDate.getTime() >= this._oMinDate.getTime() && oFocusedDate.getTime() <= this._oMaxDate.getTime()) {
							this._setFocusedDate(oFocusedDate);
							_renderMonth(that);
						}else {
							_focusDate(that, oFocusedDate);
						}
					}
				} else {
					// day in current month focused
					if (!jQuery(oEvent.target).hasClass("sapUiCalWeekNum")) {
						// not if clicked on week number
						oFocusedDate = this._oFormatYyyymmdd.parse($DomRef.attr("data-sap-day"), true);
						if (oFocusedDate.getTime() >= this._oMinDate.getTime() && oFocusedDate.getTime() <= this._oMaxDate.getTime()) {
							this._setFocusedDate(oFocusedDate);
						}else {
							_focusDate(that, oFocusedDate);
						}
					}
				}
			}

			if (oEvent.type == "mousedown") {
				// as no click event is fired in some cases, e.g. if month is changed (because of changing DOM) select the day on mousedown
				_handleMousedown(that, oEvent, oFocusedDate, iIndex);
			}

		}

		function _handleFocusAgain(oControlEvent){

			var iIndex = oControlEvent.getParameter("index");
			var oEvent = oControlEvent.getParameter("event");

			if (!oEvent) {
				return; // happens if focus is set via ItemNavigation.focusItem directly
			}

			if (oEvent.type == "mousedown") {
				// as no click event is fired in some cases, e.g. if month is changed (because of changing DOM) select the day on mousedown
				var that = this;
				var oFocusedDate = this._getFocusedDate();
				_handleMousedown(that, oEvent, oFocusedDate, iIndex);
			}

		}

		function _handleMousedown(oThis, oEvent, oFocusedDate, iIndex){

			switch (oThis._iMode) {
			case 0: // day picker
				_selectDay(oThis, oFocusedDate, oEvent.shiftKey);
				_fireSelect(oThis);
				if (oThis.getIntervalSelection() && oThis.$().is(":visible")) {
					// if calendar was closed in select event, do not add mousemove handler
					jQuery(window.document).bind('mousemove', oThis._mouseMoveProxy);
					oThis._bMouseMove = true;
				}
				break;

			case 1: // month picker
				_selectMonth(oThis, iIndex);
				break;

			case 2: // year picker
				_selectYear(oThis, iIndex);
				break;
				// no default
			}
			oEvent.preventDefault(); // to prevent focus set outside of DatePicker
			oEvent.setMark("cancelAutoClose");

		}

		function _handleBorderReached(oControlEvent){

			var oEvent = oControlEvent.getParameter("event");
			var iMonth = 0;
			var oFocusedDate = this._getFocusedDate();

			if (oEvent.type) {
				var that = this;

				switch (this._iMode) {
				case 0: // day picker
					switch (oEvent.type) {
					case "sapnext":
					case "sapnextmodifiers":
						// last day in month reached
						if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) {
							//goto same day next week
							oFocusedDate.setUTCDate(oFocusedDate.getUTCDate() + 7);
						} else {
							//go to next day
							oFocusedDate.setUTCDate(oFocusedDate.getUTCDate() + 1);
						}
						break;

					case "sapprevious":
					case "sappreviousmodifiers":
						// first day in month reached
						if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) {
							//goto same day previous week
							oFocusedDate.setUTCDate(oFocusedDate.getUTCDate() - 7);
						} else {
							//go to previous day
							oFocusedDate.setUTCDate(oFocusedDate.getUTCDate() - 1);
						}
						break;

					case "sappagedown":
						// go to same day next month
						iMonth = oFocusedDate.getUTCMonth() + 1;
						oFocusedDate.setUTCMonth(iMonth);
						// but if the day doesn't exist in this month, go to last day of the month
						if (iMonth % 12 != oFocusedDate.getUTCMonth()) {
							while (iMonth != oFocusedDate.getUTCMonth()) {
								oFocusedDate.setUTCDate(oFocusedDate.getUTCDate() - 1);
							}
						}
						break;

					case "sappageup":
						// go to same day previous month
						iMonth = oFocusedDate.getUTCMonth() - 1;
						oFocusedDate.setUTCMonth(iMonth);
						if (iMonth < 0) {
							iMonth = 11;
						}
						// but if the day doesn't exist in this month, go to last day of the month
						if (iMonth != oFocusedDate.getUTCMonth()) {
							while (iMonth != oFocusedDate.getUTCMonth()) {
								oFocusedDate.setUTCDate(oFocusedDate.getUTCDate() - 1);
							}
						}
						break;

					default:
						break;
					}

					if (oFocusedDate.getTime() > this._oMaxDate.getTime()) {
						oFocusedDate.setUTCFullYear(this._oMaxDate.getUTCFullYear());
						oFocusedDate.setUTCMonth(this._oMaxDate.getUTCMonth());
						oFocusedDate.setUTCDate(this._oMaxDate.getUTCDate());
					}
					if (oFocusedDate.getTime() < this._oMinDate.getTime()) {
						oFocusedDate.setUTCFullYear(this._oMinDate.getUTCFullYear());
						oFocusedDate.setUTCMonth(this._oMinDate.getUTCMonth());
						oFocusedDate.setUTCDate(this._oMinDate.getUTCDate());
					}

					_renderMonth(that);
					break;

				case 1: // month picker
					break;

				case 2: // year picker
					switch (oEvent.type) {
					case "sapnext":
					case "sapnextmodifiers":
						if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) {
							//same column in first row of next group
							_updateYears(that, true, this._oItemNavigation.getFocusedIndex() - 16);
						} else {
							// first year in next group
							_updateYears(that, true, 0);
						}
						break;

					case "sapprevious":
					case "sappreviousmodifiers":
						if (oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) {
							//same column in last row of previous group
							_updateYears(that, false, 16 + this._oItemNavigation.getFocusedIndex());
						} else {
							// last year in previous group
							_updateYears(that, false, 19);
						}
						break;

					case "sappagedown":
						// same index in next group
						_updateYears(that, true, this._oItemNavigation.getFocusedIndex());
						break;

					case "sappageup":
						// same index in previous group
						_updateYears(that, false, this._oItemNavigation.getFocusedIndex());
						break;

					default:
						break;
					}
					break;
					// no default
				}
			}

		}

		function _initItemNavigation(oThis){

			var oDate = oThis._getFocusedDate();
			var sYyyymmdd = oThis._oFormatYyyymmdd.format(oDate, true);
			var aDomRefs = [];
			var oRootDomRef;
			var iIndex = 0;
			var iColumns = 0;
			var bNoColumnChange = false;
			var bCycling = true;

			switch (oThis._iMode) {
			case 0: // day picker
				oRootDomRef = oThis.$("days").get(0);
				aDomRefs = oThis.$("days").children(".sapUiCalDay");

				for ( var i = 0; i < aDomRefs.length; i++) {
					var $DomRef = jQuery(aDomRefs[i]);
					if ($DomRef.attr("data-sap-day") === sYyyymmdd) {
						iIndex = i;
					}
				}

				iColumns = 7;
				bNoColumnChange = true;
				bCycling = false;

				break;

			case 1: // month picker
				oRootDomRef = oThis.$("months").get(0);
				aDomRefs = oThis.$("months").children(".sapUiCalMonth");
				iIndex = oDate.getUTCMonth();

				iColumns = 3;

				break;

			case 2: // year picker
				oRootDomRef = oThis.$("years").get(0);
				aDomRefs = oThis.$("years").children(".sapUiCalYear");
				iIndex = 10;

				iColumns = 4;
				bNoColumnChange = true;
				bCycling = false;

				break;
				// no default
			}


			if (!oThis._oItemNavigation) {
				oThis._oItemNavigation = new ItemNavigation();
				oThis._oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, _handleAfterFocus, oThis);
				oThis._oItemNavigation.attachEvent(ItemNavigation.Events.FocusAgain, _handleFocusAgain, oThis);
				oThis._oItemNavigation.attachEvent(ItemNavigation.Events.BorderReached, _handleBorderReached, oThis);
				oThis.addDelegate(oThis._oItemNavigation);
				oThis._oItemNavigation.setHomeEndColumnMode(true, true);
				oThis._oItemNavigation.setDisabledModifiers({
					sapnext : ["alt"],
					sapprevious : ["alt"],
					saphome : ["alt"],
					sapend : ["alt"]
				});
			}
			oThis._oItemNavigation.setRootDomRef(oRootDomRef);
			oThis._oItemNavigation.setItemDomRefs(aDomRefs);
			oThis._oItemNavigation.setCycling(bCycling);
			oThis._oItemNavigation.setColumns(iColumns, bNoColumnChange);
			oThis._oItemNavigation.setFocusedIndex(iIndex);
			oThis._oItemNavigation.setPageSize(aDomRefs.length); // to make sure that pageup/down goes out of month

		}

		function _renderMonth(oThis){

			oThis._sRenderMonth = undefined; // initialize delayed call

			var oDate = oThis._getFocusedDate();
			var $Container = oThis.$("days");

			if ($Container.length > 0) {
				var oRm = sap.ui.getCore().createRenderManager();
				oThis.getRenderer().renderDays(oRm, oThis, oDate);
				oRm.flush($Container[0]);
				oRm.destroy();
			}

			// fire internal event for DatePicker for with number of rendered days. If Calendar becomes larger maybe popup must change position
			oThis.fireEvent("_renderMonth", {days: $Container.children(".sapUiCalDay").length});

			// change month and year
			var aMonthNames = [];
			if (oThis._bLongMonth || !oThis._bNamesLengthChecked) {
				aMonthNames = oThis._getLocaleData().getMonthsStandAlone("wide");
			} else {
				aMonthNames = oThis._getLocaleData().getMonthsStandAlone("abbreviated");
			}
			oThis.$("month").text(aMonthNames[oDate.getUTCMonth()]);
			oThis.$("year").text(oDate.getUTCFullYear());

			_initItemNavigation(oThis);
			oThis._oItemNavigation.focusItem(oThis._oItemNavigation.getFocusedIndex());

			_togglePrevNext(oThis, oDate, true);

		}

		/**
		 * Creates a Date in local timezone from UTC timezone
		 * @param {Date} oDate in UTC timezone
		 * @return {Date} in local timezone
		 * @private
		 */
		function _createLocalDate(oDate) {
			if (oDate) {
				return new Date(oDate.getTime() + oDate.getTimezoneOffset() * 60000);
			}
		}

		/**
		 * Creates a Date in UTC timezone from local timezone
		 * @param {Date} oDate in local timezone
		 * @return {Date} in UTC timezone
		 * @private
		 */
		function _createUTCDate(oDate) {
			if (oDate) {
				var oUTCDate = new Date(Date.UTC(oDate.getFullYear(),oDate.getMonth(),oDate.getDate()));
				if (oDate.getFullYear() < 1000) {
					oUTCDate.setUTCFullYear(oDate.getFullYear());
				}
				return oUTCDate;
			}

		}

		function _selectDay(oThis, oDate, bIntervalEnd, bMove){

			var aSelectedDates = oThis.getSelectedDates();
			var oDateRange;
			var aDomRefs = oThis.$("days").children(".sapUiCalDay");
			var $DomRef;
			var sYyyymmdd;
			var i = 0;
			if (oThis.getSingleSelection()) {
				var oStartDate;

				if (aSelectedDates.length > 0) {
					oDateRange = aSelectedDates[0];
					oStartDate = _createUTCDate(oDateRange.getStartDate());
				} else {
					oDateRange = new sap.ui.unified.DateRange();
					oThis.addAggregation("selectedDates", oDateRange, true); // no re-rendering
				}

				if (oThis.getIntervalSelection()/* && bIntervalEnd*/ && (!oDateRange.getEndDate() || bMove) && oStartDate) {
					// single interval selection
					var oEndDate;
					if (oDate.getTime() < oStartDate.getTime()) {
						oEndDate = oStartDate;
						oStartDate = oDate;
						if (!bMove) {
							// in move mode do not set date. this bring broblems if on backward move the start date would be cahnged
							oDateRange.setProperty("startDate", _createLocalDate(oStartDate), true); // no-rerendering
							oDateRange.setProperty("endDate", _createLocalDate(oEndDate), true); // no-rerendering
						}
					} else if (oDate.getTime() >= oStartDate.getTime()) {
						// single day ranges are allowed
						oEndDate = oDate;
						if (!bMove) {
							oDateRange.setProperty("endDate", _createLocalDate(oEndDate), true); // no-rerendering
						}
					}

					var oDay;
					for ( i = 0; i < aDomRefs.length; i++) {
						$DomRef = jQuery(aDomRefs[i]);
						oDay = oThis._oFormatYyyymmdd.parse($DomRef.attr("data-sap-day"), true);

						if (oDay.getTime() == oStartDate.getTime()) {
							$DomRef.addClass("sapUiCalDaySelStart");
							$DomRef.addClass("sapUiCalDaySel");
							if (oEndDate && oDay.getTime() == oEndDate.getTime()) {
								// start day and end day are the same
								$DomRef.addClass("sapUiCalDaySelEnd");
							}
						} else if (oEndDate && oDay.getTime() > oStartDate.getTime() && oDay.getTime() < oEndDate.getTime()) {
							$DomRef.addClass("sapUiCalDaySel");
							$DomRef.addClass("sapUiCalDaySelBetween");
						} else if (oEndDate && oDay.getTime() == oEndDate.getTime()) {
							$DomRef.addClass("sapUiCalDaySelEnd");
							$DomRef.addClass("sapUiCalDaySel");
						} else {
							if ($DomRef.hasClass("sapUiCalDaySel")) {
								$DomRef.removeClass("sapUiCalDaySel");
							}
							if ($DomRef.hasClass("sapUiCalDaySelStart")) {
								$DomRef.removeClass("sapUiCalDaySelStart");
							} else if ($DomRef.hasClass("sapUiCalDaySelBetween")) {
								$DomRef.removeClass("sapUiCalDaySelBetween");
							} else if ($DomRef.hasClass("sapUiCalDaySelEnd")) {
								$DomRef.removeClass("sapUiCalDaySelEnd");
							}
						}
					}
				} else {
					// single day selection or start a new interval
					sYyyymmdd = oThis._oFormatYyyymmdd.format(oDate, true);
					for ( i = 0; i < aDomRefs.length; i++) {
						$DomRef = jQuery(aDomRefs[i]);
						if (!$DomRef.hasClass("sapUiCalDayOtherMonth") && $DomRef.attr("data-sap-day") == sYyyymmdd) {
							$DomRef.addClass("sapUiCalDaySel");
						} else if ($DomRef.hasClass("sapUiCalDaySel")/*oOldDate && parseInt($DomRef.attr("data-sap-day")) == oOldDate.getUTCDate()*/) {
							$DomRef.removeClass("sapUiCalDaySel");
						}
						if ($DomRef.hasClass("sapUiCalDaySelStart")) {
							$DomRef.removeClass("sapUiCalDaySelStart");
						} else if ($DomRef.hasClass("sapUiCalDaySelBetween")) {
							$DomRef.removeClass("sapUiCalDaySelBetween");
						} else if ($DomRef.hasClass("sapUiCalDaySelEnd")) {
							$DomRef.removeClass("sapUiCalDaySelEnd");
						}
					}
					oDateRange.setProperty("startDate", _createLocalDate(oDate), true); // no-rerendering
					oDateRange.setProperty("endDate", undefined, true); // no-rerendering
				}
			} else {
				// multiple selection
				if (oThis.getIntervalSelection()) {
					throw new Error("Calender don't support multiple interval selection");

				} else {
					var iSelected = oThis._checkDateSelected(oDate);
					if (iSelected > 0) {
						// already selected - deselect
						for ( i = 0; i < aSelectedDates.length; i++) {
							if (aSelectedDates[i].getStartDate() && oDate.getTime() == _createUTCDate(aSelectedDates[i].getStartDate()).getTime()) {
								oThis.removeAggregation("selectedDates", i, true); // no re-rendering
								break;
							}
						}
					} else {
						// not selected -> select
						oDateRange = new sap.ui.unified.DateRange({startDate: _createLocalDate(oDate)});
						oThis.addAggregation("selectedDates", oDateRange, true); // no re-rendering
					}
					sYyyymmdd = oThis._oFormatYyyymmdd.format(oDate, true);
					for ( i = 0; i < aDomRefs.length; i++) {
						$DomRef = jQuery(aDomRefs[i]);
						if (!$DomRef.hasClass("sapUiCalDayOtherMonth") && $DomRef.attr("data-sap-day") == sYyyymmdd) {
							if (iSelected > 0) {
								$DomRef.removeClass("sapUiCalDaySel");
							} else {
								$DomRef.addClass("sapUiCalDaySel");
							}
						}
					}
				}
			}

		}

		function _determineFocusedDate(oThis){

			var aSelectedDates = oThis.getSelectedDates();
			if (aSelectedDates && aSelectedDates[0] && aSelectedDates[0].getStartDate()) {
				// selected dates are provided -> use first one to focus
				oThis._oFocusedDate = _createUTCDate(aSelectedDates[0].getStartDate());
			} else {
				// use current date
				var newDate = new Date();
				oThis._oFocusedDate = _createUTCDate(newDate);
			}

		}

		function _showMonthPicker(oThis){

			if (oThis._iMode == 2) {
				_hideYearPicker(oThis);
			}

			var oDate = oThis._getFocusedDate();
			var oRm = sap.ui.getCore().createRenderManager();
			var $Container = oThis.$();

			oThis.getRenderer().renderMonthPicker(oRm, oThis, oDate);
			oRm.flush($Container[0], false, true); // insert it
			oRm.destroy();

			oThis._iMode = 1;

			// remove tabindex from focused day
			jQuery(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");

			_initItemNavigation(oThis);
			jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

			_togglePrevNext(oThis, oDate, false);

		}

		function _hideMonthPicker(oThis){

			oThis.$("months").remove();
			oThis._iMode = 0;
			_initItemNavigation(oThis);
			jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

			var oFocusedDate = oThis._getFocusedDate();
			oThis.$("year").text(oFocusedDate.getUTCFullYear());
			_togglePrevNext(oThis, oFocusedDate, true);

		}

		function _selectMonth(oThis, iMonth){

			var oFocusedDate = oThis._getFocusedDate();

			oFocusedDate.setUTCMonth(iMonth);

			if (iMonth != oFocusedDate.getUTCMonth() ) {
				// day did not exist in this month (e.g. 31) -> go to last day of month
				oFocusedDate.setUTCDate(0);
			}

			if (oFocusedDate.getTime() < oThis._oMinDate.getTime()) {
				oThis._setFocusedDate(oThis._oMinDate);
			}else if (oFocusedDate.getTime() > oThis._oMaxDate.getTime()){
				oThis._setFocusedDate(oThis._oMaxDate);
			}

			_renderMonth(oThis);

			_hideMonthPicker(oThis);

		}

		function _showYearPicker(oThis){

			if (oThis._iMode == 1) {
				_hideMonthPicker(oThis);
			}

			var oDate = oThis._getFocusedDate();
			var oRm = sap.ui.getCore().createRenderManager();
			var $Container = oThis.$();
			var iYearMax = oThis._oMaxDate.getUTCFullYear();
			var iYearMin = oThis._oMinDate.getUTCFullYear();

			if (iYearMax - iYearMin <= 20) {
				return;
			}

			if (oDate.getUTCFullYear() > ( iYearMax - 10 )) {
				oDate.setUTCFullYear(iYearMax - 9);
				oThis.$("next").toggleClass("sapUiCalDsbl", true).attr("disabled", "disabled");
			} else {
				oThis.$("next").toggleClass("sapUiCalDsbl", false).removeAttr("disabled");
			}
			if (oDate.getUTCFullYear() < ( iYearMin + 9 )) {
				oDate.setUTCFullYear(iYearMin + 10);
				oThis.$("prev").toggleClass("sapUiCalDsbl", true).attr("disabled", "disabled");
			} else {
				oThis.$("prev").toggleClass("sapUiCalDsbl", false).removeAttr("disabled");
			}

			oThis.getRenderer().renderYearPicker(oRm, oThis, oDate);
			oRm.flush($Container[0], false, true); // insert it
			oRm.destroy();

			// check special case if only 4 weeks are displayed (e.g. February 2021) -> top padding must be removed
			var aDomRefs = oThis.$("days").children(".sapUiCalDay");
			if (aDomRefs.length == 28) {
				oThis.$("years").addClass("sapUiCalYearNoTop");
			}

			oThis._iMode = 2;

			// remove tabindex from focused day
			jQuery(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]).attr("tabindex", "-1");

			_initItemNavigation(oThis);
			jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

		}

		function _hideYearPicker(oThis){

			oThis.$("years").remove();
			oThis._iMode = 0;
			_initItemNavigation(oThis);
			jQuery.sap.focus(oThis._oItemNavigation.getItemDomRefs()[oThis._oItemNavigation.getFocusedIndex()]);

			var oFocusedDate = oThis._getFocusedDate();
			_togglePrevNext(oThis, oFocusedDate, true);

		}

		function _selectYear(oThis, iIndex){

			var oFocusedDate = oThis._getFocusedDate();
			var aDomRefs = oThis.$("years").children(".sapUiCalYear");
			var sYear = jQuery(aDomRefs[iIndex]).text();

			oFocusedDate.setUTCFullYear(sYear);

			if (oFocusedDate.getTime() < oThis._oMinDate.getTime()) {
				oThis._setFocusedDate(oThis._oMinDate);
			}else if (oFocusedDate.getTime() > oThis._oMaxDate.getTime()){
				oThis._setFocusedDate(oThis._oMaxDate);
			}

			_renderMonth(oThis);

			_hideYearPicker(oThis);

		}

		function _updateYears(oThis, bForward, iSelectedIndex){

			var aDomRefs = oThis.$("years").children(".sapUiCalYear");
			var iFirstYear = parseInt(jQuery(aDomRefs[0]).text(), 10);
			var oFocusedDate = oThis._getFocusedDate();
			var sCurrentYear = oFocusedDate.getUTCFullYear().toString();
			var iYearMax = oThis._oMaxDate.getUTCFullYear();
			var iYearMin = oThis._oMinDate.getUTCFullYear();

			if (bForward) {
				iFirstYear = iFirstYear + 20;
			} else {
				iFirstYear = iFirstYear - 20;
			}

			if (iFirstYear >= iYearMax - 19) {
				iFirstYear = iYearMax - 19;
				oThis.$("next").toggleClass("sapUiCalDsbl", true).attr("disabled", "disabled");
			}else {
				oThis.$("next").toggleClass("sapUiCalDsbl", false).removeAttr("disabled");
			}
			if (iFirstYear <= iYearMin) {
				iFirstYear = iYearMin;
				oThis.$("prev").toggleClass("sapUiCalDsbl", true).attr("disabled", "disabled");
			} else {
				oThis.$("prev").toggleClass("sapUiCalDsbl", false).removeAttr("disabled");
			}

			var iYear = iFirstYear;
			for ( var i = 0; i < aDomRefs.length; i++) {
				var $DomRef = jQuery(aDomRefs[i]);
				$DomRef.attr("id", oThis.getId() + "-y" + iYear);
				$DomRef.text(iYear);
				if ($DomRef.hasClass("sapUiCalYearSel") && $DomRef.text() != sCurrentYear) {
					$DomRef.removeClass("sapUiCalYearSel");
				} else if (!$DomRef.hasClass("sapUiCalYearSel") && $DomRef.text() == sCurrentYear) {
					$DomRef.addClass("sapUiCalYearSel");
				}
				iYear++;
			}

			oThis._oItemNavigation.focusItem(iSelectedIndex);

		}

		function _checkNamesLength(oThis){

			if (!oThis._bNamesLengthChecked) {
				// only once - cannot change by rerendering - only by theme change
				var i = 0;
				var oWeekDay;
				var oLocaleData;

				// check day names
				var aWeekHeaders = oThis.$().children(".sapUiCalWH");
				var bTooLong = false;

				for ( i = 0; i < aWeekHeaders.length; i++) {
					oWeekDay = aWeekHeaders[i];
					if (oWeekDay.clientWidth < oWeekDay.scrollWidth) {
						bTooLong = true;
						break;
					}
				}

				if (bTooLong) {
					oThis._bLongWeekDays = false;
					oLocaleData = oThis._getLocaleData();
					var iFirstDayOfWeek = oLocaleData.getFirstDayOfWeek();
					var aDayNames = oLocaleData.getDaysStandAlone("narrow");
					for ( i = 0; i < aDayNames.length; i++) {
						oWeekDay = aWeekHeaders[i];
						jQuery(oWeekDay).text(aDayNames[(i + iFirstDayOfWeek) % 7]);
					}
				} else {
					oThis._bLongWeekDays = true;
				}

				// check month names
				_showMonthPicker(oThis);

				var aMonths = oThis.$("months").children();
				bTooLong = false;
				for ( i = 0; i < aMonths.length; i++) {
					var oMonth = aMonths[i];
					if (oMonth.clientWidth < oMonth.scrollWidth) {
						bTooLong = true;
						break;
					}
				}
				if (bTooLong) {
					oThis._bLongMonth = false;
					if (!oLocaleData) {
						oLocaleData = oThis._getLocaleData();
					}
					// change month name on button but not chnage month picker, becuase it is hided again
					var aMonthNames = oLocaleData.getMonthsStandAlone("abbreviated");
					var oDate = oThis._getFocusedDate();
					oThis.$("month").text(aMonthNames[oDate.getUTCMonth()]);
				} else {
					oThis._bLongMonth = true;
				}

				_hideMonthPicker(oThis);

				oThis._bNamesLengthChecked = true;
			}

		}

		function _fireSelect(oThis){

			if (oThis._bMouseMove) {
				// detach mouse move handler because calendar might be losed in select event handler
				jQuery(window.document).unbind('mousemove', oThis._mouseMoveProxy);
				oThis._bMouseMove = undefined;
			}

			oThis.fireSelect();

		}

		function _togglePrevNext (oThis, oDate, bCheckMonth){

			var iYear = oDate.getUTCFullYear();
			var iYearMax = oThis._oMaxDate.getUTCFullYear();
			var iYearMin = oThis._oMinDate.getUTCFullYear();
			var iMonth = oDate.getUTCMonth();
			var iMonthMax = oThis._oMaxDate.getUTCMonth();
			var iMonthMin = oThis._oMinDate.getUTCMonth();

			if (iYear > iYearMax || (iYear == iYearMax && ( !bCheckMonth || iMonth >= iMonthMax ))) {
				oThis.$("next").toggleClass("sapUiCalDsbl", true).attr("disabled", "disabled");
			}else {
				oThis.$("next").toggleClass("sapUiCalDsbl", false).removeAttr("disabled");
			}

			if (iYear < iYearMin || (iYear == iYearMin && ( !bCheckMonth || iMonth <= iMonthMin ))) {
				oThis.$("prev").toggleClass("sapUiCalDsbl", true).attr("disabled", "disabled");
			}else {
				oThis.$("prev").toggleClass("sapUiCalDsbl", false).removeAttr("disabled");
			}

		}

		function _focusDate (oThis, oDate){

			// if a date should be focused thats out of the borders -> focus the border
			var oFocusedDate;
			if (oDate.getTime() < oThis._oMinDate.getTime()) {
				oFocusedDate = oThis._oMinDate;
			}else if (oDate.getTime() > oThis._oMaxDate.getTime()){
				oFocusedDate = oThis._oMaxDate;
			}else {
				oFocusedDate = oDate;
			}

			oThis._setFocusedDate(oFocusedDate);

			var sYyyymmdd = oThis._oFormatYyyymmdd.format(oFocusedDate, true);
			var aDomRefs = oThis._oItemNavigation.getItemDomRefs();
			var $DomRefDay;
			for ( var i = 0; i < aDomRefs.length; i++) {
				$DomRefDay = jQuery(aDomRefs[i]);
				if ($DomRefDay.attr("data-sap-day") == sYyyymmdd) {
					oThis._oItemNavigation.focusItem(i);
					break;
				}
			}

		}

	}());

	return Calendar;

}, /* bExport= */ true);

}; // end of sap/ui/unified/Calendar.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarLegend') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.CalendarLegend.
jQuery.sap.declare('sap.ui.unified.CalendarLegend'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/CalendarLegend",['jquery.sap.global', 'sap/ui/core/Control', './library'],
	function(jQuery, Control, library) {
	"use strict";


	
	/**
	 * Constructor for a new CalendarLegend.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A legend for the Calendar Control. Displays special dates colors with their corresponding description. The aggregation specialDates can be set herefor.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.CalendarLegend
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var CalendarLegend = Control.extend("sap.ui.unified.CalendarLegend", /** @lends sap.ui.unified.CalendarLegend.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * Width of the columns created in which the items are arranged.
			 */
			columnWidth : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : '120px'}
		},
		aggregations : {
	
			/**
			 * Items to be displayed.
			 */
			items : {type : "sap.ui.unified.CalendarLegendItem", multiple : true, singularName : "item"}
		}
	}});
	
	// IE9 workaround for responsive layout of legend items
	CalendarLegend.prototype.onAfterRendering = function() {
		if (sap.ui.Device.browser.msie) {
			if (sap.ui.Device.browser.version < 10) {
				jQuery(".sapUiUnifiedLegendItem").css("width", this.getColumnWidth() + 4 + "px").css("display", "inline-block");
			}
		}
	};
	

	return CalendarLegend;

}, /* bExport= */ true);

}; // end of sap/ui/unified/CalendarLegend.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.CalendarLegendItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.CalendarLegendItem.
jQuery.sap.declare('sap.ui.unified.CalendarLegendItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/CalendarLegendItem",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element, library) {
	"use strict";


	
	/**
	 * Constructor for a new CalendarLegendItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Item to be displayed in a CalendarLegend.
	 * @extends sap.ui.core.Element
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.CalendarLegendItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var CalendarLegendItem = Element.extend("sap.ui.unified.CalendarLegendItem", /** @lends sap.ui.unified.CalendarLegendItem.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * Text to be displayed for the item.
			 */
			text : {type : "string", group : "Misc", defaultValue : null}
		}
	}});
	
	///**
	// * This file defines behavior for the control,
	// */
	//sap.ui.unified.CalendarLegendItem.prototype.init = function(){
	//   // do something for initialization...
	//};
	

	return CalendarLegendItem;

}, /* bExport= */ true);

}; // end of sap/ui/unified/CalendarLegendItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ContentSwitcher') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.ContentSwitcher.
jQuery.sap.declare('sap.ui.unified.ContentSwitcher'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ContentSwitcher",['jquery.sap.global', 'sap/ui/core/Control', './library'],
	function(jQuery, Control, library) {
	"use strict";


	
	/**
	 * Constructor for a new ContentSwitcher.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Switches between two control areas and animates it via CSS transitions
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.16.0
	 * @experimental Since version 1.16.0. 
	 * API is not yet finished and might change completely
	 * @alias sap.ui.unified.ContentSwitcher
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ContentSwitcher = Control.extend("sap.ui.unified.ContentSwitcher", /** @lends sap.ui.unified.ContentSwitcher.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * Set the used animation when changing content. This just sets a CSS-class named "sapUiUnifiedACSwitcherAnimation" + this value on the root element of the control. The animation has to be implemented in CSS. This also enables applications to implement their own animations via CSS by reacting to the parent class.
			 * See the types sap.ui.unified.ContentSwitcherAnimation for default implementations.
			 */
			animation : {type : "string", group : "Appearance", defaultValue : 'None'},
	
			/**
			 * The number of the currently active content (1 or 2).
			 */
			activeContent : {type : "int", group : "Behavior", defaultValue : 1}
		},
		aggregations : {
	
			/**
			 * The controls that should be shown in the first content
			 */
			content1 : {type : "sap.ui.core.Control", multiple : true, singularName : "content1"}, 
	
			/**
			 * The controls that should be shown in the second content
			 */
			content2 : {type : "sap.ui.core.Control", multiple : true, singularName : "content2"}
		}
	}});
	
	(function(window) {
	
	////////////////////////////////////////// Public Methods //////////////////////////////////////////
	
	/**
	 * This file defines behavior for the control,
	 */
	ContentSwitcher.prototype.init = function(){
	};
	
	/**
	 * Changes the currently active content to the other one. If content 1 is active, content 2 will
	 * be activated and the other way around.
	 * 
	 * @public
	 */
	ContentSwitcher.prototype.switchContent = function() {
		this.setActiveContent(this.getActiveContent() == 1 ? 2 : 1);
		return this;
	};
	
	////////////////////////////////////////// onEvent Methods /////////////////////////////////////////
	
	ContentSwitcher.prototype.onAfterRendering = function() {
		this._$Contents = [
			this.$("content1"),
			this.$("content2")
		];
	};
	
	
	////////////////////////////////////////// Private Methods /////////////////////////////////////////
	
	/**
	 * Make the content-area with the given number appear/visible. This just sets the CSS-class
	 * sapUiUnifiedCSwitcherVisible
	 */
	ContentSwitcher.prototype._showActiveContent = function(iNumber) {
		this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible", iNumber === 1);
		this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible", iNumber === 2);
	};
	
	///////////////////////////////////////// Hidden Functions /////////////////////////////////////////
	
	
	//////////////////////////////////////// Overridden Methods ////////////////////////////////////////
	
	    ///////////////////////////////// Property "activeContent" /////////////////////////////////
	
	ContentSwitcher.prototype.setActiveContent = function(iNumber) {
		iNumber = parseInt(iNumber, 10);
		
		if (isNaN(iNumber) || iNumber < 1) {
			iNumber = 1;
			
			jQuery.sap.log.warning(
				"setActiveContent argument must be either 1 or 2. Active content set to 1."
			);
		} else if (iNumber > 2) {
			iNumber = 2;
			
			jQuery.sap.log.warning(
				"setActiveContent argument must be either 1 or 2. Active content set to 2."
			);
		}
		
		this.setProperty("activeContent", iNumber, /* supressInvalidate: */ true);
		
		this._showActiveContent(iNumber);
		
		return this;
	};
	
	
	    /////////////////////////////////// Property "animation" ///////////////////////////////////
	
	ContentSwitcher.prototype.setAnimation = function(sAnimation, bSuppressInvalidate){
		if (typeof (sAnimation) !== "string") {
			sAnimation = sap.ui.unified.ContentSwitcherAnimation.None;
			jQuery.sap.log.warning(
				"setAnimation argument must be a string. Animation was set to \"" +
				sap.ui.unified.ContentSwitcherAnimation.None + "\"."
			);
		}
		
		// Remove all non-alphanumerical characters from the animation string
		sAnimation = sAnimation.replace(/[^a-zA-Z0-9]/g, "");
		
		var sCurrentAnimation = this.getProperty("animation");
		
		if (sAnimation === sCurrentAnimation) {
			// No change.
			return;
		}
		
		var $Dom = this.$();
		if ($Dom[0]) {
			// We are already rendered - so we have to change the class on the fly...
			$Dom.toggleClass("sapUiUfdCSwitcherAnimation" + sCurrentAnimation, false);
			$Dom.toggleClass("sapUiUfdCSwitcherAnimation" + sAnimation, true);
		}/* else {
			// The renderer will take care of it.
		}/**/
	
		this.setProperty("animation", sAnimation, bSuppressInvalidate);
		
		return this;
	};
	
	
	    //////////////////////////////////////// Event "xxx" ///////////////////////////////////////
	    ///////////////////////////////////// Aggregation "xxx" ////////////////////////////////////
	    ///////////////////////////////////// Association "xxx" ////////////////////////////////////
	
	})(window);

	return ContentSwitcher;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ContentSwitcher.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Currency') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.Currency.
jQuery.sap.declare('sap.ui.unified.Currency'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.LocaleData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.format.NumberFormat'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/Currency",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/LocaleData', 'sap/ui/core/format/NumberFormat', './library'],
	function(jQuery, Control, LocaleData, NumberFormat, library) {
	"use strict";


	
	/**
	 * Constructor for a new Currency.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A text view which displays currency values and aligns them at the separator
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.21.1
	 * @alias sap.ui.unified.Currency
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Currency = Control.extend("sap.ui.unified.Currency", /** @lends sap.ui.unified.Currency.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * The currency value
			 */
			value : {type : "float", group : "Appearance", defaultValue : 0},
	
			/**
			 * The ISO 4217 currency code
			 */
			currency : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * Defines the space that is available for the precision of the various currencies.
			 */
			maxPrecision : {type : "int", group : "Appearance", defaultValue : 3},
	
			/**
			 * Show the currency symbol instead of the ISO currency code
			 */
			useSymbol : {type : "boolean", group : "Appearance", defaultValue : true}
		}
	}});
	
	
	
	
	
	
	
	
	//Whitespace characters to align values
	Currency.FIGURE_SPACE = '\u2007';
	Currency.PUNCTUATION_SPACE = '\u2008';
	
	Currency.prototype.init = function() {
		this._oFormat = NumberFormat.getCurrencyInstance({
			showMeasure: false
		});
	};
	

	/**
	 * The formatted value
	 *
	 * @type string
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Currency.prototype.getFormattedValue = function() {
		if (this.getCurrency() === "*") {
			return "";
		}
	
		var iPadding = this.getMaxPrecision() - this._oFormat.oLocaleData.getCurrencyDigits(this.getCurrency());
		var sValue = this._oFormat.format(this.getValue(), this.getCurrency());
		
		if (iPadding == this.getMaxPrecision() && this.getMaxPrecision() > 0) {
			sValue += Currency.PUNCTUATION_SPACE;
		}
	
		// create spaces
		if (iPadding > 0) {
			sValue = jQuery.sap.padRight(sValue, Currency.FIGURE_SPACE, sValue.length + iPadding);
		} else if (iPadding < 0) {
			sValue = sValue.substr(0, sValue.length + iPadding);
		}
		
		return sValue;
	};
	

	/**
	 * Get symbol of the currency, if available
	 *
	 * @type string
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Currency.prototype.getCurrencySymbol = function() {
		return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());
	};
	
	Currency.prototype.setValue = function(sValue) {
		// force the invalidation if the value should be displayed
		// to re-render the control finally
		var bHasValue = this._hasValue(),
		    bHasNoValueClass = this.$().hasClass("sapUiUfdCurrencyNoVal");
		if (bHasValue === bHasNoValueClass) {
			this.invalidate();
		}
		this.setProperty("value", sValue);
		return this;
	};
	
	/**
	 * Checks if the binding has a proper value or the value is undefined. In case of 
	 * undefined value the Currency control will not display any value! This workaround
	 * is necessary because of the default value 0 suppresses to set a undefined or null value
	 * instead and this cannot be changed due to compatibility.
	 * @private
	 */
	Currency.prototype._hasValue = function() {
		var oValueBinding = this.getBinding("value"),
		    bHasBinding = oValueBinding !== undefined,
		    bHasValue = bHasBinding ? oValueBinding.getValue() !== undefined : true /* no databinding => always true */;
		return bHasValue;
	};
	

	return Currency;

}, /* bExport= */ true);

}; // end of sap/ui/unified/Currency.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.DateRange') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides control sap.ui.unified.DateRange.
jQuery.sap.declare('sap.ui.unified.DateRange'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/DateRange",['jquery.sap.global', 'sap/ui/core/Element', './library'],
		function(jQuery, Element, library) {
	"use strict";



	/**
	 * Constructor for a new DateRange.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Date range for use in DatePicker
	 * @extends sap.ui.core.Element
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.22.0
	 * @alias sap.ui.unified.DateRange
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var DateRange = Element.extend("sap.ui.unified.DateRange", /** @lends sap.ui.unified.DateRange.prototype */ { metadata : {

		library : "sap.ui.unified",
		properties : {

			/**
			 * Start date for a date range. This must be a JavaScript date object.
			 */
			startDate : {type : "object", group : "Misc", defaultValue : null},

			/**
			 * Start date for a date range. If empty only a single date is presented by this DateRange element. This must be a JavaScript date object.
			 */
			endDate : {type : "object", group : "Misc", defaultValue : null}
		}
	}});

	///**
	// * This file defines behavior for the control,
	// */

	DateRange.prototype.setStartDate = function(oDate){

		if (oDate) {
			if (!(oDate instanceof Date)) {
				throw new Error("Date must be a JavaScript date object; " + this);
			}

			var iYear = oDate.getFullYear();
			if (iYear < 1 || iYear > 9999) {
				throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); " + this);
			}
		}

		this.setProperty("startDate", oDate);

	};

	DateRange.prototype.setEndDate = function(oDate){

		if (oDate) {
			if (!(oDate instanceof Date)) {
				throw new Error("Date must be a JavaScript date object; " + this);
			}

			var iYear = oDate.getFullYear();
			if (iYear < 1 || iYear > 9999) {
				throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); " + this);
			}
		}

		this.setProperty("endDate", oDate);

	};

	return DateRange;

}, /* bExport= */ true);

}; // end of sap/ui/unified/DateRange.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.DateTypeRange') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.DateTypeRange.
jQuery.sap.declare('sap.ui.unified.DateTypeRange'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/DateTypeRange",['jquery.sap.global', './DateRange', './library'],
	function(jQuery, DateRange, library) {
	"use strict";


	
	/**
	 * Constructor for a new DateTypeRange.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Date range with calendar day type information. Used to visualize special days in the Calendar.
	 * @extends sap.ui.unified.DateRange
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.24.0
	 * @alias sap.ui.unified.DateTypeRange
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var DateTypeRange = DateRange.extend("sap.ui.unified.DateTypeRange", /** @lends sap.ui.unified.DateTypeRange.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * Type of the dayte range.
			 */
			type : {type : "sap.ui.unified.CalendarDayType", group : "Appearance", defaultValue : null}
		}
	}});
	
	///**
	// * This file defines behavior for the control,
	// */
	//sap.ui.unified.DateTypeRange.prototype.init = function(){
	//   // do something for initialization...
	//};
	

	return DateTypeRange;

}, /* bExport= */ true);

}; // end of sap/ui/unified/DateTypeRange.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.FileUploader') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.FileUploader.
jQuery.sap.declare('sap.ui.unified.FileUploader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/FileUploader",['jquery.sap.global', 'sap/ui/core/Control', './library'],
	function(jQuery, Control, library) {
	"use strict";



	/**
	 * Constructor for a new FileUploader.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The framework generates an input field and a button with text "Browse ...". The API supports features such as on change uploads (the upload starts immediately after a file has been selected), file uploads with explicit calls, adjustable control sizes, text display after uploads, or tooltips containing complete file paths.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.FileUploader
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FileUploader = Control.extend("sap.ui.unified.FileUploader", /** @lends sap.ui.unified.FileUploader.prototype */ { metadata : {

		library : "sap.ui.unified",
		properties : {

			/**
			 * Value of the path for file upload.
			 */
			value : {type : "string", group : "Data", defaultValue : ''},

			/**
			 * Disabled controls have different colors, depending on customer settings.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Used when URL address is on a remote server.
			 */
			uploadUrl : {type : "sap.ui.core.URI", group : "Data", defaultValue : ''},

			/**
			 * Unique control name for identification on the server side after sending data to the server.
			 */
			name : {type : "string", group : "Data", defaultValue : null},

			/**
			 * Specifies the displayed control width.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : ''},

			/**
			 * If set to "true", the upload immediately starts after file selection. With the default setting, the upload needs to be explicitly triggered.
			 */
			uploadOnChange : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Additional data that is sent to the back end service. Data will be transmitted as value of a hidden input where the name is derived from the name property with suffix -data.
			 */
			additionalData : {type : "string", group : "Data", defaultValue : null},

			/**
			 * If the FileUploader is configured to upload the file directly after the file is selected it is not allowed to upload a file with the same name again. If a user should be allowed to upload a file with the same name again this parameter has to be "true". A typical use case would be if the files have different paths.
			 */
			sameFilenameAllowed : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * The Button text can be overwritten using this property.
			 */
			buttonText : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The chosen files will be checked against an array of file types. If at least one file does not fit the file type restriction the upload is prevented.
			 * Example: ["jpg", "png", "bmp"].
			 */
			fileType : {type : "string[]", group : "Data", defaultValue : null},

			/**
			 * Allows multiple files to be chosen and uploaded from the same folder. This property is not supported by Internet Explorer 8 and 9.
			 */
			multiple : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * A file size limit in megabytes which prevents the upload if at least one file exceeds it. This property is not supported by Internet Explorer 8 and 9.
			 */
			maximumFileSize : {type : "float", group : "Data", defaultValue : null},

			/**
			 * The chosen files will be checked against an array of mime types. If at least one file does not fit the mime type restriction the upload is prevented. This property is not supported by Internet Explorer 8 and 9.
			 * Example: mimeType ["image/png", "image/jpeg"].
			 */
			mimeType : {type : "string[]", group : "Data", defaultValue : null},

			/**
			 * If set to "true", the request will be sent as XHR request instead of a form submit. This property is not supported by Internet Explorer 8 and 9.
			 */
			sendXHR : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Placeholder for the text field.
			 */
			placeholder : {type : "string", group : "Appearance", defaultValue : null},

			/**
			 * Style of the button. "Transparent, "Accept", "Reject", or "Emphasized" is allowed.
			 */
			style : {type : "string", group : "Appearance", defaultValue : null},

			/**
			 * If set to "true", the FileUploader will be rendered as Button only, without showing the InputField.
			 */
			buttonOnly : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * If set to "false", the request will be sent as file only request instead of a multipart/form-data request. Only one file could be uploaded using this type of request. Required for sending such a request is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.
			 */
			useMultipart : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * The maximum length of a filename which the FileUploader will accept. If the maximum filename length is exceeded, the corresponding Event 'filenameLengthExceed' is fired.
			 * @since 1.24.0
			 */
			maximumFilenameLength : {type : "int", group : "Data", defaultValue : null},

			/**
			 * Visualizes warnings or errors related to the text field. Possible values: Warning, Error, Success, None.
			 * @since 1.24.0
			 */
			valueState : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},

			/**
			 * Icon to be displayed as graphical element within the button.
			 * This can be an URI to an image or an icon font URI.
			 * @since 1.26.0
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},

			/**
			 * Icon to be displayed as graphical element within the button when it is hovered (only if also a base icon was specified). If not specified the base icon is used.
			 * If a icon font icon is used, this property is ignored.
			 * @since 1.26.0
			 */
			iconHovered : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},

			/**
			 * Icon to be displayed as graphical element within the button when it is selected (only if also a base icon was specified). If not specified the base or hovered icon is used.
			 * If a icon font icon is used, this property is ignored.
			 * @since 1.26.0
			 */
			iconSelected : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},

			/**
			 * If set to true (default), the display sequence is 1. icon 2. control text.
			 * @since 1.26.0
			 */
			iconFirst : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * If set to true, the button is displayed without any text.
			 * @since 1.26.0
			 */
			iconOnly : {type : "boolean", group : "Appearance", defaultValue : false}
		},
		aggregations : {

			/**
			 * The parameters for the FileUploader which are rendered as a hidden inputfield.
			 * @since 1.12.2
			 */
			parameters : {type : "sap.ui.unified.FileUploaderParameter", multiple : true, singularName : "parameter"},

			/**
			 * The header parameters for the FileUploader which are only submitted with XHR requests. Header parameters are not supported by Internet Explorer 8 and 9.
			 */
			headerParameters : {type : "sap.ui.unified.FileUploaderParameter", multiple : true, singularName : "headerParameter"}
		},
		events : {

			/**
			 * Event is fired when the value of the file path has been changed.
			 */
			change : {
				parameters : {

					/**
					 * New file path value.
					 */
					newValue : {type : "string"},

					/**
					 * Files.
					 */
					files : {type : "object[]"}
				}
			},

			/**
			 * Event is fired as soon as the upload request is completed (either successful or unsuccessful). To see if the upload request was successful, check the 'state' parameter for a value 2xx.
			 * The uploads actual progress can be retrieved via the 'uploadProgress' Event.
			 * However this covers only the client side of the Upload process and does not give any success status from the server.
			 */
			uploadComplete : {
				parameters : {

					/**
					 * The name of a file to be uploaded.
					 */
					fileName : {type : "string"},

					/**
					 * Response message which comes from the server. On the server side this response has to be put within the &quot;body&quot; tags of the response document of the iFrame. It can consist of a return code and an optional message. This does not work in cross-domain scenarios.
					 */
					response : {type : "string"},

					/**
					 * ReadyState of the XHR request. Required for receiving a readyState is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.
					 */
					readyStateXHR : {type : "string"},

					/**
					 * Status of the XHR request. Required for receiving a status is to set the property "sendXHR" to "true". This property is not supported by Internet Explorer 8 and 9.
					 */
					status : {type : "string"},

					/**
					 * Http-Response which comes from the server. Required for receiving "responseRaw" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.
					 */
					responseRaw : {type : "string"},

					/**
					 * Http-Response-Headers which come from the server. provided as a JSON-map, i.e. each header-field is reflected by a property in the header-object, with the property value reflecting the header-field's content. Required for receiving "header" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.
					 */
					headers : {type : "object"},

					/**
					 * Http-Request-Headers. Required for receiving "header" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.
					 */
					requestHeaders : {type : "object[]"}
				}
			},

			/**
			 * Event is fired when the type of a file does not match the mimeType or fileType property.
			 */
			typeMissmatch : {
				parameters : {

					/**
					 * The name of a file to be uploaded.
					 */
					fileName : {type : "string"},

					/**
					 * The file ending of a file to be uploaded.
					 */
					fileType : {type : "string"},

					/**
					 * The MIME type of a file to be uploaded.
					 */
					mimeType : {type : "string"}
				}
			},

			/**
			 * Event is fired when the size of a file is above the maximumFileSize property. This event is not supported by Internet Explorer 8 and 9 (same restriction as for the property maximumFileSize).
			 */
			fileSizeExceed : {
				parameters : {

					/**
					 * The name of a file to be uploaded.
					 */
					fileName : {type : "string"},

					/**
					 * The size in MB of a file to be uploaded.
					 */
					fileSize : {type : "string"}
				}
			},

			/**
			 * Event is fired when the file is allowed for upload on client side.
			 */
			fileAllowed : {},

			/**
			 * Event is fired after the upload has started and before the upload is completed and contains progress information related to the running upload. Depending on file size, band width and used browser the event is fired once or multiple times.
			 * This is event is only supported with property sendXHR set to true, i.e. the event is not supported in Internet Explorer 8 or 9.
			 * @since 1.24.0
			 */
			uploadProgress : {
				parameters : {

					/**
					 * Indicates whether or not the relative upload progress can be calculated out of loaded and total.
					 */
					lengthComputable : {type : "boolean"},

					/**
					 * The number of bytes of the file which have been uploaded by to the time the event was fired.
					 */
					loaded : {type : "float"},

					/**
					 * The total size of the file to be uploaded in byte.
					 */
					total : {type : "float"},

					/**
					 * The name of a file to be uploaded.
					 */
					fileName : {type : "string"},

					/**
					 * Http-Request-Headers. Required for receiving "header" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.
					 */
					requestHeaders : {type : "object[]"}
				}
			},

			/**
			 * Event is fired after the current upload has been aborted.
			 * This is event is only supported with property sendXHR set to true, i.e. the event is not supported in Internet Explorer 8 or 9.
			 * @since 1.24.0
			 */
			uploadAborted : {
				parameters : {

					/**
					 * The name of a file to be uploaded.
					 */
					fileName : {type : "string"},

					/**
					 * Http-Request-Headers. Required for receiving "header" is to set the property "sendXHR" to true. This property is not supported by Internet Explorer 8 and 9.
					 */
					requestHeaders : {type : "object[]"}
				}
			},

			/**
			 * Event is fired, if the filename of a chosen file is longer than the value specified with the maximumFilenameLength property.
			 * @since 1.24.0
			 */
			filenameLengthExceed : {
				parameters : {

					/**
					 * The filename, which is longer than specified by the value of the property maximumFilenameLength.
					 */
					fileName : {type : "string"}
				}
			}
		}
	}});


	/**
	 * Initializes the control.
	 * It is called from the constructor.
	 * @private
	 */
	FileUploader.prototype.init = function(){

		// Instantiate browser-specific UI-Elements (IE8 only):
		// works fine with applySettings() after init() - most things are done in onAfterRendering
		// IE8 should render a native file uploader and the SAPUI5 controls should be exactly behind
		if (!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8) {
			this.oFilePath = new sap.ui.commons.TextField(this.getId() + "-fu_input",
														{width: "225px"});

			this.oBrowse = new sap.ui.commons.Button({enabled : this.getEnabled(),
				text: "Browse..",
				width: "0px",
				height: "0px"});
		} else {
			//all other browsers will load the respective UI-Elements from the FileUploaderHelper
			this.oFilePath = sap.ui.unified.FileUploaderHelper.createTextField(this.getId() + "-fu_input");
			this.oBrowse = sap.ui.unified.FileUploaderHelper.createButton();
		}
		this.oFilePath.setParent(this);
		this.oBrowse.setParent(this);

		this.oFileUpload = null;

		// check if sap.m library is used
		this.bMobileLib = this.oBrowse.getMetadata().getName() == "sap.m.Button";

		//retrieving the default browse button text from the resource bundle
		if (!this.getIconOnly()) {
			this.oBrowse.setText(this.getBrowseText());
		}
	};

	FileUploader.prototype.setButtonText = function(sText) {
		if (!this.getIconOnly()) {
			this.oBrowse.setText(sText || this.getBrowseText());
			this.setProperty("buttonText", sText, false);
			return this;
		}
	};

	FileUploader.prototype.setIcon = function(sIcon) {
		this.oBrowse.setIcon(sIcon);
		this.setProperty("icon", sIcon, false);
		return this;
	};

	FileUploader.prototype.setIconHovered = function(sIconHovered) {
		this.setProperty("iconHovered", sIconHovered, false);
		if (this.oBrowse.setIconHovered) {
			this.oBrowse.setIconHovered(sIconHovered);
		}
		return this;
	};

	FileUploader.prototype.setIconSelected = function(sIconSelected) {
		this.setProperty("iconSelected", sIconSelected, false);
		if (this.oBrowse.setIconSelected) {
			this.oBrowse.setIconSelected(sIconSelected);
		} else {
			this.oBrowse.setActiveIcon(sIconSelected);
		}
		return this;
	};

	FileUploader.prototype.setIconFirst = function(bIconFirst) {
		this.oBrowse.setIconFirst(bIconFirst);
		this.setProperty("iconFirst", bIconFirst, false);
		return this;
	};

	FileUploader.prototype.setIconOnly = function(bIconOnly) {
		this.oBrowse.setText("");
		this.setProperty("iconOnly", bIconOnly, false);
		return this;
	};

	FileUploader.prototype.getIdForLabel = function () {
		return this.oBrowse.getId();
	};

	FileUploader.prototype.setFileType = function(vTypes) {
		// Compatibility issue: converting the given types to an array in case it is a string
		var aTypes = this._convertTypesToArray(vTypes);
		this.setProperty("fileType", aTypes, false);
		return this;
	};

	FileUploader.prototype.setMimeType = function(vTypes) {
		// Compatibility issue: converting the given types to an array in case it is a string
		var aTypes = this._convertTypesToArray(vTypes);
		this.setProperty("mimeType", aTypes, false);
		return this;
	};

	/**
	 * Helper to ensure, that the types (file or mime) are inside an array.
	 * The FUP also accepts comma-separated strings for its fileType and mimeType property.
	 * @private
	 */
	FileUploader.prototype._convertTypesToArray = function (vTypes) {
		if (typeof vTypes === "string") {
			if (vTypes === "") {
				return [];
			} else {
				return vTypes.split(",");
			}
		}
		return vTypes;
	};

	/**
	 * Terminates the control when it has been destroyed.
	 * @private
	 */
	FileUploader.prototype.exit = function(){

		// destroy the nested controls
		this.oFilePath.destroy();
		this.oBrowse.destroy();

		// remove the IFRAME
		if (this.oIFrameRef) {
			jQuery(this.oIFrameRef).unbind();
			sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);
			this.oIFrameRef = null;
		}

	};

	/**
	 * Clean up event listeners before rendering
	 * @private
	 */
	FileUploader.prototype.onBeforeRendering = function() {

		// store the file uploader outside in the static area
		var oStaticArea = sap.ui.getCore().getStaticAreaRef();
		jQuery(this.oFileUpload).appendTo(oStaticArea);

		// unbind the custom event handlers in case of IE8
		jQuery(this.oFileUpload).unbind();

	};

	/**
	 * Prepare the upload processing, establish the change handler for the
	 * pure html input object.
	 * @private
	 */
	FileUploader.prototype.onAfterRendering = function() {

		// prepare the file upload control and the upload iframe
		this.prepareFileUploadAndIFrame();

		// event listener registration for change event in IE8 because the change
		// event is not bubbling for IE8 => so we do this for all browsers!
		jQuery(this.oFileUpload).change(jQuery.proxy(this.handlechange, this));

		// IE8 should render a native file uploader and don't need the witdh calculation
		if ((!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 8)) {
			this.oBrowse.getDomRef().style.padding = "0px";
			this.oBrowse.getDomRef().style.visibility = "hidden";
			this.oFilePath.getDomRef().style.height = "20px";
			this.oFilePath.getDomRef().style.visibility = "hidden";
			jQuery(this.oFilePath.getDomRef()).removeClass('sapUiTfBrd');
		} else {
			if (!this.bMobileLib) {
				this.oFilePath.$().attr("tabindex", "-1");
			} else {
				this.oFilePath.$().find('input').attr("tabindex", "-1");
			}
			// in case of IE9 we prevent the browse button from being focused because the
			// native file uploader requires the focus for catching the keyboard events
			if ((!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 9)) {
				this.oBrowse.$().attr("tabindex", "-1");
			}
			jQuery.sap.delayedCall(0, this, this._recalculateWidth);
		}

	};

	FileUploader.prototype._recalculateWidth = function() {
		// calculation of the width of the overlay for the original file upload
		// !!!sap.ui.Device.browser.internet_explorer check: only for non IE browsers since there we need
		// the button in front of the fileuploader
		if (this.getWidth()) {
			if (this.getButtonOnly()) {
				this.oBrowse.getDomRef().style.width = this.getWidth();
			} else {
				// Recalculate the textfield width...
				this._resizeDomElements();
			}
		}
	};

	/**
	 * Returns the DOM element that should be focused when focus is set onto the control.
	 */
	FileUploader.prototype.getFocusDomRef = function() {
		return this.$("fu").get(0);
	};

	FileUploader.prototype._resizeDomElements = function() {
		var sId = this.getId();
		this._oBrowseDomRef = this.oBrowse.getDomRef();
		var $b = jQuery(this._oBrowseDomRef);
		var _buttonWidth = $b.parent().outerWidth(true);
		this._oFilePathDomRef = this.oFilePath.getDomRef();
		var oDomRef = this._oFilePathDomRef;
		var sWidth = this.getWidth();

		if (sWidth.substr( -1) == "%") {
			// Special case - if the width is not in px, we only change the top element

			// Resize all elements from the input field up to the control element itself.
			while (oDomRef.id != sId) {
				oDomRef.style.width = "100%";
				oDomRef = oDomRef.parentNode;
			}

			oDomRef.style.width = sWidth;
		} else {
			oDomRef.style.width = sWidth;

			// Now make sure the field including the button has the correct size
			var $fp = jQuery(this._oFilePathDomRef);
			var _newWidth = $fp.outerWidth() - _buttonWidth;
			if (_newWidth < 0) {
				this.oFilePath.getDomRef().style.width = "0px";
				if (!!!sap.ui.Device.browser.internet_explorer) {
					this.oFileUpload.style.width = $b.outerWidth(true);
				}
			} else {
				this.oFilePath.getDomRef().style.width = _newWidth + "px";
			}
		}
	};

	FileUploader.prototype.onresize = function() {
		this._recalculateWidth();
	};

	FileUploader.prototype.onThemeChanged = function() {
		this._recalculateWidth();
	};

	FileUploader.prototype.setEnabled = function(bEnabled){
		this.setProperty("enabled", bEnabled, true);
		this.oFilePath.setEnabled(bEnabled);
		this.oBrowse.setEnabled(bEnabled);
		if (bEnabled) {
			this.$("fu").removeAttr('disabled');
		} else {
			this.$("fu").attr('disabled', 'disabled');
		}
		return this;
	};

	FileUploader.prototype.setValueState = function(sValueState) {
		this.setProperty("valueState", sValueState);
		//as of 1.23.1 oFilePath can be a sap.ui.commons.TextField or a sap.m.Input, which both have a valueState
		if (this.oFilePath.setValueState) {
			this.oFilePath.setValueState(sValueState);
		}
		return this;
	};

	FileUploader.prototype.setUploadUrl = function(sValue, bFireEvent) {
		this.setProperty("uploadUrl", sValue, true);
		var $uploadForm = this.$("fu_form");
		$uploadForm.attr("action", this.getUploadUrl());
		return this;
	};

	FileUploader.prototype.setPlaceholder = function(sPlaceholder) {
		this.setProperty("placeholder", sPlaceholder, true);
		this.oFilePath.setPlaceholder(sPlaceholder);
		return this;
	};

	FileUploader.prototype.setStyle = function(sStyle) {
		this.setProperty("style", sStyle, true);
		if (sStyle == "Transparent") {
			if (this.oBrowse.setLite) {
				this.oBrowse.setLite(true);
			} else {
				this.oBrowse.setType("Transparent");
			}
		} else {
			if (this.oBrowse.setType) {
				this.oBrowse.setType(sStyle);
			} else {
				if (sStyle == "Emphasized") {
					sStyle = "Emph";
				}
				this.oBrowse.setStyle(sStyle);
			}
		}
		return this;
	};

	FileUploader.prototype.setValue = function(sValue, bFireEvent, bSupressFocus) {
		var oldValue = this.getValue();
		if ((oldValue != sValue) || this.getSameFilenameAllowed()) {
			// only upload when a valid value is set
			var bUpload = this.getUploadOnChange() && sValue;
			// when we do not upload we re-render (cause some browsers don't like
			// to change the value of file uploader INPUT elements)
			this.setProperty("value", sValue, bUpload);
			if (this.oFilePath) {
				this.oFilePath.setValue(sValue);
				//refocus the filepath input field, except in IE8 or if bSupressFocus is set
				if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8) && this.oFilePath.getFocusDomRef() && !bSupressFocus) {
					this.oFilePath.getFocusDomRef().focus();
				}
			}
			var oForm = this.getDomRef("fu_form"),
				sapMInnerInput = this.getDomRef("fu_input-inner");
			//reseting the input fields if setValue("") is called, also for undefined and null
			if (this.oFileUpload && /* is visible: */ oForm && !sValue) {
				// some browsers do not allow to clear the value of the fileuploader control
				// therefore we utilize the form and reset the values inside this form and
				// apply the additionalData again afterwards
				oForm.reset();
				this.getDomRef("fu_input").value = "";
				//if the sap.m library is used, we also need to clear the inner input-field of sap.m.Input
				if (sapMInnerInput) {
					sapMInnerInput.value = "";
				}
				//keep the additional data on the form
				this.$("fu_data").val(this.getAdditionalData());
			}
			// only fire event when triggered by user interaction
			if (bFireEvent) {
				if (window.File) {
					var oFiles = jQuery.sap.domById(this.getId() + "-fu").files;
				}
				this.fireChange({id:this.getId(), newValue:sValue, files:oFiles});
			}
			if (bUpload) {
				this.upload();
			}
		}
		return this;
	};


	/**
	 * Clears the content of the FileUploader. The attached additional data however is retained.
	 *
	 * @type void
	 * @public
	 * @since 1.25.0
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	FileUploader.prototype.clear = function () {
		//clear the value, don't fire change event, and supress the refocusing of the file input field
		return this.setValue("", false, true);
	};

	FileUploader.prototype.onmousedown = function(oEvent) {
		if (!this.bMobileLib) {
			this.oBrowse.onmousedown(oEvent);
		}
	};

	FileUploader.prototype.onmouseup = function(oEvent) {
		if (!this.bMobileLib) {
			this.oBrowse.onmouseup(oEvent);
		}
	};

	FileUploader.prototype.onmouseover = function (oEvent) {
		if (!this.bMobileLib) {
			jQuery(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover');
			this.oBrowse.onmouseover(oEvent);
		}
	};

	FileUploader.prototype.onmouseout = function (oEvent) {
		if (!this.bMobileLib) {
			jQuery(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover');
			this.oBrowse.onmouseout(oEvent);
		}
	};

	FileUploader.prototype.onfocusin = function () {
		if (!this.bMobileLib) {
			jQuery(this.oBrowse.getDomRef()).addClass('sapUiBtnStdFocus').attr("tabindex", "-1");
			jQuery(this.oFilePath.getDomRef()).removeClass('sapUiTfFoc');
			this.focus();
		}
	};

	FileUploader.prototype.onfocusout = function () {
		if (!this.bMobileLib) {
			jQuery(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdFocus').attr("tabindex", "0");
		}
	};

	FileUploader.prototype.setAdditionalData = function(sAdditionalData) {
		// set the additional data in the hidden input
		this.setProperty("additionalData", sAdditionalData, true);
		var oAdditionalData = this.getDomRef("fu_data");
		if (oAdditionalData) {
			var sAdditionalData = this.getAdditionalData() || "";
			oAdditionalData.value = sAdditionalData;
		}
		return this;
	};


	/**
	 * Starts the upload (as defined by uploadUrl)
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	FileUploader.prototype.upload = function() {
		//supress Upload if the FileUploader is not enabled
		if (!this.getEnabled()) {
			return;
		}
		var uploadForm = this.getDomRef("fu_form"),
			that = this;

		try {
			if (uploadForm) {
				this._bUploading = true;
				if (this.getSendXHR() && window.File) {
					var oFiles = jQuery.sap.domById(this.getId() + "-fu").files;
					if (oFiles.length > 0) {

						var oXhr;
						//keep a reference on the current upload xhr
						this._uploadXHR = new window.XMLHttpRequest();
						oXhr = {
								xhr: this._uploadXHR,
								requestHeaders: []
						};

						var sFilename = oFiles[0].name;

						if (sap.ui.Device.browser.internet_explorer) {
							var sContentType = oFiles[0].type;
							oXhr.xhr.setRequestHeader("Content-Type", sContentType);
							oXhr.requestHeaders.push({name: "Content-Type", value: sContentType});
						}

						var oRequestHeaders = oXhr.requestHeaders;

						var fnProgressListener = function(oProgressEvent) {
							var oProgressData = {
								lengthComputable: !!oProgressEvent.lengthComputable,
								loaded: oProgressEvent.loaded,
								total: oProgressEvent.total
							};
							that.fireUploadProgress({
								"lengthComputable": oProgressData.lengthComputable,
								"loaded": oProgressData.loaded,
								"total": oProgressData.total,
								"fileName": sFilename,
								"requestHeaders": oRequestHeaders
							});
						};

						var fnAbordListerner = function(oAbortEvent) {
							that.fireUploadAborted({
								"fileName": sFilename,
								"requestHeaders": oRequestHeaders
							});
						};

						oXhr.xhr.upload.addEventListener("progress", fnProgressListener);

						//relay the abort event, if the xhr was aborted manually
						oXhr.xhr.upload.addEventListener("abort",  fnAbordListerner);

						oXhr.xhr.open("POST", this.getUploadUrl(), true);
						if (this.getHeaderParameters()) {
							var oHeaderParams = this.getHeaderParameters();
							for (var i = 0; i < oHeaderParams.length; i++) {
								var sHeader = oHeaderParams[i].getName();
								var sValue = oHeaderParams[i].getValue();
								oXhr.xhr.setRequestHeader(sHeader, sValue);
								oXhr.requestHeaders.push({name: sHeader, value: sValue});
							}
						}
						if (this.getUseMultipart()) {
							var formData = new window.FormData();
							var name = jQuery.sap.domById(this.getId() + "-fu").name;
							for (var i = 0; i < oFiles.length; i++) {
								formData.append(name, oFiles[i]);
							}
							formData.append("_charset_", "UTF-8");
							var data = jQuery.sap.domById(this.getId() + "-fu_data").name;
							if (this.getAdditionalData()) {
								var sData = this.getAdditionalData();
								formData.append(data, sData);
							} else {
								formData.append(data, "");
							}
							if (this.getParameters()) {
								var oParams = this.getParameters();
								for (var i = 0; i < oParams.length; i++) {
									var sName = oParams[i].getName();
									var sValue = oParams[i].getValue();
									formData.append(sName, sValue);
								}
							}
							oXhr.xhr.send(formData);
						} else {
							oXhr.xhr.send(oFiles[0]);
						}

						oXhr.xhr.onreadystatechange = function() {
							var sResponse;
							var sResponseRaw;
							var mHeaders = {};
							var sPlainHeader;
							var aHeaderLines;
							var iHeaderIdx;
							var sReadyState = oXhr.xhr.readyState;
							var sStatus = oXhr.xhr.status;
							if (oXhr.xhr.readyState == 4) {
								//this check is needed, because (according to the xhr spec) the readyState is set to OPEN (4)
								//as soon as the xhr is aborted. Only after the progress events are fired, the state is set to UNSENT (0)
								if (oXhr.xhr.responseXML) {
									sResponse = oXhr.xhr.responseXML.documentElement.textContent;
								}
								sResponseRaw = oXhr.xhr.response;

								//Parse the http-header into a map
								sPlainHeader = oXhr.xhr.getAllResponseHeaders();
								if (sPlainHeader) {
									aHeaderLines = sPlainHeader.split("\u000d\u000a");
									for (var i = 0; i < aHeaderLines.length; i++) {
										if (aHeaderLines[i]) {
											iHeaderIdx = aHeaderLines[i].indexOf("\u003a\u0020");
											mHeaders[aHeaderLines[i].substring(0, iHeaderIdx)] = aHeaderLines[i].substring(iHeaderIdx + 2);
										}
									}
								}
								that.fireUploadComplete({
									"fileName": sFilename,
									"headers": mHeaders,
									"response": sResponse,
									"responseRaw": sResponseRaw,
									"readyStateXHR": sReadyState,
									"status": sStatus,
									"requestHeaders": oRequestHeaders
								});
							}
							that._bUploading = false;
						};
						this._bUploading = false;
					}
				} else {
					uploadForm.submit();
				}
				jQuery.sap.log.info("File uploading to " + this.getUploadUrl());
				if (this.getSameFilenameAllowed() && this.getUploadOnChange()) {
					this.setValue("", true);
				}
			}
		} catch (oException) {
			jQuery.sap.log.error("File upload failed:\n" + oException.message);
		}
	};

	/**
	 * Aborts the currently running upload.
	 *
	 * @type void
	 * @public
	 * @since 1.24.0
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	FileUploader.prototype.abort = function() {
		if (this._uploadXHR && this._uploadXHR.abort) {
			//fires a progress event 'abort' on the _uploadXHR
			this._uploadXHR.abort();
		}
	};

	FileUploader.prototype.onkeypress = function(oEvent) {
		this.onkeydown(oEvent);
	};

	FileUploader.prototype.onclick = function(oEvent) {
		if (this.getSameFilenameAllowed()) {
			this.setValue("", true);
		}
	};

	//
	//Event Handling
	//
	FileUploader.prototype.onkeydown = function(oEvent) {
		if (!this.getEnabled()) {
			return;
		}
		if (this.getSameFilenameAllowed()) {
			this.setValue("", true);
		}
		var iKeyCode = oEvent.keyCode,
			eKC = jQuery.sap.KeyCodes;
		if (iKeyCode == eKC.DELETE || iKeyCode == eKC.BACKSPACE) {
			if (this.oFileUpload) {
				this.setValue("", true);
			}
		} else if (iKeyCode == eKC.SPACE || iKeyCode == eKC.ENTER) {
			// this does not work for IE9 and downwards! TODO: check with IE10/11
			// consider to always put the focus on the hidden file uploader
			// and let the fileuploader manager the keyboard interaction
			if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 9) && this.oFileUpload) {
				this.oFileUpload.click();
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		} else if (iKeyCode != eKC.TAB &&
					iKeyCode != eKC.SHIFT &&
					iKeyCode != eKC.F6) {
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * Helper function to check if the given filename is longer than the specified 'maximumFilenameLength'.
	 * @param {string} [sFilename] the filename which should be tested
	 * @param {boolean} [bFireEvent] if necessary, this flag triggers that a filenameLengthExceed event is fired 
	 * @returns {boolean} whether the filename is too long or not
	 * @private
	 */
	FileUploader.prototype._isFilenameTooLong = function (sFilename) {
		var iMaxFilenameLength = this.getMaximumFilenameLength();
		if (iMaxFilenameLength !== 0 && sFilename.length > iMaxFilenameLength) {
			jQuery.sap.log.info("The filename of " + sFilename + " (" + sFilename.length + " characters)  is longer than the maximum of " + iMaxFilenameLength + " characters.");
			return true;
		}

		return false;
	};

	FileUploader.prototype.handlechange = function(oEvent) {
		if (this.oFileUpload && this.getEnabled()) {

			var fMaxSize = this.getMaximumFileSize();

			var aFileTypes = this.getFileType();
			var aMimeTypes = this.getMimeType();

			var sFileString = '';

			if (window.File) {
				var oFiles = oEvent.target.files;

				for (var i = 0; i < oFiles.length; i++) {
					var sName = oFiles[i].name;
					var sType = oFiles[i].type;
					if (!sType) {
						sType = "unknown";
					}
					var fSize = ((oFiles[i].size / 1024) / 1024);
					if (fMaxSize && (fSize > fMaxSize)) {
						jQuery.sap.log.info("File: " + sName + " is of size " + fSize + " MB which exceeds the file size limit of " + fMaxSize + " MB.");
						this.fireFileSizeExceed({
							fileName:sName,
							fileSize:fSize
						});
						return;
					}
					//check if the filename is too long and fire the corresponding event if necessary
					if (this._isFilenameTooLong(sName)) {
						this.fireFilenameLengthExceed({
							fileName: sName
						});
						return;
					}
					//check allowed mime-types for potential mismatches
					if (aMimeTypes && aMimeTypes.length > 0) {
						var bWrongMime = true;
						for (var j = 0; j < aMimeTypes.length; j++) {
							if (sType.match(aMimeTypes[j])) {
								bWrongMime = false;
							}
						}
						if (bWrongMime) {
							jQuery.sap.log.info("File: " + sName + " is of type " + sType + ". Allowed types are: "  + aMimeTypes + ".");
							this.fireTypeMissmatch({
								fileName:sName,
								mimeType:sType
							});
							return;
						}
					}
					//check allowed file-types for potential mismatches
					if (aFileTypes && aFileTypes.length > 0) {
						var bWrongType = true;
						var iIdx = sName.lastIndexOf(".");
						var sFileEnding = sName.substring(iIdx + 1);
						for (var k = 0; k < aFileTypes.length; k++) {
							if (sFileEnding == aFileTypes[k]) {
								bWrongType = false;
							}
						}
						if (bWrongType) {
							jQuery.sap.log.info("File: " + sName + " is of type " + sFileEnding + ". Allowed types are: "  + aFileTypes + ".");
							this.fireTypeMissmatch({
								fileName:sName,
								fileType:sFileEnding
							});
							return;
						}
					}
					sFileString = sFileString + '"' + oFiles[i].name + '" ';
				}
				if (sFileString) {
					this.fireFileAllowed();
				}
			} else if (aFileTypes && aFileTypes.length > 0) {
				// This else case is executed if the File-API is not supported by the browser (especially IE8/9).
				// Check if allowed file types match the chosen file from the oFileUpload IFrame Workaround.
				var bWrongType = true;
				var sName = this.oFileUpload.value || "";
				var iIdx = sName.lastIndexOf(".");
				var sFileEnding = sName.substring(iIdx + 1);
				for (var k = 0; k < aFileTypes.length; k++) {
					if (sFileEnding == aFileTypes[k]) {
						bWrongType = false;
					}
				}
				if (bWrongType) {
					jQuery.sap.log.info("File: " + sName + " is of type " + sFileEnding + ". Allowed types are: "  + aFileTypes + ".");
					this.fireTypeMissmatch({
						fileName:sName,
						fileType:sFileEnding
					});
					return;
				}
				//check if the filename is too long and fire the corresponding event if necessary
				if (this._isFilenameTooLong(sName)) {
					this.fireFilenameLengthExceed({
						fileName: sName
					});
					return;
				}
				if (sName) {
					this.fireFileAllowed();
				}
			}

			// due to new security mechanism modern browsers simply
			// append a fakepath in front of the filename instead of
			// returning the filename only - we strip this path now
			var sValue = this.oFileUpload.value || "";
			var iIndex = sValue.lastIndexOf("\\");
			if (iIndex >= 0) {
				sValue = sValue.substring(iIndex + 1);
			}
			if (this.getMultiple()) {
				//multiple is not supported in IE <= 9
				if (!(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 9)) {
					sValue = sFileString;
				}
			}

			//sValue has to be filled to avoid clearing the FilePath by pressing cancel
			if (sValue || sap.ui.Device.browser.chrome) { // in Chrome the file path has to be cleared as the upload will be avoided
				this.setValue(sValue, true);
			}
		}
	};

	//
	// Private
	//

	/**
	 * Helper to retrieve the I18N texts for a button
	 * @private
	 */
	FileUploader.prototype.getBrowseText = function() {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
		var sText;
		if (rb) {
			sText = rb.getText("FILEUPLOAD_BROWSE");
		}
		return sText ? sText : "Browse...";
	};

	/**
	 * Getter for shortened value.
	 * @private
	 * @deprecated the value now is the short value (filename only)!
	 */
	FileUploader.prototype.getShortenValue = function() {
		return this.getValue();
	};

	/**
	 * Prepares the hidden IFrame for uploading the file (in static area).
	 * @private
	 */
	FileUploader.prototype.prepareFileUploadAndIFrame = function() {

		if (!this.oFileUpload) {

			// create the file uploader markup
			var aFileUpload = [];
			aFileUpload.push('<input ');
			aFileUpload.push('type="file" ');
			if (this.getName()) {
				if (this.getMultiple()) {
					//multiple is not supported in IE <= 9
					if (!(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 9)) {
						aFileUpload.push('name="' + this.getName() + '[]" ');
					}
				} else {
					aFileUpload.push('name="' + this.getName() + '" ');
				}
			} else {
				if (this.getMultiple()) {
					//multiple is not supported in IE <= 9
					if (!(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 9)) {
						aFileUpload.push('name="' + this.getId() + '[]" ');
					}
				} else {
					aFileUpload.push('name="' + this.getId() + '" ');
				}
			}
			aFileUpload.push('id="' + this.getId() + '-fu" ');
			if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8)) {
				// for IE9 the file uploader itself gets the focus to make sure that the
				// keyboard interaction works and there is no security issue - unfortunately
				// this has the negative side effect that 2 tabs are required.
				if (!(!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 9)) {
					aFileUpload.push('tabindex="-1" ');
				}
				aFileUpload.push('size="1" ');
			}
			if (this.getTooltip_AsString() ) {
				aFileUpload.push('title="' + jQuery.sap.escapeHTML(this.getTooltip_AsString()) + '" ');
			//} else if (this.getTooltip() ) {
				// object tooltip, do nothing - tooltip will be displayed
			} else if (this.getValue() != "") {
				// only if there is no tooltip, then set value as fallback
				aFileUpload.push('title="' + jQuery.sap.escapeHTML(this.getValue()) + '" ');
			}
			if (!this.getEnabled()) {
				aFileUpload.push('disabled="disabled" ');
			}
			if (this.getMultiple()) {
				//multiple is not supported in IE <= 9
				if (!(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 9)) {
					aFileUpload.push('multiple ');
				}
			}
			if (this.getMimeType() && window.File) {
				var aMimeTypes = this.getMimeType();
				var sMimeTypes = aMimeTypes.join(",");
				aFileUpload.push('accept="' + sMimeTypes + '" ');
			}
			aFileUpload.push('>');

			// add it into the control markup
			this.oFileUpload = jQuery(aFileUpload.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0);

		} else {

			// move the file uploader from the static area to the control markup
			jQuery(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"));

		}

		if (!this.oIFrameRef) {

			// create the upload iframe
			var oIFrameRef = document.createElement("iframe");
			oIFrameRef.style.display = "none";
			/*eslint-disable no-script-url */
			oIFrameRef.src = "javascript:''";
			/*eslint-enable no-script-url */
			oIFrameRef.id = this.sId + "-frame";
			sap.ui.getCore().getStaticAreaRef().appendChild(oIFrameRef);
			oIFrameRef.contentWindow.name = this.sId + "-frame";

			// sink the load event of the upload iframe
			var that = this;
			this._bUploading = false; // flag for uploading (because of IE8 to make sure that complete is only triggered after upload)
			jQuery(oIFrameRef).load(function(oEvent) {
				if (that._bUploading) {
					jQuery.sap.log.info("File uploaded to " + that.getUploadUrl());
					var sResponse;
					try {
						sResponse = that.oIFrameRef.contentDocument.body.innerHTML;
					} catch (ex) {
						// in case of cross-domain submit we get a permission denied exception
						// when we try to access the body of the IFrame document
					}
					that.fireUploadComplete({"response": sResponse});
					that._bUploading = false;
				}
			});

			// keep the reference
			this.oIFrameRef = oIFrameRef;

		}
	};


	return FileUploader;

}, /* bExport= */ true);

}; // end of sap/ui/unified/FileUploader.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.FileUploaderParameter') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.FileUploaderParameter.
jQuery.sap.declare('sap.ui.unified.FileUploaderParameter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/FileUploaderParameter",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element, library) {
	"use strict";


	
	/**
	 * Constructor for a new FileUploaderParameter.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Represents a parameter for the FileUploader which is rendered as a hidden inputfield.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.FileUploaderParameter
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FileUploaderParameter = Element.extend("sap.ui.unified.FileUploaderParameter", /** @lends sap.ui.unified.FileUploaderParameter.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * The name of the hidden inputfield.
			 * @since 1.12.2
			 */
			name : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * The value of the hidden inputfield.
			 * @since 1.12.2
			 */
			value : {type : "string", group : "Data", defaultValue : null}
		}
	}});
	
	

	return FileUploaderParameter;

}, /* bExport= */ true);

}; // end of sap/ui/unified/FileUploaderParameter.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuItemBase') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.MenuItemBase.
jQuery.sap.declare('sap.ui.unified.MenuItemBase'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/MenuItemBase",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element, library) {
	"use strict";


	
	/**
	 * Constructor for a new MenuItemBase.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Provides the standard properties for menu items.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.MenuItemBase
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MenuItemBase = Element.extend("sap.ui.unified.MenuItemBase", /** @lends sap.ui.unified.MenuItemBase.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * 
			 * Disabled items have different colors, depending on customer settings.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * 
			 * Invisible controls are not rendered.
			 */
			visible : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * 
			 * If set to true, a divider is displayed before the item
			 */
			startsSection : {type : "boolean", group : "Behavior", defaultValue : false}
		},
		defaultAggregation : "submenu",
		aggregations : {
	
			/**
			 * Aggregation of a menu item's sub menu.
			 */
			submenu : {type : "sap.ui.unified.Menu", multiple : false}
		},
		events : {
	
			/**
			 * Event is fired when an item is selected. The event is also available for items having a sub menu.
			 * A mouse click or space bar click on a sub menu item fires the event.
			 */
			select : {
				parameters : {
	
					/**
					 * Represents the current item
					 */
					item : {type : "sap.ui.unified.MenuItemBase"}
				}
			}
		}
	}});
	
	MenuItemBase.prototype.init = function(){
	   // do something for initialization...
	};
	
	/**
	 * @param {object} oRenderManager
	 * @param {object} oItem
	 * @param {object} oMenu
	 * @protected
	 */
	MenuItemBase.prototype.render = function(oRenderManager, oItem, oMenu){
		// Subclasses have to override this: Called when the item is rendered
		var rm = oRenderManager;
		rm.write("<li");
		rm.writeElementData(oItem);
		rm.write("><div style=\"white-space:nowrap;display:inline-block;padding:1px;color:black;\" id=\"" + this.getId() + "-txt\">");
		rm.write(oItem.getId());
		if (this.getSubmenu()) {
			rm.write("&nbsp;&nbsp;->");
		}
		rm.write("</div></li>");
	};
	
	/** 
	 * @param {boolean} bHovered
	 * @param {object} oMenu
	 * @protected
	 */
	MenuItemBase.prototype.hover = function(bHovered, oMenu){
		// Subclasses have to override this: Called when the item is hovered
		this.$("txt").attr("style", bHovered ? "white-space:nowrap;display:inline-block;padding:1px;color:red;" : "white-space:nowrap;display:inline-block;padding:1px;color:black;");
	};
	
	/** 
	 * @param {boolean} bOpened
	 * @protected
	 */
	MenuItemBase.prototype.onSubmenuToggle = function(bOpened){
		// Subclasses may override this: Called when the items submenu is opend or closed
		this.$().toggleClass("sapUiMnuItmSubMnuOpen", bOpened);
	};
	
	/**
	 * @protected
	 */
	MenuItemBase.prototype.onAfterRendering = function(){
		// Subclasses may override this: Called after the item is rendered
	};
	
	
	
	MenuItemBase.prototype.onmouseover = function(oEvent){
		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.unified.Menu && this.getTooltip() instanceof sap.ui.core.TooltipBase) {
			//TooltipBase stops the event propagation
			oParent.onmouseover(oEvent);
		}
	};

	return MenuItemBase;

}, /* bExport= */ true);

}; // end of sap/ui/unified/MenuItemBase.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuTextFieldItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.MenuTextFieldItem.
jQuery.sap.declare('sap.ui.unified.MenuTextFieldItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/MenuTextFieldItem",['jquery.sap.global', 'sap/ui/core/ValueStateSupport', './MenuItemBase', './library'],
	function(jQuery, ValueStateSupport, MenuItemBase, library) {
	"use strict";


	
	/**
	 * Constructor for a new MenuTextFieldItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Menu item which contains an text field. This menu item is e.g. helpful for filters.
	 * The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
	 * @extends sap.ui.unified.MenuItemBase
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.MenuTextFieldItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MenuTextFieldItem = MenuItemBase.extend("sap.ui.unified.MenuTextFieldItem", /** @lends sap.ui.unified.MenuTextFieldItem.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * The label of the contained text field.
			 */
			label : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * Icon to be displayed.
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
	
			/**
			 * Value of the contained text field.
			 */
			value : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Visualizes warnings or errors.
			 */
			valueState : {type : "sap.ui.core.ValueState", group : "Appearance", defaultValue : sap.ui.core.ValueState.None}
		}
	}});
	
	
	(function() {
	
	/**
	 * Called by the Menu renderer when the item should be rendered.
	 * @private
	 */
	MenuTextFieldItem.prototype.render = function(oRenderManager, oItem, oMenu, oInfo){
		var rm = oRenderManager,
			bIsEnabled = oMenu.checkEnabled(oItem),
			itemId = oItem.getId();
		
		var sClass = "sapUiMnuItm sapUiMnuTfItm";
		if (oInfo.iItemNo == 1) {
			sClass += " sapUiMnuItmFirst";
		} else if (oInfo.iItemNo == oInfo.iTotalItems) {
			sClass += " sapUiMnuItmLast";
		}
		if (!oMenu.checkEnabled(oItem)) {
			sClass += " sapUiMnuItmDsbl";
		}
		if (oItem.getStartsSection()) {
			sClass += " sapUiMnuItmSepBefore";
		}
		
		rm.write("<li ");
		rm.writeAttribute("class", sClass);
		rm.writeElementData(oItem);
		
		// ARIA
		if (oInfo.bAccessible) {
			rm.writeAttribute("role", "menuitem");
			rm.writeAttribute("aria-disabled", !bIsEnabled);
			rm.writeAttribute("aria-posinset", oInfo.iItemNo);
			rm.writeAttribute("aria-setsize", oInfo.iTotalItems);
		}
		
		// Left border
		rm.write("><div class=\"sapUiMnuItmL\"></div>");
		
		// icon/check column 
		rm.write("<div class=\"sapUiMnuItmIco\">");
		if (oItem.getIcon()) {
			rm.writeIcon(oItem.getIcon());
		}
		rm.write("</div>");
		
		// Text filed column 
		rm.write("<div id=\"" + itemId + "-txt\" class=\"sapUiMnuItmTxt\">");
		rm.write("<label id=\"" + itemId + "-lbl\" class=\"sapUiMnuTfItemLbl\">");
		rm.writeEscaped(oItem.getLabel() || "");
		rm.write("</label>");
		rm.write("<div id=\"" + itemId + "-str\" class=\"sapUiMnuTfItmStretch\"></div>"); // Helper to strech the width if needed
		rm.write("<div class=\"sapUiMnuTfItemWrppr\">");
		rm.write("<input id=\"" + itemId + "-tf\" tabindex=\"-1\"");
		rm.writeAttributeEscaped("value", oItem.getValue() || "");
		rm.writeAttribute("class", bIsEnabled ? "sapUiMnuTfItemTf sapUiMnuTfItemTfEnbl" : "sapUiMnuTfItemTf sapUiMnuTfItemTfDsbl");
		if (!bIsEnabled) {
			rm.writeAttribute("disabled", "disabled");
		}
		if (oInfo.bAccessible) {
			rm.writeAccessibilityState(oMenu, { //Pass the Menu here to write aria-labelledby
				role: "textbox",
				disabled: !bIsEnabled,
				multiline: false,
				autocomplete: "none",
				labelledby: {value: oMenu.getId() + "-label " + itemId + "-lbl", append: true}
			});
		}
		rm.write("></input></div></div>");
		
		// Right border
		rm.write("<div class=\"sapUiMnuItmR\"></div>");
	
		rm.write("</li>");
	};
	
	
	/**
	 * Called by the Menu renderer when the item is hovered.
	 * @private
	 */
	MenuTextFieldItem.prototype.hover = function(bHovered, oMenu){
		this.$().toggleClass("sapUiMnuItmHov", bHovered);
		
		var that = this;
		function focusTF() {
			that.$("tf").focus();
		}
		
		if (bHovered && oMenu.checkEnabled(this)) {
			if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8) {
				setTimeout(focusTF, 0);
			} else {
				focusTF();
			}
		}
	};
	
	
	/**
	 * Called by the Menu renderer after the item is rendered.
	 * @private
	 */
	MenuTextFieldItem.prototype.onAfterRendering = function(){
		this._adaptSizes();
		this.setValueState(this.getValueState());
	};
	
	
	//************ Event Handling *************
	
	
	MenuTextFieldItem.prototype.onsapup = function(oEvent){
		this.getParent().focus();
		this.getParent().onsapprevious(oEvent);
	};
	
	
	MenuTextFieldItem.prototype.onsapdown = function(oEvent){
		this.getParent().focus();
		this.getParent().onsapnext(oEvent);
	};
	
	
	MenuTextFieldItem.prototype.onsaphome = function(oEvent){
		if (this._checkCursorPosForNav(false)) {
			this.getParent().focus();
			this.getParent().onsaphome(oEvent);
		}
	};
	
	
	MenuTextFieldItem.prototype.onsapend = function(oEvent){
		if (this._checkCursorPosForNav(true)) {
			this.getParent().focus();
			this.getParent().onsapend(oEvent);
		}
	};
	
	
	MenuTextFieldItem.prototype.onsappageup = function(oEvent){
		this.getParent().focus();
		this.getParent().onsappageup(oEvent);
	};
	
	
	MenuTextFieldItem.prototype.onsappagedown = function(oEvent){
		this.getParent().focus();
		this.getParent().onsappagedown(oEvent);
	};
	
	
	MenuTextFieldItem.prototype.onsapescape = function(oEvent){
		this.getParent().onsapescape(oEvent);
	};
	
	
	MenuTextFieldItem.prototype.onkeydown = function(oEvent){
		oEvent.stopPropagation(); //Avoid bubbling key events to the Menu -> Events are only selectively forwarded
	};
	
	
	MenuTextFieldItem.prototype.onclick = function(oEvent){
		if (!sap.ui.Device.system.desktop && this.getParent().checkEnabled(this)) {
			this.focus();
		}
		oEvent.stopPropagation();
	};
	
	
	MenuTextFieldItem.prototype.onsapenter = function(oEvent){
		var sValue = this.$("tf").val();
		this.setValue(sValue);
		this.getParent().selectItem(this);
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	
	// ************ Overridden API functions *************
	
	/**
	 * Getter for aggregation <code>submenu</code>.<br/>
	 * Aggregation of a menu item's sub menu.
	 * 
	 * @return {sap.ui.unified.Menu}
	 * @public
	 * @name sap.ui.unified.MenuTextFieldItem#getSubmenu
	 * @deprecated The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
	 * @function
	 */
	 
	/**
	 * Destroys the submenu in the aggregation 
	 * named <code>submenu</code>.
	 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.unified.MenuTextFieldItem#destroySubmenu
	 * @deprecated The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
	 * @function
	 */
	
	/**
	 * Setter for the aggregated <code>submenu</code>.
	 * @param {sap.ui.unified.Menu} oSubmenu
	 * @return {sap.ui.unified.MenuTextFieldItem} <code>this</code> to allow method chaining
	 * @public
	 * @deprecated The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
	 */
	MenuTextFieldItem.prototype.setSubmenu = function(oMenu){
		jQuery.sap.log.warning("The aggregation 'submenu' is not supported for this type of menu item.", "", "sap.ui.unified.MenuTextFieldItem");
		return this;
	};
	
	
	MenuTextFieldItem.prototype.setLabel = function(sLabel){
		this.setProperty("label", sLabel, true);
		this.$("lbl").text(sLabel);
		this._adaptSizes();
		return this;
	};
	
	
	MenuTextFieldItem.prototype.setValue = function(sValue){
		this.setProperty("value", sValue, true);
		this.$("tf").val(sValue);
		//this._adaptSizes();
		return this;
	};
	
	
	MenuTextFieldItem.prototype.setValueState = function(sValueState){
		this.setProperty("valueState", sValueState, true);
		var $tf = this.$("tf");
		$tf.toggleClass("sapUiMnuTfItemTfErr", sValueState == sap.ui.core.ValueState.Error);
		$tf.toggleClass("sapUiMnuTfItemTfWarn", sValueState == sap.ui.core.ValueState.Warning);
		var sTooltip = ValueStateSupport.enrichTooltip(this, this.getTooltip_AsString());
		this.$().attr("title", sTooltip ? sTooltip : "");
		return this;
	};
	
	
	//************ Private Helpers *************
	
	
	MenuTextFieldItem.prototype.getFocusDomRef = function () {
		var $FocusRef = this.$("tf");
		return $FocusRef.length ? $FocusRef.get(0) : null;
	};
	
	
	MenuTextFieldItem.prototype._adaptSizes = function(){
		var $tf = this.$("tf");
		var $lbl = this.$("lbl");
		var offsetLeft = $lbl.length ? $lbl.get(0).offsetLeft : 0;
		
		if (sap.ui.getCore().getConfiguration().getRTL()) {
			$tf.parent().css({"width": "auto", "right": (this.$().outerWidth(true) - offsetLeft + ($lbl.outerWidth(true) - $lbl.outerWidth())) + "px"});
		} else {
			$tf.parent().css({"width": "auto", "left": (offsetLeft + $lbl.outerWidth(true)) + "px"});
		}
	};
	
	
	MenuTextFieldItem.prototype._checkCursorPosForNav = function(bForward) {
		var bRtl = sap.ui.getCore().getConfiguration().getRTL();
		var bBack = bForward ? bRtl : !bRtl;
		var $input = this.$("tf");
		var iPos = $input.cursorPos();
		var iLen = $input.val().length;
		if (bRtl) {
			iPos = iLen - iPos;
		}
		if ((!bBack && iPos != iLen) || (bBack && iPos != 0)) {
			return false;
		}
		return true;
	};
	
	
	}());
	

	return MenuTextFieldItem;

}, /* bExport= */ true);

}; // end of sap/ui/unified/MenuTextFieldItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellHeadItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.ShellHeadItem.
jQuery.sap.declare('sap.ui.unified.ShellHeadItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellHeadItem",['jquery.sap.global', 'sap/ui/core/Element', 'sap/ui/core/IconPool', './library'],
	function(jQuery, Element, IconPool, library) {
	"use strict";


	
	/**
	 * Constructor for a new ShellHeadItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Header Action item of the Shell.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.15.1
	 * @alias sap.ui.unified.ShellHeadItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ShellHeadItem = Element.extend("sap.ui.unified.ShellHeadItem", /** @lends sap.ui.unified.ShellHeadItem.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * If set to true, a divider is displayed before the item.
			 * @deprecated Since version 1.18. 
			 * Dividers are not supported anymore.
			 */
			startsSection : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
	
			/**
			 * If set to true, a separator is displayed after the item.
			 * @since 1.22.5
			 */
			showSeparator : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * If set to true, the item gets a special design.
			 */
			selected : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * If set to true, a theme dependent marker is shown on the item.
			 * @deprecated Since version 1.18. 
			 * Markers should not be used anymore.
			 */
			showMarker : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
	
			/**
			 * The icon of the item, either defined in the sap.ui.core.IconPool or an URI to a custom image. An icon must be set.
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
	
			/**
			 * Invisible items are not shown on the UI.
			 * @since 1.18
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true}
		},
		events : {
	
			/**
			 * Event is fired when the user presses the item.
			 */
			press : {}
		}
	}});
	
	ShellHeadItem.prototype.onclick = function(oEvent){
		this.firePress();
		// IE always interprets a click on an anker as navigation and thus triggers the 
		// beforeunload-event on the window. Since a ShellHeadItem never has a valid href-attribute,
		// the default behavior should never be triggered
		oEvent.preventDefault();
	};
	
	ShellHeadItem.prototype.onsapspace = ShellHeadItem.prototype.onclick;
	
	
	ShellHeadItem.prototype.setStartsSection = function(bStartsSection){
		bStartsSection = !!bStartsSection;
		this.setProperty("startsSection", bStartsSection, true);
		this.$().toggleClass("sapUiUfdShellHeadItmDelim", bStartsSection);
		return this;
	};
	
	
	ShellHeadItem.prototype.setShowSeparator = function(bShowSeparator){
		bShowSeparator = !!bShowSeparator;
		this.setProperty("showSeparator", bShowSeparator, true);
		this.$().toggleClass("sapUiUfdShellHeadItmSep", bShowSeparator);
		return this;
	};
	
	
	ShellHeadItem.prototype.setSelected = function(bSelected){
		bSelected = !!bSelected;
		this.setProperty("selected", bSelected, true);
		this.$().toggleClass("sapUiUfdShellHeadItmSel", bSelected);
		return this;
	};
	
	
	ShellHeadItem.prototype.setVisible = function(bVisible){
		this.setProperty("visible", !!bVisible); // Suppress Rerendering handled by Shell
		return this;
	};
	
	
	ShellHeadItem.prototype.setShowMarker = function(bMarker){
		bMarker = !!bMarker;
		this.setProperty("showMarker", bMarker, true);
		this.$().toggleClass("sapUiUfdShellHeadItmMark", bMarker);
		return this;
	};
	
	
	ShellHeadItem.prototype.setIcon = function(sIcon){
		this.setProperty("icon", sIcon, true);
		if (this.getDomRef()) {
			this._refreshIcon();
		}
		return this;
	};
	
	
	ShellHeadItem.prototype._refreshIcon = function(){
		var $Ico = jQuery(this.$().children()[0]);
		var sIco = this.getIcon();
		if (IconPool.isIconURI(sIco)) {
			var oIconInfo = IconPool.getIconInfo(sIco);
			$Ico.html("").css("style", "");
			if (oIconInfo) {
				$Ico.text(oIconInfo.content).css("font-family", "'" + oIconInfo.fontFamily + "'");
			}
		} else {
			var $Image = this.$("img-inner");
			if ($Image.length == 0 || $Image.attr("src") != sIco) {
				$Ico.css("style", "").html("<img id='" + this.getId() + "-img-inner' src='" + jQuery.sap.encodeHTML(sIco) + "'></img>");
			}
		}
	};

	return ShellHeadItem;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellHeadItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellHeadUserItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.ShellHeadUserItem.
jQuery.sap.declare('sap.ui.unified.ShellHeadUserItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellHeadUserItem",['jquery.sap.global', 'sap/ui/core/Element', 'sap/ui/core/IconPool', './library'],
	function(jQuery, Element, IconPool, library) {
	"use strict";


	
	/**
	 * Constructor for a new ShellHeadUserItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * User Header Action Item of the Shell.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.22.0
	 * @alias sap.ui.unified.ShellHeadUserItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ShellHeadUserItem = Element.extend("sap.ui.unified.ShellHeadUserItem", /** @lends sap.ui.unified.ShellHeadUserItem.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * The name of the user.
			 */
			username : {type : "string", group : "Appearance", defaultValue : ''},
	
			/**
			 * An image of the user, normally an URI to a image but also an icon from the sap.ui.core.IconPool is possible.
			 */
			image : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null}
		},
		events : {
	
			/**
			 * Event is fired when the user presses the button.
			 */
			press : {}
		}
	}});
	
	IconPool.getIconInfo("", ""); //Ensure Icon Font is loaded
	
	ShellHeadUserItem.prototype.onclick = function(oEvent){
		this.firePress();
		// IE always interprets a click on an anker as navigation and thus triggers the 
		// beforeunload-event on the window. Since a ShellHeadItem never has a valid href-attribute,
		// the default behavior should never be triggered
		oEvent.preventDefault();
	};
	
	ShellHeadUserItem.prototype.onsapspace = ShellHeadUserItem.prototype.onclick;
	
	ShellHeadUserItem.prototype.setImage = function(sImage){
		this.setProperty("image", sImage, true);
		if (this.getDomRef()) {
			this._refreshImage();
		}
		return this;
	};
	
	ShellHeadUserItem.prototype._refreshImage = function(){
		var $Ico = this.$("img");
		var sImage = this.getImage();
		if (!sImage) {
			$Ico.html("").css("style", "").css("display", "none");
		} else if (IconPool.isIconURI(sImage)) {
			var oIconInfo = IconPool.getIconInfo(sImage);
			$Ico.html("").css("style", "");
			if (oIconInfo) {
				$Ico.text(oIconInfo.content).css("font-family", "'" + oIconInfo.fontFamily + "'");
			}
		} else {
			var $Image = this.$("img-inner");
			if ($Image.length == 0 || $Image.attr("src") != sImage) {
				$Ico.css("style", "").html("<img id='" + this.getId() + "-img-inner' src='" + jQuery.sap.encodeHTML(sImage) + "'></img>");
			}
		}
	};
	
	ShellHeadUserItem.prototype._checkAndAdaptWidth = function(bShellSearchVisible){
		if (!this.getDomRef()) {
			return false;
		}
		
		var $Ref = this.$(),
			$NameRef = this.$("name");
		var iBeforeWidth = $Ref.width();
		$Ref.toggleClass("sapUiUfdShellHeadUsrItmLimit", false);
		//User name cannot be larger than 240px
		//(if a search field is shown in the shell this max size decreases depending on the screen width)
		var iMax = 240;
		if (bShellSearchVisible) {
			iMax = Math.min(iMax, 0.5 * document.documentElement.clientWidth - 225);
		}
		if (iMax < $NameRef.width()) {
			$Ref.toggleClass("sapUiUfdShellHeadUsrItmLimit", true);
		}
		return iBeforeWidth != $Ref.width();
	};

	return ShellHeadUserItem;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellHeadUserItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellHeader') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.unified.ShellHeader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellHeader",['jquery.sap.global', './library'],
	function(jQuery, library) {
	"use strict";


	var ShellHeader = sap.ui.core.Control.extend("sap.ui.unified.ShellHeader", {
		
		metadata: {
			properties: {
				logo: {type: "sap.ui.core.URI", defaultValue: ""},
				searchVisible: {type: "boolean", defaultValue: true}
			},
			aggregations: {
				headItems: {type: "sap.ui.unified.ShellHeadItem", multiple: true},
				headEndItems: {type: "sap.ui.unified.ShellHeadItem", multiple: true},
				search: {type: "sap.ui.core.Control", multiple: false},
				user: {type: "sap.ui.unified.ShellHeadUserItem", multiple: false}
			}
		},
		
		renderer: {
			render: function(rm, oHeader){
				var id = oHeader.getId();
				
				rm.write("<div");
				rm.writeControlData(oHeader);
				rm.writeAttribute("class", "sapUiUfdShellHeader");
				rm.write(">");
				
				rm.write("<div id='", id, "-hdr-begin' class='sapUiUfdShellHeadBegin'>");
				this.renderHeaderItems(rm, oHeader, true);
				rm.write("</div>");
				
				rm.write("<div id='", id, "-hdr-center' class='sapUiUfdShellHeadCenter'>");
				this.renderSearch(rm, oHeader);
				rm.write("</div>");
				
				rm.write("<div id='", id, "-hdr-end' class='sapUiUfdShellHeadEnd'>");
				this.renderHeaderItems(rm, oHeader, false);
				rm.write("</div>");
				
				rm.write("</div>");
			},
			
			renderSearch: function(rm, oHeader) {
				var oSearch = oHeader.getSearch();
				rm.write("<div id='", oHeader.getId(), "-hdr-search'");
				rm.writeAttribute("class", "sapUiUfdShellSearch" + (oHeader.getSearchVisible() ? "" : " sapUiUfdShellHidden"));
				rm.write("><div>");
				if (oSearch) {
					rm.renderControl(oSearch);
				}
				rm.write("</div></div>");
			},
			
			renderHeaderItems: function(rm, oHeader, begin) {
				rm.write("<div class='sapUiUfdShellHeadContainer'>");
				var aItems = begin ? oHeader.getHeadItems() : oHeader.getHeadEndItems();
				
				for (var i = 0; i < aItems.length; i++) {
					rm.write("<a tabindex='0' href='javascript:void(0);'");
					rm.writeElementData(aItems[i]);
					rm.addClass("sapUiUfdShellHeadItm");
					if (aItems[i].getStartsSection()) {
						rm.addClass("sapUiUfdShellHeadItmDelim");
					}
					if (aItems[i].getShowSeparator()) {
						rm.addClass("sapUiUfdShellHeadItmSep");
					}
					if (!aItems[i].getVisible()) {
						rm.addClass("sapUiUfdShellHidden");
					}
					if (aItems[i].getSelected()) {
						rm.addClass("sapUiUfdShellHeadItmSel");
					}
					if (aItems[i].getShowMarker()) {
						rm.addClass("sapUiUfdShellHeadItmMark");
					}
					rm.writeClasses();
					var tooltip = aItems[i].getTooltip_AsString();
					if (tooltip) {
						rm.writeAttributeEscaped("title", tooltip);
					}
					rm.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></a>");
				}
				
				var oUser = oHeader.getUser();
				if (!begin && oUser) {
					rm.write("<a tabindex='0' href='javascript:void(0);'");
					rm.writeElementData(oUser);
					rm.addClass("sapUiUfdShellHeadUsrItm");
					rm.writeClasses();
					var tooltip = oUser.getTooltip_AsString();
					if (tooltip) {
						rm.writeAttributeEscaped("title", tooltip);
					}
					rm.write("><span id='", oUser.getId(), "-img' class='sapUiUfdShellHeadUsrItmImg'></span>");
					rm.write("<span id='" + oUser.getId() + "-name' class='sapUiUfdShellHeadUsrItmName'");
					var sUserName = oUser.getUsername() || "";
					rm.writeAttributeEscaped("title", sUserName);
					rm.write(">");
					rm.writeEscaped(sUserName);
					rm.write("</span><span class='sapUiUfdShellHeadUsrItmExp'></span></a>");
				}
				
				rm.write("</div>");
				if (begin) {
					this._renderLogo(rm, oHeader);
				}
			},
			
			_renderLogo: function(rm, oHeader) {
				var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),
					sLogoTooltip = rb.getText("SHELL_LOGO_TOOLTIP"),
					sIco = oHeader._getLogo();
				
				rm.write("<div class='sapUiUfdShellIco'>");
				rm.write("<img id='", oHeader.getId(), "-icon'");
				rm.writeAttributeEscaped("title", sLogoTooltip);
				rm.writeAttributeEscaped("alt", sLogoTooltip);
				rm.write("src='");
				rm.writeEscaped(sIco);
				rm.write("' style='", sIco ? "" : "display:none;","'></img>");
				rm.write("</div>");
			}
		}
		
	});
	
	
	ShellHeader.prototype.init = function(){
		var that = this;
		
		this._rtl = sap.ui.getCore().getConfiguration().getRTL();
		
		this._handleMediaChange = function(mParams){
			if (!that.getDomRef()) {
				return;
			}
			that._refresh();
		};
		sap.ui.Device.media.attachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
		
		this._handleResizeChange = function(mParams){
			if (!that.getDomRef() || !that.getUser()) {
				return;
			}
			
			var oUser = this.getUser();
			var bChanged = oUser._checkAndAdaptWidth(!that.$("hdr-search").hasClass("sapUiUfdShellHidden") && !!that.getSearch());
			if (bChanged) {
				that._refresh();
			}
		};
		sap.ui.Device.resize.attachHandler(this._handleResizeChange, this);
		
		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};
	
	ShellHeader.prototype.exit = function(){
		sap.ui.Device.media.detachHandler(this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
		delete this._handleMediaChange;
		sap.ui.Device.resize.detachHandler(this._handleResizeChange, this);
		delete this._handleResizeChange;
	};
	
	ShellHeader.prototype.onAfterRendering = function(){
		this._refresh();
		this.$("hdr-center").toggleClass("sapUiUfdShellAnim", !this._noHeadCenterAnim);
	};
	
	ShellHeader.prototype.onThemeChanged = function(){
		if (this.getDomRef()) {
			this.invalidate();
		}
	};
	
	ShellHeader.prototype._getLogo = function(){
		var ico = this.getLogo();
		if (!ico) {
			jQuery.sap.require("sap.ui.core.theming.Parameters");
			ico = sap.ui.core.theming.Parameters._getThemeImage(null, true); // theme logo
		}
		return ico;
	};
	
	ShellHeader.prototype._refresh = function(){
		function updateItems(aItems){
			for (var i = 0; i < aItems.length; i++) {
				aItems[i]._refreshIcon();
			}
		}
		
		updateItems(this.getHeadItems());
		updateItems(this.getHeadEndItems());
		
		var oUser = this.getUser(),
			isPhoneSize = jQuery("html").hasClass("sapUiMedia-Std-Phone"),
			searchVisible = !this.$("hdr-search").hasClass("sapUiUfdShellHidden"),
			$logo = this.$("icon");
		
		if (oUser) {
			oUser._refreshImage();
			oUser._checkAndAdaptWidth(searchVisible && !!this.getSearch());
		}
		
		$logo.parent().toggleClass("sapUiUfdShellHidden", isPhoneSize && searchVisible && !!this.getSearch());
		
		var	we = this.$("hdr-end").outerWidth(),
			wb = this.$("hdr-begin").outerWidth(),
			wmax = Math.max(we, wb),
			begin = (isPhoneSize && searchVisible ? wb : wmax) + "px",
			end = (isPhoneSize && searchVisible ? we : wmax) + "px";
	
		this.$("hdr-center").css({
			"left": this._rtl ? end : begin,
			"right": this._rtl ? begin : end
		});
	};

	return ShellHeader;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellHeader.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.SplitContainer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.SplitContainer.
jQuery.sap.declare('sap.ui.unified.SplitContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/SplitContainer",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/theming/Parameters', './library'],
	function(jQuery, Control, Parameters, library) {
	"use strict";


	
	/**
	 * Constructor for a new SplitContainer.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Provides a main content and a secondary content area
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.15.0
	 * @experimental Since version 1.15.0. 
	 * API is not yet finished and might change completely
	 * @alias sap.ui.unified.SplitContainer
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var SplitContainer = Control.extend("sap.ui.unified.SplitContainer", /** @lends sap.ui.unified.SplitContainer.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * Shows / Hides the secondary area.
			 */
			showSecondaryContent : {type : "boolean", group : "Appearance", defaultValue : null},
	
			/**
			 * The width if the secondary content. The height is always 100%.
			 */
			secondaryContentSize : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '250px'},
	
			/**
			 * Do not use. Use secondaryContentSize instead.
			 * @deprecated Since version 1.22. 
			 * 
			 * Only available for backwards compatibility.
			 */
			secondaryContentWidth : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '250px', deprecated: true},
	
			/**
			 * Whether to show the secondary content on the left ("Horizontal", default) or on the top ("Vertical").
			 * @since 1.22.0
			 */
			orientation : {type : "sap.ui.core.Orientation", group : "Appearance", defaultValue : sap.ui.core.Orientation.Horizontal}
		},
		defaultAggregation : "content",
		aggregations : {
	
			/**
			 * The content to appear in the main area.
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
	
			/**
			 * The content to appear in the secondary area.
			 */
			secondaryContent : {type : "sap.ui.core.Control", multiple : true, singularName : "secondaryContent"}
		}
	}});
	
	(function(window) {
	
	
	////////////////////////////////////////// Public Methods //////////////////////////////////////////
	
	SplitContainer.prototype.init = function(){
		this.bRtl  = sap.ui.getCore().getConfiguration().getRTL();
		
		this._paneRenderer = new sap.ui.unified._ContentRenderer(this, this.getId() + "-panecntnt", "secondaryContent");
		this._canvasRenderer = new sap.ui.unified._ContentRenderer(this, this.getId() + "-canvascntnt", "content");
		
	// Design decided that content does not need to be handled differently depending on device - remove 
	// comments if needed again...
	//	sap.ui.Device.media.attachHandler(
	//		this._handleMediaChange, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD
	//	);
	
		// By default move the content when the secondaryContent is shown
		this._moveContent = true;
	};
	
	SplitContainer.prototype.exit = function(){
		this._paneRenderer.destroy();
		delete this._paneRenderer;
		this._canvasRenderer.destroy();
		delete this._canvasRenderer;
	
		delete this._contentContainer;
		delete this._secondaryContentContainer;
	};
	
	
	////////////////////////////////////////// onEvent Methods /////////////////////////////////////////
	
	SplitContainer.prototype.onAfterRendering = function() {
		// Shortcuts to the main DOM containers
		this._contentContainer 			= this.$("canvas");
		this._secondaryContentContainer = this.$("pane");
	
	// Design decided that content does not need to be handled differently depending on device - remove 
	// comments if needed again...
	//	this._lastDeviceName = "";
	//	this._handleMediaChange(
	//		sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD)
	//	);
		
		this._applySecondaryContentSize();
	};
	
	
	////////////////////////////////////////// Private Methods /////////////////////////////////////////
	
	// Design decided that content does not need to be handled differently depending on device - remove 
	// comments if needed again...
	///**
	// * This method is called whenever the size of the document changes into a different range of values
	// * that represent different devices (Desktop/Tablet/Phone).
	// * 
	// * @private
	// */
	//sap.ui.unified.SplitContainer.prototype._handleMediaChange = function(mParams) {
	//	var sDeviceName = mParams.name;
	//	
	//	// By default, move the content to the right, there should be enough space
	//	this._moveContent = true;
	//
	//	if (sDeviceName == "Phone") {
	//		// On phones, do not move the main content as it does not have enough
	//		// space as it is
	//		this._moveContent = false;
	//	}
	//
	//	// Only write changes if something actually changed
	//	if (this._lastDeviceName !== sDeviceName) {
	//		this._applySecondaryContentSize();
	//	}
	//	this._lastDeviceName = sDeviceName;
	//};
	
	/**
	 * Applies the current status to the content areas (CSS left and width properties).
	 * 
	 * @private
	 */
	SplitContainer.prototype._applySecondaryContentSize = function(){
		// Only set if rendered...
		if (this.getDomRef()) {
			var bVertical = this.getOrientation() == sap.ui.core.Orientation.Vertical;
			var sSize, sOtherSize;
			var sDir, sOtherDir;
			var sSizeValue = this.getSecondaryContentSize();
			var bShow = this.getShowSecondaryContent();
	
			if (bVertical) {
				// Vertical mode
				sSize = "height";
				sOtherSize =  "width";
				sDir = "top";
				sOtherDir = this.bRtl ? "right" : "left";
			} else {
				// Horizontal mode
				sSize = "width";
				sOtherSize =  "height";
				sDir = this.bRtl ? "right" : "left";
				sOtherDir = "top";
			}
			
			if (this._closeContentDelayId) {
				jQuery.sap.clearDelayedCall(this._closeContentDelayId);
			}
			
			this._secondaryContentContainer.css(sSize, sSizeValue);
			this._secondaryContentContainer.css(sOtherSize, "");
			this._secondaryContentContainer.css(sDir, bShow ? "0" : "-" + sSizeValue);
			this._secondaryContentContainer.css(sOtherDir, "");
			
			// Move main content if it should be completely visible. @see _handleMediaChange()
			if (this._moveContent) {
				this._contentContainer.css(sDir, bShow ? sSizeValue : "0");
			} else {
				this._contentContainer.css(sDir, "0");
			}
			
			if (!bShow) {
				// The theming parameter is something along the lines of "500ms", the "ms"-part is
				// ignored by parseInt.
				// TODO: Cache the value.
				var iHideDelay = parseInt(
					Parameters.get("sapUiUfdSplitContAnimationDuration"),
					10
				);
				// Maybe we could also allow "s"-values and then multiply everything below 20 with 1000...?
	
				this._closeContentDelayId = jQuery.sap.delayedCall(iHideDelay, this, function() {
					this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed", true);
				});
			} else {
				this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed", false);
			}
			
		}
	};
	
	
	
	/**
	 * Optimization method that prevents the normal render from rerendering the whole control.
	 * See _ContentRenderer in file shared.js for details.
	 * 
	 * @param {function} fMod Method that is called to perform the requested change
	 * @param {sap.ui.core.Renderer} oDoIfRendered Renderer Instance
	 * @returns {any} the return value from the first parameter
	 * 
	 * @private
	 */
	SplitContainer.prototype._mod = function(fMod, oDoIfRendered){
		var bRendered = !!this.getDomRef();
		var res = fMod.apply(this, [bRendered]);
		if (bRendered && oDoIfRendered) {
			oDoIfRendered.render();
		}
		return res;
	};
	
	
	//////////////////////////////////////// Overridden Methods ////////////////////////////////////////
	
	    //////////////////////////// Property "showSecondaryContent" ///////////////////////////////
	
	SplitContainer.prototype.setShowSecondaryContent = function(bShow){
		var bRendered = this.getDomRef();
		this.setProperty("showSecondaryContent", !!bShow, bRendered);
		
		this._applySecondaryContentSize();
		return this;
	};
	
	
		///////////////////////////// Property "secondaryContentSize" /////////////////////////////
	
	SplitContainer.prototype.setSecondaryContentSize = function(sSize) {
		this.setProperty("secondaryContentSize", sSize, true);
		this._applySecondaryContentSize();
		return this;
	};
	
	// Backwards compatibility with old property name

	SplitContainer.prototype.getSecondaryContentWidth = function() {
		jQuery.sap.log.warning(
			"SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use " +
			"\"SecondaryContentSize\" instead."
		);
		return this.getSecondaryContentSize.apply(this, arguments);
	};
		
	SplitContainer.prototype.setSecondaryContentWidth = function() {
		jQuery.sap.log.warning(
			"SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use " +
			"\"SecondaryContentSize\" instead."
		);
		return this.setSecondaryContentSize.apply(this, arguments);
	};
	
	
	
		/////////////////////////////////// Aggregation "content" //////////////////////////////////
	
	SplitContainer.prototype.insertContent = function(oContent, iIndex) {
		return this._mod(function(bRendered){
			return this.insertAggregation("content", oContent, iIndex, bRendered);
		}, this._canvasRenderer);
	};
	SplitContainer.prototype.addContent = function(oContent) {
		return this._mod(function(bRendered){
			return this.addAggregation("content", oContent, bRendered);
		}, this._canvasRenderer);
	};
	SplitContainer.prototype.removeContent = function(vIndex) {
		return this._mod(function(bRendered){
			return this.removeAggregation("content", vIndex, bRendered);
		}, this._canvasRenderer);
	};
	SplitContainer.prototype.removeAllContent = function() {
		return this._mod(function(bRendered){
			return this.removeAllAggregation("content", bRendered);
		}, this._canvasRenderer);
	};
	SplitContainer.prototype.destroyContent = function() {
		return this._mod(function(bRendered){
			return this.destroyAggregation("content", bRendered);
		}, this._canvasRenderer);
	};
	
	
	    ////////////////////////////// Aggregation "secondaryContent" //////////////////////////////
	
	SplitContainer.prototype.insertSecondaryContent = function(oContent, iIndex) {
		return this._mod(function(bRendered){
			return this.insertAggregation("secondaryContent", oContent, iIndex, bRendered);
		}, this._paneRenderer);
	};
	SplitContainer.prototype.addSecondaryContent = function(oContent) {
		return this._mod(function(bRendered){
			return this.addAggregation("secondaryContent", oContent, bRendered);
		}, this._paneRenderer);
	};
	SplitContainer.prototype.removeSecondaryContent = function(vIndex) {
		return this._mod(function(bRendered){
			return this.removeAggregation("secondaryContent", vIndex, bRendered);
		}, this._paneRenderer);
	};
	SplitContainer.prototype.removeAllSecondaryContent = function() {
		return this._mod(function(bRendered){
			return this.removeAllAggregation("secondaryContent", bRendered);
		}, this._paneRenderer);
	};
	SplitContainer.prototype.destroySecondaryContent = function() {
		return this._mod(function(bRendered){
			return this.destroyAggregation("secondaryContent", bRendered);
		}, this._paneRenderer);
	};
	
	
	})(window);
	

	return SplitContainer;

}, /* bExport= */ true);

}; // end of sap/ui/unified/SplitContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Menu') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.Menu.
jQuery.sap.declare('sap.ui.unified.Menu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/Menu",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/Popup', './MenuItemBase', './library', 'jquery.sap.script'],
	function(jQuery, Control, Popup, MenuItemBase, library/* , jQuerySap */) {
	"use strict";


	
	/**
	 * Constructor for a new Menu.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A container for menu items. When the space in the browser is not large enough to display all defined items, a scroll bar is provided.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.Menu
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Menu = Control.extend("sap.ui.unified.Menu", /** @lends sap.ui.unified.Menu.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * 
			 * Disabled menus have other colors than enabled ones, depending on customer settings.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * 
			 * The label/description provided for screen readers
			 */
			ariaDescription : {type : "string", group : "Accessibility", defaultValue : null},
	
			/**
			 * 
			 * Max. number of items to be displayed before an overflow mechanimn appears. Values smaller than 1 mean infinite number of visible items.
			 * The menu can not become larger than the screen height.
			 */
			maxVisibleItems : {type : "int", group : "Behavior", defaultValue : 0},
	
			/**
			 * 
			 * The number of items to be shifted up or down upon Page-up or Page-up key navigation. Values smaller than 1 mean infinite number of page items.
			 * @since 1.25.0
			 */
			pageSize : {type : "int", group : "Behavior", defaultValue : 5}
		},
		defaultAggregation : "items",
		aggregations : {
	
			/**
			 * Aggregation of menu items
			 */
			items : {type : "sap.ui.unified.MenuItemBase", multiple : true, singularName : "item"}
		},
		associations : {
	
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 * @since 1.26.3
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {
	
			/**
			 * 
			 * Provides the application an alternative option to listen to select events. This event is only fired on the root menu of a menu hierarchy.
			 * Note that there is also a select event available for MenuItem; if the current event is used, the select event of a MenuItem becomes redundant.
			 */
			itemSelect : {
				parameters : {
	
					/**
					 * The selected item
					 */
					item : {type : "sap.ui.unified.MenuItemBase"}
				}
			}
		}
	}});
	
	
	
	
	
	
	
	(function(window) {
	
	
	Menu.prototype.init = function(){
		var that = this;
		this.bOpen = false;
		this.oOpenedSubMenu = null;
		this.oHoveredItem = null;
		this.oPopup = null; // Will be created lazily
		this.fAnyEventHandlerProxy = jQuery.proxy(function(oEvent){
			var oRoot = this.getRootMenu();
			if (oRoot != this || !this.bOpen || !this.getDomRef() || (oEvent.type != "mousedown" && oEvent.type != "touchstart")) {
				return;
			}
			oRoot.handleOuterEvent(this.getId(), oEvent); //TBD: standard popup autoclose
		}, this);
		this.fOrientationChangeHandler = function(){
			that.close();
		};
		this.bUseTopStyle = false;
	};
	
	/**
	 * Does all the cleanup when the Menu is to be destroyed.
	 * Called from Element's destroy() method.
	 * @private
	 */
	Menu.prototype.exit = function(){
		if (this.oPopup) {
			this.oPopup.detachOpened(this._menuOpened, this);
			this.oPopup.detachClosed(this._menuClosed, this);
			this.oPopup.destroy();
			delete this.oPopup;
		}
		
		jQuery.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);
		if (this._bOrientationChangeBound) {
			jQuery(window).unbind("orientationchange", this.fOrientationChangeHandler);
			this._bOrientationChangeBound = false;
		}
		
		// Cleanup
		this._resetDelayedRerenderItems();
	};
	
	/**
	 * Called when the control or its children are changed.
	 * @private
	 */
	Menu.prototype.invalidate = function(oOrigin){
		if (oOrigin instanceof MenuItemBase && this.getDomRef()) {
			this._delayedRerenderItems();
		} else {
			Control.prototype.invalidate.apply(this, arguments);
		}
	};
	
	/**
	 * Called before rendering starts by the renderer
	 * @private
	 */
	Menu.prototype.onBeforeRendering = function() {
		this._resetDelayedRerenderItems();
	};
	
	/**
	 * Called when the rendering is complete
	 * @private
	 */
	Menu.prototype.onAfterRendering = function() {
		var aItems = this.getItems();

		for (var i = 0; i < aItems.length; i++) {
			if (aItems[i].onAfterRendering && aItems[i].getDomRef()) {
				aItems[i].onAfterRendering();
			}
		}
		
		if (this.oHoveredItem) {
			this.oHoveredItem.hover(true, this);
		}
		
		checkAndLimitHeight(this);
	};
	
	Menu.prototype.onThemeChanged = function(){
		if (this.getDomRef() && this.getPopup().getOpenState() === sap.ui.core.OpenState.OPEN) {
			checkAndLimitHeight(this);
			this.getPopup()._applyPosition(this.getPopup()._oLastPosition);
		}
	};
	
	
	//****** API Methods ******
	
	Menu.prototype.setPageSize = function(iSize){
		return this.setProperty("pageSize", iSize, true); /*No rerendering required*/
	};
	
	Menu.prototype.addItem = function(oItem){
		this.addAggregation("items", oItem, !!this.getDomRef());
		this._delayedRerenderItems();
		return this;
	};
	
	Menu.prototype.insertItem = function(oItem, idx){
		this.insertAggregation("items", oItem, idx, !!this.getDomRef());
		this._delayedRerenderItems();
		return this;
	};
	
	Menu.prototype.removeItem = function(oItem){
		this.removeAggregation("items", oItem, !!this.getDomRef());
		this._delayedRerenderItems();
		return this;
	};
	
	Menu.prototype.removeAllItems = function(){
		var oRes = this.removeAllAggregation("items", !!this.getDomRef());
		this._delayedRerenderItems();
		return oRes;
	};
	
	Menu.prototype.destroyItems = function(){
		this.destroyAggregation("items", !!this.getDomRef());
		this._delayedRerenderItems();
		return this;
	};
	
	Menu.prototype._delayedRerenderItems = function(){
		if (!this.getDomRef()) {
			return;
		}
		this._resetDelayedRerenderItems();
		
		this._itemRerenderTimer = jQuery.sap.delayedCall(0, this, function(){
			var oDomRef = this.getDomRef();
			if (oDomRef) {
				var oRm = sap.ui.getCore().createRenderManager();
				sap.ui.unified.MenuRenderer.renderItems(oRm, this);
				oRm.flush(oDomRef);
				oRm.destroy();
				this.onAfterRendering();
				this.getPopup()._applyPosition(this.getPopup()._oLastPosition);
			}
		});
	};
	
	Menu.prototype._resetDelayedRerenderItems = function(){
		if (this._itemRerenderTimer) {
			jQuery.sap.clearDelayedCall(this._itemRerenderTimer);
			delete this._itemRerenderTimer;
		}
	};
	
	

	/**
	 * Opens the menu
	 *
	 * @param {boolean} bWithKeyboard
	 * 
	 *         An indicator whether the first item shall be highlighted, or not. It is highlighted in the case that the menu is opened via keyboard.
	 * @param {object} oOpenerRef
	 * 
	 *         DOMNode or sap.ui.core.Element that opens the menu; the DOMNode or sap.ui.core.Element will be focused again after the menu is closed. This parameter is optional.
	 * @param {sap.ui.core.Dock} sMy
	 * 
	 *         The popup content's reference position for docking.
	 *         See also sap.ui.core.Popup.Dock and sap.ui.core.Popup.open.
	 * @param {sap.ui.core.Dock} sAt
	 * 
	 *         The 'of' element's reference point for docking to.
	 *         See also sap.ui.core.Popup.Dock and sap.ui.core.Popup.open.
	 * @param {object} oOf
	 * 
	 *         The DOM element or sap.ui.core.Element to dock to.
	 *         See also sap.ui.core.Popup.open.
	 * @param {string} sOffset
	 * 
	 *         The offset relative to the docking point, specified as a string with space-separated pixel values (e.g. "0 10" to move the popup 10 pixels to the right).
	 *         See also sap.ui.core.Popup.open.
	 * @param {sap.ui.core.Collision} sCollision
	 * 
	 *         The collision defines how the position of an element should be adjusted in case it overflows the window in some direction.
	 *         See also sap.ui.core.Popup.open.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Menu.prototype.open = function(bWithKeyboard, oOpenerRef, my, at, of, offset, collision){
		if (this.bOpen) {
			return;
		}
		
		setItemToggleState(this, true);
	
		this.bOpen = true;
		this.oOpenerRef = oOpenerRef;
	
		// Open the sap.ui.core.Popup
		this.getPopup().open(0, my, at, of, offset || "0 0", collision || "_sapUiCommonsMenuFlip _sapUiCommonsMenuFlip", true);
	
		// Set the tab index of the menu and focus
		var oDomRef = this.getDomRef();
		jQuery(oDomRef).attr("tabIndex", 0).focus();
		
		// Mark the first item when using the keyboard
		if (bWithKeyboard) {
			this.setHoveredItem(this.getNextSelectableItem(-1));
		}
	
		jQuery.sap.bindAnyEvent(this.fAnyEventHandlerProxy);
		if (sap.ui.Device.support.orientation && this.getRootMenu() === this) {
			jQuery(window).bind("orientationchange", this.fOrientationChangeHandler);
			this._bOrientationChangeBound = true;
		}
	};
	
	/**
	 * This function is called when the Menu was opened.
	 *
	 * @since 1.17.0
	 * @private
	 */
	Menu.prototype._menuOpened = function() {
		fnIe8RepaintBug(this);
	};
	

	/**
	 * Closes the menu
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Menu.prototype.close = function() {
		if (!this.bOpen || Menu._dbg /*Avoid closing for debugging purposes*/) {
			return;
		}
		
		setItemToggleState(this, false);
		
		// Remove fixed flag if it existed
		delete this._bFixed;
	
		jQuery.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);
		if (this._bOrientationChangeBound) {
			jQuery(window).unbind("orientationchange", this.fOrientationChangeHandler);
			this._bOrientationChangeBound = false;
		}
	
		this.bOpen = false;
		// Close all sub menus if there are any
		if (this.oOpenedSubMenu) {
			this.oOpenedSubMenu.close();
		}
	
		// Reset the hover state
		this.setHoveredItem();
	
		// Reset the tab index of the menu and focus the opener (if there is any)
		jQuery(this.getDomRef()).attr("tabIndex", -1);
	
		// Close the sap.ui.core.Popup
		this.getPopup().close(0);
	
		//Remove the Menus DOM after it is closed
		this._resetDelayedRerenderItems();
		this.$().remove();
		this.bOutput = false;
	
		if (this.isSubMenu()) {
			this.getParent().getParent().oOpenedSubMenu = null;
		}
	};
	
	/**
	 * This function is called when the Menu was closed.
	 *
	 * @since 1.17.0
	 * @private
	 */
	Menu.prototype._menuClosed = function() {
		//TBD: standard popup autoclose: this.close(); //Ensure proper cleanup
		if (this.oOpenerRef) {
			if (!this.ignoreOpenerDOMRef) {
				try {
					this.oOpenerRef.focus();
				} catch (e) {
					jQuery.sap.log.warning("Menu.close cannot restore the focus on opener " + this.oOpenerRef + ", " + e);
				}
			}
			this.oOpenerRef = undefined;
		}
	};
	
	//****** Event Handlers ******
	
	Menu.prototype.onclick = function(oEvent){
		this.selectItem(this.getItemByDomRef(oEvent.target), false, !!(oEvent.metaKey || oEvent.ctrlKey));
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	
	Menu.prototype.onsapnext = function(oEvent){
		//right or down (RTL: left or down)
		if (oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_DOWN) {
			//Go to sub menu if available
			if (this.oHoveredItem && this.oHoveredItem.getSubmenu() && this.checkEnabled(this.oHoveredItem)) {
				this.openSubmenu(this.oHoveredItem, true);
			}
			return;
		}
	
		//Go to the next selectable item
		var iIdx = this.oHoveredItem ? this.indexOfAggregation("items", this.oHoveredItem) : -1;
		this.setHoveredItem(this.getNextSelectableItem(iIdx));
		
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsapprevious = function(oEvent){
		//left or up (RTL: right or up)
		if (oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_UP) {
			//Go to parent menu if this is a sub menu
			if (this.isSubMenu()) {
				this.close();
			}
			oEvent.preventDefault();
			oEvent.stopPropagation();
			return;
		}
	
		//Go to the previous selectable item
		var iIdx = this.oHoveredItem ? this.indexOfAggregation("items", this.oHoveredItem) : -1;
		this.setHoveredItem(this.getPreviousSelectableItem(iIdx));
	
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsaphome = function(oEvent){
		//Go to the first selectable item
		this.setHoveredItem(this.getNextSelectableItem(-1));
	
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsapend = function(oEvent){
		//Go to the last selectable item
		this.setHoveredItem(this.getPreviousSelectableItem(this.getItems().length));
	
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsappagedown = function(oEvent) {
		if (this.getPageSize() < 1) {
			this.onsapend(oEvent);
			return;
		}
		var iIdx = this.oHoveredItem ? this.indexOfAggregation("items", this.oHoveredItem) : -1;
		iIdx += this.getPageSize();
			
		if (iIdx >= this.getItems().length) {
			this.onsapend(oEvent);
			return;
		}
		this.setHoveredItem(this.getNextSelectableItem(iIdx - 1)); //subtract 1 to preserve computed page offset because getNextSelectableItem already offsets 1 item down
			
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsappageup = function(oEvent) {
		if (this.getPageSize() < 1) {
			this.onsaphome(oEvent);
			return;
		}
	
		var iIdx = this.oHoveredItem ? this.indexOfAggregation("items", this.oHoveredItem) : -1;
		iIdx -= this.getPageSize();
		if (iIdx < 0) {
			this.onsaphome(oEvent);
			return;
		}
		this.setHoveredItem(this.getPreviousSelectableItem(iIdx + 1)); //add 1 to preserve computed page offset because getPreviousSelectableItem already offsets one item up
	
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsapselect = function(oEvent){
		this._sapSelectOnKeyDown = true;
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onkeyup = function(oEvent){
		//like sapselect but on keyup:
		//Using keydown has the following side effect:
		//If the selection leads to a close of the menu and the focus is restored to the caller (e.g. a button)
		//the keyup is fired on the caller (in case of a button a click event is fired there in FF -> Bad!)
		//The attribute _sapSelectOnKeyDown is used to avoid the problem the other way round (Space is pressed
		//on Button which opens the menu and the space keyup immediately selects the first item)
		if (!this._sapSelectOnKeyDown) {
			return;
		} else {
			this._sapSelectOnKeyDown = false;
		}
		if (!jQuery.sap.PseudoEvents.sapselect.fnCheck(oEvent)) {
			return;
		}
		this.selectItem(this.oHoveredItem, true, false);
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsapbackspace = function(oEvent){
		if (jQuery(oEvent.target).prop("tagName") != "INPUT") {
			oEvent.preventDefault(); //CSN 4537657 2012: Stop browser history navigation
		}
	};
	Menu.prototype.onsapbackspacemodifiers = Menu.prototype.onsapbackspace;
	
	Menu.prototype.onsapescape = function(oEvent){
		this.close();
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	Menu.prototype.onsaptabnext = Menu.prototype.onsapescape;
	Menu.prototype.onsaptabprevious = Menu.prototype.onsapescape;
	
	Menu.prototype.onmouseover = function(oEvent){
		if (!sap.ui.Device.system.desktop) {
			return;
		}
		var oItem = this.getItemByDomRef(oEvent.target);
		if (!this.bOpen || !oItem || oItem == this.oHoveredItem) {
			return;
		}
	
		if (this.oOpenedSubMenu && jQuery.sap.containsOrEquals(this.oOpenedSubMenu.getDomRef(), oEvent.target)) {
			return;
		}
	
		this.setHoveredItem(oItem);
	
		if (this.oOpenedSubMenu && !this.oOpenedSubMenu._bFixed) {
			this.oOpenedSubMenu.close();
			this.oOpenedSubMenu = null;
		}
	
		if (jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())) {
			this.getDomRef().focus();
		}
	
		if (this.checkEnabled(oItem)) {
			this.openSubmenu(oItem, false, true);
		}
	};
	
	Menu.prototype.onmouseout = function(oEvent){
		if (!sap.ui.Device.system.desktop) {
			return;
		}
		fnIe8RepaintBug(this);
		
		if (jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())) {
			if (!this.oOpenedSubMenu || !this.oOpenedSubMenu.getParent() === this.oHoveredItem) {
				this.setHoveredItem(null);
			}
		}
	};
	
	/**
	 * Handles the onsapfocusleave event
	 * @param {jQuery.Event} oEvent The browser event
	 * @private
	 */
	Menu.prototype.onsapfocusleave = function(oEvent){
		// Only the deepest opened sub menu should handle the event or ignore the event from an item
		if (this.oOpenedSubMenu || !this.bOpen) {
			return;
		}
		this.getRootMenu().handleOuterEvent(this.getId(), oEvent); //TBD: standard popup autoclose
	};
	
	//****** Helper Methods ******
	
	Menu.prototype.handleOuterEvent = function(oMenuId, oEvent){
		//See sap.ui.core.Popup implementation: Target is to use autoclose mechanismn of the popup
		//but currently there autoclose only works for 2 hierarchy levels and not for n as needed by the menu
		//-> This function and all its callers are obsolete when switching later to standard popup autoclose
		//   (all needed further code locations for that change are marked with "TBD: standard popup autoclose")
		var isInMenuHierarchy = false,
			touchEnabled = this.getPopup().touchEnabled;
		
		if (oEvent.type == "mousedown" || oEvent.type == "touchstart") {
			// Suppress the delayed mouse event from mobile browser
			if (touchEnabled && (oEvent.isMarked("delayedMouseEvent") || oEvent.isMarked("cancelAutoClose"))) {
				return;
			}
			var that = this;
			while (that && !isInMenuHierarchy) {
				if (jQuery.sap.containsOrEquals(that.getDomRef(), oEvent.target)) {
					isInMenuHierarchy = true;
				}
				that = that.oOpenedSubMenu;
			}
		} else if (oEvent.type == "sapfocusleave") {
			if (touchEnabled) {
				return;
			}
			if (oEvent.relatedControlId) {
				var that = this;
				while (that && !isInMenuHierarchy) {
					if ((that.oOpenedSubMenu && that.oOpenedSubMenu.getId() == oEvent.relatedControlId)
							|| jQuery.sap.containsOrEquals(that.getDomRef(), jQuery.sap.byId(oEvent.relatedControlId).get(0))) {
						isInMenuHierarchy = true;
					}
					that = that.oOpenedSubMenu;
				}
			}
		}
	
		if (!isInMenuHierarchy) {
			this.ignoreOpenerDOMRef = true;
			this.close();
			this.ignoreOpenerDOMRef = false;
		}
	};
	
	Menu.prototype.getItemByDomRef = function(oDomRef){
		var oItems = this.getItems(),
			iLength = oItems.length;
		for (var i = 0;i < iLength;i++) {
			var oItem = oItems[i],
				oItemRef = oItem.getDomRef();
			if (jQuery.sap.containsOrEquals(oItemRef, oDomRef)) {
				return oItem;
			}
		}
		return null;
	};
	
	Menu.prototype.selectItem = function(oItem, bWithKeyboard, bCtrlKey){
		if (!oItem || !(oItem instanceof MenuItemBase && this.checkEnabled(oItem))) {
			return;
		}
	
		var oSubMenu = oItem.getSubmenu();
	
		if (!oSubMenu) {
			// This is a normal item -> Close all menus and fire event.
			this.getRootMenu().close();
		} else {
			if (!sap.ui.Device.system.desktop && this.oOpenedSubMenu === oSubMenu) {
				this.oOpenedSubMenu.close();
				this.oOpenedSubMenu = null;
			} else {
				// Item with sub menu was triggered -> Open sub menu and fire event.
				this.openSubmenu(oItem, bWithKeyboard);
			}
		}
	
		oItem.fireSelect({item: oItem, ctrlKey: bCtrlKey});
		this.getRootMenu().fireItemSelect({item: oItem});
	};
	
	Menu.prototype.isSubMenu = function(){
		return this.getParent() && this.getParent().getParent && this.getParent().getParent() instanceof Menu;
	};
	
	Menu.prototype.getRootMenu = function(){
		var that = this;
		while (that.isSubMenu()) {
			that = that.getParent().getParent();
		}
		return that;
	};
	
	Menu.prototype.getMenuLevel = function(){
		var iLevel = 1;
		var that = this;
		while (that.isSubMenu()) {
			that = that.getParent().getParent();
			iLevel++;
		}
		return iLevel;
	};
	
	Menu.prototype.getPopup = function (){
		if (!this.oPopup) {
			this.oPopup = new Popup(this, false, true, false); // content, modal, shadow, autoclose (TBD: standard popup autoclose)
			this.oPopup.setDurations(0, 0);
			this.oPopup.attachOpened(this._menuOpened, this);
			this.oPopup.attachClosed(this._menuClosed, this);
		}
		return this.oPopup;
	};
	
	Menu.prototype.setHoveredItem = function(oItem){
		if (this.oHoveredItem) {
			this.oHoveredItem.hover(false, this);
		}
	
		if (!oItem) {
			this.oHoveredItem = null;
			jQuery(this.getDomRef()).removeAttr("aria-activedescendant");
			return;
		}
	
		this.oHoveredItem = oItem;
		oItem.hover(true, this);
		this._setActiveDescendant(this.oHoveredItem);
		
		this.scrollToItem(this.oHoveredItem);
	};
	
	Menu.prototype._setActiveDescendant = function(oItem){
		if (sap.ui.getCore().getConfiguration().getAccessibility()) {
			var that = this;
			setTimeout(function(){
				//Setting active descendant must be a bit delayed. Otherwise the screenreader does not announce it.
				if (that.oHoveredItem === oItem) {
					that.$().attr("aria-activedescendant", that.oHoveredItem.getId());
				}
			}, 10);
		}
	};
	
	Menu.prototype.openSubmenu = function(oItem, bWithKeyboard, bWithHover){
		var oSubMenu = oItem.getSubmenu();
		if (!oSubMenu) {
			return;
		}
	
		if (this.oOpenedSubMenu && this.oOpenedSubMenu !== oSubMenu) {
			// Another sub menu is open and has not been fixed. Close it at first.
			this.oOpenedSubMenu.close();
			this.oOpenedSubMenu = null;
		}
		
		if (this.oOpenedSubMenu) {
			// Already open. Keep open, bring to front and fix/unfix menu...
	
			// Fix/Unfix Menu if clicked. Do not change status if just hovering over
			this.oOpenedSubMenu._bFixed =
				   (bWithHover && this.oOpenedSubMenu._bFixed)
				|| (!bWithHover && !this.oOpenedSubMenu._bFixed);
			
			this.oOpenedSubMenu._bringToFront();
		} else {
			// Open the sub menu
			this.oOpenedSubMenu = oSubMenu;
			var eDock = Popup.Dock;
			oSubMenu.open(bWithKeyboard, this, eDock.BeginTop, eDock.EndTop, oItem, "0 0");
		}
	};
	
	/**
	 * Scrolls an item into the visual viewport.
	 *
	 * @private
	 */
	Menu.prototype.scrollToItem = function(oItem) {
	
		var oMenuRef = this.getDomRef(),
		oItemRef = oItem ? oItem.getDomRef() : null;
	
		if (!oItemRef || !oMenuRef) {
			return;
		}
	
		var iMenuScrollTop = oMenuRef.scrollTop, 
		iItemOffsetTop = oItemRef.offsetTop, 
		iMenuHeight = jQuery(oMenuRef).height(), 
		iItemHeight = jQuery(oItemRef).height();
	
		if (iMenuScrollTop > iItemOffsetTop) { // scroll up
			oMenuRef.scrollTop = iItemOffsetTop;
		} else if ((iItemOffsetTop + iItemHeight) > (iMenuScrollTop + iMenuHeight)) { // scroll down
			oMenuRef.scrollTop = Math.ceil(iItemOffsetTop + iItemHeight - iMenuHeight);
		}
	};
	
	/**
	 * Brings this menu to the front of the menu stack.
	 * This simulates a mouse-event and raises the z-index which is internally tracked by the Popup.
	 * 
	 * @private
	 */
	Menu.prototype._bringToFront = function() {
		// This is a hack. We "simulate" a mouse-down-event on the submenu so that it brings itself
		// to the front.
		jQuery.sap.byId(this.getPopup().getId()).mousedown();
	};
	
	Menu.prototype.checkEnabled = function(oItem){
		fnIe8RepaintBug(this);
		return oItem && oItem.getEnabled() && this.getEnabled();
	};
	
	Menu.prototype.getNextSelectableItem = function(iIdx){
		var oItem = null;
		var aItems = this.getItems();
	
		// At first, start with the next index
		for (var i = iIdx + 1; i < aItems.length; i++) {
			if (aItems[i].getVisible() && this.checkEnabled(aItems[i])) {
				oItem = aItems[i];
				break;
			}
		}
	
		// If nothing found, start from the beginning
		if (!oItem) {
			for (var i = 0; i <= iIdx; i++) {
				if (aItems[i].getVisible() && this.checkEnabled(aItems[i])) {
					oItem = aItems[i];
					break;
				}
			}
		}
	
		return oItem;
	};
	
	Menu.prototype.getPreviousSelectableItem = function(iIdx){
		var oItem = null;
		var aItems = this.getItems();
	
		// At first, start with the previous index
		for (var i = iIdx - 1; i >= 0; i--) {
			if (aItems[i].getVisible() && this.checkEnabled(aItems[i])) {
				oItem = aItems[i];
				break;
			}
		}
	
		// If nothing found, start from the end
		if (!oItem) {
			for (var i = aItems.length - 1; i >= iIdx; i--) {
				if (aItems[i].getVisible() && this.checkEnabled(aItems[i])) {
					oItem = aItems[i];
					break;
				}
			}
		}
	
		return oItem;
	};
	
	Menu.prototype.setRootMenuTopStyle = function(bUseTopStyle){
		this.getRootMenu().bUseTopStyle = bUseTopStyle;
		Menu.rerenderMenu(this.getRootMenu());
	};
	
	
	Menu.rerenderMenu = function(oMenu){
		var aItems = oMenu.getItems();
		for (var i = 0; i < aItems.length; i++) {
			var oSubMenu = aItems[i].getSubmenu();
			if (oSubMenu) {
				Menu.rerenderMenu(oSubMenu);
			}
		}
	
		oMenu.invalidate();
		oMenu.rerender();
	};
	
	
	///////////////////////////////////////// Hidden Functions /////////////////////////////////////////
	
	function setItemToggleState(oMenu, bOpen){
		var oParent = oMenu.getParent();
		if (oParent && oParent instanceof MenuItemBase) {
			oParent.onSubmenuToggle(bOpen);
		}
	}
	
	
	function checkAndLimitHeight(oMenu) {
		var iMaxVisibleItems = oMenu.getMaxVisibleItems(),
			iMaxHeight = document.documentElement.clientHeight - 10,
			$Menu = oMenu.$();
		
		if (iMaxVisibleItems > 0) {
			var aItems = oMenu.getItems();
			for (var i = 0; i < aItems.length; i++) {
				if (aItems[i].getDomRef()) {
					iMaxHeight = Math.min(iMaxHeight, aItems[i].$().outerHeight(true) * iMaxVisibleItems);
					break;
				}
			}
		}
		
		if ($Menu.outerHeight(true) > iMaxHeight) {
			$Menu.css("max-height", iMaxHeight + "px").toggleClass("sapUiMnuScroll", true);
		} else {
			$Menu.css("max-height", "").toggleClass("sapUiMnuScroll", false);
		}
	}
	
	
	//IE 8 repainting bug when hovering over MenuItems with IconFont
	var fnIe8RepaintBug = function() {};
	if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 9) {
		fnIe8RepaintBug = function(oMenu, iDelay) {
			if (iDelay === undefined) {
				iDelay = 50;
			}
			
			
			/* In case of perdormance issues, the commented code around the delayedCall might help:
			jQuery.sap.clearDelayedCall(oMenu.data("delayedRepaintId"));
			var iDelayedId =  */
			jQuery.sap.delayedCall(iDelay, oMenu, function() {
				var $Elem = this.$(); // this is the Menu instance from the oMenu argument
				if ($Elem.length > 0) {
					var oDomRef = $Elem[0].firstChild;
					sap.ui.core.RenderManager.forceRepaint(oDomRef);
				}
			});
			/* oMenu.data("delayedRepaintId", iDelayedId); */
		};
	}
	
	
	//**********************************************
	
	/*!
	 * The following code is taken from 
	 * jQuery UI 1.10.3 - 2013-11-18
	 * jquery.ui.position.js
	 *
	 * http://jqueryui.com
	 * Copyright 2013 jQuery Foundation and other contributors; Licensed MIT
	 */
	
	//TODO: Get rid of this coding when jQuery UI 1.8 is no longer supported and the framework was switched to jQuery UI 1.9 ff. 
	
	function _migrateDataTojQueryUI110(data){
		var withinElement = jQuery(window);
		data.within = {
			element: withinElement,
			isWindow: true,
			offset: withinElement.offset() || { left: 0, top: 0 },
			scrollLeft: withinElement.scrollLeft(),
			scrollTop: withinElement.scrollTop(),
			width: withinElement.width(),
			height: withinElement.height()
		};
		data.collisionPosition = {
			marginLeft: 0,
			marginTop: 0
		};
		return data;
	}
	
	var _pos_jQueryUI110 = {
		fit: {
			left: function( position, data ) {
				var within = data.within,
					withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,
					outerWidth = within.width,
					collisionPosLeft = position.left - data.collisionPosition.marginLeft,
					overLeft = withinOffset - collisionPosLeft,
					overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,
					newOverRight;
	
				// element is wider than within
				if ( data.collisionWidth > outerWidth ) {
					// element is initially over the left side of within
					if ( overLeft > 0 && overRight <= 0 ) {
						newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;
						position.left += overLeft - newOverRight;
					// element is initially over right side of within
					} else if ( overRight > 0 && overLeft <= 0 ) {
						position.left = withinOffset;
					// element is initially over both left and right sides of within
					} else {
						if ( overLeft > overRight ) {
							position.left = withinOffset + outerWidth - data.collisionWidth;
						} else {
							position.left = withinOffset;
						}
					}
				// too far left -> align with left edge
				} else if ( overLeft > 0 ) {
					position.left += overLeft;
				// too far right -> align with right edge
				} else if ( overRight > 0 ) {
					position.left -= overRight;
				// adjust based on position and margin
				} else {
					position.left = Math.max( position.left - collisionPosLeft, position.left );
				}
			},
			top: function( position, data ) {
				var within = data.within,
					withinOffset = within.isWindow ? within.scrollTop : within.offset.top,
					outerHeight = data.within.height,
					collisionPosTop = position.top - data.collisionPosition.marginTop,
					overTop = withinOffset - collisionPosTop,
					overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,
					newOverBottom;
	
				// element is taller than within
				if ( data.collisionHeight > outerHeight ) {
					// element is initially over the top of within
					if ( overTop > 0 && overBottom <= 0 ) {
						newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;
						position.top += overTop - newOverBottom;
					// element is initially over bottom of within
					} else if ( overBottom > 0 && overTop <= 0 ) {
						position.top = withinOffset;
					// element is initially over both top and bottom of within
					} else {
						if ( overTop > overBottom ) {
							position.top = withinOffset + outerHeight - data.collisionHeight;
						} else {
							position.top = withinOffset;
						}
					}
				// too far up -> align with top
				} else if ( overTop > 0 ) {
					position.top += overTop;
				// too far down -> align with bottom edge
				} else if ( overBottom > 0 ) {
					position.top -= overBottom;
				// adjust based on position and margin
				} else {
					position.top = Math.max( position.top - collisionPosTop, position.top );
				}
			}
		},
		flip: {
			left: function( position, data ) {
				var within = data.within,
					withinOffset = within.offset.left + within.scrollLeft,
					outerWidth = within.width,
					offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,
					collisionPosLeft = position.left - data.collisionPosition.marginLeft,
					overLeft = collisionPosLeft - offsetLeft,
					overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,
					/*eslint-disable no-nested-ternary */
					myOffset = data.my[ 0 ] === "left" ?
						-data.elemWidth :
						data.my[ 0 ] === "right" ?
							data.elemWidth :
							0,
					atOffset = data.at[ 0 ] === "left" ?
						data.targetWidth :
						data.at[ 0 ] === "right" ?
							-data.targetWidth :
							0,
					/*eslint-enable no-nested-ternary */
					offset = -2 * data.offset[ 0 ],
					newOverRight,
					newOverLeft;
	
				if ( overLeft < 0 ) {
					newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;
					if ( newOverRight < 0 || newOverRight < Math.abs( overLeft ) ) {
						position.left += myOffset + atOffset + offset;
					}
				}
				else if ( overRight > 0 ) {
					newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;
					if ( newOverLeft > 0 || Math.abs( newOverLeft ) < overRight ) {
						position.left += myOffset + atOffset + offset;
					}
				}
			},
			top: function( position, data ) {
				var within = data.within,
					withinOffset = within.offset.top + within.scrollTop,
					outerHeight = within.height,
					offsetTop = within.isWindow ? within.scrollTop : within.offset.top,
					collisionPosTop = position.top - data.collisionPosition.marginTop,
					overTop = collisionPosTop - offsetTop,
					overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,
					top = data.my[ 1 ] === "top",
					/*eslint-disable no-nested-ternary */
					myOffset = top ?
						-data.elemHeight :
						data.my[ 1 ] === "bottom" ?
							data.elemHeight :
							0,
					atOffset = data.at[ 1 ] === "top" ?
						data.targetHeight :
						data.at[ 1 ] === "bottom" ?
							-data.targetHeight :
							0,
					/*eslint-enable no-nested-ternary */
					offset = -2 * data.offset[ 1 ],
					newOverTop,
					newOverBottom;
				if ( overTop < 0 ) {
					newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;
					if ( ( position.top + myOffset + atOffset + offset) > overTop && ( newOverBottom < 0 || newOverBottom < Math.abs( overTop ) ) ) {
						position.top += myOffset + atOffset + offset;
					}
				}
				else if ( overBottom > 0 ) {
					newOverTop = position.top -  data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;
					if ( ( position.top + myOffset + atOffset + offset) > overBottom && ( newOverTop > 0 || Math.abs( newOverTop ) < overBottom ) ) {
						position.top += myOffset + atOffset + offset;
					}
				}
			}
		},
		flipfit: {
			left: function() {
				_pos_jQueryUI110.flip.left.apply( this, arguments );
				_pos_jQueryUI110.fit.left.apply( this, arguments );
			},
			top: function() {
				_pos_jQueryUI110.flip.top.apply( this, arguments );
				_pos_jQueryUI110.fit.top.apply( this, arguments );
			}
		}
	};
	
	jQuery.ui.position._sapUiCommonsMenuFlip = {
		left: function(position, data){
			
			if (jQuery.ui.position.flipfit) { //jQuery UI 1.9 ff.
				jQuery.ui.position.flipfit.left.apply(this, arguments);
				return;
			}
			
			//jQuery UI 1.8
			data = _migrateDataTojQueryUI110(data);
			_pos_jQueryUI110.flipfit.left.apply(this, arguments);
		},
		top: function(position, data){
			
			if (jQuery.ui.position.flipfit) { //jQuery UI 1.9 ff.
				jQuery.ui.position.flipfit.top.apply(this, arguments);
				return;
			}
			
			//jQuery UI 1.8
			data = _migrateDataTojQueryUI110(data);
			_pos_jQueryUI110.flipfit.top.apply(this, arguments);
		}
	};
	
	//******************** jQuery UI 1.10.3 End **************************
	
	
	})(window);
	

	return Menu;

}, /* bExport= */ true);

}; // end of sap/ui/unified/Menu.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.MenuItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.MenuItem.
jQuery.sap.declare('sap.ui.unified.MenuItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/MenuItem",['jquery.sap.global', 'sap/ui/core/IconPool', './MenuItemBase', './library'],
	function(jQuery, IconPool, MenuItemBase, library) {
	"use strict";


	
	/**
	 * Constructor for a new MenuItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Smallest unit in the menu hierarchy. An item can be a direct part of a menu bar, of a menu, or of a sub menu.
	 * @extends sap.ui.unified.MenuItemBase
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.unified.MenuItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MenuItem = MenuItemBase.extend("sap.ui.unified.MenuItem", /** @lends sap.ui.unified.MenuItem.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * 
			 * Item text
			 */
			text : {type : "string", group : "Appearance", defaultValue : ''},
	
			/**
			 * 
			 * Icon to be displayed
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''}
		}
	}});
	
	IconPool.getIconInfo("", ""); //Ensure Icon Font is loaded
	
	MenuItem.prototype.render = function(oRenderManager, oItem, oMenu, oInfo){
		var rm = oRenderManager;
		var oSubMenu = oItem.getSubmenu();
		rm.write("<li ");
		
		var sClass = "sapUiMnuItm";
		if (oInfo.iItemNo == 1) {
			sClass += " sapUiMnuItmFirst";
		} else if (oInfo.iItemNo == oInfo.iTotalItems) {
			sClass += " sapUiMnuItmLast";
		}
		if (!oMenu.checkEnabled(oItem)) {
			sClass += " sapUiMnuItmDsbl";
		}
		if (oItem.getStartsSection()) {
			sClass += " sapUiMnuItmSepBefore";
		}
		
		rm.writeAttribute("class", sClass);
		if (oItem.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oItem.getTooltip_AsString());
		}
		rm.writeElementData(oItem);
	
		// ARIA
		if (oInfo.bAccessible) {
			rm.writeAccessibilityState(oMenu, { //Pass the Menu here to write aria-labelledby
				role: "menuitem",
				disabled: !oMenu.checkEnabled(oItem),
				posinset: oInfo.iItemNo,
				setsize: oInfo.iTotalItems,
				labelledby: {value: oMenu.getId() + "-label " + this.getId() + "-txt " + this.getId() + "-scuttxt", append: true}
			});
			if (oSubMenu) {
				rm.writeAttribute("aria-haspopup", true);
				rm.writeAttribute("aria-owns", oSubMenu.getId());
			}
		}
	
		// Left border
		rm.write("><div class=\"sapUiMnuItmL\"></div>");
	
		// icon/check column
		rm.write("<div class=\"sapUiMnuItmIco\">");
		if (oItem.getIcon()) {
			rm.writeIcon(oItem.getIcon());
		}
		rm.write("</div>");
	
		// Text column
		rm.write("<div id=\"" + this.getId() + "-txt\" class=\"sapUiMnuItmTxt\">");
		rm.writeEscaped(oItem.getText());
		rm.write("</div>");
	
		// Shortcut column
		rm.write("<div id=\"" + this.getId() + "-scuttxt\" class=\"sapUiMnuItmSCut\"></div>");
	
		// Submenu column
		rm.write("<div class=\"sapUiMnuItmSbMnu\">");
		if (oSubMenu) {
			rm.write("<div class=\"sapUiIconMirrorInRTL\"></div>");
		}
		rm.write("</div>");
	
		// Right border
		rm.write("<div class=\"sapUiMnuItmR\"></div>");
	
		rm.write("</li>");
	};
	
	/**
	 * @protected
	 */
	MenuItem.prototype.hover = function(bHovered, oMenu){
		this.$().toggleClass("sapUiMnuItmHov", bHovered);
	};

	return MenuItem;

}, /* bExport= */ true);

}; // end of sap/ui/unified/MenuItem.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellLayout') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.ShellLayout.
jQuery.sap.declare('sap.ui.unified.ShellLayout'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellLayout",['jquery.sap.global', 'sap/ui/Device', 'sap/ui/core/Control', 'sap/ui/core/Popup', 'sap/ui/core/theming/Parameters', './SplitContainer', './library', 'jquery.sap.dom', 'jquery.sap.script'],
	function(jQuery, Device, Control, Popup, Parameters, SplitContainer, library/* , jQuerySap1, jQuerySap */) {
	"use strict";


	
	/**
	 * Constructor for a new ShellLayout.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The shell layout is the base for the shell control which is meant as root control (full-screen) of an application.
	 * It was build as root control of the Fiori Launchpad application and provides the basic capabilities
	 * for this purpose. Do not use this control within applications which run inside the Fiori Lauchpad and
	 * do not use it for other scenarios than the root control usecase.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.25.0
	 * @alias sap.ui.unified.ShellLayout
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ShellLayout = Control.extend("sap.ui.unified.ShellLayout", /** @lends sap.ui.unified.ShellLayout.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * Shows / Hides the side pane.
			 */
			showPane : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * Whether the header can be hidden (manually or automatically). This feature is only available when touch events are supported.
			 */
			headerHiding : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * If set to false, no header (and no items, search, ...) is shown.
			 */
			headerVisible : {type : "boolean", group : "Appearance", defaultValue : true}
		},
		defaultAggregation : "content",
		aggregations : {
	
			/**
			 * The content to appear in the main canvas.
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
	
			/**
			 * The content to appear in the pane area.
			 */
			paneContent : {type : "sap.ui.core.Control", multiple : true, singularName : "paneContent"}, 
	
			/**
			 * The control to appear in the header area.
			 */
			header : {type : "sap.ui.core.Control", multiple : false}, 
	
			/**
			 * Private storage for the internal split container for the canvas.
			 */
			canvasSplitContainer : {type : "sap.ui.unified.SplitContainer", multiple : false, visibility : "hidden"}, 
	
			/**
			 * Private storage for the internal split container for the curtain.
			 */
			curtainSplitContainer : {type : "sap.ui.unified.SplitContainer", multiple : false, visibility : "hidden"}
		}
	}});
	
	
	ShellLayout._SIDEPANE_WIDTH_PHONE = 208;
	ShellLayout._SIDEPANE_WIDTH_TABLET = 208;
	ShellLayout._SIDEPANE_WIDTH_DESKTOP = 240;
	ShellLayout._HEADER_ALWAYS_VISIBLE = true; /*Whether header hiding is technically possible (touch enabled)*/
	ShellLayout._HEADER_AUTO_CLOSE = true;
	ShellLayout._HEADER_TOUCH_TRESHOLD = 15;
	if (Device.browser.chrome && Device.browser.version < 36) {
		//see https://groups.google.com/a/chromium.org/forum/#!topic/input-dev/Ru9xjSsvLHw --> chrome://flags/#touch-scrolling-mode
		ShellLayout._HEADER_TOUCH_TRESHOLD = 10;
	}
		
	ShellLayout.prototype.init = function(){
		this._rtl = sap.ui.getCore().getConfiguration().getRTL();
		this._animation = sap.ui.getCore().getConfiguration().getAnimation();
		this._showHeader = true;
		this._showCurtain = false;
		this._iHeaderHidingDelay = 3000; /*Currently hidden but maybe a property later (see getter and setter below)*/
		this._useStrongBG = false;
		
		this._cont = new SplitContainer(this.getId() + "-container");
		this._cont._bRootContent = true; // see e.g. sap.m.App#onAfterRendering
		this.setAggregation("canvasSplitContainer", this._cont, true);
		
		this._curtCont = new SplitContainer(this.getId() + "-curt-container");
		this._curtCont._bRootContent = true; // see e.g. sap.m.App#onAfterRendering
		this.setAggregation("curtainSplitContainer", this._curtCont, true);
		
		this._setSidePaneWidth();
	
		Device.media.attachHandler(this._handleMediaChange, this, Device.media.RANGESETS.SAP_STANDARD);
		Device.resize.attachHandler(this._handleResizeChange, this);
	};
	
	ShellLayout.prototype.exit = function(){
		Device.media.detachHandler(this._handleMediaChange, this, Device.media.RANGESETS.SAP_STANDARD);
		Device.resize.detachHandler(this._handleResizeChange, this);
		
		delete this._cont; //Destroy of child controls done via aggregation handling
		delete this._curtCont;
	};
	
	ShellLayout.prototype.onAfterRendering = function(){
		var that = this;
	
		function headerFocus(oBrowserEvent){
			var oEvent = jQuery.event.fix(oBrowserEvent);
			if (jQuery.sap.containsOrEquals(that.getDomRef("hdr"), oEvent.target)) {
				that._timedHideHeader(oEvent.type === "focus");
			}
		}
		
		if (window.addEventListener && !ShellLayout._HEADER_ALWAYS_VISIBLE) {
			var oHdr = this.getDomRef("hdr");
			oHdr.addEventListener("focus", headerFocus, true);
			oHdr.addEventListener("blur", headerFocus, true);
		}
		
		this._refreshAfterRendering();
	};
	
	ShellLayout.prototype.onThemeChanged = function(){
		this._refreshAfterRendering();
	};
	
	ShellLayout.prototype.onfocusin = function(oEvent) {
		var sId = this.getId();
		
		if (oEvent.target.id === sId + "-curt-focusDummyOut") {
			// Jump back to shell when you reach the end of the curtain
			jQuery.sap.focus(this.$("hdrcntnt").firstFocusableDomRef());
		} else if (oEvent.target.id === sId + "-main-focusDummyOut") {
			// Jump to the curtain if it is open (can only reached by tabbing back when curtain is open)
			jQuery.sap.focus(this.$("curtcntnt").firstFocusableDomRef());
		}
	};
	
	(function(){
	
		function _updateHeader(oShell){
			if (oShell._startY === undefined || oShell._currY === undefined) {
				return;
			}
			
			var yMove = oShell._currY - oShell._startY;
			if (Math.abs(yMove) > ShellLayout._HEADER_TOUCH_TRESHOLD) {
				oShell._doShowHeader(yMove > 0);
				oShell._startY = oShell._currY;
			}
		}
	
		if (Device.support.touch) {
			
			ShellLayout._HEADER_ALWAYS_VISIBLE = false;
			
			ShellLayout.prototype.ontouchstart = function(oEvent){
				this._startY = oEvent.touches[0].pageY;
				if (this._startY > 2 * 48) { /*Only when touch starts "nearby" the header*/
					this._startY = undefined;
				}
				this._currY = this._startY;
			};
			
			ShellLayout.prototype.ontouchend = function(oEvent){
				_updateHeader(this);
				this._startY = undefined;
				this._currY = undefined;
			};
			
			ShellLayout.prototype.ontouchcancel = ShellLayout.prototype.ontouchend;
			
			ShellLayout.prototype.ontouchmove = function(oEvent){
				this._currY = oEvent.touches[0].pageY;
				_updateHeader(this);
			};
			
		}
	
	})();
	
	
	//***************** API / Overridden generated API *****************
	
	ShellLayout.prototype.setHeaderHiding = function(bEnabled){
		bEnabled = !!bEnabled;
		return this._mod(function(bRendered){
			return this.setProperty("headerHiding", bEnabled, bRendered);
		}, function(){
			this._doShowHeader(!bEnabled ? true : this._showHeader);
		});
	};
	
	/*Not public, Maybe API later*/
	ShellLayout.prototype.setHeaderHidingDelay = function(iDelay){
		this._iHeaderHidingDelay = iDelay;
		return this;
	};
	
	/*Not public, Maybe API later*/
	ShellLayout.prototype.getHeaderHidingDelay = function(){
		return this._iHeaderHidingDelay;
	};
	
	ShellLayout.prototype.getShowPane = function(){
		return this._cont.getShowSecondaryContent();
	};
	
	ShellLayout.prototype.setShowPane = function(bShowPane){
		this._cont.setShowSecondaryContent(bShowPane);
		this.setProperty("showPane", !!bShowPane, true);
		return this;
	};
	
	/*Not public, deprecated*/
	ShellLayout.prototype.setShowCurtainPane = function(bShowPane){
		this._curtCont.setShowSecondaryContent(bShowPane);
		return this;
	};
	
	/*Not public, deprecated*/
	ShellLayout.prototype.getShowCurtainPane = function(){
		return this._curtCont.getShowSecondaryContent();
	};
	
	ShellLayout.prototype.setHeaderVisible = function(bHeaderVisible){
		bHeaderVisible = !!bHeaderVisible;
		this.setProperty("headerVisible", bHeaderVisible, true);
		this.$().toggleClass("sapUiUfdShellNoHead", !bHeaderVisible);
		return this;
	};
	
	/*Not public, deprecated*/
	ShellLayout.prototype.setShowCurtain = function(bShowCurtain){
		bShowCurtain = !!bShowCurtain;
		
		return this._mod(function(bRendered){
			this._showCurtain = bShowCurtain;
			return this;
		}, function(){
			this.$("main-focusDummyOut").attr("tabindex", bShowCurtain ? 0 : -1);
			this.$().toggleClass("sapUiUfdShellCurtainHidden", !bShowCurtain).toggleClass("sapUiUfdShellCurtainVisible", bShowCurtain);
			
			if (bShowCurtain) {
				var zIndex = Popup.getNextZIndex();
				this.$("curt").css("z-index", zIndex + 1);
				this.$("hdr").css("z-index", zIndex + 3);
				this.$("brand").css("z-index", zIndex + 7);
				this.$().toggleClass("sapUiUfdShellCurtainClosed", false);
			}
			
			this._timedCurtainClosed(bShowCurtain);
			
			this._doShowHeader(true);
		});
	};
	
	/*Not public, deprecated*/
	ShellLayout.prototype.getShowCurtain = function(){
		return this._showCurtain;
	};
	
	
	ShellLayout.prototype.getContent = function() {
		return this._cont.getContent();
	};
	ShellLayout.prototype.insertContent = function(oContent, iIndex) {
		this._cont.insertContent(oContent, iIndex);
		return this;
	};
	ShellLayout.prototype.addContent = function(oContent) {
		this._cont.addContent(oContent);
		return this;
	};
	ShellLayout.prototype.removeContent = function(vIndex) {
		return this._cont.removeContent(vIndex);
	};
	ShellLayout.prototype.removeAllContent = function() {
		return this._cont.removeAllContent();
	};
	ShellLayout.prototype.destroyContent = function() {
		this._cont.destroyContent();
		return this;
	};
	ShellLayout.prototype.indexOfContent = function(oContent) {
		return this._cont.indexOfContent(oContent);
	};
	
	
	ShellLayout.prototype.getPaneContent = function() {
		return this._cont.getSecondaryContent();
	};
	ShellLayout.prototype.insertPaneContent = function(oContent, iIndex) {
		this._cont.insertSecondaryContent(oContent, iIndex);
		return this;
	};
	ShellLayout.prototype.addPaneContent = function(oContent) {
		this._cont.addSecondaryContent(oContent);
		return this;
	};
	ShellLayout.prototype.removePaneContent = function(vIndex) {
		return this._cont.removeSecondaryContent(vIndex);
	};
	ShellLayout.prototype.removeAllPaneContent = function() {
		return this._cont.removeAllSecondaryContent();
	};
	ShellLayout.prototype.destroyPaneContent = function() {
		this._cont.destroySecondaryContent();
		return this;
	};
	ShellLayout.prototype.indexOfPaneContent = function(oContent) {
		return this._cont.indexOfSecondaryContent(oContent);
	};
	
	
	ShellLayout.prototype.setHeader = function(oHeader) {
		this.setAggregation("header", oHeader, true);
		oHeader = this.getHeader();
		if (this.getDomRef()) {
			if (!oHeader) {
				this.$("hdrcntnt").html("");
			} else {
				var rm = sap.ui.getCore().createRenderManager();
				rm.renderControl(oHeader);
				rm.flush(this.getDomRef("hdrcntnt"));
				rm.destroy();
			}
		}
		return this;
	};
	ShellLayout.prototype.destroyHeader = function() {
		this.destroyAggregation("header", true);
		this.$("hdrcntnt").html("");
		return this;
	};
	
	
	/*Not public, deprecated*/
	ShellLayout.prototype.getCurtainContent = function() {
		return this._curtCont.getContent();
	};
	ShellLayout.prototype.insertCurtainContent = function(oContent, iIndex) {
		this._curtCont.insertContent(oContent, iIndex);
		return this;
	};
	ShellLayout.prototype.addCurtainContent = function(oContent) {
		this._curtCont.addContent(oContent);
		return this;
	};
	ShellLayout.prototype.removeCurtainContent = function(vIndex) {
		return this._curtCont.removeContent(vIndex);
	};
	ShellLayout.prototype.removeAllCurtainContent = function() {
		return this._curtCont.removeAllContent();
	};
	ShellLayout.prototype.destroyCurtainContent = function() {
		this._curtCont.destroyContent();
		return this;
	};
	ShellLayout.prototype.indexOfCurtainContent = function(oContent) {
		return this._curtCont.indexOfCurtainContent(oContent);
	};
	
	
	/*Not public, deprecated*/
	ShellLayout.prototype.getCurtainPaneContent = function() {
		return this._curtCont.getSecondaryContent();
	};
	ShellLayout.prototype.insertCurtainPaneContent = function(oContent, iIndex) {
		this._curtCont.insertSecondaryContent(oContent, iIndex);
		return this;
	};
	ShellLayout.prototype.addCurtainPaneContent = function(oContent) {
		this._curtCont.addSecondaryContent(oContent);
		return this;
	};
	ShellLayout.prototype.removeCurtainPaneContent = function(vIndex) {
		return this._curtCont.removeSecondaryContent(vIndex);
	};
	ShellLayout.prototype.removeAllCurtainPaneContent = function() {
		return this._curtCont.removeAllSecondaryContent();
	};
	ShellLayout.prototype.destroyCurtainPaneContent = function() {
		this._curtCont.destroySecondaryContent();
		return this;
	};
	ShellLayout.prototype.indexOfCurtainPaneContent = function(oContent) {
		return this._curtCont.indexOfSecondaryContent(oContent);
	};
	
	
	/*Restricted API for Launchpad to set a Strong BG style*/
	ShellLayout.prototype._setStrongBackground = function(bUseStongBG){
		this._useStrongBG = !!bUseStongBG;
		this.$("strgbg").toggleClass("sapMGlobalBackgroundColorStrong", this._useStrongBG);
	};
	
	
	//***************** Private Helpers *****************
	
	ShellLayout.prototype._mod = function(fMod, oDoIfRendered){
		var bRendered = !!this.getDomRef();
		var res = fMod.apply(this, [bRendered]);
		if (bRendered && oDoIfRendered) {
			if (oDoIfRendered instanceof sap.ui.unified._ContentRenderer) {
				oDoIfRendered.render();
			} else {
				oDoIfRendered.apply(this);
			}
		}
		return res;
	};
	
	ShellLayout.prototype._doShowHeader = function(bShow){
		var bWasVisible = this._showHeader;
		this._showHeader = this._isHeaderHidingActive() ? !!bShow : true;
		
		this.$().toggleClass("sapUiUfdShellHeadHidden", !this._showHeader).toggleClass("sapUiUfdShellHeadVisible", this._showHeader);
		
		if (this._showHeader) {
			this._timedHideHeader();
		}
		
		if (bWasVisible != this._showHeader && this._isHeaderHidingActive()){
			jQuery.sap.delayedCall(500, this, function(){
				try {
					var oResizeEvent = document.createEvent("UIEvents");
					oResizeEvent.initUIEvent("resize", true, false, window, 0);
					window.dispatchEvent(oResizeEvent);
				} catch(e) {
					jQuery.sap.log.error(e);
				}
			});
		}
	};
	
	ShellLayout.prototype._timedHideHeader = function(bClearOnly){
		if (this._headerHidingTimer) {
			jQuery.sap.clearDelayedCall(this._headerHidingTimer);
			this._headerHidingTimer = null;
		}
		
		if (bClearOnly || !ShellLayout._HEADER_AUTO_CLOSE || !this._isHeaderHidingActive() || this._iHeaderHidingDelay <= 0) {
			return;
		}
		
		this._headerHidingTimer = jQuery.sap.delayedCall(this._iHeaderHidingDelay, this, function(){
			if (this._isHeaderHidingActive() && this._iHeaderHidingDelay > 0 && !jQuery.sap.containsOrEquals(this.getDomRef("hdr"), document.activeElement)) {
				this._doShowHeader(false);
			}
		});
	};
	
	ShellLayout.prototype._timedCurtainClosed = function(bClearOnly){
		if (this._curtainClosedTimer) {
			jQuery.sap.clearDelayedCall(this._curtainClosedTimer);
			this._curtainClosedTimer = null;
		}
		
		if (bClearOnly) {
			return;
		}
		
		var duration = parseInt(Parameters.get("sapUiUfdShellAnimDuration"), 10);
		if (!this._animation || (Device.browser.internet_explorer && Device.browser.version < 10)) {
			duration = 0;
		}
		
		this._curtainClosedTimer = jQuery.sap.delayedCall(duration, this, function(){
			this._curtainClosedTimer = null;
			this.$("curt").css("z-index", "");
			this.$("hdr").css("z-index", "");
			this.$("brand").css("z-index", "");
			this.$().toggleClass("sapUiUfdShellCurtainClosed", true);
		});
	};
	
	ShellLayout.prototype._isHeaderHidingActive = function(){
		// Not active if no touch, the curtain is open or the hiding is deactivated via API
		if (ShellLayout._HEADER_ALWAYS_VISIBLE || this.getShowCurtain() || !this.getHeaderHiding() || sap.ui.unified._iNumberOfOpenedShellOverlays > 0 || !this.getHeaderVisible()) {
			return false;
		}
		return true;
	};
	
	ShellLayout.prototype._refreshCSSWorkaround = function() {
		if (!Device.browser.webkit || !Device.support.touch) {
			return;
		}
		
		if (this._cssWorkaroundTimer) {
			jQuery.sap.clearDelayedCall(this._cssWorkaroundTimer);
			this._cssWorkaroundTimer = null;
		}
		this.$("css").remove();
	
		this._cssWorkaroundTimer = jQuery.sap.delayedCall(10, this, function(){
			this._cssWorkaroundTimer = null;
			jQuery.sap.log.debug("sap.ui.unified.ShellLayout: CSS Workaround applied.");
			jQuery("head").append("<link type='text/css' rel='stylesheet' id='" + this.getId() + "-css' href='data:text/css;base64,LnNhcFVpVWZkU2hlbGxDaHJvbWVSZXBhaW50e291dGxpbmUtY29sb3I6aW5pdGlhbDt9'/>");
			this._cssWorkaroundTimer = jQuery.sap.delayedCall(100, this, function(){
				this.$("css").remove();
			});
		});
	};
	
	ShellLayout.prototype._setSidePaneWidth = function(sRange){
		if (!sRange) {
			sRange = Device.media.getCurrentRange(Device.media.RANGESETS.SAP_STANDARD).name;
		}
		
		var w = ShellLayout["_SIDEPANE_WIDTH_" + sRange.toUpperCase()] + "px";
		this._cont.setSecondaryContentSize(w);
		this._curtCont.setSecondaryContentSize(w);
	};
	
	ShellLayout.prototype._handleMediaChange = function(mParams){
		if (!this.getDomRef()) {
			return false;
		}
		
		this._setSidePaneWidth(mParams.name);
	};
	
	ShellLayout.prototype._handleResizeChange = function(mParams){
		//Nothing to do here, maybe in subclass
	};
	
	ShellLayout.prototype._refreshAfterRendering = function(){
		var oDom = this.getDomRef();
		
		if (!oDom) {
			return false;
		}
	
		this._repaint(oDom);
		this._timedHideHeader();
		
		return true;
	};
	
	ShellLayout.prototype._repaint = function(oDom){
		if (Device.browser.webkit) {
			var display = oDom.style.display;
			oDom.style.display = "none";
			oDom.offsetHeight;
			oDom.style.display = display;
			
			this._refreshCSSWorkaround();
		}
	};
	
	//Needed by sap.ui.unified.ShellOverlay
	ShellLayout.prototype._getSearchWidth = function(){
		return -1;
	};

	return ShellLayout;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.Shell') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.Shell.
jQuery.sap.declare('sap.ui.unified.Shell'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/Shell",['jquery.sap.global', './ShellHeader', './ShellLayout', './library'],
	function(jQuery, ShellHeader, ShellLayout, library) {
	"use strict";


	
	/**
	 * Constructor for a new Shell.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The shell control is meant as root control (full-screen) of an application.
	 * It was build as root control of the Fiori Launchpad application and provides the basic capabilities
	 * for this purpose. Do not use this control within applications which run inside the Fiori Lauchpad and
	 * do not use it for other scenarios than the root control usecase.
	 * @extends sap.ui.unified.ShellLayout
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.15.1
	 * @alias sap.ui.unified.Shell
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Shell = ShellLayout.extend("sap.ui.unified.Shell", /** @lends sap.ui.unified.Shell.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		properties : {
	
			/**
			 * The application icon. If a custom header is set this property has no effect.
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
	
			/**
			 * Shows / Hides the curtain.
			 * @deprecated Since version 1.16.3. 
			 * Curtain is deprecated and replaced by ShellOverlay mechanism.
			 */
			showCurtain : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true},
	
			/**
			 * Shows / Hides the side pane on the curtain.
			 * @deprecated Since version 1.16.3. 
			 * Curtain is deprecated and replaced by ShellOverlay mechanism.
			 */
			showCurtainPane : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true},
	
			/**
			 * If set to false, the search area (aggregation 'search') is hidden. If a custom header is set this property has no effect.
			 * @since 1.18
			 */
			searchVisible : {type : "boolean", group : "Appearance", defaultValue : true}
		},
		aggregations : {
	
			/**
			 * The content to appear in the curtain area.
			 */
			curtainContent : {type : "sap.ui.core.Control", multiple : true, singularName : "curtainContent"}, 
	
			/**
			 * The content to appear in the pane area of the curtain.
			 */
			curtainPaneContent : {type : "sap.ui.core.Control", multiple : true, singularName : "curtainPaneContent"}, 
	
			/**
			 * The buttons shown in the begin (left in left-to-right case) of the Shell header. Currently max. 3 visible buttons are supported. If a custom header is set this aggregation has no effect.
			 */
			headItems : {type : "sap.ui.unified.ShellHeadItem", multiple : true, singularName : "headItem"}, 
	
			/**
			 * The buttons shown in the end (right in left-to-right case) of the Shell header. Currently max. 3 visible buttons are supported (when user is set only 1). If a custom header is set this aggregation has no effect.
			 */
			headEndItems : {type : "sap.ui.unified.ShellHeadItem", multiple : true, singularName : "headEndItem"}, 
	
			/**
			 * Experimental (This aggregation might change in future!): The search control which should be displayed in the shell header. If a custom header is set this aggregation has no effect.
			 */
			search : {type : "sap.ui.core.Control", multiple : false}, 
	
			/**
			 * The user item which is rendered in the shell header beside the items. If a custom header is set this aggregation has no effect.
			 * @since 1.22.0
			 */
			user : {type : "sap.ui.unified.ShellHeadUserItem", multiple : false}
		}
	}});
	
		
	Shell.prototype.init = function(){
		ShellLayout.prototype.init.apply(this, arguments);
		this._header = new ShellHeader(this.getId() + "-header");
		this.setHeader(this._header);
	};
	
	Shell.prototype.exit = function(){
		ShellLayout.prototype.exit.apply(this, arguments);
		this._header.destroy();
		delete this._header;
	};
	
	//Needed by sap.ui.unified.ShellOverlay
	Shell.prototype._getSearchWidth = function(){
		if (this._header === this.getHeader() && this._header.getDomRef()) {
			var $ShellSearchArea = this._header.$("hdr-center").children();
			if ($ShellSearchArea.length) {
				return $ShellSearchArea.width();
			}
		}
		return -1;
	};
	
	
	// ***************** API / Overridden generated API *****************
	
	Shell.prototype.setIcon = function(sIcon){
		this.setProperty("icon", sIcon, true);
		this._header.setLogo(sIcon);
		return this;
	};
	
	Shell.prototype.getIcon = function(){
		return this._header.getLogo();
	};
	
	Shell.prototype.setSearchVisible = function(bSearchVisible){
		this.setProperty("searchVisible", bSearchVisible, true);
		this._header.setSearchVisible(bSearchVisible);
		return this;
	};
	
	Shell.prototype.getSearchVisible = function(){
		return this._header.getSearchVisible();
	};
	
	Shell.prototype.setSearch = function(oSearch){
		this._header.setSearch(oSearch);
		return this;
	};
	
	Shell.prototype.getSearch = function(){
		return this._header.getSearch();
	};
	
	Shell.prototype.setUser = function(oUser){
		this._header.setUser(oUser);
		return this;
	};
	
	Shell.prototype.getUser = function(){
		return this._header.getUser();
	};
	
	Shell.prototype.getHeadItems = function() {
		return this._header.getHeadItems();
	};
	Shell.prototype.insertHeadItem = function(oHeadItem, iIndex) {
		this._header.insertHeadItem(oHeadItem, iIndex);
		return this;
	};
	Shell.prototype.addHeadItem = function(oHeadItem) {
		this._header.addHeadItem(oHeadItem);
		return this;
	};
	Shell.prototype.removeHeadItem = function(vIndex) {
		return this._header.removeHeadItem(vIndex);
	};
	Shell.prototype.removeAllHeadItems = function() {
		return this._header.removeAllHeadItems();
	};
	Shell.prototype.destroyHeadItems = function() {
		this._header.destroyHeadItems();
		return this;
	};
	Shell.prototype.indexOfHeadtem = function(oHeadItem) {
		return this._header.indexOfHeadItem(oHeadItem);
	};
	
	
	Shell.prototype.getHeadEndItems = function() {
		return this._header.getHeadEndItems();
	};
	Shell.prototype.insertHeadEndItem = function(oHeadItem, iIndex) {
		this._header.insertHeadEndItem(oHeadItem, iIndex);
		return this;
	};
	Shell.prototype.addHeadEndItem = function(oHeadItem) {
		this._header.addHeadEndItem(oHeadItem);
		return this;
	};
	Shell.prototype.removeHeadEndItem = function(vIndex) {
		return this._header.removeHeadEndItem(vIndex);
	};
	Shell.prototype.removeAllHeadEndItems = function() {
		return this._header.removeAllHeadEndItems();
	};
	Shell.prototype.destroyHeadEndItems = function() {
		this._header.destroyHeadEndItems();
		return this;
	};
	Shell.prototype.indexOfHeadEndItem = function(oHeadItem) {
		return this._header.indexOfHeadEndItem(oHeadItem);
	};
	
	
	/**
	 * Setter for the aggregated <code>header</code>.
	 * 
	 * @param {sap.ui.core.Control} oHeader The Control which should be rendered within the Shell header or <code>null</code> to render the default Shell header.
	 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
	 * @public
	 */
	Shell.prototype.setHeader = function(oHeader) {
		return ShellLayout.prototype.setHeader.apply(this, [oHeader ? oHeader : this._header]);
	};
	
	/**
	 * Destroys the header in the aggregation named <code>header</code>, but only if a custom header is set.
	 * The default header can not be destroyed.
	 * 
	 * @return {sap.ui.unified.Shell} <code>this</code> to allow method chaining
	 * @public
	 */
	Shell.prototype.destroyHeader = function() {
		if (this.getHeader() === this._header) {
			return this;
		}
		return ShellLayout.prototype.destroyHeader.apply(this, []);
	};

	return Shell;

}, /* bExport= */ true);

}; // end of sap/ui/unified/Shell.js
if ( !jQuery.sap.isDeclared('sap.ui.unified.ShellOverlay') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.unified.ShellOverlay.
jQuery.sap.declare('sap.ui.unified.ShellOverlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained
sap.ui.define("sap/ui/unified/ShellOverlay",['jquery.sap.global', 'sap/ui/Device', 'sap/ui/core/Control', 'sap/ui/core/Popup', './Shell', './library', 'jquery.sap.script'],
	function(jQuery, Device, Control, Popup, Shell, library/* , jQuerySap */) {
	"use strict";


	
	/**
	 * Constructor for a new ShellOverlay.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ShellOverlay to be opened in front of a sap.ui.unified.Shell
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.26.7
	 *
	 * @constructor
	 * @public
	 * @since 1.16.3
	 * @alias sap.ui.unified.ShellOverlay
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ShellOverlay = Control.extend("sap.ui.unified.ShellOverlay", /** @lends sap.ui.unified.ShellOverlay.prototype */ { metadata : {
	
		library : "sap.ui.unified",
		defaultAggregation : "content",
		aggregations : {
	
			/**
			 * The content to appear in the overlay.
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
	
			/**
			 * Experimental (This aggregation might change in future!): The search control which should be displayed in the overlay header.
			 */
			search : {type : "sap.ui.core.Control", multiple : false}
		},
		associations : {
	
			/**
			 * Reference to the sap.ui.unified.Shell or sap.ui.unified.ShellLayout control.
			 */
			shell : {type : "sap.ui.unified.ShellLayout", multiple : false}
		},
		events : {
	
			/**
			 * Fired when the overlay was closed.
			 */
			closed : {}
		}
	}});
	
	
	/**** API ****/
	
	/**
	 * Opens the ShellOverlay.
	 *
	 * @public
	 */
	ShellOverlay.prototype.open = function(){
		if (this._getPopup().isOpen()) {
			return;
		}
	
		this._opening = true;
		this._forceShellHeaderVisible();
		this._getPopup().setModal(true, Popup.blStack.length == 0 && this._getAnimActive() ? "sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp" : "");
		this._getPopup().open(0, Popup.Dock.BeginTop, Popup.Dock.BeginTop, window, "0 0", "none");
		var oSearch = this.getSearch();
		if (oSearch) {
			oSearch.focus();
		}
		this._opening = false;
		
		if (this._getAnimActive()) {
			jQuery.sap.delayedCall(50, this, function(){
				jQuery.sap.byId("sap-ui-blocklayer-popup").toggleClass("sapUiUfdShellOvrlyBlyTp", false);
			});
		}
		
		jQuery.sap.delayedCall(this._getAnimDuration(true), this, function(){
			this.$().toggleClass("sapUiUfdShellOvrlyOpening", false);
		});
	};
	
	/**
	 * Closes the ShellOverlay.
	 *
	 * @public
	 */
	ShellOverlay.prototype.close = function(){
		if (!this._getPopup().isOpen()) {
			return;
		}
		
		this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden", true).toggleClass("sapUiUfdShellOvrlyClosing", true);
		
		this._setSearchWidth();
		
		jQuery.sap.delayedCall(Math.max(this._getAnimDuration(false) - this._getBLAnimDuration(), 0), this, function(){
			var $Bl = jQuery.sap.byId("sap-ui-blocklayer-popup");
			if (Popup.blStack.length == 1 && this._getAnimActive() && $Bl.hasClass("sapUiUfdShellOvrlyBly")) {
				$Bl.toggleClass("sapUiUfdShellOvrlyBlyTp", true);
			}
		});
		
		jQuery.sap.delayedCall(this._getAnimDuration(false), this, function(){
			this._getPopup().close(0);
			this.$().remove();
			this._forceShellHeaderVisible();
			this.fireClosed();
		});
	};
	
	ShellOverlay.prototype.setShell = function(vShell){
		return this.setAssociation("shell", vShell, true);
	};
	
	ShellOverlay.prototype.setSearch = function(oSearch){
		this.setAggregation("search", oSearch, true);
		if (!!this.getDomRef()) {
			this._headRenderer.render();
		}
		return this;
	};
	
	ShellOverlay.prototype.insertContent = function(oContent, iIndex) {
		var res = this.insertAggregation("content", oContent, iIndex, true);
		if (!!this.getDomRef()) {
			this._contentRenderer.render();
		}
		return res;
	};
	ShellOverlay.prototype.addContent = function(oContent) {
		var res = this.addAggregation("content", oContent, true);
		if (!!this.getDomRef()) {
			this._contentRenderer.render();
		}
		return res;
	};
	ShellOverlay.prototype.removeContent = function(vIndex) {
		var res = this.removeAggregation("content", vIndex, true);
		if (!!this.getDomRef()) {
			this._contentRenderer.render();
		}
		return res;
	};
	ShellOverlay.prototype.removeAllContent = function() {
		var res = this.removeAllAggregation("content", true);
		if (!!this.getDomRef()) {
			this._contentRenderer.render();
		}
		return res;
	};
	ShellOverlay.prototype.destroyContent = function() {
		var res = this.destroyAggregation("content", true);
		if (!!this.getDomRef()) {
			this._contentRenderer.render();
		}
		return res;
	};
	
	
	/**** Private ****/
	
	ShellOverlay.prototype.init = function(){
		this._animOpenDuration = -1;
		this._animCloseDuration = -1;
		this._animBlockLayerDuration = -1;
		this._animation = sap.ui.getCore().getConfiguration().getAnimation();
		this._opening = false;
		
		var that = this;
		
		this._headRenderer = new sap.ui.unified._ContentRenderer(this, this.getId() + "-hdr-center", function(rm){
			sap.ui.unified.ShellOverlayRenderer.renderSearch(rm, that);
		});
		this._contentRenderer = new sap.ui.unified._ContentRenderer(this, this.getId() + "-cntnt", function(rm){
			sap.ui.unified.ShellOverlayRenderer.renderContent(rm, that);
		});
	};
	
	ShellOverlay.prototype.exit = function(){
		if (this._popup) {
			this._popup.close(0);
			this._popup.destroy();
			this._popup = null;
		}
		
		this._getPopup = function(){return null;};
		this._headRenderer.destroy();
		delete this._headRenderer;
		this._contentRenderer.destroy();
		delete this._contentRenderer;
	};
	
	ShellOverlay.prototype.onAfterRendering = function(){
		if (this._opening) {
			this._setSearchWidth();
		}
		
		jQuery.sap.delayedCall(10, this, function(){
			this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden", false);
			this.$("search").css("width", "");
		});
	};
	
	ShellOverlay.prototype.onclick = function(oEvent){
		if (jQuery(oEvent.target).attr("id") === this.getId() + "-close") {
			this.close();
			// IE always interprets a click on an anker as navigation and thus triggers the 
			// beforeunload-event on the window. Since a ShellHeadItem never has a valid href-attribute,
			// the default behavior should never be triggered
			oEvent.preventDefault();
		}
	};
	
	ShellOverlay.prototype.onsapspace = ShellOverlay.prototype.onclick;
	
	ShellOverlay.prototype.onThemeChanged = function(){
		this._animOpenDuration = -1;
		this._animCloseDuration = -1;
		this._animBlockLayerDuration = -1;
	};
	
	ShellOverlay.prototype.onfocusin = function(oEvent){
		var $FocusableContent, oDomRef;
		
		if (oEvent.target.id == this.getId() + "-focfirst") {
			// Focus on first dummy element -> Move focus to last element in content
			$FocusableContent = jQuery(":sapTabbable", this.$("inner")); //Contains at least the close button
			oDomRef = $FocusableContent.get($FocusableContent.length - 1);
		} else if (oEvent.target.id == this.getId() + "-foclast") {
			// Focus on last dummy element -> Move focus to first element in content
			$FocusableContent = jQuery(":sapTabbable", this.$("inner")); //Contains at least the close button
			oDomRef = $FocusableContent.get(0);
		}
		
		if (oDomRef) {
			jQuery.sap.focus(oDomRef);
		}
	};
	
	
	/**** Private Helpers ****/
	
	ShellOverlay.prototype._getAnimDurationThemeParam = function(sParam, bClearIfNotActive){
		var val = parseInt(sap.ui.core.theming.Parameters.get(sParam), 10);
		if (!this._getAnimActive() && bClearIfNotActive) {
			val = 0;
		}
		return val;
	};
	
	ShellOverlay.prototype._getAnimDuration = function(bOpen){
		if ((bOpen && this._animOpenDuration == -1) || (!bOpen && this._animCloseDuration == -1)) {
			var sTxt = bOpen ? "Open" : "Close";
			this["_anim" + sTxt + "Duration"] = this._getAnimDurationThemeParam("sapUiUfdShellOvrly" + sTxt + "AnimOverAll", true);
		}
		return bOpen ? this._animOpenDuration : this._animCloseDuration;
	};
	
	ShellOverlay.prototype._getBLAnimDuration = function(){
		if (this._animBlockLayerDuration == -1) {
			this._animBlockLayerDuration = this._getAnimDurationThemeParam("sapUiUfdShellOvrlyBlockLayerAnimDuration", true);
		}
		return this._animBlockLayerDuration;
	};
	
	ShellOverlay.prototype._getAnimActive = function(){
		if (!this._animation || (Device.browser.internet_explorer && Device.browser.version < 10)) {
			return false;
		}
		return true;
	};
	
	ShellOverlay.prototype._getPopup = function(){
		if (!this._popup) {
			this._popup = new Popup(this, true, false, false);
			this._popup._applyPosition = function(oPosition) {
				this._$().css("left", "0").css("top", "0");
				this._oLastPosition = oPosition;
				this._oLastOfRect = jQuery(window).rect();
			};
			this._popup.attachOpened(function(){
				sap.ui.unified._iNumberOfOpenedShellOverlays++;
			});
			this._popup.attachClosed(function(){
				sap.ui.unified._iNumberOfOpenedShellOverlays--;
			});
		}
		return this._popup;
	};
	
	ShellOverlay.prototype._getShell = function(){
		var sId = this.getShell();
		if (!sId) {
			return;
		}
		var oShell = sap.ui.getCore().byId(sId);
		if (!oShell || !(oShell instanceof sap.ui.unified.ShellLayout)) {
			return;
		}
		return oShell;
	};
	
	ShellOverlay.prototype._forceShellHeaderVisible = function(){
		var oShell = this._getShell();
		if (oShell) {
			oShell._doShowHeader(true);
		}
	};
	
	ShellOverlay.prototype._getSearchWidth = function(){
		var oShell = this._getShell();
		return oShell ? oShell._getSearchWidth() : -1;
	};
	
	ShellOverlay.prototype._setSearchWidth = function(){
		var iWidth = this._getSearchWidth();
		if (iWidth <= 0) {
			return;
		}
		
		var sWidth = iWidth + "px";
		
		if (Device.browser.safari) {
			//Safari doesn't support width transition based on different units -> so px must be replaced by %
			var iTotalWidth = this.$("hdr-center").width();
			if (iTotalWidth > iWidth) {
				sWidth = Math.round((iWidth * 100) / iTotalWidth) + "%";
			} else {
				sWidth = "100%";
			}
		}
		
		this.$("search").css("width", sWidth);
	};
	
	
	

	return ShellOverlay;

}, /* bExport= */ true);

}; // end of sap/ui/unified/ShellOverlay.js
