/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','jquery.sap.script'],function(q,B){"use strict";var L=B.extend("sap.ui.core.util.LibraryInfo",{constructor:function(){B.apply(this);this._oLibInfos={};},destroy:function(){B.prototype.destroy.apply(this,arguments);this._oLibInfos={};},getInterface:function(){return this;}});L.prototype._loadLibraryMetadata=function(l,c){l=l.replace(/\//g,".");if(this._oLibInfos[l]){q.sap.delayedCall(0,window,c,[this._oLibInfos[l]]);return;}var t=this,u,s,p=/themelib_(.*)/i.exec(l);if(!p){s=".library";u=q.sap.getModulePath(l,'/');}else{s=".theme";u=q.sap.getModulePath("sap.ui.core",'/themes/'+p[1]+"/");}q.ajax({url:u+s,dataType:"xml",error:function(x,a,e){q.sap.log.error("failed to load library details from '"+u+s+": "+a+", "+e);t._oLibInfos[l]={name:l,data:null,url:u};c(t._oLibInfos[l]);},success:function(d,S,x){t._oLibInfos[l]={name:l,data:d,url:u};c(t._oLibInfos[l]);}});};L.prototype._getLibraryInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data);r.vendor=$.find("vendor").text();r.copyright=$.find("copyright").text();r.version=$.find("version").text();r.documentation=$.find("documentation").text();r.releasenotes=$.find("releasenotes").attr("url");r.componentInfo=L.prototype._getLibraryComponentInfo($);}c(r);});};L.prototype._getThirdPartyInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data).find("appData").find("thirdparty").children();$.each(function(i,o){if(o.nodeName==="lib"){var a=q(o);var b=a.children("license");r.libs.push({displayName:a.attr("displayName"),homepage:a.attr("homepage"),license:{url:b.attr("url"),type:b.attr("type"),file:d.url+b.attr("file")}});}});}c(r);});};L.prototype._getDocuIndex=function(l,c){this._loadLibraryMetadata(l,function(d){var a=d.name,b=d.url,r={"docu":{},library:a,libraryUrl:b};if(!d.data){c(r);return;}var D=q(d.data).find("appData").find("documentation");var u=D.attr("indexUrl");if(!u){c(r);return;}if(D.attr("resolve")=="lib"){u=d.url+u;}q.ajax({url:u,dataType:"json",error:function(x,s,e){q.sap.log.error("failed to load library docu from '"+u+"': "+s+", "+e);c(r);},success:function(d,s,x){d.library=a;d.libraryUrl=b;c(d);}});});};L.prototype._getReleaseNotes=function(l,v,c){this._loadLibraryMetadata(l,function(d){if(!d.data){c({});return;}var V=q.sap.Version(v);var m=V.getMajor();var M=V.getMinor();var p=V.getPatch();var D=q(d.data).find("appData").find("releasenotes");var u=D.attr("url");if(!u){q.sap.log.warning("failed to load release notes for library "+l);c({});return;}if(V.getSuffix()==="-SNAPSHOT"){if(M%2!=0){M=(M+1);p=0;}v=m+"."+M+"."+p;}u=u.replace("{major}",m);u=u.replace("{minor}",M);u=u.replace("{patch}",p);if(D.attr("resolve")=="lib"){u=d.url+u;}q.ajax({url:u,dataType:"json",error:function(x,s,e){if(s==="parsererror"){q.sap.log.error("failed to parse release notes for library '"+l+", "+e);}else{q.sap.log.warning("failed to load release notes for library '"+l+", "+e);}c({});},success:function(d,s,x){c(d,v);}});});};L.prototype._getLibraryComponentInfo=function(d){var a={};var c=[];var D="";d.find("ownership > component").each(function(b,C){if(C.childElementCount===0){D=C.textContent;}else{var v=C.getElementsByTagName("name");if(v&&v.length>0){v=v[0].textContent;var e=C.getElementsByTagName("module");if(v&&e&&e.length>0){var s="";for(var i=0;i<e.length;i++){var m=e[i].textContent.replace(/\//g,".");if(m){s=s+","+m;}}if(s){s=s.replace(/^,/,'');var t={"component":v,"modules":s};c.push(t);}}}}});a["defaultComponent"]=D;if(c&&c.length>0){a["specialCases"]=c;}return a;};L.prototype._getActualComponent=function(c,m){if(m){for(var k in c){if(k&&m.indexOf(k)===0){var s=false;var S=c[k].specialCases;var a="";var b=[];if(S){for(var i=0;i<S.length;i++){b=S[i].modules.split(",");for(var j=0;j<b.length;j++){if(m===b[j]){a=S[i].component;s=true;break;}}}}if(s){return a;}else{return c[k].defaultComponent;}}}}};L.prototype._getDefaultComponent=function(l){return l&&l.componentInfo&&l.componentInfo.defaultComponent;};return L;},true);
