/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','./v2/ODataTreeBinding','sap/ui/table/TreeAutoExpandMode'],function(q,T,O,c){"use strict";var d=function(){if(!(this instanceof T&&this.getContexts===undefined)){return;}for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this._aRowIndexMap=[];this._createTreeState();this._iThreshold=0;this._iPageSize=0;this.mParameters=this.mParameters||{};if(!this.mParameters.autoExpandMode){this.mParameters.autoExpandMode=c.Sequential;}if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}};d.prototype.getLength=function(){if(!this._oRootNode){return 0;}return this._oRootNode.magnitude;};d.prototype.getContextByIndex=function(i){if(this.isInitial()){return;}var n=this.findNode(i);return n?n.context:undefined;};d.prototype.getNodeByIndex=function(i){if(this.isInitial()){return;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};d.prototype.findNode=function(p){if(this.isInitial()){return;}var P=typeof p;var f;var s=[];if(P==="number"){f=this._aRowIndexMap[p];if(!f){var i=-1;this._match(this._oRootNode,s,1,function(n){if(i===p){return true;}i+=1;});f=s[0];}}return f;};d.prototype._createTreeState=function(r){if(!this._mTreeState||r){this._mTreeState={expanded:{},collapsed:{},selected:{},deselected:{}};}};d.prototype._updateTreeState=function(p){p=p||{};var t=p.expanded?this._mTreeState.expanded:this._mTreeState.collapsed;var s=p.expanded?this._mTreeState.collapsed:this._mTreeState.expanded;var n=this._getNodeState(p.groupID);if(!n){n=p.fallbackNodeState||this._createNodeState({groupID:p.groupID,expanded:p.expanded,sum:p.sum});}delete s[p.groupID];t[p.groupID]=n;n.expanded=p.expanded;return n;};d.prototype._createNodeState=function(p){var n={groupID:p.groupID,expanded:p.expanded||false,sections:p.sections||[{startIndex:0,length:this._iPageSize}],sum:p.sum||false,selected:p.selected||false};return n;};d.prototype._getNodeState=function(g){var e=this._mTreeState.expanded[g];var C=this._mTreeState.collapsed[g];var s=this._mTreeState.selected[g];var D=this._mTreeState.deselected[g];return e||C||s||D;};d.prototype._updateNodeSections=function(g,n){var N=this._getNodeState(g);N.sections=this._mergeSections(N.sections,n);return N.sections;};d.prototype._increaseSections=function(){var I=function(n){if(!n){return;}var m=0;if(n.isArtificial){if(this.bDisplayRootNode&&this.mParameters.rootNodeID&&!this._bRootMissing){m=1;}else{m=this._getGroupSize(n)||0;}}else{m=this.nodeHasChildren(n)?this._getGroupSize(n):0;}var N=n.nodeState;if(m===undefined){var a=[];for(var i=0;i<N.sections.length;i++){var C=N.sections[i];C.length=Math.max(C.length,this._iPageSize);a=this._mergeSections(a,C);}N.sections=a;}};this._map(this._oRootNode,I);};d.prototype.getContexts=function(s,l,t){if(this.isInitial()){return[];}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(l>this._iPageSize){this._iPageSize=l;this._increaseSections();}this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(n,s);var C=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}C.push(N.context);}if(m){var a=this;q.each(m,function(g,N){N.magnitude=0;N.numberOfTotals=0;a._loadChildContexts(N);});C=[];for(var j=0;j<n.length;j++){var N=n[j];C.push(N.context);}}return C;};d.prototype._updateRowIndexMap=function(n,s){this._aRowIndexMap=[];for(var i=0;i<n.length;i++){this._aRowIndexMap[s+i]=n[i];}};d.prototype._retrieveNodeSection=function(n,s,l){var N=-1;var a=[];this._match(this._oRootNode,[],l,function(n,p,P){if(!n||!n.isArtificial){N++;}if(N>=s&&N<s+l){if(!n){n=this._createNode({parent:P,positionInParent:p});P.children[p]=n;}a.push(n);return true;}});return a;};d.prototype._buildTree=function(s,l){this._oRootNode=undefined;var r=null;var R=this._calculateGroupID({context:r,parent:null});var o=this._getNodeState(R);if(!o){var o=this._createNodeState({groupID:R,sum:true,sections:[{startIndex:s,length:l}]});this._updateTreeState({groupID:o.groupID,fallbackNodeState:o,expanded:true});}this._oRootNode=this._createNode({context:r,parent:null,level:this.bDisplayRootNode&&!(r===null)?0:-1,nodeState:o,isLeaf:false,autoExpand:this.iNumberOfExpandedLevels+1});this._oRootNode.isArtificial=true;if(this._mTreeState.expanded[this._oRootNode.groupID]){this._loadChildContexts(this._oRootNode);}};d.prototype._loadChildContexts=function(n){var N=n.nodeState;var m=0;if(n.isArtificial){if(this.bDisplayRootNode&&this.mParameters.rootNodeID&&!this._bRootMissing){m=1;}else{m=this._getGroupSize(n)||0;}}else{m=this.nodeHasChildren(n)?this._getGroupSize(n):0;}if(m>0){if(!n.children[m-1]){n.children[m-1]=undefined;}}for(var i=0;i<N.sections.length;i++){var C=N.sections[i];var r;if(!m){r=C.length;}else{r=Math.max(Math.min(C.length,m-C.startIndex),0);}if(n.autoExpand>=0&&this.mParameters.autoExpandMode===c.Bundled){r=Math.max(0,m);}var a;if(n.isArtificial){a=this.getRootContexts(C.startIndex,r,this._iThreshold);}else{a=this.nodeHasChildren(n)?this.getNodeContexts(n.context,C.startIndex,r,this._iThreshold):[];}for(var j=0;j<a.length;j++){var o=a[j];if(!o){continue;}var b=j+C.startIndex;var e=n.children[b];var u={context:a[j],parent:n,level:n.level+1,positionInParent:b,autoExpand:Math.max(n.autoExpand-1,-1)};if(e){e.context=u.context;e.parent=u.parent;e.level=u.level;e.positionInParent=u.positionInParent;e.magnitude=0;e.numberOfTotals=0;e.autoExpand=u.autoExpand;var g;if(o){g=this._calculateGroupID(e);}e.groupID=g;}else{e=this._createNode(u);}e.nodeState=this._getNodeState(e.groupID);if(!e.nodeState){e.nodeState=this._createNodeState({groupID:e.groupID,expanded:false});}e.isLeaf=!this.nodeHasChildren(e);n.children[b]=e;if(e.isLeaf){n.numberOfLeafs+=1;}if(e.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[e.groupID]){this.setNodeSelection(e.nodeState,true);}if((e.autoExpand>0||e.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[e.groupID]&&!e.isLeaf){if(e.autoExpand>0&&e.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[e.groupID]){if(e.nodeState.selectAllMode===undefined){e.nodeState.selectAllMode=true;}}this._updateTreeState({groupID:e.nodeState.groupID,fallbackNodeState:e.nodeState,expanded:true});this._loadChildContexts(e);}n.magnitude+=Math.max(e.magnitude||0,0);n.numberOfLeafs+=e.numberOfLeafs;}}}n.magnitude+=Math.max(m||0,0);};d.prototype.isGrouped=function(){return true;};d.prototype._calculateGroupID=function(n){var g="";var G="";if(n.context===null){return"/";}if(n.parent){g=n.parent.groupID;g=g[g.length-1]!=="/"?g+"/":g;if(this.bHasTreeAnnotations){G=n.context.getProperty(this.oTreeProperties["hierarchy-node-for"])+"/";}else{G=n.context.sPath.substring(1)+"/";}}else{if(this.bHasTreeAnnotations){g="/";G=n.context.getProperty(this.oTreeProperties["hierarchy-node-for"])+"/";}else{g="/";G=n.context.sPath[0]==="/"?n.context.sPath.substring(1):n.context.sPath;}}var s=g+G;return s;};d.prototype._createNode=function(p){p=p||{};var C=p.context;var l=p.level||0;var n={context:C,level:l,children:p.children||[],parent:p.parent,nodeState:p.nodeState,isLeaf:p.isLeaf||false,positionInParent:p.positionInParent,magnitude:p.magnitude||0,numberOfTotals:p.numberOfTotals||0,numberOfLeafs:p.numberOfLeafs||0,autoExpand:p.autoExpand||0};if(C!==undefined){n.groupID=this._calculateGroupID(n);}return n;};d.prototype.expand=function(i){var n=this.findNode(i);this._updateTreeState({groupID:n.nodeState.groupID,fallbackNodeState:n.nodeState,expanded:true});this._fireChange();};d.prototype.expandToLevel=function(l){this._mTreeState.collapsed={};this.setNumberOfExpandedLevels(l);this._fireChange();};d.prototype.isExpanded=function(i){var n=this.findNode(i);return n&&n.nodeState?n.nodeState.expanded:false;};d.prototype.collapse=function(p,s){var n;var t=this;if(typeof p==="object"){n=p;}else if(typeof p==="number"){var N=this.findNode(p);n=N.nodeState;}this._updateTreeState({groupID:n.groupID,fallbackNodeState:n,expanded:false});n.selectAllMode=false;if(this.bCollapseRecursive){var g=n.groupID;q.each(this._mTreeState.expanded,function(G,o){if(q.sap.startsWith(G,g)){t._updateTreeState({groupID:G,expanded:false});}});}q.each(this._mTreeState.selected,function(G,o){if(q.sap.startsWith(G,g)&&G!==g){o.selectAllMode=false;t.setNodeSelection(o,false);}});if(!s){this._fireChange();}};d.prototype.collapseToLevel=function(l){if(!l||l<0){l=0;}var t=this;q.each(this._mTreeState.expanded,function(g,n){var N=t._getGroupIdLevel(g)-1;if(N===l){t.collapse(n,true);}});this._fireChange();};d.prototype._map=function(n,m){m.call(this,n);if(!n){return;}for(var i=0;i<n.children.length;i++){var C=n.children[i];this._map(C,m);}};d.prototype._match=function(n,r,m,M,p,P){if(r.length===m){return true;}var N=M.call(this,n,p,P);if(N){r.push(n);}if(!n){return false;}for(var i=0;i<n.children.length;i++){var C=n.children[i];var b=this._match(C,r,m,M,i,n);if(b){return true;}}};d.prototype.toggleIndex=function(i){var n=this._aRowIndexMap[i];if(n.nodeState.expanded){this.collapse(i);}else{this.expand(i);}};d.prototype._getGroupIdLevel=function(g){if(g==null){q.sap.log.warning("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};d.prototype._getGroupSize=function(n){return this.getChildCount(n.context);};d.prototype.nodeHasChildren=function(n){if(!n){return false;}else if(n.isArtificial){return true;}else{return O.prototype.hasChildren.call(this,n.context);}};d.prototype.resetData=function(C){var r=O.prototype.resetData.call(this,C);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this.clearSelection();this._createTreeState(true);return r;};d.prototype.setNodeSelection=function(n,i){n.selected=i;if(i){this._mTreeState.selected[n.groupID]=n;delete this._mTreeState.deselected[n.groupID];}else{delete this._mTreeState.selected[n.groupID];this._mTreeState.deselected[n.groupID]=n;}};d.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n){var C=this._clearSelection();var i=C.rowIndices.indexOf(r);if(i>=0){C.rowIndices.splice(i,1);}else{C.rowIndices.push(r);}C.leadGroupID=n.groupID;C.leadIndex=r;this.setNodeSelection(n.nodeState,true);this._publishSelectionChanges(C);}else{q.sap.log.warning("TreeTable: Please make sure to only select rows, for which data has been fetched to the client.");}};d.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionGroupID||q.isEmptyObject(this._mTreeState.selected)){return-1;}var n=-1;var m=function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){return true;}}};this._match(this._oRootNode,[],1,m);return n;};d.prototype.getSelectedIndices=function(){var r=[];if(q.isEmptyObject(this._mTreeState.selected)){return r;}var n=-1;var m=function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.nodeState&&N.nodeState.selected&&!N.isArtificial){r.push(n);}}};this._map(this._oRootNode,m);return r;};d.prototype.getSelectedContexts=function(){var r=[];if(q.isEmptyObject(this._mTreeState.selected)){return r;}var m=function(n){if(n){if(n.nodeState.selected&&!n.isArtificial){r.push(n.context);}}};this._map(this._oRootNode,m);return r;};d.prototype.setSelectionInterval=function(f,t){var C=this._clearSelection();var s=this._setSelectionInterval(f,t,true);var I={};var r=[];for(var i=0;i<C.rowIndices.length;i++){var a=C.rowIndices[i];I[a]=true;}for(i=0;i<s.rowIndices.length;i++){a=s.rowIndices[i];if(I[a]){delete I[a];}else{I[a]=true;}}for(a in I){if(I[a]){r.push(parseInt(a,10));}}this._publishSelectionChanges({rowIndices:r,oldIndex:C.oldIndex,leadIndex:s.leadIndex,leadGroupID:s.leadGroupID});};d.prototype._setSelectionInterval=function(f,t,s){var n=Math.min(f,t);var N=Math.max(f,t);var a=[];var C=[];var i=Math.abs(N-n)+1;var o;var b=-1;var m=function(e){if(!e||!e.isArtificial){b++;}if(e){if(b>=n&&b<=N){if(e.nodeState.selected!==!!s){C.push(b);}if(e.groupID===this._sLeadSelectionGroupID){o=b;}this.setNodeSelection(e.nodeState,!!s);return true;}}};this._match(this._oRootNode,a,i,m);var p={rowIndices:C,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadGroupID=l.groupID;p.leadIndex=N;}return p;};d.prototype.addSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,true);this._publishSelectionChanges(p);};d.prototype.removeSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,false);this._publishSelectionChanges(p);};d.prototype.selectAll=function(){this._mTreeState.deselected={};var p={rowIndices:[],oldIndex:-1};var n=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){n++;}if(N){p.leadGroupID=N.groupID;p.leadIndex=n;if(N.groupID===this._sLeadSelectionGroupID){p.oldIndex=n;}if(!N.isArtificial&&N.nodeState.selected!==true){p.rowIndices.push(n);}this.setNodeSelection(N.nodeState,true);if(N.nodeState.expanded){N.nodeState.selectAllMode=true;}}});this._publishSelectionChanges(p);};d.prototype._clearSelection=function(){var n=-1;var o=-1;var m=0;var C=[];for(var g in this._mTreeState.selected){if(g){m++;}}var M=function(N){if(!N||!N.isArtificial){n++;}if(N){if(this._mTreeState.selected[N.groupID]){if(!N.isArtificial){C.push(n);}this.setNodeSelection(N.nodeState,false);N.nodeState.selectAllMode=false;if(N.groupID===this._sLeadSelectionGroupID){o=n;}return true;}}};this._match(this._oRootNode,[],m,M);if(this._oRootNode&&this._oRootNode.nodeState&&this._oRootNode.isArtificial){this._oRootNode.nodeState.selectAllMode=false;}return{rowIndices:C,oldIndex:o,leadIndex:-1};};d.prototype.clearSelection=function(s){var C=this._clearSelection();if(!s){this._publishSelectionChanges(C);}};d.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadGroupID){this._sLeadSelectionGroupID=p.leadGroupID;}else if(p.leadIndex===-1){this._sLeadSelectionGroupID=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};d.prototype.setCollapseRecursive=function(C){this.bCollapseRecursive=!!C;};d.prototype.attachContextChange=function(f,l){this.attachEvent("contextChange",f,l);};d.prototype.detachContextChange=function(f,l){this.detachEvent("contextChange",f,l);};d.prototype._fireContextChange=function(a){this.fireEvent("contextChange",a);};d.prototype.attachSelectionChanged=function(D,f,l){this.attachEvent("selectionChanged",D,f,l);return this;};d.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};d.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};return d;},true);
