/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IntervalTrigger','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/SelectionModel','./Row','./library'],function(q,C,I,S,a,P,b,R,c){"use strict";var T=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:sap.ui.table.SelectionMode.Multi},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:sap.ui.table.SelectionBehavior.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},allowColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:sap.ui.table.NavigationMode.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:sap.ui.table.VisibleRowCountMode.Fixed},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Appearance",defaultValue:null,deprecated:true},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"int"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},rowIndex:{type:"int"},columnIndex:{type:"int"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},rowIndex:{type:"int"},columnIndex:{type:"int"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{}}}});T.ResizeTrigger=new I(300);T.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bAccMode=sap.ui.getCore().getConfiguration().getAccessibility();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._oSelection=new b(b.MULTI_SELECTION);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);this._iColMinWidth=20;this._oCalcColumnWidths=[];this._aIdxCols2Cells=[];this._aVisibleColumns=[];var f={onAfterRendering:function(e){e.srcControl.$("sb").attr("tabindex","-1").css("outline","none");}};this._oVSb=new S(this.getId()+"-vsb",{size:"100%"});this._oVSb.attachScroll(this.onvscroll,this);this._oVSb.addDelegate(f);this._oHSb=new S(this.getId()+"-hsb",{size:"100%",contentSize:"0px",vertical:false});this._oHSb.attachScroll(this.onhscroll,this);this._oHSb.addDelegate(f);this._bActionMode=false;this._iLastFixedColIndex=-1;this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._bCallUpdateTableCell=false;this._iTimerDelay=250;this._doubleclickDelay=300;this._clicksRegistered=0;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;};T.prototype.exit=function(){this._oVSb.destroy();this._oHSb.destroy();if(this._oPaginator){this._oPaginator.destroy();}this._destroyItemNavigation();this._cleanUpTimers();this._detachEvents();};T.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};T.prototype.onBeforeRendering=function(){this._cleanUpTimers();this._detachEvents();};T.prototype.onAfterRendering=function(){this._bOnAfterRendering=true;var $=this.$();if(sap.ui.Device.system.tablet){$.addClass("sapUiTableTouch");}this._renderOverlay();this._updateVSb(true);this._updateTableContent();this._handleResize();this._attachEvents();var d=this.getColumns();for(var i=0,l=d.length;i<l;i++){if(d[i].getVisible()){d[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._initItemNavigation();if(this._bDetermineVisibleCols===true){this._determineVisibleCols();this._bDetermineVisibleCols=false;}};T.prototype._renderOverlay=function(){var $=this.$(),d=$.find(".sapUiTableOverlay"),s=this.getShowOverlay();if(s&&d.length===0){d=q("<div>").addClass("sapUiOverlay sapUiTableOverlay").css("z-index","1");$.append(d);}else if(!s){d.remove();}};T.prototype.setShowOverlay=function(s){this.setProperty("showOverlay",s,true);this._renderOverlay();return this;};T.prototype._updateTableContent=function(){this._updateNoData();this._updateSelection();if(this._modifyRow){var t=this;q.each(this.getRows(),function(i,r){t._modifyRow(i+t.getFirstVisibleRow(),r.$());t._modifyRow(i+t.getFirstVisibleRow(),r.$("fixed"));});}var B=this.getBinding("rows");var f=this.getFixedRowCount();var F=this.getFixedBottomRowCount();var v=this.getVisibleRowCount();var t=this;if(B){q.each(this.getRows(),function(i,r){var $=r.$();var d=r.$("fixed");var e=t.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(r.getBindingContext()){e.attr("title",t._oResBundle.getText("TBL_ROW_SELECT"));}else{e.attr("title","");}if(f>0){var g=i<f;if(g){if(!$.hasClass("sapUiTableFixedTopRow")){$.addClass('sapUiTableFixedTopRow');d.addClass('sapUiTableFixedTopRow');e.addClass('sapUiTableFixedTopRow');}}else if($.hasClass("sapUiTableFixedTopRow")){$.removeClass('sapUiTableFixedTopRow');d.removeClass('sapUiTableFixedTopRow');e.removeClass('sapUiTableFixedTopRow');}}if(F>0){var h,j;if(B.getLength()>=v){h=i>v-F-1;j=i>v-F-2;}else{h=(t.getFirstVisibleRow()+i)>(B.getLength()-1-F)&&(t.getFirstVisibleRow()+i)<B.getLength();j=(t.getFirstVisibleRow()+i)>(B.getLength()-2-F)&&(t.getFirstVisibleRow()+i)<B.getLength();}if(h){if(!$.hasClass("sapUiTableFixedBottomRow")){$.addClass('sapUiTableFixedBottomRow');d.addClass('sapUiTableFixedBottomRow');e.addClass('sapUiTableFixedBottomRow');}}else if($.hasClass("sapUiTableFixedBottomRow")){$.removeClass('sapUiTableFixedBottomRow');d.removeClass('sapUiTableFixedBottomRow');e.removeClass('sapUiTableFixedBottomRow');}if(j){if(!$.hasClass("sapUiTableFixedPreBottomRow")){$.addClass('sapUiTableFixedPreBottomRow');d.addClass('sapUiTableFixedPreBottomRow');e.addClass('sapUiTableFixedPreBottomRow');}}else if($.hasClass("sapUiTableFixedPreBottomRow")){$.removeClass('sapUiTableFixedPreBottomRow');d.removeClass('sapUiTableFixedPreBottomRow');e.removeClass('sapUiTableFixedPreBottomRow');}}});}this._updateRowHeader();if(this._bOnAfterRendering&&(this._bCallUpdateTableCell||typeof this._updateTableCell==="function")){var t=this;var o=this.mBindingInfos["rows"];q.each(this.getRows(),function(i,r){var A=t.getFirstVisibleRow()+i;q.each(r.getCells(),function(i,d){if(d._updateTableCell){d._updateTableCell(d,d.getBindingContext(o&&o.model),d.$().closest("td"),A);}if(t._updateTableCell){t._updateTableCell(d,d.getBindingContext(o&&o.model),d.$().closest("td"),A);}});});}};T.prototype._initItemNavigation=function(){var $=this.$();var d=this._getVisibleColumnCount();var t=d;var h=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;if(!this._oColHdrItemNav){this._oColHdrItemNav=new a();this._oColHdrItemNav.setCycling(false);this.addDelegate(this._oColHdrItemNav);}var e=[];if(this.getFixedColumnCount()==0){e=$.find(".sapUiTableCtrl td[tabindex]").get();}else{var f=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');var g=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');var j=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');var k=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');var l=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');var m=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');for(var i=0;i<this.getVisibleRowCount();i++){e=e.concat(f.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(g.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(j.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(k.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(l.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(m.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());}}var n=e.length;var o=0;if(h){var r=$.find(".sapUiTableRowHdr").get();for(var i=r.length-1;i>=0;i--){e.splice(i*d,0,r[i]);n++;}n--;t++;o=1;}if(this.getColumnHeaderVisible()){e=$.find(".sapUiTableCol").get().concat(e);}if(h&&this.getColumnHeaderVisible()){var p=$.find(".sapUiTableColRowHdr").get();for(var i=this._getHeaderRowCount()-1;i>=0;i--){e.splice(i*d,0,p[0]);}}if(!this._oItemNavigation){this._iLastSelectedDataRow=this._getHeaderRowCount();this._oItemNavigation=new a();this._oItemNavigation.setTableMode(true);this._oItemNavigation.attachEvent(a.Events.BeforeFocus,function(E){this.$("ariadesc").text("");},this);this._oItemNavigation.attachEvent(a.Events.AfterFocus,function(E){var s=Math.floor(E.getParameter("index")/this._oItemNavigation.iColumns);if(s>0){this._iLastSelectedDataRow=s;}},this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setColumns(t);this._oItemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setFocusedIndex(o);};T.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this._oItemNavigation.destroy();this._oItemNavigation=undefined;}};T.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return sap.ui.core.Element.prototype.getFocusInfo.apply(this,arguments);}};T.prototype.applyFocusInfo=function(f){if(f&&f.customId){this.$().find("#"+f.customId).focus();}else{sap.ui.core.Element.prototype.getFocusInfo.apply(this,arguments);}return this;};T.prototype.setTitle=function(t){var o=t;if(typeof(t)==="string"||t instanceof String){o=sap.ui.table.TableHelper.createTextView({text:t,width:"100%"});o.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",o);return this;};T.prototype.setFooter=function(f){var F=f;if(typeof(f)==="string"||f instanceof String){F=sap.ui.table.TableHelper.createTextView({text:f,width:"100%"});}this.setAggregation("footer",F);return this;};T.prototype.setSelectionMode=function(s){this._oSelection.clearSelection();if(s===sap.ui.table.SelectionMode.Single){this._oSelection.setSelectionMode(b.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(b.MULTI_SELECTION);}this.setProperty("selectionMode",s);return this;};T.prototype.setFirstVisibleRow=function(r,o){this.setProperty("firstVisibleRow",r,true);if(this.getBinding("rows")&&!this._bRefreshing){this.updateRows();}return this;};T.prototype.getAllowColumnReordering=function(){q.sap.log.warning("getAllowColumnReordering is deprecated - please use getEnableColumnReordering!");return T.prototype.getEnableColumnReordering.apply(this,arguments);};T.prototype.setAllowColumnReordering=function(){q.sap.log.warning("setAllowColumnReordering is deprecated - please use setEnableColumnReordering!");return T.prototype.setEnableColumnReordering.apply(this,arguments);};T.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;T.prototype.bindRows=function(B,t,s,f){if(typeof B==="string"&&(t instanceof sap.ui.model.Sorter||q.isArray(s)&&s[0]instanceof sap.ui.model.Filter)){f=s;s=t;t=undefined;}return this.bindAggregation("rows",B,t,s,f);};T.prototype._bindAggregation=function(n,p,t,s,f){sap.ui.core.Element.prototype._bindAggregation.apply(this,arguments);var B=this.getBinding("rows");if(n==="rows"&&B){B.attachChange(this._onBindingChange,this);}return this;};T.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};T.prototype.unbindAggregation=function(n,s){var B=this.getBinding("rows");if(n==="rows"&&B){B.detachChange(this._onBindingChange);s=true;this._restoreAppDefaultsColumnHeaderSortFilter();}this.updateRows();return sap.ui.core.Element.prototype.unbindAggregation.apply(this,[n,s]);};T.prototype.setVisibleRowCountMode=function(v){this.setProperty("visibleRowCountMode",v);this._handleRowCountMode();return this;};T.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);return this;};T.prototype.refreshRows=function(r){this._bBusyIndicatorAllowed=true;this._bRefreshing=true;this._onBindingChange(r);this._updateBindingContexts(true);this._bRefreshing=false;};T.prototype.updateRows=function(r){this._setBusy(false);var s=this.getFirstVisibleRow();s=Math.max(s,0);if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar&&this._getRowCount()>0){s=Math.min(s,Math.max(this._getRowCount()-this.getVisibleRowCount(),0));}this.setProperty("firstVisibleRow",s,true);if(this._oVSb.getScrollPosition()!==s){this._oVSb.setScrollPosition(s);}if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){var n=1;if(s<this.getBinding("rows").getLength()){n=Math.ceil((s+1)/this.getVisibleRowCount());}if(n!==this._oPaginator.getCurrentPage()){this.setProperty("firstVisibleRow",(n-1)*this.getVisibleRowCount(),true);this._oPaginator.setCurrentPage(n);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}}if(this.getDomRef()){this._sBindingTimer=this._sBindingTimer||q.sap.delayedCall(50,this,function(){if(!this.bIsDestroyed){this._determineVisibleCols();this._updateBindingContexts();this._updateVSb();this._updateTableContent();this._sBindingTimer=undefined;this.fireEvent("_rowsUpdated");}});}};T.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!");};T.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!");};T.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!");};T.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!");};T.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!");};T.prototype.autoResizeColumn=function(i){var o=this.getColumns()[i];this._iColumnResizeStart=null;var n=this._calculateAutomaticColumnWidth(i);if(n==null){return;}o._iNewWidth=n;this._oCalcColumnWidths[i]=o._iNewWidth;this._onColumnResized(null,i);};T.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(i)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableColRsz").mousedown(q.proxy(this._onColumnResizeStart,this));this._enableColumnAutoResizing();T.ResizeTrigger.addListener(this._checkTableSize,this);this._oHSb.bind($.find(".sapUiTableCtrlScr").get(0));this._oVSb.bind($.find(".sapUiTableCtrlScr").get(0));this._oHSb.bind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.bind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.bind($.find(".sapUiTableRowHdrScr").get(0));q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(e){if(q(e.target).has($).length>0){this._handleResize();}},this));};T.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableColHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();T.ResizeTrigger.removeListener(this._checkTableSize,this);$.find(".sapUiTableColRsz").unbind();this._oHSb.unbind($.find(".sapUiTableCtrlScr").get(0));this._oVSb.unbind($.find(".sapUiTableCtrlScr").get(0));this._oHSb.unbind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.unbind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.unbind($.find(".sapUiTableRowHdrScr").get(0));q("body").unbind('webkitTransitionEnd transitionend');};T.prototype._cleanUpTimers=function(){if(this._sBindingTimer){q.sap.clearDelayedCall(this._sBindingTimer);this._sBindingTimer=undefined;}if(this._sScrollBarTimer){q.sap.clearDelayedCall(this._sScrollBarTimer);this._sScrollBarTimer=undefined;}if(this._sDelayedMenuTimer){q.sap.clearDelayedCall(this._sDelayedMenuTimer);this._sDelayedMenuTimer=undefined;}if(this._sDelayedActionTimer){q.sap.clearDelayedCall(this._sDelayedActionTimer);this._sDelayedActionTimer=undefined;}if(this._sColHdrPosTimer){q.sap.clearDelayedCall(this._sColHdrPosTimer);this._sColHdrPosTimer=undefined;}if(this._visibleRowCountTimer){q.sap.clearDelayedCall(this._visibleRowCountTimer);this._visibleRowCountTimer=undefined;}T.ResizeTrigger.removeListener(this._checkTableSize,this);};T.prototype._createRows=function(s){var f=this.getFirstVisibleRow();var v=this.getVisibleRowCount();s=s===undefined?f:s;var t=new R(this.getId()+"-rows");var d=this.getColumns();var e=0;for(var i=0,l=d.length;i<l;i++){if(d[i].getVisible()){var o=d[i].getTemplate();if(o){var g=o.clone("col"+i);if(this._bInheritEditableToControls&&!this.getEditable()&&g.setEditable){g.setEditable(false);}g.data("sap-ui-colindex",i);t.addCell(g);this._aIdxCols2Cells[i]=e++;}}}this.destroyAggregation("rows",true);var h;var B=this.getBinding("rows");var j=this.mBindingInfos["rows"];if(B&&v>0){var k=this.getThreshold()?Math.max(this.getVisibleRowCount(),this.getThreshold()):0;var F=this.getFixedBottomRowCount();h=B.getContexts(s,v-F,k);this._setBusy({requestedLength:v-F,receivedLength:h.length,contexts:h});if(F>0&&(v-F)<B.getLength()){var m=B.getContexts(B.getLength()-F,F,1);h=h.concat(m);this._setBusy({requestedLength:F,receivedLength:m.length,contexts:m});}}for(var i=0;i<v;i++){var g=t.clone("row"+i);if(h&&h[i]){g.setBindingContext(h[i],j.model);g._bHidden=false;}else{if(j){g.setBindingContext(null,j.model);}else{g.setBindingContext(null);}g._bHidden=true;}this.addAggregation("rows",g,true);}t.destroy();};T.prototype._updateHSb=function(){var $=this.$();var i=$.find(".sapUiTableCtrlScroll").width();if(!!sap.ui.Device.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>$.find(".sapUiTableCtrlScr").width()){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!sap.ui.Device.browser.safari){var d=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){d.width(i);}else{d.outerWidth(i);}}}var s=$.find(".sapUiTableCtrlFixed").width();if($.find(".sapUiTableRowHdrScr:visible").length>0){s+=$.find(".sapUiTableRowHdrScr").width();}var e=$.find(".sapUiTableHSb");if(this._bRtlMode){e.css('padding-right',s+'px');}else{e.css('padding-left',s+'px');}var m=e.parent().width();e.css('max-width',m+"px");this._oHSb.setContentSize(i+"px");if(this._oHSb.getDomRef()){this._oHSb.rerender();}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!sap.ui.Device.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}this._syncHeaderAndContent();};T.prototype._updateVSb=function(o){var $=this.$();var d=false;var f=false;var B=this.getBinding("rows");if(B){var F=this.getFixedRowCount();if(F>0){var O=$.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetTop;this.$().find('.sapUiTableVSb').css('top',(O-1)+'px');f=true;}var i=this.getFixedBottomRowCount();if(i>0){var e=$.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetHeight;this.$().find('.sapUiTableVSb').css('height',e+'px');f=true;}var s=Math.max(0,(B.getLength()||0)-this.getVisibleRowCount());if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){var n=Math.ceil((B.getLength()||0)/this.getVisibleRowCount());this._oPaginator.setNumberOfPages(n);var p=Math.min(n,Math.ceil((this.getFirstVisibleRow()+1)/this.getVisibleRowCount()));this.setProperty("firstVisibleRow",(Math.max(p,1)-1)*this.getVisibleRowCount(),true);this._oPaginator.setCurrentPage(p);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");}}else{if(s>0){if(!$.hasClass("sapUiTableVScr")){$.addClass("sapUiTableVScr");d=true;}}else{if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");d=true;}}}if(o||f||s!==this._oVSb.getSteps()||this.getFirstVisibleRow()!==this._oVSb.getScrollPosition()){q.sap.clearDelayedCall(this._sScrollBarTimer);this._sScrollBarTimer=q.sap.delayedCall(o?0:250,this,function(){this._oVSb.setSteps(s);if(this._oVSb.getDomRef()){this._oVSb.rerender();}this._oVSb.setScrollPosition(this.getFirstVisibleRow());});}}else{if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){this._oPaginator.setNumberOfPages(0);this._oPaginator.setCurrentPage(0);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}else{if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");d=true;}}}if(d&&!this._bOnAfterRendering){this._handleResize();}};T.prototype._updateBindingContexts=function(s){var r=this.getRows(),B=this.getBinding("rows"),o=this.mBindingInfos["rows"],f,d,F,i=this.getFixedRowCount(),e=this.getFixedBottomRowCount(),v=this.getVisibleRowCount();if(B){var t;if(i>0||e>0){var g=i+e;t=this.getThreshold()?Math.max((this.getVisibleRowCount()-g),this.getThreshold()):0;d=B.getContexts(this.getFirstVisibleRow()+i,r.length-g,t);this._setBusy({requestedLength:r.length-g,receivedLength:d.length,contexts:d});if(i>0){f=B.getContexts(0,i);this._setBusy({requestedLength:i,receivedLength:f.length,contexts:f});d=f.concat(d);}if(e>0&&(v-e)<B.getLength()){F=B.getContexts(B.getLength()-e,e);this._setBusy({requestedLength:e,receivedLength:F.length,contexts:F});d=d.concat(F);}}else if(r.length>0){t=this.getThreshold()?Math.max(this.getVisibleRowCount(),this.getThreshold()):0;d=B.getContexts(this.getFirstVisibleRow(),r.length,t);this._setBusy({requestedLength:r.length,receivedLength:d.length,contexts:d});}}if(!s){for(var h=r.length-1;h>=0;h--){var j=d?d[h]:undefined;var k=r[h];if(k){var A=this.getFirstVisibleRow()+h;this._updateRowBindingContext(k,j,o&&o.model,A);}}}};T.prototype._updateRowBindingContext=function(r,o,m,A){var d=r.getCells();var $=r.$();var e=r.$("fixed");var f=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");r.setBindingContext(o,m);if(o&&o instanceof sap.ui.model.Context){for(var i=0,l=this._aVisibleColumns.length;i<l;i++){var g=this._aIdxCols2Cells[this._aVisibleColumns[i]];if(d[g]){this._updateCellBindingContext(d[g],o,m,A);}}if($.hasClass("sapUiTableRowHidden")){$.removeClass("sapUiTableRowHidden");e.removeClass("sapUiTableRowHidden");f.removeClass("sapUiTableRowHidden");}r._bHidden=false;}else{if(!$.hasClass("sapUiTableRowHidden")){$.addClass("sapUiTableRowHidden");e.addClass("sapUiTableRowHidden");f.addClass("sapUiTableRowHidden");}if($.hasClass("sapUiTableFixedBottomRow")){$.removeClass('sapUiTableFixedBottomRow');e.removeClass('sapUiTableFixedBottomRow');f.removeClass('sapUiTableFixedBottomRow');}if($.hasClass("sapUiTableFixedPreBottomRow")){$.removeClass('sapUiTableFixedPreBottomRow');e.removeClass('sapUiTableFixedPreBottomRow');f.removeClass('sapUiTableFixedPreBottomRow');}if($.hasClass("sapUiTableFixedTopRow")){$.removeClass('sapUiTableFixedTopRow');e.removeClass('sapUiTableFixedTopRow');f.removeClass('sapUiTableFixedTopRow');}r._bHidden=true;for(var i=0,l=this._aVisibleColumns.length;i<l;i++){var g=this._aIdxCols2Cells[this._aVisibleColumns[i]];if(d[g]){this._updateCellBindingContext(d[g],o,m,A);}}}};T.prototype._updateCellBindingContext=function(o,d,m,A){if(this._bCallUpdateTableCell&&o._updateTableCell){o._updateTableCell(o,d,o.$().closest("td"),A);}if(typeof this._updateTableCell==="function"){this._updateTableCell(o,d,o.$().closest("td"),A);}};T.prototype._hasData=function(){var B=this.getBinding("rows");if(!B||(B.getLength()||0)===0){return false;}return true;};T.prototype._updateNoData=function(){if(this.getShowNoData()){var B=this.getBinding("rows");if(!this._hasData()){if(!this.$().hasClass("sapUiTableEmpty")){this.$().addClass("sapUiTableEmpty");}this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS",[0]));}else{if(this.$().hasClass("sapUiTableEmpty")){this.$().removeClass("sapUiTableEmpty");}this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS",[(B.getLength()||0)]));}}};T.prototype._determineVisibleCols=function(){var $=this.$(),t=this;if($.hasClass("sapUiTableHScr")){var r=this._bRtlMode;var s=this._oHSb.getNativeScrollPosition();if(r&&sap.ui.Device.browser.firefox&&s<0){s=s*-1;}var d=s+this._getScrollWidth();if(this._iOldScrollLeft!==s||this._iOldScrollRight!==d||this._bForceVisibleColCalc){var L=r?$.find(".sapUiTableCtrlScroll").width():0;if((sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.firefox)&&r){L=0;}this._aVisibleColumns=[];for(var i=0,l=this.getFixedColumnCount();i<l;i++){this._aVisibleColumns.push(i);}var e=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll .sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex]");e.each(function(g,E){var w=q(E).width();if(r&&sap.ui.Device.browser.chrome){L-=w;}if(L+w>=s&&L<=d){t._aVisibleColumns.push(parseInt(q(E).data('sap-ui-headcolindex'),10));}if(!r||(sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.firefox)){L+=w;}});this._iOldScrollLeft=s;this._iOldScrollRight=d;this._bForceVisibleColCalc=false;}}else{this._aVisibleColumns=[];var f=this.getColumns();for(var i=0,l=f.length;i<l;i++){if(f[i].shouldRender()){this._aVisibleColumns.push(i);}}}};T.prototype._enableColumnAutoResizing=function(){var t=this;q.each(this.getColumns(),function(i,o){if(!!o.getAutoResizable()){var $=q.find(".sapUiTableColRsz[data-sap-ui-colindex="+i+"]");if($){t._bindSimulatedDoubleclick($,null,t._onAutomaticColumnResize);}}});};T.prototype.removeColumn=function(o){this.removeAggregation('columns',o);this._bDetermineVisibleCols=true;return this;};T.prototype.addColumn=function(o){var t=this;this.addAggregation('columns',o);o.attachEvent('_widthChanged',function(e){t._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;return this;};T.prototype.insertColumn=function(o,i){var t=this;this.insertAggregation('columns',o,i);o.attachEvent('_widthChanged',function(){t._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;return this;};T.prototype._getRowCount=function(){var B=this.getBinding("rows");return B?(B.getLength()||0):0;};T.prototype._getSelectableRowCount=function(){return this._getRowCount();};T.prototype._getScrollTop=function(){if(this.$().hasClass("sapUiTableVScr")){return this._oVSb.getScrollPosition()||0;}else{if(this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){return(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}else{return 0;}}};T.prototype._getScrollWidth=function(){return this.$().find(".sapUiTableCtrlScr").width();};T.prototype._getScrollHeight=function(){return this.$().find(".sapUiTableCtrlScr").height();};T.prototype._getVisibleColumns=function(){var d=[];var e=this.getColumns();for(var i=0,l=e.length;i<l;i++){if(e[i].shouldRender()){d.push(e[i]);}}return d;};T.prototype._getVisibleColumnCount=function(){return this._getVisibleColumns().length;};T.prototype._getHeaderRowCount=function(){if(!this.getColumnHeaderVisible()){return 0;}else if(!this._useMultiHeader()){return 1;}var h=0;q.each(this._getVisibleColumns(),function(i,o){h=Math.max(h,o.getMultiLabels().length);});return h;};T.prototype._useMultiHeader=function(){var u=false;q.each(this._getVisibleColumns(),function(i,o){if(o.getMultiLabels().length>0){u=true;return false;}});return u;};T.prototype._getColumnsWidth=function(s,e){var d=this.getColumns();var f=0;if(s!==0&&!s){s=0;}if(e!==0&&!e){e=d.length;}for(var i=s,l=e;i<l;i++){if(d[i]&&d[i].shouldRender()){var w=d[i].getWidth();var W=parseInt(w,10);if(q.sap.endsWith(w,"px")){f+=W;}else{f+=this._iColMinWidth;}}}return f;};T.prototype._handleResize=function(){if(!this.getDomRef()){return;}this._updateHSb();this._updateColumnHeader();this._updateRowHeader();this._handleRowCountMode();};T.prototype._checkTableSize=function(){if(!this.getDomRef()){return;}var p=this.getDomRef().parentNode,h=p.offsetHeight,w=p.offsetWidth;if(p!=this._lastParent||h!=this._lastParentHeight||w!=this._lastParentWidth){this._handleResize();this._lastParent=p;this._lastParentHeight=h;this._lastParentWidth=w;if(this.getBinding("rows")){this.updateRows();}}};T.prototype._handleRowCountMode=function(){if(this.getVisibleRowCountMode()==sap.ui.table.VisibleRowCountMode.Auto){var i=this.$().parent().height();var r=this._calculateRowsToDisplay(i);if(isNaN(r)){return;}var t=this;this._visibleRowCountTimer=setTimeout(function(){t.setVisibleRowCount(r);},0);}};T.prototype._updateRowHeader=function(){if(this.getFixedRowCount()>=0||this.getFixedColumnCount()>=0||this.getRowHeight()<=0){var $=this.$();var d=$.find(".sapUiTableCtrlFixed > tbody > tr");var e=$.find(".sapUiTableCtrlScroll > tbody > tr");var f=$.find(".sapUiTableRowHdr");if(this.getFixedColumnCount()>0&&!this.getRowHeight()){d.css('height','');e.css('height','');}for(var i=0,l=e.length;i<l;i++){var h=Math.max(d[i]?(d[i].getBoundingClientRect().bottom-d[i].getBoundingClientRect().top):0,e[i]?(e[i].getBoundingClientRect().bottom-e[i].getBoundingClientRect().top):0);if(this._bjQueryLess18){q(f[i]).height(h);if(this.getFixedColumnCount()>0&&!this.getRowHeight()){q(d[i]).height(h);q(e[i]).height(h);}}else{q(f[i]).outerHeight(h);if(this.getFixedColumnCount()>0&&!this.getRowHeight()){q(d[i]).outerHeight(h);q(e[i]).outerHeight(h);}}}}};T.prototype._updateColumnHeader=function(u){if(this._sColHdrPosTimer){q.sap.clearDelayedCall(this._sColHdrPosTimer);}var r=this._bRtlMode;var l=this._bRtlMode?"99000px":"-99000px";var s=function(){this._resizeDependentColumns();var t=this,$=this.$();var d=$.find(".sapUiTableColHdr .sapUiTableCol");var e=$.find(".sapUiTableColHdr .sapUiTableColRsz");var f=this._getVisibleColumns();if(f.length==0){return;}var g=$.width();var h=$.find(".sapUiTableCtrlFirstCol > th");var H=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;var k=0;if(H){var o=h.get(0);k=o.getBoundingClientRect().right-o.getBoundingClientRect().left;h=h.not(":nth-child(1)");}h.each(function(i,E){if(f[i]){q(E).css('width',f[i].getWidth());}});h.each(function(z,E){var W=(E.getBoundingClientRect().right-E.getBoundingClientRect().left),A=f[z]?f[z].getHeaderSpan():1,B=[],D;if(A){if(q.isArray(A)){q.each(A,function(N,O){A[N]=Math.max((O+z>f.length)?Math.min(O,f.length-z):O,1);});D=A;}else{A=Math.max((A+z>f.length)?Math.min(A,f.length-z):A,1);D=[A];}}else{D=[1];}if(z==0){W+=k;}for(var i=0;i<D.length;i++){B[i]=W;for(var j=1;j<D[i];j++){var F=h[z+j];if(F){B[i]+=F.getBoundingClientRect().right-F.getBoundingClientRect().left;}}}var G=d.filter('[data-sap-ui-colindex='+q(E).data('sap-ui-headcolindex')+']');if(G.length>0){if(!u){var J=sap.ui.getCore().byId(G.first().data("sap-ui-colid"));for(var i=0;i<G.length;i++){if(t._bjQueryLess18){q(G[i]).width(B[i]||B[0]);}else{q(G[i]).outerWidth(B[i]||B[0]);}}J._iRealWidth=W;}var L=G.first().position().left;if(L===0&&G.css("display")=="none"){F=h[z];L=F.getBoundingClientRect().left;}var K=q(E).data('sap-ui-headcolindex');for(var i=0;i<D[0];i++){L+=(r?-2:(h[z+i].getBoundingClientRect().right-h[z+i].getBoundingClientRect().left)-3);var M=e.filter('[data-sap-ui-colindex='+K+']');if(L>=0&&L<=g){M.css({"left":L});}else if(M.css("left")!==l){M.css({"left":l});}K++;}}});var m=this.getColumnHeaderHeight()>0;if(!m&&!u){var n=$.find(".sapUiTableColHdr");var p=$.find(".sapUiTableColHdrCnt");var v=$.find(".sapUiTableColRowHdr");var w=v.add(p);w.height("auto");d.height("auto");var x=Math.max(n.height(),p.height());var y=x/this._getHeaderRowCount();if(this._bjQueryLess18){d.height(y);w.height(x);}else{d.outerHeight(y);w.outerHeight(x);}}};if(this._bOnAfterRendering){s.apply(this,arguments);}else{this._sColHdrPosTimer=q.sap.delayedCall(150,this,s);}};T.prototype._disableTextSelection=function(e){q(e||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(E){E.preventDefault();return false;});};T.prototype._enableTextSelection=function(e){q(e||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};T.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(e){}}};T.prototype.onvscroll=function(e){this._leaveActionMode();this.setFirstVisibleRow(this._getScrollTop(),true);};T.prototype._syncHeaderAndContent=function(){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var s=this._oHSb.getNativeScrollPosition();$.find(".sapUiTableCtrlScr").scrollLeft(s);if(!!sap.ui.Device.browser.webkit&&this._bRtlMode){var o=$.find(".sapUiTableColHdrScr").get(0);s=o.scrollWidth-o.clientWidth-this._oHSb.getScrollPosition();}$.find(".sapUiTableColHdrScr").scrollLeft(s);this._bSyncScrollLeft=false;}};T.prototype.onhscroll=function(e){if(!this._bOnAfterRendering){this._syncHeaderAndContent();this._updateColumnHeader(true);if(this.getBinding("rows")){this.updateRows();}}};T.prototype._oncolscroll=function(e){if(!this._bSyncScrollLeft){var $=this.$().find(".sapUiTableColHdrScr");if(!!sap.ui.Device.browser.webkit&&this._bRtlMode){var s=this.$().find(".sapUiTableColHdrScr").get(0);this._oHSb.setScrollPosition(s.scrollWidth-s.clientWidth-$.scrollLeft());}else{this._oHSb.setNativeScrollPosition($.scrollLeft());}}};T.prototype._oncntscroll=function(e){if(!this._bSyncScrollLeft){var $=this.$().find(".sapUiTableCtrlScr");this._oHSb.setNativeScrollPosition($.scrollLeft());}};T.prototype.onmousedown=function(e){var l=e.button===(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=8?1:0);if(l){var $=q(e.target);var d=this.$("sb");if(e.target==d[0]){q(document.body).bind("selectstart",q.proxy(this._splitterSelectStart,this));var o=d.offset();var h=d.height();var w=d.width();q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiHSBGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");d.append("<div id=\""+this.getId()+"-overlay\" style =\"left: 0px;"+" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");q(document).bind("mouseup",q.proxy(this._onGhostMouseRelease,this));q(document).bind("mousemove",q.proxy(this._onGhostMouseMove,this));return;}var f=$.closest(".sapUiTableCol");if(f.length===1){this._bShowMenu=true;this._sDelayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});if(this.getEnableColumnReordering()){var i=parseInt(f.attr("data-sap-ui-colindex"),10);if(i>this._iLastFixedColIndex){var g=this.getColumns()[i];this._sDelayedActionTimer=q.sap.delayedCall(200,this,function(){this._onColumnMoveStart(g);});}}}var j=!!(e.metaKey||e.ctrlKey);if(!!sap.ui.Device.browser.firefox&&j){e.preventDefault();}}};T.prototype.onmouseup=function(e){q.sap.clearDelayedCall(this._sDelayedActionTimer);if(e.isMarked()){return;}if(this.$().find(".sapUiTableCtrl td :focus").length>0){this._enterActionMode(this.$().find(".sapUiTableCtrl td :focus"));}else{this._leaveActionMode(e);}};T.prototype.onclick=function(e){q.sap.clearDelayedCall(this._sDelayedActionTimer);if(e.isMarked()){return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){this._onSelect(e);}else{e.preventDefault();}};T.prototype.oncontextmenu=function(e){var t=q(e.target);var h=t.closest('.sapUiTableCol');if(h.length>0){var o=sap.ui.getCore().byId(h.attr("data-sap-ui-colid"));if(o){o._openMenu(h[0]);}e.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,e,this._oncellcontextmenu)){e.preventDefault();}}};T.prototype._oncellcontextmenu=function(p){if(this.getEnableCellFilter()){if(!this._oContextMenu){q.sap.require("sap.ui.unified.Menu");q.sap.require("sap.ui.unified.MenuItem");this._oContextMenu=new sap.ui.unified.Menu(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var o=this._getVisibleColumns()[p.columnIndex];var s=o.getFilterProperty();if(s&&o.getShowFilterMenuEntry()){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var d=this.getContextByIndex(p.rowIndex);var v=d.getProperty(s);this.filter(o,v);},this]}));var e=sap.ui.core.Popup.Dock;this._oContextMenu.open(false,p.cellDomRef,e.BeginTop,e.BeginBottom,p.cellDomRef,"none none");return true;}}};T.prototype._bindSimulatedDoubleclick=function(e,f,d){var g="click";var t=this;if(!!sap.ui.Device.support.touch){g="touchend";}q(e).on(g,function(E){E.preventDefault();E.stopPropagation();t._clicksRegistered=t._clicksRegistered+1;if(t._clicksRegistered<2){t._singleClickTimer=q.sap.delayedCall(t._doubleclickDelay,t,function(){t._clicksRegistered=0;if(f){f.call(t,E);}},[E]);}else{q.sap.clearDelayedCall(t._singleClickTimer);t._clicksRegistered=0;d.call(t,E);}});};T.prototype._findAndfireCellEvent=function(f,e,d){var $=q(e.target);var g=$.closest("td[role='gridcell']");var i=g.attr("id");var m=/.*-row(\d*)-col(\d*)/i.exec(i);var h=false;if(m){var r=m[1];var j=m[2];var o=this.getRows()[r];var k=o&&o.getCells()[j];var l=o&&o.getIndex();var p={rowIndex:l,columnIndex:j,cellControl:k};h=!f.call(this,p);if(!h&&typeof d==="function"){p.cellDomRef=g[0];h=d.call(this,p);}}return h;};T.prototype.onfocusin=function(e){var $=q(e.target);if(!this._bIgnoreFocusIn&&($.hasClass("sapUiTableCtrlBefore")||$.hasClass("sapUiTableCtrlAfter"))){this.$("ariadesc").text(this._oResBundle.getText("TBL_TABLE"));this._leaveActionMode();if(q.contains(this.$().find('.sapUiTableColHdrCnt')[0],e.target)){q(this._oItemNavigation.getFocusedDomRef()||this._oItemNavigation.getRootDomRef()).focus();}else{if($.hasClass("sapUiTableCtrlBefore")){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex()%this._oItemNavigation.iColumns,e);}else{this._oItemNavigation.focusItem((this._oItemNavigation.getFocusedIndex()%this._oItemNavigation.iColumns)+(this._oItemNavigation.iColumns*this._iLastSelectedDataRow),e);}}e.preventDefault();}else if(q.sap.endsWith(e.target.id,"-rsz")){e.preventDefault();e.stopPropagation();}};T.prototype._onSelect=function(e){var $=q(e.target);var s=e.shiftKey;var d=!!(e.metaKey||e.ctrlKey);var f=$.closest(".sapUiTableCol");if(this._bShowMenu&&f.length===1){var i=parseInt(f.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[i];this._onColumnSelect(o,f[0]);return;}var g=$.closest(".sapUiTableRowHdr");if(g.length===1){var i=parseInt(g.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getFirstVisibleRow()+i,s,d);return;}if((this.getSelectionBehavior()===sap.ui.table.SelectionBehavior.Row||this.getSelectionBehavior()===sap.ui.table.SelectionBehavior.RowOnly)){var g=$.closest(".sapUiTableCtrl > tbody > tr");if(g.length===1){var i=parseInt(g.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getFirstVisibleRow()+i,s,d);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),e.target)){this._toggleSelectAll();return;}};T.prototype._isRowSelectable=function(r){return true;};T.prototype._onRowSelect=function(r,s,d){if(!!sap.ui.Device.browser.internet_explorer&&s){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(r<0||r>=(B.getLength()||0)){return;}if(!this._isRowSelectable(r)){return;}this._iSourceRowIndex=r;var o=this.getSelectionMode();if(o!==sap.ui.table.SelectionMode.None){if(o===sap.ui.table.SelectionMode.Single){if(!this.isIndexSelected(r)){this.setSelectedIndex(r);}else{this.clearSelection();}}else{if(o===sap.ui.table.SelectionMode.MultiToggle){d=true;}if(s){var i=this.getSelectedIndex();if(i>=0){this.addSelectionInterval(i,r);}else{this.setSelectedIndex(r);}}else{if(!this.isIndexSelected(r)){if(d){this.addSelectionInterval(r,r);}else{this.setSelectedIndex(r);}}else{if(d){this.removeSelectionInterval(r,r);}else{if(this.getSelectedIndices().length===1){this.clearSelection();}else{this.setSelectedIndex(r);}}}}}}this._iSourceRowIndex=undefined;};T.prototype._onColumnSelect=function(o,d){var e=this.fireColumnSelect({column:o});if(e){o._openMenu(d);}};T.prototype._onColumnMoveStart=function(o){this.$().addClass("sapUiTableDragDrop");this._disableTextSelection();var $=o.$();var i=parseInt($.attr("data-sap-ui-colindex"),10);if(i<this.getFixedColumnCount()){return;}this._$colGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});this._$colGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":this.$().zIndex()+10});this.$().find(".sapUiTableCol").each(function(d,e){var $=q(this);$.css({position:"relative"});$.data("pos",{left:$.position().left,center:$.position().left+$.outerWidth()/2,right:$.position().left+$.outerWidth()});});this._$colGhost.appendTo(document.body);q(document.body).mousemove(q.proxy(this._onColumnMove,this)).mouseup(q.proxy(this._onColumnMoved,this));};T.prototype._onColumnMove=function(e){var $=this.$();var r=this._bRtlMode;var i=e.pageX-$.offset().left;var d=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var D=this.getColumns()[d].$();var o=this._iNewColPos;this._iNewColPos=d;var t=this;$.find(".sapUiTableCol").each(function(f,g){var h=q(g);var j=parseInt(h.attr("data-sap-ui-colindex"),10);var H=sap.ui.getCore().byId(h.attr("data-sap-ui-colid")).getHeaderSpan();var s;if(H){if(q.isArray(H)){s=H[0];}else{s=H;}}else{s=1;}if(h.get(0)!==D.get(0)){var p=h.data("pos");var B=i>=p.left&&i<=p.center;var A=i>=p.center&&i<=p.right;if(!r){if(B){t._iNewColPos=j;}else if(A){t._iNewColPos=j+s;}else{t._iNewColPos=t._iNewColPos;}}else{if(A){t._iNewColPos=j;}else if(B){t._iNewColPos=j+s;}else{t._iNewColPos=t._iNewColPos;}}if((B||A)&&j>d){t._iNewColPos--;}}});if(this._iNewColPos<=this._iLastFixedColIndex){this._iNewColPos=o;}if(this._iNewColPos<this.getFixedColumnCount()){this._iNewColPos=o;}this._animateColumnMove(d,o,this._iNewColPos);this._$colGhost.css({"left":e.pageX+5,"top":e.pageY+5});};T.prototype._animateColumnMove=function(d,o,n){var r=this._bRtlMode;var D=this.getColumns()[d].$();if(o!==n){for(var i=Math.min(o,n),l=Math.max(o,n);i<=l;i++){var e=this.getColumns()[i];if(i!==d&&e.getVisible()){e.$().stop(true,true).animate({left:"0px"});}}var O=0;if(n<d){for(var i=n;i<d;i++){var e=this.getColumns()[i];if(e.getVisible()){var $=e.$();O-=$.outerWidth();$.stop(true,true).animate({left:D.outerWidth()*(r?-1:1)+"px"});}}}else{for(var i=d+1,l=n+1;i<l;i++){var e=this.getColumns()[i];if(e.getVisible()){var $=e.$();O+=$.outerWidth();$.stop(true,true).animate({left:D.outerWidth()*(r?1:-1)+"px"});}}}D.stop(true,true).animate({left:O*(r?-1:1)+"px"});}};T.prototype._onColumnMoved=function(e){this.$().removeClass("sapUiTableDragDrop");var d=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var D=this.getColumns()[d];q(document.body).unbind("mousemove",this._onColumnMove).unbind("mouseup",this._onColumnMoved);this._$colGhost.remove();this._$colGhost=undefined;this._enableTextSelection();var E=this.fireColumnMove({column:D,newPos:this._iNewColPos});var m=d<this._iNewColPos;if(E&&this._iNewColPos!==undefined&&this._iNewColPos!==d){this.removeColumn(D);this.insertColumn(D,this._iNewColPos);var h=D.getHeaderSpan(),s;if(h){if(q.isArray(h)){s=h[0];}else{s=h;}}else{s=1;}if(s>1){if(!m){this._iNewColPos++;}for(var i=1;i<s;i++){var o=this.getColumns()[m?d:d+i];this.removeColumn(o);this.insertColumn(o,this._iNewColPos);this.fireColumnMove({column:o,newPos:this._iNewColPos});if(!m){this._iNewColPos++;}}}this._oColHdrItemNav.setFocusedIndex(this._iNewColPos);}else{this._animateColumnMove(d,this._iNewColPos,d);D.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}setTimeout(function(){var O=this._oItemNavigation.getFocusedIndex();this._oItemNavigation.focusItem(0,e);this._oItemNavigation.focusItem(O,e);}.bind(this),0);delete this._iNewColPos;};T.prototype._onAutomaticColumnResize=function(e){var i,o,h,m,d=1,r=false;q.sap.log.debug("doubleclick fired");this._disableTextSelection();this._$colResize=q(e.target);this._$colResize.addClass("sapUiTableColRszActive");var p=parseInt(this._$colResize.prevAll(".sapUiTableCol").first().attr("data-sap-ui-colindex"),10);i=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);if(p!=i){r=true;}if(r){o=this.getColumns()[p];h=o.getHeaderSpan();if(h instanceof Array){m=Math.max.apply(Math,h);}else if(!!h){m=h;}if(i+h-1!=p){d=m;i=p+m;}}if(d>1){while(i>p){i--;this.autoResizeColumn(i);}}else{this.autoResizeColumn(i);}e.preventDefault();e.stopPropagation();};T.prototype._onColumnResizeStart=function(e){var l=e.button===(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=8?1:0);if(l){this._iColumnResizeStart=e.pageX;this._disableTextSelection();this._$colResize=q(e.target);q(document.body).mousemove(q.proxy(this._onColumnResize,this)).mouseup(q.proxy(this._onColumnResized,this));}};T.prototype._onColumnResize=function(e){if(this._iColumnResizeStart&&e.pageX<this._iColumnResizeStart+3&&e.pageX>this._iColumnResizeStart-3){return;}this._$colResize.addClass("sapUiTableColRszActive");this._iColumnResizeStart=null;var $=this.$();var r=this._bRtlMode;var i=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[i];var d=$.find(".sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex='"+i+"']");var f=d.position().left;var w;if(!r){if(this.getFixedColumnCount()>0&&i>=this.getFixedColumnCount()){var F=$.find(".sapUiTableColHdrFixed").width();f=f+F;f=f-$.find(".sapUiTableCtrlScr").scrollLeft();}var O=$.find(".sapUiTableCtrlFirstCol > th:first").offset().left;var g=e.pageX-O;w=g-f;}else{var s;if(this.getFixedColumnCount()>0&&i<this.getFixedColumnCount()){s=$.find('.sapUiTableCtrlScrFixed');}else{s=$.find('.sapUiTableCtrlScr');}var h=s.scrollLeft();if(sap.ui.Device.browser.internet_explorer){h=s[0].scrollWidth-h-s[0].clientWidth;}else if(sap.ui.Device.browser.firefox){h=h+s[0].scrollWidth-s[0].clientWidth;}var D=f-h-e.pageX+s.offset().left;w=d.outerWidth()+D;}w=Math.max(w,this._iColMinWidth);var j=$.find(".sapUiTableCnt").offset().left;var k=e.pageX-j;k-=this._$colResize.width()/2;this._$colResize.css("left",k);o._iNewWidth=w;};T.prototype._onColumnResized=function(e,i){var d;if(!this._$colResize&&(i===null||i===undefined)){return;}if(i===null||i===undefined){d=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);}else{d=i;}var o=this.getColumns()[d];var r=false;if(!this._iColumnResizeStart&&o._iNewWidth){var w;var A=this.$().find(".sapUiTableCtrl").width();if(!this._checkPercentageColumnWidth()){w=o._iNewWidth+"px";}else{var f=Math.round(100/A*o._iNewWidth);w=f+"%";}this._updateColumnWidth(o,w);this._resizeDependentColumns(o,w);delete o._iNewWidth;r=true;}q(document.body).unbind("mousemove",this._onColumnResize).unbind("mouseup",this._onColumnResized);o.focus();if(this._$colResize){this._$colResize.removeClass("sapUiTableColRszActive");this._$colResize=undefined;}this._enableTextSelection();if(r){this.invalidate();}};T.prototype._resizeDependentColumns=function(o,w){if(this._checkPercentageColumnWidth()){var v=this._getVisibleColumns();var d;q.each(v,function(m,s){if(o===s){d=m;}});var O=0;var l=v.length-1;var t;if(d===undefined){t=0;}else{t=parseInt(w,10);}var p=0;var e=[];var f=this;q.each(v,function(m,s){var u=f._getColumnPercentageWidth(s);if((((d===l&&m<d)||((d!==l)&&m>d))&&s.getFlexible())||d===undefined){O+=s.$().outerWidth();p+=u;e.push(s);}else if(m!==d){t+=u;}});var g=t;q.each(e,function(m,s){var u=f._getColumnPercentageWidth(s);var N=Math.round((100-g)/p*u);if(m===e.length-1){N=100-t;}else{t+=N;}f._updateColumnWidth(s,N+"%");});}else if(!this._hasOnlyFixColumnWidths()){var v=this._getVisibleColumns(),A=this.$().find(".sapUiTableCtrl").width(),d,r=0,L=0,h=0,n=0;q.each(v,function(m,s){if(!q.sap.endsWith(s.getWidth(),"px")){n++;return false;}if(d!=undefined){h+=parseInt(s.getWidth(),10);r++;}else if(o!==s){L+=parseInt(s.getWidth(),10);}if(o===s){d=m;L+=parseInt(w,10);}});if(n>0||(L+h>A)){return;}A-=L;for(var i=d+1;i<v.length;i++){var o=v[i],j=parseInt(o.getWidth(),10),k=j/h*100,N=A/100*k;this._updateColumnWidth(o,Math.round(N)+'px');}}};T.prototype._getColumnPercentageWidth=function(o){var s=o.getWidth();var i=parseInt(o.getWidth(),10);var t=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(s,"px")){i=Math.round(100/t*i);}else if(!q.sap.endsWith(s,"%")){i=Math.round(100/t*o.$().width());}return i;};T.prototype._updateColumnWidth=function(o,w){var e=this.fireColumnResize({column:o,width:w});if(e){o.setProperty("width",w,true);this.$().find('th[aria-owns="'+o.getId()+'"]').css('width',w);}};T.prototype._checkPercentageColumnWidth=function(){var d=this.getColumns();var h=false;q.each(d,function(i,o){if(q.sap.endsWith(o.getWidth(),"%")){h=true;return false;}});return h;};T.prototype._hasOnlyFixColumnWidths=function(){var o=true;q.each(this.getColumns(),function(i,d){var w=d.getWidth();if(d.getFlexible()||!w||w.substr(-2)!=="px"){o=false;return false;}});return o;};T.prototype.sort=function(o,s,A){if(q.inArray(o,this.getColumns())>=0){o.sort(s===sap.ui.table.SortOrder.Descending,A);}};T.prototype.filter=function(o,v){if(q.inArray(o,this.getColumns())>=0){o.filter(v);}};T.prototype._updateSelection=function(){if(this.getSelectionMode()===sap.ui.table.SelectionMode.None){return;}var $=this.$();var f=this.getFirstVisibleRow();var t=this;var r=this._oResBundle;var m=this._oSelection.getSelectedIndices().length>1;var s=this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowSelector;var d=r.getText("TBL_ROW_SELECT");var e=r.getText("TBL_ROW_SELECT_KEY");var g=r.getText("TBL_ROW_DESELECT");var h=r.getText("TBL_ROW_DESELECT_KEY");var i=r.getText("TBL_ROW_SELECT_MULTI");var j=r.getText("TBL_ROW_SELECT_MULTI_KEY");var k=r.getText("TBL_ROW_DESELECT_MULTI");var l=r.getText("TBL_ROW_DESELECT_MULTI_KEY");$.find(".sapUiTableRowHdr").each(function(n,E){var o=q($.find(".sapUiTableCtrlFixed > tbody > tr").get(n));var p=q($.find(".sapUiTableCtrlScroll > tbody > tr").get(n));var u=o.add(p);var v=q(this);var w=v.add(u);if(t.isIndexSelected(f+n)){if(!q(this).hasClass("sapUiTableRowSel")){q(this).addClass("sapUiTableRowSel");u.addClass("sapUiTableRowSel");w.attr("aria-selected","true");u.children("td").attr("aria-selected","true");}if(m){u.find(".sapUiTableAriaRowSel").text(l);if(s){w.attr("title",k).attr("aria-label",l);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-deselectrowmulti");}}else{u.find(".sapUiTableAriaRowSel").text(h);if(s){w.attr("title",g).attr("aria-label",h);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-deselectrow");}}}else{if(q(this).hasClass("sapUiTableRowSel")){q(this).removeClass("sapUiTableRowSel");u.removeClass("sapUiTableRowSel");if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi||t.getSelectionMode()===sap.ui.table.SelectionMode.MultiToggle){w.attr("aria-selected","false");u.children("td").attr("aria-selected","false");}else{w.removeAttr("aria-selected");u.children("td").removeAttr("aria-selected");}}if((t.getSelectionMode()===sap.ui.table.SelectionMode.Multi||t.getSelectionMode()===sap.ui.table.SelectionMode.MultiToggle)&&t._oSelection.getSelectedIndices().length>0){u.find(".sapUiTableAriaRowSel").text(i);if(s){w.attr("title",i).attr("aria-label",j);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-selectrowmulti");}}else{u.find(".sapUiTableAriaRowSel").text(e);if(s){w.attr("title",d).attr("aria-label",e);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-selectrow");}}}});this.setProperty("selectedIndex",this.getSelectedIndex(),true);};T.prototype._onSelectionChanged=function(e){var r=e.getParameter("rowIndices");var i=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();var s=this.getSelectionMode();if(s==="Multi"||s==="MultiToggle"){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");}this.fireRowSelectionChange({rowIndex:i,rowContext:this.getContextByIndex(i),rowIndices:r});};T.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContexts(i,1)[0]:null;};T.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};T.prototype.setSelectedIndex=function(i){if(i===-1){this._oSelection.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};T.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};T.prototype.selectAll=function(){var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){this._oSelection.setSelectionInterval(0,(B.getLength()||0)-1);this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};T.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};T.prototype.addSelectionInterval=function(i,d){this._oSelection.addSelectionInterval(i,d);return this;};T.prototype.setSelectionInterval=function(i,d){this._oSelection.setSelectionInterval(i,d);return this;};T.prototype.removeSelectionInterval=function(i,d){this._oSelection.removeSelectionInterval(i,d);return this;};T.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};T.prototype._scrollNext=function(){if(this.getFirstVisibleRow()<this._getRowCount()-this.getVisibleRowCount()){this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow()+1,this._getRowCount()-this.getVisibleRowCount()));}};T.prototype._scrollPrevious=function(){if(this.getFirstVisibleRow()>0){this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow()-1,0));}};T.prototype._scrollPageUp=function(){this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow()-this.getVisibleRowCount(),0));};T.prototype._scrollPageDown=function(){this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow()+this.getVisibleRowCount(),this._getRowCount()-this.getVisibleRowCount()));};T.prototype._isTopRow=function(e){var $=q(e.target);var r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=this.getFixedRowCount();if(f>0&&r>=f){return r===f;}return r===0;};T.prototype._isBottomRow=function(e){var $=q(e.target);var r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=this.getFixedBottomRowCount();if(f>0&&r<=this.getVisibleRowCount()-1-f){return r===this.getVisibleRowCount()-1-f;}return r===this.getVisibleRowCount()-1;};T.prototype._enterActionMode=function(f){if(f.length>0&&!this._bActionMode){if(f.filter(":sapTabbable").length==0){return;}this._bActionMode=true;this.removeDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","-1");f.filter(":sapTabbable").eq(0).focus();}};T.prototype._leaveActionMode=function(e){if(this._bActionMode){this._bActionMode=false;this.addDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","0");if(e){if(q(e.target).closest("td[tabindex='-1']").length>0){var i=q(this._oItemNavigation.aItemDomRefs).index(q(e.target).closest("td[tabindex='-1']").get(0));this._oItemNavigation.focusItem(i,null);}else{if(q.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0),e.target)){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}};T.prototype._getFocusedRowIndex=function(){var f=this._oItemNavigation.iFocusedIndex;var i=this._oItemNavigation.iColumns;var s=f%i;var d=this.getFirstVisibleRow()+(f-s)/i;if(!this.getColumnHeaderVisible()){d++;}return d-1;};T.prototype._isFocusedRowSelected=function(){var s=this._getFocusedRowIndex();var i=this.isIndexSelected(s);var d=(this._oItemNavigation.iFocusedIndex%this._oItemNavigation.iColumns==0);if(d){return i;}else{var h=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;if(h){return null;}else{return i;}}};T.prototype.onkeyup=function(e){if(!this._bEventSapSelect===true){return;}this._bEventSapSelect=false;if(e.keyCode!==q.sap.KeyCodes.ENTER&&e.keyCode!==q.sap.KeyCodes.SPACE&&e.keyCode!==q.sap.KeyCodes.F4||e.srcControl!==this&&q.inArray(e.srcControl,this.getRows())===-1&&q.inArray(e.srcControl,this.getColumns())===-1){return;}var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B){if(B.isExpanded(r)){B.collapse(r);}else{B.expand(r);}}e.preventDefault();return;}this._bShowMenu=true;this._onSelect(e);this._bShowMenu=false;e.preventDefault();};T.prototype.onsapselect=function(){this._bEventSapSelect=true;};T.prototype.onkeydown=function(e){var $=this.$();if(!this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2||e.keyCode==q.sap.KeyCodes.ENTER){if($.find(".sapUiTableCtrl td:focus").length>0){this._enterActionMode($.find(".sapUiTableCtrl td:focus").find(":sapFocusable"));e.preventDefault();e.stopPropagation();}}else if(this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2){this._leaveActionMode(e);}else if(e.keyCode==q.sap.KeyCodes.TAB&&this._bActionMode){if(this.getFixedColumnCount()>0){var d=q(e.target);if(d.is("td[role=gridcell]")==false){d=d.parents("td[role=gridcell]");}var f=d.parent("tr[data-sap-ui-rowindex]");var g=f.closest(".sapUiTableCtrl");var r=parseInt(f.attr("data-sap-ui-rowindex"),10);var h=f.find("td[role=gridcell]");var i=h.index(d);var t=h.length;if(i===(t-1)){var j;if(g.hasClass("sapUiTableCtrlFixed")){j=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll");}else{j=$.find(".sapUiTableCtrl.sapUiTableCtrlFixed");r++;if(r==this.getVisibleRowCount()){r=0;}}var k=j.find("tr[data-sap-ui-rowindex='"+r+"']");var l=k.find("td :sapFocusable[tabindex='0']").first();if(l.length>0){l.focus();e.preventDefault();}}}}else if(e.keyCode==q.sap.KeyCodes.A&&(e.metaKey||e.ctrlKey)){var o=this._oItemNavigation;var F=o.getFocusedIndex();this._toggleSelectAll();o.focusItem(F,e);e.preventDefault();e.stopImmediatePropagation(true);}else if(e.keyCode===q.sap.KeyCodes.F10&&(e.shiftKey)){this.oncontextmenu(e);}};T.prototype.onsapescape=function(e){this._leaveActionMode(e);};T.prototype.onsaptabprevious=function(e){var $=this.$();if(this._bActionMode){this._leaveActionMode();e.preventDefault();}else{var i=this._oItemNavigation;if(q.contains($.find('.sapUiTableCCnt')[0],e.target)&&this.getColumnHeaderVisible()){var d=i.getFocusedIndex()%i.iColumns;i.focusItem(d,e);e.preventDefault();}else if(i.getFocusedDomRef()===e.target&&q.sap.containsOrEquals($.find(".sapUiTableCCnt").get(0),e.target)){this._bIgnoreFocusIn=true;$.find(".sapUiTableCtrlBefore").focus();this._bIgnoreFocusIn=false;}}};T.prototype.onsaptabnext=function(e){var $=this.$();if(this._bActionMode){this._leaveActionMode();e.preventDefault();}else{var i=this._oItemNavigation;if(q.contains($.find('.sapUiTableColHdrCnt')[0],e.target)){i.focusItem(i.getFocusedIndex()+i.iColumns*this._iLastSelectedDataRow,e);e.preventDefault();}else if(i.getFocusedDomRef()===e.target){this._bIgnoreFocusIn=true;$.find(".sapUiTableCtrlAfter").focus();this._bIgnoreFocusIn=false;}}};T.prototype.onsapdown=function(e){if(!this._bActionMode&&this._isBottomRow(e)){if(this.getFirstVisibleRow()!=this._getRowCount()-this.getVisibleRowCount()-this.getFixedBottomRowCount()){e.stopImmediatePropagation(true);if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar){this._scrollNext();}else{this._scrollPageDown();}}}e.preventDefault();};T.prototype.onsapdownmodifiers=function(e){if(e.shiftKey){var f=this._getFocusedRowIndex();var i=this._isFocusedRowSelected();if(i===true){this.addSelectionInterval(f+1,f+1);}else if(i===false){this.removeSelectionInterval(f+1,f+1);}if(this._isBottomRow(e)){this._scrollNext();}}else if(e.altKey){this._toggleGroupHeader(e);}};T.prototype.onsapupmodifiers=function(e){if(e.shiftKey){var f=this._getFocusedRowIndex();var i=this._isFocusedRowSelected();if(i===true){this.addSelectionInterval(f-1,f-1);}else if(i===false){this.removeSelectionInterval(f-1,f-1);}if(this._isTopRow(e)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}this._scrollPrevious();}}else if(e.altKey){this._toggleGroupHeader(e);}};T.prototype.onsapup=function(e){if(!this._bActionMode&&this._isTopRow(e)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar){this._scrollPrevious();}else{this._scrollPageUp();}}e.preventDefault();};T.prototype.onsappagedown=function(e){if(!this._bActionMode){var $=this.$();var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;if(this.getColumnHeaderVisible()&&i.iFocusedIndex<(i.iColumns*h)){var d=i.iFocusedIndex%i.iColumns;if((i.iFocusedIndex<=(i.iColumns*h)&&i.iFocusedIndex>=(i.iColumns*h)-i.iColumns)||(d===0&&r)){this.setFirstVisibleRow(0);i.focusItem(i.iColumns*h+d,e);}else{i.focusItem(i.iColumns*h-i.iColumns+d,e);}e.stopImmediatePropagation(true);}else{if(this._isBottomRow(e)){this._scrollPageDown();}}e.preventDefault();}};T.prototype.onsappagedownmodifiers=function(e){if(!this._bActionMode&&e.altKey){var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var d=i.iFocusedIndex%i.iColumns;var n;if(d==0&&r){n=1;}else{var v=this._aVisibleColumns.length;var m=this._getVisibleColumns().length;if(!r){m--;}if(v===0){n=m;}else{n=Math.min(m,d+v);}}i.focusItem(i.iFocusedIndex-(d-n),e);e.stopImmediatePropagation(true);e.preventDefault();}};T.prototype.onsappageup=function(e){if(!this._bActionMode){var $=this.$();var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;var d=i.iFocusedIndex%i.iColumns;if(this.getColumnHeaderVisible()&&i.iFocusedIndex<(i.iColumns*h)){if(i.iFocusedIndex>i.iColumns){i.focusItem(d,e);}e.stopImmediatePropagation(true);}else{if(this.getColumnHeaderVisible()&&this.getFirstVisibleRow()==0&&this._isTopRow(e)){if(r&&d===0){i.focusItem(d,e);}else{i.focusItem(i.iColumns*h-i.iColumns+d,e);}e.stopImmediatePropagation(true);}else{var f=this.getColumnHeaderVisible()?i.iColumns*h:0;i.focusItem(f+d,e);e.stopImmediatePropagation(true);if(this._isTopRow(e)){this._scrollPageUp();}}}e.preventDefault();}};T.prototype.onsappageupmodifiers=function(e){if(!this._bActionMode&&e.altKey){var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var d=i.iFocusedIndex%i.iColumns;if(d>0){var n;if(d==1&&r){n=0;}else{var v=this._aVisibleColumns.length;if(v===0){if(r){n=1;}else{n=0;}}else{var m=1;if(!r){m=0;}n=Math.max(m,d-v);}}i.focusItem(i.iFocusedIndex-(d-n),e);}e.stopImmediatePropagation(true);e.preventDefault();}};T.prototype.onsaphome=function(e){var i=(this.getSelectionBehavior()==sap.ui.table.SelectionBehavior.RowOnly);var d=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(d){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var g=this._oItemNavigation.iColumns;var s=f%g;var o=0;if(!i){o=1;}if(s>this.getFixedColumnCount()+o){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-s+this.getFixedColumnCount()+o,null);}else if(!i){if(s>1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-s+1,null);}else if(s==1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-1,null);}else{e.stopImmediatePropagation(true);}}};T.prototype.onsapend=function(e){var i=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(i){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var d=this._oItemNavigation.iColumns;var s=f%d;var g=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var o=0;if(!g){o=1;}if(s===0&&g){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f+1,null);}else if(s<this.getFixedColumnCount()-o){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-s+this.getFixedColumnCount()-o,null);}};T.prototype.onsaphomemodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);if(i){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var d=this._oItemNavigation.iColumns;var s=Math.ceil(f/d)-1;var g=f%d;if(this.getColumnHeaderVisible()){if(s==1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(g,e);}else if(s>1){e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var h=g+d;this._oItemNavigation.focusItem(h,e);}}else{e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var h=f-s*d;this._oItemNavigation.focusItem(h,e);}}};T.prototype.onsapendmodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);var f=this._oItemNavigation.iFocusedIndex;var d=this._oItemNavigation.iColumns;var s=f%d;e.stopImmediatePropagation(true);if(i){this._oItemNavigation.focusItem(f+d,e);}else{this.setFirstVisibleRow(this._getRowCount()-this.getVisibleRowCount());var g=this._oItemNavigation.aItemDomRefs.length-(d-s);this._oItemNavigation.focusItem(g,e);}}};T.prototype.onsapleft=function(e){this._collapseGroupHeader(e);};T.prototype.onsapright=function(e){this._expandGroupHeader(e);};T.prototype._toggleGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(r)){B.collapse(r);}else{B.expand(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype._collapseGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(r)){B.collapse(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype._expandGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&!B.isExpanded(r)){B.expand(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype.onsapleftmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var d=parseInt(t.attr('data-sap-ui-colindex'),10),v=this._getVisibleColumns(),o=v[this._aVisibleColumns.indexOf(d)];if(e.shiftKey){var n=parseInt(o.getWidth(),10)-16;o.setWidth((n>20?n:20)+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){if(d-1>=0){var N=0;for(var p=this._aVisibleColumns.indexOf(d)-1;p>=0;p--){N=this._aVisibleColumns[p];if(v[p].$().css("display")!=="none"){break;}}this.removeColumn(o);this.insertColumn(o,N);var h=o.getHeaderSpan();if(h>1){for(var i=1;i<h;i++){o=v[d+i];this.removeColumn(o);this.insertColumn(o,N+i);}}}e.preventDefault();e.stopImmediatePropagation();}}};T.prototype.onsaprightmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var d=parseInt(t.attr('data-sap-ui-colindex'),10);var v=this._getVisibleColumns();var p=this._aVisibleColumns.indexOf(d);var o=v[p];if(e.shiftKey){o.setWidth(parseInt(o.getWidth(),10)+16+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){var h=o.getHeaderSpan();if(p<v.length-h){var n=v[p+1].getHeaderSpan(),N=this._aVisibleColumns[p+n];for(var i=h-1;i>=0;i--){o=v[p+i];this.removeColumn(o);this.insertColumn(o,N+i);}}e.preventDefault();e.stopImmediatePropagation();}}};T.prototype.setGroupBy=function(v){var g=v;if(typeof g==="string"){g=sap.ui.getCore().byId(g);}var r=false;if(g&&g instanceof sap.ui.table.Column){if(q.inArray(g,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var e=this.fireGroup({column:g,groupedColumns:[g.getId()],type:sap.ui.table.GroupEventType.group});var o=sap.ui.getCore().byId(this.getGroupBy());if(o){o.setGrouped(false);r=true;}if(e&&g instanceof sap.ui.table.Column){g.setGrouped(true);}}if(!g||r){var B=this.getBindingInfo("rows");delete B.binding;this._bindAggregation("rows",B);}return this.setAssociation("groupBy",g);};T.prototype.getBinding=function(n){n=n||"rows";var B=sap.ui.core.Element.prototype.getBinding.call(this,n);if(this.getEnableGrouping()){q.sap.require("sap.ui.model.ClientListBinding");var g=sap.ui.getCore().byId(this.getGroupBy());var d=g&&g.getGrouped()&&n==="rows"&&B&&B instanceof sap.ui.model.ClientListBinding;if(d&&!B._modified){B._modified=true;this._modifyRow=function(r,$){this.$().find(".sapUiTableRowHdrScr").css("display","block");var h=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.isGroupHeader(r)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var s=B.isExpanded(r)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";h.html("<div class=\"sapUiTableGroupIcon "+s+"\" tabindex=\"-1\">"+B.getTitle(r)+"</div>");h.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");h.html("");h.removeClass("sapUiTableGroupHeader");}};this.onclick=function(E){if(q(E.target).hasClass("sapUiTableGroupIcon")){var $=q(E.target).parents("[data-sap-ui-rowindex]");if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B.isExpanded(r)){B.collapse(r);q(E.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");}else{B.expand(r);q(E.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");}}}else{if(T.prototype.onclick){T.prototype.onclick.apply(this,arguments);}}};var p=g.getSortProperty();B.sort(new sap.ui.model.Sorter(p));var l=B.getLength(),e=B.getContexts(0,l);var k;var f=0;for(var i=l-1;i>=0;i--){var N=e[i].getProperty(p);if(!k){k=N;}if(k!==N){e.splice(i+1,0,{oContext:e[i+1],name:k,count:f,groupHeader:true,expanded:true});k=N;f=0;}f++;}e.splice(0,0,{oContext:e[0],name:k,count:f,groupHeader:true,expanded:true});q.extend(B,{getLength:function(){return e.length;},getContexts:function(s,l){return e.slice(s,s+l);},isGroupHeader:function(h){var o=e[h];return o&&!(o instanceof sap.ui.model.Context);},getTitle:function(h){var o=e[h];return o&&!(o instanceof sap.ui.model.Context)&&(o["name"]+" - "+o["count"]);},isExpanded:function(h){return this.isGroupHeader(h)&&e[h].expanded;},expand:function(h){if(this.isGroupHeader(h)&&!e[h].expanded){for(var i=0;i<e[h].childs.length;i++){e.splice(h+1+i,0,e[h].childs[i]);}delete e[h].childs;e[h].expanded=true;this._fireChange();}},collapse:function(h){if(this.isGroupHeader(h)&&e[h].expanded){e[h].childs=e.splice(h+1,e[h].count);e[h].expanded=false;this._fireChange();}}});}}return B;};T.prototype.resetGrouping=function(){var B=this.getBinding("rows");if(B&&B._modified){this.$().find(".sapUiTableRowHdrScr").css("display","");this.onclick=T.prototype.onclick;this._modifyRow=undefined;var o=this.getBindingInfo("rows");this.unbindRows();this.bindRows(o);}};T.prototype.setEnableGrouping=function(e){this.setProperty("enableGrouping",e);if(!e){this.resetGrouping();}this._invalidateColumnMenus();return this;};T.prototype.setEnableCustomFilter=function(e){this.setProperty("enableCustomFilter",e);this._invalidateColumnMenus();return this;};T.prototype.setEnableColumnFreeze=function(e){this.setProperty("enableColumnFreeze",e);this._invalidateColumnMenus();return this;};T.prototype.setShowColumnVisibilityMenu=function(s){this.setProperty("showColumnVisibilityMenu",s);this._invalidateColumnMenus();return this;};T.prototype.setFixedColumnCount=function(f){var d=this._getVisibleColumns();var h=d[f-1]&&d[f-1].getHeaderSpan();if(h){var H;if(q.isArray(h)){H=parseInt(h[0],10);}else{H=parseInt(h,10);}f+=H-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<f;i++){var o=d[i];if(o){var e=q.inArray(o,this.getColumns());if(!o.getWidth()){o.setWidth($.filter("[data-sap-ui-headcolindex='"+e+"']").width()+"px");}}}this.setProperty("fixedColumnCount",f);this._invalidateColumnMenus();return this;};T.prototype._invalidateColumnMenus=function(){var d=this.getColumns();for(var i=0,l=d.length;i<l;i++){if(d[i].getMenu()){d[i].getMenu()._bInvalidated=true;}}};T.prototype._splitterSelectStart=function(e){e.preventDefault();e.stopPropagation();return false;};T.prototype._onGhostMouseRelease=function(e){var s=this.getDomRef("ghost");var n=e.pageY-this.$().offset().top;this.setVisibleRowCount(this._calculateRowsToDisplay(n));q(s).remove();this.$("overlay").remove();q(document.body).unbind("selectstart",this._splitterSelectStart);q(document).unbind("mouseup",this._onGhostMouseRelease);q(document).unbind("mousemove",this._onGhostMouseMove);};T.prototype._onGhostMouseMove=function(e){var s=this.getDomRef("ghost");var m=this.$().offset().top;if(e.pageY>m){q(s).css("top",e.pageY+"px");}};T.prototype._calculateRowsToDisplay=function(h){var m=this.getMinAutoRowCount()||5;if(!h){return m;}var $=this.$();if(!$.get(0)){return;}var i=$.get(0).getBoundingClientRect().height;var d=$.find('.sapUiTableCCnt').outerHeight();var r=$.find("tr:not(.sapUiAnalyticalTableSum) > td").outerHeight();if(!r){var s="sap.ui.table.Table:sapUiTableRowHeight";if($.parents().hasClass('sapUiSizeCompact')){s="sap.ui.table.Table:sapUiTableCompactRowHeight";}r=parseInt(P.get(s),10);}var M=window.innerHeight-2*r;var e=h-(i-d);var A=Math.min(e,M);return Math.max(m,Math.floor((A+1)/r));};T.prototype.setShowNoData=function(s){this.setProperty('showNoData',s,true);s=this.getProperty('showNoData');if(!s){this.$().removeClass("sapUiTableEmpty");}else{this._updateNoData();}return this;};T.prototype.setNoDataText=function(t){this.setProperty("noDataText",t,true);this.$().find('.sapUiTableCtrlEmptyMsg').text(t);};T.prototype.exportData=function(s){q.sap.require("sap.ui.core.util.Export");s=s||{};if(!s.rows){var B=this.getBinding("rows"),o=this.getBindingInfo("rows");var f=B.aFilters.concat(B.aApplicationFilters);s.rows={path:o.path,model:o.model,sorter:B.aSorters,filters:f,parameters:o.parameters};}if(!s.exportType){q.sap.require("sap.ui.core.util.ExportTypeCSV");s.exportType=new sap.ui.core.util.ExportTypeCSV();}var m=s.rows.model;if(!m){var p=s.rows.path;var d=p.indexOf(">");if(d>0){m=p.substr(0,d);}}if(!s.columns){s.columns=[];var e=this.getColumns();for(var i=0,l=e.length;i<l;i++){var g=e[i];if(g.getSortProperty()){s.columns.push({name:g.getLabel().getText(),template:{content:{path:g.getSortProperty(),model:m}}});}}}var E=new sap.ui.core.util.Export(s);this.addDependent(E);return E;};T.prototype._calculateAutomaticColumnWidth=function(d){var t=["sap.m.Text","sap.m.Label","sap.m.Link","sap.ui.commons.TextView","sap.ui.commons.Label","sap.ui.commons.Link"];var $=this.$();var h=0;var e=$.find('td[headers=\"'+this.getId()+'_col'+d+'\"]').children("div");var o=this.getColumns();var f=o[d];if(!f){return null;}var H=f.getHeaderSpan();var g=f.getLabel();var j=this;var k=f.getTemplate();var l=q.inArray(k.getMetadata().getName(),t)!=-1||sap.ui.commons&&sap.ui.commons.TextField&&k instanceof sap.ui.commons.TextField||sap.m&&sap.m.Input&&k instanceof sap.m.Input;var m=document.createElement("div");document.body.appendChild(m);q(m).addClass("sapUiTableHiddenSizeDetector");var n=f.getMultiLabels();if(n.length==0&&!!g){n=[g];}if(n.length>0){q.each(n,function(s,L){var u;if(!!L.getText()){q(m).text(L.getText());h=m.scrollWidth;}else{h=L.$().scrollWidth;}h=h+$.find("#"+f.getId()+"-icons").first().width();$.find(".sapUiTableColIcons#"+f.getId()+"_"+s+"-icons").first().width();if(H instanceof Array&&H[s]>1){u=H[s];}else if(H>1){u=H;}if(!!u){var i=u-1;while(i>d){h=h-(j._oCalcColumnWidths[d+i]||0);i-=1;}}});}var p=Math.max.apply(null,e.map(function(){var _=q(this);return parseInt(_.css('padding-left'),10)+parseInt(_.css('padding-right'),10)+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10);}).get());var r=Math.max.apply(null,e.children().map(function(){var w=0,W=0;var _=q(this);var s=_.text()||_.val();if(l){q(m).text(s);W=m.scrollWidth;}else{W=this.scrollWidth;}if(h>W){W=h;}w=W+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10)+p+1;return w;}).get());q(m).remove();return(r>this._iColMinWidth)?r:this._iColMinWidth;};T.prototype._onPersoApplied=function(){var d=this.getColumns();var s=[];for(var i=0,l=d.length;i<l;i++){var o=d[i];if(o.getSorted()){s.push(new sap.ui.model.Sorter(o.getSortProperty(),o.getSortOrder()===sap.ui.table.SortOrder.Descending));}}if(s.length>0&&this.getBinding("rows")){this.getBinding("rows").sort(s);}this.refreshRows();};T.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this.clearSelection();}else{this.selectAll();}if(!!sap.ui.Device.browser.internet_explorer){this.$("selall").focus();}};T.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var d=this.getColumns();q.each(d,function(i,o){o._restoreAppDefaults();});};T.prototype._setBusy=function(p){var B,i,s;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}B=this.getBinding("rows");if(!B){return;}if(p){if(p.contexts&&p.contexts.length!==undefined){s=false;for(i=0;i<p.contexts.length;i++){if(p.contexts[i]===undefined){s=true;break;}}}if(s||B.isInitial()||B._bInitial||(p.requestedLength!==p.receivedLength&&B.getLength()>0&&p.receivedLength!==B.getLength())){this.setBusy(true);}}else{this.setBusy(false);}};T.prototype.setColumnHeaderVisible=function(d){this.setProperty("columnHeaderVisible",d);this._iLastSelectedDataRow=this._getHeaderRowCount();};return T;},true);
