/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./SwitchRenderer','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/theming/Parameters'],function(q,S,l,C,E,I,P){"use strict";var a=C.extend("sap.m.Switch",{metadata:{library:"sap.m",properties:{state:{type:"boolean",group:"Misc",defaultValue:false},customTextOn:{type:"string",group:"Misc",defaultValue:""},customTextOff:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Data",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.m.SwitchType",group:"Appearance",defaultValue:sap.m.SwitchType.Default}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{state:{type:"boolean"}}}}}});I.insertFontFaceStyle();E.apply(a.prototype,[true]);a.prototype._slide=function(p){if(p>a._OFFPOSITION){p=a._OFFPOSITION;}else if(p<a._ONPOSITION){p=a._ONPOSITION;}if(this._iCurrentPosition===p){return;}this._iCurrentPosition=p;this.getDomRef("inner").style[sap.ui.getCore().getConfiguration().getRTL()?"right":"left"]=p+"px";this._setTempState(Math.abs(p)<a._SWAPPOINT);};a.prototype._setTempState=function(b){if(this._bTempState===b){return;}this._bTempState=b;this.getDomRef("handle").setAttribute("data-sap-ui-swt",b?this._sOn:this._sOff);};a.prototype._setDomState=function(s){var b=S.CSS_CLASS,c=s?this._sOn:this._sOff,d=this.getDomRef();if(!d){return;}var $=this.$("switch"),o=this.getDomRef("inner"),h=this.getDomRef("handle"),e=null;if(this.getName()){e=this.getDomRef("input");e.setAttribute("checked",s);e.setAttribute("value",c);}h.setAttribute("data-sap-ui-swt",c);if(s){$.removeClass(b+"Off").addClass(b+"On");d.setAttribute("aria-checked","true");}else{$.removeClass(b+"On").addClass(b+"Off");d.setAttribute("aria-checked","false");}$.addClass(b+"Trans");o.style.cssText="";};a.prototype.getInvisibleElementId=function(){return this.getId()+"-invisible";};a.prototype.getInvisibleElementText=function(){var t="";switch(this.getType()){case sap.m.SwitchType.Default:if(!this.getCustomTextOn()){t="SWITCH_ON";}break;case sap.m.SwitchType.AcceptReject:t="SWITCH_ARIA_ACCEPT";break;}return t;};a._TRANSITIONTIME=Number(P.get("sapMSwitch-TRANSITIONTIME"))||0;a._ONPOSITION=Number(P.get("sapMSwitch-ONPOSITION"));a._OFFPOSITION=Number(P.get("sapMSwitch-OFFPOSITION"));a._SWAPPOINT=Math.abs((a._ONPOSITION-a._OFFPOSITION)/2);a._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");a.prototype.onBeforeRendering=function(){var b=a;this._sOn=this.getCustomTextOn()||b._oRb.getText("SWITCH_ON");this._sOff=this.getCustomTextOff()||b._oRb.getText("SWITCH_OFF");};a.prototype.ontouchstart=function(e){var t=e.targetTouches[0],b=S.CSS_CLASS,s=this.$("inner");e.setMarked();if(sap.m.touch.countContained(e.touches,this.getId())>1||!this.getEnabled()||e.button){return;}this._iActiveTouchId=t.identifier;this._bTempState=this.getState();this._iStartPressPosX=t.pageX;this._iPosition=s.position().left;this._bDragging=false;q.sap.delayedCall(0,this,"focus");this.$("switch").addClass(b+"Pressed").removeClass(b+"Trans");};a.prototype.ontouchmove=function(e){e.setMarked();e.preventDefault();var t,p,T=sap.m.touch;if(!this.getEnabled()||e.button){return;}t=T.find(e.changedTouches,this._iActiveTouchId);if(!t||t.pageX===this._iStartPressPosX){return;}this._bDragging=true;p=((this._iStartPressPosX-t.pageX)*-1)+this._iPosition;if(sap.ui.getCore().getConfiguration().getRTL()){p=-p;}this._slide(p);};a.prototype.ontouchend=function(e){e.setMarked();var t,T=sap.m.touch,b=q.sap.assert;if(!this.getEnabled()||e.button){return;}b(this._iActiveTouchId!==undefined,"expect to already be touching");t=T.find(e.changedTouches,this._iActiveTouchId);if(t){b(!T.find(e.touches,this._iActiveTouchId),"touchend still active");this.$("switch").removeClass(S.CSS_CLASS+"Pressed");this._setDomState(this._bDragging?this._bTempState:!this.getState());q.sap.delayedCall(a._TRANSITIONTIME,this,function(){var s=this.getState();this.setState(this._bDragging?this._bTempState:!s);if(s!==this.getState()){this.fireChange({state:this.getState()});}});}};a.prototype.ontouchcancel=a.prototype.ontouchend;a.prototype.onsapselect=function(e){var s;if(this.getEnabled()){e.setMarked();e.preventDefault();this.setState(!this.getState());s=this.getState();q.sap.delayedCall(a._TRANSITIONTIME,this,function(){this.fireChange({state:s});});}};a.prototype.setState=function(s){this.setProperty("state",s,true);this._setDomState(this.getState());return this;};return a;},true);
