/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/Popup','./MenuItemBase','./library','jquery.sap.script'],function(q,C,P,M,l){"use strict";var a=C.extend("sap.ui.unified.Menu",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});(function(w){a.prototype.init=function(){var t=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this.fAnyEventHandlerProxy=q.proxy(function(e){var r=this.getRootMenu();if(r!=this||!this.bOpen||!this.getDomRef()||(e.type!="mousedown"&&e.type!="touchstart")){return;}r.handleOuterEvent(this.getId(),e);},this);this.fOrientationChangeHandler=function(){t.close();};this.bUseTopStyle=false;};a.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._menuOpened,this);this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup;}q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this._resetDelayedRerenderItems();};a.prototype.invalidate=function(o){if(o instanceof M&&this.getDomRef()){this._delayedRerenderItems();}else{C.prototype.invalidate.apply(this,arguments);}};a.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();};a.prototype.onAfterRendering=function(){var d=this.getItems();for(var i=0;i<d.length;i++){if(d[i].onAfterRendering&&d[i].getDomRef()){d[i].onAfterRendering();}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this);}c(this);};a.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===sap.ui.core.OpenState.OPEN){c(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}};a.prototype.setPageSize=function(S){return this.setProperty("pageSize",S,true);};a.prototype.addItem=function(i){this.addAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};a.prototype.insertItem=function(i,d){this.insertAggregation("items",i,d,!!this.getDomRef());this._delayedRerenderItems();return this;};a.prototype.removeItem=function(i){this.removeAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};a.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return r;};a.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this;};a.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return;}this._resetDelayedRerenderItems();this._itemRerenderTimer=q.sap.delayedCall(0,this,function(){var d=this.getDomRef();if(d){var r=sap.ui.getCore().createRenderManager();sap.ui.unified.MenuRenderer.renderItems(r,this);r.flush(d);r.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}});};a.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){q.sap.clearDelayedCall(this._itemRerenderTimer);delete this._itemRerenderTimer;}};a.prototype.open=function(W,o,m,d,e,f,g){if(this.bOpen){return;}s(this,true);this.oOpenerRef=o;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,m,d,e,f||"0 0",g||"_sapUiCommonsMenuFlip _sapUiCommonsMenuFlip",true);this.bOpen=true;var D=this.getDomRef();q(D).attr("tabIndex",0).focus();if(W){this.setHoveredItem(this.getNextSelectableItem(-1));}q.sap.bindAnyEvent(this.fAnyEventHandlerProxy);if(sap.ui.Device.support.orientation&&this.getRootMenu()===this){q(w).bind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true;}};a.prototype._menuOpened=function(){I(this);};a.prototype.close=function(){if(!this.bOpen||a._dbg){return;}s(this,false);delete this._bFixed;q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this.bOpen=false;this.closeSubmenu();this.setHoveredItem();q(this.getDomRef()).attr("tabIndex",-1);this.getPopup().close(0);this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null;}};a.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus();}catch(e){q.sap.log.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e);}}this.oOpenerRef=undefined;}};a.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation();};a.prototype.onsapnext=function(e){if(e.keyCode!=q.sap.KeyCodes.ARROW_DOWN){if(this.oHoveredItem&&this.oHoveredItem.getSubmenu()&&this.checkEnabled(this.oHoveredItem)){this.openSubmenu(this.oHoveredItem,true);}return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getNextSelectableItem(i));e.preventDefault();e.stopPropagation();};a.prototype.onsapprevious=function(e){if(e.keyCode!=q.sap.KeyCodes.ARROW_UP){if(this.isSubMenu()){this.close();}e.preventDefault();e.stopPropagation();return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getPreviousSelectableItem(i));e.preventDefault();e.stopPropagation();};a.prototype.onsaphome=function(e){this.setHoveredItem(this.getNextSelectableItem(-1));e.preventDefault();e.stopPropagation();};a.prototype.onsapend=function(e){this.setHoveredItem(this.getPreviousSelectableItem(this.getItems().length));e.preventDefault();e.stopPropagation();};a.prototype.onsappagedown=function(e){if(this.getPageSize()<1){this.onsapend(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i+=this.getPageSize();if(i>=this.getItems().length){this.onsapend(e);return;}this.setHoveredItem(this.getNextSelectableItem(i-1));e.preventDefault();e.stopPropagation();};a.prototype.onsappageup=function(e){if(this.getPageSize()<1){this.onsaphome(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i-=this.getPageSize();if(i<0){this.onsaphome(e);return;}this.setHoveredItem(this.getPreviousSelectableItem(i+1));e.preventDefault();e.stopPropagation();};a.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation();};a.prototype.onkeyup=function(e){if(!this._sapSelectOnKeyDown){return;}else{this._sapSelectOnKeyDown=false;}if(!q.sap.PseudoEvents.sapselect.fnCheck(e)){return;}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation();};a.prototype.onsapbackspace=function(e){if(q(e.target).prop("tagName")!="INPUT"){e.preventDefault();}};a.prototype.onsapbackspacemodifiers=a.prototype.onsapbackspace;a.prototype.onsapescape=function(e){this.close();e.preventDefault();e.stopPropagation();};a.prototype.onsaptabnext=a.prototype.onsapescape;a.prototype.onsaptabprevious=a.prototype.onsapescape;a.prototype.onmouseover=function(e){if(!sap.ui.Device.system.desktop){return;}var i=this.getItemByDomRef(e.target);if(!this.bOpen||!i||i==this.oHoveredItem){return;}if(this.oOpenedSubMenu&&q.sap.containsOrEquals(this.oOpenedSubMenu.getDomRef(),e.target)){return;}this.setHoveredItem(i);this.closeSubmenu(true);if(q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){this.getDomRef().focus();}if(this.checkEnabled(i)){this.openSubmenu(i,false,true);}};a.prototype.onmouseout=function(e){if(!sap.ui.Device.system.desktop){return;}I(this);if(q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){if(!this.oOpenedSubMenu||!this.oOpenedSubMenu.getParent()===this.oHoveredItem){this.setHoveredItem(null);}}};a.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.bOpen){return;}this.getRootMenu().handleOuterEvent(this.getId(),e);};a.prototype.handleOuterEvent=function(m,e){var i=false,t=this.getPopup().touchEnabled;if(e.type=="mousedown"||e.type=="touchstart"){if(t&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return;}var d=this;while(d&&!i){if(q.sap.containsOrEquals(d.getDomRef(),e.target)){i=true;}d=d.oOpenedSubMenu;}}else if(e.type=="sapfocusleave"){if(t){return;}if(e.relatedControlId){var d=this;while(d&&!i){if((d.oOpenedSubMenu&&d.oOpenedSubMenu.getId()==e.relatedControlId)||q.sap.containsOrEquals(d.getDomRef(),q.sap.byId(e.relatedControlId).get(0))){i=true;}d=d.oOpenedSubMenu;}}}if(!i){this.bIgnoreOpenerDOMRef=true;this.close();}};a.prototype.getItemByDomRef=function(d){var o=this.getItems(),L=o.length;for(var i=0;i<L;i++){var e=o[i],f=e.getDomRef();if(q.sap.containsOrEquals(f,d)){return e;}}return null;};a.prototype.selectItem=function(i,W,d){if(!i||!(i instanceof M&&this.checkEnabled(i))){return;}var S=i.getSubmenu();if(!S){this.getRootMenu().close();}else{if(!sap.ui.Device.system.desktop&&this.oOpenedSubMenu===S){this.closeSubmenu();}else{this.openSubmenu(i,W);}}i.fireSelect({item:i,ctrlKey:d});this.getRootMenu().fireItemSelect({item:i});};a.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof a;};a.prototype.getRootMenu=function(){var t=this;while(t.isSubMenu()){t=t.getParent().getParent();}return t;};a.prototype.getMenuLevel=function(){var L=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();L++;}return L;};a.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachOpened(this._menuOpened,this);this.oPopup.attachClosed(this._menuClosed,this);}return this.oPopup;};a.prototype.setHoveredItem=function(i){if(this.oHoveredItem){this.oHoveredItem.hover(false,this);}if(!i){this.oHoveredItem=null;q(this.getDomRef()).removeAttr("aria-activedescendant");return;}this.oHoveredItem=i;i.hover(true,this);this._setActiveDescendant(this.oHoveredItem);this.scrollToItem(this.oHoveredItem);};a.prototype._setActiveDescendant=function(i){if(sap.ui.getCore().getConfiguration().getAccessibility()&&i){var t=this;t.$().removeAttr("aria-activedescendant");setTimeout(function(){if(t.oHoveredItem===i){t.$().attr("aria-activedescendant",t.oHoveredItem.getId());}},10);}};a.prototype.openSubmenu=function(i,W,d){var S=i.getSubmenu();if(!S){return;}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==S){this.closeSubmenu();}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=(d&&this.oOpenedSubMenu._bFixed)||(!d&&!this.oOpenedSubMenu._bFixed);this.oOpenedSubMenu._bringToFront();}else{this.oOpenedSubMenu=S;var e=P.Dock;S.open(W,this,e.BeginTop,e.EndTop,i,"0 0");}};a.prototype.closeSubmenu=function(i,d){if(this.oOpenedSubMenu){if(i&&this.oOpenedSubMenu._bFixed){return;}if(d){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true;}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null;}};a.prototype.scrollToItem=function(i){var m=this.getDomRef(),o=i?i.getDomRef():null;if(!o||!m){return;}var d=m.scrollTop,e=o.offsetTop,f=q(m).height(),g=q(o).height();if(d>e){m.scrollTop=e;}else if((e+g)>(d+f)){m.scrollTop=Math.ceil(e+g-f);}};a.prototype._bringToFront=function(){q.sap.byId(this.getPopup().getId()).mousedown();};a.prototype.checkEnabled=function(i){I(this);return i&&i.getEnabled()&&this.getEnabled();};a.prototype.getNextSelectableItem=function(d){var o=null;var e=this.getItems();for(var i=d+1;i<e.length;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=0;i<=d;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};a.prototype.getPreviousSelectableItem=function(d){var o=null;var e=this.getItems();for(var i=d-1;i>=0;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=e.length-1;i>=d;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};a.prototype.setRootMenuTopStyle=function(u){this.getRootMenu().bUseTopStyle=u;a.rerenderMenu(this.getRootMenu());};a.rerenderMenu=function(m){var d=m.getItems();for(var i=0;i<d.length;i++){var S=d[i].getSubmenu();if(S){a.rerenderMenu(S);}}m.invalidate();m.rerender();};a.prototype.focus=function(){var r=sap.ui.core.Control.prototype.focus.apply(this,arguments);this._setActiveDescendant(this.oHoveredItem);return r;};function s(m,o){var p=m.getParent();if(p&&p instanceof M){p.onSubmenuToggle(o);}}function c(m){var d=m.getMaxVisibleItems(),e=document.documentElement.clientHeight-10,$=m.$();if(d>0){var f=m.getItems();for(var i=0;i<f.length;i++){if(f[i].getDomRef()){e=Math.min(e,f[i].$().outerHeight(true)*d);break;}}}if($.outerHeight(true)>e){$.css("max-height",e+"px").toggleClass("sapUiMnuScroll",true);}else{$.css("max-height","").toggleClass("sapUiMnuScroll",false);}}var I=function(){};if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<9){I=function(m,d){if(d===undefined){d=50;}q.sap.delayedCall(d,m,function(){var e=this.$();if(e.length>0){var D=e[0].firstChild;sap.ui.core.RenderManager.forceRepaint(D);}});};}
/*!
	 * The following code is taken from
	 * jQuery UI 1.10.3 - 2013-11-18
	 * jquery.ui.position.js
	 *
	 * http://jqueryui.com
	 * Copyright 2013 jQuery Foundation and other contributors; Licensed MIT
	 */
function _(d){var e=q(w);d.within={element:e,isWindow:true,offset:e.offset()||{left:0,top:0},scrollLeft:e.scrollLeft(),scrollTop:e.scrollTop(),width:e.width(),height:e.height()};d.collisionPosition={marginLeft:0,marginTop:0};return d;}var b={fit:{left:function(p,d){var e=d.within,f=e.isWindow?e.scrollLeft:e.offset.left,o=e.width,g=p.left-d.collisionPosition.marginLeft,h=f-g,i=g+d.collisionWidth-o-f,n;if(d.collisionWidth>o){if(h>0&&i<=0){n=p.left+h+d.collisionWidth-o-f;p.left+=h-n;}else if(i>0&&h<=0){p.left=f;}else{if(h>i){p.left=f+o-d.collisionWidth;}else{p.left=f;}}}else if(h>0){p.left+=h;}else if(i>0){p.left-=i;}else{p.left=Math.max(p.left-g,p.left);}},top:function(p,d){var e=d.within,f=e.isWindow?e.scrollTop:e.offset.top,o=d.within.height,g=p.top-d.collisionPosition.marginTop,h=f-g,i=g+d.collisionHeight-o-f,n;if(d.collisionHeight>o){if(h>0&&i<=0){n=p.top+h+d.collisionHeight-o-f;p.top+=h-n;}else if(i>0&&h<=0){p.top=f;}else{if(h>i){p.top=f+o-d.collisionHeight;}else{p.top=f;}}}else if(h>0){p.top+=h;}else if(i>0){p.top-=i;}else{p.top=Math.max(p.top-g,p.top);}}},flip:{left:function(p,d){var e=d.within,f=e.offset.left+e.scrollLeft,o=e.width,g=e.isWindow?e.scrollLeft:e.offset.left,h=p.left-d.collisionPosition.marginLeft,i=h-g,j=h+d.collisionWidth-o-g,m=d.my[0]==="left"?-d.elemWidth:d.my[0]==="right"?d.elemWidth:0,k=d.at[0]==="left"?d.targetWidth:d.at[0]==="right"?-d.targetWidth:0,n=-2*d.offset[0],r,t;if(i<0){r=p.left+m+k+n+d.collisionWidth-o-f;if(r<0||r<Math.abs(i)){p.left+=m+k+n;}}else if(j>0){t=p.left-d.collisionPosition.marginLeft+m+k+n-g;if(t>0||Math.abs(t)<j){p.left+=m+k+n;}}},top:function(p,d){var e=d.within,f=e.offset.top+e.scrollTop,o=e.height,g=e.isWindow?e.scrollTop:e.offset.top,h=p.top-d.collisionPosition.marginTop,i=h-g,j=h+d.collisionHeight-o-g,t=d.my[1]==="top",m=t?-d.elemHeight:d.my[1]==="bottom"?d.elemHeight:0,k=d.at[1]==="top"?d.targetHeight:d.at[1]==="bottom"?-d.targetHeight:0,n=-2*d.offset[1],r,u;if(i<0){u=p.top+m+k+n+d.collisionHeight-o-f;if((p.top+m+k+n)>i&&(u<0||u<Math.abs(i))){p.top+=m+k+n;}}else if(j>0){r=p.top-d.collisionPosition.marginTop+m+k+n-g;if((p.top+m+k+n)>j&&(r>0||Math.abs(r)<j)){p.top+=m+k+n;}}}},flipfit:{left:function(){b.flip.left.apply(this,arguments);b.fit.left.apply(this,arguments);},top:function(){b.flip.top.apply(this,arguments);b.fit.top.apply(this,arguments);}}};q.ui.position._sapUiCommonsMenuFlip={left:function(p,d){if(q.ui.position.flipfit){q.ui.position.flipfit.left.apply(this,arguments);return;}d=_(d);b.flipfit.left.apply(this,arguments);},top:function(p,d){if(q.ui.position.flipfit){q.ui.position.flipfit.top.apply(this,arguments);return;}d=_(d);b.flipfit.top.apply(this,arguments);}};})(window);return a;},true);
