/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation'],function(q,l,C,I){"use strict";var T=C.extend("sap.ui.commons.TabStrip",{metadata:{library:"sap.ui.commons",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},selectedIndex:{type:"int",group:"Misc",defaultValue:0}},defaultAggregation:"tabs",aggregations:{tabs:{type:"sap.ui.commons.Tab",multiple:true,singularName:"tab"}},events:{select:{parameters:{index:{type:"int"}}},close:{parameters:{index:{type:"int"}}}}}});T.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};T.prototype.onAfterRendering=function(){var f=this.getFocusDomRef(),t=f.lastChild.childNodes,a=[],s=-1;for(var i=0;i<t.length;i++){a.push(t[i]);if(q(t[i]).hasClass("sapUiTabSel")){s=i;}}if(!this.oItemNavigation){this.oItemNavigation=new I();this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(a);this.oItemNavigation.setSelectedIndex(s);var t=this.getTabs();for(var i=0;i<t.length;i++){t[i].onAfterRendering();}};T.prototype.createTab=function(t,c){var o=this.getTabs(),a=new sap.ui.core.Title(this.getId()+"-"+o.length+"-title",{text:t}),b=new sap.ui.commons.Tab(this.getId()+"-"+o.length);b.setTitle(a);b.addContent(c);this.addTab(b);return b;};T.prototype.selectTabByDomRef=function(d){var i=this.getItemIndex(d);if(i>-1){if((i!=this.getSelectedIndex())&&(this.getTabs()[i].getEnabled())){var o=this.getSelectedIndex();this.setProperty('selectedIndex',i,true);this.rerenderPanel(o);this.oItemNavigation.setSelectedIndex(this.oItemNavigation.getFocusedIndex());this.fireSelect({index:i});}}};T.prototype.onsapspace=function(e){var s=e.target;this.selectTabByDomRef(s);};T.prototype.onsapspacemodifiers=T.prototype.onsapspace;T.prototype.onsapenter=T.prototype.onsapspace;T.prototype.onsapentermodifiers=T.prototype.onsapspace;T.prototype.onsapdelete=function(e){var s=e.target;var i=this.getItemIndex(s);if(i>-1&&this.getTabs()[i].getClosable()){this.fireClose({index:i});}};T.prototype.onclick=function(e){var s=e.target;if(s.className=="sapUiTabClose"){var i=this.getItemIndex(q(s).parentByAttribute("id"));if(i>-1){this.fireClose({index:i});}return;}this.selectTabByDomRef(s);};T.prototype.getFocusDomRef=function(){return this.getDomRef().firstChild;};T.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}};T.prototype.getItemIndex=function(d){var i;if(!d.id||d.id.search("-close")!=-1){var o=q(d).parentByAttribute("id");i=o.id;}else{i=d.id;}for(var a=0,t=this.getTabs();a<t.length;a++){if(i==t[a].getId()){return a;}}return-1;};T.prototype.removeTab=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){i=this.indexOfTab(e);}var t=this.getTabs()[i];if(t.getVisible()){t.setProperty("visible",false,true);this.hideTab(i);t.setProperty("visible",true,true);}if(this.getSelectedIndex()>i){this.setProperty('selectedIndex',this.getSelectedIndex()-1,true);}return this.removeAggregation("tabs",i,true);};T.prototype.setSelectedIndex=function(s){var o=this.getSelectedIndex();if(s==o){return this;}var t=this.getTabs();var a=t[s];if(!a&&!this.getDomRef()){this.setProperty('selectedIndex',s,false);}else if(a&&a.getEnabled()&&a.getVisible()){this.setProperty('selectedIndex',s,true);if(this.getDomRef()&&!this.invalidated){this.rerenderPanel(o);if(this.oItemNavigation){var v=0;var S=-1;for(var i=0;i<t.length;i++){a=t[i];if(a.getVisible()===false){continue;}if(i==s){S=v;break;}v++;}this.oItemNavigation.setSelectedIndex(S);}}}else{this._warningInvalidSelectedIndex(s,a);}return this;};T.prototype.closeTab=function(i){var t=this.getTabs()[i];if(!t||!t.getClosable()||!t.getVisible()){return;}t.setProperty("visible",false,true);this.hideTab(i);};T.prototype.hideTab=function(a){var t=this.getTabs()[a];if(!this.getDomRef()){return;}var f=this.oItemNavigation.getFocusedIndex();var v=parseInt(t.$().attr("aria-posinset"),10)-1;var F=sap.ui.getCore().getCurrentFocusedControlId();t.$().remove();if(this.iVisibleTabs==1){this.setProperty('selectedIndex',-1,true);t.$("panel").remove();}else if(a==this.getSelectedIndex()){var n=a+1;while(n<this.getTabs().length&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n++;}if(n==this.getTabs().length){n=a-1;while(n>=0&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n--;}}this.setProperty('selectedIndex',n,true);this.rerenderPanel(a);}else{this.toggleTabClasses(this.getSelectedIndex(),this.getSelectedIndex());}this.iVisibleTabs--;var v=0;var b=[];var s=-1;var c=false;for(var i=0;i<this.getTabs().length;i++){var t=this.getTabs()[i];if(F==t.getId()){c=true;}if(t.getVisible()===false){continue;}if(i==this.getSelectedIndex()){s=v;}v++;t.$().attr("aria-posinset",v).attr("aria-setsize",this.iVisibleTabs);if(v==this.iVisibleTabs){t.$().addClass("sapUiTabLast");}b.push(t.getDomRef());}if(v<=f){f--;}this.oItemNavigation.setItemDomRefs(b);this.oItemNavigation.setSelectedIndex(s);this.oItemNavigation.setFocusedIndex(f);if(c){this.oItemNavigation.focusItem(f);}};T.prototype.rerenderPanel=function(o){var n=this.getSelectedIndex();var $=this.getTabs()[o].$("panel");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderTabContents(r,this.getTabs()[n]);r.flush($[0]);r.destroy();}var N=this.getTabs()[n].getId();$.attr("id",N+"-panel").attr("aria-labelledby",N);this.getTabs()[n].onAfterRendering();this.toggleTabClasses(o,n);};T.prototype.toggleTabClasses=function(o,n){this.getTabs()[o].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",false);var b=o-1;while(b>=0&&!this.getTabs()[b].getVisible()){b--;}if(b>=0){this.getTabs()[b].$().removeClass("sapUiTabBeforeSel");}var a=o+1;while(a<this.getTabs().length&&!this.getTabs()[a].getVisible()){a++;}if(a<this.getTabs().length){this.getTabs()[a].$().removeClass("sapUiTabAfterSel");}this.getTabs()[n].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",true);b=n-1;while(b>=0&&!this.getTabs()[b].getVisible()){b--;}if(b>=0){this.getTabs()[b].$().addClass("sapUiTabBeforeSel");}a=n+1;while(a<this.getTabs().length&&!this.getTabs()[a].getVisible()){a++;}if(a<this.getTabs().length){this.getTabs()[a].$().addClass("sapUiTabAfterSel");}};T.prototype._originalInvalidate=T.prototype.invalidate;T.prototype.invalidate=function(){this.invalidated=true;T.prototype._originalInvalidate.apply(this,arguments);};T.prototype._warningInvalidSelectedIndex=function(s,t){var d="";if(!t){d="Tab not exists";}else if(!t.getEnabled()){d="Tab disabled";}else if(!t.getVisible()){d="Tab not visible";}q.sap.log.warning("SelectedIndex "+s+" can not be set",d,"sap.ui.commons.TabStrip");};return T;},true);
