jQuery.sap.declare('sap.ui.table.library-all');if(!jQuery.sap.isDeclared('sap.ui.table.ColumnMenuRenderer')){
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.table.ColumnMenuRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');jQuery.sap.require('sap.ui.unified.MenuRenderer');sap.ui.define("sap/ui/table/ColumnMenuRenderer",['jquery.sap.global','sap/ui/core/Renderer','sap/ui/unified/MenuRenderer'],function(q,R,M){"use strict";var C=R.extend(M);return C;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TablePersoController')){jQuery.sap.declare('sap.ui.table.TablePersoController');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.base.ManagedObject');sap.ui.define("sap/ui/table/TablePersoController",['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";var T=M.extend("sap.ui.table.TablePersoController",{constructor:function(i,s){M.apply(this,arguments);},metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}});T.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};T.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;delete this._oDialog;};T.prototype.setPersoService=function(s){s=this.validateProperty("persoService",s);if(s&&(!q.isFunction(s.getPersData)||!q.isFunction(s.setPersData)||!q.isFunction(s.delPersData))){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",s,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};T.prototype.setAutoSave=function(a){var o=this.getAutoSave();this.setProperty("autoSave",a,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};T.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){this._oInitialPersoData=this._getCurrentTablePersoData(true);this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};T.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};T.prototype._manageTableEventHandlers=function(t,a){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(a?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};T.prototype.refresh=function(){var t=this;var s=this.getPersoService();if(s){return s.getPersData().done(function(S){var D=(S&&q.isArray(S.aColumns))?S:t._oInitialPersoData;t._adjustTable(D);}).fail(function(){q.sap.log.error("Problem reading persisted personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};T.prototype.savePersonalizations=function(){var s=this.getPersoService();if(s){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return s.setPersData(d).fail(function(){q.sap.log.error("Problem persisting personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};T.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!q.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var a=d.aColumns;for(var i=0,l=a.length;i<l;i++){var o=a[i];var b=c[o.id];if(b){if(t.indexOfColumn(b)!==o.order){t.removeColumn(b);t.insertColumn(b,o.order);}var m=b.getMetadata();for(var j=0,e=this._aColumnProperties.length;j<e;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&b.getProperty(p)!=o[p]){b.setProperty(p,o[p]);}}catch(f){q.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \""+b[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};T.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};T.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,a=this._aColumnProperties.length;j<a;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=C.getLabel()&&C.getLabel().getText()||p;}d.aColumns.push(o);}return d;};T.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};T.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};T.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){q.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};T.prototype.openDialog=function(s){sap.ui.getCore().loadLibrary("sap.m");q.sap.require("sap.m.TablePersoDialog");if(!this._oDialog){var t=this;this._oDialog=new sap.m.TablePersoDialog({persoService:this.getPersoService(),showSelectAll:true,showResetAll:true,grouping:false,contentWidth:s&&s.contentWidth,contentHeight:s&&s.contentHeight||"20rem",initialColumnState:this._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding");q.sap.syncStyleClass("sapUiSizeCompact",this._getTable(),this._oDialog._oDialog);}this._oDialog.open();};return T;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TableRenderer')){jQuery.sap.declare('sap.ui.table.TableRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/TableRenderer",['jquery.sap.global'],function(q){"use strict";var T={};T.render=function(r,t){t._createRows();r.write("<div");if(t._bAccMode){var a=[];if(t.getToolbar()){a.push(t.getToolbar().getId());}a.push(t.getId()+"-table");r.writeAttribute("aria-owns",a.join(" "));r.writeAttribute("aria-readonly","true");if(t.getTitle()){r.writeAttribute("aria-labelledby",t.getTitle().getId());}if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi){r.writeAttribute("aria-multiselectable","true");}}r.writeControlData(t);r.addClass("sapUiTable");r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(t.getSelectionMode()!==sap.ui.table.SelectionMode.None&&t.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly){r.addClass("sapUiTableRSel");}var s=sap.ui.table.TableHelper.addTableClass();if(s){r.addClass(s);}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}r.addClass("sapUiTableShNoDa");if(t.getShowNoData()&&t._getRowCount()===0){r.addClass("sapUiTableEmpty");}if(t.getEnableGrouping()){r.addClass("sapUiTableGrouping");}r.writeClasses();if(t.getWidth()){r.addStyle("width",t.getWidth());}r.writeStyles();r.write(">");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.addClass("sapUiTableCnt");r.writeClasses();r.writeAttribute("data-sap-ui-fastnavgroup","true");if(t._bAccMode){r.writeAttribute("aria-describedby",t.getId()+"-ariacount");}r.write(">");this.renderColHdr(r,t);this.renderTable(r,t);if(t._bAccMode){r.write("<span");r.writeAttribute("id",t.getId()+"-ariadesc");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(t._oResBundle.getText("TBL_TABLE"));r.write("</span>");r.write("<span");r.writeAttribute("id",t.getId()+"-ariacount");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write("</span>");r.write("<span");r.writeAttribute("id",t.getId()+"-toggleedit");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(t._oResBundle.getText("TBL_TOGGLE_EDIT_KEY"));r.write("</span>");r.write("<span");r.writeAttribute("id",t.getId()+"-selectrow");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(t._oResBundle.getText("TBL_ROW_SELECT_KEY"));r.write("</span>");r.write("<span");r.writeAttribute("id",t.getId()+"-selectrowmulti");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(t._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));r.write("</span>");r.write("<span");r.writeAttribute("id",t.getId()+"-deselectrow");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(t._oResBundle.getText("TBL_ROW_DESELECT_KEY"));r.write("</span>");r.write("<span");r.writeAttribute("id",t.getId()+"-deselectrowmulti");r.addStyle("position","absolute");r.addStyle("top","-20000px");r.writeStyles();r.write(">");r.write(t._oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY"));r.write("</span>");}r.write("</div>");if(t.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){r.write("<div");r.addClass("sapUiTablePaginator");r.writeClasses();r.write(">");if(!t._oPaginator){q.sap.require("sap.ui.commons.Paginator");t._oPaginator=new sap.ui.commons.Paginator(t.getId()+"-paginator");t._oPaginator.attachPage(q.proxy(t.onvscroll,t));}r.renderControl(t._oPaginator);r.write("</div>");}if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==sap.ui.table.VisibleRowCountMode.Interactive){this.renderVariableHeight(r,t);}r.write("</div>");};T.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();if(t._bAccMode){r.writeAttribute("role","heading");}r.write(">");r.renderControl(o);r.write("</div>");};T.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone!=="function"){r.addClass("sapUiTableMTbr");}r.writeClasses();r.write(">");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}r.renderControl(o);r.write("</div>");};T.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};T.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();r.write(">");r.renderControl(e);r.write("</div>");};T.renderTable=function(r,t){r.write("<div");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiTableCtrlBefore");r.writeClasses();r.writeAttribute("tabindex","0");r.write("></div>");this.renderRowHdr(r,t);this.renderTableCtrl(r,t);this.renderVSb(r,t);r.write("</div>");this.renderHSb(r,t);};T.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();r.write(">");r.renderControl(f);r.write("</div>");};T.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableSplitterBar");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};T.renderColHdr=function(r,t){r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",(t.getColumnHeaderHeight()*t._getHeaderRowCount())+"px");}if(t._bAccMode&&(t.getSelectionMode()===sap.ui.table.SelectionMode.None||t.getSelectionBehavior()===sap.ui.table.SelectionBehavior.RowOnly)){r.writeAttribute("role","row");}r.writeStyles();r.write(">");this.renderColRowHdr(r,t);var c=t.getColumns();if(t.getFixedColumnCount()>0){r.write("<div");r.addClass("sapUiTableColHdrFixed");r.writeClasses();r.write(">");for(var h=0;h<t._getHeaderRowCount();h++){r.write("<div");r.addClass("sapUiTableColHdr");r.writeClasses();r.addStyle("min-width",t._getColumnsWidth(0,t.getFixedColumnCount())+"px");r.writeStyles();r.write(">");var s=1;for(var i=0,l=t.getFixedColumnCount();i<l;i++){if(c[i]&&c[i].shouldRender()){if(s<=1){this.renderCol(r,t,c[i],i,h);var H=c[i].getHeaderSpan();if(q.isArray(H)){s=c[i].getHeaderSpan()[h]+1;}else{s=c[i].getHeaderSpan()+1;}}else{this.renderCol(r,t,c[i],i,h,true);}if(h==0){this.renderColRsz(r,t,c[i],i);}s--;}}r.write("<p style=\"clear: both;\"></p>");r.write("</div>");}r.write("</div>");}r.write("<div");r.addClass("sapUiTableColHdrScr");r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");for(var h=0;h<t._getHeaderRowCount();h++){r.write("<div");r.addClass("sapUiTableColHdr");r.writeClasses();r.addStyle("min-width",t._getColumnsWidth(t.getFixedColumnCount(),c.length)+"px");r.writeStyles();r.write(">");var s=1;for(var i=t.getFixedColumnCount(),l=c.length;i<l;i++){if(c[i].shouldRender()){if(s<=1){this.renderCol(r,t,c[i],i,h);var H=c[i].getHeaderSpan();if(q.isArray(H)){s=c[i].getHeaderSpan()[h]+1;}else{s=c[i].getHeaderSpan()+1;}}else{this.renderCol(r,t,c[i],i,h,true);}if(h==0){this.renderColRsz(r,t,c[i],i);}s--;}}r.write("<p style=\"clear: both;\"></p>");r.write("</div>");}r.write("</div>");r.write("</div>");};T.renderColRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-selall");var s=t.getSelectionMode();if((s=="Multi"||s=="MultiToggle")&&t.getEnableSelectAll()){r.writeAttributeEscaped("title",t._oResBundle.getText("TBL_SELECT_ALL"));if(t._getSelectableRowCount()==0||t._getSelectableRowCount()!==t.getSelectedIndices().length){r.addClass("sapUiTableSelAll");}r.addClass("sapUiTableSelAllEnabled");}r.addClass("sapUiTableColRowHdr");r.writeClasses();if(t._bAccMode){r.writeAttribute("tabindex","-1");r.writeAttributeEscaped("aria-label",t._oResBundle.getText("TBL_SELECT_ALL_KEY"));}r.write(">");if(t.getSelectionMode()!==sap.ui.table.SelectionMode.Single){r.write("<div");r.addClass("sapUiTableColRowHdrIco");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.write(">");r.write("</div>");}r.write("</div>");};T.renderCol=function(r,t,c,i,h,I){var l;if(c.getMultiLabels().length>0){l=c.getMultiLabels()[h];}else if(h==0){l=c.getLabel();}r.write("<div");if(h===0){r.writeElementData(c);}else{r.writeAttribute('id',c.getId()+"_"+h);}r.writeAttribute('data-sap-ui-colid',c.getId());r.writeAttribute("data-sap-ui-colindex",i);if(t._bAccMode){if(!!sap.ui.Device.browser.internet_explorer){r.writeAttribute("role","columnheader");}r.writeAttribute("aria-haspopup","true");r.writeAttribute("tabindex","-1");}r.addClass("sapUiTableCol");r.writeClasses();r.addStyle("width",c.getWidth());if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}if(I){r.addStyle("display","none");}r.writeStyles();var s=c.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableColCell");r.writeClasses();var H=this.getHAlign(c.getHAlign(),t._bRtlMode);if(H){r.addStyle("text-align",H);}r.writeStyles();r.write(">");r.write("<div id=\""+c.getId()+"-icons\" class=\"sapUiTableColIcons\"></div>");if(l){r.renderControl(l);}r.write("</div></div>");};T.renderColRsz=function(r,t,c,i){if(c.getResizable()){r.write("<div");r.writeAttribute("id",c.getId()+"-rsz");r.writeAttribute("data-sap-ui-colindex",i);r.writeAttribute("tabindex","-1");r.addClass("sapUiTableColRsz");r.writeClasses();r.addStyle("left",t._bRtlMode?"99000px":"-99000px");r.writeStyles();r.write("></div>");}};T.renderRowHdr=function(r,t){r.write("<div");r.addClass("sapUiTableRowHdrScr");r.writeClasses();r.write(">");for(var a=0,c=t.getRows().length;a<c;a++){this.renderRowHdrRow(r,t,t.getRows()[a],a);}r.write("</div>");};T.renderRowHdrRow=function(r,t,R,i){r.write("<div");r.writeAttribute("id",t.getId()+"-rowsel"+i);r.writeAttribute("data-sap-ui-rowindex",i);r.addClass("sapUiTableRowHdr");if(R._bHidden){r.addClass("sapUiTableRowHidden");}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t.getRowHeight()+"px");}if(t._bAccMode){var c=[];q.each(R.getCells(),function(I,C){c.push(R.getId()+"-col"+I);});if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi){r.writeAttribute("aria-selected","false");}if(t.getSelectionMode()!==sap.ui.table.SelectionMode.None){r.writeAttributeEscaped("title",t._oResBundle.getText("TBL_ROW_SELECT"));if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi&&t._oSelection.getSelectedIndices().length>1){r.writeAttributeEscaped("aria-label",t._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));}else{r.writeAttributeEscaped("aria-label",t._oResBundle.getText("TBL_ROW_SELECT_KEY"));}}r.writeAttribute("tabindex","-1");}r.writeStyles();r.write("></div>");};T.renderTableCtrl=function(r,t){if(t.getFixedColumnCount()>0){r.write("<div");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.addClass("sapUiTableCtrlCnt");r.writeClasses();r.write(">");this.renderTableControl(r,t,false);r.write("</div>");r.write("<div");r.addClass("sapUiTableCtrlAfter");r.writeClasses();r.writeAttribute("tabindex","0");r.write("></div>");r.write("</div>");r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.write(">");if(t.getNoData()&&t.getNoData()instanceof sap.ui.core.Control){r.renderControl(t.getNoData());}else{r.write("<span");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");if(typeof t.getNoData()==="string"||t.getNoData()instanceof String){r.writeEscaped(t.getNoData());}else if(t.getNoDataText()){r.writeEscaped(t.getNoDataText());}else{r.writeEscaped(t._oResBundle.getText("TBL_NO_DATA"));}r.write("</span>");}r.write("</div>");};T.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getFixedColumnCount();}else{s=t.getFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var R=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,R.length-i);if(i>0){this.renderTableControlCnt(r,t,f,s,e,false,true,R.length-i,R.length);}};T.renderTableControlCnt=function(r,t,f,s,e,F,b,S,E){r.write("<table");var i=t.getId()+"-table";if(f){i+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){i+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(b){i+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",i);if(t._bAccMode){r.writeAttribute("role","grid");}r.addClass("sapUiTableCtrl");r.writeClasses();r.addStyle("min-width",t._getColumnsWidth(s,e)+"px");if(f&&(!!sap.ui.Device.browser.firefox||!!sap.ui.Device.browser.chrome||!!sap.ui.Device.browser.safari)){r.addStyle("width",t._getColumnsWidth(s,e)+"px");}r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(S==0){r.addClass("sapUiTableCtrlFirstCol");}r.writeClasses();r.write(">");var c=t.getColumns();if(t.getSelectionMode()!==sap.ui.table.SelectionMode.None&&t.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly){r.write("<th");r.addStyle("width","0px");r.writeStyles();if(t._bAccMode&&S==0){r.writeAttribute("role","columnheader");r.writeAttribute("scope","col");r.writeAttribute("id",t.getId()+"_colsel");}r.write("></th>");}else{if(c.length===0){r.write("<th></th>");}}for(var a=s,d=e;a<d;a++){var C=c[a];if(C&&C.shouldRender()){r.write("<th");r.addStyle("width",C.getWidth());r.writeStyles();if(S==0){if(t._bAccMode){r.writeAttribute("aria-owns",C.getId());r.writeAttribute("aria-labelledby",C.getId());r.writeAttribute("role","columnheader");r.writeAttribute("scope","col");r.writeAttribute("id",t.getId()+"_col"+a);}}r.writeAttribute("data-sap-ui-headcolindex",a);r.write(">");if(S==0){if(C.getMultiLabels().length>0){r.renderControl(C.getMultiLabels()[0]);}else{r.renderControl(C.getLabel());}}r.write("</th>");}}if(!f&&t._hasOnlyFixColumnWidths()&&c.length>0){r.write("<th></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var R=t.getRows();for(var g=S,d=E;g<d;g++){this.renderTableRow(r,t,R[g],g,f,s,e,false);}r.write("</tbody>");r.write("</table>");};T.renderTableRow=function(r,t,R,i,f,s,e,F){r.write("<tr");r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",R.getId()+"-fixed");}else{r.writeElementData(R);}if(R._bHidden){r.addClass("sapUiTableRowHidden");}if(i%2===0){r.addClass("sapUiTableRowEven");}else{r.addClass("sapUiTableRowOdd");}r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);if(t.getRowHeight()>0){r.addStyle("height",t.getRowHeight()+"px");}r.writeStyles();if(t._bAccMode){r.writeAttribute("role","row");if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi){r.writeAttribute("aria-selected","false");}}r.write(">");var c=R.getCells();if(t.getSelectionMode()!==sap.ui.table.SelectionMode.None&&t.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly){r.write("<td");if(t._bAccMode){r.writeAttribute("role","gridcell");r.writeAttribute("headers",t.getId()+"_colsel");r.writeAttribute("aria-owns",t.getId()+"-rowsel"+i);if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi){r.writeAttribute("aria-selected","false");}}r.write(">");if(t._bAccMode){r.write("<div");r.addClass("sapUiTableAriaRowSel");r.writeClasses();r.write(">");r.write(t._oResBundle.getText("TBL_ROW_SELECT_KEY"));r.write("</div>");}r.write("</td>");}else{if(c.length===0){r.write("<td");if(t._bAccMode){r.writeAttribute("role","gridcell");r.writeAttribute("headers",t.getId()+"_colsel");r.writeAttribute("aria-owns",t.getId()+"-rowsel"+i);if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi){r.writeAttribute("aria-selected","false");}}r.write(">");if(t._bAccMode){r.write("<div");r.addClass("sapUiTableAriaRowSel");r.writeClasses();r.write(">");r.write(t._oResBundle.getText("TBL_ROW_SELECT_KEY"));r.write("</div>");}r.write("</td>");}}for(var a=0,b=c.length;a<b;a++){this.renderTableCell(r,t,R,c[a],a,f,s,e);}if(!f&&t._hasOnlyFixColumnWidths()&&c.length>0){r.write("<td></td>");}r.write("</tr>");};T.renderTableCell=function(r,t,R,c,C,f,s,e){var a=c.data("sap-ui-colindex");var o=t.getColumns()[a];if(o.shouldRender()&&s<=a&&e>a){r.write("<td");var I=R.getId()+"-col"+C;r.writeAttribute("id",I);r.writeAttribute("tabindex","-1");if(t._bAccMode){r.writeAttribute("headers",t.getId()+"_col"+a);r.writeAttribute("role","gridcell");var l=t.getId()+"-ariadesc "+o.getId();var m=o.getMultiLabels().length;if(m>1){for(var i=1;i<m;i++){l+=" "+o.getId()+"_"+i;}}l+=" "+c.getId();r.writeAttribute("aria-labelledby",l);r.writeAttribute("aria-describedby",t.getId()+"-toggleedit");r.writeAttribute("aria-activedescendant",c.getId());if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi){r.writeAttribute("aria-selected","false");}}var h=this.getHAlign(o.getHAlign(),t._bRtlMode);if(h){r.addStyle("text-align",h);}r.writeStyles();var v=t._getVisibleColumns();if(v.length>0&&v[0]===o){r.addClass("sapUiTableTdFirst");}if(o.getGrouped()){r.addClass("sapUiTableTdGroup");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCell");r.writeClasses();if(t.getRowHeight()&&t.getVisibleRowCountMode()==sap.ui.table.VisibleRowCountMode.Auto){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,c,C);r.write("</div></td>");}};T.renderTableCellControl=function(r,t,c,C){r.renderControl(c);};T.renderVSb=function(r,t){r.write("<div");r.addClass("sapUiTableVSb");r.writeClasses();r.write(">");r.renderControl(t._oVSb);r.write("</div>");};T.renderHSb=function(r,t){r.write("<div");r.addClass("sapUiTableHSb");r.writeClasses();r.write(">");r.renderControl(t._oHSb);r.write("</div>");};T.getHAlign=function(h,r){switch(h){case sap.ui.core.HorizontalAlign.Center:return"center";case sap.ui.core.HorizontalAlign.End:case sap.ui.core.HorizontalAlign.Right:return r?"left":"right";}return r?"right":"left";};return T;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TreeAutoExpandMode')){jQuery.sap.declare('sap.ui.table.TreeAutoExpandMode');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/TreeAutoExpandMode",['jquery.sap.global'],function(q){"use strict";var T={Sequential:"Sequential",Bundled:"Bundled"};return T;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TreeTableRenderer')){jQuery.sap.declare('sap.ui.table.TreeTableRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/table/TreeTableRenderer",['jquery.sap.global','sap/ui/core/Renderer','./TableRenderer'],function(q,R,T){"use strict";var a=R.extend(T);a.renderTableCellControl=function(r,t,c,C){if(t.isTreeBinding("rows")&&C===0&&!t.getUseGroupMode()){r.write("<span");r.addClass("sapUiTableTreeIcon");r.addClass("sapUiTableTreeIconLeaf");r.writeClasses();r.writeAttribute("tabindex",-1);r.write(">&nbsp;</span>");}r.renderControl(c);};return a;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.library')){jQuery.sap.declare('sap.ui.table.library');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.library');jQuery.sap.require('sap.ui.unified.library');sap.ui.define("sap/ui/table/library",['jquery.sap.global','sap/ui/core/library','sap/ui/unified/library'],function(q){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.28.16",dependencies:["sap.ui.core","sap.ui.unified"],types:["sap.ui.table.NavigationMode","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.DataTable","sap.ui.table.Table","sap.ui.table.TreeTable"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row"]});sap.ui.table.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};sap.ui.table.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};sap.ui.table.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};sap.ui.table.SortOrder={Ascending:"Ascending",Descending:"Descending"};sap.ui.table.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};sap.ui.table.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};sap.ui.table.ColumnHeader=sap.ui.table.Column;sap.ui.table.SelectionMode.All=sap.ui.table.SelectionMode.Multi;if(!sap.ui.table.TableHelper){sap.ui.table.TableHelper={createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},createTextField:function(c){throw new Error("no TextField control available!");},createImage:function(c){throw new Error("no Image control available!");},bFinal:false};}return sap.ui.table;});};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenuRenderer')){jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenuRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/table/AnalyticalColumnMenuRenderer",['jquery.sap.global','sap/ui/core/Renderer','./ColumnMenuRenderer'],function(q,R,C){"use strict";var A=R.extend(C);return A;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalTableRenderer')){jQuery.sap.declare('sap.ui.table.AnalyticalTableRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/table/AnalyticalTableRenderer",['jquery.sap.global','sap/ui/core/Renderer','./TableRenderer'],function(q,R,T){"use strict";var A=R.extend(T);return A;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.Column')){jQuery.sap.declare('sap.ui.table.Column');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.core.RenderManager');jQuery.sap.require('sap.ui.model.Filter');jQuery.sap.require('sap.ui.model.Sorter');jQuery.sap.require('sap.ui.model.Type');jQuery.sap.require('sap.ui.model.type.String');sap.ui.define("sap/ui/table/Column",['jquery.sap.global','sap/ui/core/Element','sap/ui/core/RenderManager','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/Type','sap/ui/model/type/String','./library'],function(q,E,R,F,S,T,a,b){"use strict";var C=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},flexible:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:sap.ui.core.HorizontalAlign.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:sap.ui.table.SortOrder.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},filterType:{type:"any",group:"Misc",defaultValue:null},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",multiple:false},menu:{type:"sap.ui.unified.Menu",multiple:false}}}});C._DEFAULT_FILTER_TYPE=new a();C.prototype.init=function(){this.oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._oSorter=null;this.mSkipPropagation={template:true};};C.prototype.exit=function(){var s=sap.ui.getCore().byId(this.getId()+"-sortIcon");if(s){s.destroy();}var f=sap.ui.getCore().byId(this.getId()+"-filterIcon");if(f){f.destroy();}};C.prototype.setParent=function(p,A,s){E.prototype.setParent.apply(this,arguments);var m=this.getAggregation("menu");if(m&&typeof m._updateReferences==="function"){m._updateReferences(this);}};C.prototype.invalidate=function(o){if(o!==this.getTemplate()&&!(o instanceof sap.ui.table.ColumnMenu)){E.prototype.invalidate.apply(this,arguments);}};C.prototype.setLabel=function(l){var L=l;if(typeof(l)==="string"){L=sap.ui.table.TableHelper.createLabel({text:l});}this.setAggregation("label",L);return this;};C.prototype.setTemplate=function(t){var o=t;if(typeof(t)==="string"){o=sap.ui.table.TableHelper.createTextView().bindProperty("text",t);}this.setAggregation("template",o);this.invalidate();return this;};C.prototype.getMenu=function(){var m=this.getAggregation("menu");if(!m){m=this._createMenu();this.setMenu(m);}return m;};C.prototype.setMenu=function(m){this.setAggregation("menu",m,true);return this;};C.prototype._createMenu=function(){q.sap.require("sap.ui.table.ColumnMenu");return new sap.ui.table.ColumnMenu(this.getId()+"-menu");};C.prototype.setWidth=function(w){this.setProperty("width",w);this.fireEvent('_widthChanged',{newWidth:w});return this;};C.prototype._setAppDefault=function(p,v){if(!this._appDefaults){this._appDefaults={};}if(p=="sorted"){this._appDefaults.sorted=v;}else if(p=="sortOrder"){this._appDefaults.sortOrder=v;}else if(p=="filtered"){this._appDefaults.filtered=v;}else if(p=="filterValue"){this._appDefaults.filterValue=v;}else if(p=="filterOperator"){this._appDefaults.filterOperator=v;}};C.prototype._restoreAppDefaults=function(){if(this._appDefaults){this.setProperty("sorted",this._appDefaults.sorted,true);this.setProperty("sortOrder",this._appDefaults.sortOrder,true);this.setProperty("filtered",this._appDefaults.filtered,true);this.setProperty("filterValue",this._appDefaults.filterValue,true);this.setProperty("filterOperator",this._appDefaults.filterOperator,true);this._renderSortIcon();this._renderFilterIcon();}};C.prototype.setSorted=function(f){this.setProperty("sorted",f,true);this._setAppDefault("sorted",f);this._renderSortIcon();return this;};C.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._setAppDefault("sortOrder",t);this._renderSortIcon();return this;};C.prototype.setFiltered=function(f){this.setProperty("filtered",f,true);this._setAppDefault("filtered",f);this._renderFilterIcon();return this;};C.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);this._setAppDefault("filterValue",v);if(this.getMenu()){this.getMenu()._setFilterValue(v);}return this;};C.prototype.setFilterOperator=function(v){this.setProperty("filterOperator",v,true);this._setAppDefault("filterOperator",v);return this;};C.prototype.onmousedown=function(e){var m=this.getAggregation("menu");this._bSkipOpen=m&&m.bOpen;};C.prototype.onmouseout=function(e){if(this._bSkipOpen&&q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){this._bSkipOpen=false;}};C.prototype._openMenu=function(d){if(this._bSkipOpen){this._bSkipOpen=false;return;}var m=this.getMenu();var e=sap.ui.core.Popup.Dock;var f=d;if(!d){d=this.getDomRef();f=this.getFocusDomRef();}m.open(false,f,e.BeginTop,e.BeginBottom,d,"none none");};C.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===sap.ui.table.SortOrder.Ascending);};C.prototype.sort=function(d,A){var t=this.getParent();if(t){var n=d?sap.ui.table.SortOrder.Descending:sap.ui.table.SortOrder.Ascending;var e=t.fireSort({column:this,sortOrder:n,columnAdded:A});if(e){var s=[];var c=t.getColumns();if(A){for(var i=0,l=c.length;i<l;i++){if(c[i]==this){this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===sap.ui.table.SortOrder.Descending);s.push(this._oSorter);}else{var o=c[i]._oSorter;if(o){s.push(o);}}}}else{for(var i=0,l=c.length;i<l;i++){if(c[i]!==this){c[i].setProperty("sorted",false,true);c[i].setProperty("sortOrder",sap.ui.table.SortOrder.Ascending,true);c[i]._renderSortIcon();delete c[i]._oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===sap.ui.table.SortOrder.Descending);s.push(this._oSorter);}if(t.isBound("rows")){t.getBinding("rows").sort(s);if(this._afterSort){this._afterSort();}}this._renderSortIcon();}}return this;};C.prototype._renderSortIcon=function(){var t=this.getParent();if(t&&t.getDomRef()){if(this.getSorted()){var c=sap.ui.getCore().getConfiguration().getTheme();var i=sap.ui.getCore().byId(this.getId()+"-sortIcon")||sap.ui.table.TableHelper.createImage(this.getId()+"-sortIcon");i.addStyleClass("sapUiTableColIconsOrder");if(this.getSortOrder()===sap.ui.table.SortOrder.Ascending){i.setSrc(sap.ui.resource("sap.ui.table","themes/"+c+"/img/ico12_sort_asc.gif"));}else{i.setSrc(sap.ui.resource("sap.ui.table","themes/"+c+"/img/ico12_sort_desc.gif"));}var r=new R();var h=r.getHTML(i);this.$().find(".sapUiTableColIconsOrder").remove();q(h).prependTo(this.getDomRef("icons"));this.$().attr("aria-sort",this.getSortOrder()===sap.ui.table.SortOrder.Ascending?"ascending":"descending");this.$().find(".sapUiTableColCell").addClass("sapUiTableColSorted");}else{this.$().find(".sapUiTableColIconsOrder").remove();this.$().removeAttr("aria-sort");this.$().find(".sapUiTableColCell").removeClass("sapUiTableColSorted");}}};C.prototype._getFilter=function(){var f,p=this.getFilterProperty(),v=this.getFilterValue(),o=this.getFilterOperator(),P,s,t=this.getFilterType()||C._DEFAULT_FILTER_TYPE,i=t instanceof a,B;if(v){if(!o){B=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){o=sap.ui.model.FilterOperator.EQ;P=v.substr(1);}else if(v.indexOf("!=")==0){o=sap.ui.model.FilterOperator.NE;P=v.substr(2);}else if(v.indexOf("<=")==0){o=sap.ui.model.FilterOperator.LE;P=v.substr(2);}else if(v.indexOf("<")==0){o=sap.ui.model.FilterOperator.LT;P=v.substr(1);}else if(v.indexOf(">=")==0){o=sap.ui.model.FilterOperator.GE;P=v.substr(2);}else if(v.indexOf(">")==0){o=sap.ui.model.FilterOperator.GT;P=v.substr(1);}else if(B){if(B[1]&&B[2]){o=sap.ui.model.FilterOperator.BT;P=B[1];s=B[2];}else if(B[1]&&!B[2]){o=sap.ui.model.FilterOperator.GE;P=B[1];}else{o=sap.ui.model.FilterOperator.LE;P=B[2];}}else if(i&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){o=sap.ui.model.FilterOperator.Contains;P=v.substr(1,v.length-2);}else if(i&&v.indexOf("*")==0){o=sap.ui.model.FilterOperator.EndsWith;P=v.substr(1);}else if(i&&v.lastIndexOf("*")==v.length-1){o=sap.ui.model.FilterOperator.StartsWith;P=v.substr(0,v.length-1);}else{if(this.getDefaultFilterOperator()){o=this.getDefaultFilterOperator();}else{if(i){o=sap.ui.model.FilterOperator.Contains;}else{o=sap.ui.model.FilterOperator.EQ;}}P=v.substr(0);}if(!s){f=new F(p,o,this._parseFilterValue(P));}else{f=new F(p,o,this._parseFilterValue(P),this._parseFilterValue(s));}}else{f=new F(p,o,this._parseFilterValue(v));}}return f;};C.prototype.filter=function(v){var t=this.getParent();if(t&&t.isBound("rows")){var c=t.fireFilter({column:this,value:v});if(c){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var f=[];var d=t.getColumns();for(var i=0,l=d.length;i<l;i++){var o=d[i],m=o.getMenu(),g;try{g=o._getFilter();if(m._setFilterState){m._setFilterState(sap.ui.core.ValueState.None);}}catch(e){if(m._setFilterState){m._setFilterState(sap.ui.core.ValueState.Error);}continue;}if(g){f.push(g);}}t.getBinding("rows").filter(f,sap.ui.model.FilterType.Control);this._renderFilterIcon();}}return this;};C.prototype._parseFilterValue=function(v){var f=this.getFilterType();if(f){if(q.isFunction(f)){v=f(v);}else{v=f.parseValue(v,"string");}}return v;};C.prototype._renderFilterIcon=function(){var t=this.getParent();if(t&&t.getDomRef()){var c=sap.ui.getCore().getConfiguration().getTheme();var i=sap.ui.getCore().byId(this.getId()+"-filterIcon")||sap.ui.table.TableHelper.createImage(this.getId()+"-filterIcon");i.$().remove();i.addStyleClass("sapUiTableColIconsFilter");if(this.getFiltered()){i.setSrc(sap.ui.resource("sap.ui.table","themes/"+c+"/img/ico12_filter.gif"));var r=new R();var h=r.getHTML(i);q(h).prependTo(this.getDomRef("icons"));this.$().find(".sapUiTableColCell").addClass("sapUiTableColFiltered");}else{this.$().find(".sapUiTableColCell").removeClass("sapUiTableColFiltered");}}};C.prototype._restoreIcons=function(){if(this.getSorted()){this._renderSortIcon();}if(this.getFiltered()){this._renderFilterIcon();}};C.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped();};C.prototype.setFilterType=function(t){var o=t;if(typeof(t)==="string"){try{var c=q.sap.parseJS(t);if(typeof(c.type)==="string"){var f=q.sap.getObject(c.type);o=f&&new f(c.formatOptions,c.constraints);}}catch(e){var f=q.sap.getObject(t);o=f&&new f();}if(!(o instanceof T)){q.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");o=undefined;}}this.setProperty("filterType",o,true);return this;};return C;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.ColumnMenu')){jQuery.sap.declare('sap.ui.table.ColumnMenu');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.RenderManager');jQuery.sap.require('sap.ui.unified.Menu');jQuery.sap.require('sap.ui.unified.MenuItem');sap.ui.define("sap/ui/table/ColumnMenu",['jquery.sap.global','sap/ui/core/RenderManager','./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem'],function(q,R,a,M,b){"use strict";var C=M.extend("sap.ui.table.ColumnMenu",{metadata:{library:"sap.ui.table"}});C.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this.oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;this._attachPopupClosed();};C.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);this._detachEvents();this._oColumn=this._oTable=null;};C.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};C.prototype.setParent=function(p){this._detachEvents();this._invalidate();this._updateReferences(p);this._attachEvents();return M.prototype.setParent.apply(this,arguments);};C.prototype._updateReferences=function(p){this._oColumn=p;if(p){this._oTable=this._oColumn.getParent();if(this._oTable){}}};C.prototype._attachEvents=function(){if(this._oTable){this._oTable.attachColumnVisibility(this._invalidate,this);this._oTable.attachColumnMove(this._invalidate,this);}};C.prototype._detachEvents=function(){if(this._oTable){this._oTable.detachColumnVisibility(this._invalidate,this);this._oTable.detachColumnMove(this._invalidate,this);}};C.prototype._invalidate=function(){this._bInvalidated=true;};C.prototype._attachPopupClosed=function(){var t=this;if(!sap.ui.Device.support.touch){this.getPopup().attachClosed(function(e){t._iPopupClosedTimeoutId=window.setTimeout(function(){if(t._oColumn){if(t._lastFocusedDomRef){t._lastFocusedDomRef.focus();}else{t._oColumn.focus();}}},0);});}};C.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this.destroyItems();this._addMenuItems();}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};C.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};C.prototype._addSortMenuItem=function(d){var c=this._oColumn;var D=d?"desc":"asc";var i=d?"sort-descending":"sort-ascending";if(c.getSortProperty()&&c.getShowSortMenuEntry()){this.addItem(this._createMenuItem(D,"TBL_SORT_"+D.toUpperCase(),i,function(e){c.sort(d,e.getParameter("ctrlKey")===true);}));}};C.prototype._addFilterMenuItem=function(){var c=this._oColumn;var t=c.getParent();var e=false;if(t){e=t.getEnableCustomFilter();}if(c.getFilterProperty()&&c.getShowFilterMenuEntry()){if(e){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(E){t.fireCustomFilter({column:c});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",c.getFilterValue(),function(E){c.filter(this.getValue());}));}}};C.prototype._addGroupMenuItem=function(){var c=this._oColumn;var t=this._oTable;if(t&&t.getEnableGrouping()&&c.getSortProperty()){this.addItem(this._createMenuItem("group","TBL_GROUP",null,q.proxy(function(e){t.setGroupBy(c);},this)));}};C.prototype._addFreezeMenuItem=function(){var c=this._oColumn;var t=this._oTable;if(t&&t.getEnableColumnFreeze()){var i=q.inArray(c,t.getColumns());var I=i+1==t.getFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(e){var E=t.fireColumnFreeze({column:c});if(E){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};C.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){var c=this._createMenuItem("column-visibilty","TBL_COLUMNS");this.addItem(c);var o=new M(c.getId()+"-menu");o.addStyleClass("sapUiTableColumnVisibilityMenu");c.setSubmenu(o);var d=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){d=d.sort(s);}}var B=t.getBinding();var A=sap.ui.model&&sap.ui.model.analytics&&B instanceof sap.ui.model.analytics.AnalyticalBinding;for(var i=0,l=d.length;i<l;i++){var e=d[i];if(A&&e instanceof sap.ui.table.AnalyticalColumn){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+e.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){continue;}}var f=this._createColumnVisibilityMenuItem(o.getId()+"-item-"+i,e);o.addItem(f);}}};C.prototype._createColumnVisibilityMenuItem=function(i,c){var t=c.getName()||(c.getLabel()&&c.getLabel().getText?c.getLabel().getText():null);return new b(i,{text:t,icon:c.getVisible()?"sap-icon://accept":null,select:q.proxy(function(e){var m=e.getSource();var v=!c.getVisible();if(v||this._oTable._getVisibleColumnCount()>1){var T=c.getParent();var E=true;if(T&&T instanceof sap.ui.table.Table){E=T.fireColumnVisibility({column:c,newVisible:v});}if(E){c.setVisible(v);}m.setIcon(v?"sap-icon://accept":null);}},this)});};C.prototype._createMenuItem=function(i,t,I,h){return new b(this.getId()+"-"+i,{text:this.oResBundle.getText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};C.prototype._createMenuTextFieldItem=function(i,t,I,v,h){q.sap.require("sap.ui.unified.MenuTextFieldItem");h=h||function(){};return new sap.ui.unified.MenuTextFieldItem(this.getId()+"-"+i,{label:this.oResBundle.getText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};C.prototype._setFilterValue=function(v){var f=sap.ui.getCore().byId(this.getId()+"-filter");if(f){f.setValue(v);}return this;};C.prototype._setFilterState=function(f){var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F){F.setValueState(f);}return this;};return C;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.DataTableRenderer')){jQuery.sap.declare('sap.ui.table.DataTableRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/table/DataTableRenderer",['jquery.sap.global','sap/ui/core/Renderer','./TreeTableRenderer'],function(q,R,T){"use strict";var D=R.extend(T);return D;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.Row')){jQuery.sap.declare('sap.ui.table.Row');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');sap.ui.define("sap/ui/table/Row",['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E,l){"use strict";var R=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"}}}});R.prototype.getIndex=function(){var t=this.getParent();if(t){var f=t.getFirstVisibleRow();var r=t.indexOfRow(this);return f+r;}return-1;};return R;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.Table')){jQuery.sap.declare('sap.ui.table.Table');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.IntervalTrigger');jQuery.sap.require('sap.ui.core.ScrollBar');jQuery.sap.require('sap.ui.core.delegate.ItemNavigation');jQuery.sap.require('sap.ui.core.theming.Parameters');jQuery.sap.require('sap.ui.model.SelectionModel');sap.ui.define("sap/ui/table/Table",['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IntervalTrigger','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/SelectionModel','./Row','./library'],function(q,C,I,S,a,P,b,R,c){"use strict";var T=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:sap.ui.table.SelectionMode.Multi},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:sap.ui.table.SelectionBehavior.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},allowColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:sap.ui.table.NavigationMode.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:sap.ui.table.VisibleRowCountMode.Fixed},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Appearance",defaultValue:null,deprecated:true},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"int"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},rowIndex:{type:"int"},columnIndex:{type:"int"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},rowIndex:{type:"int"},columnIndex:{type:"int"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{}}}});T.ResizeTrigger=new I(300);T.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bAccMode=sap.ui.getCore().getConfiguration().getAccessibility();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._oSelection=new b(b.MULTI_SELECTION);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);this._iColMinWidth=20;this._oCalcColumnWidths=[];this._aIdxCols2Cells=[];this._aVisibleColumns=[];var f={onAfterRendering:function(e){e.srcControl.$("sb").attr("tabindex","-1").css("outline","none");}};this._oVSb=new S(this.getId()+"-vsb",{size:"100%"});this._oVSb.attachScroll(this.onvscroll,this);this._oVSb.addDelegate(f);this._oHSb=new S(this.getId()+"-hsb",{size:"100%",contentSize:"0px",vertical:false});this._oHSb.attachScroll(this.onhscroll,this);this._oHSb.addDelegate(f);this._bActionMode=false;this._iLastFixedColIndex=-1;this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._bCallUpdateTableCell=false;this._iTimerDelay=250;this._doubleclickDelay=300;this._clicksRegistered=0;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;};T.prototype.exit=function(){this._oVSb.destroy();this._oHSb.destroy();if(this._oPaginator){this._oPaginator.destroy();}this._destroyItemNavigation();this._cleanUpTimers();this._detachEvents();};T.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};T.prototype.onBeforeRendering=function(){this._cleanUpTimers();this._detachEvents();};T.prototype.onAfterRendering=function(){this._bOnAfterRendering=true;var $=this.$();if(sap.ui.Device.system.tablet){$.addClass("sapUiTableTouch");}this._renderOverlay();this._updateVSb(true);this._updateTableContent();this._handleResize();this._attachEvents();var d=this.getColumns();for(var i=0,l=d.length;i<l;i++){if(d[i].getVisible()){d[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._initItemNavigation();if(this._bDetermineVisibleCols===true){this._determineVisibleCols();this._bDetermineVisibleCols=false;}};T.prototype._renderOverlay=function(){var $=this.$(),d=$.find(".sapUiTableOverlay"),s=this.getShowOverlay();if(s&&d.length===0){d=q("<div>").addClass("sapUiOverlay sapUiTableOverlay").css("z-index","1");$.append(d);}else if(!s){d.remove();}};T.prototype.setShowOverlay=function(s){this.setProperty("showOverlay",s,true);this._renderOverlay();return this;};T.prototype._updateTableContent=function(){this._updateNoData();this._updateSelection();if(this._modifyRow){var t=this;q.each(this.getRows(),function(i,r){t._modifyRow(i+t.getFirstVisibleRow(),r.$());t._modifyRow(i+t.getFirstVisibleRow(),r.$("fixed"));});}var B=this.getBinding("rows");var f=this.getFixedRowCount();var F=this.getFixedBottomRowCount();var v=this.getVisibleRowCount();var t=this;if(B){q.each(this.getRows(),function(i,r){var $=r.$();var d=r.$("fixed");var e=t.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(r.getBindingContext()){e.attr("title",t._oResBundle.getText("TBL_ROW_SELECT"));}else{e.attr("title","");}if(f>0){var g=i<f;if(g){if(!$.hasClass("sapUiTableFixedTopRow")){$.addClass('sapUiTableFixedTopRow');d.addClass('sapUiTableFixedTopRow');e.addClass('sapUiTableFixedTopRow');}}else if($.hasClass("sapUiTableFixedTopRow")){$.removeClass('sapUiTableFixedTopRow');d.removeClass('sapUiTableFixedTopRow');e.removeClass('sapUiTableFixedTopRow');}}if(F>0){var h,j;if(B.getLength()>=v){h=i>v-F-1;j=i>v-F-2;}else{h=(t.getFirstVisibleRow()+i)>(B.getLength()-1-F)&&(t.getFirstVisibleRow()+i)<B.getLength();j=(t.getFirstVisibleRow()+i)>(B.getLength()-2-F)&&(t.getFirstVisibleRow()+i)<B.getLength();}if(h){if(!$.hasClass("sapUiTableFixedBottomRow")){$.addClass('sapUiTableFixedBottomRow');d.addClass('sapUiTableFixedBottomRow');e.addClass('sapUiTableFixedBottomRow');}}else if($.hasClass("sapUiTableFixedBottomRow")){$.removeClass('sapUiTableFixedBottomRow');d.removeClass('sapUiTableFixedBottomRow');e.removeClass('sapUiTableFixedBottomRow');}if(j){if(!$.hasClass("sapUiTableFixedPreBottomRow")){$.addClass('sapUiTableFixedPreBottomRow');d.addClass('sapUiTableFixedPreBottomRow');e.addClass('sapUiTableFixedPreBottomRow');}}else if($.hasClass("sapUiTableFixedPreBottomRow")){$.removeClass('sapUiTableFixedPreBottomRow');d.removeClass('sapUiTableFixedPreBottomRow');e.removeClass('sapUiTableFixedPreBottomRow');}}});}this._updateRowHeader();if(this._bOnAfterRendering&&(this._bCallUpdateTableCell||typeof this._updateTableCell==="function")){var t=this;var o=this.mBindingInfos["rows"];q.each(this.getRows(),function(i,r){var A=t.getFirstVisibleRow()+i;q.each(r.getCells(),function(i,d){if(d._updateTableCell){d._updateTableCell(d,d.getBindingContext(o&&o.model),d.$().closest("td"),A);}if(t._updateTableCell){t._updateTableCell(d,d.getBindingContext(o&&o.model),d.$().closest("td"),A);}});});}};T.prototype._initItemNavigation=function(){var $=this.$();var d=this._getVisibleColumnCount();var t=d;var h=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;if(!this._oColHdrItemNav){this._oColHdrItemNav=new a();this._oColHdrItemNav.setCycling(false);this.addDelegate(this._oColHdrItemNav);}var e=[];if(this.getFixedColumnCount()==0){e=$.find(".sapUiTableCtrl td[tabindex]").get();}else{var f=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');var g=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');var j=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');var k=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');var l=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');var m=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');for(var i=0;i<this.getVisibleRowCount();i++){e=e.concat(f.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(g.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(j.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(k.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(l.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());e=e.concat(m.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());}}var n=e.length;var o=0;if(h){var r=$.find(".sapUiTableRowHdr").get();for(var i=r.length-1;i>=0;i--){e.splice(i*d,0,r[i]);n++;}n--;t++;o=1;}if(this.getColumnHeaderVisible()){e=$.find(".sapUiTableCol").get().concat(e);}if(h&&this.getColumnHeaderVisible()){var p=$.find(".sapUiTableColRowHdr").get();for(var i=this._getHeaderRowCount()-1;i>=0;i--){e.splice(i*d,0,p[0]);}}if(!this._oItemNavigation){this._iLastSelectedDataRow=this._getHeaderRowCount();this._oItemNavigation=new a();this._oItemNavigation.setTableMode(true);this._oItemNavigation.attachEvent(a.Events.BeforeFocus,function(E){this.$("ariadesc").text("");},this);this._oItemNavigation.attachEvent(a.Events.AfterFocus,function(E){var s=Math.floor(E.getParameter("index")/this._oItemNavigation.iColumns);if(s>0){this._iLastSelectedDataRow=s;}},this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setColumns(t);this._oItemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setFocusedIndex(o);};T.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this._oItemNavigation.destroy();this._oItemNavigation=undefined;}};T.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return sap.ui.core.Element.prototype.getFocusInfo.apply(this,arguments);}};T.prototype.applyFocusInfo=function(f){if(f&&f.customId){this.$().find("#"+f.customId).focus();}else{sap.ui.core.Element.prototype.getFocusInfo.apply(this,arguments);}return this;};T.prototype.setTitle=function(t){var o=t;if(typeof(t)==="string"||t instanceof String){o=sap.ui.table.TableHelper.createTextView({text:t,width:"100%"});o.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",o);return this;};T.prototype.setFooter=function(f){var F=f;if(typeof(f)==="string"||f instanceof String){F=sap.ui.table.TableHelper.createTextView({text:f,width:"100%"});}this.setAggregation("footer",F);return this;};T.prototype.setSelectionMode=function(s){this._oSelection.clearSelection();if(s===sap.ui.table.SelectionMode.Single){this._oSelection.setSelectionMode(b.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(b.MULTI_SELECTION);}this.setProperty("selectionMode",s);return this;};T.prototype.setFirstVisibleRow=function(r,o){this.setProperty("firstVisibleRow",r,true);if(this.getBinding("rows")&&!this._bRefreshing){this.updateRows();}return this;};T.prototype.getAllowColumnReordering=function(){q.sap.log.warning("getAllowColumnReordering is deprecated - please use getEnableColumnReordering!");return T.prototype.getEnableColumnReordering.apply(this,arguments);};T.prototype.setAllowColumnReordering=function(){q.sap.log.warning("setAllowColumnReordering is deprecated - please use setEnableColumnReordering!");return T.prototype.setEnableColumnReordering.apply(this,arguments);};T.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;T.prototype.bindRows=function(B,t,s,f){if(typeof B==="string"&&(t instanceof sap.ui.model.Sorter||q.isArray(s)&&s[0]instanceof sap.ui.model.Filter)){f=s;s=t;t=undefined;}return this.bindAggregation("rows",B,t,s,f);};T.prototype._bindAggregation=function(n,p,t,s,f){sap.ui.core.Element.prototype._bindAggregation.apply(this,arguments);var B=this.getBinding("rows");if(n==="rows"&&B){B.attachChange(this._onBindingChange,this);}return this;};T.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};T.prototype.unbindAggregation=function(n,s){var B=this.getBinding("rows");if(n==="rows"&&B){B.detachChange(this._onBindingChange);s=true;this._restoreAppDefaultsColumnHeaderSortFilter();}this.updateRows();return sap.ui.core.Element.prototype.unbindAggregation.apply(this,[n,s]);};T.prototype.setVisibleRowCountMode=function(v){this.setProperty("visibleRowCountMode",v);this._handleRowCountMode();return this;};T.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);return this;};T.prototype.refreshRows=function(r){this._bBusyIndicatorAllowed=true;this._bRefreshing=true;this._onBindingChange(r);this._updateBindingContexts(true);this._bRefreshing=false;};T.prototype.updateRows=function(r){this._setBusy(false);var s=this.getFirstVisibleRow();s=Math.max(s,0);if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar&&this._getRowCount()>0){s=Math.min(s,Math.max(this._getRowCount()-this.getVisibleRowCount(),0));}this.setProperty("firstVisibleRow",s,true);if(this._oVSb.getScrollPosition()!==s){this._oVSb.setScrollPosition(s);}if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){var n=1;if(s<this.getBinding("rows").getLength()){n=Math.ceil((s+1)/this.getVisibleRowCount());}if(n!==this._oPaginator.getCurrentPage()){this.setProperty("firstVisibleRow",(n-1)*this.getVisibleRowCount(),true);this._oPaginator.setCurrentPage(n);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}}if(this.getDomRef()){this._sBindingTimer=this._sBindingTimer||q.sap.delayedCall(50,this,function(){if(!this.bIsDestroyed){this._determineVisibleCols();this._updateBindingContexts();this._updateVSb();this._updateTableContent();this._sBindingTimer=undefined;this.fireEvent("_rowsUpdated");}});}};T.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!");};T.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!");};T.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!");};T.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!");};T.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!");};T.prototype.autoResizeColumn=function(i){var o=this.getColumns()[i];this._iColumnResizeStart=null;var n=this._calculateAutomaticColumnWidth(i);if(n==null){return;}o._iNewWidth=n;this._oCalcColumnWidths[i]=o._iNewWidth;this._onColumnResized(null,i);};T.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(i)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableColRsz").mousedown(q.proxy(this._onColumnResizeStart,this));this._enableColumnAutoResizing();T.ResizeTrigger.addListener(this._checkTableSize,this);this._oHSb.bind($.find(".sapUiTableCtrlScr").get(0));this._oVSb.bind($.find(".sapUiTableCtrlScr").get(0));this._oHSb.bind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.bind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.bind($.find(".sapUiTableRowHdrScr").get(0));q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(e){if(q(e.target).has($).length>0){this._handleResize();}},this));};T.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableColHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();T.ResizeTrigger.removeListener(this._checkTableSize,this);$.find(".sapUiTableColRsz").unbind();this._oHSb.unbind($.find(".sapUiTableCtrlScr").get(0));this._oVSb.unbind($.find(".sapUiTableCtrlScr").get(0));this._oHSb.unbind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.unbind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.unbind($.find(".sapUiTableRowHdrScr").get(0));q("body").unbind('webkitTransitionEnd transitionend');};T.prototype._cleanUpTimers=function(){if(this._sBindingTimer){q.sap.clearDelayedCall(this._sBindingTimer);this._sBindingTimer=undefined;}if(this._sScrollBarTimer){q.sap.clearDelayedCall(this._sScrollBarTimer);this._sScrollBarTimer=undefined;}if(this._sDelayedMenuTimer){q.sap.clearDelayedCall(this._sDelayedMenuTimer);this._sDelayedMenuTimer=undefined;}if(this._sDelayedActionTimer){q.sap.clearDelayedCall(this._sDelayedActionTimer);this._sDelayedActionTimer=undefined;}if(this._sColHdrPosTimer){q.sap.clearDelayedCall(this._sColHdrPosTimer);this._sColHdrPosTimer=undefined;}if(this._visibleRowCountTimer){q.sap.clearDelayedCall(this._visibleRowCountTimer);this._visibleRowCountTimer=undefined;}T.ResizeTrigger.removeListener(this._checkTableSize,this);};T.prototype._createRows=function(s){var f=this.getFirstVisibleRow();var v=this.getVisibleRowCount();s=s===undefined?f:s;var t=new R(this.getId()+"-rows");var d=this.getColumns();var e=0;for(var i=0,l=d.length;i<l;i++){if(d[i].getVisible()){var o=d[i].getTemplate();if(o){var g=o.clone("col"+i);if(this._bInheritEditableToControls&&!this.getEditable()&&g.setEditable){g.setEditable(false);}g.data("sap-ui-colindex",i);t.addCell(g);this._aIdxCols2Cells[i]=e++;}}}this.destroyAggregation("rows",true);var h;var B=this.getBinding("rows");var j=this.mBindingInfos["rows"];if(B&&v>0){var k=this.getThreshold()?Math.max(this.getVisibleRowCount(),this.getThreshold()):0;var F=this.getFixedBottomRowCount();h=B.getContexts(s,v-F,k);this._setBusy({requestedLength:v-F,receivedLength:h.length,contexts:h});if(F>0&&(v-F)<B.getLength()){var m=B.getContexts(B.getLength()-F,F,1);h=h.concat(m);this._setBusy({requestedLength:F,receivedLength:m.length,contexts:m});}}for(var i=0;i<v;i++){var g=t.clone("row"+i);if(h&&h[i]){g.setBindingContext(h[i],j.model);g._bHidden=false;}else{if(j){g.setBindingContext(null,j.model);}else{g.setBindingContext(null);}g._bHidden=true;}this.addAggregation("rows",g,true);}t.destroy();};T.prototype._updateHSb=function(){var $=this.$();var i=$.find(".sapUiTableCtrlScroll").width();if(!!sap.ui.Device.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>$.find(".sapUiTableCtrlScr").width()){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!sap.ui.Device.browser.safari){var d=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){d.width(i);}else{d.outerWidth(i);}}}var s=$.find(".sapUiTableCtrlFixed").width();if($.find(".sapUiTableRowHdrScr:visible").length>0){s+=$.find(".sapUiTableRowHdrScr").width();}var e=$.find(".sapUiTableHSb");if(this._bRtlMode){e.css('padding-right',s+'px');}else{e.css('padding-left',s+'px');}var m=e.parent().width();e.css('max-width',m+"px");this._oHSb.setContentSize(i+"px");if(this._oHSb.getDomRef()){this._oHSb.rerender();}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!sap.ui.Device.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}this._syncHeaderAndContent();};T.prototype._updateVSb=function(o){var $=this.$();var d=false;var f=false;var B=this.getBinding("rows");if(B){var F=this.getFixedRowCount();if(F>0){var O=$.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetTop;this.$().find('.sapUiTableVSb').css('top',(O-1)+'px');f=true;}var i=this.getFixedBottomRowCount();if(i>0){var e=$.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetHeight;this.$().find('.sapUiTableVSb').css('height',e+'px');f=true;}var s=Math.max(0,(B.getLength()||0)-this.getVisibleRowCount());if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){var n=Math.ceil((B.getLength()||0)/this.getVisibleRowCount());this._oPaginator.setNumberOfPages(n);var p=Math.min(n,Math.ceil((this.getFirstVisibleRow()+1)/this.getVisibleRowCount()));this.setProperty("firstVisibleRow",(Math.max(p,1)-1)*this.getVisibleRowCount(),true);this._oPaginator.setCurrentPage(p);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");}}else{if(s>0){if(!$.hasClass("sapUiTableVScr")){$.addClass("sapUiTableVScr");d=true;}}else{if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");d=true;}}}if(o||f||s!==this._oVSb.getSteps()||this.getFirstVisibleRow()!==this._oVSb.getScrollPosition()){q.sap.clearDelayedCall(this._sScrollBarTimer);this._sScrollBarTimer=q.sap.delayedCall(o?0:250,this,function(){this._oVSb.setSteps(s);if(this._oVSb.getDomRef()){this._oVSb.rerender();}this._oVSb.setScrollPosition(this.getFirstVisibleRow());});}}else{if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){this._oPaginator.setNumberOfPages(0);this._oPaginator.setCurrentPage(0);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}else{if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");d=true;}}}if(d&&!this._bOnAfterRendering){this._handleResize();}};T.prototype._updateBindingContexts=function(s){var r=this.getRows(),B=this.getBinding("rows"),o=this.mBindingInfos["rows"],f,d,F,i=this.getFixedRowCount(),e=this.getFixedBottomRowCount(),v=this.getVisibleRowCount();if(B){var t;if(i>0||e>0){var g=i+e;t=this.getThreshold()?Math.max((this.getVisibleRowCount()-g),this.getThreshold()):0;d=B.getContexts(this.getFirstVisibleRow()+i,r.length-g,t);this._setBusy({requestedLength:r.length-g,receivedLength:d.length,contexts:d});if(i>0){f=B.getContexts(0,i);this._setBusy({requestedLength:i,receivedLength:f.length,contexts:f});d=f.concat(d);}if(e>0&&(v-e)<B.getLength()){F=B.getContexts(B.getLength()-e,e);this._setBusy({requestedLength:e,receivedLength:F.length,contexts:F});d=d.concat(F);}}else if(r.length>0){t=this.getThreshold()?Math.max(this.getVisibleRowCount(),this.getThreshold()):0;d=B.getContexts(this.getFirstVisibleRow(),r.length,t);this._setBusy({requestedLength:r.length,receivedLength:d.length,contexts:d});}}if(!s){for(var h=r.length-1;h>=0;h--){var j=d?d[h]:undefined;var k=r[h];if(k){var A=this.getFirstVisibleRow()+h;this._updateRowBindingContext(k,j,o&&o.model,A);}}}};T.prototype._updateRowBindingContext=function(r,o,m,A){var d=r.getCells();var $=r.$();var e=r.$("fixed");var f=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");r.setBindingContext(o,m);if(o&&o instanceof sap.ui.model.Context){for(var i=0,l=this._aVisibleColumns.length;i<l;i++){var g=this._aIdxCols2Cells[this._aVisibleColumns[i]];if(d[g]){this._updateCellBindingContext(d[g],o,m,A);}}if($.hasClass("sapUiTableRowHidden")){$.removeClass("sapUiTableRowHidden");e.removeClass("sapUiTableRowHidden");f.removeClass("sapUiTableRowHidden");}r._bHidden=false;}else{if(!$.hasClass("sapUiTableRowHidden")){$.addClass("sapUiTableRowHidden");e.addClass("sapUiTableRowHidden");f.addClass("sapUiTableRowHidden");}if($.hasClass("sapUiTableFixedBottomRow")){$.removeClass('sapUiTableFixedBottomRow');e.removeClass('sapUiTableFixedBottomRow');f.removeClass('sapUiTableFixedBottomRow');}if($.hasClass("sapUiTableFixedPreBottomRow")){$.removeClass('sapUiTableFixedPreBottomRow');e.removeClass('sapUiTableFixedPreBottomRow');f.removeClass('sapUiTableFixedPreBottomRow');}if($.hasClass("sapUiTableFixedTopRow")){$.removeClass('sapUiTableFixedTopRow');e.removeClass('sapUiTableFixedTopRow');f.removeClass('sapUiTableFixedTopRow');}r._bHidden=true;for(var i=0,l=this._aVisibleColumns.length;i<l;i++){var g=this._aIdxCols2Cells[this._aVisibleColumns[i]];if(d[g]){this._updateCellBindingContext(d[g],o,m,A);}}}};T.prototype._updateCellBindingContext=function(o,d,m,A){if(this._bCallUpdateTableCell&&o._updateTableCell){o._updateTableCell(o,d,o.$().closest("td"),A);}if(typeof this._updateTableCell==="function"){this._updateTableCell(o,d,o.$().closest("td"),A);}};T.prototype._hasData=function(){var B=this.getBinding("rows");if(!B||(B.getLength()||0)===0){return false;}return true;};T.prototype._updateNoData=function(){if(this.getShowNoData()){var B=this.getBinding("rows");if(!this._hasData()){if(!this.$().hasClass("sapUiTableEmpty")){this.$().addClass("sapUiTableEmpty");}this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS",[0]));}else{if(this.$().hasClass("sapUiTableEmpty")){this.$().removeClass("sapUiTableEmpty");}this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS",[(B.getLength()||0)]));}}};T.prototype._determineVisibleCols=function(){var $=this.$(),t=this;if($.hasClass("sapUiTableHScr")){var r=this._bRtlMode;var s=this._oHSb.getNativeScrollPosition();if(r&&sap.ui.Device.browser.firefox&&s<0){s=s*-1;}var d=s+this._getScrollWidth();if(this._iOldScrollLeft!==s||this._iOldScrollRight!==d||this._bForceVisibleColCalc){var L=r?$.find(".sapUiTableCtrlScroll").width():0;if((sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.firefox)&&r){L=0;}this._aVisibleColumns=[];for(var i=0,l=this.getFixedColumnCount();i<l;i++){this._aVisibleColumns.push(i);}var e=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll .sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex]");e.each(function(g,E){var w=q(E).width();if(r&&sap.ui.Device.browser.chrome){L-=w;}if(L+w>=s&&L<=d){t._aVisibleColumns.push(parseInt(q(E).data('sap-ui-headcolindex'),10));}if(!r||(sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.firefox)){L+=w;}});this._iOldScrollLeft=s;this._iOldScrollRight=d;this._bForceVisibleColCalc=false;}}else{this._aVisibleColumns=[];var f=this.getColumns();for(var i=0,l=f.length;i<l;i++){if(f[i].shouldRender()){this._aVisibleColumns.push(i);}}}};T.prototype._enableColumnAutoResizing=function(){var t=this;q.each(this.getColumns(),function(i,o){if(!!o.getAutoResizable()){var $=q.find(".sapUiTableColRsz[data-sap-ui-colindex="+i+"]");if($){t._bindSimulatedDoubleclick($,null,t._onAutomaticColumnResize);}}});};T.prototype.removeColumn=function(o){this.removeAggregation('columns',o);this._bDetermineVisibleCols=true;return this;};T.prototype.addColumn=function(o){var t=this;this.addAggregation('columns',o);o.attachEvent('_widthChanged',function(e){t._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;return this;};T.prototype.insertColumn=function(o,i){var t=this;this.insertAggregation('columns',o,i);o.attachEvent('_widthChanged',function(){t._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;return this;};T.prototype._getRowCount=function(){var B=this.getBinding("rows");return B?(B.getLength()||0):0;};T.prototype._getSelectableRowCount=function(){return this._getRowCount();};T.prototype._getScrollTop=function(){if(this.$().hasClass("sapUiTableVScr")){return this._oVSb.getScrollPosition()||0;}else{if(this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){return(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}else{return 0;}}};T.prototype._getScrollWidth=function(){return this.$().find(".sapUiTableCtrlScr").width();};T.prototype._getScrollHeight=function(){return this.$().find(".sapUiTableCtrlScr").height();};T.prototype._getVisibleColumns=function(){var d=[];var e=this.getColumns();for(var i=0,l=e.length;i<l;i++){if(e[i].shouldRender()){d.push(e[i]);}}return d;};T.prototype._getVisibleColumnCount=function(){return this._getVisibleColumns().length;};T.prototype._getHeaderRowCount=function(){if(!this.getColumnHeaderVisible()){return 0;}else if(!this._useMultiHeader()){return 1;}var h=0;q.each(this._getVisibleColumns(),function(i,o){h=Math.max(h,o.getMultiLabels().length);});return h;};T.prototype._useMultiHeader=function(){var u=false;q.each(this._getVisibleColumns(),function(i,o){if(o.getMultiLabels().length>0){u=true;return false;}});return u;};T.prototype._getColumnsWidth=function(s,e){var d=this.getColumns();var f=0;if(s!==0&&!s){s=0;}if(e!==0&&!e){e=d.length;}for(var i=s,l=e;i<l;i++){if(d[i]&&d[i].shouldRender()){var w=d[i].getWidth();var W=parseInt(w,10);if(q.sap.endsWith(w,"px")){f+=W;}else{f+=this._iColMinWidth;}}}return f;};T.prototype._handleResize=function(){if(!this.getDomRef()){return;}this._updateHSb();this._updateColumnHeader();this._updateRowHeader();this._handleRowCountMode();};T.prototype._checkTableSize=function(){if(!this.getDomRef()){return;}var p=this.getDomRef().parentNode,h=p.offsetHeight,w=p.offsetWidth;if(p!=this._lastParent||h!=this._lastParentHeight||w!=this._lastParentWidth){this._handleResize();this._lastParent=p;this._lastParentHeight=h;this._lastParentWidth=w;if(this.getBinding("rows")){this.updateRows();}}};T.prototype._handleRowCountMode=function(){if(this.getVisibleRowCountMode()==sap.ui.table.VisibleRowCountMode.Auto){var i=this.$().parent().height();var r=this._calculateRowsToDisplay(i);if(isNaN(r)){return;}var t=this;this._visibleRowCountTimer=setTimeout(function(){t.setVisibleRowCount(r);},0);}};T.prototype._updateRowHeader=function(){if(this.getFixedRowCount()>=0||this.getFixedColumnCount()>=0||this.getRowHeight()<=0){var $=this.$();var d=$.find(".sapUiTableCtrlFixed > tbody > tr");var e=$.find(".sapUiTableCtrlScroll > tbody > tr");var f=$.find(".sapUiTableRowHdr");if(this.getFixedColumnCount()>0&&!this.getRowHeight()){d.css('height','');e.css('height','');}for(var i=0,l=e.length;i<l;i++){var h=Math.max(d[i]?(d[i].getBoundingClientRect().bottom-d[i].getBoundingClientRect().top):0,e[i]?(e[i].getBoundingClientRect().bottom-e[i].getBoundingClientRect().top):0);if(this._bjQueryLess18){q(f[i]).height(h);if(this.getFixedColumnCount()>0&&!this.getRowHeight()){q(d[i]).height(h);q(e[i]).height(h);}}else{q(f[i]).outerHeight(h);if(this.getFixedColumnCount()>0&&!this.getRowHeight()){q(d[i]).outerHeight(h);q(e[i]).outerHeight(h);}}}}};T.prototype._updateColumnHeader=function(u){if(this._sColHdrPosTimer){q.sap.clearDelayedCall(this._sColHdrPosTimer);}var r=this._bRtlMode;var l=this._bRtlMode?"99000px":"-99000px";var s=function(){this._resizeDependentColumns();var t=this,$=this.$();var d=$.find(".sapUiTableColHdr .sapUiTableCol");var e=$.find(".sapUiTableColHdr .sapUiTableColRsz");var f=this._getVisibleColumns();if(f.length==0){return;}var g=$.width();var h=$.find(".sapUiTableCtrlFirstCol > th");var H=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;var k=0;if(H){var o=h.get(0);k=o.getBoundingClientRect().right-o.getBoundingClientRect().left;h=h.not(":nth-child(1)");}h.each(function(i,E){if(f[i]){q(E).css('width',f[i].getWidth());}});h.each(function(z,E){var W=(E.getBoundingClientRect().right-E.getBoundingClientRect().left),A=f[z]?f[z].getHeaderSpan():1,B=[],D;if(A){if(q.isArray(A)){q.each(A,function(N,O){A[N]=Math.max((O+z>f.length)?Math.min(O,f.length-z):O,1);});D=A;}else{A=Math.max((A+z>f.length)?Math.min(A,f.length-z):A,1);D=[A];}}else{D=[1];}if(z==0){W+=k;}for(var i=0;i<D.length;i++){B[i]=W;for(var j=1;j<D[i];j++){var F=h[z+j];if(F){B[i]+=F.getBoundingClientRect().right-F.getBoundingClientRect().left;}}}var G=d.filter('[data-sap-ui-colindex='+q(E).data('sap-ui-headcolindex')+']');if(G.length>0){if(!u){var J=sap.ui.getCore().byId(G.first().data("sap-ui-colid"));for(var i=0;i<G.length;i++){if(t._bjQueryLess18){q(G[i]).width(B[i]||B[0]);}else{q(G[i]).outerWidth(B[i]||B[0]);}}J._iRealWidth=W;}var L=G.first().position().left;if(L===0&&G.css("display")=="none"){F=h[z];L=F.getBoundingClientRect().left;}var K=q(E).data('sap-ui-headcolindex');for(var i=0;i<D[0];i++){L+=(r?-2:(h[z+i].getBoundingClientRect().right-h[z+i].getBoundingClientRect().left)-3);var M=e.filter('[data-sap-ui-colindex='+K+']');if(L>=0&&L<=g){M.css({"left":L});}else if(M.css("left")!==l){M.css({"left":l});}K++;}}});var m=this.getColumnHeaderHeight()>0;if(!m&&!u){var n=$.find(".sapUiTableColHdr");var p=$.find(".sapUiTableColHdrCnt");var v=$.find(".sapUiTableColRowHdr");var w=v.add(p);w.height("auto");d.height("auto");var x=Math.max(n.height(),p.height());var y=x/this._getHeaderRowCount();if(this._bjQueryLess18){d.height(y);w.height(x);}else{d.outerHeight(y);w.outerHeight(x);}}};if(this._bOnAfterRendering){s.apply(this,arguments);}else{this._sColHdrPosTimer=q.sap.delayedCall(150,this,s);}};T.prototype._disableTextSelection=function(e){q(e||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(E){E.preventDefault();return false;});};T.prototype._enableTextSelection=function(e){q(e||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};T.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(e){}}};T.prototype.onvscroll=function(e){this._leaveActionMode();this.setFirstVisibleRow(this._getScrollTop(),true);};T.prototype._syncHeaderAndContent=function(){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var s=this._oHSb.getNativeScrollPosition();$.find(".sapUiTableCtrlScr").scrollLeft(s);if(!!sap.ui.Device.browser.webkit&&this._bRtlMode){var o=$.find(".sapUiTableColHdrScr").get(0);s=o.scrollWidth-o.clientWidth-this._oHSb.getScrollPosition();}$.find(".sapUiTableColHdrScr").scrollLeft(s);this._bSyncScrollLeft=false;}};T.prototype.onhscroll=function(e){if(!this._bOnAfterRendering){this._syncHeaderAndContent();this._updateColumnHeader(true);if(this.getBinding("rows")){this.updateRows();}}};T.prototype._oncolscroll=function(e){if(!this._bSyncScrollLeft){var $=this.$().find(".sapUiTableColHdrScr");if(!!sap.ui.Device.browser.webkit&&this._bRtlMode){var s=this.$().find(".sapUiTableColHdrScr").get(0);this._oHSb.setScrollPosition(s.scrollWidth-s.clientWidth-$.scrollLeft());}else{this._oHSb.setNativeScrollPosition($.scrollLeft());}}};T.prototype._oncntscroll=function(e){if(!this._bSyncScrollLeft){var $=this.$().find(".sapUiTableCtrlScr");this._oHSb.setNativeScrollPosition($.scrollLeft());}};T.prototype.onmousedown=function(e){var l=e.button===(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=8?1:0);if(l){var $=q(e.target);var d=this.$("sb");if(e.target==d[0]){q(document.body).bind("selectstart",q.proxy(this._splitterSelectStart,this));var o=d.offset();var h=d.height();var w=d.width();q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiHSBGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");d.append("<div id=\""+this.getId()+"-overlay\" style =\"left: 0px;"+" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");q(document).bind("mouseup",q.proxy(this._onGhostMouseRelease,this));q(document).bind("mousemove",q.proxy(this._onGhostMouseMove,this));return;}var f=$.closest(".sapUiTableCol");if(f.length===1){this._bShowMenu=true;this._sDelayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});if(this.getEnableColumnReordering()){var i=parseInt(f.attr("data-sap-ui-colindex"),10);if(i>this._iLastFixedColIndex){var g=this.getColumns()[i];this._sDelayedActionTimer=q.sap.delayedCall(200,this,function(){this._onColumnMoveStart(g);});}}}var j=!!(e.metaKey||e.ctrlKey);if(!!sap.ui.Device.browser.firefox&&j){e.preventDefault();}}};T.prototype.onmouseup=function(e){q.sap.clearDelayedCall(this._sDelayedActionTimer);if(e.isMarked()){return;}if(this.$().find(".sapUiTableCtrl td :focus").length>0){this._enterActionMode(this.$().find(".sapUiTableCtrl td :focus"));}else{this._leaveActionMode(e);}};T.prototype.onclick=function(e){q.sap.clearDelayedCall(this._sDelayedActionTimer);if(e.isMarked()){return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){this._onSelect(e);}else{e.preventDefault();}};T.prototype.oncontextmenu=function(e){var t=q(e.target);var h=t.closest('.sapUiTableCol');if(h.length>0){var o=sap.ui.getCore().byId(h.attr("data-sap-ui-colid"));if(o){o._openMenu(h[0]);}e.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,e,this._oncellcontextmenu)){e.preventDefault();}}};T.prototype._oncellcontextmenu=function(p){if(this.getEnableCellFilter()){if(!this._oContextMenu){q.sap.require("sap.ui.unified.Menu");q.sap.require("sap.ui.unified.MenuItem");this._oContextMenu=new sap.ui.unified.Menu(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var o=this._getVisibleColumns()[p.columnIndex];var s=o.getFilterProperty();if(s&&o.getShowFilterMenuEntry()){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var d=this.getContextByIndex(p.rowIndex);var v=d.getProperty(s);this.filter(o,v);},this]}));var e=sap.ui.core.Popup.Dock;this._oContextMenu.open(false,p.cellDomRef,e.BeginTop,e.BeginBottom,p.cellDomRef,"none none");return true;}}};T.prototype._bindSimulatedDoubleclick=function(e,f,d){var g="click";var t=this;if(!!sap.ui.Device.support.touch){g="touchend";}q(e).on(g,function(E){E.preventDefault();E.stopPropagation();t._clicksRegistered=t._clicksRegistered+1;if(t._clicksRegistered<2){t._singleClickTimer=q.sap.delayedCall(t._doubleclickDelay,t,function(){t._clicksRegistered=0;if(f){f.call(t,E);}},[E]);}else{q.sap.clearDelayedCall(t._singleClickTimer);t._clicksRegistered=0;d.call(t,E);}});};T.prototype._findAndfireCellEvent=function(f,e,d){var $=q(e.target);var g=$.closest("td[role='gridcell']");var i=g.attr("id");var m=/.*-row(\d*)-col(\d*)/i.exec(i);var h=false;if(m){var r=m[1];var j=m[2];var o=this.getRows()[r];var k=o&&o.getCells()[j];var l=o&&o.getIndex();var p={rowIndex:l,columnIndex:j,cellControl:k};h=!f.call(this,p);if(!h&&typeof d==="function"){p.cellDomRef=g[0];h=d.call(this,p);}}return h;};T.prototype.onfocusin=function(e){var $=q(e.target);if(!this._bIgnoreFocusIn&&($.hasClass("sapUiTableCtrlBefore")||$.hasClass("sapUiTableCtrlAfter"))){this.$("ariadesc").text(this._oResBundle.getText("TBL_TABLE"));this._leaveActionMode();if(q.contains(this.$().find('.sapUiTableColHdrCnt')[0],e.target)){q(this._oItemNavigation.getFocusedDomRef()||this._oItemNavigation.getRootDomRef()).focus();}else{if($.hasClass("sapUiTableCtrlBefore")){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex()%this._oItemNavigation.iColumns,e);}else{this._oItemNavigation.focusItem((this._oItemNavigation.getFocusedIndex()%this._oItemNavigation.iColumns)+(this._oItemNavigation.iColumns*this._iLastSelectedDataRow),e);}}e.preventDefault();}else if(q.sap.endsWith(e.target.id,"-rsz")){e.preventDefault();e.stopPropagation();}};T.prototype._onSelect=function(e){var $=q(e.target);var s=e.shiftKey;var d=!!(e.metaKey||e.ctrlKey);var f=$.closest(".sapUiTableCol");if(this._bShowMenu&&f.length===1){var i=parseInt(f.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[i];this._onColumnSelect(o,f[0]);return;}var g=$.closest(".sapUiTableRowHdr");if(g.length===1){var i=parseInt(g.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getFirstVisibleRow()+i,s,d);return;}if((this.getSelectionBehavior()===sap.ui.table.SelectionBehavior.Row||this.getSelectionBehavior()===sap.ui.table.SelectionBehavior.RowOnly)){var g=$.closest(".sapUiTableCtrl > tbody > tr");if(g.length===1){var i=parseInt(g.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getFirstVisibleRow()+i,s,d);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),e.target)){this._toggleSelectAll();return;}};T.prototype._isRowSelectable=function(r){return true;};T.prototype._onRowSelect=function(r,s,d){if(!!sap.ui.Device.browser.internet_explorer&&s){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(r<0||r>=(B.getLength()||0)){return;}if(!this._isRowSelectable(r)){return;}this._iSourceRowIndex=r;var o=this.getSelectionMode();if(o!==sap.ui.table.SelectionMode.None){if(o===sap.ui.table.SelectionMode.Single){if(!this.isIndexSelected(r)){this.setSelectedIndex(r);}else{this.clearSelection();}}else{if(o===sap.ui.table.SelectionMode.MultiToggle){d=true;}if(s){var i=this.getSelectedIndex();if(i>=0){this.addSelectionInterval(i,r);}else{this.setSelectedIndex(r);}}else{if(!this.isIndexSelected(r)){if(d){this.addSelectionInterval(r,r);}else{this.setSelectedIndex(r);}}else{if(d){this.removeSelectionInterval(r,r);}else{if(this.getSelectedIndices().length===1){this.clearSelection();}else{this.setSelectedIndex(r);}}}}}}this._iSourceRowIndex=undefined;};T.prototype._onColumnSelect=function(o,d){var e=this.fireColumnSelect({column:o});if(e){o._openMenu(d);}};T.prototype._onColumnMoveStart=function(o){this.$().addClass("sapUiTableDragDrop");this._disableTextSelection();var $=o.$();var i=parseInt($.attr("data-sap-ui-colindex"),10);if(i<this.getFixedColumnCount()){return;}this._$colGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});this._$colGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":this.$().zIndex()+10});this.$().find(".sapUiTableCol").each(function(d,e){var $=q(this);$.css({position:"relative"});$.data("pos",{left:$.position().left,center:$.position().left+$.outerWidth()/2,right:$.position().left+$.outerWidth()});});this._$colGhost.appendTo(document.body);q(document.body).mousemove(q.proxy(this._onColumnMove,this)).mouseup(q.proxy(this._onColumnMoved,this));};T.prototype._onColumnMove=function(e){var $=this.$();var r=this._bRtlMode;var i=e.pageX-$.offset().left;var d=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var D=this.getColumns()[d].$();var o=this._iNewColPos;this._iNewColPos=d;var t=this;$.find(".sapUiTableCol").each(function(f,g){var h=q(g);var j=parseInt(h.attr("data-sap-ui-colindex"),10);var H=sap.ui.getCore().byId(h.attr("data-sap-ui-colid")).getHeaderSpan();var s;if(H){if(q.isArray(H)){s=H[0];}else{s=H;}}else{s=1;}if(h.get(0)!==D.get(0)){var p=h.data("pos");var B=i>=p.left&&i<=p.center;var A=i>=p.center&&i<=p.right;if(!r){if(B){t._iNewColPos=j;}else if(A){t._iNewColPos=j+s;}else{t._iNewColPos=t._iNewColPos;}}else{if(A){t._iNewColPos=j;}else if(B){t._iNewColPos=j+s;}else{t._iNewColPos=t._iNewColPos;}}if((B||A)&&j>d){t._iNewColPos--;}}});if(this._iNewColPos<=this._iLastFixedColIndex){this._iNewColPos=o;}if(this._iNewColPos<this.getFixedColumnCount()){this._iNewColPos=o;}this._animateColumnMove(d,o,this._iNewColPos);this._$colGhost.css({"left":e.pageX+5,"top":e.pageY+5});};T.prototype._animateColumnMove=function(d,o,n){var r=this._bRtlMode;var D=this.getColumns()[d].$();if(o!==n){for(var i=Math.min(o,n),l=Math.max(o,n);i<=l;i++){var e=this.getColumns()[i];if(i!==d&&e.getVisible()){e.$().stop(true,true).animate({left:"0px"});}}var O=0;if(n<d){for(var i=n;i<d;i++){var e=this.getColumns()[i];if(e.getVisible()){var $=e.$();O-=$.outerWidth();$.stop(true,true).animate({left:D.outerWidth()*(r?-1:1)+"px"});}}}else{for(var i=d+1,l=n+1;i<l;i++){var e=this.getColumns()[i];if(e.getVisible()){var $=e.$();O+=$.outerWidth();$.stop(true,true).animate({left:D.outerWidth()*(r?1:-1)+"px"});}}}D.stop(true,true).animate({left:O*(r?-1:1)+"px"});}};T.prototype._onColumnMoved=function(e){this.$().removeClass("sapUiTableDragDrop");var d=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var D=this.getColumns()[d];q(document.body).unbind("mousemove",this._onColumnMove).unbind("mouseup",this._onColumnMoved);this._$colGhost.remove();this._$colGhost=undefined;this._enableTextSelection();var E=this.fireColumnMove({column:D,newPos:this._iNewColPos});var m=d<this._iNewColPos;if(E&&this._iNewColPos!==undefined&&this._iNewColPos!==d){this.removeColumn(D);this.insertColumn(D,this._iNewColPos);var h=D.getHeaderSpan(),s;if(h){if(q.isArray(h)){s=h[0];}else{s=h;}}else{s=1;}if(s>1){if(!m){this._iNewColPos++;}for(var i=1;i<s;i++){var o=this.getColumns()[m?d:d+i];this.removeColumn(o);this.insertColumn(o,this._iNewColPos);this.fireColumnMove({column:o,newPos:this._iNewColPos});if(!m){this._iNewColPos++;}}}this._oColHdrItemNav.setFocusedIndex(this._iNewColPos);}else{this._animateColumnMove(d,this._iNewColPos,d);D.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}setTimeout(function(){var O=this._oItemNavigation.getFocusedIndex();this._oItemNavigation.focusItem(0,e);this._oItemNavigation.focusItem(O,e);}.bind(this),0);delete this._iNewColPos;};T.prototype._onAutomaticColumnResize=function(e){var i,o,h,m,d=1,r=false;q.sap.log.debug("doubleclick fired");this._disableTextSelection();this._$colResize=q(e.target);this._$colResize.addClass("sapUiTableColRszActive");var p=parseInt(this._$colResize.prevAll(".sapUiTableCol").first().attr("data-sap-ui-colindex"),10);i=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);if(p!=i){r=true;}if(r){o=this.getColumns()[p];h=o.getHeaderSpan();if(h instanceof Array){m=Math.max.apply(Math,h);}else if(!!h){m=h;}if(i+h-1!=p){d=m;i=p+m;}}if(d>1){while(i>p){i--;this.autoResizeColumn(i);}}else{this.autoResizeColumn(i);}e.preventDefault();e.stopPropagation();};T.prototype._onColumnResizeStart=function(e){var l=e.button===(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=8?1:0);if(l){this._iColumnResizeStart=e.pageX;this._disableTextSelection();this._$colResize=q(e.target);q(document.body).mousemove(q.proxy(this._onColumnResize,this)).mouseup(q.proxy(this._onColumnResized,this));}};T.prototype._onColumnResize=function(e){if(this._iColumnResizeStart&&e.pageX<this._iColumnResizeStart+3&&e.pageX>this._iColumnResizeStart-3){return;}this._$colResize.addClass("sapUiTableColRszActive");this._iColumnResizeStart=null;var $=this.$();var r=this._bRtlMode;var i=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[i];var d=$.find(".sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex='"+i+"']");var f=d.position().left;var w;if(!r){if(this.getFixedColumnCount()>0&&i>=this.getFixedColumnCount()){var F=$.find(".sapUiTableColHdrFixed").width();f=f+F;f=f-$.find(".sapUiTableCtrlScr").scrollLeft();}var O=$.find(".sapUiTableCtrlFirstCol > th:first").offset().left;var g=e.pageX-O;w=g-f;}else{var s;if(this.getFixedColumnCount()>0&&i<this.getFixedColumnCount()){s=$.find('.sapUiTableCtrlScrFixed');}else{s=$.find('.sapUiTableCtrlScr');}var h=s.scrollLeft();if(sap.ui.Device.browser.internet_explorer){h=s[0].scrollWidth-h-s[0].clientWidth;}else if(sap.ui.Device.browser.firefox){h=h+s[0].scrollWidth-s[0].clientWidth;}var D=f-h-e.pageX+s.offset().left;w=d.outerWidth()+D;}w=Math.max(w,this._iColMinWidth);var j=$.find(".sapUiTableCnt").offset().left;var k=e.pageX-j;k-=this._$colResize.width()/2;this._$colResize.css("left",k);o._iNewWidth=w;};T.prototype._onColumnResized=function(e,i){var d;if(!this._$colResize&&(i===null||i===undefined)){return;}if(i===null||i===undefined){d=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);}else{d=i;}var o=this.getColumns()[d];var r=false;if(!this._iColumnResizeStart&&o._iNewWidth){var w;var A=this.$().find(".sapUiTableCtrl").width();if(!this._checkPercentageColumnWidth()){w=o._iNewWidth+"px";}else{var f=Math.round(100/A*o._iNewWidth);w=f+"%";}this._updateColumnWidth(o,w);this._resizeDependentColumns(o,w);delete o._iNewWidth;r=true;}q(document.body).unbind("mousemove",this._onColumnResize).unbind("mouseup",this._onColumnResized);o.focus();if(this._$colResize){this._$colResize.removeClass("sapUiTableColRszActive");this._$colResize=undefined;}this._enableTextSelection();if(r){this.invalidate();}};T.prototype._resizeDependentColumns=function(o,w){if(this._checkPercentageColumnWidth()){var v=this._getVisibleColumns();var d;q.each(v,function(m,s){if(o===s){d=m;}});var O=0;var l=v.length-1;var t;if(d===undefined){t=0;}else{t=parseInt(w,10);}var p=0;var e=[];var f=this;q.each(v,function(m,s){var u=f._getColumnPercentageWidth(s);if((((d===l&&m<d)||((d!==l)&&m>d))&&s.getFlexible())||d===undefined){O+=s.$().outerWidth();p+=u;e.push(s);}else if(m!==d){t+=u;}});var g=t;q.each(e,function(m,s){var u=f._getColumnPercentageWidth(s);var N=Math.round((100-g)/p*u);if(m===e.length-1){N=100-t;}else{t+=N;}f._updateColumnWidth(s,N+"%");});}else if(!this._hasOnlyFixColumnWidths()){var v=this._getVisibleColumns(),A=this.$().find(".sapUiTableCtrl").width(),d,r=0,L=0,h=0,n=0;q.each(v,function(m,s){if(!q.sap.endsWith(s.getWidth(),"px")){n++;return false;}if(d!=undefined){h+=parseInt(s.getWidth(),10);r++;}else if(o!==s){L+=parseInt(s.getWidth(),10);}if(o===s){d=m;L+=parseInt(w,10);}});if(n>0||(L+h>A)){return;}A-=L;for(var i=d+1;i<v.length;i++){var o=v[i],j=parseInt(o.getWidth(),10),k=j/h*100,N=A/100*k;this._updateColumnWidth(o,Math.round(N)+'px');}}};T.prototype._getColumnPercentageWidth=function(o){var s=o.getWidth();var i=parseInt(o.getWidth(),10);var t=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(s,"px")){i=Math.round(100/t*i);}else if(!q.sap.endsWith(s,"%")){i=Math.round(100/t*o.$().width());}return i;};T.prototype._updateColumnWidth=function(o,w){var e=this.fireColumnResize({column:o,width:w});if(e){o.setProperty("width",w,true);this.$().find('th[aria-owns="'+o.getId()+'"]').css('width',w);}};T.prototype._checkPercentageColumnWidth=function(){var d=this.getColumns();var h=false;q.each(d,function(i,o){if(q.sap.endsWith(o.getWidth(),"%")){h=true;return false;}});return h;};T.prototype._hasOnlyFixColumnWidths=function(){var o=true;q.each(this.getColumns(),function(i,d){var w=d.getWidth();if(d.getFlexible()||!w||w.substr(-2)!=="px"){o=false;return false;}});return o;};T.prototype.sort=function(o,s,A){if(q.inArray(o,this.getColumns())>=0){o.sort(s===sap.ui.table.SortOrder.Descending,A);}};T.prototype.filter=function(o,v){if(q.inArray(o,this.getColumns())>=0){o.filter(v);}};T.prototype._updateSelection=function(){if(this.getSelectionMode()===sap.ui.table.SelectionMode.None){return;}var $=this.$();var f=this.getFirstVisibleRow();var t=this;var r=this._oResBundle;var m=this._oSelection.getSelectedIndices().length>1;var s=this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowSelector;var d=r.getText("TBL_ROW_SELECT");var e=r.getText("TBL_ROW_SELECT_KEY");var g=r.getText("TBL_ROW_DESELECT");var h=r.getText("TBL_ROW_DESELECT_KEY");var i=r.getText("TBL_ROW_SELECT_MULTI");var j=r.getText("TBL_ROW_SELECT_MULTI_KEY");var k=r.getText("TBL_ROW_DESELECT_MULTI");var l=r.getText("TBL_ROW_DESELECT_MULTI_KEY");$.find(".sapUiTableRowHdr").each(function(n,E){var o=q($.find(".sapUiTableCtrlFixed > tbody > tr").get(n));var p=q($.find(".sapUiTableCtrlScroll > tbody > tr").get(n));var u=o.add(p);var v=q(this);var w=v.add(u);if(t.isIndexSelected(f+n)){if(!q(this).hasClass("sapUiTableRowSel")){q(this).addClass("sapUiTableRowSel");u.addClass("sapUiTableRowSel");w.attr("aria-selected","true");u.children("td").attr("aria-selected","true");}if(m){u.find(".sapUiTableAriaRowSel").text(l);if(s){w.attr("title",k).attr("aria-label",l);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-deselectrowmulti");}}else{u.find(".sapUiTableAriaRowSel").text(h);if(s){w.attr("title",g).attr("aria-label",h);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-deselectrow");}}}else{if(q(this).hasClass("sapUiTableRowSel")){q(this).removeClass("sapUiTableRowSel");u.removeClass("sapUiTableRowSel");if(t.getSelectionMode()===sap.ui.table.SelectionMode.Multi||t.getSelectionMode()===sap.ui.table.SelectionMode.MultiToggle){w.attr("aria-selected","false");u.children("td").attr("aria-selected","false");}else{w.removeAttr("aria-selected");u.children("td").removeAttr("aria-selected");}}if((t.getSelectionMode()===sap.ui.table.SelectionMode.Multi||t.getSelectionMode()===sap.ui.table.SelectionMode.MultiToggle)&&t._oSelection.getSelectedIndices().length>0){u.find(".sapUiTableAriaRowSel").text(i);if(s){w.attr("title",i).attr("aria-label",j);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-selectrowmulti");}}else{u.find(".sapUiTableAriaRowSel").text(e);if(s){w.attr("title",d).attr("aria-label",e);u.children("td").attr('aria-describedby',t.getId()+"-toggleedit "+t.getId()+"-selectrow");}}}});this.setProperty("selectedIndex",this.getSelectedIndex(),true);};T.prototype._onSelectionChanged=function(e){var r=e.getParameter("rowIndices");var i=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();var s=this.getSelectionMode();if(s==="Multi"||s==="MultiToggle"){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");}this.fireRowSelectionChange({rowIndex:i,rowContext:this.getContextByIndex(i),rowIndices:r});};T.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContexts(i,1)[0]:null;};T.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};T.prototype.setSelectedIndex=function(i){if(i===-1){this._oSelection.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};T.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};T.prototype.selectAll=function(){var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){this._oSelection.setSelectionInterval(0,(B.getLength()||0)-1);this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};T.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};T.prototype.addSelectionInterval=function(i,d){this._oSelection.addSelectionInterval(i,d);return this;};T.prototype.setSelectionInterval=function(i,d){this._oSelection.setSelectionInterval(i,d);return this;};T.prototype.removeSelectionInterval=function(i,d){this._oSelection.removeSelectionInterval(i,d);return this;};T.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};T.prototype._scrollNext=function(){if(this.getFirstVisibleRow()<this._getRowCount()-this.getVisibleRowCount()){this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow()+1,this._getRowCount()-this.getVisibleRowCount()));}};T.prototype._scrollPrevious=function(){if(this.getFirstVisibleRow()>0){this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow()-1,0));}};T.prototype._scrollPageUp=function(){this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow()-this.getVisibleRowCount(),0));};T.prototype._scrollPageDown=function(){this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow()+this.getVisibleRowCount(),this._getRowCount()-this.getVisibleRowCount()));};T.prototype._isTopRow=function(e){var $=q(e.target);var r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=this.getFixedRowCount();if(f>0&&r>=f){return r===f;}return r===0;};T.prototype._isBottomRow=function(e){var $=q(e.target);var r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=this.getFixedBottomRowCount();if(f>0&&r<=this.getVisibleRowCount()-1-f){return r===this.getVisibleRowCount()-1-f;}return r===this.getVisibleRowCount()-1;};T.prototype._enterActionMode=function(f){if(f.length>0&&!this._bActionMode){if(f.filter(":sapTabbable").length==0){return;}this._bActionMode=true;this.removeDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","-1");f.filter(":sapTabbable").eq(0).focus();}};T.prototype._leaveActionMode=function(e){if(this._bActionMode){this._bActionMode=false;this.addDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","0");if(e){if(q(e.target).closest("td[tabindex='-1']").length>0){var i=q(this._oItemNavigation.aItemDomRefs).index(q(e.target).closest("td[tabindex='-1']").get(0));this._oItemNavigation.focusItem(i,null);}else{if(q.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0),e.target)){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}};T.prototype._getFocusedRowIndex=function(){var f=this._oItemNavigation.iFocusedIndex;var i=this._oItemNavigation.iColumns;var s=f%i;var d=this.getFirstVisibleRow()+(f-s)/i;if(!this.getColumnHeaderVisible()){d++;}return d-1;};T.prototype._isFocusedRowSelected=function(){var s=this._getFocusedRowIndex();var i=this.isIndexSelected(s);var d=(this._oItemNavigation.iFocusedIndex%this._oItemNavigation.iColumns==0);if(d){return i;}else{var h=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;if(h){return null;}else{return i;}}};T.prototype.onkeyup=function(e){if(!this._bEventSapSelect===true){return;}this._bEventSapSelect=false;if(e.keyCode!==q.sap.KeyCodes.ENTER&&e.keyCode!==q.sap.KeyCodes.SPACE&&e.keyCode!==q.sap.KeyCodes.F4||e.srcControl!==this&&q.inArray(e.srcControl,this.getRows())===-1&&q.inArray(e.srcControl,this.getColumns())===-1){return;}var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B){if(B.isExpanded(r)){B.collapse(r);}else{B.expand(r);}}e.preventDefault();return;}this._bShowMenu=true;this._onSelect(e);this._bShowMenu=false;e.preventDefault();};T.prototype.onsapselect=function(){this._bEventSapSelect=true;};T.prototype.onkeydown=function(e){var $=this.$();if(!this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2||e.keyCode==q.sap.KeyCodes.ENTER){if($.find(".sapUiTableCtrl td:focus").length>0){this._enterActionMode($.find(".sapUiTableCtrl td:focus").find(":sapFocusable"));e.preventDefault();e.stopPropagation();}}else if(this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2){this._leaveActionMode(e);}else if(e.keyCode==q.sap.KeyCodes.TAB&&this._bActionMode){if(this.getFixedColumnCount()>0){var d=q(e.target);if(d.is("td[role=gridcell]")==false){d=d.parents("td[role=gridcell]");}var f=d.parent("tr[data-sap-ui-rowindex]");var g=f.closest(".sapUiTableCtrl");var r=parseInt(f.attr("data-sap-ui-rowindex"),10);var h=f.find("td[role=gridcell]");var i=h.index(d);var t=h.length;if(i===(t-1)){var j;if(g.hasClass("sapUiTableCtrlFixed")){j=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll");}else{j=$.find(".sapUiTableCtrl.sapUiTableCtrlFixed");r++;if(r==this.getVisibleRowCount()){r=0;}}var k=j.find("tr[data-sap-ui-rowindex='"+r+"']");var l=k.find("td :sapFocusable[tabindex='0']").first();if(l.length>0){l.focus();e.preventDefault();}}}}else if(e.keyCode==q.sap.KeyCodes.A&&(e.metaKey||e.ctrlKey)){var o=this._oItemNavigation;var F=o.getFocusedIndex();this._toggleSelectAll();o.focusItem(F,e);e.preventDefault();e.stopImmediatePropagation(true);}else if(e.keyCode===q.sap.KeyCodes.F10&&(e.shiftKey)){this.oncontextmenu(e);}};T.prototype.onsapescape=function(e){this._leaveActionMode(e);};T.prototype.onsaptabprevious=function(e){var $=this.$();if(this._bActionMode){this._leaveActionMode();e.preventDefault();}else{var i=this._oItemNavigation;if(q.contains($.find('.sapUiTableCCnt')[0],e.target)&&this.getColumnHeaderVisible()){var d=i.getFocusedIndex()%i.iColumns;i.focusItem(d,e);e.preventDefault();}else if(i.getFocusedDomRef()===e.target&&q.sap.containsOrEquals($.find(".sapUiTableCCnt").get(0),e.target)){this._bIgnoreFocusIn=true;$.find(".sapUiTableCtrlBefore").focus();this._bIgnoreFocusIn=false;}}};T.prototype.onsaptabnext=function(e){var $=this.$();if(this._bActionMode){this._leaveActionMode();e.preventDefault();}else{var i=this._oItemNavigation;if(q.contains($.find('.sapUiTableColHdrCnt')[0],e.target)){i.focusItem(i.getFocusedIndex()+i.iColumns*this._iLastSelectedDataRow,e);e.preventDefault();}else if(i.getFocusedDomRef()===e.target){this._bIgnoreFocusIn=true;$.find(".sapUiTableCtrlAfter").focus();this._bIgnoreFocusIn=false;}}};T.prototype.onsapdown=function(e){if(!this._bActionMode&&this._isBottomRow(e)){if(this.getFirstVisibleRow()!=this._getRowCount()-this.getVisibleRowCount()-this.getFixedBottomRowCount()){e.stopImmediatePropagation(true);if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar){this._scrollNext();}else{this._scrollPageDown();}}}e.preventDefault();};T.prototype.onsapdownmodifiers=function(e){if(e.shiftKey){var f=this._getFocusedRowIndex();var i=this._isFocusedRowSelected();if(i===true){this.addSelectionInterval(f+1,f+1);}else if(i===false){this.removeSelectionInterval(f+1,f+1);}if(this._isBottomRow(e)){this._scrollNext();}}else if(e.altKey){this._toggleGroupHeader(e);}};T.prototype.onsapupmodifiers=function(e){if(e.shiftKey){var f=this._getFocusedRowIndex();var i=this._isFocusedRowSelected();if(i===true){this.addSelectionInterval(f-1,f-1);}else if(i===false){this.removeSelectionInterval(f-1,f-1);}if(this._isTopRow(e)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}this._scrollPrevious();}}else if(e.altKey){this._toggleGroupHeader(e);}};T.prototype.onsapup=function(e){if(!this._bActionMode&&this._isTopRow(e)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar){this._scrollPrevious();}else{this._scrollPageUp();}}e.preventDefault();};T.prototype.onsappagedown=function(e){if(!this._bActionMode){var $=this.$();var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;if(this.getColumnHeaderVisible()&&i.iFocusedIndex<(i.iColumns*h)){var d=i.iFocusedIndex%i.iColumns;if((i.iFocusedIndex<=(i.iColumns*h)&&i.iFocusedIndex>=(i.iColumns*h)-i.iColumns)||(d===0&&r)){this.setFirstVisibleRow(0);i.focusItem(i.iColumns*h+d,e);}else{i.focusItem(i.iColumns*h-i.iColumns+d,e);}e.stopImmediatePropagation(true);}else{if(this._isBottomRow(e)){this._scrollPageDown();}}e.preventDefault();}};T.prototype.onsappagedownmodifiers=function(e){if(!this._bActionMode&&e.altKey){var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var d=i.iFocusedIndex%i.iColumns;var n;if(d==0&&r){n=1;}else{var v=this._aVisibleColumns.length;var m=this._getVisibleColumns().length;if(!r){m--;}if(v===0){n=m;}else{n=Math.min(m,d+v);}}i.focusItem(i.iFocusedIndex-(d-n),e);e.stopImmediatePropagation(true);e.preventDefault();}};T.prototype.onsappageup=function(e){if(!this._bActionMode){var $=this.$();var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;var d=i.iFocusedIndex%i.iColumns;if(this.getColumnHeaderVisible()&&i.iFocusedIndex<(i.iColumns*h)){if(i.iFocusedIndex>i.iColumns){i.focusItem(d,e);}e.stopImmediatePropagation(true);}else{if(this.getColumnHeaderVisible()&&this.getFirstVisibleRow()==0&&this._isTopRow(e)){if(r&&d===0){i.focusItem(d,e);}else{i.focusItem(i.iColumns*h-i.iColumns+d,e);}e.stopImmediatePropagation(true);}else{var f=this.getColumnHeaderVisible()?i.iColumns*h:0;i.focusItem(f+d,e);e.stopImmediatePropagation(true);if(this._isTopRow(e)){this._scrollPageUp();}}}e.preventDefault();}};T.prototype.onsappageupmodifiers=function(e){if(!this._bActionMode&&e.altKey){var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var d=i.iFocusedIndex%i.iColumns;if(d>0){var n;if(d==1&&r){n=0;}else{var v=this._aVisibleColumns.length;if(v===0){if(r){n=1;}else{n=0;}}else{var m=1;if(!r){m=0;}n=Math.max(m,d-v);}}i.focusItem(i.iFocusedIndex-(d-n),e);}e.stopImmediatePropagation(true);e.preventDefault();}};T.prototype.onsaphome=function(e){var i=(this.getSelectionBehavior()==sap.ui.table.SelectionBehavior.RowOnly);var d=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(d){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var g=this._oItemNavigation.iColumns;var s=f%g;var o=0;if(!i){o=1;}if(s>this.getFixedColumnCount()+o){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-s+this.getFixedColumnCount()+o,null);}else if(!i){if(s>1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-s+1,null);}else if(s==1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-1,null);}else{e.stopImmediatePropagation(true);}}};T.prototype.onsapend=function(e){var i=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(i){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var d=this._oItemNavigation.iColumns;var s=f%d;var g=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var o=0;if(!g){o=1;}if(s===0&&g){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f+1,null);}else if(s<this.getFixedColumnCount()-o){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-s+this.getFixedColumnCount()-o,null);}};T.prototype.onsaphomemodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);if(i){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var d=this._oItemNavigation.iColumns;var s=Math.ceil(f/d)-1;var g=f%d;if(this.getColumnHeaderVisible()){if(s==1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(g,e);}else if(s>1){e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var h=g+d;this._oItemNavigation.focusItem(h,e);}}else{e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var h=f-s*d;this._oItemNavigation.focusItem(h,e);}}};T.prototype.onsapendmodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);var f=this._oItemNavigation.iFocusedIndex;var d=this._oItemNavigation.iColumns;var s=f%d;e.stopImmediatePropagation(true);if(i){this._oItemNavigation.focusItem(f+d,e);}else{this.setFirstVisibleRow(this._getRowCount()-this.getVisibleRowCount());var g=this._oItemNavigation.aItemDomRefs.length-(d-s);this._oItemNavigation.focusItem(g,e);}}};T.prototype.onsapleft=function(e){this._collapseGroupHeader(e);};T.prototype.onsapright=function(e){this._expandGroupHeader(e);};T.prototype._toggleGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(r)){B.collapse(r);}else{B.expand(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype._collapseGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(r)){B.collapse(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype._expandGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&!B.isExpanded(r)){B.expand(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype.onsapleftmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var d=parseInt(t.attr('data-sap-ui-colindex'),10),v=this._getVisibleColumns(),o=v[this._aVisibleColumns.indexOf(d)];if(e.shiftKey){var n=parseInt(o.getWidth(),10)-16;o.setWidth((n>20?n:20)+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){if(d-1>=0){var N=0;for(var p=this._aVisibleColumns.indexOf(d)-1;p>=0;p--){N=this._aVisibleColumns[p];if(v[p].$().css("display")!=="none"){break;}}this.removeColumn(o);this.insertColumn(o,N);var h=o.getHeaderSpan();if(h>1){for(var i=1;i<h;i++){o=v[d+i];this.removeColumn(o);this.insertColumn(o,N+i);}}}e.preventDefault();e.stopImmediatePropagation();}}};T.prototype.onsaprightmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var d=parseInt(t.attr('data-sap-ui-colindex'),10);var v=this._getVisibleColumns();var p=this._aVisibleColumns.indexOf(d);var o=v[p];if(e.shiftKey){o.setWidth(parseInt(o.getWidth(),10)+16+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){var h=o.getHeaderSpan();if(p<v.length-h){var n=v[p+1].getHeaderSpan(),N=this._aVisibleColumns[p+n];for(var i=h-1;i>=0;i--){o=v[p+i];this.removeColumn(o);this.insertColumn(o,N+i);}}e.preventDefault();e.stopImmediatePropagation();}}};T.prototype.setGroupBy=function(v){var g=v;if(typeof g==="string"){g=sap.ui.getCore().byId(g);}var r=false;if(g&&g instanceof sap.ui.table.Column){if(q.inArray(g,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var e=this.fireGroup({column:g,groupedColumns:[g.getId()],type:sap.ui.table.GroupEventType.group});var o=sap.ui.getCore().byId(this.getGroupBy());if(o){o.setGrouped(false);r=true;}if(e&&g instanceof sap.ui.table.Column){g.setGrouped(true);}}if(!g||r){var B=this.getBindingInfo("rows");delete B.binding;this._bindAggregation("rows",B);}return this.setAssociation("groupBy",g);};T.prototype.getBinding=function(n){n=n||"rows";var B=sap.ui.core.Element.prototype.getBinding.call(this,n);if(this.getEnableGrouping()){q.sap.require("sap.ui.model.ClientListBinding");var g=sap.ui.getCore().byId(this.getGroupBy());var d=g&&g.getGrouped()&&n==="rows"&&B&&B instanceof sap.ui.model.ClientListBinding;if(d&&!B._modified){B._modified=true;this._modifyRow=function(r,$){this.$().find(".sapUiTableRowHdrScr").css("display","block");var h=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.isGroupHeader(r)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var s=B.isExpanded(r)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";h.html("<div class=\"sapUiTableGroupIcon "+s+"\" tabindex=\"-1\">"+B.getTitle(r)+"</div>");h.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");h.html("");h.removeClass("sapUiTableGroupHeader");}};this.onclick=function(E){if(q(E.target).hasClass("sapUiTableGroupIcon")){var $=q(E.target).parents("[data-sap-ui-rowindex]");if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B.isExpanded(r)){B.collapse(r);q(E.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");}else{B.expand(r);q(E.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");}}}else{if(T.prototype.onclick){T.prototype.onclick.apply(this,arguments);}}};var p=g.getSortProperty();B.sort(new sap.ui.model.Sorter(p));var l=B.getLength(),e=B.getContexts(0,l);var k;var f=0;for(var i=l-1;i>=0;i--){var N=e[i].getProperty(p);if(!k){k=N;}if(k!==N){e.splice(i+1,0,{oContext:e[i+1],name:k,count:f,groupHeader:true,expanded:true});k=N;f=0;}f++;}e.splice(0,0,{oContext:e[0],name:k,count:f,groupHeader:true,expanded:true});q.extend(B,{getLength:function(){return e.length;},getContexts:function(s,l){return e.slice(s,s+l);},isGroupHeader:function(h){var o=e[h];return o&&!(o instanceof sap.ui.model.Context);},getTitle:function(h){var o=e[h];return o&&!(o instanceof sap.ui.model.Context)&&(o["name"]+" - "+o["count"]);},isExpanded:function(h){return this.isGroupHeader(h)&&e[h].expanded;},expand:function(h){if(this.isGroupHeader(h)&&!e[h].expanded){for(var i=0;i<e[h].childs.length;i++){e.splice(h+1+i,0,e[h].childs[i]);}delete e[h].childs;e[h].expanded=true;this._fireChange();}},collapse:function(h){if(this.isGroupHeader(h)&&e[h].expanded){e[h].childs=e.splice(h+1,e[h].count);e[h].expanded=false;this._fireChange();}}});}}return B;};T.prototype.resetGrouping=function(){var B=this.getBinding("rows");if(B&&B._modified){this.$().find(".sapUiTableRowHdrScr").css("display","");this.onclick=T.prototype.onclick;this._modifyRow=undefined;var o=this.getBindingInfo("rows");this.unbindRows();this.bindRows(o);}};T.prototype.setEnableGrouping=function(e){this.setProperty("enableGrouping",e);if(!e){this.resetGrouping();}this._invalidateColumnMenus();return this;};T.prototype.setEnableCustomFilter=function(e){this.setProperty("enableCustomFilter",e);this._invalidateColumnMenus();return this;};T.prototype.setEnableColumnFreeze=function(e){this.setProperty("enableColumnFreeze",e);this._invalidateColumnMenus();return this;};T.prototype.setShowColumnVisibilityMenu=function(s){this.setProperty("showColumnVisibilityMenu",s);this._invalidateColumnMenus();return this;};T.prototype.setFixedColumnCount=function(f){var d=this._getVisibleColumns();var h=d[f-1]&&d[f-1].getHeaderSpan();if(h){var H;if(q.isArray(h)){H=parseInt(h[0],10);}else{H=parseInt(h,10);}f+=H-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<f;i++){var o=d[i];if(o){var e=q.inArray(o,this.getColumns());if(!o.getWidth()){o.setWidth($.filter("[data-sap-ui-headcolindex='"+e+"']").width()+"px");}}}this.setProperty("fixedColumnCount",f);this._invalidateColumnMenus();return this;};T.prototype._invalidateColumnMenus=function(){var d=this.getColumns();for(var i=0,l=d.length;i<l;i++){if(d[i].getMenu()){d[i].getMenu()._bInvalidated=true;}}};T.prototype._splitterSelectStart=function(e){e.preventDefault();e.stopPropagation();return false;};T.prototype._onGhostMouseRelease=function(e){var s=this.getDomRef("ghost");var n=e.pageY-this.$().offset().top;this.setVisibleRowCount(this._calculateRowsToDisplay(n));q(s).remove();this.$("overlay").remove();q(document.body).unbind("selectstart",this._splitterSelectStart);q(document).unbind("mouseup",this._onGhostMouseRelease);q(document).unbind("mousemove",this._onGhostMouseMove);};T.prototype._onGhostMouseMove=function(e){var s=this.getDomRef("ghost");var m=this.$().offset().top;if(e.pageY>m){q(s).css("top",e.pageY+"px");}};T.prototype._calculateRowsToDisplay=function(h){var m=this.getMinAutoRowCount()||5;if(!h){return m;}var $=this.$();if(!$.get(0)){return;}var i=$.get(0).getBoundingClientRect().height;var d=$.find('.sapUiTableCCnt').outerHeight();var r=$.find("tr:not(.sapUiAnalyticalTableSum) > td").outerHeight();if(!r){var s="sap.ui.table.Table:sapUiTableRowHeight";if($.parents().hasClass('sapUiSizeCompact')){s="sap.ui.table.Table:sapUiTableCompactRowHeight";}r=parseInt(P.get(s),10);}var M=window.innerHeight-2*r;var e=h-(i-d);var A=Math.min(e,M);return Math.max(m,Math.floor((A+1)/r));};T.prototype.setShowNoData=function(s){this.setProperty('showNoData',s,true);s=this.getProperty('showNoData');if(!s){this.$().removeClass("sapUiTableEmpty");}else{this._updateNoData();}return this;};T.prototype.setNoDataText=function(t){this.setProperty("noDataText",t,true);this.$().find('.sapUiTableCtrlEmptyMsg').text(t);};T.prototype.exportData=function(s){q.sap.require("sap.ui.core.util.Export");s=s||{};if(!s.rows){var B=this.getBinding("rows"),o=this.getBindingInfo("rows");var f=B.aFilters.concat(B.aApplicationFilters);s.rows={path:o.path,model:o.model,sorter:B.aSorters,filters:f,parameters:o.parameters};}if(!s.exportType){q.sap.require("sap.ui.core.util.ExportTypeCSV");s.exportType=new sap.ui.core.util.ExportTypeCSV();}var m=s.rows.model;if(!m){var p=s.rows.path;var d=p.indexOf(">");if(d>0){m=p.substr(0,d);}}if(!s.columns){s.columns=[];var e=this.getColumns();for(var i=0,l=e.length;i<l;i++){var g=e[i];if(g.getSortProperty()){s.columns.push({name:g.getLabel().getText(),template:{content:{path:g.getSortProperty(),model:m}}});}}}var E=new sap.ui.core.util.Export(s);this.addDependent(E);return E;};T.prototype._calculateAutomaticColumnWidth=function(d){var t=["sap.m.Text","sap.m.Label","sap.m.Link","sap.ui.commons.TextView","sap.ui.commons.Label","sap.ui.commons.Link"];var $=this.$();var h=0;var e=$.find('td[headers=\"'+this.getId()+'_col'+d+'\"]').children("div");var o=this.getColumns();var f=o[d];if(!f){return null;}var H=f.getHeaderSpan();var g=f.getLabel();var j=this;var k=f.getTemplate();var l=q.inArray(k.getMetadata().getName(),t)!=-1||sap.ui.commons&&sap.ui.commons.TextField&&k instanceof sap.ui.commons.TextField||sap.m&&sap.m.Input&&k instanceof sap.m.Input;var m=document.createElement("div");document.body.appendChild(m);q(m).addClass("sapUiTableHiddenSizeDetector");var n=f.getMultiLabels();if(n.length==0&&!!g){n=[g];}if(n.length>0){q.each(n,function(s,L){var u;if(!!L.getText()){q(m).text(L.getText());h=m.scrollWidth;}else{h=L.$().scrollWidth;}h=h+$.find("#"+f.getId()+"-icons").first().width();$.find(".sapUiTableColIcons#"+f.getId()+"_"+s+"-icons").first().width();if(H instanceof Array&&H[s]>1){u=H[s];}else if(H>1){u=H;}if(!!u){var i=u-1;while(i>d){h=h-(j._oCalcColumnWidths[d+i]||0);i-=1;}}});}var p=Math.max.apply(null,e.map(function(){var _=q(this);return parseInt(_.css('padding-left'),10)+parseInt(_.css('padding-right'),10)+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10);}).get());var r=Math.max.apply(null,e.children().map(function(){var w=0,W=0;var _=q(this);var s=_.text()||_.val();if(l){q(m).text(s);W=m.scrollWidth;}else{W=this.scrollWidth;}if(h>W){W=h;}w=W+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10)+p+1;return w;}).get());q(m).remove();return(r>this._iColMinWidth)?r:this._iColMinWidth;};T.prototype._onPersoApplied=function(){var d=this.getColumns();var s=[];for(var i=0,l=d.length;i<l;i++){var o=d[i];if(o.getSorted()){s.push(new sap.ui.model.Sorter(o.getSortProperty(),o.getSortOrder()===sap.ui.table.SortOrder.Descending));}}if(s.length>0&&this.getBinding("rows")){this.getBinding("rows").sort(s);}this.refreshRows();};T.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this.clearSelection();}else{this.selectAll();}if(!!sap.ui.Device.browser.internet_explorer){this.$("selall").focus();}};T.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var d=this.getColumns();q.each(d,function(i,o){o._restoreAppDefaults();});};T.prototype._setBusy=function(p){var B,i,s;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}B=this.getBinding("rows");if(!B){return;}if(p){if(p.contexts&&p.contexts.length!==undefined){s=false;for(i=0;i<p.contexts.length;i++){if(p.contexts[i]===undefined){s=true;break;}}}if(s||B.isInitial()||B._bInitial||(p.requestedLength!==p.receivedLength&&B.getLength()>0&&p.receivedLength!==B.getLength())){this.setBusy(true);}}else{this.setBusy(false);}};T.prototype.setColumnHeaderVisible=function(d){this.setProperty("columnHeaderVisible",d);this._iLastSelectedDataRow=this._getHeaderRowCount();};return T;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TreeTable')){jQuery.sap.declare('sap.ui.table.TreeTable');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.model.odata.ODataTreeBindingAdapter');sap.ui.define("sap/ui/table/TreeTable",['jquery.sap.global','./Table','sap/ui/model/odata/ODataTreeBindingAdapter','./library'],function(q,T,O,a){"use strict";var b=T.extend("sap.ui.table.TreeTable",{metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}}});b.prototype.init=function(){T.prototype.init.apply(this,arguments);this._iLastFixedColIndex=0;if(sap.ui.getCore().getConfiguration().getTheme()==="sap_bluecrystal"||sap.ui.getCore().getConfiguration().getTheme()==="sap_hcb"){q.sap.require("sap.ui.core.IconPool");sap.ui.core.IconPool.insertFontFaceStyle();}};b.prototype.bindRows=function(B,t,s,f){var p,o,S,f;if(typeof B=="string"){p=arguments[0];o=arguments[1];S=arguments[2];f=arguments[3];B={path:p,sorter:S,filters:f,template:o};}if(typeof B==="object"){B.parameters=B.parameters||{};B.parameters.rootLevel=this.getRootLevel();B.parameters.collapseRecursive=this.getCollapseRecursive();B.parameters.numberOfExpandedLevels=B.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0);B.parameters.rootNodeID=B.parameters.rootNodeID;}return this.bindAggregation("rows",B);};b.prototype.refreshRows=function(r){this._bBusyIndicatorAllowed=true;var B=this.getBinding("rows");if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}this._bRefreshing=true;this._onBindingChange(r);this._updateBindingContexts(true);this._bRefreshing=false;};b.prototype.setFixedRowCount=function(r){q.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};b.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);this.$().find("[role=grid]").attr("role","treegrid");};b.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return sap.ui.core.Element.prototype.isTreeBinding.apply(this,arguments);};b.prototype.getBinding=function(n){n=n||"rows";var B=sap.ui.core.Element.prototype.getBinding.call(this,n);if(B&&this.isTreeBinding(n)&&n==="rows"&&!B.getLength){if(B instanceof sap.ui.model.ClientTreeBinding||B.getModel()instanceof sap.ui.model.odata.ODataModel){var t=this;q.extend(B,{_init:function(e){this._bExpandFirstLevel=e;this.mContextInfo={};this._initContexts();if(e&&!this._bFirstLevelExpanded){this._expandFirstLevel();}},_initContexts:function(s){this.aContexts=this.getRootContexts();for(var i=0,l=this.aContexts.length;i<l;i++){var o=this._getContextInfo(this.aContexts[i]);this._setContextInfo({oContext:this.aContexts[i],iLevel:0,bExpanded:o?o.bExpanded:false});}if(this._bExpandFirstLevel&&!this._bFirstLevelExpanded){this._expandFirstLevel(s);}},_expandFirstLevel:function(s){var t=this;if(this.aContexts&&this.aContexts.length>0){q.each(this.aContexts.slice(),function(i,c){if(!s){t._loadChildContexts(c);}t._getContextInfo(c).bExpanded=true;});this._bFirstLevelExpanded=true;}},_fnFireFilter:B._fireFilter,_fireFilter:function(){this._fnFireFilter.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_fnFireChange:B._fireChange,_fireChange:function(){this._fnFireChange.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_restoreContexts:function(c){var t=this;var N=[];q.each(c.slice(),function(i,C){var o=t._getContextInfo(C);if(o&&o.bExpanded){N.push.apply(N,t._loadChildContexts(C));}});if(N.length>0){this._restoreContexts(N);}},_loadChildContexts:function(c){var C=this._getContextInfo(c);var I=q.inArray(c,this.aContexts);var N=this.getNodeContexts(c);for(var i=0,l=N.length;i<l;i++){this.aContexts.splice(I+i+1,0,N[i]);var o=this._getContextInfo(N[i]);this._setContextInfo({oParentContext:c,oContext:N[i],iLevel:C.iLevel+1,bExpanded:o?o.bExpanded:false});}return N;},_getContextInfo:function(c){return c?this.mContextInfo[c.getPath()]:undefined;},_setContextInfo:function(d){if(d&&d.oContext){this.mContextInfo[d.oContext.getPath()]=d;}},getLength:function(){return this.aContexts?this.aContexts.length:0;},getContexts:function(s,l){return this.aContexts.slice(s,s+l);},getContextByIndex:function(r){return this.aContexts[r];},getLevel:function(c){var C=this._getContextInfo(c);return C?C.iLevel:-1;},isExpanded:function(r){var c=this.getContextByIndex(r);var C=this._getContextInfo(c);return C?C.bExpanded:false;},expandContext:function(c){var C=this._getContextInfo(c);if(C&&!C.bExpanded){this.storeSelection();this._loadChildContexts(c);C.bExpanded=true;this._fireChange();this.restoreSelection();}},expand:function(r){this.expandContext(this.getContextByIndex(r));},collapseContext:function(c,s){var C=this._getContextInfo(c);if(C&&C.bExpanded){this.storeSelection();for(var i=this.aContexts.length-1;i>0;i--){if(this._getContextInfo(this.aContexts[i]).oParentContext===c){this.aContexts.splice(i,1);}}C.bExpanded=false;if(!s){this._fireChange();}this.restoreSelection();}},collapse:function(r){this.collapseContext(this.getContextByIndex(r));},collapseToLevel:function(l){if(!l||l<0){l=0;}var c=this.aContexts.slice();for(var i=c.length-1;i>=0;i--){var C=this.getLevel(c[i]);if(C!=-1&&C>=l){this.collapseContext(c[i],true);}}this._fireChange();},toggleContext:function(c){var C=this._getContextInfo(c);if(C){if(C.bExpanded){this.collapseContext(c);}else{this.expandContext(c);}}},toggleIndex:function(r){this.toggleContext(this.getContextByIndex(r));},storeSelection:function(){var s=t.getSelectedIndices();var S=[];q.each(s,function(i,v){S.push(t.getContextByIndex(v));});this._aSelectedContexts=S;},restoreSelection:function(){t.clearSelection();var _=this._aSelectedContexts;q.each(this.aContexts,function(i,c){if(q.inArray(c,_)>=0){t.addSelectionInterval(i,i);}});this._aSelectedContexts=undefined;},attachSelectionChanged:function(){return undefined;},attachSort:function(){},detachSort:function(){}});B._init(this.getExpandFirstLevel());}else{O.apply(B);}}return B;};b.prototype._updateTableContent=function(){T.prototype._updateTableContent.apply(this,arguments);if(!this.getUseGroupMode()){return;}var B=this.getBinding("rows"),f=this.getFirstVisibleRow(),c=this.getVisibleRowCount(),r=this.getRows();for(var R=0;R<c;R++){var F="";if(this.getFixedColumnCount()>0){F="-fixed";}var C=this.getContextByIndex(f+R),$=q.sap.byId(r[R].getId()+F),d=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.hasChildren&&B.hasChildren(C)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var s=B.isExpanded(f+R)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";d.html("<div class=\"sapUiTableGroupIcon "+s+"\" tabindex=\"-1\">"+this.getModel().getProperty(this.getGroupHeaderProperty(),C)+"</div>");d.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");if(C){$.removeClass("sapUiTableRowHidden");}d.html("");d.removeClass("sapUiTableGroupHeader");}}};b.prototype._updateTableCell=function(c,C,t,A){var B=this.getBinding("rows");if(B){var l=0,i=false;if(B.getLevel){l=B.getLevel(C);i=B.isExpanded(A);}else if(B.findNode){var n=B.findNode(A);l=n?n.level:0;i=n&&n.nodeState?n.nodeState.expanded:false;}var $;if(this.getFixedColumnCount()>0){$=c.getParent().$("fixed");}else{$=c.getParent().$();}var d=$.find(".sapUiTableTreeIcon");var s="sapUiTableTreeIconLeaf";if(!this.getUseGroupMode()){d.css("marginLeft",l*17);}if(B.hasChildren&&B.hasChildren(C)){s=i?"sapUiTableTreeIconNodeOpen":"sapUiTableTreeIconNodeClosed";$.attr('aria-expanded',i);var N=i?this._oResBundle.getText("TBL_COLLAPSE"):this._oResBundle.getText("TBL_EXPAND");d.attr('title',N);}else{$.attr('aria-expanded',false);d.attr('aria-label',this._oResBundle.getText("TBL_LEAF"));}d.removeClass("sapUiTableTreeIconLeaf sapUiTableTreeIconNodeOpen sapUiTableTreeIconNodeClosed").addClass(s);$.attr("data-sap-ui-level",l);$.attr('aria-level',l+1);}};b.prototype.onclick=function(e){if(q(e.target).hasClass("sapUiTableGroupIcon")){this._onGroupSelect(e);}else if(q(e.target).hasClass("sapUiTableTreeIcon")){this._onNodeSelect(e);}else{if(T.prototype.onclick){T.prototype.onclick.apply(this,arguments);}}};b.prototype.onsapselect=function(e){if(q(e.target).hasClass("sapUiTableTreeIcon")){this._onNodeSelect(e);}else{if(T.prototype.onsapselect){T.prototype.onsapselect.apply(this,arguments);}}};b.prototype.onkeydown=function(e){T.prototype.onkeydown.apply(this,arguments);var t=q(e.target),$=t.closest('td');if(e.keyCode==q.sap.KeyCodes.TAB&&this._bActionMode&&$.find('.sapUiTableTreeIcon').length>0){if(t.hasClass('sapUiTableTreeIcon')){if(!t.hasClass("sapUiTableTreeIconLeaf")){$.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();}}else{$.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();}e.preventDefault();}};b.prototype._onNodeSelect=function(e){var $=q(e.target).parents("tr");if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var c=this.getContextByIndex(r);this.fireToggleOpenState({rowIndex:r,rowContext:c,expanded:!this.getBinding().isExpanded(r)});this.getBinding("rows").toggleIndex(r);}e.preventDefault();e.stopPropagation();};b.prototype._onGroupSelect=function(e){var $=q(e.target).parents("[data-sap-ui-rowindex]");if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var c=this.getContextByIndex(r);if(this.getBinding().isExpanded(r)){q(e.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");}else{q(e.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");}this.fireToggleOpenState({rowIndex:r,rowContext:c,expanded:!this.getBinding().isExpanded(r)});this.getBinding("rows").toggleIndex(r);}e.preventDefault();e.stopPropagation();};b.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}return this;};b.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}return this;};b.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};b.prototype.expandToLevel=function(l){var B=this.getBinding("rows");if(B&&B.expandToLevel){B.expandToLevel(l);}return this;};b.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};b.prototype.isIndexSelected=function(r){var B=this.getBinding("rows");if(B&&B.findNode){var n=B.findNode(r);return n&&n.nodeState&&n.nodeState.selected;}else{return T.prototype.isIndexSelected.call(this,r);}};b.prototype.setSelectedIndex=function(r){if(r===-1){this.clearSelection();}var B=this.getBinding("rows");if(B&&B.findNode&&B.setNodeSelection){B.setSelectedIndex(r);}else{T.prototype.setSelectedIndex.call(this,r);}return this;};b.prototype.getSelectedIndices=function(){var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedIndices){return B.getSelectedIndices();}else{return T.prototype.getSelectedIndices.call(this);}};b.prototype.setSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.setSelectionInterval){B.setSelectionInterval(f,t);}else{T.prototype.setSelectionInterval.call(this,f,t);}return this;};b.prototype.addSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.addSelectionInterval){B.addSelectionInterval(f,t);}else{T.prototype.addSelectionInterval.call(this,f,t);}return this;};b.prototype.removeSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.removeSelectionInterval){B.removeSelectionInterval(f,t);}else{T.prototype.removeSelectionInterval.call(this,f,t);}return this;};b.prototype.selectAll=function(){var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B.selectAll){B.selectAll();this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}else{T.prototype.selectAll.call(this);}return this;};b.prototype.getSelectedIndex=function(){var B=this.getBinding("rows");if(B&&B.findNode){return B.getSelectedIndex();}else{return T.prototype.getSelectedIndex.call(this);}};b.prototype.clearSelection=function(){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}else{T.prototype.clearSelection.call(this);}return this;};b.prototype._enterActionMode=function(t){var $=t.eq(0);T.prototype._enterActionMode.apply(this,arguments);if(t.length>0&&$.hasClass("sapUiTableTreeIcon")&&!$.hasClass("sapUiTableTreeIconLeaf")){$.attr("tabindex",0).focus();this._bActionMode=true;}};b.prototype._leaveActionMode=function(e){T.prototype._leaveActionMode.apply(this,arguments);this.$().find(".sapUiTableTreeIcon").attr("tabindex",-1);};b.prototype.getContextByIndex=function(r){var B=this.getBinding("rows");if(B){return B.getContextByIndex(r);}};b.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var B=this.getBinding("rows");if(B){if(B.setRootLevel){B.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};b.prototype.setCollapseRecursive=function(c){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(c);}}this.setProperty("collapseRecursive",!!c,true);return this;};return b;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumn')){jQuery.sap.declare('sap.ui.table.AnalyticalColumn');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/AnalyticalColumn",['jquery.sap.global','./Column','./library'],function(q,C,l){"use strict";var A=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});A.prototype.init=function(){C.prototype.init.apply(this,arguments);this._bSkipUpdateAI=false;};A._DEFAULT_FILTERTYPES={"Time":new sap.ui.model.type.Time({UTC:true}),"DateTime":new sap.ui.model.type.DateTime({UTC:true}),"Float":new sap.ui.model.type.Float(),"Integer":new sap.ui.model.type.Integer(),"Boolean":new sap.ui.model.type.Boolean()};A.prototype._createMenu=function(){q.sap.require("sap.ui.table.AnalyticalColumnMenu");return new sap.ui.table.AnalyticalColumnMenu(this.getId()+"-menu");};A.prototype.setGrouped=function(g){var p=this.getParent();var t=this;if(p&&p instanceof sap.ui.table.AnalyticalTable){if(g){p._addGroupedColumn(this.getId());}else{p._aGroupedColumns=q.grep(p._aGroupedColumns,function(v){return v!=t.getId();});}}var r=this.setProperty("grouped",g);this._updateTableColumnDetails();this._updateTableAnalyticalInfo(true);return r;};A.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};A.prototype.setVisible=function(v){C.prototype.setVisible.apply(this,arguments);this._updateTableColumnDetails();this._updateTableAnalyticalInfo();return this;};A.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){var b=p.getBinding("rows");if(b){this._oBindingLabel=sap.ui.table.TableHelper.createLabel({text:b.getPropertyLabel(this.getLeadingProperty())});}}}L=this._oBindingLabel;}return L;};A.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(P&&P instanceof sap.ui.table.AnalyticalTable){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getFilterablePropertyNames())>-1){p=L;}}}return p;};A.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(P&&P instanceof sap.ui.table.AnalyticalTable){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getSortablePropertyNames())>-1){p=L;}}}return p;};A.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){var b=p.getBinding("rows");var L=this.getLeadingProperty(),P=b&&b.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=A._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=A._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=A._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=A._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=A._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};A.prototype._afterSort=function(){this._updateTableAnalyticalInfo();};A.prototype._updateTableAnalyticalInfo=function(s){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){p.updateAnalyticalInfo(s);}};A.prototype._updateTableColumnDetails=function(){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){p._updateTableColumnDetails();}};A.prototype.shouldRender=function(){if(!this.getVisible()){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};A.prototype.getTooltip_AsString=function(){var p=this.getParent();if(p&&p instanceof sap.ui.table.AnalyticalTable){var b=p.getBinding("rows");if(b&&this.getLeadingProperty()){return b.getPropertyQuickInfo(this.getLeadingProperty());}}return sap.ui.core.Element.prototype.getTooltip_AsString.apply(this);};return A;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenu')){jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenu');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/AnalyticalColumnMenu",['jquery.sap.global','./ColumnMenu','./library'],function(q,C,l){"use strict";var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{metadata:{library:"sap.ui.table"}});A.prototype.init=function(){C.prototype.init.apply(this);};A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findDimensionByPropertyName(c.getLeadingProperty())&&q.inArray(c.getLeadingProperty(),b.getSortablePropertyNames())>-1&&q.inArray(c.getLeadingProperty(),b.getFilterablePropertyNames())>-1){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,q.proxy(function(e){var m=e.getSource(),g=c.getGrouped();c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:sap.ui.table.GroupEventType.group});m.setIcon(!g?"sap-icon://accept":null);},this));this.addItem(this._oGroupIcon);}};A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);},this));this.addItem(this._oSumItem);}};A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setVisible(!c._isLastGroupableLeft);};return A;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalTable')){jQuery.sap.declare('sap.ui.table.AnalyticalTable');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.model.analytics.TreeBindingAdapter');sap.ui.define("sap/ui/table/AnalyticalTable",['jquery.sap.global','sap/ui/model/analytics/TreeBindingAdapter','./AnalyticalColumn','./Table','./library'],function(q,T,A,a,b){"use strict";var c=a.extend("sap.ui.table.AnalyticalTable",{metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}}}});c.prototype.init=function(){a.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.attachBrowserEvent("contextmenu",this._onContextMenu);this.setSelectionMode(sap.ui.table.SelectionMode.MultiToggle);this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];if(sap.ui.getCore().getConfiguration().getTheme()==="sap_bluecrystal"){q.sap.require("sap.ui.core.IconPool");sap.ui.core.IconPool.insertFontFaceStyle();}this._bBindingAttachedListener=false;};c.prototype.setFixedRowCount=function(){q.sap.log.error("The property fixedRowCount is not supported by the AnalyticalTable and must not be set!");return this;};c.prototype.setFixedBottomRowCount=function(){q.sap.log.error("The property fixedBottomRowCount is managed by the AnalyticalTable and must not be set!");return this;};c.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);this.$().find("[role=grid]").attr("role","treegrid");};c.prototype.setDirty=function(d){q.sap.log.error("The property \"dirty\" is deprecated. Please use \"showOverlay\".");this.setProperty("dirty",d,true);this.setShowOverlay(this.getDirty());return this;};c.prototype.getModel=function(m,n){var m=a.prototype.getModel.apply(this,arguments);if(m&&sap.ui.model.odata&&m instanceof sap.ui.model.odata.ODataModel){q.sap.require("sap.ui.model.analytics.ODataModelAdapter");sap.ui.model.analytics.ODataModelAdapter.apply(m);}return m;};c.prototype._bindAggregation=function(n,p,t,s,f){if(n==="rows"){this.setProperty("firstVisibleRow",0,true);}return a.prototype._bindAggregation.apply(this,arguments);};c.prototype._onBindingChange=function(e){a.prototype._onBindingChange.apply(this,arguments);var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r!=="sort"){this._invalidateColumnMenus();}};c.prototype.bindRows=function(B){var p,t,s,f;if(typeof B=="string"){p=arguments[0];t=arguments[1];s=arguments[2];f=arguments[3];B={path:p,sorter:s,filters:f};if(t instanceof sap.ui.base.ManagedObject){B.template=t;}else if(typeof t==="function"){B.factory=t;}}var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){B.sorter=B.sorter||[];B.sorter.push(new sap.ui.model.Sorter(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===sap.ui.table.SortOrder.Descending));}}B.parameters=B.parameters||{};B.parameters.analyticalInfo=this._getColumnInformation();B.parameters.sumOnTop=this.getSumOnTop();B.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();var r=this.bindAggregation("rows",B);this._bSupressRefresh=true;this._updateColumns();this._bSupressRefresh=false;this._bBindingAttachedListener=false;return r;};c.prototype._setSuppressRefresh=function(s){this._bSupressRefresh=s;return this;};c.prototype.updateRows=function(r){this._attachBindingListener();a.prototype.updateRows.apply(this,arguments);};c.prototype.refreshRows=function(r){this._attachBindingListener();a.prototype.refreshRows.apply(this,arguments);};c.prototype._attachBindingListener=function(){if(!this._bBindingAttachedListener){this._bBindingAttachedListener=true;var B=this.getBinding("rows");var t=this;if(B&&!B.hasListeners("contextChange")){B.attachContextChange(function(e){if(!t._oSelection){return;}var p=e.getParameters(),s=p.type,i=p.index,l=p.length;if(s==="remove"){t._oSelection.sliceSelectionInterval(i,Math.max(i,i+l-1));}else{t._oSelection.moveSelectionInterval(i,l);}});}}};c.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(q.inArray(o.getId(),this._aGroupedColumns)>-1){continue;}if(!o instanceof A){q.sap.log.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};c.prototype._updateTableContent=function(){a.prototype._updateTableContent.apply(this,arguments);var B=this.getBinding("rows"),f=this.getFirstVisibleRow(),F=this.getFixedBottomRowCount(),C=this.getVisibleRowCount(),d=this.getColumns();if(!B){return;}var e=this._getFirstMeasureColumnIndex(),m;if(e>-1){var h=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;var $=this.$().find(".sapUiTableCtrlFirstCol > th");if(h){$=$.not(":nth-child(1)");}var o=$.get(0).getBoundingClientRect().left;var g=$.get(this._getFirstMeasureColumnIndex());if(g){var M=32+g.getBoundingClientRect().left-o;m=M+"px";}else{m="none";}}else{m="none";}var r=this.getRows();for(var R=0,l=Math.min(C,r.length);R<l;R++){var I=R>(C-F-1)&&B.getLength()>C,j=I?(B.getLength()-1-(C-1-R)):f+R,k=this.getContextInfoByIndex(j),n=r[R],p=n.$(),s=n.$("fixed"),t=this.$().find("div[data-sap-ui-rowindex="+p.attr("data-sap-ui-rowindex")+"]"),L=k?k.level:0;if(!k||!k.context){p.removeAttr("data-sap-ui-level");p.removeAttr('aria-level');p.removeAttr('aria-expanded');p.removeClass("sapUiTableGroupHeader");p.removeClass("sapUiAnalyticalTableSum");p.removeClass("sapUiAnalyticalTableDummy");s.removeAttr("data-sap-ui-level");s.removeAttr('aria-level');s.removeAttr('aria-expanded');s.removeClass("sapUiTableGroupHeader");t.removeClass("sapUiTableGroupHeader");t.html("");t.removeAttr("data-sap-ui-level");t.removeClass("sapUiAnalyticalTableSum");t.removeClass("sapUiAnalyticalTableDummy");if(k&&!k.context){p.addClass("sapUiAnalyticalTableDummy");t.addClass("sapUiAnalyticalTableDummy");t.html('<div class="sapUiAnalyticalTableLoading">Loading...</div>');}continue;}if(B.indexHasChildren&&B.indexHasChildren(j)){p.addClass("sapUiTableGroupHeader");s.addClass("sapUiTableGroupHeader");var u=k.expanded?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";p.attr('aria-expanded',k.expanded);s.attr('aria-expanded',k.expanded);var G=B.getGroupName(k.context,k.level);t.html("<div class=\"sapUiTableGroupIcon "+u+"\" tabindex=\"-1\" title=\""+G+"\" style=\"max-width:"+m+"\">"+G+"</div>");if(k.expanded&&!this.getSumOnTop()){p.addClass("sapUiTableRowHidden");t.addClass("sapUiTableRowHidden");}p.removeClass("sapUiAnalyticalTableSum");t.removeClass("sapUiAnalyticalTableSum");p.removeClass("sapUiAnalyticalTableDummy");t.removeClass("sapUiAnalyticalTableDummy");t.addClass("sapUiTableGroupHeader").removeAttr("title");}else{p.attr('aria-expanded',false);p.removeClass("sapUiTableGroupHeader");p.removeClass("sapUiTableRowHidden");p.removeClass("sapUiAnalyticalTableSum");p.removeClass("sapUiAnalyticalTableDummy");s.attr('aria-expanded',false);s.removeClass("sapUiTableGroupHeader");t.html("");t.removeClass("sapUiTableGroupHeader");t.removeClass("sapUiAnalyticalTableDummy");t.removeClass("sapUiAnalyticalTableSum");if(k.sum&&k.context&&k.context.getObject()){p.addClass("sapUiAnalyticalTableSum");t.addClass("sapUiAnalyticalTableSum");}}p.attr("data-sap-ui-level",L);s.attr("data-sap-ui-level",L);t.attr("data-sap-ui-level",L);p.attr('aria-level',L+1);s.attr('aria-level',L+1);var v=n.getCells();for(var i=0,w=v.length;i<w;i++){var x=v[i].data("sap-ui-colindex");var y=d[x];var z=q(v[i].$().closest("td"));if(B.isMeasure(y.getLeadingProperty())){if(!k.sum||y.getSummed()){z.removeClass("sapUiTableCellHidden");}else{z.addClass("sapUiTableCellHidden");}}}}};c.prototype.onclick=function(e){if(q(e.target).hasClass("sapUiTableGroupIcon")){this._onNodeSelect(e);}else if(q(e.target).hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else{if(a.prototype.onclick){a.prototype.onclick.apply(this,arguments);}}};c.prototype.onsapselect=function(e){if(q(e.target).hasClass("sapUiTableGroupIcon")){this._onNodeSelect(e);}else if(q(e.target).hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else{var t=q(e.target),$=t.closest('div.sapUiTableRowHdr');if($.hasClass('sapUiTableGroupHeader')&&$.hasClass('sapUiTableRowHdr')){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");B.toggleIndex(r);return;}if(a.prototype.onsapselect){a.prototype.onsapselect.apply(this,arguments);}}};c.prototype._onNodeSelect=function(e){var $=q(e.target).parent();if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");B.toggleIndex(r);}e.preventDefault();e.stopPropagation();};c.prototype._onContextMenu=function(e){if(q(e.target).closest('tr').hasClass('sapUiTableGroupHeader')||q(e.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length>0){this._iGroupedLevel=q(e.target).closest('[data-sap-ui-level]').data('sap-ui-level');var m=this._getGroupHeaderMenu();var d=sap.ui.core.Popup.Dock;m.open(false,e.target,d.LeftTop,d.LeftTop,document,(e.pageX-2)+" "+(e.pageY-2));e.preventDefault();e.stopPropagation();return;}return true;};c.prototype._getGroupHeaderMenu=function(){var t=this;function g(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var o=t.getColumns().filter(function(C){if(t._aGroupedColumns[i]==C.getId()){return true;}})[0];return{column:o,index:i};}else{return undefined;}}if(!this._oGroupHeaderMenu){this._oGroupHeaderMenu=new sap.ui.unified.Menu();this._oGroupHeaderMenuVisibilityItem=new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_SHOW_COLUMN"),select:function(){var G=g();if(G){var C=G.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?sap.ui.table.GroupEventType.showGroupedColumn:sap.ui.table.GroupEventType.hideGroupedColumn)});}}});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_UNGROUP"),select:function(){var d=t.getColumns(),f=0,l=-1,u=-1,C;for(var i=0;i<d.length;i++){C=d[i];if(C.getGrouped()){f++;if(f==t._iGroupedLevel){C._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);C.setGrouped(false);C._bSkipUpdateAI=false;u=i;t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:sap.ui.table.GroupEventType.ungroup});}else{l=i;}}}if(l>-1&&u>-1&&u<l){var U=d[u];var h=U.getHeaderSpan();if(q.isArray(h)){h=h[0];}var r=[];for(var i=u;i<u+h;i++){r.push(d[i]);}q.each(r,function(I,C){t.removeColumn(C);t.insertColumn(C,l);});}t._updateTableColumnDetails();t.updateAnalyticalInfo();}}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_UNGROUP_ALL"),select:function(){var d=t.getColumns();for(var i=0;i<d.length;i++){d[i]._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);d[i].setGrouped(false);d[i]._bSkipUpdateAI=false;}t._bSupressRefresh=true;t._updateTableColumnDetails();t.updateAnalyticalInfo();t._bSupressRefresh=false;t.fireGroup({column:undefined,groupedColumns:[],type:sap.ui.table.GroupEventType.ungroupAll});}}));this._oGroupHeaderMoveUpItem=new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_MOVE_UP"),select:function(){var G=g();if(G){var C=G.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:sap.ui.table.GroupEventType.moveUp});}}},icon:"sap-icon://arrow-top"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);this._oGroupHeaderMoveDownItem=new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_MOVE_DOWN"),select:function(){var G=g();if(G){var C=G.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:sap.ui.table.GroupEventType.moveDown});}}},icon:"sap-icon://arrow-bottom"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_SORT_ASC"),select:function(){var G=g();if(G){var C=G.column;C.sort(false);}},icon:"sap-icon://up"}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_SORT_DESC"),select:function(){var G=g();if(G){var C=G.column;C.sort(true);}},icon:"sap-icon://down"}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseAll(t._iGroupedLevel);t._oSelection.clearSelection();}}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseAll();t._oSelection.clearSelection();}}));}var G=g();if(G){var C=G.column;if(C.getShowIfGrouped()){this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));}else{this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));}this._oGroupHeaderMoveUpItem.setEnabled(G.index>0);this._oGroupHeaderMoveDownItem.setEnabled(G.index<this._aGroupedColumns.length-1);}else{this._oGroupHeaderMoveUpItem.setEnabled(true);this._oGroupHeaderMoveDownItem.setEnabled(true);}return this._oGroupHeaderMenu;};c.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}};c.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}};c.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};c.prototype.selectAll=function(){a.prototype.selectAll.apply(this);var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){var l=(B.getLength()||0);for(var i=0;i<l;i++){var C=this.getContextInfoByIndex(i);if(C.sum||B.indexHasChildren(i)){this._oSelection.removeSelectionInterval(i,i);}}this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};c.prototype.getContextInfoByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContextInfo(i):null;};c.prototype._onColumnMoved=function(e){a.prototype._onColumnMoved.apply(this,arguments);this.updateAnalyticalInfo();};c.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}return a.prototype.addColumn.call(this,o,s);};c.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}return a.prototype.insertColumn.call(this,o,i,s);};c.prototype.removeColumn=function(C,s){var o=a.prototype.removeColumn.apply(this,arguments);if(o){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){return v!=o.getId();});}return o;};c.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];return a.prototype.removeColumn.apply(this,arguments);};c.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};c.prototype._updateColumns=function(){this._updateTableColumnDetails();this.updateAnalyticalInfo();};c.prototype.updateAnalyticalInfo=function(s){var B=this.getBinding("rows");if(B){var C=this._getColumnInformation();B.updateAnalyticalInfo(C);this._updateTotalRow(C,s);if(s||this._bSupressRefresh){return;}this.refreshRows();}};c.prototype._updateTotalRow=function(C,s){var h=false;for(var i=0,l=C?C.length:0;i<l;i++){if(C[i].visible&&C[i].total){h=true;break;}}var B=this.getBinding("rows");if(B&&(!B.providesGrandTotal()||!B.hasTotaledMeasures())){h=false;}var f=this.getFixedBottomRowCount();if(h){if(f!==1){this.setProperty("fixedBottomRowCount",1,s);}}else{if(f!==0){this.setProperty("fixedBottomRowCount",0,s);}}};c.prototype._updateTableColumnDetails=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult();if(r){var C=this.getColumns(),g=[],u=[],d=[],D={},e,f;for(var i=0;i<C.length;i++){e=C[i];e._isLastGroupableLeft=false;e._bLastGroupAndGrouped=false;e._bDependendGrouped=false;if(!e.getVisible()){continue;}var l=e.getLeadingProperty();f=r.findDimensionByPropertyName(l);if(f){var h=f.getName();if(!D[h]){D[h]={dimension:f,columns:[e]};}else{D[h].columns.push(e);}if(e.getGrouped()&&q.inArray(h,g)==-1){g.push(h);}if(q.inArray(h,d)==-1){d.push(h);}}}u=q.grep(d,function(s){return(q.inArray(s,g)==-1);});if(g.length>0){q.each(g,function(i,s){q.each(D[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(g.length==d.length){f=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var G=D[f.getName()].columns;q.each(G,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(D[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};c.prototype._getFirstMeasureColumnIndex=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var o=C[i],l=o.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};c.prototype.getTotalSize=function(){var B=this.getBinding("rows");if(B){return B.getTotalSize();}return 0;};c.prototype._hasData=function(){var B=this.getBinding("rows"),l=B&&(B.getLength()||0),h=B&&(B.providesGrandTotal()&&B.hasTotaledMeasures());if(!B||(h&&l<2)||(!h&&l===0)){return false;}return true;};c.prototype._onPersoApplied=function(){a.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateTableColumnDetails();this.updateAnalyticalInfo();};c.prototype._addGroupedColumn=function(C){if(q.inArray(C,this._aGroupedColumns)<0){this._aGroupedColumns.push(C);}};c.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};c.prototype._getSelectableRowCount=function(){var B=this.getBinding("rows");if(B){var C=B.getLength()||0;for(var i=0,l=C;i<l;i++){var o=this.getContextInfoByIndex(i);if(o.sum||B.indexHasChildren(i)){C--;}}return C;}else{return 0;}};c.prototype._isRowSelectable=function(r){return!this.getBinding("rows").indexHasChildren(r);};return c;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.DataTable')){jQuery.sap.declare('sap.ui.table.DataTable');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/DataTable",['jquery.sap.global','./TreeTable','./Table','./library'],function(q,T,a,l){"use strict";var D=T.extend("sap.ui.table.DataTable",{metadata:{deprecated:true,library:"sap.ui.table",properties:{expandedVisibleRowCount:{type:"int",defaultValue:null},expanded:{type:"boolean",defaultValue:false},hierarchical:{type:"boolean",defaultValue:false}},events:{rowSelect:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"}}}}}});D.prototype.init=function(){T.prototype.init.apply(this,arguments);this._bInheritEditableToControls=true;this.setEditable(false);this.setSelectionBehavior(sap.ui.table.SelectionBehavior.Row);this.attachRowSelectionChange(function(e){this.fireRowSelect(e.mParameters);});this._iLastFixedColIndex=-1;};D.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return this.getHierarchical();}return sap.ui.core.Element.prototype.isTreeBinding.apply(this,arguments);};D.prototype.setHierarchical=function(h){this.setProperty("hierarchical",h);this._iLastFixedColIndex=h?0:-1;};D.prototype.setVisibleRowCount=function(r){this._iVisibleRowCount=r;if(!this.getExpanded()){sap.ui.table.Table.prototype.setVisibleRowCount.apply(this,arguments);}};D.prototype.setExpandedVisibleRowCount=function(r){this.setProperty("expandedVisibleRowCount",r,true);if(this.getExpanded()){sap.ui.table.Table.prototype.setVisibleRowCount.apply(this,arguments);}};D.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);if(this.getExpandedVisibleRowCount()>0){var r=e?this.getExpandedVisibleRowCount():this._iVisibleRowCount;sap.ui.table.Table.prototype.setVisibleRowCount.call(this,r);}};D.prototype.getContextByIndex=function(r){return a.prototype.getContextByIndex.call(this,r);};return D;},true);};
