// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.commons.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.commons.AccordionRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Accordion
jQuery.sap.declare('sap.ui.commons.AccordionRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/AccordionRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @namespace
	 */
	var AccordionRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oAccordion An object representation of the control that should be rendered
	 */
	AccordionRenderer.render = function(oRenderManager, oAccordion){
	
		// convenience variable
		var rm = oRenderManager;
	
	
		// write the HTML into the render manager
		rm.write("<div");
		rm.writeControlData(oAccordion);
	
		if ( sap.ui.getCore().getConfiguration().getAccessibility()) {
			rm.writeAttribute('role', 'tablist');
		}
	
		rm.addClass("sapUiAcd");
		rm.addStyle("width", oAccordion.getWidth());
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">"); // SPAN element
	
		rm.write("<div id='" + oAccordion.getId() + "-dropTarget" + "' style='width:" + oAccordion.getWidth() + "' tabIndex='-1' class='sapUiAcd-droptarget'></div>");
	
		var aSections = oAccordion.getSections();
		var aDefaultSections = oAccordion.getOpenedSectionsId().split(",");
	
		for (var i = 0;i < aSections.length;i++) {
	
			// Open the section if the section is part of the default opened section
			if (oAccordion.bInitialRendering) {
	
				if (jQuery.inArray(aSections[i].getId(),aDefaultSections) != -1) {
					aSections[i]._setCollapsed(false);
				} else {
					aSections[i]._setCollapsed(true);
				}
	
		   }
	
		   AccordionRenderer.renderSection(rm, aSections[i]);
	
		}
	
		rm.write('<SPAN id="' + oAccordion.getId() + '-Descr" style="visibility: hidden; display: none;">');
		rm.write(oAccordion.rb.getText("ACCORDION_DSC"));
		rm.write('</SPAN>');
	
		rm.write("</div>");
	
		oAccordion.bInitialRendering = false;
	
	};
	
	
	AccordionRenderer.renderSection = function(oRenderManager, oControl) {
	
		var rm = oRenderManager;
		var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
	
		var heightSet = sap.ui.commons.AccordionSection._isSizeSet(oControl.getMaxHeight());
		var widthSet = sap.ui.commons.AccordionSection._isSizeSet(oControl.getParent().getWidth());
	
		// root element and classes
		rm.write("<div");
		rm.writeElementData(oControl);
		rm.addClass("sapUiAcdSection");
	
		if (oControl.getParent().isLastSection(oControl)) {
			rm.addClass("sapUiAcdSectionLast");
		}
	
		rm.addStyle("width", oControl.getParent().getWidth());
		if (!oControl.getCollapsed()) {
			rm.addStyle("height", oControl.getMaxHeight());
		} else {
			rm.addClass("sapUiAcdSectionColl");
		}
	
		rm.addClass("sapUiAcdSectionArea");
	
		if (!heightSet) {
			rm.addClass("sapUiAcdSectionFlexHeight");
		}
		if (!oControl.getEnabled()) {
			rm.addClass("sapUiAcdSectionDis");
		}
	
		rm.writeClasses();
		rm.writeStyles();
	
		// header
		rm.write("><div class='sapUiAcdSectionHdr'");
		if (oControl.getEnabled()) {
			rm.write(" tabindex='0'");
		}
		rm.writeAttribute("id", oControl.getId() + "-hdr");
		if (accessibility) {
			rm.writeAttribute('role', 'tab');
			rm.writeAttribute("aria-labelledby", oControl.getId() + "-lbl");
			rm.writeAttribute("aria-describedby", oControl.getParent().getId() + "-Descr");
			if (oControl.getEnabled()) {
				if (oControl.getCollapsed()) {
					rm.writeAttribute("aria-expanded", "false");
				} else {
					rm.writeAttribute("aria-expanded", "true");
				}
			}
		}
		rm.write(">");
	
		rm.write("<div ");
		rm.writeAttribute("id", oControl.getId() + "-trgt");
		rm.write(">");
	
		rm.write("<span id='" + oControl.getId() + "-hdrL'>");
	
		if (oControl.getEnabled()) {
			rm.write("<a id='" + oControl.getId() + "-minL' class='sapUiAcdSectionMinArrow' href='javascript:void(0)' title='Collapse/Expand'");
		} else {
			rm.write("<a id='" + oControl.getId() + "-minL' class='sapUiAcdSectionMinArrow sapUiAcdCursorText' href='javascript:void(0)' title='Collapse/Expand'");
		}
	
		rm.write(" tabindex='-1' ");
	
		if (accessibility) {
	
			rm.writeAttribute("aria-labelledby", oControl.getId() + "-lbl");
	
			//Is the section opened --> selected in this case
			if (oControl.getCollapsed()) {
				rm.writeAttribute("aria-selected", "false");
			} else {
				rm.writeAttribute("aria-selected", "true");
			}
			//Disabled --> Unavailable annoucement
			if (oControl.getEnabled()) {
				rm.writeAttribute("aria-disabled", "false");
				if (!!!sap.ui.Device.browser.internet_explorer) {
					rm.writeAttribute("aria-grabbed", "false");
				}
			} else {
				rm.writeAttribute("aria-disabled", "true");
				if (!!!sap.ui.Device.browser.internet_explorer) {
					rm.writeAttribute("aria-grabbed", "");
				}
			}
	
		}
		rm.write("></a>");
	
		// label
		rm.write("<span tabindex='-1' id='" + oControl.getId() + "-lbl' class='sapUiAcdSectionLabel'");
	
		if (oControl.getCollapsed()) {
			rm.writeAttribute("aria-selected", "false");
			rm.addStyle("font-weight", "normal");
			rm.writeStyles();
		} else {
			rm.writeAttribute("aria-selected", "true");
			rm.addStyle("font-weight", "bold");
			rm.writeStyles();
		}
	
		if (accessibility) {
	
			rm.writeAttribute("role", "heading");
	
			if (oControl.getEnabled()) {
				rm.writeAttribute("aria-disabled", "false");
			} else {
				rm.writeAttribute("aria-disabled", "true");
			}
		}
	
		rm.write(">");
	
		rm.writeEscaped(oControl.getTitle());
		rm.write("</span>");
		rm.write("</span>");
	
		rm.write("</div></div>");
	
		// everything below the header is only rendered initially if not collapsed - saves performance and Panel just re-renders later on expand
		if (!oControl.getCollapsed()) {
	
			// Content area
			rm.write("<div class='sapUiAcdSectionCont' tabindex='-1' id='" + oControl.getId() + "-cont'");
			if (heightSet && widthSet) {
				rm.write(" style='position:absolute;'");
			} else {
				rm.write(" style='position:relative;top:0px;'"); // for IE7, when Panel contains relatively positioned elements
			}
	
			if ( sap.ui.getCore().getConfiguration().getAccessibility()) {
				rm.writeAttribute('role', 'tabpanel');
			}
	
			rm.write(">");
	
			// Content (child controls)
			var oControls = oControl.getContent(),
			iLength = oControls.length;
			for (var i = 0;i < iLength;i++) {
				rm.renderControl(oControls[i]);
			}
			rm.write("</div>");
	
		}
		// End of Panel
		rm.write("</div>");
	};

	return AccordionRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/AccordionRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ApplicationHeaderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ApplicationHeader
jQuery.sap.declare('sap.ui.commons.ApplicationHeaderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ApplicationHeaderRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ApplicationHeader renderer.
	 * @namespace
	 */
	var ApplicationHeaderRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oAppHeader an object representation of the control that should be rendered
	 */
	ApplicationHeaderRenderer.render = function(oRenderManager, oAppHeader){

		if (!this.initializationDone) {
			oAppHeader.initControls();
			oAppHeader.initializationDone = true;
		}

		var appHeaderId = oAppHeader.getId();

		//Write the HTML into the render manager
		oRenderManager.write("<header");
		oRenderManager.writeControlData(oAppHeader);
		oRenderManager.addClass("sapUiAppHdr");
		oRenderManager.writeClasses();
		oRenderManager.write(">");

		//Welcome and logoff areas
		oRenderManager.write("<div id=\"" + appHeaderId + "-appHeaderWelcomeLogoffAreas\" class=\"sapUiAppHdrWelcomeLogoffArea sapUiInverted-CTX\">");
		this.renderWelcomeAndLogoffAreas(oRenderManager, oAppHeader);
		oRenderManager.write("</div>"); //End welcome and logout areas

		//Logo area
		oRenderManager.write("<div id=\"" + appHeaderId + "-logoArea\" class=\"sapUiAppHdrLogo\">");
		this.renderLogoArea(oRenderManager,oAppHeader);
		oRenderManager.write("</div>");

		oRenderManager.write("</header>");

	};

	/**
	 * Renders the HTML for the logo area (Logo src and text if any)
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oAppHeader an object representation of the control that should be rendered
	 */
	ApplicationHeaderRenderer.renderLogoArea = function(oRenderManager, oAppHeader){

		//Add the logo, but first set the source to the right path
		var sSrc = oAppHeader.getLogoSrc();
		if (!sSrc) {
			jQuery.sap.require("sap.ui.core.theming.Parameters");
			sSrc = sap.ui.core.theming.Parameters._getThemeImage(); // theme logo
		}
		if (!sSrc) {
			sSrc = sap.ui.resource("sap.ui.commons", "themes/" + sap.ui.getCore().getConfiguration().getTheme() + "/img/applicationheader/SAPLogo.png");
		}

		oAppHeader.oLogo.setSrc(sSrc);
		oRenderManager.renderControl(oAppHeader.oLogo);

		//Insert the logo text if any provided by application
		if (oAppHeader.getLogoText() != "") {
			oAppHeader.oLogoText.setText(oAppHeader.getLogoText());
			oAppHeader.oLogoText.setTooltip(oAppHeader.getLogoText());
			oRenderManager.renderControl(oAppHeader.oLogoText);
		}

	};

	/**
	 * Renders the HTML for the welcome and logoff areas
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oAppHeader an object representation of the control that should be rendered
	 */
	ApplicationHeaderRenderer.renderWelcomeAndLogoffAreas = function(oRenderManager, oAppHeader){

		var appHeaderId = oAppHeader.getId();

		//Check if the Welcome text is requested
		if (oAppHeader.getDisplayWelcome()) {

			var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

			var padding = sap.ui.getCore().getConfiguration().getRTL() ? "padding-left" : "padding-right";

			//Add the user name if provided
			if (oAppHeader.getUserName() != "") {
				oRenderManager.write("<label class=\"sapUiLbl sapUiLblEmph\" style=\"text-align: left;\" id=\"" + appHeaderId + "-welcomeLabel\">" +
									  rb.getText("APPHDR_WELCOME_USER") + ":</label>");
				oRenderManager.write("&nbsp;");
				oRenderManager.write("<label class=\"sapUiLbl\" style=\"text-align: left;", padding, ":15px;\" id=\"", appHeaderId, "-userLabel\">");
				oRenderManager.writeEscaped(oAppHeader.getUserName());
				oRenderManager.write("</label>");
			} else {
				oRenderManager.write("<label class=\"sapUiLbl sapUiLblEmph\" style=\"text-align: left;" + padding + ":15px;\" id=\"" + appHeaderId + "-welcomeLabel\">" +
									  rb.getText("APPHDR_WELCOME") + "</label>");
			}
		}

		//Logout area
		if (oAppHeader.getDisplayLogoff()) {

			//Display the separator only when the welcome area is displayed as well
			if (oAppHeader.getDisplayWelcome()) {
				oRenderManager.write("<span role=\"separator\" class=\"sapUiTbSeparator\"></span>");
			}
			oRenderManager.renderControl(oAppHeader.oLogoffBtn);
		}

	};

	return ApplicationHeaderRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ApplicationHeaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Button
jQuery.sap.declare('sap.ui.commons.ButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ButtonRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.28.17
	 * @namespace
	 */
	var ButtonRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oButton An object representation of the control that should be rendered.
	 */
	ButtonRenderer.render = function(rm, oButton) {
		rm.addClass("sapUiBtn");

		// button is rendered as a "<button>" element
		rm.write("<button type=\"button\""); // otherwise this turns into a submit button in IE8
		rm.writeControlData(oButton);
		if (oButton.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oButton.getTooltip_AsString());
		}

		//styling
		if (oButton.getStyled()) {
			rm.addClass("sapUiBtnS");
		}

		if (oButton.getLite()) {
			rm.addClass("sapUiBtnLite");
		} else {
			rm.addClass("sapUiBtnNorm");
		}

		var sStyle = oButton.getStyle();

		if (sStyle != "" && sStyle != sap.ui.commons.ButtonStyle.Default) {
			rm.addClass("sapUiBtn" + jQuery.sap.escapeHTML(sStyle));
		}

		//ARIA
		rm.writeAccessibilityState(oButton, {
			role: 'button',
			disabled: !oButton.getEnabled()
		});

		if (!oButton.getEnabled()) {
			rm.write(" tabIndex=\"-1\"");
			rm.addClass("sapUiBtnDsbl");
		} else {
			rm.write(" tabIndex=\"0\"");
			rm.addClass("sapUiBtnStd");
		}

		var bImageOnly = false;
		if (!oButton.getText() && oButton.getIcon()) { // icon, but no text => reduce padding
			rm.addClass("sapUiBtnIconOnly");
			bImageOnly = true; // only the image is there, so it must have some meaning
		}

		if (oButton.getIcon() && oButton.getText()) {
			rm.addClass("sapUiBtnIconAndText");
		}

		if (oButton.getWidth() && oButton.getWidth() != '') {
			rm.addStyle("width", oButton.getWidth());
			rm.addClass("sapUiBtnFixedWidth");
		}
		if (oButton.getHeight() && oButton.getHeight() != '') {
			rm.addStyle("height", oButton.getHeight());
		}
		rm.writeStyles();

		if (this.renderButtonAttributes) {
			this.renderButtonAttributes(rm, oButton);
		}

		// feature-dependent CSS class, written for browsers not understanding CSS gradients (=IE8, IE9)
		// required to avoid a large number of browser selectors which is needed to NOT serve filter:... to IE10
		if (!!sap.ui.Device.browser.internet_explorer && (!document.documentMode || document.documentMode < 10)) {
			rm.addClass("sapUiBtnNoGradient");
		}

		rm.writeClasses();

		rm.write(">");

		if (this.renderButtonContentBefore) {
			this.renderButtonContentBefore(rm, oButton);
		}

		var bUseIconFont = false;
		if (sap.ui.core.IconPool.isIconURI(oButton.getIcon())) {
			bUseIconFont = true;
		}

		if (oButton.getIconFirst()) {
			if (bUseIconFont) {
				this.writeIconHtml(rm, oButton, bImageOnly);
			} else if (this._getIconForState(oButton, "base")) {
				this.writeImgHtml(rm, oButton, bImageOnly);
			}
		}

		// write the button label
		if (oButton.getText()) {
			if (!oButton.getIcon() && !this.renderButtonContentBefore && !this.renderButtonContentAfter) {
				rm.writeEscaped(oButton.getText());
			} else { // if there is an icon, an additional span is required
				rm.write("<span class=\"sapUiBtnTxt\">");
				rm.writeEscaped(oButton.getText());
				rm.write("</span>");
			}
		}

		if (!oButton.getIconFirst()) {
			if (bUseIconFont) {
				this.writeIconHtml(rm, oButton, bImageOnly);
			} else if (this._getIconForState(oButton, "base")) {
				this.writeImgHtml(rm, oButton, bImageOnly);
			}
		}

		if (this.renderButtonContentAfter) {
			this.renderButtonContentAfter(rm, oButton);
		}

		// close button
		rm.write("</button>");
	};

	/**
	 * Function called by button control on mouse down event.
	 */
	ButtonRenderer.onactive = function(oButton) {
		oButton.$().addClass("sapUiBtnAct").removeClass("sapUiBtnStd");
		oButton.$("img").attr("src", this._getIconForState(oButton, "active"));
	};

	/**
	 * Function called by button control on mouse up event.
	 */
	ButtonRenderer.ondeactive = function(oButton) {
		oButton.$().addClass("sapUiBtnStd").removeClass("sapUiBtnAct");
		oButton.$("img").attr("src", this._getIconForState(oButton, "deactive"));
	};

	/**
	 * Function called by button control on blur.
	 */
	ButtonRenderer.onblur = function(oButton) {
		oButton.$().removeClass("sapUiBtnFoc");
		oButton.$("img").attr("src", this._getIconForState(oButton, "blur"));
		if (!!sap.ui.Device.browser.internet_explorer) {
			ButtonRenderer.onmouseout(oButton);
		}
	};

	/**
	 * Function called by button control on focus.
	 */
	ButtonRenderer.onfocus = function(oButton) {
		oButton.$().addClass("sapUiBtnFoc");
		oButton.$("img").attr("src", this._getIconForState(oButton, "focus"));
	};

	/**
	 * Function called when mouse leaves button
	 */
	ButtonRenderer.onmouseout = function(oButton) {
		oButton.$().removeClass("sapUiBtnAct");
		oButton.$().addClass("sapUiBtnStd");
		oButton.$("img").attr("src", this._getIconForState(oButton, "mouseout"));
	};

	/**
	 * Function called when mouse enters button
	 * @private
	 */
	ButtonRenderer.onmouseover = function(oButton) {
		oButton.$("img").attr("src", this._getIconForState(oButton, "mouseover"));
	};

	/**
	 * Returns the icon URI for the given button state
	 * @private
	 */
	ButtonRenderer._getIconForState = function(oButton, sState) {
		if (!oButton.getEnabled()) {
			sState = "disabled";
		}
		switch (sState) {
			case "focus":
			case "blur":
			case "base":
				if (oButton.$().hasClass("sapUiBtnAct")) {
					var sIcon = oButton.getIconSelected() || oButton.getIconHovered();
					return sIcon ? sIcon : oButton.getIcon();
				} else if (oButton.$().hasClass("sapUiBtnFoc")) {
					return oButton.getIconHovered() || oButton.getIcon();
				}
				return oButton.getIcon();
			case "mouseout":
				if (oButton.$().hasClass("sapUiBtnFoc")) {
					return oButton.getIconHovered() || oButton.getIcon();
				}
				return oButton.getIcon();
			case "active":
				var sIcon = oButton.getIconSelected() || oButton.getIconHovered();
				return sIcon ? sIcon : oButton.getIcon();
			case "mouseover":
			case "deactive":
				var sIcon = oButton.getIconHovered();
				return sIcon ? sIcon : oButton.getIcon();
		}
		return oButton.getIcon();
	};

	/**
	 * HTML for icon as image
	 */
	ButtonRenderer.writeImgHtml = function(oRenderManager, oButton, bImageOnly) {
		var rm = oRenderManager,
			iconUrl = this._getIconForState(oButton, "base");

		rm.write("<img");
		rm.writeAttribute("id", oButton.getId() + "-img");
		rm.writeAttributeEscaped("src", iconUrl);
		if (oButton.getTooltip_AsString() && !oButton.getText()) {
			rm.writeAttributeEscaped("alt", oButton.getTooltip_AsString());
		} else {
			rm.writeAttribute("alt", ""); // there must be an ALT attribute
		}

		if (!bImageOnly) {
			rm.writeAttribute("role", "presentation");
		}

		rm.addClass("sapUiBtnIco");
		if (oButton.getText()) { // only add a distance to the text if there is text
			if (oButton.getIconFirst()) {
				rm.addClass("sapUiBtnIcoL");
			} else {
				rm.addClass("sapUiBtnIcoR");
			}
		}
		rm.writeClasses();

		rm.write("/>");
	};

	/**
	 * HTML for icon as icon font
	 */
	ButtonRenderer.writeIconHtml = function(oRenderManager, oButton, bImageOnly) {

		var rm = oRenderManager;
		var oIconInfo = sap.ui.core.IconPool.getIconInfo(oButton.getIcon());
		var aClasses = [];
		var mAttributes = {};

		mAttributes["id"] = oButton.getId() + "-icon";

		aClasses.push("sapUiBtnIco");
		if (oButton.getText()) { // only add a distance to the text if there is text
			var bRTL = rm.getConfiguration().getRTL();
			if ((oButton.getIconFirst() && (!bRTL || oIconInfo.skipMirroring)) || (!oButton.getIconFirst() && !oIconInfo.skipMirroring && bRTL)) {
				aClasses.push("sapUiBtnIcoL");
			} else {
				aClasses.push("sapUiBtnIcoR");
			}
		}

		rm.writeIcon(oButton.getIcon(), aClasses, mAttributes);

	};

	ButtonRenderer.changeIcon = function(oButton) {

		if (sap.ui.core.IconPool.isIconURI(oButton.getIcon())) {
			var oIconInfo = sap.ui.core.IconPool.getIconInfo(oButton.getIcon());
			var oIcon = oButton.$("icon");
			if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 9) {
				oIcon.text(oIconInfo.content);
			} else {
				oIcon.attr("data-sap-ui-icon-content", oIconInfo.content);
			}
			if (!oIconInfo.skipMirroring) {
				oIcon.addClass("sapUiIconMirrorInRTL");
			} else {
				oIcon.removeClass("sapUiIconMirrorInRTL");
			}
		} else if (oButton.$().hasClass("sapUiBtnAct")) {
			oButton.$("img").attr("src", this._getIconForState(oButton, "active"));
		} else if (oButton.$().hasClass("sapUiBtnFoc")) {
			oButton.$("img").attr("src", this._getIconForState(oButton, "focus"));
		} else if (oButton.$().hasClass("sapUiBtnStd")) {
			oButton.$("img").attr("src", this._getIconForState(oButton, "base"));
		}

	};


	return ButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CalloutBaseRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.CalloutBaseRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/CalloutBaseRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * CalloutBase renderer.
	 * @namespace
	 */
	var CalloutBaseRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the Callout that should be rendered
	 */
	CalloutBaseRenderer.render = function(oRenderManager, oControl){
	
		var rm = oRenderManager;
		var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
		var sId = oControl.getId();
	
		//container
		rm.write("<div");
		rm.writeControlData(oControl);
	
		rm.addClass("sapUiCltBase");
		if (this.addRootClasses) {
			this.addRootClasses(rm, oControl);
		}
		rm.writeClasses();
	
		if (accessibility) {
			rm.writeAttribute("role", "dialog");
			//ARIA label
			var sAriaLabel = oControl.oRb.getText('CALLOUT_ARIA_NAME');
			if (sAriaLabel) {
				rm.writeAttributeEscaped("aria-label", sAriaLabel);
			}
		}
		if (oControl.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
		}
		
		rm.addStyle("display", "none");
		rm.writeStyles();
		
		rm.write(">");
	
		//first focusable control to provide tab loop
		rm.write("<span id=\"" + sId + "-fhfe\" tabIndex=\"0\"></span>");
	
		// content container
		rm.write("<div");
		rm.writeAttribute("id",sId + "-cont");
	
		rm.addClass("sapUiCltBaseCont");
		if (this.addContentClasses) {
			this.addContentClasses(rm, oControl);
		}
		rm.writeClasses();
	
		rm.writeAttribute("tabindex","-1");
		rm.write(">");
	
		// successor controls provide content here in their specific renderContent methods
		if (this.renderContent) {
			this.renderContent(rm, oControl);
		}
		rm.write("</div>");
	
		// arrow tip
		rm.write("<div");
		rm.writeAttribute("id", sId + "-arrow");
		if (accessibility) {
			rm.writeAttribute("role", "presentation");
		}
		// specific arrow placement is specified in behavior by setting additional CSS classes
		rm.addClass("sapUiCltBaseArr");
		if (this.addArrowClasses) {
			this.addArrowClasses(rm, oControl);
		}
		rm.writeClasses();
		rm.write("></div>");
	
		//last focusable control to provide tab loop
		rm.write("<span id=\"" + sId + "-fhee\" tabIndex=\"0\"></span>");
	
		rm.write("</div>");// container
	
	};
	

	return CalloutBaseRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/CalloutBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CalloutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.CalloutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/CalloutRenderer",['jquery.sap.global', './CalloutBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, CalloutBaseRenderer, Renderer) {
	"use strict";


	/**
	 * Callout renderer.
	 * @namespace
	 */
	var CalloutRenderer = Renderer.extend(CalloutBaseRenderer);
	
	/**
	 * Renders the HTML for content.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oCallout an object representation of the Callout that should be rendered
	 */
	CalloutRenderer.renderContent = function(oRenderManager, oCallout){
	
		var rm = oRenderManager;
		var content = oCallout.getContent();
	
		// content
		for (var i = 0; i < content.length; i++) {
			rm.renderControl(content[i]);
		}
	};
	
	/**
	 * Add the root CSS class to the Callout to redefine/extend CalloutBase
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CalloutRenderer.addRootClasses = function(oRenderManager, oControl) {
		oRenderManager.addClass("sapUiClt");
	};
	
	/**
	 * Add the content CSS class to the Callout to redefine/extend CalloutBase
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CalloutRenderer.addContentClasses = function(oRenderManager, oControl) {
		oRenderManager.addClass("sapUiCltCont");
	};
	
	/**
	 * Add the arrow/tip CSS class to the Callout to redefine/extend CalloutBase
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CalloutRenderer.addArrowClasses = function(oRenderManager, oControl) {
		oRenderManager.addClass("sapUiCltArr");
	};
	

	return CalloutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/CalloutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CarouselRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Carousel
jQuery.sap.declare('sap.ui.commons.CarouselRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/CarouselRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * carousel renderer.
	 * @namespace
	 */
	var CarouselRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	CarouselRenderer.render = function(oRenderManager, oControl) {

		var rm = oRenderManager;
		var bRTL = sap.ui.getCore().getConfiguration().getRTL();

		rm.write("<div");
		rm.addClass("sapUiCrsl");
		if (oControl.getWidth() != "") {
			rm.addStyle("width", oControl.getWidth());
		}
		if (oControl.getHeight() != "") {
			rm.addStyle("height", oControl.getHeight());
		}
		rm.writeStyles();
		rm.writeClasses();
		rm.writeControlData(oControl);
		rm.write(">");

		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

		// Start Prev button
		rm.write("<div");
		rm.writeAttribute("id", oControl.getId() + "-prevbutton");
		rm.writeAttribute("title", rb.getText("CAROUSEL_SHOW_PREV"));
		rm.addClass("sapUiCrslPrevBtn");
		rm.writeClasses();
		if (oControl.getHandleSize() != 22) {
			if (oControl.getOrientation() == "vertical") {
				rm.addStyle("height",oControl.getHandleSize() + "px");
			} else {
				rm.addStyle("width",oControl.getHandleSize() + "px");
			}
			rm.writeStyles();
		}
		rm.write(">");
		if (oControl.getOrientation() == "vertical") {
			rm.write("&#9650");//Symbol for Base and HCB Theme (Must be hidden in other themes)
		} else {
			if (bRTL) {
				rm.write("&#9658");//Symbol for Base and HCB Theme (Must be hidden in other themes)
			} else {
				rm.write("&#9668");//Symbol for Base and HCB Theme (Must be hidden in other themes)
			}
		}
		rm.write("</div>");
		// End Prev button

		// Start Next button
		rm.write("<div");
		rm.writeAttribute("id", oControl.getId() + "-nextbutton");
		rm.writeAttribute("title", rb.getText("CAROUSEL_SHOW_NEXT"));
		rm.addClass("sapUiCrslNextBtn");
		rm.writeClasses();
		if (oControl.getHandleSize() != 22) {
			if (oControl.getOrientation() == "vertical") {
				rm.addStyle("height",oControl.getHandleSize() + "px");
			} else {
				rm.addStyle("width",oControl.getHandleSize() + "px");
			}
			rm.writeStyles();
		}
		rm.write(">");
		if (oControl.getOrientation() == "vertical") {
			rm.write("&#9660");//Symbol for Base and HCB Theme (Must be hidden in other themes)
		} else {
			if (bRTL) {
				rm.write("&#9668");//Symbol for Base and HCB Theme (Must be hidden in other themes)
			} else {
				rm.write("&#9658");//Symbol for Base and HCB Theme (Must be hidden in other themes)
			}
		}
		rm.write("</div>");
		// End Next button

		// Start content area
		rm.write("<div");
		rm.writeAttribute("id", oControl.getId() + "-contentarea");
		rm.addClass("sapUiCrslCnt");
		rm.writeClasses();
		rm.write(">");

		var aContent = oControl.getContent();

		rm.write("<ul");
		rm.writeAttribute("id", oControl.getId() + "-scrolllist");
		rm.writeAttribute("role", "listbox");
		rm.writeAttribute("aria-describedby", oControl.getId() + "-navigate");
		rm.addClass("sapUiCrslScl");
		rm.writeClasses();
		rm.write(">");

		for ( var i = 0; i < aContent.length; i++) {
			var oChild = aContent[i];
			rm.write("<li");
			rm.writeAttribute("id",oControl.getId() + "-item-" + oChild.getId());
			rm.writeAttribute("role", "option");
			rm.writeAttribute("tabindex", "-1");
			rm.writeAttribute("aria-describedby", oControl.getId() + "-toggleaction");
			rm.addClass("sapUiCrslItm");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oChild);
			rm.write("</li>");
		}

		rm.write("</ul>");

		rm.write("</div>");
		// End content area

		rm.write("<div");
		rm.writeAttribute("tabindex", "0");
		rm.addClass("sapUiCrslBefore");
		rm.writeClasses();
		rm.write("></div>");

		rm.write("<div");
		rm.writeAttribute("tabindex", "0");
		rm.addClass("sapUiCrslAfter");
		rm.writeClasses();
		rm.write("></div>");

		// aria description for toggling the action mode
		rm.write("<span");
		rm.writeAttribute("id", oControl.getId() + "-toggleaction");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(rb.getText("CAROUSEL_ACTION_MODE"));
		rm.write("</span>");

		// aria description for navigation
		rm.write("<span");
		rm.writeAttribute("id", oControl.getId() + "-navigate");
		rm.addStyle("position", "absolute");
		rm.addStyle("top", "-20000px");
		rm.writeStyles();
		rm.write(">");
		rm.write(rb.getText("CAROUSEL_NAV"));
		rm.write("</span>");

		rm.write("</div>");
	};

	return CarouselRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/CarouselRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CheckBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.CheckBox
jQuery.sap.declare('sap.ui.commons.CheckBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/CheckBoxRenderer",['jquery.sap.global', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, ValueStateSupport) {
	"use strict";


	/**
	 * @author SAP SE
	 * @namespace
	 */
	var CheckBoxRenderer = {
	};
	
	/**
	 * Renders the HTML for the CheckBox, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that is used for writing to the render output buffer.
	 * @param {sap.ui.commons.CheckBox} oCheckBox The CheckBox control that should be rendered.
	 */
	CheckBoxRenderer.render = function(rm, oCheckBox) {
		rm.addClass("sapUiCb");
	
		// Open the containing <span> tag
		rm.write("<span");
		rm.writeControlData(oCheckBox);
	
		// ARIA
		rm.writeAccessibilityState(oCheckBox, {"role" : sap.ui.core.AccessibleRole.Checkbox.toLowerCase()});
	
		// Collect state information
		var enabled = oCheckBox.getEnabled() != null && oCheckBox.getEnabled();
		var editable = oCheckBox.getEditable() != null && oCheckBox.getEditable();
		var inErrorState = false;
		var inWarningState = false;
		if (oCheckBox.getValueState() != null) {
			inErrorState = sap.ui.core.ValueState.Error == oCheckBox.getValueState();
			inWarningState = sap.ui.core.ValueState.Warning == oCheckBox.getValueState();
		}
	
	
		// Add classes and properties depending on the state
		if (oCheckBox.getChecked()) {
			rm.addClass("sapUiCbChk");
		}
	
		var myTabIndex = 0;
	
		if (!editable) {
			rm.addClass("sapUiCbRo");
			// According to CSN 2581852 2012 a readonly CB should be in the tabchain
			// This changed in 2013 back to not in the tabchain: see CSN 0002937527 2013
			// Let's see how often this will be changed back and forth in the future... Accessibility fun! :-D
			// End of 2013 is have to be again in the tabchain.
			// But not in the Form. But this is handled in the FormLayout control
			// Let's see what happens 2014... ;-)
			myTabIndex = 0;
		}
		if (!enabled) {
			rm.addClass("sapUiCbDis");
			myTabIndex = -1;
		}
		if (inErrorState) {
			rm.addClass("sapUiCbErr");
			rm.writeAttribute("aria-invalid", "true");
		} else if (inWarningState) {
			rm.addClass("sapUiCbWarn");
		}
		if (enabled && editable && !inErrorState && !inWarningState) {
			rm.addClass("sapUiCbStd");
		}
		if (enabled && editable) {
			rm.addClass("sapUiCbInteractive");
		}
		rm.writeClasses();
	
		if (oCheckBox.getWidth() && oCheckBox.getWidth() != '') {
			rm.writeAttribute("style", "width:" + oCheckBox.getWidth() + ";");
		}
	
		rm.writeAttribute("tabIndex", myTabIndex);
	
		rm.write(">"); // close the containing <span> tag
	
	
		// Write the (potentially hidden) HTML checkbox element
		rm.write("<input type='CheckBox' tabindex='-1' id='");
		rm.write(oCheckBox.getId());
		rm.write("-CB'");
	
		if (oCheckBox.getName()) {
			rm.writeAttributeEscaped('name', oCheckBox.getName());
		}
	
		if (oCheckBox.getChecked()) {
			rm.write(" checked='checked'");
		}
		if (!enabled) {
			rm.write(" disabled='disabled'");
		}
		var tooltip = ValueStateSupport.enrichTooltip(oCheckBox, oCheckBox.getTooltip_AsString());
		if (tooltip) {
			rm.writeAttributeEscaped("title", tooltip);
		}
		if (!editable) {
			//'readonly' property is not supported by input type=checkbox
			//In order to make readonly checkbox unresponsive, we need to apply 'disabled' property - only affects HCB theme
			rm.write(" disabled='disabled'");
		}
		rm.write(" />"); // close checkbox-input-element
	
	
		// Write the checkbox label which also holds the background image
		rm.write("<label");
		if (tooltip) {
			rm.writeAttributeEscaped("title", tooltip);
		}
		rm.writeAttribute("for", oCheckBox.getId() + "-CB"); // label for checkbox, so clicks toggle the state
		if (!oCheckBox.getText()) {
			rm.write(" class='sapUiCbNoText'");
		}
		rm.write(">");
		if (oCheckBox.getText()) {
			this.renderText(rm, oCheckBox.getText(), oCheckBox.getTextDirection());
		}
		rm.write("</label>");
	
		// close the surrounding <span> element
		rm.write("</span>");
	};
	
	
	
	/**
	 * Write the CheckBox label either flat or - in case the text direction is different from the environment - within a span tag with an explicit "dir".
	 */
	CheckBoxRenderer.renderText = function(oRenderManager, sText, eTextDirection) {
		var rm = oRenderManager;
		if (!eTextDirection || eTextDirection == sap.ui.core.TextDirection.Inherit) {
			rm.writeEscaped(sText);
		} else {
			rm.write("<span style=\"direction:" + eTextDirection.toLowerCase() + ";\">");
			rm.writeEscaped(sText);
			rm.write("</span>");
		}
	};
	

	return CheckBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/CheckBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ColorPickerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ColorPicker
jQuery.sap.declare('sap.ui.commons.ColorPickerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ColorPickerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ColorPicker renderer.
	 * @namespace
	 */
	var ColorPickerRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ColorPickerRenderer.render = function(oRm, oControl){
	
		// write the HTML into the render manager
		oRm.write("<div");   // Outer DIV
		oRm.writeControlData(oControl);
		oRm.writeClasses();
		oRm.write(">"); // <DIV> element
		oRm.renderControl(oControl.oMatrix);
		oRm.write("</div>");  // outer DIV
	
	};
	
	

	return ColorPickerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ColorPickerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.DialogRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Dialog
jQuery.sap.declare('sap.ui.commons.DialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/DialogRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 *  sap.ui.commons.DialogRenderer
	 * @namespace
	 */
	var DialogRenderer = {};


	/**
	 * Renders the HTML for the Dialog, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	DialogRenderer.render = function(rm, oControl) {
		var heightSet = sap.ui.commons.Dialog._isSizeSet(oControl.getHeight());
		var widthSet = sap.ui.commons.Dialog._isSizeSet(oControl.getWidth());

		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

		oControl.getScrollTop();  // Update the scroll position properties
		oControl.getScrollLeft();

		var aButtons = oControl.getButtons();
		var iButtonCount = aButtons.length;


		// Root element and classes/styles
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiDlg");
		if (oControl.getModal()) {
			rm.addClass("sapUiDlgModal");
		}
		rm.addClass("sapUiDlgContentBorderDesign" + oControl.getContentBorderDesign());

		rm.addStyle("width", oControl.getWidth());
		rm.addStyle("height", oControl.getHeight());
		rm.addStyle("min-width", oControl.getMinWidth());
		rm.addStyle("min-height", oControl.getMinHeight());
		rm.addStyle("max-width", oControl.getMaxWidth());
		rm.addStyle("max-height", oControl.getMaxHeight());
		// Do not display the dialog content directly after rerendering, since it might just be
		// rendered inside the static area, whithout being in a popup
		rm.addStyle("display", "none");

		if (!heightSet) {
			rm.addClass("sapUiDlgFlexHeight");
		}
		if (!widthSet) {
			rm.addClass("sapUiDlgFlexWidth");
		}
		if (iButtonCount == 0) {
			rm.addClass("sapUiDlgNoButtons");
		}
		if (!oControl.getApplyContentPadding()) {
			rm.addClass("sapUiDlgNoPad");
		}
		rm.writeClasses();
		rm.writeStyles();

		rm.writeAttribute("aria-labelledby", oControl.getId() + "-lbl " + oControl.getId() + "-acc");
		rm.writeAttribute("role", oControl.getAccessibleRole().toLowerCase());
		rm.writeAttribute("tabindex", "-1");
		rm.write("><span style='display:none;' id='", oControl.getId(), "-acc'>", rb.getText("DIALOG_CLOSE_HELP"), "</span>");

		// Header
		rm.write("<span id='" + oControl.getId() + "-fhfe' tabIndex='0'></span><div id='" + oControl.getId() + "-hdr' class='sapUiDlgHdr'>");
		rm.write("<span class='sapUiDlgHdrLeft' id='" + oControl.getId() + "-hdrL'>");

		// Header label
		var title = oControl.getTitle();
		rm.write("<span id='" + oControl.getId() + "-lbl' class='sapUiDlgLabel'");

		rm.writeAttribute("role", "heading");
		rm.writeAttribute("aria-level", "1");
		if (title) {
			rm.writeAttributeEscaped("title", title);
		}
		rm.write(">");

		if (!title) {
			rm.write("&nbsp;");
		} else {
			rm.writeEscaped(title);
		}
		rm.write("</span></span>");
		rm.write("<span id='", oControl.getId(), "-hdrR' class='sapUiDlgHdrBtns'>");
		// Example for an additional button:   rm.write("<a class='sapUiDlgOptBtn'></a>");

		if (oControl.getShowCloseButton()) {
			rm.write("<a id='", oControl.getId(), "-close' class='sapUiDlgCloseBtn' href='javascript:void(0)'");
			rm.write(" tabIndex='-1'"); // according to accessibility experts (O.K. and M.J.), the 'x' should not be tab-able
			rm.writeAttribute("role","button");
			rm.writeAttributeEscaped("aria-label", rb.getText("DIALOG_CLOSE_HELP"));
			rm.writeAttributeEscaped("title", rb.getText("DIALOG_CLOSE_TEXT"));
			rm.write("></a>");
		}
		rm.write("</span></div>");

		// 	Header separator
		rm.write('<div class="sapUiDlgHdrSep"></div>');

		// Content area
		rm.write("<div class='sapUiDlgCont' id='", oControl.getId(), "-cont' tabindex=\"-1\">");

		// Content
		var aChildren = oControl.getContent();
		for (var i = 0; i < aChildren.length; i++) {
			rm.renderControl(aChildren[i]);
		}
		rm.write("</div>");

		// Footer separator
		if (iButtonCount > 0) {
			rm.write('<div class="sapUiDlgFooterSep"></div>');
		}

		// Footer
		rm.write("<div id='");
		rm.write(oControl.getId());
		rm.write("-footer' class='sapUiDlgFooter'>");

		// Wave and Buttons
		rm.write("<div class='sapUiDlgBtns'>");
		for (var i = 0; i < iButtonCount; i++) {
			rm.renderControl(aButtons[i]);
		}
		rm.write("</div><div class='sapUiDlgWave'></div></div>");

		// Grip
		if (oControl.getResizable()) {
			rm.write("<span id='");
			rm.write(oControl.getId());
			rm.write("-grip' class='sapUiDlgGrip'>&#916;</span>");
		}

		// End of Dialog
		rm.write("<span id='" + oControl.getId() + "-fhee' tabIndex='0'></span></div>");

	};


	return DialogRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/DialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FileUploaderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.FileUploader
jQuery.sap.declare('sap.ui.commons.FileUploaderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.FileUploaderRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/FileUploaderRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/unified/FileUploaderRenderer'],
	function(jQuery, Renderer, FileUploaderRenderer1) {
	"use strict";


	var FileUploaderRenderer = Renderer.extend(FileUploaderRenderer1);

	return FileUploaderRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/FileUploaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FormattedTextViewRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.commons.FormattedTextViewRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/FormattedTextViewRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * FormattedTextView renderer.
	 * @namespace
	 */
	var FormattedTextViewRenderer = {};
	
	/*
	 * Renders the HTML for the FormattedTextView, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for
	 * writing to the render output buffer @param {sap.ui.core.Control} oControl an
	 * object representation of the control that should be rendered
	 */
	FormattedTextViewRenderer.render = function(oRm, oControl) {
		// pattern for placeholders:
		var rPlaceHolderPattern = /<embed\s+data-index="([0-9]+)"\s*\/?>/gim;
		var sHtml = oControl.getHtmlText();
	
		// clone, will be modified below
		var aInnerControls = oControl.getControls().slice();
	
		var iToBeRendered = aInnerControls.length;
		var lastIndex = 0;
		var aMatch = [];
	
		// write the HTML into the render manager
		oRm.write("<span");
		oRm.writeControlData(oControl);
		oRm.addClass("sapUiFTV");
		oRm.writeClasses();
	
		// render Tooltip
		if (oControl.getTooltip_AsString()) {
			oRm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
		}
		oRm.write(">"); // span element
	
		// check for placeholders in htmlText property
		while ((aMatch = rPlaceHolderPattern.exec(sHtml)) !== null) {
			// write any static HTML between previous and current placeholder (if
			// any)
			oRm.write(sHtml.slice(lastIndex, aMatch.index));
			// replace placeholder with control in aggregation
			if (this._renderReplacement(oRm, aMatch[1], aInnerControls)) {
				iToBeRendered--;
			} else {
				jQuery.sap.log.warning("Could not find matching control to placeholder #" + aMatch[1]);
			}
			lastIndex = rPlaceHolderPattern.lastIndex;
		}
		// render the remainder of the HTML
		oRm.write(sHtml.slice(lastIndex, sHtml.length));
	
		if (iToBeRendered > 0) {
			jQuery.sap.log.warning('There are leftover controls in the aggregation that have not been used in the formatted text', oControl);
		}
	
		oRm.write("</span>");
	
	};
	
	/* Private method for placeholder replacement */
	FormattedTextViewRenderer._renderReplacement = function(rm, controlsIndex, aControls) {
		if (aControls[controlsIndex]) {
			rm.renderControl(aControls[controlsIndex]);
			// UI5 controls must not be rendered twice!
			aControls[controlsIndex] = null;
			return true;
		} else {
			return false;
		}
	};

	return FormattedTextViewRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/FormattedTextViewRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.HorizontalDividerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.HorizontalDivider
jQuery.sap.declare('sap.ui.commons.HorizontalDividerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/HorizontalDividerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * HorizontalDivider renderer.
	 * @namespace
	 */
	var HorizontalDividerRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered
	 */
	HorizontalDividerRenderer.render = function(oRenderManager, oControl){
		var rm = oRenderManager;
		rm.write("<hr");
		rm.writeControlData(oControl);
		rm.writeAttribute("role", "separator"); //ARIA
		if (oControl.getWidth()) {
			rm.writeAttribute("style", "width:" + oControl.getWidth() + ";");
		}
		rm.addClass("sapUiCommonsHoriDiv");
		rm.addClass(oControl.getType() == "Page" ? "sapUiCommonsHoriDivTypePage" : "sapUiCommonsHoriDivTypeArea");
		switch (oControl.getHeight()) {
			case "Ruleheight":
				rm.addClass("sapUiCommonsHoriDivHeightR");
				break;
			case "Small":
				rm.addClass("sapUiCommonsHoriDivHeightS");
				break;
			case "Large":
				rm.addClass("sapUiCommonsHoriDivHeightL");
				break;
			default:
				rm.addClass("sapUiCommonsHoriDivHeightM");
		}
		rm.writeClasses();
		rm.write("/>");
	};
	

	return HorizontalDividerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/HorizontalDividerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ImageMapRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.ImageMapRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ImageMapRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ImageMap renderer.
	 * @namespace
	 */
	var ImageMapRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ImageMapRenderer.render = function(oImageRenderManager, oImageMap){
	    // convenience variable
		var rm = oImageRenderManager;
		var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	
		rm.write('<SPAN id="' + oImageMap.getId() + '-Descr" style="visibility: hidden; display: none; outline: none;">');
		rm.writeEscaped(rb.getText("IMAGEMAP_DSC"));
		rm.write('</SPAN>');
	
		rm.write("<map tabindex='-1'");
		rm.writeControlData(oImageMap);
	
		// Render name attribute
		rm.writeAttributeEscaped("name",  oImageMap.getName());
	
		if (oImageMap.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oImageMap.getTooltip_AsString());
		}
	
		rm.write(">");
		var aAreas = oImageMap.getAreas();
			for (var index = 0, length = aAreas.length; index < length; index++) {
				rm.write("<area ");
	
				rm.writeElementData(aAreas[index]);
				
				rm.write(' style="display: inline;"');
	
				if (accessibility) {
					rm.writeAttribute("aria-describedby", oImageMap.getId() + "-Descr");
				}
	
				
				// Get the Attributes of the area
				var sShape = aAreas[index].getShape();
				var sCoords = aAreas[index].getCoords();
				var sHref = aAreas[index].getHref();
				var sAlt = aAreas[index].getAlt();
				var sTitle = aAreas[index].getTooltip_AsString();
	
				// Render Shape Attribute. It can an be only rect, circle, poly and default
				if ( (sShape === "rect") || (sShape === "circle") || (sShape === "poly")) {
					rm.writeAttribute("shape", sShape);
				} else {
					rm.writeAttribute("shape", "default");
				}
	
				// Render Coordinates. To do: check syntax of the input array of the coordinates
				if (sCoords) {
					rm.writeAttributeEscaped("coords", sCoords);
				}
	
				// Render href
				if (sHref) {
					rm.writeAttributeEscaped("href", sHref);
				}
	
				// Render text on ALT
				if (sAlt) {
					rm.writeAttributeEscaped("alt", sAlt);
				}
	
				// Tooltip
				if (sTitle) {
					rm.writeAttributeEscaped("title", sTitle);
				}
	
	
	
				rm.writeAttribute("tabIndex", 0);
				rm.write(">");
			} // end of for
	
		rm.write("</map>");
	
	};
	

	return ImageMapRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ImageMapRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ImageRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Image
jQuery.sap.declare('sap.ui.commons.ImageRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ImageRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @author d046011
	 * @namespace
	 */
	var ImageRenderer = {
	};
	
	/**
	 * Renders the HTML for the Image, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.Image} oImage The control that should be rendered.
	 */
	ImageRenderer.render = function(oRenderManager, oImage) {
		var rm = oRenderManager;

		// Open the <img> tag
		rm.write("<img");
		rm.writeControlData(oImage);
	
		// Set the 1x1.gif when empty source is set. This is to prevent the broken image placeholder and unnecessary 
		// requests to the root url in older browsers (as the 1x1.gif is only loaded once and then cached).
		// Hiding the image won't help as hidden images are still loaded.
		// The HTML5 spec requires empty source tags to be ignored. Anyway, some modern browsers still show border around
		// empty images.
		rm.writeAttributeEscaped("src", oImage.getSrc() || sap.ui.resource('sap.ui.commons', 'img/1x1.gif'));
	
		rm.addClass("sapUiImg");
		if (oImage.hasListeners("press")) {
			rm.addClass("sapUiImgWithHandler");
		}
		if (!oImage.getSrc()) {
			rm.addClass("sapUiImgNoSource");
		}
		rm.writeClasses();
	
		var tooltip = oImage.getTooltip_AsString();
		if (tooltip) {
			rm.writeAttributeEscaped("title", tooltip);
		}
	
		var sUseMap = oImage.getUseMap();
		if (sUseMap) {
			if (!(jQuery.sap.startsWith(sUseMap, "#"))) {
				sUseMap = "#" + sUseMap;
			}
			rm.writeAttributeEscaped("useMap", sUseMap);
		}
	
		// determine tab index and write alt attribute - both depending on "decorative" state (which is overridden by the "useMap" property
		var myTabIndex = 0;
		if ((oImage.getDecorative() && (!sUseMap))) {
			myTabIndex = -1;
			rm.writeAttribute("role", "presentation");
			rm.write(" alt=''"); // accessibility requirement: write always empty alt attribute for decorative images
		} else {
			if (oImage.getAlt()) {
				rm.writeAttributeEscaped("alt", oImage.getAlt() || tooltip); // accessibility requirement: use tooltip for alt if alt is not set
			} else if (tooltip) {
				rm.writeAttributeEscaped("alt", tooltip);
			}
		}
		rm.writeAttribute("tabIndex", myTabIndex);
	
		// Dimensions
		var myStyle = "";
		if (oImage.getWidth() && oImage.getWidth() != '') {
			myStyle += "width:" + oImage.getWidth() + ";";
		}
		if (oImage.getHeight() && oImage.getHeight() != '') {
			myStyle += "height:" + oImage.getHeight() + ";";
		}
		if (myStyle != "") {
			rm.writeAttribute("style", myStyle);
		}
	
		rm.write("/>"); // close the <img> element
	};

	return ImageRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ImageRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.InPlaceEditRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.InPlaceEditRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/InPlaceEditRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * InPlaceEdit renderer.
	 * @namespace
	 */
	var InPlaceEditRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oInPlaceEdit an object representation of the control that should be rendered
	 */
	InPlaceEditRenderer.render = function(rm, oInPlaceEdit){

		var oContent = oInPlaceEdit.getContent();
		var sWidth;

		if (oContent) {
			if (oContent.getWidth) {
				sWidth = oContent.getWidth();
			}
			if (oContent.getVisible && !oContent.getVisible()) {
				// invisible -> render nothing
				jQuery.sap.log.warning("Content is not visivle - nothing is rendered", this);
				return;
			}
		} else {
			// no content -> render nothing
			jQuery.sap.log.warning("No content provided - nothing is rendered", this);
			return;
		}

		// write the HTML into the render manager
		rm.write("<DIV");
		rm.writeControlData(oInPlaceEdit);
		rm.addClass("sapUiIpe");

		if (!oInPlaceEdit.getEditable()) {
			rm.addClass("sapUiIpeRo");
		} else if (!oInPlaceEdit._bEditMode) {
			// display mode
			rm.writeAttribute("tabindex", "-1"); //to have focus event on clicking on this DIV (ComboBox expander in display mode)
			if (!oInPlaceEdit._sOldTextAvailable) {
				if (oContent.getMetadata().getName() == "sap.ui.commons.ComboBox" || oContent.getMetadata().getName() == "sap.ui.commons.DropdownBox") {
					rm.addClass("sapUiIpeCombo");
				}
			}
			if (oContent.getMetadata().getName() == "sap.ui.commons.Link") {
				rm.addClass("sapUiIpeLink");
			}
		} else {
			// edit mode
			rm.addClass("sapUiIpeEdit");
		}

		if (sWidth) {
			rm.addStyle("width", sWidth);
		}

		if (oInPlaceEdit.getUndoEnabled() && oInPlaceEdit._sOldTextAvailable && ( !oInPlaceEdit._bEditMode || ( oInPlaceEdit._bEditMode && oInPlaceEdit._oEditControl.getValue() != oInPlaceEdit._sOldText))) {
			// there is an old text available - visualize Undo
			rm.addClass("sapUiIpeUndo");
		}

		switch (oInPlaceEdit.getValueState()) {
		case sap.ui.core.ValueState.Error:
			rm.addClass('sapUiIpeErr');
		break;
		case sap.ui.core.ValueState.Success:
			rm.addClass('sapUiIpeSucc');
		break;
		case sap.ui.core.ValueState.Warning:
			rm.addClass('sapUiIpeWarn');
		break;
		default:
		break;
		}

		var tooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oInPlaceEdit, oInPlaceEdit.getTooltip_AsString());
		if (tooltip) {
			rm.writeAttributeEscaped('title', tooltip);
		}

		rm.writeClasses();
		rm.writeStyles();
		rm.write(">"); // DIV
		if (oInPlaceEdit._sOldTextAvailable || oContent.getMetadata().getName() == "sap.ui.commons.Link") {
			// there is an old text available - put content in a extra DIV to position
			// for Link do it always to have the edit button next to the link, but have the defined width for the outer DIV
			rm.write("<DIV");
			rm.addClass("sapUiIpeCont");
			if (oContent.getMetadata().getName() == "sap.ui.commons.ComboBox" || oContent.getMetadata().getName() == "sap.ui.commons.DropdownBox") {
				rm.addClass("sapUiIpeCombo");
			}
			rm.writeClasses();
			rm.write(">"); // DIV

		}
		if (oInPlaceEdit._bEditMode) {
			this.renderEditContent(rm, oInPlaceEdit);
		} else {
			this.renderDisplayContent(rm, oInPlaceEdit);
		}
		if (oInPlaceEdit._sOldTextAvailable || oContent.getMetadata().getName() == "sap.ui.commons.Link") {
			rm.write("</DIV>");
			if (oInPlaceEdit.getUndoEnabled() && oInPlaceEdit._sOldTextAvailable) {
				// there is an old text available and undo enabled - render undo button
				rm.renderControl(oInPlaceEdit._oUndoButton);
			}
		}
		rm.write("</DIV>");
	};

	InPlaceEditRenderer.renderDisplayContent = function(rm, oInPlaceEdit){

		if (oInPlaceEdit._oDisplayControl) {
			rm.renderControl(oInPlaceEdit._oDisplayControl);
			if (oInPlaceEdit.getEditable() && oInPlaceEdit._oDisplayControl.getMetadata().getName() == "sap.ui.commons.Link") {
				rm.renderControl(oInPlaceEdit._oEditButton);
			}
		}

	};

	InPlaceEditRenderer.renderEditContent = function(rm, oInPlaceEdit){

		if (oInPlaceEdit._oEditControl) {
			rm.renderControl(oInPlaceEdit._oEditControl);
		}

	};

	return InPlaceEditRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/InPlaceEditRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.LabelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Label
jQuery.sap.declare('sap.ui.commons.LabelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/LabelRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	
	/**
	 * @author SAP SE
	 * @namespace
	 */
	var LabelRenderer = {
	//	sap.ui.core.Renderer.apply(this, arguments);
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
	 * @param {sap.ui.core.Control} oLabel An object representation of the control that should be rendered.
	 */
	LabelRenderer.render = function(oRenderManager, oLabel) {
		// Some convenience variables.
		var rm = oRenderManager;
		var r = LabelRenderer;
	
		rm.write("<label");
		rm.writeControlData(oLabel);
	
		sap.ui.core.LabelEnablement.writeLabelForAttribute(oRenderManager, oLabel);
		
		var oFor = oLabel._getLabeledControl();
		var sTooltip = oLabel.getTooltip_AsString();
		
		if ((!sTooltip || sTooltip == "") && oFor && oFor.getTooltip_AsString() && oFor.getTooltip_AsString() != "") {
			// If label has no own tooltip use tooltip of the labeled control
			sTooltip = oFor.getTooltip_AsString();
		}
	
		// check whether a 'required' marker is needed
		if ( oLabel.isRequired() ) {
			rm.addClass('sapUiLblReq');
			if (oLabel.getRequiredAtBegin()) {
				rm.addClass('sapUiLblReqBeg');
			} else {
				rm.addClass('sapUiLblReqEnd');
			}
		}
	
		if (sTooltip) {
			rm.writeAttributeEscaped('title', sTooltip);
		}
	
		// Styles
		rm.addClass("sapUiLbl");
		if (oLabel.getDesign() == sap.ui.commons.LabelDesign.Bold) {
			rm.addClass("sapUiLblEmph");
		}
	
		// Text direction
		var sTextDir = oLabel.getTextDirection();
		if (sTextDir) {
			rm.addStyle("direction", sTextDir.toLowerCase());
		}
	
		// Style for text alignment
		var sTextAlign = r.getTextAlign(oLabel.getTextAlign(), sTextDir);
		if (sTextAlign) {
			rm.addStyle("text-align", sTextAlign);
		}
	
		// Style for width
		var sWidth = oLabel.getWidth();
		if (sWidth) {
			rm.addStyle("width", sWidth);
		}
	
		if (!oLabel.getWrapping()) {
			rm.addClass("sapUiLblNowrap");
		}
	
		rm.writeStyles();
		rm.writeClasses();
	
		// Close start tag
		rm.write(">");
	
		// Get image fragment if there is one, and write
		if (oLabel.getIcon()) {
			this.writeImgHtml(rm, oLabel);
		}
	
		// Write the label text
		if (oLabel.getText()) {
			rm.writeEscaped(oLabel.getText());
		}
	
		// Close tag
		rm.write("</label>");
	};
	
	
	LabelRenderer.writeImgHtml = function(oRenderManager, oLabel) {
		var rm = oRenderManager;
		var sIconUrl = oLabel.getIcon();
		var oConfig = oRenderManager.getConfiguration();
		var aClasses = [];
		var mAttributes = {};
	
		aClasses.push("sapUiLblIco");
		if ((oLabel.getTextDirection() == sap.ui.core.TextDirection.RTL && !oConfig.getRTL()) || (oLabel.getTextDirection() == sap.ui.core.TextDirection.LTR && oConfig.getRTL())) {
			// if text direction is different to global text direction, icon margin must be switched.
			aClasses.push("sapUiLblIcoR");
		} else {
			aClasses.push("sapUiLblIcoL");
		}
	
		rm.writeIcon(sIconUrl, aClasses, mAttributes);
	
	};
	
	/**
	 * Dummy inheritance of static methods/functions.
	 * @see sap.ui.core.Renderer.getTextAlign
	 * @private
	 */
	LabelRenderer.getTextAlign = Renderer.getTextAlign;
	

	return LabelRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/LabelRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.LinkRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Link
jQuery.sap.declare('sap.ui.commons.LinkRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/LinkRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @author SAP SE
	 * @namespace
	 */
	var LinkRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oLink An object representation of the control that should be rendered.
	 */
	LinkRenderer.render = function(rm, oLink) {
		// Link is rendered as a "<a>" element
		rm.write("<a");
		rm.writeControlData(oLink);
	
		rm.writeAccessibilityState(oLink);
	
		if (!oLink.getEnabled()) {
			rm.addClass("sapUiLnkDsbl");
			rm.writeAttribute("disabled", "true");
		} else {
			rm.addClass("sapUiLnk");
		}
		rm.writeClasses();
	
		if (oLink.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oLink.getTooltip_AsString());
		}
	
		if (oLink.getHref()) {
			rm.writeAttributeEscaped("href", oLink.getHref());
		}	else {
			/*eslint-disable no-script-url */
			rm.writeAttribute("href", "javascript:void(0);");
			/*eslint-enable no-script-url */
		}
	
		if (oLink.getTarget()) {
			rm.writeAttributeEscaped("target", oLink.getTarget());
		}
	
		if (!oLink.getEnabled()) {
			rm.writeAttribute("tabIndex", "-1");
		} else {
			rm.writeAttribute("tabIndex", "0");
		}
	
		if (oLink.getWidth()) {
			rm.addStyle("width", oLink.getWidth());
		}
		rm.writeStyles();
	
		// Close the opening tag
		rm.write(">");
	
		// Write the Link text
		if (oLink.getText()) {
			rm.writeEscaped(oLink.getText());
		}
	
		// Close the tag
		rm.write("</a>");
	
	};
	

	return LinkRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/LinkRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ListBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ListBox
jQuery.sap.declare('sap.ui.commons.ListBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.strings'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ListBoxRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'jquery.sap.strings'],
	function(jQuery, Renderer/* , jQuerySap */) {
	"use strict";


	/**
	 * ListBox Renderer
	 *
	 * @author d046011
	 * @version 1.28.17
	 * @namespace
	 */
	var ListBoxRenderer = {
	};

	/**
	 * Renders the HTML for the ListBox, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render-output-buffer.
	 * @param {sap.ui.commons.ListBox} oListBox The ListBox control that should be rendered.
	 */
	ListBoxRenderer.render = function(rm, oListBox) {
		var r = ListBoxRenderer;

		// TODO: this is a prototype experimenting with an alternative to onAfterRendering for size calculations and corrections
		// Do not copy this approach for now!
		// Main problem: renderers are supposed to create a string, not DOM elements, e.g. so they could also run on the server. At least that was the idea in former times.
		if (r.borderWidths === undefined) {
			if (!!sap.ui.Device.browser.internet_explorer) { // all known IE versions have this issue (min-width does not include borders)  TODO: update
				var oFakeLbx = document.createElement("div");
				var oStaticArea = sap.ui.getCore().getStaticAreaRef();
				oStaticArea.appendChild(oFakeLbx);
				oFakeLbx.className = "sapUiLbx";
				var $fakeLbx = jQuery(oFakeLbx);
				$fakeLbx.css("width", "50px");
				$fakeLbx.css("min-width", "100px");
				r.borderWidths = oFakeLbx.offsetWidth - 100;
				oStaticArea.removeChild(oFakeLbx);
			} else {
				// all other browsers are fine
				r.borderWidths = 0;
			}
		}

		rm.addClass("sapUiLbx");
		var bStd = true;
		if (!oListBox.getEditable()) {
			rm.addClass("sapUiLbxRo");
			bStd = false;
		}
		if (!oListBox.getEnabled()) {
			rm.addClass("sapUiLbxDis");
			bStd = false;
		}
		if (bStd) {
			rm.addClass("sapUiLbxStd"); // neither readonly nor disabled - this helps the CSS
		}

		// Open the containing <div> tag
		rm.write("<div");

		rm.writeControlData(oListBox);
		rm.writeAttribute("tabindex", "-1");

		var sWidth = oListBox.getWidth();
		if (sWidth) {
			rm.addStyle("width", sWidth);
			var bDisplaySecondaryValues = oListBox.getDisplaySecondaryValues();
			var bDisplayIcons = oListBox.getDisplayIcons();
			if (!bDisplaySecondaryValues && !bDisplayIcons) {
				// if fixed width, no secondary values and no icons use table-layout:fixed; to enable text-overflow:ellipsis;
				// not possible with secondary value / icons because of auto width function of table not available with fixed layout
				rm.addClass("sapUiLbxFixed");
			}
		}

		if (!sWidth || (sWidth == "auto") || (sWidth == "inherit")) {
			rm.addClass("sapUiLbxFlexWidth");
		}

		rm.writeClasses();

		// min/max-widths need fixes in IE
		var sMinWidth = oListBox.getMinWidth();
		var sMaxWidth = oListBox.getMaxWidth();
		if (!!sap.ui.Device.browser.internet_explorer) {
			sMinWidth = r.fixWidth(sMinWidth);
			sMaxWidth = r.fixWidth(sMaxWidth);
		}
		if (sMinWidth) {
			rm.addStyle("min-width", sMinWidth);
		}
		if (sMaxWidth) {
			rm.addStyle("max-width", sMaxWidth);
		}

		if (oListBox._bHeightInItems) {
			if (oListBox._sTotalHeight != null) {
				rm.addStyle("height", oListBox._sTotalHeight); // calculated height available
			} // else height will be calculated and set in onAfterRendering
		} else {
			var sHeight = oListBox.getHeight();
			if (sHeight) {
				rm.addStyle("height", sHeight); // "normal" CSS height
			}
		}
		rm.writeStyles();

		var tooltip = oListBox.getTooltip_AsString();
		if (tooltip) {
			rm.writeAttributeEscaped("title", tooltip);
		}
		rm.write(">");

		this.renderItemList(oListBox, rm);

		rm.write("</div>");
	};

	/**
	 * Renders all items
	 */
	ListBoxRenderer.renderItemList = function (oListBox, rm) {

		// Write the start tag
		rm.write("<ul id='" + oListBox.getId() + "-list'");

		rm.writeAttribute("tabindex", this.getTabIndex(oListBox));

		// add ARIA stuff
		rm.writeAccessibilityState(oListBox, {
			role: "listbox",
			multiselectable: oListBox.getAllowMultiSelect()
		});
		rm.write(">");

		var items = oListBox.getItems(),
			iRealItemIndex = 0, // to not count separators
			iRealItemCount = 0;

		for (var i = 0; i < items.length; i++) { // TODO: required only for ARIA setsize
			if (!(items[i] instanceof sap.ui.core.SeparatorItem)) {
				iRealItemCount++;
			}
		}

		var bDisplaySecondaryValues = oListBox.getDisplaySecondaryValues();

		// Write the rows with the items
		for (var i = 0; i < items.length; i++) {
			var item = items[i];

			if (item instanceof sap.ui.core.SeparatorItem) {
				// draw a separator
				rm.write("<div id='", item.getId(), "' class='sapUiLbxSep' role='separator'><hr/>");

				// colspan is not available, so add more separator cells
				if (oListBox.getDisplayIcons()) {
					rm.write("<hr/>");
				}
				if (bDisplaySecondaryValues) {
					rm.write("<hr/>");
				}
				rm.write("</div>");

			} else {
				// regular ListItem or just a plain Item
				rm.write("<li");
				rm.writeElementData(item);
				rm.writeAttribute("data-sap-ui-lbx-index", i);

				rm.addClass("sapUiLbxI");
				if (!item.getEnabled()) {
					rm.addClass("sapUiLbxIDis");
				}
				rm.writeAttribute("tabindex", "-1"); // make all LIs to focusable elements, tabindex will be changed by ItemNavigation
				if (oListBox.isIndexSelected(i)) {
					rm.addClass("sapUiLbxISel");
				}
				rm.writeClasses();

				// get the text values
				var sText = item.getText();
				var sSecondaryValue = item.getAdditionalText ? item.getAdditionalText() : ""; // allow usage of sap.ui.core.Item

				// tooltip
				if (item.getTooltip_AsString()) {
					rm.writeAttributeEscaped("title", item.getTooltip_AsString());
				} else {
					rm.writeAttributeEscaped("title", sText + ((bDisplaySecondaryValues && sSecondaryValue) ? "  --  " + sSecondaryValue : ""));
				}

				// ARIA
				rm.writeAccessibilityState(item, {
					role: "option",
					selected: (i === oListBox.getSelectedIndex()),
					setsize: iRealItemCount,
					posinset: iRealItemIndex + 1
				});

				rm.write(">");


				// write icon column if required
				if (oListBox.getDisplayIcons()) {
					var sIcon;
					if (item.getIcon) { // allow usage of sap.ui.core.Item
						sIcon = item.getIcon();
					}
					rm.write("<span");
					if (sap.ui.core.IconPool.isIconURI(sIcon)) {
						rm.addClass("sapUiLbxIIco");
						rm.addClass("sapUiLbxIIcoFont");
						var oIconInfo = sap.ui.core.IconPool.getIconInfo(sIcon);
						rm.addStyle("font-family", "'" + oIconInfo.fontFamily + "'");
						if (oIconInfo && !oIconInfo.skipMirroring) {
							rm.addClass("sapUiIconMirrorInRTL");
						}
						rm.writeClasses();
						rm.writeStyles();
						rm.write(">");
						rm.write(oIconInfo.content);
					} else {
						rm.write(" class='sapUiLbxIIco'><img src='");
						// if the item has an icon, use it; otherwise use something empty
						if (sIcon) {
							rm.writeEscaped(sIcon);
						} else {
							rm.write(sap.ui.resource('sap.ui.commons', 'img/1x1.gif'));
						}
						rm.write("'/>");
					}
					rm.write("</span>");
				}

				// write the main text
				rm.write("<span class='sapUiLbxITxt");
				rm.write("'");
				rm.writeAttribute("id", item.getId() + "-txt");
				var sTextAlign = ListBoxRenderer.getTextAlign(oListBox.getValueTextAlign(), null);
				if (sTextAlign) {
					rm.write("style='text-align:" + sTextAlign + "'"); // TODO: check whether the ListBox needs its own textDirection property
				}
				rm.write(">");
				if (sText === "" || sText === null) {
					rm.write("&nbsp;");
				} else {
					rm.writeEscaped(sText);
				}

				// Potentially display second column
				if (bDisplaySecondaryValues) {
					rm.write("</span><span class='sapUiLbxISec");
					rm.write("'");
					var sTextAlign = ListBoxRenderer.getTextAlign(oListBox.getSecondaryValueTextAlign(), null);
					if (sTextAlign) {
						rm.write("style='text-align:" + sTextAlign + "'"); // TODO: check whether the ListBox needs its own textDirection property
					}
					rm.write(">");
					rm.writeEscaped(sSecondaryValue);
				}

				rm.write("</span></li>");
				iRealItemIndex++;
			}
		}

		// Close the surrounding element
		rm.write("</ul>");
	};


	/**
	 * If the given width is set in pixels, this method reduces the pixel width by the known total width of the borders.
	 * Needed for IE which doesn't handle the combination of border-box and min/max-width correctly.
	 * @private
	 */
	ListBoxRenderer.fixWidth = function(sCssWidth) {
		if (ListBoxRenderer.borderWidths > 0) {
			if (sCssWidth && jQuery.sap.endsWithIgnoreCase(sCssWidth, "px")) {
				var iWidth = parseInt(sCssWidth.substr(0, sCssWidth.length - 2), 10);
				var newWidth = iWidth - ListBoxRenderer.borderWidths;
				if (newWidth >= 0) {
					return newWidth + "px";
				}
			}
		}
		return sCssWidth;
	};

	/**
	 * The default TabIndex that should be set for the ListBox as well as for the selected element.
	 * Can be overwritten in extending sub-classes.
	 * @param {sap.ui.commons.ListBox} oListBox
	 * @protected
	 */
	ListBoxRenderer.getTabIndex = function(oListBox) {
		if (oListBox.getEnabled() && oListBox.getEditable()) {
			return 0;
		} else {
			return -1;
		}
	};

	/**
	 * Adapts the item CSS classes after a selection change
	 * @private
	 */
	ListBoxRenderer.handleSelectionChanged = function(oListBox) { // TODO: handle tab stop
		if (oListBox.getDomRef()) {
			var items = oListBox.getItems();
			for (var i = 0, l = items.length; i < l; i++) { // TODO: could take very long for long lists
				if (oListBox.isIndexSelected(i)) {
					items[i].$().addClass("sapUiLbxISel").attr("aria-selected", "true");
				} else {
					items[i].$().removeClass("sapUiLbxISel").attr("aria-selected", "false");
				}
			}
		}
	};

	/**
	 * Set the active descendant of the ListBox to get correct announcements
	 * @private
	 */
	ListBoxRenderer.handleARIAActivedescendant = function(oListBox, iIndex) {
		var $list = oListBox.$("list");
		if ($list.length > 0) {
			var $selectedChild = $list.children("li[data-sap-ui-lbx-index=" + iIndex + "]");
			$list.attr("aria-activedescendant", $selectedChild.attr("id"));
		}
	};

	/**
	 * Dummy inheritance of static methods/functions.
	 * @see sap.ui.core.Renderer.getTextAlign
	 * @private
	 */
	ListBoxRenderer.getTextAlign = Renderer.getTextAlign;


	return ListBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ListBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuBarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MenuBar
jQuery.sap.declare('sap.ui.commons.MenuBarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MenuBarRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	
	/**
	 * MenuBarRenderer.
	 * @namespace
	 */
	var MenuBarRenderer = {
	};
	
	/**
	 * Renders the HTML for the given menubar using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.Toolbar} oToolbar An object representation of the control that should be rendered.
	 */
	MenuBarRenderer.render = function(oRenderManager, oMenuBar) {
		var rm = oRenderManager;
	
		oMenuBar.doBeforeRendering();

		rm.write("<div");
		rm.writeControlData(oMenuBar);
		rm.addClass("sapUiMnuBar");
		if (oMenuBar.getDesign() == sap.ui.commons.MenuBarDesign.Header) {
			rm.addClass("sapUiMnuBarHeader");
		}
		var bIsDisabled = !oMenuBar.getEnabled();
		if (bIsDisabled) {
			rm.addClass("sapUiMnuBarDsbl");
		}
		rm.addStyle("width", oMenuBar.getWidth());
		rm.writeStyles();
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		var sTooltip = oMenuBar.getTooltip_AsString();
		MenuBarRenderer.writeAria(rm, "menubar", sTooltip, bIsDisabled);
		rm.write("><ul");
		rm.writeAttribute("id", oMenuBar.getId() + "-area");
		rm.writeAttribute("class", "sapUiMnuBarArea");
		rm.write(">");
	
		var iVisibleItemIdx = 0;
		var aItems = oMenuBar.getItems();
		for (var i = 0; i < aItems.length; i++) {
			var oItem = aItems[i];
			if (oItem.getVisible()) {
				iVisibleItemIdx++;
				rm.write("<li");
				rm.writeElementData(oItem);
				rm.addClass("sapUiMnuBarItm");
				var bDsbld = !oItem.getEnabled() || bIsDisabled;
				if (bDsbld) {
					rm.addClass("sapUiMnuBarItmDsbl");
				}
				rm.writeClasses();
				rm.writeAttribute("itemidx", "" + i);
				var sTooltip = oItem.getTooltip_AsString();
				MenuBarRenderer.writeAria(rm, "menuitem", sTooltip, bDsbld, iVisibleItemIdx);
				rm.writeAttribute("tabindex", "-1");
				rm.write("><span>");
				rm.writeEscaped(oItem.getText());
				rm.write("</span></li>");
			}
		}
	
		rm.write("<li");
		rm.writeAttribute("id", oMenuBar.getId() + "-ovrflw");
		rm.writeAttribute("itemidx", "ovrflw");
		rm.writeAttribute("style", "display:none;");
		rm.writeAttribute("tabindex", "-1");
		rm.addClass("sapUiMnuBarItm");
		rm.addClass("sapUiMnuBarOvrFlw");
		if (bDsbld) {
			rm.addClass("sapUiMnuBarItmDsbl");
		}
		rm.writeClasses();
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
		var sOverFlowText;
		if (rb) {
			sOverFlowText = rb.getText("MNUBAR_OVRFLW");
		}
		MenuBarRenderer.writeAria(rm, "menuitem", sOverFlowText, false, 0);
		rm.write("><span></span></li></ul></div>");
	};
	
	MenuBarRenderer.writeAria = function(rm, sRole, sText, bDisabled, iIdx){
		if (sText) {
			rm.writeAttributeEscaped("title", sText);
		}
	
		if (!sap.ui.getCore().getConfiguration().getAccessibility()) {
			return;
		}
	
		rm.writeAttribute("role", sRole);
		if (sRole == "menuitem") {
			rm.writeAttribute("aria-haspopup", true);
			rm.writeAttribute("aria-posinset", iIdx);
		}
		if (bDisabled) {
			rm.writeAttribute("aria-disabled", true);
		}
	};

	return MenuBarRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MenuBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MenuButton
jQuery.sap.declare('sap.ui.commons.MenuButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MenuButtonRenderer",['jquery.sap.global', './ButtonRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ButtonRenderer, Renderer) {
	"use strict";


	/**
	 * MenuButton renderer.
	 * For a common look&feel, the MenuButton extends the Button control,
	 * just like the TextField ComboBox works.
	 * @namespace
	 */
	var MenuButtonRenderer = Renderer.extend(ButtonRenderer);
	
	/**
	 * Hint: "renderButtonAttributes" is a reserved/hard-coded Button extending function!
	 *       It is used to allow extensions to display content after the actual button content.
	 * @param {sap.ui.core.RenderManager}
	 *            rm the RenderManager currently rendering this control
	 * @param {sap.ui.commons.MenuButton}
	 *            oControl the MenuButton that should be rendered
	 * @private
	 */
	MenuButtonRenderer.renderButtonAttributes = function(rm, oControl) {
		//Add specific ARIA information for MenuButton
		if (sap.ui.getCore().getConfiguration().getAccessibility()) {
			rm.writeAttribute("aria-haspopup", "true");
		}
	};
	
	/**
	 * Hint: "renderButtonContentAfter" is a reserved/hard-coded Button extending function!
	 *       It is used to allow extensions to display content after the actual button content.
	 * @param {sap.ui.core.RenderManager}
	 *            rm the RenderManager currently rendering this control
	 * @param {sap.ui.commons.MenuButton}
	 *            oControl the MenuButton that should be rendered
	 * @private
	 */
	MenuButtonRenderer.renderButtonContentAfter = function(rm, oControl) {
		rm.write("<span class=\"sapUiMenuButtonIco\"></span>");
	};

	return MenuButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MenuButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuItemBase') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.MenuItemBase'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuItemBase'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MenuItemBase",['jquery.sap.global', 'sap/ui/unified/MenuItemBase'],
	function(jQuery, MenuItemBase) {
	"use strict";


	/**
	 * @class Provides the standard properties for menu items.
	 * @extends sap.ui.unified.MenuItemBase
	 *
	 * @author SAP SE 
	 *
	 * @public
	 * @deprecated Since version 1.21.0. 
	 * Please use the control sap.ui.unified.MenuItemBase of the library sap.ui.unified instead.
	 * @name sap.ui.commons.MenuItemBase
	 */
	
	try {
		sap.ui.getCore().loadLibrary("sap.ui.unified");
	} catch (e) {
		jQuery.sap.log.error("The controls/elements 'sap.ui.commons.Menu*' needs library 'sap.ui.unified'.");
		throw (e);
	}
	
	
	return MenuItemBase;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MenuItemBase.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Menu
jQuery.sap.declare('sap.ui.commons.MenuRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MenuRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/unified/MenuRenderer'],
	function(jQuery, Renderer, MenuRenderer1) {
	"use strict";


	var MenuRenderer = Renderer.extend(MenuRenderer1);

	return MenuRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageBarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MessageBar
jQuery.sap.declare('sap.ui.commons.MessageBarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MessageBarRenderer",['jquery.sap.global', 'sap/ui/core/Popup'],
	function(jQuery, Popup) {
	"use strict";

//jQuery.sap.require("sap.ui.commons.MessageType");
	
	/**
	 * MessageBar renderer.
	 * @namespace
	 */
	var MessageBarRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	MessageBarRenderer.render = function(oRenderManager, oControl){
	  // Convenience variables
		var rm  = oRenderManager;
		var id  = oControl.getId();
	
		// Opening the outer DIV container:
		// (Marking it as "draggable" stops the browser text selection on drag.)
		rm.write('<div draggable="true"');
	  rm.writeControlData(oControl);
	  rm.addClass("sapUiMsgBar");
	  if (this.oDropPosition) {
		// A "re-dock" image will be added if the MessageBar has been dragged.
		rm.addClass("sapUiMsgBarMoved");
	  }
	  rm.writeClasses();
	  rm.write(">");
	
			// Opening the counters&icons DIV container:
			// (An "id" is provided as the Toast will have to right-align against this element.)
			rm.write('<div id="' + id + '__sums" class="sapUiMsgBarSums">');
	
			  // Open-Hide message list arrow:
				// (An "id" is provided as the Toast will have to point-back towards this element.)
				// (This "Arrow" image is state-dependent and theme-dependent.)
				rm.write('<div id="' + id + '__arrowImg" class="sapUiMsgBarToggle"></div>');
	
			  // Error area: Image and Error count.
				// IDs are provided for DOM updates: display:none and count.
				rm.write('<div id="' + id + '__ErrorImg" class="sapUiMsgIcon sapUiMsgIconError sapUiMsgBarZeroCount"></div>');
				rm.write('<span id="' + id + '__ErrorCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');
	
			  // Warning area: Image and Warning count.
				rm.write('<div id="' + id + '__WarningImg" class="sapUiMsgIcon sapUiMsgIconWarning sapUiMsgBarZeroCount"></div>');
				rm.write('<span id="' + id + '__WarningCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');
	
			  // Success area: Image and Success count.
				rm.write('<div id="' + id + '__SuccessImg" class="sapUiMsgIcon sapUiMsgIconSuccess sapUiMsgBarZeroCount"></div>');
				rm.write('<span id="' + id + '__SuccessCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');
	
			// Closing the counters&icons DIV container:
		  rm.write("</div>");
	
		  // Re-dock icon: Appears after Drag&Drop.
			rm.write('<div class="sapUiMsgBarHome"></div>');
	
		// Closing the outer DIV container:
	  rm.write("</div>");
	};

	return MessageBarRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MessageBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MessageList
jQuery.sap.declare('sap.ui.commons.MessageListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MessageListRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * MessageList renderer.
	 * @namespace
	 */
	var MessageListRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	MessageListRenderer.render = function(oRenderManager, oControl){
		// Convenience variable
		var rm = oRenderManager;
	
		// Opening the outer container:
	  rm.write('<ul class="sapUiMsgList"');
	  rm.writeControlData(oControl);
	  rm.write(">");
	
		  // Rendering all supplied messages:
		  // Most recent messages were pushed in last, so looping in reversed order
		  // to display those first.
			for (var i = oControl.aMessages.length - 1; i >= 0; i--) {
			  rm.write('<li class="sapUiMsgListLi">');
			  rm.renderControl(oControl.aMessages[i]);
			  rm.write("</li>");
			} // end for
	
	  // Closing container:
	  rm.write("</ul>");
	};

	return MessageListRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MessageListRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.commons.Message
jQuery.sap.declare('sap.ui.commons.MessageRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MessageRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Message renderer.
	 * @namespace
	 */
	var MessageRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * A "Message" renders with:
	 *  - An icon,
	 *  - Possibly with a "Details" pointer to point to its longText
	 *  - A shortText
	 * It is up to its host (Toast, List, ... ) to hide or not the different parts.
	 * For example, it is for the Toast to decide if icons are to be shown or not! Decision can be theme-dependent!
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	MessageRenderer.render = function(oRenderManager, oControl){
		// Convenience variables
		var rm = oRenderManager;
	
		// Opening the outer container:
		// tabindex="0": Message must be focusable for accessibility?!?
		rm.write('<div class="sapUiMsg" tabindex="0">');
	
		// Message icon:
		rm.write('<div class="sapUiMsgIcon sapUiMsgIcon' + oControl.getType() + '"></div>');
	
		// Possible "Details" pointer, with its trailing "-" separator:
		if ( typeof oControl.fnCallBack === "function" ) {
			rm.write('<span class="sapUiMsgLnk">');
			// Rendering a "short" Link pointing to the "long" Details:
			if (!oControl.oLink) {
				oControl.oLink = new sap.ui.commons.Link();
				var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
				oControl.oLink.setText(rb.getText("MSGLIST_DETAILS"));
				oControl.oLink.attachPress(function() {oControl.openDetails();});
			}
			rm.renderControl(oControl.oLink);
			rm.write(' - </span>');
		}
	
		// ShortText:
		rm.write('<span class="sapUiMsgTxt">');
		rm.writeEscaped(oControl.getText());
		rm.write('</span>');
	
		// Closing the outer container:
		rm.write('</div>');
	};

	return MessageRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MessageRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageToastRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.MessageToast
jQuery.sap.declare('sap.ui.commons.MessageToastRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MessageToastRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * MessageToast renderer.
	 * @namespace
	 */
	var MessageToastRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	MessageToastRenderer.render = function(oRenderManager, oControl){
		// Convenience variable
		var rm = oRenderManager;
	
		// Opening the invisible outer-DIV container:
		// (Required to host the down-arrow.)
		// "classing" as per Type/Priority, for influencing the inner rendering:
		rm.write('<div class="' + oControl.getClasses() + '"');
		rm.writeControlData(oControl);
		rm.write('>');
	
			// Opening the inner-DIV message-container:
			rm.write('<div class="sapUiMsgToastMsg sapUiShd">');
	
				// Checking what message is to be toasted:
			  if (oControl.oMessage) {
				rm.renderControl(oControl.oMessage);
			  } else {
				// No message supplied. Rendering "Multiple new messages...":
					var sMultiMsgs = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("MSGTOAST_MULTI_MSGS");
					rm.write('<div class="sapUiMsg" tabindex="0"><span class="sapUiMsgTxt">' + sMultiMsgs + '</span></div>');
			  }
	
			// Closing the inner-DIV message-container:
			rm.write("</div>");
	
		  // Down-arrow:
			// (An "id" is provided as this arrow will have to point-back towards the right Bar icon.)
			// (This "Arrow" image is Type/Priority-dependent and theme-dependent.)
			rm.write('<div id="' + oControl.getId() + 'Arrow" class="sapUiMsgToastArrow"></div>');
	
		// Closing the invisible outer-DIV container:
		rm.write("</div>");
	};

	return MessageToastRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MessageToastRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.PaginatorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.commons.Paginator
jQuery.sap.declare('sap.ui.commons.PaginatorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/PaginatorRenderer",['jquery.sap.global', 'jquery.sap.encoder'],
	function(jQuery/* , jQuerySap */) {
	"use strict";


	/**
	 * Paginator renderer.
	 * @namespace
	 */
	var PaginatorRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oPaginator an object representation of the control that should be rendered
	 */
	PaginatorRenderer.render = function(oRm, oPaginator){
	
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	
		oRm.write("<div");
		oRm.writeControlData(oPaginator);
		oRm.writeAccessibilityState(oPaginator, {
			role: "toolbar",
			labelledby: oPaginator.getId() + "-accDesc"
		});
		oRm.addClass("sapUiPag");
		oRm.writeClasses();
		oRm.write(">");
	
		oRm.write("<span class='sapUiPagAccDesc' id='" + oPaginator.getId() + "-accDesc'>");
		oRm.writeEscaped(rb.getText("PAGINATOR"));
		oRm.write("</span>");
	
		this.renderPaginator(oRm, oPaginator);
	
		oRm.write("</div>");
	};
	
	
	/**
	 * Builds the paginator
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oPaginator an object representation of the control that should be rendered
	 */
	PaginatorRenderer.renderPaginator = function(oRm, oPaginator) {
		// First check if number of page is 1 or less, in this case, we do not render the paginator
		if (oPaginator.getNumberOfPages() <= 1) {
			return;
		}
	
		// Buffer paginator id for other ids concatenation
		var paginatorId = oPaginator.getId();
		var iCurrentPage = oPaginator.getCurrentPage();
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	
	
		/************************************************************************************
		 * Render the Page 1 (first page link) when necessary, back arrow, back link
		 ************************************************************************************/
		var linkClass = (iCurrentPage == 1) ? "sapUiLnkDsbl" : "sapUiLnk";
		var linkAcc = (iCurrentPage == 1) ? " aria-disabled='true'" : "";
	
		// First page link must only appear when at least 5 pages are available
		if (oPaginator.getNumberOfPages() > 5) {
			oRm.write("<a id='" + paginatorId + "--firstPageLink' href='javascript:void(0);' title='");
			oRm.writeEscaped(rb.getText("FIRST_PAGE"));
			oRm.write("' class='sapUiPagBtn sapUiPagFirst " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
			oRm.writeEscaped(rb.getText("PAGINATOR_OTHER_PAGE", [1]));
			oRm.write("</span></a>");
		}
		oRm.write("<a id='" + paginatorId + "--backLink' href='javascript:void(0);' title='");
		oRm.writeEscaped(rb.getText("PREVIOUS_PAGE"));
		oRm.write("' class='sapUiPagBtn sapUiPagBack " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
		oRm.writeEscaped(rb.getText("BACK"));
		oRm.write("</span></a>");
	
	
	
		/************************************************************************************
		 * Render the page numbers in a list
		 *************************************************************************************/
		oRm.write("<ul id='" + paginatorId + "-pages' role='presentation'>");
		oRm.write(PaginatorRenderer.getPagesHtml(paginatorId, oPaginator._calculatePagesRange(), oPaginator.getCurrentPage(), true));
		oRm.write("</ul>");
	
	
	
		/************************************************************************************
		 * Render the forward link, forward arrow and last page link when necessary
		 *************************************************************************************/
		linkClass = (iCurrentPage == oPaginator.getNumberOfPages()) ? "sapUiLnkDsbl" : "sapUiLnk";
		linkAcc = (iCurrentPage == 1) ? " aria-disabled='true'" : "";
	
		oRm.write("<a id='" + paginatorId + "--forwardLink' href='javascript:void(0);' title='");
		oRm.writeEscaped(rb.getText("NEXT_PAGE"));
		oRm.write("' class='sapUiPagBtn sapUiPagForward " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
		oRm.writeEscaped(rb.getText("FORWARD"));
		oRm.write("</span></a>");
		if (oPaginator.getNumberOfPages() > 5) {
			oRm.write("<a id='" + paginatorId + "--lastPageLink' href='javascript:void(0);' title='");
			oRm.writeEscaped(rb.getText("LAST_PAGE"));
			oRm.write("' class='sapUiPagBtn sapUiPagLast " + linkClass + "' " + linkAcc + "><span class='sapUiPagText'>");
			oRm.writeEscaped(rb.getText("PAGINATOR_OTHER_PAGE", [oPaginator.getNumberOfPages()]));
			oRm.write("</span></a>");
		}
	};
	
	
	PaginatorRenderer.getPagesHtml = function(sPaginatorId, oRange, iCurrent, bVisible) {
		var aHtml = [];
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	
		// each single page link is an <li> with an <a> inside
		for (var i = oRange.firstPage; i <= oRange.lastPage; i++) {
			aHtml.push("<li id='" + sPaginatorId + "-li--" + i + "' class='sapUiPagPage");
			aHtml.push((i == iCurrent) ? " sapUiPagCurrentPage'" : "'");
			if (!bVisible) { // for those items to be animated into view
				aHtml.push(" style='display:none'");
			}
			aHtml.push(">");
			aHtml.push("<a id='" + sPaginatorId + "-a--" + i + "' title='");
			if (i == iCurrent) {
				aHtml.push(jQuery.sap.encodeHTML(rb.getText("PAGINATOR_CURRENT_PAGE", [i])));
			} else {
				aHtml.push(jQuery.sap.encodeHTML(rb.getText("PAGINATOR_OTHER_PAGE", [i])));
			}
			aHtml.push("' href='javascript:void(0);'");
			if (i == iCurrent) {
				aHtml.push(" tabindex='0' class='sapUiLnkDsbl'");
			} else {
				 aHtml.push(" class='sapUiLnk'");
			}
			aHtml.push(">" + i + "</a>"); // TODO: clickable?! onPageClick
			aHtml.push("</li>");
		}
	
		return aHtml.join("");
	};
	
	/**
	 * Updates the back/first/next/last page links
	 * @param {sap.ui.core.Control} oPaginator an object representation of the control that should be updated
	 * @private
	 */
	PaginatorRenderer.updateBackAndForward = function(oPaginator) {
		var page = oPaginator.getCurrentPage();
		var id = oPaginator.getId();
	
		var isFirst = (page == 1);
		var isLast = (page == oPaginator.getNumberOfPages());
	
		var firstPage = jQuery.sap.byId(id + "--firstPageLink").toggleClass("sapUiLnk", !isFirst).toggleClass("sapUiLnkDsbl", isFirst);
		var backLink = jQuery.sap.byId(id + "--backLink").toggleClass("sapUiLnk", !isFirst).toggleClass("sapUiLnkDsbl", isFirst);
		var forwardLink = jQuery.sap.byId(id + "--forwardLink").toggleClass("sapUiLnk", !isLast).toggleClass("sapUiLnkDsbl", isLast);
		var lastPage = jQuery.sap.byId(id + "--lastPageLink").toggleClass("sapUiLnk", !isLast).toggleClass("sapUiLnkDsbl", isLast);
		
		if (isFirst) {
			firstPage.attr("aria-disabled", "true");
			backLink.attr("aria-disabled", "true");
			forwardLink.removeAttr("aria-disabled");
			lastPage.removeAttr("aria-disabled");
		} else if (isLast) {
			firstPage.removeAttr("aria-disabled");
			backLink.removeAttr("aria-disabled");
			forwardLink.attr("aria-disabled", "true");
			lastPage.attr("aria-disabled", "true");
		} else {
			firstPage.removeAttr("aria-disabled");
			backLink.removeAttr("aria-disabled");
			forwardLink.removeAttr("aria-disabled");
			lastPage.removeAttr("aria-disabled");
		}
	};

	return PaginatorRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/PaginatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.PanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Panel
jQuery.sap.declare('sap.ui.commons.PanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/PanelRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @namespace
	 */
	var PanelRenderer = function() {
	};
	
	
	/**
	 * Renders the HTML for the Panel, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered
	 */
	PanelRenderer.render = function(rm, oControl) {
		var id = oControl.getId();
		var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
	
		//var hasToolbar = false; // TODO: this can be used in the future; rendering should already be quite ok, but minor adjustments are expected
	
		var heightSet = sap.ui.commons.Panel._isSizeSet(oControl.getHeight());
		var widthSet = sap.ui.commons.Panel._isSizeSet(oControl.getWidth());
	
		oControl.getScrollTop();  // update the scroll position properties
		oControl.getScrollLeft();
	
	
		// root element and classes
		rm.write("<section");
		rm.writeControlData(oControl);
		rm.addClass("sapUiPanel");
		rm.addStyle("width", oControl.getWidth());
	
		if (!oControl.getCollapsed()) {
			rm.addStyle("height", oControl.getHeight());
		} else {
			rm.addClass("sapUiPanelColl");
			rm.addStyle("height", "auto");
		}
		if (heightSet) {
			rm.addClass("sapUiPanelHeightSet");
		}
		if (widthSet) {
			rm.addClass("sapUiPanelWidthSet");
		}
		if (oControl.getApplyContentPadding()) {
			rm.addClass("sapUiPanelWithPadding");
		}
		if (!oControl.getEnabled()) {
			rm.addClass("sapUiPanelDis");
		}
		if (oControl.getShowCollapseIcon()) {
			rm.addClass("sapUiPanelWithCollapseIcon");
		}
		rm.addClass("sapUiPanelBorderDesign" + oControl.getBorderDesign());
		rm.addClass("sapUiPanelAreaDesign" + oControl.getAreaDesign());
		rm.writeClasses();
		rm.writeStyles();
	
		if (accessibility) {
			rm.writeAttribute("aria-labelledby", id + "-title ");
			rm.writeAttribute("aria-describedby", id + "-acc");
			rm.writeAttribute("role", "region");
			if (oControl.getCollapsed()) {
				rm.writeAttribute("aria-expanded", "false");
			} else {
				rm.writeAttribute("aria-expanded", "true");
			}
			rm.writeAttribute("tabindex", "0");
		}
	
		// tooltip of Panel
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
	
	
		// header
		rm.write("><header id='" + id + "-hdr'");
		rm.addClass("sapUiPanelHdr");
	
		// tooltip of Title, might be set in addition
		var oTitle = oControl.getTitle();
		var sTitleTooltip;
		var sLevel = sap.ui.core.TitleLevel.H5; // to be compatible of size
		var bEmphasized = true;
		if (oTitle) {
			sTitleTooltip = oTitle.getTooltip_AsString();
			if (sTitleTooltip) {
				rm.writeAttributeEscaped("title", sTitleTooltip);
			}
	
			if (oTitle.getLevel() != sap.ui.core.TitleLevel.Auto) {
				// if title level is set use emphasized of title, otherwise use default one to be compatible
				sLevel = oTitle.getLevel();
				bEmphasized = oTitle.getEmphasized();
			}
		}
		if (bEmphasized) {
			rm.addClass("sapUiPanelHdrEmph");
		}
	
		rm.writeClasses();
		rm.write(">");
		
		if (oControl.getShowCollapseIcon() && accessibility) {
			rm.write("<span id=\"" + id + "-acc\" style=\"display:none;\">");
			rm.writeEscaped(oControl._rb.getText("PANEL_HEAD_ACC"));
			rm.write("</span>");
		}
	
		var sCollapseTooltip = oControl._rb.getText(oControl.getCollapsed() ? "PANEL_EXPAND" : "PANEL_COLLAPSE");
		if (oControl.getShowCollapseIcon()) { /* TODO: remove this one and rearrange the other in CSS */
			rm.write("<a id='" + id + "-collArrow' class='sapUiPanelHdrItem sapUiPanelCollArrow' href='javascript:void(0)' tabindex='0' title='" + sCollapseTooltip + "'");
			if (accessibility) {
				//rm.writeAttribute("aria-labelledby", id + "-title");
				rm.writeAttribute("role", "button");
			}
			rm.write(">&nbsp;</a>");
		}
	
	
		// IMPORTANT: title h1 is always rendered to simplify calculations and because having no title should be a rare use-case
		// if (oTitle) {
		if (oTitle && oTitle.getIcon()) {
			// header icon, if available
			var sIcon = oTitle.getIcon();
			var aClasses = [];
			var mAttributes = {};
	
			mAttributes["id"] = id + "-ico";
			aClasses.push("sapUiPanelIco");
			aClasses.push("sapUiPanelHdrItem");
			aClasses.push("sapUiTv" + sLevel); // use same font-size like header level (if icon font is used (for image it dosn't matters)
	
			rm.writeIcon(sIcon, aClasses, mAttributes);
		}
	
		// header title text
		var text = jQuery.sap.escapeHTML(oControl.getText());
		if (!text) {
			text = "&nbsp;";
		}
		// just reuse TextView class because there font size & co. is already defined
		rm.write("<" + sLevel + " ");
		rm.addClass("sapUiTv" + sLevel);
	//	rm.write("<h1 id='" + id + "-title' class='sapUiPanelHdrItem sapUiPanelTitle'");
		rm.write(" id='" + id + "-title' ");
		rm.addClass("sapUiPanelHdrItem");
		rm.addClass("sapUiPanelTitle");
		rm.writeClasses();
		if (accessibility) {
			rm.writeAttribute("role", "heading");
		}
		rm.write(">");
		rm.write(text); // already escaped!
	//	rm.write("</h1>");
		rm.write("</" + sLevel + ">");
	
	
	  // toolbar + buttons
	  var aButtons = oControl.getButtons();
	  if (aButtons && (aButtons.length > 0)) {
		rm.write("<div id='" + id + "-tb' class='sapUiPanelHdrItem sapUiPanelTb sapUiTbDesignFlat'>");
	
		for (var i = 0; i < aButtons.length; i++) {
			rm.renderControl(aButtons[i]);
		}
	
			rm.write("</div>");
	  }
	
	
	  // any other right-aligned buttons go like this:
	  // <a id="firstIcoRight" class="sapUiPanelHdrRightItem sapUiPanel*">O</a>
	  // the positioning among these items needs to be solved then, either by fixed CSS classes if there are few items (like Right1 Right2)
	  // or maybe they need to be put into a nowrap div
	
	  // collapse icon
	  if (oControl.getShowCollapseIcon()) {
			rm.write("<a id='" + id + "-collIco' class='sapUiPanelHdrRightItem sapUiPanelCollIco' href='javascript:void(0)' tabindex='0' title='" + sCollapseTooltip + "'");
			if (accessibility) {
				//rm.writeAttribute("aria-labelledby", id + "-title");
				rm.writeAttribute("role", "button");
			}
			rm.write(">&nbsp;</a>");
		}
	
	  rm.write("</header>");
	
	
	
		// content area
	
		// everything below the header is only rendered initially if not collapsed - saves performance and Panel just re-renders later on expand
		if (!oControl.getCollapsed()) {
			rm.write("<div class='sapUiPanelCont' id='", id, "-cont'>");
	
			// Content (child controls)
			var oControls = oControl.getContent(),
					iLength = oControls.length;
			for (var i = 0; i < iLength; i++) {
				rm.renderControl(oControls[i]);
			}
	
			rm.write("</div>");
		}
	
		rm.write("</section>");
	};

	return PanelRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/PanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ProgressIndicatorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ProgressIndicator
jQuery.sap.declare('sap.ui.commons.ProgressIndicatorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ProgressIndicatorRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ProgressIndicator renderer.
	 * @namespace
	 */
	var ProgressIndicatorRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
	 */
	ProgressIndicatorRenderer.render = function(oRenderManager, oProgressIndicator){
		// .convenience variable
		var rm = oRenderManager;
		var widthControl = oProgressIndicator.getWidth();
		var widthBar = oProgressIndicator.getPercentValue();
		var tooltip = oProgressIndicator.getTooltip_AsString();
		var displayValue = oProgressIndicator.getDisplayValue();
		var widthBorder;

		oProgressIndicator.bRtl  = sap.ui.getCore().getConfiguration().getRTL();

		if (widthBar > 100) {
			widthBorder = (10000 / widthBar) + '%';
		} else {
			widthBorder = '100%';
		}

		// write the HTML into the render manager
		rm.write('<DIV');
		rm.writeControlData(oProgressIndicator);

		rm.writeAttribute('tabIndex', '0');

		//ARIA
		if ( sap.ui.getCore().getConfiguration().getAccessibility()) {
			rm.writeAttribute('role', 'progressbar');
			rm.writeAccessibilityState(oProgressIndicator, {valuemin: '0%'});
			rm.writeAccessibilityState(oProgressIndicator, {valuemax: '100%'});
			rm.writeAccessibilityState(oProgressIndicator, {valuenow: widthBar + '%'});
		}

		if (displayValue) {
			rm.writeAttributeEscaped('aria-valuetext', displayValue);
		}

		if (tooltip) {
			rm.writeAttributeEscaped('title', tooltip);
		}

		if (oProgressIndicator.getWidth() && oProgressIndicator.getWidth() != '') {
			rm.writeAttribute('style', 'height: 16px; width:' + widthControl + ';');
		}

		rm.addClass('sapUiProgInd');
		rm.writeClasses();

		rm.write('>');

		rm.write('<DIV');
		rm.writeAttribute('id', oProgressIndicator.getId() + '-box');

		if (oProgressIndicator.getWidth() && oProgressIndicator.getWidth() != '') {
			rm.writeAttribute('style', 'height: 16px; width:' + widthBorder + ';');
		}

		rm.addClass('sapUiProgIndBorder');
		rm.writeClasses();

		rm.write('>');

		rm.write('<DIV');
		rm.writeAttribute('id', oProgressIndicator.getId() + '-bar');
		rm.writeAttribute('onselectstart', "return false");
		rm.writeAttribute('style', 'height: 14px; width:' + oProgressIndicator.getPercentValue() + '%;');

		var sBarColor = oProgressIndicator.getBarColor();
		switch (sBarColor) {
			case "POSITIVE":
				rm.addClass('sapUiProgIndBarPos');
				break;
			case "NEGATIVE":
				rm.addClass('sapUiProgIndBarNeg');
				break;
			case "CRITICAL":
				rm.addClass('sapUiProgIndBarCrit');
				break;
			case "NEUTRAL":
				rm.addClass('sapUiProgIndBar');
				break;
			default:
				rm.addClass('sapUiProgIndBar');
				break;
		}

		rm.writeClasses();

		rm.write('>');

		rm.write('<DIV');
		rm.writeAttribute('id', oProgressIndicator.getId() + '-end');

		if (widthBar > 100) {
			switch (sBarColor) {
				case "POSITIVE":
					rm.addClass('sapUiProgIndPosEnd');
					break;
				case "NEGATIVE":
					rm.addClass('sapUiProgIndNegEnd');
					break;
				case "CRITICAL":
					rm.addClass('sapUiProgIndCritEnd');
					break;
				case "NEUTRAL":
					rm.addClass('sapUiProgIndEnd');
					break;
				default:
					rm.addClass('sapUiProgIndEnd');
					break;
			}
		} else {
			rm.addClass('sapUiProgIndEndHidden');
		}

		rm.writeClasses();
		if (oProgressIndicator.bRtl) {
			rm.writeAttribute('style', 'position: relative; right:' + widthBorder);
		} else {
			rm.writeAttribute('style', 'position: relative; left:' + widthBorder);
		}

		rm.write('>');
		rm.write('</DIV>');

		rm.write('<SPAN');

		rm.addClass('sapUiProgIndFont');
		rm.writeClasses();

		rm.write('>');

		if (oProgressIndicator.getShowValue() && oProgressIndicator.getShowValue() == true) {
			if (oProgressIndicator.getDisplayValue() && oProgressIndicator.getDisplayValue() != '') {
				rm.writeEscaped(oProgressIndicator.getDisplayValue());
			}
		}

		rm.write('</SPAN>');
		rm.write('</DIV>');
		rm.write('</DIV>');
		rm.write('</DIV>');
	};

	return ProgressIndicatorRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ProgressIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButtonGroupRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RadioButtonGroup
jQuery.sap.declare('sap.ui.commons.RadioButtonGroupRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RadioButtonGroupRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * RadioButtonGroup renderer.
	 * @namespace
	 */
	var RadioButtonGroupRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	RadioButtonGroupRenderer.render = function(oRenderManager, oRBGroup){
		// convenience variable
		var rm = oRenderManager;
	
		// Return immediately if control has no RadioButtons
		if (!oRBGroup.aRBs) {
			return;
		}
	
		var iColumns = oRBGroup.getColumns();
		var bEnabled = oRBGroup.getEnabled();
	
		if (bEnabled) {
			// check if at least one item is enabled
			var aItems = oRBGroup.getItems();
			bEnabled = false;
			for ( var i = 0; i < aItems.length; i++) {
				if (aItems[i].getEnabled()) {
					bEnabled = true;
					break;
				}
			}
		}
	
		rm.write("<DIV");
		rm.writeControlData(oRBGroup);
		rm.addClass("sapUiRbG");
		if (iColumns > 1) {
			if (iColumns == oRBGroup.aRBs.length) {
				rm.addClass("sapUiRbG1Row");
			} else {
				rm.addClass("sapUiRbGTab");
				if (oRBGroup.getWidth() && oRBGroup.getWidth() != '') {
					rm.addClass("sapUiRbGTabFlex");
					// as in Firefox -moz-box-flex > 0 brings ellipsis even if no width is given
					// therefore flexible columns should be only used if a width is given.
				}
			}
		}
	
		if (oRBGroup.getWidth() && oRBGroup.getWidth() != '') {
			rm.addStyle("width", oRBGroup.getWidth());
		}
	
		if (oRBGroup.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oRBGroup.getTooltip_AsString());
		}
	
		if (bEnabled) {
			rm.writeAttribute('tabindex', '0');
		} else {
			rm.writeAttribute('tabindex', '-1');
		}
	
		// ARIA
		rm.writeAccessibilityState(oRBGroup, {
			role: "radiogroup",
			invalid: oRBGroup.getValueState() == sap.ui.core.ValueState.Error,
			disabled: !oRBGroup.getEditable()
		});
	
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">"); // DIV
	
		// columns
		for (var c = 0; c < iColumns; c++) {
			if (iColumns > 1 && iColumns != oRBGroup.aRBs.length) {
				// if only 1 column -> no DIV necessary
				rm.write("<DIV");
				rm.addClass("sapUiRbGCol");
				rm.writeClasses();
				rm.write(">"); // DIV element
			}
	
			// render RadioButtons
			for (var i = c; i < oRBGroup.aRBs.length; i = i + iColumns) {
				rm.renderControl(oRBGroup.aRBs[i]);
			}
	
			if (iColumns > 1 && iColumns != oRBGroup.aRBs.length) {
				rm.write("</DIV>");
			}
		}
	
		if (iColumns > 1 && iColumns != oRBGroup.aRBs.length) {
			// dummy Column to avoid big spaces between RadioButtons in Safari
			rm.write('<DIV class="sapUiRbGDummy"> </DIV>');
		}
	
		rm.write("</DIV>");
	};

	return RadioButtonGroupRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RadioButtonGroupRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RadioButton
jQuery.sap.declare('sap.ui.commons.RadioButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RadioButtonRenderer",['jquery.sap.global', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, ValueStateSupport) {
	"use strict";


	/**
	 * RadioButton Renderer
	 *
	 * @author d046011
	 * @namespace
	 */
	var RadioButtonRenderer = {
	};
	
	/**
	 * Renders the HTML for the RadioButton, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.RadioButton} oRadioButton The RadioButton control that should be rendered.
	 */
	RadioButtonRenderer.render = function(rm, oRadioButton) {
		var sId = oRadioButton.getId();
		var tooltip = oRadioButton.getTooltip_AsString();
	
		rm.addClass("sapUiRb");
	
		// Open the containing <span> tag
		rm.write("<span");
		rm.writeControlData(oRadioButton);
	
		// ARIA
		rm.writeAccessibilityState(oRadioButton, {
			role: "radio",
			checked: oRadioButton.getSelected() === true,
			invalid: oRadioButton.getValueState() == sap.ui.core.ValueState.Error,
			disabled: !oRadioButton.getEditable(),
			labelledby: sId + "-label",
			describedby: tooltip ? sId + "-Descr" : undefined
		});
	
		// Collect state information
		var enabled = oRadioButton.getEnabled() != null && oRadioButton.getEnabled();
		var editable = oRadioButton.getEditable() != null && oRadioButton.getEditable();
		var inErrorState = false;
		var inWarningState = false;
		if (oRadioButton.getValueState() != null) {
			inErrorState = sap.ui.core.ValueState.Error == oRadioButton.getValueState();
			inWarningState = sap.ui.core.ValueState.Warning == oRadioButton.getValueState();
		}
	
		// Add classes and properties depending on the state
		if (oRadioButton.getSelected()) {
			rm.addClass("sapUiRbSel");
		}
	
		var myTabIndex = 0;
		var bReadOnly = false;
	
		if (!enabled) {
			myTabIndex = -1;
			bReadOnly = true;
			rm.addClass("sapUiRbDis");
		}
		if (!editable) {
			//myTabIndex = -1; //According to CSN2581852 2012 a readonly RB should be in the tabchain
			bReadOnly = true;
			rm.addClass("sapUiRbRo");
		}
		if (inErrorState) {
			rm.addClass("sapUiRbErr");
		} else if (inWarningState) {
			rm.addClass("sapUiRbWarn");
		}
		if (enabled && editable && !inErrorState && !inWarningState) {
			rm.addClass("sapUiRbStd");
		}
		if (enabled && editable) {
			rm.addClass("sapUiRbInteractive");
		}
		rm.writeClasses();
	
		if (oRadioButton.getWidth() && oRadioButton.getWidth() != '') {
			rm.writeAttribute("style", "width:" + oRadioButton.getWidth() + ";");
		}
	
		rm.writeAttribute("tabIndex", myTabIndex);
	
		var tooltipToUse = ValueStateSupport.enrichTooltip(oRadioButton, tooltip ? tooltip : oRadioButton.getText());
		if (tooltipToUse) {
			rm.writeAttributeEscaped("title", tooltipToUse);
		}
	
		rm.write(">"); // Close the containing <span> tag
	
	
		// Write the real - potentially hidden - HTML RadioButton element
		rm.write("<input type='radio' tabindex='-1' id='");
		rm.write(sId);
		rm.write("-RB' name=\"");
		rm.writeEscaped(oRadioButton.getGroupName());
		rm.write("\" ");
		if (oRadioButton.getSelected()) {
			rm.write(" checked='checked'");
		}
		if (!enabled) {
			rm.write(" disabled='disabled'");
		}
		if (bReadOnly) {
			rm.write(" readonly='readonly'");
			rm.write(" disabled='disabled'");
		}
		if (oRadioButton.getKey()) {
			rm.writeAttributeEscaped("value", oRadioButton.getKey());
		}
	
		rm.write(" />"); // Close RadioButton-input-element
	
	
		// Write the RadioButton label which also holds the background image
		rm.write("<label id=\"" + sId + "-label\"");
		rm.writeAttribute("for", sId + "-RB"); // Label for RadioButton, so a click toggles the state
		if (!oRadioButton.getText()) {
			rm.write(" class=\"sapUiRbNoText\"");
		}
		rm.write(">");
		if (oRadioButton.getText()) {
			this.renderText(rm, oRadioButton.getText(), oRadioButton.getTextDirection());
		}
		rm.write("</label>");
	
		if (tooltip) {
			// for ARIA the tooltip must be in a separate SPAN and assigned via aria-describedby.
			// otherwise JAWS do not read it.
			rm.write("<span id=\"" + sId + "-Descr\" style=\"visibility: hidden; display: none;\">");
			rm.writeEscaped(tooltip);
			rm.write("</span>");
		}
		// Close the surrounding <span> element
		rm.write("</span>");
	};
	
	/**
	 * Write RadioButton label - either flat, or, in case the text direction is different from the environment, within a <span> with an explicit "dir".
	 */
	RadioButtonRenderer.renderText = function(oRenderManager, sText, eTextDirection) {
		var rm = oRenderManager;
		if (!eTextDirection || eTextDirection == sap.ui.core.TextDirection.Inherit) {
			rm.writeEscaped(sText);
		} else {
			rm.write("<span style=\"direction:" + eTextDirection.toLowerCase() + ";\">");
			rm.writeEscaped(sText);
			rm.write("</span>");
		}
	};
	
	RadioButtonRenderer.setSelected = function(oRadioButton, bSelected) {
	
		oRadioButton.$().toggleClass('sapUiRbSel', bSelected).attr('aria-checked', bSelected);
		var $Dom = oRadioButton.getDomRef("RB");
		if (bSelected) {
			$Dom.checked = true;
			$Dom.setAttribute('checked', 'checked');
		} else {
			$Dom.checked = false;
			$Dom.removeAttribute('checked');
		}
	
	};
	

	return RadioButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RadioButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RatingIndicatorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RatingIndicator
jQuery.sap.declare('sap.ui.commons.RatingIndicatorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RatingIndicatorRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * RatingIndicatorRenderer.
	 * @namespace
	 */
	var RatingIndicatorRenderer = function() {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oRating an object representation of the control that should be rendered
	 */
	RatingIndicatorRenderer.render = function(oRenderManager, oRating) {
		var rm = oRenderManager;
		var iNumberOfSymbols = oRating.getMaxValue();
	
		rm.write("<div");
		rm.writeControlData(oRating);
		rm.addClass("sapUiRating");
		if (oRating.getEditable()) {
			rm.addClass("sapUiRatingEdit");
		}
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0"/*oRating.getEditable() ? "0" : "-1"*/); //According to CSN 2581852 2012 the RI should always be in the tabchain
		if (oRating.getTooltip() && oRating.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oRating.getTooltip_AsString());
		} else if (!oRating.getEditable()) {
			rm.writeAttribute("title", oRating._getDisplayValue());
		}
	
		//ARIA
		rm.writeAccessibilityState(oRating, {
			"role": "slider",
			"orientation": "horizontal",
			"valuemin": 1,
			"valuemax": iNumberOfSymbols,
			"disabled": !oRating.getEditable(),
			"live": "assertive"
		});
	
		rm.write(">");
	
		for (var i = 0; i < iNumberOfSymbols; i++) {
			RatingIndicatorRenderer.renderItem(rm, oRating, i, oRating._getDisplayValue());
		}
	
		rm.write("</div>");
	};
	
	/**
	 * Helper function to render a rating symbol.
	 * @private
	 */
	RatingIndicatorRenderer.renderItem = function(rm, oRating, i, fValue){
		var val = i + 1;
		rm.write("<div");
		rm.writeAttribute("id", oRating.getId() + "-itm-" + val);
		rm.writeAttribute("itemvalue", val);
		rm.writeAttribute("class", "sapUiRatingItm");
		rm.writeAttribute("style", "line-height:0px;");
		if (!oRating.getTooltip() && oRating.getEditable()) {
			//rm.writeAttribute("dir", "ltr"); //Do we need this to avoid tooltips like "of 5 3" instead of "3 of 5"
			rm.writeAttributeEscaped("title", oRating._getText("RATING_TOOLTIP" , [val, oRating.getMaxValue()]));
		}
		rm.write(">");
	
		rm.write("<img");
		rm.writeAttribute("class", "sapUiRatingItmImg");
		var sIcon = RatingIndicatorRenderer.getThemeSymbol("selected", oRating);
		rm.writeAttributeEscaped("src", sIcon);
		rm.write("/>");
	
		rm.write("<div");
		rm.writeAttribute("class", "sapUiRatingItmOvrflw");
	
		var visualMode = oRating.getVisualMode();
		if (visualMode == "Full") {
			fValue = Math.round(fValue);
		}
		var style;
		if (fValue >= val) {
			style = "width:0%;";
		} else if (fValue < i) {
			style = "width:100%;";
		} else {
			var diff = fValue - i;
			if (visualMode == "Half") {
				var width = 50;
				if (diff < 0.25) {
					width = 100;
				}
				if (diff >= 0.75) {
					width = 0;
				}
				style = "width:" + width + "%;";
			} else { //Continuous
				style = "width:" + (100 - Math.round(diff * 100)) + "%;";
			}
		}
		rm.writeAttribute("style", style);
		rm.write(">");
	
		rm.write("<img");
		rm.writeAttribute("class", "sapUiRatingItmOvrflwImg");
		sIcon = RatingIndicatorRenderer.getThemeSymbol("unselected", oRating);
		rm.writeAttributeEscaped("src", sIcon);
		rm.write("/>");
	
		rm.write("</div>");
		rm.write("</div>");
	};
	
	/**
	 * Helper function to render a rating symbol in hover state.
	 *
	 * @param {int} iCount the number of the rating image which should be hovered.
	 * @param {sap.ui.core.Control} oRating an object representation of the control that should be rendered
	 * @param {boolean} bAfter specifies whether the rating image is behind the hovered one.
	 * @private
	 */
	RatingIndicatorRenderer.hoverRatingSymbol = function(iCount, oRating, bAfter){
		var oSymbol = jQuery.sap.byId(oRating.getId() + "-itm-" + iCount);
		oSymbol.addClass("sapUiRatingItmHov");
		var oSymbolImage = oSymbol.children("img");
		var sIcon = RatingIndicatorRenderer.getThemeSymbol(bAfter ? "unselected" : "hover", oRating);
		oSymbolImage.attr("src", sIcon);
	};
	
	/**
	 * Helper function to render a rating symbol in normal (selected/deselected) state.
	 *
	 * @param {int} iCount the number of the rating image which should be unhovered.
	 * @param {sap.ui.core.Control} oRating an object representation of the control that should be rendered
	 * @private
	 */
	RatingIndicatorRenderer.unhoverRatingSymbol = function(iCount, oRating){
		var oSymbol = jQuery.sap.byId(oRating.getId() + "-itm-" + iCount);
		oSymbol.removeClass("sapUiRatingItmHov");
		var oSymbolImage = oSymbol.children("img");
		var sIcon = RatingIndicatorRenderer.getThemeSymbol("selected", oRating);
		oSymbolImage.attr("src", sIcon);
	};
	
	/**
	 * Helper function to find the right symbol.
	 *
	 * @param {string} sType type of desired image (selected, unselected, hover)
	 * @param {sap.ui.core.Control} oRating an object representation of the control that should be rendered
	 * @private
	 */
	RatingIndicatorRenderer.getThemeSymbol = function(sType, oRating){
		var sIcon, sParam;
	
		if (sType == "selected") {
			sIcon = oRating.getIconSelected();
			sParam = "sap.ui.commons.RatingIndicator:sapUiRatingSymbolSelected";
		} else if (sType == "unselected") {
			sIcon = oRating.getIconUnselected();
			sParam = "sap.ui.commons.RatingIndicator:sapUiRatingSymbolUnselected";
		} else {
			sIcon = oRating.getIconHovered();
			sParam = "sap.ui.commons.RatingIndicator:sapUiRatingSymbolHovered";
		}
	
		if (!sIcon) {
			var sThemePath =
				"themes/" +
				sap.ui.getCore().getConfiguration().getTheme() + "/" +
				sap.ui.core.theming.Parameters.get(sParam);
	
			// The documentation states that sap.ui.resource() should be used for theme-URLs
			sIcon = sap.ui.resource("sap.ui.commons", sThemePath);
		}
	
		return sIcon;
	};

	return RatingIndicatorRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RatingIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ResponsiveContainerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ResponsiveContainer
jQuery.sap.declare('sap.ui.commons.ResponsiveContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ResponsiveContainerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * RatingIndicatorRenderer.
	 * @namespace
	 */
	var ResponsiveContainerRenderer = function() {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oRating an object representation of the control that should be rendered
	 */
	ResponsiveContainerRenderer.render = function(oRenderManager, oContainer) {
		var oRM = oRenderManager,
			oContent = oContainer.getAggregation("content");
		oRM.write("<div ");
		oRM.writeControlData(oContainer);
		oRM.addStyle("width", oContainer.getWidth());
		oRM.addStyle("height", oContainer.getHeight());
		oRM.writeStyles();
		oRM.write(">");
		if (oContent) {
			oRM.renderControl(oContent);
		}
		// Render divs for each range into an invisible area to get the actual pixel width
		// for arbitrary CSS sizes (em, ex, rem, etc...)
		oRM.write("<div ");
		oRM.addStyle("width", "0px");
		oRM.addStyle("height", "0px");
		oRM.addStyle("overflow", "hidden");
		oRM.writeStyles();
		oRM.write(">");
		jQuery.each(oContainer.getRanges(), function(i, oRange) {
			oRM.write("<div ");
			oRM.writeElementData(oRange);
			oRM.addStyle("width", oRange.getWidth());
			oRM.addStyle("height", oRange.getHeight());
			oRM.writeStyles();
			oRM.write("></div>");
		});
		oRM.write("</div>");
		oRM.write("</div>");
	};

	return ResponsiveContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ResponsiveContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RichTooltipRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RichTooltip
jQuery.sap.declare('sap.ui.commons.RichTooltipRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RichTooltipRenderer",['jquery.sap.global', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, ValueStateSupport) {
	"use strict";


	/**
	 * RichToltip renderer.
	 * @namespace
	 */
	var RichTooltipRenderer = {};
	
	/**
	 * Renders the HTML for the RichTooltip, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oRichTooltip An object representation of the control that should be rendered.
	 */
	RichTooltipRenderer.render = function(rm, oRichTooltip){
		var sId = oRichTooltip.getId();
	
		// Header
		rm.write("<div ");
		rm.writeControlData(oRichTooltip);
		rm.addClass("sapUiRtt");
		rm.writeClasses();
		rm.write(" ><div><div>");
		rm.write("<div class='sapUiRttTopL'></div><div class='sapUiRttTopR'></div>");
		rm.write("<div class='sapUiRttCL'>");
		rm.write("<div class='sapUiRttCR'>");
		
		rm.write("<div class='sapUiRttContent'>");
	
		// Title
		var sTitle = oRichTooltip.getTitle();
		if (sTitle) {
			rm.write("<div id='" + sId + "-title' role='tooltip' class='sapUiRttTitle'>");
			rm.writeEscaped(sTitle);
			rm.write("</div>");
			// render a separator between title and rest of the RichTooltip
			rm.write("<div class='sapUiRttSep'></div>");
		}
	
		// if the parent element has a set ValueState render the corresponding text and image
		var sValueStateText = ValueStateSupport.getAdditionalText(oRichTooltip.getParent());
		
		// render the individual ValueState text (if available) otherwise use the default text
		var sIndividualText = oRichTooltip.getAggregation("individualStateText");
		
		// if there is any (from parent control or from RTT itself) value state text set
		if (sValueStateText || sIndividualText) {
			rm.write('<div class="sapUiRttValueStateContainer">');
			
			// only if the owner of the RTT has a value state - render state and image
			if (sValueStateText) {
				var sValueState = oRichTooltip.getParent().getValueState();
				var sValueStateImage = sValueState !== sap.ui.core.ValueState.None ? "ValueState_" + sValueState + ".png" : "";
	
				// if there is a proper value state -> render corresponding image
				if (sValueStateImage !== "") {
					sValueStateImage = jQuery.sap.getModulePath("sap.ui.commons", '/')
					+ "themes/"
					+ sap.ui.getCore().getConfiguration().getTheme()
					+ "/img/richtooltip/" + sValueStateImage;
				
					rm.write('<img id="' + sId + '-valueStateImage" class="sapUiRttValueStateImage" src="');
					rm.writeEscaped(sValueStateImage);
					rm.write('"/>');
				}
			}
		
			if (sIndividualText) {
				rm.renderControl(sIndividualText);
			} else {
				rm.write('<div id="' + sId + '-valueStateText" class="sapUiRttValueStateText">');
				rm.writeEscaped(sValueStateText);
				rm.write('</div>');
			}
			
			rm.write('</div>');
			
			// render a separator between ValueState stuff and text of the RichTooltip
			rm.write("<div class='sapUiRttSep'></div>");
		}
		
		
		rm.write('<div class="sapUiRttContentContainer">');
		// render image that might be set
		var sImage = oRichTooltip.getImageSrc();
		if (sImage) {
			var sAltText = oRichTooltip.getImageAltText();
			rm.write('<img id="' + sId + '-image" alt="' + sAltText + '" class="sapUiRttImage" src="');
			rm.writeEscaped(sImage);
			rm.write('"/>');
		}
		
		// render RichTooltip's text
		var oText = oRichTooltip.getAggregation("formattedText");
		if (oText) {
			rm.renderControl(oText);
		}
		rm.write('</div>');
	
		// render footer
		rm.write("</div></div></div>");
		rm.write("<div class='sapUiRttBotL'></div>");
		rm.write("<div class='sapUiRttBotR'></div>");
		rm.write("</div></div></div>");
	};

	return RichTooltipRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RichTooltipRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RoadMapRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RoadMap
jQuery.sap.declare('sap.ui.commons.RoadMapRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RoadMapRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	
	
	/**
	 * RoadMap renderer.
	 * @namespace
	 */
	var RoadMapRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @private
	 */
	RoadMapRenderer.render = function(oRenderManager, oRoadMap){
		var rm = oRenderManager;
	
		oRoadMap.doBeforeRendering(); //Inform the Roadmap that the rendering starts

		rm.write("<div");
		rm.writeControlData(oRoadMap);
		rm.addClass("sapUiRoadMap");
		rm.writeClasses();
		rm.writeAttribute("tabIndex", "0");
	
		var sTooltip = oRoadMap.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
	
		rm.writeAttribute("style", "width:" + (oRoadMap.getWidth() ? oRoadMap.getWidth() : "100%") + ";");
	
		rm.write(">");
	
		renderDelimiter(rm, oRoadMap, true);
	
		rm.write("<ul");
		rm.writeAttribute("id", oRoadMap.getId() + "-steparea");
		rm.addClass("sapUiRoadMapStepArea");
		rm.writeClasses();
	
		//ARIA
		if (sap.ui.getCore().getConfiguration().getAccessibility()) {
			rm.writeAttribute("role", "group");
			rm.writeAttributeEscaped("aria-label", getText("RDMP_DEFAULT_TOOLTIP", []));
			if (sTooltip) {
				rm.writeAttributeEscaped("title", sTooltip);
			}
		}
	
		rm.write(">");
	
		var aSteps = oRoadMap.getSteps();
		for (var i = 0; i < aSteps.length; i++) {
			var oStep = aSteps[i];
			if (oStep.getSubSteps().length > 0) { //is expandable?
				renderExpandableStep(rm, oRoadMap, oStep);
			} else {
				renderStep(rm, oRoadMap, oStep);
			}
		}
	
		rm.write("</ul>");
	
		renderDelimiter(rm, oRoadMap, false);
	
		rm.write("</div>");
	};
	
	
	/**
	 * Updates the CSS classes of the Roadmap to select a new step.
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {string} sId the ID of the step which should be selected.
	 * @private
	 */
	RoadMapRenderer.selectStepWithId = function(oRoadMap, sId){
		var sCurrentId = oRoadMap.getSelectedStep();
		if (sCurrentId) {
			jQuery.sap.byId(sCurrentId).removeClass("sapUiRoadMapSelected");
		}
		if (sId) {
			jQuery.sap.byId(sId).addClass("sapUiRoadMapSelected");
		}
		if (sap.ui.getCore().getConfiguration().getAccessibility()) {
			if (sCurrentId) {
				jQuery.sap.byId(sCurrentId + "-box").removeAttr("aria-checked");
			}
			if (sId) {
				jQuery.sap.byId(sId + "-box").attr("aria-checked", true);
			}
		}
	};
	
	
	/**
	 * Updates the CSS classes of the Roadmap when a step is selected. If the step is an
	 * expandable step the exapnd state is toggled.
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @see <code>sap.ui.commons.RoadMapRenderer.selectStepWithId</code>
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {sap.ui.core.Element} oStep the step which was selected.
	 * @param {boolean} bIsSubStep indicator whether the given step is a sub step or not.
	 * @param {boolean} bSkipAnim indicator whether animation should be used or not.
	 * @param {function} fEndCallBack callback function which is called in the end with a string parameter indicating the operation which was done ("expanded", "collapsed", "selected")
	 * @param {boolean} bSkipSelect indicator whether selection state should be switched or not.
	 * @private
	 */
	RoadMapRenderer.selectStep = function(oRoadMap, oStep, bIsSubStep, bSkipAnim, fEndCallBack, bSkipSelect){
		if (!bSkipSelect) {
			//Select the step
			RoadMapRenderer.selectStepWithId(oRoadMap, oStep.getId());
		}
		if (!bIsSubStep && oStep.getSubSteps().length > 0) {
			//Expandable step -> Toggle the expand state
	
			var aSteps = oStep.getSubSteps();
			var jDomRef = oStep.$();
			var bIsExpanded = jDomRef.hasClass("sapUiRoadMapExpanded"); //Get the current expand state
	
			var iCounter = 1; //Must be in the end 0 when all animations are done (see fDoOnAnimComplete)
	
			var fDoOnAnimComplete = function(){ //Function called when an animation is done
				iCounter--;
				if (iCounter > 0) {
					return;
				}
	
				//Only do something if the last animation finishs
				if (fEndCallBack) {
					fEndCallBack(!bIsExpanded ? "expanded" : "collapsed");
				}
				RoadMapRenderer.updateStepArea(oRoadMap);
			};
	
			//Animation function to hide / show a step (depending on the current expand state)
			var fAnim = function(sId, bOpen, fComplete){
				var jRef = jQuery.sap.byId(sId);
				if (!jQuery.fx.off && !bSkipAnim) { //Animation only if turned on globally and if should not be skipped
					jRef.width(bOpen ? "0px" : oRoadMap.iStepWidth);
					var oLabel = jQuery.sap.byId(sId + "-label");
					oLabel.addClass("sapUiRoadMapHidden");
					if (bOpen) {
						jRef.toggleClass("sapUiRoadMapHidden");
					}
					jRef.animate({width: bOpen ? oRoadMap.iStepWidth : "0px"}, "fast", function(){
						if (!bOpen) {
							jRef.toggleClass("sapUiRoadMapHidden");
						}
						jRef.width("");
						oLabel.removeClass("sapUiRoadMapHidden");
						if (fComplete) {
							fComplete();
						}
					});
				} else {
					jRef.toggleClass("sapUiRoadMapHidden");
					if (fComplete) {
						fComplete();
					}
				}
			};
	
			//Change the expand state of the step immediately
			jDomRef.toggleClass("sapUiRoadMapExpanded");
	
			if (sap.ui.getCore().getConfiguration().getAccessibility()) {
				var bExp = jDomRef.hasClass("sapUiRoadMapExpanded");
				oStep.$("box").attr("aria-expanded", bExp);
				oStep.$("expandend-box").attr("aria-expanded", bExp);
			}
	
			//Hide / Show the sub steps
			for (var i = 0; i < aSteps.length; i++) {
				if (aSteps[i].getVisible()) {
					iCounter++;
					fAnim(aSteps[i].getId(), !bIsExpanded, fDoOnAnimComplete);
				}
			}
			//Hide / Show the end step
			fAnim(oStep.getId() + "-expandend", !bIsExpanded, fDoOnAnimComplete);
		} else {
			if (fEndCallBack) {
				fEndCallBack("selected");
			}
		}
	};
	
	
	/**
	 * Recalculates the width of the step area and updates the delimiters.
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @private
	 */
	RoadMapRenderer.updateStepArea = function(oRoadMap){
		if (oRoadMap.iStepWidth != -1) {
			var jStepAreaRef = oRoadMap.$("steparea");
			var jStartDelimRef = oRoadMap.$("Start");
			var jEndDelimRef = oRoadMap.$("End");
			var jRoadMapRef = oRoadMap.$();
	
			var iScrollLeft = jStepAreaRef.scrollLeft();
	
			var iAvailableSpaceForSteps = jRoadMapRef.width() - jStartDelimRef.outerWidth(true) - jEndDelimRef.outerWidth(true);
			var iMaxVisibleSteps = oRoadMap.getNumberOfVisibleSteps();
			var iCurrentMaxVisibleSteps = getNumberOfPotentiallyVisibleSteps(oRoadMap);
			if (iMaxVisibleSteps < 1) {
				iMaxVisibleSteps = iCurrentMaxVisibleSteps;
			} else {
				iMaxVisibleSteps = Math.min(iMaxVisibleSteps, iCurrentMaxVisibleSteps);
			}
	
			var iPossibleSteps = Math.floor(iAvailableSpaceForSteps / oRoadMap.iStepWidth);
			var iNumberOfVisibleSteps = Math.min(iMaxVisibleSteps, iPossibleSteps);
			jStepAreaRef.width(iNumberOfVisibleSteps * oRoadMap.iStepWidth).scrollLeft(iScrollLeft);
	
			updateDelimiters(oRoadMap);
		}
	};
	
	
	/**
	 * Recalculates the width of the step area and updates the delimiters and sets the
	 * focus either to the specified first visible step of the Roadmap (if not exists the first visible
	 * step is focused).
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @see <code>sap.ui.commons.RoadMapRenderer.updateStepArea</code>
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {boolean} bSkipScrollState if false the function does the same as <code>sap.ui.commons.RoadMapRenderer.updateStepArea</code>
	 * @private
	 */
	RoadMapRenderer.updateScrollArea = function(oRoadMap, bSkipScrollState){
		RoadMapRenderer.updateStepArea(oRoadMap);
		if (!bSkipScrollState) {
			var jStepArea = oRoadMap.$("steparea");
			var oPos = getStepEndPosition(oRoadMap, false);
			if (oRoadMap.getFirstVisibleStep()) {
				var jStep = jQuery.sap.byId(oRoadMap.getFirstVisibleStep());
				if (jStep.length) {
					oPos = getPositionLeft(jStepArea, jStep);
				}
			}
			updateScrollState(oRoadMap, oPos + getRTLFactor() * jStepArea.scrollLeft(), true);
		}
	};
	
	
	/**
	 * Checks whether the step with the given Id is currently in the visible part of the scroll area.
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {string} sId the ID of the step which should be checked.
	 * @private
	 */
	RoadMapRenderer.isVisibleRef = function(oRoadMap, sId){
		var jStepArea = oRoadMap.$("steparea");
		var jStepAreaChildren = jStepArea.children(":visible");
		for (var i = 0; i < jStepAreaChildren.length; i++) {
			var jChild = jQuery(jStepAreaChildren.get(i));
			if (jChild.attr("id") == sId) {
				var iPos = getPositionLeft(jStepArea, jChild);
				return iPos >= 0 && iPos < jStepArea.width();
			}
		}
		return false;
	};
	
	
	/**
	 * Returns the Id of the first step in the visible part of the scroll area.
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @private
	 */
	RoadMapRenderer.getFirstVisibleRef = function(oRoadMap){
		var jStepArea = oRoadMap.$("steparea");
		var jStepAreaChildren = jStepArea.children(":visible");
		for (var i = 0; i < jStepAreaChildren.length; i++) {
			var jChild = jQuery(jStepAreaChildren.get(i));
			if (getPositionLeft(jStepArea, jChild) == 0) {
				return jChild;
			}
		}
		return null;
	};
	
	
	/**
	 * Updates the label text of the given step
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Element} oStep the Step for which the label should be changed.
	 * @param {string} sLabel the new label.
	 * @private
	 */
	RoadMapRenderer.setStepLabel = function(oStep, sLabel){
		var l = sLabel ? jQuery.sap.escapeHTML(sLabel) : "";
		oStep.$("label").html(l);
		oStep.$("expandend-label").html(l);
		
		if (!sap.ui.getCore().getConfiguration().getAccessibility()) {
			return;
		}
		
		oStep.$("box").attr("aria-label", getAriaLabel(oStep, sLabel));
		oStep.$("expandend-box").attr("aria-label", getAriaLabel(oStep, sLabel));
	};
	
	
	/**
	 * Updates the enabled state of the given step
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {sap.ui.core.Element} oStep the Step for which the state should be changed.
	 * @param {boolean} bEnabled the enabled state.
	 * @private
	 */
	RoadMapRenderer.setStepEnabled = function(oRoadMap, oStep, bEnabled){
		var jRef = oStep.$();
		var jRef2 = oStep.$("expandend");
		if (bEnabled) {
			jRef.removeClass("sapUiRoadMapDisabled");
			jRef2.removeClass("sapUiRoadMapDisabled");
			if (sap.ui.getCore().getConfiguration().getAccessibility()) {
				oStep.$("box").removeAttr("aria-disabled");
				oStep.$("expandend-box").removeAttr("aria-disabled");
			}
			return false;
		} else {
			var bSelected = oRoadMap.getSelectedStep() == oStep.getId();
			if (bSelected) {
				jRef.removeClass("sapUiRoadMapSelected");
			}
			jRef.addClass("sapUiRoadMapDisabled");
			jRef2.addClass("sapUiRoadMapDisabled");
			if (sap.ui.getCore().getConfiguration().getAccessibility()) {
				var jRefBox = oStep.$("box");
				jRefBox.attr("aria-disabled", true);
				if (bSelected) {
					jRefBox.removeAttr("aria-checked");
				}
				oStep.$("expandend-box").attr("aria-disabled", true);
			}
			return bSelected;
		}
	};
	
	
	/**
	 * Updates the visible state of the given step
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {sap.ui.core.Element} oStep the Step for which the state should be changed.
	 * @param {boolean} bIsSubStep indicates whether the given step is a substep or not
	 * @param {boolean} bVisible the visible state.
	 * @private
	 */
	RoadMapRenderer.setStepVisible = function(oRoadMap, oStep, bIsSubStep, bVisible){
		var jRef = oStep.$();
		var jRef2 = oStep.$("expandend");
		var bSelected = oRoadMap.getSelectedStep() == oStep.getId();
	
		var oParent = oStep.getParent();
		if (bIsSubStep) {
			if (oParent.getEnabled() && oParent.getVisible() && oParent.getExpanded()) {
				if (bVisible) {
					jRef.removeClass("sapUiRoadMapHidden");
				} else {
					jRef.addClass("sapUiRoadMapHidden");
				}
			}
		} else {
			if (bVisible) {
				jRef.removeClass("sapUiRoadMapHidden");
			} else {
				jRef.addClass("sapUiRoadMapHidden");
			}
	
			var aSteps = oStep.getSubSteps();
			if (aSteps.length > 0 && oStep.getExpanded()) {
				if (bVisible) {
					jRef2.removeClass("sapUiRoadMapHidden");
				} else {
					jRef2.addClass("sapUiRoadMapHidden");
				}
	
				for (var i = 0; i < aSteps.length; i++) {
					if (aSteps[i].getVisible()) {
						var jRef3 = aSteps[i].$();
						if (oRoadMap.getSelectedStep() == aSteps[i].getId()) {
							bSelected = true;
							jRef3.removeClass("sapUiRoadMapSelected");
							aSteps[i].$("box").removeAttr("aria-checked");
						}
						if (bVisible) {
							jRef3.removeClass("sapUiRoadMapHidden");
						} else {
							jRef3.addClass("sapUiRoadMapHidden");
						}
					}
				}
			}
		}
	
		return bSelected;
	};
	
	
	/**
	 * Updates the width of the Roadmap
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {string} sWidth the new width.
	 * @private
	 */
	RoadMapRenderer.setRoadMapWidth = function(oRoadMap, sWidth){
		var jRef = oRoadMap.$();
		jRef.attr("style", "width:" + (sWidth ? sWidth : "100%") + ";");
	};
	
	
	/**
	 * Scrolls according to the given direction.
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @see <code>sap.ui.commons.RoadMapRenderer.getFirstVisibleRef</code>
	 *
	 * @param {sap.ui.core.Control} oRoadMap the Roadmap control for which the renderer action should be performed
	 * @param {string} sDir the scroll direction (allowed are "next", "prev", "first", "last")
	 * @param {function} fEndCallBack callback function which is called in the end with a string parameter indicating the id of the new first visible step
	 * @private
	 */
	RoadMapRenderer.scrollToNextStep = function(oRoadMap, sDir, fEndCallBack){
		var oPos = sDir;
		if (sDir == "first" || sDir == "last") {
			oPos = getStepEndPosition(oRoadMap, sDir == "last");
		}
		updateScrollState(oRoadMap, oPos, false, fEndCallBack);
	};
	
	
	/**
	 * Shortens the label of the given step and adds ellipses if necessary
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Element} oStep the Step for which the label should be adapted
	 * @private
	 */
	RoadMapRenderer.addEllipses = function(oStep){
		if (!oStep) {
			return;
		}
	
		var jStepLabel = oStep.$("label");
		var sOriginalText = oStep.getLabel();
		var sText = sOriginalText + "";
	
		var jClone = jQuery("<label class=\"sapUiRoadMapTitle\" style=\"display:none;position:absolute;overflow:visible;font-weight:bold;height:auto\">" + sText + "</label>");
		jClone.width(jStepLabel.width());
		jQuery(sap.ui.getCore().getStaticAreaRef()).append(jClone);
	
		var bIsShortened = false;
		while (sText.length > 0 && jClone.height() > jStepLabel.height()) {
			//TODO: Do we need special RTL handling here?
			sText = sText.substr(0, sText.length - 1);
			jClone.html(jQuery.sap.escapeHTML(sText + "..."));
			bIsShortened = true;
		}
	
		if (bIsShortened) {
			jStepLabel.html("<span>" + jQuery.sap.escapeHTML(sText) + "</span>");
			jStepLabel.attr("title", oStep.getLabel());
		} else {
			jStepLabel.attr("title", getStepTooltip(oStep));
		}
	
		jClone.remove();
	};
	
	
	/**
	 * Updates the ARIA properties of the steps on the same level as the given step.
	 * (Attention: This function should only be called by the Roadmap control itself).
	 *
	 * @param {sap.ui.core.Element} oStep the Step.
	 * @private
	 */
	RoadMapRenderer.updateStepAria = function(oStep){
		if (!sap.ui.getCore().getConfiguration().getAccessibility()) {
			return;
		}
		var bIsTopLevel = oStep.getParent() instanceof sap.ui.commons.RoadMap;
		var aSteps = oStep.getParent()[bIsTopLevel ? "getSteps" : "getSubSteps"]();
		for (var i = 0; i < aSteps.length; i++) {
			var sPosInSet = getAriaPosInSet(aSteps[i]);
			var sSetSize = getAriaSetSize(aSteps[i]);
			var jStepBox = aSteps[i].$("box");
			jStepBox.attr("aria-posinset", sPosInSet);
			jStepBox.attr("aria-setsize", sSetSize);
			if (bIsTopLevel && aSteps[i].getSubSteps().length > 0) {
				jStepBox = aSteps[i].$("expandend-box");
				jStepBox.attr("aria-posinset", sPosInSet);
				jStepBox.attr("aria-setsize", sSetSize);
			}
		}
	};
	
	
	//********* Private *********
	
	
	//Writes the delimiter HTML into the rendermanger
	var renderDelimiter = function(rm, oRoadMap, bStart){
		var sType = bStart ? "Start" : "End";
		rm.write("<div");
		rm.writeAttribute("id", oRoadMap.getId() + "-" + sType);
		rm.writeAttribute("tabindex", "-1");
		var hasHiddenSteps = true; //Simply assume that there are hidden steps -> updated later (see function updateScrollState)
		rm.addClass(hasHiddenSteps ? "sapUiRoadMap" + sType + "Scroll" : "sapUiRoadMap" + sType + "Fixed");
		rm.addClass("sapUiRoadMapDelim");
		rm.addClass("sapUiRoadMapContent");
		rm.writeClasses();
		rm.write("></div>");
	};
	
	
	//Writes the step HTML into the rendermanger
	var renderStep = function(rm, oRoadMap, oStep, aAdditionalClasses, fAddAdditionalBoxContent, sId){
		rm.write("<li");
		if (sId) { //Write the given Id if available, otherwise use writeControlData
			rm.writeAttribute("id", sId);
		} else {
			rm.writeElementData(oStep);
		}
		var sStepName = getStepName(oRoadMap, oStep);
		oStep.__stepName = sStepName;
		var sTooltip = getStepTooltip(oStep);
	
		rm.addClass("sapUiRoadMapContent");
		rm.addClass("sapUiRoadMapStep");
		if (!oStep.getVisible()) {
			rm.addClass("sapUiRoadMapHidden");
		}
		if (oStep.getEnabled()) {
			if (oRoadMap.getSelectedStep() == oStep.getId()) {
				rm.addClass("sapUiRoadMapSelected");
			}
		} else {
			rm.addClass("sapUiRoadMapDisabled");
		}
		if (aAdditionalClasses) { //Write additional CSS classes if available
			for (var i = 0; i < aAdditionalClasses.length; i++) {
				rm.addClass(aAdditionalClasses[i]);
			}
		}
		rm.writeClasses();
	
		rm.write(">");
	
		renderAdditionalStyleElem(rm, sId ? sId : oStep.getId(), 1);
	
		rm.write("<div");
		rm.writeAttribute("id", (sId ? sId : oStep.getId()) + "-box");
		rm.writeAttribute("tabindex", "-1");
		rm.addClass("sapUiRoadMapStepBox");
		rm.writeClasses();
		rm.writeAttributeEscaped("title", sTooltip);
	
		writeStepAria(rm, oRoadMap, oStep, fAddAdditionalBoxContent ? true : false);
	
		rm.write("><span>");
		rm.write(sStepName);
		rm.write("</span>");
	
		//Call callback function to render additional content
		if (fAddAdditionalBoxContent) {
			fAddAdditionalBoxContent(rm, oRoadMap, oStep);
		}
	
		rm.write("</div>");
	
		rm.write("<label");
		rm.writeAttribute("id", (sId ? sId : oStep.getId()) + "-label");
		rm.addClass("sapUiRoadMapTitle");
		rm.writeAttributeEscaped("title", sTooltip);
		rm.writeClasses();
		rm.write(">");
		var sLabel = oStep.getLabel();
		if (sLabel) {
			rm.writeEscaped(sLabel);
		}
		rm.write("</label>");
	
		renderAdditionalStyleElem(rm, sId ? sId : oStep.getId(), 2);
	
		rm.write("</li>");
	};
	
	
	//Returns the tooltip of the given step
	var getStepTooltip = function(oStep){
		var sTooltip = oStep.getTooltip_AsString();
		if (!sTooltip && !oStep.getTooltip() && sap.ui.getCore().getConfiguration().getAccessibility()) {
			sTooltip = getText("RDMP_DEFAULT_STEP_TOOLTIP", [oStep.__stepName]);
		}
		return sTooltip || "";
	};
	
	
	//Writes the additonal style HTML into the rendermanger (see renderStep)
	var renderAdditionalStyleElem = function(rm, sId, iIdx){
		rm.write("<div");
		rm.writeAttribute("id", sId + "-add" + iIdx);
		rm.addClass("sapUiRoadMapStepAdd" + iIdx);
		rm.writeClasses();
		rm.write("></div>");
	};
	
	
	//Writes the ARIA properties of a step
	var writeStepAria = function(rm, oRoadMap, oStep, bIsExpandable){
		if (!sap.ui.getCore().getConfiguration().getAccessibility()) {
			return;
		}
	
		rm.writeAttribute("role", "treeitem");
	
		if (oStep.getEnabled()) {
			rm.writeAttribute("aria-checked", oRoadMap.getSelectedStep() == oStep.getId());
		} else {
			rm.writeAttribute("aria-disabled", true);
		}
		rm.writeAttribute("aria-haspopup", bIsExpandable);
		rm.writeAttribute("aria-level", oStep.getParent() instanceof sap.ui.commons.RoadMap ? 1 : 2);
		
		rm.writeAttribute("aria-posinset", getAriaPosInSet(oStep));
		rm.writeAttribute("aria-setsize", getAriaSetSize(oStep));
		rm.writeAttributeEscaped("aria-label", getAriaLabel(oStep, oStep.getLabel()));
	
		if (!bIsExpandable) {
			return;
		}
	
		rm.writeAttribute("aria-expanded", oStep.getExpanded());
	};
	
	
	//Computes how the aria-label property should be set for the given step
	var getAriaLabel = function(oStep, sLabel){
		var bIsExpandable = oStep.getParent() instanceof sap.ui.commons.RoadMap && oStep.getSubSteps().length > 0;
		
		var sResult = sLabel || "";
		if (oStep.getEnabled()) {
			sResult = getText(bIsExpandable ? "RDMP_ARIA_EXPANDABLE_STEP" : "RDMP_ARIA_STANDARD_STEP", [sResult]);
		}
		
		return sResult;
	};
	
	
	//Computes how the aria-posinset property should be set for the given step
	var getAriaPosInSet = function(oStep){
		var bIsTopLevel = oStep.getParent() instanceof sap.ui.commons.RoadMap;
		var iIdx = oStep.getParent()[bIsTopLevel ? "indexOfStep" : "indexOfSubStep"](oStep);
		var iCountInvisible = 0;
		var aSteps = oStep.getParent()[bIsTopLevel ? "getSteps" : "getSubSteps"]();
		for (var i = 0; i < iIdx; i++) {
			if (!aSteps[i].getVisible()) {
				iCountInvisible++;
			}
		}
		return iIdx + 1 - iCountInvisible;
	};
	
	
	//Computes how the aria-setsize property should be set for the given step
	var getAriaSetSize = function(oStep){
		var bIsTopLevel = oStep.getParent() instanceof sap.ui.commons.RoadMap;
		var aSteps = oStep.getParent()[bIsTopLevel ? "getSteps" : "getSubSteps"]();
		var iCount = aSteps.length;
		for (var i = 0; i < aSteps.length; i++) {
			if (!aSteps[i].getVisible()) {
				iCount--;
			}
		}
		return iCount;
	};
	
	
	//Writes the step HTML of the expandable step and its children into the rendermanger
	var renderExpandableStep = function(rm, oRoadMap, oStep){
		var fCreateIcon = function(rm, oRoadMap, sId, sIcon, sAdditonalClass){
			rm.write("<div");
			rm.writeAttribute("id", sId + "-ico");
			rm.addClass("sapUiRoadMapStepIco");
			if (sAdditonalClass) {
				rm.addClass(sAdditonalClass);
			}
			rm.writeClasses();
			rm.write("></div>");
		};
	
		var bIsExpanded = oStep.getExpanded();
	
		//Render the start step with an additional icon
		renderStep(rm, oRoadMap, oStep, bIsExpanded ? ["sapUiRoadMapExpanded"] : null, function(rm, oRoadMap, oStep){
			fCreateIcon(rm, oRoadMap, oStep.getId(), bIsExpanded ? "roundtripstart.gif" : "roundtrip.gif");
		});
	
		//Render the sub steps
		var aSteps = oStep.getSubSteps();
		for (var i = 0; i < aSteps.length; i++) {
			var aClasses = ["sapUiRoadMapSubStep"];
			if (!bIsExpanded && aSteps[i].getVisible()) {
				aClasses.push("sapUiRoadMapHidden");
			}
			renderStep(rm, oRoadMap, aSteps[i], aClasses);
		}
	
		//Render the end step with an additional icon
		aClasses = ["sapUiRoadMapExpanded", "sapUiRoadMapStepEnd"];
		if (!bIsExpanded) {
			aClasses.push("sapUiRoadMapHidden");
		}
		renderStep(rm, oRoadMap, oStep, aClasses, function(rm, oRoadMap, oStep){
			fCreateIcon(rm, oRoadMap, oStep.getId() + "-expandend", "roundtripend.gif");
		}, oStep.getId() + "-expandend");
	};
	
	
	//Returns the name of the step according to its index in the aggregation (like "1", "a", "aa")
	var getStepName = function(oRoadMap, oStep){
		var oParent = oStep.getParent();
		if (oParent === oRoadMap) {
			return oParent.indexOfStep(oStep) + 1;
		}
	
		var iIdx = oParent.indexOfSubStep(oStep);
	
		if (iIdx < 26) {
			return String.fromCharCode(97 + iIdx);
		} // Single character
	
		//Double characters Substeps name are formed of 2 letters (e.g. "aa"). -> so overall 702 substeps possible
		var firstCharIdx = Math.floor(iIdx / 26) - 1;
		var secondCharIdx = iIdx % 26;
		return String.fromCharCode(97 + firstCharIdx, 97 + secondCharIdx);
	};
	
	
	//Refreshs teh delimiters according to the current scroll state
	var updateDelimiters = function(oRoadMap){
		var iRTLFactor = getRTLFactor();
	
		var jStepArea = oRoadMap.$("steparea");
	
		var iScrollLeft = getScrollLeft(jStepArea);
	
		var jStartDelim = oRoadMap.$("Start");
		jStartDelim.removeClass("sapUiRoadMapStartScroll").removeClass("sapUiRoadMapStartFixed");
		jStartDelim.addClass(iRTLFactor * iScrollLeft >= oRoadMap.iStepWidth ? "sapUiRoadMapStartScroll" : "sapUiRoadMapStartFixed");
	
		var jEndDelim = oRoadMap.$("End");
		jEndDelim.removeClass("sapUiRoadMapEndScroll").removeClass("sapUiRoadMapEndFixed");
		var bEndReached = jStepArea.get(0).scrollWidth - iRTLFactor * iScrollLeft - jStepArea.width() < oRoadMap.iStepWidth;
		jEndDelim.addClass(bEndReached ? "sapUiRoadMapEndFixed" : "sapUiRoadMapEndScroll");
	};
	
	
	//Returns the translatable text according to the given key and arguments
	var getText = function(sKey, aArgs) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
		if (rb) {
			return rb.getText(sKey, aArgs);
		}
		return sKey;
	};
	
	
	//Returns the number of steps which currently could be visible
	//(Must be visible and for substeps the parent must be expanded)
	var getNumberOfPotentiallyVisibleSteps = function(oRoadMap){
		var counter = 0;
		var aSteps = oRoadMap.getSteps();
		for (var i = 0; i < aSteps.length; i++) {
			if (aSteps[i].getVisible()) {
				counter++;
				if (aSteps[i].getExpanded()) {
					counter++; //End of Expanded Step
					var aSubSteps = aSteps[i].getSubSteps();
					for (var j = 0; j < aSubSteps.length; j++) {
						if (aSubSteps[j].getVisible()) {
							counter++;
						}
					}
				}
			}
		}
		return counter;
	};
	
	
	//Returns the position left attribute of the given step within the scroll area
	var getPositionLeft = function(jStepArea, jStep){
		var iPos = jStep.position().left;
		if (sap.ui.getCore().getConfiguration().getRTL()) { //Recompute in RTL case
			iPos = jStepArea.width() - iPos - jStep.outerWidth();
		}
		return iPos;
	};
	
	
	//Returns a factor which is needed in some browsers in RTL mode to make the position and scroll calculations running:
	//Scrolling in RTL is quite strange in the different browsers:
	//  -Firefox: right side has scrollleft=0, scrolling is indicated with negative values
	//  -IE:      right side has scrollleft=0, scrolling is indicated with positive values
	//  -Safari:  left side has scrollleft=0, scrolling is indicated with positive values
	var getRTLFactor = function(){
		return sap.ui.getCore().getConfiguration().getRTL() && !!!sap.ui.Device.browser.internet_explorer ? -1 : 1;
	};
	
	
	//Calculates the scroll left attribute (with fix for Safari in RTL mode) to make the position and scroll calculations running
	//(see comment on getRTLFactor for RTL behavior)
	var getScrollLeft = function(jStepArea){
		if (sap.ui.getCore().getConfiguration().getRTL() && !!sap.ui.Device.browser.webkit) {
			return ( -1) * (jStepArea.get(0).scrollWidth - jStepArea.scrollLeft() - jStepArea.width());
		}
		return jStepArea.scrollLeft();
	};
	
	
	//Calculates the position of the fisrt/last step (with fix for Safari in RTL mode) to make the position and scroll calculations running
	//(see comment on getRTLFactor for RTL behavior)
	var getStepEndPosition = function(oRoadMap, bLast){
		var iScrollWidth = oRoadMap.$("steparea").get(0).scrollWidth;
		if (sap.ui.getCore().getConfiguration().getRTL() && !!sap.ui.Device.browser.webkit) {
			return bLast ? 0 : ( -1) * iScrollWidth;
		}
		return bLast ? iScrollWidth : 0;
	};
	
	
	//Scrolls to the given position
	var updateScrollState = function(oRoadMap, iNewPos, bSkipAnim, fEndCallBack){
		var jStepArea = oRoadMap.$("steparea");
		jStepArea.stop(false, true);
	
		if (iNewPos == "next") {
			iNewPos = jStepArea.scrollLeft() + oRoadMap.iStepWidth * getRTLFactor();
		} else if (iNewPos == "prev") {
			iNewPos = jStepArea.scrollLeft() - oRoadMap.iStepWidth * getRTLFactor();
		} else if (iNewPos == "keep") {
			iNewPos = jStepArea.scrollLeft();
		} else {
			iNewPos = iNewPos * getRTLFactor();
		}
	
		var fDoAfterScroll = function(){
			updateDelimiters(oRoadMap);
	
			if (fEndCallBack) {
				var jFirstVisibleRef = RoadMapRenderer.getFirstVisibleRef(oRoadMap);
				fEndCallBack(jFirstVisibleRef.attr("id"));
			}
		};
	
		if (!jQuery.fx.off && !bSkipAnim) {
			jStepArea.animate({scrollLeft: iNewPos}, "fast", fDoAfterScroll);
		} else {
			jStepArea.scrollLeft(iNewPos);
			fDoAfterScroll();
		}
	};
	
	
	

	return RoadMapRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RoadMapRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SearchFieldRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.SearchField
jQuery.sap.declare('sap.ui.commons.SearchFieldRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/SearchFieldRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * SearchField renderer.
	 * @namespace
	 */
	var SearchFieldRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	SearchFieldRenderer.render = function(oRenderManager, oControl){
	    var rm = oRenderManager;

	    rm.write("<div");
	    rm.writeControlData(oControl);
	    rm.addClass("sapUiSearchField");
	    if (!oControl.getEditable() || !oControl.getEnabled()) {
			rm.addClass("sapUiSearchFieldDsbl");
	    }
	    if (!oControl.hasListExpander()) {
			rm.addClass("sapUiSearchFieldNoExp");
	    }
	    if (oControl.getEnableClear()) {
			rm.addClass("sapUiSearchFieldClear");
	    }
	    if (oControl.getWidth()) {
			rm.addStyle("width", oControl.getWidth());
	    }
	    if (oControl.getValue()) {
				rm.addClass("sapUiSearchFieldVal");
	    }
	    rm.writeClasses();
	    rm.writeStyles();
	
		/*rm.writeAccessibilityState(null, {
			//role: "search",
			owns: oControl._ctrl.getId() + (oControl.getShowExternalButton() ? (" "+oControl._btn.getId()) : "")
		});*///CSN 1076183 2013: ARIA owns not required and leads to unexpected screen reader anouncements
				
	    rm.write(">");
	    rm.renderControl(oControl._ctrl);
	    if (oControl.getShowExternalButton()) {
			rm.renderControl(oControl._btn);
	    }
	    
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	    rm.write("<span id='", oControl.getId(), "-label' style='display:none;' aria-hidden='true'>");
		rm.writeEscaped(rb.getText("SEARCHFIELD_BUTTONTEXT"));
		rm.write("</span>");
	    rm.write("</div>");
	};
	
	
	
	
	
	

	return SearchFieldRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/SearchFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SegmentedButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.SegmentedButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/SegmentedButtonRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * SegmentedButton renderer.
	 * @namespace
	 */
	var SegmentedButtonRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	SegmentedButtonRenderer.render = function(oRenderManager, oControl){
	    // convenience variable
		var rm = oRenderManager,
			rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons"),
			// ResourceBundle always returns the key if the text is not found
			sText = rb.getText("SEGMENTEDBUTTON_ARIA_SELECT");

		// write the HTML into the render manager  
	    rm.write("<span");
	    rm.writeControlData(oControl);
	    rm.addClass("sapUiSegmentedButton");
	    rm.writeClasses();
		rm.write(">"); // SPAN element
	    rm.write('<span id="' + oControl.getId() + '-radiogroup"');
	    // ARIA
		rm.writeAccessibilityState(oControl, {
			role: "radiogroup",
			disabled: !oControl.getEnabled()
		});
		if (oControl.getEnabled()) {
			rm.writeAttribute("tabIndex","0");
		} else {
			rm.writeAttribute("tabIndex","-1");
		}
		rm.write(">"); // SPAN element
		this.renderButtons(rm,oControl);
	    rm.write("</span>");
		rm.write('<span id="' + oControl.getId() + '-label" style="visibility: hidden; display: none;">');
		rm.writeEscaped(sText);
		rm.write('</span>');
	    rm.write("</span>");
	};
	
	SegmentedButtonRenderer.renderButtons = function(oRenderManager, oControl) {
		// convenience variable
		var rm = oRenderManager,
			aButtons = oControl.getButtons();
	    jQuery.each(aButtons, function(i,oButton) {
				rm.renderControl(oButton);
	    });
	};

	return SegmentedButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/SegmentedButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SliderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Slider
jQuery.sap.declare('sap.ui.commons.SliderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/SliderRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Slider renderer.
	 * @namespace
	 */
	var SliderRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.Slider} oSlider An object representation of the control that should be rendered.
	 */
	SliderRenderer.render = function(oRenderManager, oSlider){
		// Convenience variable
		var rm = oRenderManager;

		// Write the HTML into the render manager
		rm.write('<DIV');
		rm.writeControlData(oSlider);
		rm.addClass('sapUiSli');
		this.controlAdditionalCode(rm,oSlider);
		if (oSlider.getTooltip_AsString()) {
			rm.writeAttributeEscaped('title', oSlider.getTooltip_AsString());
		}

		if (!oSlider.getVertical() && oSlider.getWidth()) {
			rm.writeAttribute('style', 'width:' + oSlider.getWidth() + ';');
		} else {
			rm.writeAttribute('style', 'height:' + oSlider.getHeight() + ';');
		}

		/* eslint-disable no-lonely-if */
		if (!oSlider.getEnabled()) {
			rm.addClass('sapUiSliDsbl');
		} else {
			if (!oSlider.getEditable()) {
				rm.addClass('sapUiSliRo');
			} else {
				rm.addClass('sapUiSliStd');
			}
		}
		if (oSlider.getVertical()) {
			rm.addClass('sapUiSliVert');
		} else {
			rm.addClass('sapUiSliHori');
		}

		rm.writeClasses();

		// invisible span with tooltip as text for aria on grip
		if (oSlider.getTooltip_AsString()) {
			rm.write('><SPAN id="' + oSlider.getId() + '-Descr" style="visibility: hidden; display: none;">');
			rm.writeEscaped(oSlider.getTooltip_AsString());
			rm.write('</SPAN');
		}

		// Write slide bar
		rm.write('><DIV');
		rm.writeAttribute('id', oSlider.getId() + '-right');
		rm.write('class="sapUiSliR" > <DIV');

		rm.writeAttribute('id', oSlider.getId() + '-left');
		rm.write('class="sapUiSliL" > <DIV');

		rm.writeAttribute('id', oSlider.getId() + '-bar');
		rm.write('class="sapUiSliBar" >');

		var useTextLabels = false;
		if (oSlider.getLabels() && oSlider.getLabels().length > 0) {
			useTextLabels = true;
		}

		if (oSlider.getTotalUnits() > 0 || useTextLabels) {

			var iTotalUnits = oSlider.getTotalUnits();
			if (useTextLabels) {
				iTotalUnits = oSlider.getLabels().length - 1;
			}

			var fStepSize = (oSlider.getMax() - oSlider.getMin()) / iTotalUnits;

			// Add ticks
			for (var i = 0; i <= iTotalUnits; i++) {
				rm.write('<DIV');
				rm.writeAttribute('id', oSlider.getId() + '-tick' + i);
				rm.write('class="sapUiSliTick" ');
				rm.write('></DIV>'); // tick

				if ( oSlider.getStepLabels() ) {
					// Texts
					rm.write('<DIV');
					rm.writeAttribute('id', oSlider.getId() + '-text' + i);
					switch (i) {
					case ( 0 ):
						rm.write('class="sapUiSliText sapUiSliTextLeft" >');
						break;
					case (iTotalUnits):
						rm.write('class="sapUiSliText sapUiSliTextRight" >');
						break;
					default:
						rm.write('class="sapUiSliText" >');
						break;
					}
					if (useTextLabels) {
						rm.write(oSlider.getLabels()[i]);
					} else {
						rm.write(oSlider.getMin() + i * fStepSize);
					}
					rm.write('</DIV>'); // Text
				}
			}
		}

		// Highlight bar
		rm.write('<DIV');
		rm.writeAttribute('id', oSlider.getId() + '-hili');
		rm.write('class="sapUiSliHiLi"></DIV>');

		this.renderGrip(rm, oSlider);

		rm.write('</DIV></DIV></DIV></DIV>');
	};

	/**
	 * Renders the Grip for the slider control, using the provided {@link sap.ui.fw.RenderManager}.
	 *
	 * @param {sap.ui.fw.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.Slider} oSlider An object representation of the control that should be rendered.
	 */
	SliderRenderer.renderGrip = function(rm, oSlider){

		rm.write('<DIV');

		// Icon for grip
		rm.writeAttribute('id', oSlider.getId() + '-grip');
		if (oSlider.getEnabled()) {
			rm.writeAttribute('tabIndex', '0');
		} else {
			rm.writeAttribute('tabIndex', '-1');
		}
		rm.writeAttribute('class', 'sapUiSliGrip');
		rm.writeAttribute('title', oSlider.getValue());

		var sOriantation = 'horizontal';
		if (oSlider.getVertical()) {
			sOriantation = 'vertical';
		}

		// ARIA
		rm.writeAccessibilityState(oSlider, {
			role: 'slider',
			orientation: sOriantation,
			valuemin: oSlider.getMin(),
			valuemax: oSlider.getMax(),
			disabled: !oSlider.getEditable() || !oSlider.getEnabled(),
			describedby: oSlider.getTooltip_AsString() ? (oSlider.getId() + '-Descr ' + oSlider.getAriaDescribedBy().join(" ")) : undefined
		});

		if (oSlider.getVertical()) {
			rm.write('>&#9668;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)
		} else {
			rm.write('>&#9650;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)
		}
	};

	/**
	 * Adds extra code to the control (i.e. in subclasses), using the provided {@link sap.ui.fw.RenderManager}.
	 *
	 * @param {sap.ui.fw.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.Slider} oSlider An object representation of the control that should be rendered.
	 */
	SliderRenderer.controlAdditionalCode = function(rm, oSlider){
	};

	return SliderRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/SliderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SplitterRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Splitter
jQuery.sap.declare('sap.ui.commons.SplitterRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/SplitterRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @namespace
	 */
	var SplitterRenderer = {};
	
	/**
	 * Renders the HTML for the Splitter, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered
	 */
	SplitterRenderer.render = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		var orientation = oControl.getSplitterOrientation();
		var position = oControl.getSplitterPosition();
		var dimensionSecPane;
		var oControls;
		var iLength;
		var i;
		/*
		 * dimension (height or width) of the first pane is equal to the position of the splitter bar
		 * dimension of the second pane is the remaining available place after placing the first place
		 * 100 - position
		 * the splitter bar width/height is not taken into account since it has a fix width/height of 4px,
		 * it will be calculated after rendering
		 * it will be converted into percentage once we had the width/height of the splitter available area in px
		 */
		position = position.substring(0, position.length - 1);
		dimensionSecPane = 100 - position;
	
		/* Opening Splitter Wrapper DIV*/
		rm.write("<div ");
		rm.writeControlData(oControl);
		rm.addClass("sapUiSplitter");
	
		rm.addStyle("width",  oControl.getWidth());
		rm.addStyle("height",  oControl.getHeight());
		rm.writeStyles();
		rm.writeClasses();
		rm.write(">");
	
		/*rendering the first pane*/
		rm.write("<div id=\"" + oControl.getId() + "_firstPane\" ");
		if (oControl.getShowScrollBars()) {
			rm.addStyle("overflow", "auto");
		} else {
			rm.addStyle("overflow", "hidden");
		}
		if (orientation == sap.ui.core.Orientation.Vertical) {
			rm.addClass("sapUiVSplitterFirstPane");
			rm.addStyle("width", position + "%");
		} else if (orientation == sap.ui.core.Orientation.Horizontal) {
			rm.addClass("sapUiHSplitterFirstPane");
			rm.addStyle("height", position + "%");
		}
	
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
	
		/*First content (child controls)*/
		oControls = oControl.getFirstPaneContent();
		iLength = oControls.length;
		for (i = 0; i < iLength; i++) {
			rm.renderControl(oControls[i]);
		}
		rm.write("</div>");
	
		/*rendering the splitter bar*/
		rm.write("<div  id=\"" + oControl.getId() + "_SB\" tabIndex=\"0\" role=\"separator\" title=\"" + oControl.getText("SPLITTER_MOVE") + "\"");
		if (orientation == sap.ui.core.Orientation.Vertical) {
			if (oControl.getSplitterBarVisible()) {
				rm.addClass("sapUiVerticalSplitterBar");
			} else {
				rm.addClass("sapUiVerticalSplitterBarHidden");
			}
			rm.addStyle("width", 0 + "%");
		} else if (orientation == sap.ui.core.Orientation.Horizontal) {
			if (oControl.getSplitterBarVisible()) {
				rm.addClass("sapUiHorizontalSplitterBar");
			} else {
				rm.addClass("sapUiHorizontalSplitterBarHidden");
			}
			rm.addStyle("height", 0 + "%");
		}
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		rm.write("</div>");
	
		/*rendering the second pane*/
		rm.write("<div id=\"" + oControl.getId() + "_secondPane\" ");
		if (oControl.getShowScrollBars()) {
			rm.addStyle("overflow", "auto");
		} else {
			rm.addStyle("overflow", "hidden");
		}
		if (orientation == sap.ui.core.Orientation.Vertical) {
			rm.addClass("sapUiVSplitterSecondPane");
			rm.addStyle("width", dimensionSecPane + '%');
		} else if (orientation == sap.ui.core.Orientation.Horizontal) {
			rm.addClass("sapUiHSplitterSecondPane");
			rm.addStyle("height", dimensionSecPane + '%');
		}
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
	
		/*Second content (child controls)*/
		oControls = oControl.getSecondPaneContent();
		iLength = oControls.length;
		for (i = 0; i < iLength; i++) {
			rm.renderControl(oControls[i]);
		}
		rm.write("</div>");
	
		/* Closing the Splitter Wrapper DIV*/
		rm.write("</div>");
	};

	return SplitterRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/SplitterRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TabStripRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TabStrip
jQuery.sap.declare('sap.ui.commons.TabStripRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TabStripRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * TabStrip renderer.
	 * @namespace
	 */
	var TabStripRenderer = function() {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TabStripRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	
		//outer DIV
		rm.write("<div role='presentation'");
		rm.addClass("sapUiTabStrip");
		rm.addStyle("height",oControl.getHeight());
		rm.addStyle("width",oControl.getWidth());
		rm.writeClasses();
		rm.writeStyles();
		rm.writeControlData(oControl);
		//header area
		rm.write("><div class=\"sapUiTabBar\" tabIndex=\"0\"");
		if (oControl.getTooltip_AsString()) {
			rm.writeAttributeEscaped('title', oControl.getTooltip_AsString());
		}
		// menu and list header
		rm.write("><div class=\"sapUiTabMenu\"></div><ul class=\"sapUiTabBarCnt\" role=\"tablist\">");
	
		var aTabs = oControl.getTabs();
		// check if selected tab exists and is visible -> otherwise select first active one
		var bWrongIndex = false;
		var iSelectedIndex = oControl.getSelectedIndex();
		if (iSelectedIndex < 0) {
			// if not tab is selected use default value
			iSelectedIndex = 0;
			oControl.setProperty( 'selectedIndex', 0, true );
		}
		var oSelectedTab = aTabs[iSelectedIndex];
		if (!oSelectedTab || !oSelectedTab.getVisible() || !oSelectedTab.getEnabled()) {
			oControl._warningInvalidSelectedIndex(iSelectedIndex, oSelectedTab);
			bWrongIndex = true;
		}
	
		// for ARIA determine number of visible tabs
		oControl.iVisibleTabs = 0;
		for (var i = 0;i < aTabs.length;i++) {
			var oTab = aTabs[i];
			if (oTab.getVisible() === false) {
				continue;
			}
			oControl.iVisibleTabs++;
		}
	
		var iVisibleIndex = 0;
		// tabs
		for (var i = 0; i < aTabs.length; i++) {
			var oTab = aTabs[i];
			if (oTab.getVisible() === false) {
				continue;
			}
	
			if (bWrongIndex && oTab.getEnabled()) {
				oControl.setProperty( 'selectedIndex', i, true );
				iSelectedIndex = i;
				bWrongIndex = false;
			}
	
			rm.write("<li");
	
			if (oTab.getEnabled() == false) {
				rm.addClass("sapUiTabDsbl");
			} else if (i == iSelectedIndex) {
				rm.addClass("sapUiTabSel");
			} else {
				rm.addClass("sapUiTab");
			}
	
			// enable the successor tab to overlap this tab if selected
			if (i == iSelectedIndex - 1) {
				rm.addClass("sapUiTabBeforeSel");
			} else if (i == iSelectedIndex + 1) {
				rm.addClass("sapUiTabAfterSel");
			}
	
			rm.writeControlData(oTab);
			rm.writeAttribute("tabidx", i);
	
			//ARIA
			iVisibleIndex++;
	
			rm.writeAttribute("tabindex", "-1");
			rm.writeAttribute("role", "tab");
	
			rm.writeAccessibilityState(oTab, {selected: i == iSelectedIndex,
											  controls: oTab.getId() + "-panel",
											  disabled: !oTab.getEnabled(),
											  posinset: iVisibleIndex,
											  setsize: oControl.iVisibleTabs});
			if (oTab.getClosable()) {
				// close button text must be read
				rm.writeAccessibilityState(oTab, {describedby: oTab.getId() + "-close"});
			}
	
			if (iVisibleIndex == oControl.iVisibleTabs) {
				rm.addClass("sapUiTabLast"); // needed for IE8
			}
			rm.writeClasses();
	
			var oTitle = oTab.getTitle();
			// tooltip: if title has a tooltip use it, if not use the tooltip of the tab
			if (oTitle && oTitle.getTooltip_AsString()) {
				rm.writeAttributeEscaped('title', oTitle.getTooltip_AsString());
			} else if (oTab.getTooltip_AsString()) {
				rm.writeAttributeEscaped('title', oTab.getTooltip_AsString());
			}
			rm.write(">");
	
			// title with icon
			if (oTitle) {
				var sIcon = oTitle.getIcon();
				if (sIcon) {
					var aClasses = [];
					var mAttributes = {};
	
					aClasses.push("sapUiTabIco");
					rm.writeIcon(sIcon, aClasses, mAttributes);
				}
				rm.writeEscaped(oTitle.getText());
			} else {
				jQuery.sap.log.warning("No title configured for " + oTab + ". Either set a string as 'text' property or a sap.ui.core.Title as 'title' aggregation.");
			}
			if (oTab.getClosable()) {
				// close button
				rm.write("<button id='" + oTab.getId() + "-close' type=\"button\" tabindex= \"-1\" class=\"sapUiTabClose\" title=\"" + rb.getText("TAB_CLOSE_TEXT") + "\"></button>");
			}
			rm.write("</li>");
		}
		rm.write("</ul></div>");
	
		if (bWrongIndex) {
			// still wrong index - no tab is selected -> render empty panel area
			oControl.setProperty( 'selectedIndex', -1, true );
			iSelectedIndex = -1;
			rm.write("<div id=\"" + oControl.getId() + "-panel" + "\" role=\"tabpanel\"");
			rm.addClass("sapUiTabPanel");
			if (oControl.getHeight()) {
				rm.addClass("sapUiTabPanelHeight");
			}
			rm.writeClasses();
			rm.write("></div>");
		} else {
			for (var i = 0;i < aTabs.length;i++) {
				var oTab = aTabs[i];
				//do not render unselected (or invisible) tab content
				if (i != iSelectedIndex || oTab.getVisible() === false) {
					continue;
				}
	
				// Improved version... now announcing the title when clicked into the tabpanel... into the full tabpanel!
				// ARIA requires ID for the Panel...
				rm.write("<div id=\"" + oTab.getId() + "-panel" + "\" role=\"tabpanel\" aria-labelledby=\"" + oTab.getId() + "\"");
				rm.addClass("sapUiTabPanel");
				if (oControl.getHeight()) {
					rm.addClass("sapUiTabPanelHeight");
				}
				rm.writeClasses();
				rm.write(">");
	
				TabStripRenderer.renderTabContents(rm,oTab);
				rm.write("</div>");
			}
		}
		rm.write("</div>");
	
		// reset invalidate flag
		oControl.invalidated = false;
	
	};
	
	/*moved over from former (and replaced) Panel control
	 * @private
	 */
	TabStripRenderer.renderTabContents = function(rm, oControl) {
	
		// Content
		var oControls = oControl.getContent(),
		iLength = oControls.length;
		for (var i = 0;i < iLength;i++) {
			rm.renderControl(oControls[i]);
		}
	
	};

	return TabStripRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TabStripRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TextFieldRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TextField
jQuery.sap.declare('sap.ui.commons.TextFieldRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TextFieldRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, Renderer, ValueStateSupport) {
	"use strict";


	/**
	 * TextField Renderer
	 * @namespace
	 * @author SAP
	 * @version 1.28.17
	 * @since 0.9.0
	 */
	var TextFieldRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.TextField}
	 *            oTextField The TextField control that should be rendered.
	 */
	TextFieldRenderer.render = function(oRenderManager, oTextField) {
		var rm = oRenderManager,
			r  = TextFieldRenderer;
	
		var sWidth = oTextField.getWidth();
		var tooltip = ValueStateSupport.enrichTooltip(oTextField, oTextField.getTooltip_AsString());
		var bRenderOuter = oTextField._getRenderOuter();
	
	// In case of Combobox, F4-help, DatePicker: Render outer element.
	// The details of the outer element are rendered in the hook implemented in the corresponding control.
		if (bRenderOuter) {
			rm.write("<div");
			rm.writeControlData(oTextField);
			rm.addClass("sapUiTfBack");
			this.renderStyles(rm, oTextField);
	
			if (tooltip) {
				rm.writeAttributeEscaped('title', tooltip);
			}
	
			var sSpanStyle;
			if (sWidth && sWidth != '') {
				sSpanStyle = 'width: ' + sWidth + ';';
			}
	
			if (this.renderOuterAttributes) {
				this.renderOuterAttributes(rm, oTextField);
			}
	
			if (sSpanStyle) {
				rm.writeAttribute('style', sSpanStyle);
			}
			rm.writeStyles();
			rm.writeClasses();
			rm.write(">");
	
			// Outer hook
			if (this.renderOuterContentBefore) {
				this.renderOuterContentBefore(rm, oTextField);
			}
		}
	
	// Inner tag / pure TextField
		if (this.getInnerTagName) {
			rm.write('<' + this.getInnerTagName());
		} else {
			rm.write("<input");
		}
		rm.addClass("sapUiTf");
	
		if (!bRenderOuter) {
			// Stand-alone TextField
			rm.writeControlData(oTextField);
			rm.addClass("sapUiTfBack");
			this.renderStyles(rm, oTextField);
	
			if (sWidth && sWidth != '') {
				rm.addStyle("width", sWidth);
			}
		} else {
			rm.writeAttribute('id', oTextField.getId() + '-input');
			rm.addClass("sapUiTfInner");
			rm.addStyle("width", '100%');
		}
	
		if (tooltip) {
			// render title always on INPUT tag (even it's in outer DIV too)
			// because screenreader ignores it on outer DIV 
			rm.writeAttributeEscaped('title', tooltip);
		}
	
		if (oTextField.getName()) {
			rm.writeAttributeEscaped('name', oTextField.getName());
		}
	
		if (!oTextField.getEditable()) {
			rm.writeAttribute('readonly', 'readonly');
		}
		if (this.renderTextFieldEnabled) {
			this.renderTextFieldEnabled(rm, oTextField);
		} else if (!oTextField.getEnabled()) {
			rm.writeAttribute('disabled', 'disabled');
			rm.writeAttribute('tabindex', '-1');
		} else if (!oTextField.getEditable()) {
			rm.writeAttribute('tabindex', '0');
		} else {
			rm.writeAttribute('tabindex', '0');
		}
	
		// Appearance
		var sTextDir = oTextField.getTextDirection();
		if (sTextDir) {
			rm.addStyle("direction", sTextDir.toLowerCase());
		}
	
		var sTextAlign = r.getTextAlign(oTextField.getTextAlign(), sTextDir);
		if (sTextAlign) {
			rm.addStyle("text-align", sTextAlign);
		}
	
		switch (oTextField.getImeMode()) {
		case sap.ui.core.ImeMode.Inactive:
			rm.addStyle('ime-mode','inactive');
			break;
		case sap.ui.core.ImeMode.Active:
			rm.addStyle('ime-mode','active');
			break;
		case sap.ui.core.ImeMode.Disabled:
			rm.addStyle('ime-mode','disabled');
			break;
		// no default
		}
	
		if (oTextField.getDesign() == sap.ui.core.Design.Monospace) {
			rm.addClass('sapUiTfMono');
		}
	
		if (oTextField.getMaxLength()) {
			rm.writeAttribute("maxLength", oTextField.getMaxLength());
		}
	
		// Add additional attributes, styles and so on (TextArea)
		if (this.renderInnerAttributes) {
			this.renderInnerAttributes(rm, oTextField);
		}
	
		// ARIA
		if (this.renderARIAInfo) {
			this.renderARIAInfo(rm, oTextField);
		}
	
		var sPlaceholder = oTextField.getPlaceholder();
		if (sPlaceholder) {
			if (this.convertPlaceholder) {
				sPlaceholder = this.convertPlaceholder(oTextField);
			}
			if (sap.ui.Device.support.input.placeholder) {
				rm.writeAttributeEscaped('placeholder', sPlaceholder);
			}
		}
	
		rm.writeStyles();
		rm.writeClasses();
	
		if (this.getInnerTagName) {
			rm.write(">");
		} else {
			rm.write(" value=\"");
			if (!sap.ui.Device.support.input.placeholder && sPlaceholder && !oTextField.getValue()) {
				rm.writeEscaped(sPlaceholder);
			} else {
				rm.writeEscaped(oTextField.getValue());
			}
			rm.write("\"");
			rm.write("/>");
		}
	
		if (this.getInnerTagName) {
			// Inner hook
			if (this.renderInnerContent) {
				this.renderInnerContent(rm, oTextField);
			}
	
			rm.write('</' + this.getInnerTagName() + '>');
		}
	
		if (bRenderOuter) {
			// Outer hook
			if (this.renderOuterContent) {
				this.renderOuterContent(rm, oTextField);
			}
	
			rm.write("</div>");
		}
	
	};
	
	TextFieldRenderer.renderStyles = function(rm, oTextField) {
	
		rm.addClass('sapUiTfBrd');
	
		if (oTextField.getEnabled()) {
			if (!oTextField.getEditable()) {
				rm.addClass("sapUiTfRo");
			} else {
				rm.addClass("sapUiTfStd");
			}
		} else {
			rm.addClass("sapUiTfDsbl");
		}
	
		switch (oTextField.getValueState()) {
		case (sap.ui.core.ValueState.Error) :
			rm.addClass('sapUiTfErr');
		break;
		case (sap.ui.core.ValueState.Success) :
			rm.addClass('sapUiTfSucc');
		break;
		case (sap.ui.core.ValueState.Warning) :
			rm.addClass('sapUiTfWarn');
		break;
		// no default
		}
	
		if (oTextField.getRequired()) {
			rm.addClass('sapUiTfReq');
		}
	
		if (oTextField.getPlaceholder() && !sap.ui.Device.support.input.placeholder) {
			rm.addClass('sapUiTfPlace');
		}
	
	};
	
	TextFieldRenderer.onfocus = function(oTextField) {
		var oTfRef = oTextField.$();
		var oTfRefInput;
		oTfRef.addClass("sapUiTfFoc");
	
		if (!sap.ui.Device.support.input.placeholder && !oTextField.getValue() && oTextField.getPlaceholder()) {
			if (oTextField._getRenderOuter()) {
				oTfRefInput = oTextField.$("input");
			} else {
				oTfRefInput = oTfRef;
			}
	
			oTfRef.removeClass("sapUiTfPlace");
			oTfRefInput.val("");
		}
	};
	
	TextFieldRenderer.onblur = function(oTextField) {
		var oTfRef = oTextField.$();
		var oTfRefInput;
		oTfRef.removeClass("sapUiTfFoc");
	
		var sPlaceholder = oTextField.getPlaceholder();
		if (!sap.ui.Device.support.input.placeholder) {
			if (oTextField._getRenderOuter()) {
				oTfRefInput = oTextField.$("input");
			} else {
				oTfRefInput = oTfRef;
			}
	
			if (!oTfRefInput.val() && sPlaceholder) {
				oTfRef.addClass("sapUiTfPlace");
				if (this.convertPlaceholder) {
					sPlaceholder = this.convertPlaceholder(oTextField);
				}
				oTfRefInput.val(sPlaceholder);
			}
		}
	};
	
	TextFieldRenderer.setValueState = function(oTextField, oldValueState, newValueState) {
		var oTfRef = oTextField.$();
		var oTfRefInput;
		var bRenderOuter = oTextField._getRenderOuter();
	
		if (bRenderOuter) {
		// aria attribute must be on inner tag
			oTfRefInput = oTextField.$("input");
		} else {
			oTfRefInput = oTfRef;
		}
	
		// Remove old value state
		switch (oldValueState) {
		case (sap.ui.core.ValueState.Error) :
			oTfRef.removeClass('sapUiTfErr');
			oTfRefInput.removeAttr('aria-invalid');
			break;
		case (sap.ui.core.ValueState.Success) :
			oTfRef.removeClass('sapUiTfSucc');
			break;
		case (sap.ui.core.ValueState.Warning) :
			oTfRef.removeClass('sapUiTfWarn');
			break;
		// no default
		}
	
		// Set new value state
		switch (newValueState) {
		case (sap.ui.core.ValueState.Error) :
			oTfRef.addClass('sapUiTfErr');
			oTfRefInput.attr('aria-invalid',true);
			break;
		case (sap.ui.core.ValueState.Success) :
			oTfRef.addClass('sapUiTfSucc');
			break;
		case (sap.ui.core.ValueState.Warning) :
			oTfRef.addClass('sapUiTfWarn');
			break;
		// no default
		}
	
		var tooltip = ValueStateSupport.enrichTooltip(oTextField, oTextField.getTooltip_AsString());
		if (tooltip) {
			oTfRef.attr('title', tooltip);
			if (bRenderOuter) {
				oTextField.$("input").attr('title', tooltip);
			}
		} else {
			oTfRef.removeAttr('title');
			if (bRenderOuter) {
				oTextField.$("input").removeAttr('title');
			}
		}
	
	};
	
	TextFieldRenderer.setEditable = function(oTextField, bEditable) {
	
		if (!oTextField.getEnabled()) {
			// if disabled -> nothing to do
			return;
		}
	
		var oTfRef = oTextField.$();
		var oTfRefInput;
	
		if (oTextField._getRenderOuter()) {
		// Readonly attribute must be on inner tag
			oTfRefInput = oTextField.$("input");
		} else {
			oTfRefInput = oTfRef;
		}
	
	
		if (bEditable) {
			oTfRef.removeClass('sapUiTfRo').addClass('sapUiTfStd');
			oTfRefInput.removeAttr('readonly');
		} else {
			oTfRef.removeClass('sapUiTfStd').addClass('sapUiTfRo');
			oTfRefInput.attr('readonly', 'readonly');
		}
	
		oTfRefInput.attr('aria-readonly', !bEditable);
	};
	
	TextFieldRenderer.setEnabled = function(oTextField, bEnabled) {
		var oTfRef = oTextField.$();
		var oTfRefInput;
	
		if (oTextField._getRenderOuter()) {
		// Disabled attribute must be on inner tag
			oTfRefInput = oTextField.$("input");
		} else {
			oTfRefInput = oTfRef;
		}
	
		if (bEnabled) {
			if (oTextField.getEditable()) {
				oTfRef.removeClass('sapUiTfDsbl').addClass('sapUiTfStd').removeAttr('aria-disabled');
				oTfRefInput.removeAttr('disabled').removeAttr('aria-disabled').attr( 'tabindex', '0');
			} else {
				oTfRef.removeClass('sapUiTfDsbl').addClass('sapUiTfRo').removeAttr('aria-disabled');
				oTfRefInput.removeAttr('disabled').removeAttr('aria-disabled').attr( 'tabindex', '0').attr( 'readonly', 'readonly');
			}
		} else {
			if (oTextField.getEditable()) {
				oTfRef.removeClass('sapUiTfStd').addClass('sapUiTfDsbl').attr('aria-disabled', 'true');
				oTfRefInput.attr( 'disabled', 'disabled').attr('aria-disabled', 'true').attr( 'tabindex', '-1');
			} else {
				oTfRef.removeClass('sapUiTfRo').addClass('sapUiTfDsbl').attr('aria-disabled', 'true');
				oTfRefInput.removeAttr('readonly').attr( 'disabled', 'disabled').attr('aria-disabled', 'true').attr( 'tabindex', '-1');
			}
		}
	
	};
	
	TextFieldRenderer.removeValidVisualization = function(oTextField) {
		var oTfRef = oTextField.$();
		if (oTfRef) {
			oTfRef.removeClass("sapUiTfSucc");
		} else {
			jQuery.sap.delayedCall(1000, TextFieldRenderer, "removeValidVisualization", [oTextField]);
		}
	};
	
	TextFieldRenderer.setDesign = function(oTextField, sDesign) {
	
		oTextField.$().toggleClass('sapUiTfMono', (sDesign == sap.ui.core.Design.Monospace));
	};
	
	TextFieldRenderer.setRequired = function(oTextField, bRequired) {
	
		var oTfRefInput;
	
		if (oTextField._getRenderOuter()) {
		// aria attribute must be on inner tag
			oTfRefInput = oTextField.$("input");
		} else {
			oTfRefInput = oTextField.$();
		}
	
		oTextField.$().toggleClass('sapUiTfReq', bRequired);
		if (bRequired) {
			oTfRefInput.attr("aria-required", true);
		} else {
			oTfRefInput.removeAttr("aria-required");
		}
	
	};
	
	TextFieldRenderer.renderARIAInfo = function(rm, oTextField) {
	
		var mProps = {
			role: oTextField.getAccessibleRole().toLowerCase(),
			multiline: false,
			autocomplete: 'none'};
	
		if (oTextField.getValueState() == sap.ui.core.ValueState.Error) {
			mProps["invalid"] = true;
		}
	
		rm.writeAccessibilityState(oTextField, mProps);
	
	};
	
	/**
	 * Dummy inheritance of static methods/functions.
	 * @see sap.ui.core.Renderer.getTextAlign
	 * @private
	 */
	TextFieldRenderer.getTextAlign = Renderer.getTextAlign;
	

	return TextFieldRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TextFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TextViewRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TextView
jQuery.sap.declare('sap.ui.commons.TextViewRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TextViewRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * TextView renderer.
	 * @author SAP SE
	 * @namespace
	 */
	var TextViewRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oTextView An object representation of the control that should be rendered.
	 */
	TextViewRenderer.render = function(oRenderManager, oTextView) {
		var rm = oRenderManager;
		var r = TextViewRenderer;
	
		// Get parameters
		var enabled = oTextView.getEnabled() === true,
			oDesign = oTextView.getDesign();
	
		// Enable/disable
		if (!enabled) {
			rm.addClass("sapUiTvDsbl");
			oTextView.allowTextSelection(false);
		} else { // Show error/warning states if they are enabled
			// error/warning state
			switch (oTextView.getSemanticColor()) {
			case (sap.ui.commons.TextViewColor.Negative) :
				rm.addClass('sapUiTvErr');
				break;
			case (sap.ui.commons.TextViewColor.Positive) :
				rm.addClass('sapUiTvSucc');
				break;
			case (sap.ui.commons.TextViewColor.Critical) :
				rm.addClass('sapUiTvWarn');
				break;
			// no default
			}
		}
	
		// Styles
		var TextViewDesign = sap.ui.commons.TextViewDesign;
		if (oDesign != TextViewDesign.Standard) {
			if (oDesign === TextViewDesign.Bold) {
				rm.addClass("sapUiTvEmph");
			} else if (oDesign === TextViewDesign.H1) {
				rm.addClass("sapUiTvH1");
			} else if (oDesign === TextViewDesign.H2) {
				rm.addClass("sapUiTvH2");
			} else if (oDesign === TextViewDesign.H3) {
				rm.addClass("sapUiTvH3");
			} else if (oDesign === TextViewDesign.H4) {
				rm.addClass("sapUiTvH4");
			} else if (oDesign === TextViewDesign.H5) {
				rm.addClass("sapUiTvH5");
			} else if (oDesign === TextViewDesign.H6) {
				rm.addClass("sapUiTvH6");
			} else if (oDesign === TextViewDesign.Italic) {
				rm.addClass("sapUiTvItalic");
			} else if (oDesign === TextViewDesign.Small) {
				rm.addClass("sapUiTvSmall");
			} else if (oDesign === TextViewDesign.Monospace) {
				rm.addClass("sapUiTvMono");
			} else if (oDesign === TextViewDesign.Underline) {
				rm.addClass("sapUiTvULine");
			}
		}
	
		if (!oTextView.getWrapping()) {
			rm.addClass("sapUiTvWrap");
		}
	
		if (oTextView.getWidth() && oTextView.getWidth() != '') {
			rm.addStyle("width", oTextView.getWidth());
		}
	
		rm.write("<span");
		rm.writeControlData(oTextView);
	
		rm.addClass("sapUiTv");
	
		if (oTextView.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oTextView.getTooltip_AsString());
		} else if (oTextView.getText()) {
			rm.writeAttributeEscaped("title", oTextView.getText());
		}
	
		// Appearance
		var sTextDir = oTextView.getTextDirection();
		if (sTextDir) {
			rm.addStyle("direction", sTextDir.toLowerCase());
		}
	
		var sAlign = r.getTextAlign(oTextView.getTextAlign(), sTextDir);
		if (sAlign) {
			// use class because it's easier to overwrite
			sAlign = sAlign.charAt(0).toUpperCase() + sAlign.substring(1);
			rm.addClass("sapUiTvAlign" + sAlign);
		}
	
		// Make control focusable via tab
		// according to Stefan Schnabel there shall not be a tabstop   rm.writeAttribute('tabindex', tabIndex);
		rm.writeAttribute('tabindex', '-1'); //to make it focusable in ItemNavigation
		// Set Accessible Role
		rm.writeAccessibilityState(oTextView, {
			role: oTextView.getAccessibleRole().toLowerCase(),
			invalid: oTextView.getSemanticColor() == sap.ui.commons.TextViewColor.Negative,
			disabled: !oTextView.getEnabled()
		});
	
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		rm.writeEscaped(oTextView.getText(), true);
		rm.write("</span>");
	
	};
	
	/**
	 * Dummy inheritance of static methods/functions.
	 * @see sap.ui.core.Renderer.getTextAlign
	 * @private
	 */
	TextViewRenderer.getTextAlign = Renderer.getTextAlign;

	return TextViewRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TextViewRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ToggleButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Togglebutton
jQuery.sap.declare('sap.ui.commons.ToggleButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ToggleButtonRenderer",['jquery.sap.global', './ButtonRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ButtonRenderer, Renderer) {
	"use strict";


	/**
	 * ToggleButton renderer.
	 * @author D040134
	 * @namespace
	 */
	
	var ToggleButtonRenderer = Renderer.extend(ButtonRenderer);
	
	/**
	 * Hint: "renderButtonAttributes" is a reserved/hard-coded Button extending function!
	 *       It is used to allow extensions to display content after the actual button content.
	 * @param {sap.ui.core.RenderManager}
	 *            rm the RenderManager currently rendering this control
	 * @param {sap.ui.commons.ToggleButton}
	 *            oToggleButton the ToggleButton that should be rendered
	 * @private
	 */
	ToggleButtonRenderer.renderButtonAttributes = function(rm, oToggleButton) {
		rm.addClass("sapUiToggleBtn");
		if (oToggleButton.getPressed()) {
			rm.addClass("sapUiToggleBtnPressed");
			rm.writeAttribute('aria-pressed', true);
		} else {
			rm.writeAttribute('aria-pressed', false);
		}
	};
	
	
	/**
	 * Function called by ToggleButton control to enable Pressed state.
	 */
	ToggleButtonRenderer.onactivePressed = function(oToggleButton) {
		oToggleButton.$().addClass("sapUiToggleBtnPressed").attr('aria-pressed', true);
	};
	
	/**
	 * Function called by button control to disable Pressed state.
	 */
	ToggleButtonRenderer.ondeactivePressed = function(oToggleButton) {
		oToggleButton.$().removeClass("sapUiToggleBtnPressed").attr('aria-pressed', false);
	};
	
	/**
	 * Function called by button control to update image based on state.
	 */
	ToggleButtonRenderer.updateImage = function(oToggleButton) {
		oToggleButton.$("img").attr('src',this._getIconForState(oToggleButton, "base"));
	};
	
	/**
	 * Returns the icon URI for the given button state
	 * @private
	 */
	ToggleButtonRenderer._getIconForState = function(oButton, sState) {
		var sIcon;
		switch (sState) {
			case "mouseout":
			case "focus":
			case "blur":
			case "base":
				return oButton.getPressed() && oButton.getIconSelected() ? oButton.getIconSelected() : oButton.getIcon();
			case "active":
				sIcon = oButton.getIconSelected();
				return sIcon ? sIcon : oButton.getIcon();
			case "mouseover":
			case "deactive":
				sIcon = oButton.getIconHovered();
				if (sIcon) {
					return sIcon;
				} else if (oButton.getPressed() && oButton.getIconSelected()) {
					return oButton.getIconSelected();
				} else {
					return oButton.getIcon();
				}
		}
		return oButton.getIcon();
	};
	

	return ToggleButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ToggleButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ToolbarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Toolbar
jQuery.sap.declare('sap.ui.commons.ToolbarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ToolbarRenderer",['jquery.sap.global'],
function(jQuery) {
	"use strict";


	/**
	 * @namespace
	 */
	var ToolbarRenderer = {
	};

	/**
	 * Renders the HTML for the given toolbar using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.Toolbar} oToolbar An object representation of the control that should be rendered.
	 */
	ToolbarRenderer.render = function(oRenderManager, oToolbar) {
		var rm = oRenderManager;
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

		jQuery.sap.assert(oToolbar instanceof sap.ui.commons.Toolbar, "ToolbarRenderer.render: oToolbar must be a toolbar");

		rm.write("<div role='toolbar' tabindex='0'"); // Tab index required for ItemNavigation, the Toolbar is actually not tabable
		rm.writeControlData(oToolbar);
		if (oToolbar.getWidth()) {
			rm.addStyle("width", oToolbar.getWidth());
		}

		var sTooltip = oToolbar.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}

		rm.addClass("sapUiTb");
		rm.addClass("sapUiTbDesign" + oToolbar.getDesign());
		if (oToolbar.getStandalone()) {
			rm.addClass("sapUiTbStandalone");
		}

		rm.writeStyles();
		rm.writeClasses();
		rm.write(">");

		var aRightItems = oToolbar.getRightItems();
		var iRightItemsLength =  aRightItems.length;
		var bHasRightItems = iRightItemsLength > 0;

		var sInnerDiv = "<div class='sapUiTbInner' id='" + oToolbar.getId() + "-inner" + "'>";
		if (bHasRightItems) {
            rm.write("<div class='sapUiTbCont sapUiTbContLeft'>" + sInnerDiv);
		} else {
			rm.write("<div class='sapUiTbCont'>" + sInnerDiv);
		}


		// Render each item, also the hidden ones, as they might become visible when the toolbar is resized
		var aItems = oToolbar.getItems();
		var iLength = aItems.length;
		for (var i = 0; i < iLength; i++) {
			var oToolbarItem = aItems[i];
			if (oToolbarItem) {
				jQuery.sap.assert(oToolbarItem.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"), "ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");

				// Render ToolbarSeparator elements internally, dispatch rendering of real controls
				if (oToolbarItem instanceof sap.ui.commons.ToolbarSeparator) {
					ToolbarRenderer.renderSeparator(rm, oToolbarItem);
				} else {
					rm.renderControl(oToolbarItem);
				}
			}
		}

		// Render the overflow menu button and the cover hiding it, if appropriate
		rm.write("<div id='");
		rm.write(oToolbar.getId());
		rm.write("-mn' class='sapUiTbOB' role='button' aria-haspopup='true' title='" + rb.getText("TOOLBAR_OVERFLOW") + "' tabindex='-1'></div></div></div>");

		// Render right side items if right items exist
		if (bHasRightItems) {
			rm.write("<div class='sapUiTbInnerRight' >");
			for (var i = 0; i < iRightItemsLength; i++) {
				var oToolbarItem = aRightItems[i];
				if (oToolbarItem) {
					jQuery.sap.assert(oToolbarItem.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"), "ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");
					// Render ToolbarSeparator elements internally, dispatch rendering of real controls
					if (oToolbarItem instanceof sap.ui.commons.ToolbarSeparator) {
						ToolbarRenderer.renderSeparator(rm, oToolbarItem);
					} else {
						rm.renderControl(oToolbarItem);
					}
				}
			}
			rm.write("</div>");
		}
		// Close div for the toolbar
		rm.write("</div>");

	};


	/**
	 * Renders the given ToolbarSeparator
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager
	 * @param {sap.ui.commons.ToolbarItem} oToolbarItem The ToolbarSeparator
	 * @private
	 */
	ToolbarRenderer.renderSeparator = function(oRm, oToolbarItem) {
		if (oToolbarItem.getDisplayVisualSeparator()) {
			oRm.write("<span ");
			oRm.writeElementData(oToolbarItem);
			if (oToolbarItem.getDesign() === sap.ui.commons.ToolbarSeparatorDesign.FullHeight) {
				oRm.write(" class='sapUiTbSeparator sapUiTbSepFullHeight' role='separator'></span>");
			} else {
				oRm.write(" class='sapUiTbSeparator' role='separator'></span>");
			}
		} else {
			oRm.write("<span ");
			oRm.writeElementData(oToolbarItem);
			oRm.write(" class='sapUiTbSpacer' role='separator'></span>");
		}
	};


	/**
	 * Fills the overflow popup with the currently invisible toolbar items.
	 *
	 * @param {sap.ui.commons.Toolbar} oToolbar
	 * @private
	 */
	ToolbarRenderer.fillOverflowPopup = function(oToolbar) {
		var oPopupHolder = oToolbar.getDomRef("pu");
		if (!oPopupHolder) {
			oPopupHolder = ToolbarRenderer.initOverflowPopup(oToolbar).firstChild;
		}

		// Move all invisible (due to overflow) left items from the second row of the toolbar to the popup
		//1. Obtaining all invisible due to overflow and due to API property visible=false
		var $oPopupHolderParent = jQuery(oPopupHolder.parentNode),
			iVisibleItems = oToolbar.getVisibleItemInfo(true).count,
			oToolbarCont = oToolbar.getDomRef().firstChild.firstChild,
			iPos = 0,
			oChild = oToolbarCont.firstChild,
			sOverflowButtonId = oToolbar.getId() + "-mn",
			iPopupParentWidth = $oPopupHolderParent.width(),
			iBiggestItemWidth = 0;

		//2. Move all left items that are not visible due to the overflow
		while (oChild) {
			var nextChild = oChild.nextSibling;
			if (iPos >= iVisibleItems) {
				if (oChild.id === sOverflowButtonId) { // do not move overflow button and cover
					break;
				}
				// calculate biggest item width CSS: (1570140661)
				iBiggestItemWidth = iBiggestItemWidth  < jQuery(oChild).outerWidth(true) ? jQuery(oChild).outerWidth(true) : iBiggestItemWidth;
				oPopupHolder.appendChild(oChild);
			}
			oChild = nextChild;
			iPos++;
		}
		// when there is an item with width bigger than the last opened popup width, set popup width
		// to be equal to the biggest width among items (CSS: 1570140661)
		if (iBiggestItemWidth > iPopupParentWidth) {
			var iPaddingSpace = 12;//preserve space for left+right padding(.sapUiTbDD)
			$oPopupHolderParent.width(iBiggestItemWidth + iPaddingSpace);
		}
	};


	/**
	 * Creates the overflow popup inside the static area, but does not fill its contents (=no items).
	 *
	 * @param {sap.ui.commons.Toolbar} oToolbar
	 * @private
	 */
	ToolbarRenderer.initOverflowPopup = function(oToolbar) {
		var oStaticArea = sap.ui.getCore().getStaticAreaRef();
		var oPopupHolder = document.createElement("div");
		oPopupHolder.className = "sapUiTbDD sapUiTbDesignFlat";
		oPopupHolder.innerHTML = "<div id='" + oToolbar.getId() + "-pu' data-sap-ui=" + oToolbar.getId() + " tabindex='0' role='menu'></div>";
		oStaticArea.appendChild(oPopupHolder);
		return oPopupHolder;
	};


	/**
	 * Either move the items from the overflow popup to the toolbar or just remove them from the DOM.
	 *
	 * @param {sap.ui.commons.Toolbar} oToolbar
	 * @param {boolean} [bMoveItems=true] move popup items to the toolbar DOM or remove them completely
	 * @private
	 */
	ToolbarRenderer.emptyOverflowPopup = function(oToolbar, bMoveItems) {
		var oPopupHolder    = oToolbar.getDomRef("pu"),
		    oDomRef         = oToolbar.getDomRef(),
		    oContext        = null,
		    sMethod         = '',
		    aAdditionalArgs = [];

		if (bMoveItems === undefined) {
			// by default the items are moved from the popup to the toolbar
			bMoveItems = true;
		}

		if (oPopupHolder) {
			if (bMoveItems && oDomRef) {
				// move the items from the popup to the toolbar
				// i.e. oToolbarContent.insertBefore(oPopupHolder.firstChild, oOverflowButton)
				oContext        = oDomRef.firstChild.firstChild; // the toolbar content holder
				sMethod         = 'insertBefore';
				aAdditionalArgs = [oToolbar.getDomRef("mn")];
			} else if (!bMoveItems) {
				// simply remove the popup items from the DOM
				// i.e. oPopupHolder.removeChild(oPopupHolder.firstChild)
				oContext    = oPopupHolder;
				sMethod     = 'removeChild';
			} else {
				jQuery.sap.log.error("The renderer 'sap.ui.commons.ToolbarRenderer' cannot empty the toolbar overflow popup.");

				return;
			}

			while (oPopupHolder.hasChildNodes()) {
				var aArgs = [oPopupHolder.firstChild].concat(aAdditionalArgs);
				oContext[sMethod].apply(oContext, aArgs);
			}

			if (oDomRef && oToolbar.sOriginalStylePropertyWidth) {
				jQuery(oDomRef).width(oToolbar.sOriginalStylePropertyWidth);
				oToolbar.sOriginalStylePropertyWidth = null;
			}
		}
	};


	/**
	 * Returns the area in which the overflow popup should be rendered.
	 *
	 * @param {sap.ui.commons.Toolbar} oToolbar The Toolbar whose popup area is requested
	 *
	 * @private
	 */
	ToolbarRenderer.getPopupArea = function(oToolbar) {
		return oToolbar.getDomRef("pu");
	};

	/**
	 * @param {sap.ui.commons.Toolbar} oToolbar The Toolbar where the overflow button should be set active
	 * @private
	 */
	ToolbarRenderer.setActive = function(oToolbar) {
		oToolbar.$("mn").addClass("sapUiTbOBAct");
	};

	/**
	 * @param {sap.ui.commons.Toolbar} oToolbar The Toolbar where the overflow button should be set not active
	 * @private
	 */
	ToolbarRenderer.unsetActive = function(oToolbar) {
		oToolbar.$("mn").removeClass("sapUiTbOBAct");
	};

	return ToolbarRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ToolbarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TreeRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TreeRenderer
jQuery.sap.declare('sap.ui.commons.TreeRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TreeRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Tree renderer.
	 * @namespace
	 */
	var TreeRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oTree an object representation of the control that should be rendered
	 */
	TreeRenderer.render = function(oRenderManager, oTree){
		// convenience variable
		var rm = oRenderManager;

		//First node get is focusable.
		TreeRenderer.bFirstNodeRendered = false;

		rm.write("<div");
		rm.writeControlData(oTree);
		rm.addClass("sapUiTree");

		if (oTree.getHeight() != "" && oTree.getHeight() != "auto") {
			rm.addClass("sapUiTreeFixedHeight");
		}
		if (!oTree.getShowHeader()) {
			rm.addClass("sapUiTreeTransparent");
		}
		rm.writeClasses();

		rm.addStyle("width", oTree.getWidth() || "auto");
		rm.addStyle("height", oTree.getHeight());
		rm.addStyle("min-width", oTree.getMinWidth());

		rm.writeStyles();

		//ARIA
		rm.writeAttribute('role', 'tree');
		rm.write(">");

		if (oTree.getShowHeader()) {

			rm.write("<div id=\"" + oTree.getId() + "-Header\" class=\"sapUiTreeHeader\""); //Header
			rm.writeAttribute('role', 'heading');
			rm.write(">");

			//Title
			rm.write("<div class='sapUiTreeTitle'");

			if (oTree.getTooltip_AsString()) {
				rm.writeAttributeEscaped( "title", oTree.getTooltip_AsString());//Tree tooltip
			}
			rm.write(">");
			rm.writeEscaped(oTree.getTitle());
			rm.write("</div>");


			if (oTree.getShowHeaderIcons()) {
				rm.write("<div id='" + oTree.getId() + "-TBCont' class='sapUiTreeTbCont'"); //ToolbarContainer
				rm.writeAttribute('role', 'toolbar');
				rm.write(">");
				rm.renderControl(oTree.oCollapseAllButton);
				rm.renderControl(oTree.oExpandAllButton );

				rm.write("</div>");
			}


			rm.write("</div>");//End of Header
		}

		rm.write("<div id=\"" + oTree.getId() + "-TreeCont\""); //tree container


		rm.addClass("sapUiTreeCont");
		var showScroll = oTree.getShowHorizontalScrollbar();
		if (showScroll) {
			rm.addClass("sapUiTreeContScroll");
		} else {
			rm.addClass("sapUiTreeContNoScroll");
		}
		rm.writeClasses();

		rm.write(">");

		// write the HTML into the render manager
		rm.write("<ul class=\"sapUiTreeList\">");

		var aNodes = oTree.getNodes();
		 for (var i = 0;i < aNodes.length;i++) {
		   TreeRenderer.renderNode(rm, aNodes[i], 1, aNodes.length, i + 1);
		}

		rm.write("</ul>");
		rm.write("</div>");//Tree Container
		rm.write("</div>");//Tree
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oNode an object representation of the control that should be rendered
	 * @param {int} iLevel the hierarchical level value of the node
	 */
	TreeRenderer.renderNode = function(oRenderManager, oNode, iLevel, iSize, iPos){
		// convenience variable
		var rm = oRenderManager;
		var bExpanded;

		// write the HTML into the render manager
		rm.write("<li");
		rm.writeElementData(oNode);
		rm.addClass("sapUiTreeNode");

		if (oNode.getExpanded() && (oNode.getHasExpander() || oNode.hasChildren() )) {
			rm.addClass("sapUiTreeNodeExpanded");
			bExpanded = true;
		} else if (!oNode.getExpanded() && (oNode.getHasExpander() || oNode.hasChildren() )) {

			rm.addClass("sapUiTreeNodeCollapsed");
			bExpanded = false;
		}

		if (oNode.getSelectable() && oNode.getIsSelected()) {
			rm.addClass("sapUiTreeNodeSelected");
			rm.writeAttribute('aria-selected', 'true');
		}

		if (!bExpanded && oNode.hasSelectedHiddenChild()) {
			rm.addClass("sapUiTreeNodeSelectedParent");
			rm.writeAttribute('aria-selected', 'true');
		}

		rm.writeClasses(oNode);

		//ARIA
		var mProps = {role: 'treeitem', level: iLevel, setsize: iSize, posinset: iPos};

		if (bExpanded) {
			mProps["expanded"] = true;
		} else {
			// don't write aria expanded attribute if a node has no children
			// if a node has an expander we assume that it also has children
			if (oNode.getHasExpander()) {
				mProps["expanded"] = false;
			}
		}

		rm.writeAccessibilityState(oNode, mProps);

		//Tooltip
		rm.writeAttributeEscaped( "title", oNode.getTooltip_AsString());

		if (!TreeRenderer.bFirstNodeRendered) {
			rm.write("tabindex='0'");
			TreeRenderer.bFirstNodeRendered = true;
		}
		rm.write(">");


		rm.write("<span");  //Node Content

		rm.addClass("sapUiTreeNodeContent");
		if (!oNode.getSelectable()) {
			rm.addClass("sapUiTreeNodeNotSelectable");
		}
		rm.writeClasses();

		rm.write(">");  //Node Content

		if (oNode.getIcon()) {
			rm.writeIcon(oNode.getIcon(), "sapUiTreeIcon");
		}

		rm.writeEscaped( oNode.getText());


		rm.write("</span>"); //Node Content

		rm.write("</li>");

		if (oNode.getNodes()) {
			var aSubNodes = oNode.getNodes();
			rm.write("<ul");

			rm.writeAttribute("id", oNode.getId() + "-children");

			rm.addClass("sapUiTreeChildrenNodes");
			if (!bExpanded) {
				rm.addClass("sapUiTreeHiddenChildrenNodes");
			} else {
				rm.writeAttribute("style", "display: block;");//For animation sake
			}
			rm.writeClasses();

			rm.write(">");
			iLevel++;
			for (var i = 0;i < aSubNodes.length;i++) {
				TreeRenderer.renderNode(rm, aSubNodes[i], iLevel, aSubNodes.length, i + 1);
			}
			rm.write("</ul>");
		}
	};


	return TreeRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TreeRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TriStateCheckBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TriStateCheckBox
jQuery.sap.declare('sap.ui.commons.TriStateCheckBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TriStateCheckBoxRenderer",['jquery.sap.global', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, ValueStateSupport) {
	"use strict";


	/**
	 * @author SAP SE
	 * @namespace
	 */
	var TriStateCheckBoxRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TriStateCheckBoxRenderer.render = function(oRm, oControl) {
		var myTabIndex = 0;
		var bReadOnly = false;

		// Collect state information
		var enabled = !!oControl.getEnabled();
		var editable = !!oControl.getEditable();
		var inErrorState = false;
		var inWarningState = false;
		var selectedState = oControl.getSelectionState();
		var ariaState = selectedState.toLowerCase();
		if (ariaState == "checked") {
			ariaState = true;
		} else if (ariaState == "unchecked") {
			ariaState = false;
		}
		var tooltip = ValueStateSupport.enrichTooltip(oControl, oControl.getTooltip_AsString());
		var ariaLabelId = "sapUiAriaLabel" + oControl.getIdForLabel();
		if (oControl.getValueState() != null) {
			inErrorState = sap.ui.core.ValueState.Error == oControl.getValueState();
			inWarningState = sap.ui.core.ValueState.Warning == oControl.getValueState();
		}

		// write the HTML into the render manager
		//outer span containing aria information, tabindex, text and tooltip etc.
		oRm.write("<span");
		oRm.writeControlData(oControl);

		oRm.addClass("sapUiTriCb");

		if (!!oControl.getWidth()) {
			oRm.writeAttribute("style", "width:" + oControl.getWidth() + ";");
		}
		oRm.writeAccessibilityState(oControl, {
			"role" : sap.ui.core.AccessibleRole.Checkbox.toLowerCase(),
			"checked" : ariaState
			});
		oRm.writeClasses();
		if (!enabled) {
			myTabIndex = -1;
		}
		oRm.writeAttribute("tabIndex", myTabIndex);
		oRm.write(">");

		// inner span carrying metadata and style according to the current state
		oRm.write("<span");

		oRm.writeAccessibilityState(oControl, {"labelledby": ariaLabelId});

		if (tooltip) {
			oRm.writeAttributeEscaped("title", tooltip);
		}

		if (!enabled) {
			bReadOnly = true;
			myTabIndex = -1;
			oRm.write(" disabled='disabled'");
		}

		if (!editable) {
			bReadOnly = true;
		}

		if (bReadOnly) {
			oRm.write(" readOnly='readOnly'");
		}

		oRm.addClass("sapUiTriCbInner");

		if (!enabled) {
			oRm.addClass("sapUiTriCbDis");
		}

		if (!editable) {
			oRm.addClass("sapUiTriCbRo");
		}

		if (inErrorState) {
			oRm.addClass("sapUiTriCbErr");
		} else if (inWarningState) {
			oRm.addClass("sapUiTriCbWarn");
		}

		// Add classes and properties depending on the state
		if (selectedState === "Checked") {
			oRm.addClass("sapUiTriCbCheck");
		} else if (selectedState === "Mixed") {
			oRm.addClass("sapUiTriCbMix");
		}

		oRm.writeClasses();
		oRm.write(">"); // span element
		oRm.write("</span>");

	// render text into the outer span
		if (oControl.getText()) {
			this.renderText(ariaLabelId, oRm, oControl.getText(), oControl.getTextDirection());
		}
		oRm.write("</span>");

	};

	/**
	 * Write the descriptive span for the CheckBox along with an explicit "dir" in case the text direction is different from the environment.
	 * Add sLabelId as id for aria-labelledby support
	 *
	 */
	 TriStateCheckBoxRenderer.renderText = function(sLabelId, oRenderManager, sText, eTextDirection) {
		var oRm = oRenderManager;
		oRm.write("<span id=" + sLabelId + " class=\"sapUiTriCbLbl\"");
		if (!eTextDirection || eTextDirection == sap.ui.core.TextDirection.Inherit) {
			oRm.write(">");
			oRm.writeEscaped(sText);
		} else {
			oRm.write(" style=\"direction:" + eTextDirection.toLowerCase() + ";\">");
			oRm.writeEscaped(sText);
		}
		oRm.write("</span>");
	};

	return TriStateCheckBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TriStateCheckBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ValueHelpFieldRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ValueHelpField
jQuery.sap.declare('sap.ui.commons.ValueHelpFieldRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ValueHelpFieldRenderer",['jquery.sap.global', './TextFieldRenderer'],
	function(jQuery, TextFieldRenderer) {
	"use strict";


	/**
	 * ValueHelpField renderer.
	 * For a common look&feel, the ValueHelpField extends the TextField control,
	 * just like the ComboBox does.
	 * @namespace
	 */
	var ValueHelpFieldRenderer = sap.ui.core.Renderer.extend(TextFieldRenderer);
	
	/**
	 * Hint: "renderOuterAttributes" is a reserved/hard-coded TextField extending function!
	 *       It is used to allow extensions to display help icons.
	 * @param {sap.ui.core.RenderManager}
	 *            rm the RenderManager currently rendering this control
	 * @param {sap.ui.commons.ValueHelpField}
	 *            oControl the ValueHelpField whose "value help" should be rendered
	 * @private
	 */
	ValueHelpFieldRenderer.renderOuterAttributes = function(rm, oControl) {
		// To share the overall ComboBox styling:
		// Note: Would be best if a more generic className had been used for this, like
		//       "sapUiTfIconContainer", as ComboBox and DatePicker and ValueHelpField are likely
		//       to always share a common container look. (Only icon should differ.)
		//       Then, in the unlikely case where one of them would want to differ from the
		//       others, then this one would only need to add its own className on top of
		//       the generic one, e.g. "sapUiTfDateContainer" for the DatePicker.
		// Referencing "sapUiTfCombo" for now.
		rm.addClass("sapUiTfCombo");
	//as only input field gets focus, render aria info there
		rm.writeAttribute("aria-owns", oControl.getId() + '-input ' + oControl.getId() + '-icon');
	};
	
	/**
	 * Renders additional HTML for the ComboBox to the TextField (sets the icon)
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for
	 *                                                 writing to the Render-Output-Buffer.
	 * @param {sap.ui.fw.Control} oControl An object representation of the control that should
	 *                                     be rendered.
	 */
	ValueHelpFieldRenderer.renderOuterContent = function(rm, oControl){
	
		var sIconUrl = oControl.getIconURL();
		var aClasses = [];
		var mAttributes = {};
		mAttributes["id"] = oControl.getId() + "-icon";
		mAttributes["role"] = "button";
	
		// As mentioned above, a more generic "sapUiTfIcon" className could have been used...
		// One would just have had to add its own icon className!
		// Using "sapUiTfValueHelpIcon" for now, as it proved easier to define instead of overwriting
		// the ComboBox image sources and backgrounds.
		aClasses.push("sapUiTfValueHelpIcon");
	
		if (sIconUrl && sap.ui.core.IconPool.isIconURI(sIconUrl)) {
			oControl.bIsIconURI = true;
		} else {
			oControl.bIsIconURI = false;
			if (oControl.getEnabled() && oControl.getEditable()) {
				aClasses.push("sapUiTfValueHelpRegularIcon");
			}
	
			sIconUrl = this.renderIcon(rm, oControl, aClasses);
		}
	
		rm.writeIcon(sIconUrl, aClasses, mAttributes);
	
	};
	
	/**
	 * as onBeforeRendering only runs while re-rendering this module is called in renderer
	 */
	ValueHelpFieldRenderer.renderIcon = function(rm, oControl, aClasses){
	
		var sIcon = "";
	
		if (!oControl.getEnabled()) {
			if (oControl.getIconDisabledURL()) {
				oControl.sIconDsblUrl = oControl.getIconDisabledURL();
			} else if (oControl.getIconURL()) {
				oControl.sIconDsblUrl = oControl.getIconURL();
				aClasses.push('sapUiTfValueHelpDsblIcon');
			}
			sIcon = oControl.sIconDsblUrl;
		} else {
			if (oControl.getIconURL()) {
				oControl.sIconRegularUrl = oControl.getIconURL();
			}
			sIcon = oControl.sIconRegularUrl;
		}
		return sIcon;
	
	};
	
	///**
	// * Renders ARIA information for the outer DIV
	// *
	// * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for
	// *                                                 writing to the Render-Output-Buffer
	// * @param {sap.ui.fw.Control} oControl an object representation of the control that should
	// *                                     be rendered
	// */
	//sap.ui.commons.ValueHelpFieldRenderer.renderARIAInfo = function(rm, oControl) {
	//	if ( sap.ui.getCore().getConfiguration().getAccessibility()){
	//	// Widgets are discrete user interface objects with which the user can interact.
	//	// Widget roles map to standard features in accessibility APIs.
	//	// When a user navigates an element assigned any of the non-abstract subclass roles of widget,
	//	// assistive technologies that typically intercept standard keyboard events SHOULD switch to
	//	// an application browsing mode, and pass keyboard events through to the web application.
	//	// The intent is to hint to certain assistive technologies to switch from normal browsing mode
	//	// into a mode more appropriate for interacting with a web application; some user agents have
	//	// a browse navigation mode where keys, such as up and down arrows, are used to browse the
	//	// document, and this native behavior prevents the use of these keys by a web application.
	//		rm.writeAttribute('role', 'widget');
	//		rm.writeAttribute('aria-haspopup', 'true');
	//		// IMPORTANT: According to jQuery forums, DatePicker Accessibility is to be delivered in a
	//		//            future release. No release mentionned.
	//		// So there is not much point about doing more about this at the moment.
	//	}
	//};

	return ValueHelpFieldRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ValueHelpFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.FormLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.commons.form.FormLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.FormLayoutRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/form/FormLayoutRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/form/FormLayoutRenderer'],
	function(jQuery, Renderer, FormLayoutRenderer1) {
	"use strict";


	var FormLayoutRenderer = Renderer.extend(FormLayoutRenderer1);
	 

	return FormLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/form/FormLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.FormRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.form.FormRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.FormRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/form/FormRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/form/FormRenderer'],
	function(jQuery, Renderer, FormRenderer1) {
	"use strict";


	var FormRenderer = Renderer.extend(FormRenderer1);

	return FormRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/form/FormRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.GridLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.commons.form.GridLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.GridLayoutRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/form/GridLayoutRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/form/GridLayoutRenderer'],
	function(jQuery, Renderer, GridLayoutRenderer1) {
	"use strict";


	var GridLayoutRenderer = Renderer.extend(GridLayoutRenderer1);

	return GridLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/form/GridLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.ResponsiveLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.commons.form.ResponsiveLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.ResponsiveLayoutRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/form/ResponsiveLayoutRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/form/ResponsiveLayoutRenderer'],
	function(jQuery, Renderer, ResponsiveLayoutRenderer1) {
	"use strict";


	var ResponsiveLayoutRenderer = Renderer.extend(ResponsiveLayoutRenderer1);

	return ResponsiveLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/form/ResponsiveLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.form.SimpleFormRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.commons.form.SimpleFormRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.SimpleFormRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/form/SimpleFormRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/form/SimpleFormRenderer'],
	function(jQuery, Renderer, SimpleFormRenderer1) {
	"use strict";


	var SimpleFormRenderer = Renderer.extend(SimpleFormRenderer1);

	return SimpleFormRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/form/SimpleFormRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.AbsoluteLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.AbsoluteLayout
jQuery.sap.declare('sap.ui.commons.layout.AbsoluteLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/layout/AbsoluteLayoutRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * AbsoluteLayout renderer.
	 * @namespace
	 */
	var AbsoluteLayoutRenderer = {
	};
	
	
	(function() {
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	AbsoluteLayoutRenderer.render = function(oRenderManager, oControl){
		var rm = oRenderManager;
	
		oControl.doBeforeRendering();

		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiLayoutAbs");
		rm.addClass("sapUiLayoutAbsOvrflwY" + oControl.getVerticalScrolling());
		rm.addClass("sapUiLayoutAbsOvrflwX" + oControl.getHorizontalScrolling());
		rm.writeClasses();
		var sStyle = "width:" + oControl.getWidth() + ";height:" + oControl.getHeight() + ";";
		rm.writeAttribute("style", sStyle);
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write(">");
	
		var aPositions = oControl.getPositions();
		if (aPositions && aPositions.length > 0) {
			for (var index = 0; index < aPositions.length; index++) {
				var oPosition = aPositions[index];
				var oChildControl = oPosition.getControl();
				if (oChildControl) {
					rm.write("<div");
					rm.writeElementData(oPosition);
					rm.writeAttribute("class", "sapUiLayoutAbsPos");
					rm.writeAttribute("style", getComputedStyles(oPosition));
					sTooltip = oPosition.getTooltip_AsString();
					if (sTooltip) {
						rm.writeAttributeEscaped("title", sTooltip);
					}
					rm.write(">");
					rm.renderControl(oChildControl);
					rm.write("</div>");
				}
			}
		}
	
		rm.write("</div>");
	};
	
	
	/**
	 * Updates the size of the layout.
	 *
	 * @private
	 */
	AbsoluteLayoutRenderer.updateLayoutSize = function(oLayout) {
		jQuery(oLayout.getDomRef()).css("width", oLayout.getWidth()).css("height", oLayout.getHeight());
	};
	
	
	/**
	 * Updates the scrolling mode of the layout.
	 *
	 * @private
	 */
	AbsoluteLayoutRenderer.updateLayoutScolling = function(oLayout) {
		var jLayout = jQuery(oLayout.getDomRef());
		for (var sScrollingType in sap.ui.core.Scrolling) {
			jLayout.removeClass("sapUiLayoutAbsOvrflwY" + sScrollingType).removeClass("sapUiLayoutAbsOvrflwX" + sScrollingType);
		}
		jLayout.addClass("sapUiLayoutAbsOvrflwY" + oLayout.getVerticalScrolling()).addClass("sapUiLayoutAbsOvrflwX" + oLayout.getHorizontalScrolling());
	};
	
	
	/**
	 * Updates the styles of the given position in the Dom.
	 *
	 * @private
	 */
	AbsoluteLayoutRenderer.updatePositionStyles = function(oPosition) {
		jQuery(oPosition.getDomRef()).attr("style", getComputedStyles(oPosition));
	};
	
	
	/**
	 * Removes the given position from the Dom.
	 *
	 * @private
	 */
	AbsoluteLayoutRenderer.removePosition = function(oPosition) {
		jQuery(oPosition.getDomRef()).remove();
	};
	
	
	/**
	 * Removes all positions of the given layout from the Dom.
	 *
	 * @private
	 */
	AbsoluteLayoutRenderer.removeAllPositions = function(oLayout) {
		jQuery(oLayout.getDomRef()).html("");
	};
	
	
	/**
	 * Updates the styles and the content of the given position in the Dom.
	 *
	 * @private
	 */
	AbsoluteLayoutRenderer.updatePositionedControl = function(oPosition) {
		AbsoluteLayoutRenderer.updatePositionStyles(oPosition);
		var rm = sap.ui.getCore().createRenderManager();
		rm.renderControl(oPosition.getControl());
		rm.flush(oPosition.getDomRef());
		rm.destroy();
	};
	
	
	/**
	 * Inserts the given position into the Dom incl. the content and updating the styles.
	 *
	 * @private
	 */
	AbsoluteLayoutRenderer.insertPosition = function(oLayout, oPosition) {
		var index = oLayout.indexOfPosition(oPosition);
		var oPositions = oLayout.getPositions();
		var oPredecessorPosition = null;
		while (index > 0) {
			index--;
			if (oPositions[index].getDomRef()) {
				oPredecessorPosition = oPositions[index];
				break;
			}
		}
	
		var sHTML = "<div id=\"" + oPosition.getId() + "\" data-sap-ui=\"" + oPosition.getId() + "\" class=\"sapUiLayoutAbsPos\"></div>";
		if (!oPredecessorPosition) {
			jQuery(oLayout.getDomRef()).prepend(sHTML);
		} else {
			jQuery(oPredecessorPosition.getDomRef()).after(sHTML);
		}
	
		AbsoluteLayoutRenderer.updatePositionedControl(oPosition);
	};
	
	
	/**
	 * Computes and returns the CSS styles for the given position.
	 *
	 * @private
	 */
	var getComputedStyles = function(oPosition) {
		var oPos = oPosition.getComputedPosition();
	
		var addStyle = function(oPosition, aBuffer, sPos, sVal){
			if (sVal) {
				aBuffer.push(sPos + ":" + sVal + ";");
			}
		};
	
		var aBuffer = [];
		addStyle(oPosition, aBuffer, "top", oPos.top);
		addStyle(oPosition, aBuffer, "bottom", oPos.bottom);
		addStyle(oPosition, aBuffer, "left", oPos.left);
		addStyle(oPosition, aBuffer, "right", oPos.right);
		addStyle(oPosition, aBuffer, "width", oPos.width);
		addStyle(oPosition, aBuffer, "height", oPos.height);
	
		return aBuffer.join("");
	};
	
	}());

	return AbsoluteLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/layout/AbsoluteLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.BorderLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.BorderLayout
jQuery.sap.declare('sap.ui.commons.layout.BorderLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/layout/BorderLayoutRenderer",['jquery.sap.global', 'jquery.sap.encoder'],
	function(jQuery/* , jQuerySap */) {
	"use strict";


	
	/**
	 * BorderLayout renderer.
	 * @namespace
	 */
	var BorderLayoutRenderer = {};
	
	(function() {
		/**
		 * Renders the HTML for the given control, using the provided
		 * {@link sap.ui.core.RenderManager}.
		 * 
		 * @param {sap.ui.core.RenderManager}
		 *            oRenderManager the RenderManager that can be used for writing
		 *            to the Render-Output-Buffer
		 * @param {sap.ui.core.Control}
		 *            oControl an object representation of the control that should
		 *            be rendered
		 */
		BorderLayoutRenderer.render = function(oRm, oControl) {
			var mAreas = {
				top : oControl.getTop(),
				begin : oControl.getBegin(),
				center : oControl.getCenter(),
				end : oControl.getEnd(),
				bottom : oControl.getBottom()
			};
			var mAreaSizes = {
				top : sizeOf(mAreas.top),
				begin : sizeOf(mAreas.begin),
				center : sizeOf(mAreas.center),
				end : sizeOf(mAreas.end),
				bottom : sizeOf(mAreas.bottom)
			};
			var bRTL = sap.ui.getCore().getConfiguration().getRTL();
	
			// open the outer HTML tag
			oRm.write("<div");
			// let control data be written so that connection to SAPUI5 eventing
			// gets established
			oRm.writeControlData(oControl);
			oRm.addClass("sapUiBorderLayout");
			oRm.addStyle("width", oControl.getWidth());
			oRm.addStyle("height", oControl.getHeight());
			oRm.writeClasses();
			oRm.writeStyles();
			// don't forget to close the HTML tag
			oRm.write(">");
	
			/* render areas */
			if (mAreas.top/* && oTop.getVisible() */) {
				renderArea(oRm, "top", mAreas.top, mAreaSizes, bRTL);
			}
			if (mAreas.begin/* && oBegin.getVisible() */) {
				renderArea(oRm, "begin", mAreas.begin, mAreaSizes, bRTL);
			}
			if (mAreas.center && mAreas.center.getVisible()) {
				renderArea(oRm, "center", mAreas.center, mAreaSizes, bRTL);
			}
			if (mAreas.end/* && oEnd.getVisible() */) {
				renderArea(oRm, "end", mAreas.end, mAreaSizes, bRTL);
			}
			if (mAreas.bottom/* && oBottom.getVisible() */) {
				renderArea(oRm, "bottom", mAreas.bottom, mAreaSizes, bRTL);
			}
	
			// close surrounding div
			oRm.write("</div>");
		};
	
		BorderLayoutRenderer.animate = function(oArea, bVisible) {
			// var sBorderLayoutId = oBorderLayout.getId();
			var bRTL = sap.ui.getCore().getConfiguration().getRTL();
			var end = bVisible ? oArea.getSize() : "0";
	
			switch (oArea.getAreaId()) {
			case "top":
				$area(oArea, "top").animate({
					height : end
				});
				$area(oArea, "begin").animate({
					top : end
				});
				$area(oArea, "center").animate({
					top : end
				});
				$area(oArea, "end").animate({
					top : end
				});
				break;
	
			case "begin":
				$area(oArea, "begin").animate({
					width : end
				});
				$area(oArea, "center").animate(bRTL ? {
					right : end
				} : {
					left : end
				});
				break;
	
			case "end":
				$area(oArea, "center").animate(bRTL ? {
					left : end
				} : {
					right : end
				});
				$area(oArea, "end").animate({
					width : end
				});
				break;
	
			case "bottom":
				$area(oArea, "begin").animate({
					bottom : end
				});
				$area(oArea, "center").animate({
					bottom : end
				});
				$area(oArea, "end").animate({
					bottom : end
				});
				$area(oArea, "bottom").animate({
					height : end
				});
				break;
	
			default:
				break;
			}
	
		};
	
		function sizeOf(oArea) {
			var oSize = oArea && oArea.getVisible() && oArea.getSize();
			return oSize || "0";
		}
	
		function renderArea(oRm, sAreaId, oArea, mAreaSizes, bRTL) {
			var aAreaControls = oArea.getContent();
			var length = aAreaControls.length;
	
			oRm.write("<div");
			oRm.writeAttribute("id", oArea.getId());
			// collect styles and classes depending on area type
			switch (sAreaId) {
			case "top":
				oRm.addClass("sapUiBorderLayoutTop");
				oRm.addStyle("height", mAreaSizes.top);
				break;
			case "begin":
				oRm.addClass("sapUiBorderLayoutBegin");
				oRm.addStyle("width", mAreaSizes.begin);
				oRm.addStyle("top", mAreaSizes.top);
				oRm.addStyle("bottom", mAreaSizes.bottom);
				break;
			case "center":
				oRm.addClass("sapUiBorderLayoutCenter");
				oRm.addStyle("top", mAreaSizes.top);
				oRm.addStyle("right", bRTL ? mAreaSizes.begin : mAreaSizes.end);
				oRm.addStyle("bottom", mAreaSizes.bottom);
				oRm.addStyle("left", bRTL ? mAreaSizes.end : mAreaSizes.begin);
				break;
			case "end":
				oRm.addClass("sapUiBorderLayoutEnd");
				oRm.addStyle("width", mAreaSizes.end);
				oRm.addStyle("top", mAreaSizes.top);
				oRm.addStyle("bottom", mAreaSizes.bottom);
				break;
			case "bottom":
				oRm.addClass("sapUiBorderLayoutBottom");
				oRm.addStyle("height", mAreaSizes.bottom);
				break;
			default:
				jQuery.sap.assert("default branch must not be reached");
				break;
			}
	
			// add overflow definition to the style-attribute value
			oRm.addStyle("overflow-x", jQuery.sap.encodeHTML(oArea.getOverflowX() || ""));
			oRm.addStyle("overflow-y", jQuery.sap.encodeHTML(oArea.getOverflowY() || ""));
	
			// write alignment
			var sAlign = oArea.getContentAlign();
			if (bRTL) {
				if (sAlign === "right") {
					sAlign = "left";
				} else if (sAlign === "left") {
					sAlign = "right";
				}
			}
			oRm.addStyle("text-align", jQuery.sap.encodeHTML(sAlign || ""));
	
			oRm.writeClasses(oArea);
			oRm.writeStyles();
	
			oRm.write(">");
	
			// render the controls
			for ( var i = 0; i < length; i++) {
				oRm.renderControl(aAreaControls[i]);
			}
	
			oRm.write("</div>");
		}
	
		function $area(oArea, sAreaId) {
			var oOtherArea = oArea.getParent().getArea(sAreaId);
			return oOtherArea ? oOtherArea.$() : jQuery();
		}
	}());

	return BorderLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/layout/BorderLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.HorizontalLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.layout.HorizontalLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.HorizontalLayoutRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/layout/HorizontalLayoutRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/HorizontalLayoutRenderer'],
	function(jQuery, Renderer, HorizontalLayoutRenderer1) {
	"use strict";


	var HorizontalLayoutRenderer = Renderer.extend(HorizontalLayoutRenderer1);

	return HorizontalLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/layout/HorizontalLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.MatrixLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.MatrixLayout
jQuery.sap.declare('sap.ui.commons.layout.MatrixLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/layout/MatrixLayoutRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * MatrixLayout renderer.
	 *
	 * @author d029921
	 * @namespace
	 */
	var MatrixLayoutRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oMatrixLayout an object representation of the control that should be rendered
	 */
	MatrixLayoutRenderer.render = function(oRenderManager, oMatrixLayout) {
		// some convenience variables.
		var rm = oRenderManager;
		var r = MatrixLayoutRenderer;
		var bRTL = sap.ui.getCore().getConfiguration().getRTL();
	
		//ARIA
		rm.write("<TABLE role=\"presentation\"");
		rm.writeControlData(oMatrixLayout);
		rm.write(" cellpadding=\"0\" cellspacing=\"0\"");
		rm.addStyle("border-collapse", "collapse");
	
		var sMatrixWidth = oMatrixLayout.getWidth();
		if (sMatrixWidth) {
			rm.addStyle("width", sMatrixWidth);
		}
	
		var sMatrixHeight = oMatrixLayout.getHeight();
		if (sMatrixHeight && sMatrixHeight != 'auto') {
			rm.addStyle("height", sMatrixHeight);
			// get value and unit of Layout height (to determine row heights if given in %)
			var oMatrixHeight = r.getValueUnit( sMatrixHeight );
		}
	
		if (oMatrixLayout.getLayoutFixed()) {
			// table layout is fixed
			rm.addStyle("table-layout", "fixed");
			if (!sMatrixWidth) {
				rm.addStyle("width", "100%");
			}
		}
	
		rm.addClass("sapUiMlt");
		rm.writeStyles();
		rm.writeClasses();
	
		if (oMatrixLayout.getTooltip_AsString()) {
			rm.writeAttributeEscaped('title', oMatrixLayout.getTooltip_AsString());
		}
	
		// close table-start-tag
		rm.write('>');
	
		var aRows = oMatrixLayout.getRows();
		var iCols = oMatrixLayout.getColumns();
		if (iCols < 1) {
			// determine number of columns
			for (var i = 0; i < aRows.length; i++) {
				var oMatrixLayoutRow = aRows[i];
				var aCells = oMatrixLayoutRow.getCells();
				if ( iCols < aCells.length) {
					iCols = aCells.length;
				}
			}
		}
	
		// create columns
		if (iCols > 0) {
			var aWidths = oMatrixLayout.getWidths();
			rm.write("<colgroup>");
			for (var j = 0; j < iCols; j++) {
				rm.write("<col");
				if (aWidths && aWidths[j] && aWidths[j] != "auto") {
					rm.addStyle('width', aWidths[j]); // use style because col width in HTML supports only be px or %
					rm.writeStyles();
				}
				rm.write("/>");
			}
			rm.write("</colgroup>");
		}
	
		// in IE9 there is a problem with column width if too much colspans are used and not
		// at least one cell per columns has colspan 1
		// to keep the check simple just check if in every row colspans are used
		var bDummyRow = true;
		var bColspanInRow = false;
	
		rm.write('<TBODY style="width: 100%; height: 100%">');
	
		// for each row
		for (var i = 0; i < aRows.length; i++) {
			var oMatrixLayoutRow = aRows[i];
	
			// get value and unit of Row height (to determine row heights if given in %)
			var sRowHeight = oMatrixLayoutRow.getHeight();
			if (sRowHeight == "auto") {
				//ignore auto because without rowHeight it's auto sized
				sRowHeight = "";
			}
			if (sRowHeight && oMatrixHeight) {
				var oRowHeight = r.getValueUnit( sRowHeight );
				if ( oRowHeight.Unit == '%' && oMatrixHeight.Unit != '%') {
					// Matrix has fix height and Row % -> calculate Row height to fix value
					sRowHeight = ( oMatrixHeight.Value * oRowHeight.Value / 100 ) + oMatrixHeight.Unit;
				}
			}
	
			rm.write("<tr");
			rm.writeElementData(oMatrixLayoutRow);
			rm.writeClasses(oMatrixLayoutRow);
			if (oMatrixLayoutRow.getTooltip_AsString()) {
				rm.writeAttributeEscaped('title', oMatrixLayoutRow.getTooltip_AsString());
			}
	
			if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version >= 9 && sRowHeight) {
				// for IE9 and IE10 in some cases the height is needed on TR, so it's added here.
				// Other browsers don't need it here
				// TD must have the same height even it looks wrong
				// (e.g. TR must have 30% and TD must have 30% to show a 30% height row)
				rm.addStyle("height", sRowHeight);
				rm.writeStyles();
			}
			rm.write(">");
	
			// for each cell
			var aCells = oMatrixLayoutRow.getCells();
	
			var iColumns = iCols;
			if (iCols < 1) {
				// render only defined cells
				iColumns = aCells.length;
			}
	
			bColspanInRow = false;
			var iColSpans = 0;
			if (!oMatrixLayoutRow.RowSpanCells) {
				oMatrixLayoutRow.RowSpanCells = 0;
			} else {
				bColspanInRow = true; // not really but ok for this case
			}
	
			for (var j = 0; j < iColumns; j++) {
				if (j >= (iColumns - iColSpans - oMatrixLayoutRow.RowSpanCells)) {
				// no more cells because of Colspan
					break;
				}
	
				var oMatrixLayoutCell = aCells[j];
	
				rm.write("<td");
	
				if (sRowHeight && ( !oMatrixLayoutCell || oMatrixLayoutCell.getRowSpan() == 1 )) {
					// set height only if cell has no rowspan or is not specified
					rm.addStyle("height", sRowHeight);
				}
	
				if (oMatrixLayoutCell) {
					// if empty cell only render empty TD
					rm.writeElementData(oMatrixLayoutCell);
					if (oMatrixLayoutCell.getTooltip_AsString()) {
						rm.writeAttributeEscaped('title', oMatrixLayoutCell.getTooltip_AsString());
					}
	
					if (oMatrixLayout.getLayoutFixed() && oMatrixLayoutCell.getContent().length > 0) {
						// table layout is fixed
						rm.addStyle("overflow", "hidden");
						// as in Firefox 10 ellipsis makes problems it is removed.
						// controls inside of matrix cells should bring their own ellipsis function
						// However, ellipsis on cells can only work if included control has 100% size of cell,
						// otherwise (if control is bigger) its only cut.
						//rm.addStyle("text-overflow", "ellipsis");
					}
	
					var sHAlign = r.getHAlignClass(oMatrixLayoutCell.getHAlign(), bRTL);
					if (sHAlign) {
						rm.addClass(sHAlign);
					}
					var sVAlign = r.getVAlign(oMatrixLayoutCell.getVAlign());
					if (sVAlign) {
						rm.addStyle("vertical-align", sVAlign);
					}
					if (oMatrixLayoutCell.getColSpan() > 1) {
						rm.writeAttribute("colspan", oMatrixLayoutCell.getColSpan());
						iColSpans = iColSpans + oMatrixLayoutCell.getColSpan() - 1;
						bColspanInRow = true;
					}
					if (oMatrixLayoutCell.getRowSpan() > 1) {
						rm.writeAttribute("rowspan", oMatrixLayoutCell.getRowSpan());
	
						// summarize height of all used rows
						var fValue = 0;
						var sUnit = "";
						for (var x = 0; x < oMatrixLayoutCell.getRowSpan(); x++) {
							var oRow = aRows[i + x];
	
							if (!oRow) {
								sUnit = false;
								break;
							}
	
							if (!oRow.RowSpanCells) {
								oRow.RowSpanCells = 0;
							}
	
							if (x > 0) {
								// add number of cells with rowspan to following rows to not render additional cells
								oRow.RowSpanCells = oRow.RowSpanCells + oMatrixLayoutCell.getColSpan();
							}
							var sHeight = oRow.getHeight();
							if (!sHeight || sHeight == "auto") {
								//no height defined for one row -> no summarize possible
								sUnit = false;
								//break;
							} else {
								var oHeight = r.getValueUnit( sHeight );
								if ( oHeight.Unit == '%' && oMatrixHeight.Unit != '%') {
									// Matrix has fix height and Row % -> calculate Row height to fix value
									oHeight.Value = ( oMatrixHeight.Value * oRowHeight.Value / 100 );
									oHeight.Unit  = oMatrixHeight.Unit;
								}
								if (sUnit == "") {
									sUnit = oHeight.Unit;
								} else {
									if (sUnit != oHeight.Unit) {
										//different unit -> no summarize possible
										sUnit = false;
										//break;
									}
								}
								fValue = fValue + oHeight.Value;
							}
						}
						if (sUnit != false) {
							var sSpanHeight = fValue + sUnit;
							rm.addStyle("height", sSpanHeight);
						}
					}
	
					// set CSS class for appropriate background
					rm.addClass(r.getBackgroundClass(oMatrixLayoutCell.getBackgroundDesign()));
	
					// set CSS class for appropriate separator
					rm.addClass(r.getSeparationClass(oMatrixLayoutCell.getSeparation()));
	
					if (!oMatrixLayout.getLayoutFixed() || !sRowHeight) {
						// set CSS class for appropriate padding
						rm.addClass(r.getPaddingClass(oMatrixLayoutCell.getPadding()));
	
						rm.addClass("sapUiMltCell");
					} else {
						rm.addStyle("white-space", "nowrap");
					}
	
	
					rm.writeClasses(oMatrixLayoutCell);
				}
				rm.writeStyles();
	
				// close td-start-tag
				rm.write(">");
	
				if (oMatrixLayoutCell) {
					// if empty cell only render empty TD
	
					if (oMatrixLayout.getLayoutFixed() && sRowHeight) {
						// table layout is fixed
						// in case of defined height some DIVs are needed.
						// 1. one DIV to define height
						// 2. DIV to set vertical alignment
						// 3. DIV inside 2. DIV to set paddings for control inside.
						rm.write('<div');
	
						if ( oMatrixLayoutCell.getRowSpan() != 1 && sSpanHeight && sSpanHeight.search('%') == -1) {
							rm.addStyle("height", sSpanHeight);
						} else if (sRowHeight.search('%') != -1 || (oMatrixLayoutCell.getRowSpan() != 1 && !sSpanHeight)) {
							rm.addStyle("height", '100%');
						} else {
							rm.addStyle("height", sRowHeight);
						}
	
						rm.addStyle("display", "inline-block");
						if (sVAlign) {
							rm.addStyle("vertical-align", sVAlign);
						}
						rm.writeStyles();
						rm.writeClasses(false);
						rm.write("></div>");
						rm.write('<div');
						rm.addStyle("display", "inline-block");
						if (sVAlign) {
							rm.addStyle("vertical-align", sVAlign);
						}
						if ( oMatrixLayoutCell.getRowSpan() != 1 && sSpanHeight && sSpanHeight.search('%') == -1) {
							rm.addStyle("max-height", sSpanHeight);
						} else if (sRowHeight.search('%') != -1 || (oMatrixLayoutCell.getRowSpan() != 1 && !sSpanHeight)) {
							rm.addStyle("max-height", '100%');
						} else {
							rm.addStyle("max-height", sRowHeight);
						}
						/* determine height of content (if its a property there)
						   and set it to DIV (if possible) */
						var sDivHeight = "0";
						var sDivUnit = "";
						var sInnerDivHeight = "0";
						var aContentControls = oMatrixLayoutCell.getContent();
						for (var index = 0, length = aContentControls.length; index < length; index++) {
							if (aContentControls[index].getHeight && aContentControls[index].getHeight() != "") {
								// check unit
								var oControlHeight = r.getValueUnit( aContentControls[index].getHeight() );
								if (oControlHeight) {
									if (sDivUnit == "") {
										sDivUnit = oControlHeight.Unit;
									}
									if (sDivUnit != oControlHeight.Unit) {
										// different units in content controls not allowed -> use 100%
										sDivUnit = "%";
										sDivHeight = "100";
										break;
									}
									if (oControlHeight.Unit == "%") {
										// give %-height to outer DIV but the reverse %-height to the inner DIV
										// -> height of the content is right
										if (parseFloat(sDivHeight) < parseFloat(oControlHeight.Value)) {
											sDivHeight = oControlHeight.Value;
											if (sDivHeight != "100") {
												sInnerDivHeight = 10000 / parseFloat(sDivHeight);
											}
										}
									}// for fix units no calculation needed -DIVs get the size automatically
								}
							}
						}
						if (sDivHeight != "0") {
							rm.addStyle("height", sDivHeight + sDivUnit);
						}
						rm.addStyle("white-space", "normal");
						rm.addStyle("width", "100%");
						rm.writeStyles();
						rm.writeClasses(false);
	
						rm.write("><div");
						rm.addStyle("overflow", "hidden");
						rm.addStyle("text-overflow", "inherit");
						if (sDivHeight != "0") {
							if (sInnerDivHeight != "0") {
								rm.addStyle("height", sInnerDivHeight + "%");
							} else {
								rm.addStyle("height", "100%");
							}
						}
						rm.addClass("sapUiMltCell");
	
						// set CSS class for appropriate padding
						rm.addClass(r.getPaddingClass(oMatrixLayoutCell.getPadding()));
	
						rm.writeStyles();
						rm.writeClasses(false);
						rm.write(">"); // DIV
					}
					var aContentControls = oMatrixLayoutCell.getContent();
					for (var index = 0, length = aContentControls.length; index < length; index++) {
						oRenderManager.renderControl(aContentControls[index]);
					}
					if (oMatrixLayout.getLayoutFixed() && sRowHeight) {
						// table layout is fixed
						rm.write("</div></div>");
					}
				}
	
				// close cell
				rm.write("</td>");
			}
	
			// close row
			rm.write("</tr>");
	
			// initialize RowSpanCounter after Row is rendered
			oMatrixLayoutRow.RowSpanCells = undefined;
	
			if (!bColspanInRow) {
				bDummyRow = false;
			}
		} // end of rows-rendering
	
		if (bDummyRow && sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version >= 9) {
			// render dummy row to help IE9 to calculate column sizes
			rm.write("<tr style='height:0;'>");
			for ( var i = 0; i < iCols; i++) {
				rm.write("<td></td>");
			}
			rm.write("</tr>");
		}
	
		// close tbody, close table
		rm.write("</TBODY></TABLE>");
	
	};
	
	/**
	 * Returns the a classname according to the given
	 * horizontal alignment and RTL mode or null if an invalid value.
	 * was given.
	 *
	 * @param {sap.ui.commons.layout.HAlign} oHAlign
	 * @param {boolean} bRTL
	 * @type string
	 */
	MatrixLayoutRenderer.getHAlignClass = function(oHAlign, bRTL) {
		var sClassPrefix = "sapUiMltCellHAlign";

		switch (oHAlign) {
		case sap.ui.commons.layout.HAlign.Begin:
			return null; // CSS default in both directions

		case sap.ui.commons.layout.HAlign.Center:
			return sClassPrefix + "Center";

		case sap.ui.commons.layout.HAlign.End:
			return sClassPrefix + (bRTL ? "Left" : "Right");

		case sap.ui.commons.layout.HAlign.Left:
			return bRTL ? sClassPrefix + "Left" : null; // CSS default in ltr

		case sap.ui.commons.layout.HAlign.Right:
			return bRTL ? null : sClassPrefix + "Right"; // CSS default in rtl

		default:
			jQuery.sap.assert(false, "MatrixLayoutRenderer.getHAlign: oHAlign must be a known value");
			return null;
		}

	};
	
	/**
	 * Returns the value for the HTML "valign" attribute according to the given
	 * vertical alignment, or NULL if the HTML default is fine.
	 *
	 * @param {sap.ui.commons.layout.VAlign} oVAlign
	 * @type string
	 */
	MatrixLayoutRenderer.getVAlign = function(oVAlign) {
	  switch (oVAlign) {
		case sap.ui.commons.layout.VAlign.Bottom:
		  return "bottom";
	
		case sap.ui.commons.layout.VAlign.Middle:
			return "middle";
		case sap.ui.commons.layout.VAlign.Top:
		  return "top";
	  }
	
	  jQuery.sap.assert(false, "MatrixLayoutRenderer.getVAlign: oVAlign must be a known value");
	  return null;
	};
	
	/**
	 * Returns the class name according to the given background design or NULL of
	 * none is needed.
	 *
	 * @param {sap.ui.commons.layout.BackgroundDesign} oBackgroundDesign
	 * @type string
	 */
	MatrixLayoutRenderer.getBackgroundClass = function(oBackgroundDesign) {
	  switch (oBackgroundDesign) {
		case sap.ui.commons.layout.BackgroundDesign.Border:
		  return "sapUiMltBgBorder";
	
		case sap.ui.commons.layout.BackgroundDesign.Fill1:
		  return "sapUiMltBgFill1";
	
		case sap.ui.commons.layout.BackgroundDesign.Fill2:
		  return "sapUiMltBgFill2";
	
		case sap.ui.commons.layout.BackgroundDesign.Fill3:
		  return "sapUiMltBgFill3";
	
		case sap.ui.commons.layout.BackgroundDesign.Header:
		  return "sapUiMltBgHeader";
	
		case sap.ui.commons.layout.BackgroundDesign.Plain:
		  return "sapUiMltBgPlain";
	
		case sap.ui.commons.layout.BackgroundDesign.Transparent:
		  return null;
	  }
	
	  jQuery.sap.assert(false, "MatrixLayoutRenderer.getBackgroundClass: oBackgroundDesign must be a known value");
	  return null;
	};
	
	/**
	 * Returns the class name according to the given padding or NULL of
	 * none is needed.
	 *
	 * @param {sap.ui.commons.layout.Padding} oPadding
	 * @type string
	 */
	MatrixLayoutRenderer.getPaddingClass = function(oPadding) {
	  switch (oPadding) {
		case sap.ui.commons.layout.Padding.None:
		  return "sapUiMltPadNone";
	
		case sap.ui.commons.layout.Padding.Begin:
		  return "sapUiMltPadLeft"; //TODO OK with RTL?
	
		case sap.ui.commons.layout.Padding.End:
		  return "sapUiMltPadRight"; //TODO OK with RTL?
	
		case sap.ui.commons.layout.Padding.Both:
		  return "sapUiMltPadBoth";
	
		case sap.ui.commons.layout.Padding.Neither:
		  return "sapUiMltPadNeither";
	  }
	
	  jQuery.sap.assert(false, "MatrixLayoutRenderer.getPaddingClass: oPadding must be a known value");
	  return null;
	};
	
	/**
	 * Returns the class name according to the given separation or NULL of
	 * none is needed.
	 *
	 * @param {sap.ui.commons.layout.Separation} oSeparation
	 * @type string
	 */
	MatrixLayoutRenderer.getSeparationClass = function(oSeparation) {
	  switch (oSeparation) {
		case sap.ui.commons.layout.Separation.None:
		  return null;
	
		case sap.ui.commons.layout.Separation.Small:
		  return "sapUiMltSepS";
	
		case sap.ui.commons.layout.Separation.SmallWithLine:
		  return "sapUiMltSepSWL";
	
		case sap.ui.commons.layout.Separation.Medium:
		  return "sapUiMltSepM";
	
		case sap.ui.commons.layout.Separation.MediumWithLine:
		  return "sapUiMltSepMWL";
	
		case sap.ui.commons.layout.Separation.Large:
		  return "sapUiMltSepL";
	
		case sap.ui.commons.layout.Separation.LargeWithLine:
		  return "sapUiMltSepLWL";
	  }
	
	  jQuery.sap.assert(false, "MatrixLayoutRenderer.getSeparationClass: oSeparation must be a known value");
	  return null;
	};
	
	/**
	 * get Value and Unit for size
	 */
	MatrixLayoutRenderer.getValueUnit = function(sSize) {
	
		var fValue = 0;
		var sUnit = "";
	
		var iPos = sSize.search('px');
		if (iPos > -1) {
			sUnit = "px";
			fValue = parseInt(sSize.slice(0,iPos), 10);
			return ({ Value: fValue, Unit: sUnit });
		}
	
		iPos = sSize.search('pt');
		if (iPos > -1) {
			sUnit = "pt";
			fValue = parseFloat(sSize.slice(0,iPos));
			return ({ Value: fValue, Unit: sUnit });
		}
	
		iPos = sSize.search('in');
		if (iPos > -1) {
			sUnit = "in";
			fValue = parseFloat(sSize.slice(0,iPos));
			return ({ Value: fValue, Unit: sUnit });
		}
	
		iPos = sSize.search('mm');
		if (iPos > -1) {
			sUnit = "mm";
			fValue = parseFloat(sSize.slice(0,iPos));
			return ({ Value: fValue, Unit: sUnit });
		}
	
		iPos = sSize.search('cm');
		if (iPos > -1) {
			sUnit = "cm";
			fValue = parseFloat(sSize.slice(0,iPos));
			return ({ Value: fValue, Unit: sUnit });
		}
	
		iPos = sSize.search('em');
		if (iPos > -1) {
			sUnit = "em";
			fValue = parseFloat(sSize.slice(0,iPos));
			return ({ Value: fValue, Unit: sUnit });
		}
	
		iPos = sSize.search('ex');
		if (iPos > -1) {
			sUnit = "ex";
			fValue = parseFloat(sSize.slice(0,iPos));
			return ({ Value: fValue, Unit: sUnit });
		}
	
		iPos = sSize.search('%');
		if (iPos > -1) {
			sUnit = "%";
			fValue = parseFloat(sSize.slice(0,iPos));
			return ({ Value: fValue, Unit: sUnit });
		}
	
	};
	

	return MatrixLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/layout/MatrixLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.ResponsiveFlowLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.commons.layout.ResponsiveFlowLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.ResponsiveFlowLayoutRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/layout/ResponsiveFlowLayoutRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/ResponsiveFlowLayoutRenderer'],
	function(jQuery, Renderer, ResponsiveFlowLayoutRenderer1) {
	"use strict";


	var ResponsiveFlowLayoutRenderer = Renderer.extend(ResponsiveFlowLayoutRenderer1);

	return ResponsiveFlowLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/layout/ResponsiveFlowLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.layout.VerticalLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.layout.VerticalLayout
jQuery.sap.declare('sap.ui.commons.layout.VerticalLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.VerticalLayoutRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/layout/VerticalLayoutRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/layout/VerticalLayoutRenderer'],
	function(jQuery, Renderer, VerticalLayoutRenderer1) {
	"use strict";


	var VerticalLayoutRenderer = Renderer.extend(VerticalLayoutRenderer1);
	

	return VerticalLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/layout/VerticalLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.commons.
 */
jQuery.sap.declare('sap.ui.commons.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.DataType'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.library'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/library",['jquery.sap.global', 'sap/ui/base/DataType', 
	'sap/ui/core/library', // library dependency
	'sap/ui/layout/library'], // library dependency
	function(jQuery, DataType) {

	"use strict";

	/**
	 * Common basic controls, mainly intended for desktop scenarios
	 *
	 * @namespace
	 * @name sap.ui.commons
	 * @author SAP SE
	 * @version 1.28.17
	 * @public
	 */
	
	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.commons",
		version: "1.28.17",
		dependencies : ["sap.ui.core","sap.ui.layout"],
		types: [
			"sap.ui.commons.ButtonStyle",
			"sap.ui.commons.HorizontalDividerHeight",
			"sap.ui.commons.HorizontalDividerType",
			"sap.ui.commons.LabelDesign",
			"sap.ui.commons.MenuBarDesign",
			"sap.ui.commons.MessageType",
			"sap.ui.commons.PaginatorEvent",
			"sap.ui.commons.RatingIndicatorVisualMode",
			"sap.ui.commons.RowRepeaterDesign",
			"sap.ui.commons.SplitterSize",
			"sap.ui.commons.TextViewColor",
			"sap.ui.commons.TextViewDesign",
			"sap.ui.commons.TitleLevel",
			"sap.ui.commons.ToolbarDesign",
			"sap.ui.commons.ToolbarSeparatorDesign",
			"sap.ui.commons.TreeSelectionMode",
			"sap.ui.commons.TriStateCheckBoxState",
			"sap.ui.commons.enums.AreaDesign",
			"sap.ui.commons.enums.BorderDesign",
			"sap.ui.commons.enums.Orientation",
			"sap.ui.commons.form.GridElementCells",
			"sap.ui.commons.form.SimpleFormLayout",
			"sap.ui.commons.layout.BackgroundDesign",
			"sap.ui.commons.layout.BorderLayoutAreaTypes",
			"sap.ui.commons.layout.HAlign",
			"sap.ui.commons.layout.Padding",
			"sap.ui.commons.layout.Separation",
			"sap.ui.commons.layout.VAlign"
		],
		interfaces: [
			"sap.ui.commons.FormattedTextViewControl",
			"sap.ui.commons.ToolbarItem"
		],
		controls: [
			"sap.ui.commons.Accordion",
			"sap.ui.commons.ApplicationHeader",
			"sap.ui.commons.AutoComplete",
			"sap.ui.commons.Button",
			"sap.ui.commons.Callout",
			"sap.ui.commons.CalloutBase",
			"sap.ui.commons.Carousel",
			"sap.ui.commons.CheckBox",
			"sap.ui.commons.ColorPicker",
			"sap.ui.commons.ComboBox",
			"sap.ui.commons.DatePicker",
			"sap.ui.commons.Dialog",
			"sap.ui.commons.DropdownBox",
			"sap.ui.commons.FileUploader",
			"sap.ui.commons.FormattedTextView",
			"sap.ui.commons.HorizontalDivider",
			"sap.ui.commons.Image",
			"sap.ui.commons.ImageMap",
			"sap.ui.commons.InPlaceEdit",
			"sap.ui.commons.Label",
			"sap.ui.commons.Link",
			"sap.ui.commons.ListBox",
			"sap.ui.commons.Menu",
			"sap.ui.commons.MenuBar",
			"sap.ui.commons.MenuButton",
			"sap.ui.commons.Message",
			"sap.ui.commons.MessageBar",
			"sap.ui.commons.MessageList",
			"sap.ui.commons.MessageToast",
			"sap.ui.commons.Paginator",
			"sap.ui.commons.Panel",
			"sap.ui.commons.PasswordField",
			"sap.ui.commons.ProgressIndicator",
			"sap.ui.commons.RadioButton",
			"sap.ui.commons.RadioButtonGroup",
			"sap.ui.commons.RangeSlider",
			"sap.ui.commons.RatingIndicator",
			"sap.ui.commons.ResponsiveContainer",
			"sap.ui.commons.ResponsiveContainerRange",
			"sap.ui.commons.RichTooltip",
			"sap.ui.commons.RoadMap",
			"sap.ui.commons.RowRepeater",
			"sap.ui.commons.SearchField",
			"sap.ui.commons.SegmentedButton",
			"sap.ui.commons.Slider",
			"sap.ui.commons.Splitter",
			"sap.ui.commons.Tab",
			"sap.ui.commons.TabStrip",
			"sap.ui.commons.TextArea",
			"sap.ui.commons.TextField",
			"sap.ui.commons.TextView",
			"sap.ui.commons.ToggleButton",
			"sap.ui.commons.Toolbar",
			"sap.ui.commons.Tree",
			"sap.ui.commons.TriStateCheckBox",
			"sap.ui.commons.ValueHelpField",
			"sap.ui.commons.form.Form",
			"sap.ui.commons.form.FormLayout",
			"sap.ui.commons.form.GridLayout",
			"sap.ui.commons.form.ResponsiveLayout",
			"sap.ui.commons.form.SimpleForm",
			"sap.ui.commons.layout.AbsoluteLayout",
			"sap.ui.commons.layout.BorderLayout",
			"sap.ui.commons.layout.HorizontalLayout",
			"sap.ui.commons.layout.MatrixLayout",
			"sap.ui.commons.layout.ResponsiveFlowLayout",
			"sap.ui.commons.layout.VerticalLayout"
		],
		elements: [
			"sap.ui.commons.AccordionSection",
			"sap.ui.commons.Area",
			"sap.ui.commons.FileUploaderParameter",
			"sap.ui.commons.MenuItem",
			"sap.ui.commons.MenuItemBase",
			"sap.ui.commons.MenuTextFieldItem",
			"sap.ui.commons.RoadMapStep",
			"sap.ui.commons.RowRepeaterFilter",
			"sap.ui.commons.RowRepeaterSorter",
			"sap.ui.commons.SearchProvider",
			"sap.ui.commons.Title",
			"sap.ui.commons.ToolbarSeparator",
			"sap.ui.commons.TreeNode",
			"sap.ui.commons.form.FormContainer",
			"sap.ui.commons.form.FormElement",
			"sap.ui.commons.form.GridContainerData",
			"sap.ui.commons.form.GridElementData",
			"sap.ui.commons.layout.BorderLayoutArea",
			"sap.ui.commons.layout.MatrixLayoutCell",
			"sap.ui.commons.layout.MatrixLayoutRow",
			"sap.ui.commons.layout.PositionContainer",
			"sap.ui.commons.layout.ResponsiveFlowLayoutData"
		]
	});
	
	
	/**
	 * different styles for a button.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.ButtonStyle = {
	
		/**
		 * Button is emphasized.
		 * @public
		 */
		Emph : "Emph",
	
		/**
		 * Accept button (normally green).
		 * @public
		 */
		Accept : "Accept",
	
		/**
		 * Reject button (normally red).
		 * @public
		 */
		Reject : "Reject",
	
		/**
		 * default style (no special styling).
		 * @public
		 */
		Default : "Default"
	
	};


	/**
	 * Marker interface for common controls which are suitable for use within a FormattedTextView.
	 *
	 * @name sap.ui.commons.FormattedTextViewControl
	 * @interface
	 * @public
	 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
	 */
	
	
	/**
	 * Enumeration of possible HorizontalDivider height settings.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.HorizontalDividerHeight = {
	
		/**
		 * Divider gets no top and bottom margin.
		 * @public
		 */
		Ruleheight : "Ruleheight",
	
		/**
		 * Divider gets a small top and bottom margin.
		 * @public
		 */
		Small : "Small",
	
		/**
		 * Divider gets a medium top and bottom margin.
		 * @public
		 */
		Medium : "Medium",
	
		/**
		 * Divider gets a large top and bottom margin.
		 * @public
		 */
		Large : "Large"
	
	};
	
	
	/**
	 * Enumeration of possible HorizontalDivider types.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.HorizontalDividerType = {
	
		/**
		 * Type Area
		 * @public
		 */
		Area : "Area",
	
		/**
		 * Type Page
		 * @public
		 */
		Page : "Page"
	
	};
	
	
	/**
	 * Available label display modes.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.LabelDesign = {
	
		/**
		 * Displays the label in bold.
		 * @public
		 */
		Bold : "Bold",
	
		/**
		 * Displays the label in normal mode.
		 * @public
		 */
		Standard : "Standard"
	
	};
	
	
	/**
	 * Determines the visual design of a MenuBar. The feature might be not supported by all themes.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.MenuBarDesign = {
	
		/**
		 * The MenuBar appears in standard design.
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * The MenuBar appears in header design.
		 * @public
		 */
		Header : "Header"
	
	};
	
	
	/**
	 * [Enter description for MessageType]
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.MessageType = {
	
		/**
		 * Error message
		 * @public
		 */
		Error : "Error",
	
		/**
		 * Warning message
		 * @public
		 */
		Warning : "Warning",
	
		/**
		 * Successful message
		 * @public
		 */
		Success : "Success"
	
	};
	
	
	/**
	 * Distinct paginator event types
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.PaginatorEvent = {
	
		/**
		 * First page event
		 * @public
		 */
		First : "First",
	
		/**
		 * Previous page event
		 * @public
		 */
		Previous : "Previous",
	
		/**
		 * Go to page event
		 * @public
		 */
		Goto : "Goto",
	
		/**
		 * Next page event
		 * @public
		 */
		Next : "Next",
	
		/**
		 * Last page event
		 * @public
		 */
		Last : "Last"
	
	};
	
	
	/**
	 * Possible values for the visualization of float values in the RatingIndicator Control.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.RatingIndicatorVisualMode = {
	
		/**
		 * Values are rounded to the nearest integer value (e.g. 1.7 -> 2).
		 * @public
		 */
		Full : "Full",
	
		/**
		 * Values are rounded to the nearest half value (e.g. 1.7 -> 1.5).
		 * @public
		 */
		Half : "Half",
	
		/**
		 * Values are not rounded.
		 * @public
		 */
		Continuous : "Continuous"
	
	};
	
	
	/**
	 * Determines the visual design of a RowRepeater.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.RowRepeaterDesign = {
	
		/**
		 * The RowRepeater header and footer elements, as well as the row container background, appear solid.
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * The RowRepeater header and footer elements, as well as the row container background, appear transparent.
		 * @public
		 */
		Transparent : "Transparent",
	
		/**
		 * The RowRepeater will be displayed without header, toolbar or footer. Background will be transparent.
		 * @public
		 */
		BareShell : "BareShell"
	
	};
	
	
	/**
	 * @classdesc A string type that represents subset of CSS size values. For the Splitter only px and % are allowed.
	 *
	 * @final
	 * @namespace
	 * @public
	 * @ui5-metamodel This simple type also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.SplitterSize = DataType.createType('sap.ui.commons.SplitterSize', {
	    isValid : function(vValue) {
	      return /^((0*|([0-9]+|[0-9]*\.[0-9]+)([pP][xX]|%)))$/.test(vValue);
	    }
	
	  },
	  DataType.getType('string')
	);
	
	
	/**
	 * Semantic Colors of a text.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.TextViewColor = {
	
		/**
		 * Default color
		 * @public
		 */
		Default : "Default",
	
		/**
		 * Positive color
		 * @public
		 */
		Positive : "Positive",
	
		/**
		 * Negative color
		 * @public
		 */
		Negative : "Negative",
	
		/**
		 * Critical color
		 * @public
		 */
		Critical : "Critical"
	
	};
	
	
	/**
	 * Designs for TextView.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.TextViewDesign = {
	
		/**
		 * Displays the text in standard letters.
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * Displays the text in bold letters
		 * @public
		 */
		Bold : "Bold",
	
		/**
		 * Displays the text in header 1 letters.
		 * @public
		 */
		H1 : "H1",
	
		/**
		 * Displays the text in header 2 letters.
		 * @public
		 */
		H2 : "H2",
	
		/**
		 * Displays the text in header 3 letters.
		 * @public
		 */
		H3 : "H3",
	
		/**
		 * Displays the text in header 4 letters.
		 * @public
		 */
		H4 : "H4",
	
		/**
		 * Displays the text in header 5 letters.
		 * @public
		 */
		H5 : "H5",
	
		/**
		 * Displays the text in header 6 letters.
		 * @public
		 */
		H6 : "H6",
	
		/**
		 * Displays the text in italic letters
		 * @public
		 */
		Italic : "Italic",
	
		/**
		 * Displays the text in smaller letters.
		 * @public
		 */
		Small : "Small",
	
		/**
		 * Displays the text in monospace letters.
		 * @public
		 */
		Monospace : "Monospace",
	
		/**
		 * underlined Text
		 * @public
		 */
		Underline : "Underline"
	
	};
	
	
	/**
	 * Level of a title.
	 * @since 1.9.1
	 * @deprecated Since version 1.16.0. Moved to sap.ui.core library. Please use this one.
	 */
	sap.ui.commons.TitleLevel = sap.ui.core.TitleLevel;


	/**
	 * Determines the visual design of a Toolbar.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.ToolbarDesign = {
	
		/**
		 * The toolbar elements such as buttons for example have their normal visual design, and the toolbar appears solid.
		 * The feature might be not supported by all themes.
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * The controls included in the toolbar have a normal visual design where the toolbar appears transparent.
		 * The feature might be not supported by all themes.
		 * 
		 * @public
		 */
		Transparent : "Transparent",
	
		/**
		 * The included controls have a very light appearance. The feature might be not supported by all themes.
		 * @public
		 */
		Flat : "Flat"
	
	};
	
	/**
	 * Marker interface for common controls which are suitable for use within a toolbar.
	 * The most prominent example of a toolbar item is a button which is mostly used with
	 * an icon instead of a text caption.
	 * 
	 * Toolbar items must have a fixed height compatible with the toolbar being
	 * a single horizontal row. They can refer to the toolbar's marker class
	 * "sapUiTb" to adjust their own theming when used inside a toolbar.
	 *
	 * @name sap.ui.commons.ToolbarItem
	 * @interface
	 * @public
	 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
	 */
	
	
	/**
	 * Design of the Toolbar Separator.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.ToolbarSeparatorDesign = {
	
		/**
		 * Standard Separator between controls
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * 100% height Separator before and after specific controls
		 * @public
		 */
		FullHeight : "FullHeight"
	
	};
	
	
	/**
	 * Selection mode of the tree
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.TreeSelectionMode = {
	
		/**
		 * Select multiple rows at a time.
		 * @public
		 */
		Multi : "Multi",
	
		/**
		 * Select one row at a time.
		 * @public
		 */
		Single : "Single",
	
		/**
		 * No rows can be selected.
		 * @public
		 */
		None : "None",
		
		/**
		 * Behavior of the former Tree. It is possible to select a plurality of nodes via the API.
		 * @public
		 */
		Legacy : "Legacy"
	
	};
	
	
	/**
	 * States for TriStateCheckBox
	 *
	 * @enum {string}
	 * @public
	 * @since 1.7.2
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.TriStateCheckBoxState = {
	
		/**
		 * unchecked, default value for tri-state checkbox
		 * @public
		 */
		Unchecked : "Unchecked",
	
		/**
		 * mixed state for tri-state checkbox
		 * @public
		 */
		Mixed : "Mixed",
	
		/**
		 * checked value for tri-state checkbox
		 * @public
		 */
		Checked : "Checked"
	
	};
	
	
	sap.ui.commons.enums = sap.ui.commons.enums || {};
	
	/**
	 * Value set for the background design of areas
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.enums.AreaDesign = {
	
		/**
		 * Shows the area in a plain look
		 * @public
		 */
		Plain : "Plain",
	
		/**
		 * Shows the label in a filled look
		 * @public
		 */
		Fill : "Fill",
	
		/**
		 * Shows the background as transparent
		 * @public
		 */
		Transparent : "Transparent"
	
	};
	
	
	/**
	 * Value set for the border design of areas
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.enums.BorderDesign = {
	
		/**
		 * Draws the border as a box around the area
		 * @public
		 */
		Box : "Box",
	
		/**
		 * Suppresses the border
		 * @public
		 */
		None : "None"
	
	};
	
	
	/**
	 * Orientation of a UI element
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.enums.Orientation = {
	
		/**
		 * Horizontal orientation
		 * @public
		 */
		horizontal : "horizontal",
	
		/**
		 * Vertical orientation
		 * @public
		 */
		vertical : "vertical"
	
	};
	
	
	sap.ui.commons.form = sap.ui.commons.form || {};

	/**
	 * A string that defines the number of used cells in a GridLayout. This can be a number from 1 to 16, "auto" or "full".
	 * @deprecated Since version 1.16.0. Moved to sap.ui.layout library. Please use this one.
	 */
	sap.ui.commons.form.GridElementCells = sap.ui.layout.form.GridElementCells;
	
	
	/**
	 * Available FormLayouts used for the SimpleForm.
	 * @deprecated Since version 1.16.0. Moved to sap.ui.layout library. Please use this one.
	 */
	sap.ui.commons.form.SimpleFormLayout = sap.ui.layout.form.SimpleFormLayout;

	sap.ui.commons.layout = sap.ui.commons.layout || {};

	/**
	 * Background design (i.e. color), e.g. of a layout cell.
	 * 
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.layout.BackgroundDesign = {
	
		/**
		 * 
		 * A background design suitable for borders.
		 * 
		 * @public
		 */
		Border : "Border",
	
		/**
		 * 
		 * An opaque background design that looks dark filled.
		 * 
		 * @public
		 */
		Fill1 : "Fill1",
	
		/**
		 * 
		 * An opaque background design that looks medium filled.
		 * 
		 * @public
		 */
		Fill2 : "Fill2",
	
		/**
		 * 
		 * An opaque background design that looks light filled.
		 * 
		 * @public
		 */
		Fill3 : "Fill3",
	
		/**
		 * 
		 * A background design suitable for headers.
		 * 
		 * @public
		 */
		Header : "Header",
	
		/**
		 * 
		 * A plain but opaque background design.
		 * 
		 * @public
		 */
		Plain : "Plain",
	
		/**
		 * 
		 * A transparent background.
		 * 
		 * @public
		 */
		Transparent : "Transparent"
	
	};
	
	
	/**
	 * The type (=position) of a BorderLayoutArea
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.layout.BorderLayoutAreaTypes = {
	
		/**
		 * Value to identify the top area.
		 * @public
		 */
		top : "top",
	
		/**
		 * Value to identify the begin area.
		 * @public
		 */
		begin : "begin",
	
		/**
		 * Value to identify the center area.
		 * @public
		 */
		center : "center",
	
		/**
		 * Value to identify the end area.
		 * @public
		 */
		end : "end",
	
		/**
		 * Value to identify the bottom area.
		 * @public
		 */
		bottom : "bottom"
	
	};
	
	
	/**
	 * Horizontal alignment, e.g. of a layout cell's content within the cell's borders.
	 * Note that some values depend on the current locale's writing direction while
	 * others do not.
	 * 
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.layout.HAlign = {
	
		/**
		 * 
		 * Aligned towards the beginning of a line, in the current locale's writing direction.
		 * 
		 * @public
		 */
		Begin : "Begin",
	
		/**
		 * 
		 * Horizontally centered.
		 * 
		 * @public
		 */
		Center : "Center",
	
		/**
		 * 
		 * Aligned towards the end of a line, in the current locale's writing direction.
		 * 
		 * @public
		 */
		End : "End",
	
		/**
		 * 
		 * Left aligned, regardless of the current locale's writing direction.
		 * 
		 * @public
		 */
		Left : "Left",
	
		/**
		 * 
		 * Right aligned, regardless of the current locale's writing direction.
		 * 
		 * @public
		 */
		Right : "Right"
	
	};
	
	
	/**
	 * Padding, e.g. of a layout cell's content within the cell's borders.
	 * Note that all options except "None" include a padding of 2px at the top and
	 * bottom, and differ only in the presence of a 4px padding towards the beginning
	 * or end of a line, in the current locale's writing direction.
	 * 
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.layout.Padding = {
	
		/**
		 * 
		 * No padding at all.
		 * 
		 * @public
		 */
		None : "None",
	
		/**
		 * 
		 * Top and bottom padding of 2px.
		 * Padding of 4px towards the beginning of a line, in the current locale's
		 * writing direction, but none towards its end.
		 * 
		 * @public
		 */
		Begin : "Begin",
	
		/**
		 * 
		 * Top and bottom padding of 2px.
		 * Padding of 4px towards the end of a line, in the current locale's
		 * writing direction, but none towards its beginning.
		 * 
		 * @public
		 */
		End : "End",
	
		/**
		 * 
		 * Top and bottom padding of 2px.
		 * Padding of 4px towards both the beginning and end of a line.
		 * 
		 * @public
		 */
		Both : "Both",
	
		/**
		 * 
		 * Top and bottom padding of 2px.
		 * No padding towards neither the beginning nor end of a line.
		 * 
		 * @public
		 */
		Neither : "Neither"
	
	};
	
	
	/**
	 * Separation, e.g. of a layout cell from its neighbor, via a vertical gutter of
	 * defined width, with or without a vertical line in its middle.
	 * 
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.layout.Separation = {
	
		/**
		 * 
		 * No gutter at all (0px), and without a vertical line, of course.
		 * 
		 * @public
		 */
		None : "None",
	
		/**
		 * 
		 * A small (17px) vertical gutter without a vertical line.
		 * 
		 * @public
		 */
		Small : "Small",
	
		/**
		 * 
		 * A small (17px) vertical gutter with a vertical line in its middle.
		 * 
		 * @public
		 */
		SmallWithLine : "SmallWithLine",
	
		/**
		 * 
		 * A medium (31px) vertical gutter without a vertical line.
		 * 
		 * @public
		 */
		Medium : "Medium",
	
		/**
		 * 
		 * A medium (31px) vertical gutter with a vertical line in its middle.
		 * 
		 * @public
		 */
		MediumWithLine : "MediumWithLine",
	
		/**
		 * 
		 * A large (63px) vertical gutter without a vertical line.
		 * 
		 * @public
		 */
		Large : "Large",
	
		/**
		 * 
		 * A large (63px) vertical gutter with a vertical line in its middle.
		 * 
		 * @public
		 */
		LargeWithLine : "LargeWithLine"
	
	};
	
	
	/**
	 * Vertical alignment, e.g. of a layout cell's content within the cell's borders.
	 * 
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.commons.layout.VAlign = {
	
		/**
		 * 
		 * Aligned at the bottom.
		 * 
		 * @public
		 */
		Bottom : "Bottom",
	
		/**
		 * 
		 * Vertically centered.
		 * 
		 * @public
		 */
		Middle : "Middle",
	
		/**
		 * 
		 * Aligned at the top.
		 * 
		 * @public
		 */
		Top : "Top"
	
	};
	
	// lazy imports for MessageBox
	sap.ui.lazyRequire("sap.ui.commons.MessageBox", "alert confirm show");
	
	// lazy imports for MenuItemBase which no longer is a control on its own 
	sap.ui.lazyRequire("sap.ui.commons.MenuItemBase", "new extend getMetadata");
	
	sap.ui.commons.Orientation = {
		// Map the Orientation enum to new enums in core
		"Vertical"   : sap.ui.core.Orientation.Vertical,
		"Horizontal" : sap.ui.core.Orientation.Horizontal,
		// Map the Orientation enum to new enums with uppercase
		"vertical"   : sap.ui.core.Orientation.Vertical,
		"horizontal" : sap.ui.core.Orientation.Horizontal
	};
	
	// implement Form helper factory with common controls
	if (!sap.ui.layout.form.FormHelper || !sap.ui.layout.form.FormHelper.bFinal) {
		sap.ui.layout.form.FormHelper = {
			createLabel: function(sText){
				return new sap.ui.commons.Label({text: sText});
			},
			createButton: function(sId, fPressFunction, oThis){
				var oButton = new sap.ui.commons.Button(sId,{
					lite: true
					});
				oButton.attachEvent('press', fPressFunction, oThis); // attach event this way to have the right this-reference in handler
				return oButton;
			},
			setButtonContent: function(oButton, sText, sTooltip, sIcon, sIconHovered){
				oButton.setText(sText);
				oButton.setTooltip(sTooltip);
				oButton.setIcon(sIcon);
				oButton.setIconHovered(sIconHovered);
			},
			addFormClass: function(){ return null; },
			bArrowKeySupport: true, /* enables the keyboard support for arrow keys */
			bFinal: false /* to allow mobile to overwrite  */
		};
	}

	//implement FileUploader helper factory with commons controls
	jQuery.sap.setObject("sap.ui.unified.FileUploaderHelper", {
		createTextField: function(sId){
			var oTextField = new sap.ui.commons.TextField(sId);
			return oTextField;
		},
		setTextFieldContent: function(oTextField, sWidth){
			oTextField.setWidth(sWidth);
		},
		createButton: function(){
			var oButton = new sap.ui.commons.Button();
			return oButton;
		},
		addFormClass: function(){ return null; },
		bFinal: false /* to allow mobile to overwrite  */
	});

	//implement table helper factory with m controls
	//possible is set before layout lib is loaded.
	jQuery.sap.setObject("sap.ui.table.TableHelper", {
		createLabel: function(mConfig){
			return new sap.ui.commons.Label(mConfig);
		},
		createTextView: function(mConfig){
			if (mConfig && !mConfig.wrapping) {
				mConfig.wrapping = false;
			}
			return new sap.ui.commons.TextView(mConfig);
		},
		createTextField: function(mConfig){
			return new sap.ui.commons.TextField(mConfig);
		},
		createImage: function(mConfig){
			return new sap.ui.commons.Image(mConfig);
		},
		addTableClass: function() { return "sapUiTableCommons"; },
		bFinal: false /* to allow mobile to overwrite  */
	});

	return sap.ui.commons;

});

}; // end of sap/ui/commons/library.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Accordion') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Accordion.
jQuery.sap.declare('sap.ui.commons.Accordion'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-core'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-widget'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-mouse'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-sortable'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Accordion",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation', 'sap/ui/thirdparty/jqueryui/jquery-ui-core', 'sap/ui/thirdparty/jqueryui/jquery-ui-widget', 'sap/ui/thirdparty/jqueryui/jquery-ui-mouse', 'sap/ui/thirdparty/jqueryui/jquery-ui-sortable'],
	function(jQuery, library, Control, ItemNavigation) {
	"use strict";



	/**
	 * Constructor for a new Accordion.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Contains N sections which act as containers for any library controls
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Accordion
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Accordion = Control.extend("sap.ui.commons.Accordion", /** @lends sap.ui.commons.Accordion.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * When the width specified is smaller than a section content, a horizontal scroll bar is provided.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : '200px'},

			/**
			 * Section IDs that shall be opened by default at application start.
			 */
			openedSectionsId : {type : "string", group : "Misc", defaultValue : null}
		},
		defaultAggregation : "sections",
		aggregations : {

			/**
			 * Empty container used to display any library controls.
			 */
			sections : {type : "sap.ui.commons.AccordionSection", multiple : true, singularName : "section"}
		},
		events : {

			/**
			 * Event is triggered when the user opens a section.
			 */
			sectionOpen : {
				parameters : {

					/**
					 * ID of the opened section
					 */
					openSectionId : {type : "string"},

					/**
					 * IDs of the sections that shall be closed. Can be initial in the case of no previously opened section.
					 */
					closeSectionIds : {type : "string[]"}
				}
			},

			/**
			 * Event is triggered when the user closes a section.
			 */
			sectionClose : {
				parameters : {

					/**
					 * ID of the closed section
					 */
					closeSectionId : {type : "string"}
				}
			},

			/**
			 * Triggered when the user changes the position of a section.
			 */
			sectionsReorder : {
				parameters : {

					/**
					 * ID of the moved section.
					 */
					movedSectionId : {type : "string"},

					/**
					 * New index of the moved section.
					 */
					newIndex : {type : "int"}
				}
			}
		}
	}});


	/***************************************************
	* ACCORDION CONTROL - JAVASCRIPT FUNCTIONS
	*
	* An accordion is a control that applications can use
	* to define N sections in which they can display N
	* elements of X types. One section can be opened at
	* once and one section is always opened. If the application
	* does not provide a default section to be opened,
	* the first enabled section is opened by default.
	****************************************************/

	//*"*************************************************
	//* CONSTANTS DECLARATION - CLASS ATTRIBUTES
	//***************************************************
	Accordion.CARD_1   = 1;
	Accordion.CARD_0_1 = 2;
	Accordion.CARD_0_N = 3;
	Accordion.CARD_1_N = 4;
	Accordion.KEY_TIMEOUT = 500;

	Accordion.aAccordionsToReplace = [];
	Accordion.aAccordions = [];

	//***************************************************
	//* INITIALIZATION
	//***************************************************
	/**
	* Initialization of the Accordion control
	* @private
	*/
	Accordion.prototype.init = function(){

	   this.bInitialRendering = true;

	   // By default, only one section is opened
	   this.activationMode = Accordion.CARD_1;

	   // Get messagebundle.properties for sap.ui.commons
	   this.rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

	   // Array used to store all section titles
	   this.aSectionTitles = [];

	   Accordion.aAccordions.push(this);

	};

	/***********************************************************************************
	* KEYBOARD NAVIGATION
	* Note that we rely on 2 mechanisms to support all keyboard shortcuts needed.
	* First, for control activation (open/close sections), we rely on UI5 pseudo-events
	* which are called before the browser event. These events all start with onsap_xyz.
	* For other navigation purposes such as next/previous element, we use itemNavigation.
	* Note that to enter the section's content, one needs to use the TAB key which
	* will take the browser's default behavior.
	***********************************************************************************/

	/**
	 * SPACE key behavior
	 * Opens the section or activates the UI element on SPACE key
	 * @param {jQuery.Event} oEvent Browser event
	 * @private
	 */
	Accordion.prototype.onsapspace = function(oEvent){

		this.onclick(oEvent);

	};

	/**
	 * PAGE DOWN key behavior
	 * Beware that these shortcuts are used by FF3.6 to navigate between opened tabs in the browsers.
	 * So this is declared as a limitation, but behaves as expected in Safari 5
	 * Opens the next section and focuses the header of this opened section
	 * @param {jQuery.Event} oEvent Browser event
	 * @private
	 */
	Accordion.prototype.onsappagedownmodifiers = function(oEvent){

		// Get all the sections
		var target = jQuery(oEvent.target);
		var aParents = target.parentsUntil('.sapUiAcd');

		// Get the next section
		var oDOMSection = aParents[aParents.length - 1];
		var oNextSection = jQuery(oDOMSection).next();

		// Skip all disabled sections
		while (!this.getCorrespondingSection(oNextSection[0]).getEnabled()) {
			oNextSection = oNextSection.next();
		}
		oNextSection = oNextSection[0];


		// Open the next enabled section
		this.openSection(oNextSection.id);

		// Ensure the focus is on the right section
		var aSections = this.getSections();
		aSections[this.__idxOfSec(oNextSection.id)].focus();

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	/**
	 * PAGE UP key behavior
	 * Beware that these shortcuts are used by FF3.6 to navigate between opened TABS in the browsers.
	 * So this is declared as a limitation, but behaves as expected in Safari 5
	 * Opens the previous section and focuses the header of this opened section
	 * @param [jQuery.Event} oEvent Browser event
	 * @private
	 */
	Accordion.prototype.onsappageupmodifiers = function(oEvent){

		// Get all the sections
		var target = jQuery(oEvent.target);
		var aParents = target.parentsUntil('.sapUiAcd');

		// Get the previous section
		var oSection = aParents[aParents.length - 1];
		var oNextSection = jQuery(oSection).prev();

		// Skip all disabled sections
		while (!this.getCorrespondingSection(oNextSection[0]).getEnabled()) {
			oNextSection = oNextSection.prev();
		}
		oNextSection = oNextSection[0];

		// Open the previously enabled section
		this.openSection(oNextSection.id);

		// Ensure the focus is on the right section
		var aSections = this.getSections();
		aSections[this.__idxOfSec(oNextSection.id)].focus();

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	Accordion.prototype.onsapupmodifiers = function(oEvent){

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

		// Get the section to move
		var aParents	= jQuery(oEvent.target).parentsUntil('.sapUiAcd');
		var oDomSection = aParents[aParents.length - 1];

		// Is the section if the first one. if so, no up possible!
		if (this.__idxOfSec(oDomSection.id) == 0) {
			return;
		}

		var oDomTargetSection = jQuery(oDomSection).prev().first()[0];
		var bInsertFirst = false;
		if (this.__idxOfSec(oDomTargetSection.id) == 0) {
			bInsertFirst = true;
		}

		this.dropSection(oDomSection,oDomTargetSection,bInsertFirst);

		// Ensure the focus is on the right section
		var aSections = this.getSections();
		aSections[this.__idxOfSec(oDomSection.id)].focus();

	};

	Accordion.prototype.onsapdownmodifiers = function(oEvent){

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

		//Get the section to move
		var aParents	= jQuery(oEvent.target).parentsUntil('.sapUiAcd');
		var oDomSection = aParents[aParents.length - 1];

		//Is the section if the first one. if so, no up possible!
		if (this.__idxOfSec(oDomSection.id) == this.getSections().length - 1) {
			return;
		}

		var oDomTargetSection = jQuery(oDomSection).next().first()[0];
		this.dropSection(oDomSection,oDomTargetSection,false);

		//Ensure the focus is on the right section
		var aSections = this.getSections();
		aSections[this.__idxOfSec(oDomSection.id)].focus();

	};

	/**
	 * Called when the user presses the UP arrow key
	 * @param oEvent The event triggered by the user
	 * @private
	 */
	Accordion.prototype.onsapprevious = function(oEvent){

		if (oEvent.srcControl.getMetadata().getName() != "sap.ui.commons.AccordionSection" ) {
			return;
		}

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

		//Get the current section
		var oCurrentSection = this.getCurrentSection(oEvent.target);

		//Extra check to see of we are on the first section, if yes, set the focus on this one
		if (oCurrentSection.id == this.getSections()[0].getId()) {
			var oNextFocusableElement = jQuery(oCurrentSection).find("div.sapUiAcdSectionHdr");
			if (oNextFocusableElement) {
				oNextFocusableElement.focus();
			}
		}

		//Simply set the focus on the next section if any
		if (oCurrentSection) {

			//Get the previous section that is enabled, disregard disabled sections
			var oPreviousSection = jQuery(oCurrentSection).prev();
			while (oPreviousSection && jQuery(oPreviousSection).hasClass("sapUiAcdSectionDis")) {
				oPreviousSection = jQuery(oPreviousSection).prev();
			}
			if (oPreviousSection) {
				var oNextFocusableElement = jQuery(oPreviousSection).find("div.sapUiAcdSectionHdr");
				if (oNextFocusableElement) {
					oNextFocusableElement.focus();
				}
			}
		}

	};

	/**
	 * Called when the user presses the down arrow key
	 * @param {jQuery.Event} oEvent The event triggered by the user
	 * @private
	 */
	Accordion.prototype.onsapnext = function(oEvent){

		if (oEvent.srcControl.getMetadata().getName() != "sap.ui.commons.AccordionSection" ) {
			return;
		}

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

		//Get the current section
		var oCurrentSection = this.getCurrentSection(oEvent.target);

		//Simply set the focus on the next section if any
		if (oCurrentSection) {

			//Get the next section that is enabled, disregard disabled sections
			var oNextSection = jQuery(oCurrentSection).next();
			while (oNextSection && jQuery(oNextSection).hasClass("sapUiAcdSectionDis")) {
				oNextSection = jQuery(oNextSection).next();
			}
			if (oNextSection) {
				var oNextFocusableElement = jQuery(oNextSection).find("div.sapUiAcdSectionHdr");
				if (oNextFocusableElement) {
					oNextFocusableElement.focus();
				}
			}
		}

	};

	/**
	 * Called when the user presses the home key
	 * @param oEvent The event triggered by the user
	 * @private
	 */
	Accordion.prototype.onsaphome = function(oEvent){

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

		//Get the current first section id
		var oFocusableSection = this.getSections()[0].getDomRef();

		//If the section is disabled, get the next section that is enabled, disregard disabled sections
		if (jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")) {
			oFocusableSection = jQuery(oFocusableSection).next();
			while (oFocusableSection && jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")) {
				oFocusableSection = jQuery(oFocusableSection).next();
			}
		}

		//We found one focusable section
		if (oFocusableSection) {
			var oNextFocusableElement = jQuery(oFocusableSection).find("div.sapUiAcdSectionHdr");
			if (oNextFocusableElement) {
				oNextFocusableElement.focus();
			}
		}

	};

	/**
	 * Called when the user presses the end key
	 * @param oEvent The event triggered by the user
	 * @private
	 */
	Accordion.prototype.onsapend = function(oEvent){

		// Stop the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

		//Get the last section
		var iNbSections = this.getSections().length;
		var oFocusableSection = this.getSections()[iNbSections - 1].getDomRef();

		//If the section is disabled, get the previous section that is enabled, disregard disabled sections
		if (jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")) {
			oFocusableSection = jQuery(oFocusableSection).prev();
			while (oFocusableSection && jQuery(oFocusableSection).hasClass("sapUiAcdSectionDis")) {
				oFocusableSection = jQuery(oFocusableSection).prev();
			}
		}

		//We found one focusable section
		if (oFocusableSection) {
			var oNextFocusableElement = jQuery(oFocusableSection).find("div.sapUiAcdSectionHdr");
			if (oNextFocusableElement) {
				oNextFocusableElement.focus();
			}
		}

	};

	/**
	 * Utility to get the current section
	 * @param {Element} oDomElement The current DOM element from which an event is triggered
	 * @private
	 */
	Accordion.prototype.getCurrentSection = function(oDomElement){

		//Use jQuery to get the parent section
		var oCurrentSection = oDomElement;
		while (!jQuery(oCurrentSection).hasClass("sapUiAcdSection")) {
			oCurrentSection = jQuery(oCurrentSection).parent();
		}
		return oCurrentSection[0];

	};

	/***********************************************************************************
	 * DRAG AND DROP
	 * Drag and drop is used to move a single section at once up/down in the accordion
	 * This can be achieved via a mouse click (down/up) and also via some keyboard
	 * shortcuts (Ctrl-up and Ctrl-down)
	 ***********************************************************************************/
	/**
	 * Drops a section to a new index
	 * @param {Element} oDomSection	Section to drop to a new index
	 * @param {Element} oDomTargetSection Section after which to drop the section
	 * @param {boolean} bDropFirst If true, drop at first place
	 * @private
	 */
	Accordion.prototype.dropSection = function(oDomSection, oDomTargetSection, bDropFirst){

		//Get accordion DOM object
		var oDomAccordion = jQuery(oDomSection).parent()[0];

		//We substract 1 as the first child is the drop target and the should not be considered
		var aChildren = jQuery(oDomAccordion).children(".sapUiAcdSection").toArray();
		var iIndexToInsert = jQuery.inArray(oDomTargetSection, aChildren);

		if (bDropFirst) {
			iIndexToInsert -= 1;
		}

		//Update accordion with the change
		this.moveSection(oDomSection.id,iIndexToInsert);

	};

	/**
	 * Moves one section to a given new index by adjusting all internal information
	 * @param {string} sSectionId The current section ID being moved
	 * @param {int} iTargetIndex Where the section is dropped
	 * @private
	 */
	Accordion.prototype.moveSection = function(sSectionId, iTargetIndex){

		//Get previous index
		var iOldIndex = this.__idxOfSec(sSectionId);


		if (iTargetIndex == iOldIndex) {
			 //Nothing to do
			 return;
		}


		/****Remove section from arrays*********************************/

		//Remove title for the list
		var sSectionTitle = this.aSectionTitles[iOldIndex];
		this.aSectionTitles.splice(iOldIndex,1);

		//Remove section aggregation
		var aSections = this.getSections();
		var oSection = aSections[iOldIndex];
		this.removeSection(iOldIndex, true);


		/****Add section to new index*********************************/
		if (iTargetIndex != -1) {
			this.aSectionTitles.splice(iTargetIndex,0,sSectionTitle);
		} else {
			this.aSectionTitles.splice(0,0,sSectionTitle);
		}

		//Update aggregation
		this.insertSection(oSection,iTargetIndex, true);

		//Trigger event for application to react
		this.fireSectionsReorder({movedSectionId:sSectionId, newIndex:iTargetIndex});

	};

	Accordion.prototype._onSortChange = function(oEvent, oUi){

		oEvent.preventDefault();
		oEvent.stopPropagation();

		var oDomSection = oUi.item[0];
		var SectionId = oUi.item[0].getAttribute("Id");

		//Get accordion DOM object
		var oDomAccordion = jQuery(oDomSection).parent()[0];

		var aChildren = jQuery(oDomAccordion).children(".sapUiAcdSection").toArray();
		var iIndexToInsert = jQuery.inArray(oDomSection, aChildren);

		this.moveSection(SectionId,iIndexToInsert);
	};

	/***********************************************************************************
	 * FUNCTIONALITIES
	 * Available functionalities in the Accordion are the following:
	 * - Open a section
	 * - Close a section
	 ***********************************************************************************/

	/**
	 * Activation of the section - Opens or closes a section.
	 * If the focus is on a collapsed section, it will close the currently opened section, and open this one.
	 * If the focus is on an expanded section, it will collapse the section and open the default section.
	 * This function is called onClick by the mouse, or via ENTER/SPACE keys
	 * @param {jQuery.Event} oEvent Browser event
	 * @private
	 */
	Accordion.prototype.onclick = function(oEvent){

		//Click on the accordion itself are not considered
		if (oEvent.srcControl.getId() ==  this.getId()) {
			return;
		}

		//Move up in the DOM to get the section (click occurs on the arrow which is an inner html element)
		var target = jQuery(oEvent.target);

		//Disable the possibility to click on the content to open/close a section
		if (target.hasClass("sapUiAcdSectionCont")) {
			return;
		}

		if ( !(jQuery(oEvent.target).control(0) instanceof sap.ui.commons.AccordionSection) ) {
			return;
		}

		var oDomSection = oEvent.srcControl.getDomRef();

		//If the section is disabled, we cannot open/close it.
		var oSection = this.getCorrespondingSection(oDomSection);
		if (oSection && !oSection.getEnabled()) {
			return;
		}

		//If the section is closed, open it
		if (oEvent.srcControl && oEvent.srcControl.getCollapsed() == true) {
			this.openSection(oDomSection.id);
		} else { //If it is opened, close it
			if (oEvent.srcControl) {
				this.closeSection(oDomSection.id);
			}
		}

		//Stop the event here
		oEvent.preventDefault();
		oEvent.stopPropagation();

		//Ensure the focus is on the right section
		var aSections = this.getSections();
		aSections[this.__idxOfSec(oDomSection.id)].focus();

	};

	/**
	 * Opens a section.
	 *
	 * @param {string} sSectionId
	 *         Id of the section that shall be opened
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Accordion.prototype.openSection = function(sSectionId){

		//Map the section ID to its internal index
		var iIndex = this.__idxOfSec(sSectionId);

		//Get all accordion's sections
		var aSections = this.getSections();

		//Close all sections currently opened
		if (this.activationMode == Accordion.CARD_0_1 || this.activationMode == Accordion.CARD_1) {
		  var aClosedSections = this.closeOpenedSections();
		}

		//Open the section with the index retrieved from the importing section ID
		aSections[iIndex]._setCollapsed(false);

		//Trigger event for application to react
		this.fireSectionOpen({openSectionId:sSectionId, closeSectionIds:aClosedSections});

	};

	/**
	 * Closes a section, and opens the default one
	 *
	 * @param {string} sSectionId
	 *         Id of the section that shall be closed
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Accordion.prototype.closeSection = function(sSectionId){

		//Get the corresponding mapping index
		var iIndex = this.__idxOfSec(sSectionId);

		//Get all accordion's sections
		var aSections = this.getSections();

		//Close the given section
		aSections[iIndex]._setCollapsed(true);
		//If there is no section opened and at least one is required to be, we open the default one to respect activationMode
		//if ((this.activationMode == sap.ui.commons.Accordion.CARD_1_N || this.activationMode == sap.ui.commons.Accordion.CARD_1) && this.getNumberOfOpenedSections() == 0){
		//this.openDefaultSections();
		//}

		//Trigger event for application to react
		this.fireSectionClose({closeSectionId:sSectionId});

	};

	/**
	 * Closes all opened sections
	 * @private
	 */
	Accordion.prototype.closeOpenedSections = function(){

		var aClosedSections = [];
		var aSections = this.getSections();

		//Simply loop and close the sections already opened
		for (var i = 0;i < aSections.length;i++) {
			if ( aSections[i].getCollapsed() == false ) {
				aSections[i]._setCollapsed(true);
				aClosedSections.push(aSections[i].getId());
			}
		}

		//Return all sections that were closed
		return aClosedSections;

	};

	/**
	 * Opens the default section; consider activationMode
	 * @private
	 */
	Accordion.prototype.openDefaultSections = function(){

		//Get all accordion's sections
		var aSections = this.getSections();

		//Loop trough all defaulted opened section and open them
		var aDefaultSections = this.getOpenedSectionsId().split(",");
		for (var i = 0 ; i < aDefaultSections.length ; i++) {
		  //From the default section ID to open, we retrieve the index
		  var oActiveSection = aSections[this.__idxOfSec(aDefaultSections[i])];
		  oActiveSection._setCollapsed(false);
		}

	};

	/**
	 * Returns the number of currently opened sections
	 * @return The number of currently opened sections
	 * @private
	 */
	Accordion.prototype.getNumberOfOpenedSections = function(){

		//Initialize the return parameter
		var openedSections  = 0;

		//Get all accordion's sections
		var aSections		= this.getSections();

		//Loop and sum up all opened sections
		for (var i = 0;i < aSections.length;i++) {
			if ( aSections[i].getCollapsed() == false ) {
				openedSections++;
			}
		}
		return openedSections;
	};


	//*************************************************************************************
	// * UTILITIES FUNCTIONS
	// * List of all Javascript utilities functions needed to achieve the required behavior
	// ************************************************************************************

	Accordion.prototype.addSection = function(oSection) {

		this.addAggregation("sections", oSection);

		//Add a default opened section id
		if ( (this.getOpenedSectionsId() == null || this.getOpenedSectionsId() == "" ) && oSection.getEnabled()) {
			this.setOpenedSectionsId(oSection.getId());
		}

		this.aSectionTitles.push(oSection.getTitle());

	};

	/**
	 * Returns the index of the given section or Id of a section.
	 * @private
	 */
	Accordion.prototype.__idxOfSec = function(oSection){
		if (typeof (oSection) == "string") {
			oSection = sap.ui.getCore().byId(oSection);
		}
		return this.indexOfSection(oSection);
	};

	/**
	 * Redefinition of the method to add additional handling
	 *
	 * @param {string} sOpenedSectionsId  New value for property openedSectionsId
	 * @return {sap.ui.commons.Accordion} 'this' to allow method chaining
	 * @public
	 */
	Accordion.prototype.setOpenedSectionsId = function(sOpenedSectionsId) {

		var aSections = this.getSections();

		var aDefaultSections = sOpenedSectionsId.split(",");


		if (aDefaultSections.length == 1) {
			//it can be that the method is called from method AddSection. We don't want to intefere with those
			// call.
			if (this.__idxOfSec(sOpenedSectionsId) < 0) {
				this.setProperty("openedSectionsId", sOpenedSectionsId);
				return this;
			}

			if (aSections[this.__idxOfSec(sOpenedSectionsId)].getEnabled()) {
				//If the provided section is enabled
				this.setProperty("openedSectionsId", sOpenedSectionsId);
			} else {

				//If the provided section is disabled, the open section will be the first enable section starting for the top
				for (var i = 0;i < aSections.length;i++) {
					if (aSections[i].getEnabled()) {
						this.setProperty("openedSectionsId", aSections[i].getId());
						return this;
					}
				}
			}


		} else if (aDefaultSections.length == 0) {
			//If the empty string is provided, we keep the automatically selected section(as selected in method AddSection).
			return this;

		} else { //Several sections were provided, but some can be disabled. Check each of them
			var sCheckIndices;

			for (var i = 0;i < aDefaultSections.length;i++) {
				if (aSections[this.__idxOfSec(aDefaultSections[i])].getEnabled()) {

					if (sCheckIndices) {
						sCheckIndices += "," + aDefaultSections[i];

						//only one section should be opened at once, so return after the first is set
						return;
					} else {
						sCheckIndices = aDefaultSections[i];
					}

				}
			}

			if (sCheckIndices) {
				//If at least one section remains
				this.setProperty("openedSectionsId", sCheckIndices);
			}


		}

		return this;

	};


	/**
	 * Returns AccordionSection Object corresponding to a given Section DOM Object
	 * @param oDomSection The section in a DOM representation object
	 * @return The current section control
	 * @private
	 */
	Accordion.prototype.getCorrespondingSection = function (oDomSection) {

		//Look for section index within accordion
		if (jQuery(oDomSection).hasClass("sapUiAcdSection") ) {
			var aAccordion	= jQuery(oDomSection).parent();
			var oAccordion  = aAccordion[0];
			var aSections	= jQuery(oAccordion).children();
			var iIndex		= aSections.index( oDomSection );
			var aoSections	= this.getSections();
			//Remove 1 as we have the target div as first child
			return aoSections[iIndex - 1];
		}

	};

	/**
	 * Returns true if the current section being processed is the last one of the Accordion
	 * @param oSection The current section being processed
	 * @return true If the current section being processed is the last one of the Accordion
	 * @private
	 */
	Accordion.prototype.isLastSection = function(oSection) {

		//Get all accordion's sections
		var aSections = this.getSections();

		//Simply check in our internal array containing all titles
		/*if(aSections.indexOf(oSection) == aSections.length-1 ){*/
		if (jQuery.inArray(oSection,aSections) == aSections.length - 1 ) {
			return true;
		} else {
			return false;
		}

	};

	/**
	 * Once the Accordion is rendered, build the list of active controls that will be included
	 * in the item navigation object. This support arrow keys navigation.
	 * @private
	 */
	Accordion.prototype.onAfterRendering = function() {

		// Collect the dom references of the items
		var accordion = this.getDomRef();
		var leftBorder = "0px";
		var rightBorder = "0px";
		//neccessary to make sure IE8 does not deliver medium if no border width is set
		if (jQuery(accordion).css("borderLeftStyle") !== "none") {
			leftBorder = jQuery(accordion).css("border-left-width");
		}
		if (jQuery(accordion).css("borderRightStyle") !== "none") {
			rightBorder = jQuery(accordion).css("border-right-width");
		}
		var borderTotal = parseFloat(leftBorder.substring(0, leftBorder.indexOf("px"))) + parseFloat(rightBorder.substring(0, rightBorder.indexOf("px")));
		accordion.style.height = accordion.offsetHeight - borderTotal - 7 + "px";

		this.$().sortable({
			handle: "> div.sapUiAcdSectionHdr > div",
			stop: jQuery.proxy(this._onSortChange, this)
		});
	};


	return Accordion;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Accordion.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.AccordionSection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.AccordionSection.
jQuery.sap.declare('sap.ui.commons.AccordionSection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/AccordionSection",['jquery.sap.global', './library', 'sap/ui/core/Element'],
	function(jQuery, library, Element) {
	"use strict";


	
	/**
	 * Constructor for a new AccordionSection.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Represents a panel which is a container for other controls. The container does not have any layout function.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.AccordionSection
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AccordionSection = Element.extend("sap.ui.commons.AccordionSection", /** @lends sap.ui.commons.AccordionSection.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * When the section content exceeds maxHeight, a vertical scroll bar appears.
			 */
			maxHeight : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * Requirement is that the used theme supports the control.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * It is recommended to make some settings for the width when the section is set to 'collapsed'.
			 */
			collapsed : {type : "boolean", group : "Behavior", defaultValue : false},
	
			/**
			 * Text for the section header
			 */
			title : {type : "string", group : "Misc", defaultValue : null}
		},
		defaultAggregation : "content",
		aggregations : {
	
			/**
			 * Aggregates the controls that are contained in the panel. Control layouting is browser-dependent. For a stable content layout, use a layout control as direct single child.
			 * When the panel dimensions are set, the child control may have width and height of 100%;
			 * when the panel dimensions are not set, the child defines the panel size.
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
		},
		events : {
	
			/**
			 * Event is fired when the user scrolls the panel.
			 */
			scroll : {
				parameters : {
	
					/**
					 * Horizontal scroll position.
					 */
					left : {type : "int"}, 
	
					/**
					 * Vertical scroll position.
					 */
					top : {type : "int"}
				}
			}
		}
	}});
	
	/**
	 * AccordionSection Behavior Implementation
	 *
	 * Open:
	 * - HeaderDesign not implemented yet
	 */
	
	/**
	 * Do some initialization
	 * @private
	 */
	AccordionSection.prototype.init = function(){
	   this.bIgnoreScrollEvent = true; // do not fire a scroll event initially
	   this.oScrollDomRef = null;      // points to the content area
	   
	   this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};
	
	/**
	 * Set focus on the first control
	 * @private
	 */
	AccordionSection.prototype.focusFirstControl = function () {
		var aControls = this.getContent();
		if (aControls[0]) {
			aControls[0].focus();
		}
	};
	
	/**
	 * Set focus the arrow
	 * @private
	 */
	AccordionSection.prototype.focus = function () {
	
		var header = this.getDomRef("hdr");
		header.focus();
	};
	
	/**
	 * Called after the theme has been switched, required for adjustments
	 * @private
	 */
	AccordionSection.prototype.onThemeChanged = function () {
		var hdrLeft = this.getDomRef("hdrL");
	
		if (hdrLeft) {
			hdrLeft.style.width = "auto";
			var that = this;
			setTimeout(function() {that.onAfterRendering();}, 0); // TODO: there is a problem in IE8, depending on what the surrounding container is...
		}
	
	}
	
	/**
	 * Adapts size settings of the rendered HTML
	 * @private
	 */;
	AccordionSection.prototype.onAfterRendering = function () {
	
		this.oScrollDomRef = this.getDomRef("cont");
		var cont	  = this.oScrollDomRef;
		var root	  = this.getDomRef();
		var accordion = this.getParent().getDomRef();
		// if only height is set, the content area's height needs to be adapted  (should be a rare use-case)
		if (!AccordionSection._isSizeSet(this.getParent().getWidth()) && AccordionSection._isSizeSet(this.getMaxHeight())) {
			if (cont) {
				var contTop = cont.offsetTop;
				var targetHeight = (root.offsetHeight - contTop);
				cont.style.height = targetHeight + "px";
	
				var actualContHeight = cont.offsetHeight;
				if (actualContHeight > targetHeight) {
					cont.style.height = targetHeight - (actualContHeight - targetHeight) + "px";
				}
			}
	
		}
	
		var leftBorder	= jQuery(accordion).css("border-left-width");
		var rightBorder = jQuery(accordion).css("border-right-width");
	
	
		var borderTotal = parseFloat(leftBorder.substring(0, leftBorder.indexOf("px") )) + parseFloat(rightBorder.substring(0, rightBorder.indexOf("px") ));
		var oDomLabel = this.getDomRef("lbl");
		root.style.width = accordion.offsetWidth - borderTotal + "px";
		oDomLabel.style.width = accordion.offsetWidth - 30 + "px";
	
		//Bind the scroll event (does not bubble)
		var fnScrollProxy = this.__scrollproxy__;
		if (!fnScrollProxy) {
			fnScrollProxy = this.__scrollproxy__ = jQuery.proxy(this.onscroll, this);
		}
		this.$("cont").bind("scroll", fnScrollProxy);
	
	};
	
	AccordionSection.prototype.onBeforeRendering = function() {
		var fnScrollProxy = this.__scrollproxy__;
		if (fnScrollProxy) {
			this.$("cont").unbind("scroll", fnScrollProxy);
		}
	};
	
	/**
	 * Property setter for the "enabled" state
	 *
	 * @param {boolean} bEnabled Whether the AccordionSection should be enabled, or not
	 * @return {sap.ui.commons.AccordionSection} 'this' to allow method chaining
	 * @public
	 */
	AccordionSection.prototype.setEnabled = function(bEnabled) {
		this.setProperty("enabled", bEnabled, true); // no re-rendering!
		var root = this.getDomRef();
		if (root) {
			// if already rendered, adapt rendered control without complete re-rendering
			if (bEnabled) {
				jQuery(root).removeClass("sapUiAcdSectionDis");
			} else {
				jQuery(root).addClass("sapUiAcdSectionDis");
			}
		}
		return this;
	};
	
	
	/**
	 * Property setter for the "collapsed" state
	 *
	 * @param bCollapsed Whether the AccordionSection should be collapsed, or not
	 * @private
	 */
	AccordionSection.prototype._setCollapsed = function(bCollapsed) {
		this.setProperty("collapsed", bCollapsed, true); // no re-rendering!
		this._setCollapsedState(bCollapsed); // adapt rendered control without complete re-rendering
	};
	
	/**
	 * Property setter for the "collapsed" state
	 *
	 * @param {boolean} bCollapsed Whether the AccordionSection should be collapsed, or not
	 * @return {sap.ui.commons.AccordionSection} 'this' to allow method chaining
	 * @public
	 */
	AccordionSection.prototype.setCollapsed = function(bCollapsed) {
		if (this.getParent()) {
	
			if (!bCollapsed) {
				this.getParent().openSection(this.getId());
			} else {
				this.getParent().closeSection(this.getId());
			}
		} else {
			this._setCollapsed(bCollapsed);
		}
		return this;
	};
	
	
	/**
	 * Internal method for applying a "collapsed" state to the rendered HTML
	 *
	 * @param bCollapsed Whether the AccordionSection should be collapsed, or not
	 * @private
	 */
	AccordionSection.prototype._setCollapsedState = function(bCollapsed) {
	
		if (this.getDomRef()) {
			// after AccordionSection has been rendered
			if (bCollapsed) {
				var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
	
				// collapsing
				if (!this.getParent().getWidth()) {
					this.getDomRef().style.width = this.getDomRef().offsetWidth + "px"; // maintain the current width
				}
				jQuery(this.getDomRef()).addClass("sapUiAcdSectionColl");
				var tb = this.getDomRef("tb");
				if (tb) {
					tb.style.display = "none";
				}
	
				var cont = this.getDomRef("cont");
				cont.style.display = "none";
				if (accessibility) {
					cont.setAttribute("aria-expanded", "false");
					cont.setAttribute("aria-hidden", "true");
				}
	
				this.invalidate();
	
			} else {
				// expanding
				if (!this.getDomRef("cont")) {
					// content has not been rendered yet, so render it now
					this.invalidate(); // TODO: potentially restore focus to collapse icon/button
				} else {
					// content exists already, just make it visible again
					jQuery(this.getDomRef()).removeClass("sapUiAcdSectionColl");
					var tb = this.getDomRef("tb");
					if (tb) {
						tb.style.display = "block";
					}
	
					var cont = this.getDomRef("cont");
					cont.style.display = "block";
					if (accessibility) {
						cont.setAttribute("aria-expanded", "true");
					}
	
					if (this.getMaxHeight()) {
						this.getDomRef().style.height = this.getMaxHeight(); // restore the set height
					}
				}
			}
		}
	}
	
	
	/**
	 * Static method that finds out whether the given CSS size is actually set.
	 * Returns "true" for absolute and relative sizes, returns "false" if "null", "inherit" or "auto" is given.
	 *
	 * @static
	 * @param sCssSize A CSS size string which must be a valid CSS size, or null
	 * @private
	 */;
	AccordionSection._isSizeSet = function(sCssSize) {
		return (sCssSize && !(sCssSize == "auto") && !(sCssSize == "inherit"));
	}
	
	
	/*   Event Handling   */
	
	/**
	 * Handles any "triggering" actions like click and space
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */;
	AccordionSection.prototype._handleTrigger = function(oEvent) {
		// minimize button toggled
		if ((oEvent.target.id === this.getId() + "-minL") ||
				(oEvent.target.id === this.getId() + "-minR")) {
			var bCollapsed = !this.getProperty("collapsed");
			this._setCollapsed(bCollapsed);
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};
	
	/**
	 * Handles the scroll event of the browser
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AccordionSection.prototype.onscroll = function (oEvent) {
		/**
		if (this.bIgnoreScrollEvent) { // bIgnoreScrollEvent is set to "true" if the scrollbar is moved via API calls
			this.bIgnoreScrollEvent = false;
			return;
		}
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			this.fireScroll(oDomRef.scrollTop, oDomRef.scrollLeft);
		}
		 */
	};

	return AccordionSection;

}, /* bExport= */ true);

}; // end of sap/ui/commons/AccordionSection.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ApplicationHeader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ApplicationHeader.
jQuery.sap.declare('sap.ui.commons.ApplicationHeader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ApplicationHeader",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new ApplicationHeader.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The application header control stands on the top of any application page. It consists basically of 4 areas. Logo area/Function area provided by application/Search area/Logout area
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ApplicationHeader
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ApplicationHeader = Control.extend("sap.ui.commons.ApplicationHeader", /** @lends sap.ui.commons.ApplicationHeader.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Path (src) to the logo icon to be displayed in the application header.
			 */
			logoSrc : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * The text that will be displayed beside the logo in the application header. This property is optional.
			 */
			logoText : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * If set to true, the logoff area will be displayed at the right hand side of the application header.
			 */
			displayLogoff : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * User name that will be displayed beside the welcome text
			 */
			userName : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * By default, set to true and dislpays the welcome text
			 */
			displayWelcome : {type : "boolean", group : "Misc", defaultValue : true}
		},
		events : {
	
			/**
			 * Fires an event to log off the user from the application.
			 * No parameters.
			 */
			logoff : {}
		}
	}});
	
	ApplicationHeader.prototype.init = function(){
		this.initializationDone = false;
	};
	
	ApplicationHeader.prototype.exit = function() {
		this.oLogo && this.oLogo.destroy();
		this.oLogoText && this.oLogoText.destroy();
		this.oLogoffBtn && this.oLogoffBtn.destroy();
	};
	
	/**
	 * Create the composite parts out of the current settings.
	 * Called by the renderer just before rendering
	 * @private
	 */
	ApplicationHeader.prototype.initControls = function() {
	
		//Application header to build sub-controls ids
		var appHeaderId = this.getId();
	
		//Get the texts from the resources bundle
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	
		//Create the logo image control and the title (textView) control
		this.oLogo && this.oLogo.destroy();
		this.oLogo = new sap.ui.commons.Image(appHeaderId + "-logoImg");
		this.oLogo.setTooltip(rb.getText("APPHDR_LOGO_TOOLTIP"));
		this.oLogo.setParent(this);
		this.oLogoText && this.oLogoText.destroy();
		this.oLogoText = new sap.ui.commons.TextView(appHeaderId + "-logoText");
		this.oLogoText.setAccessibleRole(sap.ui.core.AccessibleRole.Heading);
		this.oLogoText.setParent(this);
	
		//Log off button
		this.oLogoffBtn && this.oLogoffBtn.destroy();
		this.oLogoffBtn = new sap.ui.commons.Button(appHeaderId + "-logoffBtn");
		var sLogOffText = rb.getText("APPHDR_LOGOFF");
		this.oLogoffBtn.setText(sLogOffText);
		this.oLogoffBtn.setTooltip(sLogOffText);
		this.oLogoffBtn.attachPress(this.logoff,this);
		this.oLogoffBtn.setParent(this);
		this.oLogoffBtn.setLite(true);
	}
	
	
	/**
	*  This event is fired when the user clicks on the Log Off button
	*  @param oEvent The event triggered
	*  @private
	*/;
	ApplicationHeader.prototype.logoff = function(oEvent){
		this.fireLogoff();
	};
	
	
	// ---- Overwritten property setters to make sure the full area is rerendered correctly ----
	
	ApplicationHeader.prototype.setLogoSrc = function(sLogoSrc) {
		this.initializationDone = false;
		this.setProperty("logoSrc", sLogoSrc);
		return this;
	};
	
	ApplicationHeader.prototype.setLogoText = function(sLogoText) {
		this.initializationDone = false;
		this.setProperty("logoText", sLogoText);
		return this;
	};
	
	ApplicationHeader.prototype.setUserName = function(sUserName){
		this.initializationDone = false;
		this.setProperty("userName", sUserName);
		return this;
	};
	
	ApplicationHeader.prototype.setDisplayWelcome = function(bDisplayWelcome) {
		this.initializationDone = false;
		this.setProperty("displayWelcome", bDisplayWelcome);
		return this;
	};
	
	ApplicationHeader.prototype.setDisplayLogoff = function(bDisplayLogoff) {
		this.initializationDone = false;
		this.setProperty("displayLogoff", bDisplayLogoff);
		return this;
	};

	return ApplicationHeader;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ApplicationHeader.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Area') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Area.
jQuery.sap.declare('sap.ui.commons.Area'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Area",['jquery.sap.global', './library', 'sap/ui/core/Element'],
	function(jQuery, library, Element) {
	"use strict";


	
	/**
	 * Constructor for a new Area.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Used for defining areas in an image map. At runtime, the user can trigger an action, or start a URL, from the single image areas.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Area
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Area = Element.extend("sap.ui.commons.Area", /** @lends sap.ui.commons.Area.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * The value is a string and can be 'rect' for rectangle, 'poly' for poligon, 'circle', or default.
			 */
			shape : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Coordinates of the area
			 */
			coords : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Hyper link that is executed when the area is clicked
			 */
			href : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * Alternative text that is displayed in the case the image is not available
			 */
			alt : {type : "string", group : "Misc", defaultValue : null}
		}
	}});
	
	///**
	// * This file defines behavior for the control,
	// */
	//sap.ui.dev.Area.prototype.init = function(){
	//   // do something for initialization...
	//};
	
	/**
	 * Function is called when Link is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Area.prototype.onclick = function(oEvent) {
	
		// The Element or Control that initiated the event. For example the id of the area if image map is defined for the current image.
		var oEventSource = jQuery(oEvent.target).control(0);
	
	    // Fire event on Image Map
		this.getParent().firePress({areaId: oEventSource.getId()});
	};

	return Area;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Area.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Button') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Button.
jQuery.sap.declare('sap.ui.commons.Button'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Button",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/EnabledPropagator', 'sap/ui/core/IconPool'],
	function(jQuery, library, Control, EnabledPropagator, IconPool) {
	"use strict";


	
	/**
	 * Constructor for a new Button.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Enables users to trigger actions such as save or print. For the button UI, you can define some text or an icon, or both.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.commons.ToolbarItem
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Button
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Button = Control.extend("sap.ui.commons.Button", /** @lends sap.ui.commons.Button.prototype */ { metadata : {
	
		interfaces : [
			"sap.ui.commons.ToolbarItem"
		],
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * 
			 * Button text displayed at runtime.
			 */
			text : {type : "string", group : "Appearance", defaultValue : ''},
	
			/**
			 * 
			 * Boolean property to enable the control (default is true). Buttons that are disabled have other colors than enabled ones, depending on custom settings.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * 
			 * Control width as common CSS-size (px or % as unit, for example)
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * 
			 * Unique identifier used for help service
			 */
			helpId : {type : "string", group : "Behavior", defaultValue : ''},
	
			/**
			 * Icon to be displayed as graphical element within the button.
			 * This can be an URI to an image or an icon font URI.
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},
	
			/**
			 * Icon to be displayed as graphical element within the button when it is hovered (only if also a base icon was specified). If not specified the base icon is used.
			 * If a icon font icon is used, this property is ignored.
			 */
			iconHovered : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},
	
			/**
			 * Icon to be displayed as graphical element within the button when it is selected (only if also a base icon was specified). If not specified the base or hovered icon is used.
			 * If a icon font icon is used, this property is ignored.
			 */
			iconSelected : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : ''},
	
			/**
			 * 
			 * If set to true (default), the display sequence is 1. icon 2. control text .
			 */
			iconFirst : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * Specifies the button height. If this property is set, the height which is specified by the underlying theme is not used any longer.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * Indicates if the button is styled. If not it is rendered as native HTML-button. In this case a custom styling can be added usig addStyleClass.
			 */
			styled : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * The button is rendered as lite button.
			 */
			lite : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * Style of the button.
			 * (e.g. emphasized)
			 */
			style : {type : "sap.ui.commons.ButtonStyle", group : "Appearance", defaultValue : sap.ui.commons.ButtonStyle.Default}
		},
		associations : {
	
			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
	
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {
	
			/**
			 * 
			 * Event is fired when the user presses the control.
			 */
			press : {}
		}
	}});
	
	
	/**
	 * Puts the focus to the button.
	 *
	 * @name sap.ui.commons.Button#focus
	 * @function
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	
	
	EnabledPropagator.call(Button.prototype);
	
	/**
	 * Function is called when button is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onclick = function(oEvent) {
		if (this.getEnabled()) {
			this.firePress({/* no parameters */});
		}
	
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	/**
	 * Handles the sapenter event does not bubble
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onsapenter = function(oEvent) {
		oEvent.stopPropagation();
	};
	
	/**
	 * Function is called when mouse key is clicked down. The button style classes
	 * are replaced then.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onmousedown = function(oEvent) {
		this.handleMouseDown(oEvent, true);
	};
	
	/**
	 * Function to handle the mouse down event.
	 *
	 * @param {jQuery.Event} oEvent The causing event.
	 * @param {boolean} [bFocus=false] Whether to set the focus on the selected element in a delayed call.
	 * @private
	 */
	Button.prototype.handleMouseDown = function(oEvent, bFocus) {
		if (this.getEnabled() && this.getRenderer().onactive) {
			this.getRenderer().onactive(this);
		}
		// webkit && firefox on mac does not focus a Button on click, it even unfocuses it onmousedown!
		if (bFocus && (!!sap.ui.Device.browser.webkit || (!!sap.ui.Device.browser.firefox && navigator.platform.indexOf("Mac") === 0))) {
			if (sap.ui.Device.browser.mobile && !!sap.ui.Device.browser.webkit) {
				//In mobile Webkit Browsers (IPad) the focus must be set immediately to ensure that a focusout happens whereever the
				//focus currently is. The deleayedCall below is still needed due to the reason described above. (CSN 2536817 2012)
				this.focus();
			}
			jQuery.sap.delayedCall(0, this, function(){
				this.focus();
			});
		}
	};
	
	/**
	 * When mouse key is up again, reset the background images to normal.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onmouseup = function(oEvent) {
		if (this.getEnabled() && this.getRenderer().ondeactive) {
			this.getRenderer().ondeactive(this);
		}
	};
	
	/**
	 * When mouse is going out of the control, reset the background images to normal.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onmouseout = function(oEvent) {
		if (this.getEnabled() && this.getRenderer().onmouseout) {
			this.getRenderer().onmouseout(this);
		}
	};
	
	/**
	 * When mouse is going over the control a hover effect is done.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onmouseover = function(oEvent) {
		if (this.getEnabled() && this.getRenderer().onmouseover) {
			this.getRenderer().onmouseover(this);
		}
	};
	
	/**
	 * When the button looses the focus, this method is called.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onfocusout = function(oEvent) {
		if (this.getEnabled() && this.getRenderer().onblur) {
			this.getRenderer().onblur(this);
		}
	};
	
	/**
	 * When the button gets the focus, this method is called.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Button.prototype.onfocusin = function(oEvent) {
		if (this.getEnabled() && this.getRenderer().onfocus) {
			this.getRenderer().onfocus(this);
		}
	};
	
	/*
	 * If Icon has just changed don't rerender.
	 */
	Button.prototype.setIcon = function(sIcon) {
	
		this._setIcon(sIcon, "icon");
	
		return this;
	
	};
	
	Button.prototype.setIconHovered = function(sIcon) {
	
		this._setIcon(sIcon, "iconHovered");
	
		return this;
	
	};
	
	Button.prototype.setIconSelected = function(sIcon) {
	
		this._setIcon(sIcon, "iconSelected");
	
		return this;
	
	};
	
	/*
	 * helper function to set different icons
	 */
	Button.prototype._setIcon = function(sIcon, sProperty) {
	
		var sIconOld = this.getProperty(sProperty);
	
		if (sIconOld == sIcon) {
			// icon not changed -> nothing to do
			return;
		}
	
		var bUseIconFontOld = false;
		if (IconPool.isIconURI(sIconOld)) {
			bUseIconFontOld = true;
		}
	
		var bUseIconFontNew = false;
		if (IconPool.isIconURI(sIcon)) {
			bUseIconFontNew = true;
		}
	
		var bSupressRerender = true;
		if ((!sIconOld && sIcon) || (sIconOld && !sIcon) || (bUseIconFontOld != bUseIconFontNew)) {
			// Icon new added or removed -> need to rerender
			bSupressRerender = false;
		}
	
		this.setProperty(sProperty, sIcon, bSupressRerender);
	
		if (bSupressRerender == true && this.getDomRef() && this.getRenderer().changeIcon) {
			this.getRenderer().changeIcon(this);
		}
	
	};
	

	return Button;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Button.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CalloutBase') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.CalloutBase.
jQuery.sap.declare('sap.ui.commons.CalloutBase'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.TooltipBase'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/CalloutBase",['jquery.sap.global', './library', 'sap/ui/core/TooltipBase'],
	function(jQuery, library, TooltipBase) {
	"use strict";



	/**
	 * Constructor for a new CalloutBase.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * CalloutBase is a building block for Callout. Do not use it directly. Use the Callout control instead
	 * @extends sap.ui.core.TooltipBase
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.CalloutBase
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var CalloutBase = TooltipBase.extend("sap.ui.commons.CalloutBase", /** @lends sap.ui.commons.CalloutBase.prototype */ { metadata : {

		library : "sap.ui.commons",
		events : {

			/**
			 * The event is fired when the popup is opened.
			 */
			open : {
				parameters : {

					/**
					 * Parent control that has this Callout as a tooltip
					 */
					parent : {type : "sap.ui.core.Control"}
				}
			},

			/**
			 * Event is fired when the Callout window is closed.
			 */
			close : {},

			/**
			 * Event is fired before a Callout is displayed. Call the preventDefault method of the event object to postpone opening. Application may use this event to start asynchronous Ajax call to load the Callout content
			 */
			beforeOpen : {allowPreventDefault : true,
				parameters : {

					/**
					 * Parent control that has this Callout as a tooltip
					 */
					parent : {type : "sap.ui.core.Control"}
				}
			},

			/**
			 * Is fired when the Callout has been opened
			 * @since 1.11.0
			 */
			opened : {}
		}
	}});


	/**
	 * Initializes a new callout base.
	 * Overrides default popup placement and offset of the TooltipBase control
	 *
	 * @private
	 */
	CalloutBase.prototype.init = function() {
		this.oPopup = new sap.ui.core.Popup();
		this.oPopup.setShadow(true);

		// resource bundle
		this.oRb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

		// override the default position and offset of TooltipBase:
		this.setPosition(sap.ui.core.Popup.Dock.BeginBottom, sap.ui.core.Popup.Dock.BeginTop);

		// listen to global events outside of the callout to close it when needed
		this.fAnyEventHandlerProxy = jQuery.proxy(this.onAnyEvent, this);

		// make this.oPopup call this.setTip each time after its position is changed
		var that = this;
		this.oPopup._applyPosition = function(oPosition){
			sap.ui.core.Popup.prototype._applyPosition.call(this, oPosition);
			that.setTip();
		};

		// close the Callout if its opener moves away (due to scrolling e.g.)
		this.oPopup.setFollowOf(sap.ui.core.Popup.CLOSE_ON_SCROLL);
	};

	/**
	 * Destroys this instance of the callout, called by Element#destroy()
	 * @private
	 */
	CalloutBase.prototype.exit = function() {
		this.oPopup.close();
		this.oPopup.detachEvent("opened", this.handleOpened, this);
		this.oPopup.detachEvent("closed", this.handleClosed, this);
		this.oPopup.destroy();
		delete this.oPopup;
		delete this.oRb;
		jQuery.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);
	};

	/**
	 * Return the popup to use. Each callout has own popup.
	 * (Allow multiple call-outs taking into account pin-up functionality in the next version).
	 * Overrides {@link sap.ui.core.TooltipBase} that has a single common popup for all instances.
	 * @type sap.ui.core.Popup
	 * @return The popup to use
	 * @private
	 */
	CalloutBase.prototype._getPopup = function(){
		return this.oPopup;
	};

	/**
	 * Check if the given DOM reference is child of this control
	 * @param {oDOMNode}
	 * DOM node reference
	 * @private
	 */
	CalloutBase.prototype.hasChild = function(oDOMNode) {
		return oDOMNode && !!(jQuery(oDOMNode).closest(this.getDomRef()).length);
	};

	/**
	 * Check if the given DOM reference is part of a SAPUI5 popup
	 * @param {oDOMNode}
	 * DOM node reference
	 * @private
	 */
	CalloutBase.prototype.isPopupElement = function(oDOMNode) {
		if (!oDOMNode) { return false; }
		if (this.hasChild(oDOMNode)) { return true; }

		var oStatic = sap.ui.getCore().getStaticAreaRef();
		// if oDOMNode belongs to a static area child, get z-index of this child:
		var thatZ = parseInt(jQuery(oDOMNode).closest(jQuery(oStatic).children()).css("z-index"), 10);
		// z-index of this:
		var thisZ = parseInt(this.$().css("z-index"), 10);

		// true if the element has the z-index inside of static area that is higher as the z-index of my control
		return thatZ && thisZ && thatZ >= thisZ;
	};

	/**
	 * Set tip arrow below or above the callout window depending on the popup placement
	 * @private
	 */
	CalloutBase.prototype.setTip = function() {

		if (!this.oPopup || !this.oPopup.isOpen()) {
			return;
		}

		var $parent = this._currentControl.$(),
			$this = this.$(),
			$arrow = this.$("arrow"),
			$offset = $this.offset(),
			$pOffset = $parent.offset(),
			bShow = true,
			dock = {},
			tRect = {
				l:$offset.left,
				r:$offset.left + $this.outerWidth(),
				w:$this.outerWidth(),
				t:$offset.top,
				b:$offset.top + $this.outerHeight(),
				h:$this.outerHeight()
			},
			pRect = {
				l:$pOffset.left,
				r:$pOffset.left + $parent.outerWidth(),
				w:$parent.outerWidth(),
				t:$pOffset.top,
				b:$pOffset.top + $parent.outerHeight(),
				h:$parent.outerHeight()
			},
			borderWidth = ($this.outerWidth() - $this.innerWidth()) / 2,
			arrowWidth = $arrow.outerWidth() * 1.4,
			aw = $arrow.outerWidth() / 5, // (width*sqrt(2)-width)/2
			tipOffset = aw - borderWidth - 8, // offset of the tip to the border should be 8px
			myPosition = this.getMyPosition();

		// right-left pointer
		if ( tRect.r < pRect.l - tipOffset ) {
			dock.x = "right";
		} else if (tRect.l - tipOffset > pRect.r ) {
			dock.x = "left";
		}

		// top-bottom pointer
		if ( tRect.t > pRect.b - tipOffset ) {
			dock.y = "top";
		} else if ( tRect.b < pRect.t + tipOffset ) {
			dock.y = "bottom";
		}

		if (dock.x) { // pointer on the left or right side

			var vPos = 0;
			// Set the vertical position of the pointer, relative to callout:
			//   dock top: top, dock bottom: bottom, dock center: center
			if (myPosition.indexOf("top") > -1) {
				vPos = 20;
			} else if (myPosition.indexOf("bottom") > -1) {
				vPos = tRect.h - 20 - arrowWidth;
			} else { // center
				vPos = (tRect.h - arrowWidth) / 2;
			}

			// adjust if it points outside of the parent or the parent is too small
			// - put it into the middle of intersection
			var tipY = tRect.t + vPos + arrowWidth / 2 + borderWidth;
			if ( (tipY < pRect.t) || (tipY > pRect.b) || (pRect.t > tRect.t && pRect.b < tRect.b)) {
				vPos = (Math.max(tRect.t, pRect.t) + Math.min(tRect.b, pRect.b)) / 2 - tRect.t -  arrowWidth / 2;
			}

			if (!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8 && dock.x == "left") {
				tipOffset = tipOffset - 8;
			}
			$arrow.css(dock.x, tipOffset + "px");
			$arrow.css("top", vPos);

			// do not show pointer if it cannot be placed inside
			if ( vPos < 0 || vPos > tRect.h - arrowWidth) {
				bShow = false;
			}
		}

		if (dock.y) { // pointer on the top or bottom border
			// switch right to left in case of RTL for the relevant docking (begin & end):
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			if (bRtl) { myPosition.replace("begin", "right").replace("end", "left"); }
			var hPos = 0;

			// Set horizontal position of the pointer, relative to callout:
			//   dock left: left, dock right: right, dock center: center
			if ((myPosition.indexOf("begin") > -1) || (myPosition.indexOf("left") > -1)) {
				hPos = 20;
			} else if ((myPosition.indexOf("right") > -1) || (myPosition.indexOf("end") > -1)) {
				hPos = tRect.w - 20 - arrowWidth;
			} else { // center
				hPos = (tRect.w - arrowWidth) / 2;
			}

			// adjust if it points outside of the parent - put it into the middle of intersection
			var tipX = tRect.l + hPos + arrowWidth / 2 + borderWidth;
			if ( (tipX < pRect.l) || (tipX > pRect.r)) {
				hPos = (Math.max(tRect.l, pRect.l) + Math.min(tRect.r, pRect.r)) / 2 - tRect.l - arrowWidth / 2;
			}

			if (!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8 && dock.y == "top") {
				tipOffset = tipOffset - 8;
			}
			$arrow.css(dock.y, tipOffset + "px");
			$arrow.css("left", hPos + "px");

			// do not show pointer if it cannot be placed inside
			if ( hPos < 0 || hPos > tRect.w - arrowWidth) {
				bShow = false;
			}
		}

		if (dock.x && dock.y || !dock.x && !dock.y) { bShow = false; }

		// hide if the pointer cannot be shown
		$arrow.toggle(bShow);
	};


	/**
	 * Adjust position of the already opened Callout window.
	 * Call this method each time when the size of the opened
	 * Callout window may be changed due to new or changed
	 * contents.
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	CalloutBase.prototype.adjustPosition = function() {

		function _adjust(){
			// adjust popup position
			if (this.oPopup) {
				var oParentDomRef = this._currentControl.getDomRef();
				this.oPopup.setPosition(this.getMyPosition(), this.getAtPosition(), oParentDomRef, this.getOffset(), this.getCollision());
			}
		}

		setTimeout( jQuery.proxy( _adjust, this ), 0 );
	};

	/**
	 * @see sap.ui.core.Element.prototype.focus As the callout itself is just a
	 *      frame, focus the first focusable content
	 * @private
	 */
	CalloutBase.prototype.focus = function() {
		if (this.oPopup && this.oPopup.isOpen()) {
			// Focus the first focusable child. If the callout is empty, focus the content container div.
			// Empty callout should be focused too because the contents may appear at a later time point
			// and we need input focus to react to the ESC key.
			var $Content = this.$("cont");
			jQuery.sap.focus($Content.firstFocusableDomRef() || $Content.get(0));
		}
	};

	/**
	 * Open the callout window.
	 *
	 * @param {sap.ui.core.Control}
	 *       parent control that contains the callout
	 * @private
	 */
	CalloutBase.prototype.openPopup = function(oSC) {

		if (!this.oPopup || this.oPopup.isOpen()) {
			return;
		}

		if (TooltipBase.sOpenTimeout) {
			jQuery.sap.clearDelayedCall(TooltipBase.sOpenTimeout);
			TooltipBase.sOpenTimeout = undefined;
		}

		// TODO this._parentControl member not defined! Can't we use oSC instead?
		// fire the "beforeOpen" event and delay display of the Callout if the application requests this
		if (!this.fireEvent("beforeOpen", {parent:this._currentControl}, true, false)) {
			if (!this.sCloseNowTimeout) {
				// postpone opening for 200ms
				TooltipBase.sOpenTimeout = jQuery.sap.delayedCall(200, this, "openPopup", [this._currentControl]);
			}
			return;
		}

		// save parent focus info to be restored after close
		this.oParentFocusInfo = oSC.getFocusInfo();

		this.oPopup.attachEvent("opened", this.handleOpened, this);

		// use TooltipBase to open the pop-up
		TooltipBase.prototype.openPopup.call(this, oSC);

		this.adjustPosition();

		this.fireOpen({ parent : this._currentControl });
	};

	/**
	 * Closes Callout
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	CalloutBase.prototype.close = function() {
		if (this.oPopup && this.oPopup.isOpen() && !this.sCloseNowTimeout) {
			if (TooltipBase.sOpenTimeout) {
				jQuery.sap.clearDelayedCall(TooltipBase.sOpenTimeout);
				TooltipBase.sOpenTimeout = undefined;
			}
			this.closePopup();
		}
	};

	/**
	 * Close CalloutBase. Fire the close event.
	 *
	 * @private
	 */
	CalloutBase.prototype.closePopup = function() {
		var bWasOpen = this.oPopup !== undefined && this.oPopup.isOpen();

		if (this.fAnyEventHandlerProxy) {
			jQuery.sap.unbindAnyEvent(this.onAnyEvent);
		}

		// This also attaches the handleClosed function to the closed-event
		TooltipBase.prototype.closePopup.call(this);

		// Set focus to the parent control.
		// Accessibility requirement: a focused Callout should set focus to its parent after close,
		// and not to a control where it could be found originally (In the scenario when a Callout
		// is opened on hover and a control inside it was clicked on with the mouse. This would
		// implicitly mean that a user has moved focus to the parent control intentionally)
		if (bWasOpen && this._currentControl && this.bFocused) {
			this._currentControl.applyFocusInfo(this.oParentFocusInfo);
			this.bFocused = false;
		}

		// inform the application
		this.fireClose();
	};

	/**
	 * Attaches the Callout to the Popup's closed-event and forwards it accordingly to the attached listeners
	 * @private
	 */
	CalloutBase.prototype.handleClosed = function(){
		if (this.oPopup) {
			this.oPopup.detachEvent("closed", this.handleClosed, this);
			this.fireClosed();
		}
	};

	/**
	 * Handle the key down event for ESCAPE and Ctrl-I.
	 *
	 * @param {jQuery.Event}
	 *            oEvent - the event that occurred on the Parent of the Callout.
	 * @private
	 */
	CalloutBase.prototype.onkeydown = function(oEvent) {

		var bCtrlI = oEvent.ctrlKey && oEvent.which == jQuery.sap.KeyCodes.I;
		var bEsc = oEvent.which == jQuery.sap.KeyCodes.ESCAPE;

		if (!bCtrlI && !bEsc) {
			if (jQuery(oEvent.target).control(0) === this._currentControl) {
				// Close callout by any key press on the parent control except for Ctrl-I
				this.close();
			}
			return;
		}

		// do not try to open the same callout twice
		if (bCtrlI) {
			if (this.oPopup && this.oPopup.isOpen()) {
				return; // this is already opened
			}
			this.bDoFocus = true; // accessibility: request focus
		}

		// let the TooltipBase remove/set standard tooltips and open/close the popup
		TooltipBase.prototype.onkeydown.call(this, oEvent);
	};

	/**
	 * If the callout has been opened with a keyboard command, the mouse
	 * pointer is most probably outside: the callout does not receive any
	 * mouseover and mouseout events. Arrange a global mousemove listener
	 * temporarily.
	 * Use case: accessibility testing; advanced users that prefer to work with
	 * keyboard instead of mouse.
	 *
	 * @private
	 */
	CalloutBase.prototype.handleOpened = function() {
		this.oPopup.detachEvent("opened", this.handleOpened, this);

		// The following is needed only of the callout was opened with the keyboard:
		// - request focus (accessibility requirement)
		if (this.bDoFocus) {
			this.focus();
			this.bDoFocus = false;
			this.bFocused = true; // Remember to set focus to parent on close
		}

		this.$().css("display:", "");
		this.fireOpened();

		// - listen to mouse over events outside
		//   do always because the Callout can lose focus to child popup controls
		jQuery.sap.bindAnyEvent(this.fAnyEventHandlerProxy);
	};

	/**
	 * Event handler for the focusin event.
	 * Organize a local tab chain inside of a callout.
	 * If it occurs on the focus handler elements at the beginning of the callout,
	 * the focus is set to the end, and vice versa.
	 * @param {jQuery.EventObject} oEvent The event object
	 * @private
	 */
	CalloutBase.prototype.onfocusin = function(oEvent){

		// Some element has been focused inside of the popup.
		// Focus will be set to the parent after popup close.
		this.bFocused = true;

		var oSourceDomRef = oEvent.target;

		// The same logic as in the Dialog.control:
		if (oSourceDomRef.id === this.getId() + "-fhfe") {
			// the FocusHandlingFirstElement was focused and thus the focus should move to the last element.
			jQuery.sap.focus(this.$("cont").lastFocusableDomRef());
		} else if (oSourceDomRef.id === this.getId() + "-fhee") {
			// the FocusHandlingEndElement was focused and thus the focus should move to the first element.
			jQuery.sap.focus(this.$("cont").firstFocusableDomRef());
		}
	};

	/**
	 * When a control that has a Callout looses the focus to the Callout contents,
	 * do not close it. Override the onfocusout event handler of TooltipBalse.
	 * @param {jQuery.EventObject} the event indication that the focus is lost
	 * @private
	 */
	CalloutBase.prototype.onfocusout = function(oEvent) {
		return;
	};

	/**
	* Handle the mouseover event: do not close if a child control has a simple tooltip
	* @param {jQuery.EventObject} oEvent The event that occurred in the callout
	* @private
	 */
	CalloutBase.prototype.onmouseover = function(oEvent) {
		// do not close my pop-up if it was opened already
		if (this.oPopup && (this.oPopup.isOpen() && this.oPopup.getContent() == this)) {
			if (this.sCloseNowTimeout) {
				jQuery.sap.clearDelayedCall(this.sCloseNowTimeout);
				this.sCloseNowTimeout = null;
			}
			return;
		} else {
			TooltipBase.prototype.onmouseover.call(this, oEvent);
		}
	};

	/**
	 * Handle the mouseout event of a Callout. Override the default TooltipBase behavior when
	 * the mouse pointer is over some other popup on the screen
	 * @param {jQuery.EventObject} oEvent mouseout Event.
	 * @private
	 */
	CalloutBase.prototype.onmouseout = function(oEvent) {
		// Do not close callout when the mouse goes to a popup (like menu)
		if (this.oPopup && (this.oPopup.isOpen() && this.isPopupElement(oEvent.relatedTarget))) {
			return;
		}
		TooltipBase.prototype.onmouseout.call(this, oEvent);
	};

	/**
	 * Always close Callout when the user clicks on the parent control.
	 * @param {jQuery.EventObject} the event
	 * @private
	 */
	CalloutBase.prototype.onmousedown = function(oEvent) {
		if (jQuery(oEvent.target).control(0) === this._currentControl) {
			this.close();
		}
	};

	/**
	 * Handles the outer event of the popup.
	 * @param {sap.ui.core.Event} oControlEvent The event
	 * @private
	 */
	CalloutBase.prototype.onAnyEvent = function(oEvent){

		if ((this.oPopup && !this.oPopup.isOpen()) || oEvent.type != "mouseover" || this.hasChild(oEvent.target)) {
			return;
		}

		// do not close if the hovered element is a top level popup or it is the parent of the callout
		var bDoNotClose = this.isPopupElement(oEvent.target) || jQuery(oEvent.target).control(0) === this._currentControl;
		if (!bDoNotClose && !this.sCloseNowTimeout && !TooltipBase.sOpenTimeout) {
			// schedule close if mouse moved outside of the Popup
			this.sCloseNowTimeout = jQuery.sap.delayedCall(400, this, "closePopup");
		}
		if (bDoNotClose && this.sCloseNowTimeout) {
			// do not close when inside
			jQuery.sap.clearDelayedCall(this.sCloseNowTimeout);
			this.sCloseNowTimeout = null;
		}
	};

	/**
	 * Set position of the Callout window relative to the parent control.
	 * This function automatically calculates and sets the correct offset,
	 * use it instead of <code>setMyPosition/setAtPosition</code>.
	 * @param {sap.ui.core.Dock} myPosition docking position of the Callout
	 * @param {sap.ui.core.Dock} atPosition docking position of the parent control
	 * @return {sap.ui.commons.CalloutBase} <code>this</code> to allow method chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	CalloutBase.prototype.setPosition = function(myPosition, atPosition){

		var myPos = myPosition || sap.ui.core.Popup.Dock.BeginBottom;
		var atPos = atPosition || sap.ui.core.Popup.Dock.BeginTop;

		var myX = 0, myY = 0, atX = 0, atY = 0, gap = 5;

		if ((myPos.indexOf("begin") > -1) || (myPos.indexOf("left") > -1)) {
			myX = -1;
		} else if ((myPos.indexOf("right") > -1) || (myPos.indexOf("end") > -1)) {
			myX = 1;
		}

		if ((atPos.indexOf("begin") > -1) || (atPos.indexOf("left") > -1)) {
			atX = -1;
		} else if ((atPos.indexOf("right") > -1) || (atPos.indexOf("end") > -1)) {
			atX = 1;
		}

		if (myPos.indexOf("top") > -1) {
			myY = -1;
		} else if (myPos.indexOf("bottom") > -1) {
			myY = 1;
		}

		if (atPos.indexOf("top") > -1) {
			atY = -1;
		} else if (atPos.indexOf("bottom") > -1) {
			atY = 1;
		}

		var offset = ((myX - atX) * myX * atX * gap) + " " + ((myY - atY) * myY * atY * gap);

		this.setMyPosition(myPos);
		this.setAtPosition(atPos);
		this.setOffset(offset);

		return this;
	};

	return CalloutBase;

}, /* bExport= */ true);

}; // end of sap/ui/commons/CalloutBase.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Carousel') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Carousel.
jQuery.sap.declare('sap.ui.commons.Carousel'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Carousel",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/ResizeHandler', 'sap/ui/core/delegate/ItemNavigation'],
	function(jQuery, library, Control, ResizeHandler, ItemNavigation) {
	"use strict";



	/**
	 * Constructor for a new Carousel.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Carousel holds multiple controls and displays them vertical or horizontal next to each other. You can define how many content items should be displayed at once or let the carousel determine that for you. Navigation is done through buttons or keys.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.8.0
	 * @alias sap.ui.commons.Carousel
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Carousel = Control.extend("sap.ui.commons.Carousel", /** @lends sap.ui.commons.Carousel.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Can be either "horizontal" or "vertical"
			 */
			orientation : {type : "sap.ui.commons.enums.Orientation", group : "Misc", defaultValue : sap.ui.commons.enums.Orientation.horizontal},

			/**
			 * Width of carousel
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},

			/**
			 * Height of carousel
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},

			/**
			 * Default height of item in carousel if no height can be determined
			 */
			defaultItemHeight : {type : "int", group : "Misc", defaultValue : 150},

			/**
			 * Default width of item in carousel if no height can be determined
			 */
			defaultItemWidth : {type : "int", group : "Misc", defaultValue : 150},

			/**
			 * Duration for animation when navigating through children
			 */
			animationDuration : {type : "int", group : "Misc", defaultValue : 500},

			/**
			 * If defined, the carousel displays the number of items defined. Items will be resized to fit the area.
			 */
			visibleItems : {type : "int", group : "Misc", defaultValue : null},

			/**
			 * Size of the handle in pixels. (Height for vertical carousel, width for horizontal carousel)
			 */
			handleSize : {type : "int", group : "Misc", defaultValue : 22},

			/**
			 * The index of the element in the content aggreation which is displayed first on rendering
			 * @since 1.11.0
			 */
			firstVisibleIndex : {type : "int", group : "Appearance", defaultValue : 0}
		},
		defaultAggregation : "content",
		aggregations : {

			/**
			 * Controls which are displayed inside the carousel
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content", bindable : "bindable"}
		}
	}});


	/**
	 * Initialize the carousel control
	 *
	 * @private
	 */
	Carousel.prototype.init = function() {
		this._visibleItems = 0;

		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};

	/**
	 * Clean up control when it is destroyed
	 *
	 * @private
	 */
	Carousel.prototype.exit = function() {
		// Cleanup resize event registration on exit
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
		this._destroyItemNavigation();
	};

	/**
	 * If one of the navigation buttons is clicked we trigger the navigation
	 *
	 * @private
	 */
	Carousel.prototype.onclick = function(oEvent) {
		var sCarouselId = this.getId();

		switch (oEvent.target) {
		case jQuery.sap.byId(sCarouselId + '-prevbutton')[0]:
			this.showPrevious();
			break;
		case jQuery.sap.byId(sCarouselId + '-nextbutton')[0]:
			this.showNext();
			break;
		default:
			return;
		}
	};

	/**
	 * Used for before-rendering initialization.
	 *
	 * @private
	 */
	Carousel.prototype.onBeforeRendering = function() {
		// Cleanup resize event registration before re-rendering
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};

	/**
	 * Used for after-rendering initialization.
	 *
	 * @private
	 */
	Carousel.prototype.onAfterRendering = function() {
		// Define which attribute needs to be animated
		if (this.getOrientation() == "vertical") {
			this._sAnimationAttribute = 'margin-top';
		} else {
			if (sap.ui.getCore().getConfiguration().getRTL()) {
				this._sAnimationAttribute = 'margin-right';
			} else {
				this._sAnimationAttribute = 'margin-left';
			}
		}

		this.showElementWithId(this._getItemIdByIndex(this.getFirstVisibleIndex()));

		this.calculateAndSetSize();
		this.oDomRef = this.getDomRef();
		this.sResizeListenerId = ResizeHandler.register(this.oDomRef, jQuery.proxy(this.onresize, this));

		this._initItemNavigation();
	};

	/**
	 * Initialize item navigation
	 *
	 * @private
	 */
	Carousel.prototype._initItemNavigation = function() {
		var $scrollList = this.$("scrolllist");

		if (!this._oItemNavigation) {
			this._oItemNavigation = new ItemNavigation();
			this._oItemNavigation.setCycling(true);
			this.addDelegate(this._oItemNavigation);
			//Setting focus on next to an invisible element changes the scollPosition and messes up correct display
			//So after setting the focus, we need to reset the left scrollpos
			this._oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, function(oEvent) {
				var $ContentArea = this.$("contentarea"),
					$ScrollList = this.$("scrolllist");

				// ItemNavigation should only handle keyboard, do not set the focus on a carousel item if clicked on control inside
				var oOrgEvent = oEvent.getParameter("event");
				if (oOrgEvent && oOrgEvent.type == "mousedown") {
					var bItem = false;
					for ( var i = 0; i < $ScrollList.children().length; i++) {
						var oItem = $ScrollList.children()[i];
						if (oOrgEvent.target.id == oItem.id) {
							bItem = true;
							break;
						}
					}
					if (!bItem) {
						// something inside carousel item clicked -> focus this one
						oOrgEvent.target.focus();
					}
				}

				if (sap.ui.getCore().getConfiguration().getRTL()) {
					$ContentArea.scrollLeft($ScrollList.width()  - $ContentArea.width());
				} else {
					$ContentArea.scrollLeft(0);
				}
			}, this);
		}

		this._oItemNavigation.setRootDomRef($scrollList[0]);
		this._oItemNavigation.setItemDomRefs($scrollList.children());
	};

	/**
	 * Destroy item navigation
	 *
	 * @private
	 */
	Carousel.prototype._destroyItemNavigation = function() {
		if (this._oItemNavigation) {
			this._oItemNavigation.destroy();
			this._oItemNavigation = undefined;
		}
	};

	/**
	 * Called after the theme has been switched. Some adjustments required.
	 *
	 * @private
	 */
	Carousel.prototype.onThemeChanged = function (oEvent) {
		this.calculateAndSetSize();
	};

	/**
	 * Focus in handling
	 * handles the focus when you tab into the control
	 *
	 * @private
	 */
	Carousel.prototype.onfocusin = function(oEvent) {
		var $target = jQuery(oEvent.target);
		// KEYBOARD HANDLING (_bIgnoreFocusIn is set in onsaptabXXX)
		if (!this._bIgnoreFocusIn && ($target.hasClass("sapUiCrslBefore") || $target.hasClass("sapUiCrslAfter"))) {
			// when entering the before or after helper DOM elements we put the
			// focus on the current focus element of the item navigation and we
			// leave the action mode!
			this._leaveActionMode();
			// set the focus on the last focused dom ref of the item navigation or
			// in case if not set yet (tab previous into item nav) then we set the
			// focus to the root domref
			jQuery(this._oItemNavigation.getFocusedDomRef() || this._oItemNavigation.getRootDomRef()).focus();
		}
	};

	/**
	 * If we are in action mode we only allow tabbing within the selected element
	 * else we focus on the next element in the tab chain (not in the carousel item)
	 *
	 * @private
	 */
	Carousel.prototype.onsaptabnext = function(oEvent) {
		var $this = this.$();
		if (this._bActionMode) {
			if ($this.find(".sapUiCrslScl").lastFocusableDomRef() === oEvent.target) {
				$this.find(".sapUiCrslScl").firstFocusableDomRef().focus();
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		} else {
			if (this._oItemNavigation.getFocusedDomRef() === oEvent.target) {
				this._bIgnoreFocusIn = true;
				$this.find(".sapUiCrslAfter").focus();
				this._bIgnoreFocusIn = false;
			}
		}
	};

	/**
	 * If we are in action mode we only allow tabbing within the selected element
	 * else we focus on the previous element in the tab chain (not in the carousel item)
	 *
	 * @private
	 */
	Carousel.prototype.onsaptabprevious = function(oEvent) {
		var $this = this.$();
		if (this._bActionMode) {
			if ($this.find(".sapUiCrslScl").firstFocusableDomRef() === oEvent.target) {
				$this.find(".sapUiCrslScl").lastFocusableDomRef().focus();
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		} else {
			if (this._oItemNavigation.getFocusedDomRef() === oEvent.target &&
					jQuery.sap.containsOrEquals($this.find(".sapUiCrslScl").get(0), oEvent.target)) {
				this._bIgnoreFocusIn = true;
				$this.find(".sapUiCrslBefore").focus();
				this._bIgnoreFocusIn = false;
			}
		}
	};

	/**
	 * handle the ESCAPE key to leave the action mode
	 *
	 * @private
	 */
	Carousel.prototype.onsapescape = function(oEvent) {
		this._leaveActionMode(oEvent);
	};

	/**
	 * Trigger the navigation to the next item and stop current animations (if available)
	 *
	 * @private
	 */
	Carousel.prototype.onsapnext = function(oEvent) {
		var $target = jQuery(oEvent.target);
		var $ScrollList = this.$("scrolllist");
		$ScrollList.stop(true, true);
		if ($target.hasClass('sapUiCrslItm') && $target.nextAll(':visible').length < 2) {
			this.showNext();
			oEvent.preventDefault();
		}
	};

	/**
	 * Trigger the navigation to the previous item and stop current animations (if available)
	 *
	 * @private
	 */
	Carousel.prototype.onsapprevious = function(oEvent) {
		var $target = jQuery(oEvent.target);
		var $ScrollList = this.$("scrolllist");
		$ScrollList.stop(true, true);
		if ($target.hasClass('sapUiCrslItm') && $target.prevAll(':visible').length < 2) {
			this.showPrevious();
			oEvent.preventDefault();
		}
	};

	/**
	 * If in action mode and F2 is pressed we leave the action mode
	 * If not in action mode and F2 or enter is pressed we enter the action mode
	 *
	 * @private
	 */
	Carousel.prototype.onkeydown = function(oEvent) {
		var $this = this.$();
		if (!this._bActionMode &&
			oEvent.keyCode == jQuery.sap.KeyCodes.F2 ||
			oEvent.keyCode == jQuery.sap.KeyCodes.ENTER) {
			if ($this.find(".sapUiCrslScl li:focus").length > 0) {
				this._enterActionMode($this.find(".sapUiCrslScl li:focus :sapFocusable").get(0));
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		} else if (this._bActionMode &&
			oEvent.keyCode == jQuery.sap.KeyCodes.F2) {
			this._leaveActionMode(oEvent);
		}
	};

	/**
	 * Handle clicking into elements
	 *
	 * @private
	 */
	Carousel.prototype.onmouseup = function(oEvent) {
		if (this.$().find(".sapUiCrslScl li :focus").length > 0) {
			// when clicking into a focusable control we enter the action mode!
			this._enterActionMode(this.$().find(".sapUiCrslScl li :focus").get(0));
		} else {
			// when clicking anywhere else in the table we leave the action mode!
			this._leaveActionMode(oEvent);
		}
	};

	if (sap.ui.Device.support.touch) {

		Carousel.prototype.onswipeleft = function(oEvent) {
			this.showNext();
		};

		Carousel.prototype.onswiperight = function(oEvent) {
			this.showPrevious();
		};

	}


	/**
	 * Enter action mode
	 *
	 * @private
	 */
	Carousel.prototype._enterActionMode = function(oDomRef) {
		// only enter the action mode when not already in action mode
		if (oDomRef && !this._bActionMode) {

			// in the action mode we need no item navigation
			this._bActionMode = true;
			this.removeDelegate(this._oItemNavigation);

			// remove the tab index from the item navigation
			jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "-1");

			//set aria active descendent
			this.$("scrolllist").attr("aria-activedescendant", jQuery(this._oItemNavigation.getFocusedDomRef()).attr("id"));

			// set the focus to the active control
			jQuery(oDomRef).focus();
		}
	};

	/**
	 * Leave action mode
	 *
	 * @private
	 */
	Carousel.prototype._leaveActionMode = function(oEvent) {
		if (this._bActionMode) {

			// in the navigation mode we use the item navigation
			this._bActionMode = false;
			this.addDelegate(this._oItemNavigation);

			// reset the tabindex of the focused domref of the item navigation
			jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "0");

			//remove aria active descendent
			this.$("scrolllist").removeAttr("aria-activedescendant");

			// when we have an event which is responsible to leave the action mode
			// we search for the closest
			if (oEvent) {
				if (jQuery(oEvent.target).closest("li[tabindex=-1]").length > 0) {
					// triggered when clicking into an item, then we focus the item
					var iIndex = jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(oEvent.target).closest("li[tabindex=-1]").get(0));
					this._oItemNavigation.focusItem(iIndex, null);
				} else {
					// somewhere else means whe check if the click happend inside
					// the container, then we focus the last focused element
					if (jQuery.sap.containsOrEquals(this.$().find(".sapUiCrslScl").get(0), oEvent.target)) {
						this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
					}
				}
			} else {
				// when no event is given we just focus the last focused index
				this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
			}
		}
	};

	/**
	 * Function is called when window is resized
	 *
	 * @param {jQuery.Event}
	 *            oEvent
	 * @private
	 */
	Carousel.prototype.onresize = function(oEvent) {
		if (!this.getDomRef()) {
			// carousel is not rendered, maybe deleted from DOM -> deregister resize
			// handler and do nothing
			// Cleanup resize event registration on exit
			if (this.sResizeListenerId) {
				ResizeHandler.deregister(this.sResizeListenerId);
				this.sResizeListenerId = null;
			}
			return;
		}

		this.calculateAndSetSize();
	};

	/**
	 * Shows previous item in carousel. This can be only used after the component is rendered.
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Carousel.prototype.showPrevious = function() {
		var mAnimationArguments = {};
		mAnimationArguments[this._sAnimationAttribute] = 0;
		var $ScrollList = this.$("scrolllist");
		if ($ScrollList.children('li').length < 2) {
			return;
		}
		$ScrollList.stop(true, true);
		$ScrollList.css(this._sAnimationAttribute, -this._iMaxWidth);
		var $lastItem = $ScrollList.children('li:last');
		var $firstItem = $ScrollList.children('li:first');
		this._showAllItems();
		$lastItem.insertBefore($firstItem);
		$ScrollList.append($lastItem.sapExtendedClone(true));
		var that = this;
		$ScrollList.animate(mAnimationArguments, this.getAnimationDuration(), function() {
				$ScrollList.children('li:last').remove();
				that.setProperty("firstVisibleIndex", that._getContentIndex($ScrollList.children('li:first').attr('id')), true);
				that._hideInvisibleItems();
			});
	};

	/**
	 * Shows next item in carousel. This can be only used after the component is rendered.
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Carousel.prototype.showNext = function() {
		var mAnimationArguments = {};
		mAnimationArguments[this._sAnimationAttribute] = -this._iMaxWidth;
		var $ScrollList = this.$("scrolllist");
		if ($ScrollList.children('li').length < 2) {
			return;
		}
		$ScrollList.stop(true, true);
		this._showAllItems();
		var sAnimationAttribute = this._sAnimationAttribute;
		var that = this;
		var $firstItem = $ScrollList.children('li:first');
		$firstItem.appendTo($ScrollList);
		$firstItem.sapExtendedClone(true).insertBefore($ScrollList.children('li:first'));
		$ScrollList.animate(mAnimationArguments, this.getAnimationDuration(), function() {
				$ScrollList.children('li:first').remove();
				jQuery(this).css(sAnimationAttribute, '0px');
				that.setProperty("firstVisibleIndex", that._getContentIndex($ScrollList.children('li:first').attr('id')), true);
				that._hideInvisibleItems();
			});
	};

	/**
	 * Shows the element with id specified. This can be only used after the component is rendered.
	 *
	 * @param {string} sElementId Id of the element to slide to.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Carousel.prototype.showElementWithId = function(sElementId) {
		this._showAllItems();
		var $ScrollList = this.$("scrolllist");
		sElementId = this.getId() + "-item-" + sElementId;
		var index = $ScrollList.children('li').index(jQuery.sap.byId(sElementId));
		$ScrollList.children('li:lt(' + index + ')').appendTo($ScrollList);
		this._hideInvisibleItems();
	};

	Carousel.prototype.calculateAndSetSize = function() {
		var aContent = this.getContent();
		var sCarouselId = this.getId();

		this._showAllItems();

		if (aContent.length > 0) {
			var maxWidth = 0;
			var maxHeight = 0;

			for ( var i = 0; i < aContent.length; i++) {
				var childWidth, childHeight;
				try {
					childWidth = aContent[i].getWidth();
					if (childWidth.substr( -1) == "%") {
						childWidth = this.getDefaultItemWidth();
					}
				} catch (e) {
					childWidth = this.getDefaultItemWidth();
				}
				try {
					childHeight = aContent[i].getHeight();
					if (childHeight.substr( -1) == "%") {
						childHeight = this.getDefaultItemHeight();
					}
				} catch (e) {
					childHeight = this.getDefaultItemHeight();
				}
				maxWidth = Math.max(maxWidth, parseInt(childWidth, 10));
				maxHeight = Math.max(maxHeight, parseInt(childHeight, 10));
			}

			if (maxWidth == 0 || isNaN(maxWidth)) {
				maxWidth = this.getDefaultItemWidth();
			}
			if (maxHeight == 0 || isNaN(maxHeight)) {
				maxHeight = this.getDefaultItemHeight();
			}

			var contentBarSize;
			var visibleItems = this.getVisibleItems();
			var $Me = jQuery.sap.byId(sCarouselId);
			var $NextButton = jQuery.sap.byId(sCarouselId + '-nextbutton');
			var $PrevButton = jQuery.sap.byId(sCarouselId + '-prevbutton');
			var $ContentArea = jQuery.sap.byId(sCarouselId + '-contentarea');

			if (this.getWidth() && this.getOrientation() == "vertical") {
				maxWidth = $Me.width();
			}
			if (this.getHeight() && this.getOrientation() == "horizontal") {
				maxHeight = $Me.height();
			}

			this.$().addClass('sapUiCrsl' + jQuery.sap.charToUpperCase(this.getOrientation(), 0));

			if (this.getOrientation() == "horizontal") {
				contentBarSize = $Me.width() - this.getHandleSize() * 2 - 1;
				$ContentArea.css('left', this.getHandleSize() + "px").css('right', this.getHandleSize() + "px");

				if (visibleItems == 0) {
					visibleItems = Math.floor(contentBarSize / maxWidth);
				}

				maxWidth = contentBarSize / visibleItems;
				this._iMaxWidth = maxWidth;

				var cLineHeight = maxHeight + "px";
				$ContentArea.find('.sapUiCrslItm').css("width", maxWidth + "px").css("height", maxHeight + "px").css("display", "inline-block");
				$PrevButton.css("height", maxHeight).css("line-height", cLineHeight);
				$NextButton.css("height", maxHeight).css("line-height", cLineHeight);
				$ContentArea.height(maxHeight);
				$Me.height(maxHeight);
			} else {
				contentBarSize = $Me.height() - this.getHandleSize() * 2 - 1;
				$ContentArea.css('top', this.getHandleSize() + "px").css('bottom', this.getHandleSize() + "px");

				if (visibleItems == 0) {
					visibleItems = Math.floor(contentBarSize / maxHeight);
				}

				maxHeight = contentBarSize / visibleItems;
				this._iMaxWidth = maxHeight;

				$ContentArea.find('.sapUiCrslItm').css("width", maxWidth + "px").css("height", maxHeight + "px").css("display", "block");
				$PrevButton.width(maxWidth).after($ContentArea);
				$NextButton.width(maxWidth);
				$ContentArea.width(maxWidth);
				$Me.width(maxWidth);
			}
			this._visibleItems = visibleItems;
			this._hideInvisibleItems();
		}
	};

	Carousel.prototype.getFocusDomRef = function() {
		return this.$("scrolllist");
	};

	/**
	 * Make all carousel items visible
	 *
	 * @private
	 */
	Carousel.prototype._showAllItems = function() {
		var $ContentArea = this.$("contentarea");
		$ContentArea.find('.sapUiCrslItm').show();
	};

	/**
	 * Hide all carousel items
	 *
	 * @private
	 */
	Carousel.prototype._hideInvisibleItems = function() {
		var $ContentArea = this.$("contentarea");
		$ContentArea.find('.sapUiCrslItm:gt(' + (this._visibleItems - 1)  + ')').hide();
	};

	Carousel.prototype._getContentIndex = function(sId) {
		var aIdParts = sId.split("-item-");
		return jQuery.inArray(sap.ui.getCore().byId(aIdParts[1]), this.getContent());
	};

	Carousel.prototype._getItemIdByIndex = function(iIndex) {
		var oContent = this.getContent()[iIndex];
		if (!oContent) {
			return null;
		}
		return oContent.getId();
	};

	/**
	 * Setter for property <code>firstVisibleIndex</code>.
	 *
	 * Default value is <code>0</code>
	 *
	 * @param {int} iFirstVisibleIndex  new value for property <code>firstVisibleIndex</code>
	 * @return {sap.ui.commons.Carousel} <code>this</code> to allow method chaining
	 * @public
	 * @since 1.11.0
	 */
	Carousel.prototype.setFirstVisibleIndex = function(iFirstVisibleIndex) {
		if (iFirstVisibleIndex > this.getContent().length - 1) {
			jQuery.sap.log.warning("The index is invalid. There are less items available in the carousel.");
			return this;
		}
		this.setProperty("firstVisibleIndex", iFirstVisibleIndex, true);
		this.showElementWithId(this._getItemIdByIndex(iFirstVisibleIndex));
		if (this._oItemNavigation) {
			this._oItemNavigation.focusItem(iFirstVisibleIndex);
		}
		return this;
	};


	//Fix because jQuery clone doesn't support cloning textarea values
	//jQuery Ticket #3016 (http://bugs.jquery.com/ticket/3016)

	//Textarea and select clone() bug workaround | Spencer Tipping
	//Licensed under the terms of the MIT source code license

	//Motivation.
	//jQuery's clone() method works in most cases, but it fails to copy the value of textareas and select elements. This patch replaces jQuery's clone() method with a wrapper that fills in the
	//values after the fact.

	//An interesting error case submitted by Piotr Przybył: If two <select> options had the same value, the clone() method would select the wrong one in the cloned box. The fix, suggested by Piotr
	//and implemented here, is to use the selectedIndex property on the <select> box itself rather than relying on jQuery's value-based val().

	(function (original) {
		jQuery.fn.sapExtendedClone = function () {
			var result           = original.apply(this, arguments);
			var my_textareas     = this.find('textarea').add(this.filter('textarea'));
			var result_textareas = result.find('textarea').add(result.filter('textarea'));
			var my_selects       = this.find('select').add(this.filter('select'));
			var result_selects   = result.find('select').add(result.filter('select'));

			for (var i = 0, l = my_textareas.length; i < l; ++i) {
				jQuery(result_textareas[i]).val(jQuery(my_textareas[i]).val());
			}
			for (var i = 0, l = my_selects.length;   i < l; ++i) {
				result_selects[i].selectedIndex = my_selects[i].selectedIndex;
			}

			return result;
		};
	})(jQuery.fn.clone);

	return Carousel;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Carousel.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.CheckBox') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.CheckBox.
jQuery.sap.declare('sap.ui.commons.CheckBox'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/CheckBox",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new CheckBox.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * 
	 * Provides a box which can be flagged, the box has a label. A check box can either stand alone, or in a group with other check boxes. As an option, the boxes can initially be set to status 'Not Editable'.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.CheckBox
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var CheckBox = Control.extend("sap.ui.commons.CheckBox", /** @lends sap.ui.commons.CheckBox.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Contains the state of the control whether it is flagged with a check mark, or not
			 */
			checked : {type : "boolean", group : "Data", defaultValue : false, bindable : "bindable"},
	
			/**
			 * Defines the text displayed next to the check box
			 */
			text : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * Using this property, the control could be disabled, if required.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Specifies whether the user shall be allowed to select the check box.
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Accepts the core enumeration ValueState.type that supports 'None', 'Error', 'Warning' and 'Success'.
			 */
			valueState : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},
	
			/**
			 * The width can be set to an absolute value. If no value is set, the control width results from the text length.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * The value can be set to LTR or RTL. Otherwise, the control inherits the text direction from its parent control.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
	
			/**
			 * The 'name' property to be used in the HTML code, for example for HTML forms that send data to the server via submit.
			 */
			name : {type : "string", group : "Misc", defaultValue : null}
		},
		associations : {
	
			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
	
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {
	
			/**
			 * 
			 * Event is triggered when the control status is changed by the user by flagging or unflagging the checkbox.
			 */
			change : {
				parameters : {
	
					/**
					 * 
					 * Checks whether the box is flagged or not flagged.
					 */
					checked : {type : "boolean"}
				}
			}
		}
	}});
	
	
	/**
	 * Event handler called when the check box is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CheckBox.prototype.onclick = function(oEvent) {
		//According to CSN2581852 2012 a readonly CB should be in the tabchain
		// This changed in 2013 back to not in the tabchain: see CSN 0002937527 2013
		// Let's see how often this will be changed back and forth in the future... Accessibility fun! :-D
		// End of 2013 is have to be again in the tabchain.
		// But not in the Form. But this is handled in the FromLayout control
		// Let's see what happens 2014... ;-)
		if (!!sap.ui.Device.browser.internet_explorer && !this.getEnabled()) {
			// in IE tabindex = -1 hides focus, so in readOnly/disabled case tabindex must be temporarily set to 0
			// as long as CheckBox is focused
			this.$().attr("tabindex", 0).addClass("sapUiCbFoc"); // the CSS class itself is not used, but IE only draws the standard focus outline when it is added
		}
	
		this.userToggle(oEvent);
	};
	
	/**
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CheckBox.prototype.onfocusout = function(oEvent) {
		//According to CSN2581852 2012 a readonly CB should be in the tabchain
		// This changed in 2013 back to not in the tabchain: see CSN 0002937527 2013
		// Let's see how often this will be changed back and forth in the future... Accessibility fun! :-D
		// End of 2013 is have to be again in the tabchain.
		// But not in the Form. But this is handled in the FromLayout control
		// Let's see what happens 2014... ;-)
		if (!!sap.ui.Device.browser.internet_explorer && !this.getEnabled()) {
			// in IE tabindex = -1 hides focus, so in readOnly/disabled case tabindex must be temporarily set to 0
			// as long as CheckBox is focused - now unset this again
			this.$().attr("tabindex", -1).removeClass("sapUiCbFoc");
		}
	};
	
	/**
	 * Event handler called when the space key is pressed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CheckBox.prototype.onsapspace = function(oEvent) {
		this.userToggle(oEvent);
	};
	
	/**
	 * This method is used internally whenever the user toggles the check box value.
	 * Purpose: Event cancellation and change event firing.
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CheckBox.prototype.userToggle = function(oEvent) {
		oEvent.preventDefault();
		if (this.getEnabled() && this.getEditable()) {
			this.toggle();
			this.fireChange({checked: this.getChecked()});
		} else {
			// CheckBox has been activated by the user, but value cannot be changed
			// do nothing, but restore the focus to the complete control, as the user might have clicked the <input> element which also can get the focus
			this.getDomRef().focus();
		}
	};
	
	// implement public method toggle()

	/**
	 * 
	 * Inverts the current value of the control.
	 *
	 * @type sap.ui.commons.CheckBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	CheckBox.prototype.toggle = function() {
		this.setChecked(!this.getChecked());
		return this;
	};
	

	return CheckBox;

}, /* bExport= */ true);

}; // end of sap/ui/commons/CheckBox.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ColorPicker') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ColorPicker.
jQuery.sap.declare('sap.ui.commons.ColorPicker'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ColorPicker",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";



	/**
	 * Constructor for a new ColorPicker.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This control gives the user the opportunity to choose a color. The color can be defined using HEX-, RGB- or HSV-values or a CSS colorname.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ColorPicker
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ColorPicker = Control.extend("sap.ui.commons.ColorPicker", /** @lends sap.ui.commons.ColorPicker.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * This is the import-parameter of the ColorPicker.
			 * As input-parameter, it can be a Hexadecimal string (#FFFFFF), a RGB-string rgb(255,255,255), a HSV-string hsv(360,100,100) or a CSS-colorname 'red'.
			 * As output-parameter it is a RGB-string containing the current color.
			 */
			colorString : {type : "string", group : "Misc", defaultValue : null}
		},
		events : {

			/**
			 * Value was changed. This event is fired if the value has changed by an user action.
			 */
			change : {
				parameters : {

					/**
					 * Parameter containing the RED value (0-255)
					 */
					r : {type : "int"},

					/**
					 * Parameter containing the GREEN value (0-255)
					 */
					g : {type : "int"},

					/**
					 * Parameter containing the BLUE value (0-255)
					 */
					b : {type : "int"},

					/**
					 * Parameter containing the HUE value (0-360)
					 */
					h : {type : "int"},

					/**
					 * Parameter containing the SATURATION value (0-100)
					 */
					s : {type : "int"},

					/**
					 * Parameter containing the VALUE value (0-100)
					 */
					v : {type : "int"},

					/**
					 * Parameter containing the Hexadecimal string (#FFFFFF)
					 */
					hex : {type : "string"},

					/**
					 * Parameter containing the alpha value (transparency)
					 */
					alpha : {type : "string"}
				}
			},

			/**
			 * Value was changed. This event is fired during the mouse move. The normal change event ist only fired by mouseup.
			 */
			liveChange : {
				parameters : {

					/**
					 * Parameter containing the RED value (0-255)
					 */
					r : {type : "int"},

					/**
					 * Parameter containing the GREEN value (0-255)
					 */
					g : {type : "int"},

					/**
					 * Parameter containing the BLUE value (0-255)
					 */
					b : {type : "int"},

					/**
					 * Parameter containing the HUE value (0-360)
					 */
					h : {type : "int"},

					/**
					 * Parameter containing the SATURATION value (0-100)
					 */
					s : {type : "int"},

					/**
					 * Parameter containing the VALUE value (0-100)
					 */
					v : {type : "int"},

					/**
					 * Parameter containing the Hexadecimal string (#FFFFFF)
					 */
					hex : {type : "string"},

					/**
					 * Parameter containing the alpha value (transparency)
					 */
					alpha : {type : "string"}
				}
			}
		}
	}});


	/**
	 * Initialization hook... creating composite parts
	 */
	ColorPicker.prototype.init = function(){

		var oRb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");

		//	declare global variable for the ColorObject
		this.Color = {
				r   :  255,
				g   :  255,
				b   :  255,
				h   :  0,
				s   :  0,
				v   :  100,
				a	:  1,
				a_old: 1,
				hex :  "#FFFFFF",
				old :  "#FFFFFF"
		};

		//	create global variables
		this.HexString = "FFFFFF";
		this.rgbString = "";
		this.$cpBox = null;
		this.$cpCur = null;
		this.RGB = {
				r : 0,
				g : 0,
				b : 0
		};

		//	check if we are in RTL mode
		this.bRtl  = sap.ui.getCore().getConfiguration().getRTL();

		//	create Matrix layout (outer control)
		this.oMatrix = new sap.ui.commons.layout.MatrixLayout({
			layoutFixed : true,
			columns : 3,
			width : "270px",
			widths : [ "117px", "84px", "69px"]
		});
		this.oMatrix.setParent(this);
		this.oMatrix.addStyleClass("sapUiColorPicker-ColorPickerMatrix");

		//	HTML-Control containing the ColorPickerBox
		var cpBoxID = this.getId() + '-cpBox';
		var cpCurID = this.getId() + '-cpCur';
		this.oHtmlBox = new sap.ui.core.HTML({
			content : "<DIV id=" + cpBoxID + " class=sapUiColorPicker-ColorPickerBox><DIV id=" + cpCurID + " class=sapUiColorPicker-ColorPickerCircle></DIV></DIV>"
		});

		//	HTML-Control containing the Old Color Box
		var ocBoxID = this.getId() + '-ocBox';
		this.oHtmlOldCol = new sap.ui.core.HTML({
			content : "<DIV id=" + ocBoxID + " class=sapUiColorPicker-ColorPickerOldColor></DIV>"
		});

		//	HTML-Control containing the New Color Box
		var ncBoxID = this.getId() + '-ncBox';
		this.oHtmlNewCol = new sap.ui.core.HTML({
			content : "<DIV id=" + ncBoxID + " class=sapUiColorPicker-ColorPickerNewColor></DIV>"
		});

		//	label and input field for Hexadecimal value
		var inpID = this.getId() + '-hxF';
		var hexValue = this.Color.hex.substr(1);
		this.oHexField = new sap.ui.commons.TextField({id: inpID, value : hexValue});
		this.oHexField.addStyleClass("sapUiColorPicker-ColorPickerHexField");
		this.oHexField.setTooltip(oRb.getText("COLORPICKER_HEX"));
		this.oHexLabel = new sap.ui.commons.Label();
		this.oHexLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
		this.oHexLabel.setText("#:");
		this.oHexLabel.setTooltip(oRb.getText("COLORPICKER_HEX"));
		this.oHexLabel.setLabelFor(this.oHexField);

		//	label and input field for Red Value
		inpID = this.getId() + '-rF';
		this.oRedField = new sap.ui.commons.TextField({id: inpID, value: this.Color.r, width:"3em"});
		this.oRedField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsLeft");
		this.oRedField.setTooltip(oRb.getText("COLORPICKER_RED"));
		this.oRedLabel = new sap.ui.commons.Label();
		this.oRedLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
		this.oRedLabel.setText("R:");
		this.oRedLabel.setTooltip(oRb.getText("COLORPICKER_RED"));
		this.oRedLabel.setLabelFor(this.oRedField);

		//	label and input field for Green Value
		inpID = this.getId() + '-gF';
		this.oGreenField = new sap.ui.commons.TextField({id: inpID, value : this.Color.g, width:"3em"});
		this.oGreenField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsLeft");
		this.oGreenField.setTooltip(oRb.getText("COLORPICKER_GREEN"));
		this.oGreenLabel = new sap.ui.commons.Label();
		this.oGreenLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
		this.oGreenLabel.setText("G:");
		this.oGreenLabel.setTooltip(oRb.getText("COLORPICKER_GREEN"));
		this.oGreenLabel.setLabelFor(this.oGreenField);

		//	label and input field for Blue Value
		inpID = this.getId() + '-bF';
		this.oBlueField = new sap.ui.commons.TextField({id: inpID, value : this.Color.b, width:"3em"});
		this.oBlueField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsLeft");
		this.oBlueField.setTooltip(oRb.getText("COLORPICKER_BLUE"));
		this.oBlueLabel = new sap.ui.commons.Label();
		this.oBlueLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
		this.oBlueLabel.setText("B:");
		this.oBlueLabel.setTooltip(oRb.getText("COLORPICKER_BLUE"));
		this.oBlueLabel.setLabelFor(this.oBlueField);

		//	label and input field for Hue Value
		inpID = this.getId() + '-hF';
		this.oHueField = new sap.ui.commons.TextField({id: inpID, value : this.Color.h, width:"3em"});
		this.oHueField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsRight");
		this.oHueField.setTooltip(oRb.getText("COLORPICKER_HUE"));
		this.oHueLabel = new sap.ui.commons.Label();
		this.oHueLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
		this.oHueLabel.setText("H:");
		this.oHueLabel.setTooltip(oRb.getText("COLORPICKER_HUE"));
		this.oHueLabel.setLabelFor(this.oHueField);

		//	label and input field for Saturation Value
		inpID = this.getId() + '-sF';
		this.oSatField = new sap.ui.commons.TextField({id: inpID, value : this.Color.s, width:"3em"});
		this.oSatField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsRight");
		this.oSatField.setTooltip(oRb.getText("COLORPICKER_SAT"));
		this.oSatLabel = new sap.ui.commons.Label();
		this.oSatLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
		this.oSatLabel.setText("S:");
		this.oSatLabel.setTooltip(oRb.getText("COLORPICKER_SAT"));
		this.oSatLabel.setLabelFor(this.oSatField);

		//	label and input field for Value
		inpID = this.getId() + '-vF';
		this.oValField = new sap.ui.commons.TextField({id: inpID, value : this.Color.v, width:"3em"});
		this.oValField.addStyleClass("sapUiColorPicker-ColorPickerInputFieldsRight");
		this.oValField.setTooltip(oRb.getText("COLORPICKER_VALUE"));
		this.oValLabel = new sap.ui.commons.Label();
		this.oValLabel.addStyleClass("sapUiColorPicker-ColorPickerLabels");
		this.oValLabel.setText("V:");
		this.oValLabel.setTooltip(oRb.getText("COLORPICKER_VALUE"));
		this.oValLabel.setLabelFor(this.oValField);

		//	slider
		inpID = this.getId() + '-hSLD';
		this.oSlider = new sap.ui.commons.Slider({id: inpID});
		this.oSlider.setSmallStepWidth(1);
		this.oSlider.setMax(360);
		this.oSlider.setValue(parseInt(this.oHueField.getValue(), 10),10);
		this.oSlider.setTooltip(oRb.getText("COLORPICKER_HUE"));
		this.oSlider.addStyleClass("sapUiColorPicker-ColorPickerSlider");

		// alpha slider
		inpID = this.getId() + '-aSLD';
		this.oAlphaSlider = new sap.ui.commons.Slider({id: inpID});
		this.oAlphaSlider.setMax(1);
		this.oAlphaSlider.setValue(1);
		this.oAlphaSlider.setSmallStepWidth(0.01);
		this.oAlphaSlider.setTooltip(oRb.getText("COLORPICKER_ALPHA"));
		this.oAlphaSlider.addStyleClass("sapUiColorPicker-ColorPickerAlphaSlider");

		//	1.Horizontal Layout
		this.oHLayout1 = new sap.ui.layout.HorizontalLayout({
			content: [this.oRedLabel, this.oRedField]
		});

		//	2.Horizontal Layout
		this.oHLayout2 = new sap.ui.layout.HorizontalLayout({
			content: [this.oGreenLabel, this.oGreenField]
		});

		//	3.Horizontal Layout
		this.oHLayout3 = new sap.ui.layout.HorizontalLayout({
			content: [this.oBlueLabel, this.oBlueField]
		});

		//	4.Horizontal Layout
		this.oHLayout4 = new sap.ui.layout.HorizontalLayout({
			content: [this.oHexLabel, this.oHexField]
		});

		//	5.Horizontal Layout
		this.oHLayout5 = new sap.ui.layout.HorizontalLayout({
			content: [this.oHueLabel, this.oHueField]
		});

		//	6.Horizontal Layout
		this.oHLayout6 = new sap.ui.layout.HorizontalLayout({
			content: [this.oSatLabel, this.oSatField]
		});

		//	7.Horizontal Layout
		this.oHLayout7 = new sap.ui.layout.HorizontalLayout({
			content: [this.oValLabel, this.oValField]
		});

		//	8.Horizontal Layout
		this.oHLayout8 = new sap.ui.layout.HorizontalLayout({
			content: [this.oHtmlOldCol, this.oHtmlNewCol]
		});

		//	Vertical Layout1 containing first four horizontal layouts
		this.oVLayout1 = new sap.ui.layout.VerticalLayout({
			content:[ this.oHLayout1, this.oHLayout2, this.oHLayout3, this.oHLayout4]
		});

		//	Vertical Layout2 containing 2.nd four horizontal layouts
		this.oVLayout2 = new sap.ui.layout.VerticalLayout({
			content:[ this.oHLayout5, this.oHLayout6, this.oHLayout7, this.oHLayout8]
		});
		this.oVLayout2.addStyleClass("sapUiColorPicker-ColorPickerLastColumn");

		//	add first Row to the Matrix Layout
		this.oMatrix.createRow(this.oHtmlBox, this.oVLayout1, this.oVLayout2);

		//	create second Row containing slider
		this.oRow2 = new sap.ui.commons.layout.MatrixLayoutRow();
		this.oCell = new sap.ui.commons.layout.MatrixLayoutCell({ colSpan : 3 });
		this.oCell.addContent(this.oSlider);
		this.oRow2.addCell(this.oCell);

		//	add second Row to the Matrix Layout
		this.oMatrix.addRow(this.oRow2);

		// add another row for the alpha slider
		this.oRow3 = new sap.ui.commons.layout.MatrixLayoutRow();
		this.oCell = new sap.ui.commons.layout.MatrixLayoutCell({ colSpan : 3 });
		this.oCell.addContent(this.oAlphaSlider);
		this.oRow3.addCell(this.oCell);

		//	add third Row to the Matrix Layout
		this.oMatrix.addRow(this.oRow3);

		//	attach Eventhandler
		this.oHexField.attachChange(jQuery.proxy(this._handleHexValueChange,this));
		this.oRedField.attachChange(jQuery.proxy(this._handleRedValueChange,this));
		this.oGreenField.attachChange(jQuery.proxy(this._handleGreenValueChange,this));
		this.oBlueField.attachChange(jQuery.proxy(this._handleBlueValueChange,this));
		this.oHueField.attachChange(jQuery.proxy(this._handleHueValueChange,this));
		this.oSatField.attachChange(jQuery.proxy(this._handleSatValueChange,this));
		this.oValField.attachChange(jQuery.proxy(this._handleValValueChange,this));
		this.oSlider.attachLiveChange(jQuery.proxy(this._handleSliderLiveChange,this));
		this.oSlider.attachChange(jQuery.proxy(this._handleSliderChange,this));
		this.oAlphaSlider.attachLiveChange(jQuery.proxy(this._handleAlphaSliderLiveChange,this));
		this.oAlphaSlider.attachChange(jQuery.proxy(this._handleAlphaSliderChange,this));

		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};



	/**
	 * Clean-up hook... destroying composite parts.
	 */
	ColorPicker.prototype.exit = function(){

		//	unbind Mouse-Event-Handler
		if (this.$cpBox) {
			this.$cpBox.unbind("mousedown", this.handleMouseDown);
		}

		jQuery(document)
		.unbind("mousemove", this.handleMousePos)
		.unbind("mouseup", this.handleMouseUp);

		//	destroy Objects
		this.oMatrix.destroy();
	};



	/*
	 * Evaluate parameter values
	 */
	ColorPicker.prototype.setColorString = function(iColorString) {

		//	parse string; get the color object
		this._parseColorString(iColorString);

		//	update UI
		this.oHexField.setValue(this.Color.hex.substr(1));
		this.oRedField.setValue(this.Color.r);
		this.oGreenField.setValue(this.Color.g);
		this.oBlueField.setValue(this.Color.b);
		this.oHueField.setValue(this.Color.h);
		this.oSatField.setValue(this.Color.s);
		this.oValField.setValue(this.Color.v);
		this.oSlider.setValue(this.Color.h);
		this.oAlphaSlider.setValue(this.Color.a);

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler of the mouse down event
	 */
	ColorPicker.prototype.handleMouseDown = function(e) {

		//	exit if the HEXfield is errorneous
		if (this.oHexField.getValueState() == sap.ui.core.ValueState.Error) {
			return;
		}

		//	call mouse position handler
		this.handleMousePos(e);
		jQuery(document)
		.bind("mousemove", jQuery.proxy(this.handleMousePos, this))
		.bind("mouseup", jQuery.proxy(this.handleMouseUp, this));
	};



	/**
	 * Event handler of the mouse up event
	 */
	ColorPicker.prototype.handleMouseUp = function(e) {

		//	exit if the HEXfield is errorneous
		if (this.oHexField.getValueState() == sap.ui.core.ValueState.Error) {
			return;
		}

		//	call mouse position handler
		this.handleMousePos(e);
		jQuery(document)
		.unbind("mousemove", this.handleMousePos)
		.unbind("mouseup", this.handleMouseUp);

		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for the mouse position
	 */
	ColorPicker.prototype.handleMousePos = function(e) {

		//	get offset of the colorpicker box
		var cpBoxOffset = this.$cpBox.offset();

		//	get width & height if the colorpicker box
		var cpBoxWidth  = this.$cpBox.width();
		var cpBoxHeight = this.$cpBox.height();

		//	calculate the hue and saturation values from the mouse position
		var x = e.pageX - cpBoxOffset.left;
		var y = e.pageY - cpBoxOffset.top;
		x = Math.min(Math.max(x, 0), cpBoxWidth);
		//	handle RTL - mode
		if (this.bRtl) {
			var rX = cpBoxWidth - x;
			x = rX;
		}
		y = Math.min(Math.max(y, 0), cpBoxHeight);
		var valValue = parseInt(x / cpBoxWidth * 100,10);
		var satValue = parseInt((1 - y / cpBoxHeight) * 100,10);

		//	set the new values
		this.oSatField.setValue(satValue);
		this.oValField.setValue(valValue);

		//	process changes
		this._processHSVchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for Slider LIVE changes
	 */
	ColorPicker.prototype._handleSliderLiveChange = function() {

		//	get the new value
		var sliderValue = parseInt(this.oSlider.getValue(),10);

		//	set the new hue value in the hue inut field
		this.oHueField.setValue(sliderValue);

		//	process changes
		this._processHSVchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for Slider changes
	 */
	ColorPicker.prototype._handleSliderChange = function() {

		//	get the new value
		var sliderValue = parseInt(this.oSlider.getValue(),10);

		//	set the new hue value in the hue inut field
		this.oHueField.setValue(sliderValue);

		//	process changes
		this._processHSVchanges();

		//	fire Change event
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	* Event handler for Alpha-Slider LIVE changes
	*/
	ColorPicker.prototype._handleAlphaSliderLiveChange = function() {

		// get the new value
		this.Color.a = this.oAlphaSlider.getValue();

		//	process changes
		this._processHSVchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for Alpha-Slider changes
	 */
	ColorPicker.prototype._handleAlphaSliderChange = function() {

		//	get the new value
		this.Color.a = this.oAlphaSlider.getValue();

		//	process changes
		this._processHSVchanges();

		//	fire Change event
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for changes of hue input field
	 */
	ColorPicker.prototype._handleHueValueChange = function(){

		//	get the new value
		var hueValue = parseInt(this.oHueField.getValue(),10);

		//	check for correct value (0 - 360)
		if (hueValue < 0 || isNaN(hueValue)) {
			hueValue = 0;
		}
		if (hueValue > 360) {
			hueValue = 359.9;
		}

		//	set the new value (maybe the value has been changed in the above lines)
		this.oHueField.setValue(hueValue);

		//	update slider value
		this.oSlider.setValue(hueValue);

		//	process Changes
		this._processHSVchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for changes of saturation input field
	 */
	ColorPicker.prototype._handleSatValueChange =  function(){

		//	get the new value
		var satValue = parseInt(this.oSatField.getValue(),10);

		//	check for correct value (0-100)
		if (satValue < 0 || isNaN(satValue)) {
			satValue = 0;
		}
		if (satValue > 100) {
			satValue = 100;
		}

		//	set the new value (maybe the value has been changed in the above lines)
		this.oSatField.setValue(satValue);

		//	process Changes
		this._processHSVchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for changes of value input field
	 */
	ColorPicker.prototype._handleValValueChange = function(){

		//	get the new value
		var valValue = parseInt(this.oValField.getValue(),10);

		//	check for correct value (0-100)
		if (valValue < 0 || isNaN(valValue)) {
			valValue = 0;
		}
		if (valValue > 100) {
			valValue = 100;
		}

		//	set the new value (maybe the value has been changed in the above lines)
		this.oValField.setValue(valValue);

		//	process Changes
		this._processHSVchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for changes of RED input field
	 */
	ColorPicker.prototype._handleRedValueChange = function(){

		//	get the new value
		var redValue = parseInt(this.oRedField.getValue(),10);

		//	check for correct value (0-255)
		if (redValue < 0 || isNaN(redValue)) {
			redValue = 0;
		}
		if (redValue > 255) {
			redValue = 255;
		}

		//	set the new value (maybe the value has been changed in the above lines)
		this.oRedField.setValue(redValue);

		//	process changes
		this._processRGBchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for changes of GREEN input field
	 */
	ColorPicker.prototype._handleGreenValueChange = function(){

		//	get the new value
		var greenValue = parseInt(this.oGreenField.getValue(),10);

		//	check for correct value
		if (greenValue < 0 || isNaN(greenValue)) {
			greenValue = 0;
		}
		if (greenValue > 255) {
			greenValue = 255;
		}

		//	set the new value (maybe the value has been changed in the above lines)
		this.oGreenField.setValue(greenValue);

		//	process changes
		this._processRGBchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Event handler for changes of BLUE input field
	 */
	ColorPicker.prototype._handleBlueValueChange = function(){

		//	get the new value
		var blueValue = parseInt(this.oBlueField.getValue(),10);

		//	check for correct value
		if (blueValue < 0 || isNaN(blueValue)) {
			blueValue = 0;
		}
		if (blueValue > 255) {
			blueValue = 255;
		}

		//	set the new value (maybe the value has been changed in the above lines)
		this.oBlueField.setValue(blueValue);

		//	process changes
		this._processRGBchanges();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Process changes of Hue, Value and Saturation
	 */
	ColorPicker.prototype._processHSVchanges = function(){

		//	get HSV-values
		var hueValue   = parseInt(this.oHueField.getValue(),10);
		var satValue   = parseInt(this.oSatField.getValue(),10);
		var valValue   = parseInt(this.oValField.getValue(),10);

		//	calculate and set new RGB-values
		this._calculateRGB(hueValue, satValue, valValue);
		this.Color.r = this.RGB.r;
		this.Color.g = this.RGB.g;
		this.Color.b = this.RGB.b;
		this.oRedField.setValue(this.Color.r);
		this.oGreenField.setValue(this.Color.g);
		this.oBlueField.setValue(this.Color.b);

		//	calculate and set HEX-values from the RGB-values
		this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);
		this.oHexField.setValue(this.HexString);
		this.Color.hex =  "#" + this.oHexField.getValue();

		//	set HSV-values
		this.Color.h = hueValue;
		this.Color.s = satValue;
		this.Color.v = valValue;
		this.oHueField.setValue(this.Color.h);
		this.oSatField.setValue(this.Color.s);
		this.oValField.setValue(this.Color.v);

		//	update gradient box background
		this._updateGradientBoxBackground(this.Color.h);

		//	update cursor position
		this._updateCursorPosition();

		//	update selected color background
		this._updateSelColorBackground();
	};



	/**
	 * Process changes of Red, Green and Blue values
	 */
	ColorPicker.prototype._processRGBchanges = function(){

		//	calculate and set HEX-value from the RGB-values
		var redValue   = Math.round(parseInt(this.oRedField.getValue(),10));
		var greenValue = Math.round(parseInt(this.oGreenField.getValue(),10));
		var blueValue  = Math.round(parseInt(this.oBlueField.getValue(),10));
		this._calculateHEX(redValue, greenValue, blueValue);
		this.oHexField.setValue(this.HexString);

		//	calculate and set HSV-values from the RGB-values
		this._calculateHSV(redValue, greenValue, blueValue);
		this.oHueField.setValue(this.Color.h);
		this.oSatField.setValue(this.Color.s);
		this.oValField.setValue(this.Color.v);

		//	update slider value
		this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));

		//	store the values in variable
		this.Color.r   = redValue;
		this.Color.g   = greenValue;
		this.Color.b   = blueValue;
		this.Color.hex =  "#" + this.oHexField.getValue();

		//	update gradient box background
		this._updateGradientBoxBackground(this.Color.h);

		//	update cursor position
		this._updateCursorPosition();

		//	update selected color background
		this._updateSelColorBackground();
	};



	/**
	 * Event handler for changes of HEX input field
	 */
	ColorPicker.prototype._handleHexValueChange = function(){

		//	get the new value and convert to uppercase
		var hexValue = this.oHexField.getValue().toUpperCase();

		//	check for correct value
		if (hexValue.substr(0, 1) == '#') {
			hexValue = hexValue.substr(1);
		}
		var re = /^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;
		if (re.test(hexValue) == false) {
			this.oHexField.setValueState(sap.ui.core.ValueState.Error);
			this.oSlider.setEnabled(false);
			this.oAlphaSlider.setEnabled(false);
			this.oHueField.setEnabled(false);
			this.oRedField.setEnabled(false);
			this.oGreenField.setEnabled(false);
			this.oBlueField.setEnabled(false);
			this.oSatField.setEnabled(false);
			this.oValField.setEnabled(false);
			return false;
		} else if (this.oHexField.getValueState()  == sap.ui.core.ValueState.Error) {
			this.oHexField.setValueState(sap.ui.core.ValueState.None);
			this.oSlider.setEnabled(true);
			this.oAlphaSlider.setEnabled(true);
			this.oHueField.setEnabled(true);
			this.oRedField.setEnabled(true);
			this.oGreenField.setEnabled(true);
			this.oBlueField.setEnabled(true);
			this.oSatField.setEnabled(true);
			this.oValField.setEnabled(true);
		}

		//	convert from short to long hex (if needed)
		if (hexValue.length == 3) {
			var tempValue = hexValue.charAt(0) + hexValue.charAt(0) + hexValue.charAt(1) + hexValue.charAt(1) + hexValue.charAt(2) + hexValue.charAt(2);
			hexValue = tempValue;
		}

		//	process Changes
		this._processHexChanges(hexValue);

		//	update UI
		this.oHexField.setValue(hexValue);
		this.oRedField.setValue(this.Color.r);
		this.oGreenField.setValue(this.Color.g);
		this.oBlueField.setValue(this.Color.b);
		this.oHueField.setValue(this.Color.h);
		this.oSatField.setValue(this.Color.s);
		this.oValField.setValue(this.Color.v);
		this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));
		this.oAlphaSlider.setValue(1);

		//	update gradient box background
		this._updateGradientBoxBackground(this.Color.h);

		//	update cursor position
		this._updateCursorPosition();

		//	update selected color background
		this._updateSelColorBackground();

		//	fire events & update property
		this.fireLiveChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.fireChange({r:this.Color.r, g:this.Color.g, b:this.Color.b, h:this.Color.h, s:this.Color.s, v:this.Color.v, alpha:this.Color.a, hex:this.Color.hex});
		this.setProperty('colorString', this._getRGBString(), true); // No re-rendering!
	};



	/**
	 * Hex-Values have changed ==> process changes
	 */
	ColorPicker.prototype._processHexChanges = function (ihexValue){

		//	convert RGB-values
		this._convertRGB(ihexValue);

		//	calculate and set HSV-values from the RGB-values
		this._calculateHSV(this.Color.r, this.Color.g, this.Color.b);

		//	all values except hex set; set the hex value
		this.Color.hex = "#" + ihexValue.toUpperCase();
	};



	/**
	 * Update Cursor position in the ColorPicker Box
	 */
	ColorPicker.prototype._updateCursorPosition = function(){

		//	get the width & height
		var cpCurWidth  = this.$cpCur.width();
		var cpCurHeight = this.$cpCur.height();
		var cpBoxWidth  = this.$cpBox.width();
		var cpBoxHeight = this.$cpBox.height();

		//	get the saturation and value
		var satValue = this.oSatField.getValue();
		var valValue = this.oValField.getValue();

		//	calculate the x and y values
		var x = parseInt(valValue * cpBoxWidth / 100,10);
		//	calculate x if we are in RTL mode
		if (this.bRtl) {
			var rX = cpBoxWidth - x;
			x = rX;
		}
		var y = parseInt((1 - satValue / 100) * cpBoxHeight,10);
		x = Math.min(Math.max(x, 0), cpBoxWidth - cpCurWidth / 2) - cpCurWidth / 2;
		y = Math.min(Math.max(y, 0), cpBoxHeight - cpCurHeight / 2) - cpCurHeight / 2;

		//	set the new cursor position
		this.$cpCur.css("left", x).css("top", y);
	};



	/**
	 * Calculate RGB-Values from Hue/Saturation/Value
	 */
	ColorPicker.prototype._calculateRGB = function( hue, sat, val){

		//hue value is cyclic, so 360 = 0
		if (hue == 360) {
			hue = 0;
		}
		hue /= 60;
		sat /= 100;
		val /= 100;


		//Formula taken from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
		var c = val * sat;
		var x = c * (1 - Math.abs(hue % 2 - 1));
		var m = val - c;

		// calculate values
		var redValue = 0, greenValue = 0, blueValue = 0;
		var i = Math.floor(hue);

		switch (i) {
			case 0:
				redValue   = c;
				greenValue = x;
				break;
			case 1:
				redValue   = x;
				greenValue = c;
				break;
			case 2:
				greenValue = c;
				blueValue  = x;
				break;
			case 3:
				greenValue = x;
				blueValue  = c;
				break;
			case 4:
				redValue   = x;
				blueValue  = c;
				break;
			case 5:
				redValue   = c;
				blueValue  = x;
				break;
		}

		this.RGB.r = Math.floor((redValue + m) * 255);
		this.RGB.g = Math.floor((greenValue + m) * 255);
		this.RGB.b = Math.floor((blueValue + m) * 255);
	};



	/**
	 * Get RGB-String from the current RGB-Values
	 */
	ColorPicker.prototype._getRGBString = function( ){
		if (this.Color.a < 1) {
			return "rgba(" + this.Color.r + "," + this.Color.g + "," + this.Color.b + ", " + this.Color.a + ")";
		} else {
			return "rgb(" + this.Color.r + "," + this.Color.g + "," + this.Color.b + ")";
		}
	};



	/**
	 * Calculate HEX-Values when RGB-values change
	 */
	ColorPicker.prototype._calculateHEX = function(red,green,blue){

		//	convert values
		var redStr     = red.toString(16);
		var greenStr   = green.toString(16);
		var blueStr    = blue.toString(16);
		if (redStr.length == 1)   {
			redStr   = '0' + redStr;
		}
		if (greenStr.length == 1) {
			greenStr = '0' + greenStr;
		}
		if (blueStr.length == 1)  {
			blueStr  = '0' + blueStr;
		}

		//	return the HexValue
		this.HexString = (redStr + greenStr + blueStr).toUpperCase();
	};



	/**
	 * Calculate HSV-Values from RGB-values
	 */
	ColorPicker.prototype._calculateHSV = function (red, green, blue){

		//	calculate values
		var max			= Math.max(Math.max(red, green), blue);
		var min			= Math.min(Math.min(red, green), blue);
		var delta		= (max - min);
		var valValue	= Math.round(max * 100 / 255);
		var satValue = (max == 0.0) ? 0 : (100 * delta / max);
		var hueValue = 0;
		if (satValue == 0) {
			hueValue = 0;
		} else if (red == max)   {
			hueValue = 60.0 * (green - blue) / delta;
		} else if (green == max) {
			hueValue = 120.0 + 60.0 * (blue - red) / delta;
		} else if (blue == max)  {
			hueValue = 240.0 + 60.0 * (red - green) / delta;
		}
		if (hueValue < 0.0) {
			hueValue += 359.9;
		}
		hueValue = Math.round(hueValue);
		satValue = Math.round(satValue);

		//	store the new values
		this.Color.h = hueValue;
		this.Color.s = satValue;
		this.Color.v = valValue;
	};



	/**
	 * Convert HEX-Value to RGB-Values
	 */
	ColorPicker.prototype._convertRGB = function(hex){

		//	calculate the new values
		var red   = parseInt(hex.substr(0, 2), 16);
		var green = parseInt(hex.substr(2, 2), 16);
		var blue  = parseInt(hex.substr(4, 2), 16);

		//	return the new values
		this.Color.r = red;
		this.Color.g = green;
		this.Color.b = blue;
	};



	/**
	 * Update GradientBox Background
	 */
	ColorPicker.prototype._updateGradientBoxBackground = function(hue){

		//	calculate RGB-values
		this._calculateRGB(hue, 100, 100);

		//	calculate Hex-value
		this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);

		//	set backgroundColor
		this.$cpBox.css('background-color','rgb(' + this.RGB.r + ', '  + this.RGB.g + ', ' + this.RGB.b + ')');
	};



	/**
	 * Update background of "new color box"
	 */
	ColorPicker.prototype._updateSelColorBackground = function(){

		//	set the new color
		this.$("ncBox").css('background-color',this._getRGBString());

	};



	/**
	 * Parse Input Parameter; evaluate color
	 */
	ColorPicker.prototype._parseColorString = function(iColorString){

		//	delete #, trim and convert to lower case
		if (iColorString.substr(0, 1) == '#') {
			iColorString = iColorString.substr(1);
		}
		iColorString = iColorString.replace(/ /g,'');
		iColorString = iColorString.toLowerCase();

		//	parse Names
		var searchKey = "";
		var hexValue = "";
		var colorNames = {
				aliceblue: 				'f0f8ff',
				antiquewhite: 			'faebd7',
				aqua: 					'00ffff',
				aquamarine: 			'7fffd4',
				azure: 					'f0ffff',
				beige: 					'f5f5dc',
				bisque: 				'ffe4c4',
				black: 					'000000',
				blanchedalmond:			'ffebcd',
				blue: 					'0000ff',
				blueviolet:				'8a2be2',
				brown:					'a52a2a',
				burlywood: 				'deb887',
				cadetblue: 				'5f9ea0',
				chartreuse: 			'7fff00',
				chocolate: 				'd2691e',
				coral: 					'ff7f50',
				cornflowerblue: 		'6495ed',
				cornsilk: 				'fff8dc',
				crimson: 				'dc143c',
				cyan: 					'00ffff',
				darkblue: 				'00008b',
				darkcyan: 				'008b8b',
				darkgoldenrod: 			'b8860b',
				darkgray: 				'a9a9a9',
				darkgreen: 				'006400',
				darkkhaki: 				'bdb76b',
				darkmagenta: 			'8b008b',
				darkolivegreen: 		'556b2f',
				darkorange: 			'ff8c00',
				darkorchid: 			'9932cc',
				darkred: 				'8b0000',
				darksalmon: 			'e9967a',
				darkseagreen: 			'8fbc8f',
				darkslateblue: 			'483d8b',
				darkslategray: 			'2f4f4f',
				darkturquoise: 			'00ced1',
				darkviolet: 			'9400d3',
				deeppink: 				'ff1493',
				deepskyblue: 			'00bfff',
				dimgray: 				'696969',
				dodgerblue: 			'1e90ff',
				feldspar: 				'd19275',
				firebrick: 				'b22222',
				floralwhite: 			'fffaf0',
				forestgreen: 			'228b22',
				fuchsia: 				'ff00ff',
				gainsboro: 				'dcdcdc',
				ghostwhite: 			'f8f8ff',
				gold: 					'ffd700',
				goldenrod: 				'daa520',
				gray: 					'808080',
				green: 					'008000',
				greenyellow: 			'adff2f',
				honeydew: 				'f0fff0',
				hotpink: 				'ff69b4',
				indianred : 			'cd5c5c',
				indigo : 				'4b0082',
				ivory: 					'fffff0',
				khaki: 					'f0e68c',
				lavender: 				'e6e6fa',
				lavenderblush: 			'fff0f5',
				lawngreen: 				'7cfc00',
				lemonchiffon: 			'fffacd',
				lightblue: 				'add8e6',
				lightcoral: 			'f08080',
				lightcyan: 				'e0ffff',
				lightgoldenrodyellow:	'fafad2',
				lightgrey: 				'd3d3d3',
				lightgreen: 			'90ee90',
				lightpink: 				'ffb6c1',
				lightsalmon: 			'ffa07a',
				lightseagreen: 			'20b2aa',
				lightskyblue: 			'87cefa',
				lightslateblue: 		'8470ff',
				lightslategray: 		'778899',
				lightsteelblue: 		'b0c4de',
				lightyellow: 			'ffffe0',
				lime: 					'00ff00',
				limegreen: 				'32cd32',
				linen: 					'faf0e6',
				magenta: 				'ff00ff',
				maroon: 				'800000',
				mediumaquamarine: 		'66cdaa',
				mediumblue: 			'0000cd',
				mediumorchid: 			'ba55d3',
				mediumpurple: 			'9370d8',
				mediumseagreen: 		'3cb371',
				mediumslateblue: 		'7b68ee',
				mediumspringgreen: 		'00fa9a',
				mediumturquoise: 		'48d1cc',
				mediumvioletred:		'c71585',
				midnightblue: 			'191970',
				mintcream: 				'f5fffa',
				mistyrose: 				'ffe4e1',
				moccasin: 				'ffe4b5',
				navajowhite: 			'ffdead',
				navy: 					'000080',
				oldlace: 				'fdf5e6',
				olive: 					'808000',
				olivedrab: 				'6b8e23',
				orange: 				'ffa500',
				orangered: 				'ff4500',
				orchid: 				'da70d6',
				palegoldenrod: 			'eee8aa',
				palegreen: 				'98fb98',
				paleturquoise: 			'afeeee',
				palevioletred: 			'd87093',
				papayawhip: 			'ffefd5',
				peachpuff: 				'ffdab9',
				peru: 					'cd853f',
				pink: 					'ffc0cb',
				plum: 					'dda0dd',
				powderblue: 			'b0e0e6',
				purple: 				'800080',
				red: 					'ff0000',
				rosybrown: 				'bc8f8f',
				royalblue: 				'4169e1',
				saddlebrown: 			'8b4513',
				salmon: 				'fa8072',
				sandybrown: 			'f4a460',
				seagreen: 				'2e8b57',
				seashell: 				'fff5ee',
				sienna: 				'a0522d',
				silver: 				'c0c0c0',
				skyblue: 				'87ceeb',
				slateblue: 				'6a5acd',
				slategray: 				'708090',
				snow: 					'fffafa',
				springgreen: 			'00ff7f',
				steelblue: 				'4682b4',
				tan: 					'd2b48c',
				teal: 					'008080',
				thistle: 				'd8bfd8',
				tomato: 				'ff6347',
				turquoise: 				'40e0d0',
				violet: 				'ee82ee',
				violetred: 				'd02090',
				wheat: 					'f5deb3',
				white: 					'ffffff',
				whitesmoke: 			'f5f5f5',
				yellow: 				'ffff00',
				yellowgreen: 			'9acd32'
		};

		for (searchKey in colorNames) {
			if (iColorString == searchKey) {
				hexValue = colorNames[searchKey].toUpperCase();
			}
		}

		if (hexValue != "") {
			//Found a name; get RGB and HSV values
			this._processHexChanges(hexValue);
			this.Color.old = this.Color.hex;
		}


		//	parse HEX
		//	allowed input: #aabbcc, aabbcc, #abc, abc
		//	'#' has already been deleted, search only for values
		//  check for correct value using regular expression
		var re = /^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;
		if (re.test(iColorString) == true) {
			//it's a hex value; check if its aabbcc or abc
			if (iColorString.length == 3) {
				var hexValue = iColorString.charAt(0) + iColorString.charAt(0) + iColorString.charAt(1) + iColorString.charAt(1) + iColorString.charAt(2) + iColorString.charAt(2);
			} else {
				hexValue = iColorString;
			}
			//get RGB and HSV values
			this._processHexChanges(hexValue);
			this.Color.old = this.Color.hex;
		}


		//	parse RGBA
		//	allowed input: rgba(255,255,255,0.3); rgba255,255,255,0.3
		//	check if the string begins with "rgba"
		if (iColorString.substr(0, 4) == 'rgba') {
			// remove rgba, "(", ")" and blanks
			iColorString = iColorString.substr(4);
			iColorString = iColorString.replace("(",'');
			iColorString = iColorString.replace(")",'');
			iColorString = iColorString.split(' ').join('');
			var re = /^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){1}(([0]\.[0-9]*)|(\.[0-9]{2})|[1]){1}$/;
			if (re.test(iColorString) == true) {
				//it's a rgba string, get the values and convert to Hex
				var RGBColor = iColorString.split(",");
				var sAlpha = iColorString.substr(iColorString.lastIndexOf(",") + 1, (iColorString.length - iColorString.lastIndexOf(",")));
				this._calculateHEX(parseInt(RGBColor[0],10), parseInt(RGBColor[1],10), parseInt(RGBColor[2],10));
				//get HSV values
				this._processHexChanges(this.HexString);
				this.Color.old = this.Color.hex;
				this.Color.a = this.Color.a_old = parseFloat(sAlpha);
			}
		}


		//	parse RGB
		//	allowed input: rgb(255,255,255); rgb255,255,255
		//	check if the string begins with "rgb"
		if (iColorString.substr(0, 3) == 'rgb') {
			// remove rgb, "(", ")" and blanks
			iColorString = iColorString.substr(3);
			iColorString = iColorString.replace("(",'');
			iColorString = iColorString.replace(")",'');
			iColorString = iColorString.split(' ').join('');
			var re = /^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5]))){1}$/;
			if (re.test(iColorString) == true) {
				//it's a rgb string, get the values and convert to Hex
				var RGBColor = iColorString.split(",");
				this._calculateHEX(parseInt(RGBColor[0],10), parseInt(RGBColor[1],10), parseInt(RGBColor[2],10));
				//get HSV values
				this._processHexChanges(this.HexString);
				this.Color.old = this.Color.hex;
			}
		}


		//	parse HSV
		//	allowed input: hsv(360,100,100); hsv360,100,100; [hsv(360,0.5,0.5); hsv360,0.5,0.5 later]
		//	check if the string begins with "rgb"
		if (iColorString.substr(0, 3) == 'hsv') {
			// remove hsv, "(", ")" and blanks
			iColorString = iColorString.substr(3);
			iColorString = iColorString.replace("(",'');
			iColorString = iColorString.replace(")",'');
			iColorString = iColorString.split(' ').join('');
			var re = /^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(((\d{1,2})|(100)),){1}((\d{1,2})|(100)){1}$/;
			if (re.test(iColorString) == true) {
				//it's a hsv string, get the values
				var HSVColor = iColorString.split(",");
				//get RGB values
				this._calculateRGB(parseInt(HSVColor[0],10), parseInt(HSVColor[1],10), parseInt(HSVColor[2],10));
				//get Hex values
				this._calculateHEX(this.RGB.r, this.RGB.g, this.RGB.b);
				//store the values
				this.Color.r   = this.RGB.r;
				this.Color.g   = this.RGB.g;
				this.Color.b   = this.RGB.b;
				this.Color.h   = parseInt(HSVColor[0],10);
				this.Color.s   = parseInt(HSVColor[1],10);
				this.Color.v   = parseInt(HSVColor[2],10);
				this.Color.hex = "#" + this.HexString;
				this.Color.old = this.Color.hex;
			}
		} else {
			return false;
		}
	};



	/**
	 * Event after rendering the page
	 */
	ColorPicker.prototype.onAfterRendering = function (){

		// get the jQuery-Object for cpBox and cpCur
		this.$cpBox = this.$("cpBox");
		this.$cpCur = this.$("cpCur");

		//	add Mousehandler for ColorPickerBox
		this.$cpBox.bind("mousedown", jQuery.proxy(this.handleMouseDown, this));

		//	set the background color of the Color Boxes
		this.$("ncBox").css('background-color',this._getRGBString());
		this.$("ocBox").css('background-color',this._getRGBString());

		//	update the background color of the 'new color box'
		this._updateGradientBoxBackground(this.Color.h);

		//	update cursor position
		this._updateCursorPosition();
	};



	/**
	 * Event before rendering the page
	 */
	ColorPicker.prototype.onBeforeRendering = function (){

		//	unbind Mousehandler for ColorPickerBox
		this.$("cpBox").unbind("mousedown", this.handleMouseDown);

	};


	/**
	 * Deliver current RGB-values.
	 *
	 * @name sap.ui.commons.ColorPicker#getRGB
	 * @function
	 * @type object
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ColorPicker.prototype.getRGB = function (){

		return {r:this.Color.r, g:this.Color.g, b:this.Color.b};

	};


	return ColorPicker;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ColorPicker.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ComboBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.ComboBox
jQuery.sap.declare('sap.ui.commons.ComboBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ComboBoxRenderer",['jquery.sap.global', './TextFieldRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, TextFieldRenderer, Renderer) {
	"use strict";


	/**
	 * Renderer for the sap.ui.commons.ComboBox
	 * @namespace
	 */
	var ComboBoxRenderer = Renderer.extend(TextFieldRenderer);

	/**
	 * Renders the attributes of the outer &lt;div&gt; for the ComboBox to the TextField
	 *
	 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oCmb an object representation of the ComboBox that should be rendered
	 */
	ComboBoxRenderer.renderOuterAttributes = function(rm, oCmb) {
		rm.addClass("sapUiTfCombo");
		this.renderComboARIAInfo(rm, oCmb);
	};

	/**
	 * Renders additional HTML for the ComboBox to the TextField before the INPUT element (sets the icon)
	 *
	 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oCmb an object representation of the ComboBox that should be rendered
	 */
	ComboBoxRenderer.renderOuterContentBefore = function(rm, oCmb){

		this.renderExpander(rm, oCmb);
		this.renderSelectBox(rm, oCmb, '-1');

	};

	ComboBoxRenderer.renderExpander = function(rm, oCmb){

		rm.write("<div");
		rm.writeAttributeEscaped('id', oCmb.getId() + '-icon');
		rm.writeAttribute('unselectable', 'on');
		if ( sap.ui.getCore().getConfiguration().getAccessibility()) {
			rm.writeAttribute("role", "presentation");
		}
		rm.addClass("sapUiTfComboIcon");
		rm.writeClasses();
		rm.write(">&#9660;</div>");//Symbol for HCB Theme (Must be hidden in other themes)

	};

	ComboBoxRenderer.renderSelectBox = function(rm, oCmb, sTabindex){

		if (oCmb.mobile) {
			// for mobile devices render SELECT box
			// it lays over the button but should be transparent. So a click on the button opens the select box
			rm.write("<select");
			rm.writeAttributeEscaped('id', oCmb.getId() + '-select');
			rm.writeAttribute('tabindex', sTabindex);
			if (!oCmb.getEnabled() || !oCmb.getEditable()) {
				rm.writeAttribute('disabled', 'disabled');
			}
			rm.write(">");
			for ( var i = 0; i < oCmb.getItems().length; i++) {
				var oItem = oCmb.getItems()[i];
				rm.write("<option");
				// combine comboBox ID with Item ID because items can be in more than one ComboBox vi the same List
				rm.writeAttributeEscaped('id', oCmb.getId() + "-" + oItem.getId());
				if (!oItem.getEnabled()) {
					rm.writeAttribute("disabled", "disabled");
				}
				rm.write(">" + oItem.getText() + "</option>");
			}
			rm.write("</select>");
		}

	};

	ComboBoxRenderer.renderOuterContent = function(rm, oCmb){

		if (oCmb.getDisplaySecondaryValues()) {
			rm.write("<span id=\"" + oCmb.getId() + "-SecVal\" style=\"display: none;\"></span>");
		}

	};

	/**
	 * Renders the inner &lt;div&gt; for the ComboBox to the TextField
	 *
	 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oCmb an object representation of the ComboBox that should be rendered
	 */
	ComboBoxRenderer.renderInnerAttributes = function(rm, oCmb) {

		if (oCmb.mobile) {
			rm.writeAttribute('autocapitalize', 'off');
			rm.writeAttribute('autocorrect', 'off');
		}

	};

	/*
	 * Renders ARIA information for the combobox (outer &lt;div&gt;)
	 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
	 * @private
	 */
	ComboBoxRenderer.renderComboARIAInfo = function(rm, oCmb) {

		// to not force creation if internal ListBox do not use _getListBox()
		var sListBox = oCmb.getListBox();
		if (!sListBox && oCmb._oListBox) {
			sListBox = oCmb._oListBox.getId();
		}

		var mProps = {
				role: "combobox",
				owns: oCmb.getId() + "-input " + sListBox
		};

		if (!oCmb.getEnabled()) {
			mProps["disabled"] = true;
		}

		rm.writeAccessibilityState(null,  //null because otherwise automatic generated attributes will be rendered twice
				mProps);

	};

	/*
	 * Renders ARIA information for the given input field (called from 'parent'-renderer, i.e. sap.ui.commons.TextFieldRenderer)
	 * As the input tag has the focus all controls aria attributes should be here
	 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
	 * @private
	 */
	ComboBoxRenderer.renderARIAInfo = function(rm, oCmb) {

		var iPosInSet = -1;
		if (oCmb.getSelectedItemId()) {
			for ( var i = 0; i < oCmb.getItems().length; i++) {
				var oItem = oCmb.getItems()[i];
				if (oItem.getId() == oCmb.getSelectedItemId()) {
					iPosInSet =  i + 1;
					break;
				}
			}
		}

		var mProps = {
				autocomplete: "inline",
				live: "polite",
				setsize: oCmb.getItems().length,
				posinset: (iPosInSet >= 0) ? iPosInSet : undefined
		};

		if (oCmb.getValueState() == sap.ui.core.ValueState.Error) {
			mProps["invalid"] = true;
		}

		if (oCmb.getDisplaySecondaryValues()) {
			mProps["describedby"] = {
					value: oCmb.getId() + "-SecVal",
					append: true
			};
		}

		rm.writeAccessibilityState(oCmb, mProps);

	};

	ComboBoxRenderer.setEditable = function(oCmb, bEditable) {

		if (oCmb.mobile) {
			var $Select = oCmb.$("select");
			if (bEditable && oCmb.getEnabled()) {
				$Select.removeAttr("disabled");
			} else {
				$Select.attr("disabled", "disabled");
			}
		}

		TextFieldRenderer.setEditable.apply(this, arguments);

	};

	ComboBoxRenderer.setEnabled = function(oCmb, bEnabled) {

		if (oCmb.mobile) {
			var $Select = oCmb.$("select");
			if (bEnabled && oCmb.getEditable()) {
				$Select.removeAttr("disabled");
			} else {
				$Select.attr("disabled", "disabled");
			}
		}

		TextFieldRenderer.setEnabled.apply(this, arguments);

	};

	return ComboBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ComboBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Dialog') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Dialog.
jQuery.sap.declare('sap.ui.commons.Dialog'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Dialog",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup'],
	function (jQuery, library, Control, Popup) {
		"use strict";


		/**
		 * Constructor for a new Dialog.
		 *
		 * @param {string} [sId] id for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] initial settings for the new control
		 *
		 * @class
		 * An interactive window appearing on request displaying information to the user. The API supports features such as popups with fixed sizes, popups with unlimited width, scrolling bars for large windows, and control nesting (for example, a drop-down list can be included in the window).
		 * @extends sap.ui.core.Control
		 * @implements sap.ui.core.PopupInterface
		 *
		 * @author SAP SE
		 * @version 1.28.17
		 *
		 * @constructor
		 * @public
		 * @alias sap.ui.commons.Dialog
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var Dialog = Control.extend("sap.ui.commons.Dialog", /** @lends sap.ui.commons.Dialog.prototype */ {
			metadata: {

				interfaces: [
					"sap.ui.core.PopupInterface"
				],
				library: "sap.ui.commons",
				properties: {

					/**
					 *
					 * Outer width of dialog window. When not set and not constrained by one of the width parameters (minWidth/maxWidth), the window size is automatically adapted to the content.
					 */
					width: {
						type: "sap.ui.core.CSSSize",
						group: "Dimension",
						defaultValue: null
					},

					/**
					 *
					 * Outer height of dialog window. When not set and not constrained by one of the height parameters (minHeight/maxHeight), the window size is automatically adapted to the content.
					 */
					height: {
						type: "sap.ui.core.CSSSize",
						group: "Dimension",
						defaultValue: null
					},

					/**
					 *
					 * Scroll position from left to right. "0" means leftmost position.
					 */
					scrollLeft: {
						type: "int",
						group: "Behavior",
						defaultValue: 0
					},

					/**
					 *
					 * Scroll position from top to bottom. "0" means topmost position.
					 */
					scrollTop: {
						type: "int",
						group: "Behavior",
						defaultValue: 0
					},

					/**
					 *
					 * Dialog title displayed in the header.
					 */
					title: {
						type: "string",
						group: "Misc",
						defaultValue: ''
					},

					/**
					 *
					 * Padding is theme-dependent. When set to "false", the content extends to the dialog borders.
					 */
					applyContentPadding: {
						type: "boolean",
						group: "Appearance",
						defaultValue: true
					},

					/**
					 *
					 * Displays a close button in the title bar.
					 */
					showCloseButton: {
						type: "boolean",
						group: "Behavior",
						defaultValue: true
					},

					/**
					 *
					 * Specifies whether the dialog window can be resized by the user. The dialog frame contains the visual symbol.
					 */
					resizable: {
						type: "boolean",
						group: "Behavior",
						defaultValue: true
					},

					/**
					 *
					 * Minimum outer width of the dialog window. When set, neither the user nor some layout settings can make the window smaller.
					 */
					minWidth: {
						type: "sap.ui.core.CSSSize",
						group: "Dimension",
						defaultValue: null
					},

					/**
					 *
					 * Minimum outer height of the dialog window. When set, neither the user nor some layout settings can make the window smaller.
					 */
					minHeight: {
						type: "sap.ui.core.CSSSize",
						group: "Dimension",
						defaultValue: null
					},

					/**
					 *
					 * Maximum outer width of the dialog window. If set, neither the user nor some layout settings can make the window larger.
					 */
					maxWidth: {
						type: "sap.ui.core.CSSSize",
						group: "Dimension",
						defaultValue: null
					},

					/**
					 *
					 * Maximum outer height of the dialog window. If set, neither the user nor some layout settings can make the window larger.
					 */
					maxHeight: {
						type: "sap.ui.core.CSSSize",
						group: "Dimension",
						defaultValue: null
					},

					/**
					 *
					 * Border design is theme-dependent.
					 */
					contentBorderDesign: {
						type: "sap.ui.commons.enums.BorderDesign",
						group: "Appearance",
						defaultValue: sap.ui.commons.enums.BorderDesign.None
					},

					/**
					 * Specify whether the dialog should be modal, or not. In case of <code>true</code> the focus is kept inside the dialog.
					 */
					modal: {
						type: "boolean",
						group: "Misc",
						defaultValue: false
					},

					/**
					 * The ARIA role for the control. E.g. for alert-style Dialogs this can be set to "AlertDialog".
					 */
					accessibleRole: {
						type: "sap.ui.core.AccessibleRole",
						group: "Accessibility",
						defaultValue: sap.ui.core.AccessibleRole.Dialog
					},

					/**
					 * Whether Dialog movement should be restricted to the visible area of the window. This only affects drag&drop movements by the user. This doesn't affect modal dialogs -> modal dialogs always stay in the window.
					 * @since 1.9.0
					 */
					keepInWindow: {
						type: "boolean",
						group: "Behavior",
						defaultValue: false
					},

					/**
					 * If this property is set to true the Dialog will close if the Dialog loses its focus
					 * @since 1.10
					 */
					autoClose: {
						type: "boolean",
						group: "Misc",
						defaultValue: false
					}
				},
				defaultAggregation: "content",
				aggregations: {

					/**
					 * Aggregating the buttons to display at the bottom of the dialog, for example OK and Cancel. Association defaultButton can be used for one of the defined buttons.
					 */
					buttons: {
						type: "sap.ui.core.Control",
						multiple: true,
						singularName: "button"
					},

					/**
					 * Aggregating the content of the dialog (one or more controls).
					 *
					 * Caveat: when content is added with width given as a percentage, the Dialog itself should have a width set.
					 */
					content: {
						type: "sap.ui.core.Control",
						multiple: true,
						singularName: "content"
					}
				},
				associations: {

					/**
					 *
					 * Defines one of the buttons that have been provided via button aggregation to be the default button. This default button is initially selected, if no control is set via the initialFocus association explicitly. The default button is activated when Enter is pressed in the context of the dialog and when the currently selected element does not handle the Enter event itself.
					 */
					defaultButton: {
						type: "sap.ui.commons.Button",
						multiple: false
					},

					/**
					 *
					 * Defines the control that shall get the focus when the dialog is opened.
					 */
					initialFocus: {
						type: "sap.ui.core.Control",
						multiple: false
					}
				},
				events: {

					/**
					 *
					 * Event is fired when the dialog has been closed (after closing-animation etc.). Event parameters provide information about last position and last size.
					 */
					closed: {
						parameters: {

							/**
							 * the width of the dialog when closed
							 */
							width: {
								type: "int"
							},

							/**
							 * the height of the dialog when closed
							 */
							height: {
								type: "int"
							},

							/**
							 * the top position of the dialog when closed
							 */
							top: {
								type: "int"
							},

							/**
							 * the left position of the dialog when closed
							 */
							left: {
								type: "int"
							}
						}
					}
				}
			}
		});


		/**
		 * Initialization hook for the dialog.
		 * It creates the instance of the Popup helper service and does some basic configuration for it.
		 *
		 * @private
		 */
		Dialog.prototype.init = function () {
			// do something for initialization...
			this.oPopup = new Popup(this, true, true);
			var eDock = Popup.Dock;
			this.oPopup.setPosition(eDock.CenterCenter, eDock.CenterCenter, window);

			this._minWidth = 64; // the technical minWidth, not the one set via API; will be calculated after rendering
			this._minHeight = 48; // the technical minHeight, not the one set via API; will be calculated after rendering

			this.allowTextSelection(false);

			this._mParameters = {};
			this._mParameters.that = this;
			this._mParameters.firstFocusable = this.getId() + "-fhfe";
			this._mParameters.lastFocusable = this.getId() + "-fhee";
		};

		Dialog.prototype.setInitialFocus = function (sId) {
			if (sId != null && typeof sId != "string") {
				sId = sId.getId();
			}
			this.oPopup.setInitialFocusId(sId);
			this.setAssociation("initialFocus", sId, /* suppress invalidate */ true);
		};

		/**
		 * Required adaptations after rendering.
		 * @private
		 */
		Dialog.prototype.onAfterRendering = function () {
			var $content = this.$("cont");

			// if content has 100% width, but Dialog has no width, set content width to auto
			if (!Dialog._isSizeSet(this.getWidth()) && !Dialog._isSizeSet(this.getMaxWidth())) {
				$content.children().each(function (index, element) {
					if (jQuery.trim(this.style.width) == "100%") {
						this.style.width = "auto";
					}
				});
			}

			// IE9+10 fix where subpixel font rendering may lead to rounding errors in RTL mode when the content has a width of "xyz.5px"
			if (!!sap.ui.Device.browser.internet_explorer && (sap.ui.Device.browser.version == 9 || sap.ui.Device.browser
					.version == 10) && ($content.length > 0)) {
				var elm = $content[0];
				if (sap.ui.getCore().getConfiguration().getRTL() && !Dialog._isSizeSet(this.getWidth())) {
					if (elm.ownerDocument && elm.ownerDocument.defaultView && elm.ownerDocument.defaultView.getComputedStyle) {
						var width = elm.ownerDocument.defaultView.getComputedStyle(elm).getPropertyValue("width");
						if (width) {
							var fWidth = parseFloat(width, 10);
							if (fWidth % 1 == 0.5) {
								$content[0].style.width = (fWidth + 0.01) + "px"; // if aaaalll these conditions are fulfilled, the Dialog must be a LITTLE bit wider to avoid rounding errors
							}
						}
					}
				}
			}

			// if height is not set, but min-height is set, the Dialog is in a mixed mode between fixed height and flexible height
			// (denoted by sapUiDlgFlexHeight), where sometimes the content pushes the height (when it is tall enough) and sometimes
			// the Dialog needs to take care to push the button row to the bottom (when there is less content than what would fit into a Dialog
			// with min-height size).
			// Therefore we need to check which one of both cases is currently active.
			if (!Dialog._isSizeSet(this.getHeight()) && Dialog._isSizeSet(this.getMinHeight())) {
				// height is not set, so the content height should push the height - denoted by the CSS class "sapUiDlgFlexHeight" which applies a simple layout
				// where header, content, and footer are stacked on top of each other

				// however, when there is a minHeight set which is larger than the natural height, the footer would be not at the bottom, so let's check whether the Dialog
				// is now smaller than the min-height:
				var footer = this.getDomRef("footer");
				var footerBottom = footer.offsetTop + footer.offsetHeight;
				var dialogBottom = this.getDomRef().offsetHeight;
				if (footerBottom < dialogBottom) {
					this.$().removeClass("sapUiDlgFlexHeight");
				} // else normal case: Dialog content pushes its height to or beyond its minimum height - this works fine with "sapUiDlgFlexHeight"
			}

			// Calculate min size and we need to do a delayedCall here because we do not have the size of the header and footer of the Dialog
			if (!this._sDelayedCall) {
				this._sDelayedCall = jQuery.sap.delayedCall(0, this, function () {
					var _minSize = this.getMinSize();
					this._minWidth = _minSize.width;
					this._minHeight = _minSize.height;
					this._sDelayedCall = null;
				});
			} else {
				jQuery.sap.clearDelayedCall(this._sDelayedCall);
			}
		};

		/**
		 * Handle the click event happening on the dialog instance.
		 *
		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.onclick = function (oEvent) {
			var sCloseBtnId = this.getId() + "-close";
			if (oEvent.target.id === sCloseBtnId) {
				this.close();
				oEvent.preventDefault(); // avoid onbeforeunload event which happens at least in IE9 because of the javascript:void(0); link target
			}
			return false;
		};

		/**
		 * Opens the dialog control instance.
		 *
		 * @type void
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		Dialog.prototype.open = function () {
			if (!this.oPopup) {
				jQuery.sap.log.fatal("This dialog instance has been destroyed already");
			} else if (!this._bOpen) {
				// Save current focused element to restore the focus after closing the dialog
				this._oPreviousFocus = Popup.getCurrentFocusInfo();

				this.oPopup.attachEvent("opened", this.handleOpened, this);
				this.oPopup.attachEvent("closed", this.handleClosed, this);
				this.oPopup.setModal(this.getModal());
				this.oPopup.setAutoClose(this.getAutoClose());
				this.oPopup.open(400);
				this._bOpen = true;
			}
		};

		/**
		 * Re-renders the control when the theme is changed
		 *
		 * @param oEvent
		 */
		Dialog.prototype.onThemeChanged = function (oEvent) {
			this.invalidate();
		};

		/**
		 * @private
		 */
		Dialog.prototype._handleOpened = function () {
			// Make sure the dom content is shown (in the static area)
			this.$().show();

			var sInitFocus = this.getInitialFocus(),
				oFocusCtrl;
			if (sInitFocus && (oFocusCtrl = sap.ui.getCore().getControl(sInitFocus))) { // an additional previous check was  oFocusCtrl.getParent() === this  which prevented nested children from being focused
				oFocusCtrl.focus();
				this._bInitialFocusSet = true;
			} else {
				sInitFocus = this.getDefaultButton();
				if (sInitFocus && (oFocusCtrl = sap.ui.getCore().getControl(sInitFocus)) && oFocusCtrl.getParent() === this) {
					oFocusCtrl.focus();
					this._bInitialFocusSet = true;
				} else if (this.getButtons().length > 0) {
					this.getButtons()[0].focus();
					this._bInitialFocusSet = true;
				} else if (this.getContent().length > 0) {
					// let's at least focus something in the Dialog that is TABBABLE
					var aTabbables = jQuery(":sapTabbable", this.$("cont"));
					if (aTabbables.length) {
						aTabbables[0].focus();
						this._bInitialFocusSet = true;
					} else {
						// if there is something in the content but isn't tabbable then
						// use the first fake element to focus
						var oFakeDomRef = jQuery.sap.domById(this._mParameters.firstFocusable);
						jQuery.sap.focus(oFakeDomRef);
						this._bInitialFocusSet = true;
					}
				}
			}
		};

		Dialog.prototype.handleOpened = function () {
			this.oPopup.detachEvent("opened", this.handleOpened, this);

			if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version === 11) {
				// a delayed call is needed for IE11. Since it fires the opened event before all stuff
				// is visible. All stuff is added to the DOM though and all operations can be done
				// but a focus seems to work (there is no error) but the focus can't be set to something
				// that isn't really visible
				jQuery.sap.clearDelayedCall(this._delayedCallId);
				this._delayedCallId = jQuery.sap.delayedCall(0, this, this._handleOpened);
			} else {
				this._handleOpened();
			}
		};

		/**
		 * Closes the dialog control instance.
		 *
		 * @type void
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		Dialog.prototype.close = function () {

			if (!this._bOpen) {
				return;
			}

			var oRect = this.$().rect();

			this._bOpen = false;
			this._bInitialFocusSet = false;
			if (this.oPopup.isOpen()) {
				this.oPopup.close(400);
			}

			// do this delayed or it possibly won't work because of popup closing animations
			jQuery.sap.delayedCall(400, this, "restorePreviousFocus");

			jQuery.each(oRect, function (key, val) {
				oRect[key] = parseInt(val, 10);
			});

			this._oRect = oRect;
		};

		Dialog.prototype.handleClosed = function () {
			this.oPopup.detachEvent("closed", this.handleClosed, this);

			this.fireClosed(this._oRect);
			this.close();

			// Make sure the dom content is not shown any more (in the static area)
			// This used to be this.$().hide() which keeps the current DOM in the static UIArea. This led to the
			// problem that control DOM with the same ID exists in two places if the control is added to a different
			// aggregation without the dialog being destroyed. In this special case the RichTextEditor renders a
			// textarea-element and afterwards tells the TinyMCE component which ID to use for rendering; since there
			// are two elements with the same ID at that point, it does not work.
			// As the Dialog can only contain other controls, we can safely discard the DOM - we cannot do this inside
			// the Popup, since it supports displaying arbitrary HTML content.
			this.$().remove();
		};

		/**
		 * restore the focus when the dialog was closed to the control which opened the dialog.
		 * This is independent of the dialogs modal state. The popup also restores focus when using modal popups/dialogs.
		 * @private
		 */
		Dialog.prototype.restorePreviousFocus = function () {
			Popup.applyFocusInfo(this._oPreviousFocus);
		};


		Dialog.prototype.setTitle = function (sText) {
			this.setProperty("title", sText, true); // last parameter avoids invalidation
			this.$("lbl").text(sText);
			return this;
		};

		/**
		 * Destroys this instance of dialog, called by Element#destroy()
		 * @private
		 */
		Dialog.prototype.exit = function () {
			// only fire the closed event if the dialog was open
			var bWasOpen = this.isOpen();
			this.close();

			// just to ensure that any attached event is being detached
			this.oPopup.detachEvent("opened", this.handleOpened, this);
			this.oPopup.detachEvent("closed", this.handleClosed, this);

			this.oPopup.destroy();
			if (bWasOpen) {
				this.fireClosed(this._oRect);
			}

			this.oPopup = null;
			jQuery.sap.clearDelayedCall(this._sDelayedCall);
			this._sDelayedCall = null;
			delete this._mParameters;
		};

		/**
		 * Checks whether the given sCssSize is an explicit value, or not (e.g. auto, inherit).
		 *
		 * @param {string} sCssSize The CSS string to check for being explicit value.
		 * @return {boolean} whether The given sCssSize is an explicit value, or not (e.g. auto, inherit).
		 * @private
		 */
		Dialog._isSizeSet = function (sCssSize) {
			return (sCssSize && !(sCssSize == "auto") && !(sCssSize == "inherit"));
		};

		/**
		 * Handles the sapescape event, triggers closing of the window.
		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.onsapescape = function (oEvent) {
			this.close();

			oEvent.preventDefault();
			oEvent.stopPropagation();
		};

		/**
		 * Handles the sapenter event, triggers the default button of the dialog.
		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.onsapenter = function (oEvent) {
			// See open-method
			var oFocusCtrl,
				sInitFocus = this.getDefaultButton();

			if (sInitFocus && (oFocusCtrl = sap.ui.getCore().byId(sInitFocus)) && jQuery.contains(this.getDomRef(),
					// trigger the default button if it exists and is inside the Dialog
					oFocusCtrl.getDomRef())) {
				// Okay, we have the control
				if (oFocusCtrl instanceof sap.ui.commons.Button) {
					oFocusCtrl.onclick(oEvent);
				}
			}

			oEvent.preventDefault();
			oEvent.stopPropagation();
		};

		/**
		 * Event handler for the focusin event.
		 * If it occurs on the focus handler elements at the beginning of the dialog, the focus is set to the end, and vice versa.
		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.onfocusin = function (oEvent) {
			this.sLastRelevantNavigation = null;

			if (!this._bInitialFocusSet) {
				// since IE9 calls first "onfocusin" it has to be checked if the initial focus was set already
				return;
			}

			this._mParameters.event = oEvent;
			this._mParameters.$FocusablesContent = jQuery(":sapTabbable", this.$("cont"));
			this._mParameters.$FocusablesFooter = jQuery(":sapTabbable", this.$("footer"));

			this.oPopup.focusTabChain(this._mParameters);
		};

		/**
		 * Restores the focus to the dialog after it has been moved or resized
		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.restoreFocus = function () {
			if (this.oRestoreFocusInfo && this.oPopup.bOpen) { // do not restore the focus if Dialog is no longer open
				var oCtrl = sap.ui.getCore().getControl(this.oRestoreFocusInfo.sFocusId);
				if (oCtrl) {
					oCtrl.applyFocusInfo(this.oRestoreFocusInfo.oFocusInfo);
				}
			}
		};

		/**
		 * Handles or cancels the selectstart event when occuring in parts of the dialog.
		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.onselectstart = function (oEvent) {
			if (!jQuery.sap.containsOrEquals(this.getDomRef("cont"), oEvent.target)) {
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		};

		/**
		 * Get minimal reasonable size of the dialog given its inner elements. Call is recommended after rendering.
		 *
		 * @return {Object} An object with inner structure {width:{int}, height:{int}}
		 * @private
		 */
		Dialog.prototype.getMinSize = function () {

			var oDialog = jQuery.sap.domById(this.sId),
				oTitle = jQuery.sap.domById(this.sId + "-hdr"),
				oFooter = jQuery.sap.domById(this.sId + "-footer"),
				heightTitle = 0,
				widthFooter = 0,
				heightFooter = 0;

			var oFooterBtns = jQuery(oFooter).children("DIV").get(0);
			widthFooter = oFooterBtns.offsetWidth;

			var addValue = 0;
			// add border and padding of footer...not margin
			addValue += jQuery(oFooter).outerWidth(false) - jQuery(oFooter).width();
			// add border and padding of footer...not margin
			addValue += jQuery(oDialog).outerWidth(false) - jQuery(oDialog).width();

			// if there is a too small specific border value add +20 for certainty to avoid wrapping
			if (addValue <= 20) {
				addValue = 20;
			}

			widthFooter += addValue;

			if (isNaN(widthFooter) || widthFooter < 100) {
				widthFooter = 100;
			}

			heightTitle = oTitle.offsetHeight;
			heightFooter = oFooter.offsetHeight;
			return {
				width: widthFooter,
				height: heightTitle + heightFooter + 36 /* min. height content */
			};
		};

		// store the original invalidate function
		Dialog.prototype.forceInvalidate = Control.prototype.invalidate;

		// stop propagating the invalidate to static UIArea before dialog is opened.
		// otherwise the open animation can't be seen
		// dialog will be rendered directly to static ui area when the open method is called.
		Dialog.prototype.invalidate = function (oOrigin) {
			if (this.oPopup && (this.oPopup.eOpenState !== "CLOSING" || this.isOpen())) {
				this.forceInvalidate(oOrigin);
			}
		};

		// Implementation of API method isOpen

		/**
		 * Returns whether the Dialog is open (this includes opening and closing animations). For more detailed information about the current state check Dialog.getOpenState().
		 *
		 * @type boolean
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		Dialog.prototype.isOpen = function () {
			return this.oPopup.isOpen();
		};

		// Implementation of API method isOpen

		/**
		 * Returns whether the Dialog is currently open, closed, or transitioning between these states.
		 *
		 * @type sap.ui.core.OpenState
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		Dialog.prototype.getOpenState = function () {
			return this.oPopup.getOpenState();
		};

		/**
		 * Whether the dialog is currently enabled or not.
		 *
		 * Applications can't control the enabled state via a property. A dialog is implicitly
		 * enabled depending on its <code>openState</code>. Descendant controls that honor the
		 * enabled state of their ancestors will appear disabled after the dialog is closed.
		 *
		 * @experimental Whether a dialog is regarded as "enabled" during the state transitions
		 * (OPENING, CLOSING) is not fully decided. Currently, it is enabled during the OPENING phase
		 * and disabled during the CLOSING phase. The only potential change would be to treat the
		 * OPENING phase as disabled as well. Applications should be prepared to receive events from
		 * "enabled" controls after they called open() on the dialog until close() is called on it.
		 * If the mentioned potential change should happen, the dialog will become enabled only
		 * after the transition to OPEN. Events from "enabled" children then can still only arrive
		 * between open() and close(), so applications that obey the previous rule should continue
		 * to work. Only end users or code  that explicitly triggers pseudo user events will notice
		 * a difference. <br>
		 * A second aspect that might change is the visual behavior of the content: during the CLOSING
		 * phase it 'looks' enabled but in fact it is already disabled. This avoids unnecessary redraws
		 * for content that becomes hidden soon. Should this show to be confusing for end users, it might
		 * be changed.
		 *
		 * @return {boolean} whether the dialog is currently enabled or not.
		 * @public
		 */
		Dialog.prototype.getEnabled = function () {
			var eState = this.getOpenState();
			// TODO the check for state OPENING is a compromise. Without that, the content of the dialog will render
			// in disabled state but will be enabled. As an alternative, the dialog could render again after OPEN is reached
			// and after switching to CLOSING (to properly reflect the changed enabled state in the descendants)
			return eState === sap.ui.core.OpenState.OPENING || eState === sap.ui.core.OpenState.OPEN;
		};

		// **************************************************
		// 'Legacy' Resize and Move handling including jQuery-UI parts for that would bring in 70k (uncompressed)
		// **************************************************

		/**
		 * Handles the dragstart event.
		 * In case of resize currently ongoing, this cancels the dragstart.
		 * @param {sap.ui.core.BroserEvent} oEvent The forwarded browser event
		 * @private
		 */
		Dialog.prototype.ondragstart = function (oEvent) {
			if (this.sDragMode == "resize" || this.sDragMode == "move") {
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		};

		/**
		 * Initializes drag and move capabilities.

		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.onmousedown = function (oEvent) {

			var oSource = oEvent.target,
				sId = this.getId();

			this._bRtlMode = sap.ui.getCore().getConfiguration().getRTL(); // remember the RTL mode for the starting resize operation

			if (jQuery.sap.containsOrEquals(this.getDomRef("hdr"), oSource)) {
				if (oSource.id != (sId + "-close")) {
					this.sDragMode = "move";
					this._RootWidth = this.getDomRef().offsetWidth;
					this._RootHeight = this.getDomRef().offsetHeight;
				}
			} else if (oSource.id == sId + "-grip") {
				this.sDragMode = "resize";

				// Now the dialog is fixed-width and fixed-height; write them to the element and adapt its classes to switch positioning
				var oDomRef = this.getDomRef();
				var sWidth = oDomRef.offsetWidth + "px";
				oDomRef.style.width = sWidth;
				var sHeight = oDomRef.offsetHeight + "px";
				oDomRef.style.height = sHeight;
				jQuery(oDomRef).removeClass("sapUiDlgFlexHeight sapUiDlgFlexWidth");
				// ...also remember the dimensions for the future (e.g. for after rerendering) - but do not cause rerendering now
				this.setProperty("width", sWidth, true);
				this.setProperty("height", sHeight, true);
			}

			if (this.sDragMode == null) {
				return;
			}

			// save current focused control for restoring later in restore focus
			var oActElement = document.activeElement;
			if (oActElement && oActElement.id) {
				var oCtrl = jQuery.sap.byId(oActElement.id).control(0);
				if (oCtrl) {
					this.oRestoreFocusInfo = {
						sFocusId: oCtrl.getId(),
						oFocusInfo: oCtrl.getFocusInfo()
					};
				}
			}

			// Calculate event X,Y coordinates
			this.startDragX = oEvent.screenX;
			this.startDragY = oEvent.screenY;

			this.originalRectangle = this.$().rect();

			jQuery(window.document).bind("selectstart", jQuery.proxy(this.ondragstart, this));
			jQuery(window.document).bind("mousemove", jQuery.proxy(this.handleMove, this));
			jQuery(window.document).bind("mouseup", jQuery.proxy(this.handleMouseUp, this));

			var outerDoc = Dialog._findSameDomainParentWinDoc();
			if (outerDoc) {
				jQuery(outerDoc).bind("selectstart", jQuery.proxy(this.ondragstart, this));
				jQuery(outerDoc).bind("mousemove", jQuery.proxy(this.handleMove, this));
				jQuery(outerDoc).bind("mouseup", jQuery.proxy(this.handleMouseUp, this));
			}

		};


		/**
		 * Returns the document of the parent window which is highest up in the hierarchy of parent windows, but still belongs
		 * to the same domain (so its document is accessible)
		 *
		 * @private
		 */
		Dialog._findSameDomainParentWinDoc = function () {
			var outerDoc = null;
			try {
				var win = window;
				while (win.parent && (win.parent != win)) {
					if (win.parent.document) {
						outerDoc = win.parent.document;
						win = win.parent;
					}
				}
			} catch (e) {
				// parent is in a different domain, so we cannot listen to mouse events there
				// outerWindow is now either null or the highest possible parent window (!= the document's window) in the same domain
			}
			return outerDoc;
		};


		/**
		 * Handles the move event taking the current dragMode into account.
		 * @param {DOMEvent} event The event raised by the browser.
		 * @private
		 */
		Dialog.prototype.handleMove = function (event) {

			if (!this.sDragMode) {
				return;
			}

			event = event || window.event;

			if (this.sDragMode == "resize") {

				var deltaX = event.screenX - this.startDragX;
				var deltaY = event.screenY - this.startDragY;

				var w = (this._bRtlMode ? this.originalRectangle.width - deltaX : this.originalRectangle.width + deltaX);
				var h = this.originalRectangle.height + deltaY;

				w = Math.max(w, this._minWidth);
				h = Math.max(h, this._minHeight);

				// The dimension constraints set via API could be in any CSS unit, so just set the size and do checks
				// (min/max override what was set here)
				var oDomRef = this.getDomRef();
				oDomRef.style.width = w + "px";
				oDomRef.style.height = h + "px";

				// Now use the actual size of the dialog, which might have been constrained by min-*/max-* for resizing the popup and the shadow
				w = this.getDomRef().offsetWidth;
				h = this.getDomRef().offsetHeight;

				// In IE8, style.width/height will still have the old values - possibly outside this Dialog's size constraints.
				// The Dialog box itself will stay correctly constrained, but its child elements will be positioned as if the style.width/height
				// values were the actual size, so for this browser - and to be cleaner - explicitly set these sizes. This is an IE8 bug.
				oDomRef.style.width = w + "px";
				oDomRef.style.height = h + "px";

				// Also remember the dimensions for the future (e.g. for after rerendering) - but do not cause rerendering now
				this.setProperty("width", w + "px", true);
				this.setProperty("height", h + "px", true);

			} else if (this.sDragMode == "move") {

				var iLeft = this.originalRectangle.left + event.screenX - this.startDragX;
				var iTop = this.originalRectangle.top + event.screenY - this.startDragY;

				iTop = Math.max(iTop, window.pageYOffset); // should not move the Dialog beyond the top border - otherwise it cannot be moved back
				if (this._bRtlMode || this._keepInWindow()) {
					iLeft = Math.min(iLeft, document.documentElement.clientWidth + window.pageXOffset - this._RootWidth); // in RTL mode, do not move beyond the right window border
				}
				if (!this._bRtlMode || this._keepInWindow()) {
					iLeft = Math.max(iLeft, 0); // in LTR mode do not move the Dialog beyond the left border
				}
				if (this._keepInWindow()) {
					iTop = Math.min(iTop, document.documentElement.clientHeight + window.pageYOffset - this._RootHeight);
				}

				this.oPopup.setPosition(Popup.Dock.LeftTop, {
					left: iLeft,
					top: iTop
				});
			}

			event.cancelBubble = true;
			return false;
		};

		/**
		 * This function checks if the "keepInWindow" property is set or if the Dialog is modal.
		 * Modal Dialogs mustn't not leave the window also.
		 *
		 * @returns {boolean} if the Dialog must leave the window area
		 * @private
		 */
		Dialog.prototype._keepInWindow = function () {
			return this.getKeepInWindow() || this.getModal();
		};


		/**
		 * Handle mouseup event.
		 * This does the cleanup after drag and move handling.
		 * @param {jQuery.EventObject} oEvent The event object
		 * @private
		 */
		Dialog.prototype.handleMouseUp = function (oEvent) {

			if (this.sDragMode == null) {
				return;
			}

			jQuery(window.document).unbind("selectstart", this.ondragstart);
			jQuery(window.document).unbind("mousemove", this.handleMove);
			jQuery(window.document).unbind("mouseup", this.handleMouseUp);

			var outerDoc = Dialog._findSameDomainParentWinDoc();
			if (outerDoc) {
				jQuery(outerDoc).unbind("selectstart", this.ondragstart);
				jQuery(outerDoc).unbind("mousemove", this.handleMove);
				jQuery(outerDoc).unbind("mouseup", this.handleMouseUp);
			}

			if (!!sap.ui.Device.browser.webkit) {
				//Force Webkit Browsers to do a repaint
				sap.ui.core.RenderManager.forceRepaint(this.getId());
			}

			// Set back focus to previously focused element
			this.restoreFocus();
			this.sDragMode = null;

		};

		Dialog.setAutoClose = function (bAutoclose) {
			this.oPopup.setAutoClose(bAutoclose);
		};
		Dialog.getAutoClose = function () {
			this.oPopup.getAutoClose();
		};


		return Dialog;

	}, /* bExport= */ true);

}; // end of sap/ui/commons/Dialog.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.DropdownBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.DropdownBox
jQuery.sap.declare('sap.ui.commons.DropdownBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/DropdownBoxRenderer",['jquery.sap.global', './ComboBoxRenderer'],
	function(jQuery, ComboBoxRenderer) {
	"use strict";


	/**
	 * DropdownBox renderer.
	 * @namespace
	 */
	var DropdownBoxRenderer = sap.ui.core.Renderer.extend(ComboBoxRenderer);
	
	/**
	 * Renders additional HTML for the DropdownBox to the TextField before the INPUT element (sets the icon)
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oDdb an object representation of the control that should be rendered
	 */
	DropdownBoxRenderer.renderOuterContentBefore = function(rm, oDdb){
	
		this.renderExpander(rm, oDdb);
	
	};
	
	/**
	 * Renders additional HTML for the DropdownBox to the TextField after the INPUT element (sets the select box)
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oDdb an object representation of the control that should be rendered
	 */
	DropdownBoxRenderer.renderOuterContent = function(rm, oDdb){
	
		this.renderSelectBox(rm, oDdb, '0');
	
	};
	
	/**
	 * Used to set the tabindex of the dropdownbox to -1
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oDdb an object representation of the control that should be rendered
	 */
	DropdownBoxRenderer.renderTextFieldEnabled = function(rm, oDdb) {
	
		if (oDdb.mobile) {
			rm.writeAttribute('tabindex', '-1');
		} else if (!oDdb.getEnabled()) {
			rm.writeAttribute('disabled', 'disabled');
			rm.writeAttribute('tabindex', '-1');
		} else if (!oDdb.getEditable()) {
			rm.writeAttribute('tabindex', '0');
		} else {
			rm.writeAttribute('tabindex', '0');
		}
	
	};
	
	/*
	 * Renders ARIA information for the dropdownbox (outer &lt;div&gt;)
	 * @param {sap.ui.fw.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oControl an object representation of the control that should be rendered
	 * @private
	 */
	DropdownBoxRenderer.renderARIAInfo = function(rm, oDdb) {
	
		var iPosInSet = -1;
		if (oDdb.getSelectedItemId()) {
			for ( var i = 0; i < oDdb.getItems().length; i++) {
				var oItem = oDdb.getItems()[i];
				if (oItem.getId() == oDdb.getSelectedItemId()) {
					iPosInSet =  i + 1;
					break;
				}
			}
		}
	
		var mProps = {
				autocomplete: "list",
				live: "polite",
				setsize: oDdb.getItems().length,
				posinset: (iPosInSet >= 0) ? iPosInSet : undefined
			};
	
		if (oDdb.getValueState() == sap.ui.core.ValueState.Error) {
			mProps["invalid"] = true;
		}
	
		rm.writeAccessibilityState(oDdb, mProps);
	
	};

	return DropdownBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/DropdownBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FileUploader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.FileUploader.
jQuery.sap.declare('sap.ui.commons.FileUploader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.FileUploader'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/FileUploader",['jquery.sap.global', './library', 'sap/ui/unified/FileUploader'],
	function(jQuery, library, UnifiedFileUploader) {
	"use strict";

	/**
	 * Constructor for a new FileUploader.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The framework generates an input field and a button with text "Browse ...". The API supports features such as on change uploads (the upload starts immediately after a file has been selected), file uploads with explicit calls, adjustable control sizes, text display after uploads, or tooltips containing complete file paths.
	 * @extends sap.ui.unified.FileUploader
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.21.0. 
	 * Please use the control sap.ui.unified.FileUploader of the library sap.ui.unified instead.
	 * @alias sap.ui.commons.FileUploader
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FileUploader = UnifiedFileUploader.extend("sap.ui.commons.FileUploader", /** @lends sap.ui.commons.FileUploader.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons"
	}});

	try {
		sap.ui.getCore().loadLibrary("sap.ui.unified");
	} catch (e) {
		jQuery.sap.log.error("The control 'sap.ui.commons.FileUploader' needs library 'sap.ui.unified'.");
		throw (e);
	}
	
	return FileUploader;

}, /* bExport= */ true);

}; // end of sap/ui/commons/FileUploader.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FileUploaderParameter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.FileUploaderParameter.
jQuery.sap.declare('sap.ui.commons.FileUploaderParameter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.FileUploaderParameter'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/FileUploaderParameter",['jquery.sap.global', './library', 'sap/ui/unified/FileUploaderParameter'],
	function(jQuery, library, UnifiedFileUploaderParameter) {
	"use strict";

	/**
	 * Constructor for a new FileUploaderParameter.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Represents a parameter for the FileUploader which is rendered as a hidden inputfield.
	 * @extends sap.ui.unified.FileUploaderParameter
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.21.0. 
	 * Please use the element sap.ui.unified.FileUploaderParameter of the library sap.ui.unified instead.
	 * @alias sap.ui.commons.FileUploaderParameter
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FileUploaderParameter = UnifiedFileUploaderParameter.extend("sap.ui.commons.FileUploaderParameter", /** @lends sap.ui.commons.FileUploaderParameter.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons"
	}});

	try {
		sap.ui.getCore().loadLibrary("sap.ui.unified");
	} catch (e) {
		jQuery.sap.log.error("The element 'sap.ui.commons.FileUploaderParameter' needs library 'sap.ui.unified'.");
		throw (e);
	}

	return FileUploaderParameter;

}, /* bExport= */ true);

}; // end of sap/ui/commons/FileUploaderParameter.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.FormattedTextView') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.FormattedTextView.
jQuery.sap.declare('sap.ui.commons.FormattedTextView'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/FormattedTextView",['jquery.sap.global', './library', 'sap/ui/core/Control', 'jquery.sap.encoder'],
	function(jQuery, library, Control/* , jQuerySap */) {
	"use strict";


	
	/**
	 * Constructor for a new FormattedTextView.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Allows to use a limited set of HTML tags for display
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.9.0
	 * @alias sap.ui.commons.FormattedTextView
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FormattedTextView = Control.extend("sap.ui.commons.FormattedTextView", /** @lends sap.ui.commons.FormattedTextView.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
			/**
			 * The ARIA role for the control.
			 */
			accessibleRole : {type : "sap.ui.core.AccessibleRole", group : "Accessibility", defaultValue : sap.ui.core.AccessibleRole.Document},
	
			/**
			 * Text with placeholders
			 */
			htmlText : {type : "string", group : "Misc", defaultValue : ""}
		},
		aggregations : {
	
			/**
			 * Array of controls that should be replaced within htmlText
			 */
			controls : {type : "sap.ui.commons.FormattedTextViewControl", multiple : true, singularName : "control"}
		}
	}});
	
	
	
	
	
	(function() {
		FormattedTextView.prototype.init = function() {
			this._aAllowedInterfaces = [];
			this._aAllowedInterfaces[0] = "sap.ui.commons.FormattedTextViewControl";
	
			/*
			 * these are the rules for the FormattedTextView
			 */
			this._ftv = {};
	
			// rules for the allowed attributes
			this._ftv.ATTRIBS = {
				'span::class' : 1,
				'div::class' : 1,
				'div::id' : 1,
				'span::id' : 1,
				'embed::data-index' : 1
			};
	
			// rules for the allowed tags
			this._ftv.ELEMENTS = {
				// Text Module Tags
				'abbr' : 1,
				'acronym' : 1,
				'address' : 1,
				'blockquote' : 1,
				'br' : 1,
				'cite' : 1,
				'code' : 1,
				'dfn' : 1,
				'div' : 1,
				'em' : 1,
				'h1' : 1,
				'h2' : 1,
				'h3' : 1,
				'h4' : 1,
				'h5' : 1,
				'h6' : 1,
				'kbd' : 1,
				'p' : 1,
				'pre' : 1,
				'q' : 1,
				'samp' : 1,
				'strong' : 1,
				'span' : 1,
				'var' : 1,
	
				// List Module Tags
				'dl' : 1,
				'dt' : 1,
				'dd' : 1,
				'ol' : 1,
				'ul' : 1,
				'li' : 1,
	
				// Special Tags
				// this is the placeholder for the controls
				'embed' : 1
	
			// TODO maybe add these tags (if someone really need this)
			// 'a' : 1, currently used via Link-Control
			// 'img' : 1, currently used via Image-Control
			};
		};
		FormattedTextView.prototype.exit = function() {
			delete this._aAllowedInterfaces;
	
			delete this._ftv;
		};
	
		FormattedTextView.prototype.hasControls = function() {
			var aControls = this.getAggregation("controls");
			if (aControls && aControls.length > 0) {
				return true;
			}
			return false;
		};
	
		/**
		 * Sanitizes attributes on an HTML tag.
		 *
		 * @private
		 * @param {string}
		 *            tagName An HTML tag name in lowercase.
		 * @param {Array.<?string>} attribs An array of alternating names and values.
		 * @return {Array.<?string>} The sanitized attributes as a list of
		 *         alternating names and values, where a null value means to omit
		 *         the attribute.
		 */
		var fnSanitizeAttribs = function(tagName, attribs) {
			for ( var i = 0; i < attribs.length; i += 2) {
				// attribs[i] is the name of the tag's attribute.
				// attribs[i+1] is its corresponding value.
				// (i.e. <span class="foo"> -> attribs[i] = "class" | attribs[i+1] =
				// "foo")
	
				var sAttribKey = tagName + "::" + attribs[i];
	
				if (this._ftv.ATTRIBS[sAttribKey]) {
					// keep the value of this class
					if (tagName === "embed") {
						var intPattern = /^[0-9]*$/;
						if (!attribs[i + 1].match(intPattern)) {
							// attribs[i + 1] = null;
							return null;
						}
					}
				} else {
					var sWarning = '<' + tagName + '> with attribute [' + attribs[i] + '="' + attribs[i + 1] + '"] is not allowed and cut';
					jQuery.sap.log.warning(sWarning, this);
	
					// to remove this attribute by the sanitizer the value has to be
					// set to null
					attribs[i + 1] = null;
				}
	
			}
			return attribs;
		};
	
		/**
		 * Sanitizes HTML tags and attributes according to a given policy.
		 *
		 * @private
		 * @param {string}
		 *            inputHtml The HTML to sanitize.
		 * @param {function(string,string[])} tagPolicy A function that decides which
		 *            tags to accept and sanitizes their attributes (see
		 *            makeHtmlSanitizer above for details).
		 * @return {string} The sanitized HTML.
		 */
		var fnPolicy = function(tagName, attribs) {
			if (this._ftv.ELEMENTS[tagName]) {
				var proxiedSanatizedAttribs = jQuery.proxy(fnSanitizeAttribs, this);
				return proxiedSanatizedAttribs(tagName, attribs);
			} else {
				var sWarning = '<' + tagName + '> is not allowed and cut (and its content)';
				jQuery.sap.log.warning(sWarning, this);
			}
		};
	
		FormattedTextView.prototype.setHtmlText = function(sText) {
			var sSanitizedText = "";
	
			// use a proxy for policy to access the control's private variables
			var fnProxiedPolicy = jQuery.proxy(fnPolicy, this);
	
			// using the sanitizer that is already set to the encoder
			sSanitizedText = jQuery.sap._sanitizeHTML(sText, {
				tagPolicy : fnProxiedPolicy
			});
	
			this.setProperty("htmlText", sSanitizedText);
		};
	
		var fnSetControls = function(aControls, oThis) {
			if (oThis.hasControls()) {
				oThis.removeAllAggregation("controls");
			}
	
			var bIsArray = jQuery.isArray(aControls);
			if (bIsArray && aControls.length > 0) {
				// iterate through the given array but suppress invalidate
				for ( var i = 0; i < aControls.length; i++) {
					oThis.addAggregation("controls", aControls[i], true);
				}
				oThis.invalidate();
			}
		};
	

		/**
		 * Sets text with placeholders and given array of controls
		 *
		 * @param {string} sHtmlText
		 *         Contains the corresponding HTML-text
		 * @param {sap.ui.commons.FormattedTextViewControl} oControls
		 *         Array of controls that should be used within given HTML-text
		 * @type void
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		FormattedTextView.prototype.setContent = function(sHtmlText, aControls) {
			// set the text using existing checks and method
			this.setHtmlText(sHtmlText);
	
			// validate and set content of controls corresponding to given HTML-text
			// with place holders
			fnSetControls(aControls, this);
		};
	}());

	return FormattedTextView;

}, /* bExport= */ true);

}; // end of sap/ui/commons/FormattedTextView.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.HorizontalDivider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.HorizontalDivider.
jQuery.sap.declare('sap.ui.commons.HorizontalDivider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/HorizontalDivider",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new HorizontalDivider.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Divides the screen in visual areas.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.HorizontalDivider
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var HorizontalDivider = Control.extend("sap.ui.commons.HorizontalDivider", /** @lends sap.ui.commons.HorizontalDivider.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
			/**
			 * Defines the width of the divider.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '100%'},
	
			/**
			 * Defines the type of the divider.
			 */
			type : {type : "sap.ui.commons.HorizontalDividerType", group : "Appearance", defaultValue : sap.ui.commons.HorizontalDividerType.Area},
	
			/**
			 * Defines the height of the divider.
			 */
			height : {type : "sap.ui.commons.HorizontalDividerHeight", group : "Appearance", defaultValue : sap.ui.commons.HorizontalDividerHeight.Medium}
		}
	}});
	
	// No Behaviour

	return HorizontalDivider;

}, /* bExport= */ true);

}; // end of sap/ui/commons/HorizontalDivider.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Image') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Image.
jQuery.sap.declare('sap.ui.commons.Image'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Image",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new Image.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A wrapper around the IMG tag. The image can be loaded from a remote or local server.
	 * There are various size setting options available, and the images can be combined with actions.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.commons.ToolbarItem,sap.ui.commons.FormattedTextViewControl
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Image
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Image = Control.extend("sap.ui.commons.Image", /** @lends sap.ui.commons.Image.prototype */ { metadata : {
	
		interfaces : [
			"sap.ui.commons.ToolbarItem",
			"sap.ui.commons.FormattedTextViewControl"
		],
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Relative or absolute path to URL where the image file is stored.
			 */
			src : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
	
			/**
			 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the overall size is maintained then, considering the aspect ratio.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
	
			/**
			 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the overall size is maintained then, considering the aspect ratio.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
	
			/**
			 * A decorative image is included for design reasons. Accessibility tools will ignore decorative images.
			 * Note: If the Image has an image map (useMap is set), this property will be overridden (the image will not be rendered as decorative).
			 * A decorative image has no ALT attribute, so the Alt property is ignored if the image is decorative.
			 */
			decorative : {type : "boolean", group : "Accessibility", defaultValue : true},
	
			/**
			 * The alternative text that is displayed in case the Image is not available, or cannot be displayed.
			 * If the image is set to decorative this property is ignored.
			 */
			alt : {type : "string", group : "Accessibility", defaultValue : null},
	
			/**
			 * The name of the image map that defines the clickable areas
			 */
			useMap : {type : "string", group : "Misc", defaultValue : null}
		},
		events : {
	
			/**
			 * Event is fired when the user clicks on the control.
			 */
			press : {}
		}
	}});
	
	/**
	 * Function is called when image is clicked.
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Image.prototype.onclick = function(oEvent) {
		this.firePress({/* no parameters */});
	};
	
	/**
	 * Function is called when "enter" keydown happens on image.
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Image.prototype.onsapenter = Image.prototype.onclick;
	

	return Image;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Image.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ImageMap') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ImageMap.
jQuery.sap.declare('sap.ui.commons.ImageMap'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ImageMap",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation'],
	function(jQuery, library, Control, ItemNavigation) {
	"use strict";


	
	/**
	 * Constructor for a new ImageMap.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Combination of image areas where at runtime these areas are starting points for hyperlinks or actions
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ImageMap
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ImageMap = Control.extend("sap.ui.commons.ImageMap", /** @lends sap.ui.commons.ImageMap.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Name for the image that serves as reference
			 */
			name : {type : "string", group : "Misc", defaultValue : null}
		},
		aggregations : {
	
			/**
			 * Area representing the reference to the target location
			 */
			areas : {type : "sap.ui.commons.Area", multiple : true, singularName : "area"}
		},
		events : {
	
			/**
			 * Event for the areas that can be clicked in an ImageMap
			 */
			press : {
				parameters : {
	
					/**
					 * Id of clicked Area.
					 */
					areaId : {type : "string"}
				}
			}
		}
	}});
	
	
	/**
	 * Adds areas to the Image Map. 
	 * 
	 * Each argument must be either a JSon object or a list of objects or the area element or elements.
	 *
	 * @param {any} content Area content to add 
	 * @return {sap.ui.commons.ImageMap} <code>this</code> to allow method chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ImageMap.prototype.createArea = function() {
		var oArea = new sap.ui.commons.Area();
	
		for ( var i = 0; i < arguments.length; i++) {
			var oContent = arguments[i];
			var oArea;
			if (oContent instanceof sap.ui.commons.Area) {
				oArea = oContent;
			} else {
				oArea = new sap.ui.commons.Area(oContent);
			}
			this.addArea(oArea);
		}
		return this;
	};
	
	/**
	 * Used for after-rendering initialization.
	 *
	 * @private
	 */
	ImageMap.prototype.onAfterRendering = function() {
	
		this.oDomRef = this.getDomRef();
	
		// Initialize the ItemNavigation if does not exist yet
		if (!this.oItemNavigation) {
			this.oItemNavigation = new ItemNavigation();
		}
	
		if (!!sap.ui.Device.browser.internet_explorer) {
	
			var that = this;
			var aImageControls = [];
			this.oItemNavigation.setTabIndex0();
	
			// Find the Image control and add delegate to it
			var $Images = jQuery("img[useMap=#" + this.getName() + "]");
			$Images.each(function(i, image) {
				var id = image.getAttribute("id");
				var imageControl = sap.ui.getCore().byId(id);
				imageControl.addDelegate(that.oItemNavigation);
				that.oItemNavigation.setRootDomRef(image);
				aImageControls.push(imageControl);
			});
	
			this.aImageControls = aImageControls;
		} else {
	
			this.addDelegate(this.oItemNavigation);
			this.oItemNavigation.setRootDomRef(this.oDomRef);
		}
	
		// Set navigations items = Areas inside of Image map
		var aItemDomRefs = [];
		var aAllAreas = this.getAreas();
		for ( var i = 0; i < aAllAreas.length; i++) {
			var oDomRef = aAllAreas[i].getFocusDomRef();
			if (oDomRef) { // separators return null here
				aItemDomRefs.push(oDomRef);
			}
		}
	
		this.oItemNavigation.setItemDomRefs(aItemDomRefs);
		this.oItemNavigation.setCycling(true);
		this.oItemNavigation.setSelectedIndex( -1);
		this.oItemNavigation.setFocusedIndex( -1);
	
	};
	
	/**
	 * Does all the cleanup when the Image Map is to be destroyed. Called from the
	 * element's destroy() method.
	 *
	 * @private
	 */
	ImageMap.prototype.exit = function() {
		// Remove the item navigation delegate
		if (this.oItemNavigation) {
			if (!!sap.ui.Device.browser.internet_explorer) {
				for ( var i = 0; i < this.aImageControls.length; i++) {
					this.aImageControls[i].removeDelegate(this.oItemNavigation);
				}
			} else {
				this.removeDelegate(this.oItemNavigation);
			}
			this.oItemNavigation.destroy();
			delete this.oItemNavigation;
		}
	
		// No super.exit() to call
	};

	return ImageMap;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ImageMap.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Label') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Label.
jQuery.sap.declare('sap.ui.commons.Label'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.LabelEnablement'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Label",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup', 'sap/ui/core/LabelEnablement'],
	function(jQuery, library, Control, Popup, LabelEnablement) {
	"use strict";


	
	/**
	 * Constructor for a new Label.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * 
	 * Is used for labeling other controls. The API provides formatting options, for example for bold display or alignment. A label can have an icon.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.commons.ToolbarItem,sap.ui.core.Label
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Label
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Label = Control.extend("sap.ui.commons.Label", /** @lends sap.ui.commons.Label.prototype */ { metadata : {
	
		interfaces : [
			"sap.ui.commons.ToolbarItem",
			"sap.ui.core.Label"
		],
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * 
			 * Labels can have bold format.
			 */
			design : {type : "sap.ui.commons.LabelDesign", group : "Appearance", defaultValue : sap.ui.commons.LabelDesign.Standard},
	
			/**
			 * 
			 * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction from its parent container.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
	
			/**
			 * Specifies whether a line wrapping shall be displayed when the text value is longer than the width
			 */
			wrapping : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * 
			 * Control width as common CSS-size (px or % as unit, for example).
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
	
			/**
			 * 
			 * Text to be displayed.
			 */
			text : {type : "string", group : "Misc", defaultValue : ''},
	
			/**
			 * Icon to be displayed in the control.
			 * This can be an URI to an image or an icon font URI.
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
	
			/**
			 * 
			 * Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
			 */
			textAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
	
			/**
			 * Allows to enforce the required indicator even when the associated control doesn't have a getRequired method (a required property) or when the flag is not set.
			 * If the associated control has a required property, the values of both required flags are combined with the OR operator, so a Label can't override a required=true value.
			 * @since 1.11.0
			 */
			required : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * If set the required indicator is at the begin of the label, if not set at the end.
			 * @since 1.14.0
			 */
			requiredAtBegin : {type : "boolean", group : "Misc", defaultValue : null}
		},
		associations : {
	
			/**
			 * Association to the labeled control.
			 * By default the label set the for attribute to the ID of the labeled control. This can be changed implementing function getIdForLabel on the labelled control.
			 */
			labelFor : {type : "sap.ui.core.Control", multiple : false}
		}
	}});
	
	Label.prototype.onAfterRendering = function () {
	
		var oFor = this._getLabeledControl();
		
		if (oFor) {
			if (this.getTooltip_AsString() == "" || !(this.getTooltip() instanceof sap.ui.core.TooltipBase)) {
				// no own tooltip use RichTooltip of labeled control if available
				if (oFor.getTooltip() instanceof sap.ui.core.TooltipBase) {
					this.oForTooltip = oFor.getTooltip();
					this.addDelegate(this.oForTooltip);
				}
			}

			// attach to change of required flag of labeled control
			oFor.attachEvent("requiredChanged",this._handleRequiredChanged, this);
			this._oFor = oFor;
		}
	
	};
	
	Label.prototype.onBeforeRendering = function () {
	
		if (this.oForTooltip) {
			this.removeDelegate(this.oForTooltip);
			this.oForTooltip = null;
		}
	
		if (this._oPopup) {
			this._oPopup.destroy();
			delete this._oPopup;
		}
	
		if (this._oFor) {
			this._oFor.detachEvent("requiredChanged",this._handleRequiredChanged, this);
			this._oFor = undefined;
		}
	
	};
	
	Label.prototype.exit = function(){
	
		if (this.oForTooltip) {
			this.removeDelegate(this.oForTooltip);
			this.oForTooltip = null;
		}
	
		if (this._oPopup) {
			this._oPopup.destroy();
			delete this._oPopup;
		}
	
		if (this._oFor) {
			this._oFor.detachEvent("requiredChanged",this._handleRequiredChanged, this);
			this._oFor = undefined;
		}
	
	};
	
	/**
	 * Checks whether either the label itself or the associated control is marked as required.
	 */
	Label.prototype.isRequired = function(){
	
		// the value of the local required flag is ORed with the result of a "getRequired" 
		// method of the associated "labelFor" control. If the associated control doesn't 
		// have a getRequired method, this is treated like a return value of "false".
		var oFor = this._getLabeledControl();
		return this.getRequired() || (oFor && oFor.getRequired && oFor.getRequired() === true);
	
	};
	
	/*
	 * if required flag of labeled control changes after Label is rendered,
	 * Label must be rendered again
	 */
	Label.prototype._handleRequiredChanged = function(){
	
		this.invalidate();
	
	};
	
	/**
	 * @deprecated
	 */
	Label.prototype.setReqiuredAtBegin = function(bReqiuredAtBegin){
		return this.setRequiredAtBegin(bReqiuredAtBegin);
	};
	
	/**
	 * @deprecated
	 */
	Label.prototype.getReqiuredAtBegin = function(){
		return this.getRequiredAtBegin();
	};
	
	/**
	 * Returns the labeled control instance, if exists.
	 * @return {sap.ui.core.Control} the labeled control instance, if exists
	 * @private
	 */
	Label.prototype._getLabeledControl = function() {
		var sId = this.getLabelForRendering();
		if (!sId) {
			return null;
		}
		return sap.ui.getCore().byId(sId);
	};
	
	
	/*
	sap.ui.commons.Label.prototype.onmouseover = function(oEvent) {
		var oRef = this.getDomRef();
		if (Math.abs(oRef.clientWidth - oRef.scrollWidth) < 2){
			return;
		}
	
		if (!this._oPopup) {
			 this._oPopup = new sap.ui.core.Popup();
			 this._oPopup.setDurations(0, 0); // no animations
			 this._oPopup.setContent(this._createInfo());
			 this._oPopup.attachOpened(this._handleOpened, this);
		}
	
		var eDock = sap.ui.core.Popup.Dock;
		this._oPopup.open(0, eDock.BeginTop, eDock.BeginTop, this, "0 1", "fit", true);
	};
	
	sap.ui.commons.Label.prototype._createInfo = function(){
		var $Me   = jQuery(this.getDomRef());
		var sText = $Me.html();
		var sHtml = "<span id='" + this.getId()+'-info' + "' class='sapUiLblInfo " + $Me.attr("class") + "'>" + sText + "</span>";
	
		var oDomRef = jQuery(sHtml).appendTo(sap.ui.getCore().getStaticAreaRef());
		var that = this;
		jQuery(oDomRef).mouseout([this.getId()], function(oEvent){
			that._oPopup.close();
		});
		return oDomRef;
	};
	
	sap.ui.commons.Label.prototype._handleOpened = function(){
		var that = this;
		jQuery.sap.byId(this.getId()+'-info').mouseout([this.getId()], function(oEvent){
			that._oPopup.close();
		});
	};*/
	
	//Enrich Label functionality
	LabelEnablement.enrich(Label.prototype);

	return Label;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Label.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Link') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Link.
jQuery.sap.declare('sap.ui.commons.Link'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Link",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/EnabledPropagator'],
	function(jQuery, library, Control, EnabledPropagator) {
	"use strict";


	
	/**
	 * Constructor for a new Link.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * 
	 * Provides an absolute or relative reference to an internal or external URL. The classical target parameters are supported.
	 * Another usage scenario is triggering an action, for example to open a popup window. In both cases, the link is a hypertext link.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.commons.ToolbarItem,sap.ui.commons.FormattedTextViewControl
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Link
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Link = Control.extend("sap.ui.commons.Link", /** @lends sap.ui.commons.Link.prototype */ { metadata : {
	
		interfaces : [
			"sap.ui.commons.ToolbarItem",
			"sap.ui.commons.FormattedTextViewControl"
		],
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * 
			 * Link text to be displayed.
			 */
			text : {type : "string", group : "Appearance", defaultValue : ''},
	
			/**
			 * Whether the link can be triggered by the user.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * 
			 * Unique identifier used for help service.
			 */
			helpId : {type : "string", group : "Behavior", defaultValue : ''},
	
			/**
			 * The link target URI. Supports standard hyperlink behavior. If an action should be triggered, this should not be set, but instead an event handler for the "press" event should be registered.
			 */
			href : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
	
			/**
			 * 
			 * Options are _self, _top, _blank, _parent, _search. Alternatively, a frame name can be entered.
			 */
			target : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Width of text link. When it is set (CSS-size such as % or px), this is the exact size. When left blank, the text defines the size.
			 * @since 1.8.0
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null}
		},
		associations : {
	
			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
	
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {
	
			/**
			 * 
			 * Event is fired when the user clicks the control.
			 */
			press : {allowPreventDefault : true}
		}
	}});
	
	
	/**
	 * Puts the focus to the link.
	 *
	 * @name sap.ui.commons.Link#focus
	 * @function
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	
	
	EnabledPropagator.call(Link.prototype);
	
	/**
	 * Also trigger link activation when space is pressed on the focused control
	 */
	Link.prototype.onsapspace = function(oEvent) {
		Link.prototype.onclick.apply(this, arguments);
	};
	
	/**
	 * Function is called when Link is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Link.prototype.onclick = function(oEvent) {
		if (this.getEnabled()) {
			// the default behavior will be supressed, when oEvent.preventDefault() is 
			// called or when the link doesn't contain a valid href (javascript:void(0)).
			// The last thing will trigger the onbeforeunload event in IE when not 
			// preventing the default behavior
			if (!this.firePress() || !this.getHref()) {
				oEvent.preventDefault();
			}
		} else {
			oEvent.preventDefault();
		}
	};
	
	/**
	 * The Link handles the enter by itself
	 * @since 1.16.2
	 */
	Link.prototype.onsapenter = function(oEvent) {
		oEvent.stopPropagation();
	};

	return Link;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Link.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ListBox') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ListBox.
jQuery.sap.declare('sap.ui.commons.ListBox'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.strings'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ListBox",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/IconPool', 'sap/ui/core/delegate/ItemNavigation', 'jquery.sap.strings'],
	function(jQuery, library, Control, IconPool, ItemNavigation/* , jQuerySap */) {
	"use strict";



	/**
	 * Constructor for a new ListBox.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Provides a list of items from which users can choose an item. For the design of the list box, features such as defining the list box height,
	 * fixing the number of visible items, choosing one item to be the item that is marked by default when the list box is shown, or a scroll bar for large list boxes
	 * are available.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ListBox
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ListBox = Control.extend("sap.ui.commons.ListBox", /** @lends sap.ui.commons.ListBox.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Value "true" makes the list box interactive.
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Disabled controls have another color display depending on custom settings.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Specifies whether multiple selection is allowed.
			 */
			allowMultiSelect : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Control width as common CSS-size (px or % as unit, for example).
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * Control height as common CSS-size (px or % as unit, for example).
			 * The setting overrides any definitions made for the setVisibleItems() method.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * Scroll bar position from the top. Setting the scrollTop property and calling scrollToIndex are two operations influencing the same "physical" property, so the last call "wins".
			 */
			scrollTop : {type : "int", group : "Behavior", defaultValue : -1},

			/**
			 * Defines whether the icons of the list items shall also be displayed. Enabling icons requires some space to be reserved for them. Displaying icons can also
			 * influence the width and height of a single item, which affects the overall height of the ListBox when defined in number of items.
			 * Note that the number of icons that can be displayed in the ListBox depends on the size of the icons themselves and of the total ListBox height.
			 */
			displayIcons : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Specifies whether the text values from the additionalText property (see sap.ui.core.ListItems) shall be displayed.
			 */
			displaySecondaryValues : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * The text alignment in the primary ListBox column.
			 */
			valueTextAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},

			/**
			 * The text alignment in the secondary ListBox text column (if available).
			 */
			secondaryValueTextAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},

			/**
			 * The minimum width of the ListBox. If not set, there is no minimum width.
			 */
			minWidth : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * The maximum width of the ListBox. If not set, there is no maximum width.
			 */
			maxWidth : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * The ListBox height in number of items that are initially displayed without scrolling. This setting overwrites height
			 * settings in terms of CSS size that have been made. When the items have different heights, the height of the first item is used for all
			 * other item height calculations. Note that if there are one or more separators between the visible ListBox items, the displayed items
			 * might not relate 1:1 to the initially specified number of items. When the value is retrieved, it equals the previously set value if it was set;
			 * otherwise, it will be the number of items completely fitting into the ListBox without scrolling in the case the control was already rendered.
			 * Note that if the control was not rendered, the behavior will be undefined, it may return -1 or any other number.
			 */
			visibleItems : {type : "int", group : "Dimension", defaultValue : null}
		},
		defaultAggregation : "items",
		aggregations : {

			/**
			 * Aggregation of items to be displayed. Must be either of type sap.ui.core.ListItem or sap.ui.core.SeparatorItem.
			 */
			items : {type : "sap.ui.core.Item", multiple : true, singularName : "item"}
		},
		associations : {

			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"},

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {

			/**
			 * Event is fired when selection is changed by user interaction.
			 */
			select : {
				parameters : {

					/**
					 * ID of the ListBox which triggered the event.
					 */
					id : {type : "string"},

					/**
					 * The currently selected index of the ListBox. In the case of multiple selection, this is exactly one of the selected indices - the one whose selection has triggered the selection change; to get all currently selected indices, use selectedIndices.
					 */
					selectedIndex : {type : "int"},

					/**
					 * The currently selected item of the ListBox. In the case of multiple selection, this is exactly one of the selected items - the one whose selection has triggered the selection change.
					 */
					selectedItem : {type : "sap.ui.core.Item"},

					/**
					 * Array containing the indices which are selected.
					 */
					selectedIndices : {type : "int[]"}
				}
			}
		}
	}});


	/**
	 * Initializes the ListBox control
	 * @private
	 */
	ListBox.prototype.init = function () {
		this.allowTextSelection(false);
		if (!this._bHeightInItems) { // otherwise setVisibleItems was already called by the JSON constructor
			this._bHeightInItems = false; // decides whether the height is set as CSS size (height is in height property then) or in multiples of an item height (height is in this._iVisibleItems then)
			this._iVisibleItems = -1;     // initially -1, this subsequently must be the number of items that are visible without scrolling; the value is either set directly if the height is given in items, or calculated in onAfterRendering
		}
		this._sTotalHeight = null;    // if height is set in items, this contains the
		if (ListBox._fItemHeight === undefined) {
			ListBox._fItemHeight = -1;
		}
		if (ListBox._iBordersAndStuff === undefined) {
			ListBox._iBordersAndStuff = -1;
		}

		this._aSelectionMap = [];
		this._iLastDirectlySelectedIndex = -1;

		//FIXME Mapping from activeItems index to the id of it for item navigation purposes
		this._aActiveItems = null;
	};


	/**
	 * Re-initializes the ListBox, so all sizes are fine after a theme switch
	 * @private
	 */
	ListBox.prototype.onThemeChanged = function () {
		ListBox._fItemHeight = -1;
		ListBox._iBordersAndStuff = -1;
		this._sTotalHeight = null;
		if (!this._bHeightInItems) {
			this._iVisibleItems = -1; // re-calculation only required for ItemNavigation - shouldn't change when explicitly set
		}
		this._skipStoreScrollTop = true; // Skip remembering the scrolltop in next onBeforeRendering due to theme change
		if (this.getDomRef()) {
			this.invalidate();
		}
	};


	/**
	 * Called before rendering. Required for storing the scroll position.
	 * @private
	 */
	ListBox.prototype.onBeforeRendering = function () {
		if (this._skipStoreScrollTop) {
			delete this._skipStoreScrollTop;
			return;
		}

		this.getScrollTop(); // store current ScrollTop
		// TODO: store focus??
	};


	/**
	 * Called after rendering. Required for calculating and setting the correct heights.
	 * @private
	 */
	ListBox.prototype.onAfterRendering = function () {
		var oDomRef = this.getDomRef();

		// calculate item height
		if (ListBox._fItemHeight <= 0) { // TODO: merge with width measurement which is currently in renderer

			// create dummy ListBox with dummy item
			var oStaticArea = sap.ui.getCore().getStaticAreaRef();
			var div = document.createElement("div");
			div.id = "sap-ui-commons-ListBox-sizeDummy";
			div.innerHTML = '<div class="sapUiLbx sapUiLbxFlexWidth sapUiLbxStd"><ul><li class="sapUiLbxI"><span class="sapUiLbxITxt">&nbsp;</span></li></ul></div>';
			if (sap.ui.Device.browser.safari) {
				oStaticArea.insertBefore(div, oStaticArea.firstChild);
			} else {
				oStaticArea.appendChild(div);
			}
			var oItemDomRef = div.firstChild.firstChild.firstChild;
			ListBox._fItemHeight = oItemDomRef.offsetHeight;

			// subpixel rendering strategy in IE >= 9 can lead to the total being larger than the sum of heights
			if (!!sap.ui.Device.browser.internet_explorer && (document.documentMode == 9 || document.documentMode == 10)) { // TODO: browser version check... not good...
				var cs = document.defaultView.getComputedStyle(oItemDomRef.firstChild, "");
				var h = parseFloat(cs.getPropertyValue("height").split("px")[0]);
				if (!(typeof h === "number") || !(h > 0)) { // sometimes cs.getPropertyValue("height") seems to return "auto"
					h = jQuery(oItemDomRef.firstChild).height();
				}
				var pt = parseFloat(cs.getPropertyValue("padding-top").split("px")[0]);
				var pb = parseFloat(cs.getPropertyValue("padding-bottom").split("px")[0]);
				var bt = parseFloat(cs.getPropertyValue("border-top-width").split("px")[0]);
				var bb = parseFloat(cs.getPropertyValue("border-bottom-width").split("px")[0]);
				ListBox._fItemHeight = h + pt + pb + bt + bb;
			}

			// remove the dummy
			oStaticArea.removeChild(div);
		}

		// calculate height of ListBox borders and padding
		if (ListBox._iBordersAndStuff == -1) {
			var $DomRef = jQuery(this.getDomRef());
			var outerHeight = $DomRef.outerHeight();
			var innerHeight = $DomRef.height();
			ListBox._iBordersAndStuff = outerHeight - innerHeight;
		}

		// Height is set in number of visible items
		if (this._bHeightInItems) {
			if (this._sTotalHeight == null) {
				//...but the height needs to be calculated first
				this._calcTotalHeight(); // TODO: verify this._sTotalHeight is > 0

				// now set height
				oDomRef.style.height = this._sTotalHeight;
			} // else height was already set in the renderer!
		}

		// find out how many items are visible because the ItemNavigation needs to know
		if (this._iVisibleItems == -1) {
			this._updatePageSize();
		}

		// Collect items for ItemNavigation   TODO: make it cleaner
		var oFocusRef = this.getFocusDomRef(),
				aRows = oFocusRef.childNodes,
				aDomRefs = [],
				aItems = this.getItems();
		this._aActiveItems = [];
		var aActiveItems = this._aActiveItems;
		for (var i = 0; i < aRows.length; i++) {
			if (!(aItems[i] instanceof sap.ui.core.SeparatorItem)) {
				aActiveItems[aDomRefs.length] = i;
				aDomRefs.push(aRows[i]);
			}
		}

		// init ItemNavigation
		if (!this.oItemNavigation) {
			var bNotInTabChain = (!this.getEnabled() || !this.getEditable());
			this.oItemNavigation = new ItemNavigation(null, null, bNotInTabChain);
			this.oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, this._handleAfterFocus, this);
			this.addDelegate(this.oItemNavigation);
		}
		this.oItemNavigation.setRootDomRef(oFocusRef);
		this.oItemNavigation.setItemDomRefs(aDomRefs);
		this.oItemNavigation.setCycling(false);
		this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(this.getSelectedIndex()));
		this.oItemNavigation.setPageSize(this._iVisibleItems); // Page down by number of visible items

		// Apply scrollTop


		// if scrolling to a certain item index is currently requested (but was not done because the control was not rendered before), do it now
		if (this.oScrollToIndexRequest) {
			this.scrollToIndex(this.oScrollToIndexRequest.iIndex, this.oScrollToIndexRequest.bLazy); // keep the oScrollToIndexRequest for the timeouted call
		} else {
			var scrollTop = this.getProperty("scrollTop");
			if (scrollTop > -1) {
				oDomRef.scrollTop = scrollTop;
			}
		}

		// sometimes this did not work, so repeat it after a timeout (consciously done twice, yes)
		var that = this;
		window.setTimeout(function() { // needs to be delayed because in Firefox sometimes the scrolling seems to come too early
			// if scrolling to a certain item index is currently requested (but was not done because the control was not rendered before), do it now
			if (that.oScrollToIndexRequest) {
				that.scrollToIndex(that.oScrollToIndexRequest.iIndex, that.oScrollToIndexRequest.bLazy);
				that.oScrollToIndexRequest = null;
			} else {
				var scrollTop = that.getProperty("scrollTop");
				if (scrollTop > -1) {
					oDomRef.scrollTop = scrollTop;
				}
			}
		}, 0);
	};


	/**
	 * For the given iIndex, this method calculates the index of the respective item within the ItemNavigation set.
	 * (if there are separators, the ItemNavigation does not know them)
	 * Prerequisite: the iIndex points to an element which is NOT a Separator or disabled (= it must be known to the ItemNavigation)
	 * @private
	 */
	ListBox.prototype._getNavigationIndexForRealIndex = function(iIndex) {
		var aItems = this.getItems();
		var iNavIndex = iIndex;
		for (var i = 0; i < iIndex; i++) {
			if (aItems[i] instanceof sap.ui.core.SeparatorItem) {
				iNavIndex--;
			}
		}
		return iNavIndex;
	};


	/**
	 * Calculates the number of visible items. Must happen after rendering and whenever the height is changed without rerendering.
	 * @private
	 */
	ListBox.prototype._updatePageSize = function() {
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			if (ListBox._fItemHeight > 0) {
				this._iVisibleItems = Math.floor(oDomRef.clientHeight / ListBox._fItemHeight);
			} // else shouldn't happen
		}
		// else: nothing to do, item navigation will be initialized after rendering
	};

	/*
	 * Scrolls the item with the given index into view, preferably at the topmost position.
	 */

	/**
	 * If the ListBox has a scroll bar because the number of items is larger than the number of visible items, this method scrolls to the item with the given index. If there are enough items, this item will then appear at the topmost visible position in the ListBox. If bLazy is true, it only scrolls as far as required to make the item visible.
	 * Setting the scrollTop property and calling scrollToIndex are two operations influencing the same "physical" property, so the last call "wins".
	 *
	 * @param {int} iIndex
	 *         The index to which the ListBox should scroll.
	 * @param {boolean} bLazy
	 *         If set to true, the ListBox only scrolls if the item is not completely visible, and it scrolls for exactly the space to make it fully visible. If set to false, the item is scrolled to the top position (if possible).
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.scrollToIndex = function(iIndex, bLazy) {
		var oDomRef = this.getDomRef();
		if (oDomRef) { // only if already rendered
			var oItem = this.$("list").children("li[data-sap-ui-lbx-index=" + iIndex + "]");
			oItem = oItem.get(0);
			if (oItem) {
				var iScrollTop = oItem.offsetTop;
				if (!bLazy) {
					// scroll there without any conditions
					this.setScrollTop(iScrollTop);
				} else {
					// "lazy" means we should only scroll if required and as far as required
					var iCurrentScrollTop = oDomRef.scrollTop;
					var iViewPortHeight = jQuery(oDomRef).height();
					if (iCurrentScrollTop >= iScrollTop) {
						// if we have to scroll up, the behavior is fine already
						this.setScrollTop(iScrollTop);
					} else if ((iScrollTop + ListBox._fItemHeight) > (iCurrentScrollTop + iViewPortHeight)) { // bottom Edge of item > bottom edge of viewport
						// the item is - at least partly - below the current viewport of the ListBox, so scroll down. But only as far as required
						this.setScrollTop(Math.ceil(iScrollTop + ListBox._fItemHeight - iViewPortHeight)); // round because of _fItemHeight
					} // else if the item is already fully visible, do nothing
				}
			}
			// store the actual position
			this.getScrollTop();
		} else {
			// control not yet rendered, thus item height is unknown, so remember request for after rendering
			this.oScrollToIndexRequest = {iIndex:iIndex,bLazy:bLazy};
		}
		return this;
	};

	ListBox.prototype.getVisibleItems = function() {
		return this._iVisibleItems;
	};

	/**
	 * Makes the ListBox render with a height that allows it to display exactly the given number of items.
	 *
	 * @param {int} iItemCount the number of items that should fit into the ListBox without scrolling
	 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
	 * @public
	 */
	ListBox.prototype.setVisibleItems = function(iItemCount) {
	 /*
		*For the calculation, the size of the first item is used; if no item is present, an invisible dummy item
		* is rendered and instantly removed again.
		* Therefore, this method will not work for items with different heights and if actual items have a different
		* size than generic empty dummy items.
		*/
		// TODO: prevent values less than 1, or make them go back to CSS heights
		this.setProperty("visibleItems", iItemCount, true);

		this._iVisibleItems = iItemCount;
		if (iItemCount < 0) {
			this._bHeightInItems = false;
		} else {
			this._bHeightInItems = true;
		}

		// the actual height to set must be calculated now or later
		this._sTotalHeight = null;

		// if already rendered, calculate and set the height
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			if (this._bHeightInItems) {
				var oFirstItem = oDomRef.firstChild ? oDomRef.firstChild.firstChild : null;
				if (oFirstItem || ((ListBox._fItemHeight > 0) && (ListBox._iBordersAndStuff > 0))) {
					oDomRef.style.height = this._calcTotalHeight();
				} else {
					// already rendered, but no dummy item!
					this.invalidate();
				}
			} else {
				oDomRef.style.height = this.getHeight();
				this._updatePageSize();
				if (this.oItemNavigation) {
					this.oItemNavigation.setPageSize(this._iVisibleItems); // Page down by number of visible items
				}
			}
		}

		//if (this._sTotalHeight == null) { // this is the "else" clause covering all cases where the height was not set above
			// called before rendering, so the calculation and setting of the actual CSS height to set must be done later
		//}

		return this;
	};


	/**
	 * Calculates the outer height of the ListBox from the known item height and number of items that should fit.
	 * The result (a CSS size string) is returned as well as assigned to this._sTotalHeight.
	 * Precondition: the control is rendered, this._iVisibleItems, sap.ui.commons.ListBox._iBordersAndStuff and
	 * sap.ui.commons.ListBox._fItemHeight are initialized.
	 *
	 * @returns {string} the required outer height as CSS size
	 * @private
	 */
	ListBox.prototype._calcTotalHeight = function() {
		// TODO: check preconditions
		var desiredHeight = this._iVisibleItems * ListBox._fItemHeight;
		this._sTotalHeight = (desiredHeight + ListBox._iBordersAndStuff) + "px";
		return this._sTotalHeight;
	};


	/**
	 * Sets the height of this ListBox in CSS units

	 * @param {sap.ui.core.CSSSize} sHeight
	 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
	 * @public
	 */
	ListBox.prototype.setHeight = function(sHeight) {
		this._bHeightInItems = false;
		this._iVisibleItems = -1;

		var oDomRef = this.getDomRef();
		if (oDomRef) {
			oDomRef.style.height = sHeight;
			this._updatePageSize();
			if (this.oItemNavigation) {
				this.oItemNavigation.setPageSize(this._iVisibleItems); // Page down by number of visible items
			}
		}

		this.setProperty("height", sHeight, true); // no re-rendering
		return this;
	};

	/**
	 * Setter for property width.
	 *
	 * @param {sap.ui.core.CSSSize} sWidth
	 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
	 * @public
	 */
	ListBox.prototype.setWidth = function(sWidth) {
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			oDomRef.style.width = sWidth;
		}
		this.setProperty("width", sWidth, true); // no re-rendering
		return this;
	};

	/**
	 * Positions the ListBox contents that are scrolled-down by the given number of pixels
	 *
	 * @param {int} iScrollTop Vertical scroll position in pixels
	 * @return {sap.ui.commons.ListBox} <code>this</code> to allow method chaining
	 * @public
	 */
	ListBox.prototype.setScrollTop = function (iScrollTop) {
		iScrollTop = Math.round(iScrollTop);
		var scrollDomRef = this.getDomRef();
		this.oScrollToIndexRequest = null; // delete any pending scroll request
		if (scrollDomRef) {
			scrollDomRef.scrollTop = iScrollTop;
		}
		this.setProperty("scrollTop", iScrollTop, true); // no rerendering
		return this;
	};

	/**
	 * Returns how many pixels the ListBox contents are currently scrolled down
	 *
	 * @return {int} Vertical scroll position
	 * @public
	 */
	ListBox.prototype.getScrollTop = function () {
		var scrollDomRef = this.getDomRef();
		if (scrollDomRef) {
			var scrollTop = Math.round(scrollDomRef.scrollTop);
			this.setProperty("scrollTop", scrollTop, true);
			return scrollTop;
		} else {
			return this.getProperty("scrollTop");
		}
	};



	/* --- user interaction handling methods --- */

	ListBox.prototype.onmousedown = function(oEvent) {
		if (!!sap.ui.Device.browser.webkit && oEvent.target && oEvent.target.id === this.getId()) { // ListBox scrollbar has been clicked; webkit completely removes the focus, which breaks autoclose popups
			var idToFocus = document.activeElement ? document.activeElement.id : this.getId();
			var that = this;
			window.setTimeout(function(){
				var scrollPos = that.getDomRef().scrollTop; // yes, this scrollPosition is the right one to use. The one before setTimeout works for the scrollbar grip, but not for the arrows
				jQuery.sap.focus(jQuery.sap.domById(idToFocus)); // re-set the focus
				that.getDomRef().scrollTop = scrollPos; // re-apply the scroll position (otherwise the focus() call would scroll the focused element into view)
			},0);
		}
	};

	ListBox.prototype.onclick = function (oEvent) {
		this._handleUserActivation(oEvent);
	};

	ListBox.prototype.onsapspace = function (oEvent) {
		this._handleUserActivation(oEvent);
	};

	/*
	 * Ensure the sapspace event with modifiers is also handled as well as the respective "enter" events
	 */

	ListBox.prototype.onsapspacemodifiers = ListBox.prototype.onsapspace;
	ListBox.prototype.onsapenter = ListBox.prototype.onsapspace;
	ListBox.prototype.onsapentermodifiers = ListBox.prototype.onsapspace;

	/**
	 * Internal method invoked when the user activates an item. Differentiates and dispatches according to modifier key
	 * and current selection.
	 *
	 * @private
	 */
	ListBox.prototype._handleUserActivation = function (oEvent) {
		if (!this.getEnabled() || !this.getEditable()) {
			return;
		}

		var oSource = oEvent.target;
		if (oSource.id === "" || jQuery.sap.endsWith(oSource.id, "-txt")) {
			oSource = oSource.parentNode;
			if (oSource.id === "") { // could be the image inside the first cell
				oSource = oSource.parentNode;
			}
		}
		var attr = jQuery(oSource).attr("data-sap-ui-lbx-index");
		if (typeof attr == "string" && attr.length > 0) {
			var iIndex = parseInt(attr, 10); // Get the selected index from the HTML

			var aItems = this.getItems();
			var oItem = aItems[iIndex]; // oItem could be a separator, though!

			// It could be the case that the list of items changed during the click event handling. Ensure the item is still the one in
			if (aItems.length <= iIndex) {  // TODO: very questionable! Why set the index to the last position? And why allow removing items during the processing?  Remove!
				iIndex = aItems.length - 1;
			}

			if (iIndex >= 0 && iIndex < aItems.length) { // TODO: this should be known by now
				if (oItem.getEnabled() && !(oItem instanceof sap.ui.core.SeparatorItem)) {
					// Take care of selection and select event
					if (oEvent.ctrlKey || oEvent.metaKey) { // = CTRL
							this._handleUserActivationCtrl(iIndex, oItem);
					} else {
						if (oEvent.shiftKey) {
							this.setSelectedIndices(this._getUserSelectionRange(iIndex));
							this.fireSelect({
								id:this.getId(),
								selectedIndex:iIndex,
								selectedIndices:this.getSelectedIndices(), /* NEW (do not use hungarian prefixes!) */
								selectedItem:oItem,
								sId:this.getId(),
								aSelectedIndices:this.getSelectedIndices() /* OLD */
							});
							this._iLastDirectlySelectedIndex = iIndex;
						} else {
							this._handleUserActivationPlain(iIndex, oItem);
						}
					}
				}
			}
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * Called when the user triggers an item without holding a modifier key.
	 * Changes the selection in the expected way.
	 *
	 * @private
	 */
	ListBox.prototype._handleUserActivationPlain = function (iIndex, oItem) {
		this._iLastDirectlySelectedIndex = iIndex;
		this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(iIndex));
		if (this.getSelectedIndex() != iIndex || this.getSelectedIndices().length > 1) {
			this.setSelectedIndex(iIndex); // Replace selection

			this.fireSelect({
				id:this.getId(),
				selectedIndex:iIndex,
				selectedIndices:this.getSelectedIndices(), /* NEW (do not use hungarian prefixes!) */
				selectedItem:oItem,
				sId:this.getId(),
				aSelectedIndices:this.getSelectedIndices() /* OLD */
			});
		}
	};

	/**
	 * Called when the user triggers an item while pressing the Ctrl key.
	 * Changes the selection in the expected way for the "Ctrl" case.
	 *
	 * @private
	 */
	ListBox.prototype._handleUserActivationCtrl = function (iIndex, oItem) {
		this._iLastDirectlySelectedIndex = iIndex;
		this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(iIndex));
		if (this.isIndexSelected(iIndex)) {
			this.removeSelectedIndex(iIndex); // Remove from multi-selection
		} else {
			this.addSelectedIndex(iIndex); // Add to multi-selection
		}

		this.fireSelect({
			id:this.getId(),
			selectedIndex:iIndex,
			selectedIndices:this.getSelectedIndices(), /* NEW (do not use hungarian prefixes!) */
			selectedItem:oItem,
			sId:this.getId(),
			aSelectedIndices:this.getSelectedIndices() /* OLD */
		});
	};

	/**
	 * Calculates the list of indices ranging from the previously selected item to the
	 * given index. Used internally for calculating the new selection range when the user holds the "shift" key
	 * while clicking in the ListBox.
	 *
	 * @private
	 */
	ListBox.prototype._getUserSelectionRange = function (iIndex) {
		if (this._iLastDirectlySelectedIndex == -1) {
			// TODO: Use focus and continue execution
			return [];
		}

		var aItems = this.getItems();
		var aRange = [];
		if (this._iLastDirectlySelectedIndex <= iIndex) {
			for (var i = this._iLastDirectlySelectedIndex; i <= iIndex; i++) {
				if ((i > -1) && (aItems[i].getEnabled() && !(aItems[i] instanceof sap.ui.core.SeparatorItem))) {
					aRange.push(i);
				}
			}
		} else {
			for (var i = iIndex; i <= this._iLastDirectlySelectedIndex; i++) {
				if ((i > -1) && (aItems[i].getEnabled() && !(aItems[i] instanceof sap.ui.core.SeparatorItem))) {
					aRange.push(i);
				}
			}
		}
		return aRange;
	};



	/* --- Overwritten setters and getters affecting the selection --- */


	/**
	 * Zero-based index of selected item. Index value for no selection is -1. When multiple selection is enabled and multiple items are selected, the method returns the first selected item.
	 *
	 * @type int
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.getSelectedIndex = function() {
		for (var i = 0; i < this._aSelectionMap.length; i++) {
			if (this._aSelectionMap[i]) {
				return i;
			}
		}
		return -1;
	};


	/**
	 * Sets the zero-based index of the currently selected item. This method removes any previous selections. When the given index is invalid, the call is ignored.
	 *
	 * @param {int} iIndex
	 *         Index to be selected
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.setSelectedIndex = function(iSelectedIndex) {
		if ((iSelectedIndex < -1) || (iSelectedIndex > this._aSelectionMap.length - 1)) {
			return;
		} // Invalid index

		// do not select a disabled or separator item
		var aItems = this.getItems();
		if ((iSelectedIndex > -1) && (!aItems[iSelectedIndex].getEnabled() || (aItems[iSelectedIndex] instanceof sap.ui.core.SeparatorItem))) {
			return;
		}

		for (var i = 0; i < this._aSelectionMap.length; i++) {
			this._aSelectionMap[i] = false;
		}
		this._aSelectionMap[iSelectedIndex] = true;
		// And inform the itemNavigation about this, too
		if (this.oItemNavigation) {
			this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(iSelectedIndex));
		}
		this.getRenderer().handleSelectionChanged(this);

		return this;
	};


	/**
	 * Adds the given index to current selection. When multiple selection is disabled, this replaces the current selection. When the given index is invalid, the call is ignored.
	 *
	 * @param {int} iIndex
	 *         Index to add to selection.
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.addSelectedIndex = function(iSelectedIndex) {
		if (!this.getAllowMultiSelect()) { // If multi-selection is not allowed, this call equals setSelectedIndex
			this.setSelectedIndex(iSelectedIndex);
		}

		// Multi-selectable case
		if ((iSelectedIndex < -1) || (iSelectedIndex > this._aSelectionMap.length - 1)) {
			return;
		} // Invalid index

		// do not select a disabled or separator item
		var aItems = this.getItems();
		if ((iSelectedIndex > -1) && (!aItems[iSelectedIndex].getEnabled() || (aItems[iSelectedIndex] instanceof sap.ui.core.SeparatorItem))) {
			return;
		}

		if (this._aSelectionMap[iSelectedIndex]) {
			return;
		} // Selection does not change

		// Was not selected before
		this._aSelectionMap[iSelectedIndex] = true;
		this.getRenderer().handleSelectionChanged(this);

		return this;
	};


	/**
	 * Removes the given index from this selection. When the index is invalid or not selected, the call is ignored.
	 *
	 * @param {int} iIndex
	 *         Index that shall be removed from selection.
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.removeSelectedIndex = function(iIndex) {
		if ((iIndex < 0) || (iIndex > this._aSelectionMap.length - 1)) {
			return;
		} // Invalid index

		if (!this._aSelectionMap[iIndex]) {
			return;
		} // Selection does not change

		// Was selected before
		this._aSelectionMap[iIndex] = false;
		this.getRenderer().handleSelectionChanged(this);

		return this;
	};


	/**
	 * Removes complete selection.
	 *
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.clearSelection = function() {
		for (var i = 0; i < this._aSelectionMap.length; i++) {
			if (this._aSelectionMap[i]) {
				this._aSelectionMap[i] = false;
			}
		}
		// More or less re-initialized
		this._iLastDirectlySelectedIndex = -1;
		// Reset the index also in ItemNavigation
		if (this.oItemNavigation) {
			this.oItemNavigation.setSelectedIndex( -1);
		}
		this.getRenderer().handleSelectionChanged(this);

		return this;
	};




	/**
	 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
	 *
	 * @type int[]
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.getSelectedIndices = function() {
		var aResult = [];
		for (var i = 0; i < this._aSelectionMap.length; i++) {
			if (this._aSelectionMap[i]) {
				aResult.push(i);
			}
		}
		return aResult;
	};


	/**
	 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
	 * When multiple selection is disabled and multiple items are given, the selection is set to the index of the first valid index in the given array.
	 * Any invalid indices are ignored.
	 * The previous selection is in any case replaced.
	 *
	 * @param {int[]} aIndices
	 *         Indices of the items to be selected.
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.setSelectedIndices = function(aSelectedIndices) {
		var indicesToSet = [];
		var aItems = this.getItems();
		for (var i = 0; i < aSelectedIndices.length; i++) {
			if ((aSelectedIndices[i] > -1) && (aSelectedIndices[i] < this._aSelectionMap.length)) {
				if (aItems[aSelectedIndices[i]].getEnabled() && !(aItems[aSelectedIndices[i]] instanceof sap.ui.core.SeparatorItem)) {
					indicesToSet.push(aSelectedIndices[i]);
				}
			}
		}

		if (indicesToSet.length > 0) { // TODO: Disable event listening to items??
			// With multi-selection disabled, use the first valid index only
			if (!this.getAllowMultiSelect()) {
				indicesToSet = [indicesToSet[0]];
			}
		}

		for (var i = 0; i < this._aSelectionMap.length; i++) {
			this._aSelectionMap[i] = false;
		}

		// O(n+m)
		for (var i = 0; i < indicesToSet.length; i++) {
			this._aSelectionMap[indicesToSet[i]] = true;
		}
		this.getRenderer().handleSelectionChanged(this);

		return this;
	};


	/**
	 * Adds the given indices to selection. Any invalid indices are ignored.
	 *
	 * @param {int[]} aIndices
	 *         Indices of the items that shall additionally be selected.
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.addSelectedIndices = function(aSelectedIndices) {
		var indicesToSet = [];
		var aItems = this.getItems();
		for (var i = 0; i < aSelectedIndices.length; i++) {
			if ((aSelectedIndices[i] > -1) && (aSelectedIndices[i] < this._aSelectionMap.length)) {
				// do not select a disabled or separator item
				if (aItems[aSelectedIndices[i]].getEnabled() && !(aItems[aSelectedIndices[i]] instanceof sap.ui.core.SeparatorItem)) {
					indicesToSet.push(aSelectedIndices[i]);
				}
			}
		}

		if (indicesToSet.length > 0) { // TODO: Disable event listening to items??
			// With multi-selection disabled, use the first valid index only
			if (!this.getAllowMultiSelect()) {
				indicesToSet = [indicesToSet[0]];
			}

			// O(n+m)
			for (var i = 0; i < indicesToSet.length; i++) {
				this._aSelectionMap[indicesToSet[i]] = true;
			}
			this.getRenderer().handleSelectionChanged(this);
		}
		return this;
	};



	/**
	 * Returns whether the given index is selected.
	 *
	 * @param {int} iIndex
	 *         Index which is checked for selection state.
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.isIndexSelected = function(iIndex) {
		if ((iIndex < -1) || (iIndex > this._aSelectionMap.length - 1)) {
			return false; // Invalid index -> not selected
		}

		return this._aSelectionMap[iIndex];
	};



	/**
	 * Keys of the items to be selected, wrapped in an array. An empty array means no selection. When multiple selection is disabled,
	 * and multiple keys are given, the selection is set to the item with the first valid key in the given array. Any invalid keys are ignored.
	 * The previous selection is replaced in any case.
	 *
	 * @param {string[]} aKeys
	 *         The keys of the items to be selected
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.setSelectedKeys = function(aSelectedKeys) {
		var aItems = this.getItems();

		var mKeyMap = {};
		for (var i = 0; i < aSelectedKeys.length; i++) { // put the keys into a map to hopefully search faster below
			mKeyMap[aSelectedKeys[i]] = true;
		}

		var aIndices = [];
		for (var j = 0; j < aItems.length; j++) {
			if (mKeyMap[aItems[j].getKey()]) {
				aIndices.push(j);
			}
		}

		return this.setSelectedIndices(aIndices);
	};


	/**
	 * Returns the keys of the selected items in an array. If a selected item does not have a key, the respective array entry will be undefined.
	 *
	 * @type string[]
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.getSelectedKeys = function() {
		var aItems = this.getItems();
		var aResult = [];
		for (var i = 0; i < this._aSelectionMap.length; i++) {
			if (this._aSelectionMap[i]) {
				aResult.push(aItems[i].getKey());
			}
		}
		return aResult;
	};



	/**
	 * Returns selected item. When no item is selected, "null" is returned. When multi-selection is enabled and multiple items are selected, only the first selected item is returned.
	 *
	 * @type sap.ui.core.Item
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.getSelectedItem = function() {
		var iIndex = this.getSelectedIndex();
		if ((iIndex < 0) || (iIndex >= this._aSelectionMap.length)) {
			return null;
		}
		return this.getItems()[iIndex];
	};


	/**
	 * Returns an array containing the selected items. In the case of no selection, an empty array is returned.
	 *
	 * @type sap.ui.core.Item[]
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.getSelectedItems = function() {
		var aItems = this.getItems();
		var aResult = [];
		for (var i = 0; i < this._aSelectionMap.length; i++) {
			if (this._aSelectionMap[i]) {
				aResult.push(aItems[i]);
			}
		}
		return aResult;
	};

	ListBox.prototype.setAllowMultiSelect = function(bAllowMultiSelect) {
		this.setProperty("allowMultiSelect", bAllowMultiSelect);
		var oneWasSelected = false;
		var twoWereSelected = false;
		if (!bAllowMultiSelect && this._aSelectionMap) {
			for (var i = 0; i < this._aSelectionMap.length; i++) {
				if (this._aSelectionMap[i]) {
					if (!oneWasSelected) {
						oneWasSelected = true;
					} else {
						this._aSelectionMap[i] = false;
						twoWereSelected = true;
					}
				}
			}
		}
		if (twoWereSelected) {
			this.getRenderer().handleSelectionChanged(this);
		}
		return this;
	};


	/**
	 * Handles the event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
	 *
	 * @param {sap.ui.base.Event} oControlEvent The event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
	 * @private
	 */
	ListBox.prototype._handleAfterFocus = function(oControlEvent) {
		var iIndex = oControlEvent.getParameter("index");
		iIndex = ((iIndex !== undefined && iIndex >= 0) ? this._aActiveItems[iIndex] : 0);

		this.getRenderer().handleARIAActivedescendant(this, iIndex);
	};

	/* --- "items" aggregation methods, overwritten to update _aSelectionMap and allow filteredItems --- */

	/*
	 * Implementation of API method setItems.
	 * Semantically belonging to "items" aggregation but not part of generated method set.
	 * @param bNoItemsChanged not in official API, only needed in DropdownBox TypeAhead
	 */

	/**
	 * Allows setting the list items as array for this instance of ListBox.
	 *
	 * @param {sap.ui.core.ListItem[]} aItems
	 *         The items to set for this ListBox.
	 * @param {boolean} bDestroyItems
	 *         Optional boolean parameter to indicate that the formerly set items should be destroyed, instead of just removed.
	 * @type sap.ui.commons.ListBox
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListBox.prototype.setItems = function(aItems, bDestroyItems, bNoItemsChanged) {
		this.bNoItemsChangeEvent = true;
		if (bDestroyItems) {
			this.destroyItems();
		} else {
			this.removeAllItems();
		}
		for (var i = 0, l = aItems.length; i < l; i++) {
			this.addItem(aItems[i]);
		}
		this.bNoItemsChangeEvent = undefined;
		if (!bNoItemsChanged) {
			this.fireEvent("itemsChanged", {event: "setItems", items: aItems}); //private event used in DropdownBox
		}
		return this;
	};

	ListBox.prototype.addItem = function(oItem) {
		this.bNoItemInvalidateEvent = true;
		this.addAggregation("items", oItem);
		this.bNoItemInvalidateEvent = false;
		if ( !this._aSelectionMap ) {
			this._aSelectionMap = [];
		}
		this._aSelectionMap.push(false);

		if (!this.bNoItemsChangeEvent) {
			this.fireEvent("itemsChanged", {event: "addItem", item: oItem}); //private event used in DropdownBox
		}

		oItem.attachEvent("_change", this._handleItemChanged, this);

		return this;
	};

	ListBox.prototype.insertItem = function(oItem, iIndex) {
		if ((iIndex < 0) || (iIndex > this._aSelectionMap.length)) {
			return;
		} // Ignore invalid index TODO:: check behavior for iIndex=length
		// TODO: Negative indices might be used to count from end of array

		this.bNoItemInvalidateEvent = true;
		this.insertAggregation("items", oItem, iIndex);
		this.bNoItemInvalidateEvent = false;
		this._aSelectionMap.splice(iIndex, 0, false);

		this.invalidate();

		if (!this.bNoItemsChangeEvent) {
			this.fireEvent("itemsChanged", {event: "insertItems", item: oItem, index: iIndex}); //private event used in DropdownBox
		}

		oItem.attachEvent("_change", this._handleItemChanged, this);

		return this;
	};

	ListBox.prototype.removeItem = function(vElement) {
		var iIndex = vElement;
		if (typeof (vElement) == "string") { // ID of the element is given
			vElement = sap.ui.getCore().byId(vElement);
		}
		if (typeof (vElement) == "object") { // the element itself is given or has just been retrieved
			iIndex = this.indexOfItem(vElement);
		}

		if ((iIndex < 0) || (iIndex > this._aSelectionMap.length - 1)) {
			if (!this.bNoItemsChangeEvent) {
				this.fireEvent("itemsChanged", {event: "removeItem", item: vElement}); //private event used in DropdownBox
			}
			return;
		} // Ignore invalid index

		this.bNoItemInvalidateEvent = true;
		var oRemoved = this.removeAggregation("items", iIndex);
		this.bNoItemInvalidateEvent = false;
		this._aSelectionMap.splice(iIndex, 1);

		this.invalidate();

		if (!this.bNoItemsChangeEvent) {
			this.fireEvent("itemsChanged", {event: "removeItem", item: oRemoved}); //private event used in DropdownBox
		}

		oRemoved.detachEvent("_change", this._handleItemChanged, this);

		return oRemoved;
	};

	ListBox.prototype.removeAllItems = function() {
		this.bNoItemInvalidateEvent = true;
		var oRemoved = this.removeAllAggregation("items");
		this.bNoItemInvalidateEvent = false;

		this._aSelectionMap = [];

		this.invalidate();

		if (!this.bNoItemsChangeEvent) {
			this.fireEvent("itemsChanged", {event: "removeAllItems"}); //private event used in DropdownBox
		}

		for ( var i = 0; i < oRemoved.length; i++) {
			oRemoved[i].detachEvent("_change", this._handleItemChanged, this);
		}

		return oRemoved;
	};

	ListBox.prototype.destroyItems = function() {

		var aItems = this.getItems();
		for ( var i = 0; i < aItems.length; i++) {
			aItems[i].detachEvent("_change", this._handleItemChanged, this);
		}

		this.bNoItemInvalidateEvent = true;
		var destroyed = this.destroyAggregation("items");
		this.bNoItemInvalidateEvent = false;

		this._aSelectionMap = [];

		this.invalidate();

		if (!this.bNoItemsChangeEvent) {
			this.fireEvent("itemsChanged", {event: "destroyItems"}); //private event used in DropdownBox
		}

		return destroyed;
	};

	ListBox.prototype.updateItems = function(){

		this.bNoItemsChangeEvent = true;

		this.updateAggregation("items");

		this.bNoItemsChangeEvent = undefined;

		this.fireEvent("itemsChanged", {event: "updateItems"}); //private event used in DropdownBox

	};

	/**
	 * Does all the cleanup when the ListBox is to be destroyed.
	 * Called from the element's destroy() method.
	 * @private
	 */
	ListBox.prototype.exit = function (){
		if (this.oItemNavigation) {
			this.removeDelegate(this.oItemNavigation);
			this.oItemNavigation.destroy();
			delete this.oItemNavigation;
		}

		// No super.exit() to call
	};

	/*
	 * Overrides getFocusDomRef of base element class.
	 * @public
	 */
	ListBox.prototype.getFocusDomRef = function() {
		return this.getDomRef("list");
	};

	/*
	 * Overwrites default implementation
	 * the label must point to the UL element
	 * @public
	 */
	ListBox.prototype.getIdForLabel = function () {
		return this.getId() + '-list';
	};

	/*
	 * inform ComboBox if an item has changed
	*/
	ListBox.prototype._handleItemChanged = function(oEvent) {

		if (!this.bNoItemInvalidateEvent) {
			this.fireEvent("itemInvalidated", {item: oEvent.oSource}); //private event used in ComboBox
		}

	};


	return ListBox;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ListBox.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Menu') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Menu.
jQuery.sap.declare('sap.ui.commons.Menu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Menu",['jquery.sap.global', './MenuItemBase', './library', 'sap/ui/unified/Menu'],
	function(jQuery, MenuItemBase, library, Menu1) {
	"use strict";


	
	/**
	 * Constructor for a new Menu.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A container for menu items. When the space in the browser is not large enough to display all defined items, a scroll bar is provided.
	 * @extends sap.ui.unified.Menu
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.21.0. 
	 * Please use the control sap.ui.unified.Menu of the library sap.ui.unified instead.
	 * @alias sap.ui.commons.Menu
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Menu = Menu1.extend("sap.ui.commons.Menu", /** @lends sap.ui.commons.Menu.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons"
	}});
	
	/*Ensure MenuItemBase is loaded (incl. loading of unified library)*/

	return Menu;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Menu.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuButton') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.MenuButton.
jQuery.sap.declare('sap.ui.commons.MenuButton'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MenuButton",['jquery.sap.global', './Button', './Menu', './MenuItemBase', './library'],
	function(jQuery, Button, Menu, MenuItemBase, library) {
	"use strict";

	/**
	 * Constructor for a new MenuButton.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Common button control that opens a menu when clicked by the user. The control provides an API for configuring the docking position
	 * of the menu.
	 * @extends sap.ui.commons.Button
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.MenuButton
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MenuButton = Button.extend("sap.ui.commons.MenuButton", /** @lends sap.ui.commons.MenuButton.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * The position / edge (see sap.ui.core.Popup.Dock) of the button where the menu is docked. Default is 'begin bottom'.
			 */
			dockButton : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * The position / edge (see sap.ui.core.Popup.Dock) of the menu which is docked to the button. Default is 'begin top'.
			 */
			dockMenu : {type : "string", group : "Misc", defaultValue : null}
		},
		defaultAggregation : "menu",
		aggregations : {
	
			/**
			 * Menu that shall be opened when the button is clicked
			 */
			menu : {type : "sap.ui.unified.Menu", multiple : false}
		},
		events : {
	
			/**
			 * Event that is fired when a menu item is selected by the user
			 */
			itemSelected : {
				parameters : {
	
					/**
					 * The ID of the selected item
					 */
					itemId : {type : "string"}, 
	
					/**
					 * The selected item
					 */
					item : {type : "sap.ui.unified.MenuItemBase"}
				}
			}
		}
	}});
	
	/*Ensure MenuItemBase is loaded (incl. loading of unified library)*/
	
	MenuButton.prototype.init = function() {
		this.addStyleClass("sapUiMenuButton");
		this.bWithKeyboard = false;
	};
	
	/**
	 * Function is called when button is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	MenuButton.prototype.onclick = function(oEvent) {
		if (this.getEnabled() && !this._bSkipOpen) {
			var oTooltip = this.getTooltip();
			if (oTooltip && oTooltip instanceof sap.ui.core.TooltipBase) {
				oTooltip._closeOrPreventOpen(); //CSN 1762131 2013
			}
			var sDockButton = this.getDockButton() ? this.getDockButton() : sap.ui.core.Popup.Dock.BeginBottom;
			var sDockMenu = this.getDockMenu() ? this.getDockMenu() : sap.ui.core.Popup.Dock.BeginTop;
			this.getMenu().open(this.bWithKeyboard, this, sDockMenu, sDockButton, this);
		}
		this.bWithKeyboard = false;
		this._bSkipOpen = false;
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	/**
	 * Function is called when mouse key is clicked down.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	MenuButton.prototype.onmousedown = function(oEvent) {
		this.handleMouseDown(oEvent, false);
		this._bSkipOpen = this.getMenu() && this.getMenu().bOpen;
	};
	
	
	/**
	 * Function is called when mouse leaves the control.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	MenuButton.prototype.onmouseout = function(oEvent) {
		if (Button.prototype.onmouseout) {
			Button.prototype.onmouseout.apply(this, arguments);
		}
		if (this._bSkipOpen && jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())) {
			this._bSkipOpen = false;
		}
	};
	
	
	/**
	 * Function is called when enter key is pressed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	MenuButton.prototype.onsapenter = function(oEvent){
		//It is sufficient to set this flag here only. A click event to open the menu will follow.
		this.bWithKeyboard = true;
	};
	
	/**
	 * Function is called when space key is pressed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	MenuButton.prototype.onsapspace = function(oEvent){
		//It is sufficient to set this flag here only. A click event to open the menu will follow.
		this.bWithKeyboard = true;
	};
	
	/**
	 * Function is called when down key is pressed with a modifier key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	//Requested by UX, see CSN 0120061532 0001379793 2011
	MenuButton.prototype.onsapdownmodifiers = function(oEvent){
		if (oEvent.altKey) {
			this.bWithKeyboard = true;
			this.onclick(oEvent);
		}
	};
	
	MenuButton.prototype.clone = function(sIdSuffix, aLocalIds) {
		//Deregister event listener before cloning
		updateMenuEventRegistration(this);
		var oClone = Button.prototype.clone.apply(this, arguments);
		updateMenuEventRegistration(this, this.getMenu());
		return oClone;
	};
	
	/**
	 * Setter for the aggregated <code>menu</code>.
	 * @param {sap.ui.unified.Menu} oMenu
	 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
	 * @public
	 */
	MenuButton.prototype.setMenu = function(oMenu) {
		updateMenuEventRegistration(this, oMenu);
		this.setAggregation("menu", oMenu);
		return this;
	};
	
	/**
	 * Destroys the menu in the aggregation
	 * named <code>menu</code>.
	 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
	 * @public
	 */
	MenuButton.prototype.destroyMenu = function() {
		updateMenuEventRegistration(this, null);
		this.destroyAggregation("menu");
		return this;
	};
	
	//********** Private **********
	
	// Detaches the select event handler from the current menu and attaches it to the new menu
	var updateMenuEventRegistration = function(oThis, oNewMenu){
		var oMenu = oThis.getMenu();
		if (oMenu) {
			oMenu.detachItemSelect(oThis._fItemSelectHandler);
		}
		oThis._fItemSelectHandler = jQuery.proxy(onItemSelected, oThis);
		if (oNewMenu) {
			oNewMenu.attachItemSelect(oThis._fItemSelectHandler);
		}
	};
	
	//Function is called when an item in the menu was selected.
	var onItemSelected = function(oEvent){
		var oItem = oEvent.getParameter("item");
		this.fireItemSelected({itemId: oItem.getId(), item: oItem});
		this.firePress({itemId: oItem.getId(), item: oItem});
	};
	
	// Overwrite JSDoc for inherited press event to make clear that 'press' === 'itemSelected'
	
	/**
	 * Fired when an item from the menu was selected.
	 *
	 * @see sap.ui.commons.MenuButton#itemSelected
	 *
	 * @param {sap.ui.base.Event} oControlEvent
	 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
	 * @param {object} oControlEvent.getParameters
	 *
	 * @param {string} oControlEvent.getParameters.itemId The id of the selected item
	 * @param {sap.ui.commons.MenuItemBase} oControlEvent.getParameters.item The selected item
	 * @public
	 * @name sap.ui.commons.MenuButton#press
	 * @event
	 */
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'press' event of this <code>sap.ui.commons.MenuButton</code>.<br/>
	 *
	 * Event is fired when an item from the menu was selected.
	 *
	 * @see sap.ui.commons.MenuButton#attachItemSelected
	 *
	 * @param {object}
	 *            [oData] The object, that should be passed along with the event-object when firing the event.
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs. This function will be called on the
	 *            oListener-instance (if present) or in a 'static way'.
	 * @param {object}
	 *            [oListener] Object on which to call the given function. If empty, the global context (window) is used.
	 *
	 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.commons.MenuButton#attachPress
	 * @function
	 */
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'press' event of this <code>sap.ui.commons.MenuButton</code>.<br/>
	 *
	 * The passed function and listener object must match the ones previously used for event registration.
	 *
	 * @see sap.ui.commons.MenuButton#detachItemSelected
	 *
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs.
	 * @param {object}
	 *            oListener Object on which the given function had to be called.
	 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.commons.MenuButton#detachPress
	 * @function
	 */
	
	/**
	 * Fire event press to attached listeners.
	 *
	 * @see sap.ui.commons.MenuButton#fireItemSelected
	 *
	 * @param {Map} [mArguments] the arguments to pass along with the event.
	 * @return {sap.ui.commons.MenuButton} <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.commons.MenuButton#firePress
	 * @function
	 */

	return MenuButton;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MenuButton.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.MenuItem.
jQuery.sap.declare('sap.ui.commons.MenuItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuItem'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MenuItem",['jquery.sap.global', './MenuItemBase', './library', 'sap/ui/unified/MenuItem'],
	function(jQuery, MenuItemBase, library, MenuItem1) {
	"use strict";


	
	/**
	 * Constructor for a new MenuItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Smallest unit in the menu hierarchy. An item can be a direct part of a menu bar, of a menu, or of a sub menu.
	 * @extends sap.ui.unified.MenuItem
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.21.0. 
	 * Please use the control sap.ui.unified.MenuItem of the library sap.ui.unified instead.
	 * @alias sap.ui.commons.MenuItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MenuItem = MenuItem1.extend("sap.ui.commons.MenuItem", /** @lends sap.ui.commons.MenuItem.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons"
	}});
	
	/*Ensure MenuItemBase is loaded (incl. loading of unified library)*/

	return MenuItem;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MenuItem.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MenuTextFieldItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.MenuTextFieldItem.
jQuery.sap.declare('sap.ui.commons.MenuTextFieldItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuTextFieldItem'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MenuTextFieldItem",['jquery.sap.global', './MenuItemBase', './library', 'sap/ui/unified/MenuTextFieldItem'],
	function(jQuery, MenuItemBase, library, MenuTextFieldItem1) {
	"use strict";


	
	/**
	 * Constructor for a new MenuTextFieldItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Menu item which contains an text field. This menu item is e.g. helpful for filters.
	 * The aggregation 'submenu' (inherited from parent class) is not supported for this type of menu item.
	 * @extends sap.ui.unified.MenuTextFieldItem
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.21.0. 
	 * Please use the control sap.ui.unified.MenuTextFieldItem of the library sap.ui.unified instead.
	 * @alias sap.ui.commons.MenuTextFieldItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MenuTextFieldItem = MenuTextFieldItem1.extend("sap.ui.commons.MenuTextFieldItem", /** @lends sap.ui.commons.MenuTextFieldItem.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons"
	}});
	
	/*Ensure MenuItemBase is loaded (incl. loading of unified library)*/

	return MenuTextFieldItem;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MenuTextFieldItem.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Message') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Message.
jQuery.sap.declare('sap.ui.commons.Message'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Message",['jquery.sap.global', './Dialog', './library', 'sap/ui/core/Control'],
	function(jQuery, Dialog, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new Message.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Creates the "Message"s to be supplied to the "MessageBar" Control.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.4.0. 
	 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
	 * @alias sap.ui.commons.Message
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Message = Control.extend("sap.ui.commons.Message", /** @lends sap.ui.commons.Message.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * "Success", or "Warning", or "Error" messages. (Mandatory)
			 */
			type : {type : "sap.ui.commons.MessageType", group : "Behavior", defaultValue : null},
	
			/**
			 * Message short text. (Mandatory)
			 */
			text : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Associated UI element ID. (Optional)
			 * For navigation to error field.
			 */
			associatedElementId : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Internal attribute, used to force the display of the "short" or the "long" text only.
			 */
			design : {type : "string", group : "Misc", defaultValue : null}
		}
	}});
	
	
	Message.prototype.init = function(){
		// Defining some private data...
		this.isRTL = sap.ui.getCore().getConfiguration().getRTL();
	
		// The "Details" related Controls.
	  this.fnCallBack    = null; // Supplied only if a longText is to be provided on demand.
		this.oLink         = null; // Created only if a longText exists. This is the link opening the Details Dialog.
		this.oContainer    = null; // Created only if a longText exists. This is the "Dialog" hosting the Details.
		this.oDetails      = null; // Created only if a longText exists. This is the Controller rendering the Details.
		this.oBtnOK        = null; // Created only if a longText exists. This is the OK button found within the Dialog.
	};
	
	/**
	 * Destroys this Control instance, called by Element#destroy()
	 * @private
	 */
	Message.prototype.exit = function() {
		if (this.oLink) {
			this.oLink.destroy();
			this.oLink = null;
		}
		if (this.oDetails) {
			this.oDetails.destroy();
			this.oDetails = null;
		}
		if (this.oContainer) {
			this.oContainer.destroy();
			this.oContainer = null;
		}
		if (this.oBtnOK) {
			this.oBtnOK.destroy();
			this.oBtnOK = null;
		}
	};
	
	// #############################################################################
	// Internal Utilities
	// #############################################################################
	/**
	 * This utility is for closing the Message Details from its OK button.
	 * @private
	 */
	Message.closeDetails = function(oControlEvent) {
	  oControlEvent.getSource().getParent().close();
	};
	/**
	 * This utility closes THIS Message's Details.
	 * @private
	 */
	Message.prototype.closeDetails = function() {
	  // If Details have been opened, can attempt to close them:
	  if (this.oContainer) {
		this.oContainer.close();
	  }
	};
	
	/**
	 * This utility renders the Message Details.
	 * Current Specifications are those of JPaaS:
	 *    Supported by:               "Dialog"              "MessageBox"
	 *  - Title:                       Yes                   Yes
	 *  - Non-blocking:                Yes, configurable.    No, modal only
	 *  - Accepts HTML string:         Yes, via oContent.    No, sMessage only
	 *  - Bottom-Right resize handle:  Yes                   No
	 *  - No icon:                     Yes                   Possible
	 * @private
	 */
	Message.prototype.openDetails = function() {
	  if (!this.oContainer) {
		var rb          = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
		var OK          = rb.getText("MSGBAR_DETAILS_DIALOG_CLOSE");
		var title       = rb.getText("MSGBAR_DETAILS_DIALOG_TITLE");
		// Reading the HTML details as is, styles included:
		var	htmlDetails = this.fnCallBack(this.getId());
		this.oDetails   = new Message({type: this.getType(), text: htmlDetails});
		this.oBtnOK     = new sap.ui.commons.Button({text: OK, press:Message.closeDetails});
		this.oContainer = new Dialog();
		this.oContainer.addContent(this.oDetails);
		this.oContainer.setTitle(title);
			this.oContainer.addButton(this.oBtnOK);
	  //this.oContainer.setDefaultButton(this.oBtnOK); // Already the default since the only button...
	  }
		// Other visible Dialogs around?
	  var sContainerId = this.oContainer.getId();
	  var iOthersMaxZIndex = 0;
	  var oOtherOpenDialogs = jQuery('.sapUiDlg');
	  for (var i = oOtherOpenDialogs.length - 1; i >= 0; i--) {
		if (jQuery(oOtherOpenDialogs[i]).css('visibility') != "visible") {
		  oOtherOpenDialogs.splice(i, 1);
		} else if (oOtherOpenDialogs[i].id == sContainerId) {
		  oOtherOpenDialogs.splice(i, 1);
		} else {
		  iOthersMaxZIndex = Math.max(iOthersMaxZIndex,jQuery(oOtherOpenDialogs[i]).css('zIndex'));
		}
	  }
	
	  // Taking note for later:
	  var bWasOpen = this.oContainer.isOpen();
	  // No matter what, we have to open the new Details, so:
	  this.oContainer.open();
	
	  // jQuery version of our OPEN Dialog Container:
		var jContainer = this.oContainer.$();
	
	  // Starting a new Stack in the default Dialog's location:
	  var jContainerRect = jContainer.rect(); // For Height and Width...
		if (oOtherOpenDialogs.length == 0) {
			// "offsets.right" & "offsets.left" should be identical as plain Dialogs are centered,
			// but in case there is a bug (like in Safari RTL):
			if (this.isRTL) {
			  // Will be using "left" invariably for RTL or LTR:
				jContainerRect.left = Number(jContainer.css('right').replace("px", ""));
			}
			this.setLastOffsets(jContainerRect);
			// Nothing else to do:
			return;
		}
	
	  // Dialog limitation. Work-around:
	  if (bWasOpen) {
			if (iOthersMaxZIndex > jContainer.css('zIndex')) {
				// zIndex not raised via previous re-open()...
				// Have to raise it ourselves.
			jContainer.css('zIndex',iOthersMaxZIndex + 1);
			}
			// Nothing else to do:
		return;
	  }
	
	  //*************** Stacking process starts ***************
	  // 1st rendering the new Dialog on top of the old one...
	  var oNextOffsets = this.getNextOffsets();
		jContainer.css('top',  (oNextOffsets.top - Message.TOP_INCR ) + "px");
	  if (this.isRTL) {
			jContainer.css('right', (oNextOffsets.left - Message.LEFT_INCR) + "px");
	  } else {
		jContainer.css('left',  (oNextOffsets.left - Message.LEFT_INCR) + "px");
	  }
	
	  // Figuring what should the next coordinates be:
	  var jContainerRect = jContainer.rect(); // For Height and Width...
	  var scrollTop   = jQuery(window).scrollTop();
	  var scrollLeft  = jQuery(window).scrollLeft(); // Negative in RTL
	  var scrollRight = -scrollLeft;
	  // Checking if the new coordinates fit within the window:
	  if ((jQuery(window).height() + scrollTop) < (oNextOffsets.top + jContainerRect.height)) {
		// ReStacking from the top:
		oNextOffsets.top = scrollTop;
		this.setLastOffsets(oNextOffsets);
	  }
	  if (this.isRTL) {
		  if ((jQuery(window).width() + scrollRight) < (oNextOffsets.left + jContainerRect.width)) {
			// ReStacking from the right:
			oNextOffsets.left = scrollRight;
			this.setLastOffsets(oNextOffsets);
		  }
			// Animating the Dialog to its new offset position:
			jContainer.animate({top:oNextOffsets.top + "px", right:oNextOffsets.left + "px"}, 200);
	  } else {
		  if ((jQuery(window).width() + scrollLeft) < (oNextOffsets.left + jContainerRect.width)) {
			// ReStacking from the left:
			oNextOffsets.left = scrollLeft;
			this.setLastOffsets(oNextOffsets);
		  }
			// Animating the Dialog to its new offset position:
			jContainer.animate({top:oNextOffsets.top + "px", left:oNextOffsets.left + "px"}, 200);
	  }
	
	//MESSAGEBOX BACKUP: Issues: Only Modal, Doesn't accept HTML string, No Resize-Area.
	//	var rb    = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	//  var ICON  = this.getType().toUpperCase();		// ERROR, WARNING, ...
	//  var title = rb.getText("MSGTYPE_" + ICON);
	//  var text  = this.getLongText();
	//  sap.ui.commons.MessageBox.show(text, ICON, title);
	};
	
	Message.TOP_INCR  = 20;
	Message.LEFT_INCR = 10;
	
	
	// Begin of Dialog-Offsets-Stacking facilities
	(function() {
		var oLastOffsets = null;
		/**
		 * @static
		 */
		Message.setLastOffsets = function(oOffsets){
			oLastOffsets = oOffsets;
		};
		Message.prototype.setLastOffsets = function(oOffsets){
			Message.setLastOffsets(oOffsets);
		};
		Message.getNextOffsets = function(){
		  oLastOffsets.top   += Message.TOP_INCR;
		  oLastOffsets.left  += Message.LEFT_INCR;
			return oLastOffsets;
		};
		Message.prototype.getNextOffsets = function(){
			return Message.getNextOffsets();
		};
	}());
	// End of Dialog-Offsets-Stacking facilities
	
	
	// #############################################################################
	// Public APIs
	// #############################################################################

	/**
	 * Registers a callback function to be invoked if long text Details are to be made available. 
	 * 
	 * This callback function will be supplied the corresponding Message "id", and should 
	 * return the (simple) HTML string to be displayed within the Message Details Dialog.
	 * 
	 * E.g.: myMessage.bindDetails(getDetails);
	 * function getDetails(sId) {... return htmlString;}
	 *
	 * @param {function} fnCallBack the callback function 
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 * @public
	 */
	Message.prototype.bindDetails = function(fnCallBack) {
		this.fnCallBack = fnCallBack;
	};

	return Message;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Message.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageBar') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.MessageBar.
jQuery.sap.declare('sap.ui.commons.MessageBar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MessageBar",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup'],
	function(jQuery, library, Control, Popup) {
	"use strict";


	
	/**
	 * Constructor for a new MessageBar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Creates an instance of a "MessageBar" Control, for displaying "Message"s.
	 * There is no imposed limit on the number of "MessageBar"s that can be created, but using only 1 makes sense, specially if accessing it (via Ctl-m) becomes a necessity.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.4.0. 
	 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
	 * @alias sap.ui.commons.MessageBar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MessageBar = Control.extend("sap.ui.commons.MessageBar", /** @lends sap.ui.commons.MessageBar.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Element ID upon which the 'message bar' is to be initially positioned.
			 */
			anchorID : {type : "string", group : "Appearance", defaultValue : ''},
	
			/**
			 * Invisible controls are not rendered.
			 */
			visible : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Maximum number of simultaneous messages being toasting-up in a row. Value '0' means this dynamic part of the feature is switched off.
			 */
			maxToasted : {type : "int", group : "Misc", defaultValue : 3},
	
			/**
			 * Maximum number of messages being display in the List before a scrollbar appears. Value '0' means no limit.
			 */
			maxListed : {type : "int", group : "Misc", defaultValue : 7},
	
			/**
			 * Type: sap.ui.core.Popup.Dock
			 * SnapPoint of MessageBar over anchorId.
			 * Note: Use "begin" or "end" for RTL support.
			 * Note: "center" is not indicated, as positioning is only set once, either via the css "left" or the "right" attribute. Therefore a MessageBar will only be extended in one direction, as Messages come in.
			 */
			anchorSnapPoint : {type : "string", group : "Misc", defaultValue : "begin top"}
		}
	}});
	
	
	MessageBar.prototype.init = function(){
		// Defining some private data...
	
		// Message queues, in priority order:
		this.aErrors    = []; // Error queue.
		this.aWarnings  = []; // Warning queue.
		this.aSuccesses = []; // Success queue.
		// Toasting queue:
		this.aToasts    = [];
		this.maxToastsReached = false; // Disables Toast queue.
	
		// Popup(oContent, bModal, bShadow, bAutoClose) container initialization:
		// - oModal: "true/false" : For blocking the background window.
		this.oPopup   = new Popup(this, false, true, false);
	
		// The different related Controls.
		this.oList    = null; // Created only if opened by user.
		// MessageBar does not come without Toasts:
		var id        = this.getId();
		this.oToast   = new sap.ui.commons.MessageToast(id + "__Toast", {anchorId:id + "__sums"});
		var that      = this; // For closure
		this.oToast.attachNext(function(){that.checkForToast();});
	
		// Drag&Drop data. Only evaluated if needed:
		this.snapPoint = null;
		this.oHomePosition = null;
		this.oDropPosition = null;
		this.bToggleListBackAfterDrag = null;
	};
	
	/**
	 * Destroys this Control instance, called by Element#destroy()
	 * @private
	 */
	MessageBar.prototype.exit = function() {
		// If this happens during a Drag, forcing a Drop
		// in order to remove any bound handlers:
		this.onmouseup();
	
		// Closing and destroying everything:
		this.close();
	
		this.oPopup.destroy();
		this.oPopup = null;
	
		this.oToast.destroy();
		this.oToast = null;
	
		if (this.oList) {
			this.oList.destroy();
			this.oList = null;
		}
	};
	
	// **************************************************
	// * Drag&Drop // Copied from Dialog and ColumnDnDManager...
	// **************************************************
	/**
	* Overwrites the native D&D, not to see the native ghost.
	* @param {sap.ui.core.BrowserEvent} oEvent The forwarded browser event
	* @private
	*/
	MessageBar.prototype.ondragstart = function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	/**
	 * Initializes drag and drop capabilities.
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	MessageBar.prototype.onmousedown = function (oEvent) {
	//jQuery.sap.log.debug("MESSAGEBAR: ONMOUSEDOWN");
		var oSource  = oEvent.target;
		var jSource = jQuery(oSource);
	
		// If cursor does not say move, then do not bother.
		if (jSource.css('cursor') != "move") {
			return;
		}
	
		this.sDragMode = "move";
	
	
	  // MessageBar start position:
		this.oMsgBarDragStartPosition       = this.$().rect();
		this.oMsgBarDragStartPosition.right = Number(this.$().css('right').replace("px", ""));
	
		// Recording our home position, in order to return to it on demand:
		if (!this.oHomePosition) {
			this.oHomePosition = this.oMsgBarDragStartPosition;
		}
	
		// To evaluate the extend of the drag:
		this.mouseDragStartPositionX = oEvent.screenX;
		this.mouseDragStartPositionY = oEvent.screenY;
	
		// Activating our move handler:
		var jDocument = jQuery(window.document);
		jDocument.bind("mousemove", jQuery.proxy(this.handleMove, this));
		if (window.parent) {
			jQuery(window.parent.document).bind("mousemove", jQuery.proxy(this.handleMove, this), true);
		}
	
		// Fix for IE blue text selection while dragging:
		jDocument.bind("selectstart",jQuery.proxy(this.ondragstart,this), true);
	};
	
	/**
	 * Handles the move event.
	 * @param {DOMEvent} event The event raised by the browser.
	 * @private
	 */
	MessageBar.prototype.handleMove = function (event) {
	//jQuery.sap.log.debug("MESSAGEBAR: HANDLEMOVE");
		if (!this.sDragMode) {
			return;
		}
	
	  // First closing the MessageList, if visible.
	  // That will allow the user to better see where he moves the MessageBar.
	  // We will reopen it after the Drop.
	  // This will also allow the List Popup to properly position itself (UP/DOWN).
	  if (this.bToggleListBackAfterDrag == null && this.oList) {
		this.bToggleListBackAfterDrag = this.oList.getVisible();
		if (this.bToggleListBackAfterDrag) {
			this.toggleList();
		}
	  }
	
	  // Moving our Control by the extent of the mouse-drag:
		event = event || window.event;
		var iTop   = this.oMsgBarDragStartPosition.top   + event.screenY - this.mouseDragStartPositionY;
		var iLeft  = this.oMsgBarDragStartPosition.left  + event.screenX - this.mouseDragStartPositionX;
		var iRight = this.oMsgBarDragStartPosition.right - event.screenX + this.mouseDragStartPositionX;
	
	  this.oPopup._$().css('top', iTop);
		// Is the Bar to be positioned and dragged from its right-hand side???
		if (this.snapPoint.indexOf("right") != -1) {
			this.oPopup._$().css('right', iRight);
		} else {
			this.oPopup._$().css('left', iLeft);
		}
	
		// Saving the drop position for the next MessageList "open" event:
		this.oDropPosition = {top: iTop, left: iLeft, right: iRight};
	
		event.cancelBubble = true;
		return false;
	};
	
	/**
	 * Handle onmouseup event.
	 * This does the cleanup after drag and move handling.
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	MessageBar.prototype.onmouseup = function (oEvent) {
	//jQuery.sap.log.debug("MESSAGEBAR: ONMOUSEUP");
		if (!this.sDragMode) {
			return;
		}
	
		// If we have indeed moved, then rendering our "back-home" icon:
	  if (this.oDropPosition) {
		  this.addStyleClass("sapUiMsgBarMoved");
	  }
	
	  // Reopening the List if was open before the move:
	  if (this.bToggleListBackAfterDrag) {
		this.toggleList();
	  }
	  this.bToggleListBackAfterDrag = null; // Re-initialized for the next D&D.
	
		// Removing our move handler:
		var jDocument = jQuery(window.document);
		jDocument.unbind("mousemove", jQuery.proxy(this.handleMove, this));
		if (window.parent) {
			jQuery(window.parent.document).unbind("mousemove", jQuery.proxy(this.handleMove, this));
		}
		jDocument.unbind("selectstart",jQuery.proxy(this.ondragstart,this));
	
		this.sDragMode = null;
	
		// Resume the toasting:
		this.checkForToast();
	};
	
	// **************************************************
	// * Clicking
	// **************************************************
	/**
	 * Handle onclick events.
	 * The 2 click-able areas are:
	 *  1) The front Open/Close list button.
	 *  2) The back GoHome button.
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	MessageBar.prototype.onclick = function (oEvent) {
		var oSource = oEvent.target;
		var jSource = jQuery(oSource);
	
		// If cursor does not say click, then do not bother.
		if (jSource.css('cursor') != "pointer") {
			return;
		}
	
	  // Now, checking were the click came from:
	  if (jSource.hasClass("sapUiMsgBarToggle")) {
			this.toggleList();
	  } else if (jSource.hasClass("sapUiMsgBarHome")) {
			this.backHome();
	  } else {
		jQuery.sap.log.debug("Warning: MessageBar unsupported click on " + jSource.attr('className'));
	  }
	}
	
	// #############################################################################
	// Internal Utilities
	// #############################################################################
	/**
	 * This utility checks what action the Toaster should execute next.
	 * @private
	 */;
	MessageBar.prototype.checkForToast = function() {
	  // No more toast if Multiple Toasts has already been displayed:
	  if (this.maxToastsReached) {
		return;
	  }
	
	  // Making sure there is some queued messages:
	  if (this.aToasts == null || this.aToasts.length == 0) {
		return;
	  }
	
	  // Making sure the feature is active:
	  var maxToasted = this.getMaxToasted();
	  if (maxToasted == 0) {
		return;
	  }
	
	  // Do not toast during Drag&Drop. Do not distract the user!
	  if (this.sDragMode) {
		return;
	  }
	
	  var nextToast = null;
	  var anchorId = "";
	  if (this.aToasts.length > this.getMaxToasted()) {
		// Having a null "nextToast" would indicate a "Multiple new messages..."
		// With "Multiple new messages...", no need to toast messages anymore,
		// so emptying the toasting queue:
		  this.aToasts = [];
		  this.maxToastsReached = true;
		// Do not wait for the previous toast to be done.
		// The Toast has to point towards our left open/close Arrow:
		anchorId = this.getId() + "__arrowImg";
	  } else {
		// Do not put a new toast in if there is already one in:
		  if (!this.oToast.isIdle()) {
			return;
		  }
		// Retrieving the oldest queued message:
		nextToast = this.aToasts.splice(0, 1)[0];
		// The Toast has to point towards the icon of the same priority, e.g. "id_ErrorImg":
		anchorId = this.getId() + "__" + nextToast.getType() + "Img";
	  }
	
	  // Triggering a Toast:
	  this.oToast.toast(nextToast, anchorId);
	};
	
	/**
	 * This utility adds Toasts to the Toast Array, if not already
	 * included within this Array.
	 * Order is chronological, not by priority.
	 * @private
	 */
	MessageBar.prototype.addToasts = function(aMessages) {
	  // Looping through the supplied messages:
		for (var i = 0, len = aMessages.length; i < len; i++) {
		  var newMessage = aMessages[i];
		  var alreadyQueued = false;
		  // Making sure message is not already queued for Toast:
		  for (var j = this.aToasts.length; j >= 0; j--) {
			if (newMessage == this.aToasts[j]) {
			  alreadyQueued = true;
			  break;
			}
		  }
		  // Adding the message to the Toast queue:
		  if (!alreadyQueued) {
			this.aToasts.push(newMessage);
		  }
	  } // end supplied messages for-loop
	};
	
	/**
	 * This utility removes a Toast from the Array of messages still
	 * to be toasted.
	 * @private
	 */
	MessageBar.prototype.deleteToast = function(sId) {
	  if (!this.aToasts) {
		return;
	  }
	
	  // Checking if within the Toast queue:
		for (var j = 0, len = this.aToasts.length; j < len; j++) {
			if (this.aToasts[j].getId() == sId) {
				this.aToasts.splice(j, 1);
				return;
			}
		}
	};
	
	/**
	 * This utility removes one message, given its ID, from the possible
	 * message queues (Error, Warning, Success...).
	 * Messages always have an ID, since created via the "Message" Control.
	 * @private
	 */
	MessageBar.prototype.deleteOneMessage = function(sId) {
	  if (!sId) {
		return;
	  }
	
	  // Checking if within the Error queue:
		for (var j = 0, len = this.aErrors.length; j < len; j++) {
			if (this.aErrors[j].getId() == sId) {
			  this.aErrors[j].closeDetails();
				this.aErrors.splice(j, 1);
				return;
			}
		}
	
	  // Checking if within the Warning queue:
		for (var j = 0, len = this.aWarnings.length; j < len; j++) {
			if (this.aWarnings[j].getId() == sId) {
			  this.aWarnings[j].closeDetails();
				this.aWarnings.splice(j, 1);
				return;
			}
		}
	
	  // Checking if within the Success queue:
		for (var j = 0, len = this.aSuccesses.length; j < len; j++) {
			if (this.aSuccesses[j].getId() == sId) {
			  this.aSuccesses[j].closeDetails();
				this.aSuccesses.splice(j, 1);
				return;
			}
		}
	};
	
	/**
	 * This utility converts "Begin"/"End" into "Right"/"Left" coordinates,
	 * for RTL support.
	 * @private
	 */
	MessageBar.prototype.getSnapPoint = function() {
	  if (!this.snapPoint) {
		  this.snapPoint = this.getAnchorSnapPoint();
		  if (sap.ui.getCore().getConfiguration().getRTL()) {
			this.snapPoint = this.snapPoint.replace("begin", "right").replace("end", "left");
		  } else {
			this.snapPoint = this.snapPoint.replace("begin", "left").replace("end", "right");
		  }
	  }
	  return this.snapPoint;
	};
	
	/**
	 * This utility opens the MessageBar Popup.
	 * @private
	 */
	MessageBar.prototype.open = function() {
		// Defining or fetching the Popup attributes:
	  var animationDuration = 0;
	  var snapPoint = this.getSnapPoint();
	
		// Opening the MessageBar:
	  var anchor = null;
	  var anchorId = this.getAnchorID();
	  if (anchorId) {
		anchor = jQuery.sap.domById(anchorId);
	  }
	  if (!anchor) {
		anchor = document.body;
	  }
	  // Invoking the MsgBar Popup open function(iDuration, my, at, of, offset):
		this.oPopup.open(animationDuration, snapPoint, snapPoint, anchor, "0 0");
	
	  // Repositioning as per the Drop position:
	  if (this.oDropPosition) {
		  this.oPopup._$().css('top', this.oDropPosition.top);
			// Is the Bar to be positioned and dragged from its right-hand side???
			if (snapPoint.indexOf("right") != -1) {
				this.oPopup._$().css('right', this.oDropPosition.right);
			} else {
				this.oPopup._$().css('left', this.oDropPosition.left);
			}
	  }
	
	  // If closed with a list present, then we should still display it:
	  if (this.hasStyleClass("sapUiMsgBarOpen")) {
		this.oList.setVisible(true);
	  }
	};
	
	/**
	 * This utility closes the MessageBar Popup.
	 * @private
	 */
	MessageBar.prototype.close = function() {
	  // First closing the MessageList, if visible:
	  if (this.oList && this.oList.getVisible()) {
		this.oList.setVisible(false);
	  }
	
	  // Invoking the MsgBar Popup close = function(iDuration):
	  var animationDuration = 0;
		this.oPopup.close(animationDuration);
	
	  // Re-initializing flag along with the turning-off of the MessageBar:
	  this.maxToastsReached = false;
	};
	
	/**
	 * This utility updates the messageBar counters, and visibility.
	 * @private
	 */
	MessageBar.prototype.updateCountersAndVisibility = function() {
	  // If invisible, get out of here!
		if (!this.getProperty("visible")) {
			return;
		}
	
	  // Convenience variable
		var id = this.getId();
	
	  // Updating the Error Count and Visibility:
	  var oCount = jQuery.sap.domById(id + "__ErrorCount");
	  if (!oCount) {
		// The MessageBar has to be available on the DOM in order to update it!
		// This code is required as the MessageBar is first created.
		  this.open();
		oCount = jQuery.sap.domById(id + "__ErrorCount");
	  }
	  var count   = this.aErrors.length;
	  var oldText = oCount.innerHTML;
	  var newText = "(" + count + ")";
	  var jIcon   = null;
	  var jCount  = null;
	  if (newText != oldText) {
		// Have to directly update the DOM element:
		oCount.innerHTML = newText;
	
		if (newText == "(0)") {
		  // Allowing empty queues not to be displayed:
		  jIcon  = jQuery.sap.byId(id + "__ErrorImg");
		  jCount = jQuery.sap.byId(id + "__ErrorCount");
		  jIcon.addClass("sapUiMsgBarZeroCount");
		  jCount.addClass("sapUiMsgBarZeroCount");
		} else if (oldText == "(0)") {
		  // Displaying the non-empty queue:
		  jIcon  = jQuery.sap.byId(id + "__ErrorImg");
		  jCount = jQuery.sap.byId(id + "__ErrorCount");
		  jIcon.removeClass("sapUiMsgBarZeroCount");
		  jCount.removeClass("sapUiMsgBarZeroCount");
		}
	  }
	
	
	  // Updating the Warning Count and Visibility:
	  oCount  = jQuery.sap.domById(id + "__WarningCount");
	  count   = this.aWarnings.length;
	  oldText = oCount.innerHTML;
	  newText = "(" + count + ")";
	  jIcon   = null;
	  jCount  = null;
	  if (newText != oldText) {
		// Have to directly update the DOM element:
		oCount.innerHTML = newText;
	
		if (newText == "(0)") {
		  // Allowing empty queues not to be displayed:
		  jIcon  = jQuery.sap.byId(id + "__WarningImg");
		  jCount = jQuery.sap.byId(id + "__WarningCount");
		  jIcon.addClass("sapUiMsgBarZeroCount");
		  jCount.addClass("sapUiMsgBarZeroCount");
		} else if (oldText == "(0)") {
		  // Displaying the non-empty queue:
		  jIcon  = jQuery.sap.byId(id + "__WarningImg");
		  jCount = jQuery.sap.byId(id + "__WarningCount");
		  jIcon.removeClass("sapUiMsgBarZeroCount");
		  jCount.removeClass("sapUiMsgBarZeroCount");
		}
	  }
	
	
	  // Updating the Success Count and Visibility:
	  oCount  = jQuery.sap.domById(id + "__SuccessCount");
	  count   = this.aSuccesses.length;
	  oldText = oCount.innerHTML;
	  newText = "(" + count + ")";
	  jIcon   = null;
	  jCount  = null;
	  if (newText != oldText) {
		// Have to directly update the DOM element:
		oCount.innerHTML = newText;
	
		if (newText == "(0)") {
		  // Allowing empty queues not to be displayed:
		  jIcon  = jQuery.sap.byId(id + "__SuccessImg");
		  jCount = jQuery.sap.byId(id + "__SuccessCount");
		  jIcon.addClass("sapUiMsgBarZeroCount");
		  jCount.addClass("sapUiMsgBarZeroCount");
		} else if (oldText == "(0)") {
		  // Displaying the non-empty queue:
		  jIcon  = jQuery.sap.byId(id + "__SuccessImg");
		  jCount = jQuery.sap.byId(id + "__SuccessCount");
		  jIcon.removeClass("sapUiMsgBarZeroCount");
		  jCount.removeClass("sapUiMsgBarZeroCount");
		}
	  }
	
	
		// If the MessageBar is now empty, then it should become invisible:
		if (this.aErrors.length == 0 &&
			this.aWarnings.length == 0 &&
			this.aSuccesses.length == 0) {
		  // Hiding the MessageBar:
		  this.close();
		  return;
		} else {
		  // Showing the MessageBar:
		  this.open();
		}
	
		// If the MessageList is already open, updating it:
		if (this.oList && this.oList.getVisible()) {
			this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));
		}
	
	  // Checking for the next Toaster action:
		this.checkForToast();
	};
	
	/**
	 * This utility toggles the MessageList Popup.
	 * This function is invoked by clicking the front MessageBar Arrow.
	 * @private
	 */
	MessageBar.prototype.toggleList = function() {
	  // Creating the List, if not already done:
	  if (!this.oList) {
		var listId = this.getId() + "__List";
		  this.oList = new sap.ui.commons.MessageList(listId, {anchorId:this.getId(), maxListed:this.getMaxListed()});
	  }
	
	  // Retrieving the List current Open/Close information:
	  var visible  = this.oList.getVisible();
	
	  // Toggling the List, and adapting our styling:
	  if (!visible) {
		this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));
		this.addStyleClass("sapUiMsgBarOpen");
	  } else {
		this.removeStyleClass("sapUiMsgBarOpen");
	  }
	  this.oList.setVisible(!visible);
	};
	
	/**
	 * This utility restores the initial position of the MessageBar.
	 * @private
	 */
	MessageBar.prototype.backHome = function() {
	  // Instead of repositioning the List, we may as well just re-opening it once back home!
	  // Just like when it is the user that is D&D the Bar!
	  // This will also allow the List Popup to properly position itself (UP/DOWN).
	//this.oPopup.setPosition(sap.ui.core.Popup.Dock.LeftTop, {left:this.oHomePosition.left + "px", top: this.oHomePosition.top + "px"});
	  var jPopup = this.oPopup._$();
	  if (this.oList && this.oList.getVisible()) {
		this.toggleList();
		var that = this;
			// Is the Bar to be positioned and dragged from its right-hand side???
			if (this.snapPoint.indexOf("right") != -1) {
				jPopup.animate({right:this.oHomePosition.right + "px", top:this.oHomePosition.top + "px"}, 200, function() {that.toggleList();});
			} else {
				jPopup.animate({left:this.oHomePosition.left + "px", top:this.oHomePosition.top + "px"}, 200, function() {that.toggleList();});
			}
	  } else {
			// Is the Bar to be positioned and dragged from its right-hand side???
			if (this.snapPoint.indexOf("right") != -1) {
				jPopup.animate({right:this.oHomePosition.right + "px", top:this.oHomePosition.top + "px"}, 200);
			} else {
				jPopup.animate({left:this.oHomePosition.left + "px", top:this.oHomePosition.top + "px"}, 200);
			}
	  }
	
	  // MessageBar is back home:
	  this.oDropPosition = null;
	  // Hiding our "back-home" icon:
	  this.removeStyleClass("sapUiMsgBarMoved");
	};
	
	// #############################################################################
	// Public APIs
	// #############################################################################
	/**
	 * This public API adds/updates a supplied list of messages.
	 * The messageBar is to appear should at least one message exists.
	 * 
	 * @param {sap.ui.commons.Message[]} aAMessages Array of messages.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	MessageBar.prototype.addMessages = function(aMessages) {
	  if (!aMessages) {
		return;
	  }
	
	  // Looping through the supplied messages:
		for (var i = 0, len = aMessages.length; i < len; i++) {
		// First have to removing each message from the message queues,
		// in case this is an update that we are doing!
		// This approach allows for messages to change priority,
		// and for "updated" messages to get re-ordered, i.e.
		// the most recent ones are displayed first (on a given priority
		// level).
		this.deleteOneMessage(aMessages[i].getId());
	
		// Now, inserting each message into its proper queue:
		  switch (aMessages[i].getType()) {
			case sap.ui.commons.MessageType.Error:
			  // Adding the "new" Error message:
			this.aErrors.push(aMessages[i]);
			  break;
	
			case sap.ui.commons.MessageType.Warning:
			  // Adding the "new" Warning message:
			this.aWarnings.push(aMessages[i]);
			  break;
	
			case sap.ui.commons.MessageType.Success:
			  // Adding the "new" Success message:
			this.aSuccesses.push(aMessages[i]);
			  break;
	
			default:
			  jQuery.sap.log.debug("ERROR: MessageBar supplied messageType=" + aMessages[i].getType());
		  } // end switch
		} // end for
	
		// Adding the new messages to the toasting queue:
	  this.addToasts(aMessages);
	
		// Updating the messageBar:
		this.updateCountersAndVisibility();
	
		return this;
	};
	
	/**
	 * This public API deletes a supplied list of messages.
	 * The messageBar is to disappear should no message remains.
	 * 
	 * @param {string[]} aIds Messages IDs to be deleted.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	MessageBar.prototype.deleteMessages = function(aIds) {
	  if (!aIds) {
		return;
	  }
	
	  // Removing each message from their message queues, and toast queue:
		for (var i = 0, len = aIds.length; i < len; i++) {
		this.deleteOneMessage(aIds[i]);
		this.deleteToast(aIds[i]);
		} // end for
	
		// Updating the messageBar:
		this.updateCountersAndVisibility();
	
		return this;
	};
	
	/**
	 * Deletes all messages.
	 * 
	 * @returns {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
	 * 
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	MessageBar.prototype.deleteAllMessages = function() {
	  // Closing the corresponding Details if any:
		for (var j = this.aErrors.length - 1; j >= 0; j--) {
			this.aErrors[j].closeDetails();
		}
		for (var j = this.aWarnings.length - 1; j >= 0; j--) {
			this.aWarnings[j].closeDetails();
		}
		for (var j = this.aSuccesses.length - 1; j >= 0; j--) {
			this.aSuccesses[j].closeDetails();
		}
	
		// Empty all error queues:
	  this.aErrors    = [];
	  this.aWarnings  = [];
	  this.aSuccesses = [];
	  // Empty the Toasting queue:
	  this.aToasts    = [];
	
		// Updating the messageBar:
		this.updateCountersAndVisibility();
	
		return this;
	};
	
	
	
	// #############################################################################
	// Overwriting auto-generated methods of MessageBar.API.js
	// #############################################################################
	
	/**
	 * Setter for property <code>visible</code>.
	 *
	 * Default value is <code>true</code>
	 *
	 * The default implementation of function "setVisible()" is enhanced 
	 * in order to toggle the "visibility:hidden;" attribute over the control.
	 * 
	 * @param {boolean} bVisible  new value for property <code>visible</code>
	 * @return {sap.ui.commons.MessageBar} <code>this</code> to allow method chaining
	 * @public
	 */
	MessageBar.prototype.setVisible = function(bVisible) {
		this.setProperty("visible", bVisible);
	
	  if (bVisible) {
			// Updating and rendering the MessageBar:
			this.updateCountersAndVisibility();
	  } else {
		// Just closing the MessageBar:
		  this.close();
	  }
	
		return this;
	};

	return MessageBar;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MessageBar.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageList') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.MessageList.
jQuery.sap.declare('sap.ui.commons.MessageList'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MessageList",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup'],
	function(jQuery, library, Control, Popup) {
	"use strict";


	
	/**
	 * Constructor for a new MessageList.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Instantiated by the "MessageBar" Control if the user ever requests to generate the corresponding "MessageList".
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.4.0. 
	 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
	 * @alias sap.ui.commons.MessageList
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MessageList = Control.extend("sap.ui.commons.MessageList", /** @lends sap.ui.commons.MessageList.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * To open or close the Control.
			 */
			visible : {type : "boolean", group : "Behavior", defaultValue : false},
	
			/**
			 * Id of the anchor under which the MessageList is to render.
			 */
			anchorId : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * Maximum number of messages being display in the List before a scrollbar appears. Value '0' means no limit.
			 */
			maxListed : {type : "string", group : "Misc", defaultValue : '7'}
		}
	}});
	
	
	MessageList.prototype.init = function(){
		// Defining some private data:
		this.aMessages = [];
		this.iItemHeight = 0;
	
		// Popup(oContent, bModal, bShadow, bAutoClose) container initialization:
		// - bModal: "true/false" : For blocking the background window.
		this.oPopup   = new Popup(this, false, true, false);
	};
	
	/**
	 * Destroys this Control instance, called by Element#destroy()
	 * @private
	 */
	MessageList.prototype.exit = function() {
	  this.close();
	
		this.oPopup.destroy();
		this.oPopup = null;
	};
	
	/**
	 * Re-initializes the measurements, so all sizes are recalculated after a theme switch.
	 * @private
	 */
	MessageList.prototype.onThemeChanged = function () {
		this.iItemHeight = 0;
	};
	
	/**
	 * This utility checks to see if a scrollbar has to be rendered.
	 */
	MessageList.prototype.onAfterRendering = function () {
		var oList = this.getDomRef();
		var jList = jQuery(oList);
	
		// A scrollbar is only required over 7 items:
		var maxVisibleItems = this.getMaxListed();
		var len = this.aMessages.length;
		if (len <= maxVisibleItems) {
			// By default, css height was set to "20px" to make sure List would fit, for Popup to open.
			jList.height("auto");
			return;
		}
	
		// Calculating 1 item height:
		if (this.iItemHeight == 0) {
			var oItem = oList.firstChild;
			var jItem = jQuery(oItem);
			this.iItemHeight = jItem.height();
		}
	
		oList.style.overflowY = "scroll";
		oList.style.overflowX = "hidden";
		var desiredHeight = (maxVisibleItems * this.iItemHeight) + "px";
		jList.height(desiredHeight);
	};
	
	// #############################################################################
	// Internal Utilities
	// #############################################################################
	/**
	 * This utility opens the MessageList Popup.
	 */
	MessageList.prototype.open = function() {
		var rtl = sap.ui.getCore().getConfiguration().getRTL();
	
		// Defining or fetching the Popup attributes:
		var animationDuration = 200;
		var msgListSnapPoint = rtl ? Popup.Dock.RightTop    : Popup.Dock.LeftTop;
		var anchorSnapPoint  = rtl ? Popup.Dock.RightBottom : Popup.Dock.LeftBottom;
		var relativeAnchorPosition = "0 0";
		var anchor = null;
		var anchorId = this.getAnchorId();
		if (anchorId) {
			anchor = jQuery.sap.domById(anchorId);
		}
		if (!anchor) {
			anchor = document.body;
		}
		// Invoking the MsgBar Popup open function(iDuration, my, at, of, offset):
		this.oPopup.open(animationDuration, msgListSnapPoint, anchorSnapPoint, anchor, relativeAnchorPosition);
	};
	
	/**
	 * This utility closes the MessageList Popup.
	 */
	MessageList.prototype.close = function() {
		// Invoking the MsgBar Popup close = function(iDuration):
		var animationDuration = 200;
		this.oPopup.close(animationDuration);
	};
	
	/**
	 * Set the list of Messages to be displayed and re-render this Control if visible.
	 *
	 * @param {sap.ui.commons.Message[]} aMessages Message list.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	MessageList.prototype.setMessages = function(aMessages) {
		// Storing the Messages:
		this.aMessages = aMessages;
	
		// Re-rendering this MessageList if visible:
		if (this.getVisible()) {
			sap.ui.getCore().getRenderManager().render(this, sap.ui.getCore().getStaticAreaRef(), true);
		}
	
		return this;
	};
	
	
	// #############################################################################
	// Overwriting auto-generated methods of MessageList.API.js
	// #############################################################################
	
	/**
	 * Setter for property <code>visible</code>.
	 *
	 * Default value is <code>true</code>
	 *
	 * The default implementation of function "setVisible()" is overwritten 
	 * in order to invoke the open() and close() of the MessageList Popup.
	 * 
	 * @param {boolean} bVisible  new value for property <code>visible</code>
	 * @return {sap.ui.commons.MessageList} <code>this</code> to allow method chaining
	 * @public
	 */
	MessageList.prototype.setVisible = function(bVisible) {
		this.setProperty("visible", bVisible);
	
		// Opening or closing the MessageBar, as requested:
		if (bVisible) {
		// Re-rendering, in case content is new.
		sap.ui.getCore().getRenderManager().render(this, sap.ui.getCore().getStaticAreaRef(), true);
			this.open();
		} else {
			this.close();
		}
	
		return this;
	};

	return MessageList;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MessageList.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.MessageToast') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.MessageToast.
jQuery.sap.declare('sap.ui.commons.MessageToast'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-core'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/MessageToast",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/thirdparty/jqueryui/jquery-ui-core'],
	function(jQuery, library, Control, jqueryuicore) {
	"use strict";


	
	/**
	 * Constructor for a new MessageToast.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Responsible for displaying the new incoming messages, one at the time, on top of the MessageBar.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.4.0. 
	 * A new messaging concept will be created in future. Therefore this control might be removed in one of the next versions.
	 * @alias sap.ui.commons.MessageToast
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var MessageToast = Control.extend("sap.ui.commons.MessageToast", /** @lends sap.ui.commons.MessageToast.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Id of the anchor on top of which the MessageToast is to render.
			 */
			anchorId : {type : "string", group : "Misc", defaultValue : null}
		},
		events : {
	
			/**
			 * Fired once the "toast()" method is over, so that the MessageBar can toast() another message if needed.
			 */
			next : {}
		}
	}});
	
	
	MessageToast.prototype.init = function(){
		// Local variables...
		this.oMessage    = null;
		this.sAnchorId   = "";
		this.bIdle       = true;
		this.sLeftOffset = "";
	
		// Popup(oContent, bModal, bShadow, bAutoClose) container initialization:
		// - oModal: "true/false" : For blocking the background window.
		// - bShadow: "false" as the MessageBar Popup is displayed without shadow in all themes.
		//            Shadow is added but not at the Popup level because in contains a down-arrow.
		//            Therefore the shadow is added to an inner container, excluding this down-arrow.
		this.oPopup   = new sap.ui.core.Popup(this, false, false, false);
		// Asking the Popup to fire our "next" event once a "toast()" is over.
		this.oPopup.attachClosed(this.next, this);
	};
	
	/**
	 * Destroys this Control instance, called by Element#destroy()
	 * @private
	 */
	MessageToast.prototype.exit = function() {
	  if (!this.bIdle) {
		this.close();
	  }
	
		this.oPopup.destroy();
		this.oPopup = null;
	};
	
	/**
	 * This utility makes sure that the Toast is pointing down towards
	 * the right MessageBar Icon.
	 * @private
	 */
	MessageToast.prototype.onAfterRendering = function(){
	  // The MessageToast and the MessageBar are right-aligned.
	  // The MessageToast has a minWidth matching that of the MessageBar.
	  // (That allows us to position the down-arrow without moving the MessageToast.)
	  // The MessageToast Arrow aligns towards the proper MessageBar Icon.
	
	  var rtl = sap.ui.getCore().getConfiguration().getRTL();
	
	  // 1) Calculating the distance between the Icon and the right side of its MessageBar container:
	  var jIcon = jQuery.sap.byId(this.sAnchorId); // Anchor against which our Arrow has to align
	//if (!jIcon) return;
	  var iconPosition  = jIcon.position();
	  var jBar = jQuery.sap.byId(this.getAnchorId()); // Anchor against which our Toast has to align
	//if (!jBar) return;
	  var barWidth = jBar.outerWidth();
	  if (iconPosition) {
		  var targetRightOffset = rtl ? iconPosition.left + jIcon.outerWidth()
									  : barWidth - iconPosition.left;
	
	
		  // 2) Calculating the default distance between the Arrow and the right side of our Toast:
			var jToast = this.$();  // = jQuery.sap.byId(this.getId());
		  var toastWidth = jToast.width();
		  var defaultArrowRightOffset = Math.max(toastWidth,barWidth);
	
		  // 3) Taking care of too-small a Toast:
		  var delta = barWidth - toastWidth;
			if (delta > 0) {
			// Making the Toast as wide as the Bar:
			jToast.css('minWidth', barWidth);
			}
	
		  // 4) Now, we need to move our Arrow right, by what is missing:
		  var moveRightOffset = rtl ? (defaultArrowRightOffset - targetRightOffset + 2) + "px"
									: (defaultArrowRightOffset - targetRightOffset - 2) + "px";
			if (defaultArrowRightOffset >= targetRightOffset) {
			var jArrow = jQuery.sap.byId(this.getId() + "Arrow");
			if (sap.ui.getCore().getConfiguration().getRTL()) {
				jArrow.css('marginRight', moveRightOffset); // Positive padding
			} else {
				jArrow.css('marginLeft', moveRightOffset); // Positive padding
			}
			// Our right-alignment can stay:
			this.sLeftOffset = "0";
			}
		}
	};
	
	// #############################################################################
	// Internal Utilities
	// #############################################################################
	/**
	 * Our popup-close callback function.
	 * Registers the fact that a toast just completed, and fires our "next" event.
	 * @private
	 */
	MessageToast.prototype.next = function(){
		// Toast done (allows for smooth toasting):
	  this.bIdle = true;
	  this.fireNext();
	}
	
	/**
	 * This utility opens the MessageToast Popup.
	 * @private
	 */;
	MessageToast.prototype.open = function(iDuration) {
		// For Multiple Messages, 1st we need to close the existing toast:
	  if (!this.bIdle) {
		this.oPopup.close(0);
	  }
	
		// Toast start (allows for no interruption):
	  this.bIdle = false;
	
	  var rtl = sap.ui.getCore().getConfiguration().getRTL();
	
		// Defining or fetching the Popup attributes:
	  var popupSnapPoint  = rtl ? sap.ui.core.Popup.Dock.LeftBottom : sap.ui.core.Popup.Dock.RightBottom;
	  var anchorSnapPoint = rtl ? sap.ui.core.Popup.Dock.LeftTop    : sap.ui.core.Popup.Dock.RightTop;
	  var relativeAnchorPosition = this.sLeftOffset + " 5";
	  var anchor = null;
	  var anchorId = this.getAnchorId();
	  if (anchorId) {
		anchor = jQuery.sap.domById(anchorId);
	  }
	  if (!anchor) {
		anchor = document.body;
	  }
	  // Invoking the MsgBar Popup open function(iDuration, my, at, of, offset):
	  this.oPopup.open(iDuration, popupSnapPoint, anchorSnapPoint, anchor, relativeAnchorPosition);
	};
	
	/**
	 * This utility closes the MessageToast Popup.
	 * @private
	 */
	MessageToast.prototype.close = function(iDuration) {
	  // Invoking the Popup close = function(iDuration):
	  this.oPopup.close(iDuration);
	};
	
	/**
	 * This utility returns the class of the MessageToast container,
	 * which changes according to the displayed message TYPE/PRIORITY
	 * to allow for "semantic" rendering.  :-)
	 * @private
	 */
	MessageToast.prototype.getClasses = function() {
	  // By default assuming the "Multiple new messages..." css:
	  var css = "sapUiMsgToast";
	  // Allow for specializing as per the message Type:
	  if (this.oMessage && this.oMessage.getType()) {
		css += " sapUiMsgT" + this.oMessage.getType();
	  }
	  return css;
	};
	
	// #############################################################################
	// Public APIs
	// #############################################################################
	/**
	 * This public API receives the list of Messages to be displayed,
	 * and re-render this Control if visible.
	 * 
	 * Triggers the toasting of a message, on top of the MessageBar.
	 * If no message is supplied, displays the "Multiple new messages..." message.
	 *
	 * @param {sap.ui.commons.Message} oMessage
	 *         The Message to be toasted.
	 * @param {string} sAnchorId
	 *         DOM ID of the anchor against which the Toast Arrow should align for a given Toast.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	MessageToast.prototype.toast = function(oMessage, sAnchorId) {
	  // Storing the supplied data:
		this.oMessage = oMessage;
		this.sAnchorId = sAnchorId;
	  // Render according to new message, and animate:
		sap.ui.getCore().getRenderManager().render(this, sap.ui.getCore().getStaticAreaRef(), true);
	  this.open(750);
	  this.close(2250); // <-- CAN BE COMMENTED OUT WHILE STYLING THE TOAST...
	
		return this;
	};
	
	/**
	 * Returns true if no message is being toasted.
	 *
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	MessageToast.prototype.isIdle = function() {
	  return this.bIdle;
	};

	return MessageToast;

}, /* bExport= */ true);

}; // end of sap/ui/commons/MessageToast.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Paginator') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Paginator.
jQuery.sap.declare('sap.ui.commons.Paginator'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Paginator",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";



	/**
	 * Constructor for a new Paginator.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Provides navigation between pages within a list of numbered pages.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Paginator
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Paginator = Control.extend("sap.ui.commons.Paginator", /** @lends sap.ui.commons.Paginator.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Represents the current page (first page has index 1, not 0, to match the visual number)
			 */
			currentPage : {type : "int", group : "Misc", defaultValue : 1},

			/**
			 * Represents the overall number of pages that are embedded into the parent control
			 */
			numberOfPages : {type : "int", group : "Misc", defaultValue : null}
		},
		events : {

			/**
			 * Event is fired when the user navigates to another page by selecting it directly, or by jumping forward/backward.
			 */
			page : {
				parameters : {

					/**
					 * The page which is the current one before the page event is fired (and another page is displayed)
					 */
					srcPage : {type : "int"},

					/**
					 * The page that shall be displayed next after the page event is fired.
					 *
					 * The page number is 1-based: the first page has index 1, not 0, to match the number visible in the UI.
					 */
					targetPage : {type : "int"},

					/**
					 * Provides the values 'First', 'Last', 'Next', 'Previous', 'Goto'. The event parameter informs the application
					 * how the user navigated to the new page: Whether the 'Next' button was used, or another button, or whether the page was directly
					 * selected
					 */
					type : {type : "sap.ui.commons.PaginatorEvent"}
				}
			}
		}
	}});

	/*
	 * All animations of the Paginator control can be centrally switched
	 * off by setting the <code>bShowAnimation</code> flag to <code>false</code>.
	 * @private
	 */

	// Constants declaration
	Paginator.MAX_NUMBER_PAGES = 5;

	/**
	 * Init function
	 * @private
	 */
	Paginator.prototype.init = function(){
		//Animations are set to true by default, then on control initialization, check the number of pages
		this.bShowAnimation = true;
	};


	/**
	 * When the user clicks on a page link, we navigae to that page, either with animation or with rerendering
	 * @param {jQuery.Event} oEvent The current event
	 * @private
	 */
	Paginator.prototype.onclick = function(oEvent){
		if (oEvent && oEvent.target) {

			// Supress triggering beforeunload in IE
			oEvent.preventDefault();

			// go up one node if unnamed element is the source
			var target = oEvent.target;
			if (!target.id) {
				target = target.parentNode;
			}

			if (target.id && target.id != this.getId() + "-pages") {

				// Retrieve from where the event originated
				var aArray = target.id.split("--");

				// only do something if relevant item has been clicked
				if (aArray.length > 1) {
					var lastPart = aArray[aArray.length - 1];

					// What type of event will be sent
					var sEventType = null;

					// Buffer the current page as the sourcePage
					var iSrcPage = this.getCurrentPage();
					var iTargetPage = iSrcPage; // will be changed below

					// we have a number - a page has been clicked
					if (lastPart.match(/^\d+$/)) {
						sEventType = sap.ui.commons.PaginatorEvent.Goto;
						iTargetPage = parseInt(lastPart, 10);

					} else if (lastPart == "firstPageLink") {
						sEventType = sap.ui.commons.PaginatorEvent.First;
						iTargetPage = 1;

					} else if (lastPart == "backLink") {
						sEventType = sap.ui.commons.PaginatorEvent.Previous;
						iTargetPage = Math.max(iSrcPage - 1, 1);

					} else if (lastPart == "forwardLink") {
						sEventType = sap.ui.commons.PaginatorEvent.Next;
						iTargetPage = Math.min(iSrcPage + 1, this.getNumberOfPages());

					} else if (lastPart == "lastPageLink") {
						sEventType = sap.ui.commons.PaginatorEvent.Last;
						iTargetPage = this.getNumberOfPages();

					} // else should not happen

					if (iTargetPage != iSrcPage) {
						if (this.bShowAnimation) {
							this.setCurrentPage(iTargetPage, true); // update current page without re-rendering...
							this.triggerPaginatorAnimation(); // ...and animate
						} else {
							this.setCurrentPage(iTargetPage); // includes re-rendering
						}

						// fire the "page" event
						this.firePage({srcPage:iSrcPage,targetPage:iTargetPage,type:sEventType});
					}
				}
			}
		}
	};

	Paginator.prototype.setCurrentPage = function(iTargetPage, bSuppressRerendering) {
		this.setProperty("currentPage", iTargetPage, bSuppressRerendering);
		if (this.getDomRef()) {
			sap.ui.commons.PaginatorRenderer.updateBackAndForward(this);
		}
	};

	/**
	 * When animation is set to true, this function will use jQuery to animate the paginator
	 * as if the page numbers were sliding left/right.
	 * @private
	 */
	Paginator.prototype.triggerPaginatorAnimation = function() {
		var aIndicesToHide = [];
		var aIndicesToShow = [];
		var paginatorId = this.getId();
		var aChildren = jQuery.sap.byId(paginatorId + "-pages").children();

		// Get the ranges we need to display before and after the animation
		var oNewRange = this._calculatePagesRange();
		var oOldRange;
		if (this._oOldRange) {
			oOldRange = this._oOldRange;
		} else {
			oOldRange = {};
			var aParts = aChildren[0].id.split("--");
			oOldRange.firstPage = parseInt(aParts[aParts.length - 1], 10);
			aParts = aChildren[aChildren.length - 1].id.split("--");
			oOldRange.lastPage = parseInt(aParts[aParts.length - 1], 10);
		}

		// the pages to be shown only after the animation are those to be rendered invisible, initially
		for (var i = oNewRange.firstPage; i <= oNewRange.lastPage; i++) {
			if (i < oOldRange.firstPage || i > oOldRange.lastPage) {
				aIndicesToShow.push(i);
			}
		}
		var oInvisibleRange = {
				firstPage:aIndicesToShow[0],
				lastPage:aIndicesToShow[aIndicesToShow.length - 1]
		};

		// the pages to be shown initially, but NOT after the animation, are those to fade out
		for (var i = oOldRange.firstPage; i <= oOldRange.lastPage; i++) {
			if (i < oNewRange.firstPage || i > oNewRange.lastPage) {
				aIndicesToHide.push(i);
			}
		}

		// build the html for both the initially visible and still invisible pages
		var oldHtml = sap.ui.commons.PaginatorRenderer.getPagesHtml(this.getId(), oOldRange, this.getCurrentPage(), true);
		var newHtml = sap.ui.commons.PaginatorRenderer.getPagesHtml(this.getId(), oInvisibleRange, this.getCurrentPage(), false);
		if (oOldRange.firstPage < oInvisibleRange.firstPage) {
			newHtml = oldHtml + newHtml;
		} else {
			newHtml = newHtml + oldHtml;
		}


		// remember focus
		var focElem = document.activeElement;
		var focId = focElem ? focElem.id : undefined; // remember ID of focused element - it should still be focused after rendering

		this.getDomRef("pages").innerHTML = newHtml;

		// restore focus
		if (focId) {
			// Set focus on the previously focused element.
			// jQuery does not like document.activeElement, so we have to fetch it
			// from the DOM again.
			focElem = jQuery.sap.domById(focId);
		} else {
			// Set focus to active page link if no other element was active before
			focElem = jQuery.sap.domById("testPaginator-a--" + this.getCurrentPage());
		}

		jQuery.sap.focus(focElem);


		// Use jQuery hide/show to animate the paging
		var prefix = this.getId() + "-li--";

		this._oOldRange = oNewRange;

		function removeAfterAnimation(){ // remove the DOM elements after the animation
			var elem = jQuery.sap.domById(this.id);
			if (elem) {
				elem.parentNode.removeChild(elem);
			}
		}

		for (var i = 0 ; i < aIndicesToHide.length; i++) {
			var id = prefix + aIndicesToHide[i];
			jQuery.sap.byId(id).hide(400, removeAfterAnimation);
		}

		for (var i = 0 ; i < aIndicesToShow.length; i++) {
			jQuery.sap.byId(prefix + aIndicesToShow[i]).show(400);
		}
	};


	/**
	 * Calculates what is the first page and last page to display (The current range).
	 * Ensure that when we go over 5 pages, the current page will always be rendered centered
	 * In this case, middle -2 and middle + 2 to get to full 5 pages range
	 * @return {object} oPageRange object containing first page and last page to display
	 * @private
	 */
	Paginator.prototype._calculatePagesRange = function(){

		//Setting default values
		var iFirstPage = 1;
		var iLastPage = this.getNumberOfPages();
		var iCurrentPage = this.getCurrentPage();
		var iNbPages = this.getNumberOfPages();

		//From page 1 to page 5, we display 1 to 10 or less
		if ( iCurrentPage < 4 ) {

			iFirstPage = 1;

			//Check if last page does not go over 5 --> iLastPage is already set with nbPages above
			if (iLastPage > Paginator.MAX_NUMBER_PAGES) {
				iLastPage = Paginator.MAX_NUMBER_PAGES;
			}

		} else { //Now, the current page is more than 3, so we need to shift the range

			//Reached the last page
			if (iCurrentPage == iLastPage) {
				//How many pages exist, if less than 5, simply substract the nb of pages from the last one (range is in this case 1 to max 5)
				if (iNbPages < 5) {
					iFirstPage = 1;
				} else { //More than 5 pages, substract 4 pages to have the 5 pages range
					iFirstPage = iLastPage - 4;
				}
			} else if ( iLastPage - iCurrentPage < 3 ) {
				//Last page - current page is below 3, substract 4 to always see the right range for the last 2 pages
				iFirstPage = iLastPage - 4;
			} else { //All other case, create the range from the current page +-2
				iFirstPage = iCurrentPage - 2;
				iLastPage = iCurrentPage + 2;
			}
		}

		return { firstPage : iFirstPage, lastPage : iLastPage };
	};


	/**
	 * @param {jQuery.Event} oEvent the browser event
	 * @private
	 */
	Paginator.prototype.onkeydown = function(oEvent){

		//Get the event type and dispatch to the keyboard navigation manager
		var aEvents = oEvent.getPseudoTypes();

		//Tab
		if (jQuery.inArray("saptabnext", aEvents) != -1) {
			this.triggerTabbingNavigation(oEvent,false);
		} else if (jQuery.inArray("saptabprevious", aEvents) != -1) {
			//Shift/tab
			this.triggerTabbingNavigation(oEvent,true);
		} else if (jQuery.inArray("sapincrease", aEvents) != -1) {
			//Moves focus to the right (Right arrow key)
			this.triggerInternalNavigation(oEvent,"next");
		} else if (jQuery.inArray("sapdecrease", aEvents) != -1) {
			//Moves focus to the left (Left arrow key)
			this.triggerInternalNavigation(oEvent,"previous");
		}

	};


	/**
	 * This function will navigate left and right in the paginator, skipping non tabbable elements
	 * @param {jQuery.Event} oEvent the browser event
	 * @param {string} sDirection Navigation left or right
	 * @private
	 */
	Paginator.prototype.triggerInternalNavigation = function(oEvent,sDirection){

		var aFocusableElements = jQuery(this.getDomRef()).find(":sapFocusable");
		var iCurrentIndex = jQuery(aFocusableElements).index(oEvent.target);

		//Right key pressed
		if (sDirection == "next") {
			var iNextIndex = iCurrentIndex + 1;
			if (jQuery(oEvent.target).hasClass("sapUiPagCurrentPage")) {
				iNextIndex = iNextIndex + 1;
			}
			var oNextElement = aFocusableElements[iNextIndex];
			if (oNextElement) {
				jQuery(oNextElement).focus();
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		} else if (sDirection == "previous" && aFocusableElements[iCurrentIndex - 1]) {
			//Left key pressed
			var iNextIndex = iCurrentIndex - 1;
			var oNextElement = aFocusableElements[iNextIndex];
			if (oNextElement && jQuery(oNextElement).hasClass("sapUiPagCurrentPage")) {
				oNextElement = aFocusableElements[iNextIndex - 1];
			}
			if (oNextElement) {
				jQuery(oNextElement).focus();
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		}

	};

	/**
	 * This function will handle the TAB key in the paginator (simple group)
	 * @param {jQuery.Event} oEvent the browser event
	 * @param {boolean} shiftKeyPressed Tabbing or shift-Tabbing
	 * @private
	 */
	Paginator.prototype.triggerTabbingNavigation = function(oEvent,shiftKeyPressed){

		//Get all focusable elements
		var aFocusableElements = jQuery(this.getDomRef()).find(":sapFocusable");

		//Tabbing --> Focus the last active element then let the browser focus the next active element
		if (!shiftKeyPressed) {
			jQuery(aFocusableElements[aFocusableElements.length - 1]).focus();
		} else { //Shift/Tab keys pressed --> Focus the 2nd active element then let the browser focus the first active element

			//Which element triggered the event
			var iCurrentIndex = jQuery(aFocusableElements).index(oEvent.target);

			//If the focus is already on the first active element, let the browser move the focus
			if (iCurrentIndex != 0) {
				jQuery(aFocusableElements[0]).focus();
			}
		}
	};

	Paginator.prototype.getFocusInfo = function() {
		var sId = this.$().find(":focus").attr("id");
		if (sId) {
			return {customId: sId};
		} else {
			return sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
		}
	};

	Paginator.prototype.applyFocusInfo = function(mFocusInfo) {
		if (mFocusInfo && mFocusInfo.customId) {
			this.$().find("#" + mFocusInfo.customId).focus();
		} else {
			sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
		}
		return this;
	};




	return Paginator;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Paginator.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Panel') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Panel.
jQuery.sap.declare('sap.ui.commons.Panel'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Panel",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new Panel.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Represents a container with scroll functionality, the control can be used for text and controls. The Panel does not layout the embedded controls.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Panel
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Panel = Control.extend("sap.ui.commons.Panel", /** @lends sap.ui.commons.Panel.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Panel width in CSS size
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
	
			/**
			 * Per default, the height for the Panel is automatically adjusted to the content. Dimension allows to explicitly specify the height.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * Represents the state of the of the Panel (enabled or disabled)
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Specifies the scroll position from left to right. Value "0" means leftmost position.
			 */
			scrollLeft : {type : "int", group : "Behavior", defaultValue : 0},
	
			/**
			 * Specifies the scroll position from top to bottom. Value "0" means topmost position.
			 */
			scrollTop : {type : "int", group : "Behavior", defaultValue : 0},
	
			/**
			 * Padding is theme-dependent.
			 */
			applyContentPadding : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * A collapsed Panel consumes less space than a not collapsed one. When it is initially collapsed, the contents are not rendered.
			 */
			collapsed : {type : "boolean", group : "Behavior", defaultValue : false},
	
			/**
			 * Defines the background color. Note that color settings are theme-dependent.
			 */
			areaDesign : {type : "sap.ui.commons.enums.AreaDesign", group : "Appearance", defaultValue : sap.ui.commons.enums.AreaDesign.Fill},
	
			/**
			 * The Panel can have a box as border. Note that displaying borders is theme-dependent.
			 */
			borderDesign : {type : "sap.ui.commons.enums.BorderDesign", group : "Appearance", defaultValue : sap.ui.commons.enums.BorderDesign.Box},
	
			/**
			 * Specifies whether the Panel shall have an icon for collapsing/expanding, or not.
			 */
			showCollapseIcon : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Can be used to create a simple title text for Panels that do not require an icon in the header.
			 */
			text : {type : "string", group : "Misc", defaultValue : null}
		},
		defaultAggregation : "content",
		aggregations : {
	
			/**
			 * Aggregates the controls that are contained in the Panel. It is recommended to use a layout control as single direct child.
			 * When the Panel dimensions are set, the child control may have width and height of 100%. When the dimensions are not set, the child defines
			 * the Panel size.
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
	
			/**
			 * Aggregates the title element of the Panel. For text titles only, you alternatively could use setText() which also creates a title in the background.
			 */
			title : {type : "sap.ui.core.Title", multiple : false}, 
	
			/**
			 * The buttons that shall be displayed in the Panel header
			 */
			buttons : {type : "sap.ui.commons.Button", multiple : true, singularName : "button"}
		}
	}});
	
	
	/**
	 * Initialization
	 * @private
	 */
	Panel.prototype.init = function() {
		this._oScrollDomRef = null;       // points to the content area
		this._iMaxTbBtnWidth = -1;        // the maximum width of all toolbar buttons (when there are any, else -1)
		this._iTbMarginsAndBorders = 0;
		this._iMinTitleWidth = 30;        // the minimum width of the title span
		this._iOptTitleWidth = 30;
		this._iTitleMargin = 0;
		this._bFocusCollapseIcon = false; // indicates whether the collapse icon should be focused after the next rendering
		this._resizeDelayTimer = null;    // the timer for delayed reaction to resize events in browsers not supporting FlexBox layout
		this._rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
		
		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};
	
	Panel.prototype.exit = function() {
		this._rb = undefined;
	};
	
	/**
	 * Called after the theme has been switched: adjust sizes
	 * @private
	 */
	Panel.prototype.onThemeChanged = function () {
		if (this.getDomRef() && this._oTitleDomRef) { // only if already rendered and if a real Panel (no subclass like Tab)
	
			// reset size settings done for previous theme, so elements take their optimum space
			this.getDomRef().style.minWidth = "auto";
			if (this._oToolbarDomRef) {
				this._oToolbarDomRef.style.width = "auto";
			}
			this._oTitleDomRef.style.width = "auto";
	
			// adapt sizes
			this._initializeSizes(); // TODO: delay this for Safari?
			if (!jQuery.support.flexBoxLayout ||
					(Panel._isSizeSet(this.getHeight()) && (this._hasIcon() || (this.getButtons().length > 0)))) {
				this._handleResizeNow();
			}
		}
	};
	
	
	/**
	 * Event unbinding
	 * @private
	 */
	Panel.prototype.onBeforeRendering = function() {
		// Deregister resize event before re-rendering
		if (this.sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};
	
	
	/**
	 * Adapts size settings of the rendered HTML
	 * @private
	 */
	Panel.prototype.onAfterRendering = function () {
		var id = this.getId();
		this._oScrollDomRef = jQuery.sap.domById(id + "-cont");
		if (!this._oScrollDomRef) {
			return;
		} // BugFix for TwoGo where the DomRefs were not there after rendering
		this._oHeaderDomRef = jQuery.sap.domById(id + "-hdr");
		this._oTitleDomRef = jQuery.sap.domById(id + "-title");
		this._oToolbarDomRef = jQuery.sap.domById(id + "-tb");
	
		// restore focus if required
		if (this._bFocusCollapseIcon) {
			this._bFocusCollapseIcon = false;
			var $collArrow = jQuery.sap.byId(id + "-collArrow");
			if ($collArrow.is(":visible") && ($collArrow.css("visibility") == "visible" || $collArrow.css("visibility") == "inherit")) {
				$collArrow.focus();
			} else {
				var $collIco = jQuery.sap.byId(id + "-collIco");
				if ($collIco.is(":visible") && ($collIco.css("visibility") == "visible" || $collIco.css("visibility") == "inherit")) {
					$collIco.focus();
				}
			}
		}
	
		this._initializeSizes(); // TODO: delay this for Safari?
	
		// in browsers not supporting the FlexBoxLayout we need to listen to resizing
		if (!jQuery.support.flexBoxLayout ||
				(Panel._isSizeSet(this.getHeight()) && (this._hasIcon() || (this.getButtons().length > 0)))) {
			this._handleResizeNow();
			this.sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(), jQuery.proxy(this._handleResizeSoon, this));
		}
	};
	
	
	/**
	 *
	 * @protected
	 */
	Panel.prototype.getFocusInfo = function () {
		var collId = null;
		var id = this.getId();
	
		// if collapse icon needs to be focused, find out which one - if any - is currently visible
		if (this._bFocusCollapseIcon) {
			var $collArrow = jQuery.sap.byId(id + "-collArrow");
			if ($collArrow.is(":visible") && ($collArrow.css("visibility") == "visible" || $collArrow.css("visibility") == "inherit")) {
				collId = $collArrow[0].id;
			} else {
				var $collIco = jQuery.sap.byId(id + "-collIco");
				if ($collIco.is(":visible") && ($collIco.css("visibility") == "visible" || $collIco.css("visibility") == "inherit")) {
					collId = $collIco[0].id;
				}
			}
	
		}
	
		// if a collapse icon is visible and to be focused, return its ID, otherwise just the control ID
		return {id:(collId ? collId : id)};
	};
	
	
	/**
	 *
	 * @private
	 */
	Panel.prototype.applyFocusInfo = function (oFocusInfo) {
		var $DomRef;
		if (oFocusInfo && oFocusInfo.id && ($DomRef = jQuery.sap.byId(oFocusInfo.id)) && ($DomRef.length > 0)) {
			$DomRef.focus();
		} else {
			this.focus();
		}
		return this;
	};
	
	
	/**
	 * Measures and calculates/sets sizes as soon as the CSS has been applied after rendering or a theme switch
	 * @private
	 */
	Panel.prototype._initializeSizes = function() {
		var bRtl = sap.ui.getCore().getConfiguration().getRTL();
	
		// maximum width of a toolbar item -> min toolbar width
		var aButtons = this.getButtons();
		if (aButtons && aButtons.length > 0) {
			var maxWidth = 0;
			jQuery(this._oToolbarDomRef).children().each(function(){
				var width = this.offsetWidth;
				if (width > maxWidth) {
					maxWidth = width;
				}
			});
			this._iMaxTbBtnWidth = maxWidth;
	
			if (this._oToolbarDomRef) {
				this._oToolbarDomRef.style.minWidth = maxWidth + "px";
	
				// calculate the toolbar borders and margins
				var $tb = jQuery(this._oToolbarDomRef);
				this._iTbMarginsAndBorders = $tb.outerWidth(true) - $tb.width();
			}
		}
	
		// calculate available space between left- and right-aligned items with static width
		var beginBorderOfTitle = this._oTitleDomRef.offsetLeft; // displacement of the beginning of the title from the Panel border
		var totalWidth = this.getDomRef().offsetWidth;
		if (bRtl) {
			beginBorderOfTitle = totalWidth - (beginBorderOfTitle + this._oTitleDomRef.offsetWidth); // RTL case
		}
		var $title = jQuery(this._oTitleDomRef);
		this._iOptTitleWidth = $title.width() + 1 /*+1 to avoid subpixel issues*/;
		this._iTitleMargin = $title.outerWidth(true) - $title.outerWidth();
		var beginBorderOfRightItems = 10000;
		jQuery(this._oHeaderDomRef).children(".sapUiPanelHdrRightItem").each(function(){
			var begin = this.offsetLeft;
			if (bRtl) {
				begin = totalWidth - (begin + this.offsetWidth); // RTL case
			}
			if ((begin < beginBorderOfRightItems) && (begin > 0)) {
				beginBorderOfRightItems = begin;
			}
		});
	
	
		// set minimum Panel width as sum of minimum sizes
		var minWidth = beginBorderOfTitle;
		minWidth += this._iMinTitleWidth; // 30px is ok even if there is no title
		minWidth += this._iMaxTbBtnWidth + 1; // -1 if there is no toolbar... 1px more or less is no problem here
		minWidth += (beginBorderOfRightItems == 10000) ? 10 : (totalWidth - beginBorderOfRightItems); // use 10 as hardcoded right border
		this.getDomRef().style.minWidth = minWidth + 10 + "px";
	
	
		// restore scroll positions
		if (this._oScrollDomRef) {
			var scrollTop = this.getProperty("scrollTop");
			if (scrollTop > 0) {
				this._oScrollDomRef.scrollTop = scrollTop;
			}
			var scrollLeft = this.getProperty("scrollLeft");
			if (scrollLeft > 0) {
				this._oScrollDomRef.scrollLeft = scrollLeft;
			}
	
		}
	
	};
	
	
	/**
	 * Adapts the absolute position of the content when height is set.
	 * @private
	 */
	Panel.prototype._fixContentHeight = function() {
		//if height is set and an icon or at least one toolbar button is present (which *could* inflate the header height), the cont top must be set to the header height
		if (Panel._isSizeSet(this.getHeight()) && (this._hasIcon() || (this.getButtons().length > 0))) { // TODO: what if the icon is not yet loaded?
			this._iContTop = this._oHeaderDomRef.offsetHeight;
			if (this._oScrollDomRef) {
				this._oScrollDomRef.style.top = this._iContTop + "px";
			}
		}
	};
	
	
	/**
	 * Called in browsers not supporting the FlexBox layout whenever the Panel size is changing. This method registers a delayed reaction to the size changes.
	 * When there are further size changes during this delay, the delay starts from zero. So the Panel is not adapted during the resize, but only after resizing has
	 * completed. This should fix most of the related performance issues.
	 * @private
	 */
	Panel.prototype._handleResizeSoon = function() {
		if (this._resizeDelayTimer) {
			jQuery.sap.clearDelayedCall(this._resizeDelayTimer);
		}
	
		this._resizeDelayTimer = jQuery.sap.delayedCall(200, this, function() {
			this._handleResizeNow();
			this._resizeDelayTimer = null;
		});
	};
	
	
	/**
	 * Called in browsers not supporting the FlexBox layout whenever the Panel size has changed and the header layout finally needs to be adapted.
	 * Basically this method imitates that layout's behavior.
	 * @private
	 */
	Panel.prototype._handleResizeNow = function() {
		// in IE8 (maybe also IE9) the sizes of the flexible items (title and toolbar) need to be adjusted
		// whenever the Panel width changes
		if (!jQuery.support.flexBoxLayout && this.getDomRef()) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
	
			/* Algorithm:
			 * 1. calculate space available for the two elements
			 * 2. if no toolbar is present, apply this width to the title, else:
			 * 3.   reduce toolbar width until maxBtnSize is reached, then reduce title width until minimum (do not make either any smaller; the Panel has a min-width anyway)
			 * 4.   apply these widths
			 */
	
			// begin of Panel to begin of Title
			var beginBorderOfTitle = this._oTitleDomRef.offsetLeft; // displacement of the beginning of the title from the Panel border
			var totalWidth = this.getDomRef().offsetWidth;
			if (bRtl) {
				beginBorderOfTitle = totalWidth - (beginBorderOfTitle + this._oTitleDomRef.offsetWidth); // RTL case
			}
	
			// begin of Panel to begin if "RightItems"
			var beginBorderOfRightItems = 10000;
			jQuery(this._oHeaderDomRef).children(".sapUiPanelHdrRightItem").each(function(){
				var begin = this.offsetLeft;
				if (bRtl) {
					begin = totalWidth - (begin + this.offsetWidth); // RTL case
				}
				if ((begin < beginBorderOfRightItems) && (begin > 0)) {
					beginBorderOfRightItems = begin;
				}
			});
	
			var availableSpace = (beginBorderOfRightItems == 10000) ?
						this.$().width() - beginBorderOfTitle - 20
					: beginBorderOfRightItems - beginBorderOfTitle - 10;
	
			var aButtons = this.getButtons();
			if (aButtons && aButtons.length > 0) { // there are title and toolbar; calculate and set both sizes
				// differentiate between two cases: 1. there is enough space for title plus minimum toolbar width
				//                                  2. both need to be reduced in size
				if ((availableSpace - this._iOptTitleWidth - this._iTitleMargin) > (this._iMaxTbBtnWidth - this._iTbMarginsAndBorders)) {
					// if available width minus optimum title width is still more than the minimum toolbar width,
					// give all remaining width to the toolbar
					this._oToolbarDomRef.style.width = (availableSpace - this._iOptTitleWidth - this._iTitleMargin - this._iTbMarginsAndBorders) + "px";
					this._oTitleDomRef.style.width = this._iOptTitleWidth + "px";
				} else {
					// both are affected => set toolbar to minimum and reduce title width, but not smaller than minimum
					this._oToolbarDomRef.style.width = this._iMaxTbBtnWidth + "px";
					this._oTitleDomRef.style.width = Math.max((availableSpace - this._iMaxTbBtnWidth - this._iTbMarginsAndBorders), this._iMinTitleWidth) + "px";
				}
	
			} else {
				// no toolbar
				this._oTitleDomRef.style.width = Math.max(availableSpace, this._iMinTitleWidth) + "px";
			}
		}
	
		// in case the resizing caused button wrapping, adapt content height -- FOR ALL BROWSERS!
		this._fixContentHeight();
	};
	
	
	/**
	 * Helper method to find out whether the Panel has an icon.
	 * @private
	 */
	Panel.prototype._hasIcon = function() {
		return (this.getTitle() && this.getTitle().getIcon());
	};
	
	
	
	/**
	 * Property setter for the "enabled" state
	 *
	 * @param {boolean} bEnabled whether the Panel should be enabled or not
	 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 */
	Panel.prototype.setEnabled = function(bEnabled) {
		this.setProperty("enabled", bEnabled, true); // no re-rendering!
		// if already rendered, adapt rendered control without complete re-rendering
		jQuery(this.getDomRef()).toggleClass("sapUiPanelDis", !bEnabled);
		return this;
	};
	
	
	/**
	 * Property setter for the padding
	 *
	 * @param {boolean} bPadding whether the Panel should have padding
	 * @returns {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 */
	Panel.prototype.setApplyContentPadding = function(bPadding) {
		this.setProperty("applyContentPadding", bPadding, true); // no re-rendering!
		jQuery(this.getDomRef()).toggleClass("sapUiPanelWithPadding", bPadding);
		return this;
	};
	
	
	/**
	 * Property setter for the "collapsed" state
	 *
	 * @param {boolean} bCollapsed whether the Panel should be collapsed or not
	 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 */
	Panel.prototype.setCollapsed = function(bCollapsed) {
		this.setProperty("collapsed", bCollapsed, true); // no re-rendering!
		this._setCollapsedState(bCollapsed); // adapt rendered control without complete re-rendering
		return this;
	};
	
	
	/**
	 * Internal method for applying a (non-)"collapsed" state to the rendered HTML
	 *
	 * @param bCollapsed whether the Panel should be collapsed or not
	 * @private
	 */
	Panel.prototype._setCollapsedState = function(bCollapsed) {
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			// after Panel has been rendered
			var accessibility = sap.ui.getCore().getConfiguration().getAccessibility();
			if (bCollapsed) {
				// collapsing
				if (!this.getWidth()) {
					oDomRef.style.width = this.getDomRef().offsetWidth + "px"; // maintain the current width
				}
				jQuery(oDomRef).addClass("sapUiPanelColl");
				if (accessibility) {
					oDomRef.setAttribute("aria-expanded", "false");
				}
				if (this.getHeight()) {
					// if there is a height set, the Panel would still consume the respective space, so remove the height setting
					oDomRef.style.height = "auto";
				}
				// update tooltips
				var sExpandTooltip = this._rb.getText("PANEL_EXPAND");
				this.$("collArrow").attr("title", sExpandTooltip);
				this.$("collIco").attr("title", sExpandTooltip);
	
			} else {
				// expanding
				if (!this.getDomRef("cont")) {
					// content has not been rendered yet, so render it now
					this._bFocusCollapseIcon = true; // restore focus to collapse icon/button after rendering
					this.rerender();
				} else {
					// content exists already, just make it visible again
					jQuery(oDomRef).removeClass("sapUiPanelColl");
					if (accessibility) {
						oDomRef.setAttribute("aria-expanded", "true");
					}
					if (!this.getWidth()) {
						oDomRef.style.width = "auto"; // restore the automatic width behavior
					}
					if (this.getHeight()) {
						oDomRef.style.height = this.getHeight(); // restore the set height
					}
					// update tooltips
					var sCollapseTooltip = this._rb.getText("PANEL_COLLAPSE");
					this.$("collArrow").attr("title", sCollapseTooltip);
					this.$("collIco").attr("title", sCollapseTooltip);
				}
			}
		}
	};
	
	
	/**
	 * Static method that finds out whether the given CSS size is actually set.
	 * Returns "true" for absolute and relative sizes, returns "false" if "null", "inherit" or "auto" is given.
	 *
	 * @static
	 * @param sCssSize a css size string (must be a valid CSS size, or null)
	 * @private
	 */
	Panel._isSizeSet = function(sCssSize) {
		return (sCssSize && !(sCssSize == "auto") && !(sCssSize == "inherit"));
	};
	
	// API method
	Panel.prototype.setTitle = function(oTitle) {
		var oOldTitle = this.getTitle();
		this.setAggregation("title", oTitle);
		// check whether the title has been created on the fly. Then we are owner of it and should destroy it
		// the ID check should be sufficient as long as the naming conventions are obeyed
		if ( oOldTitle && oOldTitle !== oTitle && oOldTitle.getId() === this.getId() + "-tit" ) {
			oOldTitle.destroy();
		}
		return this;
	};
	
	// API method
	Panel.prototype.setText = function(sText) {
		if (!this.getTitle()) {
			this.setTitle(new sap.ui.core.Title(this.getId() + "-tit",{text:sText}));
		} else {
			this.getTitle().setText(sText);
		}
		return this;
	};
	
	// API method
	Panel.prototype.getText = function () {
		if (!this.getTitle()) {
			return "";
		} else {
			return this.getTitle().getText();
		}
	};
	
	
	/**
	 * Returns the scroll position of the panel in pixels from the left. Returns 0 if not rendered yet.
	 * Also internally updates the control property.
	 *
	 * @return {int} the scroll position
	 * @public
	 */
	Panel.prototype.getScrollLeft = function () {
		var scrollLeft = 0;
		if (this._oScrollDomRef) {
			if (sap.ui.getCore().getConfiguration().getRTL()) {
				scrollLeft = jQuery(this._oScrollDomRef).scrollLeftRTL();
			} else {
				scrollLeft = jQuery(this._oScrollDomRef).scrollLeft();
			}
			jQuery.sap.assert(typeof scrollLeft == "number", "scrollLeft read from DOM should be a number");
			this.setProperty("scrollLeft", scrollLeft, true);
		}
	
		return scrollLeft;
	};
	
	
	/**
	 * Sets the scroll position of the panel in pixels from the left.
	 *
	 * @param {int} iPosition the position to scroll to
	 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 */
	Panel.prototype.setScrollLeft = function (iPosition) {
		this.setProperty("scrollLeft", iPosition, true);
		if (this._oScrollDomRef) {
			if (sap.ui.getCore().getConfiguration().getRTL()) {
				jQuery(this._oScrollDomRef).scrollLeftRTL(iPosition);
			} else {
				jQuery(this._oScrollDomRef).scrollLeft(iPosition);
			}
		}
		return this;
	};
	
	
	/**
	 * Returns the scroll position of the panel in pixels from the top. Returns 0 if not rendered yet.
	 * Also internally updates the control property.
	 *
	 * @return {int} the scroll position
	 * @public
	 */
	Panel.prototype.getScrollTop = function () {
		var scrollTop = 0;
		if (this._oScrollDomRef) {
			scrollTop = this._oScrollDomRef.scrollTop;
			this.setProperty("scrollTop", scrollTop, true);
		}
	
		return scrollTop;
	};
	
	
	/**
	 * Sets the scrolls position of the panel in pixels from the top.
	 *
	 * @param {int} iPosition the position to scroll to
	 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 */
	Panel.prototype.setScrollTop = function (iPosition) {
		this.setProperty("scrollTop", iPosition, true);
		if (this._oScrollDomRef) {
			this._oScrollDomRef.scrollTop = iPosition;
		}
		return this;
	};
	
	
	/**
	 * Sets the dimensions of the panel.
	 *
	 * @param {sap.ui.core.CSSSize} sWidth the width of the panel as CSS size
	 * @param {sap.ui.core.CSSSize} sHeight the height of the panel as CSS size
	 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Panel.prototype.setDimensions = function (sWidth, sHeight) {
		jQuery.sap.assert(typeof sWidth == "string" && typeof sHeight == "string", "sWidth and sHeight must be strings");
		this.setWidth(sWidth); // does not rerender
		this.setHeight(sHeight);
		return this;
	};
	
	
	/**
	 * Sets the width of the panel.
	 *
	 * @param {sap.ui.core.CSSSize} sWidth the width of the panel as CSS size
	 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 */
	Panel.prototype.setWidth = function (sWidth) {
		this.setProperty("width", sWidth, true); // don't rerender
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			oDomRef.style.width = sWidth;
		}
		return this;
	};
	
	
	/**
	 * Sets the height of the panel.
	 *
	 * @param {sap.ui.core.CSSSize} sHeight the height of the panel as CSS size
	 * @return {sap.ui.commons.Panel} <code>this</code> to allow method chaining
	 * @public
	 */
	Panel.prototype.setHeight = function (sHeight) {
		this.setProperty("height", sHeight, true); // don't rerender
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			oDomRef.style.height = sHeight;
		}
		return this;
	};
	
	
	
	/*   Event Handling   */
	
	/**
	 * Handles mouse clicks
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Panel.prototype.onclick = function(oEvent) {
		this._handleTrigger(oEvent);
	};
	
	/**
	 * Handles "space" presses
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Panel.prototype.onsapspace = function(oEvent) {
		this._handleTrigger(oEvent);
	};
	
	/**
	 * Handles any "triggering" actions like click and space
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Panel.prototype._handleTrigger = function(oEvent) {
		var id = this.getId();
		// minimize button toggled
		if ((oEvent.target.id === id + "-collArrow") ||
				(oEvent.target.id === id + "-collIco") ||
				// toggle triggered via space key
				(oEvent.target.id === id && oEvent.type === "sapspace" && this.getShowCollapseIcon())) {
			this.setCollapsed(!this.getProperty("collapsed"));
			oEvent.preventDefault();
			oEvent.stopPropagation();
			this.fireEvent("collapsedToggled"); //private event used in ResponsiveLayout
		}
	};
	

	return Panel;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Panel.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.PasswordFieldRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.commons.PasswordFieldRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/PasswordFieldRenderer",['jquery.sap.global', './TextFieldRenderer'],
	function(jQuery, TextFieldRenderer) {
	"use strict";


	/**
	 * PasswordFieldRenderer.
	 * @namespace
	 */
	var PasswordFieldRenderer = sap.ui.core.Renderer.extend(TextFieldRenderer);
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.fw.RenderManager}.
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.fw.Control} oPasswordField an object representation of the control that should be rendered
	 */
	PasswordFieldRenderer.renderInnerAttributes = function(rm, oPasswordField) {
	
		if (sap.ui.Device.support.input.placeholder || oPasswordField.getValue() || !oPasswordField.getPlaceholder()) {
			// if browser not supports placeholder on input tag, set the password type only if placeholder is not displayed
			rm.writeAttribute('type', 'password');
		}
	
	};
	
	
	PasswordFieldRenderer.renderTextFieldEnabled = function(rm, oPasswordField) {
		if (!oPasswordField.getEnabled() && !oPasswordField.getEditable()) {
			// "disabled" may not be rendered because the Jaws screenreader then reads the password
			// use "readonly" instead
			// but write it only if it has not yet been written by the TextFieldRenderer
			rm.writeAttribute('readonly', 'readonly');
			rm.writeAttribute('tabindex', '-1'); // apart from that, act as if disabled, e.g. no tab-stop
		} else {
			rm.writeAttribute('tabindex', '0'); // editable and readonly have a tab-stop
		}
	};
	
	
	// this method uses "readonly" instead of "disabled" because with "disabled" the Jaws screenreader reads the password
	PasswordFieldRenderer.setEnabled = function(oPasswordField, bEnabled) {
		var oTfRef = oPasswordField.getDomRef();
	
		if (bEnabled) {
			if (oPasswordField.getEditable()) {
				jQuery(oTfRef).removeClass('sapUiTfDsbl').addClass('sapUiTfStd');
				jQuery(oTfRef).removeAttr('readonly').attr('tabindex', '0');
			} else {
				jQuery(oTfRef).removeClass('sapUiTfDsbl').addClass('sapUiTfRo');
				jQuery(oTfRef).attr('tabindex', '0');
			}
		} else {
			if (oPasswordField.getEditable()) {
				jQuery(oTfRef).removeClass('sapUiTfStd').addClass('sapUiTfDsbl');
				jQuery(oTfRef).attr('readonly', 'readonly').attr('tabindex', '-1');
			} else {
				jQuery(oTfRef).removeClass('sapUiTfRo').addClass('sapUiTfDsbl');
				jQuery(oTfRef).attr( 'tabindex', '-1');
			}
		}
	};
	
	

	return PasswordFieldRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/PasswordFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ProgressIndicator') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ProgressIndicator.
jQuery.sap.declare('sap.ui.commons.ProgressIndicator'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ProgressIndicator",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";



	/**
	 * Constructor for a new ProgressIndicator.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Shows the progress of a process in a graphical way. The indicator can be displayed with or without numerical values.
	 * The filling can be displayed in color only, or additionally with the percentage rate. The indicator status can be interactive.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ProgressIndicator
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ProgressIndicator = Control.extend("sap.ui.commons.ProgressIndicator", /** @lends sap.ui.commons.ProgressIndicator.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Switches enabled state of the control. Disabled fields have different colors, and can not be focused.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * The color of the bar. Enumeration sap.ui.core.BarColor provides CRITICAL (yellow), NEGATIVE (red), POSITIVE (green), NEUTRAL (blue) (default value).
			 */
			barColor : {type : "sap.ui.core.BarColor", group : "Appearance", defaultValue : sap.ui.core.BarColor.NEUTRAL},

			/**
			 * The text value to be displayed in the bar.
			 */
			displayValue : {type : "string", group : "Appearance", defaultValue : '0%'},

			/**
			 * The numerical value for the displayed length of the progress bar.
			 */
			percentValue : {type : "int", group : "Data", defaultValue : 0},

			/**
			 * Specifies whether the current value shall be rendered inside the bar.
			 */
			showValue : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * The width of the control.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'}
		}
	}});

	/**
	 * Function is called when ProgressIndicator is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ProgressIndicator.prototype.onclick = function(oEvent) {

		// Set focus to whole ProgressIndicator control
		this.focus();

	};

	ProgressIndicator.prototype.setEndBar = function () {

		var widthBar = this.getPercentValue();
		var widthBorder;
		var sBarColor = this.getBarColor();
		var time;

		this.oBar  = this.getDomRef("bar");
		this.oEnd  = this.getDomRef("end");
		this.oBox  = this.getDomRef("box");

		jQuery(this.oEnd).removeClass('sapUiProgIndEndHidden');

		switch (sBarColor) {
			case "POSITIVE":
				jQuery(this.oEnd).addClass('sapUiProgIndPosEnd');
				break;
			case "NEGATIVE":
				jQuery(this.oEnd).addClass('sapUiProgIndNegEnd');
				break;
			case "CRITICAL":
				jQuery(this.oEnd).addClass('sapUiProgIndCritEnd');
				break;
			case "NEUTRAL":
				jQuery(this.oEnd).addClass('sapUiProgIndEnd');
				break;
			default:
				jQuery(this.oEnd).addClass('sapUiProgIndEnd');
				break;
		}

		if (widthBar > 100) {
			widthBorder = (10000 / widthBar) + '%';
		} else {
			widthBorder = '100%';
		}

		if (widthBar > 100) {
			time = (widthBar - 100) * 20;
		} else {
			time = (100 - widthBar) * 20;
		}

		jQuery(this.oBox).animate({width: widthBorder}, 0, 'linear');

		if (this.bRtl) {
			jQuery(this.oEnd).animate({right: widthBorder}, time, 'linear');
		} else {
			jQuery(this.oEnd).animate({left: widthBorder}, time, 'linear');
		}

		jQuery(this.oBar).animate({width: widthBar + '%'}, time, 'linear');
		if (!this.oThis) {
			this.oThis = this.$();
		}
		this.oThis.attr('aria-valuenow', widthBar + '%');

	};

	ProgressIndicator.prototype.setEndBarGoesBack = function (iPercentValue) {

		var widthBar = this.getPercentValue();
		var widthBorder;
		var sBarColor = this.getBarColor();
		var time;

		this.oBar  = this.getDomRef("bar");
		this.oEnd  = this.getDomRef("end");
		this.oBox  = this.getDomRef("box");

		if (iPercentValue > 100) {
			widthBorder = (10000 / iPercentValue) + '%';
		} else {
			widthBorder = '100%';
		}

		switch (sBarColor) {
			case "POSITIVE":
				jQuery(this.oEnd).removeClass('sapUiProgIndPosEnd');
				break;
			case "NEGATIVE":
				jQuery(this.oEnd).removeClass('sapUiProgIndNegEnd');
				break;
			case "CRITICAL":
				jQuery(this.oEnd).removeClass('sapUiProgIndCritEnd');
				break;
			case "NEUTRAL":
				jQuery(this.oEnd).removeClass('sapUiProgIndEnd');
				break;
			default:
				jQuery(this.oEnd).removeClass('sapUiProgIndEnd');
				break;
		}

		jQuery(this.oEnd).addClass('sapUiProgIndEndHidden');

		if (widthBar > 100) {
			time = (widthBar - 100) * 20;
		} else {
			time = (100 - widthBar) * 20;
		}

		jQuery(this.oBox).animate({width: widthBorder}, 0, 'linear');

		if (this.bRtl) {
			jQuery(this.oEnd).animate({right: widthBorder}, time, 'linear');
		} else {
			jQuery(this.oEnd).animate({left: widthBorder}, time, 'linear');
		}

		jQuery(this.oBar).animate({width: widthBar + '%'}, time, 'linear');
		if (!this.oThis) {
			this.oThis = this.$();
		}
		this.oThis.attr('aria-valuenow', widthBar + '%');

	};

	/**
	 * Property setter for the PercentValue
	 * A new rendering is not necessary, only the bar has to be moved.
	 *
	 * @param {int} iPercentValue
	 * @return {sap.ui.commons.ProgressIndicator} <code>this</code> to allow method chaining
	 * @public
	 */
	ProgressIndicator.prototype.setPercentValue = function(iPercentValue) {

		var widthBar = this.getPercentValue();
		var widthBorder;

		this.oBar  = this.getDomRef("bar");
		this.oEnd  = this.getDomRef("end");
		this.oBox  = this.getDomRef("box");

		var that = this;
		var time;

		if (iPercentValue < 0) {
			iPercentValue = 0;
		}

		if (iPercentValue > 100) {
			widthBorder = (10000 / iPercentValue) + '%';
		} else {
			widthBorder = '100%';
		}

		if (!this.oBar) {
			// Not already rendered -> return and render
			time = iPercentValue * 20;
			this.setProperty('percentValue', iPercentValue, true); // No re-rendering!
			jQuery(this.oBar).animate({width: iPercentValue + '%'}, time, 'linear');
			return this;
		}

		if (iPercentValue > 100 && widthBar <= 100) {
			time = (100 - widthBar) * 20;
			this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
			jQuery(this.oBar).animate({width: '100%'}, time, 'linear', function() {
			that.setEndBar();
			});
		} else if (iPercentValue <= 100 && widthBar > 100) {
			time = (widthBar - 100) * 20;
			this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
			jQuery(this.oBar).animate({width: '100%'}, time, 'linear', function() {
			that.setEndBarGoesBack();
			});
		} else if (iPercentValue > 100 && widthBar > 100) {
			if (iPercentValue > widthBar) {
				time = (iPercentValue - widthBar) * 20;
			} else {
				time = (widthBar - iPercentValue) * 20;
			}
			widthBorder = (10000 / iPercentValue) + '%';
			this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
			jQuery(this.oBox).animate({width: widthBorder}, 0, 'linear');

			if (this.bRtl) {
				jQuery(this.oEnd).animate({right: widthBorder}, time, 'linear');
			} else {
				jQuery(this.oEnd).animate({left: widthBorder}, time, 'linear');
			}

			jQuery(this.oBar).animate({width: iPercentValue + '%'}, time, 'linear', function() {
			});
			if (!this.oThis) {
				this.oThis = this.$();
			}
			this.oThis.attr('aria-valuenow', iPercentValue + '%');
		} else {
			if (iPercentValue > widthBar) {
				time = (iPercentValue - widthBar) * 20;
			} else {
				time = (widthBar - iPercentValue) * 20;
			}
			this.setProperty( 'percentValue', iPercentValue, true ); // Do not render complete control again
			jQuery(this.oBar).animate({width: iPercentValue + '%'}, time, 'linear');
			if (!this.oThis) {
				this.oThis = this.$();
			}
			this.oThis.attr('aria-valuenow', iPercentValue + '%');
		}

		return this;
	};


	return ProgressIndicator;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ProgressIndicator.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButton') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RadioButton.
jQuery.sap.declare('sap.ui.commons.RadioButton'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RadioButton",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new RadioButton.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Consists of a round element and a descriptive text. Generally, you would create at least two radio button controls;
	 * by this, you provide a limited choice for the user. Radio buttons can trigger events.
	 * Available value states are "Error", "None", "Success", "Warning".
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RadioButton
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RadioButton = Control.extend("sap.ui.commons.RadioButton", /** @lends sap.ui.commons.RadioButton.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Defines the text displayed next to the radio button.
			 */
			text : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * 
			 * Disabled controls are displayed in another color, depending on the customer settings.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Specifies whether the user can select the radio button
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Specifies the select state of the radio button
			 */
			selected : {type : "boolean", group : "Data", defaultValue : false},
	
			/**
			 * 
			 * Enumeration sap.ui.core.ValueState provides state values Error, Success, Warning, None
			 */
			valueState : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},
	
			/**
			 * The control width depends on the text length. Alternatively, CSS-sizes in % or px can be set.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * 
			 * Available options are LTR and RTL. Alternatively, the control can inherit the text direction from its parent container.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
	
			/**
			 * Name of the radio button group the current radio button belongs to. You can define a new name for the group.
			 * If no new name is specified, this radio button belongs to the sapUiRbDefaultGroup per default. Default behavior of a radio button
			 * in a group is that when one of the radio buttons in a group is selected, all others are unselected.
			 */
			groupName : {type : "string", group : "Behavior", defaultValue : 'sapUiRbDefaultGroup'},
	
			/**
			 * Can be used for subsequent actions
			 */
			key : {type : "string", group : "Data", defaultValue : null}
		},
		associations : {
	
			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
	
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {
	
			/**
			 * Event is triggered when the user makes a change on the radio button.
			 */
			select : {}
		}
	}});
	
	/**
	 * Event handler called when the radio button is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RadioButton.prototype.onclick = function(oEvent) {
	
		if (this.getEnabled() && oEvent.target.id == (this.getId() + "-RB")) {
			this.focus();
		}
	
		if (!!sap.ui.Device.browser.internet_explorer && (/*!this.getEditable() ||*/ !this.getEnabled())) { //According to CSN2581852 2012 a readonly CB should be in the tabchain 
			// in IE tabindex = -1 hides focus, so in readOnly case tabindex must be set to 0
			// as long as RadioButton is clicked on
			this.$().attr("tabindex", 0).toggleClass("sapUiRbFoc");
		}
	
		this.userSelect(oEvent);
	};

	RadioButton.prototype._groupNames = {};
	
	/**
	 * Event handler called when the space key is pressed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RadioButton.prototype.onsapspace = function(oEvent) {
	
		if (this.getEnabled() && oEvent.target.id == (this.getId() + "-RB")) {
			this.focus();
		}
		this.userSelect(oEvent);
	};
	
	/**
	 * Event handler called focus is set on Radio button
	 * Problem in HCB: Focus is set in IE8 to bullet, not to whole control
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RadioButton.prototype.onsaptabnext = function(oEvent) {
	
		if (!!sap.ui.Device.browser.internet_explorer) {
			this.bTabPressed = true;
			var that = this;
			window.setTimeout(function(){that.bTabPressed = false;}, 100);
		}
	};
	
	/**
	 * Event handler called when the radio button is focused
	 * Problem in HCB: Focus is sometimes set in IE8 to bullet, not to whole control
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RadioButton.prototype.onfocusin = function(oEvent) {
	
		if (this.getEnabled() && oEvent.target.id == (this.getId() + "-RB")) {
			if (this.bTabPressed) {
				// this only occurs in IE in HCB mode
				var aFocusableElements = jQuery(":sapFocusable"),
					bFound = false;
				for (var i = 0; i < aFocusableElements.length; i++) {
					if (bFound && aFocusableElements[i].parentNode != oEvent.target && aFocusableElements[i].tabIndex != "-1") {
						aFocusableElements[i].focus();
						oEvent.preventDefault();
						break;
					}
					if (oEvent.target == aFocusableElements[i]) {
						bFound = true;
					}
				}
			} else {
				this.focus();
			}
		}
	};
	
	/**
	 * Event handler called when the radio button is left
	 * Problem in IE: Tabindex must be set back to -1
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RadioButton.prototype.onfocusout = function(oEvent) {
	
		if (!!sap.ui.Device.browser.internet_explorer && (/*!this.getEditable() ||*/ !this.getEnabled())) { //According to CSN2581852 2012 a readonly CB should be in the tabchain 
			// in IE tabindex = -1 hides focus, so in readOnly case tabindex must be set to 0
			// as long as RadioButton is clicked on
			this.$().attr("tabindex", -1).toggleClass("sapUiRbFoc");
		}
	
	};
	/**
	 * This method is used internally only, whenever the user somehow selects the RadioButton.
	 * It is responsible for event cancellation and for firing the select event.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RadioButton.prototype.userSelect = function(oEvent) {
	//	oEvent.preventDefault();
		// the control should not stop browser event propagation
		// Example: table control needs to catch and handle the event as well
		//oEvent.stopPropagation();
	
		if (this.getEnabled() && this.getEditable()) {
			var selected = this.getSelected();
			if (!selected) {
				this.setSelected(true);
				this.fireSelect({/* no parameters */});
			}
		} else {
			// readOnly or disabled -> don't allow browser to switch RadioButton on
			oEvent.preventDefault();
		}
	};
	
	// #############################################################################
	// Overwritten methods that are also generated in RadioButton.API.js
	// #############################################################################
	
	/*
	 * Overwrite the definition from RadioButton.API.js
	 */
	RadioButton.prototype.setSelected = function(bSelected) {
		var oControl,
			bSelectedOld = this.getSelected(),
			sGroupName = this.getGroupName(),
			aControlsInGroup = this._groupNames[sGroupName],
			iLength = aControlsInGroup && aControlsInGroup.length;
			
		this.setProperty("selected", bSelected, true); // No re-rendering
		this._changeGroupName(this.getGroupName());

		if (bSelected && sGroupName && sGroupName !== "") { // If this radio button is selected and groupName is set, explicitly deselect the other radio buttons of the same group
			for (var i = 0; i < iLength; i++) {
				oControl = aControlsInGroup[i];

				if (oControl instanceof RadioButton && oControl !== this && oControl.getSelected()) {
					oControl.setSelected(false);
				}
			}
		}

		if ((bSelectedOld != bSelected) && this.getDomRef() && this.getRenderer().setSelected) {
			this.getRenderer().setSelected(this, bSelected);
		}

		return this;
	};

	RadioButton.prototype.setGroupName = function(sGroupName) {
		this._changeGroupName(sGroupName, this.getGroupName());

		return this.setProperty("groupName", sGroupName, false);
	};
	
	RadioButton.prototype.getTooltipDomRefs = function() {
		return this.$().children();
	};

	RadioButton.prototype._changeGroupName = function(sNewGroupName, sOldGroupName) {
		var aNewGroup = this._groupNames[sNewGroupName],
			aOldGroup = this._groupNames[sOldGroupName];

		if (!aNewGroup) {
			aNewGroup = this._groupNames[sNewGroupName] = [];
		}

		if (aNewGroup.indexOf(this) === -1) {
			aNewGroup.push(this);
		}

		if (aOldGroup && aOldGroup.indexOf(this) !== -1) {
			aOldGroup.splice(aOldGroup.indexOf(this), 1);
		}
	};

	return RadioButton;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RadioButton.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RadioButtonGroup') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RadioButtonGroup.
jQuery.sap.declare('sap.ui.commons.RadioButtonGroup'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RadioButtonGroup",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation'],
	function(jQuery, library, Control, ItemNavigation) {
	"use strict";

	/**
	 * Constructor for a new RadioButtonGroup.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * a group of RadioButtons to hande as one UI element.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RadioButtonGroup
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RadioButtonGroup = Control.extend("sap.ui.commons.RadioButtonGroup", /** @lends sap.ui.commons.RadioButtonGroup.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Width of the RadioButtonGroup.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * Number of RadioButtons displayed in one Line.
			 */
			columns : {type : "int", group : "Appearance", defaultValue : 1},

			/**
			 * Specifies whether the user can choose a radio button.
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * The value state to be displayed.
			 */
			valueState : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},

			/**
			 * Index of the selected/checked RadioButton.
			 */
			selectedIndex : {type : "int", group : "Data", defaultValue : 0},

			/**
			 * If set the RadioButtonGroup is enabled, if not it is disabled. If it is disabled all RadioButtons will be shown as disabled. The enabled property of the item will not be uses in this case. If the RadioButtonGroup is enabled the enabled property of the item will define if a RadioButton is enabled or not.
			 * @since 1.10.3
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true}
		},
		defaultAggregation : "items",
		aggregations : {

			/**
			 * RadioButtons of this RadioButtonGroup
			 */
			items : {type : "sap.ui.core.Item", multiple : true, singularName : "item", bindable : "bindable"}
		},
		associations : {

			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {

			/**
			 * Event is fired when selection is changed by user interaction.
			 */
			select : {
				parameters : {

					/**
					 * Index of the selected RadioButton.
					 */
					selectedIndex : {type : "int"}
				}
			}
		}
	}});


	RadioButtonGroup.prototype.exit = function() {
		this.destroyItems(); // or Element.exit should call the typed destroyXYZ methods?

		if (this.oItemNavigation) {
			this.removeDelegate(this.oItemNavigation);
			this.oItemNavigation.destroy();
			delete this.oItemNavigation;
		}

	};

	RadioButtonGroup.prototype.onBeforeRendering = function() {
		if (this.getSelectedIndex() > this.getItems().length) {
			// SelectedIndex is > than number of items -> select the first one
			jQuery.sap.log.warning("Invalid index, set to 0");
			this.setSelectedIndex(0);
		}
	};

	RadioButtonGroup.prototype.onAfterRendering = function() {

		this.initItemNavigation();

		// update ARIA information of RadioButtons
		for (var i = 0; i < this.aRBs.length; i++) {
			this.aRBs[i].$().attr("aria-posinset", i + 1).attr("aria-setsize", this.aRBs.length);
		}
	};

	/*
	 * initialize ItemNavigation. Transfer RadioButtons to ItemNavigation.
	 * TabIndexes are set by ItemNavigation
	 * @private
	 */
	RadioButtonGroup.prototype.initItemNavigation = function(){

		// Collect items for ItemNavigation
		var aDomRefs = [];
		this._aActiveItems = [];
		var aActiveItems = this._aActiveItems;
		var bEnabled = false;
		for (var i = 0; i < this.aRBs.length; i++) {
			aActiveItems[aDomRefs.length] = i;
			aDomRefs.push(this.aRBs[i].getDomRef());
			if (!bEnabled && this.aRBs[i].getEnabled()) {
				// at least one RadioButton is enabled
				bEnabled = true;
			}
		}

		if (bEnabled) {
			// at least one RadioButton enabled -> use property of RadioButtonGroup
			// so if all RadioButtons are disabled the RadioButtonGroup is disabled too.
			bEnabled = this.getEnabled();
		}

		if (!bEnabled) {
			// RadioButtonGroup is disabled -> no ItemNavigation
			if (this.oItemNavigation) {
				this.removeDelegate(this.oItemNavigation);
				this.oItemNavigation.destroy();
				delete this.oItemNavigation;
			}
			return;
		}

		// init ItemNavigation
		if (!this.oItemNavigation) {
			this.oItemNavigation = new ItemNavigation();
			this.oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, this._handleAfterFocus, this);
			this.addDelegate(this.oItemNavigation);
		}
		this.oItemNavigation.setRootDomRef(this.getDomRef());
		this.oItemNavigation.setItemDomRefs(aDomRefs);
		this.oItemNavigation.setCycling(true);
		this.oItemNavigation.setColumns(this.getColumns());
		this.oItemNavigation.setSelectedIndex(this.getSelectedIndex());
		this.oItemNavigation.setFocusedIndex(this.getSelectedIndex());
	};

	/*
	 * Set selected RadioButton via Index
	 * @public
	 */
	RadioButtonGroup.prototype.setSelectedIndex = function(iSelectedIndex) {

		var iIndexOld = this.getSelectedIndex();

		if (iSelectedIndex < 0) {
			// invalid negative index -> don't change index.
			jQuery.sap.log.warning("Invalid index, will not be changed");
			return this;
		}

		this.setProperty("selectedIndex", iSelectedIndex, true); // no re-rendering

		// deselect old RadioButton
		if ( !isNaN(iIndexOld) && this.aRBs && this.aRBs[iIndexOld]) {
			this.aRBs[iIndexOld].setSelected(false);
		}

		// select new one
		if (this.aRBs && this.aRBs[iSelectedIndex]) {
			this.aRBs[iSelectedIndex].setSelected(true);
		}

		if (this.oItemNavigation) {
			this.oItemNavigation.setSelectedIndex(iSelectedIndex);
			this.oItemNavigation.setFocusedIndex(iSelectedIndex);
		}

		return this;

	};

	/*
	 * Set selected RadioButton via Item
	 * @param {sap.ui.core.Item} oSelectedItem the item to be selected.
	 * @public
	 */

	/**
	 * Sets the item as selected and removes the selection from the old one.
	 *
	 * @param {sap.ui.core.Item} oSelectedItem Selected item
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RadioButtonGroup.prototype.setSelectedItem = function(oSelectedItem) {

		for (var i = 0; i < this.getItems().length; i++) {
			if (oSelectedItem.getId() == this.getItems()[i].getId()) {
				this.setSelectedIndex(i);
				break;
			}
		}
	};

	/*
	 * Get item of selected RadioButton
	 * @public
	 */

	/**
	 * Returns selected item. When no item is selected, "null" is returned.
	 *
	 * @returns {sap.ui.core.Item} selected item
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RadioButtonGroup.prototype.getSelectedItem = function() {

		return this.getItems()[this.getSelectedIndex()];

	};

	/*
	 * Adds a new Item
	 * If an item is added a new RadioButton must be added
	 * @public
	 */
	RadioButtonGroup.prototype.addItem = function(oItem) {

		this.myChange = true;
		this.addAggregation("items", oItem);
		oItem.attachEvent("_change", this._handleItemChanged, this);
		this.myChange = undefined;

		if (!this._bUpdateItems) {
			if (this.getSelectedIndex() === undefined) {
				// if not defined -> select first one
				this.setSelectedIndex(0);
			}
		}

		if (!this.aRBs) {
			this.aRBs = [];
		}

		var iIndex = this.aRBs.length;

		this.aRBs[iIndex] = this.createRadioButton(oItem, iIndex);

		return this;
	};

	/*
	 * Inserts a new Item
	 * If an item is inserted a new RadioButton must be inserted
	 * @public
	 */
	RadioButtonGroup.prototype.insertItem = function(oItem, iIndex) {

		this.myChange = true;
		this.insertAggregation("items", oItem, iIndex);
		oItem.attachEvent("_change", this._handleItemChanged, this);
		this.myChange = undefined;

		if (!this.aRBs) {
			this.aRBs = [];
		}

		var iLength = this.aRBs.length;

		if (!this._bUpdateItems) {
			if (this.getSelectedIndex() === undefined || iLength == 0) {
				// if not defined -> select first one
				this.setSelectedIndex(0);
			} else if (this.getSelectedIndex() >= iIndex) {
				// If inserted before selected one, move selection index (only change parameter, not RadioButton)
				this.setProperty("selectedIndex", this.getSelectedIndex() + 1, true); // no re-rendering
			}
		}

		if ( iIndex >= iLength) {
			this.aRBs[iIndex] = this.createRadioButton(oItem, iIndex);
		} else {
			// Insert RadioButton: loop backwards over Array and shift everything
			for (var i = (iLength); i > iIndex; i--) {
				this.aRBs[i] = this.aRBs[i - 1];
				if ((i - 1) == iIndex) {
					this.aRBs[i - 1] = this.createRadioButton(oItem, iIndex);
				}
			}
		}

		return this;

	};

	/*
	 * create RadioButton for an item
	 * @private
	 */
	RadioButtonGroup.prototype.createRadioButton = function(oItem, iIndex){

		if (this.iIDCount == undefined) {
			this.iIDCount = 0;
		} else {
			this.iIDCount++;
		}

		var oRadioButton = new sap.ui.commons.RadioButton(this.getId() + "-" + this.iIDCount);
		oRadioButton.setText(oItem.getText());
		oRadioButton.setTooltip(oItem.getTooltip());
		if (this.getEnabled()) {
			oRadioButton.setEnabled(oItem.getEnabled());
		} else {
			oRadioButton.setEnabled(false);
		}
		oRadioButton.setKey(oItem.getKey());
		oRadioButton.setTextDirection(oItem.getTextDirection());
		oRadioButton.setEditable(this.getEditable());
		oRadioButton.setGroupName(this.getId());
		oRadioButton.setValueState(this.getValueState());
		oRadioButton.setParent(this);

		if ( iIndex == this.getSelectedIndex() ) {
			oRadioButton.setSelected(true);
		}

		oRadioButton.attachEvent('select', this.handleRBSelect, this);

		return oRadioButton;
	};

	/*
	 * Removes an Item
	 * If an item is removed the corresponding RadioButton must be deleted
	 * @public
	 */
	RadioButtonGroup.prototype.removeItem = function(vElement) {
		var iIndex = vElement;
		if (typeof (vElement) == "string") { // ID of the element is given
			vElement = sap.ui.getCore().byId(vElement);
		}
		if (typeof (vElement) == "object") { // the element itself is given or has just been retrieved
			iIndex = this.indexOfItem(vElement);
		}

		this.myChange = true;
		var oItem = this.removeAggregation("items", iIndex);
		oItem.detachEvent("_change", this._handleItemChanged, this);
		this.myChange = undefined;

		if (!this.aRBs) {
			this.aRBs = [];
		}

		if (!this.aRBs[iIndex]) {
			// RadioButton not exists
			return null;
		}

		this.aRBs[iIndex].destroy();
		this.aRBs.splice(iIndex, 1);

		if (!this._bUpdateItems) {
			if (this.aRBs.length == 0) {
				this.setSelectedIndex(undefined);
			} else if (this.getSelectedIndex() == iIndex) {
				// selected one is removed -> select first one
				this.setSelectedIndex(0);
			} else if (this.getSelectedIndex() > iIndex) {
				// If removed before selected one, move selection index (only change parameter, not RadioButton)
				this.setProperty("selectedIndex", this.getSelectedIndex() - 1, true); // no re-rendering
			}
		}

		return oItem;
	};

	/*
	 * Removes all items
	 * If all items are removed all RadioButtons must be deleted
	 * @public
	 */
	RadioButtonGroup.prototype.removeAllItems = function() {

		this.myChange = true;
		var aItems = this.removeAllAggregation("items");
		for (var i = 0; i < aItems.length; i++) {
			aItems[i].detachEvent("_change", this._handleItemChanged, this);
		}
		this.myChange = undefined;

		if (!this._bUpdateItems) {
			this.setSelectedIndex(undefined);
		}

		if (this.aRBs) {
			while (this.aRBs.length > 0) {
				this.aRBs[0].destroy();
				this.aRBs.splice(0, 1);
			}
			return aItems;
		} else {
			return null;
		}

	};

	/*
	 * destroys all items
	 * If all items are destroyed all RadioButtons must be deleted
	 * @public
	 */
	RadioButtonGroup.prototype.destroyItems = function() {

		this.myChange = true;
		var aItems = this.getItems();
		for (var i = 0; i < aItems.length; i++) {
			aItems[i].detachEvent("_change", this._handleItemChanged, this);
		}
		this.destroyAggregation("items");
		this.myChange = undefined;

		if (!this._bUpdateItems) {
			this.setSelectedIndex(undefined);
		}

		if (this.aRBs) {
			while (this.aRBs.length > 0) {
				this.aRBs[0].destroy();
				this.aRBs.splice(0, 1);
			}
		}

		return this;

	};

	RadioButtonGroup.prototype.updateItems = function() {

		var iSelectedIndex = this.getSelectedIndex();

		this._bUpdateItems = true;
		this.updateAggregation("items");
		this._bUpdateItems = undefined;

		// if selectedIndex is still valid -> restore
		var aItems = this.getItems();
		if (iSelectedIndex === undefined && aItems.length > 0) {
			// if not defined -> select first one
			this.setSelectedIndex(0);
		}else if (iSelectedIndex >= 0 && aItems.length == 0) {
			this.setSelectedIndex(undefined);
		}else if (iSelectedIndex >= aItems.length) {
			// if less items than before -> select last one
			this.setSelectedIndex(aItems.length - 1);
		}


	};

	RadioButtonGroup.prototype.clone = function(){

		// on clone don't clone event handler
		var aItems = this.getItems();
		var i = 0;
		for (i = 0; i < aItems.length; i++) {
			aItems[i].detachEvent("_change", this._handleItemChanged, this);
		}

		var oClone = Control.prototype.clone.apply(this, arguments);

		for (i = 0; i < aItems.length; i++) {
			aItems[i].attachEvent("_change", this._handleItemChanged, this);
		}

		return oClone;

	};

	/*
	 * On SELECT event of single Radio Buttons fire Select Event for group
	 * @private
	 */
	RadioButtonGroup.prototype.handleRBSelect = function(oControlEvent){
		// find RadioButton in Array to get Index
		for (var i = 0; i < this.aRBs.length; i++) {
			if (this.aRBs[i].getId() == oControlEvent.getParameter("id")) {
				this.setSelectedIndex(i);
				this.oItemNavigation.setSelectedIndex(i);
				this.oItemNavigation.setFocusedIndex(i);
				this.fireSelect({selectedIndex: i});
				break;
			}
		}

	};

	/*
	 * Set all RadioButtons to Editable/ReadOnly
	 * @public
	 */
	RadioButtonGroup.prototype.setEditable = function(bEditable){

		this.setProperty("editable", bEditable, false); // re-rendering to update ItemNavigation

		if (this.aRBs) {
			for (var i = 0; i < this.aRBs.length; i++) {
				this.aRBs[i].setEditable(bEditable);
			}
		}
	};

	/*
	 * Set all RadioButtons to Enabled/Disabled
	 * @public
	 */
	RadioButtonGroup.prototype.setEnabled = function(bEnabled){

		this.setProperty("enabled", bEnabled, false); // re-rendering to update ItemNavigation

		if (this.aRBs) {
			var aItems = this.getItems();

			for (var i = 0; i < this.aRBs.length; i++) {
				if (bEnabled) {
					this.aRBs[i].setEnabled(aItems[i].getEnabled());
				} else {
					this.aRBs[i].setEnabled(bEnabled);
				}
			}
		}

	};

	/*
	 * Set ValueState for all RadioButtons
	 * @public
	 */
	RadioButtonGroup.prototype.setValueState = function(sValueState){

		this.setProperty("valueState", sValueState, false); // re-rendering to update ItemNavigation

		if (this.aRBs) {
			for (var i = 0; i < this.aRBs.length; i++) {
				this.aRBs[i].setValueState(sValueState);
			}
		}
	};

	/*
	 * Handles the event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
	 * Ensures that focused element is selected
	 *
	 * @param {sap.ui.base.Event} oControlEvent The event that gets fired by the {@link sap.ui.core.delegate.ItemNavigation} delegate.
	 * @private
	 */
	RadioButtonGroup.prototype._handleAfterFocus = function(oControlEvent){

		var iIndex = oControlEvent.getParameter("index");
		var oEvent = oControlEvent.getParameter("event");

		if (iIndex != this.getSelectedIndex() && !(oEvent.ctrlKey || oEvent.metaKey) && this.aRBs[iIndex].getEditable() && this.aRBs[iIndex].getEnabled()) {
			// if CTRL key is used do not switch selection
			this.setSelectedIndex(iIndex);
			this.oItemNavigation.setSelectedIndex(iIndex);
			this.fireSelect({selectedIndex:iIndex});
		}
	};

	RadioButtonGroup.prototype._handleItemChanged = function(oEvent){

		var oItem = oEvent.oSource;
		var sProperty = oEvent.getParameter("name");
		var snewValue = oEvent.getParameter("newValue");
		var aItems = this.getItems();
		var oRB;

		for (var i = 0; i < aItems.length; i++) {
			if ( aItems[i] == oItem) {
				if (this.aRBs[i]) {
					oRB = this.aRBs[i];
				}
				break;
			}
		}

		switch (sProperty) {
		case "text":
			oRB.setText(snewValue);
			break;
		case "tooltip":
			oRB.setTooltip(snewValue);
			break;
		case "enabled":
			if (this.getEnabled()) {
				oRB.setEnabled(snewValue);
			}
			break;
		case "key":
			oRB.setKey(snewValue);
			break;
		case "textDirection":
			oRB.setTextDirection(snewValue);
			break;

		default:
			break;
		}

	};

	return RadioButtonGroup;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RadioButtonGroup.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RangeSliderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.RangeSlider
jQuery.sap.declare('sap.ui.commons.RangeSliderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RangeSliderRenderer",['jquery.sap.global', './SliderRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, SliderRenderer, Renderer) {
	"use strict";


	/**
	 * RangeSlider renderer.
	 * @namespace
	 */
	var RangeSliderRenderer = Renderer.extend(SliderRenderer);

	/**
	 * Renders the Grip for the slider control, using the provided {@link sap.ui.fw.RenderManager}.
	 * Each slider is handeled as individual single sliders for aria.
	 * Min and max values are adjusted when sliders are moved.
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.RangeSlider} oSlider An object representation of the control that should be rendered.
	 */
	RangeSliderRenderer.renderGrip = function(oRenderManager, oSlider){
		var rm = oRenderManager;

		//Left Grip
		rm.write('<DIV');

		// Icon for grip
		rm.writeAttribute('id', oSlider.getId() + '-grip');
		if (oSlider.getEnabled()) {
			rm.writeAttribute('tabIndex', '0');
		} else {
			rm.writeAttribute('tabIndex', '-1');
		}
		rm.writeAttribute('class', 'sapUiSliGrip');
		rm.writeAttribute('title', oSlider.getValue());

		// ARIA
		rm.writeAccessibilityState(oSlider, {
			role: 'slider',
			controls: oSlider.getId() + '-grip2',
			orientation: 'horizontal',
			valuemin: oSlider.getMin(),
			valuemax: oSlider.getValue2(),
			live: 'assertive',
			disabled: !oSlider.getEditable() || !oSlider.getEnabled(),
			describedby: oSlider.getTooltip_AsString() ? (oSlider.getId() + '-Descr ' + oSlider.getAriaDescribedBy().join(" ")) : undefined
		});

		rm.write('>&#9650;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)

		//Right Grip
		rm.write('<DIV');

		// Icon for grip
		rm.writeAttribute('id', oSlider.getId() + '-grip2');
		if (oSlider.getEnabled()) {
			rm.writeAttribute('tabIndex', '0');
		} else {
			rm.writeAttribute('tabIndex', '-1');
		}
		rm.writeAttribute('class', 'sapUiSliGrip');
		rm.writeAttribute('title', oSlider.getValue2());

		var sOriantation = 'horizontal';
		if (oSlider.getVertical()) {
			sOriantation = 'vertical';
		}

		// ARIA
		rm.writeAccessibilityState(oSlider, {
			role: 'slider',
			controls: oSlider.getId() + '-grip',
			orientation: sOriantation,
			valuemin: oSlider.getValue(),
			valuemax: oSlider.getMax(),
			disabled: !oSlider.getEditable() || !oSlider.getEnabled(),
			describedby: oSlider.getTooltip_AsString() ? (oSlider.getId() + '-Descr ' + oSlider.getAriaDescribedBy().join(" ")) : undefined
		});

		rm.write('>&#9650;</DIV>'); // Symbol for HCB Theme (Must be hidden in other themes)

	};

	/**
	 * Adds extra code to the control (i.e. in subclasses), using the provided {@link sap.ui.fw.RenderManager}.
	 *
	 * @param {sap.ui.fw.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.commons.RangeSlider} oSlider An object representation of the control that should be rendered.
	 */
	RangeSliderRenderer.controlAdditionalCode = function(rm, oSlider){
		rm.addClass('sapUiRSli');
	};

	return RangeSliderRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RangeSliderRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RatingIndicator') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RatingIndicator.
jQuery.sap.declare('sap.ui.commons.RatingIndicator'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RatingIndicator",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/theming/Parameters'],
	function(jQuery, library, Control, Parameters) {
	"use strict";


	
	/**
	 * Constructor for a new RatingIndicator.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Is used to let the user do some rating on a certain topic. The amount of rating symbols can be specified, as well as the URIs to the
	 * image icons which shall be used as rating symbols. When the user performs a rating, an event is fired.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RatingIndicator
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RatingIndicator = Control.extend("sap.ui.commons.RatingIndicator", /** @lends sap.ui.commons.RatingIndicator.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
			/**
			 * Value 'true' is required for changes on the rating symbols.
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * The number of displayed rating symbols
			 */
			maxValue : {type : "int", group : "Behavior", defaultValue : 5},
	
			/**
			 * The currently selected value. If value is set to sap.ui.commons.RatingIndicator.NoValue, the averageValue is shown.
			 */
			value : {type : "float", group : "Behavior", defaultValue : 0, bindable : "bindable"},
	
			/**
			 * This value is shown if no value is set. This can be used to display an average Value before the user votes.
			 */
			averageValue : {type : "float", group : "Behavior", defaultValue : 0},
	
			/**
			 * The URI to the image which shall be displayed for all selected rating symbols.
			 * Note that when this attribute is used, also the other icon attributes need to be set.
			 */
			iconSelected : {type : "sap.ui.core.URI", group : "Behavior", defaultValue : null},
	
			/**
			 * The URI to the image which shall be displayed for all unselected rating symbols. If this attribute is used, a requirement is that all custom icons need to have the same size.
			 * Note that when this attribute is used also the other icon attributes need to be set.
			 */
			iconUnselected : {type : "sap.ui.core.URI", group : "Behavior", defaultValue : null},
	
			/**
			 * The URI to the image which is displayed when the mouse hovers onto a rating symbol.
			 * If used, a requirement is that all custom icons need to have the same size.
			 * Note that when this attribute is used also the other icon attributes need to be set.
			 */
			iconHovered : {type : "sap.ui.core.URI", group : "Behavior", defaultValue : null},
	
			/**
			 * Defines how float values are visualized: Full, Half, Continuous (see enumeration RatingIndicatorVisualMode)
			 */
			visualMode : {type : "sap.ui.commons.RatingIndicatorVisualMode", group : "Behavior", defaultValue : sap.ui.commons.RatingIndicatorVisualMode.Half}
		},
		associations : {
	
			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
	
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {
	
			/**
			 * The event is fired when the user has done a rating.
			 */
			change : {
				parameters : {
	
					/**
					 * The rated value
					 */
					value : {type : "int"}
				}
			}
		}
	}});
	
	
	RatingIndicator.NoValue = -9999;
	/**
	 * Control Initialization
	 * @private
	 */
	RatingIndicator.prototype.init = function(){
		this.iHoveredRating = -1;
	};
	
	/**
	 * Does all the cleanup when the RatingIndicator is to be destroyed.
	 * Called from Element's destroy() method.
	 * @private
	 */
	RatingIndicator.prototype.exit = function (){
		// no super.exit() to call
	};
	
	/**
	 * Called when the theme is changed.
	 * @private
	 */
	RatingIndicator.prototype.onThemeChanged = function(oEvent){
		if (this.getDomRef()) {
			this.invalidate();
		}
	};
	
	/**
	 * Avoid dragging the icons.
	 * @private
	 */
	RatingIndicator.prototype.ondragstart = function(oEvent){
		oEvent.preventDefault();
	};
	
	/**
	 * Returns the value to be displayed, which is either a set value or (if no value is set) the
	 * averageValue
	 * @private
	 */
	RatingIndicator.prototype._getDisplayValue = function() {
		var fValue = this.getValue();
		
		if (fValue == RatingIndicator.NoValue) {
			// If the value is set to sap.ui.commons.RatingIndicator.NoValue, show the averageValue 
			return this.getAverageValue();
		} else {
			return fValue;
		}
	};
	
	/**
	 * Behavior implementation which is executed when the user presses Arrow Right (Left in RTL case) or Arrow Up.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onsapincrease = function(oEvent){
		var iNewHoverValue = this.iHoveredRating;
	
		if (iNewHoverValue == -1) {
			iNewHoverValue = Math.round(this._getDisplayValue()) - 1;
			if (iNewHoverValue == -1) {
				iNewHoverValue = 0;
			}
		}
	
		if (iNewHoverValue < this.getMaxValue()) {
			iNewHoverValue = iNewHoverValue + 1;
		} else {
			iNewHoverValue = this.getMaxValue();
		}
	
		this.updateHoverState(oEvent, iNewHoverValue);
	};
	
	/**
	 * Behavior implementation which is executed when the user presses Arrow Left (Right in RTL case) or Arrow Down.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onsapdecrease = function(oEvent){
		var iNewHoverValue = this.iHoveredRating;
	
		if (iNewHoverValue == -1 && Math.round(this._getDisplayValue()) == 0) {
			return;
		}
	
		if (iNewHoverValue == -1) {
			iNewHoverValue = Math.round(this._getDisplayValue()) + 1;
		}
	
		if (iNewHoverValue > 1) {
			iNewHoverValue = iNewHoverValue - 1;
		} else {
			iNewHoverValue = 1;
		}
	
		this.updateHoverState(oEvent, iNewHoverValue);
	};
	
	/**
	 * Behavior implementation which is executed when the user presses Home.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onsaphome = function(oEvent){
		this.updateHoverState(oEvent, 1);
	};
	
	/**
	 * Behavior implementation which is executed when the user presses End.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onsapend = function(oEvent){
		this.updateHoverState(oEvent, this.getMaxValue());
	};
	
	/**
	 * Behavior implementation which is executed when the user presses Enter or Space.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onsapselect = function(oEvent){
		this.saveValue(oEvent, true, this.iHoveredRating);
	};
	
	/**
	 * Behavior implementation which is executed when the user presses Esc.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onsapescape = function(oEvent){
		this.saveValue(oEvent, true, -1);
	};
	
	/**
	 * Behavior implementation which is executed when the control loses the focus.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onfocusout = function(oEvent){
		//Do not react on focusouts of child DOM refs in IE
		if (!!sap.ui.Device.browser.internet_explorer && oEvent.target != this.getDomRef()) {
			return;
		}
		this.saveValue(oEvent, false, this.iHoveredRating);
	};
	
	/**
	 * Behavior implementation which is executed when the control gets the focus.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onfocusin = function(oEvent){
		//Avoid focusing child DOM refs in IE
		if (!!sap.ui.Device.browser.internet_explorer && oEvent.target != this.getDomRef()) {
			this.getDomRef().focus();
		}
	};
	
	/**
	 * Behavior implementation which is executed when the user clicks on a rating symbol.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onclick = function(oEvent){
		this.saveValue(oEvent, true, this.getSymbolValue(oEvent));
	};
	
	/**
	 * Behavior implementation which is executed when the user moves the mouse on a rating symbol.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onmouseover = function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
	
		if (!this.getEditable()) {
			return;
		}
		this.iHoveredRating = -1;
	
		var symbolValue = this.getSymbolValue(oEvent);
		if (symbolValue == -1) {
			return;
		}
	
		for (var i = 1; i <= symbolValue; i++) {
			sap.ui.commons.RatingIndicatorRenderer.hoverRatingSymbol(i, this);
		}
		for (var i = symbolValue + 1; i <= this.getMaxValue(); i++) {
			sap.ui.commons.RatingIndicatorRenderer.hoverRatingSymbol(i, this, true);
		}
	};
	
	/**
	 * Behavior implementation which is executed when the user moves the mouse out of the rating symbol.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.onmouseout = function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
	
		if (!this.getEditable()) {
			return;
		}
	
		if (jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())) {
			this.iHoveredRating = -1;
			for (var i = 1; i <= this.getMaxValue(); i++) {
				sap.ui.commons.RatingIndicatorRenderer.unhoverRatingSymbol(i, this);
			}
		}
	};
	
	/**
	 * Returns the rating symbol value which is affected by the given event or -1
	 * if the event was not on a rating symbol.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RatingIndicator.prototype.getSymbolValue = function(oEvent){
		var oSymbol = jQuery(oEvent.target);
		if (oSymbol.hasClass("sapUiRatingItmImg") || oSymbol.hasClass("sapUiRatingItmOvrflw")) {
			oSymbol = jQuery(oEvent.target.parentNode);
		} else if (oSymbol.hasClass("sapUiRatingItmOvrflwImg")) {
			oSymbol = jQuery(oEvent.target.parentNode.parentNode);
		}
		var itemvalue = oSymbol.attr("itemvalue");
		if (itemvalue) {
			return parseInt(itemvalue, 10);
		}
		return -1;
	};
	
	/**
	 * Updates the hover state according to the current pending keyboard input.
	 *
	 * @private
	 */
	RatingIndicator.prototype.updateKeyboardHoverState = function(bSkipHoverAfter){
		for (var i = 1; i <= this.getMaxValue(); i++) {
			sap.ui.commons.RatingIndicatorRenderer.unhoverRatingSymbol(i, this);
			if (i <= this.iHoveredRating) {
				sap.ui.commons.RatingIndicatorRenderer.hoverRatingSymbol(i, this);
			} else if (!bSkipHoverAfter) {
				sap.ui.commons.RatingIndicatorRenderer.hoverRatingSymbol(i, this, true);
			}
		}
		this.setAriaState();
	};
	
	/**
	 * Called by the framework when rendering is completed.
	 *
	 * @private
	 */
	RatingIndicator.prototype.onAfterRendering = function() {
		this.setAriaState();
	};
	
	/**
	 * Updates the ARIA state initially and in case of changes.
	 *
	 * @private
	 */
	RatingIndicator.prototype.setAriaState = function() {
		var val = this.iHoveredRating == -1 ? this._getDisplayValue() : this.iHoveredRating;
		this.$().attr("aria-valuenow", val).attr("aria-valuetext", this._getText("RATING_ARIA_VALUE" , [val])).attr("aria-label", this._getText("RATING_ARIA_NAME"));
	};
	
	/**
	 * Load language dependent texts.
	 *
	 * @private
	 */
	RatingIndicator.prototype._getText = function(sKey, aArgs) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
		if (rb) {
			return rb.getText(sKey, aArgs);
		}
		return sKey;
	};
	
	/**
	 * Helper function to save the value and fire the change event.
	 *
	 * @param {jQuery.Event} oEvent
	 * @param {boolean} bstopEvent
	 * @param {int} iNewValue
	 * @private
	 */
	RatingIndicator.prototype.saveValue = function(oEvent, bstopEvent, iNewValue) {
		if (bstopEvent) {
			oEvent.preventDefault();
			// the control should not stop browser event propagation
			// Example: table control needs to catch and handle the event as well
			//oEvent.stopPropagation();
		}
		if (!this.getEditable()) {
			return false;
		}
	
		this.iHoveredRating = -1;
		if (iNewValue != -1 && iNewValue != this.getValue()) {
			this.setValue(iNewValue);
			this.fireChange({value:iNewValue});
			return true;
		} else {
			//Update hover state only if value is not changed (otherwise rerendering is done anyway)
			for (var i = 1; i <= this.getMaxValue(); i++) {
				sap.ui.commons.RatingIndicatorRenderer.unhoverRatingSymbol(i, this);
			}
			this.setAriaState();
			return false;
		}
	};
	
	/**
	 * Helper function to update the hover state when keyboard is used.
	 *
	 * @param {jQuery.Event} oEvent
	 * @param {interger} iNewHoverValue
	 * @private
	 */
	RatingIndicator.prototype.updateHoverState = function(oEvent, iNewHoverValue) {
		oEvent.preventDefault();
		oEvent.stopPropagation();
		if (!this.getEditable()) {
			return;
		}
		this.iHoveredRating = iNewHoverValue;
		this.updateKeyboardHoverState();
	};
	
	/**
	 * Setter for property <code>maxValue</code>.
	 *
	 * Default value is <code>5</code>
	 * Minimum value is <code>1</code>
	 *
	 * @param {int} iMaxValue new value for property <code>maxValue</code>
	 * @return {sap.ui.commons.RatingIndicator} <code>this</code> to allow method chaining
	 * @public
	 */
	RatingIndicator.prototype.setMaxValue = function(iMaxValue) {
		if (iMaxValue < 1) {
			iMaxValue = 1;
		}
		this.setProperty("maxValue", iMaxValue);
		return this;
	};
	

	return RatingIndicator;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RatingIndicator.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ResponsiveContainer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ResponsiveContainer.
jQuery.sap.declare('sap.ui.commons.ResponsiveContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ResponsiveContainer",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/ResizeHandler'],
	function(jQuery, library, Control, ResizeHandler) {
	"use strict";


	
	/**
	 * Constructor for a new ResponsiveContainer.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Is used to provide a container, which can show different content depending on its current width. It fires an event, whenever a new range is reached. In addition the content of the new range is automatically shown, if it is set.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ResponsiveContainer
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ResponsiveContainer = Control.extend("sap.ui.commons.ResponsiveContainer", /** @lends sap.ui.commons.ResponsiveContainer.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * The width of the responsive container.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
	
			/**
			 * The width of the responsive container.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'}
		},
		aggregations : {
	
			/**
			 * The ranges defined for this container
			 */
			ranges : {type : "sap.ui.commons.ResponsiveContainerRange", multiple : true, singularName : "range"}, 
	
			/**
			 * The currently shown content, either the default content or content of a range
			 */
			content : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
		},
		associations : {
	
			/**
			 * The default content to show, in case the range does not provide content
			 */
			defaultContent : {type : "sap.ui.core.Control", multiple : false}
		},
		events : {
	
			/**
			 * The event is fired the width of the container reaches a new range.
			 */
			rangeSwitch : {
				parameters : {
	
					/**
					 * The current range
					 */
					currentRange : {type : "sap.ui.commons.ResponsiveContainerRange"}
				}
			}
		}
	}});
	
	
	/**
	 * Control Initialization
	 * @private
	 */
	ResponsiveContainer.prototype.init = function(){
		this.oCurrentRange = null;
	};
	
	/**
	 * Destructor
	 * @private
	 */
	ResponsiveContainer.prototype.exit = function (){
		// Cleanup resize event registration on exit
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};
	
	/**
	 * Before rendering
	 */
	ResponsiveContainer.prototype.onBeforeRendering = function() {
		// Cleanup resize event registration before re-rendering
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
		if (!this.getAggregation("content")) {
			var oDefaultContent = sap.ui.getCore().byId(this.getDefaultContent());
			this.setAggregation("content", oDefaultContent);
		}
	};
	
	/**
	 * After rendering
	 */
	ResponsiveContainer.prototype.onAfterRendering = function() {
		var fnResizeHandler = jQuery.proxy(this.onresize, this);
		this.sResizeListenerId = ResizeHandler.register(this.getDomRef(), fnResizeHandler);
		this.refreshRangeDimensions();
		if (!this.oCurrentRange) {
			setTimeout(fnResizeHandler, 0);
		}
	};
	
	/**
	 * Resize handling
	 */
	ResponsiveContainer.prototype.onresize = function(oEvent) {
		var oRange = this.findMatchingRange(),
			sContentId = oRange && oRange.getContent(),
			oNewContent;
		if (this.oCurrentRange != oRange) {
			this.oCurrentRange = oRange;
			if (!oRange) {
				sContentId = this.getDefaultContent();
			}
			oNewContent = sap.ui.getCore().byId(sContentId);
			this.setAggregation("content", oNewContent);
			this.fireRangeSwitch({
				currentRange: this.oCurrentRange
			});
		}
	};
	
	/**
	 * Refresh ranges, updates the range sizes from the DOM.
	 * Loop through all the rendered divs for the ranges and read their width and height
	 * for later comparison with the current container size
	 */
	ResponsiveContainer.prototype.refreshRangeDimensions = function() {
		var aRanges = this.getRanges(),
			aRangeDimensions = [],
			$Range;
		jQuery.each(aRanges, function(i, oRange) {
			$Range = oRange.$();
			aRangeDimensions.push({
				range: oRange,
				width: $Range.width(),
				height: $Range.height()
			});
		});
		this.aRangeDimensions = aRangeDimensions;
	};
	
	/**
	 * Find best matching range, finds the range which best fills the available space.
	 * Reads the current width and height of the container and compares to the stored range
	 * dimensions to find the best match.
	 */
	ResponsiveContainer.prototype.findMatchingRange = function() {
		var $Container = this.$(),
			iWidth = $Container.width(),
			iHeight = $Container.height(),
			iRangeWidth, iRangeHeight,
			aRangeDimensions = this.aRangeDimensions,
			oMatch = null;
		jQuery.each(aRangeDimensions, function(i, oRangeDim) {
			iRangeWidth = oRangeDim.width || iWidth;
			iRangeHeight = oRangeDim.height || iHeight;
			if (iRangeWidth <= iWidth && iRangeHeight <= iHeight) {
				oRangeDim.area = iRangeWidth * iRangeHeight;
				if (!oMatch || oMatch.area < oRangeDim.area) {
					oMatch = oRangeDim;
				}
			}
		});
		return oMatch && oMatch.range;
	};
	
	

	return ResponsiveContainer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ResponsiveContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ResponsiveContainerRange') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ResponsiveContainerRange.
jQuery.sap.declare('sap.ui.commons.ResponsiveContainerRange'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ResponsiveContainerRange",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new ResponsiveContainerRange.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Defines a range for the ResponsiveContainer
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ResponsiveContainerRange
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ResponsiveContainerRange = Control.extend("sap.ui.commons.ResponsiveContainerRange", /** @lends sap.ui.commons.ResponsiveContainerRange.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * The minimal width for this range to be displayed.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
	
			/**
			 * The minimal height for this range to be displayed.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
	
			/**
			 * A key which can be used to identify the range (optional).
			 */
			key : {type : "string", group : "Misc", defaultValue : ''}
		},
		associations : {
	
			/**
			 * The content to show for this range (optional).
			 */
			content : {type : "sap.ui.core.Control", multiple : false}
		}
	}});
	
	

	return ResponsiveContainerRange;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ResponsiveContainerRange.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RichTooltip') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RichTooltip.
jQuery.sap.declare('sap.ui.commons.RichTooltip'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.TooltipBase'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RichTooltip",['jquery.sap.global', './library', 'sap/ui/core/TooltipBase'],
	function(jQuery, library, TooltipBase) {
	"use strict";


	
	/**
	 * Constructor for a new RichTooltip.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * 
	 * Is used to provide tool tips that can have long text, image and title. This tool tip extends the TooltipBase.
	 * @extends sap.ui.core.TooltipBase
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RichTooltip
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RichTooltip = TooltipBase.extend("sap.ui.commons.RichTooltip", /** @lends sap.ui.commons.RichTooltip.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Tool tip title to be displayed in the header.
			 */
			title : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * If RichTooltip contains an image, this property is used to define the source path.
			 */
			imageSrc : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * This property is an individual text that will be used instead of the default ValueState text
			 * @since 1.11.1
			 */
			valueStateText : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * This is the alt text for the image
			 * @since 1.11.1
			 */
			imageAltText : {type : "string", group : "Misc", defaultValue : null}
		},
		aggregations : {
	
			/**
			 * FormattedTextView control used in the content area to enable HTML-text within the content
			 */
			formattedText : {type : "sap.ui.commons.FormattedTextView", multiple : false, visibility : "hidden"}, 
	
			/**
			 * Value State Text that can be specified individually.
			 */
			individualStateText : {type : "sap.ui.commons.FormattedTextView", multiple : false, visibility : "hidden"}
		}
	}});
	
	/**
	 * Calculates the height of the RichTooltip to set a proper min-height.
	 * Additionally the ARIA attributes are set to the corresponding elements.
	 *
	 * @protected
	 */
	RichTooltip.prototype.onAfterRendering = function() {
		var oText = this.getAggregation("formattedText");
		if (oText && oText.getDomRef()) {
			// set a corresponding ARIA role if there is a text
			oText.$().attr("role", "tooltip");
	
			if (this.getImageSrc() !== "") {
				// if text and image are set a bigger min-width is needed
				this.$().addClass("sapUiRttContentWide");
			}
		}
	};
	
	/**
	 * This sets an individual text for the ValueState of the parent element of the RichTooltip.
	 *
	 * @param {string} sText the text that should be shown as individual ValueState text
	 * @returns {sap.ui.commons.RichTooltip} Returns <code>this</code> to facilitate method chaining.
	 * @public
	 */
	RichTooltip.prototype.setValueStateText = function(sText) {
		var oValueStateText = this.getAggregation("individualStateText");
		if (sText) {
			if (oValueStateText) {
				oValueStateText.setHtmlText(sText);
			} else {
				oValueStateText = new sap.ui.commons.FormattedTextView(this.getId() + "-valueStateText", {
					htmlText : sText
				}).addStyleClass("sapUiRttValueStateText").addStyleClass("individual");
	
				this.setAggregation("individualStateText", oValueStateText);
				this.setProperty("valueStateText", sText, true);
			}
		} else {
			if (oValueStateText) {
				this.setAggregation("individualStateText", oValueStateText);
			}
		}
	};
	
	/**
	 * This returns the previously set text. Since a FormattedTextView is used for
	 * rendering and stuff the corresponding property of the FormattedTextView is
	 * being read and returned. If no text was set an empty string is being
	 * returned.
	 *
	 * @returns {string} the ValueState text that was previously set.
	 * @public
	 */
	RichTooltip.prototype.getValueStateText = function() {
		var oValueStateText = this.getAggregation("individualStateText");
		if (oValueStateText) {
			return oValueStateText.getHtmlText();
		}
		return "";
	};
	
	/**
	 * This overrides the function of TooltipBase to create a FormattedTextView that
	 * should be used for rendering
	 *
	 * @override sap.ui.core.TooltipBase.setText
	 * @param sText
	 *            {sap.ui.core.string} the text that should be shown
	 */
	RichTooltip.prototype.setText = function(sText) {
		if (!!sText) {
			//replace carriage returns etc. with br tag
			sText = sText.replace(/(\r\n|\n|\r)/g,"<br />");
		}
		var oText = this.getAggregation("formattedText");
		if (oText) {
			oText.setHtmlText(sText);
		} else {
			oText = new sap.ui.commons.FormattedTextView(this.getId() + "-txt", {
				htmlText : sText
			}).addStyleClass("sapUiRttText");
			this.setAggregation("formattedText", oText);
			this.setProperty("text", sText, true);
		}
	};
	
	/**
	 * This returns the previously set text. Since a FormattedTextView is used for
	 * rendering and stuff the corresponding property of the FormattedTextView is
	 * being read and returned. If no text was set an empty string is being
	 * returned.
	 *
	 * @returns {sap.ui.core.string} the text that was previously set.
	 * @override TooltipBase.getText
	 */
	RichTooltip.prototype.getText = function() {
		var oText = this.getAggregation("formattedText");
		if (oText) {
			return oText.getHtmlText();
		}
		return "";
	};
	
	RichTooltip.prototype.onfocusin = function(oEvent) {
		TooltipBase.prototype.onfocusin.apply(this, arguments);
	
		var oSC = jQuery(oEvent.target).control(0);
		if (oSC != null) {
			var sId = this.getId();
			var sIds = "";
	
			if (this.getTitle() !== "") {
				sIds += sId + "-title ";
			}
	
			var $valueStateText = this.$("valueStateText");
			if ($valueStateText.length > 0) {
				sIds += sId + "-valueStateText ";
			}
	
			// alt image
			if (this.getImageSrc() !== "") {
				sIds += sId + "-image ";
			}
	
			//
			if (this.getText() !== "") {
				sIds += sId + "-txt";
			}
	
			var oDomRef = oSC.getFocusDomRef();
			oDomRef.setAttribute("aria-describedby", sIds);
		}
	};
	

	return RichTooltip;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RichTooltip.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RoadMap') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RoadMap.
jQuery.sap.declare('sap.ui.commons.RoadMap'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RoadMap",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new RoadMap.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Is used to display step-by-step work flows of a clearly defined work process
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RoadMap
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RoadMap = Control.extend("sap.ui.commons.RoadMap", /** @lends sap.ui.commons.RoadMap.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Total number of steps to be displayed at once
			 */
			numberOfVisibleSteps : {type : "int", group : "Misc", defaultValue : null},
	
			/**
			 * Id of the first step to be displayed
			 */
			firstVisibleStep : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Id of the step which is currently selected
			 */
			selectedStep : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Control width in CSS size
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'}
		},
		defaultAggregation : "steps",
		aggregations : {
	
			/**
			 * Steps that are composing the RoadMap
			 */
			steps : {type : "sap.ui.commons.RoadMapStep", multiple : true, singularName : "step"}
		},
		events : {
	
			/**
			 * Event is fired when the user selects a step; assumption is that this step was not selected with the previously done select action.
			 */
			stepSelected : {
				parameters : {
	
					/**
					 * Id of the selected step
					 */
					stepId : {type : "string"}
				}
			}, 
	
			/**
			 * Event is fired when a given step is expanded or collapsed by user.
			 */
			stepExpanded : {
				parameters : {
	
					/**
					 * Id of the expanded/collapsed step
					 */
					stepId : {type : "string"}
				}
			}
		}
	}});
	
	(function() {
	
	/**
	 * Does the setup when the RoadMap is created.
	 * @private
	 */
	RoadMap.prototype.init = function(){
		this.iStepWidth = -1;
		this.sCurrentFocusedStepRefId = null;
	};
	
	/**
	 * Does all the cleanup when the RoadMap is to be destroyed.
	 * Called from Element's destroy() method.
	 * @private
	 */
	RoadMap.prototype.exit = function (){
		// Cleanup resize event registration
		if (this.sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};
	
	
	//Setter for property numberOfVisibleSteps which suppresses rerendering if possible -> Comment generated automatically
	RoadMap.prototype.setNumberOfVisibleSteps = function(iNumberOfVisibleSteps) {
		var bIsRendered = this.getDomRef() ? true : false;
		this.setProperty("numberOfVisibleSteps", iNumberOfVisibleSteps, bIsRendered);
		if (bIsRendered) {
			sap.ui.commons.RoadMapRenderer.updateScrollArea(this, true);
		}
		return this;
	};
	
	
	//Setter for property firstVisibleStep which suppresses rerendering if possible -> Comment generated automatically
	RoadMap.prototype.setFirstVisibleStep = function(sFirstVisibleStep) {
		var bIsRendered = this.getDomRef() ? true : false;
		if (bIsRendered) {
			if (sFirstVisibleStep) {
				var oStep = sap.ui.getCore().byId(sFirstVisibleStep);
				if (oStep && oStep.getParent() && (oStep.getParent() === this || oStep.getParent().getParent() === this) && oStep.getVisible()) {
					this.setProperty("firstVisibleStep", sFirstVisibleStep, true);
					sap.ui.commons.RoadMapRenderer.updateScrollArea(this);
				}
			} else {
				this.setProperty("firstVisibleStep", "", true);
				sap.ui.commons.RoadMapRenderer.updateScrollArea(this);
			}
		} else {
			this.setProperty("firstVisibleStep", sFirstVisibleStep);
		}
		return this;
	};
	
	
	//Setter for property width which suppresses rerendering if possible -> Comment generated automatically
	RoadMap.prototype.setWidth = function(sWidth) {
		var bIsRendered = this.getDomRef() ? true : false;
		this.setProperty("width", sWidth, bIsRendered);
		if (bIsRendered) {
			sap.ui.commons.RoadMapRenderer.setRoadMapWidth(this, sWidth);
			sap.ui.commons.RoadMapRenderer.updateScrollArea(this, true);
		}
		return this;
	};
	
	
	//Setter for property selectedStep which suppresses rerendering if possible -> Comment generated automatically
	RoadMap.prototype.setSelectedStep = function(sSelectedStep) {
		var bIsRendered = this.getDomRef() ? true : false;
		if (bIsRendered) {
			if (sSelectedStep) {
				var oStep = sap.ui.getCore().byId(sSelectedStep);
				if (oStep && oStep.getParent() && (oStep.getParent() === this || oStep.getParent().getParent() === this)
					&& oStep.getEnabled() && oStep.getVisible()) {
					sap.ui.commons.RoadMapRenderer.selectStepWithId(this, sSelectedStep);
					this.setProperty("selectedStep", sSelectedStep, true);
				}
			} else {
				sap.ui.commons.RoadMapRenderer.selectStepWithId(this, "");
				this.setProperty("selectedStep", "", true);
			}
		} else {
			this.setProperty("selectedStep", sSelectedStep);
		}
		return this;
	};
	
	
	/**
	 * Called when the theme is changed.
	 * @private
	 */
	RoadMap.prototype.onThemeChanged = function(oEvent){
		this.iStepWidth = -1;
		if (this.getDomRef()) {
			this.invalidate();
		}
	};
	
	
	/**
	 * Called before rendering starts by the renderer
	 * (This is not the onBeforeRendering method which would be not called for the first rendering)
	 * @private
	 */
	RoadMap.prototype.doBeforeRendering = function(){
		//Bring the properties into a solid state
		var bIsValidSelectedStep = false;
		var bIsValidFirstStep = false;
		var aSteps = this.getSteps();
		for (var i = 0; i < aSteps.length; i++) {
			var oStep = aSteps[i];
			//expanded=true only possible if substeps available and enabled
			if (oStep.getSubSteps().length == 0 || !oStep.getEnabled()) {
				oStep.setProperty("expanded", false, true);
			}
			//A selected step must exist, be enabled and visible
			if (!oStep.getEnabled() && !oStep.getVisible() && this.getSelectedStep() == oStep.getId()) {
				this.setProperty("selectedStep", "", true);
			} else if (oStep.getEnabled() && oStep.getVisible() && this.getSelectedStep() == oStep.getId()) {
				bIsValidSelectedStep = true;
			}
			//A first step must exist and be visible
			if (oStep.getVisible() && this.getFirstVisibleStep() == oStep.getId()) {
				bIsValidFirstStep = true;
			}
	
			var aSubSteps = oStep.getSubSteps();
			for (var j = 0; j < aSubSteps.length; j++) {
				var oSubStep = aSubSteps[j];
				//expanded always false
				oSubStep.setProperty("expanded", false, true);
				//A selected step must exist, be enabled and visible
				if (!oSubStep.getEnabled() && !oSubStep.getVisible() && this.getSelectedStep() == oSubStep.getId()) {
					this.setProperty("selectedStep", "", true);
				} else if (oSubStep.getEnabled() && oSubStep.getVisible() && this.getSelectedStep() == oSubStep.getId()) {
					bIsValidSelectedStep = true;
				}
				//A first step must exist and be visible
				if (oSubStep.getVisible() && this.getFirstVisibleStep() == oSubStep.getId()) {
					bIsValidFirstStep = true;
				}
			}
		}
	
		if (!bIsValidSelectedStep) {
			this.setProperty("selectedStep", "", true);
		}
		if (!bIsValidFirstStep) {
			this.setProperty("firstVisibleStep", "", true);
		}
	
		// Cleanup resize event registration before re-rendering
		if (this.sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};
	
	
	/**
	 * Called when the rendering is complete
	 * @private
	 */
	RoadMap.prototype.onAfterRendering = function(){
	
		var aSteps = this.getSteps();
	
		//Compute the step width
		if (this.iStepWidth == -1 && aSteps.length > 0) {
			var jRef = aSteps[0].$();
			this.iStepWidth = jRef.outerWidth();
		}
	
		//Adapt the step labels if needed
		for (var i = 0; i < aSteps.length; i++) {
			var oStep = aSteps[i];
			sap.ui.commons.RoadMapRenderer.addEllipses(oStep);
			var aSubSteps = oStep.getSubSteps();
			for (var j = 0; j < aSubSteps.length; j++) {
				sap.ui.commons.RoadMapRenderer.addEllipses(aSubSteps[j]);
			}
		}
	
		//Adapt the size of the scroll area
		sap.ui.commons.RoadMapRenderer.updateScrollArea(this);
	
		// Listen to resizing
		this.sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(), jQuery.proxy(this.onresize, this));
	};
	
	
	/**
	 * Called when the Roadmap is resized
	 * @private
	 */
	RoadMap.prototype.onresize = function(oEvent) {
		var fDoOnResize = function() {
			if (this.getDomRef()) {
				//Adapt the size of the scroll area
				sap.ui.commons.RoadMapRenderer.updateScrollArea(this, true);
				refreshFocus(this, "prev");
				this.sResizeInProgress = null;
			}
		};
	
		if (!!sap.ui.Device.browser.firefox) {
			fDoOnResize.apply(this, []);
		} else {
			if (!this.sResizeInProgress) {
				this.sResizeInProgress = jQuery.sap.delayedCall(300, this, fDoOnResize);
			}
		}
	};
	
	
	/**
	 * Behavior implementation which is executed when the user clicks the step.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onclick = function(oEvent){
		handleSelect(this, oEvent);
	};
	
	
	/**
	 * Behavior implementation which is executed when the user presses the space or enter key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onsapselect = function(oEvent){
		handleSelect(this, oEvent);
	};
	
	
	/**
	 * Behavior implementation which is executed when the focus comes into the control or on one of its children.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onfocusin = function(oEvent){
		var jTarget = jQuery(oEvent.target);
		var jTargetId = jTarget.attr("id");
		/*eslint no-empty:1 */
		//TODO Rethink if empty block is needed
		if (jTargetId && jQuery.sap.endsWith(jTargetId, "-box")) {
			this.sCurrentFocusedStepRefId = jTargetId.substring(0, jTargetId.length - 4);
		} else if (jTargetId && (jQuery.sap.endsWith(jTargetId, "-Start") || jQuery.sap.endsWith(jTargetId, "-End"))) {
			//Keep the current focus
		} else {
			this.sCurrentFocusedStepRefId = sap.ui.commons.RoadMapRenderer.getFirstVisibleRef(this).attr("id");
			refreshFocus(this);
		}
		//Remove the control from tab chain to make tab out working (see onfocusout)
		this.$().attr("tabindex", "-1");
	};
	
	
	/**
	 * Behavior implementation which is executed when the focus leaves the control or one of its children.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onfocusout = function(oEvent){
		//Add the control to tab chain again to make tab in working (see onfocusin)
		this.$().attr("tabindex", "0");
	};
	
	
	/**
	 * Behavior implementation which is executed when the user presses the arrow up or arrow left (RTL: arrow right) key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onsapprevious = function(oEvent){
		focusStep(oEvent, this, "prev");
	};
	
	
	/**
	 * Behavior implementation which is executed when the user presses the arrow down or arrow right (RTL: arrow left) key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onsapnext = function(oEvent){
		focusStep(oEvent, this, "next");
	};
	
	
	/**
	 * Behavior implementation which is executed when the user presses the home/pos1 key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onsaphome = function(oEvent){
		focusStep(oEvent, this, "first");
	};
	
	
	/**
	 * Behavior implementation which is executed when the user presses the end key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMap.prototype.onsapend = function(oEvent){
		focusStep(oEvent, this, "last");
	};
	
	
	//********* Private *********
	
	
	//Called when either the Roadmap is clicked or the space or enter key is pressed
	var handleSelect = function(oThis, oEvent){
		oEvent.stopPropagation();
		oEvent.preventDefault();
	
		var jTarget = jQuery(oEvent.target);
		var sTargetId = jTarget.attr("id");
	
		if (!sTargetId) {
			return;
		}
	
		//Handle event for the end of an expandable step
		var iIdx = sTargetId.lastIndexOf("-expandend");
		if (iIdx != -1) {
			var oStep = sap.ui.getCore().byId(sTargetId.substring(0, iIdx));
			if (oStep && oThis.indexOfStep(oStep) >= 0) {
				oStep.handleSelect(oEvent, true);
				return;
			}
		}
	
		//Handle select on delimiter
		if (sTargetId == oThis.getId() + "-Start") {
			if (jTarget.hasClass("sapUiRoadMapStartScroll")) {
				scrollToNextStep(oThis, "prev", true);
			} else {
				refreshFocus(oThis);
			}
		} else if (sTargetId == oThis.getId() + "-End") {
			if (jTarget.hasClass("sapUiRoadMapEndScroll")) {
				scrollToNextStep(oThis, "next", true);
			} else {
				refreshFocus(oThis);
			}
		}
	};
	
	
	//Helper function to scroll to following step (optionally with updating the focus (see focusStep)).
	//Allowed directions are: next, prev, first, last.
	var scrollToNextStep = function(oThis, sDir, bUpdateFocus){
		sap.ui.commons.RoadMapRenderer.scrollToNextStep(oThis, sDir, function(sFirstVisibleNodeId){
			var iIdx = sFirstVisibleNodeId.lastIndexOf("-expandend");
			if (iIdx != -1) {
				sFirstVisibleNodeId = sFirstVisibleNodeId.substring(0, iIdx);
			}
			oThis.setProperty("firstVisibleStep", sFirstVisibleNodeId, true);
	
			if (bUpdateFocus) {
				refreshFocus(oThis, sDir);
			}
		});
	};
	
	
	//Helper function to focus the following step of the current focused step in the given direction.
	//Allowed directions are: next, prev, first, last. If this step is not visible an automatic scrolling is done.
	var focusStep = function(oEvent, oThis, sDir){
		if (oEvent) {
			oEvent.stopPropagation();
			oEvent.preventDefault();
		}
		if (!oThis.sCurrentFocusedStepRefId) {
			return;
		}
	
		var sFoo = sDir + "All";
		var bIsJumpToDelimiter = false;
		if (sDir == "first") {
			sFoo = "prevAll";
			bIsJumpToDelimiter = true;
		} else if (sDir == "last") {
			sFoo = "nextAll";
			bIsJumpToDelimiter = true;
		}
	
		var jCurrentFocusStep = jQuery.sap.byId(oThis.sCurrentFocusedStepRefId);
		var jFollowingSteps = jCurrentFocusStep[sFoo](":visible");
		var sFollowingFocusStepId = jQuery(jFollowingSteps.get(bIsJumpToDelimiter ? jFollowingSteps.length - 1 : 0)).attr("id");
		if (sFollowingFocusStepId) {
			if (!sap.ui.commons.RoadMapRenderer.isVisibleRef(oThis, sFollowingFocusStepId)) {
				scrollToNextStep(oThis, sDir);
			}
	
			jQuery.sap.byId(sFollowingFocusStepId + "-box").get(0).focus();
		}
	};
	
	
	//Sets the focus on the current focused step again. If the current focused step is not visible anymore
	//the following step in the given direction is focused. Allowed directions are: next, prev, first, last
	var refreshFocus = function(oThis, sDir){
		if (!oThis.sCurrentFocusedStepRefId) {
			return;
		}
	
		if (sDir && !sap.ui.commons.RoadMapRenderer.isVisibleRef(oThis, oThis.sCurrentFocusedStepRefId)) {
			focusStep(null, oThis, sDir);
		} else {
			jQuery.sap.byId(oThis.sCurrentFocusedStepRefId + "-box").get(0).focus();
		}
	};
	
	}());

	return RoadMap;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RoadMap.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RoadMapStep') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RoadMapStep.
jQuery.sap.declare('sap.ui.commons.RoadMapStep'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RoadMapStep",['jquery.sap.global', './library', 'sap/ui/core/Element'],
	function(jQuery, library, Element) {
	"use strict";


	
	/**
	 * Constructor for a new RoadMapStep.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Step used within a RoadMap Control.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RoadMapStep
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RoadMapStep = Element.extend("sap.ui.commons.RoadMapStep", /** @lends sap.ui.commons.RoadMapStep.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Label of the step
			 */
			label : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Specifies whether the user shall be allowed to click a step, or not
			 */
			enabled : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * This property is only relevant when using sub steps.
			 * @deprecated Since version 1.10.5. 
			 * Note that sub steps will not be supported in future. This feature might be removed in one of the next releases.
			 */
			expanded : {type : "boolean", group : "Misc", defaultValue : false, deprecated: true},
	
			/**
			 * Step is visible
			 */
			visible : {type : "boolean", group : "Misc", defaultValue : true}
		},
		defaultAggregation : "subSteps",
		aggregations : {
	
			/**
			 * Sub steps for the current step. Will be displayed only in the case that the step is expanded. Otherwise, special arrows show the availability
			 * of sub steps. One level of sub steps supported.
			 * @deprecated Since version 1.10.5. 
			 * Sub steps will not be supported in future. This feature might be removed in one of the next releases.
			 */
			subSteps : {type : "sap.ui.commons.RoadMapStep", multiple : true, singularName : "subStep", deprecated: true}
		}
	}});
	
	(function() {
	
	//Setter for property label which suppresses rerendering if possible -> Comment generated automatically
	RoadMapStep.prototype.setLabel = function(sLabel) {
		setProperty(this, "label", sLabel, function(){
			sap.ui.commons.RoadMapRenderer.setStepLabel(this, sLabel);
			this.setProperty("label", sLabel, true);
			sap.ui.commons.RoadMapRenderer.addEllipses(this);
			return true;
		});
		return this;
	};
	
	
	//Setter for property enabled which suppresses rerendering if possible -> Comment generated automatically
	RoadMapStep.prototype.setEnabled = function(bEnabled) {
		var bOldEnabled = this.getEnabled();
		if ((bEnabled && bOldEnabled) || (!bEnabled && !bOldEnabled)) {
			return this;
		}
		setProperty(this, "enabled", bEnabled, function(){
			var oRoadMap = getRoadMap(this);
			var bWasSelected = sap.ui.commons.RoadMapRenderer.setStepEnabled(oRoadMap, this, bEnabled);
			if (bWasSelected) {
				oRoadMap.setProperty("selectedStep", "", true);
			}
			if (!bEnabled) {
				this.setExpanded(false);
			}
			return false;
		});
		return this;
	};
	
	
	//Setter for property expanded which suppresses rerendering if possible -> Comment generated automatically
	RoadMapStep.prototype.setExpanded = function(bExpanded) {
		var bOldExpanded = this.getExpanded();
		if ((bExpanded && bOldExpanded) || (!bExpanded && !bOldExpanded)) {
			return this;
		}
		setProperty(this, "expanded", bExpanded, function(){
			if (isSubStep(this) || this.getSubSteps().length == 0 || !this.getEnabled() || !bExpanded) {
				this.setProperty("expanded", false, true);
				if (!isSubStep(this) && this.getSubSteps().length > 0 && this.getEnabled()) {
					sap.ui.commons.RoadMapRenderer.selectStep(getRoadMap(this), this, false, true, null, true);
				}
			} else {
				this.setProperty("expanded", true, true);
				sap.ui.commons.RoadMapRenderer.selectStep(getRoadMap(this), this, false, true, null, true);
			}
			return true;
		});
		return this;
	};
	
	
	//Setter for property visible which suppresses rerendering if possible -> Comment generated automatically
	RoadMapStep.prototype.setVisible = function(bVisible) {
		var bOldVisible = this.getVisible();
		if ((bVisible && bOldVisible) || (!bVisible && !bOldVisible)) {
			return this;
		}
		setProperty(this, "visible", bVisible, function(){
			var oRoadMap = getRoadMap(this);
			var bWasSelected = sap.ui.commons.RoadMapRenderer.setStepVisible(oRoadMap, this, isSubStep(this), bVisible);
			if (bWasSelected) {
				oRoadMap.setProperty("selectedStep", "", true);
			}
			this.setProperty("visible", bVisible, true);
			sap.ui.commons.RoadMapRenderer.updateStepArea(oRoadMap);
			sap.ui.commons.RoadMapRenderer.updateStepAria(this);
			return true;
		});
		return this;
	};
	
	
	/**
	 * Returns the dom reference that should get the focus
	 * @type DOMNode
	 * @return Returns the dom reference that should get the focus
	 */
	RoadMapStep.prototype.getFocusDomRef = function () {
		return jQuery.sap.byId(this.getFocusInfo().id).get(0) || null;
	};
	
	
	/**
	 * Returns an object representing the serialized focus information
	 * @type object
	 * @return an object representing the serialized focus information
	 * @private
	 */
	RoadMapStep.prototype.getFocusInfo = function () {
		return {id: this.getId() + "-box"};
	};
	
	
	/**
	 * Behavior implementation which is executed when the user clicks the step.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMapStep.prototype.onclick = function(oEvent){
		this.handleSelect(oEvent);
	};
	
	
	/**
	 * Behavior implementation which is executed when the user presses the space or enter key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMapStep.prototype.onsapselect = function(oEvent){
		this.handleSelect(oEvent);
	};
	
	
	/**
	 * Handler which is called when the step is selected.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	RoadMapStep.prototype.handleSelect = function(oEvent, bIgnoreDomCheck){
		oEvent.stopPropagation();
		oEvent.preventDefault();
	
		if (!bIgnoreDomCheck && !jQuery.sap.containsOrEquals(this.getDomRef(), oEvent.target)) {
			return;
		}
	
		if (this.getEnabled()) {
			var oRoadMap = getRoadMap(this);
			var that = this;
			sap.ui.commons.RoadMapRenderer.selectStep(oRoadMap, this, isSubStep(this), false, function(sType){
				var bWasAlreadySelected = oRoadMap.getSelectedStep() == that.getId();
				oRoadMap.setProperty("selectedStep", that.getId(), true);
				that.focus();
				if (sType != "selected") {
					that.setProperty("expanded", sType == "expanded", true);
					oRoadMap.fireStepExpanded({stepId: that.getId()});
				}
				if (!bWasAlreadySelected) {
					oRoadMap.fireStepSelected({stepId: that.getId()});
				}
			});
		} else {
			this.focus();
		}
	};
	
	
	//********* Private *********
	
	
	//Returns the corresponding Roadmap control
	var getRoadMap = function(oThis){
		var oRoadMap = oThis.getParent();
		if (isSubStep(oThis)) {
			oRoadMap = oRoadMap.getParent();
		}
		return oRoadMap;
	};
	
	
	//Returns true if the parent of this step is not of type sap.ui.commons.RoadMap
	var isSubStep = function(oThis){
		return !(oThis.getParent() instanceof sap.ui.commons.RoadMap);
	};
	
	
	//Helper function to set a property without rerendering (see overridden setter functions)
	var setProperty = function(oThis, sName, oValue, fDomAdaptationCallback){
		if (!oThis.getDomRef()) {
			oThis.setProperty(sName, oValue);
			return;
		}
		var bSkipUpdate = fDomAdaptationCallback.apply(oThis, []);
		if (!bSkipUpdate) {
			oThis.setProperty(sName, oValue, true);
		}
	};
	
	}());

	return RoadMapStep;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RoadMapStep.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RowRepeater') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RowRepeater.
jQuery.sap.declare('sap.ui.commons.RowRepeater'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RowRepeater",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new RowRepeater.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This control displays items in a stacked list format, allowing the user to page in order to see more items or to use the offered filtering and sorting capabilities in order to manipulate the displayed data.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RowRepeater
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RowRepeater = Control.extend("sap.ui.commons.RowRepeater", /** @lends sap.ui.commons.RowRepeater.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
			/**
			 * Number of rows displayed.
			 */
			numberOfRows : {type : "int", group : "Dimension", defaultValue : 5},
	
			/**
			 * The index of the page currently displayed. The index starts at 1.
			 */
			currentPage : {type : "int", group : "Data", defaultValue : 1},
	
			/**
			 * Step size used to increase the numberOfRows value. This feature is only active if value is greater than 0. This will deactivate the paging feature.
			 */
			showMoreSteps : {type : "int", group : "Behavior", defaultValue : 0},
	
			/**
			 * Row height adapts to rendered content. If a fixed height is specified the cells have a maximum height and the overflow will be hidden.
			 */
			fixedRowHeight : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : ''},
	
			/**
			 * The visual design of the control.
			 */
			design : {type : "sap.ui.commons.RowRepeaterDesign", group : "Appearance", defaultValue : sap.ui.commons.RowRepeaterDesign.Standard},
	
			/**
			 * Threshold to fetch the next chunk of data. The minimal threshold can be the numberOfRows of the RR.
			 */
			threshold : {type : "int", defaultValue : null}
		},
		defaultAggregation : "rows",
		aggregations : {
	
			/**
			 * Rows to be repeated.
			 */
			rows : {type : "sap.ui.core.Control", multiple : true, singularName : "row", bindable : "bindable"}, 
	
			/**
			 * Title to be displayed in top left corner. Either text or icon.
			 */
			title : {type : "sap.ui.core.Title", multiple : false}, 
	
			/**
			 * Filters to be provided in toolbar.
			 */
			filters : {type : "sap.ui.commons.RowRepeaterFilter", multiple : true, singularName : "filter"}, 
	
			/**
			 * Sorters to be provided in secondary toolbar.
			 */
			sorters : {type : "sap.ui.commons.RowRepeaterSorter", multiple : true, singularName : "sorter"}, 
	
			/**
			 * This control is shown, in case there is no data available to be displayed in the RowRepeater.
			 */
			noData : {type : "sap.ui.core.Control", multiple : false}, 
	
			/**
			 * A Toolbar which used internally by the RowRepeater
			 */
			filterToolbar : {type : "sap.ui.commons.Toolbar", multiple : false, visibility : "hidden"}, 
	
			/**
			 * A Toolbar which used internally by the RowRepeater
			 */
			sorterToolbar : {type : "sap.ui.commons.Toolbar", multiple : false, visibility : "hidden"}, 
	
			/**
			 * A Button which used internally by the RowRepeater
			 */
			headerShowMoreButton : {type : "sap.ui.commons.Button", multiple : false, visibility : "hidden"}, 
	
			/**
			 * A Button which used internally by the RowRepeater
			 */
			footerShowMoreButton : {type : "sap.ui.commons.Button", multiple : false, visibility : "hidden"}, 
	
			/**
			 * A Paginator which used internally by the RowRepeater
			 */
			footerPager : {type : "sap.ui.commons.Paginator", multiple : false, visibility : "hidden"}
		},
		events : {
	
			/**
			 * This event is triggered when a filter is set.
			 */
			filter : {
				parameters : {
	
					/**
					 * The ID of the filter that has just been applied.
					 */
					filterId : {type : "string"}
				}
			}, 
	
			/**
			 * This event is triggered when a sorting is applied.
			 */
			sort : {
				parameters : {
	
					/**
					 * The ID of the sorter that has just been applied.
					 */
					sorterId : {type : "string"}
				}
			}, 
	
			/**
			 * This event is triggered when paging was executed.
			 */
			page : {
				parameters : {
	
					/**
					 * The value of the currentPage property after the change.
					 */
					currentPage : {type : "int"}, 
	
					/**
					 * The value of the currentPage property before the change.
					 */
					previousPage : {type : "int"}
				}
			}, 
	
			/**
			 * This event is triggered when the number of rows was changed.
			 */
			resize : {
				parameters : {
	
					/**
					 * The value of the numberOfRows property after the change.
					 */
					numberOfRows : {type : "int"}, 
	
					/**
					 * The value of the numberOfRows property before the change.
					 */
					previousNumberOfRows : {type : "int"}
				}
			}
		}
	}});
	
	
	/**
	 * This value of the paging mode boolean is true if the showMoreSteps
	 * property is not set. This value is updated whenever the value
	 * of showMoreSteps is changed.
	 *
	 * @private
	 */
	RowRepeater.prototype.bPagingMode = true;
	
	/**
	 * All animations of the RowRepeater control can be centrally switched
	 * off by setting the <code>bShowAnimation</code> flag to <code>false</code>.
	 *
	 * @private
	 */
	RowRepeater.prototype.bShowAnimation = true;
	
	
	/* animation constants */
	RowRepeater.SHOW_MORE = "show_more";
	RowRepeater.RESIZE = "resize";
	RowRepeater.FIRST_PAGE = "first_page";
	RowRepeater.LAST_PAGE = "last_page";
	RowRepeater.PREVIOUS_PAGE = "previous_page";
	RowRepeater.NEXT_PAGE = "next_page";
	RowRepeater.GOTO_PAGE = "goto_page";
	
	RowRepeater.prototype.init = function() {
	
		// local variables
		var sId = this.getId();
	
		// get reference to resource bundle
		this.oResourceBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
	
		// initialize animation and queuing variables
		this.sCurrentAnimation = null;
		this.aAnimationQueue = [];
		this.aRemoveBuffer = [];
	
		// previous page and numberOfRows animation
		this.iPreviousPage = this.getCurrentPage();
		this.iPreviousNumberOfRows = this.getNumberOfRows();
	
		// create filter and sorter toolbar control and add as aggregation
		this.setAggregation( "filterToolbar", new sap.ui.commons.Toolbar(sId + "-ftb",{standalone:false,design:sap.ui.commons.ToolbarDesign.Transparent}));
		this.setAggregation( "sorterToolbar", new sap.ui.commons.Toolbar(sId + "-stb",{standalone:false}));
	
		// create pager controls and their event handlers, add them as aggregations
		var oPager = new sap.ui.commons.Paginator(sId + "-fp",{page:[this.paging,this]});
		this.setAggregation("footerPager",oPager);
	
		// create show more buttons and add them as aggregation
		var sShowMoreText = this.oResourceBundle.getText("SHOW_MORE");
		this.setAggregation( "headerShowMoreButton", new sap.ui.commons.Button(sId + "-hsm",{text:sShowMoreText,press:[this.triggerShowMore,this]}));
		this.setAggregation( "footerShowMoreButton", new sap.ui.commons.Button(sId + "-fsm",{text:sShowMoreText,press:[this.triggerShowMore,this]}));
	
		this._bSecondPage = false;
		
	};
	
	
	/*
	 * PUBLIC API METHODS
	 */
	/**
	 * The <code>triggerShowMore</code> function increments the number of rows by the
	 * value of <code>showMoreSteps</code>.
	 * 
	 * This method will only trigger a showMore if the property showMoreSteps is set.
	 *
	 * @return {sap.ui.commons.RowRepeater} <code>this</code> to allow method chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.triggerShowMore = function() {
	
		// execute only if showMoreSteps is bigger than 0
		if (this.getShowMoreSteps() <= 0) {
			return this;
		}
	
		// local variables
		var iShowMoreSteps = this.getShowMoreSteps();
		var iNumberOfRows = this.getNumberOfRows();
	
		// verify that the new value is not larger than number of rows available
		var iNewNumberOfRows = Math.min(this._getRowCount(),iNumberOfRows + iShowMoreSteps);
	
		// exit if value remains the same
		if (iNumberOfRows === iNewNumberOfRows) {
			return this;
		}
	
		// start animation or just set the property
		if (this.getDomRef() && this.bShowAnimation) {
	
			// check if animation is running before starting a new animation
			if ( this.sCurrentAnimation !== null ) {
				this.aAnimationQueue.push({	name:RowRepeater.SHOW_MORE,
					animationFunction:this.triggerShowMore,
					args:arguments});
				return this;
			} else {
				this.sCurrentAnimation = RowRepeater.SHOW_MORE;
			}
	
			// set property and animate
			this.iPreviousNumberOfRows = iNumberOfRows;
			this.setProperty("numberOfRows",iNewNumberOfRows,true);
			this.startResizeAnimation();
	
		} else {
	
			// set property and invalidate
			this.setNumberOfRows(iNewNumberOfRows);
	
		}
	
		// fire page event
		this.fireResize({numberOfRows:iNewNumberOfRows,previousNumberOfRows:iNumberOfRows});
	
		// return instance for chaining
		return this;
	
	};
	

	/**
	 * Resizes the row repeater by changing the number of displayed rows. This method will only resize the RowRepeater if the property showMoreSteps is set.
	 *
	 * @param {int} iNumberOfRows
	 *         The new value of number of rows displayed.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.resize = function(numberOfRows) {
	
		// execute only if showMoreSteps is bigger than 0
		if (this.getShowMoreSteps() <= 0) {
			return this;
		}
	
		// local variables
		var iNumberOfRows = this.getNumberOfRows();
		
		// exit if new value is not in range or equals to old value
		if (numberOfRows <= 0 || numberOfRows > this._getRowCount() || numberOfRows === iNumberOfRows ) {
			return this;
		}
		
		// start animation or just set the property
		if (this.getDomRef() && this.bShowAnimation) {
	
			// check if animation is running before starting a new animation
			if ( this.sCurrentAnimation !== null ) {
				this.aAnimationQueue.push({	name:RowRepeater.RESIZE,
					animationFunction:this.resize,
					args:arguments});
				return this;
			} else {
				this.sCurrentAnimation = RowRepeater.RESIZE;
			}
	
			// set property and animate
			this.iPreviousNumberOfRows = iNumberOfRows;
			this.setProperty("numberOfRows",numberOfRows,true);
			this.startResizeAnimation();
	
		} else {
	
			// set property and invalidate
			this.setNumberOfRows(numberOfRows);
	
		}
	
		// fire page event
		this.fireResize({numberOfRows:numberOfRows,previousNumberOfRows:iNumberOfRows});
	
		// return instance for chaining
		return this;
	
	};
	

	/**
	 * Applies a filter.
	 *
	 * @param {string} sId
	 *         The ID if the filter.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.applyFilter = function(id) {
	
		// local variables
		var aFilters = this.getFilters();
		var oListBinding = this.getBinding("rows");
		var oFilter, n;
	
		// exit directly if there are no filters or no binding defined
		if (aFilters.length === 0 || oListBinding === null) {
			return this;
		}
	
		// try to read the filter defined by the ID, unfortunately by looping
		for ( n = 0; n < aFilters.length; n++ ) {
			if (aFilters[n].getId() === id) {
				// we found the requested filter
				oFilter = aFilters[n];
				break;
			}
		}
	
		// don't do anything if we can't find the filter
		if (oFilter) {
	
			// apply the filter assigned to filter item
			oListBinding.filter(oFilter.getFilters(), sap.ui.model.FilterType.Control);
	
			// fire the filter
			this.fireFilter({filterId:id});
	
			// goto first page via public API method (i.e. animated)
			this.firstPage();
	
		}
	
		// return instance to allow chaining
		return this;
	
	};
	

	/**
	 * Sort the data.
	 *
	 * @param {string} sId
	 *         The ID of the sorter.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.triggerSort = function(id) {
	
		// local variables
		var aSorters = this.getSorters();
		var oListBinding = this.getBinding("rows");
		var oSorter, n;
	
		// exit directly if there are no sorters or no binding defined
		if (aSorters.length === 0 || oListBinding === null) {
			return this;
		}
	
		// try to read the sorter defined by the ID, unfortunately by looping
		for ( n = 0; n < aSorters.length; n++ ) {
			if (aSorters[n].getId() === id) {
				// we found the requested filter
				oSorter = aSorters[n];
				break;
			}
		}
	
		// don't do anything if we can't find the sorter
		if (oSorter) {
	
			// trigger the sorter assigned to sorter item
			oListBinding.sort(oSorter.getSorter());
	
			// fire sort event
			this.fireSort({sorterId:id});
	
			// goto first page via public API method (i.e. animated)
			this.firstPage();
	
		}
	
		// return instance to allow chaining
		return this;
	
	};
	

	/**
	 * Switch to first page.
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.firstPage = function() {
	
		// only execute if showMoreSteps is not bigger than 0
		if (this.getShowMoreSteps() > 0) {
			return this;
		}
	
		// local variable
		var iCurrentPage = this.getCurrentPage();
	
		// don't do anything if we are on the first page
		if (iCurrentPage === 1) {
			return this;
		}
	
		// keep pagers in sync
		this.getAggregation("footerPager").setCurrentPage(1);
	
		// start animation or just set the property
		if (this.getDomRef() && this.bShowAnimation) {
	
			// check if animation is running before starting a new animation
			if ( this.sCurrentAnimation !== null ) {
				this.aAnimationQueue.push({	name:RowRepeater.FIRST_PAGE,
					animationFunction:this.firstPage,
					args:arguments});
				return this;
			} else {
				this.sCurrentAnimation = RowRepeater.FIRST_PAGE;
			}
	
			// set property and animate
			this.iPreviousPage = iCurrentPage;
			this.setProperty("currentPage",1,true);
			this.startPagingAnimation();
	
		} else {
	
			// set property and invalidate
			this.setCurrentPage(1);
	
		}
	
		// fire page event
		this.firePage({currentPage:1,previousPage:iCurrentPage});
	
		// return instance for chaining
		return this;
	
	};
	

	/**
	 * Switch to last page.
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.lastPage = function() {
	
		// only execute if showMoreSteps is not bigger than 0
		if (this.getShowMoreSteps() > 0) {
			return this;
		}
	
		// local variable
		var iCurrentPage = this.getCurrentPage();
		var iLastPage = Math.ceil(this._getRowCount() / this.getNumberOfRows());
	
		// don't do anything if we are on the last page
		if (iCurrentPage === iLastPage) {
			return this;
		}
	
		// keep pagers in sync
		this.getAggregation("footerPager").setCurrentPage(iLastPage);
	
		// start animation or just set the property
		if (this.getDomRef() && this.bShowAnimation) {
	
			// check if animation is running before starting a new animation
			if ( this.sCurrentAnimation !== null ) {
				this.aAnimationQueue.push({	name:RowRepeater.LAST_PAGE,
					animationFunction:this.lastPage,
					args:arguments});
				return this;
			} else {
				this.sCurrentAnimation = RowRepeater.LAST_PAGE;
			}
	
			// set property and animate
			this.iPreviousPage = iCurrentPage;
			this.setProperty("currentPage",iLastPage,true);
			this.startPagingAnimation();
	
		} else {
	
			// set property and invalidate
			this.setCurrentPage(iLastPage);
	
		}
	
		// fire page event
		this.firePage({currentPage:iLastPage,previousPage:iCurrentPage});
	
		// return instance for chaining
		return this;
	
	};
	

	/**
	 * Switch to previous page.
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.previousPage = function() {
	
		// only execute if showMoreSteps is not bigger than 0
		if (this.getShowMoreSteps() > 0) {
			return this;
		}
	
		// local variable
		var iCurrentPage = this.getCurrentPage();
	
		// don't do anything if we are on the first page or even below
		if (iCurrentPage <= 1) {
			return this;
		}
	
		// keep pagers in sync
		this.getAggregation("footerPager").setCurrentPage(iCurrentPage - 1);
	
		// start animation or just set the property
		if (this.getDomRef() && this.bShowAnimation) {
	
			// check if animation is running before starting a new animation
			if ( this.sCurrentAnimation !== null ) {
				this.aAnimationQueue.push({	name:RowRepeater.PREVIOUS_PAGE,
					animationFunction:this.previousPage,
					args:arguments});
				return this;
			} else {
				this.sCurrentAnimation = RowRepeater.PREVIOUS_PAGE;
			}
	
			// set property and animate
			this.iPreviousPage = iCurrentPage;
			this.setProperty("currentPage",iCurrentPage - 1,true);
			this.startPagingAnimation();
	
		} else {
	
			// set property and invalidate
			this.setCurrentPage(iCurrentPage - 1);
	
		}
	
		// fire page event
		this.firePage({currentPage:iCurrentPage - 1,previousPage:iCurrentPage});
	
		// return instance for chaining
		return this;
	
	};
	

	/**
	 * Switch to next page.
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.nextPage = function() {
	
		// only execute if showMoreSteps is not bigger than 0
		if (this.getShowMoreSteps() > 0) {
			return this;
		}
	
		// local variable
		var iCurrentPage = this.getCurrentPage();
		var iLastPage = Math.ceil(this._getRowCount() / this.getNumberOfRows());
	
		// don't do anything if we are on the last page or even further
		if (iCurrentPage >= iLastPage) {
			return this;
		}
	
		// keep pagers in sync
		this.getAggregation("footerPager").setCurrentPage(iCurrentPage + 1);
	
		// start animation or just set the property
		if (this.getDomRef() && this.bShowAnimation) {
	
			// check if animation is running before starting a new animation
			if ( this.sCurrentAnimation !== null ) {
				this.aAnimationQueue.push({	name:RowRepeater.NEXT_PAGE,
					animationFunction:this.nextPage,
					args:arguments});
				return this;
			} else {
				this.sCurrentAnimation = RowRepeater.NEXT_PAGE;
			}
	
			// set property and animate
			this.iPreviousPage = iCurrentPage;
			this.setProperty("currentPage",iCurrentPage + 1,true);
			this.startPagingAnimation();
	
		} else {
	
			// set property and invalidate
			this.setCurrentPage(iCurrentPage + 1);
	
		}
	
		// fire page event
		this.firePage({currentPage:iCurrentPage + 1,previousPage:iCurrentPage});
	
		// return instance for chaining
		return this;
	
	};
	

	/**
	 * Switch to specified page.
	 *
	 * @param {int} iPageNumber
	 *         The index of the page to go to.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	RowRepeater.prototype.gotoPage = function(iPageNumber) {
	
		// only execute if showMoreSteps is not bigger than 0
		if (this.getShowMoreSteps() > 0) {
			return this;
		}
	
		// local variable
		var iCurrentPage = this.getCurrentPage();
		var iLastPage = Math.ceil(this._getRowCount() / this.getNumberOfRows());
	
		// don't do anything if page if not in range or same as before
		if (iPageNumber < 1 || iPageNumber > iLastPage || iCurrentPage === iPageNumber) {
			return this;
		}
	
		// keep pagers in sync
		this.getAggregation("footerPager").setCurrentPage(iPageNumber);
	
		// start animation or just set the property
		if (this.getDomRef() && this.bShowAnimation) {
	
			// check if animation is running before starting a new animation
			if ( this.sCurrentAnimation !== null ) {
				this.aAnimationQueue.push({	name:RowRepeater.GOTO_PAGE,
					animationFunction:this.gotoPage,
					args:arguments});
				return this;
			} else {
				this.sCurrentAnimation = RowRepeater.GOTO_PAGE;
			}
	
			// set property and animate
			this.iPreviousPage = iCurrentPage;
			this.setProperty("currentPage",iPageNumber,true);
			this.startPagingAnimation();
	
		} else {
	
			// set property and invalidate
			this.setCurrentPage(iPageNumber);
	
		}
	
		// fire page event
		this.firePage({currentPage:iPageNumber,previousPage:iCurrentPage});
	
		// return instance for chaining
		return this;
	
	};
	
	
	
	/*
	 * OVERRIDE OF SETTERS
	 */
	
	/**
	 * Setter for property <code>numberOfRows</code>.
	 *
	 * Default value is <code>5</code>
	 *
	 * @param {int} iNumberOfRows  new value for property <code>numberOfRows</code>
	 * @return {sap.ui.commons.RowRepeater} <code>this</code> to allow method chaining
	 * @public
	 */
	RowRepeater.prototype.setNumberOfRows = function(iNumberOfRows) {
	
		// change property without setting suppress rendering flag
		this.setProperty("numberOfRows", iNumberOfRows);
	
		// update the rows (maybe only when becoming visible?)
		if (this.getBinding("rows")) {
			this.updateRows(true);
		}
	
		// child controls might need a re-render after this change
		this.updateChildControls();
	
		// return instance to allow chaining
		return this;
	
	};
	
	/**
	 * Setter for property <code>currentPage</code>.
	 *
	 * @param {int} iCurrentPage  new value for property <code>currentPage</code>
	 * @return {sap.ui.commons.RowRepeater} <code>this</code> to allow method chaining
	 * @public
	 */
	RowRepeater.prototype.setCurrentPage = function(iCurrentPage) {
		
		if (this.getCurrentPage() != iCurrentPage) {
			// invalidate with this update
			this.setProperty("currentPage", iCurrentPage);
		
			// update the rows (maybe only when becoming visible?)
			if (this.getBinding("rows")) {
				this.updateRows(true);
			}
			
			// child controls might need a re-render after this change
			this.updateChildControls();
		}
	
		// return instance to allow chaining
		return this;
	
	};
	
	/**
	 * Override the default behavior of <code>setShowMoreSteps</code> to update the
	 * paging mode flag. Any change to the paging mode flag will result in the current
	 * page being set to the first page.
	 *
	 * @param {int} iShowMoreSteps  new value for property <code>showMoreSteps</code>
	 * @return {sap.ui.commons.RowRepeater} <code>this</code> to allow method chaining
	 * @public
	 */
	RowRepeater.prototype.setShowMoreSteps = function(iShowMoreSteps) {
	
		// calculate new paging mode by looking at step size
		var bNewPagingMode = iShowMoreSteps > 0 ? false : true,
				oBinding = this.getBinding("rows");
	
		// the state is to be reset if the mode changes
		if (bNewPagingMode !== this.bPagingMode) {
			this.bPagingMode = bNewPagingMode;
			this.setCurrentPage(1);
		}
	
		// set the property allowing a re-rendering of the row repeater
		this.setProperty("showMoreSteps", iShowMoreSteps);
		
		// in case of data binding we need to update the rows
		if (oBinding) {
			this._bSecondPage = false;
			this.updateRows(true);
		}
		
		return this;
	
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.insertRow = function(oRow, iIndex) {
		this.insertAggregation("rows", oRow, iIndex);
		this.updateChildControls();
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.addRow = function(oRow) {
		this.addAggregation("rows", oRow);
		this.updateChildControls();
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.removeRow = function(vElement) {
		this.removeAggregation("rows", vElement);
		this.updateChildControls();
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.removeAllRows = function() {
		this.removeAllAggregation("rows");
		this.updateChildControls();
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.destroyRows = function() {
		this.destroyAggregation("rows");
		this.updateChildControls();
		return this;
	};
	
	/* refer to generated documentation */
	RowRepeater.prototype.setThreshhold = function(iThreshold) {
		this.setProperty("threshold", iThreshold, true);
		return this;
	};
	
	/* refer to generated documentation */
	RowRepeater.prototype.insertFilter = function(oFilter, iIndex) {
	
		// insert a button into the filter toolbar's aggregation
		var oToolbar = this.getAggregation("filterToolbar");
		var sFilterId = oFilter.getId();
		var oButton = new sap.ui.commons.Button({text:oFilter.getText(),icon:oFilter.getIcon(),tooltip:oFilter.getTooltip(),press:[function(){this.applyFilter(sFilterId);},this]});
		oToolbar.insertItem(oButton,iIndex);
	
		this.insertAggregation("filters", oFilter, iIndex);
		return this;
	
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.addFilter = function(oFilter) {
	
		// add a button to the filter toolbar's aggregation
		var oToolbar = this.getAggregation("filterToolbar");
		var sFilterId = oFilter.getId();
		var oButton = new sap.ui.commons.Button({text:oFilter.getText(),icon:oFilter.getIcon(),tooltip:oFilter.getTooltip(),press:[function(){this.applyFilter(sFilterId);},this]});
		oToolbar.addItem(oButton);
	
		this.addAggregation("filters", oFilter);
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.removeFilter = function(vElement) {
	
		// remove button from toolbar
		var oToolbar = this.getAggregation("filterToolbar");
		oToolbar.removeItem(vElement);
	
		return this.removeAggregation("filters", vElement);
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.removeAllFilters = function() {
	
		// remove all buttons from toolbar
		var oToolbar = this.getAggregation("filterToolbar");
		oToolbar.removeAllItems();
	
		return this.removeAllAggregation("filters");
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.destroyFilters = function() {
	
		// remove all buttons from toolbar
		var oToolbar = this.getAggregation("filterToolbar");
		oToolbar.removeAllItems();
	
		this.destroyAggregation("filters");
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.insertSorter = function(oSorter, iIndex) {
	
		// add a button to the sorter toolbar's aggregation
		var oToolbar = this.getAggregation("sorterToolbar");
		var sSorterId = oSorter.getId();
		var oButton = new sap.ui.commons.Button({text:oSorter.getText(),icon:oSorter.getIcon(),tooltip:oSorter.getTooltip(),press:[function(){this.triggerSort(sSorterId);},this]});
		oToolbar.insertItem(oButton,iIndex);
	
		this.insertAggregation("sorters", oSorter, iIndex);
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.addSorter = function(oSorter) {
	
		// add a button to the sorter toolbar's aggregation
		var oToolbar = this.getAggregation("sorterToolbar");
		var sSorterId = oSorter.getId();
		var oButton = new sap.ui.commons.Button({text:oSorter.getText(),icon:oSorter.getIcon(),tooltip:oSorter.getTooltip(),press:[function(){this.triggerSort(sSorterId);},this]});
		oToolbar.addItem(oButton);
	
		this.addAggregation("sorters", oSorter);
		return this;
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.removeSorter = function(vElement) {
	
		// remove button from toolbar
		var oToolbar = this.getAggregation("sorterToolbar");
		oToolbar.removeItem(vElement);
	
		return this.removeAggregation("sorters", vElement);
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.removeAllSorters = function() {
	
		// remove all buttons from toolbar
		var oToolbar = this.getAggregation("sorterToolbar");
		oToolbar.removeAllItems();
	
		return this.removeAllAggregation("sorters");
	};
	
	
	/* refer to generated documentation */
	RowRepeater.prototype.destroySorters = function() {
	
		// remove all buttons from toolbar
		var oToolbar = this.getAggregation("sorterToolbar");
		oToolbar.removeAllItems();
	
		this.destroyAggregation("sorters");
		return this;
	};
	
	
	/*
	 * ANIMATION METHODS
	 */
	
	RowRepeater.prototype.startPagingAnimation = function() {
	
		// local variables
		var oCore = sap.ui.getCore(),
		    oRenderManager = oCore.getRenderManager(),
		    sId = this.getId(),
		    iPageFrom = this.iPreviousPage,
		    iPageTo = this.getCurrentPage(),
		    iNumberOfRows = this.getNumberOfRows(),
		    iStartIndex = (iPageTo - 1) * iNumberOfRows,
		    aRows = this.getRows(),
		    iCurrentVisibleRows = this._getRowCount() > iNumberOfRows * iPageTo ? iNumberOfRows : this._getRowCount() - iNumberOfRows * (iPageTo - 1),
		    n,
		    oBinding = this.getBinding("rows");
	
		// DOM elements
		var oDomCurrentLI,
		    oJQDomULFrom = this.$("page_" + iPageFrom),
		    oDomBodyDIV = this.getDomRef("body"),
		    oJQDomBodyDIV = jQuery(oDomBodyDIV);
	
		// fix the height on the body DIV to allow an animated height change
		oJQDomBodyDIV.css("height",oJQDomBodyDIV.outerHeight());
	
		// create UL for new page
		var sDirection;
		if (sap.ui.getCore() && sap.ui.getCore().getConfiguration() && sap.ui.getCore().getConfiguration().getRTL()) {
			sDirection = (iPageTo < iPageFrom) ? "left" : "right";
		} else {
			sDirection = (iPageTo < iPageFrom) ? "right" : "left";
		}
	
		// load the required contexts
		if (oBinding) {
			// update the rows aggregation
			this._bSecondPage = !this._bSecondPage;
			this.updateRows(true);
			aRows = this.getRows();
			iStartIndex = (this._bSecondPage ? 1 : 0) * iNumberOfRows;
		}
	
		// create the rows where we navigate to in the DOM
		var sStyleString = "\"top:-" + oJQDomULFrom.outerHeight(true) + "px;" + sDirection + ":" + oJQDomULFrom.outerWidth(true) + "px;\"";
		jQuery("<ul id=\"" + sId + "-page_" + iPageTo + "\" class=\"sapUiRrPage\" style=" + sStyleString + "/>").appendTo(oDomBodyDIV);
		var oDomULTo = oDomBodyDIV.lastChild;
		var oJQDomULTo = jQuery(oDomULTo);
		for ( n = iStartIndex; n < iStartIndex + iCurrentVisibleRows; n++ ) {
			jQuery("<li id=\"" + sId + "-row_" + n + "\" class=\"sapUiRrRow\"/>").appendTo(oDomULTo);
			oDomCurrentLI =  oDomULTo.lastChild;
			oRenderManager.render(aRows[n], oDomCurrentLI);
		}
	
		// animate the paging effect
		if (sDirection === "right") {
			oJQDomULFrom.animate({right: -oJQDomULFrom.outerWidth(true)},"slow");
			oJQDomULTo.animate({right:0},"slow");
		} else {
			oJQDomULFrom.animate({left: -oJQDomULFrom.outerWidth(true)},"slow");
			oJQDomULTo.animate({left:0},"slow");
		}
	
		// animate the height change if number of displayed rows changes
		oJQDomBodyDIV.animate({height:oJQDomULTo.outerHeight(true)},"slow",jQuery.proxy(this.endPagingAnimation,this));
	
	};
	
	
	RowRepeater.prototype.endPagingAnimation = function() {
	
		// local variables
		// get all needed DOM objects
		var oDomDIV = this.getDomRef("body");
		var oDomOldUL = this.getDomRef("page_" + this.iPreviousPage);
		var oDomCurrentUL = this.getDomRef("page_" + this.getCurrentPage());
		var oJQDomCurrentUL = jQuery(oDomCurrentUL);
	
		// un-fix the height on DIV
		jQuery(oDomDIV).css("height","");
	
		// remove the old UL from DOM
		jQuery(oDomOldUL).remove();
	
		// remove positioning from new UL
		var sDirection;
		if (sap.ui.getCore() && sap.ui.getCore().getConfiguration() && sap.ui.getCore().getConfiguration().getRTL()) {
			sDirection = (this.getCurrentPage() < this.iPreviousPage) ? "left" : "right";
		} else {
			sDirection = (this.getCurrentPage() < this.iPreviousPage) ? "right" : "left";
		}
		oJQDomCurrentUL.css("top","");
		oJQDomCurrentUL.css(sDirection,"");
	
		// reset animation indicator
		this.sCurrentAnimation = null;
	
		// start new animation
		this.nextQueuedAnimation();
	
	};
	
	
	RowRepeater.prototype.startResizeAnimation = function() {
	
		// variables
		var oRenderManager = sap.ui.getCore().getRenderManager(),
		    iNewNumberOfRows = this.getNumberOfRows(),
		    iOldNumberOfRows = this.iPreviousNumberOfRows,
		    sId = this.getId(),
		    iSizeDelta = 0,
		    aRows,
		    oBinding = this.getBinding("rows");
	
		// dom elements
		var oDomCurrentLI,
		    oDomBodyDIV = this.getDomRef("body"),
		    oJQDomBodyDIV = jQuery(oDomBodyDIV),
		    oDomPageUL = this.getDomRef("page_" + this.getCurrentPage());
	
		// fix the height
		oJQDomBodyDIV.css("height",oJQDomBodyDIV.outerHeight());
	
		// update the rows aggregation
		if (oBinding) {
			this.updateRows(true);
		}
		aRows = this.getRows();
		
		// check if control is growing or shrinking
		if (iNewNumberOfRows > iOldNumberOfRows) {
	
			// create all newly visible child elements, if size grows
			for (var n = iOldNumberOfRows; n < iNewNumberOfRows; n++) {
				jQuery("<li id=\"" + sId + "-row_" + n + "\" class=\"sapUiRrRow\"/>").appendTo(oDomPageUL);
				oDomCurrentLI = oDomPageUL.lastChild;
				oRenderManager.render(aRows[n], oDomCurrentLI);
			}
	
		} else {
	
			// measure controls to be removed and store them in array for later removal
			for (var n = iNewNumberOfRows; n < iOldNumberOfRows; n++) {
				oDomCurrentLI = this.getDomRef("row_" + n);
				iSizeDelta -= jQuery(oDomCurrentLI).outerHeight(true);
				this.aRemoveBuffer.push(oDomCurrentLI);
			}
	
		}
	
		// animate resize of container
		oJQDomBodyDIV.animate({height:jQuery(oDomPageUL).outerHeight(true) + iSizeDelta},"slow",jQuery.proxy(this.endResizeAnimation,this));
	
	};
	
	
	RowRepeater.prototype.endResizeAnimation = function() {
	
		// get body DIV
		var oDomBodyDIV = this.getDomRef("body");
	
		// remove LI element after shrinking
		while ( this.aRemoveBuffer.length > 0 ) {
			jQuery(this.aRemoveBuffer.pop()).remove();
		}
	
		// un-fix the height on DIV
		jQuery(oDomBodyDIV).css("height","");
	
		// reset animation indicator
		this.sCurrentAnimation = null;
	
		// start new animation
		this.nextQueuedAnimation();
	
	};
	
	
	RowRepeater.prototype.nextQueuedAnimation = function() {
	
		// local variables
		var oNextAnimation, oLastQueuedAnimation;
		var iCounter = 1;
		var aQueue = this.aAnimationQueue;
		var iPageNumber, iNumberOfRows;
	
		// get first one
		if (aQueue.length > 0) {
			oNextAnimation = aQueue.shift();
		}
	
		// if there are more in the queue of same name we try to summarize
		if (oNextAnimation && aQueue.length > 0) {
	
			// remove all upcoming animations with same name
			while (aQueue[0] && aQueue[0].name === oNextAnimation.name) {
				iCounter++;
				oLastQueuedAnimation = aQueue.shift();
			}
	
			// reaction depends of animation name
			if (iCounter > 0) {
				switch (oNextAnimation.name) {
				case RowRepeater.SHOW_MORE:
					// replace with resize of summarized size
					iNumberOfRows = Math.min(this._getRowCount(),this.getNumberOfRows() + this.getShowMoreSteps() * iCounter);
					oNextAnimation = {	name:RowRepeater.RESIZE,
							animationFunction:this.resize,
							args:[iNumberOfRows]};
					break;
				case RowRepeater.RESIZE:
					// execute the last one and skip the ones before
					oNextAnimation = oLastQueuedAnimation;
					break;
				case RowRepeater.FIRST_PAGE:
					// the animations are duplicates and can be droppped
					break;
				case RowRepeater.LAST_PAGE:
					// the animations are duplicates and can be droppped
					break;
				case RowRepeater.PREVIOUS_PAGE:
					// replace with goto page
					iPageNumber = Math.max(1,this.getCurrentPage() - iCounter);
					oNextAnimation = {	name:RowRepeater.GOTO_PAGE,
							animationFunction:this.gotoPage,
							args:[iPageNumber]};
					break;
				case RowRepeater.NEXT_PAGE:
					// replace with goto page
					iPageNumber = Math.min(Math.ceil(this._getRowCount() / this.getNumberOfRows()),this.getCurrentPage() + iCounter);
					oNextAnimation = {	name:RowRepeater.GOTO_PAGE,
							animationFunction:this.gotoPage,
							args:[iPageNumber]};
					break;
				case RowRepeater.GOTO_PAGE:
					// execute the last one and skip the ones before
					oNextAnimation = oLastQueuedAnimation;
					break;
				}
			}
	
		}
	
		// finally execute
		if (oNextAnimation) {
			oNextAnimation.animationFunction.apply(this,oNextAnimation.args);
		}
	
	};
	
	
	/*
	 * INTERNAL METHODS
	 */
	
	/**
	 * Handle paging events from the Paginator(s)
	 *
	 * @private
	 */
	 RowRepeater.prototype.paging = function(oEvent) {
	
		 switch (oEvent.getParameter("type")) {
			 case sap.ui.commons.PaginatorEvent.First:
				 this.firstPage();
				 break;
			 case sap.ui.commons.PaginatorEvent.Last:
				 this.lastPage();
				 break;
			 case sap.ui.commons.PaginatorEvent.Previous:
				 this.previousPage();
				 break;
			 case sap.ui.commons.PaginatorEvent.Next:
				 this.nextPage();
				 break;
			 case sap.ui.commons.PaginatorEvent.Goto:
				 this.gotoPage(oEvent.getParameter("targetPage"));
				 break;
		 }
	
	 }
	
	/**
	 * Update the state of aggregated child controls inside this row repeater.
	 *
	 * @private
	 */;
	RowRepeater.prototype.updateChildControls = function() {
	
		// local referenced to controls
		var oShowMoreButton, oPager;
	
		// local variables
		var bShowMoreEnabled;
	
		// only care about pagers if we are in paging mode, otherwise it is the showMore buttons
		if (this.bPagingMode) {
	
			// the pager is itself responsible for activation, just update the page info
			var iCurrentPage = this.getCurrentPage();
			var iLastPage = Math.ceil( this._getRowCount() / this.getNumberOfRows() );
			if (this._getRowCount() == 0) {
				iLastPage = 1;
			}
			
			// update header pager
			oPager = this.getAggregation("footerPager");
			if (oPager) {
				oPager.setCurrentPage( iCurrentPage );
				oPager.setNumberOfPages( iLastPage );
			}
	
		} else {
	
			// show more buttons are only active if there are more lines to show
			bShowMoreEnabled = this._getRowCount() > this.getNumberOfRows();
	
			// update header showMore button
			oShowMoreButton = this.getAggregation("headerShowMoreButton");
			if (oShowMoreButton) {
				oShowMoreButton.setEnabled(bShowMoreEnabled);
			}
	
			// update footer showMore button
			oShowMoreButton = this.getAggregation("footerShowMoreButton");
			if (oShowMoreButton) {
				oShowMoreButton.setEnabled(bShowMoreEnabled);
			}
	
		}
	
	};
	
	
	/**
	 * Verify if the rows aggregation of this control is bound.
	 */
	RowRepeater.prototype.isBound = function(sName) {
		return sap.ui.core.Element.prototype.isBound.call(this, sName || "rows");
	};
	
	/**
	 * Returns the row count. If aggregation rows is bound the count will be the length of the binding,
	 * otherwise the count of the rows aggregation will be returned 
	 * @private
	 */
	RowRepeater.prototype._getRowCount = function() {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.getLength();
		} else {
			return this.getRows().length;
		}
	};
	
	/**
	 * Override unbindAggregation to clean up the "rows" aggregation 
	 * @private
	 */
	RowRepeater.prototype.unbindAggregation = function(sName) {
		sap.ui.core.Element.prototype.unbindAggregation.apply(this, arguments);
		if (sName === "rows") {
			this.destroyRows();
		}
		return this;
	};

	/**
	* Override refreshRows to enable paging
	* @private
	*/
	RowRepeater.prototype.refreshRows = function() {

		// collect the relevant informations
		var oBindingInfo = this.getBindingInfo("rows"),
			oBinding = oBindingInfo.binding,
			iRowCount = this._getRowCount(),
			iNumberOfRows = this.getNumberOfRows(),
			iNewRowCount = Math.min(iRowCount, iNumberOfRows),
			iThreshold = this.getThreshold();

		// Reset current page
		this.setProperty("currentPage", 1, true);

		// call getContext to trigger data load
		oBinding.getContexts(0, iNewRowCount, iThreshold);

	};

	/**
	 * Override updateRows to enable paging 
	 * @private
	 */
	RowRepeater.prototype.updateRows = function(bViaAPI) {
		
		// collect the relevant informations
		var oBindingInfo = this.getBindingInfo("rows"),
		    fnFactory = oBindingInfo.factory,
		    oBinding = oBindingInfo.binding,
		    iShowMoreSteps = this.getShowMoreSteps(),
		    bShowMore = iShowMoreSteps > 0,
		    iCurrentPage = this.getCurrentPage(),
		    iRowCount = this._getRowCount(),
		    iNumberOfRows = this.getNumberOfRows(),
		    iNewRowCount = Math.min(iRowCount, iNumberOfRows),
		    iLastPage = Math.ceil(iRowCount / iNumberOfRows) || 1;
		    
		// boundary check for the current page to avoid invalid pages
		if (iCurrentPage > iLastPage) {
			iCurrentPage = iLastPage;
			this.setProperty("currentPage", iCurrentPage);
			this._bSecondPage = false;
		}
	
		// collect the binding relevant information
		var iFirstRow = bShowMore ? 0 : (iCurrentPage - 1) * iNewRowCount,
		    iRowsOffset = (this._bSecondPage ? 1 : 0) * iNewRowCount,
		    iThreshold = this.getThreshold(), // || (bShowMore ? Math.min(iRowCount, iNewRowCount + iShowMoreSteps) : iNewRowCount * 2),
		    aContexts = oBinding ? oBinding.getContexts(iFirstRow, iNewRowCount, iThreshold) : [];
		
		if (bViaAPI !== true) {
	
			// if not called internally via API we create the rows aggregation
			// because then this function is called after the connection between the 
			// control and the model has been established!
			this._bSecondPage = false;
			this.destroyRows();
			for (var i = 0, l = iNewRowCount; i < l; i++) {
				var sId = this.getId() + "-" + i,
				    oClone = fnFactory(sId, aContexts[i]);
				oClone.setBindingContext(aContexts[i], oBindingInfo.model);
				this.addRow(oClone);
			}
			
			// TODO: in future we might think about a performance improvement to render
			// only those lines where the factory returns another template and the rest
			// is simply adopted by applying a new context. For now in case of the 
			// model loads additional data we simply rerender the complete row-repeater
			// or when the binding is changed!
			
		} else {
		
			// if called via API we need to only create the additional rows (paging) 
			// and bind them properly by updating their binding contexts
			this._bSuppressInvalidate = true;
		
			for (var i = 0, l = iNewRowCount; i < l; i++) {
				var iIndex = iRowsOffset + i;
				var oRow = this.getRows()[iIndex];
				// when paging we remove the row again because we need to recreate it via 
				// the factory function to make sure to react on data specific rendering
				if (!bShowMore) {
					if (oRow) {
						this.removeAggregation("rows", oRow, true);
						oRow.destroy();
					}
					oRow = undefined;
				}
				// if the row doesn't exist yet, we recreate the row and insert it into
				// the rows aggregation and afterwards we bind the context
				if (!oRow) {
					var sId = this.getId() + "-" + iIndex;
					oRow = fnFactory(sId, aContexts[i]);
					oRow.setBindingContext(aContexts[i], oBindingInfo.model);
					this.insertAggregation("rows", oRow, iIndex, true);
				} else {
					oRow.setBindingContext(aContexts[i], oBindingInfo.model);
				}
			}
			
			this._bSuppressInvalidate = false;
			
		}
		
		// update the child controls
		this.updateChildControls();
		
	};
	
	RowRepeater.prototype.invalidate = function(oOrigin) {
		// if we do not suppress the invalidation, the first time another page
		// is displayed the complete row repeater gets invalidated and rerendered
		// because a property of a not renderered control is changed via setting the
		// databinding context.
		if (this._bSuppressInvalidate) {
			return; // suppress the invalidation of the rows (when exchanging the binding contexts)
		}
		Control.prototype.invalidate.apply(this, arguments);
	};
	

	return RowRepeater;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RowRepeater.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RowRepeaterFilter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RowRepeaterFilter.
jQuery.sap.declare('sap.ui.commons.RowRepeaterFilter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RowRepeaterFilter",['jquery.sap.global', './library', 'sap/ui/core/Element'],
	function(jQuery, library, Element) {
	"use strict";


	
	/**
	 * Constructor for a new RowRepeaterFilter.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This element is used by the RowRepeater and allows to define a filter in this context along with the related data such as a text and an icon.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RowRepeaterFilter
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RowRepeaterFilter = Element.extend("sap.ui.commons.RowRepeaterFilter", /** @lends sap.ui.commons.RowRepeaterFilter.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * The filter title if needed for display.
			 */
			text : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * The filter icon if needed for display.
			 */
			icon : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * The set of filter objects.
			 */
			filters : {type : "object", group : "Data", defaultValue : null}
		}
	}});
	
	///**
	// * This file defines behavior for the control,
	// */
	//sap.ui.commons.RowRepeaterFilter.prototype.init = function(){
	//   // do something for initialization...
	//};

	return RowRepeaterFilter;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RowRepeaterFilter.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.RowRepeaterSorter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.RowRepeaterSorter.
jQuery.sap.declare('sap.ui.commons.RowRepeaterSorter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/RowRepeaterSorter",['jquery.sap.global', './library', 'sap/ui/core/Element'],
	function(jQuery, library, Element) {
	"use strict";


	
	/**
	 * Constructor for a new RowRepeaterSorter.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This element is used by the RowRepeater and allows to define a sorter in this context along with the related data such as a text and an icon.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.RowRepeaterSorter
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var RowRepeaterSorter = Element.extend("sap.ui.commons.RowRepeaterSorter", /** @lends sap.ui.commons.RowRepeaterSorter.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * The sorter title if needed for display.
			 */
			text : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * The sorter icon if needed for display.
			 */
			icon : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * The sorter object.
			 */
			sorter : {type : "object", group : "Data", defaultValue : null}
		}
	}});
	
	///**
	// * This file defines behavior for the control,
	// */
	//sap.ui.commons.RowRepeaterSorter.prototype.init = function(){
	//   // do something for initialization...
	//};

	return RowRepeaterSorter;

}, /* bExport= */ true);

}; // end of sap/ui/commons/RowRepeaterSorter.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SearchProvider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.SearchProvider.
jQuery.sap.declare('sap.ui.commons.SearchProvider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.search.OpenSearchProvider'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/SearchProvider",['jquery.sap.global', './library', 'sap/ui/core/search/OpenSearchProvider'],
	function(jQuery, library, OpenSearchProvider) {
	"use strict";


	
	/**
	 * Constructor for a new SearchProvider.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A SearchProvider which can be attached to a Search Field.
	 * @extends sap.ui.core.search.OpenSearchProvider
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.6.0. 
	 * Replaced by sap.ui.core.search.OpenSearchProvider
	 * @alias sap.ui.commons.SearchProvider
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var SearchProvider = OpenSearchProvider.extend("sap.ui.commons.SearchProvider", /** @lends sap.ui.commons.SearchProvider.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons"
	}});
	
	/**
	 * Called by the search field, when suggestions are requested.
	 *
	 * @private
	 */
	SearchProvider.prototype._doSuggest = function(oSearchField, sSuggestValue) {
		this.suggest(sSuggestValue, function(sValue, aSuggestions){
			if (oSearchField && oSearchField.suggest) {
				oSearchField.suggest(sValue, aSuggestions);
			}
		});
	};
	
	

	return SearchProvider;

}, /* bExport= */ true);

}; // end of sap/ui/commons/SearchProvider.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.SegmentedButton') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.SegmentedButton.
jQuery.sap.declare('sap.ui.commons.SegmentedButton'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/SegmentedButton",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation'],
	function(jQuery, library, Control, ItemNavigation) {
	"use strict";


	
	/**
	 * Constructor for a new SegmentedButton.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The SegmentedButton provides a group of multiple buttons. Only one button can be active. The behaviour is more ore less like a radio button group.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.commons.ToolbarItem
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.SegmentedButton
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var SegmentedButton = Control.extend("sap.ui.commons.SegmentedButton", /** @lends sap.ui.commons.SegmentedButton.prototype */ { metadata : {
	
		interfaces : [
			"sap.ui.commons.ToolbarItem"
		],
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * enabled
			 */
			enabled : {type : "boolean", group : "Misc", defaultValue : true}
		},
		aggregations : {
	
			/**
			 * Buttons
			 */
			buttons : {type : "sap.ui.commons.Button", multiple : true, singularName : "button"}
		},
		associations : {
	
			/**
			 * Selected Button
			 */
			selectedButton : {type : "sap.ui.commons.Button", multiple : false}
		},
		events : {
	
			/**
			 * Event fired when button selected
			 */
			select : {
				parameters : {
	
					/**
					 * Id of selected ToggleButton
					 */
					selectedButtonId : {type : "string"}
				}
			}
		}
	}});
	
	/* This file defines behavior for the SegmentedButton control */
	
	
	/**
	 * Initialization hook for the SegmentedButton.
	 * 
	 * @private
	 */
	SegmentedButton.prototype.init = function() {
		if (!this._oItemNavigation) {
			this._oItemNavigation = new ItemNavigation();
			this._oItemNavigation.setCycling(true);
			this.addDelegate(this._oItemNavigation);
		}
		this._oButtonDelegate = {oSegmentedButton: this, onAfterRendering: this._buttonOnAfterRendering};
	};
	
	SegmentedButton.prototype.exit = function() {
	
		if (this._oItemNavigation) {
			this.removeDelegate(this._oItemNavigation);
			this._oItemNavigation.destroy();
			delete this._oItemNavigation;
		}
	
	};
	
	/**
	 * AfterRendering hook for the SegmentedButton. Create ItemNavigation here. 
	 *
	 * @private
	 */
	SegmentedButton.prototype.onAfterRendering = function() {
		this._setItemNavigation(true);
	
	};
	/**
	 * @private
	 */
	SegmentedButton.prototype._buttonSelected = function(oEvent) {
		var oOldButtonSelection = sap.ui.getCore().byId(this.getSelectedButton()),
			oNewButtonSelection = oEvent.getSource();
	
		if (oNewButtonSelection !== oOldButtonSelection) {
			this.setSelectedButton(oNewButtonSelection);
			this.fireSelect({selectedButtonId:oNewButtonSelection.getId()});
		}
	};
	/**
	 * @private
	 */
	SegmentedButton.prototype._setItemNavigation = function(bAddDelegate) {
		var oButton,
			aButtons,
			aItemDomRefs = [];
		if (!this.getEnabled()) {
			return;
		}
		if (this.getDomRef()) {
			this._oItemNavigation.setRootDomRef(this.getDomRef("radiogroup"));
			aButtons = this.getButtons();
			for ( var i = 0; i < aButtons.length; i++) {
				oButton = aButtons[i];
				aItemDomRefs.push(oButton.getDomRef());
				this._setAriaInfo(oButton, i + 1);
				if (bAddDelegate) {
					// remove delgate if it already exists
					oButton.removeDelegate(this._oButtonDelegate);
					oButton.addDelegate(this._oButtonDelegate);
				}
			}
			this._oItemNavigation.setItemDomRefs(aItemDomRefs);
		}
	};
	/**
	 * @private
	 */
	SegmentedButton.prototype._setAriaInfo = function(oButton, i) {
		var $button = jQuery(oButton.getDomRef()),
			length = this.getButtons().length;
	
		$button.attr("aria-posinset",i);
		$button.attr("aria-setsize",length);
		$button.attr("role", "radio");
		if (oButton.getId() === this.getSelectedButton()) {
			$button.attr("aria-checked", "true");
			$button.removeAttr("aria-describedby");
		} else {
			$button.removeAttr("aria-checked");
			$button.attr("aria-describedby",this.getId() + "-label");
		}
	};
	
	/**
	 * OnAfterRendering of Button
	 *
	 * @private
	*/
	SegmentedButton.prototype._buttonOnAfterRendering = function() {
	
		this.oSegmentedButton._setItemNavigation();
	
	};
	
	/**
	 * Rerendering of the Buttons
	 *
	 * @protected
	*/
	SegmentedButton.prototype._rerenderButtons = function() {
		var $content = this.$();
		if ($content.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			sap.ui.commons.SegmentedButtonRenderer.renderButtons(rm, this);
			rm.flush($content[0]);
			rm.destroy();
		}
	};
	
	/* Override API methods */
	SegmentedButton.prototype.addButton = function(oButton) {
		this.addAggregation("buttons",oButton, true);
		oButton.attachPress(this._buttonSelected, this);
		this._rerenderButtons();
		return this;
	};
	SegmentedButton.prototype.insertButton = function(oButton, iIndex) {
		this.insertAggregation("buttons",oButton, iIndex, true);
		oButton.attachPress(this._buttonSelected, this);
		this._rerenderButtons();
		return this;
	};
	SegmentedButton.prototype.removeButton = function(oButton) {
		var result = this.removeAggregation("buttons",oButton, true);
		if (result) {
			result.detachPress(this._buttonSelected, this);
			result.removeDelegate(this._oButtonDelegate);
			this._rerenderButtons();
		}
		return result;
	};
	SegmentedButton.prototype.removeAllButtons = function() {
		var result = this.removeAllAggregation("buttons", true);
		jQuery.each(result, function(i, oButton) {
			oButton.detachPress(this._buttonSelected, this);
			oButton.removeDelegate(this._oButtonDelegate);
		});
		this._rerenderButtons();
		return result;
	};
	SegmentedButton.prototype.setSelectedButton = function(vButton) {
		var oButton, oButtonOld = sap.ui.getCore().byId(this.getSelectedButton());
		this.setAssociation("selectedButton", vButton, true);
		oButton = sap.ui.getCore().byId(this.getSelectedButton());
		
		// Make sure Aria info is correct after changing button state
		this._setItemNavigation();
		
		var aButtons = this.getButtons();
		for (var i = 0; i < aButtons.length; i++) {
			if (aButtons[i] === oButton) {
				this._oItemNavigation.setFocusedIndex(i);
				break;
			}
		}
		if (oButtonOld) {
			oButtonOld.removeStyleClass("sapUiSegButtonSelected");
			oButtonOld.$().blur();
		}
		if (oButtonOld && oButtonOld._icon) {
			oButtonOld.setIcon(oButtonOld._icon);
			oButtonOld._icon = null;
		}
		if (oButton) {
			if (oButton.getIconHovered()) {
				oButton._icon = oButton.getIcon();
				oButton.setIcon(oButton.getIconHovered());
			}
			oButton.addStyleClass("sapUiSegButtonSelected");
		}
	};
	
	SegmentedButton.prototype.setEnabled = function(bEnabled) {
		jQuery.each(this.getButtons(),function(i,oButton) {
			oButton.setEnabled(bEnabled);
		});
		// remove itemNavigation if buttons are disabled
		if (this._oItemNavigation && !bEnabled) {
			this.removeDelegate(this._oItemNavigation);
		} else {
			this.addDelegate(this._oItemNavigation);
		}
		this.setProperty("enabled",bEnabled);
	};
	
	/*
	 * before cloning buttons deregister events and register it after cloning again.
	 */
	SegmentedButton.prototype.clone = function(sIdSuffix, aLocalIds) {
	
		var aButtons = this.getButtons();
		for ( var i = 0; i < aButtons.length; i++) {
			var oButton = aButtons[i];
			oButton.detachPress(this._buttonSelected, this);
		}
	
		var oClone = sap.ui.core.Element.prototype.clone.apply(this, arguments);
	
		for ( var i = 0; i < aButtons.length; i++) {
			var oButton = aButtons[i];
			oButton.attachPress(this._buttonSelected, this);
		}
	
		return oClone;
	};
	
	SegmentedButton.prototype.getFocusDomRef = function() {
	
		return this.getDomRef("radiogroup") || null;
	
	};

	return SegmentedButton;

}, /* bExport= */ true);

}; // end of sap/ui/commons/SegmentedButton.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Slider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Slider.
jQuery.sap.declare('sap.ui.commons.Slider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Slider",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/EnabledPropagator', 'sap/ui/core/ResizeHandler'],
	function(jQuery, library, Control, EnabledPropagator, ResizeHandler) {
	"use strict";



	/**
	 * Constructor for a new <code>Slider</code>.
	 *
	 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
	 * @param {object} [mSettings] Initial settings for the new control
	 *
	 * @class
	 * The interactive control is displayed either as a horizontal or a vertical line with a pointer and units of measurement.
	 * Users can move the pointer along the line to change values with graphical support.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Slider
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Slider = Control.extend("sap.ui.commons.Slider", /** @lends sap.ui.commons.Slider.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Width of the horizontal slider.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},

			/**
			 * Minimal value of the slider.
			 *
			 * <b>Note:</b> If <code>min</code> is larger than <code>max</code> both values will be switched
			 */
			min : {type : "float", group : "Appearance", defaultValue : 0},

			/**
			 * Maximal value of the slider
			 *
			 * <b>Note:</b> If <code>min</code> is larger than <code>max</code> both values will be switched
			 */
			max : {type : "float", group : "Appearance", defaultValue : 100},

			/**
			 * Current value of the slider. (Position of the grip.)
			 *
			 * <b>Note:</b> If the value is not in the valid range (between <code>min</code> and <code>max</code>) it will be changed to be in the valid range.
			 */
			value : {type : "float", group : "Appearance", defaultValue : 50},

			/**
			 * The grip can only be moved in steps of this width.
			 */
			smallStepWidth : {type : "float", group : "Appearance", defaultValue : null},

			/**
			 * Number of units that are displayed by ticks. The PageUp and PageDown keys navigate according to these units.
			 */
			totalUnits : {type : "int", group : "Appearance", defaultValue : null},

			/**
			 * Display step numbers for the ticks on the slider.
			 */
			stepLabels : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Using the slider interactively requires value "true".
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Switches enabled state of the control. Disabled fields have different colors, and can not be focused.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Labels to be displayed instead of numbers. Attribute totalUnits and label count should be the same
			 *
			 * <b>Note:</b> To show the labels <code>stepLabels</code> must be activated.
			 */
			labels : {type : "string[]", group : "Misc", defaultValue : null},

			/**
			 * Orientation of slider
			 * @since 1.7.1
			 */
			vertical : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Height of the vertical slider.
			 * @since 1.7.1
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'}
		},
		associations : {

			/**
			 * Association to controls / IDs which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 

			/**
			 * Association to controls / IDs which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {

			/**
			 * Value was changed. This event is fired if the value has changed by an user action.
			 */
			change : {
				parameters : {

					/**
					 * Current value of the slider after a change.
					 */
					value : {type : "float"}
				}
			},

			/**
			 * Value was changed. This event is fired during the mouse move. The normal change event is only fired by mouseup.
			 */
			liveChange : {
				parameters : {

					/**
					 * Current value of the slider after a change.
					 */
					value : {type : "float"}
				}
			}
		}
	}});


	EnabledPropagator.call(Slider.prototype);

	Slider.prototype.exit = function() {
		// Cleanup resize event registration on exit
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};

	Slider.prototype.onBeforeRendering = function() {
		// Cleanup resize event registration before re-rendering
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}

		// Warning in the case of wrong properties
		var fMin = this.getMin();
		var fMax = this.getMax();
		if ( fMin > fMax ) {
			jQuery.sap.log.warning('Property wrong: Min:' + fMin + ' > Max:' + fMax + '; values switched', this);
			this.setMin(fMax);
			this.setMax(fMin);
			fMax = fMin;
			fMin = this.getMin();
		}

	};

	Slider.prototype.onAfterRendering = function () {

		this.oGrip = this.getDomRef("grip");
		this.oBar  = this.getDomRef("bar");
		this.oHiLi = this.getDomRef("hili");
		this.bRtl  = sap.ui.getCore().getConfiguration().getRTL();
		this.bAcc  = sap.ui.getCore().getConfiguration().getAccessibility();
		this.bTextLabels = (this.getLabels() && this.getLabels().length > 0);
		this.oMovingGrip = this.oGrip;

		if (this.bTextLabels && (this.getLabels().length - 1) != this.getTotalUnits()) {
			jQuery.sap.log.warning('label count should be one more than total units', this);
		}

		this.iDecimalFactor = this.calcDecimalFactor(this.getSmallStepWidth());

		// Get left shift for middle of grip. Use offsetWidth to include borders. Round to prevent calculation errors.
		this.iShiftGrip = Math.round(this.getOffsetWidth(this.oGrip) / 2);

		// Calculate grip position
		var fValue = this.getValue();
		var fMin = this.getMin();
		var fMax = this.getMax();
		if ( fValue > fMax ) {
			jQuery.sap.log.warning('Property wrong: value:' + fValue + ' > Max:' + fMax + '; value set to Max', this);
			fValue = fMax;
		} else if ( fValue < fMin ) {
			jQuery.sap.log.warning('Property wrong: value:' + fValue + ' < Min:' + fMin + '; value set to Min', this);
			fValue = fMin;
		}

		var iNewPos = ( fValue - this.getMin() ) / ( this.getMax() - this.getMin() ) * this.getBarWidth();

		if (this.bRtl || this.getVertical()) {
			iNewPos = this.getBarWidth() - iNewPos;
		}

		// Move grip to hit the point in the middle
		this.changeGrip(fValue, iNewPos, this.oGrip);

		this.repositionTicksAndLabels();

		// Disable text selection
		this.allowTextSelection(false);

		// Register resize event
		this.oDomRef = this.getDomRef();
		this.sResizeListenerId = ResizeHandler.register(this.oDomRef, jQuery.proxy(this.onresize, this));

	};

	/**
	 * Function is called when Slider is clicked.
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onclick = function(oEvent) {

		var oMovingGrip = this.oMovingGrip;

		if (this.getEditable() && this.getEnabled()) {

			var fMultiplicator;

			// Check for ID where the behavior depends on the clicked area.
			var sMyTargetId = oEvent.target.getAttribute( 'ID' );
			var fNewValue = this.getValue();
			var iNewPos   = this.getOffsetLeft(this.oGrip) + this.iShiftGrip;
			var iTickPos  = 0;
			var iOffsetBar = 0;
			var iOffsetMe  = 0;

			switch ( sMyTargetId ) {
				case ( this.oBar.id ):
				case ( this.oHiLi.id ):
					// Click on slide bar
					if (this.getVertical()) {
						fMultiplicator = this.getBarWidth() - this.getOffsetX(oEvent);
					} else {
						fMultiplicator = this.getOffsetX(oEvent);
					}
					if (sMyTargetId == this.oHiLi.id) {
						if (this.getVertical()) {
							fMultiplicator -= this.getOffsetLeft(this.oHiLi);
						} else {
							fMultiplicator += this.getOffsetLeft(this.oHiLi);
						}
					}
					fNewValue = this.convertRtlValue(this.getMin() + ( ( ( this.getMax() - this.getMin() )  / this.getBarWidth() ) * fMultiplicator ));
					iNewPos = this.getOffsetX(oEvent);
					if (sMyTargetId == this.oHiLi.id) {
						iNewPos += this.getOffsetLeft(this.oHiLi);
					}
					if (this.oStartTarget && this.targetIsGrip(this.oStartTarget.id)) {
						oMovingGrip = this.oStartTarget;
					} else if (this.targetIsGrip(sMyTargetId)) {
						oMovingGrip = oEvent.target;
					} else {
						oMovingGrip = this.getNearestGrip(iNewPos);
					}
					break;
				case ( this.getId() + '-left' ):
					// Click on left end
					iNewPos = 0;
					if (this.getVertical()) {
						fNewValue = this.getMax();
						oMovingGrip = this.getRightGrip();
					} else {
						fNewValue = this.getMin();
						oMovingGrip = this.getLeftGrip();
					}
					break;
				case ( this.getId() + '-right' ):
					// Click on right end
					iNewPos = this.getBarWidth();
					if (!this.getVertical()) {
						fNewValue = this.getMax();
						oMovingGrip = this.getRightGrip();
					} else {
						fNewValue = this.getMin();
						oMovingGrip = this.getLeftGrip();
					}
					break;
				default:
					//If target is grip return
					//Not implemented as case because RangeSlider has multiple grips, for which cases cannot be inserted afterwards
					if (this.targetIsGrip(sMyTargetId)) {
						return;
					}
					// Check whether tick is clicked
					iTickPos = sMyTargetId.search('-tick');
					if ( iTickPos >= 0) {
						var iTickNum = parseInt( sMyTargetId.slice( this.getId().length + 5), 10);
						iNewPos = this.fTickDist * iTickNum;
						var iTotalUnits;
						if (this.bTextLabels) {
							iTotalUnits = this.getLabels().length - 1;
						} else {
							iTotalUnits = this.getTotalUnits();
						}
						fNewValue = this.convertRtlValue(this.getMin() + ( ( ( this.getMax() - this.getMin() ) / iTotalUnits ) * iTickNum ));
						if (this.oStartTarget && this.targetIsGrip(this.oStartTarget.id)) {
							oMovingGrip = this.oStartTarget;
						} else if (this.targetIsGrip(sMyTargetId)) {
							oMovingGrip = oEvent.target;
						} else {
							oMovingGrip = this.getNearestGrip(iNewPos);
						}
						break;
					}

					// Outer DIV clicked -> ID given by caller. This is the case if all other DIVs are smaller,
					// or if tick text is clicked
					iOffsetBar = jQuery(this.oBar).offset();
					iOffsetMe  = jQuery(oEvent.target).offset();
					if (this.getVertical()) {
						iNewPos = this.getOffsetX(oEvent) - ( iOffsetBar.top - iOffsetMe.top );
					} else {
						iNewPos = this.getOffsetX(oEvent) - ( iOffsetBar.left - iOffsetMe.left );
					}
					/* eslint-disable no-lonely-if */
					if ( iNewPos <= 0 ) {
						iNewPos = 0;
						if (this.getVertical()) {
							fNewValue = this.getMax();
						} else {
							fNewValue = this.getMin();
						}
					} else {
						if ( iNewPos >= this.getBarWidth() ) {
							iNewPos = this.getBarWidth();
							if (this.getVertical()) {
								fNewValue = this.getMin();
							} else {
								fNewValue = this.getMax();
							}
						} else {
							if (this.getVertical()) {
								fMultiplicator = this.getBarWidth() - iNewPos;
							} else {
								fMultiplicator = iNewPos;
							}
							fNewValue = this.getMin() + ( ( ( this.getMax() - this.getMin() )  / this.getBarWidth() ) * fMultiplicator );
						}
					}
					fNewValue = this.convertRtlValue(fNewValue);
					if (this.oStartTarget && this.targetIsGrip(this.oStartTarget.id)) {
						oMovingGrip = this.oStartTarget;
					} else if (this.targetIsGrip(sMyTargetId)) {
						oMovingGrip = oEvent.target;
					} else {
						oMovingGrip = this.getNearestGrip(iNewPos);
					}
					break;
			}

			var validation = this.validateNewPosition(fNewValue, iNewPos, oMovingGrip, (this.getValueForGrip(oMovingGrip) > fNewValue));
			fNewValue = validation.fNewValue;
			iNewPos = validation.iNewPos;

			this.changeGrip(fNewValue, iNewPos, oMovingGrip);
			this.handleFireChange();
		}

		// Set focus to grip
		oMovingGrip.focus();
		this.oMovingGrip = oMovingGrip;
		this.oStartTarget = null;

	};

	/**
	 * Function is called when Slider is clicked
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onmousedown = function(oEvent) {

		if (this.getEditable() && this.getEnabled() && !this._cancelMousedown) {

			// Check for ID. This is only possible on the grip.
			var sMyTargetId = oEvent.target.getAttribute( 'ID' );

			if ( this.targetIsGrip(sMyTargetId) ) {
				this.bGripMousedown = true;

				// Remember start coordinates
				if (oEvent.targetTouches) {
					this.iStartDragX = oEvent.targetTouches[0].pageX;
					this.iStartDragY = oEvent.targetTouches[0].pageY;
				} else {
					this.iStartDragX = oEvent.pageX;
					this.iStartDragY = oEvent.pageY;
				}

				this.iStartLeft  = this.getOffsetLeft(oEvent.target) + this.iShiftGrip;

				this.oMovingGrip = oEvent.target;

				var that = this;
				this.handleMoveCall = function (event){
					that.handleMove(event);
				};
				this.preventSelect = function (event){
					return false;
				};

				if (!oEvent.targetTouches) {
					jQuery(window.document).bind('mousemove', this.handleMoveCall);
					jQuery(window.document).bind('selectstart', this.preventSelect);
					jQuery.sap.bindAnyEvent(jQuery.proxy(this.onAnyEvent, this));
				}
			}
			this.oStartTarget = null;
		}
	};

	Slider.prototype.ontouchstart = function(oEvent) {

		if ( (oEvent.originalEvent && jQuery.sap.startsWith(oEvent.originalEvent.type, "mouse")) ||
		     (oEvent.handleObj && jQuery.sap.startsWith(oEvent.handleObj.origType, "mouse"))) {
			// ignore simulated touch events (if mouse events are available use them)
			return;
		}

		this._cancelMousedown = false;

		this.onmousedown(oEvent);

		this._cancelMousedown = true;

	};

	/**
	 * Function is called when Slider is unclicked
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onmouseup = function(oEvent) {

		if (this.getEditable() && this.getEnabled()) {
			// Mouseup is handled on every div, not only on grip

			this.bGripMousedown = false;

			if (this.handleMoveCall) {
				jQuery(window.document).unbind('mousemove', this.handleMoveCall);
				jQuery(window.document).unbind('selectstart', this.preventSelect);
				jQuery.sap.unbindAnyEvent(this.onAnyEvent);

				if ( this.iStartLeft != ( this.getOffsetLeft(this.oMovingGrip) + this.iShiftGrip )) {
					// Only if position was changed
					// only fire change event because liveChange is already fired in handleMove
					this.handleFireChange(true); // without liveChange
				}

				this.handleMoveCall = null;
				this.iStartDragX    = null;
				this.iStartDragY    = null;
				this.iStartLeft     = null;
			}
		}

	};

	Slider.prototype.ontouchend = function(oEvent) {

		if ( (oEvent.originalEvent && jQuery.sap.startsWith(oEvent.originalEvent.type, "mouse")) ||
		     (oEvent.handleObj && jQuery.sap.startsWith(oEvent.handleObj.origType, "mouse"))) {
			// ignore simulated touch events (if mouse events are available use them)
			return;
		}

		this.onmouseup(oEvent);

	};

	/**
	 * Function is called when Slider is moved
	 *
	 * @param {DOM.Event} event The event object
	 * @returns {boolean} return value for event
	 * @private
	 */
	Slider.prototype.handleMove = function(event) {

		if (this.getEditable() && this.getEnabled() && this.bGripMousedown ) {

			event = event || window.event;

			// Move is handled on every div, not only on grip

			var iPageX, iPageY;
			if (event.targetTouches) {
				iPageX = event.targetTouches[0].pageX;
				iPageY = event.targetTouches[0].pageY;
			} else {
				iPageX = event.pageX;
				iPageY = event.pageY;
			}

			var iNewPos;
			var fNewValue;
			if (this.getVertical()) {
				iNewPos = this.iStartLeft + iPageY - this.iStartDragY;
			} else {
				iNewPos = this.iStartLeft + iPageX - this.iStartDragX;
			}

			/* eslint-disable no-lonely-if */
			if ( iNewPos <= 0 ) {
				iNewPos = 0;
				if (this.getVertical()) {
					fNewValue = this.getMax();
				} else {
					fNewValue = this.getMin();
				}
			} else {
				if ( iNewPos >= this.getBarWidth() ) {
					iNewPos = this.getBarWidth();
					if (this.getVertical()) {
						fNewValue = this.getMin();
					} else {
						fNewValue = this.getMax();
					}
				} else {
					var fMultiplicator;
					if (this.getVertical()) {
						fMultiplicator = this.getBarWidth() - iNewPos;
					} else {
						fMultiplicator = iNewPos;
					}
					fNewValue = this.getMin() + ( ( ( this.getMax() - this.getMin() )  / this.getBarWidth() ) * fMultiplicator );
				}
			}
			fNewValue = this.convertRtlValue(fNewValue);
			var fOldValue = this.getValueForGrip(this.oMovingGrip);

			var validation = this.validateNewPosition(fNewValue, iNewPos, this.oMovingGrip, (fOldValue > fNewValue));
			fNewValue = validation.fNewValue;
			iNewPos = validation.iNewPos;

			this.changeGrip(fNewValue, iNewPos, this.oMovingGrip);
			fNewValue = this.getValueForGrip(this.oMovingGrip); // get new value considering step width

			this.fireLiveChangeForGrip(this.oMovingGrip, fNewValue, fOldValue);
			this.oStartTarget = this.oMovingGrip;
		}

		event.cancelBubble = true;

		return false;

	};

	Slider.prototype.ontouchmove = function(oEvent) {

		if ( (oEvent.originalEvent && jQuery.sap.startsWith(oEvent.originalEvent.type, "mouse")) ||
		     (oEvent.handleObj && jQuery.sap.startsWith(oEvent.handleObj.origType, "mouse"))) {
			// ignore simulated touch events (if mouse events are available use them)
			return;
		}

		this.handleMove(oEvent);

		oEvent.preventDefault();

	};

	/**
	 * Function is called when Slider is moved
	 *
	 * @param {Element} oGrip DOM-Ref of grip
	 * @param {float} fNewValue new value
	 * @param {float} fOldValue old value
	 * @private
	 */
	Slider.prototype.fireLiveChangeForGrip = function (oGrip, fNewValue, fOldValue) {
		if (oGrip == this.oGrip) {
			if ( fOldValue != fNewValue ) {
				// fire event only if value changed
				this.fireLiveChange( { value: fNewValue } );
			}
		}
	};

	/**
	 * Handles all events that occur outside the Popup and
	 * dispatches it to the onOuterEvent
	 * @param {jQuery.EventObject} oEvent The event object of the ui.core framework
	 * @private
	 */
	Slider.prototype.onAnyEvent = function (oEvent) {

		jQuery.sap.log.info('onAnyEvent fired: "' + oEvent.type + '"');

		// Skip if not editable or no drag operation in progress
		if ((!this.getEditable()) || (!this.getEnabled()) || !this.bGripMousedown) {
			return;
		}

		// Check if outside of control
		var oSource = oEvent.target;
		if ((!jQuery.sap.containsOrEquals(this.oDomRef,oSource) || oSource.tagName == "BODY") && oEvent.type == 'mouseup') {
			this.onmouseup(oEvent);
		}

	};

	/**
	 * Function is called when right arrow is pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapright = function(oEvent) {

		if (this.getEditable() && this.getEnabled()) {

			var fNewValue = this.convertRtlValue(this.getValueForGrip(this.oMovingGrip));
			var iNewPos   = this.getOffsetLeft(this.oMovingGrip) + this.iShiftGrip;

			if (this.getSmallStepWidth() > 0) {
				// Step defined -> shift grip one step; at least one pixel, if step < 1px
				var fStepPixel = this.getBarWidth() / ( this.getMax() - this.getMin() ) * this.getSmallStepWidth();

				if (fStepPixel > 1) {
					fNewValue = fNewValue + this.getSmallStepWidth();
					if (this.getVertical()) {
						iNewPos   = iNewPos - fStepPixel;
					} else {
						iNewPos   = iNewPos + fStepPixel;
					}
				} else {
					// Step < 1px -> shift grip to next step that is 1 pixel away
					fNewValue = fNewValue + ( 1 / fStepPixel * this.getSmallStepWidth() );
					if (this.getVertical()) {
						iNewPos   = iNewPos - 1;
					} else {
						iNewPos   = iNewPos + 1;
					}
				}
			} else {
				// No step defined -> shift grip 1 pixel
				fNewValue = fNewValue + ( ( this.getMax() - this.getMin() ) / this.getBarWidth() );
				if (this.getVertical()) {
					iNewPos   = iNewPos - 1;
				} else {
					iNewPos   = iNewPos + 1;
				}
			}
			fNewValue = this.convertRtlValue(fNewValue);

			var validation = this.validateNewPosition(fNewValue, iNewPos, this.oMovingGrip, !this.getVertical() && this.bRtl);
			fNewValue = validation.fNewValue;
			iNewPos = validation.iNewPos;

			this.changeGrip(fNewValue, iNewPos, this.oMovingGrip);
			this.handleFireChange();

		}

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * Function is called when left arrow is pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapleft = function(oEvent) {

		if (this.getEditable() && this.getEnabled()) {

			var fNewValue = this.convertRtlValue(this.getValueForGrip(this.oMovingGrip));
			var iNewPos   = this.getOffsetLeft(this.oMovingGrip) + this.iShiftGrip;

			if (this.getSmallStepWidth() > 0) {
				// Step defined -> shift grip one step (at least one pixel, if step < 1px)
				var fStepPixel = this.getBarWidth() / ( this.getMax() - this.getMin() ) * this.getSmallStepWidth();

				if (fStepPixel > 1) {
					fNewValue = fNewValue - this.getSmallStepWidth();
					if (this.getVertical()) {
						iNewPos   = iNewPos + fStepPixel;
					} else {
						iNewPos   = iNewPos - fStepPixel;
					}
				} else {
					fNewValue = fNewValue - ( 1 / fStepPixel * this.getSmallStepWidth() );
					if (this.getVertical()) {
						iNewPos   = iNewPos + 1;
					} else {
						iNewPos   = iNewPos - 1;
					}
				}
			} else {
				// No step defined -> shift grip one pixel
				fNewValue = fNewValue - ( ( this.getMax() - this.getMin() ) / this.getBarWidth() );
				if (this.getVertical()) {
					iNewPos   = iNewPos + 1;
				} else {
					iNewPos   = iNewPos - 1;
				}
			}
			fNewValue = this.convertRtlValue(fNewValue);

			var validation = this.validateNewPosition(fNewValue, iNewPos, this.oMovingGrip, this.getVertical() || !this.bRtl);
			fNewValue = validation.fNewValue;
			iNewPos = validation.iNewPos;

			this.changeGrip(fNewValue, iNewPos, this.oMovingGrip);
			this.handleFireChange();

		}

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * Function is called when up arrow is pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapup = function(oEvent) {
		if (this.bRtl && !this.getVertical()) {
			this.onsapleft(oEvent);
		} else {
			this.onsapright(oEvent);
		}
	};

	/**
	 * Function is called when DOWN arrow is pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapdown = function(oEvent) {
		if (this.bRtl && !this.getVertical()) {
			this.onsapright(oEvent);
		} else {
			this.onsapleft(oEvent);
		}
	};

	/**
	 * Function is called when "+" is pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapexpand = function(oEvent) {

		if (!this.bRtl) {
			// Normal case - "+" similar to right
			this.onsapright(oEvent);
		} else {
			// RTL case - "+" similar to left
			this.onsapleft(oEvent);
		}

	};

	/**
	 * Function is called when "-" is pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapcollapse = function(oEvent) {

		if (!this.bRtl) {
			// Normal case - "-" similar to left
			this.onsapleft(oEvent);
		} else {
			// RTL case - "-" similar to right
			this.onsapright(oEvent);
		}

	};

	/**
	 * Function is called when Home key pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsaphome = function(oEvent) {

		if (this.getEditable() && this.getEnabled()) {
			var iNewPos = 0;
			if (this.getVertical() || (this.bRtl && !this.getVertical())) {
				iNewPos = this.getBarWidth();
			}

			this.changeGrip(this.getMin(), iNewPos, this.oMovingGrip);
			this.handleFireChange();
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * Function is called when End key pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapend = function(oEvent) {

		if (this.getEditable() && this.getEnabled()) {
			var iNewPos = this.getBarWidth();
			if (this.getVertical() || (this.bRtl && !this.getVertical())) {
				iNewPos = 0;
			}

			this.changeGrip(this.getMax(), iNewPos, this.oMovingGrip);
			this.handleFireChange();
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * Function is called when Ctrl+right key pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsaprightmodifiers = function(oEvent) {

		if (this.getEditable() && this.getEnabled()) {

			if (!this.fPageSize) {
				if (this.getTotalUnits() > 0) {
					this.fPageSize = ( this.getMax() - this.getMin() ) / this.getTotalUnits();
				} else {
					this.fPageSize = ( this.getMax() - this.getMin() ) / 10;
				}
			}

			var fNewValue;
			if (!this.bRtl || this.getVertical()) {
				fNewValue = this.getValueForGrip(this.oMovingGrip) + this.fPageSize;
			} else {
				fNewValue = this.getValueForGrip(this.oMovingGrip) - this.fPageSize;
			}
			// Calculate iNewPos from fNewValue to prevent rounding errors after repeating pageUps
			var iNewPos   = ( fNewValue - this.getMin() ) / ( this.getMax() - this.getMin() ) * this.getBarWidth();
			if (this.bRtl && !this.getVertical()) {
				iNewPos = this.getBarWidth() - iNewPos;
			}

			if (this.getVertical()) {
				if (iNewPos > this.getBarWidth()) {
					iNewPos = this.getBarWidth();
				}
				iNewPos = this.getBarWidth() - iNewPos;
			}

			var validation = this.validateNewPosition(fNewValue, iNewPos, this.oMovingGrip, !this.getVertical() && this.bRtl);
			fNewValue = validation.fNewValue;
			iNewPos = validation.iNewPos;

			this.changeGrip(fNewValue, iNewPos, this.oMovingGrip);
			this.handleFireChange();
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * Function is called when Ctrl+left key pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapleftmodifiers = function(oEvent) {

		if (this.getEditable() && this.getEnabled()) {

			if (!this.fPageSize) {
				if (this.getTotalUnits() > 0) {
					this.fPageSize = ( this.getMax() - this.getMin() ) / this.getTotalUnits();
				} else {
					this.fPageSize = ( this.getMax() - this.getMin() ) / 10;
				}
			}

			var fNewValue;
			if (!this.bRtl || this.getVertical()) {
				fNewValue = this.getValueForGrip(this.oMovingGrip) - this.fPageSize;
			} else {
				fNewValue = this.getValueForGrip(this.oMovingGrip) + this.fPageSize;
			}
			// Calculate iNewPos from fNewValue to prevent rounding errors after repeating pageDowns
			var iNewPos   = ( fNewValue - this.getMin() ) / ( this.getMax() - this.getMin() ) * this.getBarWidth();
			if (this.bRtl && !this.getVertical()) {
				iNewPos = this.getBarWidth() - iNewPos;
			}

			if (this.getVertical()) {
				if (iNewPos < 0) {
					iNewPos = 0;
				}
				iNewPos = this.getBarWidth() - iNewPos;
			}

			var validation = this.validateNewPosition(fNewValue, iNewPos, this.oMovingGrip, this.getVertical() || !this.bRtl);
			fNewValue = validation.fNewValue;
			iNewPos = validation.iNewPos;

			this.changeGrip(fNewValue, iNewPos, this.oMovingGrip);
			this.handleFireChange();
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * Function is called when Ctrl+down key pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapdownmodifiers = function(oEvent) {
		if (this.bRtl && !this.getVertical()) {
			this.onsaprightmodifiers(oEvent);
		} else {
			this.onsapleftmodifiers(oEvent);
		}
	};

	/**
	 * Function is called when Ctrl+Up key pressed
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onsapupmodifiers = function(oEvent) {
		if (this.bRtl && !this.getVertical()) {
			this.onsapleftmodifiers(oEvent);
		} else {
			this.onsaprightmodifiers(oEvent);
		}
	};

	/**
	 * Function is called when window is resized
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onresize = function(oEvent) {

		if (!this.getDomRef()) {
			// slider is not renderes, maybe deleted from DOM -> deregister resize handler and do nothing
			// Cleanup resize event registration on exit
			if (this.sResizeListenerId) {
				ResizeHandler.deregister(this.sResizeListenerId);
				this.sResizeListenerId = null;
			}
			return;
		}

		// If width of control changed -> grip position must be newly calculated

		var fNewValue = this.getValue();

		var iNewPos   = ( fNewValue - this.getMin() ) / ( this.getMax() - this.getMin() ) * this.getBarWidth();
		if (this.getVertical() || this.bRtl) {
			iNewPos = this.getBarWidth() - iNewPos;
		}

		this.changeGrip(fNewValue, iNewPos, this.oGrip);

		this.repositionTicksAndLabels();

	};

	/*
	 * Resposition ticks and labels
	 *
	 * @private
	 */
	Slider.prototype.repositionTicksAndLabels = function() {
		var iTotalUnits;
		if (this.bTextLabels) {
			iTotalUnits = this.getLabels().length - 1;
		} else {
			iTotalUnits = this.getTotalUnits();
		}

		if (iTotalUnits > 0) {
			// Move ticks to correct position; put it in the middle.
			// Round value shift factor separately to have the same behavior like for the grip position.

			var oTick = null;
			var oText = null;

			this.fTickDist = this.getBarWidth() / iTotalUnits;

			for (var i = 0; i <= iTotalUnits; i++) {
				oTick = jQuery.sap.domById(this.getId() + '-tick' + i);
				var iLeft = 0;
				if (!this.bRtl || this.getVertical()) {
					iLeft = Math.round( this.fTickDist * i ) - Math.ceil( this.getOffsetWidth(oTick) / 2 );
				} else {
					iLeft = Math.round( this.fTickDist * i ) - Math.floor( this.getOffsetWidth(oTick) / 2 );
				}
				if (this.getVertical()) {
					iLeft = this.getBarWidth() - iLeft - this.getOffsetWidth(oTick);
				}
				this.setLeft(iLeft, oTick);

				if ( this.getStepLabels() && i > 0 && i < iTotalUnits) {
					oText = jQuery.sap.domById(this.getId() + '-text' + i);
					if (this.getSmallStepWidth() > 0 && this.iDecimalFactor > 0 && !this.bTextLabels) {
						jQuery(oText).text(Math.round( parseFloat(jQuery(oText).text()) * this.iDecimalFactor ) / this.iDecimalFactor);
					}
					if (!this.bRtl || this.getVertical()) {
						iLeft = Math.round( ( this.fTickDist * i)) - Math.round(( this.getOffsetWidth(oText) / 2) );
					} else {
						iLeft = Math.round( ( this.fTickDist * (iTotalUnits - i))) - Math.round(( this.getOffsetWidth(oText) / 2) );
					}
					if (this.getVertical()) {
						iLeft = this.getBarWidth() - iLeft - this.getOffsetWidth(oText);
					}
					this.setLeft(iLeft, oText);
				}
			}
		}

	};

	/**
	 * Called after the theme has been switched. Some adjustments required.
	 * @param {jQuery.Event} oEvent The event object
	 * @private
	 */
	Slider.prototype.onThemeChanged = function (oEvent) {

		if (this.getDomRef()) {
			// Get left shift for middle of grip. Use offsetWidth to include borders. Round to prevent calculation errors.
			this.iShiftGrip = Math.round(this.getOffsetWidth(this.oGrip) / 2);

			// Use resize function to adjust grip and ticks
			this.onresize();
		}

	};

	/**
	 * Function is called when grip position shall be changed
	 *
	 * @param {float} fNewValue new value
	 * @param {int} iNewPos new position
	 * @param {Element} oGrip DOM-Ref of grip
	 * @private
	 */
	Slider.prototype.changeGrip = function(fNewValue, iNewPos, oGrip) {
		// Only if position was changed
		if ( iNewPos != ( this.getOffsetLeft(oGrip) + this.iShiftGrip ) ) {

			if ( this.getSmallStepWidth() > 0 ) {
				// Move grip according to step-width
				var iStepNum   = parseInt( ( fNewValue - this.getMin() ) / this.getSmallStepWidth() , 10);
				var fLeftStep  = ( iStepNum * this.getSmallStepWidth() ) + this.getMin();
				var fRightStep = ( ( iStepNum + 1 ) * this.getSmallStepWidth() ) + this.getMin();

				if ( fRightStep > this.getMax() ) {
					fRightStep = this.getMax();
				}

				var fStepPixel = this.getBarWidth() / ( this.getMax() - this.getMin() ) * this.getSmallStepWidth();

				if ( ( fNewValue - fLeftStep ) < ( fRightStep - fNewValue ) ) {
					fNewValue = fLeftStep;
					iNewPos   = iStepNum * fStepPixel;
				} else {
					fNewValue = fRightStep;
					iNewPos   = ( iStepNum + 1 ) * fStepPixel;
					if ( iNewPos > this.getBarWidth() ) {
						iNewPos = this.getBarWidth();
					}
				}
				if (this.getVertical() || this.bRtl) {
					iNewPos = this.getBarWidth() - iNewPos;
				}
				// Round value because of calculation errors in JavaScript
				fNewValue = Math.round( fNewValue * this.iDecimalFactor ) / this.iDecimalFactor;
			}

			// Reduce position with half grip-width to center the grip. Round because Internet Explorer does not round automatically.

			var iLeft = Math.round(iNewPos - this.iShiftGrip);
			if (isNaN(iLeft)) {
				return;
			}

			//Output iShiftGrip to check if rendering issue occurs because of wrong value
			jQuery.sap.log.info("iNewPos: " + iNewPos + " - iLeft: " + iLeft + " - iShiftGrip: " + this.iShiftGrip);

			this.updateValueProperty(fNewValue, oGrip);

			if (this.bTextLabels) {
				oGrip.title = this.getNearestLabel(fNewValue);
			} else {
				oGrip.title = fNewValue;
			}

			this.setLeft(iLeft, oGrip);

			this.adjustHighlightBar(iNewPos, oGrip);

			if (this.bAcc) {
				this.setAriaState();
			}
		}

	};

	/**
	 * Function to update value property for grip
	 *
	 * @param {float} fNewValue new value
	 * @param {Element} oGrip DOM-Ref of grip
	 * @private
	 */
	Slider.prototype.updateValueProperty = function(fNewValue,oGrip) {
		this.setProperty( 'value', fNewValue, true ); // Do not render complete control again
	};

	/**
	 * Function to set width and position of highlight bar
	 *
	 * @param {int} iNewPos new position
	 * @param {Element} oGrip DOM-Ref of grip
	 * @private
	 */
	Slider.prototype.adjustHighlightBar = function(iNewPos,oGrip) {

		/* eslint-disable no-lonely-if */
		if (this.bRtl) {
			// In the case of RTL, highlight must be on right side
			if (this.getVertical()) {
				this.oHiLi.style.height = this.getBarWidth() - Math.round(iNewPos) + 'px';
			} else {
				this.oHiLi.style.width = this.getBarWidth() - Math.round(iNewPos) + 'px';
			}
		} else {
			if (this.getVertical()) {
				this.oHiLi.style.height = this.getBarWidth() - Math.round(iNewPos) + 'px';
			} else {
				this.oHiLi.style.width = Math.round(iNewPos) + 'px';
			}
		}
	};

	/**
	 * Function to calculate the decimals of a value
	 *
	 * Problem:  If the step-width has decimals in JavaScript, there are calculation errors.
	 *           e.g. 2.01*10= 20.099999999999998 instead of 20.1
	 *           This is not sufficient as result for the value of sliding step-wise.
	 *           Therefore the value is rounded with the numbers of decimals the step-width has.
	 *           This is not possible using the modulo or any other Math function because
	 *           of the mentioned calculation error.
	 * Solution: The idea is to search for the "." in the string and to calculate the rounding factor.
	 *
	 * @param {string} Value value
	 * @returns {int} decimal factor
	 * @private
	 */
	Slider.prototype.calcDecimalFactor = function(Value) {

		var iFactor = 1;

		if ( !( Value > 0 )) {
			return iFactor;
		}

		var sMyString = String( Value );
		var iMyExp = 0;

		/* eslint-disable no-lonely-if */
		if ( sMyString.indexOf( '.' ) >= 0 ) {
			// Number of decimals = length of all numbers after the "." Subtract the numbers before the "." and the "." itself.
			iMyExp = sMyString.length - sMyString.indexOf( '.' ) - 1;
		} else {
			if ( sMyString.indexOf( 'e-' ) >= 0 ) {
				// Floating point number -> number of decimals is number after "e-"
				iMyExp = sMyString.slice(sMyString.indexOf( 'e-' ) + 2);
			} else {
				return iFactor;
			}
		}

		for (var i = 1; i <= iMyExp; i++) {
			iFactor = iFactor * 10;
		}

		return iFactor;

	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the editable state
	 *
	 * @param {boolean} bEditable Whether the Slider should be editable, or not (read-only then)
	 * @return {sap.ui.commons.Slider} <code>this</code> to allow method chaining
	 * @public
	 */
	Slider.prototype.setEditable = function(bEditable) {

		this.setProperty('editable', bEditable, true); // No re-rendering

		if (this.oDomRef && this.getEnabled()) {
			// If already rendered, adapt rendered control without complete re-rendering
			if (bEditable) {
				jQuery(this.oDomRef).removeClass('sapUiSliRo').addClass('sapUiSliStd');
				if (this.bAcc) {
					jQuery(this.oGrip).attr('aria-disabled', false);
				}
			} else {
				jQuery(this.oDomRef).removeClass('sapUiSliStd').addClass('sapUiSliRo');
				if (this.bAcc) {
					jQuery(this.oGrip).attr('aria-disabled', true);
				}
			}
		}

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the enabled state
	 *
	 * @param bEnabled Whether the Slider should be ednabled, or not (disabled)
	 * @return {sap.ui.commons.Slider} <code>this</code> to allow method chaining
	 * @public
	 */
	Slider.prototype.setEnabled = function(bEnabled) {

		this.setProperty('enabled', bEnabled, true); // No re-rendering

		if (this.oDomRef) {
			// If already rendered, adapt rendered control without complete re-rendering
			jQuery(this.oDomRef).toggleClass('sapUiSliDsbl', !bEnabled);
			if ( bEnabled ) {
				jQuery(this.oGrip).attr('tabindex', '0');
				// set classes according editable state
				if (this.getEditable()) {
					jQuery(this.oDomRef).addClass('sapUiSliStd');
					if (this.bAcc) {
						jQuery(this.oGrip).attr('aria-disabled', false);
					}
				} else {
					jQuery(this.oDomRef).addClass('sapUiSliRo');
					if (this.bAcc) {
						jQuery(this.oGrip).attr('aria-disabled', true);
					}
				}
			} else {
				jQuery(this.oGrip).attr('tabindex', '-1').attr('aria-disabled', true);
				if (this.getEditable()) {
					jQuery(this.oDomRef).removeClass('sapUiSliStd');
				} else {
					jQuery(this.oDomRef).removeClass('sapUiSliRo');
				}
			}
		}

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the totalUnits state
	 *
	 * @param iTotalUnits Number of the units (tick-spaces)
	 * @return {sap.ui.commons.Slider} <code>this</code> to allow method chaining
	 * @public
	 */
	Slider.prototype.setTotalUnits = function(iTotalUnits) {

		this.setProperty('totalUnits', iTotalUnits, false); // Do re-rendering

		// Clear this.fPageSize -> must be re-calculated
		this.fPageSize = false;

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the value
	 * A new rendering is not necessary, only the grip must be moved.
	 *
	 * @param fValue
	 * @return {sap.ui.commons.Slider} <code>this</code> to allow method chaining
	 * @public
	 */
	Slider.prototype.setValue = function(fValue) {

		this.setProperty('value', fValue, true); // No re-rendering

		this._lastValue = fValue;

		// Check for number -> if NaN -> no change
		if ( isNaN(fValue) ) {
			return this;
		}

		if (!this.oBar) {
			// Not already rendered -> return and render
			return this;
		}

		var fNewValue = parseFloat( fValue );
		var iNewPos;

		if ( fNewValue >= this.getMax() ) {
			fNewValue   = this.getMax();
			if (this.getVertical()) {
				iNewPos = 0;
			} else {
				iNewPos = this.getBarWidth();
			}
		} else if ( fNewValue <= this.getMin() ) {
			fNewValue   = this.getMin();
			if (this.getVertical()) {
				iNewPos = this.getBarWidth();
			} else {
				iNewPos = 0;
			}
		} else {
			iNewPos = ( fNewValue - this.getMin() ) / ( this.getMax() - this.getMin() ) * this.getBarWidth();
		}

		if (this.bRtl && !this.getVertical()) {
			iNewPos = this.getBarWidth() - iNewPos;
		}

		this.changeGrip( fNewValue, iNewPos, this.oGrip );
		this._lastValue = fNewValue;

		return this;

	};

	/*
	 * fires the change event. The liveChange event must be fired too if the change event is fired.
	 *
	 * @param bNoLiveChange fire no LiveChange event
	 * @private
	 */
	Slider.prototype.handleFireChange = function(bNoLiveChange) {

		var iValue = this.getValue();

		if (iValue !== this._lastValue) {
			this.fireChange({value: iValue});
			if (!bNoLiveChange) {
				this.fireLiveChange({value: iValue});
			}
			this._lastValue = iValue;
		}

	};

	/*
	 * Updates the ARIA state initially and in case of changes.
	 *
	 * @private
	 */
	Slider.prototype.setAriaState = function() {

		var fValue = this.getValue();

		if (this.bTextLabels) {
			fValue = this.getNearestLabel(fValue);
		}

		this.oGrip.setAttribute('aria-valuenow', fValue);

	};

	/**
	 * Returns value for specified grip.
	 * This function is for reuse in other sliders like the range slider, which has multiple grips
	 *
	 * @private
	 * @param {Element} oGrip DOM-Ref of grip
	 * @return {float} Value for the grip, which was passed to this function
	 */
	Slider.prototype.getValueForGrip = function(oGrip) {
		return this.getValue();
	};

	/**
	 * Check if new position and new value are valid within the slider
	 *
	 * @private
	 * @param {float} fNewValue new value
	 * @param {int} iNewPos new position
	 * @param {Element} oGrip DOM-Ref of grip
	 * @param {boolean} bMin If true, checks if validation should be done with minimum values, else it uses maximum values
	 * @return {object} oCorrectedData Object with modified data, if validation was not successful
	 */
	Slider.prototype.validateNewPosition = function(fNewValue, iNewPos, oGrip, bMin) {

		/* eslint-disable no-lonely-if */
		if (!this.bRtl || this.getVertical()) {
			if (bMin) {
				if ( fNewValue <= this.getMin() || iNewPos <= 0 ) {
					fNewValue = this.getMin();
					if (this.getVertical()) {
						iNewPos   = this.getBarWidth();
					} else {
						iNewPos   = 0;
					}
				}
			} else {
				if ( fNewValue >= this.getMax() || iNewPos > this.getBarWidth() ) {
					fNewValue = this.getMax();
					if (!this.getVertical()) {
						iNewPos   = this.getBarWidth();
					} else {
						iNewPos   = 0;
					}
				}
			}
		} else {
			if (bMin) {
				if ( fNewValue <= this.getMin() || iNewPos > this.getBarWidth() ) {
					fNewValue = this.getMin();
					iNewPos   = this.getBarWidth();
				}
			} else {
				if ( fNewValue >= this.getMax() || iNewPos <= 0 ) {
					fNewValue = this.getMax();
					iNewPos   = 0;
				}
			}
		}
		return {fNewValue: fNewValue, iNewPos: iNewPos};
	};

	/**
	 * Gets the nearest label (realative to the specified value).
	 *
	 * @private
	 * @param {float} fValue value
	 * @return {string} Text for label
	 */
	Slider.prototype.getNearestLabel = function(fValue) {
		var iPos = Math.round((this.getLabels().length - 1) / (this.getMax() - this.getMin()) * (fValue - this.getMin()));
		if (this.bRtl) {
			iPos = this.getLabels().length - 1 - iPos;
		}
		return this.getLabels()[iPos];
	};

	/**
	 * Function returns nearest grip (if there is more than one grip). There is only one grip for the basic slider
	 *
	 * @private
	 * @param {int} iOffset Offset relative to Bar
	 * @returns {Element} DOM-Ref of grip
	 * 
	 */
	Slider.prototype.getNearestGrip = function(iOffset) {
		return this.oGrip;
	};

	/**
	 * Function returns grip which should by moved after a click on left side
	 *
	 * @returns {Element} DOM-Ref of grip
	 * @private
	 */
	Slider.prototype.getLeftGrip = function() {
		return this.oGrip;
	};

	/**
	 * Function returns grip which should by moved after a click on right side
	 *
	 * @returns {Element} DOM-Ref of grip
	 * @private
	 */
	Slider.prototype.getRightGrip = function() {
		return this.oGrip;
	};

	/**
	 * Set left/top for an object. Translates the value for vertical sldiers and RTL
	 *
	 * @private
	 * @param {int} iNewPos New left attribute for specified object
	 * @param {Element} oObject Dom-Ref
	 */
	Slider.prototype.setLeft = function(iNewPos, oObject) {
		if (oObject == undefined) {
			return;
		}
		if (this.getVertical()) {
			oObject.style.top = iNewPos + 'px';
		} else {
			oObject.style.left = iNewPos + 'px';
		}
	};

	/**
	 * Get offset width/height for specified object. Translates between vertical and horizontal slider
	 *
	 * @param {Element} oObject Dom-Ref
	 * @returns {int} offset height or width
	 * @private
	 */
	Slider.prototype.getOffsetWidth = function(oObject) {
		if (this.getVertical()) {
			return oObject.offsetHeight;
		} else {
			return oObject.offsetWidth;
		}
	};

	/**
	 * Get client width/height
	 *
	 * @returns {int} height or width
	 * @private
	 */
	Slider.prototype.getBarWidth = function() {
		if (this.getVertical()) {
			return this.oBar.clientHeight;
		} else {
			return this.oBar.clientWidth;
		}
	};

	/**
	 * Get offset left/top for specified object. Translates between vertical and horizontal slider
	 *
	 * @param {Element} oObject Dom-Ref
	 * @returns {int} offset
	 * @private
	 */
	Slider.prototype.getOffsetLeft = function(oObject) {
		if (this.getVertical()) {
			return oObject.offsetTop;
		} else {
			return oObject.offsetLeft;
		}
	};

	/**
	 * Get offset for specified event. Translates between vertical and horizontal slider
	 *
	 * @param {jQuery.Event} oEvent The event object
	 * @returns {int} offset
	 * @private
	 */
	Slider.prototype.getOffsetX = function(oEvent) {

		/* eslint-disable no-lonely-if */
		if (this.getVertical()) {
			return oEvent.getOffsetY();
		} else {
			if (this.bRtl) {
				return oEvent.getOffsetX();
			} else {
				return oEvent.getOffsetX();
			}
		}
	};

	/**
	 * convert fNewValue for RTL-Mode
	 *
	 * @param {float} fNewValue input value
	 * @returns {float} output value
	 * @private
	 */
	Slider.prototype.convertRtlValue = function(fNewValue) {
		if (this.bRtl && !this.getVertical()) {
			fNewValue = this.getMax() - fNewValue + this.getMin();
		}
		return fNewValue;
	};

	/**
	 * Check if a specified target is a valid grip
	 *
	 * @param {string} sMyTargetId taget ID
	 * @returns {boolean} flag if target is a valid grip
	 * @private
	 */
	Slider.prototype.targetIsGrip = function(sMyTargetId) {
		if ( sMyTargetId == this.oGrip.id ) {
			return true;
		}
		return false;
	};

	/*
	 * Overrides getFocusDomRef of base element class.
	 * @public
	 */
	Slider.prototype.getFocusDomRef = function() {
		return this.oGrip;
	};

	/*
	 * Overwrites default implementation
	 * the label must point to the grip
	 * @public
	 */
	Slider.prototype.getIdForLabel = function () {
		return this.getId() + '-grip';
	};

	return Slider;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Slider.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Splitter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Splitter.
jQuery.sap.declare('sap.ui.commons.Splitter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.events'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.keycodes'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Splitter",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup', 'sap/ui/core/ResizeHandler', 'sap/ui/core/delegate/ItemNavigation', 'jquery.sap.events', 'jquery.sap.keycodes'],
	function(jQuery, library, Control, Popup, ResizeHandler, ItemNavigation/* , jQuerySap, jQuerySap1 */) {
	"use strict";



	/**
	 * Constructor for a new Splitter.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Allows to split the screen into two areas. Make sure that the container for the splitter has an absolute height or set an absolute height for the splitter using the height property. Otherwise the height of the splitter is calculated by the height of its contents.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Splitter
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Splitter = Control.extend("sap.ui.commons.Splitter", /** @lends sap.ui.commons.Splitter.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * The splitter can have horizontal or vertical orientation.
			 */
			splitterOrientation : {type : "sap.ui.core.Orientation", group : "Behavior", defaultValue : sap.ui.core.Orientation.Vertical},

			/**
			 * Position of splitter bar in percentage.
			 * The default value means that the splitter is positioned in the middle of the area that is available for the splitter.
			 */
			splitterPosition : {type : "sap.ui.core.Percentage", group : "Behavior", defaultValue : '50%'},

			/**
			 * The minimum size (width for vertical splitter or height for horizontal splitter) of the first Pane
			 */
			minSizeFirstPane : {type : "sap.ui.core.Percentage", group : "Behavior", defaultValue : '0%'},

			/**
			 * The minimum size (width for vertical splitter or height for horizontal splitter) of the second Pane
			 */
			minSizeSecondPane : {type : "sap.ui.core.Percentage", group : "Behavior", defaultValue : '0%'},

			/**
			 * The width of the split area in px or in %
			 */
			width : {type : "sap.ui.commons.SplitterSize", group : "Behavior", defaultValue : '100%'},

			/**
			 * The height of the split area in px or in %
			 */
			height : {type : "sap.ui.commons.SplitterSize", group : "Behavior", defaultValue : '100%'},

			/**
			 * Specifies if the browser should display scroll bars or simply cut the content of a splitter pane when the content does not fit into its pane.
			 */
			showScrollBars : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * set the splitter bar to be visible or not.
			 */
			splitterBarVisible : {type : "boolean", group : "Behavior", defaultValue : true}
		},
		aggregations : {

			/**
			 * Controls inside the first pane. These are the left ones in case of defining a vertical splitter, and the top ones in case of using the horizontal splitter.
			 */
			firstPaneContent : {type : "sap.ui.core.Control", multiple : true, singularName : "firstPaneContent"},

			/**
			 * Controls inside the second pane. These are the right ones in case of defining a vertical splitter, and the bottom ones in case of using the horizontal splitter.
			 */
			secondPaneContent : {type : "sap.ui.core.Control", multiple : true, singularName : "secondPaneContent"}
		}
	}});



	Splitter.prototype.onBeforeRendering = function() {
		// cleanup resize event registration before re-rendering
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
		if (this.sSpecialResizeListenerId) {
			ResizeHandler.deregister(this.sSpecialResizeListenerId);
			this.sSpecialResizeListenerId = null;
		}
	};

	Splitter.prototype.onAfterRendering = function() {
		this._recalculateInternals();
		this.sResizeListenerId = ResizeHandler.register(this.splitterDIV, jQuery.proxy(this.onresize, this));
	};


	Splitter.prototype._recalculateInternals = function() {

		this.splitterDIV = this.getDomRef();
		this.splitterBar = jQuery.sap.domById(this.getId() + '_SB');
		this.firstPane = jQuery.sap.domById(this.getId() + '_firstPane');
		this.secondPane = jQuery.sap.domById(this.getId() + '_secondPane');

		this.minSizeFP = this.getMinSizeFirstPane();
		this.minSizeSP = this.getMinSizeSecondPane();

		this.minSizeFP = this.minSizeFP.substring(0, (this.minSizeFP).length - 1);
		this.minSizeFP = parseFloat(this.minSizeFP);

		this.minSizeSP = this.minSizeSP.substring(0, (this.minSizeSP).length - 1);
		this.minSizeSP = parseFloat(this.minSizeSP);

		this.spOrientation =  this.getSplitterOrientation();

		this.sBarPosition = this.getSplitterPosition();
		this.sBarPosition = this.sBarPosition.substring(0, this.sBarPosition.length - 1);
		this.sBarPosition = parseFloat(this.sBarPosition);

		// in hcb mode set splitter bar width to 6 px
		if (sap.ui.getCore().getConfiguration().getTheme() == "sap_hcb") {
			this.sbSize = 6;
		} else {
			this.sbSize = 4;
		}
		this.resizeSplitterElements();

		// if no splitter parent height is specified and the splitter height is specified in % the splitter won't be displayed
		// and the splitterbar height will be
		// FF: 0 in vertical and horizontal splitters
		// or in IE: >= the div height (vertical) or  != sbSize (horizontal)
		// if any above is the case we have to set its height to a fixed pixel value
		var splitterBarHeight = jQuery(this.splitterBar).height();
		if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
			if (splitterBarHeight <= 0 || splitterBarHeight > jQuery(this.splitterDIV).height()) {
				this.fixHeight();
			}
		} else {
			if (splitterBarHeight <= 0 || splitterBarHeight != this.sbSize) {
				this.fixHeight();
			}
		}

	};


	Splitter.prototype.onresize = function(oEvent) {

		this.resizeSplitterElements();

	};

	Splitter.prototype.resizeSplitterElements = function() {

		var sbW, sbH, width, height, widthSP, heightSP;

		/**
		 * Calculate the equivalent percentage of the 4px : the width/height of the splitter bar
		 */

		if (this.spOrientation == sap.ui.core.Orientation.Vertical) {

			width = jQuery(this.splitterDIV).width();
			if (width == 0) {
				width = 100; //px so it would show something at least
			}
			sbW = (this.sbSize * 100) / width;

			// check if bar is in the far right
			if (this.sBarPosition >= 100 || this.sBarPosition + sbW > 100) {
				this.sBarPosition = 100 - sbW;
				widthSP = 0;
			} else {
				widthSP = 100 - sbW - this.sBarPosition;
			}
			jQuery(this.firstPane).css("width", this.sBarPosition + "%");
			jQuery(this.splitterBar).css("width", sbW + "%");
			jQuery(this.secondPane).css("width", widthSP + "%");

		} else {

			height = jQuery(this.splitterDIV).height();
			if (height == 0 ) {
				height = 100; //px so it would show something at least
			}
			sbH = (this.sbSize * 100) / height;

			// check if bar is in the far bottom
			if (this.sBarPosition >= 100 || this.sBarPosition + sbH > 100) {
				this.sBarPosition = 100 - sbH;
				heightSP = 0;
			} else {
				heightSP = 100 - sbH - this.sBarPosition;
			}
			jQuery(this.firstPane).css("height", this.sBarPosition + "%");
			jQuery(this.splitterBar).css("height", sbH + "%");
			jQuery(this.secondPane).css("height", heightSP + "%");

		}

		// update splitterpos value...suppress rerendering
		this.setProperty("splitterPosition", this.sBarPosition + "%", true);

		// fix height if splitterdiv height is 0 we set it to 100 px to show something at least
		// further resizing should then work correctly
		if (jQuery(this.splitterDIV).height() == 0 && !this.splitterDIV.style.height) {
			jQuery(this.splitterDIV).css("height", "100px");
			jQuery(this.splitterBar).css("height", "100px");
		}

	};

	Splitter.prototype.setSplitterPosition = function(sPos){
		if (this.getDomRef()) {
			this.setProperty("splitterPosition", sPos, true);
			this._recalculateInternals();
		} else {
			this.setProperty("splitterPosition", sPos);
		}
	};

	Splitter.prototype.setSplitterBarVisible = function(bVisible){
		if (this.getDomRef()) {
			this.setProperty("splitterBarVisible", bVisible, true);
			var sClassPrefix = this.getSplitterOrientation() === sap.ui.core.Orientation.Vertical ? "sapUiVertical" : "sapUiHorizontal";
			if (bVisible) {
				jQuery.sap.byId(this.getId() + "_SB").removeClass(sClassPrefix + "SplitterBarHidden").addClass(sClassPrefix + "SplitterBar");
			} else {
				jQuery.sap.byId(this.getId() + "_SB").removeClass(sClassPrefix + "SplitterBar").addClass(sClassPrefix + "SplitterBarHidden");
			}
		} else {
			this.setProperty("splitterBarVisible", bVisible);
		}
	};


	/**
	 * set height to a fixed height if there is no absolute height specified
	 */
	Splitter.prototype.fixHeight = function() {
		// check the parentNode height
		var parentHeight = jQuery(this.splitterDIV.parentNode).height();
		var splitterHeight = jQuery(this.splitterDIV).height();
		if (parentHeight > splitterHeight) {

			splitterHeight = parentHeight;

			// check if there was a custom max height set...then we use it regardless
			// of container height but only for px values
			var customMaxHeight = this.getHeight();
			if (customMaxHeight && customMaxHeight.toLowerCase().indexOf("px") != -1) {
				splitterHeight = parseInt(customMaxHeight, 10);
			}
			// for % values we use the splitter div height if the % is < 100% else
			// we leave the size as the parent height
			if (customMaxHeight && customMaxHeight.toLowerCase().indexOf("%") != -1) {
				var percentValue = parseInt(customMaxHeight, 10);
				if (percentValue < 100) {
					splitterHeight = jQuery(this.splitterDIV).height();
				}
			}

			// if splitterheight is 0 which shouldn't be the case we set the parent height again.
			if (splitterHeight <= 0) {
				splitterHeight = parentHeight;
			}
		}

		// reset the splitter div height so that its contents fit inside...
		jQuery(this.splitterDIV).css("height", splitterHeight + "px");
		if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
			jQuery(this.splitterBar).css("height", splitterHeight + "px");
		}
		var oParent = this.splitterDIV.parentNode;
		if (oParent) {
			var fHandler = jQuery.proxy(this.onresizespecial, this);
			this.sSpecialResizeListenerId = ResizeHandler.register(oParent, fHandler);
			//fHandler({target: oParent});
		}
	};

	/**
	 *	cleanup resize event registration before re-rendering
	 */
	Splitter.prototype.exit = function() {
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
		if (this.sSpecialResizeListenerId) {
			ResizeHandler.deregister(this.sSpecialResizeListenerId);
			this.sSpecialResizeListenerId = null;
		}
	};


	/**
	 * resize event handler to handle the special case when no splitter parent height is specified and the splitter height is specified in %.
	 * Then the splitter won't be displayed. In this case when the parent gets resized, get the parents height and use it to adapt the current fixed splitter height in px
	 * so that everything stays in place.
	 */
	Splitter.prototype.onresizespecial = function(oEvent) {
		var $Splitter = jQuery(this.splitterDIV);
		var oldHeight = $Splitter.height();
		$Splitter.css("height", "0px");
		var oDom = this.getDomRef();
		if (oDom && window.getComputedStyle) {
			// force browser to apply CSS so that the height is 0 and can then be calculated from new
			window.getComputedStyle(oDom);
		}

		// perhaps this is event handler is not needed. depends on if current child elements should be resized or not
		var parentHeight = jQuery(oEvent.target).height();
		var currentHeight = $Splitter.height();
		if (currentHeight != parentHeight) {
			// set bar height to the splitterDIV height value
			$Splitter.css("height", parentHeight + "px");
			if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
				jQuery(this.splitterBar).css("height", parentHeight + "px");
			}
		}
		// if there is no parent height set the old height again. This might be the case if the parent doesn't have a height yet...
		if (parentHeight <= 0) {
			$Splitter.css("height", oldHeight + "px");
			if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
				jQuery(this.splitterBar).css("height", oldHeight + "px");
			}
		}
	};

	/**
	 * mousedown event handler: create a ghost bar for the splitter bar and starts dragging it
	 */
	Splitter.prototype.onmousedown = function(oEvent) {

		if (oEvent.target != this.splitterBar) {
			return;
		}

		var oJBody = jQuery(document.body);
			// Fix for IE text selection while dragging
		oJBody.bind("selectstart",jQuery.proxy(this.splitterSelectStart,this));

		var offset = jQuery(this.splitterBar).offset();
		var height = jQuery(this.splitterBar).height();
		var width = jQuery(this.splitterBar).width();
		var cssClass;

		if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
			cssClass = "sapUiVSBGhost";
		} else {
			cssClass = "sapUiHSBGhost";
		}

		var iZIndex = Popup.getLastZIndex() + 5;
		if (iZIndex < 20) {
			iZIndex = 20;
		}

		jQuery(document.body).append(
				"<div id=\"" + this.getId() + "_ghost\" class=\"" + cssClass + "\" style =\" height:" + height + "px; width:"
				+ width + "px; left:" + offset.left + "px; top:" + offset.top + "px;z-index:" + iZIndex + "\"></div>");

		// append overlay over splitter to enable correct functionality of moving the splitter
		jQuery(document.body).append(
				"<div id=\"" + this.getId() + "_overlay\" style =\"left: 0px;" +
						" right: 0px; bottom: 0px; top: 0px; position:fixed; z-index:" + iZIndex + "\" ></div>");

		jQuery(document).bind("mouseup", jQuery.proxy(this.onGhostMouseRelease, this));
		jQuery(document).bind("mousemove", jQuery.proxy(this.onGhostMouseMove, this));

		// focus splitter bar
		jQuery(this.splitterBar).focus();

		// cancel the event
		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	/**
	 * The selectstart event triggered in IE to select the text.
	 * @private
	 * @param {event} oEvent The splitterselectstart event
	 * @return {boolean} false
	 */
	Splitter.prototype.splitterSelectStart = function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
		return false;
	};

	/**
	 * drops the splitter bar
	 */

	Splitter.prototype.onGhostMouseRelease = function(oEvent) {

		var newSbPosition, spHeight, spWidth;
		var splitterBarGhost = jQuery.sap.domById(this.getId() + "_ghost");
		var rtl = sap.ui.getCore().getConfiguration().getRTL();

		if ( this.spOrientation == sap.ui.core.Orientation.Vertical) {

			if (!rtl) {
				newSbPosition = oEvent.pageX - jQuery(this.firstPane).offset().left;
				spWidth = jQuery(this.splitterDIV).width();
				newSbPosition = (newSbPosition * 100) / spWidth;
			} else {
				newSbPosition = oEvent.pageX - jQuery(this.secondPane).offset().left;
				spWidth = jQuery(this.splitterDIV).width();
				newSbPosition = (( spWidth - newSbPosition ) * 100) / spWidth;
			}
		} else {
			newSbPosition = oEvent.pageY - jQuery(this.firstPane).offset().top;
			spHeight = jQuery(this.splitterDIV).height();
			newSbPosition = (newSbPosition * 100) / spHeight;
		}

		if (newSbPosition < this.minSizeFP) {
			newSbPosition = this.minSizeFP;
		} else if ((100 - newSbPosition) < this.minSizeSP) {
			newSbPosition = 100 - this.minSizeSP;
		}

		this.sBarPosition =  newSbPosition;

		this.resizeSplitterElements();

		jQuery(splitterBarGhost).remove();
		jQuery.sap.byId(this.getId() + "_overlay").remove();

		var oJBody = jQuery(document.body);
		oJBody.unbind("selectstart", this.splitterSelectStart);

		jQuery(document).unbind("mouseup", this.onGhostMouseRelease);
		jQuery(document).unbind("mousemove", this.onGhostMouseMove);

	};

	Splitter.prototype.onGhostMouseMove = function(oEvent) {

		var splitterBarGhost = jQuery.sap.domById(this.getId() + "_ghost");
		var max;
		var min;
		var rtl = sap.ui.getCore().getConfiguration().getRTL();

		var leftFirstPane = jQuery(this.firstPane).offset().left;
		var w = jQuery(this.splitterDIV).width();
		var leftSecondPane = jQuery(this.secondPane).offset().left;

		if (this.getSplitterOrientation() == sap.ui.core.Orientation.Vertical) {

			if (!rtl) {

				min = leftFirstPane + (w * this.minSizeFP) / 100;
				max = leftFirstPane + (w * (100 - this.minSizeSP)) / 100;

				if (oEvent.pageX > min && oEvent.pageX < max) {
					jQuery(splitterBarGhost).css("left", oEvent.pageX + "px");
				}
			} else {


				min = leftSecondPane + (w * this.minSizeSP) / 100;
				max = leftSecondPane + (w * (100 - this.minSizeFP)) / 100;

				if (oEvent.pageX > min && oEvent.pageX < max) {
					jQuery(splitterBarGhost).css("left", oEvent.pageX + "px");
				}


			}

		} else {

			var h = jQuery(this.splitterDIV).height();

			min = jQuery(this.firstPane).offset().top + (h * this.minSizeFP) / 100;
			max = jQuery(this.secondPane).offset().top + jQuery(this.secondPane).height() - (h * this.minSizeSP) / 100;
			if (oEvent.pageY > min && oEvent.pageY < max) {
				jQuery(splitterBarGhost).css("top", oEvent.pageY + "px");
			}
		}
	};

	/**
	 * Convenience method for handling of Ctrl key, meta key etc.
	 *
	 * @private
	 */
	Splitter.prototype.getCtrlKey = function(oEvent) {
		return !!(oEvent.ctrlKey || oEvent.metaKey); // double negation doesn't have effect on boolean but ensures null and undefined are equivalent to false.
	};

	/**
	 * Convenience method to check an event for a certain combination of modifier keys
	 *
	 * @private
	 */
	Splitter.prototype.checkModifierKey = function(oEvent, bCtrlKey, bAltKey, bShiftKey) {
		return oEvent.shiftKey == bShiftKey && oEvent.altKey == bAltKey && this.getCtrlKey(oEvent) == bCtrlKey;
	};

	/**
	 * Home key minimizes the first pane to the last possible position
	 */
	Splitter.prototype.onsaphome = function(oEvent) {
		if (oEvent.target == this.splitterBar) {
			this.sBarPosition = this.minSizeFP;
			this.resizeSplitterElements();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * End key maximizes the first pane to the last possible position
	 */
	Splitter.prototype.onsapend = function(oEvent) {
		if (oEvent.target == this.splitterBar) {
			this.sBarPosition = 100 - this.minSizeSP;
			this.resizeSplitterElements();
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	Splitter.prototype.onArrowKeys = function(oEvent,oInc) {
		var width, height, sbSize, sbPosition, newSbPosition;

		if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
			width = jQuery(this.splitterDIV).width();
			sbPosition = jQuery(this.firstPane).width();
			sbPosition = (sbPosition * 100) / width;
			// move 10 pixels
			sbSize = (10 * 100) / width;
		} else {
			height = jQuery(this.splitterDIV).height();
			sbPosition = jQuery(this.firstPane).height();
			sbPosition = (sbPosition * 100) / height;
			// move 10 pixels
			sbSize = (10 * 100) / height;
		}

		if (oInc == "false") {
			newSbPosition = sbPosition - sbSize;
		} else if (oInc == "true") {
			newSbPosition = sbPosition + sbSize;
		}

		if (newSbPosition < this.minSizeFP)	{
			newSbPosition = this.minSizeFP;
		} else if ((100 - newSbPosition) < this.minSizeSP) {
			newSbPosition = 100 - this.minSizeSP;
		}

		this.sBarPosition = newSbPosition;
		this.resizeSplitterElements();
	};

	/**
	 * If the Shift and Up keys are pressed and if the focus is the onsplitterBar moves the horizontal sash bar up by one step
	 * and the vertical sash bar left one step
	 */
	Splitter.prototype.onsapupmodifiers = function(oEvent) {
		if (this.checkModifierKey(oEvent, false, false, true)) {
			if (oEvent.target == this.splitterBar) {

				if (this.spOrientation == sap.ui.core.Orientation.Horizontal) {
					this.onArrowKeys(oEvent,"false");
				} else {
					// move vertical splitter left
					this.onsapleftmodifiers(oEvent);
				}

			}
			// cancel the event
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};


	/**
	 * If the Shift and Up keys are pressed and if the focus is on the splitterBar moves the horizontal sash bar down by one step
	 * and the vertical sash bar right one step
	 */
	Splitter.prototype.onsapdownmodifiers = function(oEvent) {
		if (this.checkModifierKey(oEvent, false, false, true)) {
			if (oEvent.target == this.splitterBar) {
				if (this.spOrientation == sap.ui.core.Orientation.Horizontal) {
					this.onArrowKeys(oEvent,"true");
				} else {
					// move vertical splitter right
					this.onsaprightmodifiers(oEvent);
				}
			}
			// cancel the event
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * If the Shift and Left keys are pressed and if the focus is on splitterBar moves the vertical sash bar left by one step or
	 * the horizontal sash bar up one step
	 */
	Splitter.prototype.onsapleftmodifiers = function(oEvent) {
		if (this.checkModifierKey(oEvent, false, false, true)) {
			if (oEvent.target == this.splitterBar) {
				if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
					var rtl = sap.ui.getCore().getConfiguration().getRTL();
					if (rtl) {
						this.onArrowKeys(oEvent,"true");
					} else {
						this.onArrowKeys(oEvent,"false");
					}
				} else {
					// move horizontal splitter up
					this.onsapupmodifiers(oEvent);
				}
			}
			// cancel the event
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * If the Shift and Right keys are pressed and if the focus is on the splitterBar moves the vertical sash bar right by one step
	 * and the horizontal sash bar down one step
	 */
	Splitter.prototype.onsaprightmodifiers = function(oEvent) {
		if (this.checkModifierKey(oEvent, false, false, true)) {
			if (oEvent.target == this.splitterBar) {
				if (this.spOrientation == sap.ui.core.Orientation.Vertical) {
					var rtl = sap.ui.getCore().getConfiguration().getRTL();
					if (rtl) {
						this.onArrowKeys(oEvent,"false");
					} else {
						this.onArrowKeys(oEvent,"true");
					}
				} else {
					// move horizontal splitter down
					this.onsapdownmodifiers(oEvent);
				}
			}
			// cancel the event
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * only drag events are fired; mouse events such as mousemove are not fired during drag operation
	 */
	/**
	 * event dragstart fired when the user starts dragging the sash bar
	 */

	Splitter.prototype.ondragstart = function(oEvent) {

		if (oEvent.target != this.splitterBar) {
			return;
		}

		// cancel the event
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};


	Splitter.prototype.getText = function(sKey, aArgs) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");
		if (rb) {
			return rb.getText(sKey, aArgs);
		}
		return sKey;
	};



	return Splitter;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Splitter.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Tab') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Tab.
jQuery.sap.declare('sap.ui.commons.Tab'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Tab",['jquery.sap.global', './Panel', './library'],
	function(jQuery, Panel, library) {
	"use strict";



	/**
	 * Constructor for a new Tab.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A single page in a TabStrip control.
	 * @extends sap.ui.commons.Panel
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.Tab
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Tab = Panel.extend("sap.ui.commons.Tab", /** @lends sap.ui.commons.Tab.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Set the height property.
			 */
			verticalScrolling : {type : "sap.ui.core.Scrolling", group : "Behavior", defaultValue : sap.ui.core.Scrolling.None},

			/**
			 * Set the width property.
			 */
			horizontalScrolling : {type : "sap.ui.core.Scrolling", group : "Behavior", defaultValue : sap.ui.core.Scrolling.None},

			/**
			 * Defines whether the tab contains a close button.
			 */
			closable : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Defines whether the tab is the active one.
			 * @deprecated Since version 0.17.0.
			 * This property is not used. To indentify the selected tab in a TabStrip selectedIndex is used.
			 */
			selected : {type : "boolean", group : "Behavior", defaultValue : false, deprecated: true}
		}
	}});

	/*
	 * Initialize the Tab
	 * @private
	 */
	Tab.prototype.init = function() {
		// Setting this to role Tabpanel instead of its container basically worked.
		// However, the role is set one level higher to get better output in screen reader.

		this.oScrollDomRef = null;      // Points to the content area
	};

	Tab.prototype.rerender = function() {

		// as Tab has no own renderer call renderer of TabStrip
		var oParent = this.getParent();
		if (oParent) {
			oParent.rerender();
		}

	};

	Tab.prototype.invalidate = function() {

		// as Tab has no own renderer call invalidate of TabStrip
		var oParent = this.getParent();
		if (oParent) {
			oParent.invalidate();
		}
	};

	/*
	 * Called after rendering from the TabStrip control
	 */
	Tab.prototype.onAfterRendering = function () {
		this.oScrollDomRef = this.getDomRef("panel");

		// Restore scroll positions
		if (this.oScrollDomRef) {
			var scrollTop = this.getProperty("scrollTop");
			if (scrollTop > 0) {
				this.oScrollDomRef.scrollTop = scrollTop;
			}
			var scrollLeft = this.getProperty("scrollLeft");
			if (scrollLeft > 0) {
				this.oScrollDomRef.scrollLeft = scrollLeft;
			}
		}

		// TODO: this must also be done for tabs where the contents are not rendered initially
	};

	/*
	 * Returns the scroll position of the tab in pixel from the left. Returns "0" if not rendered yet.
	 * Also updates the control property internally.
	 *
	 * @return The scroll position
	 * @public
	 */
	Tab.prototype.getScrollLeft = function () {
		var scrollLeft = 0;
		if (this.oScrollDomRef) {
			scrollLeft = this.oScrollDomRef.scrollLeft;
			this.setProperty("scrollLeft", scrollLeft, true);
		}

		return scrollLeft;
	};

	/*
	 * Sets the scroll position of the tab in pixel from the left.
	 * @param {int} iPosition The position to scroll to
	 * @return {sap.ui.commons.Tab} <code>this</code> to allow method chaining
	 * @public
	 */
	Tab.prototype.setScrollLeft = function (iPosition) {
		this.setProperty("scrollLeft", iPosition, true);
		if (this.oScrollDomRef) {                        // TODO: what if called before rendering?
			this.bIgnoreScrollEvent = true;
			this.oScrollDomRef.scrollLeft = iPosition;
		}
		return this;
	};

	/*
	 * Returns the scroll position of the tab in pixel from the top. Returns "0" if not rendered yet.
	 * Also updates the control property internally.
	 *
	 * @return The scroll position
	 * @public
	 */
	Tab.prototype.getScrollTop = function () {
		var scrollTop = 0;
		if (this.oScrollDomRef) {
			scrollTop = this.oScrollDomRef.scrollTop;
			this.setProperty("scrollTop", scrollTop, true);
		}

		return scrollTop;
	};

	/*
	 * Sets the scroll position of the tab in pixel from the top.
	 * @param {int} iPosition The position to scroll to
	 * @return {sap.ui.commons.Tab} <code>this</code> to allow method chaining
	 * @public
	 */
	Tab.prototype.setScrollTop = function (iPosition) {
		this.setProperty("scrollTop", iPosition, true);
		if (this.oScrollDomRef) {                       // TODO: what if called before rendering?
			this.bIgnoreScrollEvent = true;
			this.oScrollDomRef.scrollTop = iPosition;
		}
		return this;
	};

	/*
	 * Property setter for the "enabled" state (overwrite method from panel)
	 * Normally only classes are exchanged and no rerendering is needed.
	 * But if selected tab should be disabled this needs a rerendering because
	 * the selected tab can not be disabled
	 * If no tab is selected (because all tabs are disabled before) also a
	 * rerendering is needed.
	 *
	 * @param bEnabled whether the tab should be enabled or not
	 * @return {sap.ui.commons.Tab} <code>this</code> to allow method chaining
	 * @public
	 */
	Tab.prototype.setEnabled = function(bEnabled) {

		if (bEnabled == this.getEnabled()) {
			return this;
		}

		var oDomRef = this.getDomRef();
		var oParent = this.getParent();

		if (!oDomRef || (!bEnabled && jQuery(this.getDomRef()).hasClass("sapUiTabSel")) ||
			(bEnabled && oParent && oParent.getSelectedIndex && oParent.getSelectedIndex() < 0)) {
			this.setProperty("enabled", bEnabled, false); // rendering needed

			if (oParent && oParent._getActualSelectedIndex) {
				var iIndex = oParent._getActualSelectedIndex();
				oParent.setProperty('selectedIndex', iIndex, true);
			}
		} else {
			this.setProperty("enabled", bEnabled, true); // no re-rendering!
			// if already rendered, adapt rendered control without complete re-rendering
			jQuery(this.getDomRef()).toggleClass("sapUiTab", bEnabled).toggleClass("sapUiTabDsbl", !bEnabled).attr("aria-disabled",!bEnabled);
		}
		return this;

	};

	/*
	 * Setter of the width property. As it has no effect on a tab and is
	 * only inherited from panel, noting to do. Just overwrite panel implementation
	 *
	 * @param {string} sWidth the width of the panel as CSS size
	 * @return {sap.ui.commons.Tab} <code>this</code> to allow method chaining
	 * @public
	 */
	Tab.prototype.setWidth = function (sWidth) {
		this.setProperty("width", sWidth, true); // don't rerender
		// do nothing
		return this;
	};

	/*
	 * Property setter for the padding.As it has no effect on a tab and is
	 * only inherited from panel, noting to do. Just overwrite panel implementation
	 *
	 * @param bPadding whether the Panel should have padding
	 * @returns {sap.ui.commons.Tab} <code>this</code> to allow method chaining
	 * @public
	 */
	Tab.prototype.setApplyContentPadding = function(bPadding) {
		this.setProperty("applyContentPadding", bPadding, true); // no re-rendering!
		// do nothing
		return this;
	};

	Tab.prototype._handleTrigger = function(oEvent) {
		//see sap.ui.commons.Panel.prototype._handleTrigger -> Nothing to do here
	};

	return Tab;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Tab.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TabStrip') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.TabStrip.
jQuery.sap.declare('sap.ui.commons.TabStrip'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TabStrip",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation'],
	function(jQuery, library, Control, ItemNavigation) {
	"use strict";



	/**
	 * Constructor for a new TabStrip.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 *
	 * A container for tab controls which contain the content and generally other controls. The user switches between the tabs then to display the content.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.TabStrip
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var TabStrip = Control.extend("sap.ui.commons.TabStrip", /** @lends sap.ui.commons.TabStrip.prototype */ { metadata : {

		library : "sap.ui.commons",
		properties : {

			/**
			 * Height includes tab bar and content area.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * Width includes tab bar and content area.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * Index of the currently selected tab.
			 */
			selectedIndex : {type : "int", group : "Misc", defaultValue : 0}
		},
		defaultAggregation : "tabs",
		aggregations : {

			/**
			 * Aggregating tabs contained in the tab strip.
			 */
			tabs : {type : "sap.ui.commons.Tab", multiple : true, singularName : "tab"}
		},
		events : {

			/**
			 * Event is fired when the user selects a tab.
			 */
			select : {
				parameters : {

					/**
					 * Index of the selected tab.
					 */
					index : {type : "int"}
				}
			},

			/**
			 * Event is fired when the user closes a tab.
			 */
			close : {
				parameters : {

					/**
					 * Index of the closed tab.
					 */
					index : {type : "int"}
				}
			}
		}
	}});








	TabStrip.prototype.init = function() {
		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};

	TabStrip.prototype.onAfterRendering = function() {
		// find a collection of all tabs
		var oFocusRef = this.getFocusDomRef(),
			aTabs = oFocusRef.lastChild.childNodes,
			aTabDomRefs = [],
			iSelectedDomIndex = -1;
		for (var i = 0;i < aTabs.length;i++) {
			aTabDomRefs.push(aTabs[i]);
			if (jQuery(aTabs[i]).hasClass("sapUiTabSel")) {
				// get selected index out of visible tabs for ItemNavigation
				iSelectedDomIndex = i;
			}
		}
		//Initialize the ItemNavigation
		if (!this.oItemNavigation) {
			this.oItemNavigation = new ItemNavigation();
			this.addDelegate(this.oItemNavigation);
		}
		//Reinitialize the ItemNavigation after rendering
		this.oItemNavigation.setRootDomRef(oFocusRef);
		this.oItemNavigation.setItemDomRefs(aTabDomRefs);
		this.oItemNavigation.setSelectedIndex(iSelectedDomIndex);

		//Notify the tabs
		var aTabs = this.getTabs();
		for (var i = 0;i < aTabs.length;i++) {
			aTabs[i].onAfterRendering();
		}
	};

	/**
	 * Convenient method to add a tab with a text as title and a root control as content.
	 *
	 * @param {string} sText
	 *         Defines the title text of the newly created tab.
	 * @param {sap.ui.core.Control} oContent
	 *         Defines the root control of the content area.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TabStrip.prototype.createTab = function(sText,oContent) {
		var oTabs = this.getTabs(),
			oTitle = new sap.ui.core.Title(this.getId() + "-" + oTabs.length + "-title",{text:sText}),
			oTab = new sap.ui.commons.Tab(this.getId() + "-" + oTabs.length);
		oTab.setTitle(oTitle);
		oTab.addContent(oContent);
		this.addTab(oTab);
		return oTab;
	};

	/*
	 * Finds and fires the select event of a tab of a given Dom Reference
	 * if it is a Dom ref of a tab title.
	 * @private
	 */
	TabStrip.prototype.selectTabByDomRef = function(oDomRef) {
		var iIdx = this.getItemIndex(oDomRef);
		if (iIdx > -1) {
			//its an item, find the items index
			if ((iIdx != this.getSelectedIndex()) && (this.getTabs()[iIdx].getEnabled())) {
				var iOldIndex = this.getSelectedIndex();
				this.setProperty( 'selectedIndex', iIdx, true ); // no complete rerendering required

				this.rerenderPanel(iOldIndex);

				this.oItemNavigation.setSelectedIndex(this.oItemNavigation.getFocusedIndex());

				this.fireSelect({index:iIdx});
			}
		}
	};

	/*
	 * Handles the SPACEBAR press
	 * @private
	 */
	TabStrip.prototype.onsapspace = function(oEvent) {
		var oSource = oEvent.target;
		this.selectTabByDomRef(oSource);
	};

	// ENTER and SPACE with modifiers is the same like SPACE
	TabStrip.prototype.onsapspacemodifiers = TabStrip.prototype.onsapspace;
	TabStrip.prototype.onsapenter = TabStrip.prototype.onsapspace;
	TabStrip.prototype.onsapentermodifiers = TabStrip.prototype.onsapspace;

	/*
	 * Handles the DELETE press
	 * @private
	 */
	TabStrip.prototype.onsapdelete = function(oEvent) {

		var oSource = oEvent.target;
		var iIdx = this.getItemIndex(oSource);
		if (iIdx > -1 && this.getTabs()[iIdx].getClosable()) {
			//item is closable
			this.fireClose({index:iIdx});
		}

	};

	/*
	 * Handles the mouse down event.
	 * @private
	 */
	TabStrip.prototype.onmousedown = function(oEvent) {
		var oSource = oEvent.target;
		if (oSource.className == "sapUiTabClose") {
			oEvent.preventDefault();
			oEvent.stopPropagation();

			// clear the target so the the
			// ItemNavigation won't set the focus on this tab.
			oEvent.target = null;

			return;
		}
		this.selectTabByDomRef(oSource);
	};

	/*
	 * Handles the click event.
	 * @private
	 */
	TabStrip.prototype.onclick = function(oEvent) {
		var oSource = oEvent.target;
		if (oSource.className == "sapUiTabClose") {
			//find the items index
			var iIdx = this.getItemIndex(jQuery(oSource).parentByAttribute("id"));
			if (iIdx > -1) {
				this.fireClose({index:iIdx});
			}
		}
	};

	/*
	 * Overrides getFocusDomRef of base element class.
	 * @public
	 */
	TabStrip.prototype.getFocusDomRef = function() {
		return this.getDomRef().firstChild;
	};

	/*
	 * Does all the cleanup when the TabStrip is to be destroyed.
	 * Called from Element's destroy() method.
	 * @private
	 */
	TabStrip.prototype.exit = function (){
		if (this.oItemNavigation) {
			this.removeDelegate(this.oItemNavigation);
			this.oItemNavigation.destroy();
			delete this.oItemNavigation;
		}

		// no super.exit() to call
	};

	TabStrip.prototype.getItemIndex = function(oDomRef) {

		var sId;
		if (!oDomRef.id || oDomRef.id.search("-close") != -1) {
			// icon or close button
			var oItemDomRef = jQuery(oDomRef).parentByAttribute("id");
			sId = oItemDomRef.id;
		} else {
			sId = oDomRef.id;
		}

		for (var idx = 0, aTabs = this.getTabs(); idx < aTabs.length; idx++) {
			if (sId == aTabs[idx].getId()) {
				return idx;
			}
		}
		return -1;
	};

	// Override aggregation methods if something needs to be taken care of

	/*
	 * Overwrite of default method
	 * Removes an tab from the aggregation named <code>tabs</code>.
	 *
	 * @param {int | string | sap.ui.commons.Tab} vTab the tab to remove or its index or id
	 * @return {sap.ui.commons.Tab} the removed tab or null
	 * @public
	 */
	TabStrip.prototype.removeTab = function(vElement) {
		var iIndex = vElement;
		if (typeof (vElement) == "string") { // ID of the element is given
			vElement = sap.ui.getCore().byId(vElement);
		}
		if (typeof (vElement) == "object") { // the element itself is given or has just been retrieved
			iIndex = this.indexOfTab(vElement);
		}

		var oTab = this.getTabs()[iIndex];
		if (oTab.getVisible()) {
			// set tab invisible during hiding it for changing classes of tabs
			oTab.setProperty("visible",false,true); // no rerendering
			this.hideTab(iIndex);
			oTab.setProperty("visible",true,true); // no rerendering
		}

		if (this.getSelectedIndex() > iIndex) {
			this.setProperty( 'selectedIndex', this.getSelectedIndex() - 1, true ); // no complete rerendering required
		}
		return this.removeAggregation("tabs", iIndex, true); // no complete rerendering required
	};

	/*
	 * Overwite of defaultSetter for property <code>selectedIndex</code>.
	 *
	 * Default value is <code>0</code>
	 *
	 * @param {int} iSelectedIndex new value for property <code>selectedIndex</code>
	 * @return {sap.ui.commons.TabStrip} <code>this</code> to allow method chaining
	 * @public
	 */
	TabStrip.prototype.setSelectedIndex = function(iSelectedIndex) {

		var iOldIndex = this.getSelectedIndex();

		if (iSelectedIndex == iOldIndex) {
			return this;
		}

		var aTabs = this.getTabs();
		var oTab = aTabs[iSelectedIndex];

		if (!oTab && !this.getDomRef()) {
			// tab don't exist but not rendered. In initial setup index might be set before tab is added
			// But if already rendered this is not allowed, tab must exist
			this.setProperty( 'selectedIndex', iSelectedIndex, false ); // rendering needed

		} else if (oTab && oTab.getEnabled() && oTab.getVisible()) {
			this.setProperty( 'selectedIndex', iSelectedIndex, true ); // no complete rerendering required
			if (this.getDomRef() && !this.invalidated) {
				// already rendered and no re-rendering outstanding
				this.rerenderPanel(iOldIndex);
				if (this.oItemNavigation) {
					// set selected index for ItemNavigation, ignore invisible tabs.
					var iVisibleIndex = 0;
					var iSelectedDomIndex = -1;
					for (var i = 0;i < aTabs.length;i++) {
						oTab = aTabs[i];
						if (oTab.getVisible() === false) {
							continue;
						}
						if (i == iSelectedIndex) {
							iSelectedDomIndex = iVisibleIndex;
							break;
						}
						iVisibleIndex++;
					}
					this.oItemNavigation.setSelectedIndex(iSelectedDomIndex);
				}
			}
		} else {
			this._warningInvalidSelectedIndex(iSelectedIndex, oTab);
		}

		return this;
	};

	/**
	 * Close a tab. If the tab is selected, the next one will be selected. (If it's the last the previous one will be selected).
	 *
	 * This method should be called if the close event is fired. It can not be called automatically because the consumer might need to run some logic before the tab is closed.
	 *
	 * @param {int} iIndex
	 *         Index of the tab that should be closed.
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TabStrip.prototype.closeTab = function(iIndex) {

		var oTab = this.getTabs()[iIndex];

		if (!oTab || !oTab.getClosable() || !oTab.getVisible()) {
			return;
		}

		// close tab -> set to invisible
		oTab.setProperty("visible",false,true); // no rerendering

		this.hideTab(iIndex);
	};

	/*
	 * removes a tab from output
	 *
	 * @param {int} iIndex tab to be closed
	 * @private
	 */
	TabStrip.prototype.hideTab = function(iIndex) {
		var oTab = this.getTabs()[iIndex];

		if (!this.getDomRef()) {
			return; //if not already rendered selected index should be provided by caller
		}

		// get focused index and visible index of tab
		var iFocusedIndex = this.oItemNavigation.getFocusedIndex();
		var iVisibleIndex = parseInt(oTab.$().attr("aria-posinset"), 10) - 1;
		var sFocusedControlId = sap.ui.getCore().getCurrentFocusedControlId();

		// delete only tab from DOM ->no rerendering of other tabs necessary
		oTab.$().remove();

		if (this.iVisibleTabs == 1) {
			// last visible tab is closed -> no new selected tab and no content
			this.setProperty( 'selectedIndex', -1, true ); // no complete rerendering required
			oTab.$("panel").remove();
		} else if (iIndex == this.getSelectedIndex()) {
			// selected tab should be closed -> select other one

			var iNewIndex = iIndex + 1;

			while (iNewIndex < this.getTabs().length && (!this.getTabs()[iNewIndex].getEnabled() || !this.getTabs()[iNewIndex].getVisible())) {
				//select next one
				iNewIndex++;
			}

			if (iNewIndex == this.getTabs().length) {
				// no next active tab - search for previous
				iNewIndex = iIndex - 1;
				while (iNewIndex >= 0 && (!this.getTabs()[iNewIndex].getEnabled() || !this.getTabs()[iNewIndex].getVisible())) {
					//select previous one
					iNewIndex--;
				}
			}
			// if no selectable tab exists the index is set to -1
			this.setProperty( 'selectedIndex', iNewIndex, true ); // no complete rerendering required

			this.rerenderPanel(iIndex);
		} else {
			// set classes new to set before and after classes right
			this.toggleTabClasses(this.getSelectedIndex(), this.getSelectedIndex());
		}

		// update ARIA information
		this.iVisibleTabs--;
		var iVisibleIndex = 0;
		var aTabDomRefs = [];
		var iSelectedDomIndex = -1;
		var bTabFocused = false;
		for (var i = 0;i < this.getTabs().length;i++) {
			var oTab = this.getTabs()[i];

			// check if a tab has the focus
			if (sFocusedControlId == oTab.getId()) {
				bTabFocused = true;
			}

			if (oTab.getVisible() === false) {
				continue;
			}
			if (i == this.getSelectedIndex()) {
				iSelectedDomIndex = iVisibleIndex;
			}
			iVisibleIndex++;
			oTab.$().attr("aria-posinset", iVisibleIndex).attr("aria-setsize", this.iVisibleTabs);
			if (iVisibleIndex == this.iVisibleTabs) {
				oTab.$().addClass("sapUiTabLast"); // needed for IE8
			}
			aTabDomRefs.push(oTab.getDomRef());
		}

		// focused item should be the same
		if (iVisibleIndex <= iFocusedIndex) {
			// tab before or equal focused one is hidden
			iFocusedIndex--;
		}
		// update ItemNavigation
		this.oItemNavigation.setItemDomRefs(aTabDomRefs);
		this.oItemNavigation.setSelectedIndex(iSelectedDomIndex);
		this.oItemNavigation.setFocusedIndex(iFocusedIndex);

		// check if a tab has the focus
		// if yes focus again
		// if no set only focused index.
		if (bTabFocused) {
			this.oItemNavigation.focusItem(iFocusedIndex);
		}

	};

	/*
	 * if the selected index is changed, only the panel must be rerendered
	 * for the tabs only some classes must be exchanged
	 *
	 * @private
	 */
	TabStrip.prototype.rerenderPanel = function(iOldIndex) {

		var iNewIndex = this.getSelectedIndex();
		var $panel = this.getTabs()[iOldIndex].$("panel");
		if ($panel.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			this.getRenderer().renderTabContents(rm, this.getTabs()[iNewIndex]);
			rm.flush($panel[0]);
			rm.destroy();
		}

		var sNewId = this.getTabs()[iNewIndex].getId();
		//change the ID and Label of the panel to the current tab
		$panel.attr("id",sNewId + "-panel").attr("aria-labelledby", sNewId);

		// call after rendering method of tab to set scroll functions
		this.getTabs()[iNewIndex].onAfterRendering();

		this.toggleTabClasses(iOldIndex, iNewIndex);
	};

	/*
	 * Sets the classes of the tabs to display the new selection
	 *
	 * @private
	 */
	TabStrip.prototype.toggleTabClasses = function(iOldIndex, iNewIndex) {

		// change visualization of selected tab and old tab
		this.getTabs()[iOldIndex].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",false);
		var iBeforeIndex = iOldIndex - 1;
		while (iBeforeIndex >= 0 && !this.getTabs()[iBeforeIndex].getVisible()) {
			iBeforeIndex--;
		}
		if (iBeforeIndex >= 0) {
			this.getTabs()[iBeforeIndex].$().removeClass("sapUiTabBeforeSel");
		}

		var iAfterIndex = iOldIndex + 1;
		while (iAfterIndex < this.getTabs().length && !this.getTabs()[iAfterIndex].getVisible()) {
			iAfterIndex++;
		}
		if (iAfterIndex < this.getTabs().length) {
			this.getTabs()[iAfterIndex].$().removeClass("sapUiTabAfterSel");
		}

		this.getTabs()[iNewIndex].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",true);
		iBeforeIndex = iNewIndex - 1;
		while (iBeforeIndex >= 0 && !this.getTabs()[iBeforeIndex].getVisible()) {
			iBeforeIndex--;
		}
		if (iBeforeIndex >= 0) {
			this.getTabs()[iBeforeIndex].$().addClass("sapUiTabBeforeSel");
		}

		iAfterIndex = iNewIndex + 1;
		while (iAfterIndex < this.getTabs().length && !this.getTabs()[iAfterIndex].getVisible()) {
			iAfterIndex++;
		}
		if (iAfterIndex < this.getTabs().length) {
			this.getTabs()[iAfterIndex].$().addClass("sapUiTabAfterSel");
		}

	};

	/*
	 * Overwrite Invalidate function to set invalidate flag
	 */
	TabStrip.prototype._originalInvalidate = TabStrip.prototype.invalidate;

	TabStrip.prototype.invalidate = function() {

		this.invalidated = true;
		TabStrip.prototype._originalInvalidate.apply(this,arguments);

	};

	TabStrip.prototype._warningInvalidSelectedIndex = function(iSelectedIndex, oTab){

		var sDetails = "";
		if (!oTab) {
			sDetails = "Tab not exists";
		} else if (!oTab.getEnabled()) {
			sDetails = "Tab disabled";
		} else if (!oTab.getVisible()) {
			sDetails = "Tab not visible";
		}
		jQuery.sap.log.warning("SelectedIndex " + iSelectedIndex + " can not be set", sDetails, "sap.ui.commons.TabStrip");

	};

	TabStrip.prototype._getActualSelectedIndex = function() {

		// check if selected tab exists and is visible and enabled -> otherwise select first active one

		var iSelectedIndex = Math.max(0, this.getSelectedIndex());

		var aTabs = this.getTabs();
		var oSelectedTab = aTabs[iSelectedIndex];
		if (oSelectedTab && oSelectedTab.getVisible() && oSelectedTab.getEnabled()) {
			return iSelectedIndex;
		}

		for (var i = 0; i < aTabs.length; i++) {
			var oTab = aTabs[i];

			if (oTab.getVisible() && oTab.getEnabled()) {
				return i;
			}
		}

		return 0;
	};


	return TabStrip;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TabStrip.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TextAreaRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.TextArea
jQuery.sap.declare('sap.ui.commons.TextAreaRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TextAreaRenderer",['jquery.sap.global', './TextFieldRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, TextFieldRenderer, Renderer) {
	"use strict";


	/**
	 * TextArea renderer.
	 * @namespace
	 */
	var TextAreaRenderer = Renderer.extend(TextFieldRenderer);
	
	/**
	 * Use TextField to render TextArea but change tag to TEXTAREA
	 * @protected
	 */
	TextAreaRenderer.getInnerTagName = function(){
		return ('textarea');
	}
	
	/**
	 * Add attributes, styles and so on to TextField tag
	 */;
	TextAreaRenderer.renderInnerAttributes = function(oRenderManager, oTextArea){
	
		var rm = oRenderManager;
	
		rm.addClass("sapUiTxtA");
	
		rm.addStyle('overflow', 'auto');
	
		/*eslint no-empty:1 */
		//TODO Rethink if empty block is needed
		if (oTextArea.getWidth() && oTextArea.getWidth() != '') {
	//		done in TextField renderer
		} else {
			if (oTextArea.getCols() && oTextArea.getCols() != '') {
				rm.writeAttribute('cols', oTextArea.getCols());
			}
		}
	
		if (oTextArea.getHeight() && oTextArea.getHeight() != '') {
			rm.addStyle('height',oTextArea.getHeight());
			//if a height is set don't use margin-top and margin-button because this would it make higher than wanted
			//this would lead to scrollbars or cut controls in layouts
			rm.addStyle('margin-top','0');
			rm.addStyle('margin-bottom','0');
		} else {
			if (oTextArea.getRows() && oTextArea.getRows() != '') {
				rm.writeAttribute('rows', oTextArea.getRows());
			}
		}
	
		// Changes of the wrap property require re-rendering for browser reasons.
		// Therefore, no dynamic function to change wrapping necessary.
		switch (oTextArea.getWrapping()) {
		case (sap.ui.core.Wrapping.Soft) :
			rm.writeAttribute('wrap', 'soft');
			break;
		case (sap.ui.core.Wrapping.Hard) :
			rm.writeAttribute('wrap', 'hard');
			break;
		case (sap.ui.core.Wrapping.Off) :
			rm.writeAttribute('wrap', 'off');
			break;
		}
	}
	
	/**
	 * Overwrite renderARIAInfo function of TextField
	 */;
	TextAreaRenderer.renderARIAInfo = function(rm, oTextArea) {
	
		rm.writeAccessibilityState(oTextArea, {
			role: oTextArea.getAccessibleRole().toLowerCase() || 'textbox',
			labelledby: oTextArea.getLabeledBy() ? (oTextArea.getLabeledBy() + " " + oTextArea.getAriaDescribedBy().join(" ")) : undefined,
			required: oTextArea.getRequired(),
			readonly: !oTextArea.getEditable(),
			multiline: true,
			autocomplete: "none",
			invalid: oTextArea.getValueState() == sap.ui.core.ValueState.Error});
	
	};
	
	/**
	 * Renders additional HTML for the TextArea to the TextField
	 *
	 * @param {sap.ui.fw.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.fw.Control} oControl An object representation of the control that should be rendered.
	 */
	TextAreaRenderer.renderInnerContent = function(oRenderManager, oTextArea){
		// Convenience variable
		var rm = oRenderManager;
	
		var sValue = oTextArea.getValue();
		var sPlaceholder = oTextArea.getPlaceholder();
	
		if (sValue.length > oTextArea.getMaxLength() && oTextArea.getMaxLength() > 0) {
			sValue = sValue.substring(0,oTextArea.getMaxLength());
		}
	
		if (!sap.ui.Device.support.input.placeholder && sPlaceholder && !sValue) {
			rm.writeEscaped(sPlaceholder);
		} else {
			rm.writeEscaped(sValue);
		}
	};

	return TextAreaRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TextAreaRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TextField') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.TextField.
jQuery.sap.declare('sap.ui.commons.TextField'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TextField",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, library, Control, ValueStateSupport) {
	"use strict";

	/**
	 * Constructor for a new TextField.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Control is used to enter text.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.commons.ToolbarItem
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.TextField
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var TextField = Control.extend("sap.ui.commons.TextField", /** @lends sap.ui.commons.TextField.prototype */ { metadata : {

		interfaces : [
			"sap.ui.commons.ToolbarItem"
		],
		library : "sap.ui.commons",
		properties : {

			/**
			 * Text inside the textfield
			 * @SecSource {return} The 'value' property of the TextField control and its subclasses represents unfiltered user input.
			 * Applications must ensure that the data is either validated / cleansed or that it is not used in a context which is sensible to XSS attacks.
			 */
			value : {type : "string", group : "Data", defaultValue : '', bindable : "bindable"},

			/**
			 * Direction of the text. Possible values: rtl, ltr.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * Switches enabled state of the control. Disabled fields have different colors, and can not be focused.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Switches edit state of the control. Read-only fields have different colors, depending on customer setting.
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Depending on theme the TextField is shown as required.
			 */
			required : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Width of text field. When it is set (CSS-size such as % or px), this is the exact size. When left blank, the text field length defines the width.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * Maximum number of characters. Value '0' means the feature is switched off.
			 */
			maxLength : {type : "int", group : "Behavior", defaultValue : 0},

			/**
			 * Visualizes warnings or errors related to the text field. Possible values: Warning, Error, Success.
			 */
			valueState : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},

			/**
			 * Sets the horizontal alignment of the text.
			 */
			textAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},

			/**
			 * State of the Input Method Editor (IME).
			 */
			imeMode : {type : "sap.ui.core.ImeMode", group : "Behavior", defaultValue : sap.ui.core.ImeMode.Auto},

			/**
			 * Font type. Standard, Monospace
			 */
			design : {type : "sap.ui.core.Design", group : "Appearance", defaultValue : sap.ui.core.Design.Standard},

			/**
			 * Unique identifier used for help service.
			 */
			helpId : {type : "string", group : "Behavior", defaultValue : ''},

			/**
			 * Accessibility role for the text field.
			 */
			accessibleRole : {type : "sap.ui.core.AccessibleRole", group : "Accessibility", defaultValue : sap.ui.core.AccessibleRole.Textbox},

			/**
			 * The 'name' property to be used in the HTML code (e.g. for HTML forms that send data to the server via 'submit').
			 */
			name : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Placeholder for the text field.
			 * @since 1.14.0
			 */
			placeholder : {type : "string", group : "Appearance", defaultValue : null}
		},
		associations : {

			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {

			/**
			 * Event is fired when the text in the field has changed AND the focus leaves the TextField or the Enter key is pressed.
			 */
			change : {
				parameters : {

					/**
					 * The new / changed value of the textfield.
					 */
					newValue : {type : "string"}
				}
			},

			/**
			 * This event if fired during typing into the TextField and returns the currently enterted value. This is not the content of the value property. The value property is only updated by ENTER and by leaving the control.
			 */
			liveChange : {
				parameters : {

					/**
					 * Current value of the Textfield.
					 */
					liveValue : {type : "string"}
				}
			}
		}
	}});

	TextField.prototype.init = function() {

		// currently empty but defined to add on Child controls (ComboBox...)
		// for later use.

	};

	TextField.prototype.onAfterRendering = function() {

		if (sap.ui.Device.browser.internet_explorer) {
			// as IE fires oninput event directly after rendering if value contains special characters (like Ü,Ö,Ä)
			// compare first value in first oninput event with rendered one
			var $input = jQuery(this.getInputDomRef());
			this._sRenderedValue = $input.val();
		}

	};

	/**
	 * Event handler called when control is receiving the focus
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @protected
	 */
	TextField.prototype.onfocusin = function(oEvent) {

		if (this.getEditable() && this.getEnabled() && this.getRenderer().onfocus) {
			this.getRenderer().onfocus(this);
		}

	};

	/**
	 * Event handler called when control is losing the focus
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @protected
	 */
	TextField.prototype.onsapfocusleave = function(oEvent) {

		// restore old value in case of escape key (not possible in onsapescape in firefox)
		// happens e.g. in table because focus is set outside TextField
		this._doOnEscape(oEvent);

		this._checkChange(oEvent);

		if (this.getEditable() && this.getEnabled() && this.getRenderer().onblur) {
			this.getRenderer().onblur(this);
		}

		// if control is left action mode is ended
		var $FocusDomRef = jQuery(this.getFocusDomRef());
		if ($FocusDomRef.data("sap.InNavArea") === false) { // check for false to avoid undefined
			$FocusDomRef.data("sap.InNavArea", true);
		}

	};

	/**
	 * Event handler called when enter key is pressed.
	 * @param {jQuery.Event} oEvent The event object.
	 * @see sap.ui.commons.TextField#onfocusout
	 * @protected
	 */
	TextField.prototype.onsapenter = function(oEvent) {
		this._checkChange(oEvent);
	};

	/**
	 * Compares the previous value with the current value and fires the change event
	 * if the TextField is editable and the value has changed.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @protected
	 */
	TextField.prototype._checkChange = function(oEvent) {
		var oInput = this.getInputDomRef(),
			newVal = oInput && oInput.value,
			oldVal = this.getValue();

		if (this.getEditable() && this.getEnabled() && (oldVal != newVal)) {
			this.setProperty("value", newVal, true); // suppress rerendering
			this.fireChange({newValue:newVal}); // oldValue is not that easy in ComboBox and anyway not in API... thus skip it
		}
	};

	/**
	 * Event handler called when text selection starts.
	 * When the text field is disabled, the text should not be selectable, so cancel the event.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @protected
	 */
	TextField.prototype.onselectstart = function(oEvent) {
		if (!this.getEnabled()) {
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	//******************************************
	//Special handling for TextFields in ItemNavigation

	TextField.prototype._checkCursorPosForNav = function(oEvent, bForward) {
		var bRtl = sap.ui.getCore().getConfiguration().getRTL();
		var bBack = bForward ? bRtl : !bRtl;
		var $input = jQuery(this.getInputDomRef());
		var iPos = $input.cursorPos();
		var iLen = $input.val().length;
		if (bRtl) {
			iPos = iLen - iPos;
		}
		if ((!bBack && iPos != iLen) || (bBack && iPos != 0)) {
			oEvent.stopPropagation();
		}
	};

	TextField.prototype.onsapnext = function(oEvent) {

		if (oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_DOWN) { //Only interested in left / right
			if (jQuery(this.getFocusDomRef()).data("sap.InNavArea") && oEvent.keyCode != jQuery.sap.KeyCodes.END) {
				// parent handles arrow navigation
				oEvent.preventDefault();
				return;
			}

			this._checkCursorPosForNav(oEvent, true);
		}

	};

	TextField.prototype.onsapprevious = function(oEvent) {
		if (oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_UP) { //Only interested in left / right
			if (jQuery(this.getFocusDomRef()).data("sap.InNavArea") && oEvent.keyCode != jQuery.sap.KeyCodes.HOME) {
				// parent handles arrow navigation
				oEvent.preventDefault();
				return;
			}

			this._checkCursorPosForNav(oEvent, false);
		}
	};

	TextField.prototype.onsapnextmodifiers = TextField.prototype.onsapnext;
	TextField.prototype.onsappreviousmodifiers = TextField.prototype.onsapprevious;
	TextField.prototype.onsapend = TextField.prototype.onsapnext;
	TextField.prototype.onsaphome = TextField.prototype.onsapprevious;

	TextField.prototype.onsapexpand = function(oEvent){

		// as Form handles this to expand or collapse containers it must be prevented in TextField
		// to allow usage of numpad + and -
		var bInNavArea = jQuery(this.getFocusDomRef()).data("sap.InNavArea");
		if (bInNavArea || bInNavArea === false) {
			// parent handles arrow navigation
			oEvent.stopPropagation();
			return;
		}

	};

	TextField.prototype.onsapcollapse = TextField.prototype.onsapexpand;

	//******************************************

	/*
	 * Escape fires no keypress in webkit
	 * In Firefox value can not be changed in keydown (onsapescape) event
	 * So the escape event is stored in this._bEsc and the value in this._sValue
	 * Onkeypress and onfocusout the value is reseted. (focusout e.g. needed in table)
	 * the value must be set to the old one before the changes
	 * @protected
	 */
	TextField.prototype.onsapescape = function(oEvent) {

		var sValue = this.getProperty("value");
		this._bEsc = true;
		this._sValue = sValue;

		// as value change is handled in firefox in onkeypress the escape event must be directly stopped here
		var oInput = this.getInputDomRef();
		if (oInput && oInput.value !== sValue && !this._propagateEsc) {
			// if TextField is on a popup, don't close the popup if the value is just reseted
			// in InPlaceEdit propagation is needed
			oEvent.stopPropagation();
		}

		if (!!!sap.ui.Device.browser.firefox) {
			this._doOnEscape(oEvent);
		}

	};

	TextField.prototype.onkeydown = function(oEvent) {

		if (oEvent.which == jQuery.sap.KeyCodes.Z && oEvent.ctrlKey) {
			// prevent browsers standard history logic because different in different browsers
			oEvent.preventDefault();
		}

	};

	/*
	 * Event handler for keypress
	 * in Firefox the escape value must be reseted here
	 * (if on keyup there while pressing the escape key an old value is displayed)
	 * fire the liveChange event
	 * @protected
	 */
	TextField.prototype.onkeypress = function(oEvent) {

		this._doOnEscape(oEvent);

		var iKC = oEvent.which;
		// in FireFox keypress is fired for all keys, in other browsers only for characters. But in IE also for ESC

		if ( iKC > 0 && iKC !== jQuery.sap.KeyCodes.ESCAPE ) {
			// if text is edited -> switch to action mode
			var $FocusDomRef = jQuery(this.getFocusDomRef());
			if ($FocusDomRef.data("sap.InNavArea")) {
				$FocusDomRef.data("sap.InNavArea", false);
			}
		}

	};

	/*
	 * sets the old value after escape
	 * if in edit mode -> switch back to navigation mode
	 * @private
	 */
	TextField.prototype._doOnEscape = function(oEvent) {

		if (this._bEsc) {
			// restore old value in case of escape key (not possible in onsapescape in Firefox)
			// in Edit mode switch back to navigation mode
			var oInput = this.getInputDomRef();
			if (oInput) {
				if (oInput.value !== this._sValue) {
					jQuery(oInput).val(this._sValue);
				}
				var $FocusDomRef = jQuery(this.getFocusDomRef());
				if ($FocusDomRef.data("sap.InNavArea") === false) { // check for false to avoid undefined
					$FocusDomRef.data("sap.InNavArea", true);
				}
			}
			this._fireLiveChange(oEvent);
			this._bEsc = undefined;
			this._sValue = undefined;
		}

	};

	/**
	 * Event handler for keyup.
	 * fire the liveChange event
	 * @param {jQuery.Event} oEvent The event object.
	 * @protected
	 */
	TextField.prototype.onkeyup = function(oEvent) {

		if (oEvent.keyCode == jQuery.sap.KeyCodes.F2) {
			// toggle action mode
			var $FocusDomRef = jQuery(this.getFocusDomRef());
			if ($FocusDomRef.data("sap.InNavArea")) {
				$FocusDomRef.data("sap.InNavArea", false);
			} else if ($FocusDomRef.data("sap.InNavArea") === false) { // check for false to avoid undefined
				$FocusDomRef.data("sap.InNavArea", true);
			}
		} else if ((sap.ui.Device.browser.msie && sap.ui.Device.browser.version < 10) &&
					(oEvent.which === jQuery.sap.KeyCodes.DELETE || oEvent.which === jQuery.sap.KeyCodes.BACKSPACE)) {
			this._fireLiveChange(oEvent);
		}else if ((sap.ui.Device.browser.msie && sap.ui.Device.browser.version < 9) &&
		          (oEvent.keyCode != jQuery.sap.KeyCodes.TAB && oEvent.keyCode != jQuery.sap.KeyCodes.ENTER
		           && oEvent.keyCode != jQuery.sap.KeyCodes.F4)) {
			// as IE8 has no oninput event
			this._fireLiveChange(oEvent);
		}

	};

	TextField.prototype.oninput = function(oEvent) {

		if (!this._realOninput(oEvent)) {
			return;
		}

		this._fireLiveChange(oEvent);

	};

	TextField.prototype._realOninput = function(oEvent) {

		if (sap.ui.Device.browser.internet_explorer) {
			// as IE fires oninput event directly after rendering if value contains special characters (like Ü,Ö,Ä)
			// compare first value in first oninput event with rendered one
			var $input = jQuery(this.getInputDomRef());
			var sRenderedValue = this._sRenderedValue;
			this._sRenderedValue = undefined;
			if (sRenderedValue == $input.val()) {
				return false;
			}
		}

		return true;

	};

	/**
	 * Handler for live change
	 * reads the current content and fires the liveChange event
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	TextField.prototype._fireLiveChange = function(oEvent) {

		if (this.getEnabled() && this.getEditable()) {
			var sLiveValue = jQuery(this.getInputDomRef()).val();
			this.fireLiveChange({liveValue:sLiveValue});
		}

	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the ValueState
	 *
	 * @param {sap.ui.core.ValueState} oValueState
	 * @return {sap.ui.commons.TextField} <code>this</code> to allow method chaining
	 * @public
	 */
	TextField.prototype.setValueState = function(oValueState) {

		var oldValueState = this.getValueState();
		this.setProperty("valueState", oValueState, true); // do not render again
		oValueState = this.getValueState();

		if ( oldValueState == oValueState ) {
			return this;
		}

		if (!this.getDomRef()) {
			//not already rendered.
			return this;
		}

		if (this.getRenderer().setValueState) {
			this.getRenderer().setValueState(this, oldValueState, oValueState);
		}

		if (this.delayedCallId) {
			jQuery.sap.clearDelayedCall(this.delayedCallId);
			this.delayedCallId = null;
		}
		if (sap.ui.core.ValueState.Success == oValueState) {
			this.delayedCallId = jQuery.sap.delayedCall(3000, this, "removeValidVisualization");
		}

		return this;
	};

	TextField.prototype.removeValidVisualization = function() {
		if (this.getRenderer().removeValidVisualization) {
			this.getRenderer().removeValidVisualization(this);
		}
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the editable state
	 *
	 * @param bEditable
	 * @return {sap.ui.commons.TextField} <code>this</code> to allow method chaining
	 * @public
	 */
	TextField.prototype.setEditable = function(bEditable) {

		var bOldEditable = this.getEditable();
		this.setProperty('editable', bEditable, true); // No re-rendering
		bEditable = this.getEditable();

		if (bOldEditable != bEditable) {
			if (this.getDomRef() && this.getRenderer().setEditable) {
				this.getRenderer().setEditable(this, bEditable);
			}
		}

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the enabled state
	 *
	 * @param bEnabled
	 * @return {sap.ui.commons.TextField} <code>this</code> to allow method chaining
	 * @public
	 */
	TextField.prototype.setEnabled = function(bEnabled) {

		var bOldEnabled = this.getEnabled();
		this.setProperty('enabled', bEnabled, true); // No re-rendering
		bEnabled = this.getEnabled();

		if (bOldEnabled != bEnabled) {
			if (this.getDomRef() && this.getRenderer().setEnabled) {
				this.getRenderer().setEnabled(this, bEnabled);
			}
		}

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the Required-State
	 *
	 * @param bRequired:
	 * @return {sap.ui.commons.TextField} <code>this</code> to allow method chaining
	 * @public
	 */
	TextField.prototype.setRequired = function(bRequired) {

		var bOldRequired = this.getRequired();
		this.setProperty('required', bRequired, true); // No re-rendering
		bRequired = this.getRequired();

		if (bOldRequired != bRequired) {
			if (this.getDomRef()) {
				// If already rendered, adapt rendered control without complete re-rendering
				if (this.getRenderer().setRequired) {
					this.getRenderer().setRequired(this, bRequired);
				}
			}

			// fire internal event to inform Label about the change
			this.fireEvent("requiredChanged", {required: bRequired});
		}

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the Design
	 *
	 * @param sDesign:
	 * @return {sap.ui.commons.TextField} <code>this</code> to allow method chaining
	 * @public
	 */
	TextField.prototype.setDesign = function(sDesign) {

		var sOldDesign = this.getDesign();
		this.setProperty('design', sDesign, true); // No re-rendering
		sDesign = this.getDesign();

		if (sOldDesign != sDesign) {
			if (this.getDomRef()) {
				// If already rendered, adapt rendered control without complete re-rendering
				if (this.getRenderer().setDesign) {
					this.getRenderer().setDesign(this, sDesign);
				}
			}
		}

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the Value
	 *
	 * @param sValue:
	 * @return {sap.ui.commons.TextField} <code>this</code> to allow method chaining
	 * @public
	 */
	TextField.prototype.setValue = function(sValue) {
		var newValue = sValue;
		if ( newValue && newValue.length > this.getMaxLength() && this.getMaxLength() > 0) {
			newValue = newValue.substring(0,this.getMaxLength());
		}

		this.setProperty("value", newValue, true); // no re-rendering!
		newValue = this.getValue(); // to use validated value
		var oInput = this.getInputDomRef();
		if (oInput && oInput.value !== newValue) {
			if (!sap.ui.Device.support.input.placeholder) {
				if (newValue) {
					this.$().removeClass('sapUiTfPlace');
					oInput.value = newValue;
				} else if (document.activeElement !== oInput) {
					this.$().addClass('sapUiTfPlace');
					var sPlaceholder = this.getPlaceholder();
					if (this.getRenderer().convertPlaceholder) {
						sPlaceholder = this.getRenderer().convertPlaceholder(this);
					}
					oInput.value = sPlaceholder;
				} else {
					oInput.value = "";
				}
			} else {
				oInput.value =  newValue;
			}
		}

		return this;
	};

	/* Overwrite of generated function - no new JS-doc.
	 * Property setter for the Tooltip
	 *
	 * @param oTooltip:
	 * @return {sap.ui.commons.TextField} <code>this</code> to allow method chaining
	 * @public
	 */
	TextField.prototype.setTooltip = function(oTooltip) {
		this._refreshTooltipBaseDelegate(oTooltip);
		this.setAggregation("tooltip", oTooltip, true);
		var oInputDomRef = this.getInputDomRef();

		if (oInputDomRef) {
			var sTooltip = ValueStateSupport.enrichTooltip(this, this.getTooltip_AsString());
			jQuery(oInputDomRef).attr("title", sTooltip || "");

			if (this._getRenderOuter()) {
				// if InputDomRef exits DomRef must exist too
				jQuery(this.getDomRef()).attr("title", sTooltip || "");
			}
		}

		return this;
	};

	/**
	 * Method for accessing the DOM Ref of the input element.
	 * @return {object} DOM reference or null
	 * @protected
	 */
	TextField.prototype.getInputDomRef = function(){

		if (!this._getRenderOuter()) {
			return this.getDomRef() || null;
		} else {
			return this.getDomRef("input") || null;
		}

	};

	/**
	 * Applies the focus info
	 * overwrite of the Element method because in IE8 on rerendering focus is lost
	 * @param {object} oFocusInfo Focus information
	 * @return {object} reference to this
	 * @protected
	 */
	TextField.prototype.applyFocusInfo = function (oFocusInfo) {

		if (!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version == 8) {
			var oPos = this.getValue().length;
			var that = this;
			setTimeout(function(){
				that.focus();
				that._restoreUnsavedUserInput(oFocusInfo.userinput);
				jQuery(that.getFocusDomRef()).cursorPos(oPos);
			}, 0);
		} else {
			this.focus();
			this._restoreUnsavedUserInput(oFocusInfo.userinput);
		}
		return this;
	};

	/**
	 * Returns an object representing the serialized focus information
	 * @return {object} an object representing the serialized focus information
	 * @protected
	 * @function
	 */
	TextField.prototype.getFocusInfo = function () {
		return {id: this.getId(), userinput: this._getUnsavedUserInputInfo()};
	};

	/**
	 * Returns the current value of the TextField. In case of editing the TextField you can access the current value via this method. The validated value is accessible via the property value.
	 *
	 * @return {string} live value
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TextField.prototype.getLiveValue = function() {
		var oIDomRef = this.getInputDomRef();
		if (oIDomRef) {
			return jQuery(oIDomRef).val();
		} else {
			return this.getValue();
		}
	};

	TextField.prototype.ondrop = function(oEvent) {

		if (sap.ui.Device.browser.firefox) {
			this.focus();
		}

	};

	/*
	 * check if outer content is rendered
	 * @private
	 */
	TextField.prototype._getRenderOuter = function () {

		if (this.bRenderOuter == undefined) {
			var oRenderer = this.getRenderer();
			if (oRenderer.renderOuterAttributes || oRenderer.renderOuterContentBefore || oRenderer.renderOuterContent) {
				this.bRenderOuter = true;
			} else {
				this.bRenderOuter = false;
			}
		}
		return this.bRenderOuter;

	};

	/*
	 * Overwrites default implementation
	 * the label must point to the input tag
	 * @public
	 */
	TextField.prototype.getIdForLabel = function () {

		if (!this._getRenderOuter()) {
			return this.getId();
		} else {
			return this.getId() + '-input';
		}

	};

	/*
	 * Overwrites default implementation
	 * the focus is always on the input field
	 * @public
	 */
	TextField.prototype.getFocusDomRef = function() {

		return this.getInputDomRef();

	};


	TextField.prototype._getUnsavedUserInputInfo = function() {
		var $tf = this.$();
		if ($tf.length && $tf.hasClass("sapUiTfFoc") && !$tf.hasClass("sapUiTfPlace") && this.getEnabled() && this.getEditable()){
			var sVal = jQuery(this.getInputDomRef()).val();
			var sValue = this.getValue();
			if (sVal != sValue){
				return {userinput: sVal, value: sValue};
			}
		}
		return null;
	};

	TextField.prototype._restoreUnsavedUserInput = function(oUnsavedUserInputInfo) {
		if (oUnsavedUserInputInfo && this.getEnabled() && this.getEditable() && this.getValue() == oUnsavedUserInputInfo.value){
			var sVal = oUnsavedUserInputInfo.userinput;
			if ( sVal && sVal.length > this.getMaxLength() && this.getMaxLength() > 0) {
				sVal = sVal.substring(0,this.getMaxLength());
			}

			jQuery(this.getInputDomRef()).val(sVal);
		}
	};


	return TextField;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TextField.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.TextView') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.TextView.
jQuery.sap.declare('sap.ui.commons.TextView'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/TextView",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup'],
	function(jQuery, library, Control, Popup) {
	"use strict";


	
	/**
	 * Constructor for a new TextView.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Is used to display some continous text. The control can inherit the text direction from its parent control.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.commons.ToolbarItem
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.TextView
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var TextView = Control.extend("sap.ui.commons.TextView", /** @lends sap.ui.commons.TextView.prototype */ { metadata : {
	
		interfaces : [
			"sap.ui.commons.ToolbarItem"
		],
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * Text to be displayed.
			 */
			text : {type : "string", defaultValue : '', bindable : "bindable"},
	
			/**
			 * Available options are LTR and RTL. Alternatively, the control can inherit the text direction from its parent control.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
	
			/**
			 * When the control is disabled, it is greyed out and no longer focusable.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Unique identifier used for help services.
			 */
			helpId : {type : "string", group : "Behavior", defaultValue : ''},
	
			/**
			 * The ARIA role for the control.
			 */
			accessibleRole : {type : "sap.ui.core.AccessibleRole", group : "Accessibility", defaultValue : sap.ui.core.AccessibleRole.Document},
	
			/**
			 * Defines the visual appearance of the control.
			 */
			design : {type : "sap.ui.commons.TextViewDesign", group : "Data", defaultValue : sap.ui.commons.TextViewDesign.Standard},
	
			/**
			 * Disabled automatic wrapping of the text.
			 */
			wrapping : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * Semantic color of the text View
			 */
			semanticColor : {type : "sap.ui.commons.TextViewColor", group : "Appearance", defaultValue : sap.ui.commons.TextViewColor.Default},
	
			/**
			 * Sets the horizontal alignment of the text.
			 */
			textAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
	
			/**
			 * Width of the TextView
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null}
		},
		associations : {
	
			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}, 
	
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		}
	}});
	
	
	/*
	 * @see JSDoc generated by SAPUI5 Control API generator
	 */
	TextView.prototype.setText = function(sText) {
		this.setProperty("text", sText, true); // no re-rendering!
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			// in case of 
			sText = this.getText(); // the default value '' ensures valid text string
			oDomRef.innerHTML = jQuery.sap.encodeHTML(sText).replace(/&#xa;/g, "<br>");
			// when no tooltip is applied use the text as tooltip
			if (!this.getTooltip_AsString()) {
				oDomRef.title = sText; // IE8 doesn't like HTML encoded attribute values
			}
		}
		if (this._oPopup) {
			this._oPopup.destroy();
			delete this._oPopup;
		}
		return this;
	};
	
	TextView.prototype.exit = function() {
		if (this._oPopup) {
			this._oPopup.destroy();
			delete this._oPopup;
		}
	};
	/*
	sap.ui.commons.TextView.prototype.onBeforeRendering = function() {
		if (this._oPopup) {
			this._oPopup.destroy();
			delete this._oPopup;
		}
	};
	
	sap.ui.commons.TextView.prototype.onmouseover = function(oEvent) {
		var oRef = this.getDomRef();
		if (Math.abs(oRef.clientWidth - oRef.scrollWidth) < 2){
			return;
		}
	
		if (!this._oPopup) {
			 this._oPopup = new sap.ui.core.Popup();
			 this._oPopup.setDurations(0, 0); // no animations
			 this._oPopup.setContent(this._createInfo());
			 this._oPopup.attachOpened(this._handleOpened, this);
		}
	
		var eDock = sap.ui.core.Popup.Dock;
		this._oPopup.open(0, eDock.BeginTop, eDock.BeginTop, this, "0 1", "fit", true);
	};
	
	sap.ui.commons.TextView.prototype._createInfo = function(){
		var $Me   = jQuery(this.getDomRef());
		var sText = $Me.html();
		var sHtml = "<span id='" + this.getId()+'-info' + "' class='sapUiTvInfo " + $Me.attr("class") + "'>" + sText + "</span>";
	
		var oDomRef = jQuery(sHtml).appendTo(sap.ui.getCore().getStaticAreaRef());
		var that = this;
		jQuery(oDomRef).mouseout([this.getId()], function(oEvent){
			that._oPopup.close();
		});
		return oDomRef;
	};
	
	sap.ui.commons.TextView.prototype._handleOpened = function(){
		var that = this;
		jQuery.sap.byId(this.getId()+'-info').mouseout([this.getId()], function(oEvent){
			that._oPopup.close();
		});
	};*/

	return TextView;

}, /* bExport= */ true);

}; // end of sap/ui/commons/TextView.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Title') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Title.
jQuery.sap.declare('sap.ui.commons.Title'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Title'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Title",['jquery.sap.global', './library', 'sap/ui/core/Title'],
	function(jQuery, library, Title1) {
	"use strict";


	
	/**
	 * Constructor for a new Title.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Represents a title element that can be used for aggregation with other controls
	 * @extends sap.ui.core.Title
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.16.0. 
	 * moved to sap.ui.core library. Please use this one.
	 * @alias sap.ui.commons.Title
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Title = Title1.extend("sap.ui.commons.Title", /** @lends sap.ui.commons.Title.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.commons"
	}});
	
	/* Overwrite to have right "since" in there */
	
	/**
	* Getter for property <code>level</code>.
	* Defines the level of the title. If set to auto the level of the title is chosen by the control rendering the title.
	*
	* Currently not all controls using the Title.control supporting this property.
	*
	* Default value is <code>Auto</code>
	*
	* @return {sap.ui.commons.TitleLevel} the value of property <code>level</code>
	* @public
	* @since 1.9.1
	* @name sap.ui.commons.Title#getLevel
	* @function
	*/
	/**
	* Setter for property <code>level</code>.
	*
	* Default value is <code>Auto</code>
	*
	* @param {sap.ui.commons.TitleLevel} oLevel new value for property <code>level</code>
	* @return {sap.ui.commons.Title} <code>this</code> to allow method chaining
	* @public
	* @since 1.9.1
	* @name sap.ui.commons.Title#setLevel
	* @function
	*/

	return Title;

}, /* bExport= */ true);

}; // end of sap/ui/commons/Title.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.ToggleButton') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.ToggleButton.
jQuery.sap.declare('sap.ui.commons.ToggleButton'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/ToggleButton",['jquery.sap.global', './Button', './library'],
	function(jQuery, Button, library) {
	"use strict";


	
	/**
	 * Constructor for a new ToggleButton.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The ToggleButton Control is a Button that can be toggled between pressed and normal state
	 * @extends sap.ui.commons.Button
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.commons.ToggleButton
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ToggleButton = Button.extend("sap.ui.commons.ToggleButton", /** @lends sap.ui.commons.ToggleButton.prototype */ { metadata : {
	
		library : "sap.ui.commons",
		properties : {
	
			/**
			 * The property is “true” when the control is toggled. The default state of this property is "false".
			 */
			pressed : {type : "boolean", group : "Data", defaultValue : false}
		}
	}});
	
	/**
	 * Function is called when ToggleButton is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ToggleButton.prototype.onclick = function(oEvent) {
		if (this.getEnabled()) {
			this.setPressed(!this.getPressed());
			if (this.$().is(":visible")) {
				this.firePress({pressed: this.getPressed()});
			}
		}
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};
	
	
	ToggleButton.prototype.setPressed = function(bPressed) {
		if (bPressed != this.getProperty("pressed")) {
			this.setProperty("pressed", bPressed, true);
			if (!this.getPressed()) {
				this.getRenderer().ondeactivePressed(this);
			} else {
				this.getRenderer().onactivePressed(this);
			}
			this.getRenderer().updateImage(this);
		}
		return this;
	};
	
	
	ToggleButton.prototype.onAfterRendering = function() {
		if (!this.getPressed()) {
			this.getRenderer().ondeactivePressed(this);
		} else {
			this.getRenderer().onactivePressed(this);
		}
	};
	

	return ToggleButton;

}, /* bExport= */ true);

}; // end of sap/ui/commons/ToggleButton.js
if ( !jQuery.sap.isDeclared('sap.ui.commons.Toolbar') ) {
/*!
 # * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.commons.Toolbar.
jQuery.sap.declare('sap.ui.commons.Toolbar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/commons/Toolbar",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup', 'sap/ui/core/delegate/ItemNavigation', './ToolbarRenderer'],
	function (jQuery, library, Control, Popup, ItemNavigation, ToolbarRenderer) {
		"use strict";

		/**
		 * Constructor for a new Toolbar.
		 *
		 * @param {string} [sId] id for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] initial settings for the new control
		 *
		 * @class
		 * A horizontal row of items where in many cases the single toolbar items are buttons containing icons. Note that all controls with the
		 * sap.ui.commons.ToolbarItem interface can be used as item: Button, ComboBox, TextField.
		 * @extends sap.ui.core.Control
		 * @implements sap.ui.core.Toolbar
		 *
		 * @author SAP SE
		 * @version 1.28.17
		 *
		 * @constructor
		 * @public
		 * @alias sap.ui.commons.Toolbar
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var Toolbar = Control.extend("sap.ui.commons.Toolbar", /** @lends sap.ui.commons.Toolbar.prototype */ {
			metadata: {

				interfaces: [
					"sap.ui.core.Toolbar"
				],
				library: "sap.ui.commons",
				properties: {
					/**
					 * When there is not enough space for the toolbar to display all items, the rightmost items are overflowing into a drop-down menu.
					 */
					width: {type: "sap.ui.core.CSSSize", group: "Dimension", defaultValue: 'auto'},

					/**
					 * Design settings are theme-dependent.
					 */
					design: {
						type: "sap.ui.commons.ToolbarDesign",
						group: "Appearance",
						defaultValue: sap.ui.commons.ToolbarDesign.Flat
					},

					/**
					 * Per default, tool bars have the stand alone status.
					 * Alternatively, they can be nested in other controls and then inherit the design from their parent control.
					 */
					standalone: {type: "boolean", group: "Appearance", defaultValue: true}
				},
				defaultAggregation: "items",
				aggregations: {

					/**
					 * Aggregating the tool bar items.
					 */
					items: {type: "sap.ui.commons.ToolbarItem", multiple: true, singularName: "item"},

					/**
					 * Aggregating the right side tool bar items.
					 */
					rightItems: {type: "sap.ui.commons.ToolbarItem", multiple: true, singularName: "rightItem"}
				}
			}
		});


		/**
		 * Initialize this control.
		 *
		 * @private
		 */
		Toolbar.prototype.init = function () {
			this.bOpen = false; // the overflow popup state

			// Buffer for performance, updated after rendering
			this.oDomRef = null;
			this.oInnerRef = null;
			//reference to the menu button
			this.oOverflowDomRef = null;
			//reference to the overflow content
			this._oOverflowPopup = null;
		    this.sOriginalStylePropertyWidth = null;
			this.bHasRightItems = false;
			this._bRendering = false;

			this.bRtl = sap.ui.getCore().getConfiguration().getRTL();

			// for resize detection
			this._detectVisibleItemCountChangeTimer = null;

			// delegate function to recognize if item is (re)rendered
			var that = this;
			this.oItemDelegate = {
				onAfterRendering: jQuery.proxy(that._itemRendered, that)
			};

			this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
		};

		Toolbar.prototype.onBeforeRendering = function () {
			ToolbarRenderer.emptyOverflowPopup(this, false); // if rerendering happens while there are still items in the popup (and it is open), the items will be duplicated
			this.cleanup();

			this.$("mn").unbind("keydown", this._handleKeyDown);

			this.bFirstTime = true;
			this._bRendering = true;
		};

		/**
		 * Used for after-rendering initialization.
		 *
		 * @private
		 */
		Toolbar.prototype.onAfterRendering = function () {
			this._bRendering = false;
			this.oDomRef = this.getDomRef();
			this.oInnerRef = this.oDomRef.firstChild.firstChild;
			jQuery(this.oInnerRef).css("visibility", "visible");
			var sOverflowId = this.getId() + "-mn";
			this.oOverflowDomRef = jQuery.sap.domById(sOverflowId);

			// Initialize the ItemNavigation if required
			if (!this.oItemNavigation) {
				this.oItemNavigation = new ItemNavigation();
				this.addDelegate(this.oItemNavigation);
			}

			// cannot use sapspace because this triggers onkeydown and sets the focus to the first button in the overflow popup
			// and the subsequent keydown will make the browser fire a click event on that button
			this.$("mn").bind("keydown", jQuery.proxy(this._handleKeyDown, this));

			this.sResizeListenerId = sap.ui.core.ResizeHandler.register(this.oDomRef, jQuery.proxy(this.ontoolbarresize, this));
			var iRightItemsLength = this.getRightItems().length;
			this.bHasRightItems = iRightItemsLength > 0;
			if (this.bHasRightItems) {
				this.sRightSideResizeListenerId = sap.ui.core.ResizeHandler.register(this.oDomRef.lastChild, jQuery.proxy(this.onrightsideresize, this));
				// Re-initialize the ItemNavigation with changed DomRefs after rendering and set the overflow icon properly
				this.updateAfterResize(true);
				this._observeVisibleItemCountChange(40);
			} else {
				// Re-initialize the ItemNavigation with changed DomRefs after rendering and set the over