/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/odata/CountMode','sap/ui/model/ChangeReason','sap/ui/model/odata/ODataUtils'],function(q,T,C,a,O){"use strict";var b=T.extend("sap.ui.model.odata.v2.ODataTreeBinding",{constructor:function(m,p,c,f,P,s){T.apply(this,arguments);this.mParameters=this.mParameters||P||{};this.oFinalLengths={};this.oLengths={};this.oKeys={};this.bNeedsUpdate=false;this._bRootMissing=false;this.sFilterParams="";this.mRequestHandles={};this.oRootContext=null;this.iNumberOfExpandedLevels=(P&&P.numberOfExpandedLevels)||0;this.iRootLevel=(P&&P.rootLevel)||0;if(P&&P.countMode&&P.countMode!==C.Inline){q.log.fatal("ODataTreeBinding only supports CountMode.Inline!");}else{this.sCountMode=C.Inline;}this.bInitial=true;this._mLoadedSections={};this._iPageSize=0;}});b.DRILLSTATES={Collapsed:"collapsed",Expanded:"expanded",Leaf:"leaf"};b.prototype._validateParameters=function(){var r=this.mParameters.rootNodeID;var R=this.mParameters.rootLevel;if(r){return true;}if(!r){this.bDisplayRootNode=true;}};b.prototype._loadSingleRootByHierarchyNodeID=function(r,R){var t=this;var _=function(d){if(d.results&&d.results.length>0){var e=d.results[0];var k=t.oModel._getKey(e);t.oRootContext=t.oModel.getContext('/'+k);}else{t._bRootMissing=true;}t.bNeedsUpdate=true;delete t.mRequestHandles[R];t.fireDataReceived();};var c=function(e){if(e&&e.statusCode!=0&&e.statusText!="abort"){var E="Request for root node failed: "+e.message;if(e.response){E+=", "+e.response.statusCode+", "+e.response.statusText+", "+e.response.body;}q.sap.log.fatal(E);t.bNeedsUpdate=true;t._bRootMissing=true;delete t.mRequestHandles[R];t.fireDataReceived();}};var p=[];var f=this.getFilterParams()?"%20and%20"+this.getFilterParams():"";p.push("$filter="+q.sap.encodeURL(this.oTreeProperties["hierarchy-node-for"]+" eq '"+r+"'")+f);if(this.mRequestHandles[R]){this.mRequestHandles[R].abort();}this.fireDataRequested();this.mRequestHandles[R]=this.oModel.read(this.getPath(),{urlParameters:p,success:_,error:c,sorters:this.aSorters});};b.prototype._loadSingleRootNodeByNavigationProperties=function(n,r){var t=this;if(this.mRequestHandles[r]){this.mRequestHandles[r].abort();}this.mRequestHandles[r]=this.oModel.read(n,{success:function(d){var N=t._getNavPath(t.getPath());if(d){var e=d;var k=t.oModel._getKey(e);var o=t.oModel.getContext('/'+k);t.oRootContext=o;t._processODataObject(o.getObject(),n,N);}else{t._bRootMissing=true;}t.bNeedsUpdate=true;delete t.mRequestHandles[r];t.fireDataReceived();},error:function(e){if(e&&e.statusCode!=0&&e.statusText!="abort"){t.bNeedsUpdate=true;t._bRootMissing=true;delete t.mRequestHandles[r];t.fireDataReceived();}}});};b.prototype.getRootContexts=function(s,l,t){var n=null,r={numberOfExpandedLevels:this.iNumberOfExpandedLevels},R=[],c=this.mParameters.rootNodeID||null;if(this.isInitial()){return R;}s=s||0;l=l||this.oModel.sizeLimit;t=t||0;var d=""+n+"-"+s+"-"+this._iPageSize+"-"+t;if(this.bHasTreeAnnotations){this._validateParameters();if(this.bDisplayRootNode&&c){if(this.oRootContext){return[this.oRootContext];}else if(this._bRootMissing){return[];}else{this._loadSingleRootByHierarchyNodeID(c,d);}}else{R=this._getContextsForNodeId(c,s,l,t);}}else{n=this.oModel.resolve(this.getPath(),this.getContext());var i=this.oModel.isList(this.sPath,this.getContext());if(i){this.bDisplayRootNode=true;}if(this.bDisplayRootNode&&!i){if(this.oRootContext){return[this.oRootContext];}else if(this._bRootMissing){return[];}else{this._loadSingleRootNodeByNavigationProperties(n,d);}}else{r.navPath=this._getNavPath(this.getPath());if(!this.bDisplayRootNode){n+="/"+r.navPath;}R=this._getContextsForNodeId(n,s,l,t,r);}}return R;};b.prototype.getNodeContexts=function(c,s,l,t){var n,r={};if(this.isInitial()){return[];}if(this.bHasTreeAnnotations){n=c.getProperty(this.oTreeProperties["hierarchy-node-for"]);r.level=parseInt(c.getProperty(this.oTreeProperties["hierarchy-level-for"]),10)+1;}else{var N=this._getNavPath(c.getPath());if(!N){return[];}n=this.oModel.resolve(N,c);r.navPath=this.oNavigationPaths[N];}return this._getContextsForNodeId(n,s,l,t,r);};b.prototype.hasChildren=function(c){if(this.bHasTreeAnnotations){if(!c){return false;}var d=c.getProperty(this.oTreeProperties["hierarchy-drill-state-for"]);var h=c.getProperty(this.oTreeProperties["hierarchy-node-for"]);var l=this.oLengths[h];if(l===0&&this.oFinalLengths[h]){return false;}if(d==="expanded"||d==="collapsed"){return true;}else if(d==="leaf"){return false;}else{q.sap.log.warning("The entity '"+c.getPath()+"' has not specified Drilldown State property value.");if(d===undefined||d===""){return true;}return false;}}else{if(!c){return this.oLengths[this.getPath()]>0;}var l=this.oLengths[c.getPath()+"/"+this._getNavPath(c.getPath())];return l!==0;}};b.prototype.getChildCount=function(c){if(this.bHasTreeAnnotations){var h;if(!c){h=this.mParameters.rootNodeID||null;}else{h=c.getProperty(this.oTreeProperties["hierarchy-node-for"]);}return this.oLengths[h];}else{if(!c){if(!this.bDisplayRootNode){return this.oLengths[this.getPath()+"/"+this._getNavPath(this.getPath())];}else{return this.oLengths[this.getPath()];}}return this.oLengths[c.getPath()+"/"+this._getNavPath(c.getPath())];}};b.prototype._mergeSections=function(s,n){var N=[];for(var i=0;i<s.length;i++){var c=s[i];var d=c.startIndex+c.length;var e=n.startIndex+n.length;if(n.startIndex<=d&&e>=d&&n.startIndex>=c.startIndex){n.startIndex=c.startIndex;n.length=e-c.startIndex;}else if(n.startIndex<=c.startIndex&&e>=c.startIndex&&e<=d){n.length=d-n.startIndex;}else if(n.startIndex>=c.startIndex&&e<=d){n.startIndex=c.startIndex;n.length=c.length;}else if(e<c.startIndex||n.startIndex>d){N.push(c);}}N.push(n);return N;};b.prototype._getContextsForNodeId=function(n,s,l,t,r){var c=[],k,R;s=s||0;l=l||this.oModel.iSizeLimit;t=t||0;if(!this._mLoadedSections[n]){this._mLoadedSections[n]=[];}if(this.bHasTreeAnnotations){if(n==null){R=this.iRootLevel;}}if(this.oFinalLengths[n]&&this.oLengths[n]<s+l){l=Math.max(this.oLengths[n]-s,0);}var d=this;var f=function(s){for(var i=0;i<d._mLoadedSections[n].length;i++){var S=d._mLoadedSections[n][i];if(s>=S.startIndex&&s<S.startIndex+S.length){return true;}}};var m=[];var i=Math.max((s-t-this._iPageSize),0);if(this.oKeys[n]){for(i;i<s+l+(t);i++){k=this.oKeys[n][i];if(!k){if(!f(i)){m=this._mergeSections(m,{startIndex:i,length:1});}}if(i>=s&&i<s+l){if(k){c.push(this.oModel.getContext('/'+k));}else{c.push(undefined);}}}var B=Math.max((s-t-this._iPageSize),0);var e=s+l+(t);var E=m[0]&&m[0].startIndex===B&&m[0].startIndex+m[0].length===e;if(m.length>0&&!E){i=Math.max((m[0].startIndex-t-this._iPageSize),0);var F=m[0].startIndex;for(i;i<F;i++){var k=this.oKeys[n][i];if(!k){if(!f(i)){m=this._mergeSections(m,{startIndex:i,length:1});}}}i=m[m.length-1].startIndex+m[m.length-1].length;var g=i+t+this._iPageSize;for(i;i<g;i++){var k=this.oKeys[n][i];if(!k){if(!f(i)){m=this._mergeSections(m,{startIndex:i,length:1});}}}}}else{if(!f(s)){var L=s-i;m=this._mergeSections(m,{startIndex:i,length:l+L+t});}}if(this.oModel.getServiceMetadata()){if(m.length>0){var p=[];if(this.bHasTreeAnnotations){var h=this.getFilterParams()?"%20and%20"+this.getFilterParams():"";if(n){p.push("$filter="+q.sap.encodeURL(this.oTreeProperties["hierarchy-parent-node-for"]+" eq '"+n+"'")+h);}else{p.push("$filter="+q.sap.encodeURL(this.oTreeProperties["hierarchy-level-for"]+" eq "+R)+h);}}if(this.sCustomParams){p.push(this.sCustomParams);}for(i=0;i<m.length;i++){var o=m[i];this._mLoadedSections[n]=this._mergeSections(this._mLoadedSections[n],{startIndex:o.startIndex,length:o.length});this._loadSubNodes(n,o.startIndex,o.length,0,p,r,o);}}}return c;};b.prototype._getCountForNodeId=function(n,s,l,t,p){var c=this;var P=[];function _(D){c.oFinalLengths[n]=true;c.oLengths[n]=parseInt(D,10);}function d(E){if(E&&E.statusCode===0&&E.statusText==="abort"){return;}var g="Request for $count failed: "+E.message;if(E.response){g+=", "+E.response.statusCode+", "+E.response.statusText+", "+E.response.body;}q.sap.log.warning(g);}var e;if(this.bHasTreeAnnotations){e=this.oModel.resolve(this.getPath(),this.getContext());var f=this.getFilterParams()?"%20and%20"+this.getFilterParams():"";P.push("$filter="+q.sap.encodeURL(this.oTreeProperties["hierarchy-parent-node-for"]+" eq '"+n+"'")+f);}else{e=n;}if(e){this.oModel.read(e+"/$count",{urlParameters:P,success:_,error:d,sorters:this.aSorters});}};b.prototype._loadSubNodes=function(n,s,l,t,p,P,r){var c=this,I=false;if(s||l){p.push("$skip="+s+"&$top="+(l+t));}if(!this.oFinalLengths[n]&&(this.sCountMode==C.Inline||this.sCountMode==C.Both)){p.push("$inlinecount=allpages");I=true;}var R=""+n+"-"+s+"-"+this._iPageSize+"-"+t;function S(d){if(d.results&&d.results.length>0){if(c.bHasTreeAnnotations){var L={};if(I&&d.__count){c.oLengths[n]=parseInt(d.__count,10);c.oFinalLengths[n]=true;}for(var i=0;i<d.results.length;i++){var E=d.results[i];var f=n;if(i==0){L[f]=s;}else if(L[f]==undefined){L[f]=0;}if(!(f in c.oKeys)){c.oKeys[f]=[];if(I&&d.__count){c.oLengths[f]=parseInt(d.__count,10);c.oFinalLengths[f]=true;}else{var g=parseInt(d.results.length,10);c.oLengths[f]=Math.max(c.oLengths[f]||0,s+g);if(g<l){c.oFinalLengths[f]=true;}if(!c.oFinalLengths[f]&&c.oModel.isCountSupported()){c._getCountForNodeId(f);}}}c.oKeys[f][L[f]]=c.oModel._getKey(E);L[f]++;}}else{if(I&&d.__count){c.oLengths[n]=parseInt(d.__count,10);c.oFinalLengths[n]=true;}else{if(c.oModel.isCountSupported()){c._getCountForNodeId(n);}}c.oKeys[n]=[];for(var i=0;i<d.results.length;i++){var E=d.results[i];var k=c.oModel._getKey(E);c._processODataObject(E,"/"+k,P.navPath);c.oKeys[n][i+s]=k;}}}else if(d.results&&d.results.length===0){if(I&&d.__count){c.oLengths[n]=parseInt(d.__count,10);}c.oFinalLengths[n]=true;}else{c.oKeys[null]=c.oModel._getKey(d);if(!c.bHasTreeAnnotations){c._processODataObject(d,n,P.navPath);}}c.oRequestHandle=null;delete c.mRequestHandles[R];c.bNeedsUpdate=true;c.fireDataReceived();}function e(E){if(E&&E.statusCode===0&&E.statusText==="abort"){return;}c.oRequestHandle=null;delete c.mRequestHandles[R];c.fireDataReceived();if(r){var L=[];for(var i=0;i<c._mLoadedSections[n].length;i++){var o=c._mLoadedSections[n][i];if(r.startIndex>=o.startIndex&&r.startIndex+r.length<=o.startIndex+o.length){if(r.startIndex!==o.startIndex&&r.length!==o.length){L=c._mergeSections(L,{startIndex:o.startIndex,length:r.startIndex-o.startIndex});L=c._mergeSections(L,{startIndex:r.startIndex+r.length,length:(o.startIndex+o.length)-(r.startIndex+r.length)});}}else{L.push(o);}}c._mLoadedSections[n]=L;}}if(n!==undefined){if((!this.oFinalLengths[n]||this.bHasTreeAnnotations)){this.fireDataRequested();var A;if(this.bHasTreeAnnotations){A=this.oModel.resolve(this.getPath(),this.getContext());}else{A=n;}if(this.mRequestHandles[R]){this.mRequestHandles[R].abort();}this.mRequestHandles[R]=this.oModel.read(A,{urlParameters:p,success:S,error:e,sorters:this.aSorters});}}};b.prototype.resetData=function(c,p){if(c){var P=c.getPath();delete this.oKeys[P];delete this.oLengths[P];delete this.oFinalLengths[P];delete this._mLoadedSections[P];}else{this.oKeys={};this.oLengths={};this.oFinalLengths={};this.oRootContext=null;this._bRootMissing=false;q.each(this.mRequestHandles,function(r,R){if(R){R.abort();}});this.mRequestHandles={};this._mLoadedSections={};this._iPageSize=0;this.sFilterParams="";}};b.prototype.refresh=function(f,c,e){var d=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);if(r.indexOf("?")!==-1){r=r.split("?")[0];}var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){d=true;}}if(c&&!d){q.each(this.oKeys,function(i,n){q.each(n,function(i,k){if(k in c){d=true;return false;}});if(d){return false;}});}if(!c&&!e){d=true;}}if(f||d){this.resetData();this.bNeedsUpdate=false;this.bRefresh=true;this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh});}};b.prototype.filter=function(f){q.sap.log.warning("Filtering is currently not possible in the ODataTreeBinding");return this;};b.prototype.sort=function(s,r){var S=false;if(s instanceof sap.ui.model.Sorter){s=[s];}this.aSorters=s||[];if(!this.bInitial){this.resetData(undefined,{reason:a.Sort});q.each(this.mRequestHandles,function(R,o){if(o){o.abort();}});this._fireRefresh({reason:a.Sort});S=true;}if(r){return S;}else{return this;}};b.prototype.checkUpdate=function(f,c){var d=false;if(!f){if(this.bNeedsUpdate||!c){d=true;}else{q.each(this.oKeys,function(i,n){q.each(n,function(i,k){if(k in c){d=true;return false;}});if(d){return false;}});}}if(f||d){this.bNeedsUpdate=false;this._fireChange();}};b.prototype._getNavPath=function(p){var A=this.oModel.resolve(p,this.getContext());if(!A){return;}var P=A.split("/"),e=P[P.length-1],n;var c=e.split("(")[0];if(c&&this.oNavigationPaths[c]){n=this.oNavigationPaths[c];}return n;};b.prototype._processODataObject=function(o,p,n){var N=[],t=this;if(n&&n.indexOf("/")>-1){N=n.split("/");n=N[0];N.splice(0,1);}var r=this.oModel._getObject(p);if(q.isArray(r)){this.oKeys[p]=r;this.oLengths[p]=r.length;this.oFinalLengths[p]=true;}else if(r){this.oLengths[p]=1;this.oFinalLengths[p]=true;}if(n&&o[n]){if(q.isArray(r)){q.each(r,function(i,R){var o=t.getModel().getData("/"+R);t._processODataObject(o,"/"+R+"/"+n,N.join("/"));});}else if(typeof r==="object"){t._processODataObject(o,p+"/"+n,N.join("/"));}}};b.prototype._hasTreeAnnotations=function(){var m=this.oModel,M=m.oMetadata,A=m.resolve(this.getPath(),this.getContext()),e,t=M.mNamespaces["sap"],c=this;this.oTreeProperties={"hierarchy-level-for":false,"hierarchy-parent-node-for":false,"hierarchy-node-for":false,"hierarchy-drill-state-for":false};var s=function(){var f=0;var i=0;q.each(c.oTreeProperties,function(p,P){i++;if(P){f+=1;}});if(f===i){return true;}else if(f>0&&f<i){q.sap.log.warning("Incomplete hierarchy tree annotations. Please check your service metadata definition!");}return false;};if(this.mParameters&&this.mParameters.treeAnnotationProperties){this.oTreeProperties["hierarchy-level-for"]=this.mParameters.treeAnnotationProperties.hierarchyLevelFor;this.oTreeProperties["hierarchy-parent-node-for"]=this.mParameters.treeAnnotationProperties.hierarchyParentNodeFor;this.oTreeProperties["hierarchy-node-for"]=this.mParameters.treeAnnotationProperties.hierarchyNodeFor;this.oTreeProperties["hierarchy-drill-state-for"]=this.mParameters.treeAnnotationProperties.hierarchyDrillStateFor;return s();}if(A.indexOf("?")!==-1){A=A.split("?")[0];}e=M._getEntityTypeByPath(A);if(!e){q.sap.log.fatal("EntityType for path "+A+" could not be found.");return false;}q.each(e.property,function(i,p){if(!p.extensions){return true;}q.each(p.extensions,function(i,E){var n=E.name;if(E.namespace===t&&n in c.oTreeProperties&&!c.oTreeProperties[n]){c.oTreeProperties[n]=p.name;}});});return s();};b.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.bHasTreeAnnotations=this._hasTreeAnnotations();this._processSelectParameters();this.oEntityType=this._getEntityType();this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh});}return this;};b.prototype._processSelectParameters=function(){if(this.mParameters){this.oNavigationPaths=this.mParameters.navigation;if(this.mParameters.select){var s=this.mParameters.select.split(",");var n=[];if(this.oNavigationPaths){q.each(this.oNavigationPaths,function(p,P){if(q.inArray(P,n)==-1){n.push(P);}});}q.each(n,function(p,P){if(q.inArray(P,s)==-1){s.push(P);}});if(this.bHasTreeAnnotations){q.each(this.oTreeProperties,function(A,t){if(t){if(q.inArray(t,s)==-1){s.push(t);}}});}this.mParameters.select=s.join(",");}this.sCustomParams=this.oModel.createCustomParams(this.mParameters);}if(!this.bHasTreeAnnotations&&!this.oNavigationPaths){q.sap.log.error("Neither navigation paths parameters, nor (complete/valid) tree hierarchy annotations where provided to the TreeBinding.");this.oNavigationPaths={};}};b.prototype.getDownloadUrl=function(f){var p=[],P;if(f){p.push("$format="+encodeURIComponent(f));}if(this.getFilterParams()){p.push("$filter="+this.getFilterParams());}if(this.sCustomParams){p.push(this.sCustomParams);}P=this.oModel.resolve(this.sPath,this.oContext);if(P){return this.oModel._createRequestUrl(P,null,p);}};b.prototype.setNumberOfExpandedLevels=function(l){l=l||0;if(l<0){q.sap.log.warning("ODataTreeBinding: numberOfExpandedLevels was set to 0. Negative values are prohibited.");l=0;}this.iNumberOfExpandedLevels=l;this._fireChange();};b.prototype.getNumberOfExpandedLevels=function(){return this.iNumberOfExpandedLevels;};b.prototype.setRootLevel=function(r){r=parseInt(r||0,10);if(r<0){q.sap.log.warning("ODataTreeBinding: rootLevels was set to 0. Negative values are prohibited.");r=0;}this.iRootLevel=r;this.refresh();};b.prototype.getRootLevel=function(){return this.iRootLevel;};b.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var e=this.oModel.oMetadata._getEntityTypeByPath(r);return e;}return undefined;};b.prototype.getFilterParams=function(){if(this.aFilters&&this.aFilters.length>0){if(!this.sFilterParams){this.sFilterParams=O._createFilterParams(this.aFilters,this.oModel.oMetadata,this.oEntityType);this.sFilterParams=this.sFilterParams?this.sFilterParams:"";}}else{this.sFilterParams="";}return this.sFilterParams;};return b;},true);
