/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library'],function(q,C,L,I,D,a,U,l){"use strict";var M=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Misc"},intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},showHeader:{type:"boolean",group:"Misc",defaultValue:false},firstDayOfWeek:{type:"int",group:"Misc",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"}}}}}});(function(){M.prototype.init=function(){this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;};M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}};M.prototype.onAfterRendering=function(){var t=this;_(t);m(t);};M.prototype.invalidate=function(o){if(!this._bDateRangeChanged&&(!o||!(o instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonth){var t=this;if(this._bInvalidateSync){n(t);}else{this._sInvalidateMonth=q.sap.delayedCall(0,t,n,[t]);}}};M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("selectedDates");return r;};M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var o=this.destroyAggregation("selectedDates");return o;};M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("specialDates");return r;};M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var o=this.destroyAggregation("specialDates");return o;};M.prototype.setDate=function(o){var t=this;e(t,o,false);return this;};M.prototype._setDate=function(o){var i=a._createLocalDate(o);this.setProperty("date",i,true);this._oUTCDate=o;};M.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date());}return this._oUTCDate;};M.prototype.displayDate=function(o){var t=this;e(t,o,true);return this;};M.prototype._getLocale=function(){var p=this.getParent();if(p&&p.getLocale){return p.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};M.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new sap.ui.core.Locale(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};M.prototype._getFormatLong=function(){var s=this._getLocale();if(this._oFormatLong.oLocale.toString()!=s){var o=new sap.ui.core.Locale(s);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"},o);}return this._oFormatLong;};M.prototype.getIntervalSelection=function(){var p=this.getParent();if(p&&p.getIntervalSelection){return p.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};M.prototype.getSingleSelection=function(){var p=this.getParent();if(p&&p.getSingleSelection){return p.getSingleSelection();}else{return this.getProperty("singleSelection");}};M.prototype.getSelectedDates=function(){var p=this.getParent();if(p&&p.getSelectedDates){return p.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};M.prototype.getSpecialDates=function(){var p=this.getParent();if(p&&p.getSpecialDates){return p.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};M.prototype._getShowHeader=function(){var p=this.getParent();if(p&&p._getShowMonthHeader){return p._getShowMonthHeader();}else{return this.getProperty("showHeader");}};M.prototype.getAriaLabelledBy=function(){var p=this.getParent();if(p&&p.getAriaLabelledBy){return p.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};M.prototype._getFirstDayOfWeek=function(){var p=this.getParent();var F=0;if(p&&p.getFirstDayOfWeek){F=p.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var o=this._getLocaleData();F=o.getFirstDayOfWeek();}return F;};M.prototype._getNonWorkingDays=function(){var p=this.getParent();var N;if(p&&p.getNonWorkingDays){N=p.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!q.isArray(N)){N=[];}return N;};M.prototype._checkDateSelected=function(o){if(!(o instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var s=0;var S=this.getSelectedDates();var t=o.getTime();for(var i=0;i<S.length;i++){var r=S[i];var p=r.getStartDate();var u=0;if(p){p=a._createUniversalUTCDate(p);u=p.getTime();}var E=r.getEndDate();var v=0;if(E){E=a._createUniversalUTCDate(E);v=E.getTime();}if(t==u&&!E){s=1;break;}else if(t==u&&E){s=2;if(E&&t==v){s=5;}break;}else if(E&&t==v){s=3;break;}else if(E&&t>u&&t<v){s=4;break;}if(this.getSingleSelection()){break;}}return s;};M.prototype._getDateType=function(o){if(!(o instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var t;var s=this.getSpecialDates();var T=o.getTime();for(var i=0;i<s.length;i++){var r=s[i];var S=r.getStartDate();var p=0;if(S){S=a._createUniversalUTCDate(S);p=S.getTime();}var E=r.getEndDate();var u=0;if(E){E=a._createUniversalUTCDate(E);u=E.getTime();}if((T==p&&!E)||(T>=p&&T<=u)){t={type:r.getType(),tooltip:r.getTooltip_AsString()};break;}}return t;};M.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var t=q(E.target);if(t.hasClass("sapUiCalDayNum")){t=t.parent();}var i=this;if(t.hasClass("sapUiCalDay")){var o=this._getDate();if(!q.sap.containsOrEquals(this.getDomRef(),E.target)){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var S=s[0].getStartDate();if(S){S=a._createUniversalUTCDate(S);}var p=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());if(p.getTime()>=S.getTime()){j(i,S,p);}else{j(i,p,S);}}}else{var F=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());if(F.getTime()!=o.getTime()){if(t.hasClass("sapUiCalDayOtherMonth")){this.fireFocus({date:a._createLocalDate(F),otherMonth:true});}else{this._setDate(F);h(i,F,false,true);this._bMoveChange=true;}}}}};M.prototype.onmouseup=function(E){if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var o=this._oItemNavigation.getItemDomRefs();for(var i=0;i<o.length;i++){var $=q(o[i]);if(!$.hasClass("sapUiCalDayOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F,true)){$.focus();break;}}}if(this._bMoveChange){var t=q(E.target);if(t.hasClass("sapUiCalDayNum")){t=t.parent();}if(t.hasClass("sapUiCalDay")){F=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());}var p=this;h(p,F);this._bMoveChange=false;k(p);}}};M.prototype.onsapselect=function(E){var t=this;h(t,t._getDate());k(t);E.stopPropagation();E.preventDefault();};M.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};M.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y-10);}else{F.setUTCFullYear(y-1);}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});E.preventDefault();};M.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y+10);}else{F.setUTCFullYear(y+1);}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});E.preventDefault();};M.prototype._updateSelection=function(){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var t=this;var S=s[0].getStartDate();if(S){S=a._createUniversalUTCDate(S);}var E=s[0].getEndDate();if(E){E=a._createUniversalUTCDate(E);}j(t,S,E);}};M.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};M.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;if(F){this.fireEvent("_unbindMousemove");}};M.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var o=this._getLocaleData();var s=this._getFirstDayOfWeek();var p=o.getDaysStandAlone("abbreviated");for(var i=0;i<w.length;i++){var W=w[i];q(W).text(p[(i+s)%7]);}var t=this;m(t);};M.prototype._handleBorderReached=function(o){var E=o.getParameter("event");var i=0;var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN){F.setUTCDate(F.getUTCDate()+7);}else{F.setUTCDate(F.getUTCDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP){F.setUTCDate(F.getUTCDate()-7);}else{F.setUTCDate(F.getUTCDate()-1);}break;case"sappagedown":i=F.getUTCMonth()+1;F.setUTCMonth(i);if(i%12!=F.getUTCMonth()){while(i!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;case"sappageup":i=F.getUTCMonth()-1;F.setUTCMonth(i);if(i<0){i=11;}if(i!=F.getUTCMonth()){while(i!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;default:break;}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});}};M.prototype.checkDateFocusable=function(o){if(!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var i=this._getDate();var u=a._createUniversalUTCDate(o);if(u.getUTCFullYear()==i.getUTCFullYear()&&u.getUTCMonth()==i.getUTCMonth()){return true;}else{return false;}};M.prototype._renderHeader=function(){if(this._getShowHeader()){var o=this._getDate();var i=this._getLocaleData();var p=i.getMonthsStandAlone("wide");this.$("Head").text(p[o.getUTCMonth()]);}};function _(t){var o=t._getDate();var y=t._oFormatYyyymmdd.format(o,true);var p=0;var r=t.$("days").get(0);var s=t.$("days").find(".sapUiCalDay");for(var i=0;i<s.length;i++){var $=q(s[i]);if($.attr("data-sap-day")===y){p=i;break;}}if(!t._oItemNavigation){t._oItemNavigation=new I();t._oItemNavigation.attachEvent(I.Events.AfterFocus,b,t);t._oItemNavigation.attachEvent(I.Events.FocusAgain,c,t);t._oItemNavigation.attachEvent(I.Events.BorderReached,t._handleBorderReached,t);t.addDelegate(t._oItemNavigation);if(t._iColumns>1){t._oItemNavigation.setHomeEndColumnMode(true,true);}t._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});t._oItemNavigation.setCycling(false);t._oItemNavigation.setColumns(t._iColumns,true);}t._oItemNavigation.setRootDomRef(r);t._oItemNavigation.setItemDomRefs(s);t._oItemNavigation.setFocusedIndex(p);t._oItemNavigation.setPageSize(s.length);}function b(o){var p=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}var t=this;var O=this._getDate();var F=new U(O.getTime());var r=false;var s=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(s[p]);var u;if($.hasClass("sapUiCalDayOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setUTCDate(1);f(t,F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=s.length-1;i>0;i--){u=q(s[i]);if(!u.hasClass("sapUiCalDayOtherMonth")){F=new U(this._oFormatYyyymmdd.parse(u.attr("data-sap-day"),true).getTime());break;}}f(t,F);}else{r=true;F=new U(this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());if(!F){F=new U(O.getTime());}f(t,O);}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){f(t,F);}else{F=new U(this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());this._setDate(F);}}this.fireFocus({date:a._createLocalDate(F),otherMonth:r});if(E.type=="mousedown"){d(t,E,F,p);}}function c(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var t=this;var F=this._getDate();d(t,E,F,i);}}function d(t,E,F,i){if(E.button){return;}h(t,F,E.shiftKey);k(t);if(t.getIntervalSelection()&&t.$().is(":visible")){t._bindMousemove(true);}E.preventDefault();E.setMark("cancelAutoClose");}function e(t,o,N){if(!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+t);}var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+t);}var u=a._createUniversalUTCDate(o);var F=t.checkDateFocusable(o);t.setProperty("date",o,true);t._oUTCDate=u;if(t.getDomRef()){if(F){if(!N){f(t,t._oUTCDate,true);}}else{g(t,N);}}}function f(t,o,N){if(!N){t.setDate(new Date(o.getTime()));}var y=t._oFormatYyyymmdd.format(o,true);var p=t._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<p.length;i++){$=q(p[i]);if($.attr("data-sap-day")==y){t._oItemNavigation.focusItem(i);break;}}}function g(t,N){var o=t.getRenderer().getStartDate(t);var $=t.$("days");if($.length>0){var r=sap.ui.getCore().createRenderManager();t.getRenderer().renderDays(r,t,o);r.flush($[0]);r.destroy();}t._renderHeader();t.fireEvent("_renderMonth",{days:$.find(".sapUiCalDay").length});_(t);if(!N){t._oItemNavigation.focusItem(t._oItemNavigation.getFocusedIndex());}}function h(t,o,p,r){var s=t.getSelectedDates();var u;var v=t._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=t.getParent();var A=t;var S;if(P&&P.getSelectedDates){A=P;}if(t.getSingleSelection()){if(s.length>0){u=s[0];S=u.getStartDate();if(S){S=a._createUniversalUTCDate(S);}}else{u=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",u,true);}if(t.getIntervalSelection()&&(!u.getEndDate()||r)&&S){var E;if(o.getTime()<S.getTime()){E=S;S=o;if(!r){u.setProperty("startDate",a._createLocalDate(new Date(S.getTime())),true);u.setProperty("endDate",a._createLocalDate(new Date(E.getTime())),true);}}else if(o.getTime()>=S.getTime()){E=o;if(!r){u.setProperty("endDate",a._createLocalDate(new Date(E.getTime())),true);}}j(t,S,E);}else{j(t,o);u.setProperty("startDate",a._createLocalDate(new Date(o.getTime())),true);u.setProperty("endDate",undefined,true);}}else{if(t.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var w=t._checkDateSelected(o);if(w>0){for(i=0;i<s.length;i++){S=s[i].getStartDate();if(S&&o.getTime()==a._createUniversalUTCDate(S).getTime()){A.removeAggregation("selectedDates",i,true);break;}}}else{u=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(o.getTime()))});A.addAggregation("selectedDates",u,true);}y=t._oFormatYyyymmdd.format(o,true);for(i=0;i<v.length;i++){$=q(v[i]);if(!$.hasClass("sapUiCalDayOtherMonth")&&$.attr("data-sap-day")==y){if(w>0){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");}}}}}}function j(t,s,E){var o=t._oItemNavigation.getItemDomRefs();var $;var i=0;if(!E){var y=t._oFormatYyyymmdd.format(s,true);for(i=0;i<o.length;i++){$=q(o[i]);if(!$.hasClass("sapUiCalDayOtherMonth")&&$.attr("data-sap-day")==y){$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");}else if($.hasClass("sapUiCalDaySel")){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalDaySelStart")){$.removeClass("sapUiCalDaySelStart");}else if($.hasClass("sapUiCalDaySelBetween")){$.removeClass("sapUiCalDaySelBetween");}else if($.hasClass("sapUiCalDaySelEnd")){$.removeClass("sapUiCalDaySelEnd");}}}else{var p;for(i=0;i<o.length;i++){$=q(o[i]);p=new U(t._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());if(p.getTime()==s.getTime()){$.addClass("sapUiCalDaySelStart");$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");if(E&&p.getTime()==E.getTime()){$.addClass("sapUiCalDaySelEnd");}$.removeClass("sapUiCalDaySelBetween");}else if(E&&p.getTime()>s.getTime()&&p.getTime()<E.getTime()){$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");$.addClass("sapUiCalDaySelBetween");$.removeClass("sapUiCalDaySelStart");$.removeClass("sapUiCalDaySelEnd");}else if(E&&p.getTime()==E.getTime()){$.addClass("sapUiCalDaySelEnd");$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");$.removeClass("sapUiCalDaySelStart");$.removeClass("sapUiCalDaySelBetween");}else{if($.hasClass("sapUiCalDaySel")){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalDaySelStart")){$.removeClass("sapUiCalDaySelStart");}else if($.hasClass("sapUiCalDaySelBetween")){$.removeClass("sapUiCalDaySelBetween");}else if($.hasClass("sapUiCalDaySelEnd")){$.removeClass("sapUiCalDaySelEnd");}}}}}function k(t){if(t._bMouseMove){t._unbindMousemove(true);}t.fireSelect();}function m(t){if(!t._bNamesLengthChecked){var w;var W=t.$().find(".sapUiCalWH");var T=false;var i=0;for(i=0;i<W.length;i++){w=W[i];if(Math.abs(w.clientWidth-w.scrollWidth)>1){T=true;break;}}if(T){t._bLongWeekDays=false;var o=t._getLocaleData();var s=t._getFirstDayOfWeek();var p=o.getDaysStandAlone("narrow");for(i=0;i<W.length;i++){w=W[i];q(w).text(p[(i+s)%7]);}}else{t._bLongWeekDays=true;}t._bNamesLengthChecked=true;}}function n(t){t._sInvalidateMonth=undefined;g(t,t._bNoFocus);t._bDateRangeChanged=undefined;t._bNoFocus=undefined;}}());return M;},true);
