/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./InputBase','./InstanceManager','./library','sap/ui/core/IconPool','sap/ui/core/theming/Parameters','sap/ui/model/type/Date','sap/ui/thirdparty/mobiscroll/js/mobiscroll-core','sap/ui/thirdparty/mobiscroll/js/mobiscroll-datetime','sap/ui/thirdparty/mobiscroll/js/mobiscroll-scroller'],function(q,I,a,l,b,P,D,m,c,f){"use strict";var g=I.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:sap.m.DateTimeInputType.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"}}}}}});!(function(p,$,d){var o=sap.m.getLocaleData();$.extend(p,{_origin:"value",_super:I.prototype,_types:{Date:{valueFormat:o.getDatePattern("short"),displayFormat:o.getDatePattern("medium")},Time:{valueFormat:o.getTimePattern("short"),displayFormat:o.getTimePattern("short")},DateTime:{valueFormat:o.getDateTimePattern("short"),displayFormat:o.getDateTimePattern("short")}}});if(sap.m.getLocale().getLanguage()!="en"){["valueFormat","displayFormat"].forEach(function(F){var t=p._types.Time;var s=t[F];if(s.indexOf("a")!=-1){t[F]=s.replace(/a+/i,"").replace(/h+/i,"HH").trim();}});}["Time","Date"].forEach(function(t,n){["valueFormat","displayFormat"].forEach(function(F){var T=p._types;T.DateTime[F]=T.DateTime[F].replace("{"+n+"}",T[t][F]);});});}(g.prototype,q,sap.ui.Device));g.prototype.onBeforeRendering=function(){this._destroyCustomPicker();this._super.onBeforeRendering.call(this);if(!this.mProperties.hasOwnProperty("type")){this.setType("Date");}};g.prototype.onAfterRendering=function(){this._super.onAfterRendering.call(this);this._$input.scroller(this._getScrollerConfig());this._showValue();};g.prototype.exit=function(){this._destroyCustomPicker();this._super.exit.call(this);};g.prototype.setWidth=function(w){return this._super.setWidth.call(this,w||"100%");};g.prototype.getWidth=function(){return this.getProperty("width")||"100%";};g.prototype.setValue=function(v){v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v);this._origin="value";this._getFormatFromBinding();return this;};g.prototype.setDateValue=function(v){if(!v||v===this.getDateValue()){return this;}this._isDate(v);this._origin="dateValue";this.setProperty("dateValue",v);if(!this.getDomRef()){this.setProperty("value",sap.ui.core.format.DateFormat.getDateInstance({pattern:this.getValueFormat()}).format(v),true);}return this;};g.prototype.getDateValue=function(){if(this._origin=="dateValue"){return this.getProperty("dateValue");}var v=this.getProperty("value");if(!v){return null;}return sap.ui.core.format.DateFormat.getDateInstance({pattern:this.getValueFormat()}).parse(v);};g.prototype.getDisplayFormat=function(){return this.getProperty("displayFormat")||this._types[this.getType()].displayFormat;};g.prototype.getValueFormat=function(){return this.getProperty("valueFormat")||this._types[this.getType()].valueFormat;};g.prototype.onfocusin=function(){this.$().toggleClass("sapMFocus",true);this._setLabelVisibility();this.openValueStateMessage();};g.prototype._isDate=function(v){if(!sap.m.isDate(v)){throw new Error("Type Error: Expected JavaScript Date Object for property dateValue of "+this);}return true;};g.prototype.onChange=function(e){var d=null,n=this._$input.val(),o=this.getProperty("value");if(n){d=this._$input.scroller("getDate");this.getType()=="Date"&&d.setHours(0,0,0,0);e&&this._reformat&&this._$input.val(sap.ui.core.format.DateFormat.getDateInstance({pattern:this.getDisplayFormat()}).format(d));if(!isNaN(d)){n=sap.ui.core.format.DateFormat.getDateInstance({pattern:this.getValueFormat()}).format(d);}else{n="";d=null;}}if(o==n){return;}this.setProperty("value",n,true);this.setProperty("dateValue",d,true);this._setLabelVisibility();if(e&&e.type!="focus"){this.fireChangeEvent(n,{dateValue:d,newDateValue:d});}};g.prototype._destroyCustomPicker=function(){if(this._$input){this._$input.scroller("hide");this._$input.scroller("destroy");}};g.prototype._setInputValue=function(v){this._$input.val(v);this._setLabelVisibility();this.onChange();};g.prototype._showValue=function(){var d=this.getProperty(this._origin);if(!d){return;}if(this._origin=="value"){d=sap.ui.core.format.DateFormat.getDateInstance({pattern:this.getValueFormat()}).parse(d);if(!d){q.sap.log.error("Format Error: value property "+this.getValue()+" does not match with valueFormat "+this.getValueFormat()+" of "+this);this._setInputValue("");return;}}else{this._isDate(d);}this._$input.scroller("setDate",d,false);this._setInputValue(sap.ui.core.format.DateFormat.getDateInstance({pattern:this.getDisplayFormat()}).format(d));};g.prototype._getFormatFromBinding=function(){var B=this.getBindingInfo("value");if(!B){return;}var o=B.type;if(!o||!(o instanceof D)){return;}var F=o.getOutputPattern();this.setProperty("valueFormat",F,true);this.setProperty("displayFormat",F,true);return F;};g.prototype.ontap=function(e){if(document.activeElement){document.activeElement.blur();}this._$input.scroller("show");e.preventDefault();e.setMarked();};g.prototype.onsaphide=g.prototype.ontap;g.prototype.onsapshow=g.prototype.ontap;(function($,o){var h={},C=sap.ui.getCore(),L=sap.m.getLocale(),s=L.getLanguage(),i=sap.m.getLocaleData(),r=C.getLibraryResourceBundle("sap.m"),_=function(T){return $.sap.encodeHTML(r.getText("MOBISCROLL_"+T));},j="(?=([^']*'[^']*')*[^']*$)",k=$.sap.getModulePath("sap.ui.thirdparty.mobiscroll","/css/"),S={endYear:new Date().getFullYear()+10,lang:s},n={setText:_("SET"),cancelText:_("CANCEL"),monthText:_("MONTH"),dayText:_("DAY"),yearText:_("YEAR"),hourText:_("HOURS"),minuteText:_("MINUTES"),secText:_("SECONDS"),nowText:_("NOW"),dayNames:i.getDaysStandAlone("wide"),dayNamesShort:i.getDaysStandAlone("abbreviated"),monthNames:i.getMonthsStandAlone("wide"),monthNamesShort:i.getMonthsStandAlone("abbreviated")},t=P.get();$.sap.includeStyleSheet(k+"mobiscroll-core.css");h=$("<input>").scroller({}).scroller("getInst").settings;var p=["phone","tablet","desktop"].filter(function(d){return o.system[d];})[0],u=function(d){if(!d){return"";}return d.charAt(0).toUpperCase()+d.substr(1);},v=function(d,e,w){var x=t["sapUiDTICustom"+u(w)+u(d)];if(x){if(e=="bool"){S[d]=(x.toLowerCase()=="true"?true:false);}else if(e=="int"){x=parseInt(x,10);!isNaN(x)&&(S[d]=x);}else{S[d]=x;}}if(!w&&p){v(d,e,p);}};S.mode="mixed";S.display="modal";S.theme="sapMDTICustom";v("mode");v("display");v("rows","int");v("width","int");v("height","int");v("showLabel","bool");v("headerText","bool");if(S.headerText){S.headerText="{value}";}b.insertFontFaceStyle();$.scroller.i18n[s]=$.extend({},n);$.extend(g.prototype,{close:function(){this._$input.scroller("hide");},_setScrollerHeader:function(V){try{var d=this._$input.scroller("getInst").settings,F=!this.getType().indexOf("Date")?d.dateFormat:d.timeFormat,w=$.mobiscroll.parseDate(F,V);return $.sap.encodeHTML(sap.ui.core.format.DateFormat.getDateInstance({pattern:this.getDisplayFormat()}).format(w));}catch(e){return V;}},_autoClose:function(e){var d=this.getDomRef();if(d&&d.contains(e.target)){e.stopPropagation();e.preventDefault();return;}var w=document.querySelector(".sapMDTICustom .dwwr");if(w&&!w.contains(e.target)){this._$input.scroller("hide");}},_restrictMaxWidth:function(d){d[0].querySelector(".dwwr").style.maxWidth=(document.documentElement.clientWidth-22)+"px";},_handleResize:function(e){this._restrictMaxWidth(e.data.$dialog);},_handleBtnKeyDown:function(e){if(e.which===$.sap.KeyCodes.ENTER){if(e.target&&$(e.target.parentElement).hasClass("dwb-c")){this._$input.scroller("cancel");}else{this._$input.scroller("select");}}else if(e.which===$.sap.KeyCodes.ESCAPE){this._$input.scroller("cancel");}else if(e.which===$.sap.KeyCodes.F4){this._$input.scroller("select");}},_getScrollerConfig:function(){var d=this,T=this.getType(),F=this.getDisplayFormat(),A=$.proxy(this._autoClose,this),H=$.proxy(this._handleResize,this),e=$.proxy(this._handleBtnKeyDown,this),w,x,y,z=$("<span class='sapMFirstFE' tabindex='0'/>"),B=$("<span class='sapMLastFE' tabindex='0'/>"),K,E,G=$.extend({},S,{preset:T.toLowerCase(),showOnFocus:false,showOnTap:false,disabled:!d.getEnabled()||!d.getEditable(),onShow:function(J){if(o.browser.msie){if(d._popupIsShown){return;}d._popupIsShown=true;}a.addDialogInstance(d);$(window).on("resize.sapMDTICustom",{$dialog:J},H);$(window).unbind('keydown.dw');J.on('keydown.dw',e);if(S.display=="bubble"){document.addEventListener(o.support.touch?"touchstart":"mousedown",A,true);}if(o.system.desktop){var M=J.find('.dwcc'),N=J.find('.dwbc'),O=M.find(":focusable.dwww");z.insertBefore(M);x=$.proxy(d._getFocusInHandler(N,false),d);z.focusin(x);B.insertAfter(N);w=$.proxy(d._getFocusInHandler(M,true),d);B.focusin(w);$.sap.focus(M.firstFocusableDomRef());y=function(Q){$.sap.focus($(Q.target).parents(".dwww"));};J.click(y);E=J;K=$.proxy(d._getKeyDownHandler(O),d);J.keydown(K);}},onClose:function(){if(o.browser.msie){d._popupIsShown=false;}a.removeDialogInstance(d);$(window).off("resize.sapMDTICustom",H);if(S.display=="bubble"){document.removeEventListener(o.support.touch?"touchstart":"mousedown",A,true);}z.unbind('focusin',x);B.unbind('focusin',w);if(E){E.unbind('keydown',K);E.unbind('keydown.dw',e);E.unbind('click',y);}},onSelect:function(){d.onChange({});},onMarkupReady:function(J,M){d._restrictMaxWidth(J);J.addClass("sapMDTICustom"+d.getType());if(S.headerText!==false){J.addClass("sapMDTICustomHdr");}}});if(T=="Date"){F=this._convertDatePattern(F);$.extend(G,{timeWheels:"",dateFormat:F,dateOrder:this._getLongDatePattern(F.replace(/'.*?'/g,"")).replace(/[^ymd ]/ig,"")});}else if(T=="Time"){F=this._convertTimePattern(F);$.extend(G,{dateOrder:"",timeFormat:F,timeWheels:F.replace(/'.*?'/g,"").replace(/[^hisa]/ig,"")});}else if(T=="DateTime"){F=this._convertDatePattern(this._convertTimePattern(F));$.extend(G,{dateFormat:F,dateOrder:this._getLongDatePattern(F.replace(/'.*?'/g,"")).replace(/[^ymd ]/ig,""),rows:this._getRowForDateTime(),timeWheels:F,timeFormat:"",separator:""});}if(/[^ymdhisa\W]/i.test(F)){this._reformat=true;if(S.headerText!==false){G.headerText=$.proxy(this._setScrollerHeader,this);}}else{this._reformat=false;}return G;},_getRowForDateTime:function(){var d=S.rows||h.rows;if(!d||d<=3){return 3;}return Math.min(window.innerWidth,window.innerHeight)<360?3:d;},_getFocusInHandler:function(d,e){return function(){var E=e?d.firstFocusableDomRef():d.lastFocusableDomRef();$.sap.focus(E);};},_getKeyDownHandler:function(F){return function(e){var K=e.which,d=e.shiftKey,A=e.altKey,w=e.ctrlKey;if(!A&&!d&&!w){switch(K){case $.sap.KeyCodes.ARROW_RIGHT:var x=F.index(document.activeElement),y=F.eq(x+1).length?F.eq(x+1):F.eq(0);y.focus();break;case $.sap.KeyCodes.ARROW_LEFT:var x=F.index(document.activeElement),z=F.eq(x-1).length?F.eq(x-1):F.eq(F.length-1);z.focus();break;case $.sap.KeyCodes.HOME:F[0].focus();break;case $.sap.KeyCodes.END:F[F.length-1].focus();break;default:break;}}else if(A&&!d&&!w){switch(K){case $.sap.KeyCodes.ARROW_UP:case $.sap.KeyCodes.ARROW_DOWN:this._$input.scroller("select");break;default:break;}}};},_rgxYear:new RegExp("y+"+j,"ig"),_rgxMonth:new RegExp("m+"+j,"ig"),_rgxDay:new RegExp("d+"+j,"g"),_rgxMinute:new RegExp("m"+j,"g"),_rgxAmPm:new RegExp("a"+j,"g"),_rgxDayOfWeekLong:new RegExp("EEEE"+j,"g"),_rgxDayOfWeekShort:new RegExp("E+"+j,"g"),_getLongDatePattern:function(d){d=(d||this.getDisplayFormat()).replace(this._rgxYear,"YY");return d.replace(this._rgxMonth,"MM").replace(this._rgxDay,"dd");},_convertTimePattern:function(d){d=d||this.getDisplayFormat();return d.replace(this._rgxMinute,"i").replace(this._rgxAmPm,"A");},_convertDatePattern:function(d){d=d||this.getDisplayFormat();var e=d.indexOf("M"),w=d.lastIndexOf("M"),F=d,N;if(e==-1){e=d.indexOf("L");w=d.lastIndexOf("L");}if(e>-1){switch(w-e){case 0:N="m";break;case 1:N="mm";break;case 2:N="M";break;case 5:N="m";break;default:N="MM";break;}F=d.substring(0,e)+N+d.substring(w+1);}var x;e=F.indexOf("y");if(e>-1){w=F.lastIndexOf("y");if(w-e==1){x="y";}else{x="yy";}F=F.substring(0,e)+x+F.substring(w+1);}var y;e=F.indexOf("D");if(e>-1){w=F.lastIndexOf("D");if(w-e==1){y="o";}else{y="oo";}F=F.substring(0,e)+y+F.substring(w+1);}F=F.replace(this._rgxDayOfWeekLong,"DD").replace(this._rgxDayOfWeekShort,"D");return F;}});})(q,sap.ui.Device);return g;},true);
